/*
 * Decompiled with CFR 0.152.
 */
import com.apple.eawt.Application;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

public class Main {
    private static final String APP_NAME = "Smap Uploader";
    private static final String SAMPLE_SERVER = "xxx.smap.com.au";
    private JFrame frame;
    private JTextArea statusLog;
    private JTextField folderField;
    private JTextField urlField;
    private JTextField userField;
    private JPasswordField passwordField;
    private JTextField identField;
    private JCheckBox encryptField;
    private String filePath = null;
    private String serverName = null;
    private String userName = null;
    private String password = null;
    private String ident = null;
    private boolean encrypted = true;

    public Main() {
        this.initialize();
    }

    public static void main(String[] args) {
        if (System.getProperty("os.name").contains("Mac")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", APP_NAME);
            System.setProperty("com.apple.macos.use-file-dialog-packages", "true");
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Main window = new Main();
                    window.frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void initialize() {
        this.frame = new JFrame(APP_NAME);
        this.frame.setResizable(false);
        this.frame.setBounds(100, 100, 500, 410);
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.frame.setLocationRelativeTo(null);
        ImageIcon mainLogo = new ImageIcon(this.getClass().getResource("main_logo.jpg"));
        Image appLogo = Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("su_logo.png"));
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            Application app = Application.getApplication();
            app.setDockIconImage(appLogo);
        }
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JLabel logo = new JLabel(mainLogo);
        logo.setBounds(380, 225, 100, 130);
        panel.add(logo);
        this.statusLog = new JTextArea();
        this.statusLog.setEditable(false);
        this.statusLog.setFont(new Font("Dialog", 0, 11));
        this.statusLog.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(21, 26, 458, 172);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setViewportView(this.statusLog);
        panel.add(scrollPane);
        JLabel folderLabel = new JLabel("Survey Folder: ");
        folderLabel.setBounds(22, 200, 150, 20);
        this.folderField = new JTextField(100);
        this.folderField.setEditable(false);
        this.folderField.setBounds(160, 200, 150, 20);
        this.folderField.setText("");
        panel.add(folderLabel);
        panel.add(this.folderField);
        JLabel urlLabel = new JLabel("Server Name: ");
        urlLabel.setBounds(22, 225, 150, 20);
        this.urlField = new JTextField(100);
        this.urlField.setBounds(160, 225, 150, 20);
        this.urlField.setText(SAMPLE_SERVER);
        panel.add(urlLabel);
        panel.add(this.urlField);
        JLabel userLabel = new JLabel("User Id: ");
        userLabel.setBounds(22, 250, 150, 20);
        this.userField = new JTextField(100);
        this.userField.setBounds(160, 250, 150, 20);
        panel.add(userLabel);
        panel.add(this.userField);
        JLabel passwordLabel = new JLabel("Password: ");
        passwordLabel.setBounds(22, 275, 150, 20);
        this.passwordField = new JPasswordField(100);
        this.passwordField.setBounds(160, 275, 150, 20);
        panel.add(passwordLabel);
        panel.add(this.passwordField);
        JLabel identLabel = new JLabel("New Ident(Optional): ");
        identLabel.setBounds(22, 300, 150, 20);
        this.identField = new JTextField(100);
        this.identField.setBounds(160, 300, 150, 20);
        panel.add(identLabel);
        panel.add(this.identField);
        JLabel encryptLabel = new JLabel("Encrypt: ");
        encryptLabel.setBounds(22, 325, 150, 20);
        this.encryptField = new JCheckBox("", true);
        this.encryptField.setBounds(160, 325, 150, 20);
        panel.add(encryptLabel);
        panel.add(this.encryptField);
        this.encryptField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    Main.this.encrypted = false;
                } else {
                    Main.this.encrypted = true;
                }
            }
        });
        JButton selectForm = new JButton("Choose");
        selectForm.setBounds(310, 195, 100, 29);
        selectForm.addActionListener(new FileChooser());
        panel.add(selectForm);
        JButton generateCodebook = new JButton("Submit");
        generateCodebook.setBounds(130, 345, 150, 29);
        generateCodebook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.filePath = Main.this.folderField.getText();
                Main.this.serverName = Main.this.urlField.getText();
                Main.this.userName = Main.this.userField.getText();
                Main.this.password = Main.this.passwordField.getText();
                Main.this.ident = Main.this.identField.getText();
                if (Main.this.filePath == null || Main.this.filePath.length() == 0) {
                    Main.this.appendToStatus("Please select a folder first.");
                    return;
                }
                if (Main.this.serverName == null || Main.this.serverName.length() == 0 || Main.this.serverName.equals(Main.SAMPLE_SERVER)) {
                    Main.this.appendToStatus("Please enter a valid server name first.");
                    return;
                }
                if (Main.this.serverName.startsWith("http")) {
                    Main.this.appendToStatus("Only enter the server name, not the protocol.");
                    return;
                }
                if (Main.this.userName == null || Main.this.userName.length() == 0) {
                    Main.this.appendToStatus("Please enter user identifier first.");
                    return;
                }
                if (Main.this.password == null || Main.this.password.length() == 0) {
                    Main.this.appendToStatus("Please enter password first.");
                    return;
                }
                MyTask process = new MyTask(Main.this.filePath);
                process.execute();
            }
        });
        panel.add(generateCodebook);
        this.frame.getContentPane().add((Component)panel, "Center");
    }

    private int processFolder(String instanceFolderPath) throws Exception {
        SubmitResults sr = new SubmitResults();
        String response = null;
        int count = 0;
        if (this.ident != null && this.ident.trim().length() == 0) {
            this.ident = null;
        }
        try {
            File instanceFolder = new File(instanceFolderPath);
            if (!instanceFolder.exists()) {
                this.appendToStatus("Error: Instance folder " + instanceFolderPath + " does not exist");
            } else {
                File[] allFiles = instanceFolder.listFiles();
                ArrayList<File> folders = new ArrayList<File>();
                ArrayList<String> sentFolderNames = new ArrayList<String>();
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        folders.add(f);
                    } else {
                        String fileName = f.getName();
                        if (fileName.endsWith(".sent")) {
                            int idx = fileName.lastIndexOf(".");
                            String folderName = "";
                            if (idx != -1) {
                                folderName = fileName.substring(0, idx);
                            }
                            sentFolderNames.add(folderName);
                        }
                    }
                    ++n2;
                }
                int i = 0;
                while (i < sentFolderNames.size()) {
                    String folderName = (String)sentFolderNames.get(i);
                    int j = folders.size() - 1;
                    while (j >= 0) {
                        File f = (File)folders.get(j);
                        if (folderName.equals(f.getName())) {
                            this.appendToStatus("Not Sent: " + folderName + " has already been sent to a server");
                            folders.remove(j);
                        }
                        --j;
                    }
                    ++i;
                }
                i = 0;
                while (i < folders.size()) {
                    File f = (File)folders.get(i);
                    String filepath = String.valueOf(f.getPath()) + "/" + f.getName() + ".xml";
                    this.appendToStatus("Sending: " + f.getName());
                    if (sr.sendFile(this, this.serverName, filepath, "unknown", this.userName, this.password, this.encrypted, this.ident)) {
                        this.appendToStatus("\tSuccess: sent file: " + f.getName());
                        ++count;
                        String sentFilePath = String.valueOf(instanceFolderPath) + "/" + f.getName() + ".sent";
                        File sentFile = new File(sentFilePath);
                        sentFile.createNewFile();
                    } else {
                        this.appendToStatus("\tError: Failed to send file: " + filepath);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            response = "Error: " + e.getMessage();
            e.printStackTrace();
            this.appendToStatus("        " + response);
        }
        return count;
    }

    public void appendToStatus(String text) {
        this.statusLog.setText(String.valueOf(this.statusLog.getText()) + text + "\n");
    }

    private class FileChooser
    implements ActionListener {
        private FileChooser() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            int rVal = fileChooser.showOpenDialog(Main.this.frame);
            if (rVal == 0) {
                Main.this.statusLog.setText("");
                Main.this.filePath = fileChooser.getSelectedFile().getAbsolutePath();
                Main.this.folderField.setText(Main.this.filePath);
            }
        }
    }

    class MyTask
    extends SwingWorker {
        private final String selected;

        public MyTask(String f) {
            this.selected = f;
        }

        protected Object doInBackground() {
            try {
                Main.this.frame.setCursor(Cursor.getPredefinedCursor(3));
                int count = Main.this.processFolder(this.selected);
                Main.this.frame.setCursor(Cursor.getDefaultCursor());
                Main.this.appendToStatus("Upload Complete " + count + " files sent. ---------------------");
            }
            catch (Exception e) {
                Main.this.appendToStatus("Error: Failed to submit files because " + e.getMessage() + ".");
            }
            return null;
        }
    }
}

