/*
 * Decompiled with CFR 0.152.
 */
package com.nafundi.taskforce.codebook.logic;

import com.nafundi.taskforce.codebook.logic.CodebookEntry;
import com.nafundi.taskforce.codebook.logic.PropertyManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingWorker;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IFunctionHandler;
import org.javarosa.core.model.instance.InstanceInitializationFactory;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.model.xform.XFormsModule;
import org.javarosa.xform.parse.XFormParseException;
import org.javarosa.xform.util.XFormUtils;

public class CodebookEngine
extends SwingWorker<HashMap<String, ArrayList<CodebookEntry>>, String> {
    private final String filepath;

    public CodebookEngine(String filepath) {
        this.filepath = filepath;
    }

    @Override
    public HashMap<String, ArrayList<CodebookEntry>> doInBackground() {
        String[] languages;
        this.publish("\nLoading form...\n");
        new XFormsModule().registerModule();
        org.javarosa.core.services.PropertyManager.setPropertyManager(new PropertyManager(5));
        File xml = new File(this.filepath);
        String errorMsg = "";
        FormDef fd = null;
        try {
            FileInputStream fis = new FileInputStream(xml);
            fd = XFormUtils.getFormFromInputStream(fis);
            if (fd == null) {
                errorMsg = "Error reading XForm file";
            }
        }
        catch (FileNotFoundException e) {
            errorMsg = e.getMessage();
            e.printStackTrace();
        }
        catch (XFormParseException e) {
            errorMsg = e.getMessage();
            e.printStackTrace();
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
            e.printStackTrace();
        }
        if (!"".equals(errorMsg)) {
            this.publishError(errorMsg);
            return null;
        }
        if (fd == null) {
            this.publishError("FormDef is null");
            return null;
        }
        fd.getEvaluationContext().addFunctionHandler(new IFunctionHandler(){

            @Override
            public String getName() {
                return "pulldata";
            }

            @Override
            public List<Class[]> getPrototypes() {
                return new ArrayList<Class[]>();
            }

            @Override
            public boolean rawArgs() {
                return true;
            }

            @Override
            public boolean realTime() {
                return false;
            }

            @Override
            public Object eval(Object[] args, EvaluationContext ec) {
                return args[0];
            }
        });
        fd.initialize(true, new InstanceInitializationFactory());
        HashMap<String, ArrayList<CodebookEntry>> entries = new HashMap<String, ArrayList<CodebookEntry>>();
        if (fd.getLocalizer() == null) {
            fd.setLocalizer(new Localizer());
        }
        String[] stringArray = languages = fd.getLocalizer().getAvailableLocales();
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            this.publish("Processing " + language + " language...");
            fd.getLocalizer().setLocale(language);
            ArrayList<CodebookEntry> entry = new ArrayList<CodebookEntry>();
            this.populateEntries(fd.getInstance().getRoot(), fd, entry);
            entries.put(language, entry);
            ++n2;
        }
        if (languages.length == 0) {
            String defaultLanguage = "Default";
            this.publish("Processing " + defaultLanguage + " language...");
            ArrayList<CodebookEntry> entry = new ArrayList<CodebookEntry>();
            this.populateEntries(fd.getInstance().getRoot(), fd, entry);
            entries.put(defaultLanguage, entry);
        }
        this.publish("");
        return entries;
    }

    private void populateEntries(TreeElement t, FormDef fd, ArrayList<CodebookEntry> entries) {
        Localizer localizer = fd.getLocalizer();
        int i = 0;
        while (i < t.getNumChildren()) {
            TreeElement t1 = t.getChildAt(i);
            CodebookEntry ce = new CodebookEntry();
            String ref = t1.getRef().toString(false);
            ce.setVariable(ref.substring(ref.lastIndexOf("/") + 1));
            QuestionDef qd = FormDef.findQuestionByRef(t1.getRef(), fd);
            if (qd != null) {
                StringBuilder questions = new StringBuilder();
                StringBuilder values = new StringBuilder();
                String questionText = this.getLocalizedLabel(qd.getTextID(), qd.getLabelInnerText(), localizer);
                questions.append(questionText);
                switch (qd.getControlType()) {
                    case 1: {
                        switch (t1.getDataType()) {
                            case 6: {
                                values.append("User selected date and time");
                                break;
                            }
                            case 4: {
                                values.append("User selected date");
                                break;
                            }
                            case 5: {
                                values.append("User selected time");
                                break;
                            }
                            case 3: {
                                values.append("User entered decimal");
                                break;
                            }
                            case 2: {
                                values.append("User entered integer");
                                break;
                            }
                            case 10: {
                                values.append("User captured location coordinates");
                                break;
                            }
                            case 11: {
                                values.append("User captured barcode");
                                break;
                            }
                            case 1: {
                                values.append("User entered text");
                            }
                        }
                        break;
                    }
                    case 10: {
                        values.append("User captured image");
                        break;
                    }
                    case 12: {
                        values.append("User captured audio");
                        break;
                    }
                    case 13: {
                        values.append("User captured video");
                        break;
                    }
                    case 2: 
                    case 3: {
                        List<SelectChoice> choices = qd.getChoices();
                        questions.append("|");
                        for (SelectChoice choice : choices) {
                            values.append(String.valueOf(this.getLocalizedLabel(choice.getTextID(), choice.getLabelInnerText(), localizer)) + "\t" + choice.getValue() + "\n");
                        }
                        break;
                    }
                }
                ce.setQuestion(questions.toString());
                ce.setValue(values.toString());
            } else {
                ce.setQuestion("Hidden from user");
                ce.setValue(this.getValues(t1));
            }
            entries.add(ce);
            if (t1.getNumChildren() > 0) {
                this.populateEntries(t1, fd, entries);
            }
            ++i;
        }
    }

    private String getValues(TreeElement t) {
        String params = t.getPreloadParams();
        if (params == null) {
            return "";
        }
        if ("start".equalsIgnoreCase(params)) {
            return "Timestamp of form open";
        }
        if ("end".equalsIgnoreCase(params)) {
            return "Timestamp of form save";
        }
        if ("today".equalsIgnoreCase(params)) {
            return "Today's date";
        }
        if ("deviceid".equalsIgnoreCase(params) || "uri:deviceid".equalsIgnoreCase(params)) {
            return "Device ID (IMEI, Wi-Fi MAC, Android ID) ";
        }
        if ("subscriberid".equalsIgnoreCase(params) || "uri:subscriberid".equalsIgnoreCase(params)) {
            return "Subscriber ID (IMSI)";
        }
        if ("simserial".equalsIgnoreCase(params) || "uri:simserial".equalsIgnoreCase(params)) {
            return "Serial number of SIM";
        }
        if ("phonenumber".equalsIgnoreCase(params) || "uri:phonenumber".equalsIgnoreCase(params)) {
            return "Phone number of SIM";
        }
        if ("username".equalsIgnoreCase(params) || "uri:username".equalsIgnoreCase(params)) {
            return "Username on device";
        }
        if ("email".equalsIgnoreCase(params) || "uri:email".equalsIgnoreCase(params)) {
            return "Google account on device";
        }
        return "Unknown preloader";
    }

    private String getLocalizedLabel(String textId, String labelText, Localizer l) {
        if (textId == null || textId == "") {
            return labelText;
        }
        String returnText = this.getIText(textId, "long", l);
        if (returnText == null) {
            returnText = this.getIText(textId, null, l);
        }
        return returnText;
    }

    private String getIText(String textID, String form, Localizer localizer) {
        String returnText = null;
        if (textID == null || textID.equals("")) {
            return null;
        }
        if (form != null && !form.equals("")) {
            try {
                returnText = localizer.getRawText(localizer.getLocale(), String.valueOf(textID) + ";" + form);
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            try {
                returnText = localizer.getRawText(localizer.getLocale(), textID);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return returnText;
    }

    private void publishError(String errorMessage) {
        this.publish("Error: Failed to process form because " + errorMessage + ".");
    }
}

