/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.model.FormElementStateListener;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.ItemsetBinding;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.actions.ActionController;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.osm.OSMTag;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionDef
implements IFormElement,
Localizable {
    private static final Logger logger = LoggerFactory.getLogger(QuestionDef.class);
    private int id;
    private IDataReference binding;
    private int controlType;
    private List<OSMTag> osmTags;
    private String appearanceAttr;
    private String helpTextID;
    private String labelInnerText;
    private String helpText;
    private String textID;
    private String helpInnerText;
    private List<TreeElement> additionalAttributes = new ArrayList<TreeElement>(0);
    private List<SelectChoice> choices;
    private ItemsetBinding dynamicChoices;
    List<FormElementStateListener> observers;
    private ActionController actionController;

    public QuestionDef() {
        this(-1, 1);
    }

    public QuestionDef(int id, int controlType) {
        this.setID(id);
        this.setControlType(controlType);
        this.observers = new ArrayList<FormElementStateListener>(0);
        this.actionController = new ActionController();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int id) {
        this.id = id;
    }

    @Override
    public IDataReference getBind() {
        return this.binding;
    }

    public void setBind(IDataReference binding) {
        this.binding = binding;
    }

    public int getControlType() {
        return this.controlType;
    }

    public void setControlType(int controlType) {
        this.controlType = controlType;
    }

    public void setOsmTags(List<OSMTag> tags) {
        this.osmTags = tags;
    }

    public List<OSMTag> getOsmTags() {
        return this.osmTags;
    }

    @Override
    public String getAppearanceAttr() {
        return this.appearanceAttr;
    }

    @Override
    public void setAppearanceAttr(String appearanceAttr) {
        this.appearanceAttr = appearanceAttr;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    @Override
    public void setAdditionalAttribute(String namespace, String name, String value) {
        TreeElement.setAttribute(null, this.additionalAttributes, namespace, name, value);
    }

    @Override
    public String getAdditionalAttribute(String namespace, String name) {
        TreeElement e = TreeElement.getAttribute(this.additionalAttributes, namespace, name);
        if (e != null) {
            return e.getAttributeValue();
        }
        return null;
    }

    @Override
    public List<TreeElement> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    public ActionController getActionController() {
        return this.actionController;
    }

    public String getHelpTextID() {
        return this.helpTextID;
    }

    public void setHelpTextID(String textID) {
        this.helpTextID = textID;
    }

    public void addSelectChoice(SelectChoice choice) {
        if (this.choices == null) {
            this.choices = new ArrayList<SelectChoice>(1);
        }
        choice.setIndex(this.choices.size());
        this.choices.add(choice);
    }

    public void removeSelectChoice(SelectChoice choice) {
        if (this.choices == null) {
            choice.setIndex(0);
            return;
        }
        if (this.choices.contains(choice)) {
            this.choices.remove(choice);
        }
    }

    public List<SelectChoice> getChoices() {
        return this.choices;
    }

    public SelectChoice getChoice(int i) {
        return this.choices.get(i);
    }

    public int getNumChoices() {
        return this.choices != null ? this.choices.size() : 0;
    }

    public SelectChoice getChoiceForValue(String value) {
        for (int i = 0; i < this.getNumChoices(); ++i) {
            if (!this.getChoice(i).getValue().equals(value)) continue;
            return this.getChoice(i);
        }
        return null;
    }

    public ItemsetBinding getDynamicChoices() {
        return this.dynamicChoices;
    }

    public void setDynamicChoices(ItemsetBinding ib) {
        this.dynamicChoices = ib;
    }

    public boolean isComplex() {
        return this.dynamicChoices != null && this.dynamicChoices.copyMode;
    }

    @Override
    public void localeChanged(String locale, Localizer localizer) {
        if (this.choices != null) {
            for (SelectChoice choice : this.choices) {
                choice.localeChanged(null, localizer);
            }
        }
        if (this.dynamicChoices != null) {
            this.dynamicChoices.localeChanged(locale, localizer);
        }
        this.alertStateObservers(2);
    }

    @Override
    public List<IFormElement> getChildren() {
        return null;
    }

    @Override
    public void setChildren(List<IFormElement> v) {
        throw new IllegalStateException("Can't set children on question def");
    }

    @Override
    public void addChild(IFormElement fe) {
        throw new IllegalStateException("Can't add children to question def");
    }

    @Override
    public IFormElement getChild(int i) {
        return null;
    }

    @Override
    public void readExternal(DataInputStream dis, PrototypeFactory pf) throws IOException, DeserializationException {
        try {
            this.setID(ExtUtil.readInt(dis));
            this.binding = (IDataReference)ExtUtil.read(dis, new ExtWrapNullable(new ExtWrapTagged()), pf);
            this.setAppearanceAttr((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
            this.setTextID((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
            this.setLabelInnerText((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
            this.setHelpText((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
            this.setHelpTextID((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
            this.setHelpInnerText((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
            this.setControlType(ExtUtil.readInt(dis));
            this.additionalAttributes = ExtUtil.readAttributes(dis, null);
            this.choices = ExtUtil.nullIfEmpty((List)ExtUtil.read(dis, new ExtWrapList(SelectChoice.class), pf));
            for (int i = 0; i < this.getNumChoices(); ++i) {
                this.choices.get(i).setIndex(i);
            }
            this.setDynamicChoices((ItemsetBinding)ExtUtil.read(dis, new ExtWrapNullable(ItemsetBinding.class)));
            this.actionController = (ActionController)ExtUtil.read(dis, new ExtWrapNullable(ActionController.class), pf);
            this.osmTags = ExtUtil.nullIfEmpty((List)ExtUtil.read(dis, new ExtWrapList(OSMTag.class), pf));
        }
        catch (OutOfMemoryError e) {
            throw new DeserializationException("serialization format change caused misalignment and out-of-memory error");
        }
    }

    @Override
    public void writeExternal(DataOutputStream dos) throws IOException {
        ExtUtil.writeNumeric(dos, this.getID());
        ExtUtil.write(dos, new ExtWrapNullable(this.binding == null ? null : new ExtWrapTagged(this.binding)));
        ExtUtil.write(dos, new ExtWrapNullable(this.getAppearanceAttr()));
        ExtUtil.write(dos, new ExtWrapNullable(this.getTextID()));
        ExtUtil.write(dos, new ExtWrapNullable(this.getLabelInnerText()));
        ExtUtil.write(dos, new ExtWrapNullable(this.getHelpText()));
        ExtUtil.write(dos, new ExtWrapNullable(this.getHelpTextID()));
        ExtUtil.write(dos, new ExtWrapNullable(this.getHelpInnerText()));
        ExtUtil.writeNumeric(dos, this.getControlType());
        ExtUtil.writeAttributes(dos, this.additionalAttributes);
        ExtUtil.write(dos, new ExtWrapList(ExtUtil.emptyIfNull(this.choices)));
        ExtUtil.write(dos, new ExtWrapNullable(this.dynamicChoices));
        ExtUtil.write(dos, new ExtWrapNullable(this.actionController));
        ExtUtil.write(dos, new ExtWrapList(ExtUtil.emptyIfNull(this.osmTags)));
    }

    @Override
    public void registerStateObserver(FormElementStateListener qsl) {
        if (!this.observers.contains(qsl)) {
            this.observers.add(qsl);
        }
    }

    @Override
    public void unregisterStateObserver(FormElementStateListener qsl) {
        this.observers.remove(qsl);
    }

    public void unregisterAll() {
        this.observers.clear();
    }

    public void alertStateObservers(int changeFlags) {
        for (FormElementStateListener observer : this.observers) {
            observer.formElementStateChanged(this, changeFlags);
        }
    }

    @Override
    public int getDeepChildCount() {
        return 1;
    }

    public void setLabelInnerText(String labelInnerText) {
        this.labelInnerText = labelInnerText;
    }

    @Override
    public String getLabelInnerText() {
        return this.labelInnerText;
    }

    public void setHelpInnerText(String helpInnerText) {
        this.helpInnerText = helpInnerText;
    }

    public String getHelpInnerText() {
        return this.helpInnerText;
    }

    @Override
    public String getTextID() {
        return this.textID;
    }

    @Override
    public void setTextID(String textID) {
        if (DateUtils.stringContains(textID, ";")) {
            logger.warn("TextID contains ;form modifier:: \"{}\"... will be stripped.", (Object)textID.substring(textID.indexOf(";")));
            textID = textID.substring(0, textID.indexOf(";"));
        }
        this.textID = textID;
    }
}

