/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.actions;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.actions.Action;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.Recalculate;
import org.javarosa.core.model.data.AnswerDataFactory;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xform.parse.IElementHandler;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xpath.XPathTypeMismatchException;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.kxml2.kdom.Element;

public class SetValueAction
extends Action {
    private TreeReference target;
    private XPathExpression value;
    private String explicitValue;
    public static final String ELEMENT_NAME = "setvalue";

    public SetValueAction() {
    }

    public SetValueAction(TreeReference target, XPathExpression value) {
        super(ELEMENT_NAME);
        this.target = target;
        this.value = value;
    }

    public SetValueAction(TreeReference target, String explicitValue) {
        super(ELEMENT_NAME);
        this.target = target;
        this.explicitValue = explicitValue;
    }

    public static IElementHandler getHandler() {
        return new IElementHandler(){

            @Override
            public void handle(XFormParser p, Element e, Object parent) {
                p.parseSetValueAction(((IFormElement)parent).getActionController(), e);
            }
        };
    }

    @Override
    public TreeReference processAction(FormDef model, TreeReference contextRef) {
        int dataType;
        AbstractTreeElement node;
        TreeReference targetReference;
        TreeReference treeReference = targetReference = contextRef == null ? this.target : this.target.contextualize(contextRef);
        if (contextRef != null && !contextRef.isParentOf(targetReference, false)) {
            return null;
        }
        EvaluationContext context = new EvaluationContext(model.getEvaluationContext(), targetReference);
        String failMessage = "Target of TreeReference " + this.target.toString(true) + " could not be resolved!";
        if (targetReference.hasPredicates()) {
            List<TreeReference> references = context.expandReference(targetReference);
            if (references.size() == 0) {
                if (model.getMainInstance().hasTemplatePath(this.target)) {
                    return null;
                }
                throw new NullPointerException(failMessage);
            }
            if (references.size() > 1) {
                throw new XPathTypeMismatchException("XPath nodeset has more than one node [" + references + "]; Actions can only target a single node reference. Refine path expression to match only one node.");
            }
            targetReference = references.get(0);
        }
        if ((node = context.resolveReference(targetReference)) == null) {
            if (model.getMainInstance().hasTemplatePath(this.target)) {
                return null;
            }
            throw new NullPointerException(failMessage);
        }
        Object result = this.explicitValue != null ? this.explicitValue : XPathFuncExpr.unpack(this.value.eval(model.getMainInstance(), context));
        IAnswerData val = Recalculate.wrapData(result, dataType = node.getDataType());
        if (val == null) {
            model.setValue(null, targetReference, true);
        } else {
            model.setValue(AnswerDataFactory.templateByDataType(dataType).cast(val.uncast()), targetReference, true);
        }
        return targetReference;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.target = (TreeReference)ExtUtil.read(in, TreeReference.class, pf);
        this.explicitValue = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        if (this.explicitValue == null) {
            this.value = (XPathExpression)ExtUtil.read(in, new ExtWrapTagged(), pf);
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, this.target);
        ExtUtil.write(out, ExtUtil.emptyIfNull(this.explicitValue));
        if (this.explicitValue == null) {
            ExtUtil.write(out, new ExtWrapTagged(this.value));
        }
    }
}

