/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class DecimalData
implements IAnswerData {
    private double d;

    public DecimalData() {
    }

    public DecimalData(double d) {
        this.d = d;
    }

    public DecimalData(Double d) {
        this.setValue(d);
    }

    @Override
    public IAnswerData clone() {
        return new DecimalData(this.d);
    }

    @Override
    public String getDisplayText() {
        return String.valueOf(this.d);
    }

    @Override
    public Object getValue() {
        return this.d;
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.d = (Double)o;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        this.d = ExtUtil.readDecimal(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeDecimal(out, this.d);
    }

    @Override
    public UncastData uncast() {
        return new UncastData(this.getValue().toString());
    }

    @Override
    public DecimalData cast(UncastData data) throws IllegalArgumentException {
        try {
            return new DecimalData(Double.parseDouble(data.value));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid cast of data [" + data.value + "] to type Decimal");
        }
    }
}

