/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.InstanceInitializationFactory;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public abstract class DataInstance<T extends AbstractTreeElement<T>>
implements Persistable {
    private int recordid = -1;
    private String name;
    private int formId;
    private String instanceid;

    public DataInstance() {
    }

    public DataInstance(String instanceid) {
        this.instanceid = instanceid;
    }

    public static TreeReference unpackReference(IDataReference ref) {
        return (TreeReference)ref.getReference();
    }

    public abstract AbstractTreeElement<T> getBase();

    public abstract T getRoot();

    public String getInstanceId() {
        return this.instanceid;
    }

    protected void setInstanceId(String instanceid) {
        this.instanceid = instanceid;
    }

    public boolean isRuntimeEvaluated() {
        return false;
    }

    public T resolveReference(TreeReference ref) {
        if (!ref.isAbsolute()) {
            return null;
        }
        AbstractTreeElement<T> node = this.getBase();
        Object result = null;
        for (int i = 0; i < ref.size(); ++i) {
            String name = ref.getName(i);
            int mult = ref.getMultiplicity(i);
            if (mult == -4) {
                result = node.getAttribute(null, name);
                continue;
            }
            if (mult == -1) {
                if (node.getChildMultiplicity(name) == 1) {
                    mult = 0;
                } else {
                    result = null;
                    node = null;
                    break;
                }
            }
            result = node.getChild(name, mult);
            if (node == null) break;
        }
        return node == this.getBase() ? null : result;
    }

    public List<AbstractTreeElement<T>> explodeReference(TreeReference ref) {
        if (!ref.isAbsolute()) {
            return null;
        }
        ArrayList<AbstractTreeElement<T>> nodes = new ArrayList<AbstractTreeElement<T>>(ref.size());
        AbstractTreeElement<T> cur = this.getBase();
        for (int i = 0; i < ref.size(); ++i) {
            String name = ref.getName(i);
            int mult = ref.getMultiplicity(i);
            if (mult == -4) {
                if (cur != this.getBase()) {
                    nodes.add(cur);
                }
                cur = cur.getAttribute(null, name);
                continue;
            }
            if (mult == -1) {
                if (cur.getChildMultiplicity(name) == 1) {
                    mult = 0;
                } else {
                    return null;
                }
            }
            if (cur != this.getBase()) {
                nodes.add(cur);
            }
            if ((cur = cur.getChild(name, mult)) != null) continue;
            return null;
        }
        return nodes;
    }

    public T getTemplate(TreeReference ref) {
        T node = this.getTemplatePath(ref);
        return node == null ? null : (node.isRepeatable() || node.isAttribute() ? node : null);
    }

    public T getTemplatePath(TreeReference ref) {
        if (!ref.isAbsolute()) {
            return null;
        }
        T walker = null;
        AbstractTreeElement<T> node = this.getBase();
        for (int i = 0; i < ref.size(); ++i) {
            String name = ref.getName(i);
            if (ref.getMultiplicity(i) == -4) {
                walker = node.getAttribute(null, name);
                continue;
            }
            T newNode = node.getChild(name, -2);
            if (newNode == null) {
                newNode = node.getChild(name, 0);
            }
            if (newNode == null) {
                return null;
            }
            walker = newNode;
        }
        return walker;
    }

    public boolean hasTemplatePath(TreeReference ref) {
        return ref.isAbsolute() && this.hasTemplatePathRec(ref, this.getBase(), 0);
    }

    private boolean hasTemplatePathRec(TreeReference topRef, AbstractTreeElement<T> currentNode, int depth) {
        if (depth == topRef.size()) {
            return true;
        }
        if (currentNode == null) {
            return false;
        }
        String name = topRef.getName(depth);
        if (topRef.getMultiplicity(depth) == -4) {
            return this.hasTemplatePathRec(topRef, (AbstractTreeElement<T>)currentNode.getAttribute(null, name), depth + 1);
        }
        T nextNode = currentNode.getChild(name, -2);
        if (nextNode != null) {
            return this.hasTemplatePathRec(topRef, (AbstractTreeElement<T>)nextNode, depth + 1);
        }
        List<T> children = currentNode.getChildrenWithName(name);
        for (AbstractTreeElement child : children) {
            if (!this.hasTemplatePathRec(topRef, child, depth + 1)) continue;
            return true;
        }
        return false;
    }

    public T resolveReference(IDataReference binding) {
        return this.resolveReference(DataInstance.unpackReference(binding));
    }

    public void setFormId(int formId) {
        this.formId = formId;
    }

    public int getFormId() {
        return this.formId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        String name = "NULL";
        if (this.name != null) {
            name = this.name;
        }
        return name;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.recordid = ExtUtil.readInt(in);
        this.formId = ExtUtil.readInt(in);
        this.name = (String)ExtUtil.read(in, new ExtWrapNullable(String.class), pf);
        this.instanceid = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.recordid);
        ExtUtil.writeNumeric(out, this.formId);
        ExtUtil.write(out, new ExtWrapNullable(this.name));
        ExtUtil.write(out, ExtUtil.emptyIfNull(this.instanceid));
    }

    @Override
    public int getID() {
        return this.recordid;
    }

    @Override
    public void setID(int recordid) {
        this.recordid = recordid;
    }

    public abstract void initialize(InstanceInitializationFactory var1, String var2);
}

