/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.9
 * Revision: d96a669
 *
 * Copyright (c) 2009-2016 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */

!function(t){t.jqplot.CategoryAxisRenderer=function(e){t.jqplot.LinearAxisRenderer.call(this),this.sortMergedLabels=!1},t.jqplot.CategoryAxisRenderer.prototype=new t.jqplot.LinearAxisRenderer,t.jqplot.CategoryAxisRenderer.prototype.constructor=t.jqplot.CategoryAxisRenderer,t.jqplot.CategoryAxisRenderer.prototype.init=function(e){this.groups=1,this.groupLabels=[],this._groupLabels=[],this._grouped=!1,this._barsPerGroup=null,this.reverse=!1,t.extend(!0,this,{tickOptions:{formatString:"%d"}},e);for(var s=this._dataBounds,i=0;i<this._series.length;i++){var r=this._series[i];r.groups&&(this.groups=r.groups);for(var h=r.data,a=0;a<h.length;a++)"xaxis"==this.name||"x2axis"==this.name?((h[a][0]<s.min||null==s.min)&&(s.min=h[a][0]),(h[a][0]>s.max||null==s.max)&&(s.max=h[a][0])):((h[a][1]<s.min||null==s.min)&&(s.min=h[a][1]),(h[a][1]>s.max||null==s.max)&&(s.max=h[a][1]))}this.groupLabels.length&&(this.groups=this.groupLabels.length)},t.jqplot.CategoryAxisRenderer.prototype.createTicks=function(){var e,s,i,r,h=(this._ticks,this.ticks),a=this.name;this._dataBounds;if(h.length){if(this.groups>1&&!this._grouped){for(var n=h.length,l=parseInt(n/this.groups,10),o=0,r=l;r<n;r+=l)h.splice(r+o,0," "),o++;this._grouped=!0}this.min=.5,this.max=h.length+.5;var p=this.max-this.min;for(this.numberTicks=2*h.length+1,r=0;r<h.length;r++){i=this.min+2*r*p/(this.numberTicks-1);var u=new this.tickRenderer(this.tickOptions);u.showLabel=!1,u.setTick(i,this.name),this._ticks.push(u);var u=new this.tickRenderer(this.tickOptions);u.label=h[r],u.showMark=!1,u.showGridline=!1,u.setTick(i+.5,this.name),this._ticks.push(u)}var u=new this.tickRenderer(this.tickOptions);u.showLabel=!1,u.setTick(i+1,this.name),this._ticks.push(u)}else{e="xaxis"==a||"x2axis"==a?this._plotDimensions.width:this._plotDimensions.height,null!=this.min&&null!=this.max&&null!=this.numberTicks&&(this.tickInterval=null),null!=this.min&&null!=this.max&&null!=this.tickInterval&&parseInt((this.max-this.min)/this.tickInterval,10)!=(this.max-this.min)/this.tickInterval&&(this.tickInterval=null);for(var s,_,c=[],m=0,x=!1,r=0;r<this._series.length;r++)for(var g=this._series[r],d=0;d<g.data.length;d++)_="xaxis"==this.name||"x2axis"==this.name?g.data[d][0]:g.data[d][1],-1==t.inArray(_,c)&&(x=!0,m+=1,c.push(_));x&&this.sortMergedLabels&&("string"==typeof c[0]?c.sort():c.sort(function(t,e){return t-e})),this.ticks=c;for(var r=0;r<this._series.length;r++)for(var g=this._series[r],d=0;d<g.data.length;d++){_="xaxis"==this.name||"x2axis"==this.name?g.data[d][0]:g.data[d][1];var b=t.inArray(_,c)+1;"xaxis"==this.name||"x2axis"==this.name?g.data[d][0]=b:g.data[d][1]=b}if(this.groups>1&&!this._grouped){for(var n=c.length,l=parseInt(n/this.groups,10),o=0,r=l;r<n;r+=l+1)c[r]=" ";this._grouped=!0}s=m+.5,null==this.numberTicks&&(this.numberTicks=2*m+1);var p=s-.5;this.min=.5,this.max=s;var f=0,k=parseInt(3+e/10,10),l=parseInt(m/k,10);null==this.tickInterval&&(this.tickInterval=p/(this.numberTicks-1));for(var r=0;r<this.numberTicks;r++){i=this.min+r*this.tickInterval;var u=new this.tickRenderer(this.tickOptions);r/2==parseInt(r/2,10)?(u.showLabel=!1,u.showMark=!0):(l>0&&f<l?(u.showLabel=!1,f+=1):(u.showLabel=!0,f=0),u.label=u.formatter(u.formatString,c[(r-1)/2]),u.showMark=!1,u.showGridline=!1),u.setTick(i,this.name),this._ticks.push(u)}}},t.jqplot.CategoryAxisRenderer.prototype.draw=function(e,s){if(this.show){this.renderer.createTicks.call(this);if(this._elem&&this._elem.emptyForce(),this._elem=this._elem||t('<div class="jqplot-axis jqplot-'+this.name+'" style="position:absolute;"></div>'),"xaxis"==this.name||"x2axis"==this.name?this._elem.width(this._plotDimensions.width):this._elem.height(this._plotDimensions.height),this.labelOptions.axis=this.name,this._label=new this.labelRenderer(this.labelOptions),this._label.show){var i=this._label.draw(e,s);i.appendTo(this._elem)}for(var r=this._ticks,h=0;h<r.length;h++){var a=r[h];if(a.showLabel&&(!a.isMinorTick||this.showMinorTicks)){var i=a.draw(e,s);i.appendTo(this._elem)}}this._groupLabels=[];for(var h=0;h<this.groupLabels.length;h++){var i=t('<div style="position:absolute;" class="jqplot-'+this.name+'-groupLabel"></div>');i.html(this.groupLabels[h]),this._groupLabels.push(i),i.appendTo(this._elem)}}return this._elem},t.jqplot.CategoryAxisRenderer.prototype.set=function(){var e,s=0,i=0,r=0,h=null!=this._label&&this._label.show;if(this.show){for(var a=this._ticks,n=0;n<a.length;n++){var l=a[n];!l.showLabel||l.isMinorTick&&!this.showMinorTicks||(e="xaxis"==this.name||"x2axis"==this.name?l._elem.outerHeight(!0):l._elem.outerWidth(!0))>s&&(s=e)}for(var o=0,n=0;n<this._groupLabels.length;n++){var p=this._groupLabels[n];e="xaxis"==this.name||"x2axis"==this.name?p.outerHeight(!0):p.outerWidth(!0),e>o&&(o=e)}h&&(i=this._label._elem.outerWidth(!0),r=this._label._elem.outerHeight(!0)),"xaxis"==this.name?(s+=o+r,this._elem.css({height:s+"px",left:"0px",bottom:"0px"})):"x2axis"==this.name?(s+=o+r,this._elem.css({height:s+"px",left:"0px",top:"0px"})):"yaxis"==this.name?(s+=o+i,this._elem.css({width:s+"px",left:"0px",top:"0px"}),h&&this._label.constructor==t.jqplot.AxisLabelRenderer&&this._label._elem.css("width",i+"px")):(s+=o+i,this._elem.css({width:s+"px",right:"0px",top:"0px"}),h&&this._label.constructor==t.jqplot.AxisLabelRenderer&&this._label._elem.css("width",i+"px"))}},t.jqplot.CategoryAxisRenderer.prototype.pack=function(e,s){var i,r=this._ticks,h=this.max,a=this.min,n=s.max,l=s.min,o=null!=this._label&&this._label.show;for(var p in e)this._elem.css(p,e[p]);this._offsets=s;var u=n-l,_=h-a;if(this.reverse?(this.u2p=function(t){return l+(h-t)*u/_},this.p2u=function(t){return a+(t-l)*_/u},"xaxis"==this.name||"x2axis"==this.name?(this.series_u2p=function(t){return(h-t)*u/_},this.series_p2u=function(t){return t*_/u+h}):(this.series_u2p=function(t){return(a-t)*u/_},this.series_p2u=function(t){return t*_/u+a})):(this.u2p=function(t){return(t-a)*u/_+l},this.p2u=function(t){return(t-l)*_/u+a},"xaxis"==this.name||"x2axis"==this.name?(this.series_u2p=function(t){return(t-a)*u/_},this.series_p2u=function(t){return t*_/u+a}):(this.series_u2p=function(t){return(t-h)*u/_},this.series_p2u=function(t){return t*_/u+h})),this.show)if("xaxis"==this.name||"x2axis"==this.name){for(i=0;i<r.length;i++){var c=r[i];if(c.show&&c.showLabel){var m;if(c.constructor==t.jqplot.CanvasAxisTickRenderer&&c.angle){var x="xaxis"==this.name?1:-1;switch(c.labelPosition){case"auto":m=x*c.angle<0?-c.getWidth()+c._textRenderer.height*Math.sin(-c._textRenderer.angle)/2:-c._textRenderer.height*Math.sin(c._textRenderer.angle)/2;break;case"end":m=-c.getWidth()+c._textRenderer.height*Math.sin(-c._textRenderer.angle)/2;break;case"start":m=-c._textRenderer.height*Math.sin(c._textRenderer.angle)/2;break;case"middle":default:m=-c.getWidth()/2+c._textRenderer.height*Math.sin(-c._textRenderer.angle)/2}}else m=-c.getWidth()/2;var g=this.u2p(c.value)+m+"px";c._elem.css("left",g),c.pack()}}var d=["bottom",0];if(o){var b=this._label._elem.outerWidth(!0);this._label._elem.css("left",l+u/2-b/2+"px"),"xaxis"==this.name?(this._label._elem.css("bottom","0px"),d=["bottom",this._label._elem.outerHeight(!0)]):(this._label._elem.css("top","0px"),d=["top",this._label._elem.outerHeight(!0)]),this._label.pack()}var f=parseInt(this._ticks.length/this.groups,10)+1;for(i=0;i<this._groupLabels.length;i++){for(var k=0,v=0,w=i*f;w<(i+1)*f;w++)if(!(w>=this._ticks.length-1)&&this._ticks[w]._elem&&" "!=this._ticks[w].label){var c=this._ticks[w]._elem,p=c.position();k+=p.left+c.outerWidth(!0)/2,v++}k/=v,this._groupLabels[i].css({left:k-this._groupLabels[i].outerWidth(!0)/2}),this._groupLabels[i].css(d[0],d[1])}}else{for(i=0;i<r.length;i++){var c=r[i];if(c.show&&c.showLabel){var m;if(c.constructor==t.jqplot.CanvasAxisTickRenderer&&c.angle){var x="yaxis"==this.name?1:-1;switch(c.labelPosition){case"auto":case"end":m=x*c.angle<0?-c._textRenderer.height*Math.cos(-c._textRenderer.angle)/2:-c.getHeight()+c._textRenderer.height*Math.cos(c._textRenderer.angle)/2;break;case"start":m=c.angle>0?-c._textRenderer.height*Math.cos(-c._textRenderer.angle)/2:-c.getHeight()+c._textRenderer.height*Math.cos(c._textRenderer.angle)/2;break;case"middle":default:m=-c.getHeight()/2}}else m=-c.getHeight()/2;var g=this.u2p(c.value)+m+"px";c._elem.css("top",g),c.pack()}}var d=["left",0];if(o){var R=this._label._elem.outerHeight(!0);this._label._elem.css("top",n-u/2-R/2+"px"),"yaxis"==this.name?(this._label._elem.css("left","0px"),d=["left",this._label._elem.outerWidth(!0)]):(this._label._elem.css("right","0px"),d=["right",this._label._elem.outerWidth(!0)]),this._label.pack()}var f=parseInt(this._ticks.length/this.groups,10)+1;for(i=0;i<this._groupLabels.length;i++){for(var k=0,v=0,w=i*f;w<(i+1)*f;w++)if(!(w>=this._ticks.length-1)&&this._ticks[w]._elem&&" "!=this._ticks[w].label){var c=this._ticks[w]._elem,p=c.position();k+=p.top+c.outerHeight()/2,v++}k/=v,this._groupLabels[i].css({top:k-this._groupLabels[i].outerHeight()/2}),this._groupLabels[i].css(d[0],d[1])}}}}(jQuery);