/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.9
 * Revision: d96a669
 *
 * Copyright (c) 2009-2016 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */

!function(t){t.jqplot.LogAxisRenderer=function(){t.jqplot.LinearAxisRenderer.call(this),this.axisDefaults={base:10,tickDistribution:"power"}},t.jqplot.LogAxisRenderer.prototype=new t.jqplot.LinearAxisRenderer,t.jqplot.LogAxisRenderer.prototype.constructor=t.jqplot.LogAxisRenderer,t.jqplot.LogAxisRenderer.prototype.init=function(e){this.drawBaseline=!0,this.minorTicks="auto",this._scalefact=1,t.extend(!0,this,e),this._autoFormatString="%d",this._overrideFormatString=!1;for(var i in this.renderer.axisDefaults)null==this[i]&&(this[i]=this.renderer.axisDefaults[i]);this.resetDataBounds()},t.jqplot.LogAxisRenderer.prototype.createTicks=function(e){var i,s,a,r,h,n=(this._ticks,this.ticks),o=(this.name,this._dataBounds),l="x"===this.name.charAt(0)?this._plotDimensions.width:this._plotDimensions.height;if(this._scalefact=(Math.max(l,31)-30)/300,n.length){for(h=0;h<n.length;h++){var c=n[h],u=new this.tickRenderer(this.tickOptions);c.constructor==Array?(u.value=c[0],u.label=c[1],this.showTicks?this.showTickMarks||(u.showMark=!1):(u.showLabel=!1,u.showMark=!1),u.setTick(c[0],this.name),this._ticks.push(u)):t.isPlainObject(c)?(t.extend(!0,u,c),u.axis=this.name,this._ticks.push(u)):(u.value=c,this.showTicks?this.showTickMarks||(u.showMark=!1):(u.showLabel=!1,u.showMark=!1),u.setTick(c,this.name),this._ticks.push(u))}this.numberTicks=n.length,this.min=this._ticks[0].value,this.max=this._ticks[this.numberTicks-1].value}else if(null==this.min&&null==this.max){if(s=o.min*(2-this.padMin),a=o.max*this.padMax,s==a){s*=.95,a*=1.05}if(null!=this.min&&this.min<=0)throw new Error("Log axis minimum must be greater than 0");if(null!=this.max&&this.max<=0)throw new Error("Log axis maximum must be greater than 0");var m,g;m=Math.pow(this.base,Math.floor(Math.log(s)/Math.log(this.base))),g=Math.pow(this.base,Math.ceil(Math.log(a)/Math.log(this.base))),0===m&&(m=1);var k=Math.round(Math.log(m)/Math.LN10);null!=this.tickOptions&&this.tickOptions.formatString||(this._overrideFormatString=!0),this.min=m,this.max=g;var _,x=(this.max,this.min,"auto"===this.minorTicks?0:this.minorTicks);if(null==this.numberTicks)if(l>140){if(_=Math.round(Math.log(this.max/this.min)/Math.log(this.base)+1),_<2&&(_=2),0===x){var d=l/(_-1);x=d<100?0:d<190?1:d<250?3:d<600?4:9}}else _=2,0===x&&(x=1),x=0;else _=this.numberTicks;if(k>=0&&3!==x)this._autoFormatString="%d";else if(k<=0&&3===x){var d=-(k-1);this._autoFormatString="%."+Math.abs(k-1)+"f"}else if(k<0){var d=-k;this._autoFormatString="%."+Math.abs(k)+"f"}else this._autoFormatString="%d";for(var u,p,f,i,h=0;h<_;h++)if(r=Math.pow(this.base,h-_+1)*this.max,u=new this.tickRenderer(this.tickOptions),this._overrideFormatString&&(u.formatString=this._autoFormatString),this.showTicks?this.showTickMarks||(u.showMark=!1):(u.showLabel=!1,u.showMark=!1),u.setTick(r,this.name),this._ticks.push(u),x&&h<_-1){f=Math.pow(this.base,h-_+2)*this.max,f-r,i=f/(x+1);for(var w=x-1;w>=0;w--)p=f-i*(w+1),u=new this.tickRenderer(this.tickOptions),this._overrideFormatString&&""!=this._autoFormatString&&(u.formatString=this._autoFormatString),this.showTicks?this.showTickMarks||(u.showMark=!1):(u.showLabel=!1,u.showMark=!1),u.setTick(p,this.name),this._ticks.push(u)}}else if(null!=this.min&&null!=this.max){var M,b,v=t.extend(!0,{},this.tickOptions,{name:this.name,value:null});if(null==this.numberTicks&&null==this.tickInterval){var R=Math.max(l,31),T=Math.ceil((R-30)/35+1),S=t.jqplot.LinearTickGenerator.bestConstrainedInterval(this.min,this.max,T);this._autoFormatString=S[3],M=S[2],b=S[4];for(var h=0;h<M;h++)v.value=this.min+h*b,u=new this.tickRenderer(v),this._overrideFormatString&&""!=this._autoFormatString&&(u.formatString=this._autoFormatString),this.showTicks?this.showTickMarks||(u.showMark=!1):(u.showLabel=!1,u.showMark=!1),this._ticks.push(u)}else if(null!=this.numberTicks&&null!=this.tickInterval){M=this.numberTicks;for(var h=0;h<M;h++)v.value=this.min+h*this.tickInterval,u=new this.tickRenderer(v),this._overrideFormatString&&""!=this._autoFormatString&&(u.formatString=this._autoFormatString),this.showTicks?this.showTickMarks||(u.showMark=!1):(u.showLabel=!1,u.showMark=!1),this._ticks.push(u)}}},t.jqplot.LogAxisRenderer.prototype.pack=function(e,i){var s=parseInt(this.base,10),a=this._ticks,r=function(t){return Math.log(t)/Math.log(s)},h=function(t){return Math.pow(Math.E,Math.log(s)*t)},n=r(this.max),o=r(this.min),l=i.max,c=i.min,u=null!=this._label&&this._label.show;for(var m in e)this._elem.css(m,e[m]);this._offsets=i;var g=l-c,k=n-o;if(this.p2u=function(t){return h((t-c)*k/g+o)},this.u2p=function(t){return(r(t)-o)*g/k+c},"xaxis"==this.name||"x2axis"==this.name?(this.series_u2p=function(t){return(r(t)-o)*g/k},this.series_p2u=function(t){return h(t*k/g+o)}):(this.series_u2p=function(t){return(r(t)-n)*g/k},this.series_p2u=function(t){return h(t*k/g+n)}),this.show)if("xaxis"==this.name||"x2axis"==this.name){for(var _=0;_<a.length;_++){var x=a[_];if(x.show&&x.showLabel){var d;if(x.constructor==t.jqplot.CanvasAxisTickRenderer&&x.angle)switch(x.labelPosition){case"auto":d=x.angle<0?-x.getWidth()+x._textRenderer.height*Math.sin(-x._textRenderer.angle)/2:-x._textRenderer.height*Math.sin(x._textRenderer.angle)/2;break;case"end":d=-x.getWidth()+x._textRenderer.height*Math.sin(-x._textRenderer.angle)/2;break;case"start":d=-x._textRenderer.height*Math.sin(x._textRenderer.angle)/2;break;case"middle":default:d=-x.getWidth()/2+x._textRenderer.height*Math.sin(-x._textRenderer.angle)/2}else d=-x.getWidth()/2;var p=this.u2p(x.value)+d+"px";x._elem.css("left",p),x.pack()}}if(u){var f=this._label._elem.outerWidth(!0);this._label._elem.css("left",c+g/2-f/2+"px"),"xaxis"==this.name?this._label._elem.css("bottom","0px"):this._label._elem.css("top","0px"),this._label.pack()}}else{for(var _=0;_<a.length;_++){var x=a[_];if(x.show&&x.showLabel){var d;if(x.constructor==t.jqplot.CanvasAxisTickRenderer&&x.angle)switch(x.labelPosition){case"auto":case"end":d=x.angle<0?-x._textRenderer.height*Math.cos(-x._textRenderer.angle)/2:-x.getHeight()+x._textRenderer.height*Math.cos(x._textRenderer.angle)/2;break;case"start":d=x.angle>0?-x._textRenderer.height*Math.cos(-x._textRenderer.angle)/2:-x.getHeight()+x._textRenderer.height*Math.cos(x._textRenderer.angle)/2;break;case"middle":default:d=-x.getHeight()/2}else d=-x.getHeight()/2;var p=this.u2p(x.value)+d+"px";x._elem.css("top",p),x.pack()}}if(u){var w=this._label._elem.outerHeight(!0);this._label._elem.css("top",l-g/2-w/2+"px"),"yaxis"==this.name?this._label._elem.css("left","0px"):this._label._elem.css("right","0px"),this._label.pack()}}}}(jQuery);