-- 
-- Apply upgrade patches to survey definitions database
--

-- Upgrade to:  13.08 from 13.07 =======
-- None
-- Upgrade to:  13.09 from 13.08 =======
-- None

-- Upgrade to:  13.10 from 13.09 =======
CREATE SEQUENCE change_history_seq START 1;
ALTER SEQUENCE change_history_seq OWNER TO ws;

-- Upgrade to:  13.11 from 13.10 =======
CREATE SEQUENCE changeset_seq START 1;
ALTER SEQUENCE changeset_seq OWNER TO ws;

CREATE TABLE changeset (
	id INTEGER DEFAULT NEXTVAL('changeset_seq') CONSTRAINT pk_changeset PRIMARY KEY,
	s_id INTEGER,
  	user_name text,		/* User making change */
  	change_reason text,
  	description text,
  	reversed boolean default false,
  	reversed_by_user text,
	changed_ts TIMESTAMP WITH TIME ZONE
	);
ALTER TABLE changeset OWNER TO ws;

CREATE TABLE change_history (
	id INTEGER DEFAULT NEXTVAL('change_history_seq') CONSTRAINT pk_change_history PRIMARY KEY,
	c_id INTEGER REFERENCES changeset(id) ON DELETE CASCADE,		/* Changeset Id */
  	q_id INTEGER,
  	r_id INTEGER,
  	oname text,
  	old_value text,
  	new_value text,
  	qname text,
  	qtype text,
  	tablename text
	);
ALTER TABLE change_history OWNER TO ws;

-- Upgrade to:  15.11 from 15.10 =======
alter table change_history add column question_column_name text;
alter table change_history add column option_column_name text;

--Upgrade to: 16.07 from 16.06 ===========
CREATE EXTENSION fuzzystrmatch;

-- Upgrade to: 17.11 ============
CREATE SEQUENCE sync_seq START 1;
ALTER SEQUENCE sync_seq OWNER TO ws;

create TABLE sync (
	id INTEGER DEFAULT NEXTVAL('sync_seq') CONSTRAINT pk_sync PRIMARY KEY,
	s_id integer,
	n_id integer,
	prikey integer				-- Primary key of synchronised record
	);
ALTER TABLE sync OWNER TO ws;

CREATE SEQUENCE cat_seq START 1;
ALTER SEQUENCE cat_seq OWNER TO ws;

CREATE TABLE case_alert_triggered (
	id integer DEFAULT NEXTVAL('cat_seq') CONSTRAINT pk_cat PRIMARY KEY,
	a_id integer,
	table_name text,
	thread text,
	final_status text,
	alert_sent TIMESTAMP WITH TIME ZONE	
	);
ALTER TABLE case_alert_triggered OWNER TO ws;

CREATE SEQUENCE sct_seq START 1;
ALTER SEQUENCE sct_seq OWNER TO ws;

CREATE TABLE server_calc_triggered (
	id integer DEFAULT NEXTVAL('sct_seq') CONSTRAINT pk_sct PRIMARY KEY,
	n_id integer,	
	table_name text,
	question_name text,
	value text,
	thread text,
	updated_value boolean,	  -- the value of the updated flag when this event was triggered
	notification_sent TIMESTAMP WITH TIME ZONE	
	);
ALTER TABLE server_calc_triggered OWNER TO ws;
