(function () {
	'use strict';

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function commonjsRequire () {
		throw new Error('Dynamic requires are not currently supported by rollup-plugin-commonjs');
	}

	function unwrapExports (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	function getCjsExportFromNamespace (n) {
		return n && n['default'] || n;
	}

	var jquery = createCommonjsModule(function (module) {
	/*!
	 * jQuery JavaScript Library v3.7.1
	 * https://jquery.com/
	 *
	 * Copyright OpenJS Foundation and other contributors
	 * Released under the MIT license
	 * https://jquery.org/license
	 *
	 * Date: 2023-08-28T13:37Z
	 */
	( function( global, factory ) {

		{

			// For CommonJS and CommonJS-like environments where a proper `window`
			// is present, execute the factory and get jQuery.
			// For environments that do not have a `window` with a `document`
			// (such as Node.js), expose a factory as module.exports.
			// This accentuates the need for the creation of a real `window`.
			// e.g. var jQuery = require("jquery")(window);
			// See ticket trac-14549 for more info.
			module.exports = global.document ?
				factory( global, true ) :
				function( w ) {
					if ( !w.document ) {
						throw new Error( "jQuery requires a window with a document" );
					}
					return factory( w );
				};
		}

	// Pass this if window is not defined yet
	} )( typeof window !== "undefined" ? window : commonjsGlobal, function( window, noGlobal ) {

	var arr = [];

	var getProto = Object.getPrototypeOf;

	var slice = arr.slice;

	var flat = arr.flat ? function( array ) {
		return arr.flat.call( array );
	} : function( array ) {
		return arr.concat.apply( [], array );
	};


	var push = arr.push;

	var indexOf = arr.indexOf;

	var class2type = {};

	var toString = class2type.toString;

	var hasOwn = class2type.hasOwnProperty;

	var fnToString = hasOwn.toString;

	var ObjectFunctionString = fnToString.call( Object );

	var support = {};

	var isFunction = function isFunction( obj ) {

			// Support: Chrome <=57, Firefox <=52
			// In some browsers, typeof returns "function" for HTML <object> elements
			// (i.e., `typeof document.createElement( "object" ) === "function"`).
			// We don't want to classify *any* DOM node as a function.
			// Support: QtWeb <=3.8.5, WebKit <=534.34, wkhtmltopdf tool <=0.12.5
			// Plus for old WebKit, typeof returns "function" for HTML collections
			// (e.g., `typeof document.getElementsByTagName("div") === "function"`). (gh-4756)
			return typeof obj === "function" && typeof obj.nodeType !== "number" &&
				typeof obj.item !== "function";
		};


	var isWindow = function isWindow( obj ) {
			return obj != null && obj === obj.window;
		};


	var document = window.document;



		var preservedScriptAttributes = {
			type: true,
			src: true,
			nonce: true,
			noModule: true
		};

		function DOMEval( code, node, doc ) {
			doc = doc || document;

			var i, val,
				script = doc.createElement( "script" );

			script.text = code;
			if ( node ) {
				for ( i in preservedScriptAttributes ) {

					// Support: Firefox 64+, Edge 18+
					// Some browsers don't support the "nonce" property on scripts.
					// On the other hand, just using `getAttribute` is not enough as
					// the `nonce` attribute is reset to an empty string whenever it
					// becomes browsing-context connected.
					// See https://github.com/whatwg/html/issues/2369
					// See https://html.spec.whatwg.org/#nonce-attributes
					// The `node.getAttribute` check was added for the sake of
					// `jQuery.globalEval` so that it can fake a nonce-containing node
					// via an object.
					val = node[ i ] || node.getAttribute && node.getAttribute( i );
					if ( val ) {
						script.setAttribute( i, val );
					}
				}
			}
			doc.head.appendChild( script ).parentNode.removeChild( script );
		}


	function toType( obj ) {
		if ( obj == null ) {
			return obj + "";
		}

		// Support: Android <=2.3 only (functionish RegExp)
		return typeof obj === "object" || typeof obj === "function" ?
			class2type[ toString.call( obj ) ] || "object" :
			typeof obj;
	}
	/* global Symbol */
	// Defining this global in .eslintrc.json would create a danger of using the global
	// unguarded in another place, it seems safer to define global only for this module



	var version = "3.7.1",

		rhtmlSuffix = /HTML$/i,

		// Define a local copy of jQuery
		jQuery = function( selector, context ) {

			// The jQuery object is actually just the init constructor 'enhanced'
			// Need init if jQuery is called (just allow error to be thrown if not included)
			return new jQuery.fn.init( selector, context );
		};

	jQuery.fn = jQuery.prototype = {

		// The current version of jQuery being used
		jquery: version,

		constructor: jQuery,

		// The default length of a jQuery object is 0
		length: 0,

		toArray: function() {
			return slice.call( this );
		},

		// Get the Nth element in the matched element set OR
		// Get the whole matched element set as a clean array
		get: function( num ) {

			// Return all the elements in a clean array
			if ( num == null ) {
				return slice.call( this );
			}

			// Return just the one element from the set
			return num < 0 ? this[ num + this.length ] : this[ num ];
		},

		// Take an array of elements and push it onto the stack
		// (returning the new matched element set)
		pushStack: function( elems ) {

			// Build a new jQuery matched element set
			var ret = jQuery.merge( this.constructor(), elems );

			// Add the old object onto the stack (as a reference)
			ret.prevObject = this;

			// Return the newly-formed element set
			return ret;
		},

		// Execute a callback for every element in the matched set.
		each: function( callback ) {
			return jQuery.each( this, callback );
		},

		map: function( callback ) {
			return this.pushStack( jQuery.map( this, function( elem, i ) {
				return callback.call( elem, i, elem );
			} ) );
		},

		slice: function() {
			return this.pushStack( slice.apply( this, arguments ) );
		},

		first: function() {
			return this.eq( 0 );
		},

		last: function() {
			return this.eq( -1 );
		},

		even: function() {
			return this.pushStack( jQuery.grep( this, function( _elem, i ) {
				return ( i + 1 ) % 2;
			} ) );
		},

		odd: function() {
			return this.pushStack( jQuery.grep( this, function( _elem, i ) {
				return i % 2;
			} ) );
		},

		eq: function( i ) {
			var len = this.length,
				j = +i + ( i < 0 ? len : 0 );
			return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
		},

		end: function() {
			return this.prevObject || this.constructor();
		},

		// For internal use only.
		// Behaves like an Array's method, not like a jQuery method.
		push: push,
		sort: arr.sort,
		splice: arr.splice
	};

	jQuery.extend = jQuery.fn.extend = function() {
		var options, name, src, copy, copyIsArray, clone,
			target = arguments[ 0 ] || {},
			i = 1,
			length = arguments.length,
			deep = false;

		// Handle a deep copy situation
		if ( typeof target === "boolean" ) {
			deep = target;

			// Skip the boolean and the target
			target = arguments[ i ] || {};
			i++;
		}

		// Handle case when target is a string or something (possible in deep copy)
		if ( typeof target !== "object" && !isFunction( target ) ) {
			target = {};
		}

		// Extend jQuery itself if only one argument is passed
		if ( i === length ) {
			target = this;
			i--;
		}

		for ( ; i < length; i++ ) {

			// Only deal with non-null/undefined values
			if ( ( options = arguments[ i ] ) != null ) {

				// Extend the base object
				for ( name in options ) {
					copy = options[ name ];

					// Prevent Object.prototype pollution
					// Prevent never-ending loop
					if ( name === "__proto__" || target === copy ) {
						continue;
					}

					// Recurse if we're merging plain objects or arrays
					if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
						( copyIsArray = Array.isArray( copy ) ) ) ) {
						src = target[ name ];

						// Ensure proper type for the source value
						if ( copyIsArray && !Array.isArray( src ) ) {
							clone = [];
						} else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {
							clone = {};
						} else {
							clone = src;
						}
						copyIsArray = false;

						// Never move original objects, clone them
						target[ name ] = jQuery.extend( deep, clone, copy );

					// Don't bring in undefined values
					} else if ( copy !== undefined ) {
						target[ name ] = copy;
					}
				}
			}
		}

		// Return the modified object
		return target;
	};

	jQuery.extend( {

		// Unique for each copy of jQuery on the page
		expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

		// Assume jQuery is ready without the ready module
		isReady: true,

		error: function( msg ) {
			throw new Error( msg );
		},

		noop: function() {},

		isPlainObject: function( obj ) {
			var proto, Ctor;

			// Detect obvious negatives
			// Use toString instead of jQuery.type to catch host objects
			if ( !obj || toString.call( obj ) !== "[object Object]" ) {
				return false;
			}

			proto = getProto( obj );

			// Objects with no prototype (e.g., `Object.create( null )`) are plain
			if ( !proto ) {
				return true;
			}

			// Objects with prototype are plain iff they were constructed by a global Object function
			Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
			return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
		},

		isEmptyObject: function( obj ) {
			var name;

			for ( name in obj ) {
				return false;
			}
			return true;
		},

		// Evaluates a script in a provided context; falls back to the global one
		// if not specified.
		globalEval: function( code, options, doc ) {
			DOMEval( code, { nonce: options && options.nonce }, doc );
		},

		each: function( obj, callback ) {
			var length, i = 0;

			if ( isArrayLike( obj ) ) {
				length = obj.length;
				for ( ; i < length; i++ ) {
					if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
						break;
					}
				}
			} else {
				for ( i in obj ) {
					if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
						break;
					}
				}
			}

			return obj;
		},


		// Retrieve the text value of an array of DOM nodes
		text: function( elem ) {
			var node,
				ret = "",
				i = 0,
				nodeType = elem.nodeType;

			if ( !nodeType ) {

				// If no nodeType, this is expected to be an array
				while ( ( node = elem[ i++ ] ) ) {

					// Do not traverse comment nodes
					ret += jQuery.text( node );
				}
			}
			if ( nodeType === 1 || nodeType === 11 ) {
				return elem.textContent;
			}
			if ( nodeType === 9 ) {
				return elem.documentElement.textContent;
			}
			if ( nodeType === 3 || nodeType === 4 ) {
				return elem.nodeValue;
			}

			// Do not include comment or processing instruction nodes

			return ret;
		},

		// results is for internal usage only
		makeArray: function( arr, results ) {
			var ret = results || [];

			if ( arr != null ) {
				if ( isArrayLike( Object( arr ) ) ) {
					jQuery.merge( ret,
						typeof arr === "string" ?
							[ arr ] : arr
					);
				} else {
					push.call( ret, arr );
				}
			}

			return ret;
		},

		inArray: function( elem, arr, i ) {
			return arr == null ? -1 : indexOf.call( arr, elem, i );
		},

		isXMLDoc: function( elem ) {
			var namespace = elem && elem.namespaceURI,
				docElem = elem && ( elem.ownerDocument || elem ).documentElement;

			// Assume HTML when documentElement doesn't yet exist, such as inside
			// document fragments.
			return !rhtmlSuffix.test( namespace || docElem && docElem.nodeName || "HTML" );
		},

		// Support: Android <=4.0 only, PhantomJS 1 only
		// push.apply(_, arraylike) throws on ancient WebKit
		merge: function( first, second ) {
			var len = +second.length,
				j = 0,
				i = first.length;

			for ( ; j < len; j++ ) {
				first[ i++ ] = second[ j ];
			}

			first.length = i;

			return first;
		},

		grep: function( elems, callback, invert ) {
			var callbackInverse,
				matches = [],
				i = 0,
				length = elems.length,
				callbackExpect = !invert;

			// Go through the array, only saving the items
			// that pass the validator function
			for ( ; i < length; i++ ) {
				callbackInverse = !callback( elems[ i ], i );
				if ( callbackInverse !== callbackExpect ) {
					matches.push( elems[ i ] );
				}
			}

			return matches;
		},

		// arg is for internal usage only
		map: function( elems, callback, arg ) {
			var length, value,
				i = 0,
				ret = [];

			// Go through the array, translating each of the items to their new values
			if ( isArrayLike( elems ) ) {
				length = elems.length;
				for ( ; i < length; i++ ) {
					value = callback( elems[ i ], i, arg );

					if ( value != null ) {
						ret.push( value );
					}
				}

			// Go through every key on the object,
			} else {
				for ( i in elems ) {
					value = callback( elems[ i ], i, arg );

					if ( value != null ) {
						ret.push( value );
					}
				}
			}

			// Flatten any nested arrays
			return flat( ret );
		},

		// A global GUID counter for objects
		guid: 1,

		// jQuery.support is not used in Core but other projects attach their
		// properties to it so it needs to exist.
		support: support
	} );

	if ( typeof Symbol === "function" ) {
		jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
	}

	// Populate the class2type map
	jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
		function( _i, name ) {
			class2type[ "[object " + name + "]" ] = name.toLowerCase();
		} );

	function isArrayLike( obj ) {

		// Support: real iOS 8.2 only (not reproducible in simulator)
		// `in` check used to prevent JIT error (gh-2145)
		// hasOwn isn't used here due to false negatives
		// regarding Nodelist length in IE
		var length = !!obj && "length" in obj && obj.length,
			type = toType( obj );

		if ( isFunction( obj ) || isWindow( obj ) ) {
			return false;
		}

		return type === "array" || length === 0 ||
			typeof length === "number" && length > 0 && ( length - 1 ) in obj;
	}


	function nodeName( elem, name ) {

		return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();

	}
	var pop = arr.pop;


	var sort = arr.sort;


	var splice = arr.splice;


	var whitespace = "[\\x20\\t\\r\\n\\f]";


	var rtrimCSS = new RegExp(
		"^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$",
		"g"
	);




	// Note: an element does not contain itself
	jQuery.contains = function( a, b ) {
		var bup = b && b.parentNode;

		return a === bup || !!( bup && bup.nodeType === 1 && (

			// Support: IE 9 - 11+
			// IE doesn't have `contains` on SVG.
			a.contains ?
				a.contains( bup ) :
				a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
		) );
	};




	// CSS string/identifier serialization
	// https://drafts.csswg.org/cssom/#common-serializing-idioms
	var rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g;

	function fcssescape( ch, asCodePoint ) {
		if ( asCodePoint ) {

			// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
			if ( ch === "\0" ) {
				return "\uFFFD";
			}

			// Control characters and (dependent upon position) numbers get escaped as code points
			return ch.slice( 0, -1 ) + "\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
		}

		// Other potentially-special ASCII characters get backslash-escaped
		return "\\" + ch;
	}

	jQuery.escapeSelector = function( sel ) {
		return ( sel + "" ).replace( rcssescape, fcssescape );
	};




	var preferredDoc = document,
		pushNative = push;

	( function() {

	var i,
		Expr,
		outermostContext,
		sortInput,
		hasDuplicate,
		push = pushNative,

		// Local document vars
		document,
		documentElement,
		documentIsHTML,
		rbuggyQSA,
		matches,

		// Instance-specific data
		expando = jQuery.expando,
		dirruns = 0,
		done = 0,
		classCache = createCache(),
		tokenCache = createCache(),
		compilerCache = createCache(),
		nonnativeSelectorCache = createCache(),
		sortOrder = function( a, b ) {
			if ( a === b ) {
				hasDuplicate = true;
			}
			return 0;
		},

		booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|" +
			"loop|multiple|open|readonly|required|scoped",

		// Regular expressions

		// https://www.w3.org/TR/css-syntax-3/#ident-token-diagram
		identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace +
			"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",

		// Attribute selectors: https://www.w3.org/TR/selectors/#attribute-selectors
		attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +

			// Operator (capture 2)
			"*([*^$|!~]?=)" + whitespace +

			// "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
			"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" +
			whitespace + "*\\]",

		pseudos = ":(" + identifier + ")(?:\\((" +

			// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
			// 1. quoted (capture 3; capture 4 or capture 5)
			"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +

			// 2. simple (capture 6)
			"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +

			// 3. anything else (capture 2)
			".*" +
			")\\)|)",

		// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
		rwhitespace = new RegExp( whitespace + "+", "g" ),

		rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
		rleadingCombinator = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" +
			whitespace + "*" ),
		rdescend = new RegExp( whitespace + "|>" ),

		rpseudo = new RegExp( pseudos ),
		ridentifier = new RegExp( "^" + identifier + "$" ),

		matchExpr = {
			ID: new RegExp( "^#(" + identifier + ")" ),
			CLASS: new RegExp( "^\\.(" + identifier + ")" ),
			TAG: new RegExp( "^(" + identifier + "|[*])" ),
			ATTR: new RegExp( "^" + attributes ),
			PSEUDO: new RegExp( "^" + pseudos ),
			CHILD: new RegExp(
				"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
					whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" +
					whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
			bool: new RegExp( "^(?:" + booleans + ")$", "i" ),

			// For use in libraries implementing .is()
			// We use this for POS matching in `select`
			needsContext: new RegExp( "^" + whitespace +
				"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
				"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
		},

		rinputs = /^(?:input|select|textarea|button)$/i,
		rheader = /^h\d$/i,

		// Easily-parseable/retrievable ID or TAG or CLASS selectors
		rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

		rsibling = /[+~]/,

		// CSS escapes
		// https://www.w3.org/TR/CSS21/syndata.html#escaped-characters
		runescape = new RegExp( "\\\\[\\da-fA-F]{1,6}" + whitespace +
			"?|\\\\([^\\r\\n\\f])", "g" ),
		funescape = function( escape, nonHex ) {
			var high = "0x" + escape.slice( 1 ) - 0x10000;

			if ( nonHex ) {

				// Strip the backslash prefix from a non-hex escape sequence
				return nonHex;
			}

			// Replace a hexadecimal escape sequence with the encoded Unicode code point
			// Support: IE <=11+
			// For values outside the Basic Multilingual Plane (BMP), manually construct a
			// surrogate pair
			return high < 0 ?
				String.fromCharCode( high + 0x10000 ) :
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
		},

		// Used for iframes; see `setDocument`.
		// Support: IE 9 - 11+, Edge 12 - 18+
		// Removing the function wrapper causes a "Permission Denied"
		// error in IE/Edge.
		unloadHandler = function() {
			setDocument();
		},

		inDisabledFieldset = addCombinator(
			function( elem ) {
				return elem.disabled === true && nodeName( elem, "fieldset" );
			},
			{ dir: "parentNode", next: "legend" }
		);

	// Support: IE <=9 only
	// Accessing document.activeElement can throw unexpectedly
	// https://bugs.jquery.com/ticket/13393
	function safeActiveElement() {
		try {
			return document.activeElement;
		} catch ( err ) { }
	}

	// Optimize for push.apply( _, NodeList )
	try {
		push.apply(
			( arr = slice.call( preferredDoc.childNodes ) ),
			preferredDoc.childNodes
		);

		// Support: Android <=4.0
		// Detect silently failing push.apply
		// eslint-disable-next-line no-unused-expressions
		arr[ preferredDoc.childNodes.length ].nodeType;
	} catch ( e ) {
		push = {
			apply: function( target, els ) {
				pushNative.apply( target, slice.call( els ) );
			},
			call: function( target ) {
				pushNative.apply( target, slice.call( arguments, 1 ) );
			}
		};
	}

	function find( selector, context, results, seed ) {
		var m, i, elem, nid, match, groups, newSelector,
			newContext = context && context.ownerDocument,

			// nodeType defaults to 9, since context defaults to document
			nodeType = context ? context.nodeType : 9;

		results = results || [];

		// Return early from calls with invalid selector or context
		if ( typeof selector !== "string" || !selector ||
			nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

			return results;
		}

		// Try to shortcut find operations (as opposed to filters) in HTML documents
		if ( !seed ) {
			setDocument( context );
			context = context || document;

			if ( documentIsHTML ) {

				// If the selector is sufficiently simple, try using a "get*By*" DOM method
				// (excepting DocumentFragment context, where the methods don't exist)
				if ( nodeType !== 11 && ( match = rquickExpr.exec( selector ) ) ) {

					// ID selector
					if ( ( m = match[ 1 ] ) ) {

						// Document context
						if ( nodeType === 9 ) {
							if ( ( elem = context.getElementById( m ) ) ) {

								// Support: IE 9 only
								// getElementById can match elements by name instead of ID
								if ( elem.id === m ) {
									push.call( results, elem );
									return results;
								}
							} else {
								return results;
							}

						// Element context
						} else {

							// Support: IE 9 only
							// getElementById can match elements by name instead of ID
							if ( newContext && ( elem = newContext.getElementById( m ) ) &&
								find.contains( context, elem ) &&
								elem.id === m ) {

								push.call( results, elem );
								return results;
							}
						}

					// Type selector
					} else if ( match[ 2 ] ) {
						push.apply( results, context.getElementsByTagName( selector ) );
						return results;

					// Class selector
					} else if ( ( m = match[ 3 ] ) && context.getElementsByClassName ) {
						push.apply( results, context.getElementsByClassName( m ) );
						return results;
					}
				}

				// Take advantage of querySelectorAll
				if ( !nonnativeSelectorCache[ selector + " " ] &&
					( !rbuggyQSA || !rbuggyQSA.test( selector ) ) ) {

					newSelector = selector;
					newContext = context;

					// qSA considers elements outside a scoping root when evaluating child or
					// descendant combinators, which is not what we want.
					// In such cases, we work around the behavior by prefixing every selector in the
					// list with an ID selector referencing the scope context.
					// The technique has to be used as well when a leading combinator is used
					// as such selectors are not recognized by querySelectorAll.
					// Thanks to Andrew Dupont for this technique.
					if ( nodeType === 1 &&
						( rdescend.test( selector ) || rleadingCombinator.test( selector ) ) ) {

						// Expand context for sibling selectors
						newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
							context;

						// We can use :scope instead of the ID hack if the browser
						// supports it & if we're not changing the context.
						// Support: IE 11+, Edge 17 - 18+
						// IE/Edge sometimes throw a "Permission denied" error when
						// strict-comparing two documents; shallow comparisons work.
						// eslint-disable-next-line eqeqeq
						if ( newContext != context || !support.scope ) {

							// Capture the context ID, setting it first if necessary
							if ( ( nid = context.getAttribute( "id" ) ) ) {
								nid = jQuery.escapeSelector( nid );
							} else {
								context.setAttribute( "id", ( nid = expando ) );
							}
						}

						// Prefix every selector in the list
						groups = tokenize( selector );
						i = groups.length;
						while ( i-- ) {
							groups[ i ] = ( nid ? "#" + nid : ":scope" ) + " " +
								toSelector( groups[ i ] );
						}
						newSelector = groups.join( "," );
					}

					try {
						push.apply( results,
							newContext.querySelectorAll( newSelector )
						);
						return results;
					} catch ( qsaError ) {
						nonnativeSelectorCache( selector, true );
					} finally {
						if ( nid === expando ) {
							context.removeAttribute( "id" );
						}
					}
				}
			}
		}

		// All others
		return select( selector.replace( rtrimCSS, "$1" ), context, results, seed );
	}

	/**
	 * Create key-value caches of limited size
	 * @returns {function(string, object)} Returns the Object data after storing it on itself with
	 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
	 *	deleting the oldest entry
	 */
	function createCache() {
		var keys = [];

		function cache( key, value ) {

			// Use (key + " ") to avoid collision with native prototype properties
			// (see https://github.com/jquery/sizzle/issues/157)
			if ( keys.push( key + " " ) > Expr.cacheLength ) {

				// Only keep the most recent entries
				delete cache[ keys.shift() ];
			}
			return ( cache[ key + " " ] = value );
		}
		return cache;
	}

	/**
	 * Mark a function for special use by jQuery selector module
	 * @param {Function} fn The function to mark
	 */
	function markFunction( fn ) {
		fn[ expando ] = true;
		return fn;
	}

	/**
	 * Support testing using an element
	 * @param {Function} fn Passed the created element and returns a boolean result
	 */
	function assert( fn ) {
		var el = document.createElement( "fieldset" );

		try {
			return !!fn( el );
		} catch ( e ) {
			return false;
		} finally {

			// Remove from its parent by default
			if ( el.parentNode ) {
				el.parentNode.removeChild( el );
			}

			// release memory in IE
			el = null;
		}
	}

	/**
	 * Returns a function to use in pseudos for input types
	 * @param {String} type
	 */
	function createInputPseudo( type ) {
		return function( elem ) {
			return nodeName( elem, "input" ) && elem.type === type;
		};
	}

	/**
	 * Returns a function to use in pseudos for buttons
	 * @param {String} type
	 */
	function createButtonPseudo( type ) {
		return function( elem ) {
			return ( nodeName( elem, "input" ) || nodeName( elem, "button" ) ) &&
				elem.type === type;
		};
	}

	/**
	 * Returns a function to use in pseudos for :enabled/:disabled
	 * @param {Boolean} disabled true for :disabled; false for :enabled
	 */
	function createDisabledPseudo( disabled ) {

		// Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
		return function( elem ) {

			// Only certain elements can match :enabled or :disabled
			// https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
			// https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
			if ( "form" in elem ) {

				// Check for inherited disabledness on relevant non-disabled elements:
				// * listed form-associated elements in a disabled fieldset
				//   https://html.spec.whatwg.org/multipage/forms.html#category-listed
				//   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
				// * option elements in a disabled optgroup
				//   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
				// All such elements have a "form" property.
				if ( elem.parentNode && elem.disabled === false ) {

					// Option elements defer to a parent optgroup if present
					if ( "label" in elem ) {
						if ( "label" in elem.parentNode ) {
							return elem.parentNode.disabled === disabled;
						} else {
							return elem.disabled === disabled;
						}
					}

					// Support: IE 6 - 11+
					// Use the isDisabled shortcut property to check for disabled fieldset ancestors
					return elem.isDisabled === disabled ||

						// Where there is no isDisabled, check manually
						elem.isDisabled !== !disabled &&
							inDisabledFieldset( elem ) === disabled;
				}

				return elem.disabled === disabled;

			// Try to winnow out elements that can't be disabled before trusting the disabled property.
			// Some victims get caught in our net (label, legend, menu, track), but it shouldn't
			// even exist on them, let alone have a boolean value.
			} else if ( "label" in elem ) {
				return elem.disabled === disabled;
			}

			// Remaining elements are neither :enabled nor :disabled
			return false;
		};
	}

	/**
	 * Returns a function to use in pseudos for positionals
	 * @param {Function} fn
	 */
	function createPositionalPseudo( fn ) {
		return markFunction( function( argument ) {
			argument = +argument;
			return markFunction( function( seed, matches ) {
				var j,
					matchIndexes = fn( [], seed.length, argument ),
					i = matchIndexes.length;

				// Match elements found at the specified indexes
				while ( i-- ) {
					if ( seed[ ( j = matchIndexes[ i ] ) ] ) {
						seed[ j ] = !( matches[ j ] = seed[ j ] );
					}
				}
			} );
		} );
	}

	/**
	 * Checks a node for validity as a jQuery selector context
	 * @param {Element|Object=} context
	 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
	 */
	function testContext( context ) {
		return context && typeof context.getElementsByTagName !== "undefined" && context;
	}

	/**
	 * Sets document-related variables once based on the current document
	 * @param {Element|Object} [node] An element or document object to use to set the document
	 * @returns {Object} Returns the current document
	 */
	function setDocument( node ) {
		var subWindow,
			doc = node ? node.ownerDocument || node : preferredDoc;

		// Return early if doc is invalid or already selected
		// Support: IE 11+, Edge 17 - 18+
		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		// two documents; shallow comparisons work.
		// eslint-disable-next-line eqeqeq
		if ( doc == document || doc.nodeType !== 9 || !doc.documentElement ) {
			return document;
		}

		// Update global variables
		document = doc;
		documentElement = document.documentElement;
		documentIsHTML = !jQuery.isXMLDoc( document );

		// Support: iOS 7 only, IE 9 - 11+
		// Older browsers didn't support unprefixed `matches`.
		matches = documentElement.matches ||
			documentElement.webkitMatchesSelector ||
			documentElement.msMatchesSelector;

		// Support: IE 9 - 11+, Edge 12 - 18+
		// Accessing iframe documents after unload throws "permission denied" errors
		// (see trac-13936).
		// Limit the fix to IE & Edge Legacy; despite Edge 15+ implementing `matches`,
		// all IE 9+ and Edge Legacy versions implement `msMatchesSelector` as well.
		if ( documentElement.msMatchesSelector &&

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			preferredDoc != document &&
			( subWindow = document.defaultView ) && subWindow.top !== subWindow ) {

			// Support: IE 9 - 11+, Edge 12 - 18+
			subWindow.addEventListener( "unload", unloadHandler );
		}

		// Support: IE <10
		// Check if getElementById returns elements by name
		// The broken getElementById methods don't pick up programmatically-set names,
		// so use a roundabout getElementsByName test
		support.getById = assert( function( el ) {
			documentElement.appendChild( el ).id = jQuery.expando;
			return !document.getElementsByName ||
				!document.getElementsByName( jQuery.expando ).length;
		} );

		// Support: IE 9 only
		// Check to see if it's possible to do matchesSelector
		// on a disconnected node.
		support.disconnectedMatch = assert( function( el ) {
			return matches.call( el, "*" );
		} );

		// Support: IE 9 - 11+, Edge 12 - 18+
		// IE/Edge don't support the :scope pseudo-class.
		support.scope = assert( function() {
			return document.querySelectorAll( ":scope" );
		} );

		// Support: Chrome 105 - 111 only, Safari 15.4 - 16.3 only
		// Make sure the `:has()` argument is parsed unforgivingly.
		// We include `*` in the test to detect buggy implementations that are
		// _selectively_ forgiving (specifically when the list includes at least
		// one valid selector).
		// Note that we treat complete lack of support for `:has()` as if it were
		// spec-compliant support, which is fine because use of `:has()` in such
		// environments will fail in the qSA path and fall back to jQuery traversal
		// anyway.
		support.cssHas = assert( function() {
			try {
				document.querySelector( ":has(*,:jqfake)" );
				return false;
			} catch ( e ) {
				return true;
			}
		} );

		// ID filter and find
		if ( support.getById ) {
			Expr.filter.ID = function( id ) {
				var attrId = id.replace( runescape, funescape );
				return function( elem ) {
					return elem.getAttribute( "id" ) === attrId;
				};
			};
			Expr.find.ID = function( id, context ) {
				if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
					var elem = context.getElementById( id );
					return elem ? [ elem ] : [];
				}
			};
		} else {
			Expr.filter.ID =  function( id ) {
				var attrId = id.replace( runescape, funescape );
				return function( elem ) {
					var node = typeof elem.getAttributeNode !== "undefined" &&
						elem.getAttributeNode( "id" );
					return node && node.value === attrId;
				};
			};

			// Support: IE 6 - 7 only
			// getElementById is not reliable as a find shortcut
			Expr.find.ID = function( id, context ) {
				if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
					var node, i, elems,
						elem = context.getElementById( id );

					if ( elem ) {

						// Verify the id attribute
						node = elem.getAttributeNode( "id" );
						if ( node && node.value === id ) {
							return [ elem ];
						}

						// Fall back on getElementsByName
						elems = context.getElementsByName( id );
						i = 0;
						while ( ( elem = elems[ i++ ] ) ) {
							node = elem.getAttributeNode( "id" );
							if ( node && node.value === id ) {
								return [ elem ];
							}
						}
					}

					return [];
				}
			};
		}

		// Tag
		Expr.find.TAG = function( tag, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( tag );

			// DocumentFragment nodes don't have gEBTN
			} else {
				return context.querySelectorAll( tag );
			}
		};

		// Class
		Expr.find.CLASS = function( className, context ) {
			if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
				return context.getElementsByClassName( className );
			}
		};

		/* QSA/matchesSelector
		---------------------------------------------------------------------- */

		// QSA and matchesSelector support

		rbuggyQSA = [];

		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert( function( el ) {

			var input;

			documentElement.appendChild( el ).innerHTML =
				"<a id='" + expando + "' href='' disabled='disabled'></a>" +
				"<select id='" + expando + "-\r\\' disabled='disabled'>" +
				"<option selected=''></option></select>";

			// Support: iOS <=7 - 8 only
			// Boolean attributes and "value" are not treated correctly in some XML documents
			if ( !el.querySelectorAll( "[selected]" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Support: iOS <=7 - 8 only
			if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
				rbuggyQSA.push( "~=" );
			}

			// Support: iOS 8 only
			// https://bugs.webkit.org/show_bug.cgi?id=136851
			// In-page `selector#id sibling-combinator selector` fails
			if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {
				rbuggyQSA.push( ".#.+[+~]" );
			}

			// Support: Chrome <=105+, Firefox <=104+, Safari <=15.4+
			// In some of the document kinds, these selectors wouldn't work natively.
			// This is probably OK but for backwards compatibility we want to maintain
			// handling them through jQuery traversal in jQuery 3.x.
			if ( !el.querySelectorAll( ":checked" ).length ) {
				rbuggyQSA.push( ":checked" );
			}

			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			input = document.createElement( "input" );
			input.setAttribute( "type", "hidden" );
			el.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE 9 - 11+
			// IE's :disabled selector does not pick up the children of disabled fieldsets
			// Support: Chrome <=105+, Firefox <=104+, Safari <=15.4+
			// In some of the document kinds, these selectors wouldn't work natively.
			// This is probably OK but for backwards compatibility we want to maintain
			// handling them through jQuery traversal in jQuery 3.x.
			documentElement.appendChild( el ).disabled = true;
			if ( el.querySelectorAll( ":disabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: IE 11+, Edge 15 - 18+
			// IE 11/Edge don't find elements on a `[name='']` query in some cases.
			// Adding a temporary attribute to the document before the selection works
			// around the issue.
			// Interestingly, IE 10 & older don't seem to have the issue.
			input = document.createElement( "input" );
			input.setAttribute( "name", "" );
			el.appendChild( input );
			if ( !el.querySelectorAll( "[name='']" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*name" + whitespace + "*=" +
					whitespace + "*(?:''|\"\")" );
			}
		} );

		if ( !support.cssHas ) {

			// Support: Chrome 105 - 110+, Safari 15.4 - 16.3+
			// Our regular `try-catch` mechanism fails to detect natively-unsupported
			// pseudo-classes inside `:has()` (such as `:has(:contains("Foo"))`)
			// in browsers that parse the `:has()` argument as a forgiving selector list.
			// https://drafts.csswg.org/selectors/#relational now requires the argument
			// to be parsed unforgivingly, but browsers have not yet fully adjusted.
			rbuggyQSA.push( ":has" );
		}

		rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join( "|" ) );

		/* Sorting
		---------------------------------------------------------------------- */

		// Document order sorting
		sortOrder = function( a, b ) {

			// Flag for duplicate removal
			if ( a === b ) {
				hasDuplicate = true;
				return 0;
			}

			// Sort on method existence if only one input has compareDocumentPosition
			var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
			if ( compare ) {
				return compare;
			}

			// Calculate position if both inputs belong to the same document
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			compare = ( a.ownerDocument || a ) == ( b.ownerDocument || b ) ?
				a.compareDocumentPosition( b ) :

				// Otherwise we know they are disconnected
				1;

			// Disconnected nodes
			if ( compare & 1 ||
				( !support.sortDetached && b.compareDocumentPosition( a ) === compare ) ) {

				// Choose the first element that is related to our preferred document
				// Support: IE 11+, Edge 17 - 18+
				// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
				// two documents; shallow comparisons work.
				// eslint-disable-next-line eqeqeq
				if ( a === document || a.ownerDocument == preferredDoc &&
					find.contains( preferredDoc, a ) ) {
					return -1;
				}

				// Support: IE 11+, Edge 17 - 18+
				// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
				// two documents; shallow comparisons work.
				// eslint-disable-next-line eqeqeq
				if ( b === document || b.ownerDocument == preferredDoc &&
					find.contains( preferredDoc, b ) ) {
					return 1;
				}

				// Maintain original order
				return sortInput ?
					( indexOf.call( sortInput, a ) - indexOf.call( sortInput, b ) ) :
					0;
			}

			return compare & 4 ? -1 : 1;
		};

		return document;
	}

	find.matches = function( expr, elements ) {
		return find( expr, null, null, elements );
	};

	find.matchesSelector = function( elem, expr ) {
		setDocument( elem );

		if ( documentIsHTML &&
			!nonnativeSelectorCache[ expr + " " ] &&
			( !rbuggyQSA || !rbuggyQSA.test( expr ) ) ) {

			try {
				var ret = matches.call( elem, expr );

				// IE 9's matchesSelector returns false on disconnected nodes
				if ( ret || support.disconnectedMatch ||

						// As well, disconnected nodes are said to be in a document
						// fragment in IE 9
						elem.document && elem.document.nodeType !== 11 ) {
					return ret;
				}
			} catch ( e ) {
				nonnativeSelectorCache( expr, true );
			}
		}

		return find( expr, document, null, [ elem ] ).length > 0;
	};

	find.contains = function( context, elem ) {

		// Set document vars if needed
		// Support: IE 11+, Edge 17 - 18+
		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		// two documents; shallow comparisons work.
		// eslint-disable-next-line eqeqeq
		if ( ( context.ownerDocument || context ) != document ) {
			setDocument( context );
		}
		return jQuery.contains( context, elem );
	};


	find.attr = function( elem, name ) {

		// Set document vars if needed
		// Support: IE 11+, Edge 17 - 18+
		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		// two documents; shallow comparisons work.
		// eslint-disable-next-line eqeqeq
		if ( ( elem.ownerDocument || elem ) != document ) {
			setDocument( elem );
		}

		var fn = Expr.attrHandle[ name.toLowerCase() ],

			// Don't get fooled by Object.prototype properties (see trac-13807)
			val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
				fn( elem, name, !documentIsHTML ) :
				undefined;

		if ( val !== undefined ) {
			return val;
		}

		return elem.getAttribute( name );
	};

	find.error = function( msg ) {
		throw new Error( "Syntax error, unrecognized expression: " + msg );
	};

	/**
	 * Document sorting and removing duplicates
	 * @param {ArrayLike} results
	 */
	jQuery.uniqueSort = function( results ) {
		var elem,
			duplicates = [],
			j = 0,
			i = 0;

		// Unless we *know* we can detect duplicates, assume their presence
		//
		// Support: Android <=4.0+
		// Testing for detecting duplicates is unpredictable so instead assume we can't
		// depend on duplicate detection in all browsers without a stable sort.
		hasDuplicate = !support.sortStable;
		sortInput = !support.sortStable && slice.call( results, 0 );
		sort.call( results, sortOrder );

		if ( hasDuplicate ) {
			while ( ( elem = results[ i++ ] ) ) {
				if ( elem === results[ i ] ) {
					j = duplicates.push( i );
				}
			}
			while ( j-- ) {
				splice.call( results, duplicates[ j ], 1 );
			}
		}

		// Clear input after sorting to release objects
		// See https://github.com/jquery/sizzle/pull/225
		sortInput = null;

		return results;
	};

	jQuery.fn.uniqueSort = function() {
		return this.pushStack( jQuery.uniqueSort( slice.apply( this ) ) );
	};

	Expr = jQuery.expr = {

		// Can be adjusted by the user
		cacheLength: 50,

		createPseudo: markFunction,

		match: matchExpr,

		attrHandle: {},

		find: {},

		relative: {
			">": { dir: "parentNode", first: true },
			" ": { dir: "parentNode" },
			"+": { dir: "previousSibling", first: true },
			"~": { dir: "previousSibling" }
		},

		preFilter: {
			ATTR: function( match ) {
				match[ 1 ] = match[ 1 ].replace( runescape, funescape );

				// Move the given value to match[3] whether quoted or unquoted
				match[ 3 ] = ( match[ 3 ] || match[ 4 ] || match[ 5 ] || "" )
					.replace( runescape, funescape );

				if ( match[ 2 ] === "~=" ) {
					match[ 3 ] = " " + match[ 3 ] + " ";
				}

				return match.slice( 0, 4 );
			},

			CHILD: function( match ) {

				/* matches from matchExpr["CHILD"]
					1 type (only|nth|...)
					2 what (child|of-type)
					3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
					4 xn-component of xn+y argument ([+-]?\d*n|)
					5 sign of xn-component
					6 x of xn-component
					7 sign of y-component
					8 y of y-component
				*/
				match[ 1 ] = match[ 1 ].toLowerCase();

				if ( match[ 1 ].slice( 0, 3 ) === "nth" ) {

					// nth-* requires argument
					if ( !match[ 3 ] ) {
						find.error( match[ 0 ] );
					}

					// numeric x and y parameters for Expr.filter.CHILD
					// remember that false/true cast respectively to 0/1
					match[ 4 ] = +( match[ 4 ] ?
						match[ 5 ] + ( match[ 6 ] || 1 ) :
						2 * ( match[ 3 ] === "even" || match[ 3 ] === "odd" )
					);
					match[ 5 ] = +( ( match[ 7 ] + match[ 8 ] ) || match[ 3 ] === "odd" );

				// other types prohibit arguments
				} else if ( match[ 3 ] ) {
					find.error( match[ 0 ] );
				}

				return match;
			},

			PSEUDO: function( match ) {
				var excess,
					unquoted = !match[ 6 ] && match[ 2 ];

				if ( matchExpr.CHILD.test( match[ 0 ] ) ) {
					return null;
				}

				// Accept quoted arguments as-is
				if ( match[ 3 ] ) {
					match[ 2 ] = match[ 4 ] || match[ 5 ] || "";

				// Strip excess characters from unquoted arguments
				} else if ( unquoted && rpseudo.test( unquoted ) &&

					// Get excess from tokenize (recursively)
					( excess = tokenize( unquoted, true ) ) &&

					// advance to the next closing parenthesis
					( excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length ) ) {

					// excess is a negative index
					match[ 0 ] = match[ 0 ].slice( 0, excess );
					match[ 2 ] = unquoted.slice( 0, excess );
				}

				// Return only captures needed by the pseudo filter method (type and argument)
				return match.slice( 0, 3 );
			}
		},

		filter: {

			TAG: function( nodeNameSelector ) {
				var expectedNodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
				return nodeNameSelector === "*" ?
					function() {
						return true;
					} :
					function( elem ) {
						return nodeName( elem, expectedNodeName );
					};
			},

			CLASS: function( className ) {
				var pattern = classCache[ className + " " ];

				return pattern ||
					( pattern = new RegExp( "(^|" + whitespace + ")" + className +
						"(" + whitespace + "|$)" ) ) &&
					classCache( className, function( elem ) {
						return pattern.test(
							typeof elem.className === "string" && elem.className ||
								typeof elem.getAttribute !== "undefined" &&
									elem.getAttribute( "class" ) ||
								""
						);
					} );
			},

			ATTR: function( name, operator, check ) {
				return function( elem ) {
					var result = find.attr( elem, name );

					if ( result == null ) {
						return operator === "!=";
					}
					if ( !operator ) {
						return true;
					}

					result += "";

					if ( operator === "=" ) {
						return result === check;
					}
					if ( operator === "!=" ) {
						return result !== check;
					}
					if ( operator === "^=" ) {
						return check && result.indexOf( check ) === 0;
					}
					if ( operator === "*=" ) {
						return check && result.indexOf( check ) > -1;
					}
					if ( operator === "$=" ) {
						return check && result.slice( -check.length ) === check;
					}
					if ( operator === "~=" ) {
						return ( " " + result.replace( rwhitespace, " " ) + " " )
							.indexOf( check ) > -1;
					}
					if ( operator === "|=" ) {
						return result === check || result.slice( 0, check.length + 1 ) === check + "-";
					}

					return false;
				};
			},

			CHILD: function( type, what, _argument, first, last ) {
				var simple = type.slice( 0, 3 ) !== "nth",
					forward = type.slice( -4 ) !== "last",
					ofType = what === "of-type";

				return first === 1 && last === 0 ?

					// Shortcut for :nth-*(n)
					function( elem ) {
						return !!elem.parentNode;
					} :

					function( elem, _context, xml ) {
						var cache, outerCache, node, nodeIndex, start,
							dir = simple !== forward ? "nextSibling" : "previousSibling",
							parent = elem.parentNode,
							name = ofType && elem.nodeName.toLowerCase(),
							useCache = !xml && !ofType,
							diff = false;

						if ( parent ) {

							// :(first|last|only)-(child|of-type)
							if ( simple ) {
								while ( dir ) {
									node = elem;
									while ( ( node = node[ dir ] ) ) {
										if ( ofType ?
											nodeName( node, name ) :
											node.nodeType === 1 ) {

											return false;
										}
									}

									// Reverse direction for :only-* (if we haven't yet done so)
									start = dir = type === "only" && !start && "nextSibling";
								}
								return true;
							}

							start = [ forward ? parent.firstChild : parent.lastChild ];

							// non-xml :nth-child(...) stores cache data on `parent`
							if ( forward && useCache ) {

								// Seek `elem` from a previously-cached index
								outerCache = parent[ expando ] || ( parent[ expando ] = {} );
								cache = outerCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex && cache[ 2 ];
								node = nodeIndex && parent.childNodes[ nodeIndex ];

								while ( ( node = ++nodeIndex && node && node[ dir ] ||

									// Fallback to seeking `elem` from the start
									( diff = nodeIndex = 0 ) || start.pop() ) ) {

									// When found, cache indexes on `parent` and break
									if ( node.nodeType === 1 && ++diff && node === elem ) {
										outerCache[ type ] = [ dirruns, nodeIndex, diff ];
										break;
									}
								}

							} else {

								// Use previously-cached element index if available
								if ( useCache ) {
									outerCache = elem[ expando ] || ( elem[ expando ] = {} );
									cache = outerCache[ type ] || [];
									nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
									diff = nodeIndex;
								}

								// xml :nth-child(...)
								// or :nth-last-child(...) or :nth(-last)?-of-type(...)
								if ( diff === false ) {

									// Use the same loop as above to seek `elem` from the start
									while ( ( node = ++nodeIndex && node && node[ dir ] ||
										( diff = nodeIndex = 0 ) || start.pop() ) ) {

										if ( ( ofType ?
											nodeName( node, name ) :
											node.nodeType === 1 ) &&
											++diff ) {

											// Cache the index of each encountered element
											if ( useCache ) {
												outerCache = node[ expando ] ||
													( node[ expando ] = {} );
												outerCache[ type ] = [ dirruns, diff ];
											}

											if ( node === elem ) {
												break;
											}
										}
									}
								}
							}

							// Incorporate the offset, then check against cycle size
							diff -= last;
							return diff === first || ( diff % first === 0 && diff / first >= 0 );
						}
					};
			},

			PSEUDO: function( pseudo, argument ) {

				// pseudo-class names are case-insensitive
				// https://www.w3.org/TR/selectors/#pseudo-classes
				// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
				// Remember that setFilters inherits from pseudos
				var args,
					fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
						find.error( "unsupported pseudo: " + pseudo );

				// The user may use createPseudo to indicate that
				// arguments are needed to create the filter function
				// just as jQuery does
				if ( fn[ expando ] ) {
					return fn( argument );
				}

				// But maintain support for old signatures
				if ( fn.length > 1 ) {
					args = [ pseudo, pseudo, "", argument ];
					return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
						markFunction( function( seed, matches ) {
							var idx,
								matched = fn( seed, argument ),
								i = matched.length;
							while ( i-- ) {
								idx = indexOf.call( seed, matched[ i ] );
								seed[ idx ] = !( matches[ idx ] = matched[ i ] );
							}
						} ) :
						function( elem ) {
							return fn( elem, 0, args );
						};
				}

				return fn;
			}
		},

		pseudos: {

			// Potentially complex pseudos
			not: markFunction( function( selector ) {

				// Trim the selector passed to compile
				// to avoid treating leading and trailing
				// spaces as combinators
				var input = [],
					results = [],
					matcher = compile( selector.replace( rtrimCSS, "$1" ) );

				return matcher[ expando ] ?
					markFunction( function( seed, matches, _context, xml ) {
						var elem,
							unmatched = matcher( seed, null, xml, [] ),
							i = seed.length;

						// Match elements unmatched by `matcher`
						while ( i-- ) {
							if ( ( elem = unmatched[ i ] ) ) {
								seed[ i ] = !( matches[ i ] = elem );
							}
						}
					} ) :
					function( elem, _context, xml ) {
						input[ 0 ] = elem;
						matcher( input, null, xml, results );

						// Don't keep the element
						// (see https://github.com/jquery/sizzle/issues/299)
						input[ 0 ] = null;
						return !results.pop();
					};
			} ),

			has: markFunction( function( selector ) {
				return function( elem ) {
					return find( selector, elem ).length > 0;
				};
			} ),

			contains: markFunction( function( text ) {
				text = text.replace( runescape, funescape );
				return function( elem ) {
					return ( elem.textContent || jQuery.text( elem ) ).indexOf( text ) > -1;
				};
			} ),

			// "Whether an element is represented by a :lang() selector
			// is based solely on the element's language value
			// being equal to the identifier C,
			// or beginning with the identifier C immediately followed by "-".
			// The matching of C against the element's language value is performed case-insensitively.
			// The identifier C does not have to be a valid language name."
			// https://www.w3.org/TR/selectors/#lang-pseudo
			lang: markFunction( function( lang ) {

				// lang value must be a valid identifier
				if ( !ridentifier.test( lang || "" ) ) {
					find.error( "unsupported lang: " + lang );
				}
				lang = lang.replace( runescape, funescape ).toLowerCase();
				return function( elem ) {
					var elemLang;
					do {
						if ( ( elemLang = documentIsHTML ?
							elem.lang :
							elem.getAttribute( "xml:lang" ) || elem.getAttribute( "lang" ) ) ) {

							elemLang = elemLang.toLowerCase();
							return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
						}
					} while ( ( elem = elem.parentNode ) && elem.nodeType === 1 );
					return false;
				};
			} ),

			// Miscellaneous
			target: function( elem ) {
				var hash = window.location && window.location.hash;
				return hash && hash.slice( 1 ) === elem.id;
			},

			root: function( elem ) {
				return elem === documentElement;
			},

			focus: function( elem ) {
				return elem === safeActiveElement() &&
					document.hasFocus() &&
					!!( elem.type || elem.href || ~elem.tabIndex );
			},

			// Boolean properties
			enabled: createDisabledPseudo( false ),
			disabled: createDisabledPseudo( true ),

			checked: function( elem ) {

				// In CSS3, :checked should return both checked and selected elements
				// https://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
				return ( nodeName( elem, "input" ) && !!elem.checked ) ||
					( nodeName( elem, "option" ) && !!elem.selected );
			},

			selected: function( elem ) {

				// Support: IE <=11+
				// Accessing the selectedIndex property
				// forces the browser to treat the default option as
				// selected when in an optgroup.
				if ( elem.parentNode ) {
					// eslint-disable-next-line no-unused-expressions
					elem.parentNode.selectedIndex;
				}

				return elem.selected === true;
			},

			// Contents
			empty: function( elem ) {

				// https://www.w3.org/TR/selectors/#empty-pseudo
				// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
				//   but not by others (comment: 8; processing instruction: 7; etc.)
				// nodeType < 6 works because attributes (2) do not appear as children
				for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
					if ( elem.nodeType < 6 ) {
						return false;
					}
				}
				return true;
			},

			parent: function( elem ) {
				return !Expr.pseudos.empty( elem );
			},

			// Element/input types
			header: function( elem ) {
				return rheader.test( elem.nodeName );
			},

			input: function( elem ) {
				return rinputs.test( elem.nodeName );
			},

			button: function( elem ) {
				return nodeName( elem, "input" ) && elem.type === "button" ||
					nodeName( elem, "button" );
			},

			text: function( elem ) {
				var attr;
				return nodeName( elem, "input" ) && elem.type === "text" &&

					// Support: IE <10 only
					// New HTML5 attribute values (e.g., "search") appear
					// with elem.type === "text"
					( ( attr = elem.getAttribute( "type" ) ) == null ||
						attr.toLowerCase() === "text" );
			},

			// Position-in-collection
			first: createPositionalPseudo( function() {
				return [ 0 ];
			} ),

			last: createPositionalPseudo( function( _matchIndexes, length ) {
				return [ length - 1 ];
			} ),

			eq: createPositionalPseudo( function( _matchIndexes, length, argument ) {
				return [ argument < 0 ? argument + length : argument ];
			} ),

			even: createPositionalPseudo( function( matchIndexes, length ) {
				var i = 0;
				for ( ; i < length; i += 2 ) {
					matchIndexes.push( i );
				}
				return matchIndexes;
			} ),

			odd: createPositionalPseudo( function( matchIndexes, length ) {
				var i = 1;
				for ( ; i < length; i += 2 ) {
					matchIndexes.push( i );
				}
				return matchIndexes;
			} ),

			lt: createPositionalPseudo( function( matchIndexes, length, argument ) {
				var i;

				if ( argument < 0 ) {
					i = argument + length;
				} else if ( argument > length ) {
					i = length;
				} else {
					i = argument;
				}

				for ( ; --i >= 0; ) {
					matchIndexes.push( i );
				}
				return matchIndexes;
			} ),

			gt: createPositionalPseudo( function( matchIndexes, length, argument ) {
				var i = argument < 0 ? argument + length : argument;
				for ( ; ++i < length; ) {
					matchIndexes.push( i );
				}
				return matchIndexes;
			} )
		}
	};

	Expr.pseudos.nth = Expr.pseudos.eq;

	// Add button/input type pseudos
	for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
		Expr.pseudos[ i ] = createInputPseudo( i );
	}
	for ( i in { submit: true, reset: true } ) {
		Expr.pseudos[ i ] = createButtonPseudo( i );
	}

	// Easy API for creating new setFilters
	function setFilters() {}
	setFilters.prototype = Expr.filters = Expr.pseudos;
	Expr.setFilters = new setFilters();

	function tokenize( selector, parseOnly ) {
		var matched, match, tokens, type,
			soFar, groups, preFilters,
			cached = tokenCache[ selector + " " ];

		if ( cached ) {
			return parseOnly ? 0 : cached.slice( 0 );
		}

		soFar = selector;
		groups = [];
		preFilters = Expr.preFilter;

		while ( soFar ) {

			// Comma and first run
			if ( !matched || ( match = rcomma.exec( soFar ) ) ) {
				if ( match ) {

					// Don't consume trailing commas as valid
					soFar = soFar.slice( match[ 0 ].length ) || soFar;
				}
				groups.push( ( tokens = [] ) );
			}

			matched = false;

			// Combinators
			if ( ( match = rleadingCombinator.exec( soFar ) ) ) {
				matched = match.shift();
				tokens.push( {
					value: matched,

					// Cast descendant combinators to space
					type: match[ 0 ].replace( rtrimCSS, " " )
				} );
				soFar = soFar.slice( matched.length );
			}

			// Filters
			for ( type in Expr.filter ) {
				if ( ( match = matchExpr[ type ].exec( soFar ) ) && ( !preFilters[ type ] ||
					( match = preFilters[ type ]( match ) ) ) ) {
					matched = match.shift();
					tokens.push( {
						value: matched,
						type: type,
						matches: match
					} );
					soFar = soFar.slice( matched.length );
				}
			}

			if ( !matched ) {
				break;
			}
		}

		// Return the length of the invalid excess
		// if we're just parsing
		// Otherwise, throw an error or return tokens
		if ( parseOnly ) {
			return soFar.length;
		}

		return soFar ?
			find.error( selector ) :

			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
	}

	function toSelector( tokens ) {
		var i = 0,
			len = tokens.length,
			selector = "";
		for ( ; i < len; i++ ) {
			selector += tokens[ i ].value;
		}
		return selector;
	}

	function addCombinator( matcher, combinator, base ) {
		var dir = combinator.dir,
			skip = combinator.next,
			key = skip || dir,
			checkNonElements = base && key === "parentNode",
			doneName = done++;

		return combinator.first ?

			// Check against closest ancestor/preceding element
			function( elem, context, xml ) {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						return matcher( elem, context, xml );
					}
				}
				return false;
			} :

			// Check against all ancestor/preceding elements
			function( elem, context, xml ) {
				var oldCache, outerCache,
					newCache = [ dirruns, doneName ];

				// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
				if ( xml ) {
					while ( ( elem = elem[ dir ] ) ) {
						if ( elem.nodeType === 1 || checkNonElements ) {
							if ( matcher( elem, context, xml ) ) {
								return true;
							}
						}
					}
				} else {
					while ( ( elem = elem[ dir ] ) ) {
						if ( elem.nodeType === 1 || checkNonElements ) {
							outerCache = elem[ expando ] || ( elem[ expando ] = {} );

							if ( skip && nodeName( elem, skip ) ) {
								elem = elem[ dir ] || elem;
							} else if ( ( oldCache = outerCache[ key ] ) &&
								oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

								// Assign to newCache so results back-propagate to previous elements
								return ( newCache[ 2 ] = oldCache[ 2 ] );
							} else {

								// Reuse newcache so results back-propagate to previous elements
								outerCache[ key ] = newCache;

								// A match means we're done; a fail means we have to keep checking
								if ( ( newCache[ 2 ] = matcher( elem, context, xml ) ) ) {
									return true;
								}
							}
						}
					}
				}
				return false;
			};
	}

	function elementMatcher( matchers ) {
		return matchers.length > 1 ?
			function( elem, context, xml ) {
				var i = matchers.length;
				while ( i-- ) {
					if ( !matchers[ i ]( elem, context, xml ) ) {
						return false;
					}
				}
				return true;
			} :
			matchers[ 0 ];
	}

	function multipleContexts( selector, contexts, results ) {
		var i = 0,
			len = contexts.length;
		for ( ; i < len; i++ ) {
			find( selector, contexts[ i ], results );
		}
		return results;
	}

	function condense( unmatched, map, filter, context, xml ) {
		var elem,
			newUnmatched = [],
			i = 0,
			len = unmatched.length,
			mapped = map != null;

		for ( ; i < len; i++ ) {
			if ( ( elem = unmatched[ i ] ) ) {
				if ( !filter || filter( elem, context, xml ) ) {
					newUnmatched.push( elem );
					if ( mapped ) {
						map.push( i );
					}
				}
			}
		}

		return newUnmatched;
	}

	function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
		if ( postFilter && !postFilter[ expando ] ) {
			postFilter = setMatcher( postFilter );
		}
		if ( postFinder && !postFinder[ expando ] ) {
			postFinder = setMatcher( postFinder, postSelector );
		}
		return markFunction( function( seed, results, context, xml ) {
			var temp, i, elem, matcherOut,
				preMap = [],
				postMap = [],
				preexisting = results.length,

				// Get initial elements from seed or context
				elems = seed ||
					multipleContexts( selector || "*",
						context.nodeType ? [ context ] : context, [] ),

				// Prefilter to get matcher input, preserving a map for seed-results synchronization
				matcherIn = preFilter && ( seed || !selector ) ?
					condense( elems, preMap, preFilter, context, xml ) :
					elems;

			if ( matcher ) {

				// If we have a postFinder, or filtered seed, or non-seed postFilter
				// or preexisting results,
				matcherOut = postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results;

				// Find primary matches
				matcher( matcherIn, matcherOut, context, xml );
			} else {
				matcherOut = matcherIn;
			}

			// Apply postFilter
			if ( postFilter ) {
				temp = condense( matcherOut, postMap );
				postFilter( temp, [], context, xml );

				// Un-match failing elements by moving them back to matcherIn
				i = temp.length;
				while ( i-- ) {
					if ( ( elem = temp[ i ] ) ) {
						matcherOut[ postMap[ i ] ] = !( matcherIn[ postMap[ i ] ] = elem );
					}
				}
			}

			if ( seed ) {
				if ( postFinder || preFilter ) {
					if ( postFinder ) {

						// Get the final matcherOut by condensing this intermediate into postFinder contexts
						temp = [];
						i = matcherOut.length;
						while ( i-- ) {
							if ( ( elem = matcherOut[ i ] ) ) {

								// Restore matcherIn since elem is not yet a final match
								temp.push( ( matcherIn[ i ] = elem ) );
							}
						}
						postFinder( null, ( matcherOut = [] ), temp, xml );
					}

					// Move matched elements from seed to results to keep them synchronized
					i = matcherOut.length;
					while ( i-- ) {
						if ( ( elem = matcherOut[ i ] ) &&
							( temp = postFinder ? indexOf.call( seed, elem ) : preMap[ i ] ) > -1 ) {

							seed[ temp ] = !( results[ temp ] = elem );
						}
					}
				}

			// Add elements to results, through postFinder if defined
			} else {
				matcherOut = condense(
					matcherOut === results ?
						matcherOut.splice( preexisting, matcherOut.length ) :
						matcherOut
				);
				if ( postFinder ) {
					postFinder( null, results, matcherOut, xml );
				} else {
					push.apply( results, matcherOut );
				}
			}
		} );
	}

	function matcherFromTokens( tokens ) {
		var checkContext, matcher, j,
			len = tokens.length,
			leadingRelative = Expr.relative[ tokens[ 0 ].type ],
			implicitRelative = leadingRelative || Expr.relative[ " " ],
			i = leadingRelative ? 1 : 0,

			// The foundational matcher ensures that elements are reachable from top-level context(s)
			matchContext = addCombinator( function( elem ) {
				return elem === checkContext;
			}, implicitRelative, true ),
			matchAnyContext = addCombinator( function( elem ) {
				return indexOf.call( checkContext, elem ) > -1;
			}, implicitRelative, true ),
			matchers = [ function( elem, context, xml ) {

				// Support: IE 11+, Edge 17 - 18+
				// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
				// two documents; shallow comparisons work.
				// eslint-disable-next-line eqeqeq
				var ret = ( !leadingRelative && ( xml || context != outermostContext ) ) || (
					( checkContext = context ).nodeType ?
						matchContext( elem, context, xml ) :
						matchAnyContext( elem, context, xml ) );

				// Avoid hanging onto element
				// (see https://github.com/jquery/sizzle/issues/299)
				checkContext = null;
				return ret;
			} ];

		for ( ; i < len; i++ ) {
			if ( ( matcher = Expr.relative[ tokens[ i ].type ] ) ) {
				matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];
			} else {
				matcher = Expr.filter[ tokens[ i ].type ].apply( null, tokens[ i ].matches );

				// Return special upon seeing a positional matcher
				if ( matcher[ expando ] ) {

					// Find the next relative operator (if any) for proper handling
					j = ++i;
					for ( ; j < len; j++ ) {
						if ( Expr.relative[ tokens[ j ].type ] ) {
							break;
						}
					}
					return setMatcher(
						i > 1 && elementMatcher( matchers ),
						i > 1 && toSelector(

							// If the preceding token was a descendant combinator, insert an implicit any-element `*`
							tokens.slice( 0, i - 1 )
								.concat( { value: tokens[ i - 2 ].type === " " ? "*" : "" } )
						).replace( rtrimCSS, "$1" ),
						matcher,
						i < j && matcherFromTokens( tokens.slice( i, j ) ),
						j < len && matcherFromTokens( ( tokens = tokens.slice( j ) ) ),
						j < len && toSelector( tokens )
					);
				}
				matchers.push( matcher );
			}
		}

		return elementMatcher( matchers );
	}

	function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
		var bySet = setMatchers.length > 0,
			byElement = elementMatchers.length > 0,
			superMatcher = function( seed, context, xml, results, outermost ) {
				var elem, j, matcher,
					matchedCount = 0,
					i = "0",
					unmatched = seed && [],
					setMatched = [],
					contextBackup = outermostContext,

					// We must always have either seed elements or outermost context
					elems = seed || byElement && Expr.find.TAG( "*", outermost ),

					// Use integer dirruns iff this is the outermost matcher
					dirrunsUnique = ( dirruns += contextBackup == null ? 1 : Math.random() || 0.1 ),
					len = elems.length;

				if ( outermost ) {

					// Support: IE 11+, Edge 17 - 18+
					// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
					// two documents; shallow comparisons work.
					// eslint-disable-next-line eqeqeq
					outermostContext = context == document || context || outermost;
				}

				// Add elements passing elementMatchers directly to results
				// Support: iOS <=7 - 9 only
				// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching
				// elements by id. (see trac-14142)
				for ( ; i !== len && ( elem = elems[ i ] ) != null; i++ ) {
					if ( byElement && elem ) {
						j = 0;

						// Support: IE 11+, Edge 17 - 18+
						// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
						// two documents; shallow comparisons work.
						// eslint-disable-next-line eqeqeq
						if ( !context && elem.ownerDocument != document ) {
							setDocument( elem );
							xml = !documentIsHTML;
						}
						while ( ( matcher = elementMatchers[ j++ ] ) ) {
							if ( matcher( elem, context || document, xml ) ) {
								push.call( results, elem );
								break;
							}
						}
						if ( outermost ) {
							dirruns = dirrunsUnique;
						}
					}

					// Track unmatched elements for set filters
					if ( bySet ) {

						// They will have gone through all possible matchers
						if ( ( elem = !matcher && elem ) ) {
							matchedCount--;
						}

						// Lengthen the array for every element, matched or not
						if ( seed ) {
							unmatched.push( elem );
						}
					}
				}

				// `i` is now the count of elements visited above, and adding it to `matchedCount`
				// makes the latter nonnegative.
				matchedCount += i;

				// Apply set filters to unmatched elements
				// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
				// equals `i`), unless we didn't visit _any_ elements in the above loop because we have
				// no element matchers and no seed.
				// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
				// case, which will result in a "00" `matchedCount` that differs from `i` but is also
				// numerically zero.
				if ( bySet && i !== matchedCount ) {
					j = 0;
					while ( ( matcher = setMatchers[ j++ ] ) ) {
						matcher( unmatched, setMatched, context, xml );
					}

					if ( seed ) {

						// Reintegrate element matches to eliminate the need for sorting
						if ( matchedCount > 0 ) {
							while ( i-- ) {
								if ( !( unmatched[ i ] || setMatched[ i ] ) ) {
									setMatched[ i ] = pop.call( results );
								}
							}
						}

						// Discard index placeholder values to get only actual matches
						setMatched = condense( setMatched );
					}

					// Add matches to results
					push.apply( results, setMatched );

					// Seedless set matches succeeding multiple successful matchers stipulate sorting
					if ( outermost && !seed && setMatched.length > 0 &&
						( matchedCount + setMatchers.length ) > 1 ) {

						jQuery.uniqueSort( results );
					}
				}

				// Override manipulation of globals by nested matchers
				if ( outermost ) {
					dirruns = dirrunsUnique;
					outermostContext = contextBackup;
				}

				return unmatched;
			};

		return bySet ?
			markFunction( superMatcher ) :
			superMatcher;
	}

	function compile( selector, match /* Internal Use Only */ ) {
		var i,
			setMatchers = [],
			elementMatchers = [],
			cached = compilerCache[ selector + " " ];

		if ( !cached ) {

			// Generate a function of recursive functions that can be used to check each element
			if ( !match ) {
				match = tokenize( selector );
			}
			i = match.length;
			while ( i-- ) {
				cached = matcherFromTokens( match[ i ] );
				if ( cached[ expando ] ) {
					setMatchers.push( cached );
				} else {
					elementMatchers.push( cached );
				}
			}

			// Cache the compiled function
			cached = compilerCache( selector,
				matcherFromGroupMatchers( elementMatchers, setMatchers ) );

			// Save selector and tokenization
			cached.selector = selector;
		}
		return cached;
	}

	/**
	 * A low-level selection function that works with jQuery's compiled
	 *  selector functions
	 * @param {String|Function} selector A selector or a pre-compiled
	 *  selector function built with jQuery selector compile
	 * @param {Element} context
	 * @param {Array} [results]
	 * @param {Array} [seed] A set of elements to match against
	 */
	function select( selector, context, results, seed ) {
		var i, tokens, token, type, find,
			compiled = typeof selector === "function" && selector,
			match = !seed && tokenize( ( selector = compiled.selector || selector ) );

		results = results || [];

		// Try to minimize operations if there is only one selector in the list and no seed
		// (the latter of which guarantees us context)
		if ( match.length === 1 ) {

			// Reduce context if the leading compound selector is an ID
			tokens = match[ 0 ] = match[ 0 ].slice( 0 );
			if ( tokens.length > 2 && ( token = tokens[ 0 ] ).type === "ID" &&
					context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[ 1 ].type ] ) {

				context = ( Expr.find.ID(
					token.matches[ 0 ].replace( runescape, funescape ),
					context
				) || [] )[ 0 ];
				if ( !context ) {
					return results;

				// Precompiled matchers will still verify ancestry, so step up a level
				} else if ( compiled ) {
					context = context.parentNode;
				}

				selector = selector.slice( tokens.shift().value.length );
			}

			// Fetch a seed set for right-to-left matching
			i = matchExpr.needsContext.test( selector ) ? 0 : tokens.length;
			while ( i-- ) {
				token = tokens[ i ];

				// Abort if we hit a combinator
				if ( Expr.relative[ ( type = token.type ) ] ) {
					break;
				}
				if ( ( find = Expr.find[ type ] ) ) {

					// Search, expanding context for leading sibling combinators
					if ( ( seed = find(
						token.matches[ 0 ].replace( runescape, funescape ),
						rsibling.test( tokens[ 0 ].type ) &&
							testContext( context.parentNode ) || context
					) ) ) {

						// If seed is empty or no tokens remain, we can return early
						tokens.splice( i, 1 );
						selector = seed.length && toSelector( tokens );
						if ( !selector ) {
							push.apply( results, seed );
							return results;
						}

						break;
					}
				}
			}
		}

		// Compile and execute a filtering function if one is not provided
		// Provide `match` to avoid retokenization if we modified the selector above
		( compiled || compile( selector, match ) )(
			seed,
			context,
			!documentIsHTML,
			results,
			!context || rsibling.test( selector ) && testContext( context.parentNode ) || context
		);
		return results;
	}

	// One-time assignments

	// Support: Android <=4.0 - 4.1+
	// Sort stability
	support.sortStable = expando.split( "" ).sort( sortOrder ).join( "" ) === expando;

	// Initialize against the default document
	setDocument();

	// Support: Android <=4.0 - 4.1+
	// Detached nodes confoundingly follow *each other*
	support.sortDetached = assert( function( el ) {

		// Should return 1, but returns 4 (following)
		return el.compareDocumentPosition( document.createElement( "fieldset" ) ) & 1;
	} );

	jQuery.find = find;

	// Deprecated
	jQuery.expr[ ":" ] = jQuery.expr.pseudos;
	jQuery.unique = jQuery.uniqueSort;

	// These have always been private, but they used to be documented as part of
	// Sizzle so let's maintain them for now for backwards compatibility purposes.
	find.compile = compile;
	find.select = select;
	find.setDocument = setDocument;
	find.tokenize = tokenize;

	find.escape = jQuery.escapeSelector;
	find.getText = jQuery.text;
	find.isXML = jQuery.isXMLDoc;
	find.selectors = jQuery.expr;
	find.support = jQuery.support;
	find.uniqueSort = jQuery.uniqueSort;

		/* eslint-enable */

	} )();


	var dir = function( elem, dir, until ) {
		var matched = [],
			truncate = until !== undefined;

		while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
			if ( elem.nodeType === 1 ) {
				if ( truncate && jQuery( elem ).is( until ) ) {
					break;
				}
				matched.push( elem );
			}
		}
		return matched;
	};


	var siblings = function( n, elem ) {
		var matched = [];

		for ( ; n; n = n.nextSibling ) {
			if ( n.nodeType === 1 && n !== elem ) {
				matched.push( n );
			}
		}

		return matched;
	};


	var rneedsContext = jQuery.expr.match.needsContext;

	var rsingleTag = ( /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i );



	// Implement the identical functionality for filter and not
	function winnow( elements, qualifier, not ) {
		if ( isFunction( qualifier ) ) {
			return jQuery.grep( elements, function( elem, i ) {
				return !!qualifier.call( elem, i, elem ) !== not;
			} );
		}

		// Single element
		if ( qualifier.nodeType ) {
			return jQuery.grep( elements, function( elem ) {
				return ( elem === qualifier ) !== not;
			} );
		}

		// Arraylike of elements (jQuery, arguments, Array)
		if ( typeof qualifier !== "string" ) {
			return jQuery.grep( elements, function( elem ) {
				return ( indexOf.call( qualifier, elem ) > -1 ) !== not;
			} );
		}

		// Filtered directly for both simple and complex selectors
		return jQuery.filter( qualifier, elements, not );
	}

	jQuery.filter = function( expr, elems, not ) {
		var elem = elems[ 0 ];

		if ( not ) {
			expr = ":not(" + expr + ")";
		}

		if ( elems.length === 1 && elem.nodeType === 1 ) {
			return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];
		}

		return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
			return elem.nodeType === 1;
		} ) );
	};

	jQuery.fn.extend( {
		find: function( selector ) {
			var i, ret,
				len = this.length,
				self = this;

			if ( typeof selector !== "string" ) {
				return this.pushStack( jQuery( selector ).filter( function() {
					for ( i = 0; i < len; i++ ) {
						if ( jQuery.contains( self[ i ], this ) ) {
							return true;
						}
					}
				} ) );
			}

			ret = this.pushStack( [] );

			for ( i = 0; i < len; i++ ) {
				jQuery.find( selector, self[ i ], ret );
			}

			return len > 1 ? jQuery.uniqueSort( ret ) : ret;
		},
		filter: function( selector ) {
			return this.pushStack( winnow( this, selector || [], false ) );
		},
		not: function( selector ) {
			return this.pushStack( winnow( this, selector || [], true ) );
		},
		is: function( selector ) {
			return !!winnow(
				this,

				// If this is a positional/relative selector, check membership in the returned set
				// so $("p:first").is("p:last") won't return true for a doc with two "p".
				typeof selector === "string" && rneedsContext.test( selector ) ?
					jQuery( selector ) :
					selector || [],
				false
			).length;
		}
	} );


	// Initialize a jQuery object


	// A central reference to the root jQuery(document)
	var rootjQuery,

		// A simple way to check for HTML strings
		// Prioritize #id over <tag> to avoid XSS via location.hash (trac-9521)
		// Strict HTML recognition (trac-11290: must start with <)
		// Shortcut simple #id case for speed
		rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,

		init = jQuery.fn.init = function( selector, context, root ) {
			var match, elem;

			// HANDLE: $(""), $(null), $(undefined), $(false)
			if ( !selector ) {
				return this;
			}

			// Method init() accepts an alternate rootjQuery
			// so migrate can support jQuery.sub (gh-2101)
			root = root || rootjQuery;

			// Handle HTML strings
			if ( typeof selector === "string" ) {
				if ( selector[ 0 ] === "<" &&
					selector[ selector.length - 1 ] === ">" &&
					selector.length >= 3 ) {

					// Assume that strings that start and end with <> are HTML and skip the regex check
					match = [ null, selector, null ];

				} else {
					match = rquickExpr.exec( selector );
				}

				// Match html or make sure no context is specified for #id
				if ( match && ( match[ 1 ] || !context ) ) {

					// HANDLE: $(html) -> $(array)
					if ( match[ 1 ] ) {
						context = context instanceof jQuery ? context[ 0 ] : context;

						// Option to run scripts is true for back-compat
						// Intentionally let the error be thrown if parseHTML is not present
						jQuery.merge( this, jQuery.parseHTML(
							match[ 1 ],
							context && context.nodeType ? context.ownerDocument || context : document,
							true
						) );

						// HANDLE: $(html, props)
						if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
							for ( match in context ) {

								// Properties of context are called as methods if possible
								if ( isFunction( this[ match ] ) ) {
									this[ match ]( context[ match ] );

								// ...and otherwise set as attributes
								} else {
									this.attr( match, context[ match ] );
								}
							}
						}

						return this;

					// HANDLE: $(#id)
					} else {
						elem = document.getElementById( match[ 2 ] );

						if ( elem ) {

							// Inject the element directly into the jQuery object
							this[ 0 ] = elem;
							this.length = 1;
						}
						return this;
					}

				// HANDLE: $(expr, $(...))
				} else if ( !context || context.jquery ) {
					return ( context || root ).find( selector );

				// HANDLE: $(expr, context)
				// (which is just equivalent to: $(context).find(expr)
				} else {
					return this.constructor( context ).find( selector );
				}

			// HANDLE: $(DOMElement)
			} else if ( selector.nodeType ) {
				this[ 0 ] = selector;
				this.length = 1;
				return this;

			// HANDLE: $(function)
			// Shortcut for document ready
			} else if ( isFunction( selector ) ) {
				return root.ready !== undefined ?
					root.ready( selector ) :

					// Execute immediately if ready is not present
					selector( jQuery );
			}

			return jQuery.makeArray( selector, this );
		};

	// Give the init function the jQuery prototype for later instantiation
	init.prototype = jQuery.fn;

	// Initialize central reference
	rootjQuery = jQuery( document );


	var rparentsprev = /^(?:parents|prev(?:Until|All))/,

		// Methods guaranteed to produce a unique set when starting from a unique set
		guaranteedUnique = {
			children: true,
			contents: true,
			next: true,
			prev: true
		};

	jQuery.fn.extend( {
		has: function( target ) {
			var targets = jQuery( target, this ),
				l = targets.length;

			return this.filter( function() {
				var i = 0;
				for ( ; i < l; i++ ) {
					if ( jQuery.contains( this, targets[ i ] ) ) {
						return true;
					}
				}
			} );
		},

		closest: function( selectors, context ) {
			var cur,
				i = 0,
				l = this.length,
				matched = [],
				targets = typeof selectors !== "string" && jQuery( selectors );

			// Positional selectors never match, since there's no _selection_ context
			if ( !rneedsContext.test( selectors ) ) {
				for ( ; i < l; i++ ) {
					for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

						// Always skip document fragments
						if ( cur.nodeType < 11 && ( targets ?
							targets.index( cur ) > -1 :

							// Don't pass non-elements to jQuery#find
							cur.nodeType === 1 &&
								jQuery.find.matchesSelector( cur, selectors ) ) ) {

							matched.push( cur );
							break;
						}
					}
				}
			}

			return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
		},

		// Determine the position of an element within the set
		index: function( elem ) {

			// No argument, return index in parent
			if ( !elem ) {
				return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
			}

			// Index in selector
			if ( typeof elem === "string" ) {
				return indexOf.call( jQuery( elem ), this[ 0 ] );
			}

			// Locate the position of the desired element
			return indexOf.call( this,

				// If it receives a jQuery object, the first element is used
				elem.jquery ? elem[ 0 ] : elem
			);
		},

		add: function( selector, context ) {
			return this.pushStack(
				jQuery.uniqueSort(
					jQuery.merge( this.get(), jQuery( selector, context ) )
				)
			);
		},

		addBack: function( selector ) {
			return this.add( selector == null ?
				this.prevObject : this.prevObject.filter( selector )
			);
		}
	} );

	function sibling( cur, dir ) {
		while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
		return cur;
	}

	jQuery.each( {
		parent: function( elem ) {
			var parent = elem.parentNode;
			return parent && parent.nodeType !== 11 ? parent : null;
		},
		parents: function( elem ) {
			return dir( elem, "parentNode" );
		},
		parentsUntil: function( elem, _i, until ) {
			return dir( elem, "parentNode", until );
		},
		next: function( elem ) {
			return sibling( elem, "nextSibling" );
		},
		prev: function( elem ) {
			return sibling( elem, "previousSibling" );
		},
		nextAll: function( elem ) {
			return dir( elem, "nextSibling" );
		},
		prevAll: function( elem ) {
			return dir( elem, "previousSibling" );
		},
		nextUntil: function( elem, _i, until ) {
			return dir( elem, "nextSibling", until );
		},
		prevUntil: function( elem, _i, until ) {
			return dir( elem, "previousSibling", until );
		},
		siblings: function( elem ) {
			return siblings( ( elem.parentNode || {} ).firstChild, elem );
		},
		children: function( elem ) {
			return siblings( elem.firstChild );
		},
		contents: function( elem ) {
			if ( elem.contentDocument != null &&

				// Support: IE 11+
				// <object> elements with no `data` attribute has an object
				// `contentDocument` with a `null` prototype.
				getProto( elem.contentDocument ) ) {

				return elem.contentDocument;
			}

			// Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
			// Treat the template element as a regular one in browsers that
			// don't support it.
			if ( nodeName( elem, "template" ) ) {
				elem = elem.content || elem;
			}

			return jQuery.merge( [], elem.childNodes );
		}
	}, function( name, fn ) {
		jQuery.fn[ name ] = function( until, selector ) {
			var matched = jQuery.map( this, fn, until );

			if ( name.slice( -5 ) !== "Until" ) {
				selector = until;
			}

			if ( selector && typeof selector === "string" ) {
				matched = jQuery.filter( selector, matched );
			}

			if ( this.length > 1 ) {

				// Remove duplicates
				if ( !guaranteedUnique[ name ] ) {
					jQuery.uniqueSort( matched );
				}

				// Reverse order for parents* and prev-derivatives
				if ( rparentsprev.test( name ) ) {
					matched.reverse();
				}
			}

			return this.pushStack( matched );
		};
	} );
	var rnothtmlwhite = ( /[^\x20\t\r\n\f]+/g );



	// Convert String-formatted options into Object-formatted ones
	function createOptions( options ) {
		var object = {};
		jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {
			object[ flag ] = true;
		} );
		return object;
	}

	/*
	 * Create a callback list using the following parameters:
	 *
	 *	options: an optional list of space-separated options that will change how
	 *			the callback list behaves or a more traditional option object
	 *
	 * By default a callback list will act like an event callback list and can be
	 * "fired" multiple times.
	 *
	 * Possible options:
	 *
	 *	once:			will ensure the callback list can only be fired once (like a Deferred)
	 *
	 *	memory:			will keep track of previous values and will call any callback added
	 *					after the list has been fired right away with the latest "memorized"
	 *					values (like a Deferred)
	 *
	 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
	 *
	 *	stopOnFalse:	interrupt callings when a callback returns false
	 *
	 */
	jQuery.Callbacks = function( options ) {

		// Convert options from String-formatted to Object-formatted if needed
		// (we check in cache first)
		options = typeof options === "string" ?
			createOptions( options ) :
			jQuery.extend( {}, options );

		var // Flag to know if list is currently firing
			firing,

			// Last fire value for non-forgettable lists
			memory,

			// Flag to know if list was already fired
			fired,

			// Flag to prevent firing
			locked,

			// Actual callback list
			list = [],

			// Queue of execution data for repeatable lists
			queue = [],

			// Index of currently firing callback (modified by add/remove as needed)
			firingIndex = -1,

			// Fire callbacks
			fire = function() {

				// Enforce single-firing
				locked = locked || options.once;

				// Execute callbacks for all pending executions,
				// respecting firingIndex overrides and runtime changes
				fired = firing = true;
				for ( ; queue.length; firingIndex = -1 ) {
					memory = queue.shift();
					while ( ++firingIndex < list.length ) {

						// Run callback and check for early termination
						if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
							options.stopOnFalse ) {

							// Jump to end and forget the data so .add doesn't re-fire
							firingIndex = list.length;
							memory = false;
						}
					}
				}

				// Forget the data if we're done with it
				if ( !options.memory ) {
					memory = false;
				}

				firing = false;

				// Clean up if we're done firing for good
				if ( locked ) {

					// Keep an empty list if we have data for future add calls
					if ( memory ) {
						list = [];

					// Otherwise, this object is spent
					} else {
						list = "";
					}
				}
			},

			// Actual Callbacks object
			self = {

				// Add a callback or a collection of callbacks to the list
				add: function() {
					if ( list ) {

						// If we have memory from a past run, we should fire after adding
						if ( memory && !firing ) {
							firingIndex = list.length - 1;
							queue.push( memory );
						}

						( function add( args ) {
							jQuery.each( args, function( _, arg ) {
								if ( isFunction( arg ) ) {
									if ( !options.unique || !self.has( arg ) ) {
										list.push( arg );
									}
								} else if ( arg && arg.length && toType( arg ) !== "string" ) {

									// Inspect recursively
									add( arg );
								}
							} );
						} )( arguments );

						if ( memory && !firing ) {
							fire();
						}
					}
					return this;
				},

				// Remove a callback from the list
				remove: function() {
					jQuery.each( arguments, function( _, arg ) {
						var index;
						while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
							list.splice( index, 1 );

							// Handle firing indexes
							if ( index <= firingIndex ) {
								firingIndex--;
							}
						}
					} );
					return this;
				},

				// Check if a given callback is in the list.
				// If no argument is given, return whether or not list has callbacks attached.
				has: function( fn ) {
					return fn ?
						jQuery.inArray( fn, list ) > -1 :
						list.length > 0;
				},

				// Remove all callbacks from the list
				empty: function() {
					if ( list ) {
						list = [];
					}
					return this;
				},

				// Disable .fire and .add
				// Abort any current/pending executions
				// Clear all callbacks and values
				disable: function() {
					locked = queue = [];
					list = memory = "";
					return this;
				},
				disabled: function() {
					return !list;
				},

				// Disable .fire
				// Also disable .add unless we have memory (since it would have no effect)
				// Abort any pending executions
				lock: function() {
					locked = queue = [];
					if ( !memory && !firing ) {
						list = memory = "";
					}
					return this;
				},
				locked: function() {
					return !!locked;
				},

				// Call all callbacks with the given context and arguments
				fireWith: function( context, args ) {
					if ( !locked ) {
						args = args || [];
						args = [ context, args.slice ? args.slice() : args ];
						queue.push( args );
						if ( !firing ) {
							fire();
						}
					}
					return this;
				},

				// Call all the callbacks with the given arguments
				fire: function() {
					self.fireWith( this, arguments );
					return this;
				},

				// To know if the callbacks have already been called at least once
				fired: function() {
					return !!fired;
				}
			};

		return self;
	};


	function Identity( v ) {
		return v;
	}
	function Thrower( ex ) {
		throw ex;
	}

	function adoptValue( value, resolve, reject, noValue ) {
		var method;

		try {

			// Check for promise aspect first to privilege synchronous behavior
			if ( value && isFunction( ( method = value.promise ) ) ) {
				method.call( value ).done( resolve ).fail( reject );

			// Other thenables
			} else if ( value && isFunction( ( method = value.then ) ) ) {
				method.call( value, resolve, reject );

			// Other non-thenables
			} else {

				// Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
				// * false: [ value ].slice( 0 ) => resolve( value )
				// * true: [ value ].slice( 1 ) => resolve()
				resolve.apply( undefined, [ value ].slice( noValue ) );
			}

		// For Promises/A+, convert exceptions into rejections
		// Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
		// Deferred#then to conditionally suppress rejection.
		} catch ( value ) {

			// Support: Android 4.0 only
			// Strict mode functions invoked without .call/.apply get global-object context
			reject.apply( undefined, [ value ] );
		}
	}

	jQuery.extend( {

		Deferred: function( func ) {
			var tuples = [

					// action, add listener, callbacks,
					// ... .then handlers, argument index, [final state]
					[ "notify", "progress", jQuery.Callbacks( "memory" ),
						jQuery.Callbacks( "memory" ), 2 ],
					[ "resolve", "done", jQuery.Callbacks( "once memory" ),
						jQuery.Callbacks( "once memory" ), 0, "resolved" ],
					[ "reject", "fail", jQuery.Callbacks( "once memory" ),
						jQuery.Callbacks( "once memory" ), 1, "rejected" ]
				],
				state = "pending",
				promise = {
					state: function() {
						return state;
					},
					always: function() {
						deferred.done( arguments ).fail( arguments );
						return this;
					},
					"catch": function( fn ) {
						return promise.then( null, fn );
					},

					// Keep pipe for back-compat
					pipe: function( /* fnDone, fnFail, fnProgress */ ) {
						var fns = arguments;

						return jQuery.Deferred( function( newDefer ) {
							jQuery.each( tuples, function( _i, tuple ) {

								// Map tuples (progress, done, fail) to arguments (done, fail, progress)
								var fn = isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];

								// deferred.progress(function() { bind to newDefer or newDefer.notify })
								// deferred.done(function() { bind to newDefer or newDefer.resolve })
								// deferred.fail(function() { bind to newDefer or newDefer.reject })
								deferred[ tuple[ 1 ] ]( function() {
									var returned = fn && fn.apply( this, arguments );
									if ( returned && isFunction( returned.promise ) ) {
										returned.promise()
											.progress( newDefer.notify )
											.done( newDefer.resolve )
											.fail( newDefer.reject );
									} else {
										newDefer[ tuple[ 0 ] + "With" ](
											this,
											fn ? [ returned ] : arguments
										);
									}
								} );
							} );
							fns = null;
						} ).promise();
					},
					then: function( onFulfilled, onRejected, onProgress ) {
						var maxDepth = 0;
						function resolve( depth, deferred, handler, special ) {
							return function() {
								var that = this,
									args = arguments,
									mightThrow = function() {
										var returned, then;

										// Support: Promises/A+ section 2.3.3.3.3
										// https://promisesaplus.com/#point-59
										// Ignore double-resolution attempts
										if ( depth < maxDepth ) {
											return;
										}

										returned = handler.apply( that, args );

										// Support: Promises/A+ section 2.3.1
										// https://promisesaplus.com/#point-48
										if ( returned === deferred.promise() ) {
											throw new TypeError( "Thenable self-resolution" );
										}

										// Support: Promises/A+ sections 2.3.3.1, 3.5
										// https://promisesaplus.com/#point-54
										// https://promisesaplus.com/#point-75
										// Retrieve `then` only once
										then = returned &&

											// Support: Promises/A+ section 2.3.4
											// https://promisesaplus.com/#point-64
											// Only check objects and functions for thenability
											( typeof returned === "object" ||
												typeof returned === "function" ) &&
											returned.then;

										// Handle a returned thenable
										if ( isFunction( then ) ) {

											// Special processors (notify) just wait for resolution
											if ( special ) {
												then.call(
													returned,
													resolve( maxDepth, deferred, Identity, special ),
													resolve( maxDepth, deferred, Thrower, special )
												);

											// Normal processors (resolve) also hook into progress
											} else {

												// ...and disregard older resolution values
												maxDepth++;

												then.call(
													returned,
													resolve( maxDepth, deferred, Identity, special ),
													resolve( maxDepth, deferred, Thrower, special ),
													resolve( maxDepth, deferred, Identity,
														deferred.notifyWith )
												);
											}

										// Handle all other returned values
										} else {

											// Only substitute handlers pass on context
											// and multiple values (non-spec behavior)
											if ( handler !== Identity ) {
												that = undefined;
												args = [ returned ];
											}

											// Process the value(s)
											// Default process is resolve
											( special || deferred.resolveWith )( that, args );
										}
									},

									// Only normal processors (resolve) catch and reject exceptions
									process = special ?
										mightThrow :
										function() {
											try {
												mightThrow();
											} catch ( e ) {

												if ( jQuery.Deferred.exceptionHook ) {
													jQuery.Deferred.exceptionHook( e,
														process.error );
												}

												// Support: Promises/A+ section 2.3.3.3.4.1
												// https://promisesaplus.com/#point-61
												// Ignore post-resolution exceptions
												if ( depth + 1 >= maxDepth ) {

													// Only substitute handlers pass on context
													// and multiple values (non-spec behavior)
													if ( handler !== Thrower ) {
														that = undefined;
														args = [ e ];
													}

													deferred.rejectWith( that, args );
												}
											}
										};

								// Support: Promises/A+ section 2.3.3.3.1
								// https://promisesaplus.com/#point-57
								// Re-resolve promises immediately to dodge false rejection from
								// subsequent errors
								if ( depth ) {
									process();
								} else {

									// Call an optional hook to record the error, in case of exception
									// since it's otherwise lost when execution goes async
									if ( jQuery.Deferred.getErrorHook ) {
										process.error = jQuery.Deferred.getErrorHook();

									// The deprecated alias of the above. While the name suggests
									// returning the stack, not an error instance, jQuery just passes
									// it directly to `console.warn` so both will work; an instance
									// just better cooperates with source maps.
									} else if ( jQuery.Deferred.getStackHook ) {
										process.error = jQuery.Deferred.getStackHook();
									}
									window.setTimeout( process );
								}
							};
						}

						return jQuery.Deferred( function( newDefer ) {

							// progress_handlers.add( ... )
							tuples[ 0 ][ 3 ].add(
								resolve(
									0,
									newDefer,
									isFunction( onProgress ) ?
										onProgress :
										Identity,
									newDefer.notifyWith
								)
							);

							// fulfilled_handlers.add( ... )
							tuples[ 1 ][ 3 ].add(
								resolve(
									0,
									newDefer,
									isFunction( onFulfilled ) ?
										onFulfilled :
										Identity
								)
							);

							// rejected_handlers.add( ... )
							tuples[ 2 ][ 3 ].add(
								resolve(
									0,
									newDefer,
									isFunction( onRejected ) ?
										onRejected :
										Thrower
								)
							);
						} ).promise();
					},

					// Get a promise for this deferred
					// If obj is provided, the promise aspect is added to the object
					promise: function( obj ) {
						return obj != null ? jQuery.extend( obj, promise ) : promise;
					}
				},
				deferred = {};

			// Add list-specific methods
			jQuery.each( tuples, function( i, tuple ) {
				var list = tuple[ 2 ],
					stateString = tuple[ 5 ];

				// promise.progress = list.add
				// promise.done = list.add
				// promise.fail = list.add
				promise[ tuple[ 1 ] ] = list.add;

				// Handle state
				if ( stateString ) {
					list.add(
						function() {

							// state = "resolved" (i.e., fulfilled)
							// state = "rejected"
							state = stateString;
						},

						// rejected_callbacks.disable
						// fulfilled_callbacks.disable
						tuples[ 3 - i ][ 2 ].disable,

						// rejected_handlers.disable
						// fulfilled_handlers.disable
						tuples[ 3 - i ][ 3 ].disable,

						// progress_callbacks.lock
						tuples[ 0 ][ 2 ].lock,

						// progress_handlers.lock
						tuples[ 0 ][ 3 ].lock
					);
				}

				// progress_handlers.fire
				// fulfilled_handlers.fire
				// rejected_handlers.fire
				list.add( tuple[ 3 ].fire );

				// deferred.notify = function() { deferred.notifyWith(...) }
				// deferred.resolve = function() { deferred.resolveWith(...) }
				// deferred.reject = function() { deferred.rejectWith(...) }
				deferred[ tuple[ 0 ] ] = function() {
					deferred[ tuple[ 0 ] + "With" ]( this === deferred ? undefined : this, arguments );
					return this;
				};

				// deferred.notifyWith = list.fireWith
				// deferred.resolveWith = list.fireWith
				// deferred.rejectWith = list.fireWith
				deferred[ tuple[ 0 ] + "With" ] = list.fireWith;
			} );

			// Make the deferred a promise
			promise.promise( deferred );

			// Call given func if any
			if ( func ) {
				func.call( deferred, deferred );
			}

			// All done!
			return deferred;
		},

		// Deferred helper
		when: function( singleValue ) {
			var

				// count of uncompleted subordinates
				remaining = arguments.length,

				// count of unprocessed arguments
				i = remaining,

				// subordinate fulfillment data
				resolveContexts = Array( i ),
				resolveValues = slice.call( arguments ),

				// the primary Deferred
				primary = jQuery.Deferred(),

				// subordinate callback factory
				updateFunc = function( i ) {
					return function( value ) {
						resolveContexts[ i ] = this;
						resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
						if ( !( --remaining ) ) {
							primary.resolveWith( resolveContexts, resolveValues );
						}
					};
				};

			// Single- and empty arguments are adopted like Promise.resolve
			if ( remaining <= 1 ) {
				adoptValue( singleValue, primary.done( updateFunc( i ) ).resolve, primary.reject,
					!remaining );

				// Use .then() to unwrap secondary thenables (cf. gh-3000)
				if ( primary.state() === "pending" ||
					isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {

					return primary.then();
				}
			}

			// Multiple arguments are aggregated like Promise.all array elements
			while ( i-- ) {
				adoptValue( resolveValues[ i ], updateFunc( i ), primary.reject );
			}

			return primary.promise();
		}
	} );


	// These usually indicate a programmer mistake during development,
	// warn about them ASAP rather than swallowing them by default.
	var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

	// If `jQuery.Deferred.getErrorHook` is defined, `asyncError` is an error
	// captured before the async barrier to get the original error cause
	// which may otherwise be hidden.
	jQuery.Deferred.exceptionHook = function( error, asyncError ) {

		// Support: IE 8 - 9 only
		// Console exists when dev tools are open, which can happen at any time
		if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {
			window.console.warn( "jQuery.Deferred exception: " + error.message,
				error.stack, asyncError );
		}
	};




	jQuery.readyException = function( error ) {
		window.setTimeout( function() {
			throw error;
		} );
	};




	// The deferred used on DOM ready
	var readyList = jQuery.Deferred();

	jQuery.fn.ready = function( fn ) {

		readyList
			.then( fn )

			// Wrap jQuery.readyException in a function so that the lookup
			// happens at the time of error handling instead of callback
			// registration.
			.catch( function( error ) {
				jQuery.readyException( error );
			} );

		return this;
	};

	jQuery.extend( {

		// Is the DOM ready to be used? Set to true once it occurs.
		isReady: false,

		// A counter to track how many items to wait for before
		// the ready event fires. See trac-6781
		readyWait: 1,

		// Handle when the DOM is ready
		ready: function( wait ) {

			// Abort if there are pending holds or we're already ready
			if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
				return;
			}

			// Remember that the DOM is ready
			jQuery.isReady = true;

			// If a normal DOM Ready event fired, decrement, and wait if need be
			if ( wait !== true && --jQuery.readyWait > 0 ) {
				return;
			}

			// If there are functions bound, to execute
			readyList.resolveWith( document, [ jQuery ] );
		}
	} );

	jQuery.ready.then = readyList.then;

	// The ready event handler and self cleanup method
	function completed() {
		document.removeEventListener( "DOMContentLoaded", completed );
		window.removeEventListener( "load", completed );
		jQuery.ready();
	}

	// Catch cases where $(document).ready() is called
	// after the browser event has already occurred.
	// Support: IE <=9 - 10 only
	// Older IE sometimes signals "interactive" too soon
	if ( document.readyState === "complete" ||
		( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {

		// Handle it asynchronously to allow scripts the opportunity to delay ready
		window.setTimeout( jQuery.ready );

	} else {

		// Use the handy event callback
		document.addEventListener( "DOMContentLoaded", completed );

		// A fallback to window.onload, that will always work
		window.addEventListener( "load", completed );
	}




	// Multifunctional method to get and set values of a collection
	// The value/s can optionally be executed if it's a function
	var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
		var i = 0,
			len = elems.length,
			bulk = key == null;

		// Sets many values
		if ( toType( key ) === "object" ) {
			chainable = true;
			for ( i in key ) {
				access( elems, fn, i, key[ i ], true, emptyGet, raw );
			}

		// Sets one value
		} else if ( value !== undefined ) {
			chainable = true;

			if ( !isFunction( value ) ) {
				raw = true;
			}

			if ( bulk ) {

				// Bulk operations run against the entire set
				if ( raw ) {
					fn.call( elems, value );
					fn = null;

				// ...except when executing function values
				} else {
					bulk = fn;
					fn = function( elem, _key, value ) {
						return bulk.call( jQuery( elem ), value );
					};
				}
			}

			if ( fn ) {
				for ( ; i < len; i++ ) {
					fn(
						elems[ i ], key, raw ?
							value :
							value.call( elems[ i ], i, fn( elems[ i ], key ) )
					);
				}
			}
		}

		if ( chainable ) {
			return elems;
		}

		// Gets
		if ( bulk ) {
			return fn.call( elems );
		}

		return len ? fn( elems[ 0 ], key ) : emptyGet;
	};


	// Matches dashed string for camelizing
	var rmsPrefix = /^-ms-/,
		rdashAlpha = /-([a-z])/g;

	// Used by camelCase as callback to replace()
	function fcamelCase( _all, letter ) {
		return letter.toUpperCase();
	}

	// Convert dashed to camelCase; used by the css and data modules
	// Support: IE <=9 - 11, Edge 12 - 15
	// Microsoft forgot to hump their vendor prefix (trac-9572)
	function camelCase( string ) {
		return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
	}
	var acceptData = function( owner ) {

		// Accepts only:
		//  - Node
		//    - Node.ELEMENT_NODE
		//    - Node.DOCUMENT_NODE
		//  - Object
		//    - Any
		return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );
	};




	function Data() {
		this.expando = jQuery.expando + Data.uid++;
	}

	Data.uid = 1;

	Data.prototype = {

		cache: function( owner ) {

			// Check if the owner object already has a cache
			var value = owner[ this.expando ];

			// If not, create one
			if ( !value ) {
				value = {};

				// We can accept data for non-element nodes in modern browsers,
				// but we should not, see trac-8335.
				// Always return an empty object.
				if ( acceptData( owner ) ) {

					// If it is a node unlikely to be stringify-ed or looped over
					// use plain assignment
					if ( owner.nodeType ) {
						owner[ this.expando ] = value;

					// Otherwise secure it in a non-enumerable property
					// configurable must be true to allow the property to be
					// deleted when data is removed
					} else {
						Object.defineProperty( owner, this.expando, {
							value: value,
							configurable: true
						} );
					}
				}
			}

			return value;
		},
		set: function( owner, data, value ) {
			var prop,
				cache = this.cache( owner );

			// Handle: [ owner, key, value ] args
			// Always use camelCase key (gh-2257)
			if ( typeof data === "string" ) {
				cache[ camelCase( data ) ] = value;

			// Handle: [ owner, { properties } ] args
			} else {

				// Copy the properties one-by-one to the cache object
				for ( prop in data ) {
					cache[ camelCase( prop ) ] = data[ prop ];
				}
			}
			return cache;
		},
		get: function( owner, key ) {
			return key === undefined ?
				this.cache( owner ) :

				// Always use camelCase key (gh-2257)
				owner[ this.expando ] && owner[ this.expando ][ camelCase( key ) ];
		},
		access: function( owner, key, value ) {

			// In cases where either:
			//
			//   1. No key was specified
			//   2. A string key was specified, but no value provided
			//
			// Take the "read" path and allow the get method to determine
			// which value to return, respectively either:
			//
			//   1. The entire cache object
			//   2. The data stored at the key
			//
			if ( key === undefined ||
					( ( key && typeof key === "string" ) && value === undefined ) ) {

				return this.get( owner, key );
			}

			// When the key is not a string, or both a key and value
			// are specified, set or extend (existing objects) with either:
			//
			//   1. An object of properties
			//   2. A key and value
			//
			this.set( owner, key, value );

			// Since the "set" path can have two possible entry points
			// return the expected data based on which path was taken[*]
			return value !== undefined ? value : key;
		},
		remove: function( owner, key ) {
			var i,
				cache = owner[ this.expando ];

			if ( cache === undefined ) {
				return;
			}

			if ( key !== undefined ) {

				// Support array or space separated string of keys
				if ( Array.isArray( key ) ) {

					// If key is an array of keys...
					// We always set camelCase keys, so remove that.
					key = key.map( camelCase );
				} else {
					key = camelCase( key );

					// If a key with the spaces exists, use it.
					// Otherwise, create an array by matching non-whitespace
					key = key in cache ?
						[ key ] :
						( key.match( rnothtmlwhite ) || [] );
				}

				i = key.length;

				while ( i-- ) {
					delete cache[ key[ i ] ];
				}
			}

			// Remove the expando if there's no more data
			if ( key === undefined || jQuery.isEmptyObject( cache ) ) {

				// Support: Chrome <=35 - 45
				// Webkit & Blink performance suffers when deleting properties
				// from DOM nodes, so set to undefined instead
				// https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
				if ( owner.nodeType ) {
					owner[ this.expando ] = undefined;
				} else {
					delete owner[ this.expando ];
				}
			}
		},
		hasData: function( owner ) {
			var cache = owner[ this.expando ];
			return cache !== undefined && !jQuery.isEmptyObject( cache );
		}
	};
	var dataPriv = new Data();

	var dataUser = new Data();



	//	Implementation Summary
	//
	//	1. Enforce API surface and semantic compatibility with 1.9.x branch
	//	2. Improve the module's maintainability by reducing the storage
	//		paths to a single mechanism.
	//	3. Use the same single mechanism to support "private" and "user" data.
	//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
	//	5. Avoid exposing implementation details on user objects (eg. expando properties)
	//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

	var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
		rmultiDash = /[A-Z]/g;

	function getData( data ) {
		if ( data === "true" ) {
			return true;
		}

		if ( data === "false" ) {
			return false;
		}

		if ( data === "null" ) {
			return null;
		}

		// Only convert to a number if it doesn't change the string
		if ( data === +data + "" ) {
			return +data;
		}

		if ( rbrace.test( data ) ) {
			return JSON.parse( data );
		}

		return data;
	}

	function dataAttr( elem, key, data ) {
		var name;

		// If nothing was found internally, try to fetch any
		// data from the HTML5 data-* attribute
		if ( data === undefined && elem.nodeType === 1 ) {
			name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();
			data = elem.getAttribute( name );

			if ( typeof data === "string" ) {
				try {
					data = getData( data );
				} catch ( e ) {}

				// Make sure we set the data so it isn't changed later
				dataUser.set( elem, key, data );
			} else {
				data = undefined;
			}
		}
		return data;
	}

	jQuery.extend( {
		hasData: function( elem ) {
			return dataUser.hasData( elem ) || dataPriv.hasData( elem );
		},

		data: function( elem, name, data ) {
			return dataUser.access( elem, name, data );
		},

		removeData: function( elem, name ) {
			dataUser.remove( elem, name );
		},

		// TODO: Now that all calls to _data and _removeData have been replaced
		// with direct calls to dataPriv methods, these can be deprecated.
		_data: function( elem, name, data ) {
			return dataPriv.access( elem, name, data );
		},

		_removeData: function( elem, name ) {
			dataPriv.remove( elem, name );
		}
	} );

	jQuery.fn.extend( {
		data: function( key, value ) {
			var i, name, data,
				elem = this[ 0 ],
				attrs = elem && elem.attributes;

			// Gets all values
			if ( key === undefined ) {
				if ( this.length ) {
					data = dataUser.get( elem );

					if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {
						i = attrs.length;
						while ( i-- ) {

							// Support: IE 11 only
							// The attrs elements can be null (trac-14894)
							if ( attrs[ i ] ) {
								name = attrs[ i ].name;
								if ( name.indexOf( "data-" ) === 0 ) {
									name = camelCase( name.slice( 5 ) );
									dataAttr( elem, name, data[ name ] );
								}
							}
						}
						dataPriv.set( elem, "hasDataAttrs", true );
					}
				}

				return data;
			}

			// Sets multiple values
			if ( typeof key === "object" ) {
				return this.each( function() {
					dataUser.set( this, key );
				} );
			}

			return access( this, function( value ) {
				var data;

				// The calling jQuery object (element matches) is not empty
				// (and therefore has an element appears at this[ 0 ]) and the
				// `value` parameter was not undefined. An empty jQuery object
				// will result in `undefined` for elem = this[ 0 ] which will
				// throw an exception if an attempt to read a data cache is made.
				if ( elem && value === undefined ) {

					// Attempt to get data from the cache
					// The key will always be camelCased in Data
					data = dataUser.get( elem, key );
					if ( data !== undefined ) {
						return data;
					}

					// Attempt to "discover" the data in
					// HTML5 custom data-* attrs
					data = dataAttr( elem, key );
					if ( data !== undefined ) {
						return data;
					}

					// We tried really hard, but the data doesn't exist.
					return;
				}

				// Set the data...
				this.each( function() {

					// We always store the camelCased key
					dataUser.set( this, key, value );
				} );
			}, null, value, arguments.length > 1, null, true );
		},

		removeData: function( key ) {
			return this.each( function() {
				dataUser.remove( this, key );
			} );
		}
	} );


	jQuery.extend( {
		queue: function( elem, type, data ) {
			var queue;

			if ( elem ) {
				type = ( type || "fx" ) + "queue";
				queue = dataPriv.get( elem, type );

				// Speed up dequeue by getting out quickly if this is just a lookup
				if ( data ) {
					if ( !queue || Array.isArray( data ) ) {
						queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );
					} else {
						queue.push( data );
					}
				}
				return queue || [];
			}
		},

		dequeue: function( elem, type ) {
			type = type || "fx";

			var queue = jQuery.queue( elem, type ),
				startLength = queue.length,
				fn = queue.shift(),
				hooks = jQuery._queueHooks( elem, type ),
				next = function() {
					jQuery.dequeue( elem, type );
				};

			// If the fx queue is dequeued, always remove the progress sentinel
			if ( fn === "inprogress" ) {
				fn = queue.shift();
				startLength--;
			}

			if ( fn ) {

				// Add a progress sentinel to prevent the fx queue from being
				// automatically dequeued
				if ( type === "fx" ) {
					queue.unshift( "inprogress" );
				}

				// Clear up the last queue stop function
				delete hooks.stop;
				fn.call( elem, next, hooks );
			}

			if ( !startLength && hooks ) {
				hooks.empty.fire();
			}
		},

		// Not public - generate a queueHooks object, or return the current one
		_queueHooks: function( elem, type ) {
			var key = type + "queueHooks";
			return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {
				empty: jQuery.Callbacks( "once memory" ).add( function() {
					dataPriv.remove( elem, [ type + "queue", key ] );
				} )
			} );
		}
	} );

	jQuery.fn.extend( {
		queue: function( type, data ) {
			var setter = 2;

			if ( typeof type !== "string" ) {
				data = type;
				type = "fx";
				setter--;
			}

			if ( arguments.length < setter ) {
				return jQuery.queue( this[ 0 ], type );
			}

			return data === undefined ?
				this :
				this.each( function() {
					var queue = jQuery.queue( this, type, data );

					// Ensure a hooks for this queue
					jQuery._queueHooks( this, type );

					if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {
						jQuery.dequeue( this, type );
					}
				} );
		},
		dequeue: function( type ) {
			return this.each( function() {
				jQuery.dequeue( this, type );
			} );
		},
		clearQueue: function( type ) {
			return this.queue( type || "fx", [] );
		},

		// Get a promise resolved when queues of a certain type
		// are emptied (fx is the type by default)
		promise: function( type, obj ) {
			var tmp,
				count = 1,
				defer = jQuery.Deferred(),
				elements = this,
				i = this.length,
				resolve = function() {
					if ( !( --count ) ) {
						defer.resolveWith( elements, [ elements ] );
					}
				};

			if ( typeof type !== "string" ) {
				obj = type;
				type = undefined;
			}
			type = type || "fx";

			while ( i-- ) {
				tmp = dataPriv.get( elements[ i ], type + "queueHooks" );
				if ( tmp && tmp.empty ) {
					count++;
					tmp.empty.add( resolve );
				}
			}
			resolve();
			return defer.promise( obj );
		}
	} );
	var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;

	var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );


	var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

	var documentElement = document.documentElement;



		var isAttached = function( elem ) {
				return jQuery.contains( elem.ownerDocument, elem );
			},
			composed = { composed: true };

		// Support: IE 9 - 11+, Edge 12 - 18+, iOS 10.0 - 10.2 only
		// Check attachment across shadow DOM boundaries when possible (gh-3504)
		// Support: iOS 10.0-10.2 only
		// Early iOS 10 versions support `attachShadow` but not `getRootNode`,
		// leading to errors. We need to check for `getRootNode`.
		if ( documentElement.getRootNode ) {
			isAttached = function( elem ) {
				return jQuery.contains( elem.ownerDocument, elem ) ||
					elem.getRootNode( composed ) === elem.ownerDocument;
			};
		}
	var isHiddenWithinTree = function( elem, el ) {

			// isHiddenWithinTree might be called from jQuery#filter function;
			// in that case, element will be second argument
			elem = el || elem;

			// Inline style trumps all
			return elem.style.display === "none" ||
				elem.style.display === "" &&

				// Otherwise, check computed style
				// Support: Firefox <=43 - 45
				// Disconnected elements can have computed display: none, so first confirm that elem is
				// in the document.
				isAttached( elem ) &&

				jQuery.css( elem, "display" ) === "none";
		};



	function adjustCSS( elem, prop, valueParts, tween ) {
		var adjusted, scale,
			maxIterations = 20,
			currentValue = tween ?
				function() {
					return tween.cur();
				} :
				function() {
					return jQuery.css( elem, prop, "" );
				},
			initial = currentValue(),
			unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

			// Starting value computation is required for potential unit mismatches
			initialInUnit = elem.nodeType &&
				( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&
				rcssNum.exec( jQuery.css( elem, prop ) );

		if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {

			// Support: Firefox <=54
			// Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
			initial = initial / 2;

			// Trust units reported by jQuery.css
			unit = unit || initialInUnit[ 3 ];

			// Iteratively approximate from a nonzero starting point
			initialInUnit = +initial || 1;

			while ( maxIterations-- ) {

				// Evaluate and update our best guess (doubling guesses that zero out).
				// Finish if the scale equals or crosses 1 (making the old*new product non-positive).
				jQuery.style( elem, prop, initialInUnit + unit );
				if ( ( 1 - scale ) * ( 1 - ( scale = currentValue() / initial || 0.5 ) ) <= 0 ) {
					maxIterations = 0;
				}
				initialInUnit = initialInUnit / scale;

			}

			initialInUnit = initialInUnit * 2;
			jQuery.style( elem, prop, initialInUnit + unit );

			// Make sure we update the tween properties later on
			valueParts = valueParts || [];
		}

		if ( valueParts ) {
			initialInUnit = +initialInUnit || +initial || 0;

			// Apply relative offset (+=/-=) if specified
			adjusted = valueParts[ 1 ] ?
				initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :
				+valueParts[ 2 ];
			if ( tween ) {
				tween.unit = unit;
				tween.start = initialInUnit;
				tween.end = adjusted;
			}
		}
		return adjusted;
	}


	var defaultDisplayMap = {};

	function getDefaultDisplay( elem ) {
		var temp,
			doc = elem.ownerDocument,
			nodeName = elem.nodeName,
			display = defaultDisplayMap[ nodeName ];

		if ( display ) {
			return display;
		}

		temp = doc.body.appendChild( doc.createElement( nodeName ) );
		display = jQuery.css( temp, "display" );

		temp.parentNode.removeChild( temp );

		if ( display === "none" ) {
			display = "block";
		}
		defaultDisplayMap[ nodeName ] = display;

		return display;
	}

	function showHide( elements, show ) {
		var display, elem,
			values = [],
			index = 0,
			length = elements.length;

		// Determine new display value for elements that need to change
		for ( ; index < length; index++ ) {
			elem = elements[ index ];
			if ( !elem.style ) {
				continue;
			}

			display = elem.style.display;
			if ( show ) {

				// Since we force visibility upon cascade-hidden elements, an immediate (and slow)
				// check is required in this first loop unless we have a nonempty display value (either
				// inline or about-to-be-restored)
				if ( display === "none" ) {
					values[ index ] = dataPriv.get( elem, "display" ) || null;
					if ( !values[ index ] ) {
						elem.style.display = "";
					}
				}
				if ( elem.style.display === "" && isHiddenWithinTree( elem ) ) {
					values[ index ] = getDefaultDisplay( elem );
				}
			} else {
				if ( display !== "none" ) {
					values[ index ] = "none";

					// Remember what we're overwriting
					dataPriv.set( elem, "display", display );
				}
			}
		}

		// Set the display of the elements in a second loop to avoid constant reflow
		for ( index = 0; index < length; index++ ) {
			if ( values[ index ] != null ) {
				elements[ index ].style.display = values[ index ];
			}
		}

		return elements;
	}

	jQuery.fn.extend( {
		show: function() {
			return showHide( this, true );
		},
		hide: function() {
			return showHide( this );
		},
		toggle: function( state ) {
			if ( typeof state === "boolean" ) {
				return state ? this.show() : this.hide();
			}

			return this.each( function() {
				if ( isHiddenWithinTree( this ) ) {
					jQuery( this ).show();
				} else {
					jQuery( this ).hide();
				}
			} );
		}
	} );
	var rcheckableType = ( /^(?:checkbox|radio)$/i );

	var rtagName = ( /<([a-z][^\/\0>\x20\t\r\n\f]*)/i );

	var rscriptType = ( /^$|^module$|\/(?:java|ecma)script/i );



	( function() {
		var fragment = document.createDocumentFragment(),
			div = fragment.appendChild( document.createElement( "div" ) ),
			input = document.createElement( "input" );

		// Support: Android 4.0 - 4.3 only
		// Check state lost if the name is set (trac-11217)
		// Support: Windows Web Apps (WWA)
		// `name` and `type` must use .setAttribute for WWA (trac-14901)
		input.setAttribute( "type", "radio" );
		input.setAttribute( "checked", "checked" );
		input.setAttribute( "name", "t" );

		div.appendChild( input );

		// Support: Android <=4.1 only
		// Older WebKit doesn't clone checked state correctly in fragments
		support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

		// Support: IE <=11 only
		// Make sure textarea (and checkbox) defaultValue is properly cloned
		div.innerHTML = "<textarea>x</textarea>";
		support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;

		// Support: IE <=9 only
		// IE <=9 replaces <option> tags with their contents when inserted outside of
		// the select element.
		div.innerHTML = "<option></option>";
		support.option = !!div.lastChild;
	} )();


	// We have to close these tags to support XHTML (trac-13200)
	var wrapMap = {

		// XHTML parsers do not magically insert elements in the
		// same way that tag soup parsers do. So we cannot shorten
		// this by omitting <tbody> or other required elements.
		thead: [ 1, "<table>", "</table>" ],
		col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
		tr: [ 2, "<table><tbody>", "</tbody></table>" ],
		td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

		_default: [ 0, "", "" ]
	};

	wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
	wrapMap.th = wrapMap.td;

	// Support: IE <=9 only
	if ( !support.option ) {
		wrapMap.optgroup = wrapMap.option = [ 1, "<select multiple='multiple'>", "</select>" ];
	}


	function getAll( context, tag ) {

		// Support: IE <=9 - 11 only
		// Use typeof to avoid zero-argument method invocation on host objects (trac-15151)
		var ret;

		if ( typeof context.getElementsByTagName !== "undefined" ) {
			ret = context.getElementsByTagName( tag || "*" );

		} else if ( typeof context.querySelectorAll !== "undefined" ) {
			ret = context.querySelectorAll( tag || "*" );

		} else {
			ret = [];
		}

		if ( tag === undefined || tag && nodeName( context, tag ) ) {
			return jQuery.merge( [ context ], ret );
		}

		return ret;
	}


	// Mark scripts as having already been evaluated
	function setGlobalEval( elems, refElements ) {
		var i = 0,
			l = elems.length;

		for ( ; i < l; i++ ) {
			dataPriv.set(
				elems[ i ],
				"globalEval",
				!refElements || dataPriv.get( refElements[ i ], "globalEval" )
			);
		}
	}


	var rhtml = /<|&#?\w+;/;

	function buildFragment( elems, context, scripts, selection, ignored ) {
		var elem, tmp, tag, wrap, attached, j,
			fragment = context.createDocumentFragment(),
			nodes = [],
			i = 0,
			l = elems.length;

		for ( ; i < l; i++ ) {
			elem = elems[ i ];

			if ( elem || elem === 0 ) {

				// Add nodes directly
				if ( toType( elem ) === "object" ) {

					// Support: Android <=4.0 only, PhantomJS 1 only
					// push.apply(_, arraylike) throws on ancient WebKit
					jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

				// Convert non-html into a text node
				} else if ( !rhtml.test( elem ) ) {
					nodes.push( context.createTextNode( elem ) );

				// Convert html into DOM nodes
				} else {
					tmp = tmp || fragment.appendChild( context.createElement( "div" ) );

					// Deserialize a standard representation
					tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();
					wrap = wrapMap[ tag ] || wrapMap._default;
					tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];

					// Descend through wrappers to the right content
					j = wrap[ 0 ];
					while ( j-- ) {
						tmp = tmp.lastChild;
					}

					// Support: Android <=4.0 only, PhantomJS 1 only
					// push.apply(_, arraylike) throws on ancient WebKit
					jQuery.merge( nodes, tmp.childNodes );

					// Remember the top-level container
					tmp = fragment.firstChild;

					// Ensure the created nodes are orphaned (trac-12392)
					tmp.textContent = "";
				}
			}
		}

		// Remove wrapper from fragment
		fragment.textContent = "";

		i = 0;
		while ( ( elem = nodes[ i++ ] ) ) {

			// Skip elements already in the context collection (trac-4087)
			if ( selection && jQuery.inArray( elem, selection ) > -1 ) {
				if ( ignored ) {
					ignored.push( elem );
				}
				continue;
			}

			attached = isAttached( elem );

			// Append to fragment
			tmp = getAll( fragment.appendChild( elem ), "script" );

			// Preserve script evaluation history
			if ( attached ) {
				setGlobalEval( tmp );
			}

			// Capture executables
			if ( scripts ) {
				j = 0;
				while ( ( elem = tmp[ j++ ] ) ) {
					if ( rscriptType.test( elem.type || "" ) ) {
						scripts.push( elem );
					}
				}
			}
		}

		return fragment;
	}


	var rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

	function returnTrue() {
		return true;
	}

	function returnFalse() {
		return false;
	}

	function on( elem, types, selector, data, fn, one ) {
		var origFn, type;

		// Types can be a map of types/handlers
		if ( typeof types === "object" ) {

			// ( types-Object, selector, data )
			if ( typeof selector !== "string" ) {

				// ( types-Object, data )
				data = data || selector;
				selector = undefined;
			}
			for ( type in types ) {
				on( elem, type, selector, data, types[ type ], one );
			}
			return elem;
		}

		if ( data == null && fn == null ) {

			// ( types, fn )
			fn = selector;
			data = selector = undefined;
		} else if ( fn == null ) {
			if ( typeof selector === "string" ) {

				// ( types, selector, fn )
				fn = data;
				data = undefined;
			} else {

				// ( types, data, fn )
				fn = data;
				data = selector;
				selector = undefined;
			}
		}
		if ( fn === false ) {
			fn = returnFalse;
		} else if ( !fn ) {
			return elem;
		}

		if ( one === 1 ) {
			origFn = fn;
			fn = function( event ) {

				// Can use an empty set, since event contains the info
				jQuery().off( event );
				return origFn.apply( this, arguments );
			};

			// Use same guid so caller can remove using origFn
			fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
		}
		return elem.each( function() {
			jQuery.event.add( this, types, fn, data, selector );
		} );
	}

	/*
	 * Helper functions for managing events -- not part of the public interface.
	 * Props to Dean Edwards' addEvent library for many of the ideas.
	 */
	jQuery.event = {

		global: {},

		add: function( elem, types, handler, data, selector ) {

			var handleObjIn, eventHandle, tmp,
				events, t, handleObj,
				special, handlers, type, namespaces, origType,
				elemData = dataPriv.get( elem );

			// Only attach events to objects that accept data
			if ( !acceptData( elem ) ) {
				return;
			}

			// Caller can pass in an object of custom data in lieu of the handler
			if ( handler.handler ) {
				handleObjIn = handler;
				handler = handleObjIn.handler;
				selector = handleObjIn.selector;
			}

			// Ensure that invalid selectors throw exceptions at attach time
			// Evaluate against documentElement in case elem is a non-element node (e.g., document)
			if ( selector ) {
				jQuery.find.matchesSelector( documentElement, selector );
			}

			// Make sure that the handler has a unique ID, used to find/remove it later
			if ( !handler.guid ) {
				handler.guid = jQuery.guid++;
			}

			// Init the element's event structure and main handler, if this is the first
			if ( !( events = elemData.events ) ) {
				events = elemData.events = Object.create( null );
			}
			if ( !( eventHandle = elemData.handle ) ) {
				eventHandle = elemData.handle = function( e ) {

					// Discard the second event of a jQuery.event.trigger() and
					// when an event is called after a page has unloaded
					return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?
						jQuery.event.dispatch.apply( elem, arguments ) : undefined;
				};
			}

			// Handle multiple events separated by a space
			types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
			t = types.length;
			while ( t-- ) {
				tmp = rtypenamespace.exec( types[ t ] ) || [];
				type = origType = tmp[ 1 ];
				namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

				// There *must* be a type, no attaching namespace-only handlers
				if ( !type ) {
					continue;
				}

				// If event changes its type, use the special event handlers for the changed type
				special = jQuery.event.special[ type ] || {};

				// If selector defined, determine special event api type, otherwise given type
				type = ( selector ? special.delegateType : special.bindType ) || type;

				// Update special based on newly reset type
				special = jQuery.event.special[ type ] || {};

				// handleObj is passed to all event handlers
				handleObj = jQuery.extend( {
					type: type,
					origType: origType,
					data: data,
					handler: handler,
					guid: handler.guid,
					selector: selector,
					needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
					namespace: namespaces.join( "." )
				}, handleObjIn );

				// Init the event handler queue if we're the first
				if ( !( handlers = events[ type ] ) ) {
					handlers = events[ type ] = [];
					handlers.delegateCount = 0;

					// Only use addEventListener if the special events handler returns false
					if ( !special.setup ||
						special.setup.call( elem, data, namespaces, eventHandle ) === false ) {

						if ( elem.addEventListener ) {
							elem.addEventListener( type, eventHandle );
						}
					}
				}

				if ( special.add ) {
					special.add.call( elem, handleObj );

					if ( !handleObj.handler.guid ) {
						handleObj.handler.guid = handler.guid;
					}
				}

				// Add to the element's handler list, delegates in front
				if ( selector ) {
					handlers.splice( handlers.delegateCount++, 0, handleObj );
				} else {
					handlers.push( handleObj );
				}

				// Keep track of which events have ever been used, for event optimization
				jQuery.event.global[ type ] = true;
			}

		},

		// Detach an event or set of events from an element
		remove: function( elem, types, handler, selector, mappedTypes ) {

			var j, origCount, tmp,
				events, t, handleObj,
				special, handlers, type, namespaces, origType,
				elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );

			if ( !elemData || !( events = elemData.events ) ) {
				return;
			}

			// Once for each type.namespace in types; type may be omitted
			types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
			t = types.length;
			while ( t-- ) {
				tmp = rtypenamespace.exec( types[ t ] ) || [];
				type = origType = tmp[ 1 ];
				namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

				// Unbind all events (on this namespace, if provided) for the element
				if ( !type ) {
					for ( type in events ) {
						jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
					}
					continue;
				}

				special = jQuery.event.special[ type ] || {};
				type = ( selector ? special.delegateType : special.bindType ) || type;
				handlers = events[ type ] || [];
				tmp = tmp[ 2 ] &&
					new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );

				// Remove matching events
				origCount = j = handlers.length;
				while ( j-- ) {
					handleObj = handlers[ j ];

					if ( ( mappedTypes || origType === handleObj.origType ) &&
						( !handler || handler.guid === handleObj.guid ) &&
						( !tmp || tmp.test( handleObj.namespace ) ) &&
						( !selector || selector === handleObj.selector ||
							selector === "**" && handleObj.selector ) ) {
						handlers.splice( j, 1 );

						if ( handleObj.selector ) {
							handlers.delegateCount--;
						}
						if ( special.remove ) {
							special.remove.call( elem, handleObj );
						}
					}
				}

				// Remove generic event handler if we removed something and no more handlers exist
				// (avoids potential for endless recursion during removal of special event handlers)
				if ( origCount && !handlers.length ) {
					if ( !special.teardown ||
						special.teardown.call( elem, namespaces, elemData.handle ) === false ) {

						jQuery.removeEvent( elem, type, elemData.handle );
					}

					delete events[ type ];
				}
			}

			// Remove data and the expando if it's no longer used
			if ( jQuery.isEmptyObject( events ) ) {
				dataPriv.remove( elem, "handle events" );
			}
		},

		dispatch: function( nativeEvent ) {

			var i, j, ret, matched, handleObj, handlerQueue,
				args = new Array( arguments.length ),

				// Make a writable jQuery.Event from the native event object
				event = jQuery.event.fix( nativeEvent ),

				handlers = (
					dataPriv.get( this, "events" ) || Object.create( null )
				)[ event.type ] || [],
				special = jQuery.event.special[ event.type ] || {};

			// Use the fix-ed jQuery.Event rather than the (read-only) native event
			args[ 0 ] = event;

			for ( i = 1; i < arguments.length; i++ ) {
				args[ i ] = arguments[ i ];
			}

			event.delegateTarget = this;

			// Call the preDispatch hook for the mapped type, and let it bail if desired
			if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
				return;
			}

			// Determine handlers
			handlerQueue = jQuery.event.handlers.call( this, event, handlers );

			// Run delegates first; they may want to stop propagation beneath us
			i = 0;
			while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {
				event.currentTarget = matched.elem;

				j = 0;
				while ( ( handleObj = matched.handlers[ j++ ] ) &&
					!event.isImmediatePropagationStopped() ) {

					// If the event is namespaced, then each handler is only invoked if it is
					// specially universal or its namespaces are a superset of the event's.
					if ( !event.rnamespace || handleObj.namespace === false ||
						event.rnamespace.test( handleObj.namespace ) ) {

						event.handleObj = handleObj;
						event.data = handleObj.data;

						ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||
							handleObj.handler ).apply( matched.elem, args );

						if ( ret !== undefined ) {
							if ( ( event.result = ret ) === false ) {
								event.preventDefault();
								event.stopPropagation();
							}
						}
					}
				}
			}

			// Call the postDispatch hook for the mapped type
			if ( special.postDispatch ) {
				special.postDispatch.call( this, event );
			}

			return event.result;
		},

		handlers: function( event, handlers ) {
			var i, handleObj, sel, matchedHandlers, matchedSelectors,
				handlerQueue = [],
				delegateCount = handlers.delegateCount,
				cur = event.target;

			// Find delegate handlers
			if ( delegateCount &&

				// Support: IE <=9
				// Black-hole SVG <use> instance trees (trac-13180)
				cur.nodeType &&

				// Support: Firefox <=42
				// Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
				// https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
				// Support: IE 11 only
				// ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
				!( event.type === "click" && event.button >= 1 ) ) {

				for ( ; cur !== this; cur = cur.parentNode || this ) {

					// Don't check non-elements (trac-13208)
					// Don't process clicks on disabled elements (trac-6911, trac-8165, trac-11382, trac-11764)
					if ( cur.nodeType === 1 && !( event.type === "click" && cur.disabled === true ) ) {
						matchedHandlers = [];
						matchedSelectors = {};
						for ( i = 0; i < delegateCount; i++ ) {
							handleObj = handlers[ i ];

							// Don't conflict with Object.prototype properties (trac-13203)
							sel = handleObj.selector + " ";

							if ( matchedSelectors[ sel ] === undefined ) {
								matchedSelectors[ sel ] = handleObj.needsContext ?
									jQuery( sel, this ).index( cur ) > -1 :
									jQuery.find( sel, this, null, [ cur ] ).length;
							}
							if ( matchedSelectors[ sel ] ) {
								matchedHandlers.push( handleObj );
							}
						}
						if ( matchedHandlers.length ) {
							handlerQueue.push( { elem: cur, handlers: matchedHandlers } );
						}
					}
				}
			}

			// Add the remaining (directly-bound) handlers
			cur = this;
			if ( delegateCount < handlers.length ) {
				handlerQueue.push( { elem: cur, handlers: handlers.slice( delegateCount ) } );
			}

			return handlerQueue;
		},

		addProp: function( name, hook ) {
			Object.defineProperty( jQuery.Event.prototype, name, {
				enumerable: true,
				configurable: true,

				get: isFunction( hook ) ?
					function() {
						if ( this.originalEvent ) {
							return hook( this.originalEvent );
						}
					} :
					function() {
						if ( this.originalEvent ) {
							return this.originalEvent[ name ];
						}
					},

				set: function( value ) {
					Object.defineProperty( this, name, {
						enumerable: true,
						configurable: true,
						writable: true,
						value: value
					} );
				}
			} );
		},

		fix: function( originalEvent ) {
			return originalEvent[ jQuery.expando ] ?
				originalEvent :
				new jQuery.Event( originalEvent );
		},

		special: {
			load: {

				// Prevent triggered image.load events from bubbling to window.load
				noBubble: true
			},
			click: {

				// Utilize native event to ensure correct state for checkable inputs
				setup: function( data ) {

					// For mutual compressibility with _default, replace `this` access with a local var.
					// `|| data` is dead code meant only to preserve the variable through minification.
					var el = this || data;

					// Claim the first handler
					if ( rcheckableType.test( el.type ) &&
						el.click && nodeName( el, "input" ) ) {

						// dataPriv.set( el, "click", ... )
						leverageNative( el, "click", true );
					}

					// Return false to allow normal processing in the caller
					return false;
				},
				trigger: function( data ) {

					// For mutual compressibility with _default, replace `this` access with a local var.
					// `|| data` is dead code meant only to preserve the variable through minification.
					var el = this || data;

					// Force setup before triggering a click
					if ( rcheckableType.test( el.type ) &&
						el.click && nodeName( el, "input" ) ) {

						leverageNative( el, "click" );
					}

					// Return non-false to allow normal event-path propagation
					return true;
				},

				// For cross-browser consistency, suppress native .click() on links
				// Also prevent it if we're currently inside a leveraged native-event stack
				_default: function( event ) {
					var target = event.target;
					return rcheckableType.test( target.type ) &&
						target.click && nodeName( target, "input" ) &&
						dataPriv.get( target, "click" ) ||
						nodeName( target, "a" );
				}
			},

			beforeunload: {
				postDispatch: function( event ) {

					// Support: Firefox 20+
					// Firefox doesn't alert if the returnValue field is not set.
					if ( event.result !== undefined && event.originalEvent ) {
						event.originalEvent.returnValue = event.result;
					}
				}
			}
		}
	};

	// Ensure the presence of an event listener that handles manually-triggered
	// synthetic events by interrupting progress until reinvoked in response to
	// *native* events that it fires directly, ensuring that state changes have
	// already occurred before other listeners are invoked.
	function leverageNative( el, type, isSetup ) {

		// Missing `isSetup` indicates a trigger call, which must force setup through jQuery.event.add
		if ( !isSetup ) {
			if ( dataPriv.get( el, type ) === undefined ) {
				jQuery.event.add( el, type, returnTrue );
			}
			return;
		}

		// Register the controller as a special universal handler for all event namespaces
		dataPriv.set( el, type, false );
		jQuery.event.add( el, type, {
			namespace: false,
			handler: function( event ) {
				var result,
					saved = dataPriv.get( this, type );

				if ( ( event.isTrigger & 1 ) && this[ type ] ) {

					// Interrupt processing of the outer synthetic .trigger()ed event
					if ( !saved ) {

						// Store arguments for use when handling the inner native event
						// There will always be at least one argument (an event object), so this array
						// will not be confused with a leftover capture object.
						saved = slice.call( arguments );
						dataPriv.set( this, type, saved );

						// Trigger the native event and capture its result
						this[ type ]();
						result = dataPriv.get( this, type );
						dataPriv.set( this, type, false );

						if ( saved !== result ) {

							// Cancel the outer synthetic event
							event.stopImmediatePropagation();
							event.preventDefault();

							return result;
						}

					// If this is an inner synthetic event for an event with a bubbling surrogate
					// (focus or blur), assume that the surrogate already propagated from triggering
					// the native event and prevent that from happening again here.
					// This technically gets the ordering wrong w.r.t. to `.trigger()` (in which the
					// bubbling surrogate propagates *after* the non-bubbling base), but that seems
					// less bad than duplication.
					} else if ( ( jQuery.event.special[ type ] || {} ).delegateType ) {
						event.stopPropagation();
					}

				// If this is a native event triggered above, everything is now in order
				// Fire an inner synthetic event with the original arguments
				} else if ( saved ) {

					// ...and capture the result
					dataPriv.set( this, type, jQuery.event.trigger(
						saved[ 0 ],
						saved.slice( 1 ),
						this
					) );

					// Abort handling of the native event by all jQuery handlers while allowing
					// native handlers on the same element to run. On target, this is achieved
					// by stopping immediate propagation just on the jQuery event. However,
					// the native event is re-wrapped by a jQuery one on each level of the
					// propagation so the only way to stop it for jQuery is to stop it for
					// everyone via native `stopPropagation()`. This is not a problem for
					// focus/blur which don't bubble, but it does also stop click on checkboxes
					// and radios. We accept this limitation.
					event.stopPropagation();
					event.isImmediatePropagationStopped = returnTrue;
				}
			}
		} );
	}

	jQuery.removeEvent = function( elem, type, handle ) {

		// This "if" is needed for plain objects
		if ( elem.removeEventListener ) {
			elem.removeEventListener( type, handle );
		}
	};

	jQuery.Event = function( src, props ) {

		// Allow instantiation without the 'new' keyword
		if ( !( this instanceof jQuery.Event ) ) {
			return new jQuery.Event( src, props );
		}

		// Event object
		if ( src && src.type ) {
			this.originalEvent = src;
			this.type = src.type;

			// Events bubbling up the document may have been marked as prevented
			// by a handler lower down the tree; reflect the correct value.
			this.isDefaultPrevented = src.defaultPrevented ||
					src.defaultPrevented === undefined &&

					// Support: Android <=2.3 only
					src.returnValue === false ?
				returnTrue :
				returnFalse;

			// Create target properties
			// Support: Safari <=6 - 7 only
			// Target should not be a text node (trac-504, trac-13143)
			this.target = ( src.target && src.target.nodeType === 3 ) ?
				src.target.parentNode :
				src.target;

			this.currentTarget = src.currentTarget;
			this.relatedTarget = src.relatedTarget;

		// Event type
		} else {
			this.type = src;
		}

		// Put explicitly provided properties onto the event object
		if ( props ) {
			jQuery.extend( this, props );
		}

		// Create a timestamp if incoming event doesn't have one
		this.timeStamp = src && src.timeStamp || Date.now();

		// Mark it as fixed
		this[ jQuery.expando ] = true;
	};

	// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
	// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
	jQuery.Event.prototype = {
		constructor: jQuery.Event,
		isDefaultPrevented: returnFalse,
		isPropagationStopped: returnFalse,
		isImmediatePropagationStopped: returnFalse,
		isSimulated: false,

		preventDefault: function() {
			var e = this.originalEvent;

			this.isDefaultPrevented = returnTrue;

			if ( e && !this.isSimulated ) {
				e.preventDefault();
			}
		},
		stopPropagation: function() {
			var e = this.originalEvent;

			this.isPropagationStopped = returnTrue;

			if ( e && !this.isSimulated ) {
				e.stopPropagation();
			}
		},
		stopImmediatePropagation: function() {
			var e = this.originalEvent;

			this.isImmediatePropagationStopped = returnTrue;

			if ( e && !this.isSimulated ) {
				e.stopImmediatePropagation();
			}

			this.stopPropagation();
		}
	};

	// Includes all common event props including KeyEvent and MouseEvent specific props
	jQuery.each( {
		altKey: true,
		bubbles: true,
		cancelable: true,
		changedTouches: true,
		ctrlKey: true,
		detail: true,
		eventPhase: true,
		metaKey: true,
		pageX: true,
		pageY: true,
		shiftKey: true,
		view: true,
		"char": true,
		code: true,
		charCode: true,
		key: true,
		keyCode: true,
		button: true,
		buttons: true,
		clientX: true,
		clientY: true,
		offsetX: true,
		offsetY: true,
		pointerId: true,
		pointerType: true,
		screenX: true,
		screenY: true,
		targetTouches: true,
		toElement: true,
		touches: true,
		which: true
	}, jQuery.event.addProp );

	jQuery.each( { focus: "focusin", blur: "focusout" }, function( type, delegateType ) {

		function focusMappedHandler( nativeEvent ) {
			if ( document.documentMode ) {

				// Support: IE 11+
				// Attach a single focusin/focusout handler on the document while someone wants
				// focus/blur. This is because the former are synchronous in IE while the latter
				// are async. In other browsers, all those handlers are invoked synchronously.

				// `handle` from private data would already wrap the event, but we need
				// to change the `type` here.
				var handle = dataPriv.get( this, "handle" ),
					event = jQuery.event.fix( nativeEvent );
				event.type = nativeEvent.type === "focusin" ? "focus" : "blur";
				event.isSimulated = true;

				// First, handle focusin/focusout
				handle( nativeEvent );

				// ...then, handle focus/blur
				//
				// focus/blur don't bubble while focusin/focusout do; simulate the former by only
				// invoking the handler at the lower level.
				if ( event.target === event.currentTarget ) {

					// The setup part calls `leverageNative`, which, in turn, calls
					// `jQuery.event.add`, so event handle will already have been set
					// by this point.
					handle( event );
				}
			} else {

				// For non-IE browsers, attach a single capturing handler on the document
				// while someone wants focusin/focusout.
				jQuery.event.simulate( delegateType, nativeEvent.target,
					jQuery.event.fix( nativeEvent ) );
			}
		}

		jQuery.event.special[ type ] = {

			// Utilize native event if possible so blur/focus sequence is correct
			setup: function() {

				var attaches;

				// Claim the first handler
				// dataPriv.set( this, "focus", ... )
				// dataPriv.set( this, "blur", ... )
				leverageNative( this, type, true );

				if ( document.documentMode ) {

					// Support: IE 9 - 11+
					// We use the same native handler for focusin & focus (and focusout & blur)
					// so we need to coordinate setup & teardown parts between those events.
					// Use `delegateType` as the key as `type` is already used by `leverageNative`.
					attaches = dataPriv.get( this, delegateType );
					if ( !attaches ) {
						this.addEventListener( delegateType, focusMappedHandler );
					}
					dataPriv.set( this, delegateType, ( attaches || 0 ) + 1 );
				} else {

					// Return false to allow normal processing in the caller
					return false;
				}
			},
			trigger: function() {

				// Force setup before trigger
				leverageNative( this, type );

				// Return non-false to allow normal event-path propagation
				return true;
			},

			teardown: function() {
				var attaches;

				if ( document.documentMode ) {
					attaches = dataPriv.get( this, delegateType ) - 1;
					if ( !attaches ) {
						this.removeEventListener( delegateType, focusMappedHandler );
						dataPriv.remove( this, delegateType );
					} else {
						dataPriv.set( this, delegateType, attaches );
					}
				} else {

					// Return false to indicate standard teardown should be applied
					return false;
				}
			},

			// Suppress native focus or blur if we're currently inside
			// a leveraged native-event stack
			_default: function( event ) {
				return dataPriv.get( event.target, type );
			},

			delegateType: delegateType
		};

		// Support: Firefox <=44
		// Firefox doesn't have focus(in | out) events
		// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
		//
		// Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
		// focus(in | out) events fire after focus & blur events,
		// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
		// Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857
		//
		// Support: IE 9 - 11+
		// To preserve relative focusin/focus & focusout/blur event order guaranteed on the 3.x branch,
		// attach a single handler for both events in IE.
		jQuery.event.special[ delegateType ] = {
			setup: function() {

				// Handle: regular nodes (via `this.ownerDocument`), window
				// (via `this.document`) & document (via `this`).
				var doc = this.ownerDocument || this.document || this,
					dataHolder = document.documentMode ? this : doc,
					attaches = dataPriv.get( dataHolder, delegateType );

				// Support: IE 9 - 11+
				// We use the same native handler for focusin & focus (and focusout & blur)
				// so we need to coordinate setup & teardown parts between those events.
				// Use `delegateType` as the key as `type` is already used by `leverageNative`.
				if ( !attaches ) {
					if ( document.documentMode ) {
						this.addEventListener( delegateType, focusMappedHandler );
					} else {
						doc.addEventListener( type, focusMappedHandler, true );
					}
				}
				dataPriv.set( dataHolder, delegateType, ( attaches || 0 ) + 1 );
			},
			teardown: function() {
				var doc = this.ownerDocument || this.document || this,
					dataHolder = document.documentMode ? this : doc,
					attaches = dataPriv.get( dataHolder, delegateType ) - 1;

				if ( !attaches ) {
					if ( document.documentMode ) {
						this.removeEventListener( delegateType, focusMappedHandler );
					} else {
						doc.removeEventListener( type, focusMappedHandler, true );
					}
					dataPriv.remove( dataHolder, delegateType );
				} else {
					dataPriv.set( dataHolder, delegateType, attaches );
				}
			}
		};
	} );

	// Create mouseenter/leave events using mouseover/out and event-time checks
	// so that event delegation works in jQuery.
	// Do the same for pointerenter/pointerleave and pointerover/pointerout
	//
	// Support: Safari 7 only
	// Safari sends mouseenter too often; see:
	// https://bugs.chromium.org/p/chromium/issues/detail?id=470258
	// for the description of the bug (it existed in older Chrome versions as well).
	jQuery.each( {
		mouseenter: "mouseover",
		mouseleave: "mouseout",
		pointerenter: "pointerover",
		pointerleave: "pointerout"
	}, function( orig, fix ) {
		jQuery.event.special[ orig ] = {
			delegateType: fix,
			bindType: fix,

			handle: function( event ) {
				var ret,
					target = this,
					related = event.relatedTarget,
					handleObj = event.handleObj;

				// For mouseenter/leave call the handler if related is outside the target.
				// NB: No relatedTarget if the mouse left/entered the browser window
				if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {
					event.type = handleObj.origType;
					ret = handleObj.handler.apply( this, arguments );
					event.type = fix;
				}
				return ret;
			}
		};
	} );

	jQuery.fn.extend( {

		on: function( types, selector, data, fn ) {
			return on( this, types, selector, data, fn );
		},
		one: function( types, selector, data, fn ) {
			return on( this, types, selector, data, fn, 1 );
		},
		off: function( types, selector, fn ) {
			var handleObj, type;
			if ( types && types.preventDefault && types.handleObj ) {

				// ( event )  dispatched jQuery.Event
				handleObj = types.handleObj;
				jQuery( types.delegateTarget ).off(
					handleObj.namespace ?
						handleObj.origType + "." + handleObj.namespace :
						handleObj.origType,
					handleObj.selector,
					handleObj.handler
				);
				return this;
			}
			if ( typeof types === "object" ) {

				// ( types-object [, selector] )
				for ( type in types ) {
					this.off( type, selector, types[ type ] );
				}
				return this;
			}
			if ( selector === false || typeof selector === "function" ) {

				// ( types [, fn] )
				fn = selector;
				selector = undefined;
			}
			if ( fn === false ) {
				fn = returnFalse;
			}
			return this.each( function() {
				jQuery.event.remove( this, types, fn, selector );
			} );
		}
	} );


	var

		// Support: IE <=10 - 11, Edge 12 - 13 only
		// In IE/Edge using regex groups here causes severe slowdowns.
		// See https://connect.microsoft.com/IE/feedback/details/1736512/
		rnoInnerhtml = /<script|<style|<link/i,

		// checked="checked" or checked
		rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,

		rcleanScript = /^\s*<!\[CDATA\[|\]\]>\s*$/g;

	// Prefer a tbody over its parent table for containing new rows
	function manipulationTarget( elem, content ) {
		if ( nodeName( elem, "table" ) &&
			nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ) {

			return jQuery( elem ).children( "tbody" )[ 0 ] || elem;
		}

		return elem;
	}

	// Replace/restore the type attribute of script elements for safe DOM manipulation
	function disableScript( elem ) {
		elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;
		return elem;
	}
	function restoreScript( elem ) {
		if ( ( elem.type || "" ).slice( 0, 5 ) === "true/" ) {
			elem.type = elem.type.slice( 5 );
		} else {
			elem.removeAttribute( "type" );
		}

		return elem;
	}

	function cloneCopyEvent( src, dest ) {
		var i, l, type, pdataOld, udataOld, udataCur, events;

		if ( dest.nodeType !== 1 ) {
			return;
		}

		// 1. Copy private data: events, handlers, etc.
		if ( dataPriv.hasData( src ) ) {
			pdataOld = dataPriv.get( src );
			events = pdataOld.events;

			if ( events ) {
				dataPriv.remove( dest, "handle events" );

				for ( type in events ) {
					for ( i = 0, l = events[ type ].length; i < l; i++ ) {
						jQuery.event.add( dest, type, events[ type ][ i ] );
					}
				}
			}
		}

		// 2. Copy user data
		if ( dataUser.hasData( src ) ) {
			udataOld = dataUser.access( src );
			udataCur = jQuery.extend( {}, udataOld );

			dataUser.set( dest, udataCur );
		}
	}

	// Fix IE bugs, see support tests
	function fixInput( src, dest ) {
		var nodeName = dest.nodeName.toLowerCase();

		// Fails to persist the checked state of a cloned checkbox or radio button.
		if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
			dest.checked = src.checked;

		// Fails to return the selected option to the default selected state when cloning options
		} else if ( nodeName === "input" || nodeName === "textarea" ) {
			dest.defaultValue = src.defaultValue;
		}
	}

	function domManip( collection, args, callback, ignored ) {

		// Flatten any nested arrays
		args = flat( args );

		var fragment, first, scripts, hasScripts, node, doc,
			i = 0,
			l = collection.length,
			iNoClone = l - 1,
			value = args[ 0 ],
			valueIsFunction = isFunction( value );

		// We can't cloneNode fragments that contain checked, in WebKit
		if ( valueIsFunction ||
				( l > 1 && typeof value === "string" &&
					!support.checkClone && rchecked.test( value ) ) ) {
			return collection.each( function( index ) {
				var self = collection.eq( index );
				if ( valueIsFunction ) {
					args[ 0 ] = value.call( this, index, self.html() );
				}
				domManip( self, args, callback, ignored );
			} );
		}

		if ( l ) {
			fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );
			first = fragment.firstChild;

			if ( fragment.childNodes.length === 1 ) {
				fragment = first;
			}

			// Require either new content or an interest in ignored elements to invoke the callback
			if ( first || ignored ) {
				scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
				hasScripts = scripts.length;

				// Use the original fragment for the last item
				// instead of the first because it can end up
				// being emptied incorrectly in certain situations (trac-8070).
				for ( ; i < l; i++ ) {
					node = fragment;

					if ( i !== iNoClone ) {
						node = jQuery.clone( node, true, true );

						// Keep references to cloned scripts for later restoration
						if ( hasScripts ) {

							// Support: Android <=4.0 only, PhantomJS 1 only
							// push.apply(_, arraylike) throws on ancient WebKit
							jQuery.merge( scripts, getAll( node, "script" ) );
						}
					}

					callback.call( collection[ i ], node, i );
				}

				if ( hasScripts ) {
					doc = scripts[ scripts.length - 1 ].ownerDocument;

					// Re-enable scripts
					jQuery.map( scripts, restoreScript );

					// Evaluate executable scripts on first document insertion
					for ( i = 0; i < hasScripts; i++ ) {
						node = scripts[ i ];
						if ( rscriptType.test( node.type || "" ) &&
							!dataPriv.access( node, "globalEval" ) &&
							jQuery.contains( doc, node ) ) {

							if ( node.src && ( node.type || "" ).toLowerCase()  !== "module" ) {

								// Optional AJAX dependency, but won't run scripts if not present
								if ( jQuery._evalUrl && !node.noModule ) {
									jQuery._evalUrl( node.src, {
										nonce: node.nonce || node.getAttribute( "nonce" )
									}, doc );
								}
							} else {

								// Unwrap a CDATA section containing script contents. This shouldn't be
								// needed as in XML documents they're already not visible when
								// inspecting element contents and in HTML documents they have no
								// meaning but we're preserving that logic for backwards compatibility.
								// This will be removed completely in 4.0. See gh-4904.
								DOMEval( node.textContent.replace( rcleanScript, "" ), node, doc );
							}
						}
					}
				}
			}
		}

		return collection;
	}

	function remove( elem, selector, keepData ) {
		var node,
			nodes = selector ? jQuery.filter( selector, elem ) : elem,
			i = 0;

		for ( ; ( node = nodes[ i ] ) != null; i++ ) {
			if ( !keepData && node.nodeType === 1 ) {
				jQuery.cleanData( getAll( node ) );
			}

			if ( node.parentNode ) {
				if ( keepData && isAttached( node ) ) {
					setGlobalEval( getAll( node, "script" ) );
				}
				node.parentNode.removeChild( node );
			}
		}

		return elem;
	}

	jQuery.extend( {
		htmlPrefilter: function( html ) {
			return html;
		},

		clone: function( elem, dataAndEvents, deepDataAndEvents ) {
			var i, l, srcElements, destElements,
				clone = elem.cloneNode( true ),
				inPage = isAttached( elem );

			// Fix IE cloning issues
			if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&
					!jQuery.isXMLDoc( elem ) ) {

				// We eschew jQuery#find here for performance reasons:
				// https://jsperf.com/getall-vs-sizzle/2
				destElements = getAll( clone );
				srcElements = getAll( elem );

				for ( i = 0, l = srcElements.length; i < l; i++ ) {
					fixInput( srcElements[ i ], destElements[ i ] );
				}
			}

			// Copy the events from the original to the clone
			if ( dataAndEvents ) {
				if ( deepDataAndEvents ) {
					srcElements = srcElements || getAll( elem );
					destElements = destElements || getAll( clone );

					for ( i = 0, l = srcElements.length; i < l; i++ ) {
						cloneCopyEvent( srcElements[ i ], destElements[ i ] );
					}
				} else {
					cloneCopyEvent( elem, clone );
				}
			}

			// Preserve script evaluation history
			destElements = getAll( clone, "script" );
			if ( destElements.length > 0 ) {
				setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
			}

			// Return the cloned set
			return clone;
		},

		cleanData: function( elems ) {
			var data, elem, type,
				special = jQuery.event.special,
				i = 0;

			for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {
				if ( acceptData( elem ) ) {
					if ( ( data = elem[ dataPriv.expando ] ) ) {
						if ( data.events ) {
							for ( type in data.events ) {
								if ( special[ type ] ) {
									jQuery.event.remove( elem, type );

								// This is a shortcut to avoid jQuery.event.remove's overhead
								} else {
									jQuery.removeEvent( elem, type, data.handle );
								}
							}
						}

						// Support: Chrome <=35 - 45+
						// Assign undefined instead of using delete, see Data#remove
						elem[ dataPriv.expando ] = undefined;
					}
					if ( elem[ dataUser.expando ] ) {

						// Support: Chrome <=35 - 45+
						// Assign undefined instead of using delete, see Data#remove
						elem[ dataUser.expando ] = undefined;
					}
				}
			}
		}
	} );

	jQuery.fn.extend( {
		detach: function( selector ) {
			return remove( this, selector, true );
		},

		remove: function( selector ) {
			return remove( this, selector );
		},

		text: function( value ) {
			return access( this, function( value ) {
				return value === undefined ?
					jQuery.text( this ) :
					this.empty().each( function() {
						if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
							this.textContent = value;
						}
					} );
			}, null, value, arguments.length );
		},

		append: function() {
			return domManip( this, arguments, function( elem ) {
				if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
					var target = manipulationTarget( this, elem );
					target.appendChild( elem );
				}
			} );
		},

		prepend: function() {
			return domManip( this, arguments, function( elem ) {
				if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
					var target = manipulationTarget( this, elem );
					target.insertBefore( elem, target.firstChild );
				}
			} );
		},

		before: function() {
			return domManip( this, arguments, function( elem ) {
				if ( this.parentNode ) {
					this.parentNode.insertBefore( elem, this );
				}
			} );
		},

		after: function() {
			return domManip( this, arguments, function( elem ) {
				if ( this.parentNode ) {
					this.parentNode.insertBefore( elem, this.nextSibling );
				}
			} );
		},

		empty: function() {
			var elem,
				i = 0;

			for ( ; ( elem = this[ i ] ) != null; i++ ) {
				if ( elem.nodeType === 1 ) {

					// Prevent memory leaks
					jQuery.cleanData( getAll( elem, false ) );

					// Remove any remaining nodes
					elem.textContent = "";
				}
			}

			return this;
		},

		clone: function( dataAndEvents, deepDataAndEvents ) {
			dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
			deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

			return this.map( function() {
				return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
			} );
		},

		html: function( value ) {
			return access( this, function( value ) {
				var elem = this[ 0 ] || {},
					i = 0,
					l = this.length;

				if ( value === undefined && elem.nodeType === 1 ) {
					return elem.innerHTML;
				}

				// See if we can take a shortcut and just use innerHTML
				if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
					!wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {

					value = jQuery.htmlPrefilter( value );

					try {
						for ( ; i < l; i++ ) {
							elem = this[ i ] || {};

							// Remove element nodes and prevent memory leaks
							if ( elem.nodeType === 1 ) {
								jQuery.cleanData( getAll( elem, false ) );
								elem.innerHTML = value;
							}
						}

						elem = 0;

					// If using innerHTML throws an exception, use the fallback method
					} catch ( e ) {}
				}

				if ( elem ) {
					this.empty().append( value );
				}
			}, null, value, arguments.length );
		},

		replaceWith: function() {
			var ignored = [];

			// Make the changes, replacing each non-ignored context element with the new content
			return domManip( this, arguments, function( elem ) {
				var parent = this.parentNode;

				if ( jQuery.inArray( this, ignored ) < 0 ) {
					jQuery.cleanData( getAll( this ) );
					if ( parent ) {
						parent.replaceChild( elem, this );
					}
				}

			// Force callback invocation
			}, ignored );
		}
	} );

	jQuery.each( {
		appendTo: "append",
		prependTo: "prepend",
		insertBefore: "before",
		insertAfter: "after",
		replaceAll: "replaceWith"
	}, function( name, original ) {
		jQuery.fn[ name ] = function( selector ) {
			var elems,
				ret = [],
				insert = jQuery( selector ),
				last = insert.length - 1,
				i = 0;

			for ( ; i <= last; i++ ) {
				elems = i === last ? this : this.clone( true );
				jQuery( insert[ i ] )[ original ]( elems );

				// Support: Android <=4.0 only, PhantomJS 1 only
				// .get() because push.apply(_, arraylike) throws on ancient WebKit
				push.apply( ret, elems.get() );
			}

			return this.pushStack( ret );
		};
	} );
	var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );

	var rcustomProp = /^--/;


	var getStyles = function( elem ) {

			// Support: IE <=11 only, Firefox <=30 (trac-15098, trac-14150)
			// IE throws on elements created in popups
			// FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
			var view = elem.ownerDocument.defaultView;

			if ( !view || !view.opener ) {
				view = window;
			}

			return view.getComputedStyle( elem );
		};

	var swap = function( elem, options, callback ) {
		var ret, name,
			old = {};

		// Remember the old values, and insert the new ones
		for ( name in options ) {
			old[ name ] = elem.style[ name ];
			elem.style[ name ] = options[ name ];
		}

		ret = callback.call( elem );

		// Revert the old values
		for ( name in options ) {
			elem.style[ name ] = old[ name ];
		}

		return ret;
	};


	var rboxStyle = new RegExp( cssExpand.join( "|" ), "i" );



	( function() {

		// Executing both pixelPosition & boxSizingReliable tests require only one layout
		// so they're executed at the same time to save the second computation.
		function computeStyleTests() {

			// This is a singleton, we need to execute it only once
			if ( !div ) {
				return;
			}

			container.style.cssText = "position:absolute;left:-11111px;width:60px;" +
				"margin-top:1px;padding:0;border:0";
			div.style.cssText =
				"position:relative;display:block;box-sizing:border-box;overflow:scroll;" +
				"margin:auto;border:1px;padding:1px;" +
				"width:60%;top:1%";
			documentElement.appendChild( container ).appendChild( div );

			var divStyle = window.getComputedStyle( div );
			pixelPositionVal = divStyle.top !== "1%";

			// Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
			reliableMarginLeftVal = roundPixelMeasures( divStyle.marginLeft ) === 12;

			// Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
			// Some styles come back with percentage values, even though they shouldn't
			div.style.right = "60%";
			pixelBoxStylesVal = roundPixelMeasures( divStyle.right ) === 36;

			// Support: IE 9 - 11 only
			// Detect misreporting of content dimensions for box-sizing:border-box elements
			boxSizingReliableVal = roundPixelMeasures( divStyle.width ) === 36;

			// Support: IE 9 only
			// Detect overflow:scroll screwiness (gh-3699)
			// Support: Chrome <=64
			// Don't get tricked when zoom affects offsetWidth (gh-4029)
			div.style.position = "absolute";
			scrollboxSizeVal = roundPixelMeasures( div.offsetWidth / 3 ) === 12;

			documentElement.removeChild( container );

			// Nullify the div so it wouldn't be stored in the memory and
			// it will also be a sign that checks already performed
			div = null;
		}

		function roundPixelMeasures( measure ) {
			return Math.round( parseFloat( measure ) );
		}

		var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal,
			reliableTrDimensionsVal, reliableMarginLeftVal,
			container = document.createElement( "div" ),
			div = document.createElement( "div" );

		// Finish early in limited (non-browser) environments
		if ( !div.style ) {
			return;
		}

		// Support: IE <=9 - 11 only
		// Style of cloned element affects source element cloned (trac-8908)
		div.style.backgroundClip = "content-box";
		div.cloneNode( true ).style.backgroundClip = "";
		support.clearCloneStyle = div.style.backgroundClip === "content-box";

		jQuery.extend( support, {
			boxSizingReliable: function() {
				computeStyleTests();
				return boxSizingReliableVal;
			},
			pixelBoxStyles: function() {
				computeStyleTests();
				return pixelBoxStylesVal;
			},
			pixelPosition: function() {
				computeStyleTests();
				return pixelPositionVal;
			},
			reliableMarginLeft: function() {
				computeStyleTests();
				return reliableMarginLeftVal;
			},
			scrollboxSize: function() {
				computeStyleTests();
				return scrollboxSizeVal;
			},

			// Support: IE 9 - 11+, Edge 15 - 18+
			// IE/Edge misreport `getComputedStyle` of table rows with width/height
			// set in CSS while `offset*` properties report correct values.
			// Behavior in IE 9 is more subtle than in newer versions & it passes
			// some versions of this test; make sure not to make it pass there!
			//
			// Support: Firefox 70+
			// Only Firefox includes border widths
			// in computed dimensions. (gh-4529)
			reliableTrDimensions: function() {
				var table, tr, trChild, trStyle;
				if ( reliableTrDimensionsVal == null ) {
					table = document.createElement( "table" );
					tr = document.createElement( "tr" );
					trChild = document.createElement( "div" );

					table.style.cssText = "position:absolute;left:-11111px;border-collapse:separate";
					tr.style.cssText = "box-sizing:content-box;border:1px solid";

					// Support: Chrome 86+
					// Height set through cssText does not get applied.
					// Computed height then comes back as 0.
					tr.style.height = "1px";
					trChild.style.height = "9px";

					// Support: Android 8 Chrome 86+
					// In our bodyBackground.html iframe,
					// display for all div elements is set to "inline",
					// which causes a problem only in Android 8 Chrome 86.
					// Ensuring the div is `display: block`
					// gets around this issue.
					trChild.style.display = "block";

					documentElement
						.appendChild( table )
						.appendChild( tr )
						.appendChild( trChild );

					trStyle = window.getComputedStyle( tr );
					reliableTrDimensionsVal = ( parseInt( trStyle.height, 10 ) +
						parseInt( trStyle.borderTopWidth, 10 ) +
						parseInt( trStyle.borderBottomWidth, 10 ) ) === tr.offsetHeight;

					documentElement.removeChild( table );
				}
				return reliableTrDimensionsVal;
			}
		} );
	} )();


	function curCSS( elem, name, computed ) {
		var width, minWidth, maxWidth, ret,
			isCustomProp = rcustomProp.test( name ),

			// Support: Firefox 51+
			// Retrieving style before computed somehow
			// fixes an issue with getting wrong values
			// on detached elements
			style = elem.style;

		computed = computed || getStyles( elem );

		// getPropertyValue is needed for:
		//   .css('filter') (IE 9 only, trac-12537)
		//   .css('--customProperty) (gh-3144)
		if ( computed ) {

			// Support: IE <=9 - 11+
			// IE only supports `"float"` in `getPropertyValue`; in computed styles
			// it's only available as `"cssFloat"`. We no longer modify properties
			// sent to `.css()` apart from camelCasing, so we need to check both.
			// Normally, this would create difference in behavior: if
			// `getPropertyValue` returns an empty string, the value returned
			// by `.css()` would be `undefined`. This is usually the case for
			// disconnected elements. However, in IE even disconnected elements
			// with no styles return `"none"` for `getPropertyValue( "float" )`
			ret = computed.getPropertyValue( name ) || computed[ name ];

			if ( isCustomProp && ret ) {

				// Support: Firefox 105+, Chrome <=105+
				// Spec requires trimming whitespace for custom properties (gh-4926).
				// Firefox only trims leading whitespace. Chrome just collapses
				// both leading & trailing whitespace to a single space.
				//
				// Fall back to `undefined` if empty string returned.
				// This collapses a missing definition with property defined
				// and set to an empty string but there's no standard API
				// allowing us to differentiate them without a performance penalty
				// and returning `undefined` aligns with older jQuery.
				//
				// rtrimCSS treats U+000D CARRIAGE RETURN and U+000C FORM FEED
				// as whitespace while CSS does not, but this is not a problem
				// because CSS preprocessing replaces them with U+000A LINE FEED
				// (which *is* CSS whitespace)
				// https://www.w3.org/TR/css-syntax-3/#input-preprocessing
				ret = ret.replace( rtrimCSS, "$1" ) || undefined;
			}

			if ( ret === "" && !isAttached( elem ) ) {
				ret = jQuery.style( elem, name );
			}

			// A tribute to the "awesome hack by Dean Edwards"
			// Android Browser returns percentage for some values,
			// but width seems to be reliably pixels.
			// This is against the CSSOM draft spec:
			// https://drafts.csswg.org/cssom/#resolved-values
			if ( !support.pixelBoxStyles() && rnumnonpx.test( ret ) && rboxStyle.test( name ) ) {

				// Remember the original values
				width = style.width;
				minWidth = style.minWidth;
				maxWidth = style.maxWidth;

				// Put in the new values to get a computed value out
				style.minWidth = style.maxWidth = style.width = ret;
				ret = computed.width;

				// Revert the changed values
				style.width = width;
				style.minWidth = minWidth;
				style.maxWidth = maxWidth;
			}
		}

		return ret !== undefined ?

			// Support: IE <=9 - 11 only
			// IE returns zIndex value as an integer.
			ret + "" :
			ret;
	}


	function addGetHookIf( conditionFn, hookFn ) {

		// Define the hook, we'll check on the first run if it's really needed.
		return {
			get: function() {
				if ( conditionFn() ) {

					// Hook not needed (or it's not possible to use it due
					// to missing dependency), remove it.
					delete this.get;
					return;
				}

				// Hook needed; redefine it so that the support test is not executed again.
				return ( this.get = hookFn ).apply( this, arguments );
			}
		};
	}


	var cssPrefixes = [ "Webkit", "Moz", "ms" ],
		emptyStyle = document.createElement( "div" ).style,
		vendorProps = {};

	// Return a vendor-prefixed property or undefined
	function vendorPropName( name ) {

		// Check for vendor prefixed names
		var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),
			i = cssPrefixes.length;

		while ( i-- ) {
			name = cssPrefixes[ i ] + capName;
			if ( name in emptyStyle ) {
				return name;
			}
		}
	}

	// Return a potentially-mapped jQuery.cssProps or vendor prefixed property
	function finalPropName( name ) {
		var final = jQuery.cssProps[ name ] || vendorProps[ name ];

		if ( final ) {
			return final;
		}
		if ( name in emptyStyle ) {
			return name;
		}
		return vendorProps[ name ] = vendorPropName( name ) || name;
	}


	var

		// Swappable if display is none or starts with table
		// except "table", "table-cell", or "table-caption"
		// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
		rdisplayswap = /^(none|table(?!-c[ea]).+)/,
		cssShow = { position: "absolute", visibility: "hidden", display: "block" },
		cssNormalTransform = {
			letterSpacing: "0",
			fontWeight: "400"
		};

	function setPositiveNumber( _elem, value, subtract ) {

		// Any relative (+/-) values have already been
		// normalized at this point
		var matches = rcssNum.exec( value );
		return matches ?

			// Guard against undefined "subtract", e.g., when used as in cssHooks
			Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || "px" ) :
			value;
	}

	function boxModelAdjustment( elem, dimension, box, isBorderBox, styles, computedVal ) {
		var i = dimension === "width" ? 1 : 0,
			extra = 0,
			delta = 0,
			marginDelta = 0;

		// Adjustment may not be necessary
		if ( box === ( isBorderBox ? "border" : "content" ) ) {
			return 0;
		}

		for ( ; i < 4; i += 2 ) {

			// Both box models exclude margin
			// Count margin delta separately to only add it after scroll gutter adjustment.
			// This is needed to make negative margins work with `outerHeight( true )` (gh-3982).
			if ( box === "margin" ) {
				marginDelta += jQuery.css( elem, box + cssExpand[ i ], true, styles );
			}

			// If we get here with a content-box, we're seeking "padding" or "border" or "margin"
			if ( !isBorderBox ) {

				// Add padding
				delta += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

				// For "border" or "margin", add border
				if ( box !== "padding" ) {
					delta += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );

				// But still keep track of it otherwise
				} else {
					extra += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
				}

			// If we get here with a border-box (content + padding + border), we're seeking "content" or
			// "padding" or "margin"
			} else {

				// For "content", subtract padding
				if ( box === "content" ) {
					delta -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );
				}

				// For "content" or "padding", subtract border
				if ( box !== "margin" ) {
					delta -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
				}
			}
		}

		// Account for positive content-box scroll gutter when requested by providing computedVal
		if ( !isBorderBox && computedVal >= 0 ) {

			// offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border
			// Assuming integer scroll gutter, subtract the rest and round down
			delta += Math.max( 0, Math.ceil(
				elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
				computedVal -
				delta -
				extra -
				0.5

			// If offsetWidth/offsetHeight is unknown, then we can't determine content-box scroll gutter
			// Use an explicit zero to avoid NaN (gh-3964)
			) ) || 0;
		}

		return delta + marginDelta;
	}

	function getWidthOrHeight( elem, dimension, extra ) {

		// Start with computed style
		var styles = getStyles( elem ),

			// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-4322).
			// Fake content-box until we know it's needed to know the true value.
			boxSizingNeeded = !support.boxSizingReliable() || extra,
			isBorderBox = boxSizingNeeded &&
				jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
			valueIsBorderBox = isBorderBox,

			val = curCSS( elem, dimension, styles ),
			offsetProp = "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 );

		// Support: Firefox <=54
		// Return a confounding non-pixel value or feign ignorance, as appropriate.
		if ( rnumnonpx.test( val ) ) {
			if ( !extra ) {
				return val;
			}
			val = "auto";
		}


		// Support: IE 9 - 11 only
		// Use offsetWidth/offsetHeight for when box sizing is unreliable.
		// In those cases, the computed value can be trusted to be border-box.
		if ( ( !support.boxSizingReliable() && isBorderBox ||

			// Support: IE 10 - 11+, Edge 15 - 18+
			// IE/Edge misreport `getComputedStyle` of table rows with width/height
			// set in CSS while `offset*` properties report correct values.
			// Interestingly, in some cases IE 9 doesn't suffer from this issue.
			!support.reliableTrDimensions() && nodeName( elem, "tr" ) ||

			// Fall back to offsetWidth/offsetHeight when value is "auto"
			// This happens for inline elements with no explicit setting (gh-3571)
			val === "auto" ||

			// Support: Android <=4.1 - 4.3 only
			// Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)
			!parseFloat( val ) && jQuery.css( elem, "display", false, styles ) === "inline" ) &&

			// Make sure the element is visible & connected
			elem.getClientRects().length ) {

			isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box";

			// Where available, offsetWidth/offsetHeight approximate border box dimensions.
			// Where not available (e.g., SVG), assume unreliable box-sizing and interpret the
			// retrieved value as a content box dimension.
			valueIsBorderBox = offsetProp in elem;
			if ( valueIsBorderBox ) {
				val = elem[ offsetProp ];
			}
		}

		// Normalize "" and auto
		val = parseFloat( val ) || 0;

		// Adjust for the element's box model
		return ( val +
			boxModelAdjustment(
				elem,
				dimension,
				extra || ( isBorderBox ? "border" : "content" ),
				valueIsBorderBox,
				styles,

				// Provide the current computed size to request scroll gutter calculation (gh-3589)
				val
			)
		) + "px";
	}

	jQuery.extend( {

		// Add in style property hooks for overriding the default
		// behavior of getting and setting a style property
		cssHooks: {
			opacity: {
				get: function( elem, computed ) {
					if ( computed ) {

						// We should always get a number back from opacity
						var ret = curCSS( elem, "opacity" );
						return ret === "" ? "1" : ret;
					}
				}
			}
		},

		// Don't automatically add "px" to these possibly-unitless properties
		cssNumber: {
			animationIterationCount: true,
			aspectRatio: true,
			borderImageSlice: true,
			columnCount: true,
			flexGrow: true,
			flexShrink: true,
			fontWeight: true,
			gridArea: true,
			gridColumn: true,
			gridColumnEnd: true,
			gridColumnStart: true,
			gridRow: true,
			gridRowEnd: true,
			gridRowStart: true,
			lineHeight: true,
			opacity: true,
			order: true,
			orphans: true,
			scale: true,
			widows: true,
			zIndex: true,
			zoom: true,

			// SVG-related
			fillOpacity: true,
			floodOpacity: true,
			stopOpacity: true,
			strokeMiterlimit: true,
			strokeOpacity: true
		},

		// Add in properties whose names you wish to fix before
		// setting or getting the value
		cssProps: {},

		// Get and set the style property on a DOM Node
		style: function( elem, name, value, extra ) {

			// Don't set styles on text and comment nodes
			if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
				return;
			}

			// Make sure that we're working with the right name
			var ret, type, hooks,
				origName = camelCase( name ),
				isCustomProp = rcustomProp.test( name ),
				style = elem.style;

			// Make sure that we're working with the right name. We don't
			// want to query the value if it is a CSS custom property
			// since they are user-defined.
			if ( !isCustomProp ) {
				name = finalPropName( origName );
			}

			// Gets hook for the prefixed version, then unprefixed version
			hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

			// Check if we're setting a value
			if ( value !== undefined ) {
				type = typeof value;

				// Convert "+=" or "-=" to relative numbers (trac-7345)
				if ( type === "string" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {
					value = adjustCSS( elem, name, ret );

					// Fixes bug trac-9237
					type = "number";
				}

				// Make sure that null and NaN values aren't set (trac-7116)
				if ( value == null || value !== value ) {
					return;
				}

				// If a number was passed in, add the unit (except for certain CSS properties)
				// The isCustomProp check can be removed in jQuery 4.0 when we only auto-append
				// "px" to a few hardcoded values.
				if ( type === "number" && !isCustomProp ) {
					value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? "" : "px" );
				}

				// background-* props affect original clone's values
				if ( !support.clearCloneStyle && value === "" && name.indexOf( "background" ) === 0 ) {
					style[ name ] = "inherit";
				}

				// If a hook was provided, use that value, otherwise just set the specified value
				if ( !hooks || !( "set" in hooks ) ||
					( value = hooks.set( elem, value, extra ) ) !== undefined ) {

					if ( isCustomProp ) {
						style.setProperty( name, value );
					} else {
						style[ name ] = value;
					}
				}

			} else {

				// If a hook was provided get the non-computed value from there
				if ( hooks && "get" in hooks &&
					( ret = hooks.get( elem, false, extra ) ) !== undefined ) {

					return ret;
				}

				// Otherwise just get the value from the style object
				return style[ name ];
			}
		},

		css: function( elem, name, extra, styles ) {
			var val, num, hooks,
				origName = camelCase( name ),
				isCustomProp = rcustomProp.test( name );

			// Make sure that we're working with the right name. We don't
			// want to modify the value if it is a CSS custom property
			// since they are user-defined.
			if ( !isCustomProp ) {
				name = finalPropName( origName );
			}

			// Try prefixed name followed by the unprefixed name
			hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

			// If a hook was provided get the computed value from there
			if ( hooks && "get" in hooks ) {
				val = hooks.get( elem, true, extra );
			}

			// Otherwise, if a way to get the computed value exists, use that
			if ( val === undefined ) {
				val = curCSS( elem, name, styles );
			}

			// Convert "normal" to computed value
			if ( val === "normal" && name in cssNormalTransform ) {
				val = cssNormalTransform[ name ];
			}

			// Make numeric if forced or a qualifier was provided and val looks numeric
			if ( extra === "" || extra ) {
				num = parseFloat( val );
				return extra === true || isFinite( num ) ? num || 0 : val;
			}

			return val;
		}
	} );

	jQuery.each( [ "height", "width" ], function( _i, dimension ) {
		jQuery.cssHooks[ dimension ] = {
			get: function( elem, computed, extra ) {
				if ( computed ) {

					// Certain elements can have dimension info if we invisibly show them
					// but it must have a current display style that would benefit
					return rdisplayswap.test( jQuery.css( elem, "display" ) ) &&

						// Support: Safari 8+
						// Table columns in Safari have non-zero offsetWidth & zero
						// getBoundingClientRect().width unless display is changed.
						// Support: IE <=11 only
						// Running getBoundingClientRect on a disconnected node
						// in IE throws an error.
						( !elem.getClientRects().length || !elem.getBoundingClientRect().width ) ?
						swap( elem, cssShow, function() {
							return getWidthOrHeight( elem, dimension, extra );
						} ) :
						getWidthOrHeight( elem, dimension, extra );
				}
			},

			set: function( elem, value, extra ) {
				var matches,
					styles = getStyles( elem ),

					// Only read styles.position if the test has a chance to fail
					// to avoid forcing a reflow.
					scrollboxSizeBuggy = !support.scrollboxSize() &&
						styles.position === "absolute",

					// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-3991)
					boxSizingNeeded = scrollboxSizeBuggy || extra,
					isBorderBox = boxSizingNeeded &&
						jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
					subtract = extra ?
						boxModelAdjustment(
							elem,
							dimension,
							extra,
							isBorderBox,
							styles
						) :
						0;

				// Account for unreliable border-box dimensions by comparing offset* to computed and
				// faking a content-box to get border and padding (gh-3699)
				if ( isBorderBox && scrollboxSizeBuggy ) {
					subtract -= Math.ceil(
						elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
						parseFloat( styles[ dimension ] ) -
						boxModelAdjustment( elem, dimension, "border", false, styles ) -
						0.5
					);
				}

				// Convert to pixels if value adjustment is needed
				if ( subtract && ( matches = rcssNum.exec( value ) ) &&
					( matches[ 3 ] || "px" ) !== "px" ) {

					elem.style[ dimension ] = value;
					value = jQuery.css( elem, dimension );
				}

				return setPositiveNumber( elem, value, subtract );
			}
		};
	} );

	jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,
		function( elem, computed ) {
			if ( computed ) {
				return ( parseFloat( curCSS( elem, "marginLeft" ) ) ||
					elem.getBoundingClientRect().left -
						swap( elem, { marginLeft: 0 }, function() {
							return elem.getBoundingClientRect().left;
						} )
				) + "px";
			}
		}
	);

	// These hooks are used by animate to expand properties
	jQuery.each( {
		margin: "",
		padding: "",
		border: "Width"
	}, function( prefix, suffix ) {
		jQuery.cssHooks[ prefix + suffix ] = {
			expand: function( value ) {
				var i = 0,
					expanded = {},

					// Assumes a single number if not a string
					parts = typeof value === "string" ? value.split( " " ) : [ value ];

				for ( ; i < 4; i++ ) {
					expanded[ prefix + cssExpand[ i ] + suffix ] =
						parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
				}

				return expanded;
			}
		};

		if ( prefix !== "margin" ) {
			jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
		}
	} );

	jQuery.fn.extend( {
		css: function( name, value ) {
			return access( this, function( elem, name, value ) {
				var styles, len,
					map = {},
					i = 0;

				if ( Array.isArray( name ) ) {
					styles = getStyles( elem );
					len = name.length;

					for ( ; i < len; i++ ) {
						map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );
					}

					return map;
				}

				return value !== undefined ?
					jQuery.style( elem, name, value ) :
					jQuery.css( elem, name );
			}, name, value, arguments.length > 1 );
		}
	} );


	function Tween( elem, options, prop, end, easing ) {
		return new Tween.prototype.init( elem, options, prop, end, easing );
	}
	jQuery.Tween = Tween;

	Tween.prototype = {
		constructor: Tween,
		init: function( elem, options, prop, end, easing, unit ) {
			this.elem = elem;
			this.prop = prop;
			this.easing = easing || jQuery.easing._default;
			this.options = options;
			this.start = this.now = this.cur();
			this.end = end;
			this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
		},
		cur: function() {
			var hooks = Tween.propHooks[ this.prop ];

			return hooks && hooks.get ?
				hooks.get( this ) :
				Tween.propHooks._default.get( this );
		},
		run: function( percent ) {
			var eased,
				hooks = Tween.propHooks[ this.prop ];

			if ( this.options.duration ) {
				this.pos = eased = jQuery.easing[ this.easing ](
					percent, this.options.duration * percent, 0, 1, this.options.duration
				);
			} else {
				this.pos = eased = percent;
			}
			this.now = ( this.end - this.start ) * eased + this.start;

			if ( this.options.step ) {
				this.options.step.call( this.elem, this.now, this );
			}

			if ( hooks && hooks.set ) {
				hooks.set( this );
			} else {
				Tween.propHooks._default.set( this );
			}
			return this;
		}
	};

	Tween.prototype.init.prototype = Tween.prototype;

	Tween.propHooks = {
		_default: {
			get: function( tween ) {
				var result;

				// Use a property on the element directly when it is not a DOM element,
				// or when there is no matching style property that exists.
				if ( tween.elem.nodeType !== 1 ||
					tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {
					return tween.elem[ tween.prop ];
				}

				// Passing an empty string as a 3rd parameter to .css will automatically
				// attempt a parseFloat and fallback to a string if the parse fails.
				// Simple values such as "10px" are parsed to Float;
				// complex values such as "rotate(1rad)" are returned as-is.
				result = jQuery.css( tween.elem, tween.prop, "" );

				// Empty strings, null, undefined and "auto" are converted to 0.
				return !result || result === "auto" ? 0 : result;
			},
			set: function( tween ) {

				// Use step hook for back compat.
				// Use cssHook if its there.
				// Use .style if available and use plain properties where available.
				if ( jQuery.fx.step[ tween.prop ] ) {
					jQuery.fx.step[ tween.prop ]( tween );
				} else if ( tween.elem.nodeType === 1 && (
					jQuery.cssHooks[ tween.prop ] ||
						tween.elem.style[ finalPropName( tween.prop ) ] != null ) ) {
					jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
				} else {
					tween.elem[ tween.prop ] = tween.now;
				}
			}
		}
	};

	// Support: IE <=9 only
	// Panic based approach to setting things on disconnected nodes
	Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
		set: function( tween ) {
			if ( tween.elem.nodeType && tween.elem.parentNode ) {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	};

	jQuery.easing = {
		linear: function( p ) {
			return p;
		},
		swing: function( p ) {
			return 0.5 - Math.cos( p * Math.PI ) / 2;
		},
		_default: "swing"
	};

	jQuery.fx = Tween.prototype.init;

	// Back compat <1.8 extension point
	jQuery.fx.step = {};




	var
		fxNow, inProgress,
		rfxtypes = /^(?:toggle|show|hide)$/,
		rrun = /queueHooks$/;

	function schedule() {
		if ( inProgress ) {
			if ( document.hidden === false && window.requestAnimationFrame ) {
				window.requestAnimationFrame( schedule );
			} else {
				window.setTimeout( schedule, jQuery.fx.interval );
			}

			jQuery.fx.tick();
		}
	}

	// Animations created synchronously will run synchronously
	function createFxNow() {
		window.setTimeout( function() {
			fxNow = undefined;
		} );
		return ( fxNow = Date.now() );
	}

	// Generate parameters to create a standard animation
	function genFx( type, includeWidth ) {
		var which,
			i = 0,
			attrs = { height: type };

		// If we include width, step value is 1 to do all cssExpand values,
		// otherwise step value is 2 to skip over Left and Right
		includeWidth = includeWidth ? 1 : 0;
		for ( ; i < 4; i += 2 - includeWidth ) {
			which = cssExpand[ i ];
			attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
		}

		if ( includeWidth ) {
			attrs.opacity = attrs.width = type;
		}

		return attrs;
	}

	function createTween( value, prop, animation ) {
		var tween,
			collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ "*" ] ),
			index = 0,
			length = collection.length;
		for ( ; index < length; index++ ) {
			if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {

				// We're done with this property
				return tween;
			}
		}
	}

	function defaultPrefilter( elem, props, opts ) {
		var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display,
			isBox = "width" in props || "height" in props,
			anim = this,
			orig = {},
			style = elem.style,
			hidden = elem.nodeType && isHiddenWithinTree( elem ),
			dataShow = dataPriv.get( elem, "fxshow" );

		// Queue-skipping animations hijack the fx hooks
		if ( !opts.queue ) {
			hooks = jQuery._queueHooks( elem, "fx" );
			if ( hooks.unqueued == null ) {
				hooks.unqueued = 0;
				oldfire = hooks.empty.fire;
				hooks.empty.fire = function() {
					if ( !hooks.unqueued ) {
						oldfire();
					}
				};
			}
			hooks.unqueued++;

			anim.always( function() {

				// Ensure the complete handler is called before this completes
				anim.always( function() {
					hooks.unqueued--;
					if ( !jQuery.queue( elem, "fx" ).length ) {
						hooks.empty.fire();
					}
				} );
			} );
		}

		// Detect show/hide animations
		for ( prop in props ) {
			value = props[ prop ];
			if ( rfxtypes.test( value ) ) {
				delete props[ prop ];
				toggle = toggle || value === "toggle";
				if ( value === ( hidden ? "hide" : "show" ) ) {

					// Pretend to be hidden if this is a "show" and
					// there is still data from a stopped show/hide
					if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {
						hidden = true;

					// Ignore all other no-op show/hide data
					} else {
						continue;
					}
				}
				orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );
			}
		}

		// Bail out if this is a no-op like .hide().hide()
		propTween = !jQuery.isEmptyObject( props );
		if ( !propTween && jQuery.isEmptyObject( orig ) ) {
			return;
		}

		// Restrict "overflow" and "display" styles during box animations
		if ( isBox && elem.nodeType === 1 ) {

			// Support: IE <=9 - 11, Edge 12 - 15
			// Record all 3 overflow attributes because IE does not infer the shorthand
			// from identically-valued overflowX and overflowY and Edge just mirrors
			// the overflowX value there.
			opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

			// Identify a display type, preferring old show/hide data over the CSS cascade
			restoreDisplay = dataShow && dataShow.display;
			if ( restoreDisplay == null ) {
				restoreDisplay = dataPriv.get( elem, "display" );
			}
			display = jQuery.css( elem, "display" );
			if ( display === "none" ) {
				if ( restoreDisplay ) {
					display = restoreDisplay;
				} else {

					// Get nonempty value(s) by temporarily forcing visibility
					showHide( [ elem ], true );
					restoreDisplay = elem.style.display || restoreDisplay;
					display = jQuery.css( elem, "display" );
					showHide( [ elem ] );
				}
			}

			// Animate inline elements as inline-block
			if ( display === "inline" || display === "inline-block" && restoreDisplay != null ) {
				if ( jQuery.css( elem, "float" ) === "none" ) {

					// Restore the original display value at the end of pure show/hide animations
					if ( !propTween ) {
						anim.done( function() {
							style.display = restoreDisplay;
						} );
						if ( restoreDisplay == null ) {
							display = style.display;
							restoreDisplay = display === "none" ? "" : display;
						}
					}
					style.display = "inline-block";
				}
			}
		}

		if ( opts.overflow ) {
			style.overflow = "hidden";
			anim.always( function() {
				style.overflow = opts.overflow[ 0 ];
				style.overflowX = opts.overflow[ 1 ];
				style.overflowY = opts.overflow[ 2 ];
			} );
		}

		// Implement show/hide animations
		propTween = false;
		for ( prop in orig ) {

			// General show/hide setup for this element animation
			if ( !propTween ) {
				if ( dataShow ) {
					if ( "hidden" in dataShow ) {
						hidden = dataShow.hidden;
					}
				} else {
					dataShow = dataPriv.access( elem, "fxshow", { display: restoreDisplay } );
				}

				// Store hidden/visible for toggle so `.stop().toggle()` "reverses"
				if ( toggle ) {
					dataShow.hidden = !hidden;
				}

				// Show elements before animating them
				if ( hidden ) {
					showHide( [ elem ], true );
				}

				/* eslint-disable no-loop-func */

				anim.done( function() {

					/* eslint-enable no-loop-func */

					// The final step of a "hide" animation is actually hiding the element
					if ( !hidden ) {
						showHide( [ elem ] );
					}
					dataPriv.remove( elem, "fxshow" );
					for ( prop in orig ) {
						jQuery.style( elem, prop, orig[ prop ] );
					}
				} );
			}

			// Per-property setup
			propTween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );
			if ( !( prop in dataShow ) ) {
				dataShow[ prop ] = propTween.start;
				if ( hidden ) {
					propTween.end = propTween.start;
					propTween.start = 0;
				}
			}
		}
	}

	function propFilter( props, specialEasing ) {
		var index, name, easing, value, hooks;

		// camelCase, specialEasing and expand cssHook pass
		for ( index in props ) {
			name = camelCase( index );
			easing = specialEasing[ name ];
			value = props[ index ];
			if ( Array.isArray( value ) ) {
				easing = value[ 1 ];
				value = props[ index ] = value[ 0 ];
			}

			if ( index !== name ) {
				props[ name ] = value;
				delete props[ index ];
			}

			hooks = jQuery.cssHooks[ name ];
			if ( hooks && "expand" in hooks ) {
				value = hooks.expand( value );
				delete props[ name ];

				// Not quite $.extend, this won't overwrite existing keys.
				// Reusing 'index' because we have the correct "name"
				for ( index in value ) {
					if ( !( index in props ) ) {
						props[ index ] = value[ index ];
						specialEasing[ index ] = easing;
					}
				}
			} else {
				specialEasing[ name ] = easing;
			}
		}
	}

	function Animation( elem, properties, options ) {
		var result,
			stopped,
			index = 0,
			length = Animation.prefilters.length,
			deferred = jQuery.Deferred().always( function() {

				// Don't match elem in the :animated selector
				delete tick.elem;
			} ),
			tick = function() {
				if ( stopped ) {
					return false;
				}
				var currentTime = fxNow || createFxNow(),
					remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),

					// Support: Android 2.3 only
					// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (trac-12497)
					temp = remaining / animation.duration || 0,
					percent = 1 - temp,
					index = 0,
					length = animation.tweens.length;

				for ( ; index < length; index++ ) {
					animation.tweens[ index ].run( percent );
				}

				deferred.notifyWith( elem, [ animation, percent, remaining ] );

				// If there's more to do, yield
				if ( percent < 1 && length ) {
					return remaining;
				}

				// If this was an empty animation, synthesize a final progress notification
				if ( !length ) {
					deferred.notifyWith( elem, [ animation, 1, 0 ] );
				}

				// Resolve the animation and report its conclusion
				deferred.resolveWith( elem, [ animation ] );
				return false;
			},
			animation = deferred.promise( {
				elem: elem,
				props: jQuery.extend( {}, properties ),
				opts: jQuery.extend( true, {
					specialEasing: {},
					easing: jQuery.easing._default
				}, options ),
				originalProperties: properties,
				originalOptions: options,
				startTime: fxNow || createFxNow(),
				duration: options.duration,
				tweens: [],
				createTween: function( prop, end ) {
					var tween = jQuery.Tween( elem, animation.opts, prop, end,
						animation.opts.specialEasing[ prop ] || animation.opts.easing );
					animation.tweens.push( tween );
					return tween;
				},
				stop: function( gotoEnd ) {
					var index = 0,

						// If we are going to the end, we want to run all the tweens
						// otherwise we skip this part
						length = gotoEnd ? animation.tweens.length : 0;
					if ( stopped ) {
						return this;
					}
					stopped = true;
					for ( ; index < length; index++ ) {
						animation.tweens[ index ].run( 1 );
					}

					// Resolve when we played the last frame; otherwise, reject
					if ( gotoEnd ) {
						deferred.notifyWith( elem, [ animation, 1, 0 ] );
						deferred.resolveWith( elem, [ animation, gotoEnd ] );
					} else {
						deferred.rejectWith( elem, [ animation, gotoEnd ] );
					}
					return this;
				}
			} ),
			props = animation.props;

		propFilter( props, animation.opts.specialEasing );

		for ( ; index < length; index++ ) {
			result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );
			if ( result ) {
				if ( isFunction( result.stop ) ) {
					jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =
						result.stop.bind( result );
				}
				return result;
			}
		}

		jQuery.map( props, createTween, animation );

		if ( isFunction( animation.opts.start ) ) {
			animation.opts.start.call( elem, animation );
		}

		// Attach callbacks from options
		animation
			.progress( animation.opts.progress )
			.done( animation.opts.done, animation.opts.complete )
			.fail( animation.opts.fail )
			.always( animation.opts.always );

		jQuery.fx.timer(
			jQuery.extend( tick, {
				elem: elem,
				anim: animation,
				queue: animation.opts.queue
			} )
		);

		return animation;
	}

	jQuery.Animation = jQuery.extend( Animation, {

		tweeners: {
			"*": [ function( prop, value ) {
				var tween = this.createTween( prop, value );
				adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );
				return tween;
			} ]
		},

		tweener: function( props, callback ) {
			if ( isFunction( props ) ) {
				callback = props;
				props = [ "*" ];
			} else {
				props = props.match( rnothtmlwhite );
			}

			var prop,
				index = 0,
				length = props.length;

			for ( ; index < length; index++ ) {
				prop = props[ index ];
				Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];
				Animation.tweeners[ prop ].unshift( callback );
			}
		},

		prefilters: [ defaultPrefilter ],

		prefilter: function( callback, prepend ) {
			if ( prepend ) {
				Animation.prefilters.unshift( callback );
			} else {
				Animation.prefilters.push( callback );
			}
		}
	} );

	jQuery.speed = function( speed, easing, fn ) {
		var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
			complete: fn || !fn && easing ||
				isFunction( speed ) && speed,
			duration: speed,
			easing: fn && easing || easing && !isFunction( easing ) && easing
		};

		// Go to the end state if fx are off
		if ( jQuery.fx.off ) {
			opt.duration = 0;

		} else {
			if ( typeof opt.duration !== "number" ) {
				if ( opt.duration in jQuery.fx.speeds ) {
					opt.duration = jQuery.fx.speeds[ opt.duration ];

				} else {
					opt.duration = jQuery.fx.speeds._default;
				}
			}
		}

		// Normalize opt.queue - true/undefined/null -> "fx"
		if ( opt.queue == null || opt.queue === true ) {
			opt.queue = "fx";
		}

		// Queueing
		opt.old = opt.complete;

		opt.complete = function() {
			if ( isFunction( opt.old ) ) {
				opt.old.call( this );
			}

			if ( opt.queue ) {
				jQuery.dequeue( this, opt.queue );
			}
		};

		return opt;
	};

	jQuery.fn.extend( {
		fadeTo: function( speed, to, easing, callback ) {

			// Show any hidden elements after setting opacity to 0
			return this.filter( isHiddenWithinTree ).css( "opacity", 0 ).show()

				// Animate to the value specified
				.end().animate( { opacity: to }, speed, easing, callback );
		},
		animate: function( prop, speed, easing, callback ) {
			var empty = jQuery.isEmptyObject( prop ),
				optall = jQuery.speed( speed, easing, callback ),
				doAnimation = function() {

					// Operate on a copy of prop so per-property easing won't be lost
					var anim = Animation( this, jQuery.extend( {}, prop ), optall );

					// Empty animations, or finishing resolves immediately
					if ( empty || dataPriv.get( this, "finish" ) ) {
						anim.stop( true );
					}
				};

			doAnimation.finish = doAnimation;

			return empty || optall.queue === false ?
				this.each( doAnimation ) :
				this.queue( optall.queue, doAnimation );
		},
		stop: function( type, clearQueue, gotoEnd ) {
			var stopQueue = function( hooks ) {
				var stop = hooks.stop;
				delete hooks.stop;
				stop( gotoEnd );
			};

			if ( typeof type !== "string" ) {
				gotoEnd = clearQueue;
				clearQueue = type;
				type = undefined;
			}
			if ( clearQueue ) {
				this.queue( type || "fx", [] );
			}

			return this.each( function() {
				var dequeue = true,
					index = type != null && type + "queueHooks",
					timers = jQuery.timers,
					data = dataPriv.get( this );

				if ( index ) {
					if ( data[ index ] && data[ index ].stop ) {
						stopQueue( data[ index ] );
					}
				} else {
					for ( index in data ) {
						if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
							stopQueue( data[ index ] );
						}
					}
				}

				for ( index = timers.length; index--; ) {
					if ( timers[ index ].elem === this &&
						( type == null || timers[ index ].queue === type ) ) {

						timers[ index ].anim.stop( gotoEnd );
						dequeue = false;
						timers.splice( index, 1 );
					}
				}

				// Start the next in the queue if the last step wasn't forced.
				// Timers currently will call their complete callbacks, which
				// will dequeue but only if they were gotoEnd.
				if ( dequeue || !gotoEnd ) {
					jQuery.dequeue( this, type );
				}
			} );
		},
		finish: function( type ) {
			if ( type !== false ) {
				type = type || "fx";
			}
			return this.each( function() {
				var index,
					data = dataPriv.get( this ),
					queue = data[ type + "queue" ],
					hooks = data[ type + "queueHooks" ],
					timers = jQuery.timers,
					length = queue ? queue.length : 0;

				// Enable finishing flag on private data
				data.finish = true;

				// Empty the queue first
				jQuery.queue( this, type, [] );

				if ( hooks && hooks.stop ) {
					hooks.stop.call( this, true );
				}

				// Look for any active animations, and finish them
				for ( index = timers.length; index--; ) {
					if ( timers[ index ].elem === this && timers[ index ].queue === type ) {
						timers[ index ].anim.stop( true );
						timers.splice( index, 1 );
					}
				}

				// Look for any animations in the old queue and finish them
				for ( index = 0; index < length; index++ ) {
					if ( queue[ index ] && queue[ index ].finish ) {
						queue[ index ].finish.call( this );
					}
				}

				// Turn off finishing flag
				delete data.finish;
			} );
		}
	} );

	jQuery.each( [ "toggle", "show", "hide" ], function( _i, name ) {
		var cssFn = jQuery.fn[ name ];
		jQuery.fn[ name ] = function( speed, easing, callback ) {
			return speed == null || typeof speed === "boolean" ?
				cssFn.apply( this, arguments ) :
				this.animate( genFx( name, true ), speed, easing, callback );
		};
	} );

	// Generate shortcuts for custom animations
	jQuery.each( {
		slideDown: genFx( "show" ),
		slideUp: genFx( "hide" ),
		slideToggle: genFx( "toggle" ),
		fadeIn: { opacity: "show" },
		fadeOut: { opacity: "hide" },
		fadeToggle: { opacity: "toggle" }
	}, function( name, props ) {
		jQuery.fn[ name ] = function( speed, easing, callback ) {
			return this.animate( props, speed, easing, callback );
		};
	} );

	jQuery.timers = [];
	jQuery.fx.tick = function() {
		var timer,
			i = 0,
			timers = jQuery.timers;

		fxNow = Date.now();

		for ( ; i < timers.length; i++ ) {
			timer = timers[ i ];

			// Run the timer and safely remove it when done (allowing for external removal)
			if ( !timer() && timers[ i ] === timer ) {
				timers.splice( i--, 1 );
			}
		}

		if ( !timers.length ) {
			jQuery.fx.stop();
		}
		fxNow = undefined;
	};

	jQuery.fx.timer = function( timer ) {
		jQuery.timers.push( timer );
		jQuery.fx.start();
	};

	jQuery.fx.interval = 13;
	jQuery.fx.start = function() {
		if ( inProgress ) {
			return;
		}

		inProgress = true;
		schedule();
	};

	jQuery.fx.stop = function() {
		inProgress = null;
	};

	jQuery.fx.speeds = {
		slow: 600,
		fast: 200,

		// Default speed
		_default: 400
	};


	// Based off of the plugin by Clint Helfers, with permission.
	jQuery.fn.delay = function( time, type ) {
		time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
		type = type || "fx";

		return this.queue( type, function( next, hooks ) {
			var timeout = window.setTimeout( next, time );
			hooks.stop = function() {
				window.clearTimeout( timeout );
			};
		} );
	};


	( function() {
		var input = document.createElement( "input" ),
			select = document.createElement( "select" ),
			opt = select.appendChild( document.createElement( "option" ) );

		input.type = "checkbox";

		// Support: Android <=4.3 only
		// Default value for a checkbox should be "on"
		support.checkOn = input.value !== "";

		// Support: IE <=11 only
		// Must access selectedIndex to make default options select
		support.optSelected = opt.selected;

		// Support: IE <=11 only
		// An input loses its value after becoming a radio
		input = document.createElement( "input" );
		input.value = "t";
		input.type = "radio";
		support.radioValue = input.value === "t";
	} )();


	var boolHook,
		attrHandle = jQuery.expr.attrHandle;

	jQuery.fn.extend( {
		attr: function( name, value ) {
			return access( this, jQuery.attr, name, value, arguments.length > 1 );
		},

		removeAttr: function( name ) {
			return this.each( function() {
				jQuery.removeAttr( this, name );
			} );
		}
	} );

	jQuery.extend( {
		attr: function( elem, name, value ) {
			var ret, hooks,
				nType = elem.nodeType;

			// Don't get/set attributes on text, comment and attribute nodes
			if ( nType === 3 || nType === 8 || nType === 2 ) {
				return;
			}

			// Fallback to prop when attributes are not supported
			if ( typeof elem.getAttribute === "undefined" ) {
				return jQuery.prop( elem, name, value );
			}

			// Attribute hooks are determined by the lowercase version
			// Grab necessary hook if one is defined
			if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {
				hooks = jQuery.attrHooks[ name.toLowerCase() ] ||
					( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );
			}

			if ( value !== undefined ) {
				if ( value === null ) {
					jQuery.removeAttr( elem, name );
					return;
				}

				if ( hooks && "set" in hooks &&
					( ret = hooks.set( elem, value, name ) ) !== undefined ) {
					return ret;
				}

				elem.setAttribute( name, value + "" );
				return value;
			}

			if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
				return ret;
			}

			ret = jQuery.find.attr( elem, name );

			// Non-existent attributes return null, we normalize to undefined
			return ret == null ? undefined : ret;
		},

		attrHooks: {
			type: {
				set: function( elem, value ) {
					if ( !support.radioValue && value === "radio" &&
						nodeName( elem, "input" ) ) {
						var val = elem.value;
						elem.setAttribute( "type", value );
						if ( val ) {
							elem.value = val;
						}
						return value;
					}
				}
			}
		},

		removeAttr: function( elem, value ) {
			var name,
				i = 0,

				// Attribute names can contain non-HTML whitespace characters
				// https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
				attrNames = value && value.match( rnothtmlwhite );

			if ( attrNames && elem.nodeType === 1 ) {
				while ( ( name = attrNames[ i++ ] ) ) {
					elem.removeAttribute( name );
				}
			}
		}
	} );

	// Hooks for boolean attributes
	boolHook = {
		set: function( elem, value, name ) {
			if ( value === false ) {

				// Remove boolean attributes when set to false
				jQuery.removeAttr( elem, name );
			} else {
				elem.setAttribute( name, name );
			}
			return name;
		}
	};

	jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( _i, name ) {
		var getter = attrHandle[ name ] || jQuery.find.attr;

		attrHandle[ name ] = function( elem, name, isXML ) {
			var ret, handle,
				lowercaseName = name.toLowerCase();

			if ( !isXML ) {

				// Avoid an infinite loop by temporarily removing this function from the getter
				handle = attrHandle[ lowercaseName ];
				attrHandle[ lowercaseName ] = ret;
				ret = getter( elem, name, isXML ) != null ?
					lowercaseName :
					null;
				attrHandle[ lowercaseName ] = handle;
			}
			return ret;
		};
	} );




	var rfocusable = /^(?:input|select|textarea|button)$/i,
		rclickable = /^(?:a|area)$/i;

	jQuery.fn.extend( {
		prop: function( name, value ) {
			return access( this, jQuery.prop, name, value, arguments.length > 1 );
		},

		removeProp: function( name ) {
			return this.each( function() {
				delete this[ jQuery.propFix[ name ] || name ];
			} );
		}
	} );

	jQuery.extend( {
		prop: function( elem, name, value ) {
			var ret, hooks,
				nType = elem.nodeType;

			// Don't get/set properties on text, comment and attribute nodes
			if ( nType === 3 || nType === 8 || nType === 2 ) {
				return;
			}

			if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {

				// Fix name and attach hooks
				name = jQuery.propFix[ name ] || name;
				hooks = jQuery.propHooks[ name ];
			}

			if ( value !== undefined ) {
				if ( hooks && "set" in hooks &&
					( ret = hooks.set( elem, value, name ) ) !== undefined ) {
					return ret;
				}

				return ( elem[ name ] = value );
			}

			if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
				return ret;
			}

			return elem[ name ];
		},

		propHooks: {
			tabIndex: {
				get: function( elem ) {

					// Support: IE <=9 - 11 only
					// elem.tabIndex doesn't always return the
					// correct value when it hasn't been explicitly set
					// Use proper attribute retrieval (trac-12072)
					var tabindex = jQuery.find.attr( elem, "tabindex" );

					if ( tabindex ) {
						return parseInt( tabindex, 10 );
					}

					if (
						rfocusable.test( elem.nodeName ) ||
						rclickable.test( elem.nodeName ) &&
						elem.href
					) {
						return 0;
					}

					return -1;
				}
			}
		},

		propFix: {
			"for": "htmlFor",
			"class": "className"
		}
	} );

	// Support: IE <=11 only
	// Accessing the selectedIndex property
	// forces the browser to respect setting selected
	// on the option
	// The getter ensures a default option is selected
	// when in an optgroup
	// eslint rule "no-unused-expressions" is disabled for this code
	// since it considers such accessions noop
	if ( !support.optSelected ) {
		jQuery.propHooks.selected = {
			get: function( elem ) {

				/* eslint no-unused-expressions: "off" */

				var parent = elem.parentNode;
				if ( parent && parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
				return null;
			},
			set: function( elem ) {

				/* eslint no-unused-expressions: "off" */

				var parent = elem.parentNode;
				if ( parent ) {
					parent.selectedIndex;

					if ( parent.parentNode ) {
						parent.parentNode.selectedIndex;
					}
				}
			}
		};
	}

	jQuery.each( [
		"tabIndex",
		"readOnly",
		"maxLength",
		"cellSpacing",
		"cellPadding",
		"rowSpan",
		"colSpan",
		"useMap",
		"frameBorder",
		"contentEditable"
	], function() {
		jQuery.propFix[ this.toLowerCase() ] = this;
	} );




		// Strip and collapse whitespace according to HTML spec
		// https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace
		function stripAndCollapse( value ) {
			var tokens = value.match( rnothtmlwhite ) || [];
			return tokens.join( " " );
		}


	function getClass( elem ) {
		return elem.getAttribute && elem.getAttribute( "class" ) || "";
	}

	function classesToArray( value ) {
		if ( Array.isArray( value ) ) {
			return value;
		}
		if ( typeof value === "string" ) {
			return value.match( rnothtmlwhite ) || [];
		}
		return [];
	}

	jQuery.fn.extend( {
		addClass: function( value ) {
			var classNames, cur, curValue, className, i, finalValue;

			if ( isFunction( value ) ) {
				return this.each( function( j ) {
					jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );
				} );
			}

			classNames = classesToArray( value );

			if ( classNames.length ) {
				return this.each( function() {
					curValue = getClass( this );
					cur = this.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

					if ( cur ) {
						for ( i = 0; i < classNames.length; i++ ) {
							className = classNames[ i ];
							if ( cur.indexOf( " " + className + " " ) < 0 ) {
								cur += className + " ";
							}
						}

						// Only assign if different to avoid unneeded rendering.
						finalValue = stripAndCollapse( cur );
						if ( curValue !== finalValue ) {
							this.setAttribute( "class", finalValue );
						}
					}
				} );
			}

			return this;
		},

		removeClass: function( value ) {
			var classNames, cur, curValue, className, i, finalValue;

			if ( isFunction( value ) ) {
				return this.each( function( j ) {
					jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );
				} );
			}

			if ( !arguments.length ) {
				return this.attr( "class", "" );
			}

			classNames = classesToArray( value );

			if ( classNames.length ) {
				return this.each( function() {
					curValue = getClass( this );

					// This expression is here for better compressibility (see addClass)
					cur = this.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

					if ( cur ) {
						for ( i = 0; i < classNames.length; i++ ) {
							className = classNames[ i ];

							// Remove *all* instances
							while ( cur.indexOf( " " + className + " " ) > -1 ) {
								cur = cur.replace( " " + className + " ", " " );
							}
						}

						// Only assign if different to avoid unneeded rendering.
						finalValue = stripAndCollapse( cur );
						if ( curValue !== finalValue ) {
							this.setAttribute( "class", finalValue );
						}
					}
				} );
			}

			return this;
		},

		toggleClass: function( value, stateVal ) {
			var classNames, className, i, self,
				type = typeof value,
				isValidValue = type === "string" || Array.isArray( value );

			if ( isFunction( value ) ) {
				return this.each( function( i ) {
					jQuery( this ).toggleClass(
						value.call( this, i, getClass( this ), stateVal ),
						stateVal
					);
				} );
			}

			if ( typeof stateVal === "boolean" && isValidValue ) {
				return stateVal ? this.addClass( value ) : this.removeClass( value );
			}

			classNames = classesToArray( value );

			return this.each( function() {
				if ( isValidValue ) {

					// Toggle individual class names
					self = jQuery( this );

					for ( i = 0; i < classNames.length; i++ ) {
						className = classNames[ i ];

						// Check each className given, space separated list
						if ( self.hasClass( className ) ) {
							self.removeClass( className );
						} else {
							self.addClass( className );
						}
					}

				// Toggle whole class name
				} else if ( value === undefined || type === "boolean" ) {
					className = getClass( this );
					if ( className ) {

						// Store className if set
						dataPriv.set( this, "__className__", className );
					}

					// If the element has a class name or if we're passed `false`,
					// then remove the whole classname (if there was one, the above saved it).
					// Otherwise bring back whatever was previously saved (if anything),
					// falling back to the empty string if nothing was stored.
					if ( this.setAttribute ) {
						this.setAttribute( "class",
							className || value === false ?
								"" :
								dataPriv.get( this, "__className__" ) || ""
						);
					}
				}
			} );
		},

		hasClass: function( selector ) {
			var className, elem,
				i = 0;

			className = " " + selector + " ";
			while ( ( elem = this[ i++ ] ) ) {
				if ( elem.nodeType === 1 &&
					( " " + stripAndCollapse( getClass( elem ) ) + " " ).indexOf( className ) > -1 ) {
					return true;
				}
			}

			return false;
		}
	} );




	var rreturn = /\r/g;

	jQuery.fn.extend( {
		val: function( value ) {
			var hooks, ret, valueIsFunction,
				elem = this[ 0 ];

			if ( !arguments.length ) {
				if ( elem ) {
					hooks = jQuery.valHooks[ elem.type ] ||
						jQuery.valHooks[ elem.nodeName.toLowerCase() ];

					if ( hooks &&
						"get" in hooks &&
						( ret = hooks.get( elem, "value" ) ) !== undefined
					) {
						return ret;
					}

					ret = elem.value;

					// Handle most common string cases
					if ( typeof ret === "string" ) {
						return ret.replace( rreturn, "" );
					}

					// Handle cases where value is null/undef or number
					return ret == null ? "" : ret;
				}

				return;
			}

			valueIsFunction = isFunction( value );

			return this.each( function( i ) {
				var val;

				if ( this.nodeType !== 1 ) {
					return;
				}

				if ( valueIsFunction ) {
					val = value.call( this, i, jQuery( this ).val() );
				} else {
					val = value;
				}

				// Treat null/undefined as ""; convert numbers to string
				if ( val == null ) {
					val = "";

				} else if ( typeof val === "number" ) {
					val += "";

				} else if ( Array.isArray( val ) ) {
					val = jQuery.map( val, function( value ) {
						return value == null ? "" : value + "";
					} );
				}

				hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

				// If set returns undefined, fall back to normal setting
				if ( !hooks || !( "set" in hooks ) || hooks.set( this, val, "value" ) === undefined ) {
					this.value = val;
				}
			} );
		}
	} );

	jQuery.extend( {
		valHooks: {
			option: {
				get: function( elem ) {

					var val = jQuery.find.attr( elem, "value" );
					return val != null ?
						val :

						// Support: IE <=10 - 11 only
						// option.text throws exceptions (trac-14686, trac-14858)
						// Strip and collapse whitespace
						// https://html.spec.whatwg.org/#strip-and-collapse-whitespace
						stripAndCollapse( jQuery.text( elem ) );
				}
			},
			select: {
				get: function( elem ) {
					var value, option, i,
						options = elem.options,
						index = elem.selectedIndex,
						one = elem.type === "select-one",
						values = one ? null : [],
						max = one ? index + 1 : options.length;

					if ( index < 0 ) {
						i = max;

					} else {
						i = one ? index : 0;
					}

					// Loop through all the selected options
					for ( ; i < max; i++ ) {
						option = options[ i ];

						// Support: IE <=9 only
						// IE8-9 doesn't update selected after form reset (trac-2551)
						if ( ( option.selected || i === index ) &&

								// Don't return options that are disabled or in a disabled optgroup
								!option.disabled &&
								( !option.parentNode.disabled ||
									!nodeName( option.parentNode, "optgroup" ) ) ) {

							// Get the specific value for the option
							value = jQuery( option ).val();

							// We don't need an array for one selects
							if ( one ) {
								return value;
							}

							// Multi-Selects return an array
							values.push( value );
						}
					}

					return values;
				},

				set: function( elem, value ) {
					var optionSet, option,
						options = elem.options,
						values = jQuery.makeArray( value ),
						i = options.length;

					while ( i-- ) {
						option = options[ i ];

						/* eslint-disable no-cond-assign */

						if ( option.selected =
							jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1
						) {
							optionSet = true;
						}

						/* eslint-enable no-cond-assign */
					}

					// Force browsers to behave consistently when non-matching value is set
					if ( !optionSet ) {
						elem.selectedIndex = -1;
					}
					return values;
				}
			}
		}
	} );

	// Radios and checkboxes getter/setter
	jQuery.each( [ "radio", "checkbox" ], function() {
		jQuery.valHooks[ this ] = {
			set: function( elem, value ) {
				if ( Array.isArray( value ) ) {
					return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );
				}
			}
		};
		if ( !support.checkOn ) {
			jQuery.valHooks[ this ].get = function( elem ) {
				return elem.getAttribute( "value" ) === null ? "on" : elem.value;
			};
		}
	} );




	// Return jQuery for attributes-only inclusion
	var location = window.location;

	var nonce = { guid: Date.now() };

	var rquery = ( /\?/ );



	// Cross-browser xml parsing
	jQuery.parseXML = function( data ) {
		var xml, parserErrorElem;
		if ( !data || typeof data !== "string" ) {
			return null;
		}

		// Support: IE 9 - 11 only
		// IE throws on parseFromString with invalid input.
		try {
			xml = ( new window.DOMParser() ).parseFromString( data, "text/xml" );
		} catch ( e ) {}

		parserErrorElem = xml && xml.getElementsByTagName( "parsererror" )[ 0 ];
		if ( !xml || parserErrorElem ) {
			jQuery.error( "Invalid XML: " + (
				parserErrorElem ?
					jQuery.map( parserErrorElem.childNodes, function( el ) {
						return el.textContent;
					} ).join( "\n" ) :
					data
			) );
		}
		return xml;
	};


	var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
		stopPropagationCallback = function( e ) {
			e.stopPropagation();
		};

	jQuery.extend( jQuery.event, {

		trigger: function( event, data, elem, onlyHandlers ) {

			var i, cur, tmp, bubbleType, ontype, handle, special, lastElement,
				eventPath = [ elem || document ],
				type = hasOwn.call( event, "type" ) ? event.type : event,
				namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split( "." ) : [];

			cur = lastElement = tmp = elem = elem || document;

			// Don't do events on text and comment nodes
			if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
				return;
			}

			// focus/blur morphs to focusin/out; ensure we're not firing them right now
			if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
				return;
			}

			if ( type.indexOf( "." ) > -1 ) {

				// Namespaced trigger; create a regexp to match event type in handle()
				namespaces = type.split( "." );
				type = namespaces.shift();
				namespaces.sort();
			}
			ontype = type.indexOf( ":" ) < 0 && "on" + type;

			// Caller can pass in a jQuery.Event object, Object, or just an event type string
			event = event[ jQuery.expando ] ?
				event :
				new jQuery.Event( type, typeof event === "object" && event );

			// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
			event.isTrigger = onlyHandlers ? 2 : 3;
			event.namespace = namespaces.join( "." );
			event.rnamespace = event.namespace ?
				new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :
				null;

			// Clean up the event in case it is being reused
			event.result = undefined;
			if ( !event.target ) {
				event.target = elem;
			}

			// Clone any incoming data and prepend the event, creating the handler arg list
			data = data == null ?
				[ event ] :
				jQuery.makeArray( data, [ event ] );

			// Allow special events to draw outside the lines
			special = jQuery.event.special[ type ] || {};
			if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {
				return;
			}

			// Determine event propagation path in advance, per W3C events spec (trac-9951)
			// Bubble up to document, then to window; watch for a global ownerDocument var (trac-9724)
			if ( !onlyHandlers && !special.noBubble && !isWindow( elem ) ) {

				bubbleType = special.delegateType || type;
				if ( !rfocusMorph.test( bubbleType + type ) ) {
					cur = cur.parentNode;
				}
				for ( ; cur; cur = cur.parentNode ) {
					eventPath.push( cur );
					tmp = cur;
				}

				// Only add window if we got to document (e.g., not plain obj or detached DOM)
				if ( tmp === ( elem.ownerDocument || document ) ) {
					eventPath.push( tmp.defaultView || tmp.parentWindow || window );
				}
			}

			// Fire handlers on the event path
			i = 0;
			while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {
				lastElement = cur;
				event.type = i > 1 ?
					bubbleType :
					special.bindType || type;

				// jQuery handler
				handle = ( dataPriv.get( cur, "events" ) || Object.create( null ) )[ event.type ] &&
					dataPriv.get( cur, "handle" );
				if ( handle ) {
					handle.apply( cur, data );
				}

				// Native handler
				handle = ontype && cur[ ontype ];
				if ( handle && handle.apply && acceptData( cur ) ) {
					event.result = handle.apply( cur, data );
					if ( event.result === false ) {
						event.preventDefault();
					}
				}
			}
			event.type = type;

			// If nobody prevented the default action, do it now
			if ( !onlyHandlers && !event.isDefaultPrevented() ) {

				if ( ( !special._default ||
					special._default.apply( eventPath.pop(), data ) === false ) &&
					acceptData( elem ) ) {

					// Call a native DOM method on the target with the same name as the event.
					// Don't do default actions on window, that's where global variables be (trac-6170)
					if ( ontype && isFunction( elem[ type ] ) && !isWindow( elem ) ) {

						// Don't re-trigger an onFOO event when we call its FOO() method
						tmp = elem[ ontype ];

						if ( tmp ) {
							elem[ ontype ] = null;
						}

						// Prevent re-triggering of the same event, since we already bubbled it above
						jQuery.event.triggered = type;

						if ( event.isPropagationStopped() ) {
							lastElement.addEventListener( type, stopPropagationCallback );
						}

						elem[ type ]();

						if ( event.isPropagationStopped() ) {
							lastElement.removeEventListener( type, stopPropagationCallback );
						}

						jQuery.event.triggered = undefined;

						if ( tmp ) {
							elem[ ontype ] = tmp;
						}
					}
				}
			}

			return event.result;
		},

		// Piggyback on a donor event to simulate a different one
		// Used only for `focus(in | out)` events
		simulate: function( type, elem, event ) {
			var e = jQuery.extend(
				new jQuery.Event(),
				event,
				{
					type: type,
					isSimulated: true
				}
			);

			jQuery.event.trigger( e, null, elem );
		}

	} );

	jQuery.fn.extend( {

		trigger: function( type, data ) {
			return this.each( function() {
				jQuery.event.trigger( type, data, this );
			} );
		},
		triggerHandler: function( type, data ) {
			var elem = this[ 0 ];
			if ( elem ) {
				return jQuery.event.trigger( type, data, elem, true );
			}
		}
	} );


	var
		rbracket = /\[\]$/,
		rCRLF = /\r?\n/g,
		rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
		rsubmittable = /^(?:input|select|textarea|keygen)/i;

	function buildParams( prefix, obj, traditional, add ) {
		var name;

		if ( Array.isArray( obj ) ) {

			// Serialize array item.
			jQuery.each( obj, function( i, v ) {
				if ( traditional || rbracket.test( prefix ) ) {

					// Treat each array item as a scalar.
					add( prefix, v );

				} else {

					// Item is non-scalar (array or object), encode its numeric index.
					buildParams(
						prefix + "[" + ( typeof v === "object" && v != null ? i : "" ) + "]",
						v,
						traditional,
						add
					);
				}
			} );

		} else if ( !traditional && toType( obj ) === "object" ) {

			// Serialize object item.
			for ( name in obj ) {
				buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
			}

		} else {

			// Serialize scalar item.
			add( prefix, obj );
		}
	}

	// Serialize an array of form elements or a set of
	// key/values into a query string
	jQuery.param = function( a, traditional ) {
		var prefix,
			s = [],
			add = function( key, valueOrFunction ) {

				// If value is a function, invoke it and use its return value
				var value = isFunction( valueOrFunction ) ?
					valueOrFunction() :
					valueOrFunction;

				s[ s.length ] = encodeURIComponent( key ) + "=" +
					encodeURIComponent( value == null ? "" : value );
			};

		if ( a == null ) {
			return "";
		}

		// If an array was passed in, assume that it is an array of form elements.
		if ( Array.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {

			// Serialize the form elements
			jQuery.each( a, function() {
				add( this.name, this.value );
			} );

		} else {

			// If traditional, encode the "old" way (the way 1.3.2 or older
			// did it), otherwise encode params recursively.
			for ( prefix in a ) {
				buildParams( prefix, a[ prefix ], traditional, add );
			}
		}

		// Return the resulting serialization
		return s.join( "&" );
	};

	jQuery.fn.extend( {
		serialize: function() {
			return jQuery.param( this.serializeArray() );
		},
		serializeArray: function() {
			return this.map( function() {

				// Can add propHook for "elements" to filter or add form elements
				var elements = jQuery.prop( this, "elements" );
				return elements ? jQuery.makeArray( elements ) : this;
			} ).filter( function() {
				var type = this.type;

				// Use .is( ":disabled" ) so that fieldset[disabled] works
				return this.name && !jQuery( this ).is( ":disabled" ) &&
					rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&
					( this.checked || !rcheckableType.test( type ) );
			} ).map( function( _i, elem ) {
				var val = jQuery( this ).val();

				if ( val == null ) {
					return null;
				}

				if ( Array.isArray( val ) ) {
					return jQuery.map( val, function( val ) {
						return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
					} );
				}

				return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
			} ).get();
		}
	} );


	var
		r20 = /%20/g,
		rhash = /#.*$/,
		rantiCache = /([?&])_=[^&]*/,
		rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg,

		// trac-7653, trac-8125, trac-8152: local protocol detection
		rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
		rnoContent = /^(?:GET|HEAD)$/,
		rprotocol = /^\/\//,

		/* Prefilters
		 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
		 * 2) These are called:
		 *    - BEFORE asking for a transport
		 *    - AFTER param serialization (s.data is a string if s.processData is true)
		 * 3) key is the dataType
		 * 4) the catchall symbol "*" can be used
		 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
		 */
		prefilters = {},

		/* Transports bindings
		 * 1) key is the dataType
		 * 2) the catchall symbol "*" can be used
		 * 3) selection will start with transport dataType and THEN go to "*" if needed
		 */
		transports = {},

		// Avoid comment-prolog char sequence (trac-10098); must appease lint and evade compression
		allTypes = "*/".concat( "*" ),

		// Anchor tag for parsing the document origin
		originAnchor = document.createElement( "a" );

	originAnchor.href = location.href;

	// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
	function addToPrefiltersOrTransports( structure ) {

		// dataTypeExpression is optional and defaults to "*"
		return function( dataTypeExpression, func ) {

			if ( typeof dataTypeExpression !== "string" ) {
				func = dataTypeExpression;
				dataTypeExpression = "*";
			}

			var dataType,
				i = 0,
				dataTypes = dataTypeExpression.toLowerCase().match( rnothtmlwhite ) || [];

			if ( isFunction( func ) ) {

				// For each dataType in the dataTypeExpression
				while ( ( dataType = dataTypes[ i++ ] ) ) {

					// Prepend if requested
					if ( dataType[ 0 ] === "+" ) {
						dataType = dataType.slice( 1 ) || "*";
						( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );

					// Otherwise append
					} else {
						( structure[ dataType ] = structure[ dataType ] || [] ).push( func );
					}
				}
			}
		};
	}

	// Base inspection function for prefilters and transports
	function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {

		var inspected = {},
			seekingTransport = ( structure === transports );

		function inspect( dataType ) {
			var selected;
			inspected[ dataType ] = true;
			jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {
				var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );
				if ( typeof dataTypeOrTransport === "string" &&
					!seekingTransport && !inspected[ dataTypeOrTransport ] ) {

					options.dataTypes.unshift( dataTypeOrTransport );
					inspect( dataTypeOrTransport );
					return false;
				} else if ( seekingTransport ) {
					return !( selected = dataTypeOrTransport );
				}
			} );
			return selected;
		}

		return inspect( options.dataTypes[ 0 ] ) || !inspected[ "*" ] && inspect( "*" );
	}

	// A special extend for ajax options
	// that takes "flat" options (not to be deep extended)
	// Fixes trac-9887
	function ajaxExtend( target, src ) {
		var key, deep,
			flatOptions = jQuery.ajaxSettings.flatOptions || {};

		for ( key in src ) {
			if ( src[ key ] !== undefined ) {
				( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
			}
		}
		if ( deep ) {
			jQuery.extend( true, target, deep );
		}

		return target;
	}

	/* Handles responses to an ajax request:
	 * - finds the right dataType (mediates between content-type and expected dataType)
	 * - returns the corresponding response
	 */
	function ajaxHandleResponses( s, jqXHR, responses ) {

		var ct, type, finalDataType, firstDataType,
			contents = s.contents,
			dataTypes = s.dataTypes;

		// Remove auto dataType and get content-type in the process
		while ( dataTypes[ 0 ] === "*" ) {
			dataTypes.shift();
			if ( ct === undefined ) {
				ct = s.mimeType || jqXHR.getResponseHeader( "Content-Type" );
			}
		}

		// Check if we're dealing with a known content-type
		if ( ct ) {
			for ( type in contents ) {
				if ( contents[ type ] && contents[ type ].test( ct ) ) {
					dataTypes.unshift( type );
					break;
				}
			}
		}

		// Check to see if we have a response for the expected dataType
		if ( dataTypes[ 0 ] in responses ) {
			finalDataType = dataTypes[ 0 ];
		} else {

			// Try convertible dataTypes
			for ( type in responses ) {
				if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[ 0 ] ] ) {
					finalDataType = type;
					break;
				}
				if ( !firstDataType ) {
					firstDataType = type;
				}
			}

			// Or just use first one
			finalDataType = finalDataType || firstDataType;
		}

		// If we found a dataType
		// We add the dataType to the list if needed
		// and return the corresponding response
		if ( finalDataType ) {
			if ( finalDataType !== dataTypes[ 0 ] ) {
				dataTypes.unshift( finalDataType );
			}
			return responses[ finalDataType ];
		}
	}

	/* Chain conversions given the request and the original response
	 * Also sets the responseXXX fields on the jqXHR instance
	 */
	function ajaxConvert( s, response, jqXHR, isSuccess ) {
		var conv2, current, conv, tmp, prev,
			converters = {},

			// Work with a copy of dataTypes in case we need to modify it for conversion
			dataTypes = s.dataTypes.slice();

		// Create converters map with lowercased keys
		if ( dataTypes[ 1 ] ) {
			for ( conv in s.converters ) {
				converters[ conv.toLowerCase() ] = s.converters[ conv ];
			}
		}

		current = dataTypes.shift();

		// Convert to each sequential dataType
		while ( current ) {

			if ( s.responseFields[ current ] ) {
				jqXHR[ s.responseFields[ current ] ] = response;
			}

			// Apply the dataFilter if provided
			if ( !prev && isSuccess && s.dataFilter ) {
				response = s.dataFilter( response, s.dataType );
			}

			prev = current;
			current = dataTypes.shift();

			if ( current ) {

				// There's only work to do if current dataType is non-auto
				if ( current === "*" ) {

					current = prev;

				// Convert response if prev dataType is non-auto and differs from current
				} else if ( prev !== "*" && prev !== current ) {

					// Seek a direct converter
					conv = converters[ prev + " " + current ] || converters[ "* " + current ];

					// If none found, seek a pair
					if ( !conv ) {
						for ( conv2 in converters ) {

							// If conv2 outputs current
							tmp = conv2.split( " " );
							if ( tmp[ 1 ] === current ) {

								// If prev can be converted to accepted input
								conv = converters[ prev + " " + tmp[ 0 ] ] ||
									converters[ "* " + tmp[ 0 ] ];
								if ( conv ) {

									// Condense equivalence converters
									if ( conv === true ) {
										conv = converters[ conv2 ];

									// Otherwise, insert the intermediate dataType
									} else if ( converters[ conv2 ] !== true ) {
										current = tmp[ 0 ];
										dataTypes.unshift( tmp[ 1 ] );
									}
									break;
								}
							}
						}
					}

					// Apply converter (if not an equivalence)
					if ( conv !== true ) {

						// Unless errors are allowed to bubble, catch and return them
						if ( conv && s.throws ) {
							response = conv( response );
						} else {
							try {
								response = conv( response );
							} catch ( e ) {
								return {
									state: "parsererror",
									error: conv ? e : "No conversion from " + prev + " to " + current
								};
							}
						}
					}
				}
			}
		}

		return { state: "success", data: response };
	}

	jQuery.extend( {

		// Counter for holding the number of active queries
		active: 0,

		// Last-Modified header cache for next request
		lastModified: {},
		etag: {},

		ajaxSettings: {
			url: location.href,
			type: "GET",
			isLocal: rlocalProtocol.test( location.protocol ),
			global: true,
			processData: true,
			async: true,
			contentType: "application/x-www-form-urlencoded; charset=UTF-8",

			/*
			timeout: 0,
			data: null,
			dataType: null,
			username: null,
			password: null,
			cache: null,
			throws: false,
			traditional: false,
			headers: {},
			*/

			accepts: {
				"*": allTypes,
				text: "text/plain",
				html: "text/html",
				xml: "application/xml, text/xml",
				json: "application/json, text/javascript"
			},

			contents: {
				xml: /\bxml\b/,
				html: /\bhtml/,
				json: /\bjson\b/
			},

			responseFields: {
				xml: "responseXML",
				text: "responseText",
				json: "responseJSON"
			},

			// Data converters
			// Keys separate source (or catchall "*") and destination types with a single space
			converters: {

				// Convert anything to text
				"* text": String,

				// Text to html (true = no transformation)
				"text html": true,

				// Evaluate text as a json expression
				"text json": JSON.parse,

				// Parse text as xml
				"text xml": jQuery.parseXML
			},

			// For options that shouldn't be deep extended:
			// you can add your own custom options here if
			// and when you create one that shouldn't be
			// deep extended (see ajaxExtend)
			flatOptions: {
				url: true,
				context: true
			}
		},

		// Creates a full fledged settings object into target
		// with both ajaxSettings and settings fields.
		// If target is omitted, writes into ajaxSettings.
		ajaxSetup: function( target, settings ) {
			return settings ?

				// Building a settings object
				ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :

				// Extending ajaxSettings
				ajaxExtend( jQuery.ajaxSettings, target );
		},

		ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
		ajaxTransport: addToPrefiltersOrTransports( transports ),

		// Main method
		ajax: function( url, options ) {

			// If url is an object, simulate pre-1.5 signature
			if ( typeof url === "object" ) {
				options = url;
				url = undefined;
			}

			// Force options to be an object
			options = options || {};

			var transport,

				// URL without anti-cache param
				cacheURL,

				// Response headers
				responseHeadersString,
				responseHeaders,

				// timeout handle
				timeoutTimer,

				// Url cleanup var
				urlAnchor,

				// Request state (becomes false upon send and true upon completion)
				completed,

				// To know if global events are to be dispatched
				fireGlobals,

				// Loop variable
				i,

				// uncached part of the url
				uncached,

				// Create the final options object
				s = jQuery.ajaxSetup( {}, options ),

				// Callbacks context
				callbackContext = s.context || s,

				// Context for global events is callbackContext if it is a DOM node or jQuery collection
				globalEventContext = s.context &&
					( callbackContext.nodeType || callbackContext.jquery ) ?
					jQuery( callbackContext ) :
					jQuery.event,

				// Deferreds
				deferred = jQuery.Deferred(),
				completeDeferred = jQuery.Callbacks( "once memory" ),

				// Status-dependent callbacks
				statusCode = s.statusCode || {},

				// Headers (they are sent all at once)
				requestHeaders = {},
				requestHeadersNames = {},

				// Default abort message
				strAbort = "canceled",

				// Fake xhr
				jqXHR = {
					readyState: 0,

					// Builds headers hashtable if needed
					getResponseHeader: function( key ) {
						var match;
						if ( completed ) {
							if ( !responseHeaders ) {
								responseHeaders = {};
								while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
									responseHeaders[ match[ 1 ].toLowerCase() + " " ] =
										( responseHeaders[ match[ 1 ].toLowerCase() + " " ] || [] )
											.concat( match[ 2 ] );
								}
							}
							match = responseHeaders[ key.toLowerCase() + " " ];
						}
						return match == null ? null : match.join( ", " );
					},

					// Raw string
					getAllResponseHeaders: function() {
						return completed ? responseHeadersString : null;
					},

					// Caches the header
					setRequestHeader: function( name, value ) {
						if ( completed == null ) {
							name = requestHeadersNames[ name.toLowerCase() ] =
								requestHeadersNames[ name.toLowerCase() ] || name;
							requestHeaders[ name ] = value;
						}
						return this;
					},

					// Overrides response content-type header
					overrideMimeType: function( type ) {
						if ( completed == null ) {
							s.mimeType = type;
						}
						return this;
					},

					// Status-dependent callbacks
					statusCode: function( map ) {
						var code;
						if ( map ) {
							if ( completed ) {

								// Execute the appropriate callbacks
								jqXHR.always( map[ jqXHR.status ] );
							} else {

								// Lazy-add the new callbacks in a way that preserves old ones
								for ( code in map ) {
									statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
								}
							}
						}
						return this;
					},

					// Cancel the request
					abort: function( statusText ) {
						var finalText = statusText || strAbort;
						if ( transport ) {
							transport.abort( finalText );
						}
						done( 0, finalText );
						return this;
					}
				};

			// Attach deferreds
			deferred.promise( jqXHR );

			// Add protocol if not provided (prefilters might expect it)
			// Handle falsy url in the settings object (trac-10093: consistency with old signature)
			// We also use the url parameter if available
			s.url = ( ( url || s.url || location.href ) + "" )
				.replace( rprotocol, location.protocol + "//" );

			// Alias method option to type as per ticket trac-12004
			s.type = options.method || options.type || s.method || s.type;

			// Extract dataTypes list
			s.dataTypes = ( s.dataType || "*" ).toLowerCase().match( rnothtmlwhite ) || [ "" ];

			// A cross-domain request is in order when the origin doesn't match the current origin.
			if ( s.crossDomain == null ) {
				urlAnchor = document.createElement( "a" );

				// Support: IE <=8 - 11, Edge 12 - 15
				// IE throws exception on accessing the href property if url is malformed,
				// e.g. http://example.com:80x/
				try {
					urlAnchor.href = s.url;

					// Support: IE <=8 - 11 only
					// Anchor's host property isn't correctly set when s.url is relative
					urlAnchor.href = urlAnchor.href;
					s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !==
						urlAnchor.protocol + "//" + urlAnchor.host;
				} catch ( e ) {

					// If there is an error parsing the URL, assume it is crossDomain,
					// it can be rejected by the transport if it is invalid
					s.crossDomain = true;
				}
			}

			// Convert data if not already a string
			if ( s.data && s.processData && typeof s.data !== "string" ) {
				s.data = jQuery.param( s.data, s.traditional );
			}

			// Apply prefilters
			inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

			// If request was aborted inside a prefilter, stop there
			if ( completed ) {
				return jqXHR;
			}

			// We can fire global events as of now if asked to
			// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (trac-15118)
			fireGlobals = jQuery.event && s.global;

			// Watch for a new set of requests
			if ( fireGlobals && jQuery.active++ === 0 ) {
				jQuery.event.trigger( "ajaxStart" );
			}

			// Uppercase the type
			s.type = s.type.toUpperCase();

			// Determine if request has content
			s.hasContent = !rnoContent.test( s.type );

			// Save the URL in case we're toying with the If-Modified-Since
			// and/or If-None-Match header later on
			// Remove hash to simplify url manipulation
			cacheURL = s.url.replace( rhash, "" );

			// More options handling for requests with no content
			if ( !s.hasContent ) {

				// Remember the hash so we can put it back
				uncached = s.url.slice( cacheURL.length );

				// If data is available and should be processed, append data to url
				if ( s.data && ( s.processData || typeof s.data === "string" ) ) {
					cacheURL += ( rquery.test( cacheURL ) ? "&" : "?" ) + s.data;

					// trac-9682: remove data so that it's not used in an eventual retry
					delete s.data;
				}

				// Add or update anti-cache param if needed
				if ( s.cache === false ) {
					cacheURL = cacheURL.replace( rantiCache, "$1" );
					uncached = ( rquery.test( cacheURL ) ? "&" : "?" ) + "_=" + ( nonce.guid++ ) +
						uncached;
				}

				// Put hash and anti-cache on the URL that will be requested (gh-1732)
				s.url = cacheURL + uncached;

			// Change '%20' to '+' if this is encoded form body content (gh-2658)
			} else if ( s.data && s.processData &&
				( s.contentType || "" ).indexOf( "application/x-www-form-urlencoded" ) === 0 ) {
				s.data = s.data.replace( r20, "+" );
			}

			// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
			if ( s.ifModified ) {
				if ( jQuery.lastModified[ cacheURL ] ) {
					jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ cacheURL ] );
				}
				if ( jQuery.etag[ cacheURL ] ) {
					jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ cacheURL ] );
				}
			}

			// Set the correct header, if data is being sent
			if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
				jqXHR.setRequestHeader( "Content-Type", s.contentType );
			}

			// Set the Accepts header for the server, depending on the dataType
			jqXHR.setRequestHeader(
				"Accept",
				s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?
					s.accepts[ s.dataTypes[ 0 ] ] +
						( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
					s.accepts[ "*" ]
			);

			// Check for headers option
			for ( i in s.headers ) {
				jqXHR.setRequestHeader( i, s.headers[ i ] );
			}

			// Allow custom headers/mimetypes and early abort
			if ( s.beforeSend &&
				( s.beforeSend.call( callbackContext, jqXHR, s ) === false || completed ) ) {

				// Abort if not done already and return
				return jqXHR.abort();
			}

			// Aborting is no longer a cancellation
			strAbort = "abort";

			// Install callbacks on deferreds
			completeDeferred.add( s.complete );
			jqXHR.done( s.success );
			jqXHR.fail( s.error );

			// Get transport
			transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

			// If no transport, we auto-abort
			if ( !transport ) {
				done( -1, "No Transport" );
			} else {
				jqXHR.readyState = 1;

				// Send global event
				if ( fireGlobals ) {
					globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
				}

				// If request was aborted inside ajaxSend, stop there
				if ( completed ) {
					return jqXHR;
				}

				// Timeout
				if ( s.async && s.timeout > 0 ) {
					timeoutTimer = window.setTimeout( function() {
						jqXHR.abort( "timeout" );
					}, s.timeout );
				}

				try {
					completed = false;
					transport.send( requestHeaders, done );
				} catch ( e ) {

					// Rethrow post-completion exceptions
					if ( completed ) {
						throw e;
					}

					// Propagate others as results
					done( -1, e );
				}
			}

			// Callback for when everything is done
			function done( status, nativeStatusText, responses, headers ) {
				var isSuccess, success, error, response, modified,
					statusText = nativeStatusText;

				// Ignore repeat invocations
				if ( completed ) {
					return;
				}

				completed = true;

				// Clear timeout if it exists
				if ( timeoutTimer ) {
					window.clearTimeout( timeoutTimer );
				}

				// Dereference transport for early garbage collection
				// (no matter how long the jqXHR object will be used)
				transport = undefined;

				// Cache response headers
				responseHeadersString = headers || "";

				// Set readyState
				jqXHR.readyState = status > 0 ? 4 : 0;

				// Determine if successful
				isSuccess = status >= 200 && status < 300 || status === 304;

				// Get response data
				if ( responses ) {
					response = ajaxHandleResponses( s, jqXHR, responses );
				}

				// Use a noop converter for missing script but not if jsonp
				if ( !isSuccess &&
					jQuery.inArray( "script", s.dataTypes ) > -1 &&
					jQuery.inArray( "json", s.dataTypes ) < 0 ) {
					s.converters[ "text script" ] = function() {};
				}

				// Convert no matter what (that way responseXXX fields are always set)
				response = ajaxConvert( s, response, jqXHR, isSuccess );

				// If successful, handle type chaining
				if ( isSuccess ) {

					// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
					if ( s.ifModified ) {
						modified = jqXHR.getResponseHeader( "Last-Modified" );
						if ( modified ) {
							jQuery.lastModified[ cacheURL ] = modified;
						}
						modified = jqXHR.getResponseHeader( "etag" );
						if ( modified ) {
							jQuery.etag[ cacheURL ] = modified;
						}
					}

					// if no content
					if ( status === 204 || s.type === "HEAD" ) {
						statusText = "nocontent";

					// if not modified
					} else if ( status === 304 ) {
						statusText = "notmodified";

					// If we have data, let's convert it
					} else {
						statusText = response.state;
						success = response.data;
						error = response.error;
						isSuccess = !error;
					}
				} else {

					// Extract error from statusText and normalize for non-aborts
					error = statusText;
					if ( status || !statusText ) {
						statusText = "error";
						if ( status < 0 ) {
							status = 0;
						}
					}
				}

				// Set data for the fake xhr object
				jqXHR.status = status;
				jqXHR.statusText = ( nativeStatusText || statusText ) + "";

				// Success/Error
				if ( isSuccess ) {
					deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
				} else {
					deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
				}

				// Status-dependent callbacks
				jqXHR.statusCode( statusCode );
				statusCode = undefined;

				if ( fireGlobals ) {
					globalEventContext.trigger( isSuccess ? "ajaxSuccess" : "ajaxError",
						[ jqXHR, s, isSuccess ? success : error ] );
				}

				// Complete
				completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

				if ( fireGlobals ) {
					globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );

					// Handle the global AJAX counter
					if ( !( --jQuery.active ) ) {
						jQuery.event.trigger( "ajaxStop" );
					}
				}
			}

			return jqXHR;
		},

		getJSON: function( url, data, callback ) {
			return jQuery.get( url, data, callback, "json" );
		},

		getScript: function( url, callback ) {
			return jQuery.get( url, undefined, callback, "script" );
		}
	} );

	jQuery.each( [ "get", "post" ], function( _i, method ) {
		jQuery[ method ] = function( url, data, callback, type ) {

			// Shift arguments if data argument was omitted
			if ( isFunction( data ) ) {
				type = type || callback;
				callback = data;
				data = undefined;
			}

			// The url can be an options object (which then must have .url)
			return jQuery.ajax( jQuery.extend( {
				url: url,
				type: method,
				dataType: type,
				data: data,
				success: callback
			}, jQuery.isPlainObject( url ) && url ) );
		};
	} );

	jQuery.ajaxPrefilter( function( s ) {
		var i;
		for ( i in s.headers ) {
			if ( i.toLowerCase() === "content-type" ) {
				s.contentType = s.headers[ i ] || "";
			}
		}
	} );


	jQuery._evalUrl = function( url, options, doc ) {
		return jQuery.ajax( {
			url: url,

			// Make this explicit, since user can override this through ajaxSetup (trac-11264)
			type: "GET",
			dataType: "script",
			cache: true,
			async: false,
			global: false,

			// Only evaluate the response if it is successful (gh-4126)
			// dataFilter is not invoked for failure responses, so using it instead
			// of the default converter is kludgy but it works.
			converters: {
				"text script": function() {}
			},
			dataFilter: function( response ) {
				jQuery.globalEval( response, options, doc );
			}
		} );
	};


	jQuery.fn.extend( {
		wrapAll: function( html ) {
			var wrap;

			if ( this[ 0 ] ) {
				if ( isFunction( html ) ) {
					html = html.call( this[ 0 ] );
				}

				// The elements to wrap the target around
				wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );

				if ( this[ 0 ].parentNode ) {
					wrap.insertBefore( this[ 0 ] );
				}

				wrap.map( function() {
					var elem = this;

					while ( elem.firstElementChild ) {
						elem = elem.firstElementChild;
					}

					return elem;
				} ).append( this );
			}

			return this;
		},

		wrapInner: function( html ) {
			if ( isFunction( html ) ) {
				return this.each( function( i ) {
					jQuery( this ).wrapInner( html.call( this, i ) );
				} );
			}

			return this.each( function() {
				var self = jQuery( this ),
					contents = self.contents();

				if ( contents.length ) {
					contents.wrapAll( html );

				} else {
					self.append( html );
				}
			} );
		},

		wrap: function( html ) {
			var htmlIsFunction = isFunction( html );

			return this.each( function( i ) {
				jQuery( this ).wrapAll( htmlIsFunction ? html.call( this, i ) : html );
			} );
		},

		unwrap: function( selector ) {
			this.parent( selector ).not( "body" ).each( function() {
				jQuery( this ).replaceWith( this.childNodes );
			} );
			return this;
		}
	} );


	jQuery.expr.pseudos.hidden = function( elem ) {
		return !jQuery.expr.pseudos.visible( elem );
	};
	jQuery.expr.pseudos.visible = function( elem ) {
		return !!( elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length );
	};




	jQuery.ajaxSettings.xhr = function() {
		try {
			return new window.XMLHttpRequest();
		} catch ( e ) {}
	};

	var xhrSuccessStatus = {

			// File protocol always yields status code 0, assume 200
			0: 200,

			// Support: IE <=9 only
			// trac-1450: sometimes IE returns 1223 when it should be 204
			1223: 204
		},
		xhrSupported = jQuery.ajaxSettings.xhr();

	support.cors = !!xhrSupported && ( "withCredentials" in xhrSupported );
	support.ajax = xhrSupported = !!xhrSupported;

	jQuery.ajaxTransport( function( options ) {
		var callback, errorCallback;

		// Cross domain only allowed if supported through XMLHttpRequest
		if ( support.cors || xhrSupported && !options.crossDomain ) {
			return {
				send: function( headers, complete ) {
					var i,
						xhr = options.xhr();

					xhr.open(
						options.type,
						options.url,
						options.async,
						options.username,
						options.password
					);

					// Apply custom fields if provided
					if ( options.xhrFields ) {
						for ( i in options.xhrFields ) {
							xhr[ i ] = options.xhrFields[ i ];
						}
					}

					// Override mime type if needed
					if ( options.mimeType && xhr.overrideMimeType ) {
						xhr.overrideMimeType( options.mimeType );
					}

					// X-Requested-With header
					// For cross-domain requests, seeing as conditions for a preflight are
					// akin to a jigsaw puzzle, we simply never set it to be sure.
					// (it can always be set on a per-request basis or even using ajaxSetup)
					// For same-domain requests, won't change header if already provided.
					if ( !options.crossDomain && !headers[ "X-Requested-With" ] ) {
						headers[ "X-Requested-With" ] = "XMLHttpRequest";
					}

					// Set headers
					for ( i in headers ) {
						xhr.setRequestHeader( i, headers[ i ] );
					}

					// Callback
					callback = function( type ) {
						return function() {
							if ( callback ) {
								callback = errorCallback = xhr.onload =
									xhr.onerror = xhr.onabort = xhr.ontimeout =
										xhr.onreadystatechange = null;

								if ( type === "abort" ) {
									xhr.abort();
								} else if ( type === "error" ) {

									// Support: IE <=9 only
									// On a manual native abort, IE9 throws
									// errors on any property access that is not readyState
									if ( typeof xhr.status !== "number" ) {
										complete( 0, "error" );
									} else {
										complete(

											// File: protocol always yields status 0; see trac-8605, trac-14207
											xhr.status,
											xhr.statusText
										);
									}
								} else {
									complete(
										xhrSuccessStatus[ xhr.status ] || xhr.status,
										xhr.statusText,

										// Support: IE <=9 only
										// IE9 has no XHR2 but throws on binary (trac-11426)
										// For XHR2 non-text, let the caller handle it (gh-2498)
										( xhr.responseType || "text" ) !== "text"  ||
										typeof xhr.responseText !== "string" ?
											{ binary: xhr.response } :
											{ text: xhr.responseText },
										xhr.getAllResponseHeaders()
									);
								}
							}
						};
					};

					// Listen to events
					xhr.onload = callback();
					errorCallback = xhr.onerror = xhr.ontimeout = callback( "error" );

					// Support: IE 9 only
					// Use onreadystatechange to replace onabort
					// to handle uncaught aborts
					if ( xhr.onabort !== undefined ) {
						xhr.onabort = errorCallback;
					} else {
						xhr.onreadystatechange = function() {

							// Check readyState before timeout as it changes
							if ( xhr.readyState === 4 ) {

								// Allow onerror to be called first,
								// but that will not handle a native abort
								// Also, save errorCallback to a variable
								// as xhr.onerror cannot be accessed
								window.setTimeout( function() {
									if ( callback ) {
										errorCallback();
									}
								} );
							}
						};
					}

					// Create the abort callback
					callback = callback( "abort" );

					try {

						// Do send the request (this may raise an exception)
						xhr.send( options.hasContent && options.data || null );
					} catch ( e ) {

						// trac-14683: Only rethrow if this hasn't been notified as an error yet
						if ( callback ) {
							throw e;
						}
					}
				},

				abort: function() {
					if ( callback ) {
						callback();
					}
				}
			};
		}
	} );




	// Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)
	jQuery.ajaxPrefilter( function( s ) {
		if ( s.crossDomain ) {
			s.contents.script = false;
		}
	} );

	// Install script dataType
	jQuery.ajaxSetup( {
		accepts: {
			script: "text/javascript, application/javascript, " +
				"application/ecmascript, application/x-ecmascript"
		},
		contents: {
			script: /\b(?:java|ecma)script\b/
		},
		converters: {
			"text script": function( text ) {
				jQuery.globalEval( text );
				return text;
			}
		}
	} );

	// Handle cache's special case and crossDomain
	jQuery.ajaxPrefilter( "script", function( s ) {
		if ( s.cache === undefined ) {
			s.cache = false;
		}
		if ( s.crossDomain ) {
			s.type = "GET";
		}
	} );

	// Bind script tag hack transport
	jQuery.ajaxTransport( "script", function( s ) {

		// This transport only deals with cross domain or forced-by-attrs requests
		if ( s.crossDomain || s.scriptAttrs ) {
			var script, callback;
			return {
				send: function( _, complete ) {
					script = jQuery( "<script>" )
						.attr( s.scriptAttrs || {} )
						.prop( { charset: s.scriptCharset, src: s.url } )
						.on( "load error", callback = function( evt ) {
							script.remove();
							callback = null;
							if ( evt ) {
								complete( evt.type === "error" ? 404 : 200, evt.type );
							}
						} );

					// Use native DOM manipulation to avoid our domManip AJAX trickery
					document.head.appendChild( script[ 0 ] );
				},
				abort: function() {
					if ( callback ) {
						callback();
					}
				}
			};
		}
	} );




	var oldCallbacks = [],
		rjsonp = /(=)\?(?=&|$)|\?\?/;

	// Default jsonp settings
	jQuery.ajaxSetup( {
		jsonp: "callback",
		jsonpCallback: function() {
			var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce.guid++ ) );
			this[ callback ] = true;
			return callback;
		}
	} );

	// Detect, normalize options and install callbacks for jsonp requests
	jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

		var callbackName, overwritten, responseContainer,
			jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?
				"url" :
				typeof s.data === "string" &&
					( s.contentType || "" )
						.indexOf( "application/x-www-form-urlencoded" ) === 0 &&
					rjsonp.test( s.data ) && "data"
			);

		// Handle iff the expected data type is "jsonp" or we have a parameter to set
		if ( jsonProp || s.dataTypes[ 0 ] === "jsonp" ) {

			// Get callback name, remembering preexisting value associated with it
			callbackName = s.jsonpCallback = isFunction( s.jsonpCallback ) ?
				s.jsonpCallback() :
				s.jsonpCallback;

			// Insert callback into url or form data
			if ( jsonProp ) {
				s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, "$1" + callbackName );
			} else if ( s.jsonp !== false ) {
				s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
			}

			// Use data converter to retrieve json after script execution
			s.converters[ "script json" ] = function() {
				if ( !responseContainer ) {
					jQuery.error( callbackName + " was not called" );
				}
				return responseContainer[ 0 ];
			};

			// Force json dataType
			s.dataTypes[ 0 ] = "json";

			// Install callback
			overwritten = window[ callbackName ];
			window[ callbackName ] = function() {
				responseContainer = arguments;
			};

			// Clean-up function (fires after converters)
			jqXHR.always( function() {

				// If previous value didn't exist - remove it
				if ( overwritten === undefined ) {
					jQuery( window ).removeProp( callbackName );

				// Otherwise restore preexisting value
				} else {
					window[ callbackName ] = overwritten;
				}

				// Save back as free
				if ( s[ callbackName ] ) {

					// Make sure that re-using the options doesn't screw things around
					s.jsonpCallback = originalSettings.jsonpCallback;

					// Save the callback name for future use
					oldCallbacks.push( callbackName );
				}

				// Call if it was a function and we have a response
				if ( responseContainer && isFunction( overwritten ) ) {
					overwritten( responseContainer[ 0 ] );
				}

				responseContainer = overwritten = undefined;
			} );

			// Delegate to script
			return "script";
		}
	} );




	// Support: Safari 8 only
	// In Safari 8 documents created via document.implementation.createHTMLDocument
	// collapse sibling forms: the second one becomes a child of the first one.
	// Because of that, this security measure has to be disabled in Safari 8.
	// https://bugs.webkit.org/show_bug.cgi?id=137337
	support.createHTMLDocument = ( function() {
		var body = document.implementation.createHTMLDocument( "" ).body;
		body.innerHTML = "<form></form><form></form>";
		return body.childNodes.length === 2;
	} )();


	// Argument "data" should be string of html
	// context (optional): If specified, the fragment will be created in this context,
	// defaults to document
	// keepScripts (optional): If true, will include scripts passed in the html string
	jQuery.parseHTML = function( data, context, keepScripts ) {
		if ( typeof data !== "string" ) {
			return [];
		}
		if ( typeof context === "boolean" ) {
			keepScripts = context;
			context = false;
		}

		var base, parsed, scripts;

		if ( !context ) {

			// Stop scripts or inline event handlers from being executed immediately
			// by using document.implementation
			if ( support.createHTMLDocument ) {
				context = document.implementation.createHTMLDocument( "" );

				// Set the base href for the created document
				// so any parsed elements with URLs
				// are based on the document's URL (gh-2965)
				base = context.createElement( "base" );
				base.href = document.location.href;
				context.head.appendChild( base );
			} else {
				context = document;
			}
		}

		parsed = rsingleTag.exec( data );
		scripts = !keepScripts && [];

		// Single tag
		if ( parsed ) {
			return [ context.createElement( parsed[ 1 ] ) ];
		}

		parsed = buildFragment( [ data ], context, scripts );

		if ( scripts && scripts.length ) {
			jQuery( scripts ).remove();
		}

		return jQuery.merge( [], parsed.childNodes );
	};


	/**
	 * Load a url into a page
	 */
	jQuery.fn.load = function( url, params, callback ) {
		var selector, type, response,
			self = this,
			off = url.indexOf( " " );

		if ( off > -1 ) {
			selector = stripAndCollapse( url.slice( off ) );
			url = url.slice( 0, off );
		}

		// If it's a function
		if ( isFunction( params ) ) {

			// We assume that it's the callback
			callback = params;
			params = undefined;

		// Otherwise, build a param string
		} else if ( params && typeof params === "object" ) {
			type = "POST";
		}

		// If we have elements to modify, make the request
		if ( self.length > 0 ) {
			jQuery.ajax( {
				url: url,

				// If "type" variable is undefined, then "GET" method will be used.
				// Make value of this field explicit since
				// user can override it through ajaxSetup method
				type: type || "GET",
				dataType: "html",
				data: params
			} ).done( function( responseText ) {

				// Save response for use in complete callback
				response = arguments;

				self.html( selector ?

					// If a selector was specified, locate the right elements in a dummy div
					// Exclude scripts to avoid IE 'Permission Denied' errors
					jQuery( "<div>" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :

					// Otherwise use the full result
					responseText );

			// If the request succeeds, this function gets "data", "status", "jqXHR"
			// but they are ignored because response was set above.
			// If it fails, this function gets "jqXHR", "status", "error"
			} ).always( callback && function( jqXHR, status ) {
				self.each( function() {
					callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );
				} );
			} );
		}

		return this;
	};




	jQuery.expr.pseudos.animated = function( elem ) {
		return jQuery.grep( jQuery.timers, function( fn ) {
			return elem === fn.elem;
		} ).length;
	};




	jQuery.offset = {
		setOffset: function( elem, options, i ) {
			var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,
				position = jQuery.css( elem, "position" ),
				curElem = jQuery( elem ),
				props = {};

			// Set position first, in-case top/left are set even on static elem
			if ( position === "static" ) {
				elem.style.position = "relative";
			}

			curOffset = curElem.offset();
			curCSSTop = jQuery.css( elem, "top" );
			curCSSLeft = jQuery.css( elem, "left" );
			calculatePosition = ( position === "absolute" || position === "fixed" ) &&
				( curCSSTop + curCSSLeft ).indexOf( "auto" ) > -1;

			// Need to be able to calculate position if either
			// top or left is auto and position is either absolute or fixed
			if ( calculatePosition ) {
				curPosition = curElem.position();
				curTop = curPosition.top;
				curLeft = curPosition.left;

			} else {
				curTop = parseFloat( curCSSTop ) || 0;
				curLeft = parseFloat( curCSSLeft ) || 0;
			}

			if ( isFunction( options ) ) {

				// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
				options = options.call( elem, i, jQuery.extend( {}, curOffset ) );
			}

			if ( options.top != null ) {
				props.top = ( options.top - curOffset.top ) + curTop;
			}
			if ( options.left != null ) {
				props.left = ( options.left - curOffset.left ) + curLeft;
			}

			if ( "using" in options ) {
				options.using.call( elem, props );

			} else {
				curElem.css( props );
			}
		}
	};

	jQuery.fn.extend( {

		// offset() relates an element's border box to the document origin
		offset: function( options ) {

			// Preserve chaining for setter
			if ( arguments.length ) {
				return options === undefined ?
					this :
					this.each( function( i ) {
						jQuery.offset.setOffset( this, options, i );
					} );
			}

			var rect, win,
				elem = this[ 0 ];

			if ( !elem ) {
				return;
			}

			// Return zeros for disconnected and hidden (display: none) elements (gh-2310)
			// Support: IE <=11 only
			// Running getBoundingClientRect on a
			// disconnected node in IE throws an error
			if ( !elem.getClientRects().length ) {
				return { top: 0, left: 0 };
			}

			// Get document-relative position by adding viewport scroll to viewport-relative gBCR
			rect = elem.getBoundingClientRect();
			win = elem.ownerDocument.defaultView;
			return {
				top: rect.top + win.pageYOffset,
				left: rect.left + win.pageXOffset
			};
		},

		// position() relates an element's margin box to its offset parent's padding box
		// This corresponds to the behavior of CSS absolute positioning
		position: function() {
			if ( !this[ 0 ] ) {
				return;
			}

			var offsetParent, offset, doc,
				elem = this[ 0 ],
				parentOffset = { top: 0, left: 0 };

			// position:fixed elements are offset from the viewport, which itself always has zero offset
			if ( jQuery.css( elem, "position" ) === "fixed" ) {

				// Assume position:fixed implies availability of getBoundingClientRect
				offset = elem.getBoundingClientRect();

			} else {
				offset = this.offset();

				// Account for the *real* offset parent, which can be the document or its root element
				// when a statically positioned element is identified
				doc = elem.ownerDocument;
				offsetParent = elem.offsetParent || doc.documentElement;
				while ( offsetParent &&
					( offsetParent === doc.body || offsetParent === doc.documentElement ) &&
					jQuery.css( offsetParent, "position" ) === "static" ) {

					offsetParent = offsetParent.parentNode;
				}
				if ( offsetParent && offsetParent !== elem && offsetParent.nodeType === 1 ) {

					// Incorporate borders into its offset, since they are outside its content origin
					parentOffset = jQuery( offsetParent ).offset();
					parentOffset.top += jQuery.css( offsetParent, "borderTopWidth", true );
					parentOffset.left += jQuery.css( offsetParent, "borderLeftWidth", true );
				}
			}

			// Subtract parent offsets and element margins
			return {
				top: offset.top - parentOffset.top - jQuery.css( elem, "marginTop", true ),
				left: offset.left - parentOffset.left - jQuery.css( elem, "marginLeft", true )
			};
		},

		// This method will return documentElement in the following cases:
		// 1) For the element inside the iframe without offsetParent, this method will return
		//    documentElement of the parent window
		// 2) For the hidden or detached element
		// 3) For body or html element, i.e. in case of the html node - it will return itself
		//
		// but those exceptions were never presented as a real life use-cases
		// and might be considered as more preferable results.
		//
		// This logic, however, is not guaranteed and can change at any point in the future
		offsetParent: function() {
			return this.map( function() {
				var offsetParent = this.offsetParent;

				while ( offsetParent && jQuery.css( offsetParent, "position" ) === "static" ) {
					offsetParent = offsetParent.offsetParent;
				}

				return offsetParent || documentElement;
			} );
		}
	} );

	// Create scrollLeft and scrollTop methods
	jQuery.each( { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function( method, prop ) {
		var top = "pageYOffset" === prop;

		jQuery.fn[ method ] = function( val ) {
			return access( this, function( elem, method, val ) {

				// Coalesce documents and windows
				var win;
				if ( isWindow( elem ) ) {
					win = elem;
				} else if ( elem.nodeType === 9 ) {
					win = elem.defaultView;
				}

				if ( val === undefined ) {
					return win ? win[ prop ] : elem[ method ];
				}

				if ( win ) {
					win.scrollTo(
						!top ? val : win.pageXOffset,
						top ? val : win.pageYOffset
					);

				} else {
					elem[ method ] = val;
				}
			}, method, val, arguments.length );
		};
	} );

	// Support: Safari <=7 - 9.1, Chrome <=37 - 49
	// Add the top/left cssHooks using jQuery.fn.position
	// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
	// Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
	// getComputedStyle returns percent when specified for top/left/bottom/right;
	// rather than make the css module depend on the offset module, just check for it here
	jQuery.each( [ "top", "left" ], function( _i, prop ) {
		jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,
			function( elem, computed ) {
				if ( computed ) {
					computed = curCSS( elem, prop );

					// If curCSS returns percentage, fallback to offset
					return rnumnonpx.test( computed ) ?
						jQuery( elem ).position()[ prop ] + "px" :
						computed;
				}
			}
		);
	} );


	// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
	jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
		jQuery.each( {
			padding: "inner" + name,
			content: type,
			"": "outer" + name
		}, function( defaultExtra, funcName ) {

			// Margin is only for outerHeight, outerWidth
			jQuery.fn[ funcName ] = function( margin, value ) {
				var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
					extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

				return access( this, function( elem, type, value ) {
					var doc;

					if ( isWindow( elem ) ) {

						// $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
						return funcName.indexOf( "outer" ) === 0 ?
							elem[ "inner" + name ] :
							elem.document.documentElement[ "client" + name ];
					}

					// Get document width or height
					if ( elem.nodeType === 9 ) {
						doc = elem.documentElement;

						// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
						// whichever is greatest
						return Math.max(
							elem.body[ "scroll" + name ], doc[ "scroll" + name ],
							elem.body[ "offset" + name ], doc[ "offset" + name ],
							doc[ "client" + name ]
						);
					}

					return value === undefined ?

						// Get width or height on the element, requesting but not forcing parseFloat
						jQuery.css( elem, type, extra ) :

						// Set width or height on the element
						jQuery.style( elem, type, value, extra );
				}, type, chainable ? margin : undefined, chainable );
			};
		} );
	} );


	jQuery.each( [
		"ajaxStart",
		"ajaxStop",
		"ajaxComplete",
		"ajaxError",
		"ajaxSuccess",
		"ajaxSend"
	], function( _i, type ) {
		jQuery.fn[ type ] = function( fn ) {
			return this.on( type, fn );
		};
	} );




	jQuery.fn.extend( {

		bind: function( types, data, fn ) {
			return this.on( types, null, data, fn );
		},
		unbind: function( types, fn ) {
			return this.off( types, null, fn );
		},

		delegate: function( selector, types, data, fn ) {
			return this.on( types, selector, data, fn );
		},
		undelegate: function( selector, types, fn ) {

			// ( namespace ) or ( selector, types [, fn] )
			return arguments.length === 1 ?
				this.off( selector, "**" ) :
				this.off( types, selector || "**", fn );
		},

		hover: function( fnOver, fnOut ) {
			return this
				.on( "mouseenter", fnOver )
				.on( "mouseleave", fnOut || fnOver );
		}
	} );

	jQuery.each(
		( "blur focus focusin focusout resize scroll click dblclick " +
		"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
		"change select submit keydown keypress keyup contextmenu" ).split( " " ),
		function( _i, name ) {

			// Handle event binding
			jQuery.fn[ name ] = function( data, fn ) {
				return arguments.length > 0 ?
					this.on( name, null, data, fn ) :
					this.trigger( name );
			};
		}
	);




	// Support: Android <=4.0 only
	// Make sure we trim BOM and NBSP
	// Require that the "whitespace run" starts from a non-whitespace
	// to avoid O(N^2) behavior when the engine would try matching "\s+$" at each space position.
	var rtrim = /^[\s\uFEFF\xA0]+|([^\s\uFEFF\xA0])[\s\uFEFF\xA0]+$/g;

	// Bind a function to a context, optionally partially applying any
	// arguments.
	// jQuery.proxy is deprecated to promote standards (specifically Function#bind)
	// However, it is not slated for removal any time soon
	jQuery.proxy = function( fn, context ) {
		var tmp, args, proxy;

		if ( typeof context === "string" ) {
			tmp = fn[ context ];
			context = fn;
			fn = tmp;
		}

		// Quick check to determine if target is callable, in the spec
		// this throws a TypeError, but we will just return undefined.
		if ( !isFunction( fn ) ) {
			return undefined;
		}

		// Simulated bind
		args = slice.call( arguments, 2 );
		proxy = function() {
			return fn.apply( context || this, args.concat( slice.call( arguments ) ) );
		};

		// Set the guid of unique handler to the same of original handler, so it can be removed
		proxy.guid = fn.guid = fn.guid || jQuery.guid++;

		return proxy;
	};

	jQuery.holdReady = function( hold ) {
		if ( hold ) {
			jQuery.readyWait++;
		} else {
			jQuery.ready( true );
		}
	};
	jQuery.isArray = Array.isArray;
	jQuery.parseJSON = JSON.parse;
	jQuery.nodeName = nodeName;
	jQuery.isFunction = isFunction;
	jQuery.isWindow = isWindow;
	jQuery.camelCase = camelCase;
	jQuery.type = toType;

	jQuery.now = Date.now;

	jQuery.isNumeric = function( obj ) {

		// As of jQuery 3.0, isNumeric is limited to
		// strings and numbers (primitives or objects)
		// that can be coerced to finite numbers (gh-2662)
		var type = jQuery.type( obj );
		return ( type === "number" || type === "string" ) &&

			// parseFloat NaNs numeric-cast false positives ("")
			// ...but misinterprets leading-number strings, particularly hex literals ("0x...")
			// subtraction forces infinities to NaN
			!isNaN( obj - parseFloat( obj ) );
	};

	jQuery.trim = function( text ) {
		return text == null ?
			"" :
			( text + "" ).replace( rtrim, "$1" );
	};




	var

		// Map over jQuery in case of overwrite
		_jQuery = window.jQuery,

		// Map over the $ in case of overwrite
		_$ = window.$;

	jQuery.noConflict = function( deep ) {
		if ( window.$ === jQuery ) {
			window.$ = _$;
		}

		if ( deep && window.jQuery === jQuery ) {
			window.jQuery = _jQuery;
		}

		return jQuery;
	};

	// Expose jQuery and $ identifiers, even in AMD
	// (trac-7102#comment:10, https://github.com/jquery/jquery/pull/557)
	// and CommonJS for browser emulators (trac-13566)
	if ( typeof noGlobal === "undefined" ) {
		window.jQuery = window.$ = jQuery;
	}




	return jQuery;
	} );
	});

	/*
	     * File storage of attachments
	     * Use IndexedDB and fall back to local storage
	     */

	    let dbStore$2 = {
	        get available() {
	            return available$1;
	        }
	    };

	    dbStore$2.logCounter = 0;
	    let available$1 = typeof window.indexedDB !== 'undefined';

	    /*
	     * Variables for indexedDB Storage
	     */
	    let webformDbVersion$1;
	    if(window.idbConfig) {                                  // set in idbconfig.js in the smapServer module
	        webformDbVersion$1 = window.idbConfig.version;        // Share value with webforms page
	    } else {
	        webformDbVersion$1 = 15;
	    }
	    let databaseName$1 = "webform";

	    // Store attached media
	    let mediaStoreName$1 = "media";

	    // Store logs of events
	    let logStoreName$1 = 'logs';

	    // Store last saved records
	    let lastSavedStoreName$1 = 'lastSavedRecords';

	    let recordStoreName$1 = 'records';
	    let assignmentIdx$1 = 'assignment';
	    let assignmentIdxPath$1 = 'assignment.assignment_id';

	    /*
	     * Variables for fall back local storage
	     */
	    var FM_STORAGE_PREFIX$1 = "fs::";

	    /**
	     * Return true if indexedDB is supported
	     * No need to check for support of local storage this is checked by "store"
	     * @return {Boolean}
	     */
	    dbStore$2.isSupported = function() {
	        return new Promise((resolve) => {
	            if (available$1) {
	                open$1().then(() => {
	                    resolve(true);
	                }).catch( (error) => {
	                    console.log(error);
	                    resolve(false);
	                });
	            } else {
	                resolve(false);
	            }
	        });
	    };

	    /**
	     * Initialize indexdDb
	     * @return {[type]} promise boolean or rejection with Error
	     */
	    let open$1 = function() {
	        return new Promise((resolve, reject) => {

	            if(typeof dbStore$2[databaseName$1] !== 'undefined') {
	                resolve(dbStore$2[databaseName$1]);
	                return;
	            }

	            if(typeof window.indexedDB !== 'undefined') {
	                let request = window.indexedDB.open(databaseName$1, webformDbVersion$1);

	                request.onerror = function (e) {
	                    console.log('Error', e.target.error.message);
	                    //alert('Error', e.target.error.message);
	                    reject(e);
	                };

	                request.onblocked = function (e) {
	                    console.log('Error', e.target.error.message);
	                    alert('Error', e.target.error.message);
	                    reject(e);
	                };

	                request.onsuccess = function (e) {
	                    let openDb = e.target.result;

	                    openDb.onerror = function (e) {
	                        // Generic error handler for all errors targeted at this database's
	                        // requests!
	                        console.error("Database error: " + e.target.error.message);
	                    };

	                    dbStore$2[databaseName$1] = openDb;
	                    resolve(openDb);
	                };

	                request.onupgradeneeded = function(e) {
	                    let upgradeDb = e.target.result;

	                    if (!upgradeDb.objectStoreNames.contains(mediaStoreName$1)) {
	                        upgradeDb.createObjectStore(mediaStoreName$1);
	                    }

	                    if (!upgradeDb.objectStoreNames.contains(recordStoreName$1)) {
	                        let recordStore = upgradeDb.createObjectStore(recordStoreName$1, {
	                            keyPath: 'id',
	                            autoIncrement: true
	                        });
	                        recordStore.createIndex(assignmentIdx$1, assignmentIdxPath$1, {unique: false});
	                    }

	                    if (!upgradeDb.objectStoreNames.contains(logStoreName$1)) {
	                        upgradeDb.createObjectStore(logStoreName$1);
	                    }

	                    if (!upgradeDb.objectStoreNames.contains(lastSavedStoreName$1)) {
	                        upgradeDb.createObjectStore(lastSavedStoreName$1, {
	                            keyPath: '_surveyId',
	                            autoIncrement: false,
	                        });
	                    }

	                    resolve(upgradeDb);
	                };

	            } else {
	                reject("indexeddb not supported");
	            }

	        });
	    };


	    /*
	     * Delete all media with the specified prefix
	     * An explicit boolean "all" is added in case the function is called accidnetially with an undefined directory
	     */
	    dbStore$2.delete = function(dirname, all) {


	        if (typeof dirname !== "undefined" || all) {

	            if (dirname) {
	                console.log("delete directory: " + dirname);
	            } else {
	                console.log("delete all attachments");
	            }

	            var prefix = FM_STORAGE_PREFIX$1 + "/" + dirname;

	            // indexeddb first
	            open$1().then(function (db) {
	                var objectStore = db.transaction([mediaStoreName$1], "readwrite").objectStore(mediaStoreName$1);
	                objectStore.openCursor().onsuccess = function (e) {
	                    var cursor = e.target.result;
	                    if (cursor) {
	                        if (all || cursor.key.startsWith(prefix)) {     // Don't need to check the key if all is set as everything in the data store is a media URL
	                            if (cursor.value) {
	                                window.URL.revokeObjectURL(cursor.value);
	                            }
	                            var request = objectStore.delete(cursor.key);
	                            request.onsuccess = function (e) {
	                                console.log("Delete: " + cursor.key);
	                            };
	                            cursor.continue();
	                        }
	                    }
	                };
	                //db.close();
	            });

	            // Delete any entries in localstorage
	            for (var key in localStorage) {
	                if ((all && key.startsWith(FM_STORAGE_PREFIX$1)) || key.startsWith()) {

	                    var item = localStorage.getItem(key);
	                    if (item) {
	                        window.URL.revokeObjectURL(item);
	                    }
	                    console.log("Delete item: " + key);
	                    localStorage.removeItem(key);
	                }
	            }
	        }

	    };

	    /*
	     * Save an attachment to idb
	     */
	    dbStore$2.saveFile = function(media, dirname) {

	        open$1().then(function (db) {
	            console.log("save file: " + media.name + " : " + dirname);

	            var transaction = db.transaction([mediaStoreName$1], "readwrite");
	            transaction.onerror = function (e) {
	                alert("Error: failed to open transaction to save file " + media.name);
	            };

	            var objectStore = transaction.objectStore(mediaStoreName$1);
	            objectStore.put(media.dataUrl, FM_STORAGE_PREFIX$1 + "/" + dirname + "/" + media.name);
	        });

	    };

	    /*
	     * Save a last saved record
	     */
	    dbStore$2.setLastSavedRecord = function(record) {

	        return new Promise((resolve, reject) => {
	            open$1().then( function( db ) {
	                console.log( "Set last saved record" );

	                let transaction = db.transaction( [ lastSavedStoreName$1 ], "readwrite" );
	                let request = transaction.objectStore( lastSavedStoreName$1 ).put( record );
	                request.onerror = function( e ) {
	                    reject(e);
	                };
	                request.onsuccess = function (e) {
	                    resolve();
	                };

	            } );
	        });
	    };

	    /*
	     * Get a last saved record
	     */
	    dbStore$2.getLastSavedRecord = function(id) {

	        return new Promise((resolve, reject) => {
	            open$1().then( function( db ) {
	                console.log( "Get last saved record: " + id );

	                let transaction = db.transaction( [ lastSavedStoreName$1 ], "readonly" );
	                transaction.onerror = function( e ) {
	                    alert( "Error: failed to open transaction to write get last saved record " + name );
	                    reject(e);
	                };

	                let objectStore = transaction.objectStore( lastSavedStoreName$1 );
	                let request = objectStore.get( id );

	                request.onerror = function (e) {
	                    reject("Error getting last record");
	                };

	                request.onsuccess = function (e) {
	                    resolve(request.result);
	                };

	            } );
	        });
	    };

	    /*
	    * Remove a last saved record
	    */
	    dbStore$2.removeLastSavedRecord = function(id) {

	        return new Promise((resolve, reject) => {
	            open$1().then( function( db ) {
	                console.log( "Delete last saved record: " + id );

	                let transaction = db.transaction( [ lastSavedStoreName$1 ], "readwrite" );
	                transaction.onerror = function( e ) {
	                    alert( "Error: failed to open transaction to delete saved record " + name );
	                    reject(e);
	                };

	                let objectStore = transaction.objectStore( lastSavedStoreName$1 );
	                objectStore.delete(id);
	                resolve();
	            } );
	        });
	    };

	    /*
	     * Write a log entry to the database
	     */
	    dbStore$2.writeLog = function(action, name, status, instanceid) {

	        let oneday = 1000 * 3600 * 24;

	        open$1().then(function (db) {
	            console.log("write log entry: " + name + " : " + status);

	            let transaction = db.transaction([logStoreName$1], "readwrite");
	            transaction.onerror = function (e) {
	                alert("Error: failed to open transaction to write log entry " + name);
	            };

	            // Ensure date is unique as it is used as a unique key
	            let date = new Date();
	            date.setMilliseconds(date.getMilliseconds() + dbStore$2.logCounter);
	            if(dbStore$2.logCounter > 100) {
	                dbStore$2.logCounter = 0;
	            } else {
	                dbStore$2.logCounter++;
	            }

	            let logItem = {
	                date: date,
	                action: action,
	                name: name,
	                status: status,
	                instanceid: instanceid
	            };
	            var objectStore = transaction.objectStore(logStoreName$1);
	            objectStore.add(logItem, date);

	            // Delete records older than 100 days
	            let today = new Date();
	            let archiveDate = new Date(today.getTime() - (100 * oneday));
	            objectStore.delete(IDBKeyRange.upperBound(archiveDate));
	        });

	    };

	    /*
	     * Get a file from idb or local storage
	     */
	    dbStore$2.getFile = function(name, dirname) {

	        return new Promise((resolve, reject) => {

	            var key = FM_STORAGE_PREFIX$1 + "/" + dirname + "/" + name;

	            console.log("get file: " + key);

	            /*
	             * Try indxeddb first
	             */
	            getFileFromIdb$1(key).then(function (file) {

	                if (file) {
	                    resolve(file);

	                } else {
	                     // Fallback to local storage for backward compatability
	                    try {
	                        resolve(localStorage.getItem(key));
	                    } catch (err) {
	                        reject("Error: " + err.message);
	                    }
	                }

	            }).catch(function (reason) {
	                reject(reason);
	            });
	        });

	    };

	    /*
	     * Obtains blob for specified file
	     */
	    dbStore$2.retrieveFile = function(dirname, file) {

	        return new Promise((resolve, reject) => {

		        var updatedFile = {
			        fileName: file.fileName
		        };

		        dbStore$2.getFile(file.fileName, dirname).then(function(objectUrl){
		            updatedFile.blob = dbStore$2.dataURLtoBlob(objectUrl);
		            updatedFile.size = updatedFile.blob.size;
		            resolve(updatedFile);
		        });


	        });

	    };

	    // From: http://stackoverflow.com/questions/6850276/how-to-convert-dataurl-to-file-object-in-javascript
	    dbStore$2.dataURLtoBlob = function(dataurl) {
	        if(dataurl) {
	            var arr = dataurl.split(',');
	            var mime;
	            var bstr;
	            var n;
	            var u8arr;

	            if(arr.length > 1) {
	                mime = arr[0].match(/:(.*?);/)[1];
	                bstr = atob(arr[1]);
	                n = bstr.length;
	                u8arr = new Uint8Array(n);
	                while (n--) {
	                    u8arr[n] = bstr.charCodeAt(n);
	                }
	                return new Blob([u8arr], {type: mime});
	            } else {
	                return new Blob();
	            }
	        } else {
	            return new Blob();
	        }
	    };

	    /*
	     * Local functions
	     * May be called from a location that has not intialised dbStore (ie fileManager)
	     */
	    function getFileFromIdb$1(key) {
	        return new Promise((resolve, reject) => {
	            open$1().then((db) => {
	                var transaction = db.transaction([mediaStoreName$1], "readonly");
	                var objectStore = transaction.objectStore(mediaStoreName$1);
	                var request = objectStore.get(key);

	                request.onerror = function (e) {
	                    reject("Error getting file");
	                };

	                request.onsuccess = function (e) {
	                    resolve(request.result);
	                };
	            });

	        });
	    }

	    /*
	     * Functions to interoperate with mywork
	     */
	    dbStore$2.setRecord = function(record, id) {
	        return new Promise((resolve, reject) => {
	            console.log("set record: ");
	            open$1().then((db) => {
	                var transaction = db.transaction([recordStoreName$1], "readwrite");
	                transaction.onerror = function (event) {
	                    alert("Error: failed to add record ");
	                };

	                var objectStore = transaction.objectStore(recordStoreName$1);

	                var request = objectStore.put(record, id);

	                request.onsuccess = function (e) {
	                    resolve();
	                };
	                request.onerror = function (e) {
	                    console.log('Error', e.target.error.name);
	                    reject();
	                };
	                //db.close();
	            });
	        });
	    };

	var RESERVED_KEYS = ['user_locale', '__settings', 'null', '__history', 'Firebug', 'undefined', '__bookmark', '__counter',
	            '__current_server', '__loadLog', '__writetest', '__maxSize'
	        ],
	        localStorage$2 = window.localStorage;

	    let store$2 = {};

	    // Could be replaced by Modernizr function if Modernizr remains used in final version
	    store$2.isSupported = function() {
	        try {
	            return 'localStorage' in window && window['localStorage'] !== null;
	        } catch (e) {
	            return false;
	        }
	    };

	    store$2.isWritable = function() {
	        var result = store$2.setRecord('__writetest', 'x', null, true);
	        if (result === 'success') {
	            store$2.removeRecord('__writetest');
	            return true;
	        }
	        return false;
	    };

	    //used for testing
	    store$2.getForbiddenKeys = function() {
	        return RESERVED_KEYS;
	    };

	    /**
	     * saves a data object in JSON format (string)
	     * @param {string} newKey    [description]
	     * @param {*} record     [description]
	     * @param {boolean=} del [description] used to change name of existing record and delete old record
	     * @param {boolean=} overwrite [description] overwrite is only used when there is *another* record with the same new name (not when simply updating current form)
	     * @param {?string=} oldKey    [description]
	     * @return {string}
	     */
	    store$2.setRecord = function(newKey, record, del, overwrite, oldKey) {
	        var error;
	        if (!newKey || typeof newKey !== 'string' || newKey.length < 1) {
	            //console.error( 'no key or empty key provided for record: ' + newKey );
	            return 'require';
	        }
	        newKey = newKey.trim();
	        oldKey = ( typeof oldKey === 'string' ) ? oldKey.trim() : null;
	        overwrite = ( typeof overwrite !== 'undefined' && overwrite === true ) ? true : false;

	        //using the knowledge that only survey data is provided as a "data" property (and is a string)
	        if (typeof record['data'] === 'string' && store$2.isReservedKey(newKey)) {
	            return 'forbidden';
	        }
	        if (typeof record['data'] === 'string' &&
	            ( oldKey !== newKey && store$2.isExistingKey(newKey) && overwrite !== true ) ||
	            ( oldKey === newKey && overwrite !== true )) {
	            return 'existing';
	        }
	        try {
	            //add timestamp to survey data
	            if (typeof record['data'] === 'string') {
	                record['lastSaved'] = ( new Date() ).getTime();
	                localStorage$2.setItem('__counter', JSON.stringify({
	                    'counter': store$2.getCounterValue()
	                }));

	            }
	            localStorage$2.setItem(newKey, JSON.stringify(record));
	            //console.debug( 'saved: ' + newKey + ', old key was: ' + oldKey );
	            //if the record was loaded from the store (oldKey != null) and the key's value was changed during editing
	            //delete the old record if del=true
	            if (oldKey !== null && oldKey !== '' && oldKey !== newKey) {
	                if (del) {
	                    console.log('going to remove old record with key:' + oldKey);
	                    store$2.removeRecord(oldKey);
	                }
	            }
	            return 'success';
	        } catch (e) {
	            if (e && e.code === 22) { //} (e.name==='QUOTA_EXCEEDED_ERR'){
	                return 'full (or browser is set to not allow storage)';
	            }
	            console.log('error in store.setRecord:', e);
	            error = ( e ) ? JSON.stringify(e) : 'unknown';
	            return 'error: ' + error;
	        }
	    };

	    store$2.setKey = function(key, value) {
	        localStorage$2.setItem(key, value);
	    };

	    store$2.getKey = function(key) {
	        var value = localStorage$2.getItem(key);
	        if(value && value.charAt(0) === '"') {
	            value = value.replace(/"/g, '');     // Hack to cater for draft names being previously wrapped in quotes by being json stringified
	        }
	        return value;
	    };

	    /**
	     * Returns a form data record as an object. This is the only function that obtains records from the local storage.
	     * @param  {string} key [description]
	     * @return {?*}     [description]
	     */
	    store$2.getRecord = function(key) {
	        var record;
	        try {
	            var x = localStorage$2.getItem(key);
	            if(x && x.trim().startsWith('{')) {
	                record = JSON.parse(localStorage$2.getItem(key));
	            }
	            return record;
	        } catch (e) {
	            console.error('error with loading data from store: ' + e.message);
	            return null;
	        }
	    };

	    // removes a record
	    store$2.removeRecord = function(key) {
	        try {
	            localStorage$2.removeItem(key);
	            if (!store$2.isReservedKey(key)) {
	                jquery('form.or').trigger('delete', JSON.stringify(store$2.getRecordList()));
	            }
	            return true;
	        } catch (e) {
	            console.log('error with removing data from store: ' + e.message);
	            return false;
	        }
	    };

	    // Removes all records
	    store$2.removeAllRecords = function() {
	        var records = getSurveyRecords(false);

	        records.forEach(function (record) {
	            store$2.removeRecord(record.key);
	        });
	    };

	    /**
	     * Returns a list of locally stored form names and properties for a provided server URL
	     * @param  {string} serverURL
	     * @return {Array.<{name: string, server: string, title: string, url: string}>}
	     */
	    store$2.getFormList = function(serverURL) {
	        if (typeof serverURL == 'undefined') {
	            return null;
	        }
	        return store$2.getRecord('__server_' + serverURL);
	    };

	    /**
	     * returns an ordered array of objects with record keys and final variables {{"key": "name1", "draft": true},{"key": "name2", etc.
	     * @return { Array.<Object.<string, (boolean|string)>>} [description]
	     */
	    store$2.getRecordList = function() {
	        var formList = [],
	            records = store$2.getSurveyRecords(false);

	        records.forEach(function (record) {
	            formList.push({
	                'key': record.key,
	                'draft': record.draft,
	                'lastSaved': record.lastSaved
	            });
	        });

	        //order formList by lastSaved timestamp
	        formList.sort(function (a, b) {
	            return a['lastSaved'] - b['lastSaved'];
	        });
	        return formList;
	    };

	    /**
	     * retrieves all survey data
	     * @param  {boolean=} finalOnly   [description]
	     * @param  {?string=} excludeName [description]
	     * @return {Array.<Object.<(string|number), (string|boolean)>>}             [description]
	     */
	    store$2.getSurveyRecords = function(finalOnly, excludeName) {
	        var i, key,
	            records = [],
	            record = {};
	        finalOnly = ( typeof finalOnly !== 'undefined' ) ? finalOnly : false;
	        excludeName = excludeName || null;

	        for (i = 0; i < localStorage$2.length; i++) {
	            key = localStorage$2.key(i);
	            if (!store$2.isReservedKey(key) && !key.startsWith("fs::")) {

	                // get record -
	                record = store$2.getRecord(key);
	                if(record) {

		                try {
			                record.key = key;
			                //=== true comparison breaks in Google Closure compiler.
			                if (key !== excludeName && (!finalOnly || !record.draft)) {
				                if (record.form) {		// If there is a form then this should be record data (Smap)
					                records.push(record);
				                }
			                }
		                } catch (e) {
			                console.log('record found that was probably not in the expected JSON format' +
				                ' (e.g. Firebug settings or corrupt record) (error: ' + e.message + '), record was ignored');
		                }
	                }
	            }
	        }

	        return records;
	    };

	    /**
	     * [getSurveyDataArr description]
	     * @param  {boolean=} finalOnly   [description]
	     * @param  {?string=} excludeName the (currently open) record name to exclude from the returned data set
	     * @return {Array.<{name: string, data: string}>}             [description]
	     */
	    store$2.getSurveyDataArr = function(finalOnly, excludeName) {

	        finalOnly = ( typeof finalOnly !== 'undefined' ) ? finalOnly : true;
	        excludeName = excludeName || null;
	        return store$2.getSurveyRecords(finalOnly, excludeName);
	    };


	    store$2.getExportStr = function() {
	        var dataStr = '';

	        store$2.getSurveyDataArr(false).forEach(function (record) {
	            dataStr += '<record name="' + record.key + '" lastSaved="' + record.lastSaved + '"' +
	                ( record.draft ? ' draft="true()"' : '' ) +
	                '>' + record.data + '</record>';
	        });

	        return dataStr;
	    };

	    store$2.isReservedKey = function(k) {
	        var i;
	        for (i = 0; i < RESERVED_KEYS.length; i++) {
	            if (k === RESERVED_KEYS[i]) {
	                return true;
	            }
	        }
	        return false;
	    };

	    store$2.isExistingKey = function(k) {
	        if (localStorage$2.getItem(k)) {
	            //console.log('existing key');// DEBUG
	            return true;
	        }
	        //console.log('not existing key');// DEBUG
	        return false;
	    };

	    store$2.getCounterValue = function() {
	        var record = store$2.getRecord('__counter'),
	            number = ( record && record['counter'] && isNumber$1(record['counter']) ) ? Number(record['counter']) : 0,
	            numberStr = ( number + 1 ).toString();

	        return numberStr;
	    };


	    function isNumber$1(n) {
	        return !isNaN(parseFloat(n)) && isFinite(n);
	    }

	var config = {
	    'maps': [ {
	        'tiles': [ 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png' ],
	        'name': 'streets',
	        'attribution': '© <a href=\'http://openstreetmap.org\'>OpenStreetMap</a> | <a href=\'www.openstreetmap.org/copyright\'>Terms</a>'
	    }, {
	        'tiles': 'GOOGLE_SATELLITE',
	        'name': 'satellite'
	    } ],
	    'googleApiKey': '',
	    'repeatOrdinals': false,
	    'validateContinuously': false,
	    'validatePage': true,
	    'swipePage': true,
	    'textMaxChars': 65535
	};

	var queryParams = _getAllQueryParams();
	var settings$1 = {};
	var DEFAULT_MAX_SIZE = 5 * 1024 * 1024;
	var DEFAULT_LOGIN_URL = '/login';
	var DEFAULT_THANKS_URL = '/thanks';
	var settingsMap = [ {
	    q: 'return',
	    s: 'returnUrl'
	}, {
	    q: 'returnURL',
	    s: 'returnUrl'
	}, {
	    q: 'returnUrl',
	    s: 'returnUrl'
	}, {
	    q: 'touch',
	    s: 'touch'
	}, {
	    q: 'server',
	    s: 'serverUrl'
	}, {
	    q: 'serverURL',
	    s: 'serverUrl'
	}, {
	    q: 'serverUrl',
	    s: 'serverUrl'
	}, {
	    q: 'form',
	    s: 'xformUrl'
	}, {
	    q: 'id',
	    s: 'xformId'
	}, {
	    q: 'instanceId',
	    s: 'instanceId'
	}, {
	    q: 'instance_id',
	    s: 'instanceId'
	}, {
	    q: 'parentWindowOrigin',
	    s: 'parentWindowOrigin'
	} ];

	// rename query string parameters to settings, but only if they do not exist already
	settingsMap.forEach( function( obj ) {
	    if ( typeof queryParams[ obj.q ] !== 'undefined' && typeof settings$1[ obj.s ] === 'undefined' ) {
	        settings$1[ obj.s ] = queryParams[ obj.q ];
	    }
	} );

	//add default login Url
	settings$1.loginUrl = config[ 'basePath' ] + DEFAULT_LOGIN_URL;

	// add default return Url
	settings$1.defaultReturnUrl = config[ 'basePath' ] + DEFAULT_THANKS_URL;

	// add defaults object
	settings$1.defaults = {};
	for ( var p in queryParams ) {
	    if ( queryParams.hasOwnProperty( p ) ) {
	        var path$1;
	        var value;
	        if ( p.search( /d\[(.*)\]/ ) !== -1 ) {
	            path$1 = decodeURIComponent( p.match( /d\[(.*)\]/ )[ 1 ] );
	            value = decodeURIComponent( queryParams[ p ] );
	            settings$1.defaults[ path$1 ] = value;
	        }
	    }
	}

	// add common app configuration constants
	for ( var prop in config ) {
	    if ( config.hasOwnProperty( prop ) ) {
	        settings$1[ prop ] = config[ prop ];
	    }
	}

	// add submission parameter value
	if ( settings$1.submissionParameter && settings$1.submissionParameter.name ) {
	    // sets to undefined when necessary
	    settings$1.submissionParameter.value = queryParams[ settings$1.submissionParameter.name ];
	}

	// add language override value
	settings$1.languageOverrideParameter = queryParams.lang ? {
	    name: 'lang',
	    value: queryParams.lang
	} : undefined;

	// set default maxSubmissionSize
	settings$1.maxSize = DEFAULT_MAX_SIZE;

	// add type
	if ( window.location.pathname.indexOf( '/preview' ) === 0 ) {
	    settings$1.type = 'preview';
	} else if ( window.location.pathname.indexOf( '/single' ) === 0 ) {
	    settings$1.type = 'single';
	} else if ( window.location.pathname.indexOf( '/edit' ) === 0 ) {
	    settings$1.type = 'edit';
	} else if ( window.location.pathname.indexOf( '/view' ) === 0 ) {
	    settings$1.type = 'view';
	} else {
	    settings$1.type = 'other';
	}

	settings$1.basePath = "webForm";

	// Provide easy way to change online-only prefix if we wanted to in the future
	settings$1.enketoIdPrefix = '::';

	// Determine whether view is offline-capable
	settings$1.offline = !!document.querySelector( 'html' ).getAttribute( 'manifest' );

	// Extract Enketo ID
	settings$1.enketoId = ( settings$1.offline ) ? _getEnketoId( '#', window.location.hash ) : _getEnketoId( '/' + settings$1.enketoIdPrefix, window.location.pathname );

	// Set multipleAllowed for single webform views
	if ( settings$1.type === 'single' && settings$1.enketoId.length !== 32 && settings$1.enketoId.length !== 64 ) {
	    settings$1.multipleAllowed = true;
	}

	// Determine whether "go to" functionality should be enabled.
	settings$1.goTo = settings$1.type === 'edit' || settings$1.type === 'preview' || settings$1.type === 'view';

	// A bit crude and hackable by users, but this way also type=view with a record will be caught.
	settings$1.printRelevantOnly = !!settings$1.instanceId;

	function _getEnketoId( prefix, haystack ) {
	    var id = new RegExp( prefix ).test( haystack ) ? haystack.substring( haystack.lastIndexOf( prefix ) + prefix.length ) : null;
	    return id;
	}

	function _getAllQueryParams() {
	    var val;
	    var processedVal;
	    var query = window.location.search.substring( 1 );
	    var vars = query.split( '&' );
	    var params = {};

	    for ( var i = 0; i < vars.length; i++ ) {
	        var pair = vars[ i ].split( '=' );
	        if ( pair[ 0 ].length > 0 ) {
	            val = decodeURIComponent( pair[ 1 ] );
	            processedVal = ( val === 'true' ) ? true : ( val === 'false' ) ? false : val;
	            params[ pair[ 0 ] ] = processedVal;
	        }
	    }

	    return params;
	}

	function _typeof$1(obj) {
	  "@babel/helpers - typeof";

	  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
	    _typeof$1 = function _typeof(obj) {
	      return typeof obj;
	    };
	  } else {
	    _typeof$1 = function _typeof(obj) {
	      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	    };
	  }

	  return _typeof$1(obj);
	}

	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	function _objectSpread(target) {
	  for (var i = 1; i < arguments.length; i++) {
	    var source = arguments[i] != null ? Object(arguments[i]) : {};
	    var ownKeys = Object.keys(source);

	    if (typeof Object.getOwnPropertySymbols === 'function') {
	      ownKeys.push.apply(ownKeys, Object.getOwnPropertySymbols(source).filter(function (sym) {
	        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
	      }));
	    }

	    ownKeys.forEach(function (key) {
	      _defineProperty(target, key, source[key]);
	    });
	  }

	  return target;
	}

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    Object.defineProperty(target, descriptor.key, descriptor);
	  }
	}

	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  return Constructor;
	}

	var _typeof_1 = createCommonjsModule(function (module) {
	function _typeof(obj) {
	  "@babel/helpers - typeof";

	  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
	    module.exports = _typeof = function _typeof(obj) {
	      return typeof obj;
	    };

	    module.exports["default"] = module.exports, module.exports.__esModule = true;
	  } else {
	    module.exports = _typeof = function _typeof(obj) {
	      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	    };

	    module.exports["default"] = module.exports, module.exports.__esModule = true;
	  }

	  return _typeof(obj);
	}

	module.exports = _typeof;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _typeof = unwrapExports(_typeof_1);

	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}

	function _possibleConstructorReturn(self, call) {
	  if (call && (_typeof(call) === "object" || typeof call === "function")) {
	    return call;
	  } else if (call !== void 0) {
	    throw new TypeError("Derived constructors may only return object or undefined");
	  }

	  return _assertThisInitialized(self);
	}

	function _getPrototypeOf(o) {
	  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
	    return o.__proto__ || Object.getPrototypeOf(o);
	  };
	  return _getPrototypeOf(o);
	}

	function _setPrototypeOf(o, p) {
	  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
	    o.__proto__ = p;
	    return o;
	  };

	  return _setPrototypeOf(o, p);
	}

	function _inherits(subClass, superClass) {
	  if (typeof superClass !== "function" && superClass !== null) {
	    throw new TypeError("Super expression must either be null or a function");
	  }

	  subClass.prototype = Object.create(superClass && superClass.prototype, {
	    constructor: {
	      value: subClass,
	      writable: true,
	      configurable: true
	    }
	  });
	  if (superClass) _setPrototypeOf(subClass, superClass);
	}

	var consoleLogger = {
	  type: 'logger',
	  log: function log(args) {
	    this.output('log', args);
	  },
	  warn: function warn(args) {
	    this.output('warn', args);
	  },
	  error: function error(args) {
	    this.output('error', args);
	  },
	  output: function output(type, args) {
	    if (console && console[type]) console[type].apply(console, args);
	  }
	};

	var Logger = function () {
	  function Logger(concreteLogger) {
	    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

	    _classCallCheck(this, Logger);

	    this.init(concreteLogger, options);
	  }

	  _createClass(Logger, [{
	    key: "init",
	    value: function init(concreteLogger) {
	      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	      this.prefix = options.prefix || 'i18next:';
	      this.logger = concreteLogger || consoleLogger;
	      this.options = options;
	      this.debug = options.debug;
	    }
	  }, {
	    key: "setDebug",
	    value: function setDebug(bool) {
	      this.debug = bool;
	    }
	  }, {
	    key: "log",
	    value: function log() {
	      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	        args[_key] = arguments[_key];
	      }

	      return this.forward(args, 'log', '', true);
	    }
	  }, {
	    key: "warn",
	    value: function warn() {
	      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
	        args[_key2] = arguments[_key2];
	      }

	      return this.forward(args, 'warn', '', true);
	    }
	  }, {
	    key: "error",
	    value: function error() {
	      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
	        args[_key3] = arguments[_key3];
	      }

	      return this.forward(args, 'error', '');
	    }
	  }, {
	    key: "deprecate",
	    value: function deprecate() {
	      for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
	        args[_key4] = arguments[_key4];
	      }

	      return this.forward(args, 'warn', 'WARNING DEPRECATED: ', true);
	    }
	  }, {
	    key: "forward",
	    value: function forward(args, lvl, prefix, debugOnly) {
	      if (debugOnly && !this.debug) return null;
	      if (typeof args[0] === 'string') args[0] = "".concat(prefix).concat(this.prefix, " ").concat(args[0]);
	      return this.logger[lvl](args);
	    }
	  }, {
	    key: "create",
	    value: function create(moduleName) {
	      return new Logger(this.logger, _objectSpread({}, {
	        prefix: "".concat(this.prefix, ":").concat(moduleName, ":")
	      }, this.options));
	    }
	  }]);

	  return Logger;
	}();

	var baseLogger = new Logger();

	var EventEmitter = function () {
	  function EventEmitter() {
	    _classCallCheck(this, EventEmitter);

	    this.observers = {};
	  }

	  _createClass(EventEmitter, [{
	    key: "on",
	    value: function on(events, listener) {
	      var _this = this;

	      events.split(' ').forEach(function (event) {
	        _this.observers[event] = _this.observers[event] || [];

	        _this.observers[event].push(listener);
	      });
	      return this;
	    }
	  }, {
	    key: "off",
	    value: function off(event, listener) {
	      if (!this.observers[event]) return;

	      if (!listener) {
	        delete this.observers[event];
	        return;
	      }

	      this.observers[event] = this.observers[event].filter(function (l) {
	        return l !== listener;
	      });
	    }
	  }, {
	    key: "emit",
	    value: function emit(event) {
	      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	        args[_key - 1] = arguments[_key];
	      }

	      if (this.observers[event]) {
	        var cloned = [].concat(this.observers[event]);
	        cloned.forEach(function (observer) {
	          observer.apply(void 0, args);
	        });
	      }

	      if (this.observers['*']) {
	        var _cloned = [].concat(this.observers['*']);

	        _cloned.forEach(function (observer) {
	          observer.apply(observer, [event].concat(args));
	        });
	      }
	    }
	  }]);

	  return EventEmitter;
	}();

	function defer() {
	  var res;
	  var rej;
	  var promise = new Promise(function (resolve, reject) {
	    res = resolve;
	    rej = reject;
	  });
	  promise.resolve = res;
	  promise.reject = rej;
	  return promise;
	}
	function makeString(object) {
	  if (object == null) return '';
	  return '' + object;
	}
	function copy(a, s, t) {
	  a.forEach(function (m) {
	    if (s[m]) t[m] = s[m];
	  });
	}

	function getLastOfPath(object, path, Empty) {
	  function cleanKey(key) {
	    return key && key.indexOf('###') > -1 ? key.replace(/###/g, '.') : key;
	  }

	  function canNotTraverseDeeper() {
	    return !object || typeof object === 'string';
	  }

	  var stack = typeof path !== 'string' ? [].concat(path) : path.split('.');

	  while (stack.length > 1) {
	    if (canNotTraverseDeeper()) return {};
	    var key = cleanKey(stack.shift());
	    if (!object[key] && Empty) object[key] = new Empty();

	    if (Object.prototype.hasOwnProperty.call(object, key)) {
	      object = object[key];
	    } else {
	      object = {};
	    }
	  }

	  if (canNotTraverseDeeper()) return {};
	  return {
	    obj: object,
	    k: cleanKey(stack.shift())
	  };
	}

	function setPath(object, path, newValue) {
	  var _getLastOfPath = getLastOfPath(object, path, Object),
	      obj = _getLastOfPath.obj,
	      k = _getLastOfPath.k;

	  obj[k] = newValue;
	}
	function pushPath(object, path, newValue, concat) {
	  var _getLastOfPath2 = getLastOfPath(object, path, Object),
	      obj = _getLastOfPath2.obj,
	      k = _getLastOfPath2.k;

	  obj[k] = obj[k] || [];
	  if (concat) obj[k] = obj[k].concat(newValue);
	  if (!concat) obj[k].push(newValue);
	}
	function getPath$1(object, path) {
	  var _getLastOfPath3 = getLastOfPath(object, path),
	      obj = _getLastOfPath3.obj,
	      k = _getLastOfPath3.k;

	  if (!obj) return undefined;
	  return obj[k];
	}
	function getPathWithDefaults(data, defaultData, key) {
	  var value = getPath$1(data, key);

	  if (value !== undefined) {
	    return value;
	  }

	  return getPath$1(defaultData, key);
	}
	function deepExtend(target, source, overwrite) {
	  for (var prop in source) {
	    if (prop !== '__proto__' && prop !== 'constructor') {
	      if (prop in target) {
	        if (typeof target[prop] === 'string' || target[prop] instanceof String || typeof source[prop] === 'string' || source[prop] instanceof String) {
	          if (overwrite) target[prop] = source[prop];
	        } else {
	          deepExtend(target[prop], source[prop], overwrite);
	        }
	      } else {
	        target[prop] = source[prop];
	      }
	    }
	  }

	  return target;
	}
	function regexEscape(str) {
	  return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, '\\$&');
	}
	var _entityMap = {
	  '&': '&amp;',
	  '<': '&lt;',
	  '>': '&gt;',
	  '"': '&quot;',
	  "'": '&#39;',
	  '/': '&#x2F;'
	};
	function escape$1(data) {
	  if (typeof data === 'string') {
	    return data.replace(/[&<>"'\/]/g, function (s) {
	      return _entityMap[s];
	    });
	  }

	  return data;
	}
	var isIE10 = typeof window !== 'undefined' && window.navigator && window.navigator.userAgent && window.navigator.userAgent.indexOf('MSIE') > -1;

	var ResourceStore = function (_EventEmitter) {
	  _inherits(ResourceStore, _EventEmitter);

	  function ResourceStore(data) {
	    var _this;

	    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
	      ns: ['translation'],
	      defaultNS: 'translation'
	    };

	    _classCallCheck(this, ResourceStore);

	    _this = _possibleConstructorReturn(this, _getPrototypeOf(ResourceStore).call(this));

	    if (isIE10) {
	      EventEmitter.call(_assertThisInitialized(_this));
	    }

	    _this.data = data || {};
	    _this.options = options;

	    if (_this.options.keySeparator === undefined) {
	      _this.options.keySeparator = '.';
	    }

	    return _this;
	  }

	  _createClass(ResourceStore, [{
	    key: "addNamespaces",
	    value: function addNamespaces(ns) {
	      if (this.options.ns.indexOf(ns) < 0) {
	        this.options.ns.push(ns);
	      }
	    }
	  }, {
	    key: "removeNamespaces",
	    value: function removeNamespaces(ns) {
	      var index = this.options.ns.indexOf(ns);

	      if (index > -1) {
	        this.options.ns.splice(index, 1);
	      }
	    }
	  }, {
	    key: "getResource",
	    value: function getResource(lng, ns, key) {
	      var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
	      var keySeparator = options.keySeparator !== undefined ? options.keySeparator : this.options.keySeparator;
	      var path = [lng, ns];
	      if (key && typeof key !== 'string') path = path.concat(key);
	      if (key && typeof key === 'string') path = path.concat(keySeparator ? key.split(keySeparator) : key);

	      if (lng.indexOf('.') > -1) {
	        path = lng.split('.');
	      }

	      return getPath$1(this.data, path);
	    }
	  }, {
	    key: "addResource",
	    value: function addResource(lng, ns, key, value) {
	      var options = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {
	        silent: false
	      };
	      var keySeparator = this.options.keySeparator;
	      if (keySeparator === undefined) keySeparator = '.';
	      var path = [lng, ns];
	      if (key) path = path.concat(keySeparator ? key.split(keySeparator) : key);

	      if (lng.indexOf('.') > -1) {
	        path = lng.split('.');
	        value = ns;
	        ns = path[1];
	      }

	      this.addNamespaces(ns);
	      setPath(this.data, path, value);
	      if (!options.silent) this.emit('added', lng, ns, key, value);
	    }
	  }, {
	    key: "addResources",
	    value: function addResources(lng, ns, resources) {
	      var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {
	        silent: false
	      };

	      for (var m in resources) {
	        if (typeof resources[m] === 'string' || Object.prototype.toString.apply(resources[m]) === '[object Array]') this.addResource(lng, ns, m, resources[m], {
	          silent: true
	        });
	      }

	      if (!options.silent) this.emit('added', lng, ns, resources);
	    }
	  }, {
	    key: "addResourceBundle",
	    value: function addResourceBundle(lng, ns, resources, deep, overwrite) {
	      var options = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {
	        silent: false
	      };
	      var path = [lng, ns];

	      if (lng.indexOf('.') > -1) {
	        path = lng.split('.');
	        deep = resources;
	        resources = ns;
	        ns = path[1];
	      }

	      this.addNamespaces(ns);
	      var pack = getPath$1(this.data, path) || {};

	      if (deep) {
	        deepExtend(pack, resources, overwrite);
	      } else {
	        pack = _objectSpread({}, pack, resources);
	      }

	      setPath(this.data, path, pack);
	      if (!options.silent) this.emit('added', lng, ns, resources);
	    }
	  }, {
	    key: "removeResourceBundle",
	    value: function removeResourceBundle(lng, ns) {
	      if (this.hasResourceBundle(lng, ns)) {
	        delete this.data[lng][ns];
	      }

	      this.removeNamespaces(ns);
	      this.emit('removed', lng, ns);
	    }
	  }, {
	    key: "hasResourceBundle",
	    value: function hasResourceBundle(lng, ns) {
	      return this.getResource(lng, ns) !== undefined;
	    }
	  }, {
	    key: "getResourceBundle",
	    value: function getResourceBundle(lng, ns) {
	      if (!ns) ns = this.options.defaultNS;
	      if (this.options.compatibilityAPI === 'v1') return _objectSpread({}, {}, this.getResource(lng, ns));
	      return this.getResource(lng, ns);
	    }
	  }, {
	    key: "getDataByLanguage",
	    value: function getDataByLanguage(lng) {
	      return this.data[lng];
	    }
	  }, {
	    key: "toJSON",
	    value: function toJSON() {
	      return this.data;
	    }
	  }]);

	  return ResourceStore;
	}(EventEmitter);

	var postProcessor = {
	  processors: {},
	  addPostProcessor: function addPostProcessor(module) {
	    this.processors[module.name] = module;
	  },
	  handle: function handle(processors, value, key, options, translator) {
	    var _this = this;

	    processors.forEach(function (processor) {
	      if (_this.processors[processor]) value = _this.processors[processor].process(value, key, options, translator);
	    });
	    return value;
	  }
	};

	var checkedLoadedFor = {};

	var Translator = function (_EventEmitter) {
	  _inherits(Translator, _EventEmitter);

	  function Translator(services) {
	    var _this;

	    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

	    _classCallCheck(this, Translator);

	    _this = _possibleConstructorReturn(this, _getPrototypeOf(Translator).call(this));

	    if (isIE10) {
	      EventEmitter.call(_assertThisInitialized(_this));
	    }

	    copy(['resourceStore', 'languageUtils', 'pluralResolver', 'interpolator', 'backendConnector', 'i18nFormat', 'utils'], services, _assertThisInitialized(_this));
	    _this.options = options;

	    if (_this.options.keySeparator === undefined) {
	      _this.options.keySeparator = '.';
	    }

	    _this.logger = baseLogger.create('translator');
	    return _this;
	  }

	  _createClass(Translator, [{
	    key: "changeLanguage",
	    value: function changeLanguage(lng) {
	      if (lng) this.language = lng;
	    }
	  }, {
	    key: "exists",
	    value: function exists(key) {
	      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
	        interpolation: {}
	      };
	      var resolved = this.resolve(key, options);
	      return resolved && resolved.res !== undefined;
	    }
	  }, {
	    key: "extractFromKey",
	    value: function extractFromKey(key, options) {
	      var nsSeparator = options.nsSeparator !== undefined ? options.nsSeparator : this.options.nsSeparator;
	      if (nsSeparator === undefined) nsSeparator = ':';
	      var keySeparator = options.keySeparator !== undefined ? options.keySeparator : this.options.keySeparator;
	      var namespaces = options.ns || this.options.defaultNS;

	      if (nsSeparator && key.indexOf(nsSeparator) > -1) {
	        var m = key.match(this.interpolator.nestingRegexp);

	        if (m && m.length > 0) {
	          return {
	            key: key,
	            namespaces: namespaces
	          };
	        }

	        var parts = key.split(nsSeparator);
	        if (nsSeparator !== keySeparator || nsSeparator === keySeparator && this.options.ns.indexOf(parts[0]) > -1) namespaces = parts.shift();
	        key = parts.join(keySeparator);
	      }

	      if (typeof namespaces === 'string') namespaces = [namespaces];
	      return {
	        key: key,
	        namespaces: namespaces
	      };
	    }
	  }, {
	    key: "translate",
	    value: function translate(keys, options, lastKey) {
	      var _this2 = this;

	      if (_typeof$1(options) !== 'object' && this.options.overloadTranslationOptionHandler) {
	        options = this.options.overloadTranslationOptionHandler(arguments);
	      }

	      if (!options) options = {};
	      if (keys === undefined || keys === null) return '';
	      if (!Array.isArray(keys)) keys = [String(keys)];
	      var keySeparator = options.keySeparator !== undefined ? options.keySeparator : this.options.keySeparator;

	      var _this$extractFromKey = this.extractFromKey(keys[keys.length - 1], options),
	          key = _this$extractFromKey.key,
	          namespaces = _this$extractFromKey.namespaces;

	      var namespace = namespaces[namespaces.length - 1];
	      var lng = options.lng || this.language;
	      var appendNamespaceToCIMode = options.appendNamespaceToCIMode || this.options.appendNamespaceToCIMode;

	      if (lng && lng.toLowerCase() === 'cimode') {
	        if (appendNamespaceToCIMode) {
	          var nsSeparator = options.nsSeparator || this.options.nsSeparator;
	          return namespace + nsSeparator + key;
	        }

	        return key;
	      }

	      var resolved = this.resolve(keys, options);
	      var res = resolved && resolved.res;
	      var resUsedKey = resolved && resolved.usedKey || key;
	      var resExactUsedKey = resolved && resolved.exactUsedKey || key;
	      var resType = Object.prototype.toString.apply(res);
	      var noObject = ['[object Number]', '[object Function]', '[object RegExp]'];
	      var joinArrays = options.joinArrays !== undefined ? options.joinArrays : this.options.joinArrays;
	      var handleAsObjectInI18nFormat = !this.i18nFormat || this.i18nFormat.handleAsObject;
	      var handleAsObject = typeof res !== 'string' && typeof res !== 'boolean' && typeof res !== 'number';

	      if (handleAsObjectInI18nFormat && res && handleAsObject && noObject.indexOf(resType) < 0 && !(typeof joinArrays === 'string' && resType === '[object Array]')) {
	        if (!options.returnObjects && !this.options.returnObjects) {
	          this.logger.warn('accessing an object - but returnObjects options is not enabled!');
	          return this.options.returnedObjectHandler ? this.options.returnedObjectHandler(resUsedKey, res, options) : "key '".concat(key, " (").concat(this.language, ")' returned an object instead of string.");
	        }

	        if (keySeparator) {
	          var resTypeIsArray = resType === '[object Array]';
	          var copy = resTypeIsArray ? [] : {};
	          var newKeyToUse = resTypeIsArray ? resExactUsedKey : resUsedKey;

	          for (var m in res) {
	            if (Object.prototype.hasOwnProperty.call(res, m)) {
	              var deepKey = "".concat(newKeyToUse).concat(keySeparator).concat(m);
	              copy[m] = this.translate(deepKey, _objectSpread({}, options, {
	                joinArrays: false,
	                ns: namespaces
	              }));
	              if (copy[m] === deepKey) copy[m] = res[m];
	            }
	          }

	          res = copy;
	        }
	      } else if (handleAsObjectInI18nFormat && typeof joinArrays === 'string' && resType === '[object Array]') {
	        res = res.join(joinArrays);
	        if (res) res = this.extendTranslation(res, keys, options, lastKey);
	      } else {
	        var usedDefault = false;
	        var usedKey = false;
	        var needsPluralHandling = options.count !== undefined && typeof options.count !== 'string';
	        var hasDefaultValue = Translator.hasDefaultValue(options);
	        var defaultValueSuffix = needsPluralHandling ? this.pluralResolver.getSuffix(lng, options.count) : '';
	        var defaultValue = options["defaultValue".concat(defaultValueSuffix)] || options.defaultValue;

	        if (!this.isValidLookup(res) && hasDefaultValue) {
	          usedDefault = true;
	          res = defaultValue;
	        }

	        if (!this.isValidLookup(res)) {
	          usedKey = true;
	          res = key;
	        }

	        var updateMissing = hasDefaultValue && defaultValue !== res && this.options.updateMissing;

	        if (usedKey || usedDefault || updateMissing) {
	          this.logger.log(updateMissing ? 'updateKey' : 'missingKey', lng, namespace, key, updateMissing ? defaultValue : res);

	          if (keySeparator) {
	            var fk = this.resolve(key, _objectSpread({}, options, {
	              keySeparator: false
	            }));
	            if (fk && fk.res) this.logger.warn('Seems the loaded translations were in flat JSON format instead of nested. Either set keySeparator: false on init or make sure your translations are published in nested format.');
	          }

	          var lngs = [];
	          var fallbackLngs = this.languageUtils.getFallbackCodes(this.options.fallbackLng, options.lng || this.language);

	          if (this.options.saveMissingTo === 'fallback' && fallbackLngs && fallbackLngs[0]) {
	            for (var i = 0; i < fallbackLngs.length; i++) {
	              lngs.push(fallbackLngs[i]);
	            }
	          } else if (this.options.saveMissingTo === 'all') {
	            lngs = this.languageUtils.toResolveHierarchy(options.lng || this.language);
	          } else {
	            lngs.push(options.lng || this.language);
	          }

	          var send = function send(l, k, fallbackValue) {
	            if (_this2.options.missingKeyHandler) {
	              _this2.options.missingKeyHandler(l, namespace, k, updateMissing ? fallbackValue : res, updateMissing, options);
	            } else if (_this2.backendConnector && _this2.backendConnector.saveMissing) {
	              _this2.backendConnector.saveMissing(l, namespace, k, updateMissing ? fallbackValue : res, updateMissing, options);
	            }

	            _this2.emit('missingKey', l, namespace, k, res);
	          };

	          if (this.options.saveMissing) {
	            if (this.options.saveMissingPlurals && needsPluralHandling) {
	              lngs.forEach(function (language) {
	                _this2.pluralResolver.getSuffixes(language).forEach(function (suffix) {
	                  send([language], key + suffix, options["defaultValue".concat(suffix)] || defaultValue);
	                });
	              });
	            } else {
	              send(lngs, key, defaultValue);
	            }
	          }
	        }

	        res = this.extendTranslation(res, keys, options, resolved, lastKey);
	        if (usedKey && res === key && this.options.appendNamespaceToMissingKey) res = "".concat(namespace, ":").concat(key);
	        if (usedKey && this.options.parseMissingKeyHandler) res = this.options.parseMissingKeyHandler(res);
	      }

	      return res;
	    }
	  }, {
	    key: "extendTranslation",
	    value: function extendTranslation(res, key, options, resolved, lastKey) {
	      var _this3 = this;

	      if (this.i18nFormat && this.i18nFormat.parse) {
	        res = this.i18nFormat.parse(res, options, resolved.usedLng, resolved.usedNS, resolved.usedKey, {
	          resolved: resolved
	        });
	      } else if (!options.skipInterpolation) {
	        if (options.interpolation) this.interpolator.init(_objectSpread({}, options, {
	          interpolation: _objectSpread({}, this.options.interpolation, options.interpolation)
	        }));
	        var skipOnVariables = options.interpolation && options.interpolation.skipOnVariables || this.options.interpolation.skipOnVariables;
	        var nestBef;

	        if (skipOnVariables) {
	          var nb = res.match(this.interpolator.nestingRegexp);
	          nestBef = nb && nb.length;
	        }

	        var data = options.replace && typeof options.replace !== 'string' ? options.replace : options;
	        if (this.options.interpolation.defaultVariables) data = _objectSpread({}, this.options.interpolation.defaultVariables, data);
	        res = this.interpolator.interpolate(res, data, options.lng || this.language, options);

	        if (skipOnVariables) {
	          var na = res.match(this.interpolator.nestingRegexp);
	          var nestAft = na && na.length;
	          if (nestBef < nestAft) options.nest = false;
	        }

	        if (options.nest !== false) res = this.interpolator.nest(res, function () {
	          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	            args[_key] = arguments[_key];
	          }

	          if (lastKey && lastKey[0] === args[0] && !options.context) {
	            _this3.logger.warn("It seems you are nesting recursively key: ".concat(args[0], " in key: ").concat(key[0]));

	            return null;
	          }

	          return _this3.translate.apply(_this3, args.concat([key]));
	        }, options);
	        if (options.interpolation) this.interpolator.reset();
	      }

	      var postProcess = options.postProcess || this.options.postProcess;
	      var postProcessorNames = typeof postProcess === 'string' ? [postProcess] : postProcess;

	      if (res !== undefined && res !== null && postProcessorNames && postProcessorNames.length && options.applyPostProcessor !== false) {
	        res = postProcessor.handle(postProcessorNames, res, key, this.options && this.options.postProcessPassResolved ? _objectSpread({
	          i18nResolved: resolved
	        }, options) : options, this);
	      }

	      return res;
	    }
	  }, {
	    key: "resolve",
	    value: function resolve(keys) {
	      var _this4 = this;

	      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	      var found;
	      var usedKey;
	      var exactUsedKey;
	      var usedLng;
	      var usedNS;
	      if (typeof keys === 'string') keys = [keys];
	      keys.forEach(function (k) {
	        if (_this4.isValidLookup(found)) return;

	        var extracted = _this4.extractFromKey(k, options);

	        var key = extracted.key;
	        usedKey = key;
	        var namespaces = extracted.namespaces;
	        if (_this4.options.fallbackNS) namespaces = namespaces.concat(_this4.options.fallbackNS);
	        var needsPluralHandling = options.count !== undefined && typeof options.count !== 'string';
	        var needsContextHandling = options.context !== undefined && typeof options.context === 'string' && options.context !== '';
	        var codes = options.lngs ? options.lngs : _this4.languageUtils.toResolveHierarchy(options.lng || _this4.language, options.fallbackLng);
	        namespaces.forEach(function (ns) {
	          if (_this4.isValidLookup(found)) return;
	          usedNS = ns;

	          if (!checkedLoadedFor["".concat(codes[0], "-").concat(ns)] && _this4.utils && _this4.utils.hasLoadedNamespace && !_this4.utils.hasLoadedNamespace(usedNS)) {
	            checkedLoadedFor["".concat(codes[0], "-").concat(ns)] = true;

	            _this4.logger.warn("key \"".concat(usedKey, "\" for languages \"").concat(codes.join(', '), "\" won't get resolved as namespace \"").concat(usedNS, "\" was not yet loaded"), 'This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!');
	          }

	          codes.forEach(function (code) {
	            if (_this4.isValidLookup(found)) return;
	            usedLng = code;
	            var finalKey = key;
	            var finalKeys = [finalKey];

	            if (_this4.i18nFormat && _this4.i18nFormat.addLookupKeys) {
	              _this4.i18nFormat.addLookupKeys(finalKeys, key, code, ns, options);
	            } else {
	              var pluralSuffix;
	              if (needsPluralHandling) pluralSuffix = _this4.pluralResolver.getSuffix(code, options.count);
	              if (needsPluralHandling && needsContextHandling) finalKeys.push(finalKey + pluralSuffix);
	              if (needsContextHandling) finalKeys.push(finalKey += "".concat(_this4.options.contextSeparator).concat(options.context));
	              if (needsPluralHandling) finalKeys.push(finalKey += pluralSuffix);
	            }

	            var possibleKey;

	            while (possibleKey = finalKeys.pop()) {
	              if (!_this4.isValidLookup(found)) {
	                exactUsedKey = possibleKey;
	                found = _this4.getResource(code, ns, possibleKey, options);
	              }
	            }
	          });
	        });
	      });
	      return {
	        res: found,
	        usedKey: usedKey,
	        exactUsedKey: exactUsedKey,
	        usedLng: usedLng,
	        usedNS: usedNS
	      };
	    }
	  }, {
	    key: "isValidLookup",
	    value: function isValidLookup(res) {
	      return res !== undefined && !(!this.options.returnNull && res === null) && !(!this.options.returnEmptyString && res === '');
	    }
	  }, {
	    key: "getResource",
	    value: function getResource(code, ns, key) {
	      var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
	      if (this.i18nFormat && this.i18nFormat.getResource) return this.i18nFormat.getResource(code, ns, key, options);
	      return this.resourceStore.getResource(code, ns, key, options);
	    }
	  }], [{
	    key: "hasDefaultValue",
	    value: function hasDefaultValue(options) {
	      var prefix = 'defaultValue';

	      for (var option in options) {
	        if (Object.prototype.hasOwnProperty.call(options, option) && prefix === option.substring(0, prefix.length) && undefined !== options[option]) {
	          return true;
	        }
	      }

	      return false;
	    }
	  }]);

	  return Translator;
	}(EventEmitter);

	function capitalize(string) {
	  return string.charAt(0).toUpperCase() + string.slice(1);
	}

	var LanguageUtil = function () {
	  function LanguageUtil(options) {
	    _classCallCheck(this, LanguageUtil);

	    this.options = options;
	    this.whitelist = this.options.supportedLngs || false;
	    this.supportedLngs = this.options.supportedLngs || false;
	    this.logger = baseLogger.create('languageUtils');
	  }

	  _createClass(LanguageUtil, [{
	    key: "getScriptPartFromCode",
	    value: function getScriptPartFromCode(code) {
	      if (!code || code.indexOf('-') < 0) return null;
	      var p = code.split('-');
	      if (p.length === 2) return null;
	      p.pop();
	      if (p[p.length - 1].toLowerCase() === 'x') return null;
	      return this.formatLanguageCode(p.join('-'));
	    }
	  }, {
	    key: "getLanguagePartFromCode",
	    value: function getLanguagePartFromCode(code) {
	      if (!code || code.indexOf('-') < 0) return code;
	      var p = code.split('-');
	      return this.formatLanguageCode(p[0]);
	    }
	  }, {
	    key: "formatLanguageCode",
	    value: function formatLanguageCode(code) {
	      if (typeof code === 'string' && code.indexOf('-') > -1) {
	        var specialCases = ['hans', 'hant', 'latn', 'cyrl', 'cans', 'mong', 'arab'];
	        var p = code.split('-');

	        if (this.options.lowerCaseLng) {
	          p = p.map(function (part) {
	            return part.toLowerCase();
	          });
	        } else if (p.length === 2) {
	          p[0] = p[0].toLowerCase();
	          p[1] = p[1].toUpperCase();
	          if (specialCases.indexOf(p[1].toLowerCase()) > -1) p[1] = capitalize(p[1].toLowerCase());
	        } else if (p.length === 3) {
	          p[0] = p[0].toLowerCase();
	          if (p[1].length === 2) p[1] = p[1].toUpperCase();
	          if (p[0] !== 'sgn' && p[2].length === 2) p[2] = p[2].toUpperCase();
	          if (specialCases.indexOf(p[1].toLowerCase()) > -1) p[1] = capitalize(p[1].toLowerCase());
	          if (specialCases.indexOf(p[2].toLowerCase()) > -1) p[2] = capitalize(p[2].toLowerCase());
	        }

	        return p.join('-');
	      }

	      return this.options.cleanCode || this.options.lowerCaseLng ? code.toLowerCase() : code;
	    }
	  }, {
	    key: "isWhitelisted",
	    value: function isWhitelisted(code) {
	      this.logger.deprecate('languageUtils.isWhitelisted', 'function "isWhitelisted" will be renamed to "isSupportedCode" in the next major - please make sure to rename it\'s usage asap.');
	      return this.isSupportedCode(code);
	    }
	  }, {
	    key: "isSupportedCode",
	    value: function isSupportedCode(code) {
	      if (this.options.load === 'languageOnly' || this.options.nonExplicitSupportedLngs) {
	        code = this.getLanguagePartFromCode(code);
	      }

	      return !this.supportedLngs || !this.supportedLngs.length || this.supportedLngs.indexOf(code) > -1;
	    }
	  }, {
	    key: "getBestMatchFromCodes",
	    value: function getBestMatchFromCodes(codes) {
	      var _this = this;

	      if (!codes) return null;
	      var found;
	      codes.forEach(function (code) {
	        if (found) return;

	        var cleanedLng = _this.formatLanguageCode(code);

	        if (!_this.options.supportedLngs || _this.isSupportedCode(cleanedLng)) found = cleanedLng;
	      });

	      if (!found && this.options.supportedLngs) {
	        codes.forEach(function (code) {
	          if (found) return;

	          var lngOnly = _this.getLanguagePartFromCode(code);

	          if (_this.isSupportedCode(lngOnly)) return found = lngOnly;
	          found = _this.options.supportedLngs.find(function (supportedLng) {
	            if (supportedLng.indexOf(lngOnly) === 0) return supportedLng;
	          });
	        });
	      }

	      if (!found) found = this.getFallbackCodes(this.options.fallbackLng)[0];
	      return found;
	    }
	  }, {
	    key: "getFallbackCodes",
	    value: function getFallbackCodes(fallbacks, code) {
	      if (!fallbacks) return [];
	      if (typeof fallbacks === 'function') fallbacks = fallbacks(code);
	      if (typeof fallbacks === 'string') fallbacks = [fallbacks];
	      if (Object.prototype.toString.apply(fallbacks) === '[object Array]') return fallbacks;
	      if (!code) return fallbacks["default"] || [];
	      var found = fallbacks[code];
	      if (!found) found = fallbacks[this.getScriptPartFromCode(code)];
	      if (!found) found = fallbacks[this.formatLanguageCode(code)];
	      if (!found) found = fallbacks[this.getLanguagePartFromCode(code)];
	      if (!found) found = fallbacks["default"];
	      return found || [];
	    }
	  }, {
	    key: "toResolveHierarchy",
	    value: function toResolveHierarchy(code, fallbackCode) {
	      var _this2 = this;

	      var fallbackCodes = this.getFallbackCodes(fallbackCode || this.options.fallbackLng || [], code);
	      var codes = [];

	      var addCode = function addCode(c) {
	        if (!c) return;

	        if (_this2.isSupportedCode(c)) {
	          codes.push(c);
	        } else {
	          _this2.logger.warn("rejecting language code not found in supportedLngs: ".concat(c));
	        }
	      };

	      if (typeof code === 'string' && code.indexOf('-') > -1) {
	        if (this.options.load !== 'languageOnly') addCode(this.formatLanguageCode(code));
	        if (this.options.load !== 'languageOnly' && this.options.load !== 'currentOnly') addCode(this.getScriptPartFromCode(code));
	        if (this.options.load !== 'currentOnly') addCode(this.getLanguagePartFromCode(code));
	      } else if (typeof code === 'string') {
	        addCode(this.formatLanguageCode(code));
	      }

	      fallbackCodes.forEach(function (fc) {
	        if (codes.indexOf(fc) < 0) addCode(_this2.formatLanguageCode(fc));
	      });
	      return codes;
	    }
	  }]);

	  return LanguageUtil;
	}();

	var sets = [{
	  lngs: ['ach', 'ak', 'am', 'arn', 'br', 'fil', 'gun', 'ln', 'mfe', 'mg', 'mi', 'oc', 'pt', 'pt-BR', 'tg', 'tl', 'ti', 'tr', 'uz', 'wa'],
	  nr: [1, 2],
	  fc: 1
	}, {
	  lngs: ['af', 'an', 'ast', 'az', 'bg', 'bn', 'ca', 'da', 'de', 'dev', 'el', 'en', 'eo', 'es', 'et', 'eu', 'fi', 'fo', 'fur', 'fy', 'gl', 'gu', 'ha', 'hi', 'hu', 'hy', 'ia', 'it', 'kn', 'ku', 'lb', 'mai', 'ml', 'mn', 'mr', 'nah', 'nap', 'nb', 'ne', 'nl', 'nn', 'no', 'nso', 'pa', 'pap', 'pms', 'ps', 'pt-PT', 'rm', 'sco', 'se', 'si', 'so', 'son', 'sq', 'sv', 'sw', 'ta', 'te', 'tk', 'ur', 'yo'],
	  nr: [1, 2],
	  fc: 2
	}, {
	  lngs: ['ay', 'bo', 'cgg', 'fa', 'ht', 'id', 'ja', 'jbo', 'ka', 'kk', 'km', 'ko', 'ky', 'lo', 'ms', 'sah', 'su', 'th', 'tt', 'ug', 'vi', 'wo', 'zh'],
	  nr: [1],
	  fc: 3
	}, {
	  lngs: ['be', 'bs', 'cnr', 'dz', 'hr', 'ru', 'sr', 'uk'],
	  nr: [1, 2, 5],
	  fc: 4
	}, {
	  lngs: ['ar'],
	  nr: [0, 1, 2, 3, 11, 100],
	  fc: 5
	}, {
	  lngs: ['cs', 'sk'],
	  nr: [1, 2, 5],
	  fc: 6
	}, {
	  lngs: ['csb', 'pl'],
	  nr: [1, 2, 5],
	  fc: 7
	}, {
	  lngs: ['cy'],
	  nr: [1, 2, 3, 8],
	  fc: 8
	}, {
	  lngs: ['fr'],
	  nr: [1, 2],
	  fc: 9
	}, {
	  lngs: ['ga'],
	  nr: [1, 2, 3, 7, 11],
	  fc: 10
	}, {
	  lngs: ['gd'],
	  nr: [1, 2, 3, 20],
	  fc: 11
	}, {
	  lngs: ['is'],
	  nr: [1, 2],
	  fc: 12
	}, {
	  lngs: ['jv'],
	  nr: [0, 1],
	  fc: 13
	}, {
	  lngs: ['kw'],
	  nr: [1, 2, 3, 4],
	  fc: 14
	}, {
	  lngs: ['lt'],
	  nr: [1, 2, 10],
	  fc: 15
	}, {
	  lngs: ['lv'],
	  nr: [1, 2, 0],
	  fc: 16
	}, {
	  lngs: ['mk'],
	  nr: [1, 2],
	  fc: 17
	}, {
	  lngs: ['mnk'],
	  nr: [0, 1, 2],
	  fc: 18
	}, {
	  lngs: ['mt'],
	  nr: [1, 2, 11, 20],
	  fc: 19
	}, {
	  lngs: ['or'],
	  nr: [2, 1],
	  fc: 2
	}, {
	  lngs: ['ro'],
	  nr: [1, 2, 20],
	  fc: 20
	}, {
	  lngs: ['sl'],
	  nr: [5, 1, 2, 3],
	  fc: 21
	}, {
	  lngs: ['he', 'iw'],
	  nr: [1, 2, 20, 21],
	  fc: 22
	}];
	var _rulesPluralsTypes = {
	  1: function _(n) {
	    return Number(n > 1);
	  },
	  2: function _(n) {
	    return Number(n != 1);
	  },
	  3: function _(n) {
	    return 0;
	  },
	  4: function _(n) {
	    return Number(n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
	  },
	  5: function _(n) {
	    return Number(n == 0 ? 0 : n == 1 ? 1 : n == 2 ? 2 : n % 100 >= 3 && n % 100 <= 10 ? 3 : n % 100 >= 11 ? 4 : 5);
	  },
	  6: function _(n) {
	    return Number(n == 1 ? 0 : n >= 2 && n <= 4 ? 1 : 2);
	  },
	  7: function _(n) {
	    return Number(n == 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
	  },
	  8: function _(n) {
	    return Number(n == 1 ? 0 : n == 2 ? 1 : n != 8 && n != 11 ? 2 : 3);
	  },
	  9: function _(n) {
	    return Number(n >= 2);
	  },
	  10: function _(n) {
	    return Number(n == 1 ? 0 : n == 2 ? 1 : n < 7 ? 2 : n < 11 ? 3 : 4);
	  },
	  11: function _(n) {
	    return Number(n == 1 || n == 11 ? 0 : n == 2 || n == 12 ? 1 : n > 2 && n < 20 ? 2 : 3);
	  },
	  12: function _(n) {
	    return Number(n % 10 != 1 || n % 100 == 11);
	  },
	  13: function _(n) {
	    return Number(n !== 0);
	  },
	  14: function _(n) {
	    return Number(n == 1 ? 0 : n == 2 ? 1 : n == 3 ? 2 : 3);
	  },
	  15: function _(n) {
	    return Number(n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
	  },
	  16: function _(n) {
	    return Number(n % 10 == 1 && n % 100 != 11 ? 0 : n !== 0 ? 1 : 2);
	  },
	  17: function _(n) {
	    return Number(n == 1 || n % 10 == 1 && n % 100 != 11 ? 0 : 1);
	  },
	  18: function _(n) {
	    return Number(n == 0 ? 0 : n == 1 ? 1 : 2);
	  },
	  19: function _(n) {
	    return Number(n == 1 ? 0 : n == 0 || n % 100 > 1 && n % 100 < 11 ? 1 : n % 100 > 10 && n % 100 < 20 ? 2 : 3);
	  },
	  20: function _(n) {
	    return Number(n == 1 ? 0 : n == 0 || n % 100 > 0 && n % 100 < 20 ? 1 : 2);
	  },
	  21: function _(n) {
	    return Number(n % 100 == 1 ? 1 : n % 100 == 2 ? 2 : n % 100 == 3 || n % 100 == 4 ? 3 : 0);
	  },
	  22: function _(n) {
	    return Number(n == 1 ? 0 : n == 2 ? 1 : (n < 0 || n > 10) && n % 10 == 0 ? 2 : 3);
	  }
	};

	function createRules() {
	  var rules = {};
	  sets.forEach(function (set) {
	    set.lngs.forEach(function (l) {
	      rules[l] = {
	        numbers: set.nr,
	        plurals: _rulesPluralsTypes[set.fc]
	      };
	    });
	  });
	  return rules;
	}

	var PluralResolver = function () {
	  function PluralResolver(languageUtils) {
	    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

	    _classCallCheck(this, PluralResolver);

	    this.languageUtils = languageUtils;
	    this.options = options;
	    this.logger = baseLogger.create('pluralResolver');
	    this.rules = createRules();
	  }

	  _createClass(PluralResolver, [{
	    key: "addRule",
	    value: function addRule(lng, obj) {
	      this.rules[lng] = obj;
	    }
	  }, {
	    key: "getRule",
	    value: function getRule(code) {
	      return this.rules[code] || this.rules[this.languageUtils.getLanguagePartFromCode(code)];
	    }
	  }, {
	    key: "needsPlural",
	    value: function needsPlural(code) {
	      var rule = this.getRule(code);
	      return rule && rule.numbers.length > 1;
	    }
	  }, {
	    key: "getPluralFormsOfKey",
	    value: function getPluralFormsOfKey(code, key) {
	      return this.getSuffixes(code).map(function (suffix) {
	        return key + suffix;
	      });
	    }
	  }, {
	    key: "getSuffixes",
	    value: function getSuffixes(code) {
	      var _this = this;

	      var rule = this.getRule(code);

	      if (!rule) {
	        return [];
	      }

	      return rule.numbers.map(function (number) {
	        return _this.getSuffix(code, number);
	      });
	    }
	  }, {
	    key: "getSuffix",
	    value: function getSuffix(code, count) {
	      var _this2 = this;

	      var rule = this.getRule(code);

	      if (rule) {
	        var idx = rule.noAbs ? rule.plurals(count) : rule.plurals(Math.abs(count));
	        var suffix = rule.numbers[idx];

	        if (this.options.simplifyPluralSuffix && rule.numbers.length === 2 && rule.numbers[0] === 1) {
	          if (suffix === 2) {
	            suffix = 'plural';
	          } else if (suffix === 1) {
	            suffix = '';
	          }
	        }

	        var returnSuffix = function returnSuffix() {
	          return _this2.options.prepend && suffix.toString() ? _this2.options.prepend + suffix.toString() : suffix.toString();
	        };

	        if (this.options.compatibilityJSON === 'v1') {
	          if (suffix === 1) return '';
	          if (typeof suffix === 'number') return "_plural_".concat(suffix.toString());
	          return returnSuffix();
	        } else if (this.options.compatibilityJSON === 'v2') {
	          return returnSuffix();
	        } else if (this.options.simplifyPluralSuffix && rule.numbers.length === 2 && rule.numbers[0] === 1) {
	          return returnSuffix();
	        }

	        return this.options.prepend && idx.toString() ? this.options.prepend + idx.toString() : idx.toString();
	      }

	      this.logger.warn("no plural rule found for: ".concat(code));
	      return '';
	    }
	  }]);

	  return PluralResolver;
	}();

	var Interpolator = function () {
	  function Interpolator() {
	    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

	    _classCallCheck(this, Interpolator);

	    this.logger = baseLogger.create('interpolator');
	    this.options = options;

	    this.format = options.interpolation && options.interpolation.format || function (value) {
	      return value;
	    };

	    this.init(options);
	  }

	  _createClass(Interpolator, [{
	    key: "init",
	    value: function init() {
	      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      if (!options.interpolation) options.interpolation = {
	        escapeValue: true
	      };
	      var iOpts = options.interpolation;
	      this.escape = iOpts.escape !== undefined ? iOpts.escape : escape$1;
	      this.escapeValue = iOpts.escapeValue !== undefined ? iOpts.escapeValue : true;
	      this.useRawValueToEscape = iOpts.useRawValueToEscape !== undefined ? iOpts.useRawValueToEscape : false;
	      this.prefix = iOpts.prefix ? regexEscape(iOpts.prefix) : iOpts.prefixEscaped || '{{';
	      this.suffix = iOpts.suffix ? regexEscape(iOpts.suffix) : iOpts.suffixEscaped || '}}';
	      this.formatSeparator = iOpts.formatSeparator ? iOpts.formatSeparator : iOpts.formatSeparator || ',';
	      this.unescapePrefix = iOpts.unescapeSuffix ? '' : iOpts.unescapePrefix || '-';
	      this.unescapeSuffix = this.unescapePrefix ? '' : iOpts.unescapeSuffix || '';
	      this.nestingPrefix = iOpts.nestingPrefix ? regexEscape(iOpts.nestingPrefix) : iOpts.nestingPrefixEscaped || regexEscape('$t(');
	      this.nestingSuffix = iOpts.nestingSuffix ? regexEscape(iOpts.nestingSuffix) : iOpts.nestingSuffixEscaped || regexEscape(')');
	      this.nestingOptionsSeparator = iOpts.nestingOptionsSeparator ? iOpts.nestingOptionsSeparator : iOpts.nestingOptionsSeparator || ',';
	      this.maxReplaces = iOpts.maxReplaces ? iOpts.maxReplaces : 1000;
	      this.alwaysFormat = iOpts.alwaysFormat !== undefined ? iOpts.alwaysFormat : false;
	      this.resetRegExp();
	    }
	  }, {
	    key: "reset",
	    value: function reset() {
	      if (this.options) this.init(this.options);
	    }
	  }, {
	    key: "resetRegExp",
	    value: function resetRegExp() {
	      var regexpStr = "".concat(this.prefix, "(.+?)").concat(this.suffix);
	      this.regexp = new RegExp(regexpStr, 'g');
	      var regexpUnescapeStr = "".concat(this.prefix).concat(this.unescapePrefix, "(.+?)").concat(this.unescapeSuffix).concat(this.suffix);
	      this.regexpUnescape = new RegExp(regexpUnescapeStr, 'g');
	      var nestingRegexpStr = "".concat(this.nestingPrefix, "(.+?)").concat(this.nestingSuffix);
	      this.nestingRegexp = new RegExp(nestingRegexpStr, 'g');
	    }
	  }, {
	    key: "interpolate",
	    value: function interpolate(str, data, lng, options) {
	      var _this = this;

	      var match;
	      var value;
	      var replaces;
	      var defaultData = this.options && this.options.interpolation && this.options.interpolation.defaultVariables || {};

	      function regexSafe(val) {
	        return val.replace(/\$/g, '$$$$');
	      }

	      var handleFormat = function handleFormat(key) {
	        if (key.indexOf(_this.formatSeparator) < 0) {
	          var path = getPathWithDefaults(data, defaultData, key);
	          return _this.alwaysFormat ? _this.format(path, undefined, lng) : path;
	        }

	        var p = key.split(_this.formatSeparator);
	        var k = p.shift().trim();
	        var f = p.join(_this.formatSeparator).trim();
	        return _this.format(getPathWithDefaults(data, defaultData, k), f, lng, options);
	      };

	      this.resetRegExp();
	      var missingInterpolationHandler = options && options.missingInterpolationHandler || this.options.missingInterpolationHandler;
	      var skipOnVariables = options && options.interpolation && options.interpolation.skipOnVariables || this.options.interpolation.skipOnVariables;
	      var todos = [{
	        regex: this.regexpUnescape,
	        safeValue: function safeValue(val) {
	          return regexSafe(val);
	        }
	      }, {
	        regex: this.regexp,
	        safeValue: function safeValue(val) {
	          return _this.escapeValue ? regexSafe(_this.escape(val)) : regexSafe(val);
	        }
	      }];
	      todos.forEach(function (todo) {
	        replaces = 0;

	        while (match = todo.regex.exec(str)) {
	          value = handleFormat(match[1].trim());

	          if (value === undefined) {
	            if (typeof missingInterpolationHandler === 'function') {
	              var temp = missingInterpolationHandler(str, match, options);
	              value = typeof temp === 'string' ? temp : '';
	            } else if (skipOnVariables) {
	              value = match[0];
	              continue;
	            } else {
	              _this.logger.warn("missed to pass in variable ".concat(match[1], " for interpolating ").concat(str));

	              value = '';
	            }
	          } else if (typeof value !== 'string' && !_this.useRawValueToEscape) {
	            value = makeString(value);
	          }

	          str = str.replace(match[0], todo.safeValue(value));
	          todo.regex.lastIndex = 0;
	          replaces++;

	          if (replaces >= _this.maxReplaces) {
	            break;
	          }
	        }
	      });
	      return str;
	    }
	  }, {
	    key: "nest",
	    value: function nest(str, fc) {
	      var _this2 = this;

	      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	      var match;
	      var value;

	      var clonedOptions = _objectSpread({}, options);

	      clonedOptions.applyPostProcessor = false;
	      delete clonedOptions.defaultValue;

	      function handleHasOptions(key, inheritedOptions) {
	        var sep = this.nestingOptionsSeparator;
	        if (key.indexOf(sep) < 0) return key;
	        var c = key.split(new RegExp("".concat(sep, "[ ]*{")));
	        var optionsString = "{".concat(c[1]);
	        key = c[0];
	        optionsString = this.interpolate(optionsString, clonedOptions);
	        optionsString = optionsString.replace(/'/g, '"');

	        try {
	          clonedOptions = JSON.parse(optionsString);
	          if (inheritedOptions) clonedOptions = _objectSpread({}, inheritedOptions, clonedOptions);
	        } catch (e) {
	          this.logger.warn("failed parsing options string in nesting for key ".concat(key), e);
	          return "".concat(key).concat(sep).concat(optionsString);
	        }

	        delete clonedOptions.defaultValue;
	        return key;
	      }

	      while (match = this.nestingRegexp.exec(str)) {
	        var formatters = [];
	        var doReduce = false;

	        if (match[0].includes(this.formatSeparator) && !/{.*}/.test(match[1])) {
	          var r = match[1].split(this.formatSeparator).map(function (elem) {
	            return elem.trim();
	          });
	          match[1] = r.shift();
	          formatters = r;
	          doReduce = true;
	        }

	        value = fc(handleHasOptions.call(this, match[1].trim(), clonedOptions), clonedOptions);
	        if (value && match[0] === str && typeof value !== 'string') return value;
	        if (typeof value !== 'string') value = makeString(value);

	        if (!value) {
	          this.logger.warn("missed to resolve ".concat(match[1], " for nesting ").concat(str));
	          value = '';
	        }

	        if (doReduce) {
	          value = formatters.reduce(function (v, f) {
	            return _this2.format(v, f, options.lng, options);
	          }, value.trim());
	        }

	        str = str.replace(match[0], value);
	        this.regexp.lastIndex = 0;
	      }

	      return str;
	    }
	  }]);

	  return Interpolator;
	}();

	function remove(arr, what) {
	  var found = arr.indexOf(what);

	  while (found !== -1) {
	    arr.splice(found, 1);
	    found = arr.indexOf(what);
	  }
	}

	var Connector = function (_EventEmitter) {
	  _inherits(Connector, _EventEmitter);

	  function Connector(backend, store, services) {
	    var _this;

	    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

	    _classCallCheck(this, Connector);

	    _this = _possibleConstructorReturn(this, _getPrototypeOf(Connector).call(this));

	    if (isIE10) {
	      EventEmitter.call(_assertThisInitialized(_this));
	    }

	    _this.backend = backend;
	    _this.store = store;
	    _this.services = services;
	    _this.languageUtils = services.languageUtils;
	    _this.options = options;
	    _this.logger = baseLogger.create('backendConnector');
	    _this.state = {};
	    _this.queue = [];

	    if (_this.backend && _this.backend.init) {
	      _this.backend.init(services, options.backend, options);
	    }

	    return _this;
	  }

	  _createClass(Connector, [{
	    key: "queueLoad",
	    value: function queueLoad(languages, namespaces, options, callback) {
	      var _this2 = this;

	      var toLoad = [];
	      var pending = [];
	      var toLoadLanguages = [];
	      var toLoadNamespaces = [];
	      languages.forEach(function (lng) {
	        var hasAllNamespaces = true;
	        namespaces.forEach(function (ns) {
	          var name = "".concat(lng, "|").concat(ns);

	          if (!options.reload && _this2.store.hasResourceBundle(lng, ns)) {
	            _this2.state[name] = 2;
	          } else if (_this2.state[name] < 0) ; else if (_this2.state[name] === 1) {
	            if (pending.indexOf(name) < 0) pending.push(name);
	          } else {
	            _this2.state[name] = 1;
	            hasAllNamespaces = false;
	            if (pending.indexOf(name) < 0) pending.push(name);
	            if (toLoad.indexOf(name) < 0) toLoad.push(name);
	            if (toLoadNamespaces.indexOf(ns) < 0) toLoadNamespaces.push(ns);
	          }
	        });
	        if (!hasAllNamespaces) toLoadLanguages.push(lng);
	      });

	      if (toLoad.length || pending.length) {
	        this.queue.push({
	          pending: pending,
	          loaded: {},
	          errors: [],
	          callback: callback
	        });
	      }

	      return {
	        toLoad: toLoad,
	        pending: pending,
	        toLoadLanguages: toLoadLanguages,
	        toLoadNamespaces: toLoadNamespaces
	      };
	    }
	  }, {
	    key: "loaded",
	    value: function loaded(name, err, data) {
	      var s = name.split('|');
	      var lng = s[0];
	      var ns = s[1];
	      if (err) this.emit('failedLoading', lng, ns, err);

	      if (data) {
	        this.store.addResourceBundle(lng, ns, data);
	      }

	      this.state[name] = err ? -1 : 2;
	      var loaded = {};
	      this.queue.forEach(function (q) {
	        pushPath(q.loaded, [lng], ns);
	        remove(q.pending, name);
	        if (err) q.errors.push(err);

	        if (q.pending.length === 0 && !q.done) {
	          Object.keys(q.loaded).forEach(function (l) {
	            if (!loaded[l]) loaded[l] = [];

	            if (q.loaded[l].length) {
	              q.loaded[l].forEach(function (ns) {
	                if (loaded[l].indexOf(ns) < 0) loaded[l].push(ns);
	              });
	            }
	          });
	          q.done = true;

	          if (q.errors.length) {
	            q.callback(q.errors);
	          } else {
	            q.callback();
	          }
	        }
	      });
	      this.emit('loaded', loaded);
	      this.queue = this.queue.filter(function (q) {
	        return !q.done;
	      });
	    }
	  }, {
	    key: "read",
	    value: function read(lng, ns, fcName) {
	      var _this3 = this;

	      var tried = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
	      var wait = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 350;
	      var callback = arguments.length > 5 ? arguments[5] : undefined;
	      if (!lng.length) return callback(null, {});
	      return this.backend[fcName](lng, ns, function (err, data) {
	        if (err && data && tried < 5) {
	          setTimeout(function () {
	            _this3.read.call(_this3, lng, ns, fcName, tried + 1, wait * 2, callback);
	          }, wait);
	          return;
	        }

	        callback(err, data);
	      });
	    }
	  }, {
	    key: "prepareLoading",
	    value: function prepareLoading(languages, namespaces) {
	      var _this4 = this;

	      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	      var callback = arguments.length > 3 ? arguments[3] : undefined;

	      if (!this.backend) {
	        this.logger.warn('No backend was added via i18next.use. Will not load resources.');
	        return callback && callback();
	      }

	      if (typeof languages === 'string') languages = this.languageUtils.toResolveHierarchy(languages);
	      if (typeof namespaces === 'string') namespaces = [namespaces];
	      var toLoad = this.queueLoad(languages, namespaces, options, callback);

	      if (!toLoad.toLoad.length) {
	        if (!toLoad.pending.length) callback();
	        return null;
	      }

	      toLoad.toLoad.forEach(function (name) {
	        _this4.loadOne(name);
	      });
	    }
	  }, {
	    key: "load",
	    value: function load(languages, namespaces, callback) {
	      this.prepareLoading(languages, namespaces, {}, callback);
	    }
	  }, {
	    key: "reload",
	    value: function reload(languages, namespaces, callback) {
	      this.prepareLoading(languages, namespaces, {
	        reload: true
	      }, callback);
	    }
	  }, {
	    key: "loadOne",
	    value: function loadOne(name) {
	      var _this5 = this;

	      var prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
	      var s = name.split('|');
	      var lng = s[0];
	      var ns = s[1];
	      this.read(lng, ns, 'read', undefined, undefined, function (err, data) {
	        if (err) _this5.logger.warn("".concat(prefix, "loading namespace ").concat(ns, " for language ").concat(lng, " failed"), err);
	        if (!err && data) _this5.logger.log("".concat(prefix, "loaded namespace ").concat(ns, " for language ").concat(lng), data);

	        _this5.loaded(name, err, data);
	      });
	    }
	  }, {
	    key: "saveMissing",
	    value: function saveMissing(languages, namespace, key, fallbackValue, isUpdate) {
	      var options = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {};

	      if (this.services.utils && this.services.utils.hasLoadedNamespace && !this.services.utils.hasLoadedNamespace(namespace)) {
	        this.logger.warn("did not save key \"".concat(key, "\" as the namespace \"").concat(namespace, "\" was not yet loaded"), 'This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!');
	        return;
	      }

	      if (key === undefined || key === null || key === '') return;

	      if (this.backend && this.backend.create) {
	        this.backend.create(languages, namespace, key, fallbackValue, null, _objectSpread({}, options, {
	          isUpdate: isUpdate
	        }));
	      }

	      if (!languages || !languages[0]) return;
	      this.store.addResource(languages[0], namespace, key, fallbackValue);
	    }
	  }]);

	  return Connector;
	}(EventEmitter);

	function get() {
	  return {
	    debug: false,
	    initImmediate: true,
	    ns: ['translation'],
	    defaultNS: ['translation'],
	    fallbackLng: ['dev'],
	    fallbackNS: false,
	    whitelist: false,
	    nonExplicitWhitelist: false,
	    supportedLngs: false,
	    nonExplicitSupportedLngs: false,
	    load: 'all',
	    preload: false,
	    simplifyPluralSuffix: true,
	    keySeparator: '.',
	    nsSeparator: ':',
	    pluralSeparator: '_',
	    contextSeparator: '_',
	    partialBundledLanguages: false,
	    saveMissing: false,
	    updateMissing: false,
	    saveMissingTo: 'fallback',
	    saveMissingPlurals: true,
	    missingKeyHandler: false,
	    missingInterpolationHandler: false,
	    postProcess: false,
	    postProcessPassResolved: false,
	    returnNull: true,
	    returnEmptyString: true,
	    returnObjects: false,
	    joinArrays: false,
	    returnedObjectHandler: false,
	    parseMissingKeyHandler: false,
	    appendNamespaceToMissingKey: false,
	    appendNamespaceToCIMode: false,
	    overloadTranslationOptionHandler: function handle(args) {
	      var ret = {};
	      if (_typeof$1(args[1]) === 'object') ret = args[1];
	      if (typeof args[1] === 'string') ret.defaultValue = args[1];
	      if (typeof args[2] === 'string') ret.tDescription = args[2];

	      if (_typeof$1(args[2]) === 'object' || _typeof$1(args[3]) === 'object') {
	        var options = args[3] || args[2];
	        Object.keys(options).forEach(function (key) {
	          ret[key] = options[key];
	        });
	      }

	      return ret;
	    },
	    interpolation: {
	      escapeValue: true,
	      format: function format(value, _format, lng, options) {
	        return value;
	      },
	      prefix: '{{',
	      suffix: '}}',
	      formatSeparator: ',',
	      unescapePrefix: '-',
	      nestingPrefix: '$t(',
	      nestingSuffix: ')',
	      nestingOptionsSeparator: ',',
	      maxReplaces: 1000,
	      skipOnVariables: false
	    }
	  };
	}
	function transformOptions(options) {
	  if (typeof options.ns === 'string') options.ns = [options.ns];
	  if (typeof options.fallbackLng === 'string') options.fallbackLng = [options.fallbackLng];
	  if (typeof options.fallbackNS === 'string') options.fallbackNS = [options.fallbackNS];

	  if (options.whitelist) {
	    if (options.whitelist && options.whitelist.indexOf('cimode') < 0) {
	      options.whitelist = options.whitelist.concat(['cimode']);
	    }

	    options.supportedLngs = options.whitelist;
	  }

	  if (options.nonExplicitWhitelist) {
	    options.nonExplicitSupportedLngs = options.nonExplicitWhitelist;
	  }

	  if (options.supportedLngs && options.supportedLngs.indexOf('cimode') < 0) {
	    options.supportedLngs = options.supportedLngs.concat(['cimode']);
	  }

	  return options;
	}

	function noop() {}

	var I18n = function (_EventEmitter) {
	  _inherits(I18n, _EventEmitter);

	  function I18n() {
	    var _this;

	    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	    var callback = arguments.length > 1 ? arguments[1] : undefined;

	    _classCallCheck(this, I18n);

	    _this = _possibleConstructorReturn(this, _getPrototypeOf(I18n).call(this));

	    if (isIE10) {
	      EventEmitter.call(_assertThisInitialized(_this));
	    }

	    _this.options = transformOptions(options);
	    _this.services = {};
	    _this.logger = baseLogger;
	    _this.modules = {
	      external: []
	    };

	    if (callback && !_this.isInitialized && !options.isClone) {
	      if (!_this.options.initImmediate) {
	        _this.init(options, callback);

	        return _possibleConstructorReturn(_this, _assertThisInitialized(_this));
	      }

	      setTimeout(function () {
	        _this.init(options, callback);
	      }, 0);
	    }

	    return _this;
	  }

	  _createClass(I18n, [{
	    key: "init",
	    value: function init() {
	      var _this2 = this;

	      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      var callback = arguments.length > 1 ? arguments[1] : undefined;

	      if (typeof options === 'function') {
	        callback = options;
	        options = {};
	      }

	      if (options.whitelist && !options.supportedLngs) {
	        this.logger.deprecate('whitelist', 'option "whitelist" will be renamed to "supportedLngs" in the next major - please make sure to rename this option asap.');
	      }

	      if (options.nonExplicitWhitelist && !options.nonExplicitSupportedLngs) {
	        this.logger.deprecate('whitelist', 'options "nonExplicitWhitelist" will be renamed to "nonExplicitSupportedLngs" in the next major - please make sure to rename this option asap.');
	      }

	      this.options = _objectSpread({}, get(), this.options, transformOptions(options));
	      this.format = this.options.interpolation.format;
	      if (!callback) callback = noop;

	      function createClassOnDemand(ClassOrObject) {
	        if (!ClassOrObject) return null;
	        if (typeof ClassOrObject === 'function') return new ClassOrObject();
	        return ClassOrObject;
	      }

	      if (!this.options.isClone) {
	        if (this.modules.logger) {
	          baseLogger.init(createClassOnDemand(this.modules.logger), this.options);
	        } else {
	          baseLogger.init(null, this.options);
	        }

	        var lu = new LanguageUtil(this.options);
	        this.store = new ResourceStore(this.options.resources, this.options);
	        var s = this.services;
	        s.logger = baseLogger;
	        s.resourceStore = this.store;
	        s.languageUtils = lu;
	        s.pluralResolver = new PluralResolver(lu, {
	          prepend: this.options.pluralSeparator,
	          compatibilityJSON: this.options.compatibilityJSON,
	          simplifyPluralSuffix: this.options.simplifyPluralSuffix
	        });
	        s.interpolator = new Interpolator(this.options);
	        s.utils = {
	          hasLoadedNamespace: this.hasLoadedNamespace.bind(this)
	        };
	        s.backendConnector = new Connector(createClassOnDemand(this.modules.backend), s.resourceStore, s, this.options);
	        s.backendConnector.on('*', function (event) {
	          for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	            args[_key - 1] = arguments[_key];
	          }

	          _this2.emit.apply(_this2, [event].concat(args));
	        });

	        if (this.modules.languageDetector) {
	          s.languageDetector = createClassOnDemand(this.modules.languageDetector);
	          s.languageDetector.init(s, this.options.detection, this.options);
	        }

	        if (this.modules.i18nFormat) {
	          s.i18nFormat = createClassOnDemand(this.modules.i18nFormat);
	          if (s.i18nFormat.init) s.i18nFormat.init(this);
	        }

	        this.translator = new Translator(this.services, this.options);
	        this.translator.on('*', function (event) {
	          for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
	            args[_key2 - 1] = arguments[_key2];
	          }

	          _this2.emit.apply(_this2, [event].concat(args));
	        });
	        this.modules.external.forEach(function (m) {
	          if (m.init) m.init(_this2);
	        });
	      }

	      if (this.options.fallbackLng && !this.services.languageDetector && !this.options.lng) {
	        var codes = this.services.languageUtils.getFallbackCodes(this.options.fallbackLng);
	        if (codes.length > 0 && codes[0] !== 'dev') this.options.lng = codes[0];
	      }

	      if (!this.services.languageDetector && !this.options.lng) {
	        this.logger.warn('init: no languageDetector is used and no lng is defined');
	      }

	      var storeApi = ['getResource', 'hasResourceBundle', 'getResourceBundle', 'getDataByLanguage'];
	      storeApi.forEach(function (fcName) {
	        _this2[fcName] = function () {
	          var _this2$store;

	          return (_this2$store = _this2.store)[fcName].apply(_this2$store, arguments);
	        };
	      });
	      var storeApiChained = ['addResource', 'addResources', 'addResourceBundle', 'removeResourceBundle'];
	      storeApiChained.forEach(function (fcName) {
	        _this2[fcName] = function () {
	          var _this2$store2;

	          (_this2$store2 = _this2.store)[fcName].apply(_this2$store2, arguments);

	          return _this2;
	        };
	      });
	      var deferred = defer();

	      var load = function load() {
	        var finish = function finish(err, t) {
	          if (_this2.isInitialized) _this2.logger.warn('init: i18next is already initialized. You should call init just once!');
	          _this2.isInitialized = true;
	          if (!_this2.options.isClone) _this2.logger.log('initialized', _this2.options);

	          _this2.emit('initialized', _this2.options);

	          deferred.resolve(t);
	          callback(err, t);
	        };

	        if (_this2.languages && _this2.options.compatibilityAPI !== 'v1' && !_this2.isInitialized) return finish(null, _this2.t.bind(_this2));

	        _this2.changeLanguage(_this2.options.lng, finish);
	      };

	      if (this.options.resources || !this.options.initImmediate) {
	        load();
	      } else {
	        setTimeout(load, 0);
	      }

	      return deferred;
	    }
	  }, {
	    key: "loadResources",
	    value: function loadResources(language) {
	      var _this3 = this;

	      var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;
	      var usedCallback = callback;
	      var usedLng = typeof language === 'string' ? language : this.language;
	      if (typeof language === 'function') usedCallback = language;

	      if (!this.options.resources || this.options.partialBundledLanguages) {
	        if (usedLng && usedLng.toLowerCase() === 'cimode') return usedCallback();
	        var toLoad = [];

	        var append = function append(lng) {
	          if (!lng) return;

	          var lngs = _this3.services.languageUtils.toResolveHierarchy(lng);

	          lngs.forEach(function (l) {
	            if (toLoad.indexOf(l) < 0) toLoad.push(l);
	          });
	        };

	        if (!usedLng) {
	          var fallbacks = this.services.languageUtils.getFallbackCodes(this.options.fallbackLng);
	          fallbacks.forEach(function (l) {
	            return append(l);
	          });
	        } else {
	          append(usedLng);
	        }

	        if (this.options.preload) {
	          this.options.preload.forEach(function (l) {
	            return append(l);
	          });
	        }

	        this.services.backendConnector.load(toLoad, this.options.ns, usedCallback);
	      } else {
	        usedCallback(null);
	      }
	    }
	  }, {
	    key: "reloadResources",
	    value: function reloadResources(lngs, ns, callback) {
	      var deferred = defer();
	      if (!lngs) lngs = this.languages;
	      if (!ns) ns = this.options.ns;
	      if (!callback) callback = noop;
	      this.services.backendConnector.reload(lngs, ns, function (err) {
	        deferred.resolve();
	        callback(err);
	      });
	      return deferred;
	    }
	  }, {
	    key: "use",
	    value: function use(module) {
	      if (!module) throw new Error('You are passing an undefined module! Please check the object you are passing to i18next.use()');
	      if (!module.type) throw new Error('You are passing a wrong module! Please check the object you are passing to i18next.use()');

	      if (module.type === 'backend') {
	        this.modules.backend = module;
	      }

	      if (module.type === 'logger' || module.log && module.warn && module.error) {
	        this.modules.logger = module;
	      }

	      if (module.type === 'languageDetector') {
	        this.modules.languageDetector = module;
	      }

	      if (module.type === 'i18nFormat') {
	        this.modules.i18nFormat = module;
	      }

	      if (module.type === 'postProcessor') {
	        postProcessor.addPostProcessor(module);
	      }

	      if (module.type === '3rdParty') {
	        this.modules.external.push(module);
	      }

	      return this;
	    }
	  }, {
	    key: "changeLanguage",
	    value: function changeLanguage(lng, callback) {
	      var _this4 = this;

	      this.isLanguageChangingTo = lng;
	      var deferred = defer();
	      this.emit('languageChanging', lng);

	      var done = function done(err, l) {
	        if (l) {
	          _this4.language = l;
	          _this4.languages = _this4.services.languageUtils.toResolveHierarchy(l);

	          _this4.translator.changeLanguage(l);

	          _this4.isLanguageChangingTo = undefined;

	          _this4.emit('languageChanged', l);

	          _this4.logger.log('languageChanged', l);
	        } else {
	          _this4.isLanguageChangingTo = undefined;
	        }

	        deferred.resolve(function () {
	          return _this4.t.apply(_this4, arguments);
	        });
	        if (callback) callback(err, function () {
	          return _this4.t.apply(_this4, arguments);
	        });
	      };

	      var setLng = function setLng(lngs) {
	        var l = typeof lngs === 'string' ? lngs : _this4.services.languageUtils.getBestMatchFromCodes(lngs);

	        if (l) {
	          if (!_this4.language) {
	            _this4.language = l;
	            _this4.languages = _this4.services.languageUtils.toResolveHierarchy(l);
	          }

	          if (!_this4.translator.language) _this4.translator.changeLanguage(l);
	          if (_this4.services.languageDetector) _this4.services.languageDetector.cacheUserLanguage(l);
	        }

	        _this4.loadResources(l, function (err) {
	          done(err, l);
	        });
	      };

	      if (!lng && this.services.languageDetector && !this.services.languageDetector.async) {
	        setLng(this.services.languageDetector.detect());
	      } else if (!lng && this.services.languageDetector && this.services.languageDetector.async) {
	        this.services.languageDetector.detect(setLng);
	      } else {
	        setLng(lng);
	      }

	      return deferred;
	    }
	  }, {
	    key: "getFixedT",
	    value: function getFixedT(lng, ns) {
	      var _this5 = this;

	      var fixedT = function fixedT(key, opts) {
	        var options;

	        if (_typeof$1(opts) !== 'object') {
	          for (var _len3 = arguments.length, rest = new Array(_len3 > 2 ? _len3 - 2 : 0), _key3 = 2; _key3 < _len3; _key3++) {
	            rest[_key3 - 2] = arguments[_key3];
	          }

	          options = _this5.options.overloadTranslationOptionHandler([key, opts].concat(rest));
	        } else {
	          options = _objectSpread({}, opts);
	        }

	        options.lng = options.lng || fixedT.lng;
	        options.lngs = options.lngs || fixedT.lngs;
	        options.ns = options.ns || fixedT.ns;
	        return _this5.t(key, options);
	      };

	      if (typeof lng === 'string') {
	        fixedT.lng = lng;
	      } else {
	        fixedT.lngs = lng;
	      }

	      fixedT.ns = ns;
	      return fixedT;
	    }
	  }, {
	    key: "t",
	    value: function t() {
	      var _this$translator;

	      return this.translator && (_this$translator = this.translator).translate.apply(_this$translator, arguments);
	    }
	  }, {
	    key: "exists",
	    value: function exists() {
	      var _this$translator2;

	      return this.translator && (_this$translator2 = this.translator).exists.apply(_this$translator2, arguments);
	    }
	  }, {
	    key: "setDefaultNamespace",
	    value: function setDefaultNamespace(ns) {
	      this.options.defaultNS = ns;
	    }
	  }, {
	    key: "hasLoadedNamespace",
	    value: function hasLoadedNamespace(ns) {
	      var _this6 = this;

	      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

	      if (!this.isInitialized) {
	        this.logger.warn('hasLoadedNamespace: i18next was not initialized', this.languages);
	        return false;
	      }

	      if (!this.languages || !this.languages.length) {
	        this.logger.warn('hasLoadedNamespace: i18n.languages were undefined or empty', this.languages);
	        return false;
	      }

	      var lng = this.languages[0];
	      var fallbackLng = this.options ? this.options.fallbackLng : false;
	      var lastLng = this.languages[this.languages.length - 1];
	      if (lng.toLowerCase() === 'cimode') return true;

	      var loadNotPending = function loadNotPending(l, n) {
	        var loadState = _this6.services.backendConnector.state["".concat(l, "|").concat(n)];

	        return loadState === -1 || loadState === 2;
	      };

	      if (options.precheck) {
	        var preResult = options.precheck(this, loadNotPending);
	        if (preResult !== undefined) return preResult;
	      }

	      if (this.hasResourceBundle(lng, ns)) return true;
	      if (!this.services.backendConnector.backend) return true;
	      if (loadNotPending(lng, ns) && (!fallbackLng || loadNotPending(lastLng, ns))) return true;
	      return false;
	    }
	  }, {
	    key: "loadNamespaces",
	    value: function loadNamespaces(ns, callback) {
	      var _this7 = this;

	      var deferred = defer();

	      if (!this.options.ns) {
	        callback && callback();
	        return Promise.resolve();
	      }

	      if (typeof ns === 'string') ns = [ns];
	      ns.forEach(function (n) {
	        if (_this7.options.ns.indexOf(n) < 0) _this7.options.ns.push(n);
	      });
	      this.loadResources(function (err) {
	        deferred.resolve();
	        if (callback) callback(err);
	      });
	      return deferred;
	    }
	  }, {
	    key: "loadLanguages",
	    value: function loadLanguages(lngs, callback) {
	      var deferred = defer();
	      if (typeof lngs === 'string') lngs = [lngs];
	      var preloaded = this.options.preload || [];
	      var newLngs = lngs.filter(function (lng) {
	        return preloaded.indexOf(lng) < 0;
	      });

	      if (!newLngs.length) {
	        if (callback) callback();
	        return Promise.resolve();
	      }

	      this.options.preload = preloaded.concat(newLngs);
	      this.loadResources(function (err) {
	        deferred.resolve();
	        if (callback) callback(err);
	      });
	      return deferred;
	    }
	  }, {
	    key: "dir",
	    value: function dir(lng) {
	      if (!lng) lng = this.languages && this.languages.length > 0 ? this.languages[0] : this.language;
	      if (!lng) return 'rtl';
	      var rtlLngs = ['ar', 'shu', 'sqr', 'ssh', 'xaa', 'yhd', 'yud', 'aao', 'abh', 'abv', 'acm', 'acq', 'acw', 'acx', 'acy', 'adf', 'ads', 'aeb', 'aec', 'afb', 'ajp', 'apc', 'apd', 'arb', 'arq', 'ars', 'ary', 'arz', 'auz', 'avl', 'ayh', 'ayl', 'ayn', 'ayp', 'bbz', 'pga', 'he', 'iw', 'ps', 'pbt', 'pbu', 'pst', 'prp', 'prd', 'ug', 'ur', 'ydd', 'yds', 'yih', 'ji', 'yi', 'hbo', 'men', 'xmn', 'fa', 'jpr', 'peo', 'pes', 'prs', 'dv', 'sam'];
	      return rtlLngs.indexOf(this.services.languageUtils.getLanguagePartFromCode(lng)) >= 0 ? 'rtl' : 'ltr';
	    }
	  }, {
	    key: "createInstance",
	    value: function createInstance() {
	      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      var callback = arguments.length > 1 ? arguments[1] : undefined;
	      return new I18n(options, callback);
	    }
	  }, {
	    key: "cloneInstance",
	    value: function cloneInstance() {
	      var _this8 = this;

	      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;

	      var mergedOptions = _objectSpread({}, this.options, options, {
	        isClone: true
	      });

	      var clone = new I18n(mergedOptions);
	      var membersToCopy = ['store', 'services', 'language'];
	      membersToCopy.forEach(function (m) {
	        clone[m] = _this8[m];
	      });
	      clone.services = _objectSpread({}, this.services);
	      clone.services.utils = {
	        hasLoadedNamespace: clone.hasLoadedNamespace.bind(clone)
	      };
	      clone.translator = new Translator(clone.services, clone.options);
	      clone.translator.on('*', function (event) {
	        for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
	          args[_key4 - 1] = arguments[_key4];
	        }

	        clone.emit.apply(clone, [event].concat(args));
	      });
	      clone.init(mergedOptions, callback);
	      clone.translator.options = clone.options;
	      clone.translator.backendConnector.services.utils = {
	        hasLoadedNamespace: clone.hasLoadedNamespace.bind(clone)
	      };
	      return clone;
	    }
	  }]);

	  return I18n;
	}(EventEmitter);

	var i18next = new I18n();

	var arr$1 = [];
	var each$1 = arr$1.forEach;
	var slice$1 = arr$1.slice;
	function defaults$1(obj) {
	  each$1.call(slice$1.call(arguments, 1), function (source) {
	    if (source) {
	      for (var prop in source) {
	        if (obj[prop] === undefined) obj[prop] = source[prop];
	      }
	    }
	  });
	  return obj;
	}

	function addQueryString(url, params) {
	  if (params && _typeof$1(params) === 'object') {
	    var queryString = '',
	        e = encodeURIComponent; // Must encode data

	    for (var paramName in params) {
	      queryString += '&' + e(paramName) + '=' + e(params[paramName]);
	    }

	    if (!queryString) {
	      return url;
	    }

	    url = url + (url.indexOf('?') !== -1 ? '&' : '?') + queryString.slice(1);
	  }

	  return url;
	} // https://gist.github.com/Xeoncross/7663273


	function ajax(url, options, callback, data, cache) {
	  if (data && _typeof$1(data) === 'object') {
	    if (!cache) {
	      data['_t'] = new Date();
	    } // URL encoded form data must be in querystring format


	    data = addQueryString('', data).slice(1);
	  }

	  if (options.queryStringParams) {
	    url = addQueryString(url, options.queryStringParams);
	  }

	  try {
	    var x;

	    if (XMLHttpRequest) {
	      x = new XMLHttpRequest();
	    } else {
	      x = new ActiveXObject('MSXML2.XMLHTTP.3.0');
	    }

	    x.open(data ? 'POST' : 'GET', url, 1);

	    if (!options.crossDomain) {
	      x.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
	    }

	    x.withCredentials = !!options.withCredentials;

	    if (data) {
	      x.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
	    }

	    if (x.overrideMimeType) {
	      x.overrideMimeType("application/json");
	    }

	    var h = options.customHeaders;
	    h = typeof h === 'function' ? h() : h;

	    if (h) {
	      for (var i in h) {
	        x.setRequestHeader(i, h[i]);
	      }
	    }

	    x.onreadystatechange = function () {
	      x.readyState > 3 && callback && callback(x.responseText, x);
	    };

	    x.send(data);
	  } catch (e) {
	    console && console.log(e);
	  }
	}

	function getDefaults$1() {
	  return {
	    loadPath: '/locales/{{lng}}/{{ns}}.json',
	    addPath: '/locales/add/{{lng}}/{{ns}}',
	    allowMultiLoading: false,
	    parse: JSON.parse,
	    parsePayload: function parsePayload(namespace, key, fallbackValue) {
	      return _defineProperty({}, key, fallbackValue || '');
	    },
	    crossDomain: false,
	    ajax: ajax
	  };
	}

	var Backend =
	/*#__PURE__*/
	function () {
	  function Backend(services) {
	    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

	    _classCallCheck(this, Backend);

	    this.init(services, options);
	    this.type = 'backend';
	  }

	  _createClass(Backend, [{
	    key: "init",
	    value: function init(services) {
	      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	      this.services = services;
	      this.options = defaults$1(options, this.options || {}, getDefaults$1());
	    }
	  }, {
	    key: "readMulti",
	    value: function readMulti(languages, namespaces, callback) {
	      var loadPath = this.options.loadPath;

	      if (typeof this.options.loadPath === 'function') {
	        loadPath = this.options.loadPath(languages, namespaces);
	      }

	      var url = this.services.interpolator.interpolate(loadPath, {
	        lng: languages.join('+'),
	        ns: namespaces.join('+')
	      });
	      this.loadUrl(url, callback);
	    }
	  }, {
	    key: "read",
	    value: function read(language, namespace, callback) {
	      var loadPath = this.options.loadPath;

	      if (typeof this.options.loadPath === 'function') {
	        loadPath = this.options.loadPath([language], [namespace]);
	      }

	      var url = this.services.interpolator.interpolate(loadPath, {
	        lng: language,
	        ns: namespace
	      });
	      this.loadUrl(url, callback);
	    }
	  }, {
	    key: "loadUrl",
	    value: function loadUrl(url, callback) {
	      var _this = this;

	      this.options.ajax(url, this.options, function (data, xhr) {
	        if (xhr.status >= 500 && xhr.status < 600) return callback('failed loading ' + url, true
	        /* retry */
	        );
	        if (xhr.status >= 400 && xhr.status < 500) return callback('failed loading ' + url, false
	        /* no retry */
	        );
	        var ret, err;

	        try {
	          ret = _this.options.parse(data, url);
	        } catch (e) {
	          err = 'failed parsing ' + url + ' to json';
	        }

	        if (err) return callback(err, false);
	        callback(null, ret);
	      });
	    }
	  }, {
	    key: "create",
	    value: function create(languages, namespace, key, fallbackValue) {
	      var _this2 = this;

	      if (typeof languages === 'string') languages = [languages];
	      var payload = this.options.parsePayload(namespace, key, fallbackValue);
	      languages.forEach(function (lng) {
	        var url = _this2.services.interpolator.interpolate(_this2.options.addPath, {
	          lng: lng,
	          ns: namespace
	        });

	        _this2.options.ajax(url, _this2.options, function (data, xhr) {//const statusCode = xhr.status.toString();
	          // TODO: if statusCode === 4xx do log
	        }, payload);
	      });
	    }
	  }]);

	  return Backend;
	}();

	Backend.type = 'backend';

	var arr = [];
	var each = arr.forEach;
	var slice = arr.slice;
	function defaults(obj) {
	  each.call(slice.call(arguments, 1), function (source) {
	    if (source) {
	      for (var prop in source) {
	        if (obj[prop] === undefined) obj[prop] = source[prop];
	      }
	    }
	  });
	  return obj;
	}

	var cookie = {
	  create: function create(name, value, minutes, domain) {
	    var cookieOptions = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {
	      path: '/'
	    };
	    var expires;

	    if (minutes) {
	      var date = new Date();
	      date.setTime(date.getTime() + minutes * 60 * 1000);
	      expires = '; expires=' + date.toUTCString();
	    } else expires = '';

	    domain = domain ? 'domain=' + domain + ';' : '';
	    cookieOptions = Object.keys(cookieOptions).reduce(function (acc, key) {
	      return acc + ';' + key.replace(/([A-Z])/g, function ($1) {
	        return '-' + $1.toLowerCase();
	      }) + '=' + cookieOptions[key];
	    }, '');
	    document.cookie = name + '=' + encodeURIComponent(value) + expires + ';' + domain + cookieOptions;
	  },
	  read: function read(name) {
	    var nameEQ = name + '=';
	    var ca = document.cookie.split(';');

	    for (var i = 0; i < ca.length; i++) {
	      var c = ca[i];

	      while (c.charAt(0) === ' ') {
	        c = c.substring(1, c.length);
	      }

	      if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
	    }

	    return null;
	  },
	  remove: function remove(name) {
	    this.create(name, '', -1);
	  }
	};
	var cookie$1 = {
	  name: 'cookie',
	  lookup: function lookup(options) {
	    var found;

	    if (options.lookupCookie && typeof document !== 'undefined') {
	      var c = cookie.read(options.lookupCookie);
	      if (c) found = c;
	    }

	    return found;
	  },
	  cacheUserLanguage: function cacheUserLanguage(lng, options) {
	    if (options.lookupCookie && typeof document !== 'undefined') {
	      cookie.create(options.lookupCookie, lng, options.cookieMinutes, options.cookieDomain, options.cookieOptions);
	    }
	  }
	};

	var querystring = {
	  name: 'querystring',
	  lookup: function lookup(options) {
	    var found;

	    if (typeof window !== 'undefined') {
	      var query = window.location.search.substring(1);
	      var params = query.split('&');

	      for (var i = 0; i < params.length; i++) {
	        var pos = params[i].indexOf('=');

	        if (pos > 0) {
	          var key = params[i].substring(0, pos);

	          if (key === options.lookupQuerystring) {
	            found = params[i].substring(pos + 1);
	          }
	        }
	      }
	    }

	    return found;
	  }
	};

	var hasLocalStorageSupport;

	try {
	  hasLocalStorageSupport = window !== 'undefined' && window.localStorage !== null;
	  var testKey = 'i18next.translate.boo';
	  window.localStorage.setItem(testKey, 'foo');
	  window.localStorage.removeItem(testKey);
	} catch (e) {
	  hasLocalStorageSupport = false;
	}

	var localStorage$1 = {
	  name: 'localStorage',
	  lookup: function lookup(options) {
	    var found;

	    if (options.lookupLocalStorage && hasLocalStorageSupport) {
	      var lng = window.localStorage.getItem(options.lookupLocalStorage);
	      if (lng) found = lng;
	    }

	    return found;
	  },
	  cacheUserLanguage: function cacheUserLanguage(lng, options) {
	    if (options.lookupLocalStorage && hasLocalStorageSupport) {
	      window.localStorage.setItem(options.lookupLocalStorage, lng);
	    }
	  }
	};

	var hasSessionStorageSupport;

	try {
	  hasSessionStorageSupport = window !== 'undefined' && window.sessionStorage !== null;
	  var testKey$1 = 'i18next.translate.boo';
	  window.sessionStorage.setItem(testKey$1, 'foo');
	  window.sessionStorage.removeItem(testKey$1);
	} catch (e) {
	  hasSessionStorageSupport = false;
	}

	var sessionStorage = {
	  name: 'sessionStorage',
	  lookup: function lookup(options) {
	    var found;

	    if (options.lookupsessionStorage && hasSessionStorageSupport) {
	      var lng = window.sessionStorage.getItem(options.lookupsessionStorage);
	      if (lng) found = lng;
	    }

	    return found;
	  },
	  cacheUserLanguage: function cacheUserLanguage(lng, options) {
	    if (options.lookupsessionStorage && hasSessionStorageSupport) {
	      window.sessionStorage.setItem(options.lookupsessionStorage, lng);
	    }
	  }
	};

	var navigator$1 = {
	  name: 'navigator',
	  lookup: function lookup(options) {
	    var found = [];

	    if (typeof navigator !== 'undefined') {
	      if (navigator.languages) {
	        // chrome only; not an array, so can't use .push.apply instead of iterating
	        for (var i = 0; i < navigator.languages.length; i++) {
	          found.push(navigator.languages[i]);
	        }
	      }

	      if (navigator.userLanguage) {
	        found.push(navigator.userLanguage);
	      }

	      if (navigator.language) {
	        found.push(navigator.language);
	      }
	    }

	    return found.length > 0 ? found : undefined;
	  }
	};

	var htmlTag = {
	  name: 'htmlTag',
	  lookup: function lookup(options) {
	    var found;
	    var htmlTag = options.htmlTag || (typeof document !== 'undefined' ? document.documentElement : null);

	    if (htmlTag && typeof htmlTag.getAttribute === 'function') {
	      found = htmlTag.getAttribute('lang');
	    }

	    return found;
	  }
	};

	var path = {
	  name: 'path',
	  lookup: function lookup(options) {
	    var found;

	    if (typeof window !== 'undefined') {
	      var language = window.location.pathname.match(/\/([a-zA-Z-]*)/g);

	      if (language instanceof Array) {
	        if (typeof options.lookupFromPathIndex === 'number') {
	          if (typeof language[options.lookupFromPathIndex] !== 'string') {
	            return undefined;
	          }

	          found = language[options.lookupFromPathIndex].replace('/', '');
	        } else {
	          found = language[0].replace('/', '');
	        }
	      }
	    }

	    return found;
	  }
	};

	var subdomain = {
	  name: 'subdomain',
	  lookup: function lookup(options) {
	    var found;

	    if (typeof window !== 'undefined') {
	      var language = window.location.href.match(/(?:http[s]*\:\/\/)*(.*?)\.(?=[^\/]*\..{2,5})/gi);

	      if (language instanceof Array) {
	        if (typeof options.lookupFromSubdomainIndex === 'number') {
	          found = language[options.lookupFromSubdomainIndex].replace('http://', '').replace('https://', '').replace('.', '');
	        } else {
	          found = language[0].replace('http://', '').replace('https://', '').replace('.', '');
	        }
	      }
	    }

	    return found;
	  }
	};

	function getDefaults() {
	  return {
	    order: ['querystring', 'cookie', 'localStorage', 'sessionStorage', 'navigator', 'htmlTag'],
	    lookupQuerystring: 'lng',
	    lookupCookie: 'i18next',
	    lookupLocalStorage: 'i18nextLng',
	    // cache user language
	    caches: ['localStorage'],
	    excludeCacheFor: ['cimode'],
	    //cookieMinutes: 10,
	    //cookieDomain: 'myDomain'
	    checkWhitelist: true,
	    checkForSimilarInWhitelist: false
	  };
	}

	var Browser =
	/*#__PURE__*/
	function () {
	  function Browser(services) {
	    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

	    _classCallCheck(this, Browser);

	    this.type = 'languageDetector';
	    this.detectors = {};
	    this.init(services, options);
	  }

	  _createClass(Browser, [{
	    key: "init",
	    value: function init(services) {
	      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	      var i18nOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	      this.services = services;
	      this.options = defaults(options, this.options || {}, getDefaults()); // if checking for similar, user needs to check whitelist

	      if (this.options.checkForSimilarInWhitelist) this.options.checkWhitelist = true; // backwards compatibility

	      if (this.options.lookupFromUrlIndex) this.options.lookupFromPathIndex = this.options.lookupFromUrlIndex;
	      this.i18nOptions = i18nOptions;
	      this.addDetector(cookie$1);
	      this.addDetector(querystring);
	      this.addDetector(localStorage$1);
	      this.addDetector(sessionStorage);
	      this.addDetector(navigator$1);
	      this.addDetector(htmlTag);
	      this.addDetector(path);
	      this.addDetector(subdomain);
	    }
	  }, {
	    key: "addDetector",
	    value: function addDetector(detector) {
	      this.detectors[detector.name] = detector;
	    }
	  }, {
	    key: "detect",
	    value: function detect(detectionOrder) {
	      var _this = this;

	      if (!detectionOrder) detectionOrder = this.options.order;
	      var detected = [];
	      detectionOrder.forEach(function (detectorName) {
	        if (_this.detectors[detectorName]) {
	          var lookup = _this.detectors[detectorName].lookup(_this.options);

	          if (lookup && typeof lookup === 'string') lookup = [lookup];
	          if (lookup) detected = detected.concat(lookup);
	        }
	      });
	      var found;
	      detected.forEach(function (lng) {
	        if (found) return;

	        var cleanedLng = _this.services.languageUtils.formatLanguageCode(lng);

	        if (!_this.options.checkWhitelist || _this.services.languageUtils.isWhitelisted(cleanedLng)) found = cleanedLng;

	        if (!found && _this.options.checkForSimilarInWhitelist) {
	          found = _this.getSimilarInWhitelist(cleanedLng);
	        }
	      });

	      if (!found) {
	        var fallbacks = this.i18nOptions.fallbackLng;
	        if (typeof fallbacks === 'string') fallbacks = [fallbacks];
	        if (!fallbacks) fallbacks = [];

	        if (Object.prototype.toString.apply(fallbacks) === '[object Array]') {
	          found = fallbacks[0];
	        } else {
	          found = fallbacks[0] || fallbacks["default"] && fallbacks["default"][0];
	        }
	      }

	      return found;
	    }
	  }, {
	    key: "cacheUserLanguage",
	    value: function cacheUserLanguage(lng, caches) {
	      var _this2 = this;

	      if (!caches) caches = this.options.caches;
	      if (!caches) return;
	      if (this.options.excludeCacheFor && this.options.excludeCacheFor.indexOf(lng) > -1) return;
	      caches.forEach(function (cacheName) {
	        if (_this2.detectors[cacheName]) _this2.detectors[cacheName].cacheUserLanguage(lng, _this2.options);
	      });
	    }
	  }, {
	    key: "getSimilarInWhitelist",
	    value: function getSimilarInWhitelist(cleanedLng) {
	      var _this3 = this;

	      if (!this.i18nOptions.whitelist) return;

	      if (cleanedLng.includes('-')) {
	        // i.e. es-MX should check if es is in whitelist
	        var prefix = cleanedLng.split('-')[0];
	        var cleanedPrefix = this.services.languageUtils.formatLanguageCode(prefix);
	        if (this.services.languageUtils.isWhitelisted(cleanedPrefix)) return cleanedPrefix; // if reached here, nothing found. continue to search for similar using only prefix

	        cleanedLng = cleanedPrefix;
	      } // i.e. 'pt' should return 'pt-BR'. If multiple in whitelist with 'pt-', then use first one in whitelist


	      var similar = this.i18nOptions.whitelist.find(function (whitelistLng) {
	        var cleanedWhitelistLng = _this3.services.languageUtils.formatLanguageCode(whitelistLng);

	        if (cleanedWhitelistLng.startsWith(cleanedLng)) return cleanedWhitelistLng;
	      });
	      if (similar) return similar;
	    }
	  }]);

	  return Browser;
	}();

	Browser.type = 'languageDetector';

	// translator from https://github.com/kobotoolbox/enketo-express
	var init$2;
	var t;
	var htmlParagraphsPostProcessor;
	var initialize$1;

	// Smap moved to top
	t = function( key, options ) {
		return i18next.t( key, options );
	};

	// The postProcessor assumes that array values with line breaks should be divided into HTML paragraphs.
	htmlParagraphsPostProcessor = {
	    type: 'postProcessor',
	    name: 'htmlParagraphsPostProcessor',
	    process: function( value ) {
	        var paragraphs = value.split( '\n' );
	        return ( paragraphs.length > 1 ) ? '<p>' + paragraphs.join( '</p><p>' ) + '</p>' : value;
	    }
	};

	/**
	 * Initializes translator and resolves **when translations have been loaded**.
	 *
	 * @param  {=*?} something can be anything
	 * @return {Promise}       promise resolving the original something argument
	 */
	init$2 = function( something ) {
	    return initialize$1
	        .then( function() {
	            return something;
	        } );
	};
	t.init = init$2;      // smap add to t

	initialize$1 = new Promise( function( resolve, reject ) {
	    i18next
	        .use( Backend )
	        .use( Browser )
	        .use( htmlParagraphsPostProcessor )
	        .init( {
	            whitelist: settings$1.languagesSupported,
	            fallbackLng: 'en',
	            joinArrays: '\n',
	            backend: {
	                loadPath: '/build/locales/__lng__/translation.json',
	            },
	            load: 'languageOnly',
	            lowerCaseLng: true,
	            detection: {
	                order: [ 'querystring', 'navigator' ],
	                lookupQuerystring: 'lang',
	                caches: false
	            },
	            interpolation: {
	                prefix: '__',
	                suffix: '__'
	            },
	            postProcess: [ 'htmlParagraphsPostProcessor' ]
	        }, function( error ) {
	            if ( error ) {
	                reject( error );
	            } else {
	                resolve();
	            }
	        } );
	} );

	/*
	module.exports = {
	    init: init,
	    t: t,
	    localize: localize
	};
	*/

	/**
	 * add keys from XSL stylesheets manually
	 *
	 * t('constraint.invalid');
	 * t('constraint.required');
	 * t('form.required');
	 *
	 * // The following 3 are temporary:
	 * t('drawwidget.drawing');
	 * t('drawwidget.signature');
	 * t('drawwidget.annotation');
	 */

	var mergexml = createCommonjsModule(function (module, exports) {
	/**
	 * JS XML merging class
	 * merge multiple XML sources
	 * supports browser and NodeJS environments
	 * 
	 * @package     MergeXML
	 * @author      Vallo Reima
	 * @copyright   (C)2014-2019
	 */

	/**
	 * AMD/CommonJS wrapper
	 * @author Martijn van de Rijdt
	 * 
	 * @param {object} root
	 * @param {function} factory
	 */
	(function (root, factory) {
	  {
	    // Does not work with strict CommonJS, 
	    // but only CommonJS-like environments 
	    // that support module.exports, like Node
	    module.exports = factory();
	  }
	}(commonjsGlobal, function () {
	  /**
	   * Return a function as the exported value
	   * @param {object} opts -- processiong options (see readme)
	   */
	  return function (opts) {

	    var mde;        /* access mode: 1 - IE, 2 - browser, 3 - nodejs */
	    var msv;        /* MS DOM version */
	    var psr;        /* DOMParser object */
	    var xpe;        /* xPath evaluator object */
	    var xpr;        /* XPathResult object */
	    var nsr;        /* namespace resolver method */
	    var nsd = {/* default namespace prefix and URIs */
	      pfx: '_',
	      psr: 'http://www.w3.org/1999/xhtml',
	      xpe: 'http://www.w3.org/2000/xmlns/'
	    };
	    var erp;        /* parsing error flag */
	    var stay;       /* overwrite protection */
	    var join;       /* joining root name and status*/
	    var updn;       /* update nodes sequentially by name */
	    var XML_ELEMENT_NODE = 1;
	    var XML_TEXT_NODE = 3;
	    var XML_COMMENT_NODE = 8;
	    var XML_PI_NODE = 7;
	    var that = this;

	    var Init = function () {
	      that.error = {};
	      /* detect NodeJS environment */
	      if (typeof process !== 'undefined' && process.versions && process.versions.node) {
	        var p = typeof opts === 'object' && typeof opts.path === 'string' ? opts.path : '';
	        try {  //obtain xml support
	          commonjsGlobal.XPathEvaluator = commonjsRequire(p + 'xpath');
	          commonjsGlobal.DOMParser = commonjsRequire(p + 'xmldom').DOMParser;
	          commonjsGlobal.XMLSerializer = commonjsRequire(p + 'xmldom').XMLSerializer;
	        } catch (e) {
	          console.log(e.message);
	        }
	      }
	      mde = Setup(); //set mode
	      that.Init(opts);
	    };

	    /**
	     * determine mode, set functionality
	     * @returns {mixed} -- int - mode
	     *                     false - failed 
	     */
	    var Setup = function () {
	      var m;
	      var f = false;
	      var vers = [//IE 
	        'MSXML2.DOMDocument.6.0',
	        'MSXML2.DOMDocument.3.0',
	        'MSXML2.DOMDocument',
	        'Microsoft.XmlDom'
	      ];
	      var n = vers.length;
	      for (var i = 0; i < n; i++) {
	        try {
	          var d = new ActiveXObject(vers[i]);
	          d.async = false;
	          f = true;   /* DOM supported */
	          if (d.loadXML('<x></x>') && d.selectSingleNode('/')) {
	            break;    /* xPath supported */
	          }
	        } catch (e) {
	          /* skip */
	        }
	      }
	      if (f) {
	        if (i < n) {
	          msv = vers[i];
	          m = 1;  /* IE mode */
	        } else {
	          m = 'nox';  /* no xPath */
	        }
	      } else {
	        var env;
	        if (typeof window !== 'undefined') {
	          env = window;
	          m = 2;  // any browser 
	        } else if (typeof commonjsGlobal !== 'undefined') {
	          env = commonjsGlobal;
	          m = 3; // NodeJS
	        } else {
	          env = {}; //unknown
	        }
	        if (!env.DOMParser) {
	          m = 'nod';  /* no DOM */
	        } else if (!env.XMLSerializer) {
	          m = 'nos';  /* no Serializer */
	        } else if (!env.XPathEvaluator) {
	          m = 'nox';  /* no xPath */
	        } else if (m === 2) { //browser
	          psr = new env.DOMParser();
	          xpe = new env.XPathEvaluator();
	          xpr = env.XPathResult;
	          f = psr.parseFromString('<invalid', 'text/xml'); /* force parsing error */
	          nsd.psr = f.getElementsByTagName('parsererror')[0].namespaceURI; //browser default namespace
	        } else {
	          psr = new env.DOMParser({xmlns: nsd.psr, errorHandler: function () {
	              erp = true; //indicate parse error
	            }});
	          xpe = env.XPathEvaluator;
	          xpr = env.XPathEvaluator.XPathResult;
	          nsd.xpe = xpe.XPath.XMLNS_NAMESPACE_URI;
	        }
	      }
	      return typeof m === 'string' ? Error(m) : m;
	    };

	    /**
	     * (re)set the objects
	     * @param {object} opt -- processiong options
	     * @returns {mixed} -- false - error 
	     */
	    that.Init = function (opt) {
	      if (typeof opt !== 'object') {
	        opt = {};
	      }
	      /* set stay attribute value to check */
	      if (typeof opt.stay === 'undefined') {
	        if (typeof stay === 'undefined') {
	          stay = ['all'];
	        }
	      } else if (!opt.stay) {
	        stay = [];
	      } else if (typeof opt.stay === 'object' && opt.stay instanceof Array) {
	        stay = opt.stay;
	      } else {
	        stay = [opt.stay];
	      }
	      /* set join condition for different roots */
	      if (typeof opt.join === 'undefined') {
	        if (typeof join === 'undefined') {
	          join = ['root'];
	        }
	      } else if (!opt.join) {
	        join = [false];
	      } else {
	        join = [String(opt.join)];
	      }
	      join[1] = false;
	      /* set update sequence manner */
	      if (typeof opt.updn !== 'undefined') {
	        updn = opt.updn; 
	      } else if (typeof updn === 'undefined') {
	        updn = true; 
	      }
	      that.dom = null; /* result DOM object */
	      that.nsp = {};   /* namespaces */
	      that.count = 0; /* adding counter */
	      if (mde) {
	        that.error = {code: '', text: ''};
	      }
	      return mde;
	    };

	    /**
	     * add XML file
	     * @param {object} file -- FileList element
	     * @return {object|false}
	     */
	    that.AddFile = function (file) {
	      var rlt;
	      if (!mde) {
	        rlt = mde;
	      } else if (!file || !file.target) {
	        rlt = Error('nof');
	      } else if (!file.target.result) {
	        rlt = Error('emf');
	      } else {
	        rlt = that.AddSource(file.target.result);
	      }
	      return rlt;
	    };

	    /**
	     * add XML string
	     * @param {string|oobject} xml
	     * @return mixed -- false - bad content
	     *                  object - result
	     */
	    that.AddSource = function (xml) {
	      var rlt, doc;
	      if (mde) {
	        if (typeof xml === 'object') {
	          doc = that.Get(1, xml) ? xml : false;
	          if (doc && ((mde > 1 && !DOMParser) || (mde === 1 && !doc.selectSingleNode('/')))) {
	            doc = null; /* not compatible */
	          }
	        } else {
	          try {
	            doc = Load(xml);
	          } catch (e) {
	            doc = false;
	          }
	        }
	      }
	      if (!mde) {
	        rlt = mde;
	      } else if (doc === null) {
	        rlt = Error('nob');
	      } else if (doc === false) {
	        rlt = Error('inv');
	      } else if (doc === true) {
	        that.nsp = NameSpaces(that.dom.documentElement);
	        that.count = 1;
	        rlt = that.dom;
	      } else if (CheckSource(doc)) {
	        Merge(doc, '/');  /* add to existing */
	        if (join[1] === true) {
	          var tmp = that.dom.createTextNode("\r\n");
	          that.dom.documentElement.appendChild(tmp);
	        }
	        that.count++;
	        rlt = that.dom;
	      } else {
	        rlt = false;
	      }
	      return rlt;
	    };

	    /**
	     * load the source into dom object
	     * @param {object|string} src -- the source
	     * @return {mixed} -- false - error
	     *                    true - 1st load
	     *                    object - loaded doc
	     */
	    var Load = function (src) {
	      var rlt, doc;
	      if (mde > 1) {
	        erp = false;
	        if (that.dom) {
	          doc = psr.parseFromString(src, 'text/xml');
	          rlt = ParseError(doc) ? doc : false;
	        } else {
	          that.dom = psr.parseFromString(src, 'text/xml');
	          rlt = ParseError(that.dom) ? true : false;
	        }
	      } else if (that.dom) {
	        doc = new ActiveXObject(msv);
	        doc.async = false;
	        rlt = doc.loadXML(src) ? doc : false;
	      } else {
	        that.dom = new ActiveXObject(msv);
	        that.dom.async = false;
	        that.dom.setProperty('SelectionLanguage', 'XPath');
	        rlt = that.dom.loadXML(src) ? true : false;
	      }
	      return rlt;
	    };

	    /**
	     * check for xml syntax (mode 2)
	     * @param {object} doc
	     * @return {bool} -- true - ok
	     */
	    var ParseError = function (doc) {
	      return !erp && !doc.getElementsByTagNameNS(nsd.psr, 'parsererror').length;
	    };

	    /**
	     * 
	     * @param {object} doc
	     * @return {bool} -- true - ok
	     */
	    var CheckSource = function (doc) {
	      var rlt = true;
	      var charSet1 = that.dom.characterSet || that.dom.inputEncoding || that.dom.xmlEncoding;
	      var charSet2 = doc.characterSet || doc.inputEncoding || doc.xmlEncoding;
	      if (charSet2 !== charSet1) {
	        rlt = Error('enc');
	      } else if (doc.documentElement.namespaceURI !== that.dom.documentElement.namespaceURI) { /* $dom->documentElement->lookupnamespaceURI(NULL) */
	        rlt = Error('nse');
	      } else if (doc.documentElement.nodeName !== that.dom.documentElement.nodeName) {
	        if (!join[0]) {
	          rlt = Error('dif');
	        } else if (!join[1]) {
	          var enc = typeof charSet1 !== 'undefined' ? charSet1 : 'UTF-8';
	          var ver = that.dom.xmlVersion ? that.dom.xmlVersion : '1.0';
	          var xml = '<?xml version="' + ver + '" encoding="' + enc + "\"?>\r\n<" + join[0] + ">\r\n</" + join[0] + '>';
	          var d = Load(xml);
	          if (d) {
	            var tmp = that.dom.documentElement.cloneNode(true);
	            d.documentElement.appendChild(tmp);
	            tmp = d.createTextNode("\r\n");
	            d.documentElement.appendChild(tmp);
	            that.dom = d;
	            join[1] = true;
	          } else {
	            rlt = Error('jne');
	            join[1] = null;
	          }
	        }
	      }
	      if (rlt) {
	        var a = NameSpaces(doc.documentElement);
	        for (var c in a) {
	          if (!that.nsp[c]) {
	            if (typeof that.dom.documentElement.setAttributeNS !== 'undefined') {
	              that.dom.documentElement.setAttributeNS(nsd.xpe, 'xmlns:' + c, a[c]);
	            } else {
	              // no choice but to use the incorrect setAttribute instead
	              that.dom.documentElement.setAttribute('xmlns:' + c, a[c]);
	            }
	            that.nsp[c] = a[c];
	          }
	        }
	        if (!updn) {
	          nsr = null;
	        } else if (mde === 1) {
	          ResolverIE();
	        } else if (mde === 3) {
	          nsr = that;
	        } else {
	          nsr = that.lookupNamespaceURI;
	        }
	      }
	      return rlt;
	    };
	    /**
	     * join 2 dom objects recursively
	     * @param {object} src -- current source node
	     * @param {string} pth -- current source path
	     */
	    var Merge = function (src, pth) {
	      for (var i = 0; i < src.childNodes.length; i++) {
	        var tmp;
	        var node = src.childNodes[i]; //$node->getNodePath()
	        var path = GetNodePath(src.childNodes, node, pth, i);
	        var obj = that.Query(path);
	        if (node.nodeType === XML_ELEMENT_NODE) {
	          var flg = true;  /* replace existing node by default */
	          if (obj === null || obj.namespaceURI !== node.namespaceURI) {
	            tmp = node.cloneNode(true); /* take existing node */
	            obj = that.Query(pth); /* destination parent */
	            obj.appendChild(tmp); /* add a node */
	          } else {
	            if (ArraySearch(obj.getAttribute('stay'), stay) !== false) {
	              flg = false; /* don't replace */
	            }
	            if (flg) {
	              try {
	                for (var j = 0; j < node.attributes.length; j++) { /* add/replace attributes */
	                  if (node.attributes[j].namespaceURI && typeof node.setAttributeNS !== 'undefined') {
	                    obj.setAttributeNS(node.attributes[j].namespaceURI, node.attributes[j].nodeName, node.attributes[j].nodeValue);
	                  } else {
	                    obj.setAttribute(node.attributes[j].nodeName, node.attributes[j].nodeValue);
	                  }
	                }
	              } catch (e) {
	                /* read-only node */
	              }
	            }
	          }
	          if (node.hasChildNodes() && flg) {
	            Merge(node, path); /* go to subnodes */
	          }
	        } else if (node.nodeType === XML_TEXT_NODE || node.nodeType === XML_COMMENT_NODE) { /* leaf node */
	          if (obj === null || obj.nodeType !== node.nodeType) {
	            obj = that.Query(pth);    /* destination parent node */
	            if (node.nodeType === XML_TEXT_NODE) {
	              tmp = that.dom.createTextNode(node.nodeValue); /* add text */
	            } else {
	              tmp = that.dom.createComment(node.nodeValue);  /* add comment */
	            }
	            obj.appendChild(tmp); /* add leaf */
	          } else {
	            obj.nodeValue = node.nodeValue; /* replace leaf */
	            obj.data = node.data; //to ensure serializing
	          }
	        }
	      }
	    };

	    /**
	     * form the node xPath
	     * @param {object} nodes -- child nodes
	     * @param {object} node -- current child
	     * @param {string} pth -- parent path
	     * @param {int} eln -- element sequence number
	     * @return {string} query path
	     */
	    var GetNodePath = function (nodes, node, pth, eln) {
	      var p, i;
	      var j = 0;
	      if (node.nodeType === XML_ELEMENT_NODE) {
	        for (i = 0; i <= eln; i++) {
	          if ((updn && nodes[i].nodeType === node.nodeType && nodes[i].nodeName === node.nodeName) ||
	                  (!updn && nodes[i].nodeType !== XML_PI_NODE)) {
	            j++;
	          }
	        }
	        if (updn) {
	          var f = false;
	          var a = NameSpaces(node);
	          for (var c in a) {
	            if (c !== nsd.pfx) {
	              that.nsp[c] = a[c];
	              f = (mde === 1);
	            }
	          }
	          if (f) {
	            ResolverIE();
	          }
	          if (node.prefix) {
	            p = node.prefix + ':';
	          } else if (that.nsp[nsd.pfx]) {
	            p = nsd.pfx + ':';
	          } else {
	            p = '';
	          }
	          p += (node.localName ? node.localName : node.baseName);
	        } else {
	          p = 'node()';
	        }
	      } else if (node.nodeType === XML_TEXT_NODE || node.nodeType === XML_COMMENT_NODE) {
	        for (i = 0; i <= eln; i++) {
	          if (nodes[i].nodeType === node.nodeType) {
	            j++;
	          }
	        }
	        p = node.nodeType === XML_TEXT_NODE ? 'text()' : 'comment()';
	      } else {
	        p = pth;
	      }
	      if (j) {
	        p = pth + (pth.slice(-1) === '/' ? '' : '/') + p + '[' + j + ']';
	      }
	      return p;
	    };

	    /**
	     * get node's namespaces
	     * @param {object} node
	     * @return {array} 
	     */
	    var NameSpaces = function (node) {
	      var rlt = {};
	      var attrs = node.attributes;
	      for (var i = 0; i < attrs.length; ++i) {
	        var a = attrs[i].name.split(':');
	        if (a[0] === 'xmlns') {
	          var c = a[1] ? a[1] : nsd.pfx;
	          rlt[c] = attrs[i].value;
	        }
	      }
	      return rlt;
	    };

	    /**
	     * xPath query
	     * @param {string} qry -- query statement
	     * @return {object}
	     */
	    that.Query = function (qry) {
	      if (!mde) {
	        return null;
	      }
	      var rlt;
	      if (join[1]) {
	        qry = '/' + that.dom.documentElement.nodeName + (qry === '/' ? '' : qry);
	      }
	      try {
	        if (mde > 1) {
	          rlt = xpe.evaluate(qry, that.dom, nsr, xpr.FIRST_ORDERED_NODE_TYPE, null);
	          rlt = rlt.singleNodeValue;
	        } else {
	          rlt = that.dom.selectSingleNode(qry);
	        }
	      } catch (e) {
	        rlt = null; /* no such path */
	      }
	      return rlt;
	    };

	    /**
	     * XPathNSResolver 
	     * @param {string} pfx node prefix
	     * @return {string} namespace URI
	     */
	    that.lookupNamespaceURI = function (pfx) {
	      return that.nsp[pfx] || null;
	    };

	    /**
	     * XPath IE Resolver 
	     */
	    var ResolverIE = function () {
	      var p = '';
	      for (var c in that.nsp) {
	        p += ' xmlns:' + c + '=' + "'" + that.nsp[c] + "'";
	      }
	      if (p) {
	        that.dom.setProperty('SelectionNamespaces', p.substr(1));
	      }
	    };

	    /**
	     * find array memeber by value
	     * @param {mixed} val
	     * @param {array} arr
	     * @returns {mixed}
	     */
	    var ArraySearch = function (val, arr) {
	      var rlt = false;
	      for (var key in arr) {
	        if (arr[key] === val) {
	          rlt = key;
	          break;
	        }
	      }
	      return rlt;
	    };

	    /**
	     * get result
	     * @param {int} flg -- 0 - object
	     *                     1 - xml
	     *                     2 - html
	     * @param {object} doc
	     * @return {mixed}
	     */
	    that.Get = function (flg, doc) {
	      var rlt;
	      if (flg && !doc) {
	        doc = that.dom;
	      }
	      if (!mde) {
	        rlt = that.error.text;
	      } else if (!flg) {
	        rlt = that.dom;
	      } else if (!doc) {
	        rlt = '';
	      } else if (doc.xml) {
	        rlt = doc.xml;
	      } else {
	        try {
	          rlt = (new XMLSerializer()).serializeToString(doc);
	        } catch (e) {
	          rlt = e.message;
	          flg = null;
	        }
	      }
	      if (rlt && flg === 2) { /* make html view */
	        if (join[1]) {
	          var k = rlt.indexOf('<' + join[0]);
	          rlt = rlt.substr(0, k) + "\r\n" + rlt.substr(k);
	        }
	        rlt = rlt.replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/ |\t/g, '&nbsp;'); /* tags and spaces */
	        rlt = rlt.replace(/(\r\n|\n|\r)/g, '<br>');  /* line breaks */
	      }
	      return rlt;
	    };

	    /**
	     * set error message
	     * @param {string} err -- token
	     * @return {bool} false
	     */
	    var Error = function (err) {
	      var errs = {
	        nod: 'XML DOM is not supported',
	        nos: 'Serializer is not supported',
	        nox: 'xPath is not supported',
	        nob: 'Incompatible source object',
	        nof: 'File not found',
	        emf: 'File is empty', /* possible delivery fault */
	        inv: 'Invalid XML source',
	        enc: 'Different encoding',
	        dif: 'Different root nodes',
	        jne: 'Invalid join parameter',
	        nse: 'Namespace incompatibility',
	        und: 'Undefined error'
	      };
	      that.error.code = errs[err] ? err : 'und';
	      that.error.text = errs[that.error.code];
	      return false;
	    };

	    Init();
	  };
	}));
	});

	/**
	 * Various utilities.
	 *
	 * @module utils
	 */

	let cookies;

	/**
	 * Parses an Expression to extract all function calls and their argument arrays.
	 *
	 * @static
	 * @param {string} expr - The expression to search
	 * @param {string} func - The function name to search for
	 * @return {Array<Array<string, any>>} The result array, where each result is an array containing the function call and array of arguments.
	 */
	function parseFunctionFromExpression( expr, func ) {
	    let result;
	    const findFunc = new RegExp( `${func}\\s*\\(`, 'g' );
	    const results = [];

	    if ( !expr || !func ) {
	        return results;
	    }

	    while ( ( result = findFunc.exec( expr ) ) !== null ) {
	        const args = [];
	        let openBrackets = 1;
	        let start = result.index;
	        let argStart = findFunc.lastIndex;
	        let index = argStart - 1;
	        while ( openBrackets !== 0 && index < expr.length ) {
	            index++;
	            if ( expr[ index ] === '(' ) {
	                openBrackets++;
	            } else if ( expr[ index ] === ')' ) {
	                openBrackets--;
	            } else if ( expr[ index ] === ',' && openBrackets === 1 ) {
	                args.push( expr.substring( argStart, index ).trim() );
	                argStart = index + 1;
	            }
	        }
	        // add last argument
	        if ( argStart < index ) {
	            args.push( expr.substring( argStart, index ).trim() );
	        }

	        // add [ 'function( a ,b)', ['a','b'] ] to result array
	        results.push( [ expr.substring( start, index + 1 ), args ] );
	    }

	    return results;
	}

	/**
	 * @static
	 * @param {string} str - original string
	 * @return {string} stripped string
	 */
	function stripQuotes( str ) {
	    if ( /^".+"$/.test( str ) || /^'.+'$/.test( str ) ) {
	        return str.substring( 1, str.length - 1 );
	    }

	    return str;
	}

	// Because iOS gives any camera-provided file the same filename, we need to a
	// unique-ified filename.
	//
	// See https://github.com/kobotoolbox/enketo-express/issues/374
	/**
	 * @static
	 * @param {object} file - File instance
	 * @param {string} postfix - postfix for filename
	 * @return {string} new filename
	 */
	function getFilename( file, postfix ) {
	    if ( typeof file === 'object' && file !== null && file.name ) {
	        postfix = postfix || '';
	        const filenameParts = file.name.split( '.' );
	        if ( filenameParts.length > 1 ) {
	            filenameParts[ filenameParts.length - 2 ] += postfix;
	        } else if ( filenameParts.length === 1 ) {
	            filenameParts[ 0 ] += postfix;
	        }

	        return filenameParts.join( '.' );
	    }

	    return '';
	}

	/**
	 * @static
	 * @param {*} n - value
	 * @return {boolean} whether it is a number value
	 */
	function isNumber( n ) {
	    return !isNaN( parseFloat( n ) ) && isFinite( n );
	}

	/**
	 * @static
	 * @param {string} name - a cookie to look for
	 * @return {string|undefined} the value of the cookie
	 */
	function readCookie( name ) {
	    if ( cookies ) {
	        return cookies[ name ];
	    }

	    // In enketo-validate and perhaps other contexts, enketo-core is used in an empty page in a headless browser
	    // In such a context document.cookie throws an 'Access is denied for this document' error.
	    try {
	        const parts = document.cookie.split( '; ' );
	        cookies = {};

	        for ( let i = parts.length - 1; i >= 0; i-- ) {
	            const ck = parts[ i ].split( '=' );
	            // decode URI
	            ck[ 1 ] = decodeURIComponent( ck[ 1 ] );
	            // if cookie is signed (using expressjs/cookie-parser/), extract value
	            if ( ck[ 1 ].substr( 0, 2 ) === 's:' ) {
	                ck[ 1 ] = ck[ 1 ].slice( 2 );
	                ck[ 1 ] = ck[ 1 ].slice( 0, ck[ 1 ].lastIndexOf( '.' ) );
	            }
	            cookies[ ck[ 0 ] ] = decodeURIComponent( ck[ 1 ] );
	        }

	        return cookies[ name ];

	    } catch( e ){
	        console.error( 'Cookie error', e );

	        return null;
	    }
	}

	/**
	 * @static
	 * @param {string} dataURI - dataURI
	 * @return {Blob} dataURI converted to a Blob
	 */
	function dataUriToBlobSync( dataURI ) {
	    // convert base64 to raw binary data held in a string
	    // doesn't handle URLEncoded DataURIs - see SO answer #6850276 for code that does this
	    const byteString = atob( dataURI.split( ',' )[ 1 ] );
	    // separate out the mime component
	    const mimeString = dataURI.split( ',' )[ 0 ].split( ':' )[ 1 ].split( ';' )[ 0 ];

	    // write the bytes of the string to an ArrayBuffer
	    const buffer = new ArrayBuffer( byteString.length );
	    const array = new Uint8Array( buffer );

	    for ( let i = 0; i < byteString.length; i++ ) {
	        array[ i ] = byteString.charCodeAt( i );
	    }

	    // write the ArrayBuffer to a blob
	    return new Blob( [ array ], {
	        type: mimeString
	    } );
	}

	/**
	 * @static
	 * @param {Event} event - a paste event
	 * @return {string|null} clipboard data text value contained in event or null
	 */
	function getPasteData( event ) {
	    const clipboardData = event.clipboardData || window.clipboardData; // modern || IE11

	    return ( clipboardData ) ? clipboardData.getData( 'text' ) : null;
	}

	/**
	 * @static
	 * @param {File} file - Image file to be resized
	 * @param {number} maxPixels - Maximum pixels of resized image
	 * @return {Promise<Blob>} Promise of resized image blob
	 */
	function resizeImage( file, maxPixels ) {
	    return new Promise( ( resolve, reject ) => {
	        const image = new Image();
	        image.src = URL.createObjectURL( file );
	        image.onload = () => {
	            const width = image.width;
	            const height = image.height;

	            if ( width <= maxPixels && height <= maxPixels ) {
	                resolve( file );
	            }

	            let newWidth;
	            let newHeight;

	            if ( width > height ) {
	                newHeight = height * ( maxPixels / width );
	                newWidth = maxPixels;
	            } else {
	                newWidth = width * ( maxPixels / height );
	                newHeight = maxPixels;
	            }

	            const canvas = document.createElement( 'canvas' );
	            canvas.width = newWidth;
	            canvas.height = newHeight;

	            const context = canvas.getContext( '2d' );

	            context.drawImage( image, 0, 0, newWidth, newHeight );

	            canvas.toBlob( resolve, file.type );
	        };
	        image.onerror = reject;
	    } );
	}

	/**
	 * Copied from: https://gist.github.com/creationix/7435851
	 * Joins path segments.  Preserves initial "/" and resolves ".." and "."
	 * Does not support using ".." to go above/outside the root.
	 * This means that join("foo", "../../bar") will not resolve to "../bar"
	 */
	function joinPath( /* path segments */ ) {
	    // Split the inputs into a list of path commands.
	    let parts = [];
	    for ( var i = 0, l = arguments.length; i < l; i++ ) {
	        parts = parts.concat( arguments[i].split( '/' ) );
	    }
	    // Interpret the path commands to get the new resolved path.
	    let newParts = [];
	    for ( i = 0, l = parts.length; i < l; i++ ) {
	        var part = parts[i];
	        // Remove leading and trailing slashes
	        // Also remove "." segments
	        if ( !part || part === '.' ) continue;
	        // Interpret ".." to pop the last segment
	        if ( part === '..' ) newParts.pop();
	        // Push new path segments.
	        else newParts.push( part );
	    }
	    // Preserve the initial slash if there was one.
	    if ( parts[0] === '' ) newParts.unshift( '' );

	    // Turn back into a single string path.
	    return newParts.join( '/' ) || ( newParts.length ? '/' : '.' );
	}


	function getScript( url ) {
	    const scriptTag = document.createElement( 'script' );
	    const firstScriptTag = document.getElementsByTagName( 'script' )[0];
	    scriptTag.src = url;
	    firstScriptTag.parentNode.insertBefore( scriptTag, firstScriptTag );
	}

	function encodeHtmlEntities( text ){
	    return text
	        .replace( /&/g, '&amp;' )
	        .replace( /</g, '&lt;' )
	        .replace( />/g, '&gt;' )
	        .replace( /"/g, '&quot;' );
	}

	/**
	 * @module dom-utils
	 */

	/**
	 * Gets siblings that match selector and self _in DOM order_.
	 *
	 * @static
	 * @param {Node} element - Target element.
	 * @param {string} [selector] - A CSS selector for siblings (not for self).
	 * @return {Array<Node>} Array of sibling nodes plus target element.
	 */
	function getSiblingElementsAndSelf( element, selector ) {
	    return _getSiblingElements( element, selector, true );
	}

	/**
	 * Gets siblings that match selector _in DOM order_.
	 *
	 * @static
	 * @param {Node} element - Target element.
	 * @param {string} [selector] - A CSS selector.
	 * @return {Array<Node>} Array of sibling nodes.
	 */
	function getSiblingElements( element, selector ) {
	    return _getSiblingElements( element, selector );
	}

	/**
	 * Returns first sibling element (in DOM order) that optionally matches the provided selector.
	 *
	 * @param {Node} element - Target element.
	 * @param {string} [selector] - A CSS selector.
	 * @return {Node} First sibling element in DOM order
	 */
	function getSiblingElement( element, selector = '*' ){
	    let found;
	    let current = element.parentElement.firstElementChild;

	    while ( current && !found ) {
	        if ( current !== element && current.matches( selector ) ) {
	            found = current;
	        }
	        current = current.nextElementSibling;
	    }

	    return found;
	}

	/**
	 * Gets siblings that match selector _in DOM order_.
	 *
	 * @param {Node} element - Target element.
	 * @param {string} [selector] - A CSS selector.
	 * @param {boolean} [includeSelf] - Whether to include self.
	 * @return {Array<Node>} Array of sibling nodes.
	 */
	function _getSiblingElements( element, selector = '*', includeSelf = false ) {
	    const results = [];
	    let current = element.parentElement.firstElementChild;

	    while ( current ) {
	        if ( ( current === element && includeSelf ) || ( current !== element && current.matches( selector ) ) ){
	            results.push( current );
	        }
	        current = current.nextElementSibling;
	    }

	    return results;
	}

	/**
	 * Gets ancestors that match selector _in DOM order_.
	 *
	 * @static
	 * @param {Node} element - Target element.
	 * @param {string} [filterSelector] - A CSS selector.
	 * @param {string} [endSelector] - A CSS selector indicating where to stop. It will include this element if matched by the filter.
	 * @return {Array<Node>} Array of ancestors.
	 */
	function getAncestors( element, filterSelector = '*', endSelector ) {
	    const ancestors = [];
	    let parent = element.parentElement;

	    while ( parent ) {
	        if ( parent.matches( filterSelector ) ) {
	            // document order
	            ancestors.unshift( parent );
	        }
	        parent = endSelector && parent.matches( endSelector ) ? null : parent.parentElement;
	    }

	    return ancestors;
	}

	/**
	 * Gets closest ancestor that match selector until the end selector.
	 *
	 * @static
	 * @param {Node} element - Target element.
	 * @param {string} filterSelector - A CSS selector.
	 * @param {string} [endSelector] - A CSS selector indicating where to stop. It will include this element if matched by the filter.
	 * @return {Node} Closest ancestor.
	 */
	function closestAncestorUntil( element, filterSelector = '*', endSelector ) {
	    let parent = element.parentElement;
	    let found = null;

	    while ( parent && !found ) {
	        if ( parent.matches( filterSelector ) ) {
	            found = parent;
	        }
	        parent = endSelector && parent.matches( endSelector ) ? null : parent.parentElement;
	    }

	    return found;
	}

	/**
	 * Gets child elements, that (optionally) match a selector.
	 *
	 * @param {Node} element - Target element.
	 * @param {string} selector - A CSS selector.
	 * @return {Array<Node>} Array of child elements.
	 */
	function getChildren( element, selector = '*' ) {
	    return [ ...element.children ]
	        .filter( el => el.matches( selector ) );
	}

	/**
	 * Gets first child element, that (optionally) matches a selector.
	 *
	 * @param {Node} element - Target element.
	 * @param {string} selector - A CSS selector.
	 * @return {Node} - First child element.
	 */
	function getChild( element, selector = '*' ) {
	    return [ ...element.children ]
	        .find( el => el.matches( selector ) );
	}

	/**
	 * Removes all children elements.
	 *
	 * @static
	 * @param {Node} element - Target element.
	 * @return {undefined}
	 */
	function empty( element ) {
	    [ ...element.children ].forEach( el => el.remove() );
	}

	/**
	 * @param {Element} el - Target node
	 * @return {boolean} Whether previous sibling has same node name
	 */
	function hasPreviousSiblingElementSameName( el ) {
	    let found = false;
	    const nodeName = el.nodeName;
	    el = el.previousSibling;

	    while ( el ) {
	        // Ignore any sibling text and comment nodes (e.g. whitespace with a newline character)
	        // also deal with repeats that have non-repeat siblings in between them, event though that would be a bug.
	        if ( el.nodeName && el.nodeName === nodeName ) {
	            found = true;
	            break;
	        }
	        el = el.previousSibling;
	    }

	    return found;
	}

	/**
	 * @param {Element} node - Target node
	 * @param {string} content - Text content to look for
	 * @return {boolean} Whether previous comment sibling has given text content
	 */
	function hasPreviousCommentSiblingWithContent( node, content ) {
	    let found = false;
	    node = node.previousSibling;

	    while ( node ) {
	        if ( node.nodeType === Node.COMMENT_NODE && node.textContent === content ) {
	            found = true;
	            break;
	        }
	        node = node.previousSibling;
	    }

	    return found;
	}


	/**
	 * Creates an XPath from a node
	 *
	 * @param {Element} node - XML node
	 * @param {string} [rootNodeName] - Defaults to #document
	 * @param {boolean} [includePosition] - Whether or not to include the positions `/path/to/repeat[2]/node`
	 * @return {string} XPath
	 */
	function getXPath( node, rootNodeName = '#document', includePosition = false ) {
	    let index;
	    const steps = [];
	    let position = '';
	    if ( !node || node.nodeType !== 1 ) {
	        return null;
	    }
	    const nodeName = node.nodeName;
	    let parent = node.parentElement;
	    let parentName = parent ? parent.nodeName : null;

	    if ( includePosition ) {
	        index = getRepeatIndex( node );
	        if ( index > 0 ) {
	            position = `[${index + 1}]`;
	        }
	    }

	    steps.push( nodeName + position );

	    while ( parent && parentName !== rootNodeName && parentName !== '#document' ) {
	        if ( includePosition ) {
	            index = getRepeatIndex( parent );
	            position = ( index > 0 ) ? `[${index + 1}]` : '';
	        }
	        steps.push( parentName + position );
	        parent = parent.parentElement;
	        parentName = parent ? parent.nodeName : null;
	    }

	    return `/${steps.reverse().join( '/' )}`;
	}

	/**
	 * Obtains the index of a repeat instance within its own series.
	 *
	 * @param {Element} node - XML node
	 * @return {number} index
	 */
	function getRepeatIndex( node ) {
	    let index = 0;
	    const nodeName = node.nodeName;
	    let prevSibling = node.previousSibling;

	    while ( prevSibling ) {
	        // ignore any sibling text and comment nodes (e.g. whitespace with a newline character)
	        if ( prevSibling.nodeName && prevSibling.nodeName === nodeName ) {
	            index++;
	        }
	        prevSibling = prevSibling.previousSibling;
	    }

	    return index;
	}

	/**
	 * Adapted from https://stackoverflow.com/a/46522991/3071529
	 *
	 * A storage solution aimed at replacing jQuerys data function.
	 * Implementation Note: Elements are stored in a (WeakMap)[https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakMap].
	 * This makes sure the data is garbage collected when the node is removed.
	 *
	 * @namespace
	 */
	const elementDataStore = {
	    /**
	     * @type {WeakMap}
	     */
	    _storage: new WeakMap(),
	    /**
	     * Adds object to element storage. Ensures that element storage exist.
	     *
	     * @param {Node} element - target element
	     * @param {string} key - name of the stored data
	     * @param {object} obj - stored data
	     */
	    put: function( element, key, obj ) {
	        if ( !this._storage.has( element ) ) {
	            this._storage.set( element, new Map() );
	        }
	        this._storage.get( element ).set( key, obj );
	    },
	    /**
	     * Return object from element storage.
	     *
	     * @param {Node} element - target element
	     * @param {string} key - name of the stored data
	     * @return {object} stored data object
	     */
	    get: function( element, key ) {
	        const item = this._storage.get( element );

	        return item ? item.get( key ) : item;
	    },
	    /**
	     * Checkes whether element has given storage item.
	     *
	     * @param {Node} element - target element
	     * @param {string} key - name of the stored data
	     * @return {boolean} whether data is present
	     */
	    has: function( element, key ) {
	        const item = this._storage.get( element );

	        return item && item.has( key );
	    },
	    /**
	     * Removes item from element storage. Removes element storage if empty.
	     *
	     * @param {Node} element - target element
	     * @param {string} key - name of the stored data
	     * @return {object} removed data object
	     */
	    remove: function( element, key ) {
	        var ret = this._storage.get( element ).delete( key );
	        if ( !this._storage.get( key ).size === 0 ) {
	            this._storage.delete( element );
	        }

	        return ret;
	    }
	};

	class MutationsTracker{

	    constructor( el = document.documentElement ){
	        this.classChanges = new WeakMap();
	        this.quiet = true;

	        const mutationObserver = new MutationObserver(  mutations => {
	            mutations.forEach(  mutation => {
	                mutations++;
	                if ( mutation.type === 'attributes' && mutation.attributeName === 'class' ){
	                    const trackedClasses = this.classChanges.get( mutation.target ) || [];
	                    trackedClasses.forEach( obj => {
	                        if( mutation.target.classList.contains( obj.className ) ){
	                            obj.completed = true;
	                            this.classChanges.set( mutation.target, trackedClasses );
	                        }
	                    } );
	                }
	            } );
	        } );

	        mutationObserver.observe( el, {
	            attributes: true,
	            characterData: true,
	            childList: true,
	            subtree: true,
	            attributeOldValue: true,
	            characterDataOldValue: true
	        } );

	        const checkInterval = setInterval( () => {
	            {
	                this.quiet = true;
	                mutationObserver.disconnect();
	                clearInterval( checkInterval );
	            }
	        }, 100 );
	    }

	    _resolveWhenTrue( fn ){
	        if ( typeof fn !== 'function' ){
	            return Promise.reject();
	        }

	        return new Promise( resolve => {
	            const checkInterval = setInterval( () => {
	                if ( fn.call( this ) ){
	                    clearInterval( checkInterval );
	                    resolve();
	                }
	            }, 10 );
	        } );
	    }

	    waitForClassChange( element, className ){
	        const trackedClasses = this.classChanges.get( element ) || [];

	        if ( !trackedClasses.some( obj => obj.className === className ) ){
	            trackedClasses.push( { className } );
	            this.classChanges.set( element, trackedClasses );
	        }

	        return this._resolveWhenTrue( () => this.classChanges.get( element ).find( obj => obj.className === className ).completed );
	    }

	    waitForQuietness(){
	        return this._resolveWhenTrue( () => this.quiet );
	    }

	}

	/**
	 * A custom error type for form logic
	 *
	 * @class
	 * @augments Error
	 * @param {string} message - Optional message.
	 */
	function FormLogicError( message ) {
	    this.message = message || 'unknown';
	    this.name = 'FormLogicError';
	    this.stack = ( new Error() ).stack;
	}

	FormLogicError.prototype = Object.create( Error.prototype );
	FormLogicError.prototype.constructor = FormLogicError;

	/**
	 * @module format
	 */

	let _locale = navigator.language;
	const NUMBER = '0-9\u0660-\u0669';
	const TIME_PART = `[:${NUMBER}]+`;
	const MERIDIAN_PART = `[^: ${NUMBER}]+`;
	const HAS_MERIDIAN = new RegExp( `^(${TIME_PART} ?(${MERIDIAN_PART}))|((${MERIDIAN_PART}) ?${TIME_PART})$` );

	/**
	 * Transforms time to a cleaned-up localized time.
	 *
	 * @param {Date} dt - date object
	 * @return {string} cleaned-up localized time
	 */
	function _getCleanLocalTime( dt ) {
	    dt = typeof dt == 'undefined' ? new Date() : dt;

	    return _cleanSpecialChars( dt.toLocaleTimeString( _locale ) );
	}

	/**
	 * Remove unneeded and problematic special characters in (date)time string.
	 *
	 * @param {string} timeStr - (date)time string to clean up
	 * @return {string} transformed (date)time string with removed unneeded special characters that cause issues
	 */
	function _cleanSpecialChars( timeStr ) {
	    return timeStr.replace( /[\u200E\u200F]/g, '' );
	}

	/**
	 * @namespace time
	 */
	const time = {
	    // For now we just look at a subset of numbers in Arabic and Latin. There are actually over 20 number scripts and :digit: doesn't work in browsers
	    /**
	     * @type {string}
	     */
	    get hour12() {
	        return this.hasMeridian( _getCleanLocalTime() );
	    },
	    /**
	     * @type {string}
	     */
	    get pmNotation() {
	        return this.meridianNotation( new Date( 2000, 1, 1, 23, 0, 0 ) );
	    },
	    /**
	     * @type {string}
	     */
	    get amNotation() {
	        return this.meridianNotation( new Date( 2000, 1, 1, 1, 0, 0 ) );
	    },
	    /**
	     * @type {Function}
	     * @param {Date} dt - datetime string
	     */
	    meridianNotation( dt ) {
	        let matches = _getCleanLocalTime( dt ).match( HAS_MERIDIAN );
	        if ( matches && matches.length ) {
	            matches = matches.filter( item => !!item );

	            return matches[ matches.length - 1 ].trim();
	        }

	        return null;
	    },
	    /**
	     * Whether time string has meridian parts
	     *
	     * @type {Function}
	     * @param {string} time - Time string
	     */
	    hasMeridian( time ) {
	        return HAS_MERIDIAN.test( _cleanSpecialChars( time ) );
	    }
	};

	/**
	 * XML types
	 *
	 * @module types
	 */

	/**
	 * @namespace types
	 */
	const types = {
	    /**
	     * @namespace
	     */
	    'string': {
	        /**
	         * @param {string} x - value
	         * @return {string} converted value
	         */
	        convert( x ) {
	            return x.replace( /^\s+$/, '' );
	        },
	        //max length of type string is 255 chars.Convert( truncate ) silently ?
	        /**
	         * @return {boolean} always `true`
	         */
	        validate() {
	            return true;
	        }
	    },
	    /**
	     * @namespace
	     */
	    'select': {
	        /**
	         * @return {boolean} always `true`
	         */
	        validate() {
	            return true;
	        }
	    },
	    /**
	     * @namespace
	     */
	    'select1': {
	        /**
	         * @return {boolean} always `true`
	         */
	        validate() {
	            return true;
	        }
	    },
	    /**
	     * @namespace
	     */
	    'decimal': {
	        /**
	         * @param {number|string} x - value
	         * @return {number} converted value
	         */
	        convert( x ) {
	            const num = Number( x );
	            if ( isNaN( num ) || num === Number.POSITIVE_INFINITY || num === Number.NEGATIVE_INFINITY ) {
	                // Comply with XML schema decimal type that has no special values. '' is our only option.
	                return '';
	            }

	            return num;
	        },
	        /**
	         * @param {number|string} x - value
	         * @return {boolean} whether value is valid
	         */
	        validate( x ) {
	            const num = Number( x );

	            return !isNaN( num ) && num !== Number.POSITIVE_INFINITY && num !== Number.NEGATIVE_INFINITY;
	        }
	    },
	    /**
	     * @namespace
	     */
	    'int': {
	        /**
	         * @param {number|string} x - value
	         * @return {number} converted value
	         */
	        convert( x ) {
	            const num = Number( x );
	            if ( isNaN( num ) || num === Number.POSITIVE_INFINITY || num === Number.NEGATIVE_INFINITY ) {
	                // Comply with XML schema int type that has no special values. '' is our only option.
	                return '';
	            }

	            return ( num >= 0 ) ? Math.floor( num ) : -Math.floor( Math.abs( num ) );
	        },
	        /**
	         * @param {number|string} x - value
	         * @return {boolean} whether value is valid
	         */
	        validate( x ) {
	            const num = Number( x );

	            return !isNaN( num ) && num !== Number.POSITIVE_INFINITY && num !== Number.NEGATIVE_INFINITY && Math.round( num ) === num && num.toString() === x.toString();
	        }
	    },
	    /**
	     * @namespace
	     */
	    'date': {
	        /**
	         * @param {string} x - value
	         * @return {boolean} whether value is valid
	         */
	        validate( x ) {
	            const pattern = /^([0-9]{4})-([0-9]{2})-([0-9]{2})$/;
	            const segments = pattern.exec( x );
	            if ( segments && segments.length === 4 ) {
	                const year = Number( segments[ 1 ] );
	                const month = Number( segments[ 2 ] ) - 1;
	                const day = Number( segments[ 3 ] );
	                const date = new Date( year, month, day );

	                // Do not approve automatic JavaScript conversion of invalid dates such as 2017-12-32
	                return date.getFullYear() === year && date.getMonth() === month && date.getDate() === day;
	            }

	            return false;
	        },
	        /**
	         * @param {number|string} x - value
	         * @return {string} converted value
	         */
	        convert( x ) {
	            if ( isNumber( x ) ) {
	                // The XPath expression "2012-01-01" + 2 returns a number of days in XPath.
	                const date = new Date( x * 24 * 60 * 60 * 1000 );

	                return date.toString() === 'Invalid Date' ?
	                    '' : `${date.getFullYear().toString().padStart( 4, '0' )}-${( date.getMonth() + 1 ).toString().padStart( 2, '0' )}-${date.getDate().toString().padStart( 2, '0' )}`;
	            } else {
	                // For both dates and datetimes
	                // If it's a datetime, we can quite safely assume it's in the local timezone, and therefore we can simply chop off
	                // the time component.
	                if ( /[0-9]T[0-9]/.test( x ) ) {
	                    x = x.split( 'T' )[ 0 ];
	                }

	                return this.validate( x ) ? x : '';
	            }
	        }
	    },
	    /**
	     * @namespace
	     */
	    'datetime': {
	        /**
	         * @param {string} x - value
	         * @return {boolean} whether value is valid
	         */
	        validate( x ) {
	            const parts = x.split( 'T' );
	            if ( parts.length === 2 ) {
	                return types.date.validate( parts[ 0 ] ) && types.time.validate( parts[ 1 ], false );
	            } else {                        // smap check by splitting o nspace
		            const parts2 = x.split( ' ' );
		            if ( parts2.length === 2 ) {
			            return types.date.validate(parts2[0]) && types.time.validate(parts2[1], false);
		            }
	            }

	            return true;        // smap validate as ok - validate is being applied to read onlys set by calculate it should not be
	            //return types.data.validate( parts[ 0 ] );
	        },
	        /**
	         * @param {number|string} x - value
	         * @return {string} converted value
	         */
	        convert( x ) {
	            let date = 'Invalid Date';
	            const parts = x.split( 'T' );
	            if ( isNumber( x ) ) {
	                // The XPath expression "2012-01-01T01:02:03+01:00" + 2 returns a number of days in XPath.
	                date = new Date( x * 24 * 60 * 60 * 1000 );
	            } else if ( /[0-9]T[0-9]/.test( x ) && parts.length === 2 ) {
	                const convertedDate = types.date.convert( parts[ 0 ] );
	                // The milliseconds are optional for datetime (and shouldn't be added)
	                const convertedTime = types.time.convert( parts[ 1 ], false );
	                if ( convertedDate && convertedTime ) {
	                    return `${convertedDate}T${convertedTime}`;
	                }
	            } else {
	                const convertedDate = types.date.convert( parts[ 0 ] );
	                if ( convertedDate ) {
	                    return `${convertedDate}T00:00:00.000${( new Date() ).getTimezoneOffsetAsTime()}`;
	                }
	            }

	            return date.toString() !== 'Invalid Date' ? date.toISOLocalString() : '';
	        }
	    },
	    /**
	     * @namespace
	     */
	    'time': {
	        // Note that it's okay if the validate function is stricter than the spec,
	        // (for timezone offset), as long as the convertor automatically converts
	        // to a valid time.
	        /**
	         * @param {string} x - value
	         * @param {boolean} [requireMillis] - whether milliseconds are required
	         * @return {boolean} whether value is valid
	         */
	        validate( x, requireMillis ) {
	            let m = x.match( /^(\d\d):(\d\d):(\d\d)\.\d\d\d(\+|-)(\d\d):(\d\d)$/ );

	            requireMillis = typeof requireMillis !== 'boolean' ? true : requireMillis;

	            if ( !m && !requireMillis ) {
	                m = x.match( /^(\d\d):(\d\d):(\d\d)(\+|-)(\d\d):(\d\d)$/ );
	            }

	            if ( !m ) {
	                return false;
	            }

	            // no need to convert to numbers since we know they are number strings
	            return m[ 1 ] < 24 && m[ 1 ] >= 0 &&
	                m[ 2 ] < 60 && m[ 2 ] >= 0 &&
	                m[ 3 ] < 60 && m[ 3 ] >= 0 &&
	                m[ 5 ] < 24 && m[ 5 ] >= 0 && // this could be tighter
	                m[ 6 ] < 60 && m[ 6 ] >= 0; // this is probably either 0 or 30
	        },
	        /**
	         * @param {string} x - value
	         * @param {boolean} [requireMillis] - whether milliseconds are required
	         * @return {string} converted value
	         */
	        convert( x, requireMillis ) {
	            let date;
	            const o = {};
	            let parts;
	            let time;
	            let secs;
	            let tz;
	            let offset;
	            const timeAppearsCorrect = /^[0-9]{1,2}:[0-9]{1,2}(:[0-9.]*)?/;

	            requireMillis = typeof requireMillis !== 'boolean' ? true : requireMillis;

	            if ( !timeAppearsCorrect.test( x ) ) {
	                // An XPath expression would return a datetime string since there is no way to request a timeValue.
	                // We can test this by trying to convert to a date.
	                date = new Date( x );
	                if ( date.toString() !== 'Invalid Date' ) {
	                    x = `${date.getHours()}:${date.getMinutes()}:${date.getSeconds()}.${date.getMilliseconds()}${date.getTimezoneOffsetAsTime()}`;
	                } else {
	                    return '';
	                }
	            }

	            parts = x.toString().split( /(\+|-|Z)/ );
	            // We're using a 'capturing group' here, so the + or - is included!.
	            if ( parts.length < 1 ) {
	                return '';
	            }

	            time = parts[ 0 ].split( ':' );
	            tz = parts[ 2 ] ? [ parts[ 1 ] ].concat( parts[ 2 ].split( ':' ) ) : ( parts[ 1 ] === 'Z' ? [ '+', '00', '00' ] : [] );

	            o.hours = time[ 0 ].padStart( 2, '0' );
	            o.minutes = time[ 1 ].padStart( 2, '0' );

	            secs = time[ 2 ] ? time[ 2 ].split( '.' ) : [ '00' ];

	            o.seconds = secs[ 0 ];
	            o.milliseconds = secs[ 1 ] || ( requireMillis ? '000' : undefined );

	            if ( tz.length === 0 ) {
	                offset = new Date().getTimezoneOffsetAsTime();
	            } else {
	                offset = `${tz[0] + tz[1].padStart( 2, '0' )}:${tz[2] ? tz[2].padStart( 2, '0' ) : '00'}`;
	            }

	            x = `${o.hours}:${o.minutes}:${o.seconds}${o.milliseconds ? `.${o.milliseconds}` : ''}${offset}`;

	            return this.validate( x, requireMillis ) ? x : '';
	        },
	        /**
	         * converts "11:30 AM", and "11:30 ", and "11:30 上午" to: "11:30"
	         * converts "11:30 PM", and "11:30 下午" to: "23:30"
	         *
	         * @param {string} x - value
	         * @return {string} converted value
	         */
	        convertMeridian( x ) {
	            x = x.trim();
	            if ( time.hasMeridian( x ) ) {
	                const parts = x.split( ' ' );
	                const timeParts = parts[ 0 ].split( ':' );
	                if ( parts.length > 0 ) {
	                    // This will only work for latin numbers but that should be fine because that's what the widget supports.
	                    if ( parts[ 1 ] === time.pmNotation ) {
	                        timeParts[ 0 ] = ( ( Number( timeParts[ 0 ] ) % 12 ) + 12 ).toString().padStart( 2, '0' );
	                    } else if ( parts[ 1 ] === time.amNotation ) {
	                        timeParts[ 0 ] = ( Number( timeParts[ 0 ] ) % 12 ).toString().padStart( 2, '0' );
	                    }
	                    x = timeParts.join( ':' );
	                }
	            }

	            return x;
	        }
	    },
	    /**
	     * @namespace
	     */
	    'barcode': {
	        /**
	         * @return {boolean} always `true`
	         */
	        validate() {
	            return true;
	        }
	    },
	    /**
	     * @namespace
	     */
	    'geopoint': {
	        /**
	         * @param {string} x - value
	         * @return {boolean} whether value is valid
	         */
	        validate( x ) {
	            const coords = x.toString().trim().split( ' ' );

	            // Note that longitudes from -180 to 180 are problematic when recording points close to the international
	            // dateline. They are therefore set from -360  to 360 (circumventing Earth twice, I think) which is
	            // an arbitrary limit. https://github.com/kobotoolbox/enketo-express/issues/1033
	            return ( coords[ 0 ] !== '' && coords[ 0 ] >= -90 && coords[ 0 ] <= 90 ) &&
	                ( coords[ 1 ] !== '' && coords[ 1 ] >= -360 && coords[ 1 ] <= 360 ) &&
	                ( typeof coords[ 2 ] === 'undefined' || !isNaN( coords[ 2 ] ) ) &&
	                ( typeof coords[ 3 ] === 'undefined' || ( !isNaN( coords[ 3 ] ) && coords[ 3 ] >= 0 ) );
	        },
	        /**
	         * @param {string} x - value
	         * @return {string} converted value
	         */
	        convert( x ) {
	            return x.toString().trim();
	        }
	    },
	    /**
	     * @namespace
	     */
	    'geotrace': {
	        /**
	         * @param {string} x - value
	         * @return {boolean} whether value is valid
	         */
	        validate( x ) {
	            const geopoints = x.toString().split( ';' );

	            return geopoints.length >= 2 && geopoints.every( geopoint => types.geopoint.validate( geopoint ) );
	        },
	        /**
	         * @param {string} x - value
	         * @return {string} converted value
	         */
	        convert( x ) {
	            return x.toString().trim();
	        }
	    },
	    /**
	     * @namespace
	     */
	    'geoshape': {
	        /**
	         * @param {string} x - value
	         * @return {boolean} whether value is valid
	         */
	        validate( x ) {
	            const geopoints = x.toString().split( ';' );

	            return geopoints.length >= 4 && ( geopoints[ 0 ] === geopoints[ geopoints.length - 1 ] ) && geopoints.every( geopoint => types.geopoint.validate( geopoint ) );
	        },
	        /**
	         * @param {string} x - value
	         * @return {string} converted value
	         */
	        convert( x ) {
	            return x.toString().trim();
	        }
	    },
	    /**
	     * @namespace
	     */
	    'binary': {
	        /**
	         * @return {boolean} always `true`
	         */
	        validate() {
	            return true;
	        }
	    }
	};

	/**
	 * @module event
	 */
	// TODO: add second "propagate" parameter to constructors to add .enketo namespace to event.

	/**
	 * Data update event.
	 *
	 * @static
	 * @param {*} detail - Data to be passed with event
	 * @return {CustomEvent} Custom "dataupdate" event
	 */
	function DataUpdate( detail ) {
	    return new CustomEvent( 'dataupdate', { detail } );
	}

	/**
	 * Fake focus event.
	 *
	 * @return {CustomEvent} Custom "fakefocus" event (bubbling)
	 */
	function FakeFocus() {
	    return new CustomEvent( 'fakefocus', { bubbles: true } );
	}

	/**
	 * Apply focus event.
	 *
	 * @return {CustomEvent} Custom "applyfocus" event
	 */
	function ApplyFocus() {
	    return new CustomEvent( 'applyfocus' );
	}

	/**
	 * Page flip event.
	 *
	 * @return {CustomEvent} Custom "pageflip" event (bubbling)
	 */
	function PageFlip() {
	    return new CustomEvent( 'pageflip', { bubbles: true } );
	}

	/**
	 * Removed event.
	 *
	 * @param {*} detail - Data to be passed with event
	 * @return {CustomEvent} Custom "removed" event (bubbling)
	 */
	function Removed( detail ) {
	    return new CustomEvent( 'removed', { detail, bubbles: true } );
	}

	/**
	 * The odk-instance-first-load event as defined in the ODK XForms spec.
	 *
	 * @see https://getodk.github.io/xforms-spec/#event:odk-instance-first-load
	 *@return {CustomEvent} Custom "odk-instance-first-load" event (bubbling)
	 */
	function InstanceFirstLoad() {
	    return new CustomEvent( 'odk-instance-first-load', { bubbles: true } );
	}

	/**
	 * The odk-new-repeat event as defined in the ODK XForms spec.
	 *
	 * @see https://getodk.github.io/xforms-spec/#event:odk-new-repeat
	 * @param {{repeatPath: string, repeatIndex: number, trigger: string}} detail - Data to be passed with event.
	 * @return {CustomEvent} Custom "odk-new-repeat" event (bubbling)
	 */
	function NewRepeat( detail ) {
	    return new CustomEvent( 'odk-new-repeat', { detail, bubbles: true } );
	}

	/**
	 * The addrepeat event is similar but fired under different circumstances.
	 *
	 * @param {{repeatPath: string, repeatIndex: number, trigger: string}} detail - Data to be passed with event.
	 * @return {CustomEvent} Custom "odk-new-repeat" event (bubbling)
	 */
	function AddRepeat( detail ) {
	    return new CustomEvent( 'addrepeat', { detail, bubbles: true } );
	}

	/**
	 * Remove repeat event.
	 *
	 * @return {CustomEvent} Custom "removerepeat" event (bubbling)
	 */
	function RemoveRepeat() {
	    return new CustomEvent( 'removerepeat', { bubbles: true } );
	}

	/**
	 * Change language event.
	 *
	 * @return {CustomEvent} Custom "changelanguage" event (bubbling)
	 */
	function ChangeLanguage() {
	    return new CustomEvent( 'changelanguage', { bubbles: true } );
	}

	/**
	 * Change event.
	 *
	 * @return {Event} The regular HTML "change" event (bubbling)
	 */
	function Change() {
	    return new Event( 'change', { bubbles: true } );
	}

	/**
	 * Xforms-value-changed event as defined in the ODK XForms spec.
	 *
	 * @see https://getodk.github.io/xforms-spec/#event:xforms-value-changed
	 * @param {{repeatIndex: number}} detail - Data to be passed with event.
	 * @return {CustomEvent} Custom "xforms-value-changed" event (bubbling).
	 */
	function XFormsValueChanged( detail ) {
	    return new CustomEvent( 'xforms-value-changed', { detail, bubbles: true } );
	}

	/**
	 * Input event.
	 *
	 * @return {Event} "input" event (bubbling)
	 */
	function Input() {
	    return new Event( 'input', { bubbles: true } );
	}

	/**
	 * Input update event which fires when a form control value is updated programmatically.
	 *
	 * @return {CustomEvent} Custom "inputupdate" event (bubbling)
	 */
	function InputUpdate() {
	    return new CustomEvent( 'inputupdate', { bubbles: true } );
	}

	/**
	 * Edited event.
	 *
	 * @return {CustomEvent} Custom "edited" event (bubbling)
	 */
	function Edited() {
	    return new CustomEvent( 'edited', { bubbles: true } );
	}


	/**
	 * Before save event.
	 *
	 * @return {CustomEvent} Custom "edited" event (bubbling)
	 */
	function BeforeSave() {
	    return new CustomEvent( 'before-save', { bubbles: true } );
	}

	/**
	 * Validation complete event.
	 *
	 * @return {CustomEvent} Custom "validationcomplete" event (bubbling)
	 */
	function ValidationComplete() {
	    return new CustomEvent( 'validation-complete', { bubbles: true } );
	}

	/**
	 * Invalidated event.
	 *
	 * @return {CustomEvent} Custom "invalidated" event (bubbling)
	 */
	function Invalidated() {
	    return new CustomEvent( 'invalidated', { bubbles: true } );
	}

	/**
	 * Progress update event.
	 *
	 * @param {*} detail - Data to be passed with event
	 * @return {CustomEvent} Custom "progressupdate" event (bubbling)
	 */
	function ProgressUpdate( detail ) {
	    return new CustomEvent( 'progress-update', { detail, bubbles: true } );
	}

	/**
	 * Go to hidden event fired when the goto target is not relevant.
	 *
	 * @return {CustomEvent} Custom "gotoirrelevant" event (bubbling)
	 */
	function GoToIrrelevant() {
	    return new CustomEvent( 'goto-irrelevant', { bubbles: true } );
	}

	/**
	 * Go to invisible event fired when the target has no form control.
	 * This is event has prevalence of the "go to hidden" event.
	 *
	 * @return {CustomEvent} Custom "gotoinvisible" event (bubbling)
	 */
	function GoToInvisible() {
	    return new CustomEvent( 'goto-invisible', { bubbles: true } );
	}

	function ChangeOption() {
	    return new CustomEvent( 'change-option', { bubbles: true } );
	}

	/**
	 * Go to printify text event.
	 *
	 * @return {CustomEvent} Custom "printify" event (bubbling)
	 */
	function Printify() {
	    return new CustomEvent( 'printify', { bubbles: true } );
	}

	/**
	 * Go to deprintify text event.
	 *
	 * @return {CustomEvent} Custom "deprintify" event (bubbling)
	 */
	function DePrintify() {
	    return new CustomEvent( 'deprintify', { bubbles: true } );
	}

	function UpdateMaxSize() {
	    return new CustomEvent( 'update-max-size', { bubbles: true } );
	}

	var events = {
	    DataUpdate,
	    FakeFocus,
	    ApplyFocus,
	    PageFlip,
	    Removed,
	    InstanceFirstLoad,
	    NewRepeat,
	    AddRepeat,
	    RemoveRepeat,
	    ChangeLanguage,
	    Change,
	    Input,
	    InputUpdate,
	    Edited,
	    BeforeSave,
	    ValidationComplete,
	    Invalidated,
	    ProgressUpdate,
	    GoToIrrelevant,
	    GoToInvisible,
	    XFormsValueChanged,
	    ChangeOption,
	    Printify,
	    DePrintify,
	    UpdateMaxSize
	};

	/**
	 * @typedef NodesetFilter
	 * @property {boolean} onlyLeaf
	 * @property {boolean} noEmpty
	 */

	/**
	 * Class dealing with nodes and nodesets of the XML instance
	 *
	 * @class
	 * @param {string} [selector] - SimpleXPath or jQuery selector
	 * @param {number} [index] - The index of the target node with that selector
	 * @param {NodesetFilter} [filter] - Filter object for the result nodeset
	 * @param {FormModel} model - Instance of FormModel
	 */
	const Nodeset = function( selector, index, filter, model ) {
	    const defaultSelector = model.hasInstance ? '/model/instance[1]//*' : '//*';

	    this.model = model;
	    this.originalSelector = selector;
	    this.selector = ( typeof selector === 'string' && selector.length > 0 ) ? selector : defaultSelector;
	    filter = ( typeof filter !== 'undefined' && filter !== null ) ? filter : {};
	    this.filter = filter;
	    this.filter.onlyLeaf = ( typeof filter.onlyLeaf !== 'undefined' ) ? filter.onlyLeaf : false;
	    this.filter.noEmpty = ( typeof filter.noEmpty !== 'undefined' ) ? filter.noEmpty : false;
	    this.index = index;
	};

	/**
	 * @return {Element} Single node
	 */
	Nodeset.prototype.getElement = function() {
	    return this.getElements()[ 0 ];
	};

	/**
	 * @return {Array<Element>} List of nodes
	 */
	Nodeset.prototype.getElements = function() {
	    let nodes;
	    let /** @type {string} */ val;

	    // cache evaluation result
	    if ( !this._nodes ) {
	        this._nodes = this.model.evaluate( this.selector, 'nodes', null, null, true );
	        // noEmpty automatically excludes non-leaf nodes
	        if ( this.filter.noEmpty === true ) {
	            this._nodes = this._nodes
	                .filter( node => {
	                    val = node.textContent;

	                    return node.children.length === 0 && val.trim().length > 0;
	                } );
	        }
	        // this may still contain empty leaf nodes
	        else if ( this.filter.onlyLeaf === true ) {
	            this._nodes = this._nodes
	                .filter( node => node.children.length === 0 );
	        }
	    }

	    nodes = this._nodes;

	    if ( typeof this.index !== 'undefined' && this.index !== null ) {
	        nodes = typeof nodes[ this.index ] === 'undefined' ? [] : [ nodes[ this.index ] ];
	    }

	    return nodes;
	};

	/**
	 * Sets the index of the Nodeset instance
	 *
	 * @param {number} [index] - The 0-based index
	 */
	Nodeset.prototype.setIndex = function( index ) {
	    this.index = index;
	};

	/**
	 * Sets data node values.
	 *
	 * @param {(string|Array<string>)} [newVals] - The new value of the node.
	 * @param {string} [xmlDataType] - XML data type of the node
	 *
	 * @return {null|UpdatedDataNodes} `null` is returned when the node is not found or multiple nodes were selected,
	 *                       otherwise an object with update information is returned.
	 */
	Nodeset.prototype.setVal = function( newVals, xmlDataType ) {
	    let /**@type {string}*/ newVal;
	    let updated;
	    let customData;

	    const curVal = this.getVal();

	    if ( typeof newVals !== 'undefined' && newVals !== null ) {
	        newVal = ( Array.isArray( newVals ) ) ? newVals.join( ' ' ) : newVals.toString();
	    } else {
	        newVal = '';
	    }

	    newVal = this.convert( newVal, xmlDataType );
	    const targets = this.getElements();

	    if ( targets.length === 1 && newVal.toString() !== curVal.toString() ) {
	        const target = targets[ 0 ];
	        // first change the value so that it can be evaluated in XPath (validated)
	        target.textContent = newVal.toString();
	        // then return validation result
	        updated = this.getClosestRepeat();
	        updated.nodes = [ target.nodeName ];

	        customData = this.model.getUpdateEventData( target, xmlDataType );
	        updated = ( customData ) ? jquery.extend( {}, updated, customData ) : updated;

	        this.model.events.dispatchEvent( events.DataUpdate( updated ) );

	        //add type="file" attribute for file references
	        if ( xmlDataType === 'binary' ) {
	            if ( newVal.length > 0 ) {
	                target.setAttribute( 'type', 'file' );
	                // The src attribute if for default binary values (added by enketo-transformer)
	                // As soon as the value changes this attribute can be removed to clean up.
	                target.removeAttribute( 'src' );
	            } else {
	                target.removeAttribute( 'type' );
	            }
	        }

	        return updated;
	    }
	    if ( targets.length > 1 ) {
	        console.error( 'nodeset.setVal expected nodeset with one node, but received multiple' );

	        return null;
	    }
	    if ( targets.length === 0 ) {
	        console.warn( `Data node: ${this.selector} with null-based index: ${this.index} not found. Ignored.` );

	        return null;
	    }

	    return null;
	};

	/**
	 * Obtains the data value of the first node.
	 *
	 * @return {string|undefined} data value of first node or `undefined` if zero nodes
	 */
	Nodeset.prototype.getVal = function() {
	    const nodes = this.getElements();

	    return nodes.length ? nodes[ 0 ].textContent : undefined;
	};

	/**
	 * Note: If repeats have not been cloned yet, they are not considered a repeat by this function
	 *
	 * @return {{repeatPath: string, repeatIndex: number}|{}} Empty object for nothing found
	 */
	Nodeset.prototype.getClosestRepeat = function() {
	    let el = this.getElement();
	    let nodeName = el.nodeName;

	    while ( nodeName && nodeName !== 'instance' && !( el.nextElementSibling && el.nextElementSibling.nodeName === nodeName ) && !( el.previousElementSibling && el.previousElementSibling.nodeName === nodeName ) ) {
	        el = el.parentElement;
	        nodeName = el ? el.nodeName : null;
	    }

	    return ( !nodeName || nodeName === 'instance' ) ? {} : {
	        repeatPath: getXPath( el, 'instance' ),
	        repeatIndex: this.model.determineIndex( el )
	    };
	};

	/**
	 * Remove a repeat node
	 */
	Nodeset.prototype.remove = function() {
	    const dataNode = this.getElement();

	    if ( dataNode ) {
	        const nodeName = dataNode.nodeName;
	        const repeatPath = getXPath( dataNode, 'instance' );
	        let repeatIndex = this.model.determineIndex( dataNode );
	        const removalEventData = this.model.getRemovalEventData( dataNode );

	        if ( !this.model.templates[ repeatPath ] ) {
	            // This allows the model itseldataNodeout requiring the controller to call .extractFakeTemplates()
	            // to extract non-jr:templates by assuming that node.remove() would only called for a repeat.
	            this.model.extractFakeTemplates( [ repeatPath ] );
	        }
	        // warning: jQuery.next() to be avoided to support dots in the nodename
	        let nextNode = dataNode.nextElementSibling;

	        dataNode.remove();
	        this._nodes = null;

	        // For internal use
	        this.model.events.dispatchEvent( events.DataUpdate( {
	            nodes: null,
	            repeatPath,
	            repeatIndex
	        } ) );

	        // For all next sibling repeats to update formulas that use e.g. position(..)
	        // For internal use
	        while ( nextNode && nextNode.nodeName == nodeName ) {
	            nextNode = nextNode.nextElementSibling;

	            this.model.events.dispatchEvent( events.DataUpdate( {
	                nodes: null,
	                repeatPath,
	                repeatIndex: repeatIndex++
	            } ) );
	        }

	        // For external use, if required with custom data.
	        this.model.events.dispatchEvent( events.Removed( removalEventData ) );

	    } else {
	        console.error( `could not find node ${this.selector} with index ${this.index} to remove ` );
	    }
	};

	/**
	 * Convert a value to a specified data type (though always stringified)
	 *
	 * @param {string} [x] - Value to convert
	 * @param {string} [xmlDataType] - XML data type
	 * @return {string} - String representation of converted value
	 */
	Nodeset.prototype.convert = ( x, xmlDataType ) => {
	    if ( x.toString() === '' ) {
	        return x;
	    }
	    if ( typeof xmlDataType !== 'undefined' && xmlDataType !== null &&
	        typeof types[ xmlDataType.toLowerCase() ] !== 'undefined' &&
	        typeof types[ xmlDataType.toLowerCase() ].convert !== 'undefined' ) {
	        return types[ xmlDataType.toLowerCase() ].convert( x );
	    }

	    return x;
	};

	/**
	 * @param {string} constraintExpr - The XPath expression
	 * @param {string} requiredExpr - The XPath expression
	 * @param {string} xmlDataType - XML data type
	 * @return {Promise} promise that resolves with a ValidateInputResolution object
	 */
	Nodeset.prototype.validate = function( constraintExpr, requiredExpr, xmlDataType ) {
	    const that = this;
	    const result = {};

	    // Avoid checking constraint if required is invalid
	    return this.validateRequired( requiredExpr )
	        .then( passed => {
	            result.requiredValid = passed;

	            return ( passed === false ) ? null : that.validateConstraintAndType( constraintExpr, xmlDataType );
	        } )
	        .then( passed => {
	            result.constraintValid = passed;

	            return result;
	        } );
	};

	/**
	 * Validate a value with an XPath Expression and /or xml data type
	 *
	 * @param {string} [expr] - The XPath expression
	 * @param {string} [xmlDataType] - XML data type
	 * @return {Promise} wrapping a boolean indicating if the value is valid or not; error also indicates invalid field, or problem validating it
	 */
	Nodeset.prototype.validateConstraintAndType = function( expr, xmlDataType ) {
	    const that = this;
	    let value;

	    if ( !xmlDataType || typeof types[ xmlDataType.toLowerCase() ] === 'undefined' ) {
	        xmlDataType = 'string';
	    }

	    // This one weird trick results in a small validation performance increase.
	    // Do not obtain *the value* if the expr is empty and data type is string, select, select1, binary knowing that this will always return true.
	    if ( !expr && ( xmlDataType === 'string' || xmlDataType === 'select' || xmlDataType === 'select1' || xmlDataType === 'binary' ) ) {
	        return Promise.resolve( true );
	    }

	    value = that.getVal();

	    if ( value.toString() === '' ) {
	        return Promise.resolve( true );
	    }

	    return Promise.resolve()
	        .then( () => types[ xmlDataType.toLowerCase() ].validate( value ) )
	        .then( typeValid => {
	            if ( !typeValid ){
	                return false;
	            }
	            const exprValid = expr ? that.model.evaluate( expr, 'boolean', that.originalSelector, that.index ) : true;

	            return exprValid;
	        } );
	};

	// TODO: rename to isTrue?
	/**
	 * @param {string} [expr] - The XPath expression
	 * @return {boolean} Whether node is required
	 */
	Nodeset.prototype.isRequired = function( expr ) {
	    return !expr || expr.trim() === 'false()' ? false : expr.trim() === 'true()' || this.model.evaluate( expr, 'boolean', this.originalSelector, this.index );
	};

	/**
	 * Validates if requiredness is fulfilled.
	 *
	 * @param {string} [expr] - The XPath expression
	 * @return {Promise<boolean>} Promise that resolves with a boolean
	 */
	Nodeset.prototype.validateRequired = function( expr ) {
	    const that = this;

	    // if the node has a value or there is no required expression
	    if ( !expr || this.getVal() ) {
	        return Promise.resolve( true );
	    }

	    // if the node does not have a value and there is a required expression
	    return Promise.resolve()
	        .then( () => // if the expression evaluates to true, the field is required, and the function returns false.
	            !that.isRequired( expr ) );
	};

	// imported from https://github.com/enketo/enketo-xpathjs/blob/master/src/date-extensions.js
	// TODO probably shouldn't be changing Date.prototype - when these can be safely removed,
	// these functions would probably more appropriately be in utils/date.js

	/**
	 * Consistent with JavaRosa, the following should produce an empty string:
	 *
	 * - `date('')`
	 * - `format-date('')`
	 * - `format-date(date(''))`
	 *
	 * Conversions of `date('')` to a number is still invalid. This behavior
	 * deviates from JavaRosa by producing 'Invalid Date' rather than `NaN`,
	 * for consistency with historical behavior.
	 */
	class BlankDate$1 extends Date {
	  constructor() {
	    super(NaN);
	  }

	  toString() {
	    return '';
	  }
	}

	/**
	 * Converts a native Date UTC String to a RFC 3339-compliant date string with local offsets
	 * used in ODK, so it replaces the Z in the ISOstring with a local offset
	 * @param {Date} date
	 * @return {string} a datetime string formatted according to RC3339 with local offset
	 */
	const toISOLocalString$1 = (date) => {
	  //2012-09-05T12:57:00.000-04:00 (ODK)

	  if(['Invalid Date', ''].includes(date.toString())) {
	    return date.toString();
	  }

	  var dt = new Date(date.getTime() - (date.getTimezoneOffset() * 60 * 1000)).toISOString()
	      .replace('Z', getTimezoneOffsetAsTime$1(date));

	  if(dt.indexOf('T00:00:00.000') > 0) {
	    return dt.split('T')[0];
	  } else {
	    return dt;
	  }
	};

	/**
	 * @param {Date} date
	 * @return {string}
	 */
	const getTimezoneOffsetAsTime$1 = (date) => {
	  var offsetMinutesTotal;
	  var hours;
	  var minutes;
	  var direction;
	  var pad2 = function(x) {
	    return (x < 10) ? '0' + x : x;
	  };

	  if(date.toString() === 'Invalid Date') {
	    return date.toString();
	  }

	  offsetMinutesTotal = date.getTimezoneOffset();

	  direction = (offsetMinutesTotal < 0) ? '+' : '-';
	  hours = pad2(Math.floor(Math.abs(offsetMinutesTotal / 60)));
	  minutes = pad2(Math.floor(Math.abs(offsetMinutesTotal % 60)));

	  return direction + hours + ':' + minutes;
	};

	/**
	 * @deprecated
	 * @see {toISOLocalString}
	 */
	Date.prototype.toISOLocalString = function() {
	  return toISOLocalString$1(this);
	};

	/**
	 * @deprecated
	 * @see {getTimezoneOffsetAsTime}
	 */
	Date.prototype.getTimezoneOffsetAsTime = function() {
	  return getTimezoneOffsetAsTime$1(this);
	};

	var dateExtensions = {
	  BlankDate: BlankDate$1,
	  getTimezoneOffsetAsTime: getTimezoneOffsetAsTime$1,
	  toISOLocalString: toISOLocalString$1,
	};

	var DATE_STRING$2 = /^\d\d\d\d-\d{1,2}-\d{1,2}(?:T\d\d:\d\d:\d\d\.?\d?\d?(?:Z|[+-]\d\d:\d\d)|.*)?$/;

	function dateToDays$2(d) {
	  return d.getTime() / (1000 * 60 * 60 * 24);
	}

	function dateStringToDays$2(d) {
	  var temp = null;
	  if(d.indexOf('T') > 0) {
	    temp = new Date(d);
	  } else {
	    temp = d.split('-');
	    temp = new Date(temp[0], temp[1]-1, temp[2]);
	  }
	  return dateToDays$2(temp);
	}

	/**
	 * Get the number of days in any particular month
	 * @link https://stackoverflow.com/a/1433119/1293256
	 * @param  {integer} m The month (valid: 0-11)
	 * @param  {integer} y The year
	 * @return {integer}   The number of days in the month
	 */
	var daysInMonth = function (m, y) {
	  switch (m) {
	    case 1 :
	      return (y % 4 == 0 && y % 100) || y % 400 == 0 ? 29 : 28;
	    case 8 : case 3 : case 5 : case 10 :
	      return 30;
	    default :
	      return 31;
	  }
	};

	/**
	 * Check if a date is valid
	 * @link https://stackoverflow.com/a/1433119/1293256
	 * @param  {[type]}  y The year
	 * @param  {[type]}  m The month
	 * @param  {[type]}  d The day
	 * @return {Boolean}   Returns true if valid
	 */
	var isValidDate$1 = function (y, m, d) {
	  m = parseInt(m, 10) - 1;
	  return m >= 0 && m < 12 && d > 0 && d <= daysInMonth(m, y);
	};

	var date = {
	  DATE_STRING: DATE_STRING$2,
	  dateToDays: dateToDays$2,
	  dateStringToDays: dateStringToDays$2,
	  isValidDate: isValidDate$1
	};

	const { DATE_STRING: DATE_STRING$1, dateToDays: dateToDays$1, dateStringToDays: dateStringToDays$1 } = date;
	const { toISOLocalString } = dateExtensions;

	var xpathCast = {
	  asBoolean: asBoolean$5,
	  asNumber: asNumber$6,
	  asString: asString$7,
	};

	// cast to boolean, as per https://www.w3.org/TR/1999/REC-xpath-19991116/#section-Boolean-Functions
	function asBoolean$5(r) {
	  if(isDomNode(r)) return !!asString$7(r).trim();
	  switch(r.t) {
	    case 'arr':  return !!r.v.length;
	    case 'date': return !isNaN(r.v); // TODO should be handled in an extension rather than core code
	    default:     return !!r.v;
	  }
	}

	// cast to number, as per https://www.w3.org/TR/1999/REC-xpath-19991116/#section-Number-Functions
	function asNumber$6(r) {
	  if(r.t === 'num')  return r.v;
	  if(r.t === 'bool') return r.v ? 1 : 0;
	  if(r.t === 'date') return dateToDays$1(r.v); // TODO should be handled in an extension rather than core code

	  const str = asString$7(r).trim();
	  if(str === '') return NaN;
	  if(DATE_STRING$1.test(str)) return dateStringToDays$1(str); // TODO should be handled in an extension rather than core code
	  return +str;
	}

	// cast to string, as per https://www.w3.org/TR/1999/REC-xpath-19991116/#section-String-Functions
	function asString$7(r) {
	  if(isDomNode(r)) return nodeToString(r);
	  switch(r.t) {
	    case 'str':  return r.v;
	    case 'arr':  return r.v.length ? r.v[0].textContent || '' : '';
	    case 'date': return toISOLocalString(r.v).replace(/T00:00:00.000.*/, ''); // TODO should be handled in an extension rather than core code
	    case 'num':
	    case 'bool':
	    default:     return r.v.toString();
	  }
	}

	// Per https://www.w3.org/TR/1999/REC-xpath-19991116/#dt-string-value:
	// 1. > The string-value of the root node is the concatenation of the string-values of all text node descendants of the root node in document order.
	// 2. > The string-value of an element node is the concatenation of the string-values of all text node descendants of the element node in document order.
	// 3. > An attribute node has a string-value. The string-value is the normalized value as specified by the XML Recommendation [XML]. An attribute whose normalized value is a zero-length string is not treated specially: it results in an attribute node whose string-value is a zero-length string.
	// 4. > The string-value of a namespace node is the namespace URI that is being bound to the namespace prefix; if it is relative, it must be resolved just like a namespace URI in an expanded-name.
	// 5. > The string-value of a processing instruction node is the part of the processing instruction following the target and any whitespace.
	// 6. > The string-value of comment is the content of the comment not including the opening <!-- or the closing -->.
	// 7. > The string-value of a text node is the character data.
	function nodeToString(node) {
	  switch(node.nodeType) {
	    case Node.DOCUMENT_NODE: return node.documentElement.textContent;
	    case Node.TEXT_NODE:
	    case Node.CDATA_SECTION_NODE:
	    case Node.PROCESSING_INSTRUCTION_NODE:
	    case Node.COMMENT_NODE:
	    case Node.ELEMENT_NODE:
	      return node.textContent; // potentially not to spec for Element, but much simpler than recursing
	    case Node.ATTRIBUTE_NODE: return node.value;
	    default: throw new Error(`TODO No handling for node type: ${node.nodeType}`);
	  }
	}

	/**
	 * Check if an object is a DOM Node, or one of its subtypes (e.g. Element).
	 * @see https://developer.mozilla.org/en-US/docs/Web/API/Node
	 */
	function isDomNode(thing) {
	  return thing instanceof Node;
	}

	var { asBoolean: asBoolean$4, asNumber: asNumber$5, asString: asString$6 } = xpathCast;

	var operation = {
	  handleOperation:handleOperation$1,
	};

	// Operator constants copied from extended-xpath.js
	const OR$1    = 0b00000;
	const AND$1   = 0b00100;
	const EQ$2    = 0b01000;
	const NE$1    = 0b01001;
	const LT$1    = 0b01100;
	const LTE$1   = 0b01101;
	const GT$1    = 0b01110;
	const GTE$2   = 0b01111;
	const PLUS$2  = 0b10000;
	const MINUS$2 = 0b10001;
	const MULT$1  = 0b10100;
	const DIV$1   = 0b10101;
	const MOD$1   = 0b10110;
	const UNION$1 = 0b11000;

	function handleOperation$1(lhs, op, rhs) {
	  // comparison operators as per: https://www.w3.org/TR/1999/REC-xpath-19991116/#booleans
	  switch(op) {
	    case OR$1:    return asBoolean$4(lhs) || asBoolean$4(rhs);
	    case AND$1:   return asBoolean$4(lhs) && asBoolean$4(rhs);
	    case EQ$2:    return equalityCompare(lhs, rhs, (a, b) => a === b);
	    case NE$1:    return equalityCompare(lhs, rhs, (a, b) => a !== b);
	    case LT$1:    return relationalCompare(lhs, rhs, (a, b) => a <  b);
	    case LTE$1:   return relationalCompare(lhs, rhs, (a, b) => a <= b);
	    case GT$1:    return relationalCompare(lhs, rhs, (a, b) => a >  b);
	    case GTE$2:   return relationalCompare(lhs, rhs, (a, b) => a >= b);

	    case PLUS$2:  return asNumber$5(lhs) + asNumber$5(rhs);
	    case MINUS$2: return asNumber$5(lhs) - asNumber$5(rhs);
	    case MULT$1:  return asNumber$5(lhs) * asNumber$5(rhs);
	    case DIV$1:   return asNumber$5(lhs) / asNumber$5(rhs);
	    case MOD$1:   return asNumber$5(lhs) % asNumber$5(rhs);

	    case UNION$1: return [...lhs.v, ...rhs.v];
	    default: throw new Error(`No handling for op ${op}`);
	  }
	}

	function bothOf(lhs, rhs, t) {
	  return lhs.t === t && rhs.t === t;
	}

	function oneOf(lhs, rhs, t) {
	  return lhs.t === t || rhs.t === t;
	}

	function castFor(r) {
	  switch(r.t) {
	    case 'num': return asNumber$5;
	    case 'str': return asString$6;
	    default: throw new Error(`No cast for type: ${r.t}`);
	  }
	}


	function relationalCompare(lhs, rhs, compareFn) {
	  var i, j;
	  if(bothOf(lhs, rhs, 'arr' )) {
	    for(i=lhs.v.length-1; i>=0; --i) {
	      for(j=rhs.v.length-1; j>=0; --j) {
	        if(compareFn(asNumber$5(lhs.v[i]), asNumber$5(rhs.v[j]))) return true;
	      }
	    }
	    return false;
	  }
	  if(lhs.t === 'arr') {
	    rhs = asNumber$5(rhs);
	    return lhs.v.map(asNumber$5).some(v => compareFn(v, rhs));
	  }
	  if(rhs.t === 'arr') {
	    lhs = asNumber$5(lhs);
	    return rhs.v.map(asNumber$5).some(v => compareFn(lhs, v));
	  }
	  return compareFn(asNumber$5(lhs), asNumber$5(rhs));
	}

	function equalityCompare(lhs, rhs, compareFn) {
	  var i, j;
	  if(bothOf(lhs, rhs, 'arr' )) {
	    for(i=lhs.v.length-1; i>=0; --i) {
	      for(j=rhs.v.length-1; j>=0; --j) {
	        if(compareFn(lhs.v[i].textContent, rhs.v[j].textContent)) return true;
	      }
	    }
	    return false;
	  }
	  if(oneOf(lhs, rhs, 'bool')) return compareFn(asBoolean$4(lhs), asBoolean$4(rhs));
	  if(lhs.t === 'arr') {
	    const cast = castFor(rhs);
	    rhs = cast(rhs);
	    return lhs.v.map(cast).some(v => compareFn(v, rhs));
	  }
	  if(rhs.t === 'arr') {
	    const cast = castFor(lhs);
	    lhs = cast(lhs);
	    return rhs.v.map(cast).some(v => compareFn(v, lhs));
	  }
	  if(oneOf(lhs, rhs, 'num')) return compareFn(asNumber$5(lhs), asNumber$5(rhs));
	  if(oneOf(lhs, rhs, 'str')) return compareFn(asString$6(lhs), asString$6(rhs));
	  throw new Error('not handled yet for these types: ' + compareFn.toString());
	}

	/**
	 * Internal representations of XPathResults
	 */
	var xpr = {
	  boolean: v => ({ t:'bool', v }),
	  number:  v => ({ t:'num',  v }),
	  string:  v => ({ t:'str',  v }),
	  date:    v => ({ t:'date', v }),
	};
	xpr.number;
	xpr.string;
	xpr.date;

	const { asNumber: asNumber$4, asString: asString$5 } = xpathCast;


	var native_1 = { preprocessNativeArgs: preprocessNativeArgs$1 };

	const cast$1 = { num:asNumber$4, str:asString$5 };

	const fns = {
	  'ceiling':          { min:1, max:1, cast:['num'] },
	  'contains':         { min:2, max:2, cast:['str', 'str'] },
	  'floor':            { min:1, max:1, cast:['num'] },
	  'id':               { min:1, max:1, conv:r => [ xpr.string(r.t === 'arr' ? r.v.map(asString$5).join(' ') : asString$5(r)) ] },
	  'lang':             { min:1, max:1, cast:['str'] },
	  'starts-with':      { min:2, max:2, cast:['str', 'str'] },
	  'substring':        { min:2, max:3, conv:convertSubstringArgs },
	  'substring-after':  { min:2, max:2, cast:['str', 'str'] },
	  'substring-before': { min:2, max:2, cast:['str', 'str'] },
	  'translate':        { min:3, max:3, cast:['str', 'str', 'str'] },
	};

	function preprocessNativeArgs$1(name, args) {
	  const def = fns[name];
	  if(!def) return args;
	  if(args.length < def.min) throw new Error('too few args');
	  if(args.length > def.max) throw new Error('too many args');
	  if(def.conv) {
	    return def.conv(...args);
	  } else if(def.cast) {
	    return args
	      .map((v, i) => {
	        const t = def.cast[i];
	        return { t, v:cast$1[t](v) };
	      });
	  }
	  return args;
	}

	function convertSubstringArgs(str, start, len) {
	  // special cases explicitly defined in the spec
	  //
	  // - substring("12345",      1.5,     2.6) returns "234"
	  // - substring("12345",        0,       3) returns "12"
	  // - substring("12345",  0 div 0,       3) returns ""
	  // - substring("12345",        1, 0 div 0) returns ""
	  // - substring("12345",      -42, 1 div 0) returns "12345"
	  // - substring("12345", -1 div 0, 1 div 0) returns ""
	  //
	  // see: https://www.w3.org/TR/1999/REC-xpath-19991116/#function-substring
	  //
	  // Try digesting this:
	  //
	  // > The returned substring contains those characters for which the position
	  // > of the character is greater than or equal to the rounded value of the
	  // > second argument and, if the third argument is specified, less than the
	  // > sum of the rounded value of the second argument and the rounded value
	  // > of the third argument.
	  //
	  // The apparent contradictory nature of the final two examples hinges on
	  // IEEE 754-1985 section 7.1 "Invalid Operation" which states:
	  //
	  // > The invalid operation exception is signaled if an operand is invalid
	  // > for the operation on to be performed.  The result, when the exception
	  // > occurs without a trap, shall be a quiet NaN...
	  // > ...
	  // > 2) Addition or subtraction—magnitude subtraction of infinites such as, (+∞) + (−∞)
	  //
	  // Firefox and Chrome XPath implementations agree that
	  // (Infinity + -Infinity) evaluates to NaN.
	  //
	  // And here's an extra special example not defined in the spec:
	  //
	  // - substring("12345", -1 div 0)
	  //
	  // IEEE 754-1985 section 6.1 "Infinity Arithmetic" states:
	  //
	  // > Infinites shall be interpreted in the affine sense, that is,
	  // > −∞ < (every finite number) < +∞
	  //
	  // By my reading, this means substring("12345", -1 div 0) should return
	  // "12345".  Firefox and Chrome XPath implementations disagree with this,
	  // but here we have special handling for it:

	  str = xpr.string(asString$5(str));
	  start = asNumber$4(start);
	  if(len === undefined) {
	    return [ str, xpr.number(Math.max(0, start)) ];
	  }

	  return [ str, xpr.number(start), xpr.number(asNumber$4(len)) ];
	}

	var sortByDocumentOrder = function(ir) {
	  if(ir.ordrd) return;
	  ir.v.sort(byDocumentOrder);
	};

	function byDocumentOrder(a, b) {
	  var compare = a.compareDocumentPosition(b);
	  if(compare & Node.DOCUMENT_POSITION_PRECEDING) {
	    return 1;
	  }
	  if(compare & Node.DOCUMENT_POSITION_FOLLOWING) {
	    return -1;
	  }
	  return 0;
	}

	var result = { toSnapshotResult: toSnapshotResult$1 };

	function toSnapshotResult$1(arr, resultType, singleItem) {
	  if( resultType === XPathResult.ORDERED_NODE_ITERATOR_TYPE ||
	      resultType === XPathResult.ORDERED_NODE_SNAPSHOT_TYPE) {
	    sortByDocumentOrder(arr);
	  }

	  return (nodes => {
	    let idx = 0;
	    return {
	      resultType,
	      singleNodeValue: singleItem || nodes[0] || null,
	      snapshotLength: nodes.length,
	      snapshotItem: i => nodes[i] || null,
	      iterateNext: () => nodes[idx++] || null,
	    };
	  })(arr.v);
	}

	const { handleOperation } = operation;
	const { preprocessNativeArgs } = native_1;
	const { toSnapshotResult } = result;
	const { asBoolean: asBoolean$3, asNumber: asNumber$3, asString: asString$4 } = xpathCast;
	/*
	 * From http://www.w3.org/TR/xpath/#section-Expressions XPath infix operator
	 * precedence is left-associative.  In the constants that follow, all but the
	 * bottom two bits indicate precedence, and the entire value represents the
	 * unique ID of the operator.
	 *
	 * These values are defined here rather than imported in an object so that they
	 * can be inlined.  Copy/paste the definitions into other files where they are
	 * used.
	 */
	const OR    = 0b00000;
	// --- precedence group separator
	const AND   = 0b00100;
	// --- precedence group separator
	const EQ$1    = 0b01000;
	const NE    = 0b01001;
	// --- precedence group separator
	const LT    = 0b01100;
	const LTE   = 0b01101;
	const GT    = 0b01110;
	const GTE$1   = 0b01111;
	// --- precedence group separator
	const PLUS$1  = 0b10000;
	const MINUS$1 = 0b10001;
	// --- precedence group separator
	const MULT  = 0b10100;
	const DIV   = 0b10101;
	const MOD   = 0b10110;
	// --- precedence group separator
	const UNION = 0b11000;
	// --- end operators

	const FUNCTION_NAME = /^[a-z]/;
	const D$1 = 0xDEAD; // dead-end marker for the unevaluated side of a lazy expression

	var extendedXpath = function(wrapped, extensions) {
	  const
	    extendedFuncs = extensions.func || {},
	    extendedProcessors = extensions.process || {},
	    toInternalResult = function(r) {
	      let v, i, ordrd;
	      switch(r.resultType) {
	        case XPathResult.NUMBER_TYPE:  return { t:'num',  v:r.numberValue  };
	        case XPathResult.BOOLEAN_TYPE: return { t:'bool', v:r.booleanValue };
	        case XPathResult.STRING_TYPE:  return { t:'str',  v:r.stringValue  };
	        case XPathResult.ORDERED_NODE_ITERATOR_TYPE:
	          ordrd = true;
	          /* falls through */
	        case XPathResult.UNORDERED_NODE_ITERATOR_TYPE:
	          v = [];
	          while((i = r.iterateNext())) v.push(i);
	          return { t:'arr', v, ordrd };
	        case XPathResult.ORDERED_NODE_SNAPSHOT_TYPE:
	          ordrd = true;
	          /* falls through */
	        case XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE:
	          v = [];
	          for(i=0; i<r.snapshotLength; ++i) {
	            v.push(r.snapshotItem(i));
	          }
	          return { t:'arr', v, ordrd };
	        case XPathResult.ANY_UNORDERED_NODE_TYPE:
	        case XPathResult.FIRST_ORDERED_NODE_TYPE:
	          return { t:'arr', v:[r.singleNodeValue] };
	        default:
	          throw new Error(`no handling for result type: ${r.resultType}`);
	      }
	    },
	    toExternalResult = function(r, rt) {
	      if(extendedProcessors.toExternalResult) {
	        const res = extendedProcessors.toExternalResult(r, rt);
	        if(res) return res;
	      }

	      switch(rt) {
	        case null:
	        case undefined:
	        case XPathResult.ANY_TYPE:
	          // derive return type from the return value
	          switch(r.t) {
	            case 'num':  return toExternalResult(r, XPathResult.NUMBER_TYPE);
	            case 'str':  return toExternalResult(r, XPathResult.STRING_TYPE);
	            case 'bool': return toExternalResult(r, XPathResult.BOOLEAN_TYPE);
	            case 'arr':  return toExternalResult(r, XPathResult.UNORDERED_NODE_ITERATOR_TYPE);
	            default: throw new Error('unrecognised internal type: ' + r.t);
	          }
	        case XPathResult.NUMBER_TYPE:  return { resultType:rt, stringValue:asString$4(r), numberValue:asNumber$3(r) };
	        case XPathResult.STRING_TYPE:  return { resultType:rt, stringValue:asString$4(r) };
	        case XPathResult.BOOLEAN_TYPE: return { resultType:rt, stringValue:asString$4(r), booleanValue:asBoolean$3(r) };
	        case XPathResult.UNORDERED_NODE_ITERATOR_TYPE:
	        case XPathResult.ORDERED_NODE_ITERATOR_TYPE:
	        case XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE:
	        case XPathResult.ORDERED_NODE_SNAPSHOT_TYPE:
	          r.ordrd = true;   // smap - preserve ordering from randomise
	        case XPathResult.ANY_UNORDERED_NODE_TYPE:
	        case XPathResult.FIRST_ORDERED_NODE_TYPE:
	          return toSnapshotResult(r, rt);
	        default: throw new Error('unrecognised return type:', rt);
	      }
	    },
	    typefor = function(val) {
	      if(extendedProcessors.typefor) {
	        const res = extendedProcessors.typefor(val);
	        if(res) return res;
	      }
	      if(typeof val === 'boolean') return 'bool';
	      if(typeof val === 'number')  return 'num';
	      return 'str';
	    };

	  /**
	   * @type {typeof document.evaluate}
	   * @see https://developer.mozilla.org/en-US/docs/Web/API/Document/evaluate
	   */
	  const evaluate = this.evaluate = function(input, cN, nR, rT, _, contextSize=1, contextPosition=1) {
	    let i, cur;
	    const stack = [{ t:'root', tokens:[] }],
	      peek = () => stack[stack.length-1],
	      pushToken = t => {
	        const { tokens } = peek();
	        if(prevToken() !== D$1 || t !== D$1) tokens.push(t);
	      },
	      isDeadBranch = () => {
	        const { dead, t, tokens } = peek();
	        if(dead) return true;
	        if(t === 'fn') {
	          return prevToken() === D$1;
	        } else {
	          return tokens.includes(D$1);
	        }
	      },
	      err = m => { throw new Error((m||'') + JSON.stringify({ stack, cur })); },
	      newCurrent = function() { cur = { v:'' }; },
	      pushOp = function(t) {
	        if(t <= AND) {
	          evalOps(t);
	        }

	        pushToken({ t:'op', v:t });

	        if(t <= AND) {
	          const { tokens } = peek();
	          const prev = asBoolean$3(tokens[tokens.length-2]);
	          if(t === OR ? prev : !prev) pushToken(D$1);
	        }

	        newCurrent();
	      },
	      callFn = function(name, supplied) {
	        // Every second arg should be a comma, but we allow for a trailing comma.
	        // From the spec, this looks valid, if you assume that ExprWhitespace is a
	        // valid Expr.
	        // see: https://www.w3.org/TR/1999/REC-xpath-19991116/#section-Function-Calls
	        const args = [];
	        for(let i=0; i<supplied.length; ++i) {
	          if(i % 2) {
	            if(supplied[i] !== ',') throw new Error('Weird args (should be separated by commas):' + JSON.stringify(supplied));
	          } else args.push(supplied[i]);
	        }

	        if(Object.prototype.hasOwnProperty.call(extendedFuncs, name)) {
	          return extendedFuncs[name].apply({ cN, contextSize, contextPosition }, args);
	        }

	        return callNative(name, preprocessNativeArgs(name, args));
	      },
	      callNative = function(name, args) {
	        let argString = name + '(';
	        for(let i=0; i<args.length; ++i) {
	          if(i) argString += ',';
	          const arg = args[i];
	          switch(arg.t) {
	            case 'arr': throw new Error(`callNative() can't handle nodeset functions yet for ${name}()`);
	            case 'bool': argString += arg.v + '()'; break;
	            case 'num':
	              if     (arg.v ===  Infinity) argString += '( 1 div 0)';
	              else if(arg.v === -Infinity) argString += '(-1 div 0)';
	              else                         argString += arg.v.toFixed(20); // Prevent JS from converting to scientific notation
	              break;
	            case 'str': {
	              const quote = arg.quote || (arg.v.indexOf('"') === -1 ? '"' : "'");
	              // Firefox's native XPath implementation is 3.0, but Chrome's is 1.0.
	              // XPath 1.0 has no support for escaping quotes in strings, so:
	              if(arg.v.indexOf(quote) !== -1) throw new Error('Quote character found in String Literal: ' + JSON.stringify(arg.v));
	              argString += quote + arg.v + quote;
	            }
	            // there aren't any other native types TODO do we need a hook for allowing date conversion?
	          }
	        }
	        return toInternalResult(wrapped.evaluate(argString + ')', cN, nR, XPathResult.ANY_TYPE, null));
	      },
	      evalOp = function(lhs, op, rhs) {
	        if(op > AND && (lhs === D$1 || rhs === D$1)) {
	          return D$1;
	        }
	        if(extendedProcessors.handleInfix) {
	          let res = extendedProcessors.handleInfix(err, lhs, op, rhs);
	          if(res && res.t === 'continue') {
	            lhs = res.lhs; op = res.op; rhs = res.rhs; res = null;
	          }

	          if(typeof res !== 'undefined' && res !== null) return res;
	        }
	        return handleOperation(lhs, op, rhs);
	      },
	      evalOps = function(lastOp) {
	        const { tokens } = peek();

	        if(tokens.length < 2) return;

	        if(tokens[2] === D$1 && tokens[1].v >= lastOp) {
	          const endExpr = tokens.indexOf(',', 2);
	          tokens.splice(0, endExpr === -1 ? tokens.length : endExpr, { t:'bool', v:asBoolean$3(tokens[0]) });
	        }

	        for(let j=UNION; j>=lastOp; j-=0b100) {
	          let i = 1;
	          while(i < tokens.length-1) {
	            if(tokens[i].t === 'op' && tokens[i].v >= j) {
	              const res = evalOp(tokens[i-1], tokens[i].v, tokens[i+1]);
	              tokens.splice(i, 2);
	              tokens[i-1] = { t:typefor(res), v:res };
	            } else ++i;
	          }
	        }
	      },
	      handleXpathExpr = function() {
	        if(isDeadBranch()) {
	          newCurrent();
	          return;
	        }
	        let expr = cur.v;
	        const prev = prevToken();
	        if(prev && prev.t === 'arr') {
	          // chop the leading slash from expr
	          if(expr.charAt(0) !== '/') err(`not sure how to handle expression called on nodeset that doesn't start with a '/': ${expr}`);
	          // prefix a '.' to make the expression relative to the context node:
	          expr = wrapped.createExpression('.' + expr, nR);
	          const newNodeset = [];
	          prev.v.forEach(node => {
	            const res = toInternalResult(expr.evaluate(node));
	            newNodeset.push(...res.v);
	          });
	          prev.v = newNodeset;
	        } else {
	          // This addresses a bug in Chrome and Safari, where an absolute
	          // nodeset expression evaluated with an attribute contex node
	          // does not evaluate to that nodeset as expected. Using the
	          // attribute's owner document evaluates the expression correctly,
	          // ensuring consistent behavior between Chrome, Safari and Firefox.
	          const contextNode = (
	            cN?.nodeType === Node.ATTRIBUTE_NODE && expr.startsWith('/')
	              ? cN.ownerDocument
	              : cN
	          );

	          pushToken(toInternalResult(wrapped.evaluate(expr, contextNode, nR, XPathResult.ANY_TYPE, null)));
	        }

	        newCurrent();
	      },
	      nextChar = function() {
	        return input.charAt(i+1);
	      },
	      finaliseNum = function() {
	        cur.v = parseFloat(cur.str);
	        pushToken(cur);
	        newCurrent();
	      },
	      prevToken = function() {
	        const peeked = peek().tokens;
	        return peeked[peeked.length - 1];
	      },
	      isNum = function(c) {
	        return c >= '0' && c <= '9';
	      };

	    newCurrent();

	    for(i=0; i<input.length; ++i) {
	      const c = input.charAt(i);
	      if(cur.t === 'sq') {
	        // Build the entire expression found within the square brackets:
	        //
	        // > A predicate filters a node-set with respect to an axis to produce a
	        // > new node-set. For each node in the node-set to be filtered, the
	        // > PredicateExpr is evaluated with that node as the context node, with
	        // > the number of nodes in the node-set as the context size, and with
	        // > the proximity position of the node in the node-set with respect to
	        // > the axis as the context position; if PredicateExpr evaluates to
	        // > true for that node, the node is included in the new node-set;
	        // > otherwise, it is not included.
	        //   - https://www.w3.org/TR/1999/REC-xpath-19991116/#predicates
	        //
	        // Note because the ']' character is allowed within a Literal (string),
	        // there is special handling for tracking when we're within a string.
	        if(cur.inString) {
	          if(cur.inString === c) delete cur.inString;
	        } else if(c === '[') {
	          ++cur.depth;
	        } else if(c === '\'' || c === '"') {
	          cur.inString = c;
	        } else if(c === ']') {
	          if(--cur.depth) {
	            cur.v += c;
	          } else {
	            if(isDeadBranch()) {
	              newCurrent();
	              continue;
	            }
	            let contextNodes;
	            const prev = prevToken();
	            if(prev.t === 'arr') {
	              contextNodes = prev.v;
	            } else throw new Error('Not sure how to handle context node for predicate in this situation.');

	            // > A PredicateExpr is evaluated by evaluating the Expr and converting
	            // > the result to a boolean. If the result is a number, the result will
	            // > be converted to true if the number is equal to the context position
	            // > and will be converted to false otherwise; if the result is not a
	            // > number, then the result will be converted as if by a call to the
	            // > boolean function. Thus a location path para[3] is equivalent to
	            // > para[position()=3].
	            //   - https://www.w3.org/TR/1999/REC-xpath-19991116/#predicates
	            const expr = cur.v;
	            const filteredNodes = contextNodes
	              .filter((cN, i) => {
	                const res = toInternalResult(evaluate(expr, cN, nR, XPathResult.ANY_TYPE, null, contextNodes.length, i+1));
	                return res.t === 'num' ? asNumber$3(res) === 1+i : asBoolean$3(res);
	              });

	            prev.v = filteredNodes;
	            newCurrent();
	          }
	          continue;
	        }
	        cur.v += c;
	        continue;
	      }
	      if(cur.t === 'str') {
	        if(c === cur.quote) {
	          pushToken(cur);
	          newCurrent();
	        } else cur.v += c;
	        continue;
	      }
	      if(cur.t === 'num') {
	        if(isNum(c) || c === 'e' ||
	            (c === '-' && input[i-1] === 'e')) {
	          cur.str += c;
	          continue;
	        } else if(c === ' ' && cur.str === '-') {
	          continue;
	        } else if(c === '.' && !cur.decimal) {
	          cur.decimal = 1;
	          cur.str += c;
	        } else finaliseNum();
	      }
	      if(isNum(c)) {
	        if(cur.v === '') {
	          cur = { t:'num', str:c };
	        } else cur.v += c;
	      } else switch(c) {
	        case "'":
	        case '"':
	          if(cur.v === '') {
	            cur = { t:'str', quote:c, v:'' };
	          } else err('Not sure how to handle: ' + c);
	          break;
	        case '(':
	          stack.push({ v:cur.v, t:'fn', dead:isDeadBranch(), tokens:[] });
	          newCurrent();
	          break;
	        case ')':
	          if(cur.v !== '') handleXpathExpr();
	          evalOps(OR);
	          cur = stack.pop();

	          if(cur.t !== 'fn') err('")" outside function!');
	          if(cur.dead) {
	            pushToken(D$1);
	          } else if(cur.v) {
	            if(cur.v.charAt(0) === '/') {
	              if(cur.tokens.length) err('Unexpected args for node test function!');
	              cur.v += '()';
	              handleXpathExpr();
	            } else {
	              pushToken(callFn(cur.v, cur.tokens));
	            }
	          } else { // bracketed expression
	            if(cur.tokens.length !== 1) err('Expected one token, but found: ' + cur.tokens.length);
	            pushToken(cur.tokens[0]);
	          }
	          newCurrent();
	          break;
	        case ',':
	          if(peek().t !== 'fn') err('Unexpected comma outside function arguments.');
	          if(cur.v) handleXpathExpr();
	          pushToken(',');
	          break;
	        case '*': {
	          // check if part of an XPath expression
	          const prev = prevToken();
	          if(!prev || prev === ',' || prev.t === 'op' || cur.v) {
	            cur.v += c;
	            break;
	          }
	          pushOp(MULT);
	        } break;
	        case '-': {
	          const prev = prevToken();
	          if(cur.v !== '' && nextChar() !== ' ' && input.charAt(i-1) !== ' ') {
	            // function name expr
	            cur.v += c;
	          } else if(cur.v === '' && (
	              !prev ||
	              // match case: ...+-1
	              prev.t === 'op' ||
	              // previous was a separate function arg
	              prev === ',')) {
	            // -ve number
	            cur = { t:'num', str:'-' };
	          } else {
	            // TODO do we need to check for cur.v here?
	            pushOp(MINUS$1);
	          }
	        } break;
	        case '=':
	          switch(cur.v) {
	            case '<': pushOp(LTE); break;
	            case '>': pushOp(GTE$1); break;
	            case '!': pushOp(NE);  break;
	            default:
	              if(cur.v) handleXpathExpr();
	              pushOp(EQ$1);
	          }
	          break;
	        case '!':
	          if(cur.v) handleXpathExpr();
	          cur.v = c;
	          break;
	        case '>':
	        case '<':
	          if(cur.v) handleXpathExpr();
	          if(nextChar() === '=') {
	            cur.v = c;
	          } else {
	            pushOp(c === '>' ? GT : LT);
	          }
	          break;
	        case '+':
	          if(cur.v) handleXpathExpr();
	          pushOp(PLUS$1);
	          break;
	        case '|':
	          if(cur.v) handleXpathExpr();
	          pushOp(UNION);
	          break;
	        case '\n':
	        case '\r':
	        case '\t':
	        case ' ':
	          // whitespace, as defined at https://www.w3.org/TR/REC-xml/#NT-S
	          if(cur.v === '') break; // trim leading whitespace
	          if(!FUNCTION_NAME.test(cur.v)) handleXpathExpr();
	          break;
	        case 'v':
	          // Mad as it seems, according to https://www.w3.org/TR/1999/REC-xpath-19991116/#exprlex,
	          // there is no requirement for ExprWhitespace before or after any
	          // ExprToken, including OperatorName.
	          if(cur.v === 'di') { // OperatorName: 'div'
	            pushOp(DIV);
	          } else cur.v += c;
	          break;
	        case 'r':
	          // Mad as it seems, according to https://www.w3.org/TR/1999/REC-xpath-19991116/#exprlex,
	          // there is no requirement for ExprWhitespace before or after any
	          // ExprToken, including OperatorName.
	          if(cur.v === 'o') { // OperatorName: 'or'
	            pushOp(OR);
	          } else cur.v += c;
	          break;
	        case 'd':
	          // Mad as it seems, according to https://www.w3.org/TR/1999/REC-xpath-19991116/#exprlex,
	          // there is no requirement for ExprWhitespace before or after any
	          // ExprToken, including OperatorName.
	          if(cur.v === 'an') { // OperatorName: 'and'
	            pushOp(AND);
	          } else if(cur.v === 'mo') { // OperatorName: 'mod'
	            pushOp(MOD);
	          } else cur.v += c;
	          break;
	        case '[':
	          // evaluate previous part if there is any
	          if(cur.v) {
	            handleXpathExpr();
	            newCurrent();
	          }
	          cur.t = 'sq';
	          cur.depth = 1;
	          break;
	        case '.':
	          if(cur.v === '' && isNum(nextChar())) {
	            cur = { t:'num', str:c };
	            break;
	          }
	          /* falls through */
	        default:
	          cur.v += c;
	      }
	    }

	    if(cur.t === 'num') finaliseNum();
	    if(cur.v) handleXpathExpr();
	    if(stack.length !== 1) err('Stuff left on stack.');
	    if(stack[0].t !== 'root') err('Weird stuff on stack.');
	    if(stack[0].tokens.length === 0) err('No tokens.');
	    evalOps(OR);
	    if(stack[0].tokens.length !== 1) err('Too many tokens.');

	    return toExternalResult(stack[0].tokens[0], rT);
	  };
	};

	var EARTH_EQUATORIAL_RADIUS_METERS = 6378100;
	var PRECISION = 100;

	var { asString: asString$3 } = xpathCast;

	function _toLatLngs(geopoints) {
	  return geopoints.map(function (geopoint) {
	    return geopoint.trim().split(' ');
	  });
	}

	// converts degrees to radians
	function _toRadians(angle) {
	  return angle * Math.PI / 180;
	}

	// check if all geopoints are valid (copied from Enketo FormModel)
	function _latLngsValid(latLngs) {
	  return latLngs.every(function (coords) {
	    return (
	      (coords[0] !== '' && coords[0] >= -90 && coords[0] <= 90) &&
	      (coords[1] !== '' && coords[1] >= -180 && coords[1] <= 180) &&
	      (typeof coords[2] == 'undefined' || !isNaN(coords[2])) &&
	      (typeof coords[3] == 'undefined' || (!isNaN(coords[3]) && coords[3] >= 0))
	    );
	  });
	}

	/**
	 * Adapted from https://www.movable-type.co.uk/scripts/latlong.html
	 *
	 * @param {{lat:number, lng: number}} p1
	 * @param {{lat:number, lng: number}} p2
	 * @returns {number}
	 */
	function _distanceBetween(p1,p2) {
	  var Δλ = _toRadians(p1.lng - p2.lng);
	  var φ1 = _toRadians(p1.lat);
	  var φ2 = _toRadians(p2.lat);
	  return Math.acos(Math.sin(φ1) * Math.sin(φ2) + Math.cos(φ1) * Math.cos(φ2) * Math.cos(Δλ)) * EARTH_EQUATORIAL_RADIUS_METERS;
	}

	/**
	 * Adapted from https://github.com/Leaflet/Leaflet.draw/blob/3cba37065ea5be28f42efe9cc47836c9e3f5db8c/src/ext/GeometryUtil.js#L3-L20
	 */
	function area$1(geopoints) {
	  var latLngs = _toLatLngs(geopoints);

	  if (!_latLngsValid(latLngs)) {
	    return Number.NaN;
	  }

	  var pointsCount = latLngs.length;
	  var area = 0.0;

	  if (pointsCount > 2) {
	    for (var i = 0; i < pointsCount; i++) {
	      var p1 = {
	        lat: latLngs[i][0],
	        lng: latLngs[i][1]
	      };
	      var p2 = {
	        lat: latLngs[(i + 1) % pointsCount][0],
	        lng: latLngs[(i + 1) % pointsCount][1]
	      };
	      area += _toRadians(p2.lng - p1.lng) *
	          (2 + Math.sin(_toRadians(p1.lat)) + Math.sin(_toRadians(p2.lat)));
	    }
	    area = area * EARTH_EQUATORIAL_RADIUS_METERS * EARTH_EQUATORIAL_RADIUS_METERS / 2.0;
	  }
	  return Math.abs(Math.round(area * PRECISION)) / PRECISION;
	}

	/**
	 * @param {any} geopoints
	 * @returns
	 */
	function distance$1(geopoints) {
	  var latLngs = _toLatLngs(geopoints);

	  if (!_latLngsValid(latLngs)) {
	    return Number.NaN;
	  }

	  var pointsCount = latLngs.length;
	  var distance = 0.0;

	  if (pointsCount > 1) {
	    for (var i = 1; i < pointsCount; i++) {
	      var p1 = {
	        lat: latLngs[i - 1][0],
	        lng: latLngs[i - 1][1]
	      };
	      var p2 = {
	        lat: latLngs[i][0],
	        lng: latLngs[i][1]
	      };

	      distance += _distanceBetween(p1, p2);
	    }
	  }

	  return Math.abs(Math.round(distance * PRECISION)) / PRECISION;
	}

	var geo = {
	  asGeopoints: asGeopoints$1,
	  area: area$1,
	  distance: distance$1
	};

	function asGeopoints$1(r) {
	  if(r.t === 'arr' && r.v.length > 1) {
	    return r.v.map(asString$3);
	  }
	  return asString$3(r).split(';');
	}

	/**
	 * Node.js module for Forge.
	 *
	 * @author Dave Longley
	 *
	 * Copyright 2011-2016 Digital Bazaar, Inc.
	 */
	var forge = {
	  // default options
	  options: {
	    usePureJavaScript: false
	  }
	};
	forge.options;

	/**
	 * Base-N/Base-X encoding/decoding functions.
	 *
	 * Original implementation from base-x:
	 * https://github.com/cryptocoinjs/base-x
	 *
	 * Which is MIT licensed:
	 *
	 * The MIT License (MIT)
	 *
	 * Copyright base-x contributors (c) 2016
	 *
	 * Permission is hereby granted, free of charge, to any person obtaining a copy
	 * of this software and associated documentation files (the "Software"), to deal
	 * in the Software without restriction, including without limitation the rights
	 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	 * copies of the Software, and to permit persons to whom the Software is
	 * furnished to do so, subject to the following conditions:
	 *
	 * The above copyright notice and this permission notice shall be included in
	 * all copies or substantial portions of the Software.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
	 * DEALINGS IN THE SOFTWARE.
	 */
	var api = {};
	var baseN = api;

	// baseN alphabet indexes
	var _reverseAlphabets = {};

	/**
	 * BaseN-encodes a Uint8Array using the given alphabet.
	 *
	 * @param input the Uint8Array to encode.
	 * @param maxline the maximum number of encoded characters per line to use,
	 *          defaults to none.
	 *
	 * @return the baseN-encoded output string.
	 */
	api.encode = function(input, alphabet, maxline) {
	  if(typeof alphabet !== 'string') {
	    throw new TypeError('"alphabet" must be a string.');
	  }
	  if(maxline !== undefined && typeof maxline !== 'number') {
	    throw new TypeError('"maxline" must be a number.');
	  }

	  var output = '';

	  if(!(input instanceof Uint8Array)) {
	    // assume forge byte buffer
	    output = _encodeWithByteBuffer(input, alphabet);
	  } else {
	    var i = 0;
	    var base = alphabet.length;
	    var first = alphabet.charAt(0);
	    var digits = [0];
	    for(i = 0; i < input.length; ++i) {
	      for(var j = 0, carry = input[i]; j < digits.length; ++j) {
	        carry += digits[j] << 8;
	        digits[j] = carry % base;
	        carry = (carry / base) | 0;
	      }

	      while(carry > 0) {
	        digits.push(carry % base);
	        carry = (carry / base) | 0;
	      }
	    }

	    // deal with leading zeros
	    for(i = 0; input[i] === 0 && i < input.length - 1; ++i) {
	      output += first;
	    }
	    // convert digits to a string
	    for(i = digits.length - 1; i >= 0; --i) {
	      output += alphabet[digits[i]];
	    }
	  }

	  if(maxline) {
	    var regex = new RegExp('.{1,' + maxline + '}', 'g');
	    output = output.match(regex).join('\r\n');
	  }

	  return output;
	};

	/**
	 * Decodes a baseN-encoded (using the given alphabet) string to a
	 * Uint8Array.
	 *
	 * @param input the baseN-encoded input string.
	 *
	 * @return the Uint8Array.
	 */
	api.decode = function(input, alphabet) {
	  if(typeof input !== 'string') {
	    throw new TypeError('"input" must be a string.');
	  }
	  if(typeof alphabet !== 'string') {
	    throw new TypeError('"alphabet" must be a string.');
	  }

	  var table = _reverseAlphabets[alphabet];
	  if(!table) {
	    // compute reverse alphabet
	    table = _reverseAlphabets[alphabet] = [];
	    for(var i = 0; i < alphabet.length; ++i) {
	      table[alphabet.charCodeAt(i)] = i;
	    }
	  }

	  // remove whitespace characters
	  input = input.replace(/\s/g, '');

	  var base = alphabet.length;
	  var first = alphabet.charAt(0);
	  var bytes = [0];
	  for(var i = 0; i < input.length; i++) {
	    var value = table[input.charCodeAt(i)];
	    if(value === undefined) {
	      return;
	    }

	    for(var j = 0, carry = value; j < bytes.length; ++j) {
	      carry += bytes[j] * base;
	      bytes[j] = carry & 0xff;
	      carry >>= 8;
	    }

	    while(carry > 0) {
	      bytes.push(carry & 0xff);
	      carry >>= 8;
	    }
	  }

	  // deal with leading zeros
	  for(var k = 0; input[k] === first && k < input.length - 1; ++k) {
	    bytes.push(0);
	  }

	  if(typeof Buffer !== 'undefined') {
	    return Buffer.from(bytes.reverse());
	  }

	  return new Uint8Array(bytes.reverse());
	};

	function _encodeWithByteBuffer(input, alphabet) {
	  var i = 0;
	  var base = alphabet.length;
	  var first = alphabet.charAt(0);
	  var digits = [0];
	  for(i = 0; i < input.length(); ++i) {
	    for(var j = 0, carry = input.at(i); j < digits.length; ++j) {
	      carry += digits[j] << 8;
	      digits[j] = carry % base;
	      carry = (carry / base) | 0;
	    }

	    while(carry > 0) {
	      digits.push(carry % base);
	      carry = (carry / base) | 0;
	    }
	  }

	  var output = '';

	  // deal with leading zeros
	  for(i = 0; input.at(i) === 0 && i < input.length() - 1; ++i) {
	    output += first;
	  }
	  // convert digits to a string
	  for(i = digits.length - 1; i >= 0; --i) {
	    output += alphabet[digits[i]];
	  }

	  return output;
	}

	createCommonjsModule(function (module) {
	/**
	 * Utility functions for web applications.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2018 Digital Bazaar, Inc.
	 */



	/* Utilities API */
	var util = module.exports = forge.util = forge.util || {};

	// define setImmediate and nextTick
	(function() {
	  // use native nextTick (unless we're in webpack)
	  // webpack (or better node-libs-browser polyfill) sets process.browser.
	  // this way we can detect webpack properly
	  if(typeof process !== 'undefined' && process.nextTick && !process.browser) {
	    util.nextTick = process.nextTick;
	    if(typeof setImmediate === 'function') {
	      util.setImmediate = setImmediate;
	    } else {
	      // polyfill setImmediate with nextTick, older versions of node
	      // (those w/o setImmediate) won't totally starve IO
	      util.setImmediate = util.nextTick;
	    }
	    return;
	  }

	  // polyfill nextTick with native setImmediate
	  if(typeof setImmediate === 'function') {
	    util.setImmediate = function() { return setImmediate.apply(undefined, arguments); };
	    util.nextTick = function(callback) {
	      return setImmediate(callback);
	    };
	    return;
	  }

	  /* Note: A polyfill upgrade pattern is used here to allow combining
	  polyfills. For example, MutationObserver is fast, but blocks UI updates,
	  so it needs to allow UI updates periodically, so it falls back on
	  postMessage or setTimeout. */

	  // polyfill with setTimeout
	  util.setImmediate = function(callback) {
	    setTimeout(callback, 0);
	  };

	  // upgrade polyfill to use postMessage
	  if(typeof window !== 'undefined' &&
	    typeof window.postMessage === 'function') {
	    var msg = 'forge.setImmediate';
	    var callbacks = [];
	    util.setImmediate = function(callback) {
	      callbacks.push(callback);
	      // only send message when one hasn't been sent in
	      // the current turn of the event loop
	      if(callbacks.length === 1) {
	        window.postMessage(msg, '*');
	      }
	    };
	    function handler(event) {
	      if(event.source === window && event.data === msg) {
	        event.stopPropagation();
	        var copy = callbacks.slice();
	        callbacks.length = 0;
	        copy.forEach(function(callback) {
	          callback();
	        });
	      }
	    }
	    window.addEventListener('message', handler, true);
	  }

	  // upgrade polyfill to use MutationObserver
	  if(typeof MutationObserver !== 'undefined') {
	    // polyfill with MutationObserver
	    var now = Date.now();
	    var attr = true;
	    var div = document.createElement('div');
	    var callbacks = [];
	    new MutationObserver(function() {
	      var copy = callbacks.slice();
	      callbacks.length = 0;
	      copy.forEach(function(callback) {
	        callback();
	      });
	    }).observe(div, {attributes: true});
	    var oldSetImmediate = util.setImmediate;
	    util.setImmediate = function(callback) {
	      if(Date.now() - now > 15) {
	        now = Date.now();
	        oldSetImmediate(callback);
	      } else {
	        callbacks.push(callback);
	        // only trigger observer when it hasn't been triggered in
	        // the current turn of the event loop
	        if(callbacks.length === 1) {
	          div.setAttribute('a', attr = !attr);
	        }
	      }
	    };
	  }

	  util.nextTick = util.setImmediate;
	})();

	// check if running under Node.js
	util.isNodejs =
	  typeof process !== 'undefined' && process.versions && process.versions.node;


	// 'self' will also work in Web Workers (instance of WorkerGlobalScope) while
	// it will point to `window` in the main thread.
	// To remain compatible with older browsers, we fall back to 'window' if 'self'
	// is not available.
	util.globalScope = (function() {
	  if(util.isNodejs) {
	    return commonjsGlobal;
	  }

	  return typeof self === 'undefined' ? window : self;
	})();

	// define isArray
	util.isArray = Array.isArray || function(x) {
	  return Object.prototype.toString.call(x) === '[object Array]';
	};

	// define isArrayBuffer
	util.isArrayBuffer = function(x) {
	  return typeof ArrayBuffer !== 'undefined' && x instanceof ArrayBuffer;
	};

	// define isArrayBufferView
	util.isArrayBufferView = function(x) {
	  return x && util.isArrayBuffer(x.buffer) && x.byteLength !== undefined;
	};

	/**
	 * Ensure a bits param is 8, 16, 24, or 32. Used to validate input for
	 * algorithms where bit manipulation, JavaScript limitations, and/or algorithm
	 * design only allow for byte operations of a limited size.
	 *
	 * @param n number of bits.
	 *
	 * Throw Error if n invalid.
	 */
	function _checkBitsParam(n) {
	  if(!(n === 8 || n === 16 || n === 24 || n === 32)) {
	    throw new Error('Only 8, 16, 24, or 32 bits supported: ' + n);
	  }
	}

	// TODO: set ByteBuffer to best available backing
	util.ByteBuffer = ByteStringBuffer;

	/** Buffer w/BinaryString backing */

	/**
	 * Constructor for a binary string backed byte buffer.
	 *
	 * @param [b] the bytes to wrap (either encoded as string, one byte per
	 *          character, or as an ArrayBuffer or Typed Array).
	 */
	function ByteStringBuffer(b) {
	  // TODO: update to match DataBuffer API

	  // the data in this buffer
	  this.data = '';
	  // the pointer for reading from this buffer
	  this.read = 0;

	  if(typeof b === 'string') {
	    this.data = b;
	  } else if(util.isArrayBuffer(b) || util.isArrayBufferView(b)) {
	    if(typeof Buffer !== 'undefined' && b instanceof Buffer) {
	      this.data = b.toString('binary');
	    } else {
	      // convert native buffer to forge buffer
	      // FIXME: support native buffers internally instead
	      var arr = new Uint8Array(b);
	      try {
	        this.data = String.fromCharCode.apply(null, arr);
	      } catch(e) {
	        for(var i = 0; i < arr.length; ++i) {
	          this.putByte(arr[i]);
	        }
	      }
	    }
	  } else if(b instanceof ByteStringBuffer ||
	    (typeof b === 'object' && typeof b.data === 'string' &&
	    typeof b.read === 'number')) {
	    // copy existing buffer
	    this.data = b.data;
	    this.read = b.read;
	  }

	  // used for v8 optimization
	  this._constructedStringLength = 0;
	}
	util.ByteStringBuffer = ByteStringBuffer;

	/* Note: This is an optimization for V8-based browsers. When V8 concatenates
	  a string, the strings are only joined logically using a "cons string" or
	  "constructed/concatenated string". These containers keep references to one
	  another and can result in very large memory usage. For example, if a 2MB
	  string is constructed by concatenating 4 bytes together at a time, the
	  memory usage will be ~44MB; so ~22x increase. The strings are only joined
	  together when an operation requiring their joining takes place, such as
	  substr(). This function is called when adding data to this buffer to ensure
	  these types of strings are periodically joined to reduce the memory
	  footprint. */
	var _MAX_CONSTRUCTED_STRING_LENGTH = 4096;
	util.ByteStringBuffer.prototype._optimizeConstructedString = function(x) {
	  this._constructedStringLength += x;
	  if(this._constructedStringLength > _MAX_CONSTRUCTED_STRING_LENGTH) {
	    // this substr() should cause the constructed string to join
	    this.data.substr(0, 1);
	    this._constructedStringLength = 0;
	  }
	};

	/**
	 * Gets the number of bytes in this buffer.
	 *
	 * @return the number of bytes in this buffer.
	 */
	util.ByteStringBuffer.prototype.length = function() {
	  return this.data.length - this.read;
	};

	/**
	 * Gets whether or not this buffer is empty.
	 *
	 * @return true if this buffer is empty, false if not.
	 */
	util.ByteStringBuffer.prototype.isEmpty = function() {
	  return this.length() <= 0;
	};

	/**
	 * Puts a byte in this buffer.
	 *
	 * @param b the byte to put.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putByte = function(b) {
	  return this.putBytes(String.fromCharCode(b));
	};

	/**
	 * Puts a byte in this buffer N times.
	 *
	 * @param b the byte to put.
	 * @param n the number of bytes of value b to put.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.fillWithByte = function(b, n) {
	  b = String.fromCharCode(b);
	  var d = this.data;
	  while(n > 0) {
	    if(n & 1) {
	      d += b;
	    }
	    n >>>= 1;
	    if(n > 0) {
	      b += b;
	    }
	  }
	  this.data = d;
	  this._optimizeConstructedString(n);
	  return this;
	};

	/**
	 * Puts bytes in this buffer.
	 *
	 * @param bytes the bytes (as a binary encoded string) to put.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putBytes = function(bytes) {
	  this.data += bytes;
	  this._optimizeConstructedString(bytes.length);
	  return this;
	};

	/**
	 * Puts a UTF-16 encoded string into this buffer.
	 *
	 * @param str the string to put.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putString = function(str) {
	  return this.putBytes(util.encodeUtf8(str));
	};

	/**
	 * Puts a 16-bit integer in this buffer in big-endian order.
	 *
	 * @param i the 16-bit integer.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putInt16 = function(i) {
	  return this.putBytes(
	    String.fromCharCode(i >> 8 & 0xFF) +
	    String.fromCharCode(i & 0xFF));
	};

	/**
	 * Puts a 24-bit integer in this buffer in big-endian order.
	 *
	 * @param i the 24-bit integer.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putInt24 = function(i) {
	  return this.putBytes(
	    String.fromCharCode(i >> 16 & 0xFF) +
	    String.fromCharCode(i >> 8 & 0xFF) +
	    String.fromCharCode(i & 0xFF));
	};

	/**
	 * Puts a 32-bit integer in this buffer in big-endian order.
	 *
	 * @param i the 32-bit integer.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putInt32 = function(i) {
	  return this.putBytes(
	    String.fromCharCode(i >> 24 & 0xFF) +
	    String.fromCharCode(i >> 16 & 0xFF) +
	    String.fromCharCode(i >> 8 & 0xFF) +
	    String.fromCharCode(i & 0xFF));
	};

	/**
	 * Puts a 16-bit integer in this buffer in little-endian order.
	 *
	 * @param i the 16-bit integer.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putInt16Le = function(i) {
	  return this.putBytes(
	    String.fromCharCode(i & 0xFF) +
	    String.fromCharCode(i >> 8 & 0xFF));
	};

	/**
	 * Puts a 24-bit integer in this buffer in little-endian order.
	 *
	 * @param i the 24-bit integer.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putInt24Le = function(i) {
	  return this.putBytes(
	    String.fromCharCode(i & 0xFF) +
	    String.fromCharCode(i >> 8 & 0xFF) +
	    String.fromCharCode(i >> 16 & 0xFF));
	};

	/**
	 * Puts a 32-bit integer in this buffer in little-endian order.
	 *
	 * @param i the 32-bit integer.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putInt32Le = function(i) {
	  return this.putBytes(
	    String.fromCharCode(i & 0xFF) +
	    String.fromCharCode(i >> 8 & 0xFF) +
	    String.fromCharCode(i >> 16 & 0xFF) +
	    String.fromCharCode(i >> 24 & 0xFF));
	};

	/**
	 * Puts an n-bit integer in this buffer in big-endian order.
	 *
	 * @param i the n-bit integer.
	 * @param n the number of bits in the integer (8, 16, 24, or 32).
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putInt = function(i, n) {
	  _checkBitsParam(n);
	  var bytes = '';
	  do {
	    n -= 8;
	    bytes += String.fromCharCode((i >> n) & 0xFF);
	  } while(n > 0);
	  return this.putBytes(bytes);
	};

	/**
	 * Puts a signed n-bit integer in this buffer in big-endian order. Two's
	 * complement representation is used.
	 *
	 * @param i the n-bit integer.
	 * @param n the number of bits in the integer (8, 16, 24, or 32).
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putSignedInt = function(i, n) {
	  // putInt checks n
	  if(i < 0) {
	    i += 2 << (n - 1);
	  }
	  return this.putInt(i, n);
	};

	/**
	 * Puts the given buffer into this buffer.
	 *
	 * @param buffer the buffer to put into this one.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.putBuffer = function(buffer) {
	  return this.putBytes(buffer.getBytes());
	};

	/**
	 * Gets a byte from this buffer and advances the read pointer by 1.
	 *
	 * @return the byte.
	 */
	util.ByteStringBuffer.prototype.getByte = function() {
	  return this.data.charCodeAt(this.read++);
	};

	/**
	 * Gets a uint16 from this buffer in big-endian order and advances the read
	 * pointer by 2.
	 *
	 * @return the uint16.
	 */
	util.ByteStringBuffer.prototype.getInt16 = function() {
	  var rval = (
	    this.data.charCodeAt(this.read) << 8 ^
	    this.data.charCodeAt(this.read + 1));
	  this.read += 2;
	  return rval;
	};

	/**
	 * Gets a uint24 from this buffer in big-endian order and advances the read
	 * pointer by 3.
	 *
	 * @return the uint24.
	 */
	util.ByteStringBuffer.prototype.getInt24 = function() {
	  var rval = (
	    this.data.charCodeAt(this.read) << 16 ^
	    this.data.charCodeAt(this.read + 1) << 8 ^
	    this.data.charCodeAt(this.read + 2));
	  this.read += 3;
	  return rval;
	};

	/**
	 * Gets a uint32 from this buffer in big-endian order and advances the read
	 * pointer by 4.
	 *
	 * @return the word.
	 */
	util.ByteStringBuffer.prototype.getInt32 = function() {
	  var rval = (
	    this.data.charCodeAt(this.read) << 24 ^
	    this.data.charCodeAt(this.read + 1) << 16 ^
	    this.data.charCodeAt(this.read + 2) << 8 ^
	    this.data.charCodeAt(this.read + 3));
	  this.read += 4;
	  return rval;
	};

	/**
	 * Gets a uint16 from this buffer in little-endian order and advances the read
	 * pointer by 2.
	 *
	 * @return the uint16.
	 */
	util.ByteStringBuffer.prototype.getInt16Le = function() {
	  var rval = (
	    this.data.charCodeAt(this.read) ^
	    this.data.charCodeAt(this.read + 1) << 8);
	  this.read += 2;
	  return rval;
	};

	/**
	 * Gets a uint24 from this buffer in little-endian order and advances the read
	 * pointer by 3.
	 *
	 * @return the uint24.
	 */
	util.ByteStringBuffer.prototype.getInt24Le = function() {
	  var rval = (
	    this.data.charCodeAt(this.read) ^
	    this.data.charCodeAt(this.read + 1) << 8 ^
	    this.data.charCodeAt(this.read + 2) << 16);
	  this.read += 3;
	  return rval;
	};

	/**
	 * Gets a uint32 from this buffer in little-endian order and advances the read
	 * pointer by 4.
	 *
	 * @return the word.
	 */
	util.ByteStringBuffer.prototype.getInt32Le = function() {
	  var rval = (
	    this.data.charCodeAt(this.read) ^
	    this.data.charCodeAt(this.read + 1) << 8 ^
	    this.data.charCodeAt(this.read + 2) << 16 ^
	    this.data.charCodeAt(this.read + 3) << 24);
	  this.read += 4;
	  return rval;
	};

	/**
	 * Gets an n-bit integer from this buffer in big-endian order and advances the
	 * read pointer by ceil(n/8).
	 *
	 * @param n the number of bits in the integer (8, 16, 24, or 32).
	 *
	 * @return the integer.
	 */
	util.ByteStringBuffer.prototype.getInt = function(n) {
	  _checkBitsParam(n);
	  var rval = 0;
	  do {
	    // TODO: Use (rval * 0x100) if adding support for 33 to 53 bits.
	    rval = (rval << 8) + this.data.charCodeAt(this.read++);
	    n -= 8;
	  } while(n > 0);
	  return rval;
	};

	/**
	 * Gets a signed n-bit integer from this buffer in big-endian order, using
	 * two's complement, and advances the read pointer by n/8.
	 *
	 * @param n the number of bits in the integer (8, 16, 24, or 32).
	 *
	 * @return the integer.
	 */
	util.ByteStringBuffer.prototype.getSignedInt = function(n) {
	  // getInt checks n
	  var x = this.getInt(n);
	  var max = 2 << (n - 2);
	  if(x >= max) {
	    x -= max << 1;
	  }
	  return x;
	};

	/**
	 * Reads bytes out as a binary encoded string and clears them from the
	 * buffer. Note that the resulting string is binary encoded (in node.js this
	 * encoding is referred to as `binary`, it is *not* `utf8`).
	 *
	 * @param count the number of bytes to read, undefined or null for all.
	 *
	 * @return a binary encoded string of bytes.
	 */
	util.ByteStringBuffer.prototype.getBytes = function(count) {
	  var rval;
	  if(count) {
	    // read count bytes
	    count = Math.min(this.length(), count);
	    rval = this.data.slice(this.read, this.read + count);
	    this.read += count;
	  } else if(count === 0) {
	    rval = '';
	  } else {
	    // read all bytes, optimize to only copy when needed
	    rval = (this.read === 0) ? this.data : this.data.slice(this.read);
	    this.clear();
	  }
	  return rval;
	};

	/**
	 * Gets a binary encoded string of the bytes from this buffer without
	 * modifying the read pointer.
	 *
	 * @param count the number of bytes to get, omit to get all.
	 *
	 * @return a string full of binary encoded characters.
	 */
	util.ByteStringBuffer.prototype.bytes = function(count) {
	  return (typeof(count) === 'undefined' ?
	    this.data.slice(this.read) :
	    this.data.slice(this.read, this.read + count));
	};

	/**
	 * Gets a byte at the given index without modifying the read pointer.
	 *
	 * @param i the byte index.
	 *
	 * @return the byte.
	 */
	util.ByteStringBuffer.prototype.at = function(i) {
	  return this.data.charCodeAt(this.read + i);
	};

	/**
	 * Puts a byte at the given index without modifying the read pointer.
	 *
	 * @param i the byte index.
	 * @param b the byte to put.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.setAt = function(i, b) {
	  this.data = this.data.substr(0, this.read + i) +
	    String.fromCharCode(b) +
	    this.data.substr(this.read + i + 1);
	  return this;
	};

	/**
	 * Gets the last byte without modifying the read pointer.
	 *
	 * @return the last byte.
	 */
	util.ByteStringBuffer.prototype.last = function() {
	  return this.data.charCodeAt(this.data.length - 1);
	};

	/**
	 * Creates a copy of this buffer.
	 *
	 * @return the copy.
	 */
	util.ByteStringBuffer.prototype.copy = function() {
	  var c = util.createBuffer(this.data);
	  c.read = this.read;
	  return c;
	};

	/**
	 * Compacts this buffer.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.compact = function() {
	  if(this.read > 0) {
	    this.data = this.data.slice(this.read);
	    this.read = 0;
	  }
	  return this;
	};

	/**
	 * Clears this buffer.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.clear = function() {
	  this.data = '';
	  this.read = 0;
	  return this;
	};

	/**
	 * Shortens this buffer by triming bytes off of the end of this buffer.
	 *
	 * @param count the number of bytes to trim off.
	 *
	 * @return this buffer.
	 */
	util.ByteStringBuffer.prototype.truncate = function(count) {
	  var len = Math.max(0, this.length() - count);
	  this.data = this.data.substr(this.read, len);
	  this.read = 0;
	  return this;
	};

	/**
	 * Converts this buffer to a hexadecimal string.
	 *
	 * @return a hexadecimal string.
	 */
	util.ByteStringBuffer.prototype.toHex = function() {
	  var rval = '';
	  for(var i = this.read; i < this.data.length; ++i) {
	    var b = this.data.charCodeAt(i);
	    if(b < 16) {
	      rval += '0';
	    }
	    rval += b.toString(16);
	  }
	  return rval;
	};

	/**
	 * Converts this buffer to a UTF-16 string (standard JavaScript string).
	 *
	 * @return a UTF-16 string.
	 */
	util.ByteStringBuffer.prototype.toString = function() {
	  return util.decodeUtf8(this.bytes());
	};

	/** End Buffer w/BinaryString backing */

	/** Buffer w/UInt8Array backing */

	/**
	 * FIXME: Experimental. Do not use yet.
	 *
	 * Constructor for an ArrayBuffer-backed byte buffer.
	 *
	 * The buffer may be constructed from a string, an ArrayBuffer, DataView, or a
	 * TypedArray.
	 *
	 * If a string is given, its encoding should be provided as an option,
	 * otherwise it will default to 'binary'. A 'binary' string is encoded such
	 * that each character is one byte in length and size.
	 *
	 * If an ArrayBuffer, DataView, or TypedArray is given, it will be used
	 * *directly* without any copying. Note that, if a write to the buffer requires
	 * more space, the buffer will allocate a new backing ArrayBuffer to
	 * accommodate. The starting read and write offsets for the buffer may be
	 * given as options.
	 *
	 * @param [b] the initial bytes for this buffer.
	 * @param options the options to use:
	 *          [readOffset] the starting read offset to use (default: 0).
	 *          [writeOffset] the starting write offset to use (default: the
	 *            length of the first parameter).
	 *          [growSize] the minimum amount, in bytes, to grow the buffer by to
	 *            accommodate writes (default: 1024).
	 *          [encoding] the encoding ('binary', 'utf8', 'utf16', 'hex') for the
	 *            first parameter, if it is a string (default: 'binary').
	 */
	function DataBuffer(b, options) {
	  // default options
	  options = options || {};

	  // pointers for read from/write to buffer
	  this.read = options.readOffset || 0;
	  this.growSize = options.growSize || 1024;

	  var isArrayBuffer = util.isArrayBuffer(b);
	  var isArrayBufferView = util.isArrayBufferView(b);
	  if(isArrayBuffer || isArrayBufferView) {
	    // use ArrayBuffer directly
	    if(isArrayBuffer) {
	      this.data = new DataView(b);
	    } else {
	      // TODO: adjust read/write offset based on the type of view
	      // or specify that this must be done in the options ... that the
	      // offsets are byte-based
	      this.data = new DataView(b.buffer, b.byteOffset, b.byteLength);
	    }
	    this.write = ('writeOffset' in options ?
	      options.writeOffset : this.data.byteLength);
	    return;
	  }

	  // initialize to empty array buffer and add any given bytes using putBytes
	  this.data = new DataView(new ArrayBuffer(0));
	  this.write = 0;

	  if(b !== null && b !== undefined) {
	    this.putBytes(b);
	  }

	  if('writeOffset' in options) {
	    this.write = options.writeOffset;
	  }
	}
	util.DataBuffer = DataBuffer;

	/**
	 * Gets the number of bytes in this buffer.
	 *
	 * @return the number of bytes in this buffer.
	 */
	util.DataBuffer.prototype.length = function() {
	  return this.write - this.read;
	};

	/**
	 * Gets whether or not this buffer is empty.
	 *
	 * @return true if this buffer is empty, false if not.
	 */
	util.DataBuffer.prototype.isEmpty = function() {
	  return this.length() <= 0;
	};

	/**
	 * Ensures this buffer has enough empty space to accommodate the given number
	 * of bytes. An optional parameter may be given that indicates a minimum
	 * amount to grow the buffer if necessary. If the parameter is not given,
	 * the buffer will be grown by some previously-specified default amount
	 * or heuristic.
	 *
	 * @param amount the number of bytes to accommodate.
	 * @param [growSize] the minimum amount, in bytes, to grow the buffer by if
	 *          necessary.
	 */
	util.DataBuffer.prototype.accommodate = function(amount, growSize) {
	  if(this.length() >= amount) {
	    return this;
	  }
	  growSize = Math.max(growSize || this.growSize, amount);

	  // grow buffer
	  var src = new Uint8Array(
	    this.data.buffer, this.data.byteOffset, this.data.byteLength);
	  var dst = new Uint8Array(this.length() + growSize);
	  dst.set(src);
	  this.data = new DataView(dst.buffer);

	  return this;
	};

	/**
	 * Puts a byte in this buffer.
	 *
	 * @param b the byte to put.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putByte = function(b) {
	  this.accommodate(1);
	  this.data.setUint8(this.write++, b);
	  return this;
	};

	/**
	 * Puts a byte in this buffer N times.
	 *
	 * @param b the byte to put.
	 * @param n the number of bytes of value b to put.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.fillWithByte = function(b, n) {
	  this.accommodate(n);
	  for(var i = 0; i < n; ++i) {
	    this.data.setUint8(b);
	  }
	  return this;
	};

	/**
	 * Puts bytes in this buffer. The bytes may be given as a string, an
	 * ArrayBuffer, a DataView, or a TypedArray.
	 *
	 * @param bytes the bytes to put.
	 * @param [encoding] the encoding for the first parameter ('binary', 'utf8',
	 *          'utf16', 'hex'), if it is a string (default: 'binary').
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putBytes = function(bytes, encoding) {
	  if(util.isArrayBufferView(bytes)) {
	    var src = new Uint8Array(bytes.buffer, bytes.byteOffset, bytes.byteLength);
	    var len = src.byteLength - src.byteOffset;
	    this.accommodate(len);
	    var dst = new Uint8Array(this.data.buffer, this.write);
	    dst.set(src);
	    this.write += len;
	    return this;
	  }

	  if(util.isArrayBuffer(bytes)) {
	    var src = new Uint8Array(bytes);
	    this.accommodate(src.byteLength);
	    var dst = new Uint8Array(this.data.buffer);
	    dst.set(src, this.write);
	    this.write += src.byteLength;
	    return this;
	  }

	  // bytes is a util.DataBuffer or equivalent
	  if(bytes instanceof util.DataBuffer ||
	    (typeof bytes === 'object' &&
	    typeof bytes.read === 'number' && typeof bytes.write === 'number' &&
	    util.isArrayBufferView(bytes.data))) {
	    var src = new Uint8Array(bytes.data.byteLength, bytes.read, bytes.length());
	    this.accommodate(src.byteLength);
	    var dst = new Uint8Array(bytes.data.byteLength, this.write);
	    dst.set(src);
	    this.write += src.byteLength;
	    return this;
	  }

	  if(bytes instanceof util.ByteStringBuffer) {
	    // copy binary string and process as the same as a string parameter below
	    bytes = bytes.data;
	    encoding = 'binary';
	  }

	  // string conversion
	  encoding = encoding || 'binary';
	  if(typeof bytes === 'string') {
	    var view;

	    // decode from string
	    if(encoding === 'hex') {
	      this.accommodate(Math.ceil(bytes.length / 2));
	      view = new Uint8Array(this.data.buffer, this.write);
	      this.write += util.binary.hex.decode(bytes, view, this.write);
	      return this;
	    }
	    if(encoding === 'base64') {
	      this.accommodate(Math.ceil(bytes.length / 4) * 3);
	      view = new Uint8Array(this.data.buffer, this.write);
	      this.write += util.binary.base64.decode(bytes, view, this.write);
	      return this;
	    }

	    // encode text as UTF-8 bytes
	    if(encoding === 'utf8') {
	      // encode as UTF-8 then decode string as raw binary
	      bytes = util.encodeUtf8(bytes);
	      encoding = 'binary';
	    }

	    // decode string as raw binary
	    if(encoding === 'binary' || encoding === 'raw') {
	      // one byte per character
	      this.accommodate(bytes.length);
	      view = new Uint8Array(this.data.buffer, this.write);
	      this.write += util.binary.raw.decode(view);
	      return this;
	    }

	    // encode text as UTF-16 bytes
	    if(encoding === 'utf16') {
	      // two bytes per character
	      this.accommodate(bytes.length * 2);
	      view = new Uint16Array(this.data.buffer, this.write);
	      this.write += util.text.utf16.encode(view);
	      return this;
	    }

	    throw new Error('Invalid encoding: ' + encoding);
	  }

	  throw Error('Invalid parameter: ' + bytes);
	};

	/**
	 * Puts the given buffer into this buffer.
	 *
	 * @param buffer the buffer to put into this one.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putBuffer = function(buffer) {
	  this.putBytes(buffer);
	  buffer.clear();
	  return this;
	};

	/**
	 * Puts a string into this buffer.
	 *
	 * @param str the string to put.
	 * @param [encoding] the encoding for the string (default: 'utf16').
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putString = function(str) {
	  return this.putBytes(str, 'utf16');
	};

	/**
	 * Puts a 16-bit integer in this buffer in big-endian order.
	 *
	 * @param i the 16-bit integer.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putInt16 = function(i) {
	  this.accommodate(2);
	  this.data.setInt16(this.write, i);
	  this.write += 2;
	  return this;
	};

	/**
	 * Puts a 24-bit integer in this buffer in big-endian order.
	 *
	 * @param i the 24-bit integer.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putInt24 = function(i) {
	  this.accommodate(3);
	  this.data.setInt16(this.write, i >> 8 & 0xFFFF);
	  this.data.setInt8(this.write, i >> 16 & 0xFF);
	  this.write += 3;
	  return this;
	};

	/**
	 * Puts a 32-bit integer in this buffer in big-endian order.
	 *
	 * @param i the 32-bit integer.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putInt32 = function(i) {
	  this.accommodate(4);
	  this.data.setInt32(this.write, i);
	  this.write += 4;
	  return this;
	};

	/**
	 * Puts a 16-bit integer in this buffer in little-endian order.
	 *
	 * @param i the 16-bit integer.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putInt16Le = function(i) {
	  this.accommodate(2);
	  this.data.setInt16(this.write, i, true);
	  this.write += 2;
	  return this;
	};

	/**
	 * Puts a 24-bit integer in this buffer in little-endian order.
	 *
	 * @param i the 24-bit integer.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putInt24Le = function(i) {
	  this.accommodate(3);
	  this.data.setInt8(this.write, i >> 16 & 0xFF);
	  this.data.setInt16(this.write, i >> 8 & 0xFFFF, true);
	  this.write += 3;
	  return this;
	};

	/**
	 * Puts a 32-bit integer in this buffer in little-endian order.
	 *
	 * @param i the 32-bit integer.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putInt32Le = function(i) {
	  this.accommodate(4);
	  this.data.setInt32(this.write, i, true);
	  this.write += 4;
	  return this;
	};

	/**
	 * Puts an n-bit integer in this buffer in big-endian order.
	 *
	 * @param i the n-bit integer.
	 * @param n the number of bits in the integer (8, 16, 24, or 32).
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putInt = function(i, n) {
	  _checkBitsParam(n);
	  this.accommodate(n / 8);
	  do {
	    n -= 8;
	    this.data.setInt8(this.write++, (i >> n) & 0xFF);
	  } while(n > 0);
	  return this;
	};

	/**
	 * Puts a signed n-bit integer in this buffer in big-endian order. Two's
	 * complement representation is used.
	 *
	 * @param i the n-bit integer.
	 * @param n the number of bits in the integer.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.putSignedInt = function(i, n) {
	  _checkBitsParam(n);
	  this.accommodate(n / 8);
	  if(i < 0) {
	    i += 2 << (n - 1);
	  }
	  return this.putInt(i, n);
	};

	/**
	 * Gets a byte from this buffer and advances the read pointer by 1.
	 *
	 * @return the byte.
	 */
	util.DataBuffer.prototype.getByte = function() {
	  return this.data.getInt8(this.read++);
	};

	/**
	 * Gets a uint16 from this buffer in big-endian order and advances the read
	 * pointer by 2.
	 *
	 * @return the uint16.
	 */
	util.DataBuffer.prototype.getInt16 = function() {
	  var rval = this.data.getInt16(this.read);
	  this.read += 2;
	  return rval;
	};

	/**
	 * Gets a uint24 from this buffer in big-endian order and advances the read
	 * pointer by 3.
	 *
	 * @return the uint24.
	 */
	util.DataBuffer.prototype.getInt24 = function() {
	  var rval = (
	    this.data.getInt16(this.read) << 8 ^
	    this.data.getInt8(this.read + 2));
	  this.read += 3;
	  return rval;
	};

	/**
	 * Gets a uint32 from this buffer in big-endian order and advances the read
	 * pointer by 4.
	 *
	 * @return the word.
	 */
	util.DataBuffer.prototype.getInt32 = function() {
	  var rval = this.data.getInt32(this.read);
	  this.read += 4;
	  return rval;
	};

	/**
	 * Gets a uint16 from this buffer in little-endian order and advances the read
	 * pointer by 2.
	 *
	 * @return the uint16.
	 */
	util.DataBuffer.prototype.getInt16Le = function() {
	  var rval = this.data.getInt16(this.read, true);
	  this.read += 2;
	  return rval;
	};

	/**
	 * Gets a uint24 from this buffer in little-endian order and advances the read
	 * pointer by 3.
	 *
	 * @return the uint24.
	 */
	util.DataBuffer.prototype.getInt24Le = function() {
	  var rval = (
	    this.data.getInt8(this.read) ^
	    this.data.getInt16(this.read + 1, true) << 8);
	  this.read += 3;
	  return rval;
	};

	/**
	 * Gets a uint32 from this buffer in little-endian order and advances the read
	 * pointer by 4.
	 *
	 * @return the word.
	 */
	util.DataBuffer.prototype.getInt32Le = function() {
	  var rval = this.data.getInt32(this.read, true);
	  this.read += 4;
	  return rval;
	};

	/**
	 * Gets an n-bit integer from this buffer in big-endian order and advances the
	 * read pointer by n/8.
	 *
	 * @param n the number of bits in the integer (8, 16, 24, or 32).
	 *
	 * @return the integer.
	 */
	util.DataBuffer.prototype.getInt = function(n) {
	  _checkBitsParam(n);
	  var rval = 0;
	  do {
	    // TODO: Use (rval * 0x100) if adding support for 33 to 53 bits.
	    rval = (rval << 8) + this.data.getInt8(this.read++);
	    n -= 8;
	  } while(n > 0);
	  return rval;
	};

	/**
	 * Gets a signed n-bit integer from this buffer in big-endian order, using
	 * two's complement, and advances the read pointer by n/8.
	 *
	 * @param n the number of bits in the integer (8, 16, 24, or 32).
	 *
	 * @return the integer.
	 */
	util.DataBuffer.prototype.getSignedInt = function(n) {
	  // getInt checks n
	  var x = this.getInt(n);
	  var max = 2 << (n - 2);
	  if(x >= max) {
	    x -= max << 1;
	  }
	  return x;
	};

	/**
	 * Reads bytes out as a binary encoded string and clears them from the
	 * buffer.
	 *
	 * @param count the number of bytes to read, undefined or null for all.
	 *
	 * @return a binary encoded string of bytes.
	 */
	util.DataBuffer.prototype.getBytes = function(count) {
	  // TODO: deprecate this method, it is poorly named and
	  // this.toString('binary') replaces it
	  // add a toTypedArray()/toArrayBuffer() function
	  var rval;
	  if(count) {
	    // read count bytes
	    count = Math.min(this.length(), count);
	    rval = this.data.slice(this.read, this.read + count);
	    this.read += count;
	  } else if(count === 0) {
	    rval = '';
	  } else {
	    // read all bytes, optimize to only copy when needed
	    rval = (this.read === 0) ? this.data : this.data.slice(this.read);
	    this.clear();
	  }
	  return rval;
	};

	/**
	 * Gets a binary encoded string of the bytes from this buffer without
	 * modifying the read pointer.
	 *
	 * @param count the number of bytes to get, omit to get all.
	 *
	 * @return a string full of binary encoded characters.
	 */
	util.DataBuffer.prototype.bytes = function(count) {
	  // TODO: deprecate this method, it is poorly named, add "getString()"
	  return (typeof(count) === 'undefined' ?
	    this.data.slice(this.read) :
	    this.data.slice(this.read, this.read + count));
	};

	/**
	 * Gets a byte at the given index without modifying the read pointer.
	 *
	 * @param i the byte index.
	 *
	 * @return the byte.
	 */
	util.DataBuffer.prototype.at = function(i) {
	  return this.data.getUint8(this.read + i);
	};

	/**
	 * Puts a byte at the given index without modifying the read pointer.
	 *
	 * @param i the byte index.
	 * @param b the byte to put.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.setAt = function(i, b) {
	  this.data.setUint8(i, b);
	  return this;
	};

	/**
	 * Gets the last byte without modifying the read pointer.
	 *
	 * @return the last byte.
	 */
	util.DataBuffer.prototype.last = function() {
	  return this.data.getUint8(this.write - 1);
	};

	/**
	 * Creates a copy of this buffer.
	 *
	 * @return the copy.
	 */
	util.DataBuffer.prototype.copy = function() {
	  return new util.DataBuffer(this);
	};

	/**
	 * Compacts this buffer.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.compact = function() {
	  if(this.read > 0) {
	    var src = new Uint8Array(this.data.buffer, this.read);
	    var dst = new Uint8Array(src.byteLength);
	    dst.set(src);
	    this.data = new DataView(dst);
	    this.write -= this.read;
	    this.read = 0;
	  }
	  return this;
	};

	/**
	 * Clears this buffer.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.clear = function() {
	  this.data = new DataView(new ArrayBuffer(0));
	  this.read = this.write = 0;
	  return this;
	};

	/**
	 * Shortens this buffer by triming bytes off of the end of this buffer.
	 *
	 * @param count the number of bytes to trim off.
	 *
	 * @return this buffer.
	 */
	util.DataBuffer.prototype.truncate = function(count) {
	  this.write = Math.max(0, this.length() - count);
	  this.read = Math.min(this.read, this.write);
	  return this;
	};

	/**
	 * Converts this buffer to a hexadecimal string.
	 *
	 * @return a hexadecimal string.
	 */
	util.DataBuffer.prototype.toHex = function() {
	  var rval = '';
	  for(var i = this.read; i < this.data.byteLength; ++i) {
	    var b = this.data.getUint8(i);
	    if(b < 16) {
	      rval += '0';
	    }
	    rval += b.toString(16);
	  }
	  return rval;
	};

	/**
	 * Converts this buffer to a string, using the given encoding. If no
	 * encoding is given, 'utf8' (UTF-8) is used.
	 *
	 * @param [encoding] the encoding to use: 'binary', 'utf8', 'utf16', 'hex',
	 *          'base64' (default: 'utf8').
	 *
	 * @return a string representation of the bytes in this buffer.
	 */
	util.DataBuffer.prototype.toString = function(encoding) {
	  var view = new Uint8Array(this.data, this.read, this.length());
	  encoding = encoding || 'utf8';

	  // encode to string
	  if(encoding === 'binary' || encoding === 'raw') {
	    return util.binary.raw.encode(view);
	  }
	  if(encoding === 'hex') {
	    return util.binary.hex.encode(view);
	  }
	  if(encoding === 'base64') {
	    return util.binary.base64.encode(view);
	  }

	  // decode to text
	  if(encoding === 'utf8') {
	    return util.text.utf8.decode(view);
	  }
	  if(encoding === 'utf16') {
	    return util.text.utf16.decode(view);
	  }

	  throw new Error('Invalid encoding: ' + encoding);
	};

	/** End Buffer w/UInt8Array backing */

	/**
	 * Creates a buffer that stores bytes. A value may be given to populate the
	 * buffer with data. This value can either be string of encoded bytes or a
	 * regular string of characters. When passing a string of binary encoded
	 * bytes, the encoding `raw` should be given. This is also the default. When
	 * passing a string of characters, the encoding `utf8` should be given.
	 *
	 * @param [input] a string with encoded bytes to store in the buffer.
	 * @param [encoding] (default: 'raw', other: 'utf8').
	 */
	util.createBuffer = function(input, encoding) {
	  // TODO: deprecate, use new ByteBuffer() instead
	  encoding = encoding || 'raw';
	  if(input !== undefined && encoding === 'utf8') {
	    input = util.encodeUtf8(input);
	  }
	  return new util.ByteBuffer(input);
	};

	/**
	 * Fills a string with a particular value. If you want the string to be a byte
	 * string, pass in String.fromCharCode(theByte).
	 *
	 * @param c the character to fill the string with, use String.fromCharCode
	 *          to fill the string with a byte value.
	 * @param n the number of characters of value c to fill with.
	 *
	 * @return the filled string.
	 */
	util.fillString = function(c, n) {
	  var s = '';
	  while(n > 0) {
	    if(n & 1) {
	      s += c;
	    }
	    n >>>= 1;
	    if(n > 0) {
	      c += c;
	    }
	  }
	  return s;
	};

	/**
	 * Performs a per byte XOR between two byte strings and returns the result as a
	 * string of bytes.
	 *
	 * @param s1 first string of bytes.
	 * @param s2 second string of bytes.
	 * @param n the number of bytes to XOR.
	 *
	 * @return the XOR'd result.
	 */
	util.xorBytes = function(s1, s2, n) {
	  var s3 = '';
	  var b = '';
	  var t = '';
	  var i = 0;
	  var c = 0;
	  for(; n > 0; --n, ++i) {
	    b = s1.charCodeAt(i) ^ s2.charCodeAt(i);
	    if(c >= 10) {
	      s3 += t;
	      t = '';
	      c = 0;
	    }
	    t += String.fromCharCode(b);
	    ++c;
	  }
	  s3 += t;
	  return s3;
	};

	/**
	 * Converts a hex string into a 'binary' encoded string of bytes.
	 *
	 * @param hex the hexadecimal string to convert.
	 *
	 * @return the binary-encoded string of bytes.
	 */
	util.hexToBytes = function(hex) {
	  // TODO: deprecate: "Deprecated. Use util.binary.hex.decode instead."
	  var rval = '';
	  var i = 0;
	  if(hex.length & 1 == 1) {
	    // odd number of characters, convert first character alone
	    i = 1;
	    rval += String.fromCharCode(parseInt(hex[0], 16));
	  }
	  // convert 2 characters (1 byte) at a time
	  for(; i < hex.length; i += 2) {
	    rval += String.fromCharCode(parseInt(hex.substr(i, 2), 16));
	  }
	  return rval;
	};

	/**
	 * Converts a 'binary' encoded string of bytes to hex.
	 *
	 * @param bytes the byte string to convert.
	 *
	 * @return the string of hexadecimal characters.
	 */
	util.bytesToHex = function(bytes) {
	  // TODO: deprecate: "Deprecated. Use util.binary.hex.encode instead."
	  return util.createBuffer(bytes).toHex();
	};

	/**
	 * Converts an 32-bit integer to 4-big-endian byte string.
	 *
	 * @param i the integer.
	 *
	 * @return the byte string.
	 */
	util.int32ToBytes = function(i) {
	  return (
	    String.fromCharCode(i >> 24 & 0xFF) +
	    String.fromCharCode(i >> 16 & 0xFF) +
	    String.fromCharCode(i >> 8 & 0xFF) +
	    String.fromCharCode(i & 0xFF));
	};

	// base64 characters, reverse mapping
	var _base64 =
	  'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
	var _base64Idx = [
	/*43 -43 = 0*/
	/*'+',  1,  2,  3,'/' */
	   62, -1, -1, -1, 63,

	/*'0','1','2','3','4','5','6','7','8','9' */
	   52, 53, 54, 55, 56, 57, 58, 59, 60, 61,

	/*15, 16, 17,'=', 19, 20, 21 */
	  -1, -1, -1, 64, -1, -1, -1,

	/*65 - 43 = 22*/
	/*'A','B','C','D','E','F','G','H','I','J','K','L','M', */
	   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12,

	/*'N','O','P','Q','R','S','T','U','V','W','X','Y','Z' */
	   13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,

	/*91 - 43 = 48 */
	/*48, 49, 50, 51, 52, 53 */
	  -1, -1, -1, -1, -1, -1,

	/*97 - 43 = 54*/
	/*'a','b','c','d','e','f','g','h','i','j','k','l','m' */
	   26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,

	/*'n','o','p','q','r','s','t','u','v','w','x','y','z' */
	   39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51
	];

	// base58 characters (Bitcoin alphabet)
	var _base58 = '123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz';

	/**
	 * Base64 encodes a 'binary' encoded string of bytes.
	 *
	 * @param input the binary encoded string of bytes to base64-encode.
	 * @param maxline the maximum number of encoded characters per line to use,
	 *          defaults to none.
	 *
	 * @return the base64-encoded output.
	 */
	util.encode64 = function(input, maxline) {
	  // TODO: deprecate: "Deprecated. Use util.binary.base64.encode instead."
	  var line = '';
	  var output = '';
	  var chr1, chr2, chr3;
	  var i = 0;
	  while(i < input.length) {
	    chr1 = input.charCodeAt(i++);
	    chr2 = input.charCodeAt(i++);
	    chr3 = input.charCodeAt(i++);

	    // encode 4 character group
	    line += _base64.charAt(chr1 >> 2);
	    line += _base64.charAt(((chr1 & 3) << 4) | (chr2 >> 4));
	    if(isNaN(chr2)) {
	      line += '==';
	    } else {
	      line += _base64.charAt(((chr2 & 15) << 2) | (chr3 >> 6));
	      line += isNaN(chr3) ? '=' : _base64.charAt(chr3 & 63);
	    }

	    if(maxline && line.length > maxline) {
	      output += line.substr(0, maxline) + '\r\n';
	      line = line.substr(maxline);
	    }
	  }
	  output += line;
	  return output;
	};

	/**
	 * Base64 decodes a string into a 'binary' encoded string of bytes.
	 *
	 * @param input the base64-encoded input.
	 *
	 * @return the binary encoded string.
	 */
	util.decode64 = function(input) {
	  // TODO: deprecate: "Deprecated. Use util.binary.base64.decode instead."

	  // remove all non-base64 characters
	  input = input.replace(/[^A-Za-z0-9\+\/\=]/g, '');

	  var output = '';
	  var enc1, enc2, enc3, enc4;
	  var i = 0;

	  while(i < input.length) {
	    enc1 = _base64Idx[input.charCodeAt(i++) - 43];
	    enc2 = _base64Idx[input.charCodeAt(i++) - 43];
	    enc3 = _base64Idx[input.charCodeAt(i++) - 43];
	    enc4 = _base64Idx[input.charCodeAt(i++) - 43];

	    output += String.fromCharCode((enc1 << 2) | (enc2 >> 4));
	    if(enc3 !== 64) {
	      // decoded at least 2 bytes
	      output += String.fromCharCode(((enc2 & 15) << 4) | (enc3 >> 2));
	      if(enc4 !== 64) {
	        // decoded 3 bytes
	        output += String.fromCharCode(((enc3 & 3) << 6) | enc4);
	      }
	    }
	  }

	  return output;
	};

	/**
	 * Encodes the given string of characters (a standard JavaScript
	 * string) as a binary encoded string where the bytes represent
	 * a UTF-8 encoded string of characters. Non-ASCII characters will be
	 * encoded as multiple bytes according to UTF-8.
	 *
	 * @param str a standard string of characters to encode.
	 *
	 * @return the binary encoded string.
	 */
	util.encodeUtf8 = function(str) {
	  return unescape(encodeURIComponent(str));
	};

	/**
	 * Decodes a binary encoded string that contains bytes that
	 * represent a UTF-8 encoded string of characters -- into a
	 * string of characters (a standard JavaScript string).
	 *
	 * @param str the binary encoded string to decode.
	 *
	 * @return the resulting standard string of characters.
	 */
	util.decodeUtf8 = function(str) {
	  return decodeURIComponent(escape(str));
	};

	// binary encoding/decoding tools
	// FIXME: Experimental. Do not use yet.
	util.binary = {
	  raw: {},
	  hex: {},
	  base64: {},
	  base58: {},
	  baseN : {
	    encode: baseN.encode,
	    decode: baseN.decode
	  }
	};

	/**
	 * Encodes a Uint8Array as a binary-encoded string. This encoding uses
	 * a value between 0 and 255 for each character.
	 *
	 * @param bytes the Uint8Array to encode.
	 *
	 * @return the binary-encoded string.
	 */
	util.binary.raw.encode = function(bytes) {
	  return String.fromCharCode.apply(null, bytes);
	};

	/**
	 * Decodes a binary-encoded string to a Uint8Array. This encoding uses
	 * a value between 0 and 255 for each character.
	 *
	 * @param str the binary-encoded string to decode.
	 * @param [output] an optional Uint8Array to write the output to; if it
	 *          is too small, an exception will be thrown.
	 * @param [offset] the start offset for writing to the output (default: 0).
	 *
	 * @return the Uint8Array or the number of bytes written if output was given.
	 */
	util.binary.raw.decode = function(str, output, offset) {
	  var out = output;
	  if(!out) {
	    out = new Uint8Array(str.length);
	  }
	  offset = offset || 0;
	  var j = offset;
	  for(var i = 0; i < str.length; ++i) {
	    out[j++] = str.charCodeAt(i);
	  }
	  return output ? (j - offset) : out;
	};

	/**
	 * Encodes a 'binary' string, ArrayBuffer, DataView, TypedArray, or
	 * ByteBuffer as a string of hexadecimal characters.
	 *
	 * @param bytes the bytes to convert.
	 *
	 * @return the string of hexadecimal characters.
	 */
	util.binary.hex.encode = util.bytesToHex;

	/**
	 * Decodes a hex-encoded string to a Uint8Array.
	 *
	 * @param hex the hexadecimal string to convert.
	 * @param [output] an optional Uint8Array to write the output to; if it
	 *          is too small, an exception will be thrown.
	 * @param [offset] the start offset for writing to the output (default: 0).
	 *
	 * @return the Uint8Array or the number of bytes written if output was given.
	 */
	util.binary.hex.decode = function(hex, output, offset) {
	  var out = output;
	  if(!out) {
	    out = new Uint8Array(Math.ceil(hex.length / 2));
	  }
	  offset = offset || 0;
	  var i = 0, j = offset;
	  if(hex.length & 1) {
	    // odd number of characters, convert first character alone
	    i = 1;
	    out[j++] = parseInt(hex[0], 16);
	  }
	  // convert 2 characters (1 byte) at a time
	  for(; i < hex.length; i += 2) {
	    out[j++] = parseInt(hex.substr(i, 2), 16);
	  }
	  return output ? (j - offset) : out;
	};

	/**
	 * Base64-encodes a Uint8Array.
	 *
	 * @param input the Uint8Array to encode.
	 * @param maxline the maximum number of encoded characters per line to use,
	 *          defaults to none.
	 *
	 * @return the base64-encoded output string.
	 */
	util.binary.base64.encode = function(input, maxline) {
	  var line = '';
	  var output = '';
	  var chr1, chr2, chr3;
	  var i = 0;
	  while(i < input.byteLength) {
	    chr1 = input[i++];
	    chr2 = input[i++];
	    chr3 = input[i++];

	    // encode 4 character group
	    line += _base64.charAt(chr1 >> 2);
	    line += _base64.charAt(((chr1 & 3) << 4) | (chr2 >> 4));
	    if(isNaN(chr2)) {
	      line += '==';
	    } else {
	      line += _base64.charAt(((chr2 & 15) << 2) | (chr3 >> 6));
	      line += isNaN(chr3) ? '=' : _base64.charAt(chr3 & 63);
	    }

	    if(maxline && line.length > maxline) {
	      output += line.substr(0, maxline) + '\r\n';
	      line = line.substr(maxline);
	    }
	  }
	  output += line;
	  return output;
	};

	/**
	 * Decodes a base64-encoded string to a Uint8Array.
	 *
	 * @param input the base64-encoded input string.
	 * @param [output] an optional Uint8Array to write the output to; if it
	 *          is too small, an exception will be thrown.
	 * @param [offset] the start offset for writing to the output (default: 0).
	 *
	 * @return the Uint8Array or the number of bytes written if output was given.
	 */
	util.binary.base64.decode = function(input, output, offset) {
	  var out = output;
	  if(!out) {
	    out = new Uint8Array(Math.ceil(input.length / 4) * 3);
	  }

	  // remove all non-base64 characters
	  input = input.replace(/[^A-Za-z0-9\+\/\=]/g, '');

	  offset = offset || 0;
	  var enc1, enc2, enc3, enc4;
	  var i = 0, j = offset;

	  while(i < input.length) {
	    enc1 = _base64Idx[input.charCodeAt(i++) - 43];
	    enc2 = _base64Idx[input.charCodeAt(i++) - 43];
	    enc3 = _base64Idx[input.charCodeAt(i++) - 43];
	    enc4 = _base64Idx[input.charCodeAt(i++) - 43];

	    out[j++] = (enc1 << 2) | (enc2 >> 4);
	    if(enc3 !== 64) {
	      // decoded at least 2 bytes
	      out[j++] = ((enc2 & 15) << 4) | (enc3 >> 2);
	      if(enc4 !== 64) {
	        // decoded 3 bytes
	        out[j++] = ((enc3 & 3) << 6) | enc4;
	      }
	    }
	  }

	  // make sure result is the exact decoded length
	  return output ? (j - offset) : out.subarray(0, j);
	};

	// add support for base58 encoding/decoding with Bitcoin alphabet
	util.binary.base58.encode = function(input, maxline) {
	  return util.binary.baseN.encode(input, _base58, maxline);
	};
	util.binary.base58.decode = function(input, maxline) {
	  return util.binary.baseN.decode(input, _base58, maxline);
	};

	// text encoding/decoding tools
	// FIXME: Experimental. Do not use yet.
	util.text = {
	  utf8: {},
	  utf16: {}
	};

	/**
	 * Encodes the given string as UTF-8 in a Uint8Array.
	 *
	 * @param str the string to encode.
	 * @param [output] an optional Uint8Array to write the output to; if it
	 *          is too small, an exception will be thrown.
	 * @param [offset] the start offset for writing to the output (default: 0).
	 *
	 * @return the Uint8Array or the number of bytes written if output was given.
	 */
	util.text.utf8.encode = function(str, output, offset) {
	  str = util.encodeUtf8(str);
	  var out = output;
	  if(!out) {
	    out = new Uint8Array(str.length);
	  }
	  offset = offset || 0;
	  var j = offset;
	  for(var i = 0; i < str.length; ++i) {
	    out[j++] = str.charCodeAt(i);
	  }
	  return output ? (j - offset) : out;
	};

	/**
	 * Decodes the UTF-8 contents from a Uint8Array.
	 *
	 * @param bytes the Uint8Array to decode.
	 *
	 * @return the resulting string.
	 */
	util.text.utf8.decode = function(bytes) {
	  return util.decodeUtf8(String.fromCharCode.apply(null, bytes));
	};

	/**
	 * Encodes the given string as UTF-16 in a Uint8Array.
	 *
	 * @param str the string to encode.
	 * @param [output] an optional Uint8Array to write the output to; if it
	 *          is too small, an exception will be thrown.
	 * @param [offset] the start offset for writing to the output (default: 0).
	 *
	 * @return the Uint8Array or the number of bytes written if output was given.
	 */
	util.text.utf16.encode = function(str, output, offset) {
	  var out = output;
	  if(!out) {
	    out = new Uint8Array(str.length * 2);
	  }
	  var view = new Uint16Array(out.buffer);
	  offset = offset || 0;
	  var j = offset;
	  var k = offset;
	  for(var i = 0; i < str.length; ++i) {
	    view[k++] = str.charCodeAt(i);
	    j += 2;
	  }
	  return output ? (j - offset) : out;
	};

	/**
	 * Decodes the UTF-16 contents from a Uint8Array.
	 *
	 * @param bytes the Uint8Array to decode.
	 *
	 * @return the resulting string.
	 */
	util.text.utf16.decode = function(bytes) {
	  return String.fromCharCode.apply(null, new Uint16Array(bytes.buffer));
	};

	/**
	 * Deflates the given data using a flash interface.
	 *
	 * @param api the flash interface.
	 * @param bytes the data.
	 * @param raw true to return only raw deflate data, false to include zlib
	 *          header and trailer.
	 *
	 * @return the deflated data as a string.
	 */
	util.deflate = function(api, bytes, raw) {
	  bytes = util.decode64(api.deflate(util.encode64(bytes)).rval);

	  // strip zlib header and trailer if necessary
	  if(raw) {
	    // zlib header is 2 bytes (CMF,FLG) where FLG indicates that
	    // there is a 4-byte DICT (alder-32) block before the data if
	    // its 5th bit is set
	    var start = 2;
	    var flg = bytes.charCodeAt(1);
	    if(flg & 0x20) {
	      start = 6;
	    }
	    // zlib trailer is 4 bytes of adler-32
	    bytes = bytes.substring(start, bytes.length - 4);
	  }

	  return bytes;
	};

	/**
	 * Inflates the given data using a flash interface.
	 *
	 * @param api the flash interface.
	 * @param bytes the data.
	 * @param raw true if the incoming data has no zlib header or trailer and is
	 *          raw DEFLATE data.
	 *
	 * @return the inflated data as a string, null on error.
	 */
	util.inflate = function(api, bytes, raw) {
	  // TODO: add zlib header and trailer if necessary/possible
	  var rval = api.inflate(util.encode64(bytes)).rval;
	  return (rval === null) ? null : util.decode64(rval);
	};

	/**
	 * Sets a storage object.
	 *
	 * @param api the storage interface.
	 * @param id the storage ID to use.
	 * @param obj the storage object, null to remove.
	 */
	var _setStorageObject = function(api, id, obj) {
	  if(!api) {
	    throw new Error('WebStorage not available.');
	  }

	  var rval;
	  if(obj === null) {
	    rval = api.removeItem(id);
	  } else {
	    // json-encode and base64-encode object
	    obj = util.encode64(JSON.stringify(obj));
	    rval = api.setItem(id, obj);
	  }

	  // handle potential flash error
	  if(typeof(rval) !== 'undefined' && rval.rval !== true) {
	    var error = new Error(rval.error.message);
	    error.id = rval.error.id;
	    error.name = rval.error.name;
	    throw error;
	  }
	};

	/**
	 * Gets a storage object.
	 *
	 * @param api the storage interface.
	 * @param id the storage ID to use.
	 *
	 * @return the storage object entry or null if none exists.
	 */
	var _getStorageObject = function(api, id) {
	  if(!api) {
	    throw new Error('WebStorage not available.');
	  }

	  // get the existing entry
	  var rval = api.getItem(id);

	  /* Note: We check api.init because we can't do (api == localStorage)
	    on IE because of "Class doesn't support Automation" exception. Only
	    the flash api has an init method so this works too, but we need a
	    better solution in the future. */

	  // flash returns item wrapped in an object, handle special case
	  if(api.init) {
	    if(rval.rval === null) {
	      if(rval.error) {
	        var error = new Error(rval.error.message);
	        error.id = rval.error.id;
	        error.name = rval.error.name;
	        throw error;
	      }
	      // no error, but also no item
	      rval = null;
	    } else {
	      rval = rval.rval;
	    }
	  }

	  // handle decoding
	  if(rval !== null) {
	    // base64-decode and json-decode data
	    rval = JSON.parse(util.decode64(rval));
	  }

	  return rval;
	};

	/**
	 * Stores an item in local storage.
	 *
	 * @param api the storage interface.
	 * @param id the storage ID to use.
	 * @param key the key for the item.
	 * @param data the data for the item (any javascript object/primitive).
	 */
	var _setItem = function(api, id, key, data) {
	  // get storage object
	  var obj = _getStorageObject(api, id);
	  if(obj === null) {
	    // create a new storage object
	    obj = {};
	  }
	  // update key
	  obj[key] = data;

	  // set storage object
	  _setStorageObject(api, id, obj);
	};

	/**
	 * Gets an item from local storage.
	 *
	 * @param api the storage interface.
	 * @param id the storage ID to use.
	 * @param key the key for the item.
	 *
	 * @return the item.
	 */
	var _getItem = function(api, id, key) {
	  // get storage object
	  var rval = _getStorageObject(api, id);
	  if(rval !== null) {
	    // return data at key
	    rval = (key in rval) ? rval[key] : null;
	  }

	  return rval;
	};

	/**
	 * Removes an item from local storage.
	 *
	 * @param api the storage interface.
	 * @param id the storage ID to use.
	 * @param key the key for the item.
	 */
	var _removeItem = function(api, id, key) {
	  // get storage object
	  var obj = _getStorageObject(api, id);
	  if(obj !== null && key in obj) {
	    // remove key
	    delete obj[key];

	    // see if entry has no keys remaining
	    var empty = true;
	    for(var prop in obj) {
	      empty = false;
	      break;
	    }
	    if(empty) {
	      // remove entry entirely if no keys are left
	      obj = null;
	    }

	    // set storage object
	    _setStorageObject(api, id, obj);
	  }
	};

	/**
	 * Clears the local disk storage identified by the given ID.
	 *
	 * @param api the storage interface.
	 * @param id the storage ID to use.
	 */
	var _clearItems = function(api, id) {
	  _setStorageObject(api, id, null);
	};

	/**
	 * Calls a storage function.
	 *
	 * @param func the function to call.
	 * @param args the arguments for the function.
	 * @param location the location argument.
	 *
	 * @return the return value from the function.
	 */
	var _callStorageFunction = function(func, args, location) {
	  var rval = null;

	  // default storage types
	  if(typeof(location) === 'undefined') {
	    location = ['web', 'flash'];
	  }

	  // apply storage types in order of preference
	  var type;
	  var done = false;
	  var exception = null;
	  for(var idx in location) {
	    type = location[idx];
	    try {
	      if(type === 'flash' || type === 'both') {
	        if(args[0] === null) {
	          throw new Error('Flash local storage not available.');
	        }
	        rval = func.apply(this, args);
	        done = (type === 'flash');
	      }
	      if(type === 'web' || type === 'both') {
	        args[0] = localStorage;
	        rval = func.apply(this, args);
	        done = true;
	      }
	    } catch(ex) {
	      exception = ex;
	    }
	    if(done) {
	      break;
	    }
	  }

	  if(!done) {
	    throw exception;
	  }

	  return rval;
	};

	/**
	 * Stores an item on local disk.
	 *
	 * The available types of local storage include 'flash', 'web', and 'both'.
	 *
	 * The type 'flash' refers to flash local storage (SharedObject). In order
	 * to use flash local storage, the 'api' parameter must be valid. The type
	 * 'web' refers to WebStorage, if supported by the browser. The type 'both'
	 * refers to storing using both 'flash' and 'web', not just one or the
	 * other.
	 *
	 * The location array should list the storage types to use in order of
	 * preference:
	 *
	 * ['flash']: flash only storage
	 * ['web']: web only storage
	 * ['both']: try to store in both
	 * ['flash','web']: store in flash first, but if not available, 'web'
	 * ['web','flash']: store in web first, but if not available, 'flash'
	 *
	 * The location array defaults to: ['web', 'flash']
	 *
	 * @param api the flash interface, null to use only WebStorage.
	 * @param id the storage ID to use.
	 * @param key the key for the item.
	 * @param data the data for the item (any javascript object/primitive).
	 * @param location an array with the preferred types of storage to use.
	 */
	util.setItem = function(api, id, key, data, location) {
	  _callStorageFunction(_setItem, arguments, location);
	};

	/**
	 * Gets an item on local disk.
	 *
	 * Set setItem() for details on storage types.
	 *
	 * @param api the flash interface, null to use only WebStorage.
	 * @param id the storage ID to use.
	 * @param key the key for the item.
	 * @param location an array with the preferred types of storage to use.
	 *
	 * @return the item.
	 */
	util.getItem = function(api, id, key, location) {
	  return _callStorageFunction(_getItem, arguments, location);
	};

	/**
	 * Removes an item on local disk.
	 *
	 * Set setItem() for details on storage types.
	 *
	 * @param api the flash interface.
	 * @param id the storage ID to use.
	 * @param key the key for the item.
	 * @param location an array with the preferred types of storage to use.
	 */
	util.removeItem = function(api, id, key, location) {
	  _callStorageFunction(_removeItem, arguments, location);
	};

	/**
	 * Clears the local disk storage identified by the given ID.
	 *
	 * Set setItem() for details on storage types.
	 *
	 * @param api the flash interface if flash is available.
	 * @param id the storage ID to use.
	 * @param location an array with the preferred types of storage to use.
	 */
	util.clearItems = function(api, id, location) {
	  _callStorageFunction(_clearItems, arguments, location);
	};

	/**
	 * Parses the scheme, host, and port from an http(s) url.
	 *
	 * @param str the url string.
	 *
	 * @return the parsed url object or null if the url is invalid.
	 */
	util.parseUrl = function(str) {
	  // FIXME: this regex looks a bit broken
	  var regex = /^(https?):\/\/([^:&^\/]*):?(\d*)(.*)$/g;
	  regex.lastIndex = 0;
	  var m = regex.exec(str);
	  var url = (m === null) ? null : {
	    full: str,
	    scheme: m[1],
	    host: m[2],
	    port: m[3],
	    path: m[4]
	  };
	  if(url) {
	    url.fullHost = url.host;
	    if(url.port) {
	      if(url.port !== 80 && url.scheme === 'http') {
	        url.fullHost += ':' + url.port;
	      } else if(url.port !== 443 && url.scheme === 'https') {
	        url.fullHost += ':' + url.port;
	      }
	    } else if(url.scheme === 'http') {
	      url.port = 80;
	    } else if(url.scheme === 'https') {
	      url.port = 443;
	    }
	    url.full = url.scheme + '://' + url.fullHost;
	  }
	  return url;
	};

	/* Storage for query variables */
	var _queryVariables = null;

	/**
	 * Returns the window location query variables. Query is parsed on the first
	 * call and the same object is returned on subsequent calls. The mapping
	 * is from keys to an array of values. Parameters without values will have
	 * an object key set but no value added to the value array. Values are
	 * unescaped.
	 *
	 * ...?k1=v1&k2=v2:
	 * {
	 *   "k1": ["v1"],
	 *   "k2": ["v2"]
	 * }
	 *
	 * ...?k1=v1&k1=v2:
	 * {
	 *   "k1": ["v1", "v2"]
	 * }
	 *
	 * ...?k1=v1&k2:
	 * {
	 *   "k1": ["v1"],
	 *   "k2": []
	 * }
	 *
	 * ...?k1=v1&k1:
	 * {
	 *   "k1": ["v1"]
	 * }
	 *
	 * ...?k1&k1:
	 * {
	 *   "k1": []
	 * }
	 *
	 * @param query the query string to parse (optional, default to cached
	 *          results from parsing window location search query).
	 *
	 * @return object mapping keys to variables.
	 */
	util.getQueryVariables = function(query) {
	  var parse = function(q) {
	    var rval = {};
	    var kvpairs = q.split('&');
	    for(var i = 0; i < kvpairs.length; i++) {
	      var pos = kvpairs[i].indexOf('=');
	      var key;
	      var val;
	      if(pos > 0) {
	        key = kvpairs[i].substring(0, pos);
	        val = kvpairs[i].substring(pos + 1);
	      } else {
	        key = kvpairs[i];
	        val = null;
	      }
	      if(!(key in rval)) {
	        rval[key] = [];
	      }
	      // disallow overriding object prototype keys
	      if(!(key in Object.prototype) && val !== null) {
	        rval[key].push(unescape(val));
	      }
	    }
	    return rval;
	  };

	   var rval;
	   if(typeof(query) === 'undefined') {
	     // set cached variables if needed
	     if(_queryVariables === null) {
	       if(typeof(window) !== 'undefined' && window.location && window.location.search) {
	          // parse window search query
	          _queryVariables = parse(window.location.search.substring(1));
	       } else {
	          // no query variables available
	          _queryVariables = {};
	       }
	     }
	     rval = _queryVariables;
	   } else {
	     // parse given query
	     rval = parse(query);
	   }
	   return rval;
	};

	/**
	 * Parses a fragment into a path and query. This method will take a URI
	 * fragment and break it up as if it were the main URI. For example:
	 *    /bar/baz?a=1&b=2
	 * results in:
	 *    {
	 *       path: ["bar", "baz"],
	 *       query: {"k1": ["v1"], "k2": ["v2"]}
	 *    }
	 *
	 * @return object with a path array and query object.
	 */
	util.parseFragment = function(fragment) {
	  // default to whole fragment
	  var fp = fragment;
	  var fq = '';
	  // split into path and query if possible at the first '?'
	  var pos = fragment.indexOf('?');
	  if(pos > 0) {
	    fp = fragment.substring(0, pos);
	    fq = fragment.substring(pos + 1);
	  }
	  // split path based on '/' and ignore first element if empty
	  var path = fp.split('/');
	  if(path.length > 0 && path[0] === '') {
	    path.shift();
	  }
	  // convert query into object
	  var query = (fq === '') ? {} : util.getQueryVariables(fq);

	  return {
	    pathString: fp,
	    queryString: fq,
	    path: path,
	    query: query
	  };
	};

	/**
	 * Makes a request out of a URI-like request string. This is intended to
	 * be used where a fragment id (after a URI '#') is parsed as a URI with
	 * path and query parts. The string should have a path beginning and
	 * delimited by '/' and optional query parameters following a '?'. The
	 * query should be a standard URL set of key value pairs delimited by
	 * '&'. For backwards compatibility the initial '/' on the path is not
	 * required. The request object has the following API, (fully described
	 * in the method code):
	 *    {
	 *       path: <the path string part>.
	 *       query: <the query string part>,
	 *       getPath(i): get part or all of the split path array,
	 *       getQuery(k, i): get part or all of a query key array,
	 *       getQueryLast(k, _default): get last element of a query key array.
	 *    }
	 *
	 * @return object with request parameters.
	 */
	util.makeRequest = function(reqString) {
	  var frag = util.parseFragment(reqString);
	  var req = {
	    // full path string
	    path: frag.pathString,
	    // full query string
	    query: frag.queryString,
	    /**
	     * Get path or element in path.
	     *
	     * @param i optional path index.
	     *
	     * @return path or part of path if i provided.
	     */
	    getPath: function(i) {
	      return (typeof(i) === 'undefined') ? frag.path : frag.path[i];
	    },
	    /**
	     * Get query, values for a key, or value for a key index.
	     *
	     * @param k optional query key.
	     * @param i optional query key index.
	     *
	     * @return query, values for a key, or value for a key index.
	     */
	    getQuery: function(k, i) {
	      var rval;
	      if(typeof(k) === 'undefined') {
	        rval = frag.query;
	      } else {
	        rval = frag.query[k];
	        if(rval && typeof(i) !== 'undefined') {
	           rval = rval[i];
	        }
	      }
	      return rval;
	    },
	    getQueryLast: function(k, _default) {
	      var rval;
	      var vals = req.getQuery(k);
	      if(vals) {
	        rval = vals[vals.length - 1];
	      } else {
	        rval = _default;
	      }
	      return rval;
	    }
	  };
	  return req;
	};

	/**
	 * Makes a URI out of a path, an object with query parameters, and a
	 * fragment. Uses jQuery.param() internally for query string creation.
	 * If the path is an array, it will be joined with '/'.
	 *
	 * @param path string path or array of strings.
	 * @param query object with query parameters. (optional)
	 * @param fragment fragment string. (optional)
	 *
	 * @return string object with request parameters.
	 */
	util.makeLink = function(path, query, fragment) {
	  // join path parts if needed
	  path = jQuery.isArray(path) ? path.join('/') : path;

	  var qstr = jQuery.param(query || {});
	  fragment = fragment || '';
	  return path +
	    ((qstr.length > 0) ? ('?' + qstr) : '') +
	    ((fragment.length > 0) ? ('#' + fragment) : '');
	};

	/**
	 * Check if an object is empty.
	 *
	 * Taken from:
	 * http://stackoverflow.com/questions/679915/how-do-i-test-for-an-empty-javascript-object-from-json/679937#679937
	 *
	 * @param object the object to check.
	 */
	util.isEmpty = function(obj) {
	  for(var prop in obj) {
	    if(obj.hasOwnProperty(prop)) {
	      return false;
	    }
	  }
	  return true;
	};

	/**
	 * Format with simple printf-style interpolation.
	 *
	 * %%: literal '%'
	 * %s,%o: convert next argument into a string.
	 *
	 * @param format the string to format.
	 * @param ... arguments to interpolate into the format string.
	 */
	util.format = function(format) {
	  var re = /%./g;
	  // current match
	  var match;
	  // current part
	  var part;
	  // current arg index
	  var argi = 0;
	  // collected parts to recombine later
	  var parts = [];
	  // last index found
	  var last = 0;
	  // loop while matches remain
	  while((match = re.exec(format))) {
	    part = format.substring(last, re.lastIndex - 2);
	    // don't add empty strings (ie, parts between %s%s)
	    if(part.length > 0) {
	      parts.push(part);
	    }
	    last = re.lastIndex;
	    // switch on % code
	    var code = match[0][1];
	    switch(code) {
	    case 's':
	    case 'o':
	      // check if enough arguments were given
	      if(argi < arguments.length) {
	        parts.push(arguments[argi++ + 1]);
	      } else {
	        parts.push('<?>');
	      }
	      break;
	    // FIXME: do proper formating for numbers, etc
	    //case 'f':
	    //case 'd':
	    case '%':
	      parts.push('%');
	      break;
	    default:
	      parts.push('<%' + code + '?>');
	    }
	  }
	  // add trailing part of format string
	  parts.push(format.substring(last));
	  return parts.join('');
	};

	/**
	 * Formats a number.
	 *
	 * http://snipplr.com/view/5945/javascript-numberformat--ported-from-php/
	 */
	util.formatNumber = function(number, decimals, dec_point, thousands_sep) {
	  // http://kevin.vanzonneveld.net
	  // +   original by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
	  // +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
	  // +     bugfix by: Michael White (http://crestidg.com)
	  // +     bugfix by: Benjamin Lupton
	  // +     bugfix by: Allan Jensen (http://www.winternet.no)
	  // +    revised by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
	  // *     example 1: number_format(1234.5678, 2, '.', '');
	  // *     returns 1: 1234.57

	  var n = number, c = isNaN(decimals = Math.abs(decimals)) ? 2 : decimals;
	  var d = dec_point === undefined ? ',' : dec_point;
	  var t = thousands_sep === undefined ?
	   '.' : thousands_sep, s = n < 0 ? '-' : '';
	  var i = parseInt((n = Math.abs(+n || 0).toFixed(c)), 10) + '';
	  var j = (i.length > 3) ? i.length % 3 : 0;
	  return s + (j ? i.substr(0, j) + t : '') +
	    i.substr(j).replace(/(\d{3})(?=\d)/g, '$1' + t) +
	    (c ? d + Math.abs(n - i).toFixed(c).slice(2) : '');
	};

	/**
	 * Formats a byte size.
	 *
	 * http://snipplr.com/view/5949/format-humanize-file-byte-size-presentation-in-javascript/
	 */
	util.formatSize = function(size) {
	  if(size >= 1073741824) {
	    size = util.formatNumber(size / 1073741824, 2, '.', '') + ' GiB';
	  } else if(size >= 1048576) {
	    size = util.formatNumber(size / 1048576, 2, '.', '') + ' MiB';
	  } else if(size >= 1024) {
	    size = util.formatNumber(size / 1024, 0) + ' KiB';
	  } else {
	    size = util.formatNumber(size, 0) + ' bytes';
	  }
	  return size;
	};

	/**
	 * Converts an IPv4 or IPv6 string representation into bytes (in network order).
	 *
	 * @param ip the IPv4 or IPv6 address to convert.
	 *
	 * @return the 4-byte IPv6 or 16-byte IPv6 address or null if the address can't
	 *         be parsed.
	 */
	util.bytesFromIP = function(ip) {
	  if(ip.indexOf('.') !== -1) {
	    return util.bytesFromIPv4(ip);
	  }
	  if(ip.indexOf(':') !== -1) {
	    return util.bytesFromIPv6(ip);
	  }
	  return null;
	};

	/**
	 * Converts an IPv4 string representation into bytes (in network order).
	 *
	 * @param ip the IPv4 address to convert.
	 *
	 * @return the 4-byte address or null if the address can't be parsed.
	 */
	util.bytesFromIPv4 = function(ip) {
	  ip = ip.split('.');
	  if(ip.length !== 4) {
	    return null;
	  }
	  var b = util.createBuffer();
	  for(var i = 0; i < ip.length; ++i) {
	    var num = parseInt(ip[i], 10);
	    if(isNaN(num)) {
	      return null;
	    }
	    b.putByte(num);
	  }
	  return b.getBytes();
	};

	/**
	 * Converts an IPv6 string representation into bytes (in network order).
	 *
	 * @param ip the IPv6 address to convert.
	 *
	 * @return the 16-byte address or null if the address can't be parsed.
	 */
	util.bytesFromIPv6 = function(ip) {
	  var blanks = 0;
	  ip = ip.split(':').filter(function(e) {
	    if(e.length === 0) ++blanks;
	    return true;
	  });
	  var zeros = (8 - ip.length + blanks) * 2;
	  var b = util.createBuffer();
	  for(var i = 0; i < 8; ++i) {
	    if(!ip[i] || ip[i].length === 0) {
	      b.fillWithByte(0, zeros);
	      zeros = 0;
	      continue;
	    }
	    var bytes = util.hexToBytes(ip[i]);
	    if(bytes.length < 2) {
	      b.putByte(0);
	    }
	    b.putBytes(bytes);
	  }
	  return b.getBytes();
	};

	/**
	 * Converts 4-bytes into an IPv4 string representation or 16-bytes into
	 * an IPv6 string representation. The bytes must be in network order.
	 *
	 * @param bytes the bytes to convert.
	 *
	 * @return the IPv4 or IPv6 string representation if 4 or 16 bytes,
	 *         respectively, are given, otherwise null.
	 */
	util.bytesToIP = function(bytes) {
	  if(bytes.length === 4) {
	    return util.bytesToIPv4(bytes);
	  }
	  if(bytes.length === 16) {
	    return util.bytesToIPv6(bytes);
	  }
	  return null;
	};

	/**
	 * Converts 4-bytes into an IPv4 string representation. The bytes must be
	 * in network order.
	 *
	 * @param bytes the bytes to convert.
	 *
	 * @return the IPv4 string representation or null for an invalid # of bytes.
	 */
	util.bytesToIPv4 = function(bytes) {
	  if(bytes.length !== 4) {
	    return null;
	  }
	  var ip = [];
	  for(var i = 0; i < bytes.length; ++i) {
	    ip.push(bytes.charCodeAt(i));
	  }
	  return ip.join('.');
	};

	/**
	 * Converts 16-bytes into an IPv16 string representation. The bytes must be
	 * in network order.
	 *
	 * @param bytes the bytes to convert.
	 *
	 * @return the IPv16 string representation or null for an invalid # of bytes.
	 */
	util.bytesToIPv6 = function(bytes) {
	  if(bytes.length !== 16) {
	    return null;
	  }
	  var ip = [];
	  var zeroGroups = [];
	  var zeroMaxGroup = 0;
	  for(var i = 0; i < bytes.length; i += 2) {
	    var hex = util.bytesToHex(bytes[i] + bytes[i + 1]);
	    // canonicalize zero representation
	    while(hex[0] === '0' && hex !== '0') {
	      hex = hex.substr(1);
	    }
	    if(hex === '0') {
	      var last = zeroGroups[zeroGroups.length - 1];
	      var idx = ip.length;
	      if(!last || idx !== last.end + 1) {
	        zeroGroups.push({start: idx, end: idx});
	      } else {
	        last.end = idx;
	        if((last.end - last.start) >
	          (zeroGroups[zeroMaxGroup].end - zeroGroups[zeroMaxGroup].start)) {
	          zeroMaxGroup = zeroGroups.length - 1;
	        }
	      }
	    }
	    ip.push(hex);
	  }
	  if(zeroGroups.length > 0) {
	    var group = zeroGroups[zeroMaxGroup];
	    // only shorten group of length > 0
	    if(group.end - group.start > 0) {
	      ip.splice(group.start, group.end - group.start + 1, '');
	      if(group.start === 0) {
	        ip.unshift('');
	      }
	      if(group.end === 7) {
	        ip.push('');
	      }
	    }
	  }
	  return ip.join(':');
	};

	/**
	 * Estimates the number of processes that can be run concurrently. If
	 * creating Web Workers, keep in mind that the main JavaScript process needs
	 * its own core.
	 *
	 * @param options the options to use:
	 *          update true to force an update (not use the cached value).
	 * @param callback(err, max) called once the operation completes.
	 */
	util.estimateCores = function(options, callback) {
	  if(typeof options === 'function') {
	    callback = options;
	    options = {};
	  }
	  options = options || {};
	  if('cores' in util && !options.update) {
	    return callback(null, util.cores);
	  }
	  if(typeof navigator !== 'undefined' &&
	    'hardwareConcurrency' in navigator &&
	    navigator.hardwareConcurrency > 0) {
	    util.cores = navigator.hardwareConcurrency;
	    return callback(null, util.cores);
	  }
	  if(typeof Worker === 'undefined') {
	    // workers not available
	    util.cores = 1;
	    return callback(null, util.cores);
	  }
	  if(typeof Blob === 'undefined') {
	    // can't estimate, default to 2
	    util.cores = 2;
	    return callback(null, util.cores);
	  }

	  // create worker concurrency estimation code as blob
	  var blobUrl = URL.createObjectURL(new Blob(['(',
	    function() {
	      self.addEventListener('message', function(e) {
	        // run worker for 4 ms
	        var st = Date.now();
	        var et = st + 4;
	        self.postMessage({st: st, et: et});
	      });
	    }.toString(),
	  ')()'], {type: 'application/javascript'}));

	  // take 5 samples using 16 workers
	  sample([], 5, 16);

	  function sample(max, samples, numWorkers) {
	    if(samples === 0) {
	      // get overlap average
	      var avg = Math.floor(max.reduce(function(avg, x) {
	        return avg + x;
	      }, 0) / max.length);
	      util.cores = Math.max(1, avg);
	      URL.revokeObjectURL(blobUrl);
	      return callback(null, util.cores);
	    }
	    map(numWorkers, function(err, results) {
	      max.push(reduce(numWorkers, results));
	      sample(max, samples - 1, numWorkers);
	    });
	  }

	  function map(numWorkers, callback) {
	    var workers = [];
	    var results = [];
	    for(var i = 0; i < numWorkers; ++i) {
	      var worker = new Worker(blobUrl);
	      worker.addEventListener('message', function(e) {
	        results.push(e.data);
	        if(results.length === numWorkers) {
	          for(var i = 0; i < numWorkers; ++i) {
	            workers[i].terminate();
	          }
	          callback(null, results);
	        }
	      });
	      workers.push(worker);
	    }
	    for(var i = 0; i < numWorkers; ++i) {
	      workers[i].postMessage(i);
	    }
	  }

	  function reduce(numWorkers, results) {
	    // find overlapping time windows
	    var overlaps = [];
	    for(var n = 0; n < numWorkers; ++n) {
	      var r1 = results[n];
	      var overlap = overlaps[n] = [];
	      for(var i = 0; i < numWorkers; ++i) {
	        if(n === i) {
	          continue;
	        }
	        var r2 = results[i];
	        if((r1.st > r2.st && r1.st < r2.et) ||
	          (r2.st > r1.st && r2.st < r1.et)) {
	          overlap.push(i);
	        }
	      }
	    }
	    // get maximum overlaps ... don't include overlapping worker itself
	    // as the main JS process was also being scheduled during the work and
	    // would have to be subtracted from the estimate anyway
	    return overlaps.reduce(function(max, overlap) {
	      return Math.max(max, overlap.length);
	    }, 0);
	  }
	};
	});

	/**
	 * Cipher base API.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2014 Digital Bazaar, Inc.
	 */



	forge.cipher = forge.cipher || {};

	// registered algorithms
	forge.cipher.algorithms = forge.cipher.algorithms || {};

	/**
	 * Creates a cipher object that can be used to encrypt data using the given
	 * algorithm and key. The algorithm may be provided as a string value for a
	 * previously registered algorithm or it may be given as a cipher algorithm
	 * API object.
	 *
	 * @param algorithm the algorithm to use, either a string or an algorithm API
	 *          object.
	 * @param key the key to use, as a binary-encoded string of bytes or a
	 *          byte buffer.
	 *
	 * @return the cipher.
	 */
	forge.cipher.createCipher = function(algorithm, key) {
	  var api = algorithm;
	  if(typeof api === 'string') {
	    api = forge.cipher.getAlgorithm(api);
	    if(api) {
	      api = api();
	    }
	  }
	  if(!api) {
	    throw new Error('Unsupported algorithm: ' + algorithm);
	  }

	  // assume block cipher
	  return new forge.cipher.BlockCipher({
	    algorithm: api,
	    key: key,
	    decrypt: false
	  });
	};

	/**
	 * Creates a decipher object that can be used to decrypt data using the given
	 * algorithm and key. The algorithm may be provided as a string value for a
	 * previously registered algorithm or it may be given as a cipher algorithm
	 * API object.
	 *
	 * @param algorithm the algorithm to use, either a string or an algorithm API
	 *          object.
	 * @param key the key to use, as a binary-encoded string of bytes or a
	 *          byte buffer.
	 *
	 * @return the cipher.
	 */
	forge.cipher.createDecipher = function(algorithm, key) {
	  var api = algorithm;
	  if(typeof api === 'string') {
	    api = forge.cipher.getAlgorithm(api);
	    if(api) {
	      api = api();
	    }
	  }
	  if(!api) {
	    throw new Error('Unsupported algorithm: ' + algorithm);
	  }

	  // assume block cipher
	  return new forge.cipher.BlockCipher({
	    algorithm: api,
	    key: key,
	    decrypt: true
	  });
	};

	/**
	 * Registers an algorithm by name. If the name was already registered, the
	 * algorithm API object will be overwritten.
	 *
	 * @param name the name of the algorithm.
	 * @param algorithm the algorithm API object.
	 */
	forge.cipher.registerAlgorithm = function(name, algorithm) {
	  name = name.toUpperCase();
	  forge.cipher.algorithms[name] = algorithm;
	};

	/**
	 * Gets a registered algorithm by name.
	 *
	 * @param name the name of the algorithm.
	 *
	 * @return the algorithm, if found, null if not.
	 */
	forge.cipher.getAlgorithm = function(name) {
	  name = name.toUpperCase();
	  if(name in forge.cipher.algorithms) {
	    return forge.cipher.algorithms[name];
	  }
	  return null;
	};

	var BlockCipher = forge.cipher.BlockCipher = function(options) {
	  this.algorithm = options.algorithm;
	  this.mode = this.algorithm.mode;
	  this.blockSize = this.mode.blockSize;
	  this._finish = false;
	  this._input = null;
	  this.output = null;
	  this._op = options.decrypt ? this.mode.decrypt : this.mode.encrypt;
	  this._decrypt = options.decrypt;
	  this.algorithm.initialize(options);
	};

	/**
	 * Starts or restarts the encryption or decryption process, whichever
	 * was previously configured.
	 *
	 * For non-GCM mode, the IV may be a binary-encoded string of bytes, an array
	 * of bytes, a byte buffer, or an array of 32-bit integers. If the IV is in
	 * bytes, then it must be Nb (16) bytes in length. If the IV is given in as
	 * 32-bit integers, then it must be 4 integers long.
	 *
	 * Note: an IV is not required or used in ECB mode.
	 *
	 * For GCM-mode, the IV must be given as a binary-encoded string of bytes or
	 * a byte buffer. The number of bytes should be 12 (96 bits) as recommended
	 * by NIST SP-800-38D but another length may be given.
	 *
	 * @param options the options to use:
	 *          iv the initialization vector to use as a binary-encoded string of
	 *            bytes, null to reuse the last ciphered block from a previous
	 *            update() (this "residue" method is for legacy support only).
	 *          additionalData additional authentication data as a binary-encoded
	 *            string of bytes, for 'GCM' mode, (default: none).
	 *          tagLength desired length of authentication tag, in bits, for
	 *            'GCM' mode (0-128, default: 128).
	 *          tag the authentication tag to check if decrypting, as a
	 *             binary-encoded string of bytes.
	 *          output the output the buffer to write to, null to create one.
	 */
	BlockCipher.prototype.start = function(options) {
	  options = options || {};
	  var opts = {};
	  for(var key in options) {
	    opts[key] = options[key];
	  }
	  opts.decrypt = this._decrypt;
	  this._finish = false;
	  this._input = forge.util.createBuffer();
	  this.output = options.output || forge.util.createBuffer();
	  this.mode.start(opts);
	};

	/**
	 * Updates the next block according to the cipher mode.
	 *
	 * @param input the buffer to read from.
	 */
	BlockCipher.prototype.update = function(input) {
	  if(input) {
	    // input given, so empty it into the input buffer
	    this._input.putBuffer(input);
	  }

	  // do cipher operation until it needs more input and not finished
	  while(!this._op.call(this.mode, this._input, this.output, this._finish) &&
	    !this._finish) {}

	  // free consumed memory from input buffer
	  this._input.compact();
	};

	/**
	 * Finishes encrypting or decrypting.
	 *
	 * @param pad a padding function to use in CBC mode, null for default,
	 *          signature(blockSize, buffer, decrypt).
	 *
	 * @return true if successful, false on error.
	 */
	BlockCipher.prototype.finish = function(pad) {
	  // backwards-compatibility w/deprecated padding API
	  // Note: will overwrite padding functions even after another start() call
	  if(pad && (this.mode.name === 'ECB' || this.mode.name === 'CBC')) {
	    this.mode.pad = function(input) {
	      return pad(this.blockSize, input, false);
	    };
	    this.mode.unpad = function(output) {
	      return pad(this.blockSize, output, true);
	    };
	  }

	  // build options for padding and afterFinish functions
	  var options = {};
	  options.decrypt = this._decrypt;

	  // get # of bytes that won't fill a block
	  options.overflow = this._input.length() % this.blockSize;

	  if(!this._decrypt && this.mode.pad) {
	    if(!this.mode.pad(this._input, options)) {
	      return false;
	    }
	  }

	  // do final update
	  this._finish = true;
	  this.update();

	  if(this._decrypt && this.mode.unpad) {
	    if(!this.mode.unpad(this.output, options)) {
	      return false;
	    }
	  }

	  if(this.mode.afterFinish) {
	    if(!this.mode.afterFinish(this.output, options)) {
	      return false;
	    }
	  }

	  return true;
	};

	createCommonjsModule(function (module) {
	/**
	 * Supported cipher modes.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2014 Digital Bazaar, Inc.
	 */



	forge.cipher = forge.cipher || {};

	// supported cipher modes
	var modes = module.exports = forge.cipher.modes = forge.cipher.modes || {};

	/** Electronic codebook (ECB) (Don't use this; it's not secure) **/

	modes.ecb = function(options) {
	  options = options || {};
	  this.name = 'ECB';
	  this.cipher = options.cipher;
	  this.blockSize = options.blockSize || 16;
	  this._ints = this.blockSize / 4;
	  this._inBlock = new Array(this._ints);
	  this._outBlock = new Array(this._ints);
	};

	modes.ecb.prototype.start = function(options) {};

	modes.ecb.prototype.encrypt = function(input, output, finish) {
	  // not enough input to encrypt
	  if(input.length() < this.blockSize && !(finish && input.length() > 0)) {
	    return true;
	  }

	  // get next block
	  for(var i = 0; i < this._ints; ++i) {
	    this._inBlock[i] = input.getInt32();
	  }

	  // encrypt block
	  this.cipher.encrypt(this._inBlock, this._outBlock);

	  // write output
	  for(var i = 0; i < this._ints; ++i) {
	    output.putInt32(this._outBlock[i]);
	  }
	};

	modes.ecb.prototype.decrypt = function(input, output, finish) {
	  // not enough input to decrypt
	  if(input.length() < this.blockSize && !(finish && input.length() > 0)) {
	    return true;
	  }

	  // get next block
	  for(var i = 0; i < this._ints; ++i) {
	    this._inBlock[i] = input.getInt32();
	  }

	  // decrypt block
	  this.cipher.decrypt(this._inBlock, this._outBlock);

	  // write output
	  for(var i = 0; i < this._ints; ++i) {
	    output.putInt32(this._outBlock[i]);
	  }
	};

	modes.ecb.prototype.pad = function(input, options) {
	  // add PKCS#7 padding to block (each pad byte is the
	  // value of the number of pad bytes)
	  var padding = (input.length() === this.blockSize ?
	    this.blockSize : (this.blockSize - input.length()));
	  input.fillWithByte(padding, padding);
	  return true;
	};

	modes.ecb.prototype.unpad = function(output, options) {
	  // check for error: input data not a multiple of blockSize
	  if(options.overflow > 0) {
	    return false;
	  }

	  // ensure padding byte count is valid
	  var len = output.length();
	  var count = output.at(len - 1);
	  if(count > (this.blockSize << 2)) {
	    return false;
	  }

	  // trim off padding bytes
	  output.truncate(count);
	  return true;
	};

	/** Cipher-block Chaining (CBC) **/

	modes.cbc = function(options) {
	  options = options || {};
	  this.name = 'CBC';
	  this.cipher = options.cipher;
	  this.blockSize = options.blockSize || 16;
	  this._ints = this.blockSize / 4;
	  this._inBlock = new Array(this._ints);
	  this._outBlock = new Array(this._ints);
	};

	modes.cbc.prototype.start = function(options) {
	  // Note: legacy support for using IV residue (has security flaws)
	  // if IV is null, reuse block from previous processing
	  if(options.iv === null) {
	    // must have a previous block
	    if(!this._prev) {
	      throw new Error('Invalid IV parameter.');
	    }
	    this._iv = this._prev.slice(0);
	  } else if(!('iv' in options)) {
	    throw new Error('Invalid IV parameter.');
	  } else {
	    // save IV as "previous" block
	    this._iv = transformIV(options.iv, this.blockSize);
	    this._prev = this._iv.slice(0);
	  }
	};

	modes.cbc.prototype.encrypt = function(input, output, finish) {
	  // not enough input to encrypt
	  if(input.length() < this.blockSize && !(finish && input.length() > 0)) {
	    return true;
	  }

	  // get next block
	  // CBC XOR's IV (or previous block) with plaintext
	  for(var i = 0; i < this._ints; ++i) {
	    this._inBlock[i] = this._prev[i] ^ input.getInt32();
	  }

	  // encrypt block
	  this.cipher.encrypt(this._inBlock, this._outBlock);

	  // write output, save previous block
	  for(var i = 0; i < this._ints; ++i) {
	    output.putInt32(this._outBlock[i]);
	  }
	  this._prev = this._outBlock;
	};

	modes.cbc.prototype.decrypt = function(input, output, finish) {
	  // not enough input to decrypt
	  if(input.length() < this.blockSize && !(finish && input.length() > 0)) {
	    return true;
	  }

	  // get next block
	  for(var i = 0; i < this._ints; ++i) {
	    this._inBlock[i] = input.getInt32();
	  }

	  // decrypt block
	  this.cipher.decrypt(this._inBlock, this._outBlock);

	  // write output, save previous ciphered block
	  // CBC XOR's IV (or previous block) with ciphertext
	  for(var i = 0; i < this._ints; ++i) {
	    output.putInt32(this._prev[i] ^ this._outBlock[i]);
	  }
	  this._prev = this._inBlock.slice(0);
	};

	modes.cbc.prototype.pad = function(input, options) {
	  // add PKCS#7 padding to block (each pad byte is the
	  // value of the number of pad bytes)
	  var padding = (input.length() === this.blockSize ?
	    this.blockSize : (this.blockSize - input.length()));
	  input.fillWithByte(padding, padding);
	  return true;
	};

	modes.cbc.prototype.unpad = function(output, options) {
	  // check for error: input data not a multiple of blockSize
	  if(options.overflow > 0) {
	    return false;
	  }

	  // ensure padding byte count is valid
	  var len = output.length();
	  var count = output.at(len - 1);
	  if(count > (this.blockSize << 2)) {
	    return false;
	  }

	  // trim off padding bytes
	  output.truncate(count);
	  return true;
	};

	/** Cipher feedback (CFB) **/

	modes.cfb = function(options) {
	  options = options || {};
	  this.name = 'CFB';
	  this.cipher = options.cipher;
	  this.blockSize = options.blockSize || 16;
	  this._ints = this.blockSize / 4;
	  this._inBlock = null;
	  this._outBlock = new Array(this._ints);
	  this._partialBlock = new Array(this._ints);
	  this._partialOutput = forge.util.createBuffer();
	  this._partialBytes = 0;
	};

	modes.cfb.prototype.start = function(options) {
	  if(!('iv' in options)) {
	    throw new Error('Invalid IV parameter.');
	  }
	  // use IV as first input
	  this._iv = transformIV(options.iv, this.blockSize);
	  this._inBlock = this._iv.slice(0);
	  this._partialBytes = 0;
	};

	modes.cfb.prototype.encrypt = function(input, output, finish) {
	  // not enough input to encrypt
	  var inputLength = input.length();
	  if(inputLength === 0) {
	    return true;
	  }

	  // encrypt block
	  this.cipher.encrypt(this._inBlock, this._outBlock);

	  // handle full block
	  if(this._partialBytes === 0 && inputLength >= this.blockSize) {
	    // XOR input with output, write input as output
	    for(var i = 0; i < this._ints; ++i) {
	      this._inBlock[i] = input.getInt32() ^ this._outBlock[i];
	      output.putInt32(this._inBlock[i]);
	    }
	    return;
	  }

	  // handle partial block
	  var partialBytes = (this.blockSize - inputLength) % this.blockSize;
	  if(partialBytes > 0) {
	    partialBytes = this.blockSize - partialBytes;
	  }

	  // XOR input with output, write input as partial output
	  this._partialOutput.clear();
	  for(var i = 0; i < this._ints; ++i) {
	    this._partialBlock[i] = input.getInt32() ^ this._outBlock[i];
	    this._partialOutput.putInt32(this._partialBlock[i]);
	  }

	  if(partialBytes > 0) {
	    // block still incomplete, restore input buffer
	    input.read -= this.blockSize;
	  } else {
	    // block complete, update input block
	    for(var i = 0; i < this._ints; ++i) {
	      this._inBlock[i] = this._partialBlock[i];
	    }
	  }

	  // skip any previous partial bytes
	  if(this._partialBytes > 0) {
	    this._partialOutput.getBytes(this._partialBytes);
	  }

	  if(partialBytes > 0 && !finish) {
	    output.putBytes(this._partialOutput.getBytes(
	      partialBytes - this._partialBytes));
	    this._partialBytes = partialBytes;
	    return true;
	  }

	  output.putBytes(this._partialOutput.getBytes(
	    inputLength - this._partialBytes));
	  this._partialBytes = 0;
	};

	modes.cfb.prototype.decrypt = function(input, output, finish) {
	  // not enough input to decrypt
	  var inputLength = input.length();
	  if(inputLength === 0) {
	    return true;
	  }

	  // encrypt block (CFB always uses encryption mode)
	  this.cipher.encrypt(this._inBlock, this._outBlock);

	  // handle full block
	  if(this._partialBytes === 0 && inputLength >= this.blockSize) {
	    // XOR input with output, write input as output
	    for(var i = 0; i < this._ints; ++i) {
	      this._inBlock[i] = input.getInt32();
	      output.putInt32(this._inBlock[i] ^ this._outBlock[i]);
	    }
	    return;
	  }

	  // handle partial block
	  var partialBytes = (this.blockSize - inputLength) % this.blockSize;
	  if(partialBytes > 0) {
	    partialBytes = this.blockSize - partialBytes;
	  }

	  // XOR input with output, write input as partial output
	  this._partialOutput.clear();
	  for(var i = 0; i < this._ints; ++i) {
	    this._partialBlock[i] = input.getInt32();
	    this._partialOutput.putInt32(this._partialBlock[i] ^ this._outBlock[i]);
	  }

	  if(partialBytes > 0) {
	    // block still incomplete, restore input buffer
	    input.read -= this.blockSize;
	  } else {
	    // block complete, update input block
	    for(var i = 0; i < this._ints; ++i) {
	      this._inBlock[i] = this._partialBlock[i];
	    }
	  }

	  // skip any previous partial bytes
	  if(this._partialBytes > 0) {
	    this._partialOutput.getBytes(this._partialBytes);
	  }

	  if(partialBytes > 0 && !finish) {
	    output.putBytes(this._partialOutput.getBytes(
	      partialBytes - this._partialBytes));
	    this._partialBytes = partialBytes;
	    return true;
	  }

	  output.putBytes(this._partialOutput.getBytes(
	    inputLength - this._partialBytes));
	  this._partialBytes = 0;
	};

	/** Output feedback (OFB) **/

	modes.ofb = function(options) {
	  options = options || {};
	  this.name = 'OFB';
	  this.cipher = options.cipher;
	  this.blockSize = options.blockSize || 16;
	  this._ints = this.blockSize / 4;
	  this._inBlock = null;
	  this._outBlock = new Array(this._ints);
	  this._partialOutput = forge.util.createBuffer();
	  this._partialBytes = 0;
	};

	modes.ofb.prototype.start = function(options) {
	  if(!('iv' in options)) {
	    throw new Error('Invalid IV parameter.');
	  }
	  // use IV as first input
	  this._iv = transformIV(options.iv, this.blockSize);
	  this._inBlock = this._iv.slice(0);
	  this._partialBytes = 0;
	};

	modes.ofb.prototype.encrypt = function(input, output, finish) {
	  // not enough input to encrypt
	  var inputLength = input.length();
	  if(input.length() === 0) {
	    return true;
	  }

	  // encrypt block (OFB always uses encryption mode)
	  this.cipher.encrypt(this._inBlock, this._outBlock);

	  // handle full block
	  if(this._partialBytes === 0 && inputLength >= this.blockSize) {
	    // XOR input with output and update next input
	    for(var i = 0; i < this._ints; ++i) {
	      output.putInt32(input.getInt32() ^ this._outBlock[i]);
	      this._inBlock[i] = this._outBlock[i];
	    }
	    return;
	  }

	  // handle partial block
	  var partialBytes = (this.blockSize - inputLength) % this.blockSize;
	  if(partialBytes > 0) {
	    partialBytes = this.blockSize - partialBytes;
	  }

	  // XOR input with output
	  this._partialOutput.clear();
	  for(var i = 0; i < this._ints; ++i) {
	    this._partialOutput.putInt32(input.getInt32() ^ this._outBlock[i]);
	  }

	  if(partialBytes > 0) {
	    // block still incomplete, restore input buffer
	    input.read -= this.blockSize;
	  } else {
	    // block complete, update input block
	    for(var i = 0; i < this._ints; ++i) {
	      this._inBlock[i] = this._outBlock[i];
	    }
	  }

	  // skip any previous partial bytes
	  if(this._partialBytes > 0) {
	    this._partialOutput.getBytes(this._partialBytes);
	  }

	  if(partialBytes > 0 && !finish) {
	    output.putBytes(this._partialOutput.getBytes(
	      partialBytes - this._partialBytes));
	    this._partialBytes = partialBytes;
	    return true;
	  }

	  output.putBytes(this._partialOutput.getBytes(
	    inputLength - this._partialBytes));
	  this._partialBytes = 0;
	};

	modes.ofb.prototype.decrypt = modes.ofb.prototype.encrypt;

	/** Counter (CTR) **/

	modes.ctr = function(options) {
	  options = options || {};
	  this.name = 'CTR';
	  this.cipher = options.cipher;
	  this.blockSize = options.blockSize || 16;
	  this._ints = this.blockSize / 4;
	  this._inBlock = null;
	  this._outBlock = new Array(this._ints);
	  this._partialOutput = forge.util.createBuffer();
	  this._partialBytes = 0;
	};

	modes.ctr.prototype.start = function(options) {
	  if(!('iv' in options)) {
	    throw new Error('Invalid IV parameter.');
	  }
	  // use IV as first input
	  this._iv = transformIV(options.iv, this.blockSize);
	  this._inBlock = this._iv.slice(0);
	  this._partialBytes = 0;
	};

	modes.ctr.prototype.encrypt = function(input, output, finish) {
	  // not enough input to encrypt
	  var inputLength = input.length();
	  if(inputLength === 0) {
	    return true;
	  }

	  // encrypt block (CTR always uses encryption mode)
	  this.cipher.encrypt(this._inBlock, this._outBlock);

	  // handle full block
	  if(this._partialBytes === 0 && inputLength >= this.blockSize) {
	    // XOR input with output
	    for(var i = 0; i < this._ints; ++i) {
	      output.putInt32(input.getInt32() ^ this._outBlock[i]);
	    }
	  } else {
	    // handle partial block
	    var partialBytes = (this.blockSize - inputLength) % this.blockSize;
	    if(partialBytes > 0) {
	      partialBytes = this.blockSize - partialBytes;
	    }

	    // XOR input with output
	    this._partialOutput.clear();
	    for(var i = 0; i < this._ints; ++i) {
	      this._partialOutput.putInt32(input.getInt32() ^ this._outBlock[i]);
	    }

	    if(partialBytes > 0) {
	      // block still incomplete, restore input buffer
	      input.read -= this.blockSize;
	    }

	    // skip any previous partial bytes
	    if(this._partialBytes > 0) {
	      this._partialOutput.getBytes(this._partialBytes);
	    }

	    if(partialBytes > 0 && !finish) {
	      output.putBytes(this._partialOutput.getBytes(
	        partialBytes - this._partialBytes));
	      this._partialBytes = partialBytes;
	      return true;
	    }

	    output.putBytes(this._partialOutput.getBytes(
	      inputLength - this._partialBytes));
	    this._partialBytes = 0;
	  }

	  // block complete, increment counter (input block)
	  inc32(this._inBlock);
	};

	modes.ctr.prototype.decrypt = modes.ctr.prototype.encrypt;

	/** Galois/Counter Mode (GCM) **/

	modes.gcm = function(options) {
	  options = options || {};
	  this.name = 'GCM';
	  this.cipher = options.cipher;
	  this.blockSize = options.blockSize || 16;
	  this._ints = this.blockSize / 4;
	  this._inBlock = new Array(this._ints);
	  this._outBlock = new Array(this._ints);
	  this._partialOutput = forge.util.createBuffer();
	  this._partialBytes = 0;

	  // R is actually this value concatenated with 120 more zero bits, but
	  // we only XOR against R so the other zeros have no effect -- we just
	  // apply this value to the first integer in a block
	  this._R = 0xE1000000;
	};

	modes.gcm.prototype.start = function(options) {
	  if(!('iv' in options)) {
	    throw new Error('Invalid IV parameter.');
	  }
	  // ensure IV is a byte buffer
	  var iv = forge.util.createBuffer(options.iv);

	  // no ciphered data processed yet
	  this._cipherLength = 0;

	  // default additional data is none
	  var additionalData;
	  if('additionalData' in options) {
	    additionalData = forge.util.createBuffer(options.additionalData);
	  } else {
	    additionalData = forge.util.createBuffer();
	  }

	  // default tag length is 128 bits
	  if('tagLength' in options) {
	    this._tagLength = options.tagLength;
	  } else {
	    this._tagLength = 128;
	  }

	  // if tag is given, ensure tag matches tag length
	  this._tag = null;
	  if(options.decrypt) {
	    // save tag to check later
	    this._tag = forge.util.createBuffer(options.tag).getBytes();
	    if(this._tag.length !== (this._tagLength / 8)) {
	      throw new Error('Authentication tag does not match tag length.');
	    }
	  }

	  // create tmp storage for hash calculation
	  this._hashBlock = new Array(this._ints);

	  // no tag generated yet
	  this.tag = null;

	  // generate hash subkey
	  // (apply block cipher to "zero" block)
	  this._hashSubkey = new Array(this._ints);
	  this.cipher.encrypt([0, 0, 0, 0], this._hashSubkey);

	  // generate table M
	  // use 4-bit tables (32 component decomposition of a 16 byte value)
	  // 8-bit tables take more space and are known to have security
	  // vulnerabilities (in native implementations)
	  this.componentBits = 4;
	  this._m = this.generateHashTable(this._hashSubkey, this.componentBits);

	  // Note: support IV length different from 96 bits? (only supporting
	  // 96 bits is recommended by NIST SP-800-38D)
	  // generate J_0
	  var ivLength = iv.length();
	  if(ivLength === 12) {
	    // 96-bit IV
	    this._j0 = [iv.getInt32(), iv.getInt32(), iv.getInt32(), 1];
	  } else {
	    // IV is NOT 96-bits
	    this._j0 = [0, 0, 0, 0];
	    while(iv.length() > 0) {
	      this._j0 = this.ghash(
	        this._hashSubkey, this._j0,
	        [iv.getInt32(), iv.getInt32(), iv.getInt32(), iv.getInt32()]);
	    }
	    this._j0 = this.ghash(
	      this._hashSubkey, this._j0, [0, 0].concat(from64To32(ivLength * 8)));
	  }

	  // generate ICB (initial counter block)
	  this._inBlock = this._j0.slice(0);
	  inc32(this._inBlock);
	  this._partialBytes = 0;

	  // consume authentication data
	  additionalData = forge.util.createBuffer(additionalData);
	  // save additional data length as a BE 64-bit number
	  this._aDataLength = from64To32(additionalData.length() * 8);
	  // pad additional data to 128 bit (16 byte) block size
	  var overflow = additionalData.length() % this.blockSize;
	  if(overflow) {
	    additionalData.fillWithByte(0, this.blockSize - overflow);
	  }
	  this._s = [0, 0, 0, 0];
	  while(additionalData.length() > 0) {
	    this._s = this.ghash(this._hashSubkey, this._s, [
	      additionalData.getInt32(),
	      additionalData.getInt32(),
	      additionalData.getInt32(),
	      additionalData.getInt32()
	    ]);
	  }
	};

	modes.gcm.prototype.encrypt = function(input, output, finish) {
	  // not enough input to encrypt
	  var inputLength = input.length();
	  if(inputLength === 0) {
	    return true;
	  }

	  // encrypt block
	  this.cipher.encrypt(this._inBlock, this._outBlock);

	  // handle full block
	  if(this._partialBytes === 0 && inputLength >= this.blockSize) {
	    // XOR input with output
	    for(var i = 0; i < this._ints; ++i) {
	      output.putInt32(this._outBlock[i] ^= input.getInt32());
	    }
	    this._cipherLength += this.blockSize;
	  } else {
	    // handle partial block
	    var partialBytes = (this.blockSize - inputLength) % this.blockSize;
	    if(partialBytes > 0) {
	      partialBytes = this.blockSize - partialBytes;
	    }

	    // XOR input with output
	    this._partialOutput.clear();
	    for(var i = 0; i < this._ints; ++i) {
	      this._partialOutput.putInt32(input.getInt32() ^ this._outBlock[i]);
	    }

	    if(partialBytes <= 0 || finish) {
	      // handle overflow prior to hashing
	      if(finish) {
	        // get block overflow
	        var overflow = inputLength % this.blockSize;
	        this._cipherLength += overflow;
	        // truncate for hash function
	        this._partialOutput.truncate(this.blockSize - overflow);
	      } else {
	        this._cipherLength += this.blockSize;
	      }

	      // get output block for hashing
	      for(var i = 0; i < this._ints; ++i) {
	        this._outBlock[i] = this._partialOutput.getInt32();
	      }
	      this._partialOutput.read -= this.blockSize;
	    }

	    // skip any previous partial bytes
	    if(this._partialBytes > 0) {
	      this._partialOutput.getBytes(this._partialBytes);
	    }

	    if(partialBytes > 0 && !finish) {
	      // block still incomplete, restore input buffer, get partial output,
	      // and return early
	      input.read -= this.blockSize;
	      output.putBytes(this._partialOutput.getBytes(
	        partialBytes - this._partialBytes));
	      this._partialBytes = partialBytes;
	      return true;
	    }

	    output.putBytes(this._partialOutput.getBytes(
	      inputLength - this._partialBytes));
	    this._partialBytes = 0;
	  }

	  // update hash block S
	  this._s = this.ghash(this._hashSubkey, this._s, this._outBlock);

	  // increment counter (input block)
	  inc32(this._inBlock);
	};

	modes.gcm.prototype.decrypt = function(input, output, finish) {
	  // not enough input to decrypt
	  var inputLength = input.length();
	  if(inputLength < this.blockSize && !(finish && inputLength > 0)) {
	    return true;
	  }

	  // encrypt block (GCM always uses encryption mode)
	  this.cipher.encrypt(this._inBlock, this._outBlock);

	  // increment counter (input block)
	  inc32(this._inBlock);

	  // update hash block S
	  this._hashBlock[0] = input.getInt32();
	  this._hashBlock[1] = input.getInt32();
	  this._hashBlock[2] = input.getInt32();
	  this._hashBlock[3] = input.getInt32();
	  this._s = this.ghash(this._hashSubkey, this._s, this._hashBlock);

	  // XOR hash input with output
	  for(var i = 0; i < this._ints; ++i) {
	    output.putInt32(this._outBlock[i] ^ this._hashBlock[i]);
	  }

	  // increment cipher data length
	  if(inputLength < this.blockSize) {
	    this._cipherLength += inputLength % this.blockSize;
	  } else {
	    this._cipherLength += this.blockSize;
	  }
	};

	modes.gcm.prototype.afterFinish = function(output, options) {
	  var rval = true;

	  // handle overflow
	  if(options.decrypt && options.overflow) {
	    output.truncate(this.blockSize - options.overflow);
	  }

	  // handle authentication tag
	  this.tag = forge.util.createBuffer();

	  // concatenate additional data length with cipher length
	  var lengths = this._aDataLength.concat(from64To32(this._cipherLength * 8));

	  // include lengths in hash
	  this._s = this.ghash(this._hashSubkey, this._s, lengths);

	  // do GCTR(J_0, S)
	  var tag = [];
	  this.cipher.encrypt(this._j0, tag);
	  for(var i = 0; i < this._ints; ++i) {
	    this.tag.putInt32(this._s[i] ^ tag[i]);
	  }

	  // trim tag to length
	  this.tag.truncate(this.tag.length() % (this._tagLength / 8));

	  // check authentication tag
	  if(options.decrypt && this.tag.bytes() !== this._tag) {
	    rval = false;
	  }

	  return rval;
	};

	/**
	 * See NIST SP-800-38D 6.3 (Algorithm 1). This function performs Galois
	 * field multiplication. The field, GF(2^128), is defined by the polynomial:
	 *
	 * x^128 + x^7 + x^2 + x + 1
	 *
	 * Which is represented in little-endian binary form as: 11100001 (0xe1). When
	 * the value of a coefficient is 1, a bit is set. The value R, is the
	 * concatenation of this value and 120 zero bits, yielding a 128-bit value
	 * which matches the block size.
	 *
	 * This function will multiply two elements (vectors of bytes), X and Y, in
	 * the field GF(2^128). The result is initialized to zero. For each bit of
	 * X (out of 128), x_i, if x_i is set, then the result is multiplied (XOR'd)
	 * by the current value of Y. For each bit, the value of Y will be raised by
	 * a power of x (multiplied by the polynomial x). This can be achieved by
	 * shifting Y once to the right. If the current value of Y, prior to being
	 * multiplied by x, has 0 as its LSB, then it is a 127th degree polynomial.
	 * Otherwise, we must divide by R after shifting to find the remainder.
	 *
	 * @param x the first block to multiply by the second.
	 * @param y the second block to multiply by the first.
	 *
	 * @return the block result of the multiplication.
	 */
	modes.gcm.prototype.multiply = function(x, y) {
	  var z_i = [0, 0, 0, 0];
	  var v_i = y.slice(0);

	  // calculate Z_128 (block has 128 bits)
	  for(var i = 0; i < 128; ++i) {
	    // if x_i is 0, Z_{i+1} = Z_i (unchanged)
	    // else Z_{i+1} = Z_i ^ V_i
	    // get x_i by finding 32-bit int position, then left shift 1 by remainder
	    var x_i = x[(i / 32) | 0] & (1 << (31 - i % 32));
	    if(x_i) {
	      z_i[0] ^= v_i[0];
	      z_i[1] ^= v_i[1];
	      z_i[2] ^= v_i[2];
	      z_i[3] ^= v_i[3];
	    }

	    // if LSB(V_i) is 1, V_i = V_i >> 1
	    // else V_i = (V_i >> 1) ^ R
	    this.pow(v_i, v_i);
	  }

	  return z_i;
	};

	modes.gcm.prototype.pow = function(x, out) {
	  // if LSB(x) is 1, x = x >>> 1
	  // else x = (x >>> 1) ^ R
	  var lsb = x[3] & 1;

	  // always do x >>> 1:
	  // starting with the rightmost integer, shift each integer to the right
	  // one bit, pulling in the bit from the integer to the left as its top
	  // most bit (do this for the last 3 integers)
	  for(var i = 3; i > 0; --i) {
	    out[i] = (x[i] >>> 1) | ((x[i - 1] & 1) << 31);
	  }
	  // shift the first integer normally
	  out[0] = x[0] >>> 1;

	  // if lsb was not set, then polynomial had a degree of 127 and doesn't
	  // need to divided; otherwise, XOR with R to find the remainder; we only
	  // need to XOR the first integer since R technically ends w/120 zero bits
	  if(lsb) {
	    out[0] ^= this._R;
	  }
	};

	modes.gcm.prototype.tableMultiply = function(x) {
	  // assumes 4-bit tables are used
	  var z = [0, 0, 0, 0];
	  for(var i = 0; i < 32; ++i) {
	    var idx = (i / 8) | 0;
	    var x_i = (x[idx] >>> ((7 - (i % 8)) * 4)) & 0xF;
	    var ah = this._m[i][x_i];
	    z[0] ^= ah[0];
	    z[1] ^= ah[1];
	    z[2] ^= ah[2];
	    z[3] ^= ah[3];
	  }
	  return z;
	};

	/**
	 * A continuing version of the GHASH algorithm that operates on a single
	 * block. The hash block, last hash value (Ym) and the new block to hash
	 * are given.
	 *
	 * @param h the hash block.
	 * @param y the previous value for Ym, use [0, 0, 0, 0] for a new hash.
	 * @param x the block to hash.
	 *
	 * @return the hashed value (Ym).
	 */
	modes.gcm.prototype.ghash = function(h, y, x) {
	  y[0] ^= x[0];
	  y[1] ^= x[1];
	  y[2] ^= x[2];
	  y[3] ^= x[3];
	  return this.tableMultiply(y);
	  //return this.multiply(y, h);
	};

	/**
	 * Precomputes a table for multiplying against the hash subkey. This
	 * mechanism provides a substantial speed increase over multiplication
	 * performed without a table. The table-based multiplication this table is
	 * for solves X * H by multiplying each component of X by H and then
	 * composing the results together using XOR.
	 *
	 * This function can be used to generate tables with different bit sizes
	 * for the components, however, this implementation assumes there are
	 * 32 components of X (which is a 16 byte vector), therefore each component
	 * takes 4-bits (so the table is constructed with bits=4).
	 *
	 * @param h the hash subkey.
	 * @param bits the bit size for a component.
	 */
	modes.gcm.prototype.generateHashTable = function(h, bits) {
	  // TODO: There are further optimizations that would use only the
	  // first table M_0 (or some variant) along with a remainder table;
	  // this can be explored in the future
	  var multiplier = 8 / bits;
	  var perInt = 4 * multiplier;
	  var size = 16 * multiplier;
	  var m = new Array(size);
	  for(var i = 0; i < size; ++i) {
	    var tmp = [0, 0, 0, 0];
	    var idx = (i / perInt) | 0;
	    var shft = ((perInt - 1 - (i % perInt)) * bits);
	    tmp[idx] = (1 << (bits - 1)) << shft;
	    m[i] = this.generateSubHashTable(this.multiply(tmp, h), bits);
	  }
	  return m;
	};

	/**
	 * Generates a table for multiplying against the hash subkey for one
	 * particular component (out of all possible component values).
	 *
	 * @param mid the pre-multiplied value for the middle key of the table.
	 * @param bits the bit size for a component.
	 */
	modes.gcm.prototype.generateSubHashTable = function(mid, bits) {
	  // compute the table quickly by minimizing the number of
	  // POW operations -- they only need to be performed for powers of 2,
	  // all other entries can be composed from those powers using XOR
	  var size = 1 << bits;
	  var half = size >>> 1;
	  var m = new Array(size);
	  m[half] = mid.slice(0);
	  var i = half >>> 1;
	  while(i > 0) {
	    // raise m0[2 * i] and store in m0[i]
	    this.pow(m[2 * i], m[i] = []);
	    i >>= 1;
	  }
	  i = 2;
	  while(i < half) {
	    for(var j = 1; j < i; ++j) {
	      var m_i = m[i];
	      var m_j = m[j];
	      m[i + j] = [
	        m_i[0] ^ m_j[0],
	        m_i[1] ^ m_j[1],
	        m_i[2] ^ m_j[2],
	        m_i[3] ^ m_j[3]
	      ];
	    }
	    i *= 2;
	  }
	  m[0] = [0, 0, 0, 0];
	  /* Note: We could avoid storing these by doing composition during multiply
	  calculate top half using composition by speed is preferred. */
	  for(i = half + 1; i < size; ++i) {
	    var c = m[i ^ half];
	    m[i] = [mid[0] ^ c[0], mid[1] ^ c[1], mid[2] ^ c[2], mid[3] ^ c[3]];
	  }
	  return m;
	};

	/** Utility functions */

	function transformIV(iv, blockSize) {
	  if(typeof iv === 'string') {
	    // convert iv string into byte buffer
	    iv = forge.util.createBuffer(iv);
	  }

	  if(forge.util.isArray(iv) && iv.length > 4) {
	    // convert iv byte array into byte buffer
	    var tmp = iv;
	    iv = forge.util.createBuffer();
	    for(var i = 0; i < tmp.length; ++i) {
	      iv.putByte(tmp[i]);
	    }
	  }

	  if(iv.length() < blockSize) {
	    throw new Error(
	      'Invalid IV length; got ' + iv.length() +
	      ' bytes and expected ' + blockSize + ' bytes.');
	  }

	  if(!forge.util.isArray(iv)) {
	    // convert iv byte buffer into 32-bit integer array
	    var ints = [];
	    var blocks = blockSize / 4;
	    for(var i = 0; i < blocks; ++i) {
	      ints.push(iv.getInt32());
	    }
	    iv = ints;
	  }

	  return iv;
	}

	function inc32(block) {
	  // increment last 32 bits of block only
	  block[block.length - 1] = (block[block.length - 1] + 1) & 0xFFFFFFFF;
	}

	function from64To32(num) {
	  // convert 64-bit number to two BE Int32s
	  return [(num / 0x100000000) | 0, num & 0xFFFFFFFF];
	}
	});

	/**
	 * Advanced Encryption Standard (AES) implementation.
	 *
	 * This implementation is based on the public domain library 'jscrypto' which
	 * was written by:
	 *
	 * Emily Stark (estark@stanford.edu)
	 * Mike Hamburg (mhamburg@stanford.edu)
	 * Dan Boneh (dabo@cs.stanford.edu)
	 *
	 * Parts of this code are based on the OpenSSL implementation of AES:
	 * http://www.openssl.org
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2014 Digital Bazaar, Inc.
	 */





	/* AES API */
	forge.aes = forge.aes || {};

	/**
	 * Deprecated. Instead, use:
	 *
	 * var cipher = forge.cipher.createCipher('AES-<mode>', key);
	 * cipher.start({iv: iv});
	 *
	 * Creates an AES cipher object to encrypt data using the given symmetric key.
	 * The output will be stored in the 'output' member of the returned cipher.
	 *
	 * The key and iv may be given as a string of bytes, an array of bytes,
	 * a byte buffer, or an array of 32-bit words.
	 *
	 * @param key the symmetric key to use.
	 * @param iv the initialization vector to use.
	 * @param output the buffer to write to, null to create one.
	 * @param mode the cipher mode to use (default: 'CBC').
	 *
	 * @return the cipher.
	 */
	forge.aes.startEncrypting = function(key, iv, output, mode) {
	  var cipher = _createCipher$1({
	    key: key,
	    output: output,
	    decrypt: false,
	    mode: mode
	  });
	  cipher.start(iv);
	  return cipher;
	};

	/**
	 * Deprecated. Instead, use:
	 *
	 * var cipher = forge.cipher.createCipher('AES-<mode>', key);
	 *
	 * Creates an AES cipher object to encrypt data using the given symmetric key.
	 *
	 * The key may be given as a string of bytes, an array of bytes, a
	 * byte buffer, or an array of 32-bit words.
	 *
	 * @param key the symmetric key to use.
	 * @param mode the cipher mode to use (default: 'CBC').
	 *
	 * @return the cipher.
	 */
	forge.aes.createEncryptionCipher = function(key, mode) {
	  return _createCipher$1({
	    key: key,
	    output: null,
	    decrypt: false,
	    mode: mode
	  });
	};

	/**
	 * Deprecated. Instead, use:
	 *
	 * var decipher = forge.cipher.createDecipher('AES-<mode>', key);
	 * decipher.start({iv: iv});
	 *
	 * Creates an AES cipher object to decrypt data using the given symmetric key.
	 * The output will be stored in the 'output' member of the returned cipher.
	 *
	 * The key and iv may be given as a string of bytes, an array of bytes,
	 * a byte buffer, or an array of 32-bit words.
	 *
	 * @param key the symmetric key to use.
	 * @param iv the initialization vector to use.
	 * @param output the buffer to write to, null to create one.
	 * @param mode the cipher mode to use (default: 'CBC').
	 *
	 * @return the cipher.
	 */
	forge.aes.startDecrypting = function(key, iv, output, mode) {
	  var cipher = _createCipher$1({
	    key: key,
	    output: output,
	    decrypt: true,
	    mode: mode
	  });
	  cipher.start(iv);
	  return cipher;
	};

	/**
	 * Deprecated. Instead, use:
	 *
	 * var decipher = forge.cipher.createDecipher('AES-<mode>', key);
	 *
	 * Creates an AES cipher object to decrypt data using the given symmetric key.
	 *
	 * The key may be given as a string of bytes, an array of bytes, a
	 * byte buffer, or an array of 32-bit words.
	 *
	 * @param key the symmetric key to use.
	 * @param mode the cipher mode to use (default: 'CBC').
	 *
	 * @return the cipher.
	 */
	forge.aes.createDecryptionCipher = function(key, mode) {
	  return _createCipher$1({
	    key: key,
	    output: null,
	    decrypt: true,
	    mode: mode
	  });
	};

	/**
	 * Creates a new AES cipher algorithm object.
	 *
	 * @param name the name of the algorithm.
	 * @param mode the mode factory function.
	 *
	 * @return the AES algorithm object.
	 */
	forge.aes.Algorithm = function(name, mode) {
	  if(!init$1) {
	    initialize();
	  }
	  var self = this;
	  self.name = name;
	  self.mode = new mode({
	    blockSize: 16,
	    cipher: {
	      encrypt: function(inBlock, outBlock) {
	        return _updateBlock$1(self._w, inBlock, outBlock, false);
	      },
	      decrypt: function(inBlock, outBlock) {
	        return _updateBlock$1(self._w, inBlock, outBlock, true);
	      }
	    }
	  });
	  self._init = false;
	};

	/**
	 * Initializes this AES algorithm by expanding its key.
	 *
	 * @param options the options to use.
	 *          key the key to use with this algorithm.
	 *          decrypt true if the algorithm should be initialized for decryption,
	 *            false for encryption.
	 */
	forge.aes.Algorithm.prototype.initialize = function(options) {
	  if(this._init) {
	    return;
	  }

	  var key = options.key;
	  var tmp;

	  /* Note: The key may be a string of bytes, an array of bytes, a byte
	    buffer, or an array of 32-bit integers. If the key is in bytes, then
	    it must be 16, 24, or 32 bytes in length. If it is in 32-bit
	    integers, it must be 4, 6, or 8 integers long. */

	  if(typeof key === 'string' &&
	    (key.length === 16 || key.length === 24 || key.length === 32)) {
	    // convert key string into byte buffer
	    key = forge.util.createBuffer(key);
	  } else if(forge.util.isArray(key) &&
	    (key.length === 16 || key.length === 24 || key.length === 32)) {
	    // convert key integer array into byte buffer
	    tmp = key;
	    key = forge.util.createBuffer();
	    for(var i = 0; i < tmp.length; ++i) {
	      key.putByte(tmp[i]);
	    }
	  }

	  // convert key byte buffer into 32-bit integer array
	  if(!forge.util.isArray(key)) {
	    tmp = key;
	    key = [];

	    // key lengths of 16, 24, 32 bytes allowed
	    var len = tmp.length();
	    if(len === 16 || len === 24 || len === 32) {
	      len = len >>> 2;
	      for(var i = 0; i < len; ++i) {
	        key.push(tmp.getInt32());
	      }
	    }
	  }

	  // key must be an array of 32-bit integers by now
	  if(!forge.util.isArray(key) ||
	    !(key.length === 4 || key.length === 6 || key.length === 8)) {
	    throw new Error('Invalid key parameter.');
	  }

	  // encryption operation is always used for these modes
	  var mode = this.mode.name;
	  var encryptOp = (['CFB', 'OFB', 'CTR', 'GCM'].indexOf(mode) !== -1);

	  // do key expansion
	  this._w = _expandKey(key, options.decrypt && !encryptOp);
	  this._init = true;
	};

	/**
	 * Expands a key. Typically only used for testing.
	 *
	 * @param key the symmetric key to expand, as an array of 32-bit words.
	 * @param decrypt true to expand for decryption, false for encryption.
	 *
	 * @return the expanded key.
	 */
	forge.aes._expandKey = function(key, decrypt) {
	  if(!init$1) {
	    initialize();
	  }
	  return _expandKey(key, decrypt);
	};

	/**
	 * Updates a single block. Typically only used for testing.
	 *
	 * @param w the expanded key to use.
	 * @param input an array of block-size 32-bit words.
	 * @param output an array of block-size 32-bit words.
	 * @param decrypt true to decrypt, false to encrypt.
	 */
	forge.aes._updateBlock = _updateBlock$1;

	/** Register AES algorithms **/

	registerAlgorithm$1('AES-ECB', forge.cipher.modes.ecb);
	registerAlgorithm$1('AES-CBC', forge.cipher.modes.cbc);
	registerAlgorithm$1('AES-CFB', forge.cipher.modes.cfb);
	registerAlgorithm$1('AES-OFB', forge.cipher.modes.ofb);
	registerAlgorithm$1('AES-CTR', forge.cipher.modes.ctr);
	registerAlgorithm$1('AES-GCM', forge.cipher.modes.gcm);

	function registerAlgorithm$1(name, mode) {
	  var factory = function() {
	    return new forge.aes.Algorithm(name, mode);
	  };
	  forge.cipher.registerAlgorithm(name, factory);
	}

	/** AES implementation **/

	var init$1 = false; // not yet initialized
	var Nb = 4;       // number of words comprising the state (AES = 4)
	var sbox;         // non-linear substitution table used in key expansion
	var isbox;        // inversion of sbox
	var rcon;         // round constant word array
	var mix;          // mix-columns table
	var imix;         // inverse mix-columns table

	/**
	 * Performs initialization, ie: precomputes tables to optimize for speed.
	 *
	 * One way to understand how AES works is to imagine that 'addition' and
	 * 'multiplication' are interfaces that require certain mathematical
	 * properties to hold true (ie: they are associative) but they might have
	 * different implementations and produce different kinds of results ...
	 * provided that their mathematical properties remain true. AES defines
	 * its own methods of addition and multiplication but keeps some important
	 * properties the same, ie: associativity and distributivity. The
	 * explanation below tries to shed some light on how AES defines addition
	 * and multiplication of bytes and 32-bit words in order to perform its
	 * encryption and decryption algorithms.
	 *
	 * The basics:
	 *
	 * The AES algorithm views bytes as binary representations of polynomials
	 * that have either 1 or 0 as the coefficients. It defines the addition
	 * or subtraction of two bytes as the XOR operation. It also defines the
	 * multiplication of two bytes as a finite field referred to as GF(2^8)
	 * (Note: 'GF' means "Galois Field" which is a field that contains a finite
	 * number of elements so GF(2^8) has 256 elements).
	 *
	 * This means that any two bytes can be represented as binary polynomials;
	 * when they multiplied together and modularly reduced by an irreducible
	 * polynomial of the 8th degree, the results are the field GF(2^8). The
	 * specific irreducible polynomial that AES uses in hexadecimal is 0x11b.
	 * This multiplication is associative with 0x01 as the identity:
	 *
	 * (b * 0x01 = GF(b, 0x01) = b).
	 *
	 * The operation GF(b, 0x02) can be performed at the byte level by left
	 * shifting b once and then XOR'ing it (to perform the modular reduction)
	 * with 0x11b if b is >= 128. Repeated application of the multiplication
	 * of 0x02 can be used to implement the multiplication of any two bytes.
	 *
	 * For instance, multiplying 0x57 and 0x13, denoted as GF(0x57, 0x13), can
	 * be performed by factoring 0x13 into 0x01, 0x02, and 0x10. Then these
	 * factors can each be multiplied by 0x57 and then added together. To do
	 * the multiplication, values for 0x57 multiplied by each of these 3 factors
	 * can be precomputed and stored in a table. To add them, the values from
	 * the table are XOR'd together.
	 *
	 * AES also defines addition and multiplication of words, that is 4-byte
	 * numbers represented as polynomials of 3 degrees where the coefficients
	 * are the values of the bytes.
	 *
	 * The word [a0, a1, a2, a3] is a polynomial a3x^3 + a2x^2 + a1x + a0.
	 *
	 * Addition is performed by XOR'ing like powers of x. Multiplication
	 * is performed in two steps, the first is an algebriac expansion as
	 * you would do normally (where addition is XOR). But the result is
	 * a polynomial larger than 3 degrees and thus it cannot fit in a word. So
	 * next the result is modularly reduced by an AES-specific polynomial of
	 * degree 4 which will always produce a polynomial of less than 4 degrees
	 * such that it will fit in a word. In AES, this polynomial is x^4 + 1.
	 *
	 * The modular product of two polynomials 'a' and 'b' is thus:
	 *
	 * d(x) = d3x^3 + d2x^2 + d1x + d0
	 * with
	 * d0 = GF(a0, b0) ^ GF(a3, b1) ^ GF(a2, b2) ^ GF(a1, b3)
	 * d1 = GF(a1, b0) ^ GF(a0, b1) ^ GF(a3, b2) ^ GF(a2, b3)
	 * d2 = GF(a2, b0) ^ GF(a1, b1) ^ GF(a0, b2) ^ GF(a3, b3)
	 * d3 = GF(a3, b0) ^ GF(a2, b1) ^ GF(a1, b2) ^ GF(a0, b3)
	 *
	 * As a matrix:
	 *
	 * [d0] = [a0 a3 a2 a1][b0]
	 * [d1]   [a1 a0 a3 a2][b1]
	 * [d2]   [a2 a1 a0 a3][b2]
	 * [d3]   [a3 a2 a1 a0][b3]
	 *
	 * Special polynomials defined by AES (0x02 == {02}):
	 * a(x)    = {03}x^3 + {01}x^2 + {01}x + {02}
	 * a^-1(x) = {0b}x^3 + {0d}x^2 + {09}x + {0e}.
	 *
	 * These polynomials are used in the MixColumns() and InverseMixColumns()
	 * operations, respectively, to cause each element in the state to affect
	 * the output (referred to as diffusing).
	 *
	 * RotWord() uses: a0 = a1 = a2 = {00} and a3 = {01}, which is the
	 * polynomial x3.
	 *
	 * The ShiftRows() method modifies the last 3 rows in the state (where
	 * the state is 4 words with 4 bytes per word) by shifting bytes cyclically.
	 * The 1st byte in the second row is moved to the end of the row. The 1st
	 * and 2nd bytes in the third row are moved to the end of the row. The 1st,
	 * 2nd, and 3rd bytes are moved in the fourth row.
	 *
	 * More details on how AES arithmetic works:
	 *
	 * In the polynomial representation of binary numbers, XOR performs addition
	 * and subtraction and multiplication in GF(2^8) denoted as GF(a, b)
	 * corresponds with the multiplication of polynomials modulo an irreducible
	 * polynomial of degree 8. In other words, for AES, GF(a, b) will multiply
	 * polynomial 'a' with polynomial 'b' and then do a modular reduction by
	 * an AES-specific irreducible polynomial of degree 8.
	 *
	 * A polynomial is irreducible if its only divisors are one and itself. For
	 * the AES algorithm, this irreducible polynomial is:
	 *
	 * m(x) = x^8 + x^4 + x^3 + x + 1,
	 *
	 * or {01}{1b} in hexadecimal notation, where each coefficient is a bit:
	 * 100011011 = 283 = 0x11b.
	 *
	 * For example, GF(0x57, 0x83) = 0xc1 because
	 *
	 * 0x57 = 87  = 01010111 = x^6 + x^4 + x^2 + x + 1
	 * 0x85 = 131 = 10000101 = x^7 + x + 1
	 *
	 * (x^6 + x^4 + x^2 + x + 1) * (x^7 + x + 1)
	 * =  x^13 + x^11 + x^9 + x^8 + x^7 +
	 *    x^7 + x^5 + x^3 + x^2 + x +
	 *    x^6 + x^4 + x^2 + x + 1
	 * =  x^13 + x^11 + x^9 + x^8 + x^6 + x^5 + x^4 + x^3 + 1 = y
	 *    y modulo (x^8 + x^4 + x^3 + x + 1)
	 * =  x^7 + x^6 + 1.
	 *
	 * The modular reduction by m(x) guarantees the result will be a binary
	 * polynomial of less than degree 8, so that it can fit in a byte.
	 *
	 * The operation to multiply a binary polynomial b with x (the polynomial
	 * x in binary representation is 00000010) is:
	 *
	 * b_7x^8 + b_6x^7 + b_5x^6 + b_4x^5 + b_3x^4 + b_2x^3 + b_1x^2 + b_0x^1
	 *
	 * To get GF(b, x) we must reduce that by m(x). If b_7 is 0 (that is the
	 * most significant bit is 0 in b) then the result is already reduced. If
	 * it is 1, then we can reduce it by subtracting m(x) via an XOR.
	 *
	 * It follows that multiplication by x (00000010 or 0x02) can be implemented
	 * by performing a left shift followed by a conditional bitwise XOR with
	 * 0x1b. This operation on bytes is denoted by xtime(). Multiplication by
	 * higher powers of x can be implemented by repeated application of xtime().
	 *
	 * By adding intermediate results, multiplication by any constant can be
	 * implemented. For instance:
	 *
	 * GF(0x57, 0x13) = 0xfe because:
	 *
	 * xtime(b) = (b & 128) ? (b << 1 ^ 0x11b) : (b << 1)
	 *
	 * Note: We XOR with 0x11b instead of 0x1b because in javascript our
	 * datatype for b can be larger than 1 byte, so a left shift will not
	 * automatically eliminate bits that overflow a byte ... by XOR'ing the
	 * overflow bit with 1 (the extra one from 0x11b) we zero it out.
	 *
	 * GF(0x57, 0x02) = xtime(0x57) = 0xae
	 * GF(0x57, 0x04) = xtime(0xae) = 0x47
	 * GF(0x57, 0x08) = xtime(0x47) = 0x8e
	 * GF(0x57, 0x10) = xtime(0x8e) = 0x07
	 *
	 * GF(0x57, 0x13) = GF(0x57, (0x01 ^ 0x02 ^ 0x10))
	 *
	 * And by the distributive property (since XOR is addition and GF() is
	 * multiplication):
	 *
	 * = GF(0x57, 0x01) ^ GF(0x57, 0x02) ^ GF(0x57, 0x10)
	 * = 0x57 ^ 0xae ^ 0x07
	 * = 0xfe.
	 */
	function initialize() {
	  init$1 = true;

	  /* Populate the Rcon table. These are the values given by
	    [x^(i-1),{00},{00},{00}] where x^(i-1) are powers of x (and x = 0x02)
	    in the field of GF(2^8), where i starts at 1.

	    rcon[0] = [0x00, 0x00, 0x00, 0x00]
	    rcon[1] = [0x01, 0x00, 0x00, 0x00] 2^(1-1) = 2^0 = 1
	    rcon[2] = [0x02, 0x00, 0x00, 0x00] 2^(2-1) = 2^1 = 2
	    ...
	    rcon[9]  = [0x1B, 0x00, 0x00, 0x00] 2^(9-1)  = 2^8 = 0x1B
	    rcon[10] = [0x36, 0x00, 0x00, 0x00] 2^(10-1) = 2^9 = 0x36

	    We only store the first byte because it is the only one used.
	  */
	  rcon = [0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1B, 0x36];

	  // compute xtime table which maps i onto GF(i, 0x02)
	  var xtime = new Array(256);
	  for(var i = 0; i < 128; ++i) {
	    xtime[i] = i << 1;
	    xtime[i + 128] = (i + 128) << 1 ^ 0x11B;
	  }

	  // compute all other tables
	  sbox = new Array(256);
	  isbox = new Array(256);
	  mix = new Array(4);
	  imix = new Array(4);
	  for(var i = 0; i < 4; ++i) {
	    mix[i] = new Array(256);
	    imix[i] = new Array(256);
	  }
	  var e = 0, ei = 0, e2, e4, e8, sx, sx2, me, ime;
	  for(var i = 0; i < 256; ++i) {
	    /* We need to generate the SubBytes() sbox and isbox tables so that
	      we can perform byte substitutions. This requires us to traverse
	      all of the elements in GF, find their multiplicative inverses,
	      and apply to each the following affine transformation:

	      bi' = bi ^ b(i + 4) mod 8 ^ b(i + 5) mod 8 ^ b(i + 6) mod 8 ^
	            b(i + 7) mod 8 ^ ci
	      for 0 <= i < 8, where bi is the ith bit of the byte, and ci is the
	      ith bit of a byte c with the value {63} or {01100011}.

	      It is possible to traverse every possible value in a Galois field
	      using what is referred to as a 'generator'. There are many
	      generators (128 out of 256): 3,5,6,9,11,82 to name a few. To fully
	      traverse GF we iterate 255 times, multiplying by our generator
	      each time.

	      On each iteration we can determine the multiplicative inverse for
	      the current element.

	      Suppose there is an element in GF 'e'. For a given generator 'g',
	      e = g^x. The multiplicative inverse of e is g^(255 - x). It turns
	      out that if use the inverse of a generator as another generator
	      it will produce all of the corresponding multiplicative inverses
	      at the same time. For this reason, we choose 5 as our inverse
	      generator because it only requires 2 multiplies and 1 add and its
	      inverse, 82, requires relatively few operations as well.

	      In order to apply the affine transformation, the multiplicative
	      inverse 'ei' of 'e' can be repeatedly XOR'd (4 times) with a
	      bit-cycling of 'ei'. To do this 'ei' is first stored in 's' and
	      'x'. Then 's' is left shifted and the high bit of 's' is made the
	      low bit. The resulting value is stored in 's'. Then 'x' is XOR'd
	      with 's' and stored in 'x'. On each subsequent iteration the same
	      operation is performed. When 4 iterations are complete, 'x' is
	      XOR'd with 'c' (0x63) and the transformed value is stored in 'x'.
	      For example:

	      s = 01000001
	      x = 01000001

	      iteration 1: s = 10000010, x ^= s
	      iteration 2: s = 00000101, x ^= s
	      iteration 3: s = 00001010, x ^= s
	      iteration 4: s = 00010100, x ^= s
	      x ^= 0x63

	      This can be done with a loop where s = (s << 1) | (s >> 7). However,
	      it can also be done by using a single 16-bit (in this case 32-bit)
	      number 'sx'. Since XOR is an associative operation, we can set 'sx'
	      to 'ei' and then XOR it with 'sx' left-shifted 1,2,3, and 4 times.
	      The most significant bits will flow into the high 8 bit positions
	      and be correctly XOR'd with one another. All that remains will be
	      to cycle the high 8 bits by XOR'ing them all with the lower 8 bits
	      afterwards.

	      At the same time we're populating sbox and isbox we can precompute
	      the multiplication we'll need to do to do MixColumns() later.
	    */

	    // apply affine transformation
	    sx = ei ^ (ei << 1) ^ (ei << 2) ^ (ei << 3) ^ (ei << 4);
	    sx = (sx >> 8) ^ (sx & 255) ^ 0x63;

	    // update tables
	    sbox[e] = sx;
	    isbox[sx] = e;

	    /* Mixing columns is done using matrix multiplication. The columns
	      that are to be mixed are each a single word in the current state.
	      The state has Nb columns (4 columns). Therefore each column is a
	      4 byte word. So to mix the columns in a single column 'c' where
	      its rows are r0, r1, r2, and r3, we use the following matrix
	      multiplication:

	      [2 3 1 1]*[r0,c]=[r'0,c]
	      [1 2 3 1] [r1,c] [r'1,c]
	      [1 1 2 3] [r2,c] [r'2,c]
	      [3 1 1 2] [r3,c] [r'3,c]

	      r0, r1, r2, and r3 are each 1 byte of one of the words in the
	      state (a column). To do matrix multiplication for each mixed
	      column c' we multiply the corresponding row from the left matrix
	      with the corresponding column from the right matrix. In total, we
	      get 4 equations:

	      r0,c' = 2*r0,c + 3*r1,c + 1*r2,c + 1*r3,c
	      r1,c' = 1*r0,c + 2*r1,c + 3*r2,c + 1*r3,c
	      r2,c' = 1*r0,c + 1*r1,c + 2*r2,c + 3*r3,c
	      r3,c' = 3*r0,c + 1*r1,c + 1*r2,c + 2*r3,c

	      As usual, the multiplication is as previously defined and the
	      addition is XOR. In order to optimize mixing columns we can store
	      the multiplication results in tables. If you think of the whole
	      column as a word (it might help to visualize by mentally rotating
	      the equations above by counterclockwise 90 degrees) then you can
	      see that it would be useful to map the multiplications performed on
	      each byte (r0, r1, r2, r3) onto a word as well. For instance, we
	      could map 2*r0,1*r0,1*r0,3*r0 onto a word by storing 2*r0 in the
	      highest 8 bits and 3*r0 in the lowest 8 bits (with the other two
	      respectively in the middle). This means that a table can be
	      constructed that uses r0 as an index to the word. We can do the
	      same with r1, r2, and r3, creating a total of 4 tables.

	      To construct a full c', we can just look up each byte of c in
	      their respective tables and XOR the results together.

	      Also, to build each table we only have to calculate the word
	      for 2,1,1,3 for every byte ... which we can do on each iteration
	      of this loop since we will iterate over every byte. After we have
	      calculated 2,1,1,3 we can get the results for the other tables
	      by cycling the byte at the end to the beginning. For instance
	      we can take the result of table 2,1,1,3 and produce table 3,2,1,1
	      by moving the right most byte to the left most position just like
	      how you can imagine the 3 moved out of 2,1,1,3 and to the front
	      to produce 3,2,1,1.

	      There is another optimization in that the same multiples of
	      the current element we need in order to advance our generator
	      to the next iteration can be reused in performing the 2,1,1,3
	      calculation. We also calculate the inverse mix column tables,
	      with e,9,d,b being the inverse of 2,1,1,3.

	      When we're done, and we need to actually mix columns, the first
	      byte of each state word should be put through mix[0] (2,1,1,3),
	      the second through mix[1] (3,2,1,1) and so forth. Then they should
	      be XOR'd together to produce the fully mixed column.
	    */

	    // calculate mix and imix table values
	    sx2 = xtime[sx];
	    e2 = xtime[e];
	    e4 = xtime[e2];
	    e8 = xtime[e4];
	    me =
	      (sx2 << 24) ^  // 2
	      (sx << 16) ^   // 1
	      (sx << 8) ^    // 1
	      (sx ^ sx2);    // 3
	    ime =
	      (e2 ^ e4 ^ e8) << 24 ^  // E (14)
	      (e ^ e8) << 16 ^        // 9
	      (e ^ e4 ^ e8) << 8 ^    // D (13)
	      (e ^ e2 ^ e8);          // B (11)
	    // produce each of the mix tables by rotating the 2,1,1,3 value
	    for(var n = 0; n < 4; ++n) {
	      mix[n][e] = me;
	      imix[n][sx] = ime;
	      // cycle the right most byte to the left most position
	      // ie: 2,1,1,3 becomes 3,2,1,1
	      me = me << 24 | me >>> 8;
	      ime = ime << 24 | ime >>> 8;
	    }

	    // get next element and inverse
	    if(e === 0) {
	      // 1 is the inverse of 1
	      e = ei = 1;
	    } else {
	      // e = 2e + 2*2*2*(10e)) = multiply e by 82 (chosen generator)
	      // ei = ei + 2*2*ei = multiply ei by 5 (inverse generator)
	      e = e2 ^ xtime[xtime[xtime[e2 ^ e8]]];
	      ei ^= xtime[xtime[ei]];
	    }
	  }
	}

	/**
	 * Generates a key schedule using the AES key expansion algorithm.
	 *
	 * The AES algorithm takes the Cipher Key, K, and performs a Key Expansion
	 * routine to generate a key schedule. The Key Expansion generates a total
	 * of Nb*(Nr + 1) words: the algorithm requires an initial set of Nb words,
	 * and each of the Nr rounds requires Nb words of key data. The resulting
	 * key schedule consists of a linear array of 4-byte words, denoted [wi ],
	 * with i in the range 0 <= i < Nb(Nr + 1).
	 *
	 * KeyExpansion(byte key[4*Nk], word w[Nb*(Nr+1)], Nk)
	 * AES-128 (Nb=4, Nk=4, Nr=10)
	 * AES-192 (Nb=4, Nk=6, Nr=12)
	 * AES-256 (Nb=4, Nk=8, Nr=14)
	 * Note: Nr=Nk+6.
	 *
	 * Nb is the number of columns (32-bit words) comprising the State (or
	 * number of bytes in a block). For AES, Nb=4.
	 *
	 * @param key the key to schedule (as an array of 32-bit words).
	 * @param decrypt true to modify the key schedule to decrypt, false not to.
	 *
	 * @return the generated key schedule.
	 */
	function _expandKey(key, decrypt) {
	  // copy the key's words to initialize the key schedule
	  var w = key.slice(0);

	  /* RotWord() will rotate a word, moving the first byte to the last
	    byte's position (shifting the other bytes left).

	    We will be getting the value of Rcon at i / Nk. 'i' will iterate
	    from Nk to (Nb * Nr+1). Nk = 4 (4 byte key), Nb = 4 (4 words in
	    a block), Nr = Nk + 6 (10). Therefore 'i' will iterate from
	    4 to 44 (exclusive). Each time we iterate 4 times, i / Nk will
	    increase by 1. We use a counter iNk to keep track of this.
	   */

	  // go through the rounds expanding the key
	  var temp, iNk = 1;
	  var Nk = w.length;
	  var Nr1 = Nk + 6 + 1;
	  var end = Nb * Nr1;
	  for(var i = Nk; i < end; ++i) {
	    temp = w[i - 1];
	    if(i % Nk === 0) {
	      // temp = SubWord(RotWord(temp)) ^ Rcon[i / Nk]
	      temp =
	        sbox[temp >>> 16 & 255] << 24 ^
	        sbox[temp >>> 8 & 255] << 16 ^
	        sbox[temp & 255] << 8 ^
	        sbox[temp >>> 24] ^ (rcon[iNk] << 24);
	      iNk++;
	    } else if(Nk > 6 && (i % Nk === 4)) {
	      // temp = SubWord(temp)
	      temp =
	        sbox[temp >>> 24] << 24 ^
	        sbox[temp >>> 16 & 255] << 16 ^
	        sbox[temp >>> 8 & 255] << 8 ^
	        sbox[temp & 255];
	    }
	    w[i] = w[i - Nk] ^ temp;
	  }

	  /* When we are updating a cipher block we always use the code path for
	     encryption whether we are decrypting or not (to shorten code and
	     simplify the generation of look up tables). However, because there
	     are differences in the decryption algorithm, other than just swapping
	     in different look up tables, we must transform our key schedule to
	     account for these changes:

	     1. The decryption algorithm gets its key rounds in reverse order.
	     2. The decryption algorithm adds the round key before mixing columns
	       instead of afterwards.

	     We don't need to modify our key schedule to handle the first case,
	     we can just traverse the key schedule in reverse order when decrypting.

	     The second case requires a little work.

	     The tables we built for performing rounds will take an input and then
	     perform SubBytes() and MixColumns() or, for the decrypt version,
	     InvSubBytes() and InvMixColumns(). But the decrypt algorithm requires
	     us to AddRoundKey() before InvMixColumns(). This means we'll need to
	     apply some transformations to the round key to inverse-mix its columns
	     so they'll be correct for moving AddRoundKey() to after the state has
	     had its columns inverse-mixed.

	     To inverse-mix the columns of the state when we're decrypting we use a
	     lookup table that will apply InvSubBytes() and InvMixColumns() at the
	     same time. However, the round key's bytes are not inverse-substituted
	     in the decryption algorithm. To get around this problem, we can first
	     substitute the bytes in the round key so that when we apply the
	     transformation via the InvSubBytes()+InvMixColumns() table, it will
	     undo our substitution leaving us with the original value that we
	     want -- and then inverse-mix that value.

	     This change will correctly alter our key schedule so that we can XOR
	     each round key with our already transformed decryption state. This
	     allows us to use the same code path as the encryption algorithm.

	     We make one more change to the decryption key. Since the decryption
	     algorithm runs in reverse from the encryption algorithm, we reverse
	     the order of the round keys to avoid having to iterate over the key
	     schedule backwards when running the encryption algorithm later in
	     decryption mode. In addition to reversing the order of the round keys,
	     we also swap each round key's 2nd and 4th rows. See the comments
	     section where rounds are performed for more details about why this is
	     done. These changes are done inline with the other substitution
	     described above.
	  */
	  if(decrypt) {
	    var tmp;
	    var m0 = imix[0];
	    var m1 = imix[1];
	    var m2 = imix[2];
	    var m3 = imix[3];
	    var wnew = w.slice(0);
	    end = w.length;
	    for(var i = 0, wi = end - Nb; i < end; i += Nb, wi -= Nb) {
	      // do not sub the first or last round key (round keys are Nb
	      // words) as no column mixing is performed before they are added,
	      // but do change the key order
	      if(i === 0 || i === (end - Nb)) {
	        wnew[i] = w[wi];
	        wnew[i + 1] = w[wi + 3];
	        wnew[i + 2] = w[wi + 2];
	        wnew[i + 3] = w[wi + 1];
	      } else {
	        // substitute each round key byte because the inverse-mix
	        // table will inverse-substitute it (effectively cancel the
	        // substitution because round key bytes aren't sub'd in
	        // decryption mode) and swap indexes 3 and 1
	        for(var n = 0; n < Nb; ++n) {
	          tmp = w[wi + n];
	          wnew[i + (3&-n)] =
	            m0[sbox[tmp >>> 24]] ^
	            m1[sbox[tmp >>> 16 & 255]] ^
	            m2[sbox[tmp >>> 8 & 255]] ^
	            m3[sbox[tmp & 255]];
	        }
	      }
	    }
	    w = wnew;
	  }

	  return w;
	}

	/**
	 * Updates a single block (16 bytes) using AES. The update will either
	 * encrypt or decrypt the block.
	 *
	 * @param w the key schedule.
	 * @param input the input block (an array of 32-bit words).
	 * @param output the updated output block.
	 * @param decrypt true to decrypt the block, false to encrypt it.
	 */
	function _updateBlock$1(w, input, output, decrypt) {
	  /*
	  Cipher(byte in[4*Nb], byte out[4*Nb], word w[Nb*(Nr+1)])
	  begin
	    byte state[4,Nb]
	    state = in
	    AddRoundKey(state, w[0, Nb-1])
	    for round = 1 step 1 to Nr-1
	      SubBytes(state)
	      ShiftRows(state)
	      MixColumns(state)
	      AddRoundKey(state, w[round*Nb, (round+1)*Nb-1])
	    end for
	    SubBytes(state)
	    ShiftRows(state)
	    AddRoundKey(state, w[Nr*Nb, (Nr+1)*Nb-1])
	    out = state
	  end

	  InvCipher(byte in[4*Nb], byte out[4*Nb], word w[Nb*(Nr+1)])
	  begin
	    byte state[4,Nb]
	    state = in
	    AddRoundKey(state, w[Nr*Nb, (Nr+1)*Nb-1])
	    for round = Nr-1 step -1 downto 1
	      InvShiftRows(state)
	      InvSubBytes(state)
	      AddRoundKey(state, w[round*Nb, (round+1)*Nb-1])
	      InvMixColumns(state)
	    end for
	    InvShiftRows(state)
	    InvSubBytes(state)
	    AddRoundKey(state, w[0, Nb-1])
	    out = state
	  end
	  */

	  // Encrypt: AddRoundKey(state, w[0, Nb-1])
	  // Decrypt: AddRoundKey(state, w[Nr*Nb, (Nr+1)*Nb-1])
	  var Nr = w.length / 4 - 1;
	  var m0, m1, m2, m3, sub;
	  if(decrypt) {
	    m0 = imix[0];
	    m1 = imix[1];
	    m2 = imix[2];
	    m3 = imix[3];
	    sub = isbox;
	  } else {
	    m0 = mix[0];
	    m1 = mix[1];
	    m2 = mix[2];
	    m3 = mix[3];
	    sub = sbox;
	  }
	  var a, b, c, d, a2, b2, c2;
	  a = input[0] ^ w[0];
	  b = input[decrypt ? 3 : 1] ^ w[1];
	  c = input[2] ^ w[2];
	  d = input[decrypt ? 1 : 3] ^ w[3];
	  var i = 3;

	  /* In order to share code we follow the encryption algorithm when both
	    encrypting and decrypting. To account for the changes required in the
	    decryption algorithm, we use different lookup tables when decrypting
	    and use a modified key schedule to account for the difference in the
	    order of transformations applied when performing rounds. We also get
	    key rounds in reverse order (relative to encryption). */
	  for(var round = 1; round < Nr; ++round) {
	    /* As described above, we'll be using table lookups to perform the
	      column mixing. Each column is stored as a word in the state (the
	      array 'input' has one column as a word at each index). In order to
	      mix a column, we perform these transformations on each row in c,
	      which is 1 byte in each word. The new column for c0 is c'0:

	               m0      m1      m2      m3
	      r0,c'0 = 2*r0,c0 + 3*r1,c0 + 1*r2,c0 + 1*r3,c0
	      r1,c'0 = 1*r0,c0 + 2*r1,c0 + 3*r2,c0 + 1*r3,c0
	      r2,c'0 = 1*r0,c0 + 1*r1,c0 + 2*r2,c0 + 3*r3,c0
	      r3,c'0 = 3*r0,c0 + 1*r1,c0 + 1*r2,c0 + 2*r3,c0

	      So using mix tables where c0 is a word with r0 being its upper
	      8 bits and r3 being its lower 8 bits:

	      m0[c0 >> 24] will yield this word: [2*r0,1*r0,1*r0,3*r0]
	      ...
	      m3[c0 & 255] will yield this word: [1*r3,1*r3,3*r3,2*r3]

	      Therefore to mix the columns in each word in the state we
	      do the following (& 255 omitted for brevity):
	      c'0,r0 = m0[c0 >> 24] ^ m1[c1 >> 16] ^ m2[c2 >> 8] ^ m3[c3]
	      c'0,r1 = m0[c0 >> 24] ^ m1[c1 >> 16] ^ m2[c2 >> 8] ^ m3[c3]
	      c'0,r2 = m0[c0 >> 24] ^ m1[c1 >> 16] ^ m2[c2 >> 8] ^ m3[c3]
	      c'0,r3 = m0[c0 >> 24] ^ m1[c1 >> 16] ^ m2[c2 >> 8] ^ m3[c3]

	      However, before mixing, the algorithm requires us to perform
	      ShiftRows(). The ShiftRows() transformation cyclically shifts the
	      last 3 rows of the state over different offsets. The first row
	      (r = 0) is not shifted.

	      s'_r,c = s_r,(c + shift(r, Nb) mod Nb
	      for 0 < r < 4 and 0 <= c < Nb and
	      shift(1, 4) = 1
	      shift(2, 4) = 2
	      shift(3, 4) = 3.

	      This causes the first byte in r = 1 to be moved to the end of
	      the row, the first 2 bytes in r = 2 to be moved to the end of
	      the row, the first 3 bytes in r = 3 to be moved to the end of
	      the row:

	      r1: [c0 c1 c2 c3] => [c1 c2 c3 c0]
	      r2: [c0 c1 c2 c3]    [c2 c3 c0 c1]
	      r3: [c0 c1 c2 c3]    [c3 c0 c1 c2]

	      We can make these substitutions inline with our column mixing to
	      generate an updated set of equations to produce each word in the
	      state (note the columns have changed positions):

	      c0 c1 c2 c3 => c0 c1 c2 c3
	      c0 c1 c2 c3    c1 c2 c3 c0  (cycled 1 byte)
	      c0 c1 c2 c3    c2 c3 c0 c1  (cycled 2 bytes)
	      c0 c1 c2 c3    c3 c0 c1 c2  (cycled 3 bytes)

	      Therefore:

	      c'0 = 2*r0,c0 + 3*r1,c1 + 1*r2,c2 + 1*r3,c3
	      c'0 = 1*r0,c0 + 2*r1,c1 + 3*r2,c2 + 1*r3,c3
	      c'0 = 1*r0,c0 + 1*r1,c1 + 2*r2,c2 + 3*r3,c3
	      c'0 = 3*r0,c0 + 1*r1,c1 + 1*r2,c2 + 2*r3,c3

	      c'1 = 2*r0,c1 + 3*r1,c2 + 1*r2,c3 + 1*r3,c0
	      c'1 = 1*r0,c1 + 2*r1,c2 + 3*r2,c3 + 1*r3,c0
	      c'1 = 1*r0,c1 + 1*r1,c2 + 2*r2,c3 + 3*r3,c0
	      c'1 = 3*r0,c1 + 1*r1,c2 + 1*r2,c3 + 2*r3,c0

	      ... and so forth for c'2 and c'3. The important distinction is
	      that the columns are cycling, with c0 being used with the m0
	      map when calculating c0, but c1 being used with the m0 map when
	      calculating c1 ... and so forth.

	      When performing the inverse we transform the mirror image and
	      skip the bottom row, instead of the top one, and move upwards:

	      c3 c2 c1 c0 => c0 c3 c2 c1  (cycled 3 bytes) *same as encryption
	      c3 c2 c1 c0    c1 c0 c3 c2  (cycled 2 bytes)
	      c3 c2 c1 c0    c2 c1 c0 c3  (cycled 1 byte)  *same as encryption
	      c3 c2 c1 c0    c3 c2 c1 c0

	      If you compare the resulting matrices for ShiftRows()+MixColumns()
	      and for InvShiftRows()+InvMixColumns() the 2nd and 4th columns are
	      different (in encrypt mode vs. decrypt mode). So in order to use
	      the same code to handle both encryption and decryption, we will
	      need to do some mapping.

	      If in encryption mode we let a=c0, b=c1, c=c2, d=c3, and r<N> be
	      a row number in the state, then the resulting matrix in encryption
	      mode for applying the above transformations would be:

	      r1: a b c d
	      r2: b c d a
	      r3: c d a b
	      r4: d a b c

	      If we did the same in decryption mode we would get:

	      r1: a d c b
	      r2: b a d c
	      r3: c b a d
	      r4: d c b a

	      If instead we swap d and b (set b=c3 and d=c1), then we get:

	      r1: a b c d
	      r2: d a b c
	      r3: c d a b
	      r4: b c d a

	      Now the 1st and 3rd rows are the same as the encryption matrix. All
	      we need to do then to make the mapping exactly the same is to swap
	      the 2nd and 4th rows when in decryption mode. To do this without
	      having to do it on each iteration, we swapped the 2nd and 4th rows
	      in the decryption key schedule. We also have to do the swap above
	      when we first pull in the input and when we set the final output. */
	    a2 =
	      m0[a >>> 24] ^
	      m1[b >>> 16 & 255] ^
	      m2[c >>> 8 & 255] ^
	      m3[d & 255] ^ w[++i];
	    b2 =
	      m0[b >>> 24] ^
	      m1[c >>> 16 & 255] ^
	      m2[d >>> 8 & 255] ^
	      m3[a & 255] ^ w[++i];
	    c2 =
	      m0[c >>> 24] ^
	      m1[d >>> 16 & 255] ^
	      m2[a >>> 8 & 255] ^
	      m3[b & 255] ^ w[++i];
	    d =
	      m0[d >>> 24] ^
	      m1[a >>> 16 & 255] ^
	      m2[b >>> 8 & 255] ^
	      m3[c & 255] ^ w[++i];
	    a = a2;
	    b = b2;
	    c = c2;
	  }

	  /*
	    Encrypt:
	    SubBytes(state)
	    ShiftRows(state)
	    AddRoundKey(state, w[Nr*Nb, (Nr+1)*Nb-1])

	    Decrypt:
	    InvShiftRows(state)
	    InvSubBytes(state)
	    AddRoundKey(state, w[0, Nb-1])
	   */
	  // Note: rows are shifted inline
	  output[0] =
	    (sub[a >>> 24] << 24) ^
	    (sub[b >>> 16 & 255] << 16) ^
	    (sub[c >>> 8 & 255] << 8) ^
	    (sub[d & 255]) ^ w[++i];
	  output[decrypt ? 3 : 1] =
	    (sub[b >>> 24] << 24) ^
	    (sub[c >>> 16 & 255] << 16) ^
	    (sub[d >>> 8 & 255] << 8) ^
	    (sub[a & 255]) ^ w[++i];
	  output[2] =
	    (sub[c >>> 24] << 24) ^
	    (sub[d >>> 16 & 255] << 16) ^
	    (sub[a >>> 8 & 255] << 8) ^
	    (sub[b & 255]) ^ w[++i];
	  output[decrypt ? 1 : 3] =
	    (sub[d >>> 24] << 24) ^
	    (sub[a >>> 16 & 255] << 16) ^
	    (sub[b >>> 8 & 255] << 8) ^
	    (sub[c & 255]) ^ w[++i];
	}

	/**
	 * Deprecated. Instead, use:
	 *
	 * forge.cipher.createCipher('AES-<mode>', key);
	 * forge.cipher.createDecipher('AES-<mode>', key);
	 *
	 * Creates a deprecated AES cipher object. This object's mode will default to
	 * CBC (cipher-block-chaining).
	 *
	 * The key and iv may be given as a string of bytes, an array of bytes, a
	 * byte buffer, or an array of 32-bit words.
	 *
	 * @param options the options to use.
	 *          key the symmetric key to use.
	 *          output the buffer to write to.
	 *          decrypt true for decryption, false for encryption.
	 *          mode the cipher mode to use (default: 'CBC').
	 *
	 * @return the cipher.
	 */
	function _createCipher$1(options) {
	  options = options || {};
	  var mode = (options.mode || 'CBC').toUpperCase();
	  var algorithm = 'AES-' + mode;

	  var cipher;
	  if(options.decrypt) {
	    cipher = forge.cipher.createDecipher(algorithm, options.key);
	  } else {
	    cipher = forge.cipher.createCipher(algorithm, options.key);
	  }

	  // backwards compatible start API
	  var start = cipher.start;
	  cipher.start = function(iv, options) {
	    // backwards compatibility: support second arg as output buffer
	    var output = null;
	    if(options instanceof forge.util.ByteBuffer) {
	      output = options;
	      options = {};
	    }
	    options = options || {};
	    options.output = output;
	    options.iv = iv;
	    start.call(cipher, options);
	  };

	  return cipher;
	}

	createCommonjsModule(function (module) {
	/**
	 * Object IDs for ASN.1.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2013 Digital Bazaar, Inc.
	 */


	forge.pki = forge.pki || {};
	var oids = module.exports = forge.pki.oids = forge.oids = forge.oids || {};

	// set id to name mapping and name to id mapping
	function _IN(id, name) {
	  oids[id] = name;
	  oids[name] = id;
	}
	// set id to name mapping only
	function _I_(id, name) {
	  oids[id] = name;
	}

	// algorithm OIDs
	_IN('1.2.840.113549.1.1.1', 'rsaEncryption');
	// Note: md2 & md4 not implemented
	//_IN('1.2.840.113549.1.1.2', 'md2WithRSAEncryption');
	//_IN('1.2.840.113549.1.1.3', 'md4WithRSAEncryption');
	_IN('1.2.840.113549.1.1.4', 'md5WithRSAEncryption');
	_IN('1.2.840.113549.1.1.5', 'sha1WithRSAEncryption');
	_IN('1.2.840.113549.1.1.7', 'RSAES-OAEP');
	_IN('1.2.840.113549.1.1.8', 'mgf1');
	_IN('1.2.840.113549.1.1.9', 'pSpecified');
	_IN('1.2.840.113549.1.1.10', 'RSASSA-PSS');
	_IN('1.2.840.113549.1.1.11', 'sha256WithRSAEncryption');
	_IN('1.2.840.113549.1.1.12', 'sha384WithRSAEncryption');
	_IN('1.2.840.113549.1.1.13', 'sha512WithRSAEncryption');
	// Edwards-curve Digital Signature Algorithm (EdDSA) Ed25519
	_IN('1.3.101.112', 'EdDSA25519');

	_IN('1.2.840.10040.4.3', 'dsa-with-sha1');

	_IN('1.3.14.3.2.7', 'desCBC');

	_IN('1.3.14.3.2.26', 'sha1');
	_IN('2.16.840.1.101.3.4.2.1', 'sha256');
	_IN('2.16.840.1.101.3.4.2.2', 'sha384');
	_IN('2.16.840.1.101.3.4.2.3', 'sha512');
	_IN('1.2.840.113549.2.5', 'md5');

	// pkcs#7 content types
	_IN('1.2.840.113549.1.7.1', 'data');
	_IN('1.2.840.113549.1.7.2', 'signedData');
	_IN('1.2.840.113549.1.7.3', 'envelopedData');
	_IN('1.2.840.113549.1.7.4', 'signedAndEnvelopedData');
	_IN('1.2.840.113549.1.7.5', 'digestedData');
	_IN('1.2.840.113549.1.7.6', 'encryptedData');

	// pkcs#9 oids
	_IN('1.2.840.113549.1.9.1', 'emailAddress');
	_IN('1.2.840.113549.1.9.2', 'unstructuredName');
	_IN('1.2.840.113549.1.9.3', 'contentType');
	_IN('1.2.840.113549.1.9.4', 'messageDigest');
	_IN('1.2.840.113549.1.9.5', 'signingTime');
	_IN('1.2.840.113549.1.9.6', 'counterSignature');
	_IN('1.2.840.113549.1.9.7', 'challengePassword');
	_IN('1.2.840.113549.1.9.8', 'unstructuredAddress');
	_IN('1.2.840.113549.1.9.14', 'extensionRequest');

	_IN('1.2.840.113549.1.9.20', 'friendlyName');
	_IN('1.2.840.113549.1.9.21', 'localKeyId');
	_IN('1.2.840.113549.1.9.22.1', 'x509Certificate');

	// pkcs#12 safe bags
	_IN('1.2.840.113549.1.12.10.1.1', 'keyBag');
	_IN('1.2.840.113549.1.12.10.1.2', 'pkcs8ShroudedKeyBag');
	_IN('1.2.840.113549.1.12.10.1.3', 'certBag');
	_IN('1.2.840.113549.1.12.10.1.4', 'crlBag');
	_IN('1.2.840.113549.1.12.10.1.5', 'secretBag');
	_IN('1.2.840.113549.1.12.10.1.6', 'safeContentsBag');

	// password-based-encryption for pkcs#12
	_IN('1.2.840.113549.1.5.13', 'pkcs5PBES2');
	_IN('1.2.840.113549.1.5.12', 'pkcs5PBKDF2');

	_IN('1.2.840.113549.1.12.1.1', 'pbeWithSHAAnd128BitRC4');
	_IN('1.2.840.113549.1.12.1.2', 'pbeWithSHAAnd40BitRC4');
	_IN('1.2.840.113549.1.12.1.3', 'pbeWithSHAAnd3-KeyTripleDES-CBC');
	_IN('1.2.840.113549.1.12.1.4', 'pbeWithSHAAnd2-KeyTripleDES-CBC');
	_IN('1.2.840.113549.1.12.1.5', 'pbeWithSHAAnd128BitRC2-CBC');
	_IN('1.2.840.113549.1.12.1.6', 'pbewithSHAAnd40BitRC2-CBC');

	// hmac OIDs
	_IN('1.2.840.113549.2.7', 'hmacWithSHA1');
	_IN('1.2.840.113549.2.8', 'hmacWithSHA224');
	_IN('1.2.840.113549.2.9', 'hmacWithSHA256');
	_IN('1.2.840.113549.2.10', 'hmacWithSHA384');
	_IN('1.2.840.113549.2.11', 'hmacWithSHA512');

	// symmetric key algorithm oids
	_IN('1.2.840.113549.3.7', 'des-EDE3-CBC');
	_IN('2.16.840.1.101.3.4.1.2', 'aes128-CBC');
	_IN('2.16.840.1.101.3.4.1.22', 'aes192-CBC');
	_IN('2.16.840.1.101.3.4.1.42', 'aes256-CBC');

	// certificate issuer/subject OIDs
	_IN('2.5.4.3', 'commonName');
	_IN('2.5.4.5', 'serialName');
	_IN('2.5.4.6', 'countryName');
	_IN('2.5.4.7', 'localityName');
	_IN('2.5.4.8', 'stateOrProvinceName');
	_IN('2.5.4.9', 'streetAddress');
	_IN('2.5.4.10', 'organizationName');
	_IN('2.5.4.11', 'organizationalUnitName');
	_IN('2.5.4.13', 'description');
	_IN('2.5.4.15', 'businessCategory');
	_IN('2.5.4.17', 'postalCode');
	_IN('1.3.6.1.4.1.311.60.2.1.2', 'jurisdictionOfIncorporationStateOrProvinceName');
	_IN('1.3.6.1.4.1.311.60.2.1.3', 'jurisdictionOfIncorporationCountryName');

	// X.509 extension OIDs
	_IN('2.16.840.1.113730.1.1', 'nsCertType');
	_IN('2.16.840.1.113730.1.13', 'nsComment'); // deprecated in theory; still widely used
	_I_('2.5.29.1', 'authorityKeyIdentifier'); // deprecated, use .35
	_I_('2.5.29.2', 'keyAttributes'); // obsolete use .37 or .15
	_I_('2.5.29.3', 'certificatePolicies'); // deprecated, use .32
	_I_('2.5.29.4', 'keyUsageRestriction'); // obsolete use .37 or .15
	_I_('2.5.29.5', 'policyMapping'); // deprecated use .33
	_I_('2.5.29.6', 'subtreesConstraint'); // obsolete use .30
	_I_('2.5.29.7', 'subjectAltName'); // deprecated use .17
	_I_('2.5.29.8', 'issuerAltName'); // deprecated use .18
	_I_('2.5.29.9', 'subjectDirectoryAttributes');
	_I_('2.5.29.10', 'basicConstraints'); // deprecated use .19
	_I_('2.5.29.11', 'nameConstraints'); // deprecated use .30
	_I_('2.5.29.12', 'policyConstraints'); // deprecated use .36
	_I_('2.5.29.13', 'basicConstraints'); // deprecated use .19
	_IN('2.5.29.14', 'subjectKeyIdentifier');
	_IN('2.5.29.15', 'keyUsage');
	_I_('2.5.29.16', 'privateKeyUsagePeriod');
	_IN('2.5.29.17', 'subjectAltName');
	_IN('2.5.29.18', 'issuerAltName');
	_IN('2.5.29.19', 'basicConstraints');
	_I_('2.5.29.20', 'cRLNumber');
	_I_('2.5.29.21', 'cRLReason');
	_I_('2.5.29.22', 'expirationDate');
	_I_('2.5.29.23', 'instructionCode');
	_I_('2.5.29.24', 'invalidityDate');
	_I_('2.5.29.25', 'cRLDistributionPoints'); // deprecated use .31
	_I_('2.5.29.26', 'issuingDistributionPoint'); // deprecated use .28
	_I_('2.5.29.27', 'deltaCRLIndicator');
	_I_('2.5.29.28', 'issuingDistributionPoint');
	_I_('2.5.29.29', 'certificateIssuer');
	_I_('2.5.29.30', 'nameConstraints');
	_IN('2.5.29.31', 'cRLDistributionPoints');
	_IN('2.5.29.32', 'certificatePolicies');
	_I_('2.5.29.33', 'policyMappings');
	_I_('2.5.29.34', 'policyConstraints'); // deprecated use .36
	_IN('2.5.29.35', 'authorityKeyIdentifier');
	_I_('2.5.29.36', 'policyConstraints');
	_IN('2.5.29.37', 'extKeyUsage');
	_I_('2.5.29.46', 'freshestCRL');
	_I_('2.5.29.54', 'inhibitAnyPolicy');

	// extKeyUsage purposes
	_IN('1.3.6.1.4.1.11129.2.4.2', 'timestampList');
	_IN('1.3.6.1.5.5.7.1.1', 'authorityInfoAccess');
	_IN('1.3.6.1.5.5.7.3.1', 'serverAuth');
	_IN('1.3.6.1.5.5.7.3.2', 'clientAuth');
	_IN('1.3.6.1.5.5.7.3.3', 'codeSigning');
	_IN('1.3.6.1.5.5.7.3.4', 'emailProtection');
	_IN('1.3.6.1.5.5.7.3.8', 'timeStamping');
	});

	createCommonjsModule(function (module) {
	/**
	 * Javascript implementation of Abstract Syntax Notation Number One.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2015 Digital Bazaar, Inc.
	 *
	 * An API for storing data using the Abstract Syntax Notation Number One
	 * format using DER (Distinguished Encoding Rules) encoding. This encoding is
	 * commonly used to store data for PKI, i.e. X.509 Certificates, and this
	 * implementation exists for that purpose.
	 *
	 * Abstract Syntax Notation Number One (ASN.1) is used to define the abstract
	 * syntax of information without restricting the way the information is encoded
	 * for transmission. It provides a standard that allows for open systems
	 * communication. ASN.1 defines the syntax of information data and a number of
	 * simple data types as well as a notation for describing them and specifying
	 * values for them.
	 *
	 * The RSA algorithm creates public and private keys that are often stored in
	 * X.509 or PKCS#X formats -- which use ASN.1 (encoded in DER format). This
	 * class provides the most basic functionality required to store and load DSA
	 * keys that are encoded according to ASN.1.
	 *
	 * The most common binary encodings for ASN.1 are BER (Basic Encoding Rules)
	 * and DER (Distinguished Encoding Rules). DER is just a subset of BER that
	 * has stricter requirements for how data must be encoded.
	 *
	 * Each ASN.1 structure has a tag (a byte identifying the ASN.1 structure type)
	 * and a byte array for the value of this ASN1 structure which may be data or a
	 * list of ASN.1 structures.
	 *
	 * Each ASN.1 structure using BER is (Tag-Length-Value):
	 *
	 * | byte 0 | bytes X | bytes Y |
	 * |--------|---------|----------
	 * |  tag   | length  |  value  |
	 *
	 * ASN.1 allows for tags to be of "High-tag-number form" which allows a tag to
	 * be two or more octets, but that is not supported by this class. A tag is
	 * only 1 byte. Bits 1-5 give the tag number (ie the data type within a
	 * particular 'class'), 6 indicates whether or not the ASN.1 value is
	 * constructed from other ASN.1 values, and bits 7 and 8 give the 'class'. If
	 * bits 7 and 8 are both zero, the class is UNIVERSAL. If only bit 7 is set,
	 * then the class is APPLICATION. If only bit 8 is set, then the class is
	 * CONTEXT_SPECIFIC. If both bits 7 and 8 are set, then the class is PRIVATE.
	 * The tag numbers for the data types for the class UNIVERSAL are listed below:
	 *
	 * UNIVERSAL 0 Reserved for use by the encoding rules
	 * UNIVERSAL 1 Boolean type
	 * UNIVERSAL 2 Integer type
	 * UNIVERSAL 3 Bitstring type
	 * UNIVERSAL 4 Octetstring type
	 * UNIVERSAL 5 Null type
	 * UNIVERSAL 6 Object identifier type
	 * UNIVERSAL 7 Object descriptor type
	 * UNIVERSAL 8 External type and Instance-of type
	 * UNIVERSAL 9 Real type
	 * UNIVERSAL 10 Enumerated type
	 * UNIVERSAL 11 Embedded-pdv type
	 * UNIVERSAL 12 UTF8String type
	 * UNIVERSAL 13 Relative object identifier type
	 * UNIVERSAL 14-15 Reserved for future editions
	 * UNIVERSAL 16 Sequence and Sequence-of types
	 * UNIVERSAL 17 Set and Set-of types
	 * UNIVERSAL 18-22, 25-30 Character string types
	 * UNIVERSAL 23-24 Time types
	 *
	 * The length of an ASN.1 structure is specified after the tag identifier.
	 * There is a definite form and an indefinite form. The indefinite form may
	 * be used if the encoding is constructed and not all immediately available.
	 * The indefinite form is encoded using a length byte with only the 8th bit
	 * set. The end of the constructed object is marked using end-of-contents
	 * octets (two zero bytes).
	 *
	 * The definite form looks like this:
	 *
	 * The length may take up 1 or more bytes, it depends on the length of the
	 * value of the ASN.1 structure. DER encoding requires that if the ASN.1
	 * structure has a value that has a length greater than 127, more than 1 byte
	 * will be used to store its length, otherwise just one byte will be used.
	 * This is strict.
	 *
	 * In the case that the length of the ASN.1 value is less than 127, 1 octet
	 * (byte) is used to store the "short form" length. The 8th bit has a value of
	 * 0 indicating the length is "short form" and not "long form" and bits 7-1
	 * give the length of the data. (The 8th bit is the left-most, most significant
	 * bit: also known as big endian or network format).
	 *
	 * In the case that the length of the ASN.1 value is greater than 127, 2 to
	 * 127 octets (bytes) are used to store the "long form" length. The first
	 * byte's 8th bit is set to 1 to indicate the length is "long form." Bits 7-1
	 * give the number of additional octets. All following octets are in base 256
	 * with the most significant digit first (typical big-endian binary unsigned
	 * integer storage). So, for instance, if the length of a value was 257, the
	 * first byte would be set to:
	 *
	 * 10000010 = 130 = 0x82.
	 *
	 * This indicates there are 2 octets (base 256) for the length. The second and
	 * third bytes (the octets just mentioned) would store the length in base 256:
	 *
	 * octet 2: 00000001 = 1 * 256^1 = 256
	 * octet 3: 00000001 = 1 * 256^0 = 1
	 * total = 257
	 *
	 * The algorithm for converting a js integer value of 257 to base-256 is:
	 *
	 * var value = 257;
	 * var bytes = [];
	 * bytes[0] = (value >>> 8) & 0xFF; // most significant byte first
	 * bytes[1] = value & 0xFF;        // least significant byte last
	 *
	 * On the ASN.1 UNIVERSAL Object Identifier (OID) type:
	 *
	 * An OID can be written like: "value1.value2.value3...valueN"
	 *
	 * The DER encoding rules:
	 *
	 * The first byte has the value 40 * value1 + value2.
	 * The following bytes, if any, encode the remaining values. Each value is
	 * encoded in base 128, most significant digit first (big endian), with as
	 * few digits as possible, and the most significant bit of each byte set
	 * to 1 except the last in each value's encoding. For example: Given the
	 * OID "1.2.840.113549", its DER encoding is (remember each byte except the
	 * last one in each encoding is OR'd with 0x80):
	 *
	 * byte 1: 40 * 1 + 2 = 42 = 0x2A.
	 * bytes 2-3: 128 * 6 + 72 = 840 = 6 72 = 6 72 = 0x0648 = 0x8648
	 * bytes 4-6: 16384 * 6 + 128 * 119 + 13 = 6 119 13 = 0x06770D = 0x86F70D
	 *
	 * The final value is: 0x2A864886F70D.
	 * The full OID (including ASN.1 tag and length of 6 bytes) is:
	 * 0x06062A864886F70D
	 */




	/* ASN.1 API */
	var asn1 = module.exports = forge.asn1 = forge.asn1 || {};

	/**
	 * ASN.1 classes.
	 */
	asn1.Class = {
	  UNIVERSAL:        0x00,
	  APPLICATION:      0x40,
	  CONTEXT_SPECIFIC: 0x80,
	  PRIVATE:          0xC0
	};

	/**
	 * ASN.1 types. Not all types are supported by this implementation, only
	 * those necessary to implement a simple PKI are implemented.
	 */
	asn1.Type = {
	  NONE:             0,
	  BOOLEAN:          1,
	  INTEGER:          2,
	  BITSTRING:        3,
	  OCTETSTRING:      4,
	  NULL:             5,
	  OID:              6,
	  ODESC:            7,
	  EXTERNAL:         8,
	  REAL:             9,
	  ENUMERATED:      10,
	  EMBEDDED:        11,
	  UTF8:            12,
	  ROID:            13,
	  SEQUENCE:        16,
	  SET:             17,
	  PRINTABLESTRING: 19,
	  IA5STRING:       22,
	  UTCTIME:         23,
	  GENERALIZEDTIME: 24,
	  BMPSTRING:       30
	};

	/**
	 * Creates a new asn1 object.
	 *
	 * @param tagClass the tag class for the object.
	 * @param type the data type (tag number) for the object.
	 * @param constructed true if the asn1 object is in constructed form.
	 * @param value the value for the object, if it is not constructed.
	 * @param [options] the options to use:
	 *          [bitStringContents] the plain BIT STRING content including padding
	 *            byte.
	 *
	 * @return the asn1 object.
	 */
	asn1.create = function(tagClass, type, constructed, value, options) {
	  /* An asn1 object has a tagClass, a type, a constructed flag, and a
	    value. The value's type depends on the constructed flag. If
	    constructed, it will contain a list of other asn1 objects. If not,
	    it will contain the ASN.1 value as an array of bytes formatted
	    according to the ASN.1 data type. */

	  // remove undefined values
	  if(forge.util.isArray(value)) {
	    var tmp = [];
	    for(var i = 0; i < value.length; ++i) {
	      if(value[i] !== undefined) {
	        tmp.push(value[i]);
	      }
	    }
	    value = tmp;
	  }

	  var obj = {
	    tagClass: tagClass,
	    type: type,
	    constructed: constructed,
	    composed: constructed || forge.util.isArray(value),
	    value: value
	  };
	  if(options && 'bitStringContents' in options) {
	    // TODO: copy byte buffer if it's a buffer not a string
	    obj.bitStringContents = options.bitStringContents;
	    // TODO: add readonly flag to avoid this overhead
	    // save copy to detect changes
	    obj.original = asn1.copy(obj);
	  }
	  return obj;
	};

	/**
	 * Copies an asn1 object.
	 *
	 * @param obj the asn1 object.
	 * @param [options] copy options:
	 *          [excludeBitStringContents] true to not copy bitStringContents
	 *
	 * @return the a copy of the asn1 object.
	 */
	asn1.copy = function(obj, options) {
	  var copy;

	  if(forge.util.isArray(obj)) {
	    copy = [];
	    for(var i = 0; i < obj.length; ++i) {
	      copy.push(asn1.copy(obj[i], options));
	    }
	    return copy;
	  }

	  if(typeof obj === 'string') {
	    // TODO: copy byte buffer if it's a buffer not a string
	    return obj;
	  }

	  copy = {
	    tagClass: obj.tagClass,
	    type: obj.type,
	    constructed: obj.constructed,
	    composed: obj.composed,
	    value: asn1.copy(obj.value, options)
	  };
	  if(options && !options.excludeBitStringContents) {
	    // TODO: copy byte buffer if it's a buffer not a string
	    copy.bitStringContents = obj.bitStringContents;
	  }
	  return copy;
	};

	/**
	 * Compares asn1 objects for equality.
	 *
	 * Note this function does not run in constant time.
	 *
	 * @param obj1 the first asn1 object.
	 * @param obj2 the second asn1 object.
	 * @param [options] compare options:
	 *          [includeBitStringContents] true to compare bitStringContents
	 *
	 * @return true if the asn1 objects are equal.
	 */
	asn1.equals = function(obj1, obj2, options) {
	  if(forge.util.isArray(obj1)) {
	    if(!forge.util.isArray(obj2)) {
	      return false;
	    }
	    if(obj1.length !== obj2.length) {
	      return false;
	    }
	    for(var i = 0; i < obj1.length; ++i) {
	      if(!asn1.equals(obj1[i], obj2[i])) {
	        return false;
	      }
	    }
	    return true;
	  }

	  if(typeof obj1 !== typeof obj2) {
	    return false;
	  }

	  if(typeof obj1 === 'string') {
	    return obj1 === obj2;
	  }

	  var equal = obj1.tagClass === obj2.tagClass &&
	    obj1.type === obj2.type &&
	    obj1.constructed === obj2.constructed &&
	    obj1.composed === obj2.composed &&
	    asn1.equals(obj1.value, obj2.value);
	  if(options && options.includeBitStringContents) {
	    equal = equal && (obj1.bitStringContents === obj2.bitStringContents);
	  }

	  return equal;
	};

	/**
	 * Gets the length of a BER-encoded ASN.1 value.
	 *
	 * In case the length is not specified, undefined is returned.
	 *
	 * @param b the BER-encoded ASN.1 byte buffer, starting with the first
	 *          length byte.
	 *
	 * @return the length of the BER-encoded ASN.1 value or undefined.
	 */
	asn1.getBerValueLength = function(b) {
	  // TODO: move this function and related DER/BER functions to a der.js
	  // file; better abstract ASN.1 away from der/ber.
	  var b2 = b.getByte();
	  if(b2 === 0x80) {
	    return undefined;
	  }

	  // see if the length is "short form" or "long form" (bit 8 set)
	  var length;
	  var longForm = b2 & 0x80;
	  if(!longForm) {
	    // length is just the first byte
	    length = b2;
	  } else {
	    // the number of bytes the length is specified in bits 7 through 1
	    // and each length byte is in big-endian base-256
	    length = b.getInt((b2 & 0x7F) << 3);
	  }
	  return length;
	};

	/**
	 * Check if the byte buffer has enough bytes. Throws an Error if not.
	 *
	 * @param bytes the byte buffer to parse from.
	 * @param remaining the bytes remaining in the current parsing state.
	 * @param n the number of bytes the buffer must have.
	 */
	function _checkBufferLength(bytes, remaining, n) {
	  if(n > remaining) {
	    var error = new Error('Too few bytes to parse DER.');
	    error.available = bytes.length();
	    error.remaining = remaining;
	    error.requested = n;
	    throw error;
	  }
	}

	/**
	 * Gets the length of a BER-encoded ASN.1 value.
	 *
	 * In case the length is not specified, undefined is returned.
	 *
	 * @param bytes the byte buffer to parse from.
	 * @param remaining the bytes remaining in the current parsing state.
	 *
	 * @return the length of the BER-encoded ASN.1 value or undefined.
	 */
	var _getValueLength = function(bytes, remaining) {
	  // TODO: move this function and related DER/BER functions to a der.js
	  // file; better abstract ASN.1 away from der/ber.
	  // fromDer already checked that this byte exists
	  var b2 = bytes.getByte();
	  remaining--;
	  if(b2 === 0x80) {
	    return undefined;
	  }

	  // see if the length is "short form" or "long form" (bit 8 set)
	  var length;
	  var longForm = b2 & 0x80;
	  if(!longForm) {
	    // length is just the first byte
	    length = b2;
	  } else {
	    // the number of bytes the length is specified in bits 7 through 1
	    // and each length byte is in big-endian base-256
	    var longFormBytes = b2 & 0x7F;
	    _checkBufferLength(bytes, remaining, longFormBytes);
	    length = bytes.getInt(longFormBytes << 3);
	  }
	  // FIXME: this will only happen for 32 bit getInt with high bit set
	  if(length < 0) {
	    throw new Error('Negative length: ' + length);
	  }
	  return length;
	};

	/**
	 * Parses an asn1 object from a byte buffer in DER format.
	 *
	 * @param bytes the byte buffer to parse from.
	 * @param [strict] true to be strict when checking value lengths, false to
	 *          allow truncated values (default: true).
	 * @param [options] object with options or boolean strict flag
	 *          [strict] true to be strict when checking value lengths, false to
	 *            allow truncated values (default: true).
	 *          [decodeBitStrings] true to attempt to decode the content of
	 *            BIT STRINGs (not OCTET STRINGs) using strict mode. Note that
	 *            without schema support to understand the data context this can
	 *            erroneously decode values that happen to be valid ASN.1. This
	 *            flag will be deprecated or removed as soon as schema support is
	 *            available. (default: true)
	 *
	 * @return the parsed asn1 object.
	 */
	asn1.fromDer = function(bytes, options) {
	  if(options === undefined) {
	    options = {
	      strict: true,
	      decodeBitStrings: true
	    };
	  }
	  if(typeof options === 'boolean') {
	    options = {
	      strict: options,
	      decodeBitStrings: true
	    };
	  }
	  if(!('strict' in options)) {
	    options.strict = true;
	  }
	  if(!('decodeBitStrings' in options)) {
	    options.decodeBitStrings = true;
	  }

	  // wrap in buffer if needed
	  if(typeof bytes === 'string') {
	    bytes = forge.util.createBuffer(bytes);
	  }

	  return _fromDer(bytes, bytes.length(), 0, options);
	};

	/**
	 * Internal function to parse an asn1 object from a byte buffer in DER format.
	 *
	 * @param bytes the byte buffer to parse from.
	 * @param remaining the number of bytes remaining for this chunk.
	 * @param depth the current parsing depth.
	 * @param options object with same options as fromDer().
	 *
	 * @return the parsed asn1 object.
	 */
	function _fromDer(bytes, remaining, depth, options) {
	  // temporary storage for consumption calculations
	  var start;

	  // minimum length for ASN.1 DER structure is 2
	  _checkBufferLength(bytes, remaining, 2);

	  // get the first byte
	  var b1 = bytes.getByte();
	  // consumed one byte
	  remaining--;

	  // get the tag class
	  var tagClass = (b1 & 0xC0);

	  // get the type (bits 1-5)
	  var type = b1 & 0x1F;

	  // get the variable value length and adjust remaining bytes
	  start = bytes.length();
	  var length = _getValueLength(bytes, remaining);
	  remaining -= start - bytes.length();

	  // ensure there are enough bytes to get the value
	  if(length !== undefined && length > remaining) {
	    if(options.strict) {
	      var error = new Error('Too few bytes to read ASN.1 value.');
	      error.available = bytes.length();
	      error.remaining = remaining;
	      error.requested = length;
	      throw error;
	    }
	    // Note: be lenient with truncated values and use remaining state bytes
	    length = remaining;
	  }

	  // value storage
	  var value;
	  // possible BIT STRING contents storage
	  var bitStringContents;

	  // constructed flag is bit 6 (32 = 0x20) of the first byte
	  var constructed = ((b1 & 0x20) === 0x20);
	  if(constructed) {
	    // parse child asn1 objects from the value
	    value = [];
	    if(length === undefined) {
	      // asn1 object of indefinite length, read until end tag
	      for(;;) {
	        _checkBufferLength(bytes, remaining, 2);
	        if(bytes.bytes(2) === String.fromCharCode(0, 0)) {
	          bytes.getBytes(2);
	          remaining -= 2;
	          break;
	        }
	        start = bytes.length();
	        value.push(_fromDer(bytes, remaining, depth + 1, options));
	        remaining -= start - bytes.length();
	      }
	    } else {
	      // parsing asn1 object of definite length
	      while(length > 0) {
	        start = bytes.length();
	        value.push(_fromDer(bytes, length, depth + 1, options));
	        remaining -= start - bytes.length();
	        length -= start - bytes.length();
	      }
	    }
	  }

	  // if a BIT STRING, save the contents including padding
	  if(value === undefined && tagClass === asn1.Class.UNIVERSAL &&
	    type === asn1.Type.BITSTRING) {
	    bitStringContents = bytes.bytes(length);
	  }

	  // determine if a non-constructed value should be decoded as a composed
	  // value that contains other ASN.1 objects. BIT STRINGs (and OCTET STRINGs)
	  // can be used this way.
	  if(value === undefined && options.decodeBitStrings &&
	    tagClass === asn1.Class.UNIVERSAL &&
	    // FIXME: OCTET STRINGs not yet supported here
	    // .. other parts of forge expect to decode OCTET STRINGs manually
	    (type === asn1.Type.BITSTRING /*|| type === asn1.Type.OCTETSTRING*/) &&
	    length > 1) {
	    // save read position
	    var savedRead = bytes.read;
	    var savedRemaining = remaining;
	    var unused = 0;
	    if(type === asn1.Type.BITSTRING) {
	      /* The first octet gives the number of bits by which the length of the
	        bit string is less than the next multiple of eight (this is called
	        the "number of unused bits").

	        The second and following octets give the value of the bit string
	        converted to an octet string. */
	      _checkBufferLength(bytes, remaining, 1);
	      unused = bytes.getByte();
	      remaining--;
	    }
	    // if all bits are used, maybe the BIT/OCTET STRING holds ASN.1 objs
	    if(unused === 0) {
	      try {
	        // attempt to parse child asn1 object from the value
	        // (stored in array to signal composed value)
	        start = bytes.length();
	        var subOptions = {
	          // enforce strict mode to avoid parsing ASN.1 from plain data
	          verbose: options.verbose,
	          strict: true,
	          decodeBitStrings: true
	        };
	        var composed = _fromDer(bytes, remaining, depth + 1, subOptions);
	        var used = start - bytes.length();
	        remaining -= used;
	        if(type == asn1.Type.BITSTRING) {
	          used++;
	        }

	        // if the data all decoded and the class indicates UNIVERSAL or
	        // CONTEXT_SPECIFIC then assume we've got an encapsulated ASN.1 object
	        var tc = composed.tagClass;
	        if(used === length &&
	          (tc === asn1.Class.UNIVERSAL || tc === asn1.Class.CONTEXT_SPECIFIC)) {
	          value = [composed];
	        }
	      } catch(ex) {
	      }
	    }
	    if(value === undefined) {
	      // restore read position
	      bytes.read = savedRead;
	      remaining = savedRemaining;
	    }
	  }

	  if(value === undefined) {
	    // asn1 not constructed or composed, get raw value
	    // TODO: do DER to OID conversion and vice-versa in .toDer?

	    if(length === undefined) {
	      if(options.strict) {
	        throw new Error('Non-constructed ASN.1 object of indefinite length.');
	      }
	      // be lenient and use remaining state bytes
	      length = remaining;
	    }

	    if(type === asn1.Type.BMPSTRING) {
	      value = '';
	      for(; length > 0; length -= 2) {
	        _checkBufferLength(bytes, remaining, 2);
	        value += String.fromCharCode(bytes.getInt16());
	        remaining -= 2;
	      }
	    } else {
	      value = bytes.getBytes(length);
	    }
	  }

	  // add BIT STRING contents if available
	  var asn1Options = bitStringContents === undefined ? null : {
	    bitStringContents: bitStringContents
	  };

	  // create and return asn1 object
	  return asn1.create(tagClass, type, constructed, value, asn1Options);
	}

	/**
	 * Converts the given asn1 object to a buffer of bytes in DER format.
	 *
	 * @param asn1 the asn1 object to convert to bytes.
	 *
	 * @return the buffer of bytes.
	 */
	asn1.toDer = function(obj) {
	  var bytes = forge.util.createBuffer();

	  // build the first byte
	  var b1 = obj.tagClass | obj.type;

	  // for storing the ASN.1 value
	  var value = forge.util.createBuffer();

	  // use BIT STRING contents if available and data not changed
	  var useBitStringContents = false;
	  if('bitStringContents' in obj) {
	    useBitStringContents = true;
	    if(obj.original) {
	      useBitStringContents = asn1.equals(obj, obj.original);
	    }
	  }

	  if(useBitStringContents) {
	    value.putBytes(obj.bitStringContents);
	  } else if(obj.composed) {
	    // if composed, use each child asn1 object's DER bytes as value
	    // turn on 6th bit (0x20 = 32) to indicate asn1 is constructed
	    // from other asn1 objects
	    if(obj.constructed) {
	      b1 |= 0x20;
	    } else {
	      // type is a bit string, add unused bits of 0x00
	      value.putByte(0x00);
	    }

	    // add all of the child DER bytes together
	    for(var i = 0; i < obj.value.length; ++i) {
	      if(obj.value[i] !== undefined) {
	        value.putBuffer(asn1.toDer(obj.value[i]));
	      }
	    }
	  } else {
	    // use asn1.value directly
	    if(obj.type === asn1.Type.BMPSTRING) {
	      for(var i = 0; i < obj.value.length; ++i) {
	        value.putInt16(obj.value.charCodeAt(i));
	      }
	    } else {
	      // ensure integer is minimally-encoded
	      // TODO: should all leading bytes be stripped vs just one?
	      // .. ex '00 00 01' => '01'?
	      if(obj.type === asn1.Type.INTEGER &&
	        obj.value.length > 1 &&
	        // leading 0x00 for positive integer
	        ((obj.value.charCodeAt(0) === 0 &&
	        (obj.value.charCodeAt(1) & 0x80) === 0) ||
	        // leading 0xFF for negative integer
	        (obj.value.charCodeAt(0) === 0xFF &&
	        (obj.value.charCodeAt(1) & 0x80) === 0x80))) {
	        value.putBytes(obj.value.substr(1));
	      } else {
	        value.putBytes(obj.value);
	      }
	    }
	  }

	  // add tag byte
	  bytes.putByte(b1);

	  // use "short form" encoding
	  if(value.length() <= 127) {
	    // one byte describes the length
	    // bit 8 = 0 and bits 7-1 = length
	    bytes.putByte(value.length() & 0x7F);
	  } else {
	    // use "long form" encoding
	    // 2 to 127 bytes describe the length
	    // first byte: bit 8 = 1 and bits 7-1 = # of additional bytes
	    // other bytes: length in base 256, big-endian
	    var len = value.length();
	    var lenBytes = '';
	    do {
	      lenBytes += String.fromCharCode(len & 0xFF);
	      len = len >>> 8;
	    } while(len > 0);

	    // set first byte to # bytes used to store the length and turn on
	    // bit 8 to indicate long-form length is used
	    bytes.putByte(lenBytes.length | 0x80);

	    // concatenate length bytes in reverse since they were generated
	    // little endian and we need big endian
	    for(var i = lenBytes.length - 1; i >= 0; --i) {
	      bytes.putByte(lenBytes.charCodeAt(i));
	    }
	  }

	  // concatenate value bytes
	  bytes.putBuffer(value);
	  return bytes;
	};

	/**
	 * Converts an OID dot-separated string to a byte buffer. The byte buffer
	 * contains only the DER-encoded value, not any tag or length bytes.
	 *
	 * @param oid the OID dot-separated string.
	 *
	 * @return the byte buffer.
	 */
	asn1.oidToDer = function(oid) {
	  // split OID into individual values
	  var values = oid.split('.');
	  var bytes = forge.util.createBuffer();

	  // first byte is 40 * value1 + value2
	  bytes.putByte(40 * parseInt(values[0], 10) + parseInt(values[1], 10));
	  // other bytes are each value in base 128 with 8th bit set except for
	  // the last byte for each value
	  var last, valueBytes, value, b;
	  for(var i = 2; i < values.length; ++i) {
	    // produce value bytes in reverse because we don't know how many
	    // bytes it will take to store the value
	    last = true;
	    valueBytes = [];
	    value = parseInt(values[i], 10);
	    do {
	      b = value & 0x7F;
	      value = value >>> 7;
	      // if value is not last, then turn on 8th bit
	      if(!last) {
	        b |= 0x80;
	      }
	      valueBytes.push(b);
	      last = false;
	    } while(value > 0);

	    // add value bytes in reverse (needs to be in big endian)
	    for(var n = valueBytes.length - 1; n >= 0; --n) {
	      bytes.putByte(valueBytes[n]);
	    }
	  }

	  return bytes;
	};

	/**
	 * Converts a DER-encoded byte buffer to an OID dot-separated string. The
	 * byte buffer should contain only the DER-encoded value, not any tag or
	 * length bytes.
	 *
	 * @param bytes the byte buffer.
	 *
	 * @return the OID dot-separated string.
	 */
	asn1.derToOid = function(bytes) {
	  var oid;

	  // wrap in buffer if needed
	  if(typeof bytes === 'string') {
	    bytes = forge.util.createBuffer(bytes);
	  }

	  // first byte is 40 * value1 + value2
	  var b = bytes.getByte();
	  oid = Math.floor(b / 40) + '.' + (b % 40);

	  // other bytes are each value in base 128 with 8th bit set except for
	  // the last byte for each value
	  var value = 0;
	  while(bytes.length() > 0) {
	    b = bytes.getByte();
	    value = value << 7;
	    // not the last byte for the value
	    if(b & 0x80) {
	      value += b & 0x7F;
	    } else {
	      // last byte
	      oid += '.' + (value + b);
	      value = 0;
	    }
	  }

	  return oid;
	};

	/**
	 * Converts a UTCTime value to a date.
	 *
	 * Note: GeneralizedTime has 4 digits for the year and is used for X.509
	 * dates past 2049. Parsing that structure hasn't been implemented yet.
	 *
	 * @param utc the UTCTime value to convert.
	 *
	 * @return the date.
	 */
	asn1.utcTimeToDate = function(utc) {
	  /* The following formats can be used:

	    YYMMDDhhmmZ
	    YYMMDDhhmm+hh'mm'
	    YYMMDDhhmm-hh'mm'
	    YYMMDDhhmmssZ
	    YYMMDDhhmmss+hh'mm'
	    YYMMDDhhmmss-hh'mm'

	    Where:

	    YY is the least significant two digits of the year
	    MM is the month (01 to 12)
	    DD is the day (01 to 31)
	    hh is the hour (00 to 23)
	    mm are the minutes (00 to 59)
	    ss are the seconds (00 to 59)
	    Z indicates that local time is GMT, + indicates that local time is
	    later than GMT, and - indicates that local time is earlier than GMT
	    hh' is the absolute value of the offset from GMT in hours
	    mm' is the absolute value of the offset from GMT in minutes */
	  var date = new Date();

	  // if YY >= 50 use 19xx, if YY < 50 use 20xx
	  var year = parseInt(utc.substr(0, 2), 10);
	  year = (year >= 50) ? 1900 + year : 2000 + year;
	  var MM = parseInt(utc.substr(2, 2), 10) - 1; // use 0-11 for month
	  var DD = parseInt(utc.substr(4, 2), 10);
	  var hh = parseInt(utc.substr(6, 2), 10);
	  var mm = parseInt(utc.substr(8, 2), 10);
	  var ss = 0;

	  // not just YYMMDDhhmmZ
	  if(utc.length > 11) {
	    // get character after minutes
	    var c = utc.charAt(10);
	    var end = 10;

	    // see if seconds are present
	    if(c !== '+' && c !== '-') {
	      // get seconds
	      ss = parseInt(utc.substr(10, 2), 10);
	      end += 2;
	    }
	  }

	  // update date
	  date.setUTCFullYear(year, MM, DD);
	  date.setUTCHours(hh, mm, ss, 0);

	  if(end) {
	    // get +/- after end of time
	    c = utc.charAt(end);
	    if(c === '+' || c === '-') {
	      // get hours+minutes offset
	      var hhoffset = parseInt(utc.substr(end + 1, 2), 10);
	      var mmoffset = parseInt(utc.substr(end + 4, 2), 10);

	      // calculate offset in milliseconds
	      var offset = hhoffset * 60 + mmoffset;
	      offset *= 60000;

	      // apply offset
	      if(c === '+') {
	        date.setTime(+date - offset);
	      } else {
	        date.setTime(+date + offset);
	      }
	    }
	  }

	  return date;
	};

	/**
	 * Converts a GeneralizedTime value to a date.
	 *
	 * @param gentime the GeneralizedTime value to convert.
	 *
	 * @return the date.
	 */
	asn1.generalizedTimeToDate = function(gentime) {
	  /* The following formats can be used:

	    YYYYMMDDHHMMSS
	    YYYYMMDDHHMMSS.fff
	    YYYYMMDDHHMMSSZ
	    YYYYMMDDHHMMSS.fffZ
	    YYYYMMDDHHMMSS+hh'mm'
	    YYYYMMDDHHMMSS.fff+hh'mm'
	    YYYYMMDDHHMMSS-hh'mm'
	    YYYYMMDDHHMMSS.fff-hh'mm'

	    Where:

	    YYYY is the year
	    MM is the month (01 to 12)
	    DD is the day (01 to 31)
	    hh is the hour (00 to 23)
	    mm are the minutes (00 to 59)
	    ss are the seconds (00 to 59)
	    .fff is the second fraction, accurate to three decimal places
	    Z indicates that local time is GMT, + indicates that local time is
	    later than GMT, and - indicates that local time is earlier than GMT
	    hh' is the absolute value of the offset from GMT in hours
	    mm' is the absolute value of the offset from GMT in minutes */
	  var date = new Date();

	  var YYYY = parseInt(gentime.substr(0, 4), 10);
	  var MM = parseInt(gentime.substr(4, 2), 10) - 1; // use 0-11 for month
	  var DD = parseInt(gentime.substr(6, 2), 10);
	  var hh = parseInt(gentime.substr(8, 2), 10);
	  var mm = parseInt(gentime.substr(10, 2), 10);
	  var ss = parseInt(gentime.substr(12, 2), 10);
	  var fff = 0;
	  var offset = 0;
	  var isUTC = false;

	  if(gentime.charAt(gentime.length - 1) === 'Z') {
	    isUTC = true;
	  }

	  var end = gentime.length - 5, c = gentime.charAt(end);
	  if(c === '+' || c === '-') {
	    // get hours+minutes offset
	    var hhoffset = parseInt(gentime.substr(end + 1, 2), 10);
	    var mmoffset = parseInt(gentime.substr(end + 4, 2), 10);

	    // calculate offset in milliseconds
	    offset = hhoffset * 60 + mmoffset;
	    offset *= 60000;

	    // apply offset
	    if(c === '+') {
	      offset *= -1;
	    }

	    isUTC = true;
	  }

	  // check for second fraction
	  if(gentime.charAt(14) === '.') {
	    fff = parseFloat(gentime.substr(14), 10) * 1000;
	  }

	  if(isUTC) {
	    date.setUTCFullYear(YYYY, MM, DD);
	    date.setUTCHours(hh, mm, ss, fff);

	    // apply offset
	    date.setTime(+date + offset);
	  } else {
	    date.setFullYear(YYYY, MM, DD);
	    date.setHours(hh, mm, ss, fff);
	  }

	  return date;
	};

	/**
	 * Converts a date to a UTCTime value.
	 *
	 * Note: GeneralizedTime has 4 digits for the year and is used for X.509
	 * dates past 2049. Converting to a GeneralizedTime hasn't been
	 * implemented yet.
	 *
	 * @param date the date to convert.
	 *
	 * @return the UTCTime value.
	 */
	asn1.dateToUtcTime = function(date) {
	  // TODO: validate; currently assumes proper format
	  if(typeof date === 'string') {
	    return date;
	  }

	  var rval = '';

	  // create format YYMMDDhhmmssZ
	  var format = [];
	  format.push(('' + date.getUTCFullYear()).substr(2));
	  format.push('' + (date.getUTCMonth() + 1));
	  format.push('' + date.getUTCDate());
	  format.push('' + date.getUTCHours());
	  format.push('' + date.getUTCMinutes());
	  format.push('' + date.getUTCSeconds());

	  // ensure 2 digits are used for each format entry
	  for(var i = 0; i < format.length; ++i) {
	    if(format[i].length < 2) {
	      rval += '0';
	    }
	    rval += format[i];
	  }
	  rval += 'Z';

	  return rval;
	};

	/**
	 * Converts a date to a GeneralizedTime value.
	 *
	 * @param date the date to convert.
	 *
	 * @return the GeneralizedTime value as a string.
	 */
	asn1.dateToGeneralizedTime = function(date) {
	  // TODO: validate; currently assumes proper format
	  if(typeof date === 'string') {
	    return date;
	  }

	  var rval = '';

	  // create format YYYYMMDDHHMMSSZ
	  var format = [];
	  format.push('' + date.getUTCFullYear());
	  format.push('' + (date.getUTCMonth() + 1));
	  format.push('' + date.getUTCDate());
	  format.push('' + date.getUTCHours());
	  format.push('' + date.getUTCMinutes());
	  format.push('' + date.getUTCSeconds());

	  // ensure 2 digits are used for each format entry
	  for(var i = 0; i < format.length; ++i) {
	    if(format[i].length < 2) {
	      rval += '0';
	    }
	    rval += format[i];
	  }
	  rval += 'Z';

	  return rval;
	};

	/**
	 * Converts a javascript integer to a DER-encoded byte buffer to be used
	 * as the value for an INTEGER type.
	 *
	 * @param x the integer.
	 *
	 * @return the byte buffer.
	 */
	asn1.integerToDer = function(x) {
	  var rval = forge.util.createBuffer();
	  if(x >= -0x80 && x < 0x80) {
	    return rval.putSignedInt(x, 8);
	  }
	  if(x >= -0x8000 && x < 0x8000) {
	    return rval.putSignedInt(x, 16);
	  }
	  if(x >= -0x800000 && x < 0x800000) {
	    return rval.putSignedInt(x, 24);
	  }
	  if(x >= -0x80000000 && x < 0x80000000) {
	    return rval.putSignedInt(x, 32);
	  }
	  var error = new Error('Integer too large; max is 32-bits.');
	  error.integer = x;
	  throw error;
	};

	/**
	 * Converts a DER-encoded byte buffer to a javascript integer. This is
	 * typically used to decode the value of an INTEGER type.
	 *
	 * @param bytes the byte buffer.
	 *
	 * @return the integer.
	 */
	asn1.derToInteger = function(bytes) {
	  // wrap in buffer if needed
	  if(typeof bytes === 'string') {
	    bytes = forge.util.createBuffer(bytes);
	  }

	  var n = bytes.length() * 8;
	  if(n > 32) {
	    throw new Error('Integer too large; max is 32-bits.');
	  }
	  return bytes.getSignedInt(n);
	};

	/**
	 * Validates that the given ASN.1 object is at least a super set of the
	 * given ASN.1 structure. Only tag classes and types are checked. An
	 * optional map may also be provided to capture ASN.1 values while the
	 * structure is checked.
	 *
	 * To capture an ASN.1 value, set an object in the validator's 'capture'
	 * parameter to the key to use in the capture map. To capture the full
	 * ASN.1 object, specify 'captureAsn1'. To capture BIT STRING bytes, including
	 * the leading unused bits counter byte, specify 'captureBitStringContents'.
	 * To capture BIT STRING bytes, without the leading unused bits counter byte,
	 * specify 'captureBitStringValue'.
	 *
	 * Objects in the validator may set a field 'optional' to true to indicate
	 * that it isn't necessary to pass validation.
	 *
	 * @param obj the ASN.1 object to validate.
	 * @param v the ASN.1 structure validator.
	 * @param capture an optional map to capture values in.
	 * @param errors an optional array for storing validation errors.
	 *
	 * @return true on success, false on failure.
	 */
	asn1.validate = function(obj, v, capture, errors) {
	  var rval = false;

	  // ensure tag class and type are the same if specified
	  if((obj.tagClass === v.tagClass || typeof(v.tagClass) === 'undefined') &&
	    (obj.type === v.type || typeof(v.type) === 'undefined')) {
	    // ensure constructed flag is the same if specified
	    if(obj.constructed === v.constructed ||
	      typeof(v.constructed) === 'undefined') {
	      rval = true;

	      // handle sub values
	      if(v.value && forge.util.isArray(v.value)) {
	        var j = 0;
	        for(var i = 0; rval && i < v.value.length; ++i) {
	          rval = v.value[i].optional || false;
	          if(obj.value[j]) {
	            rval = asn1.validate(obj.value[j], v.value[i], capture, errors);
	            if(rval) {
	              ++j;
	            } else if(v.value[i].optional) {
	              rval = true;
	            }
	          }
	          if(!rval && errors) {
	            errors.push(
	              '[' + v.name + '] ' +
	              'Tag class "' + v.tagClass + '", type "' +
	              v.type + '" expected value length "' +
	              v.value.length + '", got "' +
	              obj.value.length + '"');
	          }
	        }
	      }

	      if(rval && capture) {
	        if(v.capture) {
	          capture[v.capture] = obj.value;
	        }
	        if(v.captureAsn1) {
	          capture[v.captureAsn1] = obj;
	        }
	        if(v.captureBitStringContents && 'bitStringContents' in obj) {
	          capture[v.captureBitStringContents] = obj.bitStringContents;
	        }
	        if(v.captureBitStringValue && 'bitStringContents' in obj) {
	          if(obj.bitStringContents.length < 2) {
	            capture[v.captureBitStringValue] = '';
	          } else {
	            // FIXME: support unused bits with data shifting
	            var unused = obj.bitStringContents.charCodeAt(0);
	            if(unused !== 0) {
	              throw new Error(
	                'captureBitStringValue only supported for zero unused bits');
	            }
	            capture[v.captureBitStringValue] = obj.bitStringContents.slice(1);
	          }
	        }
	      }
	    } else if(errors) {
	      errors.push(
	        '[' + v.name + '] ' +
	        'Expected constructed "' + v.constructed + '", got "' +
	        obj.constructed + '"');
	    }
	  } else if(errors) {
	    if(obj.tagClass !== v.tagClass) {
	      errors.push(
	        '[' + v.name + '] ' +
	        'Expected tag class "' + v.tagClass + '", got "' +
	        obj.tagClass + '"');
	    }
	    if(obj.type !== v.type) {
	      errors.push(
	        '[' + v.name + '] ' +
	        'Expected type "' + v.type + '", got "' + obj.type + '"');
	    }
	  }
	  return rval;
	};

	// regex for testing for non-latin characters
	var _nonLatinRegex = /[^\\u0000-\\u00ff]/;

	/**
	 * Pretty prints an ASN.1 object to a string.
	 *
	 * @param obj the object to write out.
	 * @param level the level in the tree.
	 * @param indentation the indentation to use.
	 *
	 * @return the string.
	 */
	asn1.prettyPrint = function(obj, level, indentation) {
	  var rval = '';

	  // set default level and indentation
	  level = level || 0;
	  indentation = indentation || 2;

	  // start new line for deep levels
	  if(level > 0) {
	    rval += '\n';
	  }

	  // create indent
	  var indent = '';
	  for(var i = 0; i < level * indentation; ++i) {
	    indent += ' ';
	  }

	  // print class:type
	  rval += indent + 'Tag: ';
	  switch(obj.tagClass) {
	  case asn1.Class.UNIVERSAL:
	    rval += 'Universal:';
	    break;
	  case asn1.Class.APPLICATION:
	    rval += 'Application:';
	    break;
	  case asn1.Class.CONTEXT_SPECIFIC:
	    rval += 'Context-Specific:';
	    break;
	  case asn1.Class.PRIVATE:
	    rval += 'Private:';
	    break;
	  }

	  if(obj.tagClass === asn1.Class.UNIVERSAL) {
	    rval += obj.type;

	    // known types
	    switch(obj.type) {
	    case asn1.Type.NONE:
	      rval += ' (None)';
	      break;
	    case asn1.Type.BOOLEAN:
	      rval += ' (Boolean)';
	      break;
	    case asn1.Type.INTEGER:
	      rval += ' (Integer)';
	      break;
	    case asn1.Type.BITSTRING:
	      rval += ' (Bit string)';
	      break;
	    case asn1.Type.OCTETSTRING:
	      rval += ' (Octet string)';
	      break;
	    case asn1.Type.NULL:
	      rval += ' (Null)';
	      break;
	    case asn1.Type.OID:
	      rval += ' (Object Identifier)';
	      break;
	    case asn1.Type.ODESC:
	      rval += ' (Object Descriptor)';
	      break;
	    case asn1.Type.EXTERNAL:
	      rval += ' (External or Instance of)';
	      break;
	    case asn1.Type.REAL:
	      rval += ' (Real)';
	      break;
	    case asn1.Type.ENUMERATED:
	      rval += ' (Enumerated)';
	      break;
	    case asn1.Type.EMBEDDED:
	      rval += ' (Embedded PDV)';
	      break;
	    case asn1.Type.UTF8:
	      rval += ' (UTF8)';
	      break;
	    case asn1.Type.ROID:
	      rval += ' (Relative Object Identifier)';
	      break;
	    case asn1.Type.SEQUENCE:
	      rval += ' (Sequence)';
	      break;
	    case asn1.Type.SET:
	      rval += ' (Set)';
	      break;
	    case asn1.Type.PRINTABLESTRING:
	      rval += ' (Printable String)';
	      break;
	    case asn1.Type.IA5String:
	      rval += ' (IA5String (ASCII))';
	      break;
	    case asn1.Type.UTCTIME:
	      rval += ' (UTC time)';
	      break;
	    case asn1.Type.GENERALIZEDTIME:
	      rval += ' (Generalized time)';
	      break;
	    case asn1.Type.BMPSTRING:
	      rval += ' (BMP String)';
	      break;
	    }
	  } else {
	    rval += obj.type;
	  }

	  rval += '\n';
	  rval += indent + 'Constructed: ' + obj.constructed + '\n';

	  if(obj.composed) {
	    var subvalues = 0;
	    var sub = '';
	    for(var i = 0; i < obj.value.length; ++i) {
	      if(obj.value[i] !== undefined) {
	        subvalues += 1;
	        sub += asn1.prettyPrint(obj.value[i], level + 1, indentation);
	        if((i + 1) < obj.value.length) {
	          sub += ',';
	        }
	      }
	    }
	    rval += indent + 'Sub values: ' + subvalues + sub;
	  } else {
	    rval += indent + 'Value: ';
	    if(obj.type === asn1.Type.OID) {
	      var oid = asn1.derToOid(obj.value);
	      rval += oid;
	      if(forge.pki && forge.pki.oids) {
	        if(oid in forge.pki.oids) {
	          rval += ' (' + forge.pki.oids[oid] + ') ';
	        }
	      }
	    }
	    if(obj.type === asn1.Type.INTEGER) {
	      try {
	        rval += asn1.derToInteger(obj.value);
	      } catch(ex) {
	        rval += '0x' + forge.util.bytesToHex(obj.value);
	      }
	    } else if(obj.type === asn1.Type.BITSTRING) {
	      // TODO: shift bits as needed to display without padding
	      if(obj.value.length > 1) {
	        // remove unused bits field
	        rval += '0x' + forge.util.bytesToHex(obj.value.slice(1));
	      } else {
	        rval += '(none)';
	      }
	      // show unused bit count
	      if(obj.value.length > 0) {
	        var unused = obj.value.charCodeAt(0);
	        if(unused == 1) {
	          rval += ' (1 unused bit shown)';
	        } else if(unused > 1) {
	          rval += ' (' + unused + ' unused bits shown)';
	        }
	      }
	    } else if(obj.type === asn1.Type.OCTETSTRING) {
	      if(!_nonLatinRegex.test(obj.value)) {
	        rval += '(' + obj.value + ') ';
	      }
	      rval += '0x' + forge.util.bytesToHex(obj.value);
	    } else if(obj.type === asn1.Type.UTF8) {
	      rval += forge.util.decodeUtf8(obj.value);
	    } else if(obj.type === asn1.Type.PRINTABLESTRING ||
	      obj.type === asn1.Type.IA5String) {
	      rval += obj.value;
	    } else if(_nonLatinRegex.test(obj.value)) {
	      rval += '0x' + forge.util.bytesToHex(obj.value);
	    } else if(obj.value.length === 0) {
	      rval += '[null]';
	    } else {
	      rval += obj.value;
	    }
	  }

	  return rval;
	};
	});

	/**
	 * Node.js module for Forge message digests.
	 *
	 * @author Dave Longley
	 *
	 * Copyright 2011-2017 Digital Bazaar, Inc.
	 */


	forge.md = forge.md || {};
	forge.md.algorithms = forge.md.algorithms || {};

	createCommonjsModule(function (module) {
	/**
	 * Hash-based Message Authentication Code implementation. Requires a message
	 * digest object that can be obtained, for example, from forge.md.sha1 or
	 * forge.md.md5.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2012 Digital Bazaar, Inc. All rights reserved.
	 */




	/* HMAC API */
	var hmac = module.exports = forge.hmac = forge.hmac || {};

	/**
	 * Creates an HMAC object that uses the given message digest object.
	 *
	 * @return an HMAC object.
	 */
	hmac.create = function() {
	  // the hmac key to use
	  var _key = null;

	  // the message digest to use
	  var _md = null;

	  // the inner padding
	  var _ipadding = null;

	  // the outer padding
	  var _opadding = null;

	  // hmac context
	  var ctx = {};

	  /**
	   * Starts or restarts the HMAC with the given key and message digest.
	   *
	   * @param md the message digest to use, null to reuse the previous one,
	   *           a string to use builtin 'sha1', 'md5', 'sha256'.
	   * @param key the key to use as a string, array of bytes, byte buffer,
	   *           or null to reuse the previous key.
	   */
	  ctx.start = function(md, key) {
	    if(md !== null) {
	      if(typeof md === 'string') {
	        // create builtin message digest
	        md = md.toLowerCase();
	        if(md in forge.md.algorithms) {
	          _md = forge.md.algorithms[md].create();
	        } else {
	          throw new Error('Unknown hash algorithm "' + md + '"');
	        }
	      } else {
	        // store message digest
	        _md = md;
	      }
	    }

	    if(key === null) {
	      // reuse previous key
	      key = _key;
	    } else {
	      if(typeof key === 'string') {
	        // convert string into byte buffer
	        key = forge.util.createBuffer(key);
	      } else if(forge.util.isArray(key)) {
	        // convert byte array into byte buffer
	        var tmp = key;
	        key = forge.util.createBuffer();
	        for(var i = 0; i < tmp.length; ++i) {
	          key.putByte(tmp[i]);
	        }
	      }

	      // if key is longer than blocksize, hash it
	      var keylen = key.length();
	      if(keylen > _md.blockLength) {
	        _md.start();
	        _md.update(key.bytes());
	        key = _md.digest();
	      }

	      // mix key into inner and outer padding
	      // ipadding = [0x36 * blocksize] ^ key
	      // opadding = [0x5C * blocksize] ^ key
	      _ipadding = forge.util.createBuffer();
	      _opadding = forge.util.createBuffer();
	      keylen = key.length();
	      for(var i = 0; i < keylen; ++i) {
	        var tmp = key.at(i);
	        _ipadding.putByte(0x36 ^ tmp);
	        _opadding.putByte(0x5C ^ tmp);
	      }

	      // if key is shorter than blocksize, add additional padding
	      if(keylen < _md.blockLength) {
	        var tmp = _md.blockLength - keylen;
	        for(var i = 0; i < tmp; ++i) {
	          _ipadding.putByte(0x36);
	          _opadding.putByte(0x5C);
	        }
	      }
	      _key = key;
	      _ipadding = _ipadding.bytes();
	      _opadding = _opadding.bytes();
	    }

	    // digest is done like so: hash(opadding | hash(ipadding | message))

	    // prepare to do inner hash
	    // hash(ipadding | message)
	    _md.start();
	    _md.update(_ipadding);
	  };

	  /**
	   * Updates the HMAC with the given message bytes.
	   *
	   * @param bytes the bytes to update with.
	   */
	  ctx.update = function(bytes) {
	    _md.update(bytes);
	  };

	  /**
	   * Produces the Message Authentication Code (MAC).
	   *
	   * @return a byte buffer containing the digest value.
	   */
	  ctx.getMac = function() {
	    // digest is done like so: hash(opadding | hash(ipadding | message))
	    // here we do the outer hashing
	    var inner = _md.digest().bytes();
	    _md.start();
	    _md.update(_opadding);
	    _md.update(inner);
	    return _md.digest();
	  };
	  // alias for getMac
	  ctx.digest = ctx.getMac;

	  return ctx;
	};
	});

	createCommonjsModule(function (module) {
	/**
	 * Message Digest Algorithm 5 with 128-bit digest (MD5) implementation.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2014 Digital Bazaar, Inc.
	 */




	var md5 = module.exports = forge.md5 = forge.md5 || {};
	forge.md.md5 = forge.md.algorithms.md5 = md5;

	/**
	 * Creates an MD5 message digest object.
	 *
	 * @return a message digest object.
	 */
	md5.create = function() {
	  // do initialization as necessary
	  if(!_initialized) {
	    _init();
	  }

	  // MD5 state contains four 32-bit integers
	  var _state = null;

	  // input buffer
	  var _input = forge.util.createBuffer();

	  // used for word storage
	  var _w = new Array(16);

	  // message digest object
	  var md = {
	    algorithm: 'md5',
	    blockLength: 64,
	    digestLength: 16,
	    // 56-bit length of message so far (does not including padding)
	    messageLength: 0,
	    // true message length
	    fullMessageLength: null,
	    // size of message length in bytes
	    messageLengthSize: 8
	  };

	  /**
	   * Starts the digest.
	   *
	   * @return this digest object.
	   */
	  md.start = function() {
	    // up to 56-bit message length for convenience
	    md.messageLength = 0;

	    // full message length (set md.messageLength64 for backwards-compatibility)
	    md.fullMessageLength = md.messageLength64 = [];
	    var int32s = md.messageLengthSize / 4;
	    for(var i = 0; i < int32s; ++i) {
	      md.fullMessageLength.push(0);
	    }
	    _input = forge.util.createBuffer();
	    _state = {
	      h0: 0x67452301,
	      h1: 0xEFCDAB89,
	      h2: 0x98BADCFE,
	      h3: 0x10325476
	    };
	    return md;
	  };
	  // start digest automatically for first time
	  md.start();

	  /**
	   * Updates the digest with the given message input. The given input can
	   * treated as raw input (no encoding will be applied) or an encoding of
	   * 'utf8' maybe given to encode the input using UTF-8.
	   *
	   * @param msg the message input to update with.
	   * @param encoding the encoding to use (default: 'raw', other: 'utf8').
	   *
	   * @return this digest object.
	   */
	  md.update = function(msg, encoding) {
	    if(encoding === 'utf8') {
	      msg = forge.util.encodeUtf8(msg);
	    }

	    // update message length
	    var len = msg.length;
	    md.messageLength += len;
	    len = [(len / 0x100000000) >>> 0, len >>> 0];
	    for(var i = md.fullMessageLength.length - 1; i >= 0; --i) {
	      md.fullMessageLength[i] += len[1];
	      len[1] = len[0] + ((md.fullMessageLength[i] / 0x100000000) >>> 0);
	      md.fullMessageLength[i] = md.fullMessageLength[i] >>> 0;
	      len[0] = (len[1] / 0x100000000) >>> 0;
	    }

	    // add bytes to input buffer
	    _input.putBytes(msg);

	    // process bytes
	    _update(_state, _w, _input);

	    // compact input buffer every 2K or if empty
	    if(_input.read > 2048 || _input.length() === 0) {
	      _input.compact();
	    }

	    return md;
	  };

	  /**
	   * Produces the digest.
	   *
	   * @return a byte buffer containing the digest value.
	   */
	  md.digest = function() {
	    /* Note: Here we copy the remaining bytes in the input buffer and
	    add the appropriate MD5 padding. Then we do the final update
	    on a copy of the state so that if the user wants to get
	    intermediate digests they can do so. */

	    /* Determine the number of bytes that must be added to the message
	    to ensure its length is congruent to 448 mod 512. In other words,
	    the data to be digested must be a multiple of 512 bits (or 128 bytes).
	    This data includes the message, some padding, and the length of the
	    message. Since the length of the message will be encoded as 8 bytes (64
	    bits), that means that the last segment of the data must have 56 bytes
	    (448 bits) of message and padding. Therefore, the length of the message
	    plus the padding must be congruent to 448 mod 512 because
	    512 - 128 = 448.

	    In order to fill up the message length it must be filled with
	    padding that begins with 1 bit followed by all 0 bits. Padding
	    must *always* be present, so if the message length is already
	    congruent to 448 mod 512, then 512 padding bits must be added. */

	    var finalBlock = forge.util.createBuffer();
	    finalBlock.putBytes(_input.bytes());

	    // compute remaining size to be digested (include message length size)
	    var remaining = (
	      md.fullMessageLength[md.fullMessageLength.length - 1] +
	      md.messageLengthSize);

	    // add padding for overflow blockSize - overflow
	    // _padding starts with 1 byte with first bit is set (byte value 128), then
	    // there may be up to (blockSize - 1) other pad bytes
	    var overflow = remaining & (md.blockLength - 1);
	    finalBlock.putBytes(_padding.substr(0, md.blockLength - overflow));

	    // serialize message length in bits in little-endian order; since length
	    // is stored in bytes we multiply by 8 and add carry
	    var bits, carry = 0;
	    for(var i = md.fullMessageLength.length - 1; i >= 0; --i) {
	      bits = md.fullMessageLength[i] * 8 + carry;
	      carry = (bits / 0x100000000) >>> 0;
	      finalBlock.putInt32Le(bits >>> 0);
	    }

	    var s2 = {
	      h0: _state.h0,
	      h1: _state.h1,
	      h2: _state.h2,
	      h3: _state.h3
	    };
	    _update(s2, _w, finalBlock);
	    var rval = forge.util.createBuffer();
	    rval.putInt32Le(s2.h0);
	    rval.putInt32Le(s2.h1);
	    rval.putInt32Le(s2.h2);
	    rval.putInt32Le(s2.h3);
	    return rval;
	  };

	  return md;
	};

	// padding, constant tables for calculating md5
	var _padding = null;
	var _g = null;
	var _r = null;
	var _k = null;
	var _initialized = false;

	/**
	 * Initializes the constant tables.
	 */
	function _init() {
	  // create padding
	  _padding = String.fromCharCode(128);
	  _padding += forge.util.fillString(String.fromCharCode(0x00), 64);

	  // g values
	  _g = [
	    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	    1, 6, 11, 0, 5, 10, 15, 4, 9, 14, 3, 8, 13, 2, 7, 12,
	    5, 8, 11, 14, 1, 4, 7, 10, 13, 0, 3, 6, 9, 12, 15, 2,
	    0, 7, 14, 5, 12, 3, 10, 1, 8, 15, 6, 13, 4, 11, 2, 9];

	  // rounds table
	  _r = [
	    7, 12, 17, 22,  7, 12, 17, 22,  7, 12, 17, 22,  7, 12, 17, 22,
	    5,  9, 14, 20,  5,  9, 14, 20,  5,  9, 14, 20,  5,  9, 14, 20,
	    4, 11, 16, 23,  4, 11, 16, 23,  4, 11, 16, 23,  4, 11, 16, 23,
	    6, 10, 15, 21,  6, 10, 15, 21,  6, 10, 15, 21,  6, 10, 15, 21];

	  // get the result of abs(sin(i + 1)) as a 32-bit integer
	  _k = new Array(64);
	  for(var i = 0; i < 64; ++i) {
	    _k[i] = Math.floor(Math.abs(Math.sin(i + 1)) * 0x100000000);
	  }

	  // now initialized
	  _initialized = true;
	}

	/**
	 * Updates an MD5 state with the given byte buffer.
	 *
	 * @param s the MD5 state to update.
	 * @param w the array to use to store words.
	 * @param bytes the byte buffer to update with.
	 */
	function _update(s, w, bytes) {
	  // consume 512 bit (64 byte) chunks
	  var t, a, b, c, d, f, r, i;
	  var len = bytes.length();
	  while(len >= 64) {
	    // initialize hash value for this chunk
	    a = s.h0;
	    b = s.h1;
	    c = s.h2;
	    d = s.h3;

	    // round 1
	    for(i = 0; i < 16; ++i) {
	      w[i] = bytes.getInt32Le();
	      f = d ^ (b & (c ^ d));
	      t = (a + f + _k[i] + w[i]);
	      r = _r[i];
	      a = d;
	      d = c;
	      c = b;
	      b += (t << r) | (t >>> (32 - r));
	    }
	    // round 2
	    for(; i < 32; ++i) {
	      f = c ^ (d & (b ^ c));
	      t = (a + f + _k[i] + w[_g[i]]);
	      r = _r[i];
	      a = d;
	      d = c;
	      c = b;
	      b += (t << r) | (t >>> (32 - r));
	    }
	    // round 3
	    for(; i < 48; ++i) {
	      f = b ^ c ^ d;
	      t = (a + f + _k[i] + w[_g[i]]);
	      r = _r[i];
	      a = d;
	      d = c;
	      c = b;
	      b += (t << r) | (t >>> (32 - r));
	    }
	    // round 4
	    for(; i < 64; ++i) {
	      f = c ^ (b | ~d);
	      t = (a + f + _k[i] + w[_g[i]]);
	      r = _r[i];
	      a = d;
	      d = c;
	      c = b;
	      b += (t << r) | (t >>> (32 - r));
	    }

	    // update hash state
	    s.h0 = (s.h0 + a) | 0;
	    s.h1 = (s.h1 + b) | 0;
	    s.h2 = (s.h2 + c) | 0;
	    s.h3 = (s.h3 + d) | 0;

	    len -= 64;
	  }
	}
	});

	createCommonjsModule(function (module) {
	/**
	 * Javascript implementation of basic PEM (Privacy Enhanced Mail) algorithms.
	 *
	 * See: RFC 1421.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2013-2014 Digital Bazaar, Inc.
	 *
	 * A Forge PEM object has the following fields:
	 *
	 * type: identifies the type of message (eg: "RSA PRIVATE KEY").
	 *
	 * procType: identifies the type of processing performed on the message,
	 *   it has two subfields: version and type, eg: 4,ENCRYPTED.
	 *
	 * contentDomain: identifies the type of content in the message, typically
	 *   only uses the value: "RFC822".
	 *
	 * dekInfo: identifies the message encryption algorithm and mode and includes
	 *   any parameters for the algorithm, it has two subfields: algorithm and
	 *   parameters, eg: DES-CBC,F8143EDE5960C597.
	 *
	 * headers: contains all other PEM encapsulated headers -- where order is
	 *   significant (for pairing data like recipient ID + key info).
	 *
	 * body: the binary-encoded body.
	 */



	// shortcut for pem API
	var pem = module.exports = forge.pem = forge.pem || {};

	/**
	 * Encodes (serializes) the given PEM object.
	 *
	 * @param msg the PEM message object to encode.
	 * @param options the options to use:
	 *          maxline the maximum characters per line for the body, (default: 64).
	 *
	 * @return the PEM-formatted string.
	 */
	pem.encode = function(msg, options) {
	  options = options || {};
	  var rval = '-----BEGIN ' + msg.type + '-----\r\n';

	  // encode special headers
	  var header;
	  if(msg.procType) {
	    header = {
	      name: 'Proc-Type',
	      values: [String(msg.procType.version), msg.procType.type]
	    };
	    rval += foldHeader(header);
	  }
	  if(msg.contentDomain) {
	    header = {name: 'Content-Domain', values: [msg.contentDomain]};
	    rval += foldHeader(header);
	  }
	  if(msg.dekInfo) {
	    header = {name: 'DEK-Info', values: [msg.dekInfo.algorithm]};
	    if(msg.dekInfo.parameters) {
	      header.values.push(msg.dekInfo.parameters);
	    }
	    rval += foldHeader(header);
	  }

	  if(msg.headers) {
	    // encode all other headers
	    for(var i = 0; i < msg.headers.length; ++i) {
	      rval += foldHeader(msg.headers[i]);
	    }
	  }

	  // terminate header
	  if(msg.procType) {
	    rval += '\r\n';
	  }

	  // add body
	  rval += forge.util.encode64(msg.body, options.maxline || 64) + '\r\n';

	  rval += '-----END ' + msg.type + '-----\r\n';
	  return rval;
	};

	/**
	 * Decodes (deserializes) all PEM messages found in the given string.
	 *
	 * @param str the PEM-formatted string to decode.
	 *
	 * @return the PEM message objects in an array.
	 */
	pem.decode = function(str) {
	  var rval = [];

	  // split string into PEM messages (be lenient w/EOF on BEGIN line)
	  var rMessage = /\s*-----BEGIN ([A-Z0-9- ]+)-----\r?\n?([\x21-\x7e\s]+?(?:\r?\n\r?\n))?([:A-Za-z0-9+\/=\s]+?)-----END \1-----/g;
	  var rHeader = /([\x21-\x7e]+):\s*([\x21-\x7e\s^:]+)/;
	  var rCRLF = /\r?\n/;
	  var match;
	  while(true) {
	    match = rMessage.exec(str);
	    if(!match) {
	      break;
	    }

	    var msg = {
	      type: match[1],
	      procType: null,
	      contentDomain: null,
	      dekInfo: null,
	      headers: [],
	      body: forge.util.decode64(match[3])
	    };
	    rval.push(msg);

	    // no headers
	    if(!match[2]) {
	      continue;
	    }

	    // parse headers
	    var lines = match[2].split(rCRLF);
	    var li = 0;
	    while(match && li < lines.length) {
	      // get line, trim any rhs whitespace
	      var line = lines[li].replace(/\s+$/, '');

	      // RFC2822 unfold any following folded lines
	      for(var nl = li + 1; nl < lines.length; ++nl) {
	        var next = lines[nl];
	        if(!/\s/.test(next[0])) {
	          break;
	        }
	        line += next;
	        li = nl;
	      }

	      // parse header
	      match = line.match(rHeader);
	      if(match) {
	        var header = {name: match[1], values: []};
	        var values = match[2].split(',');
	        for(var vi = 0; vi < values.length; ++vi) {
	          header.values.push(ltrim(values[vi]));
	        }

	        // Proc-Type must be the first header
	        if(!msg.procType) {
	          if(header.name !== 'Proc-Type') {
	            throw new Error('Invalid PEM formatted message. The first ' +
	              'encapsulated header must be "Proc-Type".');
	          } else if(header.values.length !== 2) {
	            throw new Error('Invalid PEM formatted message. The "Proc-Type" ' +
	              'header must have two subfields.');
	          }
	          msg.procType = {version: values[0], type: values[1]};
	        } else if(!msg.contentDomain && header.name === 'Content-Domain') {
	          // special-case Content-Domain
	          msg.contentDomain = values[0] || '';
	        } else if(!msg.dekInfo && header.name === 'DEK-Info') {
	          // special-case DEK-Info
	          if(header.values.length === 0) {
	            throw new Error('Invalid PEM formatted message. The "DEK-Info" ' +
	              'header must have at least one subfield.');
	          }
	          msg.dekInfo = {algorithm: values[0], parameters: values[1] || null};
	        } else {
	          msg.headers.push(header);
	        }
	      }

	      ++li;
	    }

	    if(msg.procType === 'ENCRYPTED' && !msg.dekInfo) {
	      throw new Error('Invalid PEM formatted message. The "DEK-Info" ' +
	        'header must be present if "Proc-Type" is "ENCRYPTED".');
	    }
	  }

	  if(rval.length === 0) {
	    throw new Error('Invalid PEM formatted message.');
	  }

	  return rval;
	};

	function foldHeader(header) {
	  var rval = header.name + ': ';

	  // ensure values with CRLF are folded
	  var values = [];
	  var insertSpace = function(match, $1) {
	    return ' ' + $1;
	  };
	  for(var i = 0; i < header.values.length; ++i) {
	    values.push(header.values[i].replace(/^(\S+\r\n)/, insertSpace));
	  }
	  rval += values.join(',') + '\r\n';

	  // do folding
	  var length = 0;
	  var candidate = -1;
	  for(var i = 0; i < rval.length; ++i, ++length) {
	    if(length > 65 && candidate !== -1) {
	      var insert = rval[candidate];
	      if(insert === ',') {
	        ++candidate;
	        rval = rval.substr(0, candidate) + '\r\n ' + rval.substr(candidate);
	      } else {
	        rval = rval.substr(0, candidate) +
	          '\r\n' + insert + rval.substr(candidate + 1);
	      }
	      length = (i - candidate - 1);
	      candidate = -1;
	      ++i;
	    } else if(rval[i] === ' ' || rval[i] === '\t' || rval[i] === ',') {
	      candidate = i;
	    }
	  }

	  return rval;
	}

	function ltrim(str) {
	  return str.replace(/^\s+/, '');
	}
	});

	/**
	 * DES (Data Encryption Standard) implementation.
	 *
	 * This implementation supports DES as well as 3DES-EDE in ECB and CBC mode.
	 * It is based on the BSD-licensed implementation by Paul Tero:
	 *
	 * Paul Tero, July 2001
	 * http://www.tero.co.uk/des/
	 *
	 * Optimised for performance with large blocks by
	 * Michael Hayworth, November 2001
	 * http://www.netdealing.com
	 *
	 * THIS SOFTWARE IS PROVIDED "AS IS" AND
	 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
	 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
	 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
	 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
	 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
	 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
	 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
	 * SUCH DAMAGE.
	 *
	 * @author Stefan Siegl
	 * @author Dave Longley
	 *
	 * Copyright (c) 2012 Stefan Siegl <stesie@brokenpipe.de>
	 * Copyright (c) 2012-2014 Digital Bazaar, Inc.
	 */





	/* DES API */
	forge.des = forge.des || {};

	/**
	 * Deprecated. Instead, use:
	 *
	 * var cipher = forge.cipher.createCipher('DES-<mode>', key);
	 * cipher.start({iv: iv});
	 *
	 * Creates an DES cipher object to encrypt data using the given symmetric key.
	 * The output will be stored in the 'output' member of the returned cipher.
	 *
	 * The key and iv may be given as binary-encoded strings of bytes or
	 * byte buffers.
	 *
	 * @param key the symmetric key to use (64 or 192 bits).
	 * @param iv the initialization vector to use.
	 * @param output the buffer to write to, null to create one.
	 * @param mode the cipher mode to use (default: 'CBC' if IV is
	 *          given, 'ECB' if null).
	 *
	 * @return the cipher.
	 */
	forge.des.startEncrypting = function(key, iv, output, mode) {
	  var cipher = _createCipher({
	    key: key,
	    output: output,
	    decrypt: false,
	    mode: mode || (iv === null ? 'ECB' : 'CBC')
	  });
	  cipher.start(iv);
	  return cipher;
	};

	/**
	 * Deprecated. Instead, use:
	 *
	 * var cipher = forge.cipher.createCipher('DES-<mode>', key);
	 *
	 * Creates an DES cipher object to encrypt data using the given symmetric key.
	 *
	 * The key may be given as a binary-encoded string of bytes or a byte buffer.
	 *
	 * @param key the symmetric key to use (64 or 192 bits).
	 * @param mode the cipher mode to use (default: 'CBC').
	 *
	 * @return the cipher.
	 */
	forge.des.createEncryptionCipher = function(key, mode) {
	  return _createCipher({
	    key: key,
	    output: null,
	    decrypt: false,
	    mode: mode
	  });
	};

	/**
	 * Deprecated. Instead, use:
	 *
	 * var decipher = forge.cipher.createDecipher('DES-<mode>', key);
	 * decipher.start({iv: iv});
	 *
	 * Creates an DES cipher object to decrypt data using the given symmetric key.
	 * The output will be stored in the 'output' member of the returned cipher.
	 *
	 * The key and iv may be given as binary-encoded strings of bytes or
	 * byte buffers.
	 *
	 * @param key the symmetric key to use (64 or 192 bits).
	 * @param iv the initialization vector to use.
	 * @param output the buffer to write to, null to create one.
	 * @param mode the cipher mode to use (default: 'CBC' if IV is
	 *          given, 'ECB' if null).
	 *
	 * @return the cipher.
	 */
	forge.des.startDecrypting = function(key, iv, output, mode) {
	  var cipher = _createCipher({
	    key: key,
	    output: output,
	    decrypt: true,
	    mode: mode || (iv === null ? 'ECB' : 'CBC')
	  });
	  cipher.start(iv);
	  return cipher;
	};

	/**
	 * Deprecated. Instead, use:
	 *
	 * var decipher = forge.cipher.createDecipher('DES-<mode>', key);
	 *
	 * Creates an DES cipher object to decrypt data using the given symmetric key.
	 *
	 * The key may be given as a binary-encoded string of bytes or a byte buffer.
	 *
	 * @param key the symmetric key to use (64 or 192 bits).
	 * @param mode the cipher mode to use (default: 'CBC').
	 *
	 * @return the cipher.
	 */
	forge.des.createDecryptionCipher = function(key, mode) {
	  return _createCipher({
	    key: key,
	    output: null,
	    decrypt: true,
	    mode: mode
	  });
	};

	/**
	 * Creates a new DES cipher algorithm object.
	 *
	 * @param name the name of the algorithm.
	 * @param mode the mode factory function.
	 *
	 * @return the DES algorithm object.
	 */
	forge.des.Algorithm = function(name, mode) {
	  var self = this;
	  self.name = name;
	  self.mode = new mode({
	    blockSize: 8,
	    cipher: {
	      encrypt: function(inBlock, outBlock) {
	        return _updateBlock(self._keys, inBlock, outBlock, false);
	      },
	      decrypt: function(inBlock, outBlock) {
	        return _updateBlock(self._keys, inBlock, outBlock, true);
	      }
	    }
	  });
	  self._init = false;
	};

	/**
	 * Initializes this DES algorithm by expanding its key.
	 *
	 * @param options the options to use.
	 *          key the key to use with this algorithm.
	 *          decrypt true if the algorithm should be initialized for decryption,
	 *            false for encryption.
	 */
	forge.des.Algorithm.prototype.initialize = function(options) {
	  if(this._init) {
	    return;
	  }

	  var key = forge.util.createBuffer(options.key);
	  if(this.name.indexOf('3DES') === 0) {
	    if(key.length() !== 24) {
	      throw new Error('Invalid Triple-DES key size: ' + key.length() * 8);
	    }
	  }

	  // do key expansion to 16 or 48 subkeys (single or triple DES)
	  this._keys = _createKeys(key);
	  this._init = true;
	};

	/** Register DES algorithms **/

	registerAlgorithm('DES-ECB', forge.cipher.modes.ecb);
	registerAlgorithm('DES-CBC', forge.cipher.modes.cbc);
	registerAlgorithm('DES-CFB', forge.cipher.modes.cfb);
	registerAlgorithm('DES-OFB', forge.cipher.modes.ofb);
	registerAlgorithm('DES-CTR', forge.cipher.modes.ctr);

	registerAlgorithm('3DES-ECB', forge.cipher.modes.ecb);
	registerAlgorithm('3DES-CBC', forge.cipher.modes.cbc);
	registerAlgorithm('3DES-CFB', forge.cipher.modes.cfb);
	registerAlgorithm('3DES-OFB', forge.cipher.modes.ofb);
	registerAlgorithm('3DES-CTR', forge.cipher.modes.ctr);

	function registerAlgorithm(name, mode) {
	  var factory = function() {
	    return new forge.des.Algorithm(name, mode);
	  };
	  forge.cipher.registerAlgorithm(name, factory);
	}

	/** DES implementation **/

	var spfunction1 = [0x1010400,0,0x10000,0x1010404,0x1010004,0x10404,0x4,0x10000,0x400,0x1010400,0x1010404,0x400,0x1000404,0x1010004,0x1000000,0x4,0x404,0x1000400,0x1000400,0x10400,0x10400,0x1010000,0x1010000,0x1000404,0x10004,0x1000004,0x1000004,0x10004,0,0x404,0x10404,0x1000000,0x10000,0x1010404,0x4,0x1010000,0x1010400,0x1000000,0x1000000,0x400,0x1010004,0x10000,0x10400,0x1000004,0x400,0x4,0x1000404,0x10404,0x1010404,0x10004,0x1010000,0x1000404,0x1000004,0x404,0x10404,0x1010400,0x404,0x1000400,0x1000400,0,0x10004,0x10400,0,0x1010004];
	var spfunction2 = [-0x7fef7fe0,-0x7fff8000,0x8000,0x108020,0x100000,0x20,-0x7fefffe0,-0x7fff7fe0,-0x7fffffe0,-0x7fef7fe0,-0x7fef8000,-0x80000000,-0x7fff8000,0x100000,0x20,-0x7fefffe0,0x108000,0x100020,-0x7fff7fe0,0,-0x80000000,0x8000,0x108020,-0x7ff00000,0x100020,-0x7fffffe0,0,0x108000,0x8020,-0x7fef8000,-0x7ff00000,0x8020,0,0x108020,-0x7fefffe0,0x100000,-0x7fff7fe0,-0x7ff00000,-0x7fef8000,0x8000,-0x7ff00000,-0x7fff8000,0x20,-0x7fef7fe0,0x108020,0x20,0x8000,-0x80000000,0x8020,-0x7fef8000,0x100000,-0x7fffffe0,0x100020,-0x7fff7fe0,-0x7fffffe0,0x100020,0x108000,0,-0x7fff8000,0x8020,-0x80000000,-0x7fefffe0,-0x7fef7fe0,0x108000];
	var spfunction3 = [0x208,0x8020200,0,0x8020008,0x8000200,0,0x20208,0x8000200,0x20008,0x8000008,0x8000008,0x20000,0x8020208,0x20008,0x8020000,0x208,0x8000000,0x8,0x8020200,0x200,0x20200,0x8020000,0x8020008,0x20208,0x8000208,0x20200,0x20000,0x8000208,0x8,0x8020208,0x200,0x8000000,0x8020200,0x8000000,0x20008,0x208,0x20000,0x8020200,0x8000200,0,0x200,0x20008,0x8020208,0x8000200,0x8000008,0x200,0,0x8020008,0x8000208,0x20000,0x8000000,0x8020208,0x8,0x20208,0x20200,0x8000008,0x8020000,0x8000208,0x208,0x8020000,0x20208,0x8,0x8020008,0x20200];
	var spfunction4 = [0x802001,0x2081,0x2081,0x80,0x802080,0x800081,0x800001,0x2001,0,0x802000,0x802000,0x802081,0x81,0,0x800080,0x800001,0x1,0x2000,0x800000,0x802001,0x80,0x800000,0x2001,0x2080,0x800081,0x1,0x2080,0x800080,0x2000,0x802080,0x802081,0x81,0x800080,0x800001,0x802000,0x802081,0x81,0,0,0x802000,0x2080,0x800080,0x800081,0x1,0x802001,0x2081,0x2081,0x80,0x802081,0x81,0x1,0x2000,0x800001,0x2001,0x802080,0x800081,0x2001,0x2080,0x800000,0x802001,0x80,0x800000,0x2000,0x802080];
	var spfunction5 = [0x100,0x2080100,0x2080000,0x42000100,0x80000,0x100,0x40000000,0x2080000,0x40080100,0x80000,0x2000100,0x40080100,0x42000100,0x42080000,0x80100,0x40000000,0x2000000,0x40080000,0x40080000,0,0x40000100,0x42080100,0x42080100,0x2000100,0x42080000,0x40000100,0,0x42000000,0x2080100,0x2000000,0x42000000,0x80100,0x80000,0x42000100,0x100,0x2000000,0x40000000,0x2080000,0x42000100,0x40080100,0x2000100,0x40000000,0x42080000,0x2080100,0x40080100,0x100,0x2000000,0x42080000,0x42080100,0x80100,0x42000000,0x42080100,0x2080000,0,0x40080000,0x42000000,0x80100,0x2000100,0x40000100,0x80000,0,0x40080000,0x2080100,0x40000100];
	var spfunction6 = [0x20000010,0x20400000,0x4000,0x20404010,0x20400000,0x10,0x20404010,0x400000,0x20004000,0x404010,0x400000,0x20000010,0x400010,0x20004000,0x20000000,0x4010,0,0x400010,0x20004010,0x4000,0x404000,0x20004010,0x10,0x20400010,0x20400010,0,0x404010,0x20404000,0x4010,0x404000,0x20404000,0x20000000,0x20004000,0x10,0x20400010,0x404000,0x20404010,0x400000,0x4010,0x20000010,0x400000,0x20004000,0x20000000,0x4010,0x20000010,0x20404010,0x404000,0x20400000,0x404010,0x20404000,0,0x20400010,0x10,0x4000,0x20400000,0x404010,0x4000,0x400010,0x20004010,0,0x20404000,0x20000000,0x400010,0x20004010];
	var spfunction7 = [0x200000,0x4200002,0x4000802,0,0x800,0x4000802,0x200802,0x4200800,0x4200802,0x200000,0,0x4000002,0x2,0x4000000,0x4200002,0x802,0x4000800,0x200802,0x200002,0x4000800,0x4000002,0x4200000,0x4200800,0x200002,0x4200000,0x800,0x802,0x4200802,0x200800,0x2,0x4000000,0x200800,0x4000000,0x200800,0x200000,0x4000802,0x4000802,0x4200002,0x4200002,0x2,0x200002,0x4000000,0x4000800,0x200000,0x4200800,0x802,0x200802,0x4200800,0x802,0x4000002,0x4200802,0x4200000,0x200800,0,0x2,0x4200802,0,0x200802,0x4200000,0x800,0x4000002,0x4000800,0x800,0x200002];
	var spfunction8 = [0x10001040,0x1000,0x40000,0x10041040,0x10000000,0x10001040,0x40,0x10000000,0x40040,0x10040000,0x10041040,0x41000,0x10041000,0x41040,0x1000,0x40,0x10040000,0x10000040,0x10001000,0x1040,0x41000,0x40040,0x10040040,0x10041000,0x1040,0,0,0x10040040,0x10000040,0x10001000,0x41040,0x40000,0x41040,0x40000,0x10041000,0x1000,0x40,0x10040040,0x1000,0x41040,0x10001000,0x40,0x10000040,0x10040000,0x10040040,0x10000000,0x40000,0x10001040,0,0x10041040,0x40040,0x10000040,0x10040000,0x10001000,0x10001040,0,0x10041040,0x41000,0x41000,0x1040,0x1040,0x40040,0x10000000,0x10041000];

	/**
	 * Create necessary sub keys.
	 *
	 * @param key the 64-bit or 192-bit key.
	 *
	 * @return the expanded keys.
	 */
	function _createKeys(key) {
	  var pc2bytes0  = [0,0x4,0x20000000,0x20000004,0x10000,0x10004,0x20010000,0x20010004,0x200,0x204,0x20000200,0x20000204,0x10200,0x10204,0x20010200,0x20010204],
	      pc2bytes1  = [0,0x1,0x100000,0x100001,0x4000000,0x4000001,0x4100000,0x4100001,0x100,0x101,0x100100,0x100101,0x4000100,0x4000101,0x4100100,0x4100101],
	      pc2bytes2  = [0,0x8,0x800,0x808,0x1000000,0x1000008,0x1000800,0x1000808,0,0x8,0x800,0x808,0x1000000,0x1000008,0x1000800,0x1000808],
	      pc2bytes3  = [0,0x200000,0x8000000,0x8200000,0x2000,0x202000,0x8002000,0x8202000,0x20000,0x220000,0x8020000,0x8220000,0x22000,0x222000,0x8022000,0x8222000],
	      pc2bytes4  = [0,0x40000,0x10,0x40010,0,0x40000,0x10,0x40010,0x1000,0x41000,0x1010,0x41010,0x1000,0x41000,0x1010,0x41010],
	      pc2bytes5  = [0,0x400,0x20,0x420,0,0x400,0x20,0x420,0x2000000,0x2000400,0x2000020,0x2000420,0x2000000,0x2000400,0x2000020,0x2000420],
	      pc2bytes6  = [0,0x10000000,0x80000,0x10080000,0x2,0x10000002,0x80002,0x10080002,0,0x10000000,0x80000,0x10080000,0x2,0x10000002,0x80002,0x10080002],
	      pc2bytes7  = [0,0x10000,0x800,0x10800,0x20000000,0x20010000,0x20000800,0x20010800,0x20000,0x30000,0x20800,0x30800,0x20020000,0x20030000,0x20020800,0x20030800],
	      pc2bytes8  = [0,0x40000,0,0x40000,0x2,0x40002,0x2,0x40002,0x2000000,0x2040000,0x2000000,0x2040000,0x2000002,0x2040002,0x2000002,0x2040002],
	      pc2bytes9  = [0,0x10000000,0x8,0x10000008,0,0x10000000,0x8,0x10000008,0x400,0x10000400,0x408,0x10000408,0x400,0x10000400,0x408,0x10000408],
	      pc2bytes10 = [0,0x20,0,0x20,0x100000,0x100020,0x100000,0x100020,0x2000,0x2020,0x2000,0x2020,0x102000,0x102020,0x102000,0x102020],
	      pc2bytes11 = [0,0x1000000,0x200,0x1000200,0x200000,0x1200000,0x200200,0x1200200,0x4000000,0x5000000,0x4000200,0x5000200,0x4200000,0x5200000,0x4200200,0x5200200],
	      pc2bytes12 = [0,0x1000,0x8000000,0x8001000,0x80000,0x81000,0x8080000,0x8081000,0x10,0x1010,0x8000010,0x8001010,0x80010,0x81010,0x8080010,0x8081010],
	      pc2bytes13 = [0,0x4,0x100,0x104,0,0x4,0x100,0x104,0x1,0x5,0x101,0x105,0x1,0x5,0x101,0x105];

	  // how many iterations (1 for des, 3 for triple des)
	  // changed by Paul 16/6/2007 to use Triple DES for 9+ byte keys
	  var iterations = key.length() > 8 ? 3 : 1;

	  // stores the return keys
	  var keys = [];

	  // now define the left shifts which need to be done
	  var shifts = [0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0];

	  var n = 0, tmp;
	  for(var j = 0; j < iterations; j++) {
	    var left = key.getInt32();
	    var right = key.getInt32();

	    tmp = ((left >>> 4) ^ right) & 0x0f0f0f0f;
	    right ^= tmp;
	    left ^= (tmp << 4);

	    tmp = ((right >>> -16) ^ left) & 0x0000ffff;
	    left ^= tmp;
	    right ^= (tmp << -16);

	    tmp = ((left >>> 2) ^ right) & 0x33333333;
	    right ^= tmp;
	    left ^= (tmp << 2);

	    tmp = ((right >>> -16) ^ left) & 0x0000ffff;
	    left ^= tmp;
	    right ^= (tmp << -16);

	    tmp = ((left >>> 1) ^ right) & 0x55555555;
	    right ^= tmp;
	    left ^= (tmp << 1);

	    tmp = ((right >>> 8) ^ left) & 0x00ff00ff;
	    left ^= tmp;
	    right ^= (tmp << 8);

	    tmp = ((left >>> 1) ^ right) & 0x55555555;
	    right ^= tmp;
	    left ^= (tmp << 1);

	    // right needs to be shifted and OR'd with last four bits of left
	    tmp = (left << 8) | ((right >>> 20) & 0x000000f0);

	    // left needs to be put upside down
	    left = ((right << 24) | ((right << 8) & 0xff0000) |
	      ((right >>> 8) & 0xff00) | ((right >>> 24) & 0xf0));
	    right = tmp;

	    // now go through and perform these shifts on the left and right keys
	    for(var i = 0; i < shifts.length; ++i) {
	      //shift the keys either one or two bits to the left
	      if(shifts[i]) {
	        left = (left << 2) | (left >>> 26);
	        right = (right << 2) | (right >>> 26);
	      } else {
	        left = (left << 1) | (left >>> 27);
	        right = (right << 1) | (right >>> 27);
	      }
	      left &= -0xf;
	      right &= -0xf;

	      // now apply PC-2, in such a way that E is easier when encrypting or
	      // decrypting this conversion will look like PC-2 except only the last 6
	      // bits of each byte are used rather than 48 consecutive bits and the
	      // order of lines will be according to how the S selection functions will
	      // be applied: S2, S4, S6, S8, S1, S3, S5, S7
	      var lefttmp = (
	        pc2bytes0[left >>> 28] | pc2bytes1[(left >>> 24) & 0xf] |
	        pc2bytes2[(left >>> 20) & 0xf] | pc2bytes3[(left >>> 16) & 0xf] |
	        pc2bytes4[(left >>> 12) & 0xf] | pc2bytes5[(left >>> 8) & 0xf] |
	        pc2bytes6[(left >>> 4) & 0xf]);
	      var righttmp = (
	        pc2bytes7[right >>> 28] | pc2bytes8[(right >>> 24) & 0xf] |
	        pc2bytes9[(right >>> 20) & 0xf] | pc2bytes10[(right >>> 16) & 0xf] |
	        pc2bytes11[(right >>> 12) & 0xf] | pc2bytes12[(right >>> 8) & 0xf] |
	        pc2bytes13[(right >>> 4) & 0xf]);
	      tmp = ((righttmp >>> 16) ^ lefttmp) & 0x0000ffff;
	      keys[n++] = lefttmp ^ tmp;
	      keys[n++] = righttmp ^ (tmp << 16);
	    }
	  }

	  return keys;
	}

	/**
	 * Updates a single block (1 byte) using DES. The update will either
	 * encrypt or decrypt the block.
	 *
	 * @param keys the expanded keys.
	 * @param input the input block (an array of 32-bit words).
	 * @param output the updated output block.
	 * @param decrypt true to decrypt the block, false to encrypt it.
	 */
	function _updateBlock(keys, input, output, decrypt) {
	  // set up loops for single or triple DES
	  var iterations = keys.length === 32 ? 3 : 9;
	  var looping;
	  if(iterations === 3) {
	    looping = decrypt ? [30, -2, -2] : [0, 32, 2];
	  } else {
	    looping = (decrypt ?
	      [94, 62, -2, 32, 64, 2, 30, -2, -2] :
	      [0, 32, 2, 62, 30, -2, 64, 96, 2]);
	  }

	  var tmp;

	  var left = input[0];
	  var right = input[1];

	  // first each 64 bit chunk of the message must be permuted according to IP
	  tmp = ((left >>> 4) ^ right) & 0x0f0f0f0f;
	  right ^= tmp;
	  left ^= (tmp << 4);

	  tmp = ((left >>> 16) ^ right) & 0x0000ffff;
	  right ^= tmp;
	  left ^= (tmp << 16);

	  tmp = ((right >>> 2) ^ left) & 0x33333333;
	  left ^= tmp;
	  right ^= (tmp << 2);

	  tmp = ((right >>> 8) ^ left) & 0x00ff00ff;
	  left ^= tmp;
	  right ^= (tmp << 8);

	  tmp = ((left >>> 1) ^ right) & 0x55555555;
	  right ^= tmp;
	  left ^= (tmp << 1);

	  // rotate left 1 bit
	  left = ((left << 1) | (left >>> 31));
	  right = ((right << 1) | (right >>> 31));

	  for(var j = 0; j < iterations; j += 3) {
	    var endloop = looping[j + 1];
	    var loopinc = looping[j + 2];

	    // now go through and perform the encryption or decryption
	    for(var i = looping[j]; i != endloop; i += loopinc) {
	      var right1 = right ^ keys[i];
	      var right2 = ((right >>> 4) | (right << 28)) ^ keys[i + 1];

	      // passing these bytes through the S selection functions
	      tmp = left;
	      left = right;
	      right = tmp ^ (
	        spfunction2[(right1 >>> 24) & 0x3f] |
	        spfunction4[(right1 >>> 16) & 0x3f] |
	        spfunction6[(right1 >>>  8) & 0x3f] |
	        spfunction8[right1 & 0x3f] |
	        spfunction1[(right2 >>> 24) & 0x3f] |
	        spfunction3[(right2 >>> 16) & 0x3f] |
	        spfunction5[(right2 >>>  8) & 0x3f] |
	        spfunction7[right2 & 0x3f]);
	    }
	    // unreverse left and right
	    tmp = left;
	    left = right;
	    right = tmp;
	  }

	  // rotate right 1 bit
	  left = ((left >>> 1) | (left << 31));
	  right = ((right >>> 1) | (right << 31));

	  // now perform IP-1, which is IP in the opposite direction
	  tmp = ((left >>> 1) ^ right) & 0x55555555;
	  right ^= tmp;
	  left ^= (tmp << 1);

	  tmp = ((right >>> 8) ^ left) & 0x00ff00ff;
	  left ^= tmp;
	  right ^= (tmp << 8);

	  tmp = ((right >>> 2) ^ left) & 0x33333333;
	  left ^= tmp;
	  right ^= (tmp << 2);

	  tmp = ((left >>> 16) ^ right) & 0x0000ffff;
	  right ^= tmp;
	  left ^= (tmp << 16);

	  tmp = ((left >>> 4) ^ right) & 0x0f0f0f0f;
	  right ^= tmp;
	  left ^= (tmp << 4);

	  output[0] = left;
	  output[1] = right;
	}

	/**
	 * Deprecated. Instead, use:
	 *
	 * forge.cipher.createCipher('DES-<mode>', key);
	 * forge.cipher.createDecipher('DES-<mode>', key);
	 *
	 * Creates a deprecated DES cipher object. This object's mode will default to
	 * CBC (cipher-block-chaining).
	 *
	 * The key may be given as a binary-encoded string of bytes or a byte buffer.
	 *
	 * @param options the options to use.
	 *          key the symmetric key to use (64 or 192 bits).
	 *          output the buffer to write to.
	 *          decrypt true for decryption, false for encryption.
	 *          mode the cipher mode to use (default: 'CBC').
	 *
	 * @return the cipher.
	 */
	function _createCipher(options) {
	  options = options || {};
	  var mode = (options.mode || 'CBC').toUpperCase();
	  var algorithm = 'DES-' + mode;

	  var cipher;
	  if(options.decrypt) {
	    cipher = forge.cipher.createDecipher(algorithm, options.key);
	  } else {
	    cipher = forge.cipher.createCipher(algorithm, options.key);
	  }

	  // backwards compatible start API
	  var start = cipher.start;
	  cipher.start = function(iv, options) {
	    // backwards compatibility: support second arg as output buffer
	    var output = null;
	    if(options instanceof forge.util.ByteBuffer) {
	      output = options;
	      options = {};
	    }
	    options = options || {};
	    options.output = output;
	    options.iv = iv;
	    start.call(cipher, options);
	  };

	  return cipher;
	}

	var _nodeResolve_empty = {};

	var _nodeResolve_empty$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		'default': _nodeResolve_empty
	});

	var require$$7 = getCjsExportFromNamespace(_nodeResolve_empty$1);

	/**
	 * Password-Based Key-Derivation Function #2 implementation.
	 *
	 * See RFC 2898 for details.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2013 Digital Bazaar, Inc.
	 */





	var pkcs5 = forge.pkcs5 = forge.pkcs5 || {};

	var crypto$1;
	if(forge.util.isNodejs && !forge.options.usePureJavaScript) {
	  crypto$1 = require$$7;
	}

	/**
	 * Derives a key from a password.
	 *
	 * @param p the password as a binary-encoded string of bytes.
	 * @param s the salt as a binary-encoded string of bytes.
	 * @param c the iteration count, a positive integer.
	 * @param dkLen the intended length, in bytes, of the derived key,
	 *          (max: 2^32 - 1) * hash length of the PRF.
	 * @param [md] the message digest (or algorithm identifier as a string) to use
	 *          in the PRF, defaults to SHA-1.
	 * @param [callback(err, key)] presence triggers asynchronous version, called
	 *          once the operation completes.
	 *
	 * @return the derived key, as a binary-encoded string of bytes, for the
	 *           synchronous version (if no callback is specified).
	 */
	forge.pbkdf2 = pkcs5.pbkdf2 = function(
	  p, s, c, dkLen, md, callback) {
	  if(typeof md === 'function') {
	    callback = md;
	    md = null;
	  }

	  // use native implementation if possible and not disabled, note that
	  // some node versions only support SHA-1, others allow digest to be changed
	  if(forge.util.isNodejs && !forge.options.usePureJavaScript &&
	    crypto$1.pbkdf2 && (md === null || typeof md !== 'object') &&
	    (crypto$1.pbkdf2Sync.length > 4 || (!md || md === 'sha1'))) {
	    if(typeof md !== 'string') {
	      // default prf to SHA-1
	      md = 'sha1';
	    }
	    p = Buffer.from(p, 'binary');
	    s = Buffer.from(s, 'binary');
	    if(!callback) {
	      if(crypto$1.pbkdf2Sync.length === 4) {
	        return crypto$1.pbkdf2Sync(p, s, c, dkLen).toString('binary');
	      }
	      return crypto$1.pbkdf2Sync(p, s, c, dkLen, md).toString('binary');
	    }
	    if(crypto$1.pbkdf2Sync.length === 4) {
	      return crypto$1.pbkdf2(p, s, c, dkLen, function(err, key) {
	        if(err) {
	          return callback(err);
	        }
	        callback(null, key.toString('binary'));
	      });
	    }
	    return crypto$1.pbkdf2(p, s, c, dkLen, md, function(err, key) {
	      if(err) {
	        return callback(err);
	      }
	      callback(null, key.toString('binary'));
	    });
	  }

	  if(typeof md === 'undefined' || md === null) {
	    // default prf to SHA-1
	    md = 'sha1';
	  }
	  if(typeof md === 'string') {
	    if(!(md in forge.md.algorithms)) {
	      throw new Error('Unknown hash algorithm: ' + md);
	    }
	    md = forge.md[md].create();
	  }

	  var hLen = md.digestLength;

	  /* 1. If dkLen > (2^32 - 1) * hLen, output "derived key too long" and
	    stop. */
	  if(dkLen > (0xFFFFFFFF * hLen)) {
	    var err = new Error('Derived key is too long.');
	    if(callback) {
	      return callback(err);
	    }
	    throw err;
	  }

	  /* 2. Let len be the number of hLen-octet blocks in the derived key,
	    rounding up, and let r be the number of octets in the last
	    block:

	    len = CEIL(dkLen / hLen),
	    r = dkLen - (len - 1) * hLen. */
	  var len = Math.ceil(dkLen / hLen);
	  var r = dkLen - (len - 1) * hLen;

	  /* 3. For each block of the derived key apply the function F defined
	    below to the password P, the salt S, the iteration count c, and
	    the block index to compute the block:

	    T_1 = F(P, S, c, 1),
	    T_2 = F(P, S, c, 2),
	    ...
	    T_len = F(P, S, c, len),

	    where the function F is defined as the exclusive-or sum of the
	    first c iterates of the underlying pseudorandom function PRF
	    applied to the password P and the concatenation of the salt S
	    and the block index i:

	    F(P, S, c, i) = u_1 XOR u_2 XOR ... XOR u_c

	    where

	    u_1 = PRF(P, S || INT(i)),
	    u_2 = PRF(P, u_1),
	    ...
	    u_c = PRF(P, u_{c-1}).

	    Here, INT(i) is a four-octet encoding of the integer i, most
	    significant octet first. */
	  var prf = forge.hmac.create();
	  prf.start(md, p);
	  var dk = '';
	  var xor, u_c, u_c1;

	  // sync version
	  if(!callback) {
	    for(var i = 1; i <= len; ++i) {
	      // PRF(P, S || INT(i)) (first iteration)
	      prf.start(null, null);
	      prf.update(s);
	      prf.update(forge.util.int32ToBytes(i));
	      xor = u_c1 = prf.digest().getBytes();

	      // PRF(P, u_{c-1}) (other iterations)
	      for(var j = 2; j <= c; ++j) {
	        prf.start(null, null);
	        prf.update(u_c1);
	        u_c = prf.digest().getBytes();
	        // F(p, s, c, i)
	        xor = forge.util.xorBytes(xor, u_c, hLen);
	        u_c1 = u_c;
	      }

	      /* 4. Concatenate the blocks and extract the first dkLen octets to
	        produce a derived key DK:

	        DK = T_1 || T_2 ||  ...  || T_len<0..r-1> */
	      dk += (i < len) ? xor : xor.substr(0, r);
	    }
	    /* 5. Output the derived key DK. */
	    return dk;
	  }

	  // async version
	  var i = 1, j;
	  function outer() {
	    if(i > len) {
	      // done
	      return callback(null, dk);
	    }

	    // PRF(P, S || INT(i)) (first iteration)
	    prf.start(null, null);
	    prf.update(s);
	    prf.update(forge.util.int32ToBytes(i));
	    xor = u_c1 = prf.digest().getBytes();

	    // PRF(P, u_{c-1}) (other iterations)
	    j = 2;
	    inner();
	  }

	  function inner() {
	    if(j <= c) {
	      prf.start(null, null);
	      prf.update(u_c1);
	      u_c = prf.digest().getBytes();
	      // F(p, s, c, i)
	      xor = forge.util.xorBytes(xor, u_c, hLen);
	      u_c1 = u_c;
	      ++j;
	      return forge.util.setImmediate(inner);
	    }

	    /* 4. Concatenate the blocks and extract the first dkLen octets to
	      produce a derived key DK:

	      DK = T_1 || T_2 ||  ...  || T_len<0..r-1> */
	    dk += (i < len) ? xor : xor.substr(0, r);

	    ++i;
	    outer();
	  }

	  outer();
	};

	createCommonjsModule(function (module) {
	/**
	 * Secure Hash Algorithm with 256-bit digest (SHA-256) implementation.
	 *
	 * See FIPS 180-2 for details.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2015 Digital Bazaar, Inc.
	 */




	var sha256 = module.exports = forge.sha256 = forge.sha256 || {};
	forge.md.sha256 = forge.md.algorithms.sha256 = sha256;

	/**
	 * Creates a SHA-256 message digest object.
	 *
	 * @return a message digest object.
	 */
	sha256.create = function() {
	  // do initialization as necessary
	  if(!_initialized) {
	    _init();
	  }

	  // SHA-256 state contains eight 32-bit integers
	  var _state = null;

	  // input buffer
	  var _input = forge.util.createBuffer();

	  // used for word storage
	  var _w = new Array(64);

	  // message digest object
	  var md = {
	    algorithm: 'sha256',
	    blockLength: 64,
	    digestLength: 32,
	    // 56-bit length of message so far (does not including padding)
	    messageLength: 0,
	    // true message length
	    fullMessageLength: null,
	    // size of message length in bytes
	    messageLengthSize: 8
	  };

	  /**
	   * Starts the digest.
	   *
	   * @return this digest object.
	   */
	  md.start = function() {
	    // up to 56-bit message length for convenience
	    md.messageLength = 0;

	    // full message length (set md.messageLength64 for backwards-compatibility)
	    md.fullMessageLength = md.messageLength64 = [];
	    var int32s = md.messageLengthSize / 4;
	    for(var i = 0; i < int32s; ++i) {
	      md.fullMessageLength.push(0);
	    }
	    _input = forge.util.createBuffer();
	    _state = {
	      h0: 0x6A09E667,
	      h1: 0xBB67AE85,
	      h2: 0x3C6EF372,
	      h3: 0xA54FF53A,
	      h4: 0x510E527F,
	      h5: 0x9B05688C,
	      h6: 0x1F83D9AB,
	      h7: 0x5BE0CD19
	    };
	    return md;
	  };
	  // start digest automatically for first time
	  md.start();

	  /**
	   * Updates the digest with the given message input. The given input can
	   * treated as raw input (no encoding will be applied) or an encoding of
	   * 'utf8' maybe given to encode the input using UTF-8.
	   *
	   * @param msg the message input to update with.
	   * @param encoding the encoding to use (default: 'raw', other: 'utf8').
	   *
	   * @return this digest object.
	   */
	  md.update = function(msg, encoding) {
	    if(encoding === 'utf8') {
	      msg = forge.util.encodeUtf8(msg);
	    }

	    // update message length
	    var len = msg.length;
	    md.messageLength += len;
	    len = [(len / 0x100000000) >>> 0, len >>> 0];
	    for(var i = md.fullMessageLength.length - 1; i >= 0; --i) {
	      md.fullMessageLength[i] += len[1];
	      len[1] = len[0] + ((md.fullMessageLength[i] / 0x100000000) >>> 0);
	      md.fullMessageLength[i] = md.fullMessageLength[i] >>> 0;
	      len[0] = ((len[1] / 0x100000000) >>> 0);
	    }

	    // add bytes to input buffer
	    _input.putBytes(msg);

	    // process bytes
	    _update(_state, _w, _input);

	    // compact input buffer every 2K or if empty
	    if(_input.read > 2048 || _input.length() === 0) {
	      _input.compact();
	    }

	    return md;
	  };

	  /**
	   * Produces the digest.
	   *
	   * @return a byte buffer containing the digest value.
	   */
	  md.digest = function() {
	    /* Note: Here we copy the remaining bytes in the input buffer and
	    add the appropriate SHA-256 padding. Then we do the final update
	    on a copy of the state so that if the user wants to get
	    intermediate digests they can do so. */

	    /* Determine the number of bytes that must be added to the message
	    to ensure its length is congruent to 448 mod 512. In other words,
	    the data to be digested must be a multiple of 512 bits (or 128 bytes).
	    This data includes the message, some padding, and the length of the
	    message. Since the length of the message will be encoded as 8 bytes (64
	    bits), that means that the last segment of the data must have 56 bytes
	    (448 bits) of message and padding. Therefore, the length of the message
	    plus the padding must be congruent to 448 mod 512 because
	    512 - 128 = 448.

	    In order to fill up the message length it must be filled with
	    padding that begins with 1 bit followed by all 0 bits. Padding
	    must *always* be present, so if the message length is already
	    congruent to 448 mod 512, then 512 padding bits must be added. */

	    var finalBlock = forge.util.createBuffer();
	    finalBlock.putBytes(_input.bytes());

	    // compute remaining size to be digested (include message length size)
	    var remaining = (
	      md.fullMessageLength[md.fullMessageLength.length - 1] +
	      md.messageLengthSize);

	    // add padding for overflow blockSize - overflow
	    // _padding starts with 1 byte with first bit is set (byte value 128), then
	    // there may be up to (blockSize - 1) other pad bytes
	    var overflow = remaining & (md.blockLength - 1);
	    finalBlock.putBytes(_padding.substr(0, md.blockLength - overflow));

	    // serialize message length in bits in big-endian order; since length
	    // is stored in bytes we multiply by 8 and add carry from next int
	    var next, carry;
	    var bits = md.fullMessageLength[0] * 8;
	    for(var i = 0; i < md.fullMessageLength.length - 1; ++i) {
	      next = md.fullMessageLength[i + 1] * 8;
	      carry = (next / 0x100000000) >>> 0;
	      bits += carry;
	      finalBlock.putInt32(bits >>> 0);
	      bits = next >>> 0;
	    }
	    finalBlock.putInt32(bits);

	    var s2 = {
	      h0: _state.h0,
	      h1: _state.h1,
	      h2: _state.h2,
	      h3: _state.h3,
	      h4: _state.h4,
	      h5: _state.h5,
	      h6: _state.h6,
	      h7: _state.h7
	    };
	    _update(s2, _w, finalBlock);
	    var rval = forge.util.createBuffer();
	    rval.putInt32(s2.h0);
	    rval.putInt32(s2.h1);
	    rval.putInt32(s2.h2);
	    rval.putInt32(s2.h3);
	    rval.putInt32(s2.h4);
	    rval.putInt32(s2.h5);
	    rval.putInt32(s2.h6);
	    rval.putInt32(s2.h7);
	    return rval;
	  };

	  return md;
	};

	// sha-256 padding bytes not initialized yet
	var _padding = null;
	var _initialized = false;

	// table of constants
	var _k = null;

	/**
	 * Initializes the constant tables.
	 */
	function _init() {
	  // create padding
	  _padding = String.fromCharCode(128);
	  _padding += forge.util.fillString(String.fromCharCode(0x00), 64);

	  // create K table for SHA-256
	  _k = [
	    0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
	    0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
	    0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
	    0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
	    0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
	    0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
	    0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
	    0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
	    0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
	    0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
	    0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
	    0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
	    0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
	    0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
	    0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
	    0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2];

	  // now initialized
	  _initialized = true;
	}

	/**
	 * Updates a SHA-256 state with the given byte buffer.
	 *
	 * @param s the SHA-256 state to update.
	 * @param w the array to use to store words.
	 * @param bytes the byte buffer to update with.
	 */
	function _update(s, w, bytes) {
	  // consume 512 bit (64 byte) chunks
	  var t1, t2, s0, s1, ch, maj, i, a, b, c, d, e, f, g, h;
	  var len = bytes.length();
	  while(len >= 64) {
	    // the w array will be populated with sixteen 32-bit big-endian words
	    // and then extended into 64 32-bit words according to SHA-256
	    for(i = 0; i < 16; ++i) {
	      w[i] = bytes.getInt32();
	    }
	    for(; i < 64; ++i) {
	      // XOR word 2 words ago rot right 17, rot right 19, shft right 10
	      t1 = w[i - 2];
	      t1 =
	        ((t1 >>> 17) | (t1 << 15)) ^
	        ((t1 >>> 19) | (t1 << 13)) ^
	        (t1 >>> 10);
	      // XOR word 15 words ago rot right 7, rot right 18, shft right 3
	      t2 = w[i - 15];
	      t2 =
	        ((t2 >>> 7) | (t2 << 25)) ^
	        ((t2 >>> 18) | (t2 << 14)) ^
	        (t2 >>> 3);
	      // sum(t1, word 7 ago, t2, word 16 ago) modulo 2^32
	      w[i] = (t1 + w[i - 7] + t2 + w[i - 16]) | 0;
	    }

	    // initialize hash value for this chunk
	    a = s.h0;
	    b = s.h1;
	    c = s.h2;
	    d = s.h3;
	    e = s.h4;
	    f = s.h5;
	    g = s.h6;
	    h = s.h7;

	    // round function
	    for(i = 0; i < 64; ++i) {
	      // Sum1(e)
	      s1 =
	        ((e >>> 6) | (e << 26)) ^
	        ((e >>> 11) | (e << 21)) ^
	        ((e >>> 25) | (e << 7));
	      // Ch(e, f, g) (optimized the same way as SHA-1)
	      ch = g ^ (e & (f ^ g));
	      // Sum0(a)
	      s0 =
	        ((a >>> 2) | (a << 30)) ^
	        ((a >>> 13) | (a << 19)) ^
	        ((a >>> 22) | (a << 10));
	      // Maj(a, b, c) (optimized the same way as SHA-1)
	      maj = (a & b) | (c & (a ^ b));

	      // main algorithm
	      t1 = h + s1 + ch + _k[i] + w[i];
	      t2 = s0 + maj;
	      h = g;
	      g = f;
	      f = e;
	      // `>>> 0` necessary to avoid iOS/Safari 10 optimization bug
	      // can't truncate with `| 0`
	      e = (d + t1) >>> 0;
	      d = c;
	      c = b;
	      b = a;
	      // `>>> 0` necessary to avoid iOS/Safari 10 optimization bug
	      // can't truncate with `| 0`
	      a = (t1 + t2) >>> 0;
	    }

	    // update hash state
	    s.h0 = (s.h0 + a) | 0;
	    s.h1 = (s.h1 + b) | 0;
	    s.h2 = (s.h2 + c) | 0;
	    s.h3 = (s.h3 + d) | 0;
	    s.h4 = (s.h4 + e) | 0;
	    s.h5 = (s.h5 + f) | 0;
	    s.h6 = (s.h6 + g) | 0;
	    s.h7 = (s.h7 + h) | 0;
	    len -= 64;
	  }
	}
	});

	createCommonjsModule(function (module) {
	/**
	 * A javascript implementation of a cryptographically-secure
	 * Pseudo Random Number Generator (PRNG). The Fortuna algorithm is followed
	 * here though the use of SHA-256 is not enforced; when generating an
	 * a PRNG context, the hashing algorithm and block cipher used for
	 * the generator are specified via a plugin.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2014 Digital Bazaar, Inc.
	 */



	var _crypto = null;
	if(forge.util.isNodejs && !forge.options.usePureJavaScript &&
	  !process.versions['node-webkit']) {
	  _crypto = require$$7;
	}

	/* PRNG API */
	var prng = module.exports = forge.prng = forge.prng || {};

	/**
	 * Creates a new PRNG context.
	 *
	 * A PRNG plugin must be passed in that will provide:
	 *
	 * 1. A function that initializes the key and seed of a PRNG context. It
	 *   will be given a 16 byte key and a 16 byte seed. Any key expansion
	 *   or transformation of the seed from a byte string into an array of
	 *   integers (or similar) should be performed.
	 * 2. The cryptographic function used by the generator. It takes a key and
	 *   a seed.
	 * 3. A seed increment function. It takes the seed and returns seed + 1.
	 * 4. An api to create a message digest.
	 *
	 * For an example, see random.js.
	 *
	 * @param plugin the PRNG plugin to use.
	 */
	prng.create = function(plugin) {
	  var ctx = {
	    plugin: plugin,
	    key: null,
	    seed: null,
	    time: null,
	    // number of reseeds so far
	    reseeds: 0,
	    // amount of data generated so far
	    generated: 0,
	    // no initial key bytes
	    keyBytes: ''
	  };

	  // create 32 entropy pools (each is a message digest)
	  var md = plugin.md;
	  var pools = new Array(32);
	  for(var i = 0; i < 32; ++i) {
	    pools[i] = md.create();
	  }
	  ctx.pools = pools;

	  // entropy pools are written to cyclically, starting at index 0
	  ctx.pool = 0;

	  /**
	   * Generates random bytes. The bytes may be generated synchronously or
	   * asynchronously. Web workers must use the asynchronous interface or
	   * else the behavior is undefined.
	   *
	   * @param count the number of random bytes to generate.
	   * @param [callback(err, bytes)] called once the operation completes.
	   *
	   * @return count random bytes as a string.
	   */
	  ctx.generate = function(count, callback) {
	    // do synchronously
	    if(!callback) {
	      return ctx.generateSync(count);
	    }

	    // simple generator using counter-based CBC
	    var cipher = ctx.plugin.cipher;
	    var increment = ctx.plugin.increment;
	    var formatKey = ctx.plugin.formatKey;
	    var formatSeed = ctx.plugin.formatSeed;
	    var b = forge.util.createBuffer();

	    // paranoid deviation from Fortuna:
	    // reset key for every request to protect previously
	    // generated random bytes should the key be discovered;
	    // there is no 100ms based reseeding because of this
	    // forced reseed for every `generate` call
	    ctx.key = null;

	    generate();

	    function generate(err) {
	      if(err) {
	        return callback(err);
	      }

	      // sufficient bytes generated
	      if(b.length() >= count) {
	        return callback(null, b.getBytes(count));
	      }

	      // if amount of data generated is greater than 1 MiB, trigger reseed
	      if(ctx.generated > 0xfffff) {
	        ctx.key = null;
	      }

	      if(ctx.key === null) {
	        // prevent stack overflow
	        return forge.util.nextTick(function() {
	          _reseed(generate);
	        });
	      }

	      // generate the random bytes
	      var bytes = cipher(ctx.key, ctx.seed);
	      ctx.generated += bytes.length;
	      b.putBytes(bytes);

	      // generate bytes for a new key and seed
	      ctx.key = formatKey(cipher(ctx.key, increment(ctx.seed)));
	      ctx.seed = formatSeed(cipher(ctx.key, ctx.seed));

	      forge.util.setImmediate(generate);
	    }
	  };

	  /**
	   * Generates random bytes synchronously.
	   *
	   * @param count the number of random bytes to generate.
	   *
	   * @return count random bytes as a string.
	   */
	  ctx.generateSync = function(count) {
	    // simple generator using counter-based CBC
	    var cipher = ctx.plugin.cipher;
	    var increment = ctx.plugin.increment;
	    var formatKey = ctx.plugin.formatKey;
	    var formatSeed = ctx.plugin.formatSeed;

	    // paranoid deviation from Fortuna:
	    // reset key for every request to protect previously
	    // generated random bytes should the key be discovered;
	    // there is no 100ms based reseeding because of this
	    // forced reseed for every `generateSync` call
	    ctx.key = null;

	    var b = forge.util.createBuffer();
	    while(b.length() < count) {
	      // if amount of data generated is greater than 1 MiB, trigger reseed
	      if(ctx.generated > 0xfffff) {
	        ctx.key = null;
	      }

	      if(ctx.key === null) {
	        _reseedSync();
	      }

	      // generate the random bytes
	      var bytes = cipher(ctx.key, ctx.seed);
	      ctx.generated += bytes.length;
	      b.putBytes(bytes);

	      // generate bytes for a new key and seed
	      ctx.key = formatKey(cipher(ctx.key, increment(ctx.seed)));
	      ctx.seed = formatSeed(cipher(ctx.key, ctx.seed));
	    }

	    return b.getBytes(count);
	  };

	  /**
	   * Private function that asynchronously reseeds a generator.
	   *
	   * @param callback(err) called once the operation completes.
	   */
	  function _reseed(callback) {
	    if(ctx.pools[0].messageLength >= 32) {
	      _seed();
	      return callback();
	    }
	    // not enough seed data...
	    var needed = (32 - ctx.pools[0].messageLength) << 5;
	    ctx.seedFile(needed, function(err, bytes) {
	      if(err) {
	        return callback(err);
	      }
	      ctx.collect(bytes);
	      _seed();
	      callback();
	    });
	  }

	  /**
	   * Private function that synchronously reseeds a generator.
	   */
	  function _reseedSync() {
	    if(ctx.pools[0].messageLength >= 32) {
	      return _seed();
	    }
	    // not enough seed data...
	    var needed = (32 - ctx.pools[0].messageLength) << 5;
	    ctx.collect(ctx.seedFileSync(needed));
	    _seed();
	  }

	  /**
	   * Private function that seeds a generator once enough bytes are available.
	   */
	  function _seed() {
	    // update reseed count
	    ctx.reseeds = (ctx.reseeds === 0xffffffff) ? 0 : ctx.reseeds + 1;

	    // goal is to update `key` via:
	    // key = hash(key + s)
	    //   where 's' is all collected entropy from selected pools, then...

	    // create a plugin-based message digest
	    var md = ctx.plugin.md.create();

	    // consume current key bytes
	    md.update(ctx.keyBytes);

	    // digest the entropy of pools whose index k meet the
	    // condition 'n mod 2^k == 0' where n is the number of reseeds
	    var _2powK = 1;
	    for(var k = 0; k < 32; ++k) {
	      if(ctx.reseeds % _2powK === 0) {
	        md.update(ctx.pools[k].digest().getBytes());
	        ctx.pools[k].start();
	      }
	      _2powK = _2powK << 1;
	    }

	    // get digest for key bytes
	    ctx.keyBytes = md.digest().getBytes();

	    // paranoid deviation from Fortuna:
	    // update `seed` via `seed = hash(key)`
	    // instead of initializing to zero once and only
	    // ever incrementing it
	    md.start();
	    md.update(ctx.keyBytes);
	    var seedBytes = md.digest().getBytes();

	    // update state
	    ctx.key = ctx.plugin.formatKey(ctx.keyBytes);
	    ctx.seed = ctx.plugin.formatSeed(seedBytes);
	    ctx.generated = 0;
	  }

	  /**
	   * The built-in default seedFile. This seedFile is used when entropy
	   * is needed immediately.
	   *
	   * @param needed the number of bytes that are needed.
	   *
	   * @return the random bytes.
	   */
	  function defaultSeedFile(needed) {
	    // use window.crypto.getRandomValues strong source of entropy if available
	    var getRandomValues = null;
	    var globalScope = forge.util.globalScope;
	    var _crypto = globalScope.crypto || globalScope.msCrypto;
	    if(_crypto && _crypto.getRandomValues) {
	      getRandomValues = function(arr) {
	        return _crypto.getRandomValues(arr);
	      };
	    }

	    var b = forge.util.createBuffer();
	    if(getRandomValues) {
	      while(b.length() < needed) {
	        // max byte length is 65536 before QuotaExceededError is thrown
	        // http://www.w3.org/TR/WebCryptoAPI/#RandomSource-method-getRandomValues
	        var count = Math.max(1, Math.min(needed - b.length(), 65536) / 4);
	        var entropy = new Uint32Array(Math.floor(count));
	        try {
	          getRandomValues(entropy);
	          for(var i = 0; i < entropy.length; ++i) {
	            b.putInt32(entropy[i]);
	          }
	        } catch(e) {
	          /* only ignore QuotaExceededError */
	          if(!(typeof QuotaExceededError !== 'undefined' &&
	            e instanceof QuotaExceededError)) {
	            throw e;
	          }
	        }
	      }
	    }

	    // be sad and add some weak random data
	    if(b.length() < needed) {
	      /* Draws from Park-Miller "minimal standard" 31 bit PRNG,
	      implemented with David G. Carta's optimization: with 32 bit math
	      and without division (Public Domain). */
	      var hi, lo, next;
	      var seed = Math.floor(Math.random() * 0x010000);
	      while(b.length() < needed) {
	        lo = 16807 * (seed & 0xFFFF);
	        hi = 16807 * (seed >> 16);
	        lo += (hi & 0x7FFF) << 16;
	        lo += hi >> 15;
	        lo = (lo & 0x7FFFFFFF) + (lo >> 31);
	        seed = lo & 0xFFFFFFFF;

	        // consume lower 3 bytes of seed
	        for(var i = 0; i < 3; ++i) {
	          // throw in more pseudo random
	          next = seed >>> (i << 3);
	          next ^= Math.floor(Math.random() * 0x0100);
	          b.putByte(String.fromCharCode(next & 0xFF));
	        }
	      }
	    }

	    return b.getBytes(needed);
	  }
	  // initialize seed file APIs
	  if(_crypto) {
	    // use nodejs async API
	    ctx.seedFile = function(needed, callback) {
	      _crypto.randomBytes(needed, function(err, bytes) {
	        if(err) {
	          return callback(err);
	        }
	        callback(null, bytes.toString());
	      });
	    };
	    // use nodejs sync API
	    ctx.seedFileSync = function(needed) {
	      return _crypto.randomBytes(needed).toString();
	    };
	  } else {
	    ctx.seedFile = function(needed, callback) {
	      try {
	        callback(null, defaultSeedFile(needed));
	      } catch(e) {
	        callback(e);
	      }
	    };
	    ctx.seedFileSync = defaultSeedFile;
	  }

	  /**
	   * Adds entropy to a prng ctx's accumulator.
	   *
	   * @param bytes the bytes of entropy as a string.
	   */
	  ctx.collect = function(bytes) {
	    // iterate over pools distributing entropy cyclically
	    var count = bytes.length;
	    for(var i = 0; i < count; ++i) {
	      ctx.pools[ctx.pool].update(bytes.substr(i, 1));
	      ctx.pool = (ctx.pool === 31) ? 0 : ctx.pool + 1;
	    }
	  };

	  /**
	   * Collects an integer of n bits.
	   *
	   * @param i the integer entropy.
	   * @param n the number of bits in the integer.
	   */
	  ctx.collectInt = function(i, n) {
	    var bytes = '';
	    for(var x = 0; x < n; x += 8) {
	      bytes += String.fromCharCode((i >> x) & 0xFF);
	    }
	    ctx.collect(bytes);
	  };

	  /**
	   * Registers a Web Worker to receive immediate entropy from the main thread.
	   * This method is required until Web Workers can access the native crypto
	   * API. This method should be called twice for each created worker, once in
	   * the main thread, and once in the worker itself.
	   *
	   * @param worker the worker to register.
	   */
	  ctx.registerWorker = function(worker) {
	    // worker receives random bytes
	    if(worker === self) {
	      ctx.seedFile = function(needed, callback) {
	        function listener(e) {
	          var data = e.data;
	          if(data.forge && data.forge.prng) {
	            self.removeEventListener('message', listener);
	            callback(data.forge.prng.err, data.forge.prng.bytes);
	          }
	        }
	        self.addEventListener('message', listener);
	        self.postMessage({forge: {prng: {needed: needed}}});
	      };
	    } else {
	      // main thread sends random bytes upon request
	      var listener = function(e) {
	        var data = e.data;
	        if(data.forge && data.forge.prng) {
	          ctx.seedFile(data.forge.prng.needed, function(err, bytes) {
	            worker.postMessage({forge: {prng: {err: err, bytes: bytes}}});
	          });
	        }
	      };
	      // TODO: do we need to remove the event listener when the worker dies?
	      worker.addEventListener('message', listener);
	    }
	  };

	  return ctx;
	};
	});

	createCommonjsModule(function (module) {
	/**
	 * An API for getting cryptographically-secure random bytes. The bytes are
	 * generated using the Fortuna algorithm devised by Bruce Schneier and
	 * Niels Ferguson.
	 *
	 * Getting strong random bytes is not yet easy to do in javascript. The only
	 * truish random entropy that can be collected is from the mouse, keyboard, or
	 * from timing with respect to page loads, etc. This generator makes a poor
	 * attempt at providing random bytes when those sources haven't yet provided
	 * enough entropy to initially seed or to reseed the PRNG.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2009-2014 Digital Bazaar, Inc.
	 */






	(function() {

	// forge.random already defined
	if(forge.random && forge.random.getBytes) {
	  module.exports = forge.random;
	  return;
	}

	(function(jQuery) {

	// the default prng plugin, uses AES-128
	var prng_aes = {};
	var _prng_aes_output = new Array(4);
	var _prng_aes_buffer = forge.util.createBuffer();
	prng_aes.formatKey = function(key) {
	  // convert the key into 32-bit integers
	  var tmp = forge.util.createBuffer(key);
	  key = new Array(4);
	  key[0] = tmp.getInt32();
	  key[1] = tmp.getInt32();
	  key[2] = tmp.getInt32();
	  key[3] = tmp.getInt32();

	  // return the expanded key
	  return forge.aes._expandKey(key, false);
	};
	prng_aes.formatSeed = function(seed) {
	  // convert seed into 32-bit integers
	  var tmp = forge.util.createBuffer(seed);
	  seed = new Array(4);
	  seed[0] = tmp.getInt32();
	  seed[1] = tmp.getInt32();
	  seed[2] = tmp.getInt32();
	  seed[3] = tmp.getInt32();
	  return seed;
	};
	prng_aes.cipher = function(key, seed) {
	  forge.aes._updateBlock(key, seed, _prng_aes_output, false);
	  _prng_aes_buffer.putInt32(_prng_aes_output[0]);
	  _prng_aes_buffer.putInt32(_prng_aes_output[1]);
	  _prng_aes_buffer.putInt32(_prng_aes_output[2]);
	  _prng_aes_buffer.putInt32(_prng_aes_output[3]);
	  return _prng_aes_buffer.getBytes();
	};
	prng_aes.increment = function(seed) {
	  // FIXME: do we care about carry or signed issues?
	  ++seed[3];
	  return seed;
	};
	prng_aes.md = forge.md.sha256;

	/**
	 * Creates a new PRNG.
	 */
	function spawnPrng() {
	  var ctx = forge.prng.create(prng_aes);

	  /**
	   * Gets random bytes. If a native secure crypto API is unavailable, this
	   * method tries to make the bytes more unpredictable by drawing from data that
	   * can be collected from the user of the browser, eg: mouse movement.
	   *
	   * If a callback is given, this method will be called asynchronously.
	   *
	   * @param count the number of random bytes to get.
	   * @param [callback(err, bytes)] called once the operation completes.
	   *
	   * @return the random bytes in a string.
	   */
	  ctx.getBytes = function(count, callback) {
	    return ctx.generate(count, callback);
	  };

	  /**
	   * Gets random bytes asynchronously. If a native secure crypto API is
	   * unavailable, this method tries to make the bytes more unpredictable by
	   * drawing from data that can be collected from the user of the browser,
	   * eg: mouse movement.
	   *
	   * @param count the number of random bytes to get.
	   *
	   * @return the random bytes in a string.
	   */
	  ctx.getBytesSync = function(count) {
	    return ctx.generate(count);
	  };

	  return ctx;
	}

	// create default prng context
	var _ctx = spawnPrng();

	// add other sources of entropy only if window.crypto.getRandomValues is not
	// available -- otherwise this source will be automatically used by the prng
	var getRandomValues = null;
	var globalScope = forge.util.globalScope;
	var _crypto = globalScope.crypto || globalScope.msCrypto;
	if(_crypto && _crypto.getRandomValues) {
	  getRandomValues = function(arr) {
	    return _crypto.getRandomValues(arr);
	  };
	}

	if(forge.options.usePureJavaScript ||
	  (!forge.util.isNodejs && !getRandomValues)) {

	  // get load time entropy
	  _ctx.collectInt(+new Date(), 32);

	  // add some entropy from navigator object
	  if(typeof(navigator) !== 'undefined') {
	    var _navBytes = '';
	    for(var key in navigator) {
	      try {
	        if(typeof(navigator[key]) == 'string') {
	          _navBytes += navigator[key];
	        }
	      } catch(e) {
	        /* Some navigator keys might not be accessible, e.g. the geolocation
	          attribute throws an exception if touched in Mozilla chrome://
	          context.

	          Silently ignore this and just don't use this as a source of
	          entropy. */
	      }
	    }
	    _ctx.collect(_navBytes);
	    _navBytes = null;
	  }

	  // add mouse and keyboard collectors if jquery is available
	  if(jQuery) {
	    // set up mouse entropy capture
	    jQuery().mousemove(function(e) {
	      // add mouse coords
	      _ctx.collectInt(e.clientX, 16);
	      _ctx.collectInt(e.clientY, 16);
	    });

	    // set up keyboard entropy capture
	    jQuery().keypress(function(e) {
	      _ctx.collectInt(e.charCode, 8);
	    });
	  }
	}

	/* Random API */
	if(!forge.random) {
	  forge.random = _ctx;
	} else {
	  // extend forge.random with _ctx
	  for(var key in _ctx) {
	    forge.random[key] = _ctx[key];
	  }
	}

	// expose spawn PRNG
	forge.random.createInstance = spawnPrng;

	module.exports = forge.random;

	})(typeof(jQuery) !== 'undefined' ? jQuery : null);

	})();
	});

	/**
	 * RC2 implementation.
	 *
	 * @author Stefan Siegl
	 *
	 * Copyright (c) 2012 Stefan Siegl <stesie@brokenpipe.de>
	 *
	 * Information on the RC2 cipher is available from RFC #2268,
	 * http://www.ietf.org/rfc/rfc2268.txt
	 */



	var piTable = [
	  0xd9, 0x78, 0xf9, 0xc4, 0x19, 0xdd, 0xb5, 0xed, 0x28, 0xe9, 0xfd, 0x79, 0x4a, 0xa0, 0xd8, 0x9d,
	  0xc6, 0x7e, 0x37, 0x83, 0x2b, 0x76, 0x53, 0x8e, 0x62, 0x4c, 0x64, 0x88, 0x44, 0x8b, 0xfb, 0xa2,
	  0x17, 0x9a, 0x59, 0xf5, 0x87, 0xb3, 0x4f, 0x13, 0x61, 0x45, 0x6d, 0x8d, 0x09, 0x81, 0x7d, 0x32,
	  0xbd, 0x8f, 0x40, 0xeb, 0x86, 0xb7, 0x7b, 0x0b, 0xf0, 0x95, 0x21, 0x22, 0x5c, 0x6b, 0x4e, 0x82,
	  0x54, 0xd6, 0x65, 0x93, 0xce, 0x60, 0xb2, 0x1c, 0x73, 0x56, 0xc0, 0x14, 0xa7, 0x8c, 0xf1, 0xdc,
	  0x12, 0x75, 0xca, 0x1f, 0x3b, 0xbe, 0xe4, 0xd1, 0x42, 0x3d, 0xd4, 0x30, 0xa3, 0x3c, 0xb6, 0x26,
	  0x6f, 0xbf, 0x0e, 0xda, 0x46, 0x69, 0x07, 0x57, 0x27, 0xf2, 0x1d, 0x9b, 0xbc, 0x94, 0x43, 0x03,
	  0xf8, 0x11, 0xc7, 0xf6, 0x90, 0xef, 0x3e, 0xe7, 0x06, 0xc3, 0xd5, 0x2f, 0xc8, 0x66, 0x1e, 0xd7,
	  0x08, 0xe8, 0xea, 0xde, 0x80, 0x52, 0xee, 0xf7, 0x84, 0xaa, 0x72, 0xac, 0x35, 0x4d, 0x6a, 0x2a,
	  0x96, 0x1a, 0xd2, 0x71, 0x5a, 0x15, 0x49, 0x74, 0x4b, 0x9f, 0xd0, 0x5e, 0x04, 0x18, 0xa4, 0xec,
	  0xc2, 0xe0, 0x41, 0x6e, 0x0f, 0x51, 0xcb, 0xcc, 0x24, 0x91, 0xaf, 0x50, 0xa1, 0xf4, 0x70, 0x39,
	  0x99, 0x7c, 0x3a, 0x85, 0x23, 0xb8, 0xb4, 0x7a, 0xfc, 0x02, 0x36, 0x5b, 0x25, 0x55, 0x97, 0x31,
	  0x2d, 0x5d, 0xfa, 0x98, 0xe3, 0x8a, 0x92, 0xae, 0x05, 0xdf, 0x29, 0x10, 0x67, 0x6c, 0xba, 0xc9,
	  0xd3, 0x00, 0xe6, 0xcf, 0xe1, 0x9e, 0xa8, 0x2c, 0x63, 0x16, 0x01, 0x3f, 0x58, 0xe2, 0x89, 0xa9,
	  0x0d, 0x38, 0x34, 0x1b, 0xab, 0x33, 0xff, 0xb0, 0xbb, 0x48, 0x0c, 0x5f, 0xb9, 0xb1, 0xcd, 0x2e,
	  0xc5, 0xf3, 0xdb, 0x47, 0xe5, 0xa5, 0x9c, 0x77, 0x0a, 0xa6, 0x20, 0x68, 0xfe, 0x7f, 0xc1, 0xad
	];

	var s = [1, 2, 3, 5];

	/**
	 * Rotate a word left by given number of bits.
	 *
	 * Bits that are shifted out on the left are put back in on the right
	 * hand side.
	 *
	 * @param word The word to shift left.
	 * @param bits The number of bits to shift by.
	 * @return The rotated word.
	 */
	var rol = function(word, bits) {
	  return ((word << bits) & 0xffff) | ((word & 0xffff) >> (16 - bits));
	};

	/**
	 * Rotate a word right by given number of bits.
	 *
	 * Bits that are shifted out on the right are put back in on the left
	 * hand side.
	 *
	 * @param word The word to shift right.
	 * @param bits The number of bits to shift by.
	 * @return The rotated word.
	 */
	var ror = function(word, bits) {
	  return ((word & 0xffff) >> bits) | ((word << (16 - bits)) & 0xffff);
	};

	/* RC2 API */
	forge.rc2 = forge.rc2 || {};

	/**
	 * Perform RC2 key expansion as per RFC #2268, section 2.
	 *
	 * @param key variable-length user key (between 1 and 128 bytes)
	 * @param effKeyBits number of effective key bits (default: 128)
	 * @return the expanded RC2 key (ByteBuffer of 128 bytes)
	 */
	forge.rc2.expandKey = function(key, effKeyBits) {
	  if(typeof key === 'string') {
	    key = forge.util.createBuffer(key);
	  }
	  effKeyBits = effKeyBits || 128;

	  /* introduce variables that match the names used in RFC #2268 */
	  var L = key;
	  var T = key.length();
	  var T1 = effKeyBits;
	  var T8 = Math.ceil(T1 / 8);
	  var TM = 0xff >> (T1 & 0x07);
	  var i;

	  for(i = T; i < 128; i++) {
	    L.putByte(piTable[(L.at(i - 1) + L.at(i - T)) & 0xff]);
	  }

	  L.setAt(128 - T8, piTable[L.at(128 - T8) & TM]);

	  for(i = 127 - T8; i >= 0; i--) {
	    L.setAt(i, piTable[L.at(i + 1) ^ L.at(i + T8)]);
	  }

	  return L;
	};

	/**
	 * Creates a RC2 cipher object.
	 *
	 * @param key the symmetric key to use (as base for key generation).
	 * @param bits the number of effective key bits.
	 * @param encrypt false for decryption, true for encryption.
	 *
	 * @return the cipher.
	 */
	var createCipher = function(key, bits, encrypt) {
	  var _finish = false, _input = null, _output = null, _iv = null;
	  var mixRound, mashRound;
	  var i, j, K = [];

	  /* Expand key and fill into K[] Array */
	  key = forge.rc2.expandKey(key, bits);
	  for(i = 0; i < 64; i++) {
	    K.push(key.getInt16Le());
	  }

	  if(encrypt) {
	    /**
	     * Perform one mixing round "in place".
	     *
	     * @param R Array of four words to perform mixing on.
	     */
	    mixRound = function(R) {
	      for(i = 0; i < 4; i++) {
	        R[i] += K[j] + (R[(i + 3) % 4] & R[(i + 2) % 4]) +
	          ((~R[(i + 3) % 4]) & R[(i + 1) % 4]);
	        R[i] = rol(R[i], s[i]);
	        j++;
	      }
	    };

	    /**
	     * Perform one mashing round "in place".
	     *
	     * @param R Array of four words to perform mashing on.
	     */
	    mashRound = function(R) {
	      for(i = 0; i < 4; i++) {
	        R[i] += K[R[(i + 3) % 4] & 63];
	      }
	    };
	  } else {
	    /**
	     * Perform one r-mixing round "in place".
	     *
	     * @param R Array of four words to perform mixing on.
	     */
	    mixRound = function(R) {
	      for(i = 3; i >= 0; i--) {
	        R[i] = ror(R[i], s[i]);
	        R[i] -= K[j] + (R[(i + 3) % 4] & R[(i + 2) % 4]) +
	          ((~R[(i + 3) % 4]) & R[(i + 1) % 4]);
	        j--;
	      }
	    };

	    /**
	     * Perform one r-mashing round "in place".
	     *
	     * @param R Array of four words to perform mashing on.
	     */
	    mashRound = function(R) {
	      for(i = 3; i >= 0; i--) {
	        R[i] -= K[R[(i + 3) % 4] & 63];
	      }
	    };
	  }

	  /**
	   * Run the specified cipher execution plan.
	   *
	   * This function takes four words from the input buffer, applies the IV on
	   * it (if requested) and runs the provided execution plan.
	   *
	   * The plan must be put together in form of a array of arrays.  Where the
	   * outer one is simply a list of steps to perform and the inner one needs
	   * to have two elements: the first one telling how many rounds to perform,
	   * the second one telling what to do (i.e. the function to call).
	   *
	   * @param {Array} plan The plan to execute.
	   */
	  var runPlan = function(plan) {
	    var R = [];

	    /* Get data from input buffer and fill the four words into R */
	    for(i = 0; i < 4; i++) {
	      var val = _input.getInt16Le();

	      if(_iv !== null) {
	        if(encrypt) {
	          /* We're encrypting, apply the IV first. */
	          val ^= _iv.getInt16Le();
	        } else {
	          /* We're decryption, keep cipher text for next block. */
	          _iv.putInt16Le(val);
	        }
	      }

	      R.push(val & 0xffff);
	    }

	    /* Reset global "j" variable as per spec. */
	    j = encrypt ? 0 : 63;

	    /* Run execution plan. */
	    for(var ptr = 0; ptr < plan.length; ptr++) {
	      for(var ctr = 0; ctr < plan[ptr][0]; ctr++) {
	        plan[ptr][1](R);
	      }
	    }

	    /* Write back result to output buffer. */
	    for(i = 0; i < 4; i++) {
	      if(_iv !== null) {
	        if(encrypt) {
	          /* We're encrypting in CBC-mode, feed back encrypted bytes into
	             IV buffer to carry it forward to next block. */
	          _iv.putInt16Le(R[i]);
	        } else {
	          R[i] ^= _iv.getInt16Le();
	        }
	      }

	      _output.putInt16Le(R[i]);
	    }
	  };

	  /* Create cipher object */
	  var cipher = null;
	  cipher = {
	    /**
	     * Starts or restarts the encryption or decryption process, whichever
	     * was previously configured.
	     *
	     * To use the cipher in CBC mode, iv may be given either as a string
	     * of bytes, or as a byte buffer.  For ECB mode, give null as iv.
	     *
	     * @param iv the initialization vector to use, null for ECB mode.
	     * @param output the output the buffer to write to, null to create one.
	     */
	    start: function(iv, output) {
	      if(iv) {
	        /* CBC mode */
	        if(typeof iv === 'string') {
	          iv = forge.util.createBuffer(iv);
	        }
	      }

	      _finish = false;
	      _input = forge.util.createBuffer();
	      _output = output || new forge.util.createBuffer();
	      _iv = iv;

	      cipher.output = _output;
	    },

	    /**
	     * Updates the next block.
	     *
	     * @param input the buffer to read from.
	     */
	    update: function(input) {
	      if(!_finish) {
	        // not finishing, so fill the input buffer with more input
	        _input.putBuffer(input);
	      }

	      while(_input.length() >= 8) {
	        runPlan([
	            [ 5, mixRound ],
	            [ 1, mashRound ],
	            [ 6, mixRound ],
	            [ 1, mashRound ],
	            [ 5, mixRound ]
	          ]);
	      }
	    },

	    /**
	     * Finishes encrypting or decrypting.
	     *
	     * @param pad a padding function to use, null for PKCS#7 padding,
	     *           signature(blockSize, buffer, decrypt).
	     *
	     * @return true if successful, false on error.
	     */
	    finish: function(pad) {
	      var rval = true;

	      if(encrypt) {
	        if(pad) {
	          rval = pad(8, _input, !encrypt);
	        } else {
	          // add PKCS#7 padding to block (each pad byte is the
	          // value of the number of pad bytes)
	          var padding = (_input.length() === 8) ? 8 : (8 - _input.length());
	          _input.fillWithByte(padding, padding);
	        }
	      }

	      if(rval) {
	        // do final update
	        _finish = true;
	        cipher.update();
	      }

	      if(!encrypt) {
	        // check for error: input data not a multiple of block size
	        rval = (_input.length() === 0);
	        if(rval) {
	          if(pad) {
	            rval = pad(8, _output, !encrypt);
	          } else {
	            // ensure padding byte count is valid
	            var len = _output.length();
	            var count = _output.at(len - 1);

	            if(count > len) {
	              rval = false;
	            } else {
	              // trim off padding bytes
	              _output.truncate(count);
	            }
	          }
	        }
	      }

	      return rval;
	    }
	  };

	  return cipher;
	};

	/**
	 * Creates an RC2 cipher object to encrypt data in ECB or CBC mode using the
	 * given symmetric key. The output will be stored in the 'output' member
	 * of the returned cipher.
	 *
	 * The key and iv may be given as a string of bytes or a byte buffer.
	 * The cipher is initialized to use 128 effective key bits.
	 *
	 * @param key the symmetric key to use.
	 * @param iv the initialization vector to use.
	 * @param output the buffer to write to, null to create one.
	 *
	 * @return the cipher.
	 */
	forge.rc2.startEncrypting = function(key, iv, output) {
	  var cipher = forge.rc2.createEncryptionCipher(key, 128);
	  cipher.start(iv, output);
	  return cipher;
	};

	/**
	 * Creates an RC2 cipher object to encrypt data in ECB or CBC mode using the
	 * given symmetric key.
	 *
	 * The key may be given as a string of bytes or a byte buffer.
	 *
	 * To start encrypting call start() on the cipher with an iv and optional
	 * output buffer.
	 *
	 * @param key the symmetric key to use.
	 *
	 * @return the cipher.
	 */
	forge.rc2.createEncryptionCipher = function(key, bits) {
	  return createCipher(key, bits, true);
	};

	/**
	 * Creates an RC2 cipher object to decrypt data in ECB or CBC mode using the
	 * given symmetric key. The output will be stored in the 'output' member
	 * of the returned cipher.
	 *
	 * The key and iv may be given as a string of bytes or a byte buffer.
	 * The cipher is initialized to use 128 effective key bits.
	 *
	 * @param key the symmetric key to use.
	 * @param iv the initialization vector to use.
	 * @param output the buffer to write to, null to create one.
	 *
	 * @return the cipher.
	 */
	forge.rc2.startDecrypting = function(key, iv, output) {
	  var cipher = forge.rc2.createDecryptionCipher(key, 128);
	  cipher.start(iv, output);
	  return cipher;
	};

	/**
	 * Creates an RC2 cipher object to decrypt data in ECB or CBC mode using the
	 * given symmetric key.
	 *
	 * The key may be given as a string of bytes or a byte buffer.
	 *
	 * To start decrypting call start() on the cipher with an iv and optional
	 * output buffer.
	 *
	 * @param key the symmetric key to use.
	 *
	 * @return the cipher.
	 */
	forge.rc2.createDecryptionCipher = function(key, bits) {
	  return createCipher(key, bits, false);
	};

	// Copyright (c) 2005  Tom Wu
	// All Rights Reserved.
	// See "LICENSE" for details.

	// Basic JavaScript BN library - subset useful for RSA encryption.

	/*
	Licensing (LICENSE)
	-------------------

	This software is covered under the following copyright:
	*/
	/*
	 * Copyright (c) 2003-2005  Tom Wu
	 * All Rights Reserved.
	 *
	 * Permission is hereby granted, free of charge, to any person obtaining
	 * a copy of this software and associated documentation files (the
	 * "Software"), to deal in the Software without restriction, including
	 * without limitation the rights to use, copy, modify, merge, publish,
	 * distribute, sublicense, and/or sell copies of the Software, and to
	 * permit persons to whom the Software is furnished to do so, subject to
	 * the following conditions:
	 *
	 * The above copyright notice and this permission notice shall be
	 * included in all copies or substantial portions of the Software.
	 *
	 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
	 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
	 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
	 *
	 * IN NO EVENT SHALL TOM WU BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
	 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
	 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
	 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
	 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
	 *
	 * In addition, the following condition applies:
	 *
	 * All redistributions must retain an intact copy of this copyright notice
	 * and disclaimer.
	 */
	/*
	Address all questions regarding this license to:

	  Tom Wu
	  tjw@cs.Stanford.EDU
	*/


	forge.jsbn = forge.jsbn || {};

	// Bits per digit
	var dbits;

	// (public) Constructor
	function BigInteger$5(a,b,c) {
	  this.data = [];
	  if(a != null)
	    if("number" == typeof a) this.fromNumber(a,b,c);
	    else if(b == null && "string" != typeof a) this.fromString(a,256);
	    else this.fromString(a,b);
	}
	forge.jsbn.BigInteger = BigInteger$5;

	// return new, unset BigInteger
	function nbi() { return new BigInteger$5(null); }

	// am: Compute w_j += (x*this_i), propagate carries,
	// c is initial carry, returns final carry.
	// c < 3*dvalue, x < 2*dvalue, this_i < dvalue
	// We need to select the fastest one that works in this environment.

	// am1: use a single mult and divide to get the high bits,
	// max digit bits should be 26 because
	// max internal value = 2*dvalue^2-2*dvalue (< 2^53)
	function am1(i,x,w,j,c,n) {
	  while(--n >= 0) {
	    var v = x*this.data[i++]+w.data[j]+c;
	    c = Math.floor(v/0x4000000);
	    w.data[j++] = v&0x3ffffff;
	  }
	  return c;
	}
	// am2 avoids a big mult-and-extract completely.
	// Max digit bits should be <= 30 because we do bitwise ops
	// on values up to 2*hdvalue^2-hdvalue-1 (< 2^31)
	function am2(i,x,w,j,c,n) {
	  var xl = x&0x7fff, xh = x>>15;
	  while(--n >= 0) {
	    var l = this.data[i]&0x7fff;
	    var h = this.data[i++]>>15;
	    var m = xh*l+h*xl;
	    l = xl*l+((m&0x7fff)<<15)+w.data[j]+(c&0x3fffffff);
	    c = (l>>>30)+(m>>>15)+xh*h+(c>>>30);
	    w.data[j++] = l&0x3fffffff;
	  }
	  return c;
	}
	// Alternately, set max digit bits to 28 since some
	// browsers slow down when dealing with 32-bit numbers.
	function am3(i,x,w,j,c,n) {
	  var xl = x&0x3fff, xh = x>>14;
	  while(--n >= 0) {
	    var l = this.data[i]&0x3fff;
	    var h = this.data[i++]>>14;
	    var m = xh*l+h*xl;
	    l = xl*l+((m&0x3fff)<<14)+w.data[j]+c;
	    c = (l>>28)+(m>>14)+xh*h;
	    w.data[j++] = l&0xfffffff;
	  }
	  return c;
	}

	// node.js (no browser)
	if(typeof(navigator) === 'undefined')
	{
	   BigInteger$5.prototype.am = am3;
	   dbits = 28;
	} else if((navigator.appName == "Microsoft Internet Explorer")) {
	  BigInteger$5.prototype.am = am2;
	  dbits = 30;
	} else if((navigator.appName != "Netscape")) {
	  BigInteger$5.prototype.am = am1;
	  dbits = 26;
	} else { // Mozilla/Netscape seems to prefer am3
	  BigInteger$5.prototype.am = am3;
	  dbits = 28;
	}

	BigInteger$5.prototype.DB = dbits;
	BigInteger$5.prototype.DM = ((1<<dbits)-1);
	BigInteger$5.prototype.DV = (1<<dbits);

	var BI_FP = 52;
	BigInteger$5.prototype.FV = Math.pow(2,BI_FP);
	BigInteger$5.prototype.F1 = BI_FP-dbits;
	BigInteger$5.prototype.F2 = 2*dbits-BI_FP;

	// Digit conversions
	var BI_RM = "0123456789abcdefghijklmnopqrstuvwxyz";
	var BI_RC = new Array();
	var rr,vv;
	rr = "0".charCodeAt(0);
	for(vv = 0; vv <= 9; ++vv) BI_RC[rr++] = vv;
	rr = "a".charCodeAt(0);
	for(vv = 10; vv < 36; ++vv) BI_RC[rr++] = vv;
	rr = "A".charCodeAt(0);
	for(vv = 10; vv < 36; ++vv) BI_RC[rr++] = vv;

	function int2char(n) { return BI_RM.charAt(n); }
	function intAt(s,i) {
	  var c = BI_RC[s.charCodeAt(i)];
	  return (c==null)?-1:c;
	}

	// (protected) copy this to r
	function bnpCopyTo(r) {
	  for(var i = this.t-1; i >= 0; --i) r.data[i] = this.data[i];
	  r.t = this.t;
	  r.s = this.s;
	}

	// (protected) set from integer value x, -DV <= x < DV
	function bnpFromInt(x) {
	  this.t = 1;
	  this.s = (x<0)?-1:0;
	  if(x > 0) this.data[0] = x;
	  else if(x < -1) this.data[0] = x+this.DV;
	  else this.t = 0;
	}

	// return bigint initialized to value
	function nbv(i) { var r = nbi(); r.fromInt(i); return r; }

	// (protected) set from string and radix
	function bnpFromString(s,b) {
	  var k;
	  if(b == 16) k = 4;
	  else if(b == 8) k = 3;
	  else if(b == 256) k = 8; // byte array
	  else if(b == 2) k = 1;
	  else if(b == 32) k = 5;
	  else if(b == 4) k = 2;
	  else { this.fromRadix(s,b); return; }
	  this.t = 0;
	  this.s = 0;
	  var i = s.length, mi = false, sh = 0;
	  while(--i >= 0) {
	    var x = (k==8)?s[i]&0xff:intAt(s,i);
	    if(x < 0) {
	      if(s.charAt(i) == "-") mi = true;
	      continue;
	    }
	    mi = false;
	    if(sh == 0)
	      this.data[this.t++] = x;
	    else if(sh+k > this.DB) {
	      this.data[this.t-1] |= (x&((1<<(this.DB-sh))-1))<<sh;
	      this.data[this.t++] = (x>>(this.DB-sh));
	    } else
	      this.data[this.t-1] |= x<<sh;
	    sh += k;
	    if(sh >= this.DB) sh -= this.DB;
	  }
	  if(k == 8 && (s[0]&0x80) != 0) {
	    this.s = -1;
	    if(sh > 0) this.data[this.t-1] |= ((1<<(this.DB-sh))-1)<<sh;
	  }
	  this.clamp();
	  if(mi) BigInteger$5.ZERO.subTo(this,this);
	}

	// (protected) clamp off excess high words
	function bnpClamp() {
	  var c = this.s&this.DM;
	  while(this.t > 0 && this.data[this.t-1] == c) --this.t;
	}

	// (public) return string representation in given radix
	function bnToString(b) {
	  if(this.s < 0) return "-"+this.negate().toString(b);
	  var k;
	  if(b == 16) k = 4;
	  else if(b == 8) k = 3;
	  else if(b == 2) k = 1;
	  else if(b == 32) k = 5;
	  else if(b == 4) k = 2;
	  else return this.toRadix(b);
	  var km = (1<<k)-1, d, m = false, r = "", i = this.t;
	  var p = this.DB-(i*this.DB)%k;
	  if(i-- > 0) {
	    if(p < this.DB && (d = this.data[i]>>p) > 0) { m = true; r = int2char(d); }
	    while(i >= 0) {
	      if(p < k) {
	        d = (this.data[i]&((1<<p)-1))<<(k-p);
	        d |= this.data[--i]>>(p+=this.DB-k);
	      } else {
	        d = (this.data[i]>>(p-=k))&km;
	        if(p <= 0) { p += this.DB; --i; }
	      }
	      if(d > 0) m = true;
	      if(m) r += int2char(d);
	    }
	  }
	  return m?r:"0";
	}

	// (public) -this
	function bnNegate() { var r = nbi(); BigInteger$5.ZERO.subTo(this,r); return r; }

	// (public) |this|
	function bnAbs() { return (this.s<0)?this.negate():this; }

	// (public) return + if this > a, - if this < a, 0 if equal
	function bnCompareTo(a) {
	  var r = this.s-a.s;
	  if(r != 0) return r;
	  var i = this.t;
	  r = i-a.t;
	  if(r != 0) return (this.s<0)?-r:r;
	  while(--i >= 0) if((r=this.data[i]-a.data[i]) != 0) return r;
	  return 0;
	}

	// returns bit length of the integer x
	function nbits(x) {
	  var r = 1, t;
	  if((t=x>>>16) != 0) { x = t; r += 16; }
	  if((t=x>>8) != 0) { x = t; r += 8; }
	  if((t=x>>4) != 0) { x = t; r += 4; }
	  if((t=x>>2) != 0) { x = t; r += 2; }
	  if((t=x>>1) != 0) { x = t; r += 1; }
	  return r;
	}

	// (public) return the number of bits in "this"
	function bnBitLength() {
	  if(this.t <= 0) return 0;
	  return this.DB*(this.t-1)+nbits(this.data[this.t-1]^(this.s&this.DM));
	}

	// (protected) r = this << n*DB
	function bnpDLShiftTo(n,r) {
	  var i;
	  for(i = this.t-1; i >= 0; --i) r.data[i+n] = this.data[i];
	  for(i = n-1; i >= 0; --i) r.data[i] = 0;
	  r.t = this.t+n;
	  r.s = this.s;
	}

	// (protected) r = this >> n*DB
	function bnpDRShiftTo(n,r) {
	  for(var i = n; i < this.t; ++i) r.data[i-n] = this.data[i];
	  r.t = Math.max(this.t-n,0);
	  r.s = this.s;
	}

	// (protected) r = this << n
	function bnpLShiftTo(n,r) {
	  var bs = n%this.DB;
	  var cbs = this.DB-bs;
	  var bm = (1<<cbs)-1;
	  var ds = Math.floor(n/this.DB), c = (this.s<<bs)&this.DM, i;
	  for(i = this.t-1; i >= 0; --i) {
	    r.data[i+ds+1] = (this.data[i]>>cbs)|c;
	    c = (this.data[i]&bm)<<bs;
	  }
	  for(i = ds-1; i >= 0; --i) r.data[i] = 0;
	  r.data[ds] = c;
	  r.t = this.t+ds+1;
	  r.s = this.s;
	  r.clamp();
	}

	// (protected) r = this >> n
	function bnpRShiftTo(n,r) {
	  r.s = this.s;
	  var ds = Math.floor(n/this.DB);
	  if(ds >= this.t) { r.t = 0; return; }
	  var bs = n%this.DB;
	  var cbs = this.DB-bs;
	  var bm = (1<<bs)-1;
	  r.data[0] = this.data[ds]>>bs;
	  for(var i = ds+1; i < this.t; ++i) {
	    r.data[i-ds-1] |= (this.data[i]&bm)<<cbs;
	    r.data[i-ds] = this.data[i]>>bs;
	  }
	  if(bs > 0) r.data[this.t-ds-1] |= (this.s&bm)<<cbs;
	  r.t = this.t-ds;
	  r.clamp();
	}

	// (protected) r = this - a
	function bnpSubTo(a,r) {
	  var i = 0, c = 0, m = Math.min(a.t,this.t);
	  while(i < m) {
	    c += this.data[i]-a.data[i];
	    r.data[i++] = c&this.DM;
	    c >>= this.DB;
	  }
	  if(a.t < this.t) {
	    c -= a.s;
	    while(i < this.t) {
	      c += this.data[i];
	      r.data[i++] = c&this.DM;
	      c >>= this.DB;
	    }
	    c += this.s;
	  } else {
	    c += this.s;
	    while(i < a.t) {
	      c -= a.data[i];
	      r.data[i++] = c&this.DM;
	      c >>= this.DB;
	    }
	    c -= a.s;
	  }
	  r.s = (c<0)?-1:0;
	  if(c < -1) r.data[i++] = this.DV+c;
	  else if(c > 0) r.data[i++] = c;
	  r.t = i;
	  r.clamp();
	}

	// (protected) r = this * a, r != this,a (HAC 14.12)
	// "this" should be the larger one if appropriate.
	function bnpMultiplyTo(a,r) {
	  var x = this.abs(), y = a.abs();
	  var i = x.t;
	  r.t = i+y.t;
	  while(--i >= 0) r.data[i] = 0;
	  for(i = 0; i < y.t; ++i) r.data[i+x.t] = x.am(0,y.data[i],r,i,0,x.t);
	  r.s = 0;
	  r.clamp();
	  if(this.s != a.s) BigInteger$5.ZERO.subTo(r,r);
	}

	// (protected) r = this^2, r != this (HAC 14.16)
	function bnpSquareTo(r) {
	  var x = this.abs();
	  var i = r.t = 2*x.t;
	  while(--i >= 0) r.data[i] = 0;
	  for(i = 0; i < x.t-1; ++i) {
	    var c = x.am(i,x.data[i],r,2*i,0,1);
	    if((r.data[i+x.t]+=x.am(i+1,2*x.data[i],r,2*i+1,c,x.t-i-1)) >= x.DV) {
	      r.data[i+x.t] -= x.DV;
	      r.data[i+x.t+1] = 1;
	    }
	  }
	  if(r.t > 0) r.data[r.t-1] += x.am(i,x.data[i],r,2*i,0,1);
	  r.s = 0;
	  r.clamp();
	}

	// (protected) divide this by m, quotient and remainder to q, r (HAC 14.20)
	// r != q, this != m.  q or r may be null.
	function bnpDivRemTo(m,q,r) {
	  var pm = m.abs();
	  if(pm.t <= 0) return;
	  var pt = this.abs();
	  if(pt.t < pm.t) {
	    if(q != null) q.fromInt(0);
	    if(r != null) this.copyTo(r);
	    return;
	  }
	  if(r == null) r = nbi();
	  var y = nbi(), ts = this.s, ms = m.s;
	  var nsh = this.DB-nbits(pm.data[pm.t-1]);	// normalize modulus
	  if(nsh > 0) { pm.lShiftTo(nsh,y); pt.lShiftTo(nsh,r); } else { pm.copyTo(y); pt.copyTo(r); }
	  var ys = y.t;
	  var y0 = y.data[ys-1];
	  if(y0 == 0) return;
	  var yt = y0*(1<<this.F1)+((ys>1)?y.data[ys-2]>>this.F2:0);
	  var d1 = this.FV/yt, d2 = (1<<this.F1)/yt, e = 1<<this.F2;
	  var i = r.t, j = i-ys, t = (q==null)?nbi():q;
	  y.dlShiftTo(j,t);
	  if(r.compareTo(t) >= 0) {
	    r.data[r.t++] = 1;
	    r.subTo(t,r);
	  }
	  BigInteger$5.ONE.dlShiftTo(ys,t);
	  t.subTo(y,y);	// "negative" y so we can replace sub with am later
	  while(y.t < ys) y.data[y.t++] = 0;
	  while(--j >= 0) {
	    // Estimate quotient digit
	    var qd = (r.data[--i]==y0)?this.DM:Math.floor(r.data[i]*d1+(r.data[i-1]+e)*d2);
	    if((r.data[i]+=y.am(0,qd,r,j,0,ys)) < qd) {	// Try it out
	      y.dlShiftTo(j,t);
	      r.subTo(t,r);
	      while(r.data[i] < --qd) r.subTo(t,r);
	    }
	  }
	  if(q != null) {
	    r.drShiftTo(ys,q);
	    if(ts != ms) BigInteger$5.ZERO.subTo(q,q);
	  }
	  r.t = ys;
	  r.clamp();
	  if(nsh > 0) r.rShiftTo(nsh,r);	// Denormalize remainder
	  if(ts < 0) BigInteger$5.ZERO.subTo(r,r);
	}

	// (public) this mod a
	function bnMod(a) {
	  var r = nbi();
	  this.abs().divRemTo(a,null,r);
	  if(this.s < 0 && r.compareTo(BigInteger$5.ZERO) > 0) a.subTo(r,r);
	  return r;
	}

	// Modular reduction using "classic" algorithm
	function Classic(m) { this.m = m; }
	function cConvert(x) {
	  if(x.s < 0 || x.compareTo(this.m) >= 0) return x.mod(this.m);
	  else return x;
	}
	function cRevert(x) { return x; }
	function cReduce(x) { x.divRemTo(this.m,null,x); }
	function cMulTo(x,y,r) { x.multiplyTo(y,r); this.reduce(r); }
	function cSqrTo(x,r) { x.squareTo(r); this.reduce(r); }

	Classic.prototype.convert = cConvert;
	Classic.prototype.revert = cRevert;
	Classic.prototype.reduce = cReduce;
	Classic.prototype.mulTo = cMulTo;
	Classic.prototype.sqrTo = cSqrTo;

	// (protected) return "-1/this % 2^DB"; useful for Mont. reduction
	// justification:
	//         xy == 1 (mod m)
	//         xy =  1+km
	//   xy(2-xy) = (1+km)(1-km)
	// x[y(2-xy)] = 1-k^2m^2
	// x[y(2-xy)] == 1 (mod m^2)
	// if y is 1/x mod m, then y(2-xy) is 1/x mod m^2
	// should reduce x and y(2-xy) by m^2 at each step to keep size bounded.
	// JS multiply "overflows" differently from C/C++, so care is needed here.
	function bnpInvDigit() {
	  if(this.t < 1) return 0;
	  var x = this.data[0];
	  if((x&1) == 0) return 0;
	  var y = x&3;		// y == 1/x mod 2^2
	  y = (y*(2-(x&0xf)*y))&0xf;	// y == 1/x mod 2^4
	  y = (y*(2-(x&0xff)*y))&0xff;	// y == 1/x mod 2^8
	  y = (y*(2-(((x&0xffff)*y)&0xffff)))&0xffff;	// y == 1/x mod 2^16
	  // last step - calculate inverse mod DV directly;
	  // assumes 16 < DB <= 32 and assumes ability to handle 48-bit ints
	  y = (y*(2-x*y%this.DV))%this.DV;		// y == 1/x mod 2^dbits
	  // we really want the negative inverse, and -DV < y < DV
	  return (y>0)?this.DV-y:-y;
	}

	// Montgomery reduction
	function Montgomery(m) {
	  this.m = m;
	  this.mp = m.invDigit();
	  this.mpl = this.mp&0x7fff;
	  this.mph = this.mp>>15;
	  this.um = (1<<(m.DB-15))-1;
	  this.mt2 = 2*m.t;
	}

	// xR mod m
	function montConvert(x) {
	  var r = nbi();
	  x.abs().dlShiftTo(this.m.t,r);
	  r.divRemTo(this.m,null,r);
	  if(x.s < 0 && r.compareTo(BigInteger$5.ZERO) > 0) this.m.subTo(r,r);
	  return r;
	}

	// x/R mod m
	function montRevert(x) {
	  var r = nbi();
	  x.copyTo(r);
	  this.reduce(r);
	  return r;
	}

	// x = x/R mod m (HAC 14.32)
	function montReduce(x) {
	  while(x.t <= this.mt2)	// pad x so am has enough room later
	    x.data[x.t++] = 0;
	  for(var i = 0; i < this.m.t; ++i) {
	    // faster way of calculating u0 = x.data[i]*mp mod DV
	    var j = x.data[i]&0x7fff;
	    var u0 = (j*this.mpl+(((j*this.mph+(x.data[i]>>15)*this.mpl)&this.um)<<15))&x.DM;
	    // use am to combine the multiply-shift-add into one call
	    j = i+this.m.t;
	    x.data[j] += this.m.am(0,u0,x,i,0,this.m.t);
	    // propagate carry
	    while(x.data[j] >= x.DV) { x.data[j] -= x.DV; x.data[++j]++; }
	  }
	  x.clamp();
	  x.drShiftTo(this.m.t,x);
	  if(x.compareTo(this.m) >= 0) x.subTo(this.m,x);
	}

	// r = "x^2/R mod m"; x != r
	function montSqrTo(x,r) { x.squareTo(r); this.reduce(r); }

	// r = "xy/R mod m"; x,y != r
	function montMulTo(x,y,r) { x.multiplyTo(y,r); this.reduce(r); }

	Montgomery.prototype.convert = montConvert;
	Montgomery.prototype.revert = montRevert;
	Montgomery.prototype.reduce = montReduce;
	Montgomery.prototype.mulTo = montMulTo;
	Montgomery.prototype.sqrTo = montSqrTo;

	// (protected) true iff this is even
	function bnpIsEven() { return ((this.t>0)?(this.data[0]&1):this.s) == 0; }

	// (protected) this^e, e < 2^32, doing sqr and mul with "r" (HAC 14.79)
	function bnpExp(e,z) {
	  if(e > 0xffffffff || e < 1) return BigInteger$5.ONE;
	  var r = nbi(), r2 = nbi(), g = z.convert(this), i = nbits(e)-1;
	  g.copyTo(r);
	  while(--i >= 0) {
	    z.sqrTo(r,r2);
	    if((e&(1<<i)) > 0) z.mulTo(r2,g,r);
	    else { var t = r; r = r2; r2 = t; }
	  }
	  return z.revert(r);
	}

	// (public) this^e % m, 0 <= e < 2^32
	function bnModPowInt(e,m) {
	  var z;
	  if(e < 256 || m.isEven()) z = new Classic(m); else z = new Montgomery(m);
	  return this.exp(e,z);
	}

	// protected
	BigInteger$5.prototype.copyTo = bnpCopyTo;
	BigInteger$5.prototype.fromInt = bnpFromInt;
	BigInteger$5.prototype.fromString = bnpFromString;
	BigInteger$5.prototype.clamp = bnpClamp;
	BigInteger$5.prototype.dlShiftTo = bnpDLShiftTo;
	BigInteger$5.prototype.drShiftTo = bnpDRShiftTo;
	BigInteger$5.prototype.lShiftTo = bnpLShiftTo;
	BigInteger$5.prototype.rShiftTo = bnpRShiftTo;
	BigInteger$5.prototype.subTo = bnpSubTo;
	BigInteger$5.prototype.multiplyTo = bnpMultiplyTo;
	BigInteger$5.prototype.squareTo = bnpSquareTo;
	BigInteger$5.prototype.divRemTo = bnpDivRemTo;
	BigInteger$5.prototype.invDigit = bnpInvDigit;
	BigInteger$5.prototype.isEven = bnpIsEven;
	BigInteger$5.prototype.exp = bnpExp;

	// public
	BigInteger$5.prototype.toString = bnToString;
	BigInteger$5.prototype.negate = bnNegate;
	BigInteger$5.prototype.abs = bnAbs;
	BigInteger$5.prototype.compareTo = bnCompareTo;
	BigInteger$5.prototype.bitLength = bnBitLength;
	BigInteger$5.prototype.mod = bnMod;
	BigInteger$5.prototype.modPowInt = bnModPowInt;

	// "constants"
	BigInteger$5.ZERO = nbv(0);
	BigInteger$5.ONE = nbv(1);

	// jsbn2 lib

	//Copyright (c) 2005-2009  Tom Wu
	//All Rights Reserved.
	//See "LICENSE" for details (See jsbn.js for LICENSE).

	//Extended JavaScript BN functions, required for RSA private ops.

	//Version 1.1: new BigInteger("0", 10) returns "proper" zero

	//(public)
	function bnClone() { var r = nbi(); this.copyTo(r); return r; }

	//(public) return value as integer
	function bnIntValue() {
	if(this.s < 0) {
	 if(this.t == 1) return this.data[0]-this.DV;
	 else if(this.t == 0) return -1;
	} else if(this.t == 1) return this.data[0];
	else if(this.t == 0) return 0;
	// assumes 16 < DB < 32
	return ((this.data[1]&((1<<(32-this.DB))-1))<<this.DB)|this.data[0];
	}

	//(public) return value as byte
	function bnByteValue() { return (this.t==0)?this.s:(this.data[0]<<24)>>24; }

	//(public) return value as short (assumes DB>=16)
	function bnShortValue() { return (this.t==0)?this.s:(this.data[0]<<16)>>16; }

	//(protected) return x s.t. r^x < DV
	function bnpChunkSize(r) { return Math.floor(Math.LN2*this.DB/Math.log(r)); }

	//(public) 0 if this == 0, 1 if this > 0
	function bnSigNum() {
	if(this.s < 0) return -1;
	else if(this.t <= 0 || (this.t == 1 && this.data[0] <= 0)) return 0;
	else return 1;
	}

	//(protected) convert to radix string
	function bnpToRadix(b) {
	if(b == null) b = 10;
	if(this.signum() == 0 || b < 2 || b > 36) return "0";
	var cs = this.chunkSize(b);
	var a = Math.pow(b,cs);
	var d = nbv(a), y = nbi(), z = nbi(), r = "";
	this.divRemTo(d,y,z);
	while(y.signum() > 0) {
	 r = (a+z.intValue()).toString(b).substr(1) + r;
	 y.divRemTo(d,y,z);
	}
	return z.intValue().toString(b) + r;
	}

	//(protected) convert from radix string
	function bnpFromRadix(s,b) {
	this.fromInt(0);
	if(b == null) b = 10;
	var cs = this.chunkSize(b);
	var d = Math.pow(b,cs), mi = false, j = 0, w = 0;
	for(var i = 0; i < s.length; ++i) {
	 var x = intAt(s,i);
	 if(x < 0) {
	   if(s.charAt(i) == "-" && this.signum() == 0) mi = true;
	   continue;
	 }
	 w = b*w+x;
	 if(++j >= cs) {
	   this.dMultiply(d);
	   this.dAddOffset(w,0);
	   j = 0;
	   w = 0;
	 }
	}
	if(j > 0) {
	 this.dMultiply(Math.pow(b,j));
	 this.dAddOffset(w,0);
	}
	if(mi) BigInteger$5.ZERO.subTo(this,this);
	}

	//(protected) alternate constructor
	function bnpFromNumber(a,b,c) {
	if("number" == typeof b) {
	 // new BigInteger(int,int,RNG)
	 if(a < 2) this.fromInt(1);
	 else {
	   this.fromNumber(a,c);
	   if(!this.testBit(a-1))  // force MSB set
	     this.bitwiseTo(BigInteger$5.ONE.shiftLeft(a-1),op_or,this);
	   if(this.isEven()) this.dAddOffset(1,0); // force odd
	   while(!this.isProbablePrime(b)) {
	     this.dAddOffset(2,0);
	     if(this.bitLength() > a) this.subTo(BigInteger$5.ONE.shiftLeft(a-1),this);
	   }
	 }
	} else {
	 // new BigInteger(int,RNG)
	 var x = new Array(), t = a&7;
	 x.length = (a>>3)+1;
	 b.nextBytes(x);
	 if(t > 0) x[0] &= ((1<<t)-1); else x[0] = 0;
	 this.fromString(x,256);
	}
	}

	//(public) convert to bigendian byte array
	function bnToByteArray() {
	var i = this.t, r = new Array();
	r[0] = this.s;
	var p = this.DB-(i*this.DB)%8, d, k = 0;
	if(i-- > 0) {
	 if(p < this.DB && (d = this.data[i]>>p) != (this.s&this.DM)>>p)
	   r[k++] = d|(this.s<<(this.DB-p));
	 while(i >= 0) {
	   if(p < 8) {
	     d = (this.data[i]&((1<<p)-1))<<(8-p);
	     d |= this.data[--i]>>(p+=this.DB-8);
	   } else {
	     d = (this.data[i]>>(p-=8))&0xff;
	     if(p <= 0) { p += this.DB; --i; }
	   }
	   if((d&0x80) != 0) d |= -256;
	   if(k == 0 && (this.s&0x80) != (d&0x80)) ++k;
	   if(k > 0 || d != this.s) r[k++] = d;
	 }
	}
	return r;
	}

	function bnEquals(a) { return(this.compareTo(a)==0); }
	function bnMin(a) { return (this.compareTo(a)<0)?this:a; }
	function bnMax(a) { return (this.compareTo(a)>0)?this:a; }

	//(protected) r = this op a (bitwise)
	function bnpBitwiseTo(a,op,r) {
	var i, f, m = Math.min(a.t,this.t);
	for(i = 0; i < m; ++i) r.data[i] = op(this.data[i],a.data[i]);
	if(a.t < this.t) {
	 f = a.s&this.DM;
	 for(i = m; i < this.t; ++i) r.data[i] = op(this.data[i],f);
	 r.t = this.t;
	} else {
	 f = this.s&this.DM;
	 for(i = m; i < a.t; ++i) r.data[i] = op(f,a.data[i]);
	 r.t = a.t;
	}
	r.s = op(this.s,a.s);
	r.clamp();
	}

	//(public) this & a
	function op_and(x,y) { return x&y; }
	function bnAnd(a) { var r = nbi(); this.bitwiseTo(a,op_and,r); return r; }

	//(public) this | a
	function op_or(x,y) { return x|y; }
	function bnOr(a) { var r = nbi(); this.bitwiseTo(a,op_or,r); return r; }

	//(public) this ^ a
	function op_xor(x,y) { return x^y; }
	function bnXor(a) { var r = nbi(); this.bitwiseTo(a,op_xor,r); return r; }

	//(public) this & ~a
	function op_andnot(x,y) { return x&~y; }
	function bnAndNot(a) { var r = nbi(); this.bitwiseTo(a,op_andnot,r); return r; }

	//(public) ~this
	function bnNot() {
	var r = nbi();
	for(var i = 0; i < this.t; ++i) r.data[i] = this.DM&~this.data[i];
	r.t = this.t;
	r.s = ~this.s;
	return r;
	}

	//(public) this << n
	function bnShiftLeft(n) {
	var r = nbi();
	if(n < 0) this.rShiftTo(-n,r); else this.lShiftTo(n,r);
	return r;
	}

	//(public) this >> n
	function bnShiftRight(n) {
	var r = nbi();
	if(n < 0) this.lShiftTo(-n,r); else this.rShiftTo(n,r);
	return r;
	}

	//return index of lowest 1-bit in x, x < 2^31
	function lbit(x) {
	if(x == 0) return -1;
	var r = 0;
	if((x&0xffff) == 0) { x >>= 16; r += 16; }
	if((x&0xff) == 0) { x >>= 8; r += 8; }
	if((x&0xf) == 0) { x >>= 4; r += 4; }
	if((x&3) == 0) { x >>= 2; r += 2; }
	if((x&1) == 0) ++r;
	return r;
	}

	//(public) returns index of lowest 1-bit (or -1 if none)
	function bnGetLowestSetBit() {
	for(var i = 0; i < this.t; ++i)
	 if(this.data[i] != 0) return i*this.DB+lbit(this.data[i]);
	if(this.s < 0) return this.t*this.DB;
	return -1;
	}

	//return number of 1 bits in x
	function cbit(x) {
	var r = 0;
	while(x != 0) { x &= x-1; ++r; }
	return r;
	}

	//(public) return number of set bits
	function bnBitCount() {
	var r = 0, x = this.s&this.DM;
	for(var i = 0; i < this.t; ++i) r += cbit(this.data[i]^x);
	return r;
	}

	//(public) true iff nth bit is set
	function bnTestBit(n) {
	var j = Math.floor(n/this.DB);
	if(j >= this.t) return(this.s!=0);
	return((this.data[j]&(1<<(n%this.DB)))!=0);
	}

	//(protected) this op (1<<n)
	function bnpChangeBit(n,op) {
	var r = BigInteger$5.ONE.shiftLeft(n);
	this.bitwiseTo(r,op,r);
	return r;
	}

	//(public) this | (1<<n)
	function bnSetBit(n) { return this.changeBit(n,op_or); }

	//(public) this & ~(1<<n)
	function bnClearBit(n) { return this.changeBit(n,op_andnot); }

	//(public) this ^ (1<<n)
	function bnFlipBit(n) { return this.changeBit(n,op_xor); }

	//(protected) r = this + a
	function bnpAddTo(a,r) {
	var i = 0, c = 0, m = Math.min(a.t,this.t);
	while(i < m) {
	 c += this.data[i]+a.data[i];
	 r.data[i++] = c&this.DM;
	 c >>= this.DB;
	}
	if(a.t < this.t) {
	 c += a.s;
	 while(i < this.t) {
	   c += this.data[i];
	   r.data[i++] = c&this.DM;
	   c >>= this.DB;
	 }
	 c += this.s;
	} else {
	 c += this.s;
	 while(i < a.t) {
	   c += a.data[i];
	   r.data[i++] = c&this.DM;
	   c >>= this.DB;
	 }
	 c += a.s;
	}
	r.s = (c<0)?-1:0;
	if(c > 0) r.data[i++] = c;
	else if(c < -1) r.data[i++] = this.DV+c;
	r.t = i;
	r.clamp();
	}

	//(public) this + a
	function bnAdd(a) { var r = nbi(); this.addTo(a,r); return r; }

	//(public) this - a
	function bnSubtract(a) { var r = nbi(); this.subTo(a,r); return r; }

	//(public) this * a
	function bnMultiply(a) { var r = nbi(); this.multiplyTo(a,r); return r; }

	//(public) this / a
	function bnDivide(a) { var r = nbi(); this.divRemTo(a,r,null); return r; }

	//(public) this % a
	function bnRemainder(a) { var r = nbi(); this.divRemTo(a,null,r); return r; }

	//(public) [this/a,this%a]
	function bnDivideAndRemainder(a) {
	var q = nbi(), r = nbi();
	this.divRemTo(a,q,r);
	return new Array(q,r);
	}

	//(protected) this *= n, this >= 0, 1 < n < DV
	function bnpDMultiply(n) {
	this.data[this.t] = this.am(0,n-1,this,0,0,this.t);
	++this.t;
	this.clamp();
	}

	//(protected) this += n << w words, this >= 0
	function bnpDAddOffset(n,w) {
	if(n == 0) return;
	while(this.t <= w) this.data[this.t++] = 0;
	this.data[w] += n;
	while(this.data[w] >= this.DV) {
	 this.data[w] -= this.DV;
	 if(++w >= this.t) this.data[this.t++] = 0;
	 ++this.data[w];
	}
	}

	//A "null" reducer
	function NullExp() {}
	function nNop(x) { return x; }
	function nMulTo(x,y,r) { x.multiplyTo(y,r); }
	function nSqrTo(x,r) { x.squareTo(r); }

	NullExp.prototype.convert = nNop;
	NullExp.prototype.revert = nNop;
	NullExp.prototype.mulTo = nMulTo;
	NullExp.prototype.sqrTo = nSqrTo;

	//(public) this^e
	function bnPow(e) { return this.exp(e,new NullExp()); }

	//(protected) r = lower n words of "this * a", a.t <= n
	//"this" should be the larger one if appropriate.
	function bnpMultiplyLowerTo(a,n,r) {
	var i = Math.min(this.t+a.t,n);
	r.s = 0; // assumes a,this >= 0
	r.t = i;
	while(i > 0) r.data[--i] = 0;
	var j;
	for(j = r.t-this.t; i < j; ++i) r.data[i+this.t] = this.am(0,a.data[i],r,i,0,this.t);
	for(j = Math.min(a.t,n); i < j; ++i) this.am(0,a.data[i],r,i,0,n-i);
	r.clamp();
	}

	//(protected) r = "this * a" without lower n words, n > 0
	//"this" should be the larger one if appropriate.
	function bnpMultiplyUpperTo(a,n,r) {
	--n;
	var i = r.t = this.t+a.t-n;
	r.s = 0; // assumes a,this >= 0
	while(--i >= 0) r.data[i] = 0;
	for(i = Math.max(n-this.t,0); i < a.t; ++i)
	 r.data[this.t+i-n] = this.am(n-i,a.data[i],r,0,0,this.t+i-n);
	r.clamp();
	r.drShiftTo(1,r);
	}

	//Barrett modular reduction
	function Barrett(m) {
	// setup Barrett
	this.r2 = nbi();
	this.q3 = nbi();
	BigInteger$5.ONE.dlShiftTo(2*m.t,this.r2);
	this.mu = this.r2.divide(m);
	this.m = m;
	}

	function barrettConvert(x) {
	if(x.s < 0 || x.t > 2*this.m.t) return x.mod(this.m);
	else if(x.compareTo(this.m) < 0) return x;
	else { var r = nbi(); x.copyTo(r); this.reduce(r); return r; }
	}

	function barrettRevert(x) { return x; }

	//x = x mod m (HAC 14.42)
	function barrettReduce(x) {
	x.drShiftTo(this.m.t-1,this.r2);
	if(x.t > this.m.t+1) { x.t = this.m.t+1; x.clamp(); }
	this.mu.multiplyUpperTo(this.r2,this.m.t+1,this.q3);
	this.m.multiplyLowerTo(this.q3,this.m.t+1,this.r2);
	while(x.compareTo(this.r2) < 0) x.dAddOffset(1,this.m.t+1);
	x.subTo(this.r2,x);
	while(x.compareTo(this.m) >= 0) x.subTo(this.m,x);
	}

	//r = x^2 mod m; x != r
	function barrettSqrTo(x,r) { x.squareTo(r); this.reduce(r); }

	//r = x*y mod m; x,y != r
	function barrettMulTo(x,y,r) { x.multiplyTo(y,r); this.reduce(r); }

	Barrett.prototype.convert = barrettConvert;
	Barrett.prototype.revert = barrettRevert;
	Barrett.prototype.reduce = barrettReduce;
	Barrett.prototype.mulTo = barrettMulTo;
	Barrett.prototype.sqrTo = barrettSqrTo;

	//(public) this^e % m (HAC 14.85)
	function bnModPow(e,m) {
	var i = e.bitLength(), k, r = nbv(1), z;
	if(i <= 0) return r;
	else if(i < 18) k = 1;
	else if(i < 48) k = 3;
	else if(i < 144) k = 4;
	else if(i < 768) k = 5;
	else k = 6;
	if(i < 8)
	 z = new Classic(m);
	else if(m.isEven())
	 z = new Barrett(m);
	else
	 z = new Montgomery(m);

	// precomputation
	var g = new Array(), n = 3, k1 = k-1, km = (1<<k)-1;
	g[1] = z.convert(this);
	if(k > 1) {
	 var g2 = nbi();
	 z.sqrTo(g[1],g2);
	 while(n <= km) {
	   g[n] = nbi();
	   z.mulTo(g2,g[n-2],g[n]);
	   n += 2;
	 }
	}

	var j = e.t-1, w, is1 = true, r2 = nbi(), t;
	i = nbits(e.data[j])-1;
	while(j >= 0) {
	 if(i >= k1) w = (e.data[j]>>(i-k1))&km;
	 else {
	   w = (e.data[j]&((1<<(i+1))-1))<<(k1-i);
	   if(j > 0) w |= e.data[j-1]>>(this.DB+i-k1);
	 }

	 n = k;
	 while((w&1) == 0) { w >>= 1; --n; }
	 if((i -= n) < 0) { i += this.DB; --j; }
	 if(is1) {  // ret == 1, don't bother squaring or multiplying it
	   g[w].copyTo(r);
	   is1 = false;
	 } else {
	   while(n > 1) { z.sqrTo(r,r2); z.sqrTo(r2,r); n -= 2; }
	   if(n > 0) z.sqrTo(r,r2); else { t = r; r = r2; r2 = t; }
	   z.mulTo(r2,g[w],r);
	 }

	 while(j >= 0 && (e.data[j]&(1<<i)) == 0) {
	   z.sqrTo(r,r2); t = r; r = r2; r2 = t;
	   if(--i < 0) { i = this.DB-1; --j; }
	 }
	}
	return z.revert(r);
	}

	//(public) gcd(this,a) (HAC 14.54)
	function bnGCD(a) {
	var x = (this.s<0)?this.negate():this.clone();
	var y = (a.s<0)?a.negate():a.clone();
	if(x.compareTo(y) < 0) { var t = x; x = y; y = t; }
	var i = x.getLowestSetBit(), g = y.getLowestSetBit();
	if(g < 0) return x;
	if(i < g) g = i;
	if(g > 0) {
	 x.rShiftTo(g,x);
	 y.rShiftTo(g,y);
	}
	while(x.signum() > 0) {
	 if((i = x.getLowestSetBit()) > 0) x.rShiftTo(i,x);
	 if((i = y.getLowestSetBit()) > 0) y.rShiftTo(i,y);
	 if(x.compareTo(y) >= 0) {
	   x.subTo(y,x);
	   x.rShiftTo(1,x);
	 } else {
	   y.subTo(x,y);
	   y.rShiftTo(1,y);
	 }
	}
	if(g > 0) y.lShiftTo(g,y);
	return y;
	}

	//(protected) this % n, n < 2^26
	function bnpModInt(n) {
	if(n <= 0) return 0;
	var d = this.DV%n, r = (this.s<0)?n-1:0;
	if(this.t > 0)
	 if(d == 0) r = this.data[0]%n;
	 else for(var i = this.t-1; i >= 0; --i) r = (d*r+this.data[i])%n;
	return r;
	}

	//(public) 1/this % m (HAC 14.61)
	function bnModInverse(m) {
	var ac = m.isEven();
	if((this.isEven() && ac) || m.signum() == 0) return BigInteger$5.ZERO;
	var u = m.clone(), v = this.clone();
	var a = nbv(1), b = nbv(0), c = nbv(0), d = nbv(1);
	while(u.signum() != 0) {
	 while(u.isEven()) {
	   u.rShiftTo(1,u);
	   if(ac) {
	     if(!a.isEven() || !b.isEven()) { a.addTo(this,a); b.subTo(m,b); }
	     a.rShiftTo(1,a);
	   } else if(!b.isEven()) b.subTo(m,b);
	   b.rShiftTo(1,b);
	 }
	 while(v.isEven()) {
	   v.rShiftTo(1,v);
	   if(ac) {
	     if(!c.isEven() || !d.isEven()) { c.addTo(this,c); d.subTo(m,d); }
	     c.rShiftTo(1,c);
	   } else if(!d.isEven()) d.subTo(m,d);
	   d.rShiftTo(1,d);
	 }
	 if(u.compareTo(v) >= 0) {
	   u.subTo(v,u);
	   if(ac) a.subTo(c,a);
	   b.subTo(d,b);
	 } else {
	   v.subTo(u,v);
	   if(ac) c.subTo(a,c);
	   d.subTo(b,d);
	 }
	}
	if(v.compareTo(BigInteger$5.ONE) != 0) return BigInteger$5.ZERO;
	if(d.compareTo(m) >= 0) return d.subtract(m);
	if(d.signum() < 0) d.addTo(m,d); else return d;
	if(d.signum() < 0) return d.add(m); else return d;
	}

	var lowprimes = [2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97,101,103,107,109,113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,197,199,211,223,227,229,233,239,241,251,257,263,269,271,277,281,283,293,307,311,313,317,331,337,347,349,353,359,367,373,379,383,389,397,401,409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,499,503,509];
	var lplim = (1<<26)/lowprimes[lowprimes.length-1];

	//(public) test primality with certainty >= 1-.5^t
	function bnIsProbablePrime(t) {
	var i, x = this.abs();
	if(x.t == 1 && x.data[0] <= lowprimes[lowprimes.length-1]) {
	 for(i = 0; i < lowprimes.length; ++i)
	   if(x.data[0] == lowprimes[i]) return true;
	 return false;
	}
	if(x.isEven()) return false;
	i = 1;
	while(i < lowprimes.length) {
	 var m = lowprimes[i], j = i+1;
	 while(j < lowprimes.length && m < lplim) m *= lowprimes[j++];
	 m = x.modInt(m);
	 while(i < j) if(m%lowprimes[i++] == 0) return false;
	}
	return x.millerRabin(t);
	}

	//(protected) true if probably prime (HAC 4.24, Miller-Rabin)
	function bnpMillerRabin(t) {
	var n1 = this.subtract(BigInteger$5.ONE);
	var k = n1.getLowestSetBit();
	if(k <= 0) return false;
	var r = n1.shiftRight(k);
	var prng = bnGetPrng();
	var a;
	for(var i = 0; i < t; ++i) {
	 // select witness 'a' at random from between 1 and n1
	 do {
	   a = new BigInteger$5(this.bitLength(), prng);
	 }
	 while(a.compareTo(BigInteger$5.ONE) <= 0 || a.compareTo(n1) >= 0);
	 var y = a.modPow(r,this);
	 if(y.compareTo(BigInteger$5.ONE) != 0 && y.compareTo(n1) != 0) {
	   var j = 1;
	   while(j++ < k && y.compareTo(n1) != 0) {
	     y = y.modPowInt(2,this);
	     if(y.compareTo(BigInteger$5.ONE) == 0) return false;
	   }
	   if(y.compareTo(n1) != 0) return false;
	 }
	}
	return true;
	}

	// get pseudo random number generator
	function bnGetPrng() {
	  // create prng with api that matches BigInteger secure random
	  return {
	    // x is an array to fill with bytes
	    nextBytes: function(x) {
	      for(var i = 0; i < x.length; ++i) {
	        x[i] = Math.floor(Math.random() * 0x0100);
	      }
	    }
	  };
	}

	//protected
	BigInteger$5.prototype.chunkSize = bnpChunkSize;
	BigInteger$5.prototype.toRadix = bnpToRadix;
	BigInteger$5.prototype.fromRadix = bnpFromRadix;
	BigInteger$5.prototype.fromNumber = bnpFromNumber;
	BigInteger$5.prototype.bitwiseTo = bnpBitwiseTo;
	BigInteger$5.prototype.changeBit = bnpChangeBit;
	BigInteger$5.prototype.addTo = bnpAddTo;
	BigInteger$5.prototype.dMultiply = bnpDMultiply;
	BigInteger$5.prototype.dAddOffset = bnpDAddOffset;
	BigInteger$5.prototype.multiplyLowerTo = bnpMultiplyLowerTo;
	BigInteger$5.prototype.multiplyUpperTo = bnpMultiplyUpperTo;
	BigInteger$5.prototype.modInt = bnpModInt;
	BigInteger$5.prototype.millerRabin = bnpMillerRabin;

	//public
	BigInteger$5.prototype.clone = bnClone;
	BigInteger$5.prototype.intValue = bnIntValue;
	BigInteger$5.prototype.byteValue = bnByteValue;
	BigInteger$5.prototype.shortValue = bnShortValue;
	BigInteger$5.prototype.signum = bnSigNum;
	BigInteger$5.prototype.toByteArray = bnToByteArray;
	BigInteger$5.prototype.equals = bnEquals;
	BigInteger$5.prototype.min = bnMin;
	BigInteger$5.prototype.max = bnMax;
	BigInteger$5.prototype.and = bnAnd;
	BigInteger$5.prototype.or = bnOr;
	BigInteger$5.prototype.xor = bnXor;
	BigInteger$5.prototype.andNot = bnAndNot;
	BigInteger$5.prototype.not = bnNot;
	BigInteger$5.prototype.shiftLeft = bnShiftLeft;
	BigInteger$5.prototype.shiftRight = bnShiftRight;
	BigInteger$5.prototype.getLowestSetBit = bnGetLowestSetBit;
	BigInteger$5.prototype.bitCount = bnBitCount;
	BigInteger$5.prototype.testBit = bnTestBit;
	BigInteger$5.prototype.setBit = bnSetBit;
	BigInteger$5.prototype.clearBit = bnClearBit;
	BigInteger$5.prototype.flipBit = bnFlipBit;
	BigInteger$5.prototype.add = bnAdd;
	BigInteger$5.prototype.subtract = bnSubtract;
	BigInteger$5.prototype.multiply = bnMultiply;
	BigInteger$5.prototype.divide = bnDivide;
	BigInteger$5.prototype.remainder = bnRemainder;
	BigInteger$5.prototype.divideAndRemainder = bnDivideAndRemainder;
	BigInteger$5.prototype.modPow = bnModPow;
	BigInteger$5.prototype.modInverse = bnModInverse;
	BigInteger$5.prototype.pow = bnPow;
	BigInteger$5.prototype.gcd = bnGCD;
	BigInteger$5.prototype.isProbablePrime = bnIsProbablePrime;

	createCommonjsModule(function (module) {
	/**
	 * Secure Hash Algorithm with 160-bit digest (SHA-1) implementation.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2015 Digital Bazaar, Inc.
	 */




	var sha1 = module.exports = forge.sha1 = forge.sha1 || {};
	forge.md.sha1 = forge.md.algorithms.sha1 = sha1;

	/**
	 * Creates a SHA-1 message digest object.
	 *
	 * @return a message digest object.
	 */
	sha1.create = function() {
	  // do initialization as necessary
	  if(!_initialized) {
	    _init();
	  }

	  // SHA-1 state contains five 32-bit integers
	  var _state = null;

	  // input buffer
	  var _input = forge.util.createBuffer();

	  // used for word storage
	  var _w = new Array(80);

	  // message digest object
	  var md = {
	    algorithm: 'sha1',
	    blockLength: 64,
	    digestLength: 20,
	    // 56-bit length of message so far (does not including padding)
	    messageLength: 0,
	    // true message length
	    fullMessageLength: null,
	    // size of message length in bytes
	    messageLengthSize: 8
	  };

	  /**
	   * Starts the digest.
	   *
	   * @return this digest object.
	   */
	  md.start = function() {
	    // up to 56-bit message length for convenience
	    md.messageLength = 0;

	    // full message length (set md.messageLength64 for backwards-compatibility)
	    md.fullMessageLength = md.messageLength64 = [];
	    var int32s = md.messageLengthSize / 4;
	    for(var i = 0; i < int32s; ++i) {
	      md.fullMessageLength.push(0);
	    }
	    _input = forge.util.createBuffer();
	    _state = {
	      h0: 0x67452301,
	      h1: 0xEFCDAB89,
	      h2: 0x98BADCFE,
	      h3: 0x10325476,
	      h4: 0xC3D2E1F0
	    };
	    return md;
	  };
	  // start digest automatically for first time
	  md.start();

	  /**
	   * Updates the digest with the given message input. The given input can
	   * treated as raw input (no encoding will be applied) or an encoding of
	   * 'utf8' maybe given to encode the input using UTF-8.
	   *
	   * @param msg the message input to update with.
	   * @param encoding the encoding to use (default: 'raw', other: 'utf8').
	   *
	   * @return this digest object.
	   */
	  md.update = function(msg, encoding) {
	    if(encoding === 'utf8') {
	      msg = forge.util.encodeUtf8(msg);
	    }

	    // update message length
	    var len = msg.length;
	    md.messageLength += len;
	    len = [(len / 0x100000000) >>> 0, len >>> 0];
	    for(var i = md.fullMessageLength.length - 1; i >= 0; --i) {
	      md.fullMessageLength[i] += len[1];
	      len[1] = len[0] + ((md.fullMessageLength[i] / 0x100000000) >>> 0);
	      md.fullMessageLength[i] = md.fullMessageLength[i] >>> 0;
	      len[0] = ((len[1] / 0x100000000) >>> 0);
	    }

	    // add bytes to input buffer
	    _input.putBytes(msg);

	    // process bytes
	    _update(_state, _w, _input);

	    // compact input buffer every 2K or if empty
	    if(_input.read > 2048 || _input.length() === 0) {
	      _input.compact();
	    }

	    return md;
	  };

	  /**
	   * Produces the digest.
	   *
	   * @return a byte buffer containing the digest value.
	   */
	  md.digest = function() {
	    /* Note: Here we copy the remaining bytes in the input buffer and
	    add the appropriate SHA-1 padding. Then we do the final update
	    on a copy of the state so that if the user wants to get
	    intermediate digests they can do so. */

	    /* Determine the number of bytes that must be added to the message
	    to ensure its length is congruent to 448 mod 512. In other words,
	    the data to be digested must be a multiple of 512 bits (or 128 bytes).
	    This data includes the message, some padding, and the length of the
	    message. Since the length of the message will be encoded as 8 bytes (64
	    bits), that means that the last segment of the data must have 56 bytes
	    (448 bits) of message and padding. Therefore, the length of the message
	    plus the padding must be congruent to 448 mod 512 because
	    512 - 128 = 448.

	    In order to fill up the message length it must be filled with
	    padding that begins with 1 bit followed by all 0 bits. Padding
	    must *always* be present, so if the message length is already
	    congruent to 448 mod 512, then 512 padding bits must be added. */

	    var finalBlock = forge.util.createBuffer();
	    finalBlock.putBytes(_input.bytes());

	    // compute remaining size to be digested (include message length size)
	    var remaining = (
	      md.fullMessageLength[md.fullMessageLength.length - 1] +
	      md.messageLengthSize);

	    // add padding for overflow blockSize - overflow
	    // _padding starts with 1 byte with first bit is set (byte value 128), then
	    // there may be up to (blockSize - 1) other pad bytes
	    var overflow = remaining & (md.blockLength - 1);
	    finalBlock.putBytes(_padding.substr(0, md.blockLength - overflow));

	    // serialize message length in bits in big-endian order; since length
	    // is stored in bytes we multiply by 8 and add carry from next int
	    var next, carry;
	    var bits = md.fullMessageLength[0] * 8;
	    for(var i = 0; i < md.fullMessageLength.length - 1; ++i) {
	      next = md.fullMessageLength[i + 1] * 8;
	      carry = (next / 0x100000000) >>> 0;
	      bits += carry;
	      finalBlock.putInt32(bits >>> 0);
	      bits = next >>> 0;
	    }
	    finalBlock.putInt32(bits);

	    var s2 = {
	      h0: _state.h0,
	      h1: _state.h1,
	      h2: _state.h2,
	      h3: _state.h3,
	      h4: _state.h4
	    };
	    _update(s2, _w, finalBlock);
	    var rval = forge.util.createBuffer();
	    rval.putInt32(s2.h0);
	    rval.putInt32(s2.h1);
	    rval.putInt32(s2.h2);
	    rval.putInt32(s2.h3);
	    rval.putInt32(s2.h4);
	    return rval;
	  };

	  return md;
	};

	// sha-1 padding bytes not initialized yet
	var _padding = null;
	var _initialized = false;

	/**
	 * Initializes the constant tables.
	 */
	function _init() {
	  // create padding
	  _padding = String.fromCharCode(128);
	  _padding += forge.util.fillString(String.fromCharCode(0x00), 64);

	  // now initialized
	  _initialized = true;
	}

	/**
	 * Updates a SHA-1 state with the given byte buffer.
	 *
	 * @param s the SHA-1 state to update.
	 * @param w the array to use to store words.
	 * @param bytes the byte buffer to update with.
	 */
	function _update(s, w, bytes) {
	  // consume 512 bit (64 byte) chunks
	  var t, a, b, c, d, e, f, i;
	  var len = bytes.length();
	  while(len >= 64) {
	    // the w array will be populated with sixteen 32-bit big-endian words
	    // and then extended into 80 32-bit words according to SHA-1 algorithm
	    // and for 32-79 using Max Locktyukhin's optimization

	    // initialize hash value for this chunk
	    a = s.h0;
	    b = s.h1;
	    c = s.h2;
	    d = s.h3;
	    e = s.h4;

	    // round 1
	    for(i = 0; i < 16; ++i) {
	      t = bytes.getInt32();
	      w[i] = t;
	      f = d ^ (b & (c ^ d));
	      t = ((a << 5) | (a >>> 27)) + f + e + 0x5A827999 + t;
	      e = d;
	      d = c;
	      // `>>> 0` necessary to avoid iOS/Safari 10 optimization bug
	      c = ((b << 30) | (b >>> 2)) >>> 0;
	      b = a;
	      a = t;
	    }
	    for(; i < 20; ++i) {
	      t = (w[i - 3] ^ w[i - 8] ^ w[i - 14] ^ w[i - 16]);
	      t = (t << 1) | (t >>> 31);
	      w[i] = t;
	      f = d ^ (b & (c ^ d));
	      t = ((a << 5) | (a >>> 27)) + f + e + 0x5A827999 + t;
	      e = d;
	      d = c;
	      // `>>> 0` necessary to avoid iOS/Safari 10 optimization bug
	      c = ((b << 30) | (b >>> 2)) >>> 0;
	      b = a;
	      a = t;
	    }
	    // round 2
	    for(; i < 32; ++i) {
	      t = (w[i - 3] ^ w[i - 8] ^ w[i - 14] ^ w[i - 16]);
	      t = (t << 1) | (t >>> 31);
	      w[i] = t;
	      f = b ^ c ^ d;
	      t = ((a << 5) | (a >>> 27)) + f + e + 0x6ED9EBA1 + t;
	      e = d;
	      d = c;
	      // `>>> 0` necessary to avoid iOS/Safari 10 optimization bug
	      c = ((b << 30) | (b >>> 2)) >>> 0;
	      b = a;
	      a = t;
	    }
	    for(; i < 40; ++i) {
	      t = (w[i - 6] ^ w[i - 16] ^ w[i - 28] ^ w[i - 32]);
	      t = (t << 2) | (t >>> 30);
	      w[i] = t;
	      f = b ^ c ^ d;
	      t = ((a << 5) | (a >>> 27)) + f + e + 0x6ED9EBA1 + t;
	      e = d;
	      d = c;
	      // `>>> 0` necessary to avoid iOS/Safari 10 optimization bug
	      c = ((b << 30) | (b >>> 2)) >>> 0;
	      b = a;
	      a = t;
	    }
	    // round 3
	    for(; i < 60; ++i) {
	      t = (w[i - 6] ^ w[i - 16] ^ w[i - 28] ^ w[i - 32]);
	      t = (t << 2) | (t >>> 30);
	      w[i] = t;
	      f = (b & c) | (d & (b ^ c));
	      t = ((a << 5) | (a >>> 27)) + f + e + 0x8F1BBCDC + t;
	      e = d;
	      d = c;
	      // `>>> 0` necessary to avoid iOS/Safari 10 optimization bug
	      c = ((b << 30) | (b >>> 2)) >>> 0;
	      b = a;
	      a = t;
	    }
	    // round 4
	    for(; i < 80; ++i) {
	      t = (w[i - 6] ^ w[i - 16] ^ w[i - 28] ^ w[i - 32]);
	      t = (t << 2) | (t >>> 30);
	      w[i] = t;
	      f = b ^ c ^ d;
	      t = ((a << 5) | (a >>> 27)) + f + e + 0xCA62C1D6 + t;
	      e = d;
	      d = c;
	      // `>>> 0` necessary to avoid iOS/Safari 10 optimization bug
	      c = ((b << 30) | (b >>> 2)) >>> 0;
	      b = a;
	      a = t;
	    }

	    // update hash state
	    s.h0 = (s.h0 + a) | 0;
	    s.h1 = (s.h1 + b) | 0;
	    s.h2 = (s.h2 + c) | 0;
	    s.h3 = (s.h3 + d) | 0;
	    s.h4 = (s.h4 + e) | 0;

	    len -= 64;
	  }
	}
	});

	createCommonjsModule(function (module) {
	/**
	 * Partial implementation of PKCS#1 v2.2: RSA-OEAP
	 *
	 * Modified but based on the following MIT and BSD licensed code:
	 *
	 * https://github.com/kjur/jsjws/blob/master/rsa.js:
	 *
	 * The 'jsjws'(JSON Web Signature JavaScript Library) License
	 *
	 * Copyright (c) 2012 Kenji Urushima
	 *
	 * Permission is hereby granted, free of charge, to any person obtaining a copy
	 * of this software and associated documentation files (the "Software"), to deal
	 * in the Software without restriction, including without limitation the rights
	 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	 * copies of the Software, and to permit persons to whom the Software is
	 * furnished to do so, subject to the following conditions:
	 *
	 * The above copyright notice and this permission notice shall be included in
	 * all copies or substantial portions of the Software.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	 * THE SOFTWARE.
	 *
	 * http://webrsa.cvs.sourceforge.net/viewvc/webrsa/Client/RSAES-OAEP.js?content-type=text%2Fplain:
	 *
	 * RSAES-OAEP.js
	 * $Id: RSAES-OAEP.js,v 1.1.1.1 2003/03/19 15:37:20 ellispritchard Exp $
	 * JavaScript Implementation of PKCS #1 v2.1 RSA CRYPTOGRAPHY STANDARD (RSA Laboratories, June 14, 2002)
	 * Copyright (C) Ellis Pritchard, Guardian Unlimited 2003.
	 * Contact: ellis@nukinetics.com
	 * Distributed under the BSD License.
	 *
	 * Official documentation: http://www.rsa.com/rsalabs/node.asp?id=2125
	 *
	 * @author Evan Jones (http://evanjones.ca/)
	 * @author Dave Longley
	 *
	 * Copyright (c) 2013-2014 Digital Bazaar, Inc.
	 */





	// shortcut for PKCS#1 API
	var pkcs1 = module.exports = forge.pkcs1 = forge.pkcs1 || {};

	/**
	 * Encode the given RSAES-OAEP message (M) using key, with optional label (L)
	 * and seed.
	 *
	 * This method does not perform RSA encryption, it only encodes the message
	 * using RSAES-OAEP.
	 *
	 * @param key the RSA key to use.
	 * @param message the message to encode.
	 * @param options the options to use:
	 *          label an optional label to use.
	 *          seed the seed to use.
	 *          md the message digest object to use, undefined for SHA-1.
	 *          mgf1 optional mgf1 parameters:
	 *            md the message digest object to use for MGF1.
	 *
	 * @return the encoded message bytes.
	 */
	pkcs1.encode_rsa_oaep = function(key, message, options) {
	  // parse arguments
	  var label;
	  var seed;
	  var md;
	  var mgf1Md;
	  // legacy args (label, seed, md)
	  if(typeof options === 'string') {
	    label = options;
	    seed = arguments[3] || undefined;
	    md = arguments[4] || undefined;
	  } else if(options) {
	    label = options.label || undefined;
	    seed = options.seed || undefined;
	    md = options.md || undefined;
	    if(options.mgf1 && options.mgf1.md) {
	      mgf1Md = options.mgf1.md;
	    }
	  }

	  // default OAEP to SHA-1 message digest
	  if(!md) {
	    md = forge.md.sha1.create();
	  } else {
	    md.start();
	  }

	  // default MGF-1 to same as OAEP
	  if(!mgf1Md) {
	    mgf1Md = md;
	  }

	  // compute length in bytes and check output
	  var keyLength = Math.ceil(key.n.bitLength() / 8);
	  var maxLength = keyLength - 2 * md.digestLength - 2;
	  if(message.length > maxLength) {
	    var error = new Error('RSAES-OAEP input message length is too long.');
	    error.length = message.length;
	    error.maxLength = maxLength;
	    throw error;
	  }

	  if(!label) {
	    label = '';
	  }
	  md.update(label, 'raw');
	  var lHash = md.digest();

	  var PS = '';
	  var PS_length = maxLength - message.length;
	  for(var i = 0; i < PS_length; i++) {
	    PS += '\x00';
	  }

	  var DB = lHash.getBytes() + PS + '\x01' + message;

	  if(!seed) {
	    seed = forge.random.getBytes(md.digestLength);
	  } else if(seed.length !== md.digestLength) {
	    var error = new Error('Invalid RSAES-OAEP seed. The seed length must ' +
	      'match the digest length.');
	    error.seedLength = seed.length;
	    error.digestLength = md.digestLength;
	    throw error;
	  }

	  var dbMask = rsa_mgf1(seed, keyLength - md.digestLength - 1, mgf1Md);
	  var maskedDB = forge.util.xorBytes(DB, dbMask, DB.length);

	  var seedMask = rsa_mgf1(maskedDB, md.digestLength, mgf1Md);
	  var maskedSeed = forge.util.xorBytes(seed, seedMask, seed.length);

	  // return encoded message
	  return '\x00' + maskedSeed + maskedDB;
	};

	/**
	 * Decode the given RSAES-OAEP encoded message (EM) using key, with optional
	 * label (L).
	 *
	 * This method does not perform RSA decryption, it only decodes the message
	 * using RSAES-OAEP.
	 *
	 * @param key the RSA key to use.
	 * @param em the encoded message to decode.
	 * @param options the options to use:
	 *          label an optional label to use.
	 *          md the message digest object to use for OAEP, undefined for SHA-1.
	 *          mgf1 optional mgf1 parameters:
	 *            md the message digest object to use for MGF1.
	 *
	 * @return the decoded message bytes.
	 */
	pkcs1.decode_rsa_oaep = function(key, em, options) {
	  // parse args
	  var label;
	  var md;
	  var mgf1Md;
	  // legacy args
	  if(typeof options === 'string') {
	    label = options;
	    md = arguments[3] || undefined;
	  } else if(options) {
	    label = options.label || undefined;
	    md = options.md || undefined;
	    if(options.mgf1 && options.mgf1.md) {
	      mgf1Md = options.mgf1.md;
	    }
	  }

	  // compute length in bytes
	  var keyLength = Math.ceil(key.n.bitLength() / 8);

	  if(em.length !== keyLength) {
	    var error = new Error('RSAES-OAEP encoded message length is invalid.');
	    error.length = em.length;
	    error.expectedLength = keyLength;
	    throw error;
	  }

	  // default OAEP to SHA-1 message digest
	  if(md === undefined) {
	    md = forge.md.sha1.create();
	  } else {
	    md.start();
	  }

	  // default MGF-1 to same as OAEP
	  if(!mgf1Md) {
	    mgf1Md = md;
	  }

	  if(keyLength < 2 * md.digestLength + 2) {
	    throw new Error('RSAES-OAEP key is too short for the hash function.');
	  }

	  if(!label) {
	    label = '';
	  }
	  md.update(label, 'raw');
	  var lHash = md.digest().getBytes();

	  // split the message into its parts
	  var y = em.charAt(0);
	  var maskedSeed = em.substring(1, md.digestLength + 1);
	  var maskedDB = em.substring(1 + md.digestLength);

	  var seedMask = rsa_mgf1(maskedDB, md.digestLength, mgf1Md);
	  var seed = forge.util.xorBytes(maskedSeed, seedMask, maskedSeed.length);

	  var dbMask = rsa_mgf1(seed, keyLength - md.digestLength - 1, mgf1Md);
	  var db = forge.util.xorBytes(maskedDB, dbMask, maskedDB.length);

	  var lHashPrime = db.substring(0, md.digestLength);

	  // constant time check that all values match what is expected
	  var error = (y !== '\x00');

	  // constant time check lHash vs lHashPrime
	  for(var i = 0; i < md.digestLength; ++i) {
	    error |= (lHash.charAt(i) !== lHashPrime.charAt(i));
	  }

	  // "constant time" find the 0x1 byte separating the padding (zeros) from the
	  // message
	  // TODO: It must be possible to do this in a better/smarter way?
	  var in_ps = 1;
	  var index = md.digestLength;
	  for(var j = md.digestLength; j < db.length; j++) {
	    var code = db.charCodeAt(j);

	    var is_0 = (code & 0x1) ^ 0x1;

	    // non-zero if not 0 or 1 in the ps section
	    var error_mask = in_ps ? 0xfffe : 0x0000;
	    error |= (code & error_mask);

	    // latch in_ps to zero after we find 0x1
	    in_ps = in_ps & is_0;
	    index += in_ps;
	  }

	  if(error || db.charCodeAt(index) !== 0x1) {
	    throw new Error('Invalid RSAES-OAEP padding.');
	  }

	  return db.substring(index + 1);
	};

	function rsa_mgf1(seed, maskLength, hash) {
	  // default to SHA-1 message digest
	  if(!hash) {
	    hash = forge.md.sha1.create();
	  }
	  var t = '';
	  var count = Math.ceil(maskLength / hash.digestLength);
	  for(var i = 0; i < count; ++i) {
	    var c = String.fromCharCode(
	      (i >> 24) & 0xFF, (i >> 16) & 0xFF, (i >> 8) & 0xFF, i & 0xFF);
	    hash.start();
	    hash.update(seed + c);
	    t += hash.digest().getBytes();
	  }
	  return t.substring(0, maskLength);
	}
	});

	createCommonjsModule(function (module) {
	/**
	 * Prime number generation API.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2014 Digital Bazaar, Inc.
	 */





	(function() {

	// forge.prime already defined
	if(forge.prime) {
	  module.exports = forge.prime;
	  return;
	}

	/* PRIME API */
	var prime = module.exports = forge.prime = forge.prime || {};

	var BigInteger = forge.jsbn.BigInteger;

	// primes are 30k+i for i = 1, 7, 11, 13, 17, 19, 23, 29
	var GCD_30_DELTA = [6, 4, 2, 4, 2, 4, 6, 2];
	var THIRTY = new BigInteger(null);
	THIRTY.fromInt(30);
	var op_or = function(x, y) {return x|y;};

	/**
	 * Generates a random probable prime with the given number of bits.
	 *
	 * Alternative algorithms can be specified by name as a string or as an
	 * object with custom options like so:
	 *
	 * {
	 *   name: 'PRIMEINC',
	 *   options: {
	 *     maxBlockTime: <the maximum amount of time to block the main
	 *       thread before allowing I/O other JS to run>,
	 *     millerRabinTests: <the number of miller-rabin tests to run>,
	 *     workerScript: <the worker script URL>,
	 *     workers: <the number of web workers (if supported) to use,
	 *       -1 to use estimated cores minus one>.
	 *     workLoad: the size of the work load, ie: number of possible prime
	 *       numbers for each web worker to check per work assignment,
	 *       (default: 100).
	 *   }
	 * }
	 *
	 * @param bits the number of bits for the prime number.
	 * @param options the options to use.
	 *          [algorithm] the algorithm to use (default: 'PRIMEINC').
	 *          [prng] a custom crypto-secure pseudo-random number generator to use,
	 *            that must define "getBytesSync".
	 *
	 * @return callback(err, num) called once the operation completes.
	 */
	prime.generateProbablePrime = function(bits, options, callback) {
	  if(typeof options === 'function') {
	    callback = options;
	    options = {};
	  }
	  options = options || {};

	  // default to PRIMEINC algorithm
	  var algorithm = options.algorithm || 'PRIMEINC';
	  if(typeof algorithm === 'string') {
	    algorithm = {name: algorithm};
	  }
	  algorithm.options = algorithm.options || {};

	  // create prng with api that matches BigInteger secure random
	  var prng = options.prng || forge.random;
	  var rng = {
	    // x is an array to fill with bytes
	    nextBytes: function(x) {
	      var b = prng.getBytesSync(x.length);
	      for(var i = 0; i < x.length; ++i) {
	        x[i] = b.charCodeAt(i);
	      }
	    }
	  };

	  if(algorithm.name === 'PRIMEINC') {
	    return primeincFindPrime(bits, rng, algorithm.options, callback);
	  }

	  throw new Error('Invalid prime generation algorithm: ' + algorithm.name);
	};

	function primeincFindPrime(bits, rng, options, callback) {
	  if('workers' in options) {
	    return primeincFindPrimeWithWorkers(bits, rng, options, callback);
	  }
	  return primeincFindPrimeWithoutWorkers(bits, rng, options, callback);
	}

	function primeincFindPrimeWithoutWorkers(bits, rng, options, callback) {
	  // initialize random number
	  var num = generateRandom(bits, rng);

	  /* Note: All primes are of the form 30k+i for i < 30 and gcd(30, i)=1. The
	  number we are given is always aligned at 30k + 1. Each time the number is
	  determined not to be prime we add to get to the next 'i', eg: if the number
	  was at 30k + 1 we add 6. */
	  var deltaIdx = 0;

	  // get required number of MR tests
	  var mrTests = getMillerRabinTests(num.bitLength());
	  if('millerRabinTests' in options) {
	    mrTests = options.millerRabinTests;
	  }

	  // find prime nearest to 'num' for maxBlockTime ms
	  // 10 ms gives 5ms of leeway for other calculations before dropping
	  // below 60fps (1000/60 == 16.67), but in reality, the number will
	  // likely be higher due to an 'atomic' big int modPow
	  var maxBlockTime = 10;
	  if('maxBlockTime' in options) {
	    maxBlockTime = options.maxBlockTime;
	  }

	  _primeinc(num, bits, rng, deltaIdx, mrTests, maxBlockTime, callback);
	}

	function _primeinc(num, bits, rng, deltaIdx, mrTests, maxBlockTime, callback) {
	  var start = +new Date();
	  do {
	    // overflow, regenerate random number
	    if(num.bitLength() > bits) {
	      num = generateRandom(bits, rng);
	    }
	    // do primality test
	    if(num.isProbablePrime(mrTests)) {
	      return callback(null, num);
	    }
	    // get next potential prime
	    num.dAddOffset(GCD_30_DELTA[deltaIdx++ % 8], 0);
	  } while(maxBlockTime < 0 || (+new Date() - start < maxBlockTime));

	  // keep trying later
	  forge.util.setImmediate(function() {
	    _primeinc(num, bits, rng, deltaIdx, mrTests, maxBlockTime, callback);
	  });
	}

	// NOTE: This algorithm is indeterminate in nature because workers
	// run in parallel looking at different segments of numbers. Even if this
	// algorithm is run twice with the same input from a predictable RNG, it
	// may produce different outputs.
	function primeincFindPrimeWithWorkers(bits, rng, options, callback) {
	  // web workers unavailable
	  if(typeof Worker === 'undefined') {
	    return primeincFindPrimeWithoutWorkers(bits, rng, options, callback);
	  }

	  // initialize random number
	  var num = generateRandom(bits, rng);

	  // use web workers to generate keys
	  var numWorkers = options.workers;
	  var workLoad = options.workLoad || 100;
	  var range = workLoad * 30 / 8;
	  var workerScript = options.workerScript || 'forge/prime.worker.js';
	  if(numWorkers === -1) {
	    return forge.util.estimateCores(function(err, cores) {
	      if(err) {
	        // default to 2
	        cores = 2;
	      }
	      numWorkers = cores - 1;
	      generate();
	    });
	  }
	  generate();

	  function generate() {
	    // require at least 1 worker
	    numWorkers = Math.max(1, numWorkers);

	    // TODO: consider optimizing by starting workers outside getPrime() ...
	    // note that in order to clean up they will have to be made internally
	    // asynchronous which may actually be slower

	    // start workers immediately
	    var workers = [];
	    for(var i = 0; i < numWorkers; ++i) {
	      // FIXME: fix path or use blob URLs
	      workers[i] = new Worker(workerScript);
	    }

	    // listen for requests from workers and assign ranges to find prime
	    for(var i = 0; i < numWorkers; ++i) {
	      workers[i].addEventListener('message', workerMessage);
	    }

	    /* Note: The distribution of random numbers is unknown. Therefore, each
	    web worker is continuously allocated a range of numbers to check for a
	    random number until one is found.

	    Every 30 numbers will be checked just 8 times, because prime numbers
	    have the form:

	    30k+i, for i < 30 and gcd(30, i)=1 (there are 8 values of i for this)

	    Therefore, if we want a web worker to run N checks before asking for
	    a new range of numbers, each range must contain N*30/8 numbers.

	    For 100 checks (workLoad), this is a range of 375. */

	    var found = false;
	    function workerMessage(e) {
	      // ignore message, prime already found
	      if(found) {
	        return;
	      }
	      var data = e.data;
	      if(data.found) {
	        // terminate all workers
	        for(var i = 0; i < workers.length; ++i) {
	          workers[i].terminate();
	        }
	        found = true;
	        return callback(null, new BigInteger(data.prime, 16));
	      }

	      // overflow, regenerate random number
	      if(num.bitLength() > bits) {
	        num = generateRandom(bits, rng);
	      }

	      // assign new range to check
	      var hex = num.toString(16);

	      // start prime search
	      e.target.postMessage({
	        hex: hex,
	        workLoad: workLoad
	      });

	      num.dAddOffset(range, 0);
	    }
	  }
	}

	/**
	 * Generates a random number using the given number of bits and RNG.
	 *
	 * @param bits the number of bits for the number.
	 * @param rng the random number generator to use.
	 *
	 * @return the random number.
	 */
	function generateRandom(bits, rng) {
	  var num = new BigInteger(bits, rng);
	  // force MSB set
	  var bits1 = bits - 1;
	  if(!num.testBit(bits1)) {
	    num.bitwiseTo(BigInteger.ONE.shiftLeft(bits1), op_or, num);
	  }
	  // align number on 30k+1 boundary
	  num.dAddOffset(31 - num.mod(THIRTY).byteValue(), 0);
	  return num;
	}

	/**
	 * Returns the required number of Miller-Rabin tests to generate a
	 * prime with an error probability of (1/2)^80.
	 *
	 * See Handbook of Applied Cryptography Chapter 4, Table 4.4.
	 *
	 * @param bits the bit size.
	 *
	 * @return the required number of iterations.
	 */
	function getMillerRabinTests(bits) {
	  if(bits <= 100) return 27;
	  if(bits <= 150) return 18;
	  if(bits <= 200) return 15;
	  if(bits <= 250) return 12;
	  if(bits <= 300) return 9;
	  if(bits <= 350) return 8;
	  if(bits <= 400) return 7;
	  if(bits <= 500) return 6;
	  if(bits <= 600) return 5;
	  if(bits <= 800) return 4;
	  if(bits <= 1250) return 3;
	  return 2;
	}

	})();
	});

	/**
	 * Javascript implementation of basic RSA algorithms.
	 *
	 * @author Dave Longley
	 *
	 * Copyright (c) 2010-2014 Digital Bazaar, Inc.
	 *
	 * The only algorithm currently supported for PKI is RSA.
	 *
	 * An RSA key is often stored in ASN.1 DER format. The SubjectPublicKeyInfo
	 * ASN.1 structure is composed of an algorithm of type AlgorithmIdentifier
	 * and a subjectPublicKey of type bit string.
	 *
	 * The AlgorithmIdentifier contains an Object Identifier (OID) and parameters
	 * for the algorithm, if any. In the case of RSA, there aren't any.
	 *
	 * SubjectPublicKeyInfo ::= SEQUENCE {
	 *   algorithm AlgorithmIdentifier,
	 *   subjectPublicKey BIT STRING
	 * }
	 *
	 * AlgorithmIdentifer ::= SEQUENCE {
	 *   algorithm OBJECT IDENTIFIER,
	 *   parameters ANY DEFINED BY algorithm OPTIONAL
	 * }
	 *
	 * For an RSA public key, the subjectPublicKey is:
	 *
	 * RSAPublicKey ::= SEQUENCE {
	 *   modulus            INTEGER,    -- n
	 *   publicExponent     INTEGER     -- e
	 * }
	 *
	 * PrivateKeyInfo ::= SEQUENCE {
	 *   version                   Version,
	 *   privateKeyAlgorithm       PrivateKeyAlgorithmIdentifier,
	 *   privateKey                PrivateKey,
	 *   attributes           [0]  IMPLICIT Attributes OPTIONAL
	 * }
	 *
	 * Version ::= INTEGER
	 * PrivateKeyAlgorithmIdentifier ::= AlgorithmIdentifier
	 * PrivateKey ::= OCTET STRING
	 * Attributes ::= SET OF Attribute
	 *
	 * An RSA private key as the following structure:
	 *
	 * RSAPrivateKey ::= SEQUENCE {
	 *   version Version,
	 *   modulus INTEGER, -- n
	 *   publicExponent INTEGER, -- e
	 *   privateExponent INTEGER, -- d
	 *   prime1 INTEGER, -- p
	 *   prime2 INTEGER, -- q
	 *   exponent1 INTEGER, -- d mod (p-1)
	 *   exponent2 INTEGER, -- d mod (q-1)
	 *   coefficient INTEGER -- (inverse of q) mod p
	 * }
	 *
	 * Version ::= INTEGER
	 *
	 * The OID for the RSA key algorithm is: 1.2.840.113549.1.1.1
	 */









	if(typeof BigInteger$4 === 'undefined') {
	  var BigInteger$4 = forge.jsbn.BigInteger;
	}

	var _crypto = forge.util.isNodejs ? require$$7 : null;

	// shortcut for asn.1 API
	var asn1$2 = forge.asn1;

	// shortcut for util API
	var util = forge.util;

	/*
	 * RSA encryption and decryption, see RFC 2313.
	 */
	forge.pki = forge.pki || {};
	forge.pki.rsa = forge.rsa = forge.rsa || {};
	var pki$1 = forge.pki;

	// for finding primes, which are 30k+i for i = 1, 7, 11, 13, 17, 19, 23, 29
	var GCD_30_DELTA = [6, 4, 2, 4, 2, 4, 6, 2];

	// validator for a PrivateKeyInfo structure
	var privateKeyValidator$2 = {
	  // PrivateKeyInfo
	  name: 'PrivateKeyInfo',
	  tagClass: asn1$2.Class.UNIVERSAL,
	  type: asn1$2.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    // Version (INTEGER)
	    name: 'PrivateKeyInfo.version',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'privateKeyVersion'
	  }, {
	    // privateKeyAlgorithm
	    name: 'PrivateKeyInfo.privateKeyAlgorithm',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.SEQUENCE,
	    constructed: true,
	    value: [{
	      name: 'AlgorithmIdentifier.algorithm',
	      tagClass: asn1$2.Class.UNIVERSAL,
	      type: asn1$2.Type.OID,
	      constructed: false,
	      capture: 'privateKeyOid'
	    }]
	  }, {
	    // PrivateKey
	    name: 'PrivateKeyInfo',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.OCTETSTRING,
	    constructed: false,
	    capture: 'privateKey'
	  }]
	};

	// validator for an RSA private key
	var rsaPrivateKeyValidator = {
	  // RSAPrivateKey
	  name: 'RSAPrivateKey',
	  tagClass: asn1$2.Class.UNIVERSAL,
	  type: asn1$2.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    // Version (INTEGER)
	    name: 'RSAPrivateKey.version',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'privateKeyVersion'
	  }, {
	    // modulus (n)
	    name: 'RSAPrivateKey.modulus',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'privateKeyModulus'
	  }, {
	    // publicExponent (e)
	    name: 'RSAPrivateKey.publicExponent',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'privateKeyPublicExponent'
	  }, {
	    // privateExponent (d)
	    name: 'RSAPrivateKey.privateExponent',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'privateKeyPrivateExponent'
	  }, {
	    // prime1 (p)
	    name: 'RSAPrivateKey.prime1',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'privateKeyPrime1'
	  }, {
	    // prime2 (q)
	    name: 'RSAPrivateKey.prime2',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'privateKeyPrime2'
	  }, {
	    // exponent1 (d mod (p-1))
	    name: 'RSAPrivateKey.exponent1',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'privateKeyExponent1'
	  }, {
	    // exponent2 (d mod (q-1))
	    name: 'RSAPrivateKey.exponent2',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'privateKeyExponent2'
	  }, {
	    // coefficient ((inverse of q) mod p)
	    name: 'RSAPrivateKey.coefficient',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'privateKeyCoefficient'
	  }]
	};

	// validator for an RSA public key
	var rsaPublicKeyValidator = {
	  // RSAPublicKey
	  name: 'RSAPublicKey',
	  tagClass: asn1$2.Class.UNIVERSAL,
	  type: asn1$2.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    // modulus (n)
	    name: 'RSAPublicKey.modulus',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'publicKeyModulus'
	  }, {
	    // publicExponent (e)
	    name: 'RSAPublicKey.exponent',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.INTEGER,
	    constructed: false,
	    capture: 'publicKeyExponent'
	  }]
	};

	// validator for an SubjectPublicKeyInfo structure
	// Note: Currently only works with an RSA public key
	var publicKeyValidator$2 = forge.pki.rsa.publicKeyValidator = {
	  name: 'SubjectPublicKeyInfo',
	  tagClass: asn1$2.Class.UNIVERSAL,
	  type: asn1$2.Type.SEQUENCE,
	  constructed: true,
	  captureAsn1: 'subjectPublicKeyInfo',
	  value: [{
	    name: 'SubjectPublicKeyInfo.AlgorithmIdentifier',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.SEQUENCE,
	    constructed: true,
	    value: [{
	      name: 'AlgorithmIdentifier.algorithm',
	      tagClass: asn1$2.Class.UNIVERSAL,
	      type: asn1$2.Type.OID,
	      constructed: false,
	      capture: 'publicKeyOid'
	    }]
	  }, {
	    // subjectPublicKey
	    name: 'SubjectPublicKeyInfo.subjectPublicKey',
	    tagClass: asn1$2.Class.UNIVERSAL,
	    type: asn1$2.Type.BITSTRING,
	    constructed: false,
	    value: [{
	      // RSAPublicKey
	      name: 'SubjectPublicKeyInfo.subjectPublicKey.RSAPublicKey',
	      tagClass: asn1$2.Class.UNIVERSAL,
	      type: asn1$2.Type.SEQUENCE,
	      constructed: true,
	      optional: true,
	      captureAsn1: 'rsaPublicKey'
	    }]
	  }]
	};

	/**
	 * Wrap digest in DigestInfo object.
	 *
	 * This function implements EMSA-PKCS1-v1_5-ENCODE as per RFC 3447.
	 *
	 * DigestInfo ::= SEQUENCE {
	 *   digestAlgorithm DigestAlgorithmIdentifier,
	 *   digest Digest
	 * }
	 *
	 * DigestAlgorithmIdentifier ::= AlgorithmIdentifier
	 * Digest ::= OCTET STRING
	 *
	 * @param md the message digest object with the hash to sign.
	 *
	 * @return the encoded message (ready for RSA encrytion)
	 */
	var emsaPkcs1v15encode = function(md) {
	  // get the oid for the algorithm
	  var oid;
	  if(md.algorithm in pki$1.oids) {
	    oid = pki$1.oids[md.algorithm];
	  } else {
	    var error = new Error('Unknown message digest algorithm.');
	    error.algorithm = md.algorithm;
	    throw error;
	  }
	  var oidBytes = asn1$2.oidToDer(oid).getBytes();

	  // create the digest info
	  var digestInfo = asn1$2.create(
	    asn1$2.Class.UNIVERSAL, asn1$2.Type.SEQUENCE, true, []);
	  var digestAlgorithm = asn1$2.create(
	    asn1$2.Class.UNIVERSAL, asn1$2.Type.SEQUENCE, true, []);
	  digestAlgorithm.value.push(asn1$2.create(
	    asn1$2.Class.UNIVERSAL, asn1$2.Type.OID, false, oidBytes));
	  digestAlgorithm.value.push(asn1$2.create(
	    asn1$2.Class.UNIVERSAL, asn1$2.Type.NULL, false, ''));
	  var digest = asn1$2.create(
	    asn1$2.Class.UNIVERSAL, asn1$2.Type.OCTETSTRING,
	    false, md.digest().getBytes());
	  digestInfo.value.push(digestAlgorithm);
	  digestInfo.value.push(digest);

	  // encode digest info
	  return asn1$2.toDer(digestInfo).getBytes();
	};

	/**
	 * Performs x^c mod n (RSA encryption or decryption operation).
	 *
	 * @param x the number to raise and mod.
	 * @param key the key to use.
	 * @param pub true if the key is public, false if private.
	 *
	 * @return the result of x^c mod n.
	 */
	var _modPow = function(x, key, pub) {
	  if(pub) {
	    return x.modPow(key.e, key.n);
	  }

	  if(!key.p || !key.q) {
	    // allow calculation without CRT params (slow)
	    return x.modPow(key.d, key.n);
	  }

	  // pre-compute dP, dQ, and qInv if necessary
	  if(!key.dP) {
	    key.dP = key.d.mod(key.p.subtract(BigInteger$4.ONE));
	  }
	  if(!key.dQ) {
	    key.dQ = key.d.mod(key.q.subtract(BigInteger$4.ONE));
	  }
	  if(!key.qInv) {
	    key.qInv = key.q.modInverse(key.p);
	  }

	  /* Chinese remainder theorem (CRT) states:

	    Suppose n1, n2, ..., nk are positive integers which are pairwise
	    coprime (n1 and n2 have no common factors other than 1). For any
	    integers x1, x2, ..., xk there exists an integer x solving the
	    system of simultaneous congruences (where ~= means modularly
	    congruent so a ~= b mod n means a mod n = b mod n):

	    x ~= x1 mod n1
	    x ~= x2 mod n2
	    ...
	    x ~= xk mod nk

	    This system of congruences has a single simultaneous solution x
	    between 0 and n - 1. Furthermore, each xk solution and x itself
	    is congruent modulo the product n = n1*n2*...*nk.
	    So x1 mod n = x2 mod n = xk mod n = x mod n.

	    The single simultaneous solution x can be solved with the following
	    equation:

	    x = sum(xi*ri*si) mod n where ri = n/ni and si = ri^-1 mod ni.

	    Where x is less than n, xi = x mod ni.

	    For RSA we are only concerned with k = 2. The modulus n = pq, where
	    p and q are coprime. The RSA decryption algorithm is:

	    y = x^d mod n

	    Given the above:

	    x1 = x^d mod p
	    r1 = n/p = q
	    s1 = q^-1 mod p
	    x2 = x^d mod q
	    r2 = n/q = p
	    s2 = p^-1 mod q

	    So y = (x1r1s1 + x2r2s2) mod n
	         = ((x^d mod p)q(q^-1 mod p) + (x^d mod q)p(p^-1 mod q)) mod n

	    According to Fermat's Little Theorem, if the modulus P is prime,
	    for any integer A not evenly divisible by P, A^(P-1) ~= 1 mod P.
	    Since A is not divisible by P it follows that if:
	    N ~= M mod (P - 1), then A^N mod P = A^M mod P. Therefore:

	    A^N mod P = A^(M mod (P - 1)) mod P. (The latter takes less effort
	    to calculate). In order to calculate x^d mod p more quickly the
	    exponent d mod (p - 1) is stored in the RSA private key (the same
	    is done for x^d mod q). These values are referred to as dP and dQ
	    respectively. Therefore we now have:

	    y = ((x^dP mod p)q(q^-1 mod p) + (x^dQ mod q)p(p^-1 mod q)) mod n

	    Since we'll be reducing x^dP by modulo p (same for q) we can also
	    reduce x by p (and q respectively) before hand. Therefore, let

	    xp = ((x mod p)^dP mod p), and
	    xq = ((x mod q)^dQ mod q), yielding:

	    y = (xp*q*(q^-1 mod p) + xq*p*(p^-1 mod q)) mod n

	    This can be further reduced to a simple algorithm that only
	    requires 1 inverse (the q inverse is used) to be used and stored.
	    The algorithm is called Garner's algorithm. If qInv is the
	    inverse of q, we simply calculate:

	    y = (qInv*(xp - xq) mod p) * q + xq

	    However, there are two further complications. First, we need to
	    ensure that xp > xq to prevent signed BigIntegers from being used
	    so we add p until this is true (since we will be mod'ing with
	    p anyway). Then, there is a known timing attack on algorithms
	    using the CRT. To mitigate this risk, "cryptographic blinding"
	    should be used. This requires simply generating a random number r
	    between 0 and n-1 and its inverse and multiplying x by r^e before
	    calculating y and then multiplying y by r^-1 afterwards. Note that
	    r must be coprime with n (gcd(r, n) === 1) in order to have an
	    inverse.
	  */

	  // cryptographic blinding
	  var r;
	  do {
	    r = new BigInteger$4(
	      forge.util.bytesToHex(forge.random.getBytes(key.n.bitLength() / 8)),
	      16);
	  } while(r.compareTo(key.n) >= 0 || !r.gcd(key.n).equals(BigInteger$4.ONE));
	  x = x.multiply(r.modPow(key.e, key.n)).mod(key.n);

	  // calculate xp and xq
	  var xp = x.mod(key.p).modPow(key.dP, key.p);
	  var xq = x.mod(key.q).modPow(key.dQ, key.q);

	  // xp must be larger than xq to avoid signed bit usage
	  while(xp.compareTo(xq) < 0) {
	    xp = xp.add(key.p);
	  }

	  // do last step
	  var y = xp.subtract(xq)
	    .multiply(key.qInv).mod(key.p)
	    .multiply(key.q).add(xq);

	  // remove effect of random for cryptographic blinding
	  y = y.multiply(r.modInverse(key.n)).mod(key.n);

	  return y;
	};

	/**
	 * NOTE: THIS METHOD IS DEPRECATED, use 'sign' on a private key object or
	 * 'encrypt' on a public key object instead.
	 *
	 * Performs RSA encryption.
	 *
	 * The parameter bt controls whether to put padding bytes before the
	 * message passed in. Set bt to either true or false to disable padding
	 * completely (in order to handle e.g. EMSA-PSS encoding seperately before),
	 * signaling whether the encryption operation is a public key operation
	 * (i.e. encrypting data) or not, i.e. private key operation (data signing).
	 *
	 * For PKCS#1 v1.5 padding pass in the block type to use, i.e. either 0x01
	 * (for signing) or 0x02 (for encryption). The key operation mode (private
	 * or public) is derived from this flag in that case).
	 *
	 * @param m the message to encrypt as a byte string.
	 * @param key the RSA key to use.
	 * @param bt for PKCS#1 v1.5 padding, the block type to use
	 *   (0x01 for private key, 0x02 for public),
	 *   to disable padding: true = public key, false = private key.
	 *
	 * @return the encrypted bytes as a string.
	 */
	pki$1.rsa.encrypt = function(m, key, bt) {
	  var pub = bt;
	  var eb;

	  // get the length of the modulus in bytes
	  var k = Math.ceil(key.n.bitLength() / 8);

	  if(bt !== false && bt !== true) {
	    // legacy, default to PKCS#1 v1.5 padding
	    pub = (bt === 0x02);
	    eb = _encodePkcs1_v1_5(m, key, bt);
	  } else {
	    eb = forge.util.createBuffer();
	    eb.putBytes(m);
	  }

	  // load encryption block as big integer 'x'
	  // FIXME: hex conversion inefficient, get BigInteger w/byte strings
	  var x = new BigInteger$4(eb.toHex(), 16);

	  // do RSA encryption
	  var y = _modPow(x, key, pub);

	  // convert y into the encrypted data byte string, if y is shorter in
	  // bytes than k, then prepend zero bytes to fill up ed
	  // FIXME: hex conversion inefficient, get BigInteger w/byte strings
	  var yhex = y.toString(16);
	  var ed = forge.util.createBuffer();
	  var zeros = k - Math.ceil(yhex.length / 2);
	  while(zeros > 0) {
	    ed.putByte(0x00);
	    --zeros;
	  }
	  ed.putBytes(forge.util.hexToBytes(yhex));
	  return ed.getBytes();
	};

	/**
	 * NOTE: THIS METHOD IS DEPRECATED, use 'decrypt' on a private key object or
	 * 'verify' on a public key object instead.
	 *
	 * Performs RSA decryption.
	 *
	 * The parameter ml controls whether to apply PKCS#1 v1.5 padding
	 * or not.  Set ml = false to disable padding removal completely
	 * (in order to handle e.g. EMSA-PSS later on) and simply pass back
	 * the RSA encryption block.
	 *
	 * @param ed the encrypted data to decrypt in as a byte string.
	 * @param key the RSA key to use.
	 * @param pub true for a public key operation, false for private.
	 * @param ml the message length, if known, false to disable padding.
	 *
	 * @return the decrypted message as a byte string.
	 */
	pki$1.rsa.decrypt = function(ed, key, pub, ml) {
	  // get the length of the modulus in bytes
	  var k = Math.ceil(key.n.bitLength() / 8);

	  // error if the length of the encrypted data ED is not k
	  if(ed.length !== k) {
	    var error = new Error('Encrypted message length is invalid.');
	    error.length = ed.length;
	    error.expected = k;
	    throw error;
	  }

	  // convert encrypted data into a big integer
	  // FIXME: hex conversion inefficient, get BigInteger w/byte strings
	  var y = new BigInteger$4(forge.util.createBuffer(ed).toHex(), 16);

	  // y must be less than the modulus or it wasn't the result of
	  // a previous mod operation (encryption) using that modulus
	  if(y.compareTo(key.n) >= 0) {
	    throw new Error('Encrypted message is invalid.');
	  }

	  // do RSA decryption
	  var x = _modPow(y, key, pub);

	  // create the encryption block, if x is shorter in bytes than k, then
	  // prepend zero bytes to fill up eb
	  // FIXME: hex conversion inefficient, get BigInteger w/byte strings
	  var xhex = x.toString(16);
	  var eb = forge.util.createBuffer();
	  var zeros = k - Math.ceil(xhex.length / 2);
	  while(zeros > 0) {
	    eb.putByte(0x00);
	    --zeros;
	  }
	  eb.putBytes(forge.util.hexToBytes(xhex));

	  if(ml !== false) {
	    // legacy, default to PKCS#1 v1.5 padding
	    return _decodePkcs1_v1_5(eb.getBytes(), key, pub);
	  }

	  // return message
	  return eb.getBytes();
	};

	/**
	 * Creates an RSA key-pair generation state object. It is used to allow
	 * key-generation to be performed in steps. It also allows for a UI to
	 * display progress updates.
	 *
	 * @param bits the size for the private key in bits, defaults to 2048.
	 * @param e the public exponent to use, defaults to 65537 (0x10001).
	 * @param [options] the options to use.
	 *          prng a custom crypto-secure pseudo-random number generator to use,
	 *            that must define "getBytesSync".
	 *          algorithm the algorithm to use (default: 'PRIMEINC').
	 *
	 * @return the state object to use to generate the key-pair.
	 */
	pki$1.rsa.createKeyPairGenerationState = function(bits, e, options) {
	  // TODO: migrate step-based prime generation code to forge.prime

	  // set default bits
	  if(typeof(bits) === 'string') {
	    bits = parseInt(bits, 10);
	  }
	  bits = bits || 2048;

	  // create prng with api that matches BigInteger secure random
	  options = options || {};
	  var prng = options.prng || forge.random;
	  var rng = {
	    // x is an array to fill with bytes
	    nextBytes: function(x) {
	      var b = prng.getBytesSync(x.length);
	      for(var i = 0; i < x.length; ++i) {
	        x[i] = b.charCodeAt(i);
	      }
	    }
	  };

	  var algorithm = options.algorithm || 'PRIMEINC';

	  // create PRIMEINC algorithm state
	  var rval;
	  if(algorithm === 'PRIMEINC') {
	    rval = {
	      algorithm: algorithm,
	      state: 0,
	      bits: bits,
	      rng: rng,
	      eInt: e || 65537,
	      e: new BigInteger$4(null),
	      p: null,
	      q: null,
	      qBits: bits >> 1,
	      pBits: bits - (bits >> 1),
	      pqState: 0,
	      num: null,
	      keys: null
	    };
	    rval.e.fromInt(rval.eInt);
	  } else {
	    throw new Error('Invalid key generation algorithm: ' + algorithm);
	  }

	  return rval;
	};

	/**
	 * Attempts to runs the key-generation algorithm for at most n seconds
	 * (approximately) using the given state. When key-generation has completed,
	 * the keys will be stored in state.keys.
	 *
	 * To use this function to update a UI while generating a key or to prevent
	 * causing browser lockups/warnings, set "n" to a value other than 0. A
	 * simple pattern for generating a key and showing a progress indicator is:
	 *
	 * var state = pki.rsa.createKeyPairGenerationState(2048);
	 * var step = function() {
	 *   // step key-generation, run algorithm for 100 ms, repeat
	 *   if(!forge.pki.rsa.stepKeyPairGenerationState(state, 100)) {
	 *     setTimeout(step, 1);
	 *   } else {
	 *     // key-generation complete
	 *     // TODO: turn off progress indicator here
	 *     // TODO: use the generated key-pair in "state.keys"
	 *   }
	 * };
	 * // TODO: turn on progress indicator here
	 * setTimeout(step, 0);
	 *
	 * @param state the state to use.
	 * @param n the maximum number of milliseconds to run the algorithm for, 0
	 *          to run the algorithm to completion.
	 *
	 * @return true if the key-generation completed, false if not.
	 */
	pki$1.rsa.stepKeyPairGenerationState = function(state, n) {
	  // set default algorithm if not set
	  if(!('algorithm' in state)) {
	    state.algorithm = 'PRIMEINC';
	  }

	  // TODO: migrate step-based prime generation code to forge.prime
	  // TODO: abstract as PRIMEINC algorithm

	  // do key generation (based on Tom Wu's rsa.js, see jsbn.js license)
	  // with some minor optimizations and designed to run in steps

	  // local state vars
	  var THIRTY = new BigInteger$4(null);
	  THIRTY.fromInt(30);
	  var deltaIdx = 0;
	  var op_or = function(x, y) {return x | y;};

	  // keep stepping until time limit is reached or done
	  var t1 = +new Date();
	  var t2;
	  var total = 0;
	  while(state.keys === null && (n <= 0 || total < n)) {
	    // generate p or q
	    if(state.state === 0) {
	      /* Note: All primes are of the form:

	        30k+i, for i < 30 and gcd(30, i)=1, where there are 8 values for i

	        When we generate a random number, we always align it at 30k + 1. Each
	        time the number is determined not to be prime we add to get to the
	        next 'i', eg: if the number was at 30k + 1 we add 6. */
	      var bits = (state.p === null) ? state.pBits : state.qBits;
	      var bits1 = bits - 1;

	      // get a random number
	      if(state.pqState === 0) {
	        state.num = new BigInteger$4(bits, state.rng);
	        // force MSB set
	        if(!state.num.testBit(bits1)) {
	          state.num.bitwiseTo(
	            BigInteger$4.ONE.shiftLeft(bits1), op_or, state.num);
	        }
	        // align number on 30k+1 boundary
	        state.num.dAddOffset(31 - state.num.mod(THIRTY).byteValue(), 0);
	        deltaIdx = 0;

	        ++state.pqState;
	      } else if(state.pqState === 1) {
	        // try to make the number a prime
	        if(state.num.bitLength() > bits) {
	          // overflow, try again
	          state.pqState = 0;
	          // do primality test
	        } else if(state.num.isProbablePrime(
	          _getMillerRabinTests(state.num.bitLength()))) {
	          ++state.pqState;
	        } else {
	          // get next potential prime
	          state.num.dAddOffset(GCD_30_DELTA[deltaIdx++ % 8], 0);
	        }
	      } else if(state.pqState === 2) {
	        // ensure number is coprime with e
	        state.pqState =
	          (state.num.subtract(BigInteger$4.ONE).gcd(state.e)
	            .compareTo(BigInteger$4.ONE) === 0) ? 3 : 0;
	      } else if(state.pqState === 3) {
	        // store p or q
	        state.pqState = 0;
	        if(state.p === null) {
	          state.p = state.num;
	        } else {
	          state.q = state.num;
	        }

	        // advance state if both p and q are ready
	        if(state.p !== null && state.q !== null) {
	          ++state.state;
	        }
	        state.num = null;
	      }
	    } else if(state.state === 1) {
	      // ensure p is larger than q (swap them if not)
	      if(state.p.compareTo(state.q) < 0) {
	        state.num = state.p;
	        state.p = state.q;
	        state.q = state.num;
	      }
	      ++state.state;
	    } else if(state.state === 2) {
	      // compute phi: (p - 1)(q - 1) (Euler's totient function)
	      state.p1 = state.p.subtract(BigInteger$4.ONE);
	      state.q1 = state.q.subtract(BigInteger$4.ONE);
	      state.phi = state.p1.multiply(state.q1);
	      ++state.state;
	    } else if(state.state === 3) {
	      // ensure e and phi are coprime
	      if(state.phi.gcd(state.e).compareTo(BigInteger$4.ONE) === 0) {
	        // phi and e are coprime, advance
	        ++state.state;
	      } else {
	        // phi and e aren't coprime, so generate a new p and q
	        state.p = null;
	        state.q = null;
	        state.state = 0;
	      }
	    } else if(state.state === 4) {
	      // create n, ensure n is has the right number of bits
	      state.n = state.p.multiply(state.q);

	      // ensure n is right number of bits
	      if(state.n.bitLength() === state.bits) {
	        // success, advance
	        ++state.state;
	      } else {
	        // failed, get new q
	        state.q = null;
	        state.state = 0;
	      }
	    } else if(state.state === 5) {
	      // set keys
	      var d = state.e.modInverse(state.phi);
	      state.keys = {
	        privateKey: pki$1.rsa.setPrivateKey(
	          state.n, state.e, d, state.p, state.q,
	          d.mod(state.p1), d.mod(state.q1),
	          state.q.modInverse(state.p)),
	        publicKey: pki$1.rsa.setPublicKey(state.n, state.e)
	      };
	    }

	    // update timing
	    t2 = +new Date();
	    total += t2 - t1;
	    t1 = t2;
	  }

	  return state.keys !== null;
	};

	/**
	 * Generates an RSA public-private key pair in a single call.
	 *
	 * To generate a key-pair in steps (to allow for progress updates and to
	 * prevent blocking or warnings in slow browsers) then use the key-pair
	 * generation state functions.
	 *
	 * To generate a key-pair asynchronously (either through web-workers, if
	 * available, or by breaking up the work on the main thread), pass a
	 * callback function.
	 *
	 * @param [bits] the size for the private key in bits, defaults to 2048.
	 * @param [e] the public exponent to use, defaults to 65537.
	 * @param [options] options for key-pair generation, if given then 'bits'
	 *            and 'e' must *not* be given:
	 *          bits the size for the private key in bits, (default: 2048).
	 *          e the public exponent to use, (default: 65537 (0x10001)).
	 *          workerScript the worker script URL.
	 *          workers the number of web workers (if supported) to use,
	 *            (default: 2).
	 *          workLoad the size of the work load, ie: number of possible prime
	 *            numbers for each web worker to check per work assignment,
	 *            (default: 100).
	 *          prng a custom crypto-secure pseudo-random number generator to use,
	 *            that must define "getBytesSync". Disables use of native APIs.
	 *          algorithm the algorithm to use (default: 'PRIMEINC').
	 * @param [callback(err, keypair)] called once the operation completes.
	 *
	 * @return an object with privateKey and publicKey properties.
	 */
	pki$1.rsa.generateKeyPair = function(bits, e, options, callback) {
	  // (bits), (options), (callback)
	  if(arguments.length === 1) {
	    if(typeof bits === 'object') {
	      options = bits;
	      bits = undefined;
	    } else if(typeof bits === 'function') {
	      callback = bits;
	      bits = undefined;
	    }
	  } else if(arguments.length === 2) {
	    // (bits, e), (bits, options), (bits, callback), (options, callback)
	    if(typeof bits === 'number') {
	      if(typeof e === 'function') {
	        callback = e;
	        e = undefined;
	      } else if(typeof e !== 'number') {
	        options = e;
	        e = undefined;
	      }
	    } else {
	      options = bits;
	      callback = e;
	      bits = undefined;
	      e = undefined;
	    }
	  } else if(arguments.length === 3) {
	    // (bits, e, options), (bits, e, callback), (bits, options, callback)
	    if(typeof e === 'number') {
	      if(typeof options === 'function') {
	        callback = options;
	        options = undefined;
	      }
	    } else {
	      callback = options;
	      options = e;
	      e = undefined;
	    }
	  }
	  options = options || {};
	  if(bits === undefined) {
	    bits = options.bits || 2048;
	  }
	  if(e === undefined) {
	    e = options.e || 0x10001;
	  }

	  // use native code if permitted, available, and parameters are acceptable
	  if(!forge.options.usePureJavaScript && !options.prng &&
	    bits >= 256 && bits <= 16384 && (e === 0x10001 || e === 3)) {
	    if(callback) {
	      // try native async
	      if(_detectNodeCrypto('generateKeyPair')) {
	        return _crypto.generateKeyPair('rsa', {
	          modulusLength: bits,
	          publicExponent: e,
	          publicKeyEncoding: {
	            type: 'spki',
	            format: 'pem'
	          },
	          privateKeyEncoding: {
	            type: 'pkcs8',
	            format: 'pem'
	          }
	        }, function(err, pub, priv) {
	          if(err) {
	            return callback(err);
	          }
	          callback(null, {
	            privateKey: pki$1.privateKeyFromPem(priv),
	            publicKey: pki$1.publicKeyFromPem(pub)
	          });
	        });
	      }
	      if(_detectSubtleCrypto('generateKey') &&
	        _detectSubtleCrypto('exportKey')) {
	        // use standard native generateKey
	        return util.globalScope.crypto.subtle.generateKey({
	          name: 'RSASSA-PKCS1-v1_5',
	          modulusLength: bits,
	          publicExponent: _intToUint8Array(e),
	          hash: {name: 'SHA-256'}
	        }, true /* key can be exported*/, ['sign', 'verify'])
	        .then(function(pair) {
	          return util.globalScope.crypto.subtle.exportKey(
	            'pkcs8', pair.privateKey);
	        // avoiding catch(function(err) {...}) to support IE <= 8
	        }).then(undefined, function(err) {
	          callback(err);
	        }).then(function(pkcs8) {
	          if(pkcs8) {
	            var privateKey = pki$1.privateKeyFromAsn1(
	              asn1$2.fromDer(forge.util.createBuffer(pkcs8)));
	            callback(null, {
	              privateKey: privateKey,
	              publicKey: pki$1.setRsaPublicKey(privateKey.n, privateKey.e)
	            });
	          }
	        });
	      }
	      if(_detectSubtleMsCrypto('generateKey') &&
	        _detectSubtleMsCrypto('exportKey')) {
	        var genOp = util.globalScope.msCrypto.subtle.generateKey({
	          name: 'RSASSA-PKCS1-v1_5',
	          modulusLength: bits,
	          publicExponent: _intToUint8Array(e),
	          hash: {name: 'SHA-256'}
	        }, true /* key can be exported*/, ['sign', 'verify']);
	        genOp.oncomplete = function(e) {
	          var pair = e.target.result;
	          var exportOp = util.globalScope.msCrypto.subtle.exportKey(
	            'pkcs8', pair.privateKey);
	          exportOp.oncomplete = function(e) {
	            var pkcs8 = e.target.result;
	            var privateKey = pki$1.privateKeyFromAsn1(
	              asn1$2.fromDer(forge.util.createBuffer(pkcs8)));
	            callback(null, {
	              privateKey: privateKey,
	              publicKey: pki$1.setRsaPublicKey(privateKey.n, privateKey.e)
	            });
	          };
	          exportOp.onerror = function(err) {
	            callback(err);
	          };
	        };
	        genOp.onerror = function(err) {
	          callback(err);
	        };
	        return;
	      }
	    } else {
	      // try native sync
	      if(_detectNodeCrypto('generateKeyPairSync')) {
	        var keypair = _crypto.generateKeyPairSync('rsa', {
	          modulusLength: bits,
	          publicExponent: e,
	          publicKeyEncoding: {
	            type: 'spki',
	            format: 'pem'
	          },
	          privateKeyEncoding: {
	            type: 'pkcs8',
	            format: 'pem'
	          }
	        });
	        return {
	          privateKey: pki$1.privateKeyFromPem(keypair.privateKey),
	          publicKey: pki$1.publicKeyFromPem(keypair.publicKey)
	        };
	      }
	    }
	  }

	  // use JavaScript implementation
	  var state = pki$1.rsa.createKeyPairGenerationState(bits, e, options);
	  if(!callback) {
	    pki$1.rsa.stepKeyPairGenerationState(state, 0);
	    return state.keys;
	  }
	  _generateKeyPair(state, options, callback);
	};

	/**
	 * Sets an RSA public key from BigIntegers modulus and exponent.
	 *
	 * @param n the modulus.
	 * @param e the exponent.
	 *
	 * @return the public key.
	 */
	pki$1.setRsaPublicKey = pki$1.rsa.setPublicKey = function(n, e) {
	  var key = {
	    n: n,
	    e: e
	  };

	  /**
	   * Encrypts the given data with this public key. Newer applications
	   * should use the 'RSA-OAEP' decryption scheme, 'RSAES-PKCS1-V1_5' is for
	   * legacy applications.
	   *
	   * @param data the byte string to encrypt.
	   * @param scheme the encryption scheme to use:
	   *          'RSAES-PKCS1-V1_5' (default),
	   *          'RSA-OAEP',
	   *          'RAW', 'NONE', or null to perform raw RSA encryption,
	   *          an object with an 'encode' property set to a function
	   *          with the signature 'function(data, key)' that returns
	   *          a binary-encoded string representing the encoded data.
	   * @param schemeOptions any scheme-specific options.
	   *
	   * @return the encrypted byte string.
	   */
	  key.encrypt = function(data, scheme, schemeOptions) {
	    if(typeof scheme === 'string') {
	      scheme = scheme.toUpperCase();
	    } else if(scheme === undefined) {
	      scheme = 'RSAES-PKCS1-V1_5';
	    }

	    if(scheme === 'RSAES-PKCS1-V1_5') {
	      scheme = {
	        encode: function(m, key, pub) {
	          return _encodePkcs1_v1_5(m, key, 0x02).getBytes();
	        }
	      };
	    } else if(scheme === 'RSA-OAEP' || scheme === 'RSAES-OAEP') {
	      scheme = {
	        encode: function(m, key) {
	          return forge.pkcs1.encode_rsa_oaep(key, m, schemeOptions);
	        }
	      };
	    } else if(['RAW', 'NONE', 'NULL', null].indexOf(scheme) !== -1) {
	      scheme = {encode: function(e) {return e;}};
	    } else if(typeof scheme === 'string') {
	      throw new Error('Unsupported encryption scheme: "' + scheme + '".');
	    }

	    // do scheme-based encoding then rsa encryption
	    var e = scheme.encode(data, key, true);
	    return pki$1.rsa.encrypt(e, key, true);
	  };

	  /**
	   * Verifies the given signature against the given digest.
	   *
	   * PKCS#1 supports multiple (currently two) signature schemes:
	   * RSASSA-PKCS1-V1_5 and RSASSA-PSS.
	   *
	   * By default this implementation uses the "old scheme", i.e.
	   * RSASSA-PKCS1-V1_5, in which case once RSA-decrypted, the
	   * signature is an OCTET STRING that holds a DigestInfo.
	   *
	   * DigestInfo ::= SEQUENCE {
	   *   digestAlgorithm DigestAlgorithmIdentifier,
	   *   digest Digest
	   * }
	   * DigestAlgorithmIdentifier ::= AlgorithmIdentifier
	   * Digest ::= OCTET STRING
	   *
	   * To perform PSS signature verification, provide an instance
	   * of Forge PSS object as the scheme parameter.
	   *
	   * @param digest the message digest hash to compare against the signature,
	   *          as a binary-encoded string.
	   * @param signature the signature to verify, as a binary-encoded string.
	   * @param scheme signature verification scheme to use:
	   *          'RSASSA-PKCS1-V1_5' or undefined for RSASSA PKCS#1 v1.5,
	   *          a Forge PSS object for RSASSA-PSS,
	   *          'NONE' or null for none, DigestInfo will not be expected, but
	   *            PKCS#1 v1.5 padding will still be used.
	   *
	   * @return true if the signature was verified, false if not.
	   */
	  key.verify = function(digest, signature, scheme) {
	    if(typeof scheme === 'string') {
	      scheme = scheme.toUpperCase();
	    } else if(scheme === undefined) {
	      scheme = 'RSASSA-PKCS1-V1_5';
	    }

	    if(scheme === 'RSASSA-PKCS1-V1_5') {
	      scheme = {
	        verify: function(digest, d) {
	          // remove padding
	          d = _decodePkcs1_v1_5(d, key, true);
	          // d is ASN.1 BER-encoded DigestInfo
	          var obj = asn1$2.fromDer(d);
	          // compare the given digest to the decrypted one
	          return digest === obj.value[1].value;
	        }
	      };
	    } else if(scheme === 'NONE' || scheme === 'NULL' || scheme === null) {
	      scheme = {
	        verify: function(digest, d) {
	          // remove padding
	          d = _decodePkcs1_v1_5(d, key, true);
	          return digest === d;
	        }
	      };
	    }

	    // do rsa decryption w/o any decoding, then verify -- which does decoding
	    var d = pki$1.rsa.decrypt(signature, key, true, false);
	    return scheme.verify(digest, d, key.n.bitLength());
	  };

	  return key;
	};

	/**
	 * Sets an RSA private key from BigIntegers modulus, exponent, primes,
	 * prime exponents, and modular multiplicative inverse.
	 *
	 * @param n the modulus.
	 * @param e the public exponent.
	 * @param d the private exponent ((inverse of e) mod n).
	 * @param p the first prime.
	 * @param q the second prime.
	 * @param dP exponent1 (d mod (p-1)).
	 * @param dQ exponent2 (d mod (q-1)).
	 * @param qInv ((inverse of q) mod p)
	 *
	 * @return the private key.
	 */
	pki$1.setRsaPrivateKey = pki$1.rsa.setPrivateKey = function(
	  n, e, d, p, q, dP, dQ, qInv) {
	  var key = {
	    n: n,
	    e: e,
	    d: d,
	    p: p,
	    q: q,
	    dP: dP,
	    dQ: dQ,
	    qInv: qInv
	  };

	  /**
	   * Decrypts the given data with this private key. The decryption scheme
	   * must match the one used to encrypt the data.
	   *
	   * @param data the byte string to decrypt.
	   * @param scheme the decryption scheme to use:
	   *          'RSAES-PKCS1-V1_5' (default),
	   *          'RSA-OAEP',
	   *          'RAW', 'NONE', or null to perform raw RSA decryption.
	   * @param schemeOptions any scheme-specific options.
	   *
	   * @return the decrypted byte string.
	   */
	  key.decrypt = function(data, scheme, schemeOptions) {
	    if(typeof scheme === 'string') {
	      scheme = scheme.toUpperCase();
	    } else if(scheme === undefined) {
	      scheme = 'RSAES-PKCS1-V1_5';
	    }

	    // do rsa decryption w/o any decoding
	    var d = pki$1.rsa.decrypt(data, key, false, false);

	    if(scheme === 'RSAES-PKCS1-V1_5') {
	      scheme = {decode: _decodePkcs1_v1_5};
	    } else if(scheme === 'RSA-OAEP' || scheme === 'RSAES-OAEP') {
	      scheme = {
	        decode: function(d, key) {
	          return forge.pkcs1.decode_rsa_oaep(key, d, schemeOptions);
	        }
	      };
	    } else if(['RAW', 'NONE', 'NULL', null].indexOf(scheme) !== -1) {
	      scheme = {decode: function(d) {return d;}};
	    } else {
	      throw new Error('Unsupported encryption scheme: "' + scheme + '".');
	    }

	    // decode according to scheme
	    return scheme.decode(d, key, false);
	  };

	  /**
	   * Signs the given digest, producing a signature.
	   *
	   * PKCS#1 supports multiple (currently two) signature schemes:
	   * RSASSA-PKCS1-V1_5 and RSASSA-PSS.
	   *
	   * By default this implementation uses the "old scheme", i.e.
	   * RSASSA-PKCS1-V1_5. In order to generate a PSS signature, provide
	   * an instance of Forge PSS object as the scheme parameter.
	   *
	   * @param md the message digest object with the hash to sign.
	   * @param scheme the signature scheme to use:
	   *          'RSASSA-PKCS1-V1_5' or undefined for RSASSA PKCS#1 v1.5,
	   *          a Forge PSS object for RSASSA-PSS,
	   *          'NONE' or null for none, DigestInfo will not be used but
	   *            PKCS#1 v1.5 padding will still be used.
	   *
	   * @return the signature as a byte string.
	   */
	  key.sign = function(md, scheme) {
	    /* Note: The internal implementation of RSA operations is being
	      transitioned away from a PKCS#1 v1.5 hard-coded scheme. Some legacy
	      code like the use of an encoding block identifier 'bt' will eventually
	      be removed. */

	    // private key operation
	    var bt = false;

	    if(typeof scheme === 'string') {
	      scheme = scheme.toUpperCase();
	    }

	    if(scheme === undefined || scheme === 'RSASSA-PKCS1-V1_5') {
	      scheme = {encode: emsaPkcs1v15encode};
	      bt = 0x01;
	    } else if(scheme === 'NONE' || scheme === 'NULL' || scheme === null) {
	      scheme = {encode: function() {return md;}};
	      bt = 0x01;
	    }

	    // encode and then encrypt
	    var d = scheme.encode(md, key.n.bitLength());
	    return pki$1.rsa.encrypt(d, key, bt);
	  };

	  return key;
	};

	/**
	 * Wraps an RSAPrivateKey ASN.1 object in an ASN.1 PrivateKeyInfo object.
	 *
	 * @param rsaKey the ASN.1 RSAPrivateKey.
	 *
	 * @return the ASN.1 PrivateKeyInfo.
	 */
	pki$1.wrapRsaPrivateKey = function(rsaKey) {
	  // PrivateKeyInfo
	  return asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.SEQUENCE, true, [
	    // version (0)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      asn1$2.integerToDer(0).getBytes()),
	    // privateKeyAlgorithm
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.SEQUENCE, true, [
	      asn1$2.create(
	        asn1$2.Class.UNIVERSAL, asn1$2.Type.OID, false,
	        asn1$2.oidToDer(pki$1.oids.rsaEncryption).getBytes()),
	      asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.NULL, false, '')
	    ]),
	    // PrivateKey
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.OCTETSTRING, false,
	      asn1$2.toDer(rsaKey).getBytes())
	  ]);
	};

	/**
	 * Converts a private key from an ASN.1 object.
	 *
	 * @param obj the ASN.1 representation of a PrivateKeyInfo containing an
	 *          RSAPrivateKey or an RSAPrivateKey.
	 *
	 * @return the private key.
	 */
	pki$1.privateKeyFromAsn1 = function(obj) {
	  // get PrivateKeyInfo
	  var capture = {};
	  var errors = [];
	  if(asn1$2.validate(obj, privateKeyValidator$2, capture, errors)) {
	    obj = asn1$2.fromDer(forge.util.createBuffer(capture.privateKey));
	  }

	  // get RSAPrivateKey
	  capture = {};
	  errors = [];
	  if(!asn1$2.validate(obj, rsaPrivateKeyValidator, capture, errors)) {
	    var error = new Error('Cannot read private key. ' +
	      'ASN.1 object does not contain an RSAPrivateKey.');
	    error.errors = errors;
	    throw error;
	  }

	  // Note: Version is currently ignored.
	  // capture.privateKeyVersion
	  // FIXME: inefficient, get a BigInteger that uses byte strings
	  var n, e, d, p, q, dP, dQ, qInv;
	  n = forge.util.createBuffer(capture.privateKeyModulus).toHex();
	  e = forge.util.createBuffer(capture.privateKeyPublicExponent).toHex();
	  d = forge.util.createBuffer(capture.privateKeyPrivateExponent).toHex();
	  p = forge.util.createBuffer(capture.privateKeyPrime1).toHex();
	  q = forge.util.createBuffer(capture.privateKeyPrime2).toHex();
	  dP = forge.util.createBuffer(capture.privateKeyExponent1).toHex();
	  dQ = forge.util.createBuffer(capture.privateKeyExponent2).toHex();
	  qInv = forge.util.createBuffer(capture.privateKeyCoefficient).toHex();

	  // set private key
	  return pki$1.setRsaPrivateKey(
	    new BigInteger$4(n, 16),
	    new BigInteger$4(e, 16),
	    new BigInteger$4(d, 16),
	    new BigInteger$4(p, 16),
	    new BigInteger$4(q, 16),
	    new BigInteger$4(dP, 16),
	    new BigInteger$4(dQ, 16),
	    new BigInteger$4(qInv, 16));
	};

	/**
	 * Converts a private key to an ASN.1 RSAPrivateKey.
	 *
	 * @param key the private key.
	 *
	 * @return the ASN.1 representation of an RSAPrivateKey.
	 */
	pki$1.privateKeyToAsn1 = pki$1.privateKeyToRSAPrivateKey = function(key) {
	  // RSAPrivateKey
	  return asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.SEQUENCE, true, [
	    // version (0 = only 2 primes, 1 multiple primes)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      asn1$2.integerToDer(0).getBytes()),
	    // modulus (n)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      _bnToBytes(key.n)),
	    // publicExponent (e)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      _bnToBytes(key.e)),
	    // privateExponent (d)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      _bnToBytes(key.d)),
	    // privateKeyPrime1 (p)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      _bnToBytes(key.p)),
	    // privateKeyPrime2 (q)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      _bnToBytes(key.q)),
	    // privateKeyExponent1 (dP)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      _bnToBytes(key.dP)),
	    // privateKeyExponent2 (dQ)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      _bnToBytes(key.dQ)),
	    // coefficient (qInv)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      _bnToBytes(key.qInv))
	  ]);
	};

	/**
	 * Converts a public key from an ASN.1 SubjectPublicKeyInfo or RSAPublicKey.
	 *
	 * @param obj the asn1 representation of a SubjectPublicKeyInfo or RSAPublicKey.
	 *
	 * @return the public key.
	 */
	pki$1.publicKeyFromAsn1 = function(obj) {
	  // get SubjectPublicKeyInfo
	  var capture = {};
	  var errors = [];
	  if(asn1$2.validate(obj, publicKeyValidator$2, capture, errors)) {
	    // get oid
	    var oid = asn1$2.derToOid(capture.publicKeyOid);
	    if(oid !== pki$1.oids.rsaEncryption) {
	      var error = new Error('Cannot read public key. Unknown OID.');
	      error.oid = oid;
	      throw error;
	    }
	    obj = capture.rsaPublicKey;
	  }

	  // get RSA params
	  errors = [];
	  if(!asn1$2.validate(obj, rsaPublicKeyValidator, capture, errors)) {
	    var error = new Error('Cannot read public key. ' +
	      'ASN.1 object does not contain an RSAPublicKey.');
	    error.errors = errors;
	    throw error;
	  }

	  // FIXME: inefficient, get a BigInteger that uses byte strings
	  var n = forge.util.createBuffer(capture.publicKeyModulus).toHex();
	  var e = forge.util.createBuffer(capture.publicKeyExponent).toHex();

	  // set public key
	  return pki$1.setRsaPublicKey(
	    new BigInteger$4(n, 16),
	    new BigInteger$4(e, 16));
	};

	/**
	 * Converts a public key to an ASN.1 SubjectPublicKeyInfo.
	 *
	 * @param key the public key.
	 *
	 * @return the asn1 representation of a SubjectPublicKeyInfo.
	 */
	pki$1.publicKeyToAsn1 = pki$1.publicKeyToSubjectPublicKeyInfo = function(key) {
	  // SubjectPublicKeyInfo
	  return asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.SEQUENCE, true, [
	    // AlgorithmIdentifier
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.SEQUENCE, true, [
	      // algorithm
	      asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.OID, false,
	        asn1$2.oidToDer(pki$1.oids.rsaEncryption).getBytes()),
	      // parameters (null)
	      asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.NULL, false, '')
	    ]),
	    // subjectPublicKey
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.BITSTRING, false, [
	      pki$1.publicKeyToRSAPublicKey(key)
	    ])
	  ]);
	};

	/**
	 * Converts a public key to an ASN.1 RSAPublicKey.
	 *
	 * @param key the public key.
	 *
	 * @return the asn1 representation of a RSAPublicKey.
	 */
	pki$1.publicKeyToRSAPublicKey = function(key) {
	  // RSAPublicKey
	  return asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.SEQUENCE, true, [
	    // modulus (n)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      _bnToBytes(key.n)),
	    // publicExponent (e)
	    asn1$2.create(asn1$2.Class.UNIVERSAL, asn1$2.Type.INTEGER, false,
	      _bnToBytes(key.e))
	  ]);
	};

	/**
	 * Encodes a message using PKCS#1 v1.5 padding.
	 *
	 * @param m the message to encode.
	 * @param key the RSA key to use.
	 * @param bt the block type to use, i.e. either 0x01 (for signing) or 0x02
	 *          (for encryption).
	 *
	 * @return the padded byte buffer.
	 */
	function _encodePkcs1_v1_5(m, key, bt) {
	  var eb = forge.util.createBuffer();

	  // get the length of the modulus in bytes
	  var k = Math.ceil(key.n.bitLength() / 8);

	  /* use PKCS#1 v1.5 padding */
	  if(m.length > (k - 11)) {
	    var error = new Error('Message is too long for PKCS#1 v1.5 padding.');
	    error.length = m.length;
	    error.max = k - 11;
	    throw error;
	  }

	  /* A block type BT, a padding string PS, and the data D shall be
	    formatted into an octet string EB, the encryption block:

	    EB = 00 || BT || PS || 00 || D

	    The block type BT shall be a single octet indicating the structure of
	    the encryption block. For this version of the document it shall have
	    value 00, 01, or 02. For a private-key operation, the block type
	    shall be 00 or 01. For a public-key operation, it shall be 02.

	    The padding string PS shall consist of k-3-||D|| octets. For block
	    type 00, the octets shall have value 00; for block type 01, they
	    shall have value FF; and for block type 02, they shall be
	    pseudorandomly generated and nonzero. This makes the length of the
	    encryption block EB equal to k. */

	  // build the encryption block
	  eb.putByte(0x00);
	  eb.putByte(bt);

	  // create the padding
	  var padNum = k - 3 - m.length;
	  var padByte;
	  // private key op
	  if(bt === 0x00 || bt === 0x01) {
	    padByte = (bt === 0x00) ? 0x00 : 0xFF;
	    for(var i = 0; i < padNum; ++i) {
	      eb.putByte(padByte);
	    }
	  } else {
	    // public key op
	    // pad with random non-zero values
	    while(padNum > 0) {
	      var numZeros = 0;
	      var padBytes = forge.random.getBytes(padNum);
	      for(var i = 0; i < padNum; ++i) {
	        padByte = padBytes.charCodeAt(i);
	        if(padByte === 0) {
	          ++numZeros;
	        } else {
	          eb.putByte(padByte);
	        }
	      }
	      padNum = numZeros;
	    }
	  }

	  // zero followed by message
	  eb.putByte(0x00);
	  eb.putBytes(m);

	  return eb;
	}

	/**
	 * Decodes a message using PKCS#1 v1.5 padding.
	 *
	 * @param em the message to decode.
	 * @param key the RSA key to use.
	 * @param pub true if the key is a public key, false if it is private.
	 * @param ml the message length, if specified.
	 *
	 * @return the decoded bytes.
	 */
	function _decodePkcs1_v1_5(em, key, pub, ml) {
	  // get the length of the modulus in bytes
	  var k = Math.ceil(key.n.bitLength() / 8);

	  /* It is an error if any of the following conditions occurs:

	    1. The encryption block EB cannot be parsed unambiguously.
	    2. The padding string PS consists of fewer than eight octets
	      or is inconsisent with the block type BT.
	    3. The decryption process is a public-key operation and the block
	      type BT is not 00 or 01, or the decryption process is a
	      private-key operation and the block type is not 02.
	   */

	  // parse the encryption block
	  var eb = forge.util.createBuffer(em);
	  var first = eb.getByte();
	  var bt = eb.getByte();
	  if(first !== 0x00 ||
	    (pub && bt !== 0x00 && bt !== 0x01) ||
	    (!pub && bt != 0x02) ||
	    (pub && bt === 0x00 && typeof(ml) === 'undefined')) {
	    throw new Error('Encryption block is invalid.');
	  }

	  var padNum = 0;
	  if(bt === 0x00) {
	    // check all padding bytes for 0x00
	    padNum = k - 3 - ml;
	    for(var i = 0; i < padNum; ++i) {
	      if(eb.getByte() !== 0x00) {
	        throw new Error('Encryption block is invalid.');
	      }
	    }
	  } else if(bt === 0x01) {
	    // find the first byte that isn't 0xFF, should be after all padding
	    padNum = 0;
	    while(eb.length() > 1) {
	      if(eb.getByte() !== 0xFF) {
	        --eb.read;
	        break;
	      }
	      ++padNum;
	    }
	  } else if(bt === 0x02) {
	    // look for 0x00 byte
	    padNum = 0;
	    while(eb.length() > 1) {
	      if(eb.getByte() === 0x00) {
	        --eb.read;
	        break;
	      }
	      ++padNum;
	    }
	  }

	  // zero must be 0x00 and padNum must be (k - 3 - message length)
	  var zero = eb.getByte();
	  if(zero !== 0x00 || padNum !== (k - 3 - eb.length())) {
	    throw new Error('Encryption block is invalid.');
	  }

	  return eb.getBytes();
	}

	/**
	 * Runs the key-generation algorithm asynchronously, either in the background
	 * via Web Workers, or using the main thread and setImmediate.
	 *
	 * @param state the key-pair generation state.
	 * @param [options] options for key-pair generation:
	 *          workerScript the worker script URL.
	 *          workers the number of web workers (if supported) to use,
	 *            (default: 2, -1 to use estimated cores minus one).
	 *          workLoad the size of the work load, ie: number of possible prime
	 *            numbers for each web worker to check per work assignment,
	 *            (default: 100).
	 * @param callback(err, keypair) called once the operation completes.
	 */
	function _generateKeyPair(state, options, callback) {
	  if(typeof options === 'function') {
	    callback = options;
	    options = {};
	  }
	  options = options || {};

	  var opts = {
	    algorithm: {
	      name: options.algorithm || 'PRIMEINC',
	      options: {
	        workers: options.workers || 2,
	        workLoad: options.workLoad || 100,
	        workerScript: options.workerScript
	      }
	    }
	  };
	  if('prng' in options) {
	    opts.prng = options.prng;
	  }

	  generate();

	  function generate() {
	    // find p and then q (done in series to simplify)
	    getPrime(state.pBits, function(err, num) {
	      if(err) {
	        return callback(err);
	      }
	      state.p = num;
	      if(state.q !== null) {
	        return finish(err, state.q);
	      }
	      getPrime(state.qBits, finish);
	    });
	  }

	  function getPrime(bits, callback) {
	    forge.prime.generateProbablePrime(bits, opts, callback);
	  }

	  function finish(err, num) {
	    if(err) {
	      return callback(err);
	    }

	    // set q
	    state.q = num;

	    // ensure p is larger than q (swap them if not)
	    if(state.p.compareTo(state.q) < 0) {
	      var tmp = state.p;
	      state.p = state.q;
	      state.q = tmp;
	    }

	    // ensure p is coprime with e
	    if(state.p.subtract(BigInteger$4.ONE).gcd(state.e)
	      .compareTo(BigInteger$4.ONE) !== 0) {
	      state.p = null;
	      generate();
	      return;
	    }

	    // ensure q is coprime with e
	    if(state.q.subtract(BigInteger$4.ONE).gcd(state.e)
	      .compareTo(BigInteger$4.ONE) !== 0) {
	      state.q = null;
	      getPrime(state.qBits, finish);
	      return;
	    }

	    // compute phi: (p - 1)(q - 1) (Euler's totient function)
	    state.p1 = state.p.subtract(BigInteger$4.ONE);
	    state.q1 = state.q.subtract(BigInteger$4.ONE);
	    state.phi = state.p1.multiply(state.q1);

	    // ensure e and phi are coprime
	    if(state.phi.gcd(state.e).compareTo(BigInteger$4.ONE) !== 0) {
	      // phi and e aren't coprime, so generate a new p and q
	      state.p = state.q = null;
	      generate();
	      return;
	    }

	    // create n, ensure n is has the right number of bits
	    state.n = state.p.multiply(state.q);
	    if(state.n.bitLength() !== state.bits) {
	      // failed, get new q
	      state.q = null;
	      getPrime(state.qBits, finish);
	      return;
	    }

	    // set keys
	    var d = state.e.modInverse(state.phi);
	    state.keys = {
	      privateKey: pki$1.rsa.setPrivateKey(
	        state.n, state.e, d, state.p, state.q,
	        d.mod(state.p1), d.mod(state.q1),
	        state.q.modInverse(state.p)),
	      publicKey: pki$1.rsa.setPublicKey(state.n, state.e)
	    };

	    callback(null, state.keys);
	  }
	}

	/**
	 * Converts a positive BigInteger into 2's-complement big-endian bytes.
	 *
	 * @param b the big integer to convert.
	 *
	 * @return the bytes.
	 */
	function _bnToBytes(b) {
	  // prepend 0x00 if first byte >= 0x80
	  var hex = b.toString(16);
	  if(hex[0] >= '8') {
	    hex = '00' + hex;
	  }
	  var bytes = forge.util.hexToBytes(hex);

	  // ensure integer is minimally-encoded
	  if(bytes.length > 1 &&
	    // leading 0x00 for positive integer
	    ((bytes.charCodeAt(0) === 0 &&
	    (bytes.charCodeAt(1) & 0x80) === 0) ||
	    // leading 0xFF for negative integer
	    (bytes.charCodeAt(0) === 0xFF &&
	    (bytes.charCodeAt(1) & 0x80) === 0x80))) {
	    return bytes.substr(1);
	  }
	  return bytes;
	}

	/**
	 * Returns the required number of Miller-Rabin tests to generate a
	 * prime with an error probability of (1/2)^80.
	 *
	 * See Handbook of Applied Cryptography Chapter 4, Table 4.4.
	 *
	 * @param bits the bit size.
	 *
	 * @return the required number of iterations.
	 */
	function _getMillerRabinTests(bits) {
	  if(bits <= 100) return 27;
	  if(bits <= 150) return 18;
	  if(bits <= 200) return 15;
	  if(bits <= 250) return 12;
	  if(bits <= 300) return 9;
	  if(bits <= 350) return 8;
	  if(bits <= 400) return 7;
	  if(bits <= 500) return 6;
	  if(bits <= 600) return 5;
	  if(bits <= 800) return 4;
	  if(bits <= 1250) return 3;
	  return 2;
	}

	/**
	 * Performs feature detection on the Node crypto interface.
	 *
	 * @param fn the feature (function) to detect.
	 *
	 * @return true if detected, false if not.
	 */
	function _detectNodeCrypto(fn) {
	  return forge.util.isNodejs && typeof _crypto[fn] === 'function';
	}

	/**
	 * Performs feature detection on the SubtleCrypto interface.
	 *
	 * @param fn the feature (function) to detect.
	 *
	 * @return true if detected, false if not.
	 */
	function _detectSubtleCrypto(fn) {
	  return (typeof util.globalScope !== 'undefined' &&
	    typeof util.globalScope.crypto === 'object' &&
	    typeof util.globalScope.crypto.subtle === 'object' &&
	    typeof util.globalScope.crypto.subtle[fn] === 'function');
	}

	/**
	 * Performs feature detection on the deprecated Microsoft Internet Explorer
	 * outdated SubtleCrypto interface. This function should only be used after
	 * checking for the modern, standard SubtleCrypto interface.
	 *
	 * @param fn the feature (function) to detect.
	 *
	 * @return true if detected, false if not.
	 */
	function _detectSubtleMsCrypto(fn) {
	  return (typeof util.globalScope !== 'undefined' &&
	    typeof util.globalScope.msCrypto === 'object' &&
	    typeof util.globalScope.msCrypto.subtle === 'object' &&
	    typeof util.globalScope.msCrypto.subtle[fn] === 'function');
	}

	function _intToUint8Array(x) {
	  var bytes = forge.util.hexToBytes(x.toString(16));
	  var buffer = new Uint8Array(bytes.length);
	  for(var i = 0; i < bytes.length; ++i) {
	    buffer[i] = bytes.charCodeAt(i);
	  }
	  return buffer;
	}

	/**
	 * Password-based encryption functions.
	 *
	 * @author Dave Longley
	 * @author Stefan Siegl <stesie@brokenpipe.de>
	 *
	 * Copyright (c) 2010-2013 Digital Bazaar, Inc.
	 * Copyright (c) 2012 Stefan Siegl <stesie@brokenpipe.de>
	 *
	 * An EncryptedPrivateKeyInfo:
	 *
	 * EncryptedPrivateKeyInfo ::= SEQUENCE {
	 *   encryptionAlgorithm  EncryptionAlgorithmIdentifier,
	 *   encryptedData        EncryptedData }
	 *
	 * EncryptionAlgorithmIdentifier ::= AlgorithmIdentifier
	 *
	 * EncryptedData ::= OCTET STRING
	 */













	if(typeof BigInteger$3 === 'undefined') {
	  var BigInteger$3 = forge.jsbn.BigInteger;
	}

	// shortcut for asn.1 API
	var asn1$1 = forge.asn1;

	/* Password-based encryption implementation. */
	var pki = forge.pki = forge.pki || {};
	pki.pbe = forge.pbe = forge.pbe || {};
	var oids = pki.oids;

	// validator for an EncryptedPrivateKeyInfo structure
	// Note: Currently only works w/algorithm params
	var encryptedPrivateKeyValidator = {
	  name: 'EncryptedPrivateKeyInfo',
	  tagClass: asn1$1.Class.UNIVERSAL,
	  type: asn1$1.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    name: 'EncryptedPrivateKeyInfo.encryptionAlgorithm',
	    tagClass: asn1$1.Class.UNIVERSAL,
	    type: asn1$1.Type.SEQUENCE,
	    constructed: true,
	    value: [{
	      name: 'AlgorithmIdentifier.algorithm',
	      tagClass: asn1$1.Class.UNIVERSAL,
	      type: asn1$1.Type.OID,
	      constructed: false,
	      capture: 'encryptionOid'
	    }, {
	      name: 'AlgorithmIdentifier.parameters',
	      tagClass: asn1$1.Class.UNIVERSAL,
	      type: asn1$1.Type.SEQUENCE,
	      constructed: true,
	      captureAsn1: 'encryptionParams'
	    }]
	  }, {
	    // encryptedData
	    name: 'EncryptedPrivateKeyInfo.encryptedData',
	    tagClass: asn1$1.Class.UNIVERSAL,
	    type: asn1$1.Type.OCTETSTRING,
	    constructed: false,
	    capture: 'encryptedData'
	  }]
	};

	// validator for a PBES2Algorithms structure
	// Note: Currently only works w/PBKDF2 + AES encryption schemes
	var PBES2AlgorithmsValidator = {
	  name: 'PBES2Algorithms',
	  tagClass: asn1$1.Class.UNIVERSAL,
	  type: asn1$1.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    name: 'PBES2Algorithms.keyDerivationFunc',
	    tagClass: asn1$1.Class.UNIVERSAL,
	    type: asn1$1.Type.SEQUENCE,
	    constructed: true,
	    value: [{
	      name: 'PBES2Algorithms.keyDerivationFunc.oid',
	      tagClass: asn1$1.Class.UNIVERSAL,
	      type: asn1$1.Type.OID,
	      constructed: false,
	      capture: 'kdfOid'
	    }, {
	      name: 'PBES2Algorithms.params',
	      tagClass: asn1$1.Class.UNIVERSAL,
	      type: asn1$1.Type.SEQUENCE,
	      constructed: true,
	      value: [{
	        name: 'PBES2Algorithms.params.salt',
	        tagClass: asn1$1.Class.UNIVERSAL,
	        type: asn1$1.Type.OCTETSTRING,
	        constructed: false,
	        capture: 'kdfSalt'
	      }, {
	        name: 'PBES2Algorithms.params.iterationCount',
	        tagClass: asn1$1.Class.UNIVERSAL,
	        type: asn1$1.Type.INTEGER,
	        constructed: false,
	        capture: 'kdfIterationCount'
	      }, {
	        name: 'PBES2Algorithms.params.keyLength',
	        tagClass: asn1$1.Class.UNIVERSAL,
	        type: asn1$1.Type.INTEGER,
	        constructed: false,
	        optional: true,
	        capture: 'keyLength'
	      }, {
	        // prf
	        name: 'PBES2Algorithms.params.prf',
	        tagClass: asn1$1.Class.UNIVERSAL,
	        type: asn1$1.Type.SEQUENCE,
	        constructed: true,
	        optional: true,
	        value: [{
	          name: 'PBES2Algorithms.params.prf.algorithm',
	          tagClass: asn1$1.Class.UNIVERSAL,
	          type: asn1$1.Type.OID,
	          constructed: false,
	          capture: 'prfOid'
	        }]
	      }]
	    }]
	  }, {
	    name: 'PBES2Algorithms.encryptionScheme',
	    tagClass: asn1$1.Class.UNIVERSAL,
	    type: asn1$1.Type.SEQUENCE,
	    constructed: true,
	    value: [{
	      name: 'PBES2Algorithms.encryptionScheme.oid',
	      tagClass: asn1$1.Class.UNIVERSAL,
	      type: asn1$1.Type.OID,
	      constructed: false,
	      capture: 'encOid'
	    }, {
	      name: 'PBES2Algorithms.encryptionScheme.iv',
	      tagClass: asn1$1.Class.UNIVERSAL,
	      type: asn1$1.Type.OCTETSTRING,
	      constructed: false,
	      capture: 'encIv'
	    }]
	  }]
	};

	var pkcs12PbeParamsValidator = {
	  name: 'pkcs-12PbeParams',
	  tagClass: asn1$1.Class.UNIVERSAL,
	  type: asn1$1.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    name: 'pkcs-12PbeParams.salt',
	    tagClass: asn1$1.Class.UNIVERSAL,
	    type: asn1$1.Type.OCTETSTRING,
	    constructed: false,
	    capture: 'salt'
	  }, {
	    name: 'pkcs-12PbeParams.iterations',
	    tagClass: asn1$1.Class.UNIVERSAL,
	    type: asn1$1.Type.INTEGER,
	    constructed: false,
	    capture: 'iterations'
	  }]
	};

	/**
	 * Encrypts a ASN.1 PrivateKeyInfo object, producing an EncryptedPrivateKeyInfo.
	 *
	 * PBES2Algorithms ALGORITHM-IDENTIFIER ::=
	 *   { {PBES2-params IDENTIFIED BY id-PBES2}, ...}
	 *
	 * id-PBES2 OBJECT IDENTIFIER ::= {pkcs-5 13}
	 *
	 * PBES2-params ::= SEQUENCE {
	 *   keyDerivationFunc AlgorithmIdentifier {{PBES2-KDFs}},
	 *   encryptionScheme AlgorithmIdentifier {{PBES2-Encs}}
	 * }
	 *
	 * PBES2-KDFs ALGORITHM-IDENTIFIER ::=
	 *   { {PBKDF2-params IDENTIFIED BY id-PBKDF2}, ... }
	 *
	 * PBES2-Encs ALGORITHM-IDENTIFIER ::= { ... }
	 *
	 * PBKDF2-params ::= SEQUENCE {
	 *   salt CHOICE {
	 *     specified OCTET STRING,
	 *     otherSource AlgorithmIdentifier {{PBKDF2-SaltSources}}
	 *   },
	 *   iterationCount INTEGER (1..MAX),
	 *   keyLength INTEGER (1..MAX) OPTIONAL,
	 *   prf AlgorithmIdentifier {{PBKDF2-PRFs}} DEFAULT algid-hmacWithSHA1
	 * }
	 *
	 * @param obj the ASN.1 PrivateKeyInfo object.
	 * @param password the password to encrypt with.
	 * @param options:
	 *          algorithm the encryption algorithm to use
	 *            ('aes128', 'aes192', 'aes256', '3des'), defaults to 'aes128'.
	 *          count the iteration count to use.
	 *          saltSize the salt size to use.
	 *          prfAlgorithm the PRF message digest algorithm to use
	 *            ('sha1', 'sha224', 'sha256', 'sha384', 'sha512')
	 *
	 * @return the ASN.1 EncryptedPrivateKeyInfo.
	 */
	pki.encryptPrivateKeyInfo = function(obj, password, options) {
	  // set default options
	  options = options || {};
	  options.saltSize = options.saltSize || 8;
	  options.count = options.count || 2048;
	  options.algorithm = options.algorithm || 'aes128';
	  options.prfAlgorithm = options.prfAlgorithm || 'sha1';

	  // generate PBE params
	  var salt = forge.random.getBytesSync(options.saltSize);
	  var count = options.count;
	  var countBytes = asn1$1.integerToDer(count);
	  var dkLen;
	  var encryptionAlgorithm;
	  var encryptedData;
	  if(options.algorithm.indexOf('aes') === 0 || options.algorithm === 'des') {
	    // do PBES2
	    var ivLen, encOid, cipherFn;
	    switch(options.algorithm) {
	    case 'aes128':
	      dkLen = 16;
	      ivLen = 16;
	      encOid = oids['aes128-CBC'];
	      cipherFn = forge.aes.createEncryptionCipher;
	      break;
	    case 'aes192':
	      dkLen = 24;
	      ivLen = 16;
	      encOid = oids['aes192-CBC'];
	      cipherFn = forge.aes.createEncryptionCipher;
	      break;
	    case 'aes256':
	      dkLen = 32;
	      ivLen = 16;
	      encOid = oids['aes256-CBC'];
	      cipherFn = forge.aes.createEncryptionCipher;
	      break;
	    case 'des':
	      dkLen = 8;
	      ivLen = 8;
	      encOid = oids['desCBC'];
	      cipherFn = forge.des.createEncryptionCipher;
	      break;
	    default:
	      var error = new Error('Cannot encrypt private key. Unknown encryption algorithm.');
	      error.algorithm = options.algorithm;
	      throw error;
	    }

	    // get PRF message digest
	    var prfAlgorithm = 'hmacWith' + options.prfAlgorithm.toUpperCase();
	    var md = prfAlgorithmToMessageDigest(prfAlgorithm);

	    // encrypt private key using pbe SHA-1 and AES/DES
	    var dk = forge.pkcs5.pbkdf2(password, salt, count, dkLen, md);
	    var iv = forge.random.getBytesSync(ivLen);
	    var cipher = cipherFn(dk);
	    cipher.start(iv);
	    cipher.update(asn1$1.toDer(obj));
	    cipher.finish();
	    encryptedData = cipher.output.getBytes();

	    // get PBKDF2-params
	    var params = createPbkdf2Params(salt, countBytes, dkLen, prfAlgorithm);

	    encryptionAlgorithm = asn1$1.create(
	      asn1$1.Class.UNIVERSAL, asn1$1.Type.SEQUENCE, true, [
	      asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.OID, false,
	        asn1$1.oidToDer(oids['pkcs5PBES2']).getBytes()),
	      asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.SEQUENCE, true, [
	        // keyDerivationFunc
	        asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.SEQUENCE, true, [
	          asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.OID, false,
	            asn1$1.oidToDer(oids['pkcs5PBKDF2']).getBytes()),
	          // PBKDF2-params
	          params
	        ]),
	        // encryptionScheme
	        asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.SEQUENCE, true, [
	          asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.OID, false,
	            asn1$1.oidToDer(encOid).getBytes()),
	          // iv
	          asn1$1.create(
	            asn1$1.Class.UNIVERSAL, asn1$1.Type.OCTETSTRING, false, iv)
	        ])
	      ])
	    ]);
	  } else if(options.algorithm === '3des') {
	    // Do PKCS12 PBE
	    dkLen = 24;

	    var saltBytes = new forge.util.ByteBuffer(salt);
	    var dk = pki.pbe.generatePkcs12Key(password, saltBytes, 1, count, dkLen);
	    var iv = pki.pbe.generatePkcs12Key(password, saltBytes, 2, count, dkLen);
	    var cipher = forge.des.createEncryptionCipher(dk);
	    cipher.start(iv);
	    cipher.update(asn1$1.toDer(obj));
	    cipher.finish();
	    encryptedData = cipher.output.getBytes();

	    encryptionAlgorithm = asn1$1.create(
	      asn1$1.Class.UNIVERSAL, asn1$1.Type.SEQUENCE, true, [
	      asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.OID, false,
	        asn1$1.oidToDer(oids['pbeWithSHAAnd3-KeyTripleDES-CBC']).getBytes()),
	      // pkcs-12PbeParams
	      asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.SEQUENCE, true, [
	        // salt
	        asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.OCTETSTRING, false, salt),
	        // iteration count
	        asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.INTEGER, false,
	          countBytes.getBytes())
	      ])
	    ]);
	  } else {
	    var error = new Error('Cannot encrypt private key. Unknown encryption algorithm.');
	    error.algorithm = options.algorithm;
	    throw error;
	  }

	  // EncryptedPrivateKeyInfo
	  var rval = asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.SEQUENCE, true, [
	    // encryptionAlgorithm
	    encryptionAlgorithm,
	    // encryptedData
	    asn1$1.create(
	      asn1$1.Class.UNIVERSAL, asn1$1.Type.OCTETSTRING, false, encryptedData)
	  ]);
	  return rval;
	};

	/**
	 * Decrypts a ASN.1 PrivateKeyInfo object.
	 *
	 * @param obj the ASN.1 EncryptedPrivateKeyInfo object.
	 * @param password the password to decrypt with.
	 *
	 * @return the ASN.1 PrivateKeyInfo on success, null on failure.
	 */
	pki.decryptPrivateKeyInfo = function(obj, password) {
	  var rval = null;

	  // get PBE params
	  var capture = {};
	  var errors = [];
	  if(!asn1$1.validate(obj, encryptedPrivateKeyValidator, capture, errors)) {
	    var error = new Error('Cannot read encrypted private key. ' +
	      'ASN.1 object is not a supported EncryptedPrivateKeyInfo.');
	    error.errors = errors;
	    throw error;
	  }

	  // get cipher
	  var oid = asn1$1.derToOid(capture.encryptionOid);
	  var cipher = pki.pbe.getCipher(oid, capture.encryptionParams, password);

	  // get encrypted data
	  var encrypted = forge.util.createBuffer(capture.encryptedData);

	  cipher.update(encrypted);
	  if(cipher.finish()) {
	    rval = asn1$1.fromDer(cipher.output);
	  }

	  return rval;
	};

	/**
	 * Converts a EncryptedPrivateKeyInfo to PEM format.
	 *
	 * @param epki the EncryptedPrivateKeyInfo.
	 * @param maxline the maximum characters per line, defaults to 64.
	 *
	 * @return the PEM-formatted encrypted private key.
	 */
	pki.encryptedPrivateKeyToPem = function(epki, maxline) {
	  // convert to DER, then PEM-encode
	  var msg = {
	    type: 'ENCRYPTED PRIVATE KEY',
	    body: asn1$1.toDer(epki).getBytes()
	  };
	  return forge.pem.encode(msg, {maxline: maxline});
	};

	/**
	 * Converts a PEM-encoded EncryptedPrivateKeyInfo to ASN.1 format. Decryption
	 * is not performed.
	 *
	 * @param pem the EncryptedPrivateKeyInfo in PEM-format.
	 *
	 * @return the ASN.1 EncryptedPrivateKeyInfo.
	 */
	pki.encryptedPrivateKeyFromPem = function(pem) {
	  var msg = forge.pem.decode(pem)[0];

	  if(msg.type !== 'ENCRYPTED PRIVATE KEY') {
	    var error = new Error('Could not convert encrypted private key from PEM; ' +
	      'PEM header type is "ENCRYPTED PRIVATE KEY".');
	    error.headerType = msg.type;
	    throw error;
	  }
	  if(msg.procType && msg.procType.type === 'ENCRYPTED') {
	    throw new Error('Could not convert encrypted private key from PEM; ' +
	      'PEM is encrypted.');
	  }

	  // convert DER to ASN.1 object
	  return asn1$1.fromDer(msg.body);
	};

	/**
	 * Encrypts an RSA private key. By default, the key will be wrapped in
	 * a PrivateKeyInfo and encrypted to produce a PKCS#8 EncryptedPrivateKeyInfo.
	 * This is the standard, preferred way to encrypt a private key.
	 *
	 * To produce a non-standard PEM-encrypted private key that uses encapsulated
	 * headers to indicate the encryption algorithm (old-style non-PKCS#8 OpenSSL
	 * private key encryption), set the 'legacy' option to true. Note: Using this
	 * option will cause the iteration count to be forced to 1.
	 *
	 * Note: The 'des' algorithm is supported, but it is not considered to be
	 * secure because it only uses a single 56-bit key. If possible, it is highly
	 * recommended that a different algorithm be used.
	 *
	 * @param rsaKey the RSA key to encrypt.
	 * @param password the password to use.
	 * @param options:
	 *          algorithm: the encryption algorithm to use
	 *            ('aes128', 'aes192', 'aes256', '3des', 'des').
	 *          count: the iteration count to use.
	 *          saltSize: the salt size to use.
	 *          legacy: output an old non-PKCS#8 PEM-encrypted+encapsulated
	 *            headers (DEK-Info) private key.
	 *
	 * @return the PEM-encoded ASN.1 EncryptedPrivateKeyInfo.
	 */
	pki.encryptRsaPrivateKey = function(rsaKey, password, options) {
	  // standard PKCS#8
	  options = options || {};
	  if(!options.legacy) {
	    // encrypt PrivateKeyInfo
	    var rval = pki.wrapRsaPrivateKey(pki.privateKeyToAsn1(rsaKey));
	    rval = pki.encryptPrivateKeyInfo(rval, password, options);
	    return pki.encryptedPrivateKeyToPem(rval);
	  }

	  // legacy non-PKCS#8
	  var algorithm;
	  var iv;
	  var dkLen;
	  var cipherFn;
	  switch(options.algorithm) {
	  case 'aes128':
	    algorithm = 'AES-128-CBC';
	    dkLen = 16;
	    iv = forge.random.getBytesSync(16);
	    cipherFn = forge.aes.createEncryptionCipher;
	    break;
	  case 'aes192':
	    algorithm = 'AES-192-CBC';
	    dkLen = 24;
	    iv = forge.random.getBytesSync(16);
	    cipherFn = forge.aes.createEncryptionCipher;
	    break;
	  case 'aes256':
	    algorithm = 'AES-256-CBC';
	    dkLen = 32;
	    iv = forge.random.getBytesSync(16);
	    cipherFn = forge.aes.createEncryptionCipher;
	    break;
	  case '3des':
	    algorithm = 'DES-EDE3-CBC';
	    dkLen = 24;
	    iv = forge.random.getBytesSync(8);
	    cipherFn = forge.des.createEncryptionCipher;
	    break;
	  case 'des':
	    algorithm = 'DES-CBC';
	    dkLen = 8;
	    iv = forge.random.getBytesSync(8);
	    cipherFn = forge.des.createEncryptionCipher;
	    break;
	  default:
	    var error = new Error('Could not encrypt RSA private key; unsupported ' +
	      'encryption algorithm "' + options.algorithm + '".');
	    error.algorithm = options.algorithm;
	    throw error;
	  }

	  // encrypt private key using OpenSSL legacy key derivation
	  var dk = forge.pbe.opensslDeriveBytes(password, iv.substr(0, 8), dkLen);
	  var cipher = cipherFn(dk);
	  cipher.start(iv);
	  cipher.update(asn1$1.toDer(pki.privateKeyToAsn1(rsaKey)));
	  cipher.finish();

	  var msg = {
	    type: 'RSA PRIVATE KEY',
	    procType: {
	      version: '4',
	      type: 'ENCRYPTED'
	    },
	    dekInfo: {
	      algorithm: algorithm,
	      parameters: forge.util.bytesToHex(iv).toUpperCase()
	    },
	    body: cipher.output.getBytes()
	  };
	  return forge.pem.encode(msg);
	};

	/**
	 * Decrypts an RSA private key.
	 *
	 * @param pem the PEM-formatted EncryptedPrivateKeyInfo to decrypt.
	 * @param password the password to use.
	 *
	 * @return the RSA key on success, null on failure.
	 */
	pki.decryptRsaPrivateKey = function(pem, password) {
	  var rval = null;

	  var msg = forge.pem.decode(pem)[0];

	  if(msg.type !== 'ENCRYPTED PRIVATE KEY' &&
	    msg.type !== 'PRIVATE KEY' &&
	    msg.type !== 'RSA PRIVATE KEY') {
	    var error = new Error('Could not convert private key from PEM; PEM header type ' +
	      'is not "ENCRYPTED PRIVATE KEY", "PRIVATE KEY", or "RSA PRIVATE KEY".');
	    error.headerType = error;
	    throw error;
	  }

	  if(msg.procType && msg.procType.type === 'ENCRYPTED') {
	    var dkLen;
	    var cipherFn;
	    switch(msg.dekInfo.algorithm) {
	    case 'DES-CBC':
	      dkLen = 8;
	      cipherFn = forge.des.createDecryptionCipher;
	      break;
	    case 'DES-EDE3-CBC':
	      dkLen = 24;
	      cipherFn = forge.des.createDecryptionCipher;
	      break;
	    case 'AES-128-CBC':
	      dkLen = 16;
	      cipherFn = forge.aes.createDecryptionCipher;
	      break;
	    case 'AES-192-CBC':
	      dkLen = 24;
	      cipherFn = forge.aes.createDecryptionCipher;
	      break;
	    case 'AES-256-CBC':
	      dkLen = 32;
	      cipherFn = forge.aes.createDecryptionCipher;
	      break;
	    case 'RC2-40-CBC':
	      dkLen = 5;
	      cipherFn = function(key) {
	        return forge.rc2.createDecryptionCipher(key, 40);
	      };
	      break;
	    case 'RC2-64-CBC':
	      dkLen = 8;
	      cipherFn = function(key) {
	        return forge.rc2.createDecryptionCipher(key, 64);
	      };
	      break;
	    case 'RC2-128-CBC':
	      dkLen = 16;
	      cipherFn = function(key) {
	        return forge.rc2.createDecryptionCipher(key, 128);
	      };
	      break;
	    default:
	      var error = new Error('Could not decrypt private key; unsupported ' +
	        'encryption algorithm "' + msg.dekInfo.algorithm + '".');
	      error.algorithm = msg.dekInfo.algorithm;
	      throw error;
	    }

	    // use OpenSSL legacy key derivation
	    var iv = forge.util.hexToBytes(msg.dekInfo.parameters);
	    var dk = forge.pbe.opensslDeriveBytes(password, iv.substr(0, 8), dkLen);
	    var cipher = cipherFn(dk);
	    cipher.start(iv);
	    cipher.update(forge.util.createBuffer(msg.body));
	    if(cipher.finish()) {
	      rval = cipher.output.getBytes();
	    } else {
	      return rval;
	    }
	  } else {
	    rval = msg.body;
	  }

	  if(msg.type === 'ENCRYPTED PRIVATE KEY') {
	    rval = pki.decryptPrivateKeyInfo(asn1$1.fromDer(rval), password);
	  } else {
	    // decryption already performed above
	    rval = asn1$1.fromDer(rval);
	  }

	  if(rval !== null) {
	    rval = pki.privateKeyFromAsn1(rval);
	  }

	  return rval;
	};

	/**
	 * Derives a PKCS#12 key.
	 *
	 * @param password the password to derive the key material from, null or
	 *          undefined for none.
	 * @param salt the salt, as a ByteBuffer, to use.
	 * @param id the PKCS#12 ID byte (1 = key material, 2 = IV, 3 = MAC).
	 * @param iter the iteration count.
	 * @param n the number of bytes to derive from the password.
	 * @param md the message digest to use, defaults to SHA-1.
	 *
	 * @return a ByteBuffer with the bytes derived from the password.
	 */
	pki.pbe.generatePkcs12Key = function(password, salt, id, iter, n, md) {
	  var j, l;

	  if(typeof md === 'undefined' || md === null) {
	    if(!('sha1' in forge.md)) {
	      throw new Error('"sha1" hash algorithm unavailable.');
	    }
	    md = forge.md.sha1.create();
	  }

	  var u = md.digestLength;
	  var v = md.blockLength;
	  var result = new forge.util.ByteBuffer();

	  /* Convert password to Unicode byte buffer + trailing 0-byte. */
	  var passBuf = new forge.util.ByteBuffer();
	  if(password !== null && password !== undefined) {
	    for(l = 0; l < password.length; l++) {
	      passBuf.putInt16(password.charCodeAt(l));
	    }
	    passBuf.putInt16(0);
	  }

	  /* Length of salt and password in BYTES. */
	  var p = passBuf.length();
	  var s = salt.length();

	  /* 1. Construct a string, D (the "diversifier"), by concatenating
	        v copies of ID. */
	  var D = new forge.util.ByteBuffer();
	  D.fillWithByte(id, v);

	  /* 2. Concatenate copies of the salt together to create a string S of length
	        v * ceil(s / v) bytes (the final copy of the salt may be trunacted
	        to create S).
	        Note that if the salt is the empty string, then so is S. */
	  var Slen = v * Math.ceil(s / v);
	  var S = new forge.util.ByteBuffer();
	  for(l = 0; l < Slen; l++) {
	    S.putByte(salt.at(l % s));
	  }

	  /* 3. Concatenate copies of the password together to create a string P of
	        length v * ceil(p / v) bytes (the final copy of the password may be
	        truncated to create P).
	        Note that if the password is the empty string, then so is P. */
	  var Plen = v * Math.ceil(p / v);
	  var P = new forge.util.ByteBuffer();
	  for(l = 0; l < Plen; l++) {
	    P.putByte(passBuf.at(l % p));
	  }

	  /* 4. Set I=S||P to be the concatenation of S and P. */
	  var I = S;
	  I.putBuffer(P);

	  /* 5. Set c=ceil(n / u). */
	  var c = Math.ceil(n / u);

	  /* 6. For i=1, 2, ..., c, do the following: */
	  for(var i = 1; i <= c; i++) {
	    /* a) Set Ai=H^r(D||I). (l.e. the rth hash of D||I, H(H(H(...H(D||I)))) */
	    var buf = new forge.util.ByteBuffer();
	    buf.putBytes(D.bytes());
	    buf.putBytes(I.bytes());
	    for(var round = 0; round < iter; round++) {
	      md.start();
	      md.update(buf.getBytes());
	      buf = md.digest();
	    }

	    /* b) Concatenate copies of Ai to create a string B of length v bytes (the
	          final copy of Ai may be truncated to create B). */
	    var B = new forge.util.ByteBuffer();
	    for(l = 0; l < v; l++) {
	      B.putByte(buf.at(l % u));
	    }

	    /* c) Treating I as a concatenation I0, I1, ..., Ik-1 of v-byte blocks,
	          where k=ceil(s / v) + ceil(p / v), modify I by setting
	          Ij=(Ij+B+1) mod 2v for each j.  */
	    var k = Math.ceil(s / v) + Math.ceil(p / v);
	    var Inew = new forge.util.ByteBuffer();
	    for(j = 0; j < k; j++) {
	      var chunk = new forge.util.ByteBuffer(I.getBytes(v));
	      var x = 0x1ff;
	      for(l = B.length() - 1; l >= 0; l--) {
	        x = x >> 8;
	        x += B.at(l) + chunk.at(l);
	        chunk.setAt(l, x & 0xff);
	      }
	      Inew.putBuffer(chunk);
	    }
	    I = Inew;

	    /* Add Ai to A. */
	    result.putBuffer(buf);
	  }

	  result.truncate(result.length() - n);
	  return result;
	};

	/**
	 * Get new Forge cipher object instance.
	 *
	 * @param oid the OID (in string notation).
	 * @param params the ASN.1 params object.
	 * @param password the password to decrypt with.
	 *
	 * @return new cipher object instance.
	 */
	pki.pbe.getCipher = function(oid, params, password) {
	  switch(oid) {
	  case pki.oids['pkcs5PBES2']:
	    return pki.pbe.getCipherForPBES2(oid, params, password);

	  case pki.oids['pbeWithSHAAnd3-KeyTripleDES-CBC']:
	  case pki.oids['pbewithSHAAnd40BitRC2-CBC']:
	    return pki.pbe.getCipherForPKCS12PBE(oid, params, password);

	  default:
	    var error = new Error('Cannot read encrypted PBE data block. Unsupported OID.');
	    error.oid = oid;
	    error.supportedOids = [
	      'pkcs5PBES2',
	      'pbeWithSHAAnd3-KeyTripleDES-CBC',
	      'pbewithSHAAnd40BitRC2-CBC'
	    ];
	    throw error;
	  }
	};

	/**
	 * Get new Forge cipher object instance according to PBES2 params block.
	 *
	 * The returned cipher instance is already started using the IV
	 * from PBES2 parameter block.
	 *
	 * @param oid the PKCS#5 PBKDF2 OID (in string notation).
	 * @param params the ASN.1 PBES2-params object.
	 * @param password the password to decrypt with.
	 *
	 * @return new cipher object instance.
	 */
	pki.pbe.getCipherForPBES2 = function(oid, params, password) {
	  // get PBE params
	  var capture = {};
	  var errors = [];
	  if(!asn1$1.validate(params, PBES2AlgorithmsValidator, capture, errors)) {
	    var error = new Error('Cannot read password-based-encryption algorithm ' +
	      'parameters. ASN.1 object is not a supported EncryptedPrivateKeyInfo.');
	    error.errors = errors;
	    throw error;
	  }

	  // check oids
	  oid = asn1$1.derToOid(capture.kdfOid);
	  if(oid !== pki.oids['pkcs5PBKDF2']) {
	    var error = new Error('Cannot read encrypted private key. ' +
	      'Unsupported key derivation function OID.');
	    error.oid = oid;
	    error.supportedOids = ['pkcs5PBKDF2'];
	    throw error;
	  }
	  oid = asn1$1.derToOid(capture.encOid);
	  if(oid !== pki.oids['aes128-CBC'] &&
	    oid !== pki.oids['aes192-CBC'] &&
	    oid !== pki.oids['aes256-CBC'] &&
	    oid !== pki.oids['des-EDE3-CBC'] &&
	    oid !== pki.oids['desCBC']) {
	    var error = new Error('Cannot read encrypted private key. ' +
	      'Unsupported encryption scheme OID.');
	    error.oid = oid;
	    error.supportedOids = [
	      'aes128-CBC', 'aes192-CBC', 'aes256-CBC', 'des-EDE3-CBC', 'desCBC'];
	    throw error;
	  }

	  // set PBE params
	  var salt = capture.kdfSalt;
	  var count = forge.util.createBuffer(capture.kdfIterationCount);
	  count = count.getInt(count.length() << 3);
	  var dkLen;
	  var cipherFn;
	  switch(pki.oids[oid]) {
	  case 'aes128-CBC':
	    dkLen = 16;
	    cipherFn = forge.aes.createDecryptionCipher;
	    break;
	  case 'aes192-CBC':
	    dkLen = 24;
	    cipherFn = forge.aes.createDecryptionCipher;
	    break;
	  case 'aes256-CBC':
	    dkLen = 32;
	    cipherFn = forge.aes.createDecryptionCipher;
	    break;
	  case 'des-EDE3-CBC':
	    dkLen = 24;
	    cipherFn = forge.des.createDecryptionCipher;
	    break;
	  case 'desCBC':
	    dkLen = 8;
	    cipherFn = forge.des.createDecryptionCipher;
	    break;
	  }

	  // get PRF message digest
	  var md = prfOidToMessageDigest(capture.prfOid);

	  // decrypt private key using pbe with chosen PRF and AES/DES
	  var dk = forge.pkcs5.pbkdf2(password, salt, count, dkLen, md);
	  var iv = capture.encIv;
	  var cipher = cipherFn(dk);
	  cipher.start(iv);

	  return cipher;
	};

	/**
	 * Get new Forge cipher object instance for PKCS#12 PBE.
	 *
	 * The returned cipher instance is already started using the key & IV
	 * derived from the provided password and PKCS#12 PBE salt.
	 *
	 * @param oid The PKCS#12 PBE OID (in string notation).
	 * @param params The ASN.1 PKCS#12 PBE-params object.
	 * @param password The password to decrypt with.
	 *
	 * @return the new cipher object instance.
	 */
	pki.pbe.getCipherForPKCS12PBE = function(oid, params, password) {
	  // get PBE params
	  var capture = {};
	  var errors = [];
	  if(!asn1$1.validate(params, pkcs12PbeParamsValidator, capture, errors)) {
	    var error = new Error('Cannot read password-based-encryption algorithm ' +
	      'parameters. ASN.1 object is not a supported EncryptedPrivateKeyInfo.');
	    error.errors = errors;
	    throw error;
	  }

	  var salt = forge.util.createBuffer(capture.salt);
	  var count = forge.util.createBuffer(capture.iterations);
	  count = count.getInt(count.length() << 3);

	  var dkLen, dIvLen, cipherFn;
	  switch(oid) {
	    case pki.oids['pbeWithSHAAnd3-KeyTripleDES-CBC']:
	      dkLen = 24;
	      dIvLen = 8;
	      cipherFn = forge.des.startDecrypting;
	      break;

	    case pki.oids['pbewithSHAAnd40BitRC2-CBC']:
	      dkLen = 5;
	      dIvLen = 8;
	      cipherFn = function(key, iv) {
	        var cipher = forge.rc2.createDecryptionCipher(key, 40);
	        cipher.start(iv, null);
	        return cipher;
	      };
	      break;

	    default:
	      var error = new Error('Cannot read PKCS #12 PBE data block. Unsupported OID.');
	      error.oid = oid;
	      throw error;
	  }

	  // get PRF message digest
	  var md = prfOidToMessageDigest(capture.prfOid);
	  var key = pki.pbe.generatePkcs12Key(password, salt, 1, count, dkLen, md);
	  md.start();
	  var iv = pki.pbe.generatePkcs12Key(password, salt, 2, count, dIvLen, md);

	  return cipherFn(key, iv);
	};

	/**
	 * OpenSSL's legacy key derivation function.
	 *
	 * See: http://www.openssl.org/docs/crypto/EVP_BytesToKey.html
	 *
	 * @param password the password to derive the key from.
	 * @param salt the salt to use, null for none.
	 * @param dkLen the number of bytes needed for the derived key.
	 * @param [options] the options to use:
	 *          [md] an optional message digest object to use.
	 */
	pki.pbe.opensslDeriveBytes = function(password, salt, dkLen, md) {
	  if(typeof md === 'undefined' || md === null) {
	    if(!('md5' in forge.md)) {
	      throw new Error('"md5" hash algorithm unavailable.');
	    }
	    md = forge.md.md5.create();
	  }
	  if(salt === null) {
	    salt = '';
	  }
	  var digests = [hash(md, password + salt)];
	  for(var length = 16, i = 1; length < dkLen; ++i, length += 16) {
	    digests.push(hash(md, digests[i - 1] + password + salt));
	  }
	  return digests.join('').substr(0, dkLen);
	};

	function hash(md, bytes) {
	  return md.start().update(bytes).digest().getBytes();
	}

	function prfOidToMessageDigest(prfOid) {
	  // get PRF algorithm, default to SHA-1
	  var prfAlgorithm;
	  if(!prfOid) {
	    prfAlgorithm = 'hmacWithSHA1';
	  } else {
	    prfAlgorithm = pki.oids[asn1$1.derToOid(prfOid)];
	    if(!prfAlgorithm) {
	      var error = new Error('Unsupported PRF OID.');
	      error.oid = prfOid;
	      error.supported = [
	        'hmacWithSHA1', 'hmacWithSHA224', 'hmacWithSHA256', 'hmacWithSHA384',
	        'hmacWithSHA512'];
	      throw error;
	    }
	  }
	  return prfAlgorithmToMessageDigest(prfAlgorithm);
	}

	function prfAlgorithmToMessageDigest(prfAlgorithm) {
	  var factory = forge.md;
	  switch(prfAlgorithm) {
	  case 'hmacWithSHA224':
	    factory = forge.md.sha512;
	  case 'hmacWithSHA1':
	  case 'hmacWithSHA256':
	  case 'hmacWithSHA384':
	  case 'hmacWithSHA512':
	    prfAlgorithm = prfAlgorithm.substr(8).toLowerCase();
	    break;
	  default:
	    var error = new Error('Unsupported PRF algorithm.');
	    error.algorithm = prfAlgorithm;
	    error.supported = [
	      'hmacWithSHA1', 'hmacWithSHA224', 'hmacWithSHA256', 'hmacWithSHA384',
	      'hmacWithSHA512'];
	    throw error;
	  }
	  if(!factory || !(prfAlgorithm in factory)) {
	    throw new Error('Unknown hash algorithm: ' + prfAlgorithm);
	  }
	  return factory[prfAlgorithm].create();
	}

	function createPbkdf2Params(salt, countBytes, dkLen, prfAlgorithm) {
	  var params = asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.SEQUENCE, true, [
	    // salt
	    asn1$1.create(
	      asn1$1.Class.UNIVERSAL, asn1$1.Type.OCTETSTRING, false, salt),
	    // iteration count
	    asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.INTEGER, false,
	      countBytes.getBytes())
	  ]);
	  // when PRF algorithm is not SHA-1 default, add key length and PRF algorithm
	  if(prfAlgorithm !== 'hmacWithSHA1') {
	    params.value.push(
	      // key length
	      asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.INTEGER, false,
	        forge.util.hexToBytes(dkLen.toString(16))),
	      // AlgorithmIdentifier
	      asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.SEQUENCE, true, [
	        // algorithm
	        asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.OID, false,
	          asn1$1.oidToDer(pki.oids[prfAlgorithm]).getBytes()),
	        // parameters (null)
	        asn1$1.create(asn1$1.Class.UNIVERSAL, asn1$1.Type.NULL, false, '')
	      ]));
	  }
	  return params;
	}

	createCommonjsModule(function (module) {
	/**
	 * Javascript implementation of ASN.1 validators for PKCS#7 v1.5.
	 *
	 * @author Dave Longley
	 * @author Stefan Siegl
	 *
	 * Copyright (c) 2012-2015 Digital Bazaar, Inc.
	 * Copyright (c) 2012 Stefan Siegl <stesie@brokenpipe.de>
	 *
	 * The ASN.1 representation of PKCS#7 is as follows
	 * (see RFC #2315 for details, http://www.ietf.org/rfc/rfc2315.txt):
	 *
	 * A PKCS#7 message consists of a ContentInfo on root level, which may
	 * contain any number of further ContentInfo nested into it.
	 *
	 * ContentInfo ::= SEQUENCE {
	 *   contentType                ContentType,
	 *   content               [0]  EXPLICIT ANY DEFINED BY contentType OPTIONAL
	 * }
	 *
	 * ContentType ::= OBJECT IDENTIFIER
	 *
	 * EnvelopedData ::= SEQUENCE {
	 *   version                    Version,
	 *   recipientInfos             RecipientInfos,
	 *   encryptedContentInfo       EncryptedContentInfo
	 * }
	 *
	 * EncryptedData ::= SEQUENCE {
	 *   version                    Version,
	 *   encryptedContentInfo       EncryptedContentInfo
	 * }
	 *
	 * id-signedData OBJECT IDENTIFIER ::= { iso(1) member-body(2)
	 *   us(840) rsadsi(113549) pkcs(1) pkcs7(7) 2 }
	 *
	 * SignedData ::= SEQUENCE {
	 *   version           INTEGER,
	 *   digestAlgorithms  DigestAlgorithmIdentifiers,
	 *   contentInfo       ContentInfo,
	 *   certificates      [0] IMPLICIT Certificates OPTIONAL,
	 *   crls              [1] IMPLICIT CertificateRevocationLists OPTIONAL,
	 *   signerInfos       SignerInfos
	 * }
	 *
	 * SignerInfos ::= SET OF SignerInfo
	 *
	 * SignerInfo ::= SEQUENCE {
	 *   version                    Version,
	 *   issuerAndSerialNumber      IssuerAndSerialNumber,
	 *   digestAlgorithm            DigestAlgorithmIdentifier,
	 *   authenticatedAttributes    [0] IMPLICIT Attributes OPTIONAL,
	 *   digestEncryptionAlgorithm  DigestEncryptionAlgorithmIdentifier,
	 *   encryptedDigest            EncryptedDigest,
	 *   unauthenticatedAttributes  [1] IMPLICIT Attributes OPTIONAL
	 * }
	 *
	 * EncryptedDigest ::= OCTET STRING
	 *
	 * Attributes ::= SET OF Attribute
	 *
	 * Attribute ::= SEQUENCE {
	 *   attrType    OBJECT IDENTIFIER,
	 *   attrValues  SET OF AttributeValue
	 * }
	 *
	 * AttributeValue ::= ANY
	 *
	 * Version ::= INTEGER
	 *
	 * RecipientInfos ::= SET OF RecipientInfo
	 *
	 * EncryptedContentInfo ::= SEQUENCE {
	 *   contentType                 ContentType,
	 *   contentEncryptionAlgorithm  ContentEncryptionAlgorithmIdentifier,
	 *   encryptedContent       [0]  IMPLICIT EncryptedContent OPTIONAL
	 * }
	 *
	 * ContentEncryptionAlgorithmIdentifier ::= AlgorithmIdentifier
	 *
	 * The AlgorithmIdentifier contains an Object Identifier (OID) and parameters
	 * for the algorithm, if any. In the case of AES and DES3, there is only one,
	 * the IV.
	 *
	 * AlgorithmIdentifer ::= SEQUENCE {
	 *    algorithm OBJECT IDENTIFIER,
	 *    parameters ANY DEFINED BY algorithm OPTIONAL
	 * }
	 *
	 * EncryptedContent ::= OCTET STRING
	 *
	 * RecipientInfo ::= SEQUENCE {
	 *   version                     Version,
	 *   issuerAndSerialNumber       IssuerAndSerialNumber,
	 *   keyEncryptionAlgorithm      KeyEncryptionAlgorithmIdentifier,
	 *   encryptedKey                EncryptedKey
	 * }
	 *
	 * IssuerAndSerialNumber ::= SEQUENCE {
	 *   issuer                      Name,
	 *   serialNumber                CertificateSerialNumber
	 * }
	 *
	 * CertificateSerialNumber ::= INTEGER
	 *
	 * KeyEncryptionAlgorithmIdentifier ::= AlgorithmIdentifier
	 *
	 * EncryptedKey ::= OCTET STRING
	 */




	// shortcut for ASN.1 API
	var asn1 = forge.asn1;

	// shortcut for PKCS#7 API
	var p7v = module.exports = forge.pkcs7asn1 = forge.pkcs7asn1 || {};
	forge.pkcs7 = forge.pkcs7 || {};
	forge.pkcs7.asn1 = p7v;

	var contentInfoValidator = {
	  name: 'ContentInfo',
	  tagClass: asn1.Class.UNIVERSAL,
	  type: asn1.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    name: 'ContentInfo.ContentType',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.OID,
	    constructed: false,
	    capture: 'contentType'
	  }, {
	    name: 'ContentInfo.content',
	    tagClass: asn1.Class.CONTEXT_SPECIFIC,
	    type: 0,
	    constructed: true,
	    optional: true,
	    captureAsn1: 'content'
	  }]
	};
	p7v.contentInfoValidator = contentInfoValidator;

	var encryptedContentInfoValidator = {
	  name: 'EncryptedContentInfo',
	  tagClass: asn1.Class.UNIVERSAL,
	  type: asn1.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    name: 'EncryptedContentInfo.contentType',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.OID,
	    constructed: false,
	    capture: 'contentType'
	  }, {
	    name: 'EncryptedContentInfo.contentEncryptionAlgorithm',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.SEQUENCE,
	    constructed: true,
	    value: [{
	      name: 'EncryptedContentInfo.contentEncryptionAlgorithm.algorithm',
	      tagClass: asn1.Class.UNIVERSAL,
	      type: asn1.Type.OID,
	      constructed: false,
	      capture: 'encAlgorithm'
	    }, {
	      name: 'EncryptedContentInfo.contentEncryptionAlgorithm.parameter',
	      tagClass: asn1.Class.UNIVERSAL,
	      captureAsn1: 'encParameter'
	    }]
	  }, {
	    name: 'EncryptedContentInfo.encryptedContent',
	    tagClass: asn1.Class.CONTEXT_SPECIFIC,
	    type: 0,
	    /* The PKCS#7 structure output by OpenSSL somewhat differs from what
	     * other implementations do generate.
	     *
	     * OpenSSL generates a structure like this:
	     * SEQUENCE {
	     *    ...
	     *    [0]
	     *       26 DA 67 D2 17 9C 45 3C B1 2A A8 59 2F 29 33 38
	     *       C3 C3 DF 86 71 74 7A 19 9F 40 D0 29 BE 85 90 45
	     *       ...
	     * }
	     *
	     * Whereas other implementations (and this PKCS#7 module) generate:
	     * SEQUENCE {
	     *    ...
	     *    [0] {
	     *       OCTET STRING
	     *          26 DA 67 D2 17 9C 45 3C B1 2A A8 59 2F 29 33 38
	     *          C3 C3 DF 86 71 74 7A 19 9F 40 D0 29 BE 85 90 45
	     *          ...
	     *    }
	     * }
	     *
	     * In order to support both, we just capture the context specific
	     * field here.  The OCTET STRING bit is removed below.
	     */
	    capture: 'encryptedContent',
	    captureAsn1: 'encryptedContentAsn1'
	  }]
	};

	p7v.envelopedDataValidator = {
	  name: 'EnvelopedData',
	  tagClass: asn1.Class.UNIVERSAL,
	  type: asn1.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    name: 'EnvelopedData.Version',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.INTEGER,
	    constructed: false,
	    capture: 'version'
	  }, {
	    name: 'EnvelopedData.RecipientInfos',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.SET,
	    constructed: true,
	    captureAsn1: 'recipientInfos'
	  }].concat(encryptedContentInfoValidator)
	};

	p7v.encryptedDataValidator = {
	  name: 'EncryptedData',
	  tagClass: asn1.Class.UNIVERSAL,
	  type: asn1.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    name: 'EncryptedData.Version',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.INTEGER,
	    constructed: false,
	    capture: 'version'
	  }].concat(encryptedContentInfoValidator)
	};

	var signerValidator = {
	  name: 'SignerInfo',
	  tagClass: asn1.Class.UNIVERSAL,
	  type: asn1.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    name: 'SignerInfo.version',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.INTEGER,
	    constructed: false
	  }, {
	    name: 'SignerInfo.issuerAndSerialNumber',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.SEQUENCE,
	    constructed: true,
	    value: [{
	      name: 'SignerInfo.issuerAndSerialNumber.issuer',
	      tagClass: asn1.Class.UNIVERSAL,
	      type: asn1.Type.SEQUENCE,
	      constructed: true,
	      captureAsn1: 'issuer'
	    }, {
	      name: 'SignerInfo.issuerAndSerialNumber.serialNumber',
	      tagClass: asn1.Class.UNIVERSAL,
	      type: asn1.Type.INTEGER,
	      constructed: false,
	      capture: 'serial'
	    }]
	  }, {
	    name: 'SignerInfo.digestAlgorithm',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.SEQUENCE,
	    constructed: true,
	    value: [{
	      name: 'SignerInfo.digestAlgorithm.algorithm',
	      tagClass: asn1.Class.UNIVERSAL,
	      type: asn1.Type.OID,
	      constructed: false,
	      capture: 'digestAlgorithm'
	    }, {
	      name: 'SignerInfo.digestAlgorithm.parameter',
	      tagClass: asn1.Class.UNIVERSAL,
	      constructed: false,
	      captureAsn1: 'digestParameter',
	      optional: true
	    }]
	  }, {
	    name: 'SignerInfo.authenticatedAttributes',
	    tagClass: asn1.Class.CONTEXT_SPECIFIC,
	    type: 0,
	    constructed: true,
	    optional: true,
	    capture: 'authenticatedAttributes'
	  }, {
	    name: 'SignerInfo.digestEncryptionAlgorithm',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.SEQUENCE,
	    constructed: true,
	    capture: 'signatureAlgorithm'
	  }, {
	    name: 'SignerInfo.encryptedDigest',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.OCTETSTRING,
	    constructed: false,
	    capture: 'signature'
	  }, {
	    name: 'SignerInfo.unauthenticatedAttributes',
	    tagClass: asn1.Class.CONTEXT_SPECIFIC,
	    type: 1,
	    constructed: true,
	    optional: true,
	    capture: 'unauthenticatedAttributes'
	  }]
	};

	p7v.signedDataValidator = {
	  name: 'SignedData',
	  tagClass: asn1.Class.UNIVERSAL,
	  type: asn1.Type.SEQUENCE,
	  constructed: true,
	  value: [{
	    name: 'SignedData.Version',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.INTEGER,
	    constructed: false,
	    capture: 'version'
	  }, {
	    name: 'SignedData.DigestAlgorithms',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.SET,
	    constructed: true,
	    captureAsn1: 'digestAlgorithms'
	  },
	  contentInfoValidator,
	  {
	    name: 'SignedData.Certificates',
	    tagClass: asn1.Class.CONTEXT_SPECIFIC,
	    type: 0,
	    optional: true,
	    captureAsn1: 'certificates'
	  }, {
	    name: 'SignedData.CertificateRevocationLists',
	    tagClass: asn1.Class.CONTEXT_SPECIFIC,
	    type: 1,
	    optional: true,
	    captureAsn1: 'crls'
	  }, {
	    name: 'SignedData.SignerInfos',
	    tagClass: asn1.Class.UNIVERSAL,
	    type: asn1.Type.SET,
	    capture: 'signerInfos',
	    optional: true,
	    value: [signerValidator]
	  }]
	};

	p7v.recipientInfoValidator = {
	  name: 'Recipi