/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class SubmitResults {
    public boolean sendFile(Main parent, String hostname, String instanceFilePath, String status, String user, String password, boolean encrypted, String newIdent) {
        boolean submit_status = false;
        File tempFile = null;
        String changeIdXSLT = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:param name=\"surveyId\"/><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template><xsl:template match=\"@id\"><xsl:attribute name=\"id\"><xsl:value-of select=\"$surveyId\"/></xsl:attribute></xsl:template></xsl:stylesheet>";
        ContentType ct = null;
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        String urlString = null;
        HttpHost targetHost = null;
        if (encrypted) {
            urlString = "https://" + hostname + "/submission";
            targetHost = new HttpHost(hostname, 443, "https");
            parent.appendToStatus("\tUsing https");
            credsProvider.setCredentials(new AuthScope(hostname, 443, "smap", "basic"), new UsernamePasswordCredentials(user, password));
        } else {
            urlString = "http://" + hostname + "/submission";
            targetHost = new HttpHost(hostname, 80, "http");
            parent.appendToStatus("\tUsing http (not encrypted)");
            credsProvider.setCredentials(new AuthScope(hostname, 80, "smap", "digest"), new UsernamePasswordCredentials(user, password));
        }
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider(credsProvider).build();
        File instanceFile = new File(instanceFilePath);
        if (!instanceFile.exists()) {
            parent.appendToStatus("\tError: Submission file " + instanceFilePath + " does not exist");
        } else {
            HttpPost req = new HttpPost(URI.create(urlString));
            tempFile = this.populateRequest(parent, status, instanceFilePath, req, "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:param name=\"surveyId\"/><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template><xsl:template match=\"@id\"><xsl:attribute name=\"id\"><xsl:value-of select=\"$surveyId\"/></xsl:attribute></xsl:template></xsl:stylesheet>", ct, entityBuilder, newIdent);
            CloseableHttpResponse response = null;
            try {
                BasicAuthCache authCache = new BasicAuthCache();
                DigestScheme digestAuth = new DigestScheme();
                digestAuth.overrideParamter("realm", "smap");
                digestAuth.overrideParamter("nonce", "whatever");
                authCache.put(targetHost, digestAuth);
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(targetHost, basicAuth);
                HttpClientContext localContext = HttpClientContext.create();
                localContext.setAuthCache(authCache);
                parent.appendToStatus("\tInfo: submitting to: " + req.getURI().toString());
                response = httpclient.execute(targetHost, (HttpRequest)req, (HttpContext)localContext);
                int responseCode = response.getStatusLine().getStatusCode();
                try {
                    InputStream is = response.getEntity().getContent();
                    long count = 1024L;
                    while (is.skip(1024L) == 1024L) {
                    }
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                parent.appendToStatus("\tInfo: Response code: " + responseCode + " : " + response.getStatusLine().getReasonPhrase());
                if (responseCode != 201 && responseCode != 202) {
                    parent.appendToStatus("\tError: upload failed: ");
                } else {
                    submit_status = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                parent.appendToStatus("\tError: Generic Exception. " + e.toString());
            }
        }
        try {
            httpclient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tempFile != null) {
            tempFile.delete();
        }
        return submit_status;
    }

    private File populateRequest(final Main parent, String formStatus, String filePath, HttpPost req, final String changeIdXSLT, ContentType ct, MultipartEntityBuilder entityBuilder, final String newIdent) {
        File ammendedFile = null;
        final File instanceFile = new File(filePath);
        if (formStatus != null) {
            System.out.println("Setting form status in header: " + formStatus);
            req.setHeader("form_status", formStatus);
        } else {
            System.out.println("Form Status null");
        }
        if (newIdent != null) {
            try {
                System.out.println("Transformaing Instance file: " + instanceFile);
                PipedInputStream in = new PipedInputStream();
                final PipedOutputStream outStream = new PipedOutputStream(in);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ByteArrayInputStream xslStream = new ByteArrayInputStream(changeIdXSLT.getBytes("UTF-8"));
                            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslStream));
                            StreamSource source = new StreamSource(instanceFile);
                            StreamResult out = new StreamResult(outStream);
                            transformer.setParameter("surveyId", newIdent);
                            transformer.transform(source, out);
                            outStream.close();
                        }
                        catch (TransformerConfigurationException e1) {
                            parent.appendToStatus("Error changing ident: " + e1.toString());
                        }
                        catch (TransformerFactoryConfigurationError e1) {
                            parent.appendToStatus("Error changing ident: " + e1.toString());
                        }
                        catch (TransformerException e) {
                            parent.appendToStatus("Error changing ident: " + e.toString());
                        }
                        catch (IOException e) {
                            parent.appendToStatus("Error changing ident: " + e.toString());
                        }
                    }
                }).start();
                System.out.println("Saving stream to file");
                ammendedFile = this.saveStreamTemp(in);
            }
            catch (Exception e) {
                parent.appendToStatus("Error changing ident: " + e.toString());
            }
        }
        if (newIdent == null) {
            ct = ContentType.create("text/xml");
            entityBuilder.addBinaryBody("xml_submission_file", instanceFile, ct, instanceFile.getPath());
        } else {
            FileBody fb = new FileBody(ammendedFile);
            entityBuilder.addPart("xml_submission_file", fb);
        }
        parent.appendToStatus("Instance file path: " + instanceFile.getPath());
        File[] allFiles = instanceFile.getParentFile().listFiles();
        ArrayList<File> files = new ArrayList<File>();
        File[] fileArray = allFiles;
        int n = allFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String fileName = f.getName();
            if (!fileName.startsWith(".") && !fileName.equals(instanceFile.getName())) {
                files.add(f);
            }
            ++n2;
        }
        int j = 0;
        while (j < files.size()) {
            File f = (File)files.get(j);
            String fileName = f.getName();
            ct = ContentType.create(SubmitResults.getContentType(parent, fileName));
            FileBody fba = new FileBody(f, ct, fileName);
            entityBuilder.addPart(fileName, fba);
            ++j;
        }
        req.setEntity(entityBuilder.build());
        return ammendedFile;
    }

    private File saveStreamTemp(InputStream in) throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        File file = new File("upload" + timeStamp);
        FileUtils.copyInputStreamToFile(in, file);
        return file;
    }

    public static String getContentType(Main parent, String filename) {
        String ct = null;
        String extension = "";
        int idx = filename.lastIndexOf(46);
        if (idx > 0) {
            extension = filename.substring(idx + 1);
        }
        if (extension.equals("xml")) {
            ct = "text/xml";
        } else if (extension.equals("jpg") || extension.equals("jpeg") || extension.equals("jpe")) {
            ct = "image/jpeg";
        } else if (extension.equals("png")) {
            ct = "image/png";
        } else if (extension.equals("3gp")) {
            ct = "video/3gp";
        } else if (extension.equals("3ga")) {
            ct = "audio/3ga";
        } else if (extension.equals("mp2") || extension.equals("mp3") || extension.equals("mpga")) {
            ct = "audio/mpeg";
        } else if (extension.equals("mpeg") || extension.equals("mpg") || extension.equals("mpe")) {
            ct = "video/mpeg";
        } else if (extension.equals("qt") || extension.equals("mov")) {
            ct = "video/quicktime";
        } else if (extension.equals("mp4") || extension.equals("m4p")) {
            ct = "video/mp4";
        } else if (extension.equals("avi")) {
            ct = "video/x-msvideo";
        } else if (extension.equals("movie")) {
            ct = "video/x-sgi-movie";
        } else if (extension.equals("m4a")) {
            ct = "audio/m4a";
        } else if (extension.equals("csv")) {
            ct = "text/csv";
        } else if (extension.equals("amr")) {
            ct = "audio/amr";
        } else if (extension.equals("xls")) {
            ct = "application/vnd.ms-excel";
        } else {
            ct = "application/octet-stream";
            parent.appendToStatus("\tInfo: unrecognised content type for extension " + extension);
        }
        return ct;
    }
}

