/*
 * Decompiled with CFR 0.152.
 */
package com.nafundi.taskforce.codebook.batch;

import com.nafundi.taskforce.codebook.logic.CodebookEngineSmap;
import com.nafundi.taskforce.codebook.logic.CodebookEntry;
import com.nafundi.taskforce.codebook.logic.CodebookMakerSmap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JTextArea;

public class Main {
    private static final String APP_NAME = "Codebook v1.1 - Smap 19.4";
    private JTextArea statusLog;

    private Main(String filePath, String language) {
        try {
            System.out.println("File path:" + filePath);
            this.makeCodebook(new File(filePath), language);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String language = null;
        if (args.length > 0) {
            language = args.length > 1 ? args[1] : "_default";
            System.out.println(String.valueOf(args[0]) + " : " + language);
            new Main(args[0], language);
        } else {
            System.out.println("Error: please provide an xform to convert");
        }
    }

    private void makeCodebook(File inputFile, String language) throws Exception {
        String filenameWithExtension = inputFile.getName();
        String inputFilename = filenameWithExtension.substring(0, filenameWithExtension.lastIndexOf(46));
        String outputFolderpath = inputFile.getParentFile().getAbsolutePath();
        CodebookEngineSmap ce = new CodebookEngineSmap(inputFile.getAbsolutePath(), language);
        HashMap<String, ArrayList<CodebookEntry>> entries = ce.getEntry();
        ArrayList<CodebookEntry> entry = entries.get(language);
        CodebookMakerSmap maker = new CodebookMakerSmap(entry, language, inputFilename, outputFolderpath);
        maker.writeFile();
    }

    private void appendToStatus(String text) {
        if (this.statusLog != null) {
            this.statusLog.setText(String.valueOf(this.statusLog.getText()) + text + "\n");
        } else {
            System.out.println(text);
        }
    }
}

