/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data.helper;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathTypeMismatchException;

public class Selection
implements Externalizable {
    public String xmlValue = null;
    public int index = -1;
    public SelectChoice choice;

    public Selection() {
    }

    public Selection(SelectChoice choice) {
        this.attachChoice(choice);
    }

    public Selection(String xmlValue) {
        this.xmlValue = xmlValue;
    }

    public Selection(int index) {
        this.index = index;
    }

    public Selection clone() {
        Selection s = new Selection();
        s.choice = this.choice;
        s.xmlValue = this.xmlValue;
        s.index = this.index;
        return s;
    }

    public void attachChoice(SelectChoice choice) {
        this.choice = choice;
        this.xmlValue = choice.getValue();
        this.index = choice.getIndex();
    }

    public void attachChoice(QuestionDef q) {
        if (q.getDynamicChoices() != null) {
            return;
        }
        SelectChoice choice = null;
        if (this.index != -1 && this.index < q.getNumChoices()) {
            choice = q.getChoice(this.index);
        } else if (this.xmlValue != null && this.xmlValue.length() > 0) {
            choice = q.getChoiceForValue(this.xmlValue);
        }
        if (choice == null) {
            throw new XPathTypeMismatchException("value " + this.xmlValue + " could not be loaded into question " + q.getTextID() + ".  Check to see if value " + this.xmlValue + " is a valid option for question " + q.getTextID() + ".");
        }
        this.attachChoice(choice);
    }

    public String getValue() {
        if (this.xmlValue != null && this.xmlValue.length() > 0) {
            return this.xmlValue;
        }
        throw new RuntimeException("don't know xml value! perhaps selection was stored as index only and has not yet been linked up to a formdef?");
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        this.xmlValue = ExtUtil.readString(in);
        this.index = ExtUtil.readInt(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeString(out, this.getValue());
        ExtUtil.writeNumeric(out, this.index);
    }
}

