/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.storage.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import org.javarosa.core.services.storage.EntityFilter;
import org.javarosa.core.services.storage.IMetaData;
import org.javarosa.core.services.storage.IStorageIterator;
import org.javarosa.core.services.storage.IStorageUtilityIndexed;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.services.storage.StorageFullException;
import org.javarosa.core.services.storage.util.DummyStorageIterator;
import org.javarosa.core.util.DataUtil;
import org.javarosa.core.util.InvalidIndexException;
import org.javarosa.core.util.externalizable.Externalizable;

public class DummyIndexedStorageUtility<T extends Persistable>
implements IStorageUtilityIndexed<T> {
    private Hashtable<String, Hashtable<Object, ArrayList<Integer>>> meta;
    private Hashtable<Integer, T> data;
    int curCount = 0;
    ArrayList<String> dynamicIndices = new ArrayList(0);

    public DummyIndexedStorageUtility() {
        this.meta = new Hashtable();
        this.data = new Hashtable();
    }

    @Override
    public List<Integer> getIDsForValue(String fieldName, Object value) {
        if (this.meta.get(fieldName) == null || this.meta.get(fieldName).get(value) == null) {
            return new ArrayList<Integer>(0);
        }
        return this.meta.get(fieldName).get(value);
    }

    @Override
    public T getRecordForValue(String fieldName, Object value) throws NoSuchElementException, InvalidIndexException {
        if (this.meta.get(fieldName) == null) {
            throw new NoSuchElementException("No record matching meta index " + fieldName + " with value " + value);
        }
        ArrayList<Integer> matches = this.meta.get(fieldName).get(value);
        if (matches == null || matches.size() == 0) {
            throw new NoSuchElementException("No record matching meta index " + fieldName + " with value " + value);
        }
        if (matches.size() > 1) {
            throw new InvalidIndexException("Multiple records matching meta index " + fieldName + " with value " + value, fieldName);
        }
        return (T)((Persistable)this.data.get(matches.get(0)));
    }

    @Override
    public int add(T e) throws StorageFullException {
        this.data.put(DataUtil.integer(this.curCount), e);
        ++this.curCount;
        this.syncMeta();
        return this.curCount - 1;
    }

    @Override
    public void close() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean exists(int id) {
        return this.data.containsKey(DataUtil.integer(id));
    }

    @Override
    public Object getAccessLock() {
        return null;
    }

    @Override
    public int getNumRecords() {
        return this.data.size();
    }

    @Override
    public int getRecordSize(int id) {
        return 0;
    }

    @Override
    public int getTotalSize() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.data.size() > 0;
    }

    @Override
    public IStorageIterator<T> iterate() {
        return new DummyStorageIterator<T>(this.data);
    }

    @Override
    public T read(int id) {
        return (T)((Persistable)this.data.get(DataUtil.integer(id)));
    }

    @Override
    public byte[] readBytes(int id) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ((Persistable)this.data.get(DataUtil.integer(id))).writeExternal(new DataOutputStream(stream));
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't serialize data to return to readBytes");
        }
    }

    @Override
    public void remove(int id) {
        this.data.remove(DataUtil.integer(id));
        this.syncMeta();
    }

    @Override
    public void remove(Persistable p) {
        this.read(p.getID());
    }

    @Override
    public void removeAll() {
        this.data.clear();
        this.meta.clear();
    }

    @Override
    public List<Integer> removeAll(EntityFilter ef) {
        ArrayList<Integer> removed = new ArrayList<Integer>();
        Enumeration<Integer> en = this.data.keys();
        block4: while (en.hasMoreElements()) {
            Integer i = en.nextElement();
            switch (ef.preFilter(i, null)) {
                case 1: {
                    removed.add(i);
                    break;
                }
                case -1: {
                    continue block4;
                }
            }
            if (!ef.matches(this.data.get(i))) continue;
            removed.add(i);
        }
        for (Integer i : removed) {
            this.data.remove(i);
        }
        this.syncMeta();
        return removed;
    }

    @Override
    public void repack() {
    }

    @Override
    public void repair() {
    }

    @Override
    public void update(int id, T e) throws StorageFullException {
        this.data.put(DataUtil.integer(id), e);
        this.syncMeta();
    }

    @Override
    public void write(Persistable p) throws StorageFullException {
        if (p.getID() != -1) {
            this.data.put(DataUtil.integer(p.getID()), p);
            this.syncMeta();
        } else {
            p.setID(this.curCount);
            this.add((T)p);
        }
    }

    private void syncMeta() {
        this.meta.clear();
        Enumeration<Integer> en = this.data.keys();
        while (en.hasMoreElements()) {
            Integer i = en.nextElement();
            Externalizable e = (Externalizable)this.data.get(i);
            if (!(e instanceof IMetaData)) continue;
            IMetaData m = (IMetaData)((Object)e);
            for (String key : m.getMetaDataFields()) {
                if (this.meta.containsKey(key)) continue;
                this.meta.put(key, new Hashtable());
            }
            for (String key : this.dynamicIndices) {
                if (this.meta.containsKey(key)) continue;
                this.meta.put(key, new Hashtable());
            }
            Enumeration<String> keys = this.meta.keys();
            while (keys.hasMoreElements()) {
                ArrayList<Integer> indices;
                String key = keys.nextElement();
                Object value = m.getMetaData(key);
                Hashtable<Object, ArrayList<Integer>> records = this.meta.get(key);
                if (!records.containsKey(value)) {
                    records.put(value, new ArrayList(1));
                }
                if ((indices = records.get(value)).contains(i)) continue;
                records.get(value).add(i);
            }
        }
    }

    @Override
    public void setReadOnly() {
    }

    @Override
    public void registerIndex(String filterIndex) {
        this.dynamicIndices.add(filterIndex);
    }
}

