/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.form.api;

import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.ItemsetBinding;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.condition.Constraint;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.pivot.ConstraintHint;
import org.javarosa.core.model.condition.pivot.UnpivotableExpressionException;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.NoLocalizedTextException;
import org.javarosa.core.util.UnregisteredLocaleException;
import org.javarosa.form.api.FormEntryCaption;
import org.javarosa.formmanager.view.IQuestionWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormEntryPrompt
extends FormEntryCaption {
    private static final Logger logger = LoggerFactory.getLogger(FormEntryPrompt.class);
    TreeElement mTreeElement;
    boolean dynamicChoicesPopulated = false;

    protected FormEntryPrompt() {
    }

    public FormEntryPrompt(FormDef form, FormIndex index) {
        super(form, index);
        if (!(this.element instanceof QuestionDef)) {
            throw new IllegalArgumentException("FormEntryPrompt can only be created for QuestionDef elements");
        }
        this.mTreeElement = (TreeElement)form.getMainInstance().resolveReference(index.getReference());
    }

    public int getControlType() {
        return this.getQuestion().getControlType();
    }

    public int getDataType() {
        return this.mTreeElement.getDataType();
    }

    public String getPromptAttributes() {
        return null;
    }

    public IAnswerData getAnswerValue() {
        QuestionDef q = this.getQuestion();
        ItemsetBinding itemset = q.getDynamicChoices();
        if (itemset != null) {
            if (itemset.valueRef != null) {
                int i;
                List<SelectChoice> choices = this.getSelectChoices();
                ArrayList<String> preselectedValues = new ArrayList<String>();
                if (itemset.copyMode) {
                    TreeReference destRef = itemset.getDestRef().contextualize(this.mTreeElement.getRef());
                    List<TreeReference> subNodes = this.form.getEvaluationContext().expandReference(destRef);
                    for (i = 0; i < subNodes.size(); ++i) {
                        TreeElement node = (TreeElement)this.form.getMainInstance().resolveReference(subNodes.get(i));
                        String value = itemset.getRelativeValue().evalReadable(this.form.getMainInstance(), new EvaluationContext(this.form.getEvaluationContext(), node.getRef()));
                        preselectedValues.add(value);
                    }
                } else {
                    ArrayList<Selection> sels;
                    IAnswerData data = this.mTreeElement.getValue();
                    if (data instanceof MultipleItemsData) {
                        sels = (ArrayList<Selection>)data.getValue();
                    } else if (data instanceof SelectOneData) {
                        sels = new ArrayList<Selection>(1);
                        sels.add((Selection)data.getValue());
                    } else {
                        sels = new ArrayList(0);
                    }
                    for (i = 0; i < sels.size(); ++i) {
                        preselectedValues.add(((Selection)sels.get((int)i)).xmlValue);
                    }
                }
                ArrayList<Selection> selection = new ArrayList<Selection>();
                for (int i2 = 0; i2 < preselectedValues.size(); ++i2) {
                    String value = (String)preselectedValues.get(i2);
                    SelectChoice choice = null;
                    for (int j = 0; j < choices.size(); ++j) {
                        SelectChoice ch = choices.get(j);
                        if (!value.equals(ch.getValue())) continue;
                        choice = ch;
                        break;
                    }
                    if (choice == null) continue;
                    selection.add(choice.selection());
                }
                if (selection.size() == 0) {
                    return null;
                }
                if (q.getControlType() == 3 || q.getControlType() == 16) {
                    return new MultipleItemsData(selection);
                }
                if (q.getControlType() == 2) {
                    return new SelectOneData((Selection)selection.get(0));
                }
                throw new RuntimeException("can't happen");
            }
            return null;
        }
        return this.mTreeElement.getValue();
    }

    public String getAnswerText() {
        StringBuilder b;
        String text;
        IAnswerData data = this.getAnswerValue();
        if (data == null) {
            return null;
        }
        if (data instanceof SelectOneData) {
            text = this.getSelectItemText((Selection)data.getValue());
        } else if (data instanceof MultipleItemsData) {
            b = new StringBuilder();
            List values = (List)data.getValue();
            for (Selection value : values) {
                b.append(this.getSelectItemText(value)).append(" ");
            }
            text = b.toString();
        } else {
            text = data.getDisplayText();
        }
        if (this.getControlType() == 5) {
            b = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                b.append("*");
            }
            text = b.toString();
        }
        return text;
    }

    public String getConstraintText() {
        return this.getConstraintText(null);
    }

    public String getConstraintText(IAnswerData attemptedValue) {
        return this.getConstraintText(null, attemptedValue);
    }

    public String getConstraintText(String textForm, IAnswerData attemptedValue) {
        if (this.mTreeElement.getConstraint() == null) {
            return null;
        }
        EvaluationContext ec = new EvaluationContext(this.form.getEvaluationContext(), this.mTreeElement.getRef());
        if (textForm != null) {
            ec.setOutputTextForm(textForm);
        }
        if (attemptedValue != null) {
            ec.isConstraint = true;
            ec.candidateValue = attemptedValue;
        }
        String constraintMessage = this.mTreeElement.getConstraint().getConstraintMessage(ec, this.form.getMainInstance(), textForm);
        return this.substituteStringArgs(constraintMessage);
    }

    public List<TreeElement> getBindAttributes() {
        return this.mTreeElement.getBindAttributes();
    }

    public List<SelectChoice> getSelectChoices() {
        QuestionDef q = this.getQuestion();
        ItemsetBinding itemset = q.getDynamicChoices();
        if (itemset != null) {
            if (!this.dynamicChoicesPopulated) {
                this.form.populateDynamicChoices(itemset, this.mTreeElement.getRef());
                this.dynamicChoicesPopulated = true;
            }
            return itemset.getChoices();
        }
        return q.getChoices();
    }

    public void expireDynamicChoices() {
        this.dynamicChoicesPopulated = false;
        ItemsetBinding itemset = this.getQuestion().getDynamicChoices();
        if (itemset != null) {
            itemset.clearChoices();
        }
    }

    public boolean isRequired() {
        return this.mTreeElement.isRequired();
    }

    public boolean isReadOnly() {
        return !this.mTreeElement.isEnabled();
    }

    public QuestionDef getQuestion() {
        return (QuestionDef)this.element;
    }

    @Override
    public void register(IQuestionWidget viewWidget) {
        super.register(viewWidget);
        this.mTreeElement.registerStateObserver(this);
    }

    @Override
    public void unregister() {
        this.mTreeElement.unregisterStateObserver(this);
        super.unregister();
    }

    @Override
    public void formElementStateChanged(TreeElement instanceNode, int changeFlags) {
        if (this.mTreeElement != instanceNode) {
            throw new IllegalStateException("Widget received event from foreign question");
        }
        if (this.viewWidget != null) {
            this.viewWidget.refreshWidget(changeFlags);
        }
    }

    public String getHelpText() {
        if (!(this.element instanceof QuestionDef)) {
            throw new RuntimeException("Can't get HelpText for Elements that are not Questions!");
        }
        String textID = ((QuestionDef)this.element).getHelpTextID();
        String helpText = ((QuestionDef)this.element).getHelpText();
        String helpInnerText = ((QuestionDef)this.element).getHelpInnerText();
        try {
            helpText = textID != null ? this.substituteStringArgs(this.localizer().getLocalizedText(textID)) : this.substituteStringArgs(((QuestionDef)this.element).getHelpInnerText());
        }
        catch (NoLocalizedTextException noLocalizedTextException) {
        }
        catch (UnregisteredLocaleException ule) {
            logger.warn("No Locale set yet (while attempting to getHelpText())");
        }
        catch (Exception e) {
            logger.error("FormEntryPrompt.getHelpText", e);
        }
        return helpText;
    }

    public String getSelectItemText(Selection sel) {
        String tid;
        if (!(this.getFormElement() instanceof QuestionDef)) {
            throw new RuntimeException("Can't retrieve question text for non-QuestionDef form elements!");
        }
        if (sel == null) {
            throw new IllegalArgumentException("Cannot use null as an argument!");
        }
        if (sel.index == -1) {
            sel.attachChoice(this.getQuestion());
        }
        if ((tid = sel.choice.getTextID()) == null || tid.length() == 0) {
            return this.substituteStringArgs(sel.choice.getLabelInnerText());
        }
        String returnText = this.getIText(tid, "long");
        if (returnText == null) {
            returnText = this.getIText(tid, null);
        }
        return this.substituteStringArgs(returnText);
    }

    public String getSelectChoiceText(SelectChoice selection) {
        return this.getSelectItemText(selection.selection());
    }

    public String getSpecialFormSelectItemText(Selection sel, String form) {
        String textID;
        if (sel == null) {
            throw new IllegalArgumentException("Cannot use null as an argument for Selection!");
        }
        if (sel.index == -1) {
            sel.attachChoice(this.getQuestion());
        }
        if ((textID = sel.choice.getTextID()) == null || textID.length() == 0) {
            return null;
        }
        String returnText = this.getIText(textID, form);
        return this.substituteStringArgs(returnText);
    }

    public String getSpecialFormSelectChoiceText(SelectChoice sel, String form) {
        return this.getSpecialFormSelectItemText(sel.selection(), form);
    }

    public void requestConstraintHint(ConstraintHint hint) throws UnpivotableExpressionException {
        Constraint c = this.mTreeElement.getConstraint();
        if (c == null) {
            throw new UnpivotableExpressionException();
        }
        hint.init(new EvaluationContext(this.form.getEvaluationContext(), this.mTreeElement.getRef()), c.constraint, this.form.getMainInstance());
    }
}

