/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.javarosa.core.model.DataType;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.GeoShapeData;
import org.javarosa.core.model.data.GeoTraceData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.LongData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XFormAnswerDataParser {
    private static final Logger logger = LoggerFactory.getLogger(XFormAnswerDataParser.class.getSimpleName());

    public static IAnswerData getAnswerData(String text, int dataType) {
        return XFormAnswerDataParser.getAnswerData(text, dataType, null);
    }

    public static IAnswerData getAnswerData(String text, int intDataType, QuestionDef q) {
        String trimmedText = text.trim();
        if (trimmedText.length() == 0) {
            trimmedText = null;
        }
        switch (DataType.from(intDataType)) {
            case NULL: 
            case UNSUPPORTED: 
            case TEXT: 
            case BARCODE: 
            case BINARY: {
                return new StringData(text);
            }
            case INTEGER: {
                try {
                    return trimmedText == null ? null : new IntegerData(Integer.parseInt(trimmedText));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case LONG: {
                try {
                    return trimmedText == null ? null : new LongData(Long.parseLong(trimmedText));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case DECIMAL: {
                try {
                    return trimmedText == null ? null : new DecimalData(Double.parseDouble(trimmedText));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case CHOICE: {
                Selection selection = XFormAnswerDataParser.getSelection(text, q);
                return selection == null ? null : new SelectOneData(selection);
            }
            case MULTIPLE_ITEMS: {
                return new MultipleItemsData(XFormAnswerDataParser.getSelections(text, q));
            }
            case DATE_TIME: {
                Date dt = trimmedText == null ? null : DateUtils.parseDateTime(trimmedText);
                return dt == null ? null : new DateTimeData(dt);
            }
            case DATE: {
                Date d = trimmedText == null ? null : DateUtils.parseDate(trimmedText);
                return d == null ? null : new DateData(d);
            }
            case TIME: {
                Date t = trimmedText == null ? null : DateUtils.parseTime(trimmedText);
                return t == null ? null : new TimeData(t);
            }
            case BOOLEAN: {
                if (trimmedText == null) {
                    return null;
                }
                if (trimmedText.equals("1")) {
                    return new BooleanData(true);
                }
                if (trimmedText.equals("0")) {
                    return new BooleanData(false);
                }
                return trimmedText.equals("t") ? new BooleanData(true) : new BooleanData(false);
            }
            case GEOPOINT: {
                if (trimmedText == null) {
                    return new GeoPointData();
                }
                try {
                    return new GeoPointData().cast(new UncastData(trimmedText));
                }
                catch (Exception e) {
                    XFormAnswerDataParser.logGeoCreateError(GeoPointData.class, trimmedText, e);
                    return null;
                }
            }
            case GEOSHAPE: {
                if (trimmedText == null) {
                    return new GeoShapeData();
                }
                try {
                    return new GeoShapeData().cast(new UncastData(trimmedText));
                }
                catch (Exception e) {
                    XFormAnswerDataParser.logGeoCreateError(GeoShapeData.class, trimmedText, e);
                    return null;
                }
            }
            case GEOTRACE: {
                if (trimmedText == null) {
                    return new GeoTraceData();
                }
                try {
                    return new GeoTraceData().cast(new UncastData(trimmedText));
                }
                catch (Exception e) {
                    XFormAnswerDataParser.logGeoCreateError(GeoTraceData.class, trimmedText, e);
                    return null;
                }
            }
        }
        return new UncastData(trimmedText);
    }

    private static void logGeoCreateError(Class geoType, String trimmedText, Exception exception) {
        logger.warn("Could not create {} from \"{}\": {}", geoType.getSimpleName(), trimmedText, exception.toString());
    }

    private static List<Selection> getSelections(String text, QuestionDef q) {
        List<String> choices = DateUtils.split(text, " ", true);
        ArrayList<Selection> selections = new ArrayList<Selection>(choices.size());
        for (String choice : choices) {
            Selection s = XFormAnswerDataParser.getSelection(choice, q);
            if (s == null) continue;
            selections.add(s);
        }
        return selections;
    }

    private static Selection getSelection(String choiceValue, QuestionDef q) {
        SelectChoice choice;
        Selection s = q == null || q.getDynamicChoices() != null ? new Selection(choiceValue) : ((choice = q.getChoiceForValue(choiceValue)) != null ? choice.selection() : null);
        return s;
    }
}

