/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathExpression;

public class XPathNumericLiteral
extends XPathExpression {
    public double d;

    public XPathNumericLiteral() {
    }

    public XPathNumericLiteral(Double d) {
        this.d = d;
    }

    @Override
    public Object eval(DataInstance model, EvaluationContext evalContext) {
        return new Double(this.d);
    }

    public String toString() {
        return "{num:" + Double.toString(this.d) + "}";
    }

    public boolean equals(Object o) {
        if (o instanceof XPathNumericLiteral) {
            XPathNumericLiteral x = (XPathNumericLiteral)o;
            return Double.isNaN(this.d) ? Double.isNaN(x.d) : this.d == x.d;
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.d = in.readByte() == 0 ? (double)ExtUtil.readNumeric(in) : ExtUtil.readDecimal(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        if (this.d == (double)((int)this.d)) {
            out.writeByte(0);
            ExtUtil.writeNumeric(out, (int)this.d);
        } else {
            out.writeByte(1);
            ExtUtil.writeDecimal(out, this.d);
        }
    }
}

