/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./WebContent/js/app/aws.js"
/*!**********************************!*\
  !*** ./WebContent/js/app/aws.js ***!
  \**********************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globals */ "./WebContent/js/app/globals.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Functions for using aws services
 *
 */



var gLanguages;





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	setLanguageSelect: setLanguageSelect
});

		function setLanguageSelect ($elem, type, callback) {

			if(gLanguages) {
					updateSelection($elem, type, callback);
			} else {
					getLanguages($elem, type, callback);
			}
		}

		function updateSelection($elem, type, callback) {
			var h = [],
				idx = -1,
				i;

			for(i = 0; i < gLanguages.length; i++) {
				if(gLanguages[i][type]) {
					h[++idx] = '<option value="';
					h[++idx] = gLanguages[i].code;
					h[++idx] = '">';
					h[++idx] = htmlEncode(gLanguages[i].name);
					h[++idx] = '</option>';
				}
			}
			$elem.empty().html(h.join(''));
			if(typeof callback === "function") {
				callback();
			}
		}

		function getLanguages($elem, type, callback) {
			addHourglass();
			jquery__WEBPACK_IMPORTED_MODULE_0___default().ajax({
				url: "/surveyKPI/language_codes",
				dataType: 'json',
				cache: false,
				success: function(data) {
					removeHourglass();
					var $e = $elem;
					var t = type;
					var cb = callback;
					gLanguages = data;
					updateSelection($e, t, cb);
				},
				error: function(xhr, textStatus, err) {
					removeHourglass();
					if(xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + ": " + err);
					}
				}
			});
		}


/***/ },

/***/ "./WebContent/js/app/changeset.js"
/*!****************************************!*\
  !*** ./WebContent/js/app/changeset.js ***!
  \****************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globals */ "./WebContent/js/app/globals.js");
/* harmony import */ var _editorMarkup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./editorMarkup */ "./WebContent/js/app/editorMarkup.js");
/* harmony import */ var _option__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./option */ "./WebContent/js/app/option.js");
/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Module to manage the changeset of changes for editor
 */









let modelGeneratedChanges = [];

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
    add: add,
    undo: undo,
    save: save,
    setHasChanges: setHasChanges,
    addValidationError: addValidationError,
    removeValidationError: removeValidationError,
    validateItem: validateItem,
    validateName: validateName,
    updateModelWithErrorStatus: updateModelWithErrorStatus,
    validateAll: validateAll,
    numberIssues: numberIssues,
    addUpdateMessage: addUpdateMessage,
    updateViewControls: updateViewControls
});

		/*
		 * Add a new change item
		 */
        function add(change) {
            var refresh,
                $context,
                container,
                itemIndex,
                itemType;

            // Apply to model
            modelGeneratedChanges = [];
            refresh = updateModel(change);

			/*
			 * Validate updated model
			 */
            if(change.changeType === "property" || change.changeType === "label") {

                if (change.property.type === "option") {
                    container = change.property.optionList;
                    itemType = "option";
                } else {
                    container = change.property.formIndex;
                    itemType = "question";
                }
                itemIndex = change.property.itemIndex;

            } else if(change.changeType === "option") {

                container = change.option.optionList;
                itemIndex = change.option.itemIndex;
                itemType = "option";

            } else if(change.changeType === "question") {

                container = change.question.formIndex;
                itemIndex = change.question.itemIndex;
                itemType = "question";

            }
            if(typeof itemIndex !== "undefined") {		// Note some changes do not have an itemIndex and don't need to be validated

                validateItem(container, itemIndex, itemType, true);
            }

			/*
			 * Apply any HTML changes either directly to the changed element, or by refreshing the whole form using
			 * the updated model
			 */
            if(change.action === "delete" && typeof change.question !== "undefined") {
                $context = undefined;
                change.question.$deletedElement.prev().remove();		// remove the add new button
                change.question.$deletedElement.remove();
            } else {
                if(refresh) {
                    if(change.question || change.changeType === "optionlist" || (change.property && change.property.type === "question")) {
                        $context = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].refresh();
	                    validateAll();
                    } else {
                        $context = _option__WEBPACK_IMPORTED_MODULE_4__["default"].createChoiceView();
                        var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;
                        var question = survey.forms[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFormIndex].questions[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gItemIndex];
                        _option__WEBPACK_IMPORTED_MODULE_4__["default"].addOptionTable(question, _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFormIndex, _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gListName);
                        _option__WEBPACK_IMPORTED_MODULE_4__["default"].setupChoiceView(jquery__WEBPACK_IMPORTED_MODULE_0___default()('#filterType').val());
                    }
                } else {
                    $context = updateHtmlElement(change);
                }
            }

            // Add to changeset array ready for writing to the database
            addToChangesetArray(change);

            // Add any additional changes generated in the model
            for(var i = 0; i < modelGeneratedChanges.length; i++) {
                addToChangesetArray(modelGeneratedChanges[i]);
            }

            return $context;

        }

        function undo() {
        }

        // Save the survey
        function save(callback) {

            var url="/surveyKPI/surveys/save/" + _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentSurvey,
                changesString,
                changesInSeq = resequenceChangeSet(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes),
                i, j,
                item;

            // newVal and oldVal cannot be objects so if this is a property update
            // for a server calculation then they need to be stringified
            if(changesInSeq) {
                for(i = 0; i < changesInSeq.length; i++) {
                    if(changesInSeq[i].changeType === "property") {
                        for(j = 0; j < changesInSeq[i].items.length; j++) {
                            item = changesInSeq[i].items[j];
                            if(item.property && item.property.prop == 'server_calculation') {
                                if(item.property.oldVal && item.property.oldVal.expression) {
                                    item.property.oldVal = JSON.stringify(item.property.oldVal);
                                }
                                if(item.property.newVal  && item.property.newVal.expression) {
                                    item.property.newVal = JSON.stringify(item.property.newVal);
                                }
                            }
                        }
                    }
                }
            }
            changesString = JSON.stringify(changesInSeq);

            addHourglass();
            jquery__WEBPACK_IMPORTED_MODULE_0___default().ajax({
                url: url,
                type: 'PUT',
                dataType: 'json',
                cache: false,
                data: { changes: changesString },
                success: function(data) {
                    var responseFn = callback,
                        h = [],
                        idx = -1,
                        i;

                    removeHourglass();
                    _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSaveInProgress = false;
                    if(handleLogout(data)) {

                        setHasChanges(0);

                        if (typeof responseFn === "function") {
                            responseFn();
                        }

                        // Report success and failure
                        _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.lastChanges = data.changeSet;
                        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#successLabel .counter').html(data.success);
                        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#failedLabel .counter').html(data.failed);

                        if (data.success > 0) {
                            h[++idx] = '<div class="alert alert-success" role="alert">';
                            h[++idx] = '<p>';
                            h[++idx] = data.success;
                            h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_upd"];
                            h[++idx] = '</p>'
                            h[++idx] = '<ol>';
                            for (i = 0; i < data.changeSet.length; i++) {
                                h[++idx] = addUpdateMessage(data.changeSet[i], false);
                            }
                            h[++idx] = '</ol>';
                            h[++idx] = '</div>';
                        }
                        if (data.failed > 0) {
                            h[++idx] = '<div class="alert alert-danger" role="alert">';
                            h[++idx] = data.failed;
                            h[++idx] = " changes failed";
                            h[++idx] = '<ol>';
                            for (i = 0; i < data.changeSet.length; i++) {
                                h[++idx] = addUpdateMessage(data.changeSet[i], true);
                            }
                            h[++idx] = '</ol>';
                            h[++idx] = '</div>';
                        }

                        window.bootbox.alert(h.join(""));
                    }

                },
                error: function(xhr, textStatus, err) {
                    removeHourglass();
                    if(handleLogout(xhr.responseText)) {
                        _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSaveInProgress = false;

                        if (typeof responseFn === "function") {
                            responseFn();
                        }

                        if (xhr.readyState == 0 || xhr.status == 0) {
                            // Not an error
                        } else {
                            window.bootbox.alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_save"] + ' ' + err);
                        }
                    }
                }
            });

        }

        /*
         * Resequence a change array to allign with the sequences in the model
         */
        function resequenceChangeSet(changes) {

            var fo = [],
                i,
                newSeq = [];

            for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms.length; i++) {
                fo.push({});
            }

            // Set the sequence nuber as per the model
            for(i = 0; i < changes.length; i++) {
                if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].changeType === "question") {
                    var question = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].question;
                    if(question && _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].action === "add") {
                        var form = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms[question.formIndex];
                        for (var j = 0; j < form.qSeq.length; j++) {
                            if(form.qSeq[j] == question.itemIndex) {
                                question.seq = j;
                                fo[question.formIndex]["q"+j] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i];
                                break;
                            }
                        }
                    }
                }
            }

            // Put the question changes in the order of their sequence numbers
            for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms.length; i++) {
                var form = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms[i];
                for (var j = 0; j < form.qSeq.length; j++) {
                    if(fo[i]["q"+j]) {
                        newSeq.push(fo[i]["q"+j]);
                    }
                }
            }

            // Add any other changes
            for(i = 0; i < changes.length; i++) {
                if (_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].changeType !== "question"
                    || typeof _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].question === "undefined"
                    || _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].action !== "add"
                ) {
                    newSeq.push(changes[i]);
                }
            }

            return newSeq;

        }

		/*
		 * Add a single change item to the array of changes (changeset)
		 */
        function addToChangesetArray(change) {

            var type = change.property ? change.property.type : undefined;

            var ci = {
                    changeType: change.changeType,
                    type: type,
                    action: change.action,
                    items: []
                },
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                item,
                item_orig,
                forms_orig,
                optionListOrig,
                form,
                applyChange = true,
                changes = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes;

            // Delete any items containing jquery elements
            if(change.question) {
                delete change.question.$relatedElement;
                delete change.question.$deletedElement;
            }

			/*
			 * Add additional parameters to change object
			 */
            if(change.changeType === "label" || change.changeType === "property") {
                if(change.property.type === "question") {
                    item = survey.forms[change.property.formIndex].questions[change.property.itemIndex];
                    if(survey.forms_orig) {
                        forms_orig = survey.forms_orig[change.property.formIndex];
                        if (forms_orig) {
                            item_orig = forms_orig.questions[change.property.itemIndex];
                        }
                    }
                    change.property.name = item.name;
                    change.property.qId = item.id;
                    change.property.fId = item.fId;
                    change.property.childFormIndex = survey.forms.length - 1;
                    if(change.changeType === "property") {
                        setTypeSpecificChanges(change.property.prop, change, survey);
                    }
                } else if(change.property.type === "option") {
                    item = survey.optionLists[change.property.optionList].options[change.property.itemIndex];
                    optionListOrig = survey.optionLists_orig[change.property.optionList];
                    if(optionListOrig) {
                        item_orig = optionListOrig.options[change.property.itemIndex];
                    }
                    change.property.name = item.value;
                    change.property.o_id = item.id;
                    //if(change.changeType === "property") {
                    //	setOptionTypeSpecificChanges(change.property.prop, change, survey);
                    //}
                }

                if(change.changeType === "label") {
                    if(item_orig) {
                        change.property.oldVal = item_orig.labels[change.property.language][change.property.propType];
                    }

                    // Add a reference for the label
                    form = survey.forms[change.property.formIndex];
                    if(change.property.prop === "label" || change.property.prop === "media" && item.text_id) {
                        change.property.key = item.text_id;
                    } else if(change.property.prop === "hint" && item.hint_id) {
                        change.property.key = item.hint_id;
                    } else {
                        // Create reference for this new Label
                        if(change.property.type === "question") {
                            change.property.key = getFormPath(form) + "/" + item.name +
                                (change.property.prop === "hint" ? ":hint" : ":label");
                        } else if(change.property.type === "option") {
                            change.property.key = getFormPath(form) + "/" + change.property.qname + "/" + item.value + ":label";
                            change.property.o_id = item.id;
                        }
                    }
                } else {
                    if(item_orig) {
                        if(change.property.prop === "app_choices") {
                            change.property.oldVal = window.gAppChoiceArray.join(' ');
                        } else {
                            change.property.oldVal = item_orig[change.property.prop];
                        }
                    }
                }

                change.property.languageName = survey.languages[change.property.language].name;			// For logging the event

            } else if(change.changeType === "question") {
                form = survey.forms[change.question.formIndex];
                change.question.fId = form.id;
                if(change.action === "delete") {
                    item = survey.forms[change.question.formIndex].questions[change.question.itemIndex];
                    change.question.id = item.id;
                    change.question.name = item.name;
                    change.question.path = item.path;
                }
                //else {
                //	change.question.path = getFormPath(form) + "/" + change.question.name;
                //}
            } else if(change.changeType === "option") {
                if(change.action === "delete") {
                    item = survey.optionLists[change.option.optionList].options[change.option.itemIndex];
                    change.option.value = item.value;
                }
            }


			/*
			 * Add the change item to the array
			 */
            ci.items.push(change);
            if(change.action !== "add") {
                applyChange = removeDuplicateChange(changes, ci);
            }

			/*
			 * If this is a property update and the property is cascade_filters then convert to a string
			 * Filter values should be saved as a json string
			 */
            if(change.property) {
                if(change.property.type === "option" && change.property.prop === "cascade_filters") {
                    change.property.newVal = JSON.stringify(change.property.newVal);
                    change.property.oldVal = JSON.stringify(change.property.oldVal);
                }
            }

            if(applyChange) {
                if(change.property && (change.property.newVal !== change.property.oldVal)) {		// Add if the value has changed
                    changes.push(ci);
                } else if(change.action === "add" || change.action === "delete" || change.action === "move") {
                    changes.push(ci);
                }
            }
            setHasChanges(changes.length);

        }

		/*
		 * Annotate a change item with changes that are dependent on the type of the property
		 */
        function setTypeSpecificChanges(type, change, survey) {
            var i;
            if(type === "type") {
                var typeList = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.qTypes;

                for(i = 0; i < typeList.length; i++) {
                    if(change.property.newVal === typeList[i].type) {
                        change.property.setVisible = true;
                        change.property.visibleValue = typeList[i].visible;
                        change.property.sourceValue = typeList[i].source;
                        break;
                    }
                }
            }
        }

		/*
		 * Remove duplicate updates.  This simplifies the analysis of changes to a survey
		 * For example if the user sets the label to "x", then changes it to "y" the change recorded should only be "y"
		 */
        function removeDuplicateChange(changes, change) {

            var j,
                item,
                element,
                newItem,
                newElement,
                newElementType,
                elementType;

            newItem = change.items[0];
            if(newItem.question) {
                newElement = newItem.question;
                newElementType = "question";
            } else if(newItem.option) {
                newElement = newItem.option;
                newElementType = "option";
            } else if(newItem.property) {
                newElement = newItem.property;
                newElementType = newElement.type;
            } else if(newItem.changeType === "optionlist") {
                newElement = {
                    itemIndex: newItem.name
                };
                newElementType = newItem.changeType;
            }

            for(j = 0; j < changes.length; j++) {

                item = changes[j].items[0];
                if(item.question) {
                    element = item.question;
                    elementType = "question";
                } else if(item.option) {
                    element = item.option;
                    elementType = "option";
                } else if(item.property) {
                    element = item.property;
                    elementType = element.type;
                } else if(item.changeType === "optionlist") {
                    element = {
                        itemIndex: item.name
                    };
                    elementType = newItem.changeType;
                }

				/*
				 * Only remove duplicates if
				 * 		- The new and existing element types are the same, ie both question or both option
				 * 		- They refer to the same item
				 */
                if(elementType === newElementType && newElement.itemIndex === element.itemIndex) {
                    if((newElementType === "question" && newElement.formIndex === element.formIndex) ||
                        (newElementType === "option" && newElement.optionList === element.optionList) ||
                        (newElementType === "optionlist")) {

                        console.log("Update to an item that is already in the update queue");


						/*
						 * 1. If this is a property update and there is already another update to
						 * 		- the same property
						 *    then remove the first update
						 */
                        if(newItem.action === "update" 	&& newItem.changeType === "property"
                            && item.changeType === "property") {

                            if(newElement.prop === element.prop) {
                                changes.splice(j,1);	// Remove the old item and apply the new one
                                return true;
                            }

							/*
							 * 2. If this is a label update and there is already another update to
							 * 		- the same language
							 * 		- the same label type (in the propType attribute)
							 *    then remove the first update
							 */
                        } else if(newItem.action === "update" 	&& newItem.changeType === "label"
                            && item.changeType === "label") {

                            if(newElement.languageName === element.languageName &&
                                newElement.propType === element.propType) {
                                changes.splice(j,1);	// Remove the old item and apply the new one
                                return true;
                            }

							/*
							 * 3. If this is an update to a property or label and
							 *      - the existing item is newly added then
							 * 		- merge the update into the added item
							 */
                        } else if(newItem.action === "update"
                            && ((elementType === "question" && typeof element.qId === "undefined") ||
                            (elementType === "option" && item.action === "add"))
                            && (newItem.changeType === "label" || newItem.changeType === "property")) {

                            if(newItem.changeType === "label") {

                                if(!element.labels) {
                                    element.labels = [];
                                }
                                if(!element.labels[newElement.language]) {
                                    element.labels[newElement.language] = {};
                                }
                                element.labels[newElement.language][newElement.propType] = newElement.newVal;

                            } else {

                                element[newElement.prop] = newElement.newVal;

                            }

                            if(elementType === "question") {
                                if(newElement.prop === "name") {
                                    element["path"] = newElement.path;
                                }
                            } else {
                                if(newElement.prop === "value") {
                                    element["path"] = newElement.path;
                                }
                            }

                            return false;		// Don't apply the change it has been merged

							/*
							 * 4. If this is a move of an item
							 */
                        } else if(newItem.action === "move") {
							/*
							 * Remove any modifications to this deleted element
							 */
                            element.seq = newElement.seq;
                            return false;


							/*
							 * 5. If this is a delete of an item
							 */
                        } else if(newItem.action === "delete") {
							/*
							 * Remove any modifications to this deleted element
							 * If the item is a group question then also remove its group end
							 */
                            changes.splice(j,1);	// Remove this item
                            return true;

                        }
                    }
                }
            }

            return true;
        }

		/*
		 * Update settings when the number of changes to apply changes
		 */
        function setHasChanges(numberChanges) {

            if(numberChanges === 0) {
                _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes = [];
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_save_survey').addClass("disabled").prop("disabled", true).find('.badge').html(numberChanges);
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_languages,#m_required,#m_not_required').removeClass("disabled").prop("disabled", false);
            } else {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_save_survey').find('.badge').html(numberChanges);
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_languages,#m_required,#m_not_required').addClass("disabled").prop("disabled", true);
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_validate').removeClass("disabled").prop("disabled", false);
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_save_survey').removeClass("disabled").prop("disabled", false);
                //if(numberIssues("error") === 0) {
                //	$('.m_save_survey').removeClass("disabled").prop("disabled", false);
                //}
            }

        }


		/*
		 * Update the in memory model
		 */
        function updateModel(change) {
            var refresh = false,		// Set to true if the page needs to be refreshed with this change
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                question,
                theOption,
                property,
                length,
                i, j;

            if(change.property) {
				/*
				 * Update the property values
				 */
                property = change.property;

                if(property.type === "question") {			// Change to a question
                    question = survey.forms[property.formIndex].questions[property.itemIndex];
                    if(property.propType === "text" || property.propType === "hint") {		// Not a media change

                        if(property.prop === "label" || property.prop === "hint") {	   // Changing the label or hint

                            question.labels[property.language][property.propType] = property.newVal;

                        } else {						// Other properties, such as constraints, relevance question name

                            var oldVal;
                            if(property.prop === "app_choices") {
                                oldVal = window.gAppChoiceArray.join[' '];
                            } else {
                                oldVal = question[property.prop];
                            }
                            question[property.prop] = property.newVal;


                            if(property.setVisible) {
                                question["visible"] = property.visibleValue;
                                question["source"] = property.sourceValue;
                            }

							/*
							 * Set type dependent properties
							 */
                            if(property.prop === "type" || property.prop === "name") {

                                if(property.newVal.indexOf("select") == 0 || question.type.indexOf("select") == 0 ||
                                    property.newVal === "rank" || question.type === "rank") {	// Select question

                                    // Ensure there is a list name for this question
                                    if(!question.list_name && question.name) {
                                        question.list_name = question.name;
                                    }

                                    // Ensure there is a list of choices
                                    if(question.list_name) {
                                        var optionList = survey.optionLists[question.list_name];
                                        if(!optionList) {
                                            survey.optionLists[question.list_name] = {
                                                oSeq: [],
                                                options: []
                                            };
                                            _option__WEBPACK_IMPORTED_MODULE_4__["default"].refreshOptionListControls();
                                        }
                                    }

                                }
                            }


                            if(property.prop === "type") {

                                if(property.newVal == "begin repeat") {
                                    // New sub form
                                    survey.forms.push({
                                        id: undefined,
                                        name: survey.forms[property.formIndex].questions[property.itemIndex].name,  // name of question
                                        parentQuestionIndex: property.itemIndex,
                                        parentFormIndex: property.formIndex,
                                        questions: [],
                                        qSeq: []
                                    });
                                    question.childFormIndex = survey.forms.length - 1;

                                }

                                // Fix ups depending on oldVal
                                var newFormIdx;
                                var oldFormIdx;
                                var endQuestionIdx;
                                var groupMembers = [];
                                var mvStartIdx;
                                var itemIndex;
                                if(oldVal === "note") {
                                    // Remove the readonly status
                                    modelGeneratedChanges.push({
                                        changeType: "property",
                                        action: "update",
                                        source: "editor",
                                        property: {
                                            type: "question",
                                            prop: "readonly",
                                            newVal: false,
                                            language: property.language,
                                            formIndex: property.formIndex,
                                            itemIndex: property.itemIndex
                                        }
                                    });
                                    question.readonly = false;
                                } else if(oldVal === "begin group") {
                                    console.log("xxxxxxx fix up begin group");
                                    if(property.newVal === "begin repeat") {
                                        console.log("xxxxxxx move questions to repeat");
                                        // Move the questions in the group to the new form
                                        newFormIdx = question.childFormIndex;
                                        oldFormIdx = property.formIndex;
                                        oldLocation = property.itemIndex;
                                        newLocation = 0;
                                        endQuestionIdx = 0;

                                        name = question.name;
                                        endName = name + "_groupEnd";

										/*
										 * Get the questions to move
										 * Start from one past the begin group
										 */
                                        oldLocation++;
                                        for(i = oldLocation; i < survey.forms[oldFormIdx].qSeq.length; i++) {

                                            // Don't include the group end or any questions after it
                                            if(survey.forms[oldFormIdx].questions[survey.forms[oldFormIdx].qSeq[i]].name.toLowerCase() === endName.toLowerCase()) {
                                                endQuestionIdx = i;
                                                break;
                                            }
                                            groupMembers.push(survey.forms[oldFormIdx].qSeq[i]);
                                        }

										/*
										 * Move the group members
										 */
                                        mvStartIdx = oldLocation;
                                        for(i = 0; i < groupMembers.length; i++) {

                                            itemIndex = moveQuestion(survey, survey.forms[oldFormIdx].questions[groupMembers[i]],
                                                newFormIdx,
                                                newLocation++,
                                                oldFormIdx,
                                                mvStartIdx++);

                                            // Add the move to the changeset
                                            modelGeneratedChanges.push({
                                                changeType: "question",
                                                action: "move",
                                                source: "editor",
                                                question: {

                                                    type: survey.forms[oldFormIdx].questions[groupMembers[i]].type,
                                                    formIndex: newFormIdx,
                                                    itemIndex: itemIndex,
                                                    sourceFormIndex: oldFormIdx,
                                                    sourceItemIndex: survey.forms[oldFormIdx].questions[groupMembers[i]].itemIndex,
                                                    sourceFormId: survey.forms[oldFormIdx].id,
                                                    name: survey.forms[oldFormIdx].questions[groupMembers[i]].name
                                                }
                                            });

                                            console.log("xxxxx moved");
                                        }

                                    }
                                    console.log("xxxxxxx remove end group");
                                    applyToEndGroup(survey.forms[oldFormIdx], question.name, oldLocation, "delete", undefined, undefined);
                                    refresh = true;
                                } else if(oldVal === "begin repeat") {
                                    console.log("xxxxxxx fix up begin repeat");
                                    if(property.newVal === "begin group") {
                                        console.log("xxxxxxx move questions to group");

                                        // Move the questions in the repeat to the group
                                        newFormIdx = property.formIndex;
                                        newLocation = property.itemIndex + 1; // After the begin group
                                        oldLocation = 0;
                                        endQuestionIdx = 0;
                                        oldFormIdx = getSubFormIndex(newFormIdx, property.itemIndex);

                                        name = question.name;
                                        endName = name + "_groupEnd";

										/*
										 * Get the questions to move
										 */
                                        groupMembers = [];
                                        for(i = oldLocation; i < survey.forms[oldFormIdx].qSeq.length; i++) {
                                            groupMembers.push(survey.forms[oldFormIdx].qSeq[i]);
                                        }

										/*
										 * Move the group members
										 */
                                        mvStartIdx = oldLocation;
                                        for(i = 0; i < groupMembers.length; i++) {

                                            itemIndex = moveQuestion(survey, survey.forms[oldFormIdx].questions[groupMembers[i]],
                                                newFormIdx,
                                                newLocation++,
                                                oldFormIdx,
                                                mvStartIdx++);

                                            // Record the group that this question has been added to
                                            survey.forms[newFormIdx].questions[survey.forms[newFormIdx].qSeq[newLocation - 1]].memberGroup = name;

                                            // Add the move to the changeset
                                            modelGeneratedChanges.push({
                                                changeType: "question",
                                                action: "move",
                                                source: "editor",
                                                question: {

                                                    type: survey.forms[oldFormIdx].questions[groupMembers[i]].type,
                                                    formIndex: newFormIdx,
                                                    itemIndex: itemIndex,
                                                    sourceFormIndex: oldFormIdx,
                                                    sourceItemIndex: survey.forms[oldFormIdx].questions[groupMembers[i]].itemIndex,
                                                    sourceFormId: survey.forms[oldFormIdx].id,
                                                    name: survey.forms[oldFormIdx].questions[groupMembers[i]].name
                                                }
                                            });

                                            console.log("yyyy moved");
                                        }

                                    }
                                    refresh = true;
                                }


                            } else if(property.prop === "name") {
                                // update the end group name
                                if(survey.forms[property.formIndex].questions[property.itemIndex].type === "begin group") {
                                    applyToEndGroup(survey.forms[property.formIndex],
                                        oldVal, 0, "rename", property.newVal, undefined);

                                }
                            }

							/*
							 * If this is a change to a begin group then refresh the entire form
							 */
                            if(survey.forms[property.formIndex].questions[property.itemIndex].type === "begin group") {
                                refresh = true;
                            }


                        }

                    } else {
                        // For non text changes update all languages
                        for(i = 0; i < survey.forms[property.formIndex].questions[property.itemIndex].labels.length; i++) {
                            survey.forms[property.formIndex].questions[property.itemIndex].labels[i][property.propType] = property.newVal;
                            survey.forms[property.formIndex].questions[property.itemIndex].labels[i][property.propType + "Url"] =
                                _getUrl(property.newVal, false, property.propType, property.isSurveyLevel, survey.id);
                        }
                    }
                } else if(property.type === "option") {	// Change to an option

                    theOption = survey.optionLists[property.optionList].options[property.itemIndex];
                    theOption[property.prop] = property.newVal;

                    if(property.propType === "text") {
                        if(property.prop === "label") {
                            survey.optionLists[property.optionList].options[property.itemIndex].labels[property.language][property.propType] = property.newVal;
                        }
                    } else {
                        // For non text changes update all languages
                        for(i = 0; i < survey.optionLists[property.optionList].options[property.itemIndex].labels.length; i++) {
                            survey.optionLists[property.optionList].options[property.itemIndex].labels[i][property.propType] = property.newVal;
                            survey.optionLists[property.optionList].options[property.itemIndex].labels[i][property.propType + "Url"] =
                                _getUrl(property.newVal, false, property.propType, property.isSurveyLevel, survey.id);
                        }
                    }
                } else if(property.type === "optionlist") {	// Change to an optionlist
                    // 1. Rename the option list
                    survey.optionLists[property.newVal] = survey.optionLists[property.oldVal];
                    delete survey.optionLists[property.oldVal];

                    // 2. Update all questions that refer to this option list so they reference the new one
                    for(i = 0; i < survey.forms.length; i++) {
                        for(j = 0; j < survey.forms[i].questions.length; j++) {
                            if(survey.forms[i].questions[j].list_name === property.oldVal) {
                                survey.forms[i].questions[j].list_name = property.newVal
                            }
                        }
                    }

                    //3.  Update the optionList property for all options in the changed optionList
                    for(i = 0; i < survey.optionLists[property.newVal].options.length; i++) {
                        survey.optionLists[property.newVal].options[i].optionList = property.newVal;
                    }
                } else {
                    console.log("Error: unknown property type: " + property.type);
                }

            } else if(change.changeType === "question") {		// Not a change to a property
                if(change.action === "move") {

                    var sourceForm = change.question.sourceFormIndex;
                    var sourceItem = change.question.sourceItemIndex;
                    var targetForm = change.question.formIndex;
                    var oldLocation = change.question.sourceSeq;
                    var newLocation = change.question.seq;
                    var question = survey.forms[sourceForm].questions[sourceItem];
                    var name = question.name;
                    var endName;
                    var form;

                    if(question.type === "begin group") {	// Move all the group members
                        name = question.name;
                        endName = name + "_groupEnd";
                        form = survey.forms[sourceForm];

						/*
						 * Get the questions to move
						 */
                        var groupMembers = [];
                        for(i = oldLocation; i < form.qSeq.length; i++) {

                            groupMembers.push(form.qSeq[i]);
                            if(form.questions[form.qSeq[i]].name.toLowerCase() === endName.toLowerCase()) {
                                break;
                            }
                        }

						/*
						 * Move the group members
						 */
                        for(i = 0; i < groupMembers.length; i++) {

                            moveQuestion(survey, form.questions[groupMembers[i]],
                                targetForm,
                                newLocation++,
                                sourceForm,
                                oldLocation++);

                            console.log("moved");
                        }

                    } else {

                        // Move the single question
                        change.question.itemIndex = moveQuestion(survey, question,
                            targetForm,
                            newLocation,
                            sourceForm,
                            oldLocation);
                        
                        // Fix up the form being moved to point to its new parent
                        var movedForm;
                        if(question.type === "begin repeat") {
                            // Get the form being moved
                            for(i = 0; i < survey.forms.length; i++) {
                                movedForm = survey.forms[i];
                                if(movedForm.parentFormIndex === sourceForm && movedForm.parentQuestionIndex === sourceItem) {
                                    movedForm.parentFormIndex = targetForm;
                                    movedForm.parentform = survey.forms[targetForm].id;
                                    movedForm.parentQuestionIndex = change.question.itemIndex;
                                    break;
                                }
                            }
                        }

                    }
                    refresh = true;		// Do a complete refresh after moving questions

                } else if(change.action === "add") {
                    length = survey.forms[change.question.formIndex].questions.push(change.question);			// Add the new question to the end of the array of questions
                    change.question.itemIndex = length -1;
                    survey.forms[change.question.formIndex].qSeq.splice(change.question.seq, 0, length - 1);	// Update the question sequence array

                    if(change.question.firstQuestion) {
                        refresh = true;		// Refresh all the questions when adding the first question to a form
                    } else if(change.question.type === "end group") {
                        refresh = false;
                    }

                    // Add a subform if required
                    if(change.question.type === "begin repeat") {
                        // New sub form
                        survey.forms.push({
                            id: undefined,
                            name: change.question.name,
                            parentQuestionIndex: change.question.itemIndex,
                            parentFormIndex: change.question.formIndex,
                            questions: [],
                            qSeq: []
                        });
                        change.question.childFormIndex = survey.forms.length - 1;
                    }

                    refresh = true;			// DEBUG - remove after fixing update of html

                } else if(change.action === "delete") {
                    var form = survey.forms[change.question.formIndex];
                    var question = form.questions[change.question.itemIndex];
                    form.qSeq.splice(change.question.seq, 1);	// Remove item from the sequence array
                    question.deleted = true;	// Mark deleted
                    if(question.type === "begin group") {
                        applyToEndGroup(form, question.name, change.question.seq, "delete", undefined, change.question.formIndex);
                        refresh = true;
                    }
                } else {
                    console.log("Unknown action: " + change.action);
                }


            } else if(change.changeType === "option") {				// Change to an option
                if(change.action === "move") {

                    var sourceOptionList = survey.optionLists[change.option.sourceOptionList];
                    var targetOptionList = survey.optionLists[change.option.optionList];

                    var theOption = sourceOptionList.options[change.option.sourceItemIndex];
                    var newOption = jQuery.extend(true, {}, theOption);
                    var oldLocation = change.option.sourceSeq;
                    var newLocation = change.option.seq;

                    // 1. Add the option in the new location
                    length = targetOptionList.options.push(newOption);
                    change.option.itemIndex = length -1;
                    change.option.value = theOption.value;
                    targetOptionList.oSeq.splice(change.option.seq, 0, length - 1);

                    // 2. Remove the option from the old location
                    // The old location may have changed if the new location was inserted before it
                    if(newLocation < oldLocation && change.option.sourceOptionList == change.option.optionList) {
                        oldLocation++;
                    }
                    sourceOptionList.oSeq.splice(oldLocation, 1);
                    theOption.deleted = true;

                    // 3. Update any items in the change list to the new location
                    if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes) {
                        for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes.length; i++) {
                            var existingChange = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i];
                            if(existingChange.changeType === "option") {
                                for(j = 0; j < existingChange.items.length; j++) {
                                    var existingItem = existingChange.items[j];
                                    if(existingItem.option.optionList === theOption.optionList &&
                                        existingItem.option.itemIndex === theOption.itemIndex) {
                                        // We moved an option thats in the change queue
                                        existingItem.option.optionList = change.option.optionList;
                                        existingItem.option.itemIndex = change.option.itemIndex;
                                    }
                                }
                            }
                        }
                    }
                    refresh = true;

                } else if(change.action === "add") {
                    length = survey.optionLists[change.option.optionList].options.push(change.option);			// Add the new option to the end of the array of options
                    change.option.itemIndex = length -1;
                    survey.optionLists[change.option.optionList].oSeq.splice(change.option.seq, 0, length - 1);	// Update the option sequence array

                } else if(change.action === "delete") {
                    survey.optionLists[change.option.optionList].oSeq.splice(change.option.seq, 1);	// Remove item from the sequence array
                    survey.optionLists[change.option.optionList].options[change.option.itemIndex].deleted = true;
                } else {
                    console.log("Unknown action: " + change.action);
                }

            } else if(change.changeType === "optionlist") {				// Change to an option list
                if(change.action === "add") {
                    survey.optionLists[change.name] = {
                        oSeq: [],
                        options: []
                    };
                    refresh = true;
                } else if(change.action === "delete") {
                    delete survey.optionLists[change.name];
                    refresh = true;
                } else {
                    console.log("Unknown action: " + change.action);
                }
            }
            return refresh;
        }

		/*
		 * Move a question
		 */
        function moveQuestion(survey, question, targetForm, newLocation, sourceForm, oldLocation) {

            var newQuestion = jQuery.extend(true, {}, question),
                itemIndex,
                i,j,
                change,
                item,
                length;

            // 1. Add the question in the new location
            length = survey.forms[targetForm].questions.push(newQuestion);			// Add the new question to the end of the array of questions
            itemIndex = length - 1;
            survey.forms[targetForm].qSeq.splice(newLocation, 0, length - 1);	// Update the question sequence array

            // 1.5 Update the sequences stored in the question objects
            //for(i = 0; i < survey.forms[targetForm].qSeq.length; i++) {
            //	var idx = survey.forms[targetForm].qSeq[i];
            //    survey.forms[targetForm].questions[idx].seq = i;
            //}

            // 2. Remove the question from the old location
            // The old location may have changed if the new location was inserted before it
            if(newLocation < oldLocation && sourceForm === targetForm) {
                oldLocation++;
            }
            survey.forms[sourceForm].qSeq.splice(oldLocation, 1);
            question.deleted = true;

            // 3. Update any items in the change list to put to the new location
            if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes) {
                for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes.length; i++) {
                    change = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i];
                    if(change.changeType === "question") {
                        for(j = 0; j < change.items.length; j++) {
                            item = change.items[j];
                            if(item.question.formIndex === question.formIndex &&
                                item.question.itemIndex === question.itemIndex) {
                                // We moved a question thats in the change queue
                                item.question.formIndex = targetForm;
                                item.question.itemIndex = itemIndex;
                                item.question.fId = survey.forms[targetForm].id;
                            }
                        }
                    }
                }
            }

            // Update the model
            question.itemIndex = itemIndex;
            question.formIndex = targetForm;

            return itemIndex;
        }
		/*
		 * Apply a change to the "end group" of a group
		 */
        function applyToEndGroup(form, name, start_seq, action, new_name, form_index) {
            var i,
                end_name = name + "_groupEnd";

            // Remove the group from the model
            for(i = start_seq; i < form.qSeq.length; i++) {
                if(form.questions[form.qSeq[i]].name === end_name) {
                    if(action === "delete") {
                        form.questions[form.qSeq[i]].deleted = true;
                        form.qSeq.splice(i, 1);
                    } else if(action === "rename") {
                        form.questions[form.qSeq[i]].name = new_name + "_groupEnd";
                    }
                    break;
                } else {

                    // Delete the member
                    if(action === "delete"  && typeof form_index !== "undefined") {
                        modelGeneratedChanges.push({
                            changeType: "question",
                            action: "delete",
                            source: "editor",
                            question: {
                                seq: i,
                                formIndex: form_index,
                                itemIndex: i
                            }
                        });
                    }
                }
            }

            // Remove group end from the pending changes list
            for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes.length; i++) {
                if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].question) {
                    if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].question.name === end_name) {
                        if(action === "delete") {
                            _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes.splice(i, 1);
                        } else if(action === "rename") {
                            _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].question.name = new_name + "_groupEnd";
                        }
                    }
                }
            }

        }

		/*
		 * Update the modified HTML element
		 */
        function updateHtmlElement(change) {
            var newMarkup,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                $changedRow,
                i,
                collapsedPanels = [];

            if(change.changeType === "label") {
                if(change.property.propType === "image") {

                    newMarkup = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Image",
                        change.property.newVal,
                        _getUrl(change.property.newVal, false, 'image', change.property.isSurveyLevel, survey.id),
                        _getUrl(change.property.newVal, true, 'image', change.property.isSurveyLevel, survey.id)
                    );

                } else if(change.property.propType === "video") {

                    newMarkup = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Video",
                        change.property.newVal,
                        _getUrl(change.property.newVal, false, 'video', change.property.isSurveyLevel, survey.id),
                        _getUrl(change.property.newVal, true, 'video', change.property.isSurveyLevel, survey.id)
                    );

                } else if(change.property.propType === "audio") {

                    newMarkup = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Audio",
                        change.property.newVal,
                        _getUrl(change.property.newVal, false, 'audio', change.property.isSurveyLevel, survey.id),
                        undefined
                    );

                }

                if(newMarkup) {
                    if(change.property.type === "question") {
                        $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#question' + change.property.formIndex + '_' + change.property.itemIndex);
						/*
						 $changedRow = $('#formList').find('li.question').filter(function(index){
						 var $this = $(this);
						 return $this.data("fid") == change.property.formIndex && $this.data("id") == change.property.itemIndex;
						 });
						 */
                    } else {

                        $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView').find('tr').filter(function(index){
                            var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
                            return $this.data("id") == change.property.itemIndex;
                        });
                    }

                    if($changedRow) {
                        $changedRow.find('.' + change.property.propType + 'Element').replaceWith(newMarkup);
                    }
                }
            } else if(change.changeType === "question") {

                var form = survey.forms[change.question.formIndex];

                if(change.action === "add") {
                    var preceedingQuestion = form.questions[form.qSeq[change.question.seq-1]];
                    if(change.question.locn === "after") {
                        change.question.$relatedElement.after(_editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addOneQuestion(form, change.question, change.question.formIndex, change.question.itemIndex, true, undefined, false));
                    } else {
                        change.question.$relatedElement.prev().before(_editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addOneQuestion(form, change.question, change.question.formIndex, change.question.itemIndex, true, undefined, false));
                    }
                    $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()("#question" + change.question.formIndex + "_" + change.question.itemIndex);

                } else if(change.action === "delete") {
                    change.question.$deletedElement.prev().remove();	// Remove the add before button
                    change.question.$deletedElement.remove();
                }
            } else if(change.changeType === "option") {
                if(change.action === "add") {
                    var optionList,
                        $ref;


                    optionList = survey.optionLists[change.option.optionList];

                    // get the new markup
                    newMarkup = _option__WEBPACK_IMPORTED_MODULE_4__["default"].addOneOption(optionList,
                        change.option,
                        change.option.formIndex,
                        change.option.itemIndex,
                        change.option.optionList,
                        change.option.qName);


                    $ref = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView').find('.editor_element').
                    filter(function(index) {
                        var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
                        return $this.data("id") == change.option.optionIndex;
                    });

                    if(change.option.locn == "after") {
                        $ref.after(newMarkup);
                        $changedRow = $ref.next();
                    } else if(change.option.locn == "before") {
                        $ref.before(newMarkup);
                        $changedRow = $ref.prev();
                    } else {
                        // put at end of table
                        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView tbody').append(newMarkup);
                        $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView tbody tr:last');
                    }

                } else if(change.action === "delete") {
                    change.option.$deletedElement.remove();
                }
            } else if(change.changeType === "property") {
                // Apply any markup changes that result from a property change


                // 1. Update the question / option
                if(change.property.type === "option") {
					/*
					 * No option property changes result in markup changes
					 */
                } else if(change.property.type === "question") {

                    // Get the changed question row
                    $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList').find('li.question').filter(function(index){
                        var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
                        return $this.data("fid") == change.property.formIndex && $this.data("id") == change.property.itemIndex;
                    });

                    newMarkup = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addOneQuestion(
                        survey.forms[change.property.formIndex],
                        survey.forms[change.property.formIndex].questions[change.property.itemIndex],
                        change.property.formIndex,
                        change.property.itemIndex,
                        false, undefined, true);

                }

				/*
				 * Apply the update
				 */
                if($changedRow) {

                    // Get the current list of collapsed panels
                    jquery__WEBPACK_IMPORTED_MODULE_0___default()('.collapse.show', $changedRow).each(function(){
                        collapsedPanels.push(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).closest('li').attr("id"));
                    });

                    // Update the content view
                    $changedRow.replaceWith(newMarkup);

                    // Restore collapsed panels
                    for(i = 0; i < collapsedPanels.length; i++) {
                        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + collapsedPanels[i]).find('.collapse').addClass("show");
                    }

                    // Since we replaced the row we had better get the replaced row so that actions can be reapplied
                    if(change.property.type === "option") {
                        $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList').find('li.option').filter(function(index){
                            var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
                            return $this.data("fid") == change.property.formIndex && $this.data("id") == change.property.itemIndex;
                        });
                    } else {
                        $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList').find('li.question').filter(function(index){
                            var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
                            return $this.data("fid") == change.property.formIndex && $this.data("id") == change.property.itemIndex;
                        });
                    }
                }

            }


            return $changedRow;
        }

        function getQuestionsUsingOptionList(list) {
            var i, j,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                forms = survey.forms,
                question,
                nameArray = [];

            for(i = 0; i < forms.length; i++) {
                for(j = 0; j < forms[i].questions.length; j++) {
                    question = forms[i].questions[j];
                    if(!question.deleted &&  !question.soft_deleted &&
                        (question.type.indexOf("select") === 0 || question.type === "rank") &&
                        question.list_name === list) {

                        nameArray.push(question.name);
                    }
                }
            }
            return nameArray;
        }

		/*
		 * Media functions
		 */
        function _getUrl(newVal, thumbs, type, isSurveyLevel, sId) {
            var url = "/surveyKPI/file/",
                filebase,
                ext,
                index;

            if(newVal) {

                // Videos and other derived thumbnails will have type jpg
                if(thumbs && type !== "image") {
                    index = newVal.lastIndexOf('.');
                    filebase = url.substr(0, index);
                    newVal = filebase + ".jpg";
                }

                url += newVal;

                if(isSurveyLevel) {
                    url += "/survey/"
                    url += sId;
                } else {
                    url += "/organisation";
                }

                if(thumbs) {
                    url += "?thumbs=true";
                }


            } else {
                url = undefined;
            }

            return url;
        }

		/*
		 * Create a message from response to a save request
		 */
        function addUpdateMessage(data, forError) {
            var h = [],
                idx = -1,
                j,
                action,
                result,
                name;

            if(data.updateFailed && forError) {
                h[++idx] = '<li>';
                h[++idx] = data.errorMsg;
                h[++idx] = '</li>';
            } else if(!data.updateFailed && !forError) {
                for(j = 0; j < data.items.length; j++) {
                    h[++idx] = '<li>';
                    h[++idx] = getChangeDescription(data.items[j]);
                    h[++idx] = '</li>';
                }
            }

            return h.join("");
        }

		/*
		 * ***************************************************************
		 * Validate each change to a question or option
		 */
        function validateItem(container, itemIndex, itemType, removeExisting) {

            var i, j,
                form,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                item,
                name,
                isDeleted,
                isValid = true,
                hasDuplicate = false,
                changes = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes,
                numberErrors,
                numberWarnings;

            if(itemType === "question") {
                item = survey.forms[container].questions[itemIndex];
                name = item.name;
            } else if(itemType === "option") {
                item = survey.optionLists[container].options[itemIndex];
                name = item.value;
            } else if(itemType === "optionlist") {
                item = survey.optionLists[container];
                name = container;
            }

			/*
			 * Remove the existing error
			 * If this validation has been called by validateAll() then this removal would already have been done
			 */
            if(removeExisting) {
                removeValidationError(container, itemIndex,	"item", itemType);
            }

            if(!item.deleted &&
                ((itemType === "question" && _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].includeQuestion(item)) ||
                (itemType === "optionlist") ||
                (itemType === "option"))) {

                // Validate the name
                isValid = validateName(container, itemIndex, name, itemType, removeExisting);

				/*
				 * Question specific validations
				 */
                if(itemType === "question") {

                    // Check references to other questions
                    isValid = checkReferences(container, itemIndex, itemType, item);
                    isValid = checkSelfReferences(container, itemIndex, itemType, item);

                    if(isValid) {	// Check parenthesis on relevant
                        isValid = checkParentheisis(container, itemIndex, itemType, item.relevant);
                    }

                    if(isValid) {	// Check parenthesis on constraint
                        isValid = checkParentheisis(container, itemIndex, itemType, item.constraint);
                    }

                    if(isValid) {	// Check parenthesis on calculation
                        isValid = checkParentheisis(container, itemIndex, itemType, item.calculation);
                    }

                    if(isValid) {	// Check parenthesis on choiceFilter
                        isValid = checkParentheisis(container, itemIndex, itemType, item.choice_filter);
                    }

	                if(isValid && (item.type === "child_form" || item.type === "parent_form")) {	// Check that form launch types have a reference form

	                    if(item.parameters && item.parameters.indexOf("form_identifier") >= 0) {
	                        isValid = true;
	                    } else {
	                        isValid = false;
		                    addValidationError(
			                    container,
			                    itemIndex,
			                    "item",
			                    _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_f_l"],	// Only one geometry question can be added to a form
			                    itemType,
			                    "error");
	                    }

	                }

	                if(isValid && item.type === "begin repeat") {	// Check that a repeat group has children

	                    var itemx = item;
		                var childFormIndex = getSubFormIndex(item.formIndex, itemIndex);
		                var questions = survey.forms[childFormIndex].questions;
                        var isEmpty = true;

                        if(questions.length > 0) {
                            isEmpty = false;
                        }

                        if(isEmpty) {
	                        isValid = false;
	                        addValidationError(
		                        container,
		                        itemIndex,
		                        "item",
		                        _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_emp_rep"],
		                        itemType,
		                        "warning");
                        }
	                }

	                if(isValid && item.type === "begin group") {	// Check that a group has children

		                var endName = item.name + "_groupEnd";
		                var questions = survey.forms[item.formIndex].questions;
		                var qSeq = survey.forms[item.formIndex].qSeq;
		                var isEmpty = true;
		                var inGroup = false;

                        if(!qSeq) {
                            qSeq = [];
                        }
		                /*
						 * Get the questions in the group
						 */
		                for(j = 0; j < qSeq.length; j++) {

		                    if(inGroup === true) {
			                    if (questions[qSeq[j]].name.toLowerCase() === endName.toLowerCase()) {
				                    break;
			                    } else {
				                    isEmpty = false;
				                    break;
			                    }
		                    }

			                if(qSeq[j] === itemIndex) {
				                inGroup = true;
			                }

		                }

		                if(isEmpty && inGroup) {
			                isValid = false;
			                addValidationError(
				                container,
				                itemIndex,
				                "item",
				                _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_emp_rep"],
				                itemType,
				                "warning");
		                }
	                }


                } else if(itemType === "option") {
                    // Check references to other questions
                    isValid = checkReferences(container, itemIndex, itemType, item);
                }

                if(!isValid) {
                    updateModelWithErrorStatus(container, itemIndex, itemType);	// Update model and DOM
                }

				/*
				 * If there were no errors check for warnings
				 * Only do this on validateAll as otherwise it is just annoying to get the warnings
				 */
                if(!removeExisting) {
                    if(isValid) {
                        if(item.visible || itemType === "option") {
                            isValid = checkBlankLabels(container, itemIndex, itemType, item, "warning");
                        }
                    }

                    if(isValid) {
                        if(item.visible && itemType === "question") {
                            isValid = checkMissingChoices(container, itemIndex, itemType, item, "warning");
                        }
                    }
                }
            }

            // Set the control buttons
            numberErrors = numberIssues("error");
            numberWarnings = numberIssues("warning");

            jquery__WEBPACK_IMPORTED_MODULE_0___default()('.error-count').html(numberErrors);
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('.warning-count').html(numberWarnings);

            //if(numberErrors > 0) {
            //	$('.m_save_survey').addClass("disabled").prop("disabled", true);
            //} else
            if(changes.length > 0) {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_save_survey').removeClass("disabled").prop("disabled", false);
            }

            if(numberErrors > 0 || numberWarnings > 0) {

                jquery__WEBPACK_IMPORTED_MODULE_0___default()('#error-nav-btns').show();
                if(numberErrors > 0) {
                    jquery__WEBPACK_IMPORTED_MODULE_0___default()('#next-error').removeClass("disabled");
                } else {
                    jquery__WEBPACK_IMPORTED_MODULE_0___default()('#next-error').addClass("disabled");
                }
                if(numberWarnings > 0) {
                    jquery__WEBPACK_IMPORTED_MODULE_0___default()('#next-warning').removeClass("disabled");
                } else {
                    jquery__WEBPACK_IMPORTED_MODULE_0___default()('#next-warning').addClass("disabled");
                }
            }  else {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('#error-nav-btns').hide();
            }

        }

		/*
		 * Check for blank labels
		 */
        function checkBlankLabels(container, itemIndex, itemType, item) {
            var i,
                valid = true;

            for(i = 0; i < item.labels.length; i++) {
                if(typeof item.labels[i].text === "undefined" ||
                    (typeof item.labels[i].text === "undefined" && item.labels[i].text.trim().length === 0)) {
                    if(itemType === "question" && (item.type === "begin repeat" || item.type === "begin group")) {
                        continue;		// Don't report warnings on blank labels for these question types
                    }
                    addValidationError(
                        container,
                        itemIndex,
                        "item",
                        _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_bll"] + " " + htmlEncode(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.languages[i].name),
                        itemType,
                        "warning");
                    valid = false;
                    break;
                }
            }

            return valid;
        }

		/*
		 * Check for Missing choices in a select questions
		 */
        function checkMissingChoices(container, itemIndex, itemType, item) {
            var i,
                valid = true,
                survey;

            if(item.type.indexOf('select') === 0 || item.type === "rank") {
                if(typeof _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists[item.list_name] === "undefined") {
                    valid = false;
                }
                if(valid) {
                    var list = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists[item.list_name].options;
                    valid = false;
                    for(i = 0; i < list.length; i++) {
                        if(!list[i].deleted) {
                            valid = true;
                            break;
                        }
                    }
                }

                if(!valid) {
                    addValidationError(
                        container,
                        itemIndex,
                        "item",
                        "No choices in the choice list ",
                        itemType,
                        "warning");
                    valid = false;
                }

            }


            return valid;
        }

		/*
		 * Check for mismatched parenthesis
		 */
        function checkParentheisis(container, itemIndex, itemType, elem) {
            var i,
                c,
                depth = 0,
                lastOpen,
                errorText,
                isValid = true,
                locn;

            if(elem) {
                for(i = 0; i < elem.length; i++) {
                    c = elem.charAt(i);
                    if( c === '(') {
                        depth++;
                        locn = i;
                    } else if( c === ')') {
                        depth--;
                        locn = i;
                    }
                    if(depth < 0) {
                        break;
                    }
                }

                if(depth != 0) {
                    errorText = "Mis-matched parenthesis: " + elem.slice(0, locn) + '<b><span style="color:red;">' +
                        elem.slice(locn, locn + 1) +
                        '</span></b>' +
                        elem.slice(locn + 1);

                    addValidationError(
                        container,
                        itemIndex,
                        "item",
                        "Mis-matched parenthesis: " + errorText,
                        itemType,
                        "error");
                    isValid = false;
                }
            }

            return isValid;
        }

		/*
		 * Return false if the calculation is not valid
		 */
        function checkReferences(container, itemIndex, itemType, item) {

            var refQuestions = {},
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                form,
                i, j,
                name;

            // Get a list of references to other questions
            if(itemType  === "question") {
                getReferenceNames(item.relevant, refQuestions);
                getReferenceNames(item.constraint, refQuestions);
                getReferenceNames(item.calculation, refQuestions);
                getReferenceNames(item.choice_filter, refQuestions);
            }
            for(i = 0; i < item.labels.length; i++) {
                var text = item.labels[i].text;
                if(typeof text === "string") {
                    getReferenceNames(item.labels[i].text, refQuestions);
                }
            }

            if(checkExistenceOfReferences(refQuestions, survey)) {

                for (name in refQuestions) {
                    if (refQuestions.hasOwnProperty(name)) {
                        if (!refQuestions[name].exists) {
                            addValidationError(
                                container,
                                itemIndex,
                                "item",
                                _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_question"] + " ${" + name + "} " + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_not_f"],
                                itemType,
                                "error");
                            return false;
                        }
                    }
                }
            }

            return true;

        }

        /*
         * Return false if the calculation is not valid
         */
        function checkSelfReferences(container, itemIndex, itemType, item) {

            var refQuestions = {},
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                form,
                i, j,
                name;

            // Get a list of references to other where self cannot be references
            if(itemType  === "question") {
                getReferenceNames(item.relevant, refQuestions);
                getReferenceNames(item.calculation, refQuestions);
                getReferenceNames(item.choice_filter, refQuestions);
            }
            for(i = 0; i < item.labels.length; i++) {
                var text = item.labels[i].text;
                if(typeof text === "string") {
                    getReferenceNames(item.labels[i].text, refQuestions);
                }
            }

            var refCount = 0;
            for (name in refQuestions) {
                if (refQuestions.hasOwnProperty(name)) {
                    refCount++;
                }
            }

            if(refCount > 0) {

                form = survey.forms[container];
                var otherItem = form.questions[itemIndex];
                var questionType = otherItem.type;
                if (!otherItem.deleted && !otherItem.soft_deleted && questionType !== "end group") {

                    for (name in refQuestions) {
                        if (refQuestions.hasOwnProperty(name)) {
                            if (name === otherItem.name) {
                                addValidationError(
                                    container,
                                    itemIndex,
                                    "item",
                                    _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_question"] + " ${" + name + "} " + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["e_h_c1"],
                                    itemType,
                                    "error");
                                return false;
                            }
                        }
                    }

                }

            }

            return true;

        }

		/*
		 * Error types:  name || dupname || noname || dupgeom
		 */
        function addValidationError(container, itemIndex, errorType, msg, itemType, severity) {

            // Push error into validation array
            _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors.push({
                container: container,
                itemIndex: itemIndex,
                errorType: errorType,
                itemType: itemType,
                msg: msg,
                severity: severity
            });

            updateModelWithErrorStatus(container, itemIndex, itemType);

        }

		/*
		 * Update the model and the DOM to report any erors on the question
		 */
        function updateModelWithErrorStatus(container, itemIndex, itemType) {

            var $changedRow,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                hasError = false,
                hasWarning = false,
                msg = "",
                i,
                errors = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors,
                item;

            if(itemType === "question") {
                item = survey.forms[container].questions[itemIndex];
                $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#question' + container + '_' + itemIndex);
            } else if(itemType === "option" || itemType === "optionlist") {
                item = survey.optionLists[container];
                $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#ol_' + container);
            }

            for(i = errors.length - 1; i >= 0; i--) {
                if(errors[i].itemType === itemType && errors[i].container === container &&
                    errors[i].itemIndex === itemIndex) {

                    if(errors[i].severity === "error") {
                        hasError = true;
                        msg = errors[i].msg;
                    } else {
                        hasWarning = true;
                        if(!hasError) {
                            msg = errors[i].msg;
                        }
                    }

                    if(errors[i].errorType === "name") {	// Break on name errors as this is the highest level error to show
                        break;
                    }

                }
            }

            // Update Model
            if(typeof item !== "undefined") {
                item.error = hasError;
                item.warning = hasWarning;
                item.errorMsg = msg;
            }

            // Update DOM
            $changedRow.find('.error-msg').html(msg);	// Add message
            if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gShowingChoices) {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()(".choice_filter_error").html(msg);
            }

            $changedRow.removeClass("error warning");
            if(hasError) {
                $changedRow.addClass("error");
                if(itemType === "question") {
                    $changedRow.find('.question_type').addClass("disabled");
                }
            } else {

                if(itemType === "question" && !item.published) {
                    $changedRow.find('.question_type').removeClass("disabled");
                }

                if(hasWarning) {
                    $changedRow.addClass("warning");
                }

            }
        }

		/*
		 * Remove the specified error type (see addValidationError for error types)
		 */
        function removeValidationError(container, itemIndex, errorType, itemType) {

            var i,
                $changedRow,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;

            // Remove error
            for(i = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors.length - 1; i >= 0; i--) {
                if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors[i].itemType === itemType &&
                    _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors[i].container === container &&
                    _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors[i].itemIndex === itemIndex &&
                    _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors[i].errorType === errorType) {
                    _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors.splice(i, 1);
                }
            }

            updateModelWithErrorStatus(container, itemIndex, itemType);  // Update model

        }

		/*
		 * Validate a question or option name
		 */
        function validateName(container, itemIndex, val, itemType, removeExisting) {

            var i, j,
                form,
                optionList,
                otherItem,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                isValid = true,
                hasDuplicate = false,
                hasDuplicateOption = false,
                itemDesc,
                questionType,
                question,
                valLower;

            if(itemType === "question") {
                question = survey.forms[container].questions[itemIndex];
            }

            // Clear the existing name validation errors
            if(removeExisting) {
                removeValidationError(
                    container,
                    itemIndex,
                    "name",
                    itemType);
            }

            if(itemType === "question" ) {
                itemDesc = "question";
            } else if(itemType === "option" ) {
                itemDesc = "choice";
            } else if(itemType === "optionlist" ) {
                itemDesc = "choice list";
            } else {
                itemDesc = "unknown";
            }

            // Check for empty name
            if(typeof val === "undefined" || val === "") {
                addValidationError(
                    container,
                    itemIndex,
                    "name",
                    "This " + itemDesc + " does not have a name.  Specify a unique name.",
                    itemType,
                    "error");
                isValid = false;
            }

            // Check for invalid characters
            if(isValid) {
                if(itemType === "question") {
                    isValid = isValidODKQuestionName(val);

                    if(!isValid) {
                        addValidationError(
                            container,
                            itemIndex,
                            "name",
                            _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_vq"],
                            itemType,
                            "error");

                    }

                } else {
                    isValid = isValidODKOptionName(val);

                    if(!isValid) {
                        addValidationError(
                            container,
                            itemIndex,
                            "name",
                            _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_vc"] + " : "  + htmlEncode(val),
                            itemType,
                            "error");

                    }
                }
            }

			/*
			 * Question name change require the questions in all the forms to be validated for duplicates
			 */
            if(isValid) {

                valLower = val.toLowerCase();

                if(itemType === "question") {
                    for(i = 0; i < survey.forms.length; i++) {
                        form = survey.forms[i];
                        for(j = 0; j < form.questions.length; j++) {
                            questionType = form.questions[j].type;
                            if(questionType !== "end group") {
                                if(!(i === container && j === itemIndex)) {	// Don't test the question against itself!
                                    otherItem = form.questions[j];
                                    if(otherItem.name.toLowerCase() === valLower) {
                                        if((!otherItem.deleted && !otherItem.soft_deleted)
                                            || (otherItem.soft_deleted && otherItem.type !== questionType)) {
                                            hasDuplicate = true;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }

                } else if(itemType === "option") {
                    optionList = survey.optionLists[container];
                    for(j = 0; j < optionList.options.length; j++) {
                        if(j !== itemIndex) {
                            otherItem = optionList.options[j];
                            if(!otherItem.deleted && otherItem.value.toLowerCase() === valLower) {
                                hasDuplicateOption = true;
                                break;
                            }
                        }
                    }
                } else if(itemType === "optionlist") {
                    if(container === val) {
                        // no change its valid
                    } else {
                        optionList = survey.optionLists[val];
                        if(typeof optionList !== "undefined") {
                            hasDuplicate = true;
                        }
                    }
                }
                if(hasDuplicate || hasDuplicateOption) {
                    addValidationError(
                        container,
                        itemIndex,
                        "name",
                        "The " + itemDesc + " name is the same as the name of another " + itemDesc +".  Specify a unique name.",
                        itemType,
                        hasDuplicate ? "error" : "warning");
                    isValid = false;
                }

            }

            return isValid;

        }

		/*
		 * Get the path for the form from the top level form down
		 */
        function getFormPath(form) {
            var path = form.name,
                forms = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms,
                i;
            while(form.parentFormIndex !== -1) {
                for(i = 0; i < forms.length; i++) {
                    if(i === form.parentFormIndex) {
                        form = forms[i];
                        path = form.name + "/" + path;
                        break;
                    }
                }
            }
            path = "/" + path;
            return path;
        }

		/*
		 * Validate the entire survey
		 */
        function validateAll() {
            var i,
                j,
                forms = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms,
                optionLists = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists,
                list,
                numberErrors = 0,
                numberWarnings = 0;

            _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors = [];		// Clear the existing errors
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('tr.editor_element.error', '#choiceView').removeClass("error");
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('tr.editor_element.warning', '#choiceView').removeClass("warning");
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('li.card.error', '#formList').removeClass("error");
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('li.card.warning', '#formList').removeClass("warning");

            for(i = 0; i < forms.length; i++) {
                var deleted = false;
                var parentForm = forms[i].parentFormIndex;
                var parentQuestion = forms[i].parentQuestionIndex;
                if(parentForm > -1 && parentQuestion > -1) {
                    deleted = forms[parentForm].questions[parentQuestion].deleted;
                }
                if(!deleted) {
                    var validate = true;
                    var groupName;
                    for (j = 0; j < forms[i].questions.length; j++) {
                        // Skip deleted groups
                        if(validate) {
                            if (!forms[i].questions[j].deleted && !forms[i].questions[j].soft_deleted) {
                                validateItem(i, j, "question", false);		// Validate the question
                            } else {
                                if(forms[i].questions[j].type === "begin group") {
                                    groupName = forms[i].questions[j].name;
                                    validate = false;
                                }
                            }
                        } else {
                            if(forms[i].questions[j].type === "end group") {
                                if(forms[i].questions[j].name.indexOf(groupName) > 0) {
                                    validate = true;
                                }
                            }
                        }
                    }
                }
            }
            for(list in optionLists) {
                if(optionLists.hasOwnProperty(list)) {
                    for(j = 0; j < optionLists[list].options.length; j++) {
                        validateItem(list, j, "option", false);		// Validate the option
                    }
                }

                // Validate the option list itself
                validateItem(list, "ol_" + list, "optionlist", false);
            }

        }

        function numberIssues(severity) {
            var i,
                count = 0;

            for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors.length; i++) {
                if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors[i].severity === severity) {
                    count++;
                }
            }
            return count;
        }

        function getSubFormIndex(parentFormIndex, parentQuestionIndex) {

            var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                forms = survey.forms,
                i,
                form;

            for(i = 0; i < forms.length; i++) {
                form = forms[i];
                if(forms[i].parentFormIndex === parentFormIndex && forms[i].parentQuestionIndex === parentQuestionIndex) {
                    return i;
                }
            }

            return 0;
        }

        /*
         * Modify controls that are dependent on the view being either for questions or choices
         */
        function updateViewControls() {

            //if(globals.gSelProperty !== "media") {		// media is the only common attribute between question and option view
            //	globals.gSelProperty = "label";
            //}
            if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gIsQuestionView && !_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gShowingChoices) {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.q_only').show();
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.o_only').hide();
                _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelLabel = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#selProperty > a.q_only.default').text();
            } else {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.q_only').hide();
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.o_only').show();
                _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelLabel = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#selProperty > a.o_only.default').text();
            }
            _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty = "label";
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('#propSelected').text(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelLabel);
        }


/***/ },

/***/ "./WebContent/js/app/editorMarkup.js"
/*!*******************************************!*\
  !*** ./WebContent/js/app/editorMarkup.js ***!
  \*******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globals */ "./WebContent/js/app/globals.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
uSMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Functions for manipulating a question in the editor
 */







let gGroupStacks = [];
const linkedQuestions = {};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({	
	addOneQuestion: addOneQuestion,
	addPanelStyle: addPanelStyle,
	addQType: addQType,
	addQuestions: addQuestions,
	addMedia: addMedia,
	refresh: refresh,
	includeQuestion: includeQuestion,
	addQuestionSequence: addQuestionSequence,
	getLinkedQuestions: getLinkedQuestions,
	refreshQuestionFeaturedProperties: refreshQuestionFeaturedProperties
});
	
	/*
	 * Add a single question
	 */
	function addOneQuestion(form, question, formIndex, qIndex, addNewButton, selProperty, update) {
		var h = [],
			idx = -1,
			questionId = "question" + formIndex + "_" + qIndex;
		
		// Support the legacy geopolygon and geolinestring types
		if(question.type === "geopolygon" || question.type === "geolinestring") {
			question.type = "begin repeat";
		}
		
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gHasItems = true;
		if(!update) {					// Only increment maxQuestion if a new question is being added
			form.maxQuestion++;
		}
		
		selProperty = selProperty || _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty;
		
		if(addNewButton) {
			h[++idx] = addNewQuestionButton(false, false, formIndex, undefined, selProperty);
		}
		
		// Add the group to the group stack
		if(question.type === "begin group" && gGroupStacks[formIndex]) {
			gGroupStacks[formIndex].groupStack.push(question.name);
		}
		
		h[++idx] = addPanelStyle(question.type, formIndex, qIndex, question.error, questionId, undefined);
		h[++idx] = '<div class="card-body">';
			h[++idx] = addErrorMsg(question.errorMsg);
			h[++idx] = '<div class="row">';
				
			// Add question type
				h[++idx] = '<div class="col-sm-2 col-12 ">';
					h[++idx] = '<div class="question_type';
						if(question.published) {
							h[++idx] = ' readonly';
						}
						h[++idx] = '">';
						h[++idx] = addQType(question.type);
					h[++idx] = '</div>';
				h[++idx] = '</div>';	// End of question type cell

				// Add question name cell
				h[++idx] = '<div class="col-sm-3 col-12 "><input class="qname form-control has_tt" data-toggle="tooltip" title="';
				h[++idx] = question.name;
				h[++idx] = '" value="';
				h[++idx] = question.name;
				h[++idx] = '" ';
						
				if(question.published) {				// Mark disabled if the question has been published
					h[++idx] = 'readonly="true" ';
				}
				h[++idx] = 'type="text"></div>';		// End of name

				// Add feature property cell
				h[++idx] = addFeaturedProperty(question, formIndex, qIndex, undefined, undefined, questionId);
				
				// Add buttons
				h[++idx] = '<div class="col-sm-2 col-12 q_icons_col">';
					h[++idx] = '<div class="btn-group">';

						h[++idx] = '<button tabindex="-1" class="btn btn-light delete_question ml-1" data-id="';
						h[++idx] = questionId;
						h[++idx] = '">';
						h[++idx]='<i class="fas fa-trash-alt edit_icon"></i>';
						h[++idx]='</button>';

						if(question.type === "begin repeat" 
								|| question.type === "begin group") {
							
							h[++idx] = '<a button tabindex="-1" class="btn btn-light ml-1" data-toggle="collapse" href="#collapse';
							h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gElementIndex;
							h[++idx]='"><i class="fas fa-chevron-down edit_icon"></i></a>';
						} else if(question.type.indexOf("select") === 0 || question.type === "rank") {
						
							h[++idx] = '<a button tabindex="-1" class="btn btn-light edit_choice ml-1" ';
							h[++idx]='"><i class="fa fa-edit edit_icon"></i></a>';
							
						}
					 
					h[++idx] = '</div>';
				h[++idx] = '</div>';		// End of button cell
				h[++idx] = '</div>';		// End of row
		h[++idx] = '<div id="collapse';
		h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gElementIndex;
		h[++idx] = '" class="panel-body collapse';
		if(question.type.indexOf("select") === 0 || question.type === "rank") {
			h[++idx] = ' selectquestion';
		}
		h[++idx] = '">';
		if(question.type === "begin repeat") {
			
			h[++idx] = '<div class="question-controls">';
			h[++idx] = '<div class="row">';
				h[++idx] = '<div class="col-md-6"></div>';		
				// A control to set repeat count
					h[++idx] = '<div class="col-md-6">';
						h[++idx] = '<label>Repeat Count: </label>';
						h[++idx] = '<div class="input-group">';
							h[++idx] = '<input class="form-control repeat-counts" value="';
							h[++idx] = question.calculation;
							h[++idx] = '">';
						h[++idx] = '</div>';
					h[++idx] = '</div>';
				h[++idx] = '</div>';
			h[++idx] = '</div>';
		
			h[++idx] = addSubForm(formIndex, qIndex);
			
		} 
		
		if(question.type === "begin group") {	/* Add questions up to the end group to this panel */
			h[++idx] = '<ul class="list-unstyled">';
		} else { 
			h[++idx] = '</div>';
			h[++idx] = '</li>';
		}
		
		return h.join("");
	}
	

	/*
	 * Add a single option list element to the choices view
	 */
	function addOneOptionList(list_name, addNewButton, selProperty) {
		
		var h = [],
			idx = -1,
			itemId = "ol_" + list_name,
			optionList = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists[list_name];
		
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gHasItems = true;
		
		selProperty = selProperty || _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty;
		
		if(addNewButton) {
			h[++idx] = addNewQuestionButton(false, false, undefined, undefined, selProperty);		
		}
		
		h[++idx] = addPanelStyle("choices", undefined, undefined, optionList.error, itemId, list_name);
		h[++idx] = '<div class="card-body">';
		h[++idx] = addErrorMsg(optionList.errorMsg);
		h[++idx] = '<div class="row">';

		// Add choice name cell
		h[++idx] = '<div class="col-10"><input class="olname form-control has_tt" data-toggle="tooltip" title="List Name" value="';
		h[++idx] = list_name;
		h[++idx] = '" type="text"></div>';

		// Add buttons
		h[++idx] = '<div class="col-2 q_icons_col">';
		h[++idx] = '<div class="btn-group">';

		h[++idx] = '<a button tabindex="-1" class="btn btn-light edit_choice" data-id="';
		h[++idx] = itemId;
		h[++idx] = '"><i class="fa fa-edit edit_icon"></i></a>';

		h[++idx] = '<a button tabindex="-1" class="btn btn-light delete_ol" data-id="';
		h[++idx] = itemId;
		h[++idx]= '"><i class="fa fa-times-circle edit_icon text-danger" aria-hidden="true"></i></a>';

		h[++idx] = '</div>';		// End of button group
		h[++idx] = '</div>';		// End of button group cell
		h[++idx] = '</div>';		// End of row
		h[++idx] = '</div>';		// End of card
		h[++idx] = '</li>';			// End of list item


		return h.join("");
	}
	
	function addErrorMsg(msg) {
		var h = [],
			idx = -1;
		
		h[++idx] = '<p class="error-msg">';
		h[++idx] = htmlEncode(msg);
		h[++idx] = '</p>';
		return h.join("");
	}
	
	function addNewQuestionButton(after, topLevelForm, formIndex, formName, selProperty) {
		var h = [],
			idx = -1,
			addButtonClass,
			locn;
		
		//console.log(" Group Stack: " + gGroupStacks[formIndex].groupStack.join(",") + " : Last group: " + gGroupStacks[formIndex].lastGroup);
		
		addButtonClass = after ? 'add_after_button add_button' : 'add_before_button add_button';
		locn = after ? 'after' : 'before';
		
		if(topLevelForm && locn === "after") {
			addButtonClass += ' add_final_button';
		}
		
		h[++idx] = '<li>';
		h[++idx] = '<span>';

		h[++idx] = '<button id="addnew_';
		h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gNewQuestionButtonIndex++;
		h[++idx] = '" type="button" class="add_question btn dropon ';
		h[++idx] = addButtonClass;
		if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gNewQuestionButtonIndex == 1) { // First button in the form
			h[++idx] = ' first_element ';
		}
		if(!(topLevelForm && locn === "after")) {
			h[++idx] = '" tabindex="-1"';
		} else {
			h[++idx] = '"';
		}
		h[++idx] = ' data-locn="';
		h[++idx] = locn;
		h[++idx] = '" data-findex="';
		h[++idx] = formIndex;

		h[++idx] = '">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_aq'];
		if(formName) {
			h[++idx] = ' - ';
			h[++idx] = formName;
		}

		h[++idx] = '</button>';
		h[++idx] = '</span>';
		h[++idx] = '</li>';
		
		return h.join('');
	}
	
	function addNewOptionListButton() {
		var h = [],
			idx = -1,
			locn;
		
		h[++idx] = '<li>';
	
		h[++idx] = '<button tabindex="-1" id="addnew_optionlist" ';
		h[++idx] = 'type="button" class="add_option_list add_button add_after_button add_final_button btn">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_ancl"];
		h[++idx] = '</button>';
		h[++idx] = '</li>';
		
		return h.join('');
	}
	
	/*
	 * Add the container for an editable element including its styling
	 */
	function addPanelStyle(type, formIndex, qIndex, error, elementId, list_name) {
		
		var h = [],
			idx = -1;
		
		h[++idx] = '<li class="card editor_element question draggable';

		if(error) {
			h[++idx] = ' error ';
		}
		
		if(type === "begin repeat" || type === "begin group") {
			h[++idx] = ' bg-secondary" id="';
		} else {
			h[++idx] = ' bg-light" id="';
		}
		h[++idx] = elementId;
		++_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gElementIndex;
		h[++idx] = '"';
		
		// Add the question index and form index
		if(typeof formIndex !== "undefined") {
			h[++idx] = ' data-fid="';
			h[++idx] = formIndex;
			h[++idx] = '"';
		}
		if(typeof qIndex !== "undefined") {
			h[++idx] = ' data-id="';
			h[++idx] = qIndex;
			h[++idx] = '"';
		}
		if(typeof list_name !== "undefined") {
			h[++idx] = ' data-list_name="';
			h[++idx] = list_name;
			h[++idx] = '"';
		}
		
		
		h[++idx] = '>';
		
		return h.join('');
	}
	
	function addQType(type) {
		
		var i,
			j,
			tArray,
			types = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.qTypes,
			h = [],
			idx = -1,
			name;
	
		for(i = 0; i < types.length; i++) {
			if(types[i].type === type) {
				name = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set[types[i].trans];
				h[++idx] = '<span class="has_tt" data-toggle="tooltip" title="Question type: ';
				h[++idx] = name;
				h[++idx] = '">';
				if(types[i].icon) {
					tArray = types[i].icon.split(',');
					for(j = 0; j < tArray.length; j++) {
						h[++idx] = '<i class="fas fa-';
						h[++idx] = tArray[j].trim();
						h[++idx] = ' edit_type"></i>';
					}
				} else if(types[i].image) {
					h[++idx] = '<img class="edit_image" src="';
					h[++idx] = types[i].image; 
					h[++idx] = '">';
				} else if(types[i].text) {
					h[++idx] = '<span class="edit_type">';
					h[++idx] = types[i].text; 
					h[++idx] = '</span>';
				}
				h[++idx] = '</span>';
				break;
			}
		}	
		return h.join('');

	}
	
	/*
	 * One of the questions properties will be featured so that it can be edited in the header without expanding the question
	 */
	function addFeaturedProperty(question, fId, qIndex, list_name, qname, questionId) {
		
		var h = [],
			idx = -1,
			type = "question";
		
		if(list_name) {
			type = "option";
		}
		
		h[++idx] = '<div class="col-sm-5 col-12 ';
		h[++idx] = type;
	
		h[++idx] = '">';
		
		if(list_name) {
			type = "option";
		}
		h[++idx] = getFeaturedMarkup(question, type, questionId);
		
		h[++idx] = '</div>';
		return h.join("");
	}

	/*
	 * Get Featured Markup for the question
	 */
	function getFeaturedMarkup(question, type, questionId) {
		var h = [],
			idx = -1,
			i,
			//linkedSurveys = globals.model.survey.linkedSurveys,
			selProperty = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty,
			selLabel = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelLabel,
			naMedia = '<div class="naMedia text-center">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_namedia"] + '</div>';
		
			if(selProperty === "required" && type === "question"
				&& question.type != "calculate") {		// Add a boolean type
				
				h[++idx] = '<div class="row">';
				
				h[++idx] = '<div class="col-sm-4">';
			    h[++idx] = '<button type="button" class="btn labelButton ';
			    if(question[selProperty]) {
			    	h[++idx] = 'prop_yes" ';
			    } else {
			    	h[++idx] = 'prop_no" ';
			    }
			    h[++idx] = ' data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				if(question[selProperty]) {
					h[++idx] = '<i class="fa fa-check-circle" aria-hidden="true"></i> ';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_yes"];
				} else {
					h[++idx] = '<i class="fa fa-times-circle" aria-hidden="true"></i> ';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_no"];
				}
			    h[++idx] = '</button>';
			    h[++idx] = '</div>';

			    /*
			     * Add the text area for the required response text
			     */
			    h[++idx] = '<div class="col-sm-4';
				if(!question[selProperty]) {
					h[++idx] = ' d-none';
				}
				h[++idx] = '">';
			    h[++idx] = '<textarea class="labelProp has_tt" tabindex="0" title="';
			    h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_msg'];
				h[++idx] = '" data-prop="required_msg" placeholder="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_msg'];
				h[++idx] = '">';
				h[++idx] = question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].required_msg;
				h[++idx] = '</textarea>';
			    h[++idx] = '</div>';

				/*
                * Add the text area for conditional required
                */
				h[++idx] = '<div class="col-sm-4';
				if(!question[selProperty]) {
					h[++idx] = ' d-none';
				}
				h[++idx] = '">';
				h[++idx] = '<textarea class="labelProp has_tt" tabindex="0" title="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_expression'];
				h[++idx] = '" data-prop="required_expression" placeholder="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_expression'];
				h[++idx] = '">';
				h[++idx] = question.required_expression;
				h[++idx] = '</textarea>';
				h[++idx] = '</div>';
			    
				h[++idx] ='</div>';		// End Row
				
			} else if(selProperty === "readonly" && type === "question"
				&& question.type != "calculate") {		// Add a boolean type
				
				h[++idx] = '<div class="row">';
				
				h[++idx] = '<div class="col-sm-6">';
			    h[++idx] = '<button type="button" class="btn labelButton ';
			    if(question[selProperty]) {
			    	h[++idx] = 'prop_yes" ';
			    } else {
			    	h[++idx] = 'prop_no" ';
			    }
			    h[++idx] = ' data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				h[++idx] = '<span>';
				if(question[selProperty]) {
					h[++idx] = '<i class="fa fa-check-circle" aria-hidden="true"></i> ';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_yes"];
				} else {
					h[++idx] = '<i class="fa fa-times-circle" aria-hidden="true"></i> ';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_no"];
				}
			    h[++idx] = '</span></button>';
			    h[++idx] = '</div>';

				/*
				 * Add the text area for conditional required
				 */
				h[++idx] = '<div class="col-sm-6';
				if(!question[selProperty]) {
					h[++idx] = ' d-none';
				}
				h[++idx] = '">';
				h[++idx] = '<textarea class="labelProp has_tt" tabindex="0" title="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_readonly'];
				h[++idx] = '" data-prop="readonly_expression" placeholder="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_readonly'];
				h[++idx] = '">';
				h[++idx] = question.readonly_expression;
				h[++idx] = '</textarea>';
				h[++idx] = '</div>';
			    
				h[++idx] ='</div>';		// End Row
				
			} else if(selProperty === "autoplay" && type === "question"
				&& question.type != "calculate") {		// Add a radio buttons to select autoplay status
				
				h[++idx] = '<div class="btn-group" role="group" aria-label="Autoplay Selection" data-toggle="buttons-radio">';
					// Add "none" autoplay option
					h[++idx] = '<button data-prop="autoplay" type="button" class="btn btn-light labelButton ';
					if(question[selProperty] == "none") {
						h[++idx] = "active";
					}
					h[++idx] = '" value="none">None</button>';
					
					// Add video autoplay option
					h[++idx] = '<button data-prop="autoplay" type="button" class="btn btn-light labelButton ';
					if(question[selProperty] == "video") {
						h[++idx] = "active";
					}
					h[++idx] = '" value="video">Video</button>';
					
					// Add audio autoplay option
					h[++idx] = '<button data-prop="autoplay" type="button" class="btn btn-light labelButton ';
					if(question[selProperty] == "audio") {
						h[++idx] = "active";
					}
					h[++idx] = '" value="audio">';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_audio"];
					h[++idx] = '</button>';
					
				h[++idx] = '</div>';


			} else if(selProperty === "parameters" && type === "question") {		// Add button to select the parameters dialog
				h[++idx] = '<div class="row">';

				h[++idx] = '<div class="col-sm-6">';	    // start col
				h[++idx] = '<button type="button" class="btn btn-primary parameterButton"';
				h[++idx] = ' data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				h[++idx] = '<i class="fa fa-edit"></i> ';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_edit"];
				h[++idx] = '</button>';
				h[++idx] = '</div>';		// End Col

				/*
			     * Add the text area to display the parameters
			     */
				h[++idx] = '<div class="col-sm-6">';
				h[++idx] = '<textarea class="labelProp has_tt" data-toggle="tooltip" readonly title="';
				h[++idx] = selLabel;
				h[++idx] = '" data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				h[++idx] = question["parameters"];
				h[++idx] = '</textarea>';
				h[++idx] = '</div>';    // End Col

				h[++idx] ='</div>';		// End Row



			} else if(selProperty === "appearance" && type === "question") {		// Add button to select the appearance dialog
				h[++idx] = '<div class="row">';

				h[++idx] = '<div class="col-sm-6">';	    // start col
				h[++idx] = '<button type="button" class="btn btn-info appearanceButton"';
				h[++idx] = ' data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				h[++idx] = '<i class="fa fa-edit"></i> ';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_edit"];
				h[++idx] = '</button>';
				h[++idx] = '</div>';		// End Col

				/*
			     * Add the text area to display the appearances
			     */
				h[++idx] = '<div class="col-sm-6">';
				h[++idx] = '<textarea class="labelProp has_tt" data-toggle="tooltip" readonly title="';
				h[++idx] = selLabel;
				h[++idx] = '" data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				h[++idx] = question["appearance"];
				h[++idx] = '</textarea>';
				h[++idx] = '</div>';    // End Col

				h[++idx] ='</div>';		// End Row


			} else if(selProperty === "media" && question.type != "calculate") {
				h[++idx] = '<div class="row">';
				if(type === "question" && (question.inMeta || question.source != "user" )) {
					h[++idx] = '<div class="col-sm-4 col-sm-offset-4">';
					h[++idx] = naMedia;
					h[++idx] = '</div>';
				} else {
					h[++idx] = addMedia("Image", 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].image, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].imageUrl, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].imageThumb);
			        
					h[++idx] = addMedia("Video", 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].video, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].videoUrl, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].videoThumb);
					
					h[++idx] = addMedia("Audio", 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audio, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audioUrl, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audioThumb);		
				}
				
			h[++idx] = '</div>';		// End of row

		} else {
			h[++idx] = '<textarea tabindex="0" class="labelProp has_tt';
			if((question.type === 'calculate' || question.type === 'server_calculate') && selProperty !== "appearance" && selProperty !== "parameters" && selProperty !== "display_name") {
				h[++idx] = ' calculate';
			}
			h[++idx] = '" data-toggle="tooltip" title="';
			if((question.type === 'calculate' || question.type === 'server_calculate') && selProperty !== "appearance" && selProperty !== "parameters" && selProperty !== "display_name") {
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_addcalc"];
			} else {
				h[++idx] = type === "option" ? "Choice Label" : selLabel;
			}
			h[++idx] = '" data-prop="';
			h[++idx] = selProperty;
			h[++idx] = '"';
			if(type === "option" && selProperty !== "label") {
				h[++idx] = ' readonly tabindex="-1"';
			}
			if(type === "question" && selProperty !== "appearance" && selProperty !== "parameters" &&
					((question.source != "user" && 
						question.type != "begin group" &&
						question.type != "begin repeat" &&
						question.type != "server_calculate" &&
						question.type != "pdf_field"
						))) {
				h[++idx] = ' readonly tabindex="-1">';
				h[++idx] = selLabel;
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_nreq"];
			} else {
				h[++idx] = '>';
				if(question.type === 'calculate' && selProperty !== "appearance" && selProperty !== "parameters" && selProperty !== "display_name") {
					h[++idx] = question.calculation;
				} else if(question.type === 'server_calculate' && selProperty !== "appearance" && selProperty !== "parameters" && selProperty !== "display_name") {
					if(question.server_calculation && question.server_calculation.expression) {
						h[++idx] = question.server_calculation.expression;
					}
				} else {
					if(selProperty === "label") { 
						h[++idx] = question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].text;
					} else if(selProperty === "hint") { 
						h[++idx] = question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].hint;
					} else if(selProperty === "constraint_msg") {
						h[++idx] = question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].constraint_msg || question.constraint_msg;    // Allow for multi language or single language message
					} else if(selProperty === "guidance_hint") {
						h[++idx] = question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].guidance_hint;
					} else {
						h[++idx] = question[selProperty];
					}
				}
			}
			h[++idx] = '</textarea>';
		}
		
		return h.join("");
	}
	
	/*
	 * Add subform
	 */
	function addSubForm(parentFormIndex, parentQuestionIndex) {
		
		var h = [],
			idx = -1,
			//formName,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			forms = survey.forms,
			i,
			form;
		
		h[++idx] = '<ol class="list-unstyled">';
		
		//formName = question.name;
		
		for(i = 0; i < forms.length; i++) {
			form = forms[i];
			if(forms[i].parentFormIndex === parentFormIndex && forms[i].parentQuestionIndex === parentQuestionIndex) {			
				h[++idx] = addQuestions(forms[i], i);
				break;
			}
		}
		
		h[++idx] = '</ol>';
		
		return h.join("");
	}

	/*
	 * Add the questions for a form
	 */
	function addQuestions(form, formIndex) {
		var i,
			question,
			h = [],
			idx = -1,
			topLevelForm = false,
			lastRealQuestionId = -1,
			finalButtonName,
			groupButtonName,
			selProperty = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty;
		
		// Set the group counter for this form
		gGroupStacks[formIndex] = {
				groupStack: [],
				lastGroup: undefined
		}
		
		if(form) {
			addQuestionSequence(form);		// Add an array holding the question sequence if it does not already exist
			form.maxQuestion = 1;			// Add a number to use for the default next question in a form
			
			for(i = 0; i < form.qSeq.length; i++) {
				_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gHasItems = true;
				question = form.questions[form.qSeq[i]];
				
				// Ignore property type questions, questions that have been deleted and meta questions like end repeat
				if(!includeQuestion(question)) {
					continue;
				}
				
				if(question.type === "end group") {
					groupButtonName = question.name.substring(0, question.name.indexOf('_groupEnd'));

					// Remove the group from the group stack and set the "last group" value
					gGroupStacks[formIndex].groupStack.pop();
					gGroupStacks[formIndex].lastGroup = groupButtonName;
					
					h[++idx] = addNewQuestionButton(true, false, formIndex, groupButtonName, selProperty);
					
					// End the group
					h[++idx] = '</ul>';
					h[++idx] = '</div>';
					h[++idx] = '</li>';
					
					// Add a dummy dom entry for this end group
					h[++idx] = '<li style="display:none;" id="';
					h[++idx] = "question" + formIndex + "_" + form.qSeq[i];
					h[++idx] = '"';
					h[++idx] = ' data-fid="';
					h[++idx] = formIndex;
					h[++idx] = '" data-id="';
					h[++idx] = form.qSeq[i];
					h[++idx] = '"></li>';
					
				
					continue;
				}

				h[++idx] = addOneQuestion(form, question, formIndex, form.qSeq[i], true, selProperty, false);
			}
			if(form.parentFormIndex == -1) {
				topLevelForm = true;
				finalButtonName = undefined;
			} else {
				finalButtonName = form.name;
			}
			h[++idx] = addNewQuestionButton(true, topLevelForm, formIndex, finalButtonName, selProperty); 	// Adds a question at the end of the form
		}
		return h.join("");
	}

	/*
	 * Get the display sequence of the question by name
	 */
	function getIndexQuestionByName(name, form) {
		var i;
		
		for(i = 0; i < form.qSeq.length; i++) {
			if(form.questions[form.qSeq[i]].name === name) {
				return form.qSeq[i];
			}
		}
		alert("Could not find question with name: " + name);
		return 0;
	}
	
	/*
	 * Add the array containing the question sequence
	 * This will initially be the same as the order of questions but as new questions are added in the editor
	 *  then these new questions will be at the end of the question array
	 */
	function addQuestionSequence(form) {
		
		var i;
		
		if(!form.qSeq) {
			form.qSeq = [];
			for(i = 0; i < form.questions.length; i++) {
				form.qSeq[i] = i;		// Assume initial sequence corresponds to order of questions
			}
		}
	}
	

	
	/*
	 * Add a media type
	 */
	function addMedia(label, mediaIdent, url, thumbUrl) {
		var h = [],
			idx = -1,
			emptyMedia = '<div class="emptyMedia text-center">Empty</div>',
			lcLabel = label.toLowerCase();
		
		h[++idx] = '<div class="col-sm-3 ';
		h[++idx] = lcLabel;
		h[++idx] = 'Element">';
		if(mediaIdent) {
			h[++idx] = '<a target="_blank" href="';
			h[++idx] = url
			h[++idx] = '"';
		} else {
			h[++idx] = "<div";
		}
		h[++idx] = ' class="thumbnail preview">';

		if(mediaIdent) {
			if(thumbUrl || (lcLabel === "image" && url)) {
				h[++idx] = '<img height="100" width="100" src="';
				if(thumbUrl) {
					h[++idx] = thumbUrl + addCacheBuster(thumbUrl);;
				} else {
					h[++idx] = url + addCacheBuster(url) ;
				}
				h[++idx] = '">';
			} else {
				h[++idx] = addQType(lcLabel)
			}
		} else {
			h[++idx] = emptyMedia;
		}

		if(mediaIdent) {
			h[++idx] = '</a>';
		} else {
			h[++idx] = '</div>';
		}
	    h[++idx] = '<a type="button" class="btn btn-primary mediaProp form-control" data-element="';
	    h[++idx] = label.toLowerCase();
	    h[++idx] = '">';
	    h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_" + lcLabel];
	    h[++idx] = '</a>';
	 
	    h[++idx] = '</div>';
	    
	    return h.join("");
	}
	
	/*
	 * Refresh the content
	 */
	function refresh() {
		
		var content,
			i,
        	collapsedPanels = [];
		
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gElementIndex = 0;
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gHasItems = false;
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gNewQuestionButtonIndex = 0;
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gNewOptionButtonIndex = 0;
		
		if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gIsQuestionView) {
			content = refreshQuestions();
		} else {
			content = refreshChoiceListView();
		}
		
		// Get the current list of collapsed panels
		jquery__WEBPACK_IMPORTED_MODULE_0___default()('.collapse.show', '#formList').each(function(){
			collapsedPanels.push(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).closest('li').attr("id"));
		});
		
		// Update the content view
		jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList').html(content);
		
		// Restore collapsed panels
		for(i = 0; i < collapsedPanels.length; i++) {
			var $collapsedPanel = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + collapsedPanels[i]);
			$collapsedPanel.find('.collapse').first().addClass("show");
			$collapsedPanel.find('.edit_icon.fa-chevron-down').first().removeClass('fa-chevron-down').addClass('fa-chevron-up');
			
		}
		
		if(!_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gHasItems) {
			// If there were no items then set focus to the add new item button
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.add_final_button').focus();
		} 
		
		return jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList');		// Return the context of the updated HTML so that events can be applied
	}

	/*
	 * Refresh the featured properties
	 */
	function refreshQuestionFeaturedProperties() {

        var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;

		jquery__WEBPACK_IMPORTED_MODULE_0___default()('li.card.question').each(function() {
			var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
			var fId = $this.data("fid");
			var id = $this.data("id");
			var question = survey.forms[fId].questions[id];

			$this.find('.card-body .row .question').html(getFeaturedMarkup(question, "question"));

		});

        return jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList');
	}

	/*
	 * Show the choice List view
	 */
	function refreshChoiceListView() {
		var h = [],
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			optionLists = survey.optionLists,
			idx = -1,
			name,
			nameArray = [],
			i;
		
		/*
		 * Process the choice lists in sequential order
		 */
		if(survey) {
			if(optionLists) {
				
				for (name in optionLists) {
					if (optionLists.hasOwnProperty(name)) {
					    nameArray.push(name);
					}
				}
				// Sort array of list names
				nameArray.sort();
				for(i = 0; i < nameArray.length; i++) {
					h[++idx] = addOneOptionList(nameArray[i], false, undefined);
				}
				h[++idx] = addNewOptionListButton(); 
			}
		}
		
		return h.join("");
	}
	
	/*
	 * Show the form on the screen
	 */
	function refreshQuestions() {
		
		var i,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			h = [],
			idx = -1;
		
		/*
		 * Process the questions in the top level form (parent is 0) 
		 *   Questions that are "begin repeat" type will link to sub level forms which are then processed in turn
		 * 
		 */
		if(survey) {
			if(survey.forms && survey.forms.length > 0) {
				for(i = 0; i < survey.forms.length; i++) {
					if(survey.forms[i].parentFormIndex == -1) {
						h[++idx] = addQuestions(survey.forms[i], i);
						break;
					}
				}
			}
		}


		gGroupStacks = [];		// save some memory
		
		return h.join("");


	}
	
	/*
	 * Return true for those questions that are of interest to the editor
	 */
	function includeQuestion(question) {
		if(question.propertyType || question.soft_deleted || question.type === "end repeat") {	
			return false;
		} else {
			return true;
		}
	}
	
	/*
	 * Get the questions for a linked survey
	 */
	function getLinkedQuestions(questionId, surveyId, qId) {
		if(linkedQuestions[surveyId]) {
			setTimeout(function() {
				showLinkedQuestions(questionId, linkedQuestions[surveyId], qId);
			}, 0);
		} else {
			addHourglass();
			jquery__WEBPACK_IMPORTED_MODULE_0___default().ajax({
				url: "/surveyKPI/questionList/" + surveyId + "/none",	// Will use the default language
				cache: false,
				dataType: 'json',
				success: function(data) {
					linkedQuestions[surveyId] = data;
					showLinkedQuestions(questionId, data, qId);
					removeHourglass();
				},
				error: function(xhr, textStatus, err) {
					removeHourglass();
					if(xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						bootbox.alert("Error failed to get questions for survey:" + surveyId);
						jquery__WEBPACK_IMPORTED_MODULE_0___default()("#" + questionId).find(".linkedQuestion").html("");
					}
				}
			});

		}

		
	}
	
	/*
	 * Show the linked questions in the drop down
	 */
	function showLinkedQuestions(questionId, data, qId) {
		
		var idx = -1,
			h = [],
			i;
		
		qId = +qId;
		h[++idx] = '<option value="0"';
		if(!qId) {
			h[++idx] = ' selected';
		}
		h[++idx] = '>Key</option>';
		if(data) {
			for(i = 0; i < data.length; i++) {
				if(data[i].q) {
					h[++idx] = '<option value="';
					h[++idx] = data[i].id;
					h[++idx] = '" ';
					if(data[i].id == qId) {
						h[++idx] = ' selected';
					} 
					h[++idx] = '>';
					h[++idx] = data[i].q;
					h[++idx] = '</option>';
				}
			}
		}
		
		jquery__WEBPACK_IMPORTED_MODULE_0___default()("#" + questionId).find(".linkedQuestion").html(h.join(''));
	}


/***/ },

/***/ "./WebContent/js/app/globals.js"
/*!**************************************!*\
  !*** ./WebContent/js/app/globals.js ***!
  \**************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Quick solution to issue of legacy globals after migrating to AMD / require.js
 */
const globals = {

        // Security groups
        GROUP_ADMIN: 1,
        GROUP_ANALYST: 2,
        GROUP_ENUM: 3,
        GROUP_ORG_ADMIN : 4,
        GROUP_MANAGE: 5,
        GROUP_SECURITY: 6,
        GROUP_VIEW_DATA: 7,
        GROUP_ENTERPRISE : 8,
        GROUP_OWNER : 9,
		GROUP_VIEW_OWN_DATA : 10,
	    GROUP_MANAGE_TASKS : 11,
	    GROUP_DASHBOARD : 12,
        GROUP_LINKAGES : 13,
        GROUP_CONSOLE_ADMIN : 14,
        GROUP_MCP_ACCESS : 15,

        REC_LIMIT: 200,     // Page size for table views in analysis
	    MAP_REC_LIMIT: 10000,    // Max size for map views in analysis

        gProjectList: undefined,
        gRoleList: undefined,
        gCmSettings: undefined,
        gCurrentProject: 0,
        gCurrentSurvey: 0,
        gCurrentSurveyIdent: undefined,
	    gGroupSurveys: {},
	    gSubForms: {},
        gCurrentForm: 0,
        gCurrentLayer: undefined,
        gLoggedInUser: undefined,
        gEditingReportProject: undefined,   		// Set if fieldAnalysis called to edit a report
        gIsAdministrator: false,
        gIsEnum: false,
        gIsAnalyst: false,
	    gIsDashboard: false,
        gIsManage: false,
        gIsOrgAdministrator: false,
        gIsSecurityAdministrator: false,
        gIsEnterpriseAdministrator: false,
        gIsLinkFollower: false,
        gIsServerOwner: false,
        gIsConsoleAdmin: false,
        gViewData: false,
	    gManageTasks: false,
        gBillingData: false,
        gOrgBillingData: false,
        gSendTrail: 'off',
        gViewIdx: 0,
        gSelector: new Selector(),
        gOrgId: 0,
        gTimezone: undefined,
	    gEnterpriseName: undefined,
	    gSetAsTheme: undefined,
	    gNavbarColor: undefined,

        gRegions: undefined,
        gRegion: {},

        gServerCanSendEmail: false,

        // Reports
        gEmailEnabled: false,
        gFacebookEnabled: false,
        gTwitterEnabled: false,

        // Tasks
        gCurrentUserId: undefined,
        gCurrentUserName: undefined,
        gAssignmentsLayer: undefined,
        gPendingUpdates: [],
        gCurrentTaskGroup: undefined,
	    gCurrentMailout: undefined,
        gTaskList: undefined,
        gCurrentSurveyIndex: 0,
	    gCurrentInstance: undefined,
        gAlertSeen: false,
        gLastAlertTime: undefined,

        // Editor
        gExistingSurvey: false,		// Set true if modifying an existing survey
        gElementIndex: 0,			// Manage creation of unique identifier for each element (question, option) in editor
        gHasItems: false,			// Set true if there are questions or choice lists in the survey
        gNewQuestionButtonIndex: 0,	// Manage creation of unique identifier for buttons that add new questions
        gNewOptionButtonIndex: 0,
        gSId: 0,
        gLanguage: 0,
        gLanguage1: 0,
        gLanguage2: 0,
        errors: [],
        changes: [],
        gErrorPosition: 0,
        gSelProperty: 'label',
        gSelLabel: 'Question Text',
        gSelQuestionProperty: 'label',
        gSelQuestionLabel: 'Question Text',
        gSelChoiceProperty: 'label',
        gSelChoiceLabel: 'Question Text',
        gIsQuestionView: true,
        gShowingChoices: false,
        gMaxOptionList: 0,
        gLatestOptionList: undefined,	// Hack to record the last option list name added
	    gCsvFiles: undefined,

        gListName: undefined,					// Choice Modal parameters, Set if started from choice list view
        gOptionList: undefined,					// The option list name applying to this set of choices
        gSelOptionId: undefined,				// Selected option index
        gFormIndex: undefined,					// Selected form index
        gItemIndex: undefined,					// Selected question index
        gSelectedFilters: undefined,
        gFilterArray: undefined,

        gSaveInProgress: false,

        // Dashboard
        gMainTable: undefined,			// Data tables
        gReports: undefined,			// reports
        gCharts: {},					// charts
	    gRecordMaps: [],                // Maps shown when editing a record
	    gRecordChangeMaps: [],          // Maps shown when viewing change history
        gMapLayersShown: false,
        gViewId: 0,						// Current survey view

	    gTraining: undefined,
	    gRefreshRate: 0,

        gMapboxDefault: undefined,		// Mapbox key
        
        model: typeof Model !== "undefined" ? new Model() : undefined

    }


    function Selector() {

        this.dataItems = {};
        this.surveys = {};
        this.surveysExtended = {};
        this.surveyLanguages = {};
        this.surveyQuestions = {};
        this.surveyMeta = {};
        this.surveyAlerts = {};
        this.questions = {};
        this.allSurveys = undefined;			// Simple list of surveys
        this.allRegions = undefined;
        this.sharedMaps = undefined;
        this.views = [];			// Simple list of views
        this.maps = {};				// map panels indexed by the panel id
        this.changed = false;
        this.SURVEY_KEY_PREFIX = "surveys";
        this.TASK_KEY = "tasks";
        this.TASK_COLOR = "#dd00aa";
        this.SURVEY_COLOR = "#00aa00";
        this.SELECTED_COLOR = "#0000aa";
        this.currentPanel = "map";

        this.getAll = function () {
            return this.dataItems;
        };

        this.getItem = function (key) {
            return this.dataItems[key];
        };

        this.addDataItem = function (key, data) {
            this.dataItems[key] = data;
        };

        this.clearDataItems = function () {
            this.dataItems = {};
        };

        this.addSurvey = function (sId, data) {
            this.surveys[sId] = data;
        };

        this.addSurveyExtended = function (sId, data) {
            this.surveysExtended[sId] = data;
        };

        this.getSurvey = function (sId) {
            return this.surveysExtended[sId] || this.surveys[sId];
        };

        this.clearSurveys = function () {
            this.surveys = {};
            this.surveysExtended = {};
            this.surveyLanguages = {};
            this.surveyQuestions = {};
            this.surveyMeta = {};
            this.surveyAlerts = {};
            this.allSurveys = undefined;
        };

        this.setSurveyList = function (data) {
            this.allSurveys = data;
        };

        this.getSurveyList = function () {
            return this.allSurveys;
        };

        this.setSurveyLanguages = function (sId, data) {
            this.surveyLanguages[sId] = data;
        };

        this.getSurveyLanguages = function (sId) {
            return this.surveyLanguages[sId];
        };

        this.setSurveyQuestions = function (sId, language, data) {
            if (!this.surveyQuestions[sId]) {
                this.surveyQuestions[sId] = {};
            }
            this.surveyQuestions[sId][language] = data;
        };

        this.getSurveyQuestions = function (sId, language) {
            if (!this.surveyQuestions[sId]) {
                return undefined;
            }
            if (typeof language === "undefined") {
                return this.surveyQuestions[sId];
            }
            return this.surveyQuestions[sId][language];
        };

        this.getQuestion = function (qId, language) {
            return this.getQuestionDetails(globals.gCurrentSurvey, qId, language);
        };

        this.getQuestionDetails = function (sId, qId, language) {
            var questions = this.getSurveyQuestions(sId, language);
            if (!questions) {
                return undefined;
            }
            for (var i = 0; i < questions.length; i++) {
                if (questions[i].id == qId) {
                    return questions[i];
                }
            }
            return undefined;
        };

        this.setSurveyMeta = function (sId, data) {
            this.surveyMeta[sId] = data;
        };

        this.getSurveyMeta = function (sId) {
            return this.surveyMeta[sId];
        };

        this.setSurveyAlerts = function (sId, data) {
            this.surveyAlerts[sId] = data;
        };

        this.getSurveyAlerts = function (sId) {
            return this.surveyAlerts[sId];
        };

        this.setRegionList = function (data) {
            this.allRegions = data;
        };

        this.getRegionList = function () {
            return this.allRegions;
        };

        this.setSharedMaps = function (data) {
            this.sharedMaps = data;
        };

        this.getSharedMaps = function () {
            return this.sharedMaps;
        };

        this.setViews = function (data) {
            this.views = data || [];
        };

        this.getViews = function () {
            return this.views;
        };

        this.setMap = function (idx, map) {
            this.maps[idx] = map;
        };

        this.getMap = function (idx) {
            return this.maps[idx];
        };

    }

    /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (globals);


/***/ },

/***/ "./WebContent/js/app/localise.js"
/*!***************************************!*\
  !*** ./WebContent/js/app/localise.js ***!
  \***************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

const $ = window.$;

const dtLangFiles = {
	en: "",
	es: "/js/libs/DataTables.i18n/es.json",
	ar: "/js/libs/DataTables.i18n/ar.json",
	fr: "/js/libs/DataTables.i18n/fr.json",
	pt: "/js/libs/DataTables.i18n/pt.json",
	hi: "/js/libs/DataTables.i18n/hi.json"
};

const localeCache = {};
let currentLocale = "en";

function normalizeLocale(locale) {
	if (!locale) {
		return "en";
	}
	return locale.toLowerCase().replace("_", "-");
}

function localeCandidates(locale) {
	const normalized = normalizeLocale(locale);
	const base = normalized.split("-")[0];
	const candidates = [];

	if (normalized && normalized !== "en") {
		candidates.push(normalized);
	}
	if (base && base !== normalized && base !== "en") {
		candidates.push(base);
	}
	if (!candidates.includes("root")) {
		candidates.push("root");
	}

	return candidates;
}

function parseAmdLocale(text) {
	const trimmed = text.trim();
	const prefix = "define(";
	const start = trimmed.indexOf(prefix);
	const end = trimmed.lastIndexOf(")");
	if (start === -1 || end === -1 || end <= start) {
		throw new Error("Invalid locale format");
	}
	const objectText = trimmed.slice(start + prefix.length, end).trim();
	const jsonText = objectText
		.replace(/\s*\/\/.*$/gm, "")
		.replace(/\s\/\*[\s\S]*?\*\//g, "")
		.trim();
	return JSON.parse(jsonText);
}

async function loadLocaleFile(locale) {
	if (localeCache[locale]) {
		return localeCache[locale];
	}

	const src = `/js/nls/${locale}/lang.js`;
	const data = await new Promise((resolve, reject) => {
		const previousDefine = window.define;
		const script = document.createElement("script");

		window.define = function (payload) {
			window.define = previousDefine;
			script.remove();
			resolve(payload);
		};
		window.define.amd = true;

		script.src = src;
		script.async = true;
		script.onerror = function () {
			window.define = previousDefine;
			script.remove();
			reject(new Error(`Locale ${locale} not found`));
		};

		document.head.appendChild(script);
	});

	localeCache[locale] = data;
	return data;
}

async function initLocale(locale) {
	const candidates = localeCandidates(locale);
	const rootLocale = await loadLocaleFile("root");
	let merged = { ...rootLocale };
	let resolvedLocale = "root";

	for (const candidate of candidates) {
		if (candidate === "root") {
			continue;
		}
		try {
			const data = await loadLocaleFile(candidate);
			merged = { ...merged, ...data };
			resolvedLocale = candidate;
			break;
		} catch (error) {
			// fallback to next candidate
		}
	}

	currentLocale = resolvedLocale;
	window.localise.set = merged;
	return merged;
}

window.localise = {
	setlang: function () {
		$(".lang").each(function() {
			const $this = $(this);
			const code = $this.data("lang");
			if (code) {
				$this.html(window.localise.set[code]);
			}
		});

		$(".lang_tt").each(function() {
			const $this = $(this);
			const code = $this.data("lang_tt");
			if (code) {
				$this.prop("title", window.localise.set[code]);
			}
		});

		$(".lang_ph").each(function() {
			const $this = $(this);
			const code = $this.data("lang_ph");
			if (code) {
				$this.prop("placeholder", window.localise.set[code]);
			}
		});

		if (typeof responsiveMobileMenu === "function") {
			rmmResizeLabels();
		}
	},
	set: {},
	dt: function() {
		return dtLangFiles[currentLocale] || dtLangFiles.en;
	},
	initLocale
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (window.localise);


/***/ },

/***/ "./WebContent/js/app/option.js"
/*!*************************************!*\
  !*** ./WebContent/js/app/option.js ***!
  \*************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globals */ "./WebContent/js/app/globals.js");
/* harmony import */ var _editorMarkup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./editorMarkup */ "./WebContent/js/app/editorMarkup.js");
/* harmony import */ var _changeset__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./changeset */ "./WebContent/js/app/changeset.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Functions for manipulating a choice in the editor
 * 
 *  Filter Model
 *    globals.gFilterArray:				Filters in display order
 *    survey.filters	Filters with state of shown or not shown
 */









/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({	
	refreshOptionListControls: refreshOptionListControls,
	createChoiceView: createChoiceView,
	setupChoiceView: setupChoiceView,					// On create of option view
	addOneOption: addOneOption,
	resetFilterColumns: resetFilterColumns,
	setPreviousChoices: setPreviousChoices,
	addOptionTable: addOptionTable,
	addFilter: addFilter,
	addFilterSelectList: addFilterSelectList,
	addOptionSequence: addOptionSequence
});

	
	_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray = [];			// Filters in repeatable order
	
	/*
	 * Refresh the select controls that show the available option lists
	 */
	function refreshOptionListControls() {
		var $selector = jquery__WEBPACK_IMPORTED_MODULE_0___default()(".option-lists");
		$selector.html(getOptionLists());
	}
	
	/*
	 * Create a choice view
	 */
	function createChoiceView() {
		
		var $cv = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView').find('.choice-content'),
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			question,
			filter,
			filterType = "none",
			i;
		
		if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gListName) {
			$cv.empty().append(addOptionContainer(undefined, undefined, undefined, _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gListName));
		} else {
			// Choice list opened from a question
			question = survey.forms[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFormIndex].questions[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gItemIndex];
			$cv.empty().append(addOptionContainer(question, _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFormIndex, _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gItemIndex, undefined));
		}
		addFilterSelectList(survey.filters);
		
		/*
		 * Set the filter type to custom if there are filters with a name other than _smap_cascade
		 */
		if(question) {
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.filter_only').show();

			if(question.choice_filter && question.choice_filter.trim().length > 0) {
				if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length > 0) {
					filterType = "custom";
				}
				if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length === 1) {
					if (_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[0] === "_smap_cascade") {
						filterType = "cascade";
					}
				}
			}
	
			// Set the custom filter view by default
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#filterType').val(filterType);
		}
		
		return $cv;
	}
	
	function setupChoiceView(filterType) {
		var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			i;
		/*
		 * show custom filter columns that should be visible
		 */
		for (i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length; i++) {
			if(survey.filters[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i]] === true) {
				jquery__WEBPACK_IMPORTED_MODULE_0___default()('table', '#choiceView').removeClass("hide" + i);
			}
		}
		
		if(filterType === "custom") {
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.custom_filter_only').show();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.cascade_filter_only').hide();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView table').addClass("notcascade").removeClass("notcustom");	
		} else if(filterType === "cascade") {
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.custom_filter_only').hide();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.cascade_filter_only').show();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView table').removeClass("notcascade").addClass("notcustom");
		} else {
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.custom_filter_only').hide();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.cascade_filter_only').hide();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView table').addClass("notcascade").addClass("notcustom");	
		}

	}

	/*
	 * Add a single option
	 */
	function addOneOption(optionList, option, formIndex, index, list_name, qname) {
		
		var h = [],
			idx = -1,
			prevChoice = jquery__WEBPACK_IMPORTED_MODULE_0___default()("#previousSelectChoice").val(),
			filterType = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#filterType').val();
		
		optionList.maxOption++;
		
		if(filterType !== "cascade" || showCascadeOption(option.cascade_filters, prevChoice,  option.value) ) {
			h[++idx] = '<tr class="editor_element option draggable dropon ';
			if(option.error) {
				h[++idx] = ' error';
			}
			
			// Add the option index 
			h[++idx] = '" data-id="';
			h[++idx] = index;
			h[++idx] = '" data-fid="';					
			h[++idx] = formIndex;
			h[++idx] = '" data-qname="';
			h[++idx] = qname;
			h[++idx] = '" data-list_name="';
			h[++idx] = list_name;
			h[++idx] = '" data-filters=';
			h[++idx] = JSON.stringify(option.cascade_filters);
			h[++idx] = '>';
			
				// Add select for cascade selects
				h[++idx] = '<td class="cascade">';
					h[++idx] = '<input type="checkbox" class="cascadeFilter" name="isSelected" value="';
					h[++idx] = "";
					h[++idx] = '" ';
					if(idx !== false) {
						h[++idx] = addCascadeChecked(option.cascade_filters, prevChoice);
					} 
					h[++idx] = '>';
				h[++idx] = '</td>';
				
				// Add option name and value cell
				h[++idx] = '<td>';
						h[++idx] = '<div class="dropdown">';
						h[++idx] = '<button type="button" class="btn btn-secondary btn-lg dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-bars" aria-hidden="true"></i> ';
						h[++idx] = '</button>';
							h[++idx] = '<div class="dropdown-menu">';
								h[++idx] = '<a href="javascript:void(0)" class="dropdown-item delete_option">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_del"];
								h[++idx] = '</a>';
								h[++idx] = '<a href="javascript:void(0)" class="dropdown-item add_option_before">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_ab"];
								h[++idx] = '</a>';
								h[++idx] = '<a href="javascript:void(0)" class="dropdown-item add_option_after">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_aa"];
								h[++idx] = '</a>';
							h[++idx] = '</div>';
						h[++idx] = '</div>';
				h[++idx] = '</td>';	// End of menu button
				
				// Add option name cell
				h[++idx] = '<td>';
					
					h[++idx] = '<input class="oname form-control has_tt" value="';
					h[++idx] = option.value;
					h[++idx] = '" ';

					h[++idx] = ' type="text" title="';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cval"];
					h[++idx] = '">';
							
				h[++idx] = '</td>';	// End of option name and label cell

				h[++idx] = addFilterColumnBody(option.cascade_filters);
				h[++idx] = addOptionLabel(option);
				
			
			h[++idx] = '</tr>';
		}

	
		return h.join("");
	}
	
	function resetFilterColumns() {
		var i,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;
		
		for (i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length; i++) {
			if(survey.filters[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i]] === true) {
				jquery__WEBPACK_IMPORTED_MODULE_0___default()('table', '#choiceView').removeClass("hide" + i);
			} else {
				jquery__WEBPACK_IMPORTED_MODULE_0___default()('table', '#choiceView').addClass("hide" + i);
			}
			
		}
	}
	
	/*
	 * Add an option container
	 */
	function addOptionContainer(question, formIndex, qIndex, listName) {
		var h = [],
			idx = -1,
			filter;
		
		h[++idx] = '<div class="question_head" data-fId="';
		h[++idx] = formIndex;
		h[++idx] = '" data-id="';
		h[++idx] = qIndex;
		h[++idx] = '">';
		h[++idx] = '<div class="question-controls">';
			h[++idx] = '<div class="row">';
				h[++idx] = '<div class="col-md-6">';
					h[++idx] = '<form role="form">';
						
						// A control to set option list name
						if(!listName) {
							h[++idx] = '<div class="form-group row">';
								h[++idx] = '<label class="col-sm-2">';
									h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cl"];
								h[++idx] = '</label>';
								h[++idx] = '<div class="col-sm-10">';
									h[++idx] = '<select class="form-control option-lists">';
									h[++idx] = getOptionLists();
									h[++idx] = '</select>';
								h[++idx] = '</div>';
							h[++idx] = '</div>';
						}

						// A control to select the filter type
						h[++idx] = '<div class="form-group row filter_only" style="display:none;">';
							h[++idx] = '<label class="col-sm-2">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_filter"];
							h[++idx] = '</label>';
							h[++idx] = '<div class="col-sm-10">';
								h[++idx] = '<select class="form-control" id="filterType">';
								
								h[++idx] = '<option value="none">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"];
								h[++idx] = '</option>';
								
								h[++idx] = '<option value="cascade">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cs"];
								h[++idx] = '</option>';
								
								h[++idx] = '<option value="custom">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cf"];
								h[++idx] = '</option>';
								
								h[++idx] = '</select>';
							h[++idx] = '</div>';
						h[++idx] = '</div>';
						
					h[++idx] = '</form>';
				h[++idx] = '</div>';
				h[++idx] = '<div class="col-md-6">';
					h[++idx] = '<div class="text-right">';
				    h[++idx] = '<button class="btn btn-primary exitOptions mb-2">';
						h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_back"];
					h[++idx] = '</button>';
					h[++idx] = '</div>';
					h[++idx] = '<div class="custom_filter_only" style="display:none;">';
						h[++idx] = '<form role="form">';
						
							if(!listName) {
								h[++idx] = '<div class="form-group row">';
									h[++idx] = '<label class="col-sm-2">';
									h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_choice_f"];
									h[++idx] = '</label>';
									h[++idx] = '<div class="col-sm-8">';
										h[++idx] = '<textarea id="choiceFilter" class="input-block" form-control has_tt" type="text">';
										h[++idx] = question.choice_filter;
										h[++idx] = '</textarea>';
										h[++idx] = addChoiceFilterError(question.errorMsg);
									h[++idx] = '</div>';
								h[++idx] = '</div>';
							}
							
							h[++idx] = '<div id="custom_filters">';
							h[++idx] = '</div>';
						h[++idx] = '</form>';
						h[++idx] = '<button id="addFilter" class="btn btn-light mt-2">';
						h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_afc"];
						h[++idx] = '</button>';
					h[++idx] = '</div>';  // Custom filter only
					
					h[++idx] = '<div class="cascade_filter_only" style="display:none;">';
						h[++idx] = '<form role="form">';

							h[++idx] = '<div class="form-group row">';
								h[++idx] = '<label class="col-sm-2">';
									h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cspq"];
								h[++idx] = '</label>';
								h[++idx] = '<div class="col-sm-10">';
									h[++idx] = '<select class="form-control" id="previousSelect">';
										h[++idx] = addSelectQuestions(question);
									h[++idx] = '</select>';
								h[++idx] = '</div>';
							h[++idx] = '</div>';
			
							h[++idx] = '<div class="form-group row">';
								h[++idx] = '<label class="col-sm-2">';
									h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_csp"];
								h[++idx] = '</label>';
								h[++idx] = '<div class="col-sm-10">';
									h[++idx] = '<select class="form-control" id="previousSelectChoice">';	
									h[++idx] = '</select>';
								h[++idx] = '</div>';
							h[++idx] = '</div>';
						h[++idx] = '</form>';
					h[++idx] = '</div>';	// Cascade filter only
				h[++idx] = '</div>';
			h[++idx] = '</div>';
		h[++idx] = '</div>';
	
		h[++idx] = '<div id="optionTable">';	
		h[++idx] = '</div>';	// Option Table
		h[++idx] = '</div>';		// Question Head
		
		return h.join("");
	}

	/*
	 * Refresh the table of options
	 */
	function addOptionTable(question, formIndex, listName) {
		var h = [],
			idx = -1,
			$element = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#optionTable');
		
		if(listName) {
			h[++idx] = addOptions(undefined, undefined, listName);
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceViewQuestion').html(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cl"] + ": " + listName);
		} else {
			// Opened from a specific question
			h[++idx] = addOptions(question, formIndex, undefined);
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceViewQuestion').html(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_question"] + ": " + question.name);
		}
		
		$element.html(h.join());
		
		// Add styling to cascading select checkboxes
		jquery__WEBPACK_IMPORTED_MODULE_0___default()('[type="checkbox"]', '#optionTable').iCheck({
		    checkboxClass: 'icheckbox_square-green',
		    radioClass: 'iradio_square-green'
		});
	}
	
	/*
	 * Add filter to filters if not already there
	 */
	function addFilter(filter) {
		var i,
			hasFilter = false,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;
		
		for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length; i++) {
			if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i] === filter) {
				hasFilter = true;
			}
		}
		if(!hasFilter) {
			_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.push(filter);
		}
		
		if(!survey.filters) {
			survey.filters = {};
		}
		survey.filters[filter] = true;
	}
	
	/*
	 * Add the filters as  a select list
	 */
	function addFilterSelectList(filters) {
		var h = [],
			idx = -1,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			filter;
		
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray = [];
		for(filter in filters) {
			if (filters.hasOwnProperty(filter)) {
				_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.push(filter);	// Save filters as ordered array
				h[++idx] = '<div class="checkbox">';
			      h[++idx] = '<input type="checkbox" ';
			      if(survey.filters[filter]) {
			    	  h[++idx] = 'checked=true ';
			      }
			      h[++idx] = 'value="';
			      h[++idx] = filter;
			      h[++idx] = '"> ';
				  h[++idx] = '<label>';
			      h[++idx] = filter
			    h[++idx] = '</label>';
			    h[++idx] = '</div>';
			}
		}
		
		jquery__WEBPACK_IMPORTED_MODULE_0___default()('#custom_filters').html(h.join(""));
		
		// Style checkboxes
		jquery__WEBPACK_IMPORTED_MODULE_0___default()('[type="checkbox"]', '#custom_filters').iCheck({
		    checkboxClass: 'icheckbox_square-green',
		    radioClass: 'iradio_square-green'
		});
	}
	
	/*
	 * Show the options
	 */
	function addOptions(question, formIndex, list_name) {
		var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			optionList,
			questionName,
			oSeq,
			maxIndex,
			h = [],
			idx = -1,
			i,
			initialiseFilters = false;
		
		if(!list_name) {		// Options attached to a question
			list_name = question.list_name;
			questionName = question.name;
		} 
		optionList = survey.optionLists[list_name];
		
		if(typeof optionList !== "undefined") {
			optionList.maxOption = 0;
			
			addOptionSequence(optionList);		// Add an array holding the option sequence if it does not already exist
			oSeq = optionList.oSeq;
			
			h[++idx] = '<div class="table-responsive">';
			h[++idx] = '<table class="table notcustom hide0 hide1 hide2 hide3 hide4">';
			
			h[++idx] = '<thead class="thead-default"><tr>';
			
				h[++idx] = '<th class="cascade">';
				h[++idx] = '</th>';
			
				h[++idx] = '<th>';
				h[++idx] = '</th>';
				
				h[++idx] = '<th>';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cval"];
				h[++idx] = '</th>';

				//h[++idx] = '<th>';
				//h[++idx] = localise.set["ed_dn"];
				//h[++idx] = '</th>';

				h[++idx] = addFilterColumnHeadings();
				
				h[++idx] = '<th>';
				if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty === 'media') {
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_media"];
				} else if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty === 'display_name') {
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_dn"];
				} else {
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_clab"];
				}
				h[++idx] = '</th>';
				
			h[++idx] = '</tr></thead>';
			h[++idx] = '<tbody>';
			if(oSeq) {
				maxIndex = 0;
				for(i = 0; i < oSeq.length; i++) {
					h[++idx] = addOneOption(optionList,
							optionList.options[oSeq[i]], 
							formIndex, 
							oSeq[i], 
							list_name, 
							questionName);
					if(oSeq[i] >= maxIndex) {
						maxIndex = oSeq[i] + 1;
					}
				}
			}
			h[++idx] = '</tbody>';
			h[++idx] = '</table>';
			h[++idx]= '</div>';
			h[++idx] = addNewOptionButton(true, list_name, formIndex, questionName, -1); 
		}
		return h.join("");
	}
	
	/*
	 * Add the array containing the option sequence
	 */
	function addOptionSequence(optionList) {
		var i;
		
		if(!optionList.oSeq) {
			optionList.oSeq = [];
			for(i = 0; i < optionList.options.length; i++) {
				optionList.oSeq[i] = i;
			}
		}
	}
	
	
	/*
	 * One of the questions properties will be featured so that it can be edited in the header without expanding the question
	 */
	function addOptionLabel(option) {
		
		var h = [],
			idx = -1,
			selProperty = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty;
		
		h[++idx] = '<td class="option">';
			if(selProperty === "media") {
				h[++idx] = '<div class="row">';
				h[++idx] = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Image", 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].image, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].imageUrl, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].imageThumb);
		        
				h[++idx] = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Video", 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].video, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].videoUrl, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].videoThumb);
				
				h[++idx] = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Audio", 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audio, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audioUrl, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audioThumb);
				h[++idx] = '</div>';

			} else if(selProperty === "display_name") {
				h[++idx] = '<textarea class="odisplayname has_tt" title="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_dn"];
				h[++idx] = '">';
				h[++idx] = option.display_name;
				h[++idx] = '</textarea>';
				h[++idx] = addOptionErrorMsg(option.errorMsg);

			} else {
				h[++idx] = '<textarea data-toggle="tooltip" class="labelProp has_tt" title="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_clab"];
				h[++idx] = '">';
				h[++idx] = option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].text;
				h[++idx] = '</textarea>';
				h[++idx] = addOptionErrorMsg(option.errorMsg);
			}
		
		h[++idx] = '</td>';
		return h.join("");
	}
	
	function addNewOptionButton(after, list_name, formIndex, qname, index) {
		var h = [],
			idx = -1,
			addButtonClass,
			locn;
		
		addButtonClass = after ? 'add_after_button add_button' : 'add_before_button add_button';
		locn = after ? 'after' : 'before';
		
		h[++idx] = '<button type="button" class="add_option btn btn-primary dropon option editor_element add_after_button"';
		if(typeof index !== "undefined") {
			h[++idx] = ' data-id="';
			h[++idx] = index;
			h[++idx] = '"';
		}
		if(typeof list_name !== "undefined") {
			h[++idx] = ' data-list_name="';
			h[++idx] = list_name;
			h[++idx] = '"';
		}
		if(typeof qname !== "undefined") {
			h[++idx] = ' data-qname="';
			h[++idx] = qname;
			h[++idx] = '"';
		}
		if(typeof formIndex !== "undefined") {
			h[++idx] = ' data-fid="';
			h[++idx] = formIndex;
			h[++idx] = '"';
		}
		h[++idx] = '>';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_anc"];
		h[++idx] = ' </button>';

		
		return h.join('');
	}
	
	/*
	 * Get an array of option list names sorted alphabetically
	 */
	function getOptionLists() {
		
		var lists = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists,
			name,
			nameArray = [],
			h = [],
			idx = -1,
			i;

		// get the names into an array so they can be sorted
		for (name in lists) {
			if (lists.hasOwnProperty(name)) {
			    nameArray.push(name);
			}
		}
		// Sort array of list names
		nameArray.sort();
		
		// Create html
		for(i = 0; i < nameArray.length; i++) {
			h[++idx] = '<option value ="';
			h[++idx] = nameArray[i];
			h[++idx] = '">';
			h[++idx] = nameArray[i];
			h[++idx] = '</option>';
		}
		return h.join("");
	}
	
	/*
	 * Add the table headings for filter columns
	 */
	function addFilterColumnHeadings() {
		
		var i,
			h = [],
			idx = -1;
		
		for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length; i++) {
			h[++idx] = '<th class="f';		// Class to hide / show filter
			h[++idx] = i;
			h[++idx] = '">';
			h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i];
			h[++idx] = '</th>';
		}
		
		return h.join("");
	}
	
	/*
	 * Add the table body for filter columns
	 */
	function addFilterColumnBody(filters) {
		
		var i,
			h = [],
			idx = -1;
		
		for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length; i++) {
			h[++idx] = '<td class="f';		// Class to hide / show filter
			h[++idx] = i;
			h[++idx] = '" data-f_name="';
			h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i];
			h[++idx] = '">';
			h[++idx] = '<input class="filter form-control data-toggle="tooltip" has_tt" value="';
			h[++idx] = filters ? filters[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i]] : "";
			h[++idx] = '" ';	
			h[++idx] = ' type="text" title="';
			h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_fv"];
			h[++idx] = '">';
			
			h[++idx] = '</td>';
			
		}
		
		return h.join("");
	}
	
	/*
	 * Add a media type
	 */
	function addOptionMedia(label, mediaIdent, url, thumbUrl) {
		var h = [],
			idx = -1,
			emptyMedia = '<div class="emptyMedia text-center">Empty</div>',
			lcLabel = label.toLowerCase();
		
		h[++idx] = '<div class="col-sm-3 ';
		h[++idx] = lcLabel;
		h[++idx] = 'Element">';
		if(mediaIdent) {
			h[++idx] = '<a target="_blank" href="';
			h[++idx] = url
			h[++idx] = '"';
		} else {
			h[++idx] = "<div";
		}
		h[++idx] = ' class="thumbnail preview">';

		if(mediaIdent) {
			if(thumbUrl || (lcLabel === "image" && url)) {
				h[++idx] = '<img height="100" width="100" src="';
				if(thumbUrl) {
					h[++idx] = thumbUrl;
				} else {
					h[++idx] = url;
				}
				h[++idx] = '">';
			} else {
				h[++idx] = addQType(lcLabel)
			}
		} else {
			h[++idx] = emptyMedia;
		}

		if(mediaIdent) {
			h[++idx] = '</a>';
		} else {
			h[++idx] = '</div>';
		}
	    h[++idx] = '<a type="button" class="btn btn-default mediaProp form-control" data-element="';
	    h[++idx] = label.toLowerCase();
	    h[++idx] = '">';
	    h[++idx] = lcLabel;
	    h[++idx] = '</a>';
	 
	    h[++idx] = '</div>';
	    
	    return h.join("");
	}
	
	function addOptionErrorMsg(msg) {
		var h = [],
			idx = -1;
		
		h[++idx] = '<div class="error-msg pull-right">';
		h[++idx] = msg;
		h[++idx] = '</div>';
		return h.join("");
	}
	
	function addChoiceFilterError(msg) {
		var h = [],
			idx = -1;
		
		h[++idx] = '<div class="error-msg choice_filter_error pull-right">';
		h[++idx] = msg;
		h[++idx] = '</div>';
		return h.join("");
	}
	
	/*
	 * Add a list of select questions that can be selected as the preceeding question for a cascade select
	 */
	function addSelectQuestions(choiceQuestion) {
		var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			h = [],
			idx = -1,
			i, j,
			form,
			question,
			first = true;
			
		for(i = 0; i < survey.forms.length; i++) {
			form = survey.forms[i];
			_editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addQuestionSequence(form);		// Add the sequence for the questions if it has not already been added
			for(j = 0; j < form.qSeq.length; j++) {
				question = form.questions[form.qSeq[j]];
				if(!question.soft_deleted && question.type === "select1") {
					if(choiceQuestion && choiceQuestion.name === question.name) {
						continue;		// Skip question being edited
					}
					h[++idx] = '<option ';
					if(first) {
						h[++idx] = 'selected ';
					}
					h[++idx] = 'value="';
					h[++idx] = question.list_name;
					h[++idx] = '">';
					h[++idx] = question.name;
					h[++idx] = '</option>';
				}
			}
		}
	
		return h.join("");
	}
	
	/*
	 * Set the choices that can be selected as the preceeding choice for a cascade select
	 */
	function setPreviousChoices(listname) {
		
		var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			h = [],
			idx = -1,
			i,
			option,
			optionList = survey.optionLists[listname],
			oSeq;
			
		addOptionSequence(optionList);		// Add an array holding the option sequence if it does not already exist
		oSeq = optionList.oSeq;
		
		for(i = 0; i < oSeq.length; i++) {

			option = optionList.options[oSeq[i]];
				
			h[++idx] = '<option ';
				if(i == 0) {
					h[++idx] = 'selected ';
				}
				h[++idx] = 'value="';
				h[++idx] = option.value;
				h[++idx] = '">';
				h[++idx] = option.value;
			h[++idx] = '</option>';
		}
		jquery__WEBPACK_IMPORTED_MODULE_0___default()("#previousSelectChoice").html(h.join(""));
	}
	
	/*
	 * Set the checkbox checked if the cascade filter matches the previously selected choice
	 */
	function addCascadeChecked (filters, prevChoice) {
		
		var match = false;
		
		if(filters) {
			if(filters["_smap_cascade"] && filters["_smap_cascade"] == prevChoice) {
				match = true;
			}
		}
		
		if(match) {
			return 'checked="checked"';
		} else {
			return '';
		}
	}
	
	/*
	 * As this is the cascade view options should only be shown if their filter value is empty or 
	 *  matches the prevChoice
	 */
	function showCascadeOption (filters, prevChoice, optionValue) {
		
		var show = false,
			i,
			inOptionList = false,
			listname = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#previousSelect').val(),
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			optionList = survey.optionLists[listname],
			oSeq,
			option;
		
		if(listname) {
			addOptionSequence(optionList);		// Add an array holding the option sequence if it does not already exist
			oSeq = optionList.oSeq
			for(i = 0; i < oSeq.length; i++) {
				option = optionList.options[oSeq[i]];
				if(filters["_smap_cascade"] == option.value) {
					inOptionList = true;
					break;
				}
			}
						
			if(!filters["_smap_cascade"] || filters["_smap_cascade"] == prevChoice || !inOptionList) {
				show = true;
			}
		} else {
			show = true;		// No previous list set
		}
		
		return show;
	}


/***/ },

/***/ "./WebContent/js/app/optionlist.js"
/*!*****************************************!*\
  !*** ./WebContent/js/app/optionlist.js ***!
  \*****************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globals */ "./WebContent/js/app/globals.js");
/* harmony import */ var _editorMarkup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./editorMarkup */ "./WebContent/js/app/editorMarkup.js");
/* harmony import */ var _changeset__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./changeset */ "./WebContent/js/app/changeset.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Functions for manipulating an option list in the editor
 */









/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({	
	add: add,
	deleteList: deleteList
});
	
	var gEditor;


	/*
	 * Add a new option list
	 */
	function add() {		
		
		var name = getDefaultListName();
		
		// Create changeset to be applied on save		
		change = {
				changeType: "optionlist",		// survey | form | language | question | option | optionlist (property | label) last two are types of property change
				action: "add",
				name: name
		};
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLatestOptionList = name;		// Remember name so focus can be set to new list
		
		$context = _changeset__WEBPACK_IMPORTED_MODULE_4__["default"].add(change);
		return $context;				// Add events on to the altered html
		
	}
	
	/*
	 * Delete an option list
	 */
	function deleteList(item) {		
		
		var $deletedElement = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + item),
			change,
			name = $deletedElement.data("list_name"),
			$context;
	
		console.log("Deleting list: " + name);
		change = {
				changeType: "optionlist",		// survey | form | language | question | option | (property | label) last two are types of property change
				action: "delete",
				name: name
		};
		$context = _changeset__WEBPACK_IMPORTED_MODULE_4__["default"].add(change);
		return $context;
	}
	
	/*
	 * Utility function to get an initial list name, this name can then be changed by the user
	 */
	function getDefaultListName() {
		
		var name = "choices_" + _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gMaxOptionList;
		
		
		// Keep incrementing the maxOptionList until we get a unique name for this list
		while(!listNameIsUnique(name)) {
			name = "choices_" + ++_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gMaxOptionList;
		}
		
		return name;
	}
	
	function listNameIsUnique(name) {
		var unique = true,
			lists = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists;
		
		if(typeof name !== "undefined") {
			if(lists[name]) {
				unique = false;
			}
		}
		return unique;
	}
	

	

/***/ },

/***/ "./WebContent/js/app/question.js"
/*!***************************************!*\
  !*** ./WebContent/js/app/question.js ***!
  \***************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globals */ "./WebContent/js/app/globals.js");
/* harmony import */ var _editorMarkup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./editorMarkup */ "./WebContent/js/app/editorMarkup.js");
/* harmony import */ var _changeset__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./changeset */ "./WebContent/js/app/changeset.js");
/* harmony import */ var _option__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./option */ "./WebContent/js/app/option.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Functions for manipulating a question in the editor
 */










/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({	
	init: init,
	add: add,
	deleteQuestion: deleteQuestion,
	addOption: addOption,
	deleteOption: deleteOption,
	moveQuestion: moveQuestion,
	moveBeforeOption: moveBeforeOption,
	setGroupEnd: setGroupEnd,
	getSequenceQuestion: getSequenceQuestion
});
	
	var gEditor;

	function init(editor) {
		gEditor = editor;
	}

	/*
	 * Add a new question
	 * qItem: the html element id for the closest question to where we want to add the new question
	 * locn: "before" or "after".  Whether to add the new question "before" or "after" the reference question
	 * formIndex: The index of the form in the array of forms that are part of the survey model
	 * qIndex: The index of the question in the array of questions that make up a form 
	 */
	function add(formIndex, qId, locn, type, name) {		
		
		var $relatedQuestion = jquery__WEBPACK_IMPORTED_MODULE_0___default()("#" + qId),
			seq = 0,
			relatedFormIndex,
			qIndex,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			type,
			name,
			i,
			firstQuestion;
		
		// Choose type
		
		type = type || "string";		// Default to text question
		
		firstQuestion = true;
		qIndex = 0;
		seq = 0;
		if($relatedQuestion.length > 0) {
			relatedFormIndex = $relatedQuestion.data("fid");
			if(relatedFormIndex == formIndex) {
				// Appending or pre=pending to an existing question
				firstQuestion = false;
	
				qIndex = $relatedQuestion.data("id");
				seq = getSequenceQuestion(qIndex, survey.forms[formIndex], false, undefined);
				if(locn === "after") {
					++seq;
				} 
			}
		} 
		
		if(typeof name === "undefined") {
			name = getDefaultQuestionName(formIndex, qIndex);
		}

		// Create changeset to be applied on save		
		var change = {
				changeType: "question",		// survey | form | language | question | option | (property | label) last two are types of property change
				action: "add",
				question: {
					seq: seq,
					type: type,
					name: name,
					list_name: name,
					source: "user",	// For date type
					labels: [],
					visible: type === "end group" ? false : true,
					
					// Helper values 
					firstQuestion: firstQuestion,
					formIndex: formIndex,
					locn: locn,							// Whether the new question was added before or after the related question
					$relatedElement: $relatedQuestion	// Jquery element that is next to the new question
				}
		};
		
		// Add list of choices if this is a select question
		if(type.indexOf("select") == 0 || type === "rank") {
			var optionList = survey.optionLists[name];
			if(!optionList) {
				survey.optionLists[name] = {
					oSeq: [],
					options: []
				};
				_option__WEBPACK_IMPORTED_MODULE_5__["default"].refreshOptionListControls();
			}
		}
		
		// Add default labels
		if(type !== "end group") {
			for(i = 0; i < survey.languages.length; i++) {
				change.question.labels.push({text: name + ") "});
			}
		}
		
		var $context = _changeset__WEBPACK_IMPORTED_MODULE_4__["default"].add(change);
		return $context;				// Add events on to the altered html
		
	}
	
	function getDefaultQuestionName(formIndex, qIndex) {
		
		var forms = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms,
			form = forms[formIndex],
			name = form.maxQuestion;
		
		if(form.parentQuestionIndex >= 0) {
			name = forms[form.parentFormIndex].questions[form.parentQuestionIndex].name + "." + name;
		} else {	
			name = "q" + name;
		}
		
		// Keep incrementing the maxQuestion until we get a unique name for this question
		while(!nameIsUniqueInForm(form, name)) {
			name = ++form.maxQuestion;
			console.log("Get default qname maxQuestion: " + form.maxQuestion);
			if(form.parentQuestionIndex >= 0) {
				name = forms[form.parentFormIndex].questions[form.parentQuestionIndex].name + "." + name;
			} else {	
				name = "q" + name;
			}
		}
		
		return name;
	}
	
	function nameIsUniqueInForm(form, name) {
		var unique = false,
			i;
		if(typeof name !== "undefined") {
			unique = true;
			for(i = 0; i < form.questions.length; i++) {
				if(!form.questions[i].deleted && form.questions[i].name === name) {
					unique = false;
					break;
				}
			}
		}
		return unique;
	}
	
	function nameIsUniqueInOptionList(list, name) {
		var unique = false,
			i;
		if(typeof name !== "undefined") {
			unique = true;
			for(i = 0; i < list.options.length; i++) {
				if(!list.options[i].deleted && list.options[i].name === name) {
					unique = false;
					break;
				}
			}
		}
		return unique;
	}
	
	function setGroupEnd(formIndex, qId, locn, type, name, availableGroups) {		
		
		var $beforeElement = jquery__WEBPACK_IMPORTED_MODULE_0___default()("#" + qId),
			seq = 0,
			formIndex,
			qIndex,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			group,
			beforeFormIndex = $beforeElement.data("fid"),
			beforeItemIndex = $beforeElement.data("id"),
			seq,
			sourceSeq,
			sourceFormId,
			groupEndName,
			endGroupData,
			question;
		
		if(availableGroups.length > 1) {
			alert("Select group: " + availableGroups.join("-"));
			group = availableGroups[0];
		} else {
			group = availableGroups[0];
			alert("Moving group: " + group);
		}
		groupEndName = group + "_groupEnd";
		
		
		endGroupData = getEndGroup(groupEndName, survey.forms[beforeFormIndex]);
		sourceFormId = survey.forms[beforeFormIndex].id;	
		
		// Get the sequence of the question just after the new location of the end group
		seq = getSequenceQuestion(beforeItemIndex, survey.forms[beforeFormIndex], true, endGroupData.index);
		if(locn === "after") {
			++seq;
		} 
		
		// Get information about the current question
		question = survey.forms[beforeFormIndex].questions[endGroupData.index];
		
		// Create changeset to be applied on save		
		var change = {
				changeType: "question",		// survey | form | language | question | option | (property | label) last two are types of property change
				action: "move",
				question: {
						seq: seq,
						sourceSeq: endGroupData.seq,
						sourceFormId: sourceFormId,
						name: groupEndName,
						type: question.type,
						path: question.path,
						
						// Helper values 
						sourceFormIndex: beforeFormIndex,
						sourceItemIndex: endGroupData.index,
						formIndex: beforeFormIndex
					}
			};

		var $context = _changeset__WEBPACK_IMPORTED_MODULE_4__["default"].add(change);
		return $context;	
		
	}
	
	/*
	 * Move a question
	 * The beforeId is the id of the dom element that precedes this element
	 */
	function moveQuestion(formIndex, sourceId, beforeId, locn) {		
		
		var $beforeElement,									// The element that the new item with be "before"
			beforeFormIndex,
			beforeItemIndex,
			
			seq,												// The new values
			formIndex,

			$sourceElement = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + sourceId),					// The old values
			sourceFormIndex = $sourceElement.data("fid"),
			sourceItemIndex = $sourceElement.data("id"),
			sourceSeq,
			sourceFormId,
			
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			question,
			change;
		
		$beforeElement = jquery__WEBPACK_IMPORTED_MODULE_0___default()("#" + beforeId);
		seq = 0;
		beforeItemIndex = 0;
		if($beforeElement.length > 0) {
			beforeFormIndex = $beforeElement.data("fid");
			if(beforeFormIndex == formIndex) {
				beforeItemIndex = $beforeElement.data("id");
				seq = getSequenceQuestion(beforeItemIndex, survey.forms[beforeFormIndex], false/*beforeFormIndex === sourceFormIndex*/, sourceItemIndex);	
				if(locn === "after") {
					seq++;
				}
			}
		}

		// Get the old sequence of the question
		sourceSeq = getSequenceQuestion(sourceItemIndex, survey.forms[sourceFormIndex], false, undefined);
		question = survey.forms[sourceFormIndex].questions[sourceItemIndex];
		sourceFormId = survey.forms[sourceFormIndex].id;										// Used to verify that a question has not been moved by another user

		// Create changeset to be applied on save	
		
		change = {
			changeType: "question",		// survey | form | language | question | option | (property | label) last two are types of property change
			action: "move",
			question: {
					seq: seq,
					sourceSeq: sourceSeq,
					sourceFormId: sourceFormId,
					name: question.name,
					type: question.type,
					path: question.path,
					
					// Helper values 
					sourceFormIndex: sourceFormIndex,
					sourceItemIndex: sourceItemIndex,
					formIndex: formIndex
				}
		};
		

		
		
		var $context = _changeset__WEBPACK_IMPORTED_MODULE_4__["default"].add(change);
		return $context;				// Add events on to the altered html
		
	}
	
	/*
	 * Move an option
	 */
	function moveBeforeOption(sourceListName, sourceItemIndex, 
				targetListName, targetItemIndex, locn) {		
		
		var 	
			seq,	
			sourceSeq,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			change;

		// Get the new sequence of the option
		_option__WEBPACK_IMPORTED_MODULE_5__["default"].addOptionSequence(survey.optionLists[targetListName]);
		seq = getSequenceOption(targetItemIndex, survey.optionLists[targetListName]);
		if(locn === "after") {
			seq++;
		}
		
		// Get the old sequence of the option
		sourceSeq = getSequenceOption(sourceItemIndex, survey.optionLists[sourceListName]);
		
		// Create changeset to be applied on save		
		change = {
			changeType: "option",		// survey | form | language | question | option | (property | label) last two are types of property change
			action: "move",
			option: {
					seq: seq,
					sourceSeq: sourceSeq,
					optionList: targetListName,
					sourceOptionList: sourceListName,
					
					// Helper values 
					sourceItemIndex: sourceItemIndex,
					targetItemIndex: targetItemIndex
				}
				
		};
		
		var $context = _changeset__WEBPACK_IMPORTED_MODULE_4__["default"].add(change);
		return $context;				// Add events on to the altered html
		
	}
	
	/*
	 * Delete a question
	 */
	function deleteQuestion(item) {
		var $deletedElement = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + item),
			formIndex = $deletedElement.data("fid"),
			itemIndex = $deletedElement.data("id"),
			change,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			seq;
		
		seq = getSequenceQuestion(itemIndex, survey.forms[formIndex], false, undefined);
		
		change = {
				changeType: "question",		// survey | form | language | question | option | (property | label) last two are types of property change
				action: "delete",
				question: {
					
					// Helper values 
					seq: seq,
					formIndex: formIndex,
					itemIndex: itemIndex,
					$deletedElement: $deletedElement	// JQuery element that is next to the new question
				}
		};
		_changeset__WEBPACK_IMPORTED_MODULE_4__["default"].add(change);
	}
	
	/*
	 * Delete an option
	 */
	function deleteOption(index, list_name) {
		var $deletedElement, 
			change,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			seq;
		
		_option__WEBPACK_IMPORTED_MODULE_5__["default"].addOptionSequence(survey.optionLists[list_name]);
		seq = getSequenceOption(index, survey.optionLists[list_name]);
		$deletedElement = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView').find('tr').filter(function() {
			var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
			return $this.data("id") == index;
		});

		change = {

				changeType: "option",		// survey | form | language | question | option | (property | label) last two are types of property change
				action: "delete",
				option: {
					
					// Helper values 
					seq: seq,
					optionList: list_name,
					itemIndex: index,
					$deletedElement: $deletedElement	// Jquery element that is next to the new question
				}
		};
		_changeset__WEBPACK_IMPORTED_MODULE_4__["default"].add(change);
	}
	
	/*
	 * Add a new option
	 */
	function addOption(oId, locn, list_name, formIndex, qname) {		
		
		var seq = 0,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			value,
			i;

		_option__WEBPACK_IMPORTED_MODULE_5__["default"].addOptionSequence(survey.optionLists[list_name]);
		seq = getSequenceOption(oId, survey.optionLists[list_name]); 
		
		value = getDefaultOptionValue(list_name, seq);

		// Create changeset to be applied on save
		var change = {
				changeType: "option",		// survey | form | language | question | option | (property | label) last two are types of property change
				action: "add",				// add | update | delete
				source: "editor",
				option: {
					seq: seq,
					optionList: list_name,
					sId: survey.id,
					labels: [],
					value: value,
					cascade_filters: {},
					
					// Helper values 
					formIndex: formIndex,
					optionIndex: oId,
					qname: qname,
					locn: locn,							// Whether the new option was added before or after the related option
				}
		};
		
		// Add default empty languages
		for(i = 0; i < survey.languages.length; i++) {
			change.option.labels.push({text:""});
		}
		var $context = _changeset__WEBPACK_IMPORTED_MODULE_4__["default"].add(change);
		return $context;				// Add events on to the altered HTML
		
	}
	
	/*
	 * Get default option value
	 */
	function getDefaultOptionValue(list_name, optionIndex) {
		
		var optionLists = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists,
			list = optionLists[list_name],
			name = list.maxOption;
		
		// Keep incrementing the maxOptionValue until we get a unque name for this optionList
		while(!nameIsUniqueInOptionList(list, name)) {
			name = ++list.maxOption;
		}
		
		return String(name);

	}
	/*
	 * Get the display sequence of the question
	 * If exclude is set to true then don't count the question with index "excludeIndex"
	 *  This should be used when you are getting the new seq of a question that is being moved
	 *  The old location of that question will be removed and should not be counted
	 */
	function getSequenceQuestion(qIndex, form, exclude, excludeIndex) {
		var i,
			seq = 0;
		
		for(i = 0; i < form.qSeq.length; i++) {
			if(form.qSeq[i] === qIndex) {
				return seq;
			}
			if(!exclude || (form.qSeq[i] !== excludeIndex)) {
				seq++;
			}
		}
		return 0;
	}
	
	/*
	 * Get the display sequence of an end group
	 */
	function getEndGroup(endName, form) {
		var i,
			endGroupData = {};
		
		for(i = 0; i < form.qSeq.length; i++) {
			if(form.questions[form.qSeq[i]].name === endName) {
				endGroupData.seq = i;
				endGroupData.index = form.qSeq[i];
				return endGroupData;
			}
		}
		alert("Could not locate the current end group with name: " + endName);
		return 0;
	}
	
	/*
	 * Get the display sequence of the option
	 */
	function getSequenceOption(indexOther, optionList) {
		var i;
		
		for(i = 0; i < optionList.oSeq.length; i++) {
			if(optionList.oSeq[i] == indexOther) {
				return i;
			}
		}
		return optionList.oSeq.length;		// Add to end
	}
	


/***/ },

/***/ "./WebContent/js/libs/bootbox.5.1.1.min.js"
/*!*************************************************!*\
  !*** ./WebContent/js/libs/bootbox.5.1.1.min.js ***!
  \*************************************************/
(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/**
 * bootbox.js 5.1.3
 *
 * http://bootboxjs.com/license.txt
 */
!function(e,t){'use strict'; true?!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "jquery")], __WEBPACK_AMD_DEFINE_FACTORY__ = (t),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)):0}(this,function t(p,u){'use strict';var r,n,i,l;Object.keys||(Object.keys=(r=Object.prototype.hasOwnProperty,n=!{toString:null}.propertyIsEnumerable('toString'),l=(i=['toString','toLocaleString','valueOf','hasOwnProperty','isPrototypeOf','propertyIsEnumerable','constructor']).length,function(e){if('function'!=typeof e&&('object'!=typeof e||null===e))throw new TypeError('Object.keys called on non-object');var t,o,a=[];for(t in e)r.call(e,t)&&a.push(t);if(n)for(o=0;o<l;o++)r.call(e,i[o])&&a.push(i[o]);return a}));var d={};d.VERSION='5.0.0';var b={},f={dialog:"<div class=\"bootbox modal\" tabindex=\"-1\" role=\"dialog\" aria-hidden=\"true\"><div class=\"modal-dialog\"><div class=\"modal-content\"><div class=\"modal-body\"><div class=\"bootbox-body\"></div></div></div></div></div>",header:"<div class=\"modal-header\"><h5 class=\"modal-title\"></h5></div>",footer:'<div class="modal-footer"></div>',closeButton:'<button type="button" class="bootbox-close-button close" aria-hidden="true">&times;</button>',form:'<form class="bootbox-form"></form>',button:'<button type="button" class="btn"></button>',option:'<option></option>',promptMessage:'<div class="bootbox-prompt-message"></div>',inputs:{text:'<input class="bootbox-input bootbox-input-text form-control" autocomplete="off" type="text" />',textarea:'<textarea class="bootbox-input bootbox-input-textarea form-control"></textarea>',email:'<input class="bootbox-input bootbox-input-email form-control" autocomplete="off" type="email" />',select:'<select class="bootbox-input bootbox-input-select form-control"></select>',checkbox:'<div class="form-check checkbox"><label class="form-check-label"><input class="form-check-input bootbox-input bootbox-input-checkbox" type="checkbox" /></label></div>',radio:'<div class="form-check radio"><label class="form-check-label"><input class="form-check-input bootbox-input bootbox-input-radio" type="radio" name="bootbox-radio" /></label></div>',date:'<input class="bootbox-input bootbox-input-date form-control" autocomplete="off" type="date" />',time:'<input class="bootbox-input bootbox-input-time form-control" autocomplete="off" type="time" />',number:'<input class="bootbox-input bootbox-input-number form-control" autocomplete="off" type="number" />',password:'<input class="bootbox-input bootbox-input-password form-control" autocomplete="off" type="password" />',range:'<input class="bootbox-input bootbox-input-range form-control-range" autocomplete="off" type="range" />'}},m={locale:'en',backdrop:'static',animate:!0,className:null,closeButton:!0,show:!0,container:'body',value:'',inputType:'text',swapButtonOrder:!1,centerVertical:!1,multiple:!1,scrollable:!1};function c(e,t,o){return p.extend(!0,{},e,function(e,t){var o=e.length,a={};if(o<1||2<o)throw new Error('Invalid argument length');return 2===o||'string'==typeof e[0]?(a[t[0]]=e[0],a[t[1]]=e[1]):a=e[0],a}(t,o))}function h(e,t,o,a){var r;a&&a[0]&&(r=a[0].locale||m.locale,(a[0].swapButtonOrder||m.swapButtonOrder)&&(t=t.reverse()));var n,i,l,s={className:'bootbox-'+e,buttons:function(e,t){for(var o={},a=0,r=e.length;a<r;a++){var n=e[a],i=n.toLowerCase(),l=n.toUpperCase();o[i]={label:(s=l,c=t,void 0,p=b[c],p?p[s]:b.en[s])}}var s,c,p;return o}(t,r)};return n=c(s,a,o),l={},v(i=t,function(e,t){l[t]=!0}),v(n.buttons,function(e){if(l[e]===u)throw new Error('button key "'+e+'" is not allowed (options are '+i.join(' ')+')')}),n}function w(e){return Object.keys(e).length}function v(e,o){var a=0;p.each(e,function(e,t){o(e,t,a++)})}function g(e,t,o){e.stopPropagation(),e.preventDefault(),p.isFunction(o)&&!1===o.call(t,e)||t.modal('hide')}function y(e){return/([01][0-9]|2[0-3]):[0-5][0-9]?:[0-5][0-9]/.test(e)}function x(e){return/(\d{4})-(\d{2})-(\d{2})/.test(e)}return d.locales=function(e){return e?b[e]:b},d.addLocale=function(e,o){return p.each(['OK','CANCEL','CONFIRM'],function(e,t){if(!o[t])throw new Error('Please supply a translation for "'+t+'"')}),b[e]={OK:o.OK,CANCEL:o.CANCEL,CONFIRM:o.CONFIRM},d},d.removeLocale=function(e){if('en'===e)throw new Error('"en" is used as the default and fallback locale and cannot be removed.');return delete b[e],d},d.setLocale=function(e){return d.setDefaults('locale',e)},d.setDefaults=function(){var e={};return 2===arguments.length?e[arguments[0]]=arguments[1]:e=arguments[0],p.extend(m,e),d},d.hideAll=function(){return p('.bootbox').modal('hide'),d},d.init=function(e){return t(e||p)},d.dialog=function(e){if(p.fn.modal===u)throw new Error("\"$.fn.modal\" is not defined; please double check you have included the Bootstrap JavaScript library. See http://getbootstrap.com/javascript/ for more details.");if(e=function(r){var n,i;if('object'!=typeof r)throw new Error('Please supply an object of options');if(!r.message)throw new Error('"message" option must not be null or an empty string.');(r=p.extend({},m,r)).buttons||(r.buttons={});return n=r.buttons,i=w(n),v(n,function(e,t,o){if(p.isFunction(t)&&(t=n[e]={callback:t}),'object'!==p.type(t))throw new Error('button with key "'+e+'" must be an object');if(t.label||(t.label=e),!t.className){var a=!1;a=r.swapButtonOrder?0===o:o===i-1,t.className=i<=2&&a?'btn-primary':'btn-secondary btn-default'}}),r}(e),p.fn.modal.Constructor.VERSION){e.fullBootstrapVersion=p.fn.modal.Constructor.VERSION;var t=e.fullBootstrapVersion.indexOf('.');e.bootstrap=e.fullBootstrapVersion.substring(0,t)}else e.bootstrap='2',e.fullBootstrapVersion='2.3.2',console.warn('Bootbox will *mostly* work with Bootstrap 2, but we do not officially support it. Please upgrade, if possible.');var o=p(f.dialog),a=o.find('.modal-dialog'),r=o.find('.modal-body'),n=p(f.header),i=p(f.footer),l=e.buttons,s={onEscape:e.onEscape};if(r.find('.bootbox-body').html(e.message),0<w(e.buttons)&&(v(l,function(e,t){var o=p(f.button);switch(o.data('bb-handler',e),o.addClass(t.className),e){case'ok':case'confirm':o.addClass('bootbox-accept');break;case'cancel':o.addClass('bootbox-cancel')}o.html(t.label),i.append(o),s[e]=t.callback}),r.after(i)),!0===e.animate&&o.addClass('fade'),e.className&&o.addClass(e.className),e.size)switch(e.fullBootstrapVersion.substring(0,3)<'3.1'&&console.warn('"size" requires Bootstrap 3.1.0 or higher. You appear to be using '+e.fullBootstrapVersion+'. Please upgrade to use this option.'),e.size){case'small':case'sm':a.addClass('modal-sm');break;case'large':case'lg':a.addClass('modal-lg');break;case'xl':case'extra-large':e.fullBootstrapVersion.substring(0,3)<'4.2'&&console.warn('Using size "xl"/"extra-large" requires Bootstrap 4.2.0 or higher. You appear to be using '+e.fullBootstrapVersion+'. Please upgrade to use this option.'),a.addClass('modal-xl')}if(e.scrollable&&(e.fullBootstrapVersion.substring(0,3)<'4.3'&&console.warn('Using "scrollable" requires Bootstrap 4.3.0 or higher. You appear to be using '+e.fullBootstrapVersion+'. Please upgrade to use this option.'),a.addClass('modal-dialog-scrollable')),e.title&&(r.before(n),o.find('.modal-title').html(e.title)),e.closeButton){var c=p(f.closeButton);e.title?3<e.bootstrap?o.find('.modal-header').append(c):o.find('.modal-header').prepend(c):c.prependTo(r)}return e.centerVertical&&(e.fullBootstrapVersion<'4.0.0'&&console.warn('"centerVertical" requires Bootstrap 4.0.0-beta.3 or higher. You appear to be using '+e.fullBootstrapVersion+'. Please upgrade to use this option.'),a.addClass('modal-dialog-centered')),o.one('hide.bs.modal',function(e){e.target===this&&(o.off('escape.close.bb'),o.off('click'))}),o.one('hidden.bs.modal',function(e){e.target===this&&o.remove()}),o.one('shown.bs.modal',function(){o.find('.bootbox-accept:first').trigger('focus')}),'static'!==e.backdrop&&o.on('click.dismiss.bs.modal',function(e){o.children('.modal-backdrop').length&&(e.currentTarget=o.children('.modal-backdrop').get(0)),e.target===e.currentTarget&&o.trigger('escape.close.bb')}),o.on('escape.close.bb',function(e){s.onEscape&&g(e,o,s.onEscape)}),o.on('click','.modal-footer button:not(.disabled)',function(e){var t=p(this).data('bb-handler');g(e,o,s[t])}),o.on('click','.bootbox-close-button',function(e){g(e,o,s.onEscape)}),o.on('keyup',function(e){27===e.which&&o.trigger('escape.close.bb')}),p(e.container).append(o),o.modal({backdrop:!!e.backdrop&&'static',keyboard:!1,show:!1}),e.show&&o.modal('show'),o},d.alert=function(){var e;if((e=h('alert',['ok'],['message','callback'],arguments)).callback&&!p.isFunction(e.callback))throw new Error('alert requires the "callback" property to be a function when provided');return e.buttons.ok.callback=e.onEscape=function(){return!p.isFunction(e.callback)||e.callback.call(this)},d.dialog(e)},d.confirm=function(){var e;if(e=h('confirm',['cancel','confirm'],['message','callback'],arguments),!p.isFunction(e.callback))throw new Error('confirm requires a callback');return e.buttons.cancel.callback=e.onEscape=function(){return e.callback.call(this,!1)},e.buttons.confirm.callback=function(){return e.callback.call(this,!0)},d.dialog(e)},d.prompt=function(){var r,t,e,n,o,a;if(e=p(f.form),(r=h('prompt',['cancel','confirm'],['title','callback'],arguments)).value||(r.value=m.value),r.inputType||(r.inputType=m.inputType),o=r.show===u?m.show:r.show,r.show=!1,r.buttons.cancel.callback=r.onEscape=function(){return r.callback.call(this,null)},r.buttons.confirm.callback=function(){var e;if('checkbox'===r.inputType)e=n.find('input:checked').map(function(){return p(this).val()}).get();else if('radio'===r.inputType)e=n.find('input:checked').val();else{if(n[0].checkValidity&&!n[0].checkValidity())return!1;e='select'===r.inputType&&!0===r.multiple?n.find('option:selected').map(function(){return p(this).val()}).get():n.val()}return r.callback.call(this,e)},!r.title)throw new Error('prompt requires a title');if(!p.isFunction(r.callback))throw new Error('prompt requires a callback');if(!f.inputs[r.inputType])throw new Error('Invalid prompt type');switch(n=p(f.inputs[r.inputType]),r.inputType){case'text':case'textarea':case'email':case'password':n.val(r.value),r.placeholder&&n.attr('placeholder',r.placeholder),r.pattern&&n.attr('pattern',r.pattern),r.maxlength&&n.attr('maxlength',r.maxlength),r.required&&n.prop({required:!0}),r.rows&&!isNaN(parseInt(r.rows))&&'textarea'===r.inputType&&n.attr({rows:r.rows});break;case'date':case'time':case'number':case'range':if(n.val(r.value),r.placeholder&&n.attr('placeholder',r.placeholder),r.pattern&&n.attr('pattern',r.pattern),r.required&&n.prop({required:!0}),'date'!==r.inputType&&r.step){if(!('any'===r.step||!isNaN(r.step)&&0<parseInt(r.step)))throw new Error('"step" must be a valid positive number or the value "any". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-step for more information.');n.attr('step',r.step)}(function(e,t,o){var a=!1,r=!0,n=!0;if('date'===e)t===u||(r=x(t))?o===u||(n=x(o))||console.warn('Browsers which natively support the "date" input type expect date values to be of the form "YYYY-MM-DD" (see ISO-8601 https://www.iso.org/iso-8601-date-and-time-format.html). Bootbox does not enforce this rule, but your max value may not be enforced by this browser.'):console.warn('Browsers which natively support the "date" input type expect date values to be of the form "YYYY-MM-DD" (see ISO-8601 https://www.iso.org/iso-8601-date-and-time-format.html). Bootbox does not enforce this rule, but your min value may not be enforced by this browser.');else if('time'===e){if(t!==u&&!(r=y(t)))throw new Error('"min" is not a valid time. See https://www.w3.org/TR/2012/WD-html-markup-20120315/datatypes.html#form.data.time for more information.');if(o!==u&&!(n=y(o)))throw new Error('"max" is not a valid time. See https://www.w3.org/TR/2012/WD-html-markup-20120315/datatypes.html#form.data.time for more information.')}else{if(t!==u&&isNaN(t))throw new Error('"min" must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-min for more information.');if(o!==u&&isNaN(o))throw new Error('"max" must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.')}if(r&&n){if(o<=t)throw new Error('"max" must be greater than "min". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.');a=!0}return a})(r.inputType,r.min,r.max)&&(r.min!==u&&n.attr('min',r.min),r.max!==u&&n.attr('max',r.max));break;case'select':var i={};if(a=r.inputOptions||[],!p.isArray(a))throw new Error('Please pass an array of input options');if(!a.length)throw new Error('prompt with "inputType" set to "select" requires at least one option');r.placeholder&&n.attr('placeholder',r.placeholder),r.required&&n.prop({required:!0}),r.multiple&&n.prop({multiple:!0}),v(a,function(e,t){var o=n;if(t.value===u||t.text===u)throw new Error('each option needs a "value" property and a "text" property');t.group&&(i[t.group]||(i[t.group]=p('<optgroup />').attr('label',t.group)),o=i[t.group]);var a=p(f.option);a.attr('value',t.value).text(t.text),o.append(a)}),v(i,function(e,t){n.append(t)}),n.val(r.value);break;case'checkbox':var l=p.isArray(r.value)?r.value:[r.value];if(!(a=r.inputOptions||[]).length)throw new Error('prompt with "inputType" set to "checkbox" requires at least one option');n=p('<div class="bootbox-checkbox-list"></div>'),v(a,function(e,o){if(o.value===u||o.text===u)throw new Error('each option needs a "value" property and a "text" property');var a=p(f.inputs[r.inputType]);a.find('input').attr('value',o.value),a.find('label').append('\n'+o.text),v(l,function(e,t){t===o.value&&a.find('input').prop('checked',!0)}),n.append(a)});break;case'radio':if(r.value!==u&&p.isArray(r.value))throw new Error('prompt with "inputType" set to "radio" requires a single, non-array value for "value"');if(!(a=r.inputOptions||[]).length)throw new Error('prompt with "inputType" set to "radio" requires at least one option');n=p('<div class="bootbox-radiobutton-list"></div>');var s=!0;v(a,function(e,t){if(t.value===u||t.text===u)throw new Error('each option needs a "value" property and a "text" property');var o=p(f.inputs[r.inputType]);o.find('input').attr('value',t.value),o.find('label').append('\n'+t.text),r.value!==u&&t.value===r.value&&(o.find('input').prop('checked',!0),s=!1),n.append(o)}),s&&n.find('input[type="radio"]').first().prop('checked',!0)}if(e.append(n),e.on('submit',function(e){e.preventDefault(),e.stopPropagation(),t.find('.bootbox-accept').trigger('click')}),''!==p.trim(r.message)){var c=p(f.promptMessage).html(r.message);e.prepend(c),r.message=e}else r.message=e;return(t=d.dialog(r)).off('shown.bs.modal'),t.on('shown.bs.modal',function(){n.focus()}),!0===o&&t.modal('show'),t},d.addLocale('en',{OK:'OK',CANCEL:'Cancel',CONFIRM:'OK'}),d});

/***/ },

/***/ "./WebContent/js/libs/bootstrap-colorpicker.min.js"
/*!*********************************************************!*\
  !*** ./WebContent/js/libs/bootstrap-colorpicker.min.js ***!
  \*********************************************************/
(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * Bootstrap Colorpicker v2.5.2
 * https://itsjavi.com/bootstrap-colorpicker/
 */
!function(a,b){ true?!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "jquery")], __WEBPACK_AMD_DEFINE_RESULT__ = (function(a){return b(a)}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)):0}(this,function(a){"use strict";var b=function(c,d,e,f,g){this.fallbackValue=e?"string"==typeof e?this.parse(e):e:null,this.fallbackFormat=f?f:"rgba",this.hexNumberSignPrefix=g===!0,this.value=this.fallbackValue,this.origFormat=null,this.predefinedColors=d?d:{},this.colors=a.extend({},b.webColors,this.predefinedColors),c&&("undefined"!=typeof c.h?this.value=c:this.setColor(String(c))),this.value||(this.value={h:0,s:0,b:0,a:1})};b.webColors={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32",transparent:"transparent"},b.prototype={constructor:b,colors:{},predefinedColors:{},getValue:function(){return this.value},setValue:function(a){this.value=a},_sanitizeNumber:function(a){return"number"==typeof a?a:isNaN(a)||null===a||""===a||void 0===a?1:""===a?0:"undefined"!=typeof a.toLowerCase?(a.match(/^\./)&&(a="0"+a),Math.ceil(100*parseFloat(a))/100):1},isTransparent:function(a){return!(!a||!("string"==typeof a||a instanceof String))&&(a=a.toLowerCase().trim(),"transparent"===a||a.match(/#?00000000/)||a.match(/(rgba|hsla)\(0,0,0,0?\.?0\)/))},rgbaIsTransparent:function(a){return 0===a.r&&0===a.g&&0===a.b&&0===a.a},setColor:function(a){if(a=a.toLowerCase().trim()){if(this.isTransparent(a))return this.value={h:0,s:0,b:0,a:0},!0;var b=this.parse(a);b?(this.value=this.value={h:b.h,s:b.s,b:b.b,a:b.a},this.origFormat||(this.origFormat=b.format)):this.fallbackValue&&(this.value=this.fallbackValue)}return!1},setHue:function(a){this.value.h=1-a},setSaturation:function(a){this.value.s=a},setBrightness:function(a){this.value.b=1-a},setAlpha:function(a){this.value.a=Math.round(parseInt(100*(1-a),10)/100*100)/100},toRGB:function(a,b,c,d){0===arguments.length&&(a=this.value.h,b=this.value.s,c=this.value.b,d=this.value.a),a*=360;var e,f,g,h,i;return a=a%360/60,i=c*b,h=i*(1-Math.abs(a%2-1)),e=f=g=c-i,a=~~a,e+=[i,h,0,0,h,i][a],f+=[h,i,i,h,0,0][a],g+=[0,0,h,i,i,h][a],{r:Math.round(255*e),g:Math.round(255*f),b:Math.round(255*g),a:d}},toHex:function(a,b,c,d,e){arguments.length<=1&&(b=this.value.h,c=this.value.s,d=this.value.b,e=this.value.a);var f="#",g=this.toRGB(b,c,d,e);if(this.rgbaIsTransparent(g))return"transparent";a||(f=this.hexNumberSignPrefix?"#":"");var h=f+((1<<24)+(parseInt(g.r)<<16)+(parseInt(g.g)<<8)+parseInt(g.b)).toString(16).slice(1);return h},toHSL:function(a,b,c,d){0===arguments.length&&(a=this.value.h,b=this.value.s,c=this.value.b,d=this.value.a);var e=a,f=(2-b)*c,g=b*c;return g/=f>0&&f<=1?f:2-f,f/=2,g>1&&(g=1),{h:isNaN(e)?0:e,s:isNaN(g)?0:g,l:isNaN(f)?0:f,a:isNaN(d)?0:d}},toAlias:function(a,b,c,d){var e,f=0===arguments.length?this.toHex(!0):this.toHex(!0,a,b,c,d),g="alias"===this.origFormat?f:this.toString(!1,this.origFormat);for(var h in this.colors)if(e=this.colors[h].toLowerCase().trim(),e===f||e===g)return h;return!1},RGBtoHSB:function(a,b,c,d){a/=255,b/=255,c/=255;var e,f,g,h;return g=Math.max(a,b,c),h=g-Math.min(a,b,c),e=0===h?null:g===a?(b-c)/h:g===b?(c-a)/h+2:(a-b)/h+4,e=(e+360)%6*60/360,f=0===h?0:h/g,{h:this._sanitizeNumber(e),s:f,b:g,a:this._sanitizeNumber(d)}},HueToRGB:function(a,b,c){return c<0?c+=1:c>1&&(c-=1),6*c<1?a+(b-a)*c*6:2*c<1?b:3*c<2?a+(b-a)*(2/3-c)*6:a},HSLtoRGB:function(a,b,c,d){b<0&&(b=0);var e;e=c<=.5?c*(1+b):c+b-c*b;var f=2*c-e,g=a+1/3,h=a,i=a-1/3,j=Math.round(255*this.HueToRGB(f,e,g)),k=Math.round(255*this.HueToRGB(f,e,h)),l=Math.round(255*this.HueToRGB(f,e,i));return[j,k,l,this._sanitizeNumber(d)]},parse:function(b){if("string"!=typeof b)return this.fallbackValue;if(0===arguments.length)return!1;var c,d,e=this,f=!1,g="undefined"!=typeof this.colors[b];return g&&(b=this.colors[b].toLowerCase().trim()),a.each(this.stringParsers,function(a,h){var i=h.re.exec(b);return c=i&&h.parse.apply(e,[i]),!c||(f={},d=g?"alias":h.format?h.format:e.getValidFallbackFormat(),f=d.match(/hsla?/)?e.RGBtoHSB.apply(e,e.HSLtoRGB.apply(e,c)):e.RGBtoHSB.apply(e,c),f instanceof Object&&(f.format=d),!1)}),f},getValidFallbackFormat:function(){var a=["rgba","rgb","hex","hsla","hsl"];return this.origFormat&&a.indexOf(this.origFormat)!==-1?this.origFormat:this.fallbackFormat&&a.indexOf(this.fallbackFormat)!==-1?this.fallbackFormat:"rgba"},toString:function(a,c,d){c=c||this.origFormat||this.fallbackFormat,d=d||!1;var e=!1;switch(c){case"rgb":return e=this.toRGB(),this.rgbaIsTransparent(e)?"transparent":"rgb("+e.r+","+e.g+","+e.b+")";case"rgba":return e=this.toRGB(),"rgba("+e.r+","+e.g+","+e.b+","+e.a+")";case"hsl":return e=this.toHSL(),"hsl("+Math.round(360*e.h)+","+Math.round(100*e.s)+"%,"+Math.round(100*e.l)+"%)";case"hsla":return e=this.toHSL(),"hsla("+Math.round(360*e.h)+","+Math.round(100*e.s)+"%,"+Math.round(100*e.l)+"%,"+e.a+")";case"hex":return this.toHex(a);case"alias":return e=this.toAlias(),e===!1?this.toString(a,this.getValidFallbackFormat()):d&&!(e in b.webColors)&&e in this.predefinedColors?this.predefinedColors[e]:e;default:return e}},stringParsers:[{re:/rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*?\)/,format:"rgb",parse:function(a){return[a[1],a[2],a[3],1]}},{re:/rgb\(\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*?\)/,format:"rgb",parse:function(a){return[2.55*a[1],2.55*a[2],2.55*a[3],1]}},{re:/rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d*(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(a){return[a[1],a[2],a[3],a[4]]}},{re:/rgba\(\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*(?:,\s*(\d*(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(a){return[2.55*a[1],2.55*a[2],2.55*a[3],a[4]]}},{re:/hsl\(\s*(\d*(?:\.\d+)?)\s*,\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*?\)/,format:"hsl",parse:function(a){return[a[1]/360,a[2]/100,a[3]/100,a[4]]}},{re:/hsla\(\s*(\d*(?:\.\d+)?)\s*,\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*(?:,\s*(\d*(?:\.\d+)?)\s*)?\)/,format:"hsla",parse:function(a){return[a[1]/360,a[2]/100,a[3]/100,a[4]]}},{re:/#?([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/,format:"hex",parse:function(a){return[parseInt(a[1],16),parseInt(a[2],16),parseInt(a[3],16),1]}},{re:/#?([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/,format:"hex",parse:function(a){return[parseInt(a[1]+a[1],16),parseInt(a[2]+a[2],16),parseInt(a[3]+a[3],16),1]}}],colorNameToHex:function(a){return"undefined"!=typeof this.colors[a.toLowerCase()]&&this.colors[a.toLowerCase()]}};var c={horizontal:!1,inline:!1,color:!1,format:!1,input:"input",container:!1,component:".add-on, .input-group-addon",fallbackColor:!1,fallbackFormat:"hex",hexNumberSignPrefix:!0,sliders:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:0,maxTop:100,callLeft:!1,callTop:"setHue"},alpha:{maxLeft:0,maxTop:100,callLeft:!1,callTop:"setAlpha"}},slidersHorz:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:100,maxTop:0,callLeft:"setHue",callTop:!1},alpha:{maxLeft:100,maxTop:0,callLeft:"setAlpha",callTop:!1}},template:'<div class="colorpicker dropdown-menu"><div class="colorpicker-saturation"><i><b></b></i></div><div class="colorpicker-hue"><i></i></div><div class="colorpicker-alpha"><i></i></div><div class="colorpicker-color"><div /></div><div class="colorpicker-selectors"></div></div>',align:"right",customClass:null,colorSelectors:null},d=function(b,d){this.element=a(b).addClass("colorpicker-element"),this.options=a.extend(!0,{},c,this.element.data(),d),this.component=this.options.component,this.component=this.component!==!1&&this.element.find(this.component),this.component&&0===this.component.length&&(this.component=!1),this.container=this.options.container===!0?this.element:this.options.container,this.container=this.container!==!1&&a(this.container),this.input=this.element.is("input")?this.element:!!this.options.input&&this.element.find(this.options.input),this.input&&0===this.input.length&&(this.input=!1),this.color=this.createColor(this.options.color!==!1?this.options.color:this.getValue()),this.format=this.options.format!==!1?this.options.format:this.color.origFormat,this.options.color!==!1&&(this.updateInput(this.color),this.updateData(this.color)),this.disabled=!1;var e=this.picker=a(this.options.template);if(this.options.customClass&&e.addClass(this.options.customClass),this.options.inline?e.addClass("colorpicker-inline colorpicker-visible"):e.addClass("colorpicker-hidden"),this.options.horizontal&&e.addClass("colorpicker-horizontal"),["rgba","hsla","alias"].indexOf(this.format)===-1&&this.options.format!==!1&&"transparent"!==this.getValue()||e.addClass("colorpicker-with-alpha"),"right"===this.options.align&&e.addClass("colorpicker-right"),this.options.inline===!0&&e.addClass("colorpicker-no-arrow"),this.options.colorSelectors){var f=this,g=f.picker.find(".colorpicker-selectors");g.length>0&&(a.each(this.options.colorSelectors,function(b,c){var d=a("<i />").addClass("colorpicker-selectors-color").css("background-color",c).data("class",b).data("alias",b);d.on("mousedown.colorpicker touchstart.colorpicker",function(b){b.preventDefault(),f.setValue("alias"===f.format?a(this).data("alias"):a(this).css("background-color"))}),g.append(d)}),g.show().addClass("colorpicker-visible"))}e.on("mousedown.colorpicker touchstart.colorpicker",a.proxy(function(a){a.target===a.currentTarget&&a.preventDefault()},this)),e.find(".colorpicker-saturation, .colorpicker-hue, .colorpicker-alpha").on("mousedown.colorpicker touchstart.colorpicker",a.proxy(this.mousedown,this)),e.appendTo(this.container?this.container:a("body")),this.input!==!1&&(this.input.on({"keyup.colorpicker":a.proxy(this.keyup,this)}),this.input.on({"change.colorpicker":a.proxy(this.change,this)}),this.component===!1&&this.element.on({"focus.colorpicker":a.proxy(this.show,this)}),this.options.inline===!1&&this.element.on({"focusout.colorpicker":a.proxy(this.hide,this)})),this.component!==!1&&this.component.on({"click.colorpicker":a.proxy(this.show,this)}),this.input===!1&&this.component===!1&&this.element.on({"click.colorpicker":a.proxy(this.show,this)}),this.input!==!1&&this.component!==!1&&"color"===this.input.attr("type")&&this.input.on({"click.colorpicker":a.proxy(this.show,this),"focus.colorpicker":a.proxy(this.show,this)}),this.update(),a(a.proxy(function(){this.element.trigger("create")},this))};d.Color=b,d.prototype={constructor:d,destroy:function(){this.picker.remove(),this.element.removeData("colorpicker","color").off(".colorpicker"),this.input!==!1&&this.input.off(".colorpicker"),this.component!==!1&&this.component.off(".colorpicker"),this.element.removeClass("colorpicker-element"),this.element.trigger({type:"destroy"})},reposition:function(){if(this.options.inline!==!1||this.options.container)return!1;var a=this.container&&this.container[0]!==window.document.body?"position":"offset",b=this.component||this.element,c=b[a]();"right"===this.options.align&&(c.left-=this.picker.outerWidth()-b.outerWidth()),this.picker.css({top:c.top+b.outerHeight(),left:c.left})},show:function(b){this.isDisabled()||(this.picker.addClass("colorpicker-visible").removeClass("colorpicker-hidden"),this.reposition(),a(window).on("resize.colorpicker",a.proxy(this.reposition,this)),!b||this.hasInput()&&"color"!==this.input.attr("type")||b.stopPropagation&&b.preventDefault&&(b.stopPropagation(),b.preventDefault()),!this.component&&this.input||this.options.inline!==!1||a(window.document).on({"mousedown.colorpicker":a.proxy(this.hide,this)}),this.element.trigger({type:"showPicker",color:this.color}))},hide:function(b){return("undefined"==typeof b||!b.target||!(a(b.currentTarget).parents(".colorpicker").length>0||a(b.target).parents(".colorpicker").length>0))&&(this.picker.addClass("colorpicker-hidden").removeClass("colorpicker-visible"),a(window).off("resize.colorpicker",this.reposition),a(window.document).off({"mousedown.colorpicker":this.hide}),this.update(),void this.element.trigger({type:"hidePicker",color:this.color}))},updateData:function(a){return a=a||this.color.toString(!1,this.format),this.element.data("color",a),a},updateInput:function(a){return a=a||this.color.toString(!1,this.format),this.input!==!1&&(this.input.prop("value",a),this.input.trigger("change")),a},updatePicker:function(a){"undefined"!=typeof a&&(this.color=this.createColor(a));var b=this.options.horizontal===!1?this.options.sliders:this.options.slidersHorz,c=this.picker.find("i");if(0!==c.length)return this.options.horizontal===!1?(b=this.options.sliders,c.eq(1).css("top",b.hue.maxTop*(1-this.color.value.h)).end().eq(2).css("top",b.alpha.maxTop*(1-this.color.value.a))):(b=this.options.slidersHorz,c.eq(1).css("left",b.hue.maxLeft*(1-this.color.value.h)).end().eq(2).css("left",b.alpha.maxLeft*(1-this.color.value.a))),c.eq(0).css({top:b.saturation.maxTop-this.color.value.b*b.saturation.maxTop,left:this.color.value.s*b.saturation.maxLeft}),this.picker.find(".colorpicker-saturation").css("backgroundColor",this.color.toHex(!0,this.color.value.h,1,1,1)),this.picker.find(".colorpicker-alpha").css("backgroundColor",this.color.toHex(!0)),this.picker.find(".colorpicker-color, .colorpicker-color div").css("backgroundColor",this.color.toString(!0,this.format)),a},updateComponent:function(a){var b;if(b="undefined"!=typeof a?this.createColor(a):this.color,this.component!==!1){var c=this.component.find("i").eq(0);c.length>0?c.css({backgroundColor:b.toString(!0,this.format)}):this.component.css({backgroundColor:b.toString(!0,this.format)})}return b.toString(!1,this.format)},update:function(a){var b;return this.getValue(!1)===!1&&a!==!0||(b=this.updateComponent(),this.updateInput(b),this.updateData(b),this.updatePicker()),b},setValue:function(a){this.color=this.createColor(a),this.update(!0),this.element.trigger({type:"changeColor",color:this.color,value:a})},createColor:function(a){return new b(a?a:null,this.options.colorSelectors,this.options.fallbackColor?this.options.fallbackColor:this.color,this.options.fallbackFormat,this.options.hexNumberSignPrefix)},getValue:function(a){a="undefined"==typeof a?this.options.fallbackColor:a;var b;return b=this.hasInput()?this.input.val():this.element.data("color"),void 0!==b&&""!==b&&null!==b||(b=a),b},hasInput:function(){return this.input!==!1},isDisabled:function(){return this.disabled},disable:function(){return this.hasInput()&&this.input.prop("disabled",!0),this.disabled=!0,this.element.trigger({type:"disable",color:this.color,value:this.getValue()}),!0},enable:function(){return this.hasInput()&&this.input.prop("disabled",!1),this.disabled=!1,this.element.trigger({type:"enable",color:this.color,value:this.getValue()}),!0},currentSlider:null,mousePointer:{left:0,top:0},mousedown:function(b){!b.pageX&&!b.pageY&&b.originalEvent&&b.originalEvent.touches&&(b.pageX=b.originalEvent.touches[0].pageX,b.pageY=b.originalEvent.touches[0].pageY),b.stopPropagation(),b.preventDefault();var c=a(b.target),d=c.closest("div"),e=this.options.horizontal?this.options.slidersHorz:this.options.sliders;if(!d.is(".colorpicker")){if(d.is(".colorpicker-saturation"))this.currentSlider=a.extend({},e.saturation);else if(d.is(".colorpicker-hue"))this.currentSlider=a.extend({},e.hue);else{if(!d.is(".colorpicker-alpha"))return!1;this.currentSlider=a.extend({},e.alpha)}var f=d.offset();this.currentSlider.guide=d.find("i")[0].style,this.currentSlider.left=b.pageX-f.left,this.currentSlider.top=b.pageY-f.top,this.mousePointer={left:b.pageX,top:b.pageY},a(window.document).on({"mousemove.colorpicker":a.proxy(this.mousemove,this),"touchmove.colorpicker":a.proxy(this.mousemove,this),"mouseup.colorpicker":a.proxy(this.mouseup,this),"touchend.colorpicker":a.proxy(this.mouseup,this)}).trigger("mousemove")}return!1},mousemove:function(a){!a.pageX&&!a.pageY&&a.originalEvent&&a.originalEvent.touches&&(a.pageX=a.originalEvent.touches[0].pageX,a.pageY=a.originalEvent.touches[0].pageY),a.stopPropagation(),a.preventDefault();var b=Math.max(0,Math.min(this.currentSlider.maxLeft,this.currentSlider.left+((a.pageX||this.mousePointer.left)-this.mousePointer.left))),c=Math.max(0,Math.min(this.currentSlider.maxTop,this.currentSlider.top+((a.pageY||this.mousePointer.top)-this.mousePointer.top)));return this.currentSlider.guide.left=b+"px",this.currentSlider.guide.top=c+"px",this.currentSlider.callLeft&&this.color[this.currentSlider.callLeft].call(this.color,b/this.currentSlider.maxLeft),this.currentSlider.callTop&&this.color[this.currentSlider.callTop].call(this.color,c/this.currentSlider.maxTop),this.options.format!==!1||"setAlpha"!==this.currentSlider.callTop&&"setAlpha"!==this.currentSlider.callLeft||(1!==this.color.value.a?(this.format="rgba",this.color.origFormat="rgba"):(this.format="hex",this.color.origFormat="hex")),this.update(!0),this.element.trigger({type:"changeColor",color:this.color}),!1},mouseup:function(b){return b.stopPropagation(),b.preventDefault(),a(window.document).off({"mousemove.colorpicker":this.mousemove,"touchmove.colorpicker":this.mousemove,"mouseup.colorpicker":this.mouseup,"touchend.colorpicker":this.mouseup}),!1},change:function(a){this.keyup(a)},keyup:function(a){38===a.keyCode?(this.color.value.a<1&&(this.color.value.a=Math.round(100*(this.color.value.a+.01))/100),this.update(!0)):40===a.keyCode?(this.color.value.a>0&&(this.color.value.a=Math.round(100*(this.color.value.a-.01))/100),this.update(!0)):(this.color=this.createColor(this.input.val()),this.color.origFormat&&this.options.format===!1&&(this.format=this.color.origFormat),this.getValue(!1)!==!1&&(this.updateData(),this.updateComponent(),this.updatePicker())),this.element.trigger({type:"changeColor",color:this.color,value:this.input.val()})}},a.colorpicker=d,a.fn.colorpicker=function(b){var c=Array.prototype.slice.call(arguments,1),e=1===this.length,f=null,g=this.each(function(){var e=a(this),g=e.data("colorpicker"),h="object"==typeof b?b:{};g||(g=new d(this,h),e.data("colorpicker",g)),"string"==typeof b?a.isFunction(g[b])?f=g[b].apply(g,c):(c.length&&(g[b]=c[0]),f=g[b]):f=e});return e?f:g},a.fn.colorpicker.constructor=d});

/***/ },

/***/ "./WebContent/js/libs/bootstrap.file-input.js"
/*!****************************************************!*\
  !*** ./WebContent/js/libs/bootstrap.file-input.js ***!
  \****************************************************/
() {

/*
  Bootstrap - File Input
  ======================

  This is meant to convert all file input tags into a set of elements that displays consistently in all browsers.

  Converts all
  <input type="file">
  into Bootstrap buttons
  <a class="btn">Browse</a>

*/
(function($) {

$.fn.bootstrapFileInput = function() {

  this.each(function(i,elem){

    var $elem = $(elem);

    // Maybe some fields don't need to be standardized.
    if (typeof $elem.attr('data-bfi-disabled') != 'undefined') {
      return;
    }

    // Set the word to be displayed on the button
    var buttonWord = localise.set["ar_af"];
    //var buttonWord = 'Browse';

    //if (typeof $elem.attr('title') != 'undefined') {
    //  buttonWord = $elem.attr('title');
    //}

    var className = '';

    if (!!$elem.attr('class')) {
      className = ' ' + $elem.attr('class');
    }

    // Now we're going to wrap that input field with a Bootstrap button.
    // The input will actually still be there, it will just be float above and transparent (done with the CSS).
    buttonWord = '<i class="glyphicon glyphicon-plus"></i>' + '<span>' + buttonWord + '</span>';
    $elem.wrap('<a class="file-input-wrapper btn btn-success ' + className + '"></a>').parent().prepend(buttonWord);
  })

  // After we have found all of the file inputs let's apply a listener for tracking the mouse movement.
  // This is important because the in order to give the illusion that this is a button in FF we actually need to move the button from the file input under the cursor. Ugh.
  .promise().done( function(){

    // As the cursor moves over our new Bootstrap button we need to adjust the position of the invisible file input Browse button to be under the cursor.
    // This gives us the pointer cursor that FF denies us
    $('.file-input-wrapper').mousemove(function(cursor) {

      var input, wrapper,
        wrapperX, wrapperY,
        inputWidth, inputHeight,
        cursorX, cursorY;

      // This wrapper element (the button surround this file input)
      wrapper = $(this);
      // The invisible file input element
      input = wrapper.find("input");
      // The left-most position of the wrapper
      wrapperX = wrapper.offset().left;
      // The top-most position of the wrapper
      wrapperY = wrapper.offset().top;
      // The with of the browsers input field
      inputWidth= input.width();
      // The height of the browsers input field
      inputHeight= input.height();
      //The position of the cursor in the wrapper
      cursorX = cursor.pageX;
      cursorY = cursor.pageY;

      //The positions we are to move the invisible file input
      // The 20 at the end is an arbitrary number of pixels that we can shift the input such that cursor is not pointing at the end of the Browse button but somewhere nearer the middle
      moveInputX = cursorX - wrapperX - inputWidth + 20;
      // Slides the invisible input Browse button to be positioned middle under the cursor
      moveInputY = cursorY- wrapperY - (inputHeight/2);

      // Apply the positioning styles to actually move the invisible file input
      input.css({
        left:moveInputX,
        top:moveInputY
      });
    });

    $('body').on('change', '.file-input-wrapper input[type=file]', function(){

      var fileName,
      		fileDesc,
      		$this = $(this),
      		$target = $('.upload_file_msg');
     
      if ($this.prop('files') && $this.prop('files').length > 1) {
    	  fileDesc = '';
    	  for(i = 0; i < $this.prop('files').length; i++) {
    		  fileName = $this[0].files[i].name;
    		  fileName = fileName.substring(fileName.lastIndexOf('\\') + 1, fileName.length);
    		  if(i > 0) {
    			  fileDesc += ', ';
    		  }
    		  fileDesc += fileName;
    	  }
      }
      else {
    	fileName = $this.val();
        fileName = fileName.substring(fileName.lastIndexOf('\\') + 1, fileName.length);
        fileDesc = fileName;
      }

      // Don't try to show the name if there is none
      if (!fileDesc) {
          $target.addClass('alert-success').removeClass('alert-danger').html("").val("");
	      $('.submitFiles').addClass('disabled');
          return;
      }
      $('.submitFiles').removeClass('disabled');
      $target.addClass('alert-success').removeClass('alert-danger').html(fileDesc).val(fileDesc);

      var w = 0;
      $('.progress-bar').css('width', w+'%').attr('aria-valuenow', w); 
   
    });

  });

};

// Add the styles before the first stylesheet
// This ensures they can be easily overridden with developer styles
var cssHtml = '<style>'+
  '.file-input-wrapper { overflow: hidden; position: relative; cursor: pointer; z-index: 1; }'+
  '.file-input-wrapper input[type=file], .file-input-wrapper input[type=file]:focus, .file-input-wrapper input[type=file]:hover { position: absolute; top: 0; left: 0; cursor: pointer; opacity: 0; filter: alpha(opacity=0); z-index: 99; outline: 0; }'+
  '.file-input-name { margin-left: 8px; }'+
  '</style>';
$('link[rel=stylesheet]').eq(0).before(cssHtml);

})(jQuery);

/***/ },

/***/ "./WebContent/js/libs/wb/plugins/iCheck/icheck.min.js"
/*!************************************************************!*\
  !*** ./WebContent/js/libs/wb/plugins/iCheck/icheck.min.js ***!
  \************************************************************/
() {

/*! iCheck v1.0.2 by Damir Sultanov, http://git.io/arlzeA, MIT Licensed */
(function(f){function A(a,b,d){var c=a[0],g=/er/.test(d)?_indeterminate:/bl/.test(d)?n:k,e=d==_update?{checked:c[k],disabled:c[n],indeterminate:"true"==a.attr(_indeterminate)||"false"==a.attr(_determinate)}:c[g];if(/^(ch|di|in)/.test(d)&&!e)x(a,g);else if(/^(un|en|de)/.test(d)&&e)q(a,g);else if(d==_update)for(var f in e)e[f]?x(a,f,!0):q(a,f,!0);else if(!b||"toggle"==d){if(!b)a[_callback]("ifClicked");e?c[_type]!==r&&q(a,g):x(a,g)}}function x(a,b,d){var c=a[0],g=a.parent(),e=b==k,u=b==_indeterminate,
    v=b==n,s=u?_determinate:e?y:"enabled",F=l(a,s+t(c[_type])),B=l(a,b+t(c[_type]));if(!0!==c[b]){if(!d&&b==k&&c[_type]==r&&c.name){var w=a.closest("form"),p='input[name="'+c.name+'"]',p=w.length?w.find(p):f(p);p.each(function(){this!==c&&f(this).data(m)&&q(f(this),b)})}u?(c[b]=!0,c[k]&&q(a,k,"force")):(d||(c[b]=!0),e&&c[_indeterminate]&&q(a,_indeterminate,!1));D(a,e,b,d)}c[n]&&l(a,_cursor,!0)&&g.find("."+C).css(_cursor,"default");g[_add](B||l(a,b)||"");g.attr("role")&&!u&&g.attr("aria-"+(v?n:k),"true");
    g[_remove](F||l(a,s)||"")}function q(a,b,d){var c=a[0],g=a.parent(),e=b==k,f=b==_indeterminate,m=b==n,s=f?_determinate:e?y:"enabled",q=l(a,s+t(c[_type])),r=l(a,b+t(c[_type]));if(!1!==c[b]){if(f||!d||"force"==d)c[b]=!1;D(a,e,s,d)}!c[n]&&l(a,_cursor,!0)&&g.find("."+C).css(_cursor,"pointer");g[_remove](r||l(a,b)||"");g.attr("role")&&!f&&g.attr("aria-"+(m?n:k),"false");g[_add](q||l(a,s)||"")}function E(a,b){if(a.data(m)){a.parent().html(a.attr("style",a.data(m).s||""));if(b)a[_callback](b);a.off(".i").unwrap();
    f(_label+'[for="'+a[0].id+'"]').add(a.closest(_label)).off(".i")}}function l(a,b,f){if(a.data(m))return a.data(m).o[b+(f?"":"Class")]}function t(a){return a.charAt(0).toUpperCase()+a.slice(1)}function D(a,b,f,c){if(!c){if(b)a[_callback]("ifToggled");a[_callback]("ifChanged")[_callback]("if"+t(f))}}var m="iCheck",C=m+"-helper",r="radio",k="checked",y="un"+k,n="disabled";_determinate="determinate";_indeterminate="in"+_determinate;_update="update";_type="type";_click="click";_touch="touchbegin.i touchend.i";
    _add="addClass";_remove="removeClass";_callback="trigger";_label="label";_cursor="cursor";_mobile=/ipad|iphone|ipod|android|blackberry|windows phone|opera mini|silk/i.test(navigator.userAgent);f.fn[m]=function(a,b){var d='input[type="checkbox"], input[type="'+r+'"]',c=f(),g=function(a){a.each(function(){var a=f(this);c=a.is(d)?c.add(a):c.add(a.find(d))})};if(/^(check|uncheck|toggle|indeterminate|determinate|disable|enable|update|destroy)$/i.test(a))return a=a.toLowerCase(),g(this),c.each(function(){var c=
        f(this);"destroy"==a?E(c,"ifDestroyed"):A(c,!0,a);f.isFunction(b)&&b()});if("object"!=typeof a&&a)return this;var e=f.extend({checkedClass:k,disabledClass:n,indeterminateClass:_indeterminate,labelHover:!0},a),l=e.handle,v=e.hoverClass||"hover",s=e.focusClass||"focus",t=e.activeClass||"active",B=!!e.labelHover,w=e.labelHoverClass||"hover",p=(""+e.increaseArea).replace("%","")|0;if("checkbox"==l||l==r)d='input[type="'+l+'"]';-50>p&&(p=-50);g(this);return c.each(function(){var a=f(this);E(a);var c=this,
        b=c.id,g=-p+"%",d=100+2*p+"%",d={position:"absolute",top:g,left:g,display:"block",width:d,height:d,margin:0,padding:0,background:"#fff",border:0,opacity:0},g=_mobile?{position:"absolute",visibility:"hidden"}:p?d:{position:"absolute",opacity:0},l="checkbox"==c[_type]?e.checkboxClass||"icheckbox":e.radioClass||"i"+r,z=f(_label+'[for="'+b+'"]').add(a.closest(_label)),u=!!e.aria,y=m+"-"+Math.random().toString(36).substr(2,6),h='<div class="'+l+'" '+(u?'role="'+c[_type]+'" ':"");u&&z.each(function(){h+=
        'aria-labelledby="';this.id?h+=this.id:(this.id=y,h+=y);h+='"'});h=a.wrap(h+"/>")[_callback]("ifCreated").parent().append(e.insert);d=f('<ins class="'+C+'"/>').css(d).appendTo(h);a.data(m,{o:e,s:a.attr("style")}).css(g);e.inheritClass&&h[_add](c.className||"");e.inheritID&&b&&h.attr("id",m+"-"+b);"static"==h.css("position")&&h.css("position","relative");A(a,!0,_update);if(z.length)z.on(_click+".i mouseover.i mouseout.i "+_touch,function(b){var d=b[_type],e=f(this);if(!c[n]){if(d==_click){if(f(b.target).is("a"))return;
        A(a,!1,!0)}else B&&(/ut|nd/.test(d)?(h[_remove](v),e[_remove](w)):(h[_add](v),e[_add](w)));if(_mobile)b.stopPropagation();else return!1}});a.on(_click+".i focus.i blur.i keyup.i keydown.i keypress.i",function(b){var d=b[_type];b=b.keyCode;if(d==_click)return!1;if("keydown"==d&&32==b)return c[_type]==r&&c[k]||(c[k]?q(a,k):x(a,k)),!1;if("keyup"==d&&c[_type]==r)!c[k]&&x(a,k);else if(/us|ur/.test(d))h["blur"==d?_remove:_add](s)});d.on(_click+" mousedown mouseup mouseover mouseout "+_touch,function(b){var d=
        b[_type],e=/wn|up/.test(d)?t:v;if(!c[n]){if(d==_click)A(a,!1,!0);else{if(/wn|er|in/.test(d))h[_add](e);else h[_remove](e+" "+t);if(z.length&&B&&e==v)z[/ut|nd/.test(d)?_remove:_add](w)}if(_mobile)b.stopPropagation();else return!1}})})}})(window.jQuery||window.Zepto);


/***/ },

/***/ "jquery"
/*!*************************!*\
  !*** external "jQuery" ***!
  \*************************/
(module) {

"use strict";
module.exports = jQuery;

/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!*******************************!*\
  !*** ./WebContent/js/edit.js ***!
  \*******************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _libs_bootstrap_file_input_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./libs/bootstrap.file-input.js */ "./WebContent/js/libs/bootstrap.file-input.js");
/* harmony import */ var _libs_bootstrap_file_input_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_libs_bootstrap_file_input_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./libs/bootbox.5.1.1.min.js */ "./WebContent/js/libs/bootbox.5.1.1.min.js");
/* harmony import */ var _libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _libs_bootstrap_colorpicker_min_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./libs/bootstrap-colorpicker.min.js */ "./WebContent/js/libs/bootstrap-colorpicker.min.js");
/* harmony import */ var _libs_bootstrap_colorpicker_min_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_libs_bootstrap_colorpicker_min_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _libs_wb_plugins_iCheck_icheck_min_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./libs/wb/plugins/iCheck/icheck.min.js */ "./WebContent/js/libs/wb/plugins/iCheck/icheck.min.js");
/* harmony import */ var _libs_wb_plugins_iCheck_icheck_min_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_libs_wb_plugins_iCheck_icheck_min_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _app_localise__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./app/localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _app_globals__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./app/globals */ "./WebContent/js/app/globals.js");
/* harmony import */ var _app_question__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./app/question */ "./WebContent/js/app/question.js");
/* harmony import */ var _app_optionlist__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./app/optionlist */ "./WebContent/js/app/optionlist.js");
/* harmony import */ var _app_editorMarkup__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./app/editorMarkup */ "./WebContent/js/app/editorMarkup.js");
/* harmony import */ var _app_changeset__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./app/changeset */ "./WebContent/js/app/changeset.js");
/* harmony import */ var _app_option__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./app/option */ "./WebContent/js/app/option.js");
/* harmony import */ var _app_aws__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./app/aws */ "./WebContent/js/app/aws.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/



const $ = window.$;













window.bootbox = (_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default());
const moment = window.moment;

let gUserLocale = navigator.language;
if (typeof localStorage !== "undefined") {
	try {
		gUserLocale = localStorage.getItem('user_locale') || navigator.language;
	} catch (error) {
		gUserLocale = navigator.language;
	}
}

window.gUserLocale = gUserLocale;

var	gMode = "survey",
	gTempQuestions = [],
	$gCurrentRow,			// Currently selected row
	gTempLanguages = [],
	gTempPulldata = [],
	gDragCounter,
	gDragSourceId,
	gSurveyIdents,
	gSurveyNames,
	gSurveyUrl,
	gSurveyUrlCacheBuster,
	gFiles;
// Media globals

// Media Modal Parameters
var gNewVal,
	gElement,
	gQname,
	gQType,
	gIsSurveyLevel,
	g_from_lang_val,
	g_to_lang_val;

window.gAppChoiceArray = [];
var gAppearanceQuestion;
var gAppearanceParams;
$(function() {


	var i,
		params,
		pArray,
		param = [],
		dont_get_current_survey;

	window.bootbox = (_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default());
	window.moment = moment;

	setTheme();
    setCustomEdit();
	setupUserProfile(false);
		_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].initLocale(gUserLocale).then(function () {
			window.gUserLocale = gUserLocale;
			_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].setlang();		// Localise HTML
			var $defaultProperty = $('#selProperty a.default').first();
			if ($defaultProperty.length) {
				$('#propSelected').html($defaultProperty.html());
				_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSelLabel = $defaultProperty.html();
				_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSelProperty = $defaultProperty.data("prop");
			}

			// Get the parameters and start editing a survey if one was passed as a parameter
			params = location.search.substring(location.search.indexOf("?") + 1);
			pArray = params.split("&");
			dont_get_current_survey = false;
			for (i = 0; i < pArray.length; i++) {
				param = pArray[i].split("=");
				if ( param[0] === "id" ) {
					dont_get_current_survey = true;		// Use the passed in survey id
					_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey = param[1];
					saveCurrentProject(-1, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey, undefined);	// Save the current survey id
				} else if ( param[0] === "new" ) {
					dont_get_current_survey = true;		// Don't get any survey details
					_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey = -1;			
					openForm("new");
				}
			}

			/*
			 * Get surveys and csv files that the user can link to
			 */
			getAccessibleSurveys($('.linkable_surveys'), true, true, false, true);
			getAccessibleCsvFiles($('.linkable_files'), true);
		});

/*
 * Initialise controls in the open form dialog
 */


	 $('#base_on_existing').click(function () {
		 if($(this).is(':checked')) {
			 $('.reusing_form').show();
				getSurveyForms($('#survey_name').val(), addForms);
		 } else {
			 $('.reusing_form').hide();
		 }
	 });

	 $('#survey_name').change(function(){
		var $this = $(this);
		getSurveyForms($this.val(), addForms);
	 });

	window.history.pushState('',document.title, document.location.origin + document.location.pathname);	// Strip out the parameters from the href

	// Get the user details
	getLoggedInUser(getSurveyList, false, true, undefined, false, dont_get_current_survey);

	/*
	 * Switch between choices list view and question view
	 */
	_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].updateViewControls();
	$('#viewType').change(function() {
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gIsQuestionView = $(this).prop('checked');
		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].updateViewControls();

		refreshForm();
	});

	/*
	 * Refresh the view when the selected property changes
	 */
	$('#selProperty a').click(function() {
		$('#propSelected').html($(this).html());
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSelLabel = $(this).html();
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSelProperty = $(this).data("prop")
		refreshFeaturedProperties();

 	 });

	// Add menu functions
	$('#m_open').off().click(function() {	// Open an existing form
		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].changes.length > 0) {
			if (confirm(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_unsav"])) {
				openForm("existing");
			}
		} else {
			openForm("existing");
		}

	});
	$('#m_new').off().click(function() {	// Open a new form
		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].changes.length > 0) {
			if (confirm(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_unsav"])) {
				openForm("new");
			}
		} else {
			openForm("new");
		}

	});
	$('.m_save_survey').off().click(function() {	// Save a survey to the server
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSaveInProgress = true;
		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].validateAll();

		if(_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].numberIssues("error") === 0) {
			_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].save(surveyListDone);
			gSurveyUrlCacheBuster = addCacheBuster(gSurveyUrl);	// Update the cache buster
		} else {
			_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSaveInProgress = false;
			_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_er"]);
		}
	});

	$('#next-error').off().click(function(){
		nextIssue("error");
	});

	$('#next-warning').off().click(function(){
		nextIssue("warning");
	});

	$('.m_validate').off().click(function() {
		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].validateAll();
	});

	$('.m_languages').off().click(function() {

		if($(this).closest('li').hasClass('disabled')) {
			_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_cml"]);
		} else {
			gTempLanguages = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.languages.slice();
			updateLanguageView();
			$('#editLanguageModal').modal("show");
		}
	});

    $('#m_required').off().click(function() {
		if($(this).closest('li').hasClass('disabled')) {
			_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_csr"]);
		} else {
			setAllRequired(true);
		}
	});

	$('#m_not_required').off().click(function() {
		if($(this).closest('li').hasClass('disabled')) {
			_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_csr"]);
		} else {
			setAllRequired(false);
		}
	});

	$('#m_slu').off().click(function() {
		var selection = window.getSelection().toString();
		var ident;
		if(selection.indexOf('linked_s') == 0) {
			ident = selection.substring('linked_'.length);
		} else if(selection.indexOf('linked_pd_s') == 0) {
			ident = selection.substring('linked_pd_'.length);
		} else {
			ident = selection;
		}

		if(typeof gSurveyNames !== "undefined") {
			showSurveySummary(gSurveyNames);
		} else {
			addHourglass();
			$.ajax({
				url: "/surveyKPI/surveys/summary/" + ident,
				cache: false,
				dataType: 'json',
				success: function (data) {
					removeHourglass();
					gSurveyNames = data;
					showSurveySummary(data);

				},
				error: function (xhr, textStatus, err) {
					removeHourglass();
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(ident + " " + _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_not_f"]);
					}
				}
			});
		}

	});

	$('#m_gsi').off().click(function() {

		if(gSurveyIdents) {
			showSurveyIdentList(gSurveyIdents);
		} else {
			addHourglass();
			$.ajax({
				url: "/surveyKPI/surveys/idents",
				cache: false,
				dataType: 'json',
				success: function (data) {
					removeHourglass();
					gSurveyIdents = data;
					showSurveyIdentList(data);

				},
				error: function (xhr, textStatus, err) {
					removeHourglass();
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(ident + " " + _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_not_f"]);
					}
				}
			});
		}
	});


	$('#addLanguage').off().click(function() {
		gTempLanguages.push({
			id: -1,
			name: "",
			deleted: false
		});
		updateLanguageView();
	});

	$('#addPulldata').off().click(function() {
		gTempPulldata.push({
			survey: "",
			data_key: "",
			deleted: false
		});
		updatePulldataView();
	});

	// Set up view type toggle
	$('#viewType').attr("data-on", _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_questions"]).attr("data-off", _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_choices"]).bootstrapToggle();

	$('#m_settings').off().click(function() {	// Show the settings dialog

		// Close any drop downmenus
		$('.dropdown-toggle').parent().removeClass("open");
		$('.navbar-collapse').removeClass("in");

		updateSettingsData();

		$('#settingsMsg').html("").hide();
		$('#settingsModal').modal('show');
	});

    $('#m_keys').off().click(function() {	// Show the keys dialog

        // Close any drop downmenus
        $('.dropdown-toggle').parent().removeClass("open");
        $('.navbar-collapse').removeClass("in");

        updateSettingsData();

    });

	$('#save_settings').off().click(function() {	// Save settings to the database

		/*
		 * Validate
		 */
		var displayName = $('#set_survey_name').val();	// Survey name must be set
		if(!displayName) {
			alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_er"]);
            return false;
		}

		var refQuestions = {};		// Check referenced questions
		var name;
		getReferenceNames($('#set_instance_name').val(), refQuestions);
		if(checkExistenceOfReferences(refQuestions, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey)) {
			for (name in refQuestions) {
				if (refQuestions.hasOwnProperty(name)) {
					if (!refQuestions[name].exists) {
						alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_question"] + " ${" + name + "} " + _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_not_f"]);
						return(false);
					}
				}
			}
		}
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.save_settings();
	});

	$('#m_info').off().click(function() {	// Show the info dialog

		var tableNames ="",
			i,
			idx;

		idx = 0;
		for(i = 0; i < _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.forms.length; i++) {
			if(!_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.forms[i].reference) {
                if (idx > 0) {
                    tableNames += ", ";
                }
                tableNames += _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.forms[i].tableName;
                idx++;
            }
		}
		// Close any drop down menus
		$('.dropdown-toggle').parent().removeClass("open");
		$('.navbar-collapse').removeClass("in");

		$('#i_name').val(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.displayName);
		$('#i_ident').val(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.ident);
		$('#i_version').val(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.version);
		$('#i_created').val(localTime(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.created));
		$('#i_based_on').val(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.basedOn);
		$('#i_table_names').val(tableNames);
        $('#i_id').val(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.id);

		$('#infoModal').modal('show');
	});
	
	// Set initial focus to the cancel button as nothing else is possible
	$("#infoModal").on("shown.bs.modal", function() {
		$("#infoCancel").focus();
	});

    $('#m_export').off().click(function() {	// Export to XLS
        if($(this).closest('li').hasClass('disabled')) {
            _libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_cx"]);
        } else {
         	checkLoggedIn(exportSurvey);
        }
    });

    /*
     * Respond to a change in the form to be launched
     * If the question type is a child form then the list of questions needs to be updated
     */
	$('#p_form_identifier').change(function(){
		var survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey;
		var qType = survey.forms[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex].questions[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex].type;
		if(qType === "child_form") {
			getQuestionsInSurvey($('#p_key_question'), undefined, $(this).val(), true, true, setAppearanceValues, true);
		}
	});

    /*
     * Respond to clicking of the save parameters button in the parameters edit modal
     */
	$('#parameterSave').click(function() {
		var params = [];
		var newVal;
		var survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey;
		var question = survey.forms[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex].questions[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex];
		var i;
		var paramDetails;
		var other;

		$('#parameter_msg').hide();
		var qParams = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.qParams[question.type];
		if(qParams && qParams.length > 0) {
			for(i = 0; i < qParams.length; i++) {
				paramDetails = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.paramDetails[qParams[i]];
				if(!getParam($('#' + paramDetails.field), params, qParams[i], paramDetails.type)) {
					return false;
				}
			}
		}
		other=$('#p_other').val();
		// validate
		if(other.length > 0) {
			var oArray = other.split(';');
			for(i = 0; i < oArray.length; i++) {
				var oArray2 = oArray[i].split('=');
				if(oArray2.length != 2) {
					$('#parameter_msg').show().html(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_pformat"]);
					return false;
				}
			}
		}

		newVal = params.join(';');
		if(newVal.length > 0 && other.length > 0) {
			newVal += ';';
		}
		newVal += other;
		updateLabel("question", _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex, undefined, "text", newVal, gQname, "parameters");

		$('#parameterModal').modal("hide");
	});

	/*
	 * Change data values that are dependent on the parameter source value
	 */
	$('#p_source').change(function() {
		setLanguageCodes();
	});

	/*
     * Set up colour picker
     */
	$('.colorpicker-component').colorpicker({
		format: 'hex'
	});

	// Set up the tabs
	$('#standardTab a').click(function (e) {
		e.preventDefault();
		$(this).tab('show');

		$(".appearancetab").hide();
		$('#standardPanel').show();

	});
	$('#searchTab a').click(function (e) {
		e.preventDefault();
		$(this).tab('show');

		$(".appearancetab").hide();
		$('#searchPanel').show();
	});

	$('#pdfTab a').click(function (e) {
		e.preventDefault();
		$(this).tab('show');

		$(".appearancetab").hide();
		$('#pdfPanel').show();
	});

	// parameter tabs
	$('#standardParamTab a').click(function (e) {
		e.preventDefault();
		$(this).tab('show');

		$(".paramtab").hide();
		$('#standardParamPanel').show();
	});
	$('#annotateParamTab a').click(function (e) {
		e.preventDefault();
		$(this).tab('show');

		$(".paramtab").hide();
		$('#annotateParamPanel').show();
	});

	// Hide and show search elements
	$('#a_filter_column, #a_second_filter_column, #a_csv_identifier, ' +
		'#a_survey_identifier, input[type=radio][name=search_source],' +
		'#a_search_value, #a_search_label, #a_access, #a_fe').change(function() {
			showSearchElements();
	});

	// Trigger change in survey or csv list
	$('input[type=radio][name=search_source]').change(function() {
		$('#a_survey_identifier').trigger('change');
	});

	$('#a_pdfno').change(function() {
		if($(this).prop('checked')) {
			$('.pdf_appearance_field').hide();
		} else {
			$('.pdf_appearance_field').show();
		}
	});
	$('#a_pdfmap').change(function() {
		var map=$(this).val();
		if(map === 'custom') {
			$('.pdf_custom_map').show();
		} else {
			$('.pdf_custom_map').hide();
		}
	});

	$('#a_pdfmapsource').change(function() {
		var source = $(this).val();
		if(source === 'mapbox') {
			$('.a_pdfmap_mb').show();
			$('.a_pdfmap_g').hide();
		} else {
			$('.a_pdfmap_mb').hide();
			$('.a_pdfmap_g').show();
		}
	});

	$('#a_pdfcols_number').change(function() {
		var val = $(this).val();
		var i;

		$('.pdfcols').hide();
		if($(this).val() !== '') {
			for(i = 1; i <= val; i++) {
				$('.pdfcols' + i).show();
				$('#a_pdfcols_' + i + '_l').html(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_col_width"].replace('%s1', i));
			}
		}
	});

	// Validate on value change
	$('#a_sep, #a_numbers, #a_select1_type, #a_likert').change(function(){
		checkForAppearanceWarnings();
	});

	/*
	 * Respond to a change in the question used as the value for a search filter
	 */
	$('#a_filter_value_sel').change(function(){
		$('#a_filter_value_static').val('${' + $(this).val() + '}')
	});
	$('#a_second_filter_value_sel').change(function(){
		$('#a_second_filter_value_static').val('${' + $(this).val() + '}')
	});

	/*
     * Respond to a change in the form that is to be searched
     * If the question type is a child form then the list of questions needs to be updated
     */
	$('#a_survey_identifier, #a_csv_identifier').change(function(){
		var search_source = $('input[type=radio][name=search_source]:checked').val();
		if(search_source === "survey") {
			getQuestionsInSurvey($('.column_select'), $('.column_select_multiple'), $('#a_survey_identifier').val(), true, false, setAppearanceValues, true);
		} else {
			getQuestionsInCsvFile($('.column_select'), $('.column_select_multiple'), $('#a_csv_identifier').val(), true);
		}
	});

	/*
     * Respond to clicking of the save appearances button in the appearance edit modal
     */
	$('#appearanceSave').click(function() {
		var appearances = [];       // Array of appearance values taken from dialog
		var app_choices = [];       // Dummy appearances for choice value and labels
		var newVal;
		var newAppChoiceVal;
		var survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey;
		var question = survey.forms[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex].questions[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex];
		var i;
		var appearanceDetails;
		var other;

		$('#appearance_msg').hide();
		/*
		 * Get the appearance values from the dialog
		 */
		var qAppearances = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.qAppearances[question.type];
		if(qAppearances && qAppearances.length > 0) {
			for(i = 0; i < qAppearances.length; i++) {
				appearanceDetails = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.appearanceDetails[qAppearances[i]];
				if(!getAppearance($('#' + appearanceDetails.field), appearances, qAppearances[i], appearanceDetails, question.type, app_choices)) {
					return false;       // getAppearance returns false if there is an error
				}
			}
		}

		/*
		 * Get common appearance values
		 */
		var colour;
		if($('#a_hidden').prop('checked')) {
			appearances.push('hidden');
		}
		if($('#a_pdfno').prop('checked')) {
			appearances.push('pdfno');
		}
		if($('#a_pdf_lw').val() !== '') {
			appearances.push('pdflabelw_' + $('#a_pdf_lw').val());
		}
		if($('#a_pdfheight').val() && $('#a_pdfheight').val() !== '') {
			var pdfHeight = $('#a_pdfheight').val();
			if(pdfHeight < 0) {
				showAppearanceError(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_gt_0"]);
				$('#a_pdfheight').focus();
				return false;
			}
			appearances.push('pdfheight_' + pdfHeight);
		}
		var pdfcolsnumber = $('#a_pdfcols_number').val();
		if(pdfcolsnumber && pdfcolsnumber !== '') {
			var pdfcols = 'pdfcols';
			var pdfcolscount = +0;
			for(i = 1; i<= pdfcolsnumber; i++) {
				var col_i = $('#a_pdfcols_' + i).val();
				pdfcolscount += +col_i;
				pdfcols += '_' + col_i;
				if(+col_i > 10 || +col_i < 1) {
					showAppearanceError(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_pdfcols_width"]);
					$('#a_pdfcols_' + i).focus();
					return false;
				}
			}
			if(pdfcolscount !== 10) {
				showAppearanceError(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_pdfcols_count"]);
				$('#a_pdfcols_1').focus();
				return false;
			}
			appearances.push(pdfcols);
		}
		colour = $('#a_pdflabelbg').val();
		if(colour && colour !== '#ffffff') {
			 var c1 = colour.substring(1,3);
			 var c2 = colour.substring(3,5);
			 var c3 = colour.substring(5,7);
			 appearances.push('pdflabelbg_' + c1 + '_' + c2 + '_' +c3);
		}
		colour = $('#a_pdfvaluebg').val();
		if(colour && colour !== '#ffffff') {
			var c1 = colour.substring(1,3);
			var c2 = colour.substring(3,5);
			var c3 = colour.substring(5,7);
			appearances.push('pdfvaluebg_' + c1 + '_' + c2 + '_' +c3);
		}
		colour = $('#a_pdfmarkercolor').val();
		if(colour && colour !== '#ffffff') {
			var c1 = colour.substring(1,3);
			var c2 = colour.substring(3,5);
			var c3 = colour.substring(5,7);
			appearances.push('pdfmarkercolor_' + c1 + '_' + c2 + '_' +c3);
		}
		if($('#a_pdfspace').val() && $('#a_pdfspace').val() !== '') {
			appearances.push('pdfspace_' + $('#a_pdfspace').val());
		}
		if($('#a_pdfzoom').val() && $('#a_pdfzoom').val() !== '') {
			var zoom = $('#a_pdfzoom').val();
			if(zoom < 1 || zoom > 20) {
				showAppearanceError(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_pdfinv_zoom"]);
				$('#a_pdfzoom').focus();
				return false;
			}
			appearances.push('pdfzoom_' + zoom);
		}
		if($('#a_pdfround').val() && $('#a_pdfround').val() !== '') {
			var round = $('#a_pdfround').val();
			if(round < 0 || round > 10) {
				showAppearanceError(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_pdfinv_round"]);
				$('#a_pdfround').focus();
				return false;
			}
			appearances.push('pdfround_' + round);
		}
		if($('#a_pdfnewpage').prop('checked')) {
			appearances.push('pdfnewpage');
		}
		if($('#a_pdflabelcaps').prop('checked')) {
			appearances.push('pdflabelcaps');
		}
		if($('#a_pdflabelbold').prop('checked')) {
			appearances.push('pdflabelbold');
		}
		if($('#a_pdfapp').prop('checked')) {
			appearances.push('pdfapp');
		}
		if($('#a_pdfbarcode').prop('checked')) {
			appearances.push('pdfbarcode');
		}
		if($('#a_pdfshowimage').prop('checked')) {
			appearances.push('pdfshowimage');
		}
		if($('#a_pdfstretch').prop('checked')) {
			appearances.push('pdfstretch');
		}
		if($('#a_pdfhyperlink').prop('checked')) {
			appearances.push('pdfhyperlink');
		}
		if($('#a_pdfaddto').val() !== '') {
			appearances.push('pdfaddto_' + $('#a_pdfaddto').val());
		}

		// mapbox is the default
		if($('#a_pdfmapsource').val() != "none") {
			appearances.push('pdfmapsource_' + $('#a_pdfmapsource').val());
		}

		var pdfmap = $('#a_pdfmap').val();
		if (pdfmap !== 'default') {
			appearances.push('pdfmap_' + pdfmap);
			if (pdfmap === 'custom') {
				appearances.push('pdfcustommap_' + $('#a_pdfcustommap').val());
				appearances.push('pdfaccount_' + $('#a_pdfaccount').val());
			}
		}

		/*
		 * Add other
		 */
		other=$('#a_other').val();

		newVal = appearances.join(' ');
		if(newVal.length > 0 && other.length > 0) {
			newVal += ' ';
		}
		newVal += other;
		updateLabel("question", _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex, undefined, "text", newVal, gQname, "appearance");

		// Save the updated settings for search choices
		newAppChoiceVal = app_choices.join(' ');
		updateLabel("question", _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex, undefined, "text", newAppChoiceVal, gQname, "app_choices");
		$('#appearanceModal').modal("hide");
	});

	/*
	 * Save changes to the language list
	 */
	$('#editLanguageSave').off().click(function() {	// Save languages to the database

		var languagesString = JSON.stringify(gTempLanguages);
		addHourglass();
		$.ajax({
			  type: "POST",
			  url: "/surveyKPI/surveys/save_languages/" + _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey,
			  dataType: 'json',
			  cache: false,
			  data: { languages: languagesString },
				success: function(data) {
					removeHourglass();
					if(handleLogout(data)) {
						$('#editLanguageModal').modal("hide");
						_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.setSurveyData(data);
						setLanguages(data.languages, refreshForm);
						refreshForm();
					}
				},
				error: function(xhr, textStatus, err) {
					removeHourglass();
					if(xhr.readyState == 0 || xhr.status == 0) {
			              return;  // Not an error
					} else {
						alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_err_save"] + " " + xhr.responseText);
					}
				}
		});
	});

	$('#project_name').change(function() {
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentProject = $('#project_name option:selected').val();
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey = -1;
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentTaskGroup = undefined;

		saveCurrentProject(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentProject,
				_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey,
				_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentTaskGroup);

		getSurveyList();
 	 });

	// Check for changes in settings
	$('#set_survey_name, #set_instance_name').keyup(function(){

		// validate
		var displayName = $('#set_survey_name').val();
        if(!displayName || displayName.length == 0) {
            $('#settings_msg').html(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_val_nm"]).removeClass("alert-success").addClass("alert-danger").show();
        } else {

            $('#settings_msg').hide();
		}
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.settingsChange();
	});
	$('#set_project_name').change(function() {
		saveCurrentProject($('#set_project_name option:selected').val(), _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey);	// Save the current project id
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.settingsChange();
	});
	$('#set_default_language, #set_style, #default_logo').change(function() {
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.settingsChange();
	});
	$('#task_file').change(function() {
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.settingsChange();
	});
	$('#timing_data').change(function() {
		if($(this).is(':checked')) {
			$('.audit_location_data').show();
		} else {
			$('.audit_location_data').hide();
		}
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.settingsChange();
	});
	$('#hide_on_device, #search_local_data, #audit_location_data, #track_changes, #data_survey, #oversight_survey, ' +
			'#read_only_survey, #compress_pdf, #my_reference_data').change(function() {
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.settingsChange();
	});
    $('#exclude_empty').change(function() {
        _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.settingsChange();
    });

	// Check for selection of the label indicating successful updates and the one indicating failed
	$('#successLabel').off().click(function() {
		alert("success");
	});
	// Check for selection of the label indicating successful updates and the one indicating failed
	$('#failedLabel').off().click(function() {
		alert("failed");
	});

    $('.m_test_survey').off().click(function() {
        if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].changes.length > 0) {
            alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_test"]);
            return false;
        }
		$('.m_test_survey').attr("href", gSurveyUrl + gSurveyUrlCacheBuster);
		return true;
	});

	/*
	 * Add check prior to the user leaving the screen
	 */
	window.onbeforeunload = function() {
		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].changes.length > 0) {
			return _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_leave"];
		} else {
			return;
		}
	};

	/*
    $('#orgLevelTab a').click(function (e) {
    	  e.preventDefault();
    	  $(this).tab('show');
    	  gUrl = gBaseUrl;
    	  $('#survey_id').val("");				// clear the survey id in the forms hidden field
  		  gIsSurveyLevel = false;

    	  $('#orgPanel').show();
    	  $('#surveyPanel').hide();
    })

	 */

    $('.file-inputs').bootstrapFileInput();

    /*
     * Open a new form
     */
	$('#get_form').off().click(function() {

		var name,
			existing,
			existing_survey,
			shared_results;

		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentProject > 0) {
			_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].setHasChanges(0);		// Clear any existing changes from a previous form

			if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gExistingSurvey) {
				_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey = $('#survey_name option:selected').val();
				saveCurrentProject(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentProject, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey);	// Save the new survey id as the current survey
				getSurveyDetails(surveyDetailsDone);
			} else {
				name = $('#new_form_name').val();

				/*
				 * Validation
				 */
				if(typeof name === "undefined" || name.trim() == "") {
					_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_val_nm"]);
					$('#new_form_name').focus();
					return false;
				}
				if(!validGeneralName(name)) {
					_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_val_gen_nm"]);
					$('#new_form_name').focus();
					return false;
				}

				existing = $('#base_on_existing').prop('checked');
				existing_survey = $('#survey_name').val();
				shared_results = $('#shared_results').prop('checked');
				createNewSurvey(name, existing, existing_survey, shared_results, surveyDetailsDone);
			}
		} else {
			alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_val_p"]);
			return false;
		}
	 });

	/*
	 * If the survey is being based on another survey then the user can select the project for the
	 * other existing survey
	 */
    $('#existing_project').change(function() {
        var existingProject = $('#existing_project option:selected').val();
        loadSurveys(existingProject, "#survey_name", false, false, undefined, false, undefined, undefined, false);			// Get surveys
    });

	$('#removeMedia').click(function() {
		var type;
		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gOptionList) {
			type = "option";
		} else {
			type = "question";
		}
		updateLabel(type, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSelOptionId, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gOptionList, gElement, undefined, gQname, "media");

	});

	setupQuestionTypes($('#dialog_types'), 2, false, undefined);		// Double column, not draggable for change type dialog
	setupQuestionTypes($('#toolbar_types'), 1, true, undefined);		// Single column, draggable for toolbar

	$('#openFormModal').on('shown.bs.modal', function () {
		$('#new_form_name').focus();
	});
	$('#openFormModal').on("keypress", function(event) {
		// Click the done button if the user presses enter
		if (event.key === "Enter") {
			event.preventDefault();
			$('#get_form').trigger("click");
		}
	});

	/*
	 * Toolbar
	 */
	$('.question_type_sel', '#toolbar_types').off().click(function(){
		var type = $(this).val(),
			$finalButton = $('.add_final_button', '#formList');
		addQuestion($finalButton, type);
	});

	/*
	 * Choice Editing
	 */
	$('#filterModalSave').off().click(function(){
		var survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
			question = survey.forms[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex].questions[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex];

		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].addFilter($('#filter_name').val());
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].addOptionTable(question, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gListName);
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].setupChoiceView($('#filterType').val());
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].addFilterSelectList(survey.filters);
		respondToEventsChoices($('#optionTable'));
	});

	$("#filterModal").on("shown.bs.modal", function() {
	    $("#filter_name").focus();
	});

	$('#content').on('shown.bs.collapse', function (e) {
		$('a[href="#' + e.target.id + '"]', '#content').find('.edit_icon').removeClass('fa-chevron-down').addClass('fa-chevron-up');
	});

	$('#content').on('hidden.bs.collapse', function (e) {
		$('a[href="#' + e.target.id + '"]', '#content').find('.edit_icon').removeClass('fa-chevron-up').addClass('fa-chevron-down');
	});

	// Respond to selection of medical parameter type
	$('#p_medical').change(function() {
		setLanguageCodes();
	});

	function setLanguageCodes() {
	var type = $('#p_source').find(':selected').data('type');
	var translateType;

	if($('#p_medical').prop("checked")) {
		$('.p_med_type').show();
		translateType = "transcribe_medical";
	} else {
		$('.p_med_type').hide();
		translateType = (type === "audio" || type === "video") ? "transcribe" : "translate";
	}

	_app_aws__WEBPACK_IMPORTED_MODULE_11__["default"].setLanguageSelect($('.parameter_lang'), translateType, setLanguageCodeVals);

	if(translateType === "transcribe" || translateType === "transcribe_medical") {
		$('.to_lang_override').hide();
		$('.p_medical, .p_med_type').show();
	} else {
		$('.to_lang_override').show();
		$('.p_medical, .p_med_type').hide();
	}

}

/*
 * Export the survey being currently edited
 */
	function exportSurvey() {
	window.location.href = "/surveyKPI/xlsForm/" + _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey + "?filetype=" + "xlsx" + addCacheBuster("?");
}

/*
 * Save a selected media file
 */
	function mediaSelectSave() {
	var type;

	if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gOptionList) {
		type = "option";
	} else {
		type = "question";
	}
	updateLabel(type, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSelOptionId, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gOptionList, gElement, gNewVal, gQname, "media");

	$('#mediaModal').modal('hide');
}
	function setLanguageCodeVals() {
	$('#to_lang').val(g_to_lang_val);
	$('#from_lang').val(g_from_lang_val);
}

/*
 * Set all the questions to either required or not required
 */
	function setAllRequired(required) {

	addHourglass();
	$.ajax({
		  type: "POST",
		  cache: false,
		  url: "/surveyKPI/surveys/set_required/" + _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey + "/" + (required ? "true" : "false"),
			success: function(data) {
				removeHourglass();
				getSurveyDetails(surveyDetailsDone);
				var msg = _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set['ed_qs'] + (required ? _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set['ed_req'] : _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set['ed_nreq']);
				_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(msg);
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
		              return;  // Not an error
				} else {
					var msg = "Error: Failed to set questions as " + (required ? "required" : "not required") + " " + xhr.responseText;
					alert(msg);
				}
			}
	});
}

//Set up question type dialog
	function setupQuestionTypes($elem, columns, draggable, currentType) {
	var i,j,
		tArray,
		types = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.qTypes,
		h = [],
		idx = -1,
		count,
		name;

	for(i = 0; i < types.length; i++) {

		if(types[i].canSelect && isCompatible(types[i].compatTypes, currentType) ) {

			name = _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set[types[i].trans];
			h[++idx] = '<div class="col-12 ';
			h[++idx] = columns === 1 ? '" ' : 'col-md-6" ';
			h[++idx] = ' style="height:65px;">';
			h[++idx] = '<button type="button" tabindex="-1" class="btn btn-large btn-light border border-primary question_type_sel full_width_btn';
			if(draggable) {
				h[++idx] = ' draggable';
			}
			h[++idx] = '" value="';
			h[++idx] = types[i].type;
			h[++idx] = '">';
			if(types[i].icon) {
				tArray = types[i].icon.split(',');
				for(j = 0; j < tArray.length; j++) {
					h[++idx] = '<i class="fas fa-';
					h[++idx] = tArray[j].trim();
					h[++idx] = ' edit_type_select"></i>';
				}
				h[++idx] = '<br/>';
			} else if(types[i].image) {
				h[++idx] = '<img class="edit_image_select" src="';
				h[++idx] = types[i].image;
				h[++idx] = '"></img><br/>';
			} else if(types[i].text) {
				h[++idx] = '<span class="edit_type_select">';
				h[++idx] = types[i].text;
				h[++idx] = '</span><br/>';
			}
			h[++idx] = name;
			h[++idx] = '</button>';
			h[++idx] = '</div>';		// End col


			//count++;
		}
	}

	$elem.html(h.join(''));

}

/*
 * return true if the current published type can be converted to the new type
 */
	function isCompatible(compatTypes, currentType) {
	var compatible = false;
	if(!currentType) {
		compatible = true;
	} else {
		if(compatTypes && compatTypes.indexOf(currentType) >= 0) {
			compatible = true;
		}
	}
	return compatible;
}

	function getSurveyList() {
	if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey > 0) {
		loadSurveys(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentProject, undefined, false, false, surveyListDone, false, undefined, false);
	} else {
		loadSurveys(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentProject, undefined, false, false, undefined, false, undefined, undefined, false);
	}
}


	function surveyListDone() {
	getSurveyDetails(surveyDetailsDone);
}

	function surveyDetailsDone() {
	// Get survey level files
	if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey) {
		getFilesFromServer(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCurrentSurvey, refreshMediaPickLists, true);   // Get all media
	}

	// Set the survey name
	$('.formName').text(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.displayName);
	$('#m_media').prop('href', '/app/resources.html?survey=true&survey_name=' + _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.displayName);

	$('#openFormModal').modal("hide");		// Hide the open form modal if its open

	// Get group questions for this current survey - used for selecting the source parameter
	getGroupQuestionsInSurvey($('.group_column_select'), _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.ident);

	/*
	 * Refresh the form
	 */
	if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gShowingChoices) {
		// skip the refresh of the choices as when the data was reloaded the item index may have changed hence we can't be guaranteed which question will be refreshed
		// Safer to return to the question view
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gShowingChoices = false;
		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].updateViewControls();

		$('.editorContent').toggle();
		$('.notoptionslist').show();
	}
	refreshForm();

	// Set up link to test file
	gSurveyUrl = "/app/myWork/webForm/" + _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.ident;
	gSurveyUrlCacheBuster = addCacheBuster(gSurveyUrl)

}

/*
 * Refresh any pick lists that use media
 */
	function refreshMediaPickLists(data) {
	var h = [],
		idx = -1,
		i,
		h2 = [],
		idx2 = -1;

	gFiles = data.files;	// Reference the data on selection of an item

	for(i = 0; i < data.files.length; i++) {
		var f = data.files[i];
		if(f.type === 'image' || f.type === 'video' || f.type === 'audio') {
			h[++idx] = '<div class="row mediaItem" data-idx="';
			h[++idx] = i;
			h[++idx] = '">';

			// Image
			h[++idx] = '<div class="col-sm">';
			h[++idx] = '<img height="100" width="100" src="';
			h[++idx] = htmlEncode(f.thumbnailUrl);
			h[++idx] = '" class="';
			h[++idx] = f.type;
			h[++idx] = '" alt="';
			h[++idx] = htmlEncode(f.name);
			h[++idx] = '">';
			h[++idx] = '</div>';

			// Name
			h[++idx] = '<div class="col-sm">';
			h[++idx] = '<p>';
			h[++idx] = htmlEncode(f.name);
			h[++idx] = '<p>';
			h[++idx] = '</div>';

			h[++idx] = '</div>';

			/*
			 * Create the choice list for the default logo
			 */
			h2[++idx2] = '<option value="';
			h2[++idx2] = f.name;
			h2[++idx2] = '">';
			h2[++idx2] = htmlEncode(f.name);
			h2[++idx2] = '</option>';
		}
	}

	$('#imageSelect').empty().html(h.join(''));
	$('#default_logo').empty().html(h2.join(''));

	$('#mediaSave').off().click(function() {
		var idx = $('.mediaItem.selected', '#imageSelect').data('idx');
		gNewVal = gFiles[idx].name;
		mediaSelectSave();
	});

	$('#mediaClear').off().click(function() {
		gNewVal = undefined;
		mediaSelectSave();
	});

	$('.mediaItem', '#imageSelect').off().on("click", function(e) {
		var $this = $(this);
		$('.mediaItem', '#imageSelect').removeClass('selected');
		$this.addClass('selected');
	});

	$('.mediaItem', '#imageSelect').on("dblclick", function(e) {
		gNewVal = gFiles[$(this).data('idx')].name;
		mediaSelectSave();
	});
}

/*
 * Show the form on the screen
 */
	function refreshForm() {

	var $context,
		survey,
		question;

	if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gShowingChoices) {
		survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey;
		if(typeof _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex !== "undefined") {
			question = survey.forms[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex].questions[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex];
		}
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].addOptionTable(question, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gListName);
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].setupChoiceView($('#filterType').val());
		respondToEventsChoices($('#optionTable'));
	} else {
		$context = _app_editorMarkup__WEBPACK_IMPORTED_MODULE_8__["default"].refresh();
		respondToEvents($context);
	}

	_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].validateAll();

}

/*
 * Refresh the featured properties part of the form
 */
	function refreshFeaturedProperties() {

	var $context,
		survey,
		question;

	if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gShowingChoices) {
		survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey;
		if(typeof _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex !== "undefined") {
			question = survey.forms[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex].questions[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex];
		}
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].addOptionTable(question, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gListName);
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].setupChoiceView($('#filterType').val());
		respondToEventsChoices($('#optionTable'));
	} else {
		$context = _app_editorMarkup__WEBPACK_IMPORTED_MODULE_8__["default"].refreshQuestionFeaturedProperties();
		respondToEvents($context);
	}

}

/*
 * The passed in context is for a list of choices
 */
	function respondToEventsChoices($context) {

	$('[type="checkbox"]', $context).iCheck({
	    checkboxClass: 'icheckbox_square-green',
	    radioClass: 'iradio_square-green'
	});

	$('.exitOptions', $context).off().click(function() {

		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gShowingChoices = false;
		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].updateViewControls();

		/*
		globals.gSelChoiceProperty = globals.gSelProperty;	// Restore selProperty and selLabel for questions
		globals.gSelProperty = globals.gSelQuestionProperty;
		globals.gSelChoiceLabel = globals.gSelLabel;
		globals.gSelLabel = globals.gSelQuestionLabel;
		$('#propSelected').html(globals.gSelLabel);
		*/

		$('.editorContent').toggle();
		$('.notoptionslist').show();
		refreshForm();
	});

	$('#addFilter', $context).off().click(function() {
		$('#filterModal').modal('show');
	});

	// Set option list value
	$context.find('.option-lists', $context).each(function(index){
		var $this = $(this),
			$elem = $this.closest('.question_head'),
			formIndex = $elem.data("fid"),
			itemIndex = $elem.data("id"),
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
			question;

		question = survey.forms[formIndex].questions[itemIndex];
		if(!optionListExists(question.list_name)) {
			if(!optionListExists(question.name)) {
				survey.optionLists[question.name] = {
						oSeq: [],
						options: []
					};
					_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].refreshOptionListControls();
			}
			$this.val(question.name);
		} else {
			$this.val(question.list_name);
		}

	});


	$('#filterType', $context).off().change(function() {
		var $this = $(this),
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
			question = survey.forms[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex].questions[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex],
			filterType = $this.val(),
			choiceFilter,
			proceed = true;

		choiceFilter = $('#choiceFilter').val();

		// Show an error and set the filter to none if the user chose cascade when there are no previous select questions
		if (filterType === "cascade" && $('#previousSelect option').length == 0) {
			alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_error"] + ": " + _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_prev_select"]);
			filterType = "none";
			$('#filterType').val(filterType);
		}

		if(filterType != "custom") {
			if(choiceFilter && choiceFilter.indexOf("_smap_cascade") < 0) {
				proceed = confirm(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_rep_f"] + ": " + choiceFilter + "?");
			}
		}

		if(proceed) {
			if(filterType === "cascade") {
				setCascadeFilter();
				_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].addFilter("_smap_cascade");  // Make sure _smap_cascade is in the list of filters
			} if(filterType === "none") {
				setNoFilter();
			}
		}

		if(filterType !== "none") {
			_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].addOptionTable(question, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gListName);
			respondToEventsChoices($('#optionTable'));
		}
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].setupChoiceView($this.val());


	});

	// Respond to columns of filters being hidden or made visible
	$('input', '#custom_filters').off().on('ifToggled', function(event) {
		var $this = $(this),
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
			setting = $this.is(':checked');

		survey.filters[$this.val()] = setting;
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].resetFilterColumns();

	});


	// Option list change
	$context.find('.option-lists').off().change(function(){
		var $this = $(this),
			$elem = $this.closest('.question_head'),
			formIndex = $elem.data("fid"),
			itemIndex = $elem.data("id");

		updateLabel("question", formIndex, itemIndex, undefined, "text", $this.val(), undefined, "list_name");
	});

	// Choice filter change
	$context.find('#choiceFilter').off().change(function(){
		var $this = $(this),
			$elem = $this.closest('.question_head'),
			formIndex = $elem.data("fid"),
			itemIndex = $elem.data("id");

		updateLabel("question", formIndex, itemIndex, undefined, "text", $this.val(), undefined, "choice_filter");
	});

	// Previous question for cascading select changes
	$context.find('#previousSelect').off().change(function(){
		var $this = $(this),
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
			question = survey.forms[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex].questions[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex];

		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].setPreviousChoices($this.val());
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].addOptionTable(question, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gListName);
		respondToEventsChoices($('#optionTable'));
	});

	// Previous choice for cascading select changes
	$context.find('#previousSelectChoice').off().change(function() {
		var $this = $(this),
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
			question = survey.forms[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex].questions[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex];

		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].addOptionTable(question, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gListName);
		respondToEventsChoices($('#optionTable'));
	});

	// Add tooltips
	//$context.find('.has_tt').tooltip();


	// Respond to clicks on a label text area
	$context.find('.labelProp').change(function() {

		var $this = $(this),
			$elem = $this.closest('tr'),
			formIndex = $elem.data("fid"),
			itemIndex = $elem.data("id"),
			newVal = $this.val(),
			optionList = $elem.data("list_name"),
			qname = $elem.data("qname");

		updateLabel("option", formIndex, itemIndex, optionList, "text", newVal, qname, "label");

	});

	// Fix issues with dragging and selecting text in text area or input when draggable is set
	// Mainly a problem with Firefox however in Chrome selecting text by dragging does not work
	// Refer: http://stackoverflow.com/questions/21680363/prevent-drag-event-to-interfere-with-input-elements-in-firefox-using-html5-drag
	$context.find('input, textarea').focusin(function() {
	$(this).closest('.draggable').prop("draggable", false);
	}).blur(function() {
        $(this).closest('.draggable').prop("draggable", true);
        console.log("blur");
    });

	// validate the option name
	$context.find('.oname').keyup(function(){

		var $this = $(this),
			$elem = $this.closest('tr'),
			formIndex = $elem.data("fid"),
			itemIndex = $elem.data("id"),
			listName = $elem.data("list_name"),
			newVal = $this.val();

		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].validateName(listName, itemIndex, newVal, "option", true);
		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].updateModelWithErrorStatus(listName, itemIndex, "option");		// Update model and DOM

	});


	// Update the option name
	$context.find('.oname').change(function(){

		var $this = $(this),
			$elem = $this.closest('tr'),
			listName = $elem.data("list_name"),
			itemIndex = $elem.data("id"),
			qname = $elem.data("qname"),
			newVal = $this.val();

		updateLabel("option", 0, itemIndex, listName, "text", newVal, "", "value") ;

	});

	// Update the option display name
	$context.find('.odisplayname').change(function(){

		var $this = $(this),
			$elem = $this.closest('tr'),
			listName = $elem.data("list_name"),
			itemIndex = $elem.data("id"),
			qname = $elem.data("qname"),
			newVal = $this.val();

		updateLabel("option", 0, itemIndex, listName, "text", newVal, "", "display_name") ;

	});


	// Update the filter values when a custom filter value is changed
	$context.find('.filter').change(function(){
		updateFilterValues($(this), false, undefined);
	});

	// Update the cascade filter values when a cascade filter value is checked
	$('tr'). find('.cascadeFilter').off().on('ifToggled', function(event) {
		var $this = $(this),
		survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey;

		updateFilterValues($(this), true, $this.is(':checked'));

	});

	// Add new option after
	$context.find('.add_option_after').off().click(function() {
		var $this = $(this).closest('.editor_element');
		addNewOption($this, "after");
	});

	// Add new option before
	$context.find('.add_option_before').off().click(function() {
		var $this = $(this).closest('.editor_element');
		addNewOption($this, "before");
	});

	// Add new option using the "Add New Choice" button
	$context.find('.add_option').off().click(function() {
		var $this = $(this);

		addNewOption($this, "end");

	});

	// Delete option
	$context.find('.delete_option').off().click(function() {
		var $this = $(this),
			$context,						// Updated Html
			index = $this.closest(".editor_element").data("id"),
			list_name = $this.closest(".editor_element").data("list_name");

		_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().confirm(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_del_c"], function(result) {
			if(result) {
				$context = _app_question__WEBPACK_IMPORTED_MODULE_6__["default"].deleteOption(index, list_name);
			}
		});


	});

	// Selected a media property
	$context.find('.mediaProp').off().click(function(){

		var $this = $(this);
		mediaPropSelected($this);

	});

	/*
	 * Enable drag and drop to move choices
	 *
	 * First add handlers for draggable components
	 */
	$('.draggable.option').prop('draggable', 'true')

	.off('dragstart')
	.on('dragstart', function(evt){
		var ev = evt.originalEvent,
			$elem = $(ev.target);

		ev.effectAllowed = "move";		// Only allow move, TODO copy
		gDragCounter = 0;


		ev.dataTransfer.setData("text", $elem.closest('li').data('id'));
		gDragSourceId = $elem.closest('tr').data('id');

		console.log("Draggable item id: " + $elem.closest('tr').data('id'));
		//$('.dropon.add_option').addClass("add_drop_button").removeClass("add_button");

		return true;
	})

	// clean up after drag
	.off('dragend')
	.on('dragend', function(evt){
		//$('.dropon.add_option').addClass("add_button").removeClass("add_drop_button").removeClass("over_drop_button");
		return false;
	})

	// Don't allow a draggable component to be dropped onto a text field in some other option
	.off('drop')
	.on('drop', function(evt){
		evt.originalEvent.preventDefault();
	});

	/*
	 * Handle drop on or dragging over a drop zone
	 */
	// Entering a drop zone
	$('.dropon.option')

	.off('dragenter')
	.on('dragenter', function(evt){
		var ev = evt.originalEvent,
			$elem = $(ev.target),
			targetId = $elem.closest('tr').data('id'),
			btnId = $elem.data('id');

		$('tr', '#choiceView').removeClass("over_drop_elem");
		if(typeof(targetId) !== "undefined" && targetId != gDragSourceId) {
			ev.preventDefault();
			$elem.closest('tr').addClass("over_drop_elem");
		} else if(typeof(btnId) !== "undefined" && btnId == -1) {
			ev.preventDefault();
			$elem.addClass("over_drop_button").removeClass("add_button");
		}

	})

	// Leaving a drop zone
	.off('dragleave')
	.on('dragleave', function(evt){

		var ev = evt.originalEvent,
			$elem = $(ev.target),
			targetId = $elem.closest('tr').data('id'),
			btnId = $elem.data('id');

		if(typeof(btnId) !== "undefined" && btnId == -1) {
			$elem.addClass("add_button").removeClass("over_drop_button");
		} else if(typeof(targetId) === "undefined") {
			$('tr', '#choiceView').removeClass("over_drop_elem");
		}


	})

	.off('dragover')
	.on('dragover', function(evt){
		evt.originalEvent.dataTransfer.dropEffect = "move";
		evt.originalEvent.preventDefault();
		evt.originalEvent.stopPropagation();
	})

	// Drop the option
	.off('drop')
	.on('drop', function(evt){
		var ev = evt.originalEvent,
			$elem = $(ev.target),
			$targetElem = $elem.closest('tr'),
			$sourceElem,
			sourceId = gDragSourceId,
			targetId = $targetElem.data('id'),
			btnId = $elem.data('id'),
			listName = $targetElem.data('list_name'),
			$context,
			$elemBeforeTarget = $targetElem.prev('tr'),
			elemBeforeTargetId = $elemBeforeTarget.data('id'),
			$choiceBeforeButton = $("tr", "#choiceView").last();

		ev.preventDefault();
		ev.stopPropagation();


		$('tr', '#choiceView').removeClass("over_drop_elem");
		if(sourceId === targetId || sourceId === elemBeforeTargetId) {
			// Dropped on itself do not move
		} else {

			if(btnId === -1) {
				// Dropped on final add choice button
				targetId = $choiceBeforeButton.data('id');
				listName = $choiceBeforeButton.data('list_name')
				$context = _app_question__WEBPACK_IMPORTED_MODULE_6__["default"].moveBeforeOption(listName, sourceId, listName, targetId, "after");
			} else {
				$context = _app_question__WEBPACK_IMPORTED_MODULE_6__["default"].moveBeforeOption(listName, sourceId, listName, targetId, "before");
			}
			respondToEventsChoices($context);			// Add events on to the altered html
		}
	});
}

/*
 * Add a new option
 */
	function addNewOption($elem, locn) {
	var oId =  $elem.data("id"),
		fId =  $elem.data("fid"),
		qname = $elem.data("qname"),
		list_name = $elem.data("list_name");


	var $context = _app_question__WEBPACK_IMPORTED_MODULE_6__["default"].addOption(oId, locn, list_name, fId, qname);

	respondToEventsChoices($context);				// Add events on to the altered html

	// Set focus to the new option
	$context.find('textarea').focus();			// Set focus to the new option
}

/*
 * The passed in context is for a list item containing either a question or an option
 */
	function respondToEvents($context) {

	// Open choices for editing
	$('.edit_choice', $context).off().click(function(index){
		var $this = $(this),
			$li = $this.closest('li'),
			$context,
			survey,
			question;

		// Set global variables that will be used if the contents of this dialog are refreshed
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gListName = $li.data("list_name");
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex = $li.data("fid");
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex = $li.data("id");
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gShowingChoices = true;

		$context = _app_option__WEBPACK_IMPORTED_MODULE_10__["default"].createChoiceView();

		// Set the previous choices list box
		var prevListName = $('#previousSelect').val();
		if(prevListName) {
			_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].setPreviousChoices(prevListName);
		}

		// Show the table of options
		if(typeof _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex !== "undefined" && typeof _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex !== undefined) {
			// opened from question
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
			question = survey.forms[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex].questions[_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex];
		}

		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].addOptionTable(question, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex, _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gListName);
		_app_option__WEBPACK_IMPORTED_MODULE_10__["default"].setupChoiceView($('#filterType').val());

		respondToEventsChoices($context);
		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].updateViewControls();

		$('.editorContent').toggle();
		$('.notoptionslist').hide();
	});

	// Repeat count change
	$context.find('.repeat-counts').change(function(){
		var $this = $(this),
			$elem = $this.closest('li'),
			formIndex = $elem.data("fid"),
			itemIndex = $elem.data("id"),
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
			question;

		updateLabel("question", formIndex, itemIndex, undefined, "text", $this.val(), undefined, "calculation") ;
	});

	// Add tooltips
	//$context.find('.has_tt').tooltip();

	// Respond to changes in the label field - this would change the property that has focus
	$context.find('.labelButton').off().click(function() {

		var $this = $(this),
			prop = $this.data("prop"),
			$li = $this.closest('li'),
			formIndex = $li.data("fid"),
			itemIndex = $li.data("id"),
			newVal,
			type,
			optionList = $li.data("list_name"),
			qname = $li.data("qname"),
			labelType,
			linkedQuestionId = 0;

		if($li.hasClass("option")) {
			type = "option";
		} else {
			type = "question";
		}

		labelType = prop === "hint" ? "hint" : "text";
		if(prop === "required") {
			newVal = $this.hasClass("prop_no");		// If set false then newVal will be true
		} else if (prop === "autoplay") {
			newVal = $this.val();
		} else if (prop === "linked_target") {
			if($this.hasClass("prop_no")) {
				linkedQuestionId = $this.closest('.row').find(".linkedQuestion").val();
				if(!linkedQuestionId) {
					linkedQuestionId = 0;		// HRK
				}
				newVal = $this.closest('.row').find(".linkedSurvey").val() + "::" +
					linkedQuestionId;
			} else {
				newVal = undefined;
			}
		} else if(prop === "readonly") {
			newVal = $this.hasClass("prop_no");		// If set false then newVal will be true
		}
		updateLabel(type, formIndex, itemIndex, optionList, labelType, newVal, qname, prop);

	});

	// Respond to a click on the parameter button
	$context.find('.parameterButton').off().click(function() {

		var $this = $(this),
			$li = $this.closest('li'),
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey;

		var formIndex = $li.data("fid");
		var itemIndex = $li.data("id");
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex = formIndex;
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex = itemIndex;

		var qType = survey.forms[formIndex].questions[itemIndex].type;
		var qName = survey.forms[formIndex].questions[itemIndex].name;
		gQname = qName;
		var qParams = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.qParams[qType];
		var paramDetails;
		var paramArray = [];

		var paramData = $li.find('.labelProp').val();
		var otherParams = '';
		var i, j;
		var foundParam;

		if(paramData) {
			paramArray = paramData.split(';');
			if(paramArray.length == 0) {
				paramArray = paramData.split(' ');
			}
		}

		/*
         * Add a question select list
         */
		var sIdent = "0";
		if(qType === "parent_form") {
			$('#p_key_question_label').html(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_qk"]);
			$('#p_key_question').empty().append(getQuestionsAsSelect("", true));
		} else if (qType === "child_form") {
			$('#p_key_question_label').html(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_qkc"]);
			// Get the form ident
			for (i = 0; i < paramArray.length; i++) {
				var p = paramArray[i].split('=');
				if (p.length > 1) {
					if (p[0].trim() === 'form_identifier') {
						sIdent = p[1].trim();
						break;
					}
				}
			}
			getQuestionsInSurvey($('#p_key_question'), undefined,  sIdent, true, true, undefined, true);
		} else if(qType === "begin repeat") {
			$('#p_ref').empty().append(getFormsAsSelect(qName));
		}

		/*
         * Show any parameter attributes for this question type
         */
		$('#parameter_form')[0].reset();
		$('.parameter_field').hide();
		if(qParams && qParams.length > 0) {
			for (j = 0; j < qParams.length; j++) {
				paramDetails = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.paramDetails[qParams[j]];
				$('.' + paramDetails.field).show();
			}
		}

		g_to_lang_val = undefined;
		g_from_lang_val = undefined;
		for (i = 0; i < paramArray.length; i++) {

			var p = paramArray[i].split('=');
			if (p.length > 1) {
				if(p[0] === "to_lang") {
					g_to_lang_val = p[1];
				} else if(p[0] === "from_lang") {
					g_from_lang_val = p[1];
				}

				foundParam = false;
				if(qParams && qParams.length > 0) {

					for (j = 0; j < qParams.length; j++) {
						paramDetails = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.paramDetails[qParams[j]];

						if (p[0].trim() === qParams[j]) {
							foundParam = true;
							setParam($('#' + paramDetails.field), p[1].trim(), paramDetails.type);
							break;
						}
					}
				}

				if(!foundParam) {
					if (otherParams.length > 0) {
						otherParams += '; ';
					}
					otherParams += p[0].trim() + '=' + p[1].trim();
				}
			}
		}

		// Add any parameter values not explicetely set
		$('#p_other').val(otherParams);       // Not sure if we want to do this

		setLanguageCodes();     // Do this last as it is dependent on the source question type

		$('#parameterModal').modal({
			keyboard: true,
			backdrop: 'static',
			show: true
		});

	});

	// Respond to a click on the appearance button
	$context.find('.appearanceButton').off().click(function() {

		var $this = $(this),
			$li = $this.closest('li'),
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey;

		var formIndex = $li.data("fid");
		var itemIndex = $li.data("id");
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex = formIndex;
		_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex = itemIndex;

		var question = survey.forms[formIndex].questions[itemIndex];
		var qType = question.type;
		var qName = question.name;
		gQname = qName;
		gQType = qType;
		var qAppearances = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.qAppearances[qType];
		var appearanceDetails;
		var appearanceArray = [];

		var appearanceData = $li.find('.labelProp').val();

		var otherAppearances = '';
		var i, j;
		var foundAppearance;

		if(appearanceData) {
			appearanceArray = tokenizeAppearance(appearanceData);
		}

		/*
         * Show any appearance attributes for this question type
         */
		$('#appearance_form')[0].reset();
		$('#appearance_search_form')[0].reset();
		$('#appearance_pdf_form')[0].reset();
		$('input','.colorpicker-component').colorpicker('setValue', '#ffffff');
		$('.appearance_field, .appearance_search_details').hide();
		$('.pdf_appearance_field').show();
		$('.pdfcols').hide();
		$('#standardTab a').click();
		$('#a_pdfaddto').empty().append(getQuestionsAsSelect("", false));
		if(qType === 'image') {
			$('.a_pdfhyperlink').show();
		} else {
			$('.a_pdfhyperlink').hide();
		}
		$('.pdf_custom_map').hide();

		/*
		 * Show form controls relevant for this question type
		 */
		if(qAppearances && qAppearances.length > 0) {
			for (j = 0; j < qAppearances.length; j++) {
				appearanceDetails = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.appearanceDetails[qAppearances[j]];
				if(qAppearances[j] === 'w') {
					if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.surveyClass === "theme-grid") {
						$('.' + appearanceDetails.field).show(); // Only show width if style is for grid
					}
				} else {
					$('.' + appearanceDetails.field).show();
				}
			}
		}

		// Get questions to select from this survey
		$('.questions_in_form').empty().append(getQuestionsAsSelect(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_question"] + "...", false));

		// Add value and label(s) from choices list or they may already be specified as temporary appearance values
		addLabelControls();


		for (i = 0; i < appearanceArray.length; i++) {
			foundAppearance = false;

			/*
			 * Add appearances specific to this questions
			 */
			if (qAppearances && qAppearances.length > 0) {
				for (j = 0; j < qAppearances.length; j++) {
					appearanceDetails = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.appearanceDetails[qAppearances[j]];

					var m = appearanceArray[i].match(appearanceDetails.rex);
					if (m) {
						if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.surveyClass === "theme-grid" || qAppearances[j] !== 'w') {
							foundAppearance = true;
							var val = m[0].substring(appearanceDetails.value_offset);
							setAppearance($('#' + appearanceDetails.field), val, appearanceDetails.type, appearanceArray[i], question, survey);
							break;
						}
					}
				}
			}

			/*
			 * Check for common appearances that are set on every question type
			 */
			var pdfa;
			var colour;
			if(appearanceArray[i] === 'hidden') {
				$('#a_hidden').prop('checked', true);
				foundAppearance = true;
			} else if(appearanceArray[i] === 'pdfno') {
				$('#a_pdfno').prop('checked', true);
				$('.pdf_appearance_field').hide();
				foundAppearance = true;
			} else if(appearanceArray[i].indexOf('pdflabelw_') === 0) {
				pdfa = appearanceArray[i].split('_');
				if(pdfa.length > 1) {
					$('#a_pdf_lw').val(pdfa[1]);
					foundAppearance = true;
				}
			} else if(appearanceArray[i].indexOf('pdfheight_') === 0) {
				pdfa = appearanceArray[i].split('_');
				if(pdfa.length > 1) {
					$('#a_pdfheight').val(pdfa[1]);
					foundAppearance = true;
				}
			} else if(appearanceArray[i].indexOf('pdflabelbg_') === 0) {
				pdfa = appearanceArray[i].split('_');
				foundAppearance = true;
				if(pdfa.length > 1) {
					colour = '#' + pdfa[1];
				}
				if(pdfa.length > 2) {
					colour += pdfa[2];
				}
				if(pdfa.length > 3) {
					colour += pdfa[3];
				}
				$('#a_pdflabelbg').colorpicker('setValue', colour);
			}  else if(appearanceArray[i].indexOf('pdfvaluebg_') === 0) {
				pdfa = appearanceArray[i].split('_');
				foundAppearance = true;
				if(pdfa.length > 1) {
					colour = '#' + pdfa[1];
				}
				if(pdfa.length > 2) {
					colour += pdfa[2];
				}
				if(pdfa.length > 3) {
					colour += pdfa[3];
				}
				$('#a_pdfvaluebg').colorpicker('setValue', colour);

			} else if(appearanceArray[i].indexOf('pdfmarkercolor_') === 0) {
				pdfa = appearanceArray[i].split('_');
				foundAppearance = true;
				if(pdfa.length > 1) {
					colour = '#' + pdfa[1];
				}
				if(pdfa.length > 2) {
					colour += pdfa[2];
				}
				if(pdfa.length > 3) {
					colour += pdfa[3];
				}
				$('#a_pdfmarkercolor').colorpicker('setValue', colour);

			} else if(appearanceArray[i].indexOf('pdfspace_') === 0) {
				pdfa = appearanceArray[i].split('_');
				if(pdfa.length > 1) {
					$('#a_pdfspace').val(pdfa[1]);
					foundAppearance = true;
				}

			} else if(appearanceArray[i].indexOf('pdfzoom_') === 0) {
				pdfa = appearanceArray[i].split('_');
				if(pdfa.length > 1) {
					$('#a_pdfzoom').val(pdfa[1]);
					foundAppearance = true;
				}

			} else if(appearanceArray[i].indexOf('pdfround_') === 0) {
				pdfa = appearanceArray[i].split('_');
				if(pdfa.length > 1) {
					$('#a_pdfround').val(pdfa[1]);
					foundAppearance = true;
				}

			} else if(appearanceArray[i] === 'pdfnewpage') {
				$('#a_pdfnewpage').prop('checked', true);
				foundAppearance = true;

			} else if(appearanceArray[i] === 'pdflabelcaps') {
				$('#a_pdflabelcaps').prop('checked', true);
				foundAppearance = true;
			} else if(appearanceArray[i] === 'pdflabelbold') {
				$('#a_pdflabelbold').prop('checked', true);
				foundAppearance = true;
			} else if(appearanceArray[i] === 'pdfapp') {
				$('#a_pdfapp').prop('checked', true);
				foundAppearance = true;
			} else if(appearanceArray[i] === 'pdfbarcode') {
				$('#a_pdfbarcode').prop('checked', true);
				foundAppearance = true;
			} else if(appearanceArray[i] === 'pdfshowimage') {
				$('#a_pdfshowimage').prop('checked', true);
				foundAppearance = true;
			} else if(appearanceArray[i] === 'pdfstretch') {
				$('#a_pdfstretch').prop('checked', true);
				foundAppearance = true;
			} else if(appearanceArray[i] === 'pdfhyperlink') {
				$('#a_pdfhyperlink').prop('checked', true);
				foundAppearance = true;
			} else if(appearanceArray[i].indexOf('pdfcols_') === 0) {
				pdfa = appearanceArray[i].split('_');
				foundAppearance = true;
				if(pdfa.length > 1) {
					$('.pdfcols').hide();
					$('#a_pdfcols_number').val(pdfa.length - 1);
					for (j = 1; j <= pdfa.length - 1; j++) {
						$('#a_pdfcols_' + j + '_l').html(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_col_width"].replace('%s1', j));
						$('#a_pdfcols_' + j).val(pdfa[j])
						$('.pdfcols' + j).show();
					}
				}
			} else if(appearanceArray[i].indexOf('pdfaddto_') === 0) {
				pdfa = appearanceArray[i].split('_');
				if(pdfa.length > 1) {
					$('#a_pdfaddto').val(pdfa[1]);
					foundAppearance = true;
				}
			} else if(appearanceArray[i].indexOf('pdfmapsource_') === 0) {
				pdfa = appearanceArray[i].split('_');
				if(pdfa.length > 1) {
					$('#a_pdfmapsource').val(pdfa[1]);
					foundAppearance = true;
				}
			} else if(appearanceArray[i].indexOf('pdfmap_') === 0) {
				pdfa = appearanceArray[i].split('_');
				if(pdfa.length > 1) {
					$('#a_pdfmap').val(pdfa[1]);
					if(pdfa[1] === 'custom') {
						$('.pdf_custom_map').show();
					}
					foundAppearance = true;
				}
			} else if(appearanceArray[i].indexOf('pdfcustommap_') === 0) {
				pdfa = appearanceArray[i].split('_');
				if(pdfa.length > 1) {
					$('#a_pdfcustommap').val(pdfa[1]);
					foundAppearance = true;
				}
			} else if(appearanceArray[i].indexOf('pdfaccount_') === 0) {
				pdfa = appearanceArray[i].split('_');
				if(pdfa.length > 1) {
					$('#a_pdfaccount').val(pdfa[1]);
					foundAppearance = true;
				}
			}

			/*
			 * Add other
			 */
			if (!foundAppearance) {
				if (otherAppearances.length > 0) {
					otherAppearances += ' ';
				}
				otherAppearances += appearanceArray[i];
			}
		}

		// Add any appearance values not explicitly set
		$('#a_other').val(otherAppearances);       // Not sure if we want to do this

		$('#appearance_msg').hide();
		$('#appearanceModal').modal({
			keyboard: true,
			backdrop: 'static',
			show: true
		});

		/*
		 * Store the dialogs choice values so we know if these change
		 * THis is a heck since choice values associated with a search are not appearances themselves
		 */
		window.gAppChoiceArray = [];
		getDummyChoiceAppearances(window.gAppChoiceArray)

	});


	// Respond to changes on linkedTarget (Survey or Question changed)
	$context.find('.linkedTarget').off().change(function() {

		var $this = $(this),
			prop = $this.data("prop"),
			$li = $this.closest('li'),
			formIndex = $li.data("fid"),
			itemIndex = $li.data("id"),
			newVal,
			type,
			optionList = $li.data("list_name"),
			qname = $li.data("qname"),
			labelType,
			linkedQuestionId;

		type = "question";
		labelType = "text";

		linkedQuestionId = $this.closest('.row').find(".linkedQuestion").val();
		if(!linkedQuestionId) {
			linkedQuestionId = 0;		// HRK
		}
		newVal = $this.closest('.row').find(".linkedSurvey").val() + "::" + linkedQuestionId;
		updateLabel(type, formIndex, itemIndex, optionList, labelType, newVal, qname, prop);


	});

	// Respond to clicks on a label text area
	$context.find('.labelProp').change(function(){

		var $this = $(this),
			prop = $this.data("prop"),
			$li = $this.closest('li'),
			formIndex = $li.data("fid"),
			itemIndex = $li.data("id"),
			newVal = $this.val(),
			type,
			optionList = $li.data("list_name"),
			qname = $li.data("qname");

		var labelType;
		if(prop === "hint") {
			labelType = "hint";
		} else if(prop === "constraint_msg") {
			labelType = "constraint_msg";
		} else if(prop === "required_msg") {
			labelType = "required_msg";
		} else if(prop === "guidance_hint") {
			labelType = "guidance_hint";
		} else {
			labelType = "text";
		}
		updateLabel("question", formIndex, itemIndex, optionList, labelType, newVal, qname, prop);

	});

	// validate the name on focus as duplicates may have been removed elsewhere
	$context.find('.qname').focusin(function(){

		var $this = $(this),
			$li = $this.closest('li'),
			formIndex = $li.data("fid"),
			itemIndex = $li.data("id");

		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].validateItem(formIndex, itemIndex, "question", true);

	});

	// Fix issues with dragging and selecting text in text area or input when draggable is set
	// Mainly a problem with Firefox however in Chrome selecting text by dragging does not work
	// Refer: http://stackoverflow.com/questions/21680363/prevent-drag-event-to-interfere-with-input-elements-in-firefox-using-html5-drag
	$context.find('input, textarea').focusin(function() {
		$(this).closest('.draggable').prop("draggable", false);
	}).blur(function() {
        $(this).closest('.draggable').prop("draggable", true);
        console.log("blur");
    });

	// On tab in question name move to the feature input
	//$context.find('.qname').keydown(function(e){
	//	if(e.keyCode === 9 && ! e.shiftKey) {
	//		e.preventDefault();
	//		$(this).closest('.row').find('.labelProp').focus();
	//	}
	//});


	// validate the question name on every character change
	$context.find('.qname').keyup(function() {

		var $this = $(this),
			$li = $this.closest('li'),
			formIndex = $li.data("fid"),
			itemIndex = $li.data("id"),
			newVal = $this.val();

		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].validateName(formIndex, itemIndex, newVal, "question", true);
		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].updateModelWithErrorStatus(formIndex, itemIndex, "question");		// Update model and DOM

	});

	// Update the question name
	$context.find('.qname').change(function(){

		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSaveInProgress) {
			return;
		}

		var $this = $(this),
			$li = $this.closest('li'),
			formIndex = $li.data("fid"),
			itemIndex = $li.data("id"),
			newVal = $this.val();

		updateLabel("question", formIndex, itemIndex, undefined, "text", newVal, undefined, "name") ;

	});

	// Selected a media property
	$context.find('.mediaProp').off().click(function(){

		var $this = $(this);
		mediaPropSelected($this);

	});

	/*
	 * Add a new question
	 *  (or if the property type is groups then extend a group to the selected location)
	 */
	$context.find('.add_question').off().click(function() {
		var $this = $(this);

		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSaveInProgress) {
			return;
		}

		addQuestion($this, "string");


	});

	/*
	 * Add a new choice list
	 */
	$context.find('.add_option_list').off().click(function() {
		var $this = $(this),
			$context,
			justAddedId,
			val;

		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSaveInProgress) {
			return;
		}

		console.log("adding choices list");
		$context = _app_optionlist__WEBPACK_IMPORTED_MODULE_7__["default"].add();
		respondToEvents($context);

		// Set focus to the new option list
		var justAddedID = '#ol_' + _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gLatestOptionList;
		var $input = $('input', justAddedID);
		val = $input.val();
		$input.val("").focus().val(val);		// Set text entry to end of text field

	});

	// Delete question
	$context.find('.delete_question').off().click(function() {
		var $this = $(this),
			$context,						// Updated Html
			item = $(this).data("id");

		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSaveInProgress) {
			return;
		}

		_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().confirm(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_del_q"], function(result) {
			if(result) {
				_app_question__WEBPACK_IMPORTED_MODULE_6__["default"].deleteQuestion(item);
			}
		});

	});

	// Get linked questions
	$context.find('.linkedSurvey').change(function() {
		var $this = $(this),
			$li = $this.closest('li'),
			item = $li.prop("id"),
			surveyId = $this.val();

		_app_editorMarkup__WEBPACK_IMPORTED_MODULE_8__["default"].getLinkedQuestions(item, surveyId, 0);

	});

	// validate the optionlist name
	$context.find('.olname').keyup(function(){

		var $this = $(this),
			$elem = $this.closest('.question'),
			itemIndex = $elem.prop("id"),
			listName = $elem.data("list_name"),
			newVal = $this.val();

		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].validateName(listName, itemIndex, newVal, "optionlist", true);
		_app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].updateModelWithErrorStatus(listName, itemIndex, "optionlist");		// Update model and DOM

	});

	// Update the option list name
	$context.find('.olname').change(function(){

		var $this = $(this),
			$li = $this.closest('.question'),
			oldVal = $li.data("list_name"),
			newVal = $this.val();

		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSaveInProgress) {
			return;
		}

		// Only apply the update if there is no error on this option list
		if(!$li.hasClass("error")) {
			$li.data("list_name", newVal);	// First update the HTML
			//$('button.add_option',$li).data("list_name", newVal).removeClass('l_' + oldVal)
			//	.addClass('l_' + newVal);
			updateLabel("optionlist", undefined, undefined, undefined, "text", newVal, oldVal, "name") ;
		}

	});

	// Delete option list
	$context.find('.delete_ol').off().click(function() {
		var $this = $(this),
			$context,						// Updated Html
			item = $(this).data("id");

		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSaveInProgress) {
			return;
		}

		_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().confirm(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_del_cl"], function(result) {
			if(result) {
				$context = _app_optionlist__WEBPACK_IMPORTED_MODULE_7__["default"].deleteList(item);
				respondToEvents($context);		// The entire view is refreshed after deleting an option list
			}
		});

	});

	// Select types
	$context.find('.question_type').off().click(function() {

		var $this = $(this),
			$questionElement = $this.closest('li'),
			published,
			saved,
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
			name,
			formIndex,
			itemIndex,
			i;

		if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSaveInProgress) {
			return;
		}

		formIndex = $questionElement.data("fid");
		itemIndex = $questionElement.data("id");

		published = survey.forms[formIndex].questions[itemIndex].published;
		saved = (survey.forms[formIndex].questions[itemIndex].published > 0);
		if($this.hasClass("disabled")) {
			alert("You cannot change the type of a question that has an invalid name");
		} else {
			if(published) {
                setupQuestionTypes($('#dialog_types'), 1, false, survey.forms[formIndex].questions[itemIndex].type);
			} else {
                setupQuestionTypes($('#dialog_types'), 2, false, undefined);
			}
			$('.question_type_sel', '#dialog_types').off().click(function(){
				var type = $(this).val();

				updateLabel("question", formIndex, itemIndex, undefined, "text", type, undefined, "type");
				$('#typeModal').modal('hide');

				// Add an end group question if a new group has been created
				if(type === "begin group") {

                    // If the group was originally a begin repeat then it may not be empty
                    var seq = _app_question__WEBPACK_IMPORTED_MODULE_6__["default"].getSequenceQuestion(itemIndex, survey.forms[formIndex], false, undefined);
                    var endGroupSeq = seq;
                    for(i = seq + 1; i < survey.forms[formIndex].qSeq.length; i++) {
                        if(survey.forms[formIndex].questions[survey.forms[formIndex].qSeq[i]].memberGroup === survey.forms[formIndex].questions[itemIndex].name) {
                            endGroupSeq++;
                        } else {
                        	break;
						}
                    }

					name = survey.forms[formIndex].questions[itemIndex].name + "_groupEnd" ;
					$context = _app_question__WEBPACK_IMPORTED_MODULE_6__["default"].add(formIndex,
							//$questionElement.attr("id"),
                        	"question" + formIndex + "_" + survey.forms[formIndex].qSeq[endGroupSeq],
							"after",
							"end group",
							name);
					respondToEvents($context);
				}
			});

			$('#typeModal').modal({
					keyboard: true,
					backdrop: 'static',
					show: true
			});
		}

	});


	/*
	 * Enable drag and drop to move questions and choices
	 *
	 * First add handlers for draggable components
	 */
	$('.draggable').prop('draggable', 'true')

	.off('dragstart')
	.on('dragstart', function(evt){
		var ev = evt.originalEvent;

		ev.effectAllowed = "move";		// Only allow move, TODO copy

		if(typeof ev.target.value !== "undefined" && ev.target.value.length > 0) {
			ev.dataTransfer.setData("type", ev.target.value);
		} else {
			if(ev.target.id === "") {	// Moving an option
				ev.dataTransfer.setData("list_name", ev.target.dataset.list_name);
				ev.dataTransfer.setData("index", ev.target.dataset.id);
			} else {	// Moving a question
				ev.dataTransfer.setData("text/plain", ev.target.id);
			}
		}
		$('.dropon.add_question').addClass("add_drop_button").removeClass("add_button");

		return true;
	})

	// clean up after drag
	.off('dragend')
	.on('dragend', function(evt){
		$('.dropon.add_question').addClass("add_button").removeClass("add_drop_button").removeClass("over_drop_button");
		return false;
	})

	// Don't allow a draggable component to be dropped onto a text field in some other question / option
	.off('drop')
	.on('drop', function(evt){
		evt.originalEvent.preventDefault();
	});


	/*
	 * Handle drop on or dragging over a drop zone
	 */

	// Entering a drop zone
	$('.dropon.add_question')

	.off('dragenter')
	.on('dragenter', function(evt){
		var ev = evt.originalEvent,
			$elem = $(ev.target),
			targetId = $elem.data('qid');

		$elem.addClass("over_drop_button").removeClass("add_button").addClass("add_drop_button");

	})

	// Leaving a drop zone
	.off('dragleave')
	.on('dragleave', function(evt){

		var ev = evt.originalEvent,
			$elem = $(ev.target),
			sourceId = ev.dataTransfer.getData("text/plain"),
			targetId = $elem.data('qid');

		$elem.addClass("add_button").removeClass("over_drop_button").addClass("add_drop_button");


	})

	.off('dragover')
	.on('dragover', function(evt){
		evt.originalEvent.dataTransfer.dropEffect = "move";
		evt.originalEvent.preventDefault();
		evt.originalEvent.stopPropagation();
	})

	// Drop the question or type
	.off('drop')
	.on('drop', function(evt){
		var ev = evt.originalEvent,
			$targetListItem = $(ev.target),
			$sourceElem,
			sourceId = ev.dataTransfer.getData("text/plain"),
			sourceValue = ev.dataTransfer.getData("type"),		// The type of a new question that is being dropped
			sourceListName = ev.dataTransfer.getData("list_name"),
			sourceItemIndex = ev.dataTransfer.getData("index"),
			targetId = $targetListItem.data('qid'),
			formIndex,
			locn = $targetListItem.data("locn"),			// Before or after the target question
			targetListName,									// For option
			targetItemIndex,								// For option
			sourceListName,									// For option
			sourceItemIndex,								// For option
			$context,
			$related,
			$li,
			type,											// Question or option
			dropType = false;								// Set true if a question type is being dropped

		ev.preventDefault();
		ev.stopPropagation();

		if(typeof sourceValue !== "undefined" && sourceValue.length > 0) {		// Dropped a new type - Question only
			type = "question";
			dropType = true;
			addQuestion($targetListItem, sourceValue);
		} else {

			if($targetListItem.hasClass('add_question')) {
				type = "question";

				formIndex = $targetListItem.data("findex");
				$li = $targetListItem.closest('li');
				if(locn === "after") {
					$related = $li.prev();
				} else {
					$related = $li.next();
				}
				if($related.length === 0) {   // Empty group, location is "after"
					targetId = $li.parent().closest('li').attr("id");
				} else {
					targetId = $related.attr("id");
				}

				if(sourceId != targetId) {

					console.log("Dropped: " + sourceId + " : " + targetId + " : " + sourceValue);

					$context = _app_question__WEBPACK_IMPORTED_MODULE_6__["default"].moveQuestion(formIndex, sourceId, targetId, locn);
					respondToEvents($context);						// Add events on to the altered html
				}
			}
		}
	});

	// Select text inside text area on tab - from: https://stackoverflow.com/questions/5797539/jquery-select-all-text-from-a-textarea
	$("textarea").focus(function() {
		var $this = $(this);
		$this.select();

		$this.mouseup(function () {
			$this.unbind("mouseup");
			return false;
		});
	});
}

/*
 * End of drag and drop
 */

	function mediaPropSelected($this) {

	var $elem = $this.closest('li');

	if(!$elem.hasClass("question")) {
		$elem = $this.closest('tr');
	}
	// Set up media view
	gElement = $this.data("element");
	_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex = $elem.data("fid");
	_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gSelOptionId = $elem.data("id");
	_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gOptionList = $elem.data("list_name"); 		// Option list only used with choices which are in a table
	gQname = $elem.data("qname");
	$gCurrentRow = $elem;

	$('#mediaModalLabel').html(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set['msg_sel_media_f']);

	// Only show relevant media
	$('tr.' + gElement, '#surveyPanel, #orgPanel').show();

	// On double click save and exit
	$('#mediaModal table').off().on('dblclick', 'tbody tr', function(e) {
		var $sel = $(this);

	    gNewVal = $sel.find('.filename').text();
	    mediaSelectSave();
	});

	// If the user clicks on "Add" save and exit

	$('.mediaAdd').off().on('click', function(e) {
		var $sel = $(this).closest('tr');

	    gNewVal = $sel.find('.filename').text();
	    mediaSelectSave();
	});

	$('.upload_file_msg').removeClass('alert-danger').addClass('alert-success').html("");
	$('#mediaModal').modal('show');

}

/*
 * Add a new question after an add new question button identified by $this is selected
 */
	function addQuestion($this, type) {
	var $context,						// Updated HTML
		survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
		prop = $('#selProperty').val(),
		qId,
		$related,
		$li,
		formIndex = $this.data("findex"),
		itemIndex,
		forms,
		justAddedQuestionId,
		availableGroups,
		$textArea,
		textAreaVal,
		locn = $this.data("locn");	// Add before or after the element id referenced by qIdx

	if(!survey) {
		alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_ns"]);
	} else {
		forms = survey.forms;

		$li = $this.closest('li');
		if(locn === "after") {
			$related = $li.prev();
		} else {
			$related = $li.next();
		}
		if($related.length === 0) {   // Empty group, location is "after"
			qId = $li.parent().closest('li').attr("id");
		} else {
			qId = $related.attr("id");
		}

		if(prop === "group") {		// Extend a group
			availableGroups = $this.data("groups").split(":");
			$context = _app_question__WEBPACK_IMPORTED_MODULE_6__["default"].setGroupEnd(formIndex, qId, locn ,undefined, undefined, availableGroups);
		} else {
			$context = _app_question__WEBPACK_IMPORTED_MODULE_6__["default"].add(formIndex, qId, locn, type, undefined);
		}

		respondToEvents($context);				// Add events on to the altered html
		if($context.attr("id") !== "formList") {
			respondToEvents($context.prev());		// Add events on the "insert before" button
		}

		// Set focus to the new question
		var justAddedQuestionID = '#question' + formIndex +  '_' + (forms[formIndex].questions.length - 1);
		$textArea = $('textarea', justAddedQuestionID);
		textAreaVal = $textArea.val();
		//$textArea.val("").focus().val(textAreaVal);		// Should set text entry to end of text field
		$textArea.focus();

		// Add an end group question if a new group has been created
		if(type === "begin group") {
			itemIndex = forms[formIndex].questions.length - 1;
			var name = survey.forms[formIndex].questions[itemIndex].name + "_groupEnd" ;
			$context = _app_question__WEBPACK_IMPORTED_MODULE_6__["default"].add(formIndex, "question" + formIndex + "_" + itemIndex,
					"after",
					"end group",
					name);
			respondToEvents($context);
		}
	}
}

/*
 * Update the settings data (excluding languages which is set globally)
 */
	function updateSettingsData() {

	$('.survey_name').val(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.displayName);
	$('.formName').text(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.displayName);
	$('#set_survey_ident').val(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.ident);
	$('#set_instance_name').val(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.instanceNameDefn);
	$('#set_style').val(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.surveyClass)
	$('#task_file').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.task_file);
	$('#timing_data').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.timing_data);
	if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.timing_data) {
		$('.audit_location_data').show();
	} else {
		$('.audit_location_data').hide();
	}
	$('#audit_location_data').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.audit_location_data);
	$('#track_changes').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.track_changes);
	$('#hide_on_device').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.hideOnDevice);
	$('#search_local_data').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.searchLocalData);
	$('#data_survey').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.dataSurvey);
	$('#oversight_survey').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.oversightSurvey);
	$('#my_reference_data').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.myReferenceData);
	$('#read_only_survey').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.readOnlySurvey);
    $('#exclude_empty').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.exclude_empty);
	$('#compress_pdf').prop('checked', _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.compress_pdf);
	$('#default_logo').val(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.default_logo);
}


/*
 * Update the language model view
 */
	function updateLanguageView() {
	var i,
		$selector = $('#language_edit_list'),
		languages = gTempLanguages,
		h = [],
		idx = -1;


	h[++idx] = '<table class="table">';
	h[++idx] = '<thead>';
	h[++idx] = '<tr>';
	h[++idx] = '<th>' + _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_name"] + '</th>';
	h[++idx] = '<th>' + _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_code"] + '</th>';
	h[++idx] = '<th>' + _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_rtl"] + '</th>';
	h[++idx] = '</tr>';
	h[++idx] = '</thead>';
	h[++idx] = '<tbody class="table-striped">';

	for(i = 0; i < languages.length; i++) {

		var languageName = languages[i].name;
		if(languageName.indexOf('(') >= 0) {
			languageName = languageName.substring(0, languageName.indexOf('('));
		}

		if(!languages[i].deleted) {
			h[++idx] = '<tr>';

			// name
			h[++idx] = '<td>';
			h[++idx] = '<input type="text" data-idx="';
			h[++idx] = i;
			h[++idx] = '" required class="lname form-control" value="';
			h[++idx] = htmlEncode(languageName);
			h[++idx] = '">';
			h[++idx] = '</td>';

			// code
			h[++idx] = '<td>';
			h[++idx] = '<input type="text" data-idx="';
			h[++idx] = i;
			h[++idx] = '" class="lcode form-control" value="';
			h[++idx] = htmlEncode(languages[i].code);
			h[++idx] = '">';
			h[++idx] = '</td>';

			// direction
			h[++idx] = '<td>';
			h[++idx] = '<input type="checkbox" data-idx="';
			h[++idx] = i;
			h[++idx] = '" class="ldirn form-control"';
			if(languages[i].rtl) {
				h[++idx] = " checked";
			}
			h[++idx] = '>';
			h[++idx] = '</td>';


			// actions
			h[++idx] = '<td>';

			h[++idx] = '<button type="button" data-idx="';
			h[++idx] = i;
			h[++idx] = '" class="btn btn-sm btn-light rm_language mb-1">';
			h[++idx] = '<i class="fas fa-trash-alt edit_icon"></i></button>';

			h[++idx] = '</td>';
			// end actions

			h[++idx] = '</tr>';
		}
	}

	h[++idx] = '</tbody>';
	h[++idx] = '</table>';

	$selector.empty().append(h.join(''));

	$(".rm_language", $selector).click(function(){
		var idx = $(this).data("idx");
		gTempLanguages[idx].deleted = true;
		updateLanguageView();
	});

	$("input.lname", $selector).change(function(){
		var idx = $(this).data("idx");
		gTempLanguages[idx].name = $(this).val();
		updateLanguageView();
	});

	$("input.lcode", $selector).change(function(){
		var idx = $(this).data("idx");
		gTempLanguages[idx].code = $(this).val();
		updateLanguageView();
	});

	$("input.ldirn", $selector).change(function(){
		var idx = $(this).data("idx");

		gTempLanguages[idx].rtl = $(this).prop("checked");
		updateLanguageView();
	});

}

/*
 * Update the pulldata modal view
 */
	function updatePulldataView() {
	var i,
		$selector = $('#pulldata_edit_list'),
		pulldata = gTempPulldata,
		h = [],
		idx = -1;

	h[++idx] = '<table class="table">';
	h[++idx] = '<thead>';
	h[++idx] = '<tr>';
	h[++idx] = '<th>' + _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_survey"], + '</th>';
	h[++idx] = '<th>' + _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_dk"] + '</th>';
	h[++idx] = '<th>' + _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_del"] + '</th>';
	h[++idx] = '</tr>';
	h[++idx] = '</thead>';
	h[++idx] = '<tbody class="table-striped">';

	for(i = 0; i < pulldata.length; i++) {

		if(!pulldata[i].deleted) {
			h[++idx] = '<tr>';

			// Survey
			h[++idx] = '<td>';
			h[++idx] = '<input type="text" data-idx="';
			h[++idx] = i;
			h[++idx] = '" required class="form-control pd_survey" value="';
			h[++idx] = pulldata[i].survey;
			h[++idx] = '">';
			h[++idx] = '</td>';

			// Data Key
			h[++idx] = '<td>';
			h[++idx] = '<input type="text" data-idx="';
			h[++idx] = i;
			h[++idx] = '" required class="form-control pd_data_key" value="';
			h[++idx] = pulldata[i].data_key;
			h[++idx] = '"';
			h[++idx] = '</td>';

			// Repeats
			/*
			h[++idx] = '<td>';
		      h[++idx] = '<input type="checkbox" class="pd_repeats" data-idx="';
		      h[++idx] = i;
		      h[++idx] = '" ';
		      if(pulldata[i].repeats) {
		    	  h[++idx] = 'checked=true ';
		      }
		      h[++idx] = 'value="';
		      h[++idx] = '';
		      h[++idx] = '"> ';
			h[++idx] = '</td>';
			*/

			// Identifier
			/*
			h[++idx] = '<td>';
			h[++idx] = '<input type="text" data-idx="';
			h[++idx] = i;
			h[++idx] = '" readonly class="form-control" value="';
			h[++idx] = "linked_s_pd_" + pulldata[i].survey;
			h[++idx] = '"';
			h[++idx] = '</td>';
			*/

			// actions
			h[++idx] = '<td>';

			h[++idx] = '<button type="button" data-idx="';
			h[++idx] = i;
			h[++idx] = '" class="btn btn-light btn-sm rm_pulldata danger">';
			h[++idx] = '<span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button>';

			h[++idx] = '</td>';
			// end actions

			h[++idx] = '</tr>';
		}
	}

	h[++idx] = '</tbody>';
	h[++idx] = '</table>';

	$selector.empty().append(h.join(''));

    $('input.pd_survey[data-idx="' + (pulldata.length - 1) +'"]' , $selector).focus();

	$(".pd_survey", $selector).change(function(){
		var idx = $(this).data("idx");
		gTempPulldata[idx].survey = $(this).val();
	});

	$(".pd_data_key", $selector).change(function(){
		var idx = $(this).data("idx");
		gTempPulldata[idx].data_key = $(this).val();
	});

    $(".rm_pulldata", $selector).click(function(){
        var idx = $(this).data("idx");
        gTempPulldata.splice(idx, 1);
        updatePulldataView();
    });


}


/*
 * Call this to update a label
 * Label processing is different than other attributes since it has to be applied to multiple languages
 * Parameters:
 * 	element:  text || hint || image || video || audio
 *  newVal: The new value for the label
 *  type: question || option
 */
	function updateLabel(type, formIndex, itemIndex, optionList, element, newVal, qname, prop) {

	var $context,
		change,
		changeType,
		survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
		forms = survey.forms,
		questionType,
		repeat_path,
		oldVal,
		i,
		question;

	if(type === "question") {
		question = survey.forms[formIndex].questions[itemIndex];
		questionType = question.type;
	}

	if(type === "optionlist") {
		oldVal = qname;
	}

	/*
	 * If the question type is a calculate then the label will contain the calculation unless the
	 * property type is type, name or display name
	 */
	if(typeof questionType !== "undefined"
			&& (questionType === "calculate" || questionType === "server_calculate")
			&& prop !== "name"
        	&& prop !== "type"
			&& prop !== "display_name"
			&& prop !== "appearance"
        	&& prop !== "parameters") {	// Whatever the property for a calculation type the label field contains the calculation expression
		changeType = "property";
		if(questionType === "calculate") {
			prop = "calculation";
		} else {
			prop = "server_calculation";
			newVal = {
				expression: newVal
			}
		}
	} else {
		if(prop === "label" || prop === "media" || prop === "hint" || prop === "constraint_msg" || prop === "required_msg"
				|| prop === "guidance_hint")
			changeType = "label";
		else {
			changeType = "property";
		}
	}

	if(typeof questionType !== "undefined" && questionType === "begin repeat") {
		for(i = 0; i < forms.length; i++) {
			if(forms[i].parentFormIndex === formIndex && forms[i].parentQuestionIndex === itemIndex) {
				repeat_path = forms[i].repeat_path;
				break;
			}
		}
	}

	change = {
			changeType: changeType,		// survey | form | language | question | option | (property | label) last two are types of property change
			action: "update",			// add | delete | update
			source: "editor",				// editor | file
			property: {
				qId: undefined,				// qId must be set to apply the change
				qType: questionType,		// Question type
				type: type,					// question or option or optionlist
				name: undefined,			// name of the question or the option value
				propType: element,			// text or hint or image or video or audio or video
				prop: prop,					// Property to be changed, for example: label or appearance
				languageName: undefined,	// Language Name
				allLanguages: false,		// Set true if all languages should be updated with a new label
				repeat_path: repeat_path,	// Path to repeat count question if this is a begin repeat

				newVal: newVal,				// New value to be applied
				oldVal: oldVal,			// Old value for this property
				key: undefined,				// or Translation the "text_id", For option updates the option "value"

				// Helper values temporary indexes to access the model which has values for the question or option to be updated
				qname: qname,					// Question name used when updating an option
				language: _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gLanguage,	// Index into language array
				formIndex: formIndex,		// Index into the array of forms
				itemIndex: itemIndex,		// Index into the form or choice list (for choices)

				optionList: optionList,		// Name of the choice list (if this is an choice update)
				isSurveyLevel: gIsSurveyLevel	// Set true for media if the media was added at the survey level rather than organisation
			}
	};

	$context = _app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].add(change);
	if($context) {
		// Do not set focus on change of label, the user has just clicked out of this label text area
		respondToEvents($context);				// Add events on to the altered html
	}

}

/*
 * Return true if the option list exists
 */
	function optionListExists(list) {
	var optionLists = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.optionLists;

	if(typeof optionLists[list] === "undefined") {
		return false;
	} else {
		return true;
	}
}

/*
 * Get the forms in a survey
 */
/*
 * Get forms for a survey
 */
	function getSurveyForms(sId, callback) {

	if(sId != -1 && sId && sId !== 'null') {
		var url = '/surveyKPI/survey/' + sId + '/getMeta';

		addHourglass();
	 	$.ajax({
			url: url,
			cache: false,
			dataType: 'json',
			success: function(data) {
				removeHourglass();
				if(typeof callback === "function") {
					callback(data);
				}
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
  				if(xhr.readyState == 0 || xhr.status == 0) {
		              return;  // Not an error
				} else {
					_libs_bootbox_5_1_1_min_js__WEBPACK_IMPORTED_MODULE_1___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_err_get_s"] + ":" + htmlEncode(xhr.responseText) + " : " + sId);
				}
			}
		});

	}
}

	function addForms(data) {
	var h = [],
		idx = -1,
		i,
		forms;

	forms = data.forms;
	for(i = 0; i < forms.length; i++) {
		h[++idx] = '<option value="';
		h[++idx] = forms[i].f_id;
		h[++idx] = '">';
		if(forms[i].form === "main") {
			h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_tlf"];
		} else {
			h[++idx] = forms[i].form;
		}
		h[++idx] = '</option>';
	}
	$('#form_name').html(h.join(""));

}

/*
 * User has changed the filter value on an option
 */
	function updateFilterValues($this, isCascade, isChecked) {

	var $elem = $this.closest('tr'),
		$f = $this.closest('td'),
		listName = $elem.data("list_name"),
		formIndex = $elem.data("fid"),
		itemIndex = $elem.data("id"),
		qname = $elem.data("qname"),
		currentFilters,
		filterName,
		fVal,
		newVal;

	if(isCascade) {
		filterName = "_smap_cascade";
		if(isChecked) {
			fVal = $("#previousSelectChoice").val();
		} else {
			fVal = undefined;
		}
		currentFilters = {};
	} else {
		filterName = $f.data("f_name");
		fVal = $this.val();
		currentFilters = $elem.data("filters")
	}

	if(typeof currentFilters !== "object") {
		currentFilters = {};
	}

	newVal = currentFilters;
	if(typeof fVal === "undefined" || fVal.trim().length === 0) {
		delete(newVal[filterName]);
	} else {
		newVal[filterName] = fVal;
	}
	$elem.data("filters", newVal);

	updateLabel("option", formIndex, itemIndex, listName, "text", newVal, qname, "cascade_filters") ;
}

/*
 * Set the choice filter to a value appropriate for cascade selects
 */
	function setCascadeFilter() {
	var filter = "selected(${" + $('#previousSelect option:selected').html() + "}, _smap_cascade)";
	$('#choiceFilter').val(filter);
	updateLabel("question", _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex,
			_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex, undefined, "text", filter, undefined, "choice_filter");
}

	function showSurveySummary(summary) {

	var h = [],
		idx = -1;

	h[++idx] = '<p><b>';
	h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_ident"];
	h[++idx] = "</b>: ";
	h[++idx] = summary.ident;
	h[++idx] = '</p>';


	h[++idx] = '<p><b>';
	h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_survey"];
	h[++idx] = "</b>: ";
	h[++idx] = htmlEncode(summary.displayName);
	h[++idx] = '</p>';

	h[++idx] = '<p><b>';
	h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_project"];
	h[++idx] = "</b>: ";
	h[++idx] = htmlEncode(summary.projectName);
	h[++idx] = '</p>';


	$('#slu_content').html(h.join(''));
	$('#slu').modal("show");

}

	function showSurveyIdentList(surveys) {

	var h = [],
		idx = -1,
		project,
		i;

	if(surveys && surveys.length > 0) {
		for(i = 0; i < surveys.length; i++) {
			if(!project) {
				h[++idx] = '<h4>' + htmlEncode(surveys[i].project) + '</h4>';
				h[++idx] = '<div class="table-responsive">';
				h[++idx] = '<table><tbody>';
			} else if(project != surveys[i].project) {
				h[++idx] = '</tbody></table></div>';
				h[++idx] = '<div class="table-responsive">';
				h[++idx] = '<h4>' + htmlEncode(surveys[i].project) + '</h4>';
				h[++idx] = '<table><tbody>';
			}
			project = surveys[i].project;

			h[++idx] = '<tr>';

			h[++idx] = '<td>';
			h[++idx] = htmlEncode(surveys[i].name);
			h[++idx] = '</td>';

			h[++idx] = '<td>';
			h[++idx] = '<input tabindex="0" type="text"  readonly value="';
			h[++idx] = surveys[i].ident;
			if(i == 0) {
				h[++idx] = '" id="gsi_start'
			}
			h[++idx] = '"/>';
			h[++idx] = '</td>';

			h[++idx] = '</tr>';
		}
		h[++idx] = '</tbody></table></div>';
	}

	$('#gsi').on('shown.bs.modal', function () {
		$('#gsi_start').focus();
		$('#gsi_start').select();
	})

	$('#gsi_content').html(h.join(''));
	$('input', '#gsi_content').keyup(function(event) {
		if (event.keyCode === 13) {
			event.preventDefault();
			document.execCommand('copy');
			$('#gsi').modal("hide");
		}
	});

	$('#gsi').modal("show");

}

/*
 * clear the choice filter
 */
	function setNoFilter() {
	$('#choiceFilter').val("");
	updateLabel("question", _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gFormIndex,
			_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gItemIndex, undefined, "text", "", undefined, "choice_filter");
}

            function nextIssue(severity) {

                var i, pos;
				/*
				 * Make sure we start inside the array
				 */
                if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].errors.length > 0) {
                    if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gErrorPosition > _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].errors.length - 1) {
                        _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gErrorPosition  = 0;
                    }
                    for(i = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gErrorPosition + 1; i < _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gErrorPosition + _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].errors.length + 1; i++) {

                        if(i > _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].errors.length - 1 ) {
                            pos = i - _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].errors.length;
                        } else {
                            pos = i;
                        }

                        if(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].errors[pos].severity === severity) {
                            _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gErrorPosition = pos;
                            break;
                        }
                    }

                    focusOnError(_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gErrorPosition);
                } else {
                    _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gErrorPosition = 0;
                }
            }


            function focusOnError(position) {
                var survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
                    error = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].errors[position],
                    itemId,
                    $textarea,
                    $item,
                    $parents;

                if(error.itemType === "question") {

                    itemId = "question" + error.container + "_" + error.itemIndex;
                    $item = $('#' + itemId);

                    // Expand all parent panes
                    $parents = $item.parents('div.collapse');
                    $parents.show();

                    $textarea = $item.find('.question').find('textarea');
                    if($textarea.length > 0) {
                        $textarea.focus();
                    } else {
                        $item.find('button').focus();
                    }

                    if(!$("#viewType").prop('checked')) {
                        $("#viewType").closest('.toggle').trigger("click");
                    }

                } else {

                    //globals.gIsQuestionView = false;
                    _app_changeset__WEBPACK_IMPORTED_MODULE_9__["default"].updateViewControls();
                    //refreshForm();

                    if($("#viewType").prop('checked')) {
                        $("#viewType").closest('.toggle').trigger("click");
					}

                    $item = $('.olname[value="' + error.container + '"]');
                    $item.focus();
                }

            }

            /*
             * Get the value of a parameter from the parameter dialog
             */
            function getParam($elem, params, key, type) {
				var val;
				if(type === "boolean") {
					val = $elem.prop('checked') ? 'true' : '';
				} else {
					if(key === 'med_type') {
						if ($('#p_medical').prop("checked")) {
							val = $elem.val();
						}
					} else {
						val = $elem.val();
					}
				}
				if(val) {
					val = val.trim();
					if(val.length > 0) {
						// validate
						if(key === 'max-pixels') {
							if(val <= 0) {
								showParameterError(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["ed_gt_0"]);
								$('#p_max_pixels').focus();
								return false;
							}
						}

						// Save parameter
						if(key) {
							val = key + '=' + val;
						}
						params.push(val);
					}
				}
				return true;
            }

			/*
             * Get the value of an appearance from the appearance dialog
             */
			function getAppearance($elem, appearances, key, details, qtype, app_choices) {
				var val,
					msg,
					i;

				if(details.type === "boolean") {
					val = $elem.prop('checked') ? key : undefined;
				} else if(details.type === "select") {
					if($elem.val() === details.undef_value) {
						val = undefined;
					} else {
						if (details.valIsAppearance) {
							val = $elem.val();
						} else {
							val = key + $elem.val();
						}
					}
				} else if(details.type === "form") {
					// Handcoded
					if(details.field === 'a_search') {
						var search_source = $('input[type=radio][name=search_source]:checked').val();
						var search_access = $('input[type=radio][name=search_access]:checked').val();
						if(search_source !== 'worksheet') {
							if(search_access === 'online') {
								val = "lookup_choices(";
							} else {
								val = "search(";
							}

							// filename
							var filename;
							var csvfile;

							if(search_source === "survey") {
								if($('#a_survey_identifier').val() === '') {
									showAppearanceError(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_search_source2"]);
									return false;
								}
								filename = 'linked_' + $('#a_survey_identifier').val();
							} else if(search_source === "csv") {
								if($('#a_csv_identifier').val() === '') {
									showAppearanceError(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_search_source2"]);
									return false;
								}
								csvfile = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCsvFiles[$('#a_csv_identifier').val()];
								filename = csvfile.filename;
								var idx = filename.lastIndexOf('.');    // remove the extension
								if(idx > 0) {
									filename = filename.substring(0, idx);
								}
							} else {
								showAppearanceError(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_search_source"]);
								return false;
							}
							val += "'" + filename + "'";

							/*
							 * Add dummy appearances in app_choices for choice value and choice labels
							 */
							if(!getDummyChoiceAppearances(app_choices)) {
								showAppearanceError(_app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_choice_value"]);
								return false;   // error
							}

							if($('#a_fe').prop('checked')) {
								var expression = $('#a_fe_val').val();
								if (expression === '') {
									msg = _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_filter_expr"];
									$('#appearance_msg').removeClass('alert-warning').addClass('alert-danger').show().html(msg);
									return false;
								} else {
									val += ", 'eval', '" + expression + "'";
								}
							} else {
								// first filter
								var filterColumn = $('#a_filter_column').val().trim();
								var filter = $('#a_match').val();
								var filterValue;
								var secondFilterColumn;
								var secondFilterValue;
								if (filterColumn !== '' && filterColumn !== '0') {
									if (filter === '') {
										msg = _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_filter_col"];
										msg = msg.replace('%s1', filterColumn);
										$('#appearance_msg').removeClass('alert-warning').addClass('alert-danger').show().html(msg);
										return false;
									} else {
										val += ", '" + filter + "'";
									}

									// first filter column
									val += ", '" + filterColumn + "'";

									// first filter Value
									filterValue = $('#a_filter_value_static').val().trim();
									if (filterValue.indexOf('${') === 0) {
										// question value
										// TODO check that question is in survey
									} else {
										// static value
										filterValue = "'" + filterValue + "'";      // add quotes
									}
									val += ", " + filterValue;

									// second filter
									secondFilterColumn = $('#a_second_filter_column').val();
									if (secondFilterColumn !== '' && secondFilterColumn > 0) {
										val += ", '" + secondFilterColumn + "'";

										// second filter Value
										secondFilterValue = $('#a_second_filter_value_static').val().trim();
										if (secondFilterValue.indexOf('${') === 0) {
											// question value
											// TODO check that question is in survey
										} else {
											// static value
											secondFilterValue = "'" + secondFilterValue + "'";      // add quotes
										}
										val += ", " + secondFilterValue;
									}
								}
							}



							val += ")";    // Close
						} else {
							val = undefined;
						}
					} else if(details.field === 'a_select1_type' || details.field === 'a_select_type') {
						var s1Val = $elem.val();
						if(s1Val === '') {
							val = undefined;
						} else if (s1Val === 'columns' || s1Val === 'quickcompact') {
							var numberColumns = $('#a_number_columns').val();
							if(numberColumns === '') {
								val = s1Val;
							} else {
								val = s1Val + '-' + numberColumns;
							}
						} else if (s1Val === 'autocomplete-minimal') {
							val = 'autocomplete minimal';
						} else {
							val = s1Val;
						}
					}
				}

				if(val) {
					val = val.trim();
					appearances.push(val);
				}

				return validateAppearance(qtype, appearances, $('#appearance_msg'));

			}

			/*
			 * Choice values may be required in appearance if search is used
			 */
			function getDummyChoiceAppearances(app_choices) {
				var i = 0;
				var searchValue = $('#a_search_value').val();
				if(searchValue && searchValue.trim().length > 0) {
					app_choices.push('_sv::' + searchValue);
				} else {
					return false;
				}
				var languages = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.languages;
				for(i = 0; i < languages.length; i++) {
					var labelValueArray = $('#a_search_label' + i).val();
					var labelValue = labelValueArray ? labelValueArray.join(',') : "";
					if(!labelValue || labelValue.trim().length == 0) {
						labelValue = searchValue;
					}
					if(labelValue && labelValue.trim().length > 0) {
						app_choices.push('_sl::' + languages[i].name + '::' + labelValue);
					}
				}
				return true;
			}

			/*
             * Set the value of a parameter in the parameter dialog
             */
			function setParam($elem, val, type) {
				var val;
				if (type === "boolean") {
					$elem.prop('checked', val == 'yes' || val === 'true');
				} else {
					$elem.val(val);
				}
			}

			/*
             * Set the value of an appearance in the appearance dialog
             */
			function setAppearance($elem, val, type, appearance, question, survey) {
				if (type === "boolean") {
					$elem.prop('checked', true);
				} else if (type === "form") {
					// Custom - hardcoded
					if(val === "search(" || val === "lookup_choices(") {
						var params = getAppearanceParams(appearance);
						gAppearanceQuestion = question;

						// Now check parameters
						if(params.length > 0) {
							gAppearanceParams = params;

							// 1. First parameter is the filename
							if(params.filename.startsWith('linked_s')) {
								var sIdent = params.filename.substring("linked_s".length - 1);
								$('input[type=radio][name=search_source][value=survey]').prop('checked', true);
								$('#a_survey_identifier').val(sIdent);
								$('.search_survey').show();
								getQuestionsInSurvey($('.column_select'), $('.column_select_multiple'), sIdent, true, false, setAppearanceValues, true);
							} else {
								var csvIndex = getIndexOfCsvFilename(params.filename);
								$('input[type=radio][name=search_source][value=csv]').prop('checked', true);
								$('#a_csv_identifier').val(csvIndex);
								$('.search_csv').show();
								if(typeof csvIndex !== "undefined") {
									getQuestionsInCsvFile($('.column_select'), $('.column_select_multiple'), csvIndex, true);
								}
								setAppearanceValues();
							}
						}

						/*
						 * Set the access value
						 */
						if(val === "search(") {
							$('input[type=radio][name=search_access][value=offline]').prop('checked', true);
							$('.online_appearance_field').hide();
						} else {
							$('input[type=radio][name=search_access][value=online]').prop('checked', true);
							$('.online_appearance_field').show();
						}

						showSearchElements();
					} else if(val === 'columns' || val === 'quickcompact') {
						if(appearance === 'columns-pack') {
							$elem.val(appearance);
						} else {
							var paramsArray = appearance.split('-');
							$elem.val(paramsArray[0]);
							if (paramsArray.length > 0) {
								$('#a_number_columns').val(paramsArray[1]);
							}
							$('.a_number_columns').show();
						}

					} else if(val === 'autocomplete' && question.appearance.indexOf('minimal') >= 0
							|| val === 'minimal' && question.appearance.indexOf('autocomplete') >= 0) {
						$elem.val('autocomplete-minimal');
					} else {
						$elem.val(val);
					}
				} else {
					$elem.val(val);
				}
			}

			/*
             * Get the forms in the survey as options for a select
             */
			function getFormsAsSelect(excludeForm) {

				var i,
					survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
					h = [],
					idx = -1;

				if(survey) {
					if(survey.forms && survey.forms.length > 0) {

						h[++idx] = '<option value="">';
						h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_none"];
						h[++idx] = '</option>';

						for(i = 0; i < survey.forms.length; i++) {
							if(survey.forms[i].name !== excludeForm && survey.forms[i].parentFormIndex != -1) {
								h[++idx] = '<option value="';
								h[++idx] = survey.forms[i].name;
								h[++idx] = '">';
								h[++idx] = survey.forms[i].name;
								h[++idx] = '</option>';
							}
						}
					}
				}

				return h.join("");

			}

			/*
			 * Get the questions in the form currently being edited as options for a select question
			 */
			function getQuestionsAsSelect(noneText, textOnly) {

				var i,
					survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey,
					h = [],
					idx = -1;

				/*
				 * Process the questions in the top level form (parent is 0)
				 *   Questions that are "begin repeat" type will link to sub level forms which are then processed in turn
				 *
				 */
				if(survey) {
					if(survey.forms && survey.forms.length > 0) {

						h[++idx] = '<option value="">';
						if(!noneText) {
							h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["c_none"];
						} else {
							h[++idx] = noneText;
						}
						h[++idx] = '</option>';

						for(i = 0; i < survey.forms.length; i++) {
							if(survey.forms[i].parentFormIndex == -1) {
								h[++idx] = getQuestionsFromForm(survey.forms[i], i, textOnly);
								break;
							}
						}
					}
				}

				return h.join("");

			}

			function getQuestionsFromForm(form, formIndex, textOnly) {
				var i,
					question,
					h = [],
					idx = -1;

				if(form) {

					for (i = 0; i < form.qSeq.length; i++) {
						_app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gHasItems = true;
						question = form.questions[form.qSeq[i]];

						// Ignore property type questions, questions that have been deleted and meta questions like end repeat
						if (!_app_editorMarkup__WEBPACK_IMPORTED_MODULE_8__["default"].includeQuestion(question)) {
							continue;
						}

						if(!textOnly || isTextStorageType(question.type)) {
							h[++idx] = '<option value="';
							h[++idx] = question.name;
							h[++idx] = '">';
							h[++idx] = question.name;
							h[++idx] = '</option>';
						}
					}
				}
				return h.join('');
			}

			function getIndexOfCsvFilename(filename) {
				var csvArray = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].gCsvFiles;
				var i;

				filename += ".csv";     // The filename in the csvArray includes the extension
				for(i = 0; i < csvArray.length; i++) {
					if(csvArray[i].filename === filename) {
						return i;
					}
				}
				return undefined;
			}

			function showSearchElements() {

				var expression = $('#a_fe_val').val();
				var aFilterColumn = $('#a_filter_column').val();
				var aSecondFilterColumn = $('#a_second_filter_column').val();
				var searchSource = $('input[type=radio][name=search_source]:checked').val();
				var searchChoiceValue = $('#a_search_value').val();
				var search_access = $('input[type=radio][name=search_access]:checked').val();
				var fileIdentifier;
				var hasSearch;

				if(searchSource && searchSource !== '' && searchSource !== 'worksheet') {
					hasSearch =true;
				}

				if(search_access === 'online') {
					$('.online_appearance_field').show();
				} else {
					$('.online_appearance_field').hide();
				}

				$('#appearance_msg').hide();

				if(hasSearch) {
					$('.appearance_search_details').show();

					$('.search_csv, .search_survey').hide();
					if(searchSource == "survey") {
						$('.search_survey').show();
						fileIdentifier = $('#a_survey_identifier').val();
					} else if(searchSource == "csv") {
						$('.search_csv').show();
						fileIdentifier = $('#a_csv_identifier').val();
					}

					if(!fileIdentifier || fileIdentifier === '') {
						$('.a_choice_values').hide();
					} else {
						$('.a_choice_values').show();
					}

					if($('#a_fe').prop('checked')) {
						$('.filter_expression').show();
						$('.classic_filter').hide();
					} else {
						$('.filter_expression').hide();
						$('.classic_filter').show();

						if (!searchChoiceValue || searchChoiceValue === '') {
							$('.a_filter_column').hide();
						} else {
							$('.a_filter_column').show();
						}

						if (!aFilterColumn || aFilterColumn === "" || aFilterColumn === "0") {
							$(".has_filter, .a_second_filter_column, .has_second_filter").hide();
						} else {
							$(".has_filter, .a_second_filter_column").show();
						}

						if (!aSecondFilterColumn || aSecondFilterColumn === "" || aSecondFilterColumn === "0") {
							$('.has_second_filter').hide();
						} else {
							$('.has_second_filter').show();
						}
					}

				} else {
					$('.appearance_search_details').hide();
				}
			}

			function checkForAppearanceWarnings() {
				var warningMsg = '';
				var i;
				var msg;
				var qtype = gQType;

				if(qtype === 'string') {
					// Warn if thousands separator is used without numbers on a text question
					var ts = $('#a_sep').is(':checked');
					var numbers = $('#a_numbers').is(':checked');
					if(ts && !numbers) {
						if(warningMsg.length > 0) {
							warningMsg += '. ';
						}
						warningMsg += _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_numb_ts"];
					}
				}

				if(qtype === 'select1') {
					// Warn if likert appearance is used
					var select1Type = $('#a_select1_type').val();
					var likert = $('#a_likert').is(':checked');
					if(likert && select1Type !== '') {
						if(warningMsg.length > 0) {
							warningMsg += '. ';
						}
						warningMsg += _app_localise__WEBPACK_IMPORTED_MODULE_4__["default"].set["msg_warn_likert_n"];
					}
				}

				if(warningMsg.length > 0) {
					$('#appearance_msg').removeClass('alert-danger').addClass('alert-warning').show().html(warningMsg);
				} else {
					$('#appearance_msg').hide();
				}

				/*
				 * Show / hide controls
				 */
				if(qtype === 'select1') {
					var select1Type = $('#a_select1_type').val();
					if(select1Type === 'columns' || select1Type === 'quickcompact') {
						$('.a_number_columns').show();
					} else {
						$('.a_number_columns').hide();
					}
					if(select1Type === 'columns' || select1Type === 'columns-pack') {
						$('.a_no_buttons').show();
					} else {
						$('.a_no_buttons').hide();
					}
				}

			}

			/*
			 * Check for errors before returning
			 * TODO
			 */
			function validateAppearance() {
				return true;
			}

			/*
			 * Add a label control for each language
			 */
			function addLabelControls() {
				var languages = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey.languages;
				var i;
				var h = [];
				var idx = -1;
				var labelControlId;

				for (i = 0; i < languages.length; i++) {
					labelControlId = 'a_search_label' + i;
					h[++idx] = '<div class="form-group row search_label">';
						h[++idx] = '<label for="';
						h[++idx] = labelControlId;
						h[++idx] = '" class="col-sm-4 control-label">';
						h[++idx] = htmlEncode(languages[i].name);
						h[++idx] = '</label>';
					h[++idx] = '<div class="col-sm-8">';
					h[++idx] = '<select id="';
						h[++idx] = labelControlId;
						h[++idx] = '" multiple="multiple" class="form-control column_select_multiple"></select>';
					h[++idx] = '</div>';
					h[++idx] = '</div>';
				}
				$('#search_label_list').empty().append(h.join(''));

			}

			function showAppearanceError(msg) {
				$('#appearance_msg').removeClass('alert-warning').addClass('alert-danger').show().html(msg);
			}
			function showParameterError(msg) {
				$('#parameter_msg').removeClass('alert-warning').addClass('alert-danger').show().html(msg);
			}

			/*
			 * Set values in drop down lists in appearance dialog
			 */
			function setAppearanceValues() {
				var langIdx = 0;
				for (i = 0; i < window.gAppChoiceArray.length; i++) {
					var ace = window.gAppChoiceArray[i].split('::');
					if (ace.length > 1) {
						if (ace[0] === '_sv') {
							$('#a_search_value').val(ace[1]);
						} else if (ace[0] === '_sl' && ace.length > 2) {
							$('#a_search_label' + langIdx++).val(ace[2]);
						}
					}
				}

				/*
                 * Add the choice values
                 */
				if(gAppearanceQuestion) {
					var survey = _app_globals__WEBPACK_IMPORTED_MODULE_5__["default"].model.survey;
					var optionList = survey.optionLists[gAppearanceQuestion.list_name];
					if (optionList && optionList.options.length > 0) {
						var i;
						for (i = 0; i < optionList.options.length; i++) {
							var v = optionList.options[i].value;
							if (isNaN(v)) {
								// Apply this choice
								$('#a_search_value').val(v);
								var choiceIdx = 0;
								var labels = optionList.options[i].labels;
								for (choiceIdx = 0; choiceIdx < labels.length; choiceIdx++) {
									var labelValue = labels[choiceIdx].text;
									$('#a_search_label' + choiceIdx).multiselect('deselectAll', false);
									if(labelValue && labelValue.trim().length > 0) {
										var labelArray = labelValue.split(",");
										for (i = 0; i < labelArray.length; i++) {
											$('#a_search_label' + choiceIdx).multiselect('select', labelArray[i]);
											$('#a_search_label' + choiceIdx).multiselect('refresh');
										}
									}
								}
								break;
							} else {
								continue;   // Purely numeric must be a static choice
							}
						}
					}

					if(gAppearanceParams) {
						if(gAppearanceParams.expression) {
							$('#a_fe').prop('checked', true);
							$('#a_fe_val').val(gAppearanceParams.expression);
						} else {
							$('#a_fe').prop('checked', false);
							if (gAppearanceParams.length > 1) {
								$('#a_match').val(gAppearanceParams.filter);
							}

							if (gAppearanceParams.length > 2) {
								$('#a_filter_column').val(gAppearanceParams.filter_column);
							}

							if (gAppearanceParams.length > 3) {
								$('#a_filter_value_static').val(gAppearanceParams.filter_value);
							}

							if (gAppearanceParams.length > 4) {
								$('#a_second_filter_column').val(gAppearanceParams.second_filter_column);
							}


							if (gAppearanceParams.length > 5) {
								$('#a_second_filter_value_static').val(gAppearanceParams.second_filter_value);
							}
						}
					}

				showSearchElements();
			}
		}
});



})();

/******/ })()
;