/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./WebContent/js/app/globals.js"
/*!**************************************!*\
  !*** ./WebContent/js/app/globals.js ***!
  \**************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Quick solution to issue of legacy globals after migrating to AMD / require.js
 */
const globals = {

        // Security groups
        GROUP_ADMIN: 1,
        GROUP_ANALYST: 2,
        GROUP_ENUM: 3,
        GROUP_ORG_ADMIN : 4,
        GROUP_MANAGE: 5,
        GROUP_SECURITY: 6,
        GROUP_VIEW_DATA: 7,
        GROUP_ENTERPRISE : 8,
        GROUP_OWNER : 9,
		GROUP_VIEW_OWN_DATA : 10,
	    GROUP_MANAGE_TASKS : 11,
	    GROUP_DASHBOARD : 12,
        GROUP_LINKAGES : 13,
        GROUP_CONSOLE_ADMIN : 14,
        GROUP_MCP_ACCESS : 15,

        REC_LIMIT: 200,     // Page size for table views in analysis
	    MAP_REC_LIMIT: 10000,    // Max size for map views in analysis

        gProjectList: undefined,
        gRoleList: undefined,
        gCmSettings: undefined,
        gCurrentProject: 0,
        gCurrentSurvey: 0,
        gCurrentSurveyIdent: undefined,
	    gGroupSurveys: {},
	    gSubForms: {},
        gCurrentForm: 0,
        gCurrentLayer: undefined,
        gLoggedInUser: undefined,
        gEditingReportProject: undefined,   		// Set if fieldAnalysis called to edit a report
        gIsAdministrator: false,
        gIsEnum: false,
        gIsAnalyst: false,
	    gIsDashboard: false,
        gIsManage: false,
        gIsOrgAdministrator: false,
        gIsSecurityAdministrator: false,
        gIsEnterpriseAdministrator: false,
        gIsLinkFollower: false,
        gIsServerOwner: false,
        gIsConsoleAdmin: false,
        gViewData: false,
	    gManageTasks: false,
        gBillingData: false,
        gOrgBillingData: false,
        gSendTrail: 'off',
        gViewIdx: 0,
        gSelector: new Selector(),
        gOrgId: 0,
        gTimezone: undefined,
	    gEnterpriseName: undefined,
	    gSetAsTheme: undefined,
	    gNavbarColor: undefined,

        gRegions: undefined,
        gRegion: {},

        gServerCanSendEmail: false,

        // Reports
        gEmailEnabled: false,
        gFacebookEnabled: false,
        gTwitterEnabled: false,

        // Tasks
        gCurrentUserId: undefined,
        gCurrentUserName: undefined,
        gAssignmentsLayer: undefined,
        gPendingUpdates: [],
        gCurrentTaskGroup: undefined,
	    gCurrentMailout: undefined,
        gTaskList: undefined,
        gCurrentSurveyIndex: 0,
	    gCurrentInstance: undefined,
        gAlertSeen: false,
        gLastAlertTime: undefined,

        // Editor
        gExistingSurvey: false,		// Set true if modifying an existing survey
        gElementIndex: 0,			// Manage creation of unique identifier for each element (question, option) in editor
        gHasItems: false,			// Set true if there are questions or choice lists in the survey
        gNewQuestionButtonIndex: 0,	// Manage creation of unique identifier for buttons that add new questions
        gNewOptionButtonIndex: 0,
        gSId: 0,
        gLanguage: 0,
        gLanguage1: 0,
        gLanguage2: 0,
        errors: [],
        changes: [],
        gErrorPosition: 0,
        gSelProperty: 'label',
        gSelLabel: 'Question Text',
        gSelQuestionProperty: 'label',
        gSelQuestionLabel: 'Question Text',
        gSelChoiceProperty: 'label',
        gSelChoiceLabel: 'Question Text',
        gIsQuestionView: true,
        gShowingChoices: false,
        gMaxOptionList: 0,
        gLatestOptionList: undefined,	// Hack to record the last option list name added
	    gCsvFiles: undefined,

        gListName: undefined,					// Choice Modal parameters, Set if started from choice list view
        gOptionList: undefined,					// The option list name applying to this set of choices
        gSelOptionId: undefined,				// Selected option index
        gFormIndex: undefined,					// Selected form index
        gItemIndex: undefined,					// Selected question index
        gSelectedFilters: undefined,
        gFilterArray: undefined,

        gSaveInProgress: false,

        // Dashboard
        gMainTable: undefined,			// Data tables
        gReports: undefined,			// reports
        gCharts: {},					// charts
	    gRecordMaps: [],                // Maps shown when editing a record
	    gRecordChangeMaps: [],          // Maps shown when viewing change history
        gMapLayersShown: false,
        gViewId: 0,						// Current survey view

	    gTraining: undefined,
	    gRefreshRate: 0,

        gMapboxDefault: undefined,		// Mapbox key
        
        model: typeof Model !== "undefined" ? new Model() : undefined

    }


    function Selector() {

        this.dataItems = {};
        this.surveys = {};
        this.surveysExtended = {};
        this.surveyLanguages = {};
        this.surveyQuestions = {};
        this.surveyMeta = {};
        this.surveyAlerts = {};
        this.questions = {};
        this.allSurveys = undefined;			// Simple list of surveys
        this.allRegions = undefined;
        this.sharedMaps = undefined;
        this.views = [];			// Simple list of views
        this.maps = {};				// map panels indexed by the panel id
        this.changed = false;
        this.SURVEY_KEY_PREFIX = "surveys";
        this.TASK_KEY = "tasks";
        this.TASK_COLOR = "#dd00aa";
        this.SURVEY_COLOR = "#00aa00";
        this.SELECTED_COLOR = "#0000aa";
        this.currentPanel = "map";

        this.getAll = function () {
            return this.dataItems;
        };

        this.getItem = function (key) {
            return this.dataItems[key];
        };

        this.addDataItem = function (key, data) {
            this.dataItems[key] = data;
        };

        this.clearDataItems = function () {
            this.dataItems = {};
        };

        this.addSurvey = function (sId, data) {
            this.surveys[sId] = data;
        };

        this.addSurveyExtended = function (sId, data) {
            this.surveysExtended[sId] = data;
        };

        this.getSurvey = function (sId) {
            return this.surveysExtended[sId] || this.surveys[sId];
        };

        this.clearSurveys = function () {
            this.surveys = {};
            this.surveysExtended = {};
            this.surveyLanguages = {};
            this.surveyQuestions = {};
            this.surveyMeta = {};
            this.surveyAlerts = {};
            this.allSurveys = undefined;
        };

        this.setSurveyList = function (data) {
            this.allSurveys = data;
        };

        this.getSurveyList = function () {
            return this.allSurveys;
        };

        this.setSurveyLanguages = function (sId, data) {
            this.surveyLanguages[sId] = data;
        };

        this.getSurveyLanguages = function (sId) {
            return this.surveyLanguages[sId];
        };

        this.setSurveyQuestions = function (sId, language, data) {
            if (!this.surveyQuestions[sId]) {
                this.surveyQuestions[sId] = {};
            }
            this.surveyQuestions[sId][language] = data;
        };

        this.getSurveyQuestions = function (sId, language) {
            if (!this.surveyQuestions[sId]) {
                return undefined;
            }
            if (typeof language === "undefined") {
                return this.surveyQuestions[sId];
            }
            return this.surveyQuestions[sId][language];
        };

        this.getQuestion = function (qId, language) {
            return this.getQuestionDetails(globals.gCurrentSurvey, qId, language);
        };

        this.getQuestionDetails = function (sId, qId, language) {
            var questions = this.getSurveyQuestions(sId, language);
            if (!questions) {
                return undefined;
            }
            for (var i = 0; i < questions.length; i++) {
                if (questions[i].id == qId) {
                    return questions[i];
                }
            }
            return undefined;
        };

        this.setSurveyMeta = function (sId, data) {
            this.surveyMeta[sId] = data;
        };

        this.getSurveyMeta = function (sId) {
            return this.surveyMeta[sId];
        };

        this.setSurveyAlerts = function (sId, data) {
            this.surveyAlerts[sId] = data;
        };

        this.getSurveyAlerts = function (sId) {
            return this.surveyAlerts[sId];
        };

        this.setRegionList = function (data) {
            this.allRegions = data;
        };

        this.getRegionList = function () {
            return this.allRegions;
        };

        this.setSharedMaps = function (data) {
            this.sharedMaps = data;
        };

        this.getSharedMaps = function () {
            return this.sharedMaps;
        };

        this.setViews = function (data) {
            this.views = data || [];
        };

        this.getViews = function () {
            return this.views;
        };

        this.setMap = function (idx, map) {
            this.maps[idx] = map;
        };

        this.getMap = function (idx) {
            return this.maps[idx];
        };

    }

    /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (globals);


/***/ },

/***/ "./WebContent/js/app/localise.js"
/*!***************************************!*\
  !*** ./WebContent/js/app/localise.js ***!
  \***************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

const $ = window.$;

const dtLangFiles = {
	en: "",
	es: "/js/libs/DataTables.i18n/es.json",
	ar: "/js/libs/DataTables.i18n/ar.json",
	fr: "/js/libs/DataTables.i18n/fr.json",
	pt: "/js/libs/DataTables.i18n/pt.json",
	hi: "/js/libs/DataTables.i18n/hi.json"
};

const localeCache = {};
let currentLocale = "en";

function normalizeLocale(locale) {
	if (!locale) {
		return "en";
	}
	return locale.toLowerCase().replace("_", "-");
}

function localeCandidates(locale) {
	const normalized = normalizeLocale(locale);
	const base = normalized.split("-")[0];
	const candidates = [];

	if (normalized && normalized !== "en") {
		candidates.push(normalized);
	}
	if (base && base !== normalized && base !== "en") {
		candidates.push(base);
	}
	if (!candidates.includes("root")) {
		candidates.push("root");
	}

	return candidates;
}

function parseAmdLocale(text) {
	const trimmed = text.trim();
	const prefix = "define(";
	const start = trimmed.indexOf(prefix);
	const end = trimmed.lastIndexOf(")");
	if (start === -1 || end === -1 || end <= start) {
		throw new Error("Invalid locale format");
	}
	const objectText = trimmed.slice(start + prefix.length, end).trim();
	const jsonText = objectText
		.replace(/\s*\/\/.*$/gm, "")
		.replace(/\s\/\*[\s\S]*?\*\//g, "")
		.trim();
	return JSON.parse(jsonText);
}

async function loadLocaleFile(locale) {
	if (localeCache[locale]) {
		return localeCache[locale];
	}

	const src = `/js/nls/${locale}/lang.js`;
	const data = await new Promise((resolve, reject) => {
		const previousDefine = window.define;
		const script = document.createElement("script");

		window.define = function (payload) {
			window.define = previousDefine;
			script.remove();
			resolve(payload);
		};
		window.define.amd = true;

		script.src = src;
		script.async = true;
		script.onerror = function () {
			window.define = previousDefine;
			script.remove();
			reject(new Error(`Locale ${locale} not found`));
		};

		document.head.appendChild(script);
	});

	localeCache[locale] = data;
	return data;
}

async function initLocale(locale) {
	const candidates = localeCandidates(locale);
	const rootLocale = await loadLocaleFile("root");
	let merged = { ...rootLocale };
	let resolvedLocale = "root";

	for (const candidate of candidates) {
		if (candidate === "root") {
			continue;
		}
		try {
			const data = await loadLocaleFile(candidate);
			merged = { ...merged, ...data };
			resolvedLocale = candidate;
			break;
		} catch (error) {
			// fallback to next candidate
		}
	}

	currentLocale = resolvedLocale;
	window.localise.set = merged;
	return merged;
}

window.localise = {
	setlang: function () {
		$(".lang").each(function() {
			const $this = $(this);
			const code = $this.data("lang");
			if (code) {
				$this.html(window.localise.set[code]);
			}
		});

		$(".lang_tt").each(function() {
			const $this = $(this);
			const code = $this.data("lang_tt");
			if (code) {
				$this.prop("title", window.localise.set[code]);
			}
		});

		$(".lang_ph").each(function() {
			const $this = $(this);
			const code = $this.data("lang_ph");
			if (code) {
				$this.prop("placeholder", window.localise.set[code]);
			}
		});

		if (typeof responsiveMobileMenu === "function") {
			rmmResizeLabels();
		}
	},
	set: {},
	dt: function() {
		return dtLangFiles[currentLocale] || dtLangFiles.en;
	},
	initLocale
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (window.localise);


/***/ },

/***/ "./WebContent/js/libs/bootstrap.file-input.js"
/*!****************************************************!*\
  !*** ./WebContent/js/libs/bootstrap.file-input.js ***!
  \****************************************************/
() {

/*
  Bootstrap - File Input
  ======================

  This is meant to convert all file input tags into a set of elements that displays consistently in all browsers.

  Converts all
  <input type="file">
  into Bootstrap buttons
  <a class="btn">Browse</a>

*/
(function($) {

$.fn.bootstrapFileInput = function() {

  this.each(function(i,elem){

    var $elem = $(elem);

    // Maybe some fields don't need to be standardized.
    if (typeof $elem.attr('data-bfi-disabled') != 'undefined') {
      return;
    }

    // Set the word to be displayed on the button
    var buttonWord = localise.set["ar_af"];
    //var buttonWord = 'Browse';

    //if (typeof $elem.attr('title') != 'undefined') {
    //  buttonWord = $elem.attr('title');
    //}

    var className = '';

    if (!!$elem.attr('class')) {
      className = ' ' + $elem.attr('class');
    }

    // Now we're going to wrap that input field with a Bootstrap button.
    // The input will actually still be there, it will just be float above and transparent (done with the CSS).
    buttonWord = '<i class="glyphicon glyphicon-plus"></i>' + '<span>' + buttonWord + '</span>';
    $elem.wrap('<a class="file-input-wrapper btn btn-success ' + className + '"></a>').parent().prepend(buttonWord);
  })

  // After we have found all of the file inputs let's apply a listener for tracking the mouse movement.
  // This is important because the in order to give the illusion that this is a button in FF we actually need to move the button from the file input under the cursor. Ugh.
  .promise().done( function(){

    // As the cursor moves over our new Bootstrap button we need to adjust the position of the invisible file input Browse button to be under the cursor.
    // This gives us the pointer cursor that FF denies us
    $('.file-input-wrapper').mousemove(function(cursor) {

      var input, wrapper,
        wrapperX, wrapperY,
        inputWidth, inputHeight,
        cursorX, cursorY;

      // This wrapper element (the button surround this file input)
      wrapper = $(this);
      // The invisible file input element
      input = wrapper.find("input");
      // The left-most position of the wrapper
      wrapperX = wrapper.offset().left;
      // The top-most position of the wrapper
      wrapperY = wrapper.offset().top;
      // The with of the browsers input field
      inputWidth= input.width();
      // The height of the browsers input field
      inputHeight= input.height();
      //The position of the cursor in the wrapper
      cursorX = cursor.pageX;
      cursorY = cursor.pageY;

      //The positions we are to move the invisible file input
      // The 20 at the end is an arbitrary number of pixels that we can shift the input such that cursor is not pointing at the end of the Browse button but somewhere nearer the middle
      moveInputX = cursorX - wrapperX - inputWidth + 20;
      // Slides the invisible input Browse button to be positioned middle under the cursor
      moveInputY = cursorY- wrapperY - (inputHeight/2);

      // Apply the positioning styles to actually move the invisible file input
      input.css({
        left:moveInputX,
        top:moveInputY
      });
    });

    $('body').on('change', '.file-input-wrapper input[type=file]', function(){

      var fileName,
      		fileDesc,
      		$this = $(this),
      		$target = $('.upload_file_msg');
     
      if ($this.prop('files') && $this.prop('files').length > 1) {
    	  fileDesc = '';
    	  for(i = 0; i < $this.prop('files').length; i++) {
    		  fileName = $this[0].files[i].name;
    		  fileName = fileName.substring(fileName.lastIndexOf('\\') + 1, fileName.length);
    		  if(i > 0) {
    			  fileDesc += ', ';
    		  }
    		  fileDesc += fileName;
    	  }
      }
      else {
    	fileName = $this.val();
        fileName = fileName.substring(fileName.lastIndexOf('\\') + 1, fileName.length);
        fileDesc = fileName;
      }

      // Don't try to show the name if there is none
      if (!fileDesc) {
          $target.addClass('alert-success').removeClass('alert-danger').html("").val("");
	      $('.submitFiles').addClass('disabled');
          return;
      }
      $('.submitFiles').removeClass('disabled');
      $target.addClass('alert-success').removeClass('alert-danger').html(fileDesc).val(fileDesc);

      var w = 0;
      $('.progress-bar').css('width', w+'%').attr('aria-valuenow', w); 
   
    });

  });

};

// Add the styles before the first stylesheet
// This ensures they can be easily overridden with developer styles
var cssHtml = '<style>'+
  '.file-input-wrapper { overflow: hidden; position: relative; cursor: pointer; z-index: 1; }'+
  '.file-input-wrapper input[type=file], .file-input-wrapper input[type=file]:focus, .file-input-wrapper input[type=file]:hover { position: absolute; top: 0; left: 0; cursor: pointer; opacity: 0; filter: alpha(opacity=0); z-index: 99; outline: 0; }'+
  '.file-input-name { margin-left: 8px; }'+
  '</style>';
$('link[rel=stylesheet]').eq(0).before(cssHtml);

})(jQuery);

/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!************************************!*\
  !*** ./WebContent/js/resources.js ***!
  \************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _libs_bootstrap_file_input_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./libs/bootstrap.file-input.js */ "./WebContent/js/libs/bootstrap.file-input.js");
/* harmony import */ var _libs_bootstrap_file_input_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_libs_bootstrap_file_input_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _app_localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./app/localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _app_globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app/globals */ "./WebContent/js/app/globals.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Purpose: Allow the user to select a web form in order to complete a survey
 */






const $ = window.$;

let gUserLocale = navigator.language;
if (typeof localStorage !== "undefined") {
	try {
		gUserLocale = localStorage.getItem('user_locale') || navigator.language;
	} catch (error) {
		gUserLocale = navigator.language;
	}
}

window.gUserLocale = gUserLocale;

let gMaps,
	gMapVersion,
	gMapId,
	gTags,          // NFC tags
	gCurrentGroup,
	gIsSurvey;

$(function() {

		// moment loaded via script tag for common.js

		/*
	 	 * Get the parameters
	 	 */
		var params = location.search.substring(location.search.indexOf("?") + 1);
		var pArray = params.split("&");
		var i;
		for (i = 0; i < pArray.length; i++) {
			var param = pArray[i].split("=");
			if ( param[0] === "survey" ) {
				gIsSurvey = true;
			} else if ( param[0] === "survey_name" ) {
				$('.formName').text(decodeURI(': ' + param[1]));
			}
		}

		setCustomResources();			// Apply custom javascript
		setTheme();
		setupUserProfile(true);
		_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].initLocale(gUserLocale).then(function () {
			_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].setlang();		// Localise HTML
			$('#map_name').attr("placeholder", _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["sr_m_ph"]);
			$('#map_description').attr("placeholder", _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["sr_m_d"]);
			$('#mapid').attr("placeholder", _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["sr_m_mb"]);
		});

		// Get the user details
		_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentSurvey = undefined;
		getLoggedInUser(gotUser, false, false, undefined, false, false);
		getLocations(loadedLocationData);

		// Set up the tabs
		$('#csvTab a').click(function (e) {
			e.preventDefault();
			$(this).tab('show');

			$('.resourcePanel').hide();
			$('#csvPanel').show();

			$('.upload_alert').removeClass('alert-danger').addClass('alert-success').html("");
		});
		$('#mediaTab a').click(function (e) {
			e.preventDefault();
			$(this).tab('show');

			$('.resourcePanel').hide();
			$('#mediaPanel').show();

			$('.upload_alert').removeClass('alert-danger').addClass('alert-success').html("");
		});
		$('#mapTab a').click(function (e) {
			e.preventDefault();
			$(this).tab('show');

			$('.resourcePanel').hide();
			$('#mapPanel').show();
		});
		$('#locationTab a').click(function (e) {
			e.preventDefault();
			$(this).tab('show');

			$('.resourcePanel').hide();
			$('#locationPanel').show();

			$('.upload_file_msg').hide().removeClass('alert-danger').addClass('alert-success').html("");
		});

		/*
         * Set up csv tab
         */
		$('.csv-inputs').bootstrapFileInput();
		$('.upload_alert').hide().removeClass('alert-danger').addClass('alert-success').html("");

		// Open the dialog to select a new survey for upload
		$('#addCsv').click( function(e) {
			$('#uploadAction').val("add");
			$('#resourceUpload')[0].reset();
			$('.notreplace, #fileCsv').show();
			$('#fileMedia').hide();
			$('.upload_alert').removeClass('alert-danger').addClass('alert-success').html("");
			$('#fileAddPopup').modal('show');
		});

		// Open the dialog to select a new survey for upload
		$('#addMedia').click( function(e) {
			$('#uploadAction').val("add");
			$('#resourceUpload')[0].reset();
			$('.notreplace, #fileMedia').show();
			$('#fileCsv').hide();
			$('.upload_alert').removeClass('alert-danger').addClass('alert-success').html("");
			$('#fileAddPopup').modal('show');
		});

		/*
         * Uploading of media files
         */
		$('#itemName').keydown(function(){
			$('.upload_alert').removeClass('alert-danger').addClass('alert-success').html("");
		});

		// Change function on media file selected
		$('#fileCsv, #fileMedia').change(function(){
			var $this = $(this);
			var itemName = $('#itemName').val();
			var fileName = $this[0].files[0].name;

			$('.upload_alert').hide();

			if(!itemName || itemName.trim().length === 0) {
				$('#itemName').val(getBaseName(fileName));
			}
		});

		// Upload a single media or CSV File
		$('#submitResourceFile').click( function(e) {
			$('#submitResourceFile').prop("disabled", true);  // debounce
			uploadResourceFile();
		});

		/*
         * Set up media tab
         */
		$('.media-inputs').bootstrapFileInput();

		// Respond to file upload
		$('.submitMedia').addClass('disabled');
		$('#submitMedia').click( function() {
			if(!$('#submitMedia').hasClass('disabled')) {
				uploadFiles('/surveyKPI/upload/media', "mediaupload", refreshMediaViewManage);
			}
		});

		// Respond to location upload
		$('.upload_file_msg').hide();
		$('#uploadLocationFiles').click( function() {
			$('.upload_file_msg').hide();
			$('#fileAddLocations').modal('show');
		});
		$('#submitLocationFile').click( function(){
			uploadFiles('/surveyKPI/tasks/locations/upload', "locationsUpload", loadedLocationData);
		});

		// Respond to location download
		$('#downloadLocationFiles').click( function() {
			$('.upload_file_msg').hide();
			if(!$('#downloadLocationFiles').hasClass('disabled')) {
				downloadFile('/surveyKPI/tasks/locations/download');
			}
		});

		$('#location_group').change(function() {
			refreshLocationView();
		});
		$('#includeNfc, #includeGeo').change(function() {
			gCurrentGroup = refreshLocationGroups(gTags, false, gCurrentGroup);
			refreshLocationView();
		});

		/*
         * Set up maps tab
         */
		$('#addMap').click(function(){
			edit_map();
			$('#addMapPopup').modal("show");
		});

		// Enable the save notifications function
		$('#saveMap').click(function(){saveMap();});

		// Respond to change of map type
		$(".vector_only").hide();
		$('#map_type').change(function(){
			showMapDialogSections($(this));
		});
		getMaps();

		/*
         * Set up location tabs
         */
		$('#addNfc').click(function(){
			$('#addMapPopup').modal("show");
		});

		$('.vector-data-inputs').bootstrapFileInput();
		$('.vector-style-inputs').bootstrapFileInput();

	});

	/*
	Once we know the user and the current survey get the media files
	 */
	function gotUser() {
		/*
		 * Update menus
		 * Do it here as menus will have been set automatically according to security privileges
		 */
		if(gIsSurvey) {
			$('#mapTab, #locationTab').hide();
			$('#m_monitor, #m_tm, #m_user, #m_settings, #m_logs').hide();
			$('#m_form').show();
			$('#page_title').text(_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["sr_sm"]);
		}

		// Get the files
		getFilesFromServer(gIsSurvey ? _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentSurvey : 0, refreshMediaViewManage, false);
	}
	function showMapDialogSections(type) {
		if(type === "mapbox") {
			$(".mapbox_only").show();
			$(".vector_only").hide();
		} else {
			$(".vector_only").show();
			$(".mapbox_only").hide();
		}
	}

	/*
     * Open a map for editing or create a new map
     */
	function edit_map(idx) {

		var map,
			title = _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_add_map"];

		document.getElementById("map_edit_form").reset();

		if(typeof idx !== "undefined") {
			map = gMaps[idx];

			title = _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_edit_map"],

				$('#map_name').val(map.name);
			$('#map_type').val(map.type);
			$('#map_description').val(map.description);

			$('#map_zoom').val(map.config.zoom);
			$('#mapid').val(map.config.mapid);
			$('#vector_data').val(map.config.vectorData);
			$('#style_data').val(map.config.styleData);

			gMapVersion = map.version;
			gMapId = map.id;
		} else {
			gMapVersion = 1;
			gMapId = -1;
		}

		showMapDialogSections($('#map_type').val())
		$('#addMapLabel').html(title);

	}

	/*
     * Save a map
     */
	function saveMap() {

		var map,
			url = "/surveyKPI/shared/maps",
			mapString;

		map = {};
		map.name = $('#map_name').val();
		map.type = $('#map_type').val();
		map.description = $('#map_description').val();
		map.config = {};
		map.config.zoom = $('#map_zoom').val();
		map.config.mapid = $('#mapid').val();
		map.config.vectorData = $('#vector_data').val();
		map.config.styleData = $('#style_data').val();

		map.version = gMapVersion;
		map.id = gMapId;

		mapString = JSON.stringify(map);
		addHourglass();
		$.ajax({
			type: "POST",
			async: false,
			cache: false,
			url: url,
			contentType: "application/x-www-form-urlencoded ",
			data: { map: mapString },
			success: function(data, status) {
				removeHourglass();
				getMaps();
				$('#addMapPopup').modal("hide");
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_save"] + " " + xhr.responseText);	// alerts htmlencode
				}
			}
		});


	}

	/*
     * Get the shared maps from the server
     */
	function getMaps() {

		var url="/surveyKPI/shared/maps/";

		addHourglass();
		$.ajax({
			url: url,
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				gMaps = data;
				updateMapList(data);
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					console.log("Error: Failed to get list of maps: " + err);
				}
			}
		});

	}


	/*
     * Update the list of maps
     */
	function updateMapList(data) {

		var $selector=$('#map_list'),
			i,
			h = [],
			idx = -1;

		h[++idx] = '<thead>';
		h[++idx] = '<tr>';
		h[++idx] = '<th>' + _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_name"], + '</th>';
		h[++idx] = '<th>' + _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_type"] + '</th>';
		h[++idx] = '<th>' + _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_desc"] + '</th>';
		h[++idx] = '<th>' + _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_details"] + '</th>';
		h[++idx] = '<th></th>';
		h[++idx] = '</tr>';
		h[++idx] = '</thead>';
		h[++idx] = '<tbody class="table-striped">';

		for(i = 0; i < data.length; i++) {

			h[++idx] = '<tr>';

			// name
			h[++idx] = '<td>';
			h[++idx] = htmlEncode(data[i].name);
			h[++idx] = '</td>';

			// type
			h[++idx] = '<td>';
			h[++idx] = htmlEncode(data[i].type);
			h[++idx] = '</td>';

			// description
			h[++idx] = '<td>';
			h[++idx] = htmlEncode(data[i].desc);
			h[++idx] = '</td>';

			// details
			h[++idx] = '<td>';

			h[++idx] = htmlEncode(data[i].config.zoom + " levels");
			if(data[i].type === "mapbox" && data[i].config.mapid) {
				h[++idx] = htmlEncode(", Mapbox Id: " + data[i].config.mapid);
			}
			if(data[i].type === "vector" && data[i].config.vectorData) {
				h[++idx] = htmlEncode(", Vector file: " + data[i].config.vectorData);
			}
			if(data[i].type === "vector" && data[i].config.styleData) {
				h[++idx] = htmlEncode(", styled by " + data[i].config.styleData);
			}
			h[++idx] = '</td>';

			// actions
			h[++idx] = '<td>';

			h[++idx] = '<button type="button" data-idx="';
			h[++idx] = i;
			h[++idx] = '" class="btn btn-info mx-2 btn-sm edit_map warning">';
			h[++idx] = '<i class="far fa-edit"></i></button>';

			h[++idx] = '<button type="button" data-idx="';
			h[++idx] = i;
			h[++idx] = '" class="btn btn-danger mx-2 btn-sm rm_map danger">';
			h[++idx] = '<i class="fas fa-trash-alt"></i></button>';

			h[++idx] = '</td>';
			// end actions

			h[++idx] = '</tr>';
		}
		h[++idx] = '</tbody>';

		$selector.empty().append(h.join(''));

		$(".rm_map", $selector).click(function(){
			var idx = $(this).data("idx");
			delete_map(gMaps[idx].id);
		});

		$(".edit_map", $selector).click(function(){
			var idx = $(this).data("idx");
			edit_map(idx);
			$('#addMapPopup').modal("show");
		});

	}

	/*
     * Delete a shared map
     */
	function delete_map(id) {

		addHourglass();
		$.ajax({
			type: "DELETE",
			async: false,
			url: "/surveyKPI/shared/maps/" + id,
			success: function(data, status) {
				removeHourglass();
				getMaps();
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_del"] + " " + xhr.responseText);	// alerts htmlencode
				}
			}
		});
	}

	/*
     * Show the NFC tags
     */
	function loadedLocationData(tags) {

		gTags = tags;
		gCurrentGroup = refreshLocationGroups(gTags, false, gCurrentGroup);
		refreshLocationView();
	}

	function refreshLocationView() {

		var i,
			survey = _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			$element,
			h = [],
			idx = -1,
			currentGroup = $('#location_group').val();

		var includeNfc = $('#includeNfc').prop('checked'),
			includeGeo = $('#includeGeo').prop('checked');

		if(gTags) {

			$element = $('#locationList');


			for(i = 0; i < gTags.length; i++){

				if(currentGroup === gTags[i].group) {

					if(includeLocation(includeNfc, includeGeo, gTags[i].uid, gTags[i].lat, gTags[i].lon)) {
						h[++idx] = '<tr>';

						h[++idx] = '<td>';
						h[++idx] = htmlEncode(gTags[i].group);
						h[++idx] = '</td>';

						h[++idx] = '<td>';
						h[++idx] = htmlEncode(gTags[i].uid);
						h[++idx] = '</td>';

						h[++idx] = '<td>';
						h[++idx] = htmlEncode(gTags[i].name);
						h[++idx] = '</td>';

						h[++idx] = '<td>';
						h[++idx] = gTags[i].lat == "0" ? '' : htmlEncode(gTags[i].lat);
						h[++idx] = '</td>';

						h[++idx] = '<td>';
						h[++idx] = gTags[i].lon == "0" ? '' : htmlEncode(gTags[i].lon);
						h[++idx] = '</td>';

						h[++idx] = '</tr>';
					}
				}

			}

			$element.html(h.join(""));
		}
	}

	/*
     * Upload a shared resource file
     */
	function uploadResourceFile() {

		$('.upload_alert').hide();

		if(gIsSurvey) {
			$('#surveyId').val(_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentSurvey);
		}

		let f = document.forms.namedItem("resourceUpload");
		let formData = new FormData(f);
		let url;

		let name = $('#itemName').val();

		/*
		 * Validation
		 */
		if(!name || name.trim().length == 0) {		// Name is set
			$('.upload_alert').show().removeClass('alert-success alert-warning').addClass('alert-danger').html(_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_val_nm"]);
			$('#submitResourceFile').prop("disabled", false);  // debounce
			return false;
		}

		if(name.indexOf('/') >= 0						// Name includes a slash
				|| name.indexOf('.') >= 0) {			// Name includes a .
			$('.upload_alert').show().removeClass('alert-success alert-warning').addClass('alert-danger').html(_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_val_inv_nm"]);
			$('#submitResourceFile').prop("disabled", false);  // debounce
			return false;
		}

		url = '/surveyKPI/upload/media';

		addHourglass();
		$.ajax({
			url: url,
			type: 'POST',
			data: formData,
			dataType: 'json',
			cache: false,
			contentType: false,
			processData:false,
			success: function(data) {
				removeHourglass();
				$('#submitResourceFile').prop("disabled", false);  // debounce
				if(handleLogout(data)) {

					// Check for errors in the form
					if (data && data.status === "error") {
						$('.upload_alert').show().removeClass('alert-success alert-warning').addClass('alert-danger').text(data.message);
					} else {
						var surveyId = 0;
						document.forms.namedItem("resourceUpload").reset();
						if (gIsSurvey) {
							surveyId = _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentSurvey;
						}
						getFilesFromServer(surveyId, refreshMediaViewManage, false);
						$('.upload_alert').show().removeClass('alert-danger alert-warning').addClass('alert-success').html(_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["t_tl"] + ": " + data.name);
					}
					$('#file').val("");     // Work around ERR_UPLOAD_FILE_CHANGED error
				}

			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					$('#submitResourceFile').prop("disabled", false);  // debounce

					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						$('.upload_alert').show().removeClass('alert-success').addClass('alert-danger').html(_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_u_f"] + ": " + htmlEncode(xhr.responseText));
						$('#file').val("");     // Work around ERR_UPLOAD_FILE_CHANGED error
					}
				}
			}
		});
	}

})();

/******/ })()
;