/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./WebContent/js/app/globals.js"
/*!**************************************!*\
  !*** ./WebContent/js/app/globals.js ***!
  \**************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Quick solution to issue of legacy globals after migrating to AMD / require.js
 */
const globals = {

        // Security groups
        GROUP_ADMIN: 1,
        GROUP_ANALYST: 2,
        GROUP_ENUM: 3,
        GROUP_ORG_ADMIN : 4,
        GROUP_MANAGE: 5,
        GROUP_SECURITY: 6,
        GROUP_VIEW_DATA: 7,
        GROUP_ENTERPRISE : 8,
        GROUP_OWNER : 9,
		GROUP_VIEW_OWN_DATA : 10,
	    GROUP_MANAGE_TASKS : 11,
	    GROUP_DASHBOARD : 12,
        GROUP_LINKAGES : 13,
        GROUP_CONSOLE_ADMIN : 14,
        GROUP_MCP_ACCESS : 15,

        REC_LIMIT: 200,     // Page size for table views in analysis
	    MAP_REC_LIMIT: 10000,    // Max size for map views in analysis

        gProjectList: undefined,
        gRoleList: undefined,
        gCmSettings: undefined,
        gCurrentProject: 0,
        gCurrentSurvey: 0,
        gCurrentSurveyIdent: undefined,
	    gGroupSurveys: {},
	    gSubForms: {},
        gCurrentForm: 0,
        gCurrentLayer: undefined,
        gLoggedInUser: undefined,
        gEditingReportProject: undefined,   		// Set if fieldAnalysis called to edit a report
        gIsAdministrator: false,
        gIsEnum: false,
        gIsAnalyst: false,
	    gIsDashboard: false,
        gIsManage: false,
        gIsOrgAdministrator: false,
        gIsSecurityAdministrator: false,
        gIsEnterpriseAdministrator: false,
        gIsLinkFollower: false,
        gIsServerOwner: false,
        gIsConsoleAdmin: false,
        gViewData: false,
	    gManageTasks: false,
        gBillingData: false,
        gOrgBillingData: false,
        gSendTrail: 'off',
        gViewIdx: 0,
        gSelector: new Selector(),
        gOrgId: 0,
        gTimezone: undefined,
	    gEnterpriseName: undefined,
	    gSetAsTheme: undefined,
	    gNavbarColor: undefined,

        gRegions: undefined,
        gRegion: {},

        gServerCanSendEmail: false,

        // Reports
        gEmailEnabled: false,
        gFacebookEnabled: false,
        gTwitterEnabled: false,

        // Tasks
        gCurrentUserId: undefined,
        gCurrentUserName: undefined,
        gAssignmentsLayer: undefined,
        gPendingUpdates: [],
        gCurrentTaskGroup: undefined,
	    gCurrentMailout: undefined,
        gTaskList: undefined,
        gCurrentSurveyIndex: 0,
	    gCurrentInstance: undefined,
        gAlertSeen: false,
        gLastAlertTime: undefined,

        // Editor
        gExistingSurvey: false,		// Set true if modifying an existing survey
        gElementIndex: 0,			// Manage creation of unique identifier for each element (question, option) in editor
        gHasItems: false,			// Set true if there are questions or choice lists in the survey
        gNewQuestionButtonIndex: 0,	// Manage creation of unique identifier for buttons that add new questions
        gNewOptionButtonIndex: 0,
        gSId: 0,
        gLanguage: 0,
        gLanguage1: 0,
        gLanguage2: 0,
        errors: [],
        changes: [],
        gErrorPosition: 0,
        gSelProperty: 'label',
        gSelLabel: 'Question Text',
        gSelQuestionProperty: 'label',
        gSelQuestionLabel: 'Question Text',
        gSelChoiceProperty: 'label',
        gSelChoiceLabel: 'Question Text',
        gIsQuestionView: true,
        gShowingChoices: false,
        gMaxOptionList: 0,
        gLatestOptionList: undefined,	// Hack to record the last option list name added
	    gCsvFiles: undefined,

        gListName: undefined,					// Choice Modal parameters, Set if started from choice list view
        gOptionList: undefined,					// The option list name applying to this set of choices
        gSelOptionId: undefined,				// Selected option index
        gFormIndex: undefined,					// Selected form index
        gItemIndex: undefined,					// Selected question index
        gSelectedFilters: undefined,
        gFilterArray: undefined,

        gSaveInProgress: false,

        // Dashboard
        gMainTable: undefined,			// Data tables
        gReports: undefined,			// reports
        gCharts: {},					// charts
	    gRecordMaps: [],                // Maps shown when editing a record
	    gRecordChangeMaps: [],          // Maps shown when viewing change history
        gMapLayersShown: false,
        gViewId: 0,						// Current survey view

	    gTraining: undefined,
	    gRefreshRate: 0,

        gMapboxDefault: undefined,		// Mapbox key
        
        model: typeof Model !== "undefined" ? new Model() : undefined

    }


    function Selector() {

        this.dataItems = {};
        this.surveys = {};
        this.surveysExtended = {};
        this.surveyLanguages = {};
        this.surveyQuestions = {};
        this.surveyMeta = {};
        this.surveyAlerts = {};
        this.questions = {};
        this.allSurveys = undefined;			// Simple list of surveys
        this.allRegions = undefined;
        this.sharedMaps = undefined;
        this.views = [];			// Simple list of views
        this.maps = {};				// map panels indexed by the panel id
        this.changed = false;
        this.SURVEY_KEY_PREFIX = "surveys";
        this.TASK_KEY = "tasks";
        this.TASK_COLOR = "#dd00aa";
        this.SURVEY_COLOR = "#00aa00";
        this.SELECTED_COLOR = "#0000aa";
        this.currentPanel = "map";

        this.getAll = function () {
            return this.dataItems;
        };

        this.getItem = function (key) {
            return this.dataItems[key];
        };

        this.addDataItem = function (key, data) {
            this.dataItems[key] = data;
        };

        this.clearDataItems = function () {
            this.dataItems = {};
        };

        this.addSurvey = function (sId, data) {
            this.surveys[sId] = data;
        };

        this.addSurveyExtended = function (sId, data) {
            this.surveysExtended[sId] = data;
        };

        this.getSurvey = function (sId) {
            return this.surveysExtended[sId] || this.surveys[sId];
        };

        this.clearSurveys = function () {
            this.surveys = {};
            this.surveysExtended = {};
            this.surveyLanguages = {};
            this.surveyQuestions = {};
            this.surveyMeta = {};
            this.surveyAlerts = {};
            this.allSurveys = undefined;
        };

        this.setSurveyList = function (data) {
            this.allSurveys = data;
        };

        this.getSurveyList = function () {
            return this.allSurveys;
        };

        this.setSurveyLanguages = function (sId, data) {
            this.surveyLanguages[sId] = data;
        };

        this.getSurveyLanguages = function (sId) {
            return this.surveyLanguages[sId];
        };

        this.setSurveyQuestions = function (sId, language, data) {
            if (!this.surveyQuestions[sId]) {
                this.surveyQuestions[sId] = {};
            }
            this.surveyQuestions[sId][language] = data;
        };

        this.getSurveyQuestions = function (sId, language) {
            if (!this.surveyQuestions[sId]) {
                return undefined;
            }
            if (typeof language === "undefined") {
                return this.surveyQuestions[sId];
            }
            return this.surveyQuestions[sId][language];
        };

        this.getQuestion = function (qId, language) {
            return this.getQuestionDetails(globals.gCurrentSurvey, qId, language);
        };

        this.getQuestionDetails = function (sId, qId, language) {
            var questions = this.getSurveyQuestions(sId, language);
            if (!questions) {
                return undefined;
            }
            for (var i = 0; i < questions.length; i++) {
                if (questions[i].id == qId) {
                    return questions[i];
                }
            }
            return undefined;
        };

        this.setSurveyMeta = function (sId, data) {
            this.surveyMeta[sId] = data;
        };

        this.getSurveyMeta = function (sId) {
            return this.surveyMeta[sId];
        };

        this.setSurveyAlerts = function (sId, data) {
            this.surveyAlerts[sId] = data;
        };

        this.getSurveyAlerts = function (sId) {
            return this.surveyAlerts[sId];
        };

        this.setRegionList = function (data) {
            this.allRegions = data;
        };

        this.getRegionList = function () {
            return this.allRegions;
        };

        this.setSharedMaps = function (data) {
            this.sharedMaps = data;
        };

        this.getSharedMaps = function () {
            return this.sharedMaps;
        };

        this.setViews = function (data) {
            this.views = data || [];
        };

        this.getViews = function () {
            return this.views;
        };

        this.setMap = function (idx, map) {
            this.maps[idx] = map;
        };

        this.getMap = function (idx) {
            return this.maps[idx];
        };

    }

    /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (globals);


/***/ },

/***/ "./WebContent/js/app/localise.js"
/*!***************************************!*\
  !*** ./WebContent/js/app/localise.js ***!
  \***************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

const $ = window.$;

const dtLangFiles = {
	en: "",
	es: "/js/libs/DataTables.i18n/es.json",
	ar: "/js/libs/DataTables.i18n/ar.json",
	fr: "/js/libs/DataTables.i18n/fr.json",
	pt: "/js/libs/DataTables.i18n/pt.json",
	hi: "/js/libs/DataTables.i18n/hi.json"
};

const localeCache = {};
let currentLocale = "en";

function normalizeLocale(locale) {
	if (!locale) {
		return "en";
	}
	return locale.toLowerCase().replace("_", "-");
}

function localeCandidates(locale) {
	const normalized = normalizeLocale(locale);
	const base = normalized.split("-")[0];
	const candidates = [];

	if (normalized && normalized !== "en") {
		candidates.push(normalized);
	}
	if (base && base !== normalized && base !== "en") {
		candidates.push(base);
	}
	if (!candidates.includes("root")) {
		candidates.push("root");
	}

	return candidates;
}

function parseAmdLocale(text) {
	const trimmed = text.trim();
	const prefix = "define(";
	const start = trimmed.indexOf(prefix);
	const end = trimmed.lastIndexOf(")");
	if (start === -1 || end === -1 || end <= start) {
		throw new Error("Invalid locale format");
	}
	const objectText = trimmed.slice(start + prefix.length, end).trim();
	const jsonText = objectText
		.replace(/\s*\/\/.*$/gm, "")
		.replace(/\s\/\*[\s\S]*?\*\//g, "")
		.trim();
	return JSON.parse(jsonText);
}

async function loadLocaleFile(locale) {
	if (localeCache[locale]) {
		return localeCache[locale];
	}

	const src = `/js/nls/${locale}/lang.js`;
	const data = await new Promise((resolve, reject) => {
		const previousDefine = window.define;
		const script = document.createElement("script");

		window.define = function (payload) {
			window.define = previousDefine;
			script.remove();
			resolve(payload);
		};
		window.define.amd = true;

		script.src = src;
		script.async = true;
		script.onerror = function () {
			window.define = previousDefine;
			script.remove();
			reject(new Error(`Locale ${locale} not found`));
		};

		document.head.appendChild(script);
	});

	localeCache[locale] = data;
	return data;
}

async function initLocale(locale) {
	const candidates = localeCandidates(locale);
	const rootLocale = await loadLocaleFile("root");
	let merged = { ...rootLocale };
	let resolvedLocale = "root";

	for (const candidate of candidates) {
		if (candidate === "root") {
			continue;
		}
		try {
			const data = await loadLocaleFile(candidate);
			merged = { ...merged, ...data };
			resolvedLocale = candidate;
			break;
		} catch (error) {
			// fallback to next candidate
		}
	}

	currentLocale = resolvedLocale;
	window.localise.set = merged;
	return merged;
}

window.localise = {
	setlang: function () {
		$(".lang").each(function() {
			const $this = $(this);
			const code = $this.data("lang");
			if (code) {
				$this.html(window.localise.set[code]);
			}
		});

		$(".lang_tt").each(function() {
			const $this = $(this);
			const code = $this.data("lang_tt");
			if (code) {
				$this.prop("title", window.localise.set[code]);
			}
		});

		$(".lang_ph").each(function() {
			const $this = $(this);
			const code = $this.data("lang_ph");
			if (code) {
				$this.prop("placeholder", window.localise.set[code]);
			}
		});

		if (typeof responsiveMobileMenu === "function") {
			rmmResizeLabels();
		}
	},
	set: {},
	dt: function() {
		return dtLangFiles[currentLocale] || dtLangFiles.en;
	},
	initLocale
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (window.localise);


/***/ },

/***/ "./WebContent/js/libs/jquery.autosize.min.js"
/*!***************************************************!*\
  !*** ./WebContent/js/libs/jquery.autosize.min.js ***!
  \***************************************************/
() {

/*!
	Autosize v1.18.9 - 2014-05-27
	Automatically adjust textarea height based on user input.
	(c) 2014 Jack Moore - http://www.jacklmoore.com/autosize
	license: http://www.opensource.org/licenses/mit-license.php
*/
(function(e){var t,o={className:"autosizejs",id:"autosizejs",append:"\n",callback:!1,resizeDelay:10,placeholder:!0},i='<textarea tabindex="-1" style="position:absolute; top:-999px; left:0; right:auto; bottom:auto; border:0; padding: 0; -moz-box-sizing:content-box; -webkit-box-sizing:content-box; box-sizing:content-box; word-wrap:break-word; height:0 !important; min-height:0 !important; overflow:hidden; transition:none; -webkit-transition:none; -moz-transition:none;"/>',n=["fontFamily","fontSize","fontWeight","fontStyle","letterSpacing","textTransform","wordSpacing","textIndent"],s=e(i).data("autosize",!0)[0];s.style.lineHeight="99px","99px"===e(s).css("lineHeight")&&n.push("lineHeight"),s.style.lineHeight="",e.fn.autosize=function(i){return this.length?(i=e.extend({},o,i||{}),s.parentNode!==document.body&&e(document.body).append(s),this.each(function(){function o(){var t,o=window.getComputedStyle?window.getComputedStyle(u,null):!1;o?(t=u.getBoundingClientRect().width,(0===t||"number"!=typeof t)&&(t=parseInt(o.width,10)),e.each(["paddingLeft","paddingRight","borderLeftWidth","borderRightWidth"],function(e,i){t-=parseInt(o[i],10)})):t=p.width(),s.style.width=Math.max(t,0)+"px"}function a(){var a={};if(t=u,s.className=i.className,s.id=i.id,d=parseInt(p.css("maxHeight"),10),e.each(n,function(e,t){a[t]=p.css(t)}),e(s).css(a).attr("wrap",p.attr("wrap")),o(),window.chrome){var r=u.style.width;u.style.width="0px",u.offsetWidth,u.style.width=r}}function r(){var e,n;t!==u?a():o(),s.value=!u.value&&i.placeholder?(p.attr("placeholder")||"")+i.append:u.value+i.append,s.style.overflowY=u.style.overflowY,n=parseInt(u.style.height,10),s.scrollTop=0,s.scrollTop=9e4,e=s.scrollTop,d&&e>d?(u.style.overflowY="scroll",e=d):(u.style.overflowY="hidden",c>e&&(e=c)),e+=w,n!==e&&(u.style.height=e+"px",f&&i.callback.call(u,u))}function l(){clearTimeout(h),h=setTimeout(function(){var e=p.width();e!==g&&(g=e,r())},parseInt(i.resizeDelay,10))}var d,c,h,u=this,p=e(u),w=0,f=e.isFunction(i.callback),z={height:u.style.height,overflow:u.style.overflow,overflowY:u.style.overflowY,wordWrap:u.style.wordWrap,resize:u.style.resize},g=p.width(),y=p.css("resize");p.data("autosize")||(p.data("autosize",!0),("border-box"===p.css("box-sizing")||"border-box"===p.css("-moz-box-sizing")||"border-box"===p.css("-webkit-box-sizing"))&&(w=p.outerHeight()-p.height()),c=Math.max(parseInt(p.css("minHeight"),10)-w||0,p.height()),p.css({overflow:"hidden",overflowY:"hidden",wordWrap:"break-word"}),"vertical"===y?p.css("resize","none"):"both"===y&&p.css("resize","horizontal"),"onpropertychange"in u?"oninput"in u?p.on("input.autosize keyup.autosize",r):p.on("propertychange.autosize",function(){"value"===event.propertyName&&r()}):p.on("input.autosize",r),i.resizeDelay!==!1&&e(window).on("resize.autosize",l),p.on("autosize.resize",r),p.on("autosize.resizeIncludeStyle",function(){t=null,r()}),p.on("autosize.destroy",function(){t=null,clearTimeout(h),e(window).off("resize",l),p.off("autosize").off(".autosize").css(z).removeData("autosize")}),r())})):this}})(window.jQuery||window.$);

/***/ },

/***/ "./WebContent/js/libs/wb/plugins/iCheck/icheck.min.js"
/*!************************************************************!*\
  !*** ./WebContent/js/libs/wb/plugins/iCheck/icheck.min.js ***!
  \************************************************************/
() {

/*! iCheck v1.0.2 by Damir Sultanov, http://git.io/arlzeA, MIT Licensed */
(function(f){function A(a,b,d){var c=a[0],g=/er/.test(d)?_indeterminate:/bl/.test(d)?n:k,e=d==_update?{checked:c[k],disabled:c[n],indeterminate:"true"==a.attr(_indeterminate)||"false"==a.attr(_determinate)}:c[g];if(/^(ch|di|in)/.test(d)&&!e)x(a,g);else if(/^(un|en|de)/.test(d)&&e)q(a,g);else if(d==_update)for(var f in e)e[f]?x(a,f,!0):q(a,f,!0);else if(!b||"toggle"==d){if(!b)a[_callback]("ifClicked");e?c[_type]!==r&&q(a,g):x(a,g)}}function x(a,b,d){var c=a[0],g=a.parent(),e=b==k,u=b==_indeterminate,
    v=b==n,s=u?_determinate:e?y:"enabled",F=l(a,s+t(c[_type])),B=l(a,b+t(c[_type]));if(!0!==c[b]){if(!d&&b==k&&c[_type]==r&&c.name){var w=a.closest("form"),p='input[name="'+c.name+'"]',p=w.length?w.find(p):f(p);p.each(function(){this!==c&&f(this).data(m)&&q(f(this),b)})}u?(c[b]=!0,c[k]&&q(a,k,"force")):(d||(c[b]=!0),e&&c[_indeterminate]&&q(a,_indeterminate,!1));D(a,e,b,d)}c[n]&&l(a,_cursor,!0)&&g.find("."+C).css(_cursor,"default");g[_add](B||l(a,b)||"");g.attr("role")&&!u&&g.attr("aria-"+(v?n:k),"true");
    g[_remove](F||l(a,s)||"")}function q(a,b,d){var c=a[0],g=a.parent(),e=b==k,f=b==_indeterminate,m=b==n,s=f?_determinate:e?y:"enabled",q=l(a,s+t(c[_type])),r=l(a,b+t(c[_type]));if(!1!==c[b]){if(f||!d||"force"==d)c[b]=!1;D(a,e,s,d)}!c[n]&&l(a,_cursor,!0)&&g.find("."+C).css(_cursor,"pointer");g[_remove](r||l(a,b)||"");g.attr("role")&&!f&&g.attr("aria-"+(m?n:k),"false");g[_add](q||l(a,s)||"")}function E(a,b){if(a.data(m)){a.parent().html(a.attr("style",a.data(m).s||""));if(b)a[_callback](b);a.off(".i").unwrap();
    f(_label+'[for="'+a[0].id+'"]').add(a.closest(_label)).off(".i")}}function l(a,b,f){if(a.data(m))return a.data(m).o[b+(f?"":"Class")]}function t(a){return a.charAt(0).toUpperCase()+a.slice(1)}function D(a,b,f,c){if(!c){if(b)a[_callback]("ifToggled");a[_callback]("ifChanged")[_callback]("if"+t(f))}}var m="iCheck",C=m+"-helper",r="radio",k="checked",y="un"+k,n="disabled";_determinate="determinate";_indeterminate="in"+_determinate;_update="update";_type="type";_click="click";_touch="touchbegin.i touchend.i";
    _add="addClass";_remove="removeClass";_callback="trigger";_label="label";_cursor="cursor";_mobile=/ipad|iphone|ipod|android|blackberry|windows phone|opera mini|silk/i.test(navigator.userAgent);f.fn[m]=function(a,b){var d='input[type="checkbox"], input[type="'+r+'"]',c=f(),g=function(a){a.each(function(){var a=f(this);c=a.is(d)?c.add(a):c.add(a.find(d))})};if(/^(check|uncheck|toggle|indeterminate|determinate|disable|enable|update|destroy)$/i.test(a))return a=a.toLowerCase(),g(this),c.each(function(){var c=
        f(this);"destroy"==a?E(c,"ifDestroyed"):A(c,!0,a);f.isFunction(b)&&b()});if("object"!=typeof a&&a)return this;var e=f.extend({checkedClass:k,disabledClass:n,indeterminateClass:_indeterminate,labelHover:!0},a),l=e.handle,v=e.hoverClass||"hover",s=e.focusClass||"focus",t=e.activeClass||"active",B=!!e.labelHover,w=e.labelHoverClass||"hover",p=(""+e.increaseArea).replace("%","")|0;if("checkbox"==l||l==r)d='input[type="'+l+'"]';-50>p&&(p=-50);g(this);return c.each(function(){var a=f(this);E(a);var c=this,
        b=c.id,g=-p+"%",d=100+2*p+"%",d={position:"absolute",top:g,left:g,display:"block",width:d,height:d,margin:0,padding:0,background:"#fff",border:0,opacity:0},g=_mobile?{position:"absolute",visibility:"hidden"}:p?d:{position:"absolute",opacity:0},l="checkbox"==c[_type]?e.checkboxClass||"icheckbox":e.radioClass||"i"+r,z=f(_label+'[for="'+b+'"]').add(a.closest(_label)),u=!!e.aria,y=m+"-"+Math.random().toString(36).substr(2,6),h='<div class="'+l+'" '+(u?'role="'+c[_type]+'" ':"");u&&z.each(function(){h+=
        'aria-labelledby="';this.id?h+=this.id:(this.id=y,h+=y);h+='"'});h=a.wrap(h+"/>")[_callback]("ifCreated").parent().append(e.insert);d=f('<ins class="'+C+'"/>').css(d).appendTo(h);a.data(m,{o:e,s:a.attr("style")}).css(g);e.inheritClass&&h[_add](c.className||"");e.inheritID&&b&&h.attr("id",m+"-"+b);"static"==h.css("position")&&h.css("position","relative");A(a,!0,_update);if(z.length)z.on(_click+".i mouseover.i mouseout.i "+_touch,function(b){var d=b[_type],e=f(this);if(!c[n]){if(d==_click){if(f(b.target).is("a"))return;
        A(a,!1,!0)}else B&&(/ut|nd/.test(d)?(h[_remove](v),e[_remove](w)):(h[_add](v),e[_add](w)));if(_mobile)b.stopPropagation();else return!1}});a.on(_click+".i focus.i blur.i keyup.i keydown.i keypress.i",function(b){var d=b[_type];b=b.keyCode;if(d==_click)return!1;if("keydown"==d&&32==b)return c[_type]==r&&c[k]||(c[k]?q(a,k):x(a,k)),!1;if("keyup"==d&&c[_type]==r)!c[k]&&x(a,k);else if(/us|ur/.test(d))h["blur"==d?_remove:_add](s)});d.on(_click+" mousedown mouseup mouseover mouseout "+_touch,function(b){var d=
        b[_type],e=/wn|up/.test(d)?t:v;if(!c[n]){if(d==_click)A(a,!1,!0);else{if(/wn|er|in/.test(d))h[_add](e);else h[_remove](e+" "+t);if(z.length&&B&&e==v)z[/ut|nd/.test(d)?_remove:_add](w)}if(_mobile)b.stopPropagation();else return!1}})})}})(window.jQuery||window.Zepto);


/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!***************************************!*\
  !*** ./WebContent/js/survey_roles.js ***!
  \***************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _app_localise__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./app/localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _app_globals__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./app/globals */ "./WebContent/js/app/globals.js");
/* harmony import */ var _libs_wb_plugins_iCheck_icheck_min__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./libs/wb/plugins/iCheck/icheck.min */ "./WebContent/js/libs/wb/plugins/iCheck/icheck.min.js");
/* harmony import */ var _libs_wb_plugins_iCheck_icheck_min__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_libs_wb_plugins_iCheck_icheck_min__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _libs_jquery_autosize_min__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./libs/jquery.autosize.min */ "./WebContent/js/libs/jquery.autosize.min.js");
/* harmony import */ var _libs_jquery_autosize_min__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_libs_jquery_autosize_min__WEBPACK_IMPORTED_MODULE_3__);
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/








const $ = window.$;

var gUserLocale = navigator.language;
if (typeof localStorage !== "undefined") {
	try {
		gUserLocale = localStorage.getItem('user_locale') || navigator.language;
	} catch (error) {
		gUserLocale = navigator.language;
	}
}
window.gUserLocale = gUserLocale;

var	gCache = {},
	gRoles,
	gIdx;

_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].initLocale(gUserLocale).then(function () {
	var i,
		params,
		pArray = [],
		param = [];

    setCustomEdit();
	setTheme();
	setupUserProfile(true);
	_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].setlang();		// Localise HTML
	
	// Get the user details
	getLoggedInUser(projectChanged, false, true, undefined, false, false);
	
	// Save a row filter
	$('#saveRowFilter').click(function() {
		gRoles[gIdx].row_filter = $('#filter_row_content').val();
		updateRole(gIdx, "row_filter", $('#row_filter_popup'));
	});
	
	// Save a column filter
	$('#saveColumnFilter').off().click(function() {
		var $this,
			question,
			column
		
		gRoles[gIdx].column_filter = [];
		$('input', '#column_select').each(function(index){
			$this = $(this);
			question = gCache[_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey][$this.val()];
			
			if($this.is(':checked')) {
				column = {
					name: question.name
				};
				gRoles[gIdx].column_filter.push(column);
			}
			
		});
		updateRole(gIdx, "column_filter", $('#column_filter_popup'));
	});
	
	$('#project_name').change(function() {
        _app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject = $(this).val();
        _app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey = 0;
		projectChanged();
	});

	// Set change function on survey
	$('#survey_name').change(function() {
		_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey = $('#survey_name option:selected').val();
		saveCurrentProject(_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject,
			_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey,
			_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentTaskGroup);	// Save the current survey id
		surveyChangedRoles();
	});
	
	$('#filter_row_aq_insert').click(function() {
		var current = $('#filter_row_content').val();
		$('#filter_row_content').val(current
				+ (current.length > 0 ? " " : "")
				+ "${"
				+ $('#filter_row_aq option:selected').val()
				+ "} ");
	});

	$('#bundle').off().on('change', function() {
		var checked = $('#bundle').prop('checked');
		if(checked) {
			if(confirm(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["ro_b_w"])) {
				// Save role settings to bundle
				applyRolesToBundle(true);
			} else {
				$('#bundle').prop('checked', false);
			}
		} else {
			applyRolesToBundle(false);
		}
	})
function projectChanged() {
	loadSurveys(_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject, undefined, false, false, surveyChangedRoles, false, undefined, undefined, true);			// Get surveys
}

function surveyChangedRoles() {
	gRoles = undefined;
    _app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey = $('#survey_name option:selected').val();
	$('#survey_name_disp').text($('#survey_name option:selected').text());
	getAllRolesForSurvey();
	
	if(!gCache[_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey]) {
		getSurveyQuestions(_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey);
	} else {
		refreshRFQuestionSelect(gCache[_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey]);
	}
	getBundleRoleSetting(_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey);
	
}

function getSurveyQuestions(sId) {
	if(sId) {
        addHourglass();
        $.ajax({
            url: "/surveyKPI/questionList/" + sId + "/none/new?exc_ssc=true&inc_meta=true",
            dataType: 'json',
            cache: false,
            success: function (data) {
                removeHourglass();
                gCache[sId] = data;
                refreshRFQuestionSelect(gCache[sId]);
            },
            error: function (xhr, textStatus, err) {
                removeHourglass();
                if (xhr.readyState == 0 || xhr.status == 0) {
                    return;  // Not an error
                } else {
                    alert(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_err_get_q"] + ": " + err);
                }
            }
        });
    }
}

function getAllRolesForSurvey() {
	
	if(gRoles) {
		refreshView();
	} else if(_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey) {
		addHourglass();
		$.ajax({
			url: "/surveyKPI/role/survey/" + _app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey,
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				gRoles = data;
				refreshView();
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
		              return;  // Not an error
				} else {
					alert(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_err_get_r"] + ": " + err);
				}
			}
		});	
	}
}

/*
 * Update the select options in the question select control
 */
function refreshRFQuestionSelect(questions) {
	var h =[],
		idx = -1,
		i,
		$element = $('#filter_row_aq');
	
	for(i = 0; i < questions.length; i++) {
		if(questions[i].toplevel) {			// Only allow top level form questions in row filter
			h[++idx] = '<option value="';
			h[++idx] = htmlEncode(questions[i].name);
			h[++idx] = '"';
			if (questions[i].id < 0) {       // Show meta in blue
				h[++idx] = ' style="color:blue"';
			}
			h[++idx] = '>';
			h[++idx] = htmlEncode(questions[i].name);

			h[++idx] = '</option>';

		}

	}
	$element.empty().append(h.join(''));
}

/*
 * Convert roles to html
 */
function refreshView() {

	var h = [],
		idx = -1,
		i,
		$element = $('#role_table'),
		hasEnabledRole = false;

	// write the table headings
	h[++idx] = '<table class="table">';
	h[++idx] = '<thead>';
	h[++idx] = '<tr>';
	h[++idx] = '<th>';
	h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_role"];
	h[++idx] = '</th>';
	h[++idx] = '<th>';
	h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_enabled"];
	h[++idx] = '</th>';
	h[++idx] = '<th>';
	h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["ro_fr"];
	h[++idx] = '</th>';
	h[++idx] = '<th>';
	h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["ro_fc"];
	h[++idx] = '</th>';
	h[++idx] = '<th>';
	h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["ro_f_group"];
	h[++idx] = '<a class="filter_help" href="https://www.smap.com.au/docs/admin-rbac.html#filter-groups" target="_blank"> ( i ) </a>';
	h[++idx] = '</th>';
	h[++idx] = '</tr>';
	h[++idx] = '</thead>';

	// Write the table body
	h[++idx] = '<body>';
	for (i = 0; i < gRoles.length; i++) {

		h[++idx] = '<tr>';
		h[++idx] = '<td>';
		h[++idx] = htmlEncode(gRoles[i].name);
		h[++idx] = '</td>';
		h[++idx] = '<td>';
		h[++idx] = '<div class="btn-group btn-toggle enable" data-idx="';
		h[++idx] = i;
		h[++idx] = '">';
		h[++idx] = '<button class="btn btn-xs norole ';
		if (!gRoles[i].enabled) {
			h[++idx] = 'btn-danger active"';
		} else {
			h[++idx] = 'btn-default"';
		}
		h[++idx] = '>';
		h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_no"];
		h[++idx] = '</button>';
		h[++idx] = '<button class="btn btn-xs yesrole ';
		if (!gRoles[i].enabled) {
			h[++idx] = 'btn-default"';
		} else {
			h[++idx] = 'btn-success active"';
		}
		h[++idx] = '>';
		h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_yes"];
		h[++idx] = '</button>';
		h[++idx] = '</div>';
		h[++idx] = '<td>';
		h[++idx] = '<button class="btn btn-xs row_filter';
		if (!gRoles[i].enabled) {
			h[++idx] = ' disabled';
		}
		if (gRoles[i].restrict_row) {
			h[++idx] = ' btn-success';
		}
		h[++idx] = '">';
		h[++idx] = '<i class="fa fa-filter" aria-hidden="true"></i>';
		h[++idx] = '</button>';
		h[++idx] = '</td>';
		h[++idx] = '<td>';
		h[++idx] = '<button class="btn btn-xs column_filter';
		if (!gRoles[i].enabled) {
			h[++idx] = ' disabled';
		}
		if (gRoles[i].restrict_row) {
			h[++idx] = ' btn-success';
		}
		h[++idx] = '">';
		h[++idx] = '<i class="fa fa-filter" aria-hidden="true"></i>';
		h[++idx] = '</button>';
		h[++idx] = '</td>';
		h[++idx] = '<td>';
		h[++idx] = '<div class="btn-group btn-toggle role_group';
		if (!gRoles[i].enabled) {
			h[++idx] = ' disabled';
		}
		h[++idx] = '" data-idx="';
		h[++idx] = i;
		h[++idx] = '">';
		h[++idx] = '<button class="btn btn-xs groupA ';
		if (gRoles[i].role_group === 'A') {
			h[++idx] = 'btn-success active';
		} else {
			h[++idx] = 'btn-default';
		}
		if (!gRoles[i].enabled) {
			h[++idx] = ' disabled';
		}
		h[++idx] = '">A</button>';
		h[++idx] = '<button class="btn btn-xs groupB ';
		if (gRoles[i].role_group === 'B') {
			h[++idx] = 'btn-danger active';
		} else {
			h[++idx] = 'btn-default';
		}
		if (!gRoles[i].enabled) {
			h[++idx] = ' disabled';
		}
		h[++idx] = '">B</button>';
		h[++idx] = '</div>';
		h[++idx] = '</td>';
		h[++idx] = '</tr>';

		if (gRoles[i].enabled) {
			hasEnabledRole = true;
		}
	}
	h[++idx] = '</body>';
	h[++idx] = '</table>';

	$element.html(h.join(''));

	$('.enable', $element).off().click(function () {
		var $this = $(this),
			idx;

		$this.find('.btn').toggleClass('active').removeClass("btn-success btn-danger").addClass("btn-default");
		$this.find('.yesrole.active').addClass("btn-success").removeClass("btn-default");
		$this.find('.norole.active').addClass("btn-danger").removeClass("btn-default");

		idx = $this.data("idx");
		gRoles[idx].enabled = !gRoles[idx].enabled;
		updateRole(idx, "enabled", undefined);

		$this.closest('tr').find('.row_filter, .column_filter, .role_group, .groupA, .groupB').toggleClass("disabled");

		setInfoMsg();
	});

	// Row filtering logic
	$('.row_filter', $element).off().click(function () {
		var $this = $(this);

		if (!$this.hasClass("disabled")) {
			gIdx = $this.closest('tr').find('.btn-group').data("idx");
			$('#filter_row_content').val(gRoles[gIdx].row_filter);
			$('#row_filter_popup').modal("show");
		}
	});

	// Column filtering logic
	$('.column_filter', $element).off().click(function () {
		var $this = $(this);

		if (!$this.hasClass("disabled")) {
			gIdx = $this.closest('tr').find('.btn-group').data("idx");
			if (!gRoles[gIdx].column_filter) {
				gRoles[gIdx].column_filter = [];
			}
			refreshColumnSelect(gCache[_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey], gRoles[gIdx].column_filter);
			$('#column_filter_popup').modal("show");
		}
	});

	// filter type
	$('.role_group', $element).off().click(function () {
		var $this = $(this);

		$this.find('.btn').toggleClass('active').removeClass("btn-success btn-danger").addClass("btn-default");
		$this.find('.groupA.active').addClass("btn-success").removeClass("btn-default");
		$this.find('.groupB.active').addClass("btn-danger").removeClass("btn-default");

		idx = $this.data("idx");
		if (gRoles[idx].role_group === 'A') {
			gRoles[idx].role_group = 'B';
		} else {
			gRoles[idx].role_group = 'A';
		}
		updateRole(idx, "role_group", undefined);

	});

	if (hasEnabledRole) {
		$('#roles_alert').html(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_has_roles"]);
	} else {
		$('#roles_alert').html(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_no_roles"]);
	}

}

	/*
     * Update the table that shows enabled columns for this role
     * Filter columns are assumed to be in the same order as questions
     */
function refreshColumnSelect(questions, filter_columns) {
	
	var h =[],
	idx = -1,
	i, j,
	$element = $('#column_select');

	h[++idx] = '<table class="table">';
	h[++idx] = '<thead>';
	h[++idx] = '<th>';
		h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_question"];
	h[++idx] = '</th>';
	h[++idx] = '<th>';
	h[++idx] = '</th>';
	h[++idx] = '<th>';
		h[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_enabled"];
	h[++idx] = '</th>';
	h[++idx] = '</thead>';
	h[++idx] = '<tbody>';

	for(i = 0; i < questions.length; i++) {
		h[++idx] = '<tr>';
		h[++idx] = '<td>';
			h[++idx] = htmlEncode(questions[i].name);
		h[++idx] = '</td>';
		h[++idx] = '<td>';
			h[++idx] = htmlEncode(questions[i].q);
			h[++idx] = '</td>';
		h[++idx] = '<td><span class="colgroup"><input type="checkbox" name="colgroup" value="';
		h[++idx] = i;
		h[++idx] = '"';
		
		// See if this question has been included in the filter columns
		j = 0;
		while(j < filter_columns.length) {
			if(filter_columns[j].name ==  questions[i].name) {
				h[++idx] = ' checked';
				break;
			}
			j++;
		}
		
		h[++idx] = '></span></td>';
		h[++idx] = '</tr>';
	}
	h[++idx] = '</tbody>';
	h[++idx] = '</table>';
	
	$element.empty().append(h.join(''));
	
	$('input', $element).iCheck({
	    checkboxClass: 'icheckbox_square-green',
	    radioClass: 'iradio_square-green'
	});
}

function setInfoMsg() {
	var i,
		hasEnabledRole = false;
	
	for(i = 0; i < gRoles.length; i++) {
		if(gRoles[i].enabled) {
			hasEnabledRole = true;
		}
	}
	if(hasEnabledRole) {
		$('#roles_alert').html(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_has_roles"]);
	} else {
		$('#roles_alert').html(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_no_roles"]);
	}
}

/*
 * Update a role
 */
function updateRole(idx, property, $popup) {
	
	addHourglass();
	$.ajax({
		  type: "POST",
		  contentType: "application/x-www-form-urlencoded",
		  cache: false,
		  url: "/surveyKPI/role/survey/" + _app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey + "/" + property,
		  data: { 
			  role: JSON.stringify(gRoles[idx])
			  },
		  success: function(data, status) {
			  removeHourglass();
			  if(handleLogout(data)) {
				  gRoles[idx].linkid = data.linkid;		// Record the id of survey/role entity
				  if(property === "enabled") {		// Newly enabled get any synchronised properties
					  gRoles[idx].row_filter = data.row_filter;
					  gRoles[idx].column_filter = data.column_filter;
					  if(data.role_group) {
						  gRoles[idx].role_group = data.role_group;
						  var $g = $('#role_table .role_group[data-idx=' + idx + ']')

						  $g.find('.btn').removeClass('active').removeClass("btn-success btn-danger").addClass("btn-default");
						  $g.find('.group' + data.role_group).addClass('active');
						  $g.find('.groupA.active').addClass("btn-success").removeClass("btn-default");
						  $g.find('.groupB.active').addClass("btn-danger").removeClass("btn-default");
					  }
				  }

				  if($popup) {
					  $popup.modal("hide");
				  }
			  }

		  }, error: function(data, status) {
			  removeHourglass();
			  if(data && data.responseText) {
				  alert(data.responseText);
			  } else {
				  alert(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_u_f"]);
			  }
		  }
	});
}

  /*
   * Get the roles setting for the bundle
   */
	function getBundleRoleSetting(sId) {
		addHourglass();
		$.ajax({
			url: "/surveyKPI/bundle/settings/" + sId,
			dataType: 'json',
			cache: false,
			success: function (data) {
				removeHourglass();
				if(handleLogout(data)) {
					$('#bundle').prop('checked', data.bundleRoles);
				}
			},
			error: function (xhr, textStatus, err) {
				removeHourglass();
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_err_get_q"] + ": " + err);
				}
			}
		});
	}

	/*
     * The checkbox has been set, or unset, to apply all roles to the bundle
     */
	function applyRolesToBundle(value) {

		addHourglass();
		$.ajax({
			type: "POST",
			contentType: "application/x-www-form-urlencoded",
			cache: false,
			data: {
				sId: $('#survey_name').val(),
				value: value
			},
			url: "/surveyKPI/role/survey/bundle",
			success: function (data, status) {
				removeHourglass();
				if (handleLogout(data)) {
					if(value) {
						alert(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["ro_b_d"]);
						}
				}

			}, error: function (data, status) {
				removeHourglass();
				if (data && data.responseText) {
					alert(data.responseText);
				} else {
					alert(_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_u_f"]);
				}
			}
		});
	}
});
})();

/******/ })()
;