/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./WebContent/js/app/aws.js"
/*!**********************************!*\
  !*** ./WebContent/js/app/aws.js ***!
  \**********************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globals */ "./WebContent/js/app/globals.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Functions for using aws services
 *
 */



var gLanguages;





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	setLanguageSelect: setLanguageSelect
});

		function setLanguageSelect ($elem, type, callback) {

			if(gLanguages) {
					updateSelection($elem, type, callback);
			} else {
					getLanguages($elem, type, callback);
			}
		}

		function updateSelection($elem, type, callback) {
			var h = [],
				idx = -1,
				i;

			for(i = 0; i < gLanguages.length; i++) {
				if(gLanguages[i][type]) {
					h[++idx] = '<option value="';
					h[++idx] = gLanguages[i].code;
					h[++idx] = '">';
					h[++idx] = htmlEncode(gLanguages[i].name);
					h[++idx] = '</option>';
				}
			}
			$elem.empty().html(h.join(''));
			if(typeof callback === "function") {
				callback();
			}
		}

		function getLanguages($elem, type, callback) {
			addHourglass();
			jquery__WEBPACK_IMPORTED_MODULE_0___default().ajax({
				url: "/surveyKPI/language_codes",
				dataType: 'json',
				cache: false,
				success: function(data) {
					removeHourglass();
					var $e = $elem;
					var t = type;
					var cb = callback;
					gLanguages = data;
					updateSelection($e, t, cb);
				},
				error: function(xhr, textStatus, err) {
					removeHourglass();
					if(xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + ": " + err);
					}
				}
			});
		}


/***/ },

/***/ "./WebContent/js/app/changeset.js"
/*!****************************************!*\
  !*** ./WebContent/js/app/changeset.js ***!
  \****************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globals */ "./WebContent/js/app/globals.js");
/* harmony import */ var _editorMarkup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./editorMarkup */ "./WebContent/js/app/editorMarkup.js");
/* harmony import */ var _option__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./option */ "./WebContent/js/app/option.js");
/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Module to manage the changeset of changes for editor
 */









let modelGeneratedChanges = [];

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
    add: add,
    undo: undo,
    save: save,
    setHasChanges: setHasChanges,
    addValidationError: addValidationError,
    removeValidationError: removeValidationError,
    validateItem: validateItem,
    validateName: validateName,
    updateModelWithErrorStatus: updateModelWithErrorStatus,
    validateAll: validateAll,
    numberIssues: numberIssues,
    addUpdateMessage: addUpdateMessage,
    updateViewControls: updateViewControls
});

		/*
		 * Add a new change item
		 */
        function add(change) {
            var refresh,
                $context,
                container,
                itemIndex,
                itemType;

            // Apply to model
            modelGeneratedChanges = [];
            refresh = updateModel(change);

			/*
			 * Validate updated model
			 */
            if(change.changeType === "property" || change.changeType === "label") {

                if (change.property.type === "option") {
                    container = change.property.optionList;
                    itemType = "option";
                } else {
                    container = change.property.formIndex;
                    itemType = "question";
                }
                itemIndex = change.property.itemIndex;

            } else if(change.changeType === "option") {

                container = change.option.optionList;
                itemIndex = change.option.itemIndex;
                itemType = "option";

            } else if(change.changeType === "question") {

                container = change.question.formIndex;
                itemIndex = change.question.itemIndex;
                itemType = "question";

            }
            if(typeof itemIndex !== "undefined") {		// Note some changes do not have an itemIndex and don't need to be validated

                validateItem(container, itemIndex, itemType, true);
            }

			/*
			 * Apply any HTML changes either directly to the changed element, or by refreshing the whole form using
			 * the updated model
			 */
            if(change.action === "delete" && typeof change.question !== "undefined") {
                $context = undefined;
                change.question.$deletedElement.prev().remove();		// remove the add new button
                change.question.$deletedElement.remove();
            } else {
                if(refresh) {
                    if(change.question || change.changeType === "optionlist" || (change.property && change.property.type === "question")) {
                        $context = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].refresh();
	                    validateAll();
                    } else {
                        $context = _option__WEBPACK_IMPORTED_MODULE_4__["default"].createChoiceView();
                        var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;
                        var question = survey.forms[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFormIndex].questions[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gItemIndex];
                        _option__WEBPACK_IMPORTED_MODULE_4__["default"].addOptionTable(question, _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFormIndex, _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gListName);
                        _option__WEBPACK_IMPORTED_MODULE_4__["default"].setupChoiceView(jquery__WEBPACK_IMPORTED_MODULE_0___default()('#filterType').val());
                    }
                } else {
                    $context = updateHtmlElement(change);
                }
            }

            // Add to changeset array ready for writing to the database
            addToChangesetArray(change);

            // Add any additional changes generated in the model
            for(var i = 0; i < modelGeneratedChanges.length; i++) {
                addToChangesetArray(modelGeneratedChanges[i]);
            }

            return $context;

        }

        function undo() {
        }

        // Save the survey
        function save(callback) {

            var url="/surveyKPI/surveys/save/" + _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentSurvey,
                changesString,
                changesInSeq = resequenceChangeSet(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes),
                i, j,
                item;

            // newVal and oldVal cannot be objects so if this is a property update
            // for a server calculation then they need to be stringified
            if(changesInSeq) {
                for(i = 0; i < changesInSeq.length; i++) {
                    if(changesInSeq[i].changeType === "property") {
                        for(j = 0; j < changesInSeq[i].items.length; j++) {
                            item = changesInSeq[i].items[j];
                            if(item.property && item.property.prop == 'server_calculation') {
                                if(item.property.oldVal && item.property.oldVal.expression) {
                                    item.property.oldVal = JSON.stringify(item.property.oldVal);
                                }
                                if(item.property.newVal  && item.property.newVal.expression) {
                                    item.property.newVal = JSON.stringify(item.property.newVal);
                                }
                            }
                        }
                    }
                }
            }
            changesString = JSON.stringify(changesInSeq);

            addHourglass();
            jquery__WEBPACK_IMPORTED_MODULE_0___default().ajax({
                url: url,
                type: 'PUT',
                dataType: 'json',
                cache: false,
                data: { changes: changesString },
                success: function(data) {
                    var responseFn = callback,
                        h = [],
                        idx = -1,
                        i;

                    removeHourglass();
                    _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSaveInProgress = false;
                    if(handleLogout(data)) {

                        setHasChanges(0);

                        if (typeof responseFn === "function") {
                            responseFn();
                        }

                        // Report success and failure
                        _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.lastChanges = data.changeSet;
                        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#successLabel .counter').html(data.success);
                        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#failedLabel .counter').html(data.failed);

                        if (data.success > 0) {
                            h[++idx] = '<div class="alert alert-success" role="alert">';
                            h[++idx] = '<p>';
                            h[++idx] = data.success;
                            h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_upd"];
                            h[++idx] = '</p>'
                            h[++idx] = '<ol>';
                            for (i = 0; i < data.changeSet.length; i++) {
                                h[++idx] = addUpdateMessage(data.changeSet[i], false);
                            }
                            h[++idx] = '</ol>';
                            h[++idx] = '</div>';
                        }
                        if (data.failed > 0) {
                            h[++idx] = '<div class="alert alert-danger" role="alert">';
                            h[++idx] = data.failed;
                            h[++idx] = " changes failed";
                            h[++idx] = '<ol>';
                            for (i = 0; i < data.changeSet.length; i++) {
                                h[++idx] = addUpdateMessage(data.changeSet[i], true);
                            }
                            h[++idx] = '</ol>';
                            h[++idx] = '</div>';
                        }

                        window.bootbox.alert(h.join(""));
                    }

                },
                error: function(xhr, textStatus, err) {
                    removeHourglass();
                    if(handleLogout(xhr.responseText)) {
                        _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSaveInProgress = false;

                        if (typeof responseFn === "function") {
                            responseFn();
                        }

                        if (xhr.readyState == 0 || xhr.status == 0) {
                            // Not an error
                        } else {
                            window.bootbox.alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_save"] + ' ' + err);
                        }
                    }
                }
            });

        }

        /*
         * Resequence a change array to allign with the sequences in the model
         */
        function resequenceChangeSet(changes) {

            var fo = [],
                i,
                newSeq = [];

            for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms.length; i++) {
                fo.push({});
            }

            // Set the sequence nuber as per the model
            for(i = 0; i < changes.length; i++) {
                if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].changeType === "question") {
                    var question = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].question;
                    if(question && _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].action === "add") {
                        var form = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms[question.formIndex];
                        for (var j = 0; j < form.qSeq.length; j++) {
                            if(form.qSeq[j] == question.itemIndex) {
                                question.seq = j;
                                fo[question.formIndex]["q"+j] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i];
                                break;
                            }
                        }
                    }
                }
            }

            // Put the question changes in the order of their sequence numbers
            for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms.length; i++) {
                var form = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms[i];
                for (var j = 0; j < form.qSeq.length; j++) {
                    if(fo[i]["q"+j]) {
                        newSeq.push(fo[i]["q"+j]);
                    }
                }
            }

            // Add any other changes
            for(i = 0; i < changes.length; i++) {
                if (_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].changeType !== "question"
                    || typeof _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].question === "undefined"
                    || _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].action !== "add"
                ) {
                    newSeq.push(changes[i]);
                }
            }

            return newSeq;

        }

		/*
		 * Add a single change item to the array of changes (changeset)
		 */
        function addToChangesetArray(change) {

            var type = change.property ? change.property.type : undefined;

            var ci = {
                    changeType: change.changeType,
                    type: type,
                    action: change.action,
                    items: []
                },
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                item,
                item_orig,
                forms_orig,
                optionListOrig,
                form,
                applyChange = true,
                changes = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes;

            // Delete any items containing jquery elements
            if(change.question) {
                delete change.question.$relatedElement;
                delete change.question.$deletedElement;
            }

			/*
			 * Add additional parameters to change object
			 */
            if(change.changeType === "label" || change.changeType === "property") {
                if(change.property.type === "question") {
                    item = survey.forms[change.property.formIndex].questions[change.property.itemIndex];
                    if(survey.forms_orig) {
                        forms_orig = survey.forms_orig[change.property.formIndex];
                        if (forms_orig) {
                            item_orig = forms_orig.questions[change.property.itemIndex];
                        }
                    }
                    change.property.name = item.name;
                    change.property.qId = item.id;
                    change.property.fId = item.fId;
                    change.property.childFormIndex = survey.forms.length - 1;
                    if(change.changeType === "property") {
                        setTypeSpecificChanges(change.property.prop, change, survey);
                    }
                } else if(change.property.type === "option") {
                    item = survey.optionLists[change.property.optionList].options[change.property.itemIndex];
                    optionListOrig = survey.optionLists_orig[change.property.optionList];
                    if(optionListOrig) {
                        item_orig = optionListOrig.options[change.property.itemIndex];
                    }
                    change.property.name = item.value;
                    change.property.o_id = item.id;
                    //if(change.changeType === "property") {
                    //	setOptionTypeSpecificChanges(change.property.prop, change, survey);
                    //}
                }

                if(change.changeType === "label") {
                    if(item_orig) {
                        change.property.oldVal = item_orig.labels[change.property.language][change.property.propType];
                    }

                    // Add a reference for the label
                    form = survey.forms[change.property.formIndex];
                    if(change.property.prop === "label" || change.property.prop === "media" && item.text_id) {
                        change.property.key = item.text_id;
                    } else if(change.property.prop === "hint" && item.hint_id) {
                        change.property.key = item.hint_id;
                    } else {
                        // Create reference for this new Label
                        if(change.property.type === "question") {
                            change.property.key = getFormPath(form) + "/" + item.name +
                                (change.property.prop === "hint" ? ":hint" : ":label");
                        } else if(change.property.type === "option") {
                            change.property.key = getFormPath(form) + "/" + change.property.qname + "/" + item.value + ":label";
                            change.property.o_id = item.id;
                        }
                    }
                } else {
                    if(item_orig) {
                        if(change.property.prop === "app_choices") {
                            change.property.oldVal = window.gAppChoiceArray.join(' ');
                        } else {
                            change.property.oldVal = item_orig[change.property.prop];
                        }
                    }
                }

                change.property.languageName = survey.languages[change.property.language].name;			// For logging the event

            } else if(change.changeType === "question") {
                form = survey.forms[change.question.formIndex];
                change.question.fId = form.id;
                if(change.action === "delete") {
                    item = survey.forms[change.question.formIndex].questions[change.question.itemIndex];
                    change.question.id = item.id;
                    change.question.name = item.name;
                    change.question.path = item.path;
                }
                //else {
                //	change.question.path = getFormPath(form) + "/" + change.question.name;
                //}
            } else if(change.changeType === "option") {
                if(change.action === "delete") {
                    item = survey.optionLists[change.option.optionList].options[change.option.itemIndex];
                    change.option.value = item.value;
                }
            }


			/*
			 * Add the change item to the array
			 */
            ci.items.push(change);
            if(change.action !== "add") {
                applyChange = removeDuplicateChange(changes, ci);
            }

			/*
			 * If this is a property update and the property is cascade_filters then convert to a string
			 * Filter values should be saved as a json string
			 */
            if(change.property) {
                if(change.property.type === "option" && change.property.prop === "cascade_filters") {
                    change.property.newVal = JSON.stringify(change.property.newVal);
                    change.property.oldVal = JSON.stringify(change.property.oldVal);
                }
            }

            if(applyChange) {
                if(change.property && (change.property.newVal !== change.property.oldVal)) {		// Add if the value has changed
                    changes.push(ci);
                } else if(change.action === "add" || change.action === "delete" || change.action === "move") {
                    changes.push(ci);
                }
            }
            setHasChanges(changes.length);

        }

		/*
		 * Annotate a change item with changes that are dependent on the type of the property
		 */
        function setTypeSpecificChanges(type, change, survey) {
            var i;
            if(type === "type") {
                var typeList = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.qTypes;

                for(i = 0; i < typeList.length; i++) {
                    if(change.property.newVal === typeList[i].type) {
                        change.property.setVisible = true;
                        change.property.visibleValue = typeList[i].visible;
                        change.property.sourceValue = typeList[i].source;
                        break;
                    }
                }
            }
        }

		/*
		 * Remove duplicate updates.  This simplifies the analysis of changes to a survey
		 * For example if the user sets the label to "x", then changes it to "y" the change recorded should only be "y"
		 */
        function removeDuplicateChange(changes, change) {

            var j,
                item,
                element,
                newItem,
                newElement,
                newElementType,
                elementType;

            newItem = change.items[0];
            if(newItem.question) {
                newElement = newItem.question;
                newElementType = "question";
            } else if(newItem.option) {
                newElement = newItem.option;
                newElementType = "option";
            } else if(newItem.property) {
                newElement = newItem.property;
                newElementType = newElement.type;
            } else if(newItem.changeType === "optionlist") {
                newElement = {
                    itemIndex: newItem.name
                };
                newElementType = newItem.changeType;
            }

            for(j = 0; j < changes.length; j++) {

                item = changes[j].items[0];
                if(item.question) {
                    element = item.question;
                    elementType = "question";
                } else if(item.option) {
                    element = item.option;
                    elementType = "option";
                } else if(item.property) {
                    element = item.property;
                    elementType = element.type;
                } else if(item.changeType === "optionlist") {
                    element = {
                        itemIndex: item.name
                    };
                    elementType = newItem.changeType;
                }

				/*
				 * Only remove duplicates if
				 * 		- The new and existing element types are the same, ie both question or both option
				 * 		- They refer to the same item
				 */
                if(elementType === newElementType && newElement.itemIndex === element.itemIndex) {
                    if((newElementType === "question" && newElement.formIndex === element.formIndex) ||
                        (newElementType === "option" && newElement.optionList === element.optionList) ||
                        (newElementType === "optionlist")) {

                        console.log("Update to an item that is already in the update queue");


						/*
						 * 1. If this is a property update and there is already another update to
						 * 		- the same property
						 *    then remove the first update
						 */
                        if(newItem.action === "update" 	&& newItem.changeType === "property"
                            && item.changeType === "property") {

                            if(newElement.prop === element.prop) {
                                changes.splice(j,1);	// Remove the old item and apply the new one
                                return true;
                            }

							/*
							 * 2. If this is a label update and there is already another update to
							 * 		- the same language
							 * 		- the same label type (in the propType attribute)
							 *    then remove the first update
							 */
                        } else if(newItem.action === "update" 	&& newItem.changeType === "label"
                            && item.changeType === "label") {

                            if(newElement.languageName === element.languageName &&
                                newElement.propType === element.propType) {
                                changes.splice(j,1);	// Remove the old item and apply the new one
                                return true;
                            }

							/*
							 * 3. If this is an update to a property or label and
							 *      - the existing item is newly added then
							 * 		- merge the update into the added item
							 */
                        } else if(newItem.action === "update"
                            && ((elementType === "question" && typeof element.qId === "undefined") ||
                            (elementType === "option" && item.action === "add"))
                            && (newItem.changeType === "label" || newItem.changeType === "property")) {

                            if(newItem.changeType === "label") {

                                if(!element.labels) {
                                    element.labels = [];
                                }
                                if(!element.labels[newElement.language]) {
                                    element.labels[newElement.language] = {};
                                }
                                element.labels[newElement.language][newElement.propType] = newElement.newVal;

                            } else {

                                element[newElement.prop] = newElement.newVal;

                            }

                            if(elementType === "question") {
                                if(newElement.prop === "name") {
                                    element["path"] = newElement.path;
                                }
                            } else {
                                if(newElement.prop === "value") {
                                    element["path"] = newElement.path;
                                }
                            }

                            return false;		// Don't apply the change it has been merged

							/*
							 * 4. If this is a move of an item
							 */
                        } else if(newItem.action === "move") {
							/*
							 * Remove any modifications to this deleted element
							 */
                            element.seq = newElement.seq;
                            return false;


							/*
							 * 5. If this is a delete of an item
							 */
                        } else if(newItem.action === "delete") {
							/*
							 * Remove any modifications to this deleted element
							 * If the item is a group question then also remove its group end
							 */
                            changes.splice(j,1);	// Remove this item
                            return true;

                        }
                    }
                }
            }

            return true;
        }

		/*
		 * Update settings when the number of changes to apply changes
		 */
        function setHasChanges(numberChanges) {

            if(numberChanges === 0) {
                _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes = [];
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_save_survey').addClass("disabled").prop("disabled", true).find('.badge').html(numberChanges);
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_languages,#m_required,#m_not_required').removeClass("disabled").prop("disabled", false);
            } else {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_save_survey').find('.badge').html(numberChanges);
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_languages,#m_required,#m_not_required').addClass("disabled").prop("disabled", true);
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_validate').removeClass("disabled").prop("disabled", false);
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_save_survey').removeClass("disabled").prop("disabled", false);
                //if(numberIssues("error") === 0) {
                //	$('.m_save_survey').removeClass("disabled").prop("disabled", false);
                //}
            }

        }


		/*
		 * Update the in memory model
		 */
        function updateModel(change) {
            var refresh = false,		// Set to true if the page needs to be refreshed with this change
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                question,
                theOption,
                property,
                length,
                i, j;

            if(change.property) {
				/*
				 * Update the property values
				 */
                property = change.property;

                if(property.type === "question") {			// Change to a question
                    question = survey.forms[property.formIndex].questions[property.itemIndex];
                    if(property.propType === "text" || property.propType === "hint") {		// Not a media change

                        if(property.prop === "label" || property.prop === "hint") {	   // Changing the label or hint

                            question.labels[property.language][property.propType] = property.newVal;

                        } else {						// Other properties, such as constraints, relevance question name

                            var oldVal;
                            if(property.prop === "app_choices") {
                                oldVal = window.gAppChoiceArray.join[' '];
                            } else {
                                oldVal = question[property.prop];
                            }
                            question[property.prop] = property.newVal;


                            if(property.setVisible) {
                                question["visible"] = property.visibleValue;
                                question["source"] = property.sourceValue;
                            }

							/*
							 * Set type dependent properties
							 */
                            if(property.prop === "type" || property.prop === "name") {

                                if(property.newVal.indexOf("select") == 0 || question.type.indexOf("select") == 0 ||
                                    property.newVal === "rank" || question.type === "rank") {	// Select question

                                    // Ensure there is a list name for this question
                                    if(!question.list_name && question.name) {
                                        question.list_name = question.name;
                                    }

                                    // Ensure there is a list of choices
                                    if(question.list_name) {
                                        var optionList = survey.optionLists[question.list_name];
                                        if(!optionList) {
                                            survey.optionLists[question.list_name] = {
                                                oSeq: [],
                                                options: []
                                            };
                                            _option__WEBPACK_IMPORTED_MODULE_4__["default"].refreshOptionListControls();
                                        }
                                    }

                                }
                            }


                            if(property.prop === "type") {

                                if(property.newVal == "begin repeat") {
                                    // New sub form
                                    survey.forms.push({
                                        id: undefined,
                                        name: survey.forms[property.formIndex].questions[property.itemIndex].name,  // name of question
                                        parentQuestionIndex: property.itemIndex,
                                        parentFormIndex: property.formIndex,
                                        questions: [],
                                        qSeq: []
                                    });
                                    question.childFormIndex = survey.forms.length - 1;

                                }

                                // Fix ups depending on oldVal
                                var newFormIdx;
                                var oldFormIdx;
                                var endQuestionIdx;
                                var groupMembers = [];
                                var mvStartIdx;
                                var itemIndex;
                                if(oldVal === "note") {
                                    // Remove the readonly status
                                    modelGeneratedChanges.push({
                                        changeType: "property",
                                        action: "update",
                                        source: "editor",
                                        property: {
                                            type: "question",
                                            prop: "readonly",
                                            newVal: false,
                                            language: property.language,
                                            formIndex: property.formIndex,
                                            itemIndex: property.itemIndex
                                        }
                                    });
                                    question.readonly = false;
                                } else if(oldVal === "begin group") {
                                    console.log("xxxxxxx fix up begin group");
                                    if(property.newVal === "begin repeat") {
                                        console.log("xxxxxxx move questions to repeat");
                                        // Move the questions in the group to the new form
                                        newFormIdx = question.childFormIndex;
                                        oldFormIdx = property.formIndex;
                                        oldLocation = property.itemIndex;
                                        newLocation = 0;
                                        endQuestionIdx = 0;

                                        name = question.name;
                                        endName = name + "_groupEnd";

										/*
										 * Get the questions to move
										 * Start from one past the begin group
										 */
                                        oldLocation++;
                                        for(i = oldLocation; i < survey.forms[oldFormIdx].qSeq.length; i++) {

                                            // Don't include the group end or any questions after it
                                            if(survey.forms[oldFormIdx].questions[survey.forms[oldFormIdx].qSeq[i]].name.toLowerCase() === endName.toLowerCase()) {
                                                endQuestionIdx = i;
                                                break;
                                            }
                                            groupMembers.push(survey.forms[oldFormIdx].qSeq[i]);
                                        }

										/*
										 * Move the group members
										 */
                                        mvStartIdx = oldLocation;
                                        for(i = 0; i < groupMembers.length; i++) {

                                            itemIndex = moveQuestion(survey, survey.forms[oldFormIdx].questions[groupMembers[i]],
                                                newFormIdx,
                                                newLocation++,
                                                oldFormIdx,
                                                mvStartIdx++);

                                            // Add the move to the changeset
                                            modelGeneratedChanges.push({
                                                changeType: "question",
                                                action: "move",
                                                source: "editor",
                                                question: {

                                                    type: survey.forms[oldFormIdx].questions[groupMembers[i]].type,
                                                    formIndex: newFormIdx,
                                                    itemIndex: itemIndex,
                                                    sourceFormIndex: oldFormIdx,
                                                    sourceItemIndex: survey.forms[oldFormIdx].questions[groupMembers[i]].itemIndex,
                                                    sourceFormId: survey.forms[oldFormIdx].id,
                                                    name: survey.forms[oldFormIdx].questions[groupMembers[i]].name
                                                }
                                            });

                                            console.log("xxxxx moved");
                                        }

                                    }
                                    console.log("xxxxxxx remove end group");
                                    applyToEndGroup(survey.forms[oldFormIdx], question.name, oldLocation, "delete", undefined, undefined);
                                    refresh = true;
                                } else if(oldVal === "begin repeat") {
                                    console.log("xxxxxxx fix up begin repeat");
                                    if(property.newVal === "begin group") {
                                        console.log("xxxxxxx move questions to group");

                                        // Move the questions in the repeat to the group
                                        newFormIdx = property.formIndex;
                                        newLocation = property.itemIndex + 1; // After the begin group
                                        oldLocation = 0;
                                        endQuestionIdx = 0;
                                        oldFormIdx = getSubFormIndex(newFormIdx, property.itemIndex);

                                        name = question.name;
                                        endName = name + "_groupEnd";

										/*
										 * Get the questions to move
										 */
                                        groupMembers = [];
                                        for(i = oldLocation; i < survey.forms[oldFormIdx].qSeq.length; i++) {
                                            groupMembers.push(survey.forms[oldFormIdx].qSeq[i]);
                                        }

										/*
										 * Move the group members
										 */
                                        mvStartIdx = oldLocation;
                                        for(i = 0; i < groupMembers.length; i++) {

                                            itemIndex = moveQuestion(survey, survey.forms[oldFormIdx].questions[groupMembers[i]],
                                                newFormIdx,
                                                newLocation++,
                                                oldFormIdx,
                                                mvStartIdx++);

                                            // Record the group that this question has been added to
                                            survey.forms[newFormIdx].questions[survey.forms[newFormIdx].qSeq[newLocation - 1]].memberGroup = name;

                                            // Add the move to the changeset
                                            modelGeneratedChanges.push({
                                                changeType: "question",
                                                action: "move",
                                                source: "editor",
                                                question: {

                                                    type: survey.forms[oldFormIdx].questions[groupMembers[i]].type,
                                                    formIndex: newFormIdx,
                                                    itemIndex: itemIndex,
                                                    sourceFormIndex: oldFormIdx,
                                                    sourceItemIndex: survey.forms[oldFormIdx].questions[groupMembers[i]].itemIndex,
                                                    sourceFormId: survey.forms[oldFormIdx].id,
                                                    name: survey.forms[oldFormIdx].questions[groupMembers[i]].name
                                                }
                                            });

                                            console.log("yyyy moved");
                                        }

                                    }
                                    refresh = true;
                                }


                            } else if(property.prop === "name") {
                                // update the end group name
                                if(survey.forms[property.formIndex].questions[property.itemIndex].type === "begin group") {
                                    applyToEndGroup(survey.forms[property.formIndex],
                                        oldVal, 0, "rename", property.newVal, undefined);

                                }
                            }

							/*
							 * If this is a change to a begin group then refresh the entire form
							 */
                            if(survey.forms[property.formIndex].questions[property.itemIndex].type === "begin group") {
                                refresh = true;
                            }


                        }

                    } else {
                        // For non text changes update all languages
                        for(i = 0; i < survey.forms[property.formIndex].questions[property.itemIndex].labels.length; i++) {
                            survey.forms[property.formIndex].questions[property.itemIndex].labels[i][property.propType] = property.newVal;
                            survey.forms[property.formIndex].questions[property.itemIndex].labels[i][property.propType + "Url"] =
                                _getUrl(property.newVal, false, property.propType, property.isSurveyLevel, survey.id);
                        }
                    }
                } else if(property.type === "option") {	// Change to an option

                    theOption = survey.optionLists[property.optionList].options[property.itemIndex];
                    theOption[property.prop] = property.newVal;

                    if(property.propType === "text") {
                        if(property.prop === "label") {
                            survey.optionLists[property.optionList].options[property.itemIndex].labels[property.language][property.propType] = property.newVal;
                        }
                    } else {
                        // For non text changes update all languages
                        for(i = 0; i < survey.optionLists[property.optionList].options[property.itemIndex].labels.length; i++) {
                            survey.optionLists[property.optionList].options[property.itemIndex].labels[i][property.propType] = property.newVal;
                            survey.optionLists[property.optionList].options[property.itemIndex].labels[i][property.propType + "Url"] =
                                _getUrl(property.newVal, false, property.propType, property.isSurveyLevel, survey.id);
                        }
                    }
                } else if(property.type === "optionlist") {	// Change to an optionlist
                    // 1. Rename the option list
                    survey.optionLists[property.newVal] = survey.optionLists[property.oldVal];
                    delete survey.optionLists[property.oldVal];

                    // 2. Update all questions that refer to this option list so they reference the new one
                    for(i = 0; i < survey.forms.length; i++) {
                        for(j = 0; j < survey.forms[i].questions.length; j++) {
                            if(survey.forms[i].questions[j].list_name === property.oldVal) {
                                survey.forms[i].questions[j].list_name = property.newVal
                            }
                        }
                    }

                    //3.  Update the optionList property for all options in the changed optionList
                    for(i = 0; i < survey.optionLists[property.newVal].options.length; i++) {
                        survey.optionLists[property.newVal].options[i].optionList = property.newVal;
                    }
                } else {
                    console.log("Error: unknown property type: " + property.type);
                }

            } else if(change.changeType === "question") {		// Not a change to a property
                if(change.action === "move") {

                    var sourceForm = change.question.sourceFormIndex;
                    var sourceItem = change.question.sourceItemIndex;
                    var targetForm = change.question.formIndex;
                    var oldLocation = change.question.sourceSeq;
                    var newLocation = change.question.seq;
                    var question = survey.forms[sourceForm].questions[sourceItem];
                    var name = question.name;
                    var endName;
                    var form;

                    if(question.type === "begin group") {	// Move all the group members
                        name = question.name;
                        endName = name + "_groupEnd";
                        form = survey.forms[sourceForm];

						/*
						 * Get the questions to move
						 */
                        var groupMembers = [];
                        for(i = oldLocation; i < form.qSeq.length; i++) {

                            groupMembers.push(form.qSeq[i]);
                            if(form.questions[form.qSeq[i]].name.toLowerCase() === endName.toLowerCase()) {
                                break;
                            }
                        }

						/*
						 * Move the group members
						 */
                        for(i = 0; i < groupMembers.length; i++) {

                            moveQuestion(survey, form.questions[groupMembers[i]],
                                targetForm,
                                newLocation++,
                                sourceForm,
                                oldLocation++);

                            console.log("moved");
                        }

                    } else {

                        // Move the single question
                        change.question.itemIndex = moveQuestion(survey, question,
                            targetForm,
                            newLocation,
                            sourceForm,
                            oldLocation);
                        
                        // Fix up the form being moved to point to its new parent
                        var movedForm;
                        if(question.type === "begin repeat") {
                            // Get the form being moved
                            for(i = 0; i < survey.forms.length; i++) {
                                movedForm = survey.forms[i];
                                if(movedForm.parentFormIndex === sourceForm && movedForm.parentQuestionIndex === sourceItem) {
                                    movedForm.parentFormIndex = targetForm;
                                    movedForm.parentform = survey.forms[targetForm].id;
                                    movedForm.parentQuestionIndex = change.question.itemIndex;
                                    break;
                                }
                            }
                        }

                    }
                    refresh = true;		// Do a complete refresh after moving questions

                } else if(change.action === "add") {
                    length = survey.forms[change.question.formIndex].questions.push(change.question);			// Add the new question to the end of the array of questions
                    change.question.itemIndex = length -1;
                    survey.forms[change.question.formIndex].qSeq.splice(change.question.seq, 0, length - 1);	// Update the question sequence array

                    if(change.question.firstQuestion) {
                        refresh = true;		// Refresh all the questions when adding the first question to a form
                    } else if(change.question.type === "end group") {
                        refresh = false;
                    }

                    // Add a subform if required
                    if(change.question.type === "begin repeat") {
                        // New sub form
                        survey.forms.push({
                            id: undefined,
                            name: change.question.name,
                            parentQuestionIndex: change.question.itemIndex,
                            parentFormIndex: change.question.formIndex,
                            questions: [],
                            qSeq: []
                        });
                        change.question.childFormIndex = survey.forms.length - 1;
                    }

                    refresh = true;			// DEBUG - remove after fixing update of html

                } else if(change.action === "delete") {
                    var form = survey.forms[change.question.formIndex];
                    var question = form.questions[change.question.itemIndex];
                    form.qSeq.splice(change.question.seq, 1);	// Remove item from the sequence array
                    question.deleted = true;	// Mark deleted
                    if(question.type === "begin group") {
                        applyToEndGroup(form, question.name, change.question.seq, "delete", undefined, change.question.formIndex);
                        refresh = true;
                    }
                } else {
                    console.log("Unknown action: " + change.action);
                }


            } else if(change.changeType === "option") {				// Change to an option
                if(change.action === "move") {

                    var sourceOptionList = survey.optionLists[change.option.sourceOptionList];
                    var targetOptionList = survey.optionLists[change.option.optionList];

                    var theOption = sourceOptionList.options[change.option.sourceItemIndex];
                    var newOption = jQuery.extend(true, {}, theOption);
                    var oldLocation = change.option.sourceSeq;
                    var newLocation = change.option.seq;

                    // 1. Add the option in the new location
                    length = targetOptionList.options.push(newOption);
                    change.option.itemIndex = length -1;
                    change.option.value = theOption.value;
                    targetOptionList.oSeq.splice(change.option.seq, 0, length - 1);

                    // 2. Remove the option from the old location
                    // The old location may have changed if the new location was inserted before it
                    if(newLocation < oldLocation && change.option.sourceOptionList == change.option.optionList) {
                        oldLocation++;
                    }
                    sourceOptionList.oSeq.splice(oldLocation, 1);
                    theOption.deleted = true;

                    // 3. Update any items in the change list to the new location
                    if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes) {
                        for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes.length; i++) {
                            var existingChange = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i];
                            if(existingChange.changeType === "option") {
                                for(j = 0; j < existingChange.items.length; j++) {
                                    var existingItem = existingChange.items[j];
                                    if(existingItem.option.optionList === theOption.optionList &&
                                        existingItem.option.itemIndex === theOption.itemIndex) {
                                        // We moved an option thats in the change queue
                                        existingItem.option.optionList = change.option.optionList;
                                        existingItem.option.itemIndex = change.option.itemIndex;
                                    }
                                }
                            }
                        }
                    }
                    refresh = true;

                } else if(change.action === "add") {
                    length = survey.optionLists[change.option.optionList].options.push(change.option);			// Add the new option to the end of the array of options
                    change.option.itemIndex = length -1;
                    survey.optionLists[change.option.optionList].oSeq.splice(change.option.seq, 0, length - 1);	// Update the option sequence array

                } else if(change.action === "delete") {
                    survey.optionLists[change.option.optionList].oSeq.splice(change.option.seq, 1);	// Remove item from the sequence array
                    survey.optionLists[change.option.optionList].options[change.option.itemIndex].deleted = true;
                } else {
                    console.log("Unknown action: " + change.action);
                }

            } else if(change.changeType === "optionlist") {				// Change to an option list
                if(change.action === "add") {
                    survey.optionLists[change.name] = {
                        oSeq: [],
                        options: []
                    };
                    refresh = true;
                } else if(change.action === "delete") {
                    delete survey.optionLists[change.name];
                    refresh = true;
                } else {
                    console.log("Unknown action: " + change.action);
                }
            }
            return refresh;
        }

		/*
		 * Move a question
		 */
        function moveQuestion(survey, question, targetForm, newLocation, sourceForm, oldLocation) {

            var newQuestion = jQuery.extend(true, {}, question),
                itemIndex,
                i,j,
                change,
                item,
                length;

            // 1. Add the question in the new location
            length = survey.forms[targetForm].questions.push(newQuestion);			// Add the new question to the end of the array of questions
            itemIndex = length - 1;
            survey.forms[targetForm].qSeq.splice(newLocation, 0, length - 1);	// Update the question sequence array

            // 1.5 Update the sequences stored in the question objects
            //for(i = 0; i < survey.forms[targetForm].qSeq.length; i++) {
            //	var idx = survey.forms[targetForm].qSeq[i];
            //    survey.forms[targetForm].questions[idx].seq = i;
            //}

            // 2. Remove the question from the old location
            // The old location may have changed if the new location was inserted before it
            if(newLocation < oldLocation && sourceForm === targetForm) {
                oldLocation++;
            }
            survey.forms[sourceForm].qSeq.splice(oldLocation, 1);
            question.deleted = true;

            // 3. Update any items in the change list to put to the new location
            if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes) {
                for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes.length; i++) {
                    change = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i];
                    if(change.changeType === "question") {
                        for(j = 0; j < change.items.length; j++) {
                            item = change.items[j];
                            if(item.question.formIndex === question.formIndex &&
                                item.question.itemIndex === question.itemIndex) {
                                // We moved a question thats in the change queue
                                item.question.formIndex = targetForm;
                                item.question.itemIndex = itemIndex;
                                item.question.fId = survey.forms[targetForm].id;
                            }
                        }
                    }
                }
            }

            // Update the model
            question.itemIndex = itemIndex;
            question.formIndex = targetForm;

            return itemIndex;
        }
		/*
		 * Apply a change to the "end group" of a group
		 */
        function applyToEndGroup(form, name, start_seq, action, new_name, form_index) {
            var i,
                end_name = name + "_groupEnd";

            // Remove the group from the model
            for(i = start_seq; i < form.qSeq.length; i++) {
                if(form.questions[form.qSeq[i]].name === end_name) {
                    if(action === "delete") {
                        form.questions[form.qSeq[i]].deleted = true;
                        form.qSeq.splice(i, 1);
                    } else if(action === "rename") {
                        form.questions[form.qSeq[i]].name = new_name + "_groupEnd";
                    }
                    break;
                } else {

                    // Delete the member
                    if(action === "delete"  && typeof form_index !== "undefined") {
                        modelGeneratedChanges.push({
                            changeType: "question",
                            action: "delete",
                            source: "editor",
                            question: {
                                seq: i,
                                formIndex: form_index,
                                itemIndex: i
                            }
                        });
                    }
                }
            }

            // Remove group end from the pending changes list
            for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes.length; i++) {
                if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].question) {
                    if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].question.name === end_name) {
                        if(action === "delete") {
                            _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes.splice(i, 1);
                        } else if(action === "rename") {
                            _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes[i].items[0].question.name = new_name + "_groupEnd";
                        }
                    }
                }
            }

        }

		/*
		 * Update the modified HTML element
		 */
        function updateHtmlElement(change) {
            var newMarkup,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                $changedRow,
                i,
                collapsedPanels = [];

            if(change.changeType === "label") {
                if(change.property.propType === "image") {

                    newMarkup = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Image",
                        change.property.newVal,
                        _getUrl(change.property.newVal, false, 'image', change.property.isSurveyLevel, survey.id),
                        _getUrl(change.property.newVal, true, 'image', change.property.isSurveyLevel, survey.id)
                    );

                } else if(change.property.propType === "video") {

                    newMarkup = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Video",
                        change.property.newVal,
                        _getUrl(change.property.newVal, false, 'video', change.property.isSurveyLevel, survey.id),
                        _getUrl(change.property.newVal, true, 'video', change.property.isSurveyLevel, survey.id)
                    );

                } else if(change.property.propType === "audio") {

                    newMarkup = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Audio",
                        change.property.newVal,
                        _getUrl(change.property.newVal, false, 'audio', change.property.isSurveyLevel, survey.id),
                        undefined
                    );

                }

                if(newMarkup) {
                    if(change.property.type === "question") {
                        $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#question' + change.property.formIndex + '_' + change.property.itemIndex);
						/*
						 $changedRow = $('#formList').find('li.question').filter(function(index){
						 var $this = $(this);
						 return $this.data("fid") == change.property.formIndex && $this.data("id") == change.property.itemIndex;
						 });
						 */
                    } else {

                        $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView').find('tr').filter(function(index){
                            var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
                            return $this.data("id") == change.property.itemIndex;
                        });
                    }

                    if($changedRow) {
                        $changedRow.find('.' + change.property.propType + 'Element').replaceWith(newMarkup);
                    }
                }
            } else if(change.changeType === "question") {

                var form = survey.forms[change.question.formIndex];

                if(change.action === "add") {
                    var preceedingQuestion = form.questions[form.qSeq[change.question.seq-1]];
                    if(change.question.locn === "after") {
                        change.question.$relatedElement.after(_editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addOneQuestion(form, change.question, change.question.formIndex, change.question.itemIndex, true, undefined, false));
                    } else {
                        change.question.$relatedElement.prev().before(_editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addOneQuestion(form, change.question, change.question.formIndex, change.question.itemIndex, true, undefined, false));
                    }
                    $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()("#question" + change.question.formIndex + "_" + change.question.itemIndex);

                } else if(change.action === "delete") {
                    change.question.$deletedElement.prev().remove();	// Remove the add before button
                    change.question.$deletedElement.remove();
                }
            } else if(change.changeType === "option") {
                if(change.action === "add") {
                    var optionList,
                        $ref;


                    optionList = survey.optionLists[change.option.optionList];

                    // get the new markup
                    newMarkup = _option__WEBPACK_IMPORTED_MODULE_4__["default"].addOneOption(optionList,
                        change.option,
                        change.option.formIndex,
                        change.option.itemIndex,
                        change.option.optionList,
                        change.option.qName);


                    $ref = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView').find('.editor_element').
                    filter(function(index) {
                        var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
                        return $this.data("id") == change.option.optionIndex;
                    });

                    if(change.option.locn == "after") {
                        $ref.after(newMarkup);
                        $changedRow = $ref.next();
                    } else if(change.option.locn == "before") {
                        $ref.before(newMarkup);
                        $changedRow = $ref.prev();
                    } else {
                        // put at end of table
                        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView tbody').append(newMarkup);
                        $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView tbody tr:last');
                    }

                } else if(change.action === "delete") {
                    change.option.$deletedElement.remove();
                }
            } else if(change.changeType === "property") {
                // Apply any markup changes that result from a property change


                // 1. Update the question / option
                if(change.property.type === "option") {
					/*
					 * No option property changes result in markup changes
					 */
                } else if(change.property.type === "question") {

                    // Get the changed question row
                    $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList').find('li.question').filter(function(index){
                        var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
                        return $this.data("fid") == change.property.formIndex && $this.data("id") == change.property.itemIndex;
                    });

                    newMarkup = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addOneQuestion(
                        survey.forms[change.property.formIndex],
                        survey.forms[change.property.formIndex].questions[change.property.itemIndex],
                        change.property.formIndex,
                        change.property.itemIndex,
                        false, undefined, true);

                }

				/*
				 * Apply the update
				 */
                if($changedRow) {

                    // Get the current list of collapsed panels
                    jquery__WEBPACK_IMPORTED_MODULE_0___default()('.collapse.show', $changedRow).each(function(){
                        collapsedPanels.push(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).closest('li').attr("id"));
                    });

                    // Update the content view
                    $changedRow.replaceWith(newMarkup);

                    // Restore collapsed panels
                    for(i = 0; i < collapsedPanels.length; i++) {
                        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + collapsedPanels[i]).find('.collapse').addClass("show");
                    }

                    // Since we replaced the row we had better get the replaced row so that actions can be reapplied
                    if(change.property.type === "option") {
                        $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList').find('li.option').filter(function(index){
                            var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
                            return $this.data("fid") == change.property.formIndex && $this.data("id") == change.property.itemIndex;
                        });
                    } else {
                        $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList').find('li.question').filter(function(index){
                            var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
                            return $this.data("fid") == change.property.formIndex && $this.data("id") == change.property.itemIndex;
                        });
                    }
                }

            }


            return $changedRow;
        }

        function getQuestionsUsingOptionList(list) {
            var i, j,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                forms = survey.forms,
                question,
                nameArray = [];

            for(i = 0; i < forms.length; i++) {
                for(j = 0; j < forms[i].questions.length; j++) {
                    question = forms[i].questions[j];
                    if(!question.deleted &&  !question.soft_deleted &&
                        (question.type.indexOf("select") === 0 || question.type === "rank") &&
                        question.list_name === list) {

                        nameArray.push(question.name);
                    }
                }
            }
            return nameArray;
        }

		/*
		 * Media functions
		 */
        function _getUrl(newVal, thumbs, type, isSurveyLevel, sId) {
            var url = "/surveyKPI/file/",
                filebase,
                ext,
                index;

            if(newVal) {

                // Videos and other derived thumbnails will have type jpg
                if(thumbs && type !== "image") {
                    index = newVal.lastIndexOf('.');
                    filebase = url.substr(0, index);
                    newVal = filebase + ".jpg";
                }

                url += newVal;

                if(isSurveyLevel) {
                    url += "/survey/"
                    url += sId;
                } else {
                    url += "/organisation";
                }

                if(thumbs) {
                    url += "?thumbs=true";
                }


            } else {
                url = undefined;
            }

            return url;
        }

		/*
		 * Create a message from response to a save request
		 */
        function addUpdateMessage(data, forError) {
            var h = [],
                idx = -1,
                j,
                action,
                result,
                name;

            if(data.updateFailed && forError) {
                h[++idx] = '<li>';
                h[++idx] = data.errorMsg;
                h[++idx] = '</li>';
            } else if(!data.updateFailed && !forError) {
                for(j = 0; j < data.items.length; j++) {
                    h[++idx] = '<li>';
                    h[++idx] = getChangeDescription(data.items[j]);
                    h[++idx] = '</li>';
                }
            }

            return h.join("");
        }

		/*
		 * ***************************************************************
		 * Validate each change to a question or option
		 */
        function validateItem(container, itemIndex, itemType, removeExisting) {

            var i, j,
                form,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                item,
                name,
                isDeleted,
                isValid = true,
                hasDuplicate = false,
                changes = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes,
                numberErrors,
                numberWarnings;

            if(itemType === "question") {
                item = survey.forms[container].questions[itemIndex];
                name = item.name;
            } else if(itemType === "option") {
                item = survey.optionLists[container].options[itemIndex];
                name = item.value;
            } else if(itemType === "optionlist") {
                item = survey.optionLists[container];
                name = container;
            }

			/*
			 * Remove the existing error
			 * If this validation has been called by validateAll() then this removal would already have been done
			 */
            if(removeExisting) {
                removeValidationError(container, itemIndex,	"item", itemType);
            }

            if(!item.deleted &&
                ((itemType === "question" && _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].includeQuestion(item)) ||
                (itemType === "optionlist") ||
                (itemType === "option"))) {

                // Validate the name
                isValid = validateName(container, itemIndex, name, itemType, removeExisting);

				/*
				 * Question specific validations
				 */
                if(itemType === "question") {

                    // Check references to other questions
                    isValid = checkReferences(container, itemIndex, itemType, item);
                    isValid = checkSelfReferences(container, itemIndex, itemType, item);

                    if(isValid) {	// Check parenthesis on relevant
                        isValid = checkParentheisis(container, itemIndex, itemType, item.relevant);
                    }

                    if(isValid) {	// Check parenthesis on constraint
                        isValid = checkParentheisis(container, itemIndex, itemType, item.constraint);
                    }

                    if(isValid) {	// Check parenthesis on calculation
                        isValid = checkParentheisis(container, itemIndex, itemType, item.calculation);
                    }

                    if(isValid) {	// Check parenthesis on choiceFilter
                        isValid = checkParentheisis(container, itemIndex, itemType, item.choice_filter);
                    }

	                if(isValid && (item.type === "child_form" || item.type === "parent_form")) {	// Check that form launch types have a reference form

	                    if(item.parameters && item.parameters.indexOf("form_identifier") >= 0) {
	                        isValid = true;
	                    } else {
	                        isValid = false;
		                    addValidationError(
			                    container,
			                    itemIndex,
			                    "item",
			                    _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_f_l"],	// Only one geometry question can be added to a form
			                    itemType,
			                    "error");
	                    }

	                }

	                if(isValid && item.type === "begin repeat") {	// Check that a repeat group has children

	                    var itemx = item;
		                var childFormIndex = getSubFormIndex(item.formIndex, itemIndex);
		                var questions = survey.forms[childFormIndex].questions;
                        var isEmpty = true;

                        if(questions.length > 0) {
                            isEmpty = false;
                        }

                        if(isEmpty) {
	                        isValid = false;
	                        addValidationError(
		                        container,
		                        itemIndex,
		                        "item",
		                        _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_emp_rep"],
		                        itemType,
		                        "warning");
                        }
	                }

	                if(isValid && item.type === "begin group") {	// Check that a group has children

		                var endName = item.name + "_groupEnd";
		                var questions = survey.forms[item.formIndex].questions;
		                var qSeq = survey.forms[item.formIndex].qSeq;
		                var isEmpty = true;
		                var inGroup = false;

                        if(!qSeq) {
                            qSeq = [];
                        }
		                /*
						 * Get the questions in the group
						 */
		                for(j = 0; j < qSeq.length; j++) {

		                    if(inGroup === true) {
			                    if (questions[qSeq[j]].name.toLowerCase() === endName.toLowerCase()) {
				                    break;
			                    } else {
				                    isEmpty = false;
				                    break;
			                    }
		                    }

			                if(qSeq[j] === itemIndex) {
				                inGroup = true;
			                }

		                }

		                if(isEmpty && inGroup) {
			                isValid = false;
			                addValidationError(
				                container,
				                itemIndex,
				                "item",
				                _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_emp_rep"],
				                itemType,
				                "warning");
		                }
	                }


                } else if(itemType === "option") {
                    // Check references to other questions
                    isValid = checkReferences(container, itemIndex, itemType, item);
                }

                if(!isValid) {
                    updateModelWithErrorStatus(container, itemIndex, itemType);	// Update model and DOM
                }

				/*
				 * If there were no errors check for warnings
				 * Only do this on validateAll as otherwise it is just annoying to get the warnings
				 */
                if(!removeExisting) {
                    if(isValid) {
                        if(item.visible || itemType === "option") {
                            isValid = checkBlankLabels(container, itemIndex, itemType, item, "warning");
                        }
                    }

                    if(isValid) {
                        if(item.visible && itemType === "question") {
                            isValid = checkMissingChoices(container, itemIndex, itemType, item, "warning");
                        }
                    }
                }
            }

            // Set the control buttons
            numberErrors = numberIssues("error");
            numberWarnings = numberIssues("warning");

            jquery__WEBPACK_IMPORTED_MODULE_0___default()('.error-count').html(numberErrors);
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('.warning-count').html(numberWarnings);

            //if(numberErrors > 0) {
            //	$('.m_save_survey').addClass("disabled").prop("disabled", true);
            //} else
            if(changes.length > 0) {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.m_save_survey').removeClass("disabled").prop("disabled", false);
            }

            if(numberErrors > 0 || numberWarnings > 0) {

                jquery__WEBPACK_IMPORTED_MODULE_0___default()('#error-nav-btns').show();
                if(numberErrors > 0) {
                    jquery__WEBPACK_IMPORTED_MODULE_0___default()('#next-error').removeClass("disabled");
                } else {
                    jquery__WEBPACK_IMPORTED_MODULE_0___default()('#next-error').addClass("disabled");
                }
                if(numberWarnings > 0) {
                    jquery__WEBPACK_IMPORTED_MODULE_0___default()('#next-warning').removeClass("disabled");
                } else {
                    jquery__WEBPACK_IMPORTED_MODULE_0___default()('#next-warning').addClass("disabled");
                }
            }  else {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('#error-nav-btns').hide();
            }

        }

		/*
		 * Check for blank labels
		 */
        function checkBlankLabels(container, itemIndex, itemType, item) {
            var i,
                valid = true;

            for(i = 0; i < item.labels.length; i++) {
                if(typeof item.labels[i].text === "undefined" ||
                    (typeof item.labels[i].text === "undefined" && item.labels[i].text.trim().length === 0)) {
                    if(itemType === "question" && (item.type === "begin repeat" || item.type === "begin group")) {
                        continue;		// Don't report warnings on blank labels for these question types
                    }
                    addValidationError(
                        container,
                        itemIndex,
                        "item",
                        _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_bll"] + " " + htmlEncode(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.languages[i].name),
                        itemType,
                        "warning");
                    valid = false;
                    break;
                }
            }

            return valid;
        }

		/*
		 * Check for Missing choices in a select questions
		 */
        function checkMissingChoices(container, itemIndex, itemType, item) {
            var i,
                valid = true,
                survey;

            if(item.type.indexOf('select') === 0 || item.type === "rank") {
                if(typeof _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists[item.list_name] === "undefined") {
                    valid = false;
                }
                if(valid) {
                    var list = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists[item.list_name].options;
                    valid = false;
                    for(i = 0; i < list.length; i++) {
                        if(!list[i].deleted) {
                            valid = true;
                            break;
                        }
                    }
                }

                if(!valid) {
                    addValidationError(
                        container,
                        itemIndex,
                        "item",
                        "No choices in the choice list ",
                        itemType,
                        "warning");
                    valid = false;
                }

            }


            return valid;
        }

		/*
		 * Check for mismatched parenthesis
		 */
        function checkParentheisis(container, itemIndex, itemType, elem) {
            var i,
                c,
                depth = 0,
                lastOpen,
                errorText,
                isValid = true,
                locn;

            if(elem) {
                for(i = 0; i < elem.length; i++) {
                    c = elem.charAt(i);
                    if( c === '(') {
                        depth++;
                        locn = i;
                    } else if( c === ')') {
                        depth--;
                        locn = i;
                    }
                    if(depth < 0) {
                        break;
                    }
                }

                if(depth != 0) {
                    errorText = "Mis-matched parenthesis: " + elem.slice(0, locn) + '<b><span style="color:red;">' +
                        elem.slice(locn, locn + 1) +
                        '</span></b>' +
                        elem.slice(locn + 1);

                    addValidationError(
                        container,
                        itemIndex,
                        "item",
                        "Mis-matched parenthesis: " + errorText,
                        itemType,
                        "error");
                    isValid = false;
                }
            }

            return isValid;
        }

		/*
		 * Return false if the calculation is not valid
		 */
        function checkReferences(container, itemIndex, itemType, item) {

            var refQuestions = {},
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                form,
                i, j,
                name;

            // Get a list of references to other questions
            if(itemType  === "question") {
                getReferenceNames(item.relevant, refQuestions);
                getReferenceNames(item.constraint, refQuestions);
                getReferenceNames(item.calculation, refQuestions);
                getReferenceNames(item.choice_filter, refQuestions);
            }
            for(i = 0; i < item.labels.length; i++) {
                var text = item.labels[i].text;
                if(typeof text === "string") {
                    getReferenceNames(item.labels[i].text, refQuestions);
                }
            }

            if(checkExistenceOfReferences(refQuestions, survey)) {

                for (name in refQuestions) {
                    if (refQuestions.hasOwnProperty(name)) {
                        if (!refQuestions[name].exists) {
                            addValidationError(
                                container,
                                itemIndex,
                                "item",
                                _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_question"] + " ${" + name + "} " + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_not_f"],
                                itemType,
                                "error");
                            return false;
                        }
                    }
                }
            }

            return true;

        }

        /*
         * Return false if the calculation is not valid
         */
        function checkSelfReferences(container, itemIndex, itemType, item) {

            var refQuestions = {},
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                form,
                i, j,
                name;

            // Get a list of references to other where self cannot be references
            if(itemType  === "question") {
                getReferenceNames(item.relevant, refQuestions);
                getReferenceNames(item.calculation, refQuestions);
                getReferenceNames(item.choice_filter, refQuestions);
            }
            for(i = 0; i < item.labels.length; i++) {
                var text = item.labels[i].text;
                if(typeof text === "string") {
                    getReferenceNames(item.labels[i].text, refQuestions);
                }
            }

            var refCount = 0;
            for (name in refQuestions) {
                if (refQuestions.hasOwnProperty(name)) {
                    refCount++;
                }
            }

            if(refCount > 0) {

                form = survey.forms[container];
                var otherItem = form.questions[itemIndex];
                var questionType = otherItem.type;
                if (!otherItem.deleted && !otherItem.soft_deleted && questionType !== "end group") {

                    for (name in refQuestions) {
                        if (refQuestions.hasOwnProperty(name)) {
                            if (name === otherItem.name) {
                                addValidationError(
                                    container,
                                    itemIndex,
                                    "item",
                                    _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_question"] + " ${" + name + "} " + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["e_h_c1"],
                                    itemType,
                                    "error");
                                return false;
                            }
                        }
                    }

                }

            }

            return true;

        }

		/*
		 * Error types:  name || dupname || noname || dupgeom
		 */
        function addValidationError(container, itemIndex, errorType, msg, itemType, severity) {

            // Push error into validation array
            _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors.push({
                container: container,
                itemIndex: itemIndex,
                errorType: errorType,
                itemType: itemType,
                msg: msg,
                severity: severity
            });

            updateModelWithErrorStatus(container, itemIndex, itemType);

        }

		/*
		 * Update the model and the DOM to report any erors on the question
		 */
        function updateModelWithErrorStatus(container, itemIndex, itemType) {

            var $changedRow,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                hasError = false,
                hasWarning = false,
                msg = "",
                i,
                errors = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors,
                item;

            if(itemType === "question") {
                item = survey.forms[container].questions[itemIndex];
                $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#question' + container + '_' + itemIndex);
            } else if(itemType === "option" || itemType === "optionlist") {
                item = survey.optionLists[container];
                $changedRow = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#ol_' + container);
            }

            for(i = errors.length - 1; i >= 0; i--) {
                if(errors[i].itemType === itemType && errors[i].container === container &&
                    errors[i].itemIndex === itemIndex) {

                    if(errors[i].severity === "error") {
                        hasError = true;
                        msg = errors[i].msg;
                    } else {
                        hasWarning = true;
                        if(!hasError) {
                            msg = errors[i].msg;
                        }
                    }

                    if(errors[i].errorType === "name") {	// Break on name errors as this is the highest level error to show
                        break;
                    }

                }
            }

            // Update Model
            if(typeof item !== "undefined") {
                item.error = hasError;
                item.warning = hasWarning;
                item.errorMsg = msg;
            }

            // Update DOM
            $changedRow.find('.error-msg').html(msg);	// Add message
            if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gShowingChoices) {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()(".choice_filter_error").html(msg);
            }

            $changedRow.removeClass("error warning");
            if(hasError) {
                $changedRow.addClass("error");
                if(itemType === "question") {
                    $changedRow.find('.question_type').addClass("disabled");
                }
            } else {

                if(itemType === "question" && !item.published) {
                    $changedRow.find('.question_type').removeClass("disabled");
                }

                if(hasWarning) {
                    $changedRow.addClass("warning");
                }

            }
        }

		/*
		 * Remove the specified error type (see addValidationError for error types)
		 */
        function removeValidationError(container, itemIndex, errorType, itemType) {

            var i,
                $changedRow,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;

            // Remove error
            for(i = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors.length - 1; i >= 0; i--) {
                if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors[i].itemType === itemType &&
                    _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors[i].container === container &&
                    _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors[i].itemIndex === itemIndex &&
                    _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors[i].errorType === errorType) {
                    _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors.splice(i, 1);
                }
            }

            updateModelWithErrorStatus(container, itemIndex, itemType);  // Update model

        }

		/*
		 * Validate a question or option name
		 */
        function validateName(container, itemIndex, val, itemType, removeExisting) {

            var i, j,
                form,
                optionList,
                otherItem,
                survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                isValid = true,
                hasDuplicate = false,
                hasDuplicateOption = false,
                itemDesc,
                questionType,
                question,
                valLower;

            if(itemType === "question") {
                question = survey.forms[container].questions[itemIndex];
            }

            // Clear the existing name validation errors
            if(removeExisting) {
                removeValidationError(
                    container,
                    itemIndex,
                    "name",
                    itemType);
            }

            if(itemType === "question" ) {
                itemDesc = "question";
            } else if(itemType === "option" ) {
                itemDesc = "choice";
            } else if(itemType === "optionlist" ) {
                itemDesc = "choice list";
            } else {
                itemDesc = "unknown";
            }

            // Check for empty name
            if(typeof val === "undefined" || val === "") {
                addValidationError(
                    container,
                    itemIndex,
                    "name",
                    "This " + itemDesc + " does not have a name.  Specify a unique name.",
                    itemType,
                    "error");
                isValid = false;
            }

            // Check for invalid characters
            if(isValid) {
                if(itemType === "question") {
                    isValid = isValidODKQuestionName(val);

                    if(!isValid) {
                        addValidationError(
                            container,
                            itemIndex,
                            "name",
                            _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_vq"],
                            itemType,
                            "error");

                    }

                } else {
                    isValid = isValidODKOptionName(val);

                    if(!isValid) {
                        addValidationError(
                            container,
                            itemIndex,
                            "name",
                            _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_vc"] + " : "  + htmlEncode(val),
                            itemType,
                            "error");

                    }
                }
            }

			/*
			 * Question name change require the questions in all the forms to be validated for duplicates
			 */
            if(isValid) {

                valLower = val.toLowerCase();

                if(itemType === "question") {
                    for(i = 0; i < survey.forms.length; i++) {
                        form = survey.forms[i];
                        for(j = 0; j < form.questions.length; j++) {
                            questionType = form.questions[j].type;
                            if(questionType !== "end group") {
                                if(!(i === container && j === itemIndex)) {	// Don't test the question against itself!
                                    otherItem = form.questions[j];
                                    if(otherItem.name.toLowerCase() === valLower) {
                                        if((!otherItem.deleted && !otherItem.soft_deleted)
                                            || (otherItem.soft_deleted && otherItem.type !== questionType)) {
                                            hasDuplicate = true;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }

                } else if(itemType === "option") {
                    optionList = survey.optionLists[container];
                    for(j = 0; j < optionList.options.length; j++) {
                        if(j !== itemIndex) {
                            otherItem = optionList.options[j];
                            if(!otherItem.deleted && otherItem.value.toLowerCase() === valLower) {
                                hasDuplicateOption = true;
                                break;
                            }
                        }
                    }
                } else if(itemType === "optionlist") {
                    if(container === val) {
                        // no change its valid
                    } else {
                        optionList = survey.optionLists[val];
                        if(typeof optionList !== "undefined") {
                            hasDuplicate = true;
                        }
                    }
                }
                if(hasDuplicate || hasDuplicateOption) {
                    addValidationError(
                        container,
                        itemIndex,
                        "name",
                        "The " + itemDesc + " name is the same as the name of another " + itemDesc +".  Specify a unique name.",
                        itemType,
                        hasDuplicate ? "error" : "warning");
                    isValid = false;
                }

            }

            return isValid;

        }

		/*
		 * Get the path for the form from the top level form down
		 */
        function getFormPath(form) {
            var path = form.name,
                forms = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms,
                i;
            while(form.parentFormIndex !== -1) {
                for(i = 0; i < forms.length; i++) {
                    if(i === form.parentFormIndex) {
                        form = forms[i];
                        path = form.name + "/" + path;
                        break;
                    }
                }
            }
            path = "/" + path;
            return path;
        }

		/*
		 * Validate the entire survey
		 */
        function validateAll() {
            var i,
                j,
                forms = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.forms,
                optionLists = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists,
                list,
                numberErrors = 0,
                numberWarnings = 0;

            _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors = [];		// Clear the existing errors
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('tr.editor_element.error', '#choiceView').removeClass("error");
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('tr.editor_element.warning', '#choiceView').removeClass("warning");
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('li.card.error', '#formList').removeClass("error");
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('li.card.warning', '#formList').removeClass("warning");

            for(i = 0; i < forms.length; i++) {
                var deleted = false;
                var parentForm = forms[i].parentFormIndex;
                var parentQuestion = forms[i].parentQuestionIndex;
                if(parentForm > -1 && parentQuestion > -1) {
                    deleted = forms[parentForm].questions[parentQuestion].deleted;
                }
                if(!deleted) {
                    var validate = true;
                    var groupName;
                    for (j = 0; j < forms[i].questions.length; j++) {
                        // Skip deleted groups
                        if(validate) {
                            if (!forms[i].questions[j].deleted && !forms[i].questions[j].soft_deleted) {
                                validateItem(i, j, "question", false);		// Validate the question
                            } else {
                                if(forms[i].questions[j].type === "begin group") {
                                    groupName = forms[i].questions[j].name;
                                    validate = false;
                                }
                            }
                        } else {
                            if(forms[i].questions[j].type === "end group") {
                                if(forms[i].questions[j].name.indexOf(groupName) > 0) {
                                    validate = true;
                                }
                            }
                        }
                    }
                }
            }
            for(list in optionLists) {
                if(optionLists.hasOwnProperty(list)) {
                    for(j = 0; j < optionLists[list].options.length; j++) {
                        validateItem(list, j, "option", false);		// Validate the option
                    }
                }

                // Validate the option list itself
                validateItem(list, "ol_" + list, "optionlist", false);
            }

        }

        function numberIssues(severity) {
            var i,
                count = 0;

            for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors.length; i++) {
                if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].errors[i].severity === severity) {
                    count++;
                }
            }
            return count;
        }

        function getSubFormIndex(parentFormIndex, parentQuestionIndex) {

            var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
                forms = survey.forms,
                i,
                form;

            for(i = 0; i < forms.length; i++) {
                form = forms[i];
                if(forms[i].parentFormIndex === parentFormIndex && forms[i].parentQuestionIndex === parentQuestionIndex) {
                    return i;
                }
            }

            return 0;
        }

        /*
         * Modify controls that are dependent on the view being either for questions or choices
         */
        function updateViewControls() {

            //if(globals.gSelProperty !== "media") {		// media is the only common attribute between question and option view
            //	globals.gSelProperty = "label";
            //}
            if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gIsQuestionView && !_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gShowingChoices) {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.q_only').show();
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.o_only').hide();
                _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelLabel = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#selProperty > a.q_only.default').text();
            } else {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.q_only').hide();
                jquery__WEBPACK_IMPORTED_MODULE_0___default()('.o_only').show();
                _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelLabel = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#selProperty > a.o_only.default').text();
            }
            _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty = "label";
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('#propSelected').text(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelLabel);
        }


/***/ },

/***/ "./WebContent/js/app/editorMarkup.js"
/*!*******************************************!*\
  !*** ./WebContent/js/app/editorMarkup.js ***!
  \*******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globals */ "./WebContent/js/app/globals.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
uSMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Functions for manipulating a question in the editor
 */







let gGroupStacks = [];
const linkedQuestions = {};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({	
	addOneQuestion: addOneQuestion,
	addPanelStyle: addPanelStyle,
	addQType: addQType,
	addQuestions: addQuestions,
	addMedia: addMedia,
	refresh: refresh,
	includeQuestion: includeQuestion,
	addQuestionSequence: addQuestionSequence,
	getLinkedQuestions: getLinkedQuestions,
	refreshQuestionFeaturedProperties: refreshQuestionFeaturedProperties
});
	
	/*
	 * Add a single question
	 */
	function addOneQuestion(form, question, formIndex, qIndex, addNewButton, selProperty, update) {
		var h = [],
			idx = -1,
			questionId = "question" + formIndex + "_" + qIndex;
		
		// Support the legacy geopolygon and geolinestring types
		if(question.type === "geopolygon" || question.type === "geolinestring") {
			question.type = "begin repeat";
		}
		
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gHasItems = true;
		if(!update) {					// Only increment maxQuestion if a new question is being added
			form.maxQuestion++;
		}
		
		selProperty = selProperty || _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty;
		
		if(addNewButton) {
			h[++idx] = addNewQuestionButton(false, false, formIndex, undefined, selProperty);
		}
		
		// Add the group to the group stack
		if(question.type === "begin group" && gGroupStacks[formIndex]) {
			gGroupStacks[formIndex].groupStack.push(question.name);
		}
		
		h[++idx] = addPanelStyle(question.type, formIndex, qIndex, question.error, questionId, undefined);
		h[++idx] = '<div class="card-body">';
			h[++idx] = addErrorMsg(question.errorMsg);
			h[++idx] = '<div class="row">';
				
			// Add question type
				h[++idx] = '<div class="col-sm-2 col-12 ">';
					h[++idx] = '<div class="question_type';
						if(question.published) {
							h[++idx] = ' readonly';
						}
						h[++idx] = '">';
						h[++idx] = addQType(question.type);
					h[++idx] = '</div>';
				h[++idx] = '</div>';	// End of question type cell

				// Add question name cell
				h[++idx] = '<div class="col-sm-3 col-12 "><input class="qname form-control has_tt" data-toggle="tooltip" title="';
				h[++idx] = question.name;
				h[++idx] = '" value="';
				h[++idx] = question.name;
				h[++idx] = '" ';
						
				if(question.published) {				// Mark disabled if the question has been published
					h[++idx] = 'readonly="true" ';
				}
				h[++idx] = 'type="text"></div>';		// End of name

				// Add feature property cell
				h[++idx] = addFeaturedProperty(question, formIndex, qIndex, undefined, undefined, questionId);
				
				// Add buttons
				h[++idx] = '<div class="col-sm-2 col-12 q_icons_col">';
					h[++idx] = '<div class="btn-group">';

						h[++idx] = '<button tabindex="-1" class="btn btn-light delete_question ml-1" data-id="';
						h[++idx] = questionId;
						h[++idx] = '">';
						h[++idx]='<i class="fas fa-trash-alt edit_icon"></i>';
						h[++idx]='</button>';

						if(question.type === "begin repeat" 
								|| question.type === "begin group") {
							
							h[++idx] = '<a button tabindex="-1" class="btn btn-light ml-1" data-toggle="collapse" href="#collapse';
							h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gElementIndex;
							h[++idx]='"><i class="fas fa-chevron-down edit_icon"></i></a>';
						} else if(question.type.indexOf("select") === 0 || question.type === "rank") {
						
							h[++idx] = '<a button tabindex="-1" class="btn btn-light edit_choice ml-1" ';
							h[++idx]='"><i class="fa fa-edit edit_icon"></i></a>';
							
						}
					 
					h[++idx] = '</div>';
				h[++idx] = '</div>';		// End of button cell
				h[++idx] = '</div>';		// End of row
		h[++idx] = '<div id="collapse';
		h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gElementIndex;
		h[++idx] = '" class="panel-body collapse';
		if(question.type.indexOf("select") === 0 || question.type === "rank") {
			h[++idx] = ' selectquestion';
		}
		h[++idx] = '">';
		if(question.type === "begin repeat") {
			
			h[++idx] = '<div class="question-controls">';
			h[++idx] = '<div class="row">';
				h[++idx] = '<div class="col-md-6"></div>';		
				// A control to set repeat count
					h[++idx] = '<div class="col-md-6">';
						h[++idx] = '<label>Repeat Count: </label>';
						h[++idx] = '<div class="input-group">';
							h[++idx] = '<input class="form-control repeat-counts" value="';
							h[++idx] = question.calculation;
							h[++idx] = '">';
						h[++idx] = '</div>';
					h[++idx] = '</div>';
				h[++idx] = '</div>';
			h[++idx] = '</div>';
		
			h[++idx] = addSubForm(formIndex, qIndex);
			
		} 
		
		if(question.type === "begin group") {	/* Add questions up to the end group to this panel */
			h[++idx] = '<ul class="list-unstyled">';
		} else { 
			h[++idx] = '</div>';
			h[++idx] = '</li>';
		}
		
		return h.join("");
	}
	

	/*
	 * Add a single option list element to the choices view
	 */
	function addOneOptionList(list_name, addNewButton, selProperty) {
		
		var h = [],
			idx = -1,
			itemId = "ol_" + list_name,
			optionList = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists[list_name];
		
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gHasItems = true;
		
		selProperty = selProperty || _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty;
		
		if(addNewButton) {
			h[++idx] = addNewQuestionButton(false, false, undefined, undefined, selProperty);		
		}
		
		h[++idx] = addPanelStyle("choices", undefined, undefined, optionList.error, itemId, list_name);
		h[++idx] = '<div class="card-body">';
		h[++idx] = addErrorMsg(optionList.errorMsg);
		h[++idx] = '<div class="row">';

		// Add choice name cell
		h[++idx] = '<div class="col-10"><input class="olname form-control has_tt" data-toggle="tooltip" title="List Name" value="';
		h[++idx] = list_name;
		h[++idx] = '" type="text"></div>';

		// Add buttons
		h[++idx] = '<div class="col-2 q_icons_col">';
		h[++idx] = '<div class="btn-group">';

		h[++idx] = '<a button tabindex="-1" class="btn btn-light edit_choice" data-id="';
		h[++idx] = itemId;
		h[++idx] = '"><i class="fa fa-edit edit_icon"></i></a>';

		h[++idx] = '<a button tabindex="-1" class="btn btn-light delete_ol" data-id="';
		h[++idx] = itemId;
		h[++idx]= '"><i class="fa fa-times-circle edit_icon text-danger" aria-hidden="true"></i></a>';

		h[++idx] = '</div>';		// End of button group
		h[++idx] = '</div>';		// End of button group cell
		h[++idx] = '</div>';		// End of row
		h[++idx] = '</div>';		// End of card
		h[++idx] = '</li>';			// End of list item


		return h.join("");
	}
	
	function addErrorMsg(msg) {
		var h = [],
			idx = -1;
		
		h[++idx] = '<p class="error-msg">';
		h[++idx] = htmlEncode(msg);
		h[++idx] = '</p>';
		return h.join("");
	}
	
	function addNewQuestionButton(after, topLevelForm, formIndex, formName, selProperty) {
		var h = [],
			idx = -1,
			addButtonClass,
			locn;
		
		//console.log(" Group Stack: " + gGroupStacks[formIndex].groupStack.join(",") + " : Last group: " + gGroupStacks[formIndex].lastGroup);
		
		addButtonClass = after ? 'add_after_button add_button' : 'add_before_button add_button';
		locn = after ? 'after' : 'before';
		
		if(topLevelForm && locn === "after") {
			addButtonClass += ' add_final_button';
		}
		
		h[++idx] = '<li>';
		h[++idx] = '<span>';

		h[++idx] = '<button id="addnew_';
		h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gNewQuestionButtonIndex++;
		h[++idx] = '" type="button" class="add_question btn dropon ';
		h[++idx] = addButtonClass;
		if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gNewQuestionButtonIndex == 1) { // First button in the form
			h[++idx] = ' first_element ';
		}
		if(!(topLevelForm && locn === "after")) {
			h[++idx] = '" tabindex="-1"';
		} else {
			h[++idx] = '"';
		}
		h[++idx] = ' data-locn="';
		h[++idx] = locn;
		h[++idx] = '" data-findex="';
		h[++idx] = formIndex;

		h[++idx] = '">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_aq'];
		if(formName) {
			h[++idx] = ' - ';
			h[++idx] = formName;
		}

		h[++idx] = '</button>';
		h[++idx] = '</span>';
		h[++idx] = '</li>';
		
		return h.join('');
	}
	
	function addNewOptionListButton() {
		var h = [],
			idx = -1,
			locn;
		
		h[++idx] = '<li>';
	
		h[++idx] = '<button tabindex="-1" id="addnew_optionlist" ';
		h[++idx] = 'type="button" class="add_option_list add_button add_after_button add_final_button btn">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_ancl"];
		h[++idx] = '</button>';
		h[++idx] = '</li>';
		
		return h.join('');
	}
	
	/*
	 * Add the container for an editable element including its styling
	 */
	function addPanelStyle(type, formIndex, qIndex, error, elementId, list_name) {
		
		var h = [],
			idx = -1;
		
		h[++idx] = '<li class="card editor_element question draggable';

		if(error) {
			h[++idx] = ' error ';
		}
		
		if(type === "begin repeat" || type === "begin group") {
			h[++idx] = ' bg-secondary" id="';
		} else {
			h[++idx] = ' bg-light" id="';
		}
		h[++idx] = elementId;
		++_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gElementIndex;
		h[++idx] = '"';
		
		// Add the question index and form index
		if(typeof formIndex !== "undefined") {
			h[++idx] = ' data-fid="';
			h[++idx] = formIndex;
			h[++idx] = '"';
		}
		if(typeof qIndex !== "undefined") {
			h[++idx] = ' data-id="';
			h[++idx] = qIndex;
			h[++idx] = '"';
		}
		if(typeof list_name !== "undefined") {
			h[++idx] = ' data-list_name="';
			h[++idx] = list_name;
			h[++idx] = '"';
		}
		
		
		h[++idx] = '>';
		
		return h.join('');
	}
	
	function addQType(type) {
		
		var i,
			j,
			tArray,
			types = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.qTypes,
			h = [],
			idx = -1,
			name;
	
		for(i = 0; i < types.length; i++) {
			if(types[i].type === type) {
				name = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set[types[i].trans];
				h[++idx] = '<span class="has_tt" data-toggle="tooltip" title="Question type: ';
				h[++idx] = name;
				h[++idx] = '">';
				if(types[i].icon) {
					tArray = types[i].icon.split(',');
					for(j = 0; j < tArray.length; j++) {
						h[++idx] = '<i class="fas fa-';
						h[++idx] = tArray[j].trim();
						h[++idx] = ' edit_type"></i>';
					}
				} else if(types[i].image) {
					h[++idx] = '<img class="edit_image" src="';
					h[++idx] = types[i].image; 
					h[++idx] = '">';
				} else if(types[i].text) {
					h[++idx] = '<span class="edit_type">';
					h[++idx] = types[i].text; 
					h[++idx] = '</span>';
				}
				h[++idx] = '</span>';
				break;
			}
		}	
		return h.join('');

	}
	
	/*
	 * One of the questions properties will be featured so that it can be edited in the header without expanding the question
	 */
	function addFeaturedProperty(question, fId, qIndex, list_name, qname, questionId) {
		
		var h = [],
			idx = -1,
			type = "question";
		
		if(list_name) {
			type = "option";
		}
		
		h[++idx] = '<div class="col-sm-5 col-12 ';
		h[++idx] = type;
	
		h[++idx] = '">';
		
		if(list_name) {
			type = "option";
		}
		h[++idx] = getFeaturedMarkup(question, type, questionId);
		
		h[++idx] = '</div>';
		return h.join("");
	}

	/*
	 * Get Featured Markup for the question
	 */
	function getFeaturedMarkup(question, type, questionId) {
		var h = [],
			idx = -1,
			i,
			//linkedSurveys = globals.model.survey.linkedSurveys,
			selProperty = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty,
			selLabel = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelLabel,
			naMedia = '<div class="naMedia text-center">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_namedia"] + '</div>';
		
			if(selProperty === "required" && type === "question"
				&& question.type != "calculate") {		// Add a boolean type
				
				h[++idx] = '<div class="row">';
				
				h[++idx] = '<div class="col-sm-4">';
			    h[++idx] = '<button type="button" class="btn labelButton ';
			    if(question[selProperty]) {
			    	h[++idx] = 'prop_yes" ';
			    } else {
			    	h[++idx] = 'prop_no" ';
			    }
			    h[++idx] = ' data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				if(question[selProperty]) {
					h[++idx] = '<i class="fa fa-check-circle" aria-hidden="true"></i> ';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_yes"];
				} else {
					h[++idx] = '<i class="fa fa-times-circle" aria-hidden="true"></i> ';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_no"];
				}
			    h[++idx] = '</button>';
			    h[++idx] = '</div>';

			    /*
			     * Add the text area for the required response text
			     */
			    h[++idx] = '<div class="col-sm-4';
				if(!question[selProperty]) {
					h[++idx] = ' d-none';
				}
				h[++idx] = '">';
			    h[++idx] = '<textarea class="labelProp has_tt" tabindex="0" title="';
			    h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_msg'];
				h[++idx] = '" data-prop="required_msg" placeholder="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_msg'];
				h[++idx] = '">';
				h[++idx] = question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].required_msg;
				h[++idx] = '</textarea>';
			    h[++idx] = '</div>';

				/*
                * Add the text area for conditional required
                */
				h[++idx] = '<div class="col-sm-4';
				if(!question[selProperty]) {
					h[++idx] = ' d-none';
				}
				h[++idx] = '">';
				h[++idx] = '<textarea class="labelProp has_tt" tabindex="0" title="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_expression'];
				h[++idx] = '" data-prop="required_expression" placeholder="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_expression'];
				h[++idx] = '">';
				h[++idx] = question.required_expression;
				h[++idx] = '</textarea>';
				h[++idx] = '</div>';
			    
				h[++idx] ='</div>';		// End Row
				
			} else if(selProperty === "readonly" && type === "question"
				&& question.type != "calculate") {		// Add a boolean type
				
				h[++idx] = '<div class="row">';
				
				h[++idx] = '<div class="col-sm-6">';
			    h[++idx] = '<button type="button" class="btn labelButton ';
			    if(question[selProperty]) {
			    	h[++idx] = 'prop_yes" ';
			    } else {
			    	h[++idx] = 'prop_no" ';
			    }
			    h[++idx] = ' data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				h[++idx] = '<span>';
				if(question[selProperty]) {
					h[++idx] = '<i class="fa fa-check-circle" aria-hidden="true"></i> ';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_yes"];
				} else {
					h[++idx] = '<i class="fa fa-times-circle" aria-hidden="true"></i> ';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_no"];
				}
			    h[++idx] = '</span></button>';
			    h[++idx] = '</div>';

				/*
				 * Add the text area for conditional required
				 */
				h[++idx] = '<div class="col-sm-6';
				if(!question[selProperty]) {
					h[++idx] = ' d-none';
				}
				h[++idx] = '">';
				h[++idx] = '<textarea class="labelProp has_tt" tabindex="0" title="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_readonly'];
				h[++idx] = '" data-prop="readonly_expression" placeholder="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['ed_r_readonly'];
				h[++idx] = '">';
				h[++idx] = question.readonly_expression;
				h[++idx] = '</textarea>';
				h[++idx] = '</div>';
			    
				h[++idx] ='</div>';		// End Row
				
			} else if(selProperty === "autoplay" && type === "question"
				&& question.type != "calculate") {		// Add a radio buttons to select autoplay status
				
				h[++idx] = '<div class="btn-group" role="group" aria-label="Autoplay Selection" data-toggle="buttons-radio">';
					// Add "none" autoplay option
					h[++idx] = '<button data-prop="autoplay" type="button" class="btn btn-light labelButton ';
					if(question[selProperty] == "none") {
						h[++idx] = "active";
					}
					h[++idx] = '" value="none">None</button>';
					
					// Add video autoplay option
					h[++idx] = '<button data-prop="autoplay" type="button" class="btn btn-light labelButton ';
					if(question[selProperty] == "video") {
						h[++idx] = "active";
					}
					h[++idx] = '" value="video">Video</button>';
					
					// Add audio autoplay option
					h[++idx] = '<button data-prop="autoplay" type="button" class="btn btn-light labelButton ';
					if(question[selProperty] == "audio") {
						h[++idx] = "active";
					}
					h[++idx] = '" value="audio">';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_audio"];
					h[++idx] = '</button>';
					
				h[++idx] = '</div>';


			} else if(selProperty === "parameters" && type === "question") {		// Add button to select the parameters dialog
				h[++idx] = '<div class="row">';

				h[++idx] = '<div class="col-sm-6">';	    // start col
				h[++idx] = '<button type="button" class="btn btn-primary parameterButton"';
				h[++idx] = ' data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				h[++idx] = '<i class="fa fa-edit"></i> ';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_edit"];
				h[++idx] = '</button>';
				h[++idx] = '</div>';		// End Col

				/*
			     * Add the text area to display the parameters
			     */
				h[++idx] = '<div class="col-sm-6">';
				h[++idx] = '<textarea class="labelProp has_tt" data-toggle="tooltip" readonly title="';
				h[++idx] = selLabel;
				h[++idx] = '" data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				h[++idx] = question["parameters"];
				h[++idx] = '</textarea>';
				h[++idx] = '</div>';    // End Col

				h[++idx] ='</div>';		// End Row



			} else if(selProperty === "appearance" && type === "question") {		// Add button to select the appearance dialog
				h[++idx] = '<div class="row">';

				h[++idx] = '<div class="col-sm-6">';	    // start col
				h[++idx] = '<button type="button" class="btn btn-info appearanceButton"';
				h[++idx] = ' data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				h[++idx] = '<i class="fa fa-edit"></i> ';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_edit"];
				h[++idx] = '</button>';
				h[++idx] = '</div>';		// End Col

				/*
			     * Add the text area to display the appearances
			     */
				h[++idx] = '<div class="col-sm-6">';
				h[++idx] = '<textarea class="labelProp has_tt" data-toggle="tooltip" readonly title="';
				h[++idx] = selLabel;
				h[++idx] = '" data-prop="';
				h[++idx] = selProperty;
				h[++idx] = '">';
				h[++idx] = question["appearance"];
				h[++idx] = '</textarea>';
				h[++idx] = '</div>';    // End Col

				h[++idx] ='</div>';		// End Row


			} else if(selProperty === "media" && question.type != "calculate") {
				h[++idx] = '<div class="row">';
				if(type === "question" && (question.inMeta || question.source != "user" )) {
					h[++idx] = '<div class="col-sm-4 col-sm-offset-4">';
					h[++idx] = naMedia;
					h[++idx] = '</div>';
				} else {
					h[++idx] = addMedia("Image", 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].image, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].imageUrl, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].imageThumb);
			        
					h[++idx] = addMedia("Video", 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].video, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].videoUrl, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].videoThumb);
					
					h[++idx] = addMedia("Audio", 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audio, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audioUrl, 
							question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audioThumb);		
				}
				
			h[++idx] = '</div>';		// End of row

		} else {
			h[++idx] = '<textarea tabindex="0" class="labelProp has_tt';
			if((question.type === 'calculate' || question.type === 'server_calculate') && selProperty !== "appearance" && selProperty !== "parameters" && selProperty !== "display_name") {
				h[++idx] = ' calculate';
			}
			h[++idx] = '" data-toggle="tooltip" title="';
			if((question.type === 'calculate' || question.type === 'server_calculate') && selProperty !== "appearance" && selProperty !== "parameters" && selProperty !== "display_name") {
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_addcalc"];
			} else {
				h[++idx] = type === "option" ? "Choice Label" : selLabel;
			}
			h[++idx] = '" data-prop="';
			h[++idx] = selProperty;
			h[++idx] = '"';
			if(type === "option" && selProperty !== "label") {
				h[++idx] = ' readonly tabindex="-1"';
			}
			if(type === "question" && selProperty !== "appearance" && selProperty !== "parameters" &&
					((question.source != "user" && 
						question.type != "begin group" &&
						question.type != "begin repeat" &&
						question.type != "server_calculate" &&
						question.type != "pdf_field"
						))) {
				h[++idx] = ' readonly tabindex="-1">';
				h[++idx] = selLabel;
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_nreq"];
			} else {
				h[++idx] = '>';
				if(question.type === 'calculate' && selProperty !== "appearance" && selProperty !== "parameters" && selProperty !== "display_name") {
					h[++idx] = question.calculation;
				} else if(question.type === 'server_calculate' && selProperty !== "appearance" && selProperty !== "parameters" && selProperty !== "display_name") {
					if(question.server_calculation && question.server_calculation.expression) {
						h[++idx] = question.server_calculation.expression;
					}
				} else {
					if(selProperty === "label") { 
						h[++idx] = question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].text;
					} else if(selProperty === "hint") { 
						h[++idx] = question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].hint;
					} else if(selProperty === "constraint_msg") {
						h[++idx] = question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].constraint_msg || question.constraint_msg;    // Allow for multi language or single language message
					} else if(selProperty === "guidance_hint") {
						h[++idx] = question.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].guidance_hint;
					} else {
						h[++idx] = question[selProperty];
					}
				}
			}
			h[++idx] = '</textarea>';
		}
		
		return h.join("");
	}
	
	/*
	 * Add subform
	 */
	function addSubForm(parentFormIndex, parentQuestionIndex) {
		
		var h = [],
			idx = -1,
			//formName,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			forms = survey.forms,
			i,
			form;
		
		h[++idx] = '<ol class="list-unstyled">';
		
		//formName = question.name;
		
		for(i = 0; i < forms.length; i++) {
			form = forms[i];
			if(forms[i].parentFormIndex === parentFormIndex && forms[i].parentQuestionIndex === parentQuestionIndex) {			
				h[++idx] = addQuestions(forms[i], i);
				break;
			}
		}
		
		h[++idx] = '</ol>';
		
		return h.join("");
	}

	/*
	 * Add the questions for a form
	 */
	function addQuestions(form, formIndex) {
		var i,
			question,
			h = [],
			idx = -1,
			topLevelForm = false,
			lastRealQuestionId = -1,
			finalButtonName,
			groupButtonName,
			selProperty = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty;
		
		// Set the group counter for this form
		gGroupStacks[formIndex] = {
				groupStack: [],
				lastGroup: undefined
		}
		
		if(form) {
			addQuestionSequence(form);		// Add an array holding the question sequence if it does not already exist
			form.maxQuestion = 1;			// Add a number to use for the default next question in a form
			
			for(i = 0; i < form.qSeq.length; i++) {
				_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gHasItems = true;
				question = form.questions[form.qSeq[i]];
				
				// Ignore property type questions, questions that have been deleted and meta questions like end repeat
				if(!includeQuestion(question)) {
					continue;
				}
				
				if(question.type === "end group") {
					groupButtonName = question.name.substring(0, question.name.indexOf('_groupEnd'));

					// Remove the group from the group stack and set the "last group" value
					gGroupStacks[formIndex].groupStack.pop();
					gGroupStacks[formIndex].lastGroup = groupButtonName;
					
					h[++idx] = addNewQuestionButton(true, false, formIndex, groupButtonName, selProperty);
					
					// End the group
					h[++idx] = '</ul>';
					h[++idx] = '</div>';
					h[++idx] = '</li>';
					
					// Add a dummy dom entry for this end group
					h[++idx] = '<li style="display:none;" id="';
					h[++idx] = "question" + formIndex + "_" + form.qSeq[i];
					h[++idx] = '"';
					h[++idx] = ' data-fid="';
					h[++idx] = formIndex;
					h[++idx] = '" data-id="';
					h[++idx] = form.qSeq[i];
					h[++idx] = '"></li>';
					
				
					continue;
				}

				h[++idx] = addOneQuestion(form, question, formIndex, form.qSeq[i], true, selProperty, false);
			}
			if(form.parentFormIndex == -1) {
				topLevelForm = true;
				finalButtonName = undefined;
			} else {
				finalButtonName = form.name;
			}
			h[++idx] = addNewQuestionButton(true, topLevelForm, formIndex, finalButtonName, selProperty); 	// Adds a question at the end of the form
		}
		return h.join("");
	}

	/*
	 * Get the display sequence of the question by name
	 */
	function getIndexQuestionByName(name, form) {
		var i;
		
		for(i = 0; i < form.qSeq.length; i++) {
			if(form.questions[form.qSeq[i]].name === name) {
				return form.qSeq[i];
			}
		}
		alert("Could not find question with name: " + name);
		return 0;
	}
	
	/*
	 * Add the array containing the question sequence
	 * This will initially be the same as the order of questions but as new questions are added in the editor
	 *  then these new questions will be at the end of the question array
	 */
	function addQuestionSequence(form) {
		
		var i;
		
		if(!form.qSeq) {
			form.qSeq = [];
			for(i = 0; i < form.questions.length; i++) {
				form.qSeq[i] = i;		// Assume initial sequence corresponds to order of questions
			}
		}
	}
	

	
	/*
	 * Add a media type
	 */
	function addMedia(label, mediaIdent, url, thumbUrl) {
		var h = [],
			idx = -1,
			emptyMedia = '<div class="emptyMedia text-center">Empty</div>',
			lcLabel = label.toLowerCase();
		
		h[++idx] = '<div class="col-sm-3 ';
		h[++idx] = lcLabel;
		h[++idx] = 'Element">';
		if(mediaIdent) {
			h[++idx] = '<a target="_blank" href="';
			h[++idx] = url
			h[++idx] = '"';
		} else {
			h[++idx] = "<div";
		}
		h[++idx] = ' class="thumbnail preview">';

		if(mediaIdent) {
			if(thumbUrl || (lcLabel === "image" && url)) {
				h[++idx] = '<img height="100" width="100" src="';
				if(thumbUrl) {
					h[++idx] = thumbUrl + addCacheBuster(thumbUrl);;
				} else {
					h[++idx] = url + addCacheBuster(url) ;
				}
				h[++idx] = '">';
			} else {
				h[++idx] = addQType(lcLabel)
			}
		} else {
			h[++idx] = emptyMedia;
		}

		if(mediaIdent) {
			h[++idx] = '</a>';
		} else {
			h[++idx] = '</div>';
		}
	    h[++idx] = '<a type="button" class="btn btn-primary mediaProp form-control" data-element="';
	    h[++idx] = label.toLowerCase();
	    h[++idx] = '">';
	    h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_" + lcLabel];
	    h[++idx] = '</a>';
	 
	    h[++idx] = '</div>';
	    
	    return h.join("");
	}
	
	/*
	 * Refresh the content
	 */
	function refresh() {
		
		var content,
			i,
        	collapsedPanels = [];
		
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gElementIndex = 0;
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gHasItems = false;
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gNewQuestionButtonIndex = 0;
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gNewOptionButtonIndex = 0;
		
		if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gIsQuestionView) {
			content = refreshQuestions();
		} else {
			content = refreshChoiceListView();
		}
		
		// Get the current list of collapsed panels
		jquery__WEBPACK_IMPORTED_MODULE_0___default()('.collapse.show', '#formList').each(function(){
			collapsedPanels.push(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).closest('li').attr("id"));
		});
		
		// Update the content view
		jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList').html(content);
		
		// Restore collapsed panels
		for(i = 0; i < collapsedPanels.length; i++) {
			var $collapsedPanel = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + collapsedPanels[i]);
			$collapsedPanel.find('.collapse').first().addClass("show");
			$collapsedPanel.find('.edit_icon.fa-chevron-down').first().removeClass('fa-chevron-down').addClass('fa-chevron-up');
			
		}
		
		if(!_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gHasItems) {
			// If there were no items then set focus to the add new item button
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.add_final_button').focus();
		} 
		
		return jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList');		// Return the context of the updated HTML so that events can be applied
	}

	/*
	 * Refresh the featured properties
	 */
	function refreshQuestionFeaturedProperties() {

        var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;

		jquery__WEBPACK_IMPORTED_MODULE_0___default()('li.card.question').each(function() {
			var $this = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
			var fId = $this.data("fid");
			var id = $this.data("id");
			var question = survey.forms[fId].questions[id];

			$this.find('.card-body .row .question').html(getFeaturedMarkup(question, "question"));

		});

        return jquery__WEBPACK_IMPORTED_MODULE_0___default()('#formList');
	}

	/*
	 * Show the choice List view
	 */
	function refreshChoiceListView() {
		var h = [],
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			optionLists = survey.optionLists,
			idx = -1,
			name,
			nameArray = [],
			i;
		
		/*
		 * Process the choice lists in sequential order
		 */
		if(survey) {
			if(optionLists) {
				
				for (name in optionLists) {
					if (optionLists.hasOwnProperty(name)) {
					    nameArray.push(name);
					}
				}
				// Sort array of list names
				nameArray.sort();
				for(i = 0; i < nameArray.length; i++) {
					h[++idx] = addOneOptionList(nameArray[i], false, undefined);
				}
				h[++idx] = addNewOptionListButton(); 
			}
		}
		
		return h.join("");
	}
	
	/*
	 * Show the form on the screen
	 */
	function refreshQuestions() {
		
		var i,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			h = [],
			idx = -1;
		
		/*
		 * Process the questions in the top level form (parent is 0) 
		 *   Questions that are "begin repeat" type will link to sub level forms which are then processed in turn
		 * 
		 */
		if(survey) {
			if(survey.forms && survey.forms.length > 0) {
				for(i = 0; i < survey.forms.length; i++) {
					if(survey.forms[i].parentFormIndex == -1) {
						h[++idx] = addQuestions(survey.forms[i], i);
						break;
					}
				}
			}
		}


		gGroupStacks = [];		// save some memory
		
		return h.join("");


	}
	
	/*
	 * Return true for those questions that are of interest to the editor
	 */
	function includeQuestion(question) {
		if(question.propertyType || question.soft_deleted || question.type === "end repeat") {	
			return false;
		} else {
			return true;
		}
	}
	
	/*
	 * Get the questions for a linked survey
	 */
	function getLinkedQuestions(questionId, surveyId, qId) {
		if(linkedQuestions[surveyId]) {
			setTimeout(function() {
				showLinkedQuestions(questionId, linkedQuestions[surveyId], qId);
			}, 0);
		} else {
			addHourglass();
			jquery__WEBPACK_IMPORTED_MODULE_0___default().ajax({
				url: "/surveyKPI/questionList/" + surveyId + "/none",	// Will use the default language
				cache: false,
				dataType: 'json',
				success: function(data) {
					linkedQuestions[surveyId] = data;
					showLinkedQuestions(questionId, data, qId);
					removeHourglass();
				},
				error: function(xhr, textStatus, err) {
					removeHourglass();
					if(xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						bootbox.alert("Error failed to get questions for survey:" + surveyId);
						jquery__WEBPACK_IMPORTED_MODULE_0___default()("#" + questionId).find(".linkedQuestion").html("");
					}
				}
			});

		}

		
	}
	
	/*
	 * Show the linked questions in the drop down
	 */
	function showLinkedQuestions(questionId, data, qId) {
		
		var idx = -1,
			h = [],
			i;
		
		qId = +qId;
		h[++idx] = '<option value="0"';
		if(!qId) {
			h[++idx] = ' selected';
		}
		h[++idx] = '>Key</option>';
		if(data) {
			for(i = 0; i < data.length; i++) {
				if(data[i].q) {
					h[++idx] = '<option value="';
					h[++idx] = data[i].id;
					h[++idx] = '" ';
					if(data[i].id == qId) {
						h[++idx] = ' selected';
					} 
					h[++idx] = '>';
					h[++idx] = data[i].q;
					h[++idx] = '</option>';
				}
			}
		}
		
		jquery__WEBPACK_IMPORTED_MODULE_0___default()("#" + questionId).find(".linkedQuestion").html(h.join(''));
	}


/***/ },

/***/ "./WebContent/js/app/globals.js"
/*!**************************************!*\
  !*** ./WebContent/js/app/globals.js ***!
  \**************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Quick solution to issue of legacy globals after migrating to AMD / require.js
 */
const globals = {

        // Security groups
        GROUP_ADMIN: 1,
        GROUP_ANALYST: 2,
        GROUP_ENUM: 3,
        GROUP_ORG_ADMIN : 4,
        GROUP_MANAGE: 5,
        GROUP_SECURITY: 6,
        GROUP_VIEW_DATA: 7,
        GROUP_ENTERPRISE : 8,
        GROUP_OWNER : 9,
		GROUP_VIEW_OWN_DATA : 10,
	    GROUP_MANAGE_TASKS : 11,
	    GROUP_DASHBOARD : 12,
        GROUP_LINKAGES : 13,
        GROUP_CONSOLE_ADMIN : 14,
        GROUP_MCP_ACCESS : 15,

        REC_LIMIT: 200,     // Page size for table views in analysis
	    MAP_REC_LIMIT: 10000,    // Max size for map views in analysis

        gProjectList: undefined,
        gRoleList: undefined,
        gCmSettings: undefined,
        gCurrentProject: 0,
        gCurrentSurvey: 0,
        gCurrentSurveyIdent: undefined,
	    gGroupSurveys: {},
	    gSubForms: {},
        gCurrentForm: 0,
        gCurrentLayer: undefined,
        gLoggedInUser: undefined,
        gEditingReportProject: undefined,   		// Set if fieldAnalysis called to edit a report
        gIsAdministrator: false,
        gIsEnum: false,
        gIsAnalyst: false,
	    gIsDashboard: false,
        gIsManage: false,
        gIsOrgAdministrator: false,
        gIsSecurityAdministrator: false,
        gIsEnterpriseAdministrator: false,
        gIsLinkFollower: false,
        gIsServerOwner: false,
        gIsConsoleAdmin: false,
        gViewData: false,
	    gManageTasks: false,
        gBillingData: false,
        gOrgBillingData: false,
        gSendTrail: 'off',
        gViewIdx: 0,
        gSelector: new Selector(),
        gOrgId: 0,
        gTimezone: undefined,
	    gEnterpriseName: undefined,
	    gSetAsTheme: undefined,
	    gNavbarColor: undefined,

        gRegions: undefined,
        gRegion: {},

        gServerCanSendEmail: false,

        // Reports
        gEmailEnabled: false,
        gFacebookEnabled: false,
        gTwitterEnabled: false,

        // Tasks
        gCurrentUserId: undefined,
        gCurrentUserName: undefined,
        gAssignmentsLayer: undefined,
        gPendingUpdates: [],
        gCurrentTaskGroup: undefined,
	    gCurrentMailout: undefined,
        gTaskList: undefined,
        gCurrentSurveyIndex: 0,
	    gCurrentInstance: undefined,
        gAlertSeen: false,
        gLastAlertTime: undefined,

        // Editor
        gExistingSurvey: false,		// Set true if modifying an existing survey
        gElementIndex: 0,			// Manage creation of unique identifier for each element (question, option) in editor
        gHasItems: false,			// Set true if there are questions or choice lists in the survey
        gNewQuestionButtonIndex: 0,	// Manage creation of unique identifier for buttons that add new questions
        gNewOptionButtonIndex: 0,
        gSId: 0,
        gLanguage: 0,
        gLanguage1: 0,
        gLanguage2: 0,
        errors: [],
        changes: [],
        gErrorPosition: 0,
        gSelProperty: 'label',
        gSelLabel: 'Question Text',
        gSelQuestionProperty: 'label',
        gSelQuestionLabel: 'Question Text',
        gSelChoiceProperty: 'label',
        gSelChoiceLabel: 'Question Text',
        gIsQuestionView: true,
        gShowingChoices: false,
        gMaxOptionList: 0,
        gLatestOptionList: undefined,	// Hack to record the last option list name added
	    gCsvFiles: undefined,

        gListName: undefined,					// Choice Modal parameters, Set if started from choice list view
        gOptionList: undefined,					// The option list name applying to this set of choices
        gSelOptionId: undefined,				// Selected option index
        gFormIndex: undefined,					// Selected form index
        gItemIndex: undefined,					// Selected question index
        gSelectedFilters: undefined,
        gFilterArray: undefined,

        gSaveInProgress: false,

        // Dashboard
        gMainTable: undefined,			// Data tables
        gReports: undefined,			// reports
        gCharts: {},					// charts
	    gRecordMaps: [],                // Maps shown when editing a record
	    gRecordChangeMaps: [],          // Maps shown when viewing change history
        gMapLayersShown: false,
        gViewId: 0,						// Current survey view

	    gTraining: undefined,
	    gRefreshRate: 0,

        gMapboxDefault: undefined,		// Mapbox key
        
        model: typeof Model !== "undefined" ? new Model() : undefined

    }


    function Selector() {

        this.dataItems = {};
        this.surveys = {};
        this.surveysExtended = {};
        this.surveyLanguages = {};
        this.surveyQuestions = {};
        this.surveyMeta = {};
        this.surveyAlerts = {};
        this.questions = {};
        this.allSurveys = undefined;			// Simple list of surveys
        this.allRegions = undefined;
        this.sharedMaps = undefined;
        this.views = [];			// Simple list of views
        this.maps = {};				// map panels indexed by the panel id
        this.changed = false;
        this.SURVEY_KEY_PREFIX = "surveys";
        this.TASK_KEY = "tasks";
        this.TASK_COLOR = "#dd00aa";
        this.SURVEY_COLOR = "#00aa00";
        this.SELECTED_COLOR = "#0000aa";
        this.currentPanel = "map";

        this.getAll = function () {
            return this.dataItems;
        };

        this.getItem = function (key) {
            return this.dataItems[key];
        };

        this.addDataItem = function (key, data) {
            this.dataItems[key] = data;
        };

        this.clearDataItems = function () {
            this.dataItems = {};
        };

        this.addSurvey = function (sId, data) {
            this.surveys[sId] = data;
        };

        this.addSurveyExtended = function (sId, data) {
            this.surveysExtended[sId] = data;
        };

        this.getSurvey = function (sId) {
            return this.surveysExtended[sId] || this.surveys[sId];
        };

        this.clearSurveys = function () {
            this.surveys = {};
            this.surveysExtended = {};
            this.surveyLanguages = {};
            this.surveyQuestions = {};
            this.surveyMeta = {};
            this.surveyAlerts = {};
            this.allSurveys = undefined;
        };

        this.setSurveyList = function (data) {
            this.allSurveys = data;
        };

        this.getSurveyList = function () {
            return this.allSurveys;
        };

        this.setSurveyLanguages = function (sId, data) {
            this.surveyLanguages[sId] = data;
        };

        this.getSurveyLanguages = function (sId) {
            return this.surveyLanguages[sId];
        };

        this.setSurveyQuestions = function (sId, language, data) {
            if (!this.surveyQuestions[sId]) {
                this.surveyQuestions[sId] = {};
            }
            this.surveyQuestions[sId][language] = data;
        };

        this.getSurveyQuestions = function (sId, language) {
            if (!this.surveyQuestions[sId]) {
                return undefined;
            }
            if (typeof language === "undefined") {
                return this.surveyQuestions[sId];
            }
            return this.surveyQuestions[sId][language];
        };

        this.getQuestion = function (qId, language) {
            return this.getQuestionDetails(globals.gCurrentSurvey, qId, language);
        };

        this.getQuestionDetails = function (sId, qId, language) {
            var questions = this.getSurveyQuestions(sId, language);
            if (!questions) {
                return undefined;
            }
            for (var i = 0; i < questions.length; i++) {
                if (questions[i].id == qId) {
                    return questions[i];
                }
            }
            return undefined;
        };

        this.setSurveyMeta = function (sId, data) {
            this.surveyMeta[sId] = data;
        };

        this.getSurveyMeta = function (sId) {
            return this.surveyMeta[sId];
        };

        this.setSurveyAlerts = function (sId, data) {
            this.surveyAlerts[sId] = data;
        };

        this.getSurveyAlerts = function (sId) {
            return this.surveyAlerts[sId];
        };

        this.setRegionList = function (data) {
            this.allRegions = data;
        };

        this.getRegionList = function () {
            return this.allRegions;
        };

        this.setSharedMaps = function (data) {
            this.sharedMaps = data;
        };

        this.getSharedMaps = function () {
            return this.sharedMaps;
        };

        this.setViews = function (data) {
            this.views = data || [];
        };

        this.getViews = function () {
            return this.views;
        };

        this.setMap = function (idx, map) {
            this.maps[idx] = map;
        };

        this.getMap = function (idx) {
            return this.maps[idx];
        };

    }

    /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (globals);


/***/ },

/***/ "./WebContent/js/app/localise.js"
/*!***************************************!*\
  !*** ./WebContent/js/app/localise.js ***!
  \***************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

const $ = window.$;

const dtLangFiles = {
	en: "",
	es: "/js/libs/DataTables.i18n/es.json",
	ar: "/js/libs/DataTables.i18n/ar.json",
	fr: "/js/libs/DataTables.i18n/fr.json",
	pt: "/js/libs/DataTables.i18n/pt.json",
	hi: "/js/libs/DataTables.i18n/hi.json"
};

const localeCache = {};
let currentLocale = "en";

function normalizeLocale(locale) {
	if (!locale) {
		return "en";
	}
	return locale.toLowerCase().replace("_", "-");
}

function localeCandidates(locale) {
	const normalized = normalizeLocale(locale);
	const base = normalized.split("-")[0];
	const candidates = [];

	if (normalized && normalized !== "en") {
		candidates.push(normalized);
	}
	if (base && base !== normalized && base !== "en") {
		candidates.push(base);
	}
	if (!candidates.includes("root")) {
		candidates.push("root");
	}

	return candidates;
}

function parseAmdLocale(text) {
	const trimmed = text.trim();
	const prefix = "define(";
	const start = trimmed.indexOf(prefix);
	const end = trimmed.lastIndexOf(")");
	if (start === -1 || end === -1 || end <= start) {
		throw new Error("Invalid locale format");
	}
	const objectText = trimmed.slice(start + prefix.length, end).trim();
	const jsonText = objectText
		.replace(/\s*\/\/.*$/gm, "")
		.replace(/\s\/\*[\s\S]*?\*\//g, "")
		.trim();
	return JSON.parse(jsonText);
}

async function loadLocaleFile(locale) {
	if (localeCache[locale]) {
		return localeCache[locale];
	}

	const src = `/js/nls/${locale}/lang.js`;
	const data = await new Promise((resolve, reject) => {
		const previousDefine = window.define;
		const script = document.createElement("script");

		window.define = function (payload) {
			window.define = previousDefine;
			script.remove();
			resolve(payload);
		};
		window.define.amd = true;

		script.src = src;
		script.async = true;
		script.onerror = function () {
			window.define = previousDefine;
			script.remove();
			reject(new Error(`Locale ${locale} not found`));
		};

		document.head.appendChild(script);
	});

	localeCache[locale] = data;
	return data;
}

async function initLocale(locale) {
	const candidates = localeCandidates(locale);
	const rootLocale = await loadLocaleFile("root");
	let merged = { ...rootLocale };
	let resolvedLocale = "root";

	for (const candidate of candidates) {
		if (candidate === "root") {
			continue;
		}
		try {
			const data = await loadLocaleFile(candidate);
			merged = { ...merged, ...data };
			resolvedLocale = candidate;
			break;
		} catch (error) {
			// fallback to next candidate
		}
	}

	currentLocale = resolvedLocale;
	window.localise.set = merged;
	return merged;
}

window.localise = {
	setlang: function () {
		$(".lang").each(function() {
			const $this = $(this);
			const code = $this.data("lang");
			if (code) {
				$this.html(window.localise.set[code]);
			}
		});

		$(".lang_tt").each(function() {
			const $this = $(this);
			const code = $this.data("lang_tt");
			if (code) {
				$this.prop("title", window.localise.set[code]);
			}
		});

		$(".lang_ph").each(function() {
			const $this = $(this);
			const code = $this.data("lang_ph");
			if (code) {
				$this.prop("placeholder", window.localise.set[code]);
			}
		});

		if (typeof responsiveMobileMenu === "function") {
			rmmResizeLabels();
		}
	},
	set: {},
	dt: function() {
		return dtLangFiles[currentLocale] || dtLangFiles.en;
	},
	initLocale
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (window.localise);


/***/ },

/***/ "./WebContent/js/app/option.js"
/*!*************************************!*\
  !*** ./WebContent/js/app/option.js ***!
  \*************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globals */ "./WebContent/js/app/globals.js");
/* harmony import */ var _editorMarkup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./editorMarkup */ "./WebContent/js/app/editorMarkup.js");
/* harmony import */ var _changeset__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./changeset */ "./WebContent/js/app/changeset.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Functions for manipulating a choice in the editor
 * 
 *  Filter Model
 *    globals.gFilterArray:				Filters in display order
 *    survey.filters	Filters with state of shown or not shown
 */









/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({	
	refreshOptionListControls: refreshOptionListControls,
	createChoiceView: createChoiceView,
	setupChoiceView: setupChoiceView,					// On create of option view
	addOneOption: addOneOption,
	resetFilterColumns: resetFilterColumns,
	setPreviousChoices: setPreviousChoices,
	addOptionTable: addOptionTable,
	addFilter: addFilter,
	addFilterSelectList: addFilterSelectList,
	addOptionSequence: addOptionSequence
});

	
	_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray = [];			// Filters in repeatable order
	
	/*
	 * Refresh the select controls that show the available option lists
	 */
	function refreshOptionListControls() {
		var $selector = jquery__WEBPACK_IMPORTED_MODULE_0___default()(".option-lists");
		$selector.html(getOptionLists());
	}
	
	/*
	 * Create a choice view
	 */
	function createChoiceView() {
		
		var $cv = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView').find('.choice-content'),
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			question,
			filter,
			filterType = "none",
			i;
		
		if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gListName) {
			$cv.empty().append(addOptionContainer(undefined, undefined, undefined, _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gListName));
		} else {
			// Choice list opened from a question
			question = survey.forms[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFormIndex].questions[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gItemIndex];
			$cv.empty().append(addOptionContainer(question, _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFormIndex, _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gItemIndex, undefined));
		}
		addFilterSelectList(survey.filters);
		
		/*
		 * Set the filter type to custom if there are filters with a name other than _smap_cascade
		 */
		if(question) {
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.filter_only').show();

			if(question.choice_filter && question.choice_filter.trim().length > 0) {
				if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length > 0) {
					filterType = "custom";
				}
				if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length === 1) {
					if (_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[0] === "_smap_cascade") {
						filterType = "cascade";
					}
				}
			}
	
			// Set the custom filter view by default
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#filterType').val(filterType);
		}
		
		return $cv;
	}
	
	function setupChoiceView(filterType) {
		var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			i;
		/*
		 * show custom filter columns that should be visible
		 */
		for (i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length; i++) {
			if(survey.filters[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i]] === true) {
				jquery__WEBPACK_IMPORTED_MODULE_0___default()('table', '#choiceView').removeClass("hide" + i);
			}
		}
		
		if(filterType === "custom") {
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.custom_filter_only').show();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.cascade_filter_only').hide();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView table').addClass("notcascade").removeClass("notcustom");	
		} else if(filterType === "cascade") {
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.custom_filter_only').hide();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.cascade_filter_only').show();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView table').removeClass("notcascade").addClass("notcustom");
		} else {
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.custom_filter_only').hide();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('.cascade_filter_only').hide();
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceView table').addClass("notcascade").addClass("notcustom");	
		}

	}

	/*
	 * Add a single option
	 */
	function addOneOption(optionList, option, formIndex, index, list_name, qname) {
		
		var h = [],
			idx = -1,
			prevChoice = jquery__WEBPACK_IMPORTED_MODULE_0___default()("#previousSelectChoice").val(),
			filterType = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#filterType').val();
		
		optionList.maxOption++;
		
		if(filterType !== "cascade" || showCascadeOption(option.cascade_filters, prevChoice,  option.value) ) {
			h[++idx] = '<tr class="editor_element option draggable dropon ';
			if(option.error) {
				h[++idx] = ' error';
			}
			
			// Add the option index 
			h[++idx] = '" data-id="';
			h[++idx] = index;
			h[++idx] = '" data-fid="';					
			h[++idx] = formIndex;
			h[++idx] = '" data-qname="';
			h[++idx] = qname;
			h[++idx] = '" data-list_name="';
			h[++idx] = list_name;
			h[++idx] = '" data-filters=';
			h[++idx] = JSON.stringify(option.cascade_filters);
			h[++idx] = '>';
			
				// Add select for cascade selects
				h[++idx] = '<td class="cascade">';
					h[++idx] = '<input type="checkbox" class="cascadeFilter" name="isSelected" value="';
					h[++idx] = "";
					h[++idx] = '" ';
					if(idx !== false) {
						h[++idx] = addCascadeChecked(option.cascade_filters, prevChoice);
					} 
					h[++idx] = '>';
				h[++idx] = '</td>';
				
				// Add option name and value cell
				h[++idx] = '<td>';
						h[++idx] = '<div class="dropdown">';
						h[++idx] = '<button type="button" class="btn btn-secondary btn-lg dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-bars" aria-hidden="true"></i> ';
						h[++idx] = '</button>';
							h[++idx] = '<div class="dropdown-menu">';
								h[++idx] = '<a href="javascript:void(0)" class="dropdown-item delete_option">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_del"];
								h[++idx] = '</a>';
								h[++idx] = '<a href="javascript:void(0)" class="dropdown-item add_option_before">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_ab"];
								h[++idx] = '</a>';
								h[++idx] = '<a href="javascript:void(0)" class="dropdown-item add_option_after">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_aa"];
								h[++idx] = '</a>';
							h[++idx] = '</div>';
						h[++idx] = '</div>';
				h[++idx] = '</td>';	// End of menu button
				
				// Add option name cell
				h[++idx] = '<td>';
					
					h[++idx] = '<input class="oname form-control has_tt" value="';
					h[++idx] = option.value;
					h[++idx] = '" ';

					h[++idx] = ' type="text" title="';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cval"];
					h[++idx] = '">';
							
				h[++idx] = '</td>';	// End of option name and label cell

				h[++idx] = addFilterColumnBody(option.cascade_filters);
				h[++idx] = addOptionLabel(option);
				
			
			h[++idx] = '</tr>';
		}

	
		return h.join("");
	}
	
	function resetFilterColumns() {
		var i,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;
		
		for (i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length; i++) {
			if(survey.filters[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i]] === true) {
				jquery__WEBPACK_IMPORTED_MODULE_0___default()('table', '#choiceView').removeClass("hide" + i);
			} else {
				jquery__WEBPACK_IMPORTED_MODULE_0___default()('table', '#choiceView').addClass("hide" + i);
			}
			
		}
	}
	
	/*
	 * Add an option container
	 */
	function addOptionContainer(question, formIndex, qIndex, listName) {
		var h = [],
			idx = -1,
			filter;
		
		h[++idx] = '<div class="question_head" data-fId="';
		h[++idx] = formIndex;
		h[++idx] = '" data-id="';
		h[++idx] = qIndex;
		h[++idx] = '">';
		h[++idx] = '<div class="question-controls">';
			h[++idx] = '<div class="row">';
				h[++idx] = '<div class="col-md-6">';
					h[++idx] = '<form role="form">';
						
						// A control to set option list name
						if(!listName) {
							h[++idx] = '<div class="form-group row">';
								h[++idx] = '<label class="col-sm-2">';
									h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cl"];
								h[++idx] = '</label>';
								h[++idx] = '<div class="col-sm-10">';
									h[++idx] = '<select class="form-control option-lists">';
									h[++idx] = getOptionLists();
									h[++idx] = '</select>';
								h[++idx] = '</div>';
							h[++idx] = '</div>';
						}

						// A control to select the filter type
						h[++idx] = '<div class="form-group row filter_only" style="display:none;">';
							h[++idx] = '<label class="col-sm-2">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_filter"];
							h[++idx] = '</label>';
							h[++idx] = '<div class="col-sm-10">';
								h[++idx] = '<select class="form-control" id="filterType">';
								
								h[++idx] = '<option value="none">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"];
								h[++idx] = '</option>';
								
								h[++idx] = '<option value="cascade">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cs"];
								h[++idx] = '</option>';
								
								h[++idx] = '<option value="custom">';
								h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cf"];
								h[++idx] = '</option>';
								
								h[++idx] = '</select>';
							h[++idx] = '</div>';
						h[++idx] = '</div>';
						
					h[++idx] = '</form>';
				h[++idx] = '</div>';
				h[++idx] = '<div class="col-md-6">';
					h[++idx] = '<div class="text-right">';
				    h[++idx] = '<button class="btn btn-primary exitOptions mb-2">';
						h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_back"];
					h[++idx] = '</button>';
					h[++idx] = '</div>';
					h[++idx] = '<div class="custom_filter_only" style="display:none;">';
						h[++idx] = '<form role="form">';
						
							if(!listName) {
								h[++idx] = '<div class="form-group row">';
									h[++idx] = '<label class="col-sm-2">';
									h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_choice_f"];
									h[++idx] = '</label>';
									h[++idx] = '<div class="col-sm-8">';
										h[++idx] = '<textarea id="choiceFilter" class="input-block" form-control has_tt" type="text">';
										h[++idx] = question.choice_filter;
										h[++idx] = '</textarea>';
										h[++idx] = addChoiceFilterError(question.errorMsg);
									h[++idx] = '</div>';
								h[++idx] = '</div>';
							}
							
							h[++idx] = '<div id="custom_filters">';
							h[++idx] = '</div>';
						h[++idx] = '</form>';
						h[++idx] = '<button id="addFilter" class="btn btn-light mt-2">';
						h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_afc"];
						h[++idx] = '</button>';
					h[++idx] = '</div>';  // Custom filter only
					
					h[++idx] = '<div class="cascade_filter_only" style="display:none;">';
						h[++idx] = '<form role="form">';

							h[++idx] = '<div class="form-group row">';
								h[++idx] = '<label class="col-sm-2">';
									h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cspq"];
								h[++idx] = '</label>';
								h[++idx] = '<div class="col-sm-10">';
									h[++idx] = '<select class="form-control" id="previousSelect">';
										h[++idx] = addSelectQuestions(question);
									h[++idx] = '</select>';
								h[++idx] = '</div>';
							h[++idx] = '</div>';
			
							h[++idx] = '<div class="form-group row">';
								h[++idx] = '<label class="col-sm-2">';
									h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_csp"];
								h[++idx] = '</label>';
								h[++idx] = '<div class="col-sm-10">';
									h[++idx] = '<select class="form-control" id="previousSelectChoice">';	
									h[++idx] = '</select>';
								h[++idx] = '</div>';
							h[++idx] = '</div>';
						h[++idx] = '</form>';
					h[++idx] = '</div>';	// Cascade filter only
				h[++idx] = '</div>';
			h[++idx] = '</div>';
		h[++idx] = '</div>';
	
		h[++idx] = '<div id="optionTable">';	
		h[++idx] = '</div>';	// Option Table
		h[++idx] = '</div>';		// Question Head
		
		return h.join("");
	}

	/*
	 * Refresh the table of options
	 */
	function addOptionTable(question, formIndex, listName) {
		var h = [],
			idx = -1,
			$element = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#optionTable');
		
		if(listName) {
			h[++idx] = addOptions(undefined, undefined, listName);
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceViewQuestion').html(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cl"] + ": " + listName);
		} else {
			// Opened from a specific question
			h[++idx] = addOptions(question, formIndex, undefined);
			jquery__WEBPACK_IMPORTED_MODULE_0___default()('#choiceViewQuestion').html(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_question"] + ": " + question.name);
		}
		
		$element.html(h.join());
		
		// Add styling to cascading select checkboxes
		jquery__WEBPACK_IMPORTED_MODULE_0___default()('[type="checkbox"]', '#optionTable').iCheck({
		    checkboxClass: 'icheckbox_square-green',
		    radioClass: 'iradio_square-green'
		});
	}
	
	/*
	 * Add filter to filters if not already there
	 */
	function addFilter(filter) {
		var i,
			hasFilter = false,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;
		
		for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length; i++) {
			if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i] === filter) {
				hasFilter = true;
			}
		}
		if(!hasFilter) {
			_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.push(filter);
		}
		
		if(!survey.filters) {
			survey.filters = {};
		}
		survey.filters[filter] = true;
	}
	
	/*
	 * Add the filters as  a select list
	 */
	function addFilterSelectList(filters) {
		var h = [],
			idx = -1,
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			filter;
		
		_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray = [];
		for(filter in filters) {
			if (filters.hasOwnProperty(filter)) {
				_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.push(filter);	// Save filters as ordered array
				h[++idx] = '<div class="checkbox">';
			      h[++idx] = '<input type="checkbox" ';
			      if(survey.filters[filter]) {
			    	  h[++idx] = 'checked=true ';
			      }
			      h[++idx] = 'value="';
			      h[++idx] = filter;
			      h[++idx] = '"> ';
				  h[++idx] = '<label>';
			      h[++idx] = filter
			    h[++idx] = '</label>';
			    h[++idx] = '</div>';
			}
		}
		
		jquery__WEBPACK_IMPORTED_MODULE_0___default()('#custom_filters').html(h.join(""));
		
		// Style checkboxes
		jquery__WEBPACK_IMPORTED_MODULE_0___default()('[type="checkbox"]', '#custom_filters').iCheck({
		    checkboxClass: 'icheckbox_square-green',
		    radioClass: 'iradio_square-green'
		});
	}
	
	/*
	 * Show the options
	 */
	function addOptions(question, formIndex, list_name) {
		var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			optionList,
			questionName,
			oSeq,
			maxIndex,
			h = [],
			idx = -1,
			i,
			initialiseFilters = false;
		
		if(!list_name) {		// Options attached to a question
			list_name = question.list_name;
			questionName = question.name;
		} 
		optionList = survey.optionLists[list_name];
		
		if(typeof optionList !== "undefined") {
			optionList.maxOption = 0;
			
			addOptionSequence(optionList);		// Add an array holding the option sequence if it does not already exist
			oSeq = optionList.oSeq;
			
			h[++idx] = '<div class="table-responsive">';
			h[++idx] = '<table class="table notcustom hide0 hide1 hide2 hide3 hide4">';
			
			h[++idx] = '<thead class="thead-default"><tr>';
			
				h[++idx] = '<th class="cascade">';
				h[++idx] = '</th>';
			
				h[++idx] = '<th>';
				h[++idx] = '</th>';
				
				h[++idx] = '<th>';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_cval"];
				h[++idx] = '</th>';

				//h[++idx] = '<th>';
				//h[++idx] = localise.set["ed_dn"];
				//h[++idx] = '</th>';

				h[++idx] = addFilterColumnHeadings();
				
				h[++idx] = '<th>';
				if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty === 'media') {
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_media"];
				} else if(_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty === 'display_name') {
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_dn"];
				} else {
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_clab"];
				}
				h[++idx] = '</th>';
				
			h[++idx] = '</tr></thead>';
			h[++idx] = '<tbody>';
			if(oSeq) {
				maxIndex = 0;
				for(i = 0; i < oSeq.length; i++) {
					h[++idx] = addOneOption(optionList,
							optionList.options[oSeq[i]], 
							formIndex, 
							oSeq[i], 
							list_name, 
							questionName);
					if(oSeq[i] >= maxIndex) {
						maxIndex = oSeq[i] + 1;
					}
				}
			}
			h[++idx] = '</tbody>';
			h[++idx] = '</table>';
			h[++idx]= '</div>';
			h[++idx] = addNewOptionButton(true, list_name, formIndex, questionName, -1); 
		}
		return h.join("");
	}
	
	/*
	 * Add the array containing the option sequence
	 */
	function addOptionSequence(optionList) {
		var i;
		
		if(!optionList.oSeq) {
			optionList.oSeq = [];
			for(i = 0; i < optionList.options.length; i++) {
				optionList.oSeq[i] = i;
			}
		}
	}
	
	
	/*
	 * One of the questions properties will be featured so that it can be edited in the header without expanding the question
	 */
	function addOptionLabel(option) {
		
		var h = [],
			idx = -1,
			selProperty = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gSelProperty;
		
		h[++idx] = '<td class="option">';
			if(selProperty === "media") {
				h[++idx] = '<div class="row">';
				h[++idx] = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Image", 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].image, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].imageUrl, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].imageThumb);
		        
				h[++idx] = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Video", 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].video, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].videoUrl, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].videoThumb);
				
				h[++idx] = _editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addMedia("Audio", 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audio, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audioUrl, 
						option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].audioThumb);
				h[++idx] = '</div>';

			} else if(selProperty === "display_name") {
				h[++idx] = '<textarea class="odisplayname has_tt" title="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_dn"];
				h[++idx] = '">';
				h[++idx] = option.display_name;
				h[++idx] = '</textarea>';
				h[++idx] = addOptionErrorMsg(option.errorMsg);

			} else {
				h[++idx] = '<textarea data-toggle="tooltip" class="labelProp has_tt" title="';
				h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_clab"];
				h[++idx] = '">';
				h[++idx] = option.labels[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage].text;
				h[++idx] = '</textarea>';
				h[++idx] = addOptionErrorMsg(option.errorMsg);
			}
		
		h[++idx] = '</td>';
		return h.join("");
	}
	
	function addNewOptionButton(after, list_name, formIndex, qname, index) {
		var h = [],
			idx = -1,
			addButtonClass,
			locn;
		
		addButtonClass = after ? 'add_after_button add_button' : 'add_before_button add_button';
		locn = after ? 'after' : 'before';
		
		h[++idx] = '<button type="button" class="add_option btn btn-primary dropon option editor_element add_after_button"';
		if(typeof index !== "undefined") {
			h[++idx] = ' data-id="';
			h[++idx] = index;
			h[++idx] = '"';
		}
		if(typeof list_name !== "undefined") {
			h[++idx] = ' data-list_name="';
			h[++idx] = list_name;
			h[++idx] = '"';
		}
		if(typeof qname !== "undefined") {
			h[++idx] = ' data-qname="';
			h[++idx] = qname;
			h[++idx] = '"';
		}
		if(typeof formIndex !== "undefined") {
			h[++idx] = ' data-fid="';
			h[++idx] = formIndex;
			h[++idx] = '"';
		}
		h[++idx] = '>';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_anc"];
		h[++idx] = ' </button>';

		
		return h.join('');
	}
	
	/*
	 * Get an array of option list names sorted alphabetically
	 */
	function getOptionLists() {
		
		var lists = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.optionLists,
			name,
			nameArray = [],
			h = [],
			idx = -1,
			i;

		// get the names into an array so they can be sorted
		for (name in lists) {
			if (lists.hasOwnProperty(name)) {
			    nameArray.push(name);
			}
		}
		// Sort array of list names
		nameArray.sort();
		
		// Create html
		for(i = 0; i < nameArray.length; i++) {
			h[++idx] = '<option value ="';
			h[++idx] = nameArray[i];
			h[++idx] = '">';
			h[++idx] = nameArray[i];
			h[++idx] = '</option>';
		}
		return h.join("");
	}
	
	/*
	 * Add the table headings for filter columns
	 */
	function addFilterColumnHeadings() {
		
		var i,
			h = [],
			idx = -1;
		
		for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length; i++) {
			h[++idx] = '<th class="f';		// Class to hide / show filter
			h[++idx] = i;
			h[++idx] = '">';
			h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i];
			h[++idx] = '</th>';
		}
		
		return h.join("");
	}
	
	/*
	 * Add the table body for filter columns
	 */
	function addFilterColumnBody(filters) {
		
		var i,
			h = [],
			idx = -1;
		
		for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray.length; i++) {
			h[++idx] = '<td class="f';		// Class to hide / show filter
			h[++idx] = i;
			h[++idx] = '" data-f_name="';
			h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i];
			h[++idx] = '">';
			h[++idx] = '<input class="filter form-control data-toggle="tooltip" has_tt" value="';
			h[++idx] = filters ? filters[_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gFilterArray[i]] : "";
			h[++idx] = '" ';	
			h[++idx] = ' type="text" title="';
			h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_fv"];
			h[++idx] = '">';
			
			h[++idx] = '</td>';
			
		}
		
		return h.join("");
	}
	
	/*
	 * Add a media type
	 */
	function addOptionMedia(label, mediaIdent, url, thumbUrl) {
		var h = [],
			idx = -1,
			emptyMedia = '<div class="emptyMedia text-center">Empty</div>',
			lcLabel = label.toLowerCase();
		
		h[++idx] = '<div class="col-sm-3 ';
		h[++idx] = lcLabel;
		h[++idx] = 'Element">';
		if(mediaIdent) {
			h[++idx] = '<a target="_blank" href="';
			h[++idx] = url
			h[++idx] = '"';
		} else {
			h[++idx] = "<div";
		}
		h[++idx] = ' class="thumbnail preview">';

		if(mediaIdent) {
			if(thumbUrl || (lcLabel === "image" && url)) {
				h[++idx] = '<img height="100" width="100" src="';
				if(thumbUrl) {
					h[++idx] = thumbUrl;
				} else {
					h[++idx] = url;
				}
				h[++idx] = '">';
			} else {
				h[++idx] = addQType(lcLabel)
			}
		} else {
			h[++idx] = emptyMedia;
		}

		if(mediaIdent) {
			h[++idx] = '</a>';
		} else {
			h[++idx] = '</div>';
		}
	    h[++idx] = '<a type="button" class="btn btn-default mediaProp form-control" data-element="';
	    h[++idx] = label.toLowerCase();
	    h[++idx] = '">';
	    h[++idx] = lcLabel;
	    h[++idx] = '</a>';
	 
	    h[++idx] = '</div>';
	    
	    return h.join("");
	}
	
	function addOptionErrorMsg(msg) {
		var h = [],
			idx = -1;
		
		h[++idx] = '<div class="error-msg pull-right">';
		h[++idx] = msg;
		h[++idx] = '</div>';
		return h.join("");
	}
	
	function addChoiceFilterError(msg) {
		var h = [],
			idx = -1;
		
		h[++idx] = '<div class="error-msg choice_filter_error pull-right">';
		h[++idx] = msg;
		h[++idx] = '</div>';
		return h.join("");
	}
	
	/*
	 * Add a list of select questions that can be selected as the preceeding question for a cascade select
	 */
	function addSelectQuestions(choiceQuestion) {
		var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			h = [],
			idx = -1,
			i, j,
			form,
			question,
			first = true;
			
		for(i = 0; i < survey.forms.length; i++) {
			form = survey.forms[i];
			_editorMarkup__WEBPACK_IMPORTED_MODULE_3__["default"].addQuestionSequence(form);		// Add the sequence for the questions if it has not already been added
			for(j = 0; j < form.qSeq.length; j++) {
				question = form.questions[form.qSeq[j]];
				if(!question.soft_deleted && question.type === "select1") {
					if(choiceQuestion && choiceQuestion.name === question.name) {
						continue;		// Skip question being edited
					}
					h[++idx] = '<option ';
					if(first) {
						h[++idx] = 'selected ';
					}
					h[++idx] = 'value="';
					h[++idx] = question.list_name;
					h[++idx] = '">';
					h[++idx] = question.name;
					h[++idx] = '</option>';
				}
			}
		}
	
		return h.join("");
	}
	
	/*
	 * Set the choices that can be selected as the preceeding choice for a cascade select
	 */
	function setPreviousChoices(listname) {
		
		var survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			h = [],
			idx = -1,
			i,
			option,
			optionList = survey.optionLists[listname],
			oSeq;
			
		addOptionSequence(optionList);		// Add an array holding the option sequence if it does not already exist
		oSeq = optionList.oSeq;
		
		for(i = 0; i < oSeq.length; i++) {

			option = optionList.options[oSeq[i]];
				
			h[++idx] = '<option ';
				if(i == 0) {
					h[++idx] = 'selected ';
				}
				h[++idx] = 'value="';
				h[++idx] = option.value;
				h[++idx] = '">';
				h[++idx] = option.value;
			h[++idx] = '</option>';
		}
		jquery__WEBPACK_IMPORTED_MODULE_0___default()("#previousSelectChoice").html(h.join(""));
	}
	
	/*
	 * Set the checkbox checked if the cascade filter matches the previously selected choice
	 */
	function addCascadeChecked (filters, prevChoice) {
		
		var match = false;
		
		if(filters) {
			if(filters["_smap_cascade"] && filters["_smap_cascade"] == prevChoice) {
				match = true;
			}
		}
		
		if(match) {
			return 'checked="checked"';
		} else {
			return '';
		}
	}
	
	/*
	 * As this is the cascade view options should only be shown if their filter value is empty or 
	 *  matches the prevChoice
	 */
	function showCascadeOption (filters, prevChoice, optionValue) {
		
		var show = false,
			i,
			inOptionList = false,
			listname = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#previousSelect').val(),
			survey = _globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
			optionList = survey.optionLists[listname],
			oSeq,
			option;
		
		if(listname) {
			addOptionSequence(optionList);		// Add an array holding the option sequence if it does not already exist
			oSeq = optionList.oSeq
			for(i = 0; i < oSeq.length; i++) {
				option = optionList.options[oSeq[i]];
				if(filters["_smap_cascade"] == option.value) {
					inOptionList = true;
					break;
				}
			}
						
			if(!filters["_smap_cascade"] || filters["_smap_cascade"] == prevChoice || !inOptionList) {
				show = true;
			}
		} else {
			show = true;		// No previous list set
		}
		
		return show;
	}


/***/ },

/***/ "./WebContent/js/libs/bootbox.min.js"
/*!*******************************************!*\
  !*** ./WebContent/js/libs/bootbox.min.js ***!
  \*******************************************/
(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/**
 * bootbox.js v4.3.0
 *
 * http://bootboxjs.com/license.txt
 */
!function(a,b){"use strict"; true?!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "jquery")], __WEBPACK_AMD_DEFINE_FACTORY__ = (b),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)):0}(this,function a(b,c){"use strict";function d(a){var b=q[o.locale];return b?b[a]:q.en[a]}function e(a,c,d){a.stopPropagation(),a.preventDefault();var e=b.isFunction(d)&&d(a)===!1;e||c.modal("hide")}function f(a){var b,c=0;for(b in a)c++;return c}function g(a,c){var d=0;b.each(a,function(a,b){c(a,b,d++)})}function h(a){var c,d;if("object"!=typeof a)throw new Error("Please supply an object of options");if(!a.message)throw new Error("Please specify a message");return a=b.extend({},o,a),a.buttons||(a.buttons={}),a.backdrop=a.backdrop?"static":!1,c=a.buttons,d=f(c),g(c,function(a,e,f){if(b.isFunction(e)&&(e=c[a]={callback:e}),"object"!==b.type(e))throw new Error("button with key "+a+" must be an object");e.label||(e.label=a),e.className||(e.className=2>=d&&f===d-1?"btn-primary":"btn-default")}),a}function i(a,b){var c=a.length,d={};if(1>c||c>2)throw new Error("Invalid argument length");return 2===c||"string"==typeof a[0]?(d[b[0]]=a[0],d[b[1]]=a[1]):d=a[0],d}function j(a,c,d){return b.extend(!0,{},a,i(c,d))}function k(a,b,c,d){var e={className:"bootbox-"+a,buttons:l.apply(null,b)};return m(j(e,d,c),b)}function l(){for(var a={},b=0,c=arguments.length;c>b;b++){var e=arguments[b],f=e.toLowerCase(),g=e.toUpperCase();a[f]={label:d(g)}}return a}function m(a,b){var d={};return g(b,function(a,b){d[b]=!0}),g(a.buttons,function(a){if(d[a]===c)throw new Error("button key "+a+" is not allowed (options are "+b.join("\n")+")")}),a}var n={dialog:"<div class='bootbox modal' tabindex='-1' role='dialog'><div class='modal-dialog'><div class='modal-content'><div class='modal-body'><div class='bootbox-body'></div></div></div></div></div>",header:"<div class='modal-header'><h4 class='modal-title'></h4></div>",footer:"<div class='modal-footer'></div>",closeButton:"<button type='button' class='bootbox-close-button close' data-dismiss='modal' aria-hidden='true'>&times;</button>",form:"<form class='bootbox-form'></form>",inputs:{text:"<input class='bootbox-input bootbox-input-text form-control' autocomplete=off type=text />",textarea:"<textarea class='bootbox-input bootbox-input-textarea form-control'></textarea>",email:"<input class='bootbox-input bootbox-input-email form-control' autocomplete='off' type='email' />",select:"<select class='bootbox-input bootbox-input-select form-control'></select>",checkbox:"<div class='checkbox'><label><input class='bootbox-input bootbox-input-checkbox' type='checkbox' /></label></div>",date:"<input class='bootbox-input bootbox-input-date form-control' autocomplete=off type='date' />",time:"<input class='bootbox-input bootbox-input-time form-control' autocomplete=off type='time' />",number:"<input class='bootbox-input bootbox-input-number form-control' autocomplete=off type='number' />",password:"<input class='bootbox-input bootbox-input-password form-control' autocomplete='off' type='password' />"}},o={locale:"en",backdrop:!0,animate:!0,className:null,closeButton:!0,show:!0,container:"body"},p={};p.alert=function(){var a;if(a=k("alert",["ok"],["message","callback"],arguments),a.callback&&!b.isFunction(a.callback))throw new Error("alert requires callback property to be a function when provided");return a.buttons.ok.callback=a.onEscape=function(){return b.isFunction(a.callback)?a.callback():!0},p.dialog(a)},p.confirm=function(){var a;if(a=k("confirm",["cancel","confirm"],["message","callback"],arguments),a.buttons.cancel.callback=a.onEscape=function(){return a.callback(!1)},a.buttons.confirm.callback=function(){return a.callback(!0)},!b.isFunction(a.callback))throw new Error("confirm requires a callback");return p.dialog(a)},p.prompt=function(){var a,d,e,f,h,i,k;if(f=b(n.form),d={className:"bootbox-prompt",buttons:l("cancel","confirm"),value:"",inputType:"text"},a=m(j(d,arguments,["title","callback"]),["cancel","confirm"]),i=a.show===c?!0:a.show,a.message=f,a.buttons.cancel.callback=a.onEscape=function(){return a.callback(null)},a.buttons.confirm.callback=function(){var c;switch(a.inputType){case"text":case"textarea":case"email":case"select":case"date":case"time":case"number":case"password":c=h.val();break;case"checkbox":var d=h.find("input:checked");c=[],g(d,function(a,d){c.push(b(d).val())})}return a.callback(c)},a.show=!1,!a.title)throw new Error("prompt requires a title");if(!b.isFunction(a.callback))throw new Error("prompt requires a callback");if(!n.inputs[a.inputType])throw new Error("invalid prompt type");switch(h=b(n.inputs[a.inputType]),a.inputType){case"text":case"textarea":case"email":case"date":case"time":case"number":case"password":h.val(a.value);break;case"select":var o={};if(k=a.inputOptions||[],!k.length)throw new Error("prompt with select requires options");g(k,function(a,d){var e=h;if(d.value===c||d.text===c)throw new Error("given options in wrong format");d.group&&(o[d.group]||(o[d.group]=b("<optgroup/>").attr("label",d.group)),e=o[d.group]),e.append("<option value='"+d.value+"'>"+d.text+"</option>")}),g(o,function(a,b){h.append(b)}),h.val(a.value);break;case"checkbox":var q=b.isArray(a.value)?a.value:[a.value];if(k=a.inputOptions||[],!k.length)throw new Error("prompt with checkbox requires options");if(!k[0].value||!k[0].text)throw new Error("given options in wrong format");h=b("<div/>"),g(k,function(c,d){var e=b(n.inputs[a.inputType]);e.find("input").attr("value",d.value),e.find("label").append(d.text),g(q,function(a,b){b===d.value&&e.find("input").prop("checked",!0)}),h.append(e)})}return a.placeholder&&h.attr("placeholder",a.placeholder),a.pattern&&h.attr("pattern",a.pattern),f.append(h),f.on("submit",function(a){a.preventDefault(),a.stopPropagation(),e.find(".btn-primary").click()}),e=p.dialog(a),e.off("shown.bs.modal"),e.on("shown.bs.modal",function(){h.focus()}),i===!0&&e.modal("show"),e},p.dialog=function(a){a=h(a);var c=b(n.dialog),d=c.find(".modal-dialog"),f=c.find(".modal-body"),i=a.buttons,j="",k={onEscape:a.onEscape};if(g(i,function(a,b){j+="<button data-bb-handler='"+a+"' type='button' class='btn "+b.className+"'>"+b.label+"</button>",k[a]=b.callback}),f.find(".bootbox-body").html(a.message),a.animate===!0&&c.addClass("fade"),a.className&&c.addClass(a.className),"large"===a.size&&d.addClass("modal-lg"),"small"===a.size&&d.addClass("modal-sm"),a.title&&f.before(n.header),a.closeButton){var l=b(n.closeButton);a.title?c.find(".modal-header").prepend(l):l.css("margin-top","-10px").prependTo(f)}return a.title&&c.find(".modal-title").html(a.title),j.length&&(f.after(n.footer),c.find(".modal-footer").html(j)),c.on("hidden.bs.modal",function(a){a.target===this&&c.remove()}),c.on("shown.bs.modal",function(){c.find(".btn-primary:first").focus()}),c.on("escape.close.bb",function(a){k.onEscape&&e(a,c,k.onEscape)}),c.on("click",".modal-footer button",function(a){var d=b(this).data("bb-handler");e(a,c,k[d])}),c.on("click",".bootbox-close-button",function(a){e(a,c,k.onEscape)}),c.on("keyup",function(a){27===a.which&&c.trigger("escape.close.bb")}),b(a.container).append(c),c.modal({backdrop:a.backdrop,keyboard:!1,show:!1}),a.show&&c.modal("show"),c},p.setDefaults=function(){var a={};2===arguments.length?a[arguments[0]]=arguments[1]:a=arguments[0],b.extend(o,a)},p.hideAll=function(){return b(".bootbox").modal("hide"),p};var q={br:{OK:"OK",CANCEL:"Cancelar",CONFIRM:"Sim"},cs:{OK:"OK",CANCEL:"Zrušit",CONFIRM:"Potvrdit"},da:{OK:"OK",CANCEL:"Annuller",CONFIRM:"Accepter"},de:{OK:"OK",CANCEL:"Abbrechen",CONFIRM:"Akzeptieren"},el:{OK:"Εντάξει",CANCEL:"Ακύρωση",CONFIRM:"Επιβεβαίωση"},en:{OK:"OK",CANCEL:"Cancel",CONFIRM:"OK"},es:{OK:"OK",CANCEL:"Cancelar",CONFIRM:"Aceptar"},et:{OK:"OK",CANCEL:"Katkesta",CONFIRM:"OK"},fi:{OK:"OK",CANCEL:"Peruuta",CONFIRM:"OK"},fr:{OK:"OK",CANCEL:"Annuler",CONFIRM:"D'accord"},he:{OK:"אישור",CANCEL:"ביטול",CONFIRM:"אישור"},id:{OK:"OK",CANCEL:"Batal",CONFIRM:"OK"},it:{OK:"OK",CANCEL:"Annulla",CONFIRM:"Conferma"},ja:{OK:"OK",CANCEL:"キャンセル",CONFIRM:"確認"},lt:{OK:"Gerai",CANCEL:"Atšaukti",CONFIRM:"Patvirtinti"},lv:{OK:"Labi",CANCEL:"Atcelt",CONFIRM:"Apstiprināt"},nl:{OK:"OK",CANCEL:"Annuleren",CONFIRM:"Accepteren"},no:{OK:"OK",CANCEL:"Avbryt",CONFIRM:"OK"},pl:{OK:"OK",CANCEL:"Anuluj",CONFIRM:"Potwierdź"},pt:{OK:"OK",CANCEL:"Cancelar",CONFIRM:"Confirmar"},ru:{OK:"OK",CANCEL:"Отмена",CONFIRM:"Применить"},sv:{OK:"OK",CANCEL:"Avbryt",CONFIRM:"OK"},tr:{OK:"Tamam",CANCEL:"İptal",CONFIRM:"Onayla"},zh_CN:{OK:"OK",CANCEL:"取消",CONFIRM:"确认"},zh_TW:{OK:"OK",CANCEL:"取消",CONFIRM:"確認"}};return p.init=function(c){return a(c||b)},p});

/***/ },

/***/ "./WebContent/js/libs/jquery.autosize.min.js"
/*!***************************************************!*\
  !*** ./WebContent/js/libs/jquery.autosize.min.js ***!
  \***************************************************/
() {

/*!
	Autosize v1.18.9 - 2014-05-27
	Automatically adjust textarea height based on user input.
	(c) 2014 Jack Moore - http://www.jacklmoore.com/autosize
	license: http://www.opensource.org/licenses/mit-license.php
*/
(function(e){var t,o={className:"autosizejs",id:"autosizejs",append:"\n",callback:!1,resizeDelay:10,placeholder:!0},i='<textarea tabindex="-1" style="position:absolute; top:-999px; left:0; right:auto; bottom:auto; border:0; padding: 0; -moz-box-sizing:content-box; -webkit-box-sizing:content-box; box-sizing:content-box; word-wrap:break-word; height:0 !important; min-height:0 !important; overflow:hidden; transition:none; -webkit-transition:none; -moz-transition:none;"/>',n=["fontFamily","fontSize","fontWeight","fontStyle","letterSpacing","textTransform","wordSpacing","textIndent"],s=e(i).data("autosize",!0)[0];s.style.lineHeight="99px","99px"===e(s).css("lineHeight")&&n.push("lineHeight"),s.style.lineHeight="",e.fn.autosize=function(i){return this.length?(i=e.extend({},o,i||{}),s.parentNode!==document.body&&e(document.body).append(s),this.each(function(){function o(){var t,o=window.getComputedStyle?window.getComputedStyle(u,null):!1;o?(t=u.getBoundingClientRect().width,(0===t||"number"!=typeof t)&&(t=parseInt(o.width,10)),e.each(["paddingLeft","paddingRight","borderLeftWidth","borderRightWidth"],function(e,i){t-=parseInt(o[i],10)})):t=p.width(),s.style.width=Math.max(t,0)+"px"}function a(){var a={};if(t=u,s.className=i.className,s.id=i.id,d=parseInt(p.css("maxHeight"),10),e.each(n,function(e,t){a[t]=p.css(t)}),e(s).css(a).attr("wrap",p.attr("wrap")),o(),window.chrome){var r=u.style.width;u.style.width="0px",u.offsetWidth,u.style.width=r}}function r(){var e,n;t!==u?a():o(),s.value=!u.value&&i.placeholder?(p.attr("placeholder")||"")+i.append:u.value+i.append,s.style.overflowY=u.style.overflowY,n=parseInt(u.style.height,10),s.scrollTop=0,s.scrollTop=9e4,e=s.scrollTop,d&&e>d?(u.style.overflowY="scroll",e=d):(u.style.overflowY="hidden",c>e&&(e=c)),e+=w,n!==e&&(u.style.height=e+"px",f&&i.callback.call(u,u))}function l(){clearTimeout(h),h=setTimeout(function(){var e=p.width();e!==g&&(g=e,r())},parseInt(i.resizeDelay,10))}var d,c,h,u=this,p=e(u),w=0,f=e.isFunction(i.callback),z={height:u.style.height,overflow:u.style.overflow,overflowY:u.style.overflowY,wordWrap:u.style.wordWrap,resize:u.style.resize},g=p.width(),y=p.css("resize");p.data("autosize")||(p.data("autosize",!0),("border-box"===p.css("box-sizing")||"border-box"===p.css("-moz-box-sizing")||"border-box"===p.css("-webkit-box-sizing"))&&(w=p.outerHeight()-p.height()),c=Math.max(parseInt(p.css("minHeight"),10)-w||0,p.height()),p.css({overflow:"hidden",overflowY:"hidden",wordWrap:"break-word"}),"vertical"===y?p.css("resize","none"):"both"===y&&p.css("resize","horizontal"),"onpropertychange"in u?"oninput"in u?p.on("input.autosize keyup.autosize",r):p.on("propertychange.autosize",function(){"value"===event.propertyName&&r()}):p.on("input.autosize",r),i.resizeDelay!==!1&&e(window).on("resize.autosize",l),p.on("autosize.resize",r),p.on("autosize.resizeIncludeStyle",function(){t=null,r()}),p.on("autosize.destroy",function(){t=null,clearTimeout(h),e(window).off("resize",l),p.off("autosize").off(".autosize").css(z).removeData("autosize")}),r())})):this}})(window.jQuery||window.$);

/***/ },

/***/ "jquery"
/*!*************************!*\
  !*** external "jQuery" ***!
  \*************************/
(module) {

"use strict";
module.exports = jQuery;

/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!************************************!*\
  !*** ./WebContent/js/translate.js ***!
  \************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./libs/bootbox.min */ "./WebContent/js/libs/bootbox.min.js");
/* harmony import */ var _libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _app_localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./app/localise */ "./WebContent/js/app/localise.js");
/* harmony import */ var _app_globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app/globals */ "./WebContent/js/app/globals.js");
/* harmony import */ var _app_changeset__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./app/changeset */ "./WebContent/js/app/changeset.js");
/* harmony import */ var _app_aws__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./app/aws */ "./WebContent/js/app/aws.js");
/* harmony import */ var _libs_jquery_autosize_min__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./libs/jquery.autosize.min */ "./WebContent/js/libs/jquery.autosize.min.js");
/* harmony import */ var _libs_jquery_autosize_min__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_libs_jquery_autosize_min__WEBPACK_IMPORTED_MODULE_5__);
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/










const $ = window.$;

var gUserLocale = navigator.language;
if (typeof localStorage !== "undefined") {
	try {
		gUserLocale = localStorage.getItem('user_locale') || navigator.language;
	} catch (error) {
		gUserLocale = navigator.language;
	}
}
window.gUserLocale = gUserLocale;
window.bootbox = (_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default());

var	gMode = "survey",
	gTempLanguageItems = [];

_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].initLocale(gUserLocale).then(function () {
	setCustomEdit();
	setTheme();
	setupUserProfile(true);
	_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].setlang();		// Localise HTML
	
	// Get the user details
	getLoggedInUser(surveyListDone, false, true, undefined, false, false);
	
	// Add menu functions
	$('#m_open').off().click(function() {	// Open an existing form
		openForm("existing");
	});
	
	$('.save_form').off().click(function() {	// Save a survey to Smap
		saveTranslations(getSurveyDetails(undefined, false, true));
	});
	
	$('#m_settings').off().click(function() {	// Get a survey from Smap
		gMode = "settings";
		refreshView(gMode);
	});
	$('#m_changes').off().click(function() {	// View the changes to this survey
		gMode = "changes";
		refreshView(gMode);
	});
	$('#m_undo').off().click(function() {	// Undo last change
		_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.undo();
		refreshView(gMode);
	});
	$('#m_redo').off().click(function() {	// Redo last change
		_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.redo();
		refreshView(gMode);
	});

	$('#m_auto_translate').click(function(e) {
		e.preventDefault();
		if(!$(this).parent().hasClass("disabled")) {
			var survey = _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;
			if (survey.languages.length > 1) {
				_app_aws__WEBPACK_IMPORTED_MODULE_4__["default"].setLanguageSelect($('.translate_select'), 'translate', setTranslateValues);
				$('#overwrite').prop("checked", false);
				$('#autoTranslateModal').modal("show");
			}
		} else {
			_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_sct"]);
		}
	});
	
	$('.language_list').off().change(function() {
		_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1 = $('#language1').val();
		_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2 = $('#language2').val();
		refreshView(gMode);
  	 });
	

	// Check for selection of the label indicating successful updates and the one indicating failed
	$('#successLabel').off().click(function() {
		_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default().alert("success");
	});
	// Check for selection of the label indicating successful updates and the one indicating failed
	$('#failedLabel').off().click(function() {
		_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default().alert("failed");
	});
	
    /*
     * Open a new form
     */
	$('#get_form').off().click(function() {
		_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentSurvey = $('#survey_name option:selected').val();
		saveCurrentProject(_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentProject, _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentSurvey);	// Save the current survey id
		getSurveyDetails(refreshView, false, true);
  	 });

	$('#translateGo').off().click(function() {
		if(!$(this).hasClass('disabled')) {
			autoTranslate();
		}
	});

	/*
  	 * Add check prior to the user leaving the screen
  	 */
	window.onbeforeunload = function() {
		if(_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].changes.length > 0) {
			return _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_leave"];
		} else {
			return;
		}
	};


function surveyListDone() {
	getSurveyDetails(refreshView, false, true);
}


function setTranslateValues() {
	var survey = _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey;
	if (survey.languages[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].code) {
		$('#from_lang').val(survey.languages[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].code);
	} else {
		$('#from_lang').val("en");
	}
	if (survey.languages[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2].code) {
		$('#to_lang').val(survey.languages[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2].code);
	}  else {
		$('#to_lang').val("en");
	}
}

// Save the survey
function saveTranslations(callback) {
	
	var url="/surveyKPI/surveys/save/" + _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentSurvey,
		changes = _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.translateChanges,
		changesString = JSON.stringify(changes);		
	
	addHourglass();
	$.ajax({
		url: url,
		type: 'PUT',
		dataType: 'json',
		cache: false,
		data: { changes: changesString },
		success: function(data) {
			var responseFn = callback,
				h = [],
				idx = -1,
				i;
			
			removeHourglass();			
			
			_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.clearChanges();
			
			if(typeof responseFn === "function") { 
				responseFn();
			}
			
			// Report success and failure
			_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.lastChanges = data.changeSet;
			//$('#successLabel .counter').html(data.success);
			//$('#failedLabel .counter').html(data.failed);	
			
			if(data.success > 0) {
				h[++idx] = '<div class="alert alert-success" role="alert">';
				h[++idx] = '<p>';
				h[++idx] = data.success;
				h[++idx] = " " + _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_csa"];
				h[++idx] = '</p>';
				h[++idx] = '<ol>';
				for(i = 0; i < data.changeSet.length; i++) {
					h[++idx] = _app_changeset__WEBPACK_IMPORTED_MODULE_3__["default"].addUpdateMessage(data.changeSet[i], false);
				}
				h[++idx] = '</ol>';
				h[++idx] = '</div>';
			}
			if(data.failed > 0) {
				h[++idx] = '<div class="alert alert-danger" role="alert">';
				h[++idx] = data.failed;
				h[++idx] = " " + _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_csf"];
				h[++idx] = '<ol>';
				for(i = 0; i < data.changeSet.length; i++) {
					h[++idx] = _app_changeset__WEBPACK_IMPORTED_MODULE_3__["default"].addUpdateMessage(data.changeSet[i], true);
				}
				h[++idx] = '</ol>';
				h[++idx] = '</div>';
			}

			_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default().alert(h.join(""));

		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			
			if(xhr.readyState === 0 || xhr.status === 0) {
	              return;  // Not an error
			} else {
				_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_save"] + ' ' + err);
			}
					
			if(typeof responseFn === "function") { 
				responseFn();
			}
		}

	});
}

function refreshView() {
	
	var i,
		j,
		itemList = [],
		index = -1,
		survey = _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey,
		numberLanguages,
		key,
		options = [];

	gTempLanguageItems = [];
	
	if(survey) {
		numberLanguages = survey.languages.length;
	}
	
	if(_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1 >= numberLanguages) {
		_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1 = 0;
	}
	if(_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2 >= numberLanguages) {
		_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2 = 0;
	}
	
	// Set the display name
	$('.formName').text(survey.displayName);
			
	// Add all unique questions from all forms
	for(i = 0; i < survey.forms.length; i++) {
		console.log("Form name: " + survey.forms[i].name);
		var formQuestions = survey.forms[i].questions; 
		for(j = 0; j < formQuestions.length; j++) {

			// Question Labels
			if(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].text) {
				if((index = $.inArray(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].text, itemList)) > -1) {
					gTempLanguageItems[index].indexes.push({
						form: i,
						question: j
					});
				} else {
					itemList.push(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].text);
					gTempLanguageItems.push({
						label_a: formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].text,
						label_b: formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2].text,
						indexes: [{
							form: i,
							question: j
						}]
					});
				}
			}

			// Hints
			if(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].hint) {
				if((index = $.inArray(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].hint, itemList)) > -1) {
					gTempLanguageItems[index].indexes.push({
						form: i,
						question: j,
						hint: true
					});
				} else {
					itemList.push(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].hint);
					gTempLanguageItems.push({
						label_a: formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].hint,
						label_b: formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2].hint,
						indexes: [{
							form: i,
							question: j,
							hint: true
						}]
					});
				}
			}

			// Constraint Messages
			if(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].constraint_msg) {
				if((index = $.inArray(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].constraint_msg, itemList)) > -1) {
					gTempLanguageItems[index].indexes.push({
						form: i,
						question: j,
						constraint_msg: true
					});
				} else {
					itemList.push(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].constraint_msg);
					gTempLanguageItems.push({
						label_a: formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].constraint_msg,
						label_b: formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2].constraint_msg,
						indexes: [{
							form: i,
							question: j,
							constraint_msg: true
						}]
					});
				}
			}

			// Required Messages
			if(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].required_msg) {
				if((index = $.inArray(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].required_msg, itemList)) > -1) {
					gTempLanguageItems[index].indexes.push({
						form: i,
						question: j,
						required_msg: true
					});
				} else {
					itemList.push(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].required_msg);
					gTempLanguageItems.push({
						label_a: formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].required_msg,
						label_b: formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2].required_msg,
						indexes: [{
							form: i,
							question: j,
							required_msg: true
						}]
					});
				}
			}

			// Guidance Hint
			if(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].guidance_hint) {
				if((index = $.inArray(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].guidance_hint, itemList)) > -1) {
					gTempLanguageItems[index].indexes.push({
						form: i,
						question: j,
						guidance_hint: true
					});
				} else {
					itemList.push(formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].guidance_hint);
					gTempLanguageItems.push({
						label_a: formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].guidance_hint,
						label_b: formQuestions[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2].guidance_hint,
						indexes: [{
							form: i,
							question: j,
							guidance_hint: true
						}]
					});
				}
			}
		}
	}
	// Add all unique options from all option lists
	for(key in survey.optionLists) {

		options = survey.optionLists[key].options;
		for(j = 0; j < options.length; j++) {

			if(options[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].text) {
				if((index = $.inArray(options[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].text, itemList)) > -1) {
					console.log(options[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].text);
					gTempLanguageItems[index].indexes.push({
						optionList: key,
						option: j
					});
					
				} else {
					itemList.push(options[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].text);
					gTempLanguageItems.push({
						label_a: options[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].text,
						label_b: options[j].labels[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2].text,
						indexes: [{
							optionList: key,
							option: j
						}]
					});
				}
			}
		}
	}

	// Add the HTML
	setTranslateHtml($('.questions'), gTempLanguageItems, survey);

	// Respond to text changes
	$(".lang_b").first().focus();
	$(".lang_b").change(function(e){
		e.preventDefault();
		var $this = $(this);
		var index = $this.data("index");
		var newVal = $this.val();
		console.log(gTempLanguageItems[index]);
		console.log("New val:" + newVal);
		_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.modLabel(_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2, gTempLanguageItems[index].indexes, newVal, "text", "label");
	});
}

/*
 * Convert JSON to html
 */
function setTranslateHtml($element, language_items, survey) {
	var i;

	$element.empty();
	for(i = 0; i < language_items.length; i++) {
		var label_a = language_items[i].label_a;
		var label_b = language_items[i].label_b || "";
		var tabidx = i + 1;
		var content = `
			<div class="col-6">
				<textarea class="lang_a" tabindex="-1" readonly>${label_a}</textarea>
			</div>
			<div class="col-6">
				<textarea class="lang_b" tabindex="${tabidx}" data-index="${i}">${label_b}</textarea>
			<div>`;
		$element.append(content);
	}

}

/*
 * Call AWS services to translate automatically
 */
function autoTranslate() {

	var url="/surveyKPI/surveys/translate/" + _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gCurrentSurvey
		+ "/" + _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1
		+ "/" + _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2
		+ "/" + $("#from_lang").val()
		+ "/" + $('#to_lang').val();
	var overwrite = $('#overwrite').prop("checked");

	if(overwrite) {
		url += "?overwrite=true";
	}

	$('#translateGo').addClass("disabled");

	addHourglass();
	$.ajax({
		url: url,
		type: 'PUT',
		cache: false,
		timeout: 0,
		success: function() {
			removeHourglass();
			$('#autoTranslateModal').modal("hide");
			$('#translateGo').removeClass("disabled");
			getSurveyDetails(refreshView, false, true);

			var h = [],
				idx = -1,
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_transd"];

			msg = msg.replace("%s1", _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.languages[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage1].name);
			msg = msg.replace("%s2", _app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].model.survey.languages[_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"].gLanguage2].name);

			h[++idx] = '<div class="alert alert-success" role="alert">';
			h[++idx] = '<p>';
			h[++idx] = msg;
			h[++idx] = '</p>';

			h[++idx] = '</div>';
			_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default().alert(h.join(""));

		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			$('#translateGo').removeClass("disabled");

			if(xhr.readyState === 0 || xhr.status === 0) {
				return;  // Not an error
			} else {
				if(xhr.responseText.indexOf("<html>") > 0) {
					_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default().alert(_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_trans_to"]);
				} else {
					_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default().alert(xhr.responseText);
				}

			}
		}
	});
}

});
})();

/******/ })()
;