// Copyright 2006 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//   (a) let/const keyword, (b) class expressions, (c) Map object,

//   (b) destructuring, (c) block-scoped functions,

/**
 * @license
 * Latitude/longitude spherical geodesy formulae taken from
 * http://www.movable-type.co.uk/scripts/latlong.html
 * Licensed under CC-BY-3.0.
 */

// Based on simplify-js https://github.com/mourner/simplify-js
// Copyright (c) 2012, Vladimir Agafonkin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//    1. Redistributions of source code must retain the above copyright notice,
//       this list of conditions and the following disclaimer.
//
//    2. Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// Copyright 2000 softSurfer, 2012 Dan Sunday

// providing that this copyright notice is included with it.

// Copyright (c) 2013 The Polymer Authors. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
// * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// 64-bit int handling is based on github.com/dpw/node-buffer-more-ints (MIT-licensed)

// Buffer code below from https://github.com/feross/buffer, MIT-licensed

//var copyright = response.copyright;  // FIXME do we need to display this?

/**
 * The attribution containing a link to the OpenStreetMap Copyright and License
 * page.
 * @const
 * @type {ol.Attribution}
 * @api
 */

// Copyright 2009 The Closure Library Authors.
// All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// This file has been auto-generated by GenJsDeps, please do not edit.

!function(e,o){"object"==typeof exports?module.exports=o():"function"==typeof define&&define.amd?define([],o):e.ol=o()}(this,function(){var OPENLAYERS={},goog=this.goog={};this.CLOSURE_NO_DEPS=!0;var COMPILED=!1,goog=goog||{};goog.global=this,goog.global.CLOSURE_UNCOMPILED_DEFINES,goog.global.CLOSURE_DEFINES,goog.isDef=function(e){return void 0!==e},goog.exportPath_=function(e,o,t){var r=e.split("."),i=t||goog.global;r[0]in i||!i.execScript||i.execScript("var "+r[0]);for(var n;r.length&&(n=r.shift());)!r.length&&goog.isDef(o)?i[n]=o:i=i[n]?i[n]:i[n]={}},goog.define=function(e,o){var t=o;COMPILED||(goog.global.CLOSURE_UNCOMPILED_DEFINES&&Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES,e)?t=goog.global.CLOSURE_UNCOMPILED_DEFINES[e]:goog.global.CLOSURE_DEFINES&&Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES,e)&&(t=goog.global.CLOSURE_DEFINES[e])),goog.exportPath_(e,t)},goog.define("goog.DEBUG",!0),goog.define("goog.LOCALE","en"),goog.define("goog.TRUSTED_SITE",!0),goog.define("goog.STRICT_MODE_COMPATIBLE",!1),goog.define("goog.DISALLOW_TEST_ONLY_CODE",COMPILED&&!goog.DEBUG),goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING",!1),goog.provide=function(e){if(goog.isInModuleLoader_())throw Error("goog.provide can not be used within a goog.module.");if(!COMPILED&&goog.isProvided_(e))throw Error('Namespace "'+e+'" already declared.');goog.constructNamespace_(e)},goog.constructNamespace_=function(e,o){if(!COMPILED){delete goog.implicitNamespaces_[e];for(var t=e;(t=t.substring(0,t.lastIndexOf(".")))&&!goog.getObjectByName(t);)goog.implicitNamespaces_[t]=!0}goog.exportPath_(e,o)},goog.VALID_MODULE_RE_=/^[a-zA-Z_$][a-zA-Z0-9._$]*$/,goog.module=function(e){if(!goog.isString(e)||!e||-1==e.search(goog.VALID_MODULE_RE_))throw Error("Invalid module identifier");if(!goog.isInModuleLoader_())throw Error("Module "+e+" has been loaded incorrectly.");if(goog.moduleLoaderState_.moduleName)throw Error("goog.module may only be called once per module.");if(goog.moduleLoaderState_.moduleName=e,!COMPILED){if(goog.isProvided_(e))throw Error('Namespace "'+e+'" already declared.');delete goog.implicitNamespaces_[e]}},goog.module.get=function(e){return goog.module.getInternal_(e)},goog.module.getInternal_=function(e){if(!COMPILED)return goog.isProvided_(e)?e in goog.loadedModules_?goog.loadedModules_[e]:goog.getObjectByName(e):null},goog.moduleLoaderState_=null,goog.isInModuleLoader_=function(){return null!=goog.moduleLoaderState_},goog.module.declareLegacyNamespace=function(){if(!COMPILED&&!goog.isInModuleLoader_())throw new Error("goog.module.declareLegacyNamespace must be called from within a goog.module");if(!COMPILED&&!goog.moduleLoaderState_.moduleName)throw Error("goog.module must be called prior to goog.module.declareLegacyNamespace.");goog.moduleLoaderState_.declareLegacyNamespace=!0},goog.setTestOnly=function(e){if(goog.DISALLOW_TEST_ONLY_CODE)throw e=e||"",Error("Importing test-only code into non-debug environment"+(e?": "+e:"."))},goog.forwardDeclare=function(e){},goog.forwardDeclare("Document"),goog.forwardDeclare("HTMLScriptElement"),goog.forwardDeclare("XMLHttpRequest"),COMPILED||(goog.isProvided_=function(e){return e in goog.loadedModules_||!goog.implicitNamespaces_[e]&&goog.isDefAndNotNull(goog.getObjectByName(e))},goog.implicitNamespaces_={"goog.module":!0}),goog.getObjectByName=function(e,o){for(var t,r=e.split("."),i=o||goog.global;t=r.shift();){if(!goog.isDefAndNotNull(i[t]))return null;i=i[t]}return i},goog.globalize=function(e,o){var t=o||goog.global;for(var r in e)t[r]=e[r]},goog.addDependency=function(e,o,t,r){if(goog.DEPENDENCIES_ENABLED){var i,n,l=e.replace(/\\/g,"/"),a=goog.dependencies_;r&&"boolean"!=typeof r||(r=r?{module:"goog"}:{});for(var s=0;i=o[s];s++)a.nameToPath[i]=l,a.loadFlags[l]=r;for(var p=0;n=t[p];p++)l in a.requires||(a.requires[l]={}),a.requires[l][n]=!0}},goog.define("goog.ENABLE_DEBUG_LOADER",!0),goog.logToConsole_=function(e){goog.global.console&&goog.global.console.error(e)},goog.require=function(e){if(!COMPILED){if(goog.ENABLE_DEBUG_LOADER&&goog.IS_OLD_IE_&&goog.maybeProcessDeferredDep_(e),goog.isProvided_(e))return goog.isInModuleLoader_()?goog.module.getInternal_(e):null;if(goog.ENABLE_DEBUG_LOADER){var o=goog.getPathFromDeps_(e);if(o)return goog.writeScripts_(o),null}var t="goog.require could not find: "+e;throw goog.logToConsole_(t),Error(t)}},goog.basePath="",goog.global.CLOSURE_BASE_PATH,goog.global.CLOSURE_NO_DEPS,goog.global.CLOSURE_IMPORT_SCRIPT,goog.nullFunction=function(){},goog.abstractMethod=function(){throw Error("unimplemented abstract method")},goog.addSingletonGetter=function(e){e.getInstance=function(){return e.instance_?e.instance_:(goog.DEBUG&&(goog.instantiatedSingletons_[goog.instantiatedSingletons_.length]=e),e.instance_=new e)}},goog.instantiatedSingletons_=[],goog.define("goog.LOAD_MODULE_USING_EVAL",!0),goog.define("goog.SEAL_MODULE_EXPORTS",goog.DEBUG),goog.loadedModules_={},goog.DEPENDENCIES_ENABLED=!COMPILED&&goog.ENABLE_DEBUG_LOADER,goog.define("goog.TRANSPILE","detect"),goog.define("goog.TRANSPILER","transpile.js"),goog.DEPENDENCIES_ENABLED&&(goog.dependencies_={loadFlags:{},nameToPath:{},requires:{},visited:{},written:{},deferred:{}},goog.inHtmlDocument_=function(){var e=goog.global.document;return null!=e&&"write"in e},goog.findBasePath_=function(){if(goog.isDef(goog.global.CLOSURE_BASE_PATH))return void(goog.basePath=goog.global.CLOSURE_BASE_PATH);if(goog.inHtmlDocument_())for(var e=goog.global.document,o=e.getElementsByTagName("SCRIPT"),t=o.length-1;t>=0;--t){var r=o[t],i=r.src,n=i.lastIndexOf("?"),l=-1==n?i.length:n;if("base.js"==i.substr(l-7,7))return void(goog.basePath=i.substr(0,l-7))}},goog.importScript_=function(e,o){(goog.global.CLOSURE_IMPORT_SCRIPT||goog.writeScriptTag_)(e,o)&&(goog.dependencies_.written[e]=!0)},goog.IS_OLD_IE_=!(goog.global.atob||!goog.global.document||!goog.global.document.all),goog.importProcessedScript_=function(e,o,t){var r='goog.retrieveAndExec_("'+e+'", '+o+", "+t+");";goog.importScript_("",r)},goog.queuedModules_=[],goog.wrapModule_=function(e,o){return goog.LOAD_MODULE_USING_EVAL&&goog.isDef(goog.global.JSON)?"goog.loadModule("+goog.global.JSON.stringify(o+"\n//# sourceURL="+e+"\n")+");":'goog.loadModule(function(exports) {"use strict";'+o+"\n;return exports});\n//# sourceURL="+e+"\n"},goog.loadQueuedModules_=function(){var e=goog.queuedModules_.length;if(e>0){var o=goog.queuedModules_;goog.queuedModules_=[];for(var t=0;t<e;t++){var r=o[t];goog.maybeProcessDeferredPath_(r)}}},goog.maybeProcessDeferredDep_=function(e){if(goog.isDeferredModule_(e)&&goog.allDepsAreAvailable_(e)){var o=goog.getPathFromDeps_(e);goog.maybeProcessDeferredPath_(goog.basePath+o)}},goog.isDeferredModule_=function(e){var o=goog.getPathFromDeps_(e),t=o&&goog.dependencies_.loadFlags[o]||{};if(o&&("goog"==t.module||goog.needsTranspile_(t.lang))){return goog.basePath+o in goog.dependencies_.deferred}return!1},goog.allDepsAreAvailable_=function(e){var o=goog.getPathFromDeps_(e);if(o&&o in goog.dependencies_.requires)for(var t in goog.dependencies_.requires[o])if(!goog.isProvided_(t)&&!goog.isDeferredModule_(t))return!1;return!0},goog.maybeProcessDeferredPath_=function(e){if(e in goog.dependencies_.deferred){var o=goog.dependencies_.deferred[e];delete goog.dependencies_.deferred[e],goog.globalEval(o)}},goog.loadModuleFromUrl=function(e){goog.retrieveAndExec_(e,!0,!1)},goog.writeScriptSrcNode_=function(e){goog.global.document.write('<script type="text/javascript" src="'+e+'"><\/script>')},goog.appendScriptSrcNode_=function(e){var o=goog.global.document,t=o.createElement("script");t.type="text/javascript",t.src=e,t.defer=!1,t.async=!1,o.head.appendChild(t)},goog.writeScriptTag_=function(e,o){if(goog.inHtmlDocument_()){var t=goog.global.document;if(!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING&&"complete"==t.readyState){if(/\bdeps.js$/.test(e))return!1;throw Error('Cannot write "'+e+'" after document load')}if(void 0===o)if(goog.IS_OLD_IE_){var r=" onreadystatechange='goog.onScriptLoad_(this, "+ ++goog.lastNonModuleScriptIndex_+")' ";t.write('<script type="text/javascript" src="'+e+'"'+r+"><\/script>")}else goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING?goog.appendScriptSrcNode_(e):goog.writeScriptSrcNode_(e);else t.write('<script type="text/javascript">'+o+"<\/script>");return!0}return!1},goog.needsTranspile_=function(lang){if("always"==goog.TRANSPILE)return!0;if("never"==goog.TRANSPILE)return!1;if(!goog.transpiledLanguages_){goog.transpiledLanguages_={es5:!0,es6:!0,"es6-impl":!0};try{goog.transpiledLanguages_.es5=eval("[1,].length!=1");var es6implTest="let a={};const X=class{constructor(){}x(z){return new Map([...arguments]).get(z[0])==3}};return new X().x([a,3])",es6fullTest="class X{constructor(){if(new.target!=String)throw 1;this.x=42}}let q=Reflect.construct(X,[],String);if(q.x!=42||!(q instanceof String))throw 1;for(const a of[2,3]){if(a==2)continue;function f(z={a}){let a=0;return z.a}{function f(){return 0;}}return f()==3}";eval('(()=>{"use strict";'+es6implTest+"})()")&&(goog.transpiledLanguages_["es6-impl"]=!1),eval('(()=>{"use strict";'+es6fullTest+"})()")&&(goog.transpiledLanguages_.es6=!1)}catch(e){}}return!!goog.transpiledLanguages_[lang]},goog.transpiledLanguages_=null,goog.lastNonModuleScriptIndex_=0,goog.onScriptLoad_=function(e,o){return"complete"==e.readyState&&goog.lastNonModuleScriptIndex_==o&&goog.loadQueuedModules_(),!0},goog.writeScripts_=function(e){function o(e){if(!(e in i.written||e in i.visited)){if(i.visited[e]=!0,e in i.requires)for(var n in i.requires[e])if(!goog.isProvided_(n)){if(!(n in i.nameToPath))throw Error("Undefined nameToPath for "+n);o(i.nameToPath[n])}e in r||(r[e]=!0,t.push(e))}}var t=[],r={},i=goog.dependencies_;o(e);for(var n=0;n<t.length;n++){var l=t[n];goog.dependencies_.written[l]=!0}var a=goog.moduleLoaderState_;goog.moduleLoaderState_=null;for(var n=0;n<t.length;n++){var l=t[n];if(!l)throw goog.moduleLoaderState_=a,Error("Undefined script input");var s=i.loadFlags[l]||{},p=goog.needsTranspile_(s.lang);"goog"==s.module||p?goog.importProcessedScript_(goog.basePath+l,"goog"==s.module,p):goog.importScript_(goog.basePath+l)}goog.moduleLoaderState_=a},goog.getPathFromDeps_=function(e){return e in goog.dependencies_.nameToPath?goog.dependencies_.nameToPath[e]:null},goog.findBasePath_(),goog.global.CLOSURE_NO_DEPS||goog.importScript_(goog.basePath+"deps.js")),goog.loadModule=function(e){var o=goog.moduleLoaderState_;try{goog.moduleLoaderState_={moduleName:void 0,declareLegacyNamespace:!1};var t;if(goog.isFunction(e))t=e.call(void 0,{});else{if(!goog.isString(e))throw Error("Invalid module definition");t=goog.loadModuleFromSource_.call(void 0,e)}var r=goog.moduleLoaderState_.moduleName;if(!goog.isString(r)||!r)throw Error('Invalid module name "'+r+'"');goog.moduleLoaderState_.declareLegacyNamespace?goog.constructNamespace_(r,t):goog.SEAL_MODULE_EXPORTS&&Object.seal&&Object.seal(t),goog.loadedModules_[r]=t}finally{goog.moduleLoaderState_=o}},goog.loadModuleFromSource_=function(){"use strict";var exports={};return eval(arguments[0]),exports},goog.normalizePath_=function(e){for(var o=e.split("/"),t=0;t<o.length;)"."==o[t]?o.splice(t,1):t&&".."==o[t]&&o[t-1]&&".."!=o[t-1]?o.splice(--t,2):t++;return o.join("/")},goog.loadFileSync_=function(e){if(goog.global.CLOSURE_LOAD_FILE_SYNC)return goog.global.CLOSURE_LOAD_FILE_SYNC(e);try{var o=new goog.global.XMLHttpRequest;return o.open("get",e,!1),o.send(),0==o.status||200==o.status?o.responseText:null}catch(e){return null}},goog.retrieveAndExec_=function(e,o,t){if(!COMPILED){var r=e;e=goog.normalizePath_(e);var i=goog.global.CLOSURE_IMPORT_SCRIPT||goog.writeScriptTag_,n=goog.loadFileSync_(e);if(null==n)throw new Error('Load of "'+e+'" failed');t&&(n=goog.transpile_.call(goog.global,n,e)),o?n=goog.wrapModule_(e,n):n+="\n//# sourceURL="+e;goog.IS_OLD_IE_?(goog.dependencies_.deferred[r]=n,goog.queuedModules_.push(r)):i(e,n)}},goog.transpile_=function(code,path){var jscomp=goog.global.$jscomp;jscomp||(goog.global.$jscomp=jscomp={});var transpile=jscomp.transpile;if(!transpile){var transpilerPath=goog.basePath+goog.TRANSPILER,transpilerCode=goog.loadFileSync_(transpilerPath);transpilerCode&&(eval(transpilerCode+"\n//# sourceURL="+transpilerPath),jscomp=goog.global.$jscomp,transpile=jscomp.transpile)}if(!transpile){transpile=jscomp.transpile=function(e,o){return goog.logToConsole_(o+" requires transpilation but no transpiler was found."),e}}return transpile(code,path)},goog.typeOf=function(e){var o=typeof e;if("object"==o){if(!e)return"null";if(e instanceof Array)return"array";if(e instanceof Object)return o;var t=Object.prototype.toString.call(e);if("[object Window]"==t)return"object";if("[object Array]"==t||"number"==typeof e.length&&void 0!==e.splice&&void 0!==e.propertyIsEnumerable&&!e.propertyIsEnumerable("splice"))return"array";if("[object Function]"==t||void 0!==e.call&&void 0!==e.propertyIsEnumerable&&!e.propertyIsEnumerable("call"))return"function"}else if("function"==o&&void 0===e.call)return"object";return o},goog.isNull=function(e){return null===e},goog.isDefAndNotNull=function(e){return null!=e},goog.isArray=function(e){return"array"==goog.typeOf(e)},goog.isArrayLike=function(e){var o=goog.typeOf(e);return"array"==o||"object"==o&&"number"==typeof e.length},goog.isDateLike=function(e){return goog.isObject(e)&&"function"==typeof e.getFullYear},goog.isString=function(e){return"string"==typeof e},goog.isBoolean=function(e){return"boolean"==typeof e},goog.isNumber=function(e){return"number"==typeof e},goog.isFunction=function(e){return"function"==goog.typeOf(e)},goog.isObject=function(e){var o=typeof e;return"object"==o&&null!=e||"function"==o},goog.getUid=function(e){return e[goog.UID_PROPERTY_]||(e[goog.UID_PROPERTY_]=++goog.uidCounter_)},goog.hasUid=function(e){return!!e[goog.UID_PROPERTY_]},goog.removeUid=function(e){null!==e&&"removeAttribute"in e&&e.removeAttribute(goog.UID_PROPERTY_);try{delete e[goog.UID_PROPERTY_]}catch(e){}},goog.UID_PROPERTY_="closure_uid_"+(1e9*Math.random()>>>0),goog.uidCounter_=0,goog.getHashCode=goog.getUid,goog.removeHashCode=goog.removeUid,goog.cloneObject=function(e){var o=goog.typeOf(e);if("object"==o||"array"==o){if(e.clone)return e.clone();var t="array"==o?[]:{};for(var r in e)t[r]=goog.cloneObject(e[r]);return t}return e},goog.bindNative_=function(e,o,t){return e.call.apply(e.bind,arguments)},goog.bindJs_=function(e,o,t){if(!e)throw new Error;if(arguments.length>2){var r=Array.prototype.slice.call(arguments,2);return function(){var t=Array.prototype.slice.call(arguments);return Array.prototype.unshift.apply(t,r),e.apply(o,t)}}return function(){return e.apply(o,arguments)}},goog.bind=function(e,o,t){return Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?goog.bind=goog.bindNative_:goog.bind=goog.bindJs_,goog.bind.apply(null,arguments)},goog.partial=function(e,o){var t=Array.prototype.slice.call(arguments,1);return function(){var o=t.slice();return o.push.apply(o,arguments),e.apply(this,o)}},goog.mixin=function(e,o){for(var t in o)e[t]=o[t]},goog.now=goog.TRUSTED_SITE&&Date.now||function(){return+new Date},goog.globalEval=function(e){if(goog.global.execScript)goog.global.execScript(e,"JavaScript");else{if(!goog.global.eval)throw Error("goog.globalEval not available");if(null==goog.evalWorksForGlobals_)if(goog.global.eval("var _evalTest_ = 1;"),void 0!==goog.global._evalTest_){try{delete goog.global._evalTest_}catch(e){}goog.evalWorksForGlobals_=!0}else goog.evalWorksForGlobals_=!1;if(goog.evalWorksForGlobals_)goog.global.eval(e);else{var o=goog.global.document,t=o.createElement("SCRIPT");t.type="text/javascript",t.defer=!1,t.appendChild(o.createTextNode(e)),o.body.appendChild(t),o.body.removeChild(t)}}},goog.evalWorksForGlobals_=null,goog.cssNameMapping_,goog.cssNameMappingStyle_,goog.getCssName=function(e,o){var t,r=function(e){return goog.cssNameMapping_[e]||e},i=function(e){for(var o=e.split("-"),t=[],i=0;i<o.length;i++)t.push(r(o[i]));return t.join("-")};return t=goog.cssNameMapping_?"BY_WHOLE"==goog.cssNameMappingStyle_?r:i:function(e){return e},o?e+"-"+t(o):t(e)},goog.setCssNameMapping=function(e,o){goog.cssNameMapping_=e,goog.cssNameMappingStyle_=o},goog.global.CLOSURE_CSS_NAME_MAPPING,!COMPILED&&goog.global.CLOSURE_CSS_NAME_MAPPING&&(goog.cssNameMapping_=goog.global.CLOSURE_CSS_NAME_MAPPING),goog.getMsg=function(e,o){return o&&(e=e.replace(/\{\$([^}]+)}/g,function(e,t){return null!=o&&t in o?o[t]:e})),e},goog.getMsgWithFallback=function(e,o){return e},goog.exportSymbol=function(e,o,t){goog.exportPath_(e,o,t)},goog.exportProperty=function(e,o,t){e[o]=t},goog.inherits=function(e,o){function t(){}t.prototype=o.prototype,e.superClass_=o.prototype,e.prototype=new t,e.prototype.constructor=e,e.base=function(e,t,r){for(var i=new Array(arguments.length-2),n=2;n<arguments.length;n++)i[n-2]=arguments[n];return o.prototype[t].apply(e,i)}},goog.base=function(e,o,t){var r=arguments.callee.caller;if(goog.STRICT_MODE_COMPATIBLE||goog.DEBUG&&!r)throw Error("arguments.caller not defined.  goog.base() cannot be used with strict mode code. See http://www.ecma-international.org/ecma-262/5.1/#sec-C");if(r.superClass_){for(var i=new Array(arguments.length-1),n=1;n<arguments.length;n++)i[n-1]=arguments[n];return r.superClass_.constructor.apply(e,i)}for(var l=new Array(arguments.length-2),n=2;n<arguments.length;n++)l[n-2]=arguments[n];for(var a=!1,s=e.constructor;s;s=s.superClass_&&s.superClass_.constructor)if(s.prototype[o]===r)a=!0;else if(a)return s.prototype[o].apply(e,l);if(e[o]===r)return e.constructor.prototype[o].apply(e,l);throw Error("goog.base called from a method of one name to a method of a different name")},goog.scope=function(e){if(goog.isInModuleLoader_())throw Error("goog.scope is not supported within a goog.module.");e.call(goog.global)},COMPILED||(goog.global.COMPILED=COMPILED),goog.defineClass=function(e,o){var t=o.constructor,r=o.statics;t&&t!=Object.prototype.constructor||(t=function(){throw Error("cannot instantiate an interface (no constructor defined).")});var i=goog.defineClass.createSealingConstructor_(t,e);return e&&goog.inherits(i,e),delete o.constructor,delete o.statics,goog.defineClass.applyProperties_(i.prototype,o),null!=r&&(r instanceof Function?r(i):goog.defineClass.applyProperties_(i,r)),i},goog.defineClass.ClassDescriptor,goog.define("goog.defineClass.SEAL_CLASS_INSTANCES",goog.DEBUG),goog.defineClass.createSealingConstructor_=function(e,o){if(!goog.defineClass.SEAL_CLASS_INSTANCES)return e;var t=!goog.defineClass.isUnsealable_(o),r=function(){var o=e.apply(this,arguments)||this;return o[goog.UID_PROPERTY_]=o[goog.UID_PROPERTY_],this.constructor===r&&t&&Object.seal instanceof Function&&Object.seal(o),o};return r},goog.defineClass.isUnsealable_=function(e){return e&&e.prototype&&e.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]},goog.defineClass.OBJECT_PROTOTYPE_FIELDS_=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"],goog.defineClass.applyProperties_=function(e,o){var t;for(t in o)Object.prototype.hasOwnProperty.call(o,t)&&(e[t]=o[t]);for(var r=0;r<goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;r++)t=goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[r],Object.prototype.hasOwnProperty.call(o,t)&&(e[t]=o[t])},goog.tagUnsealableClass=function(e){!COMPILED&&goog.defineClass.SEAL_CLASS_INSTANCES&&(e.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]=!0)},goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_="goog_defineClass_legacy_unsealable",goog.provide("ol"),ol.DEBUG=!0,ol.ASSUME_TOUCH=!1,ol.DEFAULT_MAX_ZOOM=42,ol.DEFAULT_MIN_ZOOM=0,ol.DEFAULT_RASTER_REPROJECTION_ERROR_THRESHOLD=.5,ol.DEFAULT_TILE_SIZE=256,ol.DEFAULT_WMS_VERSION="1.3.0",ol.DRAG_BOX_HYSTERESIS_PIXELS=8,ol.ENABLE_CANVAS=!0,ol.ENABLE_IMAGE=!0,ol.ENABLE_PROJ4JS=!0,ol.ENABLE_RASTER_REPROJECTION=!0,ol.ENABLE_TILE=!0,ol.ENABLE_VECTOR=!0,ol.ENABLE_VECTOR_TILE=!0,ol.ENABLE_WEBGL=!0,ol.INITIAL_ATLAS_SIZE=256,ol.MAX_ATLAS_SIZE=-1,ol.MOUSEWHEELZOOM_MAXDELTA=1,ol.OVERVIEWMAP_MAX_RATIO=.75,ol.OVERVIEWMAP_MIN_RATIO=.1,ol.RASTER_REPROJECTION_MAX_SOURCE_TILES=100,ol.RASTER_REPROJECTION_MAX_SUBDIVISION=10,ol.RASTER_REPROJECTION_MAX_TRIANGLE_WIDTH=.25,ol.SIMPLIFY_TOLERANCE=.5,ol.WEBGL_TEXTURE_CACHE_HIGH_WATER_MARK=1024,ol.VERSION="",ol.WEBGL_MAX_TEXTURE_SIZE,ol.WEBGL_EXTENSIONS,ol.inherits=function(e,o){e.prototype=Object.create(o.prototype),e.prototype.constructor=e},ol.nullFunction=function(){},ol.getUid=function(e){return e.ol_uid||(e.ol_uid=++ol.uidCounter_)},ol.uidCounter_=0,goog.provide("ol.AssertionError"),goog.require("ol"),ol.AssertionError=function(e){this.message="Assertion failed. See "+(ol.VERSION?"https://openlayers.org/en/"+ol.VERSION.split("-")[0]:"")+"/doc/errors/#"+e+" for details.",this.code=e,this.name="AssertionError"},ol.inherits(ol.AssertionError,Error),goog.provide("ol.asserts"),goog.require("ol.AssertionError"),ol.asserts.assert=function(e,o){if(!e)throw new ol.AssertionError(o)},goog.provide("ol.math"),goog.require("ol"),goog.require("ol.asserts"),ol.math.clamp=function(e,o,t){return Math.min(Math.max(e,o),t)},ol.math.cosh=function(){return"cosh"in Math?Math.cosh:function(e){var o=Math.exp(e);return(o+1/o)/2}}(),ol.math.roundUpToPowerOfTwo=function(e){return ol.asserts.assert(0<e,29),Math.pow(2,Math.ceil(Math.log(e)/Math.LN2))},ol.math.squaredSegmentDistance=function(e,o,t,r,i,n){var l=i-t,a=n-r;if(0!==l||0!==a){var s=((e-t)*l+(o-r)*a)/(l*l+a*a);s>1?(t=i,r=n):s>0&&(t+=l*s,r+=a*s)}return ol.math.squaredDistance(e,o,t,r)},ol.math.squaredDistance=function(e,o,t,r){var i=t-e,n=r-o;return i*i+n*n},ol.math.solveLinearSystem=function(e){var o=e.length;if(ol.DEBUG)for(var t=0;t<o;t++)console.assert(e[t].length==o+1,"every row should have correct number of columns");for(var r=0;r<o;r++){for(var i=r,n=Math.abs(e[r][r]),l=r+1;l<o;l++){var a=Math.abs(e[l][r]);a>n&&(n=a,i=l)}if(0===n)return null;var s=e[i];e[i]=e[r],e[r]=s;for(var p=r+1;p<o;p++)for(var g=-e[p][r]/e[r][r],c=r;c<o+1;c++)r==c?e[p][c]=0:e[p][c]+=g*e[r][c]}for(var u=new Array(o),y=o-1;y>=0;y--){u[y]=e[y][o]/e[y][y];for(var d=y-1;d>=0;d--)e[d][o]-=e[d][y]*u[y]}return u},ol.math.toDegrees=function(e){return 180*e/Math.PI},ol.math.toRadians=function(e){return e*Math.PI/180},ol.math.modulo=function(e,o){var t=e%o;return t*o<0?t+o:t},ol.math.lerp=function(e,o,t){return e+t*(o-e)},goog.provide("ol.CenterConstraint"),goog.require("ol.math"),ol.CenterConstraint.createExtent=function(e){return function(o){return o?[ol.math.clamp(o[0],e[0],e[2]),ol.math.clamp(o[1],e[1],e[3])]:void 0}},ol.CenterConstraint.none=function(e){return e},goog.provide("ol.Constraints"),ol.Constraints=function(e,o,t){this.center=e,this.resolution=o,this.rotation=t},goog.provide("ol.obj"),ol.obj.assign="function"==typeof Object.assign?Object.assign:function(e,o){if(void 0===e||null===e)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(e),r=1,i=arguments.length;r<i;++r){var n=arguments[r];if(void 0!==n&&null!==n)for(var l in n)n.hasOwnProperty(l)&&(t[l]=n[l])}return t},ol.obj.clear=function(e){for(var o in e)delete e[o]},ol.obj.getValues=function(e){var o=[];for(var t in e)o.push(e[t]);return o},ol.obj.isEmpty=function(e){var o;for(o in e)return!1;return!o},goog.provide("ol.events"),goog.require("ol.obj"),ol.events.bindListener_=function(e){var o=function(o){var t=e.listener,r=e.bindTo||e.target;return e.callOnce&&ol.events.unlistenByKey(e),t.call(r,o)};return e.boundListener=o,o},ol.events.findListener_=function(e,o,t,r){for(var i,n=0,l=e.length;n<l;++n)if(i=e[n],i.listener===o&&i.bindTo===t)return r&&(i.deleteIndex=n),i},ol.events.getListeners=function(e,o){var t=e.ol_lm;return t?t[o]:void 0},ol.events.getListenerMap_=function(e){var o=e.ol_lm;return o||(o=e.ol_lm={}),o},ol.events.removeListeners_=function(e,o){var t=ol.events.getListeners(e,o);if(t){for(var r=0,i=t.length;r<i;++r)e.removeEventListener(o,t[r].boundListener),ol.obj.clear(t[r]);t.length=0;var n=e.ol_lm;n&&(delete n[o],0===Object.keys(n).length&&delete e.ol_lm)}},ol.events.listen=function(e,o,t,r,i){var n=ol.events.getListenerMap_(e),l=n[o];l||(l=n[o]=[]);var a=ol.events.findListener_(l,t,r,!1);return a?i||(a.callOnce=!1):(a={bindTo:r,callOnce:!!i,listener:t,target:e,type:o},e.addEventListener(o,ol.events.bindListener_(a)),l.push(a)),a},ol.events.listenOnce=function(e,o,t,r){return ol.events.listen(e,o,t,r,!0)},ol.events.unlisten=function(e,o,t,r){var i=ol.events.getListeners(e,o);if(i){var n=ol.events.findListener_(i,t,r,!0);n&&ol.events.unlistenByKey(n)}},ol.events.unlistenByKey=function(e){if(e&&e.target){e.target.removeEventListener(e.type,e.boundListener);var o=ol.events.getListeners(e.target,e.type);if(o){var t="deleteIndex"in e?e.deleteIndex:o.indexOf(e);-1!==t&&o.splice(t,1),0===o.length&&ol.events.removeListeners_(e.target,e.type)}ol.obj.clear(e)}},ol.events.unlistenAll=function(e){var o=ol.events.getListenerMap_(e);for(var t in o)ol.events.removeListeners_(e,t)},goog.provide("ol.Disposable"),goog.require("ol"),ol.Disposable=function(){},ol.Disposable.prototype.disposed_=!1,ol.Disposable.prototype.dispose=function(){this.disposed_||(this.disposed_=!0,this.disposeInternal())},ol.Disposable.prototype.disposeInternal=ol.nullFunction,goog.provide("ol.events.Event"),ol.events.Event=function(e){this.propagationStopped,this.type=e,this.target=null},ol.events.Event.prototype.preventDefault=ol.events.Event.prototype.stopPropagation=function(){this.propagationStopped=!0},ol.events.Event.stopPropagation=function(e){e.stopPropagation()},ol.events.Event.preventDefault=function(e){e.preventDefault()},goog.provide("ol.events.EventTarget"),goog.require("ol"),goog.require("ol.Disposable"),goog.require("ol.events"),goog.require("ol.events.Event"),ol.events.EventTarget=function(){ol.Disposable.call(this),this.pendingRemovals_={},this.dispatching_={},this.listeners_={}},ol.inherits(ol.events.EventTarget,ol.Disposable),ol.events.EventTarget.prototype.addEventListener=function(e,o){var t=this.listeners_[e];t||(t=this.listeners_[e]=[]),-1===t.indexOf(o)&&t.push(o)};ol.events.EventTarget.prototype.dispatchEvent=function(e){var o="string"==typeof e?new ol.events.Event(e):e,t=o.type;o.target=this;var r,i=this.listeners_[t];if(i){t in this.dispatching_||(this.dispatching_[t]=0,this.pendingRemovals_[t]=0),++this.dispatching_[t];for(var n=0,l=i.length;n<l;++n)if(!1===i[n].call(this,o)||o.propagationStopped){r=!1;break}if(0===--this.dispatching_[t]){var a=this.pendingRemovals_[t];for(delete this.pendingRemovals_[t];a--;)this.removeEventListener(t,ol.nullFunction);delete this.dispatching_[t]}return r}},ol.events.EventTarget.prototype.disposeInternal=function(){ol.events.unlistenAll(this)},ol.events.EventTarget.prototype.getListeners=function(e){return this.listeners_[e]},ol.events.EventTarget.prototype.hasListener=function(e){return e?e in this.listeners_:Object.keys(this.listeners_).length>0},ol.events.EventTarget.prototype.removeEventListener=function(e,o){var t=this.listeners_[e];if(t){var r=t.indexOf(o);ol.DEBUG&&console.assert(-1!=r,"listener not found"),e in this.pendingRemovals_?(t[r]=ol.nullFunction,++this.pendingRemovals_[e]):(t.splice(r,1),0===t.length&&delete this.listeners_[e])}},goog.provide("ol.events.EventType"),ol.events.EventType={CHANGE:"change",CLICK:"click",DBLCLICK:"dblclick",DRAGENTER:"dragenter",DRAGOVER:"dragover",DROP:"drop",ERROR:"error",KEYDOWN:"keydown",KEYPRESS:"keypress",LOAD:"load",MOUSEDOWN:"mousedown",MOUSEMOVE:"mousemove",MOUSEOUT:"mouseout",MOUSEUP:"mouseup",MOUSEWHEEL:"mousewheel",MSPOINTERDOWN:"mspointerdown",RESIZE:"resize",TOUCHSTART:"touchstart",TOUCHMOVE:"touchmove",TOUCHEND:"touchend",WHEEL:"wheel"},goog.provide("ol.Observable"),goog.require("ol"),goog.require("ol.events"),goog.require("ol.events.EventTarget"),goog.require("ol.events.EventType"),ol.Observable=function(){ol.events.EventTarget.call(this),this.revision_=0},ol.inherits(ol.Observable,ol.events.EventTarget),ol.Observable.unByKey=function(e){if(Array.isArray(e))for(var o=0,t=e.length;o<t;++o)ol.events.unlistenByKey(e[o]);else ol.events.unlistenByKey(e)},ol.Observable.prototype.changed=function(){++this.revision_,this.dispatchEvent(ol.events.EventType.CHANGE)},ol.Observable.prototype.dispatchEvent,ol.Observable.prototype.getRevision=function(){return this.revision_},ol.Observable.prototype.on=function(e,o,t){if(Array.isArray(e)){for(var r=e.length,i=new Array(r),n=0;n<r;++n)i[n]=ol.events.listen(this,e[n],o,t);return i}return ol.events.listen(this,e,o,t)},ol.Observable.prototype.once=function(e,o,t){if(Array.isArray(e)){for(var r=e.length,i=new Array(r),n=0;n<r;++n)i[n]=ol.events.listenOnce(this,e[n],o,t);return i}return ol.events.listenOnce(this,e,o,t)},ol.Observable.prototype.un=function(e,o,t){if(Array.isArray(e))for(var r=0,i=e.length;r<i;++r)ol.events.unlisten(this,e[r],o,t);else ol.events.unlisten(this,e,o,t)},ol.Observable.prototype.unByKey=ol.Observable.unByKey,goog.provide("ol.Object"),goog.require("ol"),goog.require("ol.Observable"),goog.require("ol.events.Event"),goog.require("ol.obj"),ol.Object=function(e){ol.Observable.call(this),ol.getUid(this),this.values_={},void 0!==e&&this.setProperties(e)},ol.inherits(ol.Object,ol.Observable),ol.Object.changeEventTypeCache_={},ol.Object.getChangeEventType=function(e){return ol.Object.changeEventTypeCache_.hasOwnProperty(e)?ol.Object.changeEventTypeCache_[e]:ol.Object.changeEventTypeCache_[e]="change:"+e},ol.Object.prototype.get=function(e){var o;return this.values_.hasOwnProperty(e)&&(o=this.values_[e]),o},ol.Object.prototype.getKeys=function(){return Object.keys(this.values_)},ol.Object.prototype.getProperties=function(){return ol.obj.assign({},this.values_)},ol.Object.prototype.notify=function(e,o){var t;t=ol.Object.getChangeEventType(e),this.dispatchEvent(new ol.Object.Event(t,e,o)),t=ol.Object.EventType.PROPERTYCHANGE,this.dispatchEvent(new ol.Object.Event(t,e,o))},ol.Object.prototype.set=function(e,o,t){if(t)this.values_[e]=o;else{var r=this.values_[e];this.values_[e]=o,r!==o&&this.notify(e,r)}},ol.Object.prototype.setProperties=function(e,o){var t;for(t in e)this.set(t,e[t],o)},ol.Object.prototype.unset=function(e,o){if(e in this.values_){var t=this.values_[e];delete this.values_[e],o||this.notify(e,t)}},ol.Object.EventType={PROPERTYCHANGE:"propertychange"},ol.Object.Event=function(e,o,t){ol.events.Event.call(this,e),this.key=o,this.oldValue=t},ol.inherits(ol.Object.Event,ol.events.Event),goog.provide("ol.array"),goog.require("ol"),ol.array.binarySearch=function(e,o,t){for(var r,i,n=t||ol.array.numberSafeCompareFunction,l=0,a=e.length,s=!1;l<a;)r=l+(a-l>>1),i=+n(e[r],o),i<0?l=r+1:(a=r,s=!i);return s?l:~l},ol.array.numberSafeCompareFunction=function(e,o){return e>o?1:e<o?-1:0},ol.array.includes=function(e,o){return e.indexOf(o)>=0},ol.array.linearFindNearest=function(e,o,t){var r=e.length;if(e[0]<=o)return 0;if(o<=e[r-1])return r-1;var i;if(t>0){for(i=1;i<r;++i)if(e[i]<o)return i-1}else if(t<0){for(i=1;i<r;++i)if(e[i]<=o)return i}else for(i=1;i<r;++i){if(e[i]==o)return i;if(e[i]<o)return e[i-1]-o<o-e[i]?i-1:i}return r-1},ol.array.reverseSubArray=function(e,o,t){for(ol.DEBUG&&console.assert(o>=0,"Array begin index should be equal to or greater than 0"),ol.DEBUG&&console.assert(t<e.length,"Array end index should be less than the array length");o<t;){var r=e[o];e[o]=e[t],e[t]=r,++o,--t}},ol.array.flatten=function(e){return e.reduce(function(e,o){return Array.isArray(o)?e.concat(ol.array.flatten(o)):e.concat(o)},[])},ol.array.extend=function(e,o){var t,r=Array.isArray(o)?o:[o],i=r.length;for(t=0;t<i;t++)e[e.length]=r[t]},ol.array.remove=function(e,o){var t=e.indexOf(o),r=t>-1;return r&&e.splice(t,1),r},ol.array.find=function(e,o){for(var t,r=e.length>>>0,i=0;i<r;i++)if(t=e[i],o(t,i,e))return t;return null},ol.array.equals=function(e,o){var t=e.length;if(t!==o.length)return!1;for(var r=0;r<t;r++)if(e[r]!==o[r])return!1;return!0},ol.array.stableSort=function(e,o){var t,r=e.length,i=Array(e.length);for(t=0;t<r;t++)i[t]={index:t,value:e[t]}
;for(i.sort(function(e,t){return o(e.value,t.value)||e.index-t.index}),t=0;t<e.length;t++)e[t]=i[t].value},ol.array.findIndex=function(e,o){var t;return e.every(function(r,i){return t=i,!o(r,i,e)})?-1:t},ol.array.isSorted=function(e,o,t){var r=o||ol.array.numberSafeCompareFunction;return e.every(function(o,i){if(0===i)return!0;var n=r(e[i-1],o);return!(n>0||t&&0===n)})},goog.provide("ol.ResolutionConstraint"),goog.require("ol.array"),goog.require("ol.math"),ol.ResolutionConstraint.createSnapToResolutions=function(e){return function(o,t,r){if(void 0!==o){var i=ol.array.linearFindNearest(e,o,r);i=ol.math.clamp(i+t,0,e.length-1);var n=Math.floor(i);if(i!=n&&n<e.length-1){var l=e[n]/e[n+1];return e[n]/Math.pow(l,i-n)}return e[n]}}},ol.ResolutionConstraint.createSnapToPower=function(e,o,t){return function(r,i,n){if(void 0!==r){var l=-n/2+.5,a=Math.floor(Math.log(o/r)/Math.log(e)+l),s=Math.max(a+i,0);return void 0!==t&&(s=Math.min(s,t)),o/Math.pow(e,s)}}},goog.provide("ol.RotationConstraint"),goog.require("ol.math"),ol.RotationConstraint.disable=function(e,o){return void 0!==e?0:void 0},ol.RotationConstraint.none=function(e,o){return void 0!==e?e+o:void 0},ol.RotationConstraint.createSnapToN=function(e){var o=2*Math.PI/e;return function(e,t){return void 0!==e?e=Math.floor((e+t)/o+.5)*o:void 0}},ol.RotationConstraint.createSnapToZero=function(e){var o=e||ol.math.toRadians(5);return function(e,t){return void 0!==e?Math.abs(e+t)<=o?0:e+t:void 0}},goog.provide("ol.string"),ol.string.padNumber=function(e,o,t){var r=void 0!==t?e.toFixed(t):""+e,i=r.indexOf(".");return i=-1===i?r.length:i,i>o?r:new Array(1+o-i).join("0")+r},ol.string.compareVersions=function(e,o){for(var t=(""+e).split("."),r=(""+o).split("."),i=0;i<Math.max(t.length,r.length);i++){var n=parseInt(t[i]||"0",10),l=parseInt(r[i]||"0",10);if(n>l)return 1;if(l>n)return-1}return 0},goog.provide("ol.coordinate"),goog.require("ol.math"),goog.require("ol.string"),ol.coordinate.add=function(e,o){return e[0]+=o[0],e[1]+=o[1],e},ol.coordinate.closestOnSegment=function(e,o){var t,r,i=e[0],n=e[1],l=o[0],a=o[1],s=l[0],p=l[1],g=a[0],c=a[1],u=g-s,y=c-p,d=0===u&&0===y?0:(u*(i-s)+y*(n-p))/(u*u+y*y||0);return d<=0?(t=s,r=p):d>=1?(t=g,r=c):(t=s+d*u,r=p+d*y),[t,r]},ol.coordinate.createStringXY=function(e){return function(o){return ol.coordinate.toStringXY(o,e)}},ol.coordinate.degreesToStringHDMS_=function(e,o,t){var r=ol.math.modulo(e+180,360)-180,i=Math.abs(3600*r),n=t||0;return Math.floor(i/3600)+"° "+ol.string.padNumber(Math.floor(i/60%60),2)+"′ "+ol.string.padNumber(i%60,2,n)+"″ "+o.charAt(r<0?1:0)},ol.coordinate.format=function(e,o,t){return e?o.replace("{x}",e[0].toFixed(t)).replace("{y}",e[1].toFixed(t)):""},ol.coordinate.equals=function(e,o){for(var t=!0,r=e.length-1;r>=0;--r)if(e[r]!=o[r]){t=!1;break}return t},ol.coordinate.rotate=function(e,o){var t=Math.cos(o),r=Math.sin(o),i=e[0]*t-e[1]*r,n=e[1]*t+e[0]*r;return e[0]=i,e[1]=n,e},ol.coordinate.scale=function(e,o){return e[0]*=o,e[1]*=o,e},ol.coordinate.sub=function(e,o){return e[0]-=o[0],e[1]-=o[1],e},ol.coordinate.squaredDistance=function(e,o){var t=e[0]-o[0],r=e[1]-o[1];return t*t+r*r},ol.coordinate.squaredDistanceToSegment=function(e,o){return ol.coordinate.squaredDistance(e,ol.coordinate.closestOnSegment(e,o))},ol.coordinate.toStringHDMS=function(e,o){return e?ol.coordinate.degreesToStringHDMS_(e[1],"NS",o)+" "+ol.coordinate.degreesToStringHDMS_(e[0],"EW",o):""},ol.coordinate.toStringXY=function(e,o){return ol.coordinate.format(e,"{x}, {y}",o)},goog.provide("ol.easing"),ol.easing.easeIn=function(e){return Math.pow(e,3)},ol.easing.easeOut=function(e){return 1-ol.easing.easeIn(1-e)},ol.easing.inAndOut=function(e){return 3*e*e-2*e*e*e},ol.easing.linear=function(e){return e},ol.easing.upAndDown=function(e){return e<.5?ol.easing.inAndOut(2*e):1-ol.easing.inAndOut(2*(e-.5))},goog.provide("ol.extent.Corner"),ol.extent.Corner={BOTTOM_LEFT:"bottom-left",BOTTOM_RIGHT:"bottom-right",TOP_LEFT:"top-left",TOP_RIGHT:"top-right"},goog.provide("ol.extent.Relationship"),ol.extent.Relationship={UNKNOWN:0,INTERSECTING:1,ABOVE:2,RIGHT:4,BELOW:8,LEFT:16},goog.provide("ol.extent"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.extent.Corner"),goog.require("ol.extent.Relationship"),ol.extent.boundingExtent=function(e){for(var o=ol.extent.createEmpty(),t=0,r=e.length;t<r;++t)ol.extent.extendCoordinate(o,e[t]);return o},ol.extent.boundingExtentXYs_=function(e,o,t){ol.DEBUG&&console.assert(e.length>0,"xs length should be larger than 0"),ol.DEBUG&&console.assert(o.length>0,"ys length should be larger than 0");var r=Math.min.apply(null,e),i=Math.min.apply(null,o),n=Math.max.apply(null,e),l=Math.max.apply(null,o);return ol.extent.createOrUpdate(r,i,n,l,t)},ol.extent.buffer=function(e,o,t){return t?(t[0]=e[0]-o,t[1]=e[1]-o,t[2]=e[2]+o,t[3]=e[3]+o,t):[e[0]-o,e[1]-o,e[2]+o,e[3]+o]},ol.extent.clone=function(e,o){return o?(o[0]=e[0],o[1]=e[1],o[2]=e[2],o[3]=e[3],o):e.slice()},ol.extent.closestSquaredDistanceXY=function(e,o,t){var r,i;return r=o<e[0]?e[0]-o:e[2]<o?o-e[2]:0,i=t<e[1]?e[1]-t:e[3]<t?t-e[3]:0,r*r+i*i},ol.extent.containsCoordinate=function(e,o){return ol.extent.containsXY(e,o[0],o[1])},ol.extent.containsExtent=function(e,o){return e[0]<=o[0]&&o[2]<=e[2]&&e[1]<=o[1]&&o[3]<=e[3]},ol.extent.containsXY=function(e,o,t){return e[0]<=o&&o<=e[2]&&e[1]<=t&&t<=e[3]},ol.extent.coordinateRelationship=function(e,o){var t=e[0],r=e[1],i=e[2],n=e[3],l=o[0],a=o[1],s=ol.extent.Relationship.UNKNOWN;return l<t?s|=ol.extent.Relationship.LEFT:l>i&&(s|=ol.extent.Relationship.RIGHT),a<r?s|=ol.extent.Relationship.BELOW:a>n&&(s|=ol.extent.Relationship.ABOVE),s===ol.extent.Relationship.UNKNOWN&&(s=ol.extent.Relationship.INTERSECTING),s},ol.extent.createEmpty=function(){return[1/0,1/0,-1/0,-1/0]},ol.extent.createOrUpdate=function(e,o,t,r,i){return i?(i[0]=e,i[1]=o,i[2]=t,i[3]=r,i):[e,o,t,r]},ol.extent.createOrUpdateEmpty=function(e){return ol.extent.createOrUpdate(1/0,1/0,-1/0,-1/0,e)},ol.extent.createOrUpdateFromCoordinate=function(e,o){var t=e[0],r=e[1];return ol.extent.createOrUpdate(t,r,t,r,o)},ol.extent.createOrUpdateFromCoordinates=function(e,o){var t=ol.extent.createOrUpdateEmpty(o);return ol.extent.extendCoordinates(t,e)},ol.extent.createOrUpdateFromFlatCoordinates=function(e,o,t,r,i){var n=ol.extent.createOrUpdateEmpty(i);return ol.extent.extendFlatCoordinates(n,e,o,t,r)},ol.extent.createOrUpdateFromRings=function(e,o){var t=ol.extent.createOrUpdateEmpty(o);return ol.extent.extendRings(t,e)},ol.extent.equals=function(e,o){return e[0]==o[0]&&e[2]==o[2]&&e[1]==o[1]&&e[3]==o[3]},ol.extent.extend=function(e,o){return o[0]<e[0]&&(e[0]=o[0]),o[2]>e[2]&&(e[2]=o[2]),o[1]<e[1]&&(e[1]=o[1]),o[3]>e[3]&&(e[3]=o[3]),e},ol.extent.extendCoordinate=function(e,o){o[0]<e[0]&&(e[0]=o[0]),o[0]>e[2]&&(e[2]=o[0]),o[1]<e[1]&&(e[1]=o[1]),o[1]>e[3]&&(e[3]=o[1])},ol.extent.extendCoordinates=function(e,o){var t,r;for(t=0,r=o.length;t<r;++t)ol.extent.extendCoordinate(e,o[t]);return e},ol.extent.extendFlatCoordinates=function(e,o,t,r,i){for(;t<r;t+=i)ol.extent.extendXY(e,o[t],o[t+1]);return e},ol.extent.extendRings=function(e,o){var t,r;for(t=0,r=o.length;t<r;++t)ol.extent.extendCoordinates(e,o[t]);return e},ol.extent.extendXY=function(e,o,t){e[0]=Math.min(e[0],o),e[1]=Math.min(e[1],t),e[2]=Math.max(e[2],o),e[3]=Math.max(e[3],t)},ol.extent.forEachCorner=function(e,o,t){var r;return(r=o.call(t,ol.extent.getBottomLeft(e)))?r:(r=o.call(t,ol.extent.getBottomRight(e)))?r:(r=o.call(t,ol.extent.getTopRight(e)))?r:(r=o.call(t,ol.extent.getTopLeft(e)))||!1},ol.extent.getArea=function(e){var o=0;return ol.extent.isEmpty(e)||(o=ol.extent.getWidth(e)*ol.extent.getHeight(e)),o},ol.extent.getBottomLeft=function(e){return[e[0],e[1]]},ol.extent.getBottomRight=function(e){return[e[2],e[1]]},ol.extent.getCenter=function(e){return[(e[0]+e[2])/2,(e[1]+e[3])/2]},ol.extent.getCorner=function(e,o){var t;return o===ol.extent.Corner.BOTTOM_LEFT?t=ol.extent.getBottomLeft(e):o===ol.extent.Corner.BOTTOM_RIGHT?t=ol.extent.getBottomRight(e):o===ol.extent.Corner.TOP_LEFT?t=ol.extent.getTopLeft(e):o===ol.extent.Corner.TOP_RIGHT?t=ol.extent.getTopRight(e):ol.asserts.assert(!1,13),t},ol.extent.getEnlargedArea=function(e,o){var t=Math.min(e[0],o[0]),r=Math.min(e[1],o[1]);return(Math.max(e[2],o[2])-t)*(Math.max(e[3],o[3])-r)},ol.extent.getForViewAndSize=function(e,o,t,r,i){var n=o*r[0]/2,l=o*r[1]/2,a=Math.cos(t),s=Math.sin(t),p=n*a,g=n*s,c=l*a,u=l*s,y=e[0],d=e[1],h=y-p+u,m=y-p-u,f=y+p-u,_=y+p+u,E=d-g-c,v=d-g+c,S=d+g+c,x=d+g-c;return ol.extent.createOrUpdate(Math.min(h,m,f,_),Math.min(E,v,S,x),Math.max(h,m,f,_),Math.max(E,v,S,x),i)},ol.extent.getHeight=function(e){return e[3]-e[1]},ol.extent.getIntersectionArea=function(e,o){var t=ol.extent.getIntersection(e,o);return ol.extent.getArea(t)},ol.extent.getIntersection=function(e,o,t){var r=t||ol.extent.createEmpty();return ol.extent.intersects(e,o)&&(e[0]>o[0]?r[0]=e[0]:r[0]=o[0],e[1]>o[1]?r[1]=e[1]:r[1]=o[1],e[2]<o[2]?r[2]=e[2]:r[2]=o[2],e[3]<o[3]?r[3]=e[3]:r[3]=o[3]),r},ol.extent.getMargin=function(e){return ol.extent.getWidth(e)+ol.extent.getHeight(e)},ol.extent.getSize=function(e){return[e[2]-e[0],e[3]-e[1]]},ol.extent.getTopLeft=function(e){return[e[0],e[3]]},ol.extent.getTopRight=function(e){return[e[2],e[3]]},ol.extent.getWidth=function(e){return e[2]-e[0]},ol.extent.intersects=function(e,o){return e[0]<=o[2]&&e[2]>=o[0]&&e[1]<=o[3]&&e[3]>=o[1]},ol.extent.isEmpty=function(e){return e[2]<e[0]||e[3]<e[1]},ol.extent.returnOrUpdate=function(e,o){return o?(o[0]=e[0],o[1]=e[1],o[2]=e[2],o[3]=e[3],o):e},ol.extent.scaleFromCenter=function(e,o){var t=(e[2]-e[0])/2*(o-1),r=(e[3]-e[1])/2*(o-1);e[0]-=t,e[2]+=t,e[1]-=r,e[3]+=r},ol.extent.intersectsSegment=function(e,o,t){var r=!1,i=ol.extent.coordinateRelationship(e,o),n=ol.extent.coordinateRelationship(e,t);if(i===ol.extent.Relationship.INTERSECTING||n===ol.extent.Relationship.INTERSECTING)r=!0;else{var l,a,s=e[0],p=e[1],g=e[2],c=e[3],u=o[0],y=o[1],d=t[0],h=t[1],m=(h-y)/(d-u);n&ol.extent.Relationship.ABOVE&&!(i&ol.extent.Relationship.ABOVE)&&(l=d-(h-c)/m,r=l>=s&&l<=g),r||!(n&ol.extent.Relationship.RIGHT)||i&ol.extent.Relationship.RIGHT||(a=h-(d-g)*m,r=a>=p&&a<=c),r||!(n&ol.extent.Relationship.BELOW)||i&ol.extent.Relationship.BELOW||(l=d-(h-p)/m,r=l>=s&&l<=g),r||!(n&ol.extent.Relationship.LEFT)||i&ol.extent.Relationship.LEFT||(a=h-(d-s)*m,r=a>=p&&a<=c)}return r},ol.extent.applyTransform=function(e,o,t){var r=[e[0],e[1],e[0],e[3],e[2],e[1],e[2],e[3]];o(r,r,2);var i=[r[0],r[2],r[4],r[6]],n=[r[1],r[3],r[5],r[7]];return ol.extent.boundingExtentXYs_(i,n,t)},goog.provide("ol.geom.GeometryLayout"),ol.geom.GeometryLayout={XY:"XY",XYZ:"XYZ",XYM:"XYM",XYZM:"XYZM"},goog.provide("ol.geom.GeometryType"),ol.geom.GeometryType={POINT:"Point",LINE_STRING:"LineString",LINEAR_RING:"LinearRing",POLYGON:"Polygon",MULTI_POINT:"MultiPoint",MULTI_LINE_STRING:"MultiLineString",MULTI_POLYGON:"MultiPolygon",GEOMETRY_COLLECTION:"GeometryCollection",CIRCLE:"Circle"},goog.provide("ol.functions"),ol.functions.TRUE=function(){return!0},ol.functions.FALSE=function(){return!1},goog.provide("ol.Sphere"),goog.require("ol.math"),ol.Sphere=function(e){this.radius=e},ol.Sphere.prototype.geodesicArea=function(e){for(var o=0,t=e.length,r=e[t-1][0],i=e[t-1][1],n=0;n<t;n++){var l=e[n][0],a=e[n][1];o+=ol.math.toRadians(l-r)*(2+Math.sin(ol.math.toRadians(i))+Math.sin(ol.math.toRadians(a))),r=l,i=a}return o*this.radius*this.radius/2},ol.Sphere.prototype.haversineDistance=function(e,o){var t=ol.math.toRadians(e[1]),r=ol.math.toRadians(o[1]),i=(r-t)/2,n=ol.math.toRadians(o[0]-e[0])/2,l=Math.sin(i)*Math.sin(i)+Math.sin(n)*Math.sin(n)*Math.cos(t)*Math.cos(r);return 2*this.radius*Math.atan2(Math.sqrt(l),Math.sqrt(1-l))},ol.Sphere.prototype.offset=function(e,o,t){var r=ol.math.toRadians(e[1]),i=ol.math.toRadians(e[0]),n=o/this.radius,l=Math.asin(Math.sin(r)*Math.cos(n)+Math.cos(r)*Math.sin(n)*Math.cos(t)),a=i+Math.atan2(Math.sin(t)*Math.sin(n)*Math.cos(r),Math.cos(n)-Math.sin(r)*Math.sin(l));return[ol.math.toDegrees(a),ol.math.toDegrees(l)]},goog.provide("ol.sphere.NORMAL"),goog.require("ol.Sphere"),ol.sphere.NORMAL=new ol.Sphere(6370997),goog.provide("ol.proj.Units"),goog.require("ol.sphere.NORMAL"),ol.proj.Units={DEGREES:"degrees",FEET:"ft",METERS:"m",PIXELS:"pixels",TILE_PIXELS:"tile-pixels",USFEET:"us-ft"},ol.proj.Units.METERS_PER_UNIT={},ol.proj.Units.METERS_PER_UNIT[ol.proj.Units.DEGREES]=2*Math.PI*ol.sphere.NORMAL.radius/360,ol.proj.Units.METERS_PER_UNIT[ol.proj.Units.FEET]=.3048,ol.proj.Units.METERS_PER_UNIT[ol.proj.Units.METERS]=1,ol.proj.Units.METERS_PER_UNIT[ol.proj.Units.USFEET]=1200/3937,goog.provide("ol.proj.proj4"),ol.proj.proj4.cache_=null,ol.proj.proj4.set=function(e){ol.proj.proj4.cache_=e},ol.proj.proj4.get=function(){return ol.proj.proj4.cache_||window.proj4},goog.provide("ol.proj.Projection"),goog.require("ol"),goog.require("ol.proj.Units"),goog.require("ol.proj.proj4"),ol.proj.Projection=function(e){this.code_=e.code,this.units_=e.units,this.extent_=void 0!==e.extent?e.extent:null,this.worldExtent_=void 0!==e.worldExtent?e.worldExtent:null,this.axisOrientation_=void 0!==e.axisOrientation?e.axisOrientation:"enu",this.global_=void 0!==e.global&&e.global,this.canWrapX_=!(!this.global_||!this.extent_),this.getPointResolutionFunc_=e.getPointResolution,this.defaultTileGrid_=null,this.metersPerUnit_=e.metersPerUnit;var o=e.code;if(ol.DEBUG&&console.assert(void 0!==o,'Option "code" is required for constructing instance'),ol.ENABLE_PROJ4JS){var t=ol.proj.proj4.get();if("function"==typeof t){var r=t.defs(o);void 0!==r&&(void 0!==r.axis&&void 0===e.axisOrientation&&(this.axisOrientation_=r.axis),void 0===e.metersPerUnit&&(this.metersPerUnit_=r.to_meter),void 0===e.units&&(this.units_=r.units))}}},ol.proj.Projection.prototype.canWrapX=function(){return this.canWrapX_},ol.proj.Projection.prototype.getCode=function(){return this.code_},ol.proj.Projection.prototype.getExtent=function(){return this.extent_},ol.proj.Projection.prototype.getUnits=function(){return this.units_},ol.proj.Projection.prototype.getMetersPerUnit=function(){return this.metersPerUnit_||ol.proj.Units.METERS_PER_UNIT[this.units_]},ol.proj.Projection.prototype.getWorldExtent=function(){return this.worldExtent_},ol.proj.Projection.prototype.getAxisOrientation=function(){return this.axisOrientation_},ol.proj.Projection.prototype.isGlobal=function(){return this.global_},ol.proj.Projection.prototype.setGlobal=function(e){this.global_=e,this.canWrapX_=!(!e||!this.extent_)},ol.proj.Projection.prototype.getDefaultTileGrid=function(){return this.defaultTileGrid_},ol.proj.Projection.prototype.setDefaultTileGrid=function(e){this.defaultTileGrid_=e},ol.proj.Projection.prototype.setExtent=function(e){this.extent_=e,this.canWrapX_=!(!this.global_||!e)},ol.proj.Projection.prototype.setWorldExtent=function(e){this.worldExtent_=e},ol.proj.Projection.prototype.setGetPointResolution=function(e){this.getPointResolutionFunc_=e},ol.proj.Projection.prototype.getPointResolutionFunc=function(){return this.getPointResolutionFunc_},goog.provide("ol.proj.projections"),ol.proj.projections.cache_={},ol.proj.projections.clear=function(){ol.proj.projections.cache_={}},ol.proj.projections.get=function(e){return ol.proj.projections.cache_[e]||null},ol.proj.projections.add=function(e,o){ol.proj.projections.cache_[e]=o},goog.provide("ol.proj.transforms");goog.require("ol"),goog.require("ol.obj"),ol.proj.transforms.cache_={},ol.proj.transforms.clear=function(){ol.proj.transforms.cache_={}},ol.proj.transforms.add=function(e,o,t){var r=e.getCode(),i=o.getCode(),n=ol.proj.transforms.cache_;r in n||(n[r]={}),n[r][i]=t},ol.proj.transforms.remove=function(e,o){var t=e.getCode(),r=o.getCode(),i=ol.proj.transforms.cache_;ol.DEBUG&&console.assert(t in i,"sourceCode should be in transforms"),ol.DEBUG&&console.assert(r in i[t],"destinationCode should be in transforms of sourceCode");var n=i[t][r];return delete i[t][r],ol.obj.isEmpty(i[t])&&delete i[t],n},ol.proj.transforms.get=function(e,o){var t,r=ol.proj.transforms.cache_;return e in r&&o in r[e]&&(t=r[e][o]),t},goog.provide("ol.proj"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.proj.Projection"),goog.require("ol.proj.Units"),goog.require("ol.proj.proj4"),goog.require("ol.proj.projections"),goog.require("ol.proj.transforms"),goog.require("ol.sphere.NORMAL"),ol.proj.METERS_PER_UNIT=ol.proj.Units.METERS_PER_UNIT,ol.ENABLE_PROJ4JS&&(ol.proj.setProj4=function(e){ol.DEBUG&&console.assert("function"==typeof e,"proj4 argument should be a function"),ol.proj.proj4.set(e)}),ol.proj.getPointResolution=function(e,o,t){var r,i=e.getPointResolutionFunc();if(i)r=i(o,t);else{if(e.getUnits()==ol.proj.Units.DEGREES)r=o;else{var n=ol.proj.getTransformFromProjections(e,ol.proj.get("EPSG:4326")),l=[t[0]-o/2,t[1],t[0]+o/2,t[1],t[0],t[1]-o/2,t[0],t[1]+o/2];l=n(l,l,2);r=(ol.sphere.NORMAL.haversineDistance(l.slice(0,2),l.slice(2,4))+ol.sphere.NORMAL.haversineDistance(l.slice(4,6),l.slice(6,8)))/2;var a=e.getMetersPerUnit();void 0!==a&&(r/=a)}}return r},ol.proj.addEquivalentProjections=function(e){ol.proj.addProjections(e),e.forEach(function(o){e.forEach(function(e){o!==e&&ol.proj.transforms.add(o,e,ol.proj.cloneTransform)})})},ol.proj.addEquivalentTransforms=function(e,o,t,r){e.forEach(function(e){o.forEach(function(o){ol.proj.transforms.add(e,o,t),ol.proj.transforms.add(o,e,r)})})},ol.proj.addProjection=function(e){ol.proj.projections.add(e.getCode(),e),ol.proj.transforms.add(e,e,ol.proj.cloneTransform)},ol.proj.addProjections=function(e){var o=[];e.forEach(function(e){o.push(ol.proj.addProjection(e))})},ol.proj.clearAllProjections=function(){ol.proj.projections.clear(),ol.proj.transforms.clear()},ol.proj.createProjection=function(e,o){return e?"string"==typeof e?ol.proj.get(e):e:ol.proj.get(o)},ol.proj.addCoordinateTransforms=function(e,o,t,r){var i=ol.proj.get(e),n=ol.proj.get(o);ol.proj.transforms.add(i,n,ol.proj.createTransformFromCoordinateTransform(t)),ol.proj.transforms.add(n,i,ol.proj.createTransformFromCoordinateTransform(r))},ol.proj.createTransformFromCoordinateTransform=function(e){return function(o,t,r){var i,n,l,a=o.length,s=void 0!==r?r:2,p=void 0!==t?t:new Array(a);for(n=0;n<a;n+=s)for(i=e([o[n],o[n+1]]),p[n]=i[0],p[n+1]=i[1],l=s-1;l>=2;--l)p[n+l]=o[n+l];return p}},ol.proj.fromLonLat=function(e,o){return ol.proj.transform(e,"EPSG:4326",void 0!==o?o:"EPSG:3857")},ol.proj.toLonLat=function(e,o){return ol.proj.transform(e,void 0!==o?o:"EPSG:3857","EPSG:4326")},ol.proj.get=function(e){var o=null;if(e instanceof ol.proj.Projection)o=e;else if("string"==typeof e){var t=e;if(o=ol.proj.projections.get(t),ol.ENABLE_PROJ4JS){var r=ol.proj.proj4.get();o||"function"!=typeof r||void 0===r.defs(t)||(o=new ol.proj.Projection({code:t}),ol.proj.addProjection(o))}}return o},ol.proj.equivalent=function(e,o){if(e===o)return!0;var t=e.getUnits()===o.getUnits();return e.getCode()===o.getCode()?t:ol.proj.getTransformFromProjections(e,o)===ol.proj.cloneTransform&&t},ol.proj.getTransform=function(e,o){var t=ol.proj.get(e),r=ol.proj.get(o);return ol.proj.getTransformFromProjections(t,r)},ol.proj.getTransformFromProjections=function(e,o){var t=e.getCode(),r=o.getCode(),i=ol.proj.transforms.get(t,r);if(ol.ENABLE_PROJ4JS&&!i){var n=ol.proj.proj4.get();if("function"==typeof n){var l=n.defs(t),a=n.defs(r);if(void 0!==l&&void 0!==a){if(l===a)ol.proj.addEquivalentProjections([o,e]);else{var s=n(r,t);ol.proj.addCoordinateTransforms(o,e,s.forward,s.inverse)}i=ol.proj.transforms.get(t,r)}}}return i||(ol.DEBUG&&console.assert(i,"transform should be defined"),i=ol.proj.identityTransform),i},ol.proj.identityTransform=function(e,o,t){if(void 0!==o&&e!==o){ol.DEBUG&&console.assert(!1,"This should not be used internally.");for(var r=0,i=e.length;r<i;++r)o[r]=e[r];e=o}return e},ol.proj.cloneTransform=function(e,o,t){var r;if(void 0!==o){for(var i=0,n=e.length;i<n;++i)o[i]=e[i];r=o}else r=e.slice();return r},ol.proj.transform=function(e,o,t){return ol.proj.getTransform(o,t)(e,void 0,e.length)},ol.proj.transformExtent=function(e,o,t){var r=ol.proj.getTransform(o,t);return ol.extent.applyTransform(e,r)},ol.proj.transformWithProjections=function(e,o,t){return ol.proj.getTransformFromProjections(o,t)(e)},goog.provide("ol.geom.Geometry"),goog.require("ol"),goog.require("ol.Object"),goog.require("ol.extent"),goog.require("ol.functions"),goog.require("ol.proj"),goog.require("ol.proj.Units"),ol.geom.Geometry=function(){ol.Object.call(this),this.extent_=ol.extent.createEmpty(),this.extentRevision_=-1,this.simplifiedGeometryCache={},this.simplifiedGeometryMaxMinSquaredTolerance=0,this.simplifiedGeometryRevision=0},ol.inherits(ol.geom.Geometry,ol.Object),ol.geom.Geometry.prototype.clone=function(){},ol.geom.Geometry.prototype.closestPointXY=function(e,o,t,r){},ol.geom.Geometry.prototype.getClosestPoint=function(e,o){var t=o||[NaN,NaN];return this.closestPointXY(e[0],e[1],t,1/0),t},ol.geom.Geometry.prototype.intersectsCoordinate=function(e){return this.containsXY(e[0],e[1])},ol.geom.Geometry.prototype.computeExtent=function(e){},ol.geom.Geometry.prototype.containsXY=ol.functions.FALSE,ol.geom.Geometry.prototype.getExtent=function(e){return this.extentRevision_!=this.getRevision()&&(this.extent_=this.computeExtent(this.extent_),this.extentRevision_=this.getRevision()),ol.extent.returnOrUpdate(this.extent_,e)},ol.geom.Geometry.prototype.rotate=function(e,o){},ol.geom.Geometry.prototype.scale=function(e,o,t){},ol.geom.Geometry.prototype.simplify=function(e){return this.getSimplifiedGeometry(e*e)},ol.geom.Geometry.prototype.getSimplifiedGeometry=function(e){},ol.geom.Geometry.prototype.getType=function(){},ol.geom.Geometry.prototype.applyTransform=function(e){},ol.geom.Geometry.prototype.intersectsExtent=function(e){},ol.geom.Geometry.prototype.translate=function(e,o){},ol.geom.Geometry.prototype.transform=function(e,o){return ol.DEBUG&&console.assert(ol.proj.get(e).getUnits()!==ol.proj.Units.TILE_PIXELS&&ol.proj.get(o).getUnits()!==ol.proj.Units.TILE_PIXELS,"cannot transform geometries with TILE_PIXELS units"),this.applyTransform(ol.proj.getTransform(e,o)),this},goog.provide("ol.geom.flat.transform"),ol.geom.flat.transform.transform2D=function(e,o,t,r,i,n){var l,a=n||[],s=0;for(l=o;l<t;l+=r){var p=e[l],g=e[l+1];a[s++]=i[0]*p+i[2]*g+i[4],a[s++]=i[1]*p+i[3]*g+i[5]}return n&&a.length!=s&&(a.length=s),a},ol.geom.flat.transform.rotate=function(e,o,t,r,i,n,l){for(var a=l||[],s=Math.cos(i),p=Math.sin(i),g=n[0],c=n[1],u=0,y=o;y<t;y+=r){var d=e[y]-g,h=e[y+1]-c;a[u++]=g+d*s-h*p,a[u++]=c+d*p+h*s;for(var m=y+2;m<y+r;++m)a[u++]=e[m]}return l&&a.length!=u&&(a.length=u),a},ol.geom.flat.transform.scale=function(e,o,t,r,i,n,l,a){for(var s=a||[],p=l[0],g=l[1],c=0,u=o;u<t;u+=r){var y=e[u]-p,d=e[u+1]-g;s[c++]=p+i*y,s[c++]=g+n*d;for(var h=u+2;h<u+r;++h)s[c++]=e[h]}return a&&s.length!=c&&(s.length=c),s},ol.geom.flat.transform.translate=function(e,o,t,r,i,n,l){var a,s,p=l||[],g=0;for(a=o;a<t;a+=r)for(p[g++]=e[a]+i,p[g++]=e[a+1]+n,s=a+2;s<a+r;++s)p[g++]=e[s];return l&&p.length!=g&&(p.length=g),p},goog.provide("ol.geom.SimpleGeometry"),goog.require("ol"),goog.require("ol.functions"),goog.require("ol.extent"),goog.require("ol.geom.Geometry"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.flat.transform"),goog.require("ol.obj"),ol.geom.SimpleGeometry=function(){ol.geom.Geometry.call(this),this.layout=ol.geom.GeometryLayout.XY,this.stride=2,this.flatCoordinates=null},ol.inherits(ol.geom.SimpleGeometry,ol.geom.Geometry),ol.geom.SimpleGeometry.getLayoutForStride_=function(e){var o;return 2==e?o=ol.geom.GeometryLayout.XY:3==e?o=ol.geom.GeometryLayout.XYZ:4==e&&(o=ol.geom.GeometryLayout.XYZM),ol.DEBUG&&console.assert(o,"unsupported stride: "+e),o},ol.geom.SimpleGeometry.getStrideForLayout=function(e){var o;return e==ol.geom.GeometryLayout.XY?o=2:e==ol.geom.GeometryLayout.XYZ||e==ol.geom.GeometryLayout.XYM?o=3:e==ol.geom.GeometryLayout.XYZM&&(o=4),ol.DEBUG&&console.assert(o,"unsupported layout: "+e),o},ol.geom.SimpleGeometry.prototype.containsXY=ol.functions.FALSE,ol.geom.SimpleGeometry.prototype.computeExtent=function(e){return ol.extent.createOrUpdateFromFlatCoordinates(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,e)},ol.geom.SimpleGeometry.prototype.getCoordinates=function(){},ol.geom.SimpleGeometry.prototype.getFirstCoordinate=function(){return this.flatCoordinates.slice(0,this.stride)},ol.geom.SimpleGeometry.prototype.getFlatCoordinates=function(){return this.flatCoordinates},ol.geom.SimpleGeometry.prototype.getLastCoordinate=function(){return this.flatCoordinates.slice(this.flatCoordinates.length-this.stride)},ol.geom.SimpleGeometry.prototype.getLayout=function(){return this.layout},ol.geom.SimpleGeometry.prototype.getSimplifiedGeometry=function(e){if(this.simplifiedGeometryRevision!=this.getRevision()&&(ol.obj.clear(this.simplifiedGeometryCache),this.simplifiedGeometryMaxMinSquaredTolerance=0,this.simplifiedGeometryRevision=this.getRevision()),e<0||0!==this.simplifiedGeometryMaxMinSquaredTolerance&&e<=this.simplifiedGeometryMaxMinSquaredTolerance)return this;var o=e.toString();if(this.simplifiedGeometryCache.hasOwnProperty(o))return this.simplifiedGeometryCache[o];var t=this.getSimplifiedGeometryInternal(e);return t.getFlatCoordinates().length<this.flatCoordinates.length?(this.simplifiedGeometryCache[o]=t,t):(this.simplifiedGeometryMaxMinSquaredTolerance=e,this)},ol.geom.SimpleGeometry.prototype.getSimplifiedGeometryInternal=function(e){return this},ol.geom.SimpleGeometry.prototype.getStride=function(){return this.stride},ol.geom.SimpleGeometry.prototype.setFlatCoordinatesInternal=function(e,o){this.stride=ol.geom.SimpleGeometry.getStrideForLayout(e),this.layout=e,this.flatCoordinates=o},ol.geom.SimpleGeometry.prototype.setCoordinates=function(e,o){},ol.geom.SimpleGeometry.prototype.setLayout=function(e,o,t){var r;if(e)r=ol.geom.SimpleGeometry.getStrideForLayout(e);else{var i;for(i=0;i<t;++i){if(0===o.length)return this.layout=ol.geom.GeometryLayout.XY,void(this.stride=2);o=o[0]}r=o.length,e=ol.geom.SimpleGeometry.getLayoutForStride_(r)}this.layout=e,this.stride=r},ol.geom.SimpleGeometry.prototype.applyTransform=function(e){this.flatCoordinates&&(e(this.flatCoordinates,this.flatCoordinates,this.stride),this.changed())},ol.geom.SimpleGeometry.prototype.rotate=function(e,o){var t=this.getFlatCoordinates();if(t){var r=this.getStride();ol.geom.flat.transform.rotate(t,0,t.length,r,e,o,t),this.changed()}},ol.geom.SimpleGeometry.prototype.scale=function(e,o,t){var r=o;void 0===r&&(r=e);var i=t;i||(i=ol.extent.getCenter(this.getExtent()));var n=this.getFlatCoordinates();if(n){var l=this.getStride();ol.geom.flat.transform.scale(n,0,n.length,l,e,r,i,n),this.changed()}},ol.geom.SimpleGeometry.prototype.translate=function(e,o){var t=this.getFlatCoordinates();if(t){var r=this.getStride();ol.geom.flat.transform.translate(t,0,t.length,r,e,o,t),this.changed()}},ol.geom.SimpleGeometry.transform2D=function(e,o,t){var r=e.getFlatCoordinates();if(r){var i=e.getStride();return ol.geom.flat.transform.transform2D(r,0,r.length,i,o,t)}return null},goog.provide("ol.geom.flat.area"),ol.geom.flat.area.linearRing=function(e,o,t,r){for(var i=0,n=e[t-r],l=e[t-r+1];o<t;o+=r){var a=e[o],s=e[o+1];i+=l*a-n*s,n=a,l=s}return i/2},ol.geom.flat.area.linearRings=function(e,o,t,r){var i,n,l=0;for(i=0,n=t.length;i<n;++i){var a=t[i];l+=ol.geom.flat.area.linearRing(e,o,a,r),o=a}return l},ol.geom.flat.area.linearRingss=function(e,o,t,r){var i,n,l=0;for(i=0,n=t.length;i<n;++i){var a=t[i];l+=ol.geom.flat.area.linearRings(e,o,a,r),o=a[a.length-1]}return l},goog.provide("ol.geom.flat.closest"),goog.require("ol"),goog.require("ol.math"),ol.geom.flat.closest.point=function(e,o,t,r,i,n,l){var a,s,p=e[o],g=e[o+1],c=e[t]-p,u=e[t+1]-g;if(0===c&&0===u)s=o;else{var y=((i-p)*c+(n-g)*u)/(c*c+u*u);if(y>1)s=t;else{if(y>0){for(a=0;a<r;++a)l[a]=ol.math.lerp(e[o+a],e[t+a],y);return void(l.length=r)}s=o}}for(a=0;a<r;++a)l[a]=e[s+a];l.length=r},ol.geom.flat.closest.getMaxSquaredDelta=function(e,o,t,r,i){var n=e[o],l=e[o+1];for(o+=r;o<t;o+=r){var a=e[o],s=e[o+1],p=ol.math.squaredDistance(n,l,a,s);p>i&&(i=p),n=a,l=s}return i},ol.geom.flat.closest.getsMaxSquaredDelta=function(e,o,t,r,i){var n,l;for(n=0,l=t.length;n<l;++n){var a=t[n];i=ol.geom.flat.closest.getMaxSquaredDelta(e,o,a,r,i),o=a}return i},ol.geom.flat.closest.getssMaxSquaredDelta=function(e,o,t,r,i){var n,l;for(n=0,l=t.length;n<l;++n){var a=t[n];i=ol.geom.flat.closest.getsMaxSquaredDelta(e,o,a,r,i),o=a[a.length-1]}return i},ol.geom.flat.closest.getClosestPoint=function(e,o,t,r,i,n,l,a,s,p,g){if(o==t)return p;var c,u;if(0===i){if((u=ol.math.squaredDistance(l,a,e[o],e[o+1]))<p){for(c=0;c<r;++c)s[c]=e[o+c];return s.length=r,u}return p}ol.DEBUG&&console.assert(i>0,"maxDelta should be larger than 0");for(var y=g||[NaN,NaN],d=o+r;d<t;)if(ol.geom.flat.closest.point(e,d-r,d,r,l,a,y),(u=ol.math.squaredDistance(l,a,y[0],y[1]))<p){for(p=u,c=0;c<r;++c)s[c]=y[c];s.length=r,d+=r}else d+=r*Math.max((Math.sqrt(u)-Math.sqrt(p))/i|0,1);if(n&&(ol.geom.flat.closest.point(e,t-r,o,r,l,a,y),(u=ol.math.squaredDistance(l,a,y[0],y[1]))<p)){for(p=u,c=0;c<r;++c)s[c]=y[c];s.length=r}return p},ol.geom.flat.closest.getsClosestPoint=function(e,o,t,r,i,n,l,a,s,p,g){var c,u,y=g||[NaN,NaN];for(c=0,u=t.length;c<u;++c){var d=t[c];p=ol.geom.flat.closest.getClosestPoint(e,o,d,r,i,n,l,a,s,p,y),o=d}return p},ol.geom.flat.closest.getssClosestPoint=function(e,o,t,r,i,n,l,a,s,p,g){var c,u,y=g||[NaN,NaN];for(c=0,u=t.length;c<u;++c){var d=t[c];p=ol.geom.flat.closest.getsClosestPoint(e,o,d,r,i,n,l,a,s,p,y),o=d[d.length-1]}return p},goog.provide("ol.geom.flat.deflate"),goog.require("ol"),ol.geom.flat.deflate.coordinate=function(e,o,t,r){ol.DEBUG&&console.assert(t.length==r,"length of the coordinate array should match stride");var i,n;for(i=0,n=t.length;i<n;++i)e[o++]=t[i];return o},ol.geom.flat.deflate.coordinates=function(e,o,t,r){var i,n;for(i=0,n=t.length;i<n;++i){var l=t[i];ol.DEBUG&&console.assert(l.length==r,"length of coordinate array should match stride");var a;for(a=0;a<r;++a)e[o++]=l[a]}return o},ol.geom.flat.deflate.coordinatess=function(e,o,t,r,i){var n,l,a=i||[],s=0;for(n=0,l=t.length;n<l;++n){var p=ol.geom.flat.deflate.coordinates(e,o,t[n],r);a[s++]=p,o=p}return a.length=s,a},ol.geom.flat.deflate.coordinatesss=function(e,o,t,r,i){var n,l,a=i||[],s=0;for(n=0,l=t.length;n<l;++n){var p=ol.geom.flat.deflate.coordinatess(e,o,t[n],r,a[s]);a[s++]=p,o=p[p.length-1]}return a.length=s,a},goog.provide("ol.geom.flat.inflate"),ol.geom.flat.inflate.coordinates=function(e,o,t,r,i){var n,l=void 0!==i?i:[],a=0;for(n=o;n<t;n+=r)l[a++]=e.slice(n,n+r);return l.length=a,l},ol.geom.flat.inflate.coordinatess=function(e,o,t,r,i){var n,l,a=void 0!==i?i:[],s=0;for(n=0,l=t.length;n<l;++n){var p=t[n];a[s++]=ol.geom.flat.inflate.coordinates(e,o,p,r,a[s]),o=p}return a.length=s,a},ol.geom.flat.inflate.coordinatesss=function(e,o,t,r,i){var n,l,a=void 0!==i?i:[],s=0;for(n=0,l=t.length;n<l;++n){var p=t[n];a[s++]=ol.geom.flat.inflate.coordinatess(e,o,p,r,a[s]),o=p[p.length-1]}return a.length=s,a},goog.provide("ol.geom.flat.simplify"),goog.require("ol.math"),ol.geom.flat.simplify.lineString=function(e,o,t,r,i,n,l){var a=void 0!==l?l:[];return n||(t=ol.geom.flat.simplify.radialDistance(e,o,t,r,i,a,0),e=a,o=0,r=2),a.length=ol.geom.flat.simplify.douglasPeucker(e,o,t,r,i,a,0),a},ol.geom.flat.simplify.douglasPeucker=function(e,o,t,r,i,n,l){var a=(t-o)/r;if(a<3){for(;o<t;o+=r)n[l++]=e[o],n[l++]=e[o+1];return l}var s=new Array(a);s[0]=1,s[a-1]=1;for(var p,g=[o,t-r],c=0;g.length>0;){var u=g.pop(),y=g.pop(),d=0,h=e[y],m=e[y+1],f=e[u],_=e[u+1];for(p=y+r;p<u;p+=r){var E=e[p],v=e[p+1],S=ol.math.squaredSegmentDistance(E,v,h,m,f,_);S>d&&(c=p,d=S)}d>i&&(s[(c-o)/r]=1,y+r<c&&g.push(y,c),c+r<u&&g.push(c,u))}for(p=0;p<a;++p)s[p]&&(n[l++]=e[o+p*r],n[l++]=e[o+p*r+1]);return l},ol.geom.flat.simplify.douglasPeuckers=function(e,o,t,r,i,n,l,a){var s,p;for(s=0,p=t.length;s<p;++s){var g=t[s];l=ol.geom.flat.simplify.douglasPeucker(e,o,g,r,i,n,l),a.push(l),o=g}return l},
ol.geom.flat.simplify.douglasPeuckerss=function(e,o,t,r,i,n,l,a){var s,p;for(s=0,p=t.length;s<p;++s){var g=t[s],c=[];l=ol.geom.flat.simplify.douglasPeuckers(e,o,g,r,i,n,l,c),a.push(c),o=g[g.length-1]}return l},ol.geom.flat.simplify.radialDistance=function(e,o,t,r,i,n,l){if(t<=o+r){for(;o<t;o+=r)n[l++]=e[o],n[l++]=e[o+1];return l}var a=e[o],s=e[o+1];n[l++]=a,n[l++]=s;var p=a,g=s;for(o+=r;o<t;o+=r)p=e[o],g=e[o+1],ol.math.squaredDistance(a,s,p,g)>i&&(n[l++]=p,n[l++]=g,a=p,s=g);return p==a&&g==s||(n[l++]=p,n[l++]=g),l},ol.geom.flat.simplify.snap=function(e,o){return o*Math.round(e/o)},ol.geom.flat.simplify.quantize=function(e,o,t,r,i,n,l){if(o==t)return l;var a=ol.geom.flat.simplify.snap(e[o],i),s=ol.geom.flat.simplify.snap(e[o+1],i);o+=r,n[l++]=a,n[l++]=s;var p,g;do{if(p=ol.geom.flat.simplify.snap(e[o],i),g=ol.geom.flat.simplify.snap(e[o+1],i),(o+=r)==t)return n[l++]=p,n[l++]=g,l}while(p==a&&g==s);for(;o<t;){var c,u;if(c=ol.geom.flat.simplify.snap(e[o],i),u=ol.geom.flat.simplify.snap(e[o+1],i),o+=r,c!=p||u!=g){var y=p-a,d=g-s,h=c-a,m=u-s;y*m==d*h&&(y<0&&h<y||y==h||y>0&&h>y)&&(d<0&&m<d||d==m||d>0&&m>d)?(p=c,g=u):(n[l++]=p,n[l++]=g,a=p,s=g,p=c,g=u)}}return n[l++]=p,n[l++]=g,l},ol.geom.flat.simplify.quantizes=function(e,o,t,r,i,n,l,a){var s,p;for(s=0,p=t.length;s<p;++s){var g=t[s];l=ol.geom.flat.simplify.quantize(e,o,g,r,i,n,l),a.push(l),o=g}return l},ol.geom.flat.simplify.quantizess=function(e,o,t,r,i,n,l,a){var s,p;for(s=0,p=t.length;s<p;++s){var g=t[s],c=[];l=ol.geom.flat.simplify.quantizes(e,o,g,r,i,n,l,c),a.push(c),o=g[g.length-1]}return l},goog.provide("ol.geom.LinearRing"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.geom.flat.area"),goog.require("ol.geom.flat.closest"),goog.require("ol.geom.flat.deflate"),goog.require("ol.geom.flat.inflate"),goog.require("ol.geom.flat.simplify"),ol.geom.LinearRing=function(e,o){ol.geom.SimpleGeometry.call(this),this.maxDelta_=-1,this.maxDeltaRevision_=-1,this.setCoordinates(e,o)},ol.inherits(ol.geom.LinearRing,ol.geom.SimpleGeometry),ol.geom.LinearRing.prototype.clone=function(){var e=new ol.geom.LinearRing(null);return e.setFlatCoordinates(this.layout,this.flatCoordinates.slice()),e},ol.geom.LinearRing.prototype.closestPointXY=function(e,o,t,r){return r<ol.extent.closestSquaredDistanceXY(this.getExtent(),e,o)?r:(this.maxDeltaRevision_!=this.getRevision()&&(this.maxDelta_=Math.sqrt(ol.geom.flat.closest.getMaxSquaredDelta(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,0)),this.maxDeltaRevision_=this.getRevision()),ol.geom.flat.closest.getClosestPoint(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,this.maxDelta_,!0,e,o,t,r))},ol.geom.LinearRing.prototype.getArea=function(){return ol.geom.flat.area.linearRing(this.flatCoordinates,0,this.flatCoordinates.length,this.stride)},ol.geom.LinearRing.prototype.getCoordinates=function(){return ol.geom.flat.inflate.coordinates(this.flatCoordinates,0,this.flatCoordinates.length,this.stride)},ol.geom.LinearRing.prototype.getSimplifiedGeometryInternal=function(e){var o=[];o.length=ol.geom.flat.simplify.douglasPeucker(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,e,o,0);var t=new ol.geom.LinearRing(null);return t.setFlatCoordinates(ol.geom.GeometryLayout.XY,o),t},ol.geom.LinearRing.prototype.getType=function(){return ol.geom.GeometryType.LINEAR_RING},ol.geom.LinearRing.prototype.setCoordinates=function(e,o){e?(this.setLayout(o,e,1),this.flatCoordinates||(this.flatCoordinates=[]),this.flatCoordinates.length=ol.geom.flat.deflate.coordinates(this.flatCoordinates,0,e,this.stride),this.changed()):this.setFlatCoordinates(ol.geom.GeometryLayout.XY,null)},ol.geom.LinearRing.prototype.setFlatCoordinates=function(e,o){this.setFlatCoordinatesInternal(e,o),this.changed()},goog.provide("ol.geom.Point"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.geom.flat.deflate"),goog.require("ol.math"),ol.geom.Point=function(e,o){ol.geom.SimpleGeometry.call(this),this.setCoordinates(e,o)},ol.inherits(ol.geom.Point,ol.geom.SimpleGeometry),ol.geom.Point.prototype.clone=function(){var e=new ol.geom.Point(null);return e.setFlatCoordinates(this.layout,this.flatCoordinates.slice()),e},ol.geom.Point.prototype.closestPointXY=function(e,o,t,r){var i=this.flatCoordinates,n=ol.math.squaredDistance(e,o,i[0],i[1]);if(n<r){var l,a=this.stride;for(l=0;l<a;++l)t[l]=i[l];return t.length=a,n}return r},ol.geom.Point.prototype.getCoordinates=function(){return this.flatCoordinates?this.flatCoordinates.slice():[]},ol.geom.Point.prototype.computeExtent=function(e){return ol.extent.createOrUpdateFromCoordinate(this.flatCoordinates,e)},ol.geom.Point.prototype.getType=function(){return ol.geom.GeometryType.POINT},ol.geom.Point.prototype.intersectsExtent=function(e){return ol.extent.containsXY(e,this.flatCoordinates[0],this.flatCoordinates[1])},ol.geom.Point.prototype.setCoordinates=function(e,o){e?(this.setLayout(o,e,0),this.flatCoordinates||(this.flatCoordinates=[]),this.flatCoordinates.length=ol.geom.flat.deflate.coordinate(this.flatCoordinates,0,e,this.stride),this.changed()):this.setFlatCoordinates(ol.geom.GeometryLayout.XY,null)},ol.geom.Point.prototype.setFlatCoordinates=function(e,o){this.setFlatCoordinatesInternal(e,o),this.changed()},goog.provide("ol.geom.flat.contains"),goog.require("ol"),goog.require("ol.extent"),ol.geom.flat.contains.linearRingContainsExtent=function(e,o,t,r,i){return!ol.extent.forEachCorner(i,function(i){return!ol.geom.flat.contains.linearRingContainsXY(e,o,t,r,i[0],i[1])})},ol.geom.flat.contains.linearRingContainsXY=function(e,o,t,r,i,n){for(var l=0,a=e[t-r],s=e[t-r+1];o<t;o+=r){var p=e[o],g=e[o+1];s<=n?g>n&&(p-a)*(n-s)-(i-a)*(g-s)>0&&l++:g<=n&&(p-a)*(n-s)-(i-a)*(g-s)<0&&l--,a=p,s=g}return 0!==l},ol.geom.flat.contains.linearRingsContainsXY=function(e,o,t,r,i,n){if(ol.DEBUG&&console.assert(t.length>0,"ends should not be an empty array"),0===t.length)return!1;if(!ol.geom.flat.contains.linearRingContainsXY(e,o,t[0],r,i,n))return!1;var l,a;for(l=1,a=t.length;l<a;++l)if(ol.geom.flat.contains.linearRingContainsXY(e,t[l-1],t[l],r,i,n))return!1;return!0},ol.geom.flat.contains.linearRingssContainsXY=function(e,o,t,r,i,n){if(ol.DEBUG&&console.assert(t.length>0,"endss should not be an empty array"),0===t.length)return!1;var l,a;for(l=0,a=t.length;l<a;++l){var s=t[l];if(ol.geom.flat.contains.linearRingsContainsXY(e,o,s,r,i,n))return!0;o=s[s.length-1]}return!1},goog.provide("ol.geom.flat.interiorpoint"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.geom.flat.contains"),ol.geom.flat.interiorpoint.linearRings=function(e,o,t,r,i,n,l){var a,s,p,g,c,u,y,d=i[n+1],h=[],m=t[0];for(g=e[m-r],u=e[m-r+1],a=o;a<m;a+=r)c=e[a],y=e[a+1],(d<=u&&y<=d||u<=d&&d<=y)&&(p=(d-u)/(y-u)*(c-g)+g,h.push(p)),g=c,u=y;var f=NaN,_=-1/0;for(h.sort(ol.array.numberSafeCompareFunction),g=h[0],a=1,s=h.length;a<s;++a){c=h[a];var E=Math.abs(c-g);E>_&&(p=(g+c)/2,ol.geom.flat.contains.linearRingsContainsXY(e,o,t,r,p,d)&&(f=p,_=E)),g=c}return isNaN(f)&&(f=i[n]),l?(l.push(f,d),l):[f,d]},ol.geom.flat.interiorpoint.linearRingss=function(e,o,t,r,i){ol.DEBUG&&console.assert(2*t.length==i.length,"endss.length times 2 should be flatCenters.length");var n,l,a=[];for(n=0,l=t.length;n<l;++n){var s=t[n];a=ol.geom.flat.interiorpoint.linearRings(e,o,s,r,i,2*n,a),o=s[s.length-1]}return a},goog.provide("ol.geom.flat.segments"),ol.geom.flat.segments.forEach=function(e,o,t,r,i,n){for(var l,a=[e[o],e[o+1]],s=[];o+r<t;o+=r){if(s[0]=e[o+r],s[1]=e[o+r+1],l=i.call(n,a,s))return l;a[0]=s[0],a[1]=s[1]}return!1},goog.provide("ol.geom.flat.intersectsextent"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.geom.flat.contains"),goog.require("ol.geom.flat.segments"),ol.geom.flat.intersectsextent.lineString=function(e,o,t,r,i){var n=ol.extent.extendFlatCoordinates(ol.extent.createEmpty(),e,o,t,r);return!!ol.extent.intersects(i,n)&&(!!ol.extent.containsExtent(i,n)||(n[0]>=i[0]&&n[2]<=i[2]||(n[1]>=i[1]&&n[3]<=i[3]||ol.geom.flat.segments.forEach(e,o,t,r,function(e,o){return ol.extent.intersectsSegment(i,e,o)}))))},ol.geom.flat.intersectsextent.lineStrings=function(e,o,t,r,i){var n,l;for(n=0,l=t.length;n<l;++n){if(ol.geom.flat.intersectsextent.lineString(e,o,t[n],r,i))return!0;o=t[n]}return!1},ol.geom.flat.intersectsextent.linearRing=function(e,o,t,r,i){return!!ol.geom.flat.intersectsextent.lineString(e,o,t,r,i)||(!!ol.geom.flat.contains.linearRingContainsXY(e,o,t,r,i[0],i[1])||(!!ol.geom.flat.contains.linearRingContainsXY(e,o,t,r,i[0],i[3])||(!!ol.geom.flat.contains.linearRingContainsXY(e,o,t,r,i[2],i[1])||!!ol.geom.flat.contains.linearRingContainsXY(e,o,t,r,i[2],i[3]))))},ol.geom.flat.intersectsextent.linearRings=function(e,o,t,r,i){if(ol.DEBUG&&console.assert(t.length>0,"ends should not be an empty array"),!ol.geom.flat.intersectsextent.linearRing(e,o,t[0],r,i))return!1;if(1===t.length)return!0;var n,l;for(n=1,l=t.length;n<l;++n)if(ol.geom.flat.contains.linearRingContainsExtent(e,t[n-1],t[n],r,i))return!1;return!0},ol.geom.flat.intersectsextent.linearRingss=function(e,o,t,r,i){ol.DEBUG&&console.assert(t.length>0,"endss should not be an empty array");var n,l;for(n=0,l=t.length;n<l;++n){var a=t[n];if(ol.geom.flat.intersectsextent.linearRings(e,o,a,r,i))return!0;o=a[a.length-1]}return!1},goog.provide("ol.geom.flat.reverse"),ol.geom.flat.reverse.coordinates=function(e,o,t,r){for(;o<t-r;){var i;for(i=0;i<r;++i){var n=e[o+i];e[o+i]=e[t-r+i],e[t-r+i]=n}o+=r,t-=r}},goog.provide("ol.geom.flat.orient");goog.require("ol"),goog.require("ol.geom.flat.reverse"),ol.geom.flat.orient.linearRingIsClockwise=function(e,o,t,r){for(var i=0,n=e[t-r],l=e[t-r+1];o<t;o+=r){var a=e[o],s=e[o+1];i+=(a-n)*(s+l),n=a,l=s}return i>0},ol.geom.flat.orient.linearRingsAreOriented=function(e,o,t,r,i){var n,l,a=void 0!==i&&i;for(n=0,l=t.length;n<l;++n){var s=t[n],p=ol.geom.flat.orient.linearRingIsClockwise(e,o,s,r);if(0===n){if(a&&p||!a&&!p)return!1}else if(a&&!p||!a&&p)return!1;o=s}return!0},ol.geom.flat.orient.linearRingssAreOriented=function(e,o,t,r,i){var n,l;for(n=0,l=t.length;n<l;++n)if(!ol.geom.flat.orient.linearRingsAreOriented(e,o,t[n],r,i))return!1;return!0},ol.geom.flat.orient.orientLinearRings=function(e,o,t,r,i){var n,l,a=void 0!==i&&i;for(n=0,l=t.length;n<l;++n){var s=t[n],p=ol.geom.flat.orient.linearRingIsClockwise(e,o,s,r);(0===n?a&&p||!a&&!p:a&&!p||!a&&p)&&ol.geom.flat.reverse.coordinates(e,o,s,r),o=s}return o},ol.geom.flat.orient.orientLinearRingss=function(e,o,t,r,i){var n,l;for(n=0,l=t.length;n<l;++n)o=ol.geom.flat.orient.orientLinearRings(e,o,t[n],r,i);return o},goog.provide("ol.geom.Polygon"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.extent"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.LinearRing"),goog.require("ol.geom.Point"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.geom.flat.area"),goog.require("ol.geom.flat.closest"),goog.require("ol.geom.flat.contains"),goog.require("ol.geom.flat.deflate"),goog.require("ol.geom.flat.inflate"),goog.require("ol.geom.flat.interiorpoint"),goog.require("ol.geom.flat.intersectsextent"),goog.require("ol.geom.flat.orient"),goog.require("ol.geom.flat.simplify"),goog.require("ol.math"),ol.geom.Polygon=function(e,o){ol.geom.SimpleGeometry.call(this),this.ends_=[],this.flatInteriorPointRevision_=-1,this.flatInteriorPoint_=null,this.maxDelta_=-1,this.maxDeltaRevision_=-1,this.orientedRevision_=-1,this.orientedFlatCoordinates_=null,this.setCoordinates(e,o)},ol.inherits(ol.geom.Polygon,ol.geom.SimpleGeometry),ol.geom.Polygon.prototype.appendLinearRing=function(e){ol.DEBUG&&console.assert(e.getLayout()==this.layout,"layout of linearRing should match layout"),this.flatCoordinates?ol.array.extend(this.flatCoordinates,e.getFlatCoordinates()):this.flatCoordinates=e.getFlatCoordinates().slice(),this.ends_.push(this.flatCoordinates.length),this.changed()},ol.geom.Polygon.prototype.clone=function(){var e=new ol.geom.Polygon(null);return e.setFlatCoordinates(this.layout,this.flatCoordinates.slice(),this.ends_.slice()),e},ol.geom.Polygon.prototype.closestPointXY=function(e,o,t,r){return r<ol.extent.closestSquaredDistanceXY(this.getExtent(),e,o)?r:(this.maxDeltaRevision_!=this.getRevision()&&(this.maxDelta_=Math.sqrt(ol.geom.flat.closest.getsMaxSquaredDelta(this.flatCoordinates,0,this.ends_,this.stride,0)),this.maxDeltaRevision_=this.getRevision()),ol.geom.flat.closest.getsClosestPoint(this.flatCoordinates,0,this.ends_,this.stride,this.maxDelta_,!0,e,o,t,r))},ol.geom.Polygon.prototype.containsXY=function(e,o){return ol.geom.flat.contains.linearRingsContainsXY(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride,e,o)},ol.geom.Polygon.prototype.getArea=function(){return ol.geom.flat.area.linearRings(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride)},ol.geom.Polygon.prototype.getCoordinates=function(e){var o;return void 0!==e?(o=this.getOrientedFlatCoordinates().slice(),ol.geom.flat.orient.orientLinearRings(o,0,this.ends_,this.stride,e)):o=this.flatCoordinates,ol.geom.flat.inflate.coordinatess(o,0,this.ends_,this.stride)},ol.geom.Polygon.prototype.getEnds=function(){return this.ends_},ol.geom.Polygon.prototype.getFlatInteriorPoint=function(){if(this.flatInteriorPointRevision_!=this.getRevision()){var e=ol.extent.getCenter(this.getExtent());this.flatInteriorPoint_=ol.geom.flat.interiorpoint.linearRings(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride,e,0),this.flatInteriorPointRevision_=this.getRevision()}return this.flatInteriorPoint_},ol.geom.Polygon.prototype.getInteriorPoint=function(){return new ol.geom.Point(this.getFlatInteriorPoint())},ol.geom.Polygon.prototype.getLinearRingCount=function(){return this.ends_.length},ol.geom.Polygon.prototype.getLinearRing=function(e){if(ol.DEBUG&&console.assert(0<=e&&e<this.ends_.length,"index should be in between 0 and and length of this.ends_"),e<0||this.ends_.length<=e)return null;var o=new ol.geom.LinearRing(null);return o.setFlatCoordinates(this.layout,this.flatCoordinates.slice(0===e?0:this.ends_[e-1],this.ends_[e])),o},ol.geom.Polygon.prototype.getLinearRings=function(){var e,o,t=this.layout,r=this.flatCoordinates,i=this.ends_,n=[],l=0;for(e=0,o=i.length;e<o;++e){var a=i[e],s=new ol.geom.LinearRing(null);s.setFlatCoordinates(t,r.slice(l,a)),n.push(s),l=a}return n},ol.geom.Polygon.prototype.getOrientedFlatCoordinates=function(){if(this.orientedRevision_!=this.getRevision()){var e=this.flatCoordinates;ol.geom.flat.orient.linearRingsAreOriented(e,0,this.ends_,this.stride)?this.orientedFlatCoordinates_=e:(this.orientedFlatCoordinates_=e.slice(),this.orientedFlatCoordinates_.length=ol.geom.flat.orient.orientLinearRings(this.orientedFlatCoordinates_,0,this.ends_,this.stride)),this.orientedRevision_=this.getRevision()}return this.orientedFlatCoordinates_},ol.geom.Polygon.prototype.getSimplifiedGeometryInternal=function(e){var o=[],t=[];o.length=ol.geom.flat.simplify.quantizes(this.flatCoordinates,0,this.ends_,this.stride,Math.sqrt(e),o,0,t);var r=new ol.geom.Polygon(null);return r.setFlatCoordinates(ol.geom.GeometryLayout.XY,o,t),r},ol.geom.Polygon.prototype.getType=function(){return ol.geom.GeometryType.POLYGON},ol.geom.Polygon.prototype.intersectsExtent=function(e){return ol.geom.flat.intersectsextent.linearRings(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride,e)},ol.geom.Polygon.prototype.setCoordinates=function(e,o){if(e){this.setLayout(o,e,2),this.flatCoordinates||(this.flatCoordinates=[]);var t=ol.geom.flat.deflate.coordinatess(this.flatCoordinates,0,e,this.stride,this.ends_);this.flatCoordinates.length=0===t.length?0:t[t.length-1],this.changed()}else this.setFlatCoordinates(ol.geom.GeometryLayout.XY,null,this.ends_)},ol.geom.Polygon.prototype.setFlatCoordinates=function(e,o,t){o?0===t.length?ol.DEBUG&&console.assert(0===o.length,"flatCoordinates should be an empty array"):ol.DEBUG&&console.assert(o.length==t[t.length-1],"the length of flatCoordinates should be the last entry of ends"):ol.DEBUG&&console.assert(t&&0===t.length,"ends must be an empty array"),this.setFlatCoordinatesInternal(e,o),this.ends_=t,this.changed()},ol.geom.Polygon.circular=function(e,o,t,r){var i,n=r||32,l=[];for(i=0;i<n;++i)ol.array.extend(l,e.offset(o,t,2*Math.PI*i/n));l.push(l[0],l[1]);var a=new ol.geom.Polygon(null);return a.setFlatCoordinates(ol.geom.GeometryLayout.XY,l,[l.length]),a},ol.geom.Polygon.fromExtent=function(e){var o=e[0],t=e[1],r=e[2],i=e[3],n=[o,t,o,i,r,i,r,t,o,t],l=new ol.geom.Polygon(null);return l.setFlatCoordinates(ol.geom.GeometryLayout.XY,n,[n.length]),l},ol.geom.Polygon.fromCircle=function(e,o,t){for(var r=o||32,i=e.getStride(),n=e.getLayout(),l=new ol.geom.Polygon(null,n),a=i*(r+1),s=new Array(a),p=0;p<a;p++)s[p]=0;var g=[s.length];return l.setFlatCoordinates(n,s,g),ol.geom.Polygon.makeRegular(l,e.getCenter(),e.getRadius(),t),l},ol.geom.Polygon.makeRegular=function(e,o,t,r){var i=e.getFlatCoordinates(),n=e.getLayout(),l=e.getStride(),a=e.getEnds();ol.DEBUG&&console.assert(1===a.length,"only 1 ring is supported");for(var s,p,g=i.length/l-1,c=r||0,u=0;u<=g;++u)p=u*l,s=c+2*ol.math.modulo(u,g)*Math.PI/g,i[p]=o[0]+t*Math.cos(s),i[p+1]=o[1]+t*Math.sin(s);e.setFlatCoordinates(n,i,a)},goog.provide("ol.View"),goog.require("ol"),goog.require("ol.CenterConstraint"),goog.require("ol.Constraints"),goog.require("ol.Object"),goog.require("ol.ResolutionConstraint"),goog.require("ol.RotationConstraint"),goog.require("ol.array"),goog.require("ol.asserts"),goog.require("ol.coordinate"),goog.require("ol.easing"),goog.require("ol.extent"),goog.require("ol.geom.Polygon"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.proj"),goog.require("ol.proj.Units"),ol.View=function(e){ol.Object.call(this);var o=e||{};this.hints_=[0,0],this.animations_=[],this.updateAnimationKey_,this.updateAnimations_=this.updateAnimations_.bind(this);var t={};t[ol.View.Property.CENTER]=void 0!==o.center?o.center:null,this.projection_=ol.proj.createProjection(o.projection,"EPSG:3857");var r=ol.View.createResolutionConstraint_(o);this.maxResolution_=r.maxResolution,this.minResolution_=r.minResolution,this.zoomFactor_=r.zoomFactor,this.resolutions_=o.resolutions,this.minZoom_=r.minZoom;var i=ol.View.createCenterConstraint_(o),n=r.constraint,l=ol.View.createRotationConstraint_(o);this.constraints_=new ol.Constraints(i,n,l),void 0!==o.resolution?t[ol.View.Property.RESOLUTION]=o.resolution:void 0!==o.zoom&&(t[ol.View.Property.RESOLUTION]=this.constrainResolution(this.maxResolution_,o.zoom-this.minZoom_)),t[ol.View.Property.ROTATION]=void 0!==o.rotation?o.rotation:0,this.setProperties(t)},ol.inherits(ol.View,ol.Object),ol.View.prototype.animate=function(e){var o,t=Date.now(),r=this.getCenter().slice(),i=this.getResolution(),n=this.getRotation(),l=arguments.length;l>1&&"function"==typeof arguments[l-1]&&(o=arguments[l-1],--l);for(var a=[],s=0;s<l;++s){var p=arguments[s],g={start:t,complete:!1,anchor:p.anchor,duration:void 0!==p.duration?p.duration:1e3,easing:p.easing||ol.easing.inAndOut};p.center&&(g.sourceCenter=r,g.targetCenter=p.center,r=g.targetCenter),void 0!==p.zoom?(g.sourceResolution=i,g.targetResolution=this.constrainResolution(this.maxResolution_,p.zoom-this.minZoom_,0),i=g.targetResolution):p.resolution&&(g.sourceResolution=i,g.targetResolution=p.resolution,i=g.targetResolution),void 0!==p.rotation&&(g.sourceRotation=n,g.targetRotation=p.rotation,n=g.targetRotation),g.callback=o,t+=g.duration,a.push(g)}this.animations_.push(a),this.setHint(ol.View.Hint.ANIMATING,1),this.updateAnimations_()},ol.View.prototype.getAnimating=function(){return this.getHints()[ol.View.Hint.ANIMATING]>0},ol.View.prototype.cancelAnimations=function(){this.setHint(ol.View.Hint.ANIMATING,-this.getHints()[ol.View.Hint.ANIMATING]);for(var e=0,o=this.animations_.length;e<o;++e){var t=this.animations_[e];t[0].callback&&t[0].callback(!1)}this.animations_.length=0},ol.View.prototype.updateAnimations_=function(){if(void 0!==this.updateAnimationKey_&&(cancelAnimationFrame(this.updateAnimationKey_),this.updateAnimationKey_=void 0),this.getAnimating()){for(var e=Date.now(),o=!1,t=this.animations_.length-1;t>=0;--t){for(var r=this.animations_[t],i=!0,n=0,l=r.length;n<l;++n){var a=r[n];if(!a.complete){var s=e-a.start,p=a.duration>0?s/a.duration:1;p>=1?(a.complete=!0,p=1):i=!1;var g=a.easing(p);if(a.sourceCenter){var c=a.sourceCenter[0],u=a.sourceCenter[1],y=a.targetCenter[0],d=a.targetCenter[1],h=c+g*(y-c),m=u+g*(d-u);this.set(ol.View.Property.CENTER,[h,m])}if(a.sourceResolution){var f=a.sourceResolution+g*(a.targetResolution-a.sourceResolution);a.anchor&&this.set(ol.View.Property.CENTER,this.calculateCenterZoom(f,a.anchor)),this.set(ol.View.Property.RESOLUTION,f)}if(void 0!==a.sourceRotation){var _=a.sourceRotation+g*(a.targetRotation-a.sourceRotation);a.anchor&&this.set(ol.View.Property.CENTER,this.calculateCenterRotate(_,a.anchor)),this.set(ol.View.Property.ROTATION,_)}if(o=!0,!a.complete)break}}if(i){this.animations_[t]=null,this.setHint(ol.View.Hint.ANIMATING,-1);var E=r[0].callback;E&&E(!0)}}this.animations_=this.animations_.filter(Boolean),o&&void 0===this.updateAnimationKey_&&(this.updateAnimationKey_=requestAnimationFrame(this.updateAnimations_))}},ol.View.prototype.calculateCenterRotate=function(e,o){var t,r=this.getCenter();return void 0!==r&&(t=[r[0]-o[0],r[1]-o[1]],ol.coordinate.rotate(t,e-this.getRotation()),ol.coordinate.add(t,o)),t},ol.View.prototype.calculateCenterZoom=function(e,o){var t,r=this.getCenter(),i=this.getResolution();if(void 0!==r&&void 0!==i){t=[o[0]-e*(o[0]-r[0])/i,o[1]-e*(o[1]-r[1])/i]}return t},ol.View.prototype.constrainCenter=function(e){return this.constraints_.center(e)},ol.View.prototype.constrainResolution=function(e,o,t){var r=o||0,i=t||0;return this.constraints_.resolution(e,r,i)},ol.View.prototype.constrainRotation=function(e,o){var t=o||0;return this.constraints_.rotation(e,t)},ol.View.prototype.getCenter=function(){return this.get(ol.View.Property.CENTER)},ol.View.prototype.getHints=function(e){return void 0!==e?(e[0]=this.hints_[0],e[1]=this.hints_[1],e):this.hints_.slice()},ol.View.prototype.calculateExtent=function(e){var o=this.getCenter();ol.asserts.assert(o,1);var t=this.getResolution();ol.asserts.assert(void 0!==t,2);var r=this.getRotation();return ol.asserts.assert(void 0!==r,3),ol.extent.getForViewAndSize(o,t,r,e)},ol.View.prototype.getMaxResolution=function(){return this.maxResolution_},ol.View.prototype.getMinResolution=function(){return this.minResolution_},ol.View.prototype.getProjection=function(){return this.projection_},ol.View.prototype.getResolution=function(){return this.get(ol.View.Property.RESOLUTION)},ol.View.prototype.getResolutions=function(){return this.resolutions_},ol.View.prototype.getResolutionForExtent=function(e,o){var t=ol.extent.getWidth(e)/o[0],r=ol.extent.getHeight(e)/o[1];return Math.max(t,r)},ol.View.prototype.getResolutionForValueFunction=function(e){var o=e||2,t=this.maxResolution_,r=this.minResolution_,i=Math.log(t/r)/Math.log(o);return function(e){var n=t/Math.pow(o,e*i);return ol.DEBUG&&console.assert(n>=r&&n<=t,"calculated resolution outside allowed bounds (%s <= %s <= %s)",r,n,t),n}},ol.View.prototype.getRotation=function(){return this.get(ol.View.Property.ROTATION)},ol.View.prototype.getValueForResolutionFunction=function(e){var o=e||2,t=this.maxResolution_,r=this.minResolution_,i=Math.log(t/r)/Math.log(o);return function(e){var r=Math.log(t/e)/Math.log(o)/i;return ol.DEBUG&&console.assert(r>=0&&r<=1,"calculated value (%s) ouside allowed range (0-1)",r),r}},ol.View.prototype.getState=function(){ol.DEBUG&&console.assert(this.isDef(),"the view was not defined (had no center and/or resolution)");var e=this.getCenter(),o=this.getProjection(),t=this.getResolution(),r=this.getRotation();return{center:e.slice(),projection:void 0!==o?o:null,resolution:t,rotation:r}},ol.View.prototype.getZoom=function(){var e,o=this.getResolution();if(void 0!==o&&o>=this.minResolution_&&o<=this.maxResolution_){var t,r,i=this.minZoom_||0;if(this.resolutions_){var n=ol.array.linearFindNearest(this.resolutions_,o,1);if(i+=n,n==this.resolutions_.length-1)return i;t=this.resolutions_[n],r=t/this.resolutions_[n+1]}else t=this.maxResolution_,r=this.zoomFactor_;e=i+Math.log(t/o)/Math.log(r)}return e},ol.View.prototype.fit=function(e,o,t){e instanceof ol.geom.SimpleGeometry||(ol.asserts.assert(Array.isArray(e),24),ol.asserts.assert(!ol.extent.isEmpty(e),25),e=ol.geom.Polygon.fromExtent(e));var r,i=t||{},n=void 0!==i.padding?i.padding:[0,0,0,0],l=void 0===i.constrainResolution||i.constrainResolution,a=void 0!==i.nearest&&i.nearest;r=void 0!==i.minResolution?i.minResolution:void 0!==i.maxZoom?this.constrainResolution(this.maxResolution_,i.maxZoom-this.minZoom_,0):0;var s=e.getFlatCoordinates(),p=this.getRotation();ol.DEBUG&&console.assert(void 0!==p,"rotation was not defined");for(var g=Math.cos(-p),c=Math.sin(-p),u=1/0,y=1/0,d=-1/0,h=-1/0,m=e.getStride(),f=0,_=s.length;f<_;f+=m){var E=s[f]*g-s[f+1]*c,v=s[f]*c+s[f+1]*g;u=Math.min(u,E),y=Math.min(y,v),d=Math.max(d,E),h=Math.max(h,v)}var S=this.getResolutionForExtent([u,y,d,h],[o[0]-n[1]-n[3],o[1]-n[0]-n[2]]);if(S=isNaN(S)?r:Math.max(S,r),l){var x=this.constrainResolution(S,0,0);!a&&x<S&&(x=this.constrainResolution(x,-1,0)),S=x}c=-c;var P=(u+d)/2,T=(y+h)/2;P+=(n[1]-n[3])/2*S,T+=(n[0]-n[2])/2*S;var R=P*g-T*c,L=T*g+P*c,M=[R,L];void 0!==i.duration?this.animate({resolution:S,center:M,duration:i.duration,easing:i.easing}):(this.setResolution(S),this.setCenter(M))},ol.View.prototype.centerOn=function(e,o,t){var r=this.getRotation(),i=Math.cos(-r),n=Math.sin(-r),l=e[0]*i-e[1]*n,a=e[1]*i+e[0]*n,s=this.getResolution();l+=(o[0]/2-t[0])*s,a+=(t[1]-o[1]/2)*s,n=-n;var p=l*i-a*n,g=a*i+l*n;this.setCenter([p,g])},ol.View.prototype.isDef=function(){return!!this.getCenter()&&void 0!==this.getResolution()},ol.View.prototype.rotate=function(e,o){if(void 0!==o){var t=this.calculateCenterRotate(e,o);this.setCenter(t)}this.setRotation(e)},ol.View.prototype.setCenter=function(e){this.set(ol.View.Property.CENTER,e),this.getAnimating()&&this.cancelAnimations()},ol.View.prototype.setHint=function(e,o){return ol.DEBUG&&console.assert(0<=e&&e<this.hints_.length,"illegal hint (%s), must be between 0 and %s",e,this.hints_.length),this.hints_[e]+=o,ol.DEBUG&&console.assert(this.hints_[e]>=0,"Hint at %s must be positive, was %s",e,this.hints_[e]),this.changed(),this.hints_[e]},ol.View.prototype.setResolution=function(e){this.set(ol.View.Property.RESOLUTION,e),this.getAnimating()&&this.cancelAnimations()},ol.View.prototype.setRotation=function(e){this.set(ol.View.Property.ROTATION,e),this.getAnimating()&&this.cancelAnimations()},ol.View.prototype.setZoom=function(e){var o=this.constrainResolution(this.maxResolution_,e-this.minZoom_,0);this.setResolution(o)},ol.View.createCenterConstraint_=function(e){return void 0!==e.extent?ol.CenterConstraint.createExtent(e.extent):ol.CenterConstraint.none},ol.View.createResolutionConstraint_=function(e){var o,t,r,i=void 0!==e.minZoom?e.minZoom:ol.DEFAULT_MIN_ZOOM,n=void 0!==e.maxZoom?e.maxZoom:28,l=void 0!==e.zoomFactor?e.zoomFactor:2;if(void 0!==e.resolutions){var a=e.resolutions;t=a[0],r=a[a.length-1],o=ol.ResolutionConstraint.createSnapToResolutions(a)}else{var s=ol.proj.createProjection(e.projection,"EPSG:3857"),p=s.getExtent(),g=p?Math.max(ol.extent.getWidth(p),ol.extent.getHeight(p)):360*ol.proj.METERS_PER_UNIT[ol.proj.Units.DEGREES]/s.getMetersPerUnit(),c=g/ol.DEFAULT_TILE_SIZE/Math.pow(2,ol.DEFAULT_MIN_ZOOM),u=c/Math.pow(2,28-ol.DEFAULT_MIN_ZOOM);t=e.maxResolution,void 0!==t?i=0:t=c/Math.pow(l,i),r=e.minResolution,void 0===r&&(r=void 0!==e.maxZoom?void 0!==e.maxResolution?t/Math.pow(l,n):c/Math.pow(l,n):u),n=i+Math.floor(Math.log(t/r)/Math.log(l)),r=t/Math.pow(l,n-i),o=ol.ResolutionConstraint.createSnapToPower(l,t,n-i)}return{constraint:o,maxResolution:t,minResolution:r,minZoom:i,zoomFactor:l}},ol.View.createRotationConstraint_=function(e){if(void 0===e.enableRotation||e.enableRotation){var o=e.constrainRotation;return void 0===o||!0===o?ol.RotationConstraint.createSnapToZero():!1===o?ol.RotationConstraint.none:"number"==typeof o?ol.RotationConstraint.createSnapToN(o):(ol.DEBUG&&console.assert(!1,"illegal option for constrainRotation (%s)",o),ol.RotationConstraint.none)}return ol.RotationConstraint.disable},ol.View.Property={CENTER:"center",RESOLUTION:"resolution",ROTATION:"rotation"},ol.View.Hint={ANIMATING:0,INTERACTING:1},goog.provide("ol.animation"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.coordinate"),goog.require("ol.easing"),ol.animation.bounce=function(e){ol.DEBUG&&console.warn("ol.animation.bounce() is deprecated.  Use view.animate() instead.");var o=e.resolution,t=e.start?e.start:Date.now(),r=void 0!==e.duration?e.duration:1e3,i=e.easing?e.easing:ol.easing.upAndDown;return function(e,n){if(n.time<t)return n.animate=!0,n.viewHints[ol.View.Hint.ANIMATING]+=1,!0;if(n.time<t+r){var l=i((n.time-t)/r),a=o-n.viewState.resolution;return n.animate=!0,n.viewState.resolution+=l*a,n.viewHints[ol.View.Hint.ANIMATING]+=1,!0}return!1}},ol.animation.pan=function(e){ol.DEBUG&&console.warn("ol.animation.pan() is deprecated.  Use view.animate() instead.");var o=e.source,t=e.start?e.start:Date.now(),r=o[0],i=o[1],n=void 0!==e.duration?e.duration:1e3,l=e.easing?e.easing:ol.easing.inAndOut;return function(e,o){if(o.time<t)return o.animate=!0,o.viewHints[ol.View.Hint.ANIMATING]+=1,!0;if(o.time<t+n){var a=1-l((o.time-t)/n),s=r-o.viewState.center[0],p=i-o.viewState.center[1];return o.animate=!0,o.viewState.center[0]+=a*s,o.viewState.center[1]+=a*p,o.viewHints[ol.View.Hint.ANIMATING]+=1,!0}return!1}},ol.animation.rotate=function(e){ol.DEBUG&&console.warn("ol.animation.rotate() is deprecated.  Use view.animate() instead.");var o=e.rotation?e.rotation:0,t=e.start?e.start:Date.now(),r=void 0!==e.duration?e.duration:1e3,i=e.easing?e.easing:ol.easing.inAndOut,n=e.anchor?e.anchor:null;return function(e,l){if(l.time<t)return l.animate=!0,l.viewHints[ol.View.Hint.ANIMATING]+=1,!0;if(l.time<t+r){var a=1-i((l.time-t)/r),s=(o-l.viewState.rotation)*a;if(l.animate=!0,l.viewState.rotation+=s,n){var p=l.viewState.center;ol.coordinate.sub(p,n),ol.coordinate.rotate(p,s),ol.coordinate.add(p,n)}return l.viewHints[ol.View.Hint.ANIMATING]+=1,!0}return!1}},ol.animation.zoom=function(e){ol.DEBUG&&console.warn("ol.animation.zoom() is deprecated.  Use view.animate() instead.");var o=e.resolution,t=e.start?e.start:Date.now(),r=void 0!==e.duration?e.duration:1e3,i=e.easing?e.easing:ol.easing.inAndOut;return function(e,n){if(n.time<t)return n.animate=!0,n.viewHints[ol.View.Hint.ANIMATING]+=1,!0;if(n.time<t+r){var l=1-i((n.time-t)/r),a=o-n.viewState.resolution;return n.animate=!0,n.viewState.resolution+=l*a,n.viewHints[ol.View.Hint.ANIMATING]+=1,!0}return!1}},goog.provide("ol.TileRange"),ol.TileRange=function(e,o,t,r){this.minX=e,this.maxX=o,this.minY=t,this.maxY=r},ol.TileRange.createOrUpdate=function(e,o,t,r,i){return void 0!==i?(i.minX=e,i.maxX=o,i.minY=t,i.maxY=r,i):new ol.TileRange(e,o,t,r)},ol.TileRange.prototype.contains=function(e){return this.containsXY(e[1],e[2])},ol.TileRange.prototype.containsTileRange=function(e){return this.minX<=e.minX&&e.maxX<=this.maxX&&this.minY<=e.minY&&e.maxY<=this.maxY},ol.TileRange.prototype.containsXY=function(e,o){return this.minX<=e&&e<=this.maxX&&this.minY<=o&&o<=this.maxY},ol.TileRange.prototype.equals=function(e){return this.minX==e.minX&&this.minY==e.minY&&this.maxX==e.maxX&&this.maxY==e.maxY},ol.TileRange.prototype.extend=function(e){e.minX<this.minX&&(this.minX=e.minX),e.maxX>this.maxX&&(this.maxX=e.maxX),e.minY<this.minY&&(this.minY=e.minY),e.maxY>this.maxY&&(this.maxY=e.maxY)},ol.TileRange.prototype.getHeight=function(){return this.maxY-this.minY+1},ol.TileRange.prototype.getSize=function(){return[this.getWidth(),this.getHeight()]},
ol.TileRange.prototype.getWidth=function(){return this.maxX-this.minX+1},ol.TileRange.prototype.intersects=function(e){return this.minX<=e.maxX&&this.maxX>=e.minX&&this.minY<=e.maxY&&this.maxY>=e.minY},goog.provide("ol.size"),ol.size.buffer=function(e,o,t){return void 0===t&&(t=[0,0]),t[0]=e[0]+2*o,t[1]=e[1]+2*o,t},ol.size.hasArea=function(e){return e[0]>0&&e[1]>0},ol.size.scale=function(e,o,t){return void 0===t&&(t=[0,0]),t[0]=e[0]*o+.5|0,t[1]=e[1]*o+.5|0,t},ol.size.toSize=function(e,o){return Array.isArray(e)?e:(void 0===o?o=[e,e]:o[0]=o[1]=e,o)},goog.provide("ol.tilecoord"),ol.tilecoord.createOrUpdate=function(e,o,t,r){return void 0!==r?(r[0]=e,r[1]=o,r[2]=t,r):[e,o,t]},ol.tilecoord.getKeyZXY=function(e,o,t){return e+"/"+o+"/"+t},ol.tilecoord.hash=function(e){return(e[1]<<e[0])+e[2]},ol.tilecoord.quadKey=function(e){var o,t,r=e[0],i=new Array(r),n=1<<r-1;for(o=0;o<r;++o)t=48,e[1]&n&&(t+=1),e[2]&n&&(t+=2),i[o]=String.fromCharCode(t),n>>=1;return i.join("")},ol.tilecoord.withinExtentAndZ=function(e,o){var t=e[0],r=e[1],i=e[2];if(o.getMinZoom()>t||t>o.getMaxZoom())return!1;var n,l=o.getExtent();return!(n=l?o.getTileRangeForExtentAndZ(l,t):o.getFullTileRange(t))||n.containsXY(r,i)},goog.provide("ol.tilegrid.TileGrid"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.TileRange"),goog.require("ol.array"),goog.require("ol.extent"),goog.require("ol.math"),goog.require("ol.size"),goog.require("ol.tilecoord"),ol.tilegrid.TileGrid=function(e){this.minZoom=void 0!==e.minZoom?e.minZoom:0,this.resolutions_=e.resolutions,ol.asserts.assert(ol.array.isSorted(this.resolutions_,function(e,o){return o-e},!0),17),this.maxZoom=this.resolutions_.length-1,this.origin_=void 0!==e.origin?e.origin:null,this.origins_=null,void 0!==e.origins&&(this.origins_=e.origins,ol.asserts.assert(this.origins_.length==this.resolutions_.length,20));var o=e.extent;void 0===o||this.origin_||this.origins_||(this.origin_=ol.extent.getTopLeft(o)),ol.asserts.assert(!this.origin_&&this.origins_||this.origin_&&!this.origins_,18),this.tileSizes_=null,void 0!==e.tileSizes&&(this.tileSizes_=e.tileSizes,ol.asserts.assert(this.tileSizes_.length==this.resolutions_.length,19)),this.tileSize_=void 0!==e.tileSize?e.tileSize:this.tileSizes_?null:ol.DEFAULT_TILE_SIZE,ol.asserts.assert(!this.tileSize_&&this.tileSizes_||this.tileSize_&&!this.tileSizes_,22),this.extent_=void 0!==o?o:null,this.fullTileRanges_=null,this.tmpSize_=[0,0],void 0!==e.sizes?(ol.DEBUG&&console.assert(e.sizes.length==this.resolutions_.length,"number of sizes and resolutions must be equal"),this.fullTileRanges_=e.sizes.map(function(e,o){return ol.DEBUG&&console.assert(0!==e[0],"width must not be 0"),ol.DEBUG&&console.assert(0!==e[1],"height must not be 0"),new ol.TileRange(Math.min(0,e[0]),Math.max(e[0]-1,-1),Math.min(0,e[1]),Math.max(e[1]-1,-1))},this)):o&&this.calculateTileRanges_(o)},ol.tilegrid.TileGrid.tmpTileCoord_=[0,0,0],ol.tilegrid.TileGrid.prototype.forEachTileCoord=function(e,o,t){for(var r=this.getTileRangeForExtentAndZ(e,o),i=r.minX,n=r.maxX;i<=n;++i)for(var l=r.minY,a=r.maxY;l<=a;++l)t([o,i,l])},ol.tilegrid.TileGrid.prototype.forEachTileCoordParentTileRange=function(e,o,t,r,i){for(var n=this.getTileCoordExtent(e,i),l=e[0]-1;l>=this.minZoom;){if(o.call(t,l,this.getTileRangeForExtentAndZ(n,l,r)))return!0;--l}return!1},ol.tilegrid.TileGrid.prototype.getExtent=function(){return this.extent_},ol.tilegrid.TileGrid.prototype.getMaxZoom=function(){return this.maxZoom},ol.tilegrid.TileGrid.prototype.getMinZoom=function(){return this.minZoom},ol.tilegrid.TileGrid.prototype.getOrigin=function(e){return this.origin_?this.origin_:(ol.DEBUG&&console.assert(this.minZoom<=e&&e<=this.maxZoom,"given z is not in allowed range (%s <= %s <= %s)",this.minZoom,e,this.maxZoom),this.origins_[e])},ol.tilegrid.TileGrid.prototype.getResolution=function(e){return ol.DEBUG&&console.assert(this.minZoom<=e&&e<=this.maxZoom,"given z is not in allowed range (%s <= %s <= %s)",this.minZoom,e,this.maxZoom),this.resolutions_[e]},ol.tilegrid.TileGrid.prototype.getResolutions=function(){return this.resolutions_},ol.tilegrid.TileGrid.prototype.getTileCoordChildTileRange=function(e,o,t){if(e[0]<this.maxZoom){var r=this.getTileCoordExtent(e,t);return this.getTileRangeForExtentAndZ(r,e[0]+1,o)}return null},ol.tilegrid.TileGrid.prototype.getTileRangeExtent=function(e,o,t){var r=this.getOrigin(e),i=this.getResolution(e),n=ol.size.toSize(this.getTileSize(e),this.tmpSize_),l=r[0]+o.minX*n[0]*i,a=r[0]+(o.maxX+1)*n[0]*i,s=r[1]+o.minY*n[1]*i,p=r[1]+(o.maxY+1)*n[1]*i;return ol.extent.createOrUpdate(l,s,a,p,t)},ol.tilegrid.TileGrid.prototype.getTileRangeForExtentAndResolution=function(e,o,t){var r=ol.tilegrid.TileGrid.tmpTileCoord_;this.getTileCoordForXYAndResolution_(e[0],e[1],o,!1,r);var i=r[1],n=r[2];return this.getTileCoordForXYAndResolution_(e[2],e[3],o,!0,r),ol.TileRange.createOrUpdate(i,r[1],n,r[2],t)},ol.tilegrid.TileGrid.prototype.getTileRangeForExtentAndZ=function(e,o,t){var r=this.getResolution(o);return this.getTileRangeForExtentAndResolution(e,r,t)},ol.tilegrid.TileGrid.prototype.getTileCoordCenter=function(e){var o=this.getOrigin(e[0]),t=this.getResolution(e[0]),r=ol.size.toSize(this.getTileSize(e[0]),this.tmpSize_);return[o[0]+(e[1]+.5)*r[0]*t,o[1]+(e[2]+.5)*r[1]*t]},ol.tilegrid.TileGrid.prototype.getTileCoordExtent=function(e,o){var t=this.getOrigin(e[0]),r=this.getResolution(e[0]),i=ol.size.toSize(this.getTileSize(e[0]),this.tmpSize_),n=t[0]+e[1]*i[0]*r,l=t[1]+e[2]*i[1]*r,a=n+i[0]*r,s=l+i[1]*r;return ol.extent.createOrUpdate(n,l,a,s,o)},ol.tilegrid.TileGrid.prototype.getTileCoordForCoordAndResolution=function(e,o,t){return this.getTileCoordForXYAndResolution_(e[0],e[1],o,!1,t)},ol.tilegrid.TileGrid.prototype.getTileCoordForXYAndResolution_=function(e,o,t,r,i){var n=this.getZForResolution(t),l=t/this.getResolution(n),a=this.getOrigin(n),s=ol.size.toSize(this.getTileSize(n),this.tmpSize_),p=r?.5:0,g=r?0:.5,c=Math.floor((e-a[0])/t+p),u=Math.floor((o-a[1])/t+g),y=l*c/s[0],d=l*u/s[1];return r?(y=Math.ceil(y)-1,d=Math.ceil(d)-1):(y=Math.floor(y),d=Math.floor(d)),ol.tilecoord.createOrUpdate(n,y,d,i)},ol.tilegrid.TileGrid.prototype.getTileCoordForCoordAndZ=function(e,o,t){var r=this.getResolution(o);return this.getTileCoordForXYAndResolution_(e[0],e[1],r,!1,t)},ol.tilegrid.TileGrid.prototype.getTileCoordResolution=function(e){return ol.DEBUG&&console.assert(this.minZoom<=e[0]&&e[0]<=this.maxZoom,"z of given tilecoord is not in allowed range (%s <= %s <= %s",this.minZoom,e[0],this.maxZoom),this.resolutions_[e[0]]},ol.tilegrid.TileGrid.prototype.getTileSize=function(e){return this.tileSize_?this.tileSize_:(ol.DEBUG&&console.assert(this.minZoom<=e&&e<=this.maxZoom,"z is not in allowed range (%s <= %s <= %s",this.minZoom,e,this.maxZoom),this.tileSizes_[e])},ol.tilegrid.TileGrid.prototype.getFullTileRange=function(e){return this.fullTileRanges_?(ol.DEBUG&&console.assert(this.minZoom<=e&&e<=this.maxZoom,"z is not in allowed range (%s <= %s <= %s",this.minZoom,e,this.maxZoom),this.fullTileRanges_[e]):null},ol.tilegrid.TileGrid.prototype.getZForResolution=function(e,o){var t=ol.array.linearFindNearest(this.resolutions_,e,o||0);return ol.math.clamp(t,this.minZoom,this.maxZoom)},ol.tilegrid.TileGrid.prototype.calculateTileRanges_=function(e){for(var o=this.resolutions_.length,t=new Array(o),r=this.minZoom;r<o;++r)t[r]=this.getTileRangeForExtentAndZ(e,r);this.fullTileRanges_=t},goog.provide("ol.tilegrid"),goog.require("ol"),goog.require("ol.size"),goog.require("ol.extent"),goog.require("ol.extent.Corner"),goog.require("ol.obj"),goog.require("ol.proj"),goog.require("ol.proj.Units"),goog.require("ol.tilegrid.TileGrid"),ol.tilegrid.getForProjection=function(e){var o=e.getDefaultTileGrid();return o||(o=ol.tilegrid.createForProjection(e),e.setDefaultTileGrid(o)),o},ol.tilegrid.wrapX=function(e,o,t){var r=o[0],i=e.getTileCoordCenter(o),n=ol.tilegrid.extentFromProjection(t);if(ol.extent.containsCoordinate(n,i))return o;var l=ol.extent.getWidth(n),a=Math.ceil((n[0]-i[0])/l);return i[0]+=l*a,e.getTileCoordForCoordAndZ(i,r)},ol.tilegrid.createForExtent=function(e,o,t,r){var i=void 0!==r?r:ol.extent.Corner.TOP_LEFT,n=ol.tilegrid.resolutionsFromExtent(e,o,t);return new ol.tilegrid.TileGrid({extent:e,origin:ol.extent.getCorner(e,i),resolutions:n,tileSize:t})},ol.tilegrid.createXYZ=function(e){var o={};return ol.obj.assign(o,void 0!==e?e:{}),void 0===o.extent&&(o.extent=ol.proj.get("EPSG:3857").getExtent()),o.resolutions=ol.tilegrid.resolutionsFromExtent(o.extent,o.maxZoom,o.tileSize),delete o.maxZoom,new ol.tilegrid.TileGrid(o)},ol.tilegrid.resolutionsFromExtent=function(e,o,t){for(var r=void 0!==o?o:ol.DEFAULT_MAX_ZOOM,i=ol.extent.getHeight(e),n=ol.extent.getWidth(e),l=ol.size.toSize(void 0!==t?t:ol.DEFAULT_TILE_SIZE),a=Math.max(n/l[0],i/l[1]),s=r+1,p=new Array(s),g=0;g<s;++g)p[g]=a/Math.pow(2,g);return p},ol.tilegrid.createForProjection=function(e,o,t,r){var i=ol.tilegrid.extentFromProjection(e);return ol.tilegrid.createForExtent(i,o,t,r)},ol.tilegrid.extentFromProjection=function(e){e=ol.proj.get(e);var o=e.getExtent();if(!o){var t=180*ol.proj.METERS_PER_UNIT[ol.proj.Units.DEGREES]/e.getMetersPerUnit();o=ol.extent.createOrUpdate(-t,-t,t,t)}return o},goog.provide("ol.Attribution"),goog.require("ol.TileRange"),goog.require("ol.math"),goog.require("ol.tilegrid"),ol.Attribution=function(e){this.html_=e.html,this.tileRanges_=e.tileRanges?e.tileRanges:null},ol.Attribution.prototype.getHTML=function(){return this.html_},ol.Attribution.prototype.intersectsAnyTileRange=function(e,o,t){if(!this.tileRanges_)return!0;var r,i,n,l;for(l in e)if(l in this.tileRanges_){n=e[l];var a;for(r=0,i=this.tileRanges_[l].length;r<i;++r){if(a=this.tileRanges_[l][r],a.intersects(n))return!0;var s=o.getTileRangeForExtentAndZ(ol.tilegrid.extentFromProjection(t),parseInt(l,10)),p=s.getWidth();if(n.minX<s.minX||n.maxX>s.maxX){if(a.intersects(new ol.TileRange(ol.math.modulo(n.minX,p),ol.math.modulo(n.maxX,p),n.minY,n.maxY)))return!0;if(n.getWidth()>p&&a.intersects(s))return!0}}}return!1},goog.provide("ol.Collection"),goog.require("ol"),goog.require("ol.events.Event"),goog.require("ol.Object"),ol.Collection=function(e){ol.Object.call(this),this.array_=e||[],this.updateLength_()},ol.inherits(ol.Collection,ol.Object),ol.Collection.prototype.clear=function(){for(;this.getLength()>0;)this.pop()};ol.Collection.prototype.extend=function(e){var o,t;for(o=0,t=e.length;o<t;++o)this.push(e[o]);return this},ol.Collection.prototype.forEach=function(e,o){this.array_.forEach(e,o)},ol.Collection.prototype.getArray=function(){return this.array_},ol.Collection.prototype.item=function(e){return this.array_[e]},ol.Collection.prototype.getLength=function(){return this.get(ol.Collection.Property.LENGTH)},ol.Collection.prototype.insertAt=function(e,o){this.array_.splice(e,0,o),this.updateLength_(),this.dispatchEvent(new ol.Collection.Event(ol.Collection.EventType.ADD,o))},ol.Collection.prototype.pop=function(){return this.removeAt(this.getLength()-1)},ol.Collection.prototype.push=function(e){var o=this.getLength();return this.insertAt(o,e),this.getLength()},ol.Collection.prototype.remove=function(e){var o,t,r=this.array_;for(o=0,t=r.length;o<t;++o)if(r[o]===e)return this.removeAt(o)},ol.Collection.prototype.removeAt=function(e){var o=this.array_[e];return this.array_.splice(e,1),this.updateLength_(),this.dispatchEvent(new ol.Collection.Event(ol.Collection.EventType.REMOVE,o)),o},ol.Collection.prototype.setAt=function(e,o){var t=this.getLength();if(e<t){var r=this.array_[e];this.array_[e]=o,this.dispatchEvent(new ol.Collection.Event(ol.Collection.EventType.REMOVE,r)),this.dispatchEvent(new ol.Collection.Event(ol.Collection.EventType.ADD,o))}else{var i;for(i=t;i<e;++i)this.insertAt(i,void 0);this.insertAt(e,o)}},ol.Collection.prototype.updateLength_=function(){this.set(ol.Collection.Property.LENGTH,this.array_.length)},ol.Collection.Property={LENGTH:"length"},ol.Collection.EventType={ADD:"add",REMOVE:"remove"},ol.Collection.Event=function(e,o){ol.events.Event.call(this,e),this.element=o},ol.inherits(ol.Collection.Event,ol.events.Event),goog.provide("ol.color"),goog.require("ol.asserts"),goog.require("ol.math"),ol.color.HEX_COLOR_RE_=/^#(?:[0-9a-f]{3}){1,2}$/i,ol.color.NAMED_COLOR_RE_=/^([a-z]*)$/i,ol.color.asArray=function(e){return Array.isArray(e)?e:ol.color.fromString(e)},ol.color.asString=function(e){return"string"==typeof e?e:ol.color.toString(e)},ol.color.fromNamed=function(e){var o=document.createElement("div");o.style.color=e,document.body.appendChild(o);var t=getComputedStyle(o).color;return document.body.removeChild(o),t},ol.color.fromString=function(){var e={},o=0;return function(t){var r;if(e.hasOwnProperty(t))r=e[t];else{if(o>=1024){var i,n=0;for(i in e)0==(3&n++)&&(delete e[i],--o)}r=ol.color.fromStringInternal_(t),e[t]=r,++o}return r}}(),ol.color.fromStringInternal_=function(e){var o,t,r,i,n,l;if(ol.color.NAMED_COLOR_RE_.exec(e)&&(e=ol.color.fromNamed(e)),ol.color.HEX_COLOR_RE_.exec(e)){var a=e.length-1;ol.asserts.assert(3==a||6==a,54);var s=3==a?1:2;o=parseInt(e.substr(1+0*s,s),16),t=parseInt(e.substr(1+1*s,s),16),r=parseInt(e.substr(1+2*s,s),16),1==s&&(o=(o<<4)+o,t=(t<<4)+t,r=(r<<4)+r),i=1,n=[o,t,r,i]}else 0==e.indexOf("rgba(")?(l=e.slice(5,-1).split(",").map(Number),n=ol.color.normalize(l)):0==e.indexOf("rgb(")?(l=e.slice(4,-1).split(",").map(Number),l.push(1),n=ol.color.normalize(l)):ol.asserts.assert(!1,14);return n},ol.color.normalize=function(e,o){var t=o||[];return t[0]=ol.math.clamp(e[0]+.5|0,0,255),t[1]=ol.math.clamp(e[1]+.5|0,0,255),t[2]=ol.math.clamp(e[2]+.5|0,0,255),t[3]=ol.math.clamp(e[3],0,1),t},ol.color.toString=function(e){var o=e[0];o!=(0|o)&&(o=o+.5|0);var t=e[1];t!=(0|t)&&(t=t+.5|0);var r=e[2];return r!=(0|r)&&(r=r+.5|0),"rgba("+o+","+t+","+r+","+(void 0===e[3]?1:e[3])+")"},goog.provide("ol.colorlike"),goog.require("ol.color"),ol.colorlike.asColorLike=function(e){return ol.colorlike.isColorLike(e)?e:ol.color.asString(e)},ol.colorlike.isColorLike=function(e){return"string"==typeof e||e instanceof CanvasPattern||e instanceof CanvasGradient},goog.provide("ol.dom"),ol.dom.createCanvasContext2D=function(e,o){var t=document.createElement("CANVAS");return e&&(t.width=e),o&&(t.height=o),t.getContext("2d")},ol.dom.outerWidth=function(e){var o=e.offsetWidth,t=e.currentStyle||getComputedStyle(e);return o+=parseInt(t.marginLeft,10)+parseInt(t.marginRight,10)},ol.dom.outerHeight=function(e){var o=e.offsetHeight,t=e.currentStyle||getComputedStyle(e);return o+=parseInt(t.marginTop,10)+parseInt(t.marginBottom,10)},ol.dom.replaceNode=function(e,o){var t=o.parentNode;t&&t.replaceChild(e,o)},ol.dom.removeNode=function(e){return e&&e.parentNode?e.parentNode.removeChild(e):null},ol.dom.removeChildren=function(e){for(;e.lastChild;)e.removeChild(e.lastChild)},goog.provide("ol.MapEvent"),goog.require("ol"),goog.require("ol.events.Event"),ol.MapEvent=function(e,o,t){ol.events.Event.call(this,e),this.map=o,this.frameState=void 0!==t?t:null},ol.inherits(ol.MapEvent,ol.events.Event),ol.MapEvent.Type={POSTRENDER:"postrender",MOVEEND:"moveend"},goog.provide("ol.control.Control"),goog.require("ol.events"),goog.require("ol"),goog.require("ol.MapEvent"),goog.require("ol.Object"),goog.require("ol.dom"),ol.control.Control=function(e){ol.Object.call(this),this.element=e.element?e.element:null,this.target_=null,this.map_=null,this.listenerKeys=[],this.render=e.render?e.render:ol.nullFunction,e.target&&this.setTarget(e.target)},ol.inherits(ol.control.Control,ol.Object),ol.control.Control.prototype.disposeInternal=function(){ol.dom.removeNode(this.element),ol.Object.prototype.disposeInternal.call(this)},ol.control.Control.prototype.getMap=function(){return this.map_},ol.control.Control.prototype.setMap=function(e){this.map_&&ol.dom.removeNode(this.element);for(var o=0,t=this.listenerKeys.length;o<t;++o)ol.events.unlistenByKey(this.listenerKeys[o]);if(this.listenerKeys.length=0,this.map_=e,this.map_){(this.target_?this.target_:e.getOverlayContainerStopEvent()).appendChild(this.element),this.render!==ol.nullFunction&&this.listenerKeys.push(ol.events.listen(e,ol.MapEvent.Type.POSTRENDER,this.render,this)),e.render()}},ol.control.Control.prototype.setTarget=function(e){this.target_="string"==typeof e?document.getElementById(e):e},goog.provide("ol.css"),ol.css.CLASS_HIDDEN="ol-hidden",ol.css.CLASS_UNSELECTABLE="ol-unselectable",ol.css.CLASS_UNSUPPORTED="ol-unsupported",ol.css.CLASS_CONTROL="ol-control",goog.provide("ol.control.Attribution"),goog.require("ol"),goog.require("ol.dom"),goog.require("ol.control.Control"),goog.require("ol.css"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.obj"),ol.control.Attribution=function(e){var o=e||{};this.ulElement_=document.createElement("UL"),this.logoLi_=document.createElement("LI"),this.ulElement_.appendChild(this.logoLi_),this.logoLi_.style.display="none",this.collapsed_=void 0===o.collapsed||o.collapsed,this.collapsible_=void 0===o.collapsible||o.collapsible,this.collapsible_||(this.collapsed_=!1);var t=void 0!==o.className?o.className:"ol-attribution",r=void 0!==o.tipLabel?o.tipLabel:"Attributions",i=void 0!==o.collapseLabel?o.collapseLabel:"»";"string"==typeof i?(this.collapseLabel_=document.createElement("span"),this.collapseLabel_.textContent=i):this.collapseLabel_=i;var n=void 0!==o.label?o.label:"i";"string"==typeof n?(this.label_=document.createElement("span"),this.label_.textContent=n):this.label_=n;var l=this.collapsible_&&!this.collapsed_?this.collapseLabel_:this.label_,a=document.createElement("button");a.setAttribute("type","button"),a.title=r,a.appendChild(l),ol.events.listen(a,ol.events.EventType.CLICK,this.handleClick_,this);var s=t+" "+ol.css.CLASS_UNSELECTABLE+" "+ol.css.CLASS_CONTROL+(this.collapsed_&&this.collapsible_?" ol-collapsed":"")+(this.collapsible_?"":" ol-uncollapsible"),p=document.createElement("div");p.className=s,p.appendChild(this.ulElement_),p.appendChild(a);var g=o.render?o.render:ol.control.Attribution.render;ol.control.Control.call(this,{element:p,render:g,target:o.target}),this.renderedVisible_=!0,this.attributionElements_={},this.attributionElementRenderedVisible_={},this.logoElements_={}},ol.inherits(ol.control.Attribution,ol.control.Control),ol.control.Attribution.prototype.getSourceAttributions=function(e){var o,t,r,i,n,l,a,s,p,g,c,u=e.layerStatesArray,y=ol.obj.assign({},e.attributions),d={},h={},m=e.viewState.projection;for(o=0,t=u.length;o<t;o++)if((l=u[o].layer.getSource())&&(g=ol.getUid(l).toString(),p=l.getAttributions()))for(r=0,i=p.length;r<i;r++)if(a=p[r],!((s=ol.getUid(a).toString())in y)){if(n=e.usedTiles[g]){var f=l.getTileGridForProjection(m);c=a.intersectsAnyTileRange(n,f,m)}else c=!1;if(c){s in d&&delete d[s];var _=a.getHTML();_ in h||(h[_]=!0,y[s]=a)}else d[s]=a}return[y,d]},ol.control.Attribution.render=function(e){this.updateElement_(e.frameState)},ol.control.Attribution.prototype.updateElement_=function(e){if(!e)return void(this.renderedVisible_&&(this.element.style.display="none",this.renderedVisible_=!1));var o,t,r=this.getSourceAttributions(e),i=r[0],n=r[1];for(t in this.attributionElements_)t in i?(this.attributionElementRenderedVisible_[t]||(this.attributionElements_[t].style.display="",this.attributionElementRenderedVisible_[t]=!0),delete i[t]):t in n?(this.attributionElementRenderedVisible_[t]&&(this.attributionElements_[t].style.display="none",delete this.attributionElementRenderedVisible_[t]),delete n[t]):(ol.dom.removeNode(this.attributionElements_[t]),delete this.attributionElements_[t],delete this.attributionElementRenderedVisible_[t]);for(t in i)o=document.createElement("LI"),o.innerHTML=i[t].getHTML(),this.ulElement_.appendChild(o),this.attributionElements_[t]=o,this.attributionElementRenderedVisible_[t]=!0;for(t in n)o=document.createElement("LI"),o.innerHTML=n[t].getHTML(),o.style.display="none",this.ulElement_.appendChild(o),this.attributionElements_[t]=o;var l=!ol.obj.isEmpty(this.attributionElementRenderedVisible_)||!ol.obj.isEmpty(e.logos);this.renderedVisible_!=l&&(this.element.style.display=l?"":"none",this.renderedVisible_=l),l&&ol.obj.isEmpty(this.attributionElementRenderedVisible_)?this.element.classList.add("ol-logo-only"):this.element.classList.remove("ol-logo-only"),this.insertLogos_(e)},ol.control.Attribution.prototype.insertLogos_=function(e){var o,t=e.logos,r=this.logoElements_;for(o in r)o in t||(ol.dom.removeNode(r[o]),delete r[o]);var i,n,l;for(l in t){var a=t[l];a instanceof HTMLElement&&(this.logoLi_.appendChild(a),r[l]=a),l in r||(i=new Image,i.src=l,""===a?n=i:(n=document.createElement("a"),n.href=a,n.appendChild(i)),this.logoLi_.appendChild(n),r[l]=n)}this.logoLi_.style.display=ol.obj.isEmpty(t)?"none":""},ol.control.Attribution.prototype.handleClick_=function(e){e.preventDefault(),this.handleToggle_()},ol.control.Attribution.prototype.handleToggle_=function(){this.element.classList.toggle("ol-collapsed"),this.collapsed_?ol.dom.replaceNode(this.collapseLabel_,this.label_):ol.dom.replaceNode(this.label_,this.collapseLabel_),this.collapsed_=!this.collapsed_},ol.control.Attribution.prototype.getCollapsible=function(){return this.collapsible_},ol.control.Attribution.prototype.setCollapsible=function(e){this.collapsible_!==e&&(this.collapsible_=e,this.element.classList.toggle("ol-uncollapsible"),!e&&this.collapsed_&&this.handleToggle_())},ol.control.Attribution.prototype.setCollapsed=function(e){this.collapsible_&&this.collapsed_!==e&&this.handleToggle_()},ol.control.Attribution.prototype.getCollapsed=function(){return this.collapsed_},goog.provide("ol.control.FullScreen"),goog.require("ol"),goog.require("ol.control.Control"),goog.require("ol.css"),goog.require("ol.dom"),goog.require("ol.events"),goog.require("ol.events.EventType"),ol.control.FullScreen=function(e){var o=e||{};this.cssClassName_=void 0!==o.className?o.className:"ol-full-screen";var t=void 0!==o.label?o.label:"⤢";this.labelNode_="string"==typeof t?document.createTextNode(t):t;var r=void 0!==o.labelActive?o.labelActive:"×";this.labelActiveNode_="string"==typeof r?document.createTextNode(r):r;var i=o.tipLabel?o.tipLabel:"Toggle full-screen",n=document.createElement("button");n.className=this.cssClassName_+"-"+ol.control.FullScreen.isFullScreen(),n.setAttribute("type","button"),n.title=i,n.appendChild(this.labelNode_),ol.events.listen(n,ol.events.EventType.CLICK,this.handleClick_,this);var l=this.cssClassName_+" "+ol.css.CLASS_UNSELECTABLE+" "+ol.css.CLASS_CONTROL+" "+(ol.control.FullScreen.isFullScreenSupported()?"":ol.css.CLASS_UNSUPPORTED),a=document.createElement("div");a.className=l,a.appendChild(n),ol.control.Control.call(this,{element:a,target:o.target}),this.keys_=void 0!==o.keys&&o.keys,this.source_=o.source},ol.inherits(ol.control.FullScreen,ol.control.Control),ol.control.FullScreen.prototype.handleClick_=function(e){e.preventDefault(),this.handleFullScreen_()},ol.control.FullScreen.prototype.handleFullScreen_=function(){if(ol.control.FullScreen.isFullScreenSupported()){var e=this.getMap();if(e)if(ol.control.FullScreen.isFullScreen())ol.control.FullScreen.exitFullScreen();else{var o;o=this.source_?"string"==typeof this.source_?document.getElementById(this.source_):this.source_:e.getTargetElement(),this.keys_?ol.control.FullScreen.requestFullScreenWithKeys(o):ol.control.FullScreen.requestFullScreen(o)}}},ol.control.FullScreen.prototype.handleFullScreenChange_=function(){var e=this.element.firstElementChild,o=this.getMap();ol.control.FullScreen.isFullScreen()?(e.className=this.cssClassName_+"-true",ol.dom.replaceNode(this.labelActiveNode_,this.labelNode_)):(e.className=this.cssClassName_+"-false",ol.dom.replaceNode(this.labelNode_,this.labelActiveNode_)),o&&o.updateSize()},ol.control.FullScreen.prototype.setMap=function(e){ol.control.Control.prototype.setMap.call(this,e),e&&this.listenerKeys.push(ol.events.listen(document,ol.control.FullScreen.getChangeType_(),this.handleFullScreenChange_,this))},ol.control.FullScreen.isFullScreenSupported=function(){var e=document.body;return!!(e.webkitRequestFullscreen||e.mozRequestFullScreen&&document.mozFullScreenEnabled||e.msRequestFullscreen&&document.msFullscreenEnabled||e.requestFullscreen&&document.fullscreenEnabled)},ol.control.FullScreen.isFullScreen=function(){return!!(document.webkitIsFullScreen||document.mozFullScreen||document.msFullscreenElement||document.fullscreenElement)},ol.control.FullScreen.requestFullScreen=function(e){e.requestFullscreen?e.requestFullscreen():e.msRequestFullscreen?e.msRequestFullscreen():e.mozRequestFullScreen?e.mozRequestFullScreen():e.webkitRequestFullscreen&&e.webkitRequestFullscreen()},ol.control.FullScreen.requestFullScreenWithKeys=function(e){e.mozRequestFullScreenWithKeys?e.mozRequestFullScreenWithKeys():e.webkitRequestFullscreen?e.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT):ol.control.FullScreen.requestFullScreen(e)},ol.control.FullScreen.exitFullScreen=function(){document.exitFullscreen?document.exitFullscreen():document.msExitFullscreen?document.msExitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitExitFullscreen&&document.webkitExitFullscreen()},ol.control.FullScreen.getChangeType_=function(){var e;return function(){if(!e){var o=document.body;o.webkitRequestFullscreen?e="webkitfullscreenchange":o.mozRequestFullScreen?e="mozfullscreenchange":o.msRequestFullscreen?e="MSFullscreenChange":o.requestFullscreen&&(e="fullscreenchange")}return e}}(),goog.provide("ol.control.Rotate"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol"),goog.require("ol.control.Control"),goog.require("ol.css"),goog.require("ol.easing"),ol.control.Rotate=function(e){var o=e||{},t=void 0!==o.className?o.className:"ol-rotate",r=void 0!==o.label?o.label:"⇧";this.label_=null,"string"==typeof r?(this.label_=document.createElement("span"),this.label_.className="ol-compass",this.label_.textContent=r):(this.label_=r,this.label_.classList.add("ol-compass"));var i=o.tipLabel?o.tipLabel:"Reset rotation",n=document.createElement("button");n.className=t+"-reset",n.setAttribute("type","button"),n.title=i,n.appendChild(this.label_),ol.events.listen(n,ol.events.EventType.CLICK,ol.control.Rotate.prototype.handleClick_,this);var l=t+" "+ol.css.CLASS_UNSELECTABLE+" "+ol.css.CLASS_CONTROL,a=document.createElement("div");a.className=l,a.appendChild(n);var s=o.render?o.render:ol.control.Rotate.render;this.callResetNorth_=o.resetNorth?o.resetNorth:void 0,ol.control.Control.call(this,{element:a,render:s,target:o.target}),this.duration_=void 0!==o.duration?o.duration:250,this.autoHide_=void 0===o.autoHide||o.autoHide,this.rotation_=void 0,this.autoHide_&&this.element.classList.add(ol.css.CLASS_HIDDEN)},ol.inherits(ol.control.Rotate,ol.control.Control),ol.control.Rotate.prototype.handleClick_=function(e){e.preventDefault(),void 0!==this.callResetNorth_?this.callResetNorth_():this.resetNorth_()},ol.control.Rotate.prototype.resetNorth_=function(){var e=this.getMap(),o=e.getView();if(o){var t=o.getRotation();void 0!==t&&(this.duration_>0?(t%=2*Math.PI,t<-Math.PI&&(t+=2*Math.PI),t>Math.PI&&(t-=2*Math.PI),o.animate({rotation:0,duration:this.duration_,easing:ol.easing.easeOut})):o.setRotation(0))}},ol.control.Rotate.render=function(e){var o=e.frameState;if(o){var t=o.viewState.rotation;if(t!=this.rotation_){var r="rotate("+t+"rad)";if(this.autoHide_){var i=this.element.classList.contains(ol.css.CLASS_HIDDEN);i||0!==t?i&&0!==t&&this.element.classList.remove(ol.css.CLASS_HIDDEN):this.element.classList.add(ol.css.CLASS_HIDDEN)}this.label_.style.msTransform=r,this.label_.style.webkitTransform=r,this.label_.style.transform=r}this.rotation_=t}},goog.provide("ol.control.Zoom"),goog.require("ol"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.control.Control"),goog.require("ol.css"),goog.require("ol.easing"),ol.control.Zoom=function(e){var o=e||{},t=void 0!==o.className?o.className:"ol-zoom",r=void 0!==o.delta?o.delta:1,i=void 0!==o.zoomInLabel?o.zoomInLabel:"+",n=void 0!==o.zoomOutLabel?o.zoomOutLabel:"−",l=void 0!==o.zoomInTipLabel?o.zoomInTipLabel:"Zoom in",a=void 0!==o.zoomOutTipLabel?o.zoomOutTipLabel:"Zoom out",s=document.createElement("button");s.className=t+"-in",s.setAttribute("type","button"),s.title=l,s.appendChild("string"==typeof i?document.createTextNode(i):i),ol.events.listen(s,ol.events.EventType.CLICK,ol.control.Zoom.prototype.handleClick_.bind(this,r));var p=document.createElement("button");p.className=t+"-out",p.setAttribute("type","button"),p.title=a,p.appendChild("string"==typeof n?document.createTextNode(n):n),ol.events.listen(p,ol.events.EventType.CLICK,ol.control.Zoom.prototype.handleClick_.bind(this,-r));var g=t+" "+ol.css.CLASS_UNSELECTABLE+" "+ol.css.CLASS_CONTROL,c=document.createElement("div");c.className=g,c.appendChild(s),c.appendChild(p),ol.control.Control.call(this,{element:c,target:o.target}),this.duration_=void 0!==o.duration?o.duration:250},ol.inherits(ol.control.Zoom,ol.control.Control),ol.control.Zoom.prototype.handleClick_=function(e,o){o.preventDefault(),this.zoomByDelta_(e)},ol.control.Zoom.prototype.zoomByDelta_=function(e){var o=this.getMap(),t=o.getView();if(t){var r=t.getResolution();if(r){var i=t.constrainResolution(r,e);this.duration_>0?(t.getAnimating()&&t.cancelAnimations(),t.animate({resolution:i,duration:this.duration_,easing:ol.easing.easeOut})):t.setResolution(i)}}},goog.provide("ol.control"),goog.require("ol"),goog.require("ol.Collection"),goog.require("ol.control.Attribution"),goog.require("ol.control.Rotate"),goog.require("ol.control.Zoom"),ol.control.defaults=function(e){var o=e||{},t=new ol.Collection;return(void 0===o.zoom||o.zoom)&&t.push(new ol.control.Zoom(o.zoomOptions)),(void 0===o.rotate||o.rotate)&&t.push(new ol.control.Rotate(o.rotateOptions)),(void 0===o.attribution||o.attribution)&&t.push(new ol.control.Attribution(o.attributionOptions)),t},goog.provide("ol.control.MousePosition"),goog.require("ol"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.Object"),goog.require("ol.control.Control"),goog.require("ol.proj"),ol.control.MousePosition=function(e){var o=e||{},t=document.createElement("DIV");t.className=void 0!==o.className?o.className:"ol-mouse-position";var r=o.render?o.render:ol.control.MousePosition.render;ol.control.Control.call(this,{element:t,render:r,target:o.target}),ol.events.listen(this,ol.Object.getChangeEventType(ol.control.MousePosition.Property.PROJECTION),this.handleProjectionChanged_,this),o.coordinateFormat&&this.setCoordinateFormat(o.coordinateFormat),o.projection&&this.setProjection(ol.proj.get(o.projection)),this.undefinedHTML_=void 0!==o.undefinedHTML?o.undefinedHTML:"",this.renderedHTML_=t.innerHTML,this.mapProjection_=null,this.transform_=null,this.lastMouseMovePixel_=null},ol.inherits(ol.control.MousePosition,ol.control.Control),ol.control.MousePosition.render=function(e){var o=e.frameState;o?this.mapProjection_!=o.viewState.projection&&(this.mapProjection_=o.viewState.projection,this.transform_=null):this.mapProjection_=null,this.updateHTML_(this.lastMouseMovePixel_)},ol.control.MousePosition.prototype.handleProjectionChanged_=function(){this.transform_=null},ol.control.MousePosition.prototype.getCoordinateFormat=function(){return this.get(ol.control.MousePosition.Property.COORDINATE_FORMAT)},ol.control.MousePosition.prototype.getProjection=function(){return this.get(ol.control.MousePosition.Property.PROJECTION)},ol.control.MousePosition.prototype.handleMouseMove=function(e){var o=this.getMap();this.lastMouseMovePixel_=o.getEventPixel(e),this.updateHTML_(this.lastMouseMovePixel_)},ol.control.MousePosition.prototype.handleMouseOut=function(e){this.updateHTML_(null),this.lastMouseMovePixel_=null},ol.control.MousePosition.prototype.setMap=function(e){if(ol.control.Control.prototype.setMap.call(this,e),e){var o=e.getViewport()
;this.listenerKeys.push(ol.events.listen(o,ol.events.EventType.MOUSEMOVE,this.handleMouseMove,this),ol.events.listen(o,ol.events.EventType.MOUSEOUT,this.handleMouseOut,this))}},ol.control.MousePosition.prototype.setCoordinateFormat=function(e){this.set(ol.control.MousePosition.Property.COORDINATE_FORMAT,e)},ol.control.MousePosition.prototype.setProjection=function(e){this.set(ol.control.MousePosition.Property.PROJECTION,e)},ol.control.MousePosition.prototype.updateHTML_=function(e){var o=this.undefinedHTML_;if(e&&this.mapProjection_){if(!this.transform_){var t=this.getProjection();this.transform_=t?ol.proj.getTransformFromProjections(this.mapProjection_,t):ol.proj.identityTransform}var r=this.getMap(),i=r.getCoordinateFromPixel(e);if(i){this.transform_(i,i);var n=this.getCoordinateFormat();o=n?n(i):i.toString()}}this.renderedHTML_&&o==this.renderedHTML_||(this.element.innerHTML=o,this.renderedHTML_=o)},ol.control.MousePosition.Property={PROJECTION:"projection",COORDINATE_FORMAT:"coordinateFormat"},goog.provide("ol.MapBrowserEvent"),goog.require("ol"),goog.require("ol.MapEvent"),goog.require("ol.events.EventType"),ol.MapBrowserEvent=function(e,o,t,r,i){ol.MapEvent.call(this,e,o,i),this.originalEvent=t,this.pixel=o.getEventPixel(t),this.coordinate=o.getCoordinateFromPixel(this.pixel),this.dragging=void 0!==r&&r},ol.inherits(ol.MapBrowserEvent,ol.MapEvent),ol.MapBrowserEvent.prototype.preventDefault=function(){ol.MapEvent.prototype.preventDefault.call(this),this.originalEvent.preventDefault()},ol.MapBrowserEvent.prototype.stopPropagation=function(){ol.MapEvent.prototype.stopPropagation.call(this),this.originalEvent.stopPropagation()},ol.MapBrowserEvent.EventType={SINGLECLICK:"singleclick",CLICK:ol.events.EventType.CLICK,DBLCLICK:ol.events.EventType.DBLCLICK,POINTERDRAG:"pointerdrag",POINTERMOVE:"pointermove",POINTERDOWN:"pointerdown",POINTERUP:"pointerup",POINTEROVER:"pointerover",POINTEROUT:"pointerout",POINTERENTER:"pointerenter",POINTERLEAVE:"pointerleave",POINTERCANCEL:"pointercancel"},goog.provide("ol.MapBrowserPointerEvent"),goog.require("ol"),goog.require("ol.MapBrowserEvent"),ol.MapBrowserPointerEvent=function(e,o,t,r,i){ol.MapBrowserEvent.call(this,e,o,t.originalEvent,r,i),this.pointerEvent=t},ol.inherits(ol.MapBrowserPointerEvent,ol.MapBrowserEvent),goog.provide("ol.pointer.EventType"),ol.pointer.EventType={POINTERMOVE:"pointermove",POINTERDOWN:"pointerdown",POINTERUP:"pointerup",POINTEROVER:"pointerover",POINTEROUT:"pointerout",POINTERENTER:"pointerenter",POINTERLEAVE:"pointerleave",POINTERCANCEL:"pointercancel"},goog.provide("ol.webgl"),ol.webgl.ONE=1,ol.webgl.SRC_ALPHA=770,ol.webgl.COLOR_ATTACHMENT0=36064,ol.webgl.COLOR_BUFFER_BIT=16384,ol.webgl.TRIANGLES=4,ol.webgl.TRIANGLE_STRIP=5,ol.webgl.ONE_MINUS_SRC_ALPHA=771,ol.webgl.ARRAY_BUFFER=34962,ol.webgl.ELEMENT_ARRAY_BUFFER=34963,ol.webgl.STREAM_DRAW=35040,ol.webgl.STATIC_DRAW=35044,ol.webgl.DYNAMIC_DRAW=35048,ol.webgl.CULL_FACE=2884,ol.webgl.BLEND=3042,ol.webgl.STENCIL_TEST=2960,ol.webgl.DEPTH_TEST=2929,ol.webgl.SCISSOR_TEST=3089,ol.webgl.UNSIGNED_BYTE=5121,ol.webgl.UNSIGNED_SHORT=5123,ol.webgl.UNSIGNED_INT=5125,ol.webgl.FLOAT=5126,ol.webgl.RGBA=6408,ol.webgl.FRAGMENT_SHADER=35632,ol.webgl.VERTEX_SHADER=35633,ol.webgl.LINK_STATUS=35714,ol.webgl.LINEAR=9729,ol.webgl.TEXTURE_MAG_FILTER=10240,ol.webgl.TEXTURE_MIN_FILTER=10241,ol.webgl.TEXTURE_WRAP_S=10242,ol.webgl.TEXTURE_WRAP_T=10243,ol.webgl.TEXTURE_2D=3553,ol.webgl.TEXTURE0=33984;ol.webgl.CLAMP_TO_EDGE=33071,ol.webgl.COMPILE_STATUS=35713,ol.webgl.FRAMEBUFFER=36160,ol.webgl.CONTEXT_IDS_=["experimental-webgl","webgl","webkit-3d","moz-webgl"],ol.webgl.getContext=function(e,o){var t,r,i=ol.webgl.CONTEXT_IDS_.length;for(r=0;r<i;++r)try{if(t=e.getContext(ol.webgl.CONTEXT_IDS_[r],o))return t}catch(e){}return null},goog.provide("ol.has"),goog.require("ol"),goog.require("ol.webgl");var ua="undefined"!=typeof navigator?navigator.userAgent.toLowerCase():"";ol.has.FIREFOX=-1!==ua.indexOf("firefox"),ol.has.SAFARI=-1!==ua.indexOf("safari")&&-1==ua.indexOf("chrom"),ol.has.WEBKIT=-1!==ua.indexOf("webkit")&&-1==ua.indexOf("edge"),ol.has.MAC=-1!==ua.indexOf("macintosh"),ol.has.DEVICE_PIXEL_RATIO=window.devicePixelRatio||1,ol.has.CANVAS_LINE_DASH=!1,ol.has.CANVAS=ol.ENABLE_CANVAS&&function(){if(!("HTMLCanvasElement"in window))return!1;try{var e=document.createElement("CANVAS").getContext("2d");return!!e&&(void 0!==e.setLineDash&&(ol.has.CANVAS_LINE_DASH=!0),!0)}catch(e){return!1}}(),ol.has.DEVICE_ORIENTATION="DeviceOrientationEvent"in window,ol.has.GEOLOCATION="geolocation"in navigator,ol.has.TOUCH=ol.ASSUME_TOUCH||"ontouchstart"in window,ol.has.POINTER="PointerEvent"in window,ol.has.MSPOINTER=!!navigator.msPointerEnabled,ol.has.WEBGL,function(){if(ol.ENABLE_WEBGL){var e,o=!1,t=[];if("WebGLRenderingContext"in window)try{var r=document.createElement("CANVAS"),i=ol.webgl.getContext(r,{failIfMajorPerformanceCaveat:!0});i&&(o=!0,e=i.getParameter(i.MAX_TEXTURE_SIZE),t=i.getSupportedExtensions())}catch(e){}ol.has.WEBGL=o,ol.WEBGL_EXTENSIONS=t,ol.WEBGL_MAX_TEXTURE_SIZE=e}}(),goog.provide("ol.pointer.EventSource"),ol.pointer.EventSource=function(e,o){this.dispatcher=e,this.mapping_=o},ol.pointer.EventSource.prototype.getEvents=function(){return Object.keys(this.mapping_)},ol.pointer.EventSource.prototype.getMapping=function(){return this.mapping_},ol.pointer.EventSource.prototype.getHandlerForEvent=function(e){return this.mapping_[e]},goog.provide("ol.pointer.MouseSource"),goog.require("ol"),goog.require("ol.pointer.EventSource"),ol.pointer.MouseSource=function(e){var o={mousedown:this.mousedown,mousemove:this.mousemove,mouseup:this.mouseup,mouseover:this.mouseover,mouseout:this.mouseout};ol.pointer.EventSource.call(this,e,o),this.pointerMap=e.pointerMap,this.lastTouches=[]},ol.inherits(ol.pointer.MouseSource,ol.pointer.EventSource),ol.pointer.MouseSource.POINTER_ID=1,ol.pointer.MouseSource.POINTER_TYPE="mouse",ol.pointer.MouseSource.DEDUP_DIST=25,ol.pointer.MouseSource.prototype.isEventSimulatedFromTouch_=function(e){for(var o,t=this.lastTouches,r=e.clientX,i=e.clientY,n=0,l=t.length;n<l&&(o=t[n]);n++){var a=Math.abs(r-o[0]),s=Math.abs(i-o[1]);if(a<=ol.pointer.MouseSource.DEDUP_DIST&&s<=ol.pointer.MouseSource.DEDUP_DIST)return!0}return!1},ol.pointer.MouseSource.prepareEvent=function(e,o){var t=o.cloneEvent(e,e),r=t.preventDefault;return t.preventDefault=function(){e.preventDefault(),r()},t.pointerId=ol.pointer.MouseSource.POINTER_ID,t.isPrimary=!0,t.pointerType=ol.pointer.MouseSource.POINTER_TYPE,t},ol.pointer.MouseSource.prototype.mousedown=function(e){if(!this.isEventSimulatedFromTouch_(e)){ol.pointer.MouseSource.POINTER_ID.toString()in this.pointerMap&&this.cancel(e);var o=ol.pointer.MouseSource.prepareEvent(e,this.dispatcher);this.pointerMap[ol.pointer.MouseSource.POINTER_ID.toString()]=e,this.dispatcher.down(o,e)}},ol.pointer.MouseSource.prototype.mousemove=function(e){if(!this.isEventSimulatedFromTouch_(e)){var o=ol.pointer.MouseSource.prepareEvent(e,this.dispatcher);this.dispatcher.move(o,e)}},ol.pointer.MouseSource.prototype.mouseup=function(e){if(!this.isEventSimulatedFromTouch_(e)){var o=this.pointerMap[ol.pointer.MouseSource.POINTER_ID.toString()];if(o&&o.button===e.button){var t=ol.pointer.MouseSource.prepareEvent(e,this.dispatcher);this.dispatcher.up(t,e),this.cleanupMouse()}}},ol.pointer.MouseSource.prototype.mouseover=function(e){if(!this.isEventSimulatedFromTouch_(e)){var o=ol.pointer.MouseSource.prepareEvent(e,this.dispatcher);this.dispatcher.enterOver(o,e)}},ol.pointer.MouseSource.prototype.mouseout=function(e){if(!this.isEventSimulatedFromTouch_(e)){var o=ol.pointer.MouseSource.prepareEvent(e,this.dispatcher);this.dispatcher.leaveOut(o,e)}},ol.pointer.MouseSource.prototype.cancel=function(e){var o=ol.pointer.MouseSource.prepareEvent(e,this.dispatcher);this.dispatcher.cancel(o,e),this.cleanupMouse()},ol.pointer.MouseSource.prototype.cleanupMouse=function(){delete this.pointerMap[ol.pointer.MouseSource.POINTER_ID.toString()]},goog.provide("ol.pointer.MsSource"),goog.require("ol"),goog.require("ol.pointer.EventSource"),ol.pointer.MsSource=function(e){var o={MSPointerDown:this.msPointerDown,MSPointerMove:this.msPointerMove,MSPointerUp:this.msPointerUp,MSPointerOut:this.msPointerOut,MSPointerOver:this.msPointerOver,MSPointerCancel:this.msPointerCancel,MSGotPointerCapture:this.msGotPointerCapture,MSLostPointerCapture:this.msLostPointerCapture};ol.pointer.EventSource.call(this,e,o),this.pointerMap=e.pointerMap,this.POINTER_TYPES=["","unavailable","touch","pen","mouse"]},ol.inherits(ol.pointer.MsSource,ol.pointer.EventSource),ol.pointer.MsSource.prototype.prepareEvent_=function(e){var o=e;return"number"==typeof e.pointerType&&(o=this.dispatcher.cloneEvent(e,e),o.pointerType=this.POINTER_TYPES[e.pointerType]),o},ol.pointer.MsSource.prototype.cleanup=function(e){delete this.pointerMap[e.toString()]},ol.pointer.MsSource.prototype.msPointerDown=function(e){this.pointerMap[e.pointerId.toString()]=e;var o=this.prepareEvent_(e);this.dispatcher.down(o,e)},ol.pointer.MsSource.prototype.msPointerMove=function(e){var o=this.prepareEvent_(e);this.dispatcher.move(o,e)},ol.pointer.MsSource.prototype.msPointerUp=function(e){var o=this.prepareEvent_(e);this.dispatcher.up(o,e),this.cleanup(e.pointerId)},ol.pointer.MsSource.prototype.msPointerOut=function(e){var o=this.prepareEvent_(e);this.dispatcher.leaveOut(o,e)},ol.pointer.MsSource.prototype.msPointerOver=function(e){var o=this.prepareEvent_(e);this.dispatcher.enterOver(o,e)},ol.pointer.MsSource.prototype.msPointerCancel=function(e){var o=this.prepareEvent_(e);this.dispatcher.cancel(o,e),this.cleanup(e.pointerId)},ol.pointer.MsSource.prototype.msLostPointerCapture=function(e){var o=this.dispatcher.makeEvent("lostpointercapture",e,e);this.dispatcher.dispatchEvent(o)},ol.pointer.MsSource.prototype.msGotPointerCapture=function(e){var o=this.dispatcher.makeEvent("gotpointercapture",e,e);this.dispatcher.dispatchEvent(o)},goog.provide("ol.pointer.NativeSource"),goog.require("ol"),goog.require("ol.pointer.EventSource"),ol.pointer.NativeSource=function(e){var o={pointerdown:this.pointerDown,pointermove:this.pointerMove,pointerup:this.pointerUp,pointerout:this.pointerOut,pointerover:this.pointerOver,pointercancel:this.pointerCancel,gotpointercapture:this.gotPointerCapture,lostpointercapture:this.lostPointerCapture};ol.pointer.EventSource.call(this,e,o)},ol.inherits(ol.pointer.NativeSource,ol.pointer.EventSource),ol.pointer.NativeSource.prototype.pointerDown=function(e){this.dispatcher.fireNativeEvent(e)},ol.pointer.NativeSource.prototype.pointerMove=function(e){this.dispatcher.fireNativeEvent(e)},ol.pointer.NativeSource.prototype.pointerUp=function(e){this.dispatcher.fireNativeEvent(e)},ol.pointer.NativeSource.prototype.pointerOut=function(e){this.dispatcher.fireNativeEvent(e)},ol.pointer.NativeSource.prototype.pointerOver=function(e){this.dispatcher.fireNativeEvent(e)},ol.pointer.NativeSource.prototype.pointerCancel=function(e){this.dispatcher.fireNativeEvent(e)},ol.pointer.NativeSource.prototype.lostPointerCapture=function(e){this.dispatcher.fireNativeEvent(e)},ol.pointer.NativeSource.prototype.gotPointerCapture=function(e){this.dispatcher.fireNativeEvent(e)},goog.provide("ol.pointer.PointerEvent"),goog.require("ol"),goog.require("ol.events.Event"),ol.pointer.PointerEvent=function(e,o,t){ol.events.Event.call(this,e),this.originalEvent=o;var r=t||{};this.buttons=this.getButtons_(r),this.pressure=this.getPressure_(r,this.buttons),this.bubbles="bubbles"in r&&r.bubbles,this.cancelable="cancelable"in r&&r.cancelable,this.view="view"in r?r.view:null,this.detail="detail"in r?r.detail:null,this.screenX="screenX"in r?r.screenX:0,this.screenY="screenY"in r?r.screenY:0,this.clientX="clientX"in r?r.clientX:0,this.clientY="clientY"in r?r.clientY:0,this.ctrlKey="ctrlKey"in r&&r.ctrlKey,this.altKey="altKey"in r&&r.altKey,this.shiftKey="shiftKey"in r&&r.shiftKey,this.metaKey="metaKey"in r&&r.metaKey,this.button="button"in r?r.button:0,this.relatedTarget="relatedTarget"in r?r.relatedTarget:null,this.pointerId="pointerId"in r?r.pointerId:0,this.width="width"in r?r.width:0,this.height="height"in r?r.height:0,this.tiltX="tiltX"in r?r.tiltX:0,this.tiltY="tiltY"in r?r.tiltY:0,this.pointerType="pointerType"in r?r.pointerType:"",this.hwTimestamp="hwTimestamp"in r?r.hwTimestamp:0,this.isPrimary="isPrimary"in r&&r.isPrimary,o.preventDefault&&(this.preventDefault=function(){o.preventDefault()})},ol.inherits(ol.pointer.PointerEvent,ol.events.Event),ol.pointer.PointerEvent.prototype.getButtons_=function(e){var o;if(e.buttons||ol.pointer.PointerEvent.HAS_BUTTONS)o=e.buttons;else switch(e.which){case 1:o=1;break;case 2:o=4;break;case 3:o=2;break;default:o=0}return o},ol.pointer.PointerEvent.prototype.getPressure_=function(e,o){return e.pressure?e.pressure:o?.5:0},ol.pointer.PointerEvent.HAS_BUTTONS=!1,function(){try{var e=new MouseEvent("click",{buttons:1});ol.pointer.PointerEvent.HAS_BUTTONS=1===e.buttons}catch(e){}}(),goog.provide("ol.pointer.TouchSource"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.pointer.EventSource"),goog.require("ol.pointer.MouseSource"),ol.pointer.TouchSource=function(e,o){var t={touchstart:this.touchstart,touchmove:this.touchmove,touchend:this.touchend,touchcancel:this.touchcancel};ol.pointer.EventSource.call(this,e,t),this.pointerMap=e.pointerMap,this.mouseSource=o,this.firstTouchId_=void 0,this.clickCount_=0,this.resetId_=void 0},ol.inherits(ol.pointer.TouchSource,ol.pointer.EventSource),ol.pointer.TouchSource.DEDUP_TIMEOUT=2500,ol.pointer.TouchSource.CLICK_COUNT_TIMEOUT=200,ol.pointer.TouchSource.POINTER_TYPE="touch",ol.pointer.TouchSource.prototype.isPrimaryTouch_=function(e){return this.firstTouchId_===e.identifier},ol.pointer.TouchSource.prototype.setPrimaryTouch_=function(e){var o=Object.keys(this.pointerMap).length;(0===o||1===o&&ol.pointer.MouseSource.POINTER_ID.toString()in this.pointerMap)&&(this.firstTouchId_=e.identifier,this.cancelResetClickCount_())},ol.pointer.TouchSource.prototype.removePrimaryPointer_=function(e){e.isPrimary&&(this.firstTouchId_=void 0,this.resetClickCount_())},ol.pointer.TouchSource.prototype.resetClickCount_=function(){this.resetId_=setTimeout(this.resetClickCountHandler_.bind(this),ol.pointer.TouchSource.CLICK_COUNT_TIMEOUT)},ol.pointer.TouchSource.prototype.resetClickCountHandler_=function(){this.clickCount_=0,this.resetId_=void 0},ol.pointer.TouchSource.prototype.cancelResetClickCount_=function(){void 0!==this.resetId_&&clearTimeout(this.resetId_)},ol.pointer.TouchSource.prototype.touchToPointer_=function(e,o){var t=this.dispatcher.cloneEvent(e,o);return t.pointerId=o.identifier+2,t.bubbles=!0,t.cancelable=!0,t.detail=this.clickCount_,t.button=0,t.buttons=1,t.width=o.webkitRadiusX||o.radiusX||0,t.height=o.webkitRadiusY||o.radiusY||0,t.pressure=o.webkitForce||o.force||.5,t.isPrimary=this.isPrimaryTouch_(o),t.pointerType=ol.pointer.TouchSource.POINTER_TYPE,t.clientX=o.clientX,t.clientY=o.clientY,t.screenX=o.screenX,t.screenY=o.screenY,t},ol.pointer.TouchSource.prototype.processTouches_=function(e,o){function t(){e.preventDefault()}var r,i,n=Array.prototype.slice.call(e.changedTouches),l=n.length;for(r=0;r<l;++r)i=this.touchToPointer_(e,n[r]),i.preventDefault=t,o.call(this,e,i)},ol.pointer.TouchSource.prototype.findTouch_=function(e,o){for(var t,r=e.length,i=0;i<r;i++)if(t=e[i],t.identifier===o)return!0;return!1},ol.pointer.TouchSource.prototype.vacuumTouches_=function(e){var o=e.touches,t=Object.keys(this.pointerMap),r=t.length;if(r>=o.length){var i,n,l,a=[];for(i=0;i<r;++i)n=t[i],l=this.pointerMap[n],n==ol.pointer.MouseSource.POINTER_ID||this.findTouch_(o,n-2)||a.push(l.out);for(i=0;i<a.length;++i)this.cancelOut_(e,a[i])}},ol.pointer.TouchSource.prototype.touchstart=function(e){this.vacuumTouches_(e),this.setPrimaryTouch_(e.changedTouches[0]),this.dedupSynthMouse_(e),this.clickCount_++,this.processTouches_(e,this.overDown_)},ol.pointer.TouchSource.prototype.overDown_=function(e,o){this.pointerMap[o.pointerId]={target:o.target,out:o,outTarget:o.target},this.dispatcher.over(o,e),this.dispatcher.enter(o,e),this.dispatcher.down(o,e)},ol.pointer.TouchSource.prototype.touchmove=function(e){e.preventDefault(),this.processTouches_(e,this.moveOverOut_)},ol.pointer.TouchSource.prototype.moveOverOut_=function(e,o){var t=o,r=this.pointerMap[t.pointerId];if(r){var i=r.out,n=r.outTarget;this.dispatcher.move(t,e),i&&n!==t.target&&(i.relatedTarget=t.target,t.relatedTarget=n,i.target=n,t.target?(this.dispatcher.leaveOut(i,e),this.dispatcher.enterOver(t,e)):(t.target=n,t.relatedTarget=null,this.cancelOut_(e,t))),r.out=t,r.outTarget=t.target}},ol.pointer.TouchSource.prototype.touchend=function(e){this.dedupSynthMouse_(e),this.processTouches_(e,this.upOut_)},ol.pointer.TouchSource.prototype.upOut_=function(e,o){this.dispatcher.up(o,e),this.dispatcher.out(o,e),this.dispatcher.leave(o,e),this.cleanUpPointer_(o)},ol.pointer.TouchSource.prototype.touchcancel=function(e){this.processTouches_(e,this.cancelOut_)},ol.pointer.TouchSource.prototype.cancelOut_=function(e,o){this.dispatcher.cancel(o,e),this.dispatcher.out(o,e),this.dispatcher.leave(o,e),this.cleanUpPointer_(o)},ol.pointer.TouchSource.prototype.cleanUpPointer_=function(e){delete this.pointerMap[e.pointerId],this.removePrimaryPointer_(e)},ol.pointer.TouchSource.prototype.dedupSynthMouse_=function(e){var o=this.mouseSource.lastTouches,t=e.changedTouches[0];if(this.isPrimaryTouch_(t)){var r=[t.clientX,t.clientY];o.push(r),setTimeout(function(){ol.array.remove(o,r)},ol.pointer.TouchSource.DEDUP_TIMEOUT)}},goog.provide("ol.pointer.PointerEventHandler"),goog.require("ol"),goog.require("ol.events"),goog.require("ol.events.EventTarget"),goog.require("ol.has"),goog.require("ol.pointer.EventType"),goog.require("ol.pointer.MouseSource"),goog.require("ol.pointer.MsSource"),goog.require("ol.pointer.NativeSource"),goog.require("ol.pointer.PointerEvent"),goog.require("ol.pointer.TouchSource"),ol.pointer.PointerEventHandler=function(e){ol.events.EventTarget.call(this),this.element_=e,this.pointerMap={},this.eventMap_={},this.eventSourceList_=[],this.registerSources()},ol.inherits(ol.pointer.PointerEventHandler,ol.events.EventTarget),ol.pointer.PointerEventHandler.prototype.registerSources=function(){if(ol.has.POINTER)this.registerSource("native",new ol.pointer.NativeSource(this));else if(ol.has.MSPOINTER)this.registerSource("ms",new ol.pointer.MsSource(this));else{var e=new ol.pointer.MouseSource(this);this.registerSource("mouse",e),ol.has.TOUCH&&this.registerSource("touch",new ol.pointer.TouchSource(this,e))}this.register_()},ol.pointer.PointerEventHandler.prototype.registerSource=function(e,o){var t=o,r=t.getEvents();r&&(r.forEach(function(e){var o=t.getHandlerForEvent(e);o&&(this.eventMap_[e]=o.bind(t))},this),this.eventSourceList_.push(t))},ol.pointer.PointerEventHandler.prototype.register_=function(){for(var e,o=this.eventSourceList_.length,t=0;t<o;t++)e=this.eventSourceList_[t],this.addEvents_(e.getEvents())},ol.pointer.PointerEventHandler.prototype.unregister_=function(){for(var e,o=this.eventSourceList_.length,t=0;t<o;t++)e=this.eventSourceList_[t],this.removeEvents_(e.getEvents())},ol.pointer.PointerEventHandler.prototype.eventHandler_=function(e){var o=e.type,t=this.eventMap_[o];t&&t(e)},ol.pointer.PointerEventHandler.prototype.addEvents_=function(e){e.forEach(function(e){ol.events.listen(this.element_,e,this.eventHandler_,this)},this)},ol.pointer.PointerEventHandler.prototype.removeEvents_=function(e){e.forEach(function(e){ol.events.unlisten(this.element_,e,this.eventHandler_,this)},this)},ol.pointer.PointerEventHandler.prototype.cloneEvent=function(e,o){for(var t,r={},i=0,n=ol.pointer.PointerEventHandler.CLONE_PROPS.length;i<n;i++)t=ol.pointer.PointerEventHandler.CLONE_PROPS[i][0],r[t]=e[t]||o[t]||ol.pointer.PointerEventHandler.CLONE_PROPS[i][1];return r},ol.pointer.PointerEventHandler.prototype.down=function(e,o){this.fireEvent(ol.pointer.EventType.POINTERDOWN,e,o)},ol.pointer.PointerEventHandler.prototype.move=function(e,o){this.fireEvent(ol.pointer.EventType.POINTERMOVE,e,o)},ol.pointer.PointerEventHandler.prototype.up=function(e,o){this.fireEvent(ol.pointer.EventType.POINTERUP,e,o)},ol.pointer.PointerEventHandler.prototype.enter=function(e,o){e.bubbles=!1,this.fireEvent(ol.pointer.EventType.POINTERENTER,e,o)},ol.pointer.PointerEventHandler.prototype.leave=function(e,o){e.bubbles=!1,this.fireEvent(ol.pointer.EventType.POINTERLEAVE,e,o)},ol.pointer.PointerEventHandler.prototype.over=function(e,o){e.bubbles=!0,this.fireEvent(ol.pointer.EventType.POINTEROVER,e,o)},ol.pointer.PointerEventHandler.prototype.out=function(e,o){e.bubbles=!0,this.fireEvent(ol.pointer.EventType.POINTEROUT,e,o)},ol.pointer.PointerEventHandler.prototype.cancel=function(e,o){this.fireEvent(ol.pointer.EventType.POINTERCANCEL,e,o)},ol.pointer.PointerEventHandler.prototype.leaveOut=function(e,o){this.out(e,o),this.contains_(e.target,e.relatedTarget)||this.leave(e,o)},ol.pointer.PointerEventHandler.prototype.enterOver=function(e,o){this.over(e,o),this.contains_(e.target,e.relatedTarget)||this.enter(e,o)},ol.pointer.PointerEventHandler.prototype.contains_=function(e,o){return!(!e||!o)&&e.contains(o)},ol.pointer.PointerEventHandler.prototype.makeEvent=function(e,o,t){return new ol.pointer.PointerEvent(e,t,o)},ol.pointer.PointerEventHandler.prototype.fireEvent=function(e,o,t){var r=this.makeEvent(e,o,t);this.dispatchEvent(r)},ol.pointer.PointerEventHandler.prototype.fireNativeEvent=function(e){var o=this.makeEvent(e.type,e,e);this.dispatchEvent(o)},ol.pointer.PointerEventHandler.prototype.wrapMouseEvent=function(e,o){return this.makeEvent(e,ol.pointer.MouseSource.prepareEvent(o,this),o)},ol.pointer.PointerEventHandler.prototype.disposeInternal=function(){this.unregister_(),ol.events.EventTarget.prototype.disposeInternal.call(this)},ol.pointer.PointerEventHandler.CLONE_PROPS=[["bubbles",!1],["cancelable",!1],["view",null],["detail",null],["screenX",0],["screenY",0],["clientX",0],["clientY",0],["ctrlKey",!1],["altKey",!1],["shiftKey",!1],["metaKey",!1],["button",0],["relatedTarget",null],["buttons",0],["pointerId",0],["width",0],["height",0],["pressure",0],["tiltX",0],["tiltY",0],["pointerType",""],["hwTimestamp",0],["isPrimary",!1],["type",""],["target",null],["currentTarget",null],["which",0]],goog.provide("ol.MapBrowserEventHandler"),goog.require("ol"),goog.require("ol.MapBrowserEvent"),goog.require("ol.MapBrowserPointerEvent"),goog.require("ol.events"),goog.require("ol.events.EventTarget"),goog.require("ol.pointer.EventType"),goog.require("ol.pointer.PointerEventHandler"),ol.MapBrowserEventHandler=function(e){ol.events.EventTarget.call(this),this.map_=e,this.clickTimeoutId_=0,this.dragging_=!1,this.dragListenerKeys_=[],this.down_=null;var o=this.map_.getViewport();this.activePointers_=0,this.trackedTouches_={},this.pointerEventHandler_=new ol.pointer.PointerEventHandler(o),this.documentPointerEventHandler_=null,this.pointerdownListenerKey_=ol.events.listen(this.pointerEventHandler_,ol.pointer.EventType.POINTERDOWN,this.handlePointerDown_,this),this.relayedListenerKey_=ol.events.listen(this.pointerEventHandler_,ol.pointer.EventType.POINTERMOVE,this.relayEvent_,this)},ol.inherits(ol.MapBrowserEventHandler,ol.events.EventTarget),ol.MapBrowserEventHandler.prototype.emulateClick_=function(e){var o=new ol.MapBrowserPointerEvent(ol.MapBrowserEvent.EventType.CLICK,this.map_,e);this.dispatchEvent(o),0!==this.clickTimeoutId_?(clearTimeout(this.clickTimeoutId_),this.clickTimeoutId_=0,o=new ol.MapBrowserPointerEvent(ol.MapBrowserEvent.EventType.DBLCLICK,this.map_,e),this.dispatchEvent(o)):this.clickTimeoutId_=setTimeout(function(){this.clickTimeoutId_=0;var o=new ol.MapBrowserPointerEvent(ol.MapBrowserEvent.EventType.SINGLECLICK,this.map_,e);this.dispatchEvent(o)}.bind(this),250)},ol.MapBrowserEventHandler.prototype.updateActivePointers_=function(e){var o=e;o.type==ol.MapBrowserEvent.EventType.POINTERUP||o.type==ol.MapBrowserEvent.EventType.POINTERCANCEL?delete this.trackedTouches_[o.pointerId]:o.type==ol.MapBrowserEvent.EventType.POINTERDOWN&&(this.trackedTouches_[o.pointerId]=!0),this.activePointers_=Object.keys(this.trackedTouches_).length},ol.MapBrowserEventHandler.prototype.handlePointerUp_=function(e){this.updateActivePointers_(e);var o=new ol.MapBrowserPointerEvent(ol.MapBrowserEvent.EventType.POINTERUP,this.map_,e);this.dispatchEvent(o),!this.dragging_&&this.isMouseActionButton_(e)&&(ol.DEBUG&&console.assert(this.down_,"this.down_ must be truthy"),this.emulateClick_(this.down_)),ol.DEBUG&&console.assert(this.activePointers_>=0,"this.activePointers_ should be equal to or larger than 0"),0===this.activePointers_&&(this.dragListenerKeys_.forEach(ol.events.unlistenByKey),this.dragListenerKeys_.length=0,this.dragging_=!1,this.down_=null,this.documentPointerEventHandler_.dispose(),this.documentPointerEventHandler_=null)},ol.MapBrowserEventHandler.prototype.isMouseActionButton_=function(e){return 0===e.button},ol.MapBrowserEventHandler.prototype.handlePointerDown_=function(e){this.updateActivePointers_(e);var o=new ol.MapBrowserPointerEvent(ol.MapBrowserEvent.EventType.POINTERDOWN,this.map_,e);this.dispatchEvent(o),this.down_=e,0===this.dragListenerKeys_.length&&(this.documentPointerEventHandler_=new ol.pointer.PointerEventHandler(document),this.dragListenerKeys_.push(ol.events.listen(this.documentPointerEventHandler_,ol.MapBrowserEvent.EventType.POINTERMOVE,this.handlePointerMove_,this),ol.events.listen(this.documentPointerEventHandler_,ol.MapBrowserEvent.EventType.POINTERUP,this.handlePointerUp_,this),ol.events.listen(this.pointerEventHandler_,ol.MapBrowserEvent.EventType.POINTERCANCEL,this.handlePointerUp_,this)))},ol.MapBrowserEventHandler.prototype.handlePointerMove_=function(e){if(this.isMoving_(e)){this.dragging_=!0;var o=new ol.MapBrowserPointerEvent(ol.MapBrowserEvent.EventType.POINTERDRAG,this.map_,e,this.dragging_);this.dispatchEvent(o)}e.preventDefault()},ol.MapBrowserEventHandler.prototype.relayEvent_=function(e){var o=!(!this.down_||!this.isMoving_(e));this.dispatchEvent(new ol.MapBrowserPointerEvent(e.type,this.map_,e,o))},ol.MapBrowserEventHandler.prototype.isMoving_=function(e){return e.clientX!=this.down_.clientX||e.clientY!=this.down_.clientY},ol.MapBrowserEventHandler.prototype.disposeInternal=function(){this.relayedListenerKey_&&(ol.events.unlistenByKey(this.relayedListenerKey_),this.relayedListenerKey_=null),this.pointerdownListenerKey_&&(ol.events.unlistenByKey(this.pointerdownListenerKey_),this.pointerdownListenerKey_=null),this.dragListenerKeys_.forEach(ol.events.unlistenByKey),this.dragListenerKeys_.length=0,this.documentPointerEventHandler_&&(this.documentPointerEventHandler_.dispose(),this.documentPointerEventHandler_=null),this.pointerEventHandler_&&(this.pointerEventHandler_.dispose(),this.pointerEventHandler_=null),ol.events.EventTarget.prototype.disposeInternal.call(this)},goog.provide("ol.Tile"),goog.require("ol"),goog.require("ol.events.EventTarget"),goog.require("ol.events.EventType"),ol.Tile=function(e,o){ol.events.EventTarget.call(this),this.tileCoord=e,this.state=o,this.interimTile=null,this.key=""},ol.inherits(ol.Tile,ol.events.EventTarget),ol.Tile.prototype.changed=function(){this.dispatchEvent(ol.events.EventType.CHANGE)},ol.Tile.prototype.getImage=function(){},ol.Tile.prototype.getKey=function(){return this.key+"/"+this.tileCoord},ol.Tile.prototype.getInterimTile=function(){if(!this.interimTile)return this;var e=this.interimTile;do{if(e.getState()==ol.Tile.State.LOADED)return e;e=e.interimTile}while(e);return this},ol.Tile.prototype.refreshInterimChain=function(){if(this.interimTile){var e=this.interimTile,o=this;do{if(e.getState()==ol.Tile.State.LOADED){e.interimTile=null;break}e.getState()==ol.Tile.State.LOADING?o=e:e.getState()==ol.Tile.State.IDLE?o.interimTile=e.interimTile:o=e,e=o.interimTile}while(e)}},ol.Tile.prototype.getTileCoord=function(){return this.tileCoord},ol.Tile.prototype.getState=function(){return this.state},ol.Tile.prototype.load=function(){},ol.Tile.State={IDLE:0,LOADING:1,LOADED:2,ERROR:3,EMPTY:4,ABORT:5},goog.provide("ol.structs.PriorityQueue"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.obj"),ol.structs.PriorityQueue=function(e,o){this.priorityFunction_=e,this.keyFunction_=o,this.elements_=[],this.priorities_=[],this.queuedElements_={}},ol.structs.PriorityQueue.DROP=1/0,ol.DEBUG&&(ol.structs.PriorityQueue.prototype.assertValid=function(){var e=this.elements_,o=this.priorities_,t=e.length;console.assert(o.length==t);var r,i;for(r=0;r<(t>>1)-1;++r)i=o[r],console.assert(i<=o[this.getLeftChildIndex_(r)],"priority smaller than or equal to priority of left child (%s <= %s)",i,o[this.getLeftChildIndex_(r)]),console.assert(i<=o[this.getRightChildIndex_(r)],"priority smaller than or equal to priority of right child (%s <= %s)",i,o[this.getRightChildIndex_(r)])}),ol.structs.PriorityQueue.prototype.clear=function(){this.elements_.length=0,this.priorities_.length=0,ol.obj.clear(this.queuedElements_)},ol.structs.PriorityQueue.prototype.dequeue=function(){var e=this.elements_;ol.DEBUG&&console.assert(e.length>0,"must have elements in order to be able to dequeue");var o=this.priorities_,t=e[0];1==e.length?(e.length=0,o.length=0):(e[0]=e.pop(),o[0]=o.pop(),this.siftUp_(0));var r=this.keyFunction_(t);return ol.DEBUG&&console.assert(r in this.queuedElements_,"key %s is not listed as queued",r),delete this.queuedElements_[r],t},ol.structs.PriorityQueue.prototype.enqueue=function(e){ol.asserts.assert(!(this.keyFunction_(e)in this.queuedElements_),31);var o=this.priorityFunction_(e);return o!=ol.structs.PriorityQueue.DROP&&(this.elements_.push(e),this.priorities_.push(o),this.queuedElements_[this.keyFunction_(e)]=!0,this.siftDown_(0,this.elements_.length-1),!0)},ol.structs.PriorityQueue.prototype.getCount=function(){return this.elements_.length},ol.structs.PriorityQueue.prototype.getLeftChildIndex_=function(e){return 2*e+1},ol.structs.PriorityQueue.prototype.getRightChildIndex_=function(e){return 2*e+2},ol.structs.PriorityQueue.prototype.getParentIndex_=function(e){return e-1>>1},ol.structs.PriorityQueue.prototype.heapify_=function(){var e;for(e=(this.elements_.length>>1)-1;e>=0;e--)this.siftUp_(e)},ol.structs.PriorityQueue.prototype.isEmpty=function(){return 0===this.elements_.length},ol.structs.PriorityQueue.prototype.isKeyQueued=function(e){return e in this.queuedElements_},ol.structs.PriorityQueue.prototype.isQueued=function(e){return this.isKeyQueued(this.keyFunction_(e))},ol.structs.PriorityQueue.prototype.siftUp_=function(e){for(var o=this.elements_,t=this.priorities_,r=o.length,i=o[e],n=t[e],l=e;e<r>>1;){var a=this.getLeftChildIndex_(e),s=this.getRightChildIndex_(e),p=s<r&&t[s]<t[a]?s:a;o[e]=o[p],t[e]=t[p],e=p}o[e]=i,t[e]=n,this.siftDown_(l,e)},ol.structs.PriorityQueue.prototype.siftDown_=function(e,o){for(var t=this.elements_,r=this.priorities_,i=t[o],n=r[o];o>e;){var l=this.getParentIndex_(o);if(!(r[l]>n))break;t[o]=t[l],r[o]=r[l],o=l}t[o]=i,r[o]=n},ol.structs.PriorityQueue.prototype.reprioritize=function(){var e,o,t,r=this.priorityFunction_,i=this.elements_,n=this.priorities_,l=0,a=i.length;for(o=0;o<a;++o)e=i[o],t=r(e),t==ol.structs.PriorityQueue.DROP?delete this.queuedElements_[this.keyFunction_(e)]:(n[l]=t,i[l++]=e);i.length=l,n.length=l,this.heapify_()},goog.provide("ol.TileQueue"),goog.require("ol"),goog.require("ol.Tile"),goog.require("ol.events");goog.require("ol.events.EventType"),goog.require("ol.structs.PriorityQueue"),ol.TileQueue=function(e,o){ol.structs.PriorityQueue.call(this,function(o){return e.apply(null,o)},function(e){return e[0].getKey()}),this.tileChangeCallback_=o,this.tilesLoading_=0,this.tilesLoadingKeys_={}},ol.inherits(ol.TileQueue,ol.structs.PriorityQueue),ol.TileQueue.prototype.enqueue=function(e){var o=ol.structs.PriorityQueue.prototype.enqueue.call(this,e);if(o){var t=e[0];ol.events.listen(t,ol.events.EventType.CHANGE,this.handleTileChange,this)}return o},ol.TileQueue.prototype.getTilesLoading=function(){
return this.tilesLoading_},ol.TileQueue.prototype.handleTileChange=function(e){var o=e.target,t=o.getState();if(t===ol.Tile.State.LOADED||t===ol.Tile.State.ERROR||t===ol.Tile.State.EMPTY||t===ol.Tile.State.ABORT){ol.events.unlisten(o,ol.events.EventType.CHANGE,this.handleTileChange,this);var r=o.getKey();r in this.tilesLoadingKeys_&&(delete this.tilesLoadingKeys_[r],--this.tilesLoading_),this.tileChangeCallback_()}ol.DEBUG&&console.assert(Object.keys(this.tilesLoadingKeys_).length===this.tilesLoading_)},ol.TileQueue.prototype.loadMoreTiles=function(e,o){for(var t,r,i=0;this.tilesLoading_<e&&i<o&&this.getCount()>0;)t=this.dequeue()[0],r=t.getKey(),t.getState()!==ol.Tile.State.IDLE||r in this.tilesLoadingKeys_||(this.tilesLoadingKeys_[r]=!0,++this.tilesLoading_,++i,t.load()),ol.DEBUG&&console.assert(Object.keys(this.tilesLoadingKeys_).length===this.tilesLoading_)},goog.provide("ol.Kinetic"),ol.Kinetic=function(e,o,t){this.decay_=e,this.minVelocity_=o,this.delay_=t,this.points_=[],this.angle_=0,this.initialVelocity_=0},ol.Kinetic.prototype.begin=function(){this.points_.length=0,this.angle_=0,this.initialVelocity_=0},ol.Kinetic.prototype.update=function(e,o){this.points_.push(e,o,Date.now())},ol.Kinetic.prototype.end=function(){if(this.points_.length<6)return!1;var e=Date.now()-this.delay_,o=this.points_.length-3;if(this.points_[o+2]<e)return!1;for(var t=o-3;t>0&&this.points_[t+2]>e;)t-=3;var r=this.points_[o+2]-this.points_[t+2],i=this.points_[o]-this.points_[t],n=this.points_[o+1]-this.points_[t+1];return this.angle_=Math.atan2(n,i),this.initialVelocity_=Math.sqrt(i*i+n*n)/r,this.initialVelocity_>this.minVelocity_},ol.Kinetic.prototype.getDuration_=function(){return Math.log(this.minVelocity_/this.initialVelocity_)/this.decay_},ol.Kinetic.prototype.getDistance=function(){return(this.minVelocity_-this.initialVelocity_)/this.decay_},ol.Kinetic.prototype.getAngle=function(){return this.angle_},goog.provide("ol.interaction.Interaction"),goog.require("ol"),goog.require("ol.Object"),goog.require("ol.easing"),ol.interaction.Interaction=function(e){ol.Object.call(this),this.map_=null,this.setActive(!0),this.handleEvent=e.handleEvent},ol.inherits(ol.interaction.Interaction,ol.Object),ol.interaction.Interaction.prototype.getActive=function(){return this.get(ol.interaction.Interaction.Property.ACTIVE)},ol.interaction.Interaction.prototype.getMap=function(){return this.map_},ol.interaction.Interaction.prototype.setActive=function(e){this.set(ol.interaction.Interaction.Property.ACTIVE,e)},ol.interaction.Interaction.prototype.setMap=function(e){this.map_=e},ol.interaction.Interaction.pan=function(e,o,t,r){var i=o.getCenter();if(i){var n=o.constrainCenter([i[0]+t[0],i[1]+t[1]]);r?o.animate({duration:r,easing:ol.easing.linear,center:n}):o.setCenter(n)}},ol.interaction.Interaction.rotate=function(e,o,t,r,i){t=o.constrainRotation(t,0),ol.interaction.Interaction.rotateWithoutConstraints(e,o,t,r,i)},ol.interaction.Interaction.rotateWithoutConstraints=function(e,o,t,r,i){if(void 0!==t){var n=o.getRotation(),l=o.getCenter();void 0!==n&&l&&i>0?o.animate({rotation:t,anchor:r,duration:i,easing:ol.easing.easeOut}):o.rotate(t,r)}},ol.interaction.Interaction.zoom=function(e,o,t,r,i,n){t=o.constrainResolution(t,0,n),ol.interaction.Interaction.zoomWithoutConstraints(e,o,t,r,i)},ol.interaction.Interaction.zoomByDelta=function(e,o,t,r,i){var n=o.getResolution(),l=o.constrainResolution(n,t,0);ol.interaction.Interaction.zoomWithoutConstraints(e,o,l,r,i)},ol.interaction.Interaction.zoomWithoutConstraints=function(e,o,t,r,i){if(t){var n=o.getResolution(),l=o.getCenter();if(void 0!==n&&l&&t!==n&&i)o.animate({resolution:t,anchor:r,duration:i,easing:ol.easing.easeOut});else{if(r){var a=o.calculateCenterZoom(t,r);o.setCenter(a)}o.setResolution(t)}}},ol.interaction.Interaction.Property={ACTIVE:"active"},goog.provide("ol.interaction.DoubleClickZoom"),goog.require("ol"),goog.require("ol.MapBrowserEvent"),goog.require("ol.interaction.Interaction"),ol.interaction.DoubleClickZoom=function(e){var o=e||{};this.delta_=o.delta?o.delta:1,ol.interaction.Interaction.call(this,{handleEvent:ol.interaction.DoubleClickZoom.handleEvent}),this.duration_=void 0!==o.duration?o.duration:250},ol.inherits(ol.interaction.DoubleClickZoom,ol.interaction.Interaction),ol.interaction.DoubleClickZoom.handleEvent=function(e){var o=!1,t=e.originalEvent;if(e.type==ol.MapBrowserEvent.EventType.DBLCLICK){var r=e.map,i=e.coordinate,n=t.shiftKey?-this.delta_:this.delta_,l=r.getView();ol.interaction.Interaction.zoomByDelta(r,l,n,i,this.duration_),e.preventDefault(),o=!0}return!o},goog.provide("ol.events.condition"),goog.require("ol.MapBrowserEvent"),goog.require("ol.asserts"),goog.require("ol.functions"),goog.require("ol.has"),ol.events.condition.altKeyOnly=function(e){var o=e.originalEvent;return o.altKey&&!(o.metaKey||o.ctrlKey)&&!o.shiftKey},ol.events.condition.altShiftKeysOnly=function(e){var o=e.originalEvent;return o.altKey&&!(o.metaKey||o.ctrlKey)&&o.shiftKey},ol.events.condition.always=ol.functions.TRUE,ol.events.condition.click=function(e){return e.type==ol.MapBrowserEvent.EventType.CLICK},ol.events.condition.mouseActionButton=function(e){var o=e.originalEvent;return 0==o.button&&!(ol.has.WEBKIT&&ol.has.MAC&&o.ctrlKey)},ol.events.condition.never=ol.functions.FALSE,ol.events.condition.pointerMove=function(e){return"pointermove"==e.type},ol.events.condition.singleClick=function(e){return e.type==ol.MapBrowserEvent.EventType.SINGLECLICK},ol.events.condition.doubleClick=function(e){return e.type==ol.MapBrowserEvent.EventType.DBLCLICK},ol.events.condition.noModifierKeys=function(e){var o=e.originalEvent;return!o.altKey&&!(o.metaKey||o.ctrlKey)&&!o.shiftKey},ol.events.condition.platformModifierKeyOnly=function(e){var o=e.originalEvent;return!o.altKey&&(ol.has.MAC?o.metaKey:o.ctrlKey)&&!o.shiftKey},ol.events.condition.shiftKeyOnly=function(e){var o=e.originalEvent;return!o.altKey&&!(o.metaKey||o.ctrlKey)&&o.shiftKey},ol.events.condition.targetNotEditable=function(e){var o=e.originalEvent.target,t=o.tagName;return"INPUT"!==t&&"SELECT"!==t&&"TEXTAREA"!==t},ol.events.condition.mouseOnly=function(e){return ol.asserts.assert(e.pointerEvent,56),"mouse"==e.pointerEvent.pointerType},ol.events.condition.primaryAction=function(e){var o=e.pointerEvent;return o.isPrimary&&0===o.button},goog.provide("ol.interaction.Pointer"),goog.require("ol"),goog.require("ol.functions"),goog.require("ol.MapBrowserEvent"),goog.require("ol.MapBrowserPointerEvent"),goog.require("ol.interaction.Interaction"),goog.require("ol.obj"),ol.interaction.Pointer=function(e){var o=e||{},t=o.handleEvent?o.handleEvent:ol.interaction.Pointer.handleEvent;ol.interaction.Interaction.call(this,{handleEvent:t}),this.handleDownEvent_=o.handleDownEvent?o.handleDownEvent:ol.interaction.Pointer.handleDownEvent,this.handleDragEvent_=o.handleDragEvent?o.handleDragEvent:ol.interaction.Pointer.handleDragEvent,this.handleMoveEvent_=o.handleMoveEvent?o.handleMoveEvent:ol.interaction.Pointer.handleMoveEvent,this.handleUpEvent_=o.handleUpEvent?o.handleUpEvent:ol.interaction.Pointer.handleUpEvent,this.handlingDownUpSequence=!1,this.trackedPointers_={},this.targetPointers=[]},ol.inherits(ol.interaction.Pointer,ol.interaction.Interaction),ol.interaction.Pointer.centroid=function(e){for(var o=e.length,t=0,r=0,i=0;i<o;i++)t+=e[i].clientX,r+=e[i].clientY;return[t/o,r/o]},ol.interaction.Pointer.prototype.isPointerDraggingEvent_=function(e){var o=e.type;return o===ol.MapBrowserEvent.EventType.POINTERDOWN||o===ol.MapBrowserEvent.EventType.POINTERDRAG||o===ol.MapBrowserEvent.EventType.POINTERUP},ol.interaction.Pointer.prototype.updateTrackedPointers_=function(e){if(this.isPointerDraggingEvent_(e)){var o=e.pointerEvent;e.type==ol.MapBrowserEvent.EventType.POINTERUP?delete this.trackedPointers_[o.pointerId]:e.type==ol.MapBrowserEvent.EventType.POINTERDOWN?this.trackedPointers_[o.pointerId]=o:o.pointerId in this.trackedPointers_&&(this.trackedPointers_[o.pointerId]=o),this.targetPointers=ol.obj.getValues(this.trackedPointers_)}},ol.interaction.Pointer.handleDragEvent=ol.nullFunction,ol.interaction.Pointer.handleUpEvent=ol.functions.FALSE,ol.interaction.Pointer.handleDownEvent=ol.functions.FALSE,ol.interaction.Pointer.handleMoveEvent=ol.nullFunction,ol.interaction.Pointer.handleEvent=function(e){if(!(e instanceof ol.MapBrowserPointerEvent))return!0;var o=!1;if(this.updateTrackedPointers_(e),this.handlingDownUpSequence&&(e.type==ol.MapBrowserEvent.EventType.POINTERDRAG?this.handleDragEvent_(e):e.type==ol.MapBrowserEvent.EventType.POINTERUP&&(this.handlingDownUpSequence=this.handleUpEvent_(e))),e.type==ol.MapBrowserEvent.EventType.POINTERDOWN){var t=this.handleDownEvent_(e);this.handlingDownUpSequence=t,o=this.shouldStopEvent(t)}else e.type==ol.MapBrowserEvent.EventType.POINTERMOVE&&this.handleMoveEvent_(e);return!o},ol.interaction.Pointer.prototype.shouldStopEvent=function(e){return e},goog.provide("ol.interaction.DragPan"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.coordinate"),goog.require("ol.easing"),goog.require("ol.events.condition"),goog.require("ol.functions"),goog.require("ol.interaction.Pointer"),ol.interaction.DragPan=function(e){ol.interaction.Pointer.call(this,{handleDownEvent:ol.interaction.DragPan.handleDownEvent_,handleDragEvent:ol.interaction.DragPan.handleDragEvent_,handleUpEvent:ol.interaction.DragPan.handleUpEvent_});var o=e||{};this.kinetic_=o.kinetic,this.lastCentroid=null,this.condition_=o.condition?o.condition:ol.events.condition.noModifierKeys,this.noKinetic_=!1},ol.inherits(ol.interaction.DragPan,ol.interaction.Pointer),ol.interaction.DragPan.handleDragEvent_=function(e){ol.DEBUG&&console.assert(this.targetPointers.length>=1,"the length of this.targetPointers should be more than 1");var o=ol.interaction.Pointer.centroid(this.targetPointers);if(this.kinetic_&&this.kinetic_.update(o[0],o[1]),this.lastCentroid){var t=this.lastCentroid[0]-o[0],r=o[1]-this.lastCentroid[1],i=e.map,n=i.getView(),l=n.getState(),a=[t,r];ol.coordinate.scale(a,l.resolution),ol.coordinate.rotate(a,l.rotation),ol.coordinate.add(a,l.center),a=n.constrainCenter(a),n.setCenter(a)}this.lastCentroid=o},ol.interaction.DragPan.handleUpEvent_=function(e){var o=e.map,t=o.getView();if(0===this.targetPointers.length){if(!this.noKinetic_&&this.kinetic_&&this.kinetic_.end()){var r=this.kinetic_.getDistance(),i=this.kinetic_.getAngle(),n=t.getCenter(),l=o.getPixelFromCoordinate(n),a=o.getCoordinateFromPixel([l[0]-r*Math.cos(i),l[1]-r*Math.sin(i)]);t.animate({center:t.constrainCenter(a),duration:500,easing:ol.easing.easeOut})}return t.setHint(ol.View.Hint.INTERACTING,-1),!1}return this.lastCentroid=null,!0},ol.interaction.DragPan.handleDownEvent_=function(e){if(this.targetPointers.length>0&&this.condition_(e)){var o=e.map,t=o.getView();return this.lastCentroid=null,this.handlingDownUpSequence||t.setHint(ol.View.Hint.INTERACTING,1),t.setCenter(e.frameState.viewState.center),this.kinetic_&&this.kinetic_.begin(),this.noKinetic_=this.targetPointers.length>1,!0}return!1},ol.interaction.DragPan.prototype.shouldStopEvent=ol.functions.FALSE,goog.provide("ol.interaction.DragRotate"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.events.condition"),goog.require("ol.functions"),goog.require("ol.interaction.Interaction"),goog.require("ol.interaction.Pointer"),ol.interaction.DragRotate=function(e){var o=e||{};ol.interaction.Pointer.call(this,{handleDownEvent:ol.interaction.DragRotate.handleDownEvent_,handleDragEvent:ol.interaction.DragRotate.handleDragEvent_,handleUpEvent:ol.interaction.DragRotate.handleUpEvent_}),this.condition_=o.condition?o.condition:ol.events.condition.altShiftKeysOnly,this.lastAngle_=void 0,this.duration_=void 0!==o.duration?o.duration:250},ol.inherits(ol.interaction.DragRotate,ol.interaction.Pointer),ol.interaction.DragRotate.handleDragEvent_=function(e){if(ol.events.condition.mouseOnly(e)){var o=e.map,t=o.getSize(),r=e.pixel,i=Math.atan2(t[1]/2-r[1],r[0]-t[0]/2);if(void 0!==this.lastAngle_){var n=i-this.lastAngle_,l=o.getView(),a=l.getRotation();ol.interaction.Interaction.rotateWithoutConstraints(o,l,a-n)}this.lastAngle_=i}},ol.interaction.DragRotate.handleUpEvent_=function(e){if(!ol.events.condition.mouseOnly(e))return!0;var o=e.map,t=o.getView();t.setHint(ol.View.Hint.INTERACTING,-1);var r=t.getRotation();return ol.interaction.Interaction.rotate(o,t,r,void 0,this.duration_),!1},ol.interaction.DragRotate.handleDownEvent_=function(e){if(!ol.events.condition.mouseOnly(e))return!1;if(ol.events.condition.mouseActionButton(e)&&this.condition_(e)){return e.map.getView().setHint(ol.View.Hint.INTERACTING,1),this.lastAngle_=void 0,!0}return!1},ol.interaction.DragRotate.prototype.shouldStopEvent=ol.functions.FALSE,goog.provide("ol.render.Box"),goog.require("ol"),goog.require("ol.Disposable"),goog.require("ol.geom.Polygon"),ol.render.Box=function(e){this.geometry_=null,this.element_=document.createElement("div"),this.element_.style.position="absolute",this.element_.className="ol-box "+e,this.map_=null,this.startPixel_=null,this.endPixel_=null},ol.inherits(ol.render.Box,ol.Disposable),ol.render.Box.prototype.disposeInternal=function(){this.setMap(null)},ol.render.Box.prototype.render_=function(){var e=this.startPixel_,o=this.endPixel_,t=this.element_.style;t.left=Math.min(e[0],o[0])+"px",t.top=Math.min(e[1],o[1])+"px",t.width=Math.abs(o[0]-e[0])+"px",t.height=Math.abs(o[1]-e[1])+"px"},ol.render.Box.prototype.setMap=function(e){if(this.map_){this.map_.getOverlayContainer().removeChild(this.element_);var o=this.element_.style;o.left=o.top=o.width=o.height="inherit"}this.map_=e,this.map_&&this.map_.getOverlayContainer().appendChild(this.element_)},ol.render.Box.prototype.setPixels=function(e,o){this.startPixel_=e,this.endPixel_=o,this.createOrUpdateGeometry(),this.render_()},ol.render.Box.prototype.createOrUpdateGeometry=function(){var e=this.startPixel_,o=this.endPixel_,t=[e,[e[0],o[1]],o,[o[0],e[1]]],r=t.map(this.map_.getCoordinateFromPixel,this.map_);r[4]=r[0].slice(),this.geometry_?this.geometry_.setCoordinates([r]):this.geometry_=new ol.geom.Polygon([r])},ol.render.Box.prototype.getGeometry=function(){return this.geometry_},goog.provide("ol.interaction.DragBox"),goog.require("ol.events.Event"),goog.require("ol"),goog.require("ol.events.condition"),goog.require("ol.interaction.Pointer"),goog.require("ol.render.Box"),ol.DRAG_BOX_HYSTERESIS_PIXELS_SQUARED=ol.DRAG_BOX_HYSTERESIS_PIXELS*ol.DRAG_BOX_HYSTERESIS_PIXELS,ol.interaction.DragBox=function(e){ol.interaction.Pointer.call(this,{handleDownEvent:ol.interaction.DragBox.handleDownEvent_,handleDragEvent:ol.interaction.DragBox.handleDragEvent_,handleUpEvent:ol.interaction.DragBox.handleUpEvent_});var o=e||{};this.box_=new ol.render.Box(o.className||"ol-dragbox"),this.startPixel_=null,this.condition_=o.condition?o.condition:ol.events.condition.always,this.boxEndCondition_=o.boxEndCondition?o.boxEndCondition:ol.interaction.DragBox.defaultBoxEndCondition},ol.inherits(ol.interaction.DragBox,ol.interaction.Pointer),ol.interaction.DragBox.defaultBoxEndCondition=function(e,o,t){var r=t[0]-o[0],i=t[1]-o[1];return r*r+i*i>=ol.DRAG_BOX_HYSTERESIS_PIXELS_SQUARED},ol.interaction.DragBox.handleDragEvent_=function(e){ol.events.condition.mouseOnly(e)&&(this.box_.setPixels(this.startPixel_,e.pixel),this.dispatchEvent(new ol.interaction.DragBox.Event(ol.interaction.DragBox.EventType.BOXDRAG,e.coordinate,e)))},ol.interaction.DragBox.prototype.getGeometry=function(){return this.box_.getGeometry()},ol.interaction.DragBox.prototype.onBoxEnd=ol.nullFunction,ol.interaction.DragBox.handleUpEvent_=function(e){return!ol.events.condition.mouseOnly(e)||(this.box_.setMap(null),this.boxEndCondition_(e,this.startPixel_,e.pixel)&&(this.onBoxEnd(e),this.dispatchEvent(new ol.interaction.DragBox.Event(ol.interaction.DragBox.EventType.BOXEND,e.coordinate,e))),!1)},ol.interaction.DragBox.handleDownEvent_=function(e){return!!ol.events.condition.mouseOnly(e)&&(!(!ol.events.condition.mouseActionButton(e)||!this.condition_(e))&&(this.startPixel_=e.pixel,this.box_.setMap(e.map),this.box_.setPixels(this.startPixel_,this.startPixel_),this.dispatchEvent(new ol.interaction.DragBox.Event(ol.interaction.DragBox.EventType.BOXSTART,e.coordinate,e)),!0))},ol.interaction.DragBox.EventType={BOXSTART:"boxstart",BOXDRAG:"boxdrag",BOXEND:"boxend"},ol.interaction.DragBox.Event=function(e,o,t){ol.events.Event.call(this,e),this.coordinate=o,this.mapBrowserEvent=t},ol.inherits(ol.interaction.DragBox.Event,ol.events.Event),goog.provide("ol.interaction.DragZoom"),goog.require("ol"),goog.require("ol.easing"),goog.require("ol.events.condition"),goog.require("ol.extent"),goog.require("ol.interaction.DragBox"),ol.interaction.DragZoom=function(e){var o=e||{},t=o.condition?o.condition:ol.events.condition.shiftKeyOnly;this.duration_=void 0!==o.duration?o.duration:200,this.out_=void 0!==o.out&&o.out,ol.interaction.DragBox.call(this,{condition:t,className:o.className||"ol-dragzoom"})},ol.inherits(ol.interaction.DragZoom,ol.interaction.DragBox),ol.interaction.DragZoom.prototype.onBoxEnd=function(){var e=this.getMap(),o=e.getView(),t=e.getSize(),r=this.getGeometry().getExtent();if(this.out_){var i=o.calculateExtent(t),n=ol.extent.createOrUpdateFromCoordinates([e.getPixelFromCoordinate(ol.extent.getBottomLeft(r)),e.getPixelFromCoordinate(ol.extent.getTopRight(r))]),l=o.getResolutionForExtent(n,t);ol.extent.scaleFromCenter(i,1/l),r=i}var a=o.constrainResolution(o.getResolutionForExtent(r,t));o.animate({resolution:a,center:ol.extent.getCenter(r),duration:this.duration_,easing:ol.easing.easeOut})},goog.provide("ol.events.KeyCode"),ol.events.KeyCode={LEFT:37,UP:38,RIGHT:39,DOWN:40},goog.provide("ol.interaction.KeyboardPan"),goog.require("ol"),goog.require("ol.coordinate"),goog.require("ol.events.EventType"),goog.require("ol.events.KeyCode"),goog.require("ol.events.condition"),goog.require("ol.interaction.Interaction"),ol.interaction.KeyboardPan=function(e){ol.interaction.Interaction.call(this,{handleEvent:ol.interaction.KeyboardPan.handleEvent});var o=e||{};this.defaultCondition_=function(e){return ol.events.condition.noModifierKeys(e)&&ol.events.condition.targetNotEditable(e)},this.condition_=void 0!==o.condition?o.condition:this.defaultCondition_,this.duration_=void 0!==o.duration?o.duration:100,this.pixelDelta_=void 0!==o.pixelDelta?o.pixelDelta:128},ol.inherits(ol.interaction.KeyboardPan,ol.interaction.Interaction),ol.interaction.KeyboardPan.handleEvent=function(e){var o=!1;if(e.type==ol.events.EventType.KEYDOWN){var t=e.originalEvent,r=t.keyCode;if(this.condition_(e)&&(r==ol.events.KeyCode.DOWN||r==ol.events.KeyCode.LEFT||r==ol.events.KeyCode.RIGHT||r==ol.events.KeyCode.UP)){var i=e.map,n=i.getView(),l=n.getResolution()*this.pixelDelta_,a=0,s=0;r==ol.events.KeyCode.DOWN?s=-l:r==ol.events.KeyCode.LEFT?a=-l:r==ol.events.KeyCode.RIGHT?a=l:s=l;var p=[a,s];ol.coordinate.rotate(p,n.getRotation()),ol.interaction.Interaction.pan(i,n,p,this.duration_),e.preventDefault(),o=!0}}return!o},goog.provide("ol.interaction.KeyboardZoom"),goog.require("ol"),goog.require("ol.events.EventType"),goog.require("ol.events.condition"),goog.require("ol.interaction.Interaction"),ol.interaction.KeyboardZoom=function(e){ol.interaction.Interaction.call(this,{handleEvent:ol.interaction.KeyboardZoom.handleEvent});var o=e||{};this.condition_=o.condition?o.condition:ol.events.condition.targetNotEditable,this.delta_=o.delta?o.delta:1,this.duration_=void 0!==o.duration?o.duration:100},ol.inherits(ol.interaction.KeyboardZoom,ol.interaction.Interaction),ol.interaction.KeyboardZoom.handleEvent=function(e){var o=!1;if(e.type==ol.events.EventType.KEYDOWN||e.type==ol.events.EventType.KEYPRESS){var t=e.originalEvent,r=t.charCode;if(this.condition_(e)&&(r=="+".charCodeAt(0)||r=="-".charCodeAt(0))){var i=e.map,n=r=="+".charCodeAt(0)?this.delta_:-this.delta_,l=i.getView();ol.interaction.Interaction.zoomByDelta(i,l,n,void 0,this.duration_),e.preventDefault(),o=!0}}return!o},goog.provide("ol.interaction.MouseWheelZoom"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.easing"),goog.require("ol.events.EventType"),goog.require("ol.has"),goog.require("ol.interaction.Interaction"),goog.require("ol.math"),ol.interaction.MouseWheelZoom=function(e){ol.interaction.Interaction.call(this,{handleEvent:ol.interaction.MouseWheelZoom.handleEvent});var o=e||{};this.delta_=0,this.duration_=void 0!==o.duration?o.duration:250,this.timeout_=void 0!==o.timeout?o.timeout:80,this.useAnchor_=void 0===o.useAnchor||o.useAnchor,this.lastAnchor_=null,this.startTime_=void 0,this.timeoutId_=void 0,this.mode_=void 0,this.trackpadEventGap_=400,this.trackpadTimeoutId_=void 0,this.trackpadDeltaPerZoom_=300,this.trackpadZoomBuffer_=1.5},ol.inherits(ol.interaction.MouseWheelZoom,ol.interaction.Interaction),ol.interaction.MouseWheelZoom.handleEvent=function(e){var o=e.type;if(o!==ol.events.EventType.WHEEL&&o!==ol.events.EventType.MOUSEWHEEL)return!0;e.preventDefault();var t=e.map,r=e.originalEvent;this.useAnchor_&&(this.lastAnchor_=e.coordinate);var i;if(e.type==ol.events.EventType.WHEEL?(i=r.deltaY,ol.has.FIREFOX&&r.deltaMode===WheelEvent.DOM_DELTA_PIXEL&&(i/=ol.has.DEVICE_PIXEL_RATIO),r.deltaMode===WheelEvent.DOM_DELTA_LINE&&(i*=40)):e.type==ol.events.EventType.MOUSEWHEEL&&(i=-r.wheelDeltaY,ol.has.SAFARI&&(i/=3)),0===i)return!1;var n=Date.now();if(void 0===this.startTime_&&(this.startTime_=n),(!this.mode_||n-this.startTime_>this.trackpadEventGap_)&&(this.mode_=Math.abs(i)<4?ol.interaction.MouseWheelZoom.Mode.TRACKPAD:ol.interaction.MouseWheelZoom.Mode.WHEEL),this.mode_===ol.interaction.MouseWheelZoom.Mode.TRACKPAD){var l=t.getView();this.trackpadTimeoutId_?clearTimeout(this.trackpadTimeoutId_):l.setHint(ol.View.Hint.INTERACTING,1),this.trackpadTimeoutId_=setTimeout(this.decrementInteractingHint_.bind(this),this.trackpadEventGap_);var a=l.getResolution()*Math.pow(2,i/this.trackpadDeltaPerZoom_),s=l.getMinResolution(),p=l.getMaxResolution(),g=0;if(a<s?(a=Math.max(a,s/this.trackpadZoomBuffer_),g=1):a>p&&(a=Math.min(a,p*this.trackpadZoomBuffer_),g=-1),this.lastAnchor_){var c=l.calculateCenterZoom(a,this.lastAnchor_);l.setCenter(c)}return l.setResolution(a),g>0?l.animate({resolution:s,easing:ol.easing.easeOut,anchor:this.lastAnchor_,duration:500}):g<0&&l.animate({resolution:p,easing:ol.easing.easeOut,anchor:this.lastAnchor_,duration:500}),this.startTime_=n,!1}this.delta_+=i;var u=Math.max(this.timeout_-(n-this.startTime_),0);return clearTimeout(this.timeoutId_),this.timeoutId_=setTimeout(this.handleWheelZoom_.bind(this,t),u),!1},ol.interaction.MouseWheelZoom.prototype.decrementInteractingHint_=function(){this.trackpadTimeoutId_=void 0,this.getMap().getView().setHint(ol.View.Hint.INTERACTING,-1)},ol.interaction.MouseWheelZoom.prototype.handleWheelZoom_=function(e){var o=e.getView();o.getAnimating()&&o.cancelAnimations();var t=ol.MOUSEWHEELZOOM_MAXDELTA,r=ol.math.clamp(this.delta_,-t,t);ol.interaction.Interaction.zoomByDelta(e,o,-r,this.lastAnchor_,this.duration_),this.mode_=void 0,this.delta_=0,this.lastAnchor_=null,this.startTime_=void 0,this.timeoutId_=void 0},ol.interaction.MouseWheelZoom.prototype.setMouseAnchor=function(e){this.useAnchor_=e,e||(this.lastAnchor_=null)},ol.interaction.MouseWheelZoom.Mode={TRACKPAD:"trackpad",WHEEL:"wheel"},goog.provide("ol.interaction.PinchRotate"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.functions"),goog.require("ol.interaction.Interaction"),goog.require("ol.interaction.Pointer"),ol.interaction.PinchRotate=function(e){ol.interaction.Pointer.call(this,{handleDownEvent:ol.interaction.PinchRotate.handleDownEvent_,handleDragEvent:ol.interaction.PinchRotate.handleDragEvent_,handleUpEvent:ol.interaction.PinchRotate.handleUpEvent_});var o=e||{};this.anchor_=null,this.lastAngle_=void 0,this.rotating_=!1,this.rotationDelta_=0,this.threshold_=void 0!==o.threshold?o.threshold:.3,this.duration_=void 0!==o.duration?o.duration:250},ol.inherits(ol.interaction.PinchRotate,ol.interaction.Pointer),ol.interaction.PinchRotate.handleDragEvent_=function(e){ol.DEBUG&&console.assert(this.targetPointers.length>=2,"length of this.targetPointers should be greater than or equal to 2");var o=0,t=this.targetPointers[0],r=this.targetPointers[1],i=Math.atan2(r.clientY-t.clientY,r.clientX-t.clientX);if(void 0!==this.lastAngle_){var n=i-this.lastAngle_;this.rotationDelta_+=n,!this.rotating_&&Math.abs(this.rotationDelta_)>this.threshold_&&(this.rotating_=!0),o=n}this.lastAngle_=i;var l=e.map,a=l.getViewport().getBoundingClientRect(),s=ol.interaction.Pointer.centroid(this.targetPointers);if(s[0]-=a.left,s[1]-=a.top,this.anchor_=l.getCoordinateFromPixel(s),this.rotating_){var p=l.getView(),g=p.getRotation();l.render(),ol.interaction.Interaction.rotateWithoutConstraints(l,p,g+o,this.anchor_)}},ol.interaction.PinchRotate.handleUpEvent_=function(e){if(this.targetPointers.length<2){var o=e.map,t=o.getView();if(t.setHint(ol.View.Hint.INTERACTING,-1),this.rotating_){var r=t.getRotation();ol.interaction.Interaction.rotate(o,t,r,this.anchor_,this.duration_)}return!1}return!0},ol.interaction.PinchRotate.handleDownEvent_=function(e){if(this.targetPointers.length>=2){var o=e.map;return this.anchor_=null,this.lastAngle_=void 0,this.rotating_=!1,this.rotationDelta_=0,this.handlingDownUpSequence||o.getView().setHint(ol.View.Hint.INTERACTING,1),!0}return!1},ol.interaction.PinchRotate.prototype.shouldStopEvent=ol.functions.FALSE,goog.provide("ol.interaction.PinchZoom"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.functions"),goog.require("ol.interaction.Interaction"),goog.require("ol.interaction.Pointer"),ol.interaction.PinchZoom=function(e){ol.interaction.Pointer.call(this,{handleDownEvent:ol.interaction.PinchZoom.handleDownEvent_,handleDragEvent:ol.interaction.PinchZoom.handleDragEvent_,handleUpEvent:ol.interaction.PinchZoom.handleUpEvent_});var o=e||{};this.constrainResolution_=o.constrainResolution||!1,this.anchor_=null,this.duration_=void 0!==o.duration?o.duration:400,this.lastDistance_=void 0,this.lastScaleDelta_=1},ol.inherits(ol.interaction.PinchZoom,ol.interaction.Pointer),ol.interaction.PinchZoom.handleDragEvent_=function(e){ol.DEBUG&&console.assert(this.targetPointers.length>=2,"length of this.targetPointers should be 2 or more");var o=1,t=this.targetPointers[0],r=this.targetPointers[1],i=t.clientX-r.clientX,n=t.clientY-r.clientY,l=Math.sqrt(i*i+n*n);void 0!==this.lastDistance_&&(o=this.lastDistance_/l),this.lastDistance_=l,1!=o&&(this.lastScaleDelta_=o);var a=e.map,s=a.getView(),p=s.getResolution(),g=a.getViewport().getBoundingClientRect(),c=ol.interaction.Pointer.centroid(this.targetPointers);c[0]-=g.left,c[1]-=g.top,this.anchor_=a.getCoordinateFromPixel(c),a.render(),ol.interaction.Interaction.zoomWithoutConstraints(a,s,p*o,this.anchor_)};ol.interaction.PinchZoom.handleUpEvent_=function(e){if(this.targetPointers.length<2){var o=e.map,t=o.getView();if(t.setHint(ol.View.Hint.INTERACTING,-1),this.constrainResolution_){var r=t.getResolution(),i=this.lastScaleDelta_-1;ol.interaction.Interaction.zoom(o,t,r,this.anchor_,this.duration_,i)}return!1}return!0},ol.interaction.PinchZoom.handleDownEvent_=function(e){if(this.targetPointers.length>=2){var o=e.map;return this.anchor_=null,this.lastDistance_=void 0,this.lastScaleDelta_=1,this.handlingDownUpSequence||o.getView().setHint(ol.View.Hint.INTERACTING,1),!0}return!1},ol.interaction.PinchZoom.prototype.shouldStopEvent=ol.functions.FALSE,goog.provide("ol.interaction"),goog.require("ol"),goog.require("ol.Collection"),goog.require("ol.Kinetic"),goog.require("ol.interaction.DoubleClickZoom"),goog.require("ol.interaction.DragPan"),goog.require("ol.interaction.DragRotate"),goog.require("ol.interaction.DragZoom"),goog.require("ol.interaction.KeyboardPan"),goog.require("ol.interaction.KeyboardZoom"),goog.require("ol.interaction.MouseWheelZoom"),goog.require("ol.interaction.PinchRotate"),goog.require("ol.interaction.PinchZoom"),ol.interaction.defaults=function(e){var o=e||{},t=new ol.Collection,r=new ol.Kinetic(-.005,.05,100);return(void 0===o.altShiftDragRotate||o.altShiftDragRotate)&&t.push(new ol.interaction.DragRotate),(void 0===o.doubleClickZoom||o.doubleClickZoom)&&t.push(new ol.interaction.DoubleClickZoom({delta:o.zoomDelta,duration:o.zoomDuration})),(void 0===o.dragPan||o.dragPan)&&t.push(new ol.interaction.DragPan({kinetic:r})),(void 0===o.pinchRotate||o.pinchRotate)&&t.push(new ol.interaction.PinchRotate),(void 0===o.pinchZoom||o.pinchZoom)&&t.push(new ol.interaction.PinchZoom({duration:o.zoomDuration})),(void 0===o.keyboard||o.keyboard)&&(t.push(new ol.interaction.KeyboardPan),t.push(new ol.interaction.KeyboardZoom({delta:o.zoomDelta,duration:o.zoomDuration}))),(void 0===o.mouseWheelZoom||o.mouseWheelZoom)&&t.push(new ol.interaction.MouseWheelZoom({duration:o.zoomDuration})),(void 0===o.shiftDragZoom||o.shiftDragZoom)&&t.push(new ol.interaction.DragZoom({duration:o.zoomDuration})),t},goog.provide("ol.layer.Base"),goog.require("ol"),goog.require("ol.Object"),goog.require("ol.math"),goog.require("ol.obj"),ol.layer.Base=function(e){ol.Object.call(this);var o=ol.obj.assign({},e);o[ol.layer.Base.Property.OPACITY]=void 0!==e.opacity?e.opacity:1,o[ol.layer.Base.Property.VISIBLE]=void 0===e.visible||e.visible,o[ol.layer.Base.Property.Z_INDEX]=void 0!==e.zIndex?e.zIndex:0,o[ol.layer.Base.Property.MAX_RESOLUTION]=void 0!==e.maxResolution?e.maxResolution:1/0,o[ol.layer.Base.Property.MIN_RESOLUTION]=void 0!==e.minResolution?e.minResolution:0,this.setProperties(o),this.state_={layer:this,managed:!0}},ol.inherits(ol.layer.Base,ol.Object),ol.layer.Base.prototype.getLayerState=function(){return this.state_.opacity=ol.math.clamp(this.getOpacity(),0,1),this.state_.sourceState=this.getSourceState(),this.state_.visible=this.getVisible(),this.state_.extent=this.getExtent(),this.state_.zIndex=this.getZIndex(),this.state_.maxResolution=this.getMaxResolution(),this.state_.minResolution=Math.max(this.getMinResolution(),0),this.state_},ol.layer.Base.prototype.getLayersArray=function(e){},ol.layer.Base.prototype.getLayerStatesArray=function(e){},ol.layer.Base.prototype.getExtent=function(){return this.get(ol.layer.Base.Property.EXTENT)},ol.layer.Base.prototype.getMaxResolution=function(){return this.get(ol.layer.Base.Property.MAX_RESOLUTION)},ol.layer.Base.prototype.getMinResolution=function(){return this.get(ol.layer.Base.Property.MIN_RESOLUTION)},ol.layer.Base.prototype.getOpacity=function(){return this.get(ol.layer.Base.Property.OPACITY)},ol.layer.Base.prototype.getSourceState=function(){},ol.layer.Base.prototype.getVisible=function(){return this.get(ol.layer.Base.Property.VISIBLE)},ol.layer.Base.prototype.getZIndex=function(){return this.get(ol.layer.Base.Property.Z_INDEX)},ol.layer.Base.prototype.setExtent=function(e){this.set(ol.layer.Base.Property.EXTENT,e)},ol.layer.Base.prototype.setMaxResolution=function(e){this.set(ol.layer.Base.Property.MAX_RESOLUTION,e)},ol.layer.Base.prototype.setMinResolution=function(e){this.set(ol.layer.Base.Property.MIN_RESOLUTION,e)},ol.layer.Base.prototype.setOpacity=function(e){this.set(ol.layer.Base.Property.OPACITY,e)},ol.layer.Base.prototype.setVisible=function(e){this.set(ol.layer.Base.Property.VISIBLE,e)},ol.layer.Base.prototype.setZIndex=function(e){this.set(ol.layer.Base.Property.Z_INDEX,e)},ol.layer.Base.Property={OPACITY:"opacity",VISIBLE:"visible",EXTENT:"extent",Z_INDEX:"zIndex",MAX_RESOLUTION:"maxResolution",MIN_RESOLUTION:"minResolution",SOURCE:"source"},goog.provide("ol.source.State"),ol.source.State={UNDEFINED:"undefined",LOADING:"loading",READY:"ready",ERROR:"error"},goog.provide("ol.layer.Group"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.Collection"),goog.require("ol.Object"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.layer.Base"),goog.require("ol.obj"),goog.require("ol.source.State"),ol.layer.Group=function(e){var o=e||{},t=ol.obj.assign({},o);delete t.layers;var r=o.layers;ol.layer.Base.call(this,t),this.layersListenerKeys_=[],
this.listenerKeys_={},ol.events.listen(this,ol.Object.getChangeEventType(ol.layer.Group.Property.LAYERS),this.handleLayersChanged_,this),r?Array.isArray(r)?r=new ol.Collection(r.slice()):(ol.asserts.assert(r instanceof ol.Collection,43),r=r):r=new ol.Collection,this.setLayers(r)},ol.inherits(ol.layer.Group,ol.layer.Base),ol.layer.Group.prototype.handleLayerChange_=function(){this.getVisible()&&this.changed()},ol.layer.Group.prototype.handleLayersChanged_=function(e){this.layersListenerKeys_.forEach(ol.events.unlistenByKey),this.layersListenerKeys_.length=0;var o=this.getLayers();this.layersListenerKeys_.push(ol.events.listen(o,ol.Collection.EventType.ADD,this.handleLayersAdd_,this),ol.events.listen(o,ol.Collection.EventType.REMOVE,this.handleLayersRemove_,this));for(var t in this.listenerKeys_)this.listenerKeys_[t].forEach(ol.events.unlistenByKey);ol.obj.clear(this.listenerKeys_);var r,i,n,l=o.getArray();for(r=0,i=l.length;r<i;r++)n=l[r],this.listenerKeys_[ol.getUid(n).toString()]=[ol.events.listen(n,ol.Object.EventType.PROPERTYCHANGE,this.handleLayerChange_,this),ol.events.listen(n,ol.events.EventType.CHANGE,this.handleLayerChange_,this)];this.changed()},ol.layer.Group.prototype.handleLayersAdd_=function(e){var o=e.element,t=ol.getUid(o).toString();ol.DEBUG&&console.assert(!(t in this.listenerKeys_),"listeners already registered"),this.listenerKeys_[t]=[ol.events.listen(o,ol.Object.EventType.PROPERTYCHANGE,this.handleLayerChange_,this),ol.events.listen(o,ol.events.EventType.CHANGE,this.handleLayerChange_,this)],this.changed()},ol.layer.Group.prototype.handleLayersRemove_=function(e){var o=e.element,t=ol.getUid(o).toString();ol.DEBUG&&console.assert(t in this.listenerKeys_,"no listeners to unregister"),this.listenerKeys_[t].forEach(ol.events.unlistenByKey),delete this.listenerKeys_[t],this.changed()},ol.layer.Group.prototype.getLayers=function(){return this.get(ol.layer.Group.Property.LAYERS)},ol.layer.Group.prototype.setLayers=function(e){this.set(ol.layer.Group.Property.LAYERS,e)},ol.layer.Group.prototype.getLayersArray=function(e){var o=void 0!==e?e:[];return this.getLayers().forEach(function(e){e.getLayersArray(o)}),o},ol.layer.Group.prototype.getLayerStatesArray=function(e){var o=void 0!==e?e:[],t=o.length;this.getLayers().forEach(function(e){e.getLayerStatesArray(o)});var r,i,n,l=this.getLayerState();for(r=t,i=o.length;r<i;r++)n=o[r],n.opacity*=l.opacity,n.visible=n.visible&&l.visible,n.maxResolution=Math.min(n.maxResolution,l.maxResolution),n.minResolution=Math.max(n.minResolution,l.minResolution),void 0!==l.extent&&(void 0!==n.extent?n.extent=ol.extent.getIntersection(n.extent,l.extent):n.extent=l.extent);return o},ol.layer.Group.prototype.getSourceState=function(){return ol.source.State.READY},ol.layer.Group.Property={LAYERS:"layers"},goog.provide("ol.proj.EPSG3857"),goog.require("ol"),goog.require("ol.math"),goog.require("ol.proj"),goog.require("ol.proj.Projection"),goog.require("ol.proj.Units"),ol.proj.EPSG3857_=function(e){ol.proj.Projection.call(this,{code:e,units:ol.proj.Units.METERS,extent:ol.proj.EPSG3857.EXTENT,global:!0,worldExtent:ol.proj.EPSG3857.WORLD_EXTENT,getPointResolution:function(e,o){return e/ol.math.cosh(o[1]/ol.proj.EPSG3857.RADIUS)}})},ol.inherits(ol.proj.EPSG3857_,ol.proj.Projection),ol.proj.EPSG3857.RADIUS=6378137,ol.proj.EPSG3857.HALF_SIZE=Math.PI*ol.proj.EPSG3857.RADIUS,ol.proj.EPSG3857.EXTENT=[-ol.proj.EPSG3857.HALF_SIZE,-ol.proj.EPSG3857.HALF_SIZE,ol.proj.EPSG3857.HALF_SIZE,ol.proj.EPSG3857.HALF_SIZE],ol.proj.EPSG3857.WORLD_EXTENT=[-180,-85,180,85],ol.proj.EPSG3857.CODES=["EPSG:3857","EPSG:102100","EPSG:102113","EPSG:900913","urn:ogc:def:crs:EPSG:6.18:3:3857","urn:ogc:def:crs:EPSG::3857","http://www.opengis.net/gml/srs/epsg.xml#3857"],ol.proj.EPSG3857.PROJECTIONS=ol.proj.EPSG3857.CODES.map(function(e){return new ol.proj.EPSG3857_(e)}),ol.proj.EPSG3857.fromEPSG4326=function(e,o,t){var r=e.length,i=t>1?t:2,n=o;void 0===n&&(n=i>2?e.slice():new Array(r)),ol.DEBUG&&console.assert(n.length%i==0,"modulus of output.length with dimension should be 0");for(var l=ol.proj.EPSG3857.HALF_SIZE,a=0;a<r;a+=i){n[a]=l*e[a]/180;var s=ol.proj.EPSG3857.RADIUS*Math.log(Math.tan(Math.PI*(e[a+1]+90)/360));s>l?s=l:s<-l&&(s=-l),n[a+1]=s}return n},ol.proj.EPSG3857.toEPSG4326=function(e,o,t){var r=e.length,i=t>1?t:2,n=o;void 0===n&&(n=i>2?e.slice():new Array(r)),ol.DEBUG&&console.assert(n.length%i==0,"modulus of output.length with dimension should be 0");for(var l=0;l<r;l+=i)n[l]=180*e[l]/ol.proj.EPSG3857.HALF_SIZE,n[l+1]=360*Math.atan(Math.exp(e[l+1]/ol.proj.EPSG3857.RADIUS))/Math.PI-90;return n},goog.provide("ol.sphere.WGS84"),goog.require("ol.Sphere"),ol.sphere.WGS84=new ol.Sphere(6378137),goog.provide("ol.proj.EPSG4326"),goog.require("ol"),goog.require("ol.proj"),goog.require("ol.proj.Projection"),goog.require("ol.proj.Units"),goog.require("ol.sphere.WGS84"),ol.proj.EPSG4326_=function(e,o){ol.proj.Projection.call(this,{code:e,units:ol.proj.Units.DEGREES,extent:ol.proj.EPSG4326.EXTENT,axisOrientation:o,global:!0,metersPerUnit:ol.proj.EPSG4326.METERS_PER_UNIT,worldExtent:ol.proj.EPSG4326.EXTENT})},ol.inherits(ol.proj.EPSG4326_,ol.proj.Projection),ol.proj.EPSG4326.EXTENT=[-180,-90,180,90],ol.proj.EPSG4326.METERS_PER_UNIT=Math.PI*ol.sphere.WGS84.radius/180,ol.proj.EPSG4326.PROJECTIONS=[new ol.proj.EPSG4326_("CRS:84"),new ol.proj.EPSG4326_("EPSG:4326","neu"),new ol.proj.EPSG4326_("urn:ogc:def:crs:EPSG::4326","neu"),new ol.proj.EPSG4326_("urn:ogc:def:crs:EPSG:6.6:4326","neu"),new ol.proj.EPSG4326_("urn:ogc:def:crs:OGC:1.3:CRS84"),new ol.proj.EPSG4326_("urn:ogc:def:crs:OGC:2:84"),new ol.proj.EPSG4326_("http://www.opengis.net/gml/srs/epsg.xml#4326","neu"),new ol.proj.EPSG4326_("urn:x-ogc:def:crs:EPSG:4326","neu")],goog.provide("ol.proj.common"),goog.require("ol.proj"),goog.require("ol.proj.EPSG3857"),goog.require("ol.proj.EPSG4326"),ol.proj.common.add=function(){ol.proj.addEquivalentProjections(ol.proj.EPSG3857.PROJECTIONS),ol.proj.addEquivalentProjections(ol.proj.EPSG4326.PROJECTIONS),ol.proj.addEquivalentTransforms(ol.proj.EPSG4326.PROJECTIONS,ol.proj.EPSG3857.PROJECTIONS,ol.proj.EPSG3857.fromEPSG4326,ol.proj.EPSG3857.toEPSG4326)},goog.provide("ol.renderer.Type"),ol.renderer.Type={CANVAS:"canvas",WEBGL:"webgl"},goog.provide("ol.render.Event"),goog.require("ol"),goog.require("ol.events.Event"),ol.render.Event=function(e,o,t,r,i){ol.events.Event.call(this,e),this.vectorContext=o,this.frameState=t,this.context=r,this.glContext=i},ol.inherits(ol.render.Event,ol.events.Event),ol.render.Event.Type={POSTCOMPOSE:"postcompose",PRECOMPOSE:"precompose",RENDER:"render"},goog.provide("ol.layer.Layer"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol"),goog.require("ol.Object"),goog.require("ol.layer.Base"),goog.require("ol.obj"),goog.require("ol.render.Event"),goog.require("ol.source.State"),ol.layer.Layer=function(e){var o=ol.obj.assign({},e);delete o.source,ol.layer.Base.call(this,o),this.mapPrecomposeKey_=null,this.mapRenderKey_=null,this.sourceChangeKey_=null,e.map&&this.setMap(e.map),ol.events.listen(this,ol.Object.getChangeEventType(ol.layer.Base.Property.SOURCE),this.handleSourcePropertyChange_,this);var t=e.source?e.source:null;this.setSource(t)},ol.inherits(ol.layer.Layer,ol.layer.Base),ol.layer.Layer.visibleAtResolution=function(e,o){return e.visible&&o>=e.minResolution&&o<e.maxResolution},ol.layer.Layer.prototype.getLayersArray=function(e){var o=e||[];return o.push(this),o},ol.layer.Layer.prototype.getLayerStatesArray=function(e){var o=e||[];return o.push(this.getLayerState()),o},ol.layer.Layer.prototype.getSource=function(){return this.get(ol.layer.Base.Property.SOURCE)||null},ol.layer.Layer.prototype.getSourceState=function(){var e=this.getSource();return e?e.getState():ol.source.State.UNDEFINED},ol.layer.Layer.prototype.handleSourceChange_=function(){this.changed()},ol.layer.Layer.prototype.handleSourcePropertyChange_=function(){this.sourceChangeKey_&&(ol.events.unlistenByKey(this.sourceChangeKey_),this.sourceChangeKey_=null);var e=this.getSource();e&&(this.sourceChangeKey_=ol.events.listen(e,ol.events.EventType.CHANGE,this.handleSourceChange_,this)),this.changed()},ol.layer.Layer.prototype.setMap=function(e){this.mapPrecomposeKey_&&(ol.events.unlistenByKey(this.mapPrecomposeKey_),this.mapPrecomposeKey_=null),e||this.changed(),this.mapRenderKey_&&(ol.events.unlistenByKey(this.mapRenderKey_),this.mapRenderKey_=null),e&&(this.mapPrecomposeKey_=ol.events.listen(e,ol.render.Event.Type.PRECOMPOSE,function(e){var o=this.getLayerState();o.managed=!1,o.zIndex=1/0,e.frameState.layerStatesArray.push(o),e.frameState.layerStates[ol.getUid(this)]=o},this),this.mapRenderKey_=ol.events.listen(this,ol.events.EventType.CHANGE,e.render,e),this.changed())},ol.layer.Layer.prototype.setSource=function(e){this.set(ol.layer.Base.Property.SOURCE,e)},goog.provide("ol.style.IconImageCache"),goog.require("ol"),goog.require("ol.color"),ol.style.IconImageCache=function(){this.cache_={},this.cacheSize_=0,this.maxCacheSize_=32},ol.style.IconImageCache.getKey=function(e,o,t){return ol.DEBUG&&console.assert(void 0!==o,"argument crossOrigin must be defined"),o+":"+e+":"+(t?ol.color.asString(t):"null")},ol.style.IconImageCache.prototype.clear=function(){this.cache_={},this.cacheSize_=0},ol.style.IconImageCache.prototype.expire=function(){if(this.cacheSize_>this.maxCacheSize_){var e,o,t=0;for(e in this.cache_)o=this.cache_[e],0!=(3&t++)||o.hasListener()||(delete this.cache_[e],--this.cacheSize_)}},ol.style.IconImageCache.prototype.get=function(e,o,t){var r=ol.style.IconImageCache.getKey(e,o,t);return r in this.cache_?this.cache_[r]:null},ol.style.IconImageCache.prototype.set=function(e,o,t,r){var i=ol.style.IconImageCache.getKey(e,o,t);this.cache_[i]=r,++this.cacheSize_},goog.provide("ol.style"),goog.require("ol.style.IconImageCache"),ol.style.iconImageCache=new ol.style.IconImageCache,goog.provide("ol.transform"),goog.require("ol.asserts"),ol.transform.tmp_=new Array(6),ol.transform.create=function(){return[1,0,0,1,0,0]},ol.transform.reset=function(e){return ol.transform.set(e,1,0,0,1,0,0)},ol.transform.multiply=function(e,o){var t=e[0],r=e[1],i=e[2],n=e[3],l=e[4],a=e[5],s=o[0],p=o[1],g=o[2],c=o[3],u=o[4],y=o[5];return e[0]=t*s+i*p,e[1]=r*s+n*p,e[2]=t*g+i*c,e[3]=r*g+n*c,e[4]=t*u+i*y+l,e[5]=r*u+n*y+a,e},ol.transform.set=function(e,o,t,r,i,n,l){return e[0]=o,e[1]=t,e[2]=r,e[3]=i,e[4]=n,e[5]=l,e},ol.transform.setFromArray=function(e,o){return e[0]=o[0],e[1]=o[1],e[2]=o[2],e[3]=o[3],e[4]=o[4],e[5]=o[5],e},ol.transform.apply=function(e,o){var t=o[0],r=o[1];return o[0]=e[0]*t+e[2]*r+e[4],o[1]=e[1]*t+e[3]*r+e[5],o},ol.transform.rotate=function(e,o){var t=Math.cos(o),r=Math.sin(o);return ol.transform.multiply(e,ol.transform.set(ol.transform.tmp_,t,r,-r,t,0,0))},ol.transform.scale=function(e,o,t){return ol.transform.multiply(e,ol.transform.set(ol.transform.tmp_,o,0,0,t,0,0))},ol.transform.translate=function(e,o,t){return ol.transform.multiply(e,ol.transform.set(ol.transform.tmp_,1,0,0,1,o,t))},ol.transform.compose=function(e,o,t,r,i,n,l,a){var s=Math.sin(n),p=Math.cos(n);return e[0]=r*p,e[1]=i*s,e[2]=-r*s,e[3]=i*p,e[4]=l*r*p-a*r*s+o,e[5]=l*i*s+a*i*p+t,e},ol.transform.invert=function(e){var o=ol.transform.determinant(e);ol.asserts.assert(0!==o,32);var t=e[0],r=e[1],i=e[2],n=e[3],l=e[4],a=e[5];return e[0]=n/o,e[1]=-r/o,e[2]=-i/o,e[3]=t/o,e[4]=(i*a-n*l)/o,e[5]=-(t*a-r*l)/o,e},ol.transform.determinant=function(e){return e[0]*e[3]-e[1]*e[2]},goog.provide("ol.renderer.Map"),goog.require("ol"),goog.require("ol.Disposable"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.functions"),goog.require("ol.layer.Layer"),goog.require("ol.style"),goog.require("ol.transform"),ol.renderer.Map=function(e,o){ol.Disposable.call(this),this.map_=o,this.layerRenderers_={},this.layerRendererListeners_={}},ol.inherits(ol.renderer.Map,ol.Disposable),ol.renderer.Map.prototype.calculateMatrices2D=function(e){var o=e.viewState,t=e.coordinateToPixelTransform,r=e.pixelToCoordinateTransform;ol.DEBUG&&console.assert(t,"frameState has a coordinateToPixelTransform"),ol.transform.compose(t,e.size[0]/2,e.size[1]/2,1/o.resolution,-1/o.resolution,-o.rotation,-o.center[0],-o.center[1]),ol.transform.invert(ol.transform.setFromArray(r,t))},ol.renderer.Map.prototype.createLayerRenderer=function(e){},ol.renderer.Map.prototype.disposeInternal=function(){for(var e in this.layerRenderers_)this.layerRenderers_[e].dispose()},ol.renderer.Map.expireIconCache_=function(e,o){ol.style.iconImageCache.expire()},ol.renderer.Map.prototype.forEachFeatureAtCoordinate=function(e,o,t,r,i,n,l){function a(e,t){var n=ol.getUid(e).toString(),l=o.layerStates[ol.getUid(t)].managed;if(!(n in o.skippedFeatureUids)||l)return r.call(i,e,l?t:null)}var s,p=o.viewState,g=p.resolution,c=p.projection,u=e;if(c.canWrapX()){var y=c.getExtent(),d=ol.extent.getWidth(y),h=e[0];if(h<y[0]||h>y[2]){u=[h+d*Math.ceil((y[0]-h)/d),e[1]]}}var m,f=o.layerStatesArray,_=f.length;for(m=_-1;m>=0;--m){var E=f[m],v=E.layer;if(ol.layer.Layer.visibleAtResolution(E,g)&&n.call(l,v)){var S=this.getLayerRenderer(v);if(v.getSource()&&(s=S.forEachFeatureAtCoordinate(v.getSource().getWrapX()?u:e,o,t,a,i)),s)return s}}},ol.renderer.Map.prototype.forEachLayerAtPixel=function(e,o,t,r,i,n){},ol.renderer.Map.prototype.hasFeatureAtCoordinate=function(e,o,t,r,i){return void 0!==this.forEachFeatureAtCoordinate(e,o,t,ol.functions.TRUE,this,r,i)},ol.renderer.Map.prototype.getLayerRenderer=function(e){var o=ol.getUid(e).toString();if(o in this.layerRenderers_)return this.layerRenderers_[o];var t=this.createLayerRenderer(e);return this.layerRenderers_[o]=t,this.layerRendererListeners_[o]=ol.events.listen(t,ol.events.EventType.CHANGE,this.handleLayerRendererChange_,this),t},ol.renderer.Map.prototype.getLayerRendererByKey=function(e){return ol.DEBUG&&console.assert(e in this.layerRenderers_,"given layerKey (%s) exists in layerRenderers",e),this.layerRenderers_[e]},ol.renderer.Map.prototype.getLayerRenderers=function(){return this.layerRenderers_},ol.renderer.Map.prototype.getMap=function(){return this.map_},ol.renderer.Map.prototype.getType=function(){},ol.renderer.Map.prototype.handleLayerRendererChange_=function(){this.map_.render()},ol.renderer.Map.prototype.removeLayerRendererByKey_=function(e){ol.DEBUG&&console.assert(e in this.layerRenderers_,"given layerKey (%s) exists in layerRenderers",e);var o=this.layerRenderers_[e];return delete this.layerRenderers_[e],ol.DEBUG&&console.assert(e in this.layerRendererListeners_,"given layerKey (%s) exists in layerRendererListeners",e),ol.events.unlistenByKey(this.layerRendererListeners_[e]),delete this.layerRendererListeners_[e],o},ol.renderer.Map.prototype.renderFrame=ol.nullFunction,ol.renderer.Map.prototype.removeUnusedLayerRenderers_=function(e,o){var t;for(t in this.layerRenderers_)o&&t in o.layerStates||this.removeLayerRendererByKey_(t).dispose()},ol.renderer.Map.prototype.scheduleExpireIconCache=function(e){e.postRenderFunctions.push(ol.renderer.Map.expireIconCache_)},ol.renderer.Map.prototype.scheduleRemoveUnusedLayerRenderers=function(e){var o;for(o in this.layerRenderers_)if(!(o in e.layerStates))return void e.postRenderFunctions.push(this.removeUnusedLayerRenderers_.bind(this))},ol.renderer.Map.sortByZIndex=function(e,o){return e.zIndex-o.zIndex},goog.provide("ol.layer.Image"),goog.require("ol"),goog.require("ol.layer.Layer"),ol.layer.Image=function(e){var o=e||{};ol.layer.Layer.call(this,o)},ol.inherits(ol.layer.Image,ol.layer.Layer),ol.layer.Image.prototype.getSource,goog.provide("ol.layer.Tile"),goog.require("ol"),goog.require("ol.layer.Layer"),goog.require("ol.obj"),ol.layer.Tile=function(e){var o=e||{},t=ol.obj.assign({},o);delete t.preload,delete t.useInterimTilesOnError,ol.layer.Layer.call(this,t),this.setPreload(void 0!==o.preload?o.preload:0),this.setUseInterimTilesOnError(void 0===o.useInterimTilesOnError||o.useInterimTilesOnError)},ol.inherits(ol.layer.Tile,ol.layer.Layer),ol.layer.Tile.prototype.getPreload=function(){return this.get(ol.layer.Tile.Property.PRELOAD)};ol.layer.Tile.prototype.getSource,ol.layer.Tile.prototype.setPreload=function(e){this.set(ol.layer.Tile.Property.PRELOAD,e)},ol.layer.Tile.prototype.getUseInterimTilesOnError=function(){return this.get(ol.layer.Tile.Property.USE_INTERIM_TILES_ON_ERROR)},ol.layer.Tile.prototype.setUseInterimTilesOnError=function(e){this.set(ol.layer.Tile.Property.USE_INTERIM_TILES_ON_ERROR,e)},ol.layer.Tile.Property={PRELOAD:"preload",USE_INTERIM_TILES_ON_ERROR:"useInterimTilesOnError"},goog.provide("ol.ImageBase"),goog.require("ol"),goog.require("ol.events.EventTarget"),goog.require("ol.events.EventType"),ol.ImageBase=function(e,o,t,r,i){ol.events.EventTarget.call(this),this.attributions_=i,this.extent=e,this.pixelRatio_=t,this.resolution=o,this.state=r},ol.inherits(ol.ImageBase,ol.events.EventTarget),ol.ImageBase.prototype.changed=function(){this.dispatchEvent(ol.events.EventType.CHANGE)},ol.ImageBase.prototype.getAttributions=function(){return this.attributions_},ol.ImageBase.prototype.getExtent=function(){return this.extent},ol.ImageBase.prototype.getImage=function(e){},ol.ImageBase.prototype.getPixelRatio=function(){return this.pixelRatio_},ol.ImageBase.prototype.getResolution=function(){return ol.DEBUG&&console.assert(void 0!==this.resolution,"resolution not yet set"),this.resolution},ol.ImageBase.prototype.getState=function(){return this.state},ol.ImageBase.prototype.load=function(){},goog.provide("ol.Image"),goog.require("ol"),goog.require("ol.ImageBase"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.obj"),ol.Image=function(e,o,t,r,i,n,l){ol.ImageBase.call(this,e,o,t,ol.Image.State.IDLE,r),this.src_=i,this.image_=new Image,null!==n&&(this.image_.crossOrigin=n),this.imageByContext_={},this.imageListenerKeys_=null,this.state=ol.Image.State.IDLE,this.imageLoadFunction_=l},ol.inherits(ol.Image,ol.ImageBase),ol.Image.prototype.getImage=function(e){if(void 0!==e){var o,t=ol.getUid(e);return t in this.imageByContext_?this.imageByContext_[t]:(o=ol.obj.isEmpty(this.imageByContext_)?this.image_:this.image_.cloneNode(!1),this.imageByContext_[t]=o,o)}return this.image_},ol.Image.prototype.handleImageError_=function(){this.state=ol.Image.State.ERROR,this.unlistenImage_(),this.changed()},ol.Image.prototype.handleImageLoad_=function(){void 0===this.resolution&&(this.resolution=ol.extent.getHeight(this.extent)/this.image_.height),this.state=ol.Image.State.LOADED,this.unlistenImage_(),this.changed()},ol.Image.prototype.load=function(){this.state!=ol.Image.State.IDLE&&this.state!=ol.Image.State.ERROR||(this.state=ol.Image.State.LOADING,this.changed(),ol.DEBUG&&console.assert(!this.imageListenerKeys_,"this.imageListenerKeys_ should be null"),this.imageListenerKeys_=[ol.events.listenOnce(this.image_,ol.events.EventType.ERROR,this.handleImageError_,this),ol.events.listenOnce(this.image_,ol.events.EventType.LOAD,this.handleImageLoad_,this)],this.imageLoadFunction_(this,this.src_))},ol.Image.prototype.setImage=function(e){this.image_=e},ol.Image.prototype.unlistenImage_=function(){this.imageListenerKeys_.forEach(ol.events.unlistenByKey),this.imageListenerKeys_=null},ol.Image.State={IDLE:0,LOADING:1,LOADED:2,ERROR:3},goog.provide("ol.render.canvas"),ol.render.canvas.defaultFont="10px sans-serif",ol.render.canvas.defaultFillStyle=[0,0,0,1],ol.render.canvas.defaultLineCap="round",ol.render.canvas.defaultLineDash=[],ol.render.canvas.defaultLineJoin="round",ol.render.canvas.defaultMiterLimit=10,ol.render.canvas.defaultStrokeStyle=[0,0,0,1],ol.render.canvas.defaultTextAlign="center",ol.render.canvas.defaultTextBaseline="middle",ol.render.canvas.defaultLineWidth=1,ol.render.canvas.rotateAtOffset=function(e,o,t,r){0!==o&&(e.translate(t,r),e.rotate(o),e.translate(-t,-r))},goog.provide("ol.style.Image"),ol.style.Image=function(e){this.opacity_=e.opacity,this.rotateWithView_=e.rotateWithView,this.rotation_=e.rotation,this.scale_=e.scale,this.snapToPixel_=e.snapToPixel},ol.style.Image.prototype.getOpacity=function(){return this.opacity_},ol.style.Image.prototype.getRotateWithView=function(){return this.rotateWithView_},ol.style.Image.prototype.getRotation=function(){return this.rotation_},ol.style.Image.prototype.getScale=function(){return this.scale_},ol.style.Image.prototype.getSnapToPixel=function(){return this.snapToPixel_},ol.style.Image.prototype.getAnchor=function(){},ol.style.Image.prototype.getImage=function(e){},ol.style.Image.prototype.getHitDetectionImage=function(e){},ol.style.Image.prototype.getImageState=function(){},ol.style.Image.prototype.getImageSize=function(){},ol.style.Image.prototype.getHitDetectionImageSize=function(){},ol.style.Image.prototype.getOrigin=function(){},ol.style.Image.prototype.getSize=function(){},ol.style.Image.prototype.setOpacity=function(e){this.opacity_=e},ol.style.Image.prototype.setRotateWithView=function(e){this.rotateWithView_=e},ol.style.Image.prototype.setRotation=function(e){this.rotation_=e},ol.style.Image.prototype.setScale=function(e){this.scale_=e},ol.style.Image.prototype.setSnapToPixel=function(e){this.snapToPixel_=e},ol.style.Image.prototype.listenImageChange=function(e,o){},ol.style.Image.prototype.load=function(){},ol.style.Image.prototype.unlistenImageChange=function(e,o){},goog.provide("ol.style.RegularShape"),goog.require("ol"),goog.require("ol.colorlike"),goog.require("ol.dom"),goog.require("ol.has"),goog.require("ol.Image"),goog.require("ol.render.canvas"),goog.require("ol.style.Image"),ol.style.RegularShape=function(e){ol.DEBUG&&console.assert(void 0!==e.radius||void 0!==e.radius1,'must provide either "radius" or "radius1"'),this.checksums_=null,this.canvas_=null,this.hitDetectionCanvas_=null,this.fill_=void 0!==e.fill?e.fill:null,this.origin_=[0,0],this.points_=e.points,this.radius_=void 0!==e.radius?e.radius:e.radius1,this.radius2_=void 0!==e.radius2?e.radius2:this.radius_,this.angle_=void 0!==e.angle?e.angle:0,this.stroke_=void 0!==e.stroke?e.stroke:null,this.anchor_=null,this.size_=null,this.imageSize_=null,this.hitDetectionImageSize_=null,this.atlasManager_=e.atlasManager,this.render_(this.atlasManager_);var o=void 0===e.snapToPixel||e.snapToPixel,t=void 0!==e.rotateWithView&&e.rotateWithView;ol.style.Image.call(this,{opacity:1,rotateWithView:t,rotation:void 0!==e.rotation?e.rotation:0,scale:1,snapToPixel:o})},ol.inherits(ol.style.RegularShape,ol.style.Image),ol.style.RegularShape.prototype.clone=function(){var e=new ol.style.RegularShape({fill:this.getFill()?this.getFill().clone():void 0,points:this.getRadius2()!==this.getRadius()?this.getPoints()/2:this.getPoints(),radius:this.getRadius(),radius2:this.getRadius2(),angle:this.getAngle(),snapToPixel:this.getSnapToPixel(),stroke:this.getStroke()?this.getStroke().clone():void 0,rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),atlasManager:this.atlasManager_});return e.setOpacity(this.getOpacity()),e.setScale(this.getScale()),e},ol.style.RegularShape.prototype.getAnchor=function(){return this.anchor_},ol.style.RegularShape.prototype.getAngle=function(){return this.angle_},ol.style.RegularShape.prototype.getFill=function(){return this.fill_},ol.style.RegularShape.prototype.getHitDetectionImage=function(e){return this.hitDetectionCanvas_},ol.style.RegularShape.prototype.getImage=function(e){return this.canvas_},ol.style.RegularShape.prototype.getImageSize=function(){return this.imageSize_},ol.style.RegularShape.prototype.getHitDetectionImageSize=function(){return this.hitDetectionImageSize_},ol.style.RegularShape.prototype.getImageState=function(){return ol.Image.State.LOADED},ol.style.RegularShape.prototype.getOrigin=function(){return this.origin_},ol.style.RegularShape.prototype.getPoints=function(){return this.points_},ol.style.RegularShape.prototype.getRadius=function(){return this.radius_},ol.style.RegularShape.prototype.getRadius2=function(){return this.radius2_},ol.style.RegularShape.prototype.getSize=function(){return this.size_},ol.style.RegularShape.prototype.getStroke=function(){return this.stroke_},ol.style.RegularShape.prototype.listenImageChange=ol.nullFunction,ol.style.RegularShape.prototype.load=ol.nullFunction,ol.style.RegularShape.prototype.unlistenImageChange=ol.nullFunction,ol.style.RegularShape.prototype.render_=function(e){var o,t,r="",i="",n=0,l=null,a=0;this.stroke_&&(t=ol.colorlike.asColorLike(this.stroke_.getColor()),a=this.stroke_.getWidth(),void 0===a&&(a=ol.render.canvas.defaultLineWidth),l=this.stroke_.getLineDash(),ol.has.CANVAS_LINE_DASH||(l=null),i=this.stroke_.getLineJoin(),void 0===i&&(i=ol.render.canvas.defaultLineJoin),r=this.stroke_.getLineCap(),void 0===r&&(r=ol.render.canvas.defaultLineCap),void 0===(n=this.stroke_.getMiterLimit())&&(n=ol.render.canvas.defaultMiterLimit));var s=2*(this.radius_+a)+1,p={strokeStyle:t,strokeWidth:a,size:s,lineCap:r,lineDash:l,lineJoin:i,miterLimit:n};if(void 0===e){var g=ol.dom.createCanvasContext2D(s,s);this.canvas_=g.canvas,s=this.canvas_.width,o=s,this.draw_(p,g,0,0),this.createHitDetectionCanvas_(p)}else{s=Math.round(s);var c,u=!this.fill_;u&&(c=this.drawHitDetectionCanvas_.bind(this,p));var y=this.getChecksum(),d=e.add(y,s,s,this.draw_.bind(this,p),c);ol.DEBUG&&console.assert(d,"shape size is too large"),this.canvas_=d.image,this.origin_=[d.offsetX,d.offsetY],o=d.image.width,u?(this.hitDetectionCanvas_=d.hitImage,this.hitDetectionImageSize_=[d.hitImage.width,d.hitImage.height]):(this.hitDetectionCanvas_=this.canvas_,this.hitDetectionImageSize_=[o,o])}this.anchor_=[s/2,s/2],this.size_=[s,s],this.imageSize_=[o,o]},ol.style.RegularShape.prototype.draw_=function(e,o,t,r){var i,n,l;if(o.setTransform(1,0,0,1,0,0),o.translate(t,r),o.beginPath(),this.points_===1/0)o.arc(e.size/2,e.size/2,this.radius_,0,2*Math.PI,!0);else for(this.radius2_!==this.radius_&&(this.points_=2*this.points_),i=0;i<=this.points_;i++)n=2*i*Math.PI/this.points_-Math.PI/2+this.angle_,l=i%2==0?this.radius_:this.radius2_,o.lineTo(e.size/2+l*Math.cos(n),e.size/2+l*Math.sin(n));this.fill_&&(o.fillStyle=ol.colorlike.asColorLike(this.fill_.getColor()),o.fill()),this.stroke_&&(o.strokeStyle=e.strokeStyle,o.lineWidth=e.strokeWidth,e.lineDash&&o.setLineDash(e.lineDash),o.lineCap=e.lineCap,o.lineJoin=e.lineJoin,o.miterLimit=e.miterLimit,o.stroke()),o.closePath()},ol.style.RegularShape.prototype.createHitDetectionCanvas_=function(e){if(this.hitDetectionImageSize_=[e.size,e.size],this.fill_)return void(this.hitDetectionCanvas_=this.canvas_);var o=ol.dom.createCanvasContext2D(e.size,e.size);this.hitDetectionCanvas_=o.canvas,this.drawHitDetectionCanvas_(e,o,0,0)},ol.style.RegularShape.prototype.drawHitDetectionCanvas_=function(e,o,t,r){if(o.setTransform(1,0,0,1,0,0),o.translate(t,r),o.beginPath(),this.points_===1/0)o.arc(e.size/2,e.size/2,this.radius_,0,2*Math.PI,!0);else{this.radius2_!==this.radius_&&(this.points_=2*this.points_);var i,n,l;for(i=0;i<=this.points_;i++)l=2*i*Math.PI/this.points_-Math.PI/2+this.angle_,n=i%2==0?this.radius_:this.radius2_,o.lineTo(e.size/2+n*Math.cos(l),e.size/2+n*Math.sin(l))}o.fillStyle=ol.render.canvas.defaultFillStyle,o.fill(),this.stroke_&&(o.strokeStyle=e.strokeStyle,o.lineWidth=e.strokeWidth,e.lineDash&&o.setLineDash(e.lineDash),o.stroke()),o.closePath()},ol.style.RegularShape.prototype.getChecksum=function(){var e=this.stroke_?this.stroke_.getChecksum():"-",o=this.fill_?this.fill_.getChecksum():"-";if(!this.checksums_||e!=this.checksums_[1]||o!=this.checksums_[2]||this.radius_!=this.checksums_[3]||this.radius2_!=this.checksums_[4]||this.angle_!=this.checksums_[5]||this.points_!=this.checksums_[6]){var t="r"+e+o+(void 0!==this.radius_?this.radius_.toString():"-")+(void 0!==this.radius2_?this.radius2_.toString():"-")+(void 0!==this.angle_?this.angle_.toString():"-")+(void 0!==this.points_?this.points_.toString():"-");this.checksums_=[t,e,o,this.radius_,this.radius2_,this.angle_,this.points_]}return this.checksums_[0]},goog.provide("ol.style.Circle"),goog.require("ol"),goog.require("ol.style.RegularShape"),ol.style.Circle=function(e){var o=e||{};ol.style.RegularShape.call(this,{points:1/0,fill:o.fill,radius:o.radius,snapToPixel:o.snapToPixel,stroke:o.stroke,atlasManager:o.atlasManager})},ol.inherits(ol.style.Circle,ol.style.RegularShape),ol.style.Circle.prototype.clone=function(){var e=new ol.style.Circle({fill:this.getFill()?this.getFill().clone():void 0,stroke:this.getStroke()?this.getStroke().clone():void 0,radius:this.getRadius(),snapToPixel:this.getSnapToPixel(),atlasManager:this.atlasManager_});return e.setOpacity(this.getOpacity()),e.setScale(this.getScale()),e},ol.style.Circle.prototype.setRadius=function(e){this.radius_=e,this.render_(this.atlasManager_)},goog.provide("ol.style.Fill"),goog.require("ol"),goog.require("ol.color"),ol.style.Fill=function(e){var o=e||{};this.color_=void 0!==o.color?o.color:null,this.checksum_=void 0},ol.style.Fill.prototype.clone=function(){var e=this.getColor();return new ol.style.Fill({color:e&&e.slice?e.slice():e||void 0})},ol.style.Fill.prototype.getColor=function(){return this.color_},ol.style.Fill.prototype.setColor=function(e){this.color_=e,this.checksum_=void 0},ol.style.Fill.prototype.getChecksum=function(){return void 0===this.checksum_&&(this.color_ instanceof CanvasPattern||this.color_ instanceof CanvasGradient?this.checksum_=ol.getUid(this.color_).toString():this.checksum_="f"+(this.color_?ol.color.asString(this.color_):"-")),this.checksum_},goog.provide("ol.style.Stroke"),goog.require("ol"),ol.style.Stroke=function(e){var o=e||{};this.color_=void 0!==o.color?o.color:null,this.lineCap_=o.lineCap,this.lineDash_=void 0!==o.lineDash?o.lineDash:null,this.lineJoin_=o.lineJoin,this.miterLimit_=o.miterLimit,this.width_=o.width,this.checksum_=void 0},ol.style.Stroke.prototype.clone=function(){var e=this.getColor();return new ol.style.Stroke({color:e&&e.slice?e.slice():e||void 0,lineCap:this.getLineCap(),lineDash:this.getLineDash()?this.getLineDash().slice():void 0,lineJoin:this.getLineJoin(),miterLimit:this.getMiterLimit(),width:this.getWidth()})},ol.style.Stroke.prototype.getColor=function(){return this.color_},ol.style.Stroke.prototype.getLineCap=function(){return this.lineCap_},ol.style.Stroke.prototype.getLineDash=function(){return this.lineDash_},ol.style.Stroke.prototype.getLineJoin=function(){return this.lineJoin_},ol.style.Stroke.prototype.getMiterLimit=function(){return this.miterLimit_},ol.style.Stroke.prototype.getWidth=function(){return this.width_},ol.style.Stroke.prototype.setColor=function(e){this.color_=e,this.checksum_=void 0},ol.style.Stroke.prototype.setLineCap=function(e){this.lineCap_=e,this.checksum_=void 0},ol.style.Stroke.prototype.setLineDash=function(e){this.lineDash_=e,this.checksum_=void 0},ol.style.Stroke.prototype.setLineJoin=function(e){this.lineJoin_=e,this.checksum_=void 0},ol.style.Stroke.prototype.setMiterLimit=function(e){this.miterLimit_=e,this.checksum_=void 0},ol.style.Stroke.prototype.setWidth=function(e){this.width_=e,this.checksum_=void 0},ol.style.Stroke.prototype.getChecksum=function(){return void 0===this.checksum_&&(this.checksum_="s",this.color_?"string"==typeof this.color_?this.checksum_+=this.color_:this.checksum_+=ol.getUid(this.color_).toString():this.checksum_+="-",this.checksum_+=","+(void 0!==this.lineCap_?this.lineCap_.toString():"-")+","+(this.lineDash_?this.lineDash_.toString():"-")+","+(void 0!==this.lineJoin_?this.lineJoin_:"-")+","+(void 0!==this.miterLimit_?this.miterLimit_.toString():"-")+","+(void 0!==this.width_?this.width_.toString():"-")),this.checksum_},goog.provide("ol.style.Style"),goog.require("ol.asserts"),goog.require("ol.geom.GeometryType"),goog.require("ol.style.Circle"),goog.require("ol.style.Fill"),goog.require("ol.style.Stroke"),ol.style.Style=function(e){var o=e||{};this.geometry_=null,this.geometryFunction_=ol.style.Style.defaultGeometryFunction,void 0!==o.geometry&&this.setGeometry(o.geometry),this.fill_=void 0!==o.fill?o.fill:null,this.image_=void 0!==o.image?o.image:null,
this.stroke_=void 0!==o.stroke?o.stroke:null,this.text_=void 0!==o.text?o.text:null,this.zIndex_=o.zIndex},ol.style.Style.prototype.clone=function(){var e=this.getGeometry();return e&&e.clone&&(e=e.clone()),new ol.style.Style({geometry:e,fill:this.getFill()?this.getFill().clone():void 0,image:this.getImage()?this.getImage().clone():void 0,stroke:this.getStroke()?this.getStroke().clone():void 0,text:this.getText()?this.getText().clone():void 0,zIndex:this.getZIndex()})},ol.style.Style.prototype.getGeometry=function(){return this.geometry_},ol.style.Style.prototype.getGeometryFunction=function(){return this.geometryFunction_},ol.style.Style.prototype.getFill=function(){return this.fill_},ol.style.Style.prototype.setFill=function(e){this.fill_=e},ol.style.Style.prototype.getImage=function(){return this.image_},ol.style.Style.prototype.setImage=function(e){this.image_=e},ol.style.Style.prototype.getStroke=function(){return this.stroke_},ol.style.Style.prototype.setStroke=function(e){this.stroke_=e},ol.style.Style.prototype.getText=function(){return this.text_},ol.style.Style.prototype.setText=function(e){this.text_=e},ol.style.Style.prototype.getZIndex=function(){return this.zIndex_},ol.style.Style.prototype.setGeometry=function(e){"function"==typeof e?this.geometryFunction_=e:"string"==typeof e?this.geometryFunction_=function(o){return o.get(e)}:e?void 0!==e&&(this.geometryFunction_=function(){return e}):this.geometryFunction_=ol.style.Style.defaultGeometryFunction,this.geometry_=e},ol.style.Style.prototype.setZIndex=function(e){this.zIndex_=e},ol.style.Style.createFunction=function(e){var o;if("function"==typeof e)o=e;else{var t;Array.isArray(e)?t=e:(ol.asserts.assert(e instanceof ol.style.Style,41),t=[e]),o=function(){return t}}return o},ol.style.Style.default_=null,ol.style.Style.defaultFunction=function(e,o){if(!ol.style.Style.default_){var t=new ol.style.Fill({color:"rgba(255,255,255,0.4)"}),r=new ol.style.Stroke({color:"#3399CC",width:1.25});ol.style.Style.default_=[new ol.style.Style({image:new ol.style.Circle({fill:t,stroke:r,radius:5}),fill:t,stroke:r})]}return ol.style.Style.default_},ol.style.Style.createDefaultEditing=function(){var e={},o=[255,255,255,1],t=[0,153,255,1];return e[ol.geom.GeometryType.POLYGON]=[new ol.style.Style({fill:new ol.style.Fill({color:[255,255,255,.5]})})],e[ol.geom.GeometryType.MULTI_POLYGON]=e[ol.geom.GeometryType.POLYGON],e[ol.geom.GeometryType.LINE_STRING]=[new ol.style.Style({stroke:new ol.style.Stroke({color:o,width:5})}),new ol.style.Style({stroke:new ol.style.Stroke({color:t,width:3})})],e[ol.geom.GeometryType.MULTI_LINE_STRING]=e[ol.geom.GeometryType.LINE_STRING],e[ol.geom.GeometryType.CIRCLE]=e[ol.geom.GeometryType.POLYGON].concat(e[ol.geom.GeometryType.LINE_STRING]),e[ol.geom.GeometryType.POINT]=[new ol.style.Style({image:new ol.style.Circle({radius:6,fill:new ol.style.Fill({color:t}),stroke:new ol.style.Stroke({color:o,width:1.5})}),zIndex:1/0})],e[ol.geom.GeometryType.MULTI_POINT]=e[ol.geom.GeometryType.POINT],e[ol.geom.GeometryType.GEOMETRY_COLLECTION]=e[ol.geom.GeometryType.POLYGON].concat(e[ol.geom.GeometryType.LINE_STRING],e[ol.geom.GeometryType.POINT]),e},ol.style.Style.defaultGeometryFunction=function(e){return e.getGeometry()},goog.provide("ol.layer.Vector"),goog.require("ol"),goog.require("ol.layer.Layer"),goog.require("ol.obj"),goog.require("ol.style.Style"),ol.layer.Vector=function(e){var o=e||{};ol.DEBUG&&console.assert(void 0===o.renderOrder||!o.renderOrder||"function"==typeof o.renderOrder,"renderOrder must be a comparator function");var t=ol.obj.assign({},o);delete t.style,delete t.renderBuffer,delete t.updateWhileAnimating,delete t.updateWhileInteracting,ol.layer.Layer.call(this,t),this.renderBuffer_=void 0!==o.renderBuffer?o.renderBuffer:100,this.style_=null,this.styleFunction_=void 0,this.setStyle(o.style),this.updateWhileAnimating_=void 0!==o.updateWhileAnimating&&o.updateWhileAnimating,this.updateWhileInteracting_=void 0!==o.updateWhileInteracting&&o.updateWhileInteracting},ol.inherits(ol.layer.Vector,ol.layer.Layer),ol.layer.Vector.prototype.getRenderBuffer=function(){return this.renderBuffer_},ol.layer.Vector.prototype.getRenderOrder=function(){return this.get(ol.layer.Vector.Property.RENDER_ORDER)},ol.layer.Vector.prototype.getSource,ol.layer.Vector.prototype.getStyle=function(){return this.style_},ol.layer.Vector.prototype.getStyleFunction=function(){return this.styleFunction_},ol.layer.Vector.prototype.getUpdateWhileAnimating=function(){return this.updateWhileAnimating_},ol.layer.Vector.prototype.getUpdateWhileInteracting=function(){return this.updateWhileInteracting_},ol.layer.Vector.prototype.setRenderOrder=function(e){ol.DEBUG&&console.assert(void 0===e||!e||"function"==typeof e,"renderOrder must be a comparator function"),this.set(ol.layer.Vector.Property.RENDER_ORDER,e)},ol.layer.Vector.prototype.setStyle=function(e){this.style_=void 0!==e?e:ol.style.Style.defaultFunction,this.styleFunction_=null===e?void 0:ol.style.Style.createFunction(this.style_),this.changed()},ol.layer.Vector.Property={RENDER_ORDER:"renderOrder"},goog.provide("ol.layer.VectorTile"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.layer.Tile"),goog.require("ol.layer.Vector"),goog.require("ol.obj"),ol.layer.VectorTile=function(e){var o=e||{},t=ol.obj.assign({},o);delete t.preload,delete t.useInterimTilesOnError,ol.layer.Vector.call(this,t),this.setPreload(o.preload?o.preload:0),this.setUseInterimTilesOnError(!o.useInterimTilesOnError||o.useInterimTilesOnError),ol.asserts.assert(void 0==o.renderMode||o.renderMode==ol.layer.VectorTile.RenderType.IMAGE||o.renderMode==ol.layer.VectorTile.RenderType.HYBRID||o.renderMode==ol.layer.VectorTile.RenderType.VECTOR,28),this.renderMode_=o.renderMode||ol.layer.VectorTile.RenderType.HYBRID},ol.inherits(ol.layer.VectorTile,ol.layer.Vector),ol.layer.VectorTile.prototype.getPreload=function(){return this.get(ol.layer.VectorTile.Property.PRELOAD)},ol.layer.VectorTile.prototype.getRenderMode=function(){return this.renderMode_},ol.layer.VectorTile.prototype.getUseInterimTilesOnError=function(){return this.get(ol.layer.VectorTile.Property.USE_INTERIM_TILES_ON_ERROR)},ol.layer.VectorTile.prototype.setPreload=function(e){this.set(ol.layer.Tile.Property.PRELOAD,e)},ol.layer.VectorTile.prototype.setUseInterimTilesOnError=function(e){this.set(ol.layer.Tile.Property.USE_INTERIM_TILES_ON_ERROR,e)},ol.layer.VectorTile.Property={PRELOAD:"preload",USE_INTERIM_TILES_ON_ERROR:"useInterimTilesOnError"},ol.layer.VectorTile.RenderType={IMAGE:"image",HYBRID:"hybrid",VECTOR:"vector"},goog.provide("ol.render.VectorContext"),ol.render.VectorContext=function(){},ol.render.VectorContext.prototype.drawGeometry=function(e){},ol.render.VectorContext.prototype.setStyle=function(e){},ol.render.VectorContext.prototype.drawCircle=function(e,o){},ol.render.VectorContext.prototype.drawFeature=function(e,o){},ol.render.VectorContext.prototype.drawGeometryCollection=function(e,o){};ol.render.VectorContext.prototype.drawLineString=function(e,o){},ol.render.VectorContext.prototype.drawMultiLineString=function(e,o){},ol.render.VectorContext.prototype.drawMultiPoint=function(e,o){},ol.render.VectorContext.prototype.drawMultiPolygon=function(e,o){},ol.render.VectorContext.prototype.drawPoint=function(e,o){},ol.render.VectorContext.prototype.drawPolygon=function(e,o){},ol.render.VectorContext.prototype.drawText=function(e,o,t,r,i,n){},ol.render.VectorContext.prototype.setFillStrokeStyle=function(e,o){},ol.render.VectorContext.prototype.setImageStyle=function(e){},ol.render.VectorContext.prototype.setTextStyle=function(e){},goog.provide("ol.render.canvas.Immediate"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.colorlike"),goog.require("ol.extent"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.geom.flat.transform"),goog.require("ol.has"),goog.require("ol.render.VectorContext"),goog.require("ol.render.canvas"),goog.require("ol.transform"),ol.render.canvas.Immediate=function(e,o,t,r,i){ol.render.VectorContext.call(this),this.context_=e,this.pixelRatio_=o,this.extent_=t,this.transform_=r,this.viewRotation_=i,this.contextFillState_=null,this.contextStrokeState_=null,this.contextTextState_=null,this.fillState_=null,this.strokeState_=null,this.image_=null,this.imageAnchorX_=0,this.imageAnchorY_=0,this.imageHeight_=0,this.imageOpacity_=0,this.imageOriginX_=0,this.imageOriginY_=0,this.imageRotateWithView_=!1,this.imageRotation_=0,this.imageScale_=0,this.imageSnapToPixel_=!1,this.imageWidth_=0,this.text_="",this.textOffsetX_=0,this.textOffsetY_=0,this.textRotateWithView_=!1,this.textRotation_=0,this.textScale_=0,this.textFillState_=null,this.textStrokeState_=null,this.textState_=null,this.pixelCoordinates_=[],this.tmpLocalTransform_=ol.transform.create()},ol.inherits(ol.render.canvas.Immediate,ol.render.VectorContext),ol.render.canvas.Immediate.prototype.drawImages_=function(e,o,t,r){if(this.image_){ol.DEBUG&&console.assert(0===o,"offset should be 0"),ol.DEBUG&&console.assert(t==e.length,"end should be equal to the length of flatCoordinates");var i=ol.geom.flat.transform.transform2D(e,o,t,2,this.transform_,this.pixelCoordinates_),n=this.context_,l=this.tmpLocalTransform_,a=n.globalAlpha;1!=this.imageOpacity_&&(n.globalAlpha=a*this.imageOpacity_);var s=this.imageRotation_;this.imageRotateWithView_&&(s+=this.viewRotation_);var p,g;for(p=0,g=i.length;p<g;p+=2){var c=i[p]-this.imageAnchorX_,u=i[p+1]-this.imageAnchorY_;if(this.imageSnapToPixel_&&(c=Math.round(c),u=Math.round(u)),0!==s||1!=this.imageScale_){var y=c+this.imageAnchorX_,d=u+this.imageAnchorY_;ol.transform.compose(l,y,d,this.imageScale_,this.imageScale_,s,-y,-d),n.setTransform.apply(n,l)}n.drawImage(this.image_,this.imageOriginX_,this.imageOriginY_,this.imageWidth_,this.imageHeight_,c,u,this.imageWidth_,this.imageHeight_)}0===s&&1==this.imageScale_||n.setTransform(1,0,0,1,0,0),1!=this.imageOpacity_&&(n.globalAlpha=a)}},ol.render.canvas.Immediate.prototype.drawText_=function(e,o,t,r){if(this.textState_&&""!==this.text_){this.textFillState_&&this.setContextFillState_(this.textFillState_),this.textStrokeState_&&this.setContextStrokeState_(this.textStrokeState_),this.setContextTextState_(this.textState_),ol.DEBUG&&console.assert(0===o,"offset should be 0"),ol.DEBUG&&console.assert(t==e.length,"end should be equal to the length of flatCoordinates");var i=ol.geom.flat.transform.transform2D(e,o,t,r,this.transform_,this.pixelCoordinates_),n=this.context_,l=this.textRotation_;for(this.textRotateWithView_&&(l+=this.viewRotation_);o<t;o+=r){var a=i[o]+this.textOffsetX_,s=i[o+1]+this.textOffsetY_;if(0!==l||1!=this.textScale_){var p=ol.transform.compose(this.tmpLocalTransform_,a,s,this.textScale_,this.textScale_,l,-a,-s);n.setTransform.apply(n,p)}this.textStrokeState_&&n.strokeText(this.text_,a,s),this.textFillState_&&n.fillText(this.text_,a,s)}0===l&&1==this.textScale_||n.setTransform(1,0,0,1,0,0)}},ol.render.canvas.Immediate.prototype.moveToLineTo_=function(e,o,t,r,i){var n=this.context_,l=ol.geom.flat.transform.transform2D(e,o,t,r,this.transform_,this.pixelCoordinates_);n.moveTo(l[0],l[1]);var a=l.length;i&&(a-=2);for(var s=2;s<a;s+=2)n.lineTo(l[s],l[s+1]);return i&&n.closePath(),t},ol.render.canvas.Immediate.prototype.drawRings_=function(e,o,t,r){var i,n;for(i=0,n=t.length;i<n;++i)o=this.moveToLineTo_(e,o,t[i],r,!0);return o},ol.render.canvas.Immediate.prototype.drawCircle=function(e){if(ol.extent.intersects(this.extent_,e.getExtent())){if(this.fillState_||this.strokeState_){this.fillState_&&this.setContextFillState_(this.fillState_),this.strokeState_&&this.setContextStrokeState_(this.strokeState_);var o=ol.geom.SimpleGeometry.transform2D(e,this.transform_,this.pixelCoordinates_),t=o[2]-o[0],r=o[3]-o[1],i=Math.sqrt(t*t+r*r),n=this.context_;n.beginPath(),n.arc(o[0],o[1],i,0,2*Math.PI),this.fillState_&&n.fill(),this.strokeState_&&n.stroke()}""!==this.text_&&this.drawText_(e.getCenter(),0,2,2)}},ol.render.canvas.Immediate.prototype.setStyle=function(e){this.setFillStrokeStyle(e.getFill(),e.getStroke()),this.setImageStyle(e.getImage()),this.setTextStyle(e.getText())},ol.render.canvas.Immediate.prototype.drawGeometry=function(e){var o=e.getType();switch(o){case ol.geom.GeometryType.POINT:this.drawPoint(e);break;case ol.geom.GeometryType.LINE_STRING:this.drawLineString(e);break;case ol.geom.GeometryType.POLYGON:this.drawPolygon(e);break;case ol.geom.GeometryType.MULTI_POINT:this.drawMultiPoint(e);break;case ol.geom.GeometryType.MULTI_LINE_STRING:this.drawMultiLineString(e);break;case ol.geom.GeometryType.MULTI_POLYGON:this.drawMultiPolygon(e);break;case ol.geom.GeometryType.GEOMETRY_COLLECTION:this.drawGeometryCollection(e);break;case ol.geom.GeometryType.CIRCLE:this.drawCircle(e);break;default:ol.DEBUG&&console.assert(!1,"Unsupported geometry type: "+o)}},ol.render.canvas.Immediate.prototype.drawFeature=function(e,o){var t=o.getGeometryFunction()(e);t&&ol.extent.intersects(this.extent_,t.getExtent())&&(this.setStyle(o),this.drawGeometry(t))},ol.render.canvas.Immediate.prototype.drawGeometryCollection=function(e){var o,t,r=e.getGeometriesArray();for(o=0,t=r.length;o<t;++o)this.drawGeometry(r[o])},ol.render.canvas.Immediate.prototype.drawPoint=function(e){var o=e.getFlatCoordinates(),t=e.getStride();this.image_&&this.drawImages_(o,0,o.length,t),""!==this.text_&&this.drawText_(o,0,o.length,t)},ol.render.canvas.Immediate.prototype.drawMultiPoint=function(e){var o=e.getFlatCoordinates(),t=e.getStride();this.image_&&this.drawImages_(o,0,o.length,t),""!==this.text_&&this.drawText_(o,0,o.length,t)},ol.render.canvas.Immediate.prototype.drawLineString=function(e){if(ol.extent.intersects(this.extent_,e.getExtent())){if(this.strokeState_){this.setContextStrokeState_(this.strokeState_);var o=this.context_,t=e.getFlatCoordinates();o.beginPath(),this.moveToLineTo_(t,0,t.length,e.getStride(),!1),o.stroke()}if(""!==this.text_){var r=e.getFlatMidpoint();this.drawText_(r,0,2,2)}}},ol.render.canvas.Immediate.prototype.drawMultiLineString=function(e){var o=e.getExtent();if(ol.extent.intersects(this.extent_,o)){if(this.strokeState_){this.setContextStrokeState_(this.strokeState_);var t=this.context_,r=e.getFlatCoordinates(),i=0,n=e.getEnds(),l=e.getStride();t.beginPath();var a,s;for(a=0,s=n.length;a<s;++a)i=this.moveToLineTo_(r,i,n[a],l,!1);t.stroke()}if(""!==this.text_){var p=e.getFlatMidpoints();this.drawText_(p,0,p.length,2)}}},ol.render.canvas.Immediate.prototype.drawPolygon=function(e){if(ol.extent.intersects(this.extent_,e.getExtent())){if(this.strokeState_||this.fillState_){this.fillState_&&this.setContextFillState_(this.fillState_),this.strokeState_&&this.setContextStrokeState_(this.strokeState_);var o=this.context_;o.beginPath(),this.drawRings_(e.getOrientedFlatCoordinates(),0,e.getEnds(),e.getStride()),this.fillState_&&o.fill(),this.strokeState_&&o.stroke()}if(""!==this.text_){var t=e.getFlatInteriorPoint();this.drawText_(t,0,2,2)}}},ol.render.canvas.Immediate.prototype.drawMultiPolygon=function(e){if(ol.extent.intersects(this.extent_,e.getExtent())){if(this.strokeState_||this.fillState_){this.fillState_&&this.setContextFillState_(this.fillState_),this.strokeState_&&this.setContextStrokeState_(this.strokeState_);var o,t,r=this.context_,i=e.getOrientedFlatCoordinates(),n=0,l=e.getEndss(),a=e.getStride();for(r.beginPath(),o=0,t=l.length;o<t;++o){var s=l[o];n=this.drawRings_(i,n,s,a)}this.fillState_&&r.fill(),this.strokeState_&&r.stroke()}if(""!==this.text_){var p=e.getFlatInteriorPoints();this.drawText_(p,0,p.length,2)}}},ol.render.canvas.Immediate.prototype.setContextFillState_=function(e){var o=this.context_,t=this.contextFillState_;t?t.fillStyle!=e.fillStyle&&(t.fillStyle=o.fillStyle=e.fillStyle):(o.fillStyle=e.fillStyle,this.contextFillState_={fillStyle:e.fillStyle})},ol.render.canvas.Immediate.prototype.setContextStrokeState_=function(e){var o=this.context_,t=this.contextStrokeState_;t?(t.lineCap!=e.lineCap&&(t.lineCap=o.lineCap=e.lineCap),ol.has.CANVAS_LINE_DASH&&(ol.array.equals(t.lineDash,e.lineDash)||o.setLineDash(t.lineDash=e.lineDash)),t.lineJoin!=e.lineJoin&&(t.lineJoin=o.lineJoin=e.lineJoin),t.lineWidth!=e.lineWidth&&(t.lineWidth=o.lineWidth=e.lineWidth),t.miterLimit!=e.miterLimit&&(t.miterLimit=o.miterLimit=e.miterLimit),t.strokeStyle!=e.strokeStyle&&(t.strokeStyle=o.strokeStyle=e.strokeStyle)):(o.lineCap=e.lineCap,ol.has.CANVAS_LINE_DASH&&o.setLineDash(e.lineDash),o.lineJoin=e.lineJoin,o.lineWidth=e.lineWidth,o.miterLimit=e.miterLimit,o.strokeStyle=e.strokeStyle,this.contextStrokeState_={lineCap:e.lineCap,lineDash:e.lineDash,lineJoin:e.lineJoin,lineWidth:e.lineWidth,miterLimit:e.miterLimit,strokeStyle:e.strokeStyle})},ol.render.canvas.Immediate.prototype.setContextTextState_=function(e){var o=this.context_,t=this.contextTextState_;t?(t.font!=e.font&&(t.font=o.font=e.font),t.textAlign!=e.textAlign&&(t.textAlign=o.textAlign=e.textAlign),t.textBaseline!=e.textBaseline&&(t.textBaseline=o.textBaseline=e.textBaseline)):(o.font=e.font,o.textAlign=e.textAlign,o.textBaseline=e.textBaseline,this.contextTextState_={font:e.font,textAlign:e.textAlign,textBaseline:e.textBaseline})},ol.render.canvas.Immediate.prototype.setFillStrokeStyle=function(e,o){if(e){var t=e.getColor();this.fillState_={fillStyle:ol.colorlike.asColorLike(t||ol.render.canvas.defaultFillStyle)}}else this.fillState_=null;if(o){var r=o.getColor(),i=o.getLineCap(),n=o.getLineDash(),l=o.getLineJoin(),a=o.getWidth(),s=o.getMiterLimit();this.strokeState_={lineCap:void 0!==i?i:ol.render.canvas.defaultLineCap,lineDash:n||ol.render.canvas.defaultLineDash,lineJoin:void 0!==l?l:ol.render.canvas.defaultLineJoin,lineWidth:this.pixelRatio_*(void 0!==a?a:ol.render.canvas.defaultLineWidth),miterLimit:void 0!==s?s:ol.render.canvas.defaultMiterLimit,strokeStyle:ol.colorlike.asColorLike(r||ol.render.canvas.defaultStrokeStyle)}}else this.strokeState_=null},ol.render.canvas.Immediate.prototype.setImageStyle=function(e){if(e){var o=e.getAnchor(),t=e.getImage(1),r=e.getOrigin(),i=e.getSize();ol.DEBUG&&console.assert(t,"imageImage must be truthy"),this.imageAnchorX_=o[0],this.imageAnchorY_=o[1],this.imageHeight_=i[1],this.image_=t,this.imageOpacity_=e.getOpacity(),this.imageOriginX_=r[0],this.imageOriginY_=r[1],this.imageRotateWithView_=e.getRotateWithView(),this.imageRotation_=e.getRotation(),this.imageScale_=e.getScale(),this.imageSnapToPixel_=e.getSnapToPixel(),this.imageWidth_=i[0]}else this.image_=null},ol.render.canvas.Immediate.prototype.setTextStyle=function(e){if(e){var o=e.getFill();if(o){var t=o.getColor();this.textFillState_={fillStyle:ol.colorlike.asColorLike(t||ol.render.canvas.defaultFillStyle)}}else this.textFillState_=null;var r=e.getStroke();if(r){var i=r.getColor(),n=r.getLineCap(),l=r.getLineDash(),a=r.getLineJoin(),s=r.getWidth(),p=r.getMiterLimit();this.textStrokeState_={lineCap:void 0!==n?n:ol.render.canvas.defaultLineCap,lineDash:l||ol.render.canvas.defaultLineDash,lineJoin:void 0!==a?a:ol.render.canvas.defaultLineJoin,lineWidth:void 0!==s?s:ol.render.canvas.defaultLineWidth,miterLimit:void 0!==p?p:ol.render.canvas.defaultMiterLimit,strokeStyle:ol.colorlike.asColorLike(i||ol.render.canvas.defaultStrokeStyle)}}else this.textStrokeState_=null;var g=e.getFont(),c=e.getOffsetX(),u=e.getOffsetY(),y=e.getRotateWithView(),d=e.getRotation(),h=e.getScale(),m=e.getText(),f=e.getTextAlign(),_=e.getTextBaseline();this.textState_={font:void 0!==g?g:ol.render.canvas.defaultFont,textAlign:void 0!==f?f:ol.render.canvas.defaultTextAlign,textBaseline:void 0!==_?_:ol.render.canvas.defaultTextBaseline},this.text_=void 0!==m?m:"",this.textOffsetX_=void 0!==c?this.pixelRatio_*c:0,this.textOffsetY_=void 0!==u?this.pixelRatio_*u:0,this.textRotateWithView_=void 0!==y&&y,this.textRotation_=void 0!==d?d:0,this.textScale_=this.pixelRatio_*(void 0!==h?h:1)}else this.text_=""},goog.provide("ol.renderer.Layer"),goog.require("ol"),goog.require("ol.Image"),goog.require("ol.Observable"),goog.require("ol.Tile"),goog.require("ol.asserts"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.functions"),goog.require("ol.source.State"),ol.renderer.Layer=function(e){ol.Observable.call(this),this.layer_=e},ol.inherits(ol.renderer.Layer,ol.Observable),ol.renderer.Layer.prototype.forEachFeatureAtCoordinate=ol.nullFunction,ol.renderer.Layer.prototype.hasFeatureAtCoordinate=ol.functions.FALSE,ol.renderer.Layer.prototype.createLoadedTileFinder=function(e,o,t){return function(r,i){function n(e){t[r]||(t[r]={}),t[r][e.tileCoord.toString()]=e}return e.forEachLoadedTile(o,r,i,n)}},ol.renderer.Layer.prototype.getLayer=function(){return this.layer_},ol.renderer.Layer.prototype.handleImageChange_=function(e){e.target.getState()===ol.Image.State.LOADED&&this.renderIfReadyAndVisible()},ol.renderer.Layer.prototype.loadImage=function(e){var o=e.getState();return o!=ol.Image.State.LOADED&&o!=ol.Image.State.ERROR&&(ol.DEBUG&&console.assert(o==ol.Image.State.IDLE||o==ol.Image.State.LOADING,'imageState is "idle" or "loading"'),ol.events.listen(e,ol.events.EventType.CHANGE,this.handleImageChange_,this)),o==ol.Image.State.IDLE&&(e.load(),o=e.getState(),ol.DEBUG&&console.assert(o==ol.Image.State.LOADING||o==ol.Image.State.LOADED,'imageState is "loading" or "loaded"')),o==ol.Image.State.LOADED},ol.renderer.Layer.prototype.renderIfReadyAndVisible=function(){var e=this.getLayer();e.getVisible()&&e.getSourceState()==ol.source.State.READY&&this.changed()},ol.renderer.Layer.prototype.scheduleExpireCache=function(e,o){if(o.canExpireCache()){var t=function(e,o,t){var r=ol.getUid(e).toString();e.expireCache(t.viewState.projection,t.usedTiles[r])}.bind(null,o);e.postRenderFunctions.push(t)}},ol.renderer.Layer.prototype.updateAttributions=function(e,o){if(o){var t,r,i;for(r=0,i=o.length;r<i;++r)t=o[r],e[ol.getUid(t).toString()]=t}},ol.renderer.Layer.prototype.updateLogos=function(e,o){var t=o.getLogo();void 0!==t&&("string"==typeof t?e.logos[t]="":t&&(ol.asserts.assert("string"==typeof t.href,44),ol.asserts.assert("string"==typeof t.src,45),e.logos[t.src]=t.href))},ol.renderer.Layer.prototype.updateUsedTiles=function(e,o,t,r){var i=ol.getUid(o).toString(),n=t.toString();i in e?n in e[i]?e[i][n].extend(r):e[i][n]=r:(e[i]={},e[i][n]=r)},ol.renderer.Layer.prototype.manageTilePyramid=function(e,o,t,r,i,n,l,a,s,p){var g=ol.getUid(o).toString();g in e.wantedTiles||(e.wantedTiles[g]={});var c,u,y,d,h,m,f=e.wantedTiles[g],_=e.tileQueue,E=t.getMinZoom();for(m=l;m>=E;--m)for(u=t.getTileRangeForExtentAndZ(n,m,u),y=t.getResolution(m),d=u.minX;d<=u.maxX;++d)for(h=u.minY;h<=u.maxY;++h)l-m<=a?(c=o.getTile(m,d,h,r,i),c.getState()==ol.Tile.State.IDLE&&(f[c.getKey()]=!0,_.isKeyQueued(c.getKey())||_.enqueue([c,g,t.getTileCoordCenter(c.tileCoord),y])),void 0!==s&&s.call(p,c)):o.useTile(m,d,h,i)},goog.provide("ol.renderer.canvas.Layer"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.functions"),goog.require("ol.render.Event"),goog.require("ol.render.canvas"),goog.require("ol.render.canvas.Immediate"),goog.require("ol.renderer.Layer"),goog.require("ol.transform"),ol.renderer.canvas.Layer=function(e){ol.renderer.Layer.call(this,e),this.renderedResolution,this.transform_=ol.transform.create()},ol.inherits(ol.renderer.canvas.Layer,ol.renderer.Layer),ol.renderer.canvas.Layer.prototype.clip=function(e,o,t){var r=o.pixelRatio,i=o.size[0]*r,n=o.size[1]*r,l=o.viewState.rotation,a=ol.extent.getTopLeft(t),s=ol.extent.getTopRight(t),p=ol.extent.getBottomRight(t),g=ol.extent.getBottomLeft(t);ol.transform.apply(o.coordinateToPixelTransform,a),ol.transform.apply(o.coordinateToPixelTransform,s),ol.transform.apply(o.coordinateToPixelTransform,p),ol.transform.apply(o.coordinateToPixelTransform,g),e.save(),ol.render.canvas.rotateAtOffset(e,-l,i/2,n/2),e.beginPath(),e.moveTo(a[0]*r,a[1]*r),e.lineTo(s[0]*r,s[1]*r),e.lineTo(p[0]*r,p[1]*r),e.lineTo(g[0]*r,g[1]*r),e.clip(),ol.render.canvas.rotateAtOffset(e,l,i/2,n/2)},ol.renderer.canvas.Layer.prototype.dispatchComposeEvent_=function(e,o,t,r){var i=this.getLayer();if(i.hasListener(e)){var n=t.size[0]*t.pixelRatio,l=t.size[1]*t.pixelRatio,a=t.viewState.rotation;ol.render.canvas.rotateAtOffset(o,-a,n/2,l/2);var s=void 0!==r?r:this.getTransform(t,0),p=new ol.render.canvas.Immediate(o,t.pixelRatio,t.extent,s,t.viewState.rotation),g=new ol.render.Event(e,p,t,o,null);i.dispatchEvent(g),ol.render.canvas.rotateAtOffset(o,a,n/2,l/2)}},ol.renderer.canvas.Layer.prototype.forEachLayerAtCoordinate=function(e,o,t,r){return this.forEachFeatureAtCoordinate(e,o,0,ol.functions.TRUE,this)?t.call(r,this.getLayer(),null):void 0},ol.renderer.canvas.Layer.prototype.postCompose=function(e,o,t,r){this.dispatchComposeEvent_(ol.render.Event.Type.POSTCOMPOSE,e,o,r)},ol.renderer.canvas.Layer.prototype.preCompose=function(e,o,t){this.dispatchComposeEvent_(ol.render.Event.Type.PRECOMPOSE,e,o,t)},ol.renderer.canvas.Layer.prototype.dispatchRenderEvent=function(e,o,t){this.dispatchComposeEvent_(ol.render.Event.Type.RENDER,e,o,t)},ol.renderer.canvas.Layer.prototype.getTransform=function(e,o){var t=e.viewState,r=e.pixelRatio,i=r*e.size[0]/2,n=r*e.size[1]/2,l=r/t.resolution,a=-l,s=-t.rotation,p=-t.center[0]+o,g=-t.center[1];return ol.transform.compose(this.transform_,i,n,l,a,s,p,g)},ol.renderer.canvas.Layer.prototype.composeFrame=function(e,o,t){},ol.renderer.canvas.Layer.prototype.prepareFrame=function(e,o){},goog.provide("ol.renderer.canvas.IntermediateCanvas"),goog.require("ol"),goog.require("ol.coordinate"),goog.require("ol.dom"),goog.require("ol.renderer.canvas.Layer"),goog.require("ol.transform"),ol.renderer.canvas.IntermediateCanvas=function(e){ol.renderer.canvas.Layer.call(this,e),this.coordinateToCanvasPixelTransform=ol.transform.create(),this.hitCanvasContext_=null,this.renderedResolution},ol.inherits(ol.renderer.canvas.IntermediateCanvas,ol.renderer.canvas.Layer),ol.renderer.canvas.IntermediateCanvas.prototype.composeFrame=function(e,o,t){this.preCompose(t,e);var r=this.getImage();if(r){var i=o.extent,n=void 0!==i;n&&this.clip(t,e,i);var l=this.getImageTransform(),a=t.globalAlpha;t.globalAlpha=o.opacity;var s=l[4],p=l[5],g=r.width*l[0],c=r.height*l[3];t.drawImage(r,0,0,+r.width,+r.height,Math.round(s),Math.round(p),Math.round(g),Math.round(c)),t.globalAlpha=a,n&&t.restore()}this.postCompose(t,e,o)},ol.renderer.canvas.IntermediateCanvas.prototype.getImage=function(){},ol.renderer.canvas.IntermediateCanvas.prototype.getImageTransform=function(){},ol.renderer.canvas.IntermediateCanvas.prototype.forEachFeatureAtCoordinate=function(e,o,t,r,i){var n=this.getLayer(),l=n.getSource(),a=o.viewState.resolution,s=o.viewState.rotation,p=o.skippedFeatureUids;return l.forEachFeatureAtCoordinate(e,a,s,t,p,function(e){return r.call(i,e,n)})},ol.renderer.canvas.IntermediateCanvas.prototype.forEachLayerAtCoordinate=function(e,o,t,r){if(this.getImage()){if(this.getLayer().getSource().forEachFeatureAtCoordinate!==ol.nullFunction)return ol.renderer.canvas.Layer.prototype.forEachLayerAtCoordinate.apply(this,arguments);var i=ol.transform.apply(this.coordinateToCanvasPixelTransform,e.slice());ol.coordinate.scale(i,o.viewState.resolution/this.renderedResolution),this.hitCanvasContext_||(this.hitCanvasContext_=ol.dom.createCanvasContext2D(1,1)),this.hitCanvasContext_.clearRect(0,0,1,1),this.hitCanvasContext_.drawImage(this.getImage(),i[0],i[1],1,1,0,0,1,1);var n=this.hitCanvasContext_.getImageData(0,0,1,1).data;return n[3]>0?t.call(r,this.getLayer(),n):void 0}},goog.provide("ol.renderer.canvas.ImageLayer"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.extent"),goog.require("ol.proj"),goog.require("ol.renderer.canvas.IntermediateCanvas"),goog.require("ol.transform"),ol.renderer.canvas.ImageLayer=function(e){ol.renderer.canvas.IntermediateCanvas.call(this,e),this.image_=null,this.imageTransform_=ol.transform.create()},ol.inherits(ol.renderer.canvas.ImageLayer,ol.renderer.canvas.IntermediateCanvas),ol.renderer.canvas.ImageLayer.prototype.getImage=function(){return this.image_?this.image_.getImage():null},ol.renderer.canvas.ImageLayer.prototype.getImageTransform=function(){return this.imageTransform_},ol.renderer.canvas.ImageLayer.prototype.prepareFrame=function(e,o){var t,r=e.pixelRatio,i=e.size,n=e.viewState,l=n.center,a=n.resolution,s=this.getLayer(),p=s.getSource(),g=e.viewHints,c=e.extent;if(void 0!==o.extent&&(c=ol.extent.getIntersection(c,o.extent)),!g[ol.View.Hint.ANIMATING]&&!g[ol.View.Hint.INTERACTING]&&!ol.extent.isEmpty(c)){var u=n.projection;if(!ol.ENABLE_RASTER_REPROJECTION){var y=p.getProjection();y&&(ol.DEBUG&&console.assert(ol.proj.equivalent(u,y),"projection and sourceProjection are equivalent"),u=y)}if(t=p.getImage(c,a,r,u)){this.loadImage(t)&&(this.image_=t,this.renderedResolution=a)}}if(this.image_){t=this.image_;var d=t.getExtent(),h=t.getResolution(),m=t.getPixelRatio(),f=r*h/(a*m),_=ol.transform.compose(this.imageTransform_,r*i[0]/2,r*i[1]/2,f,f,0,m*(d[0]-l[0])/h,m*(l[1]-d[3])/h);ol.transform.compose(this.coordinateToCanvasPixelTransform,r*i[0]/2-_[4],r*i[1]/2-_[5],r/a,-r/a,0,-l[0],-l[1]),this.updateAttributions(e.attributions,t.getAttributions()),this.updateLogos(e,p)}return!!this.image_},goog.provide("ol.renderer.canvas.TileLayer"),goog.require("ol"),goog.require("ol.transform"),goog.require("ol.TileRange"),goog.require("ol.Tile"),goog.require("ol.array"),goog.require("ol.dom"),goog.require("ol.extent"),goog.require("ol.renderer.canvas.IntermediateCanvas"),ol.renderer.canvas.TileLayer=function(e){ol.renderer.canvas.IntermediateCanvas.call(this,e),this.context=ol.dom.createCanvasContext2D(),this.renderedExtent_=null,this.renderedRevision_,this.renderedTiles=[],this.tmpExtent=ol.extent.createEmpty(),this.tmpTileCoord_=[0,0,0],this.tmpTileRange_=new ol.TileRange(0,0,0,0),this.imageTransform_=ol.transform.create(),this.zDirection=0},ol.inherits(ol.renderer.canvas.TileLayer,ol.renderer.canvas.IntermediateCanvas),ol.renderer.canvas.TileLayer.prototype.prepareFrame=function(e,o){var t=e.pixelRatio,r=e.size,i=e.viewState,n=i.projection,l=i.resolution,a=i.center,s=this.getLayer(),p=s.getSource(),g=p.getRevision(),c=p.getTileGridForProjection(n),u=c.getZForResolution(l,this.zDirection),y=c.getResolution(u),d=e.extent;if(void 0!==o.extent&&(d=ol.extent.getIntersection(d,o.extent)),ol.extent.isEmpty(d))return!1;var h=c.getTileRangeForExtentAndResolution(d,y),m=c.getTileRangeExtent(u,h),f=p.getTilePixelRatio(t),_={};_[u]={};var E,v,S,x=this.createLoadedTileFinder(p,n,_),P=s.getUseInterimTilesOnError(),T=this.tmpExtent,R=this.tmpTileRange_,L=!1;for(v=h.minX;v<=h.maxX;++v)for(S=h.minY;S<=h.maxY;++S){E=p.getTile(u,v,S,t,n);var M=E.getState(),C=M==ol.Tile.State.LOADED||M==ol.Tile.State.EMPTY||M==ol.Tile.State.ERROR&&!P;if(C)M==ol.Tile.State.LOADED&&(_[u][E.tileCoord.toString()]=E,L||-1!=this.renderedTiles.indexOf(E)||(L=!0));else{E=E.getInterimTile();var I=c.forEachTileCoordParentTileRange(E.tileCoord,x,null,R,T);if(!I){var b=c.getTileCoordChildTileRange(E.tileCoord,R,T);b&&x(u+1,b)}}}var O=e.viewHints;if(!(this.renderedResolution&&Date.now()-e.time>16&&(O[ol.View.Hint.ANIMATING]||O[ol.View.Hint.INTERACTING]))&&(L||!this.renderedExtent_||!ol.extent.equals(this.renderedExtent_,m)||this.renderedRevision_!=g)){var A=p.getTilePixelSize(u,t,n),N=h.getWidth()*A[0],G=h.getHeight()*A[0],D=this.context,w=D.canvas,F=p.getOpaque(n);w.width!=N||w.height!=G?(w.width=N,w.height=G):D.clearRect(0,0,N,G),this.renderedTiles.length=0;var U=Object.keys(_).map(Number);U.sort(ol.array.numberSafeCompareFunction);var B,q,k,j,W,V,K,X,Y,Z,H;for(W=0,V=U.length;W<V;++W){j=U[W],k=p.getTilePixelSize(j,t,n),B=c.getResolution(j),q=B/y,X=f*p.getGutter(n),Y=_[j];for(var z in Y)E=Y[z],K=c.getTileCoordExtent(E.getTileCoord(),T),v=(K[0]-m[0])/y*f,S=(m[3]-K[3])/y*f,Z=k[0]*q,H=k[1]*q,F||D.clearRect(v,S,Z,H),this.drawTileImage(E,e,o,v,S,Z,H,X),this.renderedTiles.push(E)}this.renderedRevision_=g,this.renderedResolution=y,this.renderedExtent_=m}
var J=t/f*this.renderedResolution/l,Q=ol.transform.compose(this.imageTransform_,t*r[0]/2,t*r[1]/2,J,J,0,f*(this.renderedExtent_[0]-a[0])/this.renderedResolution,f*(a[1]-this.renderedExtent_[3])/this.renderedResolution);return ol.transform.compose(this.coordinateToCanvasPixelTransform,t*r[0]/2-Q[4],t*r[1]/2-Q[5],t/l,-t/l,0,-a[0],-a[1]),this.updateUsedTiles(e.usedTiles,p,u,h),this.manageTilePyramid(e,p,c,t,n,d,u,s.getPreload()),this.scheduleExpireCache(e,p),this.updateLogos(e,p),this.renderedTiles.length>0},ol.renderer.canvas.TileLayer.prototype.drawTileImage=function(e,o,t,r,i,n,l,a){var s=e.getImage();s&&this.context.drawImage(s,a,a,s.width-2*a,s.height-2*a,r,i,n,l)},ol.renderer.canvas.TileLayer.prototype.getImage=function(){return this.context.canvas},ol.renderer.canvas.TileLayer.prototype.getLayer,ol.renderer.canvas.TileLayer.prototype.getImageTransform=function(){return this.imageTransform_},goog.provide("ol.render.ReplayGroup"),ol.render.ReplayGroup=function(){},ol.render.ReplayGroup.prototype.getReplay=function(e,o){},ol.render.ReplayGroup.prototype.isEmpty=function(){},goog.provide("ol.render.canvas.Instruction"),ol.render.canvas.Instruction={BEGIN_GEOMETRY:0,BEGIN_PATH:1,CIRCLE:2,CLOSE_PATH:3,DRAW_IMAGE:4,DRAW_TEXT:5,END_GEOMETRY:6,FILL:7,MOVE_TO_LINE_TO:8,SET_FILL_STYLE:9,SET_STROKE_STYLE:10,SET_TEXT_STYLE:11,STROKE:12},goog.provide("ol.render.canvas.Replay"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.colorlike"),goog.require("ol.extent"),goog.require("ol.extent.Relationship"),goog.require("ol.geom.flat.transform"),goog.require("ol.has"),goog.require("ol.obj"),goog.require("ol.render.VectorContext"),goog.require("ol.render.canvas"),goog.require("ol.render.canvas.Instruction"),goog.require("ol.transform"),ol.render.canvas.Replay=function(e,o,t,r){ol.render.VectorContext.call(this),this.tolerance=e,this.maxExtent=o,this.overlaps=r,this.maxLineWidth=0,this.resolution=t,this.fillOrigin_,this.beginGeometryInstruction1_=null,this.beginGeometryInstruction2_=null,this.instructions=[],this.coordinates=[],this.renderedTransform_=ol.transform.create(),this.hitDetectionInstructions=[],this.pixelCoordinates_=[],this.tmpLocalTransform_=ol.transform.create(),this.resetTransform_=ol.transform.create()},ol.inherits(ol.render.canvas.Replay,ol.render.VectorContext),ol.render.canvas.Replay.prototype.appendFlatCoordinates=function(e,o,t,r,i,n){var l=this.coordinates.length,a=this.getBufferedMaxExtent();n&&(o+=r);var s,p,g,c=[e[o],e[o+1]],u=[NaN,NaN],y=!0;for(s=o+r;s<t;s+=r)u[0]=e[s],u[1]=e[s+1],g=ol.extent.coordinateRelationship(a,u),g!==p?(y&&(this.coordinates[l++]=c[0],this.coordinates[l++]=c[1]),this.coordinates[l++]=u[0],this.coordinates[l++]=u[1],y=!1):g===ol.extent.Relationship.INTERSECTING?(this.coordinates[l++]=u[0],this.coordinates[l++]=u[1],y=!1):y=!0,c[0]=u[0],c[1]=u[1],p=g;return(i&&y||s===o+r)&&(this.coordinates[l++]=c[0],this.coordinates[l++]=c[1]),l},ol.render.canvas.Replay.prototype.beginGeometry=function(e,o){this.beginGeometryInstruction1_=[ol.render.canvas.Instruction.BEGIN_GEOMETRY,o,0],this.instructions.push(this.beginGeometryInstruction1_),this.beginGeometryInstruction2_=[ol.render.canvas.Instruction.BEGIN_GEOMETRY,o,0],this.hitDetectionInstructions.push(this.beginGeometryInstruction2_)},ol.render.canvas.Replay.prototype.fill_=function(e,o){if(this.fillOrigin_){var t=ol.transform.apply(this.renderedTransform_,this.fillOrigin_.slice());e.translate(t[0],t[1]),e.rotate(o)}e.fill(),this.fillOrigin_&&e.setTransform.apply(e,this.resetTransform_)},ol.render.canvas.Replay.prototype.replay_=function(e,o,t,r,i,n,l,a){var s;ol.array.equals(t,this.renderedTransform_)?s=this.pixelCoordinates_:(s=ol.geom.flat.transform.transform2D(this.coordinates,0,this.coordinates.length,2,t,this.pixelCoordinates_),ol.transform.setFromArray(this.renderedTransform_,t),ol.DEBUG&&console.assert(s===this.pixelCoordinates_,"pixelCoordinates should be the same as this.pixelCoordinates_"));for(var p,g,c,u,y,d=!ol.obj.isEmpty(i),h=0,m=n.length,f=0,_=this.tmpLocalTransform_,E=this.resetTransform_,v=0,S=0,x=this.instructions!=n||this.overlaps?0:200;h<m;){var P,T,R,L,M,C,I=n[h],b=I[0];switch(b){case ol.render.canvas.Instruction.BEGIN_GEOMETRY:P=I[1],d&&i[ol.getUid(P).toString()]||!P.getGeometry()?h=I[2]:void 0===a||ol.extent.intersects(a,P.getGeometry().getExtent())?++h:h=I[2]+1;break;case ol.render.canvas.Instruction.BEGIN_PATH:v>x&&(this.fill_(e,r),v=0),S>x&&(e.stroke(),S=0),v||S||e.beginPath(),++h;break;case ol.render.canvas.Instruction.CIRCLE:ol.DEBUG&&console.assert("number"==typeof I[1],"second instruction should be a number"),f=I[1];var O=s[f],A=s[f+1],N=s[f+2],G=s[f+3],D=N-O,w=G-A,F=Math.sqrt(D*D+w*w);e.moveTo(O+F,A),e.arc(O,A,F,0,2*Math.PI,!0),++h;break;case ol.render.canvas.Instruction.CLOSE_PATH:e.closePath(),++h;break;case ol.render.canvas.Instruction.DRAW_IMAGE:ol.DEBUG&&console.assert("number"==typeof I[1],"second instruction should be a number"),f=I[1],ol.DEBUG&&console.assert("number"==typeof I[2],"third instruction should be a number"),p=I[2];var U=I[3],B=I[4]*o,q=I[5]*o,k=I[6],j=I[7],W=I[8],V=I[9],K=I[10],X=I[11],Y=I[12],Z=I[13],H=I[14];for(K&&(X+=r);f<p;f+=2){if(M=s[f]-B,C=s[f+1]-q,Z&&(M=Math.round(M),C=Math.round(C)),1!=Y||0!==X){var z=M+B,J=C+q;ol.transform.compose(_,z,J,Y,Y,X,-z,-J),e.setTransform.apply(e,_)}var Q=e.globalAlpha;1!=j&&(e.globalAlpha=Q*j);var $=H+W>U.width?U.width-W:H,ee=k+V>U.height?U.height-V:k;e.drawImage(U,W,V,$,ee,M,C,$*o,ee*o),1!=j&&(e.globalAlpha=Q),1==Y&&0===X||e.setTransform.apply(e,E)}++h;break;case ol.render.canvas.Instruction.DRAW_TEXT:ol.DEBUG&&console.assert("number"==typeof I[1],"2nd instruction should be a number"),f=I[1],ol.DEBUG&&console.assert("number"==typeof I[2],"3rd instruction should be a number"),p=I[2],ol.DEBUG&&console.assert("string"==typeof I[3],"4th instruction should be a string"),L=I[3],ol.DEBUG&&console.assert("number"==typeof I[4],"5th instruction should be a number");var oe=I[4]*o;ol.DEBUG&&console.assert("number"==typeof I[5],"6th instruction should be a number");var te=I[5]*o;for(ol.DEBUG&&console.assert("number"==typeof I[6],"7th instruction should be a number"),X=I[6],ol.DEBUG&&console.assert("number"==typeof I[7],"8th instruction should be a number"),Y=I[7]*o,ol.DEBUG&&console.assert("boolean"==typeof I[8],"9th instruction should be a boolean"),T=I[8],ol.DEBUG&&console.assert("boolean"==typeof I[9],"10th instruction should be a boolean"),R=I[9],K=I[10],K&&(X+=r);f<p;f+=2){M=s[f]+oe,C=s[f+1]+te,1==Y&&0===X||(ol.transform.compose(_,M,C,Y,Y,X,-M,-C),e.setTransform.apply(e,_));var re,ie,ne=L.split("\n"),le=ne.length;le>1?(re=Math.round(1.5*e.measureText("M").width),ie=C-(le-1)/2*re):(re=0,ie=C);for(var ae=0;ae<le;ae++){var se=ne[ae];R&&e.strokeText(se,M,ie),T&&e.fillText(se,M,ie),ie+=re}1==Y&&0===X||e.setTransform.apply(e,E)}++h;break;case ol.render.canvas.Instruction.END_GEOMETRY:if(void 0!==l){P=I[1];var pe=l(P);if(pe)return pe}++h;break;case ol.render.canvas.Instruction.FILL:x?v++:this.fill_(e,r),++h;break;case ol.render.canvas.Instruction.MOVE_TO_LINE_TO:for(ol.DEBUG&&console.assert("number"==typeof I[1],"2nd instruction should be a number"),f=I[1],ol.DEBUG&&console.assert("number"==typeof I[2],"3rd instruction should be a number"),p=I[2],M=s[f],C=s[f+1],u=M+.5|0,y=C+.5|0,u===g&&y===c||(e.moveTo(M,C),g=u,c=y),f+=2;f<p;f+=2)M=s[f],C=s[f+1],u=M+.5|0,y=C+.5|0,f!=p-2&&u===g&&y===c||(e.lineTo(M,C),g=u,c=y);++h;break;case ol.render.canvas.Instruction.SET_FILL_STYLE:ol.DEBUG&&console.assert(ol.colorlike.isColorLike(I[1]),"2nd instruction should be a string, CanvasPattern, or CanvasGradient"),this.fillOrigin_=I[2],v&&(this.fill_(e,r),v=0),e.fillStyle=I[1],++h;break;case ol.render.canvas.Instruction.SET_STROKE_STYLE:ol.DEBUG&&console.assert(ol.colorlike.isColorLike(I[1]),"2nd instruction should be a string, CanvasPattern, or CanvasGradient"),ol.DEBUG&&console.assert("number"==typeof I[2],"3rd instruction should be a number"),ol.DEBUG&&console.assert("string"==typeof I[3],"4rd instruction should be a string"),ol.DEBUG&&console.assert("string"==typeof I[4],"5th instruction should be a string"),ol.DEBUG&&console.assert("number"==typeof I[5],"6th instruction should be a number"),ol.DEBUG&&console.assert(I[6],"7th instruction should not be null"),ol.DEBUG&&console.assert("number"==typeof I[8],"9th instruction should be a number");var ge=void 0===I[7]||I[7],ce=I[8],ue=I[2];if(S&&(e.stroke(),S=0),e.strokeStyle=I[1],e.lineWidth=ge?ue*o:ue,e.lineCap=I[3],e.lineJoin=I[4],e.miterLimit=I[5],ol.has.CANVAS_LINE_DASH){var ye=I[6];ge&&o!==ce&&(ye=ye.map(function(e){return e*o/ce}),I[6]=ye,I[8]=o),e.setLineDash(ye)}g=NaN,c=NaN,++h;break;case ol.render.canvas.Instruction.SET_TEXT_STYLE:ol.DEBUG&&console.assert("string"==typeof I[1],"2nd instruction should be a string"),ol.DEBUG&&console.assert("string"==typeof I[2],"3rd instruction should be a string"),ol.DEBUG&&console.assert("string"==typeof I[3],"4th instruction should be a string"),e.font=I[1],e.textAlign=I[2],e.textBaseline=I[3],++h;break;case ol.render.canvas.Instruction.STROKE:x?S++:e.stroke(),++h;break;default:ol.DEBUG&&console.assert(!1,"Unknown canvas render instruction"),++h}}v&&this.fill_(e,r),S&&e.stroke(),ol.DEBUG&&console.assert(h==n.length,"all instructions should be consumed")},ol.render.canvas.Replay.prototype.replay=function(e,o,t,r,i){var n=this.instructions;this.replay_(e,o,t,r,i,n,void 0,void 0)},ol.render.canvas.Replay.prototype.replayHitDetection=function(e,o,t,r,i,n){var l=this.hitDetectionInstructions;return this.replay_(e,1,o,t,r,l,i,n)},ol.render.canvas.Replay.prototype.reverseHitDetectionInstructions=function(){var e=this.hitDetectionInstructions;e.reverse();var o,t,r,i=e.length,n=-1;for(o=0;o<i;++o)t=e[o],r=t[0],r==ol.render.canvas.Instruction.END_GEOMETRY?(ol.DEBUG&&console.assert(-1==n,"begin should be -1"),n=o):r==ol.render.canvas.Instruction.BEGIN_GEOMETRY&&(t[2]=o,ol.DEBUG&&console.assert(n>=0,"begin should be larger than or equal to 0"),ol.array.reverseSubArray(this.hitDetectionInstructions,n,o),n=-1)},ol.render.canvas.Replay.prototype.endGeometry=function(e,o){ol.DEBUG&&console.assert(this.beginGeometryInstruction1_,"this.beginGeometryInstruction1_ should not be null"),this.beginGeometryInstruction1_[2]=this.instructions.length,this.beginGeometryInstruction1_=null,ol.DEBUG&&console.assert(this.beginGeometryInstruction2_,"this.beginGeometryInstruction2_ should not be null"),this.beginGeometryInstruction2_[2]=this.hitDetectionInstructions.length,this.beginGeometryInstruction2_=null;var t=[ol.render.canvas.Instruction.END_GEOMETRY,o];this.instructions.push(t),this.hitDetectionInstructions.push(t)},ol.render.canvas.Replay.prototype.finish=ol.nullFunction,ol.render.canvas.Replay.prototype.getBufferedMaxExtent=function(){return this.maxExtent},goog.provide("ol.render.canvas.ImageReplay"),goog.require("ol"),goog.require("ol.render.canvas.Instruction"),goog.require("ol.render.canvas.Replay"),ol.render.canvas.ImageReplay=function(e,o,t,r){ol.render.canvas.Replay.call(this,e,o,t,r),this.hitDetectionImage_=null,this.image_=null,this.anchorX_=void 0,this.anchorY_=void 0,this.height_=void 0,this.opacity_=void 0,this.originX_=void 0,this.originY_=void 0,this.rotateWithView_=void 0,this.rotation_=void 0,this.scale_=void 0,this.snapToPixel_=void 0,this.width_=void 0},ol.inherits(ol.render.canvas.ImageReplay,ol.render.canvas.Replay),ol.render.canvas.ImageReplay.prototype.drawCoordinates_=function(e,o,t,r){return this.appendFlatCoordinates(e,o,t,r,!1,!1)},ol.render.canvas.ImageReplay.prototype.drawPoint=function(e,o){if(this.image_){ol.DEBUG&&console.assert(void 0!==this.anchorX_,"this.anchorX_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.anchorY_,"this.anchorY_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.height_,"this.height_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.opacity_,"this.opacity_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.originX_,"this.originX_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.originY_,"this.originY_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.rotateWithView_,"this.rotateWithView_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.rotation_,"this.rotation_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.scale_,"this.scale_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.width_,"this.width_ should be defined"),this.beginGeometry(e,o);var t=e.getFlatCoordinates(),r=e.getStride(),i=this.coordinates.length,n=this.drawCoordinates_(t,0,t.length,r);this.instructions.push([ol.render.canvas.Instruction.DRAW_IMAGE,i,n,this.image_,this.anchorX_,this.anchorY_,this.height_,this.opacity_,this.originX_,this.originY_,this.rotateWithView_,this.rotation_,this.scale_,this.snapToPixel_,this.width_]),this.hitDetectionInstructions.push([ol.render.canvas.Instruction.DRAW_IMAGE,i,n,this.hitDetectionImage_,this.anchorX_,this.anchorY_,this.height_,this.opacity_,this.originX_,this.originY_,this.rotateWithView_,this.rotation_,this.scale_,this.snapToPixel_,this.width_]),this.endGeometry(e,o)}},ol.render.canvas.ImageReplay.prototype.drawMultiPoint=function(e,o){if(this.image_){ol.DEBUG&&console.assert(void 0!==this.anchorX_,"this.anchorX_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.anchorY_,"this.anchorY_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.height_,"this.height_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.opacity_,"this.opacity_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.originX_,"this.originX_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.originY_,"this.originY_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.rotateWithView_,"this.rotateWithView_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.rotation_,"this.rotation_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.scale_,"this.scale_ should be defined"),ol.DEBUG&&console.assert(void 0!==this.width_,"this.width_ should be defined"),this.beginGeometry(e,o);var t=e.getFlatCoordinates(),r=e.getStride(),i=this.coordinates.length,n=this.drawCoordinates_(t,0,t.length,r);this.instructions.push([ol.render.canvas.Instruction.DRAW_IMAGE,i,n,this.image_,this.anchorX_,this.anchorY_,this.height_,this.opacity_,this.originX_,this.originY_,this.rotateWithView_,this.rotation_,this.scale_,this.snapToPixel_,this.width_]),this.hitDetectionInstructions.push([ol.render.canvas.Instruction.DRAW_IMAGE,i,n,this.hitDetectionImage_,this.anchorX_,this.anchorY_,this.height_,this.opacity_,this.originX_,this.originY_,this.rotateWithView_,this.rotation_,this.scale_,this.snapToPixel_,this.width_]),this.endGeometry(e,o)}},ol.render.canvas.ImageReplay.prototype.finish=function(){this.reverseHitDetectionInstructions(),this.anchorX_=void 0,this.anchorY_=void 0,this.hitDetectionImage_=null,this.image_=null,this.height_=void 0,this.scale_=void 0,this.opacity_=void 0,this.originX_=void 0,this.originY_=void 0,this.rotateWithView_=void 0,this.rotation_=void 0,this.snapToPixel_=void 0,this.width_=void 0},ol.render.canvas.ImageReplay.prototype.setImageStyle=function(e){ol.DEBUG&&console.assert(e,"imageStyle should not be null");var o=e.getAnchor();ol.DEBUG&&console.assert(o,"anchor should not be null");var t=e.getSize();ol.DEBUG&&console.assert(t,"size should not be null");var r=e.getHitDetectionImage(1);ol.DEBUG&&console.assert(r,"hitDetectionImage should not be null");var i=e.getImage(1);ol.DEBUG&&console.assert(i,"image should not be null");var n=e.getOrigin();ol.DEBUG&&console.assert(n,"origin should not be null"),this.anchorX_=o[0],this.anchorY_=o[1],this.hitDetectionImage_=r,this.image_=i,this.height_=t[1],this.opacity_=e.getOpacity(),this.originX_=n[0],this.originY_=n[1],this.rotateWithView_=e.getRotateWithView(),this.rotation_=e.getRotation(),this.scale_=e.getScale(),this.snapToPixel_=e.getSnapToPixel(),this.width_=t[0]},goog.provide("ol.render.canvas.LineStringReplay"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.colorlike"),goog.require("ol.extent"),goog.require("ol.render.canvas"),goog.require("ol.render.canvas.Instruction"),goog.require("ol.render.canvas.Replay"),ol.render.canvas.LineStringReplay=function(e,o,t,r){ol.render.canvas.Replay.call(this,e,o,t,r),this.bufferedMaxExtent_=null,this.state_={currentStrokeStyle:void 0,currentLineCap:void 0,currentLineDash:null,currentLineJoin:void 0,currentLineWidth:void 0,currentMiterLimit:void 0,lastStroke:0,strokeStyle:void 0,lineCap:void 0,lineDash:null,lineJoin:void 0,lineWidth:void 0,miterLimit:void 0}},ol.inherits(ol.render.canvas.LineStringReplay,ol.render.canvas.Replay),ol.render.canvas.LineStringReplay.prototype.drawFlatCoordinates_=function(e,o,t,r){var i=this.coordinates.length,n=this.appendFlatCoordinates(e,o,t,r,!1,!1),l=[ol.render.canvas.Instruction.MOVE_TO_LINE_TO,i,n];return this.instructions.push(l),this.hitDetectionInstructions.push(l),t},ol.render.canvas.LineStringReplay.prototype.getBufferedMaxExtent=function(){if(!this.bufferedMaxExtent_&&(this.bufferedMaxExtent_=ol.extent.clone(this.maxExtent),this.maxLineWidth>0)){var e=this.resolution*(this.maxLineWidth+1)/2;ol.extent.buffer(this.bufferedMaxExtent_,e,this.bufferedMaxExtent_)}return this.bufferedMaxExtent_},ol.render.canvas.LineStringReplay.prototype.setStrokeStyle_=function(){var e=this.state_,o=e.strokeStyle,t=e.lineCap,r=e.lineDash,i=e.lineJoin,n=e.lineWidth,l=e.miterLimit;ol.DEBUG&&console.assert(void 0!==o,"strokeStyle should be defined"),ol.DEBUG&&console.assert(void 0!==t,"lineCap should be defined"),ol.DEBUG&&console.assert(r,"lineDash should not be null"),ol.DEBUG&&console.assert(void 0!==i,"lineJoin should be defined"),ol.DEBUG&&console.assert(void 0!==n,"lineWidth should be defined"),ol.DEBUG&&console.assert(void 0!==l,"miterLimit should be defined"),e.currentStrokeStyle==o&&e.currentLineCap==t&&ol.array.equals(e.currentLineDash,r)&&e.currentLineJoin==i&&e.currentLineWidth==n&&e.currentMiterLimit==l||(e.lastStroke!=this.coordinates.length&&(this.instructions.push([ol.render.canvas.Instruction.STROKE]),e.lastStroke=this.coordinates.length),this.instructions.push([ol.render.canvas.Instruction.SET_STROKE_STYLE,o,n,t,i,l,r,!0,1],[ol.render.canvas.Instruction.BEGIN_PATH]),e.currentStrokeStyle=o,e.currentLineCap=t,e.currentLineDash=r,e.currentLineJoin=i,e.currentLineWidth=n,e.currentMiterLimit=l)},ol.render.canvas.LineStringReplay.prototype.drawLineString=function(e,o){var t=this.state_;ol.DEBUG&&console.assert(t,"state should not be null");var r=t.strokeStyle,i=t.lineWidth;if(void 0!==r&&void 0!==i){this.setStrokeStyle_(),this.beginGeometry(e,o),this.hitDetectionInstructions.push([ol.render.canvas.Instruction.SET_STROKE_STYLE,t.strokeStyle,t.lineWidth,t.lineCap,t.lineJoin,t.miterLimit,t.lineDash,!0,1],[ol.render.canvas.Instruction.BEGIN_PATH]);var n=e.getFlatCoordinates(),l=e.getStride();this.drawFlatCoordinates_(n,0,n.length,l),this.hitDetectionInstructions.push([ol.render.canvas.Instruction.STROKE]),this.endGeometry(e,o)}},ol.render.canvas.LineStringReplay.prototype.drawMultiLineString=function(e,o){var t=this.state_;ol.DEBUG&&console.assert(t,"state should not be null");var r=t.strokeStyle,i=t.lineWidth;if(void 0!==r&&void 0!==i){this.setStrokeStyle_(),this.beginGeometry(e,o),this.hitDetectionInstructions.push([ol.render.canvas.Instruction.SET_STROKE_STYLE,t.strokeStyle,t.lineWidth,t.lineCap,t.lineJoin,t.miterLimit,t.lineDash,!0,1],[ol.render.canvas.Instruction.BEGIN_PATH]);var n,l,a=e.getEnds(),s=e.getFlatCoordinates(),p=e.getStride(),g=0;for(n=0,l=a.length;n<l;++n)g=this.drawFlatCoordinates_(s,g,a[n],p);this.hitDetectionInstructions.push([ol.render.canvas.Instruction.STROKE]),this.endGeometry(e,o)}},ol.render.canvas.LineStringReplay.prototype.finish=function(){var e=this.state_;ol.DEBUG&&console.assert(e,"state should not be null"),e.lastStroke!=this.coordinates.length&&this.instructions.push([ol.render.canvas.Instruction.STROKE]),this.reverseHitDetectionInstructions(),this.state_=null},ol.render.canvas.LineStringReplay.prototype.setFillStrokeStyle=function(e,o){ol.DEBUG&&console.assert(this.state_,"this.state_ should not be null"),ol.DEBUG&&console.assert(!e,"fillStyle should be null"),ol.DEBUG&&console.assert(o,"strokeStyle should not be null");var t=o.getColor();this.state_.strokeStyle=ol.colorlike.asColorLike(t||ol.render.canvas.defaultStrokeStyle);var r=o.getLineCap();this.state_.lineCap=void 0!==r?r:ol.render.canvas.defaultLineCap;var i=o.getLineDash();this.state_.lineDash=i||ol.render.canvas.defaultLineDash;var n=o.getLineJoin();this.state_.lineJoin=void 0!==n?n:ol.render.canvas.defaultLineJoin;var l=o.getWidth();this.state_.lineWidth=void 0!==l?l:ol.render.canvas.defaultLineWidth;var a=o.getMiterLimit();this.state_.miterLimit=void 0!==a?a:ol.render.canvas.defaultMiterLimit,this.state_.lineWidth>this.maxLineWidth&&(this.maxLineWidth=this.state_.lineWidth,this.bufferedMaxExtent_=null)},goog.provide("ol.render.canvas.PolygonReplay"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.color"),goog.require("ol.colorlike"),goog.require("ol.extent"),goog.require("ol.geom.flat.simplify"),goog.require("ol.render.canvas"),goog.require("ol.render.canvas.Instruction"),goog.require("ol.render.canvas.Replay"),ol.render.canvas.PolygonReplay=function(e,o,t,r){ol.render.canvas.Replay.call(this,e,o,t,r),this.bufferedMaxExtent_=null,this.state_={currentFillStyle:void 0,currentStrokeStyle:void 0,currentLineCap:void 0,currentLineDash:null,currentLineJoin:void 0,currentLineWidth:void 0,currentMiterLimit:void 0,fillStyle:void 0,strokeStyle:void 0,lineCap:void 0,lineDash:null,lineJoin:void 0,lineWidth:void 0,miterLimit:void 0}};ol.inherits(ol.render.canvas.PolygonReplay,ol.render.canvas.Replay),ol.render.canvas.PolygonReplay.prototype.drawFlatCoordinatess_=function(e,o,t,r){var i=this.state_,n=void 0!==i.fillStyle,l=void 0!=i.strokeStyle,a=t.length,s=[ol.render.canvas.Instruction.BEGIN_PATH];this.instructions.push(s),this.hitDetectionInstructions.push(s);for(var p=0;p<a;++p){var g=t[p],c=this.coordinates.length,u=this.appendFlatCoordinates(e,o,g,r,!0,!l),y=[ol.render.canvas.Instruction.MOVE_TO_LINE_TO,c,u];if(this.instructions.push(y),this.hitDetectionInstructions.push(y),l){var d=[ol.render.canvas.Instruction.CLOSE_PATH];this.instructions.push(d),this.hitDetectionInstructions.push(d)}o=g}var h=[ol.render.canvas.Instruction.FILL];if(this.hitDetectionInstructions.push(h),n&&this.instructions.push(h),l){ol.DEBUG&&console.assert(void 0!==i.lineWidth,"state.lineWidth should be defined");var m=[ol.render.canvas.Instruction.STROKE];this.instructions.push(m),this.hitDetectionInstructions.push(m)}return o},ol.render.canvas.PolygonReplay.prototype.drawCircle=function(e,o){var t=this.state_;ol.DEBUG&&console.assert(t,"state should not be null");var r=t.fillStyle,i=t.strokeStyle;if(void 0!==r||void 0!==i){void 0!==i&&ol.DEBUG&&console.assert(void 0!==t.lineWidth,"state.lineWidth should be defined"),this.setFillStrokeStyles_(e),this.beginGeometry(e,o),this.hitDetectionInstructions.push([ol.render.canvas.Instruction.SET_FILL_STYLE,ol.color.asString(ol.render.canvas.defaultFillStyle)]),void 0!==t.strokeStyle&&this.hitDetectionInstructions.push([ol.render.canvas.Instruction.SET_STROKE_STYLE,t.strokeStyle,t.lineWidth,t.lineCap,t.lineJoin,t.miterLimit,t.lineDash,!0,1]);var n=e.getFlatCoordinates(),l=e.getStride(),a=this.coordinates.length;this.appendFlatCoordinates(n,0,n.length,l,!1,!1);var s=[ol.render.canvas.Instruction.BEGIN_PATH],p=[ol.render.canvas.Instruction.CIRCLE,a];this.instructions.push(s,p),this.hitDetectionInstructions.push(s,p);var g=[ol.render.canvas.Instruction.FILL];if(this.hitDetectionInstructions.push(g),void 0!==t.fillStyle&&this.instructions.push(g),void 0!==t.strokeStyle){ol.DEBUG&&console.assert(void 0!==t.lineWidth,"state.lineWidth should be defined");var c=[ol.render.canvas.Instruction.STROKE];this.instructions.push(c),this.hitDetectionInstructions.push(c)}this.endGeometry(e,o)}},ol.render.canvas.PolygonReplay.prototype.drawPolygon=function(e,o){var t=this.state_;ol.DEBUG&&console.assert(t,"state should not be null");var r=t.strokeStyle;ol.DEBUG&&console.assert(void 0!==t.fillStyle||void 0!==r,"fillStyle or strokeStyle should be defined"),void 0!==r&&ol.DEBUG&&console.assert(void 0!==t.lineWidth,"state.lineWidth should be defined"),this.setFillStrokeStyles_(e),this.beginGeometry(e,o),this.hitDetectionInstructions.push([ol.render.canvas.Instruction.SET_FILL_STYLE,ol.color.asString(ol.render.canvas.defaultFillStyle)]),void 0!==t.strokeStyle&&this.hitDetectionInstructions.push([ol.render.canvas.Instruction.SET_STROKE_STYLE,t.strokeStyle,t.lineWidth,t.lineCap,t.lineJoin,t.miterLimit,t.lineDash,!0,1]);var i=e.getEnds(),n=e.getOrientedFlatCoordinates(),l=e.getStride();this.drawFlatCoordinatess_(n,0,i,l),this.endGeometry(e,o)},ol.render.canvas.PolygonReplay.prototype.drawMultiPolygon=function(e,o){var t=this.state_;ol.DEBUG&&console.assert(t,"state should not be null");var r=t.fillStyle,i=t.strokeStyle;if(void 0!==r||void 0!==i){void 0!==i&&ol.DEBUG&&console.assert(void 0!==t.lineWidth,"state.lineWidth should be defined"),this.setFillStrokeStyles_(e),this.beginGeometry(e,o),this.hitDetectionInstructions.push([ol.render.canvas.Instruction.SET_FILL_STYLE,ol.color.asString(ol.render.canvas.defaultFillStyle)]),void 0!==t.strokeStyle&&this.hitDetectionInstructions.push([ol.render.canvas.Instruction.SET_STROKE_STYLE,t.strokeStyle,t.lineWidth,t.lineCap,t.lineJoin,t.miterLimit,t.lineDash,!0,1]);var n,l,a=e.getEndss(),s=e.getOrientedFlatCoordinates(),p=e.getStride(),g=0;for(n=0,l=a.length;n<l;++n)g=this.drawFlatCoordinatess_(s,g,a[n],p);this.endGeometry(e,o)}},ol.render.canvas.PolygonReplay.prototype.finish=function(){ol.DEBUG&&console.assert(this.state_,"this.state_ should not be null"),this.reverseHitDetectionInstructions(),this.state_=null;var e=this.tolerance;if(0!==e){var o,t,r=this.coordinates;for(o=0,t=r.length;o<t;++o)r[o]=ol.geom.flat.simplify.snap(r[o],e)}},ol.render.canvas.PolygonReplay.prototype.getBufferedMaxExtent=function(){if(!this.bufferedMaxExtent_&&(this.bufferedMaxExtent_=ol.extent.clone(this.maxExtent),this.maxLineWidth>0)){var e=this.resolution*(this.maxLineWidth+1)/2;ol.extent.buffer(this.bufferedMaxExtent_,e,this.bufferedMaxExtent_)}return this.bufferedMaxExtent_},ol.render.canvas.PolygonReplay.prototype.setFillStrokeStyle=function(e,o){ol.DEBUG&&console.assert(this.state_,"this.state_ should not be null"),ol.DEBUG&&console.assert(e||o,"fillStyle or strokeStyle should not be null");var t=this.state_;if(e){var r=e.getColor();t.fillStyle=ol.colorlike.asColorLike(r||ol.render.canvas.defaultFillStyle)}else t.fillStyle=void 0;if(o){var i=o.getColor();t.strokeStyle=ol.colorlike.asColorLike(i||ol.render.canvas.defaultStrokeStyle);var n=o.getLineCap();t.lineCap=void 0!==n?n:ol.render.canvas.defaultLineCap;var l=o.getLineDash();t.lineDash=l?l.slice():ol.render.canvas.defaultLineDash;var a=o.getLineJoin();t.lineJoin=void 0!==a?a:ol.render.canvas.defaultLineJoin;var s=o.getWidth();t.lineWidth=void 0!==s?s:ol.render.canvas.defaultLineWidth;var p=o.getMiterLimit();t.miterLimit=void 0!==p?p:ol.render.canvas.defaultMiterLimit,t.lineWidth>this.maxLineWidth&&(this.maxLineWidth=t.lineWidth,this.bufferedMaxExtent_=null)}else t.strokeStyle=void 0,t.lineCap=void 0,t.lineDash=null,t.lineJoin=void 0,t.lineWidth=void 0,t.miterLimit=void 0},ol.render.canvas.PolygonReplay.prototype.setFillStrokeStyles_=function(e){var o=this.state_,t=o.fillStyle,r=o.strokeStyle,i=o.lineCap,n=o.lineDash,l=o.lineJoin,a=o.lineWidth,s=o.miterLimit;if(void 0!==t&&("string"!=typeof t||o.currentFillStyle!=t)){var p=[ol.render.canvas.Instruction.SET_FILL_STYLE,t];if("string"!=typeof t){var g=e.getExtent();p.push([g[0],g[3]])}this.instructions.push(p),o.currentFillStyle=o.fillStyle}void 0!==r&&(ol.DEBUG&&console.assert(void 0!==i,"lineCap should be defined"),ol.DEBUG&&console.assert(n,"lineDash should not be null"),ol.DEBUG&&console.assert(void 0!==l,"lineJoin should be defined"),ol.DEBUG&&console.assert(void 0!==a,"lineWidth should be defined"),ol.DEBUG&&console.assert(void 0!==s,"miterLimit should be defined"),o.currentStrokeStyle==r&&o.currentLineCap==i&&ol.array.equals(o.currentLineDash,n)&&o.currentLineJoin==l&&o.currentLineWidth==a&&o.currentMiterLimit==s||(this.instructions.push([ol.render.canvas.Instruction.SET_STROKE_STYLE,r,a,i,l,s,n,!0,1]),o.currentStrokeStyle=r,o.currentLineCap=i,o.currentLineDash=n,o.currentLineJoin=l,o.currentLineWidth=a,o.currentMiterLimit=s))},goog.provide("ol.render.canvas.TextReplay"),goog.require("ol"),goog.require("ol.colorlike"),goog.require("ol.render.canvas"),goog.require("ol.render.canvas.Instruction"),goog.require("ol.render.canvas.Replay"),ol.render.canvas.TextReplay=function(e,o,t,r){ol.render.canvas.Replay.call(this,e,o,t,r),this.replayFillState_=null,this.replayStrokeState_=null,this.replayTextState_=null,this.text_="",this.textOffsetX_=0,this.textOffsetY_=0,this.textRotateWithView_=void 0,this.textRotation_=0,this.textScale_=0,this.textFillState_=null,this.textStrokeState_=null,this.textState_=null},ol.inherits(ol.render.canvas.TextReplay,ol.render.canvas.Replay),ol.render.canvas.TextReplay.prototype.drawText=function(e,o,t,r,i,n){if(""!==this.text_&&this.textState_&&(this.textFillState_||this.textStrokeState_)){this.textFillState_&&this.setReplayFillState_(this.textFillState_),this.textStrokeState_&&this.setReplayStrokeState_(this.textStrokeState_),this.setReplayTextState_(this.textState_),this.beginGeometry(i,n);var l=this.coordinates.length,a=this.appendFlatCoordinates(e,o,t,r,!1,!1),s=!!this.textFillState_,p=!!this.textStrokeState_,g=[ol.render.canvas.Instruction.DRAW_TEXT,l,a,this.text_,this.textOffsetX_,this.textOffsetY_,this.textRotation_,this.textScale_,s,p,this.textRotateWithView_];this.instructions.push(g),this.hitDetectionInstructions.push(g),this.endGeometry(i,n)}},ol.render.canvas.TextReplay.prototype.setReplayFillState_=function(e){var o=this.replayFillState_;if(!o||o.fillStyle!=e.fillStyle){var t=[ol.render.canvas.Instruction.SET_FILL_STYLE,e.fillStyle];this.instructions.push(t),this.hitDetectionInstructions.push(t),o?o.fillStyle=e.fillStyle:this.replayFillState_={fillStyle:e.fillStyle}}},ol.render.canvas.TextReplay.prototype.setReplayStrokeState_=function(e){var o=this.replayStrokeState_;if(!o||o.lineCap!=e.lineCap||o.lineDash!=e.lineDash||o.lineJoin!=e.lineJoin||o.lineWidth!=e.lineWidth||o.miterLimit!=e.miterLimit||o.strokeStyle!=e.strokeStyle){var t=[ol.render.canvas.Instruction.SET_STROKE_STYLE,e.strokeStyle,e.lineWidth,e.lineCap,e.lineJoin,e.miterLimit,e.lineDash,!1,1];this.instructions.push(t),this.hitDetectionInstructions.push(t),o?(o.lineCap=e.lineCap,o.lineDash=e.lineDash,o.lineJoin=e.lineJoin,o.lineWidth=e.lineWidth,o.miterLimit=e.miterLimit,o.strokeStyle=e.strokeStyle):this.replayStrokeState_={lineCap:e.lineCap,lineDash:e.lineDash,lineJoin:e.lineJoin,lineWidth:e.lineWidth,miterLimit:e.miterLimit,strokeStyle:e.strokeStyle}}},ol.render.canvas.TextReplay.prototype.setReplayTextState_=function(e){var o=this.replayTextState_;if(!o||o.font!=e.font||o.textAlign!=e.textAlign||o.textBaseline!=e.textBaseline){var t=[ol.render.canvas.Instruction.SET_TEXT_STYLE,e.font,e.textAlign,e.textBaseline];this.instructions.push(t),this.hitDetectionInstructions.push(t),o?(o.font=e.font,o.textAlign=e.textAlign,o.textBaseline=e.textBaseline):this.replayTextState_={font:e.font,textAlign:e.textAlign,textBaseline:e.textBaseline}}},ol.render.canvas.TextReplay.prototype.setTextStyle=function(e){if(e){var o=e.getFill();if(o){var t=o.getColor(),r=ol.colorlike.asColorLike(t||ol.render.canvas.defaultFillStyle);if(this.textFillState_){this.textFillState_.fillStyle=r}else this.textFillState_={fillStyle:r}}else this.textFillState_=null;var i=e.getStroke();if(i){
var n=i.getColor(),l=i.getLineCap(),a=i.getLineDash(),s=i.getLineJoin(),p=i.getWidth(),g=i.getMiterLimit(),c=void 0!==l?l:ol.render.canvas.defaultLineCap,u=a?a.slice():ol.render.canvas.defaultLineDash,y=void 0!==s?s:ol.render.canvas.defaultLineJoin,d=void 0!==p?p:ol.render.canvas.defaultLineWidth,h=void 0!==g?g:ol.render.canvas.defaultMiterLimit,m=ol.colorlike.asColorLike(n||ol.render.canvas.defaultStrokeStyle);if(this.textStrokeState_){var f=this.textStrokeState_;f.lineCap=c,f.lineDash=u,f.lineJoin=y,f.lineWidth=d,f.miterLimit=h,f.strokeStyle=m}else this.textStrokeState_={lineCap:c,lineDash:u,lineJoin:y,lineWidth:d,miterLimit:h,strokeStyle:m}}else this.textStrokeState_=null;var _=e.getFont(),E=e.getOffsetX(),v=e.getOffsetY(),S=e.getRotateWithView(),x=e.getRotation(),P=e.getScale(),T=e.getText(),R=e.getTextAlign(),L=e.getTextBaseline(),M=void 0!==_?_:ol.render.canvas.defaultFont,C=void 0!==R?R:ol.render.canvas.defaultTextAlign,I=void 0!==L?L:ol.render.canvas.defaultTextBaseline;if(this.textState_){var b=this.textState_;b.font=M,b.textAlign=C,b.textBaseline=I}else this.textState_={font:M,textAlign:C,textBaseline:I};this.text_=void 0!==T?T:"",this.textOffsetX_=void 0!==E?E:0,this.textOffsetY_=void 0!==v?v:0,this.textRotateWithView_=void 0!==S&&S,this.textRotation_=void 0!==x?x:0,this.textScale_=void 0!==P?P:1}else this.text_=""},goog.provide("ol.render.ReplayType"),ol.render.ReplayType={CIRCLE:"Circle",IMAGE:"Image",LINE_STRING:"LineString",POLYGON:"Polygon",TEXT:"Text"},goog.provide("ol.render.replay"),goog.require("ol.render.ReplayType"),ol.render.replay.ORDER=[ol.render.ReplayType.POLYGON,ol.render.ReplayType.CIRCLE,ol.render.ReplayType.LINE_STRING,ol.render.ReplayType.IMAGE,ol.render.ReplayType.TEXT],goog.provide("ol.render.canvas.ReplayGroup"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.dom"),goog.require("ol.extent"),goog.require("ol.geom.flat.transform"),goog.require("ol.obj"),goog.require("ol.render.ReplayGroup"),goog.require("ol.render.canvas.ImageReplay"),goog.require("ol.render.canvas.LineStringReplay"),goog.require("ol.render.canvas.PolygonReplay"),goog.require("ol.render.canvas.TextReplay"),goog.require("ol.render.replay"),goog.require("ol.transform"),ol.render.canvas.ReplayGroup=function(e,o,t,r,i){ol.render.ReplayGroup.call(this),this.tolerance_=e,this.maxExtent_=o,this.overlaps_=r,this.resolution_=t,this.renderBuffer_=i,this.replaysByZIndex_={},this.hitDetectionContext_=ol.dom.createCanvasContext2D(1,1),this.hitDetectionTransform_=ol.transform.create()},ol.inherits(ol.render.canvas.ReplayGroup,ol.render.ReplayGroup),ol.render.canvas.ReplayGroup.circleArrayCache_={0:[[!0]]},ol.render.canvas.ReplayGroup.fillCircleArrayRowToMiddle_=function(e,o,t){var r,i=Math.floor(e.length/2);if(o>=i)for(r=i;r<o;r++)e[r][t]=!0;else if(o<i)for(r=o+1;r<i;r++)e[r][t]=!0},ol.render.canvas.ReplayGroup.getCircleArray_=function(e){if(void 0!==ol.render.canvas.ReplayGroup.circleArrayCache_[e])return ol.render.canvas.ReplayGroup.circleArrayCache_[e];for(var o=2*e+1,t=new Array(o),r=0;r<o;r++)t[r]=new Array(o);for(var i=e,n=0,l=0;i>=n;)ol.render.canvas.ReplayGroup.fillCircleArrayRowToMiddle_(t,e+i,e+n),ol.render.canvas.ReplayGroup.fillCircleArrayRowToMiddle_(t,e+n,e+i),ol.render.canvas.ReplayGroup.fillCircleArrayRowToMiddle_(t,e-n,e+i),ol.render.canvas.ReplayGroup.fillCircleArrayRowToMiddle_(t,e-i,e+n),ol.render.canvas.ReplayGroup.fillCircleArrayRowToMiddle_(t,e-i,e-n),ol.render.canvas.ReplayGroup.fillCircleArrayRowToMiddle_(t,e-n,e-i),ol.render.canvas.ReplayGroup.fillCircleArrayRowToMiddle_(t,e+n,e-i),ol.render.canvas.ReplayGroup.fillCircleArrayRowToMiddle_(t,e+i,e-n),n++,2*((l+=1+2*n)-i)+1>0&&(i-=1,l+=1-2*i);return ol.render.canvas.ReplayGroup.circleArrayCache_[e]=t,t},ol.render.canvas.ReplayGroup.prototype.finish=function(){var e;for(e in this.replaysByZIndex_){var o,t=this.replaysByZIndex_[e];for(o in t)t[o].finish()}},ol.render.canvas.ReplayGroup.prototype.forEachFeatureAtCoordinate=function(e,o,t,r,i,n){r=Math.round(r);var l=2*r+1,a=ol.transform.compose(this.hitDetectionTransform_,r+.5,r+.5,1/o,-1/o,-t,-e[0],-e[1]),s=this.hitDetectionContext_;s.canvas.width!==l||s.canvas.height!==l?(s.canvas.width=l,s.canvas.height=l):s.clearRect(0,0,l,l);var p;void 0!==this.renderBuffer_&&(p=ol.extent.createEmpty(),ol.extent.extendCoordinate(p,e),ol.extent.buffer(p,o*(this.renderBuffer_+r),p));var g=ol.render.canvas.ReplayGroup.getCircleArray_(r);return this.replayHitDetection_(s,a,t,i,function(e){for(var o=s.getImageData(0,0,l,l).data,t=0;t<l;t++)for(var r=0;r<l;r++)if(g[t][r]&&o[4*(r*l+t)+3]>0){var i=n(e);return i||void s.clearRect(0,0,l,l)}},p)},ol.render.canvas.ReplayGroup.prototype.getClipCoords=function(e){var o=this.maxExtent_,t=o[0],r=o[1],i=o[2],n=o[3],l=[t,r,t,n,i,n,i,r];return ol.geom.flat.transform.transform2D(l,0,8,2,e,l),l},ol.render.canvas.ReplayGroup.prototype.getReplay=function(e,o){var t=void 0!==e?e.toString():"0",r=this.replaysByZIndex_[t];void 0===r&&(r={},this.replaysByZIndex_[t]=r);var i=r[o];if(void 0===i){var n=ol.render.canvas.ReplayGroup.BATCH_CONSTRUCTORS_[o];ol.DEBUG&&console.assert(void 0!==n,o+" constructor missing from ol.render.canvas.ReplayGroup.BATCH_CONSTRUCTORS_"),i=new n(this.tolerance_,this.maxExtent_,this.resolution_,this.overlaps_),r[o]=i}return i},ol.render.canvas.ReplayGroup.prototype.isEmpty=function(){return ol.obj.isEmpty(this.replaysByZIndex_)},ol.render.canvas.ReplayGroup.prototype.replay=function(e,o,t,r,i,n){var l=Object.keys(this.replaysByZIndex_).map(Number);l.sort(ol.array.numberSafeCompareFunction);var a=this.getClipCoords(t);e.save(),e.beginPath(),e.moveTo(a[0],a[1]),e.lineTo(a[2],a[3]),e.lineTo(a[4],a[5]),e.lineTo(a[6],a[7]),e.clip();var s,p,g,c,u,y,d=n||ol.render.replay.ORDER;for(s=0,p=l.length;s<p;++s)for(u=this.replaysByZIndex_[l[s].toString()],g=0,c=d.length;g<c;++g)void 0!==(y=u[d[g]])&&y.replay(e,o,t,r,i);e.restore()},ol.render.canvas.ReplayGroup.prototype.replayHitDetection_=function(e,o,t,r,i,n){var l=Object.keys(this.replaysByZIndex_).map(Number);l.sort(function(e,o){return o-e});var a,s,p,g,c,u;for(a=0,s=l.length;a<s;++a)for(g=this.replaysByZIndex_[l[a].toString()],p=ol.render.replay.ORDER.length-1;p>=0;--p)if(void 0!==(c=g[ol.render.replay.ORDER[p]])&&(u=c.replayHitDetection(e,o,t,r,i,n)))return u},ol.render.canvas.ReplayGroup.BATCH_CONSTRUCTORS_={Circle:ol.render.canvas.PolygonReplay,Image:ol.render.canvas.ImageReplay,LineString:ol.render.canvas.LineStringReplay,Polygon:ol.render.canvas.PolygonReplay,Text:ol.render.canvas.TextReplay},goog.provide("ol.renderer.vector"),goog.require("ol"),goog.require("ol.Image"),goog.require("ol.render.ReplayType"),ol.renderer.vector.defaultOrder=function(e,o){return ol.getUid(e)-ol.getUid(o)},ol.renderer.vector.getSquaredTolerance=function(e,o){var t=ol.renderer.vector.getTolerance(e,o);return t*t},ol.renderer.vector.getTolerance=function(e,o){return ol.SIMPLIFY_TOLERANCE*e/o},ol.renderer.vector.renderCircleGeometry_=function(e,o,t,r){var i=t.getFill(),n=t.getStroke();if(i||n){var l=e.getReplay(t.getZIndex(),ol.render.ReplayType.CIRCLE);l.setFillStrokeStyle(i,n),l.drawCircle(o,r)}var a=t.getText();if(a){var s=e.getReplay(t.getZIndex(),ol.render.ReplayType.TEXT);s.setTextStyle(a),s.drawText(o.getCenter(),0,2,2,o,r)}},ol.renderer.vector.renderFeature=function(e,o,t,r,i,n){var l,a,s=!1;return l=t.getImage(),l&&(a=l.getImageState(),a==ol.Image.State.LOADED||a==ol.Image.State.ERROR?l.unlistenImageChange(i,n):(a==ol.Image.State.IDLE&&l.load(),a=l.getImageState(),ol.DEBUG&&console.assert(a==ol.Image.State.LOADING,"imageState should be LOADING"),l.listenImageChange(i,n),s=!0)),ol.renderer.vector.renderFeature_(e,o,t,r),s},ol.renderer.vector.renderFeature_=function(e,o,t,r){var i=t.getGeometryFunction()(o);if(i){var n=i.getSimplifiedGeometry(r);(0,ol.renderer.vector.GEOMETRY_RENDERERS_[n.getType()])(e,n,t,o)}},ol.renderer.vector.renderGeometryCollectionGeometry_=function(e,o,t,r){var i,n,l=o.getGeometriesArray();for(i=0,n=l.length;i<n;++i){(0,ol.renderer.vector.GEOMETRY_RENDERERS_[l[i].getType()])(e,l[i],t,r)}},ol.renderer.vector.renderLineStringGeometry_=function(e,o,t,r){var i=t.getStroke();if(i){var n=e.getReplay(t.getZIndex(),ol.render.ReplayType.LINE_STRING);n.setFillStrokeStyle(null,i),n.drawLineString(o,r)}var l=t.getText();if(l){var a=e.getReplay(t.getZIndex(),ol.render.ReplayType.TEXT);a.setTextStyle(l),a.drawText(o.getFlatMidpoint(),0,2,2,o,r)}},ol.renderer.vector.renderMultiLineStringGeometry_=function(e,o,t,r){var i=t.getStroke();if(i){var n=e.getReplay(t.getZIndex(),ol.render.ReplayType.LINE_STRING);n.setFillStrokeStyle(null,i),n.drawMultiLineString(o,r)}var l=t.getText();if(l){var a=e.getReplay(t.getZIndex(),ol.render.ReplayType.TEXT);a.setTextStyle(l);var s=o.getFlatMidpoints();a.drawText(s,0,s.length,2,o,r)}},ol.renderer.vector.renderMultiPolygonGeometry_=function(e,o,t,r){var i=t.getFill(),n=t.getStroke();if(n||i){var l=e.getReplay(t.getZIndex(),ol.render.ReplayType.POLYGON);l.setFillStrokeStyle(i,n),l.drawMultiPolygon(o,r)}var a=t.getText();if(a){var s=e.getReplay(t.getZIndex(),ol.render.ReplayType.TEXT);s.setTextStyle(a);var p=o.getFlatInteriorPoints();s.drawText(p,0,p.length,2,o,r)}},ol.renderer.vector.renderPointGeometry_=function(e,o,t,r){var i=t.getImage();if(i){if(i.getImageState()!=ol.Image.State.LOADED)return;var n=e.getReplay(t.getZIndex(),ol.render.ReplayType.IMAGE);n.setImageStyle(i),n.drawPoint(o,r)}var l=t.getText();if(l){var a=e.getReplay(t.getZIndex(),ol.render.ReplayType.TEXT);a.setTextStyle(l),a.drawText(o.getFlatCoordinates(),0,2,2,o,r)}},ol.renderer.vector.renderMultiPointGeometry_=function(e,o,t,r){var i=t.getImage();if(i){if(i.getImageState()!=ol.Image.State.LOADED)return;var n=e.getReplay(t.getZIndex(),ol.render.ReplayType.IMAGE);n.setImageStyle(i),n.drawMultiPoint(o,r)}var l=t.getText();if(l){var a=e.getReplay(t.getZIndex(),ol.render.ReplayType.TEXT);a.setTextStyle(l);var s=o.getFlatCoordinates();a.drawText(s,0,s.length,o.getStride(),o,r)}},ol.renderer.vector.renderPolygonGeometry_=function(e,o,t,r){var i=t.getFill(),n=t.getStroke();if(i||n){var l=e.getReplay(t.getZIndex(),ol.render.ReplayType.POLYGON);l.setFillStrokeStyle(i,n),l.drawPolygon(o,r)}var a=t.getText();if(a){var s=e.getReplay(t.getZIndex(),ol.render.ReplayType.TEXT);s.setTextStyle(a),s.drawText(o.getFlatInteriorPoint(),0,2,2,o,r)}},ol.renderer.vector.GEOMETRY_RENDERERS_={Point:ol.renderer.vector.renderPointGeometry_,LineString:ol.renderer.vector.renderLineStringGeometry_,Polygon:ol.renderer.vector.renderPolygonGeometry_,MultiPoint:ol.renderer.vector.renderMultiPointGeometry_,MultiLineString:ol.renderer.vector.renderMultiLineStringGeometry_,MultiPolygon:ol.renderer.vector.renderMultiPolygonGeometry_,GeometryCollection:ol.renderer.vector.renderGeometryCollectionGeometry_,Circle:ol.renderer.vector.renderCircleGeometry_},goog.provide("ol.renderer.canvas.VectorLayer"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.dom"),goog.require("ol.extent"),goog.require("ol.render.Event"),goog.require("ol.render.canvas"),goog.require("ol.render.canvas.ReplayGroup"),goog.require("ol.renderer.canvas.Layer"),goog.require("ol.renderer.vector"),ol.renderer.canvas.VectorLayer=function(e){ol.renderer.canvas.Layer.call(this,e),this.dirty_=!1,this.renderedRevision_=-1,this.renderedResolution_=NaN,this.renderedExtent_=ol.extent.createEmpty(),this.renderedRenderOrder_=null,this.replayGroup_=null,this.context_=ol.dom.createCanvasContext2D()},ol.inherits(ol.renderer.canvas.VectorLayer,ol.renderer.canvas.Layer),ol.renderer.canvas.VectorLayer.prototype.composeFrame=function(e,o,t){var r=e.extent,i=e.pixelRatio,n=o.managed?e.skippedFeatureUids:{},l=e.viewState,a=l.projection,s=l.rotation,p=a.getExtent(),g=this.getLayer().getSource(),c=this.getTransform(e,0);this.preCompose(t,e,c);var u=o.extent,y=void 0!==u;y&&this.clip(t,e,u);var d=this.replayGroup_;if(d&&!d.isEmpty()){var h,m=this.getLayer(),f=0,_=0;if(m.hasListener(ol.render.Event.Type.RENDER)){var E=t.canvas.width,v=t.canvas.height;if(s){var S=Math.round(Math.sqrt(E*E+v*v));f=(S-E)/2,_=(S-v)/2,E=v=S}this.context_.canvas.width=E,this.context_.canvas.height=v,h=this.context_}else h=t;var x=h.globalAlpha;h.globalAlpha=o.opacity,h!=t&&h.translate(f,_);var P=e.size[0]*i,T=e.size[1]*i;if(ol.render.canvas.rotateAtOffset(h,-s,P/2,T/2),d.replay(h,i,c,s,n),g.getWrapX()&&a.canWrapX()&&!ol.extent.containsExtent(p,r)){for(var R,L=r[0],M=ol.extent.getWidth(p),C=0;L<p[0];)--C,R=M*C,c=this.getTransform(e,R),d.replay(h,i,c,s,n),L+=M;for(C=0,L=r[2];L>p[2];)++C,R=M*C,c=this.getTransform(e,R),d.replay(h,i,c,s,n),L-=M;c=this.getTransform(e,0)}ol.render.canvas.rotateAtOffset(h,s,P/2,T/2),h!=t&&(this.dispatchRenderEvent(h,e,c),t.drawImage(h.canvas,-f,-_),h.translate(-f,-_)),h.globalAlpha=x}y&&t.restore(),this.postCompose(t,e,o,c)},ol.renderer.canvas.VectorLayer.prototype.forEachFeatureAtCoordinate=function(e,o,t,r,i){if(this.replayGroup_){var n=o.viewState.resolution,l=o.viewState.rotation,a=this.getLayer(),s={};return this.replayGroup_.forEachFeatureAtCoordinate(e,n,l,t,{},function(e){var o=ol.getUid(e).toString();if(!(o in s))return s[o]=!0,r.call(i,e,a)})}},ol.renderer.canvas.VectorLayer.prototype.handleStyleImageChange_=function(e){this.renderIfReadyAndVisible()},ol.renderer.canvas.VectorLayer.prototype.prepareFrame=function(e,o){var t=this.getLayer(),r=t.getSource();this.updateAttributions(e.attributions,r.getAttributions()),this.updateLogos(e,r);var i=e.viewHints[ol.View.Hint.ANIMATING],n=e.viewHints[ol.View.Hint.INTERACTING],l=t.getUpdateWhileAnimating(),a=t.getUpdateWhileInteracting();if(!this.dirty_&&!l&&i||!a&&n)return!0;var s=e.extent,p=e.viewState,g=p.projection,c=p.resolution,u=e.pixelRatio,y=t.getRevision(),d=t.getRenderBuffer(),h=t.getRenderOrder();void 0===h&&(h=ol.renderer.vector.defaultOrder);var m=ol.extent.buffer(s,d*c),f=p.projection.getExtent();if(r.getWrapX()&&p.projection.canWrapX()&&!ol.extent.containsExtent(f,e.extent)){var _=ol.extent.getWidth(f),E=Math.max(ol.extent.getWidth(m)/2,_);m[0]=f[0]-E,m[2]=f[2]+E}if(!this.dirty_&&this.renderedResolution_==c&&this.renderedRevision_==y&&this.renderedRenderOrder_==h&&ol.extent.containsExtent(this.renderedExtent_,m))return!0;this.replayGroup_=null,this.dirty_=!1;var v=new ol.render.canvas.ReplayGroup(ol.renderer.vector.getTolerance(c,u),m,c,r.getOverlaps(),t.getRenderBuffer());r.loadFeatures(m,c,g);var S=function(e){var o,r=e.getStyleFunction();if(r?o=r.call(e,c):(r=t.getStyleFunction())&&(o=r(e,c)),o){var i=this.renderFeature(e,c,u,o,v);this.dirty_=this.dirty_||i}};if(h){var x=[];r.forEachFeatureInExtent(m,function(e){x.push(e)},this),x.sort(h),x.forEach(S,this)}else r.forEachFeatureInExtent(m,S,this);return v.finish(),this.renderedResolution_=c,this.renderedRevision_=y,this.renderedRenderOrder_=h,this.renderedExtent_=m,this.replayGroup_=v,!0},ol.renderer.canvas.VectorLayer.prototype.renderFeature=function(e,o,t,r,i){if(!r)return!1;var n=!1;if(Array.isArray(r))for(var l=0,a=r.length;l<a;++l)n=ol.renderer.vector.renderFeature(i,e,r[l],ol.renderer.vector.getSquaredTolerance(o,t),this.handleStyleImageChange_,this)||n;else n=ol.renderer.vector.renderFeature(i,e,r,ol.renderer.vector.getSquaredTolerance(o,t),this.handleStyleImageChange_,this)||n;return n},goog.provide("ol.renderer.canvas.VectorTileLayer"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.proj"),goog.require("ol.proj.Units"),goog.require("ol.layer.VectorTile"),goog.require("ol.render.ReplayType"),goog.require("ol.render.canvas"),goog.require("ol.render.canvas.ReplayGroup"),goog.require("ol.render.replay"),goog.require("ol.renderer.canvas.TileLayer"),goog.require("ol.renderer.vector"),goog.require("ol.size"),goog.require("ol.transform"),ol.renderer.canvas.VectorTileLayer=function(e){ol.renderer.canvas.TileLayer.call(this,e),this.dirty_=!1,this.tmpTransform_=ol.transform.create(),this.zDirection=e.getRenderMode()==ol.layer.VectorTile.RenderType.VECTOR?1:0},ol.inherits(ol.renderer.canvas.VectorTileLayer,ol.renderer.canvas.TileLayer),ol.renderer.canvas.VectorTileLayer.IMAGE_REPLAYS={image:ol.render.replay.ORDER,hybrid:[ol.render.ReplayType.POLYGON,ol.render.ReplayType.LINE_STRING]},ol.renderer.canvas.VectorTileLayer.VECTOR_REPLAYS={hybrid:[ol.render.ReplayType.IMAGE,ol.render.ReplayType.TEXT],vector:ol.render.replay.ORDER},ol.renderer.canvas.VectorTileLayer.prototype.createReplayGroup_=function(e,o){function t(e){var o,t=e.getStyleFunction();if(t?o=t.call(e,m):(t=r.getStyleFunction())&&(o=t(e,m)),o){Array.isArray(o)||(o=[o]);var i=this.renderFeature(e,v,o,E);this.dirty_=this.dirty_||i,s.dirty=s.dirty||i}}var r=this.getLayer(),i=o.pixelRatio,n=o.viewState.projection,l=r.getRevision(),a=r.getRenderOrder()||null,s=e.getReplayState();if(s.dirty||s.renderedRevision!=l||s.renderedRenderOrder!=a){s.replayGroup=null,s.dirty=!1;var p,g,c,u=r.getSource(),y=u.getTileGrid(),d=e.tileCoord,h=e.getProjection(),m=y.getResolution(d[0]);if(h.getUnits()==ol.proj.Units.TILE_PIXELS){var f=c=u.getTilePixelRatio(),_=ol.size.toSize(y.getTileSize(d[0]));p=[0,0,_[0]*f,_[1]*f]}else c=m,p=y.getTileCoordExtent(d),ol.proj.equivalent(n,h)||(g=!0,e.setProjection(n));s.dirty=!1;var E=new ol.render.canvas.ReplayGroup(0,p,c,u.getOverlaps(),r.getRenderBuffer()),v=ol.renderer.vector.getSquaredTolerance(c,i),S=e.getFeatures();a&&a!==s.renderedRenderOrder&&S.sort(a);for(var x,P=0,T=S.length;P<T;++P)x=S[P],g&&x.getGeometry().transform(h,n),t.call(this,x);E.finish(),s.renderedRevision=l,s.renderedRenderOrder=a,s.replayGroup=E,s.resolution=NaN}},ol.renderer.canvas.VectorTileLayer.prototype.drawTileImage=function(e,o,t,r,i,n,l,a){var s=e;this.createReplayGroup_(s,o),this.getLayer().getRenderMode()!=ol.layer.VectorTile.RenderType.VECTOR&&this.renderTileImage_(s,o,t),ol.renderer.canvas.TileLayer.prototype.drawTileImage.apply(this,arguments)},ol.renderer.canvas.VectorTileLayer.prototype.forEachFeatureAtCoordinate=function(e,o,t,r,i){var n=o.viewState.resolution,l=o.viewState.rotation;t=void 0==t?0:t;var a,s,p,g,c,u,y,d,h,m,f,_=this.getLayer(),E={},v=this.renderedTiles,S=_.getSource(),x=S.getTileGrid();for(p=0,g=v.length;p<g;++p)y=v[p],d=y.tileCoord,h=S.getTileGrid().getTileCoordExtent(d,this.tmpExtent),ol.extent.containsCoordinate(ol.extent.buffer(h,t*n),e)&&(y.getProjection().getUnits()===ol.proj.Units.TILE_PIXELS?(c=ol.extent.getTopLeft(h),m=S.getTilePixelRatio(),f=x.getResolution(d[0])/m,s=[(e[0]-c[0])/f,(c[1]-e[1])/f],n=m):s=e,u=y.getReplayState().replayGroup,a=a||u.forEachFeatureAtCoordinate(s,n,l,t,{},function(e){var o=ol.getUid(e).toString();if(!(o in E))return E[o]=!0,r.call(i,e,_)}));return a},ol.renderer.canvas.VectorTileLayer.prototype.getReplayTransform_=function(e,o){if(e.getProjection().getUnits()==ol.proj.Units.TILE_PIXELS){var t=this.getLayer(),r=t.getSource(),i=r.getTileGrid(),n=e.tileCoord,l=i.getResolution(n[0])/r.getTilePixelRatio(),a=o.viewState,s=o.pixelRatio,p=a.resolution/s,g=i.getTileCoordExtent(n,this.tmpExtent),c=a.center,u=ol.extent.getTopLeft(g),y=o.size,d=Math.round(s*y[0]/2),h=Math.round(s*y[1]/2);return ol.transform.compose(this.tmpTransform_,d,h,l/p,l/p,a.rotation,(u[0]-c[0])/l,(c[1]-u[1])/l)}return this.getTransform(o,0)},ol.renderer.canvas.VectorTileLayer.prototype.handleStyleImageChange_=function(e){this.renderIfReadyAndVisible()},ol.renderer.canvas.VectorTileLayer.prototype.postCompose=function(e,o,t){var r=this.getLayer().getRenderMode(),i=ol.renderer.canvas.VectorTileLayer.VECTOR_REPLAYS[r];if(i)for(var n=o.pixelRatio,l=o.viewState.rotation,a=o.size,s=Math.round(n*a[0]/2),p=Math.round(n*a[1]/2),g=this.renderedTiles,c=[],u=[],y=g.length-1;y>=0;--y){var d=g[y],h=this.getReplayTransform_(d,o),m=d.getReplayState().replayGroup.getClipCoords(h),f=d.tileCoord[0];e.save(),e.globalAlpha=t.opacity,ol.render.canvas.rotateAtOffset(e,-l,s,p);for(var _=0,E=c.length;_<E;++_){var v=c[_];f<u[_]&&(e.beginPath(),e.moveTo(m[0],m[1]),e.lineTo(m[2],m[3]),e.lineTo(m[4],m[5]),e.lineTo(m[6],m[7]),e.moveTo(v[6],v[7]),e.lineTo(v[4],v[5]),e.lineTo(v[2],v[3]),e.lineTo(v[0],v[1]),e.clip())}var S=d.getReplayState().replayGroup;S.replay(e,n,h,l,{},i),e.restore(),c.push(m),u.push(f)}ol.renderer.canvas.TileLayer.prototype.postCompose.apply(this,arguments)},ol.renderer.canvas.VectorTileLayer.prototype.renderFeature=function(e,o,t,r){if(!t)return!1;var i=!1;if(Array.isArray(t))for(var n=0,l=t.length;n<l;++n)i=ol.renderer.vector.renderFeature(r,e,t[n],o,this.handleStyleImageChange_,this)||i;else i=ol.renderer.vector.renderFeature(r,e,t,o,this.handleStyleImageChange_,this)||i;return i},ol.renderer.canvas.VectorTileLayer.prototype.renderTileImage_=function(e,o,t){var r=this.getLayer(),i=e.getReplayState(),n=r.getRevision(),l=ol.renderer.canvas.VectorTileLayer.IMAGE_REPLAYS[r.getRenderMode()];if(l&&i.renderedTileRevision!==n){i.renderedTileRevision=n;var a=e.tileCoord,s=e.tileCoord[0],p=o.pixelRatio,g=r.getSource(),c=g.getTileGrid(),u=g.getTilePixelRatio(),y=ol.transform.reset(this.tmpTransform_);if(e.getProjection().getUnits()==ol.proj.Units.TILE_PIXELS){var d=p/u;ol.transform.scale(y,d,d)}else{var h=c.getResolution(s),m=p/h,f=c.getTileCoordExtent(a,this.tmpExtent);ol.transform.scale(y,m,-m),ol.transform.translate(y,-f[0],-f[3])}var _=e.getContext(),E=g.getTilePixelSize(s,p,o.viewState.projection);_.canvas.width=E[0],_.canvas.height=E[1],i.replayGroup.replay(_,p,y,0,{},l)}},goog.provide("ol.renderer.canvas.Map"),goog.require("ol.transform"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.css"),goog.require("ol.dom"),goog.require("ol.layer.Image"),goog.require("ol.layer.Layer"),goog.require("ol.layer.Tile"),goog.require("ol.layer.Vector"),goog.require("ol.layer.VectorTile"),goog.require("ol.render.Event"),goog.require("ol.render.canvas"),goog.require("ol.render.canvas.Immediate"),goog.require("ol.renderer.Map"),goog.require("ol.renderer.Type"),goog.require("ol.renderer.canvas.ImageLayer"),goog.require("ol.renderer.canvas.TileLayer"),goog.require("ol.renderer.canvas.VectorLayer"),goog.require("ol.renderer.canvas.VectorTileLayer"),goog.require("ol.source.State"),ol.renderer.canvas.Map=function(e,o){ol.renderer.Map.call(this,e,o),this.context_=ol.dom.createCanvasContext2D(),this.canvas_=this.context_.canvas,this.canvas_.style.width="100%",this.canvas_.style.height="100%",this.canvas_.className=ol.css.CLASS_UNSELECTABLE,e.insertBefore(this.canvas_,e.childNodes[0]||null),this.renderedVisible_=!0,this.transform_=ol.transform.create()},ol.inherits(ol.renderer.canvas.Map,ol.renderer.Map),ol.renderer.canvas.Map.prototype.createLayerRenderer=function(e){return ol.ENABLE_IMAGE&&e instanceof ol.layer.Image?new ol.renderer.canvas.ImageLayer(e):ol.ENABLE_TILE&&e instanceof ol.layer.Tile?new ol.renderer.canvas.TileLayer(e):ol.ENABLE_VECTOR_TILE&&e instanceof ol.layer.VectorTile?new ol.renderer.canvas.VectorTileLayer(e):ol.ENABLE_VECTOR&&e instanceof ol.layer.Vector?new ol.renderer.canvas.VectorLayer(e):(ol.DEBUG&&console.assert(!1,"unexpected layer configuration"),null)},ol.renderer.canvas.Map.prototype.dispatchComposeEvent_=function(e,o){var t=this.getMap(),r=this.context_;if(t.hasListener(e)){var i=o.extent,n=o.pixelRatio,l=o.viewState,a=l.rotation,s=this.getTransform(o),p=new ol.render.canvas.Immediate(r,n,i,s,a),g=new ol.render.Event(e,p,o,r,null);t.dispatchEvent(g)}},ol.renderer.canvas.Map.prototype.getTransform=function(e){var o=e.viewState,t=this.canvas_.width/2,r=this.canvas_.height/2,i=e.pixelRatio/o.resolution,n=-i,l=-o.rotation,a=-o.center[0],s=-o.center[1];return ol.transform.compose(this.transform_,t,r,i,n,l,a,s)},ol.renderer.canvas.Map.prototype.getType=function(){return ol.renderer.Type.CANVAS},ol.renderer.canvas.Map.prototype.renderFrame=function(e){if(!e)return void(this.renderedVisible_&&(this.canvas_.style.display="none",this.renderedVisible_=!1));var o=this.context_,t=e.pixelRatio,r=Math.round(e.size[0]*t),i=Math.round(e.size[1]*t);this.canvas_.width!=r||this.canvas_.height!=i?(this.canvas_.width=r,this.canvas_.height=i):o.clearRect(0,0,r,i);var n=e.viewState.rotation;this.calculateMatrices2D(e),this.dispatchComposeEvent_(ol.render.Event.Type.PRECOMPOSE,e);var l=e.layerStatesArray;ol.array.stableSort(l,ol.renderer.Map.sortByZIndex),ol.render.canvas.rotateAtOffset(o,n,r/2,i/2);var a,s,p,g,c,u=e.viewState.resolution;for(a=0,s=l.length;a<s;++a)c=l[a],p=c.layer,g=this.getLayerRenderer(p),ol.layer.Layer.visibleAtResolution(c,u)&&c.sourceState==ol.source.State.READY&&g.prepareFrame(e,c)&&g.composeFrame(e,c,o);ol.render.canvas.rotateAtOffset(o,-n,r/2,i/2),this.dispatchComposeEvent_(ol.render.Event.Type.POSTCOMPOSE,e),this.renderedVisible_||(this.canvas_.style.display="",this.renderedVisible_=!0),this.scheduleRemoveUnusedLayerRenderers(e),this.scheduleExpireIconCache(e)},ol.renderer.canvas.Map.prototype.forEachLayerAtPixel=function(e,o,t,r,i,n){var l,a,s=o.viewState,p=s.resolution,g=o.layerStatesArray,c=g.length,u=ol.transform.apply(o.pixelToCoordinateTransform,e.slice());for(a=c-1;a>=0;--a){var y=g[a],d=y.layer;if(ol.layer.Layer.visibleAtResolution(y,p)&&i.call(n,d)){if(l=this.getLayerRenderer(d).forEachLayerAtCoordinate(u,o,t,r))return l}}},goog.provide("ol.render.webgl"),ol.render.webgl.defaultFillStyle=[0,0,0,1],ol.render.webgl.defaultLineCap="round",ol.render.webgl.defaultLineDash=[],ol.render.webgl.defaultLineJoin="round",ol.render.webgl.defaultMiterLimit=10,ol.render.webgl.defaultStrokeStyle=[0,0,0,1],ol.render.webgl.defaultLineWidth=1,ol.render.webgl.lineStringInstruction={ROUND:2,BEGIN_LINE:3,END_LINE:5,BEGIN_LINE_CAP:7,END_LINE_CAP:11,BEVEL_FIRST:13,BEVEL_SECOND:17,MITER_BOTTOM:19,MITER_TOP:23},ol.render.webgl.triangleIsCounterClockwise=function(e,o,t,r,i,n){var l=(t-e)*(n-o)-(i-e)*(r-o);return l<=ol.render.webgl.EPSILON&&l>=-ol.render.webgl.EPSILON?void 0:l>0},ol.render.webgl.EPSILON=Number.EPSILON||2.220446049250313e-16,goog.provide("ol.webgl.Shader"),goog.require("ol.functions"),goog.require("ol.webgl"),ol.webgl.Shader=function(e){this.source_=e},ol.webgl.Shader.prototype.getType=function(){},ol.webgl.Shader.prototype.getSource=function(){return this.source_},ol.webgl.Shader.prototype.isAnimated=ol.functions.FALSE,goog.provide("ol.webgl.Fragment"),goog.require("ol"),goog.require("ol.webgl"),goog.require("ol.webgl.Shader"),ol.webgl.Fragment=function(e){ol.webgl.Shader.call(this,e)},ol.inherits(ol.webgl.Fragment,ol.webgl.Shader),ol.webgl.Fragment.prototype.getType=function(){return ol.webgl.FRAGMENT_SHADER},goog.provide("ol.webgl.Vertex"),goog.require("ol"),goog.require("ol.webgl"),goog.require("ol.webgl.Shader"),ol.webgl.Vertex=function(e){ol.webgl.Shader.call(this,e)},ol.inherits(ol.webgl.Vertex,ol.webgl.Shader),ol.webgl.Vertex.prototype.getType=function(){return ol.webgl.VERTEX_SHADER},goog.provide("ol.render.webgl.circlereplay.defaultshader"),goog.require("ol"),goog.require("ol.webgl.Fragment"),goog.require("ol.webgl.Vertex"),ol.render.webgl.circlereplay.defaultshader.Fragment=function(){ol.webgl.Fragment.call(this,ol.render.webgl.circlereplay.defaultshader.Fragment.SOURCE)},ol.inherits(ol.render.webgl.circlereplay.defaultshader.Fragment,ol.webgl.Fragment),ol.render.webgl.circlereplay.defaultshader.Fragment.DEBUG_SOURCE="precision mediump float;\nvarying vec2 v_center;\nvarying vec2 v_offset;\nvarying float v_halfWidth;\nvarying float v_pixelRatio;\n\n\n\nuniform float u_opacity;\nuniform vec4 u_fillColor;\nuniform vec4 u_strokeColor;\nuniform vec2 u_size;\n\nvoid main(void) {\n  vec2 windowCenter = vec2((v_center.x + 1.0) / 2.0 * u_size.x * v_pixelRatio,\n      (v_center.y + 1.0) / 2.0 * u_size.y * v_pixelRatio);\n  vec2 windowOffset = vec2((v_offset.x + 1.0) / 2.0 * u_size.x * v_pixelRatio,\n      (v_offset.y + 1.0) / 2.0 * u_size.y * v_pixelRatio);\n  float radius = length(windowCenter - windowOffset);\n  float dist = length(windowCenter - gl_FragCoord.xy);\n  if (dist > radius + v_halfWidth) {\n    if (u_strokeColor.a == 0.0) {\n      gl_FragColor = u_fillColor;\n    } else {\n      gl_FragColor = u_strokeColor;\n    }\n    gl_FragColor.a = gl_FragColor.a - (dist - (radius + v_halfWidth));\n  } else if (u_fillColor.a == 0.0) {\n    // Hooray, no fill, just stroke. We can use real antialiasing.\n    gl_FragColor = u_strokeColor;\n    if (dist < radius - v_halfWidth) {\n      gl_FragColor.a = gl_FragColor.a - (radius - v_halfWidth - dist);\n    }\n  } else {\n    gl_FragColor = u_fillColor;\n    float strokeDist = radius - v_halfWidth;\n    float antialias = 2.0 * v_pixelRatio;\n    if (dist > strokeDist) {\n      gl_FragColor = u_strokeColor;\n    } else if (dist >= strokeDist - antialias) {\n      float step = smoothstep(strokeDist - antialias, strokeDist, dist);\n      gl_FragColor = mix(u_fillColor, u_strokeColor, step);\n    }\n  }\n  gl_FragColor.a = gl_FragColor.a * u_opacity;\n  if (gl_FragColor.a <= 0.0) {\n    discard;\n  }\n}\n",ol.render.webgl.circlereplay.defaultshader.Fragment.OPTIMIZED_SOURCE="precision mediump float;varying vec2 a;varying vec2 b;varying float c;varying float d;uniform float m;uniform vec4 n;uniform vec4 o;uniform vec2 p;void main(void){vec2 windowCenter=vec2((a.x+1.0)/2.0*p.x*d,(a.y+1.0)/2.0*p.y*d);vec2 windowOffset=vec2((b.x+1.0)/2.0*p.x*d,(b.y+1.0)/2.0*p.y*d);float radius=length(windowCenter-windowOffset);float dist=length(windowCenter-gl_FragCoord.xy);if(dist>radius+c){if(o.a==0.0){gl_FragColor=n;}else{gl_FragColor=o;}gl_FragColor.a=gl_FragColor.a-(dist-(radius+c));}else if(n.a==0.0){gl_FragColor=o;if(dist<radius-c){gl_FragColor.a=gl_FragColor.a-(radius-c-dist);}} else{gl_FragColor=n;float strokeDist=radius-c;float antialias=2.0*d;if(dist>strokeDist){gl_FragColor=o;}else if(dist>=strokeDist-antialias){float step=smoothstep(strokeDist-antialias,strokeDist,dist);gl_FragColor=mix(n,o,step);}} gl_FragColor.a=gl_FragColor.a*m;if(gl_FragColor.a<=0.0){discard;}}",ol.render.webgl.circlereplay.defaultshader.Fragment.SOURCE=ol.DEBUG?ol.render.webgl.circlereplay.defaultshader.Fragment.DEBUG_SOURCE:ol.render.webgl.circlereplay.defaultshader.Fragment.OPTIMIZED_SOURCE,ol.render.webgl.circlereplay.defaultshader.fragment=new ol.render.webgl.circlereplay.defaultshader.Fragment,ol.render.webgl.circlereplay.defaultshader.Vertex=function(){ol.webgl.Vertex.call(this,ol.render.webgl.circlereplay.defaultshader.Vertex.SOURCE)},ol.inherits(ol.render.webgl.circlereplay.defaultshader.Vertex,ol.webgl.Vertex),ol.render.webgl.circlereplay.defaultshader.Vertex.DEBUG_SOURCE="varying vec2 v_center;\nvarying vec2 v_offset;\nvarying float v_halfWidth;\nvarying float v_pixelRatio;\n\n\nattribute vec2 a_position;\nattribute float a_instruction;\nattribute float a_radius;\n\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_offsetScaleMatrix;\nuniform mat4 u_offsetRotateMatrix;\nuniform float u_lineWidth;\nuniform float u_pixelRatio;\n\nvoid main(void) {\n  mat4 offsetMatrix = u_offsetScaleMatrix * u_offsetRotateMatrix;\n  v_center = vec4(u_projectionMatrix * vec4(a_position, 0.0, 1.0)).xy;\n  v_pixelRatio = u_pixelRatio;\n  float lineWidth = u_lineWidth * u_pixelRatio;\n  v_halfWidth = lineWidth / 2.0;\n  if (lineWidth == 0.0) {\n    lineWidth = 2.0 * u_pixelRatio;\n  }\n  vec2 offset;\n  // Radius with anitaliasing (roughly).\n  float radius = a_radius + 3.0 * u_pixelRatio;\n  // Until we get gl_VertexID in WebGL, we store an instruction.\n  if (a_instruction == 0.0) {\n    // Offsetting the edges of the triangle by lineWidth / 2 is necessary, however\n    // we should also leave some space for the antialiasing, thus we offset by lineWidth.\n    offset = vec2(-1.0, 1.0);\n  } else if (a_instruction == 1.0) {\n    offset = vec2(-1.0, -1.0);\n  } else if (a_instruction == 2.0) {\n    offset = vec2(1.0, -1.0);\n  } else {\n    offset = vec2(1.0, 1.0);\n  }\n\n  gl_Position = u_projectionMatrix * vec4(a_position + offset * radius, 0.0, 1.0) +\n      offsetMatrix * vec4(offset * lineWidth, 0.0, 0.0);\n  v_offset = vec4(u_projectionMatrix * vec4(a_position.x + a_radius, a_position.y,\n      0.0, 1.0)).xy;\n\n  if (distance(v_center, v_offset) > 20000.0) {\n    gl_Position = vec4(v_center, 0.0, 1.0);\n  }\n}\n\n\n",
ol.render.webgl.circlereplay.defaultshader.Vertex.OPTIMIZED_SOURCE="varying vec2 a;varying vec2 b;varying float c;varying float d;attribute vec2 e;attribute float f;attribute float g;uniform mat4 h;uniform mat4 i;uniform mat4 j;uniform float k;uniform float l;void main(void){mat4 offsetMatrix=i*j;a=vec4(h*vec4(e,0.0,1.0)).xy;d=l;float lineWidth=k*l;c=lineWidth/2.0;if(lineWidth==0.0){lineWidth=2.0*l;}vec2 offset;float radius=g+3.0*l;if(f==0.0){offset=vec2(-1.0,1.0);}else if(f==1.0){offset=vec2(-1.0,-1.0);}else if(f==2.0){offset=vec2(1.0,-1.0);}else{offset=vec2(1.0,1.0);}gl_Position=h*vec4(e+offset*radius,0.0,1.0)+offsetMatrix*vec4(offset*lineWidth,0.0,0.0);b=vec4(h*vec4(e.x+g,e.y,0.0,1.0)).xy;if(distance(a,b)>20000.0){gl_Position=vec4(a,0.0,1.0);}}",ol.render.webgl.circlereplay.defaultshader.Vertex.SOURCE=ol.DEBUG?ol.render.webgl.circlereplay.defaultshader.Vertex.DEBUG_SOURCE:ol.render.webgl.circlereplay.defaultshader.Vertex.OPTIMIZED_SOURCE,ol.render.webgl.circlereplay.defaultshader.vertex=new ol.render.webgl.circlereplay.defaultshader.Vertex,ol.render.webgl.circlereplay.defaultshader.Locations=function(e,o){this.u_fillColor=e.getUniformLocation(o,ol.DEBUG?"u_fillColor":"n"),this.u_lineWidth=e.getUniformLocation(o,ol.DEBUG?"u_lineWidth":"k"),this.u_offsetRotateMatrix=e.getUniformLocation(o,ol.DEBUG?"u_offsetRotateMatrix":"j"),this.u_offsetScaleMatrix=e.getUniformLocation(o,ol.DEBUG?"u_offsetScaleMatrix":"i"),this.u_opacity=e.getUniformLocation(o,ol.DEBUG?"u_opacity":"m"),this.u_pixelRatio=e.getUniformLocation(o,ol.DEBUG?"u_pixelRatio":"l"),this.u_projectionMatrix=e.getUniformLocation(o,ol.DEBUG?"u_projectionMatrix":"h"),this.u_size=e.getUniformLocation(o,ol.DEBUG?"u_size":"p"),this.u_strokeColor=e.getUniformLocation(o,ol.DEBUG?"u_strokeColor":"o"),this.a_instruction=e.getAttribLocation(o,ol.DEBUG?"a_instruction":"f"),this.a_position=e.getAttribLocation(o,ol.DEBUG?"a_position":"e"),this.a_radius=e.getAttribLocation(o,ol.DEBUG?"a_radius":"g")},goog.provide("ol.vec.Mat4"),ol.vec.Mat4.create=function(){return[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]},ol.vec.Mat4.fromTransform=function(e,o){return e[0]=o[0],e[1]=o[1],e[4]=o[2],e[5]=o[3],e[12]=o[4],e[13]=o[5],e},goog.provide("ol.render.webgl.Replay"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.render.VectorContext");goog.require("ol.transform"),goog.require("ol.vec.Mat4"),goog.require("ol.webgl"),ol.render.webgl.Replay=function(e,o){ol.render.VectorContext.call(this),this.tolerance=e,this.maxExtent=o,this.origin=ol.extent.getCenter(o),this.projectionMatrix_=ol.transform.create(),this.offsetRotateMatrix_=ol.transform.create(),this.offsetScaleMatrix_=ol.transform.create(),this.tmpMat4_=ol.vec.Mat4.create(),this.indices=[],this.indicesBuffer=null,this.startIndices=[],this.startIndicesFeature=[],this.vertices=[],this.verticesBuffer=null,this.lineStringReplay=void 0},ol.inherits(ol.render.webgl.Replay,ol.render.VectorContext),ol.render.webgl.Replay.prototype.getDeleteResourcesFunction=function(e){},ol.render.webgl.Replay.prototype.finish=function(e){},ol.render.webgl.Replay.prototype.setUpProgram=function(e,o,t,r){},ol.render.webgl.Replay.prototype.shutDownProgram=function(e,o){},ol.render.webgl.Replay.prototype.drawReplay=function(e,o,t,r){},ol.render.webgl.Replay.prototype.drawHitDetectionReplayOneByOne=function(e,o,t,r,i){},ol.render.webgl.Replay.prototype.drawHitDetectionReplay=function(e,o,t,r,i,n){return i?this.drawHitDetectionReplayOneByOne(e,o,t,r,n):this.drawHitDetectionReplayAll(e,o,t,r)},ol.render.webgl.Replay.prototype.drawHitDetectionReplayAll=function(e,o,t,r){e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT),this.drawReplay(e,o,t,!0);var i=r(null);return i||void 0},ol.render.webgl.Replay.prototype.replay=function(e,o,t,r,i,n,l,a,s,p,g){var c,u,y,d,h,m,f,_,E=e.getGL();this.lineStringReplay&&(c=E.isEnabled(E.STENCIL_TEST),u=E.getParameter(E.STENCIL_FUNC),y=E.getParameter(E.STENCIL_VALUE_MASK),d=E.getParameter(E.STENCIL_REF),h=E.getParameter(E.STENCIL_WRITEMASK),m=E.getParameter(E.STENCIL_FAIL),f=E.getParameter(E.STENCIL_PASS_DEPTH_PASS),_=E.getParameter(E.STENCIL_PASS_DEPTH_FAIL),E.enable(E.STENCIL_TEST),E.clear(E.STENCIL_BUFFER_BIT),E.stencilMask(255),E.stencilFunc(E.ALWAYS,1,255),E.stencilOp(E.KEEP,E.KEEP,E.REPLACE),this.lineStringReplay.replay(e,o,t,r,i,n,l,a,s,p,g),E.stencilMask(0),E.stencilFunc(E.NOTEQUAL,1,255)),ol.DEBUG&&console.assert(this.verticesBuffer,"verticesBuffer must not be null"),e.bindBuffer(ol.webgl.ARRAY_BUFFER,this.verticesBuffer),ol.DEBUG&&console.assert(this.indicesBuffer,"indicesBuffer must not be null"),e.bindBuffer(ol.webgl.ELEMENT_ARRAY_BUFFER,this.indicesBuffer);var v=this.setUpProgram(E,e,i,n),S=ol.transform.reset(this.projectionMatrix_);ol.transform.scale(S,2/(t*i[0]),2/(t*i[1])),ol.transform.rotate(S,-r),ol.transform.translate(S,-(o[0]-this.origin[0]),-(o[1]-this.origin[1]));var x=ol.transform.reset(this.offsetScaleMatrix_);ol.transform.scale(x,2/i[0],2/i[1]);var P=ol.transform.reset(this.offsetRotateMatrix_);0!==r&&ol.transform.rotate(P,-r),E.uniformMatrix4fv(v.u_projectionMatrix,!1,ol.vec.Mat4.fromTransform(this.tmpMat4_,S)),E.uniformMatrix4fv(v.u_offsetScaleMatrix,!1,ol.vec.Mat4.fromTransform(this.tmpMat4_,x)),E.uniformMatrix4fv(v.u_offsetRotateMatrix,!1,ol.vec.Mat4.fromTransform(this.tmpMat4_,P)),E.uniform1f(v.u_opacity,l);var T;return void 0===s?this.drawReplay(E,e,a,!1):T=this.drawHitDetectionReplay(E,e,a,s,p,g),this.shutDownProgram(E,v),this.lineStringReplay&&(c||E.disable(E.STENCIL_TEST),E.clear(E.STENCIL_BUFFER_BIT),E.stencilFunc(u,d,y),E.stencilMask(h),E.stencilOp(m,_,f)),T},ol.render.webgl.Replay.prototype.drawElements=function(e,o,t,r){var i=o.hasOESElementIndexUint?ol.webgl.UNSIGNED_INT:ol.webgl.UNSIGNED_SHORT,n=o.hasOESElementIndexUint?4:2,l=r-t,a=t*n;e.drawElements(ol.webgl.TRIANGLES,l,i,a)},goog.provide("ol.webgl.Buffer"),goog.require("ol"),goog.require("ol.webgl"),ol.webgl.Buffer=function(e,o){this.arr_=void 0!==e?e:[],this.usage_=void 0!==o?o:ol.webgl.Buffer.Usage.STATIC_DRAW},ol.webgl.Buffer.prototype.getArray=function(){return this.arr_},ol.webgl.Buffer.prototype.getUsage=function(){return this.usage_},ol.webgl.Buffer.Usage={STATIC_DRAW:ol.webgl.STATIC_DRAW,STREAM_DRAW:ol.webgl.STREAM_DRAW,DYNAMIC_DRAW:ol.webgl.DYNAMIC_DRAW},goog.provide("ol.render.webgl.CircleReplay"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.color"),goog.require("ol.extent"),goog.require("ol.obj"),goog.require("ol.geom.flat.transform"),goog.require("ol.render.webgl.circlereplay.defaultshader"),goog.require("ol.render.webgl.Replay"),goog.require("ol.render.webgl"),goog.require("ol.webgl"),goog.require("ol.webgl.Buffer"),ol.render.webgl.CircleReplay=function(e,o){ol.render.webgl.Replay.call(this,e,o),this.defaultLocations_=null,this.styles_=[],this.styleIndices_=[],this.radius_=0,this.state_={fillColor:null,strokeColor:null,lineDash:null,lineWidth:void 0,changed:!1}},ol.inherits(ol.render.webgl.CircleReplay,ol.render.webgl.Replay),ol.render.webgl.CircleReplay.prototype.drawCoordinates_=function(e,o,t,r){var i,n,l=this.vertices.length,a=this.indices.length,s=l/4;for(i=o,n=t;i<n;i+=r)this.vertices[l++]=e[i],this.vertices[l++]=e[i+1],this.vertices[l++]=0,this.vertices[l++]=this.radius_,this.vertices[l++]=e[i],this.vertices[l++]=e[i+1],this.vertices[l++]=1,this.vertices[l++]=this.radius_,this.vertices[l++]=e[i],this.vertices[l++]=e[i+1],this.vertices[l++]=2,this.vertices[l++]=this.radius_,this.vertices[l++]=e[i],this.vertices[l++]=e[i+1],this.vertices[l++]=3,this.vertices[l++]=this.radius_,this.indices[a++]=s,this.indices[a++]=s+1,this.indices[a++]=s+2,this.indices[a++]=s+2,this.indices[a++]=s+3,this.indices[a++]=s,s+=4},ol.render.webgl.CircleReplay.prototype.drawCircle=function(e,o){var t=e.getRadius(),r=e.getStride();if(t){this.startIndices.push(this.indices.length),this.startIndicesFeature.push(o),this.state_.changed&&(this.styleIndices_.push(this.indices.length),this.state_.changed=!1),this.radius_=t;var i=e.getFlatCoordinates();i=ol.geom.flat.transform.translate(i,0,2,r,-this.origin[0],-this.origin[1]),this.drawCoordinates_(i,0,2,r)}else if(this.state_.changed&&(this.styles_.pop(),this.styles_.length)){var n=this.styles_[this.styles_.length-1];this.state_.fillColor=n[0],this.state_.strokeColor=n[1],this.state_.lineWidth=n[2],this.state_.changed=!1}},ol.render.webgl.CircleReplay.prototype.finish=function(e){this.verticesBuffer=new ol.webgl.Buffer(this.vertices),this.indicesBuffer=new ol.webgl.Buffer(this.indices),this.startIndices.push(this.indices.length),0===this.styleIndices_.length&&this.styles_.length>0&&(this.styles_=[]),this.vertices=null,this.indices=null},ol.render.webgl.CircleReplay.prototype.getDeleteResourcesFunction=function(e){ol.DEBUG&&console.assert(this.verticesBuffer,"verticesBuffer must not be null"),ol.DEBUG&&console.assert(this.indicesBuffer,"indicesBuffer must not be null");var o=this.verticesBuffer,t=this.indicesBuffer;return function(){e.deleteBuffer(o),e.deleteBuffer(t)}},ol.render.webgl.CircleReplay.prototype.setUpProgram=function(e,o,t,r){var i,n;i=ol.render.webgl.circlereplay.defaultshader.fragment,n=ol.render.webgl.circlereplay.defaultshader.vertex;var l,a=o.getProgram(i,n);return this.defaultLocations_?l=this.defaultLocations_:(l=new ol.render.webgl.circlereplay.defaultshader.Locations(e,a),this.defaultLocations_=l),o.useProgram(a),e.enableVertexAttribArray(l.a_position),e.vertexAttribPointer(l.a_position,2,ol.webgl.FLOAT,!1,16,0),e.enableVertexAttribArray(l.a_instruction),e.vertexAttribPointer(l.a_instruction,1,ol.webgl.FLOAT,!1,16,8),e.enableVertexAttribArray(l.a_radius),e.vertexAttribPointer(l.a_radius,1,ol.webgl.FLOAT,!1,16,12),e.uniform2fv(l.u_size,t),e.uniform1f(l.u_pixelRatio,r),l},ol.render.webgl.CircleReplay.prototype.shutDownProgram=function(e,o){e.disableVertexAttribArray(o.a_position),e.disableVertexAttribArray(o.a_instruction),e.disableVertexAttribArray(o.a_radius)},ol.render.webgl.CircleReplay.prototype.drawReplay=function(e,o,t,r){if(ol.obj.isEmpty(t)){ol.DEBUG&&console.assert(this.styles_.length===this.styleIndices_.length,"number of styles and styleIndices match");var i,n,l,a;for(l=this.startIndices[this.startIndices.length-1],i=this.styleIndices_.length-1;i>=0;--i)n=this.styleIndices_[i],a=this.styles_[i],this.setFillStyle_(e,a[0]),this.setStrokeStyle_(e,a[1],a[2]),this.drawElements(e,o,n,l),l=n}else this.drawReplaySkipping_(e,o,t)},ol.render.webgl.CircleReplay.prototype.drawHitDetectionReplayOneByOne=function(e,o,t,r,i){ol.DEBUG&&console.assert(this.styles_.length===this.styleIndices_.length,"number of styles and styleIndices match"),ol.DEBUG&&console.assert(this.startIndices.length-1===this.startIndicesFeature.length,"number of startIndices and startIndicesFeature match");var n,l,a,s,p,g,c,u;for(u=this.startIndices.length-2,a=this.startIndices[u+1],n=this.styleIndices_.length-1;n>=0;--n)for(s=this.styles_[n],this.setFillStyle_(e,s[0]),this.setStrokeStyle_(e,s[1],s[2]),p=this.styleIndices_[n];u>=0&&this.startIndices[u]>=p;){if(l=this.startIndices[u],g=this.startIndicesFeature[u],c=ol.getUid(g).toString(),void 0===t[c]&&g.getGeometry()&&(void 0===i||ol.extent.intersects(i,g.getGeometry().getExtent()))){e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT),this.drawElements(e,o,l,a);var y=r(g);if(y)return y}u--,a=l}},ol.render.webgl.CircleReplay.prototype.drawReplaySkipping_=function(e,o,t){ol.DEBUG&&console.assert(this.startIndices.length-1===this.startIndicesFeature.length,"number of startIndices and startIndicesFeature match");var r,i,n,l,a,s,p,g,c;for(g=this.startIndices.length-2,n=i=this.startIndices[g+1],r=this.styleIndices_.length-1;r>=0;--r){for(l=this.styles_[r],this.setFillStyle_(e,l[0]),this.setStrokeStyle_(e,l[1],l[2]),a=this.styleIndices_[r];g>=0&&this.startIndices[g]>=a;)c=this.startIndices[g],s=this.startIndicesFeature[g],p=ol.getUid(s).toString(),t[p]&&(i!==n&&this.drawElements(e,o,i,n),n=c),g--,i=c;i!==n&&this.drawElements(e,o,i,n),i=n=a}},ol.render.webgl.CircleReplay.prototype.setFillStyle_=function(e,o){e.uniform4fv(this.defaultLocations_.u_fillColor,o)},ol.render.webgl.CircleReplay.prototype.setStrokeStyle_=function(e,o,t){e.uniform4fv(this.defaultLocations_.u_strokeColor,o),e.uniform1f(this.defaultLocations_.u_lineWidth,t)},ol.render.webgl.CircleReplay.prototype.setFillStrokeStyle=function(e,o){ol.DEBUG&&console.assert(this.state_,"this.state_ should not be null");var t,r;if(o){var i=o.getLineDash();this.state_.lineDash=i||ol.render.webgl.defaultLineDash,t=o.getColor(),t=t instanceof CanvasGradient||t instanceof CanvasPattern?ol.render.webgl.defaultStrokeStyle:ol.color.asArray(t).map(function(e,o){return 3!=o?e/255:e})||ol.render.webgl.defaultStrokeStyle,r=o.getWidth(),r=void 0!==r?r:ol.render.webgl.defaultLineWidth}else t=[0,0,0,0],r=0;var n=e?e.getColor():[0,0,0,0];n=n instanceof CanvasGradient||n instanceof CanvasPattern?ol.render.webgl.defaultFillStyle:ol.color.asArray(n).map(function(e,o){return 3!=o?e/255:e})||ol.render.webgl.defaultFillStyle,this.state_.strokeColor&&ol.array.equals(this.state_.strokeColor,t)&&this.state_.fillColor&&ol.array.equals(this.state_.fillColor,n)&&this.state_.lineWidth===r||(this.state_.changed=!0,this.state_.fillColor=n,this.state_.strokeColor=t,this.state_.lineWidth=r,this.styles_.push([n,t,r]))},goog.provide("ol.render.webgl.imagereplay.defaultshader"),goog.require("ol"),goog.require("ol.webgl.Fragment"),goog.require("ol.webgl.Vertex"),ol.render.webgl.imagereplay.defaultshader.Fragment=function(){ol.webgl.Fragment.call(this,ol.render.webgl.imagereplay.defaultshader.Fragment.SOURCE)},ol.inherits(ol.render.webgl.imagereplay.defaultshader.Fragment,ol.webgl.Fragment),ol.render.webgl.imagereplay.defaultshader.Fragment.DEBUG_SOURCE="precision mediump float;\nvarying vec2 v_texCoord;\nvarying float v_opacity;\n\nuniform float u_opacity;\nuniform sampler2D u_image;\n\nvoid main(void) {\n  vec4 texColor = texture2D(u_image, v_texCoord);\n  gl_FragColor.rgb = texColor.rgb;\n  float alpha = texColor.a * v_opacity * u_opacity;\n  if (alpha == 0.0) {\n    discard;\n  }\n  gl_FragColor.a = alpha;\n}\n",ol.render.webgl.imagereplay.defaultshader.Fragment.OPTIMIZED_SOURCE="precision mediump float;varying vec2 a;varying float b;uniform float k;uniform sampler2D l;void main(void){vec4 texColor=texture2D(l,a);gl_FragColor.rgb=texColor.rgb;float alpha=texColor.a*b*k;if(alpha==0.0){discard;}gl_FragColor.a=alpha;}",ol.render.webgl.imagereplay.defaultshader.Fragment.SOURCE=ol.DEBUG?ol.render.webgl.imagereplay.defaultshader.Fragment.DEBUG_SOURCE:ol.render.webgl.imagereplay.defaultshader.Fragment.OPTIMIZED_SOURCE,ol.render.webgl.imagereplay.defaultshader.fragment=new ol.render.webgl.imagereplay.defaultshader.Fragment,ol.render.webgl.imagereplay.defaultshader.Vertex=function(){ol.webgl.Vertex.call(this,ol.render.webgl.imagereplay.defaultshader.Vertex.SOURCE)},ol.inherits(ol.render.webgl.imagereplay.defaultshader.Vertex,ol.webgl.Vertex),ol.render.webgl.imagereplay.defaultshader.Vertex.DEBUG_SOURCE="varying vec2 v_texCoord;\nvarying float v_opacity;\n\nattribute vec2 a_position;\nattribute vec2 a_texCoord;\nattribute vec2 a_offsets;\nattribute float a_opacity;\nattribute float a_rotateWithView;\n\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_offsetScaleMatrix;\nuniform mat4 u_offsetRotateMatrix;\n\nvoid main(void) {\n  mat4 offsetMatrix = u_offsetScaleMatrix;\n  if (a_rotateWithView == 1.0) {\n    offsetMatrix = u_offsetScaleMatrix * u_offsetRotateMatrix;\n  }\n  vec4 offsets = offsetMatrix * vec4(a_offsets, 0.0, 0.0);\n  gl_Position = u_projectionMatrix * vec4(a_position, 0.0, 1.0) + offsets;\n  v_texCoord = a_texCoord;\n  v_opacity = a_opacity;\n}\n\n\n",ol.render.webgl.imagereplay.defaultshader.Vertex.OPTIMIZED_SOURCE="varying vec2 a;varying float b;attribute vec2 c;attribute vec2 d;attribute vec2 e;attribute float f;attribute float g;uniform mat4 h;uniform mat4 i;uniform mat4 j;void main(void){mat4 offsetMatrix=i;if(g==1.0){offsetMatrix=i*j;}vec4 offsets=offsetMatrix*vec4(e,0.0,0.0);gl_Position=h*vec4(c,0.0,1.0)+offsets;a=d;b=f;}",ol.render.webgl.imagereplay.defaultshader.Vertex.SOURCE=ol.DEBUG?ol.render.webgl.imagereplay.defaultshader.Vertex.DEBUG_SOURCE:ol.render.webgl.imagereplay.defaultshader.Vertex.OPTIMIZED_SOURCE,ol.render.webgl.imagereplay.defaultshader.vertex=new ol.render.webgl.imagereplay.defaultshader.Vertex,ol.render.webgl.imagereplay.defaultshader.Locations=function(e,o){this.u_image=e.getUniformLocation(o,ol.DEBUG?"u_image":"l"),this.u_offsetRotateMatrix=e.getUniformLocation(o,ol.DEBUG?"u_offsetRotateMatrix":"j"),this.u_offsetScaleMatrix=e.getUniformLocation(o,ol.DEBUG?"u_offsetScaleMatrix":"i"),this.u_opacity=e.getUniformLocation(o,ol.DEBUG?"u_opacity":"k"),this.u_projectionMatrix=e.getUniformLocation(o,ol.DEBUG?"u_projectionMatrix":"h"),this.a_offsets=e.getAttribLocation(o,ol.DEBUG?"a_offsets":"e"),this.a_opacity=e.getAttribLocation(o,ol.DEBUG?"a_opacity":"f"),this.a_position=e.getAttribLocation(o,ol.DEBUG?"a_position":"c"),this.a_rotateWithView=e.getAttribLocation(o,ol.DEBUG?"a_rotateWithView":"g"),this.a_texCoord=e.getAttribLocation(o,ol.DEBUG?"a_texCoord":"d")},goog.provide("ol.webgl.ContextEventType"),ol.webgl.ContextEventType={LOST:"webglcontextlost",RESTORED:"webglcontextrestored"},goog.provide("ol.webgl.Context"),goog.require("ol"),goog.require("ol.Disposable"),goog.require("ol.array"),goog.require("ol.events"),goog.require("ol.obj"),goog.require("ol.webgl"),goog.require("ol.webgl.ContextEventType"),ol.webgl.Context=function(e,o){if(this.canvas_=e,this.gl_=o,this.bufferCache_={},this.shaderCache_={},this.programCache_={},this.currentProgram_=null,this.hitDetectionFramebuffer_=null,this.hitDetectionTexture_=null,this.hitDetectionRenderbuffer_=null,this.hasOESElementIndexUint=ol.array.includes(ol.WEBGL_EXTENSIONS,"OES_element_index_uint"),this.hasOESElementIndexUint){var t=o.getExtension("OES_element_index_uint");ol.DEBUG&&console.assert(t,'Failed to get extension "OES_element_index_uint"')}ol.events.listen(this.canvas_,ol.webgl.ContextEventType.LOST,this.handleWebGLContextLost,this),ol.events.listen(this.canvas_,ol.webgl.ContextEventType.RESTORED,this.handleWebGLContextRestored,this)},ol.inherits(ol.webgl.Context,ol.Disposable),ol.webgl.Context.prototype.bindBuffer=function(e,o){var t=this.getGL(),r=o.getArray(),i=String(ol.getUid(o));if(i in this.bufferCache_){var n=this.bufferCache_[i];t.bindBuffer(e,n.buffer)}else{var l=t.createBuffer();t.bindBuffer(e,l),ol.DEBUG&&console.assert(e==ol.webgl.ARRAY_BUFFER||e==ol.webgl.ELEMENT_ARRAY_BUFFER,"target is supposed to be an ARRAY_BUFFER or ELEMENT_ARRAY_BUFFER");var a;e==ol.webgl.ARRAY_BUFFER?a=new Float32Array(r):e==ol.webgl.ELEMENT_ARRAY_BUFFER&&(a=this.hasOESElementIndexUint?new Uint32Array(r):new Uint16Array(r)),t.bufferData(e,a,o.getUsage()),this.bufferCache_[i]={buf:o,buffer:l}}},ol.webgl.Context.prototype.deleteBuffer=function(e){var o=this.getGL(),t=String(ol.getUid(e));ol.DEBUG&&console.assert(t in this.bufferCache_,"attempted to delete uncached buffer");var r=this.bufferCache_[t];o.isContextLost()||o.deleteBuffer(r.buffer),delete this.bufferCache_[t]},ol.webgl.Context.prototype.disposeInternal=function(){ol.events.unlistenAll(this.canvas_);var e=this.getGL();if(!e.isContextLost()){var o;for(o in this.bufferCache_)e.deleteBuffer(this.bufferCache_[o].buffer);for(o in this.programCache_)e.deleteProgram(this.programCache_[o]);for(o in this.shaderCache_)e.deleteShader(this.shaderCache_[o]);e.deleteFramebuffer(this.hitDetectionFramebuffer_),e.deleteRenderbuffer(this.hitDetectionRenderbuffer_),e.deleteTexture(this.hitDetectionTexture_)}},ol.webgl.Context.prototype.getCanvas=function(){return this.canvas_},ol.webgl.Context.prototype.getGL=function(){return this.gl_},ol.webgl.Context.prototype.getHitDetectionFramebuffer=function(){return this.hitDetectionFramebuffer_||this.initHitDetectionFramebuffer_(),this.hitDetectionFramebuffer_},ol.webgl.Context.prototype.getShader=function(e){var o=String(ol.getUid(e));if(o in this.shaderCache_)return this.shaderCache_[o];var t=this.getGL(),r=t.createShader(e.getType());return t.shaderSource(r,e.getSource()),t.compileShader(r),ol.DEBUG&&console.assert(t.getShaderParameter(r,ol.webgl.COMPILE_STATUS)||t.isContextLost(),t.getShaderInfoLog(r)||"illegal state, shader not compiled or context lost"),this.shaderCache_[o]=r,r},ol.webgl.Context.prototype.getProgram=function(e,o){var t=ol.getUid(e)+"/"+ol.getUid(o);if(t in this.programCache_)return this.programCache_[t];var r=this.getGL(),i=r.createProgram();return r.attachShader(i,this.getShader(e)),r.attachShader(i,this.getShader(o)),r.linkProgram(i),ol.DEBUG&&console.assert(r.getProgramParameter(i,ol.webgl.LINK_STATUS)||r.isContextLost(),r.getProgramInfoLog(i)||"illegal state, shader not linked or context lost"),this.programCache_[t]=i,i},ol.webgl.Context.prototype.handleWebGLContextLost=function(){ol.obj.clear(this.bufferCache_),ol.obj.clear(this.shaderCache_),ol.obj.clear(this.programCache_),this.currentProgram_=null,this.hitDetectionFramebuffer_=null,this.hitDetectionTexture_=null,this.hitDetectionRenderbuffer_=null},ol.webgl.Context.prototype.handleWebGLContextRestored=function(){},ol.webgl.Context.prototype.initHitDetectionFramebuffer_=function(){var e=this.gl_,o=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,o);var t=ol.webgl.Context.createEmptyTexture(e,1,1),r=e.createRenderbuffer();e.bindRenderbuffer(e.RENDERBUFFER,r),e.renderbufferStorage(e.RENDERBUFFER,e.DEPTH_COMPONENT16,1,1),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,r),e.bindTexture(e.TEXTURE_2D,null),e.bindRenderbuffer(e.RENDERBUFFER,null),e.bindFramebuffer(e.FRAMEBUFFER,null),this.hitDetectionFramebuffer_=o,this.hitDetectionTexture_=t,this.hitDetectionRenderbuffer_=r},ol.webgl.Context.prototype.useProgram=function(e){return e!=this.currentProgram_&&(this.getGL().useProgram(e),this.currentProgram_=e,!0)},ol.webgl.Context.createTexture_=function(e,o,t){var r=e.createTexture();return e.bindTexture(e.TEXTURE_2D,r),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),void 0!==o&&e.texParameteri(ol.webgl.TEXTURE_2D,ol.webgl.TEXTURE_WRAP_S,o),void 0!==t&&e.texParameteri(ol.webgl.TEXTURE_2D,ol.webgl.TEXTURE_WRAP_T,t),r},ol.webgl.Context.createEmptyTexture=function(e,o,t,r,i){var n=ol.webgl.Context.createTexture_(e,r,i);return e.texImage2D(e.TEXTURE_2D,0,e.RGBA,o,t,0,e.RGBA,e.UNSIGNED_BYTE,null),n},ol.webgl.Context.createTexture=function(e,o,t,r){var i=ol.webgl.Context.createTexture_(e,t,r);return e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,o),i},goog.provide("ol.render.webgl.ImageReplay"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.obj"),goog.require("ol.render.webgl.imagereplay.defaultshader"),goog.require("ol.render.webgl.Replay"),goog.require("ol.render.webgl"),goog.require("ol.webgl"),goog.require("ol.webgl.Buffer"),goog.require("ol.webgl.Context"),ol.render.webgl.ImageReplay=function(e,o){ol.render.webgl.Replay.call(this,e,o),this.anchorX_=void 0,this.anchorY_=void 0,this.groupIndices_=[],this.hitDetectionGroupIndices_=[],this.height_=void 0,this.images_=[],this.hitDetectionImages_=[],this.imageHeight_=void 0,this.imageWidth_=void 0,this.defaultLocations_=null,this.opacity_=void 0,this.originX_=void 0,this.originY_=void 0,this.rotateWithView_=void 0,this.rotation_=void 0,this.scale_=void 0,this.textures_=[],this.hitDetectionTextures_=[],this.width_=void 0},ol.inherits(ol.render.webgl.ImageReplay,ol.render.webgl.Replay),ol.render.webgl.ImageReplay.prototype.getDeleteResourcesFunction=function(e){ol.DEBUG&&console.assert(this.verticesBuffer,"verticesBuffer must not be null"),ol.DEBUG&&console.assert(this.indicesBuffer,"indicesBuffer must not be null");var o=this.verticesBuffer,t=this.indicesBuffer,r=this.textures_,i=this.hitDetectionTextures_,n=e.getGL();return function(){if(!n.isContextLost()){var l,a;for(l=0,a=r.length;l<a;++l)n.deleteTexture(r[l]);for(l=0,a=i.length;l<a;++l)n.deleteTexture(i[l])}e.deleteBuffer(o),e.deleteBuffer(t)}},ol.render.webgl.ImageReplay.prototype.drawCoordinates_=function(e,o,t,r){ol.DEBUG&&console.assert(void 0!==this.anchorX_,"anchorX is defined"),ol.DEBUG&&console.assert(void 0!==this.anchorY_,"anchorY is defined"),ol.DEBUG&&console.assert(void 0!==this.height_,"height is defined"),ol.DEBUG&&console.assert(void 0!==this.imageHeight_,"imageHeight is defined"),ol.DEBUG&&console.assert(void 0!==this.imageWidth_,"imageWidth is defined"),ol.DEBUG&&console.assert(void 0!==this.opacity_,"opacity is defined"),ol.DEBUG&&console.assert(void 0!==this.originX_,"originX is defined"),ol.DEBUG&&console.assert(void 0!==this.originY_,"originY is defined"),ol.DEBUG&&console.assert(void 0!==this.rotateWithView_,"rotateWithView is defined"),ol.DEBUG&&console.assert(void 0!==this.rotation_,"rotation is defined"),ol.DEBUG&&console.assert(void 0!==this.scale_,"scale is defined"),ol.DEBUG&&console.assert(void 0!==this.width_,"width is defined");var i,n,l,a,s,p,g=this.anchorX_,c=this.anchorY_,u=this.height_,y=this.imageHeight_,d=this.imageWidth_,h=this.opacity_,m=this.originX_,f=this.originY_,_=this.rotateWithView_?1:0,E=-this.rotation_,v=this.scale_,S=this.width_,x=Math.cos(E),P=Math.sin(E),T=this.indices.length,R=this.vertices.length;for(i=o;i<t;i+=r)s=e[i]-this.origin[0],p=e[i+1]-this.origin[1],n=R/8,l=-v*g,a=-v*(u-c),this.vertices[R++]=s,this.vertices[R++]=p,this.vertices[R++]=l*x-a*P,this.vertices[R++]=l*P+a*x,this.vertices[R++]=m/d,this.vertices[R++]=(f+u)/y,this.vertices[R++]=h,this.vertices[R++]=_,l=v*(S-g),a=-v*(u-c),this.vertices[R++]=s,this.vertices[R++]=p,this.vertices[R++]=l*x-a*P,this.vertices[R++]=l*P+a*x,this.vertices[R++]=(m+S)/d,this.vertices[R++]=(f+u)/y,this.vertices[R++]=h,this.vertices[R++]=_,l=v*(S-g),a=v*c,this.vertices[R++]=s,this.vertices[R++]=p,this.vertices[R++]=l*x-a*P,this.vertices[R++]=l*P+a*x,this.vertices[R++]=(m+S)/d,this.vertices[R++]=f/y,this.vertices[R++]=h,this.vertices[R++]=_,l=-v*g,a=v*c,this.vertices[R++]=s,this.vertices[R++]=p,this.vertices[R++]=l*x-a*P,this.vertices[R++]=l*P+a*x,this.vertices[R++]=m/d,this.vertices[R++]=f/y,this.vertices[R++]=h,this.vertices[R++]=_,this.indices[T++]=n,this.indices[T++]=n+1,this.indices[T++]=n+2,this.indices[T++]=n,this.indices[T++]=n+2,this.indices[T++]=n+3;return R},ol.render.webgl.ImageReplay.prototype.drawMultiPoint=function(e,o){this.startIndices.push(this.indices.length),this.startIndicesFeature.push(o);var t=e.getFlatCoordinates(),r=e.getStride();this.drawCoordinates_(t,0,t.length,r)},ol.render.webgl.ImageReplay.prototype.drawPoint=function(e,o){this.startIndices.push(this.indices.length),this.startIndicesFeature.push(o);var t=e.getFlatCoordinates(),r=e.getStride();this.drawCoordinates_(t,0,t.length,r)},ol.render.webgl.ImageReplay.prototype.finish=function(e){var o=e.getGL();this.groupIndices_.push(this.indices.length),ol.DEBUG&&console.assert(this.images_.length===this.groupIndices_.length,"number of images and groupIndices match"),this.hitDetectionGroupIndices_.push(this.indices.length),ol.DEBUG&&console.assert(this.hitDetectionImages_.length===this.hitDetectionGroupIndices_.length,"number of hitDetectionImages and hitDetectionGroupIndices match"),this.verticesBuffer=new ol.webgl.Buffer(this.vertices);var t=this.indices,r=e.hasOESElementIndexUint?32:16;ol.DEBUG&&console.assert(t[t.length-1]<Math.pow(2,r),'Too large element index detected [%s] (OES_element_index_uint "%s")',t[t.length-1],e.hasOESElementIndexUint),this.indicesBuffer=new ol.webgl.Buffer(t);var i={};this.createTextures_(this.textures_,this.images_,i,o),ol.DEBUG&&console.assert(this.textures_.length===this.groupIndices_.length,"number of textures and groupIndices match"),this.createTextures_(this.hitDetectionTextures_,this.hitDetectionImages_,i,o),ol.DEBUG&&console.assert(this.hitDetectionTextures_.length===this.hitDetectionGroupIndices_.length,"number of hitDetectionTextures and hitDetectionGroupIndices match"),this.anchorX_=void 0,this.anchorY_=void 0,this.height_=void 0,this.images_=null,this.hitDetectionImages_=null,this.imageHeight_=void 0,this.imageWidth_=void 0,this.indices=null,this.opacity_=void 0,this.originX_=void 0,this.originY_=void 0,this.rotateWithView_=void 0,this.rotation_=void 0,this.scale_=void 0,this.vertices=null,this.width_=void 0},ol.render.webgl.ImageReplay.prototype.createTextures_=function(e,o,t,r){ol.DEBUG&&console.assert(0===e.length,"upon creation, textures is empty");var i,n,l,a,s=o.length;for(a=0;a<s;++a)n=o[a],l=ol.getUid(n).toString(),l in t?i=t[l]:(i=ol.webgl.Context.createTexture(r,n,ol.webgl.CLAMP_TO_EDGE,ol.webgl.CLAMP_TO_EDGE),t[l]=i),e[a]=i},ol.render.webgl.ImageReplay.prototype.setUpProgram=function(e,o,t,r){var i,n=ol.render.webgl.imagereplay.defaultshader.fragment,l=ol.render.webgl.imagereplay.defaultshader.vertex,a=o.getProgram(n,l);return this.defaultLocations_?i=this.defaultLocations_:(i=new ol.render.webgl.imagereplay.defaultshader.Locations(e,a),this.defaultLocations_=i),o.useProgram(a),e.enableVertexAttribArray(i.a_position),e.vertexAttribPointer(i.a_position,2,ol.webgl.FLOAT,!1,32,0),e.enableVertexAttribArray(i.a_offsets),e.vertexAttribPointer(i.a_offsets,2,ol.webgl.FLOAT,!1,32,8),e.enableVertexAttribArray(i.a_texCoord),e.vertexAttribPointer(i.a_texCoord,2,ol.webgl.FLOAT,!1,32,16),e.enableVertexAttribArray(i.a_opacity),e.vertexAttribPointer(i.a_opacity,1,ol.webgl.FLOAT,!1,32,24),e.enableVertexAttribArray(i.a_rotateWithView),e.vertexAttribPointer(i.a_rotateWithView,1,ol.webgl.FLOAT,!1,32,28),i},ol.render.webgl.ImageReplay.prototype.shutDownProgram=function(e,o){e.disableVertexAttribArray(o.a_position),e.disableVertexAttribArray(o.a_offsets),e.disableVertexAttribArray(o.a_texCoord),e.disableVertexAttribArray(o.a_opacity),e.disableVertexAttribArray(o.a_rotateWithView)},ol.render.webgl.ImageReplay.prototype.drawReplay=function(e,o,t,r){var i=r?this.hitDetectionTextures_:this.textures_,n=r?this.hitDetectionGroupIndices_:this.groupIndices_;if(ol.DEBUG&&console.assert(i.length===n.length,"number of textures and groupIndeces match"),ol.obj.isEmpty(t)){var l,a,s;for(l=0,a=i.length,s=0;l<a;++l){e.bindTexture(ol.webgl.TEXTURE_2D,i[l]);var p=n[l];this.drawElements(e,o,s,p),s=p}}else this.drawReplaySkipping_(e,o,t,i,n)},ol.render.webgl.ImageReplay.prototype.drawReplaySkipping_=function(e,o,t,r,i){var n,l,a=0;for(n=0,l=r.length;n<l;++n){e.bindTexture(ol.webgl.TEXTURE_2D,r[n]);for(var s=n>0?i[n-1]:0,p=i[n],g=s,c=s;a<this.startIndices.length&&this.startIndices[a]<=p;){var u=this.startIndicesFeature[a];void 0!==t[ol.getUid(u).toString()]?(g!==c&&this.drawElements(e,o,g,c),g=a===this.startIndices.length-1?p:this.startIndices[a+1],c=g):c=a===this.startIndices.length-1?p:this.startIndices[a+1],a++}g!==c&&this.drawElements(e,o,g,c)}},ol.render.webgl.ImageReplay.prototype.drawHitDetectionReplayOneByOne=function(e,o,t,r,i){ol.DEBUG&&console.assert(this.hitDetectionTextures_.length===this.hitDetectionGroupIndices_.length,"number of hitDetectionTextures and hitDetectionGroupIndices match");var n,l,a,s,p,g,c=this.startIndices.length-1;for(n=this.hitDetectionTextures_.length-1;n>=0;--n)for(e.bindTexture(ol.webgl.TEXTURE_2D,this.hitDetectionTextures_[n]),l=n>0?this.hitDetectionGroupIndices_[n-1]:0,s=this.hitDetectionGroupIndices_[n];c>=0&&this.startIndices[c]>=l;){if(a=this.startIndices[c],p=this.startIndicesFeature[c],g=ol.getUid(p).toString(),void 0===t[g]&&p.getGeometry()&&(void 0===i||ol.extent.intersects(i,p.getGeometry().getExtent()))){e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT),this.drawElements(e,o,a,s);var u=r(p);if(u)return u}s=a,c--}},ol.render.webgl.ImageReplay.prototype.setImageStyle=function(e){var o=e.getAnchor(),t=e.getImage(1),r=e.getImageSize(),i=e.getHitDetectionImage(1),n=e.getHitDetectionImageSize(),l=e.getOpacity(),a=e.getOrigin(),s=e.getRotateWithView(),p=e.getRotation(),g=e.getSize(),c=e.getScale();ol.DEBUG&&console.assert(o,"imageStyle anchor is not null"),
ol.DEBUG&&console.assert(t,"imageStyle image is not null"),ol.DEBUG&&console.assert(r,"imageStyle imageSize is not null"),ol.DEBUG&&console.assert(i,"imageStyle hitDetectionImage is not null"),ol.DEBUG&&console.assert(n,"imageStyle hitDetectionImageSize is not null"),ol.DEBUG&&console.assert(void 0!==l,"imageStyle opacity is defined"),ol.DEBUG&&console.assert(a,"imageStyle origin is not null"),ol.DEBUG&&console.assert(void 0!==s,"imageStyle rotateWithView is defined"),ol.DEBUG&&console.assert(void 0!==p,"imageStyle rotation is defined"),ol.DEBUG&&console.assert(g,"imageStyle size is not null"),ol.DEBUG&&console.assert(void 0!==c,"imageStyle scale is defined");var u;0===this.images_.length?this.images_.push(t):(u=this.images_[this.images_.length-1],ol.getUid(u)!=ol.getUid(t)&&(this.groupIndices_.push(this.indices.length),ol.DEBUG&&console.assert(this.groupIndices_.length===this.images_.length,"number of groupIndices and images match"),this.images_.push(t))),0===this.hitDetectionImages_.length?this.hitDetectionImages_.push(i):(u=this.hitDetectionImages_[this.hitDetectionImages_.length-1],ol.getUid(u)!=ol.getUid(i)&&(this.hitDetectionGroupIndices_.push(this.indices.length),ol.DEBUG&&console.assert(this.hitDetectionGroupIndices_.length===this.hitDetectionImages_.length,"number of hitDetectionGroupIndices and hitDetectionImages match"),this.hitDetectionImages_.push(i))),this.anchorX_=o[0],this.anchorY_=o[1],this.height_=g[1],this.imageHeight_=r[1],this.imageWidth_=r[0],this.opacity_=l,this.originX_=a[0],this.originY_=a[1],this.rotation_=p,this.rotateWithView_=s,this.scale_=c,this.width_=g[0]},goog.provide("ol.geom.flat.topology"),goog.require("ol.geom.flat.area"),ol.geom.flat.topology.lineStringIsClosed=function(e,o,t,r){var i=t-r;return e[o]===e[i]&&e[o+1]===e[i+1]&&(t-o)/r>3&&!!ol.geom.flat.area.linearRing(e,o,t,r)},goog.provide("ol.render.webgl.linestringreplay.defaultshader"),goog.require("ol"),goog.require("ol.webgl.Fragment"),goog.require("ol.webgl.Vertex"),ol.render.webgl.linestringreplay.defaultshader.Fragment=function(){ol.webgl.Fragment.call(this,ol.render.webgl.linestringreplay.defaultshader.Fragment.SOURCE)},ol.inherits(ol.render.webgl.linestringreplay.defaultshader.Fragment,ol.webgl.Fragment),ol.render.webgl.linestringreplay.defaultshader.Fragment.DEBUG_SOURCE="precision mediump float;\nvarying float v_round;\nvarying vec2 v_roundVertex;\nvarying float v_halfWidth;\n\n\n\nuniform float u_opacity;\nuniform vec4 u_color;\nuniform vec2 u_size;\nuniform float u_pixelRatio;\n\nvoid main(void) {\n  if (v_round > 0.0) {\n    vec2 windowCoords = vec2((v_roundVertex.x + 1.0) / 2.0 * u_size.x * u_pixelRatio,\n        (v_roundVertex.y + 1.0) / 2.0 * u_size.y * u_pixelRatio);\n    if (length(windowCoords - gl_FragCoord.xy) > v_halfWidth * u_pixelRatio) {\n      discard;\n    }\n  }\n  gl_FragColor = u_color;\n  float alpha = u_color.a * u_opacity;\n  if (alpha == 0.0) {\n    discard;\n  }\n  gl_FragColor.a = alpha;\n}\n",ol.render.webgl.linestringreplay.defaultshader.Fragment.OPTIMIZED_SOURCE="precision mediump float;varying float a;varying vec2 b;varying float c;uniform float m;uniform vec4 n;uniform vec2 o;uniform float p;void main(void){if(a>0.0){vec2 windowCoords=vec2((b.x+1.0)/2.0*o.x*p,(b.y+1.0)/2.0*o.y*p);if(length(windowCoords-gl_FragCoord.xy)>c*p){discard;}} gl_FragColor=n;float alpha=n.a*m;if(alpha==0.0){discard;}gl_FragColor.a=alpha;}",ol.render.webgl.linestringreplay.defaultshader.Fragment.SOURCE=ol.DEBUG?ol.render.webgl.linestringreplay.defaultshader.Fragment.DEBUG_SOURCE:ol.render.webgl.linestringreplay.defaultshader.Fragment.OPTIMIZED_SOURCE,ol.render.webgl.linestringreplay.defaultshader.fragment=new ol.render.webgl.linestringreplay.defaultshader.Fragment,ol.render.webgl.linestringreplay.defaultshader.Vertex=function(){ol.webgl.Vertex.call(this,ol.render.webgl.linestringreplay.defaultshader.Vertex.SOURCE)},ol.inherits(ol.render.webgl.linestringreplay.defaultshader.Vertex,ol.webgl.Vertex),ol.render.webgl.linestringreplay.defaultshader.Vertex.DEBUG_SOURCE="varying float v_round;\nvarying vec2 v_roundVertex;\nvarying float v_halfWidth;\n\n\nattribute vec2 a_lastPos;\nattribute vec2 a_position;\nattribute vec2 a_nextPos;\nattribute float a_direction;\n\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_offsetScaleMatrix;\nuniform mat4 u_offsetRotateMatrix;\nuniform float u_lineWidth;\nuniform float u_miterLimit;\n\nbool nearlyEquals(in float value, in float ref) {\n  float epsilon = 0.000000000001;\n  return value >= ref - epsilon && value <= ref + epsilon;\n}\n\nvoid alongNormal(out vec2 offset, in vec2 nextP, in float turnDir, in float direction) {\n  vec2 dirVect = nextP - a_position;\n  vec2 normal = normalize(vec2(-turnDir * dirVect.y, turnDir * dirVect.x));\n  offset = u_lineWidth / 2.0 * normal * direction;\n}\n\nvoid miterUp(out vec2 offset, out float round, in bool isRound, in float direction) {\n  float halfWidth = u_lineWidth / 2.0;\n  vec2 tangent = normalize(normalize(a_nextPos - a_position) + normalize(a_position - a_lastPos));\n  vec2 normal = vec2(-tangent.y, tangent.x);\n  vec2 dirVect = a_nextPos - a_position;\n  vec2 tmpNormal = normalize(vec2(-dirVect.y, dirVect.x));\n  float miterLength = abs(halfWidth / dot(normal, tmpNormal));\n  offset = normal * direction * miterLength;\n  round = 0.0;\n  if (isRound) {\n    round = 1.0;\n  } else if (miterLength > u_miterLimit + u_lineWidth) {\n    offset = halfWidth * tmpNormal * direction;\n  }\n}\n\nbool miterDown(out vec2 offset, in vec4 projPos, in mat4 offsetMatrix, in float direction) {\n  bool degenerate = false;\n  vec2 tangent = normalize(normalize(a_nextPos - a_position) + normalize(a_position - a_lastPos));\n  vec2 normal = vec2(-tangent.y, tangent.x);\n  vec2 dirVect = a_lastPos - a_position;\n  vec2 tmpNormal = normalize(vec2(-dirVect.y, dirVect.x));\n  vec2 longOffset, shortOffset, longVertex;\n  vec4 shortProjVertex;\n  float halfWidth = u_lineWidth / 2.0;\n  if (length(a_nextPos - a_position) > length(a_lastPos - a_position)) {\n    longOffset = tmpNormal * direction * halfWidth;\n    shortOffset = normalize(vec2(dirVect.y, -dirVect.x)) * direction * halfWidth;\n    longVertex = a_nextPos;\n    shortProjVertex = u_projectionMatrix * vec4(a_lastPos, 0.0, 1.0);\n  } else {\n    shortOffset = tmpNormal * direction * halfWidth;\n    longOffset = normalize(vec2(dirVect.y, -dirVect.x)) * direction * halfWidth;\n    longVertex = a_lastPos;\n    shortProjVertex = u_projectionMatrix * vec4(a_nextPos, 0.0, 1.0);\n  }\n  //Intersection algorithm based on theory by Paul Bourke (http://paulbourke.net/geometry/pointlineplane/).\n  vec4 p1 = u_projectionMatrix * vec4(longVertex, 0.0, 1.0) + offsetMatrix * vec4(longOffset, 0.0, 0.0);\n  vec4 p2 = projPos + offsetMatrix * vec4(longOffset, 0.0, 0.0);\n  vec4 p3 = shortProjVertex + offsetMatrix * vec4(-shortOffset, 0.0, 0.0);\n  vec4 p4 = shortProjVertex + offsetMatrix * vec4(shortOffset, 0.0, 0.0);\n  float denom = (p4.y - p3.y) * (p2.x - p1.x) - (p4.x - p3.x) * (p2.y - p1.y);\n  float firstU = ((p4.x - p3.x) * (p1.y - p3.y) - (p4.y - p3.y) * (p1.x - p3.x)) / denom;\n  float secondU = ((p2.x - p1.x) * (p1.y - p3.y) - (p2.y - p1.y) * (p1.x - p3.x)) / denom;\n  float epsilon = 0.000000000001;\n  if (firstU > epsilon && firstU < 1.0 - epsilon && secondU > epsilon && secondU < 1.0 - epsilon) {\n    shortProjVertex.x = p1.x + firstU * (p2.x - p1.x);\n    shortProjVertex.y = p1.y + firstU * (p2.y - p1.y);\n    offset = shortProjVertex.xy;\n    degenerate = true;\n  } else {\n    float miterLength = abs(halfWidth / dot(normal, tmpNormal));\n    offset = normal * direction * miterLength;\n  }\n  return degenerate;\n}\n\nvoid squareCap(out vec2 offset, out float round, in bool isRound, in vec2 nextP,\n    in float turnDir, in float direction) {\n  round = 0.0;\n  vec2 dirVect = a_position - nextP;\n  vec2 firstNormal = normalize(dirVect);\n  vec2 secondNormal = vec2(turnDir * firstNormal.y * direction, -turnDir * firstNormal.x * direction);\n  vec2 hypotenuse = normalize(firstNormal - secondNormal);\n  vec2 normal = vec2(turnDir * hypotenuse.y * direction, -turnDir * hypotenuse.x * direction);\n  float length = sqrt(v_halfWidth * v_halfWidth * 2.0);\n  offset = normal * length;\n  if (isRound) {\n    round = 1.0;\n  }\n}\n\nvoid main(void) {\n  bool degenerate = false;\n  float direction = float(sign(a_direction));\n  mat4 offsetMatrix = u_offsetScaleMatrix * u_offsetRotateMatrix;\n  vec2 offset;\n  vec4 projPos = u_projectionMatrix * vec4(a_position, 0.0, 1.0);\n  bool round = nearlyEquals(mod(a_direction, 2.0), 0.0);\n\n  v_round = 0.0;\n  v_halfWidth = u_lineWidth / 2.0;\n  v_roundVertex = projPos.xy;\n\n  if (nearlyEquals(mod(a_direction, 3.0), 0.0) || nearlyEquals(mod(a_direction, 17.0), 0.0)) {\n    alongNormal(offset, a_nextPos, 1.0, direction);\n  } else if (nearlyEquals(mod(a_direction, 5.0), 0.0) || nearlyEquals(mod(a_direction, 13.0), 0.0)) {\n    alongNormal(offset, a_lastPos, -1.0, direction);\n  } else if (nearlyEquals(mod(a_direction, 23.0), 0.0)) {\n    miterUp(offset, v_round, round, direction);\n  } else if (nearlyEquals(mod(a_direction, 19.0), 0.0)) {\n    degenerate = miterDown(offset, projPos, offsetMatrix, direction);\n  } else if (nearlyEquals(mod(a_direction, 7.0), 0.0)) {\n    squareCap(offset, v_round, round, a_nextPos, 1.0, direction);\n  } else if (nearlyEquals(mod(a_direction, 11.0), 0.0)) {\n    squareCap(offset, v_round, round, a_lastPos, -1.0, direction);\n  }\n  if (!degenerate) {\n    vec4 offsets = offsetMatrix * vec4(offset, 0.0, 0.0);\n    gl_Position = projPos + offsets;\n  } else {\n    gl_Position = vec4(offset, 0.0, 1.0);\n  }\n}\n\n\n",ol.render.webgl.linestringreplay.defaultshader.Vertex.OPTIMIZED_SOURCE="varying float a;varying vec2 b;varying float c;attribute vec2 d;attribute vec2 e;attribute vec2 f;attribute float g;uniform mat4 h;uniform mat4 i;uniform mat4 j;uniform float k;uniform float l;bool nearlyEquals(in float value,in float ref){float epsilon=0.000000000001;return value>=ref-epsilon&&value<=ref+epsilon;}void alongNormal(out vec2 offset,in vec2 nextP,in float turnDir,in float direction){vec2 dirVect=nextP-e;vec2 normal=normalize(vec2(-turnDir*dirVect.y,turnDir*dirVect.x));offset=k/2.0*normal*direction;}void miterUp(out vec2 offset,out float round,in bool isRound,in float direction){float halfWidth=k/2.0;vec2 tangent=normalize(normalize(f-e)+normalize(e-d));vec2 normal=vec2(-tangent.y,tangent.x);vec2 dirVect=f-e;vec2 tmpNormal=normalize(vec2(-dirVect.y,dirVect.x));float miterLength=abs(halfWidth/dot(normal,tmpNormal));offset=normal*direction*miterLength;round=0.0;if(isRound){round=1.0;}else if(miterLength>l+k){offset=halfWidth*tmpNormal*direction;}} bool miterDown(out vec2 offset,in vec4 projPos,in mat4 offsetMatrix,in float direction){bool degenerate=false;vec2 tangent=normalize(normalize(f-e)+normalize(e-d));vec2 normal=vec2(-tangent.y,tangent.x);vec2 dirVect=d-e;vec2 tmpNormal=normalize(vec2(-dirVect.y,dirVect.x));vec2 longOffset,shortOffset,longVertex;vec4 shortProjVertex;float halfWidth=k/2.0;if(length(f-e)>length(d-e)){longOffset=tmpNormal*direction*halfWidth;shortOffset=normalize(vec2(dirVect.y,-dirVect.x))*direction*halfWidth;longVertex=f;shortProjVertex=h*vec4(d,0.0,1.0);}else{shortOffset=tmpNormal*direction*halfWidth;longOffset=normalize(vec2(dirVect.y,-dirVect.x))*direction*halfWidth;longVertex=d;shortProjVertex=h*vec4(f,0.0,1.0);}vec4 p1=h*vec4(longVertex,0.0,1.0)+offsetMatrix*vec4(longOffset,0.0,0.0);vec4 p2=projPos+offsetMatrix*vec4(longOffset,0.0,0.0);vec4 p3=shortProjVertex+offsetMatrix*vec4(-shortOffset,0.0,0.0);vec4 p4=shortProjVertex+offsetMatrix*vec4(shortOffset,0.0,0.0);float denom=(p4.y-p3.y)*(p2.x-p1.x)-(p4.x-p3.x)*(p2.y-p1.y);float firstU=((p4.x-p3.x)*(p1.y-p3.y)-(p4.y-p3.y)*(p1.x-p3.x))/denom;float secondU=((p2.x-p1.x)*(p1.y-p3.y)-(p2.y-p1.y)*(p1.x-p3.x))/denom;float epsilon=0.000000000001;if(firstU>epsilon&&firstU<1.0-epsilon&&secondU>epsilon&&secondU<1.0-epsilon){shortProjVertex.x=p1.x+firstU*(p2.x-p1.x);shortProjVertex.y=p1.y+firstU*(p2.y-p1.y);offset=shortProjVertex.xy;degenerate=true;}else{float miterLength=abs(halfWidth/dot(normal,tmpNormal));offset=normal*direction*miterLength;}return degenerate;}void squareCap(out vec2 offset,out float round,in bool isRound,in vec2 nextP,in float turnDir,in float direction){round=0.0;vec2 dirVect=e-nextP;vec2 firstNormal=normalize(dirVect);vec2 secondNormal=vec2(turnDir*firstNormal.y*direction,-turnDir*firstNormal.x*direction);vec2 hypotenuse=normalize(firstNormal-secondNormal);vec2 normal=vec2(turnDir*hypotenuse.y*direction,-turnDir*hypotenuse.x*direction);float length=sqrt(c*c*2.0);offset=normal*length;if(isRound){round=1.0;}} void main(void){bool degenerate=false;float direction=float(sign(g));mat4 offsetMatrix=i*j;vec2 offset;vec4 projPos=h*vec4(e,0.0,1.0);bool round=nearlyEquals(mod(g,2.0),0.0);a=0.0;c=k/2.0;b=projPos.xy;if(nearlyEquals(mod(g,3.0),0.0)||nearlyEquals(mod(g,17.0),0.0)){alongNormal(offset,f,1.0,direction);}else if(nearlyEquals(mod(g,5.0),0.0)||nearlyEquals(mod(g,13.0),0.0)){alongNormal(offset,d,-1.0,direction);}else if(nearlyEquals(mod(g,23.0),0.0)){miterUp(offset,a,round,direction);}else if(nearlyEquals(mod(g,19.0),0.0)){degenerate=miterDown(offset,projPos,offsetMatrix,direction);}else if(nearlyEquals(mod(g,7.0),0.0)){squareCap(offset,a,round,f,1.0,direction);}else if(nearlyEquals(mod(g,11.0),0.0)){squareCap(offset,a,round,d,-1.0,direction);}if(!degenerate){vec4 offsets=offsetMatrix*vec4(offset,0.0,0.0);gl_Position=projPos+offsets;}else{gl_Position=vec4(offset,0.0,1.0);}}",ol.render.webgl.linestringreplay.defaultshader.Vertex.SOURCE=ol.DEBUG?ol.render.webgl.linestringreplay.defaultshader.Vertex.DEBUG_SOURCE:ol.render.webgl.linestringreplay.defaultshader.Vertex.OPTIMIZED_SOURCE,ol.render.webgl.linestringreplay.defaultshader.vertex=new ol.render.webgl.linestringreplay.defaultshader.Vertex,ol.render.webgl.linestringreplay.defaultshader.Locations=function(e,o){this.u_color=e.getUniformLocation(o,ol.DEBUG?"u_color":"n"),this.u_lineWidth=e.getUniformLocation(o,ol.DEBUG?"u_lineWidth":"k"),this.u_miterLimit=e.getUniformLocation(o,ol.DEBUG?"u_miterLimit":"l"),this.u_offsetRotateMatrix=e.getUniformLocation(o,ol.DEBUG?"u_offsetRotateMatrix":"j"),this.u_offsetScaleMatrix=e.getUniformLocation(o,ol.DEBUG?"u_offsetScaleMatrix":"i"),this.u_opacity=e.getUniformLocation(o,ol.DEBUG?"u_opacity":"m"),this.u_pixelRatio=e.getUniformLocation(o,ol.DEBUG?"u_pixelRatio":"p"),this.u_projectionMatrix=e.getUniformLocation(o,ol.DEBUG?"u_projectionMatrix":"h"),this.u_size=e.getUniformLocation(o,ol.DEBUG?"u_size":"o"),this.a_direction=e.getAttribLocation(o,ol.DEBUG?"a_direction":"g"),this.a_lastPos=e.getAttribLocation(o,ol.DEBUG?"a_lastPos":"d"),this.a_nextPos=e.getAttribLocation(o,ol.DEBUG?"a_nextPos":"f"),this.a_position=e.getAttribLocation(o,ol.DEBUG?"a_position":"e")},goog.provide("ol.render.webgl.LineStringReplay"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.color"),goog.require("ol.extent"),goog.require("ol.geom.flat.orient"),goog.require("ol.geom.flat.transform"),goog.require("ol.geom.flat.topology"),goog.require("ol.obj"),goog.require("ol.render.webgl"),goog.require("ol.render.webgl.Replay"),goog.require("ol.render.webgl.linestringreplay.defaultshader"),goog.require("ol.webgl"),goog.require("ol.webgl.Buffer"),ol.render.webgl.LineStringReplay=function(e,o){ol.render.webgl.Replay.call(this,e,o),this.defaultLocations_=null,this.styles_=[],this.styleIndices_=[],this.state_={strokeColor:null,lineCap:void 0,lineDash:null,lineJoin:void 0,lineWidth:void 0,miterLimit:void 0,changed:!1}},ol.inherits(ol.render.webgl.LineStringReplay,ol.render.webgl.Replay),ol.render.webgl.LineStringReplay.prototype.drawCoordinates_=function(e,o,t,r){var i,n,l,a,s,p,g,c,u=this.vertices.length,y=this.indices.length,d="bevel"===this.state_.lineJoin?0:"miter"===this.state_.lineJoin?1:2,h="butt"===this.state_.lineCap?0:"square"===this.state_.lineCap?1:2,m=ol.geom.flat.topology.lineStringIsClosed(e,o,t,r),f=y,_=1;for(i=o,n=t;i<n;i+=r){if(s=u/7,p=g,g=c||[e[i],e[i+1]],i===o){if(c=[e[i+r],e[i+r+1]],t-o==2*r&&ol.array.equals(g,c))break;if(!m){h&&(u=this.addVertices_([0,0],g,c,_*ol.render.webgl.lineStringInstruction.BEGIN_LINE_CAP*h,u),u=this.addVertices_([0,0],g,c,-_*ol.render.webgl.lineStringInstruction.BEGIN_LINE_CAP*h,u),this.indices[y++]=s+2,this.indices[y++]=s,this.indices[y++]=s+1,this.indices[y++]=s+1,this.indices[y++]=s+3,this.indices[y++]=s+2),u=this.addVertices_([0,0],g,c,_*ol.render.webgl.lineStringInstruction.BEGIN_LINE*(h||1),u),u=this.addVertices_([0,0],g,c,-_*ol.render.webgl.lineStringInstruction.BEGIN_LINE*(h||1),u),f=u/7-1;continue}p=[e[t-2*r],e[t-2*r+1]],l=c}else{if(i===t-r){if(m){c=l;break}ol.DEBUG&&console.assert(p,"p0 should be defined"),p=p||[0,0],u=this.addVertices_(p,g,[0,0],_*ol.render.webgl.lineStringInstruction.END_LINE*(h||1),u),u=this.addVertices_(p,g,[0,0],-_*ol.render.webgl.lineStringInstruction.END_LINE*(h||1),u),this.indices[y++]=s,this.indices[y++]=f-1,this.indices[y++]=f,this.indices[y++]=f,this.indices[y++]=s+1,this.indices[y++]=s,h&&(u=this.addVertices_(p,g,[0,0],_*ol.render.webgl.lineStringInstruction.END_LINE_CAP*h,u),u=this.addVertices_(p,g,[0,0],-_*ol.render.webgl.lineStringInstruction.END_LINE_CAP*h,u),this.indices[y++]=s+2,this.indices[y++]=s,this.indices[y++]=s+1,this.indices[y++]=s+1,this.indices[y++]=s+3,this.indices[y++]=s+2);break}c=[e[i+r],e[i+r+1]]}a=ol.render.webgl.triangleIsCounterClockwise(p[0],p[1],g[0],g[1],c[0],c[1])?-1:1,u=this.addVertices_(p,g,c,a*ol.render.webgl.lineStringInstruction.BEVEL_FIRST*(d||1),u),u=this.addVertices_(p,g,c,a*ol.render.webgl.lineStringInstruction.BEVEL_SECOND*(d||1),u),u=this.addVertices_(p,g,c,-a*ol.render.webgl.lineStringInstruction.MITER_BOTTOM*(d||1),u),i>o&&(this.indices[y++]=s,this.indices[y++]=f-1,this.indices[y++]=f,this.indices[y++]=s+2,this.indices[y++]=s,this.indices[y++]=_*a>0?f:f-1),this.indices[y++]=s,this.indices[y++]=s+2,this.indices[y++]=s+1,f=s+2,_=a,d&&(u=this.addVertices_(p,g,c,a*ol.render.webgl.lineStringInstruction.MITER_TOP*d,u),this.indices[y++]=s+1,this.indices[y++]=s+3,this.indices[y++]=s)}m&&(ol.DEBUG&&console.assert(s,"n should be defined"),s=s||u/7,a=ol.geom.flat.orient.linearRingIsClockwise([p[0],p[1],g[0],g[1],c[0],c[1]],0,6,2)?1:-1,u=this.addVertices_(p,g,c,a*ol.render.webgl.lineStringInstruction.BEVEL_FIRST*(d||1),u),u=this.addVertices_(p,g,c,-a*ol.render.webgl.lineStringInstruction.MITER_BOTTOM*(d||1),u),this.indices[y++]=s,this.indices[y++]=f-1,this.indices[y++]=f,this.indices[y++]=s+1,this.indices[y++]=s,this.indices[y++]=_*a>0?f:f-1)},ol.render.webgl.LineStringReplay.prototype.addVertices_=function(e,o,t,r,i){return this.vertices[i++]=e[0],this.vertices[i++]=e[1],this.vertices[i++]=o[0],this.vertices[i++]=o[1],this.vertices[i++]=t[0],this.vertices[i++]=t[1],this.vertices[i++]=r,i},ol.render.webgl.LineStringReplay.prototype.isValid_=function(e,o,t,r){var i=t-o;if(i<2*r)return!1;if(i===2*r){var n=[e[o],e[o+1]],l=[e[o+r],e[o+r+1]];return!ol.array.equals(n,l)}return!0},ol.render.webgl.LineStringReplay.prototype.drawLineString=function(e,o){var t=e.getFlatCoordinates(),r=e.getStride();this.isValid_(t,0,t.length,r)&&(t=ol.geom.flat.transform.translate(t,0,t.length,r,-this.origin[0],-this.origin[1]),this.state_.changed&&(this.styleIndices_.push(this.indices.length),this.state_.changed=!1),this.startIndices.push(this.indices.length),this.startIndicesFeature.push(o),this.drawCoordinates_(t,0,t.length,r))},ol.render.webgl.LineStringReplay.prototype.drawMultiLineString=function(e,o){var t,r,i=this.indices.length,n=e.getLineStrings();for(t=0,r=n.length;t<r;++t){var l=n[t].getFlatCoordinates(),a=n[t].getStride();this.isValid_(l,0,l.length,a)&&(l=ol.geom.flat.transform.translate(l,0,l.length,a,-this.origin[0],-this.origin[1]),this.drawCoordinates_(l,0,l.length,a))}this.indices.length>i&&(this.startIndices.push(i),this.startIndicesFeature.push(o),this.state_.changed&&(this.styleIndices_.push(i),this.state_.changed=!1))},ol.render.webgl.LineStringReplay.prototype.drawPolygonCoordinates=function(e,o,t){if(ol.geom.flat.topology.lineStringIsClosed(e,0,e.length,t)||(e.push(e[0]),e.push(e[1])),this.drawCoordinates_(e,0,e.length,t),o.length){var r,i;for(r=0,i=o.length;r<i;++r)ol.geom.flat.topology.lineStringIsClosed(o[r],0,o[r].length,t)||(o[r].push(o[r][0]),o[r].push(o[r][1])),this.drawCoordinates_(o[r],0,o[r].length,t)}},ol.render.webgl.LineStringReplay.prototype.setPolygonStyle=function(e,o){var t=void 0===o?this.indices.length:o;this.startIndices.push(t),this.startIndicesFeature.push(e),this.state_.changed&&(this.styleIndices_.push(t),this.state_.changed=!1)},ol.render.webgl.LineStringReplay.prototype.getCurrentIndex=function(){return this.indices.length},ol.render.webgl.LineStringReplay.prototype.finish=function(e){this.verticesBuffer=new ol.webgl.Buffer(this.vertices),this.indicesBuffer=new ol.webgl.Buffer(this.indices),this.startIndices.push(this.indices.length),0===this.styleIndices_.length&&this.styles_.length>0&&(this.styles_=[]),this.vertices=null,this.indices=null},ol.render.webgl.LineStringReplay.prototype.getDeleteResourcesFunction=function(e){ol.DEBUG&&console.assert(this.verticesBuffer,"verticesBuffer must not be null");var o=this.verticesBuffer,t=this.indicesBuffer;return function(){e.deleteBuffer(o),e.deleteBuffer(t)}},ol.render.webgl.LineStringReplay.prototype.setUpProgram=function(e,o,t,r){var i,n;i=ol.render.webgl.linestringreplay.defaultshader.fragment,n=ol.render.webgl.linestringreplay.defaultshader.vertex;var l,a=o.getProgram(i,n);return this.defaultLocations_?l=this.defaultLocations_:(l=new ol.render.webgl.linestringreplay.defaultshader.Locations(e,a),this.defaultLocations_=l),o.useProgram(a),e.enableVertexAttribArray(l.a_lastPos),e.vertexAttribPointer(l.a_lastPos,2,ol.webgl.FLOAT,!1,28,0),e.enableVertexAttribArray(l.a_position),e.vertexAttribPointer(l.a_position,2,ol.webgl.FLOAT,!1,28,8),e.enableVertexAttribArray(l.a_nextPos),e.vertexAttribPointer(l.a_nextPos,2,ol.webgl.FLOAT,!1,28,16),e.enableVertexAttribArray(l.a_direction),e.vertexAttribPointer(l.a_direction,1,ol.webgl.FLOAT,!1,28,24),e.uniform2fv(l.u_size,t),e.uniform1f(l.u_pixelRatio,r),l},ol.render.webgl.LineStringReplay.prototype.shutDownProgram=function(e,o){e.disableVertexAttribArray(o.a_lastPos),e.disableVertexAttribArray(o.a_position),e.disableVertexAttribArray(o.a_nextPos),e.disableVertexAttribArray(o.a_direction)},ol.render.webgl.LineStringReplay.prototype.drawReplay=function(e,o,t,r){var i=e.getParameter(e.DEPTH_FUNC),n=e.getParameter(e.DEPTH_WRITEMASK);if(r||(e.enable(e.DEPTH_TEST),e.depthMask(!0),e.depthFunc(e.NOTEQUAL)),ol.obj.isEmpty(t)){ol.DEBUG&&console.assert(this.styles_.length===this.styleIndices_.length,"number of styles and styleIndices match");var l,a,s,p;for(s=this.startIndices[this.startIndices.length-1],l=this.styleIndices_.length-1;l>=0;--l)a=this.styleIndices_[l],p=this.styles_[l],this.setStrokeStyle_(e,p[0],p[1],p[2]),this.drawElements(e,o,a,s),e.clear(e.DEPTH_BUFFER_BIT),s=a}else this.drawReplaySkipping_(e,o,t);r||(e.disable(e.DEPTH_TEST),e.clear(e.DEPTH_BUFFER_BIT),e.depthMask(n),e.depthFunc(i))},ol.render.webgl.LineStringReplay.prototype.drawReplaySkipping_=function(e,o,t){ol.DEBUG&&console.assert(this.startIndices.length-1===this.startIndicesFeature.length,"number of startIndices and startIndicesFeature match");var r,i,n,l,a,s,p,g,c;for(g=this.startIndices.length-2,n=i=this.startIndices[g+1],r=this.styleIndices_.length-1;r>=0;--r){for(l=this.styles_[r],this.setStrokeStyle_(e,l[0],l[1],l[2]),a=this.styleIndices_[r];g>=0&&this.startIndices[g]>=a;)c=this.startIndices[g],s=this.startIndicesFeature[g],p=ol.getUid(s).toString(),t[p]&&(i!==n&&(this.drawElements(e,o,i,n),e.clear(e.DEPTH_BUFFER_BIT)),n=c),g--,i=c;i!==n&&(this.drawElements(e,o,i,n),e.clear(e.DEPTH_BUFFER_BIT)),i=n=a}},ol.render.webgl.LineStringReplay.prototype.drawHitDetectionReplayOneByOne=function(e,o,t,r,i){ol.DEBUG&&console.assert(this.styles_.length===this.styleIndices_.length,"number of styles and styleIndices match"),ol.DEBUG&&console.assert(this.startIndices.length-1===this.startIndicesFeature.length,"number of startIndices and startIndicesFeature match");var n,l,a,s,p,g,c,u;for(u=this.startIndices.length-2,a=this.startIndices[u+1],n=this.styleIndices_.length-1;n>=0;--n)for(s=this.styles_[n],this.setStrokeStyle_(e,s[0],s[1],s[2]),p=this.styleIndices_[n];u>=0&&this.startIndices[u]>=p;){if(l=this.startIndices[u],g=this.startIndicesFeature[u],c=ol.getUid(g).toString(),void 0===t[c]&&g.getGeometry()&&(void 0===i||ol.extent.intersects(i,g.getGeometry().getExtent()))){e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT),this.drawElements(e,o,l,a);var y=r(g);if(y)return y}u--,a=l}},ol.render.webgl.LineStringReplay.prototype.setStrokeStyle_=function(e,o,t,r){e.uniform4fv(this.defaultLocations_.u_color,o),e.uniform1f(this.defaultLocations_.u_lineWidth,t),e.uniform1f(this.defaultLocations_.u_miterLimit,r)},ol.render.webgl.LineStringReplay.prototype.setFillStrokeStyle=function(e,o){ol.DEBUG&&console.assert(this.state_,"this.state_ should not be null");var t=o.getLineCap();this.state_.lineCap=void 0!==t?t:ol.render.webgl.defaultLineCap;var r=o.getLineDash();this.state_.lineDash=r||ol.render.webgl.defaultLineDash;var i=o.getLineJoin();this.state_.lineJoin=void 0!==i?i:ol.render.webgl.defaultLineJoin;var n=o.getColor();n=n instanceof CanvasGradient||n instanceof CanvasPattern?ol.render.webgl.defaultStrokeStyle:ol.color.asArray(n).map(function(e,o){return 3!=o?e/255:e})||ol.render.webgl.defaultStrokeStyle;var l=o.getWidth();l=void 0!==l?l:ol.render.webgl.defaultLineWidth;var a=o.getMiterLimit();a=void 0!==a?a:ol.render.webgl.defaultMiterLimit,this.state_.strokeColor&&ol.array.equals(this.state_.strokeColor,n)&&this.state_.lineWidth===l&&this.state_.miterLimit===a||(this.state_.changed=!0,this.state_.strokeColor=n,this.state_.lineWidth=l,this.state_.miterLimit=a,this.styles_.push([n,l,a]))},goog.provide("ol.render.webgl.polygonreplay.defaultshader"),goog.require("ol"),goog.require("ol.webgl.Fragment"),goog.require("ol.webgl.Vertex"),ol.render.webgl.polygonreplay.defaultshader.Fragment=function(){ol.webgl.Fragment.call(this,ol.render.webgl.polygonreplay.defaultshader.Fragment.SOURCE)},ol.inherits(ol.render.webgl.polygonreplay.defaultshader.Fragment,ol.webgl.Fragment),ol.render.webgl.polygonreplay.defaultshader.Fragment.DEBUG_SOURCE="precision mediump float;\n\n\n\nuniform vec4 u_color;\nuniform float u_opacity;\n\nvoid main(void) {\n  gl_FragColor = u_color;\n  float alpha = u_color.a * u_opacity;\n  if (alpha == 0.0) {\n    discard;\n  }\n  gl_FragColor.a = alpha;\n}\n",ol.render.webgl.polygonreplay.defaultshader.Fragment.OPTIMIZED_SOURCE="precision mediump float;uniform vec4 e;uniform float f;void main(void){gl_FragColor=e;float alpha=e.a*f;if(alpha==0.0){discard;}gl_FragColor.a=alpha;}",ol.render.webgl.polygonreplay.defaultshader.Fragment.SOURCE=ol.DEBUG?ol.render.webgl.polygonreplay.defaultshader.Fragment.DEBUG_SOURCE:ol.render.webgl.polygonreplay.defaultshader.Fragment.OPTIMIZED_SOURCE,ol.render.webgl.polygonreplay.defaultshader.fragment=new ol.render.webgl.polygonreplay.defaultshader.Fragment,ol.render.webgl.polygonreplay.defaultshader.Vertex=function(){ol.webgl.Vertex.call(this,ol.render.webgl.polygonreplay.defaultshader.Vertex.SOURCE)},ol.inherits(ol.render.webgl.polygonreplay.defaultshader.Vertex,ol.webgl.Vertex),ol.render.webgl.polygonreplay.defaultshader.Vertex.DEBUG_SOURCE="\n\nattribute vec2 a_position;\n\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_offsetScaleMatrix;\nuniform mat4 u_offsetRotateMatrix;\n\nvoid main(void) {\n  gl_Position = u_projectionMatrix * vec4(a_position, 0.0, 1.0);\n}\n\n\n",ol.render.webgl.polygonreplay.defaultshader.Vertex.OPTIMIZED_SOURCE="attribute vec2 a;uniform mat4 b;uniform mat4 c;uniform mat4 d;void main(void){gl_Position=b*vec4(a,0.0,1.0);}",ol.render.webgl.polygonreplay.defaultshader.Vertex.SOURCE=ol.DEBUG?ol.render.webgl.polygonreplay.defaultshader.Vertex.DEBUG_SOURCE:ol.render.webgl.polygonreplay.defaultshader.Vertex.OPTIMIZED_SOURCE,ol.render.webgl.polygonreplay.defaultshader.vertex=new ol.render.webgl.polygonreplay.defaultshader.Vertex,ol.render.webgl.polygonreplay.defaultshader.Locations=function(e,o){this.u_color=e.getUniformLocation(o,ol.DEBUG?"u_color":"e"),this.u_offsetRotateMatrix=e.getUniformLocation(o,ol.DEBUG?"u_offsetRotateMatrix":"d"),this.u_offsetScaleMatrix=e.getUniformLocation(o,ol.DEBUG?"u_offsetScaleMatrix":"c"),this.u_opacity=e.getUniformLocation(o,ol.DEBUG?"u_opacity":"f"),this.u_projectionMatrix=e.getUniformLocation(o,ol.DEBUG?"u_projectionMatrix":"b"),this.a_position=e.getAttribLocation(o,ol.DEBUG?"a_position":"a")},goog.provide("ol.structs.LinkedList"),ol.structs.LinkedList=function(e){this.first_=void 0,this.last_=void 0,this.head_=void 0,this.circular_=void 0===e||e,this.length_=0},ol.structs.LinkedList.prototype.insertItem=function(e){var o={prev:void 0,next:void 0,data:e},t=this.head_;if(t){var r=t.next;o.prev=t,o.next=r,t.next=o,r&&(r.prev=o),t===this.last_&&(this.last_=o)}else this.first_=o,this.last_=o,this.circular_&&(o.next=o,o.prev=o);this.head_=o,this.length_++},ol.structs.LinkedList.prototype.removeItem=function(){var e=this.head_;if(e){var o=e.next,t=e.prev;o&&(o.prev=t),t&&(t.next=o),this.head_=o||t,this.first_===this.last_?(this.head_=void 0,this.first_=void 0,this.last_=void 0):this.first_===e?this.first_=this.head_:this.last_===e&&(this.last_=t?this.head_.prev:this.head_),this.length_--}},ol.structs.LinkedList.prototype.firstItem=function(){if(this.head_=this.first_,this.head_)return this.head_.data},ol.structs.LinkedList.prototype.lastItem=function(){if(this.head_=this.last_,this.head_)return this.head_.data},ol.structs.LinkedList.prototype.nextItem=function(){if(this.head_&&this.head_.next)return this.head_=this.head_.next,this.head_.data},ol.structs.LinkedList.prototype.getNextItem=function(){if(this.head_&&this.head_.next)return this.head_.next.data},ol.structs.LinkedList.prototype.prevItem=function(){if(this.head_&&this.head_.prev)return this.head_=this.head_.prev,this.head_.data},ol.structs.LinkedList.prototype.getPrevItem=function(){if(this.head_&&this.head_.prev)return this.head_.prev.data},ol.structs.LinkedList.prototype.getCurrItem=function(){if(this.head_)return this.head_.data},ol.structs.LinkedList.prototype.setFirstItem=function(){this.circular_&&this.head_&&(this.first_=this.head_,this.last_=this.head_.prev)},ol.structs.LinkedList.prototype.concat=function(e){if(e.head_){if(this.head_){var o=this.head_.next;this.head_.next=e.first_,e.first_.prev=this.head_,o.prev=e.last_,e.last_.next=o,this.length_+=e.length_}else this.head_=e.head_,this.first_=e.first_,this.last_=e.last_,this.length_=e.length_;e.head_=void 0,e.first_=void 0,e.last_=void 0,e.length_=0}},ol.structs.LinkedList.prototype.getLength=function(){return this.length_};goog.provide("ol.ext.rbush"),ol.ext.rbush,function(){var e,o={},t={exports:o};!function(r){if("object"==typeof o&&void 0!==t)t.exports=r();else if("function"==typeof e&&e.amd)e([],r);else{var i;i="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,i.rbush=r()}}(function(){return function e(o,t,r){function i(l,a){if(!t[l]){if(!o[l]){var s="function"==typeof require&&require;if(!a&&s)return s(l,!0);if(n)return n(l,!0);var p=new Error("Cannot find module '"+l+"'");throw p.code="MODULE_NOT_FOUND",p}var g=t[l]={exports:{}};o[l][0].call(g.exports,function(e){var t=o[l][1][e];return i(t||e)},g,g.exports,e,o,t,r)}return t[l].exports}for(var n="function"==typeof require&&require,l=0;l<r.length;l++)i(r[l]);return i}({1:[function(e,o,t){"use strict";function r(e,o,t,l,a){for(t=t||0,l=l||e.length-1,a=a||n;l>t;){if(l-t>600){var s=l-t+1,p=o-t+1,g=Math.log(s),c=.5*Math.exp(2*g/3),u=.5*Math.sqrt(g*c*(s-c)/s)*(p-s/2<0?-1:1);r(e,o,Math.max(t,Math.floor(o-p*c/s+u)),Math.min(l,Math.floor(o+(s-p)*c/s+u)),a)}var y=e[o],d=t,h=l;for(i(e,t,o),a(e[l],y)>0&&i(e,t,l);d<h;){
for(i(e,d,h),d++,h--;a(e[d],y)<0;)d++;for(;a(e[h],y)>0;)h--}0===a(e[t],y)?i(e,t,h):(h++,i(e,h,l)),h<=o&&(t=h+1),o<=h&&(l=h-1)}}function i(e,o,t){var r=e[o];e[o]=e[t],e[t]=r}function n(e,o){return e<o?-1:e>o?1:0}o.exports=r},{}],2:[function(e,o,t){"use strict";function r(e,o){if(!(this instanceof r))return new r(e,o);this._maxEntries=Math.max(4,e||9),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),o&&this._initFormat(o),this.clear()}function i(e,o,t){if(!t)return o.indexOf(e);for(var r=0;r<o.length;r++)if(t(e,o[r]))return r;return-1}function n(e,o){l(e,0,e.children.length,o,e)}function l(e,o,t,r,i){i||(i=m(null)),i.minX=1/0,i.minY=1/0,i.maxX=-1/0,i.maxY=-1/0;for(var n,l=o;l<t;l++)n=e.children[l],a(i,e.leaf?r(n):n);return i}function a(e,o){return e.minX=Math.min(e.minX,o.minX),e.minY=Math.min(e.minY,o.minY),e.maxX=Math.max(e.maxX,o.maxX),e.maxY=Math.max(e.maxY,o.maxY),e}function s(e,o){return e.minX-o.minX}function p(e,o){return e.minY-o.minY}function g(e){return(e.maxX-e.minX)*(e.maxY-e.minY)}function c(e){return e.maxX-e.minX+(e.maxY-e.minY)}function u(e,o){return(Math.max(o.maxX,e.maxX)-Math.min(o.minX,e.minX))*(Math.max(o.maxY,e.maxY)-Math.min(o.minY,e.minY))}function y(e,o){var t=Math.max(e.minX,o.minX),r=Math.max(e.minY,o.minY),i=Math.min(e.maxX,o.maxX),n=Math.min(e.maxY,o.maxY);return Math.max(0,i-t)*Math.max(0,n-r)}function d(e,o){return e.minX<=o.minX&&e.minY<=o.minY&&o.maxX<=e.maxX&&o.maxY<=e.maxY}function h(e,o){return o.minX<=e.maxX&&o.minY<=e.maxY&&o.maxX>=e.minX&&o.maxY>=e.minY}function m(e){return{children:e,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function f(e,o,t,r,i){for(var n,l=[o,t];l.length;)t=l.pop(),o=l.pop(),t-o<=r||(n=o+Math.ceil((t-o)/r/2)*r,_(e,n,o,t,i),l.push(o,n,n,t))}o.exports=r;var _=e("quickselect");r.prototype={all:function(){return this._all(this.data,[])},search:function(e){var o=this.data,t=[],r=this.toBBox;if(!h(e,o))return t;for(var i,n,l,a,s=[];o;){for(i=0,n=o.children.length;i<n;i++)l=o.children[i],a=o.leaf?r(l):l,h(e,a)&&(o.leaf?t.push(l):d(e,a)?this._all(l,t):s.push(l));o=s.pop()}return t},collides:function(e){var o=this.data,t=this.toBBox;if(!h(e,o))return!1;for(var r,i,n,l,a=[];o;){for(r=0,i=o.children.length;r<i;r++)if(n=o.children[r],l=o.leaf?t(n):n,h(e,l)){if(o.leaf||d(e,l))return!0;a.push(n)}o=a.pop()}return!1},load:function(e){if(!e||!e.length)return this;if(e.length<this._minEntries){for(var o=0,t=e.length;o<t;o++)this.insert(e[o]);return this}var r=this._build(e.slice(),0,e.length-1,0);if(this.data.children.length)if(this.data.height===r.height)this._splitRoot(this.data,r);else{if(this.data.height<r.height){var i=this.data;this.data=r,r=i}this._insert(r,this.data.height-r.height-1,!0)}else this.data=r;return this},insert:function(e){return e&&this._insert(e,this.data.height-1),this},clear:function(){return this.data=m([]),this},remove:function(e,o){if(!e)return this;for(var t,r,n,l,a=this.data,s=this.toBBox(e),p=[],g=[];a||p.length;){if(a||(a=p.pop(),r=p[p.length-1],t=g.pop(),l=!0),a.leaf&&-1!==(n=i(e,a.children,o)))return a.children.splice(n,1),p.push(a),this._condense(p),this;l||a.leaf||!d(a,s)?r?(t++,a=r.children[t],l=!1):a=null:(p.push(a),g.push(t),t=0,r=a,a=a.children[0])}return this},toBBox:function(e){return e},compareMinX:s,compareMinY:p,toJSON:function(){return this.data},fromJSON:function(e){return this.data=e,this},_all:function(e,o){for(var t=[];e;)e.leaf?o.push.apply(o,e.children):t.push.apply(t,e.children),e=t.pop();return o},_build:function(e,o,t,r){var i,l=t-o+1,a=this._maxEntries;if(l<=a)return i=m(e.slice(o,t+1)),n(i,this.toBBox),i;r||(r=Math.ceil(Math.log(l)/Math.log(a)),a=Math.ceil(l/Math.pow(a,r-1))),i=m([]),i.leaf=!1,i.height=r;var s,p,g,c,u=Math.ceil(l/a),y=u*Math.ceil(Math.sqrt(a));for(f(e,o,t,y,this.compareMinX),s=o;s<=t;s+=y)for(g=Math.min(s+y-1,t),f(e,s,g,u,this.compareMinY),p=s;p<=g;p+=u)c=Math.min(p+u-1,g),i.children.push(this._build(e,p,c,r-1));return n(i,this.toBBox),i},_chooseSubtree:function(e,o,t,r){for(var i,n,l,a,s,p,c,y;;){if(r.push(o),o.leaf||r.length-1===t)break;for(c=y=1/0,i=0,n=o.children.length;i<n;i++)l=o.children[i],s=g(l),p=u(e,l)-s,p<y?(y=p,c=s<c?s:c,a=l):p===y&&s<c&&(c=s,a=l);o=a||o.children[0]}return o},_insert:function(e,o,t){var r=this.toBBox,i=t?e:r(e),n=[],l=this._chooseSubtree(i,this.data,o,n);for(l.children.push(e),a(l,i);o>=0&&n[o].children.length>this._maxEntries;)this._split(n,o),o--;this._adjustParentBBoxes(i,n,o)},_split:function(e,o){var t=e[o],r=t.children.length,i=this._minEntries;this._chooseSplitAxis(t,i,r);var l=this._chooseSplitIndex(t,i,r),a=m(t.children.splice(l,t.children.length-l));a.height=t.height,a.leaf=t.leaf,n(t,this.toBBox),n(a,this.toBBox),o?e[o-1].children.push(a):this._splitRoot(t,a)},_splitRoot:function(e,o){this.data=m([e,o]),this.data.height=e.height+1,this.data.leaf=!1,n(this.data,this.toBBox)},_chooseSplitIndex:function(e,o,t){var r,i,n,a,s,p,c,u;for(p=c=1/0,r=o;r<=t-o;r++)i=l(e,0,r,this.toBBox),n=l(e,r,t,this.toBBox),a=y(i,n),s=g(i)+g(n),a<p?(p=a,u=r,c=s<c?s:c):a===p&&s<c&&(c=s,u=r);return u},_chooseSplitAxis:function(e,o,t){var r=e.leaf?this.compareMinX:s,i=e.leaf?this.compareMinY:p;this._allDistMargin(e,o,t,r)<this._allDistMargin(e,o,t,i)&&e.children.sort(r)},_allDistMargin:function(e,o,t,r){e.children.sort(r);var i,n,s=this.toBBox,p=l(e,0,o,s),g=l(e,t-o,t,s),u=c(p)+c(g);for(i=o;i<t-o;i++)n=e.children[i],a(p,e.leaf?s(n):n),u+=c(p);for(i=t-o-1;i>=o;i--)n=e.children[i],a(g,e.leaf?s(n):n),u+=c(g);return u},_adjustParentBBoxes:function(e,o,t){for(var r=t;r>=0;r--)a(o[r],e)},_condense:function(e){for(var o,t=e.length-1;t>=0;t--)0===e[t].children.length?t>0?(o=e[t-1].children,o.splice(o.indexOf(e[t]),1)):this.clear():n(e[t],this.toBBox)},_initFormat:function(e){var o=["return a"," - b",";"];this.compareMinX=new Function("a","b",o.join(e[0])),this.compareMinY=new Function("a","b",o.join(e[1])),this.toBBox=new Function("a","return {minX: a"+e[0]+", minY: a"+e[1]+", maxX: a"+e[2]+", maxY: a"+e[3]+"};")}}},{quickselect:1}]},{},[2])(2)}),ol.ext.rbush=t.exports}(),goog.provide("ol.structs.RBush"),goog.require("ol"),goog.require("ol.ext.rbush"),goog.require("ol.extent"),goog.require("ol.obj"),ol.structs.RBush=function(e){this.rbush_=ol.ext.rbush(e),this.items_={},ol.DEBUG&&(this.readers_=0)},ol.structs.RBush.prototype.insert=function(e,o){if(ol.DEBUG&&this.readers_)throw new Error("Can not insert value while reading");var t={minX:e[0],minY:e[1],maxX:e[2],maxY:e[3],value:o};this.rbush_.insert(t),ol.DEBUG&&console.assert(!(ol.getUid(o)in this.items_),"uid (%s) of value (%s) already exists",ol.getUid(o),o),this.items_[ol.getUid(o)]=t},ol.structs.RBush.prototype.load=function(e,o){if(ol.DEBUG&&this.readers_)throw new Error("Can not insert values while reading");ol.DEBUG&&console.assert(e.length===o.length,"extens and values must have same length (%s === %s)",e.length,o.length);for(var t=new Array(o.length),r=0,i=o.length;r<i;r++){var n=e[r],l=o[r],a={minX:n[0],minY:n[1],maxX:n[2],maxY:n[3],value:l};t[r]=a,ol.DEBUG&&console.assert(!(ol.getUid(l)in this.items_),"uid (%s) of value (%s) already exists",ol.getUid(l),l),this.items_[ol.getUid(l)]=a}this.rbush_.load(t)},ol.structs.RBush.prototype.remove=function(e){if(ol.DEBUG&&this.readers_)throw new Error("Can not remove value while reading");var o=ol.getUid(e);ol.DEBUG&&console.assert(o in this.items_,"uid (%s) of value (%s) does not exist",o,e);var t=this.items_[o];return delete this.items_[o],null!==this.rbush_.remove(t)},ol.structs.RBush.prototype.update=function(e,o){ol.DEBUG&&console.assert(ol.getUid(o)in this.items_,"uid (%s) of value (%s) does not exist",ol.getUid(o),o);var t=this.items_[ol.getUid(o)],r=[t.minX,t.minY,t.maxX,t.maxY];if(!ol.extent.equals(r,e)){if(ol.DEBUG&&this.readers_)throw new Error("Can not update extent while reading");this.remove(o),this.insert(e,o)}},ol.structs.RBush.prototype.getAll=function(){return this.rbush_.all().map(function(e){return e.value})},ol.structs.RBush.prototype.getInExtent=function(e){var o={minX:e[0],minY:e[1],maxX:e[2],maxY:e[3]};return this.rbush_.search(o).map(function(e){return e.value})},ol.structs.RBush.prototype.forEach=function(e,o){if(!ol.DEBUG)return this.forEach_(this.getAll(),e,o);++this.readers_;try{return this.forEach_(this.getAll(),e,o)}finally{--this.readers_}},ol.structs.RBush.prototype.forEachInExtent=function(e,o,t){if(!ol.DEBUG)return this.forEach_(this.getInExtent(e),o,t);++this.readers_;try{return this.forEach_(this.getInExtent(e),o,t)}finally{--this.readers_}},ol.structs.RBush.prototype.forEach_=function(e,o,t){for(var r,i=0,n=e.length;i<n;i++)if(r=o.call(t,e[i]))return r;return r},ol.structs.RBush.prototype.isEmpty=function(){return ol.obj.isEmpty(this.items_)},ol.structs.RBush.prototype.clear=function(){this.rbush_.clear(),this.items_={}},ol.structs.RBush.prototype.getExtent=function(e){var o=this.rbush_.data;return[o.minX,o.minY,o.maxX,o.maxY]},goog.provide("ol.render.webgl.PolygonReplay"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.color"),goog.require("ol.extent"),goog.require("ol.obj"),goog.require("ol.geom.flat.contains"),goog.require("ol.geom.flat.orient"),goog.require("ol.geom.flat.transform"),goog.require("ol.render.webgl.polygonreplay.defaultshader"),goog.require("ol.render.webgl.LineStringReplay"),goog.require("ol.render.webgl.Replay"),goog.require("ol.render.webgl"),goog.require("ol.style.Stroke"),goog.require("ol.structs.LinkedList"),goog.require("ol.structs.RBush"),goog.require("ol.webgl"),goog.require("ol.webgl.Buffer"),ol.render.webgl.PolygonReplay=function(e,o){ol.render.webgl.Replay.call(this,e,o),this.lineStringReplay=new ol.render.webgl.LineStringReplay(e,o),this.defaultLocations_=null,this.styles_=[],this.styleIndices_=[],this.state_={fillColor:null,changed:!1}},ol.inherits(ol.render.webgl.PolygonReplay,ol.render.webgl.Replay),ol.render.webgl.PolygonReplay.prototype.drawCoordinates_=function(e,o,t){var r=new ol.structs.LinkedList,i=new ol.structs.RBush,n=this.processFlatCoordinates_(e,t,r,i,!0);if(o.length){var l,a,s=[];for(l=0,a=o.length;l<a;++l){var p={list:new ol.structs.LinkedList,maxX:void 0};s.push(p),p.maxX=this.processFlatCoordinates_(o[l],t,p.list,i,!1)}for(s.sort(function(e,o){return o.maxX-e.maxX}),l=0;l<s.length;++l)this.bridgeHole_(s[l].list,s[l].maxX,r,n,i)}this.classifyPoints_(r,i,!1),this.triangulate_(r,i)},ol.render.webgl.PolygonReplay.prototype.processFlatCoordinates_=function(e,o,t,r,i){var n,l,a,s,p,g,c=ol.geom.flat.orient.linearRingIsClockwise(e,0,e.length,o),u=this.vertices.length/2,y=[],d=[];if(i===c){for(s=this.createPoint_(e[0],e[1],u++),p=s,a=e[0],n=o,l=e.length;n<l;n+=o)g=this.createPoint_(e[n],e[n+1],u++),d.push(this.insertItem_(p,g,t)),y.push([Math.min(p.x,g.x),Math.min(p.y,g.y),Math.max(p.x,g.x),Math.max(p.y,g.y)]),a=e[n]>a?e[n]:a,p=g;d.push(this.insertItem_(g,s,t)),y.push([Math.min(p.x,g.x),Math.min(p.y,g.y),Math.max(p.x,g.x),Math.max(p.y,g.y)])}else{var h=e.length-o;for(s=this.createPoint_(e[h],e[h+1],u++),p=s,a=e[h],n=h-o,l=0;n>=l;n-=o)g=this.createPoint_(e[n],e[n+1],u++),d.push(this.insertItem_(p,g,t)),y.push([Math.min(p.x,g.x),Math.min(p.y,g.y),Math.max(p.x,g.x),Math.max(p.y,g.y)]),a=e[n]>a?e[n]:a,p=g;d.push(this.insertItem_(g,s,t)),y.push([Math.min(p.x,g.x),Math.min(p.y,g.y),Math.max(p.x,g.x),Math.max(p.y,g.y)])}return r.load(y,d),a},ol.render.webgl.PolygonReplay.prototype.classifyPoints_=function(e,o,t){var r=e.firstItem(),i=r,n=e.nextItem(),l=!1;do{var a=t?ol.render.webgl.triangleIsCounterClockwise(n.p1.x,n.p1.y,i.p1.x,i.p1.y,i.p0.x,i.p0.y):ol.render.webgl.triangleIsCounterClockwise(i.p0.x,i.p0.y,i.p1.x,i.p1.y,n.p1.x,n.p1.y);void 0===a?(this.removeItem_(i,n,e,o),l=!0,n===r&&(r=e.getNextItem()),n=i,e.prevItem()):i.p1.reflex!==a&&(i.p1.reflex=a,l=!0),i=n,n=e.nextItem()}while(i!==r);return l},ol.render.webgl.PolygonReplay.prototype.bridgeHole_=function(e,o,t,r,i){this.classifyPoints_(e,i,!0);for(var n=e.firstItem();n.p1.x!==o;)n=e.nextItem();var l,a,s,p,g=n.p1,c={x:r,y:g.y,i:-1},u=1/0,y=this.getIntersections_({p0:g,p1:c},i,!0);for(l=0,a=y.length;l<a;++l){var d=y[l];if(void 0===d.p0.reflex){var h=this.calculateIntersection_(g,c,d.p0,d.p1,!0),m=Math.abs(g.x-h[0]);m<u&&(u=m,p={x:h[0],y:h[1],i:-1},n=d)}}if(u!==1/0){if(s=n.p1,u>0){var f=this.getPointsInTriangle_(g,p,n.p1,i);if(f.length){var _=1/0;for(l=0,a=f.length;l<a;++l){var E=f[l],v=Math.atan2(g.y-E.y,c.x-E.x);(v<_||v===_&&E.x<s.x)&&(_=v,s=E)}}}for(n=t.firstItem();n.p1!==s;)n=t.nextItem();var S={x:g.x,y:g.y,i:g.i,reflex:void 0},x={x:n.p1.x,y:n.p1.y,i:n.p1.i,reflex:void 0};e.getNextItem().p0=S,this.insertItem_(g,n.p1,e,i),this.insertItem_(x,S,e,i),n.p1=x,e.setFirstItem(),t.concat(e)}},ol.render.webgl.PolygonReplay.prototype.triangulate_=function(e,o){for(var t=!1,r=this.isSimple_(e,o);e.getLength()>3;)if(r){if(!this.clipEars_(e,o,r,t)&&!this.classifyPoints_(e,o,t)&&!this.resolveLocalSelfIntersections_(e,o,!0)){ol.DEBUG&&console.assert(!1,"Unexpected simple polygon geometry");break}}else if(!this.clipEars_(e,o,r,t)&&!this.classifyPoints_(e,o,t)&&!this.resolveLocalSelfIntersections_(e,o)){if(!(r=this.isSimple_(e,o))){this.splitPolygon_(e,o);break}t=!this.isClockwise_(e),this.classifyPoints_(e,o,t)}if(3===e.getLength()){var i=this.indices.length;this.indices[i++]=e.getPrevItem().p0.i,this.indices[i++]=e.getCurrItem().p0.i,this.indices[i++]=e.getNextItem().p0.i}},ol.render.webgl.PolygonReplay.prototype.clipEars_=function(e,o,t,r){var i,n,l,a=this.indices.length,s=e.firstItem(),p=e.getPrevItem(),g=s,c=e.nextItem(),u=e.getNextItem(),y=!1;do{if(i=g.p0,n=g.p1,l=c.p1,!1===n.reflex){var d=r?this.diagonalIsInside_(u.p1,l,n,i,p.p0):this.diagonalIsInside_(p.p0,i,n,l,u.p1);(t||0===this.getIntersections_({p0:i,p1:l},o).length)&&d&&0===this.getPointsInTriangle_(i,n,l,o,!0).length&&(t||!1===i.reflex||!1===l.reflex||ol.geom.flat.orient.linearRingIsClockwise([p.p0.x,p.p0.y,i.x,i.y,n.x,n.y,l.x,l.y,u.p1.x,u.p1.y],0,10,2)===!r)&&(this.indices[a++]=i.i,this.indices[a++]=n.i,this.indices[a++]=l.i,this.removeItem_(g,c,e,o),c===s&&(s=u),y=!0)}p=e.getPrevItem(),g=e.getCurrItem(),c=e.nextItem(),u=e.getNextItem()}while(g!==s&&e.getLength()>3);return y},ol.render.webgl.PolygonReplay.prototype.resolveLocalSelfIntersections_=function(e,o,t){var r=e.firstItem();e.nextItem();var i=r,n=e.nextItem(),l=!1;do{var a=this.calculateIntersection_(i.p0,i.p1,n.p0,n.p1,t);if(a){var s=!1,p=this.vertices.length,g=this.indices.length,c=p/2,u=e.prevItem();e.removeItem(),o.remove(u),s=u===r;var y;if(t?(a[0]===i.p0.x&&a[1]===i.p0.y?(e.prevItem(),y=i.p0,n.p0=y,o.remove(i),s=s||i===r):(y=n.p1,i.p1=y,o.remove(n),s=s||n===r),e.removeItem()):(y=this.createPoint_(a[0],a[1],c),i.p1=y,n.p0=y,o.update([Math.min(i.p0.x,i.p1.x),Math.min(i.p0.y,i.p1.y),Math.max(i.p0.x,i.p1.x),Math.max(i.p0.y,i.p1.y)],i),o.update([Math.min(n.p0.x,n.p1.x),Math.min(n.p0.y,n.p1.y),Math.max(n.p0.x,n.p1.x),Math.max(n.p0.y,n.p1.y)],n)),this.indices[g++]=u.p0.i,this.indices[g++]=u.p1.i,this.indices[g++]=y.i,l=!0,s)break}i=e.getPrevItem(),n=e.nextItem()}while(i!==r);return l},ol.render.webgl.PolygonReplay.prototype.isSimple_=function(e,o){var t=e.firstItem(),r=t;do{if(this.getIntersections_(r,o).length)return!1;r=e.nextItem()}while(r!==t);return!0},ol.render.webgl.PolygonReplay.prototype.isClockwise_=function(e){var o=2*e.getLength(),t=new Array(o),r=e.firstItem(),i=r,n=0;do{t[n++]=i.p0.x,t[n++]=i.p0.y,i=e.nextItem()}while(i!==r);return ol.geom.flat.orient.linearRingIsClockwise(t,0,o,2)},ol.render.webgl.PolygonReplay.prototype.splitPolygon_=function(e,o){var t=e.firstItem(),r=t;do{var i=this.getIntersections_(r,o);if(i.length){var n=i[0],l=this.vertices.length/2,a=this.calculateIntersection_(r.p0,r.p1,n.p0,n.p1),s=this.createPoint_(a[0],a[1],l),p=new ol.structs.LinkedList,g=new ol.structs.RBush;this.insertItem_(s,r.p1,p,g),r.p1=s,o.update([Math.min(r.p0.x,s.x),Math.min(r.p0.y,s.y),Math.max(r.p0.x,s.x),Math.max(r.p0.y,s.y)],r);for(var c=e.nextItem();c!==n;)this.insertItem_(c.p0,c.p1,p,g),o.remove(c),e.removeItem(),c=e.getCurrItem();this.insertItem_(n.p0,s,p,g),n.p0=s,o.update([Math.min(n.p1.x,s.x),Math.min(n.p1.y,s.y),Math.max(n.p1.x,s.x),Math.max(n.p1.y,s.y)],n),this.classifyPoints_(e,o,!1),this.triangulate_(e,o),this.classifyPoints_(p,g,!1),this.triangulate_(p,g);break}r=e.nextItem()}while(r!==t)},ol.render.webgl.PolygonReplay.prototype.createPoint_=function(e,o,t){var r=this.vertices.length;return this.vertices[r++]=e,this.vertices[r++]=o,{x:e,y:o,i:t,reflex:void 0}},ol.render.webgl.PolygonReplay.prototype.insertItem_=function(e,o,t,r){var i={p0:e,p1:o};return t.insertItem(i),r&&r.insert([Math.min(e.x,o.x),Math.min(e.y,o.y),Math.max(e.x,o.x),Math.max(e.y,o.y)],i),i},ol.render.webgl.PolygonReplay.prototype.removeItem_=function(e,o,t,r){t.getCurrItem()===o&&(t.removeItem(),e.p1=o.p1,r.remove(o),r.update([Math.min(e.p0.x,e.p1.x),Math.min(e.p0.y,e.p1.y),Math.max(e.p0.x,e.p1.x),Math.max(e.p0.y,e.p1.y)],e))},ol.render.webgl.PolygonReplay.prototype.getPointsInTriangle_=function(e,o,t,r,i){var n,l,a,s,p=[],g=r.getInExtent([Math.min(e.x,o.x,t.x),Math.min(e.y,o.y,t.y),Math.max(e.x,o.x,t.x),Math.max(e.y,o.y,t.y)]);for(n=0,l=g.length;n<l;++n)for(a in g[n])"object"!=typeof(s=g[n][a])||i&&!s.reflex||s.x===e.x&&s.y===e.y||s.x===o.x&&s.y===o.y||s.x===t.x&&s.y===t.y||-1!==p.indexOf(s)||!ol.geom.flat.contains.linearRingContainsXY([e.x,e.y,o.x,o.y,t.x,t.y],0,6,2,s.x,s.y)||p.push(s);return p},ol.render.webgl.PolygonReplay.prototype.getIntersections_=function(e,o,t){var r,i,n=e.p0,l=e.p1,a=o.getInExtent([Math.min(n.x,l.x),Math.min(n.y,l.y),Math.max(n.x,l.x),Math.max(n.y,l.y)]),s=[];for(r=0,i=a.length;r<i;++r){var p=a[r];e!==p&&(t||p.p0!==l||p.p1!==n)&&this.calculateIntersection_(n,l,p.p0,p.p1,t)&&s.push(p)}return s},ol.render.webgl.PolygonReplay.prototype.calculateIntersection_=function(e,o,t,r,i){var n=(r.y-t.y)*(o.x-e.x)-(r.x-t.x)*(o.y-e.y);if(0!==n){var l=((r.x-t.x)*(e.y-t.y)-(r.y-t.y)*(e.x-t.x))/n,a=((o.x-e.x)*(e.y-t.y)-(o.y-e.y)*(e.x-t.x))/n;if(!i&&l>ol.render.webgl.EPSILON&&l<1-ol.render.webgl.EPSILON&&a>ol.render.webgl.EPSILON&&a<1-ol.render.webgl.EPSILON||i&&l>=0&&l<=1&&a>=0&&a<=1)return[e.x+l*(o.x-e.x),e.y+l*(o.y-e.y)]}},ol.render.webgl.PolygonReplay.prototype.diagonalIsInside_=function(e,o,t,r,i){if(void 0===o.reflex||void 0===r.reflex)return!1;var n=(t.x-r.x)*(o.y-r.y)>(t.y-r.y)*(o.x-r.x),l=(i.x-r.x)*(o.y-r.y)<(i.y-r.y)*(o.x-r.x),a=(e.x-o.x)*(r.y-o.y)>(e.y-o.y)*(r.x-o.x),s=(t.x-o.x)*(r.y-o.y)<(t.y-o.y)*(r.x-o.x),p=r.reflex?l||n:l&&n,g=o.reflex?s||a:s&&a;return p&&g},ol.render.webgl.PolygonReplay.prototype.drawMultiPolygon=function(e,o){var t,r,i,n,l=e.getPolygons(),a=e.getStride(),s=this.indices.length,p=this.lineStringReplay.getCurrentIndex();for(t=0,r=l.length;t<r;++t){var g=l[t].getLinearRings();if(g.length>0){var c=g[0].getFlatCoordinates();c=ol.geom.flat.transform.translate(c,0,c.length,a,-this.origin[0],-this.origin[1]);var u,y=[];for(i=1,n=g.length;i<n;++i)u=g[i].getFlatCoordinates(),u=ol.geom.flat.transform.translate(u,0,u.length,a,-this.origin[0],-this.origin[1]),y.push(u);this.lineStringReplay.drawPolygonCoordinates(c,y,a),this.drawCoordinates_(c,y,a)}}this.indices.length>s&&(this.startIndices.push(s),this.startIndicesFeature.push(o),this.state_.changed&&(this.styleIndices_.push(s),this.state_.changed=!1)),this.lineStringReplay.getCurrentIndex()>p&&this.lineStringReplay.setPolygonStyle(o,p)},ol.render.webgl.PolygonReplay.prototype.drawPolygon=function(e,o){var t=e.getLinearRings(),r=e.getStride();if(t.length>0){this.startIndices.push(this.indices.length),this.startIndicesFeature.push(o),this.state_.changed&&(this.styleIndices_.push(this.indices.length),this.state_.changed=!1),this.lineStringReplay.setPolygonStyle(o);var i=t[0].getFlatCoordinates();i=ol.geom.flat.transform.translate(i,0,i.length,r,-this.origin[0],-this.origin[1]);var n,l,a,s=[];for(n=1,l=t.length;n<l;++n)a=t[n].getFlatCoordinates(),a=ol.geom.flat.transform.translate(a,0,a.length,r,-this.origin[0],-this.origin[1]),s.push(a);this.lineStringReplay.drawPolygonCoordinates(i,s,r),this.drawCoordinates_(i,s,r)}},ol.render.webgl.PolygonReplay.prototype.finish=function(e){this.verticesBuffer=new ol.webgl.Buffer(this.vertices),this.indicesBuffer=new ol.webgl.Buffer(this.indices),this.startIndices.push(this.indices.length),this.lineStringReplay.finish(e),0===this.styleIndices_.length&&this.styles_.length>0&&(this.styles_=[]),this.vertices=null,this.indices=null},ol.render.webgl.PolygonReplay.prototype.getDeleteResourcesFunction=function(e){ol.DEBUG&&console.assert(this.verticesBuffer,"verticesBuffer must not be null"),ol.DEBUG&&console.assert(this.indicesBuffer,"indicesBuffer must not be null");var o=this.verticesBuffer,t=this.indicesBuffer,r=this.lineStringReplay.getDeleteResourcesFunction(e);return function(){e.deleteBuffer(o),e.deleteBuffer(t),r()}},ol.render.webgl.PolygonReplay.prototype.setUpProgram=function(e,o,t,r){var i,n;i=ol.render.webgl.polygonreplay.defaultshader.fragment,n=ol.render.webgl.polygonreplay.defaultshader.vertex;var l,a=o.getProgram(i,n);return this.defaultLocations_?l=this.defaultLocations_:(l=new ol.render.webgl.polygonreplay.defaultshader.Locations(e,a),this.defaultLocations_=l),o.useProgram(a),e.enableVertexAttribArray(l.a_position),e.vertexAttribPointer(l.a_position,2,ol.webgl.FLOAT,!1,8,0),l},ol.render.webgl.PolygonReplay.prototype.shutDownProgram=function(e,o){e.disableVertexAttribArray(o.a_position)},ol.render.webgl.PolygonReplay.prototype.drawReplay=function(e,o,t,r){var i=e.getParameter(e.DEPTH_FUNC),n=e.getParameter(e.DEPTH_WRITEMASK);if(r||(e.enable(e.DEPTH_TEST),e.depthMask(!0),e.depthFunc(e.NOTEQUAL)),ol.obj.isEmpty(t)){ol.DEBUG&&console.assert(this.styles_.length===this.styleIndices_.length,"number of styles and styleIndices match");var l,a,s,p;for(s=this.startIndices[this.startIndices.length-1],l=this.styleIndices_.length-1;l>=0;--l)a=this.styleIndices_[l],p=this.styles_[l],this.setFillStyle_(e,p),this.drawElements(e,o,a,s),s=a}else this.drawReplaySkipping_(e,o,t);r||(e.disable(e.DEPTH_TEST),e.clear(e.DEPTH_BUFFER_BIT),e.depthMask(n),e.depthFunc(i))},ol.render.webgl.PolygonReplay.prototype.drawHitDetectionReplayOneByOne=function(e,o,t,r,i){ol.DEBUG&&console.assert(this.styles_.length===this.styleIndices_.length,"number of styles and styleIndices match"),ol.DEBUG&&console.assert(this.startIndices.length-1===this.startIndicesFeature.length,"number of startIndices and startIndicesFeature match");var n,l,a,s,p,g,c,u;for(u=this.startIndices.length-2,a=this.startIndices[u+1],n=this.styleIndices_.length-1;n>=0;--n)for(s=this.styles_[n],this.setFillStyle_(e,s),p=this.styleIndices_[n];u>=0&&this.startIndices[u]>=p;){if(l=this.startIndices[u],g=this.startIndicesFeature[u],c=ol.getUid(g).toString(),void 0===t[c]&&g.getGeometry()&&(void 0===i||ol.extent.intersects(i,g.getGeometry().getExtent()))){e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT),this.drawElements(e,o,l,a);var y=r(g);if(y)return y}u--,a=l}},ol.render.webgl.PolygonReplay.prototype.drawReplaySkipping_=function(e,o,t){ol.DEBUG&&console.assert(this.startIndices.length-1===this.startIndicesFeature.length,"number of startIndices and startIndicesFeature match");var r,i,n,l,a,s,p,g,c;for(g=this.startIndices.length-2,n=i=this.startIndices[g+1],r=this.styleIndices_.length-1;r>=0;--r){for(l=this.styles_[r],this.setFillStyle_(e,l),a=this.styleIndices_[r];g>=0&&this.startIndices[g]>=a;)c=this.startIndices[g],s=this.startIndicesFeature[g],p=ol.getUid(s).toString(),t[p]&&(i!==n&&(this.drawElements(e,o,i,n),e.clear(e.DEPTH_BUFFER_BIT)),n=c),g--,i=c;i!==n&&(this.drawElements(e,o,i,n),e.clear(e.DEPTH_BUFFER_BIT)),i=n=a}},ol.render.webgl.PolygonReplay.prototype.setFillStyle_=function(e,o){e.uniform4fv(this.defaultLocations_.u_color,o)},ol.render.webgl.PolygonReplay.prototype.setFillStrokeStyle=function(e,o){ol.DEBUG&&console.assert(this.state_,"this.state_ should not be null");var t=e?e.getColor():[0,0,0,0];if(t=t instanceof CanvasGradient||t instanceof CanvasPattern?ol.render.webgl.defaultFillStyle:ol.color.asArray(t).map(function(e,o){return 3!=o?e/255:e})||ol.render.webgl.defaultFillStyle,this.state_.fillColor&&ol.array.equals(t,this.state_.fillColor)||(this.state_.fillColor=t,this.state_.changed=!0,this.styles_.push(t)),o)this.lineStringReplay.setFillStrokeStyle(null,o);else{var r=new ol.style.Stroke({color:[0,0,0,0],lineWidth:0});this.lineStringReplay.setFillStrokeStyle(null,r)}},goog.provide("ol.render.webgl.TextReplay"),goog.require("ol"),ol.render.webgl.TextReplay=function(e,o){},ol.render.webgl.TextReplay.prototype.setTextStyle=function(e){},ol.render.webgl.TextReplay.prototype.replay=function(e,o,t,r,i,n,l,a,s,p,g){},ol.render.webgl.TextReplay.prototype.drawText=function(e,o,t,r,i,n){},ol.render.webgl.TextReplay.prototype.finish=function(e){},ol.render.webgl.TextReplay.prototype.getDeleteResourcesFunction=function(e){return ol.nullFunction},goog.provide("ol.render.webgl.ReplayGroup"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.extent"),goog.require("ol.obj"),goog.require("ol.render.replay"),goog.require("ol.render.ReplayGroup"),goog.require("ol.render.webgl"),goog.require("ol.render.webgl.CircleReplay"),goog.require("ol.render.webgl.ImageReplay"),goog.require("ol.render.webgl.LineStringReplay"),goog.require("ol.render.webgl.PolygonReplay"),goog.require("ol.render.webgl.TextReplay"),ol.render.webgl.ReplayGroup=function(e,o,t){ol.render.ReplayGroup.call(this),this.maxExtent_=o,this.tolerance_=e,this.renderBuffer_=t,this.replaysByZIndex_={}},ol.inherits(ol.render.webgl.ReplayGroup,ol.render.ReplayGroup),ol.render.webgl.ReplayGroup.prototype.getDeleteResourcesFunction=function(e){var o,t=[];for(o in this.replaysByZIndex_){var r,i=this.replaysByZIndex_[o];for(r in i)t.push(i[r].getDeleteResourcesFunction(e))}return function(){for(var e,o=t.length,r=0;r<o;r++)e=t[r].apply(this,arguments);return e}},ol.render.webgl.ReplayGroup.prototype.finish=function(e){var o;for(o in this.replaysByZIndex_){var t,r=this.replaysByZIndex_[o];for(t in r)r[t].finish(e)}},ol.render.webgl.ReplayGroup.prototype.getReplay=function(e,o){var t=void 0!==e?e.toString():"0",r=this.replaysByZIndex_[t];void 0===r&&(r={},this.replaysByZIndex_[t]=r);var i=r[o];if(void 0===i){var n=ol.render.webgl.ReplayGroup.BATCH_CONSTRUCTORS_[o];ol.DEBUG&&console.assert(void 0!==n,o+" constructor missing from ol.render.webgl.ReplayGroup.BATCH_CONSTRUCTORS_"),i=new n(this.tolerance_,this.maxExtent_),r[o]=i}return i},ol.render.webgl.ReplayGroup.prototype.isEmpty=function(){return ol.obj.isEmpty(this.replaysByZIndex_)},ol.render.webgl.ReplayGroup.prototype.replay=function(e,o,t,r,i,n,l,a){var s=Object.keys(this.replaysByZIndex_).map(Number);s.sort(ol.array.numberSafeCompareFunction);var p,g,c,u,y,d;for(p=0,g=s.length;p<g;++p)for(y=this.replaysByZIndex_[s[p].toString()],c=0,u=ol.render.replay.ORDER.length;c<u;++c)void 0!==(d=y[ol.render.replay.ORDER[c]])&&d.replay(e,o,t,r,i,n,l,a,void 0,!1)},ol.render.webgl.ReplayGroup.prototype.replayHitDetection_=function(e,o,t,r,i,n,l,a,s,p,g){var c=Object.keys(this.replaysByZIndex_).map(Number);c.sort(function(e,o){return o-e});var u,y,d,h,m,f;for(u=0,y=c.length;u<y;++u)for(h=this.replaysByZIndex_[c[u].toString()],d=ol.render.replay.ORDER.length-1;d>=0;--d)if(void 0!==(m=h[ol.render.replay.ORDER[d]])&&(f=m.replay(e,o,t,r,i,n,l,a,s,p,g)))return f},ol.render.webgl.ReplayGroup.prototype.forEachFeatureAtCoordinate=function(e,o,t,r,i,n,l,a,s,p){var g=o.getGL();g.bindFramebuffer(g.FRAMEBUFFER,o.getHitDetectionFramebuffer());var c;return void 0!==this.renderBuffer_&&(c=ol.extent.buffer(ol.extent.createOrUpdateFromCoordinate(e),r*this.renderBuffer_)),this.replayHitDetection_(o,e,r,i,ol.render.webgl.ReplayGroup.HIT_DETECTION_SIZE_,l,a,s,function(e){var o=new Uint8Array(4);if(g.readPixels(0,0,1,1,g.RGBA,g.UNSIGNED_BYTE,o),o[3]>0){var t=p(e);if(t)return t}},!0,c)},ol.render.webgl.ReplayGroup.prototype.hasFeatureAtCoordinate=function(e,o,t,r,i,n,l,a,s){var p=o.getGL();return p.bindFramebuffer(p.FRAMEBUFFER,o.getHitDetectionFramebuffer()),void 0!==this.replayHitDetection_(o,e,r,i,ol.render.webgl.ReplayGroup.HIT_DETECTION_SIZE_,l,a,s,function(e){var o=new Uint8Array(4);return p.readPixels(0,0,1,1,p.RGBA,p.UNSIGNED_BYTE,o),o[3]>0},!1)},ol.render.webgl.ReplayGroup.HIT_DETECTION_SIZE_=[1,1],ol.render.webgl.ReplayGroup.BATCH_CONSTRUCTORS_={Circle:ol.render.webgl.CircleReplay,Image:ol.render.webgl.ImageReplay,LineString:ol.render.webgl.LineStringReplay,Polygon:ol.render.webgl.PolygonReplay,Text:ol.render.webgl.TextReplay},goog.provide("ol.render.webgl.Immediate"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.geom.GeometryType"),goog.require("ol.render.ReplayType"),goog.require("ol.render.VectorContext"),goog.require("ol.render.webgl.ReplayGroup"),goog.require("ol.render.webgl"),ol.render.webgl.Immediate=function(e,o,t,r,i,n,l){ol.render.VectorContext.call(this),this.context_=e,this.center_=o,this.extent_=n,this.pixelRatio_=l,this.size_=i,this.rotation_=r,this.resolution_=t,this.imageStyle_=null,this.fillStyle_=null,this.strokeStyle_=null},ol.inherits(ol.render.webgl.Immediate,ol.render.VectorContext),ol.render.webgl.Immediate.prototype.setStyle=function(e){this.setFillStrokeStyle(e.getFill(),e.getStroke()),this.setImageStyle(e.getImage())},ol.render.webgl.Immediate.prototype.drawGeometry=function(e){var o=e.getType();switch(o){case ol.geom.GeometryType.POINT:this.drawPoint(e,null);break;case ol.geom.GeometryType.LINE_STRING:this.drawLineString(e,null);break;case ol.geom.GeometryType.POLYGON:this.drawPolygon(e,null);break;case ol.geom.GeometryType.MULTI_POINT:this.drawMultiPoint(e,null);break;case ol.geom.GeometryType.MULTI_LINE_STRING:this.drawMultiLineString(e,null);break;case ol.geom.GeometryType.MULTI_POLYGON:this.drawMultiPolygon(e,null);break;case ol.geom.GeometryType.GEOMETRY_COLLECTION:this.drawGeometryCollection(e,null);break;case ol.geom.GeometryType.CIRCLE:this.drawCircle(e,null);break;default:ol.DEBUG&&console.assert(!1,"Unsupported geometry type: "+o)}},ol.render.webgl.Immediate.prototype.drawFeature=function(e,o){var t=o.getGeometryFunction()(e);t&&ol.extent.intersects(this.extent_,t.getExtent())&&(this.setStyle(o),ol.DEBUG&&console.assert(t,"geometry must be truthy"),this.drawGeometry(t))},ol.render.webgl.Immediate.prototype.drawGeometryCollection=function(e,o){var t,r,i=e.getGeometriesArray();for(t=0,r=i.length;t<r;++t)this.drawGeometry(i[t])},ol.render.webgl.Immediate.prototype.drawPoint=function(e,o){var t=this.context_,r=new ol.render.webgl.ReplayGroup(1,this.extent_),i=r.getReplay(0,ol.render.ReplayType.IMAGE);i.setImageStyle(this.imageStyle_),i.drawPoint(e,o),i.finish(t);var n={};i.replay(this.context_,this.center_,this.resolution_,this.rotation_,this.size_,this.pixelRatio_,1,n,void 0,!1),i.getDeleteResourcesFunction(t)()},ol.render.webgl.Immediate.prototype.drawMultiPoint=function(e,o){var t=this.context_,r=new ol.render.webgl.ReplayGroup(1,this.extent_),i=r.getReplay(0,ol.render.ReplayType.IMAGE);i.setImageStyle(this.imageStyle_),i.drawMultiPoint(e,o),i.finish(t);var n={};i.replay(this.context_,this.center_,this.resolution_,this.rotation_,this.size_,this.pixelRatio_,1,n,void 0,!1),i.getDeleteResourcesFunction(t)()},ol.render.webgl.Immediate.prototype.drawLineString=function(e,o){var t=this.context_,r=new ol.render.webgl.ReplayGroup(1,this.extent_),i=r.getReplay(0,ol.render.ReplayType.LINE_STRING);i.setFillStrokeStyle(null,this.strokeStyle_),i.drawLineString(e,o),i.finish(t);var n={};i.replay(this.context_,this.center_,this.resolution_,this.rotation_,this.size_,this.pixelRatio_,1,n,void 0,!1),i.getDeleteResourcesFunction(t)()},ol.render.webgl.Immediate.prototype.drawMultiLineString=function(e,o){var t=this.context_,r=new ol.render.webgl.ReplayGroup(1,this.extent_),i=r.getReplay(0,ol.render.ReplayType.LINE_STRING);i.setFillStrokeStyle(null,this.strokeStyle_),i.drawMultiLineString(e,o),i.finish(t);var n={};i.replay(this.context_,this.center_,this.resolution_,this.rotation_,this.size_,this.pixelRatio_,1,n,void 0,!1),i.getDeleteResourcesFunction(t)()},ol.render.webgl.Immediate.prototype.drawPolygon=function(e,o){
var t=this.context_,r=new ol.render.webgl.ReplayGroup(1,this.extent_),i=r.getReplay(0,ol.render.ReplayType.POLYGON);i.setFillStrokeStyle(this.fillStyle_,this.strokeStyle_),i.drawPolygon(e,o),i.finish(t);var n={};i.replay(this.context_,this.center_,this.resolution_,this.rotation_,this.size_,this.pixelRatio_,1,n,void 0,!1),i.getDeleteResourcesFunction(t)()},ol.render.webgl.Immediate.prototype.drawMultiPolygon=function(e,o){var t=this.context_,r=new ol.render.webgl.ReplayGroup(1,this.extent_),i=r.getReplay(0,ol.render.ReplayType.POLYGON);i.setFillStrokeStyle(this.fillStyle_,this.strokeStyle_),i.drawMultiPolygon(e,o),i.finish(t);var n={};i.replay(this.context_,this.center_,this.resolution_,this.rotation_,this.size_,this.pixelRatio_,1,n,void 0,!1),i.getDeleteResourcesFunction(t)()},ol.render.webgl.Immediate.prototype.drawCircle=function(e,o){var t=this.context_,r=new ol.render.webgl.ReplayGroup(1,this.extent_),i=r.getReplay(0,ol.render.ReplayType.CIRCLE);i.setFillStrokeStyle(this.fillStyle_,this.strokeStyle_),i.drawCircle(e,o),i.finish(t);var n={};i.replay(this.context_,this.center_,this.resolution_,this.rotation_,this.size_,this.pixelRatio_,1,n,void 0,!1),i.getDeleteResourcesFunction(t)()},ol.render.webgl.Immediate.prototype.setImageStyle=function(e){this.imageStyle_=e},ol.render.webgl.Immediate.prototype.setFillStrokeStyle=function(e,o){this.fillStyle_=e,this.strokeStyle_=o},goog.provide("ol.renderer.webgl.defaultmapshader"),goog.require("ol"),goog.require("ol.webgl.Fragment"),goog.require("ol.webgl.Vertex"),ol.renderer.webgl.defaultmapshader.Fragment=function(){ol.webgl.Fragment.call(this,ol.renderer.webgl.defaultmapshader.Fragment.SOURCE)},ol.inherits(ol.renderer.webgl.defaultmapshader.Fragment,ol.webgl.Fragment),ol.renderer.webgl.defaultmapshader.Fragment.DEBUG_SOURCE="precision mediump float;\nvarying vec2 v_texCoord;\n\n\nuniform float u_opacity;\nuniform sampler2D u_texture;\n\nvoid main(void) {\n  vec4 texColor = texture2D(u_texture, v_texCoord);\n  gl_FragColor.rgb = texColor.rgb;\n  gl_FragColor.a = texColor.a * u_opacity;\n}\n",ol.renderer.webgl.defaultmapshader.Fragment.OPTIMIZED_SOURCE="precision mediump float;varying vec2 a;uniform float f;uniform sampler2D g;void main(void){vec4 texColor=texture2D(g,a);gl_FragColor.rgb=texColor.rgb;gl_FragColor.a=texColor.a*f;}",ol.renderer.webgl.defaultmapshader.Fragment.SOURCE=ol.DEBUG?ol.renderer.webgl.defaultmapshader.Fragment.DEBUG_SOURCE:ol.renderer.webgl.defaultmapshader.Fragment.OPTIMIZED_SOURCE,ol.renderer.webgl.defaultmapshader.fragment=new ol.renderer.webgl.defaultmapshader.Fragment,ol.renderer.webgl.defaultmapshader.Vertex=function(){ol.webgl.Vertex.call(this,ol.renderer.webgl.defaultmapshader.Vertex.SOURCE)},ol.inherits(ol.renderer.webgl.defaultmapshader.Vertex,ol.webgl.Vertex),ol.renderer.webgl.defaultmapshader.Vertex.DEBUG_SOURCE="varying vec2 v_texCoord;\n\n\nattribute vec2 a_position;\nattribute vec2 a_texCoord;\n\nuniform mat4 u_texCoordMatrix;\nuniform mat4 u_projectionMatrix;\n\nvoid main(void) {\n  gl_Position = u_projectionMatrix * vec4(a_position, 0., 1.);\n  v_texCoord = (u_texCoordMatrix * vec4(a_texCoord, 0., 1.)).st;\n}\n\n\n",ol.renderer.webgl.defaultmapshader.Vertex.OPTIMIZED_SOURCE="varying vec2 a;attribute vec2 b;attribute vec2 c;uniform mat4 d;uniform mat4 e;void main(void){gl_Position=e*vec4(b,0.,1.);a=(d*vec4(c,0.,1.)).st;}",ol.renderer.webgl.defaultmapshader.Vertex.SOURCE=ol.DEBUG?ol.renderer.webgl.defaultmapshader.Vertex.DEBUG_SOURCE:ol.renderer.webgl.defaultmapshader.Vertex.OPTIMIZED_SOURCE,ol.renderer.webgl.defaultmapshader.vertex=new ol.renderer.webgl.defaultmapshader.Vertex,ol.renderer.webgl.defaultmapshader.Locations=function(e,o){this.u_opacity=e.getUniformLocation(o,ol.DEBUG?"u_opacity":"f"),this.u_projectionMatrix=e.getUniformLocation(o,ol.DEBUG?"u_projectionMatrix":"e"),this.u_texCoordMatrix=e.getUniformLocation(o,ol.DEBUG?"u_texCoordMatrix":"d"),this.u_texture=e.getUniformLocation(o,ol.DEBUG?"u_texture":"g"),this.a_position=e.getAttribLocation(o,ol.DEBUG?"a_position":"b"),this.a_texCoord=e.getAttribLocation(o,ol.DEBUG?"a_texCoord":"c")},goog.provide("ol.renderer.webgl.Layer"),goog.require("ol"),goog.require("ol.render.Event"),goog.require("ol.render.webgl.Immediate"),goog.require("ol.renderer.Layer"),goog.require("ol.renderer.webgl.defaultmapshader"),goog.require("ol.transform"),goog.require("ol.vec.Mat4"),goog.require("ol.webgl"),goog.require("ol.webgl.Buffer"),goog.require("ol.webgl.Context"),ol.renderer.webgl.Layer=function(e,o){ol.renderer.Layer.call(this,o),this.mapRenderer=e,this.arrayBuffer_=new ol.webgl.Buffer([-1,-1,0,0,1,-1,1,0,-1,1,0,1,1,1,1,1]),this.texture=null,this.framebuffer=null,this.framebufferDimension=void 0,this.texCoordMatrix=ol.transform.create(),this.projectionMatrix=ol.transform.create(),this.tmpMat4_=ol.vec.Mat4.create(),this.defaultLocations_=null},ol.inherits(ol.renderer.webgl.Layer,ol.renderer.Layer),ol.renderer.webgl.Layer.prototype.bindFramebuffer=function(e,o){var t=this.mapRenderer.getGL();if(void 0===this.framebufferDimension||this.framebufferDimension!=o){var r=function(e,o,t){e.isContextLost()||(e.deleteFramebuffer(o),e.deleteTexture(t))}.bind(null,t,this.framebuffer,this.texture);e.postRenderFunctions.push(r);var i=ol.webgl.Context.createEmptyTexture(t,o,o),n=t.createFramebuffer();t.bindFramebuffer(ol.webgl.FRAMEBUFFER,n),t.framebufferTexture2D(ol.webgl.FRAMEBUFFER,ol.webgl.COLOR_ATTACHMENT0,ol.webgl.TEXTURE_2D,i,0),this.texture=i,this.framebuffer=n,this.framebufferDimension=o}else t.bindFramebuffer(ol.webgl.FRAMEBUFFER,this.framebuffer)},ol.renderer.webgl.Layer.prototype.composeFrame=function(e,o,t){this.dispatchComposeEvent_(ol.render.Event.Type.PRECOMPOSE,t,e),t.bindBuffer(ol.webgl.ARRAY_BUFFER,this.arrayBuffer_);var r,i=t.getGL(),n=ol.renderer.webgl.defaultmapshader.fragment,l=ol.renderer.webgl.defaultmapshader.vertex,a=t.getProgram(n,l);this.defaultLocations_?r=this.defaultLocations_:(r=new ol.renderer.webgl.defaultmapshader.Locations(i,a),this.defaultLocations_=r),t.useProgram(a)&&(i.enableVertexAttribArray(r.a_position),i.vertexAttribPointer(r.a_position,2,ol.webgl.FLOAT,!1,16,0),i.enableVertexAttribArray(r.a_texCoord),i.vertexAttribPointer(r.a_texCoord,2,ol.webgl.FLOAT,!1,16,8),i.uniform1i(r.u_texture,0)),i.uniformMatrix4fv(r.u_texCoordMatrix,!1,ol.vec.Mat4.fromTransform(this.tmpMat4_,this.getTexCoordMatrix())),i.uniformMatrix4fv(r.u_projectionMatrix,!1,ol.vec.Mat4.fromTransform(this.tmpMat4_,this.getProjectionMatrix())),i.uniform1f(r.u_opacity,o.opacity),i.bindTexture(ol.webgl.TEXTURE_2D,this.getTexture()),i.drawArrays(ol.webgl.TRIANGLE_STRIP,0,4),this.dispatchComposeEvent_(ol.render.Event.Type.POSTCOMPOSE,t,e)},ol.renderer.webgl.Layer.prototype.dispatchComposeEvent_=function(e,o,t){var r=this.getLayer();if(r.hasListener(e)){var i=t.viewState,n=i.resolution,l=t.pixelRatio,a=t.extent,s=i.center,p=i.rotation,g=t.size,c=new ol.render.webgl.Immediate(o,s,n,p,g,a,l),u=new ol.render.Event(e,c,t,null,o);r.dispatchEvent(u)}},ol.renderer.webgl.Layer.prototype.getTexCoordMatrix=function(){return this.texCoordMatrix},ol.renderer.webgl.Layer.prototype.getTexture=function(){return this.texture},ol.renderer.webgl.Layer.prototype.getProjectionMatrix=function(){return this.projectionMatrix},ol.renderer.webgl.Layer.prototype.handleWebGLContextLost=function(){this.texture=null,this.framebuffer=null,this.framebufferDimension=void 0},ol.renderer.webgl.Layer.prototype.prepareFrame=function(e,o,t){},ol.renderer.webgl.Layer.prototype.forEachLayerAtPixel=function(e,o,t,r){},goog.provide("ol.ImageCanvas"),goog.require("ol"),goog.require("ol.Image"),goog.require("ol.ImageBase"),ol.ImageCanvas=function(e,o,t,r,i,n){this.loader_=void 0!==n?n:null;var l=void 0!==n?ol.Image.State.IDLE:ol.Image.State.LOADED;ol.ImageBase.call(this,e,o,t,l,r),this.canvas_=i,this.error_=null},ol.inherits(ol.ImageCanvas,ol.ImageBase),ol.ImageCanvas.prototype.getError=function(){return this.error_},ol.ImageCanvas.prototype.handleLoad_=function(e){e?(this.error_=e,this.state=ol.Image.State.ERROR):this.state=ol.Image.State.LOADED,this.changed()},ol.ImageCanvas.prototype.load=function(){this.state==ol.Image.State.IDLE&&(ol.DEBUG&&console.assert(this.loader_,"this.loader_ must be set"),this.state=ol.Image.State.LOADING,this.changed(),this.loader_(this.handleLoad_.bind(this)))},ol.ImageCanvas.prototype.getImage=function(e){return this.canvas_},goog.provide("ol.reproj"),goog.require("ol"),goog.require("ol.dom"),goog.require("ol.extent"),goog.require("ol.math"),goog.require("ol.proj"),ol.reproj.browserAntialiasesClip_=function(){var e=navigator.userAgent.indexOf("OPR")>-1,o=navigator.userAgent.indexOf("Edge")>-1;return!(!navigator.userAgent.match("CriOS")&&"chrome"in window&&"Google Inc."===navigator.vendor&&0==e&&0==o)}(),ol.reproj.calculateSourceResolution=function(e,o,t,r){var i=ol.proj.transform(t,o,e),n=ol.proj.getPointResolution(o,r,t),l=o.getMetersPerUnit();void 0!==l&&(n*=l);var a=e.getMetersPerUnit();void 0!==a&&(n/=a);var s=ol.proj.getPointResolution(e,n,i)/n;return isFinite(s)&&s>0&&(n/=s),n},ol.reproj.enlargeClipPoint_=function(e,o,t,r){var i=t-e,n=r-o,l=Math.sqrt(i*i+n*n);return[Math.round(t+i/l),Math.round(r+n/l)]},ol.reproj.render=function(e,o,t,r,i,n,l,a,s,p,g){var c=ol.dom.createCanvasContext2D(Math.round(t*e),Math.round(t*o));if(0===s.length)return c.canvas;c.scale(t,t);var u=ol.extent.createEmpty();s.forEach(function(e,o,t){ol.extent.extend(u,e.extent)});var y=ol.extent.getWidth(u),d=ol.extent.getHeight(u),h=ol.dom.createCanvasContext2D(Math.round(t*y/r),Math.round(t*d/r)),m=t/r;s.forEach(function(e,o,t){var r=e.extent[0]-u[0],i=-(e.extent[3]-u[3]),n=ol.extent.getWidth(e.extent),l=ol.extent.getHeight(e.extent);h.drawImage(e.image,p,p,e.image.width-2*p,e.image.height-2*p,r*m,i*m,n*m,l*m)});var f=ol.extent.getTopLeft(l);return a.getTriangles().forEach(function(e,o,i){var l=e.source,a=e.target,s=l[0][0],p=l[0][1],g=l[1][0],y=l[1][1],d=l[2][0],m=l[2][1],_=(a[0][0]-f[0])/n,E=-(a[0][1]-f[1])/n,v=(a[1][0]-f[0])/n,S=-(a[1][1]-f[1])/n,x=(a[2][0]-f[0])/n,P=-(a[2][1]-f[1])/n,T=s,R=p;s=0,p=0,g-=T,y-=R,d-=T,m-=R;var L=[[g,y,0,0,v-_],[d,m,0,0,x-_],[0,0,g,y,S-E],[0,0,d,m,P-E]],M=ol.math.solveLinearSystem(L);if(M){if(c.save(),c.beginPath(),ol.reproj.browserAntialiasesClip_){var C=(_+v+x)/3,I=(E+S+P)/3,b=ol.reproj.enlargeClipPoint_(C,I,_,E),O=ol.reproj.enlargeClipPoint_(C,I,v,S),A=ol.reproj.enlargeClipPoint_(C,I,x,P);c.moveTo(O[0],O[1]),c.lineTo(b[0],b[1]),c.lineTo(A[0],A[1])}else c.moveTo(v,S),c.lineTo(_,E),c.lineTo(x,P);c.clip(),c.transform(M[0],M[2],M[1],M[3],_,E),c.translate(u[0]-T,u[3]-R),c.scale(r/t,-r/t),c.drawImage(h.canvas,0,0),c.restore()}}),g&&(c.save(),c.strokeStyle="black",c.lineWidth=1,a.getTriangles().forEach(function(e,o,t){var r=e.target,i=(r[0][0]-f[0])/n,l=-(r[0][1]-f[1])/n,a=(r[1][0]-f[0])/n,s=-(r[1][1]-f[1])/n,p=(r[2][0]-f[0])/n,g=-(r[2][1]-f[1])/n;c.beginPath(),c.moveTo(a,s),c.lineTo(i,l),c.lineTo(p,g),c.closePath(),c.stroke()}),c.restore()),c.canvas},goog.provide("ol.reproj.Triangulation"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.math"),goog.require("ol.proj"),ol.reproj.Triangulation=function(e,o,t,r,i){this.sourceProj_=e,this.targetProj_=o;var n={},l=ol.proj.getTransform(this.targetProj_,this.sourceProj_);this.transformInv_=function(e){var o=e[0]+"/"+e[1];return n[o]||(n[o]=l(e)),n[o]},this.maxSourceExtent_=r,this.errorThresholdSquared_=i*i,this.triangles_=[],this.wrapsXInSource_=!1,this.canWrapXInSource_=this.sourceProj_.canWrapX()&&!!r&&!!this.sourceProj_.getExtent()&&ol.extent.getWidth(r)==ol.extent.getWidth(this.sourceProj_.getExtent()),this.sourceWorldWidth_=this.sourceProj_.getExtent()?ol.extent.getWidth(this.sourceProj_.getExtent()):null,this.targetWorldWidth_=this.targetProj_.getExtent()?ol.extent.getWidth(this.targetProj_.getExtent()):null;var a=ol.extent.getTopLeft(t),s=ol.extent.getTopRight(t),p=ol.extent.getBottomRight(t),g=ol.extent.getBottomLeft(t),c=this.transformInv_(a),u=this.transformInv_(s),y=this.transformInv_(p),d=this.transformInv_(g);if(this.addQuad_(a,s,p,g,c,u,y,d,ol.RASTER_REPROJECTION_MAX_SUBDIVISION),this.wrapsXInSource_){ol.DEBUG&&console.assert(null!==this.sourceWorldWidth_);var h=1/0;this.triangles_.forEach(function(e,o,t){h=Math.min(h,e.source[0][0],e.source[1][0],e.source[2][0])}),this.triangles_.forEach(function(e){if(Math.max(e.source[0][0],e.source[1][0],e.source[2][0])-h>this.sourceWorldWidth_/2){var o=[[e.source[0][0],e.source[0][1]],[e.source[1][0],e.source[1][1]],[e.source[2][0],e.source[2][1]]];o[0][0]-h>this.sourceWorldWidth_/2&&(o[0][0]-=this.sourceWorldWidth_),o[1][0]-h>this.sourceWorldWidth_/2&&(o[1][0]-=this.sourceWorldWidth_),o[2][0]-h>this.sourceWorldWidth_/2&&(o[2][0]-=this.sourceWorldWidth_);var t=Math.min(o[0][0],o[1][0],o[2][0]);Math.max(o[0][0],o[1][0],o[2][0])-t<this.sourceWorldWidth_/2&&(e.source=o)}},this)}n={}},ol.reproj.Triangulation.prototype.addTriangle_=function(e,o,t,r,i,n){this.triangles_.push({source:[r,i,n],target:[e,o,t]})},ol.reproj.Triangulation.prototype.addQuad_=function(e,o,t,r,i,n,l,a,s){var p=ol.extent.boundingExtent([i,n,l,a]),g=this.sourceWorldWidth_?ol.extent.getWidth(p)/this.sourceWorldWidth_:null,c=this.sourceWorldWidth_,u=this.sourceProj_.canWrapX()&&g>.5&&g<1,y=!1;if(s>0){if(this.targetProj_.isGlobal()&&this.targetWorldWidth_){var d=ol.extent.boundingExtent([e,o,t,r]);y|=ol.extent.getWidth(d)/this.targetWorldWidth_>ol.RASTER_REPROJECTION_MAX_TRIANGLE_WIDTH}!u&&this.sourceProj_.isGlobal()&&g&&(y|=g>ol.RASTER_REPROJECTION_MAX_TRIANGLE_WIDTH)}if(y||!this.maxSourceExtent_||ol.extent.intersects(p,this.maxSourceExtent_)){if(!(y||isFinite(i[0])&&isFinite(i[1])&&isFinite(n[0])&&isFinite(n[1])&&isFinite(l[0])&&isFinite(l[1])&&isFinite(a[0])&&isFinite(a[1]))){if(!(s>0))return;y=!0}if(s>0){if(!y){var h,m=[(e[0]+t[0])/2,(e[1]+t[1])/2],f=this.transformInv_(m);if(u){h=(ol.math.modulo(i[0],c)+ol.math.modulo(l[0],c))/2-ol.math.modulo(f[0],c)}else h=(i[0]+l[0])/2-f[0];var _=(i[1]+l[1])/2-f[1];y=h*h+_*_>this.errorThresholdSquared_}if(y){if(Math.abs(e[0]-t[0])<=Math.abs(e[1]-t[1])){var E=[(o[0]+t[0])/2,(o[1]+t[1])/2],v=this.transformInv_(E),S=[(r[0]+e[0])/2,(r[1]+e[1])/2],x=this.transformInv_(S);this.addQuad_(e,o,E,S,i,n,v,x,s-1),this.addQuad_(S,E,t,r,x,v,l,a,s-1)}else{var P=[(e[0]+o[0])/2,(e[1]+o[1])/2],T=this.transformInv_(P),R=[(t[0]+r[0])/2,(t[1]+r[1])/2],L=this.transformInv_(R);this.addQuad_(e,P,R,r,i,T,L,a,s-1),this.addQuad_(P,o,t,R,T,n,l,L,s-1)}return}}if(u){if(!this.canWrapXInSource_)return;this.wrapsXInSource_=!0}this.addTriangle_(e,t,r,i,l,a),this.addTriangle_(e,o,t,i,n,l)}},ol.reproj.Triangulation.prototype.calculateSourceExtent=function(){var e=ol.extent.createEmpty();return this.triangles_.forEach(function(o,t,r){var i=o.source;ol.extent.extendCoordinate(e,i[0]),ol.extent.extendCoordinate(e,i[1]),ol.extent.extendCoordinate(e,i[2])}),e},ol.reproj.Triangulation.prototype.getTriangles=function(){return this.triangles_},goog.provide("ol.reproj.Image"),goog.require("ol"),goog.require("ol.Image"),goog.require("ol.ImageBase"),goog.require("ol.events"),goog.require("ol.events.EventType");goog.require("ol.extent"),goog.require("ol.reproj"),goog.require("ol.reproj.Triangulation"),ol.reproj.Image=function(e,o,t,r,i,n){this.targetProj_=o,this.maxSourceExtent_=e.getExtent();var l=o.getExtent(),a=l?ol.extent.getIntersection(t,l):t,s=ol.extent.getCenter(a),p=ol.reproj.calculateSourceResolution(e,o,s,r),g=ol.DEFAULT_RASTER_REPROJECTION_ERROR_THRESHOLD;this.triangulation_=new ol.reproj.Triangulation(e,o,a,this.maxSourceExtent_,p*g),this.targetResolution_=r,this.targetExtent_=t;var c=this.triangulation_.calculateSourceExtent();this.sourceImage_=n(c,p,i),this.sourcePixelRatio_=this.sourceImage_?this.sourceImage_.getPixelRatio():1,this.canvas_=null,this.sourceListenerKey_=null;var u=ol.Image.State.LOADED,y=[];this.sourceImage_&&(u=ol.Image.State.IDLE,y=this.sourceImage_.getAttributions()),ol.ImageBase.call(this,t,r,this.sourcePixelRatio_,u,y)},ol.inherits(ol.reproj.Image,ol.ImageBase),ol.reproj.Image.prototype.disposeInternal=function(){this.state==ol.Image.State.LOADING&&this.unlistenSource_(),ol.ImageBase.prototype.disposeInternal.call(this)},ol.reproj.Image.prototype.getImage=function(e){return this.canvas_},ol.reproj.Image.prototype.getProjection=function(){return this.targetProj_},ol.reproj.Image.prototype.reproject_=function(){var e=this.sourceImage_.getState();if(e==ol.Image.State.LOADED){var o=ol.extent.getWidth(this.targetExtent_)/this.targetResolution_,t=ol.extent.getHeight(this.targetExtent_)/this.targetResolution_;this.canvas_=ol.reproj.render(o,t,this.sourcePixelRatio_,this.sourceImage_.getResolution(),this.maxSourceExtent_,this.targetResolution_,this.targetExtent_,this.triangulation_,[{extent:this.sourceImage_.getExtent(),image:this.sourceImage_.getImage()}],0)}this.state=e,this.changed()},ol.reproj.Image.prototype.load=function(){if(this.state==ol.Image.State.IDLE){this.state=ol.Image.State.LOADING,this.changed();var e=this.sourceImage_.getState();e==ol.Image.State.LOADED||e==ol.Image.State.ERROR?this.reproject_():(this.sourceListenerKey_=ol.events.listen(this.sourceImage_,ol.events.EventType.CHANGE,function(e){var o=this.sourceImage_.getState();o!=ol.Image.State.LOADED&&o!=ol.Image.State.ERROR||(this.unlistenSource_(),this.reproject_())},this),this.sourceImage_.load())}},ol.reproj.Image.prototype.unlistenSource_=function(){ol.DEBUG&&console.assert(this.sourceListenerKey_,"this.sourceListenerKey_ should not be null"),ol.events.unlistenByKey(this.sourceListenerKey_),this.sourceListenerKey_=null},goog.provide("ol.source.Source"),goog.require("ol"),goog.require("ol.Attribution"),goog.require("ol.Object"),goog.require("ol.proj"),goog.require("ol.source.State"),ol.source.Source=function(e){ol.Object.call(this),this.projection_=ol.proj.get(e.projection),this.attributions_=ol.source.Source.toAttributionsArray_(e.attributions),this.logo_=e.logo,this.state_=void 0!==e.state?e.state:ol.source.State.READY,this.wrapX_=void 0!==e.wrapX&&e.wrapX},ol.inherits(ol.source.Source,ol.Object),ol.source.Source.toAttributionsArray_=function(e){if("string"==typeof e)return[new ol.Attribution({html:e})];if(e instanceof ol.Attribution)return[e];if(Array.isArray(e)){for(var o=e.length,t=new Array(o),r=0;r<o;r++){var i=e[r];t[r]="string"==typeof i?new ol.Attribution({html:i}):i}return t}return null},ol.source.Source.prototype.forEachFeatureAtCoordinate=ol.nullFunction,ol.source.Source.prototype.getAttributions=function(){return this.attributions_},ol.source.Source.prototype.getLogo=function(){return this.logo_},ol.source.Source.prototype.getProjection=function(){return this.projection_},ol.source.Source.prototype.getResolutions=function(){},ol.source.Source.prototype.getState=function(){return this.state_},ol.source.Source.prototype.getWrapX=function(){return this.wrapX_},ol.source.Source.prototype.refresh=function(){this.changed()},ol.source.Source.prototype.setAttributions=function(e){this.attributions_=ol.source.Source.toAttributionsArray_(e),this.changed()},ol.source.Source.prototype.setLogo=function(e){this.logo_=e},ol.source.Source.prototype.setState=function(e){this.state_=e,this.changed()},goog.provide("ol.source.Image"),goog.require("ol"),goog.require("ol.Image"),goog.require("ol.array"),goog.require("ol.events.Event"),goog.require("ol.extent"),goog.require("ol.proj"),goog.require("ol.reproj.Image"),goog.require("ol.source.Source"),ol.source.Image=function(e){ol.source.Source.call(this,{attributions:e.attributions,extent:e.extent,logo:e.logo,projection:e.projection,state:e.state}),this.resolutions_=void 0!==e.resolutions?e.resolutions:null,ol.DEBUG&&console.assert(!this.resolutions_||ol.array.isSorted(this.resolutions_,function(e,o){return o-e},!0),"resolutions must be null or sorted in descending order"),this.reprojectedImage_=null,this.reprojectedRevision_=0},ol.inherits(ol.source.Image,ol.source.Source),ol.source.Image.prototype.getResolutions=function(){return this.resolutions_},ol.source.Image.prototype.findNearestResolution=function(e){if(this.resolutions_){var o=ol.array.linearFindNearest(this.resolutions_,e,0);e=this.resolutions_[o]}return e},ol.source.Image.prototype.getImage=function(e,o,t,r){var i=this.getProjection();if(ol.ENABLE_RASTER_REPROJECTION&&i&&r&&!ol.proj.equivalent(i,r)){if(this.reprojectedImage_){if(this.reprojectedRevision_==this.getRevision()&&ol.proj.equivalent(this.reprojectedImage_.getProjection(),r)&&this.reprojectedImage_.getResolution()==o&&this.reprojectedImage_.getPixelRatio()==t&&ol.extent.equals(this.reprojectedImage_.getExtent(),e))return this.reprojectedImage_;this.reprojectedImage_.dispose(),this.reprojectedImage_=null}return this.reprojectedImage_=new ol.reproj.Image(i,r,e,o,t,function(e,o,t){return this.getImageInternal(e,o,t,i)}.bind(this)),this.reprojectedRevision_=this.getRevision(),this.reprojectedImage_}return i&&(r=i),this.getImageInternal(e,o,t,r)},ol.source.Image.prototype.getImageInternal=function(e,o,t,r){},ol.source.Image.prototype.handleImageChange=function(e){var o=e.target;switch(o.getState()){case ol.Image.State.LOADING:this.dispatchEvent(new ol.source.Image.Event(ol.source.Image.EventType.IMAGELOADSTART,o));break;case ol.Image.State.LOADED:this.dispatchEvent(new ol.source.Image.Event(ol.source.Image.EventType.IMAGELOADEND,o));break;case ol.Image.State.ERROR:this.dispatchEvent(new ol.source.Image.Event(ol.source.Image.EventType.IMAGELOADERROR,o))}},ol.source.Image.defaultImageLoadFunction=function(e,o){e.getImage().src=o},ol.source.Image.Event=function(e,o){ol.events.Event.call(this,e),this.image=o},ol.inherits(ol.source.Image.Event,ol.events.Event),ol.source.Image.EventType={IMAGELOADSTART:"imageloadstart",IMAGELOADEND:"imageloadend",IMAGELOADERROR:"imageloaderror"},goog.provide("ol.source.ImageCanvas"),goog.require("ol"),goog.require("ol.ImageCanvas"),goog.require("ol.extent"),goog.require("ol.source.Image"),ol.source.ImageCanvas=function(e){ol.source.Image.call(this,{attributions:e.attributions,logo:e.logo,projection:e.projection,resolutions:e.resolutions,state:e.state}),this.canvasFunction_=e.canvasFunction,this.canvas_=null,this.renderedRevision_=0,this.ratio_=void 0!==e.ratio?e.ratio:1.5},ol.inherits(ol.source.ImageCanvas,ol.source.Image),ol.source.ImageCanvas.prototype.getImageInternal=function(e,o,t,r){o=this.findNearestResolution(o);var i=this.canvas_;if(i&&this.renderedRevision_==this.getRevision()&&i.getResolution()==o&&i.getPixelRatio()==t&&ol.extent.containsExtent(i.getExtent(),e))return i;e=e.slice(),ol.extent.scaleFromCenter(e,this.ratio_);var n=ol.extent.getWidth(e)/o,l=ol.extent.getHeight(e)/o,a=[n*t,l*t],s=this.canvasFunction_(e,o,t,a,r);return s&&(i=new ol.ImageCanvas(e,o,t,this.getAttributions(),s)),this.canvas_=i,this.renderedRevision_=this.getRevision(),i},goog.provide("ol.source.ImageVector"),goog.require("ol"),goog.require("ol.dom"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.render.canvas.ReplayGroup"),goog.require("ol.renderer.vector"),goog.require("ol.source.ImageCanvas"),goog.require("ol.style.Style"),goog.require("ol.transform"),ol.source.ImageVector=function(e){this.source_=e.source,this.transform_=ol.transform.create(),this.canvasContext_=ol.dom.createCanvasContext2D(),this.canvasSize_=[0,0],this.renderBuffer_=void 0==e.renderBuffer?100:e.renderBuffer,this.replayGroup_=null,ol.source.ImageCanvas.call(this,{attributions:e.attributions,canvasFunction:this.canvasFunctionInternal_.bind(this),logo:e.logo,projection:e.projection,ratio:e.ratio,resolutions:e.resolutions,state:this.source_.getState()}),this.style_=null,this.styleFunction_=void 0,this.setStyle(e.style),ol.events.listen(this.source_,ol.events.EventType.CHANGE,this.handleSourceChange_,this)},ol.inherits(ol.source.ImageVector,ol.source.ImageCanvas),ol.source.ImageVector.prototype.canvasFunctionInternal_=function(e,o,t,r,i){var n=new ol.render.canvas.ReplayGroup(ol.renderer.vector.getTolerance(o,t),e,o,this.source_.getOverlaps(),this.renderBuffer_);this.source_.loadFeatures(e,o,i);var l=!1;if(this.source_.forEachFeatureInExtent(e,function(e){l=l||this.renderFeature_(e,o,t,n)},this),n.finish(),l)return null;this.canvasSize_[0]!=r[0]||this.canvasSize_[1]!=r[1]?(this.canvasContext_.canvas.width=r[0],this.canvasContext_.canvas.height=r[1],this.canvasSize_[0]=r[0],this.canvasSize_[1]=r[1]):this.canvasContext_.clearRect(0,0,r[0],r[1]);var a=this.getTransform_(ol.extent.getCenter(e),o,t,r);return n.replay(this.canvasContext_,t,a,0,{}),this.replayGroup_=n,this.canvasContext_.canvas},ol.source.ImageVector.prototype.forEachFeatureAtCoordinate=function(e,o,t,r,i,n){if(this.replayGroup_){var l={};return this.replayGroup_.forEachFeatureAtCoordinate(e,o,0,r,i,function(e){var o=ol.getUid(e).toString();if(!(o in l))return l[o]=!0,n(e)})}},ol.source.ImageVector.prototype.getSource=function(){return this.source_},ol.source.ImageVector.prototype.getStyle=function(){return this.style_},ol.source.ImageVector.prototype.getStyleFunction=function(){return this.styleFunction_},ol.source.ImageVector.prototype.getTransform_=function(e,o,t,r){var i=r[0]/2,n=r[1]/2,l=t/o,a=-l,s=-e[0],p=-e[1];return ol.transform.compose(this.transform_,i,n,l,a,0,s,p)},ol.source.ImageVector.prototype.handleImageChange_=function(e){this.changed()},ol.source.ImageVector.prototype.handleSourceChange_=function(){this.setState(this.source_.getState())},ol.source.ImageVector.prototype.renderFeature_=function(e,o,t,r){var i,n=e.getStyleFunction();if(n?i=n.call(e,o):this.styleFunction_&&(i=this.styleFunction_(e,o)),!i)return!1;var l,a,s=!1;for(Array.isArray(i)||(i=[i]),l=0,a=i.length;l<a;++l)s=ol.renderer.vector.renderFeature(r,e,i[l],ol.renderer.vector.getSquaredTolerance(o,t),this.handleImageChange_,this)||s;return s},ol.source.ImageVector.prototype.setStyle=function(e){this.style_=void 0!==e?e:ol.style.Style.defaultFunction,this.styleFunction_=e?ol.style.Style.createFunction(this.style_):void 0,this.changed()},goog.provide("ol.renderer.webgl.ImageLayer"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.dom"),goog.require("ol.extent"),goog.require("ol.functions"),goog.require("ol.proj"),goog.require("ol.renderer.webgl.Layer"),goog.require("ol.source.ImageVector"),goog.require("ol.transform"),goog.require("ol.webgl"),goog.require("ol.webgl.Context"),ol.renderer.webgl.ImageLayer=function(e,o){ol.renderer.webgl.Layer.call(this,e,o),this.image_=null,this.hitCanvasContext_=null,this.hitTransformationMatrix_=null},ol.inherits(ol.renderer.webgl.ImageLayer,ol.renderer.webgl.Layer),ol.renderer.webgl.ImageLayer.prototype.createTexture_=function(e){var o=e.getImage(),t=this.mapRenderer.getGL();return ol.webgl.Context.createTexture(t,o,ol.webgl.CLAMP_TO_EDGE,ol.webgl.CLAMP_TO_EDGE)},ol.renderer.webgl.ImageLayer.prototype.forEachFeatureAtCoordinate=function(e,o,t,r,i){var n=this.getLayer(),l=n.getSource(),a=o.viewState.resolution,s=o.viewState.rotation,p=o.skippedFeatureUids;return l.forEachFeatureAtCoordinate(e,a,s,t,p,function(e){return r.call(i,e,n)})},ol.renderer.webgl.ImageLayer.prototype.prepareFrame=function(e,o,t){var r=this.mapRenderer.getGL(),i=e.pixelRatio,n=e.viewState,l=n.center,a=n.resolution,s=n.rotation,p=this.image_,g=this.texture,c=this.getLayer(),u=c.getSource(),y=e.viewHints,d=e.extent;if(void 0!==o.extent&&(d=ol.extent.getIntersection(d,o.extent)),!y[ol.View.Hint.ANIMATING]&&!y[ol.View.Hint.INTERACTING]&&!ol.extent.isEmpty(d)){var h=n.projection;if(!ol.ENABLE_RASTER_REPROJECTION){var m=u.getProjection();m&&(ol.DEBUG&&console.assert(ol.proj.equivalent(h,m),"projection and sourceProjection are equivalent"),h=m)}var f=u.getImage(d,a,i,h);if(f){if(this.loadImage(f)&&(p=f,g=this.createTexture_(f),this.texture)){var _=function(e,o){e.isContextLost()||e.deleteTexture(o)}.bind(null,r,this.texture);e.postRenderFunctions.push(_)}}}if(p){ol.DEBUG&&console.assert(g,"texture is truthy");var E=this.mapRenderer.getContext().getCanvas();this.updateProjectionMatrix_(E.width,E.height,i,l,a,s,p.getExtent()),this.hitTransformationMatrix_=null;var v=this.texCoordMatrix;ol.transform.reset(v),ol.transform.scale(v,1,-1),ol.transform.translate(v,0,-1),this.image_=p,this.texture=g,this.updateAttributions(e.attributions,p.getAttributions()),this.updateLogos(e,u)}return!!p},ol.renderer.webgl.ImageLayer.prototype.updateProjectionMatrix_=function(e,o,t,r,i,n,l){var a=e*i,s=o*i,p=this.projectionMatrix;ol.transform.reset(p),ol.transform.scale(p,2*t/a,2*t/s),ol.transform.rotate(p,-n),ol.transform.translate(p,l[0]-r[0],l[1]-r[1]),ol.transform.scale(p,(l[2]-l[0])/2,(l[3]-l[1])/2),ol.transform.translate(p,1,1)},ol.renderer.webgl.ImageLayer.prototype.hasFeatureAtCoordinate=function(e,o){return void 0!==this.forEachFeatureAtCoordinate(e,o,0,ol.functions.TRUE,this)},ol.renderer.webgl.ImageLayer.prototype.forEachLayerAtPixel=function(e,o,t,r){if(this.image_&&this.image_.getImage()){if(this.getLayer().getSource()instanceof ol.source.ImageVector){var i=ol.transform.apply(o.pixelToCoordinateTransform,e.slice());return this.forEachFeatureAtCoordinate(i,o,0,ol.functions.TRUE,this)?t.call(r,this.getLayer(),null):void 0}var n=[this.image_.getImage().width,this.image_.getImage().height];this.hitTransformationMatrix_||(this.hitTransformationMatrix_=this.getHitTransformationMatrix_(o.size,n));var l=ol.transform.apply(this.hitTransformationMatrix_,e.slice());if(!(l[0]<0||l[0]>n[0]||l[1]<0||l[1]>n[1])){this.hitCanvasContext_||(this.hitCanvasContext_=ol.dom.createCanvasContext2D(1,1)),this.hitCanvasContext_.clearRect(0,0,1,1),this.hitCanvasContext_.drawImage(this.image_.getImage(),l[0],l[1],1,1,0,0,1,1);var a=this.hitCanvasContext_.getImageData(0,0,1,1).data;return a[3]>0?t.call(r,this.getLayer(),a):void 0}}},ol.renderer.webgl.ImageLayer.prototype.getHitTransformationMatrix_=function(e,o){var t=ol.transform.create();ol.transform.translate(t,-1,-1),ol.transform.scale(t,2/e[0],2/e[1]),ol.transform.translate(t,0,e[1]),ol.transform.scale(t,1,-1);var r=ol.transform.invert(this.projectionMatrix.slice()),i=ol.transform.create();return ol.transform.translate(i,0,o[1]),ol.transform.scale(i,1,-1),ol.transform.scale(i,o[0]/2,o[1]/2),ol.transform.translate(i,1,1),ol.transform.multiply(i,r),ol.transform.multiply(i,t),i},goog.provide("ol.renderer.webgl.tilelayershader"),goog.require("ol"),goog.require("ol.webgl.Fragment"),goog.require("ol.webgl.Vertex"),ol.renderer.webgl.tilelayershader.Fragment=function(){ol.webgl.Fragment.call(this,ol.renderer.webgl.tilelayershader.Fragment.SOURCE)},ol.inherits(ol.renderer.webgl.tilelayershader.Fragment,ol.webgl.Fragment),ol.renderer.webgl.tilelayershader.Fragment.DEBUG_SOURCE="precision mediump float;\nvarying vec2 v_texCoord;\n\n\nuniform sampler2D u_texture;\n\nvoid main(void) {\n  gl_FragColor = texture2D(u_texture, v_texCoord);\n}\n",ol.renderer.webgl.tilelayershader.Fragment.OPTIMIZED_SOURCE="precision mediump float;varying vec2 a;uniform sampler2D e;void main(void){gl_FragColor=texture2D(e,a);}",ol.renderer.webgl.tilelayershader.Fragment.SOURCE=ol.DEBUG?ol.renderer.webgl.tilelayershader.Fragment.DEBUG_SOURCE:ol.renderer.webgl.tilelayershader.Fragment.OPTIMIZED_SOURCE,ol.renderer.webgl.tilelayershader.fragment=new ol.renderer.webgl.tilelayershader.Fragment,ol.renderer.webgl.tilelayershader.Vertex=function(){ol.webgl.Vertex.call(this,ol.renderer.webgl.tilelayershader.Vertex.SOURCE)},ol.inherits(ol.renderer.webgl.tilelayershader.Vertex,ol.webgl.Vertex),ol.renderer.webgl.tilelayershader.Vertex.DEBUG_SOURCE="varying vec2 v_texCoord;\n\n\nattribute vec2 a_position;\nattribute vec2 a_texCoord;\nuniform vec4 u_tileOffset;\n\nvoid main(void) {\n  gl_Position = vec4(a_position * u_tileOffset.xy + u_tileOffset.zw, 0., 1.);\n  v_texCoord = a_texCoord;\n}\n\n\n",ol.renderer.webgl.tilelayershader.Vertex.OPTIMIZED_SOURCE="varying vec2 a;attribute vec2 b;attribute vec2 c;uniform vec4 d;void main(void){gl_Position=vec4(b*d.xy+d.zw,0.,1.);a=c;}",
ol.renderer.webgl.tilelayershader.Vertex.SOURCE=ol.DEBUG?ol.renderer.webgl.tilelayershader.Vertex.DEBUG_SOURCE:ol.renderer.webgl.tilelayershader.Vertex.OPTIMIZED_SOURCE,ol.renderer.webgl.tilelayershader.vertex=new ol.renderer.webgl.tilelayershader.Vertex,ol.renderer.webgl.tilelayershader.Locations=function(e,o){this.u_texture=e.getUniformLocation(o,ol.DEBUG?"u_texture":"e"),this.u_tileOffset=e.getUniformLocation(o,ol.DEBUG?"u_tileOffset":"d"),this.a_position=e.getAttribLocation(o,ol.DEBUG?"a_position":"b"),this.a_texCoord=e.getAttribLocation(o,ol.DEBUG?"a_texCoord":"c")},goog.provide("ol.renderer.webgl.TileLayer"),goog.require("ol"),goog.require("ol.Tile"),goog.require("ol.TileRange"),goog.require("ol.array"),goog.require("ol.extent"),goog.require("ol.math"),goog.require("ol.renderer.webgl.Layer"),goog.require("ol.renderer.webgl.tilelayershader"),goog.require("ol.size"),goog.require("ol.transform"),goog.require("ol.webgl"),goog.require("ol.webgl.Buffer"),ol.renderer.webgl.TileLayer=function(e,o){ol.renderer.webgl.Layer.call(this,e,o),this.fragmentShader_=ol.renderer.webgl.tilelayershader.fragment,this.vertexShader_=ol.renderer.webgl.tilelayershader.vertex,this.locations_=null,this.renderArrayBuffer_=new ol.webgl.Buffer([0,0,0,1,1,0,1,1,0,1,0,0,1,1,1,0]),this.renderedTileRange_=null,this.renderedFramebufferExtent_=null,this.renderedRevision_=-1,this.tmpSize_=[0,0]},ol.inherits(ol.renderer.webgl.TileLayer,ol.renderer.webgl.Layer),ol.renderer.webgl.TileLayer.prototype.disposeInternal=function(){this.mapRenderer.getContext().deleteBuffer(this.renderArrayBuffer_),ol.renderer.webgl.Layer.prototype.disposeInternal.call(this)},ol.renderer.webgl.TileLayer.prototype.createLoadedTileFinder=function(e,o,t){var r=this.mapRenderer;return function(i,n){function l(e){var o=r.isTileTextureLoaded(e);return o&&(t[i]||(t[i]={}),t[i][e.tileCoord.toString()]=e),o}return e.forEachLoadedTile(o,i,n,l)}},ol.renderer.webgl.TileLayer.prototype.handleWebGLContextLost=function(){ol.renderer.webgl.Layer.prototype.handleWebGLContextLost.call(this),this.locations_=null},ol.renderer.webgl.TileLayer.prototype.prepareFrame=function(e,o,t){var r,i=this.mapRenderer,n=t.getGL(),l=e.viewState,a=l.projection,s=this.getLayer(),p=s.getSource(),g=p.getTileGridForProjection(a),c=g.getZForResolution(l.resolution),u=g.getResolution(c),y=p.getTilePixelSize(c,e.pixelRatio,a),d=y[0]/ol.size.toSize(g.getTileSize(c),this.tmpSize_)[0],h=u/d,m=p.getTilePixelRatio(d)*p.getGutter(a),f=l.center,_=e.extent,E=g.getTileRangeForExtentAndResolution(_,u);if(this.renderedTileRange_&&this.renderedTileRange_.equals(E)&&this.renderedRevision_==p.getRevision())r=this.renderedFramebufferExtent_;else{var v=E.getSize(),S=Math.max(v[0]*y[0],v[1]*y[1]),x=ol.math.roundUpToPowerOfTwo(S),P=h*x,T=g.getOrigin(c),R=T[0]+E.minX*y[0]*h,L=T[1]+E.minY*y[1]*h;r=[R,L,R+P,L+P],this.bindFramebuffer(e,x),n.viewport(0,0,x,x),n.clearColor(0,0,0,0),n.clear(ol.webgl.COLOR_BUFFER_BIT),n.disable(ol.webgl.BLEND);var M=t.getProgram(this.fragmentShader_,this.vertexShader_);t.useProgram(M),this.locations_||(this.locations_=new ol.renderer.webgl.tilelayershader.Locations(n,M)),t.bindBuffer(ol.webgl.ARRAY_BUFFER,this.renderArrayBuffer_),n.enableVertexAttribArray(this.locations_.a_position),n.vertexAttribPointer(this.locations_.a_position,2,ol.webgl.FLOAT,!1,16,0),n.enableVertexAttribArray(this.locations_.a_texCoord),n.vertexAttribPointer(this.locations_.a_texCoord,2,ol.webgl.FLOAT,!1,16,8),n.uniform1i(this.locations_.u_texture,0);var C={};C[c]={};var I,b,O,A,N,G,D,w,F=this.createLoadedTileFinder(p,a,C),U=s.getUseInterimTilesOnError(),B=!0,q=ol.extent.createEmpty(),k=new ol.TileRange(0,0,0,0);for(G=E.minX;G<=E.maxX;++G)for(D=E.minY;D<=E.maxY;++D)if(A=p.getTile(c,G,D,d,a),void 0===o.extent||(w=g.getTileCoordExtent(A.tileCoord,q),ol.extent.intersects(w,o.extent))){if(N=A.getState(),b=N==ol.Tile.State.LOADED||N==ol.Tile.State.EMPTY||N==ol.Tile.State.ERROR&&!U,b||(A=A.getInterimTile()),(N=A.getState())==ol.Tile.State.LOADED){if(i.isTileTextureLoaded(A)){C[c][A.tileCoord.toString()]=A;continue}}else if(N==ol.Tile.State.EMPTY||N==ol.Tile.State.ERROR&&!U)continue;B=!1,O=g.forEachTileCoordParentTileRange(A.tileCoord,F,null,k,q),O||(I=g.getTileCoordChildTileRange(A.tileCoord,k,q))&&F(c+1,I)}var j=Object.keys(C).map(Number);j.sort(ol.array.numberSafeCompareFunction);var W,V,K,X,Y=new Float32Array(4);for(W=0,V=j.length;W<V;++W){X=C[j[W]];for(K in X)A=X[K],w=g.getTileCoordExtent(A.tileCoord,q),Y[0]=2*(w[2]-w[0])/P,Y[1]=2*(w[3]-w[1])/P,Y[2]=2*(w[0]-r[0])/P-1,Y[3]=2*(w[1]-r[1])/P-1,n.uniform4fv(this.locations_.u_tileOffset,Y),i.bindTileTexture(A,y,m*d,ol.webgl.LINEAR,ol.webgl.LINEAR),n.drawArrays(ol.webgl.TRIANGLE_STRIP,0,4)}B?(this.renderedTileRange_=E,this.renderedFramebufferExtent_=r,this.renderedRevision_=p.getRevision()):(this.renderedTileRange_=null,this.renderedFramebufferExtent_=null,this.renderedRevision_=-1,e.animate=!0)}this.updateUsedTiles(e.usedTiles,p,c,E);var Z=i.getTileTextureQueue();this.manageTilePyramid(e,p,g,d,a,_,c,s.getPreload(),function(e){e.getState()!=ol.Tile.State.LOADED||i.isTileTextureLoaded(e)||Z.isKeyQueued(e.getKey())||Z.enqueue([e,g.getTileCoordCenter(e.tileCoord),g.getResolution(e.tileCoord[0]),y,m*d])},this),this.scheduleExpireCache(e,p),this.updateLogos(e,p);var H=this.texCoordMatrix;return ol.transform.reset(H),ol.transform.translate(H,(Math.round(f[0]/u)*u-r[0])/(r[2]-r[0]),(Math.round(f[1]/u)*u-r[1])/(r[3]-r[1])),0!==l.rotation&&ol.transform.rotate(H,l.rotation),ol.transform.scale(H,e.size[0]*l.resolution/(r[2]-r[0]),e.size[1]*l.resolution/(r[3]-r[1])),ol.transform.translate(H,-.5,-.5),!0},ol.renderer.webgl.TileLayer.prototype.forEachLayerAtPixel=function(e,o,t,r){if(this.framebuffer){var i=[e[0]/o.size[0],(o.size[1]-e[1])/o.size[1]],n=ol.transform.apply(this.texCoordMatrix,i.slice()),l=[n[0]*this.framebufferDimension,n[1]*this.framebufferDimension],a=this.mapRenderer.getContext().getGL();a.bindFramebuffer(a.FRAMEBUFFER,this.framebuffer);var s=new Uint8Array(4);return a.readPixels(l[0],l[1],1,1,a.RGBA,a.UNSIGNED_BYTE,s),s[3]>0?t.call(r,this.getLayer(),s):void 0}},goog.provide("ol.renderer.webgl.VectorLayer"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.extent"),goog.require("ol.render.webgl.ReplayGroup"),goog.require("ol.renderer.vector"),goog.require("ol.renderer.webgl.Layer"),goog.require("ol.transform"),ol.renderer.webgl.VectorLayer=function(e,o){ol.renderer.webgl.Layer.call(this,e,o),this.dirty_=!1,this.renderedRevision_=-1,this.renderedResolution_=NaN,this.renderedExtent_=ol.extent.createEmpty(),this.renderedRenderOrder_=null,this.replayGroup_=null,this.layerState_=null},ol.inherits(ol.renderer.webgl.VectorLayer,ol.renderer.webgl.Layer),ol.renderer.webgl.VectorLayer.prototype.composeFrame=function(e,o,t){this.layerState_=o;var r=e.viewState,i=this.replayGroup_,n=e.size,l=e.pixelRatio,a=this.mapRenderer.getGL();i&&!i.isEmpty()&&(a.enable(a.SCISSOR_TEST),a.scissor(0,0,n[0]*l,n[1]*l),i.replay(t,r.center,r.resolution,r.rotation,n,l,o.opacity,o.managed?e.skippedFeatureUids:{}),a.disable(a.SCISSOR_TEST))},ol.renderer.webgl.VectorLayer.prototype.disposeInternal=function(){var e=this.replayGroup_;if(e){var o=this.mapRenderer.getContext();e.getDeleteResourcesFunction(o)(),this.replayGroup_=null}ol.renderer.webgl.Layer.prototype.disposeInternal.call(this)},ol.renderer.webgl.VectorLayer.prototype.forEachFeatureAtCoordinate=function(e,o,t,r,i){if(this.replayGroup_&&this.layerState_){var n=this.mapRenderer.getContext(),l=o.viewState,a=this.getLayer(),s=this.layerState_,p={};return this.replayGroup_.forEachFeatureAtCoordinate(e,n,l.center,l.resolution,l.rotation,o.size,o.pixelRatio,s.opacity,{},function(e){var o=ol.getUid(e).toString();if(!(o in p))return p[o]=!0,r.call(i,e,a)})}},ol.renderer.webgl.VectorLayer.prototype.hasFeatureAtCoordinate=function(e,o){if(this.replayGroup_&&this.layerState_){var t=this.mapRenderer.getContext(),r=o.viewState,i=this.layerState_;return this.replayGroup_.hasFeatureAtCoordinate(e,t,r.center,r.resolution,r.rotation,o.size,o.pixelRatio,i.opacity,o.skippedFeatureUids)}return!1},ol.renderer.webgl.VectorLayer.prototype.forEachLayerAtPixel=function(e,o,t,r){var i=ol.transform.apply(o.pixelToCoordinateTransform,e.slice());return this.hasFeatureAtCoordinate(i,o)?t.call(r,this.getLayer(),null):void 0},ol.renderer.webgl.VectorLayer.prototype.handleStyleImageChange_=function(e){this.renderIfReadyAndVisible()},ol.renderer.webgl.VectorLayer.prototype.prepareFrame=function(e,o,t){var r=this.getLayer(),i=r.getSource();this.updateAttributions(e.attributions,i.getAttributions()),this.updateLogos(e,i);var n=e.viewHints[ol.View.Hint.ANIMATING],l=e.viewHints[ol.View.Hint.INTERACTING],a=r.getUpdateWhileAnimating(),s=r.getUpdateWhileInteracting();if(!this.dirty_&&!a&&n||!s&&l)return!0;var p=e.extent,g=e.viewState,c=g.projection,u=g.resolution,y=e.pixelRatio,d=r.getRevision(),h=r.getRenderBuffer(),m=r.getRenderOrder();void 0===m&&(m=ol.renderer.vector.defaultOrder);var f=ol.extent.buffer(p,h*u);if(!this.dirty_&&this.renderedResolution_==u&&this.renderedRevision_==d&&this.renderedRenderOrder_==m&&ol.extent.containsExtent(this.renderedExtent_,f))return!0;this.replayGroup_&&e.postRenderFunctions.push(this.replayGroup_.getDeleteResourcesFunction(t)),this.dirty_=!1;var _=new ol.render.webgl.ReplayGroup(ol.renderer.vector.getTolerance(u,y),f,r.getRenderBuffer());i.loadFeatures(f,u,c);var E=function(e){var o,t=e.getStyleFunction();if(t?o=t.call(e,u):(t=r.getStyleFunction())&&(o=t(e,u)),o){var i=this.renderFeature(e,u,y,o,_);this.dirty_=this.dirty_||i}};if(m){var v=[];i.forEachFeatureInExtent(f,function(e){v.push(e)},this),v.sort(m),v.forEach(E,this)}else i.forEachFeatureInExtent(f,E,this);return _.finish(t),this.renderedResolution_=u,this.renderedRevision_=d,this.renderedRenderOrder_=m,this.renderedExtent_=f,this.replayGroup_=_,!0},ol.renderer.webgl.VectorLayer.prototype.renderFeature=function(e,o,t,r,i){if(!r)return!1;var n=!1;if(Array.isArray(r))for(var l=r.length-1;l>=0;--l)n=ol.renderer.vector.renderFeature(i,e,r[l],ol.renderer.vector.getSquaredTolerance(o,t),this.handleStyleImageChange_,this)||n;else n=ol.renderer.vector.renderFeature(i,e,r,ol.renderer.vector.getSquaredTolerance(o,t),this.handleStyleImageChange_,this)||n;return n},goog.provide("ol.structs.LRUCache"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.obj"),ol.structs.LRUCache=function(){this.count_=0,this.entries_={},this.oldest_=null,this.newest_=null},ol.DEBUG&&(ol.structs.LRUCache.prototype.assertValid=function(){if(0===this.count_)console.assert(ol.obj.isEmpty(this.entries_),"entries must be an empty object (count = 0)"),console.assert(!this.oldest_,"oldest must be null (count = 0)"),console.assert(!this.newest_,"newest must be null (count = 0)");else{console.assert(Object.keys(this.entries_).length==this.count_,"number of entries matches count"),console.assert(this.oldest_,"we have an oldest entry"),console.assert(!this.oldest_.older,"no entry is older than oldest"),console.assert(this.newest_,"we have a newest entry"),console.assert(!this.newest_.newer,"no entry is newer than newest");var e,o,t=null;for(e=0,o=this.oldest_;o;o=o.newer)console.assert(o.older===t,"entry.older links to correct older"),t=o,++e;console.assert(e==this.count_,"iterated correct amount of times");var r=null;for(e=0,o=this.newest_;o;o=o.older)console.assert(o.newer===r,"entry.newer links to correct newer"),r=o,++e;console.assert(e==this.count_,"iterated correct amount of times")}}),ol.structs.LRUCache.prototype.clear=function(){this.count_=0,this.entries_={},this.oldest_=null,this.newest_=null},ol.structs.LRUCache.prototype.containsKey=function(e){return this.entries_.hasOwnProperty(e)},ol.structs.LRUCache.prototype.forEach=function(e,o){for(var t=this.oldest_;t;)e.call(o,t.value_,t.key_,this),t=t.newer},ol.structs.LRUCache.prototype.get=function(e){var o=this.entries_[e];return ol.asserts.assert(void 0!==o,15),o===this.newest_?o.value_:(o===this.oldest_?(this.oldest_=this.oldest_.newer,this.oldest_.older=null):(o.newer.older=o.older,o.older.newer=o.newer),o.newer=null,o.older=this.newest_,this.newest_.newer=o,this.newest_=o,o.value_)},ol.structs.LRUCache.prototype.getCount=function(){return this.count_},ol.structs.LRUCache.prototype.getKeys=function(){var e,o=new Array(this.count_),t=0;for(e=this.newest_;e;e=e.older)o[t++]=e.key_;return ol.DEBUG&&console.assert(t==this.count_,"iterated correct number of times"),o},ol.structs.LRUCache.prototype.getValues=function(){var e,o=new Array(this.count_),t=0;for(e=this.newest_;e;e=e.older)o[t++]=e.value_;return ol.DEBUG&&console.assert(t==this.count_,"iterated correct number of times"),o},ol.structs.LRUCache.prototype.peekLast=function(){return ol.DEBUG&&console.assert(this.oldest_,"oldest must not be null"),this.oldest_.value_},ol.structs.LRUCache.prototype.peekLastKey=function(){return ol.DEBUG&&console.assert(this.oldest_,"oldest must not be null"),this.oldest_.key_},ol.structs.LRUCache.prototype.pop=function(){ol.DEBUG&&console.assert(this.oldest_,"oldest must not be null"),ol.DEBUG&&console.assert(this.newest_,"newest must not be null");var e=this.oldest_;return ol.DEBUG&&console.assert(e.key_ in this.entries_,"oldest is indexed in entries"),delete this.entries_[e.key_],e.newer&&(e.newer.older=null),this.oldest_=e.newer,this.oldest_||(this.newest_=null),--this.count_,e.value_},ol.structs.LRUCache.prototype.replace=function(e,o){this.get(e),this.entries_[e].value_=o},ol.structs.LRUCache.prototype.set=function(e,o){ol.DEBUG&&console.assert(!(e in{}),'key is not a standard property of objects (e.g. "__proto__")'),ol.asserts.assert(!(e in this.entries_),16);var t={key_:e,newer:null,older:this.newest_,value_:o};this.newest_?this.newest_.newer=t:this.oldest_=t,this.newest_=t,this.entries_[e]=t,++this.count_},goog.provide("ol.renderer.webgl.Map"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.css"),goog.require("ol.dom"),goog.require("ol.events"),goog.require("ol.layer.Image"),goog.require("ol.layer.Layer"),goog.require("ol.layer.Tile"),goog.require("ol.layer.Vector"),goog.require("ol.render.Event"),goog.require("ol.render.webgl.Immediate"),goog.require("ol.renderer.Map"),goog.require("ol.renderer.Type"),goog.require("ol.renderer.webgl.ImageLayer"),goog.require("ol.renderer.webgl.TileLayer"),goog.require("ol.renderer.webgl.VectorLayer"),goog.require("ol.source.State"),goog.require("ol.structs.LRUCache"),goog.require("ol.structs.PriorityQueue"),goog.require("ol.webgl"),goog.require("ol.webgl.Context"),goog.require("ol.webgl.ContextEventType"),ol.renderer.webgl.Map=function(e,o){ol.renderer.Map.call(this,e,o),this.canvas_=document.createElement("CANVAS"),this.canvas_.style.width="100%",this.canvas_.style.height="100%",this.canvas_.className=ol.css.CLASS_UNSELECTABLE,e.insertBefore(this.canvas_,e.childNodes[0]||null),this.clipTileCanvasWidth_=0,this.clipTileCanvasHeight_=0,this.clipTileContext_=ol.dom.createCanvasContext2D(),this.renderedVisible_=!0,this.gl_=ol.webgl.getContext(this.canvas_,{antialias:!0,depth:!0,failIfMajorPerformanceCaveat:!0,preserveDrawingBuffer:!1,stencil:!0}),ol.DEBUG&&console.assert(this.gl_,"got a WebGLRenderingContext"),this.context_=new ol.webgl.Context(this.canvas_,this.gl_),ol.events.listen(this.canvas_,ol.webgl.ContextEventType.LOST,this.handleWebGLContextLost,this),ol.events.listen(this.canvas_,ol.webgl.ContextEventType.RESTORED,this.handleWebGLContextRestored,this),this.textureCache_=new ol.structs.LRUCache,this.focus_=null,this.tileTextureQueue_=new ol.structs.PriorityQueue(function(e){var o=e[1],t=e[2],r=o[0]-this.focus_[0],i=o[1]-this.focus_[1];return 65536*Math.log(t)+Math.sqrt(r*r+i*i)/t}.bind(this),function(e){return e[0].getKey()}),this.loadNextTileTexture_=function(e,o){if(!this.tileTextureQueue_.isEmpty()){this.tileTextureQueue_.reprioritize();var t=this.tileTextureQueue_.dequeue(),r=t[0],i=t[3],n=t[4];this.bindTileTexture(r,i,n,ol.webgl.LINEAR,ol.webgl.LINEAR)}return!1}.bind(this),this.textureCacheFrameMarkerCount_=0,this.initializeGL_()};ol.inherits(ol.renderer.webgl.Map,ol.renderer.Map),ol.renderer.webgl.Map.prototype.bindTileTexture=function(e,o,t,r,i){var n=this.getGL(),l=e.getKey();if(this.textureCache_.containsKey(l)){var a=this.textureCache_.get(l);n.bindTexture(ol.webgl.TEXTURE_2D,a.texture),a.magFilter!=r&&(n.texParameteri(ol.webgl.TEXTURE_2D,ol.webgl.TEXTURE_MAG_FILTER,r),a.magFilter=r),a.minFilter!=i&&(n.texParameteri(ol.webgl.TEXTURE_2D,ol.webgl.TEXTURE_MIN_FILTER,i),a.minFilter=i)}else{var s=n.createTexture();if(n.bindTexture(ol.webgl.TEXTURE_2D,s),t>0){var p=this.clipTileContext_.canvas,g=this.clipTileContext_;this.clipTileCanvasWidth_!==o[0]||this.clipTileCanvasHeight_!==o[1]?(p.width=o[0],p.height=o[1],this.clipTileCanvasWidth_=o[0],this.clipTileCanvasHeight_=o[1]):g.clearRect(0,0,o[0],o[1]),g.drawImage(e.getImage(),t,t,o[0],o[1],0,0,o[0],o[1]),n.texImage2D(ol.webgl.TEXTURE_2D,0,ol.webgl.RGBA,ol.webgl.RGBA,ol.webgl.UNSIGNED_BYTE,p)}else n.texImage2D(ol.webgl.TEXTURE_2D,0,ol.webgl.RGBA,ol.webgl.RGBA,ol.webgl.UNSIGNED_BYTE,e.getImage());n.texParameteri(ol.webgl.TEXTURE_2D,ol.webgl.TEXTURE_MAG_FILTER,r),n.texParameteri(ol.webgl.TEXTURE_2D,ol.webgl.TEXTURE_MIN_FILTER,i),n.texParameteri(ol.webgl.TEXTURE_2D,ol.webgl.TEXTURE_WRAP_S,ol.webgl.CLAMP_TO_EDGE),n.texParameteri(ol.webgl.TEXTURE_2D,ol.webgl.TEXTURE_WRAP_T,ol.webgl.CLAMP_TO_EDGE),this.textureCache_.set(l,{texture:s,magFilter:r,minFilter:i})}},ol.renderer.webgl.Map.prototype.createLayerRenderer=function(e){return ol.ENABLE_IMAGE&&e instanceof ol.layer.Image?new ol.renderer.webgl.ImageLayer(this,e):ol.ENABLE_TILE&&e instanceof ol.layer.Tile?new ol.renderer.webgl.TileLayer(this,e):ol.ENABLE_VECTOR&&e instanceof ol.layer.Vector?new ol.renderer.webgl.VectorLayer(this,e):(ol.DEBUG&&console.assert(!1,"unexpected layer configuration"),null)},ol.renderer.webgl.Map.prototype.dispatchComposeEvent_=function(e,o){var t=this.getMap();if(t.hasListener(e)){var r=this.context_,i=o.extent,n=o.size,l=o.viewState,a=o.pixelRatio,s=l.resolution,p=l.center,g=l.rotation,c=new ol.render.webgl.Immediate(r,p,s,g,n,i,a),u=new ol.render.Event(e,c,o,null,r);t.dispatchEvent(u)}},ol.renderer.webgl.Map.prototype.disposeInternal=function(){var e=this.getGL();e.isContextLost()||this.textureCache_.forEach(function(o){o&&e.deleteTexture(o.texture)}),this.context_.dispose(),ol.renderer.Map.prototype.disposeInternal.call(this)},ol.renderer.webgl.Map.prototype.expireCache_=function(e,o){for(var t,r=this.getGL();this.textureCache_.getCount()-this.textureCacheFrameMarkerCount_>ol.WEBGL_TEXTURE_CACHE_HIGH_WATER_MARK;){if(t=this.textureCache_.peekLast())r.deleteTexture(t.texture);else{if(+this.textureCache_.peekLastKey()==o.index)break;--this.textureCacheFrameMarkerCount_}this.textureCache_.pop()}},ol.renderer.webgl.Map.prototype.getContext=function(){return this.context_},ol.renderer.webgl.Map.prototype.getGL=function(){return this.gl_},ol.renderer.webgl.Map.prototype.getTileTextureQueue=function(){return this.tileTextureQueue_},ol.renderer.webgl.Map.prototype.getType=function(){return ol.renderer.Type.WEBGL},ol.renderer.webgl.Map.prototype.handleWebGLContextLost=function(e){e.preventDefault(),this.textureCache_.clear(),this.textureCacheFrameMarkerCount_=0;var o=this.getLayerRenderers();for(var t in o){o[t].handleWebGLContextLost()}},ol.renderer.webgl.Map.prototype.handleWebGLContextRestored=function(){this.initializeGL_(),this.getMap().render()},ol.renderer.webgl.Map.prototype.initializeGL_=function(){var e=this.gl_;e.activeTexture(ol.webgl.TEXTURE0),e.blendFuncSeparate(ol.webgl.SRC_ALPHA,ol.webgl.ONE_MINUS_SRC_ALPHA,ol.webgl.ONE,ol.webgl.ONE_MINUS_SRC_ALPHA),e.disable(ol.webgl.CULL_FACE),e.disable(ol.webgl.DEPTH_TEST),e.disable(ol.webgl.SCISSOR_TEST),e.disable(ol.webgl.STENCIL_TEST)},ol.renderer.webgl.Map.prototype.isTileTextureLoaded=function(e){return this.textureCache_.containsKey(e.getKey())},ol.renderer.webgl.Map.prototype.renderFrame=function(e){var o=this.getContext(),t=this.getGL();if(t.isContextLost())return!1;if(!e)return this.renderedVisible_&&(this.canvas_.style.display="none",this.renderedVisible_=!1),!1;this.focus_=e.focus,this.textureCache_.set((-e.index).toString(),null),++this.textureCacheFrameMarkerCount_,this.dispatchComposeEvent_(ol.render.Event.Type.PRECOMPOSE,e);var r=[],i=e.layerStatesArray;ol.array.stableSort(i,ol.renderer.Map.sortByZIndex);var n,l,a,s,p=e.viewState.resolution;for(n=0,l=i.length;n<l;++n)s=i[n],ol.layer.Layer.visibleAtResolution(s,p)&&s.sourceState==ol.source.State.READY&&(a=this.getLayerRenderer(s.layer),a.prepareFrame(e,s,o)&&r.push(s));var g=e.size[0]*e.pixelRatio,c=e.size[1]*e.pixelRatio;for(this.canvas_.width==g&&this.canvas_.height==c||(this.canvas_.width=g,this.canvas_.height=c),t.bindFramebuffer(ol.webgl.FRAMEBUFFER,null),t.clearColor(0,0,0,0),t.clear(ol.webgl.COLOR_BUFFER_BIT),t.enable(ol.webgl.BLEND),t.viewport(0,0,this.canvas_.width,this.canvas_.height),n=0,l=r.length;n<l;++n)s=r[n],a=this.getLayerRenderer(s.layer),a.composeFrame(e,s,o);this.renderedVisible_||(this.canvas_.style.display="",this.renderedVisible_=!0),this.calculateMatrices2D(e),this.textureCache_.getCount()-this.textureCacheFrameMarkerCount_>ol.WEBGL_TEXTURE_CACHE_HIGH_WATER_MARK&&e.postRenderFunctions.push(this.expireCache_.bind(this)),this.tileTextureQueue_.isEmpty()||(e.postRenderFunctions.push(this.loadNextTileTexture_),e.animate=!0),this.dispatchComposeEvent_(ol.render.Event.Type.POSTCOMPOSE,e),this.scheduleRemoveUnusedLayerRenderers(e),this.scheduleExpireIconCache(e)},ol.renderer.webgl.Map.prototype.forEachFeatureAtCoordinate=function(e,o,t,r,i,n,l){var a;if(this.getGL().isContextLost())return!1;var s,p=o.viewState,g=o.layerStatesArray,c=g.length;for(s=c-1;s>=0;--s){var u=g[s],y=u.layer;if(ol.layer.Layer.visibleAtResolution(u,p.resolution)&&n.call(l,y)){if(a=this.getLayerRenderer(y).forEachFeatureAtCoordinate(e,o,t,r,i))return a}}},ol.renderer.webgl.Map.prototype.hasFeatureAtCoordinate=function(e,o,t,r,i){var n=!1;if(this.getGL().isContextLost())return!1;var l,a=o.viewState,s=o.layerStatesArray,p=s.length;for(l=p-1;l>=0;--l){var g=s[l],c=g.layer;if(ol.layer.Layer.visibleAtResolution(g,a.resolution)&&r.call(i,c)){if(n=this.getLayerRenderer(c).hasFeatureAtCoordinate(e,o))return!0}}return n},ol.renderer.webgl.Map.prototype.forEachLayerAtPixel=function(e,o,t,r,i,n){if(this.getGL().isContextLost())return!1;var l,a,s=o.viewState,p=o.layerStatesArray,g=p.length;for(a=g-1;a>=0;--a){var c=p[a],u=c.layer;if(ol.layer.Layer.visibleAtResolution(c,s.resolution)&&i.call(r,u)){if(l=this.getLayerRenderer(u).forEachLayerAtPixel(e,o,t,r))return l}}},goog.provide("ol.Map"),goog.require("ol"),goog.require("ol.Collection"),goog.require("ol.MapBrowserEvent"),goog.require("ol.MapBrowserEventHandler"),goog.require("ol.MapEvent"),goog.require("ol.Object"),goog.require("ol.TileQueue"),goog.require("ol.View"),goog.require("ol.asserts"),goog.require("ol.control"),goog.require("ol.dom"),goog.require("ol.events"),goog.require("ol.events.Event"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.functions"),goog.require("ol.has"),goog.require("ol.interaction"),goog.require("ol.layer.Group"),goog.require("ol.obj"),goog.require("ol.proj.common"),goog.require("ol.renderer.Type"),goog.require("ol.renderer.Map"),goog.require("ol.renderer.canvas.Map"),goog.require("ol.renderer.webgl.Map"),goog.require("ol.size"),goog.require("ol.structs.PriorityQueue"),goog.require("ol.transform"),ol.OL3_URL="https://openlayers.org/",ol.OL3_LOGO_URL="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAAHGAAABxgEXwfpGAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAhNQTFRF////AP//AICAgP//AFVVQECA////K1VVSbbbYL/fJ05idsTYJFtbbcjbJllmZszWWMTOIFhoHlNiZszTa9DdUcHNHlNlV8XRIVdiasrUHlZjIVZjaMnVH1RlIFRkH1RkH1ZlasvYasvXVsPQH1VkacnVa8vWIVZjIFRjVMPQa8rXIVVkXsXRsNveIFVkIFZlIVVj3eDeh6GmbMvXH1ZkIFRka8rWbMvXIFVkIFVjIFVkbMvWH1VjbMvWIFVlbcvWIFVla8vVIFVkbMvWbMvVH1VkbMvWIFVlbcvWIFVkbcvVbMvWjNPbIFVkU8LPwMzNIFVkbczWIFVkbsvWbMvXIFVkRnB8bcvW2+TkW8XRIFVkIlZlJVloJlpoKlxrLl9tMmJwOWd0Omh1RXF8TneCT3iDUHiDU8LPVMLPVcLPVcPQVsPPVsPQV8PQWMTQWsTQW8TQXMXSXsXRX4SNX8bSYMfTYcfTYsfTY8jUZcfSZsnUaIqTacrVasrVa8jTa8rWbI2VbMvWbcvWdJObdcvUdszUd8vVeJaee87Yfc3WgJyjhqGnitDYjaarldPZnrK2oNbborW5o9bbo9fbpLa6q9ndrL3ArtndscDDutzfu8fJwN7gwt7gxc/QyuHhy+HizeHi0NfX0+Pj19zb1+Tj2uXk29/e3uLg3+Lh3+bl4uXj4ufl4+fl5Ofl5ufl5ujm5+jmySDnBAAAAFp0Uk5TAAECAgMEBAYHCA0NDg4UGRogIiMmKSssLzU7PkJJT1JTVFliY2hrdHZ3foSFhYeJjY2QkpugqbG1tre5w8zQ09XY3uXn6+zx8vT09vf4+Pj5+fr6/P39/f3+gz7SsAAAAVVJREFUOMtjYKA7EBDnwCPLrObS1BRiLoJLnte6CQy8FLHLCzs2QUG4FjZ5GbcmBDDjxJBXDWxCBrb8aM4zbkIDzpLYnAcE9VXlJSWlZRU13koIeW57mGx5XjoMZEUqwxWYQaQbSzLSkYGfKFSe0QMsX5WbjgY0YS4MBplemI4BdGBW+DQ11eZiymfqQuXZIjqwyadPNoSZ4L+0FVM6e+oGI6g8a9iKNT3o8kVzNkzRg5lgl7p4wyRUL9Yt2jAxVh6mQCogae6GmflI8p0r13VFWTHBQ0rWPW7ahgWVcPm+9cuLoyy4kCJDzCm6d8PSFoh0zvQNC5OjDJhQopPPJqph1doJBUD5tnkbZiUEqaCnB3bTqLTFG1bPn71kw4b+GFdpLElKIzRxxgYgWNYc5SCENVHKeUaltHdXx0dZ8uBI1hJ2UUDgq82CM2MwKeibqAvSO7MCABq0wXEPiqWEAAAAAElFTkSuQmCC",ol.DEFAULT_RENDERER_TYPES=[ol.renderer.Type.CANVAS,ol.renderer.Type.WEBGL],ol.Map=function(e){ol.Object.call(this);var o=ol.Map.createOptionsInternal(e);this.loadTilesWhileAnimating_=void 0!==e.loadTilesWhileAnimating&&e.loadTilesWhileAnimating,this.loadTilesWhileInteracting_=void 0!==e.loadTilesWhileInteracting&&e.loadTilesWhileInteracting,this.pixelRatio_=void 0!==e.pixelRatio?e.pixelRatio:ol.has.DEVICE_PIXEL_RATIO,this.logos_=o.logos,this.animationDelayKey_,this.animationDelay_=function(){this.animationDelayKey_=void 0,this.renderFrame_.call(this,Date.now())}.bind(this),this.coordinateToPixelTransform_=ol.transform.create(),this.pixelToCoordinateTransform_=ol.transform.create(),this.frameIndex_=0,this.frameState_=null,this.previousExtent_=ol.extent.createEmpty(),this.viewPropertyListenerKey_=null,this.viewChangeListenerKey_=null,this.layerGroupPropertyListenerKeys_=null,this.viewport_=document.createElement("DIV"),this.viewport_.className="ol-viewport"+(ol.has.TOUCH?" ol-touch":""),this.viewport_.style.position="relative",this.viewport_.style.overflow="hidden",this.viewport_.style.width="100%",this.viewport_.style.height="100%",this.viewport_.style.msTouchAction="none",this.viewport_.style.touchAction="none",this.overlayContainer_=document.createElement("DIV"),this.overlayContainer_.className="ol-overlaycontainer",this.viewport_.appendChild(this.overlayContainer_),this.overlayContainerStopEvent_=document.createElement("DIV"),this.overlayContainerStopEvent_.className="ol-overlaycontainer-stopevent";for(var t=[ol.events.EventType.CLICK,ol.events.EventType.DBLCLICK,ol.events.EventType.MOUSEDOWN,ol.events.EventType.TOUCHSTART,ol.events.EventType.MSPOINTERDOWN,ol.MapBrowserEvent.EventType.POINTERDOWN,ol.events.EventType.MOUSEWHEEL,ol.events.EventType.WHEEL],r=0,i=t.length;r<i;++r)ol.events.listen(this.overlayContainerStopEvent_,t[r],ol.events.Event.stopPropagation);this.viewport_.appendChild(this.overlayContainerStopEvent_),this.mapBrowserEventHandler_=new ol.MapBrowserEventHandler(this);for(var n in ol.MapBrowserEvent.EventType)ol.events.listen(this.mapBrowserEventHandler_,ol.MapBrowserEvent.EventType[n],this.handleMapBrowserEvent,this);this.keyboardEventTarget_=o.keyboardEventTarget,this.keyHandlerKeys_=null,ol.events.listen(this.viewport_,ol.events.EventType.WHEEL,this.handleBrowserEvent,this),ol.events.listen(this.viewport_,ol.events.EventType.MOUSEWHEEL,this.handleBrowserEvent,this),this.controls_=o.controls,this.interactions_=o.interactions,this.overlays_=o.overlays,this.overlayIdIndex_={},this.renderer_=new o.rendererConstructor(this.viewport_,this),this.handleResize_,this.focus_=null,this.preRenderFunctions_=[],this.postRenderFunctions_=[],this.tileQueue_=new ol.TileQueue(this.getTilePriority.bind(this),this.handleTileChange_.bind(this)),this.skippedFeatureUids_={},ol.events.listen(this,ol.Object.getChangeEventType(ol.Map.Property.LAYERGROUP),this.handleLayerGroupChanged_,this),ol.events.listen(this,ol.Object.getChangeEventType(ol.Map.Property.VIEW),this.handleViewChanged_,this),ol.events.listen(this,ol.Object.getChangeEventType(ol.Map.Property.SIZE),this.handleSizeChanged_,this),ol.events.listen(this,ol.Object.getChangeEventType(ol.Map.Property.TARGET),this.handleTargetChanged_,this),this.setProperties(o.values),this.controls_.forEach(function(e){e.setMap(this)},this),ol.events.listen(this.controls_,ol.Collection.EventType.ADD,function(e){e.element.setMap(this)},this),ol.events.listen(this.controls_,ol.Collection.EventType.REMOVE,function(e){e.element.setMap(null)},this),this.interactions_.forEach(function(e){e.setMap(this)},this),ol.events.listen(this.interactions_,ol.Collection.EventType.ADD,function(e){e.element.setMap(this)},this),ol.events.listen(this.interactions_,ol.Collection.EventType.REMOVE,function(e){e.element.setMap(null)},this),this.overlays_.forEach(this.addOverlayInternal_,this),ol.events.listen(this.overlays_,ol.Collection.EventType.ADD,function(e){this.addOverlayInternal_(e.element)},this),ol.events.listen(this.overlays_,ol.Collection.EventType.REMOVE,function(e){var o=e.element,t=o.getId();void 0!==t&&delete this.overlayIdIndex_[t.toString()],e.element.setMap(null)},this)},ol.inherits(ol.Map,ol.Object),ol.Map.prototype.addControl=function(e){this.getControls().push(e)},ol.Map.prototype.addInteraction=function(e){this.getInteractions().push(e)},ol.Map.prototype.addLayer=function(e){this.getLayerGroup().getLayers().push(e)},ol.Map.prototype.addOverlay=function(e){this.getOverlays().push(e)},ol.Map.prototype.addOverlayInternal_=function(e){var o=e.getId();void 0!==o&&(this.overlayIdIndex_[o.toString()]=e),e.setMap(this)},ol.Map.prototype.beforeRender=function(e){ol.DEBUG&&console.warn("map.beforeRender() is deprecated.  Use view.animate() instead."),this.render(),Array.prototype.push.apply(this.preRenderFunctions_,arguments)},ol.Map.prototype.disposeInternal=function(){this.mapBrowserEventHandler_.dispose(),this.renderer_.dispose(),ol.events.unlisten(this.viewport_,ol.events.EventType.WHEEL,this.handleBrowserEvent,this),ol.events.unlisten(this.viewport_,ol.events.EventType.MOUSEWHEEL,this.handleBrowserEvent,this),void 0!==this.handleResize_&&(window.removeEventListener(ol.events.EventType.RESIZE,this.handleResize_,!1),this.handleResize_=void 0),this.animationDelayKey_&&(cancelAnimationFrame(this.animationDelayKey_),this.animationDelayKey_=void 0),this.setTarget(null),ol.Object.prototype.disposeInternal.call(this)},ol.Map.prototype.forEachFeatureAtPixel=function(e,o,t){if(this.frameState_){var r=this.getCoordinateFromPixel(e);t=void 0!==t?t:{};var i=void 0!==t.hitTolerance?t.hitTolerance*this.frameState_.pixelRatio:0,n=void 0!==t.layerFilter?t.layerFilter:ol.functions.TRUE;return this.renderer_.forEachFeatureAtCoordinate(r,this.frameState_,i,o,null,n,null)}},ol.Map.prototype.forEachLayerAtPixel=function(e,o,t,r,i){if(this.frameState_){var n=void 0!==t?t:null,l=void 0!==r?r:ol.functions.TRUE,a=void 0!==i?i:null;return this.renderer_.forEachLayerAtPixel(e,this.frameState_,o,n,l,a)}},ol.Map.prototype.hasFeatureAtPixel=function(e,o){if(!this.frameState_)return!1;var t=this.getCoordinateFromPixel(e);o=void 0!==o?o:{};var r=void 0!==o.layerFilter?o.layerFilter:ol.functions.TRUE,i=void 0!==o.hitTolerance?o.hitTolerance*this.frameState_.pixelRatio:0;return this.renderer_.hasFeatureAtCoordinate(t,this.frameState_,i,r,null)},ol.Map.prototype.getEventCoordinate=function(e){return this.getCoordinateFromPixel(this.getEventPixel(e))},ol.Map.prototype.getEventPixel=function(e){var o=this.viewport_.getBoundingClientRect(),t=e.changedTouches?e.changedTouches[0]:e;return[t.clientX-o.left,t.clientY-o.top]},ol.Map.prototype.getTarget=function(){return this.get(ol.Map.Property.TARGET)},ol.Map.prototype.getTargetElement=function(){var e=this.getTarget();return void 0!==e?"string"==typeof e?document.getElementById(e):e:null},ol.Map.prototype.getCoordinateFromPixel=function(e){var o=this.frameState_
;return o?ol.transform.apply(o.pixelToCoordinateTransform,e.slice()):null},ol.Map.prototype.getControls=function(){return this.controls_},ol.Map.prototype.getOverlays=function(){return this.overlays_},ol.Map.prototype.getOverlayById=function(e){var o=this.overlayIdIndex_[e.toString()];return void 0!==o?o:null},ol.Map.prototype.getInteractions=function(){return this.interactions_},ol.Map.prototype.getLayerGroup=function(){return this.get(ol.Map.Property.LAYERGROUP)},ol.Map.prototype.getLayers=function(){return this.getLayerGroup().getLayers()},ol.Map.prototype.getPixelFromCoordinate=function(e){var o=this.frameState_;return o?ol.transform.apply(o.coordinateToPixelTransform,e.slice(0,2)):null},ol.Map.prototype.getRenderer=function(){return this.renderer_},ol.Map.prototype.getSize=function(){return this.get(ol.Map.Property.SIZE)},ol.Map.prototype.getView=function(){return this.get(ol.Map.Property.VIEW)},ol.Map.prototype.getViewport=function(){return this.viewport_},ol.Map.prototype.getOverlayContainer=function(){return this.overlayContainer_},ol.Map.prototype.getOverlayContainerStopEvent=function(){return this.overlayContainerStopEvent_},ol.Map.prototype.getTilePriority=function(e,o,t,r){var i=this.frameState_;if(!(i&&o in i.wantedTiles))return ol.structs.PriorityQueue.DROP;if(!i.wantedTiles[o][e.getKey()])return ol.structs.PriorityQueue.DROP;var n=t[0]-i.focus[0],l=t[1]-i.focus[1];return 65536*Math.log(r)+Math.sqrt(n*n+l*l)/r},ol.Map.prototype.handleBrowserEvent=function(e,o){var t=o||e.type,r=new ol.MapBrowserEvent(t,this,e);this.handleMapBrowserEvent(r)},ol.Map.prototype.handleMapBrowserEvent=function(e){if(this.frameState_){this.focus_=e.coordinate,e.frameState=this.frameState_;var o,t=this.getInteractions().getArray();if(!1!==this.dispatchEvent(e))for(o=t.length-1;o>=0;o--){var r=t[o];if(r.getActive()){var i=r.handleEvent(e);if(!i)break}}}},ol.Map.prototype.handlePostRender=function(){var e=this.frameState_,o=this.tileQueue_;if(!o.isEmpty()){var t=16,r=t;if(e){var i=e.viewHints;i[ol.View.Hint.ANIMATING]&&(t=this.loadTilesWhileAnimating_?8:0,r=2),i[ol.View.Hint.INTERACTING]&&(t=this.loadTilesWhileInteracting_?8:0,r=2)}o.getTilesLoading()<t&&(o.reprioritize(),o.loadMoreTiles(t,r))}var n,l,a=this.postRenderFunctions_;for(n=0,l=a.length;n<l;++n)a[n](this,e);a.length=0},ol.Map.prototype.handleSizeChanged_=function(){this.render()},ol.Map.prototype.handleTargetChanged_=function(){var e;if(this.getTarget()&&(e=this.getTargetElement(),ol.DEBUG&&console.assert(null!==e,"expects a non-null value for targetElement")),this.keyHandlerKeys_){for(var o=0,t=this.keyHandlerKeys_.length;o<t;++o)ol.events.unlistenByKey(this.keyHandlerKeys_[o]);this.keyHandlerKeys_=null}if(e){e.appendChild(this.viewport_);var r=this.keyboardEventTarget_?this.keyboardEventTarget_:e;this.keyHandlerKeys_=[ol.events.listen(r,ol.events.EventType.KEYDOWN,this.handleBrowserEvent,this),ol.events.listen(r,ol.events.EventType.KEYPRESS,this.handleBrowserEvent,this)],this.handleResize_||(this.handleResize_=this.updateSize.bind(this),window.addEventListener(ol.events.EventType.RESIZE,this.handleResize_,!1))}else ol.dom.removeNode(this.viewport_),void 0!==this.handleResize_&&(window.removeEventListener(ol.events.EventType.RESIZE,this.handleResize_,!1),this.handleResize_=void 0);this.updateSize()},ol.Map.prototype.handleTileChange_=function(){this.render()},ol.Map.prototype.handleViewPropertyChanged_=function(){this.render()},ol.Map.prototype.handleViewChanged_=function(){this.viewPropertyListenerKey_&&(ol.events.unlistenByKey(this.viewPropertyListenerKey_),this.viewPropertyListenerKey_=null),this.viewChangeListenerKey_&&(ol.events.unlistenByKey(this.viewChangeListenerKey_),this.viewChangeListenerKey_=null);var e=this.getView();e&&(this.viewPropertyListenerKey_=ol.events.listen(e,ol.Object.EventType.PROPERTYCHANGE,this.handleViewPropertyChanged_,this),this.viewChangeListenerKey_=ol.events.listen(e,ol.events.EventType.CHANGE,this.handleViewPropertyChanged_,this)),this.render()},ol.Map.prototype.handleLayerGroupChanged_=function(){this.layerGroupPropertyListenerKeys_&&(this.layerGroupPropertyListenerKeys_.forEach(ol.events.unlistenByKey),this.layerGroupPropertyListenerKeys_=null);var e=this.getLayerGroup();e&&(this.layerGroupPropertyListenerKeys_=[ol.events.listen(e,ol.Object.EventType.PROPERTYCHANGE,this.render,this),ol.events.listen(e,ol.events.EventType.CHANGE,this.render,this)]),this.render()},ol.Map.prototype.isRendered=function(){return!!this.frameState_},ol.Map.prototype.renderSync=function(){this.animationDelayKey_&&cancelAnimationFrame(this.animationDelayKey_),this.animationDelay_()},ol.Map.prototype.render=function(){void 0===this.animationDelayKey_&&(this.animationDelayKey_=requestAnimationFrame(this.animationDelay_))},ol.Map.prototype.removeControl=function(e){return this.getControls().remove(e)},ol.Map.prototype.removeInteraction=function(e){return this.getInteractions().remove(e)},ol.Map.prototype.removeLayer=function(e){return this.getLayerGroup().getLayers().remove(e)},ol.Map.prototype.removeOverlay=function(e){return this.getOverlays().remove(e)},ol.Map.prototype.renderFrame_=function(e){var o,t,r,i=this.getSize(),n=this.getView(),l=ol.extent.createEmpty(),a=null;if(void 0!==i&&ol.size.hasArea(i)&&n&&n.isDef()){var s=n.getHints(this.frameState_?this.frameState_.viewHints:void 0),p=this.getLayerGroup().getLayerStatesArray(),g={};for(o=0,t=p.length;o<t;++o)g[ol.getUid(p[o].layer)]=p[o];r=n.getState(),a={animate:!1,attributions:{},coordinateToPixelTransform:this.coordinateToPixelTransform_,extent:l,focus:this.focus_?this.focus_:r.center,index:this.frameIndex_++,layerStates:g,layerStatesArray:p,logos:ol.obj.assign({},this.logos_),pixelRatio:this.pixelRatio_,pixelToCoordinateTransform:this.pixelToCoordinateTransform_,postRenderFunctions:[],size:i,skippedFeatureUids:this.skippedFeatureUids_,tileQueue:this.tileQueue_,time:e,usedTiles:{},viewState:r,viewHints:s,wantedTiles:{}}}if(a){var c,u=this.preRenderFunctions_,y=0;for(o=0,t=u.length;o<t;++o)(c=u[o])(this,a)&&(u[y++]=c);u.length=y,a.extent=ol.extent.getForViewAndSize(r.center,r.resolution,r.rotation,a.size,l)}if(this.frameState_=a,this.renderer_.renderFrame(a),a){a.animate&&this.render(),Array.prototype.push.apply(this.postRenderFunctions_,a.postRenderFunctions);0===this.preRenderFunctions_.length&&!a.viewHints[ol.View.Hint.ANIMATING]&&!a.viewHints[ol.View.Hint.INTERACTING]&&!ol.extent.equals(a.extent,this.previousExtent_)&&(this.dispatchEvent(new ol.MapEvent(ol.MapEvent.Type.MOVEEND,this,a)),ol.extent.clone(a.extent,this.previousExtent_))}this.dispatchEvent(new ol.MapEvent(ol.MapEvent.Type.POSTRENDER,this,a)),setTimeout(this.handlePostRender.bind(this),0)},ol.Map.prototype.setLayerGroup=function(e){this.set(ol.Map.Property.LAYERGROUP,e)},ol.Map.prototype.setSize=function(e){this.set(ol.Map.Property.SIZE,e)},ol.Map.prototype.setTarget=function(e){this.set(ol.Map.Property.TARGET,e)},ol.Map.prototype.setView=function(e){this.set(ol.Map.Property.VIEW,e)},ol.Map.prototype.skipFeature=function(e){var o=ol.getUid(e).toString();this.skippedFeatureUids_[o]=!0,this.render()},ol.Map.prototype.updateSize=function(){var e=this.getTargetElement();if(e){var o=getComputedStyle(e);this.setSize([e.offsetWidth-parseFloat(o.borderLeftWidth)-parseFloat(o.paddingLeft)-parseFloat(o.paddingRight)-parseFloat(o.borderRightWidth),e.offsetHeight-parseFloat(o.borderTopWidth)-parseFloat(o.paddingTop)-parseFloat(o.paddingBottom)-parseFloat(o.borderBottomWidth)])}else this.setSize(void 0)},ol.Map.prototype.unskipFeature=function(e){var o=ol.getUid(e).toString();delete this.skippedFeatureUids_[o],this.render()},ol.Map.createOptionsInternal=function(e){var o=null;void 0!==e.keyboardEventTarget&&(o="string"==typeof e.keyboardEventTarget?document.getElementById(e.keyboardEventTarget):e.keyboardEventTarget);var t={},r={};if(void 0===e.logo||"boolean"==typeof e.logo&&e.logo)r[ol.OL3_LOGO_URL]=ol.OL3_URL;else{var i=e.logo;"string"==typeof i?r[i]="":i instanceof HTMLElement?r[ol.getUid(i).toString()]=i:i&&(ol.asserts.assert("string"==typeof i.href,44),ol.asserts.assert("string"==typeof i.src,45),r[i.src]=i.href)}var n=e.layers instanceof ol.layer.Group?e.layers:new ol.layer.Group({layers:e.layers});t[ol.Map.Property.LAYERGROUP]=n,t[ol.Map.Property.TARGET]=e.target,t[ol.Map.Property.VIEW]=void 0!==e.view?e.view:new ol.View;var l,a=ol.renderer.Map;void 0!==e.renderer?(Array.isArray(e.renderer)?l=e.renderer:"string"==typeof e.renderer?l=[e.renderer]:ol.asserts.assert(!1,46),l.indexOf("dom")>=0&&(ol.DEBUG&&console.assert(!1,"The DOM render has been removed"),l=l.concat(ol.DEFAULT_RENDERER_TYPES))):l=ol.DEFAULT_RENDERER_TYPES;var s,p;for(s=0,p=l.length;s<p;++s){var g=l[s];if(ol.ENABLE_CANVAS&&g==ol.renderer.Type.CANVAS){if(ol.has.CANVAS){a=ol.renderer.canvas.Map;break}}else if(ol.ENABLE_WEBGL&&g==ol.renderer.Type.WEBGL&&ol.has.WEBGL){a=ol.renderer.webgl.Map;break}}var c;void 0!==e.controls?Array.isArray(e.controls)?c=new ol.Collection(e.controls.slice()):(ol.asserts.assert(e.controls instanceof ol.Collection,47),c=e.controls):c=ol.control.defaults();var u;void 0!==e.interactions?Array.isArray(e.interactions)?u=new ol.Collection(e.interactions.slice()):(ol.asserts.assert(e.interactions instanceof ol.Collection,48),u=e.interactions):u=ol.interaction.defaults();var y;return void 0!==e.overlays?Array.isArray(e.overlays)?y=new ol.Collection(e.overlays.slice()):(ol.asserts.assert(e.overlays instanceof ol.Collection,49),y=e.overlays):y=new ol.Collection,{controls:c,interactions:u,keyboardEventTarget:o,logos:r,overlays:y,rendererConstructor:a,values:t}},ol.Map.Property={LAYERGROUP:"layergroup",SIZE:"size",TARGET:"target",VIEW:"view"},ol.proj.common.add(),goog.provide("ol.Overlay"),goog.require("ol"),goog.require("ol.MapEvent"),goog.require("ol.Object"),goog.require("ol.dom"),goog.require("ol.events"),goog.require("ol.extent"),ol.Overlay=function(e){ol.Object.call(this),this.id_=e.id,this.insertFirst_=void 0===e.insertFirst||e.insertFirst,this.stopEvent_=void 0===e.stopEvent||e.stopEvent,this.element_=document.createElement("DIV"),this.element_.className="ol-overlay-container",this.element_.style.position="absolute",this.autoPan=void 0!==e.autoPan&&e.autoPan,this.autoPanAnimation_=e.autoPanAnimation||{},this.autoPanMargin_=void 0!==e.autoPanMargin?e.autoPanMargin:20,this.rendered_={bottom_:"",left_:"",right_:"",top_:"",visible:!0},this.mapPostrenderListenerKey_=null,ol.events.listen(this,ol.Object.getChangeEventType(ol.Overlay.Property.ELEMENT),this.handleElementChanged,this),ol.events.listen(this,ol.Object.getChangeEventType(ol.Overlay.Property.MAP),this.handleMapChanged,this),ol.events.listen(this,ol.Object.getChangeEventType(ol.Overlay.Property.OFFSET),this.handleOffsetChanged,this),ol.events.listen(this,ol.Object.getChangeEventType(ol.Overlay.Property.POSITION),this.handlePositionChanged,this),ol.events.listen(this,ol.Object.getChangeEventType(ol.Overlay.Property.POSITIONING),this.handlePositioningChanged,this),void 0!==e.element&&this.setElement(e.element),this.setOffset(void 0!==e.offset?e.offset:[0,0]),this.setPositioning(void 0!==e.positioning?e.positioning:ol.Overlay.Positioning.TOP_LEFT),void 0!==e.position&&this.setPosition(e.position)},ol.inherits(ol.Overlay,ol.Object),ol.Overlay.prototype.getElement=function(){return this.get(ol.Overlay.Property.ELEMENT)},ol.Overlay.prototype.getId=function(){return this.id_},ol.Overlay.prototype.getMap=function(){return this.get(ol.Overlay.Property.MAP)},ol.Overlay.prototype.getOffset=function(){return this.get(ol.Overlay.Property.OFFSET)},ol.Overlay.prototype.getPosition=function(){return this.get(ol.Overlay.Property.POSITION)},ol.Overlay.prototype.getPositioning=function(){return this.get(ol.Overlay.Property.POSITIONING)},ol.Overlay.prototype.handleElementChanged=function(){ol.dom.removeChildren(this.element_);var e=this.getElement();e&&this.element_.appendChild(e)},ol.Overlay.prototype.handleMapChanged=function(){this.mapPostrenderListenerKey_&&(ol.dom.removeNode(this.element_),ol.events.unlistenByKey(this.mapPostrenderListenerKey_),this.mapPostrenderListenerKey_=null);var e=this.getMap();if(e){this.mapPostrenderListenerKey_=ol.events.listen(e,ol.MapEvent.Type.POSTRENDER,this.render,this),this.updatePixelPosition();var o=this.stopEvent_?e.getOverlayContainerStopEvent():e.getOverlayContainer();this.insertFirst_?o.insertBefore(this.element_,o.childNodes[0]||null):o.appendChild(this.element_)}},ol.Overlay.prototype.render=function(){this.updatePixelPosition()},ol.Overlay.prototype.handleOffsetChanged=function(){this.updatePixelPosition()},ol.Overlay.prototype.handlePositionChanged=function(){this.updatePixelPosition(),void 0!==this.get(ol.Overlay.Property.POSITION)&&this.autoPan&&this.panIntoView_()},ol.Overlay.prototype.handlePositioningChanged=function(){this.updatePixelPosition()},ol.Overlay.prototype.setElement=function(e){this.set(ol.Overlay.Property.ELEMENT,e)},ol.Overlay.prototype.setMap=function(e){this.set(ol.Overlay.Property.MAP,e)},ol.Overlay.prototype.setOffset=function(e){this.set(ol.Overlay.Property.OFFSET,e)},ol.Overlay.prototype.setPosition=function(e){this.set(ol.Overlay.Property.POSITION,e)},ol.Overlay.prototype.panIntoView_=function(){var e=this.getMap();if(void 0!==e&&e.getTargetElement()){var o=this.getRect_(e.getTargetElement(),e.getSize()),t=this.getElement(),r=this.getRect_(t,[ol.dom.outerWidth(t),ol.dom.outerHeight(t)]),i=this.autoPanMargin_;if(!ol.extent.containsExtent(o,r)){var n=r[0]-o[0],l=o[2]-r[2],a=r[1]-o[1],s=o[3]-r[3],p=[0,0];if(n<0?p[0]=n-i:l<0&&(p[0]=Math.abs(l)+i),a<0?p[1]=a-i:s<0&&(p[1]=Math.abs(s)+i),0!==p[0]||0!==p[1]){var g=e.getView().getCenter(),c=e.getPixelFromCoordinate(g),u=[c[0]+p[0],c[1]+p[1]];e.getView().animate({center:e.getCoordinateFromPixel(u),duration:this.autoPanAnimation_.duration,easing:this.autoPanAnimation_.easing})}}}},ol.Overlay.prototype.getRect_=function(e,o){var t=e.getBoundingClientRect(),r=t.left+window.pageXOffset,i=t.top+window.pageYOffset;return[r,i,r+o[0],i+o[1]]},ol.Overlay.prototype.setPositioning=function(e){this.set(ol.Overlay.Property.POSITIONING,e)},ol.Overlay.prototype.setVisible=function(e){this.rendered_.visible!==e&&(this.element_.style.display=e?"":"none",this.rendered_.visible=e)},ol.Overlay.prototype.updatePixelPosition=function(){var e=this.getMap(),o=this.getPosition();if(void 0===e||!e.isRendered()||void 0===o)return void this.setVisible(!1);var t=e.getPixelFromCoordinate(o),r=e.getSize();this.updateRenderedPosition(t,r)},ol.Overlay.prototype.updateRenderedPosition=function(e,o){var t=this.element_.style,r=this.getOffset(),i=this.getPositioning();ol.DEBUG&&console.assert(void 0!==i,"positioning should be defined");var n=r[0],l=r[1];if(i==ol.Overlay.Positioning.BOTTOM_RIGHT||i==ol.Overlay.Positioning.CENTER_RIGHT||i==ol.Overlay.Positioning.TOP_RIGHT){""!==this.rendered_.left_&&(this.rendered_.left_=t.left="");var a=Math.round(o[0]-e[0]-n)+"px";this.rendered_.right_!=a&&(this.rendered_.right_=t.right=a)}else{""!==this.rendered_.right_&&(this.rendered_.right_=t.right=""),i!=ol.Overlay.Positioning.BOTTOM_CENTER&&i!=ol.Overlay.Positioning.CENTER_CENTER&&i!=ol.Overlay.Positioning.TOP_CENTER||(n-=this.element_.offsetWidth/2);var s=Math.round(e[0]+n)+"px";this.rendered_.left_!=s&&(this.rendered_.left_=t.left=s)}if(i==ol.Overlay.Positioning.BOTTOM_LEFT||i==ol.Overlay.Positioning.BOTTOM_CENTER||i==ol.Overlay.Positioning.BOTTOM_RIGHT){""!==this.rendered_.top_&&(this.rendered_.top_=t.top="");var p=Math.round(o[1]-e[1]-l)+"px";this.rendered_.bottom_!=p&&(this.rendered_.bottom_=t.bottom=p)}else{""!==this.rendered_.bottom_&&(this.rendered_.bottom_=t.bottom=""),i!=ol.Overlay.Positioning.CENTER_LEFT&&i!=ol.Overlay.Positioning.CENTER_CENTER&&i!=ol.Overlay.Positioning.CENTER_RIGHT||(l-=this.element_.offsetHeight/2);var g=Math.round(e[1]+l)+"px";this.rendered_.top_!=g&&(this.rendered_.top_=t.top=g)}this.setVisible(!0)},ol.Overlay.Positioning={BOTTOM_LEFT:"bottom-left",BOTTOM_CENTER:"bottom-center",BOTTOM_RIGHT:"bottom-right",CENTER_LEFT:"center-left",CENTER_CENTER:"center-center",CENTER_RIGHT:"center-right",TOP_LEFT:"top-left",TOP_CENTER:"top-center",TOP_RIGHT:"top-right"},ol.Overlay.Property={ELEMENT:"element",MAP:"map",OFFSET:"offset",POSITION:"position",POSITIONING:"positioning"},goog.provide("ol.control.OverviewMap"),goog.require("ol"),goog.require("ol.Collection"),goog.require("ol.Map"),goog.require("ol.MapEvent"),goog.require("ol.Object"),goog.require("ol.Overlay"),goog.require("ol.View"),goog.require("ol.control.Control"),goog.require("ol.coordinate"),goog.require("ol.css"),goog.require("ol.dom"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),ol.control.OverviewMap=function(e){var o=e||{};this.collapsed_=void 0===o.collapsed||o.collapsed,this.collapsible_=void 0===o.collapsible||o.collapsible,this.collapsible_||(this.collapsed_=!1);var t=void 0!==o.className?o.className:"ol-overviewmap",r=void 0!==o.tipLabel?o.tipLabel:"Overview map",i=void 0!==o.collapseLabel?o.collapseLabel:"«";"string"==typeof i?(this.collapseLabel_=document.createElement("span"),this.collapseLabel_.textContent=i):this.collapseLabel_=i;var n=void 0!==o.label?o.label:"»";"string"==typeof n?(this.label_=document.createElement("span"),this.label_.textContent=n):this.label_=n;var l=this.collapsible_&&!this.collapsed_?this.collapseLabel_:this.label_,a=document.createElement("button");a.setAttribute("type","button"),a.title=r,a.appendChild(l),ol.events.listen(a,ol.events.EventType.CLICK,this.handleClick_,this);var s=document.createElement("DIV");s.className="ol-overviewmap-map",this.ovmap_=new ol.Map({controls:new ol.Collection,interactions:new ol.Collection,target:s,view:o.view});var p=this.ovmap_;o.layers&&o.layers.forEach(function(e){p.addLayer(e)},this);var g=document.createElement("DIV");g.className="ol-overviewmap-box",g.style.boxSizing="border-box",this.boxOverlay_=new ol.Overlay({position:[0,0],positioning:ol.Overlay.Positioning.BOTTOM_LEFT,element:g}),this.ovmap_.addOverlay(this.boxOverlay_);var c=t+" "+ol.css.CLASS_UNSELECTABLE+" "+ol.css.CLASS_CONTROL+(this.collapsed_&&this.collapsible_?" ol-collapsed":"")+(this.collapsible_?"":" ol-uncollapsible"),u=document.createElement("div");u.className=c,u.appendChild(s),u.appendChild(a);var y=o.render?o.render:ol.control.OverviewMap.render;ol.control.Control.call(this,{element:u,render:y,target:o.target})},ol.inherits(ol.control.OverviewMap,ol.control.Control),ol.control.OverviewMap.prototype.setMap=function(e){var o=this.getMap();if(e!==o){if(o){var t=o.getView();t&&this.unbindView_(t)}if(ol.control.Control.prototype.setMap.call(this,e),e){this.listenerKeys.push(ol.events.listen(e,ol.Object.EventType.PROPERTYCHANGE,this.handleMapPropertyChange_,this)),0===this.ovmap_.getLayers().getLength()&&this.ovmap_.setLayerGroup(e.getLayerGroup());var r=e.getView();r&&(this.bindView_(r),r.isDef()&&(this.ovmap_.updateSize(),this.resetExtent_()))}}},ol.control.OverviewMap.prototype.handleMapPropertyChange_=function(e){if(e.key===ol.Map.Property.VIEW){var o=e.oldValue;o&&this.unbindView_(o);var t=this.getMap().getView();this.bindView_(t)}},ol.control.OverviewMap.prototype.bindView_=function(e){ol.events.listen(e,ol.Object.getChangeEventType(ol.View.Property.ROTATION),this.handleRotationChanged_,this)},ol.control.OverviewMap.prototype.unbindView_=function(e){ol.events.unlisten(e,ol.Object.getChangeEventType(ol.View.Property.ROTATION),this.handleRotationChanged_,this)},ol.control.OverviewMap.prototype.handleRotationChanged_=function(){this.ovmap_.getView().setRotation(this.getMap().getView().getRotation())},ol.control.OverviewMap.render=function(e){this.validateExtent_(),this.updateBox_()},ol.control.OverviewMap.prototype.validateExtent_=function(){var e=this.getMap(),o=this.ovmap_;if(e.isRendered()&&o.isRendered()){var t=e.getSize(),r=e.getView(),i=r.calculateExtent(t),n=o.getSize(),l=o.getView(),a=l.calculateExtent(n),s=o.getPixelFromCoordinate(ol.extent.getTopLeft(i)),p=o.getPixelFromCoordinate(ol.extent.getBottomRight(i)),g=Math.abs(s[0]-p[0]),c=Math.abs(s[1]-p[1]),u=n[0],y=n[1];g<u*ol.OVERVIEWMAP_MIN_RATIO||c<y*ol.OVERVIEWMAP_MIN_RATIO||g>u*ol.OVERVIEWMAP_MAX_RATIO||c>y*ol.OVERVIEWMAP_MAX_RATIO?this.resetExtent_():ol.extent.containsExtent(a,i)||this.recenter_()}},ol.control.OverviewMap.prototype.resetExtent_=function(){if(0!==ol.OVERVIEWMAP_MAX_RATIO&&0!==ol.OVERVIEWMAP_MIN_RATIO){var e=this.getMap(),o=this.ovmap_,t=e.getSize(),r=e.getView(),i=r.calculateExtent(t),n=o.getSize(),l=o.getView(),a=Math.log(ol.OVERVIEWMAP_MAX_RATIO/ol.OVERVIEWMAP_MIN_RATIO)/Math.LN2,s=1/(Math.pow(2,a/2)*ol.OVERVIEWMAP_MIN_RATIO);ol.extent.scaleFromCenter(i,s),l.fit(i,n)}},ol.control.OverviewMap.prototype.recenter_=function(){var e=this.getMap(),o=this.ovmap_,t=e.getView();o.getView().setCenter(t.getCenter())},ol.control.OverviewMap.prototype.updateBox_=function(){var e=this.getMap(),o=this.ovmap_;if(e.isRendered()&&o.isRendered()){var t=e.getSize(),r=e.getView(),i=o.getView(),n=r.getRotation(),l=this.boxOverlay_,a=this.boxOverlay_.getElement(),s=r.calculateExtent(t),p=i.getResolution(),g=ol.extent.getBottomLeft(s),c=ol.extent.getTopRight(s),u=this.calculateCoordinateRotate_(n,g);l.setPosition(u),a&&(a.style.width=Math.abs((g[0]-c[0])/p)+"px",a.style.height=Math.abs((c[1]-g[1])/p)+"px")}},ol.control.OverviewMap.prototype.calculateCoordinateRotate_=function(e,o){var t,r=this.getMap(),i=r.getView(),n=i.getCenter();return n&&(t=[o[0]-n[0],o[1]-n[1]],ol.coordinate.rotate(t,e),ol.coordinate.add(t,n)),t},ol.control.OverviewMap.prototype.handleClick_=function(e){e.preventDefault(),this.handleToggle_()},ol.control.OverviewMap.prototype.handleToggle_=function(){this.element.classList.toggle("ol-collapsed"),this.collapsed_?ol.dom.replaceNode(this.collapseLabel_,this.label_):ol.dom.replaceNode(this.label_,this.collapseLabel_),this.collapsed_=!this.collapsed_;var e=this.ovmap_;this.collapsed_||e.isRendered()||(e.updateSize(),this.resetExtent_(),ol.events.listenOnce(e,ol.MapEvent.Type.POSTRENDER,function(e){this.updateBox_()},this))},ol.control.OverviewMap.prototype.getCollapsible=function(){return this.collapsible_},ol.control.OverviewMap.prototype.setCollapsible=function(e){this.collapsible_!==e&&(this.collapsible_=e,this.element.classList.toggle("ol-uncollapsible"),!e&&this.collapsed_&&this.handleToggle_())},ol.control.OverviewMap.prototype.setCollapsed=function(e){this.collapsible_&&this.collapsed_!==e&&this.handleToggle_()},ol.control.OverviewMap.prototype.getCollapsed=function(){return this.collapsed_},ol.control.OverviewMap.prototype.getOverviewMap=function(){return this.ovmap_},goog.provide("ol.control.ScaleLine"),goog.require("ol"),goog.require("ol.Object"),goog.require("ol.asserts"),goog.require("ol.control.Control"),goog.require("ol.css"),goog.require("ol.events"),goog.require("ol.proj"),goog.require("ol.proj.Units"),ol.control.ScaleLine=function(e){var o=e||{},t=void 0!==o.className?o.className:"ol-scale-line";this.innerElement_=document.createElement("DIV"),this.innerElement_.className=t+"-inner",this.element_=document.createElement("DIV"),this.element_.className=t+" "+ol.css.CLASS_UNSELECTABLE,this.element_.appendChild(this.innerElement_),this.viewState_=null,this.minWidth_=void 0!==o.minWidth?o.minWidth:64,this.renderedVisible_=!1,this.renderedWidth_=void 0,this.renderedHTML_="";var r=o.render?o.render:ol.control.ScaleLine.render;ol.control.Control.call(this,{element:this.element_,render:r,target:o.target}),ol.events.listen(this,ol.Object.getChangeEventType(ol.control.ScaleLine.Property.UNITS),this.handleUnitsChanged_,this),this.setUnits(o.units||ol.control.ScaleLine.Units.METRIC)},ol.inherits(ol.control.ScaleLine,ol.control.Control),ol.control.ScaleLine.LEADING_DIGITS=[1,2,5],ol.control.ScaleLine.prototype.getUnits=function(){return this.get(ol.control.ScaleLine.Property.UNITS)},ol.control.ScaleLine.render=function(e){var o=e.frameState;this.viewState_=o?o.viewState:null,this.updateElement_()},ol.control.ScaleLine.prototype.handleUnitsChanged_=function(){this.updateElement_()},ol.control.ScaleLine.prototype.setUnits=function(e){this.set(ol.control.ScaleLine.Property.UNITS,e)},ol.control.ScaleLine.prototype.updateElement_=function(){var e=this.viewState_;if(!e)return void(this.renderedVisible_&&(this.element_.style.display="none",this.renderedVisible_=!1));var o=e.center,t=e.projection,r=t.getMetersPerUnit(),i=ol.proj.getPointResolution(t,e.resolution,o)*r,n=this.minWidth_*i,l="",a=this.getUnits();if(a==ol.control.ScaleLine.Units.DEGREES){var s=ol.proj.METERS_PER_UNIT[ol.proj.Units.DEGREES];i/=s,n<s/60?(l="″",i*=3600):n<s?(l="′",i*=60):l="°"}else a==ol.control.ScaleLine.Units.IMPERIAL?n<.9144?(l="in",i/=.0254):n<1609.344?(l="ft",i/=.3048):(l="mi",i/=1609.344):a==ol.control.ScaleLine.Units.NAUTICAL?(i/=1852,l="nm"):a==ol.control.ScaleLine.Units.METRIC?n<1?(l="mm",i*=1e3):n<1e3?l="m":(l="km",i/=1e3):a==ol.control.ScaleLine.Units.US?n<.9144?(l="in",i*=39.37):n<1609.344?(l="ft",i/=.30480061):(l="mi",i/=1609.3472):ol.asserts.assert(!1,33);for(var p,g,c=3*Math.floor(Math.log(this.minWidth_*i)/Math.log(10));;){if(p=ol.control.ScaleLine.LEADING_DIGITS[(c%3+3)%3]*Math.pow(10,Math.floor(c/3)),g=Math.round(p/i),isNaN(g))return this.element_.style.display="none",void(this.renderedVisible_=!1);if(g>=this.minWidth_)break;++c}var u=p+" "+l;this.renderedHTML_!=u&&(this.innerElement_.innerHTML=u,this.renderedHTML_=u),this.renderedWidth_!=g&&(this.innerElement_.style.width=g+"px",this.renderedWidth_=g),this.renderedVisible_||(this.element_.style.display="",this.renderedVisible_=!0)},ol.control.ScaleLine.Property={UNITS:"units"},ol.control.ScaleLine.Units={DEGREES:"degrees",IMPERIAL:"imperial",NAUTICAL:"nautical",METRIC:"metric",US:"us"},goog.provide("ol.control.ZoomSlider"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.control.Control"),goog.require("ol.css");goog.require("ol.easing"),goog.require("ol.events"),goog.require("ol.events.Event"),goog.require("ol.events.EventType"),goog.require("ol.math"),goog.require("ol.pointer.EventType"),goog.require("ol.pointer.PointerEventHandler"),ol.control.ZoomSlider=function(e){var o=e||{};this.currentResolution_=void 0,this.direction_=ol.control.ZoomSlider.direction.VERTICAL,this.dragging_,this.dragListenerKeys_=[],this.heightLimit_=0,this.widthLimit_=0,this.previousX_,this.previousY_,this.thumbSize_=null,this.sliderInitialized_=!1,this.duration_=void 0!==o.duration?o.duration:200;var t=void 0!==o.className?o.className:"ol-zoomslider",r=document.createElement("button");r.setAttribute("type","button"),r.className=t+"-thumb "+ol.css.CLASS_UNSELECTABLE;var i=document.createElement("div");i.className=t+" "+ol.css.CLASS_UNSELECTABLE+" "+ol.css.CLASS_CONTROL,i.appendChild(r),this.dragger_=new ol.pointer.PointerEventHandler(i),ol.events.listen(this.dragger_,ol.pointer.EventType.POINTERDOWN,this.handleDraggerStart_,this),ol.events.listen(this.dragger_,ol.pointer.EventType.POINTERMOVE,this.handleDraggerDrag_,this),ol.events.listen(this.dragger_,ol.pointer.EventType.POINTERUP,this.handleDraggerEnd_,this),ol.events.listen(i,ol.events.EventType.CLICK,this.handleContainerClick_,this),ol.events.listen(r,ol.events.EventType.CLICK,ol.events.Event.stopPropagation);var n=o.render?o.render:ol.control.ZoomSlider.render;ol.control.Control.call(this,{element:i,render:n})},ol.inherits(ol.control.ZoomSlider,ol.control.Control),ol.control.ZoomSlider.prototype.disposeInternal=function(){this.dragger_.dispose(),ol.control.Control.prototype.disposeInternal.call(this)},ol.control.ZoomSlider.direction={VERTICAL:0,HORIZONTAL:1},ol.control.ZoomSlider.prototype.setMap=function(e){ol.control.Control.prototype.setMap.call(this,e),e&&e.render()},ol.control.ZoomSlider.prototype.initSlider_=function(){var e=this.element,o={width:e.offsetWidth,height:e.offsetHeight},t=e.firstElementChild,r=getComputedStyle(t),i=t.offsetWidth+parseFloat(r.marginRight)+parseFloat(r.marginLeft),n=t.offsetHeight+parseFloat(r.marginTop)+parseFloat(r.marginBottom);this.thumbSize_=[i,n],o.width>o.height?(this.direction_=ol.control.ZoomSlider.direction.HORIZONTAL,this.widthLimit_=o.width-i):(this.direction_=ol.control.ZoomSlider.direction.VERTICAL,this.heightLimit_=o.height-n),this.sliderInitialized_=!0},ol.control.ZoomSlider.render=function(e){if(e.frameState){this.sliderInitialized_||this.initSlider_();var o=e.frameState.viewState.resolution;o!==this.currentResolution_&&(this.currentResolution_=o,this.setThumbPosition_(o))}},ol.control.ZoomSlider.prototype.handleContainerClick_=function(e){var o=this.getMap().getView(),t=this.getRelativePosition_(e.offsetX-this.thumbSize_[0]/2,e.offsetY-this.thumbSize_[1]/2),r=this.getResolutionForPosition_(t);o.animate({resolution:o.constrainResolution(r),duration:this.duration_,easing:ol.easing.easeOut})},ol.control.ZoomSlider.prototype.handleDraggerStart_=function(e){if(!this.dragging_&&e.originalEvent.target===this.element.firstElementChild&&(this.getMap().getView().setHint(ol.View.Hint.INTERACTING,1),this.previousX_=e.clientX,this.previousY_=e.clientY,this.dragging_=!0,0===this.dragListenerKeys_.length)){var o=this.handleDraggerDrag_,t=this.handleDraggerEnd_;this.dragListenerKeys_.push(ol.events.listen(document,ol.events.EventType.MOUSEMOVE,o,this),ol.events.listen(document,ol.events.EventType.TOUCHMOVE,o,this),ol.events.listen(document,ol.pointer.EventType.POINTERMOVE,o,this),ol.events.listen(document,ol.events.EventType.MOUSEUP,t,this),ol.events.listen(document,ol.events.EventType.TOUCHEND,t,this),ol.events.listen(document,ol.pointer.EventType.POINTERUP,t,this))}},ol.control.ZoomSlider.prototype.handleDraggerDrag_=function(e){if(this.dragging_){var o=this.element.firstElementChild,t=e.clientX-this.previousX_+parseInt(o.style.left,10),r=e.clientY-this.previousY_+parseInt(o.style.top,10),i=this.getRelativePosition_(t,r);this.currentResolution_=this.getResolutionForPosition_(i),this.getMap().getView().setResolution(this.currentResolution_),this.setThumbPosition_(this.currentResolution_),this.previousX_=e.clientX,this.previousY_=e.clientY}},ol.control.ZoomSlider.prototype.handleDraggerEnd_=function(e){if(this.dragging_){var o=this.getMap().getView();o.setHint(ol.View.Hint.INTERACTING,-1),o.animate({resolution:o.constrainResolution(this.currentResolution_),duration:this.duration_,easing:ol.easing.easeOut}),this.dragging_=!1,this.previousX_=void 0,this.previousY_=void 0,this.dragListenerKeys_.forEach(ol.events.unlistenByKey),this.dragListenerKeys_.length=0}},ol.control.ZoomSlider.prototype.setThumbPosition_=function(e){var o=this.getPositionForResolution_(e),t=this.element.firstElementChild;this.direction_==ol.control.ZoomSlider.direction.HORIZONTAL?t.style.left=this.widthLimit_*o+"px":t.style.top=this.heightLimit_*o+"px"},ol.control.ZoomSlider.prototype.getRelativePosition_=function(e,o){var t;return t=this.direction_===ol.control.ZoomSlider.direction.HORIZONTAL?e/this.widthLimit_:o/this.heightLimit_,ol.math.clamp(t,0,1)},ol.control.ZoomSlider.prototype.getResolutionForPosition_=function(e){return this.getMap().getView().getResolutionForValueFunction()(1-e)},ol.control.ZoomSlider.prototype.getPositionForResolution_=function(e){return 1-this.getMap().getView().getValueForResolutionFunction()(e)},goog.provide("ol.control.ZoomToExtent"),goog.require("ol"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.control.Control"),goog.require("ol.css"),ol.control.ZoomToExtent=function(e){var o=e||{};this.extent_=o.extent?o.extent:null;var t=void 0!==o.className?o.className:"ol-zoom-extent",r=void 0!==o.label?o.label:"E",i=void 0!==o.tipLabel?o.tipLabel:"Fit to extent",n=document.createElement("button");n.setAttribute("type","button"),n.title=i,n.appendChild("string"==typeof r?document.createTextNode(r):r),ol.events.listen(n,ol.events.EventType.CLICK,this.handleClick_,this);var l=t+" "+ol.css.CLASS_UNSELECTABLE+" "+ol.css.CLASS_CONTROL,a=document.createElement("div");a.className=l,a.appendChild(n),ol.control.Control.call(this,{element:a,
target:o.target})},ol.inherits(ol.control.ZoomToExtent,ol.control.Control),ol.control.ZoomToExtent.prototype.handleClick_=function(e){e.preventDefault(),this.handleZoomToExtent_()},ol.control.ZoomToExtent.prototype.handleZoomToExtent_=function(){var e=this.getMap(),o=e.getView(),t=this.extent_?this.extent_:o.getProjection().getExtent(),r=e.getSize();o.fit(t,r)},goog.provide("ol.DeviceOrientation"),goog.require("ol.events"),goog.require("ol"),goog.require("ol.Object"),goog.require("ol.has"),goog.require("ol.math"),ol.DeviceOrientation=function(e){ol.Object.call(this);var o=e||{};this.listenerKey_=null,ol.events.listen(this,ol.Object.getChangeEventType(ol.DeviceOrientation.Property.TRACKING),this.handleTrackingChanged_,this),this.setTracking(void 0!==o.tracking&&o.tracking)},ol.inherits(ol.DeviceOrientation,ol.Object),ol.DeviceOrientation.prototype.disposeInternal=function(){this.setTracking(!1),ol.Object.prototype.disposeInternal.call(this)},ol.DeviceOrientation.prototype.orientationChange_=function(e){var o=e;if(null!==o.alpha){var t=ol.math.toRadians(o.alpha);if(this.set(ol.DeviceOrientation.Property.ALPHA,t),"boolean"==typeof o.absolute&&o.absolute)this.set(ol.DeviceOrientation.Property.HEADING,t);else if("number"==typeof o.webkitCompassHeading&&-1!=o.webkitCompassAccuracy){var r=ol.math.toRadians(o.webkitCompassHeading);this.set(ol.DeviceOrientation.Property.HEADING,r)}}null!==o.beta&&this.set(ol.DeviceOrientation.Property.BETA,ol.math.toRadians(o.beta)),null!==o.gamma&&this.set(ol.DeviceOrientation.Property.GAMMA,ol.math.toRadians(o.gamma)),this.changed()},ol.DeviceOrientation.prototype.getAlpha=function(){return this.get(ol.DeviceOrientation.Property.ALPHA)},ol.DeviceOrientation.prototype.getBeta=function(){return this.get(ol.DeviceOrientation.Property.BETA)},ol.DeviceOrientation.prototype.getGamma=function(){return this.get(ol.DeviceOrientation.Property.GAMMA)},ol.DeviceOrientation.prototype.getHeading=function(){return this.get(ol.DeviceOrientation.Property.HEADING)},ol.DeviceOrientation.prototype.getTracking=function(){return this.get(ol.DeviceOrientation.Property.TRACKING)},ol.DeviceOrientation.prototype.handleTrackingChanged_=function(){if(ol.has.DEVICE_ORIENTATION){var e=this.getTracking();e&&!this.listenerKey_?this.listenerKey_=ol.events.listen(window,"deviceorientation",this.orientationChange_,this):e||null===this.listenerKey_||(ol.events.unlistenByKey(this.listenerKey_),this.listenerKey_=null)}},ol.DeviceOrientation.prototype.setTracking=function(e){this.set(ol.DeviceOrientation.Property.TRACKING,e)},ol.DeviceOrientation.Property={ALPHA:"alpha",BETA:"beta",GAMMA:"gamma",HEADING:"heading",TRACKING:"tracking"},goog.provide("ol.Feature"),goog.require("ol.asserts"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol"),goog.require("ol.Object"),goog.require("ol.geom.Geometry"),goog.require("ol.style.Style"),ol.Feature=function(e){if(ol.Object.call(this),this.id_=void 0,this.geometryName_="geometry",this.style_=null,this.styleFunction_=void 0,this.geometryChangeKey_=null,ol.events.listen(this,ol.Object.getChangeEventType(this.geometryName_),this.handleGeometryChanged_,this),void 0!==e)if(e instanceof ol.geom.Geometry||!e){var o=e;this.setGeometry(o)}else{var t=e;this.setProperties(t)}},ol.inherits(ol.Feature,ol.Object),ol.Feature.prototype.clone=function(){var e=new ol.Feature(this.getProperties());e.setGeometryName(this.getGeometryName());var o=this.getGeometry();o&&e.setGeometry(o.clone());var t=this.getStyle();return t&&e.setStyle(t),e},ol.Feature.prototype.getGeometry=function(){return this.get(this.geometryName_)},ol.Feature.prototype.getId=function(){return this.id_},ol.Feature.prototype.getGeometryName=function(){return this.geometryName_},ol.Feature.prototype.getStyle=function(){return this.style_},ol.Feature.prototype.getStyleFunction=function(){return this.styleFunction_},ol.Feature.prototype.handleGeometryChange_=function(){this.changed()},ol.Feature.prototype.handleGeometryChanged_=function(){this.geometryChangeKey_&&(ol.events.unlistenByKey(this.geometryChangeKey_),this.geometryChangeKey_=null);var e=this.getGeometry();e&&(this.geometryChangeKey_=ol.events.listen(e,ol.events.EventType.CHANGE,this.handleGeometryChange_,this)),this.changed()},ol.Feature.prototype.setGeometry=function(e){this.set(this.geometryName_,e)},ol.Feature.prototype.setStyle=function(e){this.style_=e,this.styleFunction_=e?ol.Feature.createStyleFunction(e):void 0,this.changed()},ol.Feature.prototype.setId=function(e){this.id_=e,this.changed()},ol.Feature.prototype.setGeometryName=function(e){ol.events.unlisten(this,ol.Object.getChangeEventType(this.geometryName_),this.handleGeometryChanged_,this),this.geometryName_=e,ol.events.listen(this,ol.Object.getChangeEventType(this.geometryName_),this.handleGeometryChanged_,this),this.handleGeometryChanged_()},ol.Feature.createStyleFunction=function(e){var o;if("function"==typeof e)o=e;else{var t;Array.isArray(e)?t=e:(ol.asserts.assert(e instanceof ol.style.Style,41),t=[e]),o=function(){return t}}return o},goog.provide("ol.format.FormatType"),ol.format.FormatType={ARRAY_BUFFER:"arraybuffer",JSON:"json",TEXT:"text",XML:"xml"},goog.provide("ol.xml"),goog.require("ol"),goog.require("ol.array"),ol.xml.DOCUMENT=document.implementation.createDocument("","",null),ol.xml.createElementNS=function(e,o){return ol.xml.DOCUMENT.createElementNS(e,o)},ol.xml.getAllTextContent=function(e,o){return ol.xml.getAllTextContent_(e,o,[]).join("")},ol.xml.getAllTextContent_=function(e,o,t){if(e.nodeType==Node.CDATA_SECTION_NODE||e.nodeType==Node.TEXT_NODE)o?t.push(String(e.nodeValue).replace(/(\r\n|\r|\n)/g,"")):t.push(e.nodeValue);else{var r;for(r=e.firstChild;r;r=r.nextSibling)ol.xml.getAllTextContent_(r,o,t)}return t},ol.xml.isDocument=function(e){return e instanceof Document},ol.xml.isNode=function(e){return e instanceof Node},ol.xml.getAttributeNS=function(e,o,t){return e.getAttributeNS(o,t)||""},ol.xml.setAttributeNS=function(e,o,t,r){e.setAttributeNS(o,t,r)},ol.xml.parse=function(e){return(new DOMParser).parseFromString(e,"application/xml")},ol.xml.makeArrayExtender=function(e,o){return function(t,r){var i=e.call(o,t,r);if(void 0!==i){ol.DEBUG&&console.assert(Array.isArray(i),"valueReader function is expected to return an array of values");var n=r[r.length-1];ol.DEBUG&&console.assert(Array.isArray(n),"objectStack is supposed to be an array of arrays"),ol.array.extend(n,i)}}},ol.xml.makeArrayPusher=function(e,o){return function(t,r){var i=e.call(void 0!==o?o:this,t,r);if(void 0!==i){var n=r[r.length-1];ol.DEBUG&&console.assert(Array.isArray(n),"objectStack is supposed to be an array of arrays"),n.push(i)}}},ol.xml.makeReplacer=function(e,o){return function(t,r){var i=e.call(void 0!==o?o:this,t,r);void 0!==i&&(r[r.length-1]=i)}},ol.xml.makeObjectPropertyPusher=function(e,o,t){return ol.DEBUG&&console.assert(void 0!==e,"undefined valueReader, expected function(this: T, Node, Array.<*>)"),function(r,i){var n=e.call(void 0!==t?t:this,r,i);if(void 0!==n){var l,a=i[i.length-1],s=void 0!==o?o:r.localName;l=s in a?a[s]:a[s]=[],l.push(n)}}},ol.xml.makeObjectPropertySetter=function(e,o,t){return ol.DEBUG&&console.assert(void 0!==e,"undefined valueReader, expected function(this: T, Node, Array.<*>)"),function(r,i){var n=e.call(void 0!==t?t:this,r,i);if(void 0!==n){i[i.length-1][void 0!==o?o:r.localName]=n}}},ol.xml.makeChildAppender=function(e,o){return function(t,r,i){e.call(void 0!==o?o:this,t,r,i);var n=i[i.length-1],l=n.node;ol.DEBUG&&console.assert(ol.xml.isNode(l)||ol.xml.isDocument(l),"expected parentNode %s to be a Node or a Document",l),l.appendChild(t)}},ol.xml.makeArraySerializer=function(e,o){var t,r;return function(o,i,n){if(void 0===t){t={};var l={};l[o.localName]=e,t[o.namespaceURI]=l,r=ol.xml.makeSimpleNodeFactory(o.localName)}ol.xml.serialize(t,r,i,n)}},ol.xml.makeSimpleNodeFactory=function(e,o){var t=e;return function(e,r,i){var n=r[r.length-1],l=n.node;ol.DEBUG&&console.assert(ol.xml.isNode(l)||ol.xml.isDocument(l),"expected node %s to be a Node or a Document",l);var a=t;void 0===a&&(a=i);var s=o;return void 0===o&&(s=l.namespaceURI),ol.DEBUG&&console.assert(void 0!==a,"nodeName was undefined"),ol.xml.createElementNS(s,a)}},ol.xml.OBJECT_PROPERTY_NODE_FACTORY=ol.xml.makeSimpleNodeFactory(),ol.xml.makeSequence=function(e,o){for(var t=o.length,r=new Array(t),i=0;i<t;++i)r[i]=e[o[i]];return r},ol.xml.makeStructureNS=function(e,o,t){var r,i,n=void 0!==t?t:{};for(r=0,i=e.length;r<i;++r)n[e[r]]=o;return n},ol.xml.parseNode=function(e,o,t,r){var i;for(i=o.firstElementChild;i;i=i.nextElementSibling){var n=e[i.namespaceURI];if(void 0!==n){var l=n[i.localName];void 0!==l&&l.call(r,i,t)}}},ol.xml.pushParseAndPop=function(e,o,t,r,i){return r.push(e),ol.xml.parseNode(o,t,r,i),r.pop()},ol.xml.serialize=function(e,o,t,r,i,n){for(var l,a,s=(void 0!==i?i:t).length,p=0;p<s;++p)void 0!==(l=t[p])&&void 0!==(a=o.call(n,l,r,void 0!==i?i[p]:void 0))&&e[a.namespaceURI][a.localName].call(n,a,l,r)},ol.xml.pushSerializeAndPop=function(e,o,t,r,i,n,l){return i.push(e),ol.xml.serialize(o,t,r,i,n,l),i.pop()},goog.provide("ol.featureloader"),goog.require("ol"),goog.require("ol.format.FormatType"),goog.require("ol.xml"),ol.featureloader.loadFeaturesXhr=function(e,o,t,r){return function(i,n,l){var a=new XMLHttpRequest;a.open("GET","function"==typeof e?e(i,n,l):e,!0),o.getType()==ol.format.FormatType.ARRAY_BUFFER&&(a.responseType="arraybuffer"),a.onload=function(e){if(!a.status||a.status>=200&&a.status<300){var i,n=o.getType();n==ol.format.FormatType.JSON||n==ol.format.FormatType.TEXT?i=a.responseText:n==ol.format.FormatType.XML?(i=a.responseXML)||(i=ol.xml.parse(a.responseText)):n==ol.format.FormatType.ARRAY_BUFFER&&(i=a.response),i?t.call(this,o.readFeatures(i,{featureProjection:l}),o.readProjection(i)):r.call(this)}else r.call(this)}.bind(this),a.send()}},ol.featureloader.xhr=function(e,o){return ol.featureloader.loadFeaturesXhr(e,o,function(e,o){this.addFeatures(e)},ol.nullFunction)},goog.provide("ol.format.Feature"),goog.require("ol.geom.Geometry"),goog.require("ol.obj"),goog.require("ol.proj"),ol.format.Feature=function(){this.defaultDataProjection=null,this.defaultFeatureProjection=null},ol.format.Feature.prototype.getExtensions=function(){},ol.format.Feature.prototype.getReadOptions=function(e,o){var t;return o&&(t={dataProjection:o.dataProjection?o.dataProjection:this.readProjection(e),featureProjection:o.featureProjection}),this.adaptOptions(t)},ol.format.Feature.prototype.adaptOptions=function(e){return ol.obj.assign({dataProjection:this.defaultDataProjection,featureProjection:this.defaultFeatureProjection},e)},ol.format.Feature.prototype.getType=function(){},ol.format.Feature.prototype.readFeature=function(e,o){},ol.format.Feature.prototype.readFeatures=function(e,o){},ol.format.Feature.prototype.readGeometry=function(e,o){},ol.format.Feature.prototype.readProjection=function(e){},ol.format.Feature.prototype.writeFeature=function(e,o){},ol.format.Feature.prototype.writeFeatures=function(e,o){},ol.format.Feature.prototype.writeGeometry=function(e,o){},ol.format.Feature.transformWithOptions=function(e,o,t){var r,i=t?ol.proj.get(t.featureProjection):null,n=t?ol.proj.get(t.dataProjection):null;if(r=i&&n&&!ol.proj.equivalent(i,n)?e instanceof ol.geom.Geometry?(o?e.clone():e).transform(o?i:n,o?n:i):ol.proj.transformExtent(o?e.slice():e,o?i:n,o?n:i):e,o&&t&&t.decimals){var l=Math.pow(10,t.decimals),a=function(e){for(var o=0,t=e.length;o<t;++o)e[o]=Math.round(e[o]*l)/l;return e};Array.isArray(r)?a(r):r.applyTransform(a)}return r},goog.provide("ol.format.JSONFeature"),goog.require("ol"),goog.require("ol.format.Feature"),goog.require("ol.format.FormatType"),ol.format.JSONFeature=function(){ol.format.Feature.call(this)},ol.inherits(ol.format.JSONFeature,ol.format.Feature),ol.format.JSONFeature.prototype.getObject_=function(e){if("string"==typeof e){var o=JSON.parse(e);return o||null}return null!==e?e:null},ol.format.JSONFeature.prototype.getType=function(){return ol.format.FormatType.JSON},ol.format.JSONFeature.prototype.readFeature=function(e,o){return this.readFeatureFromObject(this.getObject_(e),this.getReadOptions(e,o))},ol.format.JSONFeature.prototype.readFeatures=function(e,o){return this.readFeaturesFromObject(this.getObject_(e),this.getReadOptions(e,o))},ol.format.JSONFeature.prototype.readFeatureFromObject=function(e,o){},ol.format.JSONFeature.prototype.readFeaturesFromObject=function(e,o){},ol.format.JSONFeature.prototype.readGeometry=function(e,o){return this.readGeometryFromObject(this.getObject_(e),this.getReadOptions(e,o))},ol.format.JSONFeature.prototype.readGeometryFromObject=function(e,o){},ol.format.JSONFeature.prototype.readProjection=function(e){return this.readProjectionFromObject(this.getObject_(e))},ol.format.JSONFeature.prototype.readProjectionFromObject=function(e){},ol.format.JSONFeature.prototype.writeFeature=function(e,o){return JSON.stringify(this.writeFeatureObject(e,o))},ol.format.JSONFeature.prototype.writeFeatureObject=function(e,o){},ol.format.JSONFeature.prototype.writeFeatures=function(e,o){return JSON.stringify(this.writeFeaturesObject(e,o))},ol.format.JSONFeature.prototype.writeFeaturesObject=function(e,o){},ol.format.JSONFeature.prototype.writeGeometry=function(e,o){return JSON.stringify(this.writeGeometryObject(e,o))},ol.format.JSONFeature.prototype.writeGeometryObject=function(e,o){},goog.provide("ol.geom.flat.interpolate"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.math"),ol.geom.flat.interpolate.lineString=function(e,o,t,r,i,n){ol.DEBUG&&console.assert(0<=i&&i<=1,"fraction should be in between 0 and 1");var l=NaN,a=NaN,s=(t-o)/r;if(0===s)ol.DEBUG&&console.assert(!1,"n cannot be 0");else if(1==s)l=e[o],a=e[o+1];else if(2==s)l=(1-i)*e[o]+i*e[o+r],a=(1-i)*e[o+1]+i*e[o+r+1];else{var p,g=e[o],c=e[o+1],u=0,y=[0];for(p=o+r;p<t;p+=r){var d=e[p],h=e[p+1];u+=Math.sqrt((d-g)*(d-g)+(h-c)*(h-c)),y.push(u),g=d,c=h}var m=i*u,f=ol.array.binarySearch(y,m);if(f<0){var _=(m-y[-f-2])/(y[-f-1]-y[-f-2]),E=o+(-f-2)*r;l=ol.math.lerp(e[E],e[E+r],_),a=ol.math.lerp(e[E+1],e[E+r+1],_)}else l=e[o+f*r],a=e[o+f*r+1]}return n?(n[0]=l,n[1]=a,n):[l,a]},ol.geom.flat.interpolate.lineStringCoordinateAtM=function(e,o,t,r,i,n){if(t==o)return null;var l;if(i<e[o+r-1])return n?(l=e.slice(o,o+r),l[r-1]=i,l):null;if(e[t-1]<i)return n?(l=e.slice(t-r,t),l[r-1]=i,l):null;if(i==e[o+r-1])return e.slice(o,o+r);for(var a=o/r,s=t/r;a<s;){var p=a+s>>1;i<e[(p+1)*r-1]?s=p:a=p+1}var g=e[a*r-1];if(i==g)return e.slice((a-1)*r,(a-1)*r+r);var c=e[(a+1)*r-1];ol.DEBUG&&console.assert(g<i,"m0 should be less than m"),ol.DEBUG&&console.assert(i<=c,"m should be less than or equal to m1");var u=(i-g)/(c-g);l=[];var y;for(y=0;y<r-1;++y)l.push(ol.math.lerp(e[(a-1)*r+y],e[a*r+y],u));return l.push(i),ol.DEBUG&&console.assert(l.length==r,"length of coordinate array should match stride"),l},ol.geom.flat.interpolate.lineStringsCoordinateAtM=function(e,o,t,r,i,n,l){if(l)return ol.geom.flat.interpolate.lineStringCoordinateAtM(e,o,t[t.length-1],r,i,n);var a;if(i<e[r-1])return n?(a=e.slice(0,r),a[r-1]=i,a):null;if(e[e.length-1]<i)return n?(a=e.slice(e.length-r),a[r-1]=i,a):null;var s,p;for(s=0,p=t.length;s<p;++s){var g=t[s];if(o!=g){if(i<e[o+r-1])return null;if(i<=e[g-1])return ol.geom.flat.interpolate.lineStringCoordinateAtM(e,o,g,r,i,!1);o=g}}return ol.DEBUG&&console.assert(!1,"ol.geom.flat.interpolate.lineStringsCoordinateAtM should have returned"),null},goog.provide("ol.geom.flat.length"),ol.geom.flat.length.lineString=function(e,o,t,r){var i,n=e[o],l=e[o+1],a=0;for(i=o+r;i<t;i+=r){var s=e[i],p=e[i+1];a+=Math.sqrt((s-n)*(s-n)+(p-l)*(p-l)),n=s,l=p}return a},ol.geom.flat.length.linearRing=function(e,o,t,r){var i=ol.geom.flat.length.lineString(e,o,t,r),n=e[t-r]-e[o],l=e[t-r+1]-e[o+1];return i+=Math.sqrt(n*n+l*l)},goog.provide("ol.geom.LineString"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.extent"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.geom.flat.closest"),goog.require("ol.geom.flat.deflate"),goog.require("ol.geom.flat.inflate"),goog.require("ol.geom.flat.interpolate"),goog.require("ol.geom.flat.intersectsextent"),goog.require("ol.geom.flat.length"),goog.require("ol.geom.flat.segments"),goog.require("ol.geom.flat.simplify"),ol.geom.LineString=function(e,o){ol.geom.SimpleGeometry.call(this),this.flatMidpoint_=null,this.flatMidpointRevision_=-1,this.maxDelta_=-1,this.maxDeltaRevision_=-1,this.setCoordinates(e,o)},ol.inherits(ol.geom.LineString,ol.geom.SimpleGeometry),ol.geom.LineString.prototype.appendCoordinate=function(e){ol.DEBUG&&console.assert(e.length==this.stride,"length of coordinate array should match stride"),this.flatCoordinates?ol.array.extend(this.flatCoordinates,e):this.flatCoordinates=e.slice(),this.changed()},ol.geom.LineString.prototype.clone=function(){var e=new ol.geom.LineString(null);return e.setFlatCoordinates(this.layout,this.flatCoordinates.slice()),e},ol.geom.LineString.prototype.closestPointXY=function(e,o,t,r){return r<ol.extent.closestSquaredDistanceXY(this.getExtent(),e,o)?r:(this.maxDeltaRevision_!=this.getRevision()&&(this.maxDelta_=Math.sqrt(ol.geom.flat.closest.getMaxSquaredDelta(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,0)),this.maxDeltaRevision_=this.getRevision()),ol.geom.flat.closest.getClosestPoint(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,this.maxDelta_,!1,e,o,t,r))},ol.geom.LineString.prototype.forEachSegment=function(e,o){return ol.geom.flat.segments.forEach(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,e,o)},ol.geom.LineString.prototype.getCoordinateAtM=function(e,o){if(this.layout!=ol.geom.GeometryLayout.XYM&&this.layout!=ol.geom.GeometryLayout.XYZM)return null;var t=void 0!==o&&o;return ol.geom.flat.interpolate.lineStringCoordinateAtM(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,e,t)},ol.geom.LineString.prototype.getCoordinates=function(){return ol.geom.flat.inflate.coordinates(this.flatCoordinates,0,this.flatCoordinates.length,this.stride)},ol.geom.LineString.prototype.getCoordinateAt=function(e,o){return ol.geom.flat.interpolate.lineString(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,e,o)},ol.geom.LineString.prototype.getLength=function(){return ol.geom.flat.length.lineString(this.flatCoordinates,0,this.flatCoordinates.length,this.stride)},ol.geom.LineString.prototype.getFlatMidpoint=function(){return this.flatMidpointRevision_!=this.getRevision()&&(this.flatMidpoint_=this.getCoordinateAt(.5,this.flatMidpoint_),this.flatMidpointRevision_=this.getRevision()),this.flatMidpoint_},ol.geom.LineString.prototype.getSimplifiedGeometryInternal=function(e){var o=[];o.length=ol.geom.flat.simplify.douglasPeucker(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,e,o,0);var t=new ol.geom.LineString(null);return t.setFlatCoordinates(ol.geom.GeometryLayout.XY,o),t},ol.geom.LineString.prototype.getType=function(){return ol.geom.GeometryType.LINE_STRING},ol.geom.LineString.prototype.intersectsExtent=function(e){return ol.geom.flat.intersectsextent.lineString(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,e)},ol.geom.LineString.prototype.setCoordinates=function(e,o){e?(this.setLayout(o,e,1),this.flatCoordinates||(this.flatCoordinates=[]),this.flatCoordinates.length=ol.geom.flat.deflate.coordinates(this.flatCoordinates,0,e,this.stride),this.changed()):this.setFlatCoordinates(ol.geom.GeometryLayout.XY,null)},ol.geom.LineString.prototype.setFlatCoordinates=function(e,o){this.setFlatCoordinatesInternal(e,o),this.changed()},goog.provide("ol.geom.MultiLineString"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.extent"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.LineString"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.geom.flat.closest"),goog.require("ol.geom.flat.deflate"),goog.require("ol.geom.flat.inflate"),goog.require("ol.geom.flat.interpolate");goog.require("ol.geom.flat.intersectsextent"),goog.require("ol.geom.flat.simplify"),ol.geom.MultiLineString=function(e,o){ol.geom.SimpleGeometry.call(this),this.ends_=[],this.maxDelta_=-1,this.maxDeltaRevision_=-1,this.setCoordinates(e,o)},ol.inherits(ol.geom.MultiLineString,ol.geom.SimpleGeometry),ol.geom.MultiLineString.prototype.appendLineString=function(e){ol.DEBUG&&console.assert(e.getLayout()==this.layout,"layout of lineString should match the layout"),this.flatCoordinates?ol.array.extend(this.flatCoordinates,e.getFlatCoordinates().slice()):this.flatCoordinates=e.getFlatCoordinates().slice(),this.ends_.push(this.flatCoordinates.length),this.changed()},ol.geom.MultiLineString.prototype.clone=function(){var e=new ol.geom.MultiLineString(null);return e.setFlatCoordinates(this.layout,this.flatCoordinates.slice(),this.ends_.slice()),e},ol.geom.MultiLineString.prototype.closestPointXY=function(e,o,t,r){return r<ol.extent.closestSquaredDistanceXY(this.getExtent(),e,o)?r:(this.maxDeltaRevision_!=this.getRevision()&&(this.maxDelta_=Math.sqrt(ol.geom.flat.closest.getsMaxSquaredDelta(this.flatCoordinates,0,this.ends_,this.stride,0)),this.maxDeltaRevision_=this.getRevision()),ol.geom.flat.closest.getsClosestPoint(this.flatCoordinates,0,this.ends_,this.stride,this.maxDelta_,!1,e,o,t,r))},ol.geom.MultiLineString.prototype.getCoordinateAtM=function(e,o,t){if(this.layout!=ol.geom.GeometryLayout.XYM&&this.layout!=ol.geom.GeometryLayout.XYZM||0===this.flatCoordinates.length)return null;var r=void 0!==o&&o,i=void 0!==t&&t;return ol.geom.flat.interpolate.lineStringsCoordinateAtM(this.flatCoordinates,0,this.ends_,this.stride,e,r,i)},ol.geom.MultiLineString.prototype.getCoordinates=function(){return ol.geom.flat.inflate.coordinatess(this.flatCoordinates,0,this.ends_,this.stride)},ol.geom.MultiLineString.prototype.getEnds=function(){return this.ends_},ol.geom.MultiLineString.prototype.getLineString=function(e){if(ol.DEBUG&&console.assert(0<=e&&e<this.ends_.length,"index should be in between 0 and length of the this.ends_ array"),e<0||this.ends_.length<=e)return null;var o=new ol.geom.LineString(null);return o.setFlatCoordinates(this.layout,this.flatCoordinates.slice(0===e?0:this.ends_[e-1],this.ends_[e])),o},ol.geom.MultiLineString.prototype.getLineStrings=function(){var e,o,t=this.flatCoordinates,r=this.ends_,i=this.layout,n=[],l=0;for(e=0,o=r.length;e<o;++e){var a=r[e],s=new ol.geom.LineString(null);s.setFlatCoordinates(i,t.slice(l,a)),n.push(s),l=a}return n},ol.geom.MultiLineString.prototype.getFlatMidpoints=function(){var e,o,t=[],r=this.flatCoordinates,i=0,n=this.ends_,l=this.stride;for(e=0,o=n.length;e<o;++e){var a=n[e],s=ol.geom.flat.interpolate.lineString(r,i,a,l,.5);ol.array.extend(t,s),i=a}return t},ol.geom.MultiLineString.prototype.getSimplifiedGeometryInternal=function(e){var o=[],t=[];o.length=ol.geom.flat.simplify.douglasPeuckers(this.flatCoordinates,0,this.ends_,this.stride,e,o,0,t);var r=new ol.geom.MultiLineString(null);return r.setFlatCoordinates(ol.geom.GeometryLayout.XY,o,t),r},ol.geom.MultiLineString.prototype.getType=function(){return ol.geom.GeometryType.MULTI_LINE_STRING},ol.geom.MultiLineString.prototype.intersectsExtent=function(e){return ol.geom.flat.intersectsextent.lineStrings(this.flatCoordinates,0,this.ends_,this.stride,e)},ol.geom.MultiLineString.prototype.setCoordinates=function(e,o){if(e){this.setLayout(o,e,2),this.flatCoordinates||(this.flatCoordinates=[]);var t=ol.geom.flat.deflate.coordinatess(this.flatCoordinates,0,e,this.stride,this.ends_);this.flatCoordinates.length=0===t.length?0:t[t.length-1],this.changed()}else this.setFlatCoordinates(ol.geom.GeometryLayout.XY,null,this.ends_)},ol.geom.MultiLineString.prototype.setFlatCoordinates=function(e,o,t){o?0===t.length?ol.DEBUG&&console.assert(0===o.length,"flatCoordinates should be an empty array"):ol.DEBUG&&console.assert(o.length==t[t.length-1],"length of flatCoordinates array should match the last value of ends"):ol.DEBUG&&console.assert(t&&0===t.length,"ends must be truthy and ends.length should be 0"),this.setFlatCoordinatesInternal(e,o),this.ends_=t,this.changed()},ol.geom.MultiLineString.prototype.setLineStrings=function(e){var o,t,r=this.getLayout(),i=[],n=[];for(o=0,t=e.length;o<t;++o){var l=e[o];0===o?r=l.getLayout():ol.DEBUG&&console.assert(l.getLayout()==r,"layout of lineString should match layout"),ol.array.extend(i,l.getFlatCoordinates()),n.push(i.length)}this.setFlatCoordinates(r,i,n)},goog.provide("ol.geom.MultiPoint"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.extent"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.Point"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.geom.flat.deflate"),goog.require("ol.geom.flat.inflate"),goog.require("ol.math"),ol.geom.MultiPoint=function(e,o){ol.geom.SimpleGeometry.call(this),this.setCoordinates(e,o)},ol.inherits(ol.geom.MultiPoint,ol.geom.SimpleGeometry),ol.geom.MultiPoint.prototype.appendPoint=function(e){ol.DEBUG&&console.assert(e.getLayout()==this.layout,"the layout of point should match layout"),this.flatCoordinates?ol.array.extend(this.flatCoordinates,e.getFlatCoordinates()):this.flatCoordinates=e.getFlatCoordinates().slice(),this.changed()},ol.geom.MultiPoint.prototype.clone=function(){var e=new ol.geom.MultiPoint(null);return e.setFlatCoordinates(this.layout,this.flatCoordinates.slice()),e},ol.geom.MultiPoint.prototype.closestPointXY=function(e,o,t,r){if(r<ol.extent.closestSquaredDistanceXY(this.getExtent(),e,o))return r;var i,n,l,a=this.flatCoordinates,s=this.stride;for(i=0,n=a.length;i<n;i+=s){var p=ol.math.squaredDistance(e,o,a[i],a[i+1]);if(p<r){for(r=p,l=0;l<s;++l)t[l]=a[i+l];t.length=s}}return r},ol.geom.MultiPoint.prototype.getCoordinates=function(){return ol.geom.flat.inflate.coordinates(this.flatCoordinates,0,this.flatCoordinates.length,this.stride)},ol.geom.MultiPoint.prototype.getPoint=function(e){var o=this.flatCoordinates?this.flatCoordinates.length/this.stride:0;if(ol.DEBUG&&console.assert(0<=e&&e<o,"index should be in between 0 and n"),e<0||o<=e)return null;var t=new ol.geom.Point(null);return t.setFlatCoordinates(this.layout,this.flatCoordinates.slice(e*this.stride,(e+1)*this.stride)),t},ol.geom.MultiPoint.prototype.getPoints=function(){var e,o,t=this.flatCoordinates,r=this.layout,i=this.stride,n=[];for(e=0,o=t.length;e<o;e+=i){var l=new ol.geom.Point(null);l.setFlatCoordinates(r,t.slice(e,e+i)),n.push(l)}return n},ol.geom.MultiPoint.prototype.getType=function(){return ol.geom.GeometryType.MULTI_POINT},ol.geom.MultiPoint.prototype.intersectsExtent=function(e){var o,t,r,i,n=this.flatCoordinates,l=this.stride;for(o=0,t=n.length;o<t;o+=l)if(r=n[o],i=n[o+1],ol.extent.containsXY(e,r,i))return!0;return!1},ol.geom.MultiPoint.prototype.setCoordinates=function(e,o){e?(this.setLayout(o,e,1),this.flatCoordinates||(this.flatCoordinates=[]),this.flatCoordinates.length=ol.geom.flat.deflate.coordinates(this.flatCoordinates,0,e,this.stride),this.changed()):this.setFlatCoordinates(ol.geom.GeometryLayout.XY,null)},ol.geom.MultiPoint.prototype.setFlatCoordinates=function(e,o){this.setFlatCoordinatesInternal(e,o),this.changed()},goog.provide("ol.geom.flat.center"),goog.require("ol.extent"),ol.geom.flat.center.linearRingss=function(e,o,t,r){var i,n,l=[],a=ol.extent.createEmpty();for(i=0,n=t.length;i<n;++i){var s=t[i];a=ol.extent.createOrUpdateFromFlatCoordinates(e,o,s[0],r),l.push((a[0]+a[2])/2,(a[1]+a[3])/2),o=s[s.length-1]}return l},goog.provide("ol.geom.MultiPolygon"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.extent"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.MultiPoint"),goog.require("ol.geom.Polygon"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.geom.flat.area"),goog.require("ol.geom.flat.center"),goog.require("ol.geom.flat.closest"),goog.require("ol.geom.flat.contains"),goog.require("ol.geom.flat.deflate"),goog.require("ol.geom.flat.inflate"),goog.require("ol.geom.flat.interiorpoint"),goog.require("ol.geom.flat.intersectsextent"),goog.require("ol.geom.flat.orient"),goog.require("ol.geom.flat.simplify"),ol.geom.MultiPolygon=function(e,o){ol.geom.SimpleGeometry.call(this),this.endss_=[],this.flatInteriorPointsRevision_=-1,this.flatInteriorPoints_=null,this.maxDelta_=-1,this.maxDeltaRevision_=-1,this.orientedRevision_=-1,this.orientedFlatCoordinates_=null,this.setCoordinates(e,o)},ol.inherits(ol.geom.MultiPolygon,ol.geom.SimpleGeometry),ol.geom.MultiPolygon.prototype.appendPolygon=function(e){ol.DEBUG&&console.assert(e.getLayout()==this.layout,"layout of polygon should match layout");var o;if(this.flatCoordinates){var t=this.flatCoordinates.length;ol.array.extend(this.flatCoordinates,e.getFlatCoordinates()),o=e.getEnds().slice();var r,i;for(r=0,i=o.length;r<i;++r)o[r]+=t}else this.flatCoordinates=e.getFlatCoordinates().slice(),o=e.getEnds().slice(),this.endss_.push();this.endss_.push(o),this.changed()},ol.geom.MultiPolygon.prototype.clone=function(){for(var e=new ol.geom.MultiPolygon(null),o=this.endss_.length,t=new Array(o),r=0;r<o;++r)t[r]=this.endss_[r].slice();return e.setFlatCoordinates(this.layout,this.flatCoordinates.slice(),t),e},ol.geom.MultiPolygon.prototype.closestPointXY=function(e,o,t,r){return r<ol.extent.closestSquaredDistanceXY(this.getExtent(),e,o)?r:(this.maxDeltaRevision_!=this.getRevision()&&(this.maxDelta_=Math.sqrt(ol.geom.flat.closest.getssMaxSquaredDelta(this.flatCoordinates,0,this.endss_,this.stride,0)),this.maxDeltaRevision_=this.getRevision()),ol.geom.flat.closest.getssClosestPoint(this.getOrientedFlatCoordinates(),0,this.endss_,this.stride,this.maxDelta_,!0,e,o,t,r))},ol.geom.MultiPolygon.prototype.containsXY=function(e,o){return ol.geom.flat.contains.linearRingssContainsXY(this.getOrientedFlatCoordinates(),0,this.endss_,this.stride,e,o)},ol.geom.MultiPolygon.prototype.getArea=function(){return ol.geom.flat.area.linearRingss(this.getOrientedFlatCoordinates(),0,this.endss_,this.stride)},ol.geom.MultiPolygon.prototype.getCoordinates=function(e){var o;return void 0!==e?(o=this.getOrientedFlatCoordinates().slice(),ol.geom.flat.orient.orientLinearRingss(o,0,this.endss_,this.stride,e)):o=this.flatCoordinates,ol.geom.flat.inflate.coordinatesss(o,0,this.endss_,this.stride)},ol.geom.MultiPolygon.prototype.getEndss=function(){return this.endss_},ol.geom.MultiPolygon.prototype.getFlatInteriorPoints=function(){if(this.flatInteriorPointsRevision_!=this.getRevision()){var e=ol.geom.flat.center.linearRingss(this.flatCoordinates,0,this.endss_,this.stride);this.flatInteriorPoints_=ol.geom.flat.interiorpoint.linearRingss(this.getOrientedFlatCoordinates(),0,this.endss_,this.stride,e),this.flatInteriorPointsRevision_=this.getRevision()}return this.flatInteriorPoints_},ol.geom.MultiPolygon.prototype.getInteriorPoints=function(){var e=new ol.geom.MultiPoint(null);return e.setFlatCoordinates(ol.geom.GeometryLayout.XY,this.getFlatInteriorPoints().slice()),e},ol.geom.MultiPolygon.prototype.getOrientedFlatCoordinates=function(){if(this.orientedRevision_!=this.getRevision()){var e=this.flatCoordinates;ol.geom.flat.orient.linearRingssAreOriented(e,0,this.endss_,this.stride)?this.orientedFlatCoordinates_=e:(this.orientedFlatCoordinates_=e.slice(),this.orientedFlatCoordinates_.length=ol.geom.flat.orient.orientLinearRingss(this.orientedFlatCoordinates_,0,this.endss_,this.stride)),this.orientedRevision_=this.getRevision()}return this.orientedFlatCoordinates_},ol.geom.MultiPolygon.prototype.getSimplifiedGeometryInternal=function(e){var o=[],t=[];o.length=ol.geom.flat.simplify.quantizess(this.flatCoordinates,0,this.endss_,this.stride,Math.sqrt(e),o,0,t);var r=new ol.geom.MultiPolygon(null);return r.setFlatCoordinates(ol.geom.GeometryLayout.XY,o,t),r},ol.geom.MultiPolygon.prototype.getPolygon=function(e){if(ol.DEBUG&&console.assert(0<=e&&e<this.endss_.length,"index should be in between 0 and the length of this.endss_"),
e<0||this.endss_.length<=e)return null;var o;if(0===e)o=0;else{var t=this.endss_[e-1];o=t[t.length-1]}var r=this.endss_[e].slice(),i=r[r.length-1];if(0!==o){var n,l;for(n=0,l=r.length;n<l;++n)r[n]-=o}var a=new ol.geom.Polygon(null);return a.setFlatCoordinates(this.layout,this.flatCoordinates.slice(o,i),r),a},ol.geom.MultiPolygon.prototype.getPolygons=function(){var e,o,t,r,i=this.layout,n=this.flatCoordinates,l=this.endss_,a=[],s=0;for(e=0,o=l.length;e<o;++e){var p=l[e].slice(),g=p[p.length-1];if(0!==s)for(t=0,r=p.length;t<r;++t)p[t]-=s;var c=new ol.geom.Polygon(null);c.setFlatCoordinates(i,n.slice(s,g),p),a.push(c),s=g}return a},ol.geom.MultiPolygon.prototype.getType=function(){return ol.geom.GeometryType.MULTI_POLYGON},ol.geom.MultiPolygon.prototype.intersectsExtent=function(e){return ol.geom.flat.intersectsextent.linearRingss(this.getOrientedFlatCoordinates(),0,this.endss_,this.stride,e)},ol.geom.MultiPolygon.prototype.setCoordinates=function(e,o){if(e){this.setLayout(o,e,3),this.flatCoordinates||(this.flatCoordinates=[]);var t=ol.geom.flat.deflate.coordinatesss(this.flatCoordinates,0,e,this.stride,this.endss_);if(0===t.length)this.flatCoordinates.length=0;else{var r=t[t.length-1];this.flatCoordinates.length=0===r.length?0:r[r.length-1]}this.changed()}else this.setFlatCoordinates(ol.geom.GeometryLayout.XY,null,this.endss_)},ol.geom.MultiPolygon.prototype.setFlatCoordinates=function(e,o,t){if(ol.DEBUG&&console.assert(t,"endss must be truthy"),o&&0!==o.length){ol.DEBUG&&console.assert(t.length>0,"endss cannot be an empty array");var r=t[t.length-1];ol.DEBUG&&console.assert(o.length==r[r.length-1],"the length of flatCoordinates should be the last value of ends")}else ol.DEBUG&&console.assert(0===t.length,"the length of endss should be 0");this.setFlatCoordinatesInternal(e,o),this.endss_=t,this.changed()},ol.geom.MultiPolygon.prototype.setPolygons=function(e){var o,t,r,i=this.getLayout(),n=[],l=[];for(o=0,t=e.length;o<t;++o){var a=e[o];0===o?i=a.getLayout():ol.DEBUG&&console.assert(a.getLayout()==i,"layout of polygon should be layout");var s=n.length;r=a.getEnds();var p,g;for(p=0,g=r.length;p<g;++p)r[p]+=s;ol.array.extend(n,a.getFlatCoordinates()),l.push(r)}this.setFlatCoordinates(i,n,l)},goog.provide("ol.format.EsriJSON"),goog.require("ol"),goog.require("ol.Feature"),goog.require("ol.array"),goog.require("ol.asserts"),goog.require("ol.extent"),goog.require("ol.format.Feature"),goog.require("ol.format.JSONFeature"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.LineString"),goog.require("ol.geom.LinearRing"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.MultiPoint"),goog.require("ol.geom.MultiPolygon"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.geom.flat.orient"),goog.require("ol.obj"),goog.require("ol.proj"),ol.format.EsriJSON=function(e){var o=e||{};ol.format.JSONFeature.call(this),this.geometryName_=o.geometryName},ol.inherits(ol.format.EsriJSON,ol.format.JSONFeature),ol.format.EsriJSON.readGeometry_=function(e,o){if(!e)return null;var t;if("number"==typeof e.x&&"number"==typeof e.y)t=ol.geom.GeometryType.POINT;else if(e.points)t=ol.geom.GeometryType.MULTI_POINT;else if(e.paths)t=1===e.paths.length?ol.geom.GeometryType.LINE_STRING:ol.geom.GeometryType.MULTI_LINE_STRING;else if(e.rings){var r=ol.format.EsriJSON.getGeometryLayout_(e),i=ol.format.EsriJSON.convertRings_(e.rings,r);e=ol.obj.assign({},e),1===i.length?(t=ol.geom.GeometryType.POLYGON,e.rings=i[0]):(t=ol.geom.GeometryType.MULTI_POLYGON,e.rings=i)}var n=ol.format.EsriJSON.GEOMETRY_READERS_[t];return ol.format.Feature.transformWithOptions(n(e),!1,o)},ol.format.EsriJSON.convertRings_=function(e,o){var t,r,i=[],n=[];for(t=0,r=e.length;t<r;++t){var l=ol.array.flatten(e[t]);ol.geom.flat.orient.linearRingIsClockwise(l,0,l.length,o.length)?i.push([e[t]]):n.push(e[t])}for(;n.length;){var a=n.shift(),s=!1;for(t=i.length-1;t>=0;t--){var p=i[t][0];if(ol.extent.containsExtent(new ol.geom.LinearRing(p).getExtent(),new ol.geom.LinearRing(a).getExtent())){i[t].push(a),s=!0;break}}s||i.push([a.reverse()])}return i},ol.format.EsriJSON.readPointGeometry_=function(e){ol.DEBUG&&console.assert("number"==typeof e.x,"object.x should be number"),ol.DEBUG&&console.assert("number"==typeof e.y,"object.y should be number");return void 0!==e.m&&void 0!==e.z?new ol.geom.Point([e.x,e.y,e.z,e.m],ol.geom.GeometryLayout.XYZM):void 0!==e.z?new ol.geom.Point([e.x,e.y,e.z],ol.geom.GeometryLayout.XYZ):void 0!==e.m?new ol.geom.Point([e.x,e.y,e.m],ol.geom.GeometryLayout.XYM):new ol.geom.Point([e.x,e.y])},ol.format.EsriJSON.readLineStringGeometry_=function(e){ol.DEBUG&&console.assert(Array.isArray(e.paths),"object.paths should be an array"),ol.DEBUG&&console.assert(1===e.paths.length,"object.paths array length should be 1");var o=ol.format.EsriJSON.getGeometryLayout_(e);return new ol.geom.LineString(e.paths[0],o)},ol.format.EsriJSON.readMultiLineStringGeometry_=function(e){ol.DEBUG&&console.assert(Array.isArray(e.paths),"object.paths should be an array"),ol.DEBUG&&console.assert(e.paths.length>1,"object.paths array length should be more than 1");var o=ol.format.EsriJSON.getGeometryLayout_(e);return new ol.geom.MultiLineString(e.paths,o)},ol.format.EsriJSON.getGeometryLayout_=function(e){var o=ol.geom.GeometryLayout.XY;return!0===e.hasZ&&!0===e.hasM?o=ol.geom.GeometryLayout.XYZM:!0===e.hasZ?o=ol.geom.GeometryLayout.XYZ:!0===e.hasM&&(o=ol.geom.GeometryLayout.XYM),o},ol.format.EsriJSON.readMultiPointGeometry_=function(e){var o=ol.format.EsriJSON.getGeometryLayout_(e);return new ol.geom.MultiPoint(e.points,o)},ol.format.EsriJSON.readMultiPolygonGeometry_=function(e){ol.DEBUG&&console.assert(e.rings.length>1,"object.rings should have length larger than 1");var o=ol.format.EsriJSON.getGeometryLayout_(e);return new ol.geom.MultiPolygon(e.rings,o)},ol.format.EsriJSON.readPolygonGeometry_=function(e){ol.DEBUG&&console.assert(e.rings);var o=ol.format.EsriJSON.getGeometryLayout_(e);return new ol.geom.Polygon(e.rings,o)},ol.format.EsriJSON.writePointGeometry_=function(e,o){var t,r=e.getCoordinates(),i=e.getLayout();return i===ol.geom.GeometryLayout.XYZ?t={x:r[0],y:r[1],z:r[2]}:i===ol.geom.GeometryLayout.XYM?t={x:r[0],y:r[1],m:r[2]}:i===ol.geom.GeometryLayout.XYZM?t={x:r[0],y:r[1],z:r[2],m:r[3]}:i===ol.geom.GeometryLayout.XY?t={x:r[0],y:r[1]}:ol.asserts.assert(!1,34),t},ol.format.EsriJSON.getHasZM_=function(e){var o=e.getLayout();return{hasZ:o===ol.geom.GeometryLayout.XYZ||o===ol.geom.GeometryLayout.XYZM,hasM:o===ol.geom.GeometryLayout.XYM||o===ol.geom.GeometryLayout.XYZM}},ol.format.EsriJSON.writeLineStringGeometry_=function(e,o){var t=ol.format.EsriJSON.getHasZM_(e);return{hasZ:t.hasZ,hasM:t.hasM,paths:[e.getCoordinates()]}},ol.format.EsriJSON.writePolygonGeometry_=function(e,o){var t=ol.format.EsriJSON.getHasZM_(e);return{hasZ:t.hasZ,hasM:t.hasM,rings:e.getCoordinates(!1)}},ol.format.EsriJSON.writeMultiLineStringGeometry_=function(e,o){var t=ol.format.EsriJSON.getHasZM_(e);return{hasZ:t.hasZ,hasM:t.hasM,paths:e.getCoordinates()}},ol.format.EsriJSON.writeMultiPointGeometry_=function(e,o){var t=ol.format.EsriJSON.getHasZM_(e);return{hasZ:t.hasZ,hasM:t.hasM,points:e.getCoordinates()}},ol.format.EsriJSON.writeMultiPolygonGeometry_=function(e,o){for(var t=ol.format.EsriJSON.getHasZM_(e),r=e.getCoordinates(!1),i=[],n=0;n<r.length;n++)for(var l=r[n].length-1;l>=0;l--)i.push(r[n][l]);return{hasZ:t.hasZ,hasM:t.hasM,rings:i}},ol.format.EsriJSON.GEOMETRY_READERS_={},ol.format.EsriJSON.GEOMETRY_READERS_[ol.geom.GeometryType.POINT]=ol.format.EsriJSON.readPointGeometry_,ol.format.EsriJSON.GEOMETRY_READERS_[ol.geom.GeometryType.LINE_STRING]=ol.format.EsriJSON.readLineStringGeometry_,ol.format.EsriJSON.GEOMETRY_READERS_[ol.geom.GeometryType.POLYGON]=ol.format.EsriJSON.readPolygonGeometry_,ol.format.EsriJSON.GEOMETRY_READERS_[ol.geom.GeometryType.MULTI_POINT]=ol.format.EsriJSON.readMultiPointGeometry_,ol.format.EsriJSON.GEOMETRY_READERS_[ol.geom.GeometryType.MULTI_LINE_STRING]=ol.format.EsriJSON.readMultiLineStringGeometry_,ol.format.EsriJSON.GEOMETRY_READERS_[ol.geom.GeometryType.MULTI_POLYGON]=ol.format.EsriJSON.readMultiPolygonGeometry_,ol.format.EsriJSON.GEOMETRY_WRITERS_={},ol.format.EsriJSON.GEOMETRY_WRITERS_[ol.geom.GeometryType.POINT]=ol.format.EsriJSON.writePointGeometry_,ol.format.EsriJSON.GEOMETRY_WRITERS_[ol.geom.GeometryType.LINE_STRING]=ol.format.EsriJSON.writeLineStringGeometry_,ol.format.EsriJSON.GEOMETRY_WRITERS_[ol.geom.GeometryType.POLYGON]=ol.format.EsriJSON.writePolygonGeometry_,ol.format.EsriJSON.GEOMETRY_WRITERS_[ol.geom.GeometryType.MULTI_POINT]=ol.format.EsriJSON.writeMultiPointGeometry_,ol.format.EsriJSON.GEOMETRY_WRITERS_[ol.geom.GeometryType.MULTI_LINE_STRING]=ol.format.EsriJSON.writeMultiLineStringGeometry_,ol.format.EsriJSON.GEOMETRY_WRITERS_[ol.geom.GeometryType.MULTI_POLYGON]=ol.format.EsriJSON.writeMultiPolygonGeometry_,ol.format.EsriJSON.prototype.readFeature,ol.format.EsriJSON.prototype.readFeatures,ol.format.EsriJSON.prototype.readFeatureFromObject=function(e,o){var t=e;ol.DEBUG&&console.assert(t.geometry||t.attributes,"geometry or attributes should be defined");var r=ol.format.EsriJSON.readGeometry_(t.geometry,o),i=new ol.Feature;return this.geometryName_&&i.setGeometryName(this.geometryName_),i.setGeometry(r),o&&o.idField&&t.attributes[o.idField]&&(ol.DEBUG&&console.assert("number"==typeof t.attributes[o.idField],"objectIdFieldName value should be a number"),i.setId(t.attributes[o.idField])),t.attributes&&i.setProperties(t.attributes),i},ol.format.EsriJSON.prototype.readFeaturesFromObject=function(e,o){var t=e,r=o||{};if(t.features){var i,n,l=e,a=[],s=l.features;for(r.idField=e.objectIdFieldName,i=0,n=s.length;i<n;++i)a.push(this.readFeatureFromObject(s[i],r));return a}return[this.readFeatureFromObject(e,r)]},ol.format.EsriJSON.prototype.readGeometry,ol.format.EsriJSON.prototype.readGeometryFromObject=function(e,o){return ol.format.EsriJSON.readGeometry_(e,o)},ol.format.EsriJSON.prototype.readProjection,ol.format.EsriJSON.prototype.readProjectionFromObject=function(e){var o=e;if(o.spatialReference&&o.spatialReference.wkid){var t=o.spatialReference.wkid;return ol.proj.get("EPSG:"+t)}return null},ol.format.EsriJSON.writeGeometry_=function(e,o){return(0,ol.format.EsriJSON.GEOMETRY_WRITERS_[e.getType()])(ol.format.Feature.transformWithOptions(e,!0,o),o)},ol.format.EsriJSON.prototype.writeGeometry,ol.format.EsriJSON.prototype.writeGeometryObject=function(e,o){return ol.format.EsriJSON.writeGeometry_(e,this.adaptOptions(o))},ol.format.EsriJSON.prototype.writeFeature,ol.format.EsriJSON.prototype.writeFeatureObject=function(e,o){o=this.adaptOptions(o);var t={},r=e.getGeometry();r&&(t.geometry=ol.format.EsriJSON.writeGeometry_(r,o));var i=e.getProperties();return delete i[e.getGeometryName()],ol.obj.isEmpty(i)?t.attributes={}:t.attributes=i,o&&o.featureProjection&&(t.spatialReference={wkid:ol.proj.get(o.featureProjection).getCode().split(":").pop()}),t},ol.format.EsriJSON.prototype.writeFeatures,ol.format.EsriJSON.prototype.writeFeaturesObject=function(e,o){o=this.adaptOptions(o);var t,r,i=[];for(t=0,r=e.length;t<r;++t)i.push(this.writeFeatureObject(e[t],o));return{features:i}},goog.provide("ol.format.filter.Filter"),goog.require("ol"),ol.format.filter.Filter=function(e){this.tagName_=e},ol.format.filter.Filter.prototype.getTagName=function(){return this.tagName_},goog.provide("ol.format.filter.Logical"),goog.require("ol"),goog.require("ol.format.filter.Filter"),ol.format.filter.Logical=function(e){ol.format.filter.Filter.call(this,e)},ol.inherits(ol.format.filter.Logical,ol.format.filter.Filter),goog.provide("ol.format.filter.LogicalBinary"),goog.require("ol"),goog.require("ol.format.filter.Logical"),ol.format.filter.LogicalBinary=function(e,o,t){ol.format.filter.Logical.call(this,e),this.conditionA=o,this.conditionB=t},ol.inherits(ol.format.filter.LogicalBinary,ol.format.filter.Logical),goog.provide("ol.format.filter.And"),goog.require("ol"),goog.require("ol.format.filter.LogicalBinary"),ol.format.filter.And=function(e,o){ol.format.filter.LogicalBinary.call(this,"And",e,o)},ol.inherits(ol.format.filter.And,ol.format.filter.LogicalBinary),goog.provide("ol.format.filter.Bbox"),goog.require("ol"),goog.require("ol.format.filter.Filter"),ol.format.filter.Bbox=function(e,o,t){ol.format.filter.Filter.call(this,"BBOX"),this.geometryName=e,this.extent=o,this.srsName=t},ol.inherits(ol.format.filter.Bbox,ol.format.filter.Filter),goog.provide("ol.format.filter.Comparison"),goog.require("ol"),goog.require("ol.format.filter.Filter"),ol.format.filter.Comparison=function(e,o){ol.format.filter.Filter.call(this,e),this.propertyName=o},ol.inherits(ol.format.filter.Comparison,ol.format.filter.Filter),goog.provide("ol.format.filter.ComparisonBinary"),goog.require("ol"),goog.require("ol.format.filter.Comparison"),ol.format.filter.ComparisonBinary=function(e,o,t,r){ol.format.filter.Comparison.call(this,e,o),this.expression=t,this.matchCase=r},ol.inherits(ol.format.filter.ComparisonBinary,ol.format.filter.Comparison),goog.provide("ol.format.filter.EqualTo"),goog.require("ol"),goog.require("ol.format.filter.ComparisonBinary"),ol.format.filter.EqualTo=function(e,o,t){ol.format.filter.ComparisonBinary.call(this,"PropertyIsEqualTo",e,o,t)},ol.inherits(ol.format.filter.EqualTo,ol.format.filter.ComparisonBinary),goog.provide("ol.format.filter.GreaterThan"),goog.require("ol"),goog.require("ol.format.filter.ComparisonBinary"),ol.format.filter.GreaterThan=function(e,o){ol.format.filter.ComparisonBinary.call(this,"PropertyIsGreaterThan",e,o)},ol.inherits(ol.format.filter.GreaterThan,ol.format.filter.ComparisonBinary),goog.provide("ol.format.filter.GreaterThanOrEqualTo"),goog.require("ol"),goog.require("ol.format.filter.ComparisonBinary"),ol.format.filter.GreaterThanOrEqualTo=function(e,o){ol.format.filter.ComparisonBinary.call(this,"PropertyIsGreaterThanOrEqualTo",e,o)},ol.inherits(ol.format.filter.GreaterThanOrEqualTo,ol.format.filter.ComparisonBinary);goog.provide("ol.format.filter.Spatial"),goog.require("ol"),goog.require("ol.format.filter.Filter"),ol.format.filter.Spatial=function(e,o,t,r){ol.format.filter.Filter.call(this,e),this.geometryName=o||"the_geom",this.geometry=t,this.srsName=r},ol.inherits(ol.format.filter.Spatial,ol.format.filter.Filter),goog.provide("ol.format.filter.Intersects"),goog.require("ol"),goog.require("ol.format.filter.Spatial"),ol.format.filter.Intersects=function(e,o,t){ol.format.filter.Spatial.call(this,"Intersects",e,o,t)},ol.inherits(ol.format.filter.Intersects,ol.format.filter.Spatial),goog.provide("ol.format.filter.IsBetween"),goog.require("ol"),goog.require("ol.format.filter.Comparison"),ol.format.filter.IsBetween=function(e,o,t){ol.format.filter.Comparison.call(this,"PropertyIsBetween",e),this.lowerBoundary=o,this.upperBoundary=t},ol.inherits(ol.format.filter.IsBetween,ol.format.filter.Comparison),goog.provide("ol.format.filter.IsLike"),goog.require("ol"),goog.require("ol.format.filter.Comparison"),ol.format.filter.IsLike=function(e,o,t,r,i,n){ol.format.filter.Comparison.call(this,"PropertyIsLike",e),this.pattern=o,this.wildCard=void 0!==t?t:"*",this.singleChar=void 0!==r?r:".",this.escapeChar=void 0!==i?i:"!",this.matchCase=n},ol.inherits(ol.format.filter.IsLike,ol.format.filter.Comparison),goog.provide("ol.format.filter.IsNull"),goog.require("ol"),goog.require("ol.format.filter.Comparison"),ol.format.filter.IsNull=function(e){ol.format.filter.Comparison.call(this,"PropertyIsNull",e)},ol.inherits(ol.format.filter.IsNull,ol.format.filter.Comparison),goog.provide("ol.format.filter.LessThan"),goog.require("ol"),goog.require("ol.format.filter.ComparisonBinary"),ol.format.filter.LessThan=function(e,o){ol.format.filter.ComparisonBinary.call(this,"PropertyIsLessThan",e,o)},ol.inherits(ol.format.filter.LessThan,ol.format.filter.ComparisonBinary),goog.provide("ol.format.filter.LessThanOrEqualTo"),goog.require("ol"),goog.require("ol.format.filter.ComparisonBinary"),ol.format.filter.LessThanOrEqualTo=function(e,o){ol.format.filter.ComparisonBinary.call(this,"PropertyIsLessThanOrEqualTo",e,o)},ol.inherits(ol.format.filter.LessThanOrEqualTo,ol.format.filter.ComparisonBinary),goog.provide("ol.format.filter.Not"),goog.require("ol"),goog.require("ol.format.filter.Logical"),ol.format.filter.Not=function(e){ol.format.filter.Logical.call(this,"Not"),this.condition=e},ol.inherits(ol.format.filter.Not,ol.format.filter.Logical),goog.provide("ol.format.filter.NotEqualTo"),goog.require("ol"),goog.require("ol.format.filter.ComparisonBinary"),ol.format.filter.NotEqualTo=function(e,o,t){ol.format.filter.ComparisonBinary.call(this,"PropertyIsNotEqualTo",e,o,t)},ol.inherits(ol.format.filter.NotEqualTo,ol.format.filter.ComparisonBinary),goog.provide("ol.format.filter.Or"),goog.require("ol"),goog.require("ol.format.filter.LogicalBinary"),ol.format.filter.Or=function(e,o){ol.format.filter.LogicalBinary.call(this,"Or",e,o)},ol.inherits(ol.format.filter.Or,ol.format.filter.LogicalBinary),goog.provide("ol.format.filter.Within"),goog.require("ol"),goog.require("ol.format.filter.Spatial"),ol.format.filter.Within=function(e,o,t){ol.format.filter.Spatial.call(this,"Within",e,o,t)},ol.inherits(ol.format.filter.Within,ol.format.filter.Spatial),goog.provide("ol.format.filter"),goog.require("ol"),goog.require("ol.format.filter.And"),goog.require("ol.format.filter.Bbox"),goog.require("ol.format.filter.EqualTo"),goog.require("ol.format.filter.GreaterThan"),goog.require("ol.format.filter.GreaterThanOrEqualTo"),goog.require("ol.format.filter.Intersects"),goog.require("ol.format.filter.IsBetween"),goog.require("ol.format.filter.IsLike"),goog.require("ol.format.filter.IsNull"),goog.require("ol.format.filter.LessThan"),goog.require("ol.format.filter.LessThanOrEqualTo"),goog.require("ol.format.filter.Not"),goog.require("ol.format.filter.NotEqualTo"),goog.require("ol.format.filter.Or"),goog.require("ol.format.filter.Within"),ol.format.filter.and=function(e,o){return new ol.format.filter.And(e,o)},ol.format.filter.or=function(e,o){return new ol.format.filter.Or(e,o)},ol.format.filter.not=function(e){return new ol.format.filter.Not(e)},ol.format.filter.bbox=function(e,o,t){return new ol.format.filter.Bbox(e,o,t)},ol.format.filter.intersects=function(e,o,t){return new ol.format.filter.Intersects(e,o,t)},ol.format.filter.within=function(e,o,t){return new ol.format.filter.Within(e,o,t)},ol.format.filter.equalTo=function(e,o,t){return new ol.format.filter.EqualTo(e,o,t)},ol.format.filter.notEqualTo=function(e,o,t){return new ol.format.filter.NotEqualTo(e,o,t)},ol.format.filter.lessThan=function(e,o){return new ol.format.filter.LessThan(e,o)},ol.format.filter.lessThanOrEqualTo=function(e,o){return new ol.format.filter.LessThanOrEqualTo(e,o)},ol.format.filter.greaterThan=function(e,o){return new ol.format.filter.GreaterThan(e,o)},ol.format.filter.greaterThanOrEqualTo=function(e,o){return new ol.format.filter.GreaterThanOrEqualTo(e,o)},ol.format.filter.isNull=function(e){return new ol.format.filter.IsNull(e)},ol.format.filter.between=function(e,o,t){return new ol.format.filter.IsBetween(e,o,t)},ol.format.filter.like=function(e,o,t,r,i,n){return new ol.format.filter.IsLike(e,o,t,r,i,n)},goog.provide("ol.geom.GeometryCollection"),goog.require("ol"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.geom.Geometry"),goog.require("ol.geom.GeometryType"),goog.require("ol.obj"),ol.geom.GeometryCollection=function(e){ol.geom.Geometry.call(this),this.geometries_=e||null,this.listenGeometriesChange_()},ol.inherits(ol.geom.GeometryCollection,ol.geom.Geometry),ol.geom.GeometryCollection.cloneGeometries_=function(e){var o,t,r=[];for(o=0,t=e.length;o<t;++o)r.push(e[o].clone());return r},ol.geom.GeometryCollection.prototype.unlistenGeometriesChange_=function(){var e,o;if(this.geometries_)for(e=0,o=this.geometries_.length;e<o;++e)ol.events.unlisten(this.geometries_[e],ol.events.EventType.CHANGE,this.changed,this)},ol.geom.GeometryCollection.prototype.listenGeometriesChange_=function(){var e,o;if(this.geometries_)for(e=0,o=this.geometries_.length;e<o;++e)ol.events.listen(this.geometries_[e],ol.events.EventType.CHANGE,this.changed,this)},ol.geom.GeometryCollection.prototype.clone=function(){var e=new ol.geom.GeometryCollection(null);return e.setGeometries(this.geometries_),e},ol.geom.GeometryCollection.prototype.closestPointXY=function(e,o,t,r){if(r<ol.extent.closestSquaredDistanceXY(this.getExtent(),e,o))return r;var i,n,l=this.geometries_;for(i=0,n=l.length;i<n;++i)r=l[i].closestPointXY(e,o,t,r);return r},ol.geom.GeometryCollection.prototype.containsXY=function(e,o){var t,r,i=this.geometries_;for(t=0,r=i.length;t<r;++t)if(i[t].containsXY(e,o))return!0;return!1},ol.geom.GeometryCollection.prototype.computeExtent=function(e){ol.extent.createOrUpdateEmpty(e);for(var o=this.geometries_,t=0,r=o.length;t<r;++t)ol.extent.extend(e,o[t].getExtent());return e},ol.geom.GeometryCollection.prototype.getGeometries=function(){return ol.geom.GeometryCollection.cloneGeometries_(this.geometries_)},ol.geom.GeometryCollection.prototype.getGeometriesArray=function(){return this.geometries_},ol.geom.GeometryCollection.prototype.getSimplifiedGeometry=function(e){if(this.simplifiedGeometryRevision!=this.getRevision()&&(ol.obj.clear(this.simplifiedGeometryCache),this.simplifiedGeometryMaxMinSquaredTolerance=0,this.simplifiedGeometryRevision=this.getRevision()),e<0||0!==this.simplifiedGeometryMaxMinSquaredTolerance&&e<this.simplifiedGeometryMaxMinSquaredTolerance)return this;var o=e.toString();if(this.simplifiedGeometryCache.hasOwnProperty(o))return this.simplifiedGeometryCache[o];var t,r,i=[],n=this.geometries_,l=!1;for(t=0,r=n.length;t<r;++t){var a=n[t],s=a.getSimplifiedGeometry(e);i.push(s),s!==a&&(l=!0)}if(l){var p=new ol.geom.GeometryCollection(null);return p.setGeometriesArray(i),this.simplifiedGeometryCache[o]=p,p}return this.simplifiedGeometryMaxMinSquaredTolerance=e,this},ol.geom.GeometryCollection.prototype.getType=function(){return ol.geom.GeometryType.GEOMETRY_COLLECTION},ol.geom.GeometryCollection.prototype.intersectsExtent=function(e){var o,t,r=this.geometries_;for(o=0,t=r.length;o<t;++o)if(r[o].intersectsExtent(e))return!0;return!1},ol.geom.GeometryCollection.prototype.isEmpty=function(){return 0===this.geometries_.length},ol.geom.GeometryCollection.prototype.rotate=function(e,o){for(var t=this.geometries_,r=0,i=t.length;r<i;++r)t[r].rotate(e,o);this.changed()},ol.geom.GeometryCollection.prototype.scale=function(e,o,t){var r=t;r||(r=ol.extent.getCenter(this.getExtent()));for(var i=this.geometries_,n=0,l=i.length;n<l;++n)i[n].scale(e,o,r);this.changed()},ol.geom.GeometryCollection.prototype.setGeometries=function(e){this.setGeometriesArray(ol.geom.GeometryCollection.cloneGeometries_(e))},ol.geom.GeometryCollection.prototype.setGeometriesArray=function(e){this.unlistenGeometriesChange_(),this.geometries_=e,this.listenGeometriesChange_(),this.changed()},ol.geom.GeometryCollection.prototype.applyTransform=function(e){var o,t,r=this.geometries_;for(o=0,t=r.length;o<t;++o)r[o].applyTransform(e);this.changed()},ol.geom.GeometryCollection.prototype.translate=function(e,o){var t,r,i=this.geometries_;for(t=0,r=i.length;t<r;++t)i[t].translate(e,o);this.changed()},ol.geom.GeometryCollection.prototype.disposeInternal=function(){this.unlistenGeometriesChange_(),ol.geom.Geometry.prototype.disposeInternal.call(this)},goog.provide("ol.format.GeoJSON"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.Feature"),goog.require("ol.format.Feature"),goog.require("ol.format.JSONFeature"),goog.require("ol.geom.GeometryCollection"),goog.require("ol.geom.LineString"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.MultiPoint"),goog.require("ol.geom.MultiPolygon"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.obj"),goog.require("ol.proj"),ol.format.GeoJSON=function(e){var o=e||{};ol.format.JSONFeature.call(this),this.defaultDataProjection=ol.proj.get(o.defaultDataProjection?o.defaultDataProjection:"EPSG:4326"),o.featureProjection&&(this.defaultFeatureProjection=ol.proj.get(o.featureProjection)),this.geometryName_=o.geometryName},ol.inherits(ol.format.GeoJSON,ol.format.JSONFeature),ol.format.GeoJSON.EXTENSIONS_=[".geojson"],ol.format.GeoJSON.readGeometry_=function(e,o){if(!e)return null;var t=ol.format.GeoJSON.GEOMETRY_READERS_[e.type];return ol.format.Feature.transformWithOptions(t(e),!1,o)},ol.format.GeoJSON.readGeometryCollectionGeometry_=function(e,o){ol.DEBUG&&console.assert("GeometryCollection"==e.type,"object.type should be GeometryCollection");var t=e.geometries.map(function(e){return ol.format.GeoJSON.readGeometry_(e,o)});return new ol.geom.GeometryCollection(t)},ol.format.GeoJSON.readPointGeometry_=function(e){return ol.DEBUG&&console.assert("Point"==e.type,"object.type should be Point"),new ol.geom.Point(e.coordinates)},ol.format.GeoJSON.readLineStringGeometry_=function(e){return ol.DEBUG&&console.assert("LineString"==e.type,"object.type should be LineString"),new ol.geom.LineString(e.coordinates)},ol.format.GeoJSON.readMultiLineStringGeometry_=function(e){return ol.DEBUG&&console.assert("MultiLineString"==e.type,"object.type should be MultiLineString"),new ol.geom.MultiLineString(e.coordinates)},ol.format.GeoJSON.readMultiPointGeometry_=function(e){return ol.DEBUG&&console.assert("MultiPoint"==e.type,"object.type should be MultiPoint"),new ol.geom.MultiPoint(e.coordinates)},ol.format.GeoJSON.readMultiPolygonGeometry_=function(e){return ol.DEBUG&&console.assert("MultiPolygon"==e.type,"object.type should be MultiPolygon"),new ol.geom.MultiPolygon(e.coordinates)},ol.format.GeoJSON.readPolygonGeometry_=function(e){return ol.DEBUG&&console.assert("Polygon"==e.type,"object.type should be Polygon"),new ol.geom.Polygon(e.coordinates)},ol.format.GeoJSON.writeGeometry_=function(e,o){return(0,ol.format.GeoJSON.GEOMETRY_WRITERS_[e.getType()])(ol.format.Feature.transformWithOptions(e,!0,o),o)},ol.format.GeoJSON.writeEmptyGeometryCollectionGeometry_=function(e){return{type:"GeometryCollection",geometries:[]}},ol.format.GeoJSON.writeGeometryCollectionGeometry_=function(e,o){return{type:"GeometryCollection",geometries:e.getGeometriesArray().map(function(e){var t=ol.obj.assign({},o);return delete t.featureProjection,ol.format.GeoJSON.writeGeometry_(e,t)})}},ol.format.GeoJSON.writeLineStringGeometry_=function(e,o){return{type:"LineString",coordinates:e.getCoordinates()}},ol.format.GeoJSON.writeMultiLineStringGeometry_=function(e,o){return{type:"MultiLineString",coordinates:e.getCoordinates()}},ol.format.GeoJSON.writeMultiPointGeometry_=function(e,o){return{type:"MultiPoint",coordinates:e.getCoordinates()}},ol.format.GeoJSON.writeMultiPolygonGeometry_=function(e,o){var t;return o&&(t=o.rightHanded),{type:"MultiPolygon",coordinates:e.getCoordinates(t)}},ol.format.GeoJSON.writePointGeometry_=function(e,o){return{type:"Point",coordinates:e.getCoordinates()}},ol.format.GeoJSON.writePolygonGeometry_=function(e,o){var t;return o&&(t=o.rightHanded),{type:"Polygon",coordinates:e.getCoordinates(t)}},ol.format.GeoJSON.GEOMETRY_READERS_={Point:ol.format.GeoJSON.readPointGeometry_,LineString:ol.format.GeoJSON.readLineStringGeometry_,Polygon:ol.format.GeoJSON.readPolygonGeometry_,MultiPoint:ol.format.GeoJSON.readMultiPointGeometry_,MultiLineString:ol.format.GeoJSON.readMultiLineStringGeometry_,MultiPolygon:ol.format.GeoJSON.readMultiPolygonGeometry_,GeometryCollection:ol.format.GeoJSON.readGeometryCollectionGeometry_},ol.format.GeoJSON.GEOMETRY_WRITERS_={Point:ol.format.GeoJSON.writePointGeometry_,LineString:ol.format.GeoJSON.writeLineStringGeometry_,Polygon:ol.format.GeoJSON.writePolygonGeometry_,MultiPoint:ol.format.GeoJSON.writeMultiPointGeometry_,MultiLineString:ol.format.GeoJSON.writeMultiLineStringGeometry_,MultiPolygon:ol.format.GeoJSON.writeMultiPolygonGeometry_,GeometryCollection:ol.format.GeoJSON.writeGeometryCollectionGeometry_,Circle:ol.format.GeoJSON.writeEmptyGeometryCollectionGeometry_},ol.format.GeoJSON.prototype.getExtensions=function(){return ol.format.GeoJSON.EXTENSIONS_},ol.format.GeoJSON.prototype.readFeature,ol.format.GeoJSON.prototype.readFeatures,ol.format.GeoJSON.prototype.readFeatureFromObject=function(e,o){ol.DEBUG&&console.assert("FeatureCollection"!==e.type,"Expected a Feature or geometry");var t=null;t="Feature"===e.type?e:{type:"Feature",geometry:e};var r=ol.format.GeoJSON.readGeometry_(t.geometry,o),i=new ol.Feature;return this.geometryName_&&i.setGeometryName(this.geometryName_),i.setGeometry(r),void 0!==t.id&&i.setId(t.id),t.properties&&i.setProperties(t.properties),i},ol.format.GeoJSON.prototype.readFeaturesFromObject=function(e,o){var t=e,r=null;if("FeatureCollection"===t.type){var i=e;r=[];var n,l,a=i.features;for(n=0,l=a.length;n<l;++n)r.push(this.readFeatureFromObject(a[n],o))}else r=[this.readFeatureFromObject(e,o)];return r},ol.format.GeoJSON.prototype.readGeometry,ol.format.GeoJSON.prototype.readGeometryFromObject=function(e,o){return ol.format.GeoJSON.readGeometry_(e,o)},ol.format.GeoJSON.prototype.readProjection,ol.format.GeoJSON.prototype.readProjectionFromObject=function(e){var o,t=e,r=t.crs;return r?"name"==r.type?o=ol.proj.get(r.properties.name):"EPSG"==r.type?o=ol.proj.get("EPSG:"+r.properties.code):ol.asserts.assert(!1,36):o=this.defaultDataProjection,o},ol.format.GeoJSON.prototype.writeFeature,ol.format.GeoJSON.prototype.writeFeatureObject=function(e,o){o=this.adaptOptions(o);var t={type:"Feature"},r=e.getId();void 0!==r&&(t.id=r);var i=e.getGeometry();t.geometry=i?ol.format.GeoJSON.writeGeometry_(i,o):null;var n=e.getProperties();return delete n[e.getGeometryName()],ol.obj.isEmpty(n)?t.properties=null:t.properties=n,t},ol.format.GeoJSON.prototype.writeFeatures,ol.format.GeoJSON.prototype.writeFeaturesObject=function(e,o){o=this.adaptOptions(o);var t,r,i=[];for(t=0,r=e.length;t<r;++t)i.push(this.writeFeatureObject(e[t],o));return{type:"FeatureCollection",features:i}},ol.format.GeoJSON.prototype.writeGeometry,ol.format.GeoJSON.prototype.writeGeometryObject=function(e,o){return ol.format.GeoJSON.writeGeometry_(e,this.adaptOptions(o))},goog.provide("ol.format.XMLFeature"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.format.Feature"),goog.require("ol.format.FormatType"),goog.require("ol.xml"),ol.format.XMLFeature=function(){this.xmlSerializer_=new XMLSerializer,ol.format.Feature.call(this)},ol.inherits(ol.format.XMLFeature,ol.format.Feature),ol.format.XMLFeature.prototype.getType=function(){return ol.format.FormatType.XML},ol.format.XMLFeature.prototype.readFeature=function(e,o){if(ol.xml.isDocument(e))return this.readFeatureFromDocument(e,o);if(ol.xml.isNode(e))return this.readFeatureFromNode(e,o);if("string"==typeof e){var t=ol.xml.parse(e);return this.readFeatureFromDocument(t,o)}return null},ol.format.XMLFeature.prototype.readFeatureFromDocument=function(e,o){var t=this.readFeaturesFromDocument(e,o);return t.length>0?t[0]:null},ol.format.XMLFeature.prototype.readFeatureFromNode=function(e,o){},ol.format.XMLFeature.prototype.readFeatures=function(e,o){if(ol.xml.isDocument(e))return this.readFeaturesFromDocument(e,o);if(ol.xml.isNode(e))return this.readFeaturesFromNode(e,o);if("string"==typeof e){var t=ol.xml.parse(e);return this.readFeaturesFromDocument(t,o)}return[]},ol.format.XMLFeature.prototype.readFeaturesFromDocument=function(e,o){var t,r=[];for(t=e.firstChild;t;t=t.nextSibling)t.nodeType==Node.ELEMENT_NODE&&ol.array.extend(r,this.readFeaturesFromNode(t,o));return r},ol.format.XMLFeature.prototype.readFeaturesFromNode=function(e,o){},ol.format.XMLFeature.prototype.readGeometry=function(e,o){if(ol.xml.isDocument(e))return this.readGeometryFromDocument(e,o);if(ol.xml.isNode(e))return this.readGeometryFromNode(e,o);if("string"==typeof e){var t=ol.xml.parse(e);return this.readGeometryFromDocument(t,o)}return null},ol.format.XMLFeature.prototype.readGeometryFromDocument=function(e,o){},
ol.format.XMLFeature.prototype.readGeometryFromNode=function(e,o){},ol.format.XMLFeature.prototype.readProjection=function(e){if(ol.xml.isDocument(e))return this.readProjectionFromDocument(e);if(ol.xml.isNode(e))return this.readProjectionFromNode(e);if("string"==typeof e){var o=ol.xml.parse(e);return this.readProjectionFromDocument(o)}return null},ol.format.XMLFeature.prototype.readProjectionFromDocument=function(e){return this.defaultDataProjection},ol.format.XMLFeature.prototype.readProjectionFromNode=function(e){return this.defaultDataProjection},ol.format.XMLFeature.prototype.writeFeature=function(e,o){var t=this.writeFeatureNode(e,o);return ol.DEBUG&&console.assert(t.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),this.xmlSerializer_.serializeToString(t)},ol.format.XMLFeature.prototype.writeFeatureNode=function(e,o){},ol.format.XMLFeature.prototype.writeFeatures=function(e,o){var t=this.writeFeaturesNode(e,o);return ol.DEBUG&&console.assert(t.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),this.xmlSerializer_.serializeToString(t)},ol.format.XMLFeature.prototype.writeFeaturesNode=function(e,o){},ol.format.XMLFeature.prototype.writeGeometry=function(e,o){var t=this.writeGeometryNode(e,o);return ol.DEBUG&&console.assert(t.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),this.xmlSerializer_.serializeToString(t)},ol.format.XMLFeature.prototype.writeGeometryNode=function(e,o){},goog.provide("ol.format.GMLBase"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.Feature");goog.require("ol.format.Feature"),goog.require("ol.format.XMLFeature"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.LineString"),goog.require("ol.geom.LinearRing"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.MultiPoint"),goog.require("ol.geom.MultiPolygon"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.obj"),goog.require("ol.proj"),goog.require("ol.xml"),ol.format.GMLBase=function(e){var o=e||{};this.featureType=o.featureType,this.featureNS=o.featureNS,this.srsName=o.srsName,this.schemaLocation="",this.FEATURE_COLLECTION_PARSERS={},this.FEATURE_COLLECTION_PARSERS[ol.format.GMLBase.GMLNS]={featureMember:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readFeaturesInternal),featureMembers:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readFeaturesInternal)},ol.format.XMLFeature.call(this)},ol.inherits(ol.format.GMLBase,ol.format.XMLFeature),ol.format.GMLBase.GMLNS="http://www.opengis.net/gml",ol.format.GMLBase.ONLY_WHITESPACE_RE_=/^[\s\xa0]*$/,ol.format.GMLBase.prototype.readFeaturesInternal=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT");var t=e.localName,r=null;if("FeatureCollection"==t)r="http://www.opengis.net/wfs"===e.namespaceURI?ol.xml.pushParseAndPop([],this.FEATURE_COLLECTION_PARSERS,e,o,this):ol.xml.pushParseAndPop(null,this.FEATURE_COLLECTION_PARSERS,e,o,this);else if("featureMembers"==t||"featureMember"==t){var i,n,l=o[0],a=l.featureType,s=l.featureNS;if(!a&&e.childNodes){for(a=[],s={},i=0,n=e.childNodes.length;i<n;++i){var p=e.childNodes[i];if(1===p.nodeType){var g=p.nodeName.split(":").pop();if(-1===a.indexOf(g)){var c="",u=0,y=p.namespaceURI;for(var d in s){if(s[d]===y){c=d;break}++u}c||(c="p"+u,s[c]=y),a.push(c+":"+g)}}}"featureMember"!=t&&(l.featureType=a,l.featureNS=s)}if("string"==typeof s){var h=s;s={},s.p0=h}var m={},f=Array.isArray(a)?a:[a];for(var _ in s){var E={};for(i=0,n=f.length;i<n;++i){var v=-1===f[i].indexOf(":")?"p0":f[i].split(":")[0];v===_&&(E[f[i].split(":").pop()]="featureMembers"==t?ol.xml.makeArrayPusher(this.readFeatureElement,this):ol.xml.makeReplacer(this.readFeatureElement,this))}m[s[_]]=E}r="featureMember"==t?ol.xml.pushParseAndPop(void 0,m,e,o):ol.xml.pushParseAndPop([],m,e,o)}return null===r&&(r=[]),r},ol.format.GMLBase.prototype.readGeometryElement=function(e,o){var t=o[0];t.srsName=e.firstElementChild.getAttribute("srsName");var r=ol.xml.pushParseAndPop(null,this.GEOMETRY_PARSERS_,e,o,this);return r?ol.format.Feature.transformWithOptions(r,!1,t):void 0},ol.format.GMLBase.prototype.readFeatureElement=function(e,o){var t,r,i=e.getAttribute("fid")||ol.xml.getAttributeNS(e,ol.format.GMLBase.GMLNS,"id"),n={};for(t=e.firstElementChild;t;t=t.nextElementSibling){var l=t.localName;if(0===t.childNodes.length||1===t.childNodes.length&&(3===t.firstChild.nodeType||4===t.firstChild.nodeType)){var a=ol.xml.getAllTextContent(t,!1);ol.format.GMLBase.ONLY_WHITESPACE_RE_.test(a)&&(a=void 0),n[l]=a}else"boundedBy"!==l&&(r=l),n[l]=this.readGeometryElement(t,o)}var s=new ol.Feature(n);return r&&s.setGeometryName(r),i&&s.setId(i),s},ol.format.GMLBase.prototype.readPoint=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Point"==e.localName,"localName should be Point");var t=this.readFlatCoordinatesFromNode_(e,o);if(t){var r=new ol.geom.Point(null);return ol.DEBUG&&console.assert(3==t.length,"flatCoordinates should have a length of 3"),r.setFlatCoordinates(ol.geom.GeometryLayout.XYZ,t),r}},ol.format.GMLBase.prototype.readMultiPoint=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("MultiPoint"==e.localName,"localName should be MultiPoint");var t=ol.xml.pushParseAndPop([],this.MULTIPOINT_PARSERS_,e,o,this);return t?new ol.geom.MultiPoint(t):void 0},ol.format.GMLBase.prototype.readMultiLineString=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("MultiLineString"==e.localName,"localName should be MultiLineString");var t=ol.xml.pushParseAndPop([],this.MULTILINESTRING_PARSERS_,e,o,this);if(t){var r=new ol.geom.MultiLineString(null);return r.setLineStrings(t),r}},ol.format.GMLBase.prototype.readMultiPolygon=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("MultiPolygon"==e.localName,"localName should be MultiPolygon");var t=ol.xml.pushParseAndPop([],this.MULTIPOLYGON_PARSERS_,e,o,this);if(t){var r=new ol.geom.MultiPolygon(null);return r.setPolygons(t),r}},ol.format.GMLBase.prototype.pointMemberParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("pointMember"==e.localName||"pointMembers"==e.localName,"localName should be pointMember or pointMembers"),ol.xml.parseNode(this.POINTMEMBER_PARSERS_,e,o,this)},ol.format.GMLBase.prototype.lineStringMemberParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("lineStringMember"==e.localName||"lineStringMembers"==e.localName,"localName should be LineStringMember or LineStringMembers"),ol.xml.parseNode(this.LINESTRINGMEMBER_PARSERS_,e,o,this)},ol.format.GMLBase.prototype.polygonMemberParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("polygonMember"==e.localName||"polygonMembers"==e.localName,"localName should be polygonMember or polygonMembers"),ol.xml.parseNode(this.POLYGONMEMBER_PARSERS_,e,o,this)},ol.format.GMLBase.prototype.readLineString=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("LineString"==e.localName,"localName should be LineString");var t=this.readFlatCoordinatesFromNode_(e,o);if(t){var r=new ol.geom.LineString(null);return r.setFlatCoordinates(ol.geom.GeometryLayout.XYZ,t),r}},ol.format.GMLBase.prototype.readFlatLinearRing_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("LinearRing"==e.localName,"localName should be LinearRing");var t=ol.xml.pushParseAndPop(null,this.GEOMETRY_FLAT_COORDINATES_PARSERS_,e,o,this);return t||void 0},ol.format.GMLBase.prototype.readLinearRing=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("LinearRing"==e.localName,"localName should be LinearRing");var t=this.readFlatCoordinatesFromNode_(e,o);if(t){var r=new ol.geom.LinearRing(null);return r.setFlatCoordinates(ol.geom.GeometryLayout.XYZ,t),r}},ol.format.GMLBase.prototype.readPolygon=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Polygon"==e.localName,"localName should be Polygon");var t=ol.xml.pushParseAndPop([null],this.FLAT_LINEAR_RINGS_PARSERS_,e,o,this);if(t&&t[0]){var r,i,n=new ol.geom.Polygon(null),l=t[0],a=[l.length];for(r=1,i=t.length;r<i;++r)ol.array.extend(l,t[r]),a.push(l.length);return n.setFlatCoordinates(ol.geom.GeometryLayout.XYZ,l,a),n}},ol.format.GMLBase.prototype.readFlatCoordinatesFromNode_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.xml.pushParseAndPop(null,this.GEOMETRY_FLAT_COORDINATES_PARSERS_,e,o,this)},ol.format.GMLBase.prototype.MULTIPOINT_PARSERS_={"http://www.opengis.net/gml":{pointMember:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.pointMemberParser_),pointMembers:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.pointMemberParser_)}},ol.format.GMLBase.prototype.MULTILINESTRING_PARSERS_={"http://www.opengis.net/gml":{lineStringMember:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.lineStringMemberParser_),lineStringMembers:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.lineStringMemberParser_)}},ol.format.GMLBase.prototype.MULTIPOLYGON_PARSERS_={"http://www.opengis.net/gml":{polygonMember:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.polygonMemberParser_),polygonMembers:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.polygonMemberParser_)}},ol.format.GMLBase.prototype.POINTMEMBER_PARSERS_={"http://www.opengis.net/gml":{Point:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.readFlatCoordinatesFromNode_)}},ol.format.GMLBase.prototype.LINESTRINGMEMBER_PARSERS_={"http://www.opengis.net/gml":{LineString:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.readLineString)}},ol.format.GMLBase.prototype.POLYGONMEMBER_PARSERS_={"http://www.opengis.net/gml":{Polygon:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.readPolygon)}},ol.format.GMLBase.prototype.RING_PARSERS={"http://www.opengis.net/gml":{LinearRing:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readFlatLinearRing_)}},ol.format.GMLBase.prototype.readGeometryFromNode=function(e,o){var t=this.readGeometryElement(e,[this.getReadOptions(e,o||{})]);return t||null},ol.format.GMLBase.prototype.readFeatures,ol.format.GMLBase.prototype.readFeaturesFromNode=function(e,o){var t={featureType:this.featureType,featureNS:this.featureNS};return o&&ol.obj.assign(t,this.getReadOptions(e,o)),this.readFeaturesInternal(e,[t])||[]},ol.format.GMLBase.prototype.readProjectionFromNode=function(e){return ol.proj.get(this.srsName?this.srsName:e.firstElementChild.getAttribute("srsName"))},goog.provide("ol.format.XSD"),goog.require("ol"),goog.require("ol.xml"),goog.require("ol.string"),ol.format.XSD.NAMESPACE_URI="http://www.w3.org/2001/XMLSchema",ol.format.XSD.readBoolean=function(e){var o=ol.xml.getAllTextContent(e,!1);return ol.format.XSD.readBooleanString(o)},ol.format.XSD.readBooleanString=function(e){var o=/^\s*(true|1)|(false|0)\s*$/.exec(e);return o?void 0!==o[1]||!1:void 0},ol.format.XSD.readDateTime=function(e){var o=ol.xml.getAllTextContent(e,!1),t=Date.parse(o);return isNaN(t)?void 0:t/1e3},ol.format.XSD.readDecimal=function(e){var o=ol.xml.getAllTextContent(e,!1);return ol.format.XSD.readDecimalString(o)},ol.format.XSD.readDecimalString=function(e){var o=/^\s*([+\-]?\d*\.?\d+(?:e[+\-]?\d+)?)\s*$/i.exec(e);return o?parseFloat(o[1]):void 0},ol.format.XSD.readNonNegativeInteger=function(e){var o=ol.xml.getAllTextContent(e,!1);return ol.format.XSD.readNonNegativeIntegerString(o)},ol.format.XSD.readNonNegativeIntegerString=function(e){var o=/^\s*(\d+)\s*$/.exec(e);return o?parseInt(o[1],10):void 0},ol.format.XSD.readString=function(e){return ol.xml.getAllTextContent(e,!1).trim()},ol.format.XSD.writeBooleanTextNode=function(e,o){ol.format.XSD.writeStringTextNode(e,o?"1":"0")},ol.format.XSD.writeCDATASection=function(e,o){e.appendChild(ol.xml.DOCUMENT.createCDATASection(o))},ol.format.XSD.writeDateTimeTextNode=function(e,o){var t=new Date(1e3*o),r=t.getUTCFullYear()+"-"+ol.string.padNumber(t.getUTCMonth()+1,2)+"-"+ol.string.padNumber(t.getUTCDate(),2)+"T"+ol.string.padNumber(t.getUTCHours(),2)+":"+ol.string.padNumber(t.getUTCMinutes(),2)+":"+ol.string.padNumber(t.getUTCSeconds(),2)+"Z";e.appendChild(ol.xml.DOCUMENT.createTextNode(r))},ol.format.XSD.writeDecimalTextNode=function(e,o){var t=o.toPrecision();e.appendChild(ol.xml.DOCUMENT.createTextNode(t))},ol.format.XSD.writeNonNegativeIntegerTextNode=function(e,o){ol.DEBUG&&console.assert(o>=0,"value should be more than 0"),ol.DEBUG&&console.assert(o==(0|o),"value should be an integer value");var t=o.toString();e.appendChild(ol.xml.DOCUMENT.createTextNode(t))},ol.format.XSD.writeStringTextNode=function(e,o){e.appendChild(ol.xml.DOCUMENT.createTextNode(o))},goog.provide("ol.format.GML3"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.extent"),goog.require("ol.format.Feature"),goog.require("ol.format.GMLBase"),goog.require("ol.format.XSD"),goog.require("ol.geom.Geometry"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.LineString"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.MultiPolygon"),goog.require("ol.geom.Polygon"),goog.require("ol.obj"),goog.require("ol.proj"),goog.require("ol.xml"),ol.format.GML3=function(e){var o=e||{};ol.format.GMLBase.call(this,o),this.surface_=void 0!==o.surface&&o.surface,this.curve_=void 0!==o.curve&&o.curve,this.multiCurve_=void 0===o.multiCurve||o.multiCurve,this.multiSurface_=void 0===o.multiSurface||o.multiSurface,this.schemaLocation=o.schemaLocation?o.schemaLocation:ol.format.GML3.schemaLocation_},ol.inherits(ol.format.GML3,ol.format.GMLBase),ol.format.GML3.schemaLocation_=ol.format.GMLBase.GMLNS+" http://schemas.opengis.net/gml/3.1.1/profiles/gmlsfProfile/1.0.0/gmlsf.xsd",ol.format.GML3.prototype.readMultiCurve_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("MultiCurve"==e.localName,"localName should be MultiCurve");var t=ol.xml.pushParseAndPop([],this.MULTICURVE_PARSERS_,e,o,this);if(t){var r=new ol.geom.MultiLineString(null);return r.setLineStrings(t),r}},ol.format.GML3.prototype.readMultiSurface_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("MultiSurface"==e.localName,"localName should be MultiSurface");var t=ol.xml.pushParseAndPop([],this.MULTISURFACE_PARSERS_,e,o,this);if(t){var r=new ol.geom.MultiPolygon(null);return r.setPolygons(t),r}},ol.format.GML3.prototype.curveMemberParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("curveMember"==e.localName||"curveMembers"==e.localName,"localName should be curveMember or curveMembers"),ol.xml.parseNode(this.CURVEMEMBER_PARSERS_,e,o,this)},ol.format.GML3.prototype.surfaceMemberParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("surfaceMember"==e.localName||"surfaceMembers"==e.localName,"localName should be surfaceMember or surfaceMembers"),ol.xml.parseNode(this.SURFACEMEMBER_PARSERS_,e,o,this)},ol.format.GML3.prototype.readPatch_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("patches"==e.localName,"localName should be patches"),ol.xml.pushParseAndPop([null],this.PATCHES_PARSERS_,e,o,this)},ol.format.GML3.prototype.readSegment_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("segments"==e.localName,"localName should be segments"),ol.xml.pushParseAndPop([null],this.SEGMENTS_PARSERS_,e,o,this)},ol.format.GML3.prototype.readPolygonPatch_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"npde.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("PolygonPatch"==e.localName,"localName should be PolygonPatch"),ol.xml.pushParseAndPop([null],this.FLAT_LINEAR_RINGS_PARSERS_,e,o,this)},ol.format.GML3.prototype.readLineStringSegment_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("LineStringSegment"==e.localName,"localName should be LineStringSegment"),ol.xml.pushParseAndPop([null],this.GEOMETRY_FLAT_COORDINATES_PARSERS_,e,o,this)},ol.format.GML3.prototype.interiorParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("interior"==e.localName,"localName should be interior");var t=ol.xml.pushParseAndPop(void 0,this.RING_PARSERS,e,o,this);if(t){var r=o[o.length-1];ol.DEBUG&&console.assert(Array.isArray(r),"flatLinearRings should be an array"),ol.DEBUG&&console.assert(r.length>0,"flatLinearRings should have an array length of 1 or more"),r.push(t)}},ol.format.GML3.prototype.exteriorParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("exterior"==e.localName,"localName should be exterior");var t=ol.xml.pushParseAndPop(void 0,this.RING_PARSERS,e,o,this);if(t){var r=o[o.length-1];ol.DEBUG&&console.assert(Array.isArray(r),"flatLinearRings should be an array"),ol.DEBUG&&console.assert(r.length>0,"flatLinearRings should have an array length of 1 or more"),r[0]=t}},ol.format.GML3.prototype.readSurface_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Surface"==e.localName,"localName should be Surface");var t=ol.xml.pushParseAndPop([null],this.SURFACE_PARSERS_,e,o,this);if(t&&t[0]){var r,i,n=new ol.geom.Polygon(null),l=t[0],a=[l.length];for(r=1,i=t.length;r<i;++r)ol.array.extend(l,t[r]),a.push(l.length);return n.setFlatCoordinates(ol.geom.GeometryLayout.XYZ,l,a),n}},ol.format.GML3.prototype.readCurve_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Curve"==e.localName,"localName should be Curve");var t=ol.xml.pushParseAndPop([null],this.CURVE_PARSERS_,e,o,this);if(t){var r=new ol.geom.LineString(null);return r.setFlatCoordinates(ol.geom.GeometryLayout.XYZ,t),r}},ol.format.GML3.prototype.readEnvelope_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Envelope"==e.localName,"localName should be Envelope");var t=ol.xml.pushParseAndPop([null],this.ENVELOPE_PARSERS_,e,o,this);return ol.extent.createOrUpdate(t[1][0],t[1][1],t[2][0],t[2][1])},ol.format.GML3.prototype.readFlatPos_=function(e,o){for(var t,r=ol.xml.getAllTextContent(e,!1),i=/^\s*([+\-]?\d*\.?\d+(?:[eE][+\-]?\d+)?)\s*/,n=[];t=i.exec(r);)n.push(parseFloat(t[1])),r=r.substr(t[0].length);if(""===r){var l=o[0],a=l.srsName,s="enu";if(a){s=ol.proj.get(a).getAxisOrientation()}if("neu"===s){var p,g;for(p=0,g=n.length;p<g;p+=3){var c=n[p],u=n[p+1];n[p]=u,n[p+1]=c}}var y=n.length;if(2==y&&n.push(0),0!==y)return n}},ol.format.GML3.prototype.readFlatPosList_=function(e,o){var t=ol.xml.getAllTextContent(e,!1).replace(/^\s*|\s*$/g,""),r=o[0],i=r.srsName,n=e.parentNode.getAttribute("srsDimension"),l="enu";if(i){l=ol.proj.get(i).getAxisOrientation()}var a=t.split(/\s+/),s=2;e.getAttribute("srsDimension")?s=ol.format.XSD.readNonNegativeIntegerString(e.getAttribute("srsDimension")):e.getAttribute("dimension")?s=ol.format.XSD.readNonNegativeIntegerString(e.getAttribute("dimension")):n&&(s=ol.format.XSD.readNonNegativeIntegerString(n));for(var p,g,c,u=[],y=0,d=a.length;y<d;y+=s)p=parseFloat(a[y]),g=parseFloat(a[y+1]),c=3===s?parseFloat(a[y+2]):0,"en"===l.substr(0,2)?u.push(p,g,c):u.push(g,p,c);return u},ol.format.GML3.prototype.GEOMETRY_FLAT_COORDINATES_PARSERS_={"http://www.opengis.net/gml":{pos:ol.xml.makeReplacer(ol.format.GML3.prototype.readFlatPos_),posList:ol.xml.makeReplacer(ol.format.GML3.prototype.readFlatPosList_)}},ol.format.GML3.prototype.FLAT_LINEAR_RINGS_PARSERS_={"http://www.opengis.net/gml":{interior:ol.format.GML3.prototype.interiorParser_,exterior:ol.format.GML3.prototype.exteriorParser_}},ol.format.GML3.prototype.GEOMETRY_PARSERS_={"http://www.opengis.net/gml":{Point:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readPoint),MultiPoint:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readMultiPoint),LineString:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readLineString),MultiLineString:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readMultiLineString),LinearRing:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readLinearRing),Polygon:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readPolygon),MultiPolygon:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readMultiPolygon),Surface:ol.xml.makeReplacer(ol.format.GML3.prototype.readSurface_),MultiSurface:ol.xml.makeReplacer(ol.format.GML3.prototype.readMultiSurface_),Curve:ol.xml.makeReplacer(ol.format.GML3.prototype.readCurve_),MultiCurve:ol.xml.makeReplacer(ol.format.GML3.prototype.readMultiCurve_),Envelope:ol.xml.makeReplacer(ol.format.GML3.prototype.readEnvelope_)}},ol.format.GML3.prototype.MULTICURVE_PARSERS_={"http://www.opengis.net/gml":{curveMember:ol.xml.makeArrayPusher(ol.format.GML3.prototype.curveMemberParser_),curveMembers:ol.xml.makeArrayPusher(ol.format.GML3.prototype.curveMemberParser_)}},ol.format.GML3.prototype.MULTISURFACE_PARSERS_={"http://www.opengis.net/gml":{surfaceMember:ol.xml.makeArrayPusher(ol.format.GML3.prototype.surfaceMemberParser_),surfaceMembers:ol.xml.makeArrayPusher(ol.format.GML3.prototype.surfaceMemberParser_)}},ol.format.GML3.prototype.CURVEMEMBER_PARSERS_={"http://www.opengis.net/gml":{LineString:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.readLineString),Curve:ol.xml.makeArrayPusher(ol.format.GML3.prototype.readCurve_)}},ol.format.GML3.prototype.SURFACEMEMBER_PARSERS_={"http://www.opengis.net/gml":{Polygon:ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.readPolygon),Surface:ol.xml.makeArrayPusher(ol.format.GML3.prototype.readSurface_)}},ol.format.GML3.prototype.SURFACE_PARSERS_={"http://www.opengis.net/gml":{patches:ol.xml.makeReplacer(ol.format.GML3.prototype.readPatch_)}},ol.format.GML3.prototype.CURVE_PARSERS_={"http://www.opengis.net/gml":{segments:ol.xml.makeReplacer(ol.format.GML3.prototype.readSegment_)}},ol.format.GML3.prototype.ENVELOPE_PARSERS_={"http://www.opengis.net/gml":{lowerCorner:ol.xml.makeArrayPusher(ol.format.GML3.prototype.readFlatPosList_),upperCorner:ol.xml.makeArrayPusher(ol.format.GML3.prototype.readFlatPosList_)}},ol.format.GML3.prototype.PATCHES_PARSERS_={"http://www.opengis.net/gml":{PolygonPatch:ol.xml.makeReplacer(ol.format.GML3.prototype.readPolygonPatch_)}},ol.format.GML3.prototype.SEGMENTS_PARSERS_={"http://www.opengis.net/gml":{LineStringSegment:ol.xml.makeReplacer(ol.format.GML3.prototype.readLineStringSegment_)}},ol.format.GML3.prototype.writePos_=function(e,o,t){var r=t[t.length-1],i=r.srsName,n="enu";i&&(n=ol.proj.get(i).getAxisOrientation());var l,a=o.getCoordinates();l="en"===n.substr(0,2)?a[0]+" "+a[1]:a[1]+" "+a[0],ol.format.XSD.writeStringTextNode(e,l)},ol.format.GML3.prototype.getCoords_=function(e,o){var t="enu";return o&&(t=ol.proj.get(o).getAxisOrientation()),"en"===t.substr(0,2)?e[0]+" "+e[1]:e[1]+" "+e[0]},ol.format.GML3.prototype.writePosList_=function(e,o,t){for(var r,i=t[t.length-1],n=i.srsName,l=o.getCoordinates(),a=l.length,s=new Array(a),p=0;p<a;++p)r=l[p],s[p]=this.getCoords_(r,n);ol.format.XSD.writeStringTextNode(e,s.join(" "))},ol.format.GML3.prototype.writePoint_=function(e,o,t){var r=t[t.length-1],i=r.srsName;i&&e.setAttribute("srsName",i);var n=ol.xml.createElementNS(e.namespaceURI,"pos");e.appendChild(n),this.writePos_(n,o,t)},ol.format.GML3.ENVELOPE_SERIALIZERS_={"http://www.opengis.net/gml":{lowerCorner:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),upperCorner:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode)}},ol.format.GML3.prototype.writeEnvelope=function(e,o,t){ol.DEBUG&&console.assert(4==o.length,"extent should have 4 items");var r=t[t.length-1],i=r.srsName;i&&e.setAttribute("srsName",i);var n=["lowerCorner","upperCorner"],l=[o[0]+" "+o[1],o[2]+" "+o[3]];ol.xml.pushSerializeAndPop({node:e},ol.format.GML3.ENVELOPE_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,l,t,n,this)},ol.format.GML3.prototype.writeLinearRing_=function(e,o,t){var r=t[t.length-1],i=r.srsName;i&&e.setAttribute("srsName",i);var n=ol.xml.createElementNS(e.namespaceURI,"posList");e.appendChild(n),this.writePosList_(n,o,t)},ol.format.GML3.prototype.RING_NODE_FACTORY_=function(e,o,t){var r=o[o.length-1],i=r.node,n=r.exteriorWritten;return void 0===n&&(r.exteriorWritten=!0),ol.xml.createElementNS(i.namespaceURI,void 0!==n?"interior":"exterior")},ol.format.GML3.prototype.writeSurfaceOrPolygon_=function(e,o,t){var r=t[t.length-1],i=r.srsName;if("PolygonPatch"!==e.nodeName&&i&&e.setAttribute("srsName",i),"Polygon"===e.nodeName||"PolygonPatch"===e.nodeName){var n=o.getLinearRings();ol.xml.pushSerializeAndPop({node:e,srsName:i},ol.format.GML3.RING_SERIALIZERS_,this.RING_NODE_FACTORY_,n,t,void 0,this)}else if("Surface"===e.nodeName){var l=ol.xml.createElementNS(e.namespaceURI,"patches");e.appendChild(l),this.writeSurfacePatches_(l,o,t)}},ol.format.GML3.prototype.writeCurveOrLineString_=function(e,o,t){var r=t[t.length-1],i=r.srsName;if("LineStringSegment"!==e.nodeName&&i&&e.setAttribute("srsName",i),"LineString"===e.nodeName||"LineStringSegment"===e.nodeName){var n=ol.xml.createElementNS(e.namespaceURI,"posList");e.appendChild(n),this.writePosList_(n,o,t)}else if("Curve"===e.nodeName){var l=ol.xml.createElementNS(e.namespaceURI,"segments");e.appendChild(l),this.writeCurveSegments_(l,o,t)}},ol.format.GML3.prototype.writeMultiSurfaceOrPolygon_=function(e,o,t){var r=t[t.length-1],i=r.srsName,n=r.surface;i&&e.setAttribute("srsName",i);var l=o.getPolygons();ol.xml.pushSerializeAndPop({node:e,srsName:i,surface:n},ol.format.GML3.SURFACEORPOLYGONMEMBER_SERIALIZERS_,this.MULTIGEOMETRY_MEMBER_NODE_FACTORY_,l,t,void 0,this)},ol.format.GML3.prototype.writeMultiPoint_=function(e,o,t){var r=t[t.length-1],i=r.srsName;i&&e.setAttribute("srsName",i);var n=o.getPoints();ol.xml.pushSerializeAndPop({node:e,srsName:i},ol.format.GML3.POINTMEMBER_SERIALIZERS_,ol.xml.makeSimpleNodeFactory("pointMember"),n,t,void 0,this)},ol.format.GML3.prototype.writeMultiCurveOrLineString_=function(e,o,t){var r=t[t.length-1],i=r.srsName,n=r.curve;i&&e.setAttribute("srsName",i);var l=o.getLineStrings();ol.xml.pushSerializeAndPop({node:e,srsName:i,curve:n},ol.format.GML3.LINESTRINGORCURVEMEMBER_SERIALIZERS_,this.MULTIGEOMETRY_MEMBER_NODE_FACTORY_,l,t,void 0,this)},ol.format.GML3.prototype.writeRing_=function(e,o,t){var r=ol.xml.createElementNS(e.namespaceURI,"LinearRing");e.appendChild(r),this.writeLinearRing_(r,o,t)},ol.format.GML3.prototype.writeSurfaceOrPolygonMember_=function(e,o,t){var r=this.GEOMETRY_NODE_FACTORY_(o,t);r&&(e.appendChild(r),this.writeSurfaceOrPolygon_(r,o,t))},ol.format.GML3.prototype.writePointMember_=function(e,o,t){var r=ol.xml.createElementNS(e.namespaceURI,"Point");e.appendChild(r),this.writePoint_(r,o,t)},ol.format.GML3.prototype.writeLineStringOrCurveMember_=function(e,o,t){var r=this.GEOMETRY_NODE_FACTORY_(o,t);r&&(e.appendChild(r),this.writeCurveOrLineString_(r,o,t))},ol.format.GML3.prototype.writeSurfacePatches_=function(e,o,t){var r=ol.xml.createElementNS(e.namespaceURI,"PolygonPatch");e.appendChild(r),this.writeSurfaceOrPolygon_(r,o,t)},ol.format.GML3.prototype.writeCurveSegments_=function(e,o,t){var r=ol.xml.createElementNS(e.namespaceURI,"LineStringSegment");e.appendChild(r),this.writeCurveOrLineString_(r,o,t)},ol.format.GML3.prototype.writeGeometryElement=function(e,o,t){var r=t[t.length-1],i=ol.obj.assign({},r);i.node=e;var n;n=Array.isArray(o)?r.dataProjection?ol.proj.transformExtent(o,r.featureProjection,r.dataProjection):o:ol.format.Feature.transformWithOptions(o,!0,r),ol.xml.pushSerializeAndPop(i,ol.format.GML3.GEOMETRY_SERIALIZERS_,this.GEOMETRY_NODE_FACTORY_,[n],t,void 0,this)},ol.format.GML3.prototype.writeFeatureElement=function(e,o,t){var r=o.getId();r&&e.setAttribute("fid",r);var i=t[t.length-1],n=i.featureNS,l=o.getGeometryName();i.serializers||(i.serializers={},i.serializers[n]={});var a=o.getProperties(),s=[],p=[];for(var g in a){var c=a[g];null!==c&&(s.push(g),p.push(c),g==l||c instanceof ol.geom.Geometry?g in i.serializers[n]||(i.serializers[n][g]=ol.xml.makeChildAppender(this.writeGeometryElement,this)):g in i.serializers[n]||(i.serializers[n][g]=ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode)))}var u=ol.obj.assign({},i);u.node=e,ol.xml.pushSerializeAndPop(u,i.serializers,ol.xml.makeSimpleNodeFactory(void 0,n),p,t,s)},ol.format.GML3.prototype.writeFeatureMembers_=function(e,o,t){var r=t[t.length-1],i=r.featureType,n=r.featureNS,l={};l[n]={},l[n][i]=ol.xml.makeChildAppender(this.writeFeatureElement,this);var a=ol.obj.assign({},r);a.node=e,ol.xml.pushSerializeAndPop(a,l,ol.xml.makeSimpleNodeFactory(i,n),o,t)},ol.format.GML3.SURFACEORPOLYGONMEMBER_SERIALIZERS_={"http://www.opengis.net/gml":{surfaceMember:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeSurfaceOrPolygonMember_),polygonMember:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeSurfaceOrPolygonMember_)}},ol.format.GML3.POINTMEMBER_SERIALIZERS_={"http://www.opengis.net/gml":{pointMember:ol.xml.makeChildAppender(ol.format.GML3.prototype.writePointMember_)}},ol.format.GML3.LINESTRINGORCURVEMEMBER_SERIALIZERS_={"http://www.opengis.net/gml":{lineStringMember:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeLineStringOrCurveMember_),curveMember:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeLineStringOrCurveMember_)}},ol.format.GML3.RING_SERIALIZERS_={"http://www.opengis.net/gml":{exterior:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeRing_),interior:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeRing_)}},ol.format.GML3.GEOMETRY_SERIALIZERS_={"http://www.opengis.net/gml":{Curve:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeCurveOrLineString_),MultiCurve:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeMultiCurveOrLineString_),Point:ol.xml.makeChildAppender(ol.format.GML3.prototype.writePoint_),MultiPoint:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeMultiPoint_),LineString:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeCurveOrLineString_),MultiLineString:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeMultiCurveOrLineString_),LinearRing:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeLinearRing_),Polygon:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeSurfaceOrPolygon_),MultiPolygon:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeMultiSurfaceOrPolygon_),Surface:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeSurfaceOrPolygon_),MultiSurface:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeMultiSurfaceOrPolygon_),Envelope:ol.xml.makeChildAppender(ol.format.GML3.prototype.writeEnvelope)}},ol.format.GML3.MULTIGEOMETRY_TO_MEMBER_NODENAME_={MultiLineString:"lineStringMember",MultiCurve:"curveMember",MultiPolygon:"polygonMember",MultiSurface:"surfaceMember"},ol.format.GML3.prototype.MULTIGEOMETRY_MEMBER_NODE_FACTORY_=function(e,o,t){var r=o[o.length-1].node;return ol.DEBUG&&console.assert(ol.xml.isNode(r),"parentNode should be a node"),
ol.xml.createElementNS("http://www.opengis.net/gml",ol.format.GML3.MULTIGEOMETRY_TO_MEMBER_NODENAME_[r.nodeName])},ol.format.GML3.prototype.GEOMETRY_NODE_FACTORY_=function(e,o,t){var r=o[o.length-1],i=r.multiSurface,n=r.surface,l=r.curve,a=r.multiCurve,s=o[o.length-1].node;ol.DEBUG&&console.assert(ol.xml.isNode(s),"parentNode should be a node");var p;return Array.isArray(e)?p="Envelope":(p=e.getType(),"MultiPolygon"===p&&!0===i?p="MultiSurface":"Polygon"===p&&!0===n?p="Surface":"LineString"===p&&!0===l?p="Curve":"MultiLineString"===p&&!0===a&&(p="MultiCurve")),ol.xml.createElementNS("http://www.opengis.net/gml",p)},ol.format.GML3.prototype.writeGeometryNode=function(e,o){o=this.adaptOptions(o);var t=ol.xml.createElementNS("http://www.opengis.net/gml","geom"),r={node:t,srsName:this.srsName,curve:this.curve_,surface:this.surface_,multiSurface:this.multiSurface_,multiCurve:this.multiCurve_};return o&&ol.obj.assign(r,o),this.writeGeometryElement(t,e,[r]),t},ol.format.GML3.prototype.writeFeatures,ol.format.GML3.prototype.writeFeaturesNode=function(e,o){o=this.adaptOptions(o);var t=ol.xml.createElementNS("http://www.opengis.net/gml","featureMembers");ol.xml.setAttributeNS(t,"http://www.w3.org/2001/XMLSchema-instance","xsi:schemaLocation",this.schemaLocation);var r={srsName:this.srsName,curve:this.curve_,surface:this.surface_,multiSurface:this.multiSurface_,multiCurve:this.multiCurve_,featureNS:this.featureNS,featureType:this.featureType};return o&&ol.obj.assign(r,o),this.writeFeatureMembers_(t,e,[r]),t},goog.provide("ol.format.GML"),goog.require("ol.format.GML3"),ol.format.GML=ol.format.GML3,ol.format.GML.prototype.writeFeatures,ol.format.GML.prototype.writeFeaturesNode,goog.provide("ol.format.GML2"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.format.GMLBase"),goog.require("ol.format.XSD"),goog.require("ol.proj"),goog.require("ol.xml"),ol.format.GML2=function(e){var o=e||{};ol.format.GMLBase.call(this,o),this.FEATURE_COLLECTION_PARSERS[ol.format.GMLBase.GMLNS].featureMember=ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.readFeaturesInternal),this.schemaLocation=o.schemaLocation?o.schemaLocation:ol.format.GML2.schemaLocation_},ol.inherits(ol.format.GML2,ol.format.GMLBase),ol.format.GML2.schemaLocation_=ol.format.GMLBase.GMLNS+" http://schemas.opengis.net/gml/2.1.2/feature.xsd",ol.format.GML2.prototype.readFlatCoordinates_=function(e,o){var t=ol.xml.getAllTextContent(e,!1).replace(/^\s*|\s*$/g,""),r=o[0],i=r.srsName,n=e.parentNode.getAttribute("srsDimension"),l="enu";if(i){var a=ol.proj.get(i);a&&(l=a.getAxisOrientation())}var s=t.split(/[\s,]+/),p=2;e.getAttribute("srsDimension")?p=ol.format.XSD.readNonNegativeIntegerString(e.getAttribute("srsDimension")):e.getAttribute("dimension")?p=ol.format.XSD.readNonNegativeIntegerString(e.getAttribute("dimension")):n&&(p=ol.format.XSD.readNonNegativeIntegerString(n));for(var g,c,u,y=[],d=0,h=s.length;d<h;d+=p)g=parseFloat(s[d]),c=parseFloat(s[d+1]),u=3===p?parseFloat(s[d+2]):0,"en"===l.substr(0,2)?y.push(g,c,u):y.push(c,g,u);return y},ol.format.GML2.prototype.readBox_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Box"==e.localName,"localName should be Box");var t=ol.xml.pushParseAndPop([null],this.BOX_PARSERS_,e,o,this);return ol.extent.createOrUpdate(t[1][0],t[1][1],t[1][3],t[1][4])},ol.format.GML2.prototype.innerBoundaryIsParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("innerBoundaryIs"==e.localName,"localName should be innerBoundaryIs");var t=ol.xml.pushParseAndPop(void 0,this.RING_PARSERS,e,o,this);if(t){var r=o[o.length-1];ol.DEBUG&&console.assert(Array.isArray(r),"flatLinearRings should be an array"),ol.DEBUG&&console.assert(r.length>0,"flatLinearRings should have an array length larger than 0"),r.push(t)}},ol.format.GML2.prototype.outerBoundaryIsParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("outerBoundaryIs"==e.localName,"localName should be outerBoundaryIs");var t=ol.xml.pushParseAndPop(void 0,this.RING_PARSERS,e,o,this);if(t){var r=o[o.length-1];ol.DEBUG&&console.assert(Array.isArray(r),"flatLinearRings should be an array"),ol.DEBUG&&console.assert(r.length>0,"flatLinearRings should have an array length larger than 0"),r[0]=t}},ol.format.GML2.prototype.GEOMETRY_FLAT_COORDINATES_PARSERS_={"http://www.opengis.net/gml":{coordinates:ol.xml.makeReplacer(ol.format.GML2.prototype.readFlatCoordinates_)}},ol.format.GML2.prototype.FLAT_LINEAR_RINGS_PARSERS_={"http://www.opengis.net/gml":{innerBoundaryIs:ol.format.GML2.prototype.innerBoundaryIsParser_,outerBoundaryIs:ol.format.GML2.prototype.outerBoundaryIsParser_}},ol.format.GML2.prototype.BOX_PARSERS_={"http://www.opengis.net/gml":{coordinates:ol.xml.makeArrayPusher(ol.format.GML2.prototype.readFlatCoordinates_)}},ol.format.GML2.prototype.GEOMETRY_PARSERS_={"http://www.opengis.net/gml":{Point:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readPoint),MultiPoint:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readMultiPoint),LineString:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readLineString),MultiLineString:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readMultiLineString),LinearRing:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readLinearRing),Polygon:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readPolygon),MultiPolygon:ol.xml.makeReplacer(ol.format.GMLBase.prototype.readMultiPolygon),Box:ol.xml.makeReplacer(ol.format.GML2.prototype.readBox_)}},goog.provide("ol.format.GPX"),goog.require("ol"),goog.require("ol.Feature"),goog.require("ol.array"),goog.require("ol.format.Feature"),goog.require("ol.format.XMLFeature"),goog.require("ol.format.XSD"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.LineString"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.Point"),goog.require("ol.proj"),goog.require("ol.xml"),ol.format.GPX=function(e){var o=e||{};ol.format.XMLFeature.call(this),this.defaultDataProjection=ol.proj.get("EPSG:4326"),this.readExtensions_=o.readExtensions},ol.inherits(ol.format.GPX,ol.format.XMLFeature),ol.format.GPX.NAMESPACE_URIS_=[null,"http://www.topografix.com/GPX/1/0","http://www.topografix.com/GPX/1/1"],ol.format.GPX.SCHEMA_LOCATION_="http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd",ol.format.GPX.appendCoordinate_=function(e,o,t,r){return ol.DEBUG&&console.assert(t.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),e.push(parseFloat(t.getAttribute("lon")),parseFloat(t.getAttribute("lat"))),"ele"in r?(e.push(r.ele),delete r.ele,o.hasZ=!0):e.push(0),"time"in r?(e.push(r.time),delete r.time,o.hasM=!0):e.push(0),e},ol.format.GPX.applyLayoutOptions_=function(e,o,t){var r=ol.geom.GeometryLayout.XY,i=2;if(e.hasZ&&e.hasM?(r=ol.geom.GeometryLayout.XYZM,i=4):e.hasZ?(r=ol.geom.GeometryLayout.XYZ,i=3):e.hasM&&(r=ol.geom.GeometryLayout.XYM,i=3),4!==i){var n,l;for(n=0,l=o.length/4;n<l;n++)o[n*i]=o[4*n],o[n*i+1]=o[4*n+1],e.hasZ&&(o[n*i+2]=o[4*n+2]),e.hasM&&(o[n*i+2]=o[4*n+3]);if(o.length=o.length/4*i,t)for(n=0,l=t.length;n<l;n++)t[n]=t[n]/4*i}return r},ol.format.GPX.parseLink_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("link"==e.localName,"localName should be link");var t=o[o.length-1],r=e.getAttribute("href");null!==r&&(t.link=r),ol.xml.parseNode(ol.format.GPX.LINK_PARSERS_,e,o)},ol.format.GPX.parseExtensions_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("extensions"==e.localName,"localName should be extensions"),o[o.length-1].extensionsNode_=e},ol.format.GPX.parseRtePt_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("rtept"==e.localName,"localName should be rtept");var t=ol.xml.pushParseAndPop({},ol.format.GPX.RTEPT_PARSERS_,e,o);if(t){var r=o[o.length-1],i=r.flatCoordinates,n=r.layoutOptions;ol.format.GPX.appendCoordinate_(i,n,e,t)}},ol.format.GPX.parseTrkPt_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("trkpt"==e.localName,"localName should be trkpt");var t=ol.xml.pushParseAndPop({},ol.format.GPX.TRKPT_PARSERS_,e,o);if(t){var r=o[o.length-1],i=r.flatCoordinates,n=r.layoutOptions;ol.format.GPX.appendCoordinate_(i,n,e,t)}},ol.format.GPX.parseTrkSeg_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("trkseg"==e.localName,"localName should be trkseg");var t=o[o.length-1];ol.xml.parseNode(ol.format.GPX.TRKSEG_PARSERS_,e,o);var r=t.flatCoordinates;t.ends.push(r.length)},ol.format.GPX.readRte_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("rte"==e.localName,"localName should be rte");var t=o[0],r=ol.xml.pushParseAndPop({flatCoordinates:[],layoutOptions:{}},ol.format.GPX.RTE_PARSERS_,e,o);if(r){var i=r.flatCoordinates;delete r.flatCoordinates;var n=r.layoutOptions;delete r.layoutOptions;var l=ol.format.GPX.applyLayoutOptions_(n,i),a=new ol.geom.LineString(null);a.setFlatCoordinates(l,i),ol.format.Feature.transformWithOptions(a,!1,t);var s=new ol.Feature(a);return s.setProperties(r),s}},ol.format.GPX.readTrk_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("trk"==e.localName,"localName should be trk");var t=o[0],r=ol.xml.pushParseAndPop({flatCoordinates:[],ends:[],layoutOptions:{}},ol.format.GPX.TRK_PARSERS_,e,o);if(r){var i=r.flatCoordinates;delete r.flatCoordinates;var n=r.ends;delete r.ends;var l=r.layoutOptions;delete r.layoutOptions;var a=ol.format.GPX.applyLayoutOptions_(l,i,n),s=new ol.geom.MultiLineString(null);s.setFlatCoordinates(a,i,n),ol.format.Feature.transformWithOptions(s,!1,t);var p=new ol.Feature(s);return p.setProperties(r),p}},ol.format.GPX.readWpt_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("wpt"==e.localName,"localName should be wpt");var t=o[0],r=ol.xml.pushParseAndPop({},ol.format.GPX.WPT_PARSERS_,e,o);if(r){var i={},n=ol.format.GPX.appendCoordinate_([],i,e,r),l=ol.format.GPX.applyLayoutOptions_(i,n),a=new ol.geom.Point(n,l);ol.format.Feature.transformWithOptions(a,!1,t);var s=new ol.Feature(a);return s.setProperties(r),s}},ol.format.GPX.FEATURE_READER_={rte:ol.format.GPX.readRte_,trk:ol.format.GPX.readTrk_,wpt:ol.format.GPX.readWpt_},ol.format.GPX.GPX_PARSERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{rte:ol.xml.makeArrayPusher(ol.format.GPX.readRte_),trk:ol.xml.makeArrayPusher(ol.format.GPX.readTrk_),wpt:ol.xml.makeArrayPusher(ol.format.GPX.readWpt_)}),ol.format.GPX.LINK_PARSERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{text:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString,"linkText"),type:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString,"linkType")}),ol.format.GPX.RTE_PARSERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{name:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),cmt:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),desc:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),src:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),link:ol.format.GPX.parseLink_,number:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),extensions:ol.format.GPX.parseExtensions_,type:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),rtept:ol.format.GPX.parseRtePt_}),ol.format.GPX.RTEPT_PARSERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{ele:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),time:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDateTime)}),ol.format.GPX.TRK_PARSERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{name:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),cmt:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),desc:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),src:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),link:ol.format.GPX.parseLink_,number:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),type:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),extensions:ol.format.GPX.parseExtensions_,trkseg:ol.format.GPX.parseTrkSeg_}),ol.format.GPX.TRKSEG_PARSERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{trkpt:ol.format.GPX.parseTrkPt_}),ol.format.GPX.TRKPT_PARSERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{ele:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),time:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDateTime)}),ol.format.GPX.WPT_PARSERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{ele:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),time:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDateTime),magvar:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),geoidheight:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),name:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),cmt:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),desc:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),src:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),link:ol.format.GPX.parseLink_,sym:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),type:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),fix:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),sat:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),hdop:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),vdop:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),pdop:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),ageofdgpsdata:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),dgpsid:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),extensions:ol.format.GPX.parseExtensions_});ol.format.GPX.prototype.handleReadExtensions_=function(e){e||(e=[]);for(var o=0,t=e.length;o<t;++o){var r=e[o];if(this.readExtensions_){var i=r.get("extensionsNode_")||null;this.readExtensions_(r,i)}r.set("extensionsNode_",void 0)}},ol.format.GPX.prototype.readFeature,ol.format.GPX.prototype.readFeatureFromNode=function(e,o){if(ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),!ol.array.includes(ol.format.GPX.NAMESPACE_URIS_,e.namespaceURI))return null;var t=ol.format.GPX.FEATURE_READER_[e.localName];if(!t)return null;var r=t(e,[this.getReadOptions(e,o)]);return r?(this.handleReadExtensions_([r]),r):null},ol.format.GPX.prototype.readFeatures,ol.format.GPX.prototype.readFeaturesFromNode=function(e,o){if(ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),!ol.array.includes(ol.format.GPX.NAMESPACE_URIS_,e.namespaceURI))return[];if("gpx"==e.localName){var t=ol.xml.pushParseAndPop([],ol.format.GPX.GPX_PARSERS_,e,[this.getReadOptions(e,o)]);return t?(this.handleReadExtensions_(t),t):[]}return[]},ol.format.GPX.prototype.readProjection,ol.format.GPX.writeLink_=function(e,o,t){e.setAttribute("href",o);var r=t[t.length-1],i=r.properties,n=[i.linkText,i.linkType];ol.xml.pushSerializeAndPop({node:e},ol.format.GPX.LINK_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,n,t,ol.format.GPX.LINK_SEQUENCE_)},ol.format.GPX.writeWptType_=function(e,o,t){var r=t[t.length-1],i=r.node;ol.DEBUG&&console.assert(ol.xml.isNode(i),"parentNode should be an XML node");var n=i.namespaceURI,l=r.properties;switch(ol.xml.setAttributeNS(e,null,"lat",o[1]),ol.xml.setAttributeNS(e,null,"lon",o[0]),r.geometryLayout){case ol.geom.GeometryLayout.XYZM:0!==o[3]&&(l.time=o[3]);case ol.geom.GeometryLayout.XYZ:0!==o[2]&&(l.ele=o[2]);break;case ol.geom.GeometryLayout.XYM:0!==o[2]&&(l.time=o[2])}var a="rtept"==e.nodeName?ol.format.GPX.RTEPT_TYPE_SEQUENCE_[n]:ol.format.GPX.WPT_TYPE_SEQUENCE_[n],s=ol.xml.makeSequence(l,a);ol.xml.pushSerializeAndPop({node:e,properties:l},ol.format.GPX.WPT_TYPE_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,s,t,a)},ol.format.GPX.writeRte_=function(e,o,t){var r=t[0],i=o.getProperties(),n={node:e,properties:i},l=o.getGeometry();l&&(l=ol.format.Feature.transformWithOptions(l,!0,r),n.geometryLayout=l.getLayout(),i.rtept=l.getCoordinates());var a=t[t.length-1].node,s=ol.format.GPX.RTE_SEQUENCE_[a.namespaceURI],p=ol.xml.makeSequence(i,s);ol.xml.pushSerializeAndPop(n,ol.format.GPX.RTE_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,p,t,s)},ol.format.GPX.writeTrk_=function(e,o,t){var r=t[0],i=o.getProperties(),n={node:e,properties:i},l=o.getGeometry();l&&(l=ol.format.Feature.transformWithOptions(l,!0,r),i.trkseg=l.getLineStrings());var a=t[t.length-1].node,s=ol.format.GPX.TRK_SEQUENCE_[a.namespaceURI],p=ol.xml.makeSequence(i,s);ol.xml.pushSerializeAndPop(n,ol.format.GPX.TRK_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,p,t,s)},ol.format.GPX.writeTrkSeg_=function(e,o,t){var r={node:e,geometryLayout:o.getLayout(),properties:{}};ol.xml.pushSerializeAndPop(r,ol.format.GPX.TRKSEG_SERIALIZERS_,ol.format.GPX.TRKSEG_NODE_FACTORY_,o.getCoordinates(),t)},ol.format.GPX.writeWpt_=function(e,o,t){var r=t[0],i=t[t.length-1];i.properties=o.getProperties();var n=o.getGeometry();n&&(n=ol.format.Feature.transformWithOptions(n,!0,r),i.geometryLayout=n.getLayout(),ol.format.GPX.writeWptType_(e,n.getCoordinates(),t))},ol.format.GPX.LINK_SEQUENCE_=["text","type"],ol.format.GPX.LINK_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{text:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),type:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode)}),ol.format.GPX.RTE_SEQUENCE_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,["name","cmt","desc","src","link","number","type","rtept"]),ol.format.GPX.RTE_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{name:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),cmt:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),desc:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),src:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),link:ol.xml.makeChildAppender(ol.format.GPX.writeLink_),number:ol.xml.makeChildAppender(ol.format.XSD.writeNonNegativeIntegerTextNode),type:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),rtept:ol.xml.makeArraySerializer(ol.xml.makeChildAppender(ol.format.GPX.writeWptType_))}),ol.format.GPX.RTEPT_TYPE_SEQUENCE_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,["ele","time"]),ol.format.GPX.TRK_SEQUENCE_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,["name","cmt","desc","src","link","number","type","trkseg"]),ol.format.GPX.TRK_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{name:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),cmt:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),desc:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),src:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),link:ol.xml.makeChildAppender(ol.format.GPX.writeLink_),number:ol.xml.makeChildAppender(ol.format.XSD.writeNonNegativeIntegerTextNode),type:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),trkseg:ol.xml.makeArraySerializer(ol.xml.makeChildAppender(ol.format.GPX.writeTrkSeg_))}),ol.format.GPX.TRKSEG_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("trkpt"),ol.format.GPX.TRKSEG_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{trkpt:ol.xml.makeChildAppender(ol.format.GPX.writeWptType_)}),ol.format.GPX.WPT_TYPE_SEQUENCE_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,["ele","time","magvar","geoidheight","name","cmt","desc","src","link","sym","type","fix","sat","hdop","vdop","pdop","ageofdgpsdata","dgpsid"]),ol.format.GPX.WPT_TYPE_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{ele:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),time:ol.xml.makeChildAppender(ol.format.XSD.writeDateTimeTextNode),magvar:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),geoidheight:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),name:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),cmt:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),desc:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),src:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),link:ol.xml.makeChildAppender(ol.format.GPX.writeLink_),sym:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),type:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),fix:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),sat:ol.xml.makeChildAppender(ol.format.XSD.writeNonNegativeIntegerTextNode),hdop:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),vdop:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),pdop:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),ageofdgpsdata:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),dgpsid:ol.xml.makeChildAppender(ol.format.XSD.writeNonNegativeIntegerTextNode)}),ol.format.GPX.GEOMETRY_TYPE_TO_NODENAME_={Point:"wpt",LineString:"rte",MultiLineString:"trk"},ol.format.GPX.GPX_NODE_FACTORY_=function(e,o,t){var r=e.getGeometry();if(r){var i=ol.format.GPX.GEOMETRY_TYPE_TO_NODENAME_[r.getType()];if(i){var n=o[o.length-1].node;return ol.DEBUG&&console.assert(ol.xml.isNode(n),"parentNode should be an XML node"),ol.xml.createElementNS(n.namespaceURI,i)}}},ol.format.GPX.GPX_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.GPX.NAMESPACE_URIS_,{rte:ol.xml.makeChildAppender(ol.format.GPX.writeRte_),trk:ol.xml.makeChildAppender(ol.format.GPX.writeTrk_),wpt:ol.xml.makeChildAppender(ol.format.GPX.writeWpt_)}),ol.format.GPX.prototype.writeFeatures,ol.format.GPX.prototype.writeFeaturesNode=function(e,o){o=this.adaptOptions(o);var t=ol.xml.createElementNS("http://www.topografix.com/GPX/1/1","gpx");return ol.xml.setAttributeNS(t,"http://www.w3.org/2000/xmlns/","xmlns:xsi","http://www.w3.org/2001/XMLSchema-instance"),ol.xml.setAttributeNS(t,"http://www.w3.org/2001/XMLSchema-instance","xsi:schemaLocation",ol.format.GPX.SCHEMA_LOCATION_),t.setAttribute("version","1.1"),t.setAttribute("creator","OpenLayers 3"),ol.xml.pushSerializeAndPop({node:t},ol.format.GPX.GPX_SERIALIZERS_,ol.format.GPX.GPX_NODE_FACTORY_,e,[o]),t},goog.provide("ol.format.TextFeature"),goog.require("ol"),goog.require("ol.format.Feature"),goog.require("ol.format.FormatType"),ol.format.TextFeature=function(){ol.format.Feature.call(this)},ol.inherits(ol.format.TextFeature,ol.format.Feature),ol.format.TextFeature.prototype.getText_=function(e){return"string"==typeof e?e:""},ol.format.TextFeature.prototype.getType=function(){return ol.format.FormatType.TEXT},ol.format.TextFeature.prototype.readFeature=function(e,o){return this.readFeatureFromText(this.getText_(e),this.adaptOptions(o))},ol.format.TextFeature.prototype.readFeatureFromText=function(e,o){},ol.format.TextFeature.prototype.readFeatures=function(e,o){return this.readFeaturesFromText(this.getText_(e),this.adaptOptions(o))},ol.format.TextFeature.prototype.readFeaturesFromText=function(e,o){},ol.format.TextFeature.prototype.readGeometry=function(e,o){return this.readGeometryFromText(this.getText_(e),this.adaptOptions(o))},ol.format.TextFeature.prototype.readGeometryFromText=function(e,o){},ol.format.TextFeature.prototype.readProjection=function(e){return this.readProjectionFromText(this.getText_(e))},ol.format.TextFeature.prototype.readProjectionFromText=function(e){return this.defaultDataProjection},ol.format.TextFeature.prototype.writeFeature=function(e,o){return this.writeFeatureText(e,this.adaptOptions(o))},ol.format.TextFeature.prototype.writeFeatureText=function(e,o){},ol.format.TextFeature.prototype.writeFeatures=function(e,o){return this.writeFeaturesText(e,this.adaptOptions(o))},ol.format.TextFeature.prototype.writeFeaturesText=function(e,o){},ol.format.TextFeature.prototype.writeGeometry=function(e,o){return this.writeGeometryText(e,this.adaptOptions(o))},ol.format.TextFeature.prototype.writeGeometryText=function(e,o){},goog.provide("ol.format.IGC"),goog.require("ol"),goog.require("ol.Feature"),goog.require("ol.format.Feature"),goog.require("ol.format.TextFeature"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.LineString"),goog.require("ol.proj"),ol.format.IGC=function(e){var o=e||{};ol.format.TextFeature.call(this),this.defaultDataProjection=ol.proj.get("EPSG:4326"),this.altitudeMode_=o.altitudeMode?o.altitudeMode:ol.format.IGC.Z.NONE},ol.inherits(ol.format.IGC,ol.format.TextFeature),ol.format.IGC.EXTENSIONS_=[".igc"],ol.format.IGC.B_RECORD_RE_=/^B(\d{2})(\d{2})(\d{2})(\d{2})(\d{5})([NS])(\d{3})(\d{5})([EW])([AV])(\d{5})(\d{5})/,ol.format.IGC.H_RECORD_RE_=/^H.([A-Z]{3}).*?:(.*)/,ol.format.IGC.HFDTE_RECORD_RE_=/^HFDTE(\d{2})(\d{2})(\d{2})/,ol.format.IGC.NEWLINE_RE_=/\r\n|\r|\n/,ol.format.IGC.prototype.getExtensions=function(){return ol.format.IGC.EXTENSIONS_},ol.format.IGC.prototype.readFeature,ol.format.IGC.prototype.readFeatureFromText=function(e,o){var t,r,i=this.altitudeMode_,n=e.split(ol.format.IGC.NEWLINE_RE_),l={},a=[],s=2e3,p=0,g=1,c=-1;for(t=0,r=n.length;t<r;++t){var u,y=n[t];if("B"==y.charAt(0)){if(u=ol.format.IGC.B_RECORD_RE_.exec(y)){var d=parseInt(u[1],10),h=parseInt(u[2],10),m=parseInt(u[3],10),f=parseInt(u[4],10)+parseInt(u[5],10)/6e4;"S"==u[6]&&(f=-f);var _=parseInt(u[7],10)+parseInt(u[8],10)/6e4;if("W"==u[9]&&(_=-_),a.push(_,f),i!=ol.format.IGC.Z.NONE){var E;i==ol.format.IGC.Z.GPS?E=parseInt(u[11],10):i==ol.format.IGC.Z.BAROMETRIC?E=parseInt(u[12],10):(ol.DEBUG&&console.assert(!1,"Unknown altitude mode."),E=0),a.push(E)}var v=Date.UTC(s,p,g,d,h,m);v<c&&(v=Date.UTC(s,p,g+1,d,h,m)),a.push(v/1e3),c=v}}else"H"==y.charAt(0)&&(u=ol.format.IGC.HFDTE_RECORD_RE_.exec(y),u?(g=parseInt(u[1],10),p=parseInt(u[2],10)-1,s=2e3+parseInt(u[3],10)):(u=ol.format.IGC.H_RECORD_RE_.exec(y))&&(l[u[1]]=u[2].trim()))}if(0===a.length)return null;var S=new ol.geom.LineString(null),x=i==ol.format.IGC.Z.NONE?ol.geom.GeometryLayout.XYM:ol.geom.GeometryLayout.XYZM;S.setFlatCoordinates(x,a);var P=new ol.Feature(ol.format.Feature.transformWithOptions(S,!1,o));return P.setProperties(l),P},ol.format.IGC.prototype.readFeatures,ol.format.IGC.prototype.readFeaturesFromText=function(e,o){var t=this.readFeatureFromText(e,o);return t?[t]:[]},ol.format.IGC.prototype.readProjection,ol.format.IGC.Z={BAROMETRIC:"barometric",GPS:"gps",NONE:"none"},goog.provide("ol.style.IconImage"),goog.require("ol"),goog.require("ol.dom"),goog.require("ol.events"),goog.require("ol.events.EventTarget"),goog.require("ol.events.EventType"),goog.require("ol.Image"),goog.require("ol.style"),ol.style.IconImage=function(e,o,t,r,i,n){ol.events.EventTarget.call(this),this.hitDetectionImage_=null,this.image_=e||new Image,null!==r&&(this.image_.crossOrigin=r),this.canvas_=n?document.createElement("CANVAS"):null,this.color_=n,this.imageListenerKeys_=null,this.imageState_=i,this.size_=t,this.src_=o,this.tainting_=!1,this.imageState_==ol.Image.State.LOADED&&this.determineTainting_()},ol.inherits(ol.style.IconImage,ol.events.EventTarget),ol.style.IconImage.get=function(e,o,t,r,i,n){var l=ol.style.iconImageCache,a=l.get(o,r,n);return a||(a=new ol.style.IconImage(e,o,t,r,i,n),l.set(o,r,n,a)),a},ol.style.IconImage.prototype.determineTainting_=function(){var e=ol.dom.createCanvasContext2D(1,1);try{e.drawImage(this.image_,0,0),e.getImageData(0,0,1,1)}catch(e){this.tainting_=!0}},ol.style.IconImage.prototype.dispatchChangeEvent_=function(){this.dispatchEvent(ol.events.EventType.CHANGE)},ol.style.IconImage.prototype.handleImageError_=function(){this.imageState_=ol.Image.State.ERROR,this.unlistenImage_(),this.dispatchChangeEvent_()},ol.style.IconImage.prototype.handleImageLoad_=function(){this.imageState_=ol.Image.State.LOADED,this.size_&&(this.image_.width=this.size_[0],this.image_.height=this.size_[1]),this.size_=[this.image_.width,this.image_.height],this.unlistenImage_(),this.determineTainting_(),this.replaceColor_(),this.dispatchChangeEvent_()},ol.style.IconImage.prototype.getImage=function(e){return this.canvas_?this.canvas_:this.image_},ol.style.IconImage.prototype.getImageState=function(){return this.imageState_},ol.style.IconImage.prototype.getHitDetectionImage=function(e){if(!this.hitDetectionImage_)if(this.tainting_){var o=this.size_[0],t=this.size_[1],r=ol.dom.createCanvasContext2D(o,t);r.fillRect(0,0,o,t),this.hitDetectionImage_=r.canvas}else this.hitDetectionImage_=this.image_;return this.hitDetectionImage_},ol.style.IconImage.prototype.getSize=function(){return this.size_},ol.style.IconImage.prototype.getSrc=function(){return this.src_},ol.style.IconImage.prototype.load=function(){if(this.imageState_==ol.Image.State.IDLE){ol.DEBUG&&console.assert(void 0!==this.src_,"this.src_ must not be undefined"),ol.DEBUG&&console.assert(!this.imageListenerKeys_,"no listener keys existing"),this.imageState_=ol.Image.State.LOADING,this.imageListenerKeys_=[ol.events.listenOnce(this.image_,ol.events.EventType.ERROR,this.handleImageError_,this),ol.events.listenOnce(this.image_,ol.events.EventType.LOAD,this.handleImageLoad_,this)];try{this.image_.src=this.src_}catch(e){this.handleImageError_()}}},ol.style.IconImage.prototype.replaceColor_=function(){if(!this.tainting_&&null!==this.color_){this.canvas_.width=this.image_.width,this.canvas_.height=this.image_.height;var e=this.canvas_.getContext("2d");e.drawImage(this.image_,0,0);for(var o=e.getImageData(0,0,this.image_.width,this.image_.height),t=o.data,r=this.color_[0]/255,i=this.color_[1]/255,n=this.color_[2]/255,l=0,a=t.length;l<a;l+=4)t[l]*=r,t[l+1]*=i,t[l+2]*=n;e.putImageData(o,0,0)}},ol.style.IconImage.prototype.unlistenImage_=function(){this.imageListenerKeys_.forEach(ol.events.unlistenByKey),this.imageListenerKeys_=null},goog.provide("ol.style.Icon"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.color"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.Image"),goog.require("ol.style.IconImage"),goog.require("ol.style.Image"),ol.style.Icon=function(e){var o=e||{};this.anchor_=void 0!==o.anchor?o.anchor:[.5,.5],this.normalizedAnchor_=null,this.anchorOrigin_=void 0!==o.anchorOrigin?o.anchorOrigin:ol.style.Icon.Origin.TOP_LEFT,this.anchorXUnits_=void 0!==o.anchorXUnits?o.anchorXUnits:ol.style.Icon.AnchorUnits.FRACTION,this.anchorYUnits_=void 0!==o.anchorYUnits?o.anchorYUnits:ol.style.Icon.AnchorUnits.FRACTION,this.crossOrigin_=void 0!==o.crossOrigin?o.crossOrigin:null;var t=void 0!==o.img?o.img:null,r=void 0!==o.imgSize?o.imgSize:null,i=o.src;ol.asserts.assert(!(void 0!==i&&t),4),ol.asserts.assert(!t||t&&r,5),void 0!==i&&0!==i.length||!t||(i=t.src||ol.getUid(t).toString()),ol.asserts.assert(void 0!==i&&i.length>0,6);var n=void 0!==o.src?ol.Image.State.IDLE:ol.Image.State.LOADED;this.color_=void 0!==o.color?ol.color.asArray(o.color):null,this.iconImage_=ol.style.IconImage.get(t,i,r,this.crossOrigin_,n,this.color_),this.offset_=void 0!==o.offset?o.offset:[0,0],this.offsetOrigin_=void 0!==o.offsetOrigin?o.offsetOrigin:ol.style.Icon.Origin.TOP_LEFT,this.origin_=null,this.size_=void 0!==o.size?o.size:null;var l=void 0!==o.opacity?o.opacity:1,a=void 0!==o.rotateWithView&&o.rotateWithView,s=void 0!==o.rotation?o.rotation:0,p=void 0!==o.scale?o.scale:1,g=void 0===o.snapToPixel||o.snapToPixel;ol.style.Image.call(this,{opacity:l,rotation:s,scale:p,snapToPixel:g,rotateWithView:a})},ol.inherits(ol.style.Icon,ol.style.Image),ol.style.Icon.prototype.clone=function(){var e,o=this.getImage(1);if(this.iconImage_.getImageState()===ol.Image.State.LOADED)if("IMG"===o.tagName.toUpperCase())e=o.cloneNode(!0);else{e=document.createElement("canvas");var t=e.getContext("2d");e.width=o.width,e.height=o.height,t.drawImage(o,0,0)}return new ol.style.Icon({
anchor:this.anchor_.slice(),anchorOrigin:this.anchorOrigin_,anchorXUnits:this.anchorXUnits_,anchorYUnits:this.anchorYUnits_,crossOrigin:this.crossOrigin_,color:this.color_&&this.color_.slice?this.color_.slice():this.color_||void 0,img:e||void 0,imgSize:e?this.iconImage_.getSize().slice():void 0,src:e?void 0:this.getSrc(),offset:this.offset_.slice(),offsetOrigin:this.offsetOrigin_,size:null!==this.size_?this.size_.slice():void 0,opacity:this.getOpacity(),scale:this.getScale(),snapToPixel:this.getSnapToPixel(),rotation:this.getRotation(),rotateWithView:this.getRotateWithView()})},ol.style.Icon.prototype.getAnchor=function(){if(this.normalizedAnchor_)return this.normalizedAnchor_;var e=this.anchor_,o=this.getSize();if(this.anchorXUnits_==ol.style.Icon.AnchorUnits.FRACTION||this.anchorYUnits_==ol.style.Icon.AnchorUnits.FRACTION){if(!o)return null;e=this.anchor_.slice(),this.anchorXUnits_==ol.style.Icon.AnchorUnits.FRACTION&&(e[0]*=o[0]),this.anchorYUnits_==ol.style.Icon.AnchorUnits.FRACTION&&(e[1]*=o[1])}if(this.anchorOrigin_!=ol.style.Icon.Origin.TOP_LEFT){if(!o)return null;e===this.anchor_&&(e=this.anchor_.slice()),this.anchorOrigin_!=ol.style.Icon.Origin.TOP_RIGHT&&this.anchorOrigin_!=ol.style.Icon.Origin.BOTTOM_RIGHT||(e[0]=-e[0]+o[0]),this.anchorOrigin_!=ol.style.Icon.Origin.BOTTOM_LEFT&&this.anchorOrigin_!=ol.style.Icon.Origin.BOTTOM_RIGHT||(e[1]=-e[1]+o[1])}return this.normalizedAnchor_=e,this.normalizedAnchor_},ol.style.Icon.prototype.getColor=function(){return this.color_},ol.style.Icon.prototype.getImage=function(e){return this.iconImage_.getImage(e)},ol.style.Icon.prototype.getImageSize=function(){return this.iconImage_.getSize()},ol.style.Icon.prototype.getHitDetectionImageSize=function(){return this.getImageSize()},ol.style.Icon.prototype.getImageState=function(){return this.iconImage_.getImageState()},ol.style.Icon.prototype.getHitDetectionImage=function(e){return this.iconImage_.getHitDetectionImage(e)},ol.style.Icon.prototype.getOrigin=function(){if(this.origin_)return this.origin_;var e=this.offset_;if(this.offsetOrigin_!=ol.style.Icon.Origin.TOP_LEFT){var o=this.getSize(),t=this.iconImage_.getSize();if(!o||!t)return null;e=e.slice(),this.offsetOrigin_!=ol.style.Icon.Origin.TOP_RIGHT&&this.offsetOrigin_!=ol.style.Icon.Origin.BOTTOM_RIGHT||(e[0]=t[0]-o[0]-e[0]),this.offsetOrigin_!=ol.style.Icon.Origin.BOTTOM_LEFT&&this.offsetOrigin_!=ol.style.Icon.Origin.BOTTOM_RIGHT||(e[1]=t[1]-o[1]-e[1])}return this.origin_=e,this.origin_},ol.style.Icon.prototype.getSrc=function(){return this.iconImage_.getSrc()},ol.style.Icon.prototype.getSize=function(){return this.size_?this.size_:this.iconImage_.getSize()},ol.style.Icon.prototype.listenImageChange=function(e,o){return ol.events.listen(this.iconImage_,ol.events.EventType.CHANGE,e,o)},ol.style.Icon.prototype.load=function(){this.iconImage_.load()},ol.style.Icon.prototype.unlistenImageChange=function(e,o){ol.events.unlisten(this.iconImage_,ol.events.EventType.CHANGE,e,o)},ol.style.Icon.AnchorUnits={FRACTION:"fraction",PIXELS:"pixels"},ol.style.Icon.Origin={BOTTOM_LEFT:"bottom-left",BOTTOM_RIGHT:"bottom-right",TOP_LEFT:"top-left",TOP_RIGHT:"top-right"},goog.provide("ol.style.Text"),goog.require("ol.style.Fill"),ol.style.Text=function(e){var o=e||{};this.font_=o.font,this.rotation_=o.rotation,this.rotateWithView_=o.rotateWithView,this.scale_=o.scale,this.text_=o.text,this.textAlign_=o.textAlign,this.textBaseline_=o.textBaseline,this.fill_=void 0!==o.fill?o.fill:new ol.style.Fill({color:ol.style.Text.DEFAULT_FILL_COLOR_}),this.stroke_=void 0!==o.stroke?o.stroke:null,this.offsetX_=void 0!==o.offsetX?o.offsetX:0,this.offsetY_=void 0!==o.offsetY?o.offsetY:0},ol.style.Text.DEFAULT_FILL_COLOR_="#333",ol.style.Text.prototype.clone=function(){return new ol.style.Text({font:this.getFont(),rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),scale:this.getScale(),text:this.getText(),textAlign:this.getTextAlign(),textBaseline:this.getTextBaseline(),fill:this.getFill()?this.getFill().clone():void 0,stroke:this.getStroke()?this.getStroke().clone():void 0,offsetX:this.getOffsetX(),offsetY:this.getOffsetY()})},ol.style.Text.prototype.getFont=function(){return this.font_},ol.style.Text.prototype.getOffsetX=function(){return this.offsetX_},ol.style.Text.prototype.getOffsetY=function(){return this.offsetY_},ol.style.Text.prototype.getFill=function(){return this.fill_},ol.style.Text.prototype.getRotateWithView=function(){return this.rotateWithView_},ol.style.Text.prototype.getRotation=function(){return this.rotation_},ol.style.Text.prototype.getScale=function(){return this.scale_},ol.style.Text.prototype.getStroke=function(){return this.stroke_},ol.style.Text.prototype.getText=function(){return this.text_},ol.style.Text.prototype.getTextAlign=function(){return this.textAlign_},ol.style.Text.prototype.getTextBaseline=function(){return this.textBaseline_},ol.style.Text.prototype.setFont=function(e){this.font_=e},ol.style.Text.prototype.setOffsetX=function(e){this.offsetX_=e},ol.style.Text.prototype.setOffsetY=function(e){this.offsetY_=e},ol.style.Text.prototype.setFill=function(e){this.fill_=e},ol.style.Text.prototype.setRotation=function(e){this.rotation_=e},ol.style.Text.prototype.setScale=function(e){this.scale_=e},ol.style.Text.prototype.setStroke=function(e){this.stroke_=e},ol.style.Text.prototype.setText=function(e){this.text_=e},ol.style.Text.prototype.setTextAlign=function(e){this.textAlign_=e},ol.style.Text.prototype.setTextBaseline=function(e){this.textBaseline_=e},goog.provide("ol.format.KML"),goog.require("ol"),goog.require("ol.Feature"),goog.require("ol.array"),goog.require("ol.asserts"),goog.require("ol.color"),goog.require("ol.format.Feature"),goog.require("ol.format.XMLFeature"),goog.require("ol.format.XSD"),goog.require("ol.geom.GeometryCollection"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.LineString"),goog.require("ol.geom.LinearRing"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.MultiPoint"),goog.require("ol.geom.MultiPolygon"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.math"),goog.require("ol.proj"),goog.require("ol.style.Fill"),goog.require("ol.style.Icon"),goog.require("ol.style.Stroke"),goog.require("ol.style.Style"),goog.require("ol.style.Text"),goog.require("ol.xml"),ol.format.KML=function(e){var o=e||{};ol.format.XMLFeature.call(this),ol.format.KML.DEFAULT_STYLE_ARRAY_||ol.format.KML.createStyleDefaults_(),this.defaultDataProjection=ol.proj.get("EPSG:4326"),this.defaultStyle_=o.defaultStyle?o.defaultStyle:ol.format.KML.DEFAULT_STYLE_ARRAY_,this.extractStyles_=void 0===o.extractStyles||o.extractStyles,this.writeStyles_=void 0===o.writeStyles||o.writeStyles,this.sharedStyles_={},this.showPointNames_=void 0===o.showPointNames||o.showPointNames},ol.inherits(ol.format.KML,ol.format.XMLFeature),ol.format.KML.EXTENSIONS_=[".kml"],ol.format.KML.GX_NAMESPACE_URIS_=["http://www.google.com/kml/ext/2.2"],ol.format.KML.NAMESPACE_URIS_=[null,"http://earth.google.com/kml/2.0","http://earth.google.com/kml/2.1","http://earth.google.com/kml/2.2","http://www.opengis.net/kml/2.2"],ol.format.KML.SCHEMA_LOCATION_="http://www.opengis.net/kml/2.2 https://developers.google.com/kml/schema/kml22gx.xsd",ol.format.KML.createStyleDefaults_=function(){return ol.format.KML.DEFAULT_COLOR_=[255,255,255,1],ol.format.KML.DEFAULT_FILL_STYLE_=new ol.style.Fill({color:ol.format.KML.DEFAULT_COLOR_}),ol.format.KML.DEFAULT_IMAGE_STYLE_ANCHOR_=[20,2],ol.format.KML.DEFAULT_IMAGE_STYLE_ANCHOR_X_UNITS_=ol.style.Icon.AnchorUnits.PIXELS,ol.format.KML.DEFAULT_IMAGE_STYLE_ANCHOR_Y_UNITS_=ol.style.Icon.AnchorUnits.PIXELS,ol.format.KML.DEFAULT_IMAGE_STYLE_SIZE_=[64,64],ol.format.KML.DEFAULT_IMAGE_STYLE_SRC_="https://maps.google.com/mapfiles/kml/pushpin/ylw-pushpin.png",ol.format.KML.DEFAULT_IMAGE_SCALE_MULTIPLIER_=.5,ol.format.KML.DEFAULT_IMAGE_STYLE_=new ol.style.Icon({anchor:ol.format.KML.DEFAULT_IMAGE_STYLE_ANCHOR_,anchorOrigin:ol.style.Icon.Origin.BOTTOM_LEFT,anchorXUnits:ol.format.KML.DEFAULT_IMAGE_STYLE_ANCHOR_X_UNITS_,anchorYUnits:ol.format.KML.DEFAULT_IMAGE_STYLE_ANCHOR_Y_UNITS_,crossOrigin:"anonymous",rotation:0,scale:ol.format.KML.DEFAULT_IMAGE_SCALE_MULTIPLIER_,size:ol.format.KML.DEFAULT_IMAGE_STYLE_SIZE_,src:ol.format.KML.DEFAULT_IMAGE_STYLE_SRC_}),ol.format.KML.DEFAULT_NO_IMAGE_STYLE_="NO_IMAGE",ol.format.KML.DEFAULT_STROKE_STYLE_=new ol.style.Stroke({color:ol.format.KML.DEFAULT_COLOR_,width:1}),ol.format.KML.DEFAULT_TEXT_STROKE_STYLE_=new ol.style.Stroke({color:[51,51,51,1],width:2}),ol.format.KML.DEFAULT_TEXT_STYLE_=new ol.style.Text({font:"bold 16px Helvetica",fill:ol.format.KML.DEFAULT_FILL_STYLE_,stroke:ol.format.KML.DEFAULT_TEXT_STROKE_STYLE_,scale:.8}),ol.format.KML.DEFAULT_STYLE_=new ol.style.Style({fill:ol.format.KML.DEFAULT_FILL_STYLE_,image:ol.format.KML.DEFAULT_IMAGE_STYLE_,text:ol.format.KML.DEFAULT_TEXT_STYLE_,stroke:ol.format.KML.DEFAULT_STROKE_STYLE_,zIndex:0}),ol.format.KML.DEFAULT_STYLE_ARRAY_=[ol.format.KML.DEFAULT_STYLE_],ol.format.KML.DEFAULT_STYLE_ARRAY_},ol.format.KML.ICON_ANCHOR_UNITS_MAP_={fraction:ol.style.Icon.AnchorUnits.FRACTION,pixels:ol.style.Icon.AnchorUnits.PIXELS},ol.format.KML.createNameStyleFunction_=function(e,o){var t=null,r=[0,0],i="start";if(e.getImage()){var n=e.getImage().getImageSize();if(null===n&&(n=ol.format.KML.DEFAULT_IMAGE_STYLE_SIZE_),2==n.length){var l=e.getImage().getScale();r[0]=l*n[0]/2,r[1]=-l*n[1]/2,i="left"}}if(null!==e.getText()){var a=e.getText();t=a.clone(),t.setFont(a.getFont()||ol.format.KML.DEFAULT_TEXT_STYLE_.getFont()),t.setScale(a.getScale()||ol.format.KML.DEFAULT_TEXT_STYLE_.getScale()),t.setFill(a.getFill()||ol.format.KML.DEFAULT_TEXT_STYLE_.getFill()),t.setStroke(a.getStroke()||ol.format.KML.DEFAULT_TEXT_STROKE_STYLE_)}else t=ol.format.KML.DEFAULT_TEXT_STYLE_.clone();return t.setText(o),t.setOffsetX(r[0]),t.setOffsetY(r[1]),t.setTextAlign(i),new ol.style.Style({text:t})},ol.format.KML.createFeatureStyleFunction_=function(e,o,t,r,i){return function(n){var l,a=i,s="";if(a&&this.getGeometry()&&(a=this.getGeometry().getType()===ol.geom.GeometryType.POINT),a&&(s=this.get("name"),a=a&&s),e)return a?(l=ol.format.KML.createNameStyleFunction_(e[0],s),e.concat(l)):e;if(o){var p=ol.format.KML.findStyle_(o,t,r);return a?(l=ol.format.KML.createNameStyleFunction_(p[0],s),p.concat(l)):p}return a?(l=ol.format.KML.createNameStyleFunction_(t[0],s),t.concat(l)):t}},ol.format.KML.findStyle_=function(e,o,t){return Array.isArray(e)?e:"string"==typeof e?(!(e in t)&&"#"+e in t&&(e="#"+e),ol.format.KML.findStyle_(t[e],o,t)):o},ol.format.KML.readColor_=function(e){var o=ol.xml.getAllTextContent(e,!1),t=/^\s*#?\s*([0-9A-Fa-f]{8})\s*$/.exec(o);if(t){var r=t[1];return[parseInt(r.substr(6,2),16),parseInt(r.substr(4,2),16),parseInt(r.substr(2,2),16),parseInt(r.substr(0,2),16)/255]}},ol.format.KML.readFlatCoordinates_=function(e){for(var o,t=ol.xml.getAllTextContent(e,!1),r=[],i=/^\s*([+\-]?\d*\.?\d+(?:e[+\-]?\d+)?)\s*,\s*([+\-]?\d*\.?\d+(?:e[+\-]?\d+)?)(?:\s*,\s*([+\-]?\d*\.?\d+(?:e[+\-]?\d+)?))?\s*/i;o=i.exec(t);){var n=parseFloat(o[1]),l=parseFloat(o[2]),a=o[3]?parseFloat(o[3]):0;r.push(n,l,a),t=t.substr(o[0].length)}if(""===t)return r},ol.format.KML.readURI_=function(e){var o=ol.xml.getAllTextContent(e,!1).trim();if(e.baseURI){return new URL(o,e.baseURI).href}return o},ol.format.KML.readVec2_=function(e){var o=e.getAttribute("xunits"),t=e.getAttribute("yunits");return{x:parseFloat(e.getAttribute("x")),xunits:ol.format.KML.ICON_ANCHOR_UNITS_MAP_[o],y:parseFloat(e.getAttribute("y")),yunits:ol.format.KML.ICON_ANCHOR_UNITS_MAP_[t]}},ol.format.KML.readScale_=function(e){return ol.format.XSD.readDecimal(e)},ol.format.KML.readStyleMapValue_=function(e,o){return ol.xml.pushParseAndPop(void 0,ol.format.KML.STYLE_MAP_PARSERS_,e,o)},ol.format.KML.IconStyleParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be an ELEMENT"),ol.DEBUG&&console.assert("IconStyle"==e.localName,"localName should be IconStyle");var t=ol.xml.pushParseAndPop({},ol.format.KML.ICON_STYLE_PARSERS_,e,o);if(t){var r,i=o[o.length-1],n="Icon"in t?t.Icon:{},l=!("Icon"in t)||Object.keys(n).length>0,a=n.href;a?r=a:l&&(r=ol.format.KML.DEFAULT_IMAGE_STYLE_SRC_);var s,p,g,c=t.hotSpot;c?(s=[c.x,c.y],p=c.xunits,g=c.yunits):r===ol.format.KML.DEFAULT_IMAGE_STYLE_SRC_?(s=ol.format.KML.DEFAULT_IMAGE_STYLE_ANCHOR_,p=ol.format.KML.DEFAULT_IMAGE_STYLE_ANCHOR_X_UNITS_,g=ol.format.KML.DEFAULT_IMAGE_STYLE_ANCHOR_Y_UNITS_):/^http:\/\/maps\.(?:google|gstatic)\.com\//.test(r)&&(s=[.5,0],p=ol.style.Icon.AnchorUnits.FRACTION,g=ol.style.Icon.AnchorUnits.FRACTION);var u,y=n.x,d=n.y;void 0!==y&&void 0!==d&&(u=[y,d]);var h,m=n.w,f=n.h;void 0!==m&&void 0!==f&&(h=[m,f]);var _,E=t.heading;void 0!==E&&(_=ol.math.toRadians(E));var v=t.scale;if(l){r==ol.format.KML.DEFAULT_IMAGE_STYLE_SRC_&&(h=ol.format.KML.DEFAULT_IMAGE_STYLE_SIZE_,void 0===v&&(v=ol.format.KML.DEFAULT_IMAGE_SCALE_MULTIPLIER_));var S=new ol.style.Icon({anchor:s,anchorOrigin:ol.style.Icon.Origin.BOTTOM_LEFT,anchorXUnits:p,anchorYUnits:g,crossOrigin:"anonymous",offset:u,offsetOrigin:ol.style.Icon.Origin.BOTTOM_LEFT,rotation:_,scale:v,size:h,src:r});i.imageStyle=S}else i.imageStyle=ol.format.KML.DEFAULT_NO_IMAGE_STYLE_}},ol.format.KML.LabelStyleParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("LabelStyle"==e.localName,"localName should be LabelStyle");var t=ol.xml.pushParseAndPop({},ol.format.KML.LABEL_STYLE_PARSERS_,e,o);if(t){var r=o[o.length-1],i=new ol.style.Text({fill:new ol.style.Fill({color:"color"in t?t.color:ol.format.KML.DEFAULT_COLOR_}),scale:t.scale});r.textStyle=i}},ol.format.KML.LineStyleParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("LineStyle"==e.localName,"localName should be LineStyle");var t=ol.xml.pushParseAndPop({},ol.format.KML.LINE_STYLE_PARSERS_,e,o);if(t){var r=o[o.length-1],i=new ol.style.Stroke({color:"color"in t?t.color:ol.format.KML.DEFAULT_COLOR_,width:"width"in t?t.width:1});r.strokeStyle=i}},ol.format.KML.PolyStyleParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("PolyStyle"==e.localName,"localName should be PolyStyle");var t=ol.xml.pushParseAndPop({},ol.format.KML.POLY_STYLE_PARSERS_,e,o);if(t){var r=o[o.length-1],i=new ol.style.Fill({color:"color"in t?t.color:ol.format.KML.DEFAULT_COLOR_});r.fillStyle=i;var n=t.fill;void 0!==n&&(r.fill=n);var l=t.outline;void 0!==l&&(r.outline=l)}},ol.format.KML.readFlatLinearRing_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("LinearRing"==e.localName,"localName should be LinearRing"),ol.xml.pushParseAndPop(null,ol.format.KML.FLAT_LINEAR_RING_PARSERS_,e,o)},ol.format.KML.gxCoordParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert(ol.array.includes(ol.format.KML.GX_NAMESPACE_URIS_,e.namespaceURI),"namespaceURI of the node should be known to the KML parser"),ol.DEBUG&&console.assert("coord"==e.localName,"localName should be coord");var t=o[o.length-1],r=t.flatCoordinates,i=ol.xml.getAllTextContent(e,!1),n=/^\s*([+\-]?\d+(?:\.\d*)?(?:e[+\-]?\d*)?)\s+([+\-]?\d+(?:\.\d*)?(?:e[+\-]?\d*)?)\s+([+\-]?\d+(?:\.\d*)?(?:e[+\-]?\d*)?)\s*$/i,l=n.exec(i);if(l){var a=parseFloat(l[1]),s=parseFloat(l[2]),p=parseFloat(l[3]);r.push(a,s,p,0)}else r.push(0,0,0,0)},ol.format.KML.readGxMultiTrack_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert(ol.array.includes(ol.format.KML.GX_NAMESPACE_URIS_,e.namespaceURI),"namespaceURI of the node should be known to the KML parser"),ol.DEBUG&&console.assert("MultiTrack"==e.localName,"localName should be MultiTrack");var t=ol.xml.pushParseAndPop([],ol.format.KML.GX_MULTITRACK_GEOMETRY_PARSERS_,e,o);if(t){var r=new ol.geom.MultiLineString(null);return r.setLineStrings(t),r}},ol.format.KML.readGxTrack_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert(ol.array.includes(ol.format.KML.GX_NAMESPACE_URIS_,e.namespaceURI),"namespaceURI of the node should be known to the KML parser"),ol.DEBUG&&console.assert("Track"==e.localName,"localName should be Track");var t=ol.xml.pushParseAndPop({flatCoordinates:[],whens:[]},ol.format.KML.GX_TRACK_PARSERS_,e,o);if(t){var r=t.flatCoordinates,i=t.whens;ol.DEBUG&&console.assert(r.length/4==i.length,"the length of the flatCoordinates array divided by 4 should be the length of the whens array");var n,l;for(n=0,l=Math.min(r.length,i.length);n<l;++n)r[4*n+3]=i[n];var a=new ol.geom.LineString(null);return a.setFlatCoordinates(ol.geom.GeometryLayout.XYZM,r),a}};ol.format.KML.readIcon_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Icon"==e.localName,"localName should be Icon");var t=ol.xml.pushParseAndPop({},ol.format.KML.ICON_PARSERS_,e,o);return t||null},ol.format.KML.readFlatCoordinatesFromNode_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.xml.pushParseAndPop(null,ol.format.KML.GEOMETRY_FLAT_COORDINATES_PARSERS_,e,o)},ol.format.KML.readLineString_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("LineString"==e.localName,"localName should be LineString");var t=ol.xml.pushParseAndPop({},ol.format.KML.EXTRUDE_AND_ALTITUDE_MODE_PARSERS_,e,o),r=ol.format.KML.readFlatCoordinatesFromNode_(e,o);if(r){var i=new ol.geom.LineString(null);return i.setFlatCoordinates(ol.geom.GeometryLayout.XYZ,r),i.setProperties(t),i}},ol.format.KML.readLinearRing_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("LinearRing"==e.localName,"localName should be LinearRing");var t=ol.xml.pushParseAndPop({},ol.format.KML.EXTRUDE_AND_ALTITUDE_MODE_PARSERS_,e,o),r=ol.format.KML.readFlatCoordinatesFromNode_(e,o);if(r){var i=new ol.geom.Polygon(null);return i.setFlatCoordinates(ol.geom.GeometryLayout.XYZ,r,[r.length]),i.setProperties(t),i}},ol.format.KML.readMultiGeometry_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("MultiGeometry"==e.localName,"localName should be MultiGeometry");var t=ol.xml.pushParseAndPop([],ol.format.KML.MULTI_GEOMETRY_PARSERS_,e,o);if(!t)return null;if(0===t.length)return new ol.geom.GeometryCollection(t);var r,i,n,l,a=!0,s=t[0].getType();for(n=1,l=t.length;n<l;++n)if(i=t[n],i.getType()!=s){a=!1;break}if(a){var p,g;if(s==ol.geom.GeometryType.POINT){var c=t[0];for(p=c.getLayout(),g=c.getFlatCoordinates(),n=1,l=t.length;n<l;++n)i=t[n],ol.DEBUG&&console.assert(i.getLayout()==p,"geometry layout should be consistent"),ol.array.extend(g,i.getFlatCoordinates());r=new ol.geom.MultiPoint(null),r.setFlatCoordinates(p,g),ol.format.KML.setCommonGeometryProperties_(r,t)}else s==ol.geom.GeometryType.LINE_STRING?(r=new ol.geom.MultiLineString(null),r.setLineStrings(t),ol.format.KML.setCommonGeometryProperties_(r,t)):s==ol.geom.GeometryType.POLYGON?(r=new ol.geom.MultiPolygon(null),r.setPolygons(t),ol.format.KML.setCommonGeometryProperties_(r,t)):s==ol.geom.GeometryType.GEOMETRY_COLLECTION?r=new ol.geom.GeometryCollection(t):ol.asserts.assert(!1,37)}else r=new ol.geom.GeometryCollection(t);return r},ol.format.KML.readPoint_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Point"==e.localName,"localName should be Point");var t=ol.xml.pushParseAndPop({},ol.format.KML.EXTRUDE_AND_ALTITUDE_MODE_PARSERS_,e,o),r=ol.format.KML.readFlatCoordinatesFromNode_(e,o);if(r){var i=new ol.geom.Point(null);return ol.DEBUG&&console.assert(3==r.length,"flatCoordinates should have a length of 3"),i.setFlatCoordinates(ol.geom.GeometryLayout.XYZ,r),i.setProperties(t),i}},ol.format.KML.readPolygon_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Polygon"==e.localName,"localName should be Polygon");var t=ol.xml.pushParseAndPop({},ol.format.KML.EXTRUDE_AND_ALTITUDE_MODE_PARSERS_,e,o),r=ol.xml.pushParseAndPop([null],ol.format.KML.FLAT_LINEAR_RINGS_PARSERS_,e,o);if(r&&r[0]){var i,n,l=new ol.geom.Polygon(null),a=r[0],s=[a.length];for(i=1,n=r.length;i<n;++i)ol.array.extend(a,r[i]),s.push(a.length);return l.setFlatCoordinates(ol.geom.GeometryLayout.XYZ,a,s),l.setProperties(t),l}},ol.format.KML.readStyle_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Style"==e.localName,"localName should be Style");var t=ol.xml.pushParseAndPop({},ol.format.KML.STYLE_PARSERS_,e,o);if(!t)return null;var r="fillStyle"in t?t.fillStyle:ol.format.KML.DEFAULT_FILL_STYLE_,i=t.fill;void 0===i||i||(r=null);var n="imageStyle"in t?t.imageStyle:ol.format.KML.DEFAULT_IMAGE_STYLE_;n==ol.format.KML.DEFAULT_NO_IMAGE_STYLE_&&(n=void 0);var l="textStyle"in t?t.textStyle:ol.format.KML.DEFAULT_TEXT_STYLE_,a="strokeStyle"in t?t.strokeStyle:ol.format.KML.DEFAULT_STROKE_STYLE_,s=t.outline;return void 0===s||s||(a=null),[new ol.style.Style({fill:r,image:n,stroke:a,text:l,zIndex:void 0})]},ol.format.KML.setCommonGeometryProperties_=function(e,o){var t,r,i,n,l=o.length,a=new Array(o.length),s=new Array(o.length);for(i=n=!1,r=0;r<l;++r)t=o[r],a[r]=t.get("extrude"),s[r]=t.get("altitudeMode"),i=i||void 0!==a[r],n=n||s[r];i&&e.set("extrude",a),n&&e.set("altitudeMode",s)},ol.format.KML.DataParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Data"==e.localName,"localName should be Data");var t=e.getAttribute("name");ol.xml.parseNode(ol.format.KML.DATA_PARSERS_,e,o);var r=o[o.length-1];null!==t?r[t]=r.value:null!==r.displayName&&(r[r.displayName]=r.value)},ol.format.KML.ExtendedDataParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("ExtendedData"==e.localName,"localName should be ExtendedData"),ol.xml.parseNode(ol.format.KML.EXTENDED_DATA_PARSERS_,e,o)},ol.format.KML.RegionParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Region"==e.localName,"localName should be Region"),ol.xml.parseNode(ol.format.KML.REGION_PARSERS_,e,o)},ol.format.KML.PairDataParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Pair"==e.localName,"localName should be Pair");var t=ol.xml.pushParseAndPop({},ol.format.KML.PAIR_PARSERS_,e,o);if(t){var r=t.key;if(r&&"normal"==r){var i=t.styleUrl;i&&(o[o.length-1]=i);var n=t.Style;n&&(o[o.length-1]=n)}}},ol.format.KML.PlacemarkStyleMapParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("StyleMap"==e.localName,"localName should be StyleMap");var t=ol.format.KML.readStyleMapValue_(e,o);if(t){var r=o[o.length-1];Array.isArray(t)?r.Style=t:"string"==typeof t?r.styleUrl=t:ol.asserts.assert(!1,38)}},ol.format.KML.SchemaDataParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("SchemaData"==e.localName,"localName should be SchemaData"),ol.xml.parseNode(ol.format.KML.SCHEMA_DATA_PARSERS_,e,o)},ol.format.KML.SimpleDataParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("SimpleData"==e.localName,"localName should be SimpleData");var t=e.getAttribute("name");if(null!==t){var r=ol.format.XSD.readString(e);o[o.length-1][t]=r}},ol.format.KML.LatLonAltBoxParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("LatLonAltBox"==e.localName,"localName should be LatLonAltBox");var t=ol.xml.pushParseAndPop({},ol.format.KML.LAT_LON_ALT_BOX_PARSERS_,e,o);if(t){var r=o[o.length-1],i=[parseFloat(t.west),parseFloat(t.south),parseFloat(t.east),parseFloat(t.north)];r.extent=i,r.altitudeMode=t.altitudeMode,r.minAltitude=parseFloat(t.minAltitude),r.maxAltitude=parseFloat(t.maxAltitude)}},ol.format.KML.LodParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Lod"==e.localName,"localName should be Lod");var t=ol.xml.pushParseAndPop({},ol.format.KML.LOD_PARSERS_,e,o);if(t){var r=o[o.length-1];r.minLodPixels=parseFloat(t.minLodPixels),r.maxLodPixels=parseFloat(t.maxLodPixels),r.minFadeExtent=parseFloat(t.minFadeExtent),r.maxFadeExtent=parseFloat(t.maxFadeExtent)}},ol.format.KML.innerBoundaryIsParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("innerBoundaryIs"==e.localName,"localName should be innerBoundaryIs");var t=ol.xml.pushParseAndPop(void 0,ol.format.KML.INNER_BOUNDARY_IS_PARSERS_,e,o);if(t){var r=o[o.length-1];ol.DEBUG&&console.assert(Array.isArray(r),"flatLinearRings should be an array"),ol.DEBUG&&console.assert(r.length>0,"flatLinearRings array should not be empty"),r.push(t)}},ol.format.KML.outerBoundaryIsParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("outerBoundaryIs"==e.localName,"localName should be outerBoundaryIs");var t=ol.xml.pushParseAndPop(void 0,ol.format.KML.OUTER_BOUNDARY_IS_PARSERS_,e,o);if(t){var r=o[o.length-1];ol.DEBUG&&console.assert(Array.isArray(r),"flatLinearRings should be an array"),ol.DEBUG&&console.assert(r.length>0,"flatLinearRings array should not be empty"),r[0]=t}},ol.format.KML.LinkParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Link"==e.localName,"localName should be Link"),ol.xml.parseNode(ol.format.KML.LINK_PARSERS_,e,o)},ol.format.KML.whenParser_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("when"==e.localName,"localName should be when");var t=o[o.length-1],r=t.whens,i=ol.xml.getAllTextContent(e,!1),n=Date.parse(i);r.push(isNaN(n)?0:n)},ol.format.KML.DATA_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{displayName:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),value:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)}),ol.format.KML.EXTENDED_DATA_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{Data:ol.format.KML.DataParser_,SchemaData:ol.format.KML.SchemaDataParser_}),ol.format.KML.REGION_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{LatLonAltBox:ol.format.KML.LatLonAltBoxParser_,Lod:ol.format.KML.LodParser_}),ol.format.KML.LAT_LON_ALT_BOX_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{altitudeMode:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),minAltitude:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),maxAltitude:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),north:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),south:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),east:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),west:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal)}),ol.format.KML.LOD_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{minLodPixels:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),maxLodPixels:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),minFadeExtent:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),maxFadeExtent:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal)}),ol.format.KML.EXTRUDE_AND_ALTITUDE_MODE_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{extrude:ol.xml.makeObjectPropertySetter(ol.format.XSD.readBoolean),altitudeMode:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)}),ol.format.KML.FLAT_LINEAR_RING_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{coordinates:ol.xml.makeReplacer(ol.format.KML.readFlatCoordinates_)}),ol.format.KML.FLAT_LINEAR_RINGS_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{innerBoundaryIs:ol.format.KML.innerBoundaryIsParser_,outerBoundaryIs:ol.format.KML.outerBoundaryIsParser_}),ol.format.KML.GX_TRACK_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{when:ol.format.KML.whenParser_},ol.xml.makeStructureNS(ol.format.KML.GX_NAMESPACE_URIS_,{coord:ol.format.KML.gxCoordParser_})),ol.format.KML.GEOMETRY_FLAT_COORDINATES_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{coordinates:ol.xml.makeReplacer(ol.format.KML.readFlatCoordinates_)}),ol.format.KML.ICON_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{href:ol.xml.makeObjectPropertySetter(ol.format.KML.readURI_)},ol.xml.makeStructureNS(ol.format.KML.GX_NAMESPACE_URIS_,{x:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),y:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),w:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),h:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal)})),ol.format.KML.ICON_STYLE_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{Icon:ol.xml.makeObjectPropertySetter(ol.format.KML.readIcon_),heading:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),hotSpot:ol.xml.makeObjectPropertySetter(ol.format.KML.readVec2_),scale:ol.xml.makeObjectPropertySetter(ol.format.KML.readScale_)}),ol.format.KML.INNER_BOUNDARY_IS_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{LinearRing:ol.xml.makeReplacer(ol.format.KML.readFlatLinearRing_)}),ol.format.KML.LABEL_STYLE_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{color:ol.xml.makeObjectPropertySetter(ol.format.KML.readColor_),scale:ol.xml.makeObjectPropertySetter(ol.format.KML.readScale_)}),ol.format.KML.LINE_STYLE_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{color:ol.xml.makeObjectPropertySetter(ol.format.KML.readColor_),width:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal)}),ol.format.KML.MULTI_GEOMETRY_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{LineString:ol.xml.makeArrayPusher(ol.format.KML.readLineString_),LinearRing:ol.xml.makeArrayPusher(ol.format.KML.readLinearRing_),MultiGeometry:ol.xml.makeArrayPusher(ol.format.KML.readMultiGeometry_),Point:ol.xml.makeArrayPusher(ol.format.KML.readPoint_),Polygon:ol.xml.makeArrayPusher(ol.format.KML.readPolygon_)}),ol.format.KML.GX_MULTITRACK_GEOMETRY_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.GX_NAMESPACE_URIS_,{Track:ol.xml.makeArrayPusher(ol.format.KML.readGxTrack_)}),ol.format.KML.NETWORK_LINK_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{ExtendedData:ol.format.KML.ExtendedDataParser_,Region:ol.format.KML.RegionParser_,Link:ol.format.KML.LinkParser_,address:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),description:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),name:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),open:ol.xml.makeObjectPropertySetter(ol.format.XSD.readBoolean),phoneNumber:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),visibility:ol.xml.makeObjectPropertySetter(ol.format.XSD.readBoolean)}),ol.format.KML.LINK_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{href:ol.xml.makeObjectPropertySetter(ol.format.KML.readURI_)}),
ol.format.KML.OUTER_BOUNDARY_IS_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{LinearRing:ol.xml.makeReplacer(ol.format.KML.readFlatLinearRing_)}),ol.format.KML.PAIR_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{Style:ol.xml.makeObjectPropertySetter(ol.format.KML.readStyle_),key:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),styleUrl:ol.xml.makeObjectPropertySetter(ol.format.KML.readURI_)}),ol.format.KML.PLACEMARK_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{ExtendedData:ol.format.KML.ExtendedDataParser_,Region:ol.format.KML.RegionParser_,MultiGeometry:ol.xml.makeObjectPropertySetter(ol.format.KML.readMultiGeometry_,"geometry"),LineString:ol.xml.makeObjectPropertySetter(ol.format.KML.readLineString_,"geometry"),LinearRing:ol.xml.makeObjectPropertySetter(ol.format.KML.readLinearRing_,"geometry"),Point:ol.xml.makeObjectPropertySetter(ol.format.KML.readPoint_,"geometry"),Polygon:ol.xml.makeObjectPropertySetter(ol.format.KML.readPolygon_,"geometry"),Style:ol.xml.makeObjectPropertySetter(ol.format.KML.readStyle_),StyleMap:ol.format.KML.PlacemarkStyleMapParser_,address:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),description:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),name:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),open:ol.xml.makeObjectPropertySetter(ol.format.XSD.readBoolean),phoneNumber:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),styleUrl:ol.xml.makeObjectPropertySetter(ol.format.KML.readURI_),visibility:ol.xml.makeObjectPropertySetter(ol.format.XSD.readBoolean)},ol.xml.makeStructureNS(ol.format.KML.GX_NAMESPACE_URIS_,{MultiTrack:ol.xml.makeObjectPropertySetter(ol.format.KML.readGxMultiTrack_,"geometry"),Track:ol.xml.makeObjectPropertySetter(ol.format.KML.readGxTrack_,"geometry")})),ol.format.KML.POLY_STYLE_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{color:ol.xml.makeObjectPropertySetter(ol.format.KML.readColor_),fill:ol.xml.makeObjectPropertySetter(ol.format.XSD.readBoolean),outline:ol.xml.makeObjectPropertySetter(ol.format.XSD.readBoolean)}),ol.format.KML.SCHEMA_DATA_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{SimpleData:ol.format.KML.SimpleDataParser_}),ol.format.KML.STYLE_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{IconStyle:ol.format.KML.IconStyleParser_,LabelStyle:ol.format.KML.LabelStyleParser_,LineStyle:ol.format.KML.LineStyleParser_,PolyStyle:ol.format.KML.PolyStyleParser_}),ol.format.KML.STYLE_MAP_PARSERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{Pair:ol.format.KML.PairDataParser_}),ol.format.KML.prototype.getExtensions=function(){return ol.format.KML.EXTENSIONS_},ol.format.KML.prototype.readDocumentOrFolder_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT");var t=e.localName;ol.DEBUG&&console.assert("Document"==t||"Folder"==t,"localName should be Document or Folder");var r=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{Document:ol.xml.makeArrayExtender(this.readDocumentOrFolder_,this),Folder:ol.xml.makeArrayExtender(this.readDocumentOrFolder_,this),Placemark:ol.xml.makeArrayPusher(this.readPlacemark_,this),Style:this.readSharedStyle_.bind(this),StyleMap:this.readSharedStyleMap_.bind(this)}),i=ol.xml.pushParseAndPop([],r,e,o,this);return i||void 0},ol.format.KML.prototype.readPlacemark_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Placemark"==e.localName,"localName should be Placemark");var t=ol.xml.pushParseAndPop({geometry:null},ol.format.KML.PLACEMARK_PARSERS_,e,o);if(t){var r=new ol.Feature,i=e.getAttribute("id");null!==i&&r.setId(i);var n=o[0],l=t.geometry;if(l&&ol.format.Feature.transformWithOptions(l,!1,n),r.setGeometry(l),delete t.geometry,this.extractStyles_){var a=t.Style,s=t.styleUrl,p=ol.format.KML.createFeatureStyleFunction_(a,s,this.defaultStyle_,this.sharedStyles_,this.showPointNames_);r.setStyle(p)}return delete t.Style,r.setProperties(t),r}},ol.format.KML.prototype.readSharedStyle_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Style"==e.localName,"localName should be Style");var t=e.getAttribute("id");if(null!==t){var r=ol.format.KML.readStyle_(e,o);if(r){var i;if(e.baseURI){i=new URL("#"+t,e.baseURI).href}else i="#"+t;this.sharedStyles_[i]=r}}},ol.format.KML.prototype.readSharedStyleMap_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("StyleMap"==e.localName,"localName should be StyleMap");var t=e.getAttribute("id");if(null!==t){var r=ol.format.KML.readStyleMapValue_(e,o);if(r){var i;if(e.baseURI){i=new URL("#"+t,e.baseURI).href}else i="#"+t;this.sharedStyles_[i]=r}}},ol.format.KML.prototype.readFeature,ol.format.KML.prototype.readFeatureFromNode=function(e,o){if(ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),!ol.array.includes(ol.format.KML.NAMESPACE_URIS_,e.namespaceURI))return null;ol.DEBUG&&console.assert("Placemark"==e.localName,"localName should be Placemark");var t=this.readPlacemark_(e,[this.getReadOptions(e,o)]);return t||null},ol.format.KML.prototype.readFeatures,ol.format.KML.prototype.readFeaturesFromNode=function(e,o){if(ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),!ol.array.includes(ol.format.KML.NAMESPACE_URIS_,e.namespaceURI))return[];var t,r=e.localName;if("Document"==r||"Folder"==r)return(t=this.readDocumentOrFolder_(e,[this.getReadOptions(e,o)]))||[];if("Placemark"==r){var i=this.readPlacemark_(e,[this.getReadOptions(e,o)]);return i?[i]:[]}if("kml"==r){t=[];var n;for(n=e.firstElementChild;n;n=n.nextElementSibling){var l=this.readFeaturesFromNode(n,o);l&&ol.array.extend(t,l)}return t}return[]},ol.format.KML.prototype.readName=function(e){if(ol.xml.isDocument(e))return this.readNameFromDocument(e);if(ol.xml.isNode(e))return this.readNameFromNode(e);if("string"==typeof e){var o=ol.xml.parse(e);return this.readNameFromDocument(o)}},ol.format.KML.prototype.readNameFromDocument=function(e){var o;for(o=e.firstChild;o;o=o.nextSibling)if(o.nodeType==Node.ELEMENT_NODE){var t=this.readNameFromNode(o);if(t)return t}},ol.format.KML.prototype.readNameFromNode=function(e){var o;for(o=e.firstElementChild;o;o=o.nextElementSibling)if(ol.array.includes(ol.format.KML.NAMESPACE_URIS_,o.namespaceURI)&&"name"==o.localName)return ol.format.XSD.readString(o);for(o=e.firstElementChild;o;o=o.nextElementSibling){var t=o.localName;if(ol.array.includes(ol.format.KML.NAMESPACE_URIS_,o.namespaceURI)&&("Document"==t||"Folder"==t||"Placemark"==t||"kml"==t)){var r=this.readNameFromNode(o);if(r)return r}}},ol.format.KML.prototype.readNetworkLinks=function(e){var o=[];if(ol.xml.isDocument(e))ol.array.extend(o,this.readNetworkLinksFromDocument(e));else if(ol.xml.isNode(e))ol.array.extend(o,this.readNetworkLinksFromNode(e));else if("string"==typeof e){var t=ol.xml.parse(e);ol.array.extend(o,this.readNetworkLinksFromDocument(t))}return o},ol.format.KML.prototype.readNetworkLinksFromDocument=function(e){var o,t=[];for(o=e.firstChild;o;o=o.nextSibling)o.nodeType==Node.ELEMENT_NODE&&ol.array.extend(t,this.readNetworkLinksFromNode(o));return t},ol.format.KML.prototype.readNetworkLinksFromNode=function(e){var o,t=[];for(o=e.firstElementChild;o;o=o.nextElementSibling)if(ol.array.includes(ol.format.KML.NAMESPACE_URIS_,o.namespaceURI)&&"NetworkLink"==o.localName){var r=ol.xml.pushParseAndPop({},ol.format.KML.NETWORK_LINK_PARSERS_,o,[]);t.push(r)}for(o=e.firstElementChild;o;o=o.nextElementSibling){var i=o.localName;!ol.array.includes(ol.format.KML.NAMESPACE_URIS_,o.namespaceURI)||"Document"!=i&&"Folder"!=i&&"kml"!=i||ol.array.extend(t,this.readNetworkLinksFromNode(o))}return t},ol.format.KML.prototype.readRegion=function(e){var o=[];if(ol.xml.isDocument(e))ol.array.extend(o,this.readRegionFromDocument(e));else if(ol.xml.isNode(e))ol.array.extend(o,this.readRegionFromNode(e));else if("string"==typeof e){var t=ol.xml.parse(e);ol.array.extend(o,this.readRegionFromDocument(t))}return o},ol.format.KML.prototype.readRegionFromDocument=function(e){var o,t=[];for(o=e.firstChild;o;o=o.nextSibling)o.nodeType==Node.ELEMENT_NODE&&ol.array.extend(t,this.readRegionFromNode(o));return t},ol.format.KML.prototype.readRegionFromNode=function(e){var o,t=[];for(o=e.firstElementChild;o;o=o.nextElementSibling)if(ol.array.includes(ol.format.KML.NAMESPACE_URIS_,o.namespaceURI)&&"Region"==o.localName){var r=ol.xml.pushParseAndPop({},ol.format.KML.REGION_PARSERS_,o,[]);t.push(r)}for(o=e.firstElementChild;o;o=o.nextElementSibling){var i=o.localName;!ol.array.includes(ol.format.KML.NAMESPACE_URIS_,o.namespaceURI)||"Document"!=i&&"Folder"!=i&&"kml"!=i||ol.array.extend(t,this.readRegionFromNode(o))}return t},ol.format.KML.prototype.readProjection,ol.format.KML.writeColorTextNode_=function(e,o){var t,r=ol.color.asArray(o),i=4==r.length?r[3]:1,n=[255*i,r[2],r[1],r[0]];for(t=0;t<4;++t){var l=parseInt(n[t],10).toString(16);n[t]=1==l.length?"0"+l:l}ol.format.XSD.writeStringTextNode(e,n.join(""))},ol.format.KML.writeCoordinatesTextNode_=function(e,o,t){var r,i=t[t.length-1],n=i.layout,l=i.stride;n==ol.geom.GeometryLayout.XY||n==ol.geom.GeometryLayout.XYM?r=2:n==ol.geom.GeometryLayout.XYZ||n==ol.geom.GeometryLayout.XYZM?r=3:ol.asserts.assert(!1,34);var a,s,p=o.length,g="";if(p>0){for(g+=o[0],a=1;a<r;++a)g+=","+o[a];for(s=l;s<p;s+=l)for(g+=" "+o[s],a=1;a<r;++a)g+=","+o[s+a]}ol.format.XSD.writeStringTextNode(e,g)},ol.format.KML.writeDataNode_=function(e,o,t){e.setAttribute("name",o.name);var r={node:e},i=o.value;"object"==typeof i?(null!==i&&i.displayName&&ol.xml.pushSerializeAndPop(r,ol.format.KML.EXTENDEDDATA_NODE_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,[i.displayName],t,["displayName"]),null!==i&&i.value&&ol.xml.pushSerializeAndPop(r,ol.format.KML.EXTENDEDDATA_NODE_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,[i.value],t,["value"])):ol.xml.pushSerializeAndPop(r,ol.format.KML.EXTENDEDDATA_NODE_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,[i],t,["value"])},ol.format.KML.writeDataNodeName_=function(e,o){ol.format.XSD.writeCDATASection(e,o)},ol.format.KML.writeDataNodeValue_=function(e,o){ol.format.XSD.writeStringTextNode(e,o)},ol.format.KML.writeDocument_=function(e,o,t){var r={node:e};ol.xml.pushSerializeAndPop(r,ol.format.KML.DOCUMENT_SERIALIZERS_,ol.format.KML.DOCUMENT_NODE_FACTORY_,o,t,void 0,this)},ol.format.KML.writeExtendedData_=function(e,o,t){for(var r={node:e},i=o.names,n=o.values,l=i.length,a=0;a<l;a++)ol.xml.pushSerializeAndPop(r,ol.format.KML.EXTENDEDDATA_NODE_SERIALIZERS_,ol.format.KML.DATA_NODE_FACTORY_,[{name:i[a],value:n[a]}],t)},ol.format.KML.writeIcon_=function(e,o,t){var r={node:e},i=t[t.length-1].node,n=ol.format.KML.ICON_SEQUENCE_[i.namespaceURI],l=ol.xml.makeSequence(o,n);ol.xml.pushSerializeAndPop(r,ol.format.KML.ICON_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,l,t,n),n=ol.format.KML.ICON_SEQUENCE_[ol.format.KML.GX_NAMESPACE_URIS_[0]],l=ol.xml.makeSequence(o,n),ol.xml.pushSerializeAndPop(r,ol.format.KML.ICON_SERIALIZERS_,ol.format.KML.GX_NODE_FACTORY_,l,t,n)},ol.format.KML.writeIconStyle_=function(e,o,t){var r={node:e},i={},n=o.getSrc(),l=o.getSize(),a=o.getImageSize(),s={href:n};if(l){s.w=l[0],s.h=l[1];var p=o.getAnchor(),g=o.getOrigin();if(g&&a&&0!==g[0]&&g[1]!==l[1]&&(s.x=g[0],s.y=a[1]-(g[1]+l[1])),p&&0!==p[0]&&p[1]!==l[1]){var c={x:p[0],xunits:ol.style.Icon.AnchorUnits.PIXELS,y:l[1]-p[1],yunits:ol.style.Icon.AnchorUnits.PIXELS};i.hotSpot=c}}i.Icon=s;var u=o.getScale();1!==u&&(i.scale=u);var y=o.getRotation();0!==y&&(i.heading=y);var d=t[t.length-1].node,h=ol.format.KML.ICON_STYLE_SEQUENCE_[d.namespaceURI],m=ol.xml.makeSequence(i,h);ol.xml.pushSerializeAndPop(r,ol.format.KML.ICON_STYLE_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,m,t,h)},ol.format.KML.writeLabelStyle_=function(e,o,t){var r={node:e},i={},n=o.getFill();n&&(i.color=n.getColor());var l=o.getScale();l&&1!==l&&(i.scale=l);var a=t[t.length-1].node,s=ol.format.KML.LABEL_STYLE_SEQUENCE_[a.namespaceURI],p=ol.xml.makeSequence(i,s);ol.xml.pushSerializeAndPop(r,ol.format.KML.LABEL_STYLE_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,p,t,s)},ol.format.KML.writeLineStyle_=function(e,o,t){var r={node:e},i={color:o.getColor(),width:o.getWidth()},n=t[t.length-1].node,l=ol.format.KML.LINE_STYLE_SEQUENCE_[n.namespaceURI],a=ol.xml.makeSequence(i,l);ol.xml.pushSerializeAndPop(r,ol.format.KML.LINE_STYLE_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,a,t,l)},ol.format.KML.writeMultiGeometry_=function(e,o,t){var r,i,n={node:e},l=o.getType();l==ol.geom.GeometryType.GEOMETRY_COLLECTION?(r=o.getGeometries(),i=ol.format.KML.GEOMETRY_NODE_FACTORY_):l==ol.geom.GeometryType.MULTI_POINT?(r=o.getPoints(),i=ol.format.KML.POINT_NODE_FACTORY_):l==ol.geom.GeometryType.MULTI_LINE_STRING?(r=o.getLineStrings(),i=ol.format.KML.LINE_STRING_NODE_FACTORY_):l==ol.geom.GeometryType.MULTI_POLYGON?(r=o.getPolygons(),i=ol.format.KML.POLYGON_NODE_FACTORY_):ol.asserts.assert(!1,39),ol.xml.pushSerializeAndPop(n,ol.format.KML.MULTI_GEOMETRY_SERIALIZERS_,i,r,t)},ol.format.KML.writeBoundaryIs_=function(e,o,t){var r={node:e};ol.xml.pushSerializeAndPop(r,ol.format.KML.BOUNDARY_IS_SERIALIZERS_,ol.format.KML.LINEAR_RING_NODE_FACTORY_,[o],t)},ol.format.KML.writePlacemark_=function(e,o,t){var r={node:e};o.getId()&&e.setAttribute("id",o.getId());var i=o.getProperties(),n={address:1,description:1,name:1,open:1,phoneNumber:1,styleUrl:1,visibility:1};n[o.getGeometryName()]=1;var l=Object.keys(i||{}).sort().filter(function(e){return!n[e]});if(l.length>0){var a=ol.xml.makeSequence(i,l),s={names:l,values:a};ol.xml.pushSerializeAndPop(r,ol.format.KML.PLACEMARK_SERIALIZERS_,ol.format.KML.EXTENDEDDATA_NODE_FACTORY_,[s],t)}var p=o.getStyleFunction();if(p){var g=p.call(o,0);if(g){var c=Array.isArray(g)?g[0]:g;this.writeStyles_&&(i.Style=c);var u=c.getText();u&&(i.name=u.getText())}}var y=t[t.length-1].node,d=ol.format.KML.PLACEMARK_SEQUENCE_[y.namespaceURI],h=ol.xml.makeSequence(i,d);ol.xml.pushSerializeAndPop(r,ol.format.KML.PLACEMARK_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,h,t,d);var m=t[0],f=o.getGeometry();f&&(f=ol.format.Feature.transformWithOptions(f,!0,m)),ol.xml.pushSerializeAndPop(r,ol.format.KML.PLACEMARK_SERIALIZERS_,ol.format.KML.GEOMETRY_NODE_FACTORY_,[f],t)},ol.format.KML.writePrimitiveGeometry_=function(e,o,t){ol.DEBUG&&console.assert(o instanceof ol.geom.Point||o instanceof ol.geom.LineString||o instanceof ol.geom.LinearRing,"geometry should be one of ol.geom.Point, ol.geom.LineString or ol.geom.LinearRing");var r=o.getFlatCoordinates(),i={node:e};i.layout=o.getLayout(),i.stride=o.getStride(),ol.xml.pushSerializeAndPop(i,ol.format.KML.PRIMITIVE_GEOMETRY_SERIALIZERS_,ol.format.KML.COORDINATES_NODE_FACTORY_,[r],t)},ol.format.KML.writePolygon_=function(e,o,t){var r=o.getLinearRings();ol.DEBUG&&console.assert(r.length>0,"linearRings should not be empty");var i=r.shift(),n={node:e};ol.xml.pushSerializeAndPop(n,ol.format.KML.POLYGON_SERIALIZERS_,ol.format.KML.INNER_BOUNDARY_NODE_FACTORY_,r,t),ol.xml.pushSerializeAndPop(n,ol.format.KML.POLYGON_SERIALIZERS_,ol.format.KML.OUTER_BOUNDARY_NODE_FACTORY_,[i],t)},ol.format.KML.writePolyStyle_=function(e,o,t){var r={node:e};ol.xml.pushSerializeAndPop(r,ol.format.KML.POLY_STYLE_SERIALIZERS_,ol.format.KML.COLOR_NODE_FACTORY_,[o.getColor()],t)},ol.format.KML.writeScaleTextNode_=function(e,o){ol.format.XSD.writeDecimalTextNode(e,Math.round(1e6*o)/1e6)},ol.format.KML.writeStyle_=function(e,o,t){var r={node:e},i={},n=o.getFill(),l=o.getStroke(),a=o.getImage(),s=o.getText();a instanceof ol.style.Icon&&(i.IconStyle=a),s&&(i.LabelStyle=s),l&&(i.LineStyle=l),n&&(i.PolyStyle=n);var p=t[t.length-1].node,g=ol.format.KML.STYLE_SEQUENCE_[p.namespaceURI],c=ol.xml.makeSequence(i,g);ol.xml.pushSerializeAndPop(r,ol.format.KML.STYLE_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,c,t,g)},ol.format.KML.writeVec2_=function(e,o){e.setAttribute("x",o.x),e.setAttribute("y",o.y),e.setAttribute("xunits",o.xunits),e.setAttribute("yunits",o.yunits)},ol.format.KML.KML_SEQUENCE_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,["Document","Placemark"]),ol.format.KML.KML_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{Document:ol.xml.makeChildAppender(ol.format.KML.writeDocument_),Placemark:ol.xml.makeChildAppender(ol.format.KML.writePlacemark_)}),ol.format.KML.DOCUMENT_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{Placemark:ol.xml.makeChildAppender(ol.format.KML.writePlacemark_)}),ol.format.KML.EXTENDEDDATA_NODE_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{Data:ol.xml.makeChildAppender(ol.format.KML.writeDataNode_),value:ol.xml.makeChildAppender(ol.format.KML.writeDataNodeValue_),displayName:ol.xml.makeChildAppender(ol.format.KML.writeDataNodeName_)}),ol.format.KML.GEOMETRY_TYPE_TO_NODENAME_={Point:"Point",LineString:"LineString",LinearRing:"LinearRing",Polygon:"Polygon",MultiPoint:"MultiGeometry",MultiLineString:"MultiGeometry",MultiPolygon:"MultiGeometry",GeometryCollection:"MultiGeometry"},ol.format.KML.ICON_SEQUENCE_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,["href"],ol.xml.makeStructureNS(ol.format.KML.GX_NAMESPACE_URIS_,["x","y","w","h"])),ol.format.KML.ICON_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{href:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode)},ol.xml.makeStructureNS(ol.format.KML.GX_NAMESPACE_URIS_,{x:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),y:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),w:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),h:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode)})),ol.format.KML.ICON_STYLE_SEQUENCE_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,["scale","heading","Icon","hotSpot"]),ol.format.KML.ICON_STYLE_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{Icon:ol.xml.makeChildAppender(ol.format.KML.writeIcon_),heading:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode),hotSpot:ol.xml.makeChildAppender(ol.format.KML.writeVec2_),scale:ol.xml.makeChildAppender(ol.format.KML.writeScaleTextNode_)}),ol.format.KML.LABEL_STYLE_SEQUENCE_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,["color","scale"]),ol.format.KML.LABEL_STYLE_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{color:ol.xml.makeChildAppender(ol.format.KML.writeColorTextNode_),scale:ol.xml.makeChildAppender(ol.format.KML.writeScaleTextNode_)}),ol.format.KML.LINE_STYLE_SEQUENCE_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,["color","width"]),ol.format.KML.LINE_STYLE_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{color:ol.xml.makeChildAppender(ol.format.KML.writeColorTextNode_),width:ol.xml.makeChildAppender(ol.format.XSD.writeDecimalTextNode)}),ol.format.KML.BOUNDARY_IS_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{LinearRing:ol.xml.makeChildAppender(ol.format.KML.writePrimitiveGeometry_)}),ol.format.KML.MULTI_GEOMETRY_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{LineString:ol.xml.makeChildAppender(ol.format.KML.writePrimitiveGeometry_),Point:ol.xml.makeChildAppender(ol.format.KML.writePrimitiveGeometry_),Polygon:ol.xml.makeChildAppender(ol.format.KML.writePolygon_),GeometryCollection:ol.xml.makeChildAppender(ol.format.KML.writeMultiGeometry_)}),ol.format.KML.PLACEMARK_SEQUENCE_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,["name","open","visibility","address","phoneNumber","description","styleUrl","Style"]),ol.format.KML.PLACEMARK_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{ExtendedData:ol.xml.makeChildAppender(ol.format.KML.writeExtendedData_),MultiGeometry:ol.xml.makeChildAppender(ol.format.KML.writeMultiGeometry_),LineString:ol.xml.makeChildAppender(ol.format.KML.writePrimitiveGeometry_),LinearRing:ol.xml.makeChildAppender(ol.format.KML.writePrimitiveGeometry_),Point:ol.xml.makeChildAppender(ol.format.KML.writePrimitiveGeometry_),Polygon:ol.xml.makeChildAppender(ol.format.KML.writePolygon_),Style:ol.xml.makeChildAppender(ol.format.KML.writeStyle_),address:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),description:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),name:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),open:ol.xml.makeChildAppender(ol.format.XSD.writeBooleanTextNode),phoneNumber:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),styleUrl:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode),visibility:ol.xml.makeChildAppender(ol.format.XSD.writeBooleanTextNode)}),ol.format.KML.PRIMITIVE_GEOMETRY_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{coordinates:ol.xml.makeChildAppender(ol.format.KML.writeCoordinatesTextNode_)}),ol.format.KML.POLYGON_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{outerBoundaryIs:ol.xml.makeChildAppender(ol.format.KML.writeBoundaryIs_),innerBoundaryIs:ol.xml.makeChildAppender(ol.format.KML.writeBoundaryIs_)}),ol.format.KML.POLY_STYLE_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{color:ol.xml.makeChildAppender(ol.format.KML.writeColorTextNode_)}),ol.format.KML.STYLE_SEQUENCE_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,["IconStyle","LabelStyle","LineStyle","PolyStyle"]),ol.format.KML.STYLE_SERIALIZERS_=ol.xml.makeStructureNS(ol.format.KML.NAMESPACE_URIS_,{IconStyle:ol.xml.makeChildAppender(ol.format.KML.writeIconStyle_),LabelStyle:ol.xml.makeChildAppender(ol.format.KML.writeLabelStyle_),LineStyle:ol.xml.makeChildAppender(ol.format.KML.writeLineStyle_),PolyStyle:ol.xml.makeChildAppender(ol.format.KML.writePolyStyle_)}),ol.format.KML.GX_NODE_FACTORY_=function(e,o,t){return ol.xml.createElementNS(ol.format.KML.GX_NAMESPACE_URIS_[0],"gx:"+t)},ol.format.KML.DOCUMENT_NODE_FACTORY_=function(e,o,t){var r=o[o.length-1].node;return ol.DEBUG&&console.assert(ol.xml.isNode(r),"parentNode should be an XML node"),ol.xml.createElementNS(r.namespaceURI,"Placemark")},ol.format.KML.GEOMETRY_NODE_FACTORY_=function(e,o,t){if(e){var r=o[o.length-1].node;return ol.DEBUG&&console.assert(ol.xml.isNode(r),"parentNode should be an XML node"),ol.xml.createElementNS(r.namespaceURI,ol.format.KML.GEOMETRY_TYPE_TO_NODENAME_[e.getType()])}},ol.format.KML.COLOR_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("color"),ol.format.KML.COORDINATES_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("coordinates"),ol.format.KML.DATA_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("Data"),ol.format.KML.EXTENDEDDATA_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("ExtendedData"),ol.format.KML.INNER_BOUNDARY_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("innerBoundaryIs"),ol.format.KML.POINT_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("Point"),ol.format.KML.LINE_STRING_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("LineString"),ol.format.KML.LINEAR_RING_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("LinearRing"),ol.format.KML.POLYGON_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("Polygon"),ol.format.KML.OUTER_BOUNDARY_NODE_FACTORY_=ol.xml.makeSimpleNodeFactory("outerBoundaryIs"),ol.format.KML.prototype.writeFeatures,ol.format.KML.prototype.writeFeaturesNode=function(e,o){o=this.adaptOptions(o);var t=ol.xml.createElementNS(ol.format.KML.NAMESPACE_URIS_[4],"kml"),r="http://www.w3.org/2000/xmlns/";ol.xml.setAttributeNS(t,r,"xmlns:gx",ol.format.KML.GX_NAMESPACE_URIS_[0]),ol.xml.setAttributeNS(t,r,"xmlns:xsi","http://www.w3.org/2001/XMLSchema-instance"),ol.xml.setAttributeNS(t,"http://www.w3.org/2001/XMLSchema-instance","xsi:schemaLocation",ol.format.KML.SCHEMA_LOCATION_);var i={node:t},n={};e.length>1?n.Document=e:1==e.length&&(n.Placemark=e[0]);var l=ol.format.KML.KML_SEQUENCE_[t.namespaceURI],a=ol.xml.makeSequence(n,l);return ol.xml.pushSerializeAndPop(i,ol.format.KML.KML_SERIALIZERS_,ol.xml.OBJECT_PROPERTY_NODE_FACTORY,a,[o],l,this),t},goog.provide("ol.ext.pbf"),ol.ext.pbf,function(){var e,o={},t={exports:o};!function(r){if("object"==typeof o&&void 0!==t)t.exports=r();else if("function"==typeof e&&e.amd)e([],r);else{var i;i="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,i.pbf=r()}}(function(){return function e(o,t,r){function i(l,a){if(!t[l]){if(!o[l]){var s="function"==typeof require&&require;if(!a&&s)return s(l,!0);if(n)return n(l,!0);var p=new Error("Cannot find module '"+l+"'");throw p.code="MODULE_NOT_FOUND",p}var g=t[l]={exports:{}};o[l][0].call(g.exports,function(e){var t=o[l][1][e];return i(t||e)},g,g.exports,e,o,t,r)}return t[l].exports}for(var n="function"==typeof require&&require,l=0;l<r.length;l++)i(r[l]);return i}({1:[function(e,o,t){t.read=function(e,o,t,r,i){var n,l,a=8*i-r-1,s=(1<<a)-1,p=s>>1,g=-7,c=t?i-1:0,u=t?-1:1,y=e[o+c];for(c+=u,n=y&(1<<-g)-1,y>>=-g,g+=a;g>0;n=256*n+e[o+c],c+=u,g-=8);for(l=n&(1<<-g)-1,n>>=-g,g+=r;g>0;l=256*l+e[o+c],c+=u,g-=8);if(0===n)n=1-p;else{if(n===s)return l?NaN:1/0*(y?-1:1);l+=Math.pow(2,r),n-=p}return(y?-1:1)*l*Math.pow(2,n-r)},t.write=function(e,o,t,r,i,n){var l,a,s,p=8*n-i-1,g=(1<<p)-1,c=g>>1,u=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,y=r?0:n-1,d=r?1:-1,h=o<0||0===o&&1/o<0?1:0;for(o=Math.abs(o),isNaN(o)||o===1/0?(a=isNaN(o)?1:0,l=g):(l=Math.floor(Math.log(o)/Math.LN2),o*(s=Math.pow(2,-l))<1&&(l--,s*=2),o+=l+c>=1?u/s:u*Math.pow(2,1-c),o*s>=2&&(l++,s/=2),l+c>=g?(a=0,l=g):l+c>=1?(a=(o*s-1)*Math.pow(2,i),l+=c):(a=o*Math.pow(2,c-1)*Math.pow(2,i),l=0));i>=8;e[t+y]=255&a,y+=d,a/=256,i-=8);for(l=l<<i|a,p+=i;p>0;e[t+y]=255&l,y+=d,l/=256,p-=8);e[t+y-d]|=128*h}},{}],2:[function(e,o,t){"use strict";function r(e){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(e)?e:new Uint8Array(e||0),this.pos=0,this.type=0,this.length=this.buf.length}function i(e,o,t){var r,i,n=t.buf;if(i=n[t.pos++],r=(112&i)>>4,i<128)return l(e,r,o);if(i=n[t.pos++],r|=(127&i)<<3,i<128)return l(e,r,o);if(i=n[t.pos++],r|=(127&i)<<10,i<128)return l(e,r,o);if(i=n[t.pos++],r|=(127&i)<<17,i<128)return l(e,r,o);if(i=n[t.pos++],r|=(127&i)<<24,i<128)return l(e,r,o);if(i=n[t.pos++],r|=(1&i)<<31,i<128)return l(e,r,o);throw new Error("Expected varint not more than 10 bytes")}function n(e){return e.type===r.Bytes?e.readVarint()+e.pos:e.pos+1}function l(e,o,t){return t?4294967296*o+(e>>>0):4294967296*(o>>>0)+(e>>>0)}function a(e,o){var t,r;if(e>=0?(t=e%4294967296|0,r=e/4294967296|0):(t=~(-e%4294967296),r=~(-e/4294967296),4294967295^t?t=t+1|0:(t=0,r=r+1|0)),e>=0x10000000000000000||e<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");o.realloc(10),s(t,r,o),p(r,o)}function s(e,o,t){t.buf[t.pos++]=127&e|128,e>>>=7,t.buf[t.pos++]=127&e|128,e>>>=7,t.buf[t.pos++]=127&e|128,e>>>=7,t.buf[t.pos++]=127&e|128,e>>>=7,t.buf[t.pos]=127&e}function p(e,o){var t=(7&e)<<4;o.buf[o.pos++]|=t|((e>>>=3)?128:0),e&&(o.buf[o.pos++]=127&e|((e>>>=7)?128:0),e&&(o.buf[o.pos++]=127&e|((e>>>=7)?128:0),e&&(o.buf[o.pos++]=127&e|((e>>>=7)?128:0),e&&(o.buf[o.pos++]=127&e|((e>>>=7)?128:0),e&&(o.buf[o.pos++]=127&e)))))}function g(e,o,t){var r=o<=16383?1:o<=2097151?2:o<=268435455?3:Math.ceil(Math.log(o)/(7*Math.LN2));t.realloc(r);for(var i=t.pos-1;i>=e;i--)t.buf[i+r]=t.buf[i]}function c(e,o){for(var t=0;t<e.length;t++)o.writeVarint(e[t])}function u(e,o){for(var t=0;t<e.length;t++)o.writeSVarint(e[t])}function y(e,o){for(var t=0;t<e.length;t++)o.writeFloat(e[t])}function d(e,o){for(var t=0;t<e.length;t++)o.writeDouble(e[t])}function h(e,o){for(var t=0;t<e.length;t++)o.writeBoolean(e[t])}function m(e,o){for(var t=0;t<e.length;t++)o.writeFixed32(e[t])}function f(e,o){for(var t=0;t<e.length;t++)o.writeSFixed32(e[t])}function _(e,o){for(var t=0;t<e.length;t++)o.writeFixed64(e[t])}function E(e,o){for(var t=0;t<e.length;t++)o.writeSFixed64(e[t])}function v(e,o){return(e[o]|e[o+1]<<8|e[o+2]<<16)+16777216*e[o+3]}function S(e,o,t){e[t]=o,e[t+1]=o>>>8,e[t+2]=o>>>16,e[t+3]=o>>>24}function x(e,o){return(e[o]|e[o+1]<<8|e[o+2]<<16)+(e[o+3]<<24)}function P(e,o,t){for(var r="",i=o;i<t;){var n=e[i],l=null,a=n>239?4:n>223?3:n>191?2:1;if(i+a>t)break;var s,p,g;1===a?n<128&&(l=n):2===a?128==(192&(s=e[i+1]))&&(l=(31&n)<<6|63&s)<=127&&(l=null):3===a?(s=e[i+1],p=e[i+2],128==(192&s)&&128==(192&p)&&((l=(15&n)<<12|(63&s)<<6|63&p)<=2047||l>=55296&&l<=57343)&&(l=null)):4===a&&(s=e[i+1],p=e[i+2],g=e[i+3],128==(192&s)&&128==(192&p)&&128==(192&g)&&((l=(15&n)<<18|(63&s)<<12|(63&p)<<6|63&g)<=65535||l>=1114112)&&(l=null)),null===l?(l=65533,a=1):l>65535&&(l-=65536,r+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),r+=String.fromCharCode(l),i+=a}return r}function T(e,o,t){for(var r,i,n=0;n<o.length;n++){if((r=o.charCodeAt(n))>55295&&r<57344){if(!i){r>56319||n+1===o.length?(e[t++]=239,e[t++]=191,e[t++]=189):i=r;continue}if(r<56320){e[t++]=239,e[t++]=191,e[t++]=189,i=r;continue}r=i-55296<<10|r-56320|65536,i=null}else i&&(e[t++]=239,e[t++]=191,e[t++]=189,i=null);r<128?e[t++]=r:(r<2048?e[t++]=r>>6|192:(r<65536?e[t++]=r>>12|224:(e[t++]=r>>18|240,e[t++]=r>>12&63|128),e[t++]=r>>6&63|128),e[t++]=63&r|128)}return t}o.exports=r;var R=e("ieee754");r.Varint=0,r.Fixed64=1,r.Bytes=2,r.Fixed32=5;r.prototype={destroy:function(){this.buf=null},readFields:function(e,o,t){for(t=t||this.length;this.pos<t;){var r=this.readVarint(),i=r>>3,n=this.pos;this.type=7&r,e(i,o,this),this.pos===n&&this.skip(r)}return o},readMessage:function(e,o){return this.readFields(e,o,this.readVarint()+this.pos)},readFixed32:function(){var e=v(this.buf,this.pos);return this.pos+=4,e},readSFixed32:function(){var e=x(this.buf,this.pos);return this.pos+=4,e},readFixed64:function(){var e=v(this.buf,this.pos)+4294967296*v(this.buf,this.pos+4);return this.pos+=8,e},readSFixed64:function(){var e=v(this.buf,this.pos)+4294967296*x(this.buf,this.pos+4);return this.pos+=8,e},readFloat:function(){var e=R.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=R.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(e){var o,t,r=this.buf;return t=r[this.pos++],o=127&t,t<128?o:(t=r[this.pos++],o|=(127&t)<<7,t<128?o:(t=r[this.pos++],o|=(127&t)<<14,t<128?o:(t=r[this.pos++],o|=(127&t)<<21,t<128?o:(t=r[this.pos],o|=(15&t)<<28,i(o,e,this)))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var e=this.readVarint();return e%2==1?(e+1)/-2:e/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var e=this.readVarint()+this.pos,o=P(this.buf,this.pos,e);return this.pos=e,o},readBytes:function(){var e=this.readVarint()+this.pos,o=this.buf.subarray(this.pos,e);return this.pos=e,o},readPackedVarint:function(e,o){var t=n(this);for(e=e||[];this.pos<t;)e.push(this.readVarint(o));return e},readPackedSVarint:function(e){var o=n(this);for(e=e||[];this.pos<o;)e.push(this.readSVarint());return e},readPackedBoolean:function(e){var o=n(this);for(e=e||[];this.pos<o;)e.push(this.readBoolean());return e},readPackedFloat:function(e){var o=n(this);for(e=e||[];this.pos<o;)e.push(this.readFloat());return e},readPackedDouble:function(e){var o=n(this);for(e=e||[];this.pos<o;)e.push(this.readDouble());return e},readPackedFixed32:function(e){var o=n(this);for(e=e||[];this.pos<o;)e.push(this.readFixed32());return e},readPackedSFixed32:function(e){var o=n(this);for(e=e||[];this.pos<o;)e.push(this.readSFixed32());return e},readPackedFixed64:function(e){var o=n(this);for(e=e||[];this.pos<o;)e.push(this.readFixed64());return e},readPackedSFixed64:function(e){var o=n(this);for(e=e||[];this.pos<o;)e.push(this.readSFixed64());return e},skip:function(e){var o=7&e;if(o===r.Varint)for(;this.buf[this.pos++]>127;);else if(o===r.Bytes)this.pos=this.readVarint()+this.pos;else if(o===r.Fixed32)this.pos+=4;else{if(o!==r.Fixed64)throw new Error("Unimplemented type: "+o);this.pos+=8}},writeTag:function(e,o){this.writeVarint(e<<3|o)},realloc:function(e){for(var o=this.length||16;o<this.pos+e;)o*=2;if(o!==this.length){var t=new Uint8Array(o);t.set(this.buf),this.buf=t,
this.length=o}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(e){this.realloc(4),S(this.buf,e,this.pos),this.pos+=4},writeSFixed32:function(e){this.realloc(4),S(this.buf,e,this.pos),this.pos+=4},writeFixed64:function(e){this.realloc(8),S(this.buf,-1&e,this.pos),S(this.buf,Math.floor(e*(1/4294967296)),this.pos+4),this.pos+=8},writeSFixed64:function(e){this.realloc(8),S(this.buf,-1&e,this.pos),S(this.buf,Math.floor(e*(1/4294967296)),this.pos+4),this.pos+=8},writeVarint:function(e){if((e=+e||0)>268435455||e<0)return void a(e,this);this.realloc(4),this.buf[this.pos++]=127&e|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=e>>>7&127)))},writeSVarint:function(e){this.writeVarint(e<0?2*-e-1:2*e)},writeBoolean:function(e){this.writeVarint(Boolean(e))},writeString:function(e){e=String(e),this.realloc(4*e.length),this.pos++;var o=this.pos;this.pos=T(this.buf,e,this.pos);var t=this.pos-o;t>=128&&g(o,t,this),this.pos=o-1,this.writeVarint(t),this.pos+=t},writeFloat:function(e){this.realloc(4),R.write(this.buf,e,this.pos,!0,23,4),this.pos+=4},writeDouble:function(e){this.realloc(8),R.write(this.buf,e,this.pos,!0,52,8),this.pos+=8},writeBytes:function(e){var o=e.length;this.writeVarint(o),this.realloc(o);for(var t=0;t<o;t++)this.buf[this.pos++]=e[t]},writeRawMessage:function(e,o){this.pos++;var t=this.pos;e(o,this);var r=this.pos-t;r>=128&&g(t,r,this),this.pos=t-1,this.writeVarint(r),this.pos+=r},writeMessage:function(e,o,t){this.writeTag(e,r.Bytes),this.writeRawMessage(o,t)},writePackedVarint:function(e,o){this.writeMessage(e,c,o)},writePackedSVarint:function(e,o){this.writeMessage(e,u,o)},writePackedBoolean:function(e,o){this.writeMessage(e,h,o)},writePackedFloat:function(e,o){this.writeMessage(e,y,o)},writePackedDouble:function(e,o){this.writeMessage(e,d,o)},writePackedFixed32:function(e,o){this.writeMessage(e,m,o)},writePackedSFixed32:function(e,o){this.writeMessage(e,f,o)},writePackedFixed64:function(e,o){this.writeMessage(e,_,o)},writePackedSFixed64:function(e,o){this.writeMessage(e,E,o)},writeBytesField:function(e,o){this.writeTag(e,r.Bytes),this.writeBytes(o)},writeFixed32Field:function(e,o){this.writeTag(e,r.Fixed32),this.writeFixed32(o)},writeSFixed32Field:function(e,o){this.writeTag(e,r.Fixed32),this.writeSFixed32(o)},writeFixed64Field:function(e,o){this.writeTag(e,r.Fixed64),this.writeFixed64(o)},writeSFixed64Field:function(e,o){this.writeTag(e,r.Fixed64),this.writeSFixed64(o)},writeVarintField:function(e,o){this.writeTag(e,r.Varint),this.writeVarint(o)},writeSVarintField:function(e,o){this.writeTag(e,r.Varint),this.writeSVarint(o)},writeStringField:function(e,o){this.writeTag(e,r.Bytes),this.writeString(o)},writeFloatField:function(e,o){this.writeTag(e,r.Fixed32),this.writeFloat(o)},writeDoubleField:function(e,o){this.writeTag(e,r.Fixed64),this.writeDouble(o)},writeBooleanField:function(e,o){this.writeVarintField(e,Boolean(o))}}},{ieee754:1}]},{},[2])(2)}),ol.ext.pbf=t.exports}(),goog.provide("ol.ext.vectortile"),ol.ext.vectortile,function(){var e,o={},t={exports:o};!function(r){if("object"==typeof o&&void 0!==t)t.exports=r();else if("function"==typeof e&&e.amd)e([],r);else{var i;i="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,i.vectortile=r()}}(function(){return function e(o,t,r){function i(l,a){if(!t[l]){if(!o[l]){var s="function"==typeof require&&require;if(!a&&s)return s(l,!0);if(n)return n(l,!0);var p=new Error("Cannot find module '"+l+"'");throw p.code="MODULE_NOT_FOUND",p}var g=t[l]={exports:{}};o[l][0].call(g.exports,function(e){var t=o[l][1][e];return i(t||e)},g,g.exports,e,o,t,r)}return t[l].exports}for(var n="function"==typeof require&&require,l=0;l<r.length;l++)i(r[l]);return i}({1:[function(e,o,t){"use strict";function r(e,o){this.x=e,this.y=o}o.exports=r,r.prototype={clone:function(){return new r(this.x,this.y)},add:function(e){return this.clone()._add(e)},sub:function(e){return this.clone()._sub(e)},mult:function(e){return this.clone()._mult(e)},div:function(e){return this.clone()._div(e)},rotate:function(e){return this.clone()._rotate(e)},matMult:function(e){return this.clone()._matMult(e)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(e){return this.x===e.x&&this.y===e.y},dist:function(e){return Math.sqrt(this.distSqr(e))},distSqr:function(e){var o=e.x-this.x,t=e.y-this.y;return o*o+t*t},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(e){return Math.atan2(this.y-e.y,this.x-e.x)},angleWith:function(e){return this.angleWithSep(e.x,e.y)},angleWithSep:function(e,o){return Math.atan2(this.x*o-this.y*e,this.x*e+this.y*o)},_matMult:function(e){var o=e[0]*this.x+e[1]*this.y,t=e[2]*this.x+e[3]*this.y;return this.x=o,this.y=t,this},_add:function(e){return this.x+=e.x,this.y+=e.y,this},_sub:function(e){return this.x-=e.x,this.y-=e.y,this},_mult:function(e){return this.x*=e,this.y*=e,this},_div:function(e){return this.x/=e,this.y/=e,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var e=this.y;return this.y=this.x,this.x=-e,this},_rotate:function(e){var o=Math.cos(e),t=Math.sin(e),r=o*this.x-t*this.y,i=t*this.x+o*this.y;return this.x=r,this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},r.convert=function(e){return e instanceof r?e:Array.isArray(e)?new r(e[0],e[1]):e}},{}],2:[function(e,o,t){o.exports.VectorTile=e("./lib/vectortile.js"),o.exports.VectorTileFeature=e("./lib/vectortilefeature.js"),o.exports.VectorTileLayer=e("./lib/vectortilelayer.js")},{"./lib/vectortile.js":3,"./lib/vectortilefeature.js":4,"./lib/vectortilelayer.js":5}],3:[function(e,o,t){"use strict";function r(e,o){this.layers=e.readFields(i,{},o)}function i(e,o,t){if(3===e){var r=new n(t,t.readVarint()+t.pos);r.length&&(o[r.name]=r)}}var n=e("./vectortilelayer");o.exports=r},{"./vectortilelayer":5}],4:[function(e,o,t){"use strict";function r(e,o,t,r,n){this.properties={},this.extent=t,this.type=0,this._pbf=e,this._geometry=-1,this._keys=r,this._values=n,e.readFields(i,this,o)}function i(e,o,t){1==e?o.id=t.readVarint():2==e?n(t,o):3==e?o.type=t.readVarint():4==e&&(o._geometry=t.pos)}function n(e,o){for(var t=e.readVarint()+e.pos;e.pos<t;){var r=o._keys[e.readVarint()],i=o._values[e.readVarint()];o.properties[r]=i}}function l(e){var o=e.length;if(o<=1)return[e];for(var t,r,i=[],n=0;n<o;n++){var l=a(e[n]);0!==l&&(void 0===r&&(r=l<0),r===l<0?(t&&i.push(t),t=[e[n]]):t.push(e[n]))}return t&&i.push(t),i}function a(e){for(var o,t,r=0,i=0,n=e.length,l=n-1;i<n;l=i++)o=e[i],t=e[l],r+=(t.x-o.x)*(o.y+t.y);return r}var s=e("point-geometry");o.exports=r,r.types=["Unknown","Point","LineString","Polygon"],r.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var o,t=e.readVarint()+e.pos,r=1,i=0,n=0,l=0,a=[];e.pos<t;){if(!i){var p=e.readVarint();r=7&p,i=p>>3}if(i--,1===r||2===r)n+=e.readSVarint(),l+=e.readSVarint(),1===r&&(o&&a.push(o),o=[]),o.push(new s(n,l));else{if(7!==r)throw new Error("unknown command "+r);o&&o.push(o[0].clone())}}return o&&a.push(o),a},r.prototype.bbox=function(){var e=this._pbf;e.pos=this._geometry;for(var o=e.readVarint()+e.pos,t=1,r=0,i=0,n=0,l=1/0,a=-1/0,s=1/0,p=-1/0;e.pos<o;){if(!r){var g=e.readVarint();t=7&g,r=g>>3}if(r--,1===t||2===t)i+=e.readSVarint(),n+=e.readSVarint(),i<l&&(l=i),i>a&&(a=i),n<s&&(s=n),n>p&&(p=n);else if(7!==t)throw new Error("unknown command "+t)}return[l,s,a,p]},r.prototype.toGeoJSON=function(e,o,t){function i(e){for(var o=0;o<e.length;o++){var t=e[o],r=180-360*(t.y+g)/s;e[o]=[360*(t.x+p)/s-180,360/Math.PI*Math.atan(Math.exp(r*Math.PI/180))-90]}}var n,a,s=this.extent*Math.pow(2,t),p=this.extent*e,g=this.extent*o,c=this.loadGeometry(),u=r.types[this.type];switch(this.type){case 1:var y=[];for(n=0;n<c.length;n++)y[n]=c[n][0];c=y,i(c);break;case 2:for(n=0;n<c.length;n++)i(c[n]);break;case 3:for(c=l(c),n=0;n<c.length;n++)for(a=0;a<c[n].length;a++)i(c[n][a])}1===c.length?c=c[0]:u="Multi"+u;var d={type:"Feature",geometry:{type:u,coordinates:c},properties:this.properties};return"id"in this&&(d.id=this.id),d}},{"point-geometry":1}],5:[function(e,o,t){"use strict";function r(e,o){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=e,this._keys=[],this._values=[],this._features=[],e.readFields(i,this,o),this.length=this._features.length}function i(e,o,t){15===e?o.version=t.readVarint():1===e?o.name=t.readString():5===e?o.extent=t.readVarint():2===e?o._features.push(t.pos):3===e?o._keys.push(t.readString()):4===e&&o._values.push(n(t))}function n(e){for(var o=null,t=e.readVarint()+e.pos;e.pos<t;){var r=e.readVarint()>>3;o=1===r?e.readString():2===r?e.readFloat():3===r?e.readDouble():4===r?e.readVarint64():5===r?e.readVarint():6===r?e.readSVarint():7===r?e.readBoolean():null}return o}var l=e("./vectortilefeature.js");o.exports=r,r.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var o=this._pbf.readVarint()+this._pbf.pos;return new l(this._pbf,o,this.extent,this._keys,this._values)}},{"./vectortilefeature.js":4}]},{},[2])(2)}),ol.ext.vectortile=t.exports}(),goog.provide("ol.render.Feature"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.geom.GeometryType"),ol.render.Feature=function(e,o,t,r){this.extent_,ol.DEBUG&&console.assert(e===ol.geom.GeometryType.POINT||e===ol.geom.GeometryType.MULTI_POINT||e===ol.geom.GeometryType.LINE_STRING||e===ol.geom.GeometryType.MULTI_LINE_STRING||e===ol.geom.GeometryType.POLYGON,"Need a Point, MultiPoint, LineString, MultiLineString or Polygon type"),this.type_=e,this.flatCoordinates_=o,this.ends_=t,this.properties_=r},ol.render.Feature.prototype.get=function(e){return this.properties_[e]},ol.render.Feature.prototype.getEnds=function(){return this.ends_},ol.render.Feature.prototype.getExtent=function(){return this.extent_||(this.extent_=this.type_===ol.geom.GeometryType.POINT?ol.extent.createOrUpdateFromCoordinate(this.flatCoordinates_):ol.extent.createOrUpdateFromFlatCoordinates(this.flatCoordinates_,0,this.flatCoordinates_.length,2)),this.extent_},ol.render.Feature.prototype.getOrientedFlatCoordinates=function(){return this.flatCoordinates_},ol.render.Feature.prototype.getFlatCoordinates=ol.render.Feature.prototype.getOrientedFlatCoordinates,ol.render.Feature.prototype.getGeometry=function(){return this},ol.render.Feature.prototype.getProperties=function(){return this.properties_},ol.render.Feature.prototype.getSimplifiedGeometry=ol.render.Feature.prototype.getGeometry,ol.render.Feature.prototype.getStride=function(){return 2},ol.render.Feature.prototype.getStyleFunction=ol.nullFunction,ol.render.Feature.prototype.getType=function(){return this.type_},goog.provide("ol.format.MVT"),goog.require("ol"),goog.require("ol.ext.pbf"),goog.require("ol.ext.vectortile"),goog.require("ol.format.Feature"),goog.require("ol.format.FormatType"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.LineString"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.MultiPoint"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.proj.Projection"),goog.require("ol.proj.Units"),goog.require("ol.render.Feature"),ol.format.MVT=function(e){ol.format.Feature.call(this);var o=e||{};this.defaultDataProjection=new ol.proj.Projection({code:"",units:ol.proj.Units.TILE_PIXELS}),this.featureClass_=o.featureClass?o.featureClass:ol.render.Feature,this.geometryName_=o.geometryName?o.geometryName:"geometry",this.layerName_=o.layerName?o.layerName:"layer",this.layers_=o.layers?o.layers:null},ol.inherits(ol.format.MVT,ol.format.Feature),ol.format.MVT.prototype.getType=function(){return ol.format.FormatType.ARRAY_BUFFER},ol.format.MVT.prototype.readFeature_=function(e,o,t){var r=new this.featureClass_,i=e.id,n=e.properties;n[this.layerName_]=o;var l=ol.format.Feature.transformWithOptions(ol.format.MVT.readGeometry_(e),!1,this.adaptOptions(t));return l&&(n[this.geometryName_]=l),r.setId(i),r.setProperties(n),r.setGeometryName(this.geometryName_),r},ol.format.MVT.prototype.readRenderFeature_=function(e,o){var t=e.loadGeometry(),r=[],i=[];ol.format.MVT.calculateFlatCoordinates_(t,i,r);var n,l=e.type;1===l?n=1===t.length?ol.geom.GeometryType.POINT:ol.geom.GeometryType.MULTI_POINT:2===l?n=1===t.length?ol.geom.GeometryType.LINE_STRING:ol.geom.GeometryType.MULTI_LINE_STRING:3===l&&(n=ol.geom.GeometryType.POLYGON);var a=e.properties;return a[this.layerName_]=o,new this.featureClass_(n,i,r,a)},ol.format.MVT.prototype.readFeatures=function(e,o){var t,r,i=this.layers_,n=new ol.ext.pbf(e),l=new ol.ext.vectortile.VectorTile(n),a=[],s=this.featureClass_;for(var p in l.layers)if(!i||-1!=i.indexOf(p)){t=l.layers[p];for(var g=0,c=t.length;g<c;++g)r=s===ol.render.Feature?this.readRenderFeature_(t.feature(g),p):this.readFeature_(t.feature(g),p,o),a.push(r)}return a},ol.format.MVT.prototype.readProjection=function(e){return this.defaultDataProjection},ol.format.MVT.prototype.setLayers=function(e){this.layers_=e},ol.format.MVT.calculateFlatCoordinates_=function(e,o,t){for(var r=0,i=0,n=e.length;i<n;++i){var l,a,s=e[i];for(l=0,a=s.length;l<a;++l){var p=s[l];o.push(p.x,p.y)}r+=2*l,t.push(r)}},ol.format.MVT.readGeometry_=function(e){var o=e.type;if(0===o)return null;var t=e.loadGeometry(),r=[],i=[];ol.format.MVT.calculateFlatCoordinates_(t,i,r);var n;return 1===o?n=1===t.length?new ol.geom.Point(null):new ol.geom.MultiPoint(null):2===o?n=1===t.length?new ol.geom.LineString(null):new ol.geom.MultiLineString(null):3===o&&(n=new ol.geom.Polygon(null)),n.setFlatCoordinates(ol.geom.GeometryLayout.XY,i,r),n},goog.provide("ol.format.OSMXML"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.Feature"),goog.require("ol.format.Feature"),goog.require("ol.format.XMLFeature"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.LineString"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.obj"),goog.require("ol.proj"),goog.require("ol.xml"),ol.format.OSMXML=function(){ol.format.XMLFeature.call(this),this.defaultDataProjection=ol.proj.get("EPSG:4326")},ol.inherits(ol.format.OSMXML,ol.format.XMLFeature),ol.format.OSMXML.EXTENSIONS_=[".osm"],ol.format.OSMXML.prototype.getExtensions=function(){return ol.format.OSMXML.EXTENSIONS_},ol.format.OSMXML.readNode_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("node"==e.localName,"localName should be node");var t=o[0],r=o[o.length-1],i=e.getAttribute("id"),n=[parseFloat(e.getAttribute("lon")),parseFloat(e.getAttribute("lat"))];r.nodes[i]=n;var l=ol.xml.pushParseAndPop({tags:{}},ol.format.OSMXML.NODE_PARSERS_,e,o);if(!ol.obj.isEmpty(l.tags)){var a=new ol.geom.Point(n);ol.format.Feature.transformWithOptions(a,!1,t);var s=new ol.Feature(a);s.setId(i),s.setProperties(l.tags),r.features.push(s)}},ol.format.OSMXML.readWay_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("way"==e.localName,"localName should be way");for(var t=o[0],r=e.getAttribute("id"),i=ol.xml.pushParseAndPop({ndrefs:[],tags:{}},ol.format.OSMXML.WAY_PARSERS_,e,o),n=o[o.length-1],l=[],a=0,s=i.ndrefs.length;a<s;a++){var p=n.nodes[i.ndrefs[a]];ol.array.extend(l,p)}var g;i.ndrefs[0]==i.ndrefs[i.ndrefs.length-1]?(g=new ol.geom.Polygon(null),g.setFlatCoordinates(ol.geom.GeometryLayout.XY,l,[l.length])):(g=new ol.geom.LineString(null),g.setFlatCoordinates(ol.geom.GeometryLayout.XY,l)),ol.format.Feature.transformWithOptions(g,!1,t);var c=new ol.Feature(g);c.setId(r),c.setProperties(i.tags),n.features.push(c)},ol.format.OSMXML.readNd_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("nd"==e.localName,"localName should be nd"),o[o.length-1].ndrefs.push(e.getAttribute("ref"))},ol.format.OSMXML.readTag_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("tag"==e.localName,"localName should be tag"),o[o.length-1].tags[e.getAttribute("k")]=e.getAttribute("v")},ol.format.OSMXML.NAMESPACE_URIS_=[null],ol.format.OSMXML.WAY_PARSERS_=ol.xml.makeStructureNS(ol.format.OSMXML.NAMESPACE_URIS_,{nd:ol.format.OSMXML.readNd_,tag:ol.format.OSMXML.readTag_}),ol.format.OSMXML.PARSERS_=ol.xml.makeStructureNS(ol.format.OSMXML.NAMESPACE_URIS_,{node:ol.format.OSMXML.readNode_,way:ol.format.OSMXML.readWay_}),ol.format.OSMXML.NODE_PARSERS_=ol.xml.makeStructureNS(ol.format.OSMXML.NAMESPACE_URIS_,{tag:ol.format.OSMXML.readTag_}),ol.format.OSMXML.prototype.readFeatures,ol.format.OSMXML.prototype.readFeaturesFromNode=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT");var t=this.getReadOptions(e,o);if("osm"==e.localName){var r=ol.xml.pushParseAndPop({nodes:{},features:[]},ol.format.OSMXML.PARSERS_,e,[t]);if(r.features)return r.features}return[]},ol.format.OSMXML.prototype.readProjection;goog.provide("ol.format.XLink"),ol.format.XLink.NAMESPACE_URI="http://www.w3.org/1999/xlink",ol.format.XLink.readHref=function(e){return e.getAttributeNS(ol.format.XLink.NAMESPACE_URI,"href")},goog.provide("ol.format.XML"),goog.require("ol.xml"),ol.format.XML=function(){},ol.format.XML.prototype.read=function(e){if(ol.xml.isDocument(e))return this.readFromDocument(e);if(ol.xml.isNode(e))return this.readFromNode(e);if("string"==typeof e){var o=ol.xml.parse(e);return this.readFromDocument(o)}return null},ol.format.XML.prototype.readFromDocument=function(e){},ol.format.XML.prototype.readFromNode=function(e){},goog.provide("ol.format.OWS"),goog.require("ol"),goog.require("ol.format.XLink"),goog.require("ol.format.XML"),goog.require("ol.format.XSD"),goog.require("ol.xml"),ol.format.OWS=function(){ol.format.XML.call(this)},ol.inherits(ol.format.OWS,ol.format.XML),ol.format.OWS.prototype.readFromDocument=function(e){ol.DEBUG&&console.assert(e.nodeType==Node.DOCUMENT_NODE,"doc.nodeType should be DOCUMENT");for(var o=e.firstChild;o;o=o.nextSibling)if(o.nodeType==Node.ELEMENT_NODE)return this.readFromNode(o);return null},ol.format.OWS.prototype.readFromNode=function(e){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT");var o=ol.xml.pushParseAndPop({},ol.format.OWS.PARSERS_,e,[]);return o||null},ol.format.OWS.readAddress_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Address"==e.localName,"localName should be Address"),ol.xml.pushParseAndPop({},ol.format.OWS.ADDRESS_PARSERS_,e,o)},ol.format.OWS.readAllowedValues_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("AllowedValues"==e.localName,"localName should be AllowedValues"),ol.xml.pushParseAndPop({},ol.format.OWS.ALLOWED_VALUES_PARSERS_,e,o)},ol.format.OWS.readConstraint_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Constraint"==e.localName,"localName should be Constraint");var t=e.getAttribute("name");if(t)return ol.xml.pushParseAndPop({name:t},ol.format.OWS.CONSTRAINT_PARSERS_,e,o)},ol.format.OWS.readContactInfo_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("ContactInfo"==e.localName,"localName should be ContactInfo"),ol.xml.pushParseAndPop({},ol.format.OWS.CONTACT_INFO_PARSERS_,e,o)},ol.format.OWS.readDcp_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("DCP"==e.localName,"localName should be DCP"),ol.xml.pushParseAndPop({},ol.format.OWS.DCP_PARSERS_,e,o)},ol.format.OWS.readGet_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Get"==e.localName,"localName should be Get");var t=ol.format.XLink.readHref(e);if(t)return ol.xml.pushParseAndPop({href:t},ol.format.OWS.REQUEST_METHOD_PARSERS_,e,o)},ol.format.OWS.readHttp_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("HTTP"==e.localName,"localName should be HTTP"),ol.xml.pushParseAndPop({},ol.format.OWS.HTTP_PARSERS_,e,o)},ol.format.OWS.readOperation_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Operation"==e.localName,"localName should be Operation");var t=e.getAttribute("name"),r=ol.xml.pushParseAndPop({},ol.format.OWS.OPERATION_PARSERS_,e,o);if(r){o[o.length-1][t]=r}},ol.format.OWS.readOperationsMetadata_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("OperationsMetadata"==e.localName,"localName should be OperationsMetadata"),ol.xml.pushParseAndPop({},ol.format.OWS.OPERATIONS_METADATA_PARSERS_,e,o)},ol.format.OWS.readPhone_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Phone"==e.localName,"localName should be Phone"),ol.xml.pushParseAndPop({},ol.format.OWS.PHONE_PARSERS_,e,o)},ol.format.OWS.readServiceIdentification_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("ServiceIdentification"==e.localName,"localName should be ServiceIdentification"),ol.xml.pushParseAndPop({},ol.format.OWS.SERVICE_IDENTIFICATION_PARSERS_,e,o)},ol.format.OWS.readServiceContact_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("ServiceContact"==e.localName,"localName should be ServiceContact"),ol.xml.pushParseAndPop({},ol.format.OWS.SERVICE_CONTACT_PARSERS_,e,o)},ol.format.OWS.readServiceProvider_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("ServiceProvider"==e.localName,"localName should be ServiceProvider"),ol.xml.pushParseAndPop({},ol.format.OWS.SERVICE_PROVIDER_PARSERS_,e,o)},ol.format.OWS.readValue_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Value"==e.localName,"localName should be Value"),ol.format.XSD.readString(e)},ol.format.OWS.NAMESPACE_URIS_=[null,"http://www.opengis.net/ows/1.1"],ol.format.OWS.PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{ServiceIdentification:ol.xml.makeObjectPropertySetter(ol.format.OWS.readServiceIdentification_),ServiceProvider:ol.xml.makeObjectPropertySetter(ol.format.OWS.readServiceProvider_),OperationsMetadata:ol.xml.makeObjectPropertySetter(ol.format.OWS.readOperationsMetadata_)}),ol.format.OWS.ADDRESS_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{DeliveryPoint:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),City:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),AdministrativeArea:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),PostalCode:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Country:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),ElectronicMailAddress:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)}),ol.format.OWS.ALLOWED_VALUES_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{Value:ol.xml.makeObjectPropertyPusher(ol.format.OWS.readValue_)}),ol.format.OWS.CONSTRAINT_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{AllowedValues:ol.xml.makeObjectPropertySetter(ol.format.OWS.readAllowedValues_)}),ol.format.OWS.CONTACT_INFO_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{Phone:ol.xml.makeObjectPropertySetter(ol.format.OWS.readPhone_),Address:ol.xml.makeObjectPropertySetter(ol.format.OWS.readAddress_)}),ol.format.OWS.DCP_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{HTTP:ol.xml.makeObjectPropertySetter(ol.format.OWS.readHttp_)}),ol.format.OWS.HTTP_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{Get:ol.xml.makeObjectPropertyPusher(ol.format.OWS.readGet_),Post:void 0}),ol.format.OWS.OPERATION_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{DCP:ol.xml.makeObjectPropertySetter(ol.format.OWS.readDcp_)}),ol.format.OWS.OPERATIONS_METADATA_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{Operation:ol.format.OWS.readOperation_}),ol.format.OWS.PHONE_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{Voice:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Facsimile:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)}),ol.format.OWS.REQUEST_METHOD_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{Constraint:ol.xml.makeObjectPropertyPusher(ol.format.OWS.readConstraint_)}),ol.format.OWS.SERVICE_CONTACT_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{IndividualName:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),PositionName:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),ContactInfo:ol.xml.makeObjectPropertySetter(ol.format.OWS.readContactInfo_)}),ol.format.OWS.SERVICE_IDENTIFICATION_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{Title:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),ServiceTypeVersion:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),ServiceType:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)}),ol.format.OWS.SERVICE_PROVIDER_PARSERS_=ol.xml.makeStructureNS(ol.format.OWS.NAMESPACE_URIS_,{ProviderName:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),ProviderSite:ol.xml.makeObjectPropertySetter(ol.format.XLink.readHref),ServiceContact:ol.xml.makeObjectPropertySetter(ol.format.OWS.readServiceContact_)}),goog.provide("ol.geom.flat.flip"),ol.geom.flat.flip.flipXY=function(e,o,t,r,i,n){var l,a;void 0!==i?(l=i,a=void 0!==n?n:0):(l=[],a=0);for(var s=o;s<t;){var p=e[s++];l[a++]=e[s++],l[a++]=p;for(var g=2;g<r;++g)l[a++]=e[s++]}return l.length=a,l},goog.provide("ol.format.Polyline"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.Feature"),goog.require("ol.format.Feature"),goog.require("ol.format.TextFeature"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.LineString"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.geom.flat.flip"),goog.require("ol.geom.flat.inflate"),goog.require("ol.proj"),ol.format.Polyline=function(e){var o=e||{};ol.format.TextFeature.call(this),this.defaultDataProjection=ol.proj.get("EPSG:4326"),this.factor_=o.factor?o.factor:1e5,this.geometryLayout_=o.geometryLayout?o.geometryLayout:ol.geom.GeometryLayout.XY},ol.inherits(ol.format.Polyline,ol.format.TextFeature),ol.format.Polyline.encodeDeltas=function(e,o,t){var r,i=t||1e5,n=new Array(o);for(r=0;r<o;++r)n[r]=0;var l,a;for(l=0,a=e.length;l<a;)for(r=0;r<o;++r,++l){var s=e[l],p=s-n[r];n[r]=s,e[l]=p}return ol.format.Polyline.encodeFloats(e,i)},ol.format.Polyline.decodeDeltas=function(e,o,t){var r,i=t||1e5,n=new Array(o);for(r=0;r<o;++r)n[r]=0;var l,a,s=ol.format.Polyline.decodeFloats(e,i);for(l=0,a=s.length;l<a;)for(r=0;r<o;++r,++l)n[r]+=s[l],s[l]=n[r];return s},ol.format.Polyline.encodeFloats=function(e,o){var t,r,i=o||1e5;for(t=0,r=e.length;t<r;++t)e[t]=Math.round(e[t]*i);return ol.format.Polyline.encodeSignedIntegers(e)},ol.format.Polyline.decodeFloats=function(e,o){var t,r,i=o||1e5,n=ol.format.Polyline.decodeSignedIntegers(e);for(t=0,r=n.length;t<r;++t)n[t]/=i;return n},ol.format.Polyline.encodeSignedIntegers=function(e){var o,t;for(o=0,t=e.length;o<t;++o){var r=e[o];e[o]=r<0?~(r<<1):r<<1}return ol.format.Polyline.encodeUnsignedIntegers(e)},ol.format.Polyline.decodeSignedIntegers=function(e){var o,t,r=ol.format.Polyline.decodeUnsignedIntegers(e);for(o=0,t=r.length;o<t;++o){var i=r[o];r[o]=1&i?~(i>>1):i>>1}return r},ol.format.Polyline.encodeUnsignedIntegers=function(e){var o,t,r="";for(o=0,t=e.length;o<t;++o)r+=ol.format.Polyline.encodeUnsignedInteger(e[o]);return r},ol.format.Polyline.decodeUnsignedIntegers=function(e){var o,t,r=[],i=0,n=0;for(o=0,t=e.length;o<t;++o){var l=e.charCodeAt(o)-63;i|=(31&l)<<n,l<32?(r.push(i),i=0,n=0):n+=5}return r},ol.format.Polyline.encodeUnsignedInteger=function(e){for(var o,t="";e>=32;)o=63+(32|31&e),t+=String.fromCharCode(o),e>>=5;return o=e+63,t+=String.fromCharCode(o)},ol.format.Polyline.prototype.readFeature,ol.format.Polyline.prototype.readFeatureFromText=function(e,o){var t=this.readGeometryFromText(e,o);return new ol.Feature(t)},ol.format.Polyline.prototype.readFeatures,ol.format.Polyline.prototype.readFeaturesFromText=function(e,o){return[this.readFeatureFromText(e,o)]},ol.format.Polyline.prototype.readGeometry,ol.format.Polyline.prototype.readGeometryFromText=function(e,o){var t=ol.geom.SimpleGeometry.getStrideForLayout(this.geometryLayout_),r=ol.format.Polyline.decodeDeltas(e,t,this.factor_);ol.geom.flat.flip.flipXY(r,0,r.length,t,r);var i=ol.geom.flat.inflate.coordinates(r,0,r.length,t);return ol.format.Feature.transformWithOptions(new ol.geom.LineString(i,this.geometryLayout_),!1,this.adaptOptions(o))},ol.format.Polyline.prototype.readProjection,ol.format.Polyline.prototype.writeFeatureText=function(e,o){var t=e.getGeometry();return t?this.writeGeometryText(t,o):(ol.asserts.assert(!1,40),"")},ol.format.Polyline.prototype.writeFeaturesText=function(e,o){return ol.DEBUG&&console.assert(1==e.length,"features array should have 1 item"),this.writeFeatureText(e[0],o)},ol.format.Polyline.prototype.writeGeometry,ol.format.Polyline.prototype.writeGeometryText=function(e,o){e=ol.format.Feature.transformWithOptions(e,!0,this.adaptOptions(o));var t=e.getFlatCoordinates(),r=e.getStride();return ol.geom.flat.flip.flipXY(t,0,t.length,r,t),ol.format.Polyline.encodeDeltas(t,r,this.factor_)},goog.provide("ol.format.TopoJSON"),goog.require("ol"),goog.require("ol.Feature"),goog.require("ol.format.Feature"),goog.require("ol.format.JSONFeature"),goog.require("ol.geom.LineString"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.MultiPoint"),goog.require("ol.geom.MultiPolygon"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.obj"),goog.require("ol.proj"),ol.format.TopoJSON=function(e){var o=e||{};ol.format.JSONFeature.call(this),this.defaultDataProjection=ol.proj.get(o.defaultDataProjection?o.defaultDataProjection:"EPSG:4326")},ol.inherits(ol.format.TopoJSON,ol.format.JSONFeature),ol.format.TopoJSON.EXTENSIONS_=[".topojson"],ol.format.TopoJSON.concatenateArcs_=function(e,o){var t,r,i,n,l,a,s=[];for(i=0,n=e.length;i<n;++i)t=e[i],i>0&&s.pop(),r=t>=0?o[t]:o[~t].slice().reverse(),s.push.apply(s,r);for(l=0,a=s.length;l<a;++l)s[l]=s[l].slice();return s},ol.format.TopoJSON.readPointGeometry_=function(e,o,t){var r=e.coordinates;return o&&t&&ol.format.TopoJSON.transformVertex_(r,o,t),new ol.geom.Point(r)},ol.format.TopoJSON.readMultiPointGeometry_=function(e,o,t){var r,i,n=e.coordinates;if(o&&t)for(r=0,i=n.length;r<i;++r)ol.format.TopoJSON.transformVertex_(n[r],o,t);return new ol.geom.MultiPoint(n)},ol.format.TopoJSON.readLineStringGeometry_=function(e,o){var t=ol.format.TopoJSON.concatenateArcs_(e.arcs,o);return new ol.geom.LineString(t)},ol.format.TopoJSON.readMultiLineStringGeometry_=function(e,o){var t,r,i=[];for(t=0,r=e.arcs.length;t<r;++t)i[t]=ol.format.TopoJSON.concatenateArcs_(e.arcs[t],o);return new ol.geom.MultiLineString(i)},ol.format.TopoJSON.readPolygonGeometry_=function(e,o){var t,r,i=[];for(t=0,
r=e.arcs.length;t<r;++t)i[t]=ol.format.TopoJSON.concatenateArcs_(e.arcs[t],o);return new ol.geom.Polygon(i)},ol.format.TopoJSON.readMultiPolygonGeometry_=function(e,o){var t,r,i,n,l,a,s=[];for(l=0,a=e.arcs.length;l<a;++l){for(t=e.arcs[l],r=[],i=0,n=t.length;i<n;++i)r[i]=ol.format.TopoJSON.concatenateArcs_(t[i],o);s[l]=r}return new ol.geom.MultiPolygon(s)},ol.format.TopoJSON.prototype.getExtensions=function(){return ol.format.TopoJSON.EXTENSIONS_},ol.format.TopoJSON.readFeaturesFromGeometryCollection_=function(e,o,t,r,i){var n,l,a=e.geometries,s=[];for(n=0,l=a.length;n<l;++n)s[n]=ol.format.TopoJSON.readFeatureFromGeometry_(a[n],o,t,r,i);return s},ol.format.TopoJSON.readFeatureFromGeometry_=function(e,o,t,r,i){var n,l=e.type,a=ol.format.TopoJSON.GEOMETRY_READERS_[l];n="Point"===l||"MultiPoint"===l?a(e,t,r):a(e,o);var s=new ol.Feature;return s.setGeometry(ol.format.Feature.transformWithOptions(n,!1,i)),void 0!==e.id&&s.setId(e.id),e.properties&&s.setProperties(e.properties),s},ol.format.TopoJSON.prototype.readFeatures,ol.format.TopoJSON.prototype.readFeaturesFromObject=function(e,o){if("Topology"==e.type){var t,r=e,i=null,n=null;r.transform&&(t=r.transform,i=t.scale,n=t.translate);var l=r.arcs;t&&ol.format.TopoJSON.transformArcs_(l,i,n);var a,s,p,g=[],c=ol.obj.getValues(r.objects);for(a=0,s=c.length;a<s;++a)"GeometryCollection"===c[a].type?(p=c[a],g.push.apply(g,ol.format.TopoJSON.readFeaturesFromGeometryCollection_(p,l,i,n,o))):(p=c[a],g.push(ol.format.TopoJSON.readFeatureFromGeometry_(p,l,i,n,o)));return g}return[]},ol.format.TopoJSON.transformArcs_=function(e,o,t){var r,i;for(r=0,i=e.length;r<i;++r)ol.format.TopoJSON.transformArc_(e[r],o,t)},ol.format.TopoJSON.transformArc_=function(e,o,t){var r,i,n,l=0,a=0;for(i=0,n=e.length;i<n;++i)r=e[i],l+=r[0],a+=r[1],r[0]=l,r[1]=a,ol.format.TopoJSON.transformVertex_(r,o,t)},ol.format.TopoJSON.transformVertex_=function(e,o,t){e[0]=e[0]*o[0]+t[0],e[1]=e[1]*o[1]+t[1]},ol.format.TopoJSON.prototype.readProjection=function(e){return this.defaultDataProjection},ol.format.TopoJSON.GEOMETRY_READERS_={Point:ol.format.TopoJSON.readPointGeometry_,LineString:ol.format.TopoJSON.readLineStringGeometry_,Polygon:ol.format.TopoJSON.readPolygonGeometry_,MultiPoint:ol.format.TopoJSON.readMultiPointGeometry_,MultiLineString:ol.format.TopoJSON.readMultiLineStringGeometry_,MultiPolygon:ol.format.TopoJSON.readMultiPolygonGeometry_},goog.provide("ol.format.WFS"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.format.GML3"),goog.require("ol.format.GMLBase"),goog.require("ol.format.filter"),goog.require("ol.format.XMLFeature"),goog.require("ol.format.XSD"),goog.require("ol.geom.Geometry"),goog.require("ol.obj"),goog.require("ol.proj"),goog.require("ol.xml"),ol.format.WFS=function(e){var o=e||{};this.featureType_=o.featureType,this.featureNS_=o.featureNS,this.gmlFormat_=o.gmlFormat?o.gmlFormat:new ol.format.GML3,this.schemaLocation_=o.schemaLocation?o.schemaLocation:ol.format.WFS.SCHEMA_LOCATION,ol.format.XMLFeature.call(this)},ol.inherits(ol.format.WFS,ol.format.XMLFeature),ol.format.WFS.FEATURE_PREFIX="feature",ol.format.WFS.XMLNS="http://www.w3.org/2000/xmlns/",ol.format.WFS.OGCNS="http://www.opengis.net/ogc",ol.format.WFS.WFSNS="http://www.opengis.net/wfs",ol.format.WFS.SCHEMA_LOCATION="http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd",ol.format.WFS.prototype.readFeatures,ol.format.WFS.prototype.readFeaturesFromNode=function(e,o){var t={featureType:this.featureType_,featureNS:this.featureNS_};ol.obj.assign(t,this.getReadOptions(e,o||{}));var r=[t];this.gmlFormat_.FEATURE_COLLECTION_PARSERS[ol.format.GMLBase.GMLNS].featureMember=ol.xml.makeArrayPusher(ol.format.GMLBase.prototype.readFeaturesInternal);var i=ol.xml.pushParseAndPop([],this.gmlFormat_.FEATURE_COLLECTION_PARSERS,e,r,this.gmlFormat_);return i||(i=[]),i},ol.format.WFS.prototype.readTransactionResponse=function(e){if(ol.xml.isDocument(e))return this.readTransactionResponseFromDocument(e);if(ol.xml.isNode(e))return this.readTransactionResponseFromNode(e);if("string"==typeof e){var o=ol.xml.parse(e);return this.readTransactionResponseFromDocument(o)}},ol.format.WFS.prototype.readFeatureCollectionMetadata=function(e){if(ol.xml.isDocument(e))return this.readFeatureCollectionMetadataFromDocument(e);if(ol.xml.isNode(e))return this.readFeatureCollectionMetadataFromNode(e);if("string"==typeof e){var o=ol.xml.parse(e);return this.readFeatureCollectionMetadataFromDocument(o)}},ol.format.WFS.prototype.readFeatureCollectionMetadataFromDocument=function(e){ol.DEBUG&&console.assert(e.nodeType==Node.DOCUMENT_NODE,"doc.nodeType should be DOCUMENT");for(var o=e.firstChild;o;o=o.nextSibling)if(o.nodeType==Node.ELEMENT_NODE)return this.readFeatureCollectionMetadataFromNode(o)},ol.format.WFS.FEATURE_COLLECTION_PARSERS_={"http://www.opengis.net/gml":{boundedBy:ol.xml.makeObjectPropertySetter(ol.format.GMLBase.prototype.readGeometryElement,"bounds")}},ol.format.WFS.prototype.readFeatureCollectionMetadataFromNode=function(e){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("FeatureCollection"==e.localName,"localName should be FeatureCollection");var o={},t=ol.format.XSD.readNonNegativeIntegerString(e.getAttribute("numberOfFeatures"));return o.numberOfFeatures=t,ol.xml.pushParseAndPop(o,ol.format.WFS.FEATURE_COLLECTION_PARSERS_,e,[],this.gmlFormat_)},ol.format.WFS.TRANSACTION_SUMMARY_PARSERS_={"http://www.opengis.net/wfs":{totalInserted:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),totalUpdated:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),totalDeleted:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger)}},ol.format.WFS.readTransactionSummary_=function(e,o){return ol.xml.pushParseAndPop({},ol.format.WFS.TRANSACTION_SUMMARY_PARSERS_,e,o)},ol.format.WFS.OGC_FID_PARSERS_={"http://www.opengis.net/ogc":{FeatureId:ol.xml.makeArrayPusher(function(e,o){return e.getAttribute("fid")})}},ol.format.WFS.fidParser_=function(e,o){ol.xml.parseNode(ol.format.WFS.OGC_FID_PARSERS_,e,o)},ol.format.WFS.INSERT_RESULTS_PARSERS_={"http://www.opengis.net/wfs":{Feature:ol.format.WFS.fidParser_}},ol.format.WFS.readInsertResults_=function(e,o){return ol.xml.pushParseAndPop([],ol.format.WFS.INSERT_RESULTS_PARSERS_,e,o)},ol.format.WFS.TRANSACTION_RESPONSE_PARSERS_={"http://www.opengis.net/wfs":{TransactionSummary:ol.xml.makeObjectPropertySetter(ol.format.WFS.readTransactionSummary_,"transactionSummary"),InsertResults:ol.xml.makeObjectPropertySetter(ol.format.WFS.readInsertResults_,"insertIds")}},ol.format.WFS.prototype.readTransactionResponseFromDocument=function(e){ol.DEBUG&&console.assert(e.nodeType==Node.DOCUMENT_NODE,"doc.nodeType should be DOCUMENT");for(var o=e.firstChild;o;o=o.nextSibling)if(o.nodeType==Node.ELEMENT_NODE)return this.readTransactionResponseFromNode(o)},ol.format.WFS.prototype.readTransactionResponseFromNode=function(e){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should  be ELEMENT"),ol.DEBUG&&console.assert("TransactionResponse"==e.localName,"localName should be TransactionResponse"),ol.xml.pushParseAndPop({},ol.format.WFS.TRANSACTION_RESPONSE_PARSERS_,e,[])},ol.format.WFS.QUERY_SERIALIZERS_={"http://www.opengis.net/wfs":{PropertyName:ol.xml.makeChildAppender(ol.format.XSD.writeStringTextNode)}},ol.format.WFS.writeFeature_=function(e,o,t){var r=t[t.length-1],i=r.featureType,n=r.featureNS,l=ol.xml.createElementNS(n,i);e.appendChild(l),ol.format.GML3.prototype.writeFeatureElement(l,o,t)},ol.format.WFS.writeOgcFidFilter_=function(e,o,t){var r=ol.xml.createElementNS(ol.format.WFS.OGCNS,"Filter"),i=ol.xml.createElementNS(ol.format.WFS.OGCNS,"FeatureId");r.appendChild(i),i.setAttribute("fid",o),e.appendChild(r)},ol.format.WFS.writeDelete_=function(e,o,t){var r=t[t.length-1];ol.asserts.assert(void 0!==o.getId(),26);var i=r.featureType,n=r.featurePrefix;n=n||ol.format.WFS.FEATURE_PREFIX;var l=r.featureNS;e.setAttribute("typeName",n+":"+i),ol.xml.setAttributeNS(e,ol.format.WFS.XMLNS,"xmlns:"+n,l);var a=o.getId();void 0!==a&&ol.format.WFS.writeOgcFidFilter_(e,a,t)},ol.format.WFS.writeUpdate_=function(e,o,t){var r=t[t.length-1];ol.asserts.assert(void 0!==o.getId(),27);var i=r.featureType,n=r.featurePrefix;n=n||ol.format.WFS.FEATURE_PREFIX;var l=r.featureNS;e.setAttribute("typeName",n+":"+i),ol.xml.setAttributeNS(e,ol.format.WFS.XMLNS,"xmlns:"+n,l);var a=o.getId();if(void 0!==a){for(var s=o.getKeys(),p=[],g=0,c=s.length;g<c;g++){var u=o.get(s[g]);void 0!==u&&p.push({name:s[g],value:u})}ol.xml.pushSerializeAndPop({node:e,srsName:r.srsName},ol.format.WFS.TRANSACTION_SERIALIZERS_,ol.xml.makeSimpleNodeFactory("Property"),p,t),ol.format.WFS.writeOgcFidFilter_(e,a,t)}},ol.format.WFS.writeProperty_=function(e,o,t){var r=ol.xml.createElementNS(ol.format.WFS.WFSNS,"Name");if(e.appendChild(r),ol.format.XSD.writeStringTextNode(r,o.name),void 0!==o.value&&null!==o.value){var i=ol.xml.createElementNS(ol.format.WFS.WFSNS,"Value");e.appendChild(i),o.value instanceof ol.geom.Geometry?ol.format.GML3.prototype.writeGeometryElement(i,o.value,t):ol.format.XSD.writeStringTextNode(i,o.value)}},ol.format.WFS.writeNative_=function(e,o,t){o.vendorId&&e.setAttribute("vendorId",o.vendorId),void 0!==o.safeToIgnore&&e.setAttribute("safeToIgnore",o.safeToIgnore),void 0!==o.value&&ol.format.XSD.writeStringTextNode(e,o.value)},ol.format.WFS.TRANSACTION_SERIALIZERS_={"http://www.opengis.net/wfs":{Insert:ol.xml.makeChildAppender(ol.format.WFS.writeFeature_),Update:ol.xml.makeChildAppender(ol.format.WFS.writeUpdate_),Delete:ol.xml.makeChildAppender(ol.format.WFS.writeDelete_),Property:ol.xml.makeChildAppender(ol.format.WFS.writeProperty_),Native:ol.xml.makeChildAppender(ol.format.WFS.writeNative_)}},ol.format.WFS.writeQuery_=function(e,o,t){var r=t[t.length-1],i=r.featurePrefix,n=r.featureNS,l=r.propertyNames,a=r.srsName,s=i?i+":":"";e.setAttribute("typeName",s+o),a&&e.setAttribute("srsName",a),n&&ol.xml.setAttributeNS(e,ol.format.WFS.XMLNS,"xmlns:"+i,n);var p=ol.obj.assign({},r);p.node=e,ol.xml.pushSerializeAndPop(p,ol.format.WFS.QUERY_SERIALIZERS_,ol.xml.makeSimpleNodeFactory("PropertyName"),l,t);var g=r.filter;if(g){var c=ol.xml.createElementNS(ol.format.WFS.OGCNS,"Filter");e.appendChild(c),ol.format.WFS.writeFilterCondition_(c,g,t)}},ol.format.WFS.writeFilterCondition_=function(e,o,t){var r={node:e};ol.xml.pushSerializeAndPop(r,ol.format.WFS.GETFEATURE_SERIALIZERS_,ol.xml.makeSimpleNodeFactory(o.getTagName()),[o],t)},ol.format.WFS.writeBboxFilter_=function(e,o,t){t[t.length-1].srsName=o.srsName,ol.format.WFS.writeOgcPropertyName_(e,o.geometryName),ol.format.GML3.prototype.writeGeometryElement(e,o.extent,t)},ol.format.WFS.writeIntersectsFilter_=function(e,o,t){t[t.length-1].srsName=o.srsName,ol.format.WFS.writeOgcPropertyName_(e,o.geometryName),ol.format.GML3.prototype.writeGeometryElement(e,o.geometry,t)},ol.format.WFS.writeWithinFilter_=function(e,o,t){t[t.length-1].srsName=o.srsName,ol.format.WFS.writeOgcPropertyName_(e,o.geometryName),ol.format.GML3.prototype.writeGeometryElement(e,o.geometry,t)},ol.format.WFS.writeLogicalFilter_=function(e,o,t){var r={node:e},i=o.conditionA;ol.xml.pushSerializeAndPop(r,ol.format.WFS.GETFEATURE_SERIALIZERS_,ol.xml.makeSimpleNodeFactory(i.getTagName()),[i],t);var n=o.conditionB;ol.xml.pushSerializeAndPop(r,ol.format.WFS.GETFEATURE_SERIALIZERS_,ol.xml.makeSimpleNodeFactory(n.getTagName()),[n],t)},ol.format.WFS.writeNotFilter_=function(e,o,t){var r={node:e},i=o.condition;ol.xml.pushSerializeAndPop(r,ol.format.WFS.GETFEATURE_SERIALIZERS_,ol.xml.makeSimpleNodeFactory(i.getTagName()),[i],t)},ol.format.WFS.writeComparisonFilter_=function(e,o,t){void 0!==o.matchCase&&e.setAttribute("matchCase",o.matchCase.toString()),ol.format.WFS.writeOgcPropertyName_(e,o.propertyName),ol.format.WFS.writeOgcLiteral_(e,""+o.expression)},ol.format.WFS.writeIsNullFilter_=function(e,o,t){ol.format.WFS.writeOgcPropertyName_(e,o.propertyName)},ol.format.WFS.writeIsBetweenFilter_=function(e,o,t){ol.format.WFS.writeOgcPropertyName_(e,o.propertyName);var r=ol.xml.createElementNS(ol.format.WFS.OGCNS,"LowerBoundary");e.appendChild(r),ol.format.WFS.writeOgcLiteral_(r,""+o.lowerBoundary);var i=ol.xml.createElementNS(ol.format.WFS.OGCNS,"UpperBoundary");e.appendChild(i),ol.format.WFS.writeOgcLiteral_(i,""+o.upperBoundary)},ol.format.WFS.writeIsLikeFilter_=function(e,o,t){e.setAttribute("wildCard",o.wildCard),e.setAttribute("singleChar",o.singleChar),e.setAttribute("escapeChar",o.escapeChar),void 0!==o.matchCase&&e.setAttribute("matchCase",o.matchCase.toString()),ol.format.WFS.writeOgcPropertyName_(e,o.propertyName),ol.format.WFS.writeOgcLiteral_(e,""+o.pattern)},ol.format.WFS.writeOgcExpression_=function(e,o,t){var r=ol.xml.createElementNS(ol.format.WFS.OGCNS,e);ol.format.XSD.writeStringTextNode(r,t),o.appendChild(r)},ol.format.WFS.writeOgcPropertyName_=function(e,o){ol.format.WFS.writeOgcExpression_("PropertyName",e,o)},ol.format.WFS.writeOgcLiteral_=function(e,o){ol.format.WFS.writeOgcExpression_("Literal",e,o)},ol.format.WFS.GETFEATURE_SERIALIZERS_={"http://www.opengis.net/wfs":{Query:ol.xml.makeChildAppender(ol.format.WFS.writeQuery_)},"http://www.opengis.net/ogc":{And:ol.xml.makeChildAppender(ol.format.WFS.writeLogicalFilter_),Or:ol.xml.makeChildAppender(ol.format.WFS.writeLogicalFilter_),Not:ol.xml.makeChildAppender(ol.format.WFS.writeNotFilter_),BBOX:ol.xml.makeChildAppender(ol.format.WFS.writeBboxFilter_),Intersects:ol.xml.makeChildAppender(ol.format.WFS.writeIntersectsFilter_),Within:ol.xml.makeChildAppender(ol.format.WFS.writeWithinFilter_),PropertyIsEqualTo:ol.xml.makeChildAppender(ol.format.WFS.writeComparisonFilter_),PropertyIsNotEqualTo:ol.xml.makeChildAppender(ol.format.WFS.writeComparisonFilter_),PropertyIsLessThan:ol.xml.makeChildAppender(ol.format.WFS.writeComparisonFilter_),PropertyIsLessThanOrEqualTo:ol.xml.makeChildAppender(ol.format.WFS.writeComparisonFilter_),PropertyIsGreaterThan:ol.xml.makeChildAppender(ol.format.WFS.writeComparisonFilter_),PropertyIsGreaterThanOrEqualTo:ol.xml.makeChildAppender(ol.format.WFS.writeComparisonFilter_),PropertyIsNull:ol.xml.makeChildAppender(ol.format.WFS.writeIsNullFilter_),PropertyIsBetween:ol.xml.makeChildAppender(ol.format.WFS.writeIsBetweenFilter_),PropertyIsLike:ol.xml.makeChildAppender(ol.format.WFS.writeIsLikeFilter_)}},ol.format.WFS.writeGetFeature_=function(e,o,t){var r=t[t.length-1],i=ol.obj.assign({},r);i.node=e,ol.xml.pushSerializeAndPop(i,ol.format.WFS.GETFEATURE_SERIALIZERS_,ol.xml.makeSimpleNodeFactory("Query"),o,t)},ol.format.WFS.prototype.writeGetFeature=function(e){var o=ol.xml.createElementNS(ol.format.WFS.WFSNS,"GetFeature");o.setAttribute("service","WFS"),o.setAttribute("version","1.1.0");var t;if(e&&(e.handle&&o.setAttribute("handle",e.handle),e.outputFormat&&o.setAttribute("outputFormat",e.outputFormat),void 0!==e.maxFeatures&&o.setAttribute("maxFeatures",e.maxFeatures),e.resultType&&o.setAttribute("resultType",e.resultType),void 0!==e.startIndex&&o.setAttribute("startIndex",e.startIndex),void 0!==e.count&&o.setAttribute("count",e.count),t=e.filter,e.bbox)){ol.asserts.assert(e.geometryName,12);var r=ol.format.filter.bbox(e.geometryName,e.bbox,e.srsName);t=t?ol.format.filter.and(t,r):r}ol.xml.setAttributeNS(o,"http://www.w3.org/2001/XMLSchema-instance","xsi:schemaLocation",this.schemaLocation_);var i={node:o,srsName:e.srsName,featureNS:e.featureNS?e.featureNS:this.featureNS_,featurePrefix:e.featurePrefix,geometryName:e.geometryName,filter:t,propertyNames:e.propertyNames?e.propertyNames:[]};return ol.asserts.assert(Array.isArray(e.featureTypes),11),ol.format.WFS.writeGetFeature_(o,e.featureTypes,[i]),o},ol.format.WFS.prototype.writeTransaction=function(e,o,t,r){var i=[],n=ol.xml.createElementNS(ol.format.WFS.WFSNS,"Transaction");n.setAttribute("service","WFS"),n.setAttribute("version","1.1.0");var l,a;return r&&(l=r.gmlOptions?r.gmlOptions:{},r.handle&&n.setAttribute("handle",r.handle)),ol.xml.setAttributeNS(n,"http://www.w3.org/2001/XMLSchema-instance","xsi:schemaLocation",this.schemaLocation_),e&&(a={node:n,featureNS:r.featureNS,featureType:r.featureType,featurePrefix:r.featurePrefix,srsName:r.srsName},ol.obj.assign(a,l),ol.xml.pushSerializeAndPop(a,ol.format.WFS.TRANSACTION_SERIALIZERS_,ol.xml.makeSimpleNodeFactory("Insert"),e,i)),o&&(a={node:n,featureNS:r.featureNS,featureType:r.featureType,featurePrefix:r.featurePrefix,srsName:r.srsName},ol.obj.assign(a,l),ol.xml.pushSerializeAndPop(a,ol.format.WFS.TRANSACTION_SERIALIZERS_,ol.xml.makeSimpleNodeFactory("Update"),o,i)),t&&ol.xml.pushSerializeAndPop({node:n,featureNS:r.featureNS,featureType:r.featureType,featurePrefix:r.featurePrefix,srsName:r.srsName},ol.format.WFS.TRANSACTION_SERIALIZERS_,ol.xml.makeSimpleNodeFactory("Delete"),t,i),r.nativeElements&&ol.xml.pushSerializeAndPop({node:n,featureNS:r.featureNS,featureType:r.featureType,featurePrefix:r.featurePrefix,srsName:r.srsName},ol.format.WFS.TRANSACTION_SERIALIZERS_,ol.xml.makeSimpleNodeFactory("Native"),r.nativeElements,i),n},ol.format.WFS.prototype.readProjection,ol.format.WFS.prototype.readProjectionFromDocument=function(e){ol.DEBUG&&console.assert(e.nodeType==Node.DOCUMENT_NODE,"doc.nodeType should be a DOCUMENT");for(var o=e.firstChild;o;o=o.nextSibling)if(o.nodeType==Node.ELEMENT_NODE)return this.readProjectionFromNode(o);return null},ol.format.WFS.prototype.readProjectionFromNode=function(e){if(ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("FeatureCollection"==e.localName,"localName should be FeatureCollection"),e.firstElementChild&&e.firstElementChild.firstElementChild){e=e.firstElementChild.firstElementChild;for(var o=e.firstElementChild;o;o=o.nextElementSibling)if(0!==o.childNodes.length&&(1!==o.childNodes.length||3!==o.firstChild.nodeType)){var t=[{}];return this.gmlFormat_.readGeometryElement(o,t),ol.proj.get(t.pop().srsName)}}return null},goog.provide("ol.format.WKT"),goog.require("ol"),goog.require("ol.Feature"),goog.require("ol.format.Feature"),goog.require("ol.format.TextFeature"),goog.require("ol.geom.GeometryCollection"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.LineString"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.MultiPoint"),goog.require("ol.geom.MultiPolygon"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.geom.SimpleGeometry"),ol.format.WKT=function(e){var o=e||{};ol.format.TextFeature.call(this),this.splitCollection_=void 0!==o.splitCollection&&o.splitCollection},ol.inherits(ol.format.WKT,ol.format.TextFeature),ol.format.WKT.EMPTY="EMPTY",ol.format.WKT.Z="Z";ol.format.WKT.M="M",ol.format.WKT.ZM="ZM",ol.format.WKT.encodePointGeometry_=function(e){var o=e.getCoordinates();return 0===o.length?"":o.join(" ")},ol.format.WKT.encodeMultiPointGeometry_=function(e){for(var o=[],t=e.getPoints(),r=0,i=t.length;r<i;++r)o.push("("+ol.format.WKT.encodePointGeometry_(t[r])+")");return o.join(",")},ol.format.WKT.encodeGeometryCollectionGeometry_=function(e){for(var o=[],t=e.getGeometries(),r=0,i=t.length;r<i;++r)o.push(ol.format.WKT.encode_(t[r]));return o.join(",")},ol.format.WKT.encodeLineStringGeometry_=function(e){for(var o=e.getCoordinates(),t=[],r=0,i=o.length;r<i;++r)t.push(o[r].join(" "));return t.join(",")},ol.format.WKT.encodeMultiLineStringGeometry_=function(e){for(var o=[],t=e.getLineStrings(),r=0,i=t.length;r<i;++r)o.push("("+ol.format.WKT.encodeLineStringGeometry_(t[r])+")");return o.join(",")},ol.format.WKT.encodePolygonGeometry_=function(e){for(var o=[],t=e.getLinearRings(),r=0,i=t.length;r<i;++r)o.push("("+ol.format.WKT.encodeLineStringGeometry_(t[r])+")");return o.join(",")},ol.format.WKT.encodeMultiPolygonGeometry_=function(e){for(var o=[],t=e.getPolygons(),r=0,i=t.length;r<i;++r)o.push("("+ol.format.WKT.encodePolygonGeometry_(t[r])+")");return o.join(",")},ol.format.WKT.encodeGeometryLayout_=function(e){var o=e.getLayout(),t="";return o!==ol.geom.GeometryLayout.XYZ&&o!==ol.geom.GeometryLayout.XYZM||(t+=ol.format.WKT.Z),o!==ol.geom.GeometryLayout.XYM&&o!==ol.geom.GeometryLayout.XYZM||(t+=ol.format.WKT.M),t},ol.format.WKT.encode_=function(e){var o=e.getType(),t=ol.format.WKT.GeometryEncoder_[o];ol.DEBUG&&console.assert(t,"geometryEncoder should be defined");var r=t(e);if(o=o.toUpperCase(),e instanceof ol.geom.SimpleGeometry){var i=ol.format.WKT.encodeGeometryLayout_(e);i.length>0&&(o+=" "+i)}return 0===r.length?o+" "+ol.format.WKT.EMPTY:o+"("+r+")"},ol.format.WKT.GeometryEncoder_={Point:ol.format.WKT.encodePointGeometry_,LineString:ol.format.WKT.encodeLineStringGeometry_,Polygon:ol.format.WKT.encodePolygonGeometry_,MultiPoint:ol.format.WKT.encodeMultiPointGeometry_,MultiLineString:ol.format.WKT.encodeMultiLineStringGeometry_,MultiPolygon:ol.format.WKT.encodeMultiPolygonGeometry_,GeometryCollection:ol.format.WKT.encodeGeometryCollectionGeometry_},ol.format.WKT.prototype.parse_=function(e){var o=new ol.format.WKT.Lexer(e);return new ol.format.WKT.Parser(o).parse()},ol.format.WKT.prototype.readFeature,ol.format.WKT.prototype.readFeatureFromText=function(e,o){var t=this.readGeometryFromText(e,o);if(t){var r=new ol.Feature;return r.setGeometry(t),r}return null},ol.format.WKT.prototype.readFeatures,ol.format.WKT.prototype.readFeaturesFromText=function(e,o){var t=[],r=this.readGeometryFromText(e,o);t=this.splitCollection_&&r.getType()==ol.geom.GeometryType.GEOMETRY_COLLECTION?r.getGeometriesArray():[r];for(var i,n=[],l=0,a=t.length;l<a;++l)i=new ol.Feature,i.setGeometry(t[l]),n.push(i);return n},ol.format.WKT.prototype.readGeometry,ol.format.WKT.prototype.readGeometryFromText=function(e,o){var t=this.parse_(e);return t?ol.format.Feature.transformWithOptions(t,!1,o):null},ol.format.WKT.prototype.writeFeature,ol.format.WKT.prototype.writeFeatureText=function(e,o){var t=e.getGeometry();return t?this.writeGeometryText(t,o):""},ol.format.WKT.prototype.writeFeatures,ol.format.WKT.prototype.writeFeaturesText=function(e,o){if(1==e.length)return this.writeFeatureText(e[0],o);for(var t=[],r=0,i=e.length;r<i;++r)t.push(e[r].getGeometry());var n=new ol.geom.GeometryCollection(t);return this.writeGeometryText(n,o)},ol.format.WKT.prototype.writeGeometry,ol.format.WKT.prototype.writeGeometryText=function(e,o){return ol.format.WKT.encode_(ol.format.Feature.transformWithOptions(e,!0,o))},ol.format.WKT.TokenType={TEXT:1,LEFT_PAREN:2,RIGHT_PAREN:3,NUMBER:4,COMMA:5,EOF:6},ol.format.WKT.Lexer=function(e){this.wkt=e,this.index_=-1},ol.format.WKT.Lexer.prototype.isAlpha_=function(e){return e>="a"&&e<="z"||e>="A"&&e<="Z"},ol.format.WKT.Lexer.prototype.isNumeric_=function(e,o){var t=void 0!==o&&o;return e>="0"&&e<="9"||"."==e&&!t},ol.format.WKT.Lexer.prototype.isWhiteSpace_=function(e){return" "==e||"\t"==e||"\r"==e||"\n"==e},ol.format.WKT.Lexer.prototype.nextChar_=function(){return this.wkt.charAt(++this.index_)},ol.format.WKT.Lexer.prototype.nextToken=function(){var e=this.nextChar_(),o={position:this.index_,value:e};if("("==e)o.type=ol.format.WKT.TokenType.LEFT_PAREN;else if(","==e)o.type=ol.format.WKT.TokenType.COMMA;else if(")"==e)o.type=ol.format.WKT.TokenType.RIGHT_PAREN;else if(this.isNumeric_(e)||"-"==e)o.type=ol.format.WKT.TokenType.NUMBER,o.value=this.readNumber_();else if(this.isAlpha_(e))o.type=ol.format.WKT.TokenType.TEXT,o.value=this.readText_();else{if(this.isWhiteSpace_(e))return this.nextToken();if(""!==e)throw new Error("Unexpected character: "+e);o.type=ol.format.WKT.TokenType.EOF}return o},ol.format.WKT.Lexer.prototype.readNumber_=function(){var e,o=this.index_,t=!1,r=!1;do{"."==e?t=!0:"e"!=e&&"E"!=e||(r=!0),e=this.nextChar_()}while(this.isNumeric_(e,t)||!r&&("e"==e||"E"==e)||r&&("-"==e||"+"==e));return parseFloat(this.wkt.substring(o,this.index_--))},ol.format.WKT.Lexer.prototype.readText_=function(){var e,o=this.index_;do{e=this.nextChar_()}while(this.isAlpha_(e));return this.wkt.substring(o,this.index_--).toUpperCase()},ol.format.WKT.Parser=function(e){this.lexer_=e,this.token_,this.layout_=ol.geom.GeometryLayout.XY},ol.format.WKT.Parser.prototype.consume_=function(){this.token_=this.lexer_.nextToken()},ol.format.WKT.Parser.prototype.isTokenType=function(e){return this.token_.type==e},ol.format.WKT.Parser.prototype.match=function(e){var o=this.isTokenType(e);return o&&this.consume_(),o},ol.format.WKT.Parser.prototype.parse=function(){this.consume_();var e=this.parseGeometry_();return ol.DEBUG&&console.assert(this.token_.type==ol.format.WKT.TokenType.EOF,"token type should be end of file"),e},ol.format.WKT.Parser.prototype.parseGeometryLayout_=function(){var e=ol.geom.GeometryLayout.XY,o=this.token_;if(this.isTokenType(ol.format.WKT.TokenType.TEXT)){var t=o.value;t===ol.format.WKT.Z?e=ol.geom.GeometryLayout.XYZ:t===ol.format.WKT.M?e=ol.geom.GeometryLayout.XYM:t===ol.format.WKT.ZM&&(e=ol.geom.GeometryLayout.XYZM),e!==ol.geom.GeometryLayout.XY&&this.consume_()}return e},ol.format.WKT.Parser.prototype.parseGeometry_=function(){var e=this.token_;if(this.match(ol.format.WKT.TokenType.TEXT)){var o=e.value;if(this.layout_=this.parseGeometryLayout_(),o==ol.geom.GeometryType.GEOMETRY_COLLECTION.toUpperCase()){var t=this.parseGeometryCollectionText_();return new ol.geom.GeometryCollection(t)}var r=ol.format.WKT.Parser.GeometryParser_[o],i=ol.format.WKT.Parser.GeometryConstructor_[o];if(!r||!i)throw new Error("Invalid geometry type: "+o);return new i(r.call(this),this.layout_)}throw new Error(this.formatErrorMessage_())},ol.format.WKT.Parser.prototype.parseGeometryCollectionText_=function(){if(this.match(ol.format.WKT.TokenType.LEFT_PAREN)){var e=[];do{e.push(this.parseGeometry_())}while(this.match(ol.format.WKT.TokenType.COMMA));if(this.match(ol.format.WKT.TokenType.RIGHT_PAREN))return e}else if(this.isEmptyGeometry_())return[];throw new Error(this.formatErrorMessage_())},ol.format.WKT.Parser.prototype.parsePointText_=function(){if(this.match(ol.format.WKT.TokenType.LEFT_PAREN)){var e=this.parsePoint_();if(this.match(ol.format.WKT.TokenType.RIGHT_PAREN))return e}else if(this.isEmptyGeometry_())return null;throw new Error(this.formatErrorMessage_())},ol.format.WKT.Parser.prototype.parseLineStringText_=function(){if(this.match(ol.format.WKT.TokenType.LEFT_PAREN)){var e=this.parsePointList_();if(this.match(ol.format.WKT.TokenType.RIGHT_PAREN))return e}else if(this.isEmptyGeometry_())return[];throw new Error(this.formatErrorMessage_())},ol.format.WKT.Parser.prototype.parsePolygonText_=function(){if(this.match(ol.format.WKT.TokenType.LEFT_PAREN)){var e=this.parseLineStringTextList_();if(this.match(ol.format.WKT.TokenType.RIGHT_PAREN))return e}else if(this.isEmptyGeometry_())return[];throw new Error(this.formatErrorMessage_())},ol.format.WKT.Parser.prototype.parseMultiPointText_=function(){if(this.match(ol.format.WKT.TokenType.LEFT_PAREN)){var e;if(e=this.token_.type==ol.format.WKT.TokenType.LEFT_PAREN?this.parsePointTextList_():this.parsePointList_(),this.match(ol.format.WKT.TokenType.RIGHT_PAREN))return e}else if(this.isEmptyGeometry_())return[];throw new Error(this.formatErrorMessage_())},ol.format.WKT.Parser.prototype.parseMultiLineStringText_=function(){if(this.match(ol.format.WKT.TokenType.LEFT_PAREN)){var e=this.parseLineStringTextList_();if(this.match(ol.format.WKT.TokenType.RIGHT_PAREN))return e}else if(this.isEmptyGeometry_())return[];throw new Error(this.formatErrorMessage_())},ol.format.WKT.Parser.prototype.parseMultiPolygonText_=function(){if(this.match(ol.format.WKT.TokenType.LEFT_PAREN)){var e=this.parsePolygonTextList_();if(this.match(ol.format.WKT.TokenType.RIGHT_PAREN))return e}else if(this.isEmptyGeometry_())return[];throw new Error(this.formatErrorMessage_())},ol.format.WKT.Parser.prototype.parsePoint_=function(){for(var e=[],o=this.layout_.length,t=0;t<o;++t){var r=this.token_;if(!this.match(ol.format.WKT.TokenType.NUMBER))break;e.push(r.value)}if(e.length==o)return e;throw new Error(this.formatErrorMessage_())},ol.format.WKT.Parser.prototype.parsePointList_=function(){for(var e=[this.parsePoint_()];this.match(ol.format.WKT.TokenType.COMMA);)e.push(this.parsePoint_());return e},ol.format.WKT.Parser.prototype.parsePointTextList_=function(){for(var e=[this.parsePointText_()];this.match(ol.format.WKT.TokenType.COMMA);)e.push(this.parsePointText_());return e},ol.format.WKT.Parser.prototype.parseLineStringTextList_=function(){for(var e=[this.parseLineStringText_()];this.match(ol.format.WKT.TokenType.COMMA);)e.push(this.parseLineStringText_());return e},ol.format.WKT.Parser.prototype.parsePolygonTextList_=function(){for(var e=[this.parsePolygonText_()];this.match(ol.format.WKT.TokenType.COMMA);)e.push(this.parsePolygonText_());return e},ol.format.WKT.Parser.prototype.isEmptyGeometry_=function(){var e=this.isTokenType(ol.format.WKT.TokenType.TEXT)&&this.token_.value==ol.format.WKT.EMPTY;return e&&this.consume_(),e},ol.format.WKT.Parser.prototype.formatErrorMessage_=function(){return"Unexpected `"+this.token_.value+"` at position "+this.token_.position+" in `"+this.lexer_.wkt+"`"},ol.format.WKT.Parser.GeometryConstructor_={POINT:ol.geom.Point,LINESTRING:ol.geom.LineString,POLYGON:ol.geom.Polygon,MULTIPOINT:ol.geom.MultiPoint,MULTILINESTRING:ol.geom.MultiLineString,MULTIPOLYGON:ol.geom.MultiPolygon},ol.format.WKT.Parser.GeometryParser_={POINT:ol.format.WKT.Parser.prototype.parsePointText_,LINESTRING:ol.format.WKT.Parser.prototype.parseLineStringText_,POLYGON:ol.format.WKT.Parser.prototype.parsePolygonText_,MULTIPOINT:ol.format.WKT.Parser.prototype.parseMultiPointText_,MULTILINESTRING:ol.format.WKT.Parser.prototype.parseMultiLineStringText_,MULTIPOLYGON:ol.format.WKT.Parser.prototype.parseMultiPolygonText_},goog.provide("ol.format.WMSCapabilities"),goog.require("ol"),goog.require("ol.format.XLink"),goog.require("ol.format.XML"),goog.require("ol.format.XSD"),goog.require("ol.xml"),ol.format.WMSCapabilities=function(){ol.format.XML.call(this),this.version=void 0},ol.inherits(ol.format.WMSCapabilities,ol.format.XML),ol.format.WMSCapabilities.prototype.read,ol.format.WMSCapabilities.prototype.readFromDocument=function(e){ol.DEBUG&&console.assert(e.nodeType==Node.DOCUMENT_NODE,"doc.nodeType should be DOCUMENT");for(var o=e.firstChild;o;o=o.nextSibling)if(o.nodeType==Node.ELEMENT_NODE)return this.readFromNode(o);return null},ol.format.WMSCapabilities.prototype.readFromNode=function(e){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("WMS_Capabilities"==e.localName||"WMT_MS_Capabilities"==e.localName,"localName should be WMS_Capabilities or WMT_MS_Capabilities"),this.version=e.getAttribute("version").trim();var o=ol.xml.pushParseAndPop({version:this.version},ol.format.WMSCapabilities.PARSERS_,e,[]);return o||null},ol.format.WMSCapabilities.readAttribution_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Attribution"==e.localName,"localName should be Attribution"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.ATTRIBUTION_PARSERS_,e,o)},ol.format.WMSCapabilities.readBoundingBox_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("BoundingBox"==e.localName,"localName should be BoundingBox");var t=[ol.format.XSD.readDecimalString(e.getAttribute("minx")),ol.format.XSD.readDecimalString(e.getAttribute("miny")),ol.format.XSD.readDecimalString(e.getAttribute("maxx")),ol.format.XSD.readDecimalString(e.getAttribute("maxy"))],r=[ol.format.XSD.readDecimalString(e.getAttribute("resx")),ol.format.XSD.readDecimalString(e.getAttribute("resy"))];return{crs:e.getAttribute("CRS"),extent:t,res:r}},ol.format.WMSCapabilities.readEXGeographicBoundingBox_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("EX_GeographicBoundingBox"==e.localName,"localName should be EX_GeographicBoundingBox")
;var t=ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.EX_GEOGRAPHIC_BOUNDING_BOX_PARSERS_,e,o);if(t){var r=t.westBoundLongitude,i=t.southBoundLatitude,n=t.eastBoundLongitude,l=t.northBoundLatitude;if(void 0!==r&&void 0!==i&&void 0!==n&&void 0!==l)return[r,i,n,l]}},ol.format.WMSCapabilities.readCapability_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Capability"==e.localName,"localName should be Capability"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.CAPABILITY_PARSERS_,e,o)},ol.format.WMSCapabilities.readService_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Service"==e.localName,"localName should be Service"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.SERVICE_PARSERS_,e,o)},ol.format.WMSCapabilities.readContactInformation_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType shpuld be ELEMENT"),ol.DEBUG&&console.assert("ContactInformation"==e.localName,"localName should be ContactInformation"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.CONTACT_INFORMATION_PARSERS_,e,o)},ol.format.WMSCapabilities.readContactPersonPrimary_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("ContactPersonPrimary"==e.localName,"localName should be ContactPersonPrimary"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.CONTACT_PERSON_PARSERS_,e,o)},ol.format.WMSCapabilities.readContactAddress_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("ContactAddress"==e.localName,"localName should be ContactAddress"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.CONTACT_ADDRESS_PARSERS_,e,o)},ol.format.WMSCapabilities.readException_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Exception"==e.localName,"localName should be Exception"),ol.xml.pushParseAndPop([],ol.format.WMSCapabilities.EXCEPTION_PARSERS_,e,o)},ol.format.WMSCapabilities.readCapabilityLayer_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Layer"==e.localName,"localName should be Layer"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.LAYER_PARSERS_,e,o)},ol.format.WMSCapabilities.readLayer_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Layer"==e.localName,"localName should be Layer");var t=o[o.length-1],r=ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.LAYER_PARSERS_,e,o);if(r){var i=ol.format.XSD.readBooleanString(e.getAttribute("queryable"));void 0===i&&(i=t.queryable),r.queryable=void 0!==i&&i;var n=ol.format.XSD.readNonNegativeIntegerString(e.getAttribute("cascaded"));void 0===n&&(n=t.cascaded),r.cascaded=n;var l=ol.format.XSD.readBooleanString(e.getAttribute("opaque"));void 0===l&&(l=t.opaque),r.opaque=void 0!==l&&l;var a=ol.format.XSD.readBooleanString(e.getAttribute("noSubsets"));void 0===a&&(a=t.noSubsets),r.noSubsets=void 0!==a&&a;var s=ol.format.XSD.readDecimalString(e.getAttribute("fixedWidth"));s||(s=t.fixedWidth),r.fixedWidth=s;var p=ol.format.XSD.readDecimalString(e.getAttribute("fixedHeight"));p||(p=t.fixedHeight),r.fixedHeight=p;["Style","CRS","AuthorityURL"].forEach(function(e){if(e in t){var o=r[e]||[];r[e]=o.concat(t[e])}});return["EX_GeographicBoundingBox","BoundingBox","Dimension","Attribution","MinScaleDenominator","MaxScaleDenominator"].forEach(function(e){if(!(e in r)){var o=t[e];r[e]=o}}),r}},ol.format.WMSCapabilities.readDimension_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Dimension"==e.localName,"localName should be Dimension"),{name:e.getAttribute("name"),units:e.getAttribute("units"),unitSymbol:e.getAttribute("unitSymbol"),default:e.getAttribute("default"),multipleValues:ol.format.XSD.readBooleanString(e.getAttribute("multipleValues")),nearestValue:ol.format.XSD.readBooleanString(e.getAttribute("nearestValue")),current:ol.format.XSD.readBooleanString(e.getAttribute("current")),values:ol.format.XSD.readString(e)}},ol.format.WMSCapabilities.readFormatOnlineresource_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.FORMAT_ONLINERESOURCE_PARSERS_,e,o)},ol.format.WMSCapabilities.readRequest_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Request"==e.localName,"localName should be Request"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.REQUEST_PARSERS_,e,o)},ol.format.WMSCapabilities.readDCPType_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("DCPType"==e.localName,"localName should be DCPType"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.DCPTYPE_PARSERS_,e,o)},ol.format.WMSCapabilities.readHTTP_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("HTTP"==e.localName,"localName should be HTTP"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.HTTP_PARSERS_,e,o)},ol.format.WMSCapabilities.readOperationType_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.OPERATIONTYPE_PARSERS_,e,o)},ol.format.WMSCapabilities.readSizedFormatOnlineresource_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT");var t=ol.format.WMSCapabilities.readFormatOnlineresource_(e,o);if(t){var r=[ol.format.XSD.readNonNegativeIntegerString(e.getAttribute("width")),ol.format.XSD.readNonNegativeIntegerString(e.getAttribute("height"))];return t.size=r,t}},ol.format.WMSCapabilities.readAuthorityURL_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("AuthorityURL"==e.localName,"localName should be AuthorityURL");var t=ol.format.WMSCapabilities.readFormatOnlineresource_(e,o);if(t)return t.name=e.getAttribute("name"),t},ol.format.WMSCapabilities.readMetadataURL_=function(e,o){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("MetadataURL"==e.localName,"localName should be MetadataURL");var t=ol.format.WMSCapabilities.readFormatOnlineresource_(e,o);if(t)return t.type=e.getAttribute("type"),t},ol.format.WMSCapabilities.readStyle_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Style"==e.localName,"localName should be Style"),ol.xml.pushParseAndPop({},ol.format.WMSCapabilities.STYLE_PARSERS_,e,o)},ol.format.WMSCapabilities.readKeywordList_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("KeywordList"==e.localName,"localName should be KeywordList"),ol.xml.pushParseAndPop([],ol.format.WMSCapabilities.KEYWORDLIST_PARSERS_,e,o)},ol.format.WMSCapabilities.NAMESPACE_URIS_=[null,"http://www.opengis.net/wms"],ol.format.WMSCapabilities.PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Service:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readService_),Capability:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readCapability_)}),ol.format.WMSCapabilities.CAPABILITY_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Request:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readRequest_),Exception:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readException_),Layer:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readCapabilityLayer_)}),ol.format.WMSCapabilities.SERVICE_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Name:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Title:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Abstract:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),KeywordList:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readKeywordList_),OnlineResource:ol.xml.makeObjectPropertySetter(ol.format.XLink.readHref),ContactInformation:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readContactInformation_),Fees:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),AccessConstraints:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),LayerLimit:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),MaxWidth:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),MaxHeight:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger)}),ol.format.WMSCapabilities.CONTACT_INFORMATION_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{ContactPersonPrimary:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readContactPersonPrimary_),ContactPosition:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),ContactAddress:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readContactAddress_),ContactVoiceTelephone:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),ContactFacsimileTelephone:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),ContactElectronicMailAddress:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)}),ol.format.WMSCapabilities.CONTACT_PERSON_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{ContactPerson:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),ContactOrganization:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)}),ol.format.WMSCapabilities.CONTACT_ADDRESS_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{AddressType:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Address:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),City:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),StateOrProvince:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),PostCode:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Country:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)}),ol.format.WMSCapabilities.EXCEPTION_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Format:ol.xml.makeArrayPusher(ol.format.XSD.readString)}),ol.format.WMSCapabilities.LAYER_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Name:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Title:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Abstract:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),KeywordList:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readKeywordList_),CRS:ol.xml.makeObjectPropertyPusher(ol.format.XSD.readString),EX_GeographicBoundingBox:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readEXGeographicBoundingBox_),BoundingBox:ol.xml.makeObjectPropertyPusher(ol.format.WMSCapabilities.readBoundingBox_),Dimension:ol.xml.makeObjectPropertyPusher(ol.format.WMSCapabilities.readDimension_),Attribution:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readAttribution_),AuthorityURL:ol.xml.makeObjectPropertyPusher(ol.format.WMSCapabilities.readAuthorityURL_),Identifier:ol.xml.makeObjectPropertyPusher(ol.format.XSD.readString),MetadataURL:ol.xml.makeObjectPropertyPusher(ol.format.WMSCapabilities.readMetadataURL_),DataURL:ol.xml.makeObjectPropertyPusher(ol.format.WMSCapabilities.readFormatOnlineresource_),FeatureListURL:ol.xml.makeObjectPropertyPusher(ol.format.WMSCapabilities.readFormatOnlineresource_),Style:ol.xml.makeObjectPropertyPusher(ol.format.WMSCapabilities.readStyle_),MinScaleDenominator:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),MaxScaleDenominator:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),Layer:ol.xml.makeObjectPropertyPusher(ol.format.WMSCapabilities.readLayer_)}),ol.format.WMSCapabilities.ATTRIBUTION_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Title:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),OnlineResource:ol.xml.makeObjectPropertySetter(ol.format.XLink.readHref),LogoURL:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readSizedFormatOnlineresource_)}),ol.format.WMSCapabilities.EX_GEOGRAPHIC_BOUNDING_BOX_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{westBoundLongitude:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),eastBoundLongitude:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),southBoundLatitude:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),northBoundLatitude:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal)}),ol.format.WMSCapabilities.REQUEST_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{GetCapabilities:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readOperationType_),GetMap:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readOperationType_),GetFeatureInfo:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readOperationType_)}),ol.format.WMSCapabilities.OPERATIONTYPE_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Format:ol.xml.makeObjectPropertyPusher(ol.format.XSD.readString),DCPType:ol.xml.makeObjectPropertyPusher(ol.format.WMSCapabilities.readDCPType_)}),ol.format.WMSCapabilities.DCPTYPE_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{HTTP:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readHTTP_)}),ol.format.WMSCapabilities.HTTP_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Get:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readFormatOnlineresource_),Post:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readFormatOnlineresource_)}),ol.format.WMSCapabilities.STYLE_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Name:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Title:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Abstract:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),LegendURL:ol.xml.makeObjectPropertyPusher(ol.format.WMSCapabilities.readSizedFormatOnlineresource_),StyleSheetURL:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readFormatOnlineresource_),StyleURL:ol.xml.makeObjectPropertySetter(ol.format.WMSCapabilities.readFormatOnlineresource_)}),ol.format.WMSCapabilities.FORMAT_ONLINERESOURCE_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Format:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),OnlineResource:ol.xml.makeObjectPropertySetter(ol.format.XLink.readHref)}),ol.format.WMSCapabilities.KEYWORDLIST_PARSERS_=ol.xml.makeStructureNS(ol.format.WMSCapabilities.NAMESPACE_URIS_,{Keyword:ol.xml.makeArrayPusher(ol.format.XSD.readString)}),goog.provide("ol.format.WMSGetFeatureInfo"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.format.GML2"),goog.require("ol.format.XMLFeature"),goog.require("ol.obj"),goog.require("ol.xml"),ol.format.WMSGetFeatureInfo=function(e){var o=e||{};this.featureNS_="http://mapserver.gis.umn.edu/mapserver",this.gmlFormat_=new ol.format.GML2,this.layers_=o.layers?o.layers:null,ol.format.XMLFeature.call(this)},ol.inherits(ol.format.WMSGetFeatureInfo,ol.format.XMLFeature),ol.format.WMSGetFeatureInfo.featureIdentifier_="_feature",ol.format.WMSGetFeatureInfo.layerIdentifier_="_layer",ol.format.WMSGetFeatureInfo.prototype.readFeatures_=function(e,o){e.setAttribute("namespaceURI",this.featureNS_),ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT");var t=e.localName,r=[];if(0===e.childNodes.length)return r;if("msGMLOutput"==t)for(var i=0,n=e.childNodes.length;i<n;i++){var l=e.childNodes[i];if(l.nodeType===Node.ELEMENT_NODE){var a=o[0];ol.DEBUG&&console.assert(l.localName.indexOf(ol.format.WMSGetFeatureInfo.layerIdentifier_)>=0,"localName of layer node should match layerIdentifier");var s=ol.format.WMSGetFeatureInfo.layerIdentifier_,p=l.localName.replace(s,"");if(!this.layers_||ol.array.includes(this.layers_,p)){var g=p+ol.format.WMSGetFeatureInfo.featureIdentifier_;a.featureType=g,a.featureNS=this.featureNS_;var c={};c[g]=ol.xml.makeArrayPusher(this.gmlFormat_.readFeatureElement,this.gmlFormat_);var u=ol.xml.makeStructureNS([a.featureNS,null],c);l.setAttribute("namespaceURI",this.featureNS_);var y=ol.xml.pushParseAndPop([],u,l,o,this.gmlFormat_);y&&ol.array.extend(r,y)}}}if("FeatureCollection"==t){var d=ol.xml.pushParseAndPop([],this.gmlFormat_.FEATURE_COLLECTION_PARSERS,e,[{}],this.gmlFormat_);d&&(r=d)}return r},ol.format.WMSGetFeatureInfo.prototype.readFeatures,ol.format.WMSGetFeatureInfo.prototype.readFeaturesFromNode=function(e,o){var t={};return o&&ol.obj.assign(t,this.getReadOptions(e,o)),this.readFeatures_(e,[t])},goog.provide("ol.format.WMTSCapabilities"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.format.OWS"),goog.require("ol.format.XLink"),goog.require("ol.format.XML"),goog.require("ol.format.XSD"),goog.require("ol.xml"),ol.format.WMTSCapabilities=function(){ol.format.XML.call(this),this.owsParser_=new ol.format.OWS},ol.inherits(ol.format.WMTSCapabilities,ol.format.XML),ol.format.WMTSCapabilities.prototype.read,ol.format.WMTSCapabilities.prototype.readFromDocument=function(e){ol.DEBUG&&console.assert(e.nodeType==Node.DOCUMENT_NODE,"doc.nodeType should be DOCUMENT");for(var o=e.firstChild;o;o=o.nextSibling)if(o.nodeType==Node.ELEMENT_NODE)return this.readFromNode(o);return null},ol.format.WMTSCapabilities.prototype.readFromNode=function(e){ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Capabilities"==e.localName,"localName should be Capabilities");var o=e.getAttribute("version").trim(),t=this.owsParser_.readFromNode(e);return t?(t.version=o,(t=ol.xml.pushParseAndPop(t,ol.format.WMTSCapabilities.PARSERS_,e,[]))||null):null},ol.format.WMTSCapabilities.readContents_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Contents"==e.localName,"localName should be Contents"),ol.xml.pushParseAndPop({},ol.format.WMTSCapabilities.CONTENTS_PARSERS_,e,o)},ol.format.WMTSCapabilities.readLayer_=function(e,o){return ol.DEBUG&&console.assert(e.nodeType==Node.ELEMENT_NODE,"node.nodeType should be ELEMENT"),ol.DEBUG&&console.assert("Layer"==e.localName,"localName should be Layer"),ol.xml.pushParseAndPop({},ol.format.WMTSCapabilities.LAYER_PARSERS_,e,o)},ol.format.WMTSCapabilities.readTileMatrixSet_=function(e,o){return ol.xml.pushParseAndPop({},ol.format.WMTSCapabilities.TMS_PARSERS_,e,o)},ol.format.WMTSCapabilities.readStyle_=function(e,o){var t=ol.xml.pushParseAndPop({},ol.format.WMTSCapabilities.STYLE_PARSERS_,e,o);if(t){var r="true"===e.getAttribute("isDefault");return t.isDefault=r,t}},ol.format.WMTSCapabilities.readTileMatrixSetLink_=function(e,o){return ol.xml.pushParseAndPop({},ol.format.WMTSCapabilities.TMS_LINKS_PARSERS_,e,o)},ol.format.WMTSCapabilities.readDimensions_=function(e,o){return ol.xml.pushParseAndPop({},ol.format.WMTSCapabilities.DIMENSION_PARSERS_,e,o)},ol.format.WMTSCapabilities.readResourceUrl_=function(e,o){var t=e.getAttribute("format"),r=e.getAttribute("template"),i=e.getAttribute("resourceType"),n={};return t&&(n.format=t),r&&(n.template=r),i&&(n.resourceType=i),n},ol.format.WMTSCapabilities.readWgs84BoundingBox_=function(e,o){var t=ol.xml.pushParseAndPop([],ol.format.WMTSCapabilities.WGS84_BBOX_READERS_,e,o);if(2==t.length)return ol.extent.boundingExtent(t)},ol.format.WMTSCapabilities.readLegendUrl_=function(e,o){var t={};return t.format=e.getAttribute("format"),t.href=ol.format.XLink.readHref(e),t},ol.format.WMTSCapabilities.readCoordinates_=function(e,o){var t=ol.format.XSD.readString(e).split(" ");if(t&&2==t.length){var r=+t[0],i=+t[1];if(!isNaN(r)&&!isNaN(i))return[r,i]}},ol.format.WMTSCapabilities.readTileMatrix_=function(e,o){return ol.xml.pushParseAndPop({},ol.format.WMTSCapabilities.TM_PARSERS_,e,o)},ol.format.WMTSCapabilities.readTileMatrixLimitsList_=function(e,o){return ol.xml.pushParseAndPop([],ol.format.WMTSCapabilities.TMS_LIMITS_LIST_PARSERS_,e,o)},ol.format.WMTSCapabilities.readTileMatrixLimits_=function(e,o){return ol.xml.pushParseAndPop({},ol.format.WMTSCapabilities.TMS_LIMITS_PARSERS_,e,o)},ol.format.WMTSCapabilities.NAMESPACE_URIS_=[null,"http://www.opengis.net/wmts/1.0"],ol.format.WMTSCapabilities.OWS_NAMESPACE_URIS_=[null,"http://www.opengis.net/ows/1.1"],ol.format.WMTSCapabilities.PARSERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.NAMESPACE_URIS_,{Contents:ol.xml.makeObjectPropertySetter(ol.format.WMTSCapabilities.readContents_)}),ol.format.WMTSCapabilities.CONTENTS_PARSERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.NAMESPACE_URIS_,{Layer:ol.xml.makeObjectPropertyPusher(ol.format.WMTSCapabilities.readLayer_),TileMatrixSet:ol.xml.makeObjectPropertyPusher(ol.format.WMTSCapabilities.readTileMatrixSet_)}),ol.format.WMTSCapabilities.LAYER_PARSERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.NAMESPACE_URIS_,{Style:ol.xml.makeObjectPropertyPusher(ol.format.WMTSCapabilities.readStyle_),Format:ol.xml.makeObjectPropertyPusher(ol.format.XSD.readString),TileMatrixSetLink:ol.xml.makeObjectPropertyPusher(ol.format.WMTSCapabilities.readTileMatrixSetLink_),Dimension:ol.xml.makeObjectPropertyPusher(ol.format.WMTSCapabilities.readDimensions_),ResourceURL:ol.xml.makeObjectPropertyPusher(ol.format.WMTSCapabilities.readResourceUrl_)},ol.xml.makeStructureNS(ol.format.WMTSCapabilities.OWS_NAMESPACE_URIS_,{Title:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Abstract:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),WGS84BoundingBox:ol.xml.makeObjectPropertySetter(ol.format.WMTSCapabilities.readWgs84BoundingBox_),Identifier:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)})),ol.format.WMTSCapabilities.STYLE_PARSERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.NAMESPACE_URIS_,{LegendURL:ol.xml.makeObjectPropertyPusher(ol.format.WMTSCapabilities.readLegendUrl_)},ol.xml.makeStructureNS(ol.format.WMTSCapabilities.OWS_NAMESPACE_URIS_,{Title:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Identifier:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)})),ol.format.WMTSCapabilities.TMS_LINKS_PARSERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.NAMESPACE_URIS_,{TileMatrixSet:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),TileMatrixSetLimits:ol.xml.makeObjectPropertySetter(ol.format.WMTSCapabilities.readTileMatrixLimitsList_)}),ol.format.WMTSCapabilities.TMS_LIMITS_LIST_PARSERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.NAMESPACE_URIS_,{TileMatrixLimits:ol.xml.makeArrayPusher(ol.format.WMTSCapabilities.readTileMatrixLimits_)}),ol.format.WMTSCapabilities.TMS_LIMITS_PARSERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.NAMESPACE_URIS_,{TileMatrix:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),MinTileRow:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),MaxTileRow:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),MinTileCol:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),MaxTileCol:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger)}),ol.format.WMTSCapabilities.DIMENSION_PARSERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.NAMESPACE_URIS_,{Default:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Value:ol.xml.makeObjectPropertyPusher(ol.format.XSD.readString)},ol.xml.makeStructureNS(ol.format.WMTSCapabilities.OWS_NAMESPACE_URIS_,{Identifier:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)})),ol.format.WMTSCapabilities.WGS84_BBOX_READERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.OWS_NAMESPACE_URIS_,{LowerCorner:ol.xml.makeArrayPusher(ol.format.WMTSCapabilities.readCoordinates_),UpperCorner:ol.xml.makeArrayPusher(ol.format.WMTSCapabilities.readCoordinates_)}),ol.format.WMTSCapabilities.TMS_PARSERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.NAMESPACE_URIS_,{WellKnownScaleSet:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),TileMatrix:ol.xml.makeObjectPropertyPusher(ol.format.WMTSCapabilities.readTileMatrix_)},ol.xml.makeStructureNS(ol.format.WMTSCapabilities.OWS_NAMESPACE_URIS_,{SupportedCRS:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString),Identifier:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)})),ol.format.WMTSCapabilities.TM_PARSERS_=ol.xml.makeStructureNS(ol.format.WMTSCapabilities.NAMESPACE_URIS_,{TopLeftCorner:ol.xml.makeObjectPropertySetter(ol.format.WMTSCapabilities.readCoordinates_),ScaleDenominator:ol.xml.makeObjectPropertySetter(ol.format.XSD.readDecimal),TileWidth:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),TileHeight:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),MatrixWidth:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger),MatrixHeight:ol.xml.makeObjectPropertySetter(ol.format.XSD.readNonNegativeInteger)},ol.xml.makeStructureNS(ol.format.WMTSCapabilities.OWS_NAMESPACE_URIS_,{Identifier:ol.xml.makeObjectPropertySetter(ol.format.XSD.readString)})),goog.provide("ol.Geolocation"),goog.require("ol"),goog.require("ol.Object"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.geom.Polygon"),goog.require("ol.has"),goog.require("ol.math"),goog.require("ol.proj"),goog.require("ol.sphere.WGS84"),ol.Geolocation=function(e){ol.Object.call(this);var o=e||{};this.position_=null,this.transform_=ol.proj.identityTransform,this.watchId_=void 0,ol.events.listen(this,ol.Object.getChangeEventType(ol.Geolocation.Property.PROJECTION),this.handleProjectionChanged_,this),ol.events.listen(this,ol.Object.getChangeEventType(ol.Geolocation.Property.TRACKING),this.handleTrackingChanged_,this),void 0!==o.projection&&this.setProjection(ol.proj.get(o.projection)),void 0!==o.trackingOptions&&this.setTrackingOptions(o.trackingOptions),this.setTracking(void 0!==o.tracking&&o.tracking)},ol.inherits(ol.Geolocation,ol.Object),ol.Geolocation.prototype.disposeInternal=function(){this.setTracking(!1),ol.Object.prototype.disposeInternal.call(this)},ol.Geolocation.prototype.handleProjectionChanged_=function(){var e=this.getProjection();e&&(this.transform_=ol.proj.getTransformFromProjections(ol.proj.get("EPSG:4326"),e),this.position_&&this.set(ol.Geolocation.Property.POSITION,this.transform_(this.position_)))},ol.Geolocation.prototype.handleTrackingChanged_=function(){if(ol.has.GEOLOCATION){var e=this.getTracking();e&&void 0===this.watchId_?this.watchId_=navigator.geolocation.watchPosition(this.positionChange_.bind(this),this.positionError_.bind(this),this.getTrackingOptions()):e||void 0===this.watchId_||(navigator.geolocation.clearWatch(this.watchId_),this.watchId_=void 0)}},ol.Geolocation.prototype.positionChange_=function(e){var o=e.coords;this.set(ol.Geolocation.Property.ACCURACY,o.accuracy),this.set(ol.Geolocation.Property.ALTITUDE,null===o.altitude?void 0:o.altitude),this.set(ol.Geolocation.Property.ALTITUDE_ACCURACY,null===o.altitudeAccuracy?void 0:o.altitudeAccuracy),this.set(ol.Geolocation.Property.HEADING,null===o.heading?void 0:ol.math.toRadians(o.heading)),this.position_?(this.position_[0]=o.longitude,this.position_[1]=o.latitude):this.position_=[o.longitude,o.latitude];var t=this.transform_(this.position_);this.set(ol.Geolocation.Property.POSITION,t),this.set(ol.Geolocation.Property.SPEED,null===o.speed?void 0:o.speed);var r=ol.geom.Polygon.circular(ol.sphere.WGS84,this.position_,o.accuracy);r.applyTransform(this.transform_),this.set(ol.Geolocation.Property.ACCURACY_GEOMETRY,r),this.changed()},ol.Geolocation.prototype.positionError_=function(e){e.type=ol.events.EventType.ERROR,this.setTracking(!1),this.dispatchEvent(e)},ol.Geolocation.prototype.getAccuracy=function(){return this.get(ol.Geolocation.Property.ACCURACY)},ol.Geolocation.prototype.getAccuracyGeometry=function(){return this.get(ol.Geolocation.Property.ACCURACY_GEOMETRY)||null},ol.Geolocation.prototype.getAltitude=function(){return this.get(ol.Geolocation.Property.ALTITUDE)},ol.Geolocation.prototype.getAltitudeAccuracy=function(){return this.get(ol.Geolocation.Property.ALTITUDE_ACCURACY)},ol.Geolocation.prototype.getHeading=function(){return this.get(ol.Geolocation.Property.HEADING)},ol.Geolocation.prototype.getPosition=function(){return this.get(ol.Geolocation.Property.POSITION)},ol.Geolocation.prototype.getProjection=function(){return this.get(ol.Geolocation.Property.PROJECTION)},ol.Geolocation.prototype.getSpeed=function(){return this.get(ol.Geolocation.Property.SPEED)},ol.Geolocation.prototype.getTracking=function(){return this.get(ol.Geolocation.Property.TRACKING)},ol.Geolocation.prototype.getTrackingOptions=function(){return this.get(ol.Geolocation.Property.TRACKING_OPTIONS)},ol.Geolocation.prototype.setProjection=function(e){this.set(ol.Geolocation.Property.PROJECTION,e)},ol.Geolocation.prototype.setTracking=function(e){this.set(ol.Geolocation.Property.TRACKING,e)},ol.Geolocation.prototype.setTrackingOptions=function(e){this.set(ol.Geolocation.Property.TRACKING_OPTIONS,e)},ol.Geolocation.Property={ACCURACY:"accuracy",ACCURACY_GEOMETRY:"accuracyGeometry",ALTITUDE:"altitude",ALTITUDE_ACCURACY:"altitudeAccuracy",HEADING:"heading",POSITION:"position",PROJECTION:"projection",SPEED:"speed",TRACKING:"tracking",TRACKING_OPTIONS:"trackingOptions"},goog.provide("ol.geom.Circle"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.geom.flat.deflate"),ol.geom.Circle=function(e,o,t){ol.geom.SimpleGeometry.call(this);var r=o||0;this.setCenterAndRadius(e,r,t)};ol.inherits(ol.geom.Circle,ol.geom.SimpleGeometry),ol.geom.Circle.prototype.clone=function(){var e=new ol.geom.Circle(null);return e.setFlatCoordinates(this.layout,this.flatCoordinates.slice()),e},ol.geom.Circle.prototype.closestPointXY=function(e,o,t,r){var i=this.flatCoordinates,n=e-i[0],l=o-i[1],a=n*n+l*l;if(a<r){var s;if(0===a)for(s=0;s<this.stride;++s)t[s]=i[s];else{var p=this.getRadius()/Math.sqrt(a);for(t[0]=i[0]+p*n,t[1]=i[1]+p*l,s=2;s<this.stride;++s)t[s]=i[s]}return t.length=this.stride,a}return r},ol.geom.Circle.prototype.containsXY=function(e,o){var t=this.flatCoordinates,r=e-t[0],i=o-t[1];return r*r+i*i<=this.getRadiusSquared_()},ol.geom.Circle.prototype.getCenter=function(){return this.flatCoordinates.slice(0,this.stride)},ol.geom.Circle.prototype.computeExtent=function(e){var o=this.flatCoordinates,t=o[this.stride]-o[0];return ol.extent.createOrUpdate(o[0]-t,o[1]-t,o[0]+t,o[1]+t,e)},ol.geom.Circle.prototype.getRadius=function(){return Math.sqrt(this.getRadiusSquared_())},ol.geom.Circle.prototype.getRadiusSquared_=function(){var e=this.flatCoordinates[this.stride]-this.flatCoordinates[0],o=this.flatCoordinates[this.stride+1]-this.flatCoordinates[1];return e*e+o*o},ol.geom.Circle.prototype.getType=function(){return ol.geom.GeometryType.CIRCLE},ol.geom.Circle.prototype.intersectsExtent=function(e){var o=this.getExtent();if(ol.extent.intersects(e,o)){var t=this.getCenter();return e[0]<=t[0]&&e[2]>=t[0]||(e[1]<=t[1]&&e[3]>=t[1]||ol.extent.forEachCorner(e,this.intersectsCoordinate,this))}return!1},ol.geom.Circle.prototype.setCenter=function(e){var o=this.stride;ol.DEBUG&&console.assert(e.length==o,"center array length should match stride")
;var t=this.flatCoordinates[o]-this.flatCoordinates[0],r=e.slice();r[o]=r[0]+t;var i;for(i=1;i<o;++i)r[o+i]=e[i];this.setFlatCoordinates(this.layout,r)},ol.geom.Circle.prototype.setCenterAndRadius=function(e,o,t){if(e){this.setLayout(t,e,0),this.flatCoordinates||(this.flatCoordinates=[]);var r=this.flatCoordinates,i=ol.geom.flat.deflate.coordinate(r,0,e,this.stride);r[i++]=r[0]+o;var n,l;for(n=1,l=this.stride;n<l;++n)r[i++]=r[n];r.length=i,this.changed()}else this.setFlatCoordinates(ol.geom.GeometryLayout.XY,null)},ol.geom.Circle.prototype.setFlatCoordinates=function(e,o){this.setFlatCoordinatesInternal(e,o),this.changed()},ol.geom.Circle.prototype.setRadius=function(e){this.flatCoordinates[this.stride]=this.flatCoordinates[0]+e,this.changed()},ol.geom.Circle.prototype.transform,goog.provide("ol.geom.flat.geodesic"),goog.require("ol"),goog.require("ol.math"),goog.require("ol.proj"),ol.geom.flat.geodesic.line_=function(e,o,t){for(var r,i,n,l,a,s,p=[],g=e(0),c=e(1),u=o(g),y=o(c),d=[c,g],h=[y,u],m=[1,0],f={},_=1e5;--_>0&&m.length>0;)n=m.pop(),g=d.pop(),u=h.pop(),s=n.toString(),s in f||(p.push(u[0],u[1]),f[s]=!0),l=m.pop(),c=d.pop(),y=h.pop(),a=(n+l)/2,r=e(a),i=o(r),ol.math.squaredSegmentDistance(i[0],i[1],u[0],u[1],y[0],y[1])<t?(p.push(y[0],y[1]),s=l.toString(),ol.DEBUG&&console.assert(!(s in f),"fractions object should contain key : "+s),f[s]=!0):(m.push(l,a,a,n),h.push(y,i,i,u),d.push(c,r,r,g));return ol.DEBUG&&console.assert(_>0,"maxIterations should be more than 0"),p},ol.geom.flat.geodesic.greatCircleArc=function(e,o,t,r,i,n){var l=ol.proj.get("EPSG:4326"),a=Math.cos(ol.math.toRadians(o)),s=Math.sin(ol.math.toRadians(o)),p=Math.cos(ol.math.toRadians(r)),g=Math.sin(ol.math.toRadians(r)),c=Math.cos(ol.math.toRadians(t-e)),u=Math.sin(ol.math.toRadians(t-e)),y=s*g+a*p*c;return ol.geom.flat.geodesic.line_(function(o){if(1<=y)return[t,r];var i=o*Math.acos(y),n=Math.cos(i),l=Math.sin(i),d=u*p,h=a*g-s*p*c,m=Math.atan2(d,h),f=Math.asin(s*n+a*l*Math.cos(m)),_=ol.math.toRadians(e)+Math.atan2(Math.sin(m)*l*a,n-s*Math.sin(f));return[ol.math.toDegrees(_),ol.math.toDegrees(f)]},ol.proj.getTransform(l,i),n)},ol.geom.flat.geodesic.meridian=function(e,o,t,r,i){var n=ol.proj.get("EPSG:4326");return ol.geom.flat.geodesic.line_(function(r){return[e,o+(t-o)*r]},ol.proj.getTransform(n,r),i)},ol.geom.flat.geodesic.parallel=function(e,o,t,r,i){var n=ol.proj.get("EPSG:4326");return ol.geom.flat.geodesic.line_(function(r){return[o+(t-o)*r,e]},ol.proj.getTransform(n,r),i)},goog.provide("ol.Graticule"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.geom.GeometryLayout"),goog.require("ol.geom.LineString"),goog.require("ol.geom.flat.geodesic"),goog.require("ol.math"),goog.require("ol.proj"),goog.require("ol.render.Event"),goog.require("ol.style.Stroke"),ol.Graticule=function(e){var o=e||{};this.map_=null,this.projection_=null,this.maxLat_=1/0,this.maxLon_=1/0,this.minLat_=-1/0,this.minLon_=-1/0,this.maxLatP_=1/0,this.maxLonP_=1/0,this.minLatP_=-1/0,this.minLonP_=-1/0,this.targetSize_=void 0!==o.targetSize?o.targetSize:100,this.maxLines_=void 0!==o.maxLines?o.maxLines:100,ol.DEBUG&&console.assert(this.maxLines_>0,"this.maxLines_ should be more than 0"),this.meridians_=[],this.parallels_=[],this.strokeStyle_=void 0!==o.strokeStyle?o.strokeStyle:ol.Graticule.DEFAULT_STROKE_STYLE_,this.fromLonLatTransform_=void 0,this.toLonLatTransform_=void 0,this.projectionCenterLonLat_=null,this.setMap(void 0!==o.map?o.map:null)},ol.Graticule.DEFAULT_STROKE_STYLE_=new ol.style.Stroke({color:"rgba(0,0,0,0.2)"}),ol.Graticule.intervals_=[90,45,30,20,10,5,2,1,.5,.2,.1,.05,.01,.005,.002,.001],ol.Graticule.prototype.addMeridian_=function(e,o,t,r,i,n){var l=this.getMeridian_(e,o,t,r,n);return ol.extent.intersects(l.getExtent(),i)&&(this.meridians_[n++]=l),n},ol.Graticule.prototype.addParallel_=function(e,o,t,r,i,n){var l=this.getParallel_(e,o,t,r,n);return ol.extent.intersects(l.getExtent(),i)&&(this.parallels_[n++]=l),n},ol.Graticule.prototype.createGraticule_=function(e,o,t,r){var i=this.getInterval_(t);if(-1==i)return void(this.meridians_.length=this.parallels_.length=0);var n,l,a,s,p=this.toLonLatTransform_(o),g=p[0],c=p[1],u=this.maxLines_,y=[Math.max(e[0],this.minLonP_),Math.max(e[1],this.minLatP_),Math.min(e[2],this.maxLonP_),Math.min(e[3],this.maxLatP_)];y=ol.proj.transformExtent(y,this.projection_,"EPSG:4326");var d=y[3],h=y[2],m=y[1],f=y[0];for(g=Math.floor(g/i)*i,s=ol.math.clamp(g,this.minLon_,this.maxLon_),l=this.addMeridian_(s,m,d,r,e,0),n=0;s!=this.minLon_&&n++<u;)s=Math.max(s-i,this.minLon_),l=this.addMeridian_(s,m,d,r,e,l);for(s=ol.math.clamp(g,this.minLon_,this.maxLon_),n=0;s!=this.maxLon_&&n++<u;)s=Math.min(s+i,this.maxLon_),l=this.addMeridian_(s,m,d,r,e,l);for(this.meridians_.length=l,c=Math.floor(c/i)*i,a=ol.math.clamp(c,this.minLat_,this.maxLat_),l=this.addParallel_(a,f,h,r,e,0),n=0;a!=this.minLat_&&n++<u;)a=Math.max(a-i,this.minLat_),l=this.addParallel_(a,f,h,r,e,l);for(a=ol.math.clamp(c,this.minLat_,this.maxLat_),n=0;a!=this.maxLat_&&n++<u;)a=Math.min(a+i,this.maxLat_),l=this.addParallel_(a,f,h,r,e,l);this.parallels_.length=l},ol.Graticule.prototype.getInterval_=function(e){var o,t,r,i=this.projectionCenterLonLat_[0],n=this.projectionCenterLonLat_[1],l=-1,a=Math.pow(this.targetSize_*e,2),s=[],p=[];for(o=0,t=ol.Graticule.intervals_.length;o<t&&(r=ol.Graticule.intervals_[o]/2,s[0]=i-r,s[1]=n-r,p[0]=i+r,p[1]=n+r,this.fromLonLatTransform_(s,s),this.fromLonLatTransform_(p,p),!(Math.pow(p[0]-s[0],2)+Math.pow(p[1]-s[1],2)<=a));++o)l=ol.Graticule.intervals_[o];return l},ol.Graticule.prototype.getMap=function(){return this.map_},ol.Graticule.prototype.getMeridian_=function(e,o,t,r,i){ol.DEBUG&&console.assert(e>=this.minLon_,"lon should be larger than or equal to this.minLon_"),ol.DEBUG&&console.assert(e<=this.maxLon_,"lon should be smaller than or equal to this.maxLon_");var n=ol.geom.flat.geodesic.meridian(e,o,t,this.projection_,r);ol.DEBUG&&console.assert(n.length>0,"flatCoordinates cannot be empty");var l=void 0!==this.meridians_[i]?this.meridians_[i]:new ol.geom.LineString(null);return l.setFlatCoordinates(ol.geom.GeometryLayout.XY,n),l},ol.Graticule.prototype.getMeridians=function(){return this.meridians_},ol.Graticule.prototype.getParallel_=function(e,o,t,r,i){ol.DEBUG&&console.assert(e>=this.minLat_,"lat should be larger than or equal to this.minLat_"),ol.DEBUG&&console.assert(e<=this.maxLat_,"lat should be smaller than or equal to this.maxLat_");var n=ol.geom.flat.geodesic.parallel(e,this.minLon_,this.maxLon_,this.projection_,r);ol.DEBUG&&console.assert(n.length>0,"flatCoordinates cannot be empty");var l=void 0!==this.parallels_[i]?this.parallels_[i]:new ol.geom.LineString(null);return l.setFlatCoordinates(ol.geom.GeometryLayout.XY,n),l},ol.Graticule.prototype.getParallels=function(){return this.parallels_},ol.Graticule.prototype.handlePostCompose_=function(e){var o=e.vectorContext,t=e.frameState,r=t.extent,i=t.viewState,n=i.center,l=i.projection,a=i.resolution,s=t.pixelRatio,p=a*a/(4*s*s);(!this.projection_||!ol.proj.equivalent(this.projection_,l))&&this.updateProjectionInfo_(l);var g=0;if(l.canWrapX()){var c=l.getExtent(),u=ol.extent.getWidth(c),y=t.focus[0];if(y<c[0]||y>c[2]){g=u*Math.ceil((c[0]-y)/u),r=[r[0]+g,r[1],r[2]+g,r[3]]}}this.createGraticule_(r,n,a,p),o.setFillStrokeStyle(null,this.strokeStyle_);var d,h,m;for(d=0,h=this.meridians_.length;d<h;++d)m=this.meridians_[d],o.drawLineString(m,null);for(d=0,h=this.parallels_.length;d<h;++d)m=this.parallels_[d],o.drawLineString(m,null)},ol.Graticule.prototype.updateProjectionInfo_=function(e){var o=ol.proj.get("EPSG:4326"),t=e.getExtent(),r=e.getWorldExtent(),i=ol.proj.transformExtent(r,o,e),n=r[3],l=r[2],a=r[1],s=r[0],p=i[3],g=i[2],c=i[1],u=i[0];ol.DEBUG&&console.assert(void 0!==n,"maxLat should be defined"),ol.DEBUG&&console.assert(void 0!==l,"maxLon should be defined"),ol.DEBUG&&console.assert(void 0!==a,"minLat should be defined"),ol.DEBUG&&console.assert(void 0!==s,"minLon should be defined"),ol.DEBUG&&console.assert(void 0!==p,"projected maxLat should be defined"),ol.DEBUG&&console.assert(void 0!==g,"projected maxLon should be defined"),ol.DEBUG&&console.assert(void 0!==c,"projected minLat should be defined"),ol.DEBUG&&console.assert(void 0!==u,"projected minLon should be defined"),this.maxLat_=n,this.maxLon_=l,this.minLat_=a,this.minLon_=s,this.maxLatP_=p,this.maxLonP_=g,this.minLatP_=c,this.minLonP_=u,this.fromLonLatTransform_=ol.proj.getTransform(o,e),this.toLonLatTransform_=ol.proj.getTransform(e,o),this.projectionCenterLonLat_=this.toLonLatTransform_(ol.extent.getCenter(t)),this.projection_=e},ol.Graticule.prototype.setMap=function(e){this.map_&&(this.map_.un(ol.render.Event.Type.POSTCOMPOSE,this.handlePostCompose_,this),this.map_.render()),e&&(e.on(ol.render.Event.Type.POSTCOMPOSE,this.handlePostCompose_,this),e.render()),this.map_=e},goog.provide("ol.ImageTile"),goog.require("ol"),goog.require("ol.Tile"),goog.require("ol.events"),goog.require("ol.events.EventType"),ol.ImageTile=function(e,o,t,r,i){ol.Tile.call(this,e,o),this.src_=t,this.image_=new Image,null!==r&&(this.image_.crossOrigin=r),this.imageListenerKeys_=null,this.tileLoadFunction_=i},ol.inherits(ol.ImageTile,ol.Tile),ol.ImageTile.prototype.disposeInternal=function(){this.state==ol.Tile.State.LOADING&&this.unlistenImage_(),this.interimTile&&this.interimTile.dispose(),this.state=ol.Tile.State.ABORT,this.changed(),ol.Tile.prototype.disposeInternal.call(this)},ol.ImageTile.prototype.getImage=function(){return this.image_},ol.ImageTile.prototype.getKey=function(){return this.src_},ol.ImageTile.prototype.handleImageError_=function(){this.state=ol.Tile.State.ERROR,this.unlistenImage_(),this.changed()},ol.ImageTile.prototype.handleImageLoad_=function(){this.image_.naturalWidth&&this.image_.naturalHeight?this.state=ol.Tile.State.LOADED:this.state=ol.Tile.State.EMPTY,this.unlistenImage_(),this.changed()},ol.ImageTile.prototype.load=function(){this.state!=ol.Tile.State.IDLE&&this.state!=ol.Tile.State.ERROR||(this.state=ol.Tile.State.LOADING,this.changed(),ol.DEBUG&&console.assert(!this.imageListenerKeys_,"this.imageListenerKeys_ should be null"),this.imageListenerKeys_=[ol.events.listenOnce(this.image_,ol.events.EventType.ERROR,this.handleImageError_,this),ol.events.listenOnce(this.image_,ol.events.EventType.LOAD,this.handleImageLoad_,this)],this.tileLoadFunction_(this,this.src_))},ol.ImageTile.prototype.unlistenImage_=function(){this.imageListenerKeys_.forEach(ol.events.unlistenByKey),this.imageListenerKeys_=null},goog.provide("ol.interaction.DragAndDrop"),goog.require("ol"),goog.require("ol.functions"),goog.require("ol.events"),goog.require("ol.events.Event"),goog.require("ol.events.EventType"),goog.require("ol.interaction.Interaction"),goog.require("ol.proj"),ol.interaction.DragAndDrop=function(e){var o=e||{};ol.interaction.Interaction.call(this,{handleEvent:ol.interaction.DragAndDrop.handleEvent}),this.formatConstructors_=o.formatConstructors?o.formatConstructors:[],this.projection_=o.projection?ol.proj.get(o.projection):null,this.dropListenKeys_=null,this.target=o.target?o.target:null},ol.inherits(ol.interaction.DragAndDrop,ol.interaction.Interaction),ol.interaction.DragAndDrop.handleDrop_=function(e){var o,t,r,i=e.dataTransfer.files;for(o=0,t=i.length;o<t;++o){r=i.item(o);var n=new FileReader;n.addEventListener(ol.events.EventType.LOAD,this.handleResult_.bind(this,r)),n.readAsText(r)}},ol.interaction.DragAndDrop.handleStop_=function(e){e.stopPropagation(),e.preventDefault(),e.dataTransfer.dropEffect="copy"},ol.interaction.DragAndDrop.prototype.handleResult_=function(e,o){var t=o.target.result,r=this.getMap(),i=this.projection_;if(!i){i=r.getView().getProjection(),ol.DEBUG&&console.assert(void 0!==i,"projection should be defined")}var n,l,a=this.formatConstructors_,s=[];for(n=0,l=a.length;n<l;++n){var p=a[n],g=new p;if((s=this.tryReadFeatures_(g,t,{featureProjection:i}))&&s.length>0)break}this.dispatchEvent(new ol.interaction.DragAndDrop.Event(ol.interaction.DragAndDrop.EventType.ADD_FEATURES,e,s,i))},ol.interaction.DragAndDrop.handleEvent=ol.functions.TRUE,ol.interaction.DragAndDrop.prototype.setMap=function(e){if(this.dropListenKeys_&&(this.dropListenKeys_.forEach(ol.events.unlistenByKey),this.dropListenKeys_=null),ol.interaction.Interaction.prototype.setMap.call(this,e),e){var o=this.target?this.target:e.getViewport();this.dropListenKeys_=[ol.events.listen(o,ol.events.EventType.DROP,ol.interaction.DragAndDrop.handleDrop_,this),ol.events.listen(o,ol.events.EventType.DRAGENTER,ol.interaction.DragAndDrop.handleStop_,this),ol.events.listen(o,ol.events.EventType.DRAGOVER,ol.interaction.DragAndDrop.handleStop_,this),ol.events.listen(o,ol.events.EventType.DROP,ol.interaction.DragAndDrop.handleStop_,this)]}},ol.interaction.DragAndDrop.prototype.tryReadFeatures_=function(e,o,t){try{return e.readFeatures(o,t)}catch(e){return null}},ol.interaction.DragAndDrop.EventType={ADD_FEATURES:"addfeatures"},ol.interaction.DragAndDrop.Event=function(e,o,t,r){ol.events.Event.call(this,e),this.features=t,this.file=o,this.projection=r},ol.inherits(ol.interaction.DragAndDrop.Event,ol.events.Event),goog.provide("ol.interaction.DragRotateAndZoom"),goog.require("ol"),goog.require("ol.View"),goog.require("ol.events.condition"),goog.require("ol.interaction.Interaction"),goog.require("ol.interaction.Pointer"),ol.interaction.DragRotateAndZoom=function(e){var o=e||{};ol.interaction.Pointer.call(this,{handleDownEvent:ol.interaction.DragRotateAndZoom.handleDownEvent_,handleDragEvent:ol.interaction.DragRotateAndZoom.handleDragEvent_,handleUpEvent:ol.interaction.DragRotateAndZoom.handleUpEvent_}),this.condition_=o.condition?o.condition:ol.events.condition.shiftKeyOnly,this.lastAngle_=void 0,this.lastMagnitude_=void 0,this.lastScaleDelta_=0,this.duration_=void 0!==o.duration?o.duration:400},ol.inherits(ol.interaction.DragRotateAndZoom,ol.interaction.Pointer),ol.interaction.DragRotateAndZoom.handleDragEvent_=function(e){if(ol.events.condition.mouseOnly(e)){var o=e.map,t=o.getSize(),r=e.pixel,i=r[0]-t[0]/2,n=t[1]/2-r[1],l=Math.atan2(n,i),a=Math.sqrt(i*i+n*n),s=o.getView();if(void 0!==this.lastAngle_){var p=l-this.lastAngle_;ol.interaction.Interaction.rotateWithoutConstraints(o,s,s.getRotation()-p)}if(this.lastAngle_=l,void 0!==this.lastMagnitude_){var g=this.lastMagnitude_*(s.getResolution()/a);ol.interaction.Interaction.zoomWithoutConstraints(o,s,g)}void 0!==this.lastMagnitude_&&(this.lastScaleDelta_=this.lastMagnitude_/a),this.lastMagnitude_=a}},ol.interaction.DragRotateAndZoom.handleUpEvent_=function(e){if(!ol.events.condition.mouseOnly(e))return!0;var o=e.map,t=o.getView();t.setHint(ol.View.Hint.INTERACTING,-1);var r=this.lastScaleDelta_-1;return ol.interaction.Interaction.rotate(o,t,t.getRotation()),ol.interaction.Interaction.zoom(o,t,t.getResolution(),void 0,this.duration_,r),this.lastScaleDelta_=0,!1},ol.interaction.DragRotateAndZoom.handleDownEvent_=function(e){return!!ol.events.condition.mouseOnly(e)&&(!!this.condition_(e)&&(e.map.getView().setHint(ol.View.Hint.INTERACTING,1),this.lastAngle_=void 0,this.lastMagnitude_=void 0,!0))},goog.provide("ol.loadingstrategy"),ol.loadingstrategy.all=function(e,o){return[[-1/0,-1/0,1/0,1/0]]},ol.loadingstrategy.bbox=function(e,o){return[e]},ol.loadingstrategy.tile=function(e){return function(o,t){var r=e.getZForResolution(t),i=e.getTileRangeForExtentAndZ(o,r),n=[],l=[r,0,0];for(l[1]=i.minX;l[1]<=i.maxX;++l[1])for(l[2]=i.minY;l[2]<=i.maxY;++l[2])n.push(e.getTileCoordExtent(l));return n}},goog.provide("ol.source.Vector"),goog.require("ol"),goog.require("ol.Collection"),goog.require("ol.Object"),goog.require("ol.array"),goog.require("ol.asserts"),goog.require("ol.events"),goog.require("ol.events.Event"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.featureloader"),goog.require("ol.functions"),goog.require("ol.loadingstrategy"),goog.require("ol.obj"),goog.require("ol.source.Source"),goog.require("ol.source.State"),goog.require("ol.structs.RBush"),ol.source.Vector=function(e){var o=e||{};ol.source.Source.call(this,{attributions:o.attributions,logo:o.logo,projection:void 0,state:ol.source.State.READY,wrapX:void 0===o.wrapX||o.wrapX}),this.loader_=ol.nullFunction,this.format_=o.format,this.overlaps_=void 0==o.overlaps||o.overlaps,this.url_=o.url,void 0!==o.loader?this.loader_=o.loader:void 0!==this.url_&&(ol.asserts.assert(this.format_,7),this.loader_=ol.featureloader.xhr(this.url_,this.format_)),this.strategy_=void 0!==o.strategy?o.strategy:ol.loadingstrategy.all;var t=void 0===o.useSpatialIndex||o.useSpatialIndex;this.featuresRtree_=t?new ol.structs.RBush:null,this.loadedExtentsRtree_=new ol.structs.RBush,this.nullGeometryFeatures_={},this.idIndex_={},this.undefIdIndex_={},this.featureChangeKeys_={},this.featuresCollection_=null;var r,i;o.features instanceof ol.Collection?(r=o.features,i=r.getArray()):Array.isArray(o.features)&&(i=o.features),t||void 0!==r||(r=new ol.Collection(i)),void 0!==i&&this.addFeaturesInternal(i),void 0!==r&&this.bindFeaturesCollection_(r)},ol.inherits(ol.source.Vector,ol.source.Source),ol.source.Vector.prototype.addFeature=function(e){this.addFeatureInternal(e),this.changed()},ol.source.Vector.prototype.addFeatureInternal=function(e){var o=ol.getUid(e).toString();if(this.addToIndex_(o,e)){this.setupChangeEvents_(o,e);var t=e.getGeometry();if(t){var r=t.getExtent();this.featuresRtree_&&this.featuresRtree_.insert(r,e)}else this.nullGeometryFeatures_[o]=e;this.dispatchEvent(new ol.source.Vector.Event(ol.source.Vector.EventType.ADDFEATURE,e))}},ol.source.Vector.prototype.setupChangeEvents_=function(e,o){ol.DEBUG&&console.assert(!(e in this.featureChangeKeys_),"key (%s) not yet registered in featureChangeKey",e),this.featureChangeKeys_[e]=[ol.events.listen(o,ol.events.EventType.CHANGE,this.handleFeatureChange_,this),ol.events.listen(o,ol.Object.EventType.PROPERTYCHANGE,this.handleFeatureChange_,this)]},ol.source.Vector.prototype.addToIndex_=function(e,o){var t=!0,r=o.getId();return void 0!==r?r.toString()in this.idIndex_?t=!1:this.idIndex_[r.toString()]=o:(ol.asserts.assert(!(e in this.undefIdIndex_),30),this.undefIdIndex_[e]=o),t},ol.source.Vector.prototype.addFeatures=function(e){this.addFeaturesInternal(e),this.changed()},ol.source.Vector.prototype.addFeaturesInternal=function(e){var o,t,r,i,n=[],l=[],a=[];for(t=0,r=e.length;t<r;t++)i=e[t],o=ol.getUid(i).toString(),this.addToIndex_(o,i)&&l.push(i);for(t=0,r=l.length;t<r;t++){i=l[t],o=ol.getUid(i).toString(),this.setupChangeEvents_(o,i);var s=i.getGeometry();if(s){var p=s.getExtent();n.push(p),a.push(i)}else this.nullGeometryFeatures_[o]=i}for(this.featuresRtree_&&this.featuresRtree_.load(n,a),t=0,r=l.length;t<r;t++)this.dispatchEvent(new ol.source.Vector.Event(ol.source.Vector.EventType.ADDFEATURE,l[t]))},ol.source.Vector.prototype.bindFeaturesCollection_=function(e){ol.DEBUG&&console.assert(!this.featuresCollection_,"bindFeaturesCollection can only be called once");var o=!1;ol.events.listen(this,ol.source.Vector.EventType.ADDFEATURE,function(t){o||(o=!0,e.push(t.feature),o=!1)}),ol.events.listen(this,ol.source.Vector.EventType.REMOVEFEATURE,function(t){o||(o=!0,e.remove(t.feature),o=!1)}),ol.events.listen(e,ol.Collection.EventType.ADD,function(e){o||(o=!0,this.addFeature(e.element),o=!1)},this),ol.events.listen(e,ol.Collection.EventType.REMOVE,function(e){o||(o=!0,this.removeFeature(e.element),o=!1)},this),this.featuresCollection_=e},ol.source.Vector.prototype.clear=function(e){if(e){for(var o in this.featureChangeKeys_){this.featureChangeKeys_[o].forEach(ol.events.unlistenByKey)}this.featuresCollection_||(this.featureChangeKeys_={},this.idIndex_={},this.undefIdIndex_={})}else if(this.featuresRtree_){this.featuresRtree_.forEach(this.removeFeatureInternal,this);for(var t in this.nullGeometryFeatures_)this.removeFeatureInternal(this.nullGeometryFeatures_[t])}this.featuresCollection_&&this.featuresCollection_.clear(),ol.DEBUG&&console.assert(ol.obj.isEmpty(this.featureChangeKeys_),"featureChangeKeys is an empty object now"),ol.DEBUG&&console.assert(ol.obj.isEmpty(this.idIndex_),"idIndex is an empty object now"),ol.DEBUG&&console.assert(ol.obj.isEmpty(this.undefIdIndex_),"undefIdIndex is an empty object now"),this.featuresRtree_&&this.featuresRtree_.clear(),this.loadedExtentsRtree_.clear(),this.nullGeometryFeatures_={};var r=new ol.source.Vector.Event(ol.source.Vector.EventType.CLEAR);this.dispatchEvent(r),this.changed()},ol.source.Vector.prototype.forEachFeature=function(e,o){return this.featuresRtree_?this.featuresRtree_.forEach(e,o):this.featuresCollection_?this.featuresCollection_.forEach(e,o):void 0},ol.source.Vector.prototype.forEachFeatureAtCoordinateDirect=function(e,o,t){var r=[e[0],e[1],e[0],e[1]];return this.forEachFeatureInExtent(r,function(r){var i=r.getGeometry();return ol.DEBUG&&console.assert(i,"feature geometry is defined and not null"),i.intersectsCoordinate(e)?o.call(t,r):void 0})},ol.source.Vector.prototype.forEachFeatureInExtent=function(e,o,t){return this.featuresRtree_?this.featuresRtree_.forEachInExtent(e,o,t):this.featuresCollection_?this.featuresCollection_.forEach(o,t):void 0},ol.source.Vector.prototype.forEachFeatureIntersectingExtent=function(e,o,t){return this.forEachFeatureInExtent(e,function(r){var i=r.getGeometry();if(ol.DEBUG&&console.assert(i,"feature geometry is defined and not null"),i.intersectsExtent(e)){var n=o.call(t,r);if(n)return n}})},ol.source.Vector.prototype.getFeaturesCollection=function(){return this.featuresCollection_},ol.source.Vector.prototype.getFeatures=function(){var e;return this.featuresCollection_?e=this.featuresCollection_.getArray():this.featuresRtree_&&(e=this.featuresRtree_.getAll(),ol.obj.isEmpty(this.nullGeometryFeatures_)||ol.array.extend(e,ol.obj.getValues(this.nullGeometryFeatures_))),e},ol.source.Vector.prototype.getFeaturesAtCoordinate=function(e){var o=[];return this.forEachFeatureAtCoordinateDirect(e,function(e){o.push(e)}),o},ol.source.Vector.prototype.getFeaturesInExtent=function(e){return ol.DEBUG&&console.assert(this.featuresRtree_,"getFeaturesInExtent does not work when useSpatialIndex is set to false"),this.featuresRtree_.getInExtent(e)},ol.source.Vector.prototype.getClosestFeatureToCoordinate=function(e,o){var t=e[0],r=e[1],i=null,n=[NaN,NaN],l=1/0,a=[-1/0,-1/0,1/0,1/0];ol.DEBUG&&console.assert(this.featuresRtree_,"getClosestFeatureToCoordinate does not work with useSpatialIndex set to false");var s=o||ol.functions.TRUE;return this.featuresRtree_.forEachInExtent(a,function(e){if(s(e)){var o=e.getGeometry();ol.DEBUG&&console.assert(o,"feature geometry is defined and not null");var p=l;if((l=o.closestPointXY(t,r,n,l))<p){i=e;var g=Math.sqrt(l);a[0]=t-g,a[1]=r-g,a[2]=t+g,a[3]=r+g}}}),i},ol.source.Vector.prototype.getExtent=function(){return ol.DEBUG&&console.assert(this.featuresRtree_,"getExtent does not work when useSpatialIndex is set to false"),this.featuresRtree_.getExtent()},ol.source.Vector.prototype.getFeatureById=function(e){var o=this.idIndex_[e.toString()];return void 0!==o?o:null},ol.source.Vector.prototype.getFormat=function(){return this.format_},ol.source.Vector.prototype.getOverlaps=function(){return this.overlaps_},ol.source.Vector.prototype.getUrl=function(){return this.url_},ol.source.Vector.prototype.handleFeatureChange_=function(e){var o=e.target,t=ol.getUid(o).toString(),r=o.getGeometry();if(r){var i=r.getExtent();t in this.nullGeometryFeatures_?(delete this.nullGeometryFeatures_[t],this.featuresRtree_&&this.featuresRtree_.insert(i,o)):this.featuresRtree_&&this.featuresRtree_.update(i,o)}else t in this.nullGeometryFeatures_||(this.featuresRtree_&&this.featuresRtree_.remove(o),this.nullGeometryFeatures_[t]=o);var n,l=o.getId();if(void 0!==l){var a=l.toString();t in this.undefIdIndex_?(delete this.undefIdIndex_[t],this.idIndex_[a]=o):this.idIndex_[a]!==o&&(n=this.removeFromIdIndex_(o),ol.DEBUG&&console.assert(n,"Expected feature to be removed from index"),this.idIndex_[a]=o)}else t in this.undefIdIndex_?ol.DEBUG&&console.assert(this.undefIdIndex_[t]===o,"feature keyed under %s in undefIdKeys",t):(n=this.removeFromIdIndex_(o),ol.DEBUG&&console.assert(n,"Expected feature to be removed from index"),this.undefIdIndex_[t]=o);this.changed(),this.dispatchEvent(new ol.source.Vector.Event(ol.source.Vector.EventType.CHANGEFEATURE,o))},ol.source.Vector.prototype.isEmpty=function(){return this.featuresRtree_.isEmpty()&&ol.obj.isEmpty(this.nullGeometryFeatures_)},ol.source.Vector.prototype.loadFeatures=function(e,o,t){var r,i,n=this.loadedExtentsRtree_,l=this.strategy_(e,o);for(r=0,i=l.length;r<i;++r){var a=l[r];n.forEachInExtent(a,function(e){return ol.extent.containsExtent(e.extent,a)})||(this.loader_.call(this,a,o,t),n.insert(a,{extent:a.slice()}))}},ol.source.Vector.prototype.removeFeature=function(e){var o=ol.getUid(e).toString();o in this.nullGeometryFeatures_?delete this.nullGeometryFeatures_[o]:this.featuresRtree_&&this.featuresRtree_.remove(e),this.removeFeatureInternal(e),this.changed()},ol.source.Vector.prototype.removeFeatureInternal=function(e){var o=ol.getUid(e).toString();ol.DEBUG&&console.assert(o in this.featureChangeKeys_,"featureKey exists in featureChangeKeys"),this.featureChangeKeys_[o].forEach(ol.events.unlistenByKey),delete this.featureChangeKeys_[o];var t=e.getId();void 0!==t?delete this.idIndex_[t.toString()]:delete this.undefIdIndex_[o],this.dispatchEvent(new ol.source.Vector.Event(ol.source.Vector.EventType.REMOVEFEATURE,e))},ol.source.Vector.prototype.removeFromIdIndex_=function(e){var o=!1;for(var t in this.idIndex_)if(this.idIndex_[t]===e){delete this.idIndex_[t],o=!0;break}return o},ol.source.Vector.Event=function(e,o){ol.events.Event.call(this,e),this.feature=o},ol.inherits(ol.source.Vector.Event,ol.events.Event),ol.source.Vector.EventType={ADDFEATURE:"addfeature",CHANGEFEATURE:"changefeature",CLEAR:"clear",REMOVEFEATURE:"removefeature"},goog.provide("ol.interaction.Draw"),goog.require("ol"),goog.require("ol.events"),goog.require("ol.extent"),goog.require("ol.events.Event"),goog.require("ol.Feature"),goog.require("ol.MapBrowserEvent"),goog.require("ol.Object"),goog.require("ol.coordinate"),goog.require("ol.functions"),goog.require("ol.events.condition"),goog.require("ol.geom.Circle"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.LineString"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.MultiPoint"),goog.require("ol.geom.MultiPolygon"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.interaction.Interaction"),goog.require("ol.interaction.Pointer"),goog.require("ol.layer.Vector"),goog.require("ol.source.Vector"),goog.require("ol.style.Style"),ol.interaction.Draw=function(e){ol.interaction.Pointer.call(this,{handleDownEvent:ol.interaction.Draw.handleDownEvent_,handleEvent:ol.interaction.Draw.handleEvent,handleUpEvent:ol.interaction.Draw.handleUpEvent_}),this.downPx_=null,this.freehand_=!1,this.source_=e.source?e.source:null,this.features_=e.features?e.features:null,this.snapTolerance_=e.snapTolerance?e.snapTolerance:12,this.type_=e.type,this.mode_=ol.interaction.Draw.getMode_(this.type_),this.minPoints_=e.minPoints?e.minPoints:this.mode_===ol.interaction.Draw.Mode.POLYGON?3:2,this.maxPoints_=e.maxPoints?e.maxPoints:1/0,this.finishCondition_=e.finishCondition?e.finishCondition:ol.functions.TRUE;var o=e.geometryFunction;if(!o)if(this.type_===ol.geom.GeometryType.CIRCLE)o=function(e,o){var t=o||new ol.geom.Circle([NaN,NaN]),r=ol.coordinate.squaredDistance(e[0],e[1]);return t.setCenterAndRadius(e[0],Math.sqrt(r)),t};else{var t,r=this.mode_;r===ol.interaction.Draw.Mode.POINT?t=ol.geom.Point:r===ol.interaction.Draw.Mode.LINE_STRING?t=ol.geom.LineString:r===ol.interaction.Draw.Mode.POLYGON&&(t=ol.geom.Polygon),o=function(e,o){var i=o;return i?r===ol.interaction.Draw.Mode.POLYGON?i.setCoordinates([e[0].concat([e[0][0]])]):i.setCoordinates(e):i=new t(e),i}}this.geometryFunction_=o,this.finishCoordinate_=null,this.sketchFeature_=null,this.sketchPoint_=null,this.sketchCoords_=null,this.sketchLine_=null,this.sketchLineCoords_=null,this.squaredClickTolerance_=e.clickTolerance?e.clickTolerance*e.clickTolerance:36,this.overlay_=new ol.layer.Vector({source:new ol.source.Vector({useSpatialIndex:!1,wrapX:!!e.wrapX&&e.wrapX}),style:e.style?e.style:ol.interaction.Draw.getDefaultStyleFunction()}),this.geometryName_=e.geometryName,this.condition_=e.condition?e.condition:ol.events.condition.noModifierKeys,this.freehandCondition_,e.freehand?this.freehandCondition_=ol.events.condition.always:this.freehandCondition_=e.freehandCondition?e.freehandCondition:ol.events.condition.shiftKeyOnly,ol.events.listen(this,ol.Object.getChangeEventType(ol.interaction.Interaction.Property.ACTIVE),this.updateState_,this)},ol.inherits(ol.interaction.Draw,ol.interaction.Pointer),ol.interaction.Draw.getDefaultStyleFunction=function(){var e=ol.style.Style.createDefaultEditing();return function(o,t){return e[o.getGeometry().getType()]}},ol.interaction.Draw.prototype.setMap=function(e){ol.interaction.Pointer.prototype.setMap.call(this,e),this.updateState_()},ol.interaction.Draw.handleEvent=function(e){this.freehand_=this.mode_!==ol.interaction.Draw.Mode.POINT&&this.freehandCondition_(e);var o=!this.freehand_;return this.freehand_&&e.type===ol.MapBrowserEvent.EventType.POINTERDRAG&&null!==this.sketchFeature_?(this.addToDrawing_(e),o=!1):e.type===ol.MapBrowserEvent.EventType.POINTERMOVE?o=this.handlePointerMove_(e):e.type===ol.MapBrowserEvent.EventType.DBLCLICK&&(o=!1),ol.interaction.Pointer.handleEvent.call(this,e)&&o},ol.interaction.Draw.handleDownEvent_=function(e){return this.freehand_?(this.downPx_=e.pixel,this.finishCoordinate_||this.startDrawing_(e),!0):!!this.condition_(e)&&(this.downPx_=e.pixel,!0)},ol.interaction.Draw.handleUpEvent_=function(e){var o=this.downPx_,t=e.pixel,r=o[0]-t[0],i=o[1]-t[1],n=r*r+i*i,l=!0,a=this.freehand_?n>this.squaredClickTolerance_:n<=this.squaredClickTolerance_,s=this.mode_===ol.interaction.Draw.Mode.CIRCLE;return a?(this.handlePointerMove_(e),this.finishCoordinate_?this.freehand_||s?this.finishDrawing():this.atFinish_(e)?this.finishCondition_(e)&&this.finishDrawing():this.addToDrawing_(e):(this.startDrawing_(e),this.mode_===ol.interaction.Draw.Mode.POINT&&this.finishDrawing()),l=!1):s&&(this.finishCoordinate_=null),l},ol.interaction.Draw.prototype.handlePointerMove_=function(e){return this.finishCoordinate_?this.modifyDrawing_(e):this.createOrUpdateSketchPoint_(e),!0},ol.interaction.Draw.prototype.atFinish_=function(e){var o=!1;if(this.sketchFeature_){var t=!1,r=[this.finishCoordinate_];if(this.mode_===ol.interaction.Draw.Mode.LINE_STRING?t=this.sketchCoords_.length>this.minPoints_:this.mode_===ol.interaction.Draw.Mode.POLYGON&&(t=this.sketchCoords_[0].length>this.minPoints_,r=[this.sketchCoords_[0][0],this.sketchCoords_[0][this.sketchCoords_[0].length-2]]),t)for(var i=e.map,n=0,l=r.length;n<l;n++){var a=r[n],s=i.getPixelFromCoordinate(a),p=e.pixel,g=p[0]-s[0],c=p[1]-s[1],u=this.freehand_?1:this.snapTolerance_;if(o=Math.sqrt(g*g+c*c)<=u){this.finishCoordinate_=a;break}}}return o},ol.interaction.Draw.prototype.createOrUpdateSketchPoint_=function(e){var o=e.coordinate.slice();if(this.sketchPoint_){this.sketchPoint_.getGeometry().setCoordinates(o)}else this.sketchPoint_=new ol.Feature(new ol.geom.Point(o)),this.updateSketchFeatures_()},ol.interaction.Draw.prototype.startDrawing_=function(e){var o=e.coordinate;this.finishCoordinate_=o,this.mode_===ol.interaction.Draw.Mode.POINT?this.sketchCoords_=o.slice():this.mode_===ol.interaction.Draw.Mode.POLYGON?(this.sketchCoords_=[[o.slice(),o.slice()]],this.sketchLineCoords_=this.sketchCoords_[0]):(this.sketchCoords_=[o.slice(),o.slice()],this.mode_===ol.interaction.Draw.Mode.CIRCLE&&(this.sketchLineCoords_=this.sketchCoords_)),this.sketchLineCoords_&&(this.sketchLine_=new ol.Feature(new ol.geom.LineString(this.sketchLineCoords_)));var t=this.geometryFunction_(this.sketchCoords_);ol.DEBUG&&console.assert(void 0!==t,"geometry should be defined"),
this.sketchFeature_=new ol.Feature,this.geometryName_&&this.sketchFeature_.setGeometryName(this.geometryName_),this.sketchFeature_.setGeometry(t),this.updateSketchFeatures_(),this.dispatchEvent(new ol.interaction.Draw.Event(ol.interaction.Draw.EventType.DRAWSTART,this.sketchFeature_))},ol.interaction.Draw.prototype.modifyDrawing_=function(e){var o,t,r=e.coordinate,i=this.sketchFeature_.getGeometry();if(this.mode_===ol.interaction.Draw.Mode.POINT?t=this.sketchCoords_:this.mode_===ol.interaction.Draw.Mode.POLYGON?(o=this.sketchCoords_[0],t=o[o.length-1],this.atFinish_(e)&&(r=this.finishCoordinate_.slice())):(o=this.sketchCoords_,t=o[o.length-1]),t[0]=r[0],t[1]=r[1],ol.DEBUG&&console.assert(this.sketchCoords_,"sketchCoords_ expected"),this.geometryFunction_(this.sketchCoords_,i),this.sketchPoint_){this.sketchPoint_.getGeometry().setCoordinates(r)}var n;if(i instanceof ol.geom.Polygon&&this.mode_!==ol.interaction.Draw.Mode.POLYGON){this.sketchLine_||(this.sketchLine_=new ol.Feature(new ol.geom.LineString(null)));var l=i.getLinearRing(0);n=this.sketchLine_.getGeometry(),n.setFlatCoordinates(l.getLayout(),l.getFlatCoordinates())}else this.sketchLineCoords_&&(n=this.sketchLine_.getGeometry(),n.setCoordinates(this.sketchLineCoords_));this.updateSketchFeatures_()},ol.interaction.Draw.prototype.addToDrawing_=function(e){var o,t,r=e.coordinate,i=this.sketchFeature_.getGeometry();this.mode_===ol.interaction.Draw.Mode.LINE_STRING?(this.finishCoordinate_=r.slice(),t=this.sketchCoords_,t.length>=this.maxPoints_&&(this.freehand_?t.pop():o=!0),t.push(r.slice()),this.geometryFunction_(t,i)):this.mode_===ol.interaction.Draw.Mode.POLYGON&&(t=this.sketchCoords_[0],t.length>=this.maxPoints_&&(this.freehand_?t.pop():o=!0),t.push(r.slice()),o&&(this.finishCoordinate_=t[0]),this.geometryFunction_(this.sketchCoords_,i)),this.updateSketchFeatures_(),o&&this.finishDrawing()},ol.interaction.Draw.prototype.removeLastPoint=function(){var e,o,t=this.sketchFeature_.getGeometry();this.mode_===ol.interaction.Draw.Mode.LINE_STRING?(e=this.sketchCoords_,e.splice(-2,1),this.geometryFunction_(e,t)):this.mode_===ol.interaction.Draw.Mode.POLYGON&&(e=this.sketchCoords_[0],e.splice(-2,1),o=this.sketchLine_.getGeometry(),o.setCoordinates(e),this.geometryFunction_(this.sketchCoords_,t)),0===e.length&&(this.finishCoordinate_=null),this.updateSketchFeatures_()},ol.interaction.Draw.prototype.finishDrawing=function(){var e=this.abortDrawing_(),o=this.sketchCoords_,t=e.getGeometry();this.mode_===ol.interaction.Draw.Mode.LINE_STRING?(o.pop(),this.geometryFunction_(o,t)):this.mode_===ol.interaction.Draw.Mode.POLYGON&&(o[0].pop(),this.geometryFunction_(o,t),o=t.getCoordinates()),this.type_===ol.geom.GeometryType.MULTI_POINT?e.setGeometry(new ol.geom.MultiPoint([o])):this.type_===ol.geom.GeometryType.MULTI_LINE_STRING?e.setGeometry(new ol.geom.MultiLineString([o])):this.type_===ol.geom.GeometryType.MULTI_POLYGON&&e.setGeometry(new ol.geom.MultiPolygon([o])),this.dispatchEvent(new ol.interaction.Draw.Event(ol.interaction.Draw.EventType.DRAWEND,e)),this.features_&&this.features_.push(e),this.source_&&this.source_.addFeature(e)},ol.interaction.Draw.prototype.abortDrawing_=function(){this.finishCoordinate_=null;var e=this.sketchFeature_;return e&&(this.sketchFeature_=null,this.sketchPoint_=null,this.sketchLine_=null,this.overlay_.getSource().clear(!0)),e},ol.interaction.Draw.prototype.extend=function(e){var o=e.getGeometry();ol.DEBUG&&console.assert(this.mode_==ol.interaction.Draw.Mode.LINE_STRING,'interaction mode must be "line"'),ol.DEBUG&&console.assert(o.getType()==ol.geom.GeometryType.LINE_STRING,"feature geometry must be a line string");var t=o;this.sketchFeature_=e,this.sketchCoords_=t.getCoordinates();var r=this.sketchCoords_[this.sketchCoords_.length-1];this.finishCoordinate_=r.slice(),this.sketchCoords_.push(r.slice()),this.updateSketchFeatures_(),this.dispatchEvent(new ol.interaction.Draw.Event(ol.interaction.Draw.EventType.DRAWSTART,this.sketchFeature_))},ol.interaction.Draw.prototype.shouldStopEvent=ol.functions.FALSE,ol.interaction.Draw.prototype.updateSketchFeatures_=function(){var e=[];this.sketchFeature_&&e.push(this.sketchFeature_),this.sketchLine_&&e.push(this.sketchLine_),this.sketchPoint_&&e.push(this.sketchPoint_);var o=this.overlay_.getSource();o.clear(!0),o.addFeatures(e)},ol.interaction.Draw.prototype.updateState_=function(){var e=this.getMap(),o=this.getActive();e&&o||this.abortDrawing_(),this.overlay_.setMap(o?e:null)},ol.interaction.Draw.createRegularPolygon=function(e,o){return function(t,r){var i=t[0],n=t[1],l=Math.sqrt(ol.coordinate.squaredDistance(i,n)),a=r||ol.geom.Polygon.fromCircle(new ol.geom.Circle(i),e),s=o||Math.atan((n[1]-i[1])/(n[0]-i[0]));return ol.geom.Polygon.makeRegular(a,i,l,s),a}},ol.interaction.Draw.createBox=function(){return function(e,o){var t=ol.extent.boundingExtent(e),r=o||new ol.geom.Polygon(null);return r.setCoordinates([[ol.extent.getBottomLeft(t),ol.extent.getBottomRight(t),ol.extent.getTopRight(t),ol.extent.getTopLeft(t),ol.extent.getBottomLeft(t)]]),r}},ol.interaction.Draw.getMode_=function(e){var o;return e===ol.geom.GeometryType.POINT||e===ol.geom.GeometryType.MULTI_POINT?o=ol.interaction.Draw.Mode.POINT:e===ol.geom.GeometryType.LINE_STRING||e===ol.geom.GeometryType.MULTI_LINE_STRING?o=ol.interaction.Draw.Mode.LINE_STRING:e===ol.geom.GeometryType.POLYGON||e===ol.geom.GeometryType.MULTI_POLYGON?o=ol.interaction.Draw.Mode.POLYGON:e===ol.geom.GeometryType.CIRCLE&&(o=ol.interaction.Draw.Mode.CIRCLE),o},ol.interaction.Draw.Mode={POINT:"Point",LINE_STRING:"LineString",POLYGON:"Polygon",CIRCLE:"Circle"},ol.interaction.Draw.Event=function(e,o){ol.events.Event.call(this,e),this.feature=o},ol.inherits(ol.interaction.Draw.Event,ol.events.Event),ol.interaction.Draw.EventType={DRAWSTART:"drawstart",DRAWEND:"drawend"},goog.provide("ol.interaction.Extent"),goog.require("ol"),goog.require("ol.Feature");goog.require("ol.MapBrowserEvent"),goog.require("ol.MapBrowserPointerEvent"),goog.require("ol.coordinate"),goog.require("ol.events.Event"),goog.require("ol.extent"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.interaction.Pointer"),goog.require("ol.layer.Vector"),goog.require("ol.source.Vector"),goog.require("ol.style.Style"),ol.interaction.Extent=function(e){this.extent_=null,this.pointerHandler_=null,this.pixelTolerance_=10,this.snappedToVertex_=!1,this.extentFeature_=null,this.vertexFeature_=null,e||(e={}),e.extent&&this.setExtent(e.extent),ol.interaction.Pointer.call(this,{handleDownEvent:ol.interaction.Extent.handleDownEvent_,handleDragEvent:ol.interaction.Extent.handleDragEvent_,handleEvent:ol.interaction.Extent.handleEvent_,handleUpEvent:ol.interaction.Extent.handleUpEvent_}),this.extentOverlay_=new ol.layer.Vector({source:new ol.source.Vector({useSpatialIndex:!1,wrapX:!!e.wrapX}),style:e.boxStyle?e.boxStyle:ol.interaction.Extent.getDefaultExtentStyleFunction_(),updateWhileAnimating:!0,updateWhileInteracting:!0}),this.vertexOverlay_=new ol.layer.Vector({source:new ol.source.Vector({useSpatialIndex:!1,wrapX:!!e.wrapX}),style:e.pointerStyle?e.pointerStyle:ol.interaction.Extent.getDefaultPointerStyleFunction_(),updateWhileAnimating:!0,updateWhileInteracting:!0})},ol.inherits(ol.interaction.Extent,ol.interaction.Pointer),ol.interaction.Extent.handleEvent_=function(e){return!(e instanceof ol.MapBrowserPointerEvent)||(e.type!=ol.MapBrowserEvent.EventType.POINTERMOVE||this.handlingDownUpSequence||this.handlePointerMove_(e),ol.interaction.Pointer.handleEvent.call(this,e),!1)},ol.interaction.Extent.handleDownEvent_=function(e){var o=e.pixel,t=e.map,r=this.getExtent(),i=this.snapToVertex_(o,t),n=function(e){var o=null,t=null;return e[0]==r[0]?o=r[2]:e[0]==r[2]&&(o=r[0]),e[1]==r[1]?t=r[3]:e[1]==r[3]&&(t=r[1]),null!==o&&null!==t?[o,t]:null};if(i&&r){var l=i[0]==r[0]||i[0]==r[2]?i[0]:null,a=i[1]==r[1]||i[1]==r[3]?i[1]:null;null!==l&&null!==a?this.pointerHandler_=ol.interaction.Extent.getPointHandler_(n(i)):null!==l?this.pointerHandler_=ol.interaction.Extent.getEdgeHandler_(n([l,r[1]]),n([l,r[3]])):null!==a&&(this.pointerHandler_=ol.interaction.Extent.getEdgeHandler_(n([r[0],a]),n([r[2],a])))}else i=t.getCoordinateFromPixel(o),this.setExtent([i[0],i[1],i[0],i[1]]),this.pointerHandler_=ol.interaction.Extent.getPointHandler_(i);return!0},ol.interaction.Extent.handleDragEvent_=function(e){if(this.pointerHandler_){var o=e.coordinate;this.setExtent(this.pointerHandler_(o)),this.createOrUpdatePointerFeature_(o)}return!0},ol.interaction.Extent.handleUpEvent_=function(e){this.pointerHandler_=null;var o=this.getExtent();return o&&0!==ol.extent.getArea(o)||this.setExtent(null),!1},ol.interaction.Extent.getDefaultExtentStyleFunction_=function(){var e=ol.style.Style.createDefaultEditing();return function(o,t){return e[ol.geom.GeometryType.POLYGON]}},ol.interaction.Extent.getDefaultPointerStyleFunction_=function(){var e=ol.style.Style.createDefaultEditing();return function(o,t){return e[ol.geom.GeometryType.POINT]}},ol.interaction.Extent.getPointHandler_=function(e){return function(o){return ol.extent.boundingExtent([e,o])}},ol.interaction.Extent.getEdgeHandler_=function(e,o){return e[0]==o[0]?function(t){return ol.extent.boundingExtent([e,[t[0],o[1]]])}:e[1]==o[1]?function(t){return ol.extent.boundingExtent([e,[o[0],t[1]]])}:null},ol.interaction.Extent.getSegments_=function(e){return[[[e[0],e[1]],[e[0],e[3]]],[[e[0],e[3]],[e[2],e[3]]],[[e[2],e[3]],[e[2],e[1]]],[[e[2],e[1]],[e[0],e[1]]]]},ol.interaction.Extent.prototype.snapToVertex_=function(e,o){var t=o.getCoordinateFromPixel(e),r=function(e,o){return ol.coordinate.squaredDistanceToSegment(t,e)-ol.coordinate.squaredDistanceToSegment(t,o)},i=this.getExtent();if(i){var n=ol.interaction.Extent.getSegments_(i);n.sort(r);var l=n[0],a=ol.coordinate.closestOnSegment(t,l),s=o.getPixelFromCoordinate(a);if(Math.sqrt(ol.coordinate.squaredDistance(e,s))<=this.pixelTolerance_){var p=o.getPixelFromCoordinate(l[0]),g=o.getPixelFromCoordinate(l[1]),c=ol.coordinate.squaredDistance(s,p),u=ol.coordinate.squaredDistance(s,g),y=Math.sqrt(Math.min(c,u));return this.snappedToVertex_=y<=this.pixelTolerance_,this.snappedToVertex_&&(a=c>u?l[1]:l[0]),a}}return null},ol.interaction.Extent.prototype.handlePointerMove_=function(e){var o=e.pixel,t=e.map,r=this.snapToVertex_(o,t);r||(r=t.getCoordinateFromPixel(o)),this.createOrUpdatePointerFeature_(r)},ol.interaction.Extent.prototype.createOrUpdateExtentFeature_=function(e){var o=this.extentFeature_;return o?e?o.setGeometry(ol.geom.Polygon.fromExtent(e)):o.setGeometry(void 0):(o=e?new ol.Feature(ol.geom.Polygon.fromExtent(e)):new ol.Feature({}),this.extentFeature_=o,this.extentOverlay_.getSource().addFeature(o)),o},ol.interaction.Extent.prototype.createOrUpdatePointerFeature_=function(e){var o=this.vertexFeature_;if(o){o.getGeometry().setCoordinates(e)}else o=new ol.Feature(new ol.geom.Point(e)),this.vertexFeature_=o,this.vertexOverlay_.getSource().addFeature(o);return o},ol.interaction.Extent.prototype.setMap=function(e){this.extentOverlay_.setMap(e),this.vertexOverlay_.setMap(e),ol.interaction.Pointer.prototype.setMap.call(this,e)},ol.interaction.Extent.prototype.getExtent=function(){return this.extent_},ol.interaction.Extent.prototype.setExtent=function(e){this.extent_=e||null,this.createOrUpdateExtentFeature_(e),this.dispatchEvent(new ol.interaction.Extent.Event(this.extent_))},ol.interaction.Extent.Event=function(e){ol.events.Event.call(this,ol.interaction.Extent.EventType.EXTENTCHANGED),this.extent_=e},ol.inherits(ol.interaction.Extent.Event,ol.events.Event),ol.interaction.Extent.EventType={EXTENTCHANGED:"extentchanged"},goog.provide("ol.interaction.Modify"),goog.require("ol"),goog.require("ol.Collection"),goog.require("ol.Feature"),goog.require("ol.MapBrowserEvent"),goog.require("ol.MapBrowserPointerEvent"),goog.require("ol.View"),goog.require("ol.array"),goog.require("ol.coordinate"),goog.require("ol.events"),goog.require("ol.events.Event"),goog.require("ol.events.EventType"),goog.require("ol.events.condition"),goog.require("ol.extent"),goog.require("ol.geom.GeometryType"),goog.require("ol.geom.Point"),goog.require("ol.interaction.Pointer"),goog.require("ol.layer.Vector"),goog.require("ol.source.Vector"),goog.require("ol.structs.RBush"),goog.require("ol.style.Style"),ol.interaction.Modify=function(e){ol.interaction.Pointer.call(this,{handleDownEvent:ol.interaction.Modify.handleDownEvent_,handleDragEvent:ol.interaction.Modify.handleDragEvent_,handleEvent:ol.interaction.Modify.handleEvent,handleUpEvent:ol.interaction.Modify.handleUpEvent_}),this.condition_=e.condition?e.condition:ol.events.condition.primaryAction,this.defaultDeleteCondition_=function(e){return ol.events.condition.noModifierKeys(e)&&ol.events.condition.singleClick(e)},this.deleteCondition_=e.deleteCondition?e.deleteCondition:this.defaultDeleteCondition_,this.vertexFeature_=null,this.vertexSegments_=null,this.lastPixel_=[0,0],this.ignoreNextSingleClick_=!1,this.modified_=!1,this.rBush_=new ol.structs.RBush,this.pixelTolerance_=void 0!==e.pixelTolerance?e.pixelTolerance:10,this.snappedToVertex_=!1,this.changingFeature_=!1,this.dragSegments_=[],this.overlay_=new ol.layer.Vector({source:new ol.source.Vector({useSpatialIndex:!1,wrapX:!!e.wrapX}),style:e.style?e.style:ol.interaction.Modify.getDefaultStyleFunction(),updateWhileAnimating:!0,updateWhileInteracting:!0}),this.SEGMENT_WRITERS_={Point:this.writePointGeometry_,LineString:this.writeLineStringGeometry_,LinearRing:this.writeLineStringGeometry_,Polygon:this.writePolygonGeometry_,MultiPoint:this.writeMultiPointGeometry_,MultiLineString:this.writeMultiLineStringGeometry_,MultiPolygon:this.writeMultiPolygonGeometry_,GeometryCollection:this.writeGeometryCollectionGeometry_},this.features_=e.features,this.features_.forEach(this.addFeature_,this),ol.events.listen(this.features_,ol.Collection.EventType.ADD,this.handleFeatureAdd_,this),ol.events.listen(this.features_,ol.Collection.EventType.REMOVE,this.handleFeatureRemove_,this),this.lastPointerEvent_=null},ol.inherits(ol.interaction.Modify,ol.interaction.Pointer),ol.interaction.Modify.prototype.addFeature_=function(e){var o=e.getGeometry();o&&o.getType()in this.SEGMENT_WRITERS_&&this.SEGMENT_WRITERS_[o.getType()].call(this,e,o);var t=this.getMap();t&&t.isRendered()&&this.handlePointerAtPixel_(this.lastPixel_,t),ol.events.listen(e,ol.events.EventType.CHANGE,this.handleFeatureChange_,this)},ol.interaction.Modify.prototype.willModifyFeatures_=function(e){this.modified_||(this.modified_=!0,this.dispatchEvent(new ol.interaction.Modify.Event(ol.interaction.Modify.EventType.MODIFYSTART,this.features_,e)))},ol.interaction.Modify.prototype.removeFeature_=function(e){this.removeFeatureSegmentData_(e),this.vertexFeature_&&0===this.features_.getLength()&&(this.overlay_.getSource().removeFeature(this.vertexFeature_),this.vertexFeature_=null),ol.events.unlisten(e,ol.events.EventType.CHANGE,this.handleFeatureChange_,this)},ol.interaction.Modify.prototype.removeFeatureSegmentData_=function(e){var o=this.rBush_,t=[];o.forEach(function(o){e===o.feature&&t.push(o)});for(var r=t.length-1;r>=0;--r)o.remove(t[r])},ol.interaction.Modify.prototype.setActive=function(e){this.vertexFeature_&&!e&&(this.overlay_.getSource().removeFeature(this.vertexFeature_),this.vertexFeature_=null),ol.interaction.Pointer.prototype.setActive.call(this,e)},ol.interaction.Modify.prototype.setMap=function(e){this.overlay_.setMap(e),ol.interaction.Pointer.prototype.setMap.call(this,e)},ol.interaction.Modify.prototype.handleFeatureAdd_=function(e){this.addFeature_(e.element)},ol.interaction.Modify.prototype.handleFeatureChange_=function(e){if(!this.changingFeature_){var o=e.target;this.removeFeature_(o),this.addFeature_(o)}},ol.interaction.Modify.prototype.handleFeatureRemove_=function(e){var o=e.element;this.removeFeature_(o)},ol.interaction.Modify.prototype.writePointGeometry_=function(e,o){var t=o.getCoordinates(),r={feature:e,geometry:o,segment:[t,t]};this.rBush_.insert(o.getExtent(),r)},ol.interaction.Modify.prototype.writeMultiPointGeometry_=function(e,o){var t,r,i,n,l=o.getCoordinates();for(r=0,i=l.length;r<i;++r)t=l[r],n={feature:e,geometry:o,depth:[r],index:r,segment:[t,t]},this.rBush_.insert(o.getExtent(),n)},ol.interaction.Modify.prototype.writeLineStringGeometry_=function(e,o){var t,r,i,n,l=o.getCoordinates();for(t=0,r=l.length-1;t<r;++t)i=l.slice(t,t+2),n={feature:e,geometry:o,index:t,segment:i},this.rBush_.insert(ol.extent.boundingExtent(i),n)},ol.interaction.Modify.prototype.writeMultiLineStringGeometry_=function(e,o){var t,r,i,n,l,a,s,p=o.getCoordinates();for(n=0,l=p.length;n<l;++n)for(t=p[n],r=0,i=t.length-1;r<i;++r)a=t.slice(r,r+2),s={feature:e,geometry:o,depth:[n],index:r,segment:a},this.rBush_.insert(ol.extent.boundingExtent(a),s)},ol.interaction.Modify.prototype.writePolygonGeometry_=function(e,o){var t,r,i,n,l,a,s,p=o.getCoordinates();for(n=0,l=p.length;n<l;++n)for(t=p[n],r=0,i=t.length-1;r<i;++r)a=t.slice(r,r+2),s={feature:e,geometry:o,depth:[n],index:r,segment:a},this.rBush_.insert(ol.extent.boundingExtent(a),s)},ol.interaction.Modify.prototype.writeMultiPolygonGeometry_=function(e,o){var t,r,i,n,l,a,s,p,g,c,u=o.getCoordinates();for(a=0,s=u.length;a<s;++a)for(p=u[a],n=0,l=p.length;n<l;++n)for(t=p[n],r=0,i=t.length-1;r<i;++r)g=t.slice(r,r+2),c={feature:e,geometry:o,depth:[n,a],index:r,segment:g},this.rBush_.insert(ol.extent.boundingExtent(g),c)},ol.interaction.Modify.prototype.writeGeometryCollectionGeometry_=function(e,o){var t,r=o.getGeometriesArray();for(t=0;t<r.length;++t)this.SEGMENT_WRITERS_[r[t].getType()].call(this,e,r[t])},ol.interaction.Modify.prototype.createOrUpdateVertexFeature_=function(e){var o=this.vertexFeature_;if(o){o.getGeometry().setCoordinates(e)}else o=new ol.Feature(new ol.geom.Point(e)),this.vertexFeature_=o,this.overlay_.getSource().addFeature(o);return o},ol.interaction.Modify.compareIndexes_=function(e,o){return e.index-o.index},ol.interaction.Modify.handleDownEvent_=function(e){if(!this.condition_(e))return!1;this.handlePointerAtPixel_(e.pixel,e.map),this.dragSegments_.length=0,this.modified_=!1;var o=this.vertexFeature_;if(o){var t=[],r=o.getGeometry(),i=r.getCoordinates(),n=ol.extent.boundingExtent([i]),l=this.rBush_.getInExtent(n),a={};l.sort(ol.interaction.Modify.compareIndexes_);for(var s=0,p=l.length;s<p;++s){var g=l[s],c=g.segment,u=ol.getUid(g.feature),y=g.depth;if(y&&(u+="-"+y.join("-")),a[u]||(a[u]=new Array(2)),ol.coordinate.equals(c[0],i)&&!a[u][0])this.dragSegments_.push([g,0]),a[u][0]=g;else if(ol.coordinate.equals(c[1],i)&&!a[u][1]){if((g.geometry.getType()===ol.geom.GeometryType.LINE_STRING||g.geometry.getType()===ol.geom.GeometryType.MULTI_LINE_STRING)&&a[u][0]&&0===a[u][0].index)continue;this.dragSegments_.push([g,1]),a[u][1]=g}else ol.getUid(c)in this.vertexSegments_&&!a[u][0]&&!a[u][1]&&t.push([g,i])}t.length&&this.willModifyFeatures_(e);for(var d=t.length-1;d>=0;--d)this.insertVertex_.apply(this,t[d])}return!!this.vertexFeature_},ol.interaction.Modify.handleDragEvent_=function(e){this.ignoreNextSingleClick_=!1,this.willModifyFeatures_(e);for(var o=e.coordinate,t=0,r=this.dragSegments_.length;t<r;++t){for(var i=this.dragSegments_[t],n=i[0],l=n.depth,a=n.geometry,s=a.getCoordinates(),p=n.segment,g=i[1];o.length<a.getStride();)o.push(p[g][o.length]);switch(a.getType()){case ol.geom.GeometryType.POINT:s=o,p[0]=p[1]=o;break;case ol.geom.GeometryType.MULTI_POINT:s[n.index]=o,p[0]=p[1]=o;break;case ol.geom.GeometryType.LINE_STRING:s[n.index+g]=o,p[g]=o;break;case ol.geom.GeometryType.MULTI_LINE_STRING:case ol.geom.GeometryType.POLYGON:s[l[0]][n.index+g]=o,p[g]=o;break;case ol.geom.GeometryType.MULTI_POLYGON:s[l[1]][l[0]][n.index+g]=o,p[g]=o}this.setGeometryCoordinates_(a,s)}this.createOrUpdateVertexFeature_(o)},ol.interaction.Modify.handleUpEvent_=function(e){for(var o,t=this.dragSegments_.length-1;t>=0;--t)o=this.dragSegments_[t][0],this.rBush_.update(ol.extent.boundingExtent(o.segment),o);return this.modified_&&(this.dispatchEvent(new ol.interaction.Modify.Event(ol.interaction.Modify.EventType.MODIFYEND,this.features_,e)),this.modified_=!1),!1},ol.interaction.Modify.handleEvent=function(e){if(!(e instanceof ol.MapBrowserPointerEvent))return!0;this.lastPointerEvent_=e;var o;return e.map.getView().getHints()[ol.View.Hint.INTERACTING]||e.type!=ol.MapBrowserEvent.EventType.POINTERMOVE||this.handlingDownUpSequence||this.handlePointerMove_(e),this.vertexFeature_&&this.deleteCondition_(e)&&(o=!(e.type!=ol.MapBrowserEvent.EventType.SINGLECLICK||!this.ignoreNextSingleClick_)||this.removePoint()),e.type==ol.MapBrowserEvent.EventType.SINGLECLICK&&(this.ignoreNextSingleClick_=!1),ol.interaction.Pointer.handleEvent.call(this,e)&&!o},ol.interaction.Modify.prototype.handlePointerMove_=function(e){this.lastPixel_=e.pixel,this.handlePointerAtPixel_(e.pixel,e.map)},ol.interaction.Modify.prototype.handlePointerAtPixel_=function(e,o){var t=o.getCoordinateFromPixel(e),r=function(e,o){return ol.coordinate.squaredDistanceToSegment(t,e.segment)-ol.coordinate.squaredDistanceToSegment(t,o.segment)},i=ol.extent.buffer(ol.extent.createOrUpdateFromCoordinate(t),o.getView().getResolution()*this.pixelTolerance_),n=this.rBush_,l=n.getInExtent(i);if(l.length>0){l.sort(r);var a=l[0],s=a.segment,p=ol.coordinate.closestOnSegment(t,s),g=o.getPixelFromCoordinate(p);if(Math.sqrt(ol.coordinate.squaredDistance(e,g))<=this.pixelTolerance_){var c=o.getPixelFromCoordinate(s[0]),u=o.getPixelFromCoordinate(s[1]),y=ol.coordinate.squaredDistance(g,c),d=ol.coordinate.squaredDistance(g,u),h=Math.sqrt(Math.min(y,d));this.snappedToVertex_=h<=this.pixelTolerance_,this.snappedToVertex_&&(p=y>d?s[1]:s[0]),this.createOrUpdateVertexFeature_(p);var m={};m[ol.getUid(s)]=!0;for(var f,_=1,E=l.length;_<E&&(f=l[_].segment,ol.coordinate.equals(s[0],f[0])&&ol.coordinate.equals(s[1],f[1])||ol.coordinate.equals(s[0],f[1])&&ol.coordinate.equals(s[1],f[0]));++_)m[ol.getUid(f)]=!0;return void(this.vertexSegments_=m)}}this.vertexFeature_&&(this.overlay_.getSource().removeFeature(this.vertexFeature_),this.vertexFeature_=null)},ol.interaction.Modify.prototype.insertVertex_=function(e,o){for(var t,r=e.segment,i=e.feature,n=e.geometry,l=e.depth,a=e.index;o.length<n.getStride();)o.push(0);switch(n.getType()){case ol.geom.GeometryType.MULTI_LINE_STRING:case ol.geom.GeometryType.POLYGON:t=n.getCoordinates(),t[l[0]].splice(a+1,0,o);break;case ol.geom.GeometryType.MULTI_POLYGON:t=n.getCoordinates(),t[l[1]][l[0]].splice(a+1,0,o);break;case ol.geom.GeometryType.LINE_STRING:t=n.getCoordinates(),t.splice(a+1,0,o);break;default:return}this.setGeometryCoordinates_(n,t);var s=this.rBush_;s.remove(e),this.updateSegmentIndices_(n,a,l,1);var p={segment:[r[0],o],feature:i,geometry:n,depth:l,index:a};s.insert(ol.extent.boundingExtent(p.segment),p),this.dragSegments_.push([p,1]);var g={segment:[o,r[1]],feature:i,geometry:n,depth:l,index:a+1};s.insert(ol.extent.boundingExtent(g.segment),g),this.dragSegments_.push([g,0]),this.ignoreNextSingleClick_=!0},ol.interaction.Modify.prototype.removePoint=function(){if(this.lastPointerEvent_&&this.lastPointerEvent_.type!=ol.MapBrowserEvent.EventType.POINTERDRAG){var e=this.lastPointerEvent_;return this.willModifyFeatures_(e),this.removeVertex_(),this.dispatchEvent(new ol.interaction.Modify.Event(ol.interaction.Modify.EventType.MODIFYEND,this.features_,e)),this.modified_=!1,!0}return!1},ol.interaction.Modify.prototype.removeVertex_=function(){var e,o,t,r,i,n,l,a,s,p,g,c=this.dragSegments_,u={},y=!1;for(i=c.length-1;i>=0;--i)t=c[i],p=t[0],g=ol.getUid(p.feature),p.depth&&(g+="-"+p.depth.join("-")),g in u||(u[g]={}),0===t[1]?(u[g].right=p,u[g].index=p.index):1==t[1]&&(u[g].left=p,u[g].index=p.index+1);for(g in u){switch(s=u[g].right,l=u[g].left,n=u[g].index,a=n-1,p=void 0!==l?l:s,a<0&&(a=0),r=p.geometry,o=r.getCoordinates(),e=o,y=!1,r.getType()){case ol.geom.GeometryType.MULTI_LINE_STRING:o[p.depth[0]].length>2&&(o[p.depth[0]].splice(n,1),y=!0);break;case ol.geom.GeometryType.LINE_STRING:o.length>2&&(o.splice(n,1),y=!0);break;case ol.geom.GeometryType.MULTI_POLYGON:e=e[p.depth[1]];case ol.geom.GeometryType.POLYGON:e=e[p.depth[0]],e.length>4&&(n==e.length-1&&(n=0),e.splice(n,1),y=!0,0===n&&(e.pop(),e.push(e[0]),a=e.length-1))}if(y){this.setGeometryCoordinates_(r,o);var d=[];if(void 0!==l&&(this.rBush_.remove(l),d.push(l.segment[0])),void 0!==s&&(this.rBush_.remove(s),d.push(s.segment[1])),void 0!==l&&void 0!==s){ol.DEBUG&&console.assert(a>=0,"newIndex should be larger than 0");var h={depth:p.depth,feature:p.feature,geometry:p.geometry,index:a,segment:d};this.rBush_.insert(ol.extent.boundingExtent(h.segment),h)}this.updateSegmentIndices_(r,n,p.depth,-1),this.vertexFeature_&&(this.overlay_.getSource().removeFeature(this.vertexFeature_),this.vertexFeature_=null)}}return y},ol.interaction.Modify.prototype.setGeometryCoordinates_=function(e,o){this.changingFeature_=!0,e.setCoordinates(o),this.changingFeature_=!1},ol.interaction.Modify.prototype.updateSegmentIndices_=function(e,o,t,r){this.rBush_.forEachInExtent(e.getExtent(),function(i){i.geometry===e&&(void 0===t||void 0===i.depth||ol.array.equals(i.depth,t))&&i.index>o&&(i.index+=r)})},ol.interaction.Modify.getDefaultStyleFunction=function(){var e=ol.style.Style.createDefaultEditing();return function(o,t){return e[ol.geom.GeometryType.POINT]}},ol.interaction.Modify.Event=function(e,o,t){ol.events.Event.call(this,e),this.features=o,this.mapBrowserEvent=t},ol.inherits(ol.interaction.Modify.Event,ol.events.Event),ol.interaction.Modify.EventType={MODIFYSTART:"modifystart",MODIFYEND:"modifyend"},goog.provide("ol.interaction.Select"),goog.require("ol"),goog.require("ol.functions"),goog.require("ol.Collection"),goog.require("ol.array"),goog.require("ol.events"),goog.require("ol.events.Event"),goog.require("ol.events.condition"),goog.require("ol.geom.GeometryType"),goog.require("ol.interaction.Interaction"),goog.require("ol.layer.Vector"),goog.require("ol.obj"),goog.require("ol.source.Vector"),goog.require("ol.style.Style"),ol.interaction.Select=function(e){ol.interaction.Interaction.call(this,{handleEvent:ol.interaction.Select.handleEvent});var o=e||{};this.condition_=o.condition?o.condition:ol.events.condition.singleClick,this.addCondition_=o.addCondition?o.addCondition:ol.events.condition.never,this.removeCondition_=o.removeCondition?o.removeCondition:ol.events.condition.never,this.toggleCondition_=o.toggleCondition?o.toggleCondition:ol.events.condition.shiftKeyOnly,this.multi_=!!o.multi&&o.multi,this.filter_=o.filter?o.filter:ol.functions.TRUE,this.hitTolerance_=o.hitTolerance?o.hitTolerance:0;var t=new ol.layer.Vector({source:new ol.source.Vector({useSpatialIndex:!1,features:o.features,wrapX:o.wrapX}),style:o.style?o.style:ol.interaction.Select.getDefaultStyleFunction(),updateWhileAnimating:!0,updateWhileInteracting:!0});this.featureOverlay_=t;var r;if(o.layers)if("function"==typeof o.layers)r=o.layers;else{var i=o.layers;r=function(e){return ol.array.includes(i,e)}}else r=ol.functions.TRUE;this.layerFilter_=r,this.featureLayerAssociation_={};var n=this.featureOverlay_.getSource().getFeaturesCollection();ol.events.listen(n,ol.Collection.EventType.ADD,this.addFeature_,this),ol.events.listen(n,ol.Collection.EventType.REMOVE,this.removeFeature_,this)},ol.inherits(ol.interaction.Select,ol.interaction.Interaction),ol.interaction.Select.prototype.addFeatureLayerAssociation_=function(e,o){var t=ol.getUid(e);this.featureLayerAssociation_[t]=o},ol.interaction.Select.prototype.getFeatures=function(){return this.featureOverlay_.getSource().getFeaturesCollection()},ol.interaction.Select.prototype.getHitTolerance=function(){return this.hitTolerance_},ol.interaction.Select.prototype.getLayer=function(e){var o=ol.getUid(e);return this.featureLayerAssociation_[o]},ol.interaction.Select.handleEvent=function(e){if(!this.condition_(e))return!0;var o=this.addCondition_(e),t=this.removeCondition_(e),r=this.toggleCondition_(e),i=!o&&!t&&!r,n=e.map,l=this.featureOverlay_.getSource().getFeaturesCollection(),a=[],s=[];if(i){ol.obj.clear(this.featureLayerAssociation_),n.forEachFeatureAtPixel(e.pixel,function(e,o){if(this.filter_(e,o))return s.push(e),this.addFeatureLayerAssociation_(e,o),!this.multi_}.bind(this),{layerFilter:this.layerFilter_,hitTolerance:this.hitTolerance_});var p;for(p=l.getLength()-1;p>=0;--p){var g=l.item(p),c=s.indexOf(g);c>-1?s.splice(c,1):(l.remove(g),a.push(g))}0!==s.length&&l.extend(s)}else{n.forEachFeatureAtPixel(e.pixel,function(e,i){if(this.filter_(e,i))return!o&&!r||ol.array.includes(l.getArray(),e)?(t||r)&&ol.array.includes(l.getArray(),e)&&(a.push(e),this.removeFeatureLayerAssociation_(e)):(s.push(e),this.addFeatureLayerAssociation_(e,i)),!this.multi_}.bind(this),{layerFilter:this.layerFilter_,hitTolerance:this.hitTolerance_});var u;for(u=a.length-1;u>=0;--u)l.remove(a[u]);l.extend(s)}return(s.length>0||a.length>0)&&this.dispatchEvent(new ol.interaction.Select.Event(ol.interaction.Select.EventType.SELECT,s,a,e)),ol.events.condition.pointerMove(e)},ol.interaction.Select.prototype.setHitTolerance=function(e){this.hitTolerance_=e},ol.interaction.Select.prototype.setMap=function(e){var o=this.getMap(),t=this.featureOverlay_.getSource().getFeaturesCollection();o&&t.forEach(o.unskipFeature,o),ol.interaction.Interaction.prototype.setMap.call(this,e),this.featureOverlay_.setMap(e),e&&t.forEach(e.skipFeature,e)},ol.interaction.Select.getDefaultStyleFunction=function(){var e=ol.style.Style.createDefaultEditing();return ol.array.extend(e[ol.geom.GeometryType.POLYGON],e[ol.geom.GeometryType.LINE_STRING]),ol.array.extend(e[ol.geom.GeometryType.GEOMETRY_COLLECTION],e[ol.geom.GeometryType.LINE_STRING]),function(o,t){return o.getGeometry()?e[o.getGeometry().getType()]:null}},ol.interaction.Select.prototype.addFeature_=function(e){var o=this.getMap();o&&o.skipFeature(e.element)},ol.interaction.Select.prototype.removeFeature_=function(e){var o=this.getMap();o&&o.unskipFeature(e.element)},ol.interaction.Select.prototype.removeFeatureLayerAssociation_=function(e){var o=ol.getUid(e);delete this.featureLayerAssociation_[o]},ol.interaction.Select.Event=function(e,o,t,r){ol.events.Event.call(this,e),this.selected=o,this.deselected=t,this.mapBrowserEvent=r},ol.inherits(ol.interaction.Select.Event,ol.events.Event),ol.interaction.Select.EventType={SELECT:"select"},goog.provide("ol.interaction.Snap"),goog.require("ol"),goog.require("ol.Collection"),goog.require("ol.Object"),goog.require("ol.Observable"),goog.require("ol.coordinate"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.interaction.Pointer"),goog.require("ol.functions"),goog.require("ol.obj"),goog.require("ol.source.Vector"),goog.require("ol.structs.RBush"),ol.interaction.Snap=function(e){ol.interaction.Pointer.call(this,{handleEvent:ol.interaction.Snap.handleEvent_,handleDownEvent:ol.functions.TRUE,handleUpEvent:ol.interaction.Snap.handleUpEvent_});var o=e||{};this.source_=o.source?o.source:null,this.vertex_=void 0===o.vertex||o.vertex,this.edge_=void 0===o.edge||o.edge,this.features_=o.features?o.features:null,this.featuresListenerKeys_=[],this.geometryChangeListenerKeys_={},this.geometryModifyListenerKeys_={},this.indexedFeaturesExtents_={},this.pendingFeatures_={},this.pixelCoordinate_=null,this.pixelTolerance_=void 0!==o.pixelTolerance?o.pixelTolerance:10,this.sortByDistance_=ol.interaction.Snap.sortByDistance.bind(this),this.rBush_=new ol.structs.RBush,this.SEGMENT_WRITERS_={Point:this.writePointGeometry_,LineString:this.writeLineStringGeometry_,LinearRing:this.writeLineStringGeometry_,Polygon:this.writePolygonGeometry_,MultiPoint:this.writeMultiPointGeometry_,MultiLineString:this.writeMultiLineStringGeometry_,MultiPolygon:this.writeMultiPolygonGeometry_,GeometryCollection:this.writeGeometryCollectionGeometry_}},ol.inherits(ol.interaction.Snap,ol.interaction.Pointer),ol.interaction.Snap.prototype.addFeature=function(e,o){var t=void 0===o||o,r=ol.getUid(e),i=e.getGeometry();if(i){
var n=this.SEGMENT_WRITERS_[i.getType()];n&&(this.indexedFeaturesExtents_[r]=i.getExtent(ol.extent.createEmpty()),n.call(this,e,i),t&&(this.geometryModifyListenerKeys_[r]=ol.events.listen(i,ol.events.EventType.CHANGE,this.handleGeometryModify_.bind(this,e),this)))}t&&(this.geometryChangeListenerKeys_[r]=ol.events.listen(e,ol.Object.getChangeEventType(e.getGeometryName()),this.handleGeometryChange_,this))},ol.interaction.Snap.prototype.forEachFeatureAdd_=function(e){this.addFeature(e)},ol.interaction.Snap.prototype.forEachFeatureRemove_=function(e){this.removeFeature(e)},ol.interaction.Snap.prototype.getFeatures_=function(){var e;return this.features_?e=this.features_:this.source_&&(e=this.source_.getFeatures()),e},ol.interaction.Snap.prototype.handleFeatureAdd_=function(e){var o;e instanceof ol.source.Vector.Event?o=e.feature:e instanceof ol.Collection.Event&&(o=e.element),this.addFeature(o)},ol.interaction.Snap.prototype.handleFeatureRemove_=function(e){var o;e instanceof ol.source.Vector.Event?o=e.feature:e instanceof ol.Collection.Event&&(o=e.element),this.removeFeature(o)},ol.interaction.Snap.prototype.handleGeometryChange_=function(e){var o=e.target;this.removeFeature(o,!0),this.addFeature(o,!0)},ol.interaction.Snap.prototype.handleGeometryModify_=function(e,o){if(this.handlingDownUpSequence){var t=ol.getUid(e);t in this.pendingFeatures_||(this.pendingFeatures_[t]=e)}else this.updateFeature_(e)},ol.interaction.Snap.prototype.removeFeature=function(e,o){var t=void 0===o||o,r=ol.getUid(e),i=this.indexedFeaturesExtents_[r];if(i){var n,l=this.rBush_,a=[];for(l.forEachInExtent(i,function(o){e===o.feature&&a.push(o)}),n=a.length-1;n>=0;--n)l.remove(a[n]);t&&(ol.Observable.unByKey(this.geometryModifyListenerKeys_[r]),delete this.geometryModifyListenerKeys_[r])}t&&(ol.Observable.unByKey(this.geometryChangeListenerKeys_[r]),delete this.geometryChangeListenerKeys_[r])},ol.interaction.Snap.prototype.setMap=function(e){var o=this.getMap(),t=this.featuresListenerKeys_,r=this.getFeatures_();o&&(t.forEach(ol.Observable.unByKey),t.length=0,r.forEach(this.forEachFeatureRemove_,this)),ol.interaction.Pointer.prototype.setMap.call(this,e),e&&(this.features_?t.push(ol.events.listen(this.features_,ol.Collection.EventType.ADD,this.handleFeatureAdd_,this),ol.events.listen(this.features_,ol.Collection.EventType.REMOVE,this.handleFeatureRemove_,this)):this.source_&&t.push(ol.events.listen(this.source_,ol.source.Vector.EventType.ADDFEATURE,this.handleFeatureAdd_,this),ol.events.listen(this.source_,ol.source.Vector.EventType.REMOVEFEATURE,this.handleFeatureRemove_,this)),r.forEach(this.forEachFeatureAdd_,this))},ol.interaction.Snap.prototype.shouldStopEvent=ol.functions.FALSE,ol.interaction.Snap.prototype.snapTo=function(e,o,t){var r,i,n,l,a,s=t.getCoordinateFromPixel([e[0]-this.pixelTolerance_,e[1]+this.pixelTolerance_]),p=t.getCoordinateFromPixel([e[0]+this.pixelTolerance_,e[1]-this.pixelTolerance_]),g=ol.extent.boundingExtent([s,p]),c=this.rBush_.getInExtent(g),u=!1,y=null,d=null;if(c.length>0){this.pixelCoordinate_=o,c.sort(this.sortByDistance_);var h=c[0].segment;this.vertex_&&!this.edge_?(i=t.getPixelFromCoordinate(h[0]),n=t.getPixelFromCoordinate(h[1]),l=ol.coordinate.squaredDistance(e,i),a=ol.coordinate.squaredDistance(e,n),r=Math.sqrt(Math.min(l,a)),r<=this.pixelTolerance_&&(u=!0,y=l>a?h[1]:h[0],d=t.getPixelFromCoordinate(y))):this.edge_&&(y=ol.coordinate.closestOnSegment(o,h),d=t.getPixelFromCoordinate(y),Math.sqrt(ol.coordinate.squaredDistance(e,d))<=this.pixelTolerance_&&(u=!0,this.vertex_&&(i=t.getPixelFromCoordinate(h[0]),n=t.getPixelFromCoordinate(h[1]),l=ol.coordinate.squaredDistance(d,i),a=ol.coordinate.squaredDistance(d,n),r=Math.sqrt(Math.min(l,a)),r<=this.pixelTolerance_&&(y=l>a?h[1]:h[0],d=t.getPixelFromCoordinate(y))))),u&&(d=[Math.round(d[0]),Math.round(d[1])])}return{snapped:u,vertex:y,vertexPixel:d}},ol.interaction.Snap.prototype.updateFeature_=function(e){this.removeFeature(e,!1),this.addFeature(e,!1)},ol.interaction.Snap.prototype.writeGeometryCollectionGeometry_=function(e,o){var t,r=o.getGeometriesArray();for(t=0;t<r.length;++t)this.SEGMENT_WRITERS_[r[t].getType()].call(this,e,r[t])},ol.interaction.Snap.prototype.writeLineStringGeometry_=function(e,o){var t,r,i,n,l=o.getCoordinates();for(t=0,r=l.length-1;t<r;++t)i=l.slice(t,t+2),n={feature:e,segment:i},this.rBush_.insert(ol.extent.boundingExtent(i),n)},ol.interaction.Snap.prototype.writeMultiLineStringGeometry_=function(e,o){var t,r,i,n,l,a,s,p=o.getCoordinates();for(n=0,l=p.length;n<l;++n)for(t=p[n],r=0,i=t.length-1;r<i;++r)a=t.slice(r,r+2),s={feature:e,segment:a},this.rBush_.insert(ol.extent.boundingExtent(a),s)},ol.interaction.Snap.prototype.writeMultiPointGeometry_=function(e,o){var t,r,i,n,l=o.getCoordinates();for(r=0,i=l.length;r<i;++r)t=l[r],n={feature:e,segment:[t,t]},this.rBush_.insert(o.getExtent(),n)},ol.interaction.Snap.prototype.writeMultiPolygonGeometry_=function(e,o){var t,r,i,n,l,a,s,p,g,c,u=o.getCoordinates();for(a=0,s=u.length;a<s;++a)for(p=u[a],n=0,l=p.length;n<l;++n)for(t=p[n],r=0,i=t.length-1;r<i;++r)g=t.slice(r,r+2),c={feature:e,segment:g},this.rBush_.insert(ol.extent.boundingExtent(g),c)},ol.interaction.Snap.prototype.writePointGeometry_=function(e,o){var t=o.getCoordinates(),r={feature:e,segment:[t,t]};this.rBush_.insert(o.getExtent(),r)},ol.interaction.Snap.prototype.writePolygonGeometry_=function(e,o){var t,r,i,n,l,a,s,p=o.getCoordinates();for(n=0,l=p.length;n<l;++n)for(t=p[n],r=0,i=t.length-1;r<i;++r)a=t.slice(r,r+2),s={feature:e,segment:a},this.rBush_.insert(ol.extent.boundingExtent(a),s)},ol.interaction.Snap.handleEvent_=function(e){var o=this.snapTo(e.pixel,e.coordinate,e.map);return o.snapped&&(e.coordinate=o.vertex.slice(0,2),e.pixel=o.vertexPixel),ol.interaction.Pointer.handleEvent.call(this,e)},ol.interaction.Snap.handleUpEvent_=function(e){var o=ol.obj.getValues(this.pendingFeatures_);return o.length&&(o.forEach(this.updateFeature_,this),this.pendingFeatures_={}),!1},ol.interaction.Snap.sortByDistance=function(e,o){return ol.coordinate.squaredDistanceToSegment(this.pixelCoordinate_,e.segment)-ol.coordinate.squaredDistanceToSegment(this.pixelCoordinate_,o.segment)},goog.provide("ol.interaction.Translate"),goog.require("ol"),goog.require("ol.Collection"),goog.require("ol.events.Event"),goog.require("ol.functions"),goog.require("ol.array"),goog.require("ol.interaction.Pointer"),ol.interaction.Translate=function(e){ol.interaction.Pointer.call(this,{handleDownEvent:ol.interaction.Translate.handleDownEvent_,handleDragEvent:ol.interaction.Translate.handleDragEvent_,handleMoveEvent:ol.interaction.Translate.handleMoveEvent_,handleUpEvent:ol.interaction.Translate.handleUpEvent_});var o=e||{};this.previousCursor_=void 0,this.lastCoordinate_=null,this.features_=void 0!==o.features?o.features:null;var t;if(o.layers)if("function"==typeof o.layers)t=o.layers;else{var r=o.layers;t=function(e){return ol.array.includes(r,e)}}else t=ol.functions.TRUE;this.layerFilter_=t,this.hitTolerance_=o.hitTolerance?o.hitTolerance:0,this.lastFeature_=null},ol.inherits(ol.interaction.Translate,ol.interaction.Pointer),ol.interaction.Translate.handleDownEvent_=function(e){if(this.lastFeature_=this.featuresAtPixel_(e.pixel,e.map),!this.lastCoordinate_&&this.lastFeature_){this.lastCoordinate_=e.coordinate,ol.interaction.Translate.handleMoveEvent_.call(this,e);var o=this.features_||new ol.Collection([this.lastFeature_]);return this.dispatchEvent(new ol.interaction.Translate.Event(ol.interaction.Translate.EventType.TRANSLATESTART,o,e.coordinate)),!0}return!1},ol.interaction.Translate.handleUpEvent_=function(e){if(this.lastCoordinate_){this.lastCoordinate_=null,ol.interaction.Translate.handleMoveEvent_.call(this,e);var o=this.features_||new ol.Collection([this.lastFeature_]);return this.dispatchEvent(new ol.interaction.Translate.Event(ol.interaction.Translate.EventType.TRANSLATEEND,o,e.coordinate)),!0}return!1},ol.interaction.Translate.handleDragEvent_=function(e){if(this.lastCoordinate_){var o=e.coordinate,t=o[0]-this.lastCoordinate_[0],r=o[1]-this.lastCoordinate_[1],i=this.features_||new ol.Collection([this.lastFeature_]);i.forEach(function(e){var o=e.getGeometry();o.translate(t,r),e.setGeometry(o)}),this.lastCoordinate_=o,this.dispatchEvent(new ol.interaction.Translate.Event(ol.interaction.Translate.EventType.TRANSLATING,i,o))}},ol.interaction.Translate.handleMoveEvent_=function(e){var o=e.map.getTargetElement();this.featuresAtPixel_(e.pixel,e.map)?(this.previousCursor_=o.style.cursor,o.style.cursor=this.lastCoordinate_?"-webkit-grabbing":"-webkit-grab",o.style.cursor=this.lastCoordinate_?"grabbing":"grab"):(o.style.cursor=void 0!==this.previousCursor_?this.previousCursor_:"",this.previousCursor_=void 0)},ol.interaction.Translate.prototype.featuresAtPixel_=function(e,o){return o.forEachFeatureAtPixel(e,function(e){if(!this.features_||ol.array.includes(this.features_.getArray(),e))return e}.bind(this),{layerFilter:this.layerFilter_,hitTolerance:this.hitTolerance_})},ol.interaction.Translate.prototype.getHitTolerance=function(){return this.hitTolerance_},ol.interaction.Translate.prototype.setHitTolerance=function(e){this.hitTolerance_=e},ol.interaction.Translate.Event=function(e,o,t){ol.events.Event.call(this,e),this.features=o,this.coordinate=t},ol.inherits(ol.interaction.Translate.Event,ol.events.Event),ol.interaction.Translate.EventType={TRANSLATESTART:"translatestart",TRANSLATING:"translating",TRANSLATEEND:"translateend"},goog.provide("ol.layer.Heatmap"),goog.require("ol.events"),goog.require("ol"),goog.require("ol.Object"),goog.require("ol.dom"),goog.require("ol.layer.Vector"),goog.require("ol.math"),goog.require("ol.obj"),goog.require("ol.render.Event"),goog.require("ol.style.Icon"),goog.require("ol.style.Style"),ol.layer.Heatmap=function(e){var o=e||{},t=ol.obj.assign({},o);delete t.gradient,delete t.radius,delete t.blur,delete t.shadow,delete t.weight,ol.layer.Vector.call(this,t),this.gradient_=null,this.shadow_=void 0!==o.shadow?o.shadow:250,this.circleImage_=void 0,this.styleCache_=null,ol.events.listen(this,ol.Object.getChangeEventType(ol.layer.Heatmap.Property.GRADIENT),this.handleGradientChanged_,this),this.setGradient(o.gradient?o.gradient:ol.layer.Heatmap.DEFAULT_GRADIENT),this.setBlur(void 0!==o.blur?o.blur:15),this.setRadius(void 0!==o.radius?o.radius:8),ol.events.listen(this,ol.Object.getChangeEventType(ol.layer.Heatmap.Property.BLUR),this.handleStyleChanged_,this),ol.events.listen(this,ol.Object.getChangeEventType(ol.layer.Heatmap.Property.RADIUS),this.handleStyleChanged_,this),this.handleStyleChanged_();var r,i=o.weight?o.weight:"weight";r="string"==typeof i?function(e){return e.get(i)}:i,ol.DEBUG&&console.assert("function"==typeof r,"weightFunction should be a function"),this.setStyle(function(e,o){ol.DEBUG&&console.assert(this.styleCache_,"this.styleCache_ expected"),ol.DEBUG&&console.assert(void 0!==this.circleImage_,"this.circleImage_ should be defined");var t=r(e),i=void 0!==t?ol.math.clamp(t,0,1):1,n=255*i|0,l=this.styleCache_[n];return l||(l=[new ol.style.Style({image:new ol.style.Icon({opacity:i,src:this.circleImage_})})],this.styleCache_[n]=l),l}.bind(this)),this.setRenderOrder(null),ol.events.listen(this,ol.render.Event.Type.RENDER,this.handleRender_,this)},ol.inherits(ol.layer.Heatmap,ol.layer.Vector),ol.layer.Heatmap.DEFAULT_GRADIENT=["#00f","#0ff","#0f0","#ff0","#f00"],ol.layer.Heatmap.createGradient_=function(e){for(var o=ol.dom.createCanvasContext2D(1,256),t=o.createLinearGradient(0,0,1,256),r=1/(e.length-1),i=0,n=e.length;i<n;++i)t.addColorStop(i*r,e[i]);return o.fillStyle=t,o.fillRect(0,0,1,256),o.getImageData(0,0,1,256).data},ol.layer.Heatmap.prototype.createCircle_=function(){var e=this.getRadius(),o=this.getBlur();ol.DEBUG&&console.assert(void 0!==e&&void 0!==o,"radius and blur should be defined");var t=e+o+1,r=2*t,i=ol.dom.createCanvasContext2D(r,r);i.shadowOffsetX=i.shadowOffsetY=this.shadow_,i.shadowBlur=o,i.shadowColor="#000",i.beginPath();var n=t-this.shadow_;return i.arc(n,n,e,0,2*Math.PI,!0),i.fill(),i.canvas.toDataURL()},ol.layer.Heatmap.prototype.getBlur=function(){return this.get(ol.layer.Heatmap.Property.BLUR)},ol.layer.Heatmap.prototype.getGradient=function(){return this.get(ol.layer.Heatmap.Property.GRADIENT)},ol.layer.Heatmap.prototype.getRadius=function(){return this.get(ol.layer.Heatmap.Property.RADIUS)},ol.layer.Heatmap.prototype.handleGradientChanged_=function(){this.gradient_=ol.layer.Heatmap.createGradient_(this.getGradient())},ol.layer.Heatmap.prototype.handleStyleChanged_=function(){this.circleImage_=this.createCircle_(),this.styleCache_=new Array(256),this.changed()},ol.layer.Heatmap.prototype.handleRender_=function(e){ol.DEBUG&&console.assert(e.type==ol.render.Event.Type.RENDER,"event.type should be RENDER"),ol.DEBUG&&console.assert(this.gradient_,"this.gradient_ expected");var o,t,r,i=e.context,n=i.canvas,l=i.getImageData(0,0,n.width,n.height),a=l.data;for(o=0,t=a.length;o<t;o+=4)(r=4*a[o+3])&&(a[o]=this.gradient_[r],a[o+1]=this.gradient_[r+1],a[o+2]=this.gradient_[r+2]);i.putImageData(l,0,0)},ol.layer.Heatmap.prototype.setBlur=function(e){this.set(ol.layer.Heatmap.Property.BLUR,e)};ol.layer.Heatmap.prototype.setGradient=function(e){this.set(ol.layer.Heatmap.Property.GRADIENT,e)},ol.layer.Heatmap.prototype.setRadius=function(e){this.set(ol.layer.Heatmap.Property.RADIUS,e)},ol.layer.Heatmap.Property={BLUR:"blur",GRADIENT:"gradient",RADIUS:"radius"},goog.provide("ol.net"),goog.require("ol"),ol.net.jsonp=function(e,o,t,r){function i(){delete window[l],n.parentNode.removeChild(n)}var n=document.createElement("script"),l="olc_"+ol.getUid(o);n.async=!0,n.src=e+(-1==e.indexOf("?")?"?":"&")+(r||"callback")+"="+l;var a=setTimeout(function(){i(),t&&t()},1e4);window[l]=function(e){clearTimeout(a),i(),o(e)},document.getElementsByTagName("head")[0].appendChild(n)},goog.provide("ol.render"),goog.require("ol.has"),goog.require("ol.transform"),goog.require("ol.render.canvas.Immediate"),ol.render.toContext=function(e,o){var t=e.canvas,r=o||{},i=r.pixelRatio||ol.has.DEVICE_PIXEL_RATIO,n=r.size;n&&(t.width=n[0]*i,t.height=n[1]*i,t.style.width=n[0]+"px",t.style.height=n[1]+"px");var l=[0,0,t.width,t.height],a=ol.transform.scale(ol.transform.create(),i,i);return new ol.render.canvas.Immediate(e,i,l,a,0)},goog.provide("ol.reproj.Tile"),goog.require("ol"),goog.require("ol.Tile"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.math"),goog.require("ol.reproj"),goog.require("ol.reproj.Triangulation"),ol.reproj.Tile=function(e,o,t,r,i,n,l,a,s,p,g){ol.Tile.call(this,i,ol.Tile.State.IDLE),this.renderEdges_=void 0!==g&&g,this.pixelRatio_=l,this.gutter_=a,this.canvas_=null,this.sourceTileGrid_=o,this.targetTileGrid_=r,this.wrappedTileCoord_=n||i,this.sourceTiles_=[],this.sourcesListenerKeys_=null,this.sourceZ_=0;var c=r.getTileCoordExtent(this.wrappedTileCoord_),u=this.targetTileGrid_.getExtent(),y=this.sourceTileGrid_.getExtent(),d=u?ol.extent.getIntersection(c,u):c;if(0===ol.extent.getArea(d))return void(this.state=ol.Tile.State.EMPTY);var h=e.getExtent();h&&(y=y?ol.extent.getIntersection(y,h):h);var m=r.getResolution(this.wrappedTileCoord_[0]),f=ol.extent.getCenter(d),_=ol.reproj.calculateSourceResolution(e,t,f,m);if(!isFinite(_)||_<=0)return void(this.state=ol.Tile.State.EMPTY);var E=void 0!==p?p:ol.DEFAULT_RASTER_REPROJECTION_ERROR_THRESHOLD;if(this.triangulation_=new ol.reproj.Triangulation(e,t,d,y,_*E),0===this.triangulation_.getTriangles().length)return void(this.state=ol.Tile.State.EMPTY);this.sourceZ_=o.getZForResolution(_);var v=this.triangulation_.calculateSourceExtent();if(y&&(e.canWrapX()?(v[1]=ol.math.clamp(v[1],y[1],y[3]),v[3]=ol.math.clamp(v[3],y[1],y[3])):v=ol.extent.getIntersection(v,y)),ol.extent.getArea(v)){var S=o.getTileRangeForExtentAndZ(v,this.sourceZ_),x=S.getWidth()*S.getHeight();if(ol.DEBUG&&!(x<ol.RASTER_REPROJECTION_MAX_SOURCE_TILES))return console.assert(!1,"reasonable number of tiles is required"),void(this.state=ol.Tile.State.ERROR);for(var P=S.minX;P<=S.maxX;P++)for(var T=S.minY;T<=S.maxY;T++){var R=s(this.sourceZ_,P,T,l);R&&this.sourceTiles_.push(R)}0===this.sourceTiles_.length&&(this.state=ol.Tile.State.EMPTY)}else this.state=ol.Tile.State.EMPTY},ol.inherits(ol.reproj.Tile,ol.Tile),ol.reproj.Tile.prototype.disposeInternal=function(){this.state==ol.Tile.State.LOADING&&this.unlistenSources_(),ol.Tile.prototype.disposeInternal.call(this)},ol.reproj.Tile.prototype.getImage=function(){return this.canvas_},ol.reproj.Tile.prototype.reproject_=function(){var e=[];if(this.sourceTiles_.forEach(function(o,t,r){o&&o.getState()==ol.Tile.State.LOADED&&e.push({extent:this.sourceTileGrid_.getTileCoordExtent(o.tileCoord),image:o.getImage()})},this),this.sourceTiles_.length=0,0===e.length)this.state=ol.Tile.State.ERROR;else{var o=this.wrappedTileCoord_[0],t=this.targetTileGrid_.getTileSize(o),r="number"==typeof t?t:t[0],i="number"==typeof t?t:t[1],n=this.targetTileGrid_.getResolution(o),l=this.sourceTileGrid_.getResolution(this.sourceZ_),a=this.targetTileGrid_.getTileCoordExtent(this.wrappedTileCoord_);this.canvas_=ol.reproj.render(r,i,this.pixelRatio_,l,this.sourceTileGrid_.getExtent(),n,a,this.triangulation_,e,this.gutter_,this.renderEdges_),this.state=ol.Tile.State.LOADED}this.changed()},ol.reproj.Tile.prototype.load=function(){if(this.state==ol.Tile.State.IDLE){this.state=ol.Tile.State.LOADING,this.changed();var e=0;ol.DEBUG&&console.assert(!this.sourcesListenerKeys_,"this.sourcesListenerKeys_ should be null"),this.sourcesListenerKeys_=[],this.sourceTiles_.forEach(function(o,t,r){var i=o.getState();if(i==ol.Tile.State.IDLE||i==ol.Tile.State.LOADING){e++;var n;n=ol.events.listen(o,ol.events.EventType.CHANGE,function(t){var r=o.getState();r!=ol.Tile.State.LOADED&&r!=ol.Tile.State.ERROR&&r!=ol.Tile.State.EMPTY||(ol.events.unlistenByKey(n),e--,ol.DEBUG&&console.assert(e>=0,"leftToLoad should not be negative"),0===e&&(this.unlistenSources_(),this.reproject_()))},this),this.sourcesListenerKeys_.push(n)}},this),this.sourceTiles_.forEach(function(e,o,t){e.getState()==ol.Tile.State.IDLE&&e.load()}),0===e&&setTimeout(this.reproject_.bind(this),0)}},ol.reproj.Tile.prototype.unlistenSources_=function(){this.sourcesListenerKeys_.forEach(ol.events.unlistenByKey),this.sourcesListenerKeys_=null},goog.provide("ol.TileUrlFunction"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.math"),goog.require("ol.tilecoord"),ol.TileUrlFunction.createFromTemplate=function(e,o){var t=/\{z\}/g,r=/\{x\}/g,i=/\{y\}/g,n=/\{-y\}/g;return function(l,a,s){return l?e.replace(t,l[0].toString()).replace(r,l[1].toString()).replace(i,function(){return(-l[2]-1).toString()}).replace(n,function(){var e=l[0],t=o.getFullTileRange(e);return ol.asserts.assert(t,55),(t.getHeight()+l[2]).toString()}):void 0}},ol.TileUrlFunction.createFromTemplates=function(e,o){for(var t=e.length,r=new Array(t),i=0;i<t;++i)r[i]=ol.TileUrlFunction.createFromTemplate(e[i],o);return ol.TileUrlFunction.createFromTileUrlFunctions(r)},ol.TileUrlFunction.createFromTileUrlFunctions=function(e){return ol.DEBUG&&console.assert(e.length>0,"Length of tile url functions should be greater than 0"),1===e.length?e[0]:function(o,t,r){if(o){var i=ol.tilecoord.hash(o),n=ol.math.modulo(i,e.length);return e[n](o,t,r)}}},ol.TileUrlFunction.nullTileUrlFunction=function(e,o,t){},ol.TileUrlFunction.expandUrl=function(e){var o=[],t=/\{([a-z])-([a-z])\}/.exec(e);if(t){var r,i=t[1].charCodeAt(0),n=t[2].charCodeAt(0);for(r=i;r<=n;++r)o.push(e.replace(t[0],String.fromCharCode(r)));return o}if(t=t=/\{(\d+)-(\d+)\}/.exec(e)){for(var l=parseInt(t[2],10),a=parseInt(t[1],10);a<=l;a++)o.push(e.replace(t[0],a.toString()));return o}return o.push(e),o},goog.provide("ol.TileCache"),goog.require("ol"),goog.require("ol.structs.LRUCache"),ol.TileCache=function(e){ol.structs.LRUCache.call(this),this.highWaterMark_=void 0!==e?e:2048},ol.inherits(ol.TileCache,ol.structs.LRUCache),ol.TileCache.prototype.canExpireCache=function(){return this.getCount()>this.highWaterMark_},ol.TileCache.prototype.expireCache=function(e){for(var o,t;this.canExpireCache()&&(o=this.peekLast(),!((t=o.tileCoord[0].toString())in e&&e[t].contains(o.tileCoord)));)this.pop().dispose()},goog.provide("ol.source.Tile"),goog.require("ol"),goog.require("ol.Tile"),goog.require("ol.TileCache"),goog.require("ol.events.Event"),goog.require("ol.proj"),goog.require("ol.size"),goog.require("ol.source.Source"),goog.require("ol.tilecoord"),goog.require("ol.tilegrid"),ol.source.Tile=function(e){ol.source.Source.call(this,{attributions:e.attributions,extent:e.extent,logo:e.logo,projection:e.projection,state:e.state,wrapX:e.wrapX}),this.opaque_=void 0!==e.opaque&&e.opaque,this.tilePixelRatio_=void 0!==e.tilePixelRatio?e.tilePixelRatio:1,this.tileGrid=void 0!==e.tileGrid?e.tileGrid:null,this.tileCache=new ol.TileCache(e.cacheSize),this.tmpSize=[0,0],this.key_=""},ol.inherits(ol.source.Tile,ol.source.Source),ol.source.Tile.prototype.canExpireCache=function(){return this.tileCache.canExpireCache()},ol.source.Tile.prototype.expireCache=function(e,o){var t=this.getTileCacheForProjection(e);t&&t.expireCache(o)},ol.source.Tile.prototype.forEachLoadedTile=function(e,o,t,r){var i=this.getTileCacheForProjection(e);if(!i)return!1;for(var n,l,a,s=!0,p=t.minX;p<=t.maxX;++p)for(var g=t.minY;g<=t.maxY;++g)l=this.getKeyZXY(o,p,g),a=!1,i.containsKey(l)&&(n=i.get(l),(a=n.getState()===ol.Tile.State.LOADED)&&(a=!1!==r(n))),a||(s=!1);return s},ol.source.Tile.prototype.getGutter=function(e){return 0},ol.source.Tile.prototype.getKey=function(){return this.key_},ol.source.Tile.prototype.setKey=function(e){this.key_!==e&&(this.key_=e,this.changed())},ol.source.Tile.prototype.getKeyZXY=ol.tilecoord.getKeyZXY,ol.source.Tile.prototype.getOpaque=function(e){return this.opaque_},ol.source.Tile.prototype.getResolutions=function(){return this.tileGrid.getResolutions()},ol.source.Tile.prototype.getTile=function(e,o,t,r,i){},ol.source.Tile.prototype.getTileGrid=function(){return this.tileGrid},ol.source.Tile.prototype.getTileGridForProjection=function(e){return this.tileGrid?this.tileGrid:ol.tilegrid.getForProjection(e)},ol.source.Tile.prototype.getTileCacheForProjection=function(e){var o=this.getProjection();return o&&!ol.proj.equivalent(o,e)?null:this.tileCache},ol.source.Tile.prototype.getTilePixelRatio=function(e){return this.tilePixelRatio_},ol.source.Tile.prototype.getTilePixelSize=function(e,o,t){var r=this.getTileGridForProjection(t),i=this.getTilePixelRatio(o),n=ol.size.toSize(r.getTileSize(e),this.tmpSize);return 1==i?n:ol.size.scale(n,i,this.tmpSize)},ol.source.Tile.prototype.getTileCoordForTileUrlFunction=function(e,o){var t=void 0!==o?o:this.getProjection(),r=this.getTileGridForProjection(t);return this.getWrapX()&&t.isGlobal()&&(e=ol.tilegrid.wrapX(r,e,t)),ol.tilecoord.withinExtentAndZ(e,r)?e:null},ol.source.Tile.prototype.refresh=function(){this.tileCache.clear(),this.changed()},ol.source.Tile.prototype.useTile=ol.nullFunction,ol.source.Tile.Event=function(e,o){ol.events.Event.call(this,e),this.tile=o},ol.inherits(ol.source.Tile.Event,ol.events.Event),ol.source.Tile.EventType={TILELOADSTART:"tileloadstart",TILELOADEND:"tileloadend",TILELOADERROR:"tileloaderror"},goog.provide("ol.source.UrlTile"),goog.require("ol"),goog.require("ol.Tile"),goog.require("ol.TileUrlFunction"),goog.require("ol.source.Tile"),ol.source.UrlTile=function(e){ol.source.Tile.call(this,{attributions:e.attributions,cacheSize:e.cacheSize,extent:e.extent,logo:e.logo,opaque:e.opaque,projection:e.projection,state:e.state,tileGrid:e.tileGrid,tilePixelRatio:e.tilePixelRatio,wrapX:e.wrapX}),this.tileLoadFunction=e.tileLoadFunction,this.tileUrlFunction=this.fixedTileUrlFunction?this.fixedTileUrlFunction.bind(this):ol.TileUrlFunction.nullTileUrlFunction,this.urls=null,e.urls?this.setUrls(e.urls):e.url&&this.setUrl(e.url),e.tileUrlFunction&&this.setTileUrlFunction(e.tileUrlFunction)},ol.inherits(ol.source.UrlTile,ol.source.Tile),ol.source.UrlTile.prototype.fixedTileUrlFunction,ol.source.UrlTile.prototype.getTileLoadFunction=function(){return this.tileLoadFunction},ol.source.UrlTile.prototype.getTileUrlFunction=function(){return this.tileUrlFunction},ol.source.UrlTile.prototype.getUrls=function(){return this.urls},ol.source.UrlTile.prototype.handleTileChange=function(e){var o=e.target;switch(o.getState()){case ol.Tile.State.LOADING:this.dispatchEvent(new ol.source.Tile.Event(ol.source.Tile.EventType.TILELOADSTART,o));break;case ol.Tile.State.LOADED:this.dispatchEvent(new ol.source.Tile.Event(ol.source.Tile.EventType.TILELOADEND,o));break;case ol.Tile.State.ERROR:this.dispatchEvent(new ol.source.Tile.Event(ol.source.Tile.EventType.TILELOADERROR,o))}},ol.source.UrlTile.prototype.setTileLoadFunction=function(e){this.tileCache.clear(),this.tileLoadFunction=e,this.changed()},ol.source.UrlTile.prototype.setTileUrlFunction=function(e,o){this.tileUrlFunction=e,void 0!==o?this.setKey(o):this.changed()},ol.source.UrlTile.prototype.setUrl=function(e){var o=this.urls=ol.TileUrlFunction.expandUrl(e);this.setTileUrlFunction(this.fixedTileUrlFunction?this.fixedTileUrlFunction.bind(this):ol.TileUrlFunction.createFromTemplates(o,this.tileGrid),e)},ol.source.UrlTile.prototype.setUrls=function(e){this.urls=e;var o=e.join("\n");this.setTileUrlFunction(this.fixedTileUrlFunction?this.fixedTileUrlFunction.bind(this):ol.TileUrlFunction.createFromTemplates(e,this.tileGrid),o)},ol.source.UrlTile.prototype.useTile=function(e,o,t){var r=this.getKeyZXY(e,o,t);this.tileCache.containsKey(r)&&this.tileCache.get(r)},goog.provide("ol.source.TileImage"),goog.require("ol"),goog.require("ol.ImageTile"),goog.require("ol.Tile"),goog.require("ol.TileCache"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.proj"),goog.require("ol.reproj.Tile"),goog.require("ol.source.UrlTile"),goog.require("ol.tilegrid"),ol.source.TileImage=function(e){ol.source.UrlTile.call(this,{attributions:e.attributions,cacheSize:e.cacheSize,extent:e.extent,logo:e.logo,opaque:e.opaque,projection:e.projection,state:e.state,tileGrid:e.tileGrid,tileLoadFunction:e.tileLoadFunction?e.tileLoadFunction:ol.source.TileImage.defaultTileLoadFunction,tilePixelRatio:e.tilePixelRatio,tileUrlFunction:e.tileUrlFunction,url:e.url,urls:e.urls,wrapX:e.wrapX}),this.crossOrigin=void 0!==e.crossOrigin?e.crossOrigin:null,this.tileClass=void 0!==e.tileClass?e.tileClass:ol.ImageTile,this.tileCacheForProjection={},this.tileGridForProjection={},this.reprojectionErrorThreshold_=e.reprojectionErrorThreshold,this.renderReprojectionEdges_=!1},ol.inherits(ol.source.TileImage,ol.source.UrlTile),ol.source.TileImage.prototype.canExpireCache=function(){if(!ol.ENABLE_RASTER_REPROJECTION)return ol.source.UrlTile.prototype.canExpireCache.call(this);if(this.tileCache.canExpireCache())return!0;for(var e in this.tileCacheForProjection)if(this.tileCacheForProjection[e].canExpireCache())return!0;return!1},ol.source.TileImage.prototype.expireCache=function(e,o){if(!ol.ENABLE_RASTER_REPROJECTION)return void ol.source.UrlTile.prototype.expireCache.call(this,e,o);var t=this.getTileCacheForProjection(e);this.tileCache.expireCache(this.tileCache==t?o:{});for(var r in this.tileCacheForProjection){var i=this.tileCacheForProjection[r];i.expireCache(i==t?o:{})}},ol.source.TileImage.prototype.getGutter=function(e){return ol.ENABLE_RASTER_REPROJECTION&&this.getProjection()&&e&&!ol.proj.equivalent(this.getProjection(),e)?0:this.getGutterInternal()},ol.source.TileImage.prototype.getGutterInternal=function(){return 0},ol.source.TileImage.prototype.getOpaque=function(e){return!(ol.ENABLE_RASTER_REPROJECTION&&this.getProjection()&&e&&!ol.proj.equivalent(this.getProjection(),e))&&ol.source.UrlTile.prototype.getOpaque.call(this,e)},ol.source.TileImage.prototype.getTileGridForProjection=function(e){if(!ol.ENABLE_RASTER_REPROJECTION)return ol.source.UrlTile.prototype.getTileGridForProjection.call(this,e);var o=this.getProjection();if(!this.tileGrid||o&&!ol.proj.equivalent(o,e)){var t=ol.getUid(e).toString();return t in this.tileGridForProjection||(this.tileGridForProjection[t]=ol.tilegrid.getForProjection(e)),this.tileGridForProjection[t]}return this.tileGrid},ol.source.TileImage.prototype.getTileCacheForProjection=function(e){if(!ol.ENABLE_RASTER_REPROJECTION)return ol.source.UrlTile.prototype.getTileCacheForProjection.call(this,e);var o=this.getProjection();if(!o||ol.proj.equivalent(o,e))return this.tileCache;var t=ol.getUid(e).toString();return t in this.tileCacheForProjection||(this.tileCacheForProjection[t]=new ol.TileCache),this.tileCacheForProjection[t]},ol.source.TileImage.prototype.createTile_=function(e,o,t,r,i,n){var l=[e,o,t],a=this.getTileCoordForTileUrlFunction(l,i),s=a?this.tileUrlFunction(a,r,i):void 0,p=new this.tileClass(l,void 0!==s?ol.Tile.State.IDLE:ol.Tile.State.EMPTY,void 0!==s?s:"",this.crossOrigin,this.tileLoadFunction);return p.key=n,ol.events.listen(p,ol.events.EventType.CHANGE,this.handleTileChange,this),p},ol.source.TileImage.prototype.getTile=function(e,o,t,r,i){if(ol.ENABLE_RASTER_REPROJECTION&&this.getProjection()&&i&&!ol.proj.equivalent(this.getProjection(),i)){var n,l=this.getTileCacheForProjection(i),a=[e,o,t],s=this.getKeyZXY.apply(this,a);l.containsKey(s)&&(n=l.get(s));var p=this.getKey();if(n&&n.key==p)return n;var g=this.getProjection(),c=this.getTileGridForProjection(g),u=this.getTileGridForProjection(i),y=this.getTileCoordForTileUrlFunction(a,i),d=new ol.reproj.Tile(g,c,i,u,a,y,this.getTilePixelRatio(r),this.getGutterInternal(),function(e,o,t,r){return this.getTileInternal(e,o,t,r,g)}.bind(this),this.reprojectionErrorThreshold_,this.renderReprojectionEdges_);return d.key=p,n?(d.interimTile=n,l.replace(s,d)):l.set(s,d),d}return this.getTileInternal(e,o,t,r,i)},ol.source.TileImage.prototype.getTileInternal=function(e,o,t,r,i){var n=null,l=this.getKeyZXY(e,o,t),a=this.getKey();if(this.tileCache.containsKey(l)){if(n=this.tileCache.get(l),n.key!=a){var s=n;n=this.createTile_(e,o,t,r,i,a),s.getState()==ol.Tile.State.IDLE?n.interimTile=s.interimTile:n.interimTile=s,n.refreshInterimChain(),this.tileCache.replace(l,n)}}else n=this.createTile_(e,o,t,r,i,a),this.tileCache.set(l,n);return n},ol.source.TileImage.prototype.setRenderReprojectionEdges=function(e){if(ol.ENABLE_RASTER_REPROJECTION&&this.renderReprojectionEdges_!=e){this.renderReprojectionEdges_=e;for(var o in this.tileCacheForProjection)this.tileCacheForProjection[o].clear();this.changed()}},ol.source.TileImage.prototype.setTileGridForProjection=function(e,o){if(ol.ENABLE_RASTER_REPROJECTION){var t=ol.proj.get(e);if(t){var r=ol.getUid(t).toString();r in this.tileGridForProjection||(this.tileGridForProjection[r]=o)}}},ol.source.TileImage.defaultTileLoadFunction=function(e,o){e.getImage().src=o},goog.provide("ol.source.BingMaps"),goog.require("ol"),goog.require("ol.Attribution"),goog.require("ol.TileUrlFunction"),goog.require("ol.extent"),goog.require("ol.net"),goog.require("ol.proj"),goog.require("ol.source.State"),goog.require("ol.source.TileImage"),goog.require("ol.tilecoord"),goog.require("ol.tilegrid"),ol.source.BingMaps=function(e){this.hidpi_=void 0!==e.hidpi&&e.hidpi,ol.source.TileImage.call(this,{cacheSize:e.cacheSize,crossOrigin:"anonymous",opaque:!0,projection:ol.proj.get("EPSG:3857"),reprojectionErrorThreshold:e.reprojectionErrorThreshold,state:ol.source.State.LOADING,tileLoadFunction:e.tileLoadFunction,tilePixelRatio:this.hidpi_?2:1,wrapX:void 0===e.wrapX||e.wrapX}),this.culture_=void 0!==e.culture?e.culture:"en-us",this.maxZoom_=void 0!==e.maxZoom?e.maxZoom:-1,this.apiKey_=e.key,this.imagerySet_=e.imagerySet;var o="https://dev.virtualearth.net/REST/v1/Imagery/Metadata/"+this.imagerySet_+"?uriScheme=https&include=ImageryProviders&key="+this.apiKey_;ol.net.jsonp(o,this.handleImageryMetadataResponse.bind(this),void 0,"jsonp")},ol.inherits(ol.source.BingMaps,ol.source.TileImage),ol.source.BingMaps.TOS_ATTRIBUTION=new ol.Attribution({
html:'<a class="ol-attribution-bing-tos" href="http://www.microsoft.com/maps/product/terms.html">Terms of Use</a>'}),ol.source.BingMaps.prototype.getApiKey=function(){return this.apiKey_},ol.source.BingMaps.prototype.getImagerySet=function(){return this.imagerySet_},ol.source.BingMaps.prototype.handleImageryMetadataResponse=function(e){if(200!=e.statusCode||"OK"!=e.statusDescription||"ValidCredentials"!=e.authenticationResultCode||1!=e.resourceSets.length||1!=e.resourceSets[0].resources.length)return void this.setState(ol.source.State.ERROR);var o=e.brandLogoUri;-1==o.indexOf("https")&&(o=o.replace("http","https"));var t=e.resourceSets[0].resources[0];ol.DEBUG&&console.assert(t.imageWidth==t.imageHeight,"resource has imageWidth equal to imageHeight, i.e. is square");var r=-1==this.maxZoom_?t.zoomMax:this.maxZoom_,i=this.getProjection(),n=ol.tilegrid.extentFromProjection(i),l=t.imageWidth==t.imageHeight?t.imageWidth:[t.imageWidth,t.imageHeight],a=ol.tilegrid.createXYZ({extent:n,minZoom:t.zoomMin,maxZoom:r,tileSize:l/this.getTilePixelRatio()});this.tileGrid=a;var s=this.culture_,p=this.hidpi_;if(this.tileUrlFunction=ol.TileUrlFunction.createFromTileUrlFunctions(t.imageUrlSubdomains.map(function(e){var o=[0,0,0],r=t.imageUrl.replace("{subdomain}",e).replace("{culture}",s);return function(e,t,n){if(ol.DEBUG&&console.assert(ol.proj.equivalent(n,i),"projections are equivalent"),e){ol.tilecoord.createOrUpdate(e[0],e[1],-e[2]-1,o);var l=r;return p&&(l+="&dpi=d1&device=mobile"),l.replace("{quadkey}",ol.tilecoord.quadKey(o))}}})),t.imageryProviders){var g=ol.proj.getTransformFromProjections(ol.proj.get("EPSG:4326"),this.getProjection()),c=t.imageryProviders.map(function(e){var o=e.attribution,t={};return e.coverageAreas.forEach(function(e){var o,i,n,l=e.zoomMin,s=Math.min(e.zoomMax,r),p=e.bbox,c=[p[1],p[0],p[3],p[2]],u=ol.extent.applyTransform(c,g);for(i=l;i<=s;++i)n=i.toString(),o=a.getTileRangeForExtentAndZ(u,i),n in t?t[n].push(o):t[n]=[o]}),new ol.Attribution({html:o,tileRanges:t})});c.push(ol.source.BingMaps.TOS_ATTRIBUTION),this.setAttributions(c)}this.setLogo(o),this.setState(ol.source.State.READY)},goog.provide("ol.source.XYZ"),goog.require("ol"),goog.require("ol.source.TileImage"),goog.require("ol.tilegrid"),ol.source.XYZ=function(e){var o=e||{},t=void 0!==o.projection?o.projection:"EPSG:3857",r=void 0!==o.tileGrid?o.tileGrid:ol.tilegrid.createXYZ({extent:ol.tilegrid.extentFromProjection(t),maxZoom:o.maxZoom,minZoom:o.minZoom,tileSize:o.tileSize});ol.source.TileImage.call(this,{attributions:o.attributions,cacheSize:o.cacheSize,crossOrigin:o.crossOrigin,logo:o.logo,opaque:o.opaque,projection:t,reprojectionErrorThreshold:o.reprojectionErrorThreshold,tileGrid:r,tileLoadFunction:o.tileLoadFunction,tilePixelRatio:o.tilePixelRatio,tileUrlFunction:o.tileUrlFunction,url:o.url,urls:o.urls,wrapX:void 0===o.wrapX||o.wrapX})},ol.inherits(ol.source.XYZ,ol.source.TileImage),goog.provide("ol.source.CartoDB"),goog.require("ol"),goog.require("ol.obj"),goog.require("ol.source.State"),goog.require("ol.source.XYZ"),ol.source.CartoDB=function(e){this.account_=e.account,this.mapId_=e.map||"",this.config_=e.config||{},this.templateCache_={},ol.source.XYZ.call(this,{attributions:e.attributions,cacheSize:e.cacheSize,crossOrigin:e.crossOrigin,logo:e.logo,maxZoom:void 0!==e.maxZoom?e.maxZoom:18,minZoom:e.minZoom,projection:e.projection,state:ol.source.State.LOADING,wrapX:e.wrapX}),this.initializeMap_()},ol.inherits(ol.source.CartoDB,ol.source.XYZ),ol.source.CartoDB.prototype.getConfig=function(){return this.config_},ol.source.CartoDB.prototype.updateConfig=function(e){ol.obj.assign(this.config_,e),this.initializeMap_()},ol.source.CartoDB.prototype.setConfig=function(e){this.config_=e||{},this.initializeMap_()},ol.source.CartoDB.prototype.initializeMap_=function(){var e=JSON.stringify(this.config_);if(this.templateCache_[e])return void this.applyTemplate_(this.templateCache_[e]);var o="https://"+this.account_+".cartodb.com/api/v1/map";this.mapId_&&(o+="/named/"+this.mapId_);var t=new XMLHttpRequest;t.addEventListener("load",this.handleInitResponse_.bind(this,e)),t.addEventListener("error",this.handleInitError_.bind(this)),t.open("POST",o),t.setRequestHeader("Content-type","application/json"),t.send(JSON.stringify(this.config_))},ol.source.CartoDB.prototype.handleInitResponse_=function(e,o){var t=o.target;if(!t.status||t.status>=200&&t.status<300){var r;try{r=JSON.parse(t.responseText)}catch(e){return void this.setState(ol.source.State.ERROR)}this.applyTemplate_(r),this.templateCache_[e]=r,this.setState(ol.source.State.READY)}else this.setState(ol.source.State.ERROR)},ol.source.CartoDB.prototype.handleInitError_=function(e){this.setState(ol.source.State.ERROR)},ol.source.CartoDB.prototype.applyTemplate_=function(e){var o="https://"+e.cdn_url.https+"/"+this.account_+"/api/v1/map/"+e.layergroupid+"/{z}/{x}/{y}.png";this.setUrl(o)},goog.provide("ol.source.Cluster"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.Feature"),goog.require("ol.coordinate"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.geom.Point"),goog.require("ol.source.Vector"),ol.source.Cluster=function(e){ol.source.Vector.call(this,{attributions:e.attributions,extent:e.extent,logo:e.logo,projection:e.projection,wrapX:e.wrapX}),this.resolution_=void 0,this.distance_=void 0!==e.distance?e.distance:20,this.features_=[],this.geometryFunction_=e.geometryFunction||function(e){var o=e.getGeometry();return ol.asserts.assert(o instanceof ol.geom.Point,10),o},this.source_=e.source,this.source_.on(ol.events.EventType.CHANGE,ol.source.Cluster.prototype.refresh_,this)},ol.inherits(ol.source.Cluster,ol.source.Vector),ol.source.Cluster.prototype.getSource=function(){return this.source_},ol.source.Cluster.prototype.loadFeatures=function(e,o,t){this.source_.loadFeatures(e,o,t),o!==this.resolution_&&(this.clear(),this.resolution_=o,this.cluster_(),this.addFeatures(this.features_))},ol.source.Cluster.prototype.setDistance=function(e){this.distance_=e,this.refresh_()},ol.source.Cluster.prototype.refresh_=function(){this.clear(),this.cluster_(),this.addFeatures(this.features_),this.changed()},ol.source.Cluster.prototype.cluster_=function(){if(void 0!==this.resolution_){this.features_.length=0;for(var e=ol.extent.createEmpty(),o=this.distance_*this.resolution_,t=this.source_.getFeatures(),r={},i=0,n=t.length;i<n;i++){var l=t[i];if(!(ol.getUid(l).toString()in r)){var a=this.geometryFunction_(l);if(a){var s=a.getCoordinates();ol.extent.createOrUpdateFromCoordinate(s,e),ol.extent.buffer(e,o,e);var p=this.source_.getFeaturesInExtent(e);ol.DEBUG&&console.assert(p.length>=1,"at least one neighbor found"),p=p.filter(function(e){var o=ol.getUid(e).toString();return!(o in r)&&(r[o]=!0,!0)}),this.features_.push(this.createCluster_(p))}}}ol.DEBUG&&console.assert(Object.keys(r).length==this.source_.getFeatures().length,"number of clustered equals number of features in the source")}},ol.source.Cluster.prototype.createCluster_=function(e){for(var o=[0,0],t=e.length-1;t>=0;--t){var r=this.geometryFunction_(e[t]);r?ol.coordinate.add(o,r.getCoordinates()):e.splice(t,1)}ol.coordinate.scale(o,1/e.length);var i=new ol.Feature(new ol.geom.Point(o));return i.set("features",e),i},goog.provide("ol.uri"),ol.uri.appendParams=function(e,o){var t=[];Object.keys(o).forEach(function(e){null!==o[e]&&void 0!==o[e]&&t.push(e+"="+encodeURIComponent(o[e]))});var r=t.join("&");return e=e.replace(/[?&]$/,""),(e=-1===e.indexOf("?")?e+"?":e+"&")+r},goog.provide("ol.source.ImageArcGISRest"),goog.require("ol"),goog.require("ol.Image"),goog.require("ol.asserts"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.obj"),goog.require("ol.source.Image"),goog.require("ol.uri"),ol.source.ImageArcGISRest=function(e){var o=e||{};ol.source.Image.call(this,{attributions:o.attributions,logo:o.logo,projection:o.projection,resolutions:o.resolutions}),this.crossOrigin_=void 0!==o.crossOrigin?o.crossOrigin:null,this.url_=o.url,this.imageLoadFunction_=void 0!==o.imageLoadFunction?o.imageLoadFunction:ol.source.Image.defaultImageLoadFunction,this.params_=o.params||{},this.image_=null,this.imageSize_=[0,0],this.renderedRevision_=0,this.ratio_=void 0!==o.ratio?o.ratio:1.5},ol.inherits(ol.source.ImageArcGISRest,ol.source.Image),ol.source.ImageArcGISRest.prototype.getParams=function(){return this.params_},ol.source.ImageArcGISRest.prototype.getImageInternal=function(e,o,t,r){if(void 0===this.url_)return null;o=this.findNearestResolution(o);var i=this.image_;if(i&&this.renderedRevision_==this.getRevision()&&i.getResolution()==o&&i.getPixelRatio()==t&&ol.extent.containsExtent(i.getExtent(),e))return i;var n={F:"image",FORMAT:"PNG32",TRANSPARENT:!0};ol.obj.assign(n,this.params_),e=e.slice();var l=(e[0]+e[2])/2,a=(e[1]+e[3])/2;if(1!=this.ratio_){var s=this.ratio_*ol.extent.getWidth(e)/2,p=this.ratio_*ol.extent.getHeight(e)/2;e[0]=l-s,e[1]=a-p,e[2]=l+s,e[3]=a+p}var g=o/t,c=Math.ceil(ol.extent.getWidth(e)/g),u=Math.ceil(ol.extent.getHeight(e)/g);e[0]=l-g*c/2,e[2]=l+g*c/2,e[1]=a-g*u/2,e[3]=a+g*u/2,this.imageSize_[0]=c,this.imageSize_[1]=u;var y=this.getRequestUrl_(e,this.imageSize_,t,r,n);return this.image_=new ol.Image(e,o,t,this.getAttributions(),y,this.crossOrigin_,this.imageLoadFunction_),this.renderedRevision_=this.getRevision(),ol.events.listen(this.image_,ol.events.EventType.CHANGE,this.handleImageChange,this),this.image_},ol.source.ImageArcGISRest.prototype.getImageLoadFunction=function(){return this.imageLoadFunction_},ol.source.ImageArcGISRest.prototype.getRequestUrl_=function(e,o,t,r,i){ol.DEBUG&&console.assert(void 0!==this.url_,"url is defined");var n=r.getCode().split(":").pop();i.SIZE=o[0]+","+o[1],i.BBOX=e.join(","),i.BBOXSR=n,i.IMAGESR=n,i.DPI=90*t;var l=this.url_,a=l.replace(/MapServer\/?$/,"MapServer/export").replace(/ImageServer\/?$/,"ImageServer/exportImage");return a==l&&ol.asserts.assert(!1,50),ol.uri.appendParams(a,i)},ol.source.ImageArcGISRest.prototype.getUrl=function(){return this.url_},ol.source.ImageArcGISRest.prototype.setImageLoadFunction=function(e){this.image_=null,this.imageLoadFunction_=e,this.changed()},ol.source.ImageArcGISRest.prototype.setUrl=function(e){e!=this.url_&&(this.url_=e,this.image_=null,this.changed())},ol.source.ImageArcGISRest.prototype.updateParams=function(e){ol.obj.assign(this.params_,e),this.image_=null,this.changed()},goog.provide("ol.source.ImageMapGuide"),goog.require("ol"),goog.require("ol.Image"),goog.require("ol.events");goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.obj"),goog.require("ol.source.Image"),goog.require("ol.uri"),ol.source.ImageMapGuide=function(e){ol.source.Image.call(this,{projection:e.projection,resolutions:e.resolutions}),this.crossOrigin_=void 0!==e.crossOrigin?e.crossOrigin:null,this.displayDpi_=void 0!==e.displayDpi?e.displayDpi:96,this.params_=e.params||{},this.url_=e.url,this.imageLoadFunction_=void 0!==e.imageLoadFunction?e.imageLoadFunction:ol.source.Image.defaultImageLoadFunction,this.hidpi_=void 0===e.hidpi||e.hidpi,this.metersPerUnit_=void 0!==e.metersPerUnit?e.metersPerUnit:1,this.ratio_=void 0!==e.ratio?e.ratio:1,this.useOverlay_=void 0!==e.useOverlay&&e.useOverlay,this.image_=null,this.renderedRevision_=0},ol.inherits(ol.source.ImageMapGuide,ol.source.Image),ol.source.ImageMapGuide.prototype.getParams=function(){return this.params_},ol.source.ImageMapGuide.prototype.getImageInternal=function(e,o,t,r){o=this.findNearestResolution(o),t=this.hidpi_?t:1;var i=this.image_;if(i&&this.renderedRevision_==this.getRevision()&&i.getResolution()==o&&i.getPixelRatio()==t&&ol.extent.containsExtent(i.getExtent(),e))return i;1!=this.ratio_&&(e=e.slice(),ol.extent.scaleFromCenter(e,this.ratio_));var n=ol.extent.getWidth(e)/o,l=ol.extent.getHeight(e)/o,a=[n*t,l*t];if(void 0!==this.url_){var s=this.getUrl(this.url_,this.params_,e,a,r);i=new ol.Image(e,o,t,this.getAttributions(),s,this.crossOrigin_,this.imageLoadFunction_),ol.events.listen(i,ol.events.EventType.CHANGE,this.handleImageChange,this)}else i=null;return this.image_=i,this.renderedRevision_=this.getRevision(),i},ol.source.ImageMapGuide.prototype.getImageLoadFunction=function(){return this.imageLoadFunction_},ol.source.ImageMapGuide.getScale=function(e,o,t,r){var i=ol.extent.getWidth(e),n=ol.extent.getHeight(e),l=o[0],a=o[1],s=.0254/r;return a*i>l*n?i*t/(l*s):n*t/(a*s)},ol.source.ImageMapGuide.prototype.updateParams=function(e){ol.obj.assign(this.params_,e),this.changed()},ol.source.ImageMapGuide.prototype.getUrl=function(e,o,t,r,i){var n=ol.source.ImageMapGuide.getScale(t,r,this.metersPerUnit_,this.displayDpi_),l=ol.extent.getCenter(t),a={OPERATION:this.useOverlay_?"GETDYNAMICMAPOVERLAYIMAGE":"GETMAPIMAGE",VERSION:"2.0.0",LOCALE:"en",CLIENTAGENT:"ol.source.ImageMapGuide source",CLIP:"1",SETDISPLAYDPI:this.displayDpi_,SETDISPLAYWIDTH:Math.round(r[0]),SETDISPLAYHEIGHT:Math.round(r[1]),SETVIEWSCALE:n,SETVIEWCENTERX:l[0],SETVIEWCENTERY:l[1]};return ol.obj.assign(a,o),ol.uri.appendParams(e,a)},ol.source.ImageMapGuide.prototype.setImageLoadFunction=function(e){this.image_=null,this.imageLoadFunction_=e,this.changed()},goog.provide("ol.source.ImageStatic"),goog.require("ol"),goog.require("ol.Image"),goog.require("ol.dom"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.proj"),goog.require("ol.source.Image"),ol.source.ImageStatic=function(e){var o=e.imageExtent,t=void 0!==e.crossOrigin?e.crossOrigin:null,r=void 0!==e.imageLoadFunction?e.imageLoadFunction:ol.source.Image.defaultImageLoadFunction;ol.source.Image.call(this,{attributions:e.attributions,logo:e.logo,projection:ol.proj.get(e.projection)}),this.image_=new ol.Image(o,void 0,1,this.getAttributions(),e.url,t,r),this.imageSize_=e.imageSize?e.imageSize:null,ol.events.listen(this.image_,ol.events.EventType.CHANGE,this.handleImageChange,this)},ol.inherits(ol.source.ImageStatic,ol.source.Image),ol.source.ImageStatic.prototype.getImageInternal=function(e,o,t,r){return ol.extent.intersects(e,this.image_.getExtent())?this.image_:null},ol.source.ImageStatic.prototype.handleImageChange=function(e){if(this.image_.getState()==ol.Image.State.LOADED){var o,t,r=this.image_.getExtent(),i=this.image_.getImage();this.imageSize_?(o=this.imageSize_[0],t=this.imageSize_[1]):(o=i.width,t=i.height);var n=ol.extent.getHeight(r)/t,l=Math.ceil(ol.extent.getWidth(r)/n);if(l!=o){var a=ol.dom.createCanvasContext2D(l,t),s=a.canvas;a.drawImage(i,0,0,o,t,0,0,s.width,s.height),this.image_.setImage(s)}}ol.source.Image.prototype.handleImageChange.call(this,e)},goog.provide("ol.source.WMSServerType"),ol.source.WMSServerType={CARMENTA_SERVER:"carmentaserver",GEOSERVER:"geoserver",MAPSERVER:"mapserver",QGIS:"qgis"},goog.provide("ol.source.ImageWMS"),goog.require("ol"),goog.require("ol.Image"),goog.require("ol.asserts"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.obj"),goog.require("ol.proj"),goog.require("ol.source.Image"),goog.require("ol.source.WMSServerType"),goog.require("ol.string"),goog.require("ol.uri"),ol.source.ImageWMS=function(e){var o=e||{};ol.source.Image.call(this,{attributions:o.attributions,logo:o.logo,projection:o.projection,resolutions:o.resolutions}),this.crossOrigin_=void 0!==o.crossOrigin?o.crossOrigin:null,this.url_=o.url,this.imageLoadFunction_=void 0!==o.imageLoadFunction?o.imageLoadFunction:ol.source.Image.defaultImageLoadFunction,this.params_=o.params||{},this.v13_=!0,this.updateV13_(),this.serverType_=o.serverType,this.hidpi_=void 0===o.hidpi||o.hidpi,this.image_=null,this.imageSize_=[0,0],this.renderedRevision_=0,this.ratio_=void 0!==o.ratio?o.ratio:1.5},ol.inherits(ol.source.ImageWMS,ol.source.Image),ol.source.ImageWMS.GETFEATUREINFO_IMAGE_SIZE_=[101,101],ol.source.ImageWMS.prototype.getGetFeatureInfoUrl=function(e,o,t,r){if(ol.DEBUG&&console.assert(!("VERSION"in r),"key VERSION is not allowed in params"),void 0!==this.url_){var i=ol.extent.getForViewAndSize(e,o,0,ol.source.ImageWMS.GETFEATUREINFO_IMAGE_SIZE_),n={SERVICE:"WMS",VERSION:ol.DEFAULT_WMS_VERSION,REQUEST:"GetFeatureInfo",FORMAT:"image/png",TRANSPARENT:!0,QUERY_LAYERS:this.params_.LAYERS};ol.obj.assign(n,this.params_,r);var l=Math.floor((e[0]-i[0])/o),a=Math.floor((i[3]-e[1])/o);return n[this.v13_?"I":"X"]=l,n[this.v13_?"J":"Y"]=a,this.getRequestUrl_(i,ol.source.ImageWMS.GETFEATUREINFO_IMAGE_SIZE_,1,ol.proj.get(t),n)}},ol.source.ImageWMS.prototype.getParams=function(){return this.params_},ol.source.ImageWMS.prototype.getImageInternal=function(e,o,t,r){if(void 0===this.url_)return null;o=this.findNearestResolution(o),1==t||this.hidpi_&&void 0!==this.serverType_||(t=1),e=e.slice();var i=(e[0]+e[2])/2,n=(e[1]+e[3])/2,l=o/t,a=ol.extent.getWidth(e)/l,s=ol.extent.getHeight(e)/l,p=this.image_;if(p&&this.renderedRevision_==this.getRevision()&&p.getResolution()==o&&p.getPixelRatio()==t&&ol.extent.containsExtent(p.getExtent(),e))return p;if(1!=this.ratio_){var g=this.ratio_*ol.extent.getWidth(e)/2,c=this.ratio_*ol.extent.getHeight(e)/2;e[0]=i-g,e[1]=n-c,e[2]=i+g,e[3]=n+c}var u={SERVICE:"WMS",VERSION:ol.DEFAULT_WMS_VERSION,REQUEST:"GetMap",FORMAT:"image/png",TRANSPARENT:!0};ol.obj.assign(u,this.params_),this.imageSize_[0]=Math.ceil(a*this.ratio_),this.imageSize_[1]=Math.ceil(s*this.ratio_);var y=this.getRequestUrl_(e,this.imageSize_,t,r,u);return this.image_=new ol.Image(e,o,t,this.getAttributions(),y,this.crossOrigin_,this.imageLoadFunction_),this.renderedRevision_=this.getRevision(),ol.events.listen(this.image_,ol.events.EventType.CHANGE,this.handleImageChange,this),this.image_},ol.source.ImageWMS.prototype.getImageLoadFunction=function(){return this.imageLoadFunction_},ol.source.ImageWMS.prototype.getRequestUrl_=function(e,o,t,r,i){if(ol.asserts.assert(void 0!==this.url_,9),i[this.v13_?"CRS":"SRS"]=r.getCode(),"STYLES"in this.params_||(i.STYLES=""),1!=t)switch(this.serverType_){case ol.source.WMSServerType.GEOSERVER:var n=90*t+.5|0;"FORMAT_OPTIONS"in i?i.FORMAT_OPTIONS+=";dpi:"+n:i.FORMAT_OPTIONS="dpi:"+n;break;case ol.source.WMSServerType.MAPSERVER:i.MAP_RESOLUTION=90*t;break;case ol.source.WMSServerType.CARMENTA_SERVER:case ol.source.WMSServerType.QGIS:i.DPI=90*t;break;default:ol.asserts.assert(!1,8)}i.WIDTH=o[0],i.HEIGHT=o[1];var l,a=r.getAxisOrientation();return l=this.v13_&&"ne"==a.substr(0,2)?[e[1],e[0],e[3],e[2]]:e,i.BBOX=l.join(","),ol.uri.appendParams(this.url_,i)},ol.source.ImageWMS.prototype.getUrl=function(){return this.url_},ol.source.ImageWMS.prototype.setImageLoadFunction=function(e){this.image_=null,this.imageLoadFunction_=e,this.changed()},ol.source.ImageWMS.prototype.setUrl=function(e){e!=this.url_&&(this.url_=e,this.image_=null,this.changed())},ol.source.ImageWMS.prototype.updateParams=function(e){ol.obj.assign(this.params_,e),this.updateV13_(),this.image_=null,this.changed()},ol.source.ImageWMS.prototype.updateV13_=function(){var e=this.params_.VERSION||ol.DEFAULT_WMS_VERSION;this.v13_=ol.string.compareVersions(e,"1.3")>=0},goog.provide("ol.source.OSM"),goog.require("ol"),goog.require("ol.Attribution"),goog.require("ol.source.XYZ"),ol.source.OSM=function(e){var o,t=e||{};o=void 0!==t.attributions?t.attributions:[ol.source.OSM.ATTRIBUTION];var r=void 0!==t.crossOrigin?t.crossOrigin:"anonymous",i=void 0!==t.url?t.url:"https://{a-c}.tile.openstreetmap.org/{z}/{x}/{y}.png";ol.source.XYZ.call(this,{attributions:o,cacheSize:t.cacheSize,crossOrigin:r,opaque:void 0===t.opaque||t.opaque,maxZoom:void 0!==t.maxZoom?t.maxZoom:19,reprojectionErrorThreshold:t.reprojectionErrorThreshold,tileLoadFunction:t.tileLoadFunction,url:i,wrapX:t.wrapX})},ol.inherits(ol.source.OSM,ol.source.XYZ),ol.source.OSM.ATTRIBUTION=new ol.Attribution({html:'&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors.'}),goog.provide("ol.ext.pixelworks"),ol.ext.pixelworks,function(){var e,o={},t={exports:o};!function(r){if("object"==typeof o&&void 0!==t)t.exports=r();else if("function"==typeof e&&e.amd)e([],r);else{var i;i="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,i.pixelworks=r()}}(function(){return function e(o,t,r){function i(l,a){if(!t[l]){if(!o[l]){var s="function"==typeof require&&require;if(!a&&s)return s(l,!0);if(n)return n(l,!0);var p=new Error("Cannot find module '"+l+"'");throw p.code="MODULE_NOT_FOUND",p}var g=t[l]={exports:{}};o[l][0].call(g.exports,function(e){var t=o[l][1][e];return i(t||e)},g,g.exports,e,o,t,r)}return t[l].exports}for(var n="function"==typeof require&&require,l=0;l<r.length;l++)i(r[l]);return i}({1:[function(e,o,t){var r=e("./processor");t.Processor=r},{"./processor":2}],2:[function(e,o,t){function r(e){function o(e,o,r){return t?new ImageData(e,o,r):{data:e,width:o,height:r}}var t=!0;try{new ImageData(10,10)}catch(e){t=!1}return function(t){var r,i,n=t.buffers,l=t.meta,a=t.imageOps,s=t.width,p=t.height,g=n.length,c=n[0].byteLength;if(a){var u=new Array(g);for(i=0;i<g;++i)u[i]=o(new Uint8ClampedArray(n[i]),s,p);r=e(u,l).data}else{r=new Uint8ClampedArray(c);var y=new Array(g),d=new Array(g);for(i=0;i<g;++i)y[i]=new Uint8ClampedArray(n[i]),d[i]=[0,0,0,0];for(var h=0;h<c;h+=4){for(var m=0;m<g;++m){var f=y[m];d[m][0]=f[h],d[m][1]=f[h+1],d[m][2]=f[h+2],d[m][3]=f[h+3]}var _=e(d,l);r[h]=_[0],r[h+1]=_[1],r[h+2]=_[2],r[h+3]=_[3]}}return r.buffer}}function i(e,o){var t=Object.keys(e.lib||{}).map(function(o){return"var "+o+" = "+e.lib[o].toString()+";"}),i=t.concat(["var __minion__ = ("+r.toString()+")(",e.operation.toString(),");",'self.addEventListener("message", function(event) {',"  var buffer = __minion__(event.data);","  self.postMessage({buffer: buffer, meta: event.data.meta}, [buffer]);","});"]),n=new Blob(i,{type:"text/javascript"}),l=URL.createObjectURL(n),a=new Worker(l);return a.addEventListener("message",o),a}function n(e,o){var t=r(e.operation);return{postMessage:function(e){setTimeout(function(){o({data:{buffer:t(e),meta:e.meta}})},0)}}}function l(e){this._imageOps=!!e.imageOps;var o;o=0===e.threads?0:this._imageOps?1:e.threads||1;var t=[];if(o)for(var r=0;r<o;++r)t[r]=i(e,this._onWorkerMessage.bind(this,r));else t[0]=n(e,this._onWorkerMessage.bind(this,0));this._workers=t,this._queue=[],this._maxQueueLength=e.queue||1/0,this._running=0,this._dataLookup={},this._job=null}var a=e("./util").newImageData;l.prototype.process=function(e,o,t){this._enqueue({inputs:e,meta:o,callback:t}),this._dispatch()},l.prototype.destroy=function(){for(var e in this)this[e]=null;this._destroyed=!0},l.prototype._enqueue=function(e){for(this._queue.push(e);this._queue.length>this._maxQueueLength;)this._queue.shift().callback(null,null)},l.prototype._dispatch=function(){if(0===this._running&&this._queue.length>0){var e=this._job=this._queue.shift(),o=e.inputs[0].width,t=e.inputs[0].height,r=e.inputs.map(function(e){return e.data.buffer}),i=this._workers.length;if(this._running=i,1===i)this._workers[0].postMessage({buffers:r,meta:e.meta,imageOps:this._imageOps,width:o,height:t},r);else for(var n=e.inputs[0].data.length,l=4*Math.ceil(n/4/i),a=0;a<i;++a){for(var s=a*l,p=[],g=0,c=r.length;g<c;++g)p.push(r[a].slice(s,s+l));this._workers[a].postMessage({buffers:p,meta:e.meta,imageOps:this._imageOps,width:o,height:t},p)}}},l.prototype._onWorkerMessage=function(e,o){this._destroyed||(this._dataLookup[e]=o.data,0===--this._running&&this._resolveJob())},l.prototype._resolveJob=function(){var e,o,t=this._job,r=this._workers.length;if(1===r)e=new Uint8ClampedArray(this._dataLookup[0].buffer),o=this._dataLookup[0].meta;else{var i=t.inputs[0].data.length;e=new Uint8ClampedArray(i),o=new Array(i);for(var n=4*Math.ceil(i/4/r),l=0;l<r;++l){var s=this._dataLookup[l].buffer,p=l*n;e.set(new Uint8ClampedArray(s),p),o[l]=this._dataLookup[l].meta}}this._job=null,this._dataLookup={},t.callback(null,a(e,t.inputs[0].width,t.inputs[0].height),o),this._dispatch()},o.exports=l},{"./util":3}],3:[function(e,o,t){function r(e,o,t){if(i)return new ImageData(e,o,t);var r=n.createImageData(o,t);return r.data.set(e),r}var i=!0;try{new ImageData(10,10)}catch(e){i=!1}var n=document.createElement("canvas").getContext("2d");t.newImageData=r},{}]},{},[1])(1)}),ol.ext.pixelworks=t.exports}(),goog.provide("ol.source.Raster"),goog.require("ol"),goog.require("ol.transform"),goog.require("ol.ImageCanvas"),goog.require("ol.TileQueue"),goog.require("ol.dom"),goog.require("ol.events"),goog.require("ol.events.Event"),goog.require("ol.events.EventType"),goog.require("ol.ext.pixelworks"),goog.require("ol.extent"),goog.require("ol.layer.Image"),goog.require("ol.layer.Tile"),goog.require("ol.obj"),goog.require("ol.renderer.canvas.ImageLayer"),goog.require("ol.renderer.canvas.TileLayer"),goog.require("ol.source.Image"),goog.require("ol.source.State"),goog.require("ol.source.Tile"),ol.source.Raster=function(e){this.worker_=null,this.operationType_=void 0!==e.operationType?e.operationType:ol.source.Raster.OperationType.PIXEL,this.threads_=void 0!==e.threads?e.threads:1,this.renderers_=ol.source.Raster.createRenderers_(e.sources);for(var o=0,t=this.renderers_.length;o<t;++o)ol.events.listen(this.renderers_[o],ol.events.EventType.CHANGE,this.changed,this);this.canvasContext_=ol.dom.createCanvasContext2D(),this.tileQueue_=new ol.TileQueue(function(){return 1},this.changed.bind(this));for(var r=ol.source.Raster.getLayerStatesArray_(this.renderers_),i={},n=0,l=r.length;n<l;++n)i[ol.getUid(r[n].layer)]=r[n];this.renderedState_=null,this.renderedImageCanvas_=null,this.frameState_={animate:!1,attributions:{},coordinateToPixelTransform:ol.transform.create(),extent:null,focus:null,index:0,layerStates:i,layerStatesArray:r,logos:{},pixelRatio:1,pixelToCoordinateTransform:ol.transform.create(),postRenderFunctions:[],size:[0,0],skippedFeatureUids:{},tileQueue:this.tileQueue_,time:Date.now(),usedTiles:{},viewState:{rotation:0},viewHints:[],wantedTiles:{}},ol.source.Image.call(this,{}),void 0!==e.operation&&this.setOperation(e.operation,e.lib)},ol.inherits(ol.source.Raster,ol.source.Image),ol.source.Raster.prototype.setOperation=function(e,o){this.worker_=new ol.ext.pixelworks.Processor({operation:e,imageOps:this.operationType_===ol.source.Raster.OperationType.IMAGE,queue:1,lib:o,threads:this.threads_}),this.changed()},ol.source.Raster.prototype.updateFrameState_=function(e,o,t){var r=ol.obj.assign({},this.frameState_);r.viewState=ol.obj.assign({},r.viewState);var i=ol.extent.getCenter(e),n=Math.round(ol.extent.getWidth(e)/o),l=Math.round(ol.extent.getHeight(e)/o);r.extent=e,r.focus=ol.extent.getCenter(e),r.size[0]=n,r.size[1]=l;var a=r.viewState;return a.center=i,a.projection=t,a.resolution=o,r},ol.source.Raster.prototype.isDirty_=function(e,o){var t=this.renderedState_;return!t||this.getRevision()!==t.revision||o!==t.resolution||!ol.extent.equals(e,t.extent)},ol.source.Raster.prototype.getImage=function(e,o,t,r){if(!this.allSourcesReady_())return null;var i=e.slice();if(!this.isDirty_(i,o))return this.renderedImageCanvas_;var n=this.canvasContext_,l=n.canvas,a=Math.round(ol.extent.getWidth(i)/o),s=Math.round(ol.extent.getHeight(i)/o);a===l.width&&s===l.height||(l.width=a,l.height=s);var p=this.updateFrameState_(i,o,r),g=new ol.ImageCanvas(i,o,1,this.getAttributions(),l,this.composeFrame_.bind(this,p));return this.renderedImageCanvas_=g,this.renderedState_={extent:i,resolution:o,revision:this.getRevision()},g},ol.source.Raster.prototype.allSourcesReady_=function(){for(var e,o=!0,t=0,r=this.renderers_.length;t<r;++t)if(e=this.renderers_[t].getLayer().getSource(),e.getState()!==ol.source.State.READY){o=!1;break}return o},ol.source.Raster.prototype.composeFrame_=function(e,o){for(var t=this.renderers_.length,r=new Array(t),i=0;i<t;++i){var n=ol.source.Raster.getImageData_(this.renderers_[i],e,e.layerStatesArray[i]);if(!n){r=null;break}r[i]=n}if(r){var l={};this.dispatchEvent(new ol.source.Raster.Event(ol.source.Raster.EventType.BEFOREOPERATIONS,e,l)),this.worker_.process(r,l,this.onWorkerComplete_.bind(this,e,o))}e.tileQueue.loadMoreTiles(16,16)},ol.source.Raster.prototype.onWorkerComplete_=function(e,o,t,r,i){if(t)return void o(t);if(r){this.dispatchEvent(new ol.source.Raster.Event(ol.source.Raster.EventType.AFTEROPERATIONS,e,i));var n=e.viewState.resolution/e.pixelRatio;this.isDirty_(e.extent,n)||this.canvasContext_.putImageData(r,0,0),o(null)}},ol.source.Raster.getImageData_=function(e,o,t){if(!e.prepareFrame(o,t))return null;var r=o.size[0],i=o.size[1];if(ol.source.Raster.context_){var n=ol.source.Raster.context_.canvas;n.width!==r||n.height!==i?ol.source.Raster.context_=ol.dom.createCanvasContext2D(r,i):ol.source.Raster.context_.clearRect(0,0,r,i)}else ol.source.Raster.context_=ol.dom.createCanvasContext2D(r,i);return e.composeFrame(o,t,ol.source.Raster.context_),ol.source.Raster.context_.getImageData(0,0,r,i)},ol.source.Raster.context_=null,ol.source.Raster.getLayerStatesArray_=function(e){return e.map(function(e){return e.getLayer().getLayerState()})},ol.source.Raster.createRenderers_=function(e){for(var o=e.length,t=new Array(o),r=0;r<o;++r)t[r]=ol.source.Raster.createRenderer_(e[r]);return t},ol.source.Raster.createRenderer_=function(e){var o=null;return e instanceof ol.source.Tile?o=ol.source.Raster.createTileRenderer_(e):e instanceof ol.source.Image?o=ol.source.Raster.createImageRenderer_(e):ol.DEBUG&&console.assert(!1,"Unsupported source type: "+e),o},ol.source.Raster.createImageRenderer_=function(e){var o=new ol.layer.Image({source:e});return new ol.renderer.canvas.ImageLayer(o)},ol.source.Raster.createTileRenderer_=function(e){var o=new ol.layer.Tile({source:e});return new ol.renderer.canvas.TileLayer(o)},ol.source.Raster.Event=function(e,o,t){ol.events.Event.call(this,e),this.extent=o.extent,this.resolution=o.viewState.resolution/o.pixelRatio,this.data=t},ol.inherits(ol.source.Raster.Event,ol.events.Event),ol.source.Raster.EventType={BEFOREOPERATIONS:"beforeoperations",AFTEROPERATIONS:"afteroperations"},ol.source.Raster.OperationType={PIXEL:"pixel",IMAGE:"image"},goog.provide("ol.source.Stamen"),goog.require("ol"),goog.require("ol.Attribution"),goog.require("ol.source.OSM"),goog.require("ol.source.XYZ"),ol.source.Stamen=function(e){var o=e.layer.indexOf("-"),t=-1==o?e.layer:e.layer.slice(0,o);ol.DEBUG&&console.assert(t in ol.source.Stamen.ProviderConfig,"known provider configured");var r=ol.source.Stamen.ProviderConfig[t];ol.DEBUG&&console.assert(e.layer in ol.source.Stamen.LayerConfig,"known layer configured");var i=ol.source.Stamen.LayerConfig[e.layer],n=void 0!==e.url?e.url:"https://stamen-tiles-{a-d}.a.ssl.fastly.net/"+e.layer+"/{z}/{x}/{y}."+i.extension;ol.source.XYZ.call(this,{attributions:ol.source.Stamen.ATTRIBUTIONS,cacheSize:e.cacheSize,crossOrigin:"anonymous",maxZoom:void 0!=e.maxZoom?e.maxZoom:r.maxZoom,minZoom:void 0!=e.minZoom?e.minZoom:r.minZoom,opaque:i.opaque,reprojectionErrorThreshold:e.reprojectionErrorThreshold,tileLoadFunction:e.tileLoadFunction,url:n})},ol.inherits(ol.source.Stamen,ol.source.XYZ),ol.source.Stamen.ATTRIBUTIONS=[new ol.Attribution({html:'Map tiles by <a href="http://stamen.com/">Stamen Design</a>, under <a href="http://creativecommons.org/licenses/by/3.0/">CC BY 3.0</a>.'}),ol.source.OSM.ATTRIBUTION],ol.source.Stamen.LayerConfig={terrain:{extension:"jpg",opaque:!0},"terrain-background":{extension:"jpg",opaque:!0},"terrain-labels":{extension:"png",opaque:!1},"terrain-lines":{extension:"png",opaque:!1},"toner-background":{extension:"png",opaque:!0},toner:{extension:"png",opaque:!0},"toner-hybrid":{extension:"png",opaque:!1},"toner-labels":{extension:"png",opaque:!1},"toner-lines":{extension:"png",opaque:!1},"toner-lite":{extension:"png",opaque:!0},watercolor:{extension:"jpg",opaque:!0}},ol.source.Stamen.ProviderConfig={terrain:{minZoom:4,maxZoom:18},toner:{minZoom:0,maxZoom:20},watercolor:{minZoom:1,maxZoom:16}},goog.provide("ol.source.TileArcGISRest"),goog.require("ol"),goog.require("ol.extent"),goog.require("ol.math"),goog.require("ol.obj"),goog.require("ol.size"),goog.require("ol.source.TileImage"),
goog.require("ol.tilecoord"),goog.require("ol.uri"),ol.source.TileArcGISRest=function(e){var o=e||{};ol.source.TileImage.call(this,{attributions:o.attributions,cacheSize:o.cacheSize,crossOrigin:o.crossOrigin,logo:o.logo,projection:o.projection,reprojectionErrorThreshold:o.reprojectionErrorThreshold,tileGrid:o.tileGrid,tileLoadFunction:o.tileLoadFunction,url:o.url,urls:o.urls,wrapX:void 0===o.wrapX||o.wrapX}),this.params_=o.params||{},this.tmpExtent_=ol.extent.createEmpty(),this.setKey(this.getKeyForParams_())},ol.inherits(ol.source.TileArcGISRest,ol.source.TileImage),ol.source.TileArcGISRest.prototype.getKeyForParams_=function(){var e=0,o=[];for(var t in this.params_)o[e++]=t+"-"+this.params_[t];return o.join("/")},ol.source.TileArcGISRest.prototype.getParams=function(){return this.params_},ol.source.TileArcGISRest.prototype.getRequestUrl_=function(e,o,t,r,i,n){var l=this.urls;if(l){var a=i.getCode().split(":").pop();n.SIZE=o[0]+","+o[1],n.BBOX=t.join(","),n.BBOXSR=a,n.IMAGESR=a,n.DPI=Math.round(n.DPI?n.DPI*r:90*r);var s;if(1==l.length)s=l[0];else{s=l[ol.math.modulo(ol.tilecoord.hash(e),l.length)]}var p=s.replace(/MapServer\/?$/,"MapServer/export").replace(/ImageServer\/?$/,"ImageServer/exportImage");return ol.uri.appendParams(p,n)}},ol.source.TileArcGISRest.prototype.getTilePixelRatio=function(e){return e},ol.source.TileArcGISRest.prototype.fixedTileUrlFunction=function(e,o,t){var r=this.getTileGrid();if(r||(r=this.getTileGridForProjection(t)),!(r.getResolutions().length<=e[0])){var i=r.getTileCoordExtent(e,this.tmpExtent_),n=ol.size.toSize(r.getTileSize(e[0]),this.tmpSize);1!=o&&(n=ol.size.scale(n,o,this.tmpSize));var l={F:"image",FORMAT:"PNG32",TRANSPARENT:!0};return ol.obj.assign(l,this.params_),this.getRequestUrl_(e,n,i,o,t,l)}},ol.source.TileArcGISRest.prototype.updateParams=function(e){ol.obj.assign(this.params_,e),this.setKey(this.getKeyForParams_())},goog.provide("ol.source.TileDebug"),goog.require("ol"),goog.require("ol.Tile"),goog.require("ol.dom"),goog.require("ol.size"),goog.require("ol.source.Tile"),ol.source.TileDebug=function(e){ol.source.Tile.call(this,{opaque:!1,projection:e.projection,tileGrid:e.tileGrid,wrapX:void 0===e.wrapX||e.wrapX})},ol.inherits(ol.source.TileDebug,ol.source.Tile),ol.source.TileDebug.prototype.getTile=function(e,o,t){var r=this.getKeyZXY(e,o,t);if(this.tileCache.containsKey(r))return this.tileCache.get(r);var i=ol.size.toSize(this.tileGrid.getTileSize(e)),n=[e,o,t],l=this.getTileCoordForTileUrlFunction(n),a=l?this.getTileCoordForTileUrlFunction(l).toString():"",s=new ol.source.TileDebug.Tile_(n,i,a);return this.tileCache.set(r,s),s},ol.source.TileDebug.Tile_=function(e,o,t){ol.Tile.call(this,e,ol.Tile.State.LOADED),this.tileSize_=o,this.text_=t,this.canvas_=null},ol.inherits(ol.source.TileDebug.Tile_,ol.Tile),ol.source.TileDebug.Tile_.prototype.getImage=function(){if(this.canvas_)return this.canvas_;var e=this.tileSize_,o=ol.dom.createCanvasContext2D(e[0],e[1]);return o.strokeStyle="black",o.strokeRect(.5,.5,e[0]+.5,e[1]+.5),o.fillStyle="black",o.textAlign="center",o.textBaseline="middle",o.font="24px sans-serif",o.fillText(this.text_,e[0]/2,e[1]/2),this.canvas_=o.canvas,o.canvas},goog.provide("ol.source.TileJSON"),goog.require("ol"),goog.require("ol.Attribution"),goog.require("ol.TileUrlFunction"),goog.require("ol.extent"),goog.require("ol.net"),goog.require("ol.proj"),goog.require("ol.source.State"),goog.require("ol.source.TileImage"),goog.require("ol.tilegrid"),ol.source.TileJSON=function(e){if(this.tileJSON_=null,ol.source.TileImage.call(this,{attributions:e.attributions,cacheSize:e.cacheSize,crossOrigin:e.crossOrigin,projection:ol.proj.get("EPSG:3857"),reprojectionErrorThreshold:e.reprojectionErrorThreshold,state:ol.source.State.LOADING,tileLoadFunction:e.tileLoadFunction,wrapX:void 0===e.wrapX||e.wrapX}),e.jsonp)ol.net.jsonp(e.url,this.handleTileJSONResponse.bind(this),this.handleTileJSONError.bind(this));else{var o=new XMLHttpRequest;o.addEventListener("load",this.onXHRLoad_.bind(this)),o.addEventListener("error",this.onXHRError_.bind(this)),o.open("GET",e.url),o.send()}},ol.inherits(ol.source.TileJSON,ol.source.TileImage),ol.source.TileJSON.prototype.onXHRLoad_=function(e){var o=e.target;if(!o.status||o.status>=200&&o.status<300){var t;try{t=JSON.parse(o.responseText)}catch(e){return void this.handleTileJSONError()}this.handleTileJSONResponse(t)}else this.handleTileJSONError()},ol.source.TileJSON.prototype.onXHRError_=function(e){this.handleTileJSONError()},ol.source.TileJSON.prototype.getTileJSON=function(){return this.tileJSON_},ol.source.TileJSON.prototype.handleTileJSONResponse=function(e){var o,t=ol.proj.get("EPSG:4326"),r=this.getProjection();if(void 0!==e.bounds){var i=ol.proj.getTransformFromProjections(t,r);o=ol.extent.applyTransform(e.bounds,i)}void 0!==e.scheme&&ol.DEBUG&&console.assert("xyz"==e.scheme,'tileJSON-scheme is "xyz"');var n=e.minzoom||0,l=e.maxzoom||22,a=ol.tilegrid.createXYZ({extent:ol.tilegrid.extentFromProjection(r),maxZoom:l,minZoom:n});if(this.tileGrid=a,this.tileUrlFunction=ol.TileUrlFunction.createFromTemplates(e.tiles,a),void 0!==e.attribution&&!this.getAttributions()){var s,p,g=void 0!==o?o:t.getExtent(),c={};for(s=n;s<=l;++s)p=s.toString(),c[p]=[a.getTileRangeForExtentAndZ(g,s)];this.setAttributions([new ol.Attribution({html:e.attribution,tileRanges:c})])}this.tileJSON_=e,this.setState(ol.source.State.READY)},ol.source.TileJSON.prototype.handleTileJSONError=function(){this.setState(ol.source.State.ERROR)},goog.provide("ol.source.TileUTFGrid"),goog.require("ol"),goog.require("ol.Attribution"),goog.require("ol.Tile"),goog.require("ol.TileUrlFunction"),goog.require("ol.asserts"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.extent"),goog.require("ol.net"),goog.require("ol.proj"),goog.require("ol.source.State"),goog.require("ol.source.Tile"),goog.require("ol.tilegrid"),ol.source.TileUTFGrid=function(e){if(ol.source.Tile.call(this,{projection:ol.proj.get("EPSG:3857"),state:ol.source.State.LOADING}),this.preemptive_=void 0===e.preemptive||e.preemptive,this.tileUrlFunction_=ol.TileUrlFunction.nullTileUrlFunction,this.template_=void 0,this.jsonp_=e.jsonp||!1,e.url)if(this.jsonp_)ol.net.jsonp(e.url,this.handleTileJSONResponse.bind(this),this.handleTileJSONError.bind(this));else{var o=new XMLHttpRequest;o.addEventListener("load",this.onXHRLoad_.bind(this)),o.addEventListener("error",this.onXHRError_.bind(this)),o.open("GET",e.url),o.send()}else e.tileJSON?this.handleTileJSONResponse(e.tileJSON):ol.asserts.assert(!1,51)},ol.inherits(ol.source.TileUTFGrid,ol.source.Tile),ol.source.TileUTFGrid.prototype.onXHRLoad_=function(e){var o=e.target;if(!o.status||o.status>=200&&o.status<300){var t;try{t=JSON.parse(o.responseText)}catch(e){return void this.handleTileJSONError()}this.handleTileJSONResponse(t)}else this.handleTileJSONError()},ol.source.TileUTFGrid.prototype.onXHRError_=function(e){this.handleTileJSONError()},ol.source.TileUTFGrid.prototype.getTemplate=function(){return this.template_},ol.source.TileUTFGrid.prototype.forDataAtCoordinateAndResolution=function(e,o,t,r,i){if(this.tileGrid){var n=this.tileGrid.getTileCoordForCoordAndResolution(e,o);this.getTile(n[0],n[1],n[2],1,this.getProjection()).forDataAtCoordinate(e,t,r,i)}else!0===i?setTimeout(function(){t.call(r,null)},0):t.call(r,null)},ol.source.TileUTFGrid.prototype.handleTileJSONError=function(){this.setState(ol.source.State.ERROR)},ol.source.TileUTFGrid.prototype.handleTileJSONResponse=function(e){var o,t=ol.proj.get("EPSG:4326"),r=this.getProjection();if(void 0!==e.bounds){var i=ol.proj.getTransformFromProjections(t,r);o=ol.extent.applyTransform(e.bounds,i)}void 0!==e.scheme&&ol.DEBUG&&console.assert("xyz"==e.scheme,'tileJSON-scheme is "xyz"');var n=e.minzoom||0,l=e.maxzoom||22,a=ol.tilegrid.createXYZ({extent:ol.tilegrid.extentFromProjection(r),maxZoom:l,minZoom:n});this.tileGrid=a,this.template_=e.template;var s=e.grids;if(!s)return void this.setState(ol.source.State.ERROR);if(this.tileUrlFunction_=ol.TileUrlFunction.createFromTemplates(s,a),void 0!==e.attribution){var p,g,c=void 0!==o?o:t.getExtent(),u={};for(p=n;p<=l;++p)g=p.toString(),u[g]=[a.getTileRangeForExtentAndZ(c,p)];this.setAttributions([new ol.Attribution({html:e.attribution,tileRanges:u})])}this.setState(ol.source.State.READY)},ol.source.TileUTFGrid.prototype.getTile=function(e,o,t,r,i){var n=this.getKeyZXY(e,o,t);if(this.tileCache.containsKey(n))return this.tileCache.get(n);ol.DEBUG&&console.assert(i,"argument projection is truthy");var l=[e,o,t],a=this.getTileCoordForTileUrlFunction(l,i),s=this.tileUrlFunction_(a,r,i),p=new ol.source.TileUTFGrid.Tile_(l,void 0!==s?ol.Tile.State.IDLE:ol.Tile.State.EMPTY,void 0!==s?s:"",this.tileGrid.getTileCoordExtent(l),this.preemptive_,this.jsonp_);return this.tileCache.set(n,p),p},ol.source.TileUTFGrid.prototype.useTile=function(e,o,t){var r=this.getKeyZXY(e,o,t);this.tileCache.containsKey(r)&&this.tileCache.get(r)},ol.source.TileUTFGrid.Tile_=function(e,o,t,r,i,n){ol.Tile.call(this,e,o),this.src_=t,this.extent_=r,this.preemptive_=i,this.grid_=null,this.keys_=null,this.data_=null,this.jsonp_=n},ol.inherits(ol.source.TileUTFGrid.Tile_,ol.Tile),ol.source.TileUTFGrid.Tile_.prototype.getImage=function(){return null},ol.source.TileUTFGrid.Tile_.prototype.getData=function(e){if(!this.grid_||!this.keys_)return null;var o=(e[0]-this.extent_[0])/(this.extent_[2]-this.extent_[0]),t=(e[1]-this.extent_[1])/(this.extent_[3]-this.extent_[1]),r=this.grid_[Math.floor((1-t)*this.grid_.length)];if("string"!=typeof r)return null;var i=r.charCodeAt(Math.floor(o*r.length));i>=93&&i--,i>=35&&i--,i-=32;var n=null;if(i in this.keys_){var l=this.keys_[i];n=this.data_&&l in this.data_?this.data_[l]:l}return n},ol.source.TileUTFGrid.Tile_.prototype.forDataAtCoordinate=function(e,o,t,r){this.state==ol.Tile.State.IDLE&&!0===r?(ol.events.listenOnce(this,ol.events.EventType.CHANGE,function(r){o.call(t,this.getData(e))},this),this.loadInternal_()):!0===r?setTimeout(function(){o.call(t,this.getData(e))}.bind(this),0):o.call(t,this.getData(e))},ol.source.TileUTFGrid.Tile_.prototype.getKey=function(){return this.src_},ol.source.TileUTFGrid.Tile_.prototype.handleError_=function(){this.state=ol.Tile.State.ERROR,this.changed()},ol.source.TileUTFGrid.Tile_.prototype.handleLoad_=function(e){this.grid_=e.grid,this.keys_=e.keys,this.data_=e.data,this.state=ol.Tile.State.EMPTY,this.changed()},ol.source.TileUTFGrid.Tile_.prototype.loadInternal_=function(){if(this.state==ol.Tile.State.IDLE)if(this.state=ol.Tile.State.LOADING,this.jsonp_)ol.net.jsonp(this.src_,this.handleLoad_.bind(this),this.handleError_.bind(this));else{var e=new XMLHttpRequest;e.addEventListener("load",this.onXHRLoad_.bind(this)),e.addEventListener("error",this.onXHRError_.bind(this)),e.open("GET",this.src_),e.send()}},ol.source.TileUTFGrid.Tile_.prototype.onXHRLoad_=function(e){var o=e.target;if(!o.status||o.status>=200&&o.status<300){var t;try{t=JSON.parse(o.responseText)}catch(e){return void this.handleError_()}this.handleLoad_(t)}else this.handleError_()},ol.source.TileUTFGrid.Tile_.prototype.onXHRError_=function(e){this.handleError_()},ol.source.TileUTFGrid.Tile_.prototype.load=function(){this.preemptive_&&this.loadInternal_()},goog.provide("ol.source.TileWMS"),goog.require("ol"),goog.require("ol.asserts"),goog.require("ol.extent");goog.require("ol.obj"),goog.require("ol.math"),goog.require("ol.proj"),goog.require("ol.size"),goog.require("ol.source.TileImage"),goog.require("ol.source.WMSServerType"),goog.require("ol.tilecoord"),goog.require("ol.string"),goog.require("ol.uri"),ol.source.TileWMS=function(e){var o=e||{},t=o.params||{},r=!("TRANSPARENT"in t)||t.TRANSPARENT;ol.source.TileImage.call(this,{attributions:o.attributions,cacheSize:o.cacheSize,crossOrigin:o.crossOrigin,logo:o.logo,opaque:!r,projection:o.projection,reprojectionErrorThreshold:o.reprojectionErrorThreshold,tileGrid:o.tileGrid,tileLoadFunction:o.tileLoadFunction,url:o.url,urls:o.urls,wrapX:void 0===o.wrapX||o.wrapX}),this.gutter_=void 0!==o.gutter?o.gutter:0,this.params_=t,this.v13_=!0,this.serverType_=o.serverType,this.hidpi_=void 0===o.hidpi||o.hidpi,this.coordKeyPrefix_="",this.resetCoordKeyPrefix_(),this.tmpExtent_=ol.extent.createEmpty(),this.updateV13_(),this.setKey(this.getKeyForParams_())},ol.inherits(ol.source.TileWMS,ol.source.TileImage),ol.source.TileWMS.prototype.getGetFeatureInfoUrl=function(e,o,t,r){ol.DEBUG&&console.assert(!("VERSION"in r),"key VERSION is not allowed in params");var i=ol.proj.get(t),n=this.getTileGrid();n||(n=this.getTileGridForProjection(i));var l=n.getTileCoordForCoordAndResolution(e,o);if(!(n.getResolutions().length<=l[0])){var a=n.getResolution(l[0]),s=n.getTileCoordExtent(l,this.tmpExtent_),p=ol.size.toSize(n.getTileSize(l[0]),this.tmpSize),g=this.gutter_;0!==g&&(p=ol.size.buffer(p,g,this.tmpSize),s=ol.extent.buffer(s,a*g,s));var c={SERVICE:"WMS",VERSION:ol.DEFAULT_WMS_VERSION,REQUEST:"GetFeatureInfo",FORMAT:"image/png",TRANSPARENT:!0,QUERY_LAYERS:this.params_.LAYERS};ol.obj.assign(c,this.params_,r);var u=Math.floor((e[0]-s[0])/a),y=Math.floor((s[3]-e[1])/a);return c[this.v13_?"I":"X"]=u,c[this.v13_?"J":"Y"]=y,this.getRequestUrl_(l,p,s,1,i,c)}},ol.source.TileWMS.prototype.getGutterInternal=function(){return this.gutter_},ol.source.TileWMS.prototype.getKeyZXY=function(e,o,t){return this.coordKeyPrefix_+ol.source.TileImage.prototype.getKeyZXY.call(this,e,o,t)},ol.source.TileWMS.prototype.getParams=function(){return this.params_},ol.source.TileWMS.prototype.getRequestUrl_=function(e,o,t,r,i,n){var l=this.urls;if(l){if(n.WIDTH=o[0],n.HEIGHT=o[1],n[this.v13_?"CRS":"SRS"]=i.getCode(),"STYLES"in this.params_||(n.STYLES=""),1!=r)switch(this.serverType_){case ol.source.WMSServerType.GEOSERVER:var a=90*r+.5|0;"FORMAT_OPTIONS"in n?n.FORMAT_OPTIONS+=";dpi:"+a:n.FORMAT_OPTIONS="dpi:"+a;break;case ol.source.WMSServerType.MAPSERVER:n.MAP_RESOLUTION=90*r;break;case ol.source.WMSServerType.CARMENTA_SERVER:case ol.source.WMSServerType.QGIS:n.DPI=90*r;break;default:ol.asserts.assert(!1,52)}var s=i.getAxisOrientation(),p=t;if(this.v13_&&"ne"==s.substr(0,2)){var g;g=t[0],p[0]=t[1],p[1]=g,g=t[2],p[2]=t[3],p[3]=g}n.BBOX=p.join(",");var c;if(1==l.length)c=l[0];else{c=l[ol.math.modulo(ol.tilecoord.hash(e),l.length)]}return ol.uri.appendParams(c,n)}},ol.source.TileWMS.prototype.getTilePixelRatio=function(e){return this.hidpi_&&void 0!==this.serverType_?e:1},ol.source.TileWMS.prototype.resetCoordKeyPrefix_=function(){var e=0,o=[];if(this.urls){var t,r;for(t=0,r=this.urls.length;t<r;++t)o[e++]=this.urls[t]}this.coordKeyPrefix_=o.join("#")},ol.source.TileWMS.prototype.getKeyForParams_=function(){var e=0,o=[];for(var t in this.params_)o[e++]=t+"-"+this.params_[t];return o.join("/")},ol.source.TileWMS.prototype.fixedTileUrlFunction=function(e,o,t){var r=this.getTileGrid();if(r||(r=this.getTileGridForProjection(t)),!(r.getResolutions().length<=e[0])){1==o||this.hidpi_&&void 0!==this.serverType_||(o=1);var i=r.getResolution(e[0]),n=r.getTileCoordExtent(e,this.tmpExtent_),l=ol.size.toSize(r.getTileSize(e[0]),this.tmpSize),a=this.gutter_;0!==a&&(l=ol.size.buffer(l,a,this.tmpSize),n=ol.extent.buffer(n,i*a,n)),1!=o&&(l=ol.size.scale(l,o,this.tmpSize));var s={SERVICE:"WMS",VERSION:ol.DEFAULT_WMS_VERSION,REQUEST:"GetMap",FORMAT:"image/png",TRANSPARENT:!0};return ol.obj.assign(s,this.params_),this.getRequestUrl_(e,l,n,o,t,s)}},ol.source.TileWMS.prototype.setUrls=function(e){ol.source.TileImage.prototype.setUrls.call(this,e),this.resetCoordKeyPrefix_()},ol.source.TileWMS.prototype.updateParams=function(e){ol.obj.assign(this.params_,e),this.resetCoordKeyPrefix_(),this.updateV13_(),this.setKey(this.getKeyForParams_())},ol.source.TileWMS.prototype.updateV13_=function(){var e=this.params_.VERSION||ol.DEFAULT_WMS_VERSION;this.v13_=ol.string.compareVersions(e,"1.3")>=0},goog.provide("ol.VectorTile"),goog.require("ol"),goog.require("ol.Tile"),goog.require("ol.dom"),goog.require("ol.featureloader"),ol.VectorTile=function(e,o,t,r,i){ol.Tile.call(this,e,o),this.context_=ol.dom.createCanvasContext2D(),this.format_=r,this.features_=null,this.loader_,this.projection_,this.replayState_={dirty:!1,renderedRenderOrder:null,renderedRevision:-1,renderedTileRevision:-1,replayGroup:null},this.tileLoadFunction_=i,this.url_=t},ol.inherits(ol.VectorTile,ol.Tile),ol.VectorTile.prototype.getContext=function(){return this.context_},ol.VectorTile.prototype.getImage=function(){return-1==this.replayState_.renderedTileRevision?null:this.context_.canvas},ol.VectorTile.prototype.getFormat=function(){return this.format_},ol.VectorTile.prototype.getFeatures=function(){return this.features_},ol.VectorTile.prototype.getReplayState=function(){return this.replayState_},ol.VectorTile.prototype.getKey=function(){return this.url_},ol.VectorTile.prototype.getProjection=function(){return this.projection_},ol.VectorTile.prototype.load=function(){this.state==ol.Tile.State.IDLE&&(this.setState(ol.Tile.State.LOADING),this.tileLoadFunction_(this,this.url_),this.loader_(null,NaN,null))},ol.VectorTile.prototype.onLoad_=function(e,o){this.setProjection(o),this.setFeatures(e)},ol.VectorTile.prototype.onError_=function(){this.setState(ol.Tile.State.ERROR)},ol.VectorTile.prototype.setFeatures=function(e){this.features_=e,this.setState(ol.Tile.State.LOADED)},ol.VectorTile.prototype.setProjection=function(e){this.projection_=e},ol.VectorTile.prototype.setState=function(e){this.state=e,this.changed()},ol.VectorTile.prototype.setLoader=function(e){this.loader_=e},ol.VectorTile.defaultLoadFunction=function(e,o){var t=ol.featureloader.loadFeaturesXhr(o,e.getFormat(),e.onLoad_.bind(e),e.onError_.bind(e));e.setLoader(t)},goog.provide("ol.source.VectorTile"),goog.require("ol"),goog.require("ol.Tile"),goog.require("ol.VectorTile"),goog.require("ol.events"),goog.require("ol.events.EventType"),goog.require("ol.size"),goog.require("ol.source.UrlTile"),ol.source.VectorTile=function(e){ol.source.UrlTile.call(this,{attributions:e.attributions,cacheSize:void 0!==e.cacheSize?e.cacheSize:128,extent:e.extent,logo:e.logo,opaque:!1,projection:e.projection,state:e.state,tileGrid:e.tileGrid,tileLoadFunction:e.tileLoadFunction?e.tileLoadFunction:ol.VectorTile.defaultLoadFunction,tileUrlFunction:e.tileUrlFunction,tilePixelRatio:e.tilePixelRatio,url:e.url,urls:e.urls,wrapX:void 0===e.wrapX||e.wrapX}),this.format_=e.format?e.format:null,this.overlaps_=void 0==e.overlaps||e.overlaps,this.tileClass=e.tileClass?e.tileClass:ol.VectorTile},ol.inherits(ol.source.VectorTile,ol.source.UrlTile),ol.source.VectorTile.prototype.getOverlaps=function(){return this.overlaps_},ol.source.VectorTile.prototype.getTile=function(e,o,t,r,i){var n=this.getKeyZXY(e,o,t);if(this.tileCache.containsKey(n))return this.tileCache.get(n);var l=[e,o,t],a=this.getTileCoordForTileUrlFunction(l,i),s=a?this.tileUrlFunction(a,r,i):void 0,p=new this.tileClass(l,void 0!==s?ol.Tile.State.IDLE:ol.Tile.State.EMPTY,void 0!==s?s:"",this.format_,this.tileLoadFunction);return ol.events.listen(p,ol.events.EventType.CHANGE,this.handleTileChange,this),this.tileCache.set(n,p),p},ol.source.VectorTile.prototype.getTilePixelRatio=function(e){return void 0==e?ol.source.UrlTile.prototype.getTilePixelRatio.call(this,e):e},ol.source.VectorTile.prototype.getTilePixelSize=function(e,o,t){var r=ol.size.toSize(this.tileGrid.getTileSize(e));return[Math.round(r[0]*o),Math.round(r[1]*o)]},goog.provide("ol.tilegrid.WMTS"),goog.require("ol"),goog.require("ol.array"),goog.require("ol.proj"),goog.require("ol.tilegrid.TileGrid"),ol.tilegrid.WMTS=function(e){ol.DEBUG&&console.assert(e.resolutions.length==e.matrixIds.length,"options resolutions and matrixIds must have equal length (%s == %s)",e.resolutions.length,e.matrixIds.length),this.matrixIds_=e.matrixIds,ol.tilegrid.TileGrid.call(this,{extent:e.extent,origin:e.origin,origins:e.origins,resolutions:e.resolutions,tileSize:e.tileSize,tileSizes:e.tileSizes,sizes:e.sizes})},ol.inherits(ol.tilegrid.WMTS,ol.tilegrid.TileGrid),ol.tilegrid.WMTS.prototype.getMatrixId=function(e){return ol.DEBUG&&console.assert(0<=e&&e<this.matrixIds_.length,"attempted to retrieve matrixId for illegal z (%s)",e),this.matrixIds_[e]},ol.tilegrid.WMTS.prototype.getMatrixIds=function(){return this.matrixIds_},ol.tilegrid.WMTS.createFromCapabilitiesMatrixSet=function(e,o,t){var r,i=[],n=[],l=[],a=[],s=[],p=void 0!==t?t:[];r=ol.proj.get(e.SupportedCRS.replace(/urn:ogc:def:crs:(\w+):(.*:)?(\w+)$/,"$1:$3"));var g=r.getMetersPerUnit(),c="ne"==r.getAxisOrientation().substr(0,2);return e.TileMatrix.sort(function(e,o){return o.ScaleDenominator-e.ScaleDenominator}),e.TileMatrix.forEach(function(e,o,t){if(!(p.length>0)||ol.array.find(p,function(o,t,r){return e.Identifier==o.TileMatrix})){n.push(e.Identifier);var r=28e-5*e.ScaleDenominator/g,u=e.TileWidth,y=e.TileHeight;c?l.push([e.TopLeftCorner[1],e.TopLeftCorner[0]]):l.push(e.TopLeftCorner),i.push(r),a.push(u==y?u:[u,y]),s.push([e.MatrixWidth,-e.MatrixHeight])}}),new ol.tilegrid.WMTS({extent:o,origins:l,resolutions:i,matrixIds:n,tileSizes:a,sizes:s})},goog.provide("ol.source.WMTS"),goog.require("ol"),goog.require("ol.TileUrlFunction"),goog.require("ol.array"),goog.require("ol.extent"),goog.require("ol.obj"),goog.require("ol.proj"),goog.require("ol.source.TileImage"),goog.require("ol.tilegrid.WMTS"),goog.require("ol.uri"),ol.source.WMTS=function(e){function o(e){return e=r==ol.source.WMTS.RequestEncoding.KVP?ol.uri.appendParams(e,n):e.replace(/\{(\w+?)\}/g,function(e,o){return o.toLowerCase()in n?n[o.toLowerCase()]:e}),function(o,t,n){if(o){var a={TileMatrix:i.getMatrixId(o[0]),TileCol:o[1],TileRow:-o[2]-1};ol.obj.assign(a,l);var s=e;return s=r==ol.source.WMTS.RequestEncoding.KVP?ol.uri.appendParams(s,a):s.replace(/\{(\w+?)\}/g,function(e,o){return a[o]})}}}this.version_=void 0!==e.version?e.version:"1.0.0",this.format_=void 0!==e.format?e.format:"image/jpeg",this.dimensions_=void 0!==e.dimensions?e.dimensions:{},this.layer_=e.layer,this.matrixSet_=e.matrixSet,this.style_=e.style;var t=e.urls;void 0===t&&void 0!==e.url&&(t=ol.TileUrlFunction.expandUrl(e.url)),this.requestEncoding_=void 0!==e.requestEncoding?e.requestEncoding:ol.source.WMTS.RequestEncoding.KVP;var r=this.requestEncoding_,i=e.tileGrid,n={layer:this.layer_,style:this.style_,tilematrixset:this.matrixSet_};r==ol.source.WMTS.RequestEncoding.KVP&&ol.obj.assign(n,{Service:"WMTS",Request:"GetTile",Version:this.version_,Format:this.format_});var l=this.dimensions_,a=t&&t.length>0?ol.TileUrlFunction.createFromTileUrlFunctions(t.map(o)):ol.TileUrlFunction.nullTileUrlFunction;ol.source.TileImage.call(this,{attributions:e.attributions,cacheSize:e.cacheSize,crossOrigin:e.crossOrigin,logo:e.logo,projection:e.projection,reprojectionErrorThreshold:e.reprojectionErrorThreshold,tileClass:e.tileClass,tileGrid:i,tileLoadFunction:e.tileLoadFunction,tilePixelRatio:e.tilePixelRatio,tileUrlFunction:a,urls:t,wrapX:void 0!==e.wrapX&&e.wrapX}),this.setKey(this.getKeyForDimensions_())},ol.inherits(ol.source.WMTS,ol.source.TileImage),ol.source.WMTS.prototype.getDimensions=function(){return this.dimensions_},ol.source.WMTS.prototype.getFormat=function(){return this.format_},ol.source.WMTS.prototype.getLayer=function(){return this.layer_},ol.source.WMTS.prototype.getMatrixSet=function(){return this.matrixSet_},ol.source.WMTS.prototype.getRequestEncoding=function(){return this.requestEncoding_},ol.source.WMTS.prototype.getStyle=function(){return this.style_},ol.source.WMTS.prototype.getVersion=function(){return this.version_},ol.source.WMTS.prototype.getKeyForDimensions_=function(){var e=0,o=[];for(var t in this.dimensions_)o[e++]=t+"-"+this.dimensions_[t];return o.join("/")},ol.source.WMTS.prototype.updateDimensions=function(e){ol.obj.assign(this.dimensions_,e),this.setKey(this.getKeyForDimensions_())},ol.source.WMTS.optionsFromCapabilities=function(e,o){ol.DEBUG&&console.assert(o.layer,'config "layer" must not be null');var t=e.Contents.Layer,r=ol.array.find(t,function(e,t,r){return e.Identifier==o.layer});ol.DEBUG&&console.assert(r,"found a matching layer in Contents/Layer"),ol.DEBUG&&console.assert(r.TileMatrixSetLink.length>0,"layer has TileMatrixSetLink");var i,n,l,a=e.Contents.TileMatrixSet;i=r.TileMatrixSetLink.length>1?"projection"in o?ol.array.findIndex(r.TileMatrixSetLink,function(e,t,r){var i=ol.array.find(a,function(o){return o.Identifier==e.TileMatrixSet}),n=i.SupportedCRS.replace(/urn:ogc:def:crs:(\w+):(.*:)?(\w+)$/,"$1:$3"),l=ol.proj.get(n),s=ol.proj.get(o.projection);return l&&s?ol.proj.equivalent(l,s):n==o.projection}):ol.array.findIndex(r.TileMatrixSetLink,function(e,t,r){return e.TileMatrixSet==o.matrixSet}):0,i<0&&(i=0),n=r.TileMatrixSetLink[i].TileMatrixSet,l=r.TileMatrixSetLink[i].TileMatrixSetLimits,ol.DEBUG&&console.assert(n,"TileMatrixSet must not be null");var s=r.Format[0];"format"in o&&(s=o.format),(i=ol.array.findIndex(r.Style,function(e,t,r){return"style"in o?e.Title==o.style:e.isDefault}))<0&&(i=0);var p=r.Style[i].Identifier,g={};"Dimension"in r&&r.Dimension.forEach(function(e,o,t){var r=e.Identifier,i=e.Default;void 0!==i?ol.DEBUG&&console.assert(ol.array.includes(e.Value,i),"default value contained in values"):i=e.Value[0],ol.DEBUG&&console.assert(void 0!==i,"value could be found"),g[r]=i});var c=e.Contents.TileMatrixSet,u=ol.array.find(c,function(e,o,t){return e.Identifier==n});ol.DEBUG&&console.assert(u,"found matrixSet in Contents/TileMatrixSet");var y;y="projection"in o?ol.proj.get(o.projection):ol.proj.get(u.SupportedCRS.replace(/urn:ogc:def:crs:(\w+):(.*:)?(\w+)$/,"$1:$3"));var d,h,m=r.WGS84BoundingBox;if(void 0!==m){var f=ol.proj.get("EPSG:4326").getExtent();h=m[0]==f[0]&&m[2]==f[2],d=ol.proj.transformExtent(m,"EPSG:4326",y);var _=y.getExtent();_&&(ol.extent.containsExtent(_,d)||(d=void 0))}var E=ol.tilegrid.WMTS.createFromCapabilitiesMatrixSet(u,d,l),v=[],S=o.requestEncoding;if(S=void 0!==S?S:"",ol.DEBUG&&console.assert(ol.array.includes(["REST","RESTful","KVP",""],S),'requestEncoding (%s) is one of "REST", "RESTful", "KVP" or ""',S),"OperationsMetadata"in e&&"GetTile"in e.OperationsMetadata){var x=e.OperationsMetadata.GetTile.DCP.HTTP.Get;ol.DEBUG&&console.assert(x.length>=1);for(var P=0,T=x.length;P<T;++P){var R=ol.array.find(x[P].Constraint,function(e){return"GetEncoding"==e.name}),L=R.AllowedValues.Value;if(ol.DEBUG&&console.assert(L.length>=1),""===S&&(S=L[0]),S!==ol.source.WMTS.RequestEncoding.KVP)break;ol.array.includes(L,ol.source.WMTS.RequestEncoding.KVP)&&v.push(x[P].href)}}return 0===v.length&&(S=ol.source.WMTS.RequestEncoding.REST,r.ResourceURL.forEach(function(e){"tile"===e.resourceType&&(s=e.format,v.push(e.template))})),ol.DEBUG&&console.assert(v.length>0,"At least one URL found"),{urls:v,layer:o.layer,matrixSet:n,format:s,projection:y,requestEncoding:S,tileGrid:E,style:p,dimensions:g,wrapX:h}},ol.source.WMTS.RequestEncoding={KVP:"KVP",REST:"REST"},goog.provide("ol.source.Zoomify"),goog.require("ol"),goog.require("ol.ImageTile"),goog.require("ol.Tile"),goog.require("ol.asserts"),goog.require("ol.dom"),goog.require("ol.extent"),goog.require("ol.source.TileImage"),goog.require("ol.tilegrid.TileGrid"),ol.source.Zoomify=function(e){function o(e,o,t){if(e){var r=e[0],i=e[1],n=-e[2]-1,l=i+n*a[r][0]+d[r],s=l/ol.DEFAULT_TILE_SIZE|0;return f+"TileGroup"+s+"/"+r+"-"+i+"-"+n+".jpg"}}var t=e||{},r=t.size,i=void 0!==t.tierSizeCalculation?t.tierSizeCalculation:ol.source.Zoomify.TierSizeCalculation.DEFAULT,n=r[0],l=r[1],a=[],s=ol.DEFAULT_TILE_SIZE;switch(i){case ol.source.Zoomify.TierSizeCalculation.DEFAULT:for(;n>s||l>s;)a.push([Math.ceil(n/s),Math.ceil(l/s)]),s+=s;break;case ol.source.Zoomify.TierSizeCalculation.TRUNCATED:for(var p=n,g=l;p>s||g>s;)a.push([Math.ceil(p/s),Math.ceil(g/s)]),p>>=1,g>>=1;break;default:ol.asserts.assert(!1,53)}a.push([1,1]),a.reverse();var c,u,y=[1],d=[0];for(c=1,u=a.length;c<u;c++)y.push(1<<c),d.push(a[c-1][0]*a[c-1][1]+d[c-1]);y.reverse();var h=[0,-r[1],r[0],0],m=new ol.tilegrid.TileGrid({extent:h,origin:ol.extent.getTopLeft(h),resolutions:y}),f=t.url;ol.source.TileImage.call(this,{attributions:t.attributions,cacheSize:t.cacheSize,crossOrigin:t.crossOrigin,logo:t.logo,reprojectionErrorThreshold:t.reprojectionErrorThreshold,tileClass:ol.source.Zoomify.Tile_,tileGrid:m,tileUrlFunction:o})},ol.inherits(ol.source.Zoomify,ol.source.TileImage),ol.source.Zoomify.Tile_=function(e,o,t,r,i){ol.ImageTile.call(this,e,o,t,r,i),this.zoomifyImage_=null},ol.inherits(ol.source.Zoomify.Tile_,ol.ImageTile),ol.source.Zoomify.Tile_.prototype.getImage=function(){if(this.zoomifyImage_)return this.zoomifyImage_;var e=ol.DEFAULT_TILE_SIZE,o=ol.ImageTile.prototype.getImage.call(this);if(this.state==ol.Tile.State.LOADED){if(o.width==e&&o.height==e)return this.zoomifyImage_=o,o;var t=ol.dom.createCanvasContext2D(e,e);return t.drawImage(o,0,0),this.zoomifyImage_=t.canvas,t.canvas}return o},ol.source.Zoomify.TierSizeCalculation={DEFAULT:"default",TRUNCATED:"truncated"},goog.provide("ol.style.Atlas"),goog.require("ol"),goog.require("ol.dom"),ol.style.Atlas=function(e,o){this.space_=o,this.emptyBlocks_=[{x:0,y:0,width:e,height:e}],this.entries_={},this.context_=ol.dom.createCanvasContext2D(e,e),this.canvas_=this.context_.canvas},ol.style.Atlas.prototype.get=function(e){return this.entries_[e]||null},ol.style.Atlas.prototype.add=function(e,o,t,r,i){var n,l,a;for(l=0,a=this.emptyBlocks_.length;l<a;++l)if(n=this.emptyBlocks_[l],n.width>=o+this.space_&&n.height>=t+this.space_){var s={offsetX:n.x+this.space_,offsetY:n.y+this.space_,image:this.canvas_};return this.entries_[e]=s,r.call(i,this.context_,n.x+this.space_,n.y+this.space_),this.split_(l,n,o+this.space_,t+this.space_),s}return null},ol.style.Atlas.prototype.split_=function(e,o,t,r){var i,n,l=o.width-t,a=o.height-r;l>a?(i={x:o.x+t,y:o.y,width:o.width-t,height:o.height},n={x:o.x,y:o.y+r,width:t,height:o.height-r},this.updateBlocks_(e,i,n)):(i={x:o.x+t,y:o.y,width:o.width-t,height:r},n={x:o.x,y:o.y+r,width:o.width,height:o.height-r},this.updateBlocks_(e,i,n))},ol.style.Atlas.prototype.updateBlocks_=function(e,o,t){var r=[e,1];o.width>0&&o.height>0&&r.push(o),t.width>0&&t.height>0&&r.push(t),this.emptyBlocks_.splice.apply(this.emptyBlocks_,r)},goog.provide("ol.style.AtlasManager"),goog.require("ol"),goog.require("ol.style.Atlas"),ol.style.AtlasManager=function(e){var o=e||{};this.currentSize_=void 0!==o.initialSize?o.initialSize:ol.INITIAL_ATLAS_SIZE,this.maxSize_=void 0!==o.maxSize?o.maxSize:-1!=ol.MAX_ATLAS_SIZE?ol.MAX_ATLAS_SIZE:void 0!==ol.WEBGL_MAX_TEXTURE_SIZE?ol.WEBGL_MAX_TEXTURE_SIZE:2048,this.space_=void 0!==o.space?o.space:1,this.atlases_=[new ol.style.Atlas(this.currentSize_,this.space_)],this.currentHitSize_=this.currentSize_,this.hitAtlases_=[new ol.style.Atlas(this.currentHitSize_,this.space_)]},ol.style.AtlasManager.prototype.getInfo=function(e){var o=this.getInfo_(this.atlases_,e);if(!o)return null;var t=this.getInfo_(this.hitAtlases_,e);return this.mergeInfos_(o,t)},ol.style.AtlasManager.prototype.getInfo_=function(e,o){var t,r,i,n;for(i=0,n=e.length;i<n;++i)if(t=e[i],r=t.get(o))return r;return null},ol.style.AtlasManager.prototype.mergeInfos_=function(e,o){return ol.DEBUG&&console.assert(e.offsetX===o.offsetX,"in order to merge, offsetX of info and hitInfo must be equal"),ol.DEBUG&&console.assert(e.offsetY===o.offsetY,"in order to merge, offsetY of info and hitInfo must be equal"),{offsetX:e.offsetX,offsetY:e.offsetY,image:e.image,hitImage:o.image}},ol.style.AtlasManager.prototype.add=function(e,o,t,r,i,n){if(o+this.space_>this.maxSize_||t+this.space_>this.maxSize_)return null;var l=this.add_(!1,e,o,t,r,n);if(!l)return null;var a=void 0!==i?i:ol.nullFunction,s=this.add_(!0,e,o,t,a,n);return this.mergeInfos_(l,s)},ol.style.AtlasManager.prototype.add_=function(e,o,t,r,i,n){var l,a,s,p,g=e?this.hitAtlases_:this.atlases_;for(s=0,p=g.length;s<p;++s){if(l=g[s],a=l.add(o,t,r,i,n))return a;if(!a&&s===p-1){var c;e?(c=Math.min(2*this.currentHitSize_,this.maxSize_),this.currentHitSize_=c):(c=Math.min(2*this.currentSize_,this.maxSize_),this.currentSize_=c),
l=new ol.style.Atlas(c,this.space_),g.push(l),++p}}return ol.DEBUG&&console.assert(!1,"Failed to add to atlasmanager"),null},goog.addDependency("demos/editor/equationeditor.js",["goog.demos.editor.EquationEditor"],["goog.ui.equation.EquationEditorDialog"]),goog.addDependency("demos/editor/helloworld.js",["goog.demos.editor.HelloWorld"],["goog.dom","goog.dom.TagName","goog.editor.Plugin"]),goog.addDependency("demos/editor/helloworlddialog.js",["goog.demos.editor.HelloWorldDialog","goog.demos.editor.HelloWorldDialog.OkEvent"],["goog.dom.TagName","goog.events.Event","goog.string","goog.ui.editor.AbstractDialog","goog.ui.editor.AbstractDialog.Builder","goog.ui.editor.AbstractDialog.EventType"]),goog.addDependency("demos/editor/helloworlddialogplugin.js",["goog.demos.editor.HelloWorldDialogPlugin","goog.demos.editor.HelloWorldDialogPlugin.Command"],["goog.demos.editor.HelloWorldDialog","goog.dom.TagName","goog.editor.plugins.AbstractDialogPlugin","goog.editor.range","goog.functions","goog.ui.editor.AbstractDialog.EventType"]),goog.require("ol"),goog.require("ol.AssertionError"),goog.require("ol.Attribution"),goog.require("ol.Collection"),goog.require("ol.DeviceOrientation"),goog.require("ol.Feature"),goog.require("ol.Geolocation"),goog.require("ol.Graticule"),goog.require("ol.Image"),goog.require("ol.ImageTile"),goog.require("ol.Kinetic"),goog.require("ol.Map"),goog.require("ol.MapBrowserEvent"),goog.require("ol.MapEvent"),goog.require("ol.Object"),goog.require("ol.Observable"),goog.require("ol.Overlay"),goog.require("ol.Sphere"),goog.require("ol.Tile"),goog.require("ol.VectorTile"),goog.require("ol.View"),goog.require("ol.animation"),goog.require("ol.color"),goog.require("ol.colorlike"),goog.require("ol.control"),goog.require("ol.control.Attribution"),goog.require("ol.control.Control"),goog.require("ol.control.FullScreen"),goog.require("ol.control.MousePosition"),goog.require("ol.control.OverviewMap"),goog.require("ol.control.Rotate"),goog.require("ol.control.ScaleLine"),goog.require("ol.control.Zoom"),goog.require("ol.control.ZoomSlider"),goog.require("ol.control.ZoomToExtent"),goog.require("ol.coordinate"),goog.require("ol.easing"),goog.require("ol.events.Event"),goog.require("ol.events.condition"),goog.require("ol.extent"),goog.require("ol.featureloader"),goog.require("ol.format.EsriJSON"),goog.require("ol.format.Feature"),goog.require("ol.format.GML"),goog.require("ol.format.GML2"),goog.require("ol.format.GML3"),goog.require("ol.format.GMLBase"),goog.require("ol.format.GPX"),goog.require("ol.format.GeoJSON"),goog.require("ol.format.IGC"),goog.require("ol.format.KML"),goog.require("ol.format.MVT"),goog.require("ol.format.OSMXML"),goog.require("ol.format.Polyline"),goog.require("ol.format.TopoJSON"),goog.require("ol.format.WFS"),goog.require("ol.format.WKT"),goog.require("ol.format.WMSCapabilities"),goog.require("ol.format.WMSGetFeatureInfo"),goog.require("ol.format.WMTSCapabilities"),goog.require("ol.format.filter"),goog.require("ol.format.filter.And"),goog.require("ol.format.filter.Bbox"),goog.require("ol.format.filter.Comparison"),goog.require("ol.format.filter.ComparisonBinary"),goog.require("ol.format.filter.EqualTo"),goog.require("ol.format.filter.Filter"),goog.require("ol.format.filter.GreaterThan"),goog.require("ol.format.filter.GreaterThanOrEqualTo"),goog.require("ol.format.filter.Intersects"),goog.require("ol.format.filter.IsBetween"),goog.require("ol.format.filter.IsLike");goog.require("ol.format.filter.IsNull"),goog.require("ol.format.filter.LessThan"),goog.require("ol.format.filter.LessThanOrEqualTo"),goog.require("ol.format.filter.Not"),goog.require("ol.format.filter.NotEqualTo"),goog.require("ol.format.filter.Or"),goog.require("ol.format.filter.Spatial"),goog.require("ol.format.filter.Within"),goog.require("ol.geom.Circle"),goog.require("ol.geom.Geometry"),goog.require("ol.geom.GeometryCollection"),goog.require("ol.geom.LineString"),goog.require("ol.geom.LinearRing"),goog.require("ol.geom.MultiLineString"),goog.require("ol.geom.MultiPoint"),goog.require("ol.geom.MultiPolygon"),goog.require("ol.geom.Point"),goog.require("ol.geom.Polygon"),goog.require("ol.geom.SimpleGeometry"),goog.require("ol.has"),goog.require("ol.interaction"),goog.require("ol.interaction.DoubleClickZoom"),goog.require("ol.interaction.DragAndDrop"),goog.require("ol.interaction.DragBox"),goog.require("ol.interaction.DragPan"),goog.require("ol.interaction.DragRotate"),goog.require("ol.interaction.DragRotateAndZoom"),goog.require("ol.interaction.DragZoom"),goog.require("ol.interaction.Draw"),goog.require("ol.interaction.Extent"),goog.require("ol.interaction.Interaction"),goog.require("ol.interaction.KeyboardPan"),goog.require("ol.interaction.KeyboardZoom"),goog.require("ol.interaction.Modify"),goog.require("ol.interaction.MouseWheelZoom"),goog.require("ol.interaction.PinchRotate"),goog.require("ol.interaction.PinchZoom"),goog.require("ol.interaction.Pointer"),goog.require("ol.interaction.Select"),goog.require("ol.interaction.Snap"),goog.require("ol.interaction.Translate"),goog.require("ol.layer.Base"),goog.require("ol.layer.Group"),goog.require("ol.layer.Heatmap"),goog.require("ol.layer.Image"),goog.require("ol.layer.Layer"),goog.require("ol.layer.Tile"),goog.require("ol.layer.Vector"),goog.require("ol.layer.VectorTile"),goog.require("ol.loadingstrategy"),goog.require("ol.proj"),goog.require("ol.proj.Projection"),goog.require("ol.proj.Units"),goog.require("ol.proj.common"),goog.require("ol.render"),goog.require("ol.render.Event"),goog.require("ol.render.Feature"),goog.require("ol.render.VectorContext"),goog.require("ol.render.canvas.Immediate"),goog.require("ol.render.webgl.Immediate"),goog.require("ol.size"),goog.require("ol.source.BingMaps"),goog.require("ol.source.CartoDB"),goog.require("ol.source.Cluster"),goog.require("ol.source.Image"),goog.require("ol.source.ImageArcGISRest"),goog.require("ol.source.ImageCanvas"),goog.require("ol.source.ImageMapGuide"),goog.require("ol.source.ImageStatic"),goog.require("ol.source.ImageVector"),goog.require("ol.source.ImageWMS"),goog.require("ol.source.OSM"),goog.require("ol.source.Raster"),goog.require("ol.source.Source"),goog.require("ol.source.Stamen"),goog.require("ol.source.Tile"),goog.require("ol.source.TileArcGISRest"),goog.require("ol.source.TileDebug"),goog.require("ol.source.TileImage"),goog.require("ol.source.TileJSON"),goog.require("ol.source.TileUTFGrid"),goog.require("ol.source.TileWMS"),goog.require("ol.source.UrlTile"),goog.require("ol.source.Vector"),goog.require("ol.source.VectorTile"),goog.require("ol.source.WMTS"),goog.require("ol.source.XYZ"),goog.require("ol.source.Zoomify"),goog.require("ol.style.AtlasManager"),goog.require("ol.style.Circle"),goog.require("ol.style.Fill"),goog.require("ol.style.Icon"),goog.require("ol.style.Image"),goog.require("ol.style.RegularShape"),goog.require("ol.style.Stroke"),goog.require("ol.style.Style"),goog.require("ol.style.Text"),goog.require("ol.tilegrid"),goog.require("ol.tilegrid.TileGrid"),goog.require("ol.tilegrid.WMTS"),goog.require("ol.webgl.Context"),goog.require("ol.xml"),goog.exportSymbol("ol.animation.bounce",ol.animation.bounce,OPENLAYERS),goog.exportSymbol("ol.animation.pan",ol.animation.pan,OPENLAYERS),goog.exportSymbol("ol.animation.rotate",ol.animation.rotate,OPENLAYERS),goog.exportSymbol("ol.animation.zoom",ol.animation.zoom,OPENLAYERS),goog.exportProperty(ol.AssertionError.prototype,"code",ol.AssertionError.prototype.code),goog.exportSymbol("ol.Attribution",ol.Attribution,OPENLAYERS),goog.exportProperty(ol.Attribution.prototype,"getHTML",ol.Attribution.prototype.getHTML),goog.exportSymbol("ol.Collection",ol.Collection,OPENLAYERS),goog.exportProperty(ol.Collection.prototype,"clear",ol.Collection.prototype.clear),goog.exportProperty(ol.Collection.prototype,"extend",ol.Collection.prototype.extend),goog.exportProperty(ol.Collection.prototype,"forEach",ol.Collection.prototype.forEach),goog.exportProperty(ol.Collection.prototype,"getArray",ol.Collection.prototype.getArray),goog.exportProperty(ol.Collection.prototype,"item",ol.Collection.prototype.item),goog.exportProperty(ol.Collection.prototype,"getLength",ol.Collection.prototype.getLength),goog.exportProperty(ol.Collection.prototype,"insertAt",ol.Collection.prototype.insertAt),goog.exportProperty(ol.Collection.prototype,"pop",ol.Collection.prototype.pop),goog.exportProperty(ol.Collection.prototype,"push",ol.Collection.prototype.push),goog.exportProperty(ol.Collection.prototype,"remove",ol.Collection.prototype.remove),goog.exportProperty(ol.Collection.prototype,"removeAt",ol.Collection.prototype.removeAt),goog.exportProperty(ol.Collection.prototype,"setAt",ol.Collection.prototype.setAt),goog.exportProperty(ol.Collection.Event.prototype,"element",ol.Collection.Event.prototype.element),goog.exportSymbol("ol.color.asArray",ol.color.asArray,OPENLAYERS),goog.exportSymbol("ol.color.asString",ol.color.asString,OPENLAYERS),goog.exportSymbol("ol.colorlike.asColorLike",ol.colorlike.asColorLike,OPENLAYERS),goog.exportSymbol("ol.coordinate.add",ol.coordinate.add,OPENLAYERS),goog.exportSymbol("ol.coordinate.createStringXY",ol.coordinate.createStringXY,OPENLAYERS),goog.exportSymbol("ol.coordinate.format",ol.coordinate.format,OPENLAYERS),goog.exportSymbol("ol.coordinate.rotate",ol.coordinate.rotate,OPENLAYERS),goog.exportSymbol("ol.coordinate.toStringHDMS",ol.coordinate.toStringHDMS,OPENLAYERS),goog.exportSymbol("ol.coordinate.toStringXY",ol.coordinate.toStringXY,OPENLAYERS),goog.exportSymbol("ol.DeviceOrientation",ol.DeviceOrientation,OPENLAYERS),goog.exportProperty(ol.DeviceOrientation.prototype,"getAlpha",ol.DeviceOrientation.prototype.getAlpha),goog.exportProperty(ol.DeviceOrientation.prototype,"getBeta",ol.DeviceOrientation.prototype.getBeta),goog.exportProperty(ol.DeviceOrientation.prototype,"getGamma",ol.DeviceOrientation.prototype.getGamma),goog.exportProperty(ol.DeviceOrientation.prototype,"getHeading",ol.DeviceOrientation.prototype.getHeading),goog.exportProperty(ol.DeviceOrientation.prototype,"getTracking",ol.DeviceOrientation.prototype.getTracking),goog.exportProperty(ol.DeviceOrientation.prototype,"setTracking",ol.DeviceOrientation.prototype.setTracking),goog.exportSymbol("ol.easing.easeIn",ol.easing.easeIn,OPENLAYERS),goog.exportSymbol("ol.easing.easeOut",ol.easing.easeOut,OPENLAYERS),goog.exportSymbol("ol.easing.inAndOut",ol.easing.inAndOut,OPENLAYERS),goog.exportSymbol("ol.easing.linear",ol.easing.linear,OPENLAYERS),goog.exportSymbol("ol.easing.upAndDown",ol.easing.upAndDown,OPENLAYERS),goog.exportSymbol("ol.Feature",ol.Feature,OPENLAYERS),goog.exportProperty(ol.Feature.prototype,"clone",ol.Feature.prototype.clone),goog.exportProperty(ol.Feature.prototype,"getGeometry",ol.Feature.prototype.getGeometry),goog.exportProperty(ol.Feature.prototype,"getId",ol.Feature.prototype.getId),goog.exportProperty(ol.Feature.prototype,"getGeometryName",ol.Feature.prototype.getGeometryName),goog.exportProperty(ol.Feature.prototype,"getStyle",ol.Feature.prototype.getStyle),goog.exportProperty(ol.Feature.prototype,"getStyleFunction",ol.Feature.prototype.getStyleFunction),goog.exportProperty(ol.Feature.prototype,"setGeometry",ol.Feature.prototype.setGeometry),goog.exportProperty(ol.Feature.prototype,"setStyle",ol.Feature.prototype.setStyle),goog.exportProperty(ol.Feature.prototype,"setId",ol.Feature.prototype.setId),goog.exportProperty(ol.Feature.prototype,"setGeometryName",ol.Feature.prototype.setGeometryName),goog.exportSymbol("ol.featureloader.xhr",ol.featureloader.xhr,OPENLAYERS),goog.exportSymbol("ol.Geolocation",ol.Geolocation,OPENLAYERS),goog.exportProperty(ol.Geolocation.prototype,"getAccuracy",ol.Geolocation.prototype.getAccuracy),goog.exportProperty(ol.Geolocation.prototype,"getAccuracyGeometry",ol.Geolocation.prototype.getAccuracyGeometry),goog.exportProperty(ol.Geolocation.prototype,"getAltitude",ol.Geolocation.prototype.getAltitude),goog.exportProperty(ol.Geolocation.prototype,"getAltitudeAccuracy",ol.Geolocation.prototype.getAltitudeAccuracy),goog.exportProperty(ol.Geolocation.prototype,"getHeading",ol.Geolocation.prototype.getHeading),goog.exportProperty(ol.Geolocation.prototype,"getPosition",ol.Geolocation.prototype.getPosition),goog.exportProperty(ol.Geolocation.prototype,"getProjection",ol.Geolocation.prototype.getProjection),goog.exportProperty(ol.Geolocation.prototype,"getSpeed",ol.Geolocation.prototype.getSpeed),goog.exportProperty(ol.Geolocation.prototype,"getTracking",ol.Geolocation.prototype.getTracking),goog.exportProperty(ol.Geolocation.prototype,"getTrackingOptions",ol.Geolocation.prototype.getTrackingOptions),goog.exportProperty(ol.Geolocation.prototype,"setProjection",ol.Geolocation.prototype.setProjection),goog.exportProperty(ol.Geolocation.prototype,"setTracking",ol.Geolocation.prototype.setTracking),goog.exportProperty(ol.Geolocation.prototype,"setTrackingOptions",ol.Geolocation.prototype.setTrackingOptions),goog.exportSymbol("ol.Graticule",ol.Graticule,OPENLAYERS),goog.exportProperty(ol.Graticule.prototype,"getMap",ol.Graticule.prototype.getMap),goog.exportProperty(ol.Graticule.prototype,"getMeridians",ol.Graticule.prototype.getMeridians),goog.exportProperty(ol.Graticule.prototype,"getParallels",ol.Graticule.prototype.getParallels),goog.exportProperty(ol.Graticule.prototype,"setMap",ol.Graticule.prototype.setMap),goog.exportSymbol("ol.has.DEVICE_PIXEL_RATIO",ol.has.DEVICE_PIXEL_RATIO,OPENLAYERS),goog.exportSymbol("ol.has.CANVAS",ol.has.CANVAS,OPENLAYERS),goog.exportSymbol("ol.has.DEVICE_ORIENTATION",ol.has.DEVICE_ORIENTATION,OPENLAYERS),goog.exportSymbol("ol.has.GEOLOCATION",ol.has.GEOLOCATION,OPENLAYERS),goog.exportSymbol("ol.has.TOUCH",ol.has.TOUCH,OPENLAYERS),goog.exportSymbol("ol.has.WEBGL",ol.has.WEBGL,OPENLAYERS),goog.exportProperty(ol.Image.prototype,"getImage",ol.Image.prototype.getImage),goog.exportProperty(ol.Image.prototype,"load",ol.Image.prototype.load),goog.exportProperty(ol.ImageTile.prototype,"getImage",ol.ImageTile.prototype.getImage),goog.exportProperty(ol.ImageTile.prototype,"load",ol.ImageTile.prototype.load),goog.exportSymbol("ol.inherits",ol.inherits,OPENLAYERS),goog.exportSymbol("ol.Kinetic",ol.Kinetic,OPENLAYERS),goog.exportSymbol("ol.loadingstrategy.all",ol.loadingstrategy.all,OPENLAYERS),goog.exportSymbol("ol.loadingstrategy.bbox",ol.loadingstrategy.bbox,OPENLAYERS),goog.exportSymbol("ol.loadingstrategy.tile",ol.loadingstrategy.tile,OPENLAYERS),goog.exportSymbol("ol.Map",ol.Map,OPENLAYERS),goog.exportProperty(ol.Map.prototype,"addControl",ol.Map.prototype.addControl),goog.exportProperty(ol.Map.prototype,"addInteraction",ol.Map.prototype.addInteraction),goog.exportProperty(ol.Map.prototype,"addLayer",ol.Map.prototype.addLayer),goog.exportProperty(ol.Map.prototype,"addOverlay",ol.Map.prototype.addOverlay),goog.exportProperty(ol.Map.prototype,"beforeRender",ol.Map.prototype.beforeRender),goog.exportProperty(ol.Map.prototype,"forEachFeatureAtPixel",ol.Map.prototype.forEachFeatureAtPixel),goog.exportProperty(ol.Map.prototype,"forEachLayerAtPixel",ol.Map.prototype.forEachLayerAtPixel),goog.exportProperty(ol.Map.prototype,"hasFeatureAtPixel",ol.Map.prototype.hasFeatureAtPixel),goog.exportProperty(ol.Map.prototype,"getEventCoordinate",ol.Map.prototype.getEventCoordinate);goog.exportProperty(ol.Map.prototype,"getEventPixel",ol.Map.prototype.getEventPixel),goog.exportProperty(ol.Map.prototype,"getTarget",ol.Map.prototype.getTarget),goog.exportProperty(ol.Map.prototype,"getTargetElement",ol.Map.prototype.getTargetElement),goog.exportProperty(ol.Map.prototype,"getCoordinateFromPixel",ol.Map.prototype.getCoordinateFromPixel),goog.exportProperty(ol.Map.prototype,"getControls",ol.Map.prototype.getControls),goog.exportProperty(ol.Map.prototype,"getOverlays",ol.Map.prototype.getOverlays),goog.exportProperty(ol.Map.prototype,"getOverlayById",ol.Map.prototype.getOverlayById),goog.exportProperty(ol.Map.prototype,"getInteractions",ol.Map.prototype.getInteractions),goog.exportProperty(ol.Map.prototype,"getLayerGroup",ol.Map.prototype.getLayerGroup),goog.exportProperty(ol.Map.prototype,"getLayers",ol.Map.prototype.getLayers),goog.exportProperty(ol.Map.prototype,"getPixelFromCoordinate",ol.Map.prototype.getPixelFromCoordinate),goog.exportProperty(ol.Map.prototype,"getSize",ol.Map.prototype.getSize),goog.exportProperty(ol.Map.prototype,"getView",ol.Map.prototype.getView),goog.exportProperty(ol.Map.prototype,"getViewport",ol.Map.prototype.getViewport),goog.exportProperty(ol.Map.prototype,"renderSync",ol.Map.prototype.renderSync),goog.exportProperty(ol.Map.prototype,"render",ol.Map.prototype.render),goog.exportProperty(ol.Map.prototype,"removeControl",ol.Map.prototype.removeControl),goog.exportProperty(ol.Map.prototype,"removeInteraction",ol.Map.prototype.removeInteraction),goog.exportProperty(ol.Map.prototype,"removeLayer",ol.Map.prototype.removeLayer),goog.exportProperty(ol.Map.prototype,"removeOverlay",ol.Map.prototype.removeOverlay),goog.exportProperty(ol.Map.prototype,"setLayerGroup",ol.Map.prototype.setLayerGroup),goog.exportProperty(ol.Map.prototype,"setSize",ol.Map.prototype.setSize),goog.exportProperty(ol.Map.prototype,"setTarget",ol.Map.prototype.setTarget),goog.exportProperty(ol.Map.prototype,"setView",ol.Map.prototype.setView),goog.exportProperty(ol.Map.prototype,"updateSize",ol.Map.prototype.updateSize),goog.exportProperty(ol.MapBrowserEvent.prototype,"originalEvent",ol.MapBrowserEvent.prototype.originalEvent),goog.exportProperty(ol.MapBrowserEvent.prototype,"pixel",ol.MapBrowserEvent.prototype.pixel),goog.exportProperty(ol.MapBrowserEvent.prototype,"coordinate",ol.MapBrowserEvent.prototype.coordinate),goog.exportProperty(ol.MapBrowserEvent.prototype,"dragging",ol.MapBrowserEvent.prototype.dragging),goog.exportProperty(ol.MapEvent.prototype,"map",ol.MapEvent.prototype.map),goog.exportProperty(ol.MapEvent.prototype,"frameState",ol.MapEvent.prototype.frameState),goog.exportSymbol("ol.Object",ol.Object,OPENLAYERS),goog.exportProperty(ol.Object.prototype,"get",ol.Object.prototype.get),goog.exportProperty(ol.Object.prototype,"getKeys",ol.Object.prototype.getKeys),goog.exportProperty(ol.Object.prototype,"getProperties",ol.Object.prototype.getProperties),goog.exportProperty(ol.Object.prototype,"set",ol.Object.prototype.set),goog.exportProperty(ol.Object.prototype,"setProperties",ol.Object.prototype.setProperties),goog.exportProperty(ol.Object.prototype,"unset",ol.Object.prototype.unset),goog.exportProperty(ol.Object.Event.prototype,"key",ol.Object.Event.prototype.key),goog.exportProperty(ol.Object.Event.prototype,"oldValue",ol.Object.Event.prototype.oldValue),goog.exportSymbol("ol.Observable",ol.Observable,OPENLAYERS),goog.exportSymbol("ol.Observable.unByKey",ol.Observable.unByKey,OPENLAYERS),goog.exportProperty(ol.Observable.prototype,"changed",ol.Observable.prototype.changed),goog.exportProperty(ol.Observable.prototype,"dispatchEvent",ol.Observable.prototype.dispatchEvent),goog.exportProperty(ol.Observable.prototype,"getRevision",ol.Observable.prototype.getRevision),goog.exportProperty(ol.Observable.prototype,"on",ol.Observable.prototype.on),goog.exportProperty(ol.Observable.prototype,"once",ol.Observable.prototype.once),goog.exportProperty(ol.Observable.prototype,"un",ol.Observable.prototype.un),goog.exportProperty(ol.Observable.prototype,"unByKey",ol.Observable.prototype.unByKey),goog.exportSymbol("ol.Overlay",ol.Overlay,OPENLAYERS),goog.exportProperty(ol.Overlay.prototype,"getElement",ol.Overlay.prototype.getElement),goog.exportProperty(ol.Overlay.prototype,"getId",ol.Overlay.prototype.getId),goog.exportProperty(ol.Overlay.prototype,"getMap",ol.Overlay.prototype.getMap),goog.exportProperty(ol.Overlay.prototype,"getOffset",ol.Overlay.prototype.getOffset),goog.exportProperty(ol.Overlay.prototype,"getPosition",ol.Overlay.prototype.getPosition),goog.exportProperty(ol.Overlay.prototype,"getPositioning",ol.Overlay.prototype.getPositioning),goog.exportProperty(ol.Overlay.prototype,"setElement",ol.Overlay.prototype.setElement),goog.exportProperty(ol.Overlay.prototype,"setMap",ol.Overlay.prototype.setMap),goog.exportProperty(ol.Overlay.prototype,"setOffset",ol.Overlay.prototype.setOffset),goog.exportProperty(ol.Overlay.prototype,"setPosition",ol.Overlay.prototype.setPosition),goog.exportProperty(ol.Overlay.prototype,"setPositioning",ol.Overlay.prototype.setPositioning),goog.exportSymbol("ol.render.toContext",ol.render.toContext,OPENLAYERS),goog.exportSymbol("ol.size.toSize",ol.size.toSize,OPENLAYERS),goog.exportProperty(ol.Tile.prototype,"getTileCoord",ol.Tile.prototype.getTileCoord),goog.exportProperty(ol.Tile.prototype,"load",ol.Tile.prototype.load),goog.exportProperty(ol.VectorTile.prototype,"getFormat",ol.VectorTile.prototype.getFormat),goog.exportProperty(ol.VectorTile.prototype,"setFeatures",ol.VectorTile.prototype.setFeatures),goog.exportProperty(ol.VectorTile.prototype,"setProjection",ol.VectorTile.prototype.setProjection),goog.exportProperty(ol.VectorTile.prototype,"setLoader",ol.VectorTile.prototype.setLoader),goog.exportSymbol("ol.View",ol.View,OPENLAYERS),goog.exportProperty(ol.View.prototype,"animate",ol.View.prototype.animate),goog.exportProperty(ol.View.prototype,"constrainCenter",ol.View.prototype.constrainCenter),goog.exportProperty(ol.View.prototype,"constrainResolution",ol.View.prototype.constrainResolution),goog.exportProperty(ol.View.prototype,"constrainRotation",ol.View.prototype.constrainRotation),goog.exportProperty(ol.View.prototype,"getCenter",ol.View.prototype.getCenter),goog.exportProperty(ol.View.prototype,"calculateExtent",ol.View.prototype.calculateExtent),goog.exportProperty(ol.View.prototype,"getMaxResolution",ol.View.prototype.getMaxResolution),goog.exportProperty(ol.View.prototype,"getMinResolution",ol.View.prototype.getMinResolution),goog.exportProperty(ol.View.prototype,"getProjection",ol.View.prototype.getProjection),goog.exportProperty(ol.View.prototype,"getResolution",ol.View.prototype.getResolution),goog.exportProperty(ol.View.prototype,"getResolutions",ol.View.prototype.getResolutions),goog.exportProperty(ol.View.prototype,"getRotation",ol.View.prototype.getRotation),goog.exportProperty(ol.View.prototype,"getZoom",ol.View.prototype.getZoom),goog.exportProperty(ol.View.prototype,"fit",ol.View.prototype.fit),goog.exportProperty(ol.View.prototype,"centerOn",ol.View.prototype.centerOn),goog.exportProperty(ol.View.prototype,"rotate",ol.View.prototype.rotate),goog.exportProperty(ol.View.prototype,"setCenter",ol.View.prototype.setCenter),goog.exportProperty(ol.View.prototype,"setResolution",ol.View.prototype.setResolution),goog.exportProperty(ol.View.prototype,"setRotation",ol.View.prototype.setRotation),goog.exportProperty(ol.View.prototype,"setZoom",ol.View.prototype.setZoom),goog.exportSymbol("ol.xml.getAllTextContent",ol.xml.getAllTextContent,OPENLAYERS),goog.exportSymbol("ol.xml.parse",ol.xml.parse,OPENLAYERS),goog.exportProperty(ol.webgl.Context.prototype,"getGL",ol.webgl.Context.prototype.getGL),goog.exportProperty(ol.webgl.Context.prototype,"useProgram",ol.webgl.Context.prototype.useProgram),goog.exportSymbol("ol.tilegrid.createXYZ",ol.tilegrid.createXYZ,OPENLAYERS),goog.exportSymbol("ol.tilegrid.TileGrid",ol.tilegrid.TileGrid,OPENLAYERS),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"forEachTileCoord",ol.tilegrid.TileGrid.prototype.forEachTileCoord),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"getMaxZoom",ol.tilegrid.TileGrid.prototype.getMaxZoom),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"getMinZoom",ol.tilegrid.TileGrid.prototype.getMinZoom),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"getOrigin",ol.tilegrid.TileGrid.prototype.getOrigin),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"getResolution",ol.tilegrid.TileGrid.prototype.getResolution),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"getResolutions",ol.tilegrid.TileGrid.prototype.getResolutions),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"getTileCoordExtent",ol.tilegrid.TileGrid.prototype.getTileCoordExtent),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"getTileCoordForCoordAndResolution",ol.tilegrid.TileGrid.prototype.getTileCoordForCoordAndResolution),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"getTileCoordForCoordAndZ",ol.tilegrid.TileGrid.prototype.getTileCoordForCoordAndZ),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"getTileSize",ol.tilegrid.TileGrid.prototype.getTileSize),goog.exportProperty(ol.tilegrid.TileGrid.prototype,"getZForResolution",ol.tilegrid.TileGrid.prototype.getZForResolution),goog.exportSymbol("ol.tilegrid.WMTS",ol.tilegrid.WMTS,OPENLAYERS),goog.exportProperty(ol.tilegrid.WMTS.prototype,"getMatrixIds",ol.tilegrid.WMTS.prototype.getMatrixIds),goog.exportSymbol("ol.tilegrid.WMTS.createFromCapabilitiesMatrixSet",ol.tilegrid.WMTS.createFromCapabilitiesMatrixSet,OPENLAYERS),goog.exportSymbol("ol.style.AtlasManager",ol.style.AtlasManager,OPENLAYERS),goog.exportSymbol("ol.style.Circle",ol.style.Circle,OPENLAYERS),goog.exportProperty(ol.style.Circle.prototype,"clone",ol.style.Circle.prototype.clone),goog.exportProperty(ol.style.Circle.prototype,"setRadius",ol.style.Circle.prototype.setRadius),goog.exportSymbol("ol.style.Fill",ol.style.Fill,OPENLAYERS),goog.exportProperty(ol.style.Fill.prototype,"clone",ol.style.Fill.prototype.clone),goog.exportProperty(ol.style.Fill.prototype,"getColor",ol.style.Fill.prototype.getColor),goog.exportProperty(ol.style.Fill.prototype,"setColor",ol.style.Fill.prototype.setColor),goog.exportSymbol("ol.style.Icon",ol.style.Icon,OPENLAYERS),goog.exportProperty(ol.style.Icon.prototype,"clone",ol.style.Icon.prototype.clone),goog.exportProperty(ol.style.Icon.prototype,"getAnchor",ol.style.Icon.prototype.getAnchor),goog.exportProperty(ol.style.Icon.prototype,"getColor",ol.style.Icon.prototype.getColor),goog.exportProperty(ol.style.Icon.prototype,"getImage",ol.style.Icon.prototype.getImage),goog.exportProperty(ol.style.Icon.prototype,"getOrigin",ol.style.Icon.prototype.getOrigin),goog.exportProperty(ol.style.Icon.prototype,"getSrc",ol.style.Icon.prototype.getSrc),goog.exportProperty(ol.style.Icon.prototype,"getSize",ol.style.Icon.prototype.getSize),goog.exportProperty(ol.style.Icon.prototype,"load",ol.style.Icon.prototype.load),goog.exportSymbol("ol.style.Image",ol.style.Image,OPENLAYERS),goog.exportProperty(ol.style.Image.prototype,"getOpacity",ol.style.Image.prototype.getOpacity),goog.exportProperty(ol.style.Image.prototype,"getRotateWithView",ol.style.Image.prototype.getRotateWithView),goog.exportProperty(ol.style.Image.prototype,"getRotation",ol.style.Image.prototype.getRotation),goog.exportProperty(ol.style.Image.prototype,"getScale",ol.style.Image.prototype.getScale),goog.exportProperty(ol.style.Image.prototype,"getSnapToPixel",ol.style.Image.prototype.getSnapToPixel),goog.exportProperty(ol.style.Image.prototype,"setOpacity",ol.style.Image.prototype.setOpacity),goog.exportProperty(ol.style.Image.prototype,"setRotation",ol.style.Image.prototype.setRotation),goog.exportProperty(ol.style.Image.prototype,"setScale",ol.style.Image.prototype.setScale),goog.exportSymbol("ol.style.RegularShape",ol.style.RegularShape,OPENLAYERS),goog.exportProperty(ol.style.RegularShape.prototype,"clone",ol.style.RegularShape.prototype.clone),goog.exportProperty(ol.style.RegularShape.prototype,"getAnchor",ol.style.RegularShape.prototype.getAnchor),goog.exportProperty(ol.style.RegularShape.prototype,"getAngle",ol.style.RegularShape.prototype.getAngle),goog.exportProperty(ol.style.RegularShape.prototype,"getFill",ol.style.RegularShape.prototype.getFill),goog.exportProperty(ol.style.RegularShape.prototype,"getImage",ol.style.RegularShape.prototype.getImage),goog.exportProperty(ol.style.RegularShape.prototype,"getOrigin",ol.style.RegularShape.prototype.getOrigin),goog.exportProperty(ol.style.RegularShape.prototype,"getPoints",ol.style.RegularShape.prototype.getPoints),goog.exportProperty(ol.style.RegularShape.prototype,"getRadius",ol.style.RegularShape.prototype.getRadius),goog.exportProperty(ol.style.RegularShape.prototype,"getRadius2",ol.style.RegularShape.prototype.getRadius2),goog.exportProperty(ol.style.RegularShape.prototype,"getSize",ol.style.RegularShape.prototype.getSize),goog.exportProperty(ol.style.RegularShape.prototype,"getStroke",ol.style.RegularShape.prototype.getStroke),goog.exportSymbol("ol.style.Stroke",ol.style.Stroke,OPENLAYERS),goog.exportProperty(ol.style.Stroke.prototype,"clone",ol.style.Stroke.prototype.clone),goog.exportProperty(ol.style.Stroke.prototype,"getColor",ol.style.Stroke.prototype.getColor),goog.exportProperty(ol.style.Stroke.prototype,"getLineCap",ol.style.Stroke.prototype.getLineCap),goog.exportProperty(ol.style.Stroke.prototype,"getLineDash",ol.style.Stroke.prototype.getLineDash),goog.exportProperty(ol.style.Stroke.prototype,"getLineJoin",ol.style.Stroke.prototype.getLineJoin),goog.exportProperty(ol.style.Stroke.prototype,"getMiterLimit",ol.style.Stroke.prototype.getMiterLimit),goog.exportProperty(ol.style.Stroke.prototype,"getWidth",ol.style.Stroke.prototype.getWidth),goog.exportProperty(ol.style.Stroke.prototype,"setColor",ol.style.Stroke.prototype.setColor),goog.exportProperty(ol.style.Stroke.prototype,"setLineCap",ol.style.Stroke.prototype.setLineCap),goog.exportProperty(ol.style.Stroke.prototype,"setLineDash",ol.style.Stroke.prototype.setLineDash),goog.exportProperty(ol.style.Stroke.prototype,"setLineJoin",ol.style.Stroke.prototype.setLineJoin),goog.exportProperty(ol.style.Stroke.prototype,"setMiterLimit",ol.style.Stroke.prototype.setMiterLimit),goog.exportProperty(ol.style.Stroke.prototype,"setWidth",ol.style.Stroke.prototype.setWidth),goog.exportSymbol("ol.style.Style",ol.style.Style,OPENLAYERS),goog.exportProperty(ol.style.Style.prototype,"clone",ol.style.Style.prototype.clone),goog.exportProperty(ol.style.Style.prototype,"getGeometry",ol.style.Style.prototype.getGeometry),goog.exportProperty(ol.style.Style.prototype,"getGeometryFunction",ol.style.Style.prototype.getGeometryFunction),goog.exportProperty(ol.style.Style.prototype,"getFill",ol.style.Style.prototype.getFill),goog.exportProperty(ol.style.Style.prototype,"setFill",ol.style.Style.prototype.setFill),goog.exportProperty(ol.style.Style.prototype,"getImage",ol.style.Style.prototype.getImage),goog.exportProperty(ol.style.Style.prototype,"setImage",ol.style.Style.prototype.setImage),goog.exportProperty(ol.style.Style.prototype,"getStroke",ol.style.Style.prototype.getStroke),goog.exportProperty(ol.style.Style.prototype,"setStroke",ol.style.Style.prototype.setStroke),goog.exportProperty(ol.style.Style.prototype,"getText",ol.style.Style.prototype.getText),goog.exportProperty(ol.style.Style.prototype,"setText",ol.style.Style.prototype.setText),goog.exportProperty(ol.style.Style.prototype,"getZIndex",ol.style.Style.prototype.getZIndex),goog.exportProperty(ol.style.Style.prototype,"setGeometry",ol.style.Style.prototype.setGeometry),goog.exportProperty(ol.style.Style.prototype,"setZIndex",ol.style.Style.prototype.setZIndex),goog.exportSymbol("ol.style.Text",ol.style.Text,OPENLAYERS),goog.exportProperty(ol.style.Text.prototype,"clone",ol.style.Text.prototype.clone),goog.exportProperty(ol.style.Text.prototype,"getFont",ol.style.Text.prototype.getFont),goog.exportProperty(ol.style.Text.prototype,"getOffsetX",ol.style.Text.prototype.getOffsetX),goog.exportProperty(ol.style.Text.prototype,"getOffsetY",ol.style.Text.prototype.getOffsetY),goog.exportProperty(ol.style.Text.prototype,"getFill",ol.style.Text.prototype.getFill),goog.exportProperty(ol.style.Text.prototype,"getRotateWithView",ol.style.Text.prototype.getRotateWithView),goog.exportProperty(ol.style.Text.prototype,"getRotation",ol.style.Text.prototype.getRotation),goog.exportProperty(ol.style.Text.prototype,"getScale",ol.style.Text.prototype.getScale),goog.exportProperty(ol.style.Text.prototype,"getStroke",ol.style.Text.prototype.getStroke),goog.exportProperty(ol.style.Text.prototype,"getText",ol.style.Text.prototype.getText),
goog.exportProperty(ol.style.Text.prototype,"getTextAlign",ol.style.Text.prototype.getTextAlign),goog.exportProperty(ol.style.Text.prototype,"getTextBaseline",ol.style.Text.prototype.getTextBaseline),goog.exportProperty(ol.style.Text.prototype,"setFont",ol.style.Text.prototype.setFont),goog.exportProperty(ol.style.Text.prototype,"setOffsetX",ol.style.Text.prototype.setOffsetX),goog.exportProperty(ol.style.Text.prototype,"setOffsetY",ol.style.Text.prototype.setOffsetY),goog.exportProperty(ol.style.Text.prototype,"setFill",ol.style.Text.prototype.setFill),goog.exportProperty(ol.style.Text.prototype,"setRotation",ol.style.Text.prototype.setRotation),goog.exportProperty(ol.style.Text.prototype,"setScale",ol.style.Text.prototype.setScale),goog.exportProperty(ol.style.Text.prototype,"setStroke",ol.style.Text.prototype.setStroke),goog.exportProperty(ol.style.Text.prototype,"setText",ol.style.Text.prototype.setText),goog.exportProperty(ol.style.Text.prototype,"setTextAlign",ol.style.Text.prototype.setTextAlign),goog.exportProperty(ol.style.Text.prototype,"setTextBaseline",ol.style.Text.prototype.setTextBaseline);goog.exportSymbol("ol.Sphere",ol.Sphere,OPENLAYERS),goog.exportProperty(ol.Sphere.prototype,"geodesicArea",ol.Sphere.prototype.geodesicArea),goog.exportProperty(ol.Sphere.prototype,"haversineDistance",ol.Sphere.prototype.haversineDistance),goog.exportSymbol("ol.source.BingMaps",ol.source.BingMaps,OPENLAYERS),goog.exportSymbol("ol.source.BingMaps.TOS_ATTRIBUTION",ol.source.BingMaps.TOS_ATTRIBUTION,OPENLAYERS),goog.exportProperty(ol.source.BingMaps.prototype,"getApiKey",ol.source.BingMaps.prototype.getApiKey),goog.exportProperty(ol.source.BingMaps.prototype,"getImagerySet",ol.source.BingMaps.prototype.getImagerySet),goog.exportSymbol("ol.source.CartoDB",ol.source.CartoDB,OPENLAYERS),goog.exportProperty(ol.source.CartoDB.prototype,"getConfig",ol.source.CartoDB.prototype.getConfig),goog.exportProperty(ol.source.CartoDB.prototype,"updateConfig",ol.source.CartoDB.prototype.updateConfig),goog.exportProperty(ol.source.CartoDB.prototype,"setConfig",ol.source.CartoDB.prototype.setConfig),goog.exportSymbol("ol.source.Cluster",ol.source.Cluster,OPENLAYERS),goog.exportProperty(ol.source.Cluster.prototype,"getSource",ol.source.Cluster.prototype.getSource),goog.exportProperty(ol.source.Cluster.prototype,"setDistance",ol.source.Cluster.prototype.setDistance),goog.exportSymbol("ol.source.Image",ol.source.Image,OPENLAYERS),goog.exportProperty(ol.source.Image.Event.prototype,"image",ol.source.Image.Event.prototype.image),goog.exportSymbol("ol.source.ImageArcGISRest",ol.source.ImageArcGISRest,OPENLAYERS),goog.exportProperty(ol.source.ImageArcGISRest.prototype,"getParams",ol.source.ImageArcGISRest.prototype.getParams),goog.exportProperty(ol.source.ImageArcGISRest.prototype,"getImageLoadFunction",ol.source.ImageArcGISRest.prototype.getImageLoadFunction),goog.exportProperty(ol.source.ImageArcGISRest.prototype,"getUrl",ol.source.ImageArcGISRest.prototype.getUrl),goog.exportProperty(ol.source.ImageArcGISRest.prototype,"setImageLoadFunction",ol.source.ImageArcGISRest.prototype.setImageLoadFunction),goog.exportProperty(ol.source.ImageArcGISRest.prototype,"setUrl",ol.source.ImageArcGISRest.prototype.setUrl),goog.exportProperty(ol.source.ImageArcGISRest.prototype,"updateParams",ol.source.ImageArcGISRest.prototype.updateParams),goog.exportSymbol("ol.source.ImageCanvas",ol.source.ImageCanvas,OPENLAYERS),goog.exportSymbol("ol.source.ImageMapGuide",ol.source.ImageMapGuide,OPENLAYERS),goog.exportProperty(ol.source.ImageMapGuide.prototype,"getParams",ol.source.ImageMapGuide.prototype.getParams),goog.exportProperty(ol.source.ImageMapGuide.prototype,"getImageLoadFunction",ol.source.ImageMapGuide.prototype.getImageLoadFunction),goog.exportProperty(ol.source.ImageMapGuide.prototype,"updateParams",ol.source.ImageMapGuide.prototype.updateParams),goog.exportProperty(ol.source.ImageMapGuide.prototype,"setImageLoadFunction",ol.source.ImageMapGuide.prototype.setImageLoadFunction),goog.exportSymbol("ol.source.ImageStatic",ol.source.ImageStatic,OPENLAYERS),goog.exportSymbol("ol.source.ImageVector",ol.source.ImageVector,OPENLAYERS),goog.exportProperty(ol.source.ImageVector.prototype,"getSource",ol.source.ImageVector.prototype.getSource),goog.exportProperty(ol.source.ImageV