/* Chartist.js 0.8.3
 * Copyright © 2015 Gion Kunz
 * Free to use under the WTFPL license.
 * http://www.wtfpl.net/
 */

!function(t,e){"function"==typeof define&&define.amd?define([],function(){return t.Chartist=e()}):"object"==typeof exports?module.exports=e():t.Chartist=e()}(this,function(){var t={version:"0.8.3"};return function(t,e,n){"use strict";n.noop=function(t){return t},n.alphaNumerate=function(t){return String.fromCharCode(97+t%26)},n.extend=function(t){return t=t||{},Array.prototype.slice.call(arguments,1).forEach(function(e){for(var i in e)"object"!=typeof e[i]||null===e[i]||e[i]instanceof Array?t[i]=e[i]:t[i]=n.extend({},t[i],e[i])}),t},n.replaceAll=function(t,e,n){return t.replace(new RegExp(e,"g"),n)},n.stripUnit=function(t){return"string"==typeof t&&(t=t.replace(/[^0-9\+-\.]/g,"")),+t},n.ensureUnit=function(t,e){return"number"==typeof t&&(t+=e),t},n.querySelector=function(t){return t instanceof Node?t:e.querySelector(t)},n.times=function(t){return Array.apply(null,new Array(t))},n.sum=function(t,e){return t+(e||0)},n.mapMultiply=function(t){return function(e){return e*t}},n.mapAdd=function(t){return function(e){return e+t}},n.serialMap=function(t,e){var i=[],s=Math.max.apply(null,t.map(function(t){return t.length}));return n.times(s).forEach(function(n,s){var r=t.map(function(t){return t[s]});i[s]=e.apply(null,r)}),i},n.roundWithPrecision=function(t,e){var i=Math.pow(10,e||n.precision);return Math.round(t*i)/i},n.precision=8,n.escapingMap={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#039;"},n.serialize=function(t){return null===t||void 0===t?t:("number"==typeof t?t=""+t:"object"==typeof t&&(t=JSON.stringify({data:t})),Object.keys(n.escapingMap).reduce(function(t,e){return n.replaceAll(t,e,n.escapingMap[e])},t))},n.deserialize=function(t){if("string"!=typeof t)return t;t=Object.keys(n.escapingMap).reduce(function(t,e){return n.replaceAll(t,n.escapingMap[e],e)},t);try{t=JSON.parse(t),t=void 0!==t.data?t.data:t}catch(t){}return t},n.createSvg=function(t,e,i,s){var r;return e=e||"100%",i=i||"100%",Array.prototype.slice.call(t.querySelectorAll("svg")).filter(function(t){return t.getAttribute(n.xmlNs.qualifiedName)}).forEach(function(e){t.removeChild(e)}),r=new n.Svg("svg").attr({width:e,height:i}).addClass(s).attr({style:"width: "+e+"; height: "+i+";"}),t.appendChild(r._node),r},n.reverseData=function(t){t.labels.reverse(),t.series.reverse();for(var e=0;e<t.series.length;e++)"object"==typeof t.series[e]&&void 0!==t.series[e].data?t.series[e].data.reverse():t.series[e]instanceof Array&&t.series[e].reverse()},n.getDataArray=function(t,e){function i(t){return void 0===t||null===t||"number"==typeof t&&isNaN(t)?void 0:(t.data||t)instanceof Array?(t.data||t).map(i):t.hasOwnProperty("value")?i(t.value):+t}return(e&&!t.reversed||!e&&t.reversed)&&(n.reverseData(t),t.reversed=!t.reversed),t.series.map(i)},n.normalizePadding=function(t,e){return e=e||0,"number"==typeof t?{top:t,right:t,bottom:t,left:t}:{top:"number"==typeof t.top?t.top:e,right:"number"==typeof t.right?t.right:e,bottom:"number"==typeof t.bottom?t.bottom:e,left:"number"==typeof t.left?t.left:e}},n.normalizeDataArray=function(t,e){for(var n=0;n<t.length;n++)if(t[n].length!==e)for(var i=t[n].length;e>i;i++)t[n][i]=void 0;return t},n.getMetaData=function(t,e){var i=t.data?t.data[e]:t[e];return i?n.serialize(i.meta):void 0},n.orderOfMagnitude=function(t){return Math.floor(Math.log(Math.abs(t))/Math.LN10)},n.projectLength=function(t,e,n){return e/n.range*t},n.getAvailableHeight=function(t,e){return Math.max((n.stripUnit(e.height)||t.height())-(e.chartPadding.top+e.chartPadding.bottom)-e.axisX.offset,0)},n.getHighLow=function(t,e){function n(t){if(t instanceof Array)for(var e=0;e<t.length;e++)n(t[e]);else s&&t>i.high&&(i.high=t),r&&t<i.low&&(i.low=t)}var i={high:void 0===e.high?-Number.MAX_VALUE:+e.high,low:void 0===e.low?Number.MAX_VALUE:+e.low},s=void 0===e.high,r=void 0===e.low;return n(t),i.high<=i.low&&(0===i.low?i.high=1:i.low<0?i.high=0:i.low=0),i},n.rho=function(t){function e(t,n){return t%n==0?n:e(n,t%n)}function n(t){return t*t+1}if(1===t)return t;var i,s=2,r=2;if(t%2==0)return 2;do{s=n(s)%t,r=n(n(r))%t,i=e(Math.abs(s-r),t)}while(1===i);return i},n.getBounds=function(t,e,i,s,r){var a,o,h,l={high:e.high,low:e.low};(s||0===s)&&(l.high=Math.max(s,l.high),l.low=Math.min(s,l.low)),l.valueRange=l.high-l.low,l.oom=n.orderOfMagnitude(l.valueRange),l.step=Math.pow(10,l.oom),l.min=Math.floor(l.low/l.step)*l.step,l.max=Math.ceil(l.high/l.step)*l.step,l.range=l.max-l.min,l.numberOfSteps=Math.round(l.range/l.step);var c=n.projectLength(t,l.step,l),u=i>c,d=r?n.rho(l.range):0;if(r&&n.projectLength(t,1,l)>=i)l.step=1;else if(r&&d<l.step&&n.projectLength(t,d,l)>=i)l.step=d;else for(;;)if(u&&n.projectLength(t,l.step,l)<=i)l.step*=2;else{if(u||!(n.projectLength(t,l.step/2,l)>=i))break;if(l.step/=2,r&&l.step%1!=0){l.step*=2;break}}for(o=l.min,h=l.max;o+l.step<=l.low;)o+=l.step;for(;h-l.step>=l.high;)h-=l.step;for(l.min=o,l.max=h,l.range=l.max-l.min,l.values=[],a=l.min;a<=l.max;a+=l.step)l.values.push(n.roundWithPrecision(a));return l},n.polarToCartesian=function(t,e,n,i){var s=(i-90)*Math.PI/180;return{x:t+n*Math.cos(s),y:e+n*Math.sin(s)}},n.createChartRect=function(t,e,i){var s=!(!e.axisX&&!e.axisY),r=s?e.axisY.offset:0,a=s?e.axisX.offset:0,o=t.width()||n.stripUnit(e.width)||0,h=t.height()||n.stripUnit(e.height)||0,l=n.normalizePadding(e.chartPadding,i);o=Math.max(o,a+l.left+l.right),h=Math.max(h,r+l.top+l.bottom);var c={padding:l,width:function(){return this.x2-this.x1},height:function(){return this.y1-this.y2}};return s?("start"===e.axisX.position?(c.y2=l.top+a,c.y1=Math.max(h-l.bottom,c.y2+1)):(c.y2=l.top,c.y1=Math.max(h-l.bottom-a,c.y2+1)),"start"===e.axisY.position?(c.x1=l.left+r,c.x2=Math.max(o-l.right,c.x1+1)):(c.x1=l.left,c.x2=Math.max(o-l.right-r,c.x1+1))):(c.x1=l.left,c.x2=Math.max(o-l.right,c.x1+1),c.y2=l.top,c.y1=Math.max(h-l.bottom,c.y2+1)),c},n.createGrid=function(t,e,i,s,r,a,o,h){var l={};l[i.units.pos+"1"]=t.pos,l[i.units.pos+"2"]=t.pos,l[i.counterUnits.pos+"1"]=s,l[i.counterUnits.pos+"2"]=s+r;var c=a.elem("line",l,o.join(" "));h.emit("draw",n.extend({type:"grid",axis:i,index:e,group:a,element:c},l))},n.createLabel=function(t,e,i,s,r,a,o,h,l,c){var u,d={};if(d[s.units.pos]=t.pos+a[s.units.pos],d[s.counterUnits.pos]=a[s.counterUnits.pos],d[s.units.len]=t.len,d[s.counterUnits.len]=r-10,l){var p='<span class="'+h.join(" ")+'" style="'+s.units.len+": "+Math.round(d[s.units.len])+"px; "+s.counterUnits.len+": "+Math.round(d[s.counterUnits.len])+'px">'+i[e]+"</span>";u=o.foreignObject(p,n.extend({style:"overflow: visible;"},d))}else u=o.elem("text",d,h.join(" ")).text(i[e]);c.emit("draw",n.extend({type:"label",axis:s,index:e,group:o,element:u,text:i[e]},d))},n.createAxis=function(t,e,i,s,r,a,o,h){var l=o["axis"+t.units.pos.toUpperCase()],c=e.map(t.projectValue.bind(t)),u=e.map(l.labelInterpolationFnc);c.forEach(function(e,c){var d={x:0,y:0};(u[c]||0===u[c])&&("x"===t.units.pos?(e.pos=i.x1+e.pos,d.x=o.axisX.labelOffset.x,"start"===o.axisX.position?d.y=i.padding.top+o.axisX.labelOffset.y+(a?5:20):d.y=i.y1+o.axisX.labelOffset.y+(a?5:20)):(e.pos=i.y1-e.pos,d.y=o.axisY.labelOffset.y-(a?e.len:0),"start"===o.axisY.position?d.x=a?i.padding.left+o.axisY.labelOffset.x:i.x1-10:d.x=i.x2+o.axisY.labelOffset.x+10),l.showGrid&&n.createGrid(e,c,t,t.gridOffset,i[t.counterUnits.len](),s,[o.classNames.grid,o.classNames[t.units.dir]],h),l.showLabel&&n.createLabel(e,c,u,t,l.offset,d,r,[o.classNames.label,o.classNames[t.units.dir],o.classNames[l.position]],a,h))})},n.getSeriesOption=function(t,e,n){if(t.name&&e.series&&e.series[t.name]){var i=e.series[t.name];return i.hasOwnProperty(n)?i[n]:e[n]}return e[n]},n.optionsProvider=function(e,i,s){function r(e){var r=o;if(o=n.extend({},l),i)for(h=0;h<i.length;h++){var a=t.matchMedia(i[h][0]);a.matches&&(o=n.extend(o,i[h][1]))}s&&!e&&s.emit("optionsChanged",{previousOptions:r,currentOptions:o})}function a(){c.forEach(function(t){t.removeListener(r)})}var o,h,l=n.extend({},e),c=[];if(!t.matchMedia)throw"window.matchMedia not found! Make sure you're using a polyfill.";if(i)for(h=0;h<i.length;h++){var u=t.matchMedia(i[h][0]);u.addListener(r),c.push(u)}return r(!0),{removeMediaQueryListeners:a,getCurrentOptions:function(){return n.extend({},o)}}}}(window,document,t),function(t,e,n){"use strict";n.Interpolation={},n.Interpolation.none=function(){return function(t,e){for(var i=new n.Svg.Path,s=!0,r=1;r<t.length;r+=2){var a=e[(r-1)/2];void 0===a.value?s=!0:s?(i.move(t[r-1],t[r],!1,a),s=!1):i.line(t[r-1],t[r],!1,a)}return i}},n.Interpolation.simple=function(t){var e={divisor:2};t=n.extend({},e,t);var i=1/Math.max(1,t.divisor);return function(t,e){for(var s=new n.Svg.Path,r=!0,a=2;a<t.length;a+=2){var o=t[a-2],h=t[a-1],l=t[a],c=t[a+1],u=(l-o)*i,d=e[a/2-1],p=e[a/2];void 0===d.value?r=!0:(r&&s.move(o,h,!1,d),void 0!==p.value&&(s.curve(o+u,h,l-u,c,l,c,!1,p),r=!1))}return s}},n.Interpolation.cardinal=function(t){function e(t,e){for(var n=[],i=!0,s=0;s<t.length;s+=2)void 0===e[s/2].value?i=!0:(i&&(n.push({pathCoordinates:[],valueData:[]}),i=!1),n[n.length-1].pathCoordinates.push(t[s],t[s+1]),n[n.length-1].valueData.push(e[s/2]));return n}var i={tension:1};t=n.extend({},i,t);var s=Math.min(1,Math.max(0,t.tension)),r=1-s;return function t(i,a){var o=e(i,a);if(o.length>1){var h=[];return o.forEach(function(e){h.push(t(e.pathCoordinates,e.valueData))}),n.Svg.Path.join(h)}if(i=o[0].pathCoordinates,a=o[0].valueData,i.length<=4)return n.Interpolation.none()(i,a);for(var l=(new n.Svg.Path).move(i[0],i[1],!1,a[0]),c=0,u=i.length;u-2>c;c+=2){var d=[{x:+i[c-2],y:+i[c-1]},{x:+i[c],y:+i[c+1]},{x:+i[c+2],y:+i[c+3]},{x:+i[c+4],y:+i[c+5]}];u-4===c?d[3]=d[2]:c||(d[0]={x:+i[c],y:+i[c+1]}),l.curve(s*(-d[0].x+6*d[1].x+d[2].x)/6+r*d[2].x,s*(-d[0].y+6*d[1].y+d[2].y)/6+r*d[2].y,s*(d[1].x+6*d[2].x-d[3].x)/6+r*d[2].x,s*(d[1].y+6*d[2].y-d[3].y)/6+r*d[2].y,d[2].x,d[2].y,!1,a[(c+2)/2])}return l}},n.Interpolation.step=function(t){var e={postpone:!0};return t=n.extend({},e,t),function(e,i){for(var s=new n.Svg.Path,r=!0,a=2;a<e.length;a+=2){var o=e[a-2],h=e[a-1],l=e[a],c=e[a+1],u=i[a/2-1],d=i[a/2];void 0===u.value?r=!0:(r&&s.move(o,h,!1,u),void 0!==d.value&&(t.postpone?s.line(l,h,!1,u):s.line(o,c,!1,d),s.line(l,c,!1,d),r=!1))}return s}}}(window,document,t),function(t,e,n){"use strict";n.EventEmitter=function(){function t(t,e){i[t]=i[t]||[],i[t].push(e)}function e(t,e){i[t]&&(e?(i[t].splice(i[t].indexOf(e),1),0===i[t].length&&delete i[t]):delete i[t])}function n(t,e){i[t]&&i[t].forEach(function(t){t(e)}),i["*"]&&i["*"].forEach(function(n){n(t,e)})}var i=[];return{addEventHandler:t,removeEventHandler:e,emit:n}}}(window,document,t),function(t,e,n){"use strict";function i(t){var e=[];if(t.length)for(var n=0;n<t.length;n++)e.push(t[n]);return e}function s(t,e){var i=e||this.prototype||n.Class,s=Object.create(i);n.Class.cloneDefinitions(s,t);var r=function(){var t,e=s.constructor||function(){};return t=this===n?Object.create(s):this,e.apply(t,Array.prototype.slice.call(arguments,0)),t};return r.prototype=s,r.super=i,r.extend=this.extend,r}function r(){var t=i(arguments),e=t[0];return t.splice(1,t.length-1).forEach(function(t){Object.getOwnPropertyNames(t).forEach(function(n){delete e[n],Object.defineProperty(e,n,Object.getOwnPropertyDescriptor(t,n))})}),e}n.Class={extend:s,cloneDefinitions:r}}(window,document,t),function(t,e,n){"use strict";function i(t,e,i){return t&&(this.data=t,this.eventEmitter.emit("data",{type:"update",data:this.data})),e&&(this.options=n.extend({},i?this.options:this.defaultOptions,e),this.initializeTimeoutId||(this.optionsProvider.removeMediaQueryListeners(),this.optionsProvider=n.optionsProvider(this.options,this.responsiveOptions,this.eventEmitter))),this.initializeTimeoutId||this.createChart(this.optionsProvider.getCurrentOptions()),this}function s(){return this.initializeTimeoutId?t.clearTimeout(this.initializeTimeoutId):(t.removeEventListener("resize",this.resizeListener),this.optionsProvider.removeMediaQueryListeners()),this}function r(t,e){return this.eventEmitter.addEventHandler(t,e),this}function a(t,e){return this.eventEmitter.removeEventHandler(t,e),this}function o(){t.addEventListener("resize",this.resizeListener),this.optionsProvider=n.optionsProvider(this.options,this.responsiveOptions,this.eventEmitter),this.eventEmitter.addEventHandler("optionsChanged",function(){this.update()}.bind(this)),this.options.plugins&&this.options.plugins.forEach(function(t){t instanceof Array?t[0](this,t[1]):t(this)}.bind(this)),this.eventEmitter.emit("data",{type:"initial",data:this.data}),this.createChart(this.optionsProvider.getCurrentOptions()),this.initializeTimeoutId=void 0}function h(t,e,i,s,r){this.container=n.querySelector(t),this.data=e,this.defaultOptions=i,this.options=s,this.responsiveOptions=r,this.eventEmitter=n.EventEmitter(),this.supportsForeignObject=n.Svg.isSupported("Extensibility"),this.supportsAnimations=n.Svg.isSupported("AnimationEventsAttribute"),this.resizeListener=function(){this.update()}.bind(this),this.container&&(this.container.__chartist__&&this.container.__chartist__.detach(),this.container.__chartist__=this),this.initializeTimeoutId=setTimeout(o.bind(this),0)}n.Base=n.Class.extend({constructor:h,optionsProvider:void 0,container:void 0,svg:void 0,eventEmitter:void 0,createChart:function(){throw new Error("Base chart type can't be instantiated!")},update:i,detach:s,on:r,off:a,version:n.version,supportsForeignObject:!1})}(window,document,t),function(t,e,n){"use strict";function i(t,i,s,r,a){t instanceof Element?this._node=t:(this._node=e.createElementNS(C,t),"svg"===t&&this._node.setAttributeNS(O,n.xmlNs.qualifiedName,n.xmlNs.uri),i&&this.attr(i),s&&this.addClass(s),r&&(a&&r._node.firstChild?r._node.insertBefore(this._node,r._node.firstChild):r._node.appendChild(this._node)))}function s(t,e){return"string"==typeof t?e?this._node.getAttributeNS(e,t):this._node.getAttribute(t):(Object.keys(t).forEach(function(i){void 0!==t[i]&&(e?this._node.setAttributeNS(e,[n.xmlNs.prefix,":",i].join(""),t[i]):this._node.setAttribute(i,t[i]))}.bind(this)),this)}function r(t,e,i,s){return new n.Svg(t,e,i,this,s)}function a(){return this._node.parentNode instanceof SVGElement?new n.Svg(this._node.parentNode):null}function o(){for(var t=this._node;"svg"!==t.nodeName;)t=t.parentNode;return new n.Svg(t)}function h(t){var e=this._node.querySelector(t);return e?new n.Svg(e):null}function l(t){var e=this._node.querySelectorAll(t);return e.length?new n.Svg.List(e):null}function c(t,n,i,s){if("string"==typeof t){var r=e.createElement("div");r.innerHTML=t,t=r.firstChild}t.setAttribute("xmlns",M);var a=this.elem("foreignObject",n,i,s);return a._node.appendChild(t),a}function u(t){return this._node.appendChild(e.createTextNode(t)),this}function d(){for(;this._node.firstChild;)this._node.removeChild(this._node.firstChild);return this}function p(){return this._node.parentNode.removeChild(this._node),this.parent()}function f(t){return this._node.parentNode.replaceChild(t._node,this._node),t}function m(t,e){return e&&this._node.firstChild?this._node.insertBefore(t._node,this._node.firstChild):this._node.appendChild(t._node),this}function v(){return this._node.getAttribute("class")?this._node.getAttribute("class").trim().split(/\s+/):[]}function g(t){return this._node.setAttribute("class",this.classes(this._node).concat(t.trim().split(/\s+/)).filter(function(t,e,n){return n.indexOf(t)===e}).join(" ")),this}function x(t){var e=t.trim().split(/\s+/);return this._node.setAttribute("class",this.classes(this._node).filter(function(t){return-1===e.indexOf(t)}).join(" ")),this}function y(){return this._node.setAttribute("class",""),this}function b(t,e){try{return t.getBBox()[e]}catch(t){}return 0}function w(){return this._node.clientHeight||Math.round(b(this._node,"height"))||this._node.parentNode.clientHeight}function E(){return this._node.clientWidth||Math.round(b(this._node,"width"))||this._node.parentNode.clientWidth}function S(t,e,i){return void 0===e&&(e=!0),Object.keys(t).forEach(function(s){function r(t,e){var r,a,o,h={};t.easing&&(o=t.easing instanceof Array?t.easing:n.Svg.Easing[t.easing],delete t.easing),t.begin=n.ensureUnit(t.begin,"ms"),t.dur=n.ensureUnit(t.dur,"ms"),o&&(t.calcMode="spline",t.keySplines=o.join(" "),t.keyTimes="0;1"),e&&(t.fill="freeze",h[s]=t.from,this.attr(h),a=n.stripUnit(t.begin||0),t.begin="indefinite"),r=this.elem("animate",n.extend({attributeName:s},t)),e&&setTimeout(function(){try{r._node.beginElement()}catch(e){h[s]=t.to,this.attr(h),r.remove()}}.bind(this),a),i&&r._node.addEventListener("beginEvent",function(){i.emit("animationBegin",{element:this,animate:r._node,params:t})}.bind(this)),r._node.addEventListener("endEvent",function(){i&&i.emit("animationEnd",{element:this,animate:r._node,params:t}),e&&(h[s]=t.to,this.attr(h),r.remove())}.bind(this))}t[s]instanceof Array?t[s].forEach(function(t){r.bind(this)(t,!1)}.bind(this)):r.bind(this)(t[s],e)}.bind(this)),this}function A(t){var e=this;this.svgElements=[];for(var i=0;i<t.length;i++)this.svgElements.push(new n.Svg(t[i]));Object.keys(n.Svg.prototype).filter(function(t){return-1===["constructor","parent","querySelector","querySelectorAll","replace","append","classes","height","width"].indexOf(t)}).forEach(function(t){e[t]=function(){var i=Array.prototype.slice.call(arguments,0);return e.svgElements.forEach(function(e){n.Svg.prototype[t].apply(e,i)}),e}})}var C="http://www.w3.org/2000/svg",O="http://www.w3.org/2000/xmlns/",M="http://www.w3.org/1999/xhtml";n.xmlNs={qualifiedName:"xmlns:ct",prefix:"ct",uri:"http://gionkunz.github.com/chartist-js/ct"},n.Svg=n.Class.extend({constructor:i,attr:s,elem:r,parent:a,root:o,querySelector:h,querySelectorAll:l,foreignObject:c,text:u,empty:d,remove:p,replace:f,append:m,classes:v,addClass:g,removeClass:x,removeAllClasses:y,height:w,width:E,animate:S}),n.Svg.isSupported=function(t){return e.implementation.hasFeature("www.http://w3.org/TR/SVG11/feature#"+t,"1.1")};var N={easeInSine:[.47,0,.745,.715],easeOutSine:[.39,.575,.565,1],easeInOutSine:[.445,.05,.55,.95],easeInQuad:[.55,.085,.68,.53],easeOutQuad:[.25,.46,.45,.94],easeInOutQuad:[.455,.03,.515,.955],easeInCubic:[.55,.055,.675,.19],easeOutCubic:[.215,.61,.355,1],easeInOutCubic:[.645,.045,.355,1],easeInQuart:[.895,.03,.685,.22],easeOutQuart:[.165,.84,.44,1],easeInOutQuart:[.77,0,.175,1],easeInQuint:[.755,.05,.855,.06],easeOutQuint:[.23,1,.32,1],easeInOutQuint:[.86,0,.07,1],easeInExpo:[.95,.05,.795,.035],easeOutExpo:[.19,1,.22,1],easeInOutExpo:[1,0,0,1],easeInCirc:[.6,.04,.98,.335],easeOutCirc:[.075,.82,.165,1],easeInOutCirc:[.785,.135,.15,.86],easeInBack:[.6,-.28,.735,.045],easeOutBack:[.175,.885,.32,1.275],easeInOutBack:[.68,-.55,.265,1.55]};n.Svg.Easing=N,n.Svg.List=n.Class.extend({constructor:A})}(window,document,t),function(t,e,n){"use strict";function i(t,e,i,s,r,a){var o=n.extend({command:r?t.toLowerCase():t.toUpperCase()},e,a?{data:a}:{});i.splice(s,0,o)}function s(t,e){t.forEach(function(n,i){b[n.command.toLowerCase()].forEach(function(s,r){e(n,s,i,r,t)})})}function r(t,e){this.pathElements=[],this.pos=0,this.close=t,this.options=n.extend({},w,e)}function a(t){return void 0!==t?(this.pos=Math.max(0,Math.min(this.pathElements.length,t)),this):this.pos}function o(t){return this.pathElements.splice(this.pos,t),this}function h(t,e,n,s){return i("M",{x:+t,y:+e},this.pathElements,this.pos++,n,s),this}function l(t,e,n,s){return i("L",{x:+t,y:+e},this.pathElements,this.pos++,n,s),this}function c(t,e,n,s,r,a,o,h){return i("C",{x1:+t,y1:+e,x2:+n,y2:+s,x:+r,y:+a},this.pathElements,this.pos++,o,h),this}function u(t,e,n,s,r,a,o,h,l){return i("A",{rx:+t,ry:+e,xAr:+n,lAf:+s,sf:+r,x:+a,y:+o},this.pathElements,this.pos++,h,l),this}function d(t){var e=t.replace(/([A-Za-z])([0-9])/g,"$1 $2").replace(/([0-9])([A-Za-z])/g,"$1 $2").split(/[\s,]+/).reduce(function(t,e){return e.match(/[A-Za-z]/)&&t.push([]),t[t.length-1].push(e),t},[]);"Z"===e[e.length-1][0].toUpperCase()&&e.pop();var i=e.map(function(t){var e=t.shift(),i=b[e.toLowerCase()];return n.extend({command:e},i.reduce(function(e,n,i){return e[n]=+t[i],e},{}))}),s=[this.pos,0];return Array.prototype.push.apply(s,i),Array.prototype.splice.apply(this.pathElements,s),this.pos+=i.length,this}function p(){var t=Math.pow(10,this.options.accuracy);return this.pathElements.reduce(function(e,n){var i=b[n.command.toLowerCase()].map(function(e){return this.options.accuracy?Math.round(n[e]*t)/t:n[e]}.bind(this));return e+n.command+i.join(",")}.bind(this),"")+(this.close?"Z":"")}function f(t,e){return s(this.pathElements,function(n,i){n[i]*="x"===i[0]?t:e}),this}function m(t,e){return s(this.pathElements,function(n,i){n[i]+="x"===i[0]?t:e}),this}function v(t){return s(this.pathElements,function(e,n,i,s,r){var a=t(e,n,i,s,r);(a||0===a)&&(e[n]=a)}),this}function g(t){var e=new n.Svg.Path(t||this.close);return e.pos=this.pos,e.pathElements=this.pathElements.slice().map(function(t){return n.extend({},t)}),e.options=n.extend({},this.options),e}function x(t){var e=[new n.Svg.Path];return this.pathElements.forEach(function(i){i.command===t.toUpperCase()&&0!==e[e.length-1].pathElements.length&&e.push(new n.Svg.Path),e[e.length-1].pathElements.push(i)}),e}function y(t,e,i){for(var s=new n.Svg.Path(e,i),r=0;r<t.length;r++)for(var a=t[r],o=0;o<a.pathElements.length;o++)s.pathElements.push(a.pathElements[o]);return s}var b={m:["x","y"],l:["x","y"],c:["x1","y1","x2","y2","x","y"],a:["rx","ry","xAr","lAf","sf","x","y"]},w={accuracy:3};n.Svg.Path=n.Class.extend({constructor:r,position:a,remove:o,move:h,line:l,curve:c,arc:u,scale:f,translate:m,transform:v,parse:d,stringify:p,clone:g,splitByCommand:x}),n.Svg.Path.elementDescriptions=b,n.Svg.Path.join=y}(window,document,t),function(t,e,n){"use strict";function i(t,e,n){this.units=t,this.counterUnits=t===s.x?s.y:s.x,this.chartRect=e,this.axisLength=e[t.rectEnd]-e[t.rectStart],this.gridOffset=e[t.rectOffset],this.options=n}var s={x:{pos:"x",len:"width",dir:"horizontal",rectStart:"x1",rectEnd:"x2",rectOffset:"y2"},y:{pos:"y",len:"height",dir:"vertical",rectStart:"y2",rectEnd:"y1",rectOffset:"x1"}};n.Axis=n.Class.extend({constructor:i,projectValue:function(t,e,n){throw new Error("Base axis can't be instantiated!")}}),n.Axis.units=s}(window,document,t),function(t,e,n){"use strict";function i(t,e,i){n.LinearScaleAxis.super.constructor.call(this,t,e,i),this.bounds=n.getBounds(this.axisLength,i.highLow,i.scaleMinSpace,i.referenceValue,i.onlyInteger)}function s(t){return{pos:this.axisLength*(t-this.bounds.min)/this.bounds.range,len:n.projectLength(this.axisLength,this.bounds.step,this.bounds)}}n.LinearScaleAxis=n.Axis.extend({constructor:i,projectValue:s})}(window,document,t),function(t,e,n){"use strict";function i(t,e,i){n.StepAxis.super.constructor.call(this,t,e,i),this.stepLength=this.axisLength/(i.stepCount-(i.stretch?1:0))}function s(t,e){return{pos:this.stepLength*e,len:this.stepLength}}n.StepAxis=n.Axis.extend({constructor:i,projectValue:s})}(window,document,t),function(t,e,n){"use strict";function i(t){var e=[],i=n.normalizeDataArray(n.getDataArray(this.data,t.reverseData),this.data.labels.length);this.svg=n.createSvg(this.container,t.width,t.height,t.classNames.chart);var s=n.createChartRect(this.svg,t,r.padding),a=n.getHighLow(i,t),o=new n.StepAxis(n.Axis.units.x,s,{stepCount:this.data.labels.length,stretch:t.fullWidth}),h=new n.LinearScaleAxis(n.Axis.units.y,s,{highLow:a,scaleMinSpace:t.axisY.scaleMinSpace,onlyInteger:t.axisY.onlyInteger}),l=this.svg.elem("g").addClass(t.classNames.labelGroup),c=this.svg.elem("g").addClass(t.classNames.gridGroup);n.createAxis(o,this.data.labels,s,c,l,this.supportsForeignObject,t,this.eventEmitter),n.createAxis(h,h.bounds.values,s,c,l,this.supportsForeignObject,t,this.eventEmitter),this.data.series.forEach(function(r,a){e[a]=this.svg.elem("g"),e[a].attr({"series-name":r.name,meta:n.serialize(r.meta)},n.xmlNs.uri),e[a].addClass([t.classNames.series,r.className||t.classNames.series+"-"+n.alphaNumerate(a)].join(" "));var l=[],c=[];i[a].forEach(function(t,e){var u={x:s.x1+o.projectValue(t,e,i[a]).pos,y:s.y1-h.projectValue(t,e,i[a]).pos};l.push(u.x,u.y),c.push({value:t,valueIndex:e,meta:n.getMetaData(r,e)})}.bind(this));var u={lineSmooth:n.getSeriesOption(r,t,"lineSmooth"),showPoint:n.getSeriesOption(r,t,"showPoint"),showLine:n.getSeriesOption(r,t,"showLine"),showArea:n.getSeriesOption(r,t,"showArea")},d="function"==typeof u.lineSmooth?u.lineSmooth:u.lineSmooth?n.Interpolation.cardinal():n.Interpolation.none(),p=d(l,c);if(u.showPoint&&p.pathElements.forEach(function(i){var s=e[a].elem("line",{x1:i.x,y1:i.y,x2:i.x+.01,y2:i.y},t.classNames.point).attr({value:i.data.value,meta:i.data.meta},n.xmlNs.uri);this.eventEmitter.emit("draw",{type:"point",value:i.data.value,index:i.data.valueIndex,meta:i.data.meta,series:r,seriesIndex:a,group:e[a],element:s,x:i.x,y:i.y})}.bind(this)),u.showLine){var f=e[a].elem("path",{d:p.stringify()},t.classNames.line,!0).attr({values:i[a]},n.xmlNs.uri);this.eventEmitter.emit("draw",{type:"line",values:i[a],path:p.clone(),chartRect:s,index:a,series:r,seriesIndex:a,group:e[a],element:f})}if(u.showArea){var m=Math.max(Math.min(t.areaBase,h.bounds.max),h.bounds.min),v=s.y1-h.projectValue(m).pos;p.splitByCommand("M").filter(function(t){return t.pathElements.length>1}).map(function(t){var e=t.pathElements[0],n=t.pathElements[t.pathElements.length-1];return t.clone(!0).position(0).remove(1).move(e.x,v).line(e.x,e.y).position(t.pathElements.length+1).line(n.x,v)}).forEach(function(o){var h=e[a].elem("path",{d:o.stringify()},t.classNames.area,!0).attr({values:i[a]},n.xmlNs.uri);this.eventEmitter.emit("draw",{type:"area",values:i[a],path:o.clone(),series:r,seriesIndex:a,chartRect:s,index:a,group:e[a],element:h})}.bind(this))}}.bind(this)),this.eventEmitter.emit("created",{bounds:h.bounds,chartRect:s,axisX:o,axisY:h,svg:this.svg,options:t})}function s(t,e,i,s){n.Line.super.constructor.call(this,t,e,r,n.extend({},r,i),s)}var r={axisX:{offset:30,position:"end",labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:n.noop,onlyInteger:!1},axisY:{offset:40,position:"start",labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:n.noop,scaleMinSpace:20,onlyInteger:!1},width:void 0,height:void 0,showLine:!0,showPoint:!0,showArea:!1,areaBase:0,lineSmooth:!0,low:void 0,high:void 0,chartPadding:{top:15,right:15,bottom:5,left:10},fullWidth:!1,reverseData:!1,classNames:{chart:"ct-chart-line",label:"ct-label",labelGroup:"ct-labels",series:"ct-series",line:"ct-line",point:"ct-point",area:"ct-area",grid:"ct-grid",gridGroup:"ct-grids",vertical:"ct-vertical",horizontal:"ct-horizontal",start:"ct-start",end:"ct-end"}};n.Line=n.Base.extend({constructor:s,createChart:i})}(window,document,t),function(t,e,n){"use strict";function i(t){var e,i=[],s=n.getDataArray(this.data,t.reverseData),a=t.distributeSeries?s.map(function(t){return[t]}):n.normalizeDataArray(s,this.data.labels.length);if(this.svg=n.createSvg(this.container,t.width,t.height,t.classNames.chart+(t.horizontalBars?" "+t.classNames.horizontalBars:"")),t.stackBars){var o=n.serialMap(a,function(){return Array.prototype.slice.call(arguments).reduce(n.sum,0)});e=n.getHighLow([o],t)}else e=n.getHighLow(a,t);e.high=+t.high||(0===t.high?0:e.high),e.low=+t.low||(0===t.low?0:e.low);var h,l,c,u,d,p=n.createChartRect(this.svg,t,r.padding);l=t.distributeSeries&&!t.stackBars?a.length:t.distributeSeries&&t.stackBars?1:this.data.labels.length,t.horizontalBars?(c=d=new n.StepAxis(n.Axis.units.y,p,{stepCount:l}),h=u=new n.LinearScaleAxis(n.Axis.units.x,p,{highLow:e,scaleMinSpace:t.axisX.scaleMinSpace,onlyInteger:t.axisX.onlyInteger,referenceValue:0})):(c=u=new n.StepAxis(n.Axis.units.x,p,{stepCount:l}),h=d=new n.LinearScaleAxis(n.Axis.units.y,p,{highLow:e,scaleMinSpace:t.axisY.scaleMinSpace,onlyInteger:t.axisY.onlyInteger,referenceValue:0}));var f=this.svg.elem("g").addClass(t.classNames.labelGroup),m=this.svg.elem("g").addClass(t.classNames.gridGroup),v=t.horizontalBars?p.x1+h.projectValue(0).pos:p.y1-h.projectValue(0).pos,g=[];n.createAxis(c,this.data.labels,p,m,f,this.supportsForeignObject,t,this.eventEmitter),n.createAxis(h,h.bounds.values,p,m,f,this.supportsForeignObject,t,this.eventEmitter),this.data.series.forEach(function(e,s){var r,o=s-(this.data.series.length-1)/2;r=t.distributeSeries&&!t.stackBars?c.axisLength/a.length/2:t.distributeSeries&&t.stackBars?c.axisLength/2:c.axisLength/a[s].length/2,i[s]=this.svg.elem("g"),i[s].attr({"series-name":e.name,meta:n.serialize(e.meta)},n.xmlNs.uri),i[s].addClass([t.classNames.series,e.className||t.classNames.series+"-"+n.alphaNumerate(s)].join(" ")),a[s].forEach(function(l,u){var d,f,m,x;if(x=t.distributeSeries&&!t.stackBars?s:t.distributeSeries&&t.stackBars?0:u,d=t.horizontalBars?{x:p.x1+h.projectValue(l||0,u,a[s]).pos,y:p.y1-c.projectValue(l||0,x,a[s]).pos}:{x:p.x1+c.projectValue(l||0,x,a[s]).pos,y:p.y1-h.projectValue(l||0,u,a[s]).pos},d[c.units.pos]+=r*(t.horizontalBars?-1:1),d[c.units.pos]+=t.stackBars||t.distributeSeries?0:o*t.seriesBarDistance*(t.horizontalBars?-1:1),m=g[u]||v,g[u]=m-(v-d[c.counterUnits.pos]),void 0!==l){var y={};y[c.units.pos+"1"]=d[c.units.pos],y[c.units.pos+"2"]=d[c.units.pos],y[c.counterUnits.pos+"1"]=t.stackBars?m:v,y[c.counterUnits.pos+"2"]=t.stackBars?g[u]:d[c.counterUnits.pos],f=i[s].elem("line",y,t.classNames.bar).attr({value:l,meta:n.getMetaData(e,u)},n.xmlNs.uri),this.eventEmitter.emit("draw",n.extend({type:"bar",value:l,index:u,meta:n.getMetaData(e,u),series:e,seriesIndex:s,chartRect:p,group:i[s],element:f},y))}}.bind(this))}.bind(this)),this.eventEmitter.emit("created",{bounds:h.bounds,chartRect:p,axisX:u,axisY:d,svg:this.svg,options:t})}function s(t,e,i,s){n.Bar.super.constructor.call(this,t,e,r,n.extend({},r,i),s)}var r={axisX:{offset:30,position:"end",labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:n.noop,scaleMinSpace:30,onlyInteger:!1},axisY:{offset:40,position:"start",labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:n.noop,scaleMinSpace:20,onlyInteger:!1},width:void 0,height:void 0,high:void 0,low:void 0,onlyInteger:!1,chartPadding:{top:15,right:15,bottom:5,left:10},seriesBarDistance:15,stackBars:!1,horizontalBars:!1,distributeSeries:!1,reverseData:!1,classNames:{chart:"ct-chart-bar",horizontalBars:"ct-horizontal-bars",label:"ct-label",labelGroup:"ct-labels",series:"ct-series",bar:"ct-bar",grid:"ct-grid",gridGroup:"ct-grids",vertical:"ct-vertical",horizontal:"ct-horizontal",start:"ct-start",end:"ct-end"}};n.Bar=n.Base.extend({constructor:s,createChart:i})}(window,document,t),function(t,e,n){"use strict";function i(t,e,n){var i=e.x>t.x;return i&&"explode"===n||!i&&"implode"===n?"start":i&&"implode"===n||!i&&"explode"===n?"end":"middle"}function s(t){var e,s,r,o,h=[],l=t.startAngle,c=n.getDataArray(this.data,t.reverseData);this.svg=n.createSvg(this.container,t.width,t.height,t.donut?t.classNames.chartDonut:t.classNames.chartPie),e=n.createChartRect(this.svg,t,a.padding),s=Math.min(e.width()/2,e.height()/2),o=t.total||c.reduce(function(t,e){return t+e},0),s-=t.donut?t.donutWidth/2:0,r="outside"===t.labelPosition||t.donut?s:"center"===t.labelPosition?0:s/2,r+=t.labelOffset;for(var u={x:e.x1+e.width()/2,y:e.y2+e.height()/2},d=1===this.data.series.filter(function(t){return t.hasOwnProperty("value")?0!==t.value:0!==t}).length,p=0;p<this.data.series.length;p++){var f=this.data.series[p];h[p]=this.svg.elem("g",null,null,!0),h[p].attr({"series-name":f.name},n.xmlNs.uri),h[p].addClass([t.classNames.series,f.className||t.classNames.series+"-"+n.alphaNumerate(p)].join(" "));var m=l+c[p]/o*360;m-l==360&&(m-=.01);var v=n.polarToCartesian(u.x,u.y,s,l-(0===p||d?0:.2)),g=n.polarToCartesian(u.x,u.y,s,m),x=new n.Svg.Path(!t.donut).move(g.x,g.y).arc(s,s,0,m-l>180,0,v.x,v.y);t.donut||x.line(u.x,u.y);var y=h[p].elem("path",{d:x.stringify()},t.donut?t.classNames.sliceDonut:t.classNames.slicePie);if(y.attr({value:c[p],meta:n.serialize(f.meta)},n.xmlNs.uri),t.donut&&y.attr({style:"stroke-width: "+ +t.donutWidth+"px"}),this.eventEmitter.emit("draw",{type:"slice",value:c[p],totalDataSum:o,index:p,meta:f.meta,series:f,
group:h[p],element:y,path:x.clone(),center:u,radius:s,startAngle:l,endAngle:m}),t.showLabel){var b=n.polarToCartesian(u.x,u.y,r,l+(m-l)/2),w=t.labelInterpolationFnc(this.data.labels?this.data.labels[p]:c[p],p);if(w||0===w){var E=h[p].elem("text",{dx:b.x,dy:b.y,"text-anchor":i(u,b,t.labelDirection)},t.classNames.label).text(""+w);this.eventEmitter.emit("draw",{type:"label",index:p,group:h[p],element:E,text:""+w,x:b.x,y:b.y})}}l=m}this.eventEmitter.emit("created",{chartRect:e,svg:this.svg,options:t})}function r(t,e,i,s){n.Pie.super.constructor.call(this,t,e,a,n.extend({},a,i),s)}var a={width:void 0,height:void 0,chartPadding:5,classNames:{chartPie:"ct-chart-pie",chartDonut:"ct-chart-donut",series:"ct-series",slicePie:"ct-slice-pie",sliceDonut:"ct-slice-donut",label:"ct-label"},startAngle:0,total:void 0,donut:!1,donutWidth:60,showLabel:!0,labelOffset:0,labelPosition:"inside",labelInterpolationFnc:n.noop,labelDirection:"neutral",reverseData:!1};n.Pie=n.Base.extend({constructor:r,createChart:s,determineAnchorPosition:i})}(window,document,t),t});