/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../smapServer/WebContent/js/app/common.js"
/*!*************************************************!*\
  !*** ../smapServer/WebContent/js/app/common.js ***!
  \*************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addCacheBuster: () => (/* binding */ addCacheBuster),
/* harmony export */   addDatePickList: () => (/* binding */ addDatePickList),
/* harmony export */   addFormPickList: () => (/* binding */ addFormPickList),
/* harmony export */   addGeomPickList: () => (/* binding */ addGeomPickList),
/* harmony export */   addHourglass: () => (/* binding */ addHourglass),
/* harmony export */   checkLoggedIn: () => (/* binding */ checkLoggedIn),
/* harmony export */   downloadFile: () => (/* binding */ downloadFile),
/* harmony export */   enableUserProfile: () => (/* binding */ enableUserProfile),
/* harmony export */   formItemsURL: () => (/* binding */ formItemsURL),
/* harmony export */   getEligibleUsers: () => (/* binding */ getEligibleUsers),
/* harmony export */   getFromLocalStorage: () => (/* binding */ getFromLocalStorage),
/* harmony export */   getLanguageList: () => (/* binding */ getLanguageList),
/* harmony export */   getLocations: () => (/* binding */ getLocations),
/* harmony export */   getLoggedInUser: () => (/* binding */ getLoggedInUser),
/* harmony export */   getNotificationTypes: () => (/* binding */ getNotificationTypes),
/* harmony export */   getTaskUsers: () => (/* binding */ getTaskUsers),
/* harmony export */   handleLogout: () => (/* binding */ handleLogout),
/* harmony export */   htmlDecode: () => (/* binding */ htmlDecode),
/* harmony export */   htmlEncode: () => (/* binding */ htmlEncode),
/* harmony export */   loadSurveys: () => (/* binding */ loadSurveys),
/* harmony export */   populateLanguageSelect: () => (/* binding */ populateLanguageSelect),
/* harmony export */   populatePdfSelect: () => (/* binding */ populatePdfSelect),
/* harmony export */   populateTaskGroupList: () => (/* binding */ populateTaskGroupList),
/* harmony export */   refreshLocationGroups: () => (/* binding */ refreshLocationGroups),
/* harmony export */   removeHourglass: () => (/* binding */ removeHourglass),
/* harmony export */   resultsURL: () => (/* binding */ resultsURL),
/* harmony export */   saveCurrentProject: () => (/* binding */ saveCurrentProject),
/* harmony export */   setLocationList: () => (/* binding */ setLocationList),
/* harmony export */   setSurveyViewLanguages: () => (/* binding */ setSurveyViewLanguages),
/* harmony export */   setupNotificationDialog: () => (/* binding */ setupNotificationDialog),
/* harmony export */   setupTaskDialog: () => (/* binding */ setupTaskDialog),
/* harmony export */   setupUserProfile: () => (/* binding */ setupUserProfile),
/* harmony export */   shapeFormsChanged: () => (/* binding */ shapeFormsChanged),
/* harmony export */   validGeneralName: () => (/* binding */ validGeneralName)
/* harmony export */ });
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./globals */ "../smapServer/WebContent/js/app/globals.js");
/* harmony import */ var _localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./localise */ "../smapServer/WebContent/js/app/localise.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

var gWait = 0;		// This javascript file only
var gCache = {};
var gCacheGroup = {};
var gCacheStatusQuestions = {};
var gCacheKeys = {};
var gEligibleUser;
var gSelectedOversightQuestion;
var gSelectedOversightSurvey;
var gConversationalSMS;	// Set true if a conversational SMS choice has been added to notification types




/*
 * Convert a choice list name into a valid jquery class name
 */
function jq(choiceList) {

	var c;

	c = choiceList.replace( /(:|\.|\[|\]|,)/g, "\\$1" );
	return c;
}


/*
 * ==============================================================
 * Task Functions
 * ==============================================================
 */


function addPendingTask(taskId, assignmentId, status, source) {
	var i,
		duplicate = false,
		assignment;

	assignment = {
		assignment_id: assignmentId,
		assignment_status: status,
		task_id: taskId
	};
	_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gPendingUpdates.push(assignment);

	if(source === "table") {
		updateMapTaskSelections(taskId, true);
	} else if(source === "map") {
		$('#tasks_table').find('[data-taskid=' + taskId + ']').prop("checked", true).closest('tr').addClass("info");
	}
}

function removePendingTask(taskId, source) {
	var i;
	for (i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gPendingUpdates.length; i++) {
		if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gPendingUpdates[i].task_id === taskId) {
			_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gPendingUpdates.splice(i,1);
			break;
		}
	}
	if(source === "table") {
		updateMapTaskSelections(taskId, false);
	} else if(source === "map") {
		$('#tasks_table').find('[data-taskid=' + taskId + ']').prop("checked", false).closest('tr').removeClass("info");
	}
}

/*
 * ===============================================================
 * Project Functions
 * ===============================================================
 */

/*
 * Update the list of available projects
 * Note when addAll is set to true the list is not used to change the default project
 *   In this case the value of the list should not be set to the default project
 */
function updateProjectList(addAll, projectId, callback, $projectSelect) {

	var i,
		h = [],
		idx = -1,
		updateCurrentProject;

	if(projectId > 0) {
		updateCurrentProject = true;		// Only save the current project if there it is set
	}

	if(addAll) {
		h[++idx] = '<option value="0">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_all"] + '</option>';
		updateCurrentProject = false;
	}
	for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gProjectList.length; i++) {
		h[++idx] = '<option value="';
		h[++idx] = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gProjectList[i].id;
		h[++idx] = '">';
		h[++idx] = htmlEncode(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gProjectList[i].name);
		h[++idx] = '</option>';

		if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gProjectList[i].id === projectId) {
			updateCurrentProject = false;   // Don't save the current project if it is already in the list
		}
	}
	$projectSelect.empty().append(h.join(''));

	// If for some reason the user's default project is no longer available then
	//  set the default project to the first project in the list
	//  if the list is empty then set the default project to undefined
	if(updateCurrentProject) {
		if (_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gProjectList[0]) {
			_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gProjectList[0].id;		// Update the current project id
			_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey = -1;
			_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentTaskGroup = undefined;
		} else {
			_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject = -1;		// Update the current project id
			_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey = -1;
			_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentTaskGroup = undefined;
		}

		saveCurrentProject(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject,
			_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey,
			_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentTaskGroup);
	}

	if(!addAll) {
		$projectSelect.val(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject);			// Set the initial project value
		$('#projectId').val(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject);			// Set the project value for the hidden field in template upload
	}

	if(typeof callback !== "undefined") {
		callback(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject);				// Call the callback with the correct current project
	}
}

/*
 * Get the list of available projects from the server
 */
function getMyProjects(projectId, callback, getAll) {
	addHourglass();
	$.ajax({
		url: "/surveyKPI/myProjectList",
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gProjectList = data;
				updateProjectList(getAll, projectId, callback, $('.project_list'));
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert("Error: Failed to get list of projects: " + err);
				}
			}
		}
	});
}

/*
 * Save the current project id in the user defaults
 */
function saveCurrentProject(projectId, surveyId, taskGroupId) {

	if(surveyId > 0 || projectId > 0 || taskGroupId > 0) {

		var user = {
			current_project_id: projectId,
			current_survey_id: surveyId,
			current_task_group_id: taskGroupId
		};

		var userString = JSON.stringify(user);

		addHourglass();
		$.ajax({
			type: "POST",
			contentType: "application/json",		// uses application/json
			url: "/surveyKPI/user/currentproject",
			cache: false,
			data: userString,
			success: function(data, status) {
				// Do not process a logout
				removeHourglass();
			}, error: function(data, status) {
				// Do not process a logout
				removeHourglass();
			}
		});
	}
}

/*
 * Save the current relationship between survey and surveyGroup
 */
function saveCurrentGroupSurvey(surveyId, gs, fName) {

	if (surveyId > 0) {

		var groupSurvey = {
			sId: surveyId,
			groupIdent: gs,
			fName: fName
		};

		addHourglass();
		$.ajax({
			type: "POST",
			contentType: "application/x-www-form-urlencoded",
			url: "/surveyKPI/user/groupsurvey",
			cache: false,
			data: JSON.stringify(groupSurvey),
			success: function (data, status) {
				removeHourglass();
				handleLogout(data);
			}, error: function (data, status) {
				removeHourglass();
			}
		});
	}
}

/*
 * ===============================================================
 * User Functions
 * ===============================================================
 */

/*
 * Add user details popup to the page
 * Legacy only used with non bootstrap pages - these should be replaced with bootstrap
 */
function addUserDetailsPopup() {
	var
		h =[],
		idx = -1;


	h[++idx] = '<div id="modify_me_popup" style="display:none;">';
	h[++idx] = '<div class="left_panel">';
	h[++idx] = '<form id="me_edit_form">';
	h[++idx] = '<label for="me_name">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_name"];
	h[++idx] = '</label>';
	h[++idx] = '<input type="text" id="me_name" required><br/>';

	h[++idx] = '<label for="me_language">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_lang"];
	h[++idx] = '</label>';
	h[++idx] = '<select class="language_select" id="me_language"></select><br/>';

	h[++idx] = '<label for="me_email">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_email"];
	h[++idx] = '</label>';
	h[++idx] = '<input type="text" id="me_email" pattern="^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$"><br/>';

	h[++idx] = '<label for="me_organisation">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_org"];
	h[++idx] = '</label>';
	h[++idx] = '<select class="organisation_select" id="me_organisation"></select><br/>';

	h[++idx] = '<label for="me_enterprise">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_ent"];
	h[++idx] = '</label>';
	h[++idx] = '<div id="me_enterprise"></div><br/>';

	h[++idx] = '<label for="u_tz">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_tz"];
	h[++idx] = '</label>';
	h[++idx] = '<select class="timezone_select" id="u_tz"></select>';

	h[++idx] = '</form>';
	h[++idx] = '</div>';
	h[++idx] = '</div>';

	$(document.body).append(h.join(''));

}

/*
 * Populate a language select widget
 */
function populateLanguageSelect(sId, $elem) {
	$.getJSON("/surveyKPI/languages/" + sId, function(data) {

		if(handleLogout(data)) {
			$elem.empty();
			$.each(data, function (j, item) {
				$elem.append('<option value="' + item + '">' + htmlEncode(item) + '</option>');
			});
		}
	});
}

/*
 * Populate a pdf select widget
 * Set the template set as the default to be selected
 * If there is no default template and there is a template specified in settings (legacy) then set that as the default
 */
function populatePdfSelect(sId, $elem) {
	var url = "/surveyKPI/surveys/templates/" + sId;
	url += addCacheBuster(url);

	$.getJSON(url, function(data) {

		if(handleLogout(data)) {
			var defaultTemplateId,
				fromSettingsTemplateId;

			$elem.empty();
			$elem.append('<option value="-2">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_auto"] + '</option>');
			$elem.append('<option value="-1">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"] + '</option>');
			$.each(data, function (j, item) {
				if (item.default_template) {
					defaultTemplateId = item.id;
				} else if (item.fromSettings) {
					fromSettingsTemplateId = item.id;
				}
				$elem.append('<option value="' + item.id + '">' + htmlEncode(item.name) + '</option>');
			});
			if (typeof defaultTemplateId !== "undefined") {
				$elem.val(defaultTemplateId);
			} else if (typeof fromSettingsTemplateId !== "undefined") {
				$elem.val(fromSettingsTemplateId)
			} else {
				$elem.val(-2);		// Set to auto
			}
		}

	});
}

/*
 * Add user details popup to the page
 */
function addUserDetailsPopupBootstrap4() {
	var	h =[],
		idx = -1;

	h[++idx] = '<div id="modify_me_popup" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modifyMeLabel" aria-hidden="true">';
	h[++idx] = '<div class="modal-dialog modal-lg">';
	h[++idx] = '<div class="modal-content">';
	h[++idx] = '<div class="modal-header">';
	h[++idx] = '<h4 class="modal-title" id="modifyMeLabel"></h4>';
	h[++idx] = '<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
	h[++idx] = '</div>';    // modal-headers

	h[++idx] = '<div class="modal-body">';
	h[++idx] = '<form role="form" id="me_edit_form">';
	h[++idx] = '<div class="form-group row">';
	h[++idx] = '<label for="me_name" class="col-sm-2 control-label">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_name"];
	h[++idx] = '</label>';
	h[++idx] = '<div class="col-sm-10">';
	h[++idx] = '<input type="text" id="me_name" required class="form-control">';
	h[++idx] = '</div>';
	h[++idx] = '</div>';

	h[++idx] = '<div class="form-group row">';
	h[++idx] = '<label for="me_language" class="col-sm-2 control-label">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_lang"];
	h[++idx] = '</label>';
	h[++idx] = '<div class="col-sm-10">';
	h[++idx] = '<select id="me_language" class="language_select form-control"></select>';
	h[++idx] = '</div>';
	h[++idx] = '</div>';

	h[++idx] = '<div class="form-group row">';
	h[++idx] = '<label for="me_email" class="col-sm-2 control-label">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_email"];
	h[++idx] = '</label>';
	h[++idx] = '<div class="col-sm-10">';
	h[++idx] = '<input type="email" class="form-control" id="me_email"';
	h[++idx] = ' placeholder="Enter email"';
	h[++idx] = ' pattern="^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$">';
	h[++idx] = '</div>';
	h[++idx] = '</div>';

	h[++idx] = '<div class="form-group row">';
	h[++idx] = '<label for="me_organisation" class="col-sm-2 control-label">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_org"];
	h[++idx] = '</label>';
	h[++idx] = '<div class="col-sm-10">';
	h[++idx] = '<select id="me_organisation" class="organisation_select form-control"></select>';
	h[++idx] = '</div>';
	h[++idx] = '</div>';

	h[++idx] = '<div class="form-group row">';
	h[++idx] = '<label for="me_enterprise" class="col-sm-2 control-label">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_ent"];
	h[++idx] = '</label>';
	h[++idx] = '<div class="col-sm-10">';
	h[++idx] = '<div id="me_enterprise" class="form-control"></div>';
	h[++idx] = '</div>';
	h[++idx] = '</div>';

	h[++idx] = '<div class="form-group row">';
	h[++idx] = '<label for="u_tz" class="col-sm-2 control-label">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_tz"];
	h[++idx] = '</label>';
	h[++idx] = '<div class="col-sm-10">';
	h[++idx] = '<select class="form-control timezone_select" id="u_tz"></select>';
	h[++idx] = '</div>';
	h[++idx] = '</div>';
	
	h[++idx] = '<div id="me_alert" class="alert d-none text-wrap text-break" role="alert"></div>';
	h[++idx] = '</form>';
	h[++idx] = '</div>';    // modal body

	h[++idx] = '<div class="modal-footer">';
	h[++idx] = '<button type="button" class="btn btn-default" data-dismiss="modal">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_close"];
	h[++idx] = '</button>';

	h[++idx] = '<button id="userProfileSave" type="button" class="btn btn-primary">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_save"];
	h[++idx] = '</button>';
	h[++idx] = '</div>';    // modal - footer
	h[++idx] = '</div>';        // modal - content
	h[++idx] = '</div>';            // modal - dialog
	h[++idx] = '</div>';                // popup

	$(document.body).append(h.join(''));

	enableUserProfileBS();
}

/*
 * Add user details popup to the page
 */
function addApiKeyPopup() {
	var	h =[],
		idx = -1;

	h[++idx] = '<div id="api_key_popup" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="apiKeyLabel" aria-hidden="true">';
	h[++idx] = '<div class="modal-dialog modal-lg">';
	h[++idx] = '<div class="modal-content">';
	h[++idx] = '<div class="modal-header">';
	h[++idx] = '<h4 class="modal-title" id="apiKeyLabel"></h4>';
	h[++idx] = '<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
	h[++idx] = '</div>';    // modal-headers

	h[++idx] = '<div class="modal-body">';
	h[++idx] = '<form>';
	h[++idx] = '<div class="form-group">';
	h[++idx] = '<input type="text" id="apiKey" required class="form-control" readOnly>';
	h[++idx] = '</div>';
	h[++idx] = '</form>';
	h[++idx] = '<button id="getKey" type="button" class="btn btn-primary">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_gak"];
	h[++idx] = '</button>';
	h[++idx] = '<button id="deleteKey" type="button" class="btn btn-danger ml-2">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_del"];
	h[++idx] = '</button>';
	h[++idx] = '<button id="copyKey" type="button" class="btn btn-default has_tt ml-2" title="Copy Key">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_ck"];
	h[++idx] = '</button>';
	h[++idx] = '</div>';

	h[++idx] = '<div class="modal-footer">';
	h[++idx] = '<button type="button" class="btn btn-default" data-dismiss="modal">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_close"];
	h[++idx] = '</button>';

	h[++idx] = '</div>';    // modal - footer
	h[++idx] = '</div>';        // modal - content
	h[++idx] = '</div>';            // modal - dialog
	h[++idx] = '</div>';                // popup

	$(document.body).append(h.join(''));

	enableApiKeyPopup();
}


/*
 * Update the user details on the page
 */
function updateUserDetails(data, getOrganisationsFn, getEnterprisesFn, getServerDetailsFn) {

	var groups = data.groups,
		i,
		bootstrap_enabled = (typeof $().modal == 'function');

	if(data.language && data.language !== gUserLocale) {
		try {
			localStorage.setItem('user_locale', data.language);  // Write to storage may be disabled
			location.reload();
		} catch (e) {

		}

	} else if(data.o_id != _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gOrgId) {
		location.reload();
	}

	_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser = data;
	_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gOrgId = data.o_id;

	// Save the organisation name for the logon screen
	try {
		localStorage.setItem('org_name', data.organisation_name);
	} catch (e) {

	}

	if(bootstrap_enabled) {

		$('#modify_me_popup').on('show.bs.modal', function (event) {
			var $this = $(this)
			$this.find('.modal-title').text(data.ident + "@" + data.organisation_name)

			$("#me_alert").hide();

			$('#me_edit_form')[0].reset();
			$('#reset_me_password_fields').removeClass('d-none').show();
			$('#password_me_fields').hide();
			addLanguageOptions($('.language_select'), data.language);
			addOrganisationOptions($('.organisation_select'), data.o_id, data.orgs);
			$('#me_name').val(data.name);
			$('#me_email').val(data.email);
			$('#me_enterprise').text(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gEnterpriseName);
			$('#u_tz').val(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone);

			$(".navbar-collapse").removeClass("in").addClass("collapse");	// Remove drop down menu
		});


	} else {
		$('#username').text(data.name).button({ label: htmlEncode(data.name),
			icons: { primary: "ui-icon-person" }}).off().click(function(){
			$('#me_edit_form')[0].reset();

			$('#reset_me_password_fields').removeClass('d-none').show();
			$('#password_me_fields').hide();
			addLanguageOptions($('.language_select'), data.language);
			addOrganisationOptions($('.organisation_select'), data.o_id, data.orgs);
			$('#me_name').val(data.name);
			$('#me_email').val(data.email);
			$('#me_enterprise').text(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gEnterpriseName);
			$('#u_tz').val(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone);

			$('#modify_me_popup').dialog("option", "title", htmlEncode(data.name + "@" + data.organisation_name));
			$('#modify_me_popup').dialog("open");
		});
	}

	/*
	 * Show restricted functions
	 */
	if(groups) {
		for(i = 0; i < groups.length; i++) {
			if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_ADMIN) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsAdministrator = true;

                if(data.billing_enabled) {
                    _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gOrgBillingData = true;
                }

			} else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_ORG_ADMIN) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsOrgAdministrator = true;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gBillingData = true;

			} else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_SECURITY) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsSecurityAdministrator = true;

			} else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_ENTERPRISE) {
                _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsEnterpriseAdministrator = true;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gBillingData = true;

            } else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_LINKAGES) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsLinkFollower = true;

			} else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_ANALYST) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsAnalyst = true;

			} else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_DASHBOARD) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsDashboard = true;

			} else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_MANAGE) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsManage = true;

			} else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_ENUM) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsEnum = true;

			} else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_VIEW_DATA) {
                _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gViewData = true;

            } else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_MANAGE_TASKS) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gManageTasks = true;

			} else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_OWNER) {
                _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsServerOwner = true;

            } else if(groups[i].id === _globals__WEBPACK_IMPORTED_MODULE_0__["default"].GROUP_CONSOLE_ADMIN) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsConsoleAdmin = true;
			}
		}
	}

	// Only show items relevant to a user
	$('.restrict_role').hide();
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsEnum) {
		$('.enum_role').removeClass('d-none').show();
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsAnalyst) {
		$('.analyst_role').removeClass('d-none').show();
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsDashboard) {
		$('.dashboard_role').removeClass('d-none').show();
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gViewData) {
		$('.data_role').removeClass('d-none').show();
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gManageTasks) {
		$('.task_role').show();
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsAdministrator) {
		$('.admin_role').removeClass('d-none').show();
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsManage) {
		$('.manage_role').removeClass('d-none').show();
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsSecurityAdministrator) {
		$('.security_role').removeClass('d-none').show();
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsOrgAdministrator) {  // Admins can see their personal organisations
		$('.org_role').removeClass('d-none').show();
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsOrgAdministrator || _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsAdministrator) {  // Admins can see their personal organisations
		if(typeof getOrganisationsFn === "function") {
			getOrganisationsFn();
		}
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsEnterpriseAdministrator) {
		$('.enterprise_role').removeClass('d-none').show();
		if(typeof getEnterprisesFn === "function") {
			getEnterprisesFn();
		}
	}
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsServerOwner) {
		$('.owner_role').removeClass('d-none').show();
		if(typeof getServerDetailsFn === "function") {
			getServerDetailsFn();
		}
	}

	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTraining) {
		$('#train_link').prop("href", _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTraining);
		$('#m_training').removeClass('d-none').show();
	}

	//TODO set logic for enabling disabling billing
	if(isBusinessServer() && (_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gBillingData || _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gOrgBillingData)) {
		$('.billing_role').removeClass('d-none').show();
	}

	// Other conditional elements
	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSendTrail === 'off') {
		$('.user_trail').hide();
	}

	// 	Customer configurable details - the configurable part is TODO
	$('#my_name').val(data.name);			// Add the name to the configurable list

	if(data.settings) {
		var userDetails = JSON.parse(data.settings);
		$('#my_title').val(userDetails.title);
		$('#my_license').val(userDetails.license);
		$('#my_signature').attr("src", "/surveyKPI/file/" + data.signature + "/users?type=sig");
	}

	// Hide any menus that have been disabled by custom java scripts
	$('.perm_dis_menu').hide();
}

function addLanguageOptions($elem, current) {

	var h = [],
		idx = -1,
		i,
		languages = [
			{
				locale: "ar",
				name: "Arabic"
			},
			{
				locale: "en",
				name: "English"
			},
			{
				locale: "fr",
				name: "French"
			},
			{
				locale: "hi",
				name: "Hindi"
			},
			{
				locale: "pt",
				name: "Portugese"
			},
			{
				locale: "es",
				name: "Spanish"
			},
			{
				locale: "uk",
				name: "Ukrainian"
			}
		];

	for(i = 0; i < languages.length; i++) {
		h[++idx] = '<option value="';
		h[++idx] = languages[i].locale;
		h[++idx] = '">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set[languages[i].locale];
		h[++idx] = '</option>';
	}
	$elem.html(h.join(''));
	if(current) {
		$elem.val(current);
	} else {
		$elem.val("en");
	}
}

function addOrganisationOptions($elem, current, orgs) {

	var h = [],
		idx = -1,
		i;

	for(i = 0; i < orgs.length; i++) {
		h[++idx] = '<option value="';
		h[++idx] = orgs[i].id;
		h[++idx] = '">';
		h[++idx] = htmlEncode(orgs[i].name);
		h[++idx] = '</option>';
	}
	$elem.html(h.join(''));
	if(current) {
		$elem.val(current);
	}
}

/*
 * Enable the user profile button
 */
function enableUserProfile () {
	// Initialise the dialog for the user to edit their own account details
	$('#modify_me_popup').dialog(
		{
			autoOpen: false, closeOnEscape:true, draggable:true, modal:true,
			title:"User Profile",
			show:"drop",
			width:350,
			height:350,
			zIndex: 2000,
			buttons: [
				{
					text: "Cancel",
					click: function() {

						$(this).dialog("close");
					}
				}, {
					text: "Save",
					click: function() {

						var user = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser;

						user.name = $('#me_name').val();
						user.language = $('#me_language').val();
						user.email = $('#me_email').val();
						if($('#me_password').is(':visible')) {
							user.password = $('#me_password').val();
							if($('#me_password_confirm').val() !== user.password) {
								user.password = undefined;
								alert("Passwords do not match");
								$('#me_password').focus();
								return false;
							}
						} else {
							user.password = undefined;
						}

						user.current_project_id = 0;	// Tell service to ignore project id and update other details
						user.current_survey_id = 0;
						user.current_task_group_id = 0;

						user.timezone = $('#u_tz').val();
						_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone = user.timezone;

						user.o_id = $('#me_organisation').val();
						if(user.o_id == _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gOrgId) {
							user.o_id = 0;	// No change
						}

						saveCurrentUser(user, undefined);			// Save the updated user details to disk
						$(this).dialog("close");
					},
				}
			]
		}
	);


	// Initialise the reset password checkbox
	$('#reset_me_password').click(function () {
		if($(this).is(':checked')) {
			$('#password_me_fields').removeClass('d-none').show();
		} else {
			$('#password_me_fields').hide();
		}
	});
}

/*
 * Enable the user profile button
 */
function enableUserProfileBS () {

	$("#modify_me_popup :input").keydown(function() {
		$("#me_alert").hide();
	});

	/*
	 * Save the user profile
	 */
	$('#userProfileSave').click(function() {
		var user = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser;

		user.name = $('#me_name').val();
		user.language = $('#me_language').val();
		user.email = $('#me_email').val();
		if($('#me_password').is(':visible')) {
			user.password = $('#me_password').val();
			if($('#me_password_confirm').val() !== user.password) {
				user.password = undefined;
				$('#me_alert').removeClass('alert-success d-none').addClass('alert-danger').text(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_pwd_m"]).show();
				$('#me_password').focus();
				return false;
			}
		} else {
			user.password = undefined;
		}

		user.o_id = $('#me_organisation').val();
		if(user.o_id == _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gOrgId) {
			user.o_id = 0;	// No change
		}

		_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone = $('#u_tz').val();
		user.timezone = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone;

		user.current_project_id = 0;	// Tell service to ignore project id and update other details
		user.current_survey_id = 0;
		user.current_task_group_id = 0;

		saveCurrentUser(user, $('#modify_me_popup'));			// Save the updated user details to disk
	});


	// Initialise the reset password checkbox
	$('#reset_me_password').click(function () {
		if($(this).is(':checked')) {
			$('#password_me_fields').removeClass('d-none').show();
		} else {
			$('#password_me_fields').hide();
		}
	});
}

/*
 * Respond to events on the API key popup
 */
function enableApiKeyPopup() {

	$('#api_key_popup').on('show.bs.modal', function (event) {
		/*
		 * Get the current API key
		 */
		$('#getKey').prop('disabled', true);
		addHourglass();
		$.ajax({
			url: '/surveyKPI/user/api_key',
			cache: false,
			success: function (data) {
				removeHourglass();
				if (handleLogout(data)) {
					$('#apiKey').val(data.apiKey);
					$('#getKey').prop('disabled', false);
					if (data.apiKey) {
						$('#getKey').text(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_rak"]);
						$('#deleteKey,#copyKey').prop('disabled', false);
					} else {
						$('#getKey').text(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_gak"]);
						$('#deleteKey,#copyKey').prop('disabled', true);
					}
				}
			},
			error: function (xhr, textStatus, err) {
				removeHourglass();
				if (handleLogout(xhr.responseText)) {
					$('#getKey').prop('disabled', false);
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert(err);
						console.log("Error: Failed to get api key: " + err);
					}
				}
			}
		});
	});

	/*
	 * Delete a key
	 */
	$('#deleteKey').on("click",function () {
		addHourglass();
		$.ajax({
			type: "DELETE",
			url: '/surveyKPI/user/api_key',
			cache: false,
			success: function (data) {
				removeHourglass();
				if (handleLogout(data)) {
					$('#apiKey').val("");
					$('#getKey').prop('disabled', false);
					$('#getKey').text(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_gak"]);
					$('#deleteKey,#copyKey').prop('disabled', true);
				}
			},
			error: function (xhr, textStatus, err) {
				removeHourglass();
				if (handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert(err);
						console.log("Error: Failed to delete api key: " + err);
					}
				}
			}
		});
	});

	/*
	 * Create a key
	 */
	$('#getKey').on("click", function () {
		addHourglass();
		$.ajax({
			type: "POST",
			cache: false,
			contentType: "application/x-www-form-urlencoded",
			dataType: 'json',
			url: "/surveyKPI/user/api_key/create",
			success: function (data) {
				removeHourglass();
				if (handleLogout(data)) {
					$('#apiKey').val(data.apiKey);
					$('#getKey').text(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_rak"]);
					$('#deleteKey,#copyKey').prop('disabled', false);
				}
			},
			error: function (xhr, textStatus, err) {
				removeHourglass();
				if (handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert(err);
						console.log("Error: Failed to get api key: " + err);
					}
				}
			}
		});
	});

	// Respond to a user clicking copy api key
	$('.has_tt').tooltip();
	$('#copyKey').click(function () {
		var copyText = document.getElementById("apiKey");
		copyText.select();
		navigator.clipboard.writeText($('#apiKey').val());

		$('#copyKey').tooltip('dispose').tooltip({title: _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_c"] + ": " + copyText.value}).tooltip('show');

	});
	$('#copyKey').mouseout(function () {
		$('#copyKey').tooltip({title: _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_c"]});
	});
}

/*
 * Save the currently logged on user's details
 */
function saveCurrentUser(user, $dialog) {

	var fd = new FormData();
	fd.append("user", JSON.stringify(user));
	addHourglass();
	$.ajax({
		method: "POST",
		cache: false,
		contentType: false,
		processData: false,
		url: "/surveyKPI/user",
		data: fd,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				if (data.error) {
					if ($dialog) {
						$('#me_alert').removeClass('alert-success d-none').addClass('alert-danger').text(data.msg).show();
					} else {
						alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + " : " + data.msg);  // legacy non bootstrap
					}
				} else if ($dialog) {
					$dialog.modal("hide");
				}
				updateUserDetails(data, undefined);
			}

		}, error: function(data, status) {
			removeHourglass();
			alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + " : " + data.responseText);
		}
	});
}

function getAvailableTimeZones(callback) {
	addHourglass();
	$.ajax({
		url: "/surveyKPI/utility/timezones",
		cache: true,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				if (typeof callback == "function") {
					callback(data);
				}
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + ": " + err);
				}
			}
		}
	});
}

function showTimeZones(timeZones) {
	var h =[],
		idx = -1,
		i,
		tz;

	for (i = 0; i < timeZones.length; i++) {
		tz = timeZones[i];
		h[++idx] = '<option value="';
		h[++idx] = tz.id;
		h[++idx] = '">';
		h[++idx] = htmlEncode(tz.name);
		h[++idx] = '</option>';
	}
	$('.timezone_select').empty().html(h.join(''));
	if(!_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone) {
		_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone = Intl.DateTimeFormat().resolvedOptions().timeZone;      // Browser timezone
	}
	$('#u_tz').val(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone);   // Set time zone in user profile
	$('#timezone').text(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_tz"] + ": " + _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone);   // Show timezone where this is enabled
}

function addTimeZoneToUrl(url) {
	if(url) {
		if(url.indexOf("?") > 0) {
			url += "&";
		} else {
			url += "?";
		}
		url += "tz=";
		url += encodeURIComponent(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone);
	}
	return url;
}

/*
 * Create the user profile dialog and get any data it needs
 */
function setupUserProfile(bs4) {

	if(bs4) {
		addUserDetailsPopupBootstrap4();
		addApiKeyPopup();
	} else {
		addUserDetailsPopup();	// legacy
	}
	getAvailableTimeZones(showTimeZones);
}

function getLoggedInUser(callback, getAll, getProjects, getOrganisationsFn, hideUserDetails,
                         dontGetCurrentSurvey, getEnterprisesFn, getServerDetailsFn, getSMSNumbers) {

	_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gIsAdministrator = false;

	addHourglass();
	$.ajax({
		url: "/surveyKPI/user",
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				var i;

				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gServerCanSendEmail = data.sendEmail;

				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gEmailEnabled = data.allow_email;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gFacebookEnabled = data.allow_facebook;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTwitterEnabled = data.allow_twitter;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCanEdit = data.can_edit;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSendTrail = data.ft_send_location;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gAlertSeen = data.seen;		// Alerts have been acknowledged
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLastAlertTime = data.lastalert;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gOrgId = data.o_id;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gEntId = data.e_id;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gEnterpriseName = data.enterprise_name;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSetAsTheme = data.set_as_theme;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gNavbarColor = data.navbar_color;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gNavbarTextColor = data.navbar_text_color;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTraining = data.training;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gRefreshRate = data.refresh_rate;

				if (data.timezone) {
					_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone = data.timezone;
				} else {
					_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
				}
				$('#u_tz').val(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone);

				if (!hideUserDetails) {
					updateUserDetails(data, getOrganisationsFn, getEnterprisesFn, getServerDetailsFn);
				}

				if(getSMSNumbers) {
					getSMSNumbers();
				}

				if(data.totalTasks > 0) {
					$('.total_tasks').html('(' + htmlEncode(data.totalTasks) + ')').addClass('btn-danger');
				}

				if (!dontGetCurrentSurvey) {	// Hack, on edit screen current survey is set as parameter not from the user's defaults
					_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey = data.current_survey_id;
					_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurveyIdent = data.current_survey_ident;
				}
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject = data.current_project_id;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentTaskGroup = data.current_task_group_id;
				$('#projectId').val(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject);		// Set the project value for the hidden field in template upload
				if (data.groupSurveys) {
					for (i = 0; i < data.groupSurveys.length; i++) {
						_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gGroupSurveys[data.groupSurveys[i].sId] = data.groupSurveys[i].groupIdent;
						_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSubForms[data.groupSurveys[i].sId] = data.groupSurveys[i].fName;
					}
				}

				setOrganisationTheme();

				if (getProjects) {
					getMyProjects(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject, callback, getAll);	// Get projects
				} else {
					if (typeof callback !== "undefined") {
						callback(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey);				// Call the callback with the correct current survey
					}
				}
			}

		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0 || xhr.status == 401) {
					return;  // Not an error or an authorisation error which is handled by the service worker
				} else {
					console.log("Error: Failed to get user details: " + err);

					var msg = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + ": ";
					if (err && err.message && err.message.indexOf('Unauthorized') >= 0) {
						msg += _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_auth"];
					} else {
						msg += err;
					}
					alert(msg);
				}
			}
		}
	});
}

/*
 * ===============================================================
 * Common functions for managing media (on both the edit page and shared resource page)
 * ===============================================================
 */

/*
 * Upload files to the server
 */
function uploadFiles(url, formName, callback1) {

	let f = document.forms.namedItem(formName),
		formData = new FormData(f);

	url = addUrlParam(url, "getlist=true");
	addHourglass();
	$('.submitFiles').addClass('disabled');
	$.ajax({
		url: url,
		type: 'POST',
		data: formData,
		cache: false,
		contentType: false,
		processData:false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				let cb1 = callback1;
				$('.upload_file_msg').show().removeClass('alert-danger').addClass('alert-success').html(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_success"]);
				if (typeof cb1 === "function") {
					cb1(data);
				}
				document.forms.namedItem(formName).reset();
				$('#fileAddLocations').modal('hide');
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				document.forms.namedItem(formName).reset();
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					var msg = htmlEncode(xhr.responseText);
					if (msg && msg.indexOf("no tags") >= 0) {
						msg = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_u_nt"];
					} else {
						msg = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_u_f"] + " : " + msg;
					}
					$('.upload_file_msg').show().removeClass('alert-success').addClass('alert-danger').html(msg);
					$('#fileAddLocations').modal('hide');
				}
			}
		}
	});
}

/*
 * Add a parameter to a URL
 */
function addUrlParam(url, param) {
	if(url.indexOf("?") > 0) {
		url += "&" + param;
	} else {
		url += "?" + param;
	}
	return url;
}

/*
 * Refresh the media view and then set the mode to manage
 */
function refreshMediaViewManage(data, sId) {
	refreshMediaView(data, sId);
	$('.mediaManage').show();
	$('.mediaSelect').hide();
}
/*
 * Refresh the view of any attached media if the available media items has changed
 * sId is set if a resources for that survey are being viewed
 */
function refreshMediaView(data, sId) {

	var i,
		$elementMedia,
		$elementCsv,
		hCsv = [],
		idxCsv = -1,
		hMedia = [],
		idxMedia = -1;

	if(sId) {
		$('#survey_id').val(sId);
	}

	if(data) {
		window.gFiles = data.files;
		let files = data.files;

		$elementMedia = $('#filesOrg');
		$elementCsv = $('#csvOrg');

		if(files) {
			for (i = 0; i < files.length; i++) {
				if (files[i].type === 'csv') {
					hCsv[++idxCsv] = getMediaRecord(files[i], 'csv', i, sId > 0);
				} else {
					hMedia[++idxMedia] = getMediaRecord(files[i], 'media', i, sId > 0);
				}
			}
		}

		$elementMedia.html(hMedia.join(""));
		$elementCsv.html(hCsv.join(""));

		$('.media_delete').click(function () {
			let item = window.gFiles[$(this).val()];

			if(confirm(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_confirm_del"] + " " + htmlEncode(item.name))) {
				delete_media(item.name, sId);
			}
		});

		$('.media_history').click(function () {
			var item = window.gFiles[$(this).val()];
			var url = '/app/resource_history.html?resource=' + item.name;
			if(sId) {
				url += '&survey_id=' + sId;
			}
			window.location.href = url;
		});

		$('.csv_replace').click(function(e) {

			$('#fileCsv').show();
			$('#fileMedia').hide();

			replace(window.gFiles[$(this).val()]);
		});

		$('.media_replace').click(function(e) {

			$('#fileCsv').hide();
			$('#fileMedia').show();

			replace(window.gFiles[$(this).val()]);
		});

	}

	// If this is the organisational view we can refresh the list of choices for selecting vector maps
	if(!sId) {
		refreshVectorSelects(data);
	}
}

function replace(item) {

	$('#uploadAction').val('replace');
	$('#itemName').val(getBaseName(item.name));

	$('.upload_alert').hide();
	$('.notreplace').hide();
	$('#media_add_title').text(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["tm_c_sr_rep"] + ": " + item.name);

	$('#fileAddPopup').modal('show');

}
function getBaseName(fileName) {
	let lastDot = fileName.lastIndexOf(".");
	let baseName = fileName;
	if (lastDot !== -1) {
		baseName = fileName.substr(0, lastDot);
	}
	return baseName;
}
function getMediaRecord(file, panel, record, surveyLevel) {
	var h = [],
		idx = -1;

	h[++idx] = '<tr class="';
	h[++idx] = htmlEncode(file.type);
	h[++idx] = '">';

	if(panel === 'media') {
		h[++idx] = '<td class="preview">';
		h[++idx] = '<a target="_blank" href="';
		h[++idx] = htmlEncode(file.url) + addCacheBuster(file.url);
		h[++idx] = '">';
		if (file.type == "audio") {
			h[++idx] = addAudioIcon();
		} else if (file.type == "geojson") {
			h[++idx] = addVectorMapIcon();
		} else {
			h[++idx] = '<img width="100" height="100" src="';
			h[++idx] = htmlEncode(file.thumbnailUrl) + addCacheBuster(file.thumbnailUrl);
			h[++idx] = '" alt="';
			h[++idx] = htmlEncode(file.name);
			h[++idx] = '">';
		}
		h[++idx] = '</a>';
		h[++idx] = '</td>';
	}

	h[++idx] = '<td class="filename">';
	h[++idx] = '<p>';
	h[++idx] = htmlEncode(file.name);
	h[++idx] = '</p>';
	h[++idx] = '</td>';

	h[++idx] = '<td class="mediaManage">';
	h[++idx] = localTime(file.modified);
	h[++idx] = '</td>';

	h[++idx] = '<td class="mediaManage">';
	h[++idx] = '<p>';
	h[++idx] = htmlEncode(file.size);
	h[++idx] = '</p>';
	h[++idx] = '</td>';

	h[++idx] = '<td class="mediaManage">';
	h[++idx] = '<button class="btn ';
	h[++idx] = (panel === 'csv') ? 'csv_replace' : 'media_replace';
	h[++idx] = '" value="';
	h[++idx] = record;
	h[++idx] = '">';
	h[++idx] = '<i class="fas fa-sync-alt"></i>';
	h[++idx] = '</button>';
	h[++idx] = '</td>';

	// Action Buttons
	let downloadUrl = '/surveyKPI/shared/latest/' + file.name
		+ (surveyLevel ? '?sIdent=' + _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurveyIdent : '');
	h[++idx] = '<td class="mediaManage">';
	h[++idx] = '<a class="media_download btn btn-info" href="';					// Download
	h[++idx] = htmlEncode(downloadUrl + addCacheBuster(downloadUrl));
	h[++idx] = '">';
	h[++idx] = '<i class="fas fa-download"></i>'
	h[++idx] = '</a>';
	h[++idx] = '<button class="media_history btn btn-primary" value="';	// History
	h[++idx] = record;
	h[++idx] = '">';
	h[++idx] = '<i class="fas fa-landmark"></i>'
	h[++idx] = '</button>';
	h[++idx] = '<button class="media_delete btn btn-danger" value="';		// Delete
	h[++idx] = record;
	h[++idx] = '">';
	h[++idx] = '<i class="fas fa-trash-alt"></i>'
	h[++idx] = '</button>';

	h[++idx] = '</td>';

	h[++idx] = '<td class="mediaSelect">';
	h[++idx] = '<button class="mediaAdd btn btn-success">';
	h[++idx] = '<i class="fas fa-plus"></i> '
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['c_add'];
	h[++idx] = '</button>';
	h[++idx] = '</td>';


	h[++idx] = '</tr>';

	return h.join('');
}
/*
 * Refresh the vector select lists
 */
function refreshVectorSelects(data) {

	var i,
		$vectorData = $('#vector_data'),
		$vectorStyle = $('#vector_style'),
		h_d = [],
		idx_d = -1,
		h_s = [],
		idx_s = -1,
		files;

	if(data) {
		files = data.files;

		for(i = 0; i < files.length; i++){
			if(files[i].type === "geojson") {
				h_d[++idx_d] = '<option value="';
				h_d[++idx_d] = files[i].name;
				h_d[++idx_d] = '">';
				h_d[++idx_d] = htmlEncode(files[i].name);
				h_d[++idx_d] = '</option>';
			}

			if(files[i].type === "TODO") {
				h_s[++idx_s] = '<option value="';
				h_s[++idx_s] = files[i].name;
				h_s[++idx_s] = '">';
				h_s[++idx_s] = htmlEncode(files[i].name);
				h_s[++idx_s] = '</option>';
			}

		}


		$vectorData.html(h_d.join(""));
		$vectorStyle.html(h_s.join(""));
	}
}

function addAudioIcon() {
	var h = [],
		idx = -1;

	h[++idx] = '<span class="has_tt" title="Audio">';
	h[++idx] = '<span class="glyphicon glyphicon-volume-up edit_type"></span>';
	h[++idx] = '</span>';

	return h.join('');
}

function addVectorMapIcon() {
	var h = [],
		idx = -1;

	h[++idx] = '<span class="has_tt" title="Audio">';
	h[++idx] = '<span class="glyphicon glyphicon glyphicon-map-marker edit_type"></span>';
	h[++idx] = '</span>';

	return h.join('');
}

function getFilesFromServer(sId, callback, getall) {

	let url = '/surveyKPI/upload/media';
	let hasParams = false;
	if(sId) {
		url += '?survey_id=' + sId;
		hasParams = true;
	}
	if(getall) {
		url += (hasParams ? '&' : '?') + 'getall=true';
	}

	url += addCacheBuster(url);

	addHourglass();
	$.ajax({
		url: url,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				let surveyId = sId;
				callback(data, surveyId);
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					$('.upload_file_msg').removeClass('alert-success').addClass('alert-danger').html("Error: " + htmlEncode(err));
				}
			}
		}
	});
}

/*
 * Delete a media file
 */
function delete_media(filename, sId) {

	var url = "/surveyKPI/shared/file/" + encodeURIComponent(filename);

	if(sId > 0) {
		url += '?survey_id=' + sId;
	}

	addHourglass();
	$.ajax({
		url: url,
		type: 'DELETE',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				var surveyId = sId;
				getFilesFromServer(surveyId, refreshMediaViewManage, false);
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert("Error: " + err);
				}
			}
		}
	});

}
/*
 * ===============================================================
 * Hourglass Functions
 * ===============================================================
 */

function addHourglass() {

	if(gWait === 0) {

		$("#hour_glass,.hour_glass,.sk-spinner").show();
	}
	++gWait;
}

function removeHourglass() {

	--gWait;
	if(gWait === 0) {

		$("#hour_glass,.hour_glass,.sk-spinner").hide();
	}

}

/*
 * ===============================================================
 * Survey Functions
 * ===============================================================
 */

/*
 * Load the surveys from the server
 */
function loadSurveys(projectId, selector, getDeleted, addAll, callback, useIdx, sId, addNone, incReadOnly) {

	var url="/surveyKPI/surveys?projectId=" + projectId + "&blocked=true";

	if(selector === undefined) {
		selector = ".survey_select";	// Update the entire class of survey select controls
	}

	if(typeof projectId !== "undefined" && projectId > 0) {

		if(getDeleted) {
			url+="&deleted=true";
		}

		addHourglass();

		$.ajax({
			url: url,
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				if(handleLogout(data)) {
					var sel = selector;
					var all = addAll;

					showSurveyList(data, sel + ".data_survey", all, true, false, useIdx, sId, addNone, false, incReadOnly);
					showSurveyList(data, sel + ".oversight_survey", all, false, true, useIdx, sId, addNone, false, incReadOnly);
					showSurveyList(data, sel + ".data_oversight_survey", all, true, true, useIdx, sId, addNone, false, incReadOnly);
					showSurveyList(data, ".bundle_select", all, true, true, false, sId, addNone, true, incReadOnly);

					if (typeof callback == "function") {
						callback(data);
					}
				}
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						console.log("Error: Failed to get list of surveys: " + err);
					}
				}
			}
		});
	} else {
		var $elem = $('.data_survey, .oversight_survey, .data_oversight_survey');
		$elem.empty();
		if(addAll) {
			$elem.append('<option value="_all">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_all_s"] + '</option>');
		}

		if(callback) {
			callback();
		}

	}
}

/*
 * Load the surveys from the server
 */
function loadSurveyIdentList(projectId, sIdent, addAll, addNone) {

	var url="/surveyKPI/surveys/project/" + projectId;
	var selector = ".survey_select";

	if(typeof projectId !== "undefined" && projectId > 0) {
		addHourglass();
		$.ajax({
			url: url,
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				if(handleLogout(data)) {
					var sel = selector;

					showIdentSurveyList(data, sel, addAll, sIdent, addNone);

				}
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						console.log("Error: Failed to get list of surveys: " + err);
					}
				}
			}
		});
	}
}

/*
 * Show the surveys in select controls
 */
function showSurveyList(data, selector, addAll, dataSurvey, oversightSurvey, useIdx, sId, addNone, bundle, incReadOnly) {

	var i,
		item,
		h = [],
		idx = -1,
		$elem,
		$elem_disable_blocked,
		selValue;

	$elem = $(selector);
	$elem_disable_blocked = $(selector + ".disable_blocked");

	$elem.empty();
	var valueSelected = false;
	if(addAll) {
		h[++idx] = '<option value="_all">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_all_s"];		// All Surveys
		h[++idx] = '</option>';

		selValue = "_all";
		valueSelected = true;
	}
	if(addNone) {
		h[++idx] = '<option value="0">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"];		// No survey
		h[++idx] = '</option>';
	}

	var bundleObj = {};
	for(i = 0; i < data.length; i++) {
		item = data[i];
		if(!bundle || !bundleObj[item.groupSurveyDetails]) {	// If this is for a bundle list remove duplicate entries
			if ((incReadOnly || !item.readOnlySurvey) && (item.dataSurvey && dataSurvey || item.oversightSurvey && oversightSurvey)) {
				h[++idx] = '<option';
				if (!valueSelected && !item.blocked) {
					valueSelected = true;
					selValue = useIdx ? i : item.id;
				}
				if (item.blocked && !bundle) {
					h[++idx] = ' class="blocked"';
				}
				h[++idx] = ' value="';
				if(bundle) {
					h[++idx] = useIdx ? i : item.groupSurveyIdent;
				} else {
					h[++idx] = useIdx ? i : item.id;
				}
				h[++idx] = '">';
				if(bundle){
					h[++idx] = htmlEncode(item.groupSurveyDetails);
					bundleObj[item.groupSurveyDetails] = '1';
				} else {
					h[++idx] = htmlEncode(item.displayName);

					if (item.blocked) {
						h[++idx] = ' (' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_blocked"] + ')';
					}
				}
				h[++idx] = '</option>';
			}
			if (typeof sid === 'undefined') {
				if (_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey > 0 && _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey === item.id) {
					selValue = useIdx ? i : item.id;
				}
			} else {
				if (sId > 0 && sId === item.id) {
					selValue = useIdx ? i : item.id;
				}
			}
		}
	}

	$elem.empty().append(h.join(''));
	$elem.val(selValue);
	$("option.blocked", $elem_disable_blocked).attr("disabled", "disabled");

}

/*
 * Show the surveys in select boxes
 */
function showIdentSurveyList(data, selector, addAll, sIdent, addNone) {

	var i,
		item,
		h = [],
		idx = -1,
		$elem;

	$elem = $(selector);

	$elem.empty();
	if(addAll) {
		h[++idx] = '<option value="_all">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_all_s"];		// All Surveys
		h[++idx] = '</option>';
	}
	if(addNone) {
		h[++idx] = '<option value="_none">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"];		// No Survey
		h[++idx] = '</option>';
	}

	for(i = 0; i < data.length; i++) {
		item = data[i];
		h[++idx] = '<option';
		h[++idx] = ' value="';
		h[++idx] = item.ident;
		h[++idx] = '">';
		h[++idx] = htmlEncode(item.name);
		h[++idx] = '</option>';
	}

	$elem.empty().append(h.join(''));
	if(sIdent) {
		$elem.val(sIdent);
	} else {
		$elem.val("_none");
	}

}


// Common Function to get the language and question list (for the default language)
function getLanguageList(sId, callback, addNone, selector, setGroupList, filterQuestion) {

	if(typeof sId === "undefined") {
		sId = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey;
	}

	if(typeof filterQuestion === "undefined") {
		filterQuestion = "-1";
	}

	function getAsyncLanguageList(sId, theCallback, selector, filterQuestion) {
		addHourglass();
		$.ajax({
			url: languageListUrl(sId),
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				if(handleLogout(data)) {
					_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.setSurveyLanguages(sId, data);
					retrievedLanguages(sId, selector, data, theCallback, filterQuestion, setGroupList, addNone);
				}
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + ": " + err);
					}
				}
			}
		});
	}

	var data = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.getSurveyLanguages(sId);
	if(data) {
		retrievedLanguages(sId, selector, data, callback, filterQuestion, setGroupList, addNone);
	} else {
		getAsyncLanguageList(sId, callback, selector, filterQuestion);
	}
}

/*
 * Called after languages have been retrieved
 */
function retrievedLanguages(sId, selector, data, theCallback, filterQuestion, setGroupList, addNone) {
	if(selector) {
		setSurveyViewLanguages(data, undefined, selector, addNone);
	} else {
		setSurveyViewLanguages(data, undefined, '#settings_language', false);
		setSurveyViewLanguages(data, undefined, '#export_language', true);
		setSurveyViewLanguages(data, undefined, '#language_name', false);
	}

	if(data[0]) {
		var dateQId = -1;
		if(typeof gTaskStart !== "undefined") {
			dateQId = gTaskStart;
		}
		getQuestionList(sId, data[0], filterQuestion, "-1", theCallback, setGroupList, undefined, dateQId, undefined, undefined, undefined);	// Default language to the first in the list
	} else {
		if(typeof theCallback === "function") {
			theCallback();
		}
	}
}

//Function to get the question list
function getQuestionList(sId, language, qId, groupId, callback, setGroupList, view, dateqId, qName, assignQuestion, scQuestion) {

	function getAsyncQuestionList(sId, language, theCallback, groupId, qId, view, dateqId, qName, assignQuestion, setGroupList, scQuestion) {

		var excludeReadOnly = true;
		if(setGroupList) {
			excludeReadOnly = false;		// Include read only questions in group list
		}
		addHourglass();
		$.ajax({
			url: questionListUrl(sId, language, excludeReadOnly),
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				if(handleLogout(data)) {
					_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.setSurveyQuestions(sId, language, data);
					setSurveyViewQuestions(data, qId, view, dateqId, qName, assignQuestion, scQuestion);

					if (setGroupList && typeof setSurveyViewQuestionGroups === "function") {
						setSurveyViewQuestionGroups(data, groupId);
					}
					if (typeof theCallback === "function") {
						theCallback();
					}
				}
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert("Error: Failed to get list of questions: " + err);
					}
				}
			}
		});
	}

	getAsyncQuestionList(sId, language, callback, groupId, qId, view, dateqId, qName, assignQuestion, setGroupList, scQuestion);
}

//Function to get the meta list
function getMetaList(sId, metaItem) {

	addHourglass();
	$.ajax({
		url: "/surveyKPI/metaList/" + sId,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.setSurveyMeta(sId, data);
				setSurveyViewMeta(data, metaItem);
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + ": " + err);
				}
			}
		}
	});
}

/*
 * Function to get the list of notification alerts
 * These are extracted from the settings for the survey
 */
function getAlertList(sId, alertId) {

	addHourglass();
	$.ajax({
		url: "/surveyKPI/cases/settings/" + sId,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.setSurveyAlerts(sId, data);
				setSurveyAlerts(data, alertId);
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + ": " + err);
				}
			}
		}
	});
}


//Set the language list in the survey view control
function setSurveyViewLanguages(list, language,elem, addNone) {

	var $languageSelect = $(elem),
		i;

	$languageSelect.empty();
	if(addNone) {
		$languageSelect.append('<option value="none">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"] + '</option>');
	}

	for(i = 0; i < list.length; i++) {
		$languageSelect.append('<option value="' + list[i] + '">' + htmlEncode(list[i]) + '</option>');
	}

	if(language) {
		$languageSelect.val(language);
	}
}

// Set the question list in the survey view control
function setSurveyViewQuestions(list, qId, view, dateqId, qName, assignQuestion, scQuestion) {

	var $questionSelect = $('.selected_question'),
		$dateQuestions = $('.date_questions'),
		$scQuestions = $('#sc_question'),
		$questionNameSelect = $('.selected_name_question'),     // this should replace selected_question
		$assignQuestion = $('#assign_question'),
		label;

	$questionSelect.empty();
	$questionSelect.append('<option value="-1">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"] + '</option>');

	$questionNameSelect.empty();
	$questionNameSelect.append('<option value="-1">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"] + '</option>');

	$dateQuestions.empty();
	$dateQuestions.append('<option value="-1">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_i_c"] + '</option>');

	$scQuestions.empty();

	if(list) {
		$.each(list, function(j, item) {
			if(typeof item.q === "undefined") {
				label = "";
			} else {
				label = item.q;
			}

			$questionSelect.append('<option value="' + item.id + '">' + htmlEncode(item.name + " : " + label) + '</option>');
			$questionNameSelect.append('<option value="' + item.name + '">' + htmlEncode(item.name) + '</option>');
			if(item.type === 'timestamp' || item.type === 'dateTime' || item.type == 'date') {
				$dateQuestions.append('<option value="' + item.id + '">' + htmlEncode(item.name + " : " + label) + '</option>');
			}
			if(item.type === 'server_calculate') {
				let name = htmlEncode(item.name);
				$scQuestions.append(`<option value="${item.name}">${name}</option>`);
			}
		});
	}
	if(!qId) {
		qId = "-1";
	}
	$questionSelect.val(qId);

	if(!qName) {
		qName = "-1";
	}
	$questionNameSelect.val(qName);
	$assignQuestion.val(assignQuestion);

	if(!dateqId) {
		dateqId = "-1";
	}
	$dateQuestions.val(dateqId);

	// Server calculate question
	if(scQuestion) {
		$scQuestions.val(scQuestion);
	}

	if(view) {
		setFilterFromView(view);	// Set the filter dialog settings
	}

}

// Set the meta list in the survey view control
function setSurveyViewMeta(list, metaItem) {

	var $metaSelect = $('.selected_meta'),
		item,
		i;

	$metaSelect.empty();

	// Add none
	$metaSelect.append('<option value="-1">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"] + '</option>');

	// Add the user who submitted the survey
	$metaSelect.append('<option value="_user">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_submitter"] + '</option>');

	if(list) {
		for(i = 0; i < list.length; i++) {
			item = list[i];
			$metaSelect.append('<option value="' + item.name + '">' + htmlEncode(item.name) + '</option>');
		}
	}
	if(!metaItem) {
		metaItem = "-1";
	}
	$metaSelect.val(metaItem);

}

/*
 * Populate the alert list
 */
function setSurveyAlerts(settings, alertId) {

	var $elem = $('.alert_list'),
		item,
		i;

	$elem.empty();

	if(settings && settings.alerts) {
		for(i = 0; i < settings.alerts.length; i++) {
			item = settings.alerts[i];
			$elem.append('<option value="' + item.id + '">' + htmlEncode(item.name) + '</option>');
		}
	}
	if(alertId) {
		$elem.val(alertId);
	}


}

/*
 * ------------------------------------------------------------
 * Web service Functions
 */
function languageListUrl (sId) {

	var url = "/surveyKPI/languages/";
	url += sId;
	return url;
}

/*
 * Web service handler for retrieving available "count" questions for graph
 *  @param {string} survey
 */
function questionListUrl (sId, language, exc_read_only) {

	var url = "/surveyKPI/questionList/",
		ro_text;

	if(exc_read_only) {
		ro_text = "true";
	} else {
		ro_text = "false";
	}

	url += sId;
	url += "/" + encodeURIComponent(language);
	url += "?exc_read_only=" + ro_text;
	return url;
}

/**
 * Web service handler for question Meta Data
 * @param {string} survey id
 * @param {string} question id
 */
function questionMetaURL (sId, lang, qId) {

	var url = "/surveyKPI/question/";
	url += sId;
	url += "/" + lang;
	url += "/" + qId;
	url += "/getMeta";
	return url;
}

/*
 * Get a survey details - depends on globals being set
 */
function getSurveyDetails(callback, get_changes, hide_soft_deleted) {

	var tz = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone;
	var url="/surveyKPI/surveys/" + _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey;
	if(get_changes) {
		url += "?get_changes=true";
		url += "&tz=" + encodeURIComponent(tz);
	} else {
		url += "?tz=" + encodeURIComponent(tz);
	}
	if(hide_soft_deleted) {
		url += "&get_soft_delete=false";
	}

	if(!_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey) {
		alert("Error: Can't get survey details, Survey identifier not specified");
	} else {
		addHourglass();
		$.ajax({
			url: url,
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				if(handleLogout(data)) {
					_globals__WEBPACK_IMPORTED_MODULE_0__["default"].model.setSurveyData(data);
					_globals__WEBPACK_IMPORTED_MODULE_0__["default"].model.setSettings();
					setLanguages(data.languages, callback);

					if (typeof callback == "function") {
						callback();
					}
				}
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						if (xhr.status == 404) {
							// The current survey has probably been deleted or the user no longer has access
							_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey = undefined;
							return;
						}
						alert("Error: Failed to get survey: " + err);
					}
				}
			}
		});
	}
}

/*
 * Set the languages for the editor
 */
function setLanguages(languages, languageCallback) {

	var h = [],
		h2 = [],
		idx = -1,
		idx2 = -1,
		$lang_menu = $('.language_menu_list'),
		$lang = $('.language_list'),
		$lang1 = $('#language1'),
		$lang2 = $('#language2'),
		i;

	_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLanguage1 = 0;	// Language indexes used for translations
	_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLanguage2 = 0;
	if(languages.length > 1) {
		_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLanguage2 = 1;
	}

	for (i = 0; i < languages.length; i++) {
		h[++idx] = '<a data-lang="';
		h[++idx] = i;
		h[++idx] = '" class="dropdown-item" href="javascript:void(0)">';
		h[++idx] = htmlEncode(languages[i].name);
		h[++idx] = '</a>';

		h2[++idx2] = '<option value="';
		h2[++idx2] = i;
		h2[++idx2] = '">';
		h2[++idx2] = htmlEncode(languages[i].name);
		h2[++idx2] = '</option>';
	}

	$lang_menu.empty().append(h.join(""));
	$lang.empty().append(h2.join(""));

	$('#langSelected').text(languages[ _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLanguage].name);
	$('.language_menu_list a').click(function() {
		_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLanguage = $(this).data("lang");
		$('#langSelected').text(languages[ _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLanguage].name);
		languageCallback();
	});

	$lang1.val(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLanguage1);
	$lang2.val(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLanguage2)
}

/*
 * Get a survey details - depends on globals being set
 */
function createNewSurvey(name, existing, existing_survey, shared_results, callback) {

	console.log("create new: " + existing + " : " + existing_survey + " : " + shared_results);

	var url="/surveyKPI/surveys/new/" + _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject + "/" + encodeURIComponent(name);
	if(!existing) {
		existing_survey = 0;
	}

	addHourglass();
	$.ajax({
		type: "POST",
		url: url,
		cache: false,
		dataType: 'json',
		data: {
			existing: existing,
			existing_survey: existing_survey,
			existing_form: 0,
			shared_results: shared_results
		},
		success: function(data) {
			removeHourglass();

			if(handleLogout(data)) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].model.setSurveyData(data);
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].model.setSettings();
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey = data.id;

				saveCurrentProject(-1, _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey, undefined);	// Save the current survey id

				setLanguages(data.languages, callback);

				if (typeof callback == "function") {
					callback();
				}
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					bootbox.alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + " " + htmlEncode(xhr.responseText));
				}
			}
		}
	});
}

/*
 * Open a form for editing
 */
function openForm(type) {

	$('.reusing_form').hide();
	$('#base_on_existing').prop('checked', false);
	$('#shared_results').prop('checked', false);
	$('#new_form_name').val("");
	if(type === "new") {
		$('.existing_form').hide();
		$('.new_form').show();
		$('#openSurveyLabel').html(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["tm_g_new"]);
		$('#get_form').html(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_create"]);
		_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gExistingSurvey = false;
	} else {
		$('.existing_form').show();
		$('.new_form').hide();
		$('#openSurveyLabel').html(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["tm_g_open"]);
		$('#get_form').html(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["m_open"]);
		_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gExistingSurvey = true;
	}
	$('#openFormModal').modal('show');

}

/*
 * If this is a smap server return the subdomain
 */
function getServerSubDomainName() {

	var hostname = location.hostname;
	var sd = "";

	if(hostname.indexOf('.smap.com.au') > 0) {
		sd = hostname.substring(0, hostname.indexOf('.smap.com.au'));
	} else if(hostname === 'localhost') {
		sd = 'localhost';
	}

	return sd;
}

/*
 * Return true if this is a business server
 */
function isBusinessServer() {

	var hostname = location.hostname;
	var bs = true;

	if(hostname.indexOf('smap.com.au') > 0) {
		bs = false;
	}
	if(hostname.indexOf('sg.smap.com.au') >= 0 ||
		hostname.indexOf('ubuntu1804.smap.com.au') >= 0 ||
		hostname.indexOf('demo.smap.com.au') >= 0) {
		bs = true;
	}

	return bs;
}

/*
 * Returns the class of server that has custom menus
 */
function getCustomMenuClass() {

	var hostname = location.hostname;
	var classname = undefined;

	if(hostname.indexOf('cuso.smap.com.au') >= 0) {
		classname = '.xxxx1';
	} else if(hostname.indexOf('demo.smap.com.au') >= 0) {
		classname = '.xxxx1';
	} else {
		if(hostname === 'localhost') {
			classname = '.xxxx1';   // testing
		}
	}

	return classname;
}


/*
 * Return true if this is a self registration server
 */
function isSelfRegistrationServer() {
	var hostname = location.hostname;
	var sr = true;

	if(hostname !== 'localhost' &&
		hostname !== 'sg.smap.com.au' &&
		hostname.indexOf('reachnettechnologies.com') < 0 &&
		hostname.indexOf('.icanreach.com') < 0 &&
		hostname.indexOf('encontactone.com') < 0 &&
		hostname !== 'app.kontrolid.com' &&
		hostname !== 'kontrolid.smap.com.au') {
		sr = false;
	}
	return sr;
}

/*
 * Validate start and end dates
 */
function validDates() {
	var $d1 = $('#startDate'),
		$d2 = $('#endDate'),
		d1 = $d1.data("DateTimePicker").date(),
		d2 = $d2.data("DateTimePicker").date()

	if(!d1 || !d1.isValid()) {
		$('#ut_alert').show().text(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["t_i_sd"]);
		setTimeout(function() {
			$('.form-control', '#startDate').focus();
		}, 0);
		return false;
	}

	if(!d2 || !d2.isValid()) {
		$('#ut_alert').show().text(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["t_i_ed"]);
		setTimeout(function() {
			$('.form-control', '#endDate').focus();
		}, 0);
		return false;
	}

	if(d1 > d2) {
		$('#ut_alert').show().text("End date must be greater than or the same as the start date");
		setTimeout(function() {
			$('.form-control', '#startDate').focus();
		}, 0);
		return false;
	}

	$('#ut_alert').hide();
	return true;
}

/*
 * Convert a date into UTC
 */
function getUtcDate($element, start, end) {

	var theDate,
		utcDate;

	if(start) {
		theDate = $element.data("DateTimePicker").date().startOf('day');
	} else if (end) {
		theDate = $element.data("DateTimePicker").date().endOf('day');
	} else {
		theDate = $element.data("DateTimePicker").date();
	}

	utcDate = moment.utc(theDate);

	console.log("date:" + theDate.format("YYYY-MM-DD HH:mm:ss"));
	console.log("UTC:" + utcDate.format("YYYY-MM-DD HH:mm:ss"));

	return utcDate.valueOf();

}

/*
 * Get a description from a change made in the editor
 */
function getChangeDescription(change, version) {

	var h =[],
		idx = -1,
		oldVal,
		newVal,
		forms = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].model.survey.forms,
		str;

	if(change.action === "external option") {
		/*
		 * Options added from a file
		 */
		h[++idx] = 'Choice <span style="color:blue;">';
		h[++idx] = htmlEncode(change.option.externalLabel);
		h[++idx] = '</span>';
		h[++idx] = ' from file: <span style="color:blue;">';
		h[++idx] = htmlEncode(change.fileName);
		h[++idx] = '</span>';

	} else if(change.action === "template_update") {
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_c_template"];
		h[++idx] = ' <span style="color:blue;">';
		h[++idx] = htmlEncode(change.msg);
		h[++idx] = '</span>';

	} else if(change.action === "template_add") {
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_a_template"];
		h[++idx] = ' <span style="color:blue;">';
		h[++idx] = htmlEncode(change.msg);
		h[++idx] = '</span>';

	} else if(change.action === "template_delete") {
		h[++idx] = ' <span style="color:red;">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_d_template"];
		h[++idx] = htmlEncode(change.msg);
		h[++idx] = '</span>';

	} else if(change.action === "settings_update") {
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_c_settings"];
		h[++idx] = ' <span style="color:blue;">';
		h[++idx] = htmlEncode(change.msg);
		h[++idx] = '</span>';

	} else if(change.action === "language_update") {
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_c_languages"];
		h[++idx] = ' <span style="color:blue;">';
		h[++idx] = htmlEncode(change.msg);
		h[++idx] = '</span>';

	} else if(change.action === "add_preload") {
		h[++idx] = ' <span style="color:blue;">';
		h[++idx] = htmlEncode(change.msg);
		h[++idx] = '</span>';

	} else if(change.action === "del_preload") {
		h[++idx] = ' <span style="color:red;">';
		h[++idx] = htmlEncode(change.msg);
		h[++idx] = '</span>';

	} else if(change.action === "update") {

		/*
		 * Updates to questions and options and list names
		 */
		if(change.property.prop === "type") {
			newVal = htmlEncode(translateType(change.property.newVal));
			oldVal = htmlEncode(translateType(change.property.oldVal));
		} else {
			newVal = htmlEncode(change.property.newVal);
			oldVal = htmlEncode(change.property.oldVal);
		}


		if(change.property.prop === "name") {

			// Deprecate the following when the structure of these log objects is made consistent
			if(typeof change.property.type === "optionList" || change.property.type === "unknown") {
				change.type = "choice list ";
			}

			h[++idx] = change.property.type;
			h[++idx] = ' ';
			h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_ren"],
				h[++idx] = ': <span style="color:blue;">';
			h[++idx] = newVal;		// Already encoded
			h[++idx] = '</span>';
			h[++idx] = ' from: <span style="color:red;">';
			h[++idx] = oldVal;	// Already encoded
			h[++idx] = '</span>';
		} else {
			str = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_c_chg_p"];
			if(change.property.propType === "constraint_msg" || change.property.propType === "required_msg" || change.property.propType === "guidance_hint") {
				str = str.replace("%s1", '"' + htmlEncode(change.property.propType) + '"');
			} else {
				str = str.replace("%s1", '"' + htmlEncode(change.property.prop) + '"');
			}
			str = str.replace("%s2", htmlEncode(change.property.name));
			str = str.replace("%s3", '<span style="color:blue;">' + newVal + '</span>');	// Already encoded
			str = str.replace("%s4", '<span style="color:red;">' + oldVal + '</span>');		// Already encoded
			h[++idx] = str;
		}

	} else if(change.action === "add")  {

		/*
		 * New questions or options
		 */
		if(change.type === "question" || change.changeType === "question"){  // deprecate checking of changeType

			str = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_c_add_q"];
			str = str.replace("%s1", '<span style="color:blue;">' + htmlEncode(change.question.name) + "</span>");
			var typeString;
			if(change.question.type === "string") {
				typeString = 'text';
			} else if(change.question.type === "select"){
				typeString = 'select_multiple';
			} else if(change.question.type === "select1"){
				typeString = 'select_one';
			} else {
				typeString = change.question.type;
			}
			str = str.replace("%s2", '<span style="color:red;">' + htmlEncode(typeString) + "</span>");
			h[++idx] = str;

		} else if(change.type === "option" || change.changeType === "option") {	// deprecate checking of changeType
			/*
			 * Options added or deleted from the editor
			 */
			str = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_c_add_o"];
			var valueStr = '<span style="color:blue;">' + change.option.value;
			if(change.option.labels && change.option.labels.length >= 1) {
				valueStr += ' (';
				valueStr += htmlEncode(change.option.labels[0].text);
				valueStr += ')';
			}
			valueStr += '</span>';
			str = str.replace("%s1", valueStr);
			str = str.replace("%s2", '<span style="color:blue;">' + htmlEncode(change.option.optionList) + '</span>');
			h[++idx] = str;
		}

	}  else if(change.action === "move")  {

		/*
		 * New questions or options
		 */
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['c_moved'] + ' ';

		if(change.type === "question" || change.changeType === "question") {  // deprecate checking of changeType){

			h[++idx] = 'question <span style="color:blue;">';
			h[++idx] = htmlEncode(change.question.name);
			if(change.question.sourceSeq >= 0) {
				h[++idx] = '</span> from position <span style="color:red;">';
				h[++idx] = htmlEncode(change.question.sourceSeq);
				h[++idx] = '</span> in form ';
				h[++idx] = htmlEncode(forms[change.question.sourceFormIndex].name);
			} else {
				h[++idx] = '</span> from form ';
				h[++idx] = htmlEncode(forms[change.question.sourceFormIndex].name);
			}
			h[++idx] = '</span> to position <span style="color:red;">';
			h[++idx] = htmlEncode(change.question.seq);
			h[++idx] = '</span>';
			h[++idx] = ' in form ';
			if(change.question.formIndex < forms.length) {	// Allow for a form being deleted
				h[++idx] = htmlEncode(forms[change.question.formIndex].name);
			}


		} else if(change.type === "option") {

			h[++idx] = 'choice <span style="color:blue;">';
			h[++idx] = htmlEncode(change.option.value);
			if(change.option.labels && change.option.labels.length >= 1) {
				h[++idx] = ' (';
				h[++idx] = htmlEncode(change.option.labels[0].text);
				h[++idx] = ')';
			}
			h[++idx] = '</span>';
			h[++idx] = ' from choice list: <span style="color:blue;">';
			h[++idx] = htmlEncode(change.option.sourceOptionList);
			h[++idx] = '</span>';
			h[++idx] = ' to choice list: <span style="color:blue;">';
			h[++idx] = htmlEncode(change.option.optionList);
			h[++idx] = '</span>';
		}

	} else if(change.action === "delete")  {

		if(change.type === "question" || change.changeType === "question"){

			h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_c_del_q"];

			h[++idx] = ' <span style="color:blue;">';
			h[++idx] = htmlEncode(change.question.name);
			h[++idx] = '</span>';

		} else if(change.type === "option") {

			str = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_c_del_o"];
			var valueStr = '<span style="color:blue;">' + htmlEncode(change.option.value);
			if(change.option.labels && change.option.labels.length >= 1) {
				valueStr  += ' (';
				valueStr  += htmlEncode(change.option.labels[0].text);
				valueStr  += ')';
			}
			valueStr  += '</span>';
			str = str.replace("%s1", valueStr);
			str = str.replace("%s2", '<span style="color:blue;">' + htmlEncode(change.option.optionList) + '</span>');
			h[++idx] = str;
		}
	} else if(change.action === "set_required")  {
		if(change.msg.indexOf('not') < 0) {
			h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_c_sr"];
		} else {
			h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_c_snr"];
		}

	} else if(change.action === "upload_template")  {

		if(version > 1) {
			h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_survey_replaced"];
		} else {
			h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_survey_loaded"];
		}

	} else if(change.action === "role")  {

			h[++idx] = change.msg;

	} else {
		h[++idx] = htmlEncode(change.type);
		h[++idx] = ' ';
		h[++idx] = htmlEncode(change.name);
		h[++idx] = ' changed to: <span style="color:blue;">';
		h[++idx] = htmlEncode(change.newVal);
		h[++idx] = '</span>';
		h[++idx] = ' from: <span style="color:red;">';
		h[++idx] = htmlEncode(change.oldVal);
		h[++idx] = '</span>';
	}

	return h.join('');
}

// Translate types for use in change description
function translateType(input) {
	if(input === "string") {
		output = "text";
	} else {
		output = input;
	}
	return output;
}

/*
 * Get the shared locations from the server
 */
function getLocations(callback) {

	var url="/surveyKPI/tasks/locations";

	addHourglass();
	$.ajax({
		url: url,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				if (typeof callback === "function") {
					callback(data);
				}
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					console.log("Error: Failed to get list of locations: " + err);
				}
			}
		}
	});

}

/*
 * update Location group list
 */
function refreshLocationGroups(tags, includeAll, currentGroup) {

	var g = undefined,
		h = [],
		idx = -1,
		i;

	var includeNfc = $('#includeNfc').prop('checked'),
		includeGeo = $('#includeGeo').prop('checked');

	if(tags) {
		for(i = 0; i < tags.length; i++) {
			if(includeAll || includeLocation(includeNfc, includeGeo, tags[i].uid, tags[i].lat, tags[i].lon)) {

				if (g != tags[i].group) {

					g = tags[i].group;
					if (typeof currentGroup === "undefined") {
						currentGroup = g;
					}

					if(includeAll) {
						if (currentGroup === g) {
							$('.location_group_list_sel').text(g);
						}
						h[++idx] = '<a class="dropdown-item" href="#">';
						h[++idx] = g;
						h[++idx] = '</a>';
					} else {
						h[++idx] = '<option';
						if (currentGroup === g) {
							h[++idx] = ' selected';
						}
						h[++idx] = ' value="';
						h[++idx] = g;
						h[++idx] = '">';
						h[++idx] = htmlEncode(g);
						h[++idx] = '</option>';
					}
				}
			}
		}
	}

	$('.location_group_list').empty().html(h.join(""));
	return currentGroup;
}

/*
 * Add the locations (NFC tags or geofence) to any drop down lists that use them
 */
function setLocationList(locns, current, currentGroup) {

	var h = [],
		idx = -1,
		i;

	if(locns && locns.length) {
		h[++idx] = '<option value="-1">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"];
		h[++idx] = '</option>';
		for(i = 0; i < locns.length; i++) {
			if(locns[i].group === currentGroup) {
				h[++idx] = '<option value="';
				h[++idx] = i;
				h[++idx] = '">';
				h[++idx] = htmlEncode(locns[i].name);
				h[++idx] = '</option>';
			}
		}
	}

	$('.location_select').empty().append(h.join(""));
	$('.location_select').val(current);


}

/*
 * Test for whether or not a location should be shown in the resource page
 */
function includeLocation(includeNfc, includeGeo, uid, lat, lon) {
	var include = false;

	if(includeNfc && typeof uid !== 'undefined' && uid !== '') {
		include = true;
	}
	if(!include && includeGeo && lat != 0 && lon != 0) {
		include = true;
	}

	return include;
}

/*
 * Convert a timestamp in UTC to local time and return a date object
 */
function localTimeAsDate(utcTime) {
	var utcDate,
		localTime;

	if(utcTime) {
		if(utcTime.indexOf('+') > 0) {
			utcDate  = moment.utc(utcTime, 'YYYY-MM-DD HH:mm:ss Z').toDate();
		} else {
			utcDate  = moment.utc(utcTime, 'YYYY-MM-DD HH:mm:ss').toDate();
		}
		localTime = moment(utcDate);
	}
	return localTime;
}

/*
 * Convert a timestamp in UTC to local time
 */
function localTime(utcTime) {
	var utcDate,
		localTime;

	if(utcTime) {
		if(utcTime.indexOf('+') > 0) {
			utcDate  = moment.utc(utcTime, 'YYYY-MM-DD HH:mm:ss Z').toDate();
		} else {
			utcDate  = moment.utc(utcTime, 'YYYY-MM-DD HH:mm:ss').toDate();
		}
		localTime = moment(utcDate).format('YYYY-MM-DD HH:mm:ss');
	}
	return localTime;
}


function utcTime(localTime) {

	var utcTime,
		localDate;

	if(localTime) {
		localDate = moment(localTime).toDate();
		utcTime =  moment.utc(localDate).format('YYYY-MM-DD HH:mm:ss');
	}
	return utcTime;

}

function isLate(finish) {

	var late = false,
		current = new Date(),
		finishDate,
		localFinish;

	if(finish) {
		localFinish = localTime(finish);
		finishDate = new Date(localFinish);
		if(current > finishDate) {
			late = true;
		}
	}
	return late;

}

function downloadPdf(language, orientation, include_references, launched_only, sIdent, instanceId, pdfTemplateId) {

	var docURL = "/surveyKPI/pdf/" + sIdent
		+ "?language=" + language
		+ "&instance=" + instanceId
		+ "&pdftemplate=" + pdfTemplateId
		+ "&tz=" + _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone;
	if(orientation === "landscape") {
		docURL += "&landscape=true";
	}
	if(include_references) {
		docURL += "&reference_surveys=true";
	}
	if(launched_only) {
		docURL += "&launched_only=true";
	}

	downloadFile(docURL);
}

function formItemsURL(form, getFeatures, mustHaveGeom, start_key, rec_limit, bBad, filter, dateId, startDate,
	endDate, advanced_filter, tz, inc_ro, geomFormQuestions) {
	var url = "/surveyKPI/items/";
	url += form;
	url += "?getFeatures=" + getFeatures;
	url += "&mustHaveGeom=" + mustHaveGeom;
	url += "&start_key=" + start_key;
	url += "&rec_limit=" + rec_limit;
	url += "&bBad=" + bBad;
	if(typeof filter !== "undefined") {
		url += "&filter=" + encodeURIComponent(filter);
	}
	if(typeof dateId !== "undefined" && dateId) {
		url += "&dateId=" + dateId;
	}
	if(typeof startDate !== "undefined" && startDate) {
		url += "&startDate=" + startDate;
	}
	if(typeof endDate !== "undefined" && endDate) {
		url += "&endDate=" + endDate;
	}
	if(typeof advanced_filter !== "undefined") {
		url += "&advanced_filter=" + encodeURIComponent(advanced_filter);
	}
	if(typeof tz !== "undefined") {
		url += "&tz=" + encodeURIComponent(tz);
	}
	if(typeof inc_ro !== "undefined") {
		url += "&inc_ro=" + inc_ro;
	}
	if(typeof geomFormQuestions !== "undefined") {
		url += "&geomFormQuestions=" + encodeURIComponent(geomFormQuestions);
	}
	return url;
}

function resultsURL(sId, qId, dateId, groupId, groupType, geoTable, fn, lang, timeGroup,
	startDate, endDate, qId_is_calc, filter, advanced_filter, geomFormQuestions,
	selectedGeomQuestion) {

	var url = "/surveyKPI/results/";
	url += sId;
	url += "?qId=" + qId;

	if(dateId != null) {
		url += "&dateId=" + dateId;
	}
	if(groupId != null && groupId != "-1") {
		url += "&groupId=" + groupId;

		if(groupType != null) {
			url += "&group_t=" + groupType;
		}
		if(geoTable != null && geoTable.toLowerCase() != "none") {
			url += "&geoTable=" + geoTable;
		}
	}
	if(fn) {
		url += "&fn=" + fn;
	} else {
		url += "&fn=percent";
	}

	if(lang) {
		url += "&lang=" + lang;
	} else {
		url += "&lang=eng";
	}

	if(typeof timeGroup !== "undefined") {
		url+= "&timeGroup=" + timeGroup;
	}

	if(typeof startDate !== "undefined" && startDate.length > 0) {
		url+= "&startDate=" + startDate;
	}

	if(typeof endDate !== "undefined" && endDate.length > 0) {
		url+= "&endDate=" + endDate;
	}

	if(qId_is_calc) {
		url+= "&qId_is_calc=true";
	}

	if(typeof filter !== "undefined") {
		url+= "&filter=" + encodeURIComponent(filter);
	}

	if(typeof advanced_filter !== "undefined") {
		url+= "&advanced_filter=" + encodeURIComponent(advanced_filter);
	}

	if(selectedGeomQuestion) {
		url+= "&selected_geom_question=" + encodeURIComponent(selectedGeomQuestion);
	}

	return url;
}

function downloadFile(url) {

	url += addCacheBuster(url);
	$("body").append("<iframe src='" + url + "' style='display: none;' ></iframe>");
	// Check for errors allow 5 seconds for an error to be returned
	setTimeout(downloadFileErrorCheck, 5000);
}

// Show an error generated by file download
function downloadFileErrorCheck() {
	var msg = $("iframe").last().contents().find('body').html();
	if(handleLogout(msg)) {
		if (msg && msg.indexOf("Error:") === 0) {
			alert(msg.substring(7));	// Jump over "Error: "
		} else if (msg && msg.length > 0) {
			alert(msg);
		}
	}
}

/*
 * Post data to be converted into a file
 */
function generateFile(url, filename, format, mime, data, sId, groupSurvey, title, project, charts, chartData, settings, tz, form) {

	var fd = new FormData();
	fd.append("sId", sId);
	fd.append("format", format);
	if(groupSurvey) {
		fd.append("groupSurvey", groupSurvey)
	}
	if(form) {
		fd.append("form", form);
	}
	if(data) {
		var blob = new Blob([JSON.stringify(data)], { type: 'text/plain' });
		var file = new File([blob], "foo.txt", {type: "text/plain"});
		fd.append("data", file);
		//fd.append("data", JSON.stringify(data));
	}
	if(title) {
		fd.append("title", title);
	}
	if(project) {
		fd.append("project", project);
	}
	if(charts) {
		fd.append("charts", JSON.stringify(charts));
	}
	if(chartData) {
		fd.append("chartData", JSON.stringify(chartData));
	}
	if(settings) {
		fd.append("settings", JSON.stringify(settings));
	}
	if(tz) {
		fd.append("tz",JSON.stringify(tz));
	}

	var xhr = new XMLHttpRequest();
	url += addCacheBuster(url);
	xhr.open('POST', url, true);
	xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest");
	xhr.responseType = 'blob';

	xhr.onload = function(e) {
		if(handleLogout(xhr.responseURL)) {
			if (this.status == 200) {
				// get binary data as a response
				var blob = new Blob([this.response], {type: mime});
				var downloadUrl = URL.createObjectURL(blob);
				var a = document.createElement("a");
				a.href = downloadUrl;
				a.download = filename;
				document.body.appendChild(a);
				a.click();
				setTimeout(function () {
					document.body.removeChild(a);
					window.URL.revokeObjectURL(url);
				}, 100);
			} else {
				alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + ": " + this.statusText);
			}
		}
	};

	xhr.onerror = function(e) {
		if(handleLogout(this)) {
			alert("Error: Upload Failed");
		}
	}

	xhr.send(fd);

}

/*
 * Get the currently selected rows of datatable data as a json array
 * Also convert the JSON object into an array of Key values pairs. This allows easy converion
 * to a java object on the server
 */
function getTableData(table, columns, format) {

	var rows = table.rows({
		order:  'current',  // 'current', 'applied', 'index',  'original'
		page:   'all',      // 'all',     'current'
		search: 'applied',     // 'none',    'applied', 'removed'
	}).data();

	var data = [],
		cols = [],
		i, j;

	for(i = 0; i < rows.length; i++) {
		cols = [];
		for(j = 0; j < columns.length; j++) {
			if(format === "xlsx" || !columns[j].hide) {
				var k = columns[j].displayName;
				var v = rows[i][columns[j].column_name];

				if (typeof v !== "string") {
					v = JSON.stringify(v);
				}
				cols.push({
					k: k,
					v: v
				})
			}
		}
		data.push(cols);
	}

	return data;


}

/*
 * Get server settings
 */
function getMapboxDefault(callback, param) {

	if(!_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gMapboxDefault) {
		addHourglass();
		$.ajax({
			url: '/surveyKPI/server/mapbox',
			cache: false,
			success: function(data) {
				removeHourglass();
				if(handleLogout(data)) {
					_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gMapboxDefault = data;
					if (typeof callback === "function") {
						callback(param);
					}
				}
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["error"] + ": " + err);
					}
				}
			}
		});
	} else {
		if(typeof callback === "function") {
			callback(param);
		}
	}
}


/*
 * Get google map api key
 */
function getGoogleMapApi(callback, map) {

	console.log("getGoogleMapApi");

	if(!window.smapLoadedGMaps && !window.smapGMapsLoading) {
		console.log("about to call server");

		window.smapGMapsLoading = true;

		window.smapGMapsToLoad = [];
		window.smapGMapsToLoad.push({
			fn: callback,
			locn: map
		});

		addHourglass();
		$.ajax({
			url: '/surveyKPI/server/googlemaps',
			cache: false,
			success: function(data) {
				removeHourglass();
				if(handleLogout(data)) {
					console.log("Retrieved map keys from server");

					var gElement = document.createElement('script');
					var key = "";
					if (data) {
						key = "?key=" + data;
					}
					//gElement.src = "//maps.google.com/maps/api/js?v=3.6&amp";
					gElement.src = "https://maps.googleapis.com/maps/api/js" + key;
					if (typeof callback === "function") {
						gElement.onload = onLoad;
					}
					document.getElementsByTagName('head')[0].appendChild(gElement);

					function onLoad() {

						var i;

						window.smapGMapsLoading = false;
						window.smapLoadedGMaps = true;

						console.log("Google map loaded");

						for (i = 0; i < window.smapGMapsToLoad.length; i++) {
							console.log("map callback");
							window.smapGMapsToLoad[i].fn(window.smapGMapsToLoad[i].locn);
						}
						delete window.smapGMapsToLoad;
					}
				}

			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["error"] + " " + err);
					}
				}
			}
		});

	} else if(window.smapLoadedGMaps) {
		console.log("Already loaded calling map callback");
		callback(map);
	} else {
		console.log("Adding callback to queue");
		window.smapGMapsToLoad.push({
			fn: callback,
			locn: map
		});
	}
}

/*
 * Add google layers to a map
 */
function addGoogleMapLayers(map) {
	try {
		map.addLayer(new OpenLayers.Layer.Google("Google Satellite",{type: google.maps.MapTypeId.SATELLITE, 'sphericalMercator': true, numZoomLevels: 22}));
		map.addLayer(new OpenLayers.Layer.Google("Google Maps",{type: google.maps.MapTypeId.ROADMAP, 'sphericalMercator': true, numZoomLevels: 22}));
		map.addLayer(new OpenLayers.Layer.Google("Google Hybrid",{type: google.maps.MapTypeId.HYBRID, 'sphericalMercator': true, numZoomLevels: 22}));
	} catch (err) {
		// Fail silently, the user may not want google maps - this is probably caused by a missing maps api key
	}
}

/*
 * Get a list of custom reports
 */
function getReports(callback1, callback2, type) {

	var url="/surveyKPI/custom_reports";

	if(type) {
		url += "?type=" + type;
	}

	addHourglass();
	$.ajax({
		url: url,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				var cb1 = callback1,
					cb2 = callback2,
					t = type;
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gReports = data;
				if (typeof cb1 === "function") {
					cb1(data, cb1, cb2, t);
				}
				if (typeof cb2 === "function") {
					cb2(data, cb1, cb2, t);
				}
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					console.log("Error: Failed to get list of reports: " + err);
				}
			}
		}
	});

}

/*
 * Allow the user to pick a report
 */
function showReportList(data) {
	var h = [],
		idx = -1,
		i;

	removeHourglass();

	if(data.length === 0) {

		// Enable / disable elements specifically for managed forms
		$('.selectmanaged').show();
		$('.no_oversight').show();
	} else {
		$('.no_oversight').hide();
		$('.selectmanaged').show();

		h[++idx] = '<option value="0">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"];
		h[++idx] = '</option>';
		for(i = 0; i < data.length; i++) {
			h[++idx] = '<option value="';
			h[++idx] = data[i].id;
			h[++idx] = '">';
			h[++idx] = htmlEncode(data[i].name);
			h[++idx] = '</option>';
		}
		$('.customReportList').empty().html(h.join(''));
	}
}

/*
 * Show the Custom Reports in a table
 */
function refreshCustomReportView(data, callback1, callback2, type) {

	var $selector = $('#cr_list'),
		i,
		h = [],
		idx = -1;

	$('.panel_msg').show();
	$('#addReportPopup').modal("hide");

	data = data || [];
	_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gReports = data;

	h[++idx] = '<table class="table">';
	h[++idx] = '<thead>';
	h[++idx] = '<tr>';
	h[++idx] = '<th>' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_name"], + '</th>';
	h[++idx] = '<th>' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_type"] + '</th>';
	h[++idx] = '</tr>';
	h[++idx] = '</thead>';
	h[++idx] = '<tbody class="table-striped">';

	for(i = 0; i < data.length; i++) {

		h[++idx] = '<tr>';

		// name
		h[++idx] = '<td>';
		h[++idx] = htmlEncode(data[i].name);
		h[++idx] = '</td>';

		// type
		h[++idx] = '<td>';
		h[++idx] = htmlEncode(data[i].type);
		h[++idx] = '</td>';

		// actions
		h[++idx] = '<td>';

		h[++idx] = '<button type="button" data-idx="';
		h[++idx] = i;
		h[++idx] = '" class="btn btn-default btn-sm rm_cr">';
		h[++idx] = '<i class="fa fa-trash-o"></i></button>';

		h[++idx] = '<button type="button" data-idx="';
		h[++idx] = i;
		h[++idx] = '" class="btn btn-default btn-sm download_cr">';
		h[++idx] = '<i class="fa fa-download"></i></button>';

		h[++idx] = '</td>';
		// end actions

		h[++idx] = '</tr>';
	}

	h[++idx] = '</tbody>';
	h[++idx] = '</table>';

	$selector.empty().append(h.join(''));

	$(".rm_cr", $selector).click(function(){
		var idx = $(this).data("idx");
		if(confirm(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_confirm_del"] + " " + htmlEncode(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gReports[idx].name))) {
			deleteCustomReport(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gReports[idx].id, type);
		}
	});

	$(".download_cr", $selector).click(function(){
		var idx = $(this).data("idx");
		downloadFile("/surveyKPI/custom_reports/xls/" + _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gReports[idx].id +
			"?filetype=xls&filename=" + cleanFileName(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gReports[idx].name));
	});


}

function deleteCustomReport(id, type) {

	var url = "/surveyKPI/custom_reports/" + id;
	if(type) {
		url += "?type=" + type;
	}

	addHourglass();
	$.ajax({
		type: "DELETE",
		url: url,
		success: function(data, status) {
			removeHourglass();
			if(handleLogout(data)) {
				var t = type;
				console.log("delete: " + t + " : " + type);
				getReports(refreshCustomReportView, showReportList, t);
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_del"] + " " + xhr.responseText);	// alerts htmlencode text
				}
			}
		}
	});
}

/*
 * Get the list of available roles from the server
 */
function getRoles(callback) {
	addHourglass();
	$.ajax({
		url: "/surveyKPI/role/roles",
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gRoleList = data;
				if (typeof callback === "function") {
					callback();
				}
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_get_r"] + " " + err);
				}
			}
		}
	});
}

/*
 * Get the list of available case management settings from the server
 */
function getCms(callback) {
	addHourglass();
	$.ajax({
		url: "/surveyKPI/cases/settings/" + _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentSurvey,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCmSettings = data;
				if (typeof callback === "function") {
					callback();
				}
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_get_r"] + " " + err);
				}
			}
		}
	});
}

/*
 * Clean the filename so that it can be passed in a URL
 */
function cleanFileName(filename) {

	var n;

	n = filename.replace(/\//g, '_');	// remove slashes from the filename
	n = n.replace(/[#?&]/g, '_');		// Remove other characters that are not wanted
	n = n.replace("'", "", 'g');		// Remove apostrophes

	return n;
}

/*
 * Add a list of forms to pick from during export
 */
function addFormPickList(sMeta, checked_forms) {

	var h = [],
		idx = -1,
		i;

	// Start with the top level form
	for(i = 0; i < sMeta.forms.length; i++) {
		if(sMeta.forms[i].p_id == 0) {
			$(".osmforms").html(addFormToList(sMeta.forms[i], sMeta, 0, true, false, checked_forms, false));
			$(".selectforms").html(addFormToList(sMeta.forms[i], sMeta, 0, false, false, checked_forms, false));
			$(".shapeforms,.taforms").html(addFormToList(sMeta.forms[i], sMeta, 0, true, true, checked_forms, false));
			$(".shapeforms_bs4").html(addFormToList(sMeta.forms[i], sMeta, 0, true, true, checked_forms, true));
		}
	}

	$("button",".selectforms").click(function() {
		var $this = $(this),
			$check = $this.parent().find("input"),
			val,
			val_array = [];

		val = $check.val();
		val_array= val.split(":");
		if(val_array.length > 1) {
			if(val_array[1] === "true") {
				$check.val(val_array[0] + ":false");
				$this.text("Pivot");
			} else {
				$check.val(val_array[0] + ":true");
				$this.text("Flat");
			}
			$this.toggleClass('exportflat');
			$this.toggleClass('exportpivot');
		}

		return false;
	});
}

/*
 * Add a list of date questions to pick from
 */
function addDatePickList(sMeta, currentDate) {

	var h = [],
		idx = -1,
		i,
		value,
		key;

	if(sMeta && sMeta.dates) {
		for(i = 0; i < sMeta.dates.length; i++) {

			key = sMeta.dates[i].name;

			h[++idx] = '<option value="';
			h[++idx] = sMeta.dates[i].id;
			h[++idx] = '">';
			if(key === "Upload Time" || key === "_start" || key === "_end") {
				key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set[key];
			} else if(key === "Scheduled Start") {
				key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_scheduled"]
			}
			h[++idx] = htmlEncode(key);
			h[++idx] = '</option>';

		}

		$(".date_question").empty().html((h.join('')));

		if(typeof currentDate !== "undefined" && currentDate != 0) {
			value = currentDate;
		} else {
			value = $("#settings_date_question").val();
		}
	}
}

/*
 * Add a list of geometry questions to pick from
 */
function addGeomPickList(sMeta) {

	var h = [],
		k = [],
		idx = -1,
		i,
		value,
		theForm;

	if(sMeta && sMeta.forms) {
		for(i = 0; i < sMeta.forms.length; i++) {

			theForm = sMeta.forms[i];

			k[++idx] = h[++idx] = '<div class="exportcontrol showshape showosm" style="display: block;">';
			k[++idx] = h[++idx] = '<label>' + htmlEncode(theForm.form) + '</label>';
			h[++idx] = '<select class="geomSelect" id="geomForm_' + theForm.f_id;            // export only
			k[++idx] = '<select class="geomSelect" id="geomSettingsForm_' + theForm.f_id;    // Settings only
			k[++idx] = h[++idx] = '" data-form="' + theForm.f_id + '">';
			if(theForm.geomQuestions) {
				for(j = 0; j < theForm.geomQuestions.length; j++) {
					k[++idx] = h[++idx] = '<option value="';
					k[++idx] = h[++idx] = theForm.geomQuestions[j];
					k[++idx] = h[++idx] = '">';
					k[++idx] = h[++idx] = htmlEncode(theForm.geomQuestions[j]);
					k[++idx] = h[++idx] = '</option>';
				}
			}
			k[++idx] = h[++idx] = '</select>';
			k[++idx] = h[++idx] = '</div>';

		}

		$(".geomselect_export").empty().html((h.join('')));
		$(".geomselect_settings").empty().html((k.join('')));

		shapeFormsChanged();

	}
}

function shapeFormsChanged() {
	var formId = getSelectedForm('.shapeforms', true);
	if(formId) {
		$('.geomSelect', '.geomselect_export').prop('disabled', true);
		$('#geomForm_' + formId, '.geomselect_export').prop('disabled', false);
	}
}

function getSelectedForm($forms, ignoreError) {
	var forms = $(':radio:checked', $forms).map(function() {
		return this.value;
	}).get();
	if(forms.length === 0) {
		if(!ignoreError) {
			alert(window.localise.set["msg_one_f2"]);
		}
		return 0;
	}
	return forms[0];
}

function addFormToList(form, sMeta, offset, osm, set_radio, checked_forms, bs4) {

	var h = [],
		idx = -1,
		i,
		type,
		checked;

	if (set_radio) {
		type = "radio";
	} else {
		type = "checkbox";
	}

	// Set checked value based on previous selections
	if(set_radio && offset == 0) {
		checked = 'checked="checked"';
	} else {
		if (offset == 0 && (!checked_forms || checked_forms.length == 0)) {
			checked = 'checked="checked"';
		} else {
			checked = '';
		}
	}
	if(checked_forms && checked_forms.length > 0) {
		for(i = 0; i < checked_forms.length; i++) {
			if(form.f_id == checked_forms[i]) {
				checked = 'checked="checked"';
				break;
			}
		}
	}

	h[++idx] = '<div class="' + type + '"';
	h[++idx] = '<span style="padding-left:';
	h[++idx]= offset + 'px;">';
	h[++idx] = '<label>';
	h[++idx] = '<input class="osmform" type="' + type + '" ' + checked + ' name="osmform" value="';
	h[++idx] = form.f_id;
	if(!osm) {
		h[++idx] = ':false"/>';
	} else {
		h[++idx] = '">';
	}
	if(bs4) {
		h[++idx] = '<span class="ml-2">';
	}
	h[++idx] = htmlEncode(form.form);
	if(bs4) {
		h[++idx] = '</span>';
	}
	h[++idx] = '</label>';
	if(form.p_id != 0 && !osm) {
		h[++idx] = ' <button class="exportpivot">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_pivot"] + '</button>';
	}
	h[++idx]= '</div>';

	// Add the children (recursively)
	for(i = 0; i < sMeta.forms.length; i++) {
		if(sMeta.forms[i].p_id != 0  && sMeta.forms[i].p_id == form.f_id) {
			h[++idx] = addFormToList(sMeta.forms[i], sMeta, offset + 20, osm, set_radio, checked_forms, bs4);
		}
	}

	return h.join('');
}

function getViewLanguages(view) {

	if(view.sId != -1) {
		var url = languageListUrl(view.sId);
		$.getJSON(url, function(data) {
			_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.setSurveyLanguages(view.sId, data);
			setSurveyViewLanguages(data, view.lang, '#settings_language', false);
			setSurveyViewLanguages(data, view.lang, '#export_language', true);
		});
	}

}

function validateEmails(emails) {
	var valid = true,
		i;
	if(emails && emails.trim().length > 0) {
		var emailArray = emails.split(",");
		for (i = 0; i < emailArray.length; i++) {
			var validEmail = /[A-Z0-9._%+-]+@[A-Z0-9.-]+.[A-Z]{2,4}/igm;
			if (!validEmail.test(emailArray[i])) {
				valid = false;
				break;
			}
		}
	}
	return valid;
}

/*
 * Get the roles for a survey
 */
function getSurveyRoles(sId, selectedRoles, setall, onlypriv) {

	if (!gTasks.cache.surveyRoles[sId]) {
		addHourglass();
		var url = "/surveyKPI/role/survey/" + sId + "?enabled=true";
		if(onlypriv) {
			url += "&onlypriv=true";
		}
		$.ajax({
			url: url,
			dataType: 'json',
			cache: false,
			success: function (data) {
				removeHourglass();
				if(handleLogout(data)) {
					var savedSelectedRoles = selectedRoles;
					gTasks.cache.surveyRoles[sId] = data;
					showRoles(gTasks.cache.surveyRoles[sId], savedSelectedRoles);
				}
			},
			error: function (xhr, textStatus, err) {

				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						console.log("Error: Failed to get roles for a survey: " + err);
					}
				}
			}
		});
	} else {
		showRoles(gTasks.cache.surveyRoles[sId], selectedRoles, setall);
	}
}

/*
 * Show the roles
 */
function showRoles(data, selectedRoles, setall) {

	var h = [],
		idx = -1,
		i,
		selId,
		selList = [];

	$('.role_select_roles').empty();
	if (data.length > 0) {
		for (i = 0; i < data.length; i++) {
			h[++idx] = '<div class="col-sm-10 custom-control custom-checkbox ml-2 mb-1">'
			h[++idx] = '<input type="checkbox"';
			selId = 'rolesel_' + i;
			h[++idx] = ' id="' + selId + '"';
			if(setall || roleSelected(data[i].id, selectedRoles)) {
				selList.push(selId);
			}
			h[++idx] = ' class="custom-control-input" value="';
			h[++idx] = data[i].id;
			h[++idx] = '">';

			h[++idx] = '<label class="custom-control-label"';
			h[++idx] = ' for="rolesel_' + i + '">';
			h[++idx] = 	htmlEncode(data[i].name);
			h[++idx] = '</label>';
			h[++idx] = '</div>';
		}
		$('.role_select').show();
		$('.role_select_roles').empty().append(h.join(''));
		for(i = 0; i < selList.length; i++) {
			selId = selList[i];
			$('#' + selId).prop('checked', true);
		}
	}
}

function roleSelected(roleId, selectedRoles) {
	var sel = false;
	if(selectedRoles) {
		for(var i = 0; i < selectedRoles.length; i++) {
			if(selectedRoles[i].id == roleId) {
				sel = true;
				break;
			}
		}
	}
	return sel;
}

 /*
  * Get all the surveys that a user can access
  */
function getAccessibleSurveys($elem, includeNone, includeBlocked, groupsOnly, includeSelf) {

	var url="/surveyKPI/surveys";
	var hasParam = false;
	if(includeBlocked) {
		url += hasParam ? '&' : '?';
		url += 'blocked=true';
		hasParam = true;
	}
	if(groupsOnly) {
		url += hasParam ? '&' : '?';
		url += 'groups=true';
		hasParam = true;
	}

	addHourglass();
	$.ajax({
		url: url,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				var h = [],
					idx = -1,
					i;

				if (includeNone) {
					h[++idx] = '<option value="">';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"]
					h[++idx] = '</option>';
				}

				if (includeSelf) {
					h[++idx] = '<option value="self">';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_self"]
					h[++idx] = '</option>';
				}
				for (i = 0; i < data.length; i++) {
					h[++idx] = '<option value="';
					h[++idx] = htmlEncode(data[i].ident);
					h[++idx] = '">';
					h[++idx] = htmlEncode(data[i].projectName);
					h[++idx] = ' : ';
					h[++idx] = htmlEncode(data[i].displayName);
					h[++idx] = '</option>';
				}
				$elem.empty().append(h.join(''));
			}

		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					console.log("Error: Failed to get list of surveys: " + err);
				}
			}
		}
	});
}

/*
 * Get all the csv files that a user can access
 */
function getAccessibleCsvFiles($elem, includeNone) {

	var url="/surveyKPI/shared/csv/files";

	addHourglass();
	$.ajax({
		url: url,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCsvFiles = data;
				var h = [],
					idx = -1,
					i;

				if (includeNone) {
					h[++idx] = '<option value="">';
					h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"]
					h[++idx] = '</option>';
				}
				for (i = 0; i < data.length; i++) {
					h[++idx] = '<option value="';
					h[++idx] = i;
					h[++idx] = '">';
					h[++idx] = htmlEncode(data[i].filename);
					h[++idx] = '</option>';
				}
				$elem.empty().append(h.join(''));
			}

		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					console.log("Error: Failed to get list of csv files: " + err);
				}
			}
		}
	});
}

 /*
  * Get the questions in a survey
  */
function getQuestionsInSurvey($elem, $elem_multiple, sIdent, includeNone, textOnly, callback, includeHrk) {

	function populateElement($elem, $elem_multiple, data) {
		var h = [],
			hm = [],
			idx = -1,
			idx_m = -1,
			i,
			setValueFn = callback;

		if (includeNone) {
			h[++idx] = '<option value="0">';
			h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"];
			h[++idx] = '</option>';
		}
		if (includeHrk) {
			hm[++idx_m] = h[++idx] = '<option value="_hrk">';
			hm[++idx_m] = h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["ed_hrk"];
			hm[++idx_m] = h[++idx] = '</option>';

			hm[++idx_m] = h[++idx] = '<option value="_assigned">';
			hm[++idx_m] = h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["t_assigned"];
			hm[++idx_m] = h[++idx] = '</option>';
		}
		for (i = 0; i < data.length; i++) {
			if(!textOnly || isTextStorageType(data[i].type)) {
				hm[++idx_m] = h[++idx] = '<option value="';
				hm[++idx_m] = h[++idx] = data[i].name;
				hm[++idx_m] = h[++idx] = '">';
				hm[++idx_m] = h[++idx] = htmlEncode(data[i].name);
				hm[++idx_m] = h[++idx] = '</option>';
			}
		}
		if($elem) {
			$elem.empty().append(h.join(''));
		}
		if($elem_multiple) {
			$elem_multiple.empty().append(hm.join(''));
			$elem_multiple.multiselect('deselectAll', false);
			$elem_multiple.multiselect('rebuild');
		}

		if(typeof setValueFn === "function") {
			setValueFn();
		}
	}

	if(sIdent === 'self') {
		populateElement($elem, $elem_multiple, _globals__WEBPACK_IMPORTED_MODULE_0__["default"].model.survey.forms[_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gFormIndex].questions);
	} else if(gCache[sIdent]) {
		populateElement($elem, $elem_multiple, gCache[sIdent]);
	} else {
		if (sIdent && sIdent !== "0" && sIdent !== '' && sIdent !== '_none') {
			addHourglass();
			$.ajax({
				url: "/surveyKPI/questionListIdent/" + sIdent + "/none?inc_meta=true",
				dataType: 'json',
				cache: false,
				success: function (data) {
					removeHourglass();
					if(handleLogout(data)) {
						var theIdent = sIdent;
						var $theElem = $elem;
						var $theElemMultiple = $elem_multiple;

						gCache[theIdent] = data;
						populateElement($theElem, $theElemMultiple, data);
					}
				},
				error: function (xhr, textStatus, err) {
					removeHourglass();
					if(handleLogout(xhr.responseText)) {
						if (xhr.readyState == 0 || xhr.status == 0) {
							return;  // Not an error
						} else {
							alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_get_q"] + ": " + err);
						}
					}
				}
			});
		} else {
			if (includeNone) {
				if($elem) {
					$elem.empty().append('option value="0">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"] + '</option>');
				}
				if($elem_multiple) {
					$elem_multiple.empty().append('option value="0">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"] + '</option>');
					$elem_multiple.multiselect('rebuild');
				}
			}
		}
	}

}

function getQuestionsInCsvFile($elem, $elem_multiple, index, includeNone) {
	var h = [],
		hm = [],
		idx = -1,
		idx_m = -1,
		i;

	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCsvFiles[index]) {
		var data = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCsvFiles[index].headers;

		if (includeNone) {		// Only include select none for single selects
			h[++idx] = '<option value="">';
			h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"];
			h[++idx] = '</option>';
		}
		for (i = 0; i < data.length; i++) {
			hm[++idx_m] = h[++idx] = '<option value="';
			hm[++idx_m] = h[++idx] = data[i].fName;
			hm[++idx_m] = h[++idx] = '">';
			hm[++idx_m] = h[++idx] = htmlEncode(data[i].fName);
			hm[++idx_m] = h[++idx] = '</option>';
		}
		if ($elem) {
			$elem.empty().append(h.join(''));
		}
		if ($elem_multiple) {
			$elem_multiple.empty().append(hm.join(''));
			$elem_multiple.multiselect('deselectAll', false)
			$elem_multiple.multiselect('rebuild');
		}
	}
}

/*
 * Get the questions in a survey
 */
function getGroupQuestionsInSurvey($elem, sIdent) {

	function populateElement($elem, data) {
		var h = [],
			idx = -1,
			i;

		h[++idx] = '<option data-type="" value="">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"];
		h[++idx] = '</option>';

		for (i = 0; i < data.length; i++) {
			h[++idx] = '<option data-type="';
			h[++idx] = data[i].type;
			h[++idx] = '" value="';
			h[++idx] = data[i].name;
			h[++idx] = '">';
			h[++idx] = htmlEncode(data[i].name);
			h[++idx] = '</option>';
		}
		$elem.empty().append(h.join(''));
	}

	if(gCacheGroup[sIdent]) {
		populateElement($elem, gCacheGroup[sIdent]);
	} else {
		if (sIdent !== "0") {
			addHourglass();
			$.ajax({
				url: "/surveyKPI/questionListIdent/" + sIdent + "/none/group",
				dataType: 'json',
				cache: false,
				success: function (data) {
					removeHourglass();
					if(handleLogout(data)) {
						var theIdent = sIdent;
						var $theElem = $elem;

						gCacheGroup[theIdent] = data;
						populateElement($theElem, data);
					}

				},
				error: function (xhr, textStatus, err) {
					removeHourglass();
					if(handleLogout(xhr.responseText)) {
						if (xhr.readyState == 0 || xhr.status == 0) {
							return;  // Not an error
						} else {
							alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_get_q"] + ": " + err);
						}
					}
				}
			});
		} else {
			if (includeNone) {
				$elem.empty().append('option value="0">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"] + '</option>');
			}
		}
	}

}

/*
 * Get the questions suitable for use as a status in a survey group using the survey id as the key
 */
function getGroupStatusQuestions($elem, sId) {

	function populateElement($elem, data) {
		var h = [],
			idx = -1,
			i;

		for (i = 0; i < data.length; i++) {
			h[++idx] = '<option value="';
			h[++idx] = data[i].column_name;
			h[++idx] = '">';
			h[++idx] = htmlEncode(data[i].name);
			h[++idx] = '</option>';
		}
		$elem.empty().append(h.join(''));
	}

	if(gCacheStatusQuestions[sId]) {
		populateElement($elem, gCacheStatusQuestions[sId]);
	} else {
		addHourglass();
		$.ajax({
			url: "/surveyKPI/questionList/" + sId + "/none/group?status=true",
			dataType: 'json',
			cache: false,
			success: function (data) {
				removeHourglass();
				if(handleLogout(data)) {
					var theId = sId;
					var $theElem = $elem;

					gCacheStatusQuestions[theId] = data;
					populateElement($theElem, data);
				}

			},
			error: function (xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_get_q"] + ": " + err);
					}
				}
			}
		});
	}
}

/*
 * Get the questions suitable for use as a status in a survey group using the survey id as the key
 */
function getGroupKeys($key, $key_policy, sId) {

	if(gCacheKeys[sId]) {
		$key.val(gCacheStatusQuestions[sId].key);
		$key_policy.val(gCacheStatusQuestions[sId].key_policy)
	} else {
		addHourglass();
		$.ajax({
			url: "/surveyKPI/cases/keys/" + sId,
			dataType: 'json',
			cache: false,
			success: function (data) {
				removeHourglass();
				if(handleLogout(data)) {
					var theId = sId;

					gCacheStatusQuestions[theId] = data;
					$key.val(gCacheStatusQuestions[sId].key);
					$key_policy.val(gCacheStatusQuestions[sId].key_policy);
				}

			},
			error: function (xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + ": " + err);
					}
				}
			}
		});
	}
}

function tokenizeAppearance(input) {
	var chunks = [];
	var tokens = [];
	var chunkTokens = [];
	var i;
	var j;
	var chunk;

	// only search/lookup_choices needs special treatment
	var idx1 = input.indexOf('search');
	if(idx1 < 0) {
		idx1 = input.indexOf('lookup_choices');
	}
	if(idx1 >= 0) {
		chunks.push({
			val:input.substring(0, idx1),
			type: "text"
		});
		if(idx1 < input.length) {
			var idx2 = input.lastIndexOf(')');
			if(idx2 >= 0) {
				chunks.push({
					val: input.substring(idx1, idx2 + 1),
					type: "fn"
				});
				if(idx2 < input.length) {
					chunks.push({
						val: input.substring(idx2 + 1),
						type: "text"
					});
				}
			}
		}
	} else {
		chunks.push({
			val: input,
			type: "text"
		});
	}
	for(i = 0; i < chunks.length; i++) {
		chunk = chunks[i].val.trim();
		if(chunk.length > 0) {
			if(chunks[i].type === "text") {
				chunkTokens = chunk.split(/(\s+)/);
			} else {
				chunkTokens = [];
				chunkTokens.push(chunk);
			}
			for(j = 0; j < chunkTokens.length; j++) {
				if(chunkTokens[j].trim().length > 0) {
					tokens.push(chunkTokens[j].trim());
				}
			}
		}
	}
	return tokens;
}

function setOrganisationTheme() {

	if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSetAsTheme && _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gOrgId > 0) {

		var mainLogoSrc = getFromLocalStorage("main_logo");
		var logo = "/media/organisation/" + _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gOrgId + '/settings/mainLogo';
		if(mainLogoSrc !== logo) {
			setInLocalStorage('main_logo', logo);
			$('.main_logo').attr("src", "/media/organisation/" + _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gOrgId + '/settings/mainLogo');
		}

		// navbar color
		var navbarColor = getFromLocalStorage("navbar_color");
		if(navbarColor !== _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gNavbarColor) {
			setInLocalStorage('navbar_color', _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gNavbarColor);
		}
		// navbar color
		var navbarTextColor = getFromLocalStorage("navbar_text_color");
		if(navbarTextColor !== _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gNavbarTextColor) {
			setInLocalStorage('navbar_text_color', _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gNavbarTextColor);
		}
	} else {
		// remove styles
		var navbarColorElement = document. getElementById("navbar_color");
		if(navbarColorElement) {
			navbarColorElement.parentNode.removeChild(navbarColorElement);
		}
		setInLocalStorage('navbar_color', undefined);
		setInLocalStorage('navbar_text_color', undefined);
		setInLocalStorage('main_logo', undefined);

		// Set the default logo
		if(typeof setCustomMainLogo === "function") {
			setCustomMainLogo();
		}
	}
}

/*
 * Surround get / set from local storage in case user has disabled local sorage reading in browser settings
 */
function getFromLocalStorage(key) {
	var value;
	try {
		value = localStorage.getItem(key);
	} catch (e) {

	}
	return value;
}

function setInLocalStorage(key, value) {
	try {
		localStorage.setItem(key, value);
	} catch(e) {

	}
}

function populateTaskGroupList() {
	if (typeof _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject !== "undefined" && _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject != -1) {
		addHourglass();
		$.ajax({
			url: "/surveyKPI/tasks/taskgroups/" + _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject,
			cache: false,
			dataType: 'json',
			success: function (taskgroups) {
				removeHourglass();
				if(handleLogout(taskgroups)) {
					var h = [],
						idx = -1,
						i,
						grp,
						firstTg,
						hasCurrentTg = false;

					window.gTaskGroups = taskgroups;   // Keep the task group list

					if (typeof taskgroups != "undefined" && taskgroups.length > 0) {

						for (i = 0; i < taskgroups.length; i++) {
							grp = taskgroups[i];
							h[++idx] = '<option value="';
							h[++idx] = i;
							h[++idx] = '">';
							h[++idx] = htmlEncode(grp.name);
							h[++idx] = '</option>';
						}
					}
					$('.task_group_select').html(h.join(''));
				}
			},
			error: function (xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert("Failed to get task group data");
					}
				}
			}
		});
	}
}

/*
 * Show a loaded file as an image
 * From https://codepen.io/adamrifai/pen/YXdEwz
 */
function displayAsImage(file, img) {

	var imgURL = URL.createObjectURL(file);
	img.onload = function() {
		URL.revokeObjectURL(imgURL);
	};

	img.src = imgURL;
}

/*
 * If debug=yes is passed as a parameter then enable debuging statement
 */
function enableDebugging() {

	if(location.search.indexOf("debug=yes") >= 0) {
		$(document).on('click', function(e) { console.log(e.target) });
	}

}

/*
 * ----------------------------------------------------
 * Common task functions shared between task managmeent page and console
 */
function setupAssignType(user_id, role_id, emails, email_question) {
	$('.assign_group').hide();
	$('.assign_type').removeClass('active');
	if(user_id != 0) {
		$('.user_type_checkbox').addClass('active');
		$('.assign_user').show();
	} else  if(role_id != 0) {
		$('.role_type_checkbox').addClass('active');
		$('.assign_role').show();
	} else if((typeof emails !== "undefined" && emails.trim().length > 0)
			|| (typeof email_question !== "undefined" && email_question.trim().length > 0)) {
		$('.email_type_checkbox').addClass('active');
		$('.assign_email').show();
	} else {        // Default to user
		$('.user_type_checkbox').addClass('active');
		$('.assign_user').show();
	}
}

// Convert a location name into a location index
function getLocationIndex(name, tags) {
	var idx = -1,
		i;

	if(tags) {
		for(i = 0; i < tags.length; i++) {
			if(tags[i].name == name) {
				idx = i;
				break;
			}

		}
	}
	return idx;

}

function saveTask(isConsole, currentTaskFeature, saveType, updateId, callback, tg_id) {
	var url = "/surveyKPI/api/tasks?preserveInitialData=true&tz=UTC",	// Assume we use UTC times in interface
		taskFeature = {
			properties: {}
		},
		fromDate,
		toDate,
		MIN_SHOW_RANGE = 10;

	taskFeature = $.extend(true, {}, currentTaskFeature);
	taskFeature.properties.assignee_ident = undefined;
	taskFeature.properties.assignee_name = undefined;

	/*
	 * Set the properties of the taskFeature from the dialog
	 */
	taskFeature.properties.p_id = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gCurrentProject;
	taskFeature.properties.tg_id = tg_id;

	if (!taskFeature.properties.id || taskFeature.properties.id == "") {
		taskFeature.properties["id"] = 0;
	}
	taskFeature.properties.name = $('#tp_name').val();		// task name
	var surveyIdentifier = $('#tp_form_name').val();
	if(!surveyIdentifier) {
		alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_pss"]);
		return false;
	}
	if(isConsole) {
		taskFeature.properties.survey_ident = surveyIdentifier;	// Survey Ident
		taskFeature.properties.form_id = undefined;
	} else {
		// old fashioned
		taskFeature.properties.form_id = surveyIdentifier;	// form id
		taskFeature.properties.survey_ident = undefined;
	}

	taskFeature.properties.assign_type = $("button.assign_type.active", "#task_properties").attr("id");
	if(taskFeature.properties.assign_type == 'tp_user_type') {
		taskFeature.properties.assignee = $('#tp_user').val();
		taskFeature.properties.emails = undefined;
	} else if(taskFeature.properties.assign_type == 'tp_email_type') {
		taskFeature.properties.assignee = 0;
		taskFeature.properties.emails = $('#tp_assign_emails').val();
		if(!validateEmails(taskFeature.properties.emails)) {
			alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_inv_email"]);
			return false;
		}
	}

	if(isConsole) {
		taskFeature.properties.update_id = updateId;
		taskFeature.properties.initial_data_source = 'survey';
	}

	taskFeature.properties.repeat = $('#tp_repeat').prop('checked');
	taskFeature.properties.complete_all = $('#tp_pol').prop('checked');
	taskFeature.properties.assign_auto = $('#tp_assign_auto').prop('checked');

	fromDate = $('#tp_from').data("DateTimePicker").date();
	toDate = $('#tp_to').data("DateTimePicker").date();

	// Validate dates
	if(toDate && !fromDate) {       // Can't have a to date without a from date
		alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_no_from"]);
		return false;
	}
	if(toDate && fromDate && fromDate > toDate) {       // To date must be after from date
		alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_sel_dates"]);
		return false;
	}

	if (fromDate) {
		taskFeature.properties.from = utcTime(fromDate.format("YYYY-MM-DD HH:mm:ss"));
	}
	if (toDate) {
		taskFeature.properties.to = utcTime(toDate.format("YYYY-MM-DD HH:mm:ss"));
	}

	taskFeature.properties.location_trigger = $('#nfc_uid').val();
	taskFeature.properties.guidance = $('#tp_guidance').val();
	taskFeature.properties.show_dist = $('#tp_show_dist').val();

	/*
	 * Save location group and location name
	 */
	var locationIdx = $('#location_select').val();
	if(saveType == "nl") {
		taskFeature.properties.location_group = $('#locationGroupSave').val();
		taskFeature.properties.location_name = $('#locationSave').val();
	} else if(saveType == "ul" && locationIdx != "-1") {
		taskFeature.properties.location_group = $('.location_group_list_sel').text();
		taskFeature.properties.location_name = window.gTags[locationIdx].name;
	} else {
		taskFeature.properties.location_group = undefined;
		taskFeature.properties.location_name = undefined;
	}
	taskFeature.properties.save_type = saveType;

	/*
	 * Convert the geoJson geometry into longitude and latitude for update
	 */
	if (currentTaskFeature.geometry) {
		if (currentTaskFeature.geometry.coordinates && currentTaskFeature.geometry.coordinates.length > 1) {
			//taskFeature.properties.location = "POINT(" + gCurrentTaskFeature.geometry.coordinates.join(" ") + ")";  // deprecate
			taskFeature.properties.lon = currentTaskFeature.geometry.coordinates[0];
			taskFeature.properties.lat = currentTaskFeature.geometry.coordinates[1];

		} else {
			//taskFeature.properties.location = "POINT(0 0)"; // deprecate
			taskFeature.properties.lon = 0;
			taskFeature.properties.lat = 0;
		}
	}

	// TODO task update details (updating existing record)

	// Validations
	if(typeof taskFeature.properties.show_dist === "undefined") {
		taskFeature.properties.show_dist = 0;
	} else {
		taskFeature.properties.show_dist = +taskFeature.properties.show_dist;
	}
	if (taskFeature.properties.show_dist && taskFeature.properties.show_dist < MIN_SHOW_RANGE) {
		alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_val_show_dist"]);
		$('#tp_show_dist').focus();
		return;
	}


	var tpString = JSON.stringify(taskFeature.properties);

	addHourglass();
	$.ajax({
		type: "POST",
		dataType: 'text',
		cache: false,
		contentType: "application/x-www-form-urlencoded",
		url: url,
		data: {task: tpString},
		success: function (data, status) {
			removeHourglass();
			if(handleLogout(data)) {
				$('#task_properties').modal("hide");
				callback();
			}
		},
		error: function (xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_upd"] + " " + xhr.responseText);	// Alerts htmlencode text already
			}
		}
	});
}

/*
 * Get the list of users from the server so they can be assigned to tasks
 */
function getTaskUsers(projectId) {
	var $users = $('.users_select,#users_filter'),
		i, user,
		h = [],
		idx = -1;

	$users.empty();
	$('#users_filter').append('<option value="0">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["t_au"] + '</options>');

	$('#users_select_new_task, #users_task_group, #users_select_user, #tp_user')
		.append('<option value="-1">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["t_u"] + '</options>');

	$('#users_task_group').append('<option value="-2">' + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["t_ad"] + '</options>');
	$.ajax({
		url: "/surveyKPI/userList",
		cache: false,
		success: function (data) {

			if(handleLogout(data)) {
				for (i = 0; i < data.length; i++) {
					user = data[i];
					// Check that this user has access to the project

					if (!projectId || userHasAccessToProject(user, projectId)) {
						h[++idx] = '<option value="';
						h[++idx] = user.id;
						h[++idx] = '">';
						h[++idx] = htmlEncode(user.name);
						h[++idx] = '</option>';
					}
				}
				$users.append(h.join(''));
			}
		},
		error: function (xhr, textStatus, err) {
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + err);
				}
			}
		}
	});
}

function userHasAccessToProject(user, projectId) {
	var i;
	if(user.projects) {
		for (i = 0; i < user.projects.length; i++) {
			if (user.projects[i].id == projectId) {
				return true;
			}
		}
	}
	return false;
}

function setupTaskDialog() {
	$('#tp_email_type, #assign_email_type').click(function() {
		$('.assign_type').removeClass('active');
		$(this).addClass('active');

		$('.assign_user, .assign_role,.assign_data').hide();
		$('.assign_email').show();
		$('#assign_data').prop('placeholder', _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set['n_eqc']);
		$('.assign_data').show();
	});
	$('#tp_user_type, #assign_user_type').click(function() {
		$('.assign_type').removeClass('active');
		$(this).addClass('active');

		$('.assign_user').show();
		$('.assign_role,.assign_email').hide();
		if($('#users_task_group').val() == -2) {
			$('#assign_data').prop('placeholder', "");
			$('.assign_data').show();
		} else {
			$('.assign_data').hide();
		}
	});
	$('#tp_role_type, #assign_role_type').click(function() {
		$('.assign_type').removeClass('active');
		$(this).addClass('active');

		$('.assign_user, .assign_email').hide();
		$('.assign_role').show();
		if($('#roles_task_group').val() == -2) {
			$('#assign_data').prop('placeholder', "");
			$('.assign_data').show();
		} else {
			$('.assign_data').hide();
		}
	});

	$('#tp_from').datetimepicker({
		useCurrent: false,
		locale: gUserLocale || 'en'
	});

	$('#tp_to').datetimepicker({
		useCurrent: false,
		locale: gUserLocale || 'en'
	});

	$('#tp_from').on("dp.change", function () {

		var startDateLocal = $(this).data("DateTimePicker").date(),
			endDateLocal = $('#tp_to').data("DateTimePicker").date(),
			originalStart = gCurrentTaskFeature.properties.from,
			originalEnd = gCurrentTaskFeature.properties.to,
			newEndDate,
			duration;

		if (startDateLocal) {

			if (originalEnd && originalStart) {
				duration = moment(originalEnd, "YYYY-MM-DD HH:mm:ss").diff(moment(originalStart, "YYYY-MM-DD HH:mm:ss"), 'hours');
				newEndDate = startDateLocal.add(duration, 'hours');
				$('#tp_to').data("DateTimePicker").date(newEndDate);
			}
		}



	});

}

function getStatusClass(status, assign_auto) {

	var statusClass = "";

	if (status === "new") {
		if(assign_auto) {
			statusClass = "bg-orange";
		} else {
			statusClass = "bg-info";
		}
	} else if (status === "submitted" || status === "success") {
		statusClass = "bg-success";
	} else if (status === "late") {
		statusClass = "bg-danger";
	} else if (status === "accepted" || status === "pending") {
		statusClass = "bg-warning";
	} else 	if (status === "error" || status === "unsent" || status === "unsubscribed"
		|| status === "blocked" || status === "rejected" || status === "cancelled" || status === "deleted") {
		statusClass = "bg-rejected";
	} else {
		statusClass = "bg-success";
	}
	return statusClass;
}

/*
 *------------------------------------------------------------------
 * Common notification functions shared between console and notifications
 */
function edit_notification(edit, idx, inconsole) {

	var notification;
	var title;

	document.getElementById("notification_edit_form").reset();

	if(edit) {
		notification = window.gNotifications[idx];

		$('#bundle').prop('checked', notification.bundle);
		$('#addNotificationLabel').text(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_edit_notification"]);
		$('#trigger').val(notification.trigger);
		$('#target').val(notification.target);
		$('#name').val(notification.name);
		setTargetDependencies(notification.target);
		$('.assign_question').hide();
		if(notification.target === 'escalate' && notification.remote_user === '_data') {
			$('.assign_question').removeClass('d-none').show();
		}

		gSelectedOversightQuestion = notification.updateQuestion;
		gSelectedOversightSurvey = notification.updateSurvey;
		setTriggerDependencies(notification.trigger);
		setAttachDependencies(notification.notifyDetails.attach);

		if (notification.trigger !== "task_reminder") {
			if(notification.bundle) {
				$('#bundle_survey').val(notification.bundle_ident).change();
			} else {
				$('#survey').val(notification.s_id).change();
			}
		}
		$('#not_filter').val(notification.filter);
		$('#update_value').val(notification.updateValue);
		$('#alerts').val(notification.alert_id);
		$('#sc_question').val(notification.updateQuestion);
		$('#sc_value').val(notification.updateValue);

		// reminder settings
		if (!inconsole) {
			$('#task_group').val(getTaskGroupIndex(notification.tgId));
			if ((notification.period)) {
				var periodArray = notification.period.split(" ");
				if (periodArray.length > 1) {
					$('#r_period').val(periodArray[0]);
					$('#period_list_sel').val(periodArray[1]);
				}
			}
			if(notification.trigger === "task_reminder") {
				taskGroupChanged($('#task_group').val(), notification.notifyDetails.emailQuestionName, notification.notifyDetails.emailMeta);
			}
		}

		// Periodic settings
		$('#periodic_period').val(notification.periodic_period);
		$('#periodic_time').val(notification.periodic_time);
		$('#periodic_week_day').val(notification.periodic_week_day);
		$('#periodic_month_day').val(notification.periodic_month_day);
		$('#periodic_month, #periodic_month_quarter').val(notification.periodic_month);
		$('#report').val(notification.r_id);
		setPeriodDependencies(notification.periodic_period);

		if(notification.trigger !== "task_reminder" && (typeof notification.alert_id !== 'undefined'
			|| (notification.notify_details && (notification.notifyDetails.emailQuestionName || notification.notifyDetails.emailMeta)))) {

				surveyChangedNotification(notification.notifyDetails.emailQuestionName,
					notification.notifyDetails.assign_question,
					notification.notifyDetails.emailMeta,
					notification.alert_id,
					notification.updateQuestion,
					notification.notifyDetails.survey_case);
		}

		if (notification.notifyDetails) {

			if (notification.target == "email" || notification.target == "escalate") {
				if (notification.notifyDetails.emails) {
					$('#notify_emails').val(notification.notifyDetails.emails.join(","));
				}
				$('#assigned_user').prop('checked', notification.notifyDetails.emailAssigned);
				$('#email_subject').val(notification.notifyDetails.subject);
				$('#email_content').val(notification.notifyDetails.content);
				$('#email_attach').val(notification.notifyDetails.attach);
				$('#include_references').prop('checked', notification.notifyDetails.include_references);
				$('#launched_only').prop('checked', notification.notifyDetails.launched_only);
			} else if (notification.target == "sms") {
				if (notification.notifyDetails.emails) {
					$('#notify_sms').val(notification.notifyDetails.emails.join(","));
				}
				$('#sms_content').val(notification.notifyDetails.content);
				$('#sms_attach').val(notification.notifyDetails.attach);
				$('#sms_sender_id').val(notification.notifyDetails.subject);
			} else if (notification.target == "conversation") {
				if (notification.notifyDetails.emails) {
					$('#notify_sms').val(notification.notifyDetails.emails.join(","));
				}
				$('#conversation_text').val(notification.notifyDetails.content);
			} else if (notification.target == "webhook") {
				$('#callback_url').val(notification.notifyDetails.callback_url);
			}
		}
		if (!inconsole) {
			$('#fwd_user,#user_to_assign').val(notification.remote_user).change();
			$('#assign_question').val(notification.notifyDetails.assign_question);
			$('#survey_case').val(notification.notifyDetails.survey_case);
			gEligibleUser = notification.remote_user;
			// Password not returned from server - leave blank

			$('#fwd_host').val(notification.remote_host);

			// assign user from data
			if($('#user_to_assign').val() === '_data') {
				$('.assign_question').removeClass('d-none').show();
			}

			if (notification.enabled) {
				$('#nt_enabled').prop('checked', true);
			} else {
				$('#nt_enabled').prop('checked', false);
			}
		}

		window.gUpdateFwdPassword = false;
		window.gSelectedNotification = notification.id;
	} else {

		$('#fwd_host').val(window.gRemote_host);	// Set the values to the one's last used
		$('#fwd_user').val(window.gRemote_user);

		$('#survey').change();

		setTargetDependencies('email');
		setTriggerDependencies('submission');

		// Reminders
		$('#r_period').val(1);
		$('#period_list_sel').val('days');
		$('#nt_enabled').prop('checked',true);
		window.gUpdateFwdPassword = true;
		window.gSelectedNotification = -1;
	}
	bundleSelectChanged();

}

function bundleSelectChanged() {
	if($('#bundle').is(':checked')) {
		$('.bundle').show();
		$('.notbundle').hide();
	} else {
		$('.bundle').hide();
		$('.notbundle').show();
	}
}
function setTargetDependencies(target) {
	$('.sms_options, .webhook_options, .email_options, .escalate_options, .conv_options').hide();
	if(target === "email") {
		$('.email_options').show();
		initMsgNotPopup(target);
	} else if(target === "sms") {
		$('.sms_options').show();
	} else if(target  === "webhook") {
		$('.webhook_options').show();
	} else if(target  === "escalate") {
		$('.escalate_options,.email_options').show();
	} else if(target  === "conversation") {
		$('.conv_options').show();
		initMsgNotPopup(target);
	}
}

function setTriggerDependencies(trigger) {
	$('.task_reminder_options,.update_options, .submission_options, .cm_alert_options, .periodic_options, .sc_options').hide();
	if(trigger === "submission") {
		$('.submission_options').show();
	} else if(trigger === "task_reminder") {
		$('.task_reminder_options').show();
		$('#target').val('email');
		setTargetDependencies('email');
	} else if(trigger === "cm_alert") {
		$('.cm_alert_options').show();
	} else if(trigger === "periodic") {
		$('.periodic_options').show();
	} else if(trigger === "server_calc") {
		$('.sc_options').show();
	}
}

function setAttachDependencies(attach) {
	if(attach === "pdf" || attach === "pdf_landscape") {
		$('.pdf_options').show();
	} else  {
		$('.pdf_options').hide();
	}
}

function setPeriodDependencies(period) {
	$('.periodic_week_day, .periodic_month_day, .periodic_month, .periodic_month_quarter').hide();
	if(period === "weekly") {
		$('.periodic_week_day').show();
	} else if(period === "monthly") {
		$('.periodic_month_day').show();
	} else if(period === "yearly") {
		$('.periodic_month').show();
	} else if(period === "quarterly") {
		$('.periodic_month_quarter').show();
	}
}

/*
 * Initialise notification popup
 * Only required if the eDitRecord variable is set as used in immediate notifications
 */
function initMsgNotPopup(target) {
	if(window.gEditRecord) {
		var $msg = $('#msg_cur_nbr');
		var $email = $('#email_cur');
		var other = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_other"];

		$('.other_msg').hide();
		$('.recvd_emails').hide();

		$msg.empty();
		var hasSelect = false;
		var hasEmailSelect = false;
		if (window.gEditRecord.contacts) {
			for (const [key, value] of Object.entries(window.gEditRecord.contacts)) {
				// Hack fix up channel for old entries, its either sms or email
				if (!value.channel) {
					value.channel = (key.indexOf("@") > 0) ? 'email' : 'sms';
				}

				if (!value.channel || value.channel === 'sms' || value.channel === 'whatsapp') {
					hasSelect = true;
					$msg.append(`<option data-channel="${value.channel}" value="${key}">${key} - ${value.channel} </option>`);
				} else {
					hasEmailSelect = true;
					$email.append(`<option value="${key}">${key}</option>`);
				}
				setOurNumbersList();
			}
		}
		$msg.append(`<option value="other">${other}</option>`);
		$email.append(`<option value="other">${other}</option>`);
		if(target === "conversation") {
			msgCurNbrChanged();
		}

		if(hasEmailSelect) {
			$('.recvd_emails').show();
		}

		$('#msg_cur_nbr').change(function () {
			msgCurNbrChanged();
		});

		$('#msg_channel').change(function () {
			setOurNumbersList();
		});

	}
}

/*
 * Change attribute visibility if the user select an existing number to message or selects other
 */
function msgCurNbrChanged($choice) {
	if ($('#msg_cur_nbr').val() === 'other') {
		$('.other_msg').show();
		$('#msg_channel').prop( "disabled", false);
	} else {
		$('.other_msg').hide();
		$('#msg_channel').val($('#msg_cur_nbr option:selected').attr('data-channel')).prop( "disabled", true).trigger("change");
	}
}

/*
 * Update the notification list
 */
function updateNotificationTypes(data) {

	var $selector=$('#target'),
		i,
		h = [],
		idx = -1;

	for(i = 0; i < data.length; i++) {

		h[++idx] = '<option value="';
		h[++idx] = data[i];
		h[++idx] = '">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_" + data[i]];
		h[++idx] = '</option>';
	}

	$selector.empty().append(h.join(''));
	gConversationalSMS = false;

}

/*
 * Load the existing notifications from the server
 */
function getNotificationTypes(page) {

	addHourglass();
	$.ajax({
		url: '/surveyKPI/notifications/types?page=' + page,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				window.gNotificationTypes = data;
				if (data) {
					updateNotificationTypes(data);
					if(gTasks && gTasks.cache && gTasks.cache.currentData) {
						updateConversationalSMS(gTasks.cache.currentData.sms);
					}
				}
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					console.log("Error: Failed to get list of notification types: " + err);
				}
			}
		}
	});
}

/*
 * Update anything related to using conversations and SMS
 */
function updateConversationalSMS(sms) {
	if(sms && !gConversationalSMS) {  // Add if there is SMS data associated with this survey and the type has not already been added
		var $selector=$('#target'),
			h = [],
			idx = -1;


		h[++idx] = '<option value="conversation">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_conversation"];
		h[++idx] = '</option>';

		$selector.append(h.join(''));
		gConversationalSMS = true;
	}
}

function setupNotificationDialog() {

	// Set change function trigger
	$('#trigger').off().change(function() {
		var trigger = $(this).val();
		setTriggerDependencies(trigger);
		if(trigger === "task_reminder") {
			taskGroupChanged($('#task_group').val());
		}
		if(trigger === "console_update") {
			getGroupSurveys($('#survey').val(), showOversightSurveys);
		}
	});
	setTriggerDependencies("submission");

	// Set change function target
	$('#target').off().change(function() {
		setTargetDependencies($(this).val());
	});
	setTargetDependencies("email");

	// Set change function attach
	$('#email_attach').off().change(function() {
		setAttachDependencies($(this).val());
	});

	// Set dependencies on a periodic trigger period change
	setPeriodDependencies($('#period_period').val());
	$('#periodic_period').off().change(function() {
		setPeriodDependencies($(this).val());
	});


	// Set focus on notification name when edit notification is opened
	$('#addNotificationPopup').on('shown.bs.modal', function () {
		$('#name').focus();
	});

	/*
	 * Functions for forwarding
	 */
	$('#fwd_host').change(function(){
		var host = $(this).val();
		if(host.length === 0) {
			return false;
		} else if(host.substr(0, 4) !== "http") {
			alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_val_prot"]);
			return false;
		}
	});

	$('#fwd_password').change(function(){
		window.gUpdateFwdPassword = true;
	});

}

/*
 Get updated question names if the task group changes
 */
function taskGroupChanged(tgIndex, emailQuestionName, emailMetaName) {

	var tg = gTaskGroups[tgIndex];
	var language = "none";
	var qList;
	var metaList;

	if(tg && tg.source_s_id) {
		qList = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.getSurveyQuestions(tg.source_s_id, language);
		metaList = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.getSurveyMeta(tg.source_s_id);
	} else {
		qList = [];
		metaList = [];
	}

	if(!qList) {
		getQuestionList(tg.source_s_id, language, 0, "-1", undefined, false,
			undefined, undefined, emailQuestionName, undefined);
	} else {
		setSurveyViewQuestions(qList, undefined, undefined, undefined, emailQuestionName, undefined, undefined, undefined);
	}

	if(!metaList) {
		getMetaList(tg.source_s_id, undefined);
	} else {
		setSurveyViewMeta(metaList, undefined);
	}
}

/*
 * Process a save notification when the target is "email"
 */
function saveEmail() {

	var notification = {};
	var emails = $('#notify_emails').val();
	var emailQuestionName = $('#email_question').val();
	var emailMetaItem = $('#email_meta').val();
	var emailAssigned = $('#assigned_user').is(':checked');
	var emailArray;
	var i;

	// validate
	// Must specifify an email
	notification.error = false;
	if((!emails || emails.trim().length == 0) && (!emailQuestionName || emailQuestionName == "-1")
		&& (!emailMetaItem || emailMetaItem == "-1") && !emailAssigned) {
		notification.error = true;
		notification.errorMsg = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_inv_email"];
		notification.notifyDetails = {};
	}

	// Text email must be valid email addresses
	if(emails && emails.trim().length > 0) {
		emailArray = emails.split(",");
		for (i = 0; i < emailArray.length; i++) {
			if (!validateEmails(emailArray[i])) {
				notification.error = true;
				notification.errorMsg = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_inv_email"];
				notification.notifyDetails = {};
				break;
			}
		}
	}

	if(!notification.error) {
		notification.target = "email";
		notification.notifyDetails = {};
		notification.notifyDetails.emails = emailArray;
		notification.notifyDetails.emailQuestionName = emailQuestionName;
		notification.notifyDetails.emailAssigned = emailAssigned;
		notification.notifyDetails.emailMeta = emailMetaItem;
		notification.notifyDetails.subject = $('#email_subject').val();
		notification.notifyDetails.content = $('#email_content').val();
		notification.notifyDetails.attach = $('#email_attach').val();
		notification.notifyDetails.include_references = $('#include_references').prop('checked');
		notification.notifyDetails.launched_only = $('#launched_only').prop('checked');
	}

	return notification;
}

/*
 * Process a save notification when the target is "sms"
 */
function saveSMS() {

	var notification = {};

	notification.target = "sms";
	notification.notifyDetails = {};
	notification.notifyDetails.emails = $('#notify_sms').val().split(",");
	notification.notifyDetails.emailQuestionName = $('#sms_question').val();
	notification.notifyDetails.subject = $('#sms_sender_id').val();
	notification.notifyDetails.content = $('#sms_content').val();
	notification.notifyDetails.attach = $('#sms_attach').val();

	return notification;
}

/*
 * Process a save notification when the target is "document"
 */
function saveDocument() {

	var notification = {};

	notification.target = "document";
	notification.notifyDetails = {};

	return notification;
}

/*
 * Process a save notification when the target is "conversation"
 */
function saveConversation(columns, theirNumber, ourNumber, msgChannel, record) {

	var notification = {};

	notification.target = "conversation";
	notification.notifyDetails = {};
	notification.notifyDetails.content = $('#conversation_text').val();
	notification.notifyDetails.emails = [theirNumber];		// Must be sent as an array
	notification.notifyDetails.ourNumber = ourNumber;
	notification.notifyDetails.msgChannel = msgChannel;

	if(!theirNumber || theirNumber.length === 0) {
		notification.error = true;
		notification.errorMsg = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_no_nbr"];
	}
	return notification;
}

/*
 * Process a save notification when the target is "webhook"
 */
function saveWebhook() {

	var error = false,
		callback_url,
		notification = {};

	callback_url = $('#callback_url').val();

	if(!error) {

		notification.target = "webhook";
		notification.remote_user = $('#fwd_user').val();
		notification.remote_password = $('#fwd_password').val();
		notification.notifyDetails = {};
		notification.notifyDetails.callback_url = callback_url;
		notification.update_password = window.gUpdateFwdPassword;

	} else {
		notification.error = true;
	}

	return notification;
}

/*
 * Process a save notification when the target is "escalate"
 */
function saveEscalate() {

	var error = false,
		callback_url,
		notification = {};

	if(!error) {

		notification.target = "escalate";
		notification.remote_user = $('#user_to_assign').val();


		notification.notifyDetails = {};
		notification.notifyDetails.survey_case = $('#survey_case').val();
		notification.notifyDetails.assign_question = $('#assign_question').val();

	} else {
		notification.error = true;
	}

	return notification;
}

function getTaskGroupIndex(tgId) {
	var i;
	if(gTaskGroups && gTaskGroups.length > 0 && tgId) {
		for(i = 0; i < gTaskGroups.length; i++) {
			if(gTaskGroups[i].tg_id == tgId) {
				return i;
			}
		}
	}
	return 0;
}

function surveyChangedNotification(qName, assignQuestion, metaItem, alertId, updateQuestion, surveyVal) {

	var language = "none",
		bundle = $('#bundle').is(':checked'),
		sId = $('#survey').val() || 0,
		bundle_ident = $('#bundle_survey').val(),
		qList,
		metaList,
		alertList;

	if(bundle && bundle_ident) {
		getGroupSurveys(bundle_ident, setGroupSelector, surveyVal);		// Get the surveys in the group
	} else if(sId) {
		if(!qName) {
			qName = "-1";
		}

		getGroupSurveys(sId, setGroupSelector, surveyVal);		// Get the surveys in the group

		qList = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.getSurveyQuestions(sId, language);
		metaList = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.getSurveyMeta(sId);
		alertList = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gSelector.getSurveyAlerts(sId);

		if(!qList) {
			getQuestionList(sId, language, 0, "-1", undefined, false,
				undefined, undefined, qName, assignQuestion, updateQuestion);
		} else {
			setSurveyViewQuestions(qList, undefined, undefined, undefined, qName, assignQuestion, undefined, updateQuestion);
		}

		if(!metaList) {
			getMetaList(sId, metaItem);
		} else {
			setSurveyViewMeta(metaList, metaItem);
		}

		if(!alertList) {
			getAlertList(sId, alertId);
		} else {
			setSurveyAlerts(alertList, alertId);
		}

	}
}

function getInitialDataLink(task) {
	var tab = [];
	idx = -1;

	tab[++idx] = '<a href="';
	tab[++idx] = getWebFormUrl(task.properties.survey_ident,
		task.properties.update_id,
		task.properties.initial_data_source,
		task.properties.id,
		task.properties.a_id);
	tab[++idx] = '" target="_blank">'
	tab[++idx] = '<i class="fa fa-file-text"></i>';	// Edit existing data
	tab[++idx] = '</a>';

	return tab.join('');
}

function getWebFormUrl(form_ident, update_id, initial_data_source, taskId, assignmentId) {
	var url,
		hasParams = false;

	initial_data_souce = initial_data_source || 'none';

	url = "/webForm/" + form_ident;

	if (update_id && initial_data_source === 'survey') {
		url += "?datakey=instanceid&datakeyvalue=" + update_id;
		url += "&viewOnly=true"
		hasParams = true;
	} else {
		url += '?taskkey=';
		url += taskId;
		hasParams = true;
	}
	url += (hasParams ? '&' : '?');
	url += 'assignment_id=';
	url += assignmentId;

	return url;
}

function taskReport(taskGroup) {
	var tz = Intl.DateTimeFormat().resolvedOptions().timeZone,
		tzParam = "",
		url = '/surveyKPI/tasks/xls/' + taskGroup,
		hasParam = false,
		statusFilterArray = $('#status_filter').val(),
		period_filter = $('#period').val();

	// Add parameters
	if (tz) {
		url += (hasParam ? '&' : '?') + "tz=" + encodeURIComponent(tz);
		hasParam = true;
	}
	if(statusFilterArray) {
		url += (hasParam ? '&' : '?') + 'inc_status=' + statusFilterArray.join(',');
		hasParam = true;
	}
	if(period_filter) {
		url += (hasParam ? '&' : '?') + 'period=' + period_filter;
		hasParam = true;
	}

	downloadFile(url);
}

/*
 * Check to see if the status of the task means it should be included
 */
function includeByStatus(statusFilter, task, excludeZeroOrigin) {

	var include = statusFilter.indexOf(task.properties.status) >= 0;
	if(!include) {
		// check for late
		if(task.properties.status === 'accepted' && isLate(task.properties.to) && statusFilter.indexOf("late") >= 0) {
			include = true;
		}
	}
	if(include && excludeZeroOrigin) {
		// Remove points with 0,0 coordinates
		include = false;
		if(task.geometry) {
			include = true;
			if(task.geometry.type === "Point" && task.geometry.coordinates[0] == 0 && task.geometry.coordinates[1] == 0) {
				include = false;
			}
		}
	}

	return include;
}

/*
 * Return true if this question stores its data in a text type column
 */
function isTextStorageType(type) {
	return type === "string" || type === "select1" || type === "barcode" || type === "calculate"
		|| type === "conversation"
		|| type === "child_form" || type === "parent_form";
}

/*
 * Get surveys in the same bundle
 */
function getGroupSurveys(surveyId, callback, surveyVal) {

	var url = "/surveyKPI/surveyResults/" + surveyId + "/groups",
		survey = surveyId;

	if(surveyId) {

		if(gTasks.cache.groupSurveys[surveyId]) {
			if(typeof callback === 'function') {
				callback(gTasks.cache.groupSurveys[surveyId], surveyVal);
			}
		} else {
			addHourglass();
			$.ajax({
				url: url,
				dataType: 'json',
				cache: false,
				success: function (data) {
					removeHourglass();
					if(handleLogout(data)) {
						gTasks.cache.groupSurveys[surveyId] = data;
						if (typeof callback === 'function') {
							callback(data, surveyVal);
						}
					}
				},
				error: function (xhr, textStatus, err) {
					removeHourglass();
					if(handleLogout(xhr.responseText)) {
						if (xhr.readyState == 0 || xhr.status == 0) {
							return;  // Not an error
						} else {
							console.log(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_error"] + ": " + err);
						}
					}
				}
			});
		}
	}
}

/*
 * Update a selector that is used for any data survey in a group that is not an oversight form
 */
function setGroupSelector(data, surveyVal) {
	var $elemGroups = $('#survey_case, #tp_form_name, #not_form_name');

	var i,
		item,
		h = [],
		idx = -1;

	for (i = 0; i < data.length; i++) {
		item = data[i];

		if (item.dataSurvey) {
			h[++idx] = '<option value="';
			h[++idx] = item.surveyIdent;
			h[++idx] = '">';
			h[++idx] = htmlEncode(item.surveyName);
			h[++idx] = '</option>';

			if(!surveyVal) {
				surveyVal = item.surveyIdent;
			}
		}
	}

	$elemGroups.empty().html(h.join(''));
	if(surveyVal) {
		$elemGroups.val(surveyVal).change();
	}

}

function showOversightSurveys(data) {
	var i,
		item,
		h = [],
		idx = -1,
		surveyId = $('#survey').val(),
		count = 0;

	$('#oversight_survey').empty();

	for (i = 0; i < data.length; i++) {
		item = data[i];

		if (item.oversightSurvey && item.sId != surveyId) {
			h[++idx] = '<option value="';
			h[++idx] = item.surveyIdent;
			h[++idx] = '">';
			h[++idx] = htmlEncode(item.surveyName);
			h[++idx] = '</option>';

			if(count == 0) {
				if(gSelectedOversightSurvey) {
					getOversightQuestionList(gSelectedOversightSurvey, showOversightQuestions);
				} else {
					getOversightQuestionList(item.surveyIdent, showOversightQuestions);
				}
			}
			count++;
		}
	}

	if(count == 0) {
		$('.update_options_msg').html(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["n_no_oversight"]);
		$('.update_options_msg').show();
	} else {
		$('.update_options_msg').hide();
	}
	$('#oversight_survey').empty().html(h.join(''));
	if(gSelectedOversightSurvey) {
		$('#oversight_survey').val(gSelectedOversightSurvey);
	}
}

//Function to get the question list
function getOversightQuestionList(sIdent, callback) {

	var url = "/surveyKPI/questionListIdent/" + sIdent + "/none?exc_read_only=false&inc_meta=false";

	if(window.oversightQuestions[sIdent]) {
		callback(window.oversightQuestions[sIdent]);
	} else {
		addHourglass();
		$.ajax({
			url: url,
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				if(handleLogout(data)) {
					window.oversightQuestions[sIdent] = data;
					callback(data);
				}
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						alert("Error: Failed to get list of questions: " + err);
					}
				}
			}
		});
	}

}

function showOversightQuestions(data) {
	var i,
		item,
		h = [],
		idx = -1;

	for (i = 0; i < data.length; i++) {
		item = data[i];

		h[++idx] = '<option value="';
		h[++idx] = item.name;
		h[++idx] = '">';
		h[++idx] = htmlEncode(item.name);
		h[++idx] = '</option>';

	}

	$('#update_question').empty().html(h.join(''));
	if(gSelectedOversightQuestion) {
		$('#update_question').val(gSelectedOversightQuestion);
	}
}

/*
 * Convert system names for meta data into human names
 */
function translateKey(key) {
	if(key === "_device") {
		key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_device"];  //"Device";
	} else if (key === "_user") {
		key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_user"];  // "Submitted By";
	} else if (key === "_start") {
		key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["_start"] + " (" + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_lt"] +")"; // "Start Survey";
	} else if (key === "_end") {
		key = key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["_end"] + " (" + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_lt"] +")";  // "End Survey";
	} else if (key === "Upload Time") {
		key = key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set[key] + " (" + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_lt"] +")";
	} else if (key === "_scheduled_start") {
		key = key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set[key] + " (" + _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_lt"] +")";
	} else if (key === "_bad") {
		key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["a_mb"];         // "Marked Bad";
	} else if (key === "_bad_reason") {
		key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_reason"];     // "Reason";
	} else if (key === "_complete") {
		key = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_complete"];	// "Complete";
	}

	return key;
}

/*
 * Convert system names for meta values into human values
 */
function translateKeyValue(key, value) {

	if (key === "_bad") {
		if(value === "t") {
			value = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_yes"];   // "Yes";
		} else {
			value = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_no"];   // "No";
		}
	} else if (key === "_complete") {
		value = (value === "t") ? _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_yes"] : _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_no"];
	}

	return value;

}

function addCacheBuster(url) {
	var cb;
	if(url.indexOf("?") >= 0) {
		cb = "&";
	} else {
		cb = "?";
	}
	return cb + "_v=" + new Date().getTime().toString();
}

function getAppearanceParams(appearance) {

	var response = {};

	var idx1 = appearance.indexOf('(');
	var idx2 = appearance.lastIndexOf(')');
	var params = appearance.substring(idx1 + 1, idx2);
	var paramsArray = [];
	if(params) {
		paramsArray = params.split(',');
	}

	response.length = paramsArray.length;
	if(paramsArray.length > 0) {

		// 1. First parameter is the filename
		var filename = paramsArray[0].trim();
		response.filename = filename.replace(/'/g, "");

		response.filter = '';    // default
		if(paramsArray.length > 1) {
			// Second parameter is the filter
			response.filter = paramsArray[1].trim();
			response.filter = response.filter.replace(/'/g, "");
		}

		if(response.filter === 'eval') {
			if (paramsArray.length > 2) {
				// Third parameter for an evaluation type function is the expression
				// For an expression type filter only remove the first and last single quote if they exist
				response.expression = paramsArray[2].trim();
				if(response.expression.charAt(0) == '\'') {
					response.expression = response.expression.substring(1);
				}
				if(response.expression.charAt(response.expression.length - 1) == '\'') {
					response.expression = response.expression.substring(0, response.expression.length - 1);
				}
			}
		} else {

			if (paramsArray.length > 2) {
				// Third parameter is the filter column
				response.filter_column = paramsArray[2].trim();
				response.filter_column = response.filter_column.replace(/'/g, "");
			}

			if (paramsArray.length > 3) {
				// Fourth parameter is the filter value
				response.filter_value = paramsArray[3].trim();
				response.filter_value = response.filter_value.replace(/'/g, "");
			}

			if (paramsArray.length > 4) {
				// Fifth parameter is the second filter column
				response.second_filter_column = paramsArray[4].trim();
				response.second_filter_column = response.second_filter_column.replace(/'/g, "");
			}


			if (paramsArray.length > 5) {
				// Sixth parameter is the filter value
				response.second_filter_value = paramsArray[5].trim();
				response.second_filter_value = response.second_filter_value.replace(/'/g, "");
			}
		}

	}
	return response;
}

function getQuestionType(schema, qname) {
	var i;
	for(i = 0; i < schema.columns.length; i++) {
		if(schema.columns[i].question_name == qname) {
			return schema.columns[i].type;
		}
	}
}

function getTrailData(projectId, userId, startDate, endDate, callback, tz, mps) {

	var url = '/surveyKPI/usertrail/trail' +
		'?userId=' + userId +
		'&startDate=' + startDate +
		'&endDate=' + endDate +
		'&mps=' + (mps || 0) +
		(tz ? "&tz=" + tz : "");

	addHourglass();
	$.ajax({
		url: url,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				callback(data);
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert("Error: Failed to get user trail: " + err);
				}
			}
		}
	});
}

/*
 * Reports
 */
function executeUsageReport(oId) {

	var usageMsec = $('#usageDate').data("DateTimePicker").date(),
		d = new Date(usageMsec),
		month = d.getMonth() + 1,
		year = d.getFullYear(),
		incTemp = $('#usage_inc_temp').prop('checked'),
		incAllTime = $('#usage_inc_alltime').prop('checked'),
		byProject = $('#usage_by_project').prop('checked'),
		bySurvey = $('#usage_by_survey').prop('checked'),
		byDevice = $('#usage_by_device').prop('checked'),
		i;

	var reportName = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["u_usage"] + "_";

	// Add the organisation name
	if(oId > 0 && _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs.length > 0) {
		for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs.length; i++) {
			if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs[i].id == oId) {
				reportName += _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs[i].name + "_";
				break;
			}
		}
	}

	if(byProject) {
		reportName += _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_project"];
	} else if(bySurvey) {
		reportName += _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_survey"];
	} else if(byDevice) {
		reportName += _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_device"];
	} else {
		reportName += _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_user"];
	}
	reportName += "_" + year + "_" + month;
	reportName = reportName.replaceAll(' ', '_');

	var reportObj = {
		report_type: 'u_usage',
		report_name: reportName,
		pId: 0,
		params: {
			oId: oId,
			byProject: byProject,
			bySurvey: bySurvey,
			byDevice: byDevice,
			month: month,
			year: year,
			incTemp: incTemp,
			incAllTime: incAllTime
		}
	}

	var tzString = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone ? "?tz=" + encodeURIComponent(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone) : "";

	addHourglass();
	$.ajax({
		type: "POST",
		cache: false,
		dataType: 'text',
		contentType: "application/x-www-form-urlencoded",
		url: "/surveyKPI/background_report" + tzString,
		data: { report: JSON.stringify(reportObj) },
		success: function(data, status) {
			if(handleLogout(data)) {
				removeHourglass();
				alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_ds_s_r"]);
			}
		}, error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_save"] + xhr.responseText);	// alerts htmlencode
				}
			}
		}
	});

}

function executeSurveyReport(oId) {

	var i;

	var reportName = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_survey"];

	// Add the organisation name
	if(oId > 0 && _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs.length > 0) {
		for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs.length; i++) {
			if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs[i].id == oId) {
				reportName += _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs[i].name + "_";
				break;
			}
		}
	}

	var reportObj = {
		report_type: 'survey',
		report_name: reportName,
		params: {
			oId: oId
		}
	}

	var tzString = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone ? "?tz=" + encodeURIComponent(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone) : "";

	addHourglass();
	$.ajax({
		type: "POST",
		cache: false,
		dataType: 'text',
		contentType: "application/x-www-form-urlencoded",
		url: "/surveyKPI/background_report" + tzString,
		data: { report: JSON.stringify(reportObj) },
		success: function(data, status) {
			if(handleLogout(data)) {
				removeHourglass();
				alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_ds_s_r"]);
			}
		}, error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_save"] + xhr.responseText);	// alerts htmlencode
				}
			}
		}
	});

}
function executeAttendanceReport(oId) {

	var attendanceMsec = $('#attendanceDate').data("DateTimePicker").date(),
		d = new Date(attendanceMsec),
		day = d.getDate(),
		month = d.getMonth() + 1,
		year = d.getFullYear(),
		i;

	var reportName = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["u_attendance"] + "_";

	// Add the organisation name
	if(oId > 0 && _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs.length > 0) {
		for(i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs.length; i++) {
			if(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs[i].id == oId) {
				reportName += _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gLoggedInUser.orgs[i].name + "_";
				break;
			}
		}
	}

	reportName += "_" + year + "_" + month + "_" + day;
	reportName = reportName.replaceAll(' ', '_');

	var reportObj = {
		report_type: 'u_attendance',
		report_name: reportName,
		pId: 0,
		params: {
			oId: oId,
			month: month,
			year: year,
			day: day
		}
	}

	var tzString = _globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone ? "?tz=" + encodeURIComponent(_globals__WEBPACK_IMPORTED_MODULE_0__["default"].gTimezone) : "";

	addHourglass();
	$.ajax({
		type: "POST",
		cache: false,
		dataType: 'text',
		contentType: "application/x-www-form-urlencoded",
		url: "/surveyKPI/background_report" + tzString,
		data: { report: JSON.stringify(reportObj) },
		success: function(data, status) {
			removeHourglass();
			if(handleLogout(data)) {
				alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_ds_s_r"]);
			}
		}, error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["msg_err_save"] + " " + xhr.responseText);  // alerts htmlencode
				}
			}
		}
	});

}

/*
 * Decode escaped HTML
 * From https://stackoverflow.com/questions/1912501/unescape-html-entities-in-javascript
 */
function htmlDecode(input) {
	var doc = new DOMParser().parseFromString(input, "text/html");
	return doc.documentElement.textContent;
}

function htmlEncode(input) {
	if(input) {
		return $('<div>').text(input).html();
	}
}

/*
 * Get the list of users from the server
 */
function getEligibleUsers(sIdent, isNotification) {

	if(window.gTasks && window.gTasks.cache.eligibleUsers[sIdent]) {
		fillUsersList(isNotification, window.gTasks && window.gTasks.cache.eligibleUsers[sIdent]);
	} else if(sIdent) {
		addHourglass();
		$.ajax({
			url: "/surveyKPI/userList/survey/" + sIdent,
			dataType: 'json',
			cache: false,
			success: function (data) {
				removeHourglass();
				if(handleLogout(data)) {
					window.gTasks.cache.eligibleUsers[sIdent] = data;
					fillUsersList(isNotification, data);
				}
			},
			error: function (xhr, textStatus, err) {
				removeHourglass();
				if(handleLogout(xhr.responseText)) {
					if (xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else if (err == 403) {
						return;  // Ignore errors where the survey cannot be found. The survey requested may be the global default current survey which may be out of date
					} else {
						alert(_localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["error"] + ": " + err);
					}
				}
			}
		});
	}
}

/*
 * Fill a list with the users who can be selected
 */
function fillUsersList(isNotification, data) {
	var h = [],
		idx = -1,
		$elem = $('#user_to_assign');

	$elem.empty();

	h[++idx] = '<option value="_none">';
	h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_none"];
	h[++idx] = '</option>';

	if (isNotification) {
		h[++idx] = '<option value="_submitter">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["c_submitter"];
		h[++idx] = '</option>';

		h[++idx] = '<option value="_data">';
		h[++idx] = _localise__WEBPACK_IMPORTED_MODULE_1__["default"].set["t_ad"];
		h[++idx] = '</option>';
	}

	if (data && data.length > 0) {
		for (i = 0; i < data.length; i++) {
			h[++idx] = '<option value="';
			h[++idx] = data[i].ident;
			h[++idx] = '">';
			h[++idx] = htmlEncode(data[i].name);
			h[++idx] = '</option>';
		}
	}
	$elem.html(h.join(''));

	if (typeof gEligibleUser !== 'undefined') {
		$elem.val(gEligibleUser);
	}
}

/*
 * Return true if the passed in value is accepted by xlsFormConverter
 */
function isValidODKQuestionName(val) {

	var sqlCheck = /^[A-Za-z_][A-Za-z0-9_\-\.]*$/;
	return sqlCheck.test(val);
}

function isValidODKOptionName(val) {

	var sqlCheck = /^[A-Za-z0-9_@&\-\.\+\(\),%:\/ ]*$/;
	return sqlCheck.test(val);
}

/*
 * Check item names such as; a username or an organisation name for invalid characters
 */
function validGeneralName(val) {

	if(val.indexOf('<') >= 0 || val.indexOf('>') >= 0) {
		return false;
	}
	return true;
}

/*
 * Get the names of referenced questions in the passed in string
 */
function getReferenceNames(elem, refQuestions) {
	var names = [],
		reg = /\$\{[A-Za-z_][A-Za-z0-9_\-\.]*\}/g,
		i,
		name;

	if (elem) {
		names = elem.match(reg);
		if(names) {
			for(i = 0; i < names.length; i++) {
				if(names[i].length > 3) {
					name = names[i].substring(2, names[i].length - 1);		// Remove the curly brackets
					refQuestions[name] = {
						name: name,
						exists: false
					};
				}
			}
		}
	}
}

/*
 * Add an exists flag to each question in the references object
 */
function checkExistenceOfReferences(refQuestions, survey) {

	var refCount = 0,
		i = 0,
		j = 0,
		name,
		form;

	for (name in refQuestions) {
		if (refQuestions.hasOwnProperty(name)) {
			refCount++;
		}
	}

	if(refCount > 0) {

		for (i = 0; i < survey.forms.length; i++) {
			form = survey.forms[i];
			for (j = 0; j < form.questions.length; j++) {
				var otherItem = form.questions[j];
				var questionType = otherItem.type;
				if (!otherItem.deleted && !otherItem.soft_deleted && questionType !== "end group") {
					otherItem = form.questions[j];

					for (name in refQuestions) {
						if (refQuestions.hasOwnProperty(name)) {
							if (name === otherItem.name) {
								refQuestions[name].exists = true;
								break;
							}
						}
					}
				}
			}
		}

		// Check against preloads
		console.log("check against preloads");
		if (survey.meta) {
			for (i = 0; i < survey.meta.length; i++) {
				for (name in refQuestions) {
					if (name === survey.meta[i].name) {
						refQuestions[name].exists = true;
					}
				}
			}
		}
	}
	return refCount;
}

function checkLoggedIn(callback) {
	$.ajax({
		cache: false,
		url: "/authenticate/login.txt",
		success: function (data) {
			if(handleLogout(data)) {
				callback();
			}

		}, error: function (data, status) {
			if(handleLogout(data.responseText)) {
				alert(data);
			}
		}
	});
}

/*
 * Respond to a logged out redirect
 */
function handleLogout(data) {
	if(data) {
		if(    (data.code && data.code === 401)
			|| (data.status && data.status === 405)
			|| (data.status && data.status === 413)
			|| (typeof data === "string" && data.indexOf('"code": 401') >= 0)
			|| (typeof data === "string" && data.indexOf('Error: 401') >= 0)
			|| (typeof data === "string" && data.indexOf('Status 401 – Unauthorized') >= 0)
			|| (typeof data === "string" && data.indexOf('notloggedin.json') >= 0)
			|| (typeof data === "string" && data.toLowerCase().indexOf("method not allowed") >= 0)) {
				window.open("/login.html");
				return false;
		}

	} else if(data && (typeof data === "string" && data.indexOf('multilogon') >= 0)) {
		alert("Logon on another device detected - logging out");
		window.open("/dologout.html");
		return false;
	}
	return true;
}

/*
 * Load the sms numbers from the server
 */
function getOurNumbers() {

	var url="/surveyKPI/smsnumbers?org=true";
	addHourglass();
	$.ajax({
		url: url,
		dataType: 'json',
		cache: false,
		success: function(data) {
			removeHourglass();
			if(handleLogout(data)) {
				gNumbers = data;
				setOurNumbersList();
			}
		},
		error: function(xhr, textStatus, err) {
			removeHourglass();
			if(handleLogout(xhr.responseText)) {
				if (xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					console.log("Error: Failed to get list of sms numbers: " + err);
				}
			}
		}
	});
}

function setOurNumbersList() {
	var i = 0;
	if(gNumbers && gNumbers.length > 0) {
		var $elem = $('#msg_our_nbr');
		var channel = $('#msg_channel').val();
		$elem.empty();
		for(i = 0; i < gNumbers.length; i++) {
			var n = gNumbers[i];
			if(n.channel === channel) {
				$elem.append(`<option value="${n.ourNumber}">${n.ourNumber} - ${n.channel} </option>`);
			}
		}
	}
}




/***/ },

/***/ "../smapServer/WebContent/js/app/globals.js"
/*!**************************************************!*\
  !*** ../smapServer/WebContent/js/app/globals.js ***!
  \**************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Quick solution to issue of legacy globals after migrating to AMD / require.js
 */
const globals = {

        // Security groups
        GROUP_ADMIN: 1,
        GROUP_ANALYST: 2,
        GROUP_ENUM: 3,
        GROUP_ORG_ADMIN : 4,
        GROUP_MANAGE: 5,
        GROUP_SECURITY: 6,
        GROUP_VIEW_DATA: 7,
        GROUP_ENTERPRISE : 8,
        GROUP_OWNER : 9,
		GROUP_VIEW_OWN_DATA : 10,
	    GROUP_MANAGE_TASKS : 11,
	    GROUP_DASHBOARD : 12,
        GROUP_LINKAGES : 13,
        GROUP_CONSOLE_ADMIN : 14,
        GROUP_MCP_ACCESS : 15,

        REC_LIMIT: 200,     // Page size for table views in analysis
	    MAP_REC_LIMIT: 10000,    // Max size for map views in analysis

        gProjectList: undefined,
        gRoleList: undefined,
        gCmSettings: undefined,
        gCurrentProject: 0,
        gCurrentSurvey: 0,
        gCurrentSurveyIdent: undefined,
	    gGroupSurveys: {},
	    gSubForms: {},
        gCurrentForm: 0,
        gCurrentLayer: undefined,
        gLoggedInUser: undefined,
        gEditingReportProject: undefined,   		// Set if fieldAnalysis called to edit a report
        gIsAdministrator: false,
        gIsEnum: false,
        gIsAnalyst: false,
	    gIsDashboard: false,
        gIsManage: false,
        gIsOrgAdministrator: false,
        gIsSecurityAdministrator: false,
        gIsEnterpriseAdministrator: false,
        gIsLinkFollower: false,
        gIsServerOwner: false,
        gIsConsoleAdmin: false,
        gViewData: false,
	    gManageTasks: false,
        gBillingData: false,
        gOrgBillingData: false,
        gSendTrail: 'off',
        gViewIdx: 0,
        gSelector: new Selector(),
        gOrgId: 0,
        gTimezone: undefined,
	    gEnterpriseName: undefined,
	    gSetAsTheme: undefined,
	    gNavbarColor: undefined,

        gRegions: undefined,
        gRegion: {},

        gServerCanSendEmail: false,

        // Reports
        gEmailEnabled: false,
        gFacebookEnabled: false,
        gTwitterEnabled: false,

        // Tasks
        gCurrentUserId: undefined,
        gCurrentUserName: undefined,
        gAssignmentsLayer: undefined,
        gPendingUpdates: [],
        gCurrentTaskGroup: undefined,
	    gCurrentMailout: undefined,
        gTaskList: undefined,
        gCurrentSurveyIndex: 0,
	    gCurrentInstance: undefined,
        gAlertSeen: false,
        gLastAlertTime: undefined,

        // Editor
        gExistingSurvey: false,		// Set true if modifying an existing survey
        gElementIndex: 0,			// Manage creation of unique identifier for each element (question, option) in editor
        gHasItems: false,			// Set true if there are questions or choice lists in the survey
        gNewQuestionButtonIndex: 0,	// Manage creation of unique identifier for buttons that add new questions
        gNewOptionButtonIndex: 0,
        gSId: 0,
        gLanguage: 0,
        gLanguage1: 0,
        gLanguage2: 0,
        errors: [],
        changes: [],
        gErrorPosition: 0,
        gSelProperty: 'label',
        gSelLabel: 'Question Text',
        gSelQuestionProperty: 'label',
        gSelQuestionLabel: 'Question Text',
        gSelChoiceProperty: 'label',
        gSelChoiceLabel: 'Question Text',
        gIsQuestionView: true,
        gShowingChoices: false,
        gMaxOptionList: 0,
        gLatestOptionList: undefined,	// Hack to record the last option list name added
	    gCsvFiles: undefined,

        gListName: undefined,					// Choice Modal parameters, Set if started from choice list view
        gOptionList: undefined,					// The option list name applying to this set of choices
        gSelOptionId: undefined,				// Selected option index
        gFormIndex: undefined,					// Selected form index
        gItemIndex: undefined,					// Selected question index
        gSelectedFilters: undefined,
        gFilterArray: undefined,

        gSaveInProgress: false,

        // Dashboard
        gMainTable: undefined,			// Data tables
        gReports: undefined,			// reports
        gCharts: {},					// charts
	    gRecordMaps: [],                // Maps shown when editing a record
	    gRecordChangeMaps: [],          // Maps shown when viewing change history
        gMapLayersShown: false,
        gViewId: 0,						// Current survey view

	    gTraining: undefined,
	    gRefreshRate: 0,

        gMapboxDefault: undefined,		// Mapbox key
        
        model: typeof Model !== "undefined" ? new Model() : undefined

    }


    function Selector() {

        this.dataItems = {};
        this.surveys = {};
        this.surveysExtended = {};
        this.surveyLanguages = {};
        this.surveyQuestions = {};
        this.surveyMeta = {};
        this.surveyAlerts = {};
        this.questions = {};
        this.allSurveys = undefined;			// Simple list of surveys
        this.allRegions = undefined;
        this.sharedMaps = undefined;
        this.views = [];			// Simple list of views
        this.maps = {};				// map panels indexed by the panel id
        this.changed = false;
        this.SURVEY_KEY_PREFIX = "surveys";
        this.TASK_KEY = "tasks";
        this.TASK_COLOR = "#dd00aa";
        this.SURVEY_COLOR = "#00aa00";
        this.SELECTED_COLOR = "#0000aa";
        this.currentPanel = "map";

        this.getAll = function () {
            return this.dataItems;
        };

        this.getItem = function (key) {
            return this.dataItems[key];
        };

        this.addDataItem = function (key, data) {
            this.dataItems[key] = data;
        };

        this.clearDataItems = function () {
            this.dataItems = {};
        };

        this.addSurvey = function (sId, data) {
            this.surveys[sId] = data;
        };

        this.addSurveyExtended = function (sId, data) {
            this.surveysExtended[sId] = data;
        };

        this.getSurvey = function (sId) {
            return this.surveysExtended[sId] || this.surveys[sId];
        };

        this.clearSurveys = function () {
            this.surveys = {};
            this.surveysExtended = {};
            this.surveyLanguages = {};
            this.surveyQuestions = {};
            this.surveyMeta = {};
            this.surveyAlerts = {};
            this.allSurveys = undefined;
        };

        this.setSurveyList = function (data) {
            this.allSurveys = data;
        };

        this.getSurveyList = function () {
            return this.allSurveys;
        };

        this.setSurveyLanguages = function (sId, data) {
            this.surveyLanguages[sId] = data;
        };

        this.getSurveyLanguages = function (sId) {
            return this.surveyLanguages[sId];
        };

        this.setSurveyQuestions = function (sId, language, data) {
            if (!this.surveyQuestions[sId]) {
                this.surveyQuestions[sId] = {};
            }
            this.surveyQuestions[sId][language] = data;
        };

        this.getSurveyQuestions = function (sId, language) {
            if (!this.surveyQuestions[sId]) {
                return undefined;
            }
            if (typeof language === "undefined") {
                return this.surveyQuestions[sId];
            }
            return this.surveyQuestions[sId][language];
        };

        this.getQuestion = function (qId, language) {
            return this.getQuestionDetails(globals.gCurrentSurvey, qId, language);
        };

        this.getQuestionDetails = function (sId, qId, language) {
            var questions = this.getSurveyQuestions(sId, language);
            if (!questions) {
                return undefined;
            }
            for (var i = 0; i < questions.length; i++) {
                if (questions[i].id == qId) {
                    return questions[i];
                }
            }
            return undefined;
        };

        this.setSurveyMeta = function (sId, data) {
            this.surveyMeta[sId] = data;
        };

        this.getSurveyMeta = function (sId) {
            return this.surveyMeta[sId];
        };

        this.setSurveyAlerts = function (sId, data) {
            this.surveyAlerts[sId] = data;
        };

        this.getSurveyAlerts = function (sId) {
            return this.surveyAlerts[sId];
        };

        this.setRegionList = function (data) {
            this.allRegions = data;
        };

        this.getRegionList = function () {
            return this.allRegions;
        };

        this.setSharedMaps = function (data) {
            this.sharedMaps = data;
        };

        this.getSharedMaps = function () {
            return this.sharedMaps;
        };

        this.setViews = function (data) {
            this.views = data || [];
        };

        this.getViews = function () {
            return this.views;
        };

        this.setMap = function (idx, map) {
            this.maps[idx] = map;
        };

        this.getMap = function (idx) {
            return this.maps[idx];
        };

    }

    /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (globals);


/***/ },

/***/ "../smapServer/WebContent/js/app/localise.js"
/*!***************************************************!*\
  !*** ../smapServer/WebContent/js/app/localise.js ***!
  \***************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

const $ = window.$;

const dtLangFiles = {
	en: "",
	es: "/js/libs/DataTables.i18n/es.json",
	ar: "/js/libs/DataTables.i18n/ar.json",
	fr: "/js/libs/DataTables.i18n/fr.json",
	pt: "/js/libs/DataTables.i18n/pt.json",
	hi: "/js/libs/DataTables.i18n/hi.json"
};

const localeCache = {};
let currentLocale = "en";

function normalizeLocale(locale) {
	if (!locale) {
		return "en";
	}
	return locale.toLowerCase().replace("_", "-");
}

function localeCandidates(locale) {
	const normalized = normalizeLocale(locale);
	const base = normalized.split("-")[0];
	const candidates = [];

	if (normalized && normalized !== "en") {
		candidates.push(normalized);
	}
	if (base && base !== normalized && base !== "en") {
		candidates.push(base);
	}
	if (!candidates.includes("root")) {
		candidates.push("root");
	}

	return candidates;
}

function parseAmdLocale(text) {
	const trimmed = text.trim();
	const prefix = "define(";
	const start = trimmed.indexOf(prefix);
	const end = trimmed.lastIndexOf(")");
	if (start === -1 || end === -1 || end <= start) {
		throw new Error("Invalid locale format");
	}
	const objectText = trimmed.slice(start + prefix.length, end).trim();
	const jsonText = objectText
		.replace(/\s*\/\/.*$/gm, "")
		.replace(/\s\/\*[\s\S]*?\*\//g, "")
		.trim();
	return JSON.parse(jsonText);
}

async function loadLocaleFile(locale) {
	if (localeCache[locale]) {
		return localeCache[locale];
	}

	const src = `/js/nls/${locale}/lang.js`;
	const data = await new Promise((resolve, reject) => {
		const previousDefine = window.define;
		const script = document.createElement("script");

		window.define = function (payload) {
			window.define = previousDefine;
			script.remove();
			resolve(payload);
		};
		window.define.amd = true;

		script.src = src;
		script.async = true;
		script.onerror = function () {
			window.define = previousDefine;
			script.remove();
			reject(new Error(`Locale ${locale} not found`));
		};

		document.head.appendChild(script);
	});

	localeCache[locale] = data;
	return data;
}

async function initLocale(locale) {
	const candidates = localeCandidates(locale);
	const rootLocale = await loadLocaleFile("root");
	let merged = { ...rootLocale };
	let resolvedLocale = "root";

	for (const candidate of candidates) {
		if (candidate === "root") {
			continue;
		}
		try {
			const data = await loadLocaleFile(candidate);
			merged = { ...merged, ...data };
			resolvedLocale = candidate;
			break;
		} catch (error) {
			// fallback to next candidate
		}
	}

	currentLocale = resolvedLocale;
	window.localise.set = merged;
	return merged;
}

window.localise = {
	setlang: function () {
		$(".lang").each(function() {
			const $this = $(this);
			const code = $this.data("lang");
			if (code) {
				$this.html(window.localise.set[code]);
			}
		});

		$(".lang_tt").each(function() {
			const $this = $(this);
			const code = $this.data("lang_tt");
			if (code) {
				$this.prop("title", window.localise.set[code]);
			}
		});

		$(".lang_ph").each(function() {
			const $this = $(this);
			const code = $this.data("lang_ph");
			if (code) {
				$this.prop("placeholder", window.localise.set[code]);
			}
		});

		if (typeof responsiveMobileMenu === "function") {
			rmmResizeLabels();
		}
	},
	set: {},
	dt: function() {
		return dtLangFiles[currentLocale] || dtLangFiles.en;
	},
	initLocale
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (window.localise);


/***/ },

/***/ "../smapServer/WebContent/js/libs/bootstrap-datetimepicker.min.js"
/*!************************************************************************!*\
  !*** ../smapServer/WebContent/js/libs/bootstrap-datetimepicker.min.js ***!
  \************************************************************************/
(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! version : 4.17.42
 =========================================================
 bootstrap-datetimejs
 https://github.com/Eonasdan/bootstrap-datetimepicker
 Copyright (c) 2015 Jonathan Peterson
 =========================================================
 */
/*
 The MIT License (MIT)

 Copyright (c) 2015 Jonathan Peterson

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 */
/*global define:false */
/*global exports:false */
/*global require:false */
/*global jQuery:false */
/*global moment:false */
!function(a){"use strict";if(true)
// AMD is used - Register as an anonymous module.
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "jquery"),__webpack_require__(/*! moment */ "moment")], __WEBPACK_AMD_DEFINE_FACTORY__ = (a),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));else // removed by dead control flow
{}}(function(a,b){"use strict";if(!b)throw new Error("bootstrap-datetimepicker requires Moment.js to be loaded first");var c=function(c,d){var e,f,g,h,i,j,k,l={},m=!0,n=!1,o=!1,p=0,q=[{clsName:"days",navFnc:"M",navStep:1},{clsName:"months",navFnc:"y",navStep:1},{clsName:"years",navFnc:"y",navStep:10},{clsName:"decades",navFnc:"y",navStep:100}],r=["days","months","years","decades"],s=["top","bottom","auto"],t=["left","right","auto"],u=["default","top","bottom"],v={up:38,38:"up",down:40,40:"down",left:37,37:"left",right:39,39:"right",tab:9,9:"tab",escape:27,27:"escape",enter:13,13:"enter",pageUp:33,33:"pageUp",pageDown:34,34:"pageDown",shift:16,16:"shift",control:17,17:"control",space:32,32:"space",t:84,84:"t","delete":46,46:"delete"},w={},/********************************************************************************
             *
             * Private functions
             *
             ********************************************************************************/
x=function(){return void 0!==b.tz&&void 0!==d.timeZone&&null!==d.timeZone&&""!==d.timeZone},y=function(a){var c;return c=void 0===a||null===a?b():x()?b.tz(a,j,d.useStrict,d.timeZone):b(a,j,d.useStrict),x()&&c.tz(d.timeZone),c},z=function(a){if("string"!=typeof a||a.length>1)throw new TypeError("isEnabled expects a single character string parameter");switch(a){case"y":return-1!==i.indexOf("Y");case"M":return-1!==i.indexOf("M");case"d":return-1!==i.toLowerCase().indexOf("d");case"h":case"H":return-1!==i.toLowerCase().indexOf("h");case"m":return-1!==i.indexOf("m");case"s":return-1!==i.indexOf("s");default:return!1}},A=function(){return z("h")||z("m")||z("s")},B=function(){return z("y")||z("M")||z("d")},C=function(){var b=a("<thead>").append(a("<tr>").append(a("<th>").addClass("prev").attr("data-action","previous").append(a("<span>").addClass(d.icons.previous))).append(a("<th>").addClass("picker-switch").attr("data-action","pickerSwitch").attr("colspan",d.calendarWeeks?"6":"5")).append(a("<th>").addClass("next").attr("data-action","next").append(a("<span>").addClass(d.icons.next)))),c=a("<tbody>").append(a("<tr>").append(a("<td>").attr("colspan",d.calendarWeeks?"8":"7")));return[a("<div>").addClass("datepicker-days").append(a("<table>").addClass("table-condensed").append(b).append(a("<tbody>"))),a("<div>").addClass("datepicker-months").append(a("<table>").addClass("table-condensed").append(b.clone()).append(c.clone())),a("<div>").addClass("datepicker-years").append(a("<table>").addClass("table-condensed").append(b.clone()).append(c.clone())),a("<div>").addClass("datepicker-decades").append(a("<table>").addClass("table-condensed").append(b.clone()).append(c.clone()))]},D=function(){var b=a("<tr>"),c=a("<tr>"),e=a("<tr>");return z("h")&&(b.append(a("<td>").append(a("<a>").attr({href:"#",tabindex:"-1",title:d.tooltips.incrementHour}).addClass("btn").attr("data-action","incrementHours").append(a("<span>").addClass(d.icons.up)))),c.append(a("<td>").append(a("<span>").addClass("timepicker-hour").attr({"data-time-component":"hours",title:d.tooltips.pickHour}).attr("data-action","showHours"))),e.append(a("<td>").append(a("<a>").attr({href:"#",tabindex:"-1",title:d.tooltips.decrementHour}).addClass("btn").attr("data-action","decrementHours").append(a("<span>").addClass(d.icons.down))))),z("m")&&(z("h")&&(b.append(a("<td>").addClass("separator")),c.append(a("<td>").addClass("separator").html(":")),e.append(a("<td>").addClass("separator"))),b.append(a("<td>").append(a("<a>").attr({href:"#",tabindex:"-1",title:d.tooltips.incrementMinute}).addClass("btn").attr("data-action","incrementMinutes").append(a("<span>").addClass(d.icons.up)))),c.append(a("<td>").append(a("<span>").addClass("timepicker-minute").attr({"data-time-component":"minutes",title:d.tooltips.pickMinute}).attr("data-action","showMinutes"))),e.append(a("<td>").append(a("<a>").attr({href:"#",tabindex:"-1",title:d.tooltips.decrementMinute}).addClass("btn").attr("data-action","decrementMinutes").append(a("<span>").addClass(d.icons.down))))),z("s")&&(z("m")&&(b.append(a("<td>").addClass("separator")),c.append(a("<td>").addClass("separator").html(":")),e.append(a("<td>").addClass("separator"))),b.append(a("<td>").append(a("<a>").attr({href:"#",tabindex:"-1",title:d.tooltips.incrementSecond}).addClass("btn").attr("data-action","incrementSeconds").append(a("<span>").addClass(d.icons.up)))),c.append(a("<td>").append(a("<span>").addClass("timepicker-second").attr({"data-time-component":"seconds",title:d.tooltips.pickSecond}).attr("data-action","showSeconds"))),e.append(a("<td>").append(a("<a>").attr({href:"#",tabindex:"-1",title:d.tooltips.decrementSecond}).addClass("btn").attr("data-action","decrementSeconds").append(a("<span>").addClass(d.icons.down))))),h||(b.append(a("<td>").addClass("separator")),c.append(a("<td>").append(a("<button>").addClass("btn btn-primary").attr({"data-action":"togglePeriod",tabindex:"-1",title:d.tooltips.togglePeriod}))),e.append(a("<td>").addClass("separator"))),a("<div>").addClass("timepicker-picker").append(a("<table>").addClass("table-condensed").append([b,c,e]))},E=function(){var b=a("<div>").addClass("timepicker-hours").append(a("<table>").addClass("table-condensed")),c=a("<div>").addClass("timepicker-minutes").append(a("<table>").addClass("table-condensed")),d=a("<div>").addClass("timepicker-seconds").append(a("<table>").addClass("table-condensed")),e=[D()];return z("h")&&e.push(b),z("m")&&e.push(c),z("s")&&e.push(d),e},F=function(){var b=[];return d.showTodayButton&&b.push(a("<td>").append(a("<a>").attr({"data-action":"today",title:d.tooltips.today}).append(a("<span>").addClass(d.icons.today)))),!d.sideBySide&&B()&&A()&&b.push(a("<td>").append(a("<a>").attr({"data-action":"togglePicker",title:d.tooltips.selectTime}).append(a("<span>").addClass(d.icons.time)))),d.showClear&&b.push(a("<td>").append(a("<a>").attr({"data-action":"clear",title:d.tooltips.clear}).append(a("<span>").addClass(d.icons.clear)))),d.showClose&&b.push(a("<td>").append(a("<a>").attr({"data-action":"close",title:d.tooltips.close}).append(a("<span>").addClass(d.icons.close)))),a("<table>").addClass("table-condensed").append(a("<tbody>").append(a("<tr>").append(b)))},G=function(){var b=a("<div>").addClass("bootstrap-datetimepicker-widget dropdown-menu"),c=a("<div>").addClass("datepicker").append(C()),e=a("<div>").addClass("timepicker").append(E()),f=a("<ul>").addClass("list-unstyled"),g=a("<li>").addClass("picker-switch"+(d.collapse?" accordion-toggle":"")).append(F());return d.inline&&b.removeClass("dropdown-menu"),h&&b.addClass("usetwentyfour"),z("s")&&!h&&b.addClass("wider"),d.sideBySide&&B()&&A()?(b.addClass("timepicker-sbs"),"top"===d.toolbarPlacement&&b.append(g),b.append(a("<div>").addClass("row").append(c.addClass("col-md-6")).append(e.addClass("col-md-6"))),"bottom"===d.toolbarPlacement&&b.append(g),b):("top"===d.toolbarPlacement&&f.append(g),B()&&f.append(a("<li>").addClass(d.collapse&&A()?"collapse in":"").append(c)),"default"===d.toolbarPlacement&&f.append(g),A()&&f.append(a("<li>").addClass(d.collapse&&B()?"collapse":"").append(e)),"bottom"===d.toolbarPlacement&&f.append(g),b.append(f))},H=function(){var b,e={};return b=c.is("input")||d.inline?c.data():c.find("input").data(),b.dateOptions&&b.dateOptions instanceof Object&&(e=a.extend(!0,e,b.dateOptions)),a.each(d,function(a){var c="date"+a.charAt(0).toUpperCase()+a.slice(1);void 0!==b[c]&&(e[a]=b[c])}),e},I=function(){var b,e=(n||c).position(),f=(n||c).offset(),g=d.widgetPositioning.vertical,h=d.widgetPositioning.horizontal;if(d.widgetParent)b=d.widgetParent.append(o);else if(c.is("input"))b=c.after(o).parent();else{if(d.inline)return void(b=c.append(o));b=c,c.children().first().after(o)}if(
// Top and bottom logic
"auto"===g&&(g=f.top+1.5*o.height()>=a(window).height()+a(window).scrollTop()&&o.height()+c.outerHeight()<f.top?"top":"bottom"),
// Left and right logic
"auto"===h&&(h=b.width()<f.left+o.outerWidth()/2&&f.left+o.outerWidth()>a(window).width()?"right":"left"),"top"===g?o.addClass("top").removeClass("bottom"):o.addClass("bottom").removeClass("top"),"right"===h?o.addClass("pull-right"):o.removeClass("pull-right"),
// find the first parent element that has a relative css positioning
"relative"!==b.css("position")&&(b=b.parents().filter(function(){return"relative"===a(this).css("position")}).first()),0===b.length)throw new Error("datetimepicker component should be placed within a relative positioned container");o.css({top:"top"===g?"auto":e.top+c.outerHeight(),bottom:"top"===g?b.outerHeight()-(b===c?0:e.top):"auto",left:"left"===h?b===c?0:e.left:"auto",right:"left"===h?"auto":b.outerWidth()-c.outerWidth()-(b===c?0:e.left)})},J=function(a){"dp.change"===a.type&&(a.date&&a.date.isSame(a.oldDate)||!a.date&&!a.oldDate)||c.trigger(a)},K=function(a){"y"===a&&(a="YYYY"),J({type:"dp.update",change:a,viewDate:f.clone()})},L=function(a){o&&(a&&(k=Math.max(p,Math.min(3,k+a))),o.find(".datepicker > div").hide().filter(".datepicker-"+q[k].clsName).show())},M=function(){var b=a("<tr>"),c=f.clone().startOf("w").startOf("d");for(d.calendarWeeks===!0&&b.append(a("<th>").addClass("cw").text("#"));c.isBefore(f.clone().endOf("w"));)b.append(a("<th>").addClass("dow").text(c.format("dd"))),c.add(1,"d");o.find(".datepicker-days thead").append(b)},N=function(a){return d.disabledDates[a.format("YYYY-MM-DD")]===!0},O=function(a){return d.enabledDates[a.format("YYYY-MM-DD")]===!0},P=function(a){return d.disabledHours[a.format("H")]===!0},Q=function(a){return d.enabledHours[a.format("H")]===!0},R=function(b,c){if(!b.isValid())return!1;if(d.disabledDates&&"d"===c&&N(b))return!1;if(d.enabledDates&&"d"===c&&!O(b))return!1;if(d.minDate&&b.isBefore(d.minDate,c))return!1;if(d.maxDate&&b.isAfter(d.maxDate,c))return!1;if(d.daysOfWeekDisabled&&"d"===c&&-1!==d.daysOfWeekDisabled.indexOf(b.day()))return!1;if(d.disabledHours&&("h"===c||"m"===c||"s"===c)&&P(b))return!1;if(d.enabledHours&&("h"===c||"m"===c||"s"===c)&&!Q(b))return!1;if(d.disabledTimeIntervals&&("h"===c||"m"===c||"s"===c)){var e=!1;if(a.each(d.disabledTimeIntervals,function(){return b.isBetween(this[0],this[1])?(e=!0,!1):void 0}),e)return!1}return!0},S=function(){for(var b=[],c=f.clone().startOf("y").startOf("d");c.isSame(f,"y");)b.push(a("<span>").attr("data-action","selectMonth").addClass("month").text(c.format("MMM"))),c.add(1,"M");o.find(".datepicker-months td").empty().append(b)},T=function(){var b=o.find(".datepicker-months"),c=b.find("th"),g=b.find("tbody").find("span");c.eq(0).find("span").attr("title",d.tooltips.prevYear),c.eq(1).attr("title",d.tooltips.selectYear),c.eq(2).find("span").attr("title",d.tooltips.nextYear),b.find(".disabled").removeClass("disabled"),R(f.clone().subtract(1,"y"),"y")||c.eq(0).addClass("disabled"),c.eq(1).text(f.year()),R(f.clone().add(1,"y"),"y")||c.eq(2).addClass("disabled"),g.removeClass("active"),e.isSame(f,"y")&&!m&&g.eq(e.month()).addClass("active"),g.each(function(b){R(f.clone().month(b),"M")||a(this).addClass("disabled")})},U=function(){var a=o.find(".datepicker-years"),b=a.find("th"),c=f.clone().subtract(5,"y"),g=f.clone().add(6,"y"),h="";for(b.eq(0).find("span").attr("title",d.tooltips.prevDecade),b.eq(1).attr("title",d.tooltips.selectDecade),b.eq(2).find("span").attr("title",d.tooltips.nextDecade),a.find(".disabled").removeClass("disabled"),d.minDate&&d.minDate.isAfter(c,"y")&&b.eq(0).addClass("disabled"),b.eq(1).text(c.year()+"-"+g.year()),d.maxDate&&d.maxDate.isBefore(g,"y")&&b.eq(2).addClass("disabled");!c.isAfter(g,"y");)h+='<span data-action="selectYear" class="year'+(c.isSame(e,"y")&&!m?" active":"")+(R(c,"y")?"":" disabled")+'">'+c.year()+"</span>",c.add(1,"y");a.find("td").html(h)},V=function(){var a,c=o.find(".datepicker-decades"),g=c.find("th"),h=b({y:f.year()-f.year()%100-1}),i=h.clone().add(100,"y"),j=h.clone(),k=!1,l=!1,m="";for(g.eq(0).find("span").attr("title",d.tooltips.prevCentury),g.eq(2).find("span").attr("title",d.tooltips.nextCentury),c.find(".disabled").removeClass("disabled"),(h.isSame(b({y:1900}))||d.minDate&&d.minDate.isAfter(h,"y"))&&g.eq(0).addClass("disabled"),g.eq(1).text(h.year()+"-"+i.year()),(h.isSame(b({y:2e3}))||d.maxDate&&d.maxDate.isBefore(i,"y"))&&g.eq(2).addClass("disabled");!h.isAfter(i,"y");)a=h.year()+12,k=d.minDate&&d.minDate.isAfter(h,"y")&&d.minDate.year()<=a,l=d.maxDate&&d.maxDate.isAfter(h,"y")&&d.maxDate.year()<=a,m+='<span data-action="selectDecade" class="decade'+(e.isAfter(h)&&e.year()<=a?" active":"")+(R(h,"y")||k||l?"":" disabled")+'" data-selection="'+(h.year()+6)+'">'+(h.year()+1)+" - "+(h.year()+12)+"</span>",h.add(12,"y");m+="<span></span><span></span><span></span>",c.find("td").html(m),g.eq(1).text(j.year()+1+"-"+h.year())},W=function(){var b,c,g,h,i=o.find(".datepicker-days"),j=i.find("th"),k=[];if(B()){for(j.eq(0).find("span").attr("title",d.tooltips.prevMonth),j.eq(1).attr("title",d.tooltips.selectMonth),j.eq(2).find("span").attr("title",d.tooltips.nextMonth),i.find(".disabled").removeClass("disabled"),j.eq(1).text(f.format(d.dayViewHeaderFormat)),R(f.clone().subtract(1,"M"),"M")||j.eq(0).addClass("disabled"),R(f.clone().add(1,"M"),"M")||j.eq(2).addClass("disabled"),b=f.clone().startOf("M").startOf("w").startOf("d"),h=0;42>h;h++)//always display 42 days (should show 6 weeks)
0===b.weekday()&&(c=a("<tr>"),d.calendarWeeks&&c.append('<td class="cw">'+b.week()+"</td>"),k.push(c)),g="",b.isBefore(f,"M")&&(g+=" old"),b.isAfter(f,"M")&&(g+=" new"),b.isSame(e,"d")&&!m&&(g+=" active"),R(b,"d")||(g+=" disabled"),b.isSame(y(),"d")&&(g+=" today"),0!==b.day()&&6!==b.day()||(g+=" weekend"),c.append('<td data-action="selectDay" data-day="'+b.format("L")+'" class="day'+g+'">'+b.date()+"</td>"),b.add(1,"d");i.find("tbody").empty().append(k),T(),U(),V()}},X=function(){var b=o.find(".timepicker-hours table"),c=f.clone().startOf("d"),d=[],e=a("<tr>");for(f.hour()>11&&!h&&c.hour(12);c.isSame(f,"d")&&(h||f.hour()<12&&c.hour()<12||f.hour()>11);)c.hour()%4===0&&(e=a("<tr>"),d.push(e)),e.append('<td data-action="selectHour" class="hour'+(R(c,"h")?"":" disabled")+'">'+c.format(h?"HH":"hh")+"</td>"),c.add(1,"h");b.empty().append(d)},Y=function(){for(var b=o.find(".timepicker-minutes table"),c=f.clone().startOf("h"),e=[],g=a("<tr>"),h=1===d.stepping?5:d.stepping;f.isSame(c,"h");)c.minute()%(4*h)===0&&(g=a("<tr>"),e.push(g)),g.append('<td data-action="selectMinute" class="minute'+(R(c,"m")?"":" disabled")+'">'+c.format("mm")+"</td>"),c.add(h,"m");b.empty().append(e)},Z=function(){for(var b=o.find(".timepicker-seconds table"),c=f.clone().startOf("m"),d=[],e=a("<tr>");f.isSame(c,"m");)c.second()%20===0&&(e=a("<tr>"),d.push(e)),e.append('<td data-action="selectSecond" class="second'+(R(c,"s")?"":" disabled")+'">'+c.format("ss")+"</td>"),c.add(5,"s");b.empty().append(d)},$=function(){var a,b,c=o.find(".timepicker span[data-time-component]");h||(a=o.find(".timepicker [data-action=togglePeriod]"),b=e.clone().add(e.hours()>=12?-12:12,"h"),a.text(e.format("A")),R(b,"h")?a.removeClass("disabled"):a.addClass("disabled")),c.filter("[data-time-component=hours]").text(e.format(h?"HH":"hh")),c.filter("[data-time-component=minutes]").text(e.format("mm")),c.filter("[data-time-component=seconds]").text(e.format("ss")),X(),Y(),Z()},_=function(){o&&(W(),$())},aa=function(a){var b=m?null:e;
// case of calling setValue(null or false)
// case of calling setValue(null or false)
//viewDate = date.clone(); // TODO this doesn't work right on first use
return a?(a=a.clone().locale(d.locale),x()&&a.tz(d.timeZone),1!==d.stepping&&a.minutes(Math.round(a.minutes()/d.stepping)*d.stepping).seconds(0),void(R(a)?(e=a,g.val(e.format(i)),c.data("date",e.format(i)),m=!1,_(),J({type:"dp.change",date:e.clone(),oldDate:b})):(d.keepInvalid?J({type:"dp.change",date:a,oldDate:b}):g.val(m?"":e.format(i)),J({type:"dp.error",date:a,oldDate:b})))):(m=!0,g.val(""),c.data("date",""),J({type:"dp.change",date:!1,oldDate:b}),void _())},/**
             * Hides the widget. Possibly will emit dp.hide
             */
ba=function(){var b=!1;
// Ignore event if in the middle of a picker transition
return o?(o.find(".collapse").each(function(){var c=a(this).data("collapse");return c&&c.transitioning?(b=!0,!1):!0}),b?l:(n&&n.hasClass("btn")&&n.toggleClass("active"),o.hide(),a(window).off("resize",I),o.off("click","[data-action]"),o.off("mousedown",!1),o.remove(),o=!1,J({type:"dp.hide",date:e.clone()}),g.blur(),k=0,f=e.clone(),l)):l},ca=function(){aa(null)},da=function(a){
//inputDate.locale(options.locale);
return void 0===d.parseInputDate?b.isMoment(a)||(a=y(a)):a=d.parseInputDate(a),a},/********************************************************************************
             *
             * Widget UI interaction functions
             *
             ********************************************************************************/
ea={next:function(){var a=q[k].navFnc;f.add(q[k].navStep,a),W(),K(a)},previous:function(){var a=q[k].navFnc;f.subtract(q[k].navStep,a),W(),K(a)},pickerSwitch:function(){L(1)},selectMonth:function(b){var c=a(b.target).closest("tbody").find("span").index(a(b.target));f.month(c),k===p?(aa(e.clone().year(f.year()).month(f.month())),d.inline||ba()):(L(-1),W()),K("M")},selectYear:function(b){var c=parseInt(a(b.target).text(),10)||0;f.year(c),k===p?(aa(e.clone().year(f.year())),d.inline||ba()):(L(-1),W()),K("YYYY")},selectDecade:function(b){var c=parseInt(a(b.target).data("selection"),10)||0;f.year(c),k===p?(aa(e.clone().year(f.year())),d.inline||ba()):(L(-1),W()),K("YYYY")},selectDay:function(b){var c=f.clone();a(b.target).is(".old")&&c.subtract(1,"M"),a(b.target).is(".new")&&c.add(1,"M"),aa(c.date(parseInt(a(b.target).text(),10))),A()||d.keepOpen||d.inline||ba()},incrementHours:function(){var a=e.clone().add(1,"h");R(a,"h")&&aa(a)},incrementMinutes:function(){var a=e.clone().add(d.stepping,"m");R(a,"m")&&aa(a)},incrementSeconds:function(){var a=e.clone().add(1,"s");R(a,"s")&&aa(a)},decrementHours:function(){var a=e.clone().subtract(1,"h");R(a,"h")&&aa(a)},decrementMinutes:function(){var a=e.clone().subtract(d.stepping,"m");R(a,"m")&&aa(a)},decrementSeconds:function(){var a=e.clone().subtract(1,"s");R(a,"s")&&aa(a)},togglePeriod:function(){aa(e.clone().add(e.hours()>=12?-12:12,"h"))},togglePicker:function(b){var c,e=a(b.target),f=e.closest("ul"),g=f.find(".in"),h=f.find(".collapse:not(.in)");if(g&&g.length){if(c=g.data("collapse"),c&&c.transitioning)return;g.collapse?(// if collapse plugin is available through bootstrap.js then use it
g.collapse("hide"),h.collapse("show")):(// otherwise just toggle in class on the two views
g.removeClass("in"),h.addClass("in")),e.is("span")?e.toggleClass(d.icons.time+" "+d.icons.date):e.find("span").toggleClass(d.icons.time+" "+d.icons.date)}},showPicker:function(){o.find(".timepicker > div:not(.timepicker-picker)").hide(),o.find(".timepicker .timepicker-picker").show()},showHours:function(){o.find(".timepicker .timepicker-picker").hide(),o.find(".timepicker .timepicker-hours").show()},showMinutes:function(){o.find(".timepicker .timepicker-picker").hide(),o.find(".timepicker .timepicker-minutes").show()},showSeconds:function(){o.find(".timepicker .timepicker-picker").hide(),o.find(".timepicker .timepicker-seconds").show()},selectHour:function(b){var c=parseInt(a(b.target).text(),10);h||(e.hours()>=12?12!==c&&(c+=12):12===c&&(c=0)),aa(e.clone().hours(c)),ea.showPicker.call(l)},selectMinute:function(b){aa(e.clone().minutes(parseInt(a(b.target).text(),10))),ea.showPicker.call(l)},selectSecond:function(b){aa(e.clone().seconds(parseInt(a(b.target).text(),10))),ea.showPicker.call(l)},clear:ca,today:function(){var a=y();R(a,"d")&&aa(a)},close:ba},fa=function(b){return a(b.currentTarget).is(".disabled")?!1:(ea[a(b.currentTarget).data("action")].apply(l,arguments),!1)},/**
             * Shows the widget. Possibly will emit dp.show and dp.change
             */
ga=function(){var b,c={year:function(a){return a.month(0).date(1).hours(0).seconds(0).minutes(0)},month:function(a){return a.date(1).hours(0).seconds(0).minutes(0)},day:function(a){return a.hours(0).seconds(0).minutes(0)},hour:function(a){return a.seconds(0).minutes(0)},minute:function(a){return a.seconds(0)}};// this handles clicks on the widget
return g.prop("disabled")||!d.ignoreReadonly&&g.prop("readonly")||o?l:(void 0!==g.val()&&0!==g.val().trim().length?aa(da(g.val().trim())):m&&d.useCurrent&&(d.inline||g.is("input")&&0===g.val().trim().length)&&(b=y(),"string"==typeof d.useCurrent&&(b=c[d.useCurrent](b)),aa(b)),o=G(),M(),S(),o.find(".timepicker-hours").hide(),o.find(".timepicker-minutes").hide(),o.find(".timepicker-seconds").hide(),_(),L(),a(window).on("resize",I),o.on("click","[data-action]",fa),o.on("mousedown",!1),n&&n.hasClass("btn")&&n.toggleClass("active"),I(),o.show(),d.focusOnShow&&!g.is(":focus")&&g.focus(),J({type:"dp.show"}),l)},/**
             * Shows or hides the widget
             */
ha=function(){return o?ba():ga()},ia=function(a){var b,c,e,f,g=null,h=[],i={},j=a.which,k="p";w[j]=k;for(b in w)w.hasOwnProperty(b)&&w[b]===k&&(h.push(b),parseInt(b,10)!==j&&(i[b]=!0));for(b in d.keyBinds)if(d.keyBinds.hasOwnProperty(b)&&"function"==typeof d.keyBinds[b]&&(e=b.split(" "),e.length===h.length&&v[j]===e[e.length-1])){for(f=!0,c=e.length-2;c>=0;c--)if(!(v[e[c]]in i)){f=!1;break}if(f){g=d.keyBinds[b];break}}g&&(g.call(l,o),a.stopPropagation(),a.preventDefault())},ja=function(a){w[a.which]="r",a.stopPropagation(),a.preventDefault()},ka=function(b){var c=a(b.target).val().trim(),d=c?da(c):null;return aa(d),b.stopImmediatePropagation(),!1},la=function(){g.on({change:ka,blur:d.debug?"":ba,keydown:ia,keyup:ja,focus:d.allowInputToggle?ga:""}),c.is("input")?g.on({focus:ga}):n&&(n.on("click",ha),n.on("mousedown",!1))},ma=function(){g.off({change:ka,blur:blur,keydown:ia,keyup:ja,focus:d.allowInputToggle?ba:""}),c.is("input")?g.off({focus:ga}):n&&(n.off("click",ha),n.off("mousedown",!1))},na=function(b){
// Store given enabledDates and disabledDates as keys.
// This way we can check their existence in O(1) time instead of looping through whole array.
// (for example: options.enabledDates['2014-02-27'] === true)
var c={};return a.each(b,function(){var a=da(this);a.isValid()&&(c[a.format("YYYY-MM-DD")]=!0)}),Object.keys(c).length?c:!1},oa=function(b){
// Store given enabledHours and disabledHours as keys.
// This way we can check their existence in O(1) time instead of looping through whole array.
// (for example: options.enabledHours['2014-02-27'] === true)
var c={};return a.each(b,function(){c[this]=!0}),Object.keys(c).length?c:!1},pa=function(){var a=d.format||"L LT";i=a.replace(/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,function(a){var b=e.localeData().longDateFormat(a)||a;return b.replace(/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,function(a){//temp fix for #740
return e.localeData().longDateFormat(a)||a})}),j=d.extraFormats?d.extraFormats.slice():[],j.indexOf(a)<0&&j.indexOf(i)<0&&j.push(i),h=i.toLowerCase().indexOf("a")<1&&i.replace(/\[.*?\]/g,"").indexOf("h")<1,z("y")&&(p=2),z("M")&&(p=1),z("d")&&(p=0),k=Math.max(p,k),m||aa(e)};
// initializing element and component attributes
if(/********************************************************************************
         *
         * Public API functions
         * =====================
         *
         * Important: Do not expose direct references to private objects or the options
         * object to the outer world. Always return a clone when returning values or make
         * a clone when setting a private variable.
         *
         ********************************************************************************/
l.destroy=function(){
///<summary>Destroys the widget and removes all attached event listeners</summary>
ba(),ma(),c.removeData("DateTimePicker"),c.removeData("date")},l.toggle=ha,l.show=ga,l.hide=ba,l.disable=function(){
///<summary>Disables the input element, the component is attached to, by adding a disabled="true" attribute to it.
///If the widget was visible before that call it is hidden. Possibly emits dp.hide</summary>
return ba(),n&&n.hasClass("btn")&&n.addClass("disabled"),g.prop("disabled",!0),l},l.enable=function(){
///<summary>Enables the input element, the component is attached to, by removing disabled attribute from it.</summary>
return n&&n.hasClass("btn")&&n.removeClass("disabled"),g.prop("disabled",!1),l},l.ignoreReadonly=function(a){if(0===arguments.length)return d.ignoreReadonly;if("boolean"!=typeof a)throw new TypeError("ignoreReadonly () expects a boolean parameter");return d.ignoreReadonly=a,l},l.options=function(b){if(0===arguments.length)return a.extend(!0,{},d);if(!(b instanceof Object))throw new TypeError("options() options parameter should be an object");return a.extend(!0,d,b),a.each(d,function(a,b){if(void 0===l[a])throw new TypeError("option "+a+" is not recognized!");l[a](b)}),l},l.date=function(a){
///<signature helpKeyword="$.fn.datetimepicker.date">
///<summary>Returns the component's model current date, a moment object or null if not set.</summary>
///<returns type="Moment">date.clone()</returns>
///</signature>
///<signature>
///<summary>Sets the components model current moment to it. Passing a null value unsets the components model current moment. Parsing of the newDate parameter is made using moment library with the options.format and options.useStrict components configuration.</summary>
///<param name="newDate" locid="$.fn.datetimepicker.date_p:newDate">Takes string, Date, moment, null parameter.</param>
///</signature>
if(0===arguments.length)return m?null:e.clone();if(!(null===a||"string"==typeof a||b.isMoment(a)||a instanceof Date))throw new TypeError("date() parameter must be one of [null, string, moment or Date]");return aa(null===a?null:da(a)),l},l.format=function(a){
///<summary>test su</summary>
///<param name="newFormat">info about para</param>
///<returns type="string|boolean">returns foo</returns>
if(0===arguments.length)return d.format;if("string"!=typeof a&&("boolean"!=typeof a||a!==!1))throw new TypeError("format() expects a string or boolean:false parameter "+a);return d.format=a,i&&pa(),l},l.timeZone=function(a){if(0===arguments.length)return d.timeZone;if("string"!=typeof a)throw new TypeError("newZone() expects a string parameter");return d.timeZone=a,l},l.dayViewHeaderFormat=function(a){if(0===arguments.length)return d.dayViewHeaderFormat;if("string"!=typeof a)throw new TypeError("dayViewHeaderFormat() expects a string parameter");return d.dayViewHeaderFormat=a,l},l.extraFormats=function(a){if(0===arguments.length)return d.extraFormats;if(a!==!1&&!(a instanceof Array))throw new TypeError("extraFormats() expects an array or false parameter");return d.extraFormats=a,j&&pa(),l},l.disabledDates=function(b){
///<signature helpKeyword="$.fn.datetimepicker.disabledDates">
///<summary>Returns an array with the currently set disabled dates on the component.</summary>
///<returns type="array">options.disabledDates</returns>
///</signature>
///<signature>
///<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of
///options.enabledDates if such exist.</summary>
///<param name="dates" locid="$.fn.datetimepicker.disabledDates_p:dates">Takes an [ string or Date or moment ] of values and allows the user to select only from those days.</param>
///</signature>
if(0===arguments.length)return d.disabledDates?a.extend({},d.disabledDates):d.disabledDates;if(!b)return d.disabledDates=!1,_(),l;if(!(b instanceof Array))throw new TypeError("disabledDates() expects an array parameter");return d.disabledDates=na(b),d.enabledDates=!1,_(),l},l.enabledDates=function(b){
///<signature helpKeyword="$.fn.datetimepicker.enabledDates">
///<summary>Returns an array with the currently set enabled dates on the component.</summary>
///<returns type="array">options.enabledDates</returns>
///</signature>
///<signature>
///<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of options.disabledDates if such exist.</summary>
///<param name="dates" locid="$.fn.datetimepicker.enabledDates_p:dates">Takes an [ string or Date or moment ] of values and allows the user to select only from those days.</param>
///</signature>
if(0===arguments.length)return d.enabledDates?a.extend({},d.enabledDates):d.enabledDates;if(!b)return d.enabledDates=!1,_(),l;if(!(b instanceof Array))throw new TypeError("enabledDates() expects an array parameter");return d.enabledDates=na(b),d.disabledDates=!1,_(),l},l.daysOfWeekDisabled=function(a){if(0===arguments.length)return d.daysOfWeekDisabled.splice(0);if("boolean"==typeof a&&!a)return d.daysOfWeekDisabled=!1,_(),l;if(!(a instanceof Array))throw new TypeError("daysOfWeekDisabled() expects an array parameter");if(d.daysOfWeekDisabled=a.reduce(function(a,b){return b=parseInt(b,10),b>6||0>b||isNaN(b)?a:(-1===a.indexOf(b)&&a.push(b),a)},[]).sort(),d.useCurrent&&!d.keepInvalid){for(var b=0;!R(e,"d");){if(e.add(1,"d"),7===b)throw"Tried 7 times to find a valid date";b++}aa(e)}return _(),l},l.maxDate=function(a){if(0===arguments.length)return d.maxDate?d.maxDate.clone():d.maxDate;if("boolean"==typeof a&&a===!1)return d.maxDate=!1,_(),l;"string"==typeof a&&("now"!==a&&"moment"!==a||(a=y()));var b=da(a);if(!b.isValid())throw new TypeError("maxDate() Could not parse date parameter: "+a);if(d.minDate&&b.isBefore(d.minDate))throw new TypeError("maxDate() date parameter is before options.minDate: "+b.format(i));return d.maxDate=b,d.useCurrent&&!d.keepInvalid&&e.isAfter(a)&&aa(d.maxDate),f.isAfter(b)&&(f=b.clone().subtract(d.stepping,"m")),_(),l},l.minDate=function(a){if(0===arguments.length)return d.minDate?d.minDate.clone():d.minDate;if("boolean"==typeof a&&a===!1)return d.minDate=!1,_(),l;"string"==typeof a&&("now"!==a&&"moment"!==a||(a=y()));var b=da(a);if(!b.isValid())throw new TypeError("minDate() Could not parse date parameter: "+a);if(d.maxDate&&b.isAfter(d.maxDate))throw new TypeError("minDate() date parameter is after options.maxDate: "+b.format(i));return d.minDate=b,d.useCurrent&&!d.keepInvalid&&e.isBefore(a)&&aa(d.minDate),f.isBefore(b)&&(f=b.clone().add(d.stepping,"m")),_(),l},l.defaultDate=function(a){
///<signature helpKeyword="$.fn.datetimepicker.defaultDate">
///<summary>Returns a moment with the options.defaultDate option configuration or false if not set</summary>
///<returns type="Moment">date.clone()</returns>
///</signature>
///<signature>
///<summary>Will set the picker's inital date. If a boolean:false value is passed the options.defaultDate parameter is cleared.</summary>
///<param name="defaultDate" locid="$.fn.datetimepicker.defaultDate_p:defaultDate">Takes a string, Date, moment, boolean:false</param>
///</signature>
if(0===arguments.length)return d.defaultDate?d.defaultDate.clone():d.defaultDate;if(!a)return d.defaultDate=!1,l;"string"==typeof a&&(a="now"===a||"moment"===a?y():y(a));var b=da(a);if(!b.isValid())throw new TypeError("defaultDate() Could not parse date parameter: "+a);if(!R(b))throw new TypeError("defaultDate() date passed is invalid according to component setup validations");return d.defaultDate=b,(d.defaultDate&&d.inline||""===g.val().trim())&&aa(d.defaultDate),l},l.locale=function(a){if(0===arguments.length)return d.locale;if(!b.localeData(a))throw new TypeError("locale() locale "+a+" is not loaded from moment locales!");return d.locale=a,e.locale(d.locale),f.locale(d.locale),i&&pa(),o&&(ba(),ga()),l},l.stepping=function(a){return 0===arguments.length?d.stepping:(a=parseInt(a,10),(isNaN(a)||1>a)&&(a=1),d.stepping=a,l)},l.useCurrent=function(a){var b=["year","month","day","hour","minute"];if(0===arguments.length)return d.useCurrent;if("boolean"!=typeof a&&"string"!=typeof a)throw new TypeError("useCurrent() expects a boolean or string parameter");if("string"==typeof a&&-1===b.indexOf(a.toLowerCase()))throw new TypeError("useCurrent() expects a string parameter of "+b.join(", "));return d.useCurrent=a,l},l.collapse=function(a){if(0===arguments.length)return d.collapse;if("boolean"!=typeof a)throw new TypeError("collapse() expects a boolean parameter");return d.collapse===a?l:(d.collapse=a,o&&(ba(),ga()),l)},l.icons=function(b){if(0===arguments.length)return a.extend({},d.icons);if(!(b instanceof Object))throw new TypeError("icons() expects parameter to be an Object");return a.extend(d.icons,b),o&&(ba(),ga()),l},l.tooltips=function(b){if(0===arguments.length)return a.extend({},d.tooltips);if(!(b instanceof Object))throw new TypeError("tooltips() expects parameter to be an Object");return a.extend(d.tooltips,b),o&&(ba(),ga()),l},l.useStrict=function(a){if(0===arguments.length)return d.useStrict;if("boolean"!=typeof a)throw new TypeError("useStrict() expects a boolean parameter");return d.useStrict=a,l},l.sideBySide=function(a){if(0===arguments.length)return d.sideBySide;if("boolean"!=typeof a)throw new TypeError("sideBySide() expects a boolean parameter");return d.sideBySide=a,o&&(ba(),ga()),l},l.viewMode=function(a){if(0===arguments.length)return d.viewMode;if("string"!=typeof a)throw new TypeError("viewMode() expects a string parameter");if(-1===r.indexOf(a))throw new TypeError("viewMode() parameter must be one of ("+r.join(", ")+") value");return d.viewMode=a,k=Math.max(r.indexOf(a),p),L(),l},l.toolbarPlacement=function(a){if(0===arguments.length)return d.toolbarPlacement;if("string"!=typeof a)throw new TypeError("toolbarPlacement() expects a string parameter");if(-1===u.indexOf(a))throw new TypeError("toolbarPlacement() parameter must be one of ("+u.join(", ")+") value");return d.toolbarPlacement=a,o&&(ba(),ga()),l},l.widgetPositioning=function(b){if(0===arguments.length)return a.extend({},d.widgetPositioning);if("[object Object]"!=={}.toString.call(b))throw new TypeError("widgetPositioning() expects an object variable");if(b.horizontal){if("string"!=typeof b.horizontal)throw new TypeError("widgetPositioning() horizontal variable must be a string");if(b.horizontal=b.horizontal.toLowerCase(),-1===t.indexOf(b.horizontal))throw new TypeError("widgetPositioning() expects horizontal parameter to be one of ("+t.join(", ")+")");d.widgetPositioning.horizontal=b.horizontal}if(b.vertical){if("string"!=typeof b.vertical)throw new TypeError("widgetPositioning() vertical variable must be a string");if(b.vertical=b.vertical.toLowerCase(),-1===s.indexOf(b.vertical))throw new TypeError("widgetPositioning() expects vertical parameter to be one of ("+s.join(", ")+")");d.widgetPositioning.vertical=b.vertical}return _(),l},l.calendarWeeks=function(a){if(0===arguments.length)return d.calendarWeeks;if("boolean"!=typeof a)throw new TypeError("calendarWeeks() expects parameter to be a boolean value");return d.calendarWeeks=a,_(),l},l.showTodayButton=function(a){if(0===arguments.length)return d.showTodayButton;if("boolean"!=typeof a)throw new TypeError("showTodayButton() expects a boolean parameter");return d.showTodayButton=a,o&&(ba(),ga()),l},l.showClear=function(a){if(0===arguments.length)return d.showClear;if("boolean"!=typeof a)throw new TypeError("showClear() expects a boolean parameter");return d.showClear=a,o&&(ba(),ga()),l},l.widgetParent=function(b){if(0===arguments.length)return d.widgetParent;if("string"==typeof b&&(b=a(b)),null!==b&&"string"!=typeof b&&!(b instanceof a))throw new TypeError("widgetParent() expects a string or a jQuery object parameter");return d.widgetParent=b,o&&(ba(),ga()),l},l.keepOpen=function(a){if(0===arguments.length)return d.keepOpen;if("boolean"!=typeof a)throw new TypeError("keepOpen() expects a boolean parameter");return d.keepOpen=a,l},l.focusOnShow=function(a){if(0===arguments.length)return d.focusOnShow;if("boolean"!=typeof a)throw new TypeError("focusOnShow() expects a boolean parameter");return d.focusOnShow=a,l},l.inline=function(a){if(0===arguments.length)return d.inline;if("boolean"!=typeof a)throw new TypeError("inline() expects a boolean parameter");return d.inline=a,l},l.clear=function(){return ca(),l},l.keyBinds=function(a){return 0===arguments.length?d.keyBinds:(d.keyBinds=a,l)},l.getMoment=function(a){return y(a)},l.debug=function(a){if("boolean"!=typeof a)throw new TypeError("debug() expects a boolean parameter");return d.debug=a,l},l.allowInputToggle=function(a){if(0===arguments.length)return d.allowInputToggle;if("boolean"!=typeof a)throw new TypeError("allowInputToggle() expects a boolean parameter");return d.allowInputToggle=a,l},l.showClose=function(a){if(0===arguments.length)return d.showClose;if("boolean"!=typeof a)throw new TypeError("showClose() expects a boolean parameter");return d.showClose=a,l},l.keepInvalid=function(a){if(0===arguments.length)return d.keepInvalid;if("boolean"!=typeof a)throw new TypeError("keepInvalid() expects a boolean parameter");return d.keepInvalid=a,l},l.datepickerInput=function(a){if(0===arguments.length)return d.datepickerInput;if("string"!=typeof a)throw new TypeError("datepickerInput() expects a string parameter");return d.datepickerInput=a,l},l.parseInputDate=function(a){if(0===arguments.length)return d.parseInputDate;if("function"!=typeof a)throw new TypeError("parseInputDate() sholud be as function");return d.parseInputDate=a,l},l.disabledTimeIntervals=function(b){
///<signature helpKeyword="$.fn.datetimepicker.disabledTimeIntervals">
///<summary>Returns an array with the currently set disabled dates on the component.</summary>
///<returns type="array">options.disabledTimeIntervals</returns>
///</signature>
///<signature>
///<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of
///options.enabledDates if such exist.</summary>
///<param name="dates" locid="$.fn.datetimepicker.disabledTimeIntervals_p:dates">Takes an [ string or Date or moment ] of values and allows the user to select only from those days.</param>
///</signature>
if(0===arguments.length)return d.disabledTimeIntervals?a.extend({},d.disabledTimeIntervals):d.disabledTimeIntervals;if(!b)return d.disabledTimeIntervals=!1,_(),l;if(!(b instanceof Array))throw new TypeError("disabledTimeIntervals() expects an array parameter");return d.disabledTimeIntervals=b,_(),l},l.disabledHours=function(b){
///<signature helpKeyword="$.fn.datetimepicker.disabledHours">
///<summary>Returns an array with the currently set disabled hours on the component.</summary>
///<returns type="array">options.disabledHours</returns>
///</signature>
///<signature>
///<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of
///options.enabledHours if such exist.</summary>
///<param name="hours" locid="$.fn.datetimepicker.disabledHours_p:hours">Takes an [ int ] of values and disallows the user to select only from those hours.</param>
///</signature>
if(0===arguments.length)return d.disabledHours?a.extend({},d.disabledHours):d.disabledHours;if(!b)return d.disabledHours=!1,_(),l;if(!(b instanceof Array))throw new TypeError("disabledHours() expects an array parameter");if(d.disabledHours=oa(b),d.enabledHours=!1,d.useCurrent&&!d.keepInvalid){for(var c=0;!R(e,"h");){if(e.add(1,"h"),24===c)throw"Tried 24 times to find a valid date";c++}aa(e)}return _(),l},l.enabledHours=function(b){
///<signature helpKeyword="$.fn.datetimepicker.enabledHours">
///<summary>Returns an array with the currently set enabled hours on the component.</summary>
///<returns type="array">options.enabledHours</returns>
///</signature>
///<signature>
///<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of options.disabledHours if such exist.</summary>
///<param name="hours" locid="$.fn.datetimepicker.enabledHours_p:hours">Takes an [ int ] of values and allows the user to select only from those hours.</param>
///</signature>
if(0===arguments.length)return d.enabledHours?a.extend({},d.enabledHours):d.enabledHours;if(!b)return d.enabledHours=!1,_(),l;if(!(b instanceof Array))throw new TypeError("enabledHours() expects an array parameter");if(d.enabledHours=oa(b),d.disabledHours=!1,d.useCurrent&&!d.keepInvalid){for(var c=0;!R(e,"h");){if(e.add(1,"h"),24===c)throw"Tried 24 times to find a valid date";c++}aa(e)}return _(),l},/**
         * Returns the component's model current viewDate, a moment object or null if not set. Passing a null value unsets the components model current moment. Parsing of the newDate parameter is made using moment library with the options.format and options.useStrict components configuration.
         * @param {Takes string, viewDate, moment, null parameter.} newDate
         * @returns {viewDate.clone()}
         */
l.viewDate=function(a){if(0===arguments.length)return f.clone();if(!a)return f=e.clone(),l;if(!("string"==typeof a||b.isMoment(a)||a instanceof Date))throw new TypeError("viewDate() parameter must be one of [string, moment or Date]");return f=da(a),K(),l},c.is("input"))g=c;else if(g=c.find(d.datepickerInput),0===g.length)g=c.find("input");else if(!g.is("input"))throw new Error('CSS class "'+d.datepickerInput+'" cannot be applied to non input element');if(c.hasClass("input-group")&&(
// in case there is more then one 'input-group-addon' Issue #48
n=0===c.find(".datepickerbutton").length?c.find(".input-group-addon"):c.find(".datepickerbutton")),!d.inline&&!g.is("input"))throw new Error("Could not initialize DateTimePicker without an input element");
// Set defaults for date here now instead of in var declaration
return e=y(),f=e.clone(),a.extend(!0,d,H()),l.options(d),pa(),la(),g.prop("disabled")&&l.disable(),g.is("input")&&0!==g.val().trim().length?aa(da(g.val().trim())):d.defaultDate&&void 0===g.attr("placeholder")&&aa(d.defaultDate),d.inline&&ga(),l};/********************************************************************************
     *
     * jQuery plugin constructor and defaults object
     *
     ********************************************************************************/
/**
    * See (http://jquery.com/).
    * @name jQuery
    * @class
    * See the jQuery Library  (http://jquery.com/) for full details.  This just
    * documents the function and classes that are added to jQuery by this plug-in.
    */
/**
     * See (http://jquery.com/)
     * @name fn
     * @class
     * See the jQuery Library  (http://jquery.com/) for full details.  This just
     * documents the function and classes that are added to jQuery by this plug-in.
     * @memberOf jQuery
     */
/**
     * Show comments
     * @class datetimepicker
     * @memberOf jQuery.fn
     */
a.fn.datetimepicker=function(b){b=b||{};var d,e=Array.prototype.slice.call(arguments,1),f=!0,g=["destroy","hide","show","toggle"];if("object"==typeof b)return this.each(function(){var d=a(this);d.data("DateTimePicker")||(b=a.extend(!0,{},a.fn.datetimepicker.defaults,b),d.data("DateTimePicker",c(d,b)))});if("string"==typeof b)return this.each(function(){var c=a(this),g=c.data("DateTimePicker");if(!g)throw new Error('bootstrap-datetimepicker("'+b+'") method was called on an element that is not using DateTimePicker');d=g[b].apply(g,e),f=d===g}),f||a.inArray(b,g)>-1?this:d;throw new TypeError("Invalid arguments for DateTimePicker: "+b)},a.fn.datetimepicker.defaults={timeZone:"",format:!1,dayViewHeaderFormat:"MMMM YYYY",extraFormats:!1,stepping:1,minDate:!1,maxDate:!1,useCurrent:!0,collapse:!0,locale:b.locale(),defaultDate:!1,disabledDates:!1,enabledDates:!1,icons:{time:"glyphicon glyphicon-time",date:"glyphicon glyphicon-calendar",up:"glyphicon glyphicon-chevron-up",down:"glyphicon glyphicon-chevron-down",previous:"glyphicon glyphicon-chevron-left",next:"glyphicon glyphicon-chevron-right",today:"glyphicon glyphicon-screenshot",clear:"glyphicon glyphicon-trash",close:"glyphicon glyphicon-remove"},tooltips:{today:"Go to today",clear:"Clear selection",close:"Close the picker",selectMonth:"Select Month",prevMonth:"Previous Month",nextMonth:"Next Month",selectYear:"Select Year",prevYear:"Previous Year",nextYear:"Next Year",selectDecade:"Select Decade",prevDecade:"Previous Decade",nextDecade:"Next Decade",prevCentury:"Previous Century",nextCentury:"Next Century",pickHour:"Pick Hour",incrementHour:"Increment Hour",decrementHour:"Decrement Hour",pickMinute:"Pick Minute",incrementMinute:"Increment Minute",decrementMinute:"Decrement Minute",pickSecond:"Pick Second",incrementSecond:"Increment Second",decrementSecond:"Decrement Second",togglePeriod:"Toggle Period",selectTime:"Select Time"},useStrict:!1,sideBySide:!1,daysOfWeekDisabled:!1,calendarWeeks:!1,viewMode:"days",toolbarPlacement:"default",showTodayButton:!1,showClear:!1,showClose:!1,widgetPositioning:{horizontal:"auto",vertical:"auto"},widgetParent:null,ignoreReadonly:!1,keepOpen:!1,focusOnShow:!0,inline:!1,keepInvalid:!1,datepickerInput:".datepickerinput",keyBinds:{up:function(a){if(a){var b=this.date()||this.getMoment();a.find(".datepicker").is(":visible")?this.date(b.clone().subtract(7,"d")):this.date(b.clone().add(this.stepping(),"m"))}},down:function(a){if(!a)return void this.show();var b=this.date()||this.getMoment();a.find(".datepicker").is(":visible")?this.date(b.clone().add(7,"d")):this.date(b.clone().subtract(this.stepping(),"m"))},"control up":function(a){if(a){var b=this.date()||this.getMoment();a.find(".datepicker").is(":visible")?this.date(b.clone().subtract(1,"y")):this.date(b.clone().add(1,"h"))}},"control down":function(a){if(a){var b=this.date()||this.getMoment();a.find(".datepicker").is(":visible")?this.date(b.clone().add(1,"y")):this.date(b.clone().subtract(1,"h"))}},left:function(a){if(a){var b=this.date()||this.getMoment();a.find(".datepicker").is(":visible")&&this.date(b.clone().subtract(1,"d"))}},right:function(a){if(a){var b=this.date()||this.getMoment();a.find(".datepicker").is(":visible")&&this.date(b.clone().add(1,"d"))}},pageUp:function(a){if(a){var b=this.date()||this.getMoment();a.find(".datepicker").is(":visible")&&this.date(b.clone().subtract(1,"M"))}},pageDown:function(a){if(a){var b=this.date()||this.getMoment();a.find(".datepicker").is(":visible")&&this.date(b.clone().add(1,"M"))}},enter:function(){this.hide()},escape:function(){this.hide()},
//tab: function (widget) { //this break the flow of the form. disabling for now
//    var toggle = widget.find('.picker-switch a[data-action="togglePicker"]');
//    if(toggle.length > 0) toggle.click();
//},
"control space":function(a){a.find(".timepicker").is(":visible")&&a.find('.btn[data-action="togglePeriod"]').click()},t:function(){this.date(this.getMoment())},"delete":function(){this.clear()}},debug:!1,allowInputToggle:!1,disabledTimeIntervals:!1,disabledHours:!1,enabledHours:!1,viewDate:!1}, true&&(module.exports=a.fn.datetimepicker)});

/***/ },

/***/ "../smapServer/WebContent/js/libs/bootstrap-toggle.min.js"
/*!****************************************************************!*\
  !*** ../smapServer/WebContent/js/libs/bootstrap-toggle.min.js ***!
  \****************************************************************/
() {

/*! ========================================================================
 * Bootstrap Toggle: bootstrap-toggle.js v2.2.0
 * http://www.bootstraptoggle.com
 * ========================================================================
 * Copyright 2014 Min Hur, The New York Times Company
 * Licensed under MIT
 * ======================================================================== */
+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.toggle"),f="object"==typeof b&&b;e||d.data("bs.toggle",e=new c(this,f)),"string"==typeof b&&e[b]&&e[b]()})}var c=function(b,c){this.$element=a(b),this.options=a.extend({},this.defaults(),c),this.render()};c.VERSION="2.2.0",c.DEFAULTS={on:"On",off:"Off",onstyle:"primary",offstyle:"default",size:"normal",style:"",width:null,height:null},c.prototype.defaults=function(){return{on:this.$element.attr("data-on")||c.DEFAULTS.on,off:this.$element.attr("data-off")||c.DEFAULTS.off,onstyle:this.$element.attr("data-onstyle")||c.DEFAULTS.onstyle,offstyle:this.$element.attr("data-offstyle")||c.DEFAULTS.offstyle,size:this.$element.attr("data-size")||c.DEFAULTS.size,style:this.$element.attr("data-style")||c.DEFAULTS.style,width:this.$element.attr("data-width")||c.DEFAULTS.width,height:this.$element.attr("data-height")||c.DEFAULTS.height}},c.prototype.render=function(){this._onstyle="btn-"+this.options.onstyle,this._offstyle="btn-"+this.options.offstyle;var b="large"===this.options.size?"btn-lg":"small"===this.options.size?"btn-sm":"mini"===this.options.size?"btn-xs":"",c=a('<label class="btn">').html(this.options.on).addClass(this._onstyle+" "+b),d=a('<label class="btn">').html(this.options.off).addClass(this._offstyle+" "+b+" active"),e=a('<span class="toggle-handle btn btn-default">').addClass(b),f=a('<div class="toggle-group">').append(c,d,e),g=a('<div class="toggle btn" data-toggle="toggle">').addClass(this.$element.prop("checked")?this._onstyle:this._offstyle+" off").addClass(b).addClass(this.options.style);this.$element.wrap(g),a.extend(this,{$toggle:this.$element.parent(),$toggleOn:c,$toggleOff:d,$toggleGroup:f}),this.$toggle.append(f);var h=this.options.width||Math.max(c.outerWidth(),d.outerWidth())+e.outerWidth()/2,i=this.options.height||Math.max(c.outerHeight(),d.outerHeight());c.addClass("toggle-on"),d.addClass("toggle-off"),this.$toggle.css({width:h,height:i}),this.options.height&&(c.css("line-height",c.height()+"px"),d.css("line-height",d.height()+"px")),this.update(!0),this.trigger(!0)},c.prototype.toggle=function(){this.$element.prop("checked")?this.off():this.on()},c.prototype.on=function(a){return this.$element.prop("disabled")?!1:(this.$toggle.removeClass(this._offstyle+" off").addClass(this._onstyle),this.$element.prop("checked",!0),void(a||this.trigger()))},c.prototype.off=function(a){return this.$element.prop("disabled")?!1:(this.$toggle.removeClass(this._onstyle).addClass(this._offstyle+" off"),this.$element.prop("checked",!1),void(a||this.trigger()))},c.prototype.enable=function(){this.$toggle.removeAttr("disabled"),this.$element.prop("disabled",!1)},c.prototype.disable=function(){this.$toggle.attr("disabled","disabled"),this.$element.prop("disabled",!0)},c.prototype.update=function(a){this.$element.prop("disabled")?this.disable():this.enable(),this.$element.prop("checked")?this.on(a):this.off(a)},c.prototype.trigger=function(b){this.$element.off("change.bs.toggle"),b||this.$element.change(),this.$element.on("change.bs.toggle",a.proxy(function(){this.update()},this))},c.prototype.destroy=function(){this.$element.off("change.bs.toggle"),this.$toggleGroup.remove(),this.$element.removeData("bs.toggle"),this.$element.unwrap()};var d=a.fn.bootstrapToggle;a.fn.bootstrapToggle=b,a.fn.bootstrapToggle.Constructor=c,a.fn.toggle.noConflict=function(){return a.fn.bootstrapToggle=d,this},a(function(){a("input[type=checkbox][data-toggle^=toggle]").bootstrapToggle()}),a(document).on("click.bs.toggle","div[data-toggle^=toggle]",function(b){var c=a(this).find("input[type=checkbox]");c.bootstrapToggle("toggle"),b.preventDefault()})}(jQuery);
//# sourceMappingURL=bootstrap-toggle.min.js.map

/***/ },

/***/ "../smapServer/WebContent/js/libs/bootstrap.file-input.js"
/*!****************************************************************!*\
  !*** ../smapServer/WebContent/js/libs/bootstrap.file-input.js ***!
  \****************************************************************/
() {

/*
  Bootstrap - File Input
  ======================

  This is meant to convert all file input tags into a set of elements that displays consistently in all browsers.

  Converts all
  <input type="file">
  into Bootstrap buttons
  <a class="btn">Browse</a>

*/
(function($) {

$.fn.bootstrapFileInput = function() {

  this.each(function(i,elem){

    var $elem = $(elem);

    // Maybe some fields don't need to be standardized.
    if (typeof $elem.attr('data-bfi-disabled') != 'undefined') {
      return;
    }

    // Set the word to be displayed on the button
    var buttonWord = localise.set["ar_af"];
    //var buttonWord = 'Browse';

    //if (typeof $elem.attr('title') != 'undefined') {
    //  buttonWord = $elem.attr('title');
    //}

    var className = '';

    if (!!$elem.attr('class')) {
      className = ' ' + $elem.attr('class');
    }

    // Now we're going to wrap that input field with a Bootstrap button.
    // The input will actually still be there, it will just be float above and transparent (done with the CSS).
    buttonWord = '<i class="glyphicon glyphicon-plus"></i>' + '<span>' + buttonWord + '</span>';
    $elem.wrap('<a class="file-input-wrapper btn btn-success ' + className + '"></a>').parent().prepend(buttonWord);
  })

  // After we have found all of the file inputs let's apply a listener for tracking the mouse movement.
  // This is important because the in order to give the illusion that this is a button in FF we actually need to move the button from the file input under the cursor. Ugh.
  .promise().done( function(){

    // As the cursor moves over our new Bootstrap button we need to adjust the position of the invisible file input Browse button to be under the cursor.
    // This gives us the pointer cursor that FF denies us
    $('.file-input-wrapper').mousemove(function(cursor) {

      var input, wrapper,
        wrapperX, wrapperY,
        inputWidth, inputHeight,
        cursorX, cursorY;

      // This wrapper element (the button surround this file input)
      wrapper = $(this);
      // The invisible file input element
      input = wrapper.find("input");
      // The left-most position of the wrapper
      wrapperX = wrapper.offset().left;
      // The top-most position of the wrapper
      wrapperY = wrapper.offset().top;
      // The with of the browsers input field
      inputWidth= input.width();
      // The height of the browsers input field
      inputHeight= input.height();
      //The position of the cursor in the wrapper
      cursorX = cursor.pageX;
      cursorY = cursor.pageY;

      //The positions we are to move the invisible file input
      // The 20 at the end is an arbitrary number of pixels that we can shift the input such that cursor is not pointing at the end of the Browse button but somewhere nearer the middle
      moveInputX = cursorX - wrapperX - inputWidth + 20;
      // Slides the invisible input Browse button to be positioned middle under the cursor
      moveInputY = cursorY- wrapperY - (inputHeight/2);

      // Apply the positioning styles to actually move the invisible file input
      input.css({
        left:moveInputX,
        top:moveInputY
      });
    });

    $('body').on('change', '.file-input-wrapper input[type=file]', function(){

      var fileName,
      		fileDesc,
      		$this = $(this),
      		$target = $('.upload_file_msg');
     
      if ($this.prop('files') && $this.prop('files').length > 1) {
    	  fileDesc = '';
    	  for(i = 0; i < $this.prop('files').length; i++) {
    		  fileName = $this[0].files[i].name;
    		  fileName = fileName.substring(fileName.lastIndexOf('\\') + 1, fileName.length);
    		  if(i > 0) {
    			  fileDesc += ', ';
    		  }
    		  fileDesc += fileName;
    	  }
      }
      else {
    	fileName = $this.val();
        fileName = fileName.substring(fileName.lastIndexOf('\\') + 1, fileName.length);
        fileDesc = fileName;
      }

      // Don't try to show the name if there is none
      if (!fileDesc) {
          $target.addClass('alert-success').removeClass('alert-danger').html("").val("");
	      $('.submitFiles').addClass('disabled');
          return;
      }
      $('.submitFiles').removeClass('disabled');
      $target.addClass('alert-success').removeClass('alert-danger').html(fileDesc).val(fileDesc);

      var w = 0;
      $('.progress-bar').css('width', w+'%').attr('aria-valuenow', w); 
   
    });

  });

};

// Add the styles before the first stylesheet
// This ensures they can be easily overridden with developer styles
var cssHtml = '<style>'+
  '.file-input-wrapper { overflow: hidden; position: relative; cursor: pointer; z-index: 1; }'+
  '.file-input-wrapper input[type=file], .file-input-wrapper input[type=file]:focus, .file-input-wrapper input[type=file]:hover { position: absolute; top: 0; left: 0; cursor: pointer; opacity: 0; filter: alpha(opacity=0); z-index: 99; outline: 0; }'+
  '.file-input-name { margin-left: 8px; }'+
  '</style>';
$('link[rel=stylesheet]').eq(0).before(cssHtml);

})(jQuery);

/***/ },

/***/ "../smapServer/WebContent/js/libs/commonReportFunctions.js"
/*!*****************************************************************!*\
  !*** ../smapServer/WebContent/js/libs/commonReportFunctions.js ***!
  \*****************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addAnchors: () => (/* binding */ addAnchors),
/* harmony export */   getDisplayDescription: () => (/* binding */ getDisplayDescription),
/* harmony export */   getMedia: () => (/* binding */ getMedia)
/* harmony export */ });
/* harmony import */ var _app_localise__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../app/localise */ "../smapServer/WebContent/js/app/localise.js");
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/


/*
 * The description should always be encoded / not used as html therefore do not encode
 */


function getDisplayDescription(fn, reportType, survey, question, group, option, qtype, 
		date_question, start, end, interval, units, filter) {
	
	var txt = [],
		idx = -1,
		msg;

	if(typeof question === "undefined" || question === "None") {
		txt[++idx] = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_sl"];
	} else {
		if(reportType === "map") {
			if(fn === "ocha") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_ocha_map"];
			} else if(fn === "percent") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_percent_map"];
			} else if(fn === "average") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_average_map"];
			} else if(fn === "count") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_count_map"];
			} else if(fn === "total") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_total_map"];
			} else if(fn === "none") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_none_map"];
			}
			msg = msg.replace('%s1', option);
		} else {
			if(fn === "ocha") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_ocha_table"];
			} else if(fn === "percent") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_percent_table"];
			} else if(fn === "average") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_average_table"];
			} else if(fn === "count") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_count_table"];
			} else if(fn === "total") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_total_table"];
			} else if(fn === "none") {
				msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_none_table"];
			}

		}
		msg = msg.replace('%s2', question);
		msg = msg.replace('%s3', survey);
		txt[++idx] = msg;
	}

	
	if(units) {
		msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_units"];
		msg = msg.replace("%s1", units);
		txt[++idx] = ' ';
		txt[++idx] = msg;
	}

	if(typeof group !== "undefined") {
		if(typeof interval !== "undefined") {
			msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_group_interval"];
			msg = msg.replace("%s2", interval);
		} else {
			msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_group"];
		}
		msg = msg.replace("%s1", group);
		txt[++idx] = ' ';
		txt[++idx] = msg;
	} else if(typeof interval !== "undefined"){
		msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_interval"];
		msg = msg.replace("%s1", interval);
		txt[++idx] = ' ';
		txt[++idx] = msg;
	}
	
	if(typeof end === "undefined") {
		end = ""
	}
	if(typeof date_question !== "undefined" && typeof start !== "undefined") {
		txt[++idx] = " (";
		txt[++idx] = date_question;
		txt[++idx] = ": ";
		txt[++idx] = start;
		txt[++idx] = " - ";
		txt[++idx] = end;
		txt[++idx] = ")";
	}

	// Add filter
	if(filter) {
		var filterObj = JSON.parse(filter);
		msg = _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_dd_where"];
		msg.replace("%s1", filterObj.qName);
		msg.replace("%s2", filterObj.value);
		txt[++idx] = ' ';
		txt[++idx] = msg;

	}
	
	return txt.join('');
}

/*
 * Add html references to media files
 * Return all properties as an Array
 * Deprecate this approach and progressively replace with processMedia()
 */
function addAnchors (property, minsize) {
	var output = [],
		media,
		i,
		style = '';

	if(property && typeof property.type !== "undefined") {
		// Geospatial
		return [ property.coordinates ];

	}

	if( Object.prototype.toString.call(property) !== '[object Array]' ) {
		property = [ property ];
	}
	
	for(i = 0; i < property.length; i++) {
	    media = getMedia(property[i]);
	    
	    if(typeof media !== "undefined") {  // Add links to media files
			if(media.supported) {
                if (media.type === "audio") {
                    if (minsize) {
                        style = ' style="width:75px;"';
                    }
                    output[i] = '<audio controls' + style + '><source src="' + media.url
                        + '" type="' + media.source_type + '"/>'
                        + 'Your browser does not support this audio type'
                        + '</audio>';
                } else if (media.type === "video") {
                    if (minsize) {
                        style = ' style="width:100px;"';
                    }
                    output[i] = '<video controls' + style +
                        (minsize ? 'width="75px" height="100px"' : '')
                        + '><source src="' + media.url
                        + '" type="' + media.source_type + '">'
                        + 'Your browser does not support this video type'
                        + '</video>';
                } else {
                    style = (media.thumbNail == '/fieldAnalysis/img/link.png') ? "width:32px;" : "width:100%;";
                    output[i] = '<a href="' + media.url
                        + '" target="_blank"><img style="' + style + '" src="'
                        + (minsize ? media.thumbNail : media.url)
						+ '" alt="Picture"></a>';
                }
            } else {
                output[i] = '<a href="' + media.url
                    + '" download style="color:#0000FF;">' + _app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_download"] + '</a>';
			}
	
		} else {
		    if (typeof property[i] === "object") {      // From: https://stackoverflow.com/questions/11182924/how-to-check-if-javascript-object-is-json
				output[i] = JSON.stringify(property[i]);
				if(output[i] === "{}") {
					output[i] = "";
				}
		    } else {
			    output[i] = property[i];
		    }

		}
	} 
	
	return output;
	
}

/*
 * Get an object with the media details for the property
 */
function getMedia(property) {
	
	var idx, name, ext, urlBase, thumbNail, type,
		media;
	
	if(typeof property === "string" && (property.indexOf("//") === 0 || property.indexOf("http") === 0)) {  // Add links to media files
		
		if(property.indexOf("//") === 0) {
			property = "https:" + property;
		}
		// Get name, type, urlBase and thumbName from the input url

		idx = property.lastIndexOf("/");
		name = property.substring(idx+1);
		urlBase = property.substring(0, idx+1);
		idx = name.lastIndexOf(".");
		ext = name.substring(idx+1).toLowerCase();
		thumbNail = urlBase + "thumbs/" + name + ".jpg";
		
		// Create a media object
		media = {};
		media.name = name;
		media.supported = true;
		if(ext === "jpg" || ext === "png" || ext === "gif" || ext === "jpeg" || ext === "ico" || ext === "webp") {
			media.type = "image";
			media.url = property; 
			media.thumbNail = thumbNail;
		} else if(ext === "mp4" || ext === "3gp" || ext === "flv" || ext === "m4p" || ext === "mov") {
            if(ext == "mp4") {
                media.source_type = "video/mp4";
            } else  if(ext == "3gp") {
                media.supported = false;
                media.source_type = "video/3gp";
            } else  if(ext == "flv") {
                media.supported = false;
                media.source_type = "video/x-flv";
            } else  if(ext == "mov") {
                media.supported = false;
                media.source_type = "video/quicktime";
            }
			media.type = "video";
			media.url = property;
			media.thumbNail = thumbNail;
		} else if(ext === "mp3" || ext === "amr" || ext === "3ga" || ext === "m4a" || ext === "ogg" || ext === "wav") {
			if(ext == "m4a") {
				media.source_type = "audio/mp4";
			} else if(ext == "mp3") {
                media.source_type = "audio/mp3";
            } else if(ext == "amr") {
				media.supported = false;
                media.source_type = "audio/amr";
            } else if(ext == "ogg") {
                media.source_type = "audio/ogg";
            } else if(ext == "wav") {
                media.source_type = "audio/wav";
            }
			media.type = "audio";
			media.url = property;		// Don't convert audio files
			media.thumbNail = "/app/fieldAnalysis/img/audio-icon.png"
		} else {
			media.type = "unknown";
			media.url = property; 
			media.thumbNail = "/app/fieldAnalysis/img/link.png"
		}


	}
	
	return media;
		
}




/***/ },

/***/ "../smapServer/WebContent/js/libs/jquery-qrcode-0.14.0.min.js"
/*!********************************************************************!*\
  !*** ../smapServer/WebContent/js/libs/jquery-qrcode-0.14.0.min.js ***!
  \********************************************************************/
(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! jquery-qrcode v0.14.0 - https://larsjung.de/jquery-qrcode/ */
!function(r){"use strict";function t(t,e,n,o){function a(r,t){return r-=o,t-=o,0>r||r>=c||0>t||t>=c?!1:f.isDark(r,t)}function i(r,t,e,n){var o=u.isDark,a=1/l;u.isDark=function(i,u){var f=u*a,c=i*a,l=f+a,g=c+a;return o(i,u)&&(r>l||f>e||t>g||c>n)}}var u={},f=r(n,e);f.addData(t),f.make(),o=o||0;var c=f.getModuleCount(),l=f.getModuleCount()+2*o;return u.text=t,u.level=e,u.version=n,u.moduleCount=l,u.isDark=a,u.addBlank=i,u}function e(r,e,n,o,a){n=Math.max(1,n||1),o=Math.min(40,o||40);for(var i=n;o>=i;i+=1)try{return t(r,e,i,a)}catch(u){}}function n(r,t,e){var n=e.size,o="bold "+e.mSize*n+"px "+e.fontname,a=w("<canvas/>")[0].getContext("2d");a.font=o;var i=a.measureText(e.label).width,u=e.mSize,f=i/n,c=(1-f)*e.mPosX,l=(1-u)*e.mPosY,g=c+f,s=l+u,v=.01;1===e.mode?r.addBlank(0,l-v,n,s+v):r.addBlank(c-v,l-v,g+v,s+v),t.fillStyle=e.fontcolor,t.font=o,t.fillText(e.label,c*n,l*n+.75*e.mSize*n)}function o(r,t,e){var n=e.size,o=e.image.naturalWidth||1,a=e.image.naturalHeight||1,i=e.mSize,u=i*o/a,f=(1-u)*e.mPosX,c=(1-i)*e.mPosY,l=f+u,g=c+i,s=.01;3===e.mode?r.addBlank(0,c-s,n,g+s):r.addBlank(f-s,c-s,l+s,g+s),t.drawImage(e.image,f*n,c*n,u*n,i*n)}function a(r,t,e){w(e.background).is("img")?t.drawImage(e.background,0,0,e.size,e.size):e.background&&(t.fillStyle=e.background,t.fillRect(e.left,e.top,e.size,e.size));var a=e.mode;1===a||2===a?n(r,t,e):(3===a||4===a)&&o(r,t,e)}function i(r,t,e,n,o,a,i,u){r.isDark(i,u)&&t.rect(n,o,a,a)}function u(r,t,e,n,o,a,i,u,f,c){i?r.moveTo(t+a,e):r.moveTo(t,e),u?(r.lineTo(n-a,e),r.arcTo(n,e,n,o,a)):r.lineTo(n,e),f?(r.lineTo(n,o-a),r.arcTo(n,o,t,o,a)):r.lineTo(n,o),c?(r.lineTo(t+a,o),r.arcTo(t,o,t,e,a)):r.lineTo(t,o),i?(r.lineTo(t,e+a),r.arcTo(t,e,n,e,a)):r.lineTo(t,e)}function f(r,t,e,n,o,a,i,u,f,c){i&&(r.moveTo(t+a,e),r.lineTo(t,e),r.lineTo(t,e+a),r.arcTo(t,e,t+a,e,a)),u&&(r.moveTo(n-a,e),r.lineTo(n,e),r.lineTo(n,e+a),r.arcTo(n,e,n-a,e,a)),f&&(r.moveTo(n-a,o),r.lineTo(n,o),r.lineTo(n,o-a),r.arcTo(n,o,n-a,o,a)),c&&(r.moveTo(t+a,o),r.lineTo(t,o),r.lineTo(t,o-a),r.arcTo(t,o,t+a,o,a))}function c(r,t,e,n,o,a,i,c){var l=r.isDark,g=n+a,s=o+a,v=e.radius*a,h=i-1,d=i+1,w=c-1,m=c+1,y=l(i,c),T=l(h,w),p=l(h,c),B=l(h,m),A=l(i,m),E=l(d,m),k=l(d,c),M=l(d,w),C=l(i,w);y?u(t,n,o,g,s,v,!p&&!C,!p&&!A,!k&&!A,!k&&!C):f(t,n,o,g,s,v,p&&C&&T,p&&A&&B,k&&A&&E,k&&C&&M)}function l(r,t,e){var n,o,a=r.moduleCount,u=e.size/a,f=i;for(e.radius>0&&e.radius<=.5&&(f=c),t.beginPath(),n=0;a>n;n+=1)for(o=0;a>o;o+=1){var l=e.left+o*u,g=e.top+n*u,s=u;f(r,t,e,l,g,s,n,o)}if(w(e.fill).is("img")){t.strokeStyle="rgba(0,0,0,0.5)",t.lineWidth=2,t.stroke();var v=t.globalCompositeOperation;t.globalCompositeOperation="destination-out",t.fill(),t.globalCompositeOperation=v,t.clip(),t.drawImage(e.fill,0,0,e.size,e.size),t.restore()}else t.fillStyle=e.fill,t.fill()}function g(r,t){var n=e(t.text,t.ecLevel,t.minVersion,t.maxVersion,t.quiet);if(!n)return null;var o=w(r).data("qrcode",n),i=o[0].getContext("2d");return a(n,i,t),l(n,i,t),o}function s(r){var t=w("<canvas/>").attr("width",r.size).attr("height",r.size);return g(t,r)}function v(r){return w("<img/>").attr("src",s(r)[0].toDataURL("image/png"))}function h(r){var t=e(r.text,r.ecLevel,r.minVersion,r.maxVersion,r.quiet);if(!t)return null;var n,o,a=r.size,i=r.background,u=Math.floor,f=t.moduleCount,c=u(a/f),l=u(.5*(a-c*f)),g={position:"relative",left:0,top:0,padding:0,margin:0,width:a,height:a},s={position:"absolute",padding:0,margin:0,width:c,height:c,"background-color":r.fill},v=w("<div/>").data("qrcode",t).css(g);for(i&&v.css("background-color",i),n=0;f>n;n+=1)for(o=0;f>o;o+=1)t.isDark(n,o)&&w("<div/>").css(s).css({left:l+o*c,top:l+n*c}).appendTo(v);return v}function d(r){return m&&"canvas"===r.render?s(r):m&&"image"===r.render?v(r):h(r)}var w=window.jQuery,m=function(){var r=document.createElement("canvas");return!(!r.getContext||!r.getContext("2d"))}(),y={render:"canvas",minVersion:1,maxVersion:40,ecLevel:"L",left:0,top:0,size:200,fill:"#000",background:null,text:"no text",radius:0,quiet:0,mode:0,mSize:.1,mPosX:.5,mPosY:.5,label:"no label",fontname:"sans",fontcolor:"#000",image:null};w.fn.qrcode=function(r){var t=w.extend({},y,r);return this.each(function(r,e){"canvas"===e.nodeName.toLowerCase()?g(e,t):w(e).append(d(t))})}}(function(){var r=function(){function r(t,e){if("undefined"==typeof t.length)throw new Error(t.length+"/"+e);var n=function(){for(var r=0;r<t.length&&0==t[r];)r+=1;for(var n=new Array(t.length-r+e),o=0;o<t.length-r;o+=1)n[o]=t[o+r];return n}(),o={};return o.getAt=function(r){return n[r]},o.getLength=function(){return n.length},o.multiply=function(t){for(var e=new Array(o.getLength()+t.getLength()-1),n=0;n<o.getLength();n+=1)for(var a=0;a<t.getLength();a+=1)e[n+a]^=i.gexp(i.glog(o.getAt(n))+i.glog(t.getAt(a)));return r(e,0)},o.mod=function(t){if(o.getLength()-t.getLength()<0)return o;for(var e=i.glog(o.getAt(0))-i.glog(t.getAt(0)),n=new Array(o.getLength()),a=0;a<o.getLength();a+=1)n[a]=o.getAt(a);for(var a=0;a<t.getLength();a+=1)n[a]^=i.gexp(i.glog(t.getAt(a))+e);return r(n,0).mod(t)},o}var t=function(t,e){var o=236,i=17,l=t,g=n[e],s=null,v=0,d=null,w=new Array,m={},y=function(r,t){v=4*l+17,s=function(r){for(var t=new Array(r),e=0;r>e;e+=1){t[e]=new Array(r);for(var n=0;r>n;n+=1)t[e][n]=null}return t}(v),T(0,0),T(v-7,0),T(0,v-7),A(),B(),k(r,t),l>=7&&E(r),null==d&&(d=D(l,g,w)),M(d,t)},T=function(r,t){for(var e=-1;7>=e;e+=1)if(!(-1>=r+e||r+e>=v))for(var n=-1;7>=n;n+=1)-1>=t+n||t+n>=v||(e>=0&&6>=e&&(0==n||6==n)||n>=0&&6>=n&&(0==e||6==e)||e>=2&&4>=e&&n>=2&&4>=n?s[r+e][t+n]=!0:s[r+e][t+n]=!1)},p=function(){for(var r=0,t=0,e=0;8>e;e+=1){y(!0,e);var n=a.getLostPoint(m);(0==e||r>n)&&(r=n,t=e)}return t},B=function(){for(var r=8;v-8>r;r+=1)null==s[r][6]&&(s[r][6]=r%2==0);for(var t=8;v-8>t;t+=1)null==s[6][t]&&(s[6][t]=t%2==0)},A=function(){for(var r=a.getPatternPosition(l),t=0;t<r.length;t+=1)for(var e=0;e<r.length;e+=1){var n=r[t],o=r[e];if(null==s[n][o])for(var i=-2;2>=i;i+=1)for(var u=-2;2>=u;u+=1)-2==i||2==i||-2==u||2==u||0==i&&0==u?s[n+i][o+u]=!0:s[n+i][o+u]=!1}},E=function(r){for(var t=a.getBCHTypeNumber(l),e=0;18>e;e+=1){var n=!r&&1==(t>>e&1);s[Math.floor(e/3)][e%3+v-8-3]=n}for(var e=0;18>e;e+=1){var n=!r&&1==(t>>e&1);s[e%3+v-8-3][Math.floor(e/3)]=n}},k=function(r,t){for(var e=g<<3|t,n=a.getBCHTypeInfo(e),o=0;15>o;o+=1){var i=!r&&1==(n>>o&1);6>o?s[o][8]=i:8>o?s[o+1][8]=i:s[v-15+o][8]=i}for(var o=0;15>o;o+=1){var i=!r&&1==(n>>o&1);8>o?s[8][v-o-1]=i:9>o?s[8][15-o-1+1]=i:s[8][15-o-1]=i}s[v-8][8]=!r},M=function(r,t){for(var e=-1,n=v-1,o=7,i=0,u=a.getMaskFunction(t),f=v-1;f>0;f-=2)for(6==f&&(f-=1);;){for(var c=0;2>c;c+=1)if(null==s[n][f-c]){var l=!1;i<r.length&&(l=1==(r[i]>>>o&1));var g=u(n,f-c);g&&(l=!l),s[n][f-c]=l,o-=1,-1==o&&(i+=1,o=7)}if(n+=e,0>n||n>=v){n-=e,e=-e;break}}},C=function(t,e){for(var n=0,o=0,i=0,u=new Array(e.length),f=new Array(e.length),c=0;c<e.length;c+=1){var l=e[c].dataCount,g=e[c].totalCount-l;o=Math.max(o,l),i=Math.max(i,g),u[c]=new Array(l);for(var s=0;s<u[c].length;s+=1)u[c][s]=255&t.getBuffer()[s+n];n+=l;var v=a.getErrorCorrectPolynomial(g),h=r(u[c],v.getLength()-1),d=h.mod(v);f[c]=new Array(v.getLength()-1);for(var s=0;s<f[c].length;s+=1){var w=s+d.getLength()-f[c].length;f[c][s]=w>=0?d.getAt(w):0}}for(var m=0,s=0;s<e.length;s+=1)m+=e[s].totalCount;for(var y=new Array(m),T=0,s=0;o>s;s+=1)for(var c=0;c<e.length;c+=1)s<u[c].length&&(y[T]=u[c][s],T+=1);for(var s=0;i>s;s+=1)for(var c=0;c<e.length;c+=1)s<f[c].length&&(y[T]=f[c][s],T+=1);return y},D=function(r,t,e){for(var n=u.getRSBlocks(r,t),c=f(),l=0;l<e.length;l+=1){var g=e[l];c.put(g.getMode(),4),c.put(g.getLength(),a.getLengthInBits(g.getMode(),r)),g.write(c)}for(var s=0,l=0;l<n.length;l+=1)s+=n[l].dataCount;if(c.getLengthInBits()>8*s)throw new Error("code length overflow. ("+c.getLengthInBits()+">"+8*s+")");for(c.getLengthInBits()+4<=8*s&&c.put(0,4);c.getLengthInBits()%8!=0;)c.putBit(!1);for(;;){if(c.getLengthInBits()>=8*s)break;if(c.put(o,8),c.getLengthInBits()>=8*s)break;c.put(i,8)}return C(c,n)};return m.addData=function(r){var t=c(r);w.push(t),d=null},m.isDark=function(r,t){if(0>r||r>=v||0>t||t>=v)throw new Error(r+","+t);return s[r][t]},m.getModuleCount=function(){return v},m.make=function(){y(!1,p())},m.createTableTag=function(r,t){r=r||2,t="undefined"==typeof t?4*r:t;var e="";e+='<table style="',e+=" border-width: 0px; border-style: none;",e+=" border-collapse: collapse;",e+=" padding: 0px; margin: "+t+"px;",e+='">',e+="<tbody>";for(var n=0;n<m.getModuleCount();n+=1){e+="<tr>";for(var o=0;o<m.getModuleCount();o+=1)e+='<td style="',e+=" border-width: 0px; border-style: none;",e+=" border-collapse: collapse;",e+=" padding: 0px; margin: 0px;",e+=" width: "+r+"px;",e+=" height: "+r+"px;",e+=" background-color: ",e+=m.isDark(n,o)?"#000000":"#ffffff",e+=";",e+='"/>';e+="</tr>"}return e+="</tbody>",e+="</table>"},m.createImgTag=function(r,t){r=r||2,t="undefined"==typeof t?4*r:t;var e=m.getModuleCount()*r+2*t,n=t,o=e-t;return h(e,e,function(t,e){if(t>=n&&o>t&&e>=n&&o>e){var a=Math.floor((t-n)/r),i=Math.floor((e-n)/r);return m.isDark(i,a)?0:1}return 1})},m};t.stringToBytes=function(r){for(var t=new Array,e=0;e<r.length;e+=1){var n=r.charCodeAt(e);t.push(255&n)}return t},t.createStringToBytes=function(r,t){var e=function(){for(var e=s(r),n=function(){var r=e.read();if(-1==r)throw new Error;return r},o=0,a={};;){var i=e.read();if(-1==i)break;var u=n(),f=n(),c=n(),l=String.fromCharCode(i<<8|u),g=f<<8|c;a[l]=g,o+=1}if(o!=t)throw new Error(o+" != "+t);return a}(),n="?".charCodeAt(0);return function(r){for(var t=new Array,o=0;o<r.length;o+=1){var a=r.charCodeAt(o);if(128>a)t.push(a);else{var i=e[r.charAt(o)];"number"==typeof i?(255&i)==i?t.push(i):(t.push(i>>>8),t.push(255&i)):t.push(n)}}return t}};var e={MODE_NUMBER:1,MODE_ALPHA_NUM:2,MODE_8BIT_BYTE:4,MODE_KANJI:8},n={L:1,M:0,Q:3,H:2},o={PATTERN000:0,PATTERN001:1,PATTERN010:2,PATTERN011:3,PATTERN100:4,PATTERN101:5,PATTERN110:6,PATTERN111:7},a=function(){var t=[[],[6,18],[6,22],[6,26],[6,30],[6,34],[6,22,38],[6,24,42],[6,26,46],[6,28,50],[6,30,54],[6,32,58],[6,34,62],[6,26,46,66],[6,26,48,70],[6,26,50,74],[6,30,54,78],[6,30,56,82],[6,30,58,86],[6,34,62,90],[6,28,50,72,94],[6,26,50,74,98],[6,30,54,78,102],[6,28,54,80,106],[6,32,58,84,110],[6,30,58,86,114],[6,34,62,90,118],[6,26,50,74,98,122],[6,30,54,78,102,126],[6,26,52,78,104,130],[6,30,56,82,108,134],[6,34,60,86,112,138],[6,30,58,86,114,142],[6,34,62,90,118,146],[6,30,54,78,102,126,150],[6,24,50,76,102,128,154],[6,28,54,80,106,132,158],[6,32,58,84,110,136,162],[6,26,54,82,110,138,166],[6,30,58,86,114,142,170]],n=1335,a=7973,u=21522,f={},c=function(r){for(var t=0;0!=r;)t+=1,r>>>=1;return t};return f.getBCHTypeInfo=function(r){for(var t=r<<10;c(t)-c(n)>=0;)t^=n<<c(t)-c(n);return(r<<10|t)^u},f.getBCHTypeNumber=function(r){for(var t=r<<12;c(t)-c(a)>=0;)t^=a<<c(t)-c(a);return r<<12|t},f.getPatternPosition=function(r){return t[r-1]},f.getMaskFunction=function(r){switch(r){case o.PATTERN000:return function(r,t){return(r+t)%2==0};case o.PATTERN001:return function(r,t){return r%2==0};case o.PATTERN010:return function(r,t){return t%3==0};case o.PATTERN011:return function(r,t){return(r+t)%3==0};case o.PATTERN100:return function(r,t){return(Math.floor(r/2)+Math.floor(t/3))%2==0};case o.PATTERN101:return function(r,t){return r*t%2+r*t%3==0};case o.PATTERN110:return function(r,t){return(r*t%2+r*t%3)%2==0};case o.PATTERN111:return function(r,t){return(r*t%3+(r+t)%2)%2==0};default:throw new Error("bad maskPattern:"+r)}},f.getErrorCorrectPolynomial=function(t){for(var e=r([1],0),n=0;t>n;n+=1)e=e.multiply(r([1,i.gexp(n)],0));return e},f.getLengthInBits=function(r,t){if(t>=1&&10>t)switch(r){case e.MODE_NUMBER:return 10;case e.MODE_ALPHA_NUM:return 9;case e.MODE_8BIT_BYTE:return 8;case e.MODE_KANJI:return 8;default:throw new Error("mode:"+r)}else if(27>t)switch(r){case e.MODE_NUMBER:return 12;case e.MODE_ALPHA_NUM:return 11;case e.MODE_8BIT_BYTE:return 16;case e.MODE_KANJI:return 10;default:throw new Error("mode:"+r)}else{if(!(41>t))throw new Error("type:"+t);switch(r){case e.MODE_NUMBER:return 14;case e.MODE_ALPHA_NUM:return 13;case e.MODE_8BIT_BYTE:return 16;case e.MODE_KANJI:return 12;default:throw new Error("mode:"+r)}}},f.getLostPoint=function(r){for(var t=r.getModuleCount(),e=0,n=0;t>n;n+=1)for(var o=0;t>o;o+=1){for(var a=0,i=r.isDark(n,o),u=-1;1>=u;u+=1)if(!(0>n+u||n+u>=t))for(var f=-1;1>=f;f+=1)0>o+f||o+f>=t||(0!=u||0!=f)&&i==r.isDark(n+u,o+f)&&(a+=1);a>5&&(e+=3+a-5)}for(var n=0;t-1>n;n+=1)for(var o=0;t-1>o;o+=1){var c=0;r.isDark(n,o)&&(c+=1),r.isDark(n+1,o)&&(c+=1),r.isDark(n,o+1)&&(c+=1),r.isDark(n+1,o+1)&&(c+=1),(0==c||4==c)&&(e+=3)}for(var n=0;t>n;n+=1)for(var o=0;t-6>o;o+=1)r.isDark(n,o)&&!r.isDark(n,o+1)&&r.isDark(n,o+2)&&r.isDark(n,o+3)&&r.isDark(n,o+4)&&!r.isDark(n,o+5)&&r.isDark(n,o+6)&&(e+=40);for(var o=0;t>o;o+=1)for(var n=0;t-6>n;n+=1)r.isDark(n,o)&&!r.isDark(n+1,o)&&r.isDark(n+2,o)&&r.isDark(n+3,o)&&r.isDark(n+4,o)&&!r.isDark(n+5,o)&&r.isDark(n+6,o)&&(e+=40);for(var l=0,o=0;t>o;o+=1)for(var n=0;t>n;n+=1)r.isDark(n,o)&&(l+=1);var g=Math.abs(100*l/t/t-50)/5;return e+=10*g},f}(),i=function(){for(var r=new Array(256),t=new Array(256),e=0;8>e;e+=1)r[e]=1<<e;for(var e=8;256>e;e+=1)r[e]=r[e-4]^r[e-5]^r[e-6]^r[e-8];for(var e=0;255>e;e+=1)t[r[e]]=e;var n={};return n.glog=function(r){if(1>r)throw new Error("glog("+r+")");return t[r]},n.gexp=function(t){for(;0>t;)t+=255;for(;t>=256;)t-=255;return r[t]},n}(),u=function(){var r=[[1,26,19],[1,26,16],[1,26,13],[1,26,9],[1,44,34],[1,44,28],[1,44,22],[1,44,16],[1,70,55],[1,70,44],[2,35,17],[2,35,13],[1,100,80],[2,50,32],[2,50,24],[4,25,9],[1,134,108],[2,67,43],[2,33,15,2,34,16],[2,33,11,2,34,12],[2,86,68],[4,43,27],[4,43,19],[4,43,15],[2,98,78],[4,49,31],[2,32,14,4,33,15],[4,39,13,1,40,14],[2,121,97],[2,60,38,2,61,39],[4,40,18,2,41,19],[4,40,14,2,41,15],[2,146,116],[3,58,36,2,59,37],[4,36,16,4,37,17],[4,36,12,4,37,13],[2,86,68,2,87,69],[4,69,43,1,70,44],[6,43,19,2,44,20],[6,43,15,2,44,16],[4,101,81],[1,80,50,4,81,51],[4,50,22,4,51,23],[3,36,12,8,37,13],[2,116,92,2,117,93],[6,58,36,2,59,37],[4,46,20,6,47,21],[7,42,14,4,43,15],[4,133,107],[8,59,37,1,60,38],[8,44,20,4,45,21],[12,33,11,4,34,12],[3,145,115,1,146,116],[4,64,40,5,65,41],[11,36,16,5,37,17],[11,36,12,5,37,13],[5,109,87,1,110,88],[5,65,41,5,66,42],[5,54,24,7,55,25],[11,36,12,7,37,13],[5,122,98,1,123,99],[7,73,45,3,74,46],[15,43,19,2,44,20],[3,45,15,13,46,16],[1,135,107,5,136,108],[10,74,46,1,75,47],[1,50,22,15,51,23],[2,42,14,17,43,15],[5,150,120,1,151,121],[9,69,43,4,70,44],[17,50,22,1,51,23],[2,42,14,19,43,15],[3,141,113,4,142,114],[3,70,44,11,71,45],[17,47,21,4,48,22],[9,39,13,16,40,14],[3,135,107,5,136,108],[3,67,41,13,68,42],[15,54,24,5,55,25],[15,43,15,10,44,16],[4,144,116,4,145,117],[17,68,42],[17,50,22,6,51,23],[19,46,16,6,47,17],[2,139,111,7,140,112],[17,74,46],[7,54,24,16,55,25],[34,37,13],[4,151,121,5,152,122],[4,75,47,14,76,48],[11,54,24,14,55,25],[16,45,15,14,46,16],[6,147,117,4,148,118],[6,73,45,14,74,46],[11,54,24,16,55,25],[30,46,16,2,47,17],[8,132,106,4,133,107],[8,75,47,13,76,48],[7,54,24,22,55,25],[22,45,15,13,46,16],[10,142,114,2,143,115],[19,74,46,4,75,47],[28,50,22,6,51,23],[33,46,16,4,47,17],[8,152,122,4,153,123],[22,73,45,3,74,46],[8,53,23,26,54,24],[12,45,15,28,46,16],[3,147,117,10,148,118],[3,73,45,23,74,46],[4,54,24,31,55,25],[11,45,15,31,46,16],[7,146,116,7,147,117],[21,73,45,7,74,46],[1,53,23,37,54,24],[19,45,15,26,46,16],[5,145,115,10,146,116],[19,75,47,10,76,48],[15,54,24,25,55,25],[23,45,15,25,46,16],[13,145,115,3,146,116],[2,74,46,29,75,47],[42,54,24,1,55,25],[23,45,15,28,46,16],[17,145,115],[10,74,46,23,75,47],[10,54,24,35,55,25],[19,45,15,35,46,16],[17,145,115,1,146,116],[14,74,46,21,75,47],[29,54,24,19,55,25],[11,45,15,46,46,16],[13,145,115,6,146,116],[14,74,46,23,75,47],[44,54,24,7,55,25],[59,46,16,1,47,17],[12,151,121,7,152,122],[12,75,47,26,76,48],[39,54,24,14,55,25],[22,45,15,41,46,16],[6,151,121,14,152,122],[6,75,47,34,76,48],[46,54,24,10,55,25],[2,45,15,64,46,16],[17,152,122,4,153,123],[29,74,46,14,75,47],[49,54,24,10,55,25],[24,45,15,46,46,16],[4,152,122,18,153,123],[13,74,46,32,75,47],[48,54,24,14,55,25],[42,45,15,32,46,16],[20,147,117,4,148,118],[40,75,47,7,76,48],[43,54,24,22,55,25],[10,45,15,67,46,16],[19,148,118,6,149,119],[18,75,47,31,76,48],[34,54,24,34,55,25],[20,45,15,61,46,16]],t=function(r,t){var e={};return e.totalCount=r,e.dataCount=t,e},e={},o=function(t,e){switch(e){case n.L:return r[4*(t-1)+0];case n.M:return r[4*(t-1)+1];case n.Q:return r[4*(t-1)+2];case n.H:return r[4*(t-1)+3];default:return}};return e.getRSBlocks=function(r,e){var n=o(r,e);if("undefined"==typeof n)throw new Error("bad rs block @ typeNumber:"+r+"/errorCorrectLevel:"+e);for(var a=n.length/3,i=new Array,u=0;a>u;u+=1)for(var f=n[3*u+0],c=n[3*u+1],l=n[3*u+2],g=0;f>g;g+=1)i.push(t(c,l));return i},e}(),f=function(){var r=new Array,t=0,e={};return e.getBuffer=function(){return r},e.getAt=function(t){var e=Math.floor(t/8);return 1==(r[e]>>>7-t%8&1)},e.put=function(r,t){for(var n=0;t>n;n+=1)e.putBit(1==(r>>>t-n-1&1))},e.getLengthInBits=function(){return t},e.putBit=function(e){var n=Math.floor(t/8);r.length<=n&&r.push(0),e&&(r[n]|=128>>>t%8),t+=1},e},c=function(r){var n=e.MODE_8BIT_BYTE,o=t.stringToBytes(r),a={};return a.getMode=function(){return n},a.getLength=function(r){return o.length},a.write=function(r){for(var t=0;t<o.length;t+=1)r.put(o[t],8)},a},l=function(){var r=new Array,t={};return t.writeByte=function(t){r.push(255&t)},t.writeShort=function(r){t.writeByte(r),t.writeByte(r>>>8)},t.writeBytes=function(r,e,n){e=e||0,n=n||r.length;for(var o=0;n>o;o+=1)t.writeByte(r[o+e])},t.writeString=function(r){for(var e=0;e<r.length;e+=1)t.writeByte(r.charCodeAt(e))},t.toByteArray=function(){return r},t.toString=function(){var t="";t+="[";for(var e=0;e<r.length;e+=1)e>0&&(t+=","),t+=r[e];return t+="]"},t},g=function(){var r=0,t=0,e=0,n="",o={},a=function(r){n+=String.fromCharCode(i(63&r))},i=function(r){if(0>r);else{if(26>r)return 65+r;if(52>r)return 97+(r-26);if(62>r)return 48+(r-52);if(62==r)return 43;if(63==r)return 47}throw new Error("n:"+r)};return o.writeByte=function(n){for(r=r<<8|255&n,t+=8,e+=1;t>=6;)a(r>>>t-6),t-=6},o.flush=function(){if(t>0&&(a(r<<6-t),r=0,t=0),e%3!=0)for(var o=3-e%3,i=0;o>i;i+=1)n+="="},o.toString=function(){return n},o},s=function(r){var t=r,e=0,n=0,o=0,a={};a.read=function(){for(;8>o;){if(e>=t.length){if(0==o)return-1;throw new Error("unexpected end of file./"+o)}var r=t.charAt(e);if(e+=1,"="==r)return o=0,-1;r.match(/^\s$/)||(n=n<<6|i(r.charCodeAt(0)),o+=6)}var a=n>>>o-8&255;return o-=8,a};var i=function(r){if(r>=65&&90>=r)return r-65;if(r>=97&&122>=r)return r-97+26;if(r>=48&&57>=r)return r-48+52;if(43==r)return 62;if(47==r)return 63;throw new Error("c:"+r)};return a},v=function(r,t){var e=r,n=t,o=new Array(r*t),a={};a.setPixel=function(r,t,n){o[t*e+r]=n},a.write=function(r){r.writeString("GIF87a"),r.writeShort(e),r.writeShort(n),r.writeByte(128),r.writeByte(0),r.writeByte(0),r.writeByte(0),r.writeByte(0),r.writeByte(0),r.writeByte(255),r.writeByte(255),r.writeByte(255),r.writeString(","),r.writeShort(0),r.writeShort(0),r.writeShort(e),r.writeShort(n),r.writeByte(0);var t=2,o=u(t);r.writeByte(t);for(var a=0;o.length-a>255;)r.writeByte(255),r.writeBytes(o,a,255),a+=255;r.writeByte(o.length-a),r.writeBytes(o,a,o.length-a),r.writeByte(0),r.writeString(";")};var i=function(r){var t=r,e=0,n=0,o={};return o.write=function(r,o){if(r>>>o!=0)throw new Error("length over");for(;e+o>=8;)t.writeByte(255&(r<<e|n)),o-=8-e,r>>>=8-e,n=0,e=0;n=r<<e|n,e+=o},o.flush=function(){e>0&&t.writeByte(n)},o},u=function(r){for(var t=1<<r,e=(1<<r)+1,n=r+1,a=f(),u=0;t>u;u+=1)a.add(String.fromCharCode(u));a.add(String.fromCharCode(t)),a.add(String.fromCharCode(e));var c=l(),g=i(c);g.write(t,n);var s=0,v=String.fromCharCode(o[s]);for(s+=1;s<o.length;){var h=String.fromCharCode(o[s]);s+=1,a.contains(v+h)?v+=h:(g.write(a.indexOf(v),n),a.size()<4095&&(a.size()==1<<n&&(n+=1),a.add(v+h)),v=h)}return g.write(a.indexOf(v),n),g.write(e,n),g.flush(),c.toByteArray()},f=function(){var r={},t=0,e={};return e.add=function(n){if(e.contains(n))throw new Error("dup key:"+n);r[n]=t,t+=1},e.size=function(){return t},e.indexOf=function(t){return r[t]},e.contains=function(t){return"undefined"!=typeof r[t]},e};return a},h=function(r,t,e,n){for(var o=v(r,t),a=0;t>a;a+=1)for(var i=0;r>i;i+=1)o.setPixel(i,a,e(i,a));var u=l();o.write(u);for(var f=g(),c=u.toByteArray(),s=0;s<c.length;s+=1)f.writeByte(c[s]);f.flush();var h="";return h+="<img",h+=' src="',h+="data:image/gif;base64,",h+=f,h+='"',h+=' width="',h+=r,h+='"',h+=' height="',h+=t,h+='"',n&&(h+=' alt="',h+=n,h+='"'),h+="/>"};return t}();return function(r){ true?!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (r),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)):0}(function(){return r}),!function(r){r.stringToBytes=function(r){function t(r){for(var t=[],e=0;e<r.length;e++){var n=r.charCodeAt(e);128>n?t.push(n):2048>n?t.push(192|n>>6,128|63&n):55296>n||n>=57344?t.push(224|n>>12,128|n>>6&63,128|63&n):(e++,n=65536+((1023&n)<<10|1023&r.charCodeAt(e)),t.push(240|n>>18,128|n>>12&63,128|n>>6&63,128|63&n))}return t}return t(r)}}(r),r}());

/***/ },

/***/ "../smapServer/WebContent/js/libs/knockout.js"
/*!****************************************************!*\
  !*** ../smapServer/WebContent/js/libs/knockout.js ***!
  \****************************************************/
(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * Knockout JavaScript library v3.4.2
 * (c) The Knockout.js team - http://knockoutjs.com/
 * License: MIT (http://www.opensource.org/licenses/mit-license.php)
 */

(function() {(function(n){var x=this||(0,eval)("this"),t=x.document,M=x.navigator,u=x.jQuery,H=x.JSON;(function(n){ true?!(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports,__webpack_require__], __WEBPACK_AMD_DEFINE_FACTORY__ = (n),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)):0})(function(N,O){function J(a,c){return null===a||typeof a in R?a===c:!1}function S(b,c){var d;return function(){d||(d=a.a.setTimeout(function(){d=n;b()},c))}}function T(b,c){var d;return function(){clearTimeout(d);d=a.a.setTimeout(b,c)}}function U(a,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            c){c&&c!==E?"beforeChange"===c?this.Ob(a):this.Ja(a,c):this.Pb(a)}function V(a,c){null!==c&&c.k&&c.k()}function W(a,c){var d=this.Mc,e=d[s];e.T||(this.ob&&this.Oa[c]?(d.Sb(c,a,this.Oa[c]),this.Oa[c]=null,--this.ob):e.s[c]||d.Sb(c,a,e.t?{$:a}:d.yc(a)),a.Ha&&a.Hc())}function K(b,c,d,e){a.d[b]={init:function(b,g,h,l,m){var k,r;a.m(function(){var q=g(),p=a.a.c(q),p=!d!==!p,A=!r;if(A||c||p!==k)A&&a.xa.Ca()&&(r=a.a.wa(a.f.childNodes(b),!0)),p?(A||a.f.fa(b,a.a.wa(r)),a.hb(e?e(m,q):m,b)):a.f.za(b),k=p},null,
    {i:b});return{controlsDescendantBindings:!0}}};a.h.va[b]=!1;a.f.aa[b]=!0}var a="undefined"!==typeof N?N:{};a.b=function(b,c){for(var d=b.split("."),e=a,f=0;f<d.length-1;f++)e=e[d[f]];e[d[d.length-1]]=c};a.H=function(a,c,d){a[c]=d};a.version="3.4.2";a.b("version",a.version);a.options={deferUpdates:!1,useOnlyNativeEvents:!1};a.a=function(){function b(a,b){for(var c in a)a.hasOwnProperty(c)&&b(c,a[c])}function c(a,b){if(b)for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c]);return a}function d(a,b){a.__proto__=
    b;return a}function e(b,c,d,e){var m=b[c].match(r)||[];a.a.r(d.match(r),function(b){a.a.ra(m,b,e)});b[c]=m.join(" ")}var f={__proto__:[]}instanceof Array,g="function"===typeof Symbol,h={},l={};h[M&&/Firefox\/2/i.test(M.userAgent)?"KeyboardEvent":"UIEvents"]=["keyup","keydown","keypress"];h.MouseEvents="click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave".split(" ");b(h,function(a,b){if(b.length)for(var c=0,d=b.length;c<d;c++)l[b[c]]=a});var m={propertychange:!0},k=
    t&&function(){for(var a=3,b=t.createElement("div"),c=b.getElementsByTagName("i");b.innerHTML="\x3c!--[if gt IE "+ ++a+"]><i></i><![endif]--\x3e",c[0];);return 4<a?a:n}(),r=/\S+/g;return{gc:["authenticity_token",/^__RequestVerificationToken(_.*)?$/],r:function(a,b){for(var c=0,d=a.length;c<d;c++)b(a[c],c)},o:function(a,b){if("function"==typeof Array.prototype.indexOf)return Array.prototype.indexOf.call(a,b);for(var c=0,d=a.length;c<d;c++)if(a[c]===b)return c;return-1},Vb:function(a,b,c){for(var d=
    0,e=a.length;d<e;d++)if(b.call(c,a[d],d))return a[d];return null},Na:function(b,c){var d=a.a.o(b,c);0<d?b.splice(d,1):0===d&&b.shift()},Wb:function(b){b=b||[];for(var c=[],d=0,e=b.length;d<e;d++)0>a.a.o(c,b[d])&&c.push(b[d]);return c},ib:function(a,b){a=a||[];for(var c=[],d=0,e=a.length;d<e;d++)c.push(b(a[d],d));return c},Ma:function(a,b){a=a||[];for(var c=[],d=0,e=a.length;d<e;d++)b(a[d],d)&&c.push(a[d]);return c},ta:function(a,b){if(b instanceof Array)a.push.apply(a,b);else for(var c=0,d=b.length;c<
d;c++)a.push(b[c]);return a},ra:function(b,c,d){var e=a.a.o(a.a.Bb(b),c);0>e?d&&b.push(c):d||b.splice(e,1)},la:f,extend:c,$a:d,ab:f?d:c,D:b,Ea:function(a,b){if(!a)return a;var c={},d;for(d in a)a.hasOwnProperty(d)&&(c[d]=b(a[d],d,a));return c},rb:function(b){for(;b.firstChild;)a.removeNode(b.firstChild)},nc:function(b){b=a.a.W(b);for(var c=(b[0]&&b[0].ownerDocument||t).createElement("div"),d=0,e=b.length;d<e;d++)c.appendChild(a.ba(b[d]));return c},wa:function(b,c){for(var d=0,e=b.length,m=[];d<e;d++){var k=
    b[d].cloneNode(!0);m.push(c?a.ba(k):k)}return m},fa:function(b,c){a.a.rb(b);if(c)for(var d=0,e=c.length;d<e;d++)b.appendChild(c[d])},uc:function(b,c){var d=b.nodeType?[b]:b;if(0<d.length){for(var e=d[0],m=e.parentNode,k=0,f=c.length;k<f;k++)m.insertBefore(c[k],e);k=0;for(f=d.length;k<f;k++)a.removeNode(d[k])}},Ba:function(a,b){if(a.length){for(b=8===b.nodeType&&b.parentNode||b;a.length&&a[0].parentNode!==b;)a.splice(0,1);for(;1<a.length&&a[a.length-1].parentNode!==b;)a.length--;if(1<a.length){var c=
    a[0],d=a[a.length-1];for(a.length=0;c!==d;)a.push(c),c=c.nextSibling;a.push(d)}}return a},wc:function(a,b){7>k?a.setAttribute("selected",b):a.selected=b},cb:function(a){return null===a||a===n?"":a.trim?a.trim():a.toString().replace(/^[\s\xa0]+|[\s\xa0]+$/g,"")},sd:function(a,b){a=a||"";return b.length>a.length?!1:a.substring(0,b.length)===b},Rc:function(a,b){if(a===b)return!0;if(11===a.nodeType)return!1;if(b.contains)return b.contains(3===a.nodeType?a.parentNode:a);if(b.compareDocumentPosition)return 16==
    (b.compareDocumentPosition(a)&16);for(;a&&a!=b;)a=a.parentNode;return!!a},qb:function(b){return a.a.Rc(b,b.ownerDocument.documentElement)},Tb:function(b){return!!a.a.Vb(b,a.a.qb)},A:function(a){return a&&a.tagName&&a.tagName.toLowerCase()},Zb:function(b){return a.onError?function(){try{return b.apply(this,arguments)}catch(c){throw a.onError&&a.onError(c),c;}}:b},setTimeout:function(b,c){return setTimeout(a.a.Zb(b),c)},dc:function(b){setTimeout(function(){a.onError&&a.onError(b);throw b;},0)},q:function(b,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                c,d){var e=a.a.Zb(d);d=k&&m[c];if(a.options.useOnlyNativeEvents||d||!u)if(d||"function"!=typeof b.addEventListener)if("undefined"!=typeof b.attachEvent){var f=function(a){e.call(b,a)},l="on"+c;b.attachEvent(l,f);a.a.G.qa(b,function(){b.detachEvent(l,f)})}else throw Error("Browser doesn't support addEventListener or attachEvent");else b.addEventListener(c,e,!1);else u(b).bind(c,e)},Fa:function(b,c){if(!b||!b.nodeType)throw Error("element must be a DOM node when calling triggerEvent");var d;"input"===
a.a.A(b)&&b.type&&"click"==c.toLowerCase()?(d=b.type,d="checkbox"==d||"radio"==d):d=!1;if(a.options.useOnlyNativeEvents||!u||d)if("function"==typeof t.createEvent)if("function"==typeof b.dispatchEvent)d=t.createEvent(l[c]||"HTMLEvents"),d.initEvent(c,!0,!0,x,0,0,0,0,0,!1,!1,!1,!1,0,b),b.dispatchEvent(d);else throw Error("The supplied element doesn't support dispatchEvent");else if(d&&b.click)b.click();else if("undefined"!=typeof b.fireEvent)b.fireEvent("on"+c);else throw Error("Browser doesn't support triggering events");
else u(b).trigger(c)},c:function(b){return a.I(b)?b():b},Bb:function(b){return a.I(b)?b.p():b},fb:function(b,c,d){var k;c&&("object"===typeof b.classList?(k=b.classList[d?"add":"remove"],a.a.r(c.match(r),function(a){k.call(b.classList,a)})):"string"===typeof b.className.baseVal?e(b.className,"baseVal",c,d):e(b,"className",c,d))},bb:function(b,c){var d=a.a.c(c);if(null===d||d===n)d="";var e=a.f.firstChild(b);!e||3!=e.nodeType||a.f.nextSibling(e)?a.f.fa(b,[b.ownerDocument.createTextNode(d)]):e.data=
    d;a.a.Wc(b)},vc:function(a,b){a.name=b;if(7>=k)try{a.mergeAttributes(t.createElement("<input name='"+a.name+"'/>"),!1)}catch(c){}},Wc:function(a){9<=k&&(a=1==a.nodeType?a:a.parentNode,a.style&&(a.style.zoom=a.style.zoom))},Sc:function(a){if(k){var b=a.style.width;a.style.width=0;a.style.width=b}},nd:function(b,c){b=a.a.c(b);c=a.a.c(c);for(var d=[],e=b;e<=c;e++)d.push(e);return d},W:function(a){for(var b=[],c=0,d=a.length;c<d;c++)b.push(a[c]);return b},bc:function(a){return g?Symbol(a):a},xd:6===k,
    yd:7===k,C:k,ic:function(b,c){for(var d=a.a.W(b.getElementsByTagName("input")).concat(a.a.W(b.getElementsByTagName("textarea"))),e="string"==typeof c?function(a){return a.name===c}:function(a){return c.test(a.name)},k=[],m=d.length-1;0<=m;m--)e(d[m])&&k.push(d[m]);return k},kd:function(b){return"string"==typeof b&&(b=a.a.cb(b))?H&&H.parse?H.parse(b):(new Function("return "+b))():null},Gb:function(b,c,d){if(!H||!H.stringify)throw Error("Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js");
        return H.stringify(a.a.c(b),c,d)},ld:function(c,d,e){e=e||{};var k=e.params||{},m=e.includeFields||this.gc,f=c;if("object"==typeof c&&"form"===a.a.A(c))for(var f=c.action,l=m.length-1;0<=l;l--)for(var g=a.a.ic(c,m[l]),h=g.length-1;0<=h;h--)k[g[h].name]=g[h].value;d=a.a.c(d);var r=t.createElement("form");r.style.display="none";r.action=f;r.method="post";for(var n in d)c=t.createElement("input"),c.type="hidden",c.name=n,c.value=a.a.Gb(a.a.c(d[n])),r.appendChild(c);b(k,function(a,b){var c=t.createElement("input");
        c.type="hidden";c.name=a;c.value=b;r.appendChild(c)});t.body.appendChild(r);e.submitter?e.submitter(r):r.submit();setTimeout(function(){r.parentNode.removeChild(r)},0)}}}();a.b("utils",a.a);a.b("utils.arrayForEach",a.a.r);a.b("utils.arrayFirst",a.a.Vb);a.b("utils.arrayFilter",a.a.Ma);a.b("utils.arrayGetDistinctValues",a.a.Wb);a.b("utils.arrayIndexOf",a.a.o);a.b("utils.arrayMap",a.a.ib);a.b("utils.arrayPushAll",a.a.ta);a.b("utils.arrayRemoveItem",a.a.Na);a.b("utils.extend",a.a.extend);a.b("utils.fieldsIncludedWithJsonPost",
    a.a.gc);a.b("utils.getFormFields",a.a.ic);a.b("utils.peekObservable",a.a.Bb);a.b("utils.postJson",a.a.ld);a.b("utils.parseJson",a.a.kd);a.b("utils.registerEventHandler",a.a.q);a.b("utils.stringifyJson",a.a.Gb);a.b("utils.range",a.a.nd);a.b("utils.toggleDomNodeCssClass",a.a.fb);a.b("utils.triggerEvent",a.a.Fa);a.b("utils.unwrapObservable",a.a.c);a.b("utils.objectForEach",a.a.D);a.b("utils.addOrRemoveItem",a.a.ra);a.b("utils.setTextContent",a.a.bb);a.b("unwrap",a.a.c);Function.prototype.bind||(Function.prototype.bind=
    function(a){var c=this;if(1===arguments.length)return function(){return c.apply(a,arguments)};var d=Array.prototype.slice.call(arguments,1);return function(){var e=d.slice(0);e.push.apply(e,arguments);return c.apply(a,e)}});a.a.e=new function(){function a(b,g){var h=b[d];if(!h||"null"===h||!e[h]){if(!g)return n;h=b[d]="ko"+c++;e[h]={}}return e[h]}var c=0,d="__ko__"+(new Date).getTime(),e={};return{get:function(c,d){var e=a(c,!1);return e===n?n:e[d]},set:function(c,d,e){if(e!==n||a(c,!1)!==n)a(c,!0)[d]=
    e},clear:function(a){var b=a[d];return b?(delete e[b],a[d]=null,!0):!1},J:function(){return c++ +d}}};a.b("utils.domData",a.a.e);a.b("utils.domData.clear",a.a.e.clear);a.a.G=new function(){function b(b,c){var e=a.a.e.get(b,d);e===n&&c&&(e=[],a.a.e.set(b,d,e));return e}function c(d){var e=b(d,!1);if(e)for(var e=e.slice(0),l=0;l<e.length;l++)e[l](d);a.a.e.clear(d);a.a.G.cleanExternalData(d);if(f[d.nodeType])for(e=d.firstChild;d=e;)e=d.nextSibling,8===d.nodeType&&c(d)}var d=a.a.e.J(),e={1:!0,8:!0,9:!0},
    f={1:!0,9:!0};return{qa:function(a,c){if("function"!=typeof c)throw Error("Callback must be a function");b(a,!0).push(c)},tc:function(c,e){var f=b(c,!1);f&&(a.a.Na(f,e),0==f.length&&a.a.e.set(c,d,n))},ba:function(b){if(e[b.nodeType]&&(c(b),f[b.nodeType])){var d=[];a.a.ta(d,b.getElementsByTagName("*"));for(var l=0,m=d.length;l<m;l++)c(d[l])}return b},removeNode:function(b){a.ba(b);b.parentNode&&b.parentNode.removeChild(b)},cleanExternalData:function(a){u&&"function"==typeof u.cleanData&&u.cleanData([a])}}};
    a.ba=a.a.G.ba;a.removeNode=a.a.G.removeNode;a.b("cleanNode",a.ba);a.b("removeNode",a.removeNode);a.b("utils.domNodeDisposal",a.a.G);a.b("utils.domNodeDisposal.addDisposeCallback",a.a.G.qa);a.b("utils.domNodeDisposal.removeDisposeCallback",a.a.G.tc);(function(){var b=[0,"",""],c=[1,"<table>","</table>"],d=[3,"<table><tbody><tr>","</tr></tbody></table>"],e=[1,"<select multiple='multiple'>","</select>"],f={thead:c,tbody:c,tfoot:c,tr:[2,"<table><tbody>","</tbody></table>"],td:d,th:d,option:e,optgroup:e},
        g=8>=a.a.C;a.a.na=function(c,d){var e;if(u)if(u.parseHTML)e=u.parseHTML(c,d)||[];else{if((e=u.clean([c],d))&&e[0]){for(var k=e[0];k.parentNode&&11!==k.parentNode.nodeType;)k=k.parentNode;k.parentNode&&k.parentNode.removeChild(k)}}else{(e=d)||(e=t);var k=e.parentWindow||e.defaultView||x,r=a.a.cb(c).toLowerCase(),q=e.createElement("div"),p;p=(r=r.match(/^<([a-z]+)[ >]/))&&f[r[1]]||b;r=p[0];p="ignored<div>"+p[1]+c+p[2]+"</div>";"function"==typeof k.innerShiv?q.appendChild(k.innerShiv(p)):(g&&e.appendChild(q),
        q.innerHTML=p,g&&q.parentNode.removeChild(q));for(;r--;)q=q.lastChild;e=a.a.W(q.lastChild.childNodes)}return e};a.a.Eb=function(b,c){a.a.rb(b);c=a.a.c(c);if(null!==c&&c!==n)if("string"!=typeof c&&(c=c.toString()),u)u(b).html(c);else for(var d=a.a.na(c,b.ownerDocument),e=0;e<d.length;e++)b.appendChild(d[e])}})();a.b("utils.parseHtmlFragment",a.a.na);a.b("utils.setHtml",a.a.Eb);a.N=function(){function b(c,e){if(c)if(8==c.nodeType){var f=a.N.pc(c.nodeValue);null!=f&&e.push({Qc:c,hd:f})}else if(1==c.nodeType)for(var f=
        0,g=c.childNodes,h=g.length;f<h;f++)b(g[f],e)}var c={};return{yb:function(a){if("function"!=typeof a)throw Error("You can only pass a function to ko.memoization.memoize()");var b=(4294967296*(1+Math.random())|0).toString(16).substring(1)+(4294967296*(1+Math.random())|0).toString(16).substring(1);c[b]=a;return"\x3c!--[ko_memo:"+b+"]--\x3e"},Bc:function(a,b){var f=c[a];if(f===n)throw Error("Couldn't find any memo with ID "+a+". Perhaps it's already been unmemoized.");try{return f.apply(null,b||[]),
        !0}finally{delete c[a]}},Cc:function(c,e){var f=[];b(c,f);for(var g=0,h=f.length;g<h;g++){var l=f[g].Qc,m=[l];e&&a.a.ta(m,e);a.N.Bc(f[g].hd,m);l.nodeValue="";l.parentNode&&l.parentNode.removeChild(l)}},pc:function(a){return(a=a.match(/^\[ko_memo\:(.*?)\]$/))?a[1]:null}}}();a.b("memoization",a.N);a.b("memoization.memoize",a.N.yb);a.b("memoization.unmemoize",a.N.Bc);a.b("memoization.parseMemoText",a.N.pc);a.b("memoization.unmemoizeDomNodeAndDescendants",a.N.Cc);a.Z=function(){function b(){if(e)for(var b=
        e,c=0,m;g<e;)if(m=d[g++]){if(g>b){if(5E3<=++c){g=e;a.a.dc(Error("'Too much recursion' after processing "+c+" task groups."));break}b=e}try{m()}catch(k){a.a.dc(k)}}}function c(){b();g=e=d.length=0}var d=[],e=0,f=1,g=0;return{scheduler:x.MutationObserver?function(a){var b=t.createElement("div");(new MutationObserver(a)).observe(b,{attributes:!0});return function(){b.classList.toggle("foo")}}(c):t&&"onreadystatechange"in t.createElement("script")?function(a){var b=t.createElement("script");b.onreadystatechange=
        function(){b.onreadystatechange=null;t.documentElement.removeChild(b);b=null;a()};t.documentElement.appendChild(b)}:function(a){setTimeout(a,0)},Za:function(b){e||a.Z.scheduler(c);d[e++]=b;return f++},cancel:function(a){a-=f-e;a>=g&&a<e&&(d[a]=null)},resetForTesting:function(){var a=e-g;g=e=d.length=0;return a},rd:b}}();a.b("tasks",a.Z);a.b("tasks.schedule",a.Z.Za);a.b("tasks.runEarly",a.Z.rd);a.Aa={throttle:function(b,c){b.throttleEvaluation=c;var d=null;return a.B({read:b,write:function(e){clearTimeout(d);
        d=a.a.setTimeout(function(){b(e)},c)}})},rateLimit:function(a,c){var d,e,f;"number"==typeof c?d=c:(d=c.timeout,e=c.method);a.gb=!1;f="notifyWhenChangesStop"==e?T:S;a.Wa(function(a){return f(a,d)})},deferred:function(b,c){if(!0!==c)throw Error("The 'deferred' extender only accepts the value 'true', because it is not supported to turn deferral off once enabled.");b.gb||(b.gb=!0,b.Wa(function(c){var e,f=!1;return function(){if(!f){a.Z.cancel(e);e=a.Z.Za(c);try{f=!0,b.notifySubscribers(n,"dirty")}finally{f=
        !1}}}}))},notify:function(a,c){a.equalityComparer="always"==c?null:J}};var R={undefined:1,"boolean":1,number:1,string:1};a.b("extenders",a.Aa);a.zc=function(b,c,d){this.$=b;this.jb=c;this.Pc=d;this.T=!1;a.H(this,"dispose",this.k)};a.zc.prototype.k=function(){this.T=!0;this.Pc()};a.K=function(){a.a.ab(this,D);D.ub(this)};var E="change",D={ub:function(a){a.F={change:[]};a.Qb=1},Y:function(b,c,d){var e=this;d=d||E;var f=new a.zc(e,c?b.bind(c):b,function(){a.a.Na(e.F[d],f);e.Ka&&e.Ka(d)});e.ua&&e.ua(d);
        e.F[d]||(e.F[d]=[]);e.F[d].push(f);return f},notifySubscribers:function(b,c){c=c||E;c===E&&this.Kb();if(this.Ra(c)){var d=c===E&&this.Fc||this.F[c].slice(0);try{a.l.Xb();for(var e=0,f;f=d[e];++e)f.T||f.jb(b)}finally{a.l.end()}}},Pa:function(){return this.Qb},Zc:function(a){return this.Pa()!==a},Kb:function(){++this.Qb},Wa:function(b){var c=this,d=a.I(c),e,f,g,h;c.Ja||(c.Ja=c.notifySubscribers,c.notifySubscribers=U);var l=b(function(){c.Ha=!1;d&&h===c&&(h=c.Mb?c.Mb():c());var a=f||c.Ua(g,h);f=e=!1;
        a&&c.Ja(g=h)});c.Pb=function(a){c.Fc=c.F[E].slice(0);c.Ha=e=!0;h=a;l()};c.Ob=function(a){e||(g=a,c.Ja(a,"beforeChange"))};c.Hc=function(){c.Ua(g,c.p(!0))&&(f=!0)}},Ra:function(a){return this.F[a]&&this.F[a].length},Xc:function(b){if(b)return this.F[b]&&this.F[b].length||0;var c=0;a.a.D(this.F,function(a,b){"dirty"!==a&&(c+=b.length)});return c},Ua:function(a,c){return!this.equalityComparer||!this.equalityComparer(a,c)},extend:function(b){var c=this;b&&a.a.D(b,function(b,e){var f=a.Aa[b];"function"==
    typeof f&&(c=f(c,e)||c)});return c}};a.H(D,"subscribe",D.Y);a.H(D,"extend",D.extend);a.H(D,"getSubscriptionsCount",D.Xc);a.a.la&&a.a.$a(D,Function.prototype);a.K.fn=D;a.lc=function(a){return null!=a&&"function"==typeof a.Y&&"function"==typeof a.notifySubscribers};a.b("subscribable",a.K);a.b("isSubscribable",a.lc);a.xa=a.l=function(){function b(a){d.push(e);e=a}function c(){e=d.pop()}var d=[],e,f=0;return{Xb:b,end:c,sc:function(b){if(e){if(!a.lc(b))throw Error("Only subscribable things can act as dependencies");
        e.jb.call(e.Lc,b,b.Gc||(b.Gc=++f))}},w:function(a,d,e){try{return b(),a.apply(d,e||[])}finally{c()}},Ca:function(){if(e)return e.m.Ca()},Va:function(){if(e)return e.Va}}}();a.b("computedContext",a.xa);a.b("computedContext.getDependenciesCount",a.xa.Ca);a.b("computedContext.isInitial",a.xa.Va);a.b("ignoreDependencies",a.wd=a.l.w);var F=a.a.bc("_latestValue");a.O=function(b){function c(){if(0<arguments.length)return c.Ua(c[F],arguments[0])&&(c.ia(),c[F]=arguments[0],c.ha()),this;a.l.sc(c);return c[F]}
        c[F]=b;a.a.la||a.a.extend(c,a.K.fn);a.K.fn.ub(c);a.a.ab(c,B);a.options.deferUpdates&&a.Aa.deferred(c,!0);return c};var B={equalityComparer:J,p:function(){return this[F]},ha:function(){this.notifySubscribers(this[F])},ia:function(){this.notifySubscribers(this[F],"beforeChange")}};a.a.la&&a.a.$a(B,a.K.fn);var I=a.O.md="__ko_proto__";B[I]=a.O;a.Qa=function(b,c){return null===b||b===n||b[I]===n?!1:b[I]===c?!0:a.Qa(b[I],c)};a.I=function(b){return a.Qa(b,a.O)};a.Da=function(b){return"function"==typeof b&&
    b[I]===a.O||"function"==typeof b&&b[I]===a.B&&b.$c?!0:!1};a.b("observable",a.O);a.b("isObservable",a.I);a.b("isWriteableObservable",a.Da);a.b("isWritableObservable",a.Da);a.b("observable.fn",B);a.H(B,"peek",B.p);a.H(B,"valueHasMutated",B.ha);a.H(B,"valueWillMutate",B.ia);a.ma=function(b){b=b||[];if("object"!=typeof b||!("length"in b))throw Error("The argument passed when initializing an observable array must be an array, or null, or undefined.");b=a.O(b);a.a.ab(b,a.ma.fn);return b.extend({trackArrayChanges:!0})};
    a.ma.fn={remove:function(b){for(var c=this.p(),d=[],e="function"!=typeof b||a.I(b)?function(a){return a===b}:b,f=0;f<c.length;f++){var g=c[f];e(g)&&(0===d.length&&this.ia(),d.push(g),c.splice(f,1),f--)}d.length&&this.ha();return d},removeAll:function(b){if(b===n){var c=this.p(),d=c.slice(0);this.ia();c.splice(0,c.length);this.ha();return d}return b?this.remove(function(c){return 0<=a.a.o(b,c)}):[]},destroy:function(b){var c=this.p(),d="function"!=typeof b||a.I(b)?function(a){return a===b}:b;this.ia();
        for(var e=c.length-1;0<=e;e--)d(c[e])&&(c[e]._destroy=!0);this.ha()},destroyAll:function(b){return b===n?this.destroy(function(){return!0}):b?this.destroy(function(c){return 0<=a.a.o(b,c)}):[]},indexOf:function(b){var c=this();return a.a.o(c,b)},replace:function(a,c){var d=this.indexOf(a);0<=d&&(this.ia(),this.p()[d]=c,this.ha())}};a.a.la&&a.a.$a(a.ma.fn,a.O.fn);a.a.r("pop push reverse shift sort splice unshift".split(" "),function(b){a.ma.fn[b]=function(){var a=this.p();this.ia();this.Yb(a,b,arguments);
        var d=a[b].apply(a,arguments);this.ha();return d===a?this:d}});a.a.r(["slice"],function(b){a.ma.fn[b]=function(){var a=this();return a[b].apply(a,arguments)}});a.b("observableArray",a.ma);a.Aa.trackArrayChanges=function(b,c){function d(){if(!e){e=!0;l=b.notifySubscribers;b.notifySubscribers=function(a,b){b&&b!==E||++h;return l.apply(this,arguments)};var c=[].concat(b.p()||[]);f=null;g=b.Y(function(d){d=[].concat(d||[]);if(b.Ra("arrayChange")){var e;if(!f||1<h)f=a.a.lb(c,d,b.kb);e=f}c=d;f=null;h=0;
        e&&e.length&&b.notifySubscribers(e,"arrayChange")})}}b.kb={};c&&"object"==typeof c&&a.a.extend(b.kb,c);b.kb.sparse=!0;if(!b.Yb){var e=!1,f=null,g,h=0,l,m=b.ua,k=b.Ka;b.ua=function(a){m&&m.call(b,a);"arrayChange"===a&&d()};b.Ka=function(a){k&&k.call(b,a);"arrayChange"!==a||b.Ra("arrayChange")||(l&&(b.notifySubscribers=l,l=n),g.k(),e=!1)};b.Yb=function(b,c,d){function k(a,b,c){return m[m.length]={status:a,value:b,index:c}}if(e&&!h){var m=[],l=b.length,g=d.length,G=0;switch(c){case "push":G=l;case "unshift":for(c=
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              0;c<g;c++)k("added",d[c],G+c);break;case "pop":G=l-1;case "shift":l&&k("deleted",b[G],G);break;case "splice":c=Math.min(Math.max(0,0>d[0]?l+d[0]:d[0]),l);for(var l=1===g?l:Math.min(c+(d[1]||0),l),g=c+g-2,G=Math.max(l,g),n=[],s=[],w=2;c<G;++c,++w)c<l&&s.push(k("deleted",b[c],c)),c<g&&n.push(k("added",d[w],c));a.a.hc(s,n);break;default:return}f=m}}}};var s=a.a.bc("_state");a.m=a.B=function(b,c,d){function e(){if(0<arguments.length){if("function"===typeof f)f.apply(g.sb,arguments);else throw Error("Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.");
        return this}a.l.sc(e);(g.V||g.t&&e.Sa())&&e.U();return g.M}"object"===typeof b?d=b:(d=d||{},b&&(d.read=b));if("function"!=typeof d.read)throw Error("Pass a function that returns the value of the ko.computed");var f=d.write,g={M:n,da:!0,V:!0,Ta:!1,Hb:!1,T:!1,Ya:!1,t:!1,od:d.read,sb:c||d.owner,i:d.disposeWhenNodeIsRemoved||d.i||null,ya:d.disposeWhen||d.ya,pb:null,s:{},L:0,fc:null};e[s]=g;e.$c="function"===typeof f;a.a.la||a.a.extend(e,a.K.fn);a.K.fn.ub(e);a.a.ab(e,z);d.pure?(g.Ya=!0,g.t=!0,a.a.extend(e,
        Y)):d.deferEvaluation&&a.a.extend(e,Z);a.options.deferUpdates&&a.Aa.deferred(e,!0);g.i&&(g.Hb=!0,g.i.nodeType||(g.i=null));g.t||d.deferEvaluation||e.U();g.i&&e.ca()&&a.a.G.qa(g.i,g.pb=function(){e.k()});return e};var z={equalityComparer:J,Ca:function(){return this[s].L},Sb:function(a,c,d){if(this[s].Ya&&c===this)throw Error("A 'pure' computed must not be called recursively");this[s].s[a]=d;d.Ia=this[s].L++;d.pa=c.Pa()},Sa:function(){var a,c,d=this[s].s;for(a in d)if(d.hasOwnProperty(a)&&(c=d[a],this.oa&&
        c.$.Ha||c.$.Zc(c.pa)))return!0},gd:function(){this.oa&&!this[s].Ta&&this.oa(!1)},ca:function(){var a=this[s];return a.V||0<a.L},qd:function(){this.Ha?this[s].V&&(this[s].da=!0):this.ec()},yc:function(a){if(a.gb&&!this[s].i){var c=a.Y(this.gd,this,"dirty"),d=a.Y(this.qd,this);return{$:a,k:function(){c.k();d.k()}}}return a.Y(this.ec,this)},ec:function(){var b=this,c=b.throttleEvaluation;c&&0<=c?(clearTimeout(this[s].fc),this[s].fc=a.a.setTimeout(function(){b.U(!0)},c)):b.oa?b.oa(!0):b.U(!0)},U:function(b){var c=
        this[s],d=c.ya,e=!1;if(!c.Ta&&!c.T){if(c.i&&!a.a.qb(c.i)||d&&d()){if(!c.Hb){this.k();return}}else c.Hb=!1;c.Ta=!0;try{e=this.Vc(b)}finally{c.Ta=!1}c.L||this.k();return e}},Vc:function(b){var c=this[s],d=!1,e=c.Ya?n:!c.L,f={Mc:this,Oa:c.s,ob:c.L};a.l.Xb({Lc:f,jb:W,m:this,Va:e});c.s={};c.L=0;f=this.Uc(c,f);this.Ua(c.M,f)&&(c.t||this.notifySubscribers(c.M,"beforeChange"),c.M=f,c.t?this.Kb():b&&this.notifySubscribers(c.M),d=!0);e&&this.notifySubscribers(c.M,"awake");return d},Uc:function(b,c){try{var d=
        b.od;return b.sb?d.call(b.sb):d()}finally{a.l.end(),c.ob&&!b.t&&a.a.D(c.Oa,V),b.da=b.V=!1}},p:function(a){var c=this[s];(c.V&&(a||!c.L)||c.t&&this.Sa())&&this.U();return c.M},Wa:function(b){a.K.fn.Wa.call(this,b);this.Mb=function(){this[s].da?this.U():this[s].V=!1;return this[s].M};this.oa=function(a){this.Ob(this[s].M);this[s].V=!0;a&&(this[s].da=!0);this.Pb(this)}},k:function(){var b=this[s];!b.t&&b.s&&a.a.D(b.s,function(a,b){b.k&&b.k()});b.i&&b.pb&&a.a.G.tc(b.i,b.pb);b.s=null;b.L=0;b.T=!0;b.da=
        !1;b.V=!1;b.t=!1;b.i=null}},Y={ua:function(b){var c=this,d=c[s];if(!d.T&&d.t&&"change"==b){d.t=!1;if(d.da||c.Sa())d.s=null,d.L=0,c.U()&&c.Kb();else{var e=[];a.a.D(d.s,function(a,b){e[b.Ia]=a});a.a.r(e,function(a,b){var e=d.s[a],l=c.yc(e.$);l.Ia=b;l.pa=e.pa;d.s[a]=l})}d.T||c.notifySubscribers(d.M,"awake")}},Ka:function(b){var c=this[s];c.T||"change"!=b||this.Ra("change")||(a.a.D(c.s,function(a,b){b.k&&(c.s[a]={$:b.$,Ia:b.Ia,pa:b.pa},b.k())}),c.t=!0,this.notifySubscribers(n,"asleep"))},Pa:function(){var b=
        this[s];b.t&&(b.da||this.Sa())&&this.U();return a.K.fn.Pa.call(this)}},Z={ua:function(a){"change"!=a&&"beforeChange"!=a||this.p()}};a.a.la&&a.a.$a(z,a.K.fn);var P=a.O.md;a.m[P]=a.O;z[P]=a.m;a.bd=function(b){return a.Qa(b,a.m)};a.cd=function(b){return a.Qa(b,a.m)&&b[s]&&b[s].Ya};a.b("computed",a.m);a.b("dependentObservable",a.m);a.b("isComputed",a.bd);a.b("isPureComputed",a.cd);a.b("computed.fn",z);a.H(z,"peek",z.p);a.H(z,"dispose",z.k);a.H(z,"isActive",z.ca);a.H(z,"getDependenciesCount",z.Ca);a.rc=
        function(b,c){if("function"===typeof b)return a.m(b,c,{pure:!0});b=a.a.extend({},b);b.pure=!0;return a.m(b,c)};a.b("pureComputed",a.rc);(function(){function b(a,f,g){g=g||new d;a=f(a);if("object"!=typeof a||null===a||a===n||a instanceof RegExp||a instanceof Date||a instanceof String||a instanceof Number||a instanceof Boolean)return a;var h=a instanceof Array?[]:{};g.save(a,h);c(a,function(c){var d=f(a[c]);switch(typeof d){case "boolean":case "number":case "string":case "function":h[c]=d;break;case "object":case "undefined":var k=
        g.get(d);h[c]=k!==n?k:b(d,f,g)}});return h}function c(a,b){if(a instanceof Array){for(var c=0;c<a.length;c++)b(c);"function"==typeof a.toJSON&&b("toJSON")}else for(c in a)b(c)}function d(){this.keys=[];this.Lb=[]}a.Ac=function(c){if(0==arguments.length)throw Error("When calling ko.toJS, pass the object you want to convert.");return b(c,function(b){for(var c=0;a.I(b)&&10>c;c++)b=b();return b})};a.toJSON=function(b,c,d){b=a.Ac(b);return a.a.Gb(b,c,d)};d.prototype={save:function(b,c){var d=a.a.o(this.keys,
        b);0<=d?this.Lb[d]=c:(this.keys.push(b),this.Lb.push(c))},get:function(b){b=a.a.o(this.keys,b);return 0<=b?this.Lb[b]:n}}})();a.b("toJS",a.Ac);a.b("toJSON",a.toJSON);(function(){a.j={u:function(b){switch(a.a.A(b)){case "option":return!0===b.__ko__hasDomDataOptionValue__?a.a.e.get(b,a.d.options.zb):7>=a.a.C?b.getAttributeNode("value")&&b.getAttributeNode("value").specified?b.value:b.text:b.value;case "select":return 0<=b.selectedIndex?a.j.u(b.options[b.selectedIndex]):n;default:return b.value}},ja:function(b,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       c,d){switch(a.a.A(b)){case "option":switch(typeof c){case "string":a.a.e.set(b,a.d.options.zb,n);"__ko__hasDomDataOptionValue__"in b&&delete b.__ko__hasDomDataOptionValue__;b.value=c;break;default:a.a.e.set(b,a.d.options.zb,c),b.__ko__hasDomDataOptionValue__=!0,b.value="number"===typeof c?c:""}break;case "select":if(""===c||null===c)c=n;for(var e=-1,f=0,g=b.options.length,h;f<g;++f)if(h=a.j.u(b.options[f]),h==c||""==h&&c===n){e=f;break}if(d||0<=e||c===n&&1<b.size)b.selectedIndex=e;break;default:if(null===
        c||c===n)c="";b.value=c}}}})();a.b("selectExtensions",a.j);a.b("selectExtensions.readValue",a.j.u);a.b("selectExtensions.writeValue",a.j.ja);a.h=function(){function b(b){b=a.a.cb(b);123===b.charCodeAt(0)&&(b=b.slice(1,-1));var c=[],d=b.match(e),r,h=[],p=0;if(d){d.push(",");for(var A=0,y;y=d[A];++A){var v=y.charCodeAt(0);if(44===v){if(0>=p){c.push(r&&h.length?{key:r,value:h.join("")}:{unknown:r||h.join("")});r=p=0;h=[];continue}}else if(58===v){if(!p&&!r&&1===h.length){r=h.pop();continue}}else 47===
    v&&A&&1<y.length?(v=d[A-1].match(f))&&!g[v[0]]&&(b=b.substr(b.indexOf(y)+1),d=b.match(e),d.push(","),A=-1,y="/"):40===v||123===v||91===v?++p:41===v||125===v||93===v?--p:r||h.length||34!==v&&39!==v||(y=y.slice(1,-1));h.push(y)}}return c}var c=["true","false","null","undefined"],d=/^(?:[$_a-z][$\w]*|(.+)(\.\s*[$_a-z][$\w]*|\[.+\]))$/i,e=RegExp("\"(?:[^\"\\\\]|\\\\.)*\"|'(?:[^'\\\\]|\\\\.)*'|/(?:[^/\\\\]|\\\\.)*/w*|[^\\s:,/][^,\"'{}()/:[\\]]*[^\\s,\"'{}()/:[\\]]|[^\\s]","g"),f=/[\])"'A-Za-z0-9_$]+$/,
        g={"in":1,"return":1,"typeof":1},h={};return{va:[],ga:h,Ab:b,Xa:function(e,m){function k(b,e){var m;if(!A){var l=a.getBindingHandler(b);if(l&&l.preprocess&&!(e=l.preprocess(e,b,k)))return;if(l=h[b])m=e,0<=a.a.o(c,m)?m=!1:(l=m.match(d),m=null===l?!1:l[1]?"Object("+l[1]+")"+l[2]:m),l=m;l&&g.push("'"+b+"':function(_z){"+m+"=_z}")}p&&(e="function(){return "+e+" }");f.push("'"+b+"':"+e)}m=m||{};var f=[],g=[],p=m.valueAccessors,A=m.bindingParams,y="string"===typeof e?b(e):e;a.a.r(y,function(a){k(a.key||
        a.unknown,a.value)});g.length&&k("_ko_property_writers","{"+g.join(",")+" }");return f.join(",")},fd:function(a,b){for(var c=0;c<a.length;c++)if(a[c].key==b)return!0;return!1},Ga:function(b,c,d,e,f){if(b&&a.I(b))!a.Da(b)||f&&b.p()===e||b(e);else if((b=c.get("_ko_property_writers"))&&b[d])b[d](e)}}}();a.b("expressionRewriting",a.h);a.b("expressionRewriting.bindingRewriteValidators",a.h.va);a.b("expressionRewriting.parseObjectLiteral",a.h.Ab);a.b("expressionRewriting.preProcessBindings",a.h.Xa);a.b("expressionRewriting._twoWayBindings",
        a.h.ga);a.b("jsonExpressionRewriting",a.h);a.b("jsonExpressionRewriting.insertPropertyAccessorsIntoJson",a.h.Xa);(function(){function b(a){return 8==a.nodeType&&g.test(f?a.text:a.nodeValue)}function c(a){return 8==a.nodeType&&h.test(f?a.text:a.nodeValue)}function d(a,d){for(var e=a,f=1,l=[];e=e.nextSibling;){if(c(e)&&(f--,0===f))return l;l.push(e);b(e)&&f++}if(!d)throw Error("Cannot find closing comment tag to match: "+a.nodeValue);return null}function e(a,b){var c=d(a,b);return c?0<c.length?c[c.length-
    1].nextSibling:a.nextSibling:null}var f=t&&"\x3c!--test--\x3e"===t.createComment("test").text,g=f?/^\x3c!--\s*ko(?:\s+([\s\S]+))?\s*--\x3e$/:/^\s*ko(?:\s+([\s\S]+))?\s*$/,h=f?/^\x3c!--\s*\/ko\s*--\x3e$/:/^\s*\/ko\s*$/,l={ul:!0,ol:!0};a.f={aa:{},childNodes:function(a){return b(a)?d(a):a.childNodes},za:function(c){if(b(c)){c=a.f.childNodes(c);for(var d=0,e=c.length;d<e;d++)a.removeNode(c[d])}else a.a.rb(c)},fa:function(c,d){if(b(c)){a.f.za(c);for(var e=c.nextSibling,f=0,l=d.length;f<l;f++)e.parentNode.insertBefore(d[f],
        e)}else a.a.fa(c,d)},qc:function(a,c){b(a)?a.parentNode.insertBefore(c,a.nextSibling):a.firstChild?a.insertBefore(c,a.firstChild):a.appendChild(c)},kc:function(c,d,e){e?b(c)?c.parentNode.insertBefore(d,e.nextSibling):e.nextSibling?c.insertBefore(d,e.nextSibling):c.appendChild(d):a.f.qc(c,d)},firstChild:function(a){return b(a)?!a.nextSibling||c(a.nextSibling)?null:a.nextSibling:a.firstChild},nextSibling:function(a){b(a)&&(a=e(a));return a.nextSibling&&c(a.nextSibling)?null:a.nextSibling},Yc:b,vd:function(a){return(a=
        (f?a.text:a.nodeValue).match(g))?a[1]:null},oc:function(d){if(l[a.a.A(d)]){var k=d.firstChild;if(k){do if(1===k.nodeType){var f;f=k.firstChild;var g=null;if(f){do if(g)g.push(f);else if(b(f)){var h=e(f,!0);h?f=h:g=[f]}else c(f)&&(g=[f]);while(f=f.nextSibling)}if(f=g)for(g=k.nextSibling,h=0;h<f.length;h++)g?d.insertBefore(f[h],g):d.appendChild(f[h])}while(k=k.nextSibling)}}}}})();a.b("virtualElements",a.f);a.b("virtualElements.allowedBindings",a.f.aa);a.b("virtualElements.emptyNode",a.f.za);a.b("virtualElements.insertAfter",
        a.f.kc);a.b("virtualElements.prepend",a.f.qc);a.b("virtualElements.setDomNodeChildren",a.f.fa);(function(){a.S=function(){this.Kc={}};a.a.extend(a.S.prototype,{nodeHasBindings:function(b){switch(b.nodeType){case 1:return null!=b.getAttribute("data-bind")||a.g.getComponentNameForNode(b);case 8:return a.f.Yc(b);default:return!1}},getBindings:function(b,c){var d=this.getBindingsString(b,c),d=d?this.parseBindingsString(d,c,b):null;return a.g.Rb(d,b,c,!1)},getBindingAccessors:function(b,c){var d=this.getBindingsString(b,
        c),d=d?this.parseBindingsString(d,c,b,{valueAccessors:!0}):null;return a.g.Rb(d,b,c,!0)},getBindingsString:function(b){switch(b.nodeType){case 1:return b.getAttribute("data-bind");case 8:return a.f.vd(b);default:return null}},parseBindingsString:function(b,c,d,e){try{var f=this.Kc,g=b+(e&&e.valueAccessors||""),h;if(!(h=f[g])){var l,m="with($context){with($data||{}){return{"+a.h.Xa(b,e)+"}}}";l=new Function("$context","$element",m);h=f[g]=l}return h(c,d)}catch(k){throw k.message="Unable to parse bindings.\nBindings value: "+
        b+"\nMessage: "+k.message,k;}}});a.S.instance=new a.S})();a.b("bindingProvider",a.S);(function(){function b(a){return function(){return a}}function c(a){return a()}function d(b){return a.a.Ea(a.l.w(b),function(a,c){return function(){return b()[c]}})}function e(c,e,k){return"function"===typeof c?d(c.bind(null,e,k)):a.a.Ea(c,b)}function f(a,b){return d(this.getBindings.bind(this,a,b))}function g(b,c,d){var e,k=a.f.firstChild(c),f=a.S.instance,m=f.preprocessNode;if(m){for(;e=k;)k=a.f.nextSibling(e),
        m.call(f,e);k=a.f.firstChild(c)}for(;e=k;)k=a.f.nextSibling(e),h(b,e,d)}function h(b,c,d){var e=!0,k=1===c.nodeType;k&&a.f.oc(c);if(k&&d||a.S.instance.nodeHasBindings(c))e=m(c,null,b,d).shouldBindDescendants;e&&!r[a.a.A(c)]&&g(b,c,!k)}function l(b){var c=[],d={},e=[];a.a.D(b,function X(k){if(!d[k]){var f=a.getBindingHandler(k);f&&(f.after&&(e.push(k),a.a.r(f.after,function(c){if(b[c]){if(-1!==a.a.o(e,c))throw Error("Cannot combine the following bindings, because they have a cyclic dependency: "+e.join(", "));
        X(c)}}),e.length--),c.push({key:k,jc:f}));d[k]=!0}});return c}function m(b,d,e,k){var m=a.a.e.get(b,q);if(!d){if(m)throw Error("You cannot apply bindings multiple times to the same element.");a.a.e.set(b,q,!0)}!m&&k&&a.xc(b,e);var g;if(d&&"function"!==typeof d)g=d;else{var h=a.S.instance,r=h.getBindingAccessors||f,p=a.B(function(){(g=d?d(e,b):r.call(h,b,e))&&e.Q&&e.Q();return g},null,{i:b});g&&p.ca()||(p=null)}var s;if(g){var t=p?function(a){return function(){return c(p()[a])}}:function(a){return g[a]},
        u=function(){return a.a.Ea(p?p():g,c)};u.get=function(a){return g[a]&&c(t(a))};u.has=function(a){return a in g};k=l(g);a.a.r(k,function(c){var d=c.jc.init,k=c.jc.update,f=c.key;if(8===b.nodeType&&!a.f.aa[f])throw Error("The binding '"+f+"' cannot be used with virtual elements");try{"function"==typeof d&&a.l.w(function(){var a=d(b,t(f),u,e.$data,e);if(a&&a.controlsDescendantBindings){if(s!==n)throw Error("Multiple bindings ("+s+" and "+f+") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.");
        s=f}}),"function"==typeof k&&a.B(function(){k(b,t(f),u,e.$data,e)},null,{i:b})}catch(m){throw m.message='Unable to process binding "'+f+": "+g[f]+'"\nMessage: '+m.message,m;}})}return{shouldBindDescendants:s===n}}function k(b){return b&&b instanceof a.R?b:new a.R(b)}a.d={};var r={script:!0,textarea:!0,template:!0};a.getBindingHandler=function(b){return a.d[b]};a.R=function(b,c,d,e,k){function f(){var k=g?b():b,m=a.a.c(k);c?(c.Q&&c.Q(),a.a.extend(l,c),l.Q=r):(l.$parents=[],l.$root=m,l.ko=a);l.$rawData=
        k;l.$data=m;d&&(l[d]=m);e&&e(l,c,m);return l.$data}function m(){return h&&!a.a.Tb(h)}var l=this,g="function"==typeof b&&!a.I(b),h,r;k&&k.exportDependencies?f():(r=a.B(f,null,{ya:m,i:!0}),r.ca()&&(l.Q=r,r.equalityComparer=null,h=[],r.Dc=function(b){h.push(b);a.a.G.qa(b,function(b){a.a.Na(h,b);h.length||(r.k(),l.Q=r=n)})}))};a.R.prototype.createChildContext=function(b,c,d,e){return new a.R(b,this,c,function(a,b){a.$parentContext=b;a.$parent=b.$data;a.$parents=(b.$parents||[]).slice(0);a.$parents.unshift(a.$parent);
        d&&d(a)},e)};a.R.prototype.extend=function(b){return new a.R(this.Q||this.$data,this,null,function(c,d){c.$rawData=d.$rawData;a.a.extend(c,"function"==typeof b?b():b)})};a.R.prototype.ac=function(a,b){return this.createChildContext(a,b,null,{exportDependencies:!0})};var q=a.a.e.J(),p=a.a.e.J();a.xc=function(b,c){if(2==arguments.length)a.a.e.set(b,p,c),c.Q&&c.Q.Dc(b);else return a.a.e.get(b,p)};a.La=function(b,c,d){1===b.nodeType&&a.f.oc(b);return m(b,c,k(d),!0)};a.Ic=function(b,c,d){d=k(d);return a.La(b,
        e(c,d,b),d)};a.hb=function(a,b){1!==b.nodeType&&8!==b.nodeType||g(k(a),b,!0)};a.Ub=function(a,b){!u&&x.jQuery&&(u=x.jQuery);if(b&&1!==b.nodeType&&8!==b.nodeType)throw Error("ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node");b=b||x.document.body;h(k(a),b,!0)};a.nb=function(b){switch(b.nodeType){case 1:case 8:var c=a.xc(b);if(c)return c;if(b.parentNode)return a.nb(b.parentNode)}return n};a.Oc=function(b){return(b=a.nb(b))?b.$data:n};a.b("bindingHandlers",
        a.d);a.b("applyBindings",a.Ub);a.b("applyBindingsToDescendants",a.hb);a.b("applyBindingAccessorsToNode",a.La);a.b("applyBindingsToNode",a.Ic);a.b("contextFor",a.nb);a.b("dataFor",a.Oc)})();(function(b){function c(c,e){var m=f.hasOwnProperty(c)?f[c]:b,k;m?m.Y(e):(m=f[c]=new a.K,m.Y(e),d(c,function(b,d){var e=!(!d||!d.synchronous);g[c]={definition:b,dd:e};delete f[c];k||e?m.notifySubscribers(b):a.Z.Za(function(){m.notifySubscribers(b)})}),k=!0)}function d(a,b){e("getConfig",[a],function(c){c?e("loadComponent",
        [a,c],function(a){b(a,c)}):b(null,null)})}function e(c,d,f,k){k||(k=a.g.loaders.slice(0));var g=k.shift();if(g){var q=g[c];if(q){var p=!1;if(q.apply(g,d.concat(function(a){p?f(null):null!==a?f(a):e(c,d,f,k)}))!==b&&(p=!0,!g.suppressLoaderExceptions))throw Error("Component loaders must supply values by invoking the callback, not by returning values synchronously.");}else e(c,d,f,k)}else f(null)}var f={},g={};a.g={get:function(d,e){var f=g.hasOwnProperty(d)?g[d]:b;f?f.dd?a.l.w(function(){e(f.definition)}):
        a.Z.Za(function(){e(f.definition)}):c(d,e)},$b:function(a){delete g[a]},Nb:e};a.g.loaders=[];a.b("components",a.g);a.b("components.get",a.g.get);a.b("components.clearCachedDefinition",a.g.$b)})();(function(){function b(b,c,d,e){function g(){0===--y&&e(h)}var h={},y=2,v=d.template;d=d.viewModel;v?f(c,v,function(c){a.g.Nb("loadTemplate",[b,c],function(a){h.template=a;g()})}):g();d?f(c,d,function(c){a.g.Nb("loadViewModel",[b,c],function(a){h[l]=a;g()})}):g()}function c(a,b,d){if("function"===typeof b)d(function(a){return new b(a)});
    else if("function"===typeof b[l])d(b[l]);else if("instance"in b){var e=b.instance;d(function(){return e})}else"viewModel"in b?c(a,b.viewModel,d):a("Unknown viewModel value: "+b)}function d(b){switch(a.a.A(b)){case "script":return a.a.na(b.text);case "textarea":return a.a.na(b.value);case "template":if(e(b.content))return a.a.wa(b.content.childNodes)}return a.a.wa(b.childNodes)}function e(a){return x.DocumentFragment?a instanceof DocumentFragment:a&&11===a.nodeType}function f(a,b,c){"string"===typeof b.require?
        O||x.require?(O||x.require)([b.require],c):a("Uses require, but no AMD loader is present"):c(b)}function g(a){return function(b){throw Error("Component '"+a+"': "+b);}}var h={};a.g.register=function(b,c){if(!c)throw Error("Invalid configuration for "+b);if(a.g.wb(b))throw Error("Component "+b+" is already registered");h[b]=c};a.g.wb=function(a){return h.hasOwnProperty(a)};a.g.ud=function(b){delete h[b];a.g.$b(b)};a.g.cc={getConfig:function(a,b){b(h.hasOwnProperty(a)?h[a]:null)},loadComponent:function(a,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  c,d){var e=g(a);f(e,c,function(c){b(a,e,c,d)})},loadTemplate:function(b,c,f){b=g(b);if("string"===typeof c)f(a.a.na(c));else if(c instanceof Array)f(c);else if(e(c))f(a.a.W(c.childNodes));else if(c.element)if(c=c.element,x.HTMLElement?c instanceof HTMLElement:c&&c.tagName&&1===c.nodeType)f(d(c));else if("string"===typeof c){var l=t.getElementById(c);l?f(d(l)):b("Cannot find element with ID "+c)}else b("Unknown element type: "+c);else b("Unknown template value: "+c)},loadViewModel:function(a,b,d){c(g(a),
        b,d)}};var l="createViewModel";a.b("components.register",a.g.register);a.b("components.isRegistered",a.g.wb);a.b("components.unregister",a.g.ud);a.b("components.defaultLoader",a.g.cc);a.g.loaders.push(a.g.cc);a.g.Ec=h})();(function(){function b(b,e){var f=b.getAttribute("params");if(f){var f=c.parseBindingsString(f,e,b,{valueAccessors:!0,bindingParams:!0}),f=a.a.Ea(f,function(c){return a.m(c,null,{i:b})}),g=a.a.Ea(f,function(c){var e=c.p();return c.ca()?a.m({read:function(){return a.a.c(c())},write:a.Da(e)&&
    function(a){c()(a)},i:b}):e});g.hasOwnProperty("$raw")||(g.$raw=f);return g}return{$raw:{}}}a.g.getComponentNameForNode=function(b){var c=a.a.A(b);if(a.g.wb(c)&&(-1!=c.indexOf("-")||"[object HTMLUnknownElement]"==""+b||8>=a.a.C&&b.tagName===c))return c};a.g.Rb=function(c,e,f,g){if(1===e.nodeType){var h=a.g.getComponentNameForNode(e);if(h){c=c||{};if(c.component)throw Error('Cannot use the "component" binding on a custom element matching a component');var l={name:h,params:b(e,f)};c.component=g?function(){return l}:
        l}}return c};var c=new a.S;9>a.a.C&&(a.g.register=function(a){return function(b){t.createElement(b);return a.apply(this,arguments)}}(a.g.register),t.createDocumentFragment=function(b){return function(){var c=b(),f=a.g.Ec,g;for(g in f)f.hasOwnProperty(g)&&c.createElement(g);return c}}(t.createDocumentFragment))})();(function(b){function c(b,c,d){c=c.template;if(!c)throw Error("Component '"+b+"' has no template");b=a.a.wa(c);a.f.fa(d,b)}function d(a,b,c,d){var e=a.createViewModel;return e?e.call(a,
        d,{element:b,templateNodes:c}):d}var e=0;a.d.component={init:function(f,g,h,l,m){function k(){var a=r&&r.dispose;"function"===typeof a&&a.call(r);q=r=null}var r,q,p=a.a.W(a.f.childNodes(f));a.a.G.qa(f,k);a.m(function(){var l=a.a.c(g()),h,v;"string"===typeof l?h=l:(h=a.a.c(l.name),v=a.a.c(l.params));if(!h)throw Error("No component name specified");var n=q=++e;a.g.get(h,function(e){if(q===n){k();if(!e)throw Error("Unknown component '"+h+"'");c(h,e,f);var l=d(e,f,p,v);e=m.createChildContext(l,b,function(a){a.$component=
        l;a.$componentTemplateNodes=p});r=l;a.hb(e,f)}})},null,{i:f});return{controlsDescendantBindings:!0}}};a.f.aa.component=!0})();var Q={"class":"className","for":"htmlFor"};a.d.attr={update:function(b,c){var d=a.a.c(c())||{};a.a.D(d,function(c,d){d=a.a.c(d);var g=!1===d||null===d||d===n;g&&b.removeAttribute(c);8>=a.a.C&&c in Q?(c=Q[c],g?b.removeAttribute(c):b[c]=d):g||b.setAttribute(c,d.toString());"name"===c&&a.a.vc(b,g?"":d.toString())})}};(function(){a.d.checked={after:["value","attr"],init:function(b,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 c,d){function e(){var e=b.checked,f=p?g():e;if(!a.xa.Va()&&(!l||e)){var h=a.l.w(c);if(k){var m=r?h.p():h;q!==f?(e&&(a.a.ra(m,f,!0),a.a.ra(m,q,!1)),q=f):a.a.ra(m,f,e);r&&a.Da(h)&&h(m)}else a.h.Ga(h,d,"checked",f,!0)}}function f(){var d=a.a.c(c());b.checked=k?0<=a.a.o(d,g()):h?d:g()===d}var g=a.rc(function(){return d.has("checkedValue")?a.a.c(d.get("checkedValue")):d.has("value")?a.a.c(d.get("value")):b.value}),h="checkbox"==b.type,l="radio"==b.type;if(h||l){var m=c(),k=h&&a.a.c(m)instanceof Array,
        r=!(k&&m.push&&m.splice),q=k?g():n,p=l||k;l&&!b.name&&a.d.uniqueName.init(b,function(){return!0});a.m(e,null,{i:b});a.a.q(b,"click",e);a.m(f,null,{i:b});m=n}}};a.h.ga.checked=!0;a.d.checkedValue={update:function(b,c){b.value=a.a.c(c())}}})();a.d.css={update:function(b,c){var d=a.a.c(c());null!==d&&"object"==typeof d?a.a.D(d,function(c,d){d=a.a.c(d);a.a.fb(b,c,d)}):(d=a.a.cb(String(d||"")),a.a.fb(b,b.__ko__cssValue,!1),b.__ko__cssValue=d,a.a.fb(b,d,!0))}};a.d.enable={update:function(b,c){var d=a.a.c(c());
        d&&b.disabled?b.removeAttribute("disabled"):d||b.disabled||(b.disabled=!0)}};a.d.disable={update:function(b,c){a.d.enable.update(b,function(){return!a.a.c(c())})}};a.d.event={init:function(b,c,d,e,f){var g=c()||{};a.a.D(g,function(g){"string"==typeof g&&a.a.q(b,g,function(b){var m,k=c()[g];if(k){try{var r=a.a.W(arguments);e=f.$data;r.unshift(e);m=k.apply(e,r)}finally{!0!==m&&(b.preventDefault?b.preventDefault():b.returnValue=!1)}!1===d.get(g+"Bubble")&&(b.cancelBubble=!0,b.stopPropagation&&b.stopPropagation())}})})}};
    a.d.foreach={mc:function(b){return function(){var c=b(),d=a.a.Bb(c);if(!d||"number"==typeof d.length)return{foreach:c,templateEngine:a.X.vb};a.a.c(c);return{foreach:d.data,as:d.as,includeDestroyed:d.includeDestroyed,afterAdd:d.afterAdd,beforeRemove:d.beforeRemove,afterRender:d.afterRender,beforeMove:d.beforeMove,afterMove:d.afterMove,templateEngine:a.X.vb}}},init:function(b,c){return a.d.template.init(b,a.d.foreach.mc(c))},update:function(b,c,d,e,f){return a.d.template.update(b,a.d.foreach.mc(c),
        d,e,f)}};a.h.va.foreach=!1;a.f.aa.foreach=!0;a.d.hasfocus={init:function(b,c,d){function e(e){b.__ko_hasfocusUpdating=!0;var f=b.ownerDocument;if("activeElement"in f){var g;try{g=f.activeElement}catch(k){g=f.body}e=g===b}f=c();a.h.Ga(f,d,"hasfocus",e,!0);b.__ko_hasfocusLastValue=e;b.__ko_hasfocusUpdating=!1}var f=e.bind(null,!0),g=e.bind(null,!1);a.a.q(b,"focus",f);a.a.q(b,"focusin",f);a.a.q(b,"blur",g);a.a.q(b,"focusout",g)},update:function(b,c){var d=!!a.a.c(c());b.__ko_hasfocusUpdating||b.__ko_hasfocusLastValue===
    d||(d?b.focus():b.blur(),!d&&b.__ko_hasfocusLastValue&&b.ownerDocument.body.focus(),a.l.w(a.a.Fa,null,[b,d?"focusin":"focusout"]))}};a.h.ga.hasfocus=!0;a.d.hasFocus=a.d.hasfocus;a.h.ga.hasFocus=!0;a.d.html={init:function(){return{controlsDescendantBindings:!0}},update:function(b,c){a.a.Eb(b,c())}};K("if");K("ifnot",!1,!0);K("with",!0,!1,function(a,c){return a.ac(c)});var L={};a.d.options={init:function(b){if("select"!==a.a.A(b))throw Error("options binding applies only to SELECT elements");for(;0<
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        b.length;)b.remove(0);return{controlsDescendantBindings:!0}},update:function(b,c,d){function e(){return a.a.Ma(b.options,function(a){return a.selected})}function f(a,b,c){var d=typeof b;return"function"==d?b(a):"string"==d?a[b]:c}function g(c,e){if(A&&k)a.j.ja(b,a.a.c(d.get("value")),!0);else if(p.length){var f=0<=a.a.o(p,a.j.u(e[0]));a.a.wc(e[0],f);A&&!f&&a.l.w(a.a.Fa,null,[b,"change"])}}var h=b.multiple,l=0!=b.length&&h?b.scrollTop:null,m=a.a.c(c()),k=d.get("valueAllowUnset")&&d.has("value"),r=
        d.get("optionsIncludeDestroyed");c={};var q,p=[];k||(h?p=a.a.ib(e(),a.j.u):0<=b.selectedIndex&&p.push(a.j.u(b.options[b.selectedIndex])));m&&("undefined"==typeof m.length&&(m=[m]),q=a.a.Ma(m,function(b){return r||b===n||null===b||!a.a.c(b._destroy)}),d.has("optionsCaption")&&(m=a.a.c(d.get("optionsCaption")),null!==m&&m!==n&&q.unshift(L)));var A=!1;c.beforeRemove=function(a){b.removeChild(a)};m=g;d.has("optionsAfterRender")&&"function"==typeof d.get("optionsAfterRender")&&(m=function(b,c){g(0,c);
        a.l.w(d.get("optionsAfterRender"),null,[c[0],b!==L?b:n])});a.a.Db(b,q,function(c,e,g){g.length&&(p=!k&&g[0].selected?[a.j.u(g[0])]:[],A=!0);e=b.ownerDocument.createElement("option");c===L?(a.a.bb(e,d.get("optionsCaption")),a.j.ja(e,n)):(g=f(c,d.get("optionsValue"),c),a.j.ja(e,a.a.c(g)),c=f(c,d.get("optionsText"),g),a.a.bb(e,c));return[e]},c,m);a.l.w(function(){k?a.j.ja(b,a.a.c(d.get("value")),!0):(h?p.length&&e().length<p.length:p.length&&0<=b.selectedIndex?a.j.u(b.options[b.selectedIndex])!==p[0]:
        p.length||0<=b.selectedIndex)&&a.a.Fa(b,"change")});a.a.Sc(b);l&&20<Math.abs(l-b.scrollTop)&&(b.scrollTop=l)}};a.d.options.zb=a.a.e.J();a.d.selectedOptions={after:["options","foreach"],init:function(b,c,d){a.a.q(b,"change",function(){var e=c(),f=[];a.a.r(b.getElementsByTagName("option"),function(b){b.selected&&f.push(a.j.u(b))});a.h.Ga(e,d,"selectedOptions",f)})},update:function(b,c){if("select"!=a.a.A(b))throw Error("values binding applies only to SELECT elements");var d=a.a.c(c()),e=b.scrollTop;
        d&&"number"==typeof d.length&&a.a.r(b.getElementsByTagName("option"),function(b){var c=0<=a.a.o(d,a.j.u(b));b.selected!=c&&a.a.wc(b,c)});b.scrollTop=e}};a.h.ga.selectedOptions=!0;a.d.style={update:function(b,c){var d=a.a.c(c()||{});a.a.D(d,function(c,d){d=a.a.c(d);if(null===d||d===n||!1===d)d="";b.style[c]=d})}};a.d.submit={init:function(b,c,d,e,f){if("function"!=typeof c())throw Error("The value for a submit binding must be a function");a.a.q(b,"submit",function(a){var d,e=c();try{d=e.call(f.$data,
        b)}finally{!0!==d&&(a.preventDefault?a.preventDefault():a.returnValue=!1)}})}};a.d.text={init:function(){return{controlsDescendantBindings:!0}},update:function(b,c){a.a.bb(b,c())}};a.f.aa.text=!0;(function(){if(x&&x.navigator)var b=function(a){if(a)return parseFloat(a[1])},c=x.opera&&x.opera.version&&parseInt(x.opera.version()),d=x.navigator.userAgent,e=b(d.match(/^(?:(?!chrome).)*version\/([^ ]*) safari/i)),f=b(d.match(/Firefox\/([^ ]*)/));if(10>a.a.C)var g=a.a.e.J(),h=a.a.e.J(),l=function(b){var c=
        this.activeElement;(c=c&&a.a.e.get(c,h))&&c(b)},m=function(b,c){var d=b.ownerDocument;a.a.e.get(d,g)||(a.a.e.set(d,g,!0),a.a.q(d,"selectionchange",l));a.a.e.set(b,h,c)};a.d.textInput={init:function(b,d,g){function l(c,d){a.a.q(b,c,d)}function h(){var c=a.a.c(d());if(null===c||c===n)c="";u!==n&&c===u?a.a.setTimeout(h,4):b.value!==c&&(s=c,b.value=c)}function y(){t||(u=b.value,t=a.a.setTimeout(v,4))}function v(){clearTimeout(t);u=t=n;var c=b.value;s!==c&&(s=c,a.h.Ga(d(),g,"textInput",c))}var s=b.value,
        t,u,x=9==a.a.C?y:v;10>a.a.C?(l("propertychange",function(a){"value"===a.propertyName&&x(a)}),8==a.a.C&&(l("keyup",v),l("keydown",v)),8<=a.a.C&&(m(b,x),l("dragend",y))):(l("input",v),5>e&&"textarea"===a.a.A(b)?(l("keydown",y),l("paste",y),l("cut",y)):11>c?l("keydown",y):4>f&&(l("DOMAutoComplete",v),l("dragdrop",v),l("drop",v)));l("change",v);a.m(h,null,{i:b})}};a.h.ga.textInput=!0;a.d.textinput={preprocess:function(a,b,c){c("textInput",a)}}})();a.d.uniqueName={init:function(b,c){if(c()){var d="ko_unique_"+
        ++a.d.uniqueName.Nc;a.a.vc(b,d)}}};a.d.uniqueName.Nc=0;a.d.value={after:["options","foreach"],init:function(b,c,d){if("input"!=b.tagName.toLowerCase()||"checkbox"!=b.type&&"radio"!=b.type){var e=["change"],f=d.get("valueUpdate"),g=!1,h=null;f&&("string"==typeof f&&(f=[f]),a.a.ta(e,f),e=a.a.Wb(e));var l=function(){h=null;g=!1;var e=c(),f=a.j.u(b);a.h.Ga(e,d,"value",f)};!a.a.C||"input"!=b.tagName.toLowerCase()||"text"!=b.type||"off"==b.autocomplete||b.form&&"off"==b.form.autocomplete||-1!=a.a.o(e,"propertychange")||
    (a.a.q(b,"propertychange",function(){g=!0}),a.a.q(b,"focus",function(){g=!1}),a.a.q(b,"blur",function(){g&&l()}));a.a.r(e,function(c){var d=l;a.a.sd(c,"after")&&(d=function(){h=a.j.u(b);a.a.setTimeout(l,0)},c=c.substring(5));a.a.q(b,c,d)});var m=function(){var e=a.a.c(c()),f=a.j.u(b);if(null!==h&&e===h)a.a.setTimeout(m,0);else if(e!==f)if("select"===a.a.A(b)){var g=d.get("valueAllowUnset"),f=function(){a.j.ja(b,e,g)};f();g||e===a.j.u(b)?a.a.setTimeout(f,0):a.l.w(a.a.Fa,null,[b,"change"])}else a.j.ja(b,
        e)};a.m(m,null,{i:b})}else a.La(b,{checkedValue:c})},update:function(){}};a.h.ga.value=!0;a.d.visible={update:function(b,c){var d=a.a.c(c()),e="none"!=b.style.display;d&&!e?b.style.display="":!d&&e&&(b.style.display="none")}};(function(b){a.d[b]={init:function(c,d,e,f,g){return a.d.event.init.call(this,c,function(){var a={};a[b]=d();return a},e,f,g)}}})("click");a.P=function(){};a.P.prototype.renderTemplateSource=function(){throw Error("Override renderTemplateSource");};a.P.prototype.createJavaScriptEvaluatorBlock=
        function(){throw Error("Override createJavaScriptEvaluatorBlock");};a.P.prototype.makeTemplateSource=function(b,c){if("string"==typeof b){c=c||t;var d=c.getElementById(b);if(!d)throw Error("Cannot find template with ID "+b);return new a.v.n(d)}if(1==b.nodeType||8==b.nodeType)return new a.v.sa(b);throw Error("Unknown template type: "+b);};a.P.prototype.renderTemplate=function(a,c,d,e){a=this.makeTemplateSource(a,e);return this.renderTemplateSource(a,c,d,e)};a.P.prototype.isTemplateRewritten=function(a,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                c){return!1===this.allowTemplateRewriting?!0:this.makeTemplateSource(a,c).data("isRewritten")};a.P.prototype.rewriteTemplate=function(a,c,d){a=this.makeTemplateSource(a,d);c=c(a.text());a.text(c);a.data("isRewritten",!0)};a.b("templateEngine",a.P);a.Ib=function(){function b(b,c,d,h){b=a.h.Ab(b);for(var l=a.h.va,m=0;m<b.length;m++){var k=b[m].key;if(l.hasOwnProperty(k)){var r=l[k];if("function"===typeof r){if(k=r(b[m].value))throw Error(k);}else if(!r)throw Error("This template engine does not support the '"+
        k+"' binding within its templates");}}d="ko.__tr_ambtns(function($context,$element){return(function(){return{ "+a.h.Xa(b,{valueAccessors:!0})+" } })()},'"+d.toLowerCase()+"')";return h.createJavaScriptEvaluatorBlock(d)+c}var c=/(<([a-z]+\d*)(?:\s+(?!data-bind\s*=\s*)[a-z0-9\-]+(?:=(?:\"[^\"]*\"|\'[^\']*\'|[^>]*))?)*\s+)data-bind\s*=\s*(["'])([\s\S]*?)\3/gi,d=/\x3c!--\s*ko\b\s*([\s\S]*?)\s*--\x3e/g;return{Tc:function(b,c,d){c.isTemplateRewritten(b,d)||c.rewriteTemplate(b,function(b){return a.Ib.jd(b,
        c)},d)},jd:function(a,f){return a.replace(c,function(a,c,d,e,k){return b(k,c,d,f)}).replace(d,function(a,c){return b(c,"\x3c!-- ko --\x3e","#comment",f)})},Jc:function(b,c){return a.N.yb(function(d,h){var l=d.nextSibling;l&&l.nodeName.toLowerCase()===c&&a.La(l,b,h)})}}}();a.b("__tr_ambtns",a.Ib.Jc);(function(){a.v={};a.v.n=function(b){if(this.n=b){var c=a.a.A(b);this.eb="script"===c?1:"textarea"===c?2:"template"==c&&b.content&&11===b.content.nodeType?3:4}};a.v.n.prototype.text=function(){var b=1===
    this.eb?"text":2===this.eb?"value":"innerHTML";if(0==arguments.length)return this.n[b];var c=arguments[0];"innerHTML"===b?a.a.Eb(this.n,c):this.n[b]=c};var b=a.a.e.J()+"_";a.v.n.prototype.data=function(c){if(1===arguments.length)return a.a.e.get(this.n,b+c);a.a.e.set(this.n,b+c,arguments[1])};var c=a.a.e.J();a.v.n.prototype.nodes=function(){var b=this.n;if(0==arguments.length)return(a.a.e.get(b,c)||{}).mb||(3===this.eb?b.content:4===this.eb?b:n);a.a.e.set(b,c,{mb:arguments[0]})};a.v.sa=function(a){this.n=
        a};a.v.sa.prototype=new a.v.n;a.v.sa.prototype.text=function(){if(0==arguments.length){var b=a.a.e.get(this.n,c)||{};b.Jb===n&&b.mb&&(b.Jb=b.mb.innerHTML);return b.Jb}a.a.e.set(this.n,c,{Jb:arguments[0]})};a.b("templateSources",a.v);a.b("templateSources.domElement",a.v.n);a.b("templateSources.anonymousTemplate",a.v.sa)})();(function(){function b(b,c,d){var e;for(c=a.f.nextSibling(c);b&&(e=b)!==c;)b=a.f.nextSibling(e),d(e,b)}function c(c,d){if(c.length){var e=c[0],f=c[c.length-1],g=e.parentNode,h=
        a.S.instance,n=h.preprocessNode;if(n){b(e,f,function(a,b){var c=a.previousSibling,d=n.call(h,a);d&&(a===e&&(e=d[0]||b),a===f&&(f=d[d.length-1]||c))});c.length=0;if(!e)return;e===f?c.push(e):(c.push(e,f),a.a.Ba(c,g))}b(e,f,function(b){1!==b.nodeType&&8!==b.nodeType||a.Ub(d,b)});b(e,f,function(b){1!==b.nodeType&&8!==b.nodeType||a.N.Cc(b,[d])});a.a.Ba(c,g)}}function d(a){return a.nodeType?a:0<a.length?a[0]:null}function e(b,e,f,h,q){q=q||{};var p=(b&&d(b)||f||{}).ownerDocument,n=q.templateEngine||g;
        a.Ib.Tc(f,n,p);f=n.renderTemplate(f,h,q,p);if("number"!=typeof f.length||0<f.length&&"number"!=typeof f[0].nodeType)throw Error("Template engine must return an array of DOM nodes");p=!1;switch(e){case "replaceChildren":a.f.fa(b,f);p=!0;break;case "replaceNode":a.a.uc(b,f);p=!0;break;case "ignoreTargetNode":break;default:throw Error("Unknown renderMode: "+e);}p&&(c(f,h),q.afterRender&&a.l.w(q.afterRender,null,[f,h.$data]));return f}function f(b,c,d){return a.I(b)?b():"function"===typeof b?b(c,d):b}
        var g;a.Fb=function(b){if(b!=n&&!(b instanceof a.P))throw Error("templateEngine must inherit from ko.templateEngine");g=b};a.Cb=function(b,c,k,h,q){k=k||{};if((k.templateEngine||g)==n)throw Error("Set a template engine before calling renderTemplate");q=q||"replaceChildren";if(h){var p=d(h);return a.B(function(){var g=c&&c instanceof a.R?c:new a.R(c,null,null,null,{exportDependencies:!0}),n=f(b,g.$data,g),g=e(h,q,n,g,k);"replaceNode"==q&&(h=g,p=d(h))},null,{ya:function(){return!p||!a.a.qb(p)},i:p&&
        "replaceNode"==q?p.parentNode:p})}return a.N.yb(function(d){a.Cb(b,c,k,d,"replaceNode")})};a.pd=function(b,d,g,h,q){function p(a,b){c(b,t);g.afterRender&&g.afterRender(b,a);t=null}function s(a,c){t=q.createChildContext(a,g.as,function(a){a.$index=c});var d=f(b,a,t);return e(null,"ignoreTargetNode",d,t,g)}var t;return a.B(function(){var b=a.a.c(d)||[];"undefined"==typeof b.length&&(b=[b]);b=a.a.Ma(b,function(b){return g.includeDestroyed||b===n||null===b||!a.a.c(b._destroy)});a.l.w(a.a.Db,null,[h,b,
            s,g,p])},null,{i:h})};var h=a.a.e.J();a.d.template={init:function(b,c){var d=a.a.c(c());if("string"==typeof d||d.name)a.f.za(b);else{if("nodes"in d){if(d=d.nodes||[],a.I(d))throw Error('The "nodes" option must be a plain, non-observable array.');}else d=a.f.childNodes(b);d=a.a.nc(d);(new a.v.sa(b)).nodes(d)}return{controlsDescendantBindings:!0}},update:function(b,c,d,e,f){var g=c();c=a.a.c(g);d=!0;e=null;"string"==typeof c?c={}:(g=c.name,"if"in c&&(d=a.a.c(c["if"])),d&&"ifnot"in c&&(d=!a.a.c(c.ifnot)));
            "foreach"in c?e=a.pd(g||b,d&&c.foreach||[],c,b,f):d?(f="data"in c?f.ac(c.data,c.as):f,e=a.Cb(g||b,f,c,b)):a.f.za(b);f=e;(c=a.a.e.get(b,h))&&"function"==typeof c.k&&c.k();a.a.e.set(b,h,f&&f.ca()?f:n)}};a.h.va.template=function(b){b=a.h.Ab(b);return 1==b.length&&b[0].unknown||a.h.fd(b,"name")?null:"This template engine does not support anonymous templates nested within its templates"};a.f.aa.template=!0})();a.b("setTemplateEngine",a.Fb);a.b("renderTemplate",a.Cb);a.a.hc=function(a,c,d){if(a.length&&
        c.length){var e,f,g,h,l;for(e=f=0;(!d||e<d)&&(h=a[f]);++f){for(g=0;l=c[g];++g)if(h.value===l.value){h.moved=l.index;l.moved=h.index;c.splice(g,1);e=g=0;break}e+=g}}};a.a.lb=function(){function b(b,d,e,f,g){var h=Math.min,l=Math.max,m=[],k,n=b.length,q,p=d.length,s=p-n||1,t=n+p+1,v,u,x;for(k=0;k<=n;k++)for(u=v,m.push(v=[]),x=h(p,k+s),q=l(0,k-1);q<=x;q++)v[q]=q?k?b[k-1]===d[q-1]?u[q-1]:h(u[q]||t,v[q-1]||t)+1:q+1:k+1;h=[];l=[];s=[];k=n;for(q=p;k||q;)p=m[k][q]-1,q&&p===m[k][q-1]?l.push(h[h.length]={status:e,
        value:d[--q],index:q}):k&&p===m[k-1][q]?s.push(h[h.length]={status:f,value:b[--k],index:k}):(--q,--k,g.sparse||h.push({status:"retained",value:d[q]}));a.a.hc(s,l,!g.dontLimitMoves&&10*n);return h.reverse()}return function(a,d,e){e="boolean"===typeof e?{dontLimitMoves:e}:e||{};a=a||[];d=d||[];return a.length<d.length?b(a,d,"added","deleted",e):b(d,a,"deleted","added",e)}}();a.b("utils.compareArrays",a.a.lb);(function(){function b(b,c,d,h,l){var m=[],k=a.B(function(){var k=c(d,l,a.a.Ba(m,b))||[];0<
    m.length&&(a.a.uc(m,k),h&&a.l.w(h,null,[d,k,l]));m.length=0;a.a.ta(m,k)},null,{i:b,ya:function(){return!a.a.Tb(m)}});return{ea:m,B:k.ca()?k:n}}var c=a.a.e.J(),d=a.a.e.J();a.a.Db=function(e,f,g,h,l){function m(b,c){w=q[c];u!==c&&(D[b]=w);w.tb(u++);a.a.Ba(w.ea,e);t.push(w);z.push(w)}function k(b,c){if(b)for(var d=0,e=c.length;d<e;d++)c[d]&&a.a.r(c[d].ea,function(a){b(a,d,c[d].ka)})}f=f||[];h=h||{};var r=a.a.e.get(e,c)===n,q=a.a.e.get(e,c)||[],p=a.a.ib(q,function(a){return a.ka}),s=a.a.lb(p,f,h.dontLimitMoves),
        t=[],v=0,u=0,x=[],z=[];f=[];for(var D=[],p=[],w,C=0,B,E;B=s[C];C++)switch(E=B.moved,B.status){case "deleted":E===n&&(w=q[v],w.B&&(w.B.k(),w.B=n),a.a.Ba(w.ea,e).length&&(h.beforeRemove&&(t.push(w),z.push(w),w.ka===d?w=null:f[C]=w),w&&x.push.apply(x,w.ea)));v++;break;case "retained":m(C,v++);break;case "added":E!==n?m(C,E):(w={ka:B.value,tb:a.O(u++)},t.push(w),z.push(w),r||(p[C]=w))}a.a.e.set(e,c,t);k(h.beforeMove,D);a.a.r(x,h.beforeRemove?a.ba:a.removeNode);for(var C=0,r=a.f.firstChild(e),F;w=z[C];C++){w.ea||
    a.a.extend(w,b(e,g,w.ka,l,w.tb));for(v=0;s=w.ea[v];r=s.nextSibling,F=s,v++)s!==r&&a.f.kc(e,s,F);!w.ad&&l&&(l(w.ka,w.ea,w.tb),w.ad=!0)}k(h.beforeRemove,f);for(C=0;C<f.length;++C)f[C]&&(f[C].ka=d);k(h.afterMove,D);k(h.afterAdd,p)}})();a.b("utils.setDomNodeChildrenFromArrayMapping",a.a.Db);a.X=function(){this.allowTemplateRewriting=!1};a.X.prototype=new a.P;a.X.prototype.renderTemplateSource=function(b,c,d,e){if(c=(9>a.a.C?0:b.nodes)?b.nodes():null)return a.a.W(c.cloneNode(!0).childNodes);b=b.text();
        return a.a.na(b,e)};a.X.vb=new a.X;a.Fb(a.X.vb);a.b("nativeTemplateEngine",a.X);(function(){a.xb=function(){var a=this.ed=function(){if(!u||!u.tmpl)return 0;try{if(0<=u.tmpl.tag.tmpl.open.toString().indexOf("__"))return 2}catch(a){}return 1}();this.renderTemplateSource=function(b,e,f,g){g=g||t;f=f||{};if(2>a)throw Error("Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.");var h=b.data("precompiled");h||(h=b.text()||"",h=u.template(null,"{{ko_with $item.koBindingContext}}"+
        h+"{{/ko_with}}"),b.data("precompiled",h));b=[e.$data];e=u.extend({koBindingContext:e},f.templateOptions);e=u.tmpl(h,b,e);e.appendTo(g.createElement("div"));u.fragments={};return e};this.createJavaScriptEvaluatorBlock=function(a){return"{{ko_code ((function() { return "+a+" })()) }}"};this.addTemplate=function(a,b){t.write("<script type='text/html' id='"+a+"'>"+b+"\x3c/script>")};0<a&&(u.tmpl.tag.ko_code={open:"__.push($1 || '');"},u.tmpl.tag.ko_with={open:"with($1) {",close:"} "})};a.xb.prototype=
        new a.P;var b=new a.xb;0<b.ed&&a.Fb(b);a.b("jqueryTmplTemplateEngine",a.xb)})()})})();})();

/***/ },

/***/ "../smapServer/WebContent/js/libs/saveSvgAsPng.js"
/*!********************************************************!*\
  !*** ../smapServer/WebContent/js/libs/saveSvgAsPng.js ***!
  \********************************************************/
(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_RESULT__;(function() {
  var out$ =  true && exports ||  true && {} || this;

  var doctype = '<?xml version="1.0" standalone="no"?><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd" [<!ENTITY nbsp "&#160;">]>';

  function isElement(obj) {
    return obj instanceof HTMLElement || obj instanceof SVGElement;
  }

  function requireDomNode(el) {
    if (!isElement(el)) {
      throw new Error('an HTMLElement or SVGElement is required; got ' + el);
    }
  }

  function isExternal(url) {
    return url && url.lastIndexOf('http',0) == 0 && url.lastIndexOf(window.location.host) == -1;
  }

  function inlineImages(el, callback) {
    requireDomNode(el);

    var images = el.querySelectorAll('image'),
        left = images.length,
        checkDone = function() {
          if (left === 0) {
            callback();
          }
        };

    checkDone();
    for (var i = 0; i < images.length; i++) {
      (function(image) {
        var href = image.getAttributeNS("http://www.w3.org/1999/xlink", "href");
        if (href) {
          if (isExternal(href.value)) {
            console.warn("Cannot render embedded images linking to external hosts: "+href.value);
            return;
          }
        }
        var canvas = document.createElement('canvas');
        var ctx = canvas.getContext('2d');
        var img = new Image();
        img.crossOrigin="anonymous";
        href = href || image.getAttribute('href');
        if (href) {
          img.src = href;
          img.onload = function() {
            canvas.width = img.width;
            canvas.height = img.height;
            ctx.drawImage(img, 0, 0);
            image.setAttributeNS("http://www.w3.org/1999/xlink", "href", canvas.toDataURL('image/png'));
            left--;
            checkDone();
          }
          img.onerror = function() {
            console.log("Could not load "+href);
            left--;
            checkDone();
          }
        } else {
          left--;
          checkDone();
        }
      })(images[i]);
    }
  }

  function styles(el, selectorRemap, modifyStyle) {
    var css = "";
    var sheets = document.styleSheets;
    for (var i = 0; i < sheets.length; i++) {
      try {
        var rules = sheets[i].cssRules;
      } catch (e) {
        console.warn("Stylesheet could not be loaded: "+sheets[i].href);
        continue;
      }

      if (rules != null) {
        for (var j = 0, match; j < rules.length; j++, match = null) {
          var rule = rules[j];
          if (typeof(rule.style) != "undefined") {
            var selectorText;

            try {
              selectorText = rule.selectorText;
            } catch(err) {
              console.warn('The following CSS rule has an invalid selector: "' + rule + '"', err);
            }

            try {
              if (selectorText) {
                match = el.querySelector(selectorText);
              }
            } catch(err) {
              console.warn('Invalid CSS selector "' + selectorText + '"', err);
            }

            if (match) {
              var selector = selectorRemap ? selectorRemap(rule.selectorText) : rule.selectorText;
              var cssText = modifyStyle ? modifyStyle(rule.style.cssText) : rule.style.cssText;
              css += selector + " { " + cssText + " }\n";
            } else if(rule.cssText.match(/^@font-face/)) {
              css += rule.cssText + '\n';
            }
          }
        }
      }
    }
    return css;
  }

  function getDimension(el, clone, dim) {
    var v = (el.viewBox && el.viewBox.baseVal && el.viewBox.baseVal[dim]) ||
      (clone.getAttribute(dim) !== null && !clone.getAttribute(dim).match(/%$/) && parseInt(clone.getAttribute(dim))) ||
      el.getBoundingClientRect()[dim] ||
      parseInt(clone.style[dim]) ||
      parseInt(window.getComputedStyle(el).getPropertyValue(dim));
    return (typeof v === 'undefined' || v === null || isNaN(parseFloat(v))) ? 0 : v;
  }

  function reEncode(data) {
    data = encodeURIComponent(data);
    data = data.replace(/%([0-9A-F]{2})/g, function(match, p1) {
      var c = String.fromCharCode('0x'+p1);
      return c === '%' ? '%25' : c;
    });
    return decodeURIComponent(data);
  }

  out$.svgAsDataUri = function(el, options, cb) {
    requireDomNode(el);

    options = options || {};
    options.scale = options.scale || 1;
    options.responsive = options.responsive || false;
    var xmlns = "http://www.w3.org/2000/xmlns/";

    inlineImages(el, function() {
      var outer = document.createElement("div");
      var clone = el.cloneNode(true);
      var width, height;
      if(el.tagName == 'svg') {
        width = options.width || getDimension(el, clone, 'width');
        height = options.height || getDimension(el, clone, 'height');
      } else if(el.getBBox) {
        var box = el.getBBox();
        width = box.x + box.width;
        height = box.y + box.height;
        clone.setAttribute('transform', clone.getAttribute('transform').replace(/translate\(.*?\)/, ''));

        var svg = document.createElementNS('http://www.w3.org/2000/svg','svg')
        svg.appendChild(clone)
        clone = svg;
      } else {
        console.error('Attempted to render non-SVG element', el);
        return;
      }

      clone.setAttribute("version", "1.1");
      if (!clone.getAttribute('xmlns')) {
        clone.setAttributeNS(xmlns, "xmlns", "http://www.w3.org/2000/svg");
      }
      if (!clone.getAttribute('xmlns:xlink')) {
        clone.setAttributeNS(xmlns, "xmlns:xlink", "http://www.w3.org/1999/xlink");
      }

      if (options.responsive) {
        clone.removeAttribute('width');
        clone.removeAttribute('height');
        clone.setAttribute('preserveAspectRatio', 'xMinYMin meet');
      } else {
        clone.setAttribute("width", width * options.scale);
        clone.setAttribute("height", height * options.scale);
      }

      clone.setAttribute("viewBox", [
        options.left || 0,
        options.top || 0,
        width,
        height
      ].join(" "));

      var fos = clone.querySelectorAll('foreignObject > *');
      for (var i = 0; i < fos.length; i++) {
        if (!fos[i].getAttribute('xmlns')) {
          fos[i].setAttributeNS(xmlns, "xmlns", "http://www.w3.org/1999/xhtml");
        }
      }

      outer.appendChild(clone);

      var css = styles(el, options.selectorRemap, options.modifyStyle);
      var s = document.createElement('style');
      s.setAttribute('type', 'text/css');
      s.innerHTML = "<![CDATA[\n" + css + "\n]]>";
      var defs = document.createElement('defs');
      defs.appendChild(s);
      clone.insertBefore(defs, clone.firstChild);

      var svg = doctype + outer.innerHTML;
      var uri = 'data:image/svg+xml;base64,' + window.btoa(reEncode(svg));
      if (cb) {
        cb(uri);
      }
    });
  }
  
  out$.svgAsDataUriSync = function(el, options) {
	    requireDomNode(el);

	    options = options || {};
	    options.scale = options.scale || 1;
	    options.responsive = options.responsive || false;
	    var xmlns = "http://www.w3.org/2000/xmlns/";


      var outer = document.createElement("div");
      var clone = el.cloneNode(true);
      var width, height;
      if(el.tagName == 'svg') {
        width = options.width || getDimension(el, clone, 'width');
        height = options.height || getDimension(el, clone, 'height');
      } else if(el.getBBox) {
        var box = el.getBBox();
        width = box.x + box.width;
        height = box.y + box.height;
        clone.setAttribute('transform', clone.getAttribute('transform').replace(/translate\(.*?\)/, ''));

        var svg = document.createElementNS('http://www.w3.org/2000/svg','svg')
        svg.appendChild(clone)
        clone = svg;
      } else {
        console.error('Attempted to render non-SVG element', el);
        return;
      }

      clone.setAttribute("version", "1.1");
      if (!clone.getAttribute('xmlns')) {
        clone.setAttributeNS(xmlns, "xmlns", "http://www.w3.org/2000/svg");
      }
      if (!clone.getAttribute('xmlns:xlink')) {
        clone.setAttributeNS(xmlns, "xmlns:xlink", "http://www.w3.org/1999/xlink");
      }

      if (options.responsive) {
        clone.removeAttribute('width');
        clone.removeAttribute('height');
        clone.setAttribute('preserveAspectRatio', 'xMinYMin meet');
      } else {
        clone.setAttribute("width", width * options.scale);
        clone.setAttribute("height", height * options.scale);
      }

      clone.setAttribute("viewBox", [
        options.left || 0,
        options.top || 0,
        width,
        height
      ].join(" "));

      var fos = clone.querySelectorAll('foreignObject > *');
      for (var i = 0; i < fos.length; i++) {
        if (!fos[i].getAttribute('xmlns')) {
          fos[i].setAttributeNS(xmlns, "xmlns", "http://www.w3.org/1999/xhtml");
        }
      }

      outer.appendChild(clone);

      var css = styles(el, options.selectorRemap, options.modifyStyle);
      var s = document.createElement('style');
      s.setAttribute('type', 'text/css');
      s.innerHTML = "<![CDATA[\n" + css + "\n]]>";
      var defs = document.createElement('defs');
      defs.appendChild(s);
      clone.insertBefore(defs, clone.firstChild);

      var svg = doctype + outer.innerHTML;
      return 'data:image/svg+xml;base64,' + window.btoa(reEncode(svg));
	     
  }

  out$.svgAsImageUriSync = function(el, options) {
	    requireDomNode(el);

	    options = options || {};
	    options.encoderType = options.encoderType || 'image/png';
	    options.encoderOptions = options.encoderOptions || 0.8;

	    var uri = out$.svgAsDataUriSync(el, options);
	    var png;
	    var image = new Image();
        var canvas = document.createElement('canvas');
        canvas.width = image.width;
        canvas.height = image.height;
        var context = canvas.getContext('2d');
        if(options && options.backgroundColor){
          context.fillStyle = options.backgroundColor;
          context.fillRect(0, 0, canvas.width, canvas.height);
        }
        context.drawImage(image, 0, 0);
        var a = document.createElement('a'), png;
        try {
          png = canvas.toDataURL(options.encoderType, options.encoderOptions);
        } catch (e) {
          if ((typeof SecurityError !== 'undefined' && e instanceof SecurityError) || e.name == "SecurityError") {
            console.error("Rendered SVG images cannot be downloaded in this browser.");
            return;
          } else {
            throw e;
          }
        }

	  
      return png;
  }
  
  out$.svgAsPngUri = function(el, options, cb) {
    requireDomNode(el);

    options = options || {};
    options.encoderType = options.encoderType || 'image/png';
    options.encoderOptions = options.encoderOptions || 0.8;

    out$.svgAsDataUri(el, options, function(uri) {
      var image = new Image();
      image.onload = function() {
        var canvas = document.createElement('canvas');
        canvas.width = image.width;
        canvas.height = image.height;
        var context = canvas.getContext('2d');
        if(options && options.backgroundColor){
          context.fillStyle = options.backgroundColor;
          context.fillRect(0, 0, canvas.width, canvas.height);
        }
        context.drawImage(image, 0, 0);
        var a = document.createElement('a'), png;
        try {
          png = canvas.toDataURL(options.encoderType, options.encoderOptions);
        } catch (e) {
          if ((typeof SecurityError !== 'undefined' && e instanceof SecurityError) || e.name == "SecurityError") {
            console.error("Rendered SVG images cannot be downloaded in this browser.");
            return;
          } else {
            throw e;
          }
        }
        cb(png);
      }
      image.onerror = function() {
        console.error(
          'There was an error loading the data URI as an image on the following SVG\n',
          window.atob(uri.slice(26)), '\n',
          "Open the following link to see browser's diagnosis\n",
          uri);
      }
      image.src = uri;
    });
  }

  function download(name, uri) {
    if (navigator.msSaveOrOpenBlob) {
      navigator.msSaveOrOpenBlob(uriToBlob(uri), name);
    } else {
      var saveLink = document.createElement('a');
      var downloadSupported = 'download' in saveLink;
      if (downloadSupported) {
        saveLink.download = name;
        saveLink.href = uri;
        saveLink.style.display = 'none';
        document.body.appendChild(saveLink);
        saveLink.click();
        document.body.removeChild(saveLink);
      }
      else {
        window.open(uri, '_temp', 'menubar=no,toolbar=no,status=no');
      }
    }
  }
  out$.download = download;

  function uriToBlob(uri) {
    var byteString = window.atob(uri.split(',')[1]);
    var mimeString = uri.split(',')[0].split(':')[1].split(';')[0]
    var buffer = new ArrayBuffer(byteString.length);
    var intArray = new Uint8Array(buffer);
    for (var i = 0; i < byteString.length; i++) {
      intArray[i] = byteString.charCodeAt(i);
    }
    return new Blob([buffer], {type: mimeString});
  }

  out$.saveSvg = function(el, name, options) {
    requireDomNode(el);

    options = options || {};
    out$.svgAsDataUri(el, options, function(uri) {
      download(name, uri);
    });
  }

  out$.saveSvgAsPng = function(el, name, options) {
    requireDomNode(el);

    options = options || {};
    out$.svgAsPngUri(el, options, function(uri) {
      download(name, uri);
    });
  }

  // if define is defined create as an AMD module
  if (true) {
    !(__WEBPACK_AMD_DEFINE_RESULT__ = (function() {
      return out$;
    }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  }
})();


/***/ },

/***/ "../smapServer/WebContent/js/libs/wb/plugins/slimscroll/jquery.slimscroll.min.js"
/*!***************************************************************************************!*\
  !*** ../smapServer/WebContent/js/libs/wb/plugins/slimscroll/jquery.slimscroll.min.js ***!
  \***************************************************************************************/
() {

/*! Copyright (c) 2011 Piotr Rochala (http://rocha.la)
 * Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 * and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.
 *
 * Version: 1.3.6
 *
 */
(function(e){e.fn.extend({slimScroll:function(g){var a=e.extend({width:"auto",height:"250px",size:"7px",color:"#000",position:"right",distance:"1px",start:"top",opacity:.4,alwaysVisible:!1,disableFadeOut:!1,railVisible:!1,railColor:"#333",railOpacity:.2,railDraggable:!0,railClass:"slimScrollRail",barClass:"slimScrollBar",wrapperClass:"slimScrollDiv",allowPageScroll:!1,wheelStep:20,touchScrollStep:200,borderRadius:"7px",railBorderRadius:"7px"},g);this.each(function(){function v(d){if(r){d=d||window.event;
    var c=0;d.wheelDelta&&(c=-d.wheelDelta/120);d.detail&&(c=d.detail/3);e(d.target||d.srcTarget||d.srcElement).closest("."+a.wrapperClass).is(b.parent())&&m(c,!0);d.preventDefault&&!k&&d.preventDefault();k||(d.returnValue=!1)}}function m(d,e,g){k=!1;var f=d,h=b.outerHeight()-c.outerHeight();e&&(f=parseInt(c.css("top"))+d*parseInt(a.wheelStep)/100*c.outerHeight(),f=Math.min(Math.max(f,0),h),f=0<d?Math.ceil(f):Math.floor(f),c.css({top:f+"px"}));l=parseInt(c.css("top"))/(b.outerHeight()-c.outerHeight());
    f=l*(b[0].scrollHeight-b.outerHeight());g&&(f=d,d=f/b[0].scrollHeight*b.outerHeight(),d=Math.min(Math.max(d,0),h),c.css({top:d+"px"}));b.scrollTop(f);b.trigger("slimscrolling",~~f);w();p()}function x(){u=Math.max(b.outerHeight()/b[0].scrollHeight*b.outerHeight(),30);c.css({height:u+"px"});var a=u==b.outerHeight()?"none":"block";c.css({display:a})}function w(){x();clearTimeout(B);l==~~l?(k=a.allowPageScroll,C!=l&&b.trigger("slimscroll",0==~~l?"top":"bottom")):k=!1;C=l;u>=b.outerHeight()?k=!0:(c.stop(!0,
    !0).fadeIn("fast"),a.railVisible&&h.stop(!0,!0).fadeIn("fast"))}function p(){a.alwaysVisible||(B=setTimeout(function(){a.disableFadeOut&&r||y||z||(c.fadeOut("slow"),h.fadeOut("slow"))},1E3))}var r,y,z,B,A,u,l,C,k=!1,b=e(this);if(b.parent().hasClass(a.wrapperClass)){var n=b.scrollTop(),c=b.closest("."+a.barClass),h=b.closest("."+a.railClass);x();if(e.isPlainObject(g)){if("height"in g&&"auto"==g.height){b.parent().css("height","auto");b.css("height","auto");var q=b.parent().parent().height();b.parent().css("height",
    q);b.css("height",q)}if("scrollTo"in g)n=parseInt(a.scrollTo);else if("scrollBy"in g)n+=parseInt(a.scrollBy);else if("destroy"in g){c.remove();h.remove();b.unwrap();return}m(n,!1,!0)}}else if(!(e.isPlainObject(g)&&"destroy"in g)){a.height="auto"==a.height?b.parent().height():a.height;n=e("<div></div>").addClass(a.wrapperClass).css({position:"relative",overflow:"hidden",width:a.width,height:a.height});b.css({overflow:"hidden",width:a.width,height:a.height});var h=e("<div></div>").addClass(a.railClass).css({width:a.size,
    height:"100%",position:"absolute",top:0,display:a.alwaysVisible&&a.railVisible?"block":"none","border-radius":a.railBorderRadius,background:a.railColor,opacity:a.railOpacity,zIndex:90}),c=e("<div></div>").addClass(a.barClass).css({background:a.color,width:a.size,position:"absolute",top:0,opacity:a.opacity,display:a.alwaysVisible?"block":"none","border-radius":a.borderRadius,BorderRadius:a.borderRadius,MozBorderRadius:a.borderRadius,WebkitBorderRadius:a.borderRadius,zIndex:99}),q="right"==a.position?
{right:a.distance}:{left:a.distance};h.css(q);c.css(q);b.wrap(n);b.parent().append(c);b.parent().append(h);a.railDraggable&&c.bind("mousedown",function(a){var b=e(document);z=!0;t=parseFloat(c.css("top"));pageY=a.pageY;b.bind("mousemove.slimscroll",function(a){currTop=t+a.pageY-pageY;c.css("top",currTop);m(0,c.position().top,!1)});b.bind("mouseup.slimscroll",function(a){z=!1;p();b.unbind(".slimscroll")});return!1}).bind("selectstart.slimscroll",function(a){a.stopPropagation();a.preventDefault();return!1});
    h.hover(function(){w()},function(){p()});c.hover(function(){y=!0},function(){y=!1});b.hover(function(){r=!0;w();p()},function(){r=!1;p()});b.bind("touchstart",function(a,b){a.originalEvent.touches.length&&(A=a.originalEvent.touches[0].pageY)});b.bind("touchmove",function(b){k||b.originalEvent.preventDefault();b.originalEvent.touches.length&&(m((A-b.originalEvent.touches[0].pageY)/a.touchScrollStep,!0),A=b.originalEvent.touches[0].pageY)});x();"bottom"===a.start?(c.css({top:b.outerHeight()-c.outerHeight()}),
        m(0,!0)):"top"!==a.start&&(m(e(a.start).position().top,null,!0),a.alwaysVisible||c.hide());window.addEventListener?(this.addEventListener("DOMMouseScroll",v,!1),this.addEventListener("mousewheel",v,!1)):document.attachEvent("onmousewheel",v)}});return this}});e.fn.extend({slimscroll:e.fn.slimScroll})})(jQuery);

/***/ },

/***/ "./WebContent/js/app/actioncommon.js"
/*!*******************************************!*\
  !*** ./WebContent/js/app/actioncommon.js ***!
  \*******************************************/
(module, exports, __webpack_require__) {


var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 uSMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */



!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
        __webpack_require__(/*! jquery */ "jquery"),
        __webpack_require__(/*! common */ "../smapServer/WebContent/js/app/common.js"),
        __webpack_require__(/*! modernizr */ "./WebContent/js/libs/modernizr-shim.js"),
        __webpack_require__(/*! localise */ "../smapServer/WebContent/js/app/localise.js"),
        __webpack_require__(/*! globals */ "../smapServer/WebContent/js/app/globals.js"),
        __webpack_require__(/*! app/mapOL3 */ "./WebContent/js/libs/mapOL3-shim.js")], __WEBPACK_AMD_DEFINE_RESULT__ = (function ($, common, modernizr, lang, globals, map) {

        return {
            showEditRecordForm: showEditRecordForm,
            showBulkEditForm: showBulkEditForm,
            addCellMarkup: addCellMarkup,
            addCellMap: addCellMap,
            initialiseDynamicMaps: initialiseDynamicMaps,
            formatConversation: formatConversation
        };

        /*
	     * Refresh any select lists that are dependent on entered values
         */
        function refreshSelectLists(schema, record, changedItemIndex, prefix) {

            var  columns = schema.columns;
            var i;
            var changedItem = columns[changedItemIndex];
            for (i = 0; i < columns.length; i++) {
                var column = columns[i];
                if (column.mgmt) {
                    if (column.type === "select1" || column.type === "select" || column.type === "select_one") {
                        var value = record[column.column_name];
                        getChoiceList(schema, column, i, value, record, changedItem.column_name, prefix);
                    }
                }

            }
        }

        /*
         * Add HTML to show a form to edit a record
         */
        function showEditRecordForm(record, schema, $surveyForm, includeMaps) {
            var
                m = [],
                cnt = -1,
                i,
                configItem,
                first = true,
                columns = schema.columns,
                prefix = 'er';

            globals.gRecordMaps = [];     // Initialise the list of maps we are going to show
            gTasks.gPriKey = record["prikey"];

            // Clear the update array
            gTasks.gUpdate = [];
            $('.saverecord').prop("disabled", true);

            for (i = 0; i < columns.length; i++) {
                configItem = columns[i];
                if((!configItem.readonly
                        || configItem.column_name[0] !== '_')
                        && configItem.column_name !== 'prikey'
                        && configItem.column_name !== 'instanceid') {
                    m[++cnt] = getEditMarkup(configItem, i, first, record, schema, false, true, prefix);
                }

            }

            if($surveyForm) {
                $surveyForm.html(m.join(''));
            }

            // Set up clicks on conversations
            $('.respond', $surveyForm).on('click', function(e) {
                window.gMessageIdx = $(this).data("idx");
                $('#messageForm')[0].reset();
                $('#messagePopup').modal('show');
            });

            // Set up the map fields
            if(includeMaps) {
                initialiseDynamicMaps(globals.gRecordMaps);
            }

            // Respond to changes in the data by creating an update object
            $surveyForm.find('.form-control').bind("click propertychange paste change keyup input", function () {
                var $this = $(this);
                var config = {
                    itemIndex: $this.data("item"),
                    value: $this.val()
                };
                dataChanged(config);
            });
            // Set focus to first editable data item
            $surveyForm.find('[autofocus]').focus();
        }

        /*
         * Add HTML to allow bulk edititng
         */
        function showBulkEditForm(record, schema, $editForm) {
            var
                h = [],
                idx = -1,
                m = [],
                cnt = -1,
                i,
                configItem,
                first = true,
                columns = schema.columns,
                prefix = 'be',
                qFound = false;

            for (i = 0; i < columns.length; i++) {
                configItem = columns[i];

                if (configItem.mgmt
                    && !configItem.readonly
                    && configItem.question_name !== '_hrk'
                    && (configItem.type === 'text'
                        || configItem.type === 'select1'
                        || configItem.type === 'select')) {

                    qFound = true;

                    h[++idx] = '<div class="row bulkquestion">';
                    h[++idx] = '<div class="col-sm-8">';

                    var cloneItem = JSON.parse(JSON.stringify(configItem));
                    if (configItem.type === 'select') {
                        cloneItem.type = 'select1';     // With select multiples the bulk change is to set or clear one value
                    }
                    h[++idx] = getEditMarkup(cloneItem, i, first, record, schema, true, false, prefix);
                    h[++idx] = '</div>';    // Question column
                    h[++idx] = '<div class="col-sm-4">';    // clear
                    if (configItem.type === 'select') {
                        h[++idx] = '<div class="switch">';
                        h[++idx] = '<input type="checkbox" class="selectClear">';
                        h[++idx] = '</div>';
                    }
                    h[++idx] = '</div>';    // clear
                    h[++idx] = '</div>';    // row
                }

                if (!configItem.readonly) {
                    first = false;
                }
            }

            if(qFound) {
                if ($editForm) {
                    $editForm.html(h.join(''));
                }

                // Set up date fields
                $editForm.find('.date').datetimepicker({
                    locale: gUserLocale || 'en',
                    useCurrent: false,
                    showTodayButton: true
                });


                // Respond to changes in the data by creating an update object
                $editForm.find('.form-control, select').bind("click propertychange paste change keyup input", function () {
                    var $this = $(this);
                    var config = {
                        itemIndex: $this.data("item"),
                        value: $this.val(),
                        clear: $this.closest(".bulkquestion").find(".selectClear").is(':checked')
                    };
                    bulkDataChanged(config);
                    refreshSelectLists(schema, record, $this.data("item"), prefix);
                });

                // Respond to changes in a clear checkbox
                $editForm.find('.selectClear').bind("change", function () {
                    var $this = $(this);
                    var $q = $this.closest(".bulkquestion").find(".form-control")
                    var config = {
                        itemIndex: $q.data("item"),
                        value: $q.val(),
                        clear: $this.is(':checked')
                    };

                    bulkDataChanged(config);
                    refreshSelectLists(schema, record, $this.data("item"), prefix);
                });

                // Set focus to first editable data item
                $editForm.find('[autofocus]').focus();
            } else {
                // There are no questions that can be bulk edited
                alert(localise.set["m_no_q"]);
            }
        }

        /*
         * Get the markup to edit the record
         */
        function getEditMarkup(configItem, itemIndex, first, record, schema, editable, setvalue, prefix) {

            var h = [],
                idx = -1,
                value;

            if(record && setvalue) {
                var name = configItem.column_name;
                value = record[name];
            }

            // Add form group and label
            h[++idx] = '<div class="form-group row"><label class="col-md-4 control-label">';
            h[++idx] = htmlEncode(configItem.displayName);
            h[++idx] = '</label>';

            // Add Data
            h[++idx] = ' <div class="col-md-8">';

            // Check for source column as will make these editable
            var sourceColumn;
            if(configItem.parameters && configItem.parameters.source) {
                sourceColumn = getColumn(configItem.parameters.source, schema.columns);
            }

            if(configItem.type === 'geopoint' || configItem.type === 'geoshape' || configItem.type === 'geotrace') {
                h[++idx] = addCellMap(
                    configItem.readonly || !editable,
                    'record_maps_',
                    globals.gRecordMaps,
                    configItem,
                    value,
                    undefined,
                    itemIndex);
            } else  if(configItem.type === 'conversation') {
                h[++idx] = addConversationCellMarkup(value, true);
            } else if (!sourceColumn && (configItem.readonly || !editable)) {		// Read only text
                h[++idx] = addCellMarkup(value);
            } else {
                h[++idx] = addEditableColumnMarkup(configItem, value, itemIndex, first, schema, record, prefix);
            }
            h[++idx] = '</div>';

            // Close form group
            h[++idx] = '</div>';

            return h.join('');
        }

        /*
         * Add the markup for an editable column
         */
        function addEditableColumnMarkup(column, value, itemIndex, first, schema, record, prefix) {
            var h = [],
                idx = -1,
                i,
                sourceColumn;

            // Check for a source column
            if(column.parameters && column.parameters.source) {
                sourceColumn = getColumn(column.parameters.source, schema.columns);
            }

            if(sourceColumn) {
                h[++idx] = addSourceQuestion(sourceColumn, record, column.parameters.rows);
            }

            if (column.type === "decimal" || column.type === "integer"  || column.type === "int") {
                h[++idx] = ' <input type="number"';
                if(column.type === "integer"  || column.type === "int") {
                    h[++idx] = ' step="1"';
                }
                h[++idx] = ' class="form-control editable" value="';
                h[++idx] = value;
                h[++idx] = '" data-item="';
                h[++idx] = itemIndex;
                if (first) {
                    h[++idx] = '" autofocus/>';
                } else {
                    h[++idx] = '"/>';
                }
            } else if (column.type === "date") {
                h[++idx] = '<div class="input-group date" data-container="body">';
                h[++idx] = '<input type="date" class="form-control editable" data-date-format="YYYY-MM-DD" value="';
                h[++idx] = value;
                h[++idx] = '" data-item="';
                h[++idx] = itemIndex;
                if (first) {
                    h[++idx] = '" autofocus/>';
                } else {
                    h[++idx] = '"/>';
                }
                h[++idx] = '<span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span></span>';
                h[++idx] = '</div>';
            } else if (column.type === "dateTime") {
                h[++idx] = '<div class="input-group" data-container="body">';
                h[++idx] = '<input type="datetime-local" class="form-control editable" data-date-format="YYYY-MM-DD HH:MM" value="';
                h[++idx] = value;
                h[++idx] = '" data-item="';
                h[++idx] = itemIndex;
                if (first) {
                    h[++idx] = '" autofocus/>';
                } else {
                    h[++idx] = '"/>';
                }
                h[++idx] = '<span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span></span>';
                h[++idx] = '</div>';
            } else if (column.type === "select1" || column.type === "select" || column.type === "select_one") {
                h[++idx] = ' <select id="select_';
                h[++idx] = prefix + itemIndex;
                h[++idx] = '" class="form-control editable ';
                if (column.type === "select") {
                    h[++idx] = ' select';
                }
                h[++idx] = '" data-item="';
                h[++idx] = itemIndex;
                h[++idx] = '"';
                if (column.type === "select") {
                    h[++idx] = ' multiple="multiple"'
                }
                h[++idx] = '>';

                // Add the empty choice
                /*
                 * Do we need this?
                 * Should it be configurable
                 * Presumably only valid choices should be allowed
                 *
                if (column.type !== "select") {
                    h[++idx] = '<option value=""></option>';
                }
                */

                var choices = getChoiceList(schema, column, itemIndex, value, record, undefined, prefix);
                if (choices) {
                    h[++idx] = getChoicesHTML(column, choices, value, true);
                }
                h[++idx] = '</select>';

            } else {        // Text + Default

                var v = addAnchors(value)[0];
                
                if(v && v.indexOf('<') == 0) {
                    h[++idx] = v;
                } else {
                    if(column.parameters && column.parameters.rows) {
                        h[++idx] = ' <textarea rows=';
                        h[++idx] = column.parameters.rows;
                        h[++idx] = ' class="form-control editable" ';
                        h[++idx] = '" data-item="';
                        h[++idx] = itemIndex;
                        if (first) {
                            h[++idx] = '" autofocus>';
                        } else {
                            h[++idx] = '">';
                        }
                        h[++idx] = value;
                        h[++idx] = '</textarea>';
                    } else {
                        h[++idx] = ' <input type="text"';
                        h[++idx] = '" class="form-control editable" value="';
                        h[++idx] = value;
                        h[++idx] = '" data-item="';
                        h[++idx] = itemIndex;
                        if (first) {
                            h[++idx] = '" autofocus/>';
                        } else {
                            h[++idx] = '"/>';
                        }
                    }
                }

            }

            return h.join('');
        }

        /*
         * Get the choicelist for a select question
         */
        function getChoiceList(schema, col, itemIndex, value, record, changed_column, prefix) {

            // Get the choice list
            var listId = col.l_id;
            var i;
            var choices;

            if (schema && schema.choiceLists && schema.choiceLists.length) {
                for (i = 0; i < schema.choiceLists.length; i++) {
                    if (schema.choiceLists[i].l_id === listId) {
                        choices = schema.choiceLists[i].choices;
                        break;
                    }
                }
            }
            if(choices && choices.length > 0) {

                if (col.appearance && (col.appearance.indexOf('search(') >= 0 || col.appearance.indexOf('lookup_choices(') >= 0)) {
                    // External choices
                    var params = getAppearanceParams(col.appearance);
                    var changeParam1 = false;
                    var changeParam2 = false;
                    var changeExpr = false;
                    var dependentColumn;
                    if (params.length > 0) {
                        // todo consider fixed values
                        var sIdent = globals.gGroupSurveys[globals.gCurrentSurvey];
                        var value_column = choices[0].k;
                        var label_column = choices[0].v;
                        var url = '/lookup/choices/' + sIdent + '/' + params.filename + '/' + value_column + '/' + label_column;
                        if(typeof params.filter !== "undefined") {
                            if(params.filter === 'eval') {
                                if (typeof params.expression !== "undefined") {
                                    // Replace ${question_name} elements with values
                                    const regex = /\$\{.+?\}/g;
                                    const found = params.expression.match(regex);
                                    if(found && found.length > 0) {
                                        for(i = 0; i < found.length; i++) {
                                            var token = found[i];
                                            dependentColumn = token.substring(2, token.length - 1);
                                            var depValue = record[dependentColumn];
                                            depValue = getUpdate(dependentColumn, depValue);  // Replace the value if there has been an update
                                            var type = getQuestionType(schema, dependentColumn);
                                            if(type !== 'int') {
                                                depValue = '\'' + depValue + '\'';
                                            }
                                            params.expression = params.expression.replace(token, depValue);


                                            if (changed_column && dependentColumn === changed_column) {        // Set a flag if this refresh in response to a changed value and this param is wha changed
                                                changeExpr = true;
                                            }
                                        }
                                    }

                                    var encodedExpression = encodeURIComponent(params.expression);
                                    // manually encode some characters that are missed by encodeUriComponent and ned to be encoded
                                    encodedExpression = encodedExpression.replace(/\(/g, "%28");
                                    encodedExpression = encodedExpression.replace(/\)/g, "%29");
                                    url += '?expression=' + encodedExpression;

                                }
                            } else {
                                if (typeof params.filter_column !== "undefined" && typeof params.filter_value !== "undefined") {
                                    // Add first filter
                                    url += '?search_type=' + params.filter;
                                    url += '&q_column=' + params.filter_column;
                                    if (params.filter_value.indexOf('${') == 0) {
                                        dependentColumn = params.filter_value.substring(2, params.filter_value.length - 1);
                                        params.filter_value = record[dependentColumn];

                                        params.filter_value = getUpdate(params.filter_column, params.filter_value);  // Replace the value if there has been an update
                                        if (changed_column && dependentColumn === changed_column) {        // Set a flag if this refresh in response to a changed value and this param is wha changed
                                            changeParam1 = true;
                                        }
                                    }

                                    url += '&q_value=' + params.filter_value;
                                    if (typeof params.second_filter_column !== "undefined"
                                        && typeof params.second_filter_value !== "undefined") {
                                        url += '&f_column=' + params.second_filter_column;
                                        if (params.second_filter_value.indexOf('${') == 0) {
                                            dependentColumn = params.second_filter_value.substring(2, params.second_filter_value.length - 1);
                                            params.second_filter_value = record[dependentColumn];

                                            params.second_filter_value = getUpdate(params.second_filter_column, params.second_filter_value);    // Replace the value if there has been an update
                                            if (changed_column && dependentColumn === changed_column) {        // Set a flag if this refresh in response to a changed value and this param is wha changed
                                                changeParam2 = true;
                                            }
                                        }
                                        url += '&f_value=' + params.second_filter_value;
                                    }
                                }
                            }
                        }

                        if(!changed_column || changeParam1 || changeParam2 || changeExpr) {
                            $.ajax({   // Get the existing report details to edit
                                url: url,
                                cache: false,
                                success: function (data, status) {
                                    var el = '#select_' + prefix + itemIndex;
                                    var selValue = value;
                                    var html = getChoicesHTML(col, data, selValue, false);
                                    $(el).empty().append(html);

                                    // Set up multi selects
                                    if (col.type === 'select') {
                                        $(el).multiselect('rebuild');
                                    }

                                }, error: function (data, status) {
                                    alert("Error: " + data.responseText);
                                }
                            });
                        }
                    } else {
                        alert("invalid search for: " + col.question_name);
                    }
                } else {
                    // Local choices
                    return choices;
                }
            }
        }

        /*
         * Get an updated value
         */
        function getUpdate(col, def) {
            if(gTasks.gUpdate && gTasks.gUpdate.length > 0) {
                var i;
                for(i = 0; i < gTasks.gUpdate.length; i++) {
                    if(gTasks.gUpdate[i].name === col) {
                        return gTasks.gUpdate[i].value;
                    }
                }
            }
            return def;
        }

        /*
         * Add the markup for a map
         */
        function addCellMap(readOnly, idbase, maps, column, currentValue, oldValue, itemIndex) {
            var h = [],
                idx = -1;

            // Make sure values are JSON objects
            if(typeof currentValue === "string") {
                try {
                    currentValue = JSON.parse(currentValue);
                } catch(err) {

                }
            }
            if(typeof oldValue === "string") {
                try {
                    oldValue = JSON.parse(oldValue);
                } catch (err) {

                }
            }

            var config = {
                readOnly: readOnly,
                id: idbase + maps.length,
                currentValue: currentValue,
                oldValue: oldValue
            };

            h[++idx] = '<div id="';
            h[++idx] = config.id;
            h[++idx] = '" data-item="';
            h[++idx] = itemIndex;
            h[++idx] = '" class="small_map">';
            h[++idx] = '<div id="tooltip_';
            h[++idx] = config.id;
            h[++idx] = '"></div>';
            h[++idx] = '</div>';

            maps.push(config);

            return h.join('');
        }

        function getColumn(qname, columns) {
            var i,
                col;
            for(i = 0; i < columns.length; i++) {
                // Hack.  For forms the human name is the question name that has not been modified to act as a database column
                if((columns[i].mgmt && qname === columns[i].name) || (!columns[i].mgmt && qname === columns[i].displayName)) {
                    col = columns[i];
                    break;
                }
            }
            return col;

        }

        function formatConversation(val, inEdit) {
            window.gEditRecord.contacts = {};
            var conv;
            if(val && val.length > 0 && val !== 'undefined' && val[0] === '[') {    // Only convert if the data is a json array, otherwise has already been converted
                try {
                    conv = JSON.parse(val);
                } catch (e) {
                    console.log("Error converting: " + val);
                    console.log(e);
                    // Ignore malformed json
                }

                if (conv && conv.length > 0) {
                    var h = [],
                        idx = -1,
                        j;
                    for (j = conv.length - 1; j >= 0; j--) {
                        var css,
                            justify,
                            respond = "";

                        if(inEdit && conv[j].inbound) {
                            respond = 'respond';
                        }
                        if (conv[j].inbound) {
                            css = 'conv-from';
                            justify = 'justify-content-start';
                        } else {
                            css = 'conv-to';
                            justify = 'justify-content-end';
                        }
                        if(conv[j].channel) {
                            css += ' ' + conv[j].channel;
                        } else {
                            css += ' sms';  // Default style
                        }
                        h[++idx] = '<div class="d-flex flex-row ' + justify + ' ' + respond + ' mb-1 message"' + (inEdit ? 'data-idx="' + j + '"' : '') + '>';
                        h[++idx] = '<div class="p-1 border bg-body-tertiary ' + css + '" style="border-radius: 10px;">';

                        if (conv[j].ts) {
                            h[++idx] = '<time datetime="';
                            h[++idx] = conv[j].ts;
                            h[++idx] = '">';
                            h[++idx] = conv[j].ts;
                            h[++idx] = '</time>';
                        }
                        if (conv[j].theirNumber) {
                            h[++idx] = ' <dest>';
                            h[++idx] = conv[j].theirNumber;
                            h[++idx] = '</dest>';
                        }

                        h[++idx] = '<br/>';
                        h[++idx] = htmlEncode(conv[j].msg);

                        h[++idx] = '</div>';
                        h[++idx] = '</div>';

                        if(inEdit) {
                            window.gEditRecord.contacts[conv[j].theirNumber] = {
                                channel: conv[j].channel
                            }
                        } //else {
                          //  break;  // Only do the first entry if not in edit
                        //}
                    }
                    return h.join('');
                } else {
                    return "";
                }
            } else {
                return val;
            }
        }

        function addSourceQuestion(column, record, ref_rows) {
            var name = column.mgmt ? column.name : column.column_name;        // Name hack
            var v = addAnchors(record[name])[0];
            var h = [];
            var idx = -1;

            if(v.indexOf('<') == 0) {
                h[++idx] = v;
            } else {
                if(!ref_rows || ref_rows <= 1) {
                    ref_rows = 1;
                }
                h[++idx] = ' <textarea readonly style="overflow-y:scroll;" rows=';
                h[++idx] = ref_rows;
                h[++idx] = ' class="form-control">';
                h[++idx] = v;
                h[++idx] = '</textarea>';
            }

            return h.join('');
        }

        /*
         * User has changed a managed value
         */
        function dataChanged(config) {

            var
                itemIndex = config.itemIndex,
                value = config.value,
                record = gTasks.gSelectedRecord,
                columns = gTasks.cache.currentData.schema.columns,
                currentValue,
                column_name = columns[itemIndex].column_name,
                displayName = columns[itemIndex].displayName,
                i,
                foundExistingUpdate;

            currentValue = record[column_name];
            if (typeof currentValue === "undefined") {
                currentValue = "";
            }
            if(typeof currentValue === "object") {
                currentValue = JSON.stringify(currentValue);
            }
            if(typeof value === "object") {
                value = JSON.stringify(value);
            }

            if (currentValue !== value) {
                // Add new value to array, or update existing
                foundExistingUpdate = false;
                for (i = 0; i < gTasks.gUpdate.length; i++) {
                    if (gTasks.gUpdate[i].name === column_name) {
                        foundExistingUpdate = true;
                        gTasks.gUpdate[i].value = value;
                        break;
                    }
                }

                if (!foundExistingUpdate) {
                    // Add new value
                    gTasks.gUpdate.push({
                        name: column_name,                 // Update name is the column name
                        displayName: displayName,
                        value: value,
                        currentValue: currentValue,
                        itemIndex: itemIndex
                    });
                }

            } else {
                // Delete value from array of updates
                for (i = 0; i < gTasks.gUpdate.length; i++) {
                    if (gTasks.gUpdate[i].name === column_name) {
                        gTasks.gUpdate.splice(i, 1);
                        break;
                    }
                }
            }

            if (gTasks.gUpdate.length > 0) {
                $('.saverecord').prop("disabled", false);
            } else {
                $('.saverecord').prop("disabled", true);
            }

            $('.re_alert').hide();
        }

        /*
         * User has changed a bulk managed value
         */
        function bulkDataChanged(config) {

            var
                itemIndex = config.itemIndex,
                value = config.value,
                clear = config.clear,
                columns = gTasks.cache.currentData.schema.columns,
                column_name = columns[itemIndex].column_name,
                displayName = columns[itemIndex].displayName,
                i,
                foundExistingUpdate;

            if(typeof value === "object") {
                value = JSON.stringify(value);
            }

            // Add new value to array, or update existing
            foundExistingUpdate = false;
            for (i = 0; i < gTasks.gUpdate.length; i++) {
                if (gTasks.gUpdate[i].name === column_name) {
                    foundExistingUpdate = true;
                    gTasks.gUpdate[i].value = value;
                    gTasks.gUpdate[i].clear = clear;
                    break;
                }
            }

            if (!foundExistingUpdate) {
                // Add new value
                gTasks.gUpdate.push({
                    name: column_name,
                    displayName: displayName,
                    value: value,
                    clear: clear,
                    itemIndex: itemIndex
                });
            }


            if (gTasks.gUpdate.length > 0) {
                $('.saverecord').prop("disabled", false);
            } else {
                $('.saveRecord').prop("disabled", true);
            }

            $('.re_alert').hide();
        }

        /*
         * Add markup for a single cell
         */
        function addCellMarkup(input) {
            var v = addAnchors(input)[0],
                h = [],
                idx = -1;
            if(v && v.indexOf('<') == 0) {
                h[++idx] = v;
            } else {
                h[++idx] = ' <textarea readonly style="overflow-y:scroll;" rows=1';
                h[++idx] = ' class="form-control">';
                h[++idx] = v;
                h[++idx] = '</textarea>';
            }
            return h.join('');

        }

        /*
        * Add markup for a conversation
        */
        function addConversationCellMarkup(v, inEdit) {
            var h = [],
                idx = -1;

            h[++idx] = ' <div class="border border-primary">';
            v = v.replace(/&quot;/g, '\"');    // TODO not sure why quotes are escaped here
            h[++idx] = formatConversation(v, inEdit);
            h[++idx] = '</div>';

            return h.join('');

        }

        /*
	     * Initialise maps
	     */
        function initialiseDynamicMaps(maps, mapId) {
            var i;

            for(i = 0; i < maps.length; i++) {
                if(!mapId || mapId === maps[i].id) {
                    map.initDynamicMap(maps[i]);
                }
            }

        }

        /*
         * Support both internal arrays and external
         * Internal
         *    value: k
         *    label: v
         * External
         *    value: value
         *    label: labelInnerText
         */
        function getChoicesHTML(column, choices, value, internal) {
            var i,
                idx = -1,
                h = [],
                vArray,
                v,
                l;

            if (column.type === "select") {
                vArray = value.split(' ');
            } //else {      // Probably not needed.  If ther eis no empty choice why add it here?
                // Add the empty option
                //h[++idx] = '<option value=""></option>';
            //}
            for (i = 0; i < choices.length; i++) {
                if(internal) {
                    v = choices[i].k;
                    l = choices[i].v;
                } else {
                    v = choices[i].value;
                    l = choices[i].labelInnerText;
                }
                h[++idx] = '<option';
                if (column.type === "select") {
                    if (vArray.indexOf(v) > -1) {
                        h[++idx] = ' selected="selected"';
                    }
                } else {
                    if (v === value) {
                        h[++idx] = ' selected="selected"';
                    }
                }
                h[++idx] = ' value="';
                h[++idx] = v;
                h[++idx] = '">';
                h[++idx] = htmlEncode(l);
                h[++idx] = '</option>';
            }
            return h.join('');
        }
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));


/***/ },

/***/ "./WebContent/js/app/chart.js"
/*!************************************!*\
  !*** ./WebContent/js/app/chart.js ***!
  \************************************/
(module, exports, __webpack_require__) {


var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 uSMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Chart functions
 * Uses: https://www.chartjs.org/
 */



!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
        __webpack_require__(/*! jquery */ "jquery"),
        __webpack_require__(/*! modernizr */ "./WebContent/js/libs/modernizr-shim.js"),
        __webpack_require__(/*! localise */ "../smapServer/WebContent/js/app/localise.js"),
        __webpack_require__(/*! globals */ "../smapServer/WebContent/js/app/globals.js")], __WEBPACK_AMD_DEFINE_RESULT__ = (function ($, modernizr, localise, globals) {

        var charts = [];
        //var barColors = ["red", "green","blue","orange","brown"];
        var barColors = ["#e60049", "#0bb4ff", "#50e991", "#e6d800", "#9b19f5", "#ffa300", "#dc0ab4", "#b3d4ff", "#00bfa0"];  // River nights from: https://www.heavy.ai/blog/12-color-palettes-for-telling-better-stories-with-your-data

        return {
            add: add,
            replace: replace,
            refresh: refresh,
            remove: remove,
            clear: clear
        };

        function add(settings) {

            if(!gTasks.cache.currentData) {
                // Data not available yet.
                return;
            }

            var item = {
                source: {
                    subject: settings.subject
                },
                config: updateConfigFromSettings({
                    type: settings.chart_type,
                    responsive: true,
                    data: {
                        labels: [],
                        datasets:[{
                            label: settings.subject,
                            backgroundColor: barColors,
                            borderColor: 'rgb(0, 0, 0)',
                            data: [],
                        }]
                    },
                    options: {}
                }, settings)
            };

            // Set the data key
            var cd = gTasks.cache.currentData.case;
            if(settings.subject === 'status') {
                item.source.key = cd.settings.statusQuestion;
            } else  if(settings.subject === 'assigned') {
                item.source.key = "_assigned";
            } else  if(settings.subject === 'alert') {
                item.source.key = "_alert";
            } else  if(settings.subject === 'criticality') {
                item.source.key = cd.settings.criticalityQuestion;
            }

            // create the canvas element
            var label = settings.subject;
            var index = charts.length;
            var card = `<div class="col-sm-12 col-md-6 col-lg-3">
                                    <div class="card">
                                        <div class="card-header d-flex chart-header">
                                            <span class="mr-auto">${label}</span>
                                            <i class="fa fa-trash text-danger pr-2" data-idx="${index}"></i>
                                            <i class="fa fa-cog" data-idx="${index}"></i>
                                        </div>
                                        <div class="card-body">
                                            <canvas id="chart${index}"></canvas>
                                        </div>
                                    </div>
                                </div>`;
            $('#chartcontent').append(card);

            // Associate the canvas element with the chart
            item.chart = new Chart(
                document.getElementById('chart' + charts.length),
                item.config
            );
            charts.push(item);
        }

        function replace(settings, index) {
            charts[index].config = updateConfigFromSettings(charts[index].config, settings);
            charts[index].chart.update();
        }

        function remove(index) {
            charts[index].chart.destroy();
            charts.splice(index,1);
        }

        function updateConfigFromSettings(config, settings) {
            config.type = settings.chart_type;
            config.data.datasets[0].backgroundColor = barColors;

            if(config.type === 'col') {
                config.type = 'bar';

            } else if(config.type === 'bar') {
                config.options.indexAxis = 'y';
            }

            return config;
        }

        /*
         * Clear existing charts
         */
       function clear() {
           for(var chartIdx = 0; chartIdx < charts.length; chartIdx++) {
               charts[chartIdx].chart.destroy();
           }
           charts = [];
           $('#chartcontent').empty();
        }

        /*
         * Extract the data in chart form
         */
        function refresh() {


            if(!gTasks.cache.currentData || !globals.gMainTable) {
                // Data not available yet.
                return;
            }

            var cd = gTasks.cache.currentData.case;
            var results = globals.gMainTable.rows({
                order: 'current',  // 'current', 'applied', 'index',  'original'
                page: 'all',      // 'all',     'current'
                search: 'applied',     // 'none',    'applied', 'removed'
            }).data();

            if(cd.settings.finalStatus && cd.settings.statusQuestion) {
                for(var chartIdx = 0; chartIdx < charts.length; chartIdx++) {

                    var key = charts[chartIdx].source.key;
                    var chartData = {};

                    for (var i = 0; i < results.length; i++) {

                        var val = results[i][key];

                        // ignore records without an alert when getting alert chart data
                        if (key === '_alert' && val.trim().length === 0) {
                            continue;
                        } else if (val === "") {
                            val = localise.set["c_none"];
                        }

                        chartData[val] = chartData[val] || 0; // Ensure value is numeric
                        chartData[val]++;

                    }
                    updateChart(charts[chartIdx].config, chartData, charts[chartIdx].chart);
                }
            }

        }

        function updateChart(config, data, chart) {
            var keys = Object.keys(data).sort();

            config.data.labels = [];
            config.data.datasets[0].data = [];
            for (var i = 0; i < keys.length; i++) {
                var key = keys[i];
                config.data.labels.push(key);
                config.data.datasets[0].data.push(data[key]);
            }
            chart.update();
        }
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ },

/***/ "./WebContent/js/app/mapOL3.js"
/*!*************************************!*\
  !*** ./WebContent/js/app/mapOL3.js ***!
  \*************************************/
(module, exports, __webpack_require__) {


var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 uSMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Open layers 3 functions
 */



!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
        __webpack_require__(/*! jquery */ "jquery"),
        __webpack_require__(/*! modernizr */ "./WebContent/js/libs/modernizr-shim.js"),
        __webpack_require__(/*! localise */ "../smapServer/WebContent/js/app/localise.js"),
        __webpack_require__(/*! globals */ "../smapServer/WebContent/js/app/globals.js"),
        __webpack_require__(/*! icheck */ "./WebContent/js/libs/icheck-shim.js")], __WEBPACK_AMD_DEFINE_RESULT__ = (function ($, modernizr, lang, globals) {


        var gMap,
            gLayers = [],
            gVectorSources = [],
            gVectorLayers = [],
            gMapUpdatePending = true,
            gSelectFeature;

        return {
            setLayers: setLayers,
            refreshLayer: refreshLayer,
            refreshAllLayers: refreshAllLayers,
            saveLayer: saveLayer,
            deleteLayers: deleteLayers,
            initDynamicMap: initDynamicMap,
            clearSelectFeatures: clearSelectFeatures,
            setSelectedFeature: setSelectedFeature
        };

        function deleteLayers() {
            if(gLayers) {
                for(i = 0; i < gLayers.length; i++) {
                    deleteLayer(i);
                }
            }
        }

        function setLayers(layers, map) {

            var i;

            /*
             * Delete existing layers
             */
            deleteLayers();

            /*
             * Add new layers
             */
            gLayers = layers;
            // Add default data layer
            var layer = {
                title: localise.set["c_data"],
                local: true,
                clump: undefined,
                enabled: true,
                fixed: true
            };
            if(gLayers.length < 2) {
                gLayers.push(layer);
            } else {
                gLayers[0] = layer;     // replace
            }
            layer = {
                title: localise.set["c_heatmap"],
                local: true,
                clump: "heatmap",
                enabled: false,
                fixed: true
            };
            if(gLayers.length < 2) {
                gLayers.push(layer);
            } else {
                gLayers[1] = layer;     // replace
            }

            showLayerSelections(map);
        };


        /*
         * Show layer selections on the screen
         */
        function showLayerSelections(map) {
            var h = [],
                idx = -1,
                i;

            for (i = 0; i < gLayers.length; i++) {
                h[++idx] = '<tr>';

                h[++idx] = '<td>';      // Select
                h[++idx] = '<div class="switch custom-control custom-checkbox">';
                h[++idx] = '<input type="checkbox" class="custom-control-input layerSelect" name="columnSelect"';
                if(gLayers[i].enabled) {
                    h[++idx] = 'checked="checked"';
                }
                h[++idx] = ' value="';
                h[++idx] = i;
                h[++idx] = '"';
                h[++idx] = ' id="layer' + i + '"';
                h[++idx] = '>';
                h[++idx] = '<label class="custom-control-label" for="layer' + i + '">';
                h[++idx] = gLayers[i].title;
                h[++idx] = '</label>';
                h[++idx] = '</div>';
                h[++idx] = '</td>';
                h[++idx] = '<td>';      // Delete
                h[++idx] = '<button type="button" data-idx="';
                h[++idx] = i;
                h[++idx] = '" class="btn btn-default btn-sm rm_layer danger"';
                if(gLayers[i].fixed) {
                    h[++idx] = ' disabled';
                }
                h[++idx] = '>';
                h[++idx] = '<span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button>';
                h[++idx] = '</td>';

                h[++idx] = '</tr>';
            }


            $('#layerSelect tbody').empty().html(h.join(''));
            //$('input', '#layerSelect tbody').iCheck({
            //    checkboxClass: 'icheckbox_square-green',
            //    radioClass: 'iradio_square-green'
            //});
            $('.rm_layer', '#layerSelect tbody').click(function() {
                var idx = $(this).data("idx");
                deleteLayer(idx);
                gLayers.splice(idx, 1);
                showLayerSelections(gMap);
            });

            $('.layerSelect').change(function() {
                var $this = $(this);
                var index = $(this).val();
               if($this.prop('checked')) {
                   showLayer(index, map);
               } else {
                   hideLayer(index, map);
               }
            });
        }

        /*
         * Redisplay a single layer
         */
        function refreshLayer(index, map) {

            if (map) {
                var results = globals.gMainTable.rows({
                    order: 'current',  // 'current', 'applied', 'index',  'original'
                    page: 'all',      // 'all',     'current'
                    search: 'applied',     // 'none',    'applied', 'removed'
                }).data();

                updateSingleLayer(index, results, map);
            }
        }

        /*
         * Redisplay all layers
         */
        function refreshAllLayers(mapView, map) {
            if (mapView) {
                if (map) {
                    var i;
                    var results = globals.gMainTable.rows({
                        order: 'current',  // 'current', 'applied', 'index',  'original'
                        page: 'all',      // 'all',     'current'
                        search: 'applied',     // 'none',    'applied', 'removed'
                    }).data();

                    for (i = 0; i < gLayers.length; i++) {
                        deleteLayer(i);
                        updateSingleLayer(i, results, map);
                    }
                }
                gMapUpdatePending = false;
            } else {
                gMapUpdatePending = true;
            }
        }

        /*
         * Set up a single layer
         * This function is called by both refreshLayer and refreshAllLayers as refreshLayer has to do some setup
         *  that is also done by refreshAllLayers
         */
        function updateSingleLayer(index, results, map) {

            var layer = gLayers[index];
            var geoJson = getGeoJson(results, layer);		// Get a geoson of data

            if (!gVectorSources[index]) {
                gVectorSources[index] = new ol.source.Vector();
            } else {
                gVectorSources[index].clear();
            }
            gVectorSources[index].addFeatures((new ol.format.GeoJSON()).readFeatures(geoJson,
                {
                    dataProjection: 'EPSG:4326',
                    featureProjection: 'EPSG:3857'
                }));


            if (layer.clump === "heatmap") {
                gVectorLayers[index] = new ol.layer.Heatmap({
                    source: gVectorSources[index],
                    radius: 5,
                    id: 'heatmap'
                });
            } else {
                gVectorLayers[index] = new ol.layer.Vector({
                    source: gVectorSources[index],
                    style: window.gStyleFn,
                    id: 'base'
                });
            }

            if(layer.enabled) {
                map.addLayer(gVectorLayers[index]);
            }
            map.getView().fit(gVectorSources[index].getExtent(), map.getSize());
        }

        function deleteLayer(index) {

            if (gVectorLayers[index]) {
                gMap.removeLayer(gVectorLayers[index]);
                gVectorSources.splice(index, 1);
                gVectorLayers.splice(index, 1);
            }

        }

        function hideLayer(index) {
            map.removeLayer(gVectorLayers[index]);
        }

        function showLayer(index, map) {
            map.addLayer(gVectorLayers[index]);
        }

        /*
         * Save a layer after the user specifies it in the layer dialog
         */
        function saveLayer(map) {

            var title = $('#ml_title').val(),
                local = $('#usecurrent_tabledata').is(':checked'),
                layer = {};

            // Validation
            if (typeof title === "undefined" || title.trim().length === 0) {
                $('#layerInfo').show().removeClass('alert-success').addClass('alert-danger').html(localise.set["mf_tr"]);
                return false;
            }

            layer.title = title;
            layer.local = local;
            layer.clump = $('input[name=clump]:checked', '#mapForm').val();

            gLayers.push(layer);
            $('#layerEdit').modal("hide");	// All good close the modal

            refreshLayer(gLayers.length - 1, map);
            showLayerSelections(map);

        };

        /*
         * Process the map data according to the layer specification
         */
        function getGeoJson(results, layer) {

            var i, j, k, m;

            var geoJson = {
                type: "FeatureCollection",

                features: []
            };

            for (i = 0; i < results.length; i++) {

                var keep = false;   // default

                if (!results[i]._geolocation) {                      // Invalid Geometry
                    keep = false;
                } else {
                    // Do not show points at 0,0
                    if(results[i]._geolocation.type === "Point") {
                        for (j = 1; j < results[i]._geolocation.coordinates.length; j++) {
                            if (results[i]._geolocation.coordinates[j] != 0) {
                                keep = true;                            // At least one non zero geometry
                                break;
                            }
                        }
                    } else  if(results[i]._geolocation.type === "LineString") {
                        for (j = 0; j < results[i]._geolocation.coordinates.length; j++) {

                            for(k = 0; k < results[i]._geolocation.coordinates[j].length; k++) {
                                if (results[i]._geolocation.coordinates[j][k] != 0) {
                                    keep = true;                            // At least one non zero geometry
                                    break;
                                }
                            }
                        }
                    } else if(results[i]._geolocation.type === "Polygon") {
                        for (j = 0; j < results[i]._geolocation.coordinates.length; j++) {

                            for(k = 0; k < results[i]._geolocation.coordinates[j].length; k++) {
                                for(m = 0; m < results[i]._geolocation.coordinates[j][k].length; m++) {
                                    if (results[i]._geolocation.coordinates[j][k][m] != 0) {
                                        keep = true;                            // At least one non zero geometry
                                        break;
                                    }
                                }
                            }
                        }

                    }


                }

                if (keep) {
                    geoJson.features.push(
                        {
                            "type": "Feature",
                            //"geometry": {"type": "Point", "coordinates": results[i]._geolocation},
                            "geometry": results[i]._geolocation,
                            "properties": {
                                record: i,
                                main: true,
                                _assigned: results[i]._assigned
                            }
                        });
                }
            }

            return geoJson;
        }

        /*
         * Get the shared maps from the server
         */
        function getSharedMapsOL3(map) {

            var url = '/surveyKPI/shared/maps';
            $.ajax({
                url: url,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    globals.gSelector.setSharedMaps(data);
                    addSharedMapsOL3(map, data);
                },
                error: function(xhr, textStatus, err) {
                    if(xhr.readyState == 0 || xhr.status == 0) {
                        return;  // Not an error
                    } else {
                        alert("Error: Failed to get list of shared maps: " + err);
                    }
                }
            });

        }

        /*
         * Add shared maps
         */
        function addSharedMapsOL3(map, sharedMaps) {

            var i,
                layerUrl,
                layer;

            if(sharedMaps) {


                var baseLayers = map.getLayers().item(0).getLayers().getArray();


                for(i = 0; i < sharedMaps.length; i++) {

                    layer = sharedMaps[i];

                    if(layer.type === "mapbox") {
                        //layerUrl = 'http://api.tiles.mapbox.com/v4/' + layer.config.mapid + ".jsonp?access_token=" + globals.gMapboxDefault;
                        layerUrl = "https://api.mapbox.com/styles/v1/" + layer.config.mapid + "/tiles/{z}/{x}/{y}?access_token=" + globals.gMapboxDefault;
                        baseLayers.unshift(new ol.layer.Tile( {
                            title: layer.name,
                            type: 'base',
                            visible: false,
                            source: new ol.source.OSM({
                                url: layerUrl,
                                crossOrigin: 'anonymous'
                            })
                        }));

                    } /* else if(layer.type === "vector") {
                        layerUrl = "/surveyKPI/file/" + layer.config.vectorData + "/organisation";
                        var vectorLayer = new OpenLayers.Layer.Vector(layer.name + ".", {
                            projection: "EPSG:4326",
                            strategies: [new OpenLayers.Strategy.Fixed()],
                            protocol: new OpenLayers.Protocol.HTTP({
                                url: layerUrl,
                                format: new OpenLayers.Format.GeoJSON()
                            })
                        });
                        map.addLayer(vectorLayer);

                    }
                    */
                }
            }
        }


        /*
         ********************************
         * Functions for dynamic maps
         */

        function initDynamicMap (config, setUserLocation, selectCallback, mainMap) {

            // Add the map
            if (!config.map) {

                config.map = new ol.Map({
                    target: config.id,
                    layers: [
                        new ol.layer.Group({
                            'title': 'Base maps',
                            layers: [
                                new ol.layer.Tile({
                                    title: 'HOT',
                                    type: 'base',
                                    visible: true,
                                    source: new ol.source.OSM({
                                        url: 'http://{a-c}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png'
                                    })
                                }),
                                new ol.layer.Tile({
                                    title: 'OSM',
                                    type: 'base',
                                    visible: true,
                                    source: new ol.source.OSM()
                                })
                            ]
                        })
                    ],
                    view: new ol.View(
                        {
                            center: ol.proj.transform([0.0, 0.0], 'EPSG:4326', 'EPSG:3857'),
                            zoom: 1,
                            maxZoom: 21
                        }
                    )

                });

                // Add additional maps specified in the shared resources page
                var sharedMaps = globals.gSelector.getSharedMaps();
                if(!sharedMaps) {
                    getMapboxDefault(getSharedMapsOL3, config.map);
                } else {
                    addSharedMapsOL3(config.map, sharedMaps)
                }

                // Add the vector layer
                var features = [];
                if(config.currentValue) {
                    var currentValue = {
                        "type": "Feature",
                        "geometry": config.currentValue,
                        "properties": {
                            "type": (config.readOnly ? "current" : "old"),      // If editable then set the curent value as the old
                            "label": localise.set["c_to"]
                        }
                    };

                    features.push(currentValue);
                }
                if(config.readOnly && config.oldValue) {       // Only care about old value if we are reviewing and not editing
                    var oldValue = {
                        "type": "Feature",
                        "geometry": config.oldValue,
                        "properties": {
                            "type": "old",
                            "label": localise.set["c_from"]
                        }
                    };

                    features.push(oldValue);
                }

                var collection = {
                    "type": "FeatureCollection",
                    features: features
                };
                window.gStyleFn = function(feature, resolution) {

                    var pointFill;
                    var areaFill;
                    var line;

                    if(feature.get('main')) {
                        if(feature.get('_assigned')=== globals.gLoggedInUser.ident) {
                            pointFill = 'rgba(0, 0, 255, 1.0)';
                        } else if(feature.get('_assigned') === '') {
                            pointFill = 'rgba(255, 165, 0, 1.0)';
                        } else {
                            pointFill = 'rgba(255, 255, 255, 1.0)';
                        }
                        line = 'rgba(255, 255, 255, 0.8)';
                    } else {
                        if (feature.get('type') === 'current') {
                            pointFill = 'rgba(255, 0, 0, 1.0)';
                            areaFill = 'rgba(255, 100, 50, 0.3)';
                            line = 'rgba(255, 10, 10, 0.8)';
                        } else if (feature.get('type') === 'old') {
                            pointFill = 'rgba(0, 0, 255, 1.0)';
                            areaFill = 'rgba(50, 100, 255, 0.3)';
                            line = 'rgba(10, 10, 255, 0.8)';
                        } else {
                            pointFill = 'rgba(0, 255, 255, 1.0)';
                            areaFill = 'rgba(10, 200, 255, 0.3)';
                            line = 'rgba(10, 200, 255, 0.8)';
                        }
                    }


                    return [new ol.style.Style({
                        fill: new ol.style.Fill({
                            color: areaFill
                        }),
                        stroke: new ol.style.Stroke({
                            width: 2,
                            color: line
                        }),
                        image: new ol.style.Circle({
                            fill: new ol.style.Fill({
                                color: pointFill
                            }),
                            stroke: new ol.style.Stroke({
                                width: 2,
                                color: 'rgba(100, 100, 100, 0.8)'
                            }),
                            radius: 7
                        })
                    })];
                };

                if(collection.features.length > 0) {

                    var source = new ol.source.Vector();
                    try {
                        source.addFeatures((new ol.format.GeoJSON()).readFeatures(collection,
                            {
                                dataProjection: 'EPSG:4326',
                                featureProjection: 'EPSG:3857'
                            }));

                        var layer = new ol.layer.Vector({
                            source: source,
                            style: gStyleFn
                        });
                        config.map.addLayer(layer);

                        config.map.getView().fit(source.getExtent(), config.map.getSize());

                    } catch(err) {

                    }

                }

                var layerSwitcher = new ol.control.LayerSwitcher({
                    tipLabel: 'Legend' // Optional label for button
                });
                config.map.addControl(layerSwitcher);


                if(setUserLocation) {
                    config.geolocation = new ol.Geolocation({
                        projection: config.map.getView().getProjection(),
                        tracking: true,
                        trackingOptions: {
                            enableHighAccuracy: true,
                            maximumAge: 2000
                        }
                    });

                    var iconStyle = new ol.style.Style({
                        image: new ol.style.Icon(({
                            anchor: [0.5, 25],
                            anchorXUnits: 'fraction',
                            anchorYUnits: 'pixels',
                            opacity: 1.0,
                            src: '/js/libs/OpenLayers/img/marker-gold.png'
                        }))
                    });

                    // add an empty iconFeature to the source of the layer
                    var iconFeature = new ol.Feature();
                    var iconSource = new ol.source.Vector({
                        features: [iconFeature]
                    });
                    var iconLayer = new ol.layer.Vector({
                        source: iconSource,
                        style : iconStyle
                    });
                    config.map.addLayer(iconLayer);

                    config.geolocation.on('change', function() {
                        var pos = config.geolocation.getPosition();
                        var view = config.map.getView();
                        iconFeature.setGeometry(new ol.geom.Point(pos));
                        view.setCenter(pos);
                        view.setZoom(18);
                    });

                }

                /*
                 * Add events
                 */
                if(mainMap) {

                    config.map.on('click', function(evt) {

                        $('#features').hide().empty();

                        if (selectCallback) {
                            var properties = [];
                            config.map.forEachFeatureAtPixel(evt.pixel, function (feature, layer) {
                                properties.push(feature.getProperties());
                            });
                            selectCallback(properties);
                        }
                        ;
                    });

                } else {
                    config.map.on('click', function(evt) {

                        var noFeature = true;
                        var id = config.id;
                        var $tooltip = $('#tooltip_' + id);

                        config.map.forEachFeatureAtPixel(evt.pixel, function (feature, layer) {

                            var properties = feature.getProperties();
                            $tooltip.html(properties.label);
                            $tooltip.css(
                                {
                                    position: "absolute",
                                    left: evt.pixel[0],
                                    top: evt.pixel[1],
                                    "z-index": 20000,
                                    "background-color": "white",
                                    "padding": 2
                                }).show();
                            noFeature = false;

                            if (selectCallback) {
                                selectCallback(properties);
                            }

                        });

                        if (noFeature) {
                            $tooltip.hide();

                            if (!config.readOnly) {
                                var coord = ol.proj.transform(evt.coordinate, "EPSG:900913", 'EPSG:4326');
                                var newValue = {
                                    itemIndex: $('#' + id).data('item'),
                                    value: {
                                        coordinates: coord,
                                        type: "Point"
                                    }
                                };

                                if (config.task) {
                                    $('#taskPropertiesForm').trigger("smap_task::geopoint", newValue);
                                } else {
                                    if (newValue.itemIndex) {
                                        $('#editRecordForm').trigger("smap::geopoint", newValue);
                                    }
                                }

                                setSelectedFeature(config, evt.coordinate, undefined, undefined, false);

                            }
                        }
                    });

                }

                if(mainMap) {
                    gMap = config.map;
                    showLayerSelections(config.map);

                    $('#showlayers').click(function () {
                        globals.gMapLayersShown = !globals.gMapLayersShown;
                        if (globals.gMapLayersShown) {
                            $('#map_content').removeClass("col-md-12").addClass("col-md-8");
                            $('.map_layers').show();
                            gMap.updateSize();
                        } else {
                            $('#map_content').removeClass("col-md-8").addClass("col-md-12");
                            $('.map_layers').hide();
                            gMap.updateSize();
                        }
                    });
                }

            } else {
                console.log('Map ' + config.id + ' already initialised');
            }

            if (mainMap && gMapUpdatePending) {
                refreshAllLayers(true,  config.map);
            }


        }

        function clearSelectFeatures(config) {
            if(config.selectSource) {
                config.selectSource.clear();
                config.map.removeLayer(config.selectLayer);
                config.selectGeometry = undefined;
                config.selectSource = undefined;
                config.selectLayer = undefined;
            }

        }

        function setSelectedFeature(config, coordinate, lon, lat, recenter) {

            if(!coordinate) {
                var coord = [];
                coord.push(lon);
                coord.push(lat);
                // Convert lat lon to coordinates
                coordinate = ol.proj.transform(coord,'EPSG:4326', "EPSG:900913");

            }
            if(config.selectLayer !== undefined) {
                config.selectGeometry.setCoordinates(coordinate);
            } else {
                config.selectGeometry = new ol.geom.Point(coordinate);
                var selectFeature = new ol.Feature({
                    geometry: config.selectGeometry,
                    type: "current",
                    label: localise.set["c_to"]
                });
                config.selectSource = new ol.source.Vector({
                    features: [selectFeature]
                });
                config.selectLayer = new ol.layer.Vector({
                    source: config.selectSource,
                    style: gStyleFn
                });
                config.map.addLayer(config.selectLayer);
            }
            if(recenter) {
                config.map.getView().fit(config.selectSource.getExtent(), config.map.getSize());
            }
        }


    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));




/***/ },

/***/ "./WebContent/js/libs/icheck-shim.js"
/*!*******************************************!*\
  !*** ./WebContent/js/libs/icheck-shim.js ***!
  \*******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (window.$);


/***/ },

/***/ "./WebContent/js/libs/mapOL3-shim.js"
/*!*******************************************!*\
  !*** ./WebContent/js/libs/mapOL3-shim.js ***!
  \*******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (window.$);


/***/ },

/***/ "./WebContent/js/libs/modernizr-shim.js"
/*!**********************************************!*\
  !*** ./WebContent/js/libs/modernizr-shim.js ***!
  \**********************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (window.Modernizr);


/***/ },

/***/ "jquery"
/*!*************************!*\
  !*** external "jQuery" ***!
  \*************************/
(module) {


module.exports = jQuery;

/***/ },

/***/ "moment"
/*!*************************!*\
  !*** external "moment" ***!
  \*************************/
(module) {


module.exports = moment;

/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!****************************************!*\
  !*** ./WebContent/js/managed_forms.js ***!
  \****************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/app/localise */ "../smapServer/WebContent/js/app/localise.js");
/* harmony import */ var _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/app/globals */ "../smapServer/WebContent/js/app/globals.js");
/* harmony import */ var _smapServer_WebContent_js_app_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/app/common */ "../smapServer/WebContent/js/app/common.js");
/* harmony import */ var _smapServer_WebContent_js_libs_commonReportFunctions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/commonReportFunctions */ "../smapServer/WebContent/js/libs/commonReportFunctions.js");
/* harmony import */ var _smapServer_WebContent_js_libs_saveSvgAsPng__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/saveSvgAsPng */ "../smapServer/WebContent/js/libs/saveSvgAsPng.js");
/* harmony import */ var _smapServer_WebContent_js_libs_saveSvgAsPng__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_saveSvgAsPng__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _smapServer_WebContent_js_libs_jquery_qrcode_0_14_0_min__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/jquery-qrcode-0.14.0.min */ "../smapServer/WebContent/js/libs/jquery-qrcode-0.14.0.min.js");
/* harmony import */ var _smapServer_WebContent_js_libs_jquery_qrcode_0_14_0_min__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_jquery_qrcode_0_14_0_min__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _smapServer_WebContent_js_libs_knockout__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/knockout */ "../smapServer/WebContent/js/libs/knockout.js");
/* harmony import */ var _smapServer_WebContent_js_libs_knockout__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_knockout__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _smapServer_WebContent_js_libs_wb_plugins_slimscroll_jquery_slimscroll_min__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/wb/plugins/slimscroll/jquery.slimscroll.min */ "../smapServer/WebContent/js/libs/wb/plugins/slimscroll/jquery.slimscroll.min.js");
/* harmony import */ var _smapServer_WebContent_js_libs_wb_plugins_slimscroll_jquery_slimscroll_min__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_wb_plugins_slimscroll_jquery_slimscroll_min__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _smapServer_WebContent_js_libs_bootstrap_toggle_min__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/bootstrap-toggle.min */ "../smapServer/WebContent/js/libs/bootstrap-toggle.min.js");
/* harmony import */ var _smapServer_WebContent_js_libs_bootstrap_toggle_min__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_bootstrap_toggle_min__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _smapServer_WebContent_js_libs_bootstrap_file_input__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/bootstrap.file-input */ "../smapServer/WebContent/js/libs/bootstrap.file-input.js");
/* harmony import */ var _smapServer_WebContent_js_libs_bootstrap_file_input__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_bootstrap_file_input__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _smapServer_WebContent_js_libs_bootstrap_datetimepicker_min__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/bootstrap-datetimepicker.min */ "../smapServer/WebContent/js/libs/bootstrap-datetimepicker.min.js");
/* harmony import */ var _smapServer_WebContent_js_libs_bootstrap_datetimepicker_min__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_bootstrap_datetimepicker_min__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _app_chart__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./app/chart */ "./WebContent/js/app/chart.js");
/* harmony import */ var _app_chart__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_app_chart__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _app_mapOL3__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./app/mapOL3 */ "./WebContent/js/app/mapOL3.js");
/* harmony import */ var _app_mapOL3__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_app_mapOL3__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _app_actioncommon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./app/actioncommon */ "./WebContent/js/app/actioncommon.js");
/* harmony import */ var _app_actioncommon__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_app_actioncommon__WEBPACK_IMPORTED_MODULE_13__);
/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Purpose: Manage the panels that display graphs, maps etc of results data
 */


















const $ = window.$;
const moment = window.moment;

var gUserLocale = navigator.language;
if (typeof localStorage !== "undefined") {
    try {
        gUserLocale = localStorage.getItem('user_locale') || navigator.language;
    } catch (error) {
        gUserLocale = navigator.language;
	}
}
window.gUserLocale = gUserLocale;

_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].initLocale(gUserLocale).then(function () {
    window.moment = window.moment || moment;

    var gMapView = false;           // Set true when the map tab is shown
    var gChartView = false;         // Set true when the chart view is shown
    var gTimingView = false;        // Set true when the timing view is shown
    var gRefreshingData = false;    // Prevent double click on  refresh button
    var gAssignedCol = 0;           // Column that contains the assignment status
    var gGetSettings = false;       // Use the settings from the database rather than the client
    var gDeleteColumn = -1;         // The index of the column that indicates if the record is deleted
    var gDeleteReasonColumn = -1;   // The index of the column that has the reason for a delete
    var gBad;                       // A boolean indicating the direction of toggle of a deleted state
    var gLocalDefaults = {};
    var gPreviousUrl = "";
    var gEditUrl = '#';

    var gDrillDownNext;                 // Next drill down state if drill down is selected
    var gDrillDownStack = [];

    var gOverallMapConfig = {       // overall map
        id: 'map',
        map: undefined,
        task: false
    };

    var gTags;                      // Task Map
    var gModalMapInitialised;
    var gTaskMapConfig = {
        id: 'mapModal',
        map: undefined,
        task: true
    };

    var gCurrentGroup,
        gCurrentLocation = '-1';

    window.gTasks = {
        cache: {
            surveyConfig: {},
            managedData: {},
            surveyList: {},
            surveyRoles: {},
            recordChanges: {},
            groupSurveys: {},
            eligibleUsers: {},
            currentData: undefined,
            data: {},
        },
        charts: [
            {
                subject: "status",
                chart_type: 'bar',
                label: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_status"],
                color: 'rgb(255, 99, 132)'
            },
            {
                subject: "assigned",
                chart_type: 'bar',
                label: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["t_assigned"],
                color: 'rgb(0, 0, 255)'
            },
            {
                subject: "alert",
                chart_type: 'bar',
                label: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_alert"],
                color: 'rgb(0, 255, 0)'
            },
            {
                subject: "criticality",
                chart_type: 'bar',
                label: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_crit"],
                color: 'rgb(255, 255, 0)'
            }

        ],
        gSelectedRecord: undefined,
        gBulkInstances: [],
        gSelectedSurveyIndex: undefined,
        gUpdate: [],
        gPriKey: undefined,
        gSort: undefined,
        gDirn: undefined,
        gInitialInstance: undefined
    };
    window.gCurrentTaskFeature; // Currently edited task feature, hack to support shared functions with console
    window.gUpdateFwdPassword = undefined;
    window.gSaveType = '';
    window.gNotifications = undefined;
    window.gChanges = [];
    window.gSelectedChart = -1;
    window.gEditRecord = {};
    window.filters = [
        {
            id: 'filter_from',
            type: 'text'
        },
        {
            id: 'filter_to',
            type: 'text'
        },
        {
            id: 'include_bad',
            type: 'checkbox',
            value: false
        },
        {
            id: 'include_completed',
            type: 'checkbox',
            value: false      // default value
        },
        {
            id: 'limit',
            type: 'text',
            value: '1000'
        },
        {
            id: 'advanced_filter',
            type: 'text'
        },
        {
            id: 'my_records',
            type: 'checkbox',
            value: true      // default value
        },
        {
            id: 'unassigned_records',
            type: 'checkbox',
            value: true      // default value
        },
        {
            id: 'other_records',
            type: 'checkbox',
            value: true      // default value
        }
    ];

    $(document).ready(function () {

        window.moment = moment;
        setCustomManage();
        setTheme();
	    setupUserProfile(true);
        _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].setlang();		// Localise HTML
        userDefaults();

        // Set any default values saved from the last use of this page
        gTasks.gInitialInstance = localStorage.getItem("mfselected");   // Currently selected record

        // Set page defaults
        var def = getFromLocalStorage("console");
        if(def) {
            try {
                gLocalDefaults = JSON.parse(def);

                if(gLocalDefaults) {
                    $('#my_records').prop('checked', gLocalDefaults.myRecords);
                    $('#unassigned_records').prop('checked', gLocalDefaults.unassignedRecords);
                    $('#other_records').prop('checked', gLocalDefaults.otherRecords);
                } else {
                    gLocalDefaults = {};
                }

            } catch (err) {
                gLocalDefaults = {};
            }
        }

        $('.editRecordSection, .bulkEditSection, .selectOnly, .singleSelectOnly, .multiSelectOnly, .dd_only').hide();

        // Get the parameters and start editing a survey if one was passed as a parameter
        var params = location.search.substr(location.search.indexOf("?") + 1);
        var pArray = params.split("&");
        var dont_get_current_survey = false;
        var i;
        $('.srview').hide();
        for (i = 0; i < pArray.length; i++) {
            var param = pArray[i].split("=");
            if ( param[0] === "id" ) {
                dont_get_current_survey = true;		// Use the passed in survey id
                _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey = param[1];
                saveCurrentProject(-1, _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, undefined);	// Save the current survey id
            } else if ( param[0] === "instanceid" ) {
                _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentInstance = param[1];
                $('.mrview').hide();
                $('.srview').show();
            }
        }

        // Set custom menus
        var customMenuClass = getCustomMenuClass();
        if(customMenuClass) {
            $(customMenuClass).show();
        }

        // Get the user details
        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gIsConsoleAdmin = false;
        getLoggedInUser(refreshData, false, true, undefined, false, dont_get_current_survey);

        // Set change function on projects
        $('#project_name').change(function () {
            projectChanged();
        });

        // Get locations
        getLocations(processLocationList);

        // Get Notification Types for this server
        getNotificationTypes("console");

        // Set response to clearing single record view
        $('#clear_srview').click(function() {
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentInstance = undefined;
            $('.srview').hide();
            $('.mrview').show();
            refreshData();
        });

        // Set change function on survey
        $('#survey_name').change(function () {
            var $this = $(this);
            checkLoggedIn(function() {
                gTasks.gSelectedSurveyIndex = $this.val();
                _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey = gTasks.cache.surveyList[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject][gTasks.gSelectedSurveyIndex].id;
                gGetSettings = true;
                clearDrillDown();
                mfSurveyChanged();
                populatePdfSelect(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, $('#select_pdf'));
            });
        });

        // Set change function on group survey
        $('#oversight_survey').change(function () {
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey] = $(this).val();
            groupSurveyChanged();
        });

        // Set change function on sub form
        $('#sub_form').change(function () {
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey] = $(this).val();
            clearDrillDown();
            subFormChanged();
        });

        // Set change function on drill down
        $('#drill_down').click(function () {
          drillDown();
        });

        // Set change function on drill up
        $('#drill_up').click(function () {

            if(gDrillDownStack.length > 0) {
                gDrillDownNext = gDrillDownStack.pop();
            }
            subFormChanged();
        });

        // Set change function on controls
        $('#advanced_filter, #limit, #include_bad, #include_completed').change(function () {
            showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, true);
        });

        // Set change function on clearColumns
        $('#clearColumns').change(function() {
            $('.columnSelect').prop('checked', ($(this).prop('checked')));
        });

        /*
         * Setup dialog to change the current survey
         */
        $("#changeSurveys").click(function () {
            $("#surveySelect").modal("show");
        });

        $('.exitEditRecord').click(function(e) {
            e.preventDefault();
            showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, true);
            window.history.back();
        });

        $('.exitBulkEdit').click(function(e) {
            e.preventDefault();
            showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, true);
            window.history.back();
        });

        setupTaskDialog();
        setupNotificationDialog();

        // Enable the save notifications function
        $('#saveNotification').click(function(){sendImmediateNotification();});

        /*
         * Update the properties of a task
         */
        $('#taskPropertiesSave').off().click(function () {
            var instance;
            if(typeof gTasks !== "undefined" && gTasks.gSelectedRecord) {
                instance = gTasks.gSelectedRecord.instanceid;
            }
            saveTask(true, gCurrentTaskFeature, gSaveType, instance, doneTaskSave, 0);
        });

        window.addEventListener("popstate", function(e) {
            console.log("location: " + document.location + ", state: " + JSON.stringify(event.state));
            if(document.location.href.indexOf("#edit") == -1 && document.location.href.indexOf("#bulk") == -1) {
                exitEdit();
            }
            return false;
        });

        $('#er_form_data').change(function(){
            if($(this).prop('checked')) {
                $('.showFormData').show();
                $('.showMgmtData').addClass('col-sm-6').removeClass('col-sm-12');
            } else {
                $('.showFormData').hide();
                $('.showMgmtData').addClass('col-sm-12').removeClass('col-sm-6');
            }
        });

        $('#resetFilters').click(function() {
            resetFilters();
            checkLoggedIn(function() {
                showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, false);  // update console with changed data
            });
        });

        /*
         * Show links
         */
        $('.linksOnly').hide();
        $('#m_links').click(function(e) {
            e.preventDefault();
            showLinks();
        });

        $('#m_bulk_edit').click(function(e) {
            e.preventDefault();
            showBulkEdit();
        });

        /*
	     * View a record
	     */
        $('#m_view').click(function(e) {
            e.preventDefault();
            showRecord();
        });

        /*
         * Open the dialog to assign a user to a record
         */
        $('#m_assign_to').click(function(e) {
            e.preventDefault();
            if(gTasks.gSelectedRecord._assigned) {
                $('#user_to_assign').val(gTasks.gSelectedRecord._assigned);
            } else {
                $('#user_to_assign').val("_none");
            }
            $('#userAssign').modal("show");
        });

        /*
         * add a chart
         */
        $('#m_add_chart').click(function(e) {
            e.preventDefault();

            $('#addChartForm')[0].reset();
            gSelectedChart = -1;
            setChartPopupControls();
            $('#chart_settings_popup').modal("show");
        });

        $('#cs_subject').change(function() {
            setChartPopupControls();
        });


        /*
         * Delete a record
         */
        $('#m_delete').click(function(e) {
            e.preventDefault();
            toggleRecord(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_del"], true);
        });

        /*
         * UnDelete a record
         */
        $('#m_undelete').click(function(e) {
            e.preventDefault();
            toggleRecord(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_undel"], false);
        });

        $('#toggleRecordSave').click(function(e){
            e.preventDefault(e);
            var url = "/surveyKPI/items/" + _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey + "/survey/bad/" + gTasks.gSelectedRecord.instanceid;
            var reason = $('#toggle_reason').val();
            addHourglass();

            $.ajax({
                type: "POST",
                dataType: 'text',
                contentType: "application/x-www-form-urlencoded",
                cache: false,
                url: url,
                data: {
                    value: gBad,
                    reason: reason
                },
                success: function (data, status) {
                    removeHourglass();
                    if(handleLogout(data)) {
                        refreshData();
                    }
                }, error: function (data, status) {
                    removeHourglass();
                    if(handleLogout(data)) {
                        alert(data.responseText);
                    }
                }
            });
        });

        /*
         * Lock a record for editing by this user
         */
        $('#m_lock').click(function(e) {
            e.preventDefault();
            $('#m_lock').prop("disabled", true);     // debounce

            var url = "/surveyKPI/managed/lock/" + _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey;
            addHourglass();
            $.ajax({
                type: "POST",
                dataType: 'text',
                contentType: "application/x-www-form-urlencoded",
                cache: false,
                url: url,
                data: {
                    record: gTasks.gSelectedRecord.instanceid
                },
                success: function (data, status) {
                    removeHourglass();
                    $('#m_lock').prop("disabled", false);     // debounce
                    if(handleLogout(data)) {
                        gTasks.gSelectedRecord._assigned = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gLoggedInUser.ident;
                        showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, true);

                    }
                }, error: function (data, status) {
                    removeHourglass();
                    $('#m_lock').prop("disabled", false);     // debounce
                    if(handleLogout(data)) {
                        alert(data.responseText);
                    }
                }
            });
        });

        /*
	     * Assign a user
	     */
        $('#assignUserSave').off().click(function(e) {
            e.preventDefault();
            $('#assignUserSave').prop("disabled", true);     // debounce

            var url = "/surveyKPI/managed/assign/" + _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey + "/" + $('#user_to_assign').val();

            addHourglass();
            $.ajax({
                type: "POST",
                dataType: 'text',
                contentType: "application/x-www-form-urlencoded",
                cache: false,
                url: url,
                data: {record: gTasks.gSelectedRecord.instanceid},
                success: function (data, status) {
                    removeHourglass();
                    $('#assignUserSave').prop("disabled", false);     // debounce
                    if(handleLogout(data)) {
                        $('#userAssign').modal("hide");
                        gTasks.gSelectedRecord._assigned = $('#user_to_assign').val();
                        showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, true);
                    }
                }, error: function (data, status) {
                    removeHourglass();
                    $('#assignUserSave').prop("disabled", false);     // debounce
                    if(handleLogout(data)) {
                        alert(data.responseText);
                    }
                }
            });

        });

        /*
         * Release a record
         */
        $('#m_release').click(function(e) {
            e.preventDefault();
            $('#m_release').prop("disabled", true);     // debounce

            var url = "/surveyKPI/managed/release/" + _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey;
            addHourglass();
            $.ajax({
                type: "POST",
                dataType: 'text',
                contentType: "application/x-www-form-urlencoded",
                cache: false,
                url: url,
                data: {record: gTasks.gSelectedRecord.instanceid},
                success: function (data, status) {
                    removeHourglass();
                    $('#m_release').prop("disabled", false);     // debounce
                    if(handleLogout(data)) {
                        gTasks.gSelectedRecord._assigned = "";
                        showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, true);
                    }
                }, error: function (data, status) {
                    removeHourglass();
                    $('#m_release').prop("disabled", false);     // debounce
                    if(handleLogout(data)) {
                        alert(data.responseText);
                    }
                }
            });
        });

        /*
         * Save a record of data in managed forms
         */
        $('.saverecord').click(function (e) {
            e.preventDefault();
            var saveString = JSON.stringify(gTasks.gUpdate);
            var biString;
            if(gTasks.gBulkInstances && gTasks.gBulkInstances.length > 1) {
                biString =  JSON.stringify(gTasks.gBulkInstances)
            }
            addHourglass();
            $.ajax({
                type: "POST",
                dataType: 'text',
                contentType: "application/x-www-form-urlencoded",
                cache: false,
                url: "/surveyKPI/managed/update_gs/" + _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey + "/" + _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey],
                data: {
                    updates: saveString,
                    instanceid: gTasks.gSelectedRecord.instanceid,
                    prikey: gTasks.gSelectedRecord.prikey,
                    bulkInstances: biString,
                    groupForm: _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey],
                    tz: _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gTimezone
                },
                success: function (data, status) {
                    removeHourglass();
                    if(handleLogout(data)) {
                        // Update the current values
                        var i,
                            record = gTasks.gSelectedRecord,
                            columns = gTasks.cache.currentData.schema.columns;
                        for (i = 0; i < gTasks.gUpdate.length; i++) {
                            record[columns[gTasks.gUpdate[i].itemIndex].column_name] = gTasks.gUpdate[i].value;
                        }

                        gTasks.gUpdate = [];
                        $('.saverecord').prop("disabled", true);

                        getRecordChanges(gTasks.gSelectedRecord);
                        $('.re_alert').show().removeClass('alert-danger').addClass('alert-success').html(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_upd"]);
                    }
                }, error: function (data, status) {
                    removeHourglass();
                    if(handleLogout(data)) {
                        $('.re_alert').show().removeClass('alert-success').addClass('alert-danger').html(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_err_upd"] + data.responseText);
                    }
                }
            });
        });


        $('.genrecordpdf').click(function (e)  {
            e.preventDefault();
            $('#genPdfPopup').modal("show");
        });

        $('#genPdf').click(function(e) {
            e.preventDefault();

            var language = $('#pdf_language option:selected').val();
            var pdfTemplate = $('#select_pdf option:selected').val();
            var orientation = $("#pdf_orientation").val();
            var include_references = $("#pdf_include_references").prop('checked');
            var launched_only = $("#pdf_launched_only").prop('checked');
            var sIdent = gTasks.cache.surveyList[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject][gTasks.gSelectedSurveyIndex].ident;
            var instanceId = gTasks.gSelectedRecord.instanceid;

            downloadPdf(language, orientation, include_references, launched_only, sIdent, instanceId, pdfTemplate);
        });

        /*
         * show the settings dialog
         */
        $('#show_settings').click(function(e) {
            e.preventDefault();
            $('#settingsPopup').modal("show");
        });

        /*
         * Save response to a message edit popup
         */
        $('#messageSave').click(function(e) {
            e.preventDefault();
            var action = {
                idx: window.gMessageIdx,
                sId: _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey,
                groupSurvey: _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey],
                instanceid: gTasks.gSelectedRecord.instanceid,
                comment: $('#mComment').val()
            }

            $.ajax({
                url: "/surveyKPI/message/newcase",
                type: "POST",
                contentType: "application/x-www-form-urlencoded",
                cache: false,
                data: action,
                success: function (data) {
                    if(handleLogout(data)) {
                        $('#messagePopup').modal('hide');
                        getRecordChanges(gTasks.gSelectedRecord);
                    }
                },
                error: function (xhr, textStatus, err) {
                    removeHourglass();
                    if(handleLogout(xhr.responseText)) {
                        if (xhr.readyState == 0 || xhr.status == 0) {
                            return;  // Not an error
                        } else {
                            console.log(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_error"] + ": " + err);
                        }
                    }
                }
            });
        });

        /*
         * Save changes to the table columns that are shown
         */
        $('#saveSettings').click(function () {

            let
                config = gTasks.cache.currentData.schema,
                $this,
                newColumns = [];

            $('.card', '#tab-columns-content').each(function (index) {
                $this = $(this);
                let oldIdx = $(this).data("idx");
                let configItem = config.columns[oldIdx];

                configItem.hide = !$('input.columnSelect', $this).is(':checked');
                newColumns.push(configItem);
            });

            config.columns = newColumns;

            saveColumns(true);
        });

        // Refresh menu
        $('#m_refresh').click(function (e) {
            e.preventDefault();
            if(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable) {
                _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.off('columns-reordered').off('columns-reorder');
            }
            checkLoggedIn(function() {
                if(window.location.hash === "#edit") {
                    getRecordChanges(gTasks.gSelectedRecord);
                } else {
                    refreshData();
                }
            })
        });

        // Add a new map layer
        $('#m_add_layer').click(function (e) {
            e.preventDefault();
            $('#layerInfo').hide();
            $('#ml_title').val("");
            $('#layerEdit').modal("show");
        });

        // Respond to save on a layer edit dialog
        $('#addLayerSave').click(function (e) {
            e.preventDefault();
            _app_mapOL3__WEBPACK_IMPORTED_MODULE_12___default().saveLayer(gOverallMapConfig.map);
        });

        // Respond to a new task location being clicked
        $('#taskPropertiesForm').on("smap_task::geopoint", function (event, config) {
            gCurrentTaskFeature.geometry = config.value;
            console.log("New task geopoint");
        });

        /*
         * Take action on tab change to initialiseColumns tab contents
         * Refer: http://stackoverflow.com/questions/20705905/bootstrap-3-jquery-event-for-active-tab-change
         */
        $('a[data-toggle="tab"]', '#mainTabs').on('shown.bs.tab', function (e) {
            var target = $(e.target).attr("href") // activated tab
            var trigger;

            $('.targetSpecific').hide();
            gMapView = false;
            gChartView = false;
            gTimingView = false;

            if (target === '#tablePanel') {
                $('.tableOnly').removeClass('d-none').show();
                trigger = '#table-view';
            } else if (target === '#mapPanel') {
                $('.mapOnly').removeClass('d-none').show();
                gMapView = true;
                try {       // will fail if there is no data
                    _app_mapOL3__WEBPACK_IMPORTED_MODULE_12___default().initDynamicMap(gOverallMapConfig, false, featureSelected, true);
                } catch(err) {

                }
                trigger = '#map-view';

            } else if(target === '#chartPanel') {
                _app_chart__WEBPACK_IMPORTED_MODULE_11___default().refresh();
                $('.chartOnly').removeClass('d-none').show();
                gChartView = true;
                trigger = '#chart-view';
            } else if(target === '#timingPanel') {
                //chart.init(false, true);
                $('#m_add_chart').removeClass('d-none').show();
                gTimingView = true;
                trigger = '#timing-view';
            }
            setInLocalStorage("currentTab" + page, trigger);
        });

        $('a[data-toggle="tab"]', '#editTabs').on('shown.bs.tab', function (e) {
            var target = $(e.target).attr("href") // activated tab

            $('.historyView,.dataView').hide();

            if (target === '#data-view') {
                $('.dataView').removeClass('d-none').show();
            } else if(target === '#changes-view') {
                $('.historyView').removeClass('d-none').show();
            }

            $('.re_alert').hide();
        });

        /*
         * Respond to a location being selected
         */
        $('#location_select').change(function () {
            var idx = $(this).val();

            // Clear old values
            $('#nfc_uid').val("");
            $('#location_save_panel').hide();
            window.gSaveType = '';

            if(idx != -1) {
                $('#nfc_uid').val(gTags[idx].uid);
                var lat = gTags[idx].lat;
                var lon = gTags[idx].lon;
                if (lon || lat) {
                   _app_mapOL3__WEBPACK_IMPORTED_MODULE_12___default().setSelectedFeature(gTaskMapConfig, undefined, lon, lat, true);

                }
                gCurrentTaskFeature.geometry.coordinates[0] = lon;
                gCurrentTaskFeature.geometry.coordinates[1] = lat;
            }
        });

        /*
         * Callback when history filter changes
         */
        $('.changes_filter').change(function () {
            showHistory(window.gChanges);
        });

        /*
         * SHow and hide the controls
         */
        $('.filtersShown').show();
        $('.filtersHidden').hide();
        $('#hideFilters').click(function(e){
            e.preventDefault();
            $('.filtersShown').hide();
            $('.filtersHidden').show();
            return false;
        });

        $('#showFilters').click(function(e){
            e.preventDefault();
            $('.filtersShown').show();
            $('.filtersHidden').hide();
            return false;
        });

	    /*
         * Custom reports
         */
	    $('.server_specific').hide();
	    var ssd = getServerSubDomainName();
	    if(ssd !== '') {
            $('.' + ssd).removeClass('d-none').show();
        }
	    $('#m_tdh_individual').click(function() {
		    $('#tdh_individual_report_popup').modal("show");
	    });
	    $('#tdh_individual_report_save').click(function() {
		    var bc = $('#tdh_rep_bc').val();
		    var link = "/surveyKPI/tdh/individual/";
		    link += $('#tdh_rep_bc').val().trim();
		    link += '/individual_report';

		    if(!bc || bc.trim().length == 0) {
			    alert("Please enter a beneficiary code");
			    return;
		    }

		    downloadFile(link);
		    $('#tdh_individual_report_popup').modal("hide");
	    });

        $('#chart_settings_save').click(function() {
            if(gSelectedChart >= 0) {   // edit
                gTasks.cache.currentData.settings.charts[gSelectedChart].subject = $('#cs_subject').val();
                gTasks.cache.currentData.settings.charts[gSelectedChart].chart_type = $('#cs_chart_type').val();
                gTasks.cache.currentData.settings.charts[gSelectedChart].question = $('#cs_question').val();
                _app_chart__WEBPACK_IMPORTED_MODULE_11___default().replace(gTasks.cache.currentData.settings.charts[gSelectedChart], gSelectedChart);
            } else {
                if(gTasks.cache.currentData) {
                    var item = {
                        subject: $('#cs_subject').val(),
                        chart_type: $('#cs_chart_type').val(),
                        question: $('#cs_question').val(),
                        color: 'rgb(0, 0, 255)'
                    }
                    gTasks.cache.currentData.settings.charts.push(item);
                    _app_chart__WEBPACK_IMPORTED_MODULE_11___default().add(item);
                    setupChartEdit();
                }
            }
            $('#chart_settings_popup').modal("hide");
            _app_chart__WEBPACK_IMPORTED_MODULE_11___default().refresh();
            saveCharts();
        });

        // Set page defaults
        var currentTab = getFromLocalStorage("currentTab" + page);
        if(currentTab) {
            $(currentTab).trigger('click');
        } else {
            $('#table-view').trigger('click');
        }

        // Respond to clicking of edit button
        $('#m_edit').click(function() {
            gEditUrl = $(this).data("url");
            checkLoggedIn(editRecord);
        });
    });         // End of document ready

    // Generate a file based on current console data
    $('.genfile').click(function (e) {
        e.preventDefault();
        var format,
            $this = $(this);

        if(!$this.hasClass("disabled")) {
            $('.genfile').addClass("disabled");
            if ($this.hasClass("xls")) {
                format = "xlsx";
            } else if ($this.hasClass("pdf")) {
                format = "pdf";
            } else if ($this.hasClass("docx")) {
                format = "docx";
            } else {
                format = "image";
            }

            $('#dashboardInfo').show().removeClass('alert-danger').addClass('alert-success').html(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_ds_s"]);
            setTimeout(function () {
                $('#dashboardInfo').hide();
                $('.genfile').removeClass("disabled");
            }, 5000);
            setTimeout(function () {
                genFile(false, format);         // allow message to be displayed
            }, 0);
        }
    });

    // Generate an xls file of basic counts for all data
    $('.genxlsfileall').click(function (e) {
        e.preventDefault();
        var $groupBy = $('#srf_group');
        if(gTasks.cache.currentData.schema &&  $groupBy.html().length == 0) {
            var cols = gTasks.cache.currentData.schema.columns;
            var h = [];
            var idx = -1;
            var i;
            var currentSelectQuestion = "";
            var selectQuestion = "";

            h[++idx] = '<option value="-1">';
            h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["none"];
            h[++idx] = '</option>';

            for(i = 0; i < cols.length; i++) {

                // Don't use some types to group
                if(cols[i].type === "image" || cols[i].type === "video" || cols[i].type === "audio"
                    || cols[i].type === "prikey" || cols[i].type === "geopoint" || cols[i].type === "geoshape" || cols[i].type === "geotrace"
                    || cols[i].type === "geocompound") {

                    continue;

                }

                if(cols[i].type === "select") {
                    var n = cols[i].displayName.split(" - ");         // Handle legacy select multiple
                    if (n.length > 1) {
                        selectQuestion = n[0];
                        if(selectQuestion === currentSelectQuestion) {
                            continue;
                        } else {
                            currentSelectQuestion = selectQuestion;
                        }
                    } else {
                        selectQuestion = n;     // A compressed select multiple
                    }
                }
                h[++idx] = '<option value="';
                h[++idx] = i;
                h[++idx] = '">';
                h[++idx] = cols[i].type === "select" ? selectQuestion : cols[i].displayName;
                h[++idx] = '</option>';
            }
            $groupBy.empty().append(h.join(''));
        }
        $('#overviewReport').modal("show");
    });

    $('#overviewReportSave').click(function(e) {
        e.preventDefault();
        genFile(true, "xlsx");
        $('#overviewReport').modal("hide");
    });

    function editRecord() {
        if(gEditUrl !== '#') {
            window.location.href = gEditUrl;
        } else {
            alert(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["n_no_oversight"]);
        }
    }
    /*
     * Load the chart definitions from the server
     */
    function updateCharts(charts) {
        var i;
        _app_chart__WEBPACK_IMPORTED_MODULE_11___default().clear();
        for(i = 0; i < charts.length; i++) {
            _app_chart__WEBPACK_IMPORTED_MODULE_11___default().add(charts[i]);
        }
        setupChartEdit();
    }

    function setupChartEdit() {
        $('.fa-cog','#chartcontent').click(function(){
            gSelectedChart = $(this).data("idx");
            $('#addChartForm')[0].reset();
            $('#cs_subject').val(gTasks.cache.currentData.settings.charts[gSelectedChart].subject);
            $('#cs_chart_type').val(gTasks.cache.currentData.settings.charts[gSelectedChart].chart_type);
            $('#cs_question').val(gTasks.cache.currentData.settings.charts[gSelectedChart].question);
            $('#cs_chart_label').val(gTasks.cache.currentData.settings.charts[gSelectedChart].label);

            setChartPopupControls();
            $('#chart_settings_popup').modal("show");
        });

        $('.fa-trash','#chartcontent').click(function(){
            _app_chart__WEBPACK_IMPORTED_MODULE_11___default().remove($(this).data("idx"));
            gTasks.cache.currentData.settings.charts.splice($(this).data("idx"), 1);
            saveCharts();
            updateCharts(gTasks.cache.currentData.settings.charts);
            _app_chart__WEBPACK_IMPORTED_MODULE_11___default().refresh();
        });
    }

    /*
     * Generate a file of data
     */
    function genFile(alldata, format) {
        var url = "/surveyKPI/tables/generate",
            filename,
            mime,
            data,
            settings = [],
            groupSurvey,
            subForm,
            title = $('#survey_name option:selected').text(),
            project = $('#project_name option:selected').text(),
            charts = [],
            chartData,
            settingsObj,
            fromVal,
            toVal,
            colCount = 0,
            colName,
            colValue,
            i;

        /*
         * Get the settings
         */
        settingsObj = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.settings();
        settings.push({
            k: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["br_s"],
            v: settingsObj.search()
        });
        settings.push({
            k: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_dateq"],
            v: $('#date_question :selected').text()
        });
        settings.push({
            k: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_from_date"],
            v: $('#filter_from').val()
        });
        settings.push({
            k: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["a_to_date"],
            v: $('#filter_to').val()
        });
        settings.push({
            k: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_deleted"],
            v: $('#include_bad').prop('checked') ? _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_yes"] : _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_no"]
        });
        settings.push({
            k: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["mf_cc"],
            v: $('#include_completed').prop('checked') ? _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_yes"] : _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_no"]
        });
        if(format === "xlsx" && alldata) {
            settings.push({
                k: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["br_tf"],
                v: $('#srf_text_fn').val()
            });
            settings.push({
                k: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["br_nf"],
                v: $('#srf_num_fn').val()
            });

            var groupIdx = $('#srf_group').val();
            if(groupIdx != -1) {
                settings.push({
                    k: "Group By",
                    v: gTasks.cache.currentData.schema.columns[groupIdx].displayName
                });
            }
        }
        colCount = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.columns()[0].length;
        for (i = 0; i < colCount; i++) {
            colValue = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.column(i).search();
            if (colValue && colValue.trim().length > 2) {

                settings.push({
                    k: $(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.column(i).header()).find('span').text(),
                    v: colValue.substring(1, colValue.length - 1)	// Remove regexp
                });
            }

        }

        var tz = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gTimezone;
        var sId = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey;

        data = getTableData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable, gTasks.cache.currentData.schema.columns, format);

        if (format === "xlsx") {
            filename = title + ".xlsx";
            mime = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (format === "pdf") {
            filename = title + ".pdf";
            mime = "application/pdf";
        } else if (format === "docx") {
            filename = title + ".docx";
            mime = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        } else {
            // image
            filename = title + ".zip"
            mime = "application/zip";
        }

        if(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey] && _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey] != "") {
            groupSurvey = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey];
        }
        if(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey] && _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey] != "") {
            subForm = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey];
            if(subForm === '_none') {
                subForm = undefined;
            }
        }
        if(!subForm) {
            // Check that we have not drilled down
            var drillDownState;

            if(gDrillDownStack.length > 0) {
                drillDownState = gDrillDownStack[gDrillDownStack.length  - 1];
            }

            if(drillDownState) {
                sId = drillDownState.survey;

                // Set subform
                if(drillDownState.type === "sub_form") {
                    subForm = drillDownState.form;
                }
            }
        }

        generateFile(url, filename, format, mime, data, sId, groupSurvey, title, project, charts, chartData,
            settings,
            tz,
            subForm);      // formName
    }

    // Respond to duplicate gReports menu
    if (isDuplicates) {
        $('#duplicateSearch').click(function () {
            showDuplicateData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey);
        });
    }

    /*
     * Add filtering by date et al to datatable
     */
    if (!isDuplicates) {
        $.fn.dataTableExt.afnFiltering.push(
            function (oSettings, aData, iDataIndex) {

                if(filterOutAssignments(aData)) {
                    return false;
                }
                //if(filterOutDate(aData)) {
                //    return false;
                //}
                return true;

            }
        );
    }

    /*
     * Test if this record should be filtered out based on its assignment
     */
    function filterOutAssignments(aData) {
        var myRecords = $('#my_records').prop('checked'),
            unassignedRecords = $('#unassigned_records').prop('checked'),
            otherRecords = $('#other_records').prop('checked');

        if(myRecords && unassignedRecords && otherRecords) {
            return false;
        }

        var assignment = aData[gAssignedCol];
        if(myRecords && assignment === _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gLoggedInUser.ident) {
            return false;
        }
        if(unassignedRecords && assignment === '') {
            return false;
        }
        if(otherRecords && assignment !== '' && assignment !== _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gLoggedInUser.ident) {
            return false;
        }
        return true;
    }

    /*
     * Function called when the current survey is changed
     */
    function mfSurveyChanged() {


        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gViewId = 0;        // TODO remember views set for each survey and restore

        getEligibleUsers(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, false);

        $('.editRecordSection, .bulkEditSection, .selectedOnly, .singleSelectOnly, .multiSelectOnly, .re_alert, .dd_only').hide();
        if (_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey > 0 && typeof gTasks.gSelectedSurveyIndex !== "undefined") {

            getLanguageList(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, undefined, false, '.language_sel', false, -1);
            saveCurrentProject(-1, _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey);
            getGroupSurveys(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey,  groupsRetrieved);
            groupSurveyChanged();

        } else {
            // No surveys in this project
            $('#content').empty();
            gRefreshingData = false;
        }
    }

    /*
     * Function called when the current group survey is changed
     */
    function groupSurveyChanged() {

        if (_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey > 0 && typeof gTasks.gSelectedSurveyIndex !== "undefined") {

            saveCurrentGroupSurvey(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey,
                _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey],
                _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey]);

            showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, false);

        }
    }

    /*
     * Function called when the current sub form is changed
  */
    function subFormChanged() {

        if (_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey > 0 && typeof gTasks.gSelectedSurveyIndex !== "undefined") {
            saveCurrentGroupSurvey(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey,
                _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey],
                _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey]);
            showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, false);
        }
    }

    /*
     * Refresh the data used in this page
     */
    function refreshData() {

        if(!gRefreshingData) {
            gRefreshingData = true;
            //gTasks.cache.surveyConfig = {};
            gTasks.cache.managedData = {};
            gTasks.cache.surveyList = {};
            gTasks.cache.surveyRoles = {};
            gTasks.cache.recordChanges = {};
            gTasks.cache.groupForms = {};
            gTasks.cache.currentData = undefined;
            gTasks.cache.data = {};

            gGetSettings = true;    // Use settings from server

            // Get the list of available surveys
            loadManagedSurveys(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject, mfSurveyChanged);
            populatePdfSelect(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, $('#select_pdf'));
            getTaskUsers(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject);	// Get the users that have access to this project
        }

    }

    /*
     * Function called when the current project is changed
     */
    function projectChanged() {

        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject = $('#project_name option:selected').val();
        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey = -1;
        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentTaskGroup = undefined;

        saveCurrentProject(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject,
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey,
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentTaskGroup);

        refreshData();

    }

    /*
     * Show the survey data along with the management columns
     */
    function showManagedData(sId, callback, clearCache) {

        var groupSurvey,
            subForm,
	        drillDownState;

        if(gDrillDownStack.length > 0) {
        	drillDownState = gDrillDownStack[gDrillDownStack.length  - 1];
        }

        if(drillDownState) {
            sId = drillDownState.survey;
        }

        // Set subform
        if(drillDownState && drillDownState.type === "sub_form") {
            subForm = drillDownState.form;
        } else {
            if (_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[sId] && _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[sId] != "") {
                subForm = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[sId];
                if (subForm === '_none') {
                    subForm = undefined;
                }
            }
        }


        // Set Group survey
	    if (_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[sId] && _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[sId] != "") {
		    groupSurvey = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[sId];
	    }

        getData(sId, groupSurvey, subForm, callback, clearCache);
    }

    /*
     * Show the table
     */
    function showTable(dataSet) {

        var x = 1,
            columns,
            parameters,
            shownColumns = [],
            hiddenColumns = [],
            visibleColumns = [],
            h = [],
            idx = -1,
            hfoot = [],
            foot_idx = -1,
            i, j,
            $table = $("#trackingTable"),
            doneFirst = false,
            headItem,
            hColSort = [],
            hDups = [],
            hSelect = [],
            hColSortIdx = -1,
            hDupsIdx = -1,
            hSelectIdx = -1;


        if ( $.fn.dataTable.isDataTable( $table) && _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable) {
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.destroy();
        }

        if(dataSet.schema) {
            columns = dataSet.schema.columns;
        } else {
            columns = [];
        }

        // Add head
        h[++idx] = '<thead>';
        h[++idx] = '<tr>';

        for (i = 0; i < columns.length; i++) {
            headItem = columns[i];

            hColSort[++hColSortIdx] = addToColumnSort(headItem, i);
            hSelect[++hSelectIdx] = addToColumnSelect(headItem);
            if(isDuplicates) {
                hDups[++hDupsIdx] = addToDuplicateReportSelect(headItem);
            }

            shownColumns.push({
                "data": headItem.column_name
            });
            h[++idx] = '<th>';
            h[++idx] = '<span class="ch">';
            h[++idx] = htmlEncode(headItem.displayName);
            h[++idx] = '</span>';
            h[++idx] = '</th>';
            hfoot[++foot_idx] = '<th></th>';

            if (headItem.hide) {
                hiddenColumns.push(i);
            } else {
                visibleColumns.push(i);
            }
        }
        h[++idx] = '</tr>';


        h[++idx] = '</thead>';
        h[++idx] = '<tfoot>';
        h[++idx] = '<tr>';
        h[++idx] = hfoot.join('');
        h[++idx] = '</tr>';
        h[++idx] = '</tfoot>';

        // close table
       // h[++idx] = '</table>';

        $table.empty().html(h.join(''));

        /*
         * Apply data tables
         */
        $.fn.dataTable.ext.errMode = 'none';

        // Create data table
        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable = $table.DataTable({
            processing: true,
            scrollY: '70vh',
            scrollX: true,
            scrollCollapse: true,
            paging: true,
            pageLength:100,
            select: {
                selector: 'td'
            },
            rowId: 'instanceid',
            data: dataSet.data,
            columns: shownColumns,
            order: [0],
            initComplete: function (settings, json) {

                if(parameters && parameters.form_data === 'off') {
                    $('.manageFormData').hide();
                    $('.showFormData').hide();
                    $('.showMgmtData').addClass('col-sm-12').removeClass('col-sm-6');
                }

                this.api().columns().every(function (colIdx) {
                    if (columns[colIdx].filter || columns[colIdx].type === "select1"
                            || columns[colIdx].type === "calculate") {
                        var column = this;
                        var select = $('<select class="form-control">')
                            .appendTo( $(column.header()))
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );
                                column
                                    .search( val ? '^'+val+'$' : '', true, false )
                                    .draw();

                                saveFilter(colIdx, val);
                            });

                        select.append( '<option value=""></option>' );
                        column.data().unique().sort().each( function ( d, j ) {
                            if(d && d.length > 0) {
                                select.append('<option value="' + d + '">' + d + '</option>')
                            }
                        } );
                        select.append('</select>');

                        //Set current value
                        if (columns[colIdx].filterValue) {
                            select.val(columns[colIdx].filterValue).trigger('change');
                        }
                    }

                });
            },

            columnDefs: [
                {
                    targets: "_all",
                    render: function (data, type, full, meta) {
                        return addAnchors(data, true).join(',');
                    }
                },
                {
                    visible: false,
                    "targets": hiddenColumns
                },
                {
                    visible: true,
                    "targets": visibleColumns
                }
            ],
            language: {
                url: _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].dt()
            }
        });

        // Respond to an error
        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.on('error.dt', function (e, settings, techNote, message) {
            alert(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_error"] + ": " + message);
            gRefreshingData = false;
        });

        // Respond to selection of a row
        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.off('select').on('select', function (e, dt, type, indexes) {
            recordSelected(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.rows('.selected').data());
        });
        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.off('deselect').on('deselect', function (e, dt, type, indexes) {
            recordSelected(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.rows('.selected').data());
        });

        // Highlight data conditionally, set barcodes
        tableOnDraw();
        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.off('draw').on('draw', function () {
            tableOnDraw();
        });

        $('.table_filter').off().on('blur', function (e) {
            e.preventDefault();
            showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, false);  // update console with changed data
        });

        // Respond to changes that filter data on assignment
        $('.assign_filter:checkbox').change(function () {
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.draw();

            checkFilters();
            gLocalDefaults.myRecords = $('#my_records').prop('checked');
            gLocalDefaults.unassignedRecords = $('#unassigned_records').prop('checked');
            gLocalDefaults.otherRecords = $('#other_records').prop('checked');
            setInLocalStorage("console", JSON.stringify(gLocalDefaults));
        });

        // Respond to change of search
        $('#trackingTable_filter input').focusout(function () {
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.draw();
        });

        /*
         * Settings
         */
        $('#tab-columns-content').html(hColSort.join(''));
        Sortable.create(document.getElementById('tab-columns-content'), {animation: 150});
        $('#cs_question').html(hSelect.join(''));

        /*
         * Duplicates modal
         */
        if(isDuplicates) {
            $('#duplicateSelect').html(hDups.join(''));
        }

    }

    /*
     * Set context specific controls in chart dialog
     */
    function setChartPopupControls() {
        var subject = $('#cs_subject').val();

        $('.qonly').hide();

        if(subject === 'question') {
            $('.qonly').show();
        }
    }

    function check(a) {
        return window.colval === a || window.colval === "" || a === "";
    }

    /*
     * Show duplicates data
     */
    function showDuplicateData(sId) {

        var searchCriteria = getSearchCriteria();
        var url = '/surveyKPI/api/data/similar/' + sId + '/' + searchCriteria + "?format=dt";
        url += "&tz=" + encodeURIComponent(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gTimezone);

        if(searchCriteria && searchCriteria.length > 0) {
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.ajax.url(url).load();
        }
    }

    /*
     * Get the search criteria for a duplicate search
     */
    function getSearchCriteria() {
        var criteria = "";

        $('input', '#duplicateSelect').each(function (index) {
            var $this = $(this),
                fn;

            if ($this.is(':checked')) {
                if (criteria.length > 0) {
                    criteria += ',';
                }
                fn = $this.closest('.row').find('select').val();
                criteria += $this.val() + '::' + fn;
            }

        });

        return criteria;
    }

    /*
     * Add the column to the settings
     */
    function addToColumnSort(item, colIndex) {
        var h = [],
            idx = -1;

        h[++idx] = '<div class="card" data-idx="';
        h[++idx] = colIndex;
        h[++idx] = '">';
        h[++idx] = '<div class="card-body pt-1 pb-1">';
        h[++idx] = '<div class="row">';
        h[++idx] = '<div class="col-sm-6">';
        h[++idx] = htmlEncode(item.displayName);
        h[++idx] = '</div>';

        h[++idx] = '<div class="col-sm-6">';
        h[++idx] = '<div class="switch">';
        h[++idx] = '<input type="checkbox" name="columnSelect"';
        h[++idx] = ' class="columnSelect" value="';
        h[++idx] = item.displayName;
        h[++idx] = '"';
        if(!item.hide) {
            h[++idx] = ' checked';
        }
        h[++idx] = '>';
        h[++idx] = '</div>';
        h[++idx] = '</div>';

        h[++idx] = '</div>'; // row
        h[++idx] = '</div>'; // Card body

        h[++idx] = '</div>';  // card

        return h.join('');
    }

    /*
     * Add the column to column select
    */
    function addToColumnSelect(item) {
        var h = [],
            idx = -1;

        if (item.include) {
            h[++idx] = '<option value="';
            h[++idx] = item.displayName;
            h[++idx] = '">';
            h[++idx] = htmlEncode(item.displayName);
            h[++idx] = '</option>';
        }
        return h.join('');
    }

    /*
     * Add the column to the select list for duplicate searches
     */
    function addToDuplicateReportSelect(item) {
        var h = [],
            idx = -1;

        if (item.include && !item.mgmt) {
            h[++idx] = '<div class="row">';
            //h[++idx] = '<div class="setings-item">';

            h[++idx] = '<div class="col-sm-1">';
            h[++idx] = '<input type="checkbox" name="columnSelect"';
            h[++idx] = ' class="columnSelect" value="';
            h[++idx] = item.displayName;
            h[++idx] = '"';
            h[++idx] = '>';
            h[++idx] = '</div>';

            h[++idx] = '<div class="col-sm-4">';
            h[++idx] = '<span>';
            h[++idx] = item.displayName;
            h[++idx] = '</span>';
            h[++idx] = '</div>';


            h[++idx] = '<div class= "col-sm-4">';
            h[++idx] = '<select>';
            h[++idx] = '<option value="exact">';
            h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["br_exact"];
            h[++idx] = '</option>';
            h[++idx] = '<option value="lower">';
            h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["br_ci"];
            h[++idx] = '</option>';
            h[++idx] = '<option value="soundex">';
            h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["br_sdx"];
            h[++idx] = '</option>';
            h[++idx] = '</select>';
            h[++idx] = '</div>';

            h[++idx] = '</div>';		// Row

        }
        return h.join('');
    }

    /*
     * Return the currently selected survey ident
     */
    function surveyIdentAndOversight() {
        var survey = gTasks.cache.surveyList[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject][$('#survey_name').val()];
        var oversightSurvey = $('#oversight_survey').val();
        var resp = survey.ident;
        if(oversightSurvey) {
            resp += "?oversight=" + oversightSurvey;
        }
        return resp;
    }

    /*
     * Get surveys and update the survey lists on this page
     *  This is a different function from the common loadSurveys function as it only loads data surveys
     *  and not oversight surveys
     */
    function loadManagedSurveys(projectId, callback) {

        var url = "/surveyKPI/surveys?projectId=" + projectId + "&blocked=true",
            $elemSurveys = $('#survey_name');


        if (typeof projectId !== "undefined" && projectId != -1 && projectId != 0) {

            addHourglass();
            gRefreshingData = false;
            $.ajax({
                url: url,
                dataType: 'json',
                cache: false,
                success: function (data) {
                    removeHourglass();
                    if(handleLogout(data)) {

                        var i,
                            item,
                            h = [],
                            idx = -1,
                            firstSurvey = true,
                            firstSurveyId = undefined,
                            firstSurveyIndex = undefined;

                        gTasks.cache.surveyList[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject] = data;
                        gTasks.gSelectedSurveyIndex = undefined;

                        for (i = 0; i < data.length; i++) {
                            item = data[i];

                            if (item.dataSurvey && !item.readOnlySurvey) {
                                h[++idx] = '<option value="';
                                h[++idx] = i;
                                h[++idx] = '">';
                                h[++idx] = htmlEncode(item.displayName);
                                h[++idx] = '</option>';

                                if (firstSurvey) {
                                    firstSurveyId = item.id;
                                    firstSurveyIndex = i;
                                    firstSurvey = false;
                                }

                                if (item.id == _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey) {
                                    gTasks.gSelectedSurveyIndex = i;
                                }
                            }
                        }

                        $elemSurveys.empty().html(h.join(''));

                        if (!gTasks.gSelectedSurveyIndex && firstSurveyId) {
                            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey = firstSurveyId;
                            gTasks.gSelectedSurveyIndex = firstSurveyIndex;
                        } else if (gTasks.gSelectedSurveyIndex && firstSurveyId) {
                            $elemSurveys.val(gTasks.gSelectedSurveyIndex);
                        }

                        if (typeof callback == "function") {
                            callback();
                        }
                    }
                },
                error: function (xhr, textStatus, err) {

                    removeHourglass();
                    gRefreshingData = false;
                    if(handleLogout(xhr.responseText)) {
                        if (xhr.readyState == 0 || xhr.status == 0) {
                            return;  // Not an error
                        } else {
                            console.log(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_error"] + ": " + err);
                        }
                    }
                }
            });
        } else {
            gRefreshingData = false;
        }
    }

    /*
     * Update the group selector
     */
    function groupsRetrieved(data) {

        setOversightSelector(data);
        setGroupSelector(data);

    }

    /*
     * Update a selector that is used for oversight forms and does not include current form
     */
    function setOversightSelector(data) {
        var $elemGroups = $('#oversight_survey');

        var i,
            item,
            h = [],
            idx = -1;

        h[++idx] = '<option value="';
        h[++idx] = '">';
        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_none"];
        h[++idx] = '</option>';

        for (i = 0; i < data.length; i++) {
            item = data[i];

            if (item.sId !== _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey && item.oversightSurvey) {       // Don't include current survey

                h[++idx] = '<option value="';
                h[++idx] = item.surveyIdent;
                h[++idx] = '">';
                h[++idx] = htmlEncode(item.surveyName);
                h[++idx] = '</option>';

            }
        }

        $elemGroups.empty().html(h.join(''));

        /*
		 * Set the value
		 */
        if(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey > 0 && _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys
            && _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey]
            && _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey] != "") {

            var val = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey];
            var exists = false;
            for(i = 0; i < data.length; i++) {
                if (data[i].surveyIdent === val) {
                    exists = true;
                    break;
                }
            }
            if(exists) {
                $elemGroups.val(val);
            } else {
                $elemGroups.val("");
                _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gGroupSurveys[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey] = undefined;
                groupSurveyChanged();
            }
        } else {
            $elemGroups.val("");        // None
        }
    }

    /*
     * Update the pick list of forms
     */
    function updateFormList(data) {
        var $elem = $('#sub_form');

        var i,
            h = [],
            idx = -1;

        h[++idx] = '<option value="_none">';
        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_none"];
        h[++idx] = '</option>';

        if(data && data.length) {
            for (i = 0; i < data.length; i++) {

                if(data[i].type === 'sub_form') {
                    h[++idx] = '<option value="';
                    h[++idx] = data[i].name;
                    h[++idx] = '">';
                    h[++idx] = data[i].name;
                    h[++idx] = '</option>';
                }
            }
        }

        $elem.empty().html(h.join(''));
        if(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey]) {
            $elem.val(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gSubForms[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey]);
        }

    }

    /*
     * Update the drill down list of forms
     */
    function updateDrillDownFormList() {
        var $drillDown = $('#drill_down_list'),
            data = gTasks.cache.currentData.forms;

        var i,
            h = [],
            idx = -1,
            setDefault = false,
	        parentForm,
	        drillDownState;

        if(gDrillDownStack.length > 0) {
        	drillDownState = gDrillDownStack[gDrillDownStack.length - 1];
        }

        if(drillDownState) {
            if(drillDownState.type === 'sub_form') {
                parentForm = drillDownState.form;
            } else {
                parentForm = "main";
            }
        } else {
		    parentForm = $('#sub_form').val();
		    if(parentForm === "_none") {
			    parentForm = "main";
		    }
	    }

	    $('#dd_form').html("");
	    gDrillDownNext = undefined;

        if(data && data.length) {

            for (i = 0; i < data.length; i++) {
                // Add to drill down
                if (parentForm && data[i].parentName == parentForm) {
                    h[++idx] = '<a class="dropdown-item dd_form" href="#" data-form="';
                    h[++idx] = data[i].name;
                    h[++idx] = '"';
                    h[++idx] = ' data-type="';
                    h[++idx] = data[i].type;
	                h[++idx] = '"';

                    if(data[i].surveyId) {
	                    h[++idx] = ' data-survey="';
	                    h[++idx] = data[i].surveyId;
	                    h[++idx] = '"';
                    }

	                if(data[i].keyQuestion) {
		                h[++idx] = ' data-key="';
		                h[++idx] = data[i].keyQuestion;
		                h[++idx] = '"';
	                }

                    h[++idx] = '>';
                    h[++idx] = data[i].name;
                    h[++idx] = '</a>';

                    if(!setDefault) {
                        $('#dd_form').html(data[i].name);

                        gDrillDownNext = {
	                        form: data[i].name,
	                        type: data[i].type,
	                        survey: data[i].surveyId,
	                        key: data[i].keyQuestion
                        }
                        setDefault = true;
                    }
                }
            }

        }

        $drillDown.empty().html(h.join(''));

        // Respond to selection of a form to drill down to:
        $('.dd_form', $drillDown).click(function(){
            var $this = $(this);
            $('#dd_form').html($this.data("form"));
            gDrillDownNext = {
	            form: $this.data("form"),
	            type: $this.data("type"),
	            survey: $this.data("survey"),
	            key: $this.data("key")
            }
            drillDown();
        });

    }

    function updateVisibleColumns(cols) {
        var i,
            hiddenColumns = [],
            visibleColumns = [];

        for (i = 0; i < cols.length; i++) {
            if (cols[i].hide) {
                hiddenColumns.push(i);
            } else {
                visibleColumns.push(i);
            }
        }

        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.columns(hiddenColumns).visible(false, false);
        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.columns(visibleColumns).visible(true, false);
        $('#trackingTable').width('auto');
        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.columns.adjust().draw(); // adjust column sizing and redraw
    }

    /*
     * Save a filter setting
     */
    function saveFilter(column, value) {

        var
            config = gTasks.cache.currentData.schema,
            i;

        if (value == '') {
            value = undefined;
        }

        for (i = 0; i < config.columns.length; i++) {
            if (config.columns[i].colIdx == column) {
                config.columns[i].filterValue = value;
                break;
            }
        }
        saveColumns(false);
    }

    /*
     * Save the current charts configuration
     */
    function saveCharts() {

        var saveView = JSON.stringify(gTasks.cache.currentData.settings.charts);

        var url = "/surveyKPI/charts/save/" + _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey;

        addHourglass();
        $.ajax({
            type: "POST",
            cache: false,
            contentType: "application/x-www-form-urlencoded",
            url: url,
            data: {chartArray: saveView},
            success: function (data, status) {
                removeHourglass();
                handleLogout(data);
            }, error: function (data, status) {
                removeHourglass();
                if(handleLogout(data)) {
                    alert(data.responseText);
                }
            }
        });
    }

    /*
     * Update the saved configuration
     */
    function saveColumns(refresh) {
        var configColumns = {},
            columns = gTasks.cache.currentData.schema.columns,
            i;

        for (i = 0; i < columns.length; i++) {
            configColumns[columns[i].column_name] = {
                hide: columns[i].hide,
                barcode: columns[i].barcode,
                includeText: columns[i].includeText,
                filterValue: columns[i].filterValue,
                seq: i
            };
        }

        var saveView = JSON.stringify(configColumns);

        var url = "/surveyKPI/survey/" + _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey + "/console_settings/columns";

        addHourglass();
        $.ajax({
            type: "POST",
            cache: false,
            contentType: "application/x-www-form-urlencoded",
            url: url,
            data: {columns: saveView},
            success: function (data, status) {
                removeHourglass();
                if(handleLogout(data)) {
                    if(refresh) {
                        showManagedData(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, showTable, false); // redraw
                        $('#right-sidebar').removeClass("sidebar-open");
                    }
                }
            }, error: function (data, status) {
                removeHourglass();
                if(handleLogout(data)) {
                    alert(data.responseText);
                }
            }
        });
    }

    /*
     * Perform initialisation after the data has been loaded
     */
    function initialiseColumns() {


        var columns = gTasks.cache.currentData.schema.columns,
            i,
            h = [],
            idx = -1,
            select_questions = {};

        /*
         * Add an indicator to columns if they can be used as a chart question in summary reports
         * Merge choices in select multiples
         */
        var firstDate = undefined;
        for(i = 0; i < columns.length; i++) {
            var d = columns[i];

            if(
                d.displayName !== "prikey" &&
                d.displayName !== "_upload_time" &&
                d.displayName !== "_start" &&
                d.displayName !== "_end" &&
                d.type !== "geopoint" &&
                d.type !== "dateTime" &&
                d.type !== "time" &&
                d.type !== "date" &&
                d.type !== "image" && d.type !== "video" && d.type !== "audio") {
                d.chartQuestion = true;
            } else {
                d.chartQuestion = false;
            }

            if(d.type === "select") {
                var n = d.displayName.split(" - ");
                if (n.length > 1) {

                    if (!select_questions[n[0]]) {		// New choice

                        d.select_name = n[0];
                        d.choices = [];
                        d.choiceNames = [];
                        d.choices.push(d.displayName);
                        d.choiceNames.push(d.displayName);

                        select_questions[n[0]] = d;
                        d.chartQuestion = true;
                    } else {
                        var f = select_questions[n[0]];
                        f.choices.push(d.displayName);
                        f.choiceNames.push(d.displayName);
                        d.chartQuestion = false;
                    }
                }
            } else if(d.type === "dateTime" || d.type === "date") {

                if(!firstDate) {
                    firstDate = columns[i].column_name;
                }
                    h[++idx] = '<option value="';
                    h[++idx] = columns[i].column_name;
                    h[++idx] = '">';
                    h[++idx] = htmlEncode(columns[i].displayName);
                    h[++idx] = '</option>';
            } else if (d.displayName === '_assigned') {
                gAssignedCol = i;
            }

        }
        var dq = $('#date_question').val();
        if(!dq) {
            dq = firstDate;
        }
        $('#date_question').empty().html(h.join('')).val(dq);
    }

    function exitEdit() {
        if(gTasks.gUpdate.length > 0) {
            if (!confirm(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_unsav"])) {
                return;
            } else {
                gTasks.gUpdate = [];
            }
        }
        $('.overviewSection,.mrview').show();
        $('.editRecordSection,.bulkEditSection,.srview,.re_alert').hide();
    }

    /*
     * Respond to a map feature being selected
     */
    function featureSelected(properties) {
        var data = [];
        var indexes = [];
        var i;
        if(properties && properties.length > 0) {
            for(i = 0; i < properties.length; i++) {
                indexes.push(properties[i].record);
            }
            data = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.rows(indexes).data().toArray();

            showSelectedMapData(properties);

        } else {
            $('#features').hide().empty();
        }
        recordSelected(data);

    }

    /*
     * Show data from features selected on a map
     */
    function showSelectedMapData(properties) {

        var schema = gTasks.cache.currentData.schema,
            $element = $('#features'),
            columns = schema.columns,
            configItem,
            i, j,
            h = [],
            idx = -1,
            records = [];

        h[++idx] = '<img id="fDel" src="/app/fieldAnalysis/img/delete.png"/><br/>';
        h[++idx] = '<div id="feature_data">';
        if(properties.length > 0) {

            for(i = 0; i < properties.length; i++) {
                records.push(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.rows(properties[i].record).data().toArray()[0]);
            }
            h[++idx] = '<div class="row">';
            h[++idx] = '<div class="col-md-12 col-xs-12 table-responsive billing_enabled">';
            h[++idx] = '<table class="table table-striped">';
            h[++idx] = '<tbody>';
            // Add data
            for (i = 0; i < columns.length; i++) {
                configItem = columns[i];
                if(configItem.type === 'geopoint' || configItem.type === 'geotrace' || configItem.type === 'geoshape'
                    || configItem.type === 'geocompound') {
                    continue;
                }
                h[++idx] = '<tr>';
                h[++idx] = addCell(translateKey(configItem.displayName));
                for(j = 0; j < properties.length; j++) {
                    h[++idx] = addCell(translateKeyValue(configItem.displayName, records[j][configItem.column_name]));
                }
                h[++idx] = '</tr>';
            }
            // End data
            h[++idx] = '</tbody>';
            h[++idx] = '</table>';
            h[++idx] = '</div>';
            h[++idx] = '</div>';
        }
        h[++idx] = '</div>';

        $element.html(h.join('')).show();
        $('#fDel', $element).off().click(function() {	// Closing the panel manually
            $("#features").hide().empty();
        });


    }

    /*
	 * Get the markup to show features
	 */
    function addCell(item) {

        var h = [],
            idx = -1;

        // Add form group and label
        h[++idx] = '<td>';
        h[++idx] = addAnchors(item, true);
        h[++idx] = '</td>';


        return h.join('');
    }

    /*
     * Respond to a record of data being selected
     */
    function recordSelected(records) {

        var assignedOther = false,
            i;

        $('.selectOnly, .multiSelectOnly, .singleSelectOnly').hide();
        $('.dd_only,.du_only').hide();

        gTasks.gSelectedRecord = undefined;
        gTasks.gBulkInstances = [];

        if(records.length === 0) {
            /*
			 * No records are selected
			 */
            $('.selectOnly, .dd_only').hide();

        } else if(records.length > 1) {
            /*
             * Multiple records are selected
             */

            // Set selected record to first record selected
            gTasks.gSelectedRecord = records[0];

            for(i = 0; i < records.length; i++) {
                gTasks.gBulkInstances.push(records[i].instanceid);
            }

            /*
             * Multi select is only available for Admin, Security Manager and analyst roles
             */
            if(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gIsSecurityAdministrator || _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gIsAdministrator || _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gIsAnalyst) {
                $('.multiSelectOnly').show();
            }

        } else {
            /*
			 * Only a single record is selected
			 */
            //gTasks.gSelectedRecord = globals.gMainTable.rows(gTasks.gSelectedIndexes).data().toArray()[0];
            gTasks.gSelectedRecord = records[0];
            if (gTasks.gSelectedRecord._assigned && gTasks.gSelectedRecord._assigned === _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gLoggedInUser.ident) {
                $('.assigned').show();
            } else if (gTasks.gSelectedRecord._assigned && gTasks.gSelectedRecord._assigned !== _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gLoggedInUser.ident) {
                $('.assigned_other').show();
                assignedOther = true;
            } else {
                $('.not_assigned').show();
            }

            // Set up the record edit button if there is an oversight form
            var oversightIdent = $('#oversight_survey').val();
            if(oversightIdent && oversightIdent.length > 0) {
                var instanceId = gTasks.gSelectedRecord.instanceid;
                var url = "/app/myWork/webForm/" + oversightIdent + "?datakey=instanceid&datakeyvalue=" + instanceId;
                url += addCacheBuster(url)
                $('#m_edit').data("url", url);
                localStorage.setItem("mfselected", instanceId);
            } else {
                $('#m_edit').data("url", "#");
            }

            // Set up the drill down
            if(gDrillDownStack.length > 0) {
                $('.du_only, .drill_only').show();
            }

            updateDrillDownFormList();
            if(gDrillDownNext) {
                $('.dd_only, .drill_only').show();
            }

            var columns = gTasks.cache.currentData.schema.columns;
            if(!assignedOther) {
                if ((gDeleteColumn < 0 || gTasks.gSelectedRecord[columns[gDeleteColumn].question_name] === 'f')) {
                    $('.not_deleted').show();
                } else if (gDeleteColumn >= 0 && gTasks.gSelectedRecord[columns[gDeleteColumn].question_name] === 't') {
                    $('.deleted').show();
                }
            }

            if(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gIsAdministrator) {
                $('.assigned_admin').show();
            }

            if(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gIsAdministrator || _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gIsConsoleAdmin) {
                $('.assigned_console_admin').show();
            }

            if(!_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gIsLinkFollower) {
                $('.linksOnly').hide();
            }
        }

    }

    /*
     * Set up the user defaults on the page
     * TODO restore these from local session storage
     */
    function userDefaults() {
        $('#my_records').prop('checked', true);
        $('#unassigned_records').prop('checked', true);
        $('#other_records').prop('checked', true);
    }

    /*
     * Get the list of changes to this record from the server
     */
    function getRecordChanges(record) {

        if(record && _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey) {
            addHourglass();
            $.ajax({
                url: "/surveyKPI/api/data/changes/" + _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey + "/" + record["instanceid"] +
                    '?tz=' + encodeURIComponent(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gTimezone),
                dataType: 'json',
                cache: false,
                success: function (data) {
                    removeHourglass();
                    if(handleLogout(data)) {
                        window.gChanges = data;
                        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gRecordChangeMaps = [];     // Initialise the list of maps we are going to show

                        showHistory(data);
                    }

                },
                error: function (xhr, textStatus, err) {
                    removeHourglass();
                    if(handleLogout(xhr.responseText)) {
                        if (xhr.readyState == 0 || xhr.status == 0) {
                            return;  // Not an error
                        } else {
                            alert(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["error"] + ": " + err);
                        }
                    }
                }
            });
        }
    }

    function showHistory(data) {
        var h = [],
            idx = -1,
            $elem = $('#changes'),
            i,
            finish,
            statusClass;

        $('#dashboardInfo').hide();
        var includeTasks = $('#er_show_tasks').is(':checked');
        var includeNotifications = $('#er_show_notifications').is(':checked');
        var includeChanges = $('#er_show_changes').is(':checked');
        var includeAssignments = $('#er_show_assignments').is(':checked');

        // Add header
        h[++idx] = '<thead>';
        h[++idx] = '<tr>';
        h[++idx] = '<th></th>';     // icon
        h[++idx] = '<th class="mincol">';
        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_user"];
        h[++idx] = '</th>';
        h[++idx] = '<th class="mincol">';
        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_survey"];
        h[++idx] = '</th>';
        h[++idx] = '<th class="mincol">';
        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_date"];
        h[++idx] = '</th>';
        h[++idx] = '<th class="mincol">';
        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_event"];
        h[++idx] = '</th>';
        h[++idx] = '<th class="mincol">';
        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_status"];
        h[++idx] = '</th>';
        h[++idx] = '<th>';
        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_details"];
        h[++idx] = '</th>';
        h[++idx] = '<th class="mincol">';
        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_action"];
        h[++idx] = '</th>';
        h[++idx] = '</tr>';
        h[++idx] = '</thead>';

        h[++idx] = '<tbody>';
        if(data && data.length > 0) {
            for(i = 0; i < data.length; i++) {

                if((includeChanges && (data[i].event === 'changes' || data[i].event === 'created' || data[i].event === 'deleted'
                        || data[i].event === 'restored'
                        || data[i].event === 'inbound_msg'
                        || data[i].event === 'new_case')) ||
                    (includeTasks && data[i].event === 'task') ||
                    (includeAssignments && data[i].event === 'assigned') ||
                    (includeNotifications && data[i].event === 'notification')) {
                    h[++idx] = '<tr>';

                    h[++idx] = '<td>';
                    if (data[i].event === 'task') {
                        h[++idx] = '<i class="fa fa-lg fa-tasks text-info"></i>';
                    } else if (data[i].event === 'created' || data[i].event === 'changes' || data[i].event === 'deleted' || data[i].event === 'restored') {
                        h[++idx] = '<i style="line-height: 1.5em;" class="fa fa-lg fa-inbox text-info"></i>';
                    } else if (data[i].event === 'inbound_msg') {
                        h[++idx] = '<i style="line-height: 1.5em;" class="fa fa-lg fa-phone text-info"></i>';
                    } else if (data[i].event === 'notification') {
                        if (data[i].notification && data[i].notification.target === 'sms') {
                            // From http://jsfiddle.net/4Bacg/
                            h[++idx] = '<span class="text-info" style="line-height: 1.5em; text-align: center; margin-top: -7px; margin-right: 0.3em;" class="fa-stack text-info fa-lg pull-left">';
                            h[++idx] = '<i class="fa fa-flip-horizontal fa-comment-o"></i>';
                            h[++idx] = '<i style="font-size: 10px; line-height: 1em;">sms</i>';
                            h[++idx] = '</span>';
                        } else {
                            h[++idx] = '<i class="fa fa-lg fa-envelope-o text-info"></i>';
                        }
                    }

                    h[++idx] = '</td>';
                    h[++idx] = '<td class="mincol">';    // user
                    if(data[i].userName) {
                        h[++idx] = htmlEncode(data[i].userName);
                    }
                    h[++idx] = '</td>';

                    h[++idx] = '<td class="mincol">';    // Survey
                    if(data[i].surveyName) {
                        h[++idx] = htmlEncode(data[i].surveyName) + ' (' + data[i].surveyVersion + ')';
                    }
                    h[++idx] = '</td>';

                    h[++idx] = '<td class="mincol">';    // when
                    h[++idx] = htmlEncode(data[i].eventTime);
                    h[++idx] = '</td>';

                    h[++idx] = '<td class="mincol">';    // event
                    if(data[i].event === 'assigned') {
                        h[++idx] = htmlEncode(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set['t_assign']);
                    } else {
                        h[++idx] = htmlEncode(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set[data[i].event]);
                    }
                    h[++idx] = '</td>';

                    h[++idx] = '<td class="mincol ';    // status
                    finish = getFinish(data[i]);
                    statusClass = getStatusClass(data[i].status, data[i].assign_auto);
                    h[++idx] = statusClass;
                    h[++idx] = '">';
                    if(statusClass == 'bg-danger') {
                        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_late"];
                    } if(statusClass == 'bg-orange') {
                        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["t_auto2"];
                    } else {
                        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set[data[i].status];
                    }

                    h[++idx] = '</td>';

                    h[++idx] = '<td>';    // Details
                    if (data[i].event === 'changes' && data[i].changes) {
                        h[++idx] = getChangeCard(data[i].changes, i);
                    } else if (data[i].event === 'task' && data[i].task) {
                        h[++idx] = getTaskCard(data[i].task, i);
                    } else if (data[i].event === 'notification' && data[i].notification) {
                        h[++idx] = getNotificationInfo(data[i].notification, data[i].description);
                    } else {
                        h[++idx] = htmlEncode(data[i].description);
                    }
                    h[++idx] = '</td>';

                    h[++idx] = '<td class="mincol">';    // Action
                    if (data[i].event === 'notification' && data[i].notification) {
                        h[++idx] = '<button class="btn btn-secondary edit_notification" data-idx="';
                        h[++idx] = i;
                        h[++idx] = '">';
                        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_resend"];
                        h[++idx] = '</button>';
                    } else  if (data[i].event === 'task' && data[i].task && data[i].status !== 'cancelled') {
                        h[++idx] = '<button class="btn btn-secondary edit_task" data-idx="';
                        h[++idx] = i;
                        h[++idx] = '">';
                        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["t_edit_task"];
                        h[++idx] = '</button>';
                    }
                    h[++idx] = '</td>';

                    h[++idx] = '</tr>';    // row
                }

            }
        }
        h[++idx] = '</tbody>';
        $elem.empty().html(h.join(''));

        $('.change_card').on('shown.bs.collapse', function() {
            var $this = $(this);
            $('.card-body > .row > .small_map', $this).each(function(){
                console.log($(this).attr("id"));
                _app_actioncommon__WEBPACK_IMPORTED_MODULE_13___default().initialiseDynamicMaps(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gRecordChangeMaps, $(this).attr("id"));
            });
        });
        $('.change_card').on('show.bs.collapse', function() {
            $('.mincol').hide();
        });
        $('.change_card').on('hidden.bs.collapse', function() {
            $('.mincol').show();
        });

        $('.edit_notification').click(function(){
            var n = {
                notifyDetails: {

                }
            };
            $('#dashboardInfo').hide();
            var idx = $(this).data("idx");
            var nMessage = window.gChanges[idx].notification
            n.target = nMessage.target;
            n.s_id = nMessage.survey_ident;     // Confusing yes - for notifications this is still id, wheras for console this is the ident
            n.notifyDetails.subject = nMessage.subject;
            n.notifyDetails.content = nMessage.content;
            n.notifyDetails.attach = nMessage.attach;
            n.notifyDetails.emails = nMessage.emails;
            window.gNotifications = [];
            window.gNotifications.push(n);

            $('#saveNotification').html(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_resend"]);
            edit_notification(true,0, true);
            $('#addNotificationPopup').modal("show");
        });

        $('.edit_task').click(function(){

            $('#dashboardInfo').hide();
            var idx = $(this).data("idx");
            var task = window.gChanges[idx].task;
            var url = "/surveyKPI/api/tasks/assignment/" + task.assignmentId + "?taskid=" + task.taskId;
            // Get the task details and then open the editor dialog

            $.ajax({
                url: url,
                dataType: 'json',
                cache: false,
                success: function (data) {
                    if(handleLogout(data)) {
                        var task = data,
                            taskFeature = {
                                geometry: {
                                    coordinates: [],
                                    type: 'Point'
                                },
                                properties: {}
                            };
                        taskFeature.geometry.coordinates.push(task.lon);
                        taskFeature.geometry.coordinates.push(task.lat);
                        taskFeature.properties.form_id = task.survey_ident;
                        taskFeature.properties.assignee = task.assignee;
                        taskFeature.properties.emails = task.emails;
                        taskFeature.properties.repeat = task.repeat;
                        taskFeature.properties.id = task.id;
                        taskFeature.properties.a_id = task.a_id;

                        editTask(false, task, taskFeature);
                    }
                },
                error: function (xhr, textStatus, err) {
                    removeHourglass();
                    if(handleLogout(xhr.responseText)) {
                        if (xhr.readyState == 0 || xhr.status == 0) {
                            return;  // Not an error
                        } else {
                            console.log(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_error"] + ": " + err);
                        }
                    }
                }
            });
        });
    }

    /*
     * Get the current schedule to date from a task
     */
    function getFinish(data) {
        var events,
            i,
            finish;

        if(data.task) {
            events = data.task.taskEvents;
            // Get the last set finish time
            for(i = events.length - 1; i >= 0; i--) {
                if(events[i].schedule_finish) {
                    finish = events[i].schedule_finish;
                    break;
                }
            }
        }
        return finish;
    }

    /*
     * Get task info
     */
    function getTaskCard(task, index) {
        var h = [],
            idx = -1,
            i,
            events = task.taskEvents,
            addBreak,
            state = getTaskState(task),
            current,
            taskHistory,
            event;

        current = state.current;
        taskHistory = state.history;


        h[++idx] = '<div class="card bg-white">';

        h[++idx] = '<div class="card-header" id="task_heading_';
        h[++idx] = index;
        h[++idx] = '">';
        h[++idx] = '<h5 class="mb-0">';
        h[++idx] = '<button class="btn btn-link card-button" data-toggle="collapse" data-target="#task_collapse_';
        h[++idx] = index;
        h[++idx] = '" aria-expanded="false" aria-controls="task_collapse_';
        h[++idx] = index;
        h[++idx] = '">';

        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_id"];
        h[++idx] = ': ';
        h[++idx] = task.assignmentId;
        if(current.assigned) {
            h[++idx] = '<br/>';
            h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["t_assigned"];
            h[++idx] = ': ';
            h[++idx] = current.assigned;
        }
        if(current.name) {
            h[++idx] = '<br/>';
            h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_name"];
            h[++idx] = ': ';
            h[++idx] = current.name;
        }

        h[++idx] = '</button>';
        h[++idx] = '</h5>';
        h[++idx] = '</div>';    // Header

        h[++idx] = '<div id="task_collapse_';
        h[++idx] = index;
        h[++idx] = '" class="collapse change_card" aria-labelledby="task_heading_';
        h[++idx] = index;
        h[++idx] = '">';
        h[++idx] = '<div class="card-body">';

        //----------------- Start card body
        if(taskHistory && taskHistory.length > 0) {
            for(i = events.length - 1; i >= 0; i--) {
                event = taskHistory[i];
                addBreak = false;
                h[++idx] = event.when;
                h[++idx] = '<div class="ml-4">';
                if(event.status) {
                    addBreak = true;
                    h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_status"];
                    h[++idx] = ': ';
                    h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set[event.status];
                }
                if(event.assigned) {
                    if(addBreak) {
                        h[++idx] = '<br/>';
                    }
                    addBreak = true;
                    h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["t_assigned"];
                    h[++idx] = ': ';
                    h[++idx] = event.assigned;
                }
                if(event.schedule_at) {
                    if(addBreak) {
                        h[++idx] = '<br/>';
                    }
                    addBreak = true;
                    h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_from"];
                    h[++idx] = ': ';
                    h[++idx] = event.schedule_at;
                }
                if(event.schedule_finish) {
                    if(addBreak) {
                        h[++idx] = '<br/>';
                    }
                    addBreak = true;
                    h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_to"];
                    h[++idx] = ': ';
                    h[++idx] = event.schedule_finish;
                }
                if(event.name) {
                    if(addBreak) {
                        h[++idx] = '<br/>';
                    }
                    addBreak = true;
                    h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_name"];
                    h[++idx] = ': ';
                    h[++idx] = event.name;
                }
                h[++idx] = '</div>';
            }
        }
        // ------------ End card body


        h[++idx] = '</div>';        // body
        h[++idx] = '</div>';        // collapse

        h[++idx] = '</div>';        // card


        return h.join('');
    }

    /*
     * Convert task events into a task state
     */
    function getTaskState(task) {

        var i,
            events = task.taskEvents,
            event,
            historyItem,
            state = {
                current: {},
                history: []
            };


        if(events && events.length > 0) {

            // Set current starting from the latest
            for(i = events.length - 1; i >= 0; i--) {
                event = events[i];

                if (i == events.length - 1) {
                    state.current = JSON.parse(JSON.stringify(event))
                } else {
                    if (!state.current.status) {
                        state.current.status = event.status;
                    }
                    if (!state.current.assigned) {
                        state.current.assigned = event.assigned;
                    }
                    if (!state.current.name) {
                        state.current.name = event.name;
                    }
                }
            }

            if (state.current.name && state.current.name.indexOf(':') > 0) {
                state.current.name = state.current.name.substring(0, state.current.name.indexOf(':'));
            }

            // Set history starting from the first and only recording changes
            for(i = 0; i < events.length; i++) {

                event = events[i];
                historyItem = {};

                historyItem.when = localTime(event.when);

                if(i == 0 || event.status !== events[i - 1].status) {
                    historyItem.status = event.status;
                }
                if(i == 0 || event.assigned !== events[i - 1].assigned) {
                    historyItem.assigned = event.assigned;
                }
                if(i == 0 || event.schedule_at !== events[i - 1].schedule_at) {
                    historyItem.schedule_at = localTime(event.schedule_at);
                }
                if(i == 0 || event.schedule_finish !== events[i - 1].schedule_finish) {
                    historyItem.schedule_finish = localTime(event.schedule_finish);
                }

                // We only need the name up to the first ":".  If the name has colons in it then it has probably been created
                // automatically from existing data using project name and survey name.  However for the per record view just the
                // Task group name is enough
                if(i == 0 || event.name !== events[i - 1].name) {
                    historyItem.name = event.name;
                    if (historyItem.name && historyItem.name.indexOf(':') > 0) {
                        historyItem.name = historyItem.name.substring(0, historyItem.name.indexOf(':'));
                    }
                }

                state.history.push(historyItem);
            }
        }
        return state;
    }
    /*
     * Get notification info
     */
    function getNotificationInfo(n, description) {
        var h = [],
            idx = -1;

        h[++idx] = '<p>';
        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_target"];
        h[++idx] = ': ';
        h[++idx] = n.target;
        h[++idx] = '<br/>';

        h[++idx] = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_to"];
        h[++idx] = ': ';
        h[++idx] = n.emails ? n.emails.join(',') : '';
        h[++idx] = '<br/>';

        if(description) {
            h[++idx] = description;
            h[++idx] = '<br/>';
        } else if(n.content) {
            h[++idx] = n.content;
        }
        h[++idx] = '</p>';

        return h.join('');

    }

    /*
     * Convert a list of changes into a bs4 card
     */
    function getChangeCard(changes, index) {
        var h = [],
            idx = -1,
            i, j;

        h[++idx] = '<div class="card bg-white">';

        h[++idx] = '<div class="card-header" id="heading_';
        h[++idx] = index;
        h[++idx] = '">';
        h[++idx] = '<h5 class="mb-0">';
        h[++idx] = '<button class="btn btn-link card-button" data-toggle="collapse" data-target="#collapse_';
        h[++idx] = index;
        h[++idx] = '" aria-expanded="false" aria-controls="collapse_';
        h[++idx] = index;
        h[++idx] = '">';
        h[++idx] = changes.length + ' '  + (changes.length > 1 ? _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_changes"] : _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_change"]);
        h[++idx] = '</button>';
        h[++idx] = '</h5>';
        h[++idx] = '</div>';    // Header

        h[++idx] = '<div id="collapse_';
        h[++idx] = index;
        h[++idx] = '" class="collapse change_card" aria-labelledby="heading_';
        h[++idx] = index;
        h[++idx] = '">';
        h[++idx] = '<div class="card-body">';

        var baseUrl = window.location.protocol + "//" + window.location.host + "/";
        for(i = 0; i < changes.length; i++)  {

            h[++idx] = '<div class="row mt-1">';

            var type = changes[i].type;
            if(type === 'begin repeat') {
                var changeArray = changes[i].changes;
                var id;

                h[++idx] = '<div class="col-md-12">';

                // Add the tab nav links
                h[++idx] = '<ul class="nav nav-tabs" role="tablist">';
                for(j = 0; j < changeArray.length; j++) {
                    id = i + '_' + j;

                    h[++idx] = '<li class="nav-item">';
                        h[++idx] = '<a class="nav-link ';
                        if(j == 0) {
                            h[++idx] = 'active';
                        }
                        h[++idx] = '" id="chgtab_';
                        h[++idx] = id;
                        h[++idx] = '" data-toggle="tab" href="#chgpanel_';
                        h[++idx] = id;
                        h[++idx] = '" role="tab" aria-controls="chgpanel_';
                        h[++idx] = id;
                        h[++idx] = '" aria-selected="';
                        if(j == 0) {
                            h[++idx] = 'true';
                        } else {
                            h[++idx] = 'false';
                        }
                        h[++idx] = '">';
                        h[++idx] = j;
                        h[++idx] = '</a>';
                    h[++idx] = '</li>';
                }
                h[++idx] = '</ul>';

                // Add the tab panels
                h[++idx] = '<div class="tab-content">';

                for(j = 0; j < changeArray.length; j++) {
                    id = i + '_' + j;

                    h[++idx] = '<div class="tab-pane fade';
                    if(j == 0) {
                        h[++idx] = ' show active';
                    }
                    h[++idx] = '" id="chgpanel_';
                    h[++idx] = id;
                    h[++idx] = '" role="tabpanel" aria-labelledby="chgtab_';
                    h[++idx] = id;
                    h[++idx] = '">';
                    h[++idx] = getChangeCard(changeArray[j], id);
                    h[++idx] = '</div>';
                }
                h[++idx] = '</div>';        // Tab content
                h[++idx] = '</div>';        // The column


            } else {

                var newVal = changes[i].newVal;
                var oldVal = changes[i].oldVal;
                if(type === 'image') {
                    newVal = baseUrl + newVal;
                    oldVal = baseUrl + oldVal;
                }

                if(type === 'geopoint' || type === 'geoshape' || type === 'geotrace' || type === 'geocompund') {
                    h[++idx] = _app_actioncommon__WEBPACK_IMPORTED_MODULE_13___default().addCellMap(true, 'change_maps_',
                        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gRecordChangeMaps, changes[i], newVal, oldVal);
                } else {

                    h[++idx] = '<div class="col-md-3">';
                    if(changes[i].displayName) {
                        h[++idx] = htmlEncode(changes[i].displayName);
                    } else {
                        h[++idx] = htmlEncode(changes[i].col);
                    }
                    h[++idx] = '</div>';

                    h[++idx] = '<div class="col-md-4">';
                    h[++idx] = _app_actioncommon__WEBPACK_IMPORTED_MODULE_13___default().addCellMarkup(oldVal);
                    h[++idx] = '</div>';

                    h[++idx] = '<div class="col-md-1">';        // Separator
                    h[++idx] = '<i class="fa fa-arrow-right" aria-hidden="true"></i>';
                    h[++idx] = '</div>';

                    h[++idx] = '<div class="col-md-4">';
                    h[++idx] = _app_actioncommon__WEBPACK_IMPORTED_MODULE_13___default().addCellMarkup(newVal);
                    h[++idx] = '</div>';
                }
            }

            h[++idx] = '</div>';        // row
        }


        h[++idx] = '</div>';        // body
        h[++idx] = '</div>';        // collapse

        h[++idx] = '</div>';        // card

        return h.join('');
    }


    function getData(sIdent, oversightSurvey, subForm, callback, clearCache) {

    	var filter;

	    var url = '/surveyKPI/api/data/';
	    url += sIdent;
	    url += "?mgmt=true";

	    if (oversightSurvey) {
		    url += "&oversightSurvey=" + oversightSurvey;
	    }

	    if(subForm) {
		    url += "&form=" + subForm;

		    // Check for drill down
		    if(gDrillDownStack.length > 0) {
			    url += "&parkey=" + gDrillDownStack[gDrillDownStack.length - 1].record;
		    }
	    }

	    if (isDuplicates) {
		    url += "&group=true";
	    }

	    if(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentInstance) {
		    url += "&instanceid=" + _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentInstance;
	    }

	    /*
		 * date filtering
		 */
	    if(!gGetSettings) {
		    var fromDate = document.getElementById('filter_from').value,
			    toDate = document.getElementById('filter_to').value,
			    dateName = $('#date_question').val();

		    if (dateName && dateName.trim().length) {
                url += "&dateName=" + dateName;
            }
            if (fromDate && fromDate.trim().length) {
                url += "&startDate=" + fromDate;
            }
            if (toDate && toDate.trim().length) {
                url += "&endDate=" + toDate;
            }

		    if($('#include_bad').prop('checked')) {
			    url += "&bad=yes";
		    }
            if($('#include_completed').prop('checked')) {
                url += "&completed=yes";
            } else {
                url += "&completed=no";
            }

		    // Limit number of records returned
		    var limit = $('#limit').val();
		    var iLimit = 0;
		    if (limit && limit.trim().length > 0) {
			    try {
				    iLimit = parseInt(limit);
				    url += "&limit=" + iLimit;
			    } catch (err) {
				    alert(err);
			    }
		    }

		    // Advanced filter
		    filter = $('#advanced_filter').val();
		    // Apply combined filter
		    if (filter && filter.trim().length > 0) {
			    url += "&filter=" + encodeURIComponent(filter);
		    }

		    // Drill Down Filters for launched forms
		    if(gDrillDownStack.length > 0) {
			    var stackObj = gDrillDownStack[gDrillDownStack.length - 1];

			    if(stackObj.type === "child_form" && stackObj.key) {
			        /*
			         * The filter will select those records where the key question is equal to either the
			         * primary key of this survey or its key
			         */
			        filter = "(${" + stackObj.key + "} = '" + stackObj.record + "'";
			        if(stackObj.key_value) {
			            filter += "or ${" + stackObj.key + "} = '" + stackObj.key_value + "')"
                    } else {
			            filter += ")";
                    }
				    url += "&dd_filter=" + encodeURIComponent(filter);
			    } else if(stackObj.type === "parent_form" && stackObj.key) {
			        var keyValue = gTasks.gSelectedRecord[stackObj.key];

			        if(keyValue) {
                        if (stackObj.key_value) {
                            url += "&dd_hrk=" + keyValue;
                        }
                    }
                }
		    }

	    } else {
		    url += "&getSettings=true";
	    }

	    url += "&format=dt";
	    url += "&schema=true";
	    url += "&view=0";                       // TODO
	    url += "&merge_select_multiple=yes";
	    url += "&sort=prikey&dirn=desc";

	    url += "&tz=" + encodeURIComponent(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gTimezone);

        if(gTasks.gInitialInstance) {
            url += "&selectedrow=" + encodeURIComponent(gTasks.gInitialInstance);
        }

	    // First Check the Cache
	    if(!clearCache && gTasks.cache.data[url]) {
            if(url !== gPreviousUrl) {
                // URL has changed update views
                gPreviousUrl = url;
                gTasks.cache.currentData = gTasks.cache.data[url];
                callback(gTasks.cache.data[url]);
                updateSettings(gTasks.cache.currentData.settings);
                _app_mapOL3__WEBPACK_IMPORTED_MODULE_12___default().setLayers(gTasks.cache.currentData.schema.layers);
                updateFormList(gTasks.cache.currentData.forms);
                updateCharts(gTasks.cache.currentData.settings.charts);
                updateConversationalSMS(gTasks.cache.currentData.sms);
            }
	    } else {

            gPreviousUrl = url;

		    addHourglass();
		    $.ajax({
			    url: url,
			    dataType: 'json',
			    cache: false,
			    success: function (data) {
				    removeHourglass();
                    gRefreshingData = false;
                    gGetSettings = false;
                    if(handleLogout(data)) {

                        var theCallback = callback;
                        if (data && data.status === "error") {
                            alert(data.msg);
                            clearTable();
                            return;
                        } else if (data.data && data.data[0] && data.data[0].status === "error") {
                            alert(data.data[0].msg);
                            clearTable();
                            return;
                        } else if (data && data.status === "ok") {
                            // Continue presumably there is no data
                            clearTable();
                            return;
                        } else {
                            var theKey = url;

                            gTasks.cache.data[theKey] = data;
                            gTasks.cache.currentData = data;

                            updateSettings(gTasks.cache.currentData.settings);
                            _app_mapOL3__WEBPACK_IMPORTED_MODULE_12___default().setLayers(gTasks.cache.currentData.schema.layers);
                            updateFormList(gTasks.cache.currentData.forms);
                            updateCharts(gTasks.cache.currentData.settings.charts);
                            updateConversationalSMS(gTasks.cache.currentData.sms);

                            // Add a config item for the group value if this is a duplicates search
                            if (isDuplicates) {
                                gTasks.cache.currentData.schema.columns.unshift({
                                    hide: true,
                                    include: true,
                                    column_name: "_group",
                                    displayName: "_group"
                                });
                            }

                            // Initialise the column settings
                            initialiseColumns();
                            checkFilters();
                            theCallback(data);
                        }
                    }
			    },
			    error: function (xhr, textStatus, err) {
				    removeHourglass();
                    gRefreshingData = false;
                    gGetSettings = false;

                    if(handleLogout(xhr.responseText)) {
                        if (_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable) {
                            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.destroy();
                            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable = undefined;
                        }
                        $("#trackingTable").empty();

                        if (xhr.readyState == 0 || xhr.status == 0) {
                            return;  // Not an error
                        } else {
                            err += " : ";
                            if (xhr.responseText.indexOf("<head>") >= 0) {
                                err += _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_error"];
                            } else {
                                err += xhr.responseText;
                            }

                            alert(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["error"] + ": " + err);
                        }
                    }
			    }
		    });
        }
    }

    /*
     * Set the reset filters link
     */
    function checkFilters() {
        var filtersOn = false,
            i;

        for(i = 0; i < window.filters.length; i++) {

            if(window.filters[i].type === 'text') {
                var v = $('#' + window.filters[i].id).val();
                if(window.filters[i].value) {
                    if(window.filters[i].value !== v) {
                        filtersOn = true;
                    }
                } else {
                    if(v && v.trim().length > 0) {
                        filtersOn = true;
                    }
                }
            } else  if(window.filters[i].type === 'checkbox') {
                filtersOn = ($('#' + window.filters[i].id).prop('checked') !== window.filters[i].value);
            }

            if(filtersOn) {
                break;
            }
        }

        if(filtersOn) {
            $('.filtersChanged').show();
        } else {
            $('.filtersChanged').hide();
        }
    }

    /*
     * Reset the filters
     */
    function resetFilters() {
        var i;

        for(i = 0; i < window.filters.length; i++) {

            if(window.filters[i].type === 'text') {
                $('#' + window.filters[i].id).val(window.filters[i].value);
            } else  if(window.filters[i].type === 'checkbox') {
                $('#' + window.filters[i].id).prop('checked', window.filters[i].value);
            }
        }

        _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.draw();
        $('.filtersChanged').hide();

    }

    function tableOnDraw() {
        var i;

        console.log("tableOnDraw");
        if(!_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable) {
            return;     // Table not ready
        }

        gDeleteColumn = -1;
        gDeleteReasonColumn = -1;

        if (isDuplicates) {

            var rows = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.rows({page: 'current'}).nodes();
            var last = null;

            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.column(0, {page: 'current'}).data().each(function (group, i) {
                if (group && last !== group) {
                    $(rows).eq(i).before(
                        '<tr class="group" style="background-color: #CCC;"><td colspan="5">' + group + '</td></tr>'
                    );

                    last = group;
                }
            });
        }

        var columns = gTasks.cache.currentData.schema.columns;

        for (i = 0; i < columns.length; i++) {
            var headItem = columns[i];

            // Highlighting
            if (headItem.markup) {
                $(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.column(i).nodes()).each(function (index) {
                    var $this = $(this),
                        v = $this.text();

                    for (var j = 0; j < headItem.markup.length; j++) {
                        if (headItem.markup[j].value === v) {
                            $this.addClass(getColorClass(headItem.markup[j].classes));
                        }
                    }
                });
            } else if (headItem.barcode) {
                $(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.column(i).nodes()).each(function (index) {
                    var $this = $(this),
                        opt = {
                            render: 'div',
                            size: 100,
                            text: $this.text()
                        }

                    $this.empty().qrcode(opt);

                });
            } else if(headItem.del_col) {  // Deleted
                gDeleteColumn = i;
                $(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.column(i).nodes()).each(function (index) {
                    var $this = $(this);
                    if($this.text() === "t") {
                        $this.text(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_yes"]);
                        $this.addClass('bg-danger');
                    } else  if($this.text() === "f") {
                        $this.text(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["c_no"]);
                    }
                });
            } else if(headItem.del_reason_col) {  // Deleted reason
                gDeleteReasonColumn = i;
            } else if(headItem.type === 'conversation') {
                $(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.column(i).nodes()).each(function (index) {
                    var $this = $(this);
                    if($this[0] && $this[0].innerHTML && $this[0].innerHTML.startsWith("[")) {  // Only format if this is a json array
                        $this.html(_app_actioncommon__WEBPACK_IMPORTED_MODULE_13___default().formatConversation(htmlEncode($this.text()),false));
                    }
                });
            }
        }

        // Refresh the views that depend on the displayed rows
        _app_mapOL3__WEBPACK_IMPORTED_MODULE_12___default().refreshAllLayers(gMapView, gOverallMapConfig.map);
        _app_chart__WEBPACK_IMPORTED_MODULE_11___default().refresh();

        if(gTasks.gBulkInstances && gTasks.gBulkInstances.length) {
            for(i = 0; i < gTasks.gBulkInstances.length; i++ ) {
                if(gTasks.gBulkInstances[i]) {
                    _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.row('#' + escSelector(gTasks.gBulkInstances[i])).select();      // Reselect the row, escape the :
                }
            }
        }

        // Set an initial selection if one has been set
        if(gTasks.gInitialInstance) {
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.row('#' + escSelector(gTasks.cache.currentData.selectedRow)).select();
            gTasks.gInitialInstance = undefined;
        }
    }

    function getColorClass(color) {
        if(color === 'yellow') {
            return 'bg-warning';
        } else if(color === 'blue') {
            return 'bg-info';
        } else if(color === 'red') {
            return 'bg-danger';
        } else if(color === 'red') {
            return 'bg-danger';
        } else if(color === 'green') {
            return 'bg-success';
        }
    }

    /*
     * If settings were requested from the server then update the setting fields
     */
    function updateSettings(settings) {
        if(settings) {

            $('#filter_from').val(settings.fromDate);
            $('#filter_to').val(settings.toDate);
            $('#date_question').val(settings.dateName);
            $('#limit').val(settings.limit);
            $('#advanced_filter').val(settings.filter);
            $('#include_bad').prop('checked', settings.include_bad === "yes");
            $('#include_completed').prop('checked', settings.include_completed === "yes");
        }
    }

    /*
     * Show links
     */
    function showLinks() {
        var sIdent = gTasks.cache.surveyList[_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentProject][gTasks.gSelectedSurveyIndex].ident;
        var instanceId = gTasks.gSelectedRecord.instanceid;
        window.location.href = '/app/tasks/linkages.html?survey=' + sIdent + '&record=' + instanceId;
    }

    /*
     * Show a records details
     */
    function showRecord() {

        window.location.hash="#edit";
        $('.shareRecordOnly, .role_select').hide();
        $('#srLink').val("");
        checkLoggedIn(function(){
            getSurveyRoles(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, undefined, false, false);
            getRecordChanges(gTasks.gSelectedRecord);
            getOurNumbers();
        });

        $('.overviewSection').hide();
        $('.editRecordSection').show();

        _app_actioncommon__WEBPACK_IMPORTED_MODULE_13___default().showEditRecordForm(gTasks.gSelectedRecord, gTasks.cache.currentData.schema, $('#surveyForm'), true);
    }

    /*
     * Open a page for bulk editing
     */
    function showBulkEdit() {

        var oversight = $('#oversight_survey').val();
        if(oversight !== '') {
            window.location.hash = "#bulk";
            $('.shareRecordOnly, .role_select').hide();
            $('#srLink').val("");
            getSurveyRoles(_smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gCurrentSurvey, undefined, false, false);

            $('.overviewSection').hide();
            $('.bulkEditSection').show();

            _app_actioncommon__WEBPACK_IMPORTED_MODULE_13___default().showBulkEditForm(gTasks.gSelectedRecord, gTasks.cache.currentData.schema, $('#bulkEditForm'));
        } else {
            alert(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["n_no_oversight"]);
        }
    }


    /*
     * -------------------------------------------------------------------------------------
     * Task management functions copied from taskManagement.js
     * (Some of) this duplication should be fixed but will require selection of a single map API
     */

    /*
     * Add a task
	 */
    $('#addTask').click(function () {

        // TODO default location to location of record
        var task = {},
            taskFeature = {
                geometry: {
                    coordinates: [],
                    type: 'Point'
                },
                properties: {}
            };

        $('#dashboardInfo').hide();
        editTask(true, task, taskFeature);
    });

    $('#addNotification').click(function(){
        $('#dashboardInfo').hide();
        edit_notification(false, -1, true);
        $('#addNotificationPopup').modal("show");
    });

    /*
	 * Edit an existing task or create a new one
	 */
    function editTask(isNew, task, taskFeature) {
        var scheduleDate,
            splitDate = [];

        console.log("open edit task: " + task.from);
        $('#dashboardInfo').hide();

        window.gCurrentTaskFeature = taskFeature;

        $('form[name="taskProperties"]')[0].reset();

        if (isNew) {
            $('#taskPropLabel').html(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["t_add_task"]);
            $('#tp_pol').prop('checked', true);
            $('#tp_assign_auto').prop('checked', false);

        } else {
            $('#taskPropLabel').html(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["t_edit_task"]);
            $('#tp_pol').prop('checked', task.complete_all);
            $('#tp_assign_auto').prop('checked', task.assign_auto);
        }

        /*
		 * Set up data
		 */
        $('#tp_repeat').prop('checked', task.repeat);
        $('#tp_pol').prop('checked', task.complete_all);
        $('#tp_assign_auto').prop('checked', task.assign_auto);
        $('#tp_name').val(task.name);		// name
        if(isNew) {
            $('#tp_form_name').val($('#tp_form_name option:first').val());
        } else {
            $('#tp_form_name').val(taskFeature.properties.form_id);	// form id
        }
        setupAssignType(taskFeature.properties.assignee, 0, taskFeature.properties.emails, taskFeature.properties.assign_data);
        $('#tp_user').val(taskFeature.properties.assignee);	// assignee
        $('#tp_assign_emails').val(taskFeature.properties.emails);
        $('#tp_repeat').prop('checked', taskFeature.properties.repeat);
        $('#tp_pol').prop('checked', taskFeature.properties.complete_all);
        $('#tp_assign_auto').prop('checked', taskFeature.properties.assign_auto);

        // Set end date first as otherwise since it will be null, it will be defaulted when from date set
        if (task.to) {
            $('#tp_to').data("DateTimePicker").date(localTime(task.to));
        }
        if (task.from) {
            $('#tp_from').data("DateTimePicker").date(localTime(task.from));
        }

        $('#nfc_uid').val(task.location_trigger);
        gCurrentGroup = task.location_group;
        gCurrentLocation = getLocationIndex(task.location_name, gTags);
        if(gCurrentGroup && gCurrentGroup != '') {
            $('.location_group_list_sel').text(gCurrentGroup);
            setLocationList(gTags, gCurrentLocation, gCurrentGroup);
        }

        if(task.guidance) {
            $('#tp_guidance').val(task.guidance);
        } else {
            $('#tp_guidance').val(task.address);    // Initialise with address data
        }
        if (task.update_id && task.update_id.length > 0) {
            $('#initial_data').html(getInitialDataLink(taskFeature));
        }
        $('#tp_show_dist').val(task.show_dist);

        $('#location_save_panel').hide();
        $('#task_properties').modal("show");

        if (!gModalMapInitialised) {
            setTimeout(function () {
                _app_mapOL3__WEBPACK_IMPORTED_MODULE_12___default().initDynamicMap(gTaskMapConfig, true, undefined, false);
            }, 0);
            gModalMapInitialised = true;
        } else {
            //gClickOnMapenabled = false;     // TODO
            //modalMapReady();
        }

    }

    /*
	 * Callback after saving a task
	 */
    function doneTaskSave() {
        getRecordChanges(gTasks.gSelectedRecord);
        getLocations(processLocationList);
    }

    /*
	 * Process a list of locations
	 */
    function processLocationList(tags) {
        gTags = tags;
        gCurrentGroup = refreshLocationGroups(tags, true, gCurrentGroup);
        setLocationList(tags, gCurrentLocation, gCurrentGroup);

        // Respond to a location group being selected
        $('.dropdown-item', '#location_group').click(function () {
            gCurrentGroup = $(this).text();
            gCurrentLocation = '-1';
            $('.location_group_list_sel').text(gCurrentGroup);
            setLocationList(gTags, gCurrentLocation, gCurrentGroup);
        });
    }

    /*
     * Save a notification
     */
    function sendImmediateNotification() {

        var url,
            notification,
            notificationString,
            target = $('#target').val(),
            theirNumber = $('#msg_cur_nbr').val(),
            ourNumber = $('#msg_our_nbr').val(),
            msgChannel = $('#msg_channel').val();

        if(theirNumber === 'other') {
            theirNumber = $('#msg_nbr_other').val();
        }

        $('#saveNotification').prop("disabled", true);  // debounce

        if(target === "email") {
            notification = saveEmail();
        } else if(target === "sms") {
            notification = saveSMS();
        } else if(target === "document") {
            notification = saveDocument();
        } else if(target === "conversation") {
            notification = saveConversation(gTasks.cache.currentData.schema.columns,
                theirNumber,
                ourNumber,
                msgChannel,
                gTasks.gSelectedRecord);
        }

        if(!notification.error) {

            notification.trigger = $('#trigger').val();
            notification.sIdent = $('#not_form_name').val();
            notification.enabled = $('#nt_enabled').is(':checked');
            notification.filter = $('#not_filter').val();
            notification.name = $('#name').val();
            notification.instanceId = gTasks.gSelectedRecord.instanceid;

            if(notification.trigger === 'task_reminder') {
                var idx = $('#task_group').val();
                if(gTaskGroups.length > 0 && idx < gTaskGroups.length) {
                    notification.tgId = gTaskGroups[idx].tg_id;
                }
                var periodCount = $('#r_period').val();
                notification.period = periodCount + ' ' + $('#period_list_sel').val();

                // Validate
                if(!periodCount || periodCount <= 0) {
                    alert(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_pc"]);
                    $('#saveNotification').prop("disabled", false);  // debounce
                    return(-1);
                }
                console.log("Reminder for tg: " + notification.tgId + ' after ' + notification.period);
            }

            url = "/surveyKPI/notifications/immediate";

            notificationString = JSON.stringify(notification);
            addHourglass();
            $.ajax({
                type: "POST",
                dataType: 'text',
                cache: false,
                async: false,
                url: url,
                data: { notification: notificationString },
                success: function(data, status) {
                    removeHourglass();
                    $('#saveNotification').prop("disabled", false);  // debounce
                    if(handleLogout(data)) {
                        $('#dashboardInfo').show().removeClass('alert-danger').addClass('alert-success').html(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["n_sent"]);
                        $('#addNotificationPopup').modal("hide");
                    }
                },
                error: function(xhr, textStatus, err) {
                    removeHourglass();
                    $('#saveNotification').prop("disabled", false);  // debounce
                    if(handleLogout(xhr.responseText)) {
                        if (xhr.readyState == 0 || xhr.status == 0) {
                            return;  // Not an error
                        } else {
                            alert(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_err_save"] + " " + xhr.responseText);  // alerts htmlencode
                        }
                    }
                }
            });

        } else {
            $('#saveNotification').prop("disabled", false);  // debounce
            alert(_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_0__["default"].set["msg_inv_email"]);
        }
    }

    function escSelector(input) {
        var output = input.replace(/:/g, '\\:');
        console.log(output);
        return output;
    }

    function toggleRecord(title, bad) {
        var columns = gTasks.cache.currentData.schema.columns;

        gBad = bad;

        if(gDeleteReasonColumn >= 0) {
            $('#toggle_reason').val(gTasks.gSelectedRecord[columns[gDeleteReasonColumn].displayName]);
        } else {
            $('#toggle_reason').val("");
        }
        $('#toggleRecordTitle, #toggleRecordSave').text(title);
        $('#toggleRecord').modal("show");
    }

    function clearTable() {
        if ( $.fn.dataTable.isDataTable( $("#trackingTable")) && _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable) {
            _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_1__["default"].gMainTable.destroy();
        }
        $("#trackingTable").empty()
    }

    function clearDrillDown() {
	    $('.dd_only,.du_only').hide();
        gDrillDownNext = undefined;
	    gDrillDownStack = [];
    }

    function drillDown() {
        var form = $('#dd_form').html();
        if(form !== "") {

            gDrillDownNext.record = gTasks.gSelectedRecord.prikey;
            if (gDrillDownNext.type === 'child_form') {
                gDrillDownNext.key_value = gTasks.gSelectedRecord._hrk;     // Drill down to child using HRK of this, the parent form
            } else {
                gDrillDownNext.key_value = gTasks.gSelectedRecord[gDrillDownNext.key];     // Drill down to parent using its HRK, this is the child form
            }

            // Set the key_value to undefined if it is zero length
	        if(gDrillDownNext.key_value && gDrillDownNext.key_value.length === 0) {
                gDrillDownNext.key_value = undefined;
            }

            gDrillDownStack.push(gDrillDownNext);

	        updateDrillDownFormList();
	        if(gDrillDownNext) {
	        	$('.dd_only').show();
	        }

            subFormChanged();

            $('.du_only').show();
        }
    }

});


})();

/******/ })()
;