/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../smapServer/WebContent/js/app/globals.js"
/*!**************************************************!*\
  !*** ../smapServer/WebContent/js/app/globals.js ***!
  \**************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 This file is part of SMAP.

 SMAP is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SMAP is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Quick solution to issue of legacy globals after migrating to AMD / require.js
 */
const globals = {

        // Security groups
        GROUP_ADMIN: 1,
        GROUP_ANALYST: 2,
        GROUP_ENUM: 3,
        GROUP_ORG_ADMIN : 4,
        GROUP_MANAGE: 5,
        GROUP_SECURITY: 6,
        GROUP_VIEW_DATA: 7,
        GROUP_ENTERPRISE : 8,
        GROUP_OWNER : 9,
		GROUP_VIEW_OWN_DATA : 10,
	    GROUP_MANAGE_TASKS : 11,
	    GROUP_DASHBOARD : 12,
        GROUP_LINKAGES : 13,
        GROUP_CONSOLE_ADMIN : 14,
        GROUP_MCP_ACCESS : 15,

        REC_LIMIT: 200,     // Page size for table views in analysis
	    MAP_REC_LIMIT: 10000,    // Max size for map views in analysis

        gProjectList: undefined,
        gRoleList: undefined,
        gCmSettings: undefined,
        gCurrentProject: 0,
        gCurrentSurvey: 0,
        gCurrentSurveyIdent: undefined,
	    gGroupSurveys: {},
	    gSubForms: {},
        gCurrentForm: 0,
        gCurrentLayer: undefined,
        gLoggedInUser: undefined,
        gEditingReportProject: undefined,   		// Set if fieldAnalysis called to edit a report
        gIsAdministrator: false,
        gIsEnum: false,
        gIsAnalyst: false,
	    gIsDashboard: false,
        gIsManage: false,
        gIsOrgAdministrator: false,
        gIsSecurityAdministrator: false,
        gIsEnterpriseAdministrator: false,
        gIsLinkFollower: false,
        gIsServerOwner: false,
        gIsConsoleAdmin: false,
        gViewData: false,
	    gManageTasks: false,
        gBillingData: false,
        gOrgBillingData: false,
        gSendTrail: 'off',
        gViewIdx: 0,
        gSelector: new Selector(),
        gOrgId: 0,
        gTimezone: undefined,
	    gEnterpriseName: undefined,
	    gSetAsTheme: undefined,
	    gNavbarColor: undefined,

        gRegions: undefined,
        gRegion: {},

        gServerCanSendEmail: false,

        // Reports
        gEmailEnabled: false,
        gFacebookEnabled: false,
        gTwitterEnabled: false,

        // Tasks
        gCurrentUserId: undefined,
        gCurrentUserName: undefined,
        gAssignmentsLayer: undefined,
        gPendingUpdates: [],
        gCurrentTaskGroup: undefined,
	    gCurrentMailout: undefined,
        gTaskList: undefined,
        gCurrentSurveyIndex: 0,
	    gCurrentInstance: undefined,
        gAlertSeen: false,
        gLastAlertTime: undefined,

        // Editor
        gExistingSurvey: false,		// Set true if modifying an existing survey
        gElementIndex: 0,			// Manage creation of unique identifier for each element (question, option) in editor
        gHasItems: false,			// Set true if there are questions or choice lists in the survey
        gNewQuestionButtonIndex: 0,	// Manage creation of unique identifier for buttons that add new questions
        gNewOptionButtonIndex: 0,
        gSId: 0,
        gLanguage: 0,
        gLanguage1: 0,
        gLanguage2: 0,
        errors: [],
        changes: [],
        gErrorPosition: 0,
        gSelProperty: 'label',
        gSelLabel: 'Question Text',
        gSelQuestionProperty: 'label',
        gSelQuestionLabel: 'Question Text',
        gSelChoiceProperty: 'label',
        gSelChoiceLabel: 'Question Text',
        gIsQuestionView: true,
        gShowingChoices: false,
        gMaxOptionList: 0,
        gLatestOptionList: undefined,	// Hack to record the last option list name added
	    gCsvFiles: undefined,

        gListName: undefined,					// Choice Modal parameters, Set if started from choice list view
        gOptionList: undefined,					// The option list name applying to this set of choices
        gSelOptionId: undefined,				// Selected option index
        gFormIndex: undefined,					// Selected form index
        gItemIndex: undefined,					// Selected question index
        gSelectedFilters: undefined,
        gFilterArray: undefined,

        gSaveInProgress: false,

        // Dashboard
        gMainTable: undefined,			// Data tables
        gReports: undefined,			// reports
        gCharts: {},					// charts
	    gRecordMaps: [],                // Maps shown when editing a record
	    gRecordChangeMaps: [],          // Maps shown when viewing change history
        gMapLayersShown: false,
        gViewId: 0,						// Current survey view

	    gTraining: undefined,
	    gRefreshRate: 0,

        gMapboxDefault: undefined,		// Mapbox key
        
        model: typeof Model !== "undefined" ? new Model() : undefined

    }


    function Selector() {

        this.dataItems = {};
        this.surveys = {};
        this.surveysExtended = {};
        this.surveyLanguages = {};
        this.surveyQuestions = {};
        this.surveyMeta = {};
        this.surveyAlerts = {};
        this.questions = {};
        this.allSurveys = undefined;			// Simple list of surveys
        this.allRegions = undefined;
        this.sharedMaps = undefined;
        this.views = [];			// Simple list of views
        this.maps = {};				// map panels indexed by the panel id
        this.changed = false;
        this.SURVEY_KEY_PREFIX = "surveys";
        this.TASK_KEY = "tasks";
        this.TASK_COLOR = "#dd00aa";
        this.SURVEY_COLOR = "#00aa00";
        this.SELECTED_COLOR = "#0000aa";
        this.currentPanel = "map";

        this.getAll = function () {
            return this.dataItems;
        };

        this.getItem = function (key) {
            return this.dataItems[key];
        };

        this.addDataItem = function (key, data) {
            this.dataItems[key] = data;
        };

        this.clearDataItems = function () {
            this.dataItems = {};
        };

        this.addSurvey = function (sId, data) {
            this.surveys[sId] = data;
        };

        this.addSurveyExtended = function (sId, data) {
            this.surveysExtended[sId] = data;
        };

        this.getSurvey = function (sId) {
            return this.surveysExtended[sId] || this.surveys[sId];
        };

        this.clearSurveys = function () {
            this.surveys = {};
            this.surveysExtended = {};
            this.surveyLanguages = {};
            this.surveyQuestions = {};
            this.surveyMeta = {};
            this.surveyAlerts = {};
            this.allSurveys = undefined;
        };

        this.setSurveyList = function (data) {
            this.allSurveys = data;
        };

        this.getSurveyList = function () {
            return this.allSurveys;
        };

        this.setSurveyLanguages = function (sId, data) {
            this.surveyLanguages[sId] = data;
        };

        this.getSurveyLanguages = function (sId) {
            return this.surveyLanguages[sId];
        };

        this.setSurveyQuestions = function (sId, language, data) {
            if (!this.surveyQuestions[sId]) {
                this.surveyQuestions[sId] = {};
            }
            this.surveyQuestions[sId][language] = data;
        };

        this.getSurveyQuestions = function (sId, language) {
            if (!this.surveyQuestions[sId]) {
                return undefined;
            }
            if (typeof language === "undefined") {
                return this.surveyQuestions[sId];
            }
            return this.surveyQuestions[sId][language];
        };

        this.getQuestion = function (qId, language) {
            return this.getQuestionDetails(globals.gCurrentSurvey, qId, language);
        };

        this.getQuestionDetails = function (sId, qId, language) {
            var questions = this.getSurveyQuestions(sId, language);
            if (!questions) {
                return undefined;
            }
            for (var i = 0; i < questions.length; i++) {
                if (questions[i].id == qId) {
                    return questions[i];
                }
            }
            return undefined;
        };

        this.setSurveyMeta = function (sId, data) {
            this.surveyMeta[sId] = data;
        };

        this.getSurveyMeta = function (sId) {
            return this.surveyMeta[sId];
        };

        this.setSurveyAlerts = function (sId, data) {
            this.surveyAlerts[sId] = data;
        };

        this.getSurveyAlerts = function (sId) {
            return this.surveyAlerts[sId];
        };

        this.setRegionList = function (data) {
            this.allRegions = data;
        };

        this.getRegionList = function () {
            return this.allRegions;
        };

        this.setSharedMaps = function (data) {
            this.sharedMaps = data;
        };

        this.getSharedMaps = function () {
            return this.sharedMaps;
        };

        this.setViews = function (data) {
            this.views = data || [];
        };

        this.getViews = function () {
            return this.views;
        };

        this.setMap = function (idx, map) {
            this.maps[idx] = map;
        };

        this.getMap = function (idx) {
            return this.maps[idx];
        };

    }

    /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (globals);


/***/ },

/***/ "../smapServer/WebContent/js/app/localise.js"
/*!***************************************************!*\
  !*** ../smapServer/WebContent/js/app/localise.js ***!
  \***************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

const $ = window.$;

const dtLangFiles = {
	en: "",
	es: "/js/libs/DataTables.i18n/es.json",
	ar: "/js/libs/DataTables.i18n/ar.json",
	fr: "/js/libs/DataTables.i18n/fr.json",
	pt: "/js/libs/DataTables.i18n/pt.json",
	hi: "/js/libs/DataTables.i18n/hi.json"
};

const localeCache = {};
let currentLocale = "en";

function normalizeLocale(locale) {
	if (!locale) {
		return "en";
	}
	return locale.toLowerCase().replace("_", "-");
}

function localeCandidates(locale) {
	const normalized = normalizeLocale(locale);
	const base = normalized.split("-")[0];
	const candidates = [];

	if (normalized && normalized !== "en") {
		candidates.push(normalized);
	}
	if (base && base !== normalized && base !== "en") {
		candidates.push(base);
	}
	if (!candidates.includes("root")) {
		candidates.push("root");
	}

	return candidates;
}

function parseAmdLocale(text) {
	const trimmed = text.trim();
	const prefix = "define(";
	const start = trimmed.indexOf(prefix);
	const end = trimmed.lastIndexOf(")");
	if (start === -1 || end === -1 || end <= start) {
		throw new Error("Invalid locale format");
	}
	const objectText = trimmed.slice(start + prefix.length, end).trim();
	const jsonText = objectText
		.replace(/\s*\/\/.*$/gm, "")
		.replace(/\s\/\*[\s\S]*?\*\//g, "")
		.trim();
	return JSON.parse(jsonText);
}

async function loadLocaleFile(locale) {
	if (localeCache[locale]) {
		return localeCache[locale];
	}

	const src = `/js/nls/${locale}/lang.js`;
	const data = await new Promise((resolve, reject) => {
		const previousDefine = window.define;
		const script = document.createElement("script");

		window.define = function (payload) {
			window.define = previousDefine;
			script.remove();
			resolve(payload);
		};
		window.define.amd = true;

		script.src = src;
		script.async = true;
		script.onerror = function () {
			window.define = previousDefine;
			script.remove();
			reject(new Error(`Locale ${locale} not found`));
		};

		document.head.appendChild(script);
	});

	localeCache[locale] = data;
	return data;
}

async function initLocale(locale) {
	const candidates = localeCandidates(locale);
	const rootLocale = await loadLocaleFile("root");
	let merged = { ...rootLocale };
	let resolvedLocale = "root";

	for (const candidate of candidates) {
		if (candidate === "root") {
			continue;
		}
		try {
			const data = await loadLocaleFile(candidate);
			merged = { ...merged, ...data };
			resolvedLocale = candidate;
			break;
		} catch (error) {
			// fallback to next candidate
		}
	}

	currentLocale = resolvedLocale;
	window.localise.set = merged;
	return merged;
}

window.localise = {
	setlang: function () {
		$(".lang").each(function() {
			const $this = $(this);
			const code = $this.data("lang");
			if (code) {
				$this.html(window.localise.set[code]);
			}
		});

		$(".lang_tt").each(function() {
			const $this = $(this);
			const code = $this.data("lang_tt");
			if (code) {
				$this.prop("title", window.localise.set[code]);
			}
		});

		$(".lang_ph").each(function() {
			const $this = $(this);
			const code = $this.data("lang_ph");
			if (code) {
				$this.prop("placeholder", window.localise.set[code]);
			}
		});

		if (typeof responsiveMobileMenu === "function") {
			rmmResizeLabels();
		}
	},
	set: {},
	dt: function() {
		return dtLangFiles[currentLocale] || dtLangFiles.en;
	},
	initLocale
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (window.localise);


/***/ },

/***/ "../smapServer/WebContent/js/libs/bootbox.min.js"
/*!*******************************************************!*\
  !*** ../smapServer/WebContent/js/libs/bootbox.min.js ***!
  \*******************************************************/
(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/**
 * bootbox.js v4.3.0
 *
 * http://bootboxjs.com/license.txt
 */
!function(a,b){"use strict"; true?!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "jquery")], __WEBPACK_AMD_DEFINE_FACTORY__ = (b),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)):0}(this,function a(b,c){"use strict";function d(a){var b=q[o.locale];return b?b[a]:q.en[a]}function e(a,c,d){a.stopPropagation(),a.preventDefault();var e=b.isFunction(d)&&d(a)===!1;e||c.modal("hide")}function f(a){var b,c=0;for(b in a)c++;return c}function g(a,c){var d=0;b.each(a,function(a,b){c(a,b,d++)})}function h(a){var c,d;if("object"!=typeof a)throw new Error("Please supply an object of options");if(!a.message)throw new Error("Please specify a message");return a=b.extend({},o,a),a.buttons||(a.buttons={}),a.backdrop=a.backdrop?"static":!1,c=a.buttons,d=f(c),g(c,function(a,e,f){if(b.isFunction(e)&&(e=c[a]={callback:e}),"object"!==b.type(e))throw new Error("button with key "+a+" must be an object");e.label||(e.label=a),e.className||(e.className=2>=d&&f===d-1?"btn-primary":"btn-default")}),a}function i(a,b){var c=a.length,d={};if(1>c||c>2)throw new Error("Invalid argument length");return 2===c||"string"==typeof a[0]?(d[b[0]]=a[0],d[b[1]]=a[1]):d=a[0],d}function j(a,c,d){return b.extend(!0,{},a,i(c,d))}function k(a,b,c,d){var e={className:"bootbox-"+a,buttons:l.apply(null,b)};return m(j(e,d,c),b)}function l(){for(var a={},b=0,c=arguments.length;c>b;b++){var e=arguments[b],f=e.toLowerCase(),g=e.toUpperCase();a[f]={label:d(g)}}return a}function m(a,b){var d={};return g(b,function(a,b){d[b]=!0}),g(a.buttons,function(a){if(d[a]===c)throw new Error("button key "+a+" is not allowed (options are "+b.join("\n")+")")}),a}var n={dialog:"<div class='bootbox modal' tabindex='-1' role='dialog'><div class='modal-dialog'><div class='modal-content'><div class='modal-body'><div class='bootbox-body'></div></div></div></div></div>",header:"<div class='modal-header'><h4 class='modal-title'></h4></div>",footer:"<div class='modal-footer'></div>",closeButton:"<button type='button' class='bootbox-close-button close' data-dismiss='modal' aria-hidden='true'>&times;</button>",form:"<form class='bootbox-form'></form>",inputs:{text:"<input class='bootbox-input bootbox-input-text form-control' autocomplete=off type=text />",textarea:"<textarea class='bootbox-input bootbox-input-textarea form-control'></textarea>",email:"<input class='bootbox-input bootbox-input-email form-control' autocomplete='off' type='email' />",select:"<select class='bootbox-input bootbox-input-select form-control'></select>",checkbox:"<div class='checkbox'><label><input class='bootbox-input bootbox-input-checkbox' type='checkbox' /></label></div>",date:"<input class='bootbox-input bootbox-input-date form-control' autocomplete=off type='date' />",time:"<input class='bootbox-input bootbox-input-time form-control' autocomplete=off type='time' />",number:"<input class='bootbox-input bootbox-input-number form-control' autocomplete=off type='number' />",password:"<input class='bootbox-input bootbox-input-password form-control' autocomplete='off' type='password' />"}},o={locale:"en",backdrop:!0,animate:!0,className:null,closeButton:!0,show:!0,container:"body"},p={};p.alert=function(){var a;if(a=k("alert",["ok"],["message","callback"],arguments),a.callback&&!b.isFunction(a.callback))throw new Error("alert requires callback property to be a function when provided");return a.buttons.ok.callback=a.onEscape=function(){return b.isFunction(a.callback)?a.callback():!0},p.dialog(a)},p.confirm=function(){var a;if(a=k("confirm",["cancel","confirm"],["message","callback"],arguments),a.buttons.cancel.callback=a.onEscape=function(){return a.callback(!1)},a.buttons.confirm.callback=function(){return a.callback(!0)},!b.isFunction(a.callback))throw new Error("confirm requires a callback");return p.dialog(a)},p.prompt=function(){var a,d,e,f,h,i,k;if(f=b(n.form),d={className:"bootbox-prompt",buttons:l("cancel","confirm"),value:"",inputType:"text"},a=m(j(d,arguments,["title","callback"]),["cancel","confirm"]),i=a.show===c?!0:a.show,a.message=f,a.buttons.cancel.callback=a.onEscape=function(){return a.callback(null)},a.buttons.confirm.callback=function(){var c;switch(a.inputType){case"text":case"textarea":case"email":case"select":case"date":case"time":case"number":case"password":c=h.val();break;case"checkbox":var d=h.find("input:checked");c=[],g(d,function(a,d){c.push(b(d).val())})}return a.callback(c)},a.show=!1,!a.title)throw new Error("prompt requires a title");if(!b.isFunction(a.callback))throw new Error("prompt requires a callback");if(!n.inputs[a.inputType])throw new Error("invalid prompt type");switch(h=b(n.inputs[a.inputType]),a.inputType){case"text":case"textarea":case"email":case"date":case"time":case"number":case"password":h.val(a.value);break;case"select":var o={};if(k=a.inputOptions||[],!k.length)throw new Error("prompt with select requires options");g(k,function(a,d){var e=h;if(d.value===c||d.text===c)throw new Error("given options in wrong format");d.group&&(o[d.group]||(o[d.group]=b("<optgroup/>").attr("label",d.group)),e=o[d.group]),e.append("<option value='"+d.value+"'>"+d.text+"</option>")}),g(o,function(a,b){h.append(b)}),h.val(a.value);break;case"checkbox":var q=b.isArray(a.value)?a.value:[a.value];if(k=a.inputOptions||[],!k.length)throw new Error("prompt with checkbox requires options");if(!k[0].value||!k[0].text)throw new Error("given options in wrong format");h=b("<div/>"),g(k,function(c,d){var e=b(n.inputs[a.inputType]);e.find("input").attr("value",d.value),e.find("label").append(d.text),g(q,function(a,b){b===d.value&&e.find("input").prop("checked",!0)}),h.append(e)})}return a.placeholder&&h.attr("placeholder",a.placeholder),a.pattern&&h.attr("pattern",a.pattern),f.append(h),f.on("submit",function(a){a.preventDefault(),a.stopPropagation(),e.find(".btn-primary").click()}),e=p.dialog(a),e.off("shown.bs.modal"),e.on("shown.bs.modal",function(){h.focus()}),i===!0&&e.modal("show"),e},p.dialog=function(a){a=h(a);var c=b(n.dialog),d=c.find(".modal-dialog"),f=c.find(".modal-body"),i=a.buttons,j="",k={onEscape:a.onEscape};if(g(i,function(a,b){j+="<button data-bb-handler='"+a+"' type='button' class='btn "+b.className+"'>"+b.label+"</button>",k[a]=b.callback}),f.find(".bootbox-body").html(a.message),a.animate===!0&&c.addClass("fade"),a.className&&c.addClass(a.className),"large"===a.size&&d.addClass("modal-lg"),"small"===a.size&&d.addClass("modal-sm"),a.title&&f.before(n.header),a.closeButton){var l=b(n.closeButton);a.title?c.find(".modal-header").prepend(l):l.css("margin-top","-10px").prependTo(f)}return a.title&&c.find(".modal-title").html(a.title),j.length&&(f.after(n.footer),c.find(".modal-footer").html(j)),c.on("hidden.bs.modal",function(a){a.target===this&&c.remove()}),c.on("shown.bs.modal",function(){c.find(".btn-primary:first").focus()}),c.on("escape.close.bb",function(a){k.onEscape&&e(a,c,k.onEscape)}),c.on("click",".modal-footer button",function(a){var d=b(this).data("bb-handler");e(a,c,k[d])}),c.on("click",".bootbox-close-button",function(a){e(a,c,k.onEscape)}),c.on("keyup",function(a){27===a.which&&c.trigger("escape.close.bb")}),b(a.container).append(c),c.modal({backdrop:a.backdrop,keyboard:!1,show:!1}),a.show&&c.modal("show"),c},p.setDefaults=function(){var a={};2===arguments.length?a[arguments[0]]=arguments[1]:a=arguments[0],b.extend(o,a)},p.hideAll=function(){return b(".bootbox").modal("hide"),p};var q={br:{OK:"OK",CANCEL:"Cancelar",CONFIRM:"Sim"},cs:{OK:"OK",CANCEL:"Zrušit",CONFIRM:"Potvrdit"},da:{OK:"OK",CANCEL:"Annuller",CONFIRM:"Accepter"},de:{OK:"OK",CANCEL:"Abbrechen",CONFIRM:"Akzeptieren"},el:{OK:"Εντάξει",CANCEL:"Ακύρωση",CONFIRM:"Επιβεβαίωση"},en:{OK:"OK",CANCEL:"Cancel",CONFIRM:"OK"},es:{OK:"OK",CANCEL:"Cancelar",CONFIRM:"Aceptar"},et:{OK:"OK",CANCEL:"Katkesta",CONFIRM:"OK"},fi:{OK:"OK",CANCEL:"Peruuta",CONFIRM:"OK"},fr:{OK:"OK",CANCEL:"Annuler",CONFIRM:"D'accord"},he:{OK:"אישור",CANCEL:"ביטול",CONFIRM:"אישור"},id:{OK:"OK",CANCEL:"Batal",CONFIRM:"OK"},it:{OK:"OK",CANCEL:"Annulla",CONFIRM:"Conferma"},ja:{OK:"OK",CANCEL:"キャンセル",CONFIRM:"確認"},lt:{OK:"Gerai",CANCEL:"Atšaukti",CONFIRM:"Patvirtinti"},lv:{OK:"Labi",CANCEL:"Atcelt",CONFIRM:"Apstiprināt"},nl:{OK:"OK",CANCEL:"Annuleren",CONFIRM:"Accepteren"},no:{OK:"OK",CANCEL:"Avbryt",CONFIRM:"OK"},pl:{OK:"OK",CANCEL:"Anuluj",CONFIRM:"Potwierdź"},pt:{OK:"OK",CANCEL:"Cancelar",CONFIRM:"Confirmar"},ru:{OK:"OK",CANCEL:"Отмена",CONFIRM:"Применить"},sv:{OK:"OK",CANCEL:"Avbryt",CONFIRM:"OK"},tr:{OK:"Tamam",CANCEL:"İptal",CONFIRM:"Onayla"},zh_CN:{OK:"OK",CANCEL:"取消",CONFIRM:"确认"},zh_TW:{OK:"OK",CANCEL:"取消",CONFIRM:"確認"}};return p.init=function(c){return a(c||b)},p});

/***/ },

/***/ "../smapServer/WebContent/js/libs/bootstrap-colorpicker.min.js"
/*!*********************************************************************!*\
  !*** ../smapServer/WebContent/js/libs/bootstrap-colorpicker.min.js ***!
  \*********************************************************************/
(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * Bootstrap Colorpicker v2.5.2
 * https://itsjavi.com/bootstrap-colorpicker/
 */
!function(a,b){ true?!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "jquery")], __WEBPACK_AMD_DEFINE_RESULT__ = (function(a){return b(a)}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)):0}(this,function(a){"use strict";var b=function(c,d,e,f,g){this.fallbackValue=e?"string"==typeof e?this.parse(e):e:null,this.fallbackFormat=f?f:"rgba",this.hexNumberSignPrefix=g===!0,this.value=this.fallbackValue,this.origFormat=null,this.predefinedColors=d?d:{},this.colors=a.extend({},b.webColors,this.predefinedColors),c&&("undefined"!=typeof c.h?this.value=c:this.setColor(String(c))),this.value||(this.value={h:0,s:0,b:0,a:1})};b.webColors={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32",transparent:"transparent"},b.prototype={constructor:b,colors:{},predefinedColors:{},getValue:function(){return this.value},setValue:function(a){this.value=a},_sanitizeNumber:function(a){return"number"==typeof a?a:isNaN(a)||null===a||""===a||void 0===a?1:""===a?0:"undefined"!=typeof a.toLowerCase?(a.match(/^\./)&&(a="0"+a),Math.ceil(100*parseFloat(a))/100):1},isTransparent:function(a){return!(!a||!("string"==typeof a||a instanceof String))&&(a=a.toLowerCase().trim(),"transparent"===a||a.match(/#?00000000/)||a.match(/(rgba|hsla)\(0,0,0,0?\.?0\)/))},rgbaIsTransparent:function(a){return 0===a.r&&0===a.g&&0===a.b&&0===a.a},setColor:function(a){if(a=a.toLowerCase().trim()){if(this.isTransparent(a))return this.value={h:0,s:0,b:0,a:0},!0;var b=this.parse(a);b?(this.value=this.value={h:b.h,s:b.s,b:b.b,a:b.a},this.origFormat||(this.origFormat=b.format)):this.fallbackValue&&(this.value=this.fallbackValue)}return!1},setHue:function(a){this.value.h=1-a},setSaturation:function(a){this.value.s=a},setBrightness:function(a){this.value.b=1-a},setAlpha:function(a){this.value.a=Math.round(parseInt(100*(1-a),10)/100*100)/100},toRGB:function(a,b,c,d){0===arguments.length&&(a=this.value.h,b=this.value.s,c=this.value.b,d=this.value.a),a*=360;var e,f,g,h,i;return a=a%360/60,i=c*b,h=i*(1-Math.abs(a%2-1)),e=f=g=c-i,a=~~a,e+=[i,h,0,0,h,i][a],f+=[h,i,i,h,0,0][a],g+=[0,0,h,i,i,h][a],{r:Math.round(255*e),g:Math.round(255*f),b:Math.round(255*g),a:d}},toHex:function(a,b,c,d,e){arguments.length<=1&&(b=this.value.h,c=this.value.s,d=this.value.b,e=this.value.a);var f="#",g=this.toRGB(b,c,d,e);if(this.rgbaIsTransparent(g))return"transparent";a||(f=this.hexNumberSignPrefix?"#":"");var h=f+((1<<24)+(parseInt(g.r)<<16)+(parseInt(g.g)<<8)+parseInt(g.b)).toString(16).slice(1);return h},toHSL:function(a,b,c,d){0===arguments.length&&(a=this.value.h,b=this.value.s,c=this.value.b,d=this.value.a);var e=a,f=(2-b)*c,g=b*c;return g/=f>0&&f<=1?f:2-f,f/=2,g>1&&(g=1),{h:isNaN(e)?0:e,s:isNaN(g)?0:g,l:isNaN(f)?0:f,a:isNaN(d)?0:d}},toAlias:function(a,b,c,d){var e,f=0===arguments.length?this.toHex(!0):this.toHex(!0,a,b,c,d),g="alias"===this.origFormat?f:this.toString(!1,this.origFormat);for(var h in this.colors)if(e=this.colors[h].toLowerCase().trim(),e===f||e===g)return h;return!1},RGBtoHSB:function(a,b,c,d){a/=255,b/=255,c/=255;var e,f,g,h;return g=Math.max(a,b,c),h=g-Math.min(a,b,c),e=0===h?null:g===a?(b-c)/h:g===b?(c-a)/h+2:(a-b)/h+4,e=(e+360)%6*60/360,f=0===h?0:h/g,{h:this._sanitizeNumber(e),s:f,b:g,a:this._sanitizeNumber(d)}},HueToRGB:function(a,b,c){return c<0?c+=1:c>1&&(c-=1),6*c<1?a+(b-a)*c*6:2*c<1?b:3*c<2?a+(b-a)*(2/3-c)*6:a},HSLtoRGB:function(a,b,c,d){b<0&&(b=0);var e;e=c<=.5?c*(1+b):c+b-c*b;var f=2*c-e,g=a+1/3,h=a,i=a-1/3,j=Math.round(255*this.HueToRGB(f,e,g)),k=Math.round(255*this.HueToRGB(f,e,h)),l=Math.round(255*this.HueToRGB(f,e,i));return[j,k,l,this._sanitizeNumber(d)]},parse:function(b){if("string"!=typeof b)return this.fallbackValue;if(0===arguments.length)return!1;var c,d,e=this,f=!1,g="undefined"!=typeof this.colors[b];return g&&(b=this.colors[b].toLowerCase().trim()),a.each(this.stringParsers,function(a,h){var i=h.re.exec(b);return c=i&&h.parse.apply(e,[i]),!c||(f={},d=g?"alias":h.format?h.format:e.getValidFallbackFormat(),f=d.match(/hsla?/)?e.RGBtoHSB.apply(e,e.HSLtoRGB.apply(e,c)):e.RGBtoHSB.apply(e,c),f instanceof Object&&(f.format=d),!1)}),f},getValidFallbackFormat:function(){var a=["rgba","rgb","hex","hsla","hsl"];return this.origFormat&&a.indexOf(this.origFormat)!==-1?this.origFormat:this.fallbackFormat&&a.indexOf(this.fallbackFormat)!==-1?this.fallbackFormat:"rgba"},toString:function(a,c,d){c=c||this.origFormat||this.fallbackFormat,d=d||!1;var e=!1;switch(c){case"rgb":return e=this.toRGB(),this.rgbaIsTransparent(e)?"transparent":"rgb("+e.r+","+e.g+","+e.b+")";case"rgba":return e=this.toRGB(),"rgba("+e.r+","+e.g+","+e.b+","+e.a+")";case"hsl":return e=this.toHSL(),"hsl("+Math.round(360*e.h)+","+Math.round(100*e.s)+"%,"+Math.round(100*e.l)+"%)";case"hsla":return e=this.toHSL(),"hsla("+Math.round(360*e.h)+","+Math.round(100*e.s)+"%,"+Math.round(100*e.l)+"%,"+e.a+")";case"hex":return this.toHex(a);case"alias":return e=this.toAlias(),e===!1?this.toString(a,this.getValidFallbackFormat()):d&&!(e in b.webColors)&&e in this.predefinedColors?this.predefinedColors[e]:e;default:return e}},stringParsers:[{re:/rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*?\)/,format:"rgb",parse:function(a){return[a[1],a[2],a[3],1]}},{re:/rgb\(\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*?\)/,format:"rgb",parse:function(a){return[2.55*a[1],2.55*a[2],2.55*a[3],1]}},{re:/rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d*(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(a){return[a[1],a[2],a[3],a[4]]}},{re:/rgba\(\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*(?:,\s*(\d*(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(a){return[2.55*a[1],2.55*a[2],2.55*a[3],a[4]]}},{re:/hsl\(\s*(\d*(?:\.\d+)?)\s*,\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*?\)/,format:"hsl",parse:function(a){return[a[1]/360,a[2]/100,a[3]/100,a[4]]}},{re:/hsla\(\s*(\d*(?:\.\d+)?)\s*,\s*(\d*(?:\.\d+)?)\%\s*,\s*(\d*(?:\.\d+)?)\%\s*(?:,\s*(\d*(?:\.\d+)?)\s*)?\)/,format:"hsla",parse:function(a){return[a[1]/360,a[2]/100,a[3]/100,a[4]]}},{re:/#?([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/,format:"hex",parse:function(a){return[parseInt(a[1],16),parseInt(a[2],16),parseInt(a[3],16),1]}},{re:/#?([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/,format:"hex",parse:function(a){return[parseInt(a[1]+a[1],16),parseInt(a[2]+a[2],16),parseInt(a[3]+a[3],16),1]}}],colorNameToHex:function(a){return"undefined"!=typeof this.colors[a.toLowerCase()]&&this.colors[a.toLowerCase()]}};var c={horizontal:!1,inline:!1,color:!1,format:!1,input:"input",container:!1,component:".add-on, .input-group-addon",fallbackColor:!1,fallbackFormat:"hex",hexNumberSignPrefix:!0,sliders:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:0,maxTop:100,callLeft:!1,callTop:"setHue"},alpha:{maxLeft:0,maxTop:100,callLeft:!1,callTop:"setAlpha"}},slidersHorz:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:100,maxTop:0,callLeft:"setHue",callTop:!1},alpha:{maxLeft:100,maxTop:0,callLeft:"setAlpha",callTop:!1}},template:'<div class="colorpicker dropdown-menu"><div class="colorpicker-saturation"><i><b></b></i></div><div class="colorpicker-hue"><i></i></div><div class="colorpicker-alpha"><i></i></div><div class="colorpicker-color"><div /></div><div class="colorpicker-selectors"></div></div>',align:"right",customClass:null,colorSelectors:null},d=function(b,d){this.element=a(b).addClass("colorpicker-element"),this.options=a.extend(!0,{},c,this.element.data(),d),this.component=this.options.component,this.component=this.component!==!1&&this.element.find(this.component),this.component&&0===this.component.length&&(this.component=!1),this.container=this.options.container===!0?this.element:this.options.container,this.container=this.container!==!1&&a(this.container),this.input=this.element.is("input")?this.element:!!this.options.input&&this.element.find(this.options.input),this.input&&0===this.input.length&&(this.input=!1),this.color=this.createColor(this.options.color!==!1?this.options.color:this.getValue()),this.format=this.options.format!==!1?this.options.format:this.color.origFormat,this.options.color!==!1&&(this.updateInput(this.color),this.updateData(this.color)),this.disabled=!1;var e=this.picker=a(this.options.template);if(this.options.customClass&&e.addClass(this.options.customClass),this.options.inline?e.addClass("colorpicker-inline colorpicker-visible"):e.addClass("colorpicker-hidden"),this.options.horizontal&&e.addClass("colorpicker-horizontal"),["rgba","hsla","alias"].indexOf(this.format)===-1&&this.options.format!==!1&&"transparent"!==this.getValue()||e.addClass("colorpicker-with-alpha"),"right"===this.options.align&&e.addClass("colorpicker-right"),this.options.inline===!0&&e.addClass("colorpicker-no-arrow"),this.options.colorSelectors){var f=this,g=f.picker.find(".colorpicker-selectors");g.length>0&&(a.each(this.options.colorSelectors,function(b,c){var d=a("<i />").addClass("colorpicker-selectors-color").css("background-color",c).data("class",b).data("alias",b);d.on("mousedown.colorpicker touchstart.colorpicker",function(b){b.preventDefault(),f.setValue("alias"===f.format?a(this).data("alias"):a(this).css("background-color"))}),g.append(d)}),g.show().addClass("colorpicker-visible"))}e.on("mousedown.colorpicker touchstart.colorpicker",a.proxy(function(a){a.target===a.currentTarget&&a.preventDefault()},this)),e.find(".colorpicker-saturation, .colorpicker-hue, .colorpicker-alpha").on("mousedown.colorpicker touchstart.colorpicker",a.proxy(this.mousedown,this)),e.appendTo(this.container?this.container:a("body")),this.input!==!1&&(this.input.on({"keyup.colorpicker":a.proxy(this.keyup,this)}),this.input.on({"change.colorpicker":a.proxy(this.change,this)}),this.component===!1&&this.element.on({"focus.colorpicker":a.proxy(this.show,this)}),this.options.inline===!1&&this.element.on({"focusout.colorpicker":a.proxy(this.hide,this)})),this.component!==!1&&this.component.on({"click.colorpicker":a.proxy(this.show,this)}),this.input===!1&&this.component===!1&&this.element.on({"click.colorpicker":a.proxy(this.show,this)}),this.input!==!1&&this.component!==!1&&"color"===this.input.attr("type")&&this.input.on({"click.colorpicker":a.proxy(this.show,this),"focus.colorpicker":a.proxy(this.show,this)}),this.update(),a(a.proxy(function(){this.element.trigger("create")},this))};d.Color=b,d.prototype={constructor:d,destroy:function(){this.picker.remove(),this.element.removeData("colorpicker","color").off(".colorpicker"),this.input!==!1&&this.input.off(".colorpicker"),this.component!==!1&&this.component.off(".colorpicker"),this.element.removeClass("colorpicker-element"),this.element.trigger({type:"destroy"})},reposition:function(){if(this.options.inline!==!1||this.options.container)return!1;var a=this.container&&this.container[0]!==window.document.body?"position":"offset",b=this.component||this.element,c=b[a]();"right"===this.options.align&&(c.left-=this.picker.outerWidth()-b.outerWidth()),this.picker.css({top:c.top+b.outerHeight(),left:c.left})},show:function(b){this.isDisabled()||(this.picker.addClass("colorpicker-visible").removeClass("colorpicker-hidden"),this.reposition(),a(window).on("resize.colorpicker",a.proxy(this.reposition,this)),!b||this.hasInput()&&"color"!==this.input.attr("type")||b.stopPropagation&&b.preventDefault&&(b.stopPropagation(),b.preventDefault()),!this.component&&this.input||this.options.inline!==!1||a(window.document).on({"mousedown.colorpicker":a.proxy(this.hide,this)}),this.element.trigger({type:"showPicker",color:this.color}))},hide:function(b){return("undefined"==typeof b||!b.target||!(a(b.currentTarget).parents(".colorpicker").length>0||a(b.target).parents(".colorpicker").length>0))&&(this.picker.addClass("colorpicker-hidden").removeClass("colorpicker-visible"),a(window).off("resize.colorpicker",this.reposition),a(window.document).off({"mousedown.colorpicker":this.hide}),this.update(),void this.element.trigger({type:"hidePicker",color:this.color}))},updateData:function(a){return a=a||this.color.toString(!1,this.format),this.element.data("color",a),a},updateInput:function(a){return a=a||this.color.toString(!1,this.format),this.input!==!1&&(this.input.prop("value",a),this.input.trigger("change")),a},updatePicker:function(a){"undefined"!=typeof a&&(this.color=this.createColor(a));var b=this.options.horizontal===!1?this.options.sliders:this.options.slidersHorz,c=this.picker.find("i");if(0!==c.length)return this.options.horizontal===!1?(b=this.options.sliders,c.eq(1).css("top",b.hue.maxTop*(1-this.color.value.h)).end().eq(2).css("top",b.alpha.maxTop*(1-this.color.value.a))):(b=this.options.slidersHorz,c.eq(1).css("left",b.hue.maxLeft*(1-this.color.value.h)).end().eq(2).css("left",b.alpha.maxLeft*(1-this.color.value.a))),c.eq(0).css({top:b.saturation.maxTop-this.color.value.b*b.saturation.maxTop,left:this.color.value.s*b.saturation.maxLeft}),this.picker.find(".colorpicker-saturation").css("backgroundColor",this.color.toHex(!0,this.color.value.h,1,1,1)),this.picker.find(".colorpicker-alpha").css("backgroundColor",this.color.toHex(!0)),this.picker.find(".colorpicker-color, .colorpicker-color div").css("backgroundColor",this.color.toString(!0,this.format)),a},updateComponent:function(a){var b;if(b="undefined"!=typeof a?this.createColor(a):this.color,this.component!==!1){var c=this.component.find("i").eq(0);c.length>0?c.css({backgroundColor:b.toString(!0,this.format)}):this.component.css({backgroundColor:b.toString(!0,this.format)})}return b.toString(!1,this.format)},update:function(a){var b;return this.getValue(!1)===!1&&a!==!0||(b=this.updateComponent(),this.updateInput(b),this.updateData(b),this.updatePicker()),b},setValue:function(a){this.color=this.createColor(a),this.update(!0),this.element.trigger({type:"changeColor",color:this.color,value:a})},createColor:function(a){return new b(a?a:null,this.options.colorSelectors,this.options.fallbackColor?this.options.fallbackColor:this.color,this.options.fallbackFormat,this.options.hexNumberSignPrefix)},getValue:function(a){a="undefined"==typeof a?this.options.fallbackColor:a;var b;return b=this.hasInput()?this.input.val():this.element.data("color"),void 0!==b&&""!==b&&null!==b||(b=a),b},hasInput:function(){return this.input!==!1},isDisabled:function(){return this.disabled},disable:function(){return this.hasInput()&&this.input.prop("disabled",!0),this.disabled=!0,this.element.trigger({type:"disable",color:this.color,value:this.getValue()}),!0},enable:function(){return this.hasInput()&&this.input.prop("disabled",!1),this.disabled=!1,this.element.trigger({type:"enable",color:this.color,value:this.getValue()}),!0},currentSlider:null,mousePointer:{left:0,top:0},mousedown:function(b){!b.pageX&&!b.pageY&&b.originalEvent&&b.originalEvent.touches&&(b.pageX=b.originalEvent.touches[0].pageX,b.pageY=b.originalEvent.touches[0].pageY),b.stopPropagation(),b.preventDefault();var c=a(b.target),d=c.closest("div"),e=this.options.horizontal?this.options.slidersHorz:this.options.sliders;if(!d.is(".colorpicker")){if(d.is(".colorpicker-saturation"))this.currentSlider=a.extend({},e.saturation);else if(d.is(".colorpicker-hue"))this.currentSlider=a.extend({},e.hue);else{if(!d.is(".colorpicker-alpha"))return!1;this.currentSlider=a.extend({},e.alpha)}var f=d.offset();this.currentSlider.guide=d.find("i")[0].style,this.currentSlider.left=b.pageX-f.left,this.currentSlider.top=b.pageY-f.top,this.mousePointer={left:b.pageX,top:b.pageY},a(window.document).on({"mousemove.colorpicker":a.proxy(this.mousemove,this),"touchmove.colorpicker":a.proxy(this.mousemove,this),"mouseup.colorpicker":a.proxy(this.mouseup,this),"touchend.colorpicker":a.proxy(this.mouseup,this)}).trigger("mousemove")}return!1},mousemove:function(a){!a.pageX&&!a.pageY&&a.originalEvent&&a.originalEvent.touches&&(a.pageX=a.originalEvent.touches[0].pageX,a.pageY=a.originalEvent.touches[0].pageY),a.stopPropagation(),a.preventDefault();var b=Math.max(0,Math.min(this.currentSlider.maxLeft,this.currentSlider.left+((a.pageX||this.mousePointer.left)-this.mousePointer.left))),c=Math.max(0,Math.min(this.currentSlider.maxTop,this.currentSlider.top+((a.pageY||this.mousePointer.top)-this.mousePointer.top)));return this.currentSlider.guide.left=b+"px",this.currentSlider.guide.top=c+"px",this.currentSlider.callLeft&&this.color[this.currentSlider.callLeft].call(this.color,b/this.currentSlider.maxLeft),this.currentSlider.callTop&&this.color[this.currentSlider.callTop].call(this.color,c/this.currentSlider.maxTop),this.options.format!==!1||"setAlpha"!==this.currentSlider.callTop&&"setAlpha"!==this.currentSlider.callLeft||(1!==this.color.value.a?(this.format="rgba",this.color.origFormat="rgba"):(this.format="hex",this.color.origFormat="hex")),this.update(!0),this.element.trigger({type:"changeColor",color:this.color}),!1},mouseup:function(b){return b.stopPropagation(),b.preventDefault(),a(window.document).off({"mousemove.colorpicker":this.mousemove,"touchmove.colorpicker":this.mousemove,"mouseup.colorpicker":this.mouseup,"touchend.colorpicker":this.mouseup}),!1},change:function(a){this.keyup(a)},keyup:function(a){38===a.keyCode?(this.color.value.a<1&&(this.color.value.a=Math.round(100*(this.color.value.a+.01))/100),this.update(!0)):40===a.keyCode?(this.color.value.a>0&&(this.color.value.a=Math.round(100*(this.color.value.a-.01))/100),this.update(!0)):(this.color=this.createColor(this.input.val()),this.color.origFormat&&this.options.format===!1&&(this.format=this.color.origFormat),this.getValue(!1)!==!1&&(this.updateData(),this.updateComponent(),this.updatePicker())),this.element.trigger({type:"changeColor",color:this.color,value:this.input.val()})}},a.colorpicker=d,a.fn.colorpicker=function(b){var c=Array.prototype.slice.call(arguments,1),e=1===this.length,f=null,g=this.each(function(){var e=a(this),g=e.data("colorpicker"),h="object"==typeof b?b:{};g||(g=new d(this,h),e.data("colorpicker",g)),"string"==typeof b?a.isFunction(g[b])?f=g[b].apply(g,c):(c.length&&(g[b]=c[0]),f=g[b]):f=e});return e?f:g},a.fn.colorpicker.constructor=d});

/***/ },

/***/ "../smapServer/WebContent/js/libs/bootstrap-datetimepicker-4.17.47.js"
/*!****************************************************************************!*\
  !*** ../smapServer/WebContent/js/libs/bootstrap-datetimepicker-4.17.47.js ***!
  \****************************************************************************/
(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! version : 4.17.47
 =========================================================
 bootstrap-datetimejs
 https://github.com/Eonasdan/bootstrap-datetimepicker
 Copyright (c) 2015 Jonathan Peterson
 =========================================================
 */
/*
 The MIT License (MIT)

 Copyright (c) 2015 Jonathan Peterson

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 */
/*global define:false */
/*global exports:false */
/*global require:false */
/*global jQuery:false */
/*global moment:false */
(function (factory) {
	'use strict';
	if (true) {
		// AMD is used - Register as an anonymous module.
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "jquery"), __webpack_require__(/*! moment */ "moment")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else // removed by dead control flow
{}
}(function ($, moment) {
	'use strict';
	if (!moment) {
		throw new Error('bootstrap-datetimepicker requires Moment.js to be loaded first');
	}

	var dateTimePicker = function (element, options) {
		var picker = {},
			date,
			viewDate,
			unset = true,
			input,
			component = false,
			widget = false,
			use24Hours,
			minViewModeNumber = 0,
			actualFormat,
			parseFormats,
			currentViewMode,
			datePickerModes = [
				{
					clsName: 'days',
					navFnc: 'M',
					navStep: 1
				},
				{
					clsName: 'months',
					navFnc: 'y',
					navStep: 1
				},
				{
					clsName: 'years',
					navFnc: 'y',
					navStep: 10
				},
				{
					clsName: 'decades',
					navFnc: 'y',
					navStep: 100
				}
			],
			viewModes = ['days', 'months', 'years', 'decades'],
			verticalModes = ['top', 'bottom', 'auto'],
			horizontalModes = ['left', 'right', 'auto'],
			toolbarPlacements = ['default', 'top', 'bottom'],
			keyMap = {
				'up': 38,
				38: 'up',
				'down': 40,
				40: 'down',
				'left': 37,
				37: 'left',
				'right': 39,
				39: 'right',
				'tab': 9,
				9: 'tab',
				'escape': 27,
				27: 'escape',
				'enter': 13,
				13: 'enter',
				'pageUp': 33,
				33: 'pageUp',
				'pageDown': 34,
				34: 'pageDown',
				'shift': 16,
				16: 'shift',
				'control': 17,
				17: 'control',
				'space': 32,
				32: 'space',
				't': 84,
				84: 't',
				'delete': 46,
				46: 'delete'
			},
			keyState = {},

			/********************************************************************************
			 *
			 * Private functions
			 *
			 ********************************************************************************/

			hasTimeZone = function () {
				return moment.tz !== undefined && options.timeZone !== undefined && options.timeZone !== null && options.timeZone !== '';
			},

			getMoment = function (d) {
				var returnMoment;

				if (d === undefined || d === null) {
					returnMoment = moment(); //TODO should this use format? and locale?
				} else if (moment.isDate(d) || moment.isMoment(d)) {
					// If the date that is passed in is already a Date() or moment() object,
					// pass it directly to moment.
					returnMoment = moment(d);
				} else if (hasTimeZone()) { // There is a string to parse and a default time zone
					// parse with the tz function which takes a default time zone if it is not in the format string
					returnMoment = moment.tz(d, parseFormats, options.useStrict, options.timeZone);
				} else {
					returnMoment = moment(d, parseFormats, options.useStrict);
				}

				if (hasTimeZone()) {
					returnMoment.tz(options.timeZone);
				}

				return returnMoment;
			},

			isEnabled = function (granularity) {
				if (typeof granularity !== 'string' || granularity.length > 1) {
					throw new TypeError('isEnabled expects a single character string parameter');
				}
				switch (granularity) {
					case 'y':
						return actualFormat.indexOf('Y') !== -1;
					case 'M':
						return actualFormat.indexOf('M') !== -1;
					case 'd':
						return actualFormat.toLowerCase().indexOf('d') !== -1;
					case 'h':
					case 'H':
						return actualFormat.toLowerCase().indexOf('h') !== -1;
					case 'm':
						return actualFormat.indexOf('m') !== -1;
					case 's':
						return actualFormat.indexOf('s') !== -1;
					default:
						return false;
				}
			},

			hasTime = function () {
				return (isEnabled('h') || isEnabled('m') || isEnabled('s'));
			},

			hasDate = function () {
				return (isEnabled('y') || isEnabled('M') || isEnabled('d'));
			},

			getDatePickerTemplate = function () {
				var headTemplate = $('<thead>')
						.append($('<tr>')
							.append($('<th>').addClass('prev').attr('data-action', 'previous')
								.append($('<span>').addClass(options.icons.previous))
							)
							.append($('<th>').addClass('picker-switch').attr('data-action', 'pickerSwitch').attr('colspan', (options.calendarWeeks ? '6' : '5')))
							.append($('<th>').addClass('next').attr('data-action', 'next')
								.append($('<span>').addClass(options.icons.next))
							)
						),
					contTemplate = $('<tbody>')
						.append($('<tr>')
							.append($('<td>').attr('colspan', (options.calendarWeeks ? '8' : '7')))
						);

				return [
					$('<div>').addClass('datepicker-days')
						.append($('<table>').addClass('table-condensed')
							.append(headTemplate)
							.append($('<tbody>'))
						),
					$('<div>').addClass('datepicker-months')
						.append($('<table>').addClass('table-condensed')
							.append(headTemplate.clone())
							.append(contTemplate.clone())
						),
					$('<div>').addClass('datepicker-years')
						.append($('<table>').addClass('table-condensed')
							.append(headTemplate.clone())
							.append(contTemplate.clone())
						),
					$('<div>').addClass('datepicker-decades')
						.append($('<table>').addClass('table-condensed')
							.append(headTemplate.clone())
							.append(contTemplate.clone())
						)
				];
			},

			getTimePickerMainTemplate = function () {
				var topRow = $('<tr>'),
					middleRow = $('<tr>'),
					bottomRow = $('<tr>');

				if (isEnabled('h')) {
					topRow.append($('<td>')
						.append($('<a>').attr({ href: '#', tabindex: '-1', 'title': options.tooltips.incrementHour }).addClass('btn').attr('data-action', 'incrementHours').append($('<span>').addClass(options.icons.up))));
					middleRow.append($('<td>')
						.append($('<span>').addClass('timepicker-hour').attr({ 'data-time-component': 'hours', 'title': options.tooltips.pickHour }).attr('data-action', 'showHours')));
					bottomRow.append($('<td>')
						.append($('<a>').attr({ href: '#', tabindex: '-1', 'title': options.tooltips.decrementHour }).addClass('btn').attr('data-action', 'decrementHours').append($('<span>').addClass(options.icons.down))));
				}
				if (isEnabled('m')) {
					if (isEnabled('h')) {
						topRow.append($('<td>').addClass('separator'));
						middleRow.append($('<td>').addClass('separator').html(':'));
						bottomRow.append($('<td>').addClass('separator'));
					}
					topRow.append($('<td>')
						.append($('<a>').attr({ href: '#', tabindex: '-1', 'title': options.tooltips.incrementMinute }).addClass('btn').attr('data-action', 'incrementMinutes')
							.append($('<span>').addClass(options.icons.up))));
					middleRow.append($('<td>')
						.append($('<span>').addClass('timepicker-minute').attr({ 'data-time-component': 'minutes', 'title': options.tooltips.pickMinute }).attr('data-action', 'showMinutes')));
					bottomRow.append($('<td>')
						.append($('<a>').attr({ href: '#', tabindex: '-1', 'title': options.tooltips.decrementMinute }).addClass('btn').attr('data-action', 'decrementMinutes')
							.append($('<span>').addClass(options.icons.down))));
				}
				if (isEnabled('s')) {
					if (isEnabled('m')) {
						topRow.append($('<td>').addClass('separator'));
						middleRow.append($('<td>').addClass('separator').html(':'));
						bottomRow.append($('<td>').addClass('separator'));
					}
					topRow.append($('<td>')
						.append($('<a>').attr({ href: '#', tabindex: '-1', 'title': options.tooltips.incrementSecond }).addClass('btn').attr('data-action', 'incrementSeconds')
							.append($('<span>').addClass(options.icons.up))));
					middleRow.append($('<td>')
						.append($('<span>').addClass('timepicker-second').attr({ 'data-time-component': 'seconds', 'title': options.tooltips.pickSecond }).attr('data-action', 'showSeconds')));
					bottomRow.append($('<td>')
						.append($('<a>').attr({ href: '#', tabindex: '-1', 'title': options.tooltips.decrementSecond }).addClass('btn').attr('data-action', 'decrementSeconds')
							.append($('<span>').addClass(options.icons.down))));
				}

				if (!use24Hours) {
					topRow.append($('<td>').addClass('separator'));
					middleRow.append($('<td>')
						.append($('<button>').addClass('btn btn-primary').attr({ 'data-action': 'togglePeriod', tabindex: '-1', 'title': options.tooltips.togglePeriod })));
					bottomRow.append($('<td>').addClass('separator'));
				}

				return $('<div>').addClass('timepicker-picker')
					.append($('<table>').addClass('table-condensed')
						.append([topRow, middleRow, bottomRow]));
			},

			getTimePickerTemplate = function () {
				var hoursView = $('<div>').addClass('timepicker-hours')
						.append($('<table>').addClass('table-condensed')),
					minutesView = $('<div>').addClass('timepicker-minutes')
						.append($('<table>').addClass('table-condensed')),
					secondsView = $('<div>').addClass('timepicker-seconds')
						.append($('<table>').addClass('table-condensed')),
					ret = [getTimePickerMainTemplate()];

				if (isEnabled('h')) {
					ret.push(hoursView);
				}
				if (isEnabled('m')) {
					ret.push(minutesView);
				}
				if (isEnabled('s')) {
					ret.push(secondsView);
				}

				return ret;
			},

			getToolbar = function () {
				var row = [];
				if (options.showTodayButton) {
					row.push($('<td>').append($('<a>').attr({ 'data-action': 'today', 'title': options.tooltips.today }).append($('<span>').addClass(options.icons.today))));
				}
				if (!options.sideBySide && hasDate() && hasTime()) {
					row.push($('<td>').append($('<a>').attr({ 'data-action': 'togglePicker', 'title': options.tooltips.selectTime }).append($('<span>').addClass(options.icons.time))));
				}
				if (options.showClear) {
					row.push($('<td>').append($('<a>').attr({ 'data-action': 'clear', 'title': options.tooltips.clear }).append($('<span>').addClass(options.icons.clear))));
				}
				if (options.showClose) {
					row.push($('<td>').append($('<a>').attr({ 'data-action': 'close', 'title': options.tooltips.close }).append($('<span>').addClass(options.icons.close))));
				}
				return $('<table>').addClass('table-condensed').append($('<tbody>').append($('<tr>').append(row)));
			},

			getTemplate = function () {
				var template = $('<div>').addClass('bootstrap-datetimepicker-widget dropdown-menu'),
					dateView = $('<div>').addClass('datepicker').append(getDatePickerTemplate()),
					timeView = $('<div>').addClass('timepicker').append(getTimePickerTemplate()),
					content = $('<ul>').addClass('list-unstyled'),
					toolbar = $('<li>').addClass('picker-switch' + (options.collapse ? ' accordion-toggle' : '')).append(getToolbar());

				if (options.inline) {
					template.removeClass('dropdown-menu');
				}

				if (use24Hours) {
					template.addClass('usetwentyfour');
				}

				if (isEnabled('s') && !use24Hours) {
					template.addClass('wider');
				}

				if (options.sideBySide && hasDate() && hasTime()) {
					template.addClass('timepicker-sbs');
					if (options.toolbarPlacement === 'top') {
						template.append(toolbar);
					}
					template.append(
						$('<div>').addClass('row')
							.append(dateView.addClass('col-md-6'))
							.append(timeView.addClass('col-md-6'))
					);
					if (options.toolbarPlacement === 'bottom') {
						template.append(toolbar);
					}
					return template;
				}

				if (options.toolbarPlacement === 'top') {
					content.append(toolbar);
				}
				if (hasDate()) {
					content.append($('<li>').addClass((options.collapse && hasTime() ? 'collapse show' : '')).append(dateView));  // smap bootstrap v4
				}
				if (options.toolbarPlacement === 'default') {
					content.append(toolbar);
				}
				if (hasTime()) {
					content.append($('<li>').addClass((options.collapse && hasDate() ? 'collapse' : '')).append(timeView));
				}
				if (options.toolbarPlacement === 'bottom') {
					content.append(toolbar);
				}
				return template.append(content);
			},

			dataToOptions = function () {
				var eData,
					dataOptions = {};

				if (element.is('input') || options.inline) {
					eData = element.data();
				} else {
					eData = element.find('input').data();
				}

				if (eData.dateOptions && eData.dateOptions instanceof Object) {
					dataOptions = $.extend(true, dataOptions, eData.dateOptions);
				}

				$.each(options, function (key) {
					var attributeName = 'date' + key.charAt(0).toUpperCase() + key.slice(1);
					if (eData[attributeName] !== undefined) {
						dataOptions[key] = eData[attributeName];
					}
				});
				return dataOptions;
			},

			place = function () {
				var position = (component || element).position(),
					offset = (component || element).offset(),
					vertical = options.widgetPositioning.vertical,
					horizontal = options.widgetPositioning.horizontal,
					parent;

				if (options.widgetParent) {
					parent = options.widgetParent.append(widget);
				} else if (element.is('input')) {
					parent = element.after(widget).parent();
				} else if (options.inline) {
					parent = element.append(widget);
					return;
				} else {
					parent = element;
					element.children().first().after(widget);
				}

				// Top and bottom logic
				if (vertical === 'auto') {
					if (offset.top + widget.height() * 1.5 >= $(window).height() + $(window).scrollTop() &&
						widget.height() + element.outerHeight() < offset.top) {
						vertical = 'top';
					} else {
						vertical = 'bottom';
					}
				}

				// Left and right logic
				if (horizontal === 'auto') {
					if (parent.width() < offset.left + widget.outerWidth() / 2 &&
						offset.left + widget.outerWidth() > $(window).width()) {
						horizontal = 'right';
					} else {
						horizontal = 'left';
					}
				}

				if (vertical === 'top') {
					widget.addClass('top').removeClass('bottom');
				} else {
					widget.addClass('bottom').removeClass('top');
				}

				if (horizontal === 'right') {
					widget.addClass('pull-right');
				} else {
					widget.removeClass('pull-right');
				}

				// find the first parent element that has a non-static css positioning
				if (parent.css('position') === 'static') {
					parent = parent.parents().filter(function () {
						return $(this).css('position') !== 'static';
					}).first();
				}

				if (parent.length === 0) {
					throw new Error('datetimepicker component should be placed within a non-static positioned container');
				}

				widget.css({
					top: vertical === 'top' ? 'auto' : position.top + element.outerHeight(),
					bottom: vertical === 'top' ? parent.outerHeight() - (parent === element ? 0 : position.top) : 'auto',
					left: horizontal === 'left' ? (parent === element ? 0 : position.left) : 'auto',
					right: horizontal === 'left' ? 'auto' : parent.outerWidth() - element.outerWidth() - (parent === element ? 0 : position.left)
				});
			},

			notifyEvent = function (e) {
				if (e.type === 'dp.change' && ((e.date && e.date.isSame(e.oldDate)) || (!e.date && !e.oldDate))) {
					return;
				}
				element.trigger(e);
			},

			viewUpdate = function (e) {
				if (e === 'y') {
					e = 'YYYY';
				}
				notifyEvent({
					type: 'dp.update',
					change: e,
					viewDate: viewDate.clone()
				});
			},

			showMode = function (dir) {
				if (!widget) {
					return;
				}
				if (dir) {
					currentViewMode = Math.max(minViewModeNumber, Math.min(3, currentViewMode + dir));
				}
				widget.find('.datepicker > div').hide().filter('.datepicker-' + datePickerModes[currentViewMode].clsName).show();
			},

			fillDow = function () {
				var row = $('<tr>'),
					currentDate = viewDate.clone().startOf('w').startOf('d');

				if (options.calendarWeeks === true) {
					row.append($('<th>').addClass('cw').text('#'));
				}

				while (currentDate.isBefore(viewDate.clone().endOf('w'))) {
					row.append($('<th>').addClass('dow').text(currentDate.format('dd')));
					currentDate.add(1, 'd');
				}
				widget.find('.datepicker-days thead').append(row);
			},

			isInDisabledDates = function (testDate) {
				return options.disabledDates[testDate.format('YYYY-MM-DD')] === true;
			},

			isInEnabledDates = function (testDate) {
				return options.enabledDates[testDate.format('YYYY-MM-DD')] === true;
			},

			isInDisabledHours = function (testDate) {
				return options.disabledHours[testDate.format('H')] === true;
			},

			isInEnabledHours = function (testDate) {
				return options.enabledHours[testDate.format('H')] === true;
			},

			isValid = function (targetMoment, granularity) {
				if (!targetMoment.isValid()) {
					return false;
				}
				if (options.disabledDates && granularity === 'd' && isInDisabledDates(targetMoment)) {
					return false;
				}
				if (options.enabledDates && granularity === 'd' && !isInEnabledDates(targetMoment)) {
					return false;
				}
				if (options.minDate && targetMoment.isBefore(options.minDate, granularity)) {
					return false;
				}
				if (options.maxDate && targetMoment.isAfter(options.maxDate, granularity)) {
					return false;
				}
				if (options.daysOfWeekDisabled && granularity === 'd' && options.daysOfWeekDisabled.indexOf(targetMoment.day()) !== -1) {
					return false;
				}
				if (options.disabledHours && (granularity === 'h' || granularity === 'm' || granularity === 's') && isInDisabledHours(targetMoment)) {
					return false;
				}
				if (options.enabledHours && (granularity === 'h' || granularity === 'm' || granularity === 's') && !isInEnabledHours(targetMoment)) {
					return false;
				}
				if (options.disabledTimeIntervals && (granularity === 'h' || granularity === 'm' || granularity === 's')) {
					var found = false;
					$.each(options.disabledTimeIntervals, function () {
						if (targetMoment.isBetween(this[0], this[1])) {
							found = true;
							return false;
						}
					});
					if (found) {
						return false;
					}
				}
				return true;
			},

			fillMonths = function () {
				var spans = [],
					monthsShort = viewDate.clone().startOf('y').startOf('d');
				while (monthsShort.isSame(viewDate, 'y')) {
					spans.push($('<span>').attr('data-action', 'selectMonth').addClass('month').text(monthsShort.format('MMM')));
					monthsShort.add(1, 'M');
				}
				widget.find('.datepicker-months td').empty().append(spans);
			},

			updateMonths = function () {
				var monthsView = widget.find('.datepicker-months'),
					monthsViewHeader = monthsView.find('th'),
					months = monthsView.find('tbody').find('span');

				monthsViewHeader.eq(0).find('span').attr('title', options.tooltips.prevYear);
				monthsViewHeader.eq(1).attr('title', options.tooltips.selectYear);
				monthsViewHeader.eq(2).find('span').attr('title', options.tooltips.nextYear);

				monthsView.find('.disabled').removeClass('disabled');

				if (!isValid(viewDate.clone().subtract(1, 'y'), 'y')) {
					monthsViewHeader.eq(0).addClass('disabled');
				}

				monthsViewHeader.eq(1).text(viewDate.year());

				if (!isValid(viewDate.clone().add(1, 'y'), 'y')) {
					monthsViewHeader.eq(2).addClass('disabled');
				}

				months.removeClass('active');
				if (date.isSame(viewDate, 'y') && !unset) {
					months.eq(date.month()).addClass('active');
				}

				months.each(function (index) {
					if (!isValid(viewDate.clone().month(index), 'M')) {
						$(this).addClass('disabled');
					}
				});
			},

			updateYears = function () {
				var yearsView = widget.find('.datepicker-years'),
					yearsViewHeader = yearsView.find('th'),
					startYear = viewDate.clone().subtract(5, 'y'),
					endYear = viewDate.clone().add(6, 'y'),
					html = '';

				yearsViewHeader.eq(0).find('span').attr('title', options.tooltips.prevDecade);
				yearsViewHeader.eq(1).attr('title', options.tooltips.selectDecade);
				yearsViewHeader.eq(2).find('span').attr('title', options.tooltips.nextDecade);

				yearsView.find('.disabled').removeClass('disabled');

				if (options.minDate && options.minDate.isAfter(startYear, 'y')) {
					yearsViewHeader.eq(0).addClass('disabled');
				}

				yearsViewHeader.eq(1).text(startYear.year() + '-' + endYear.year());

				if (options.maxDate && options.maxDate.isBefore(endYear, 'y')) {
					yearsViewHeader.eq(2).addClass('disabled');
				}

				while (!startYear.isAfter(endYear, 'y')) {
					html += '<span data-action="selectYear" class="year' + (startYear.isSame(date, 'y') && !unset ? ' active' : '') + (!isValid(startYear, 'y') ? ' disabled' : '') + '">' + startYear.year() + '</span>';
					startYear.add(1, 'y');
				}

				yearsView.find('td').html(html);
			},

			updateDecades = function () {
				var decadesView = widget.find('.datepicker-decades'),
					decadesViewHeader = decadesView.find('th'),
					startDecade = moment({ y: viewDate.year() - (viewDate.year() % 100) - 1 }),
					endDecade = startDecade.clone().add(100, 'y'),
					startedAt = startDecade.clone(),
					minDateDecade = false,
					maxDateDecade = false,
					endDecadeYear,
					html = '';

				decadesViewHeader.eq(0).find('span').attr('title', options.tooltips.prevCentury);
				decadesViewHeader.eq(2).find('span').attr('title', options.tooltips.nextCentury);

				decadesView.find('.disabled').removeClass('disabled');

				if (startDecade.isSame(moment({ y: 1900 })) || (options.minDate && options.minDate.isAfter(startDecade, 'y'))) {
					decadesViewHeader.eq(0).addClass('disabled');
				}

				decadesViewHeader.eq(1).text(startDecade.year() + '-' + endDecade.year());

				if (startDecade.isSame(moment({ y: 2000 })) || (options.maxDate && options.maxDate.isBefore(endDecade, 'y'))) {
					decadesViewHeader.eq(2).addClass('disabled');
				}

				while (!startDecade.isAfter(endDecade, 'y')) {
					endDecadeYear = startDecade.year() + 12;
					minDateDecade = options.minDate && options.minDate.isAfter(startDecade, 'y') && options.minDate.year() <= endDecadeYear;
					maxDateDecade = options.maxDate && options.maxDate.isAfter(startDecade, 'y') && options.maxDate.year() <= endDecadeYear;
					html += '<span data-action="selectDecade" class="decade' + (date.isAfter(startDecade) && date.year() <= endDecadeYear ? ' active' : '') +
						(!isValid(startDecade, 'y') && !minDateDecade && !maxDateDecade ? ' disabled' : '') + '" data-selection="' + (startDecade.year() + 6) + '">' + (startDecade.year() + 1) + ' - ' + (startDecade.year() + 12) + '</span>';
					startDecade.add(12, 'y');
				}
				html += '<span></span><span></span><span></span>'; //push the dangling block over, at least this way it's even

				decadesView.find('td').html(html);
				decadesViewHeader.eq(1).text((startedAt.year() + 1) + '-' + (startDecade.year()));
			},

			fillDate = function () {
				var daysView = widget.find('.datepicker-days'),
					daysViewHeader = daysView.find('th'),
					currentDate,
					html = [],
					row,
					clsNames = [],
					i;

				if (!hasDate()) {
					return;
				}

				daysViewHeader.eq(0).find('span').attr('title', options.tooltips.prevMonth);
				daysViewHeader.eq(1).attr('title', options.tooltips.selectMonth);
				daysViewHeader.eq(2).find('span').attr('title', options.tooltips.nextMonth);

				daysView.find('.disabled').removeClass('disabled');
				daysViewHeader.eq(1).text(viewDate.format(options.dayViewHeaderFormat));

				if (!isValid(viewDate.clone().subtract(1, 'M'), 'M')) {
					daysViewHeader.eq(0).addClass('disabled');
				}
				if (!isValid(viewDate.clone().add(1, 'M'), 'M')) {
					daysViewHeader.eq(2).addClass('disabled');
				}

				currentDate = viewDate.clone().startOf('M').startOf('w').startOf('d');

				for (i = 0; i < 42; i++) { //always display 42 days (should show 6 weeks)
					if (currentDate.weekday() === 0) {
						row = $('<tr>');
						if (options.calendarWeeks) {
							row.append('<td class="cw">' + currentDate.week() + '</td>');
						}
						html.push(row);
					}
					clsNames = ['day'];
					if (currentDate.isBefore(viewDate, 'M')) {
						clsNames.push('old');
					}
					if (currentDate.isAfter(viewDate, 'M')) {
						clsNames.push('new');
					}
					if (currentDate.isSame(date, 'd') && !unset) {
						clsNames.push('active');
					}
					if (!isValid(currentDate, 'd')) {
						clsNames.push('disabled');
					}
					if (currentDate.isSame(getMoment(), 'd')) {
						clsNames.push('today');
					}
					if (currentDate.day() === 0 || currentDate.day() === 6) {
						clsNames.push('weekend');
					}
					notifyEvent({
						type: 'dp.classify',
						date: currentDate,
						classNames: clsNames
					});
					row.append('<td data-action="selectDay" data-day="' + currentDate.format('L') + '" class="' + clsNames.join(' ') + '">' + currentDate.date() + '</td>');
					currentDate.add(1, 'd');
				}

				daysView.find('tbody').empty().append(html);

				updateMonths();

				updateYears();

				updateDecades();
			},

			fillHours = function () {
				var table = widget.find('.timepicker-hours table'),
					currentHour = viewDate.clone().startOf('d'),
					html = [],
					row = $('<tr>');

				if (viewDate.hour() > 11 && !use24Hours) {
					currentHour.hour(12);
				}
				while (currentHour.isSame(viewDate, 'd') && (use24Hours || (viewDate.hour() < 12 && currentHour.hour() < 12) || viewDate.hour() > 11)) {
					if (currentHour.hour() % 4 === 0) {
						row = $('<tr>');
						html.push(row);
					}
					row.append('<td data-action="selectHour" class="hour' + (!isValid(currentHour, 'h') ? ' disabled' : '') + '">' + currentHour.format(use24Hours ? 'HH' : 'hh') + '</td>');
					currentHour.add(1, 'h');
				}
				table.empty().append(html);
			},

			fillMinutes = function () {
				var table = widget.find('.timepicker-minutes table'),
					currentMinute = viewDate.clone().startOf('h'),
					html = [],
					row = $('<tr>'),
					step = options.stepping === 1 ? 5 : options.stepping;

				while (viewDate.isSame(currentMinute, 'h')) {
					if (currentMinute.minute() % (step * 4) === 0) {
						row = $('<tr>');
						html.push(row);
					}
					row.append('<td data-action="selectMinute" class="minute' + (!isValid(currentMinute, 'm') ? ' disabled' : '') + '">' + currentMinute.format('mm') + '</td>');
					currentMinute.add(step, 'm');
				}
				table.empty().append(html);
			},

			fillSeconds = function () {
				var table = widget.find('.timepicker-seconds table'),
					currentSecond = viewDate.clone().startOf('m'),
					html = [],
					row = $('<tr>');

				while (viewDate.isSame(currentSecond, 'm')) {
					if (currentSecond.second() % 20 === 0) {
						row = $('<tr>');
						html.push(row);
					}
					row.append('<td data-action="selectSecond" class="second' + (!isValid(currentSecond, 's') ? ' disabled' : '') + '">' + currentSecond.format('ss') + '</td>');
					currentSecond.add(5, 's');
				}

				table.empty().append(html);
			},

			fillTime = function () {
				var toggle, newDate, timeComponents = widget.find('.timepicker span[data-time-component]');

				if (!use24Hours) {
					toggle = widget.find('.timepicker [data-action=togglePeriod]');
					newDate = date.clone().add((date.hours() >= 12) ? -12 : 12, 'h');

					toggle.text(date.format('A'));

					if (isValid(newDate, 'h')) {
						toggle.removeClass('disabled');
					} else {
						toggle.addClass('disabled');
					}
				}
				timeComponents.filter('[data-time-component=hours]').text(date.format(use24Hours ? 'HH' : 'hh'));
				timeComponents.filter('[data-time-component=minutes]').text(date.format('mm'));
				timeComponents.filter('[data-time-component=seconds]').text(date.format('ss'));

				fillHours();
				fillMinutes();
				fillSeconds();
			},

			update = function () {
				if (!widget) {
					return;
				}
				fillDate();
				fillTime();
			},

			setValue = function (targetMoment) {
				var oldDate = unset ? null : date;

				// case of calling setValue(null or false)
				if (!targetMoment) {
					unset = true;
					input.val('');
					element.data('date', '');
					notifyEvent({
						type: 'dp.change',
						date: false,
						oldDate: oldDate
					});
					update();
					return;
				}

				targetMoment = targetMoment.clone().locale(options.locale);

				if (hasTimeZone()) {
					targetMoment.tz(options.timeZone);
				}

				if (options.stepping !== 1) {
					targetMoment.minutes((Math.round(targetMoment.minutes() / options.stepping) * options.stepping)).seconds(0);

					while (options.minDate && targetMoment.isBefore(options.minDate)) {
						targetMoment.add(options.stepping, 'minutes');
					}
				}

				if (isValid(targetMoment)) {
					date = targetMoment;
					viewDate = date.clone();
					input.val(date.format(actualFormat));
					element.data('date', date.format(actualFormat));
					unset = false;
					update();
					notifyEvent({
						type: 'dp.change',
						date: date.clone(),
						oldDate: oldDate
					});
				} else {
					if (!options.keepInvalid) {
						input.val(unset ? '' : date.format(actualFormat));
					} else {
						notifyEvent({
							type: 'dp.change',
							date: targetMoment,
							oldDate: oldDate
						});
					}
					notifyEvent({
						type: 'dp.error',
						date: targetMoment,
						oldDate: oldDate
					});
				}
			},

			/**
			 * Hides the widget. Possibly will emit dp.hide
			 */
			hide = function () {
				var transitioning = false;
				if (!widget) {
					return picker;
				}
				// Ignore event if in the middle of a picker transition
				widget.find('.collapse').each(function () {
					var collapseData = $(this).data('collapse');
					if (collapseData && collapseData.transitioning) {
						transitioning = true;
						return false;
					}
					return true;
				});
				if (transitioning) {
					return picker;
				}
				if (component && component.hasClass('btn')) {
					component.toggleClass('active');
				}
				widget.hide();

				$(window).off('resize', place);
				widget.off('click', '[data-action]');
				widget.off('mousedown', false);

				widget.remove();
				widget = false;

				notifyEvent({
					type: 'dp.hide',
					date: date.clone()
				});

				input.blur();

				viewDate = date.clone();

				return picker;
			},

			clear = function () {
				setValue(null);
			},

			parseInputDate = function (inputDate) {
				if (options.parseInputDate === undefined) {
					if (!moment.isMoment(inputDate) || inputDate instanceof Date) {
						inputDate = getMoment(inputDate);
					}
				} else {
					inputDate = options.parseInputDate(inputDate);
				}
				//inputDate.locale(options.locale);
				return inputDate;
			},

			/********************************************************************************
			 *
			 * Widget UI interaction functions
			 *
			 ********************************************************************************/
			actions = {
				next: function () {
					var navFnc = datePickerModes[currentViewMode].navFnc;
					viewDate.add(datePickerModes[currentViewMode].navStep, navFnc);
					fillDate();
					viewUpdate(navFnc);
				},

				previous: function () {
					var navFnc = datePickerModes[currentViewMode].navFnc;
					viewDate.subtract(datePickerModes[currentViewMode].navStep, navFnc);
					fillDate();
					viewUpdate(navFnc);
				},

				pickerSwitch: function () {
					showMode(1);
				},

				selectMonth: function (e) {
					var month = $(e.target).closest('tbody').find('span').index($(e.target));
					viewDate.month(month);
					if (currentViewMode === minViewModeNumber) {
						setValue(date.clone().year(viewDate.year()).month(viewDate.month()));
						if (!options.inline) {
							hide();
						}
					} else {
						showMode(-1);
						fillDate();
					}
					viewUpdate('M');
				},

				selectYear: function (e) {
					var year = parseInt($(e.target).text(), 10) || 0;
					viewDate.year(year);
					if (currentViewMode === minViewModeNumber) {
						setValue(date.clone().year(viewDate.year()));
						if (!options.inline) {
							hide();
						}
					} else {
						showMode(-1);
						fillDate();
					}
					viewUpdate('YYYY');
				},

				selectDecade: function (e) {
					var year = parseInt($(e.target).data('selection'), 10) || 0;
					viewDate.year(year);
					if (currentViewMode === minViewModeNumber) {
						setValue(date.clone().year(viewDate.year()));
						if (!options.inline) {
							hide();
						}
					} else {
						showMode(-1);
						fillDate();
					}
					viewUpdate('YYYY');
				},

				selectDay: function (e) {
					var day = viewDate.clone();
					if ($(e.target).is('.old')) {
						day.subtract(1, 'M');
					}
					if ($(e.target).is('.new')) {
						day.add(1, 'M');
					}
					setValue(day.date(parseInt($(e.target).text(), 10)));
					if (!hasTime() && !options.keepOpen && !options.inline) {
						hide();
					}
				},

				incrementHours: function () {
					var newDate = date.clone().add(1, 'h');
					if (isValid(newDate, 'h')) {
						setValue(newDate);
					}
				},

				incrementMinutes: function () {
					var newDate = date.clone().add(options.stepping, 'm');
					if (isValid(newDate, 'm')) {
						setValue(newDate);
					}
				},

				incrementSeconds: function () {
					var newDate = date.clone().add(1, 's');
					if (isValid(newDate, 's')) {
						setValue(newDate);
					}
				},

				decrementHours: function () {
					var newDate = date.clone().subtract(1, 'h');
					if (isValid(newDate, 'h')) {
						setValue(newDate);
					}
				},

				decrementMinutes: function () {
					var newDate = date.clone().subtract(options.stepping, 'm');
					if (isValid(newDate, 'm')) {
						setValue(newDate);
					}
				},

				decrementSeconds: function () {
					var newDate = date.clone().subtract(1, 's');
					if (isValid(newDate, 's')) {
						setValue(newDate);
					}
				},

				togglePeriod: function () {
					setValue(date.clone().add((date.hours() >= 12) ? -12 : 12, 'h'));
				},

				togglePicker: function (e) {
					var $this = $(e.target),
						$parent = $this.closest('ul'),
						expanded = $parent.find('.show'),               // smap bootstrap v4
						closed = $parent.find('.collapse:not(.show)'),  // smap bootstrap v4
						collapseData;

					if (expanded && expanded.length) {
						collapseData = expanded.data('collapse');
						if (collapseData && collapseData.transitioning) {
							return;
						}
						if (expanded.collapse) { // if collapse plugin is available through bootstrap.js then use it
							expanded.collapse('hide');
							closed.collapse('show');
						} else { // otherwise just toggle in class on the two views
							expanded.removeClass('show');   // smap bootstrap v4
							closed.addClass('show');        // smap bootstrap v4
						}
						if ($this.is('span')) {
							$this.toggleClass(options.icons.time + ' ' + options.icons.date);
						} else {
							$this.find('span').toggleClass(options.icons.time + ' ' + options.icons.date);
						}

						// NOTE: uncomment if toggled state will be restored in show()
						//if (component) {
						//    component.find('span').toggleClass(options.icons.time + ' ' + options.icons.date);
						//}
					}
				},

				showPicker: function () {
					widget.find('.timepicker > div:not(.timepicker-picker)').hide();
					widget.find('.timepicker .timepicker-picker').show();
				},

				showHours: function () {
					widget.find('.timepicker .timepicker-picker').hide();
					widget.find('.timepicker .timepicker-hours').show();
				},

				showMinutes: function () {
					widget.find('.timepicker .timepicker-picker').hide();
					widget.find('.timepicker .timepicker-minutes').show();
				},

				showSeconds: function () {
					widget.find('.timepicker .timepicker-picker').hide();
					widget.find('.timepicker .timepicker-seconds').show();
				},

				selectHour: function (e) {
					var hour = parseInt($(e.target).text(), 10);

					if (!use24Hours) {
						if (date.hours() >= 12) {
							if (hour !== 12) {
								hour += 12;
							}
						} else {
							if (hour === 12) {
								hour = 0;
							}
						}
					}
					setValue(date.clone().hours(hour));
					actions.showPicker.call(picker);
				},

				selectMinute: function (e) {
					setValue(date.clone().minutes(parseInt($(e.target).text(), 10)));
					actions.showPicker.call(picker);
				},

				selectSecond: function (e) {
					setValue(date.clone().seconds(parseInt($(e.target).text(), 10)));
					actions.showPicker.call(picker);
				},

				clear: clear,

				today: function () {
					var todaysDate = getMoment();
					if (isValid(todaysDate, 'd')) {
						setValue(todaysDate);
					}
				},

				close: hide
			},

			doAction = function (e) {
				if ($(e.currentTarget).is('.disabled')) {
					return false;
				}
				actions[$(e.currentTarget).data('action')].apply(picker, arguments);
				return false;
			},

			/**
			 * Shows the widget. Possibly will emit dp.show and dp.change
			 */
			show = function () {
				var currentMoment,
					useCurrentGranularity = {
						'year': function (m) {
							return m.month(0).date(1).hours(0).seconds(0).minutes(0);
						},
						'month': function (m) {
							return m.date(1).hours(0).seconds(0).minutes(0);
						},
						'day': function (m) {
							return m.hours(0).seconds(0).minutes(0);
						},
						'hour': function (m) {
							return m.seconds(0).minutes(0);
						},
						'minute': function (m) {
							return m.seconds(0);
						}
					};

				if (input.prop('disabled') || (!options.ignoreReadonly && input.prop('readonly')) || widget) {
					return picker;
				}
				if (input.val() !== undefined && input.val().trim().length !== 0) {
					setValue(parseInputDate(input.val().trim()));
				} else if (unset && options.useCurrent && (options.inline || (input.is('input') && input.val().trim().length === 0))) {
					currentMoment = getMoment();
					if (typeof options.useCurrent === 'string') {
						currentMoment = useCurrentGranularity[options.useCurrent](currentMoment);
					}
					setValue(currentMoment);
				}
				widget = getTemplate();

				fillDow();
				fillMonths();

				widget.find('.timepicker-hours').hide();
				widget.find('.timepicker-minutes').hide();
				widget.find('.timepicker-seconds').hide();

				update();
				showMode();

				$(window).on('resize', place);
				widget.on('click', '[data-action]', doAction); // this handles clicks on the widget
				widget.on('mousedown', false);

				if (component && component.hasClass('btn')) {
					component.toggleClass('active');
				}
				place();
				widget.show();
				if (options.focusOnShow && !input.is(':focus')) {
					input.focus();
				}

				notifyEvent({
					type: 'dp.show'
				});
				return picker;
			},

			/**
			 * Shows or hides the widget
			 */
			toggle = function () {
				return (widget ? hide() : show());
			},

			keydown = function (e) {
				var handler = null,
					index,
					index2,
					pressedKeys = [],
					pressedModifiers = {},
					currentKey = e.which,
					keyBindKeys,
					allModifiersPressed,
					pressed = 'p';

				keyState[currentKey] = pressed;

				for (index in keyState) {
					if (keyState.hasOwnProperty(index) && keyState[index] === pressed) {
						pressedKeys.push(index);
						if (parseInt(index, 10) !== currentKey) {
							pressedModifiers[index] = true;
						}
					}
				}

				for (index in options.keyBinds) {
					if (options.keyBinds.hasOwnProperty(index) && typeof (options.keyBinds[index]) === 'function') {
						keyBindKeys = index.split(' ');
						if (keyBindKeys.length === pressedKeys.length && keyMap[currentKey] === keyBindKeys[keyBindKeys.length - 1]) {
							allModifiersPressed = true;
							for (index2 = keyBindKeys.length - 2; index2 >= 0; index2--) {
								if (!(keyMap[keyBindKeys[index2]] in pressedModifiers)) {
									allModifiersPressed = false;
									break;
								}
							}
							if (allModifiersPressed) {
								handler = options.keyBinds[index];
								break;
							}
						}
					}
				}

				if (handler) {
					handler.call(picker, widget);
					e.stopPropagation();
					e.preventDefault();
				}
			},

			keyup = function (e) {
				keyState[e.which] = 'r';
				e.stopPropagation();
				e.preventDefault();
			},

			change = function (e) {
				var val = $(e.target).val().trim(),
					parsedDate = val ? parseInputDate(val) : null;
				setValue(parsedDate);
				e.stopImmediatePropagation();
				return false;
			},

			attachDatePickerElementEvents = function () {
				input.on({
					'change': change,
					'blur': options.debug ? '' : hide,
					'keydown': keydown,
					'keyup': keyup,
					'focus': options.allowInputToggle ? show : ''
				});

				if (element.is('input')) {
					input.on({
						'focus': show
					});
				} else if (component) {
					component.on('click', toggle);
					component.on('mousedown', false);
				}
			},

			detachDatePickerElementEvents = function () {
				input.off({
					'change': change,
					'blur': blur,
					'keydown': keydown,
					'keyup': keyup,
					'focus': options.allowInputToggle ? hide : ''
				});

				if (element.is('input')) {
					input.off({
						'focus': show
					});
				} else if (component) {
					component.off('click', toggle);
					component.off('mousedown', false);
				}
			},

			indexGivenDates = function (givenDatesArray) {
				// Store given enabledDates and disabledDates as keys.
				// This way we can check their existence in O(1) time instead of looping through whole array.
				// (for example: options.enabledDates['2014-02-27'] === true)
				var givenDatesIndexed = {};
				$.each(givenDatesArray, function () {
					var dDate = parseInputDate(this);
					if (dDate.isValid()) {
						givenDatesIndexed[dDate.format('YYYY-MM-DD')] = true;
					}
				});
				return (Object.keys(givenDatesIndexed).length) ? givenDatesIndexed : false;
			},

			indexGivenHours = function (givenHoursArray) {
				// Store given enabledHours and disabledHours as keys.
				// This way we can check their existence in O(1) time instead of looping through whole array.
				// (for example: options.enabledHours['2014-02-27'] === true)
				var givenHoursIndexed = {};
				$.each(givenHoursArray, function () {
					givenHoursIndexed[this] = true;
				});
				return (Object.keys(givenHoursIndexed).length) ? givenHoursIndexed : false;
			},

			initFormatting = function () {
				var format = options.format || 'L LT';

				actualFormat = format.replace(/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g, function (formatInput) {
					var newinput = date.localeData().longDateFormat(formatInput) || formatInput;
					return newinput.replace(/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g, function (formatInput2) { //temp fix for #740
						return date.localeData().longDateFormat(formatInput2) || formatInput2;
					});
				});


				parseFormats = options.extraFormats ? options.extraFormats.slice() : [];
				if (parseFormats.indexOf(format) < 0 && parseFormats.indexOf(actualFormat) < 0) {
					parseFormats.push(actualFormat);
				}

				use24Hours = (actualFormat.toLowerCase().indexOf('a') < 1 && actualFormat.replace(/\[.*?\]/g, '').indexOf('h') < 1);

				if (isEnabled('y')) {
					minViewModeNumber = 2;
				}
				if (isEnabled('M')) {
					minViewModeNumber = 1;
				}
				if (isEnabled('d')) {
					minViewModeNumber = 0;
				}

				currentViewMode = Math.max(minViewModeNumber, currentViewMode);

				if (!unset) {
					setValue(date);
				}
			};

		/********************************************************************************
		 *
		 * Public API functions
		 * =====================
		 *
		 * Important: Do not expose direct references to private objects or the options
		 * object to the outer world. Always return a clone when returning values or make
		 * a clone when setting a private variable.
		 *
		 ********************************************************************************/
		picker.destroy = function () {
			///<summary>Destroys the widget and removes all attached event listeners</summary>
			hide();
			detachDatePickerElementEvents();
			element.removeData('DateTimePicker');
			element.removeData('date');
		};

		picker.toggle = toggle;

		picker.show = show;

		picker.hide = hide;

		picker.disable = function () {
			///<summary>Disables the input element, the component is attached to, by adding a disabled="true" attribute to it.
			///If the widget was visible before that call it is hidden. Possibly emits dp.hide</summary>
			hide();
			if (component && component.hasClass('btn')) {
				component.addClass('disabled');
			}
			input.prop('disabled', true);
			return picker;
		};

		picker.enable = function () {
			///<summary>Enables the input element, the component is attached to, by removing disabled attribute from it.</summary>
			if (component && component.hasClass('btn')) {
				component.removeClass('disabled');
			}
			input.prop('disabled', false);
			return picker;
		};

		picker.ignoreReadonly = function (ignoreReadonly) {
			if (arguments.length === 0) {
				return options.ignoreReadonly;
			}
			if (typeof ignoreReadonly !== 'boolean') {
				throw new TypeError('ignoreReadonly () expects a boolean parameter');
			}
			options.ignoreReadonly = ignoreReadonly;
			return picker;
		};

		picker.options = function (newOptions) {
			if (arguments.length === 0) {
				return $.extend(true, {}, options);
			}

			if (!(newOptions instanceof Object)) {
				throw new TypeError('options() options parameter should be an object');
			}
			$.extend(true, options, newOptions);
			$.each(options, function (key, value) {
				if (picker[key] !== undefined) {
					picker[key](value);
				} else {
					throw new TypeError('option ' + key + ' is not recognized!');
				}
			});
			return picker;
		};

		picker.date = function (newDate) {
			///<signature helpKeyword="$.fn.datetimepicker.date">
			///<summary>Returns the component's model current date, a moment object or null if not set.</summary>
			///<returns type="Moment">date.clone()</returns>
			///</signature>
			///<signature>
			///<summary>Sets the components model current moment to it. Passing a null value unsets the components model current moment. Parsing of the newDate parameter is made using moment library with the options.format and options.useStrict components configuration.</summary>
			///<param name="newDate" locid="$.fn.datetimepicker.date_p:newDate">Takes string, Date, moment, null parameter.</param>
			///</signature>
			if (arguments.length === 0) {
				if (unset) {
					return null;
				}
				return date.clone();
			}

			if (newDate !== null && typeof newDate !== 'string' && !moment.isMoment(newDate) && !(newDate instanceof Date)) {
				throw new TypeError('date() parameter must be one of [null, string, moment or Date]');
			}

			setValue(newDate === null ? null : parseInputDate(newDate));
			return picker;
		};

		picker.format = function (newFormat) {
			///<summary>test su</summary>
			///<param name="newFormat">info about para</param>
			///<returns type="string|boolean">returns foo</returns>
			if (arguments.length === 0) {
				return options.format;
			}

			if ((typeof newFormat !== 'string') && ((typeof newFormat !== 'boolean') || (newFormat !== false))) {
				throw new TypeError('format() expects a string or boolean:false parameter ' + newFormat);
			}

			options.format = newFormat;
			if (actualFormat) {
				initFormatting(); // reinit formatting
			}
			return picker;
		};

		picker.timeZone = function (newZone) {
			if (arguments.length === 0) {
				return options.timeZone;
			}

			if (typeof newZone !== 'string') {
				throw new TypeError('newZone() expects a string parameter');
			}

			options.timeZone = newZone;

			return picker;
		};

		picker.dayViewHeaderFormat = function (newFormat) {
			if (arguments.length === 0) {
				return options.dayViewHeaderFormat;
			}

			if (typeof newFormat !== 'string') {
				throw new TypeError('dayViewHeaderFormat() expects a string parameter');
			}

			options.dayViewHeaderFormat = newFormat;
			return picker;
		};

		picker.extraFormats = function (formats) {
			if (arguments.length === 0) {
				return options.extraFormats;
			}

			if (formats !== false && !(formats instanceof Array)) {
				throw new TypeError('extraFormats() expects an array or false parameter');
			}

			options.extraFormats = formats;
			if (parseFormats) {
				initFormatting(); // reinit formatting
			}
			return picker;
		};

		picker.disabledDates = function (dates) {
			///<signature helpKeyword="$.fn.datetimepicker.disabledDates">
			///<summary>Returns an array with the currently set disabled dates on the component.</summary>
			///<returns type="array">options.disabledDates</returns>
			///</signature>
			///<signature>
			///<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of
			///options.enabledDates if such exist.</summary>
			///<param name="dates" locid="$.fn.datetimepicker.disabledDates_p:dates">Takes an [ string or Date or moment ] of values and allows the user to select only from those days.</param>
			///</signature>
			if (arguments.length === 0) {
				return (options.disabledDates ? $.extend({}, options.disabledDates) : options.disabledDates);
			}

			if (!dates) {
				options.disabledDates = false;
				update();
				return picker;
			}
			if (!(dates instanceof Array)) {
				throw new TypeError('disabledDates() expects an array parameter');
			}
			options.disabledDates = indexGivenDates(dates);
			options.enabledDates = false;
			update();
			return picker;
		};

		picker.enabledDates = function (dates) {
			///<signature helpKeyword="$.fn.datetimepicker.enabledDates">
			///<summary>Returns an array with the currently set enabled dates on the component.</summary>
			///<returns type="array">options.enabledDates</returns>
			///</signature>
			///<signature>
			///<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of options.disabledDates if such exist.</summary>
			///<param name="dates" locid="$.fn.datetimepicker.enabledDates_p:dates">Takes an [ string or Date or moment ] of values and allows the user to select only from those days.</param>
			///</signature>
			if (arguments.length === 0) {
				return (options.enabledDates ? $.extend({}, options.enabledDates) : options.enabledDates);
			}

			if (!dates) {
				options.enabledDates = false;
				update();
				return picker;
			}
			if (!(dates instanceof Array)) {
				throw new TypeError('enabledDates() expects an array parameter');
			}
			options.enabledDates = indexGivenDates(dates);
			options.disabledDates = false;
			update();
			return picker;
		};

		picker.daysOfWeekDisabled = function (daysOfWeekDisabled) {
			if (arguments.length === 0) {
				return options.daysOfWeekDisabled.splice(0);
			}

			if ((typeof daysOfWeekDisabled === 'boolean') && !daysOfWeekDisabled) {
				options.daysOfWeekDisabled = false;
				update();
				return picker;
			}

			if (!(daysOfWeekDisabled instanceof Array)) {
				throw new TypeError('daysOfWeekDisabled() expects an array parameter');
			}
			options.daysOfWeekDisabled = daysOfWeekDisabled.reduce(function (previousValue, currentValue) {
				currentValue = parseInt(currentValue, 10);
				if (currentValue > 6 || currentValue < 0 || isNaN(currentValue)) {
					return previousValue;
				}
				if (previousValue.indexOf(currentValue) === -1) {
					previousValue.push(currentValue);
				}
				return previousValue;
			}, []).sort();
			if (options.useCurrent && !options.keepInvalid) {
				var tries = 0;
				while (!isValid(date, 'd')) {
					date.add(1, 'd');
					if (tries === 31) {
						throw 'Tried 31 times to find a valid date';
					}
					tries++;
				}
				setValue(date);
			}
			update();
			return picker;
		};

		picker.maxDate = function (maxDate) {
			if (arguments.length === 0) {
				return options.maxDate ? options.maxDate.clone() : options.maxDate;
			}

			if ((typeof maxDate === 'boolean') && maxDate === false) {
				options.maxDate = false;
				update();
				return picker;
			}

			if (typeof maxDate === 'string') {
				if (maxDate === 'now' || maxDate === 'moment') {
					maxDate = getMoment();
				}
			}

			var parsedDate = parseInputDate(maxDate);

			if (!parsedDate.isValid()) {
				throw new TypeError('maxDate() Could not parse date parameter: ' + maxDate);
			}
			if (options.minDate && parsedDate.isBefore(options.minDate)) {
				throw new TypeError('maxDate() date parameter is before options.minDate: ' + parsedDate.format(actualFormat));
			}
			options.maxDate = parsedDate;
			if (options.useCurrent && !options.keepInvalid && date.isAfter(maxDate)) {
				setValue(options.maxDate);
			}
			if (viewDate.isAfter(parsedDate)) {
				viewDate = parsedDate.clone().subtract(options.stepping, 'm');
			}
			update();
			return picker;
		};

		picker.minDate = function (minDate) {
			if (arguments.length === 0) {
				return options.minDate ? options.minDate.clone() : options.minDate;
			}

			if ((typeof minDate === 'boolean') && minDate === false) {
				options.minDate = false;
				update();
				return picker;
			}

			if (typeof minDate === 'string') {
				if (minDate === 'now' || minDate === 'moment') {
					minDate = getMoment();
				}
			}

			var parsedDate = parseInputDate(minDate);

			if (!parsedDate.isValid()) {
				throw new TypeError('minDate() Could not parse date parameter: ' + minDate);
			}
			if (options.maxDate && parsedDate.isAfter(options.maxDate)) {
				throw new TypeError('minDate() date parameter is after options.maxDate: ' + parsedDate.format(actualFormat));
			}
			options.minDate = parsedDate;
			if (options.useCurrent && !options.keepInvalid && date.isBefore(minDate)) {
				setValue(options.minDate);
			}
			if (viewDate.isBefore(parsedDate)) {
				viewDate = parsedDate.clone().add(options.stepping, 'm');
			}
			update();
			return picker;
		};

		picker.defaultDate = function (defaultDate) {
			///<signature helpKeyword="$.fn.datetimepicker.defaultDate">
			///<summary>Returns a moment with the options.defaultDate option configuration or false if not set</summary>
			///<returns type="Moment">date.clone()</returns>
			///</signature>
			///<signature>
			///<summary>Will set the picker's inital date. If a boolean:false value is passed the options.defaultDate parameter is cleared.</summary>
			///<param name="defaultDate" locid="$.fn.datetimepicker.defaultDate_p:defaultDate">Takes a string, Date, moment, boolean:false</param>
			///</signature>
			if (arguments.length === 0) {
				return options.defaultDate ? options.defaultDate.clone() : options.defaultDate;
			}
			if (!defaultDate) {
				options.defaultDate = false;
				return picker;
			}

			if (typeof defaultDate === 'string') {
				if (defaultDate === 'now' || defaultDate === 'moment') {
					defaultDate = getMoment();
				} else {
					defaultDate = getMoment(defaultDate);
				}
			}

			var parsedDate = parseInputDate(defaultDate);
			if (!parsedDate.isValid()) {
				throw new TypeError('defaultDate() Could not parse date parameter: ' + defaultDate);
			}
			if (!isValid(parsedDate)) {
				throw new TypeError('defaultDate() date passed is invalid according to component setup validations');
			}

			options.defaultDate = parsedDate;

			if ((options.defaultDate && options.inline) || input.val().trim() === '') {
				setValue(options.defaultDate);
			}
			return picker;
		};

		picker.locale = function (locale) {
			if (arguments.length === 0) {
				return options.locale;
			}

			if (!moment.localeData(locale)) {
				throw new TypeError('locale() locale ' + locale + ' is not loaded from moment locales!');
			}

			options.locale = locale;
			date.locale(options.locale);
			viewDate.locale(options.locale);

			if (actualFormat) {
				initFormatting(); // reinit formatting
			}
			if (widget) {
				hide();
				show();
			}
			return picker;
		};

		picker.stepping = function (stepping) {
			if (arguments.length === 0) {
				return options.stepping;
			}

			stepping = parseInt(stepping, 10);
			if (isNaN(stepping) || stepping < 1) {
				stepping = 1;
			}
			options.stepping = stepping;
			return picker;
		};

		picker.useCurrent = function (useCurrent) {
			var useCurrentOptions = ['year', 'month', 'day', 'hour', 'minute'];
			if (arguments.length === 0) {
				return options.useCurrent;
			}

			if ((typeof useCurrent !== 'boolean') && (typeof useCurrent !== 'string')) {
				throw new TypeError('useCurrent() expects a boolean or string parameter');
			}
			if (typeof useCurrent === 'string' && useCurrentOptions.indexOf(useCurrent.toLowerCase()) === -1) {
				throw new TypeError('useCurrent() expects a string parameter of ' + useCurrentOptions.join(', '));
			}
			options.useCurrent = useCurrent;
			return picker;
		};

		picker.collapse = function (collapse) {
			if (arguments.length === 0) {
				return options.collapse;
			}

			if (typeof collapse !== 'boolean') {
				throw new TypeError('collapse() expects a boolean parameter');
			}
			if (options.collapse === collapse) {
				return picker;
			}
			options.collapse = collapse;
			if (widget) {
				hide();
				show();
			}
			return picker;
		};

		picker.icons = function (icons) {
			if (arguments.length === 0) {
				return $.extend({}, options.icons);
			}

			if (!(icons instanceof Object)) {
				throw new TypeError('icons() expects parameter to be an Object');
			}
			$.extend(options.icons, icons);
			if (widget) {
				hide();
				show();
			}
			return picker;
		};

		picker.tooltips = function (tooltips) {
			if (arguments.length === 0) {
				return $.extend({}, options.tooltips);
			}

			if (!(tooltips instanceof Object)) {
				throw new TypeError('tooltips() expects parameter to be an Object');
			}
			$.extend(options.tooltips, tooltips);
			if (widget) {
				hide();
				show();
			}
			return picker;
		};

		picker.useStrict = function (useStrict) {
			if (arguments.length === 0) {
				return options.useStrict;
			}

			if (typeof useStrict !== 'boolean') {
				throw new TypeError('useStrict() expects a boolean parameter');
			}
			options.useStrict = useStrict;
			return picker;
		};

		picker.sideBySide = function (sideBySide) {
			if (arguments.length === 0) {
				return options.sideBySide;
			}

			if (typeof sideBySide !== 'boolean') {
				throw new TypeError('sideBySide() expects a boolean parameter');
			}
			options.sideBySide = sideBySide;
			if (widget) {
				hide();
				show();
			}
			return picker;
		};

		picker.viewMode = function (viewMode) {
			if (arguments.length === 0) {
				return options.viewMode;
			}

			if (typeof viewMode !== 'string') {
				throw new TypeError('viewMode() expects a string parameter');
			}

			if (viewModes.indexOf(viewMode) === -1) {
				throw new TypeError('viewMode() parameter must be one of (' + viewModes.join(', ') + ') value');
			}

			options.viewMode = viewMode;
			currentViewMode = Math.max(viewModes.indexOf(viewMode), minViewModeNumber);

			showMode();
			return picker;
		};

		picker.toolbarPlacement = function (toolbarPlacement) {
			if (arguments.length === 0) {
				return options.toolbarPlacement;
			}

			if (typeof toolbarPlacement !== 'string') {
				throw new TypeError('toolbarPlacement() expects a string parameter');
			}
			if (toolbarPlacements.indexOf(toolbarPlacement) === -1) {
				throw new TypeError('toolbarPlacement() parameter must be one of (' + toolbarPlacements.join(', ') + ') value');
			}
			options.toolbarPlacement = toolbarPlacement;

			if (widget) {
				hide();
				show();
			}
			return picker;
		};

		picker.widgetPositioning = function (widgetPositioning) {
			if (arguments.length === 0) {
				return $.extend({}, options.widgetPositioning);
			}

			if (({}).toString.call(widgetPositioning) !== '[object Object]') {
				throw new TypeError('widgetPositioning() expects an object variable');
			}
			if (widgetPositioning.horizontal) {
				if (typeof widgetPositioning.horizontal !== 'string') {
					throw new TypeError('widgetPositioning() horizontal variable must be a string');
				}
				widgetPositioning.horizontal = widgetPositioning.horizontal.toLowerCase();
				if (horizontalModes.indexOf(widgetPositioning.horizontal) === -1) {
					throw new TypeError('widgetPositioning() expects horizontal parameter to be one of (' + horizontalModes.join(', ') + ')');
				}
				options.widgetPositioning.horizontal = widgetPositioning.horizontal;
			}
			if (widgetPositioning.vertical) {
				if (typeof widgetPositioning.vertical !== 'string') {
					throw new TypeError('widgetPositioning() vertical variable must be a string');
				}
				widgetPositioning.vertical = widgetPositioning.vertical.toLowerCase();
				if (verticalModes.indexOf(widgetPositioning.vertical) === -1) {
					throw new TypeError('widgetPositioning() expects vertical parameter to be one of (' + verticalModes.join(', ') + ')');
				}
				options.widgetPositioning.vertical = widgetPositioning.vertical;
			}
			update();
			return picker;
		};

		picker.calendarWeeks = function (calendarWeeks) {
			if (arguments.length === 0) {
				return options.calendarWeeks;
			}

			if (typeof calendarWeeks !== 'boolean') {
				throw new TypeError('calendarWeeks() expects parameter to be a boolean value');
			}

			options.calendarWeeks = calendarWeeks;
			update();
			return picker;
		};

		picker.showTodayButton = function (showTodayButton) {
			if (arguments.length === 0) {
				return options.showTodayButton;
			}

			if (typeof showTodayButton !== 'boolean') {
				throw new TypeError('showTodayButton() expects a boolean parameter');
			}

			options.showTodayButton = showTodayButton;
			if (widget) {
				hide();
				show();
			}
			return picker;
		};

		picker.showClear = function (showClear) {
			if (arguments.length === 0) {
				return options.showClear;
			}

			if (typeof showClear !== 'boolean') {
				throw new TypeError('showClear() expects a boolean parameter');
			}

			options.showClear = showClear;
			if (widget) {
				hide();
				show();
			}
			return picker;
		};

		picker.widgetParent = function (widgetParent) {
			if (arguments.length === 0) {
				return options.widgetParent;
			}

			if (typeof widgetParent === 'string') {
				widgetParent = $(widgetParent);
			}

			if (widgetParent !== null && (typeof widgetParent !== 'string' && !(widgetParent instanceof $))) {
				throw new TypeError('widgetParent() expects a string or a jQuery object parameter');
			}

			options.widgetParent = widgetParent;
			if (widget) {
				hide();
				show();
			}
			return picker;
		};

		picker.keepOpen = function (keepOpen) {
			if (arguments.length === 0) {
				return options.keepOpen;
			}

			if (typeof keepOpen !== 'boolean') {
				throw new TypeError('keepOpen() expects a boolean parameter');
			}

			options.keepOpen = keepOpen;
			return picker;
		};

		picker.focusOnShow = function (focusOnShow) {
			if (arguments.length === 0) {
				return options.focusOnShow;
			}

			if (typeof focusOnShow !== 'boolean') {
				throw new TypeError('focusOnShow() expects a boolean parameter');
			}

			options.focusOnShow = focusOnShow;
			return picker;
		};

		picker.inline = function (inline) {
			if (arguments.length === 0) {
				return options.inline;
			}

			if (typeof inline !== 'boolean') {
				throw new TypeError('inline() expects a boolean parameter');
			}

			options.inline = inline;
			return picker;
		};

		picker.clear = function () {
			clear();
			return picker;
		};

		picker.keyBinds = function (keyBinds) {
			if (arguments.length === 0) {
				return options.keyBinds;
			}

			options.keyBinds = keyBinds;
			return picker;
		};

		picker.getMoment = function (d) {
			return getMoment(d);
		};

		picker.debug = function (debug) {
			if (typeof debug !== 'boolean') {
				throw new TypeError('debug() expects a boolean parameter');
			}

			options.debug = debug;
			return picker;
		};

		picker.allowInputToggle = function (allowInputToggle) {
			if (arguments.length === 0) {
				return options.allowInputToggle;
			}

			if (typeof allowInputToggle !== 'boolean') {
				throw new TypeError('allowInputToggle() expects a boolean parameter');
			}

			options.allowInputToggle = allowInputToggle;
			return picker;
		};

		picker.showClose = function (showClose) {
			if (arguments.length === 0) {
				return options.showClose;
			}

			if (typeof showClose !== 'boolean') {
				throw new TypeError('showClose() expects a boolean parameter');
			}

			options.showClose = showClose;
			return picker;
		};

		picker.keepInvalid = function (keepInvalid) {
			if (arguments.length === 0) {
				return options.keepInvalid;
			}

			if (typeof keepInvalid !== 'boolean') {
				throw new TypeError('keepInvalid() expects a boolean parameter');
			}
			options.keepInvalid = keepInvalid;
			return picker;
		};

		picker.datepickerInput = function (datepickerInput) {
			if (arguments.length === 0) {
				return options.datepickerInput;
			}

			if (typeof datepickerInput !== 'string') {
				throw new TypeError('datepickerInput() expects a string parameter');
			}

			options.datepickerInput = datepickerInput;
			return picker;
		};

		picker.parseInputDate = function (parseInputDate) {
			if (arguments.length === 0) {
				return options.parseInputDate;
			}

			if (typeof parseInputDate !== 'function') {
				throw new TypeError('parseInputDate() sholud be as function');
			}

			options.parseInputDate = parseInputDate;

			return picker;
		};

		picker.disabledTimeIntervals = function (disabledTimeIntervals) {
			///<signature helpKeyword="$.fn.datetimepicker.disabledTimeIntervals">
			///<summary>Returns an array with the currently set disabled dates on the component.</summary>
			///<returns type="array">options.disabledTimeIntervals</returns>
			///</signature>
			///<signature>
			///<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of
			///options.enabledDates if such exist.</summary>
			///<param name="dates" locid="$.fn.datetimepicker.disabledTimeIntervals_p:dates">Takes an [ string or Date or moment ] of values and allows the user to select only from those days.</param>
			///</signature>
			if (arguments.length === 0) {
				return (options.disabledTimeIntervals ? $.extend({}, options.disabledTimeIntervals) : options.disabledTimeIntervals);
			}

			if (!disabledTimeIntervals) {
				options.disabledTimeIntervals = false;
				update();
				return picker;
			}
			if (!(disabledTimeIntervals instanceof Array)) {
				throw new TypeError('disabledTimeIntervals() expects an array parameter');
			}
			options.disabledTimeIntervals = disabledTimeIntervals;
			update();
			return picker;
		};

		picker.disabledHours = function (hours) {
			///<signature helpKeyword="$.fn.datetimepicker.disabledHours">
			///<summary>Returns an array with the currently set disabled hours on the component.</summary>
			///<returns type="array">options.disabledHours</returns>
			///</signature>
			///<signature>
			///<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of
			///options.enabledHours if such exist.</summary>
			///<param name="hours" locid="$.fn.datetimepicker.disabledHours_p:hours">Takes an [ int ] of values and disallows the user to select only from those hours.</param>
			///</signature>
			if (arguments.length === 0) {
				return (options.disabledHours ? $.extend({}, options.disabledHours) : options.disabledHours);
			}

			if (!hours) {
				options.disabledHours = false;
				update();
				return picker;
			}
			if (!(hours instanceof Array)) {
				throw new TypeError('disabledHours() expects an array parameter');
			}
			options.disabledHours = indexGivenHours(hours);
			options.enabledHours = false;
			if (options.useCurrent && !options.keepInvalid) {
				var tries = 0;
				while (!isValid(date, 'h')) {
					date.add(1, 'h');
					if (tries === 24) {
						throw 'Tried 24 times to find a valid date';
					}
					tries++;
				}
				setValue(date);
			}
			update();
			return picker;
		};

		picker.enabledHours = function (hours) {
			///<signature helpKeyword="$.fn.datetimepicker.enabledHours">
			///<summary>Returns an array with the currently set enabled hours on the component.</summary>
			///<returns type="array">options.enabledHours</returns>
			///</signature>
			///<signature>
			///<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of options.disabledHours if such exist.</summary>
			///<param name="hours" locid="$.fn.datetimepicker.enabledHours_p:hours">Takes an [ int ] of values and allows the user to select only from those hours.</param>
			///</signature>
			if (arguments.length === 0) {
				return (options.enabledHours ? $.extend({}, options.enabledHours) : options.enabledHours);
			}

			if (!hours) {
				options.enabledHours = false;
				update();
				return picker;
			}
			if (!(hours instanceof Array)) {
				throw new TypeError('enabledHours() expects an array parameter');
			}
			options.enabledHours = indexGivenHours(hours);
			options.disabledHours = false;
			if (options.useCurrent && !options.keepInvalid) {
				var tries = 0;
				while (!isValid(date, 'h')) {
					date.add(1, 'h');
					if (tries === 24) {
						throw 'Tried 24 times to find a valid date';
					}
					tries++;
				}
				setValue(date);
			}
			update();
			return picker;
		};
		/**
		 * Returns the component's model current viewDate, a moment object or null if not set. Passing a null value unsets the components model current moment. Parsing of the newDate parameter is made using moment library with the options.format and options.useStrict components configuration.
		 * @param {Takes string, viewDate, moment, null parameter.} newDate
		 * @returns {viewDate.clone()}
		 */
		picker.viewDate = function (newDate) {
			if (arguments.length === 0) {
				return viewDate.clone();
			}

			if (!newDate) {
				viewDate = date.clone();
				return picker;
			}

			if (typeof newDate !== 'string' && !moment.isMoment(newDate) && !(newDate instanceof Date)) {
				throw new TypeError('viewDate() parameter must be one of [string, moment or Date]');
			}

			viewDate = parseInputDate(newDate);
			viewUpdate();
			return picker;
		};

		// initializing element and component attributes
		if (element.is('input')) {
			input = element;
		} else {
			input = element.find(options.datepickerInput);
			if (input.length === 0) {
				input = element.find('input');
			} else if (!input.is('input')) {
				throw new Error('CSS class "' + options.datepickerInput + '" cannot be applied to non input element');
			}
		}

		if (element.hasClass('input-group')) {
			// in case there is more then one 'input-group-addon' Issue #48
			if (element.find('.datepickerbutton').length === 0) {
				component = element.find('.input-group-addon');
			} else {
				component = element.find('.datepickerbutton');
			}
		}

		if (!options.inline && !input.is('input')) {
			throw new Error('Could not initialize DateTimePicker without an input element');
		}

		// Set defaults for date here now instead of in var declaration
		date = getMoment();
		viewDate = date.clone();

		$.extend(true, options, dataToOptions());

		picker.options(options);

		initFormatting();

		attachDatePickerElementEvents();

		if (input.prop('disabled')) {
			picker.disable();
		}
		if (input.is('input') && input.val().trim().length !== 0) {
			setValue(parseInputDate(input.val().trim()));
		}
		else if (options.defaultDate && input.attr('placeholder') === undefined) {
			setValue(options.defaultDate);
		}
		if (options.inline) {
			show();
		}
		return picker;
	};

	/********************************************************************************
	 *
	 * jQuery plugin constructor and defaults object
	 *
	 ********************************************************************************/

	/**
	 * See (http://jquery.com/).
	 * @name jQuery
	 * @class
	 * See the jQuery Library  (http://jquery.com/) for full details.  This just
	 * documents the function and classes that are added to jQuery by this plug-in.
	 */
	/**
	 * See (http://jquery.com/)
	 * @name fn
	 * @class
	 * See the jQuery Library  (http://jquery.com/) for full details.  This just
	 * documents the function and classes that are added to jQuery by this plug-in.
	 * @memberOf jQuery
	 */
	/**
	 * Show comments
	 * @class datetimepicker
	 * @memberOf jQuery.fn
	 */
	$.fn.datetimepicker = function (options) {
		options = options || {};

		var args = Array.prototype.slice.call(arguments, 1),
			isInstance = true,
			thisMethods = ['destroy', 'hide', 'show', 'toggle'],
			returnValue;

		if (typeof options === 'object') {
			return this.each(function () {
				var $this = $(this),
					_options;
				if (!$this.data('DateTimePicker')) {
					// create a private copy of the defaults object
					_options = $.extend(true, {}, $.fn.datetimepicker.defaults, options);
					$this.data('DateTimePicker', dateTimePicker($this, _options));
				}
			});
		} else if (typeof options === 'string') {
			this.each(function () {
				var $this = $(this),
					instance = $this.data('DateTimePicker');
				if (!instance) {
					throw new Error('bootstrap-datetimepicker("' + options + '") method was called on an element that is not using DateTimePicker');
				}

				returnValue = instance[options].apply(instance, args);
				isInstance = returnValue === instance;
			});

			if (isInstance || $.inArray(options, thisMethods) > -1) {
				return this;
			}

			return returnValue;
		}

		throw new TypeError('Invalid arguments for DateTimePicker: ' + options);
	};

	$.fn.datetimepicker.defaults = {
		timeZone: '',
		format: false,
		dayViewHeaderFormat: 'MMMM YYYY',
		extraFormats: false,
		stepping: 1,
		minDate: false,
		maxDate: false,
		useCurrent: true,
		collapse: true,
		locale: moment.locale(),
		defaultDate: false,
		disabledDates: false,
		enabledDates: false,
		icons: {
			time: 'glyphicon glyphicon-time',
			date: 'glyphicon glyphicon-calendar',
			up: 'glyphicon glyphicon-chevron-up',
			down: 'glyphicon glyphicon-chevron-down',
			previous: 'glyphicon glyphicon-chevron-left',
			next: 'glyphicon glyphicon-chevron-right',
			today: 'glyphicon glyphicon-screenshot',
			clear: 'glyphicon glyphicon-trash',
			close: 'glyphicon glyphicon-remove'
		},
		tooltips: {
			today: 'Go to today',
			clear: 'Clear selection',
			close: 'Close the picker',
			selectMonth: 'Select Month',
			prevMonth: 'Previous Month',
			nextMonth: 'Next Month',
			selectYear: 'Select Year',
			prevYear: 'Previous Year',
			nextYear: 'Next Year',
			selectDecade: 'Select Decade',
			prevDecade: 'Previous Decade',
			nextDecade: 'Next Decade',
			prevCentury: 'Previous Century',
			nextCentury: 'Next Century',
			pickHour: 'Pick Hour',
			incrementHour: 'Increment Hour',
			decrementHour: 'Decrement Hour',
			pickMinute: 'Pick Minute',
			incrementMinute: 'Increment Minute',
			decrementMinute: 'Decrement Minute',
			pickSecond: 'Pick Second',
			incrementSecond: 'Increment Second',
			decrementSecond: 'Decrement Second',
			togglePeriod: 'Toggle Period',
			selectTime: 'Select Time'
		},
		useStrict: false,
		sideBySide: false,
		daysOfWeekDisabled: false,
		calendarWeeks: false,
		viewMode: 'days',
		toolbarPlacement: 'default',
		showTodayButton: false,
		showClear: false,
		showClose: false,
		widgetPositioning: {
			horizontal: 'auto',
			vertical: 'auto'
		},
		widgetParent: null,
		ignoreReadonly: false,
		keepOpen: false,
		focusOnShow: true,
		inline: false,
		keepInvalid: false,
		datepickerInput: '.datepickerinput',
		keyBinds: {
			up: function (widget) {
				if (!widget) {
					return;
				}
				var d = this.date() || this.getMoment();
				if (widget.find('.datepicker').is(':visible')) {
					this.date(d.clone().subtract(7, 'd'));
				} else {
					this.date(d.clone().add(this.stepping(), 'm'));
				}
			},
			down: function (widget) {
				if (!widget) {
					this.show();
					return;
				}
				var d = this.date() || this.getMoment();
				if (widget.find('.datepicker').is(':visible')) {
					this.date(d.clone().add(7, 'd'));
				} else {
					this.date(d.clone().subtract(this.stepping(), 'm'));
				}
			},
			'control up': function (widget) {
				if (!widget) {
					return;
				}
				var d = this.date() || this.getMoment();
				if (widget.find('.datepicker').is(':visible')) {
					this.date(d.clone().subtract(1, 'y'));
				} else {
					this.date(d.clone().add(1, 'h'));
				}
			},
			'control down': function (widget) {
				if (!widget) {
					return;
				}
				var d = this.date() || this.getMoment();
				if (widget.find('.datepicker').is(':visible')) {
					this.date(d.clone().add(1, 'y'));
				} else {
					this.date(d.clone().subtract(1, 'h'));
				}
			},
			left: function (widget) {
				if (!widget) {
					return;
				}
				var d = this.date() || this.getMoment();
				if (widget.find('.datepicker').is(':visible')) {
					this.date(d.clone().subtract(1, 'd'));
				}
			},
			right: function (widget) {
				if (!widget) {
					return;
				}
				var d = this.date() || this.getMoment();
				if (widget.find('.datepicker').is(':visible')) {
					this.date(d.clone().add(1, 'd'));
				}
			},
			pageUp: function (widget) {
				if (!widget) {
					return;
				}
				var d = this.date() || this.getMoment();
				if (widget.find('.datepicker').is(':visible')) {
					this.date(d.clone().subtract(1, 'M'));
				}
			},
			pageDown: function (widget) {
				if (!widget) {
					return;
				}
				var d = this.date() || this.getMoment();
				if (widget.find('.datepicker').is(':visible')) {
					this.date(d.clone().add(1, 'M'));
				}
			},
			enter: function () {
				this.hide();
			},
			escape: function () {
				this.hide();
			},
			//tab: function (widget) { //this break the flow of the form. disabling for now
			//    var toggle = widget.find('.picker-switch a[data-action="togglePicker"]');
			//    if(toggle.length > 0) toggle.click();
			//},
			'control space': function (widget) {
				if (!widget) {
					return;
				}
				if (widget.find('.timepicker').is(':visible')) {
					widget.find('.btn[data-action="togglePeriod"]').click();
				}
			},
			t: function () {
				this.date(this.getMoment());
			},
			'delete': function () {
				this.clear();
			}
		},
		debug: false,
		allowInputToggle: false,
		disabledTimeIntervals: false,
		disabledHours: false,
		enabledHours: false,
		viewDate: false
	};

	return $.fn.datetimepicker;
}));

/***/ },

/***/ "../smapServer/WebContent/js/libs/wb/plugins/slimscroll/jquery.slimscroll.js"
/*!***********************************************************************************!*\
  !*** ../smapServer/WebContent/js/libs/wb/plugins/slimscroll/jquery.slimscroll.js ***!
  \***********************************************************************************/
() {

/*! Copyright (c) 2011 Piotr Rochala (http://rocha.la)
 * Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 * and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.
 *
 * Version: 1.3.6
 *
 */
(function($) {

  $.fn.extend({
    slimScroll: function(options) {

      var defaults = {

        // width in pixels of the visible scroll area
        width : 'auto',

        // height in pixels of the visible scroll area
        height : '250px',

        // width in pixels of the scrollbar and rail
        size : '7px',

        // scrollbar color, accepts any hex/color value
        color: '#000',

        // scrollbar position - left/right
        position : 'right',

        // distance in pixels between the side edge and the scrollbar
        distance : '1px',

        // default scroll position on load - top / bottom / $('selector')
        start : 'top',

        // sets scrollbar opacity
        opacity : .4,

        // enables always-on mode for the scrollbar
        alwaysVisible : false,

        // check if we should hide the scrollbar when user is hovering over
        disableFadeOut : false,

        // sets visibility of the rail
        railVisible : false,

        // sets rail color
        railColor : '#333',

        // sets rail opacity
        railOpacity : .2,

        // whether  we should use jQuery UI Draggable to enable bar dragging
        railDraggable : true,

        // defautlt CSS class of the slimscroll rail
        railClass : 'slimScrollRail',

        // defautlt CSS class of the slimscroll bar
        barClass : 'slimScrollBar',

        // defautlt CSS class of the slimscroll wrapper
        wrapperClass : 'slimScrollDiv',

        // check if mousewheel should scroll the window if we reach top/bottom
        allowPageScroll : false,

        // scroll amount applied to each mouse wheel step
        wheelStep : 20,

        // scroll amount applied when user is using gestures
        touchScrollStep : 200,

        // sets border radius
        borderRadius: '7px',

        // sets border radius of the rail
        railBorderRadius : '7px'
      };

      var o = $.extend(defaults, options);

      // do it for every element that matches selector
      this.each(function(){

        var isOverPanel, isOverBar, isDragg, queueHide, touchDif,
            barHeight, percentScroll, lastScroll,
            divS = '<div></div>',
            minBarHeight = 30,
            releaseScroll = false;

        // used in event handlers and for better minification
        var me = $(this);

        // ensure we are not binding it again
        if (me.parent().hasClass(o.wrapperClass))
        {
          // start from last bar position
          var offset = me.scrollTop();

          // find bar and rail
          bar = me.closest('.' + o.barClass);
          rail = me.closest('.' + o.railClass);

          getBarHeight();

          // check if we should scroll existing instance
          if ($.isPlainObject(options))
          {
            // Pass height: auto to an existing slimscroll object to force a resize after contents have changed
            if ( 'height' in options && options.height == 'auto' ) {
              me.parent().css('height', 'auto');
              me.css('height', 'auto');
              var height = me.parent().parent().height();
              me.parent().css('height', height);
              me.css('height', height);
            }

            if ('scrollTo' in options)
            {
              // jump to a static point
              offset = parseInt(o.scrollTo);
            }
            else if ('scrollBy' in options)
            {
              // jump by value pixels
              offset += parseInt(o.scrollBy);
            }
            else if ('destroy' in options)
            {
              // remove slimscroll elements
              bar.remove();
              rail.remove();
              me.unwrap();
              return;
            }

            // scroll content by the given offset
            scrollContent(offset, false, true);
          }

          return;
        }
        else if ($.isPlainObject(options))
        {
          if ('destroy' in options)
          {
            return;
          }
        }

        // optionally set height to the parent's height
        o.height = (o.height == 'auto') ? me.parent().height() : o.height;

        // wrap content
        var wrapper = $(divS)
            .addClass(o.wrapperClass)
            .css({
              position: 'relative',
              overflow: 'hidden',
              width: o.width,
              height: o.height
            });

        // update style for the div
        me.css({
          overflow: 'hidden',
          width: o.width,
          height: o.height
        });

        // create scrollbar rail
        var rail = $(divS)
            .addClass(o.railClass)
            .css({
              width: o.size,
              height: '100%',
              position: 'absolute',
              top: 0,
              display: (o.alwaysVisible && o.railVisible) ? 'block' : 'none',
              'border-radius': o.railBorderRadius,
              background: o.railColor,
              opacity: o.railOpacity,
              zIndex: 90
            });

        // create scrollbar
        var bar = $(divS)
            .addClass(o.barClass)
            .css({
              background: o.color,
              width: o.size,
              position: 'absolute',
              top: 0,
              opacity: o.opacity,
              display: o.alwaysVisible ? 'block' : 'none',
              'border-radius' : o.borderRadius,
              BorderRadius: o.borderRadius,
              MozBorderRadius: o.borderRadius,
              WebkitBorderRadius: o.borderRadius,
              zIndex: 99
            });

        // set position
        var posCss = (o.position == 'right') ? { right: o.distance } : { left: o.distance };
        rail.css(posCss);
        bar.css(posCss);

        // wrap it
        me.wrap(wrapper);

        // append to parent div
        me.parent().append(bar);
        me.parent().append(rail);

        // make it draggable and no longer dependent on the jqueryUI
        if (o.railDraggable){
          bar.bind("mousedown", function(e) {
            var $doc = $(document);
            isDragg = true;
            t = parseFloat(bar.css('top'));
            pageY = e.pageY;

            $doc.bind("mousemove.slimscroll", function(e){
              currTop = t + e.pageY - pageY;
              bar.css('top', currTop);
              scrollContent(0, bar.position().top, false);// scroll content
            });

            $doc.bind("mouseup.slimscroll", function(e) {
              isDragg = false;hideBar();
              $doc.unbind('.slimscroll');
            });
            return false;
          }).bind("selectstart.slimscroll", function(e){
            e.stopPropagation();
            e.preventDefault();
            return false;
          });
        }

        // on rail over
        rail.hover(function(){
          showBar();
        }, function(){
          hideBar();
        });

        // on bar over
        bar.hover(function(){
          isOverBar = true;
        }, function(){
          isOverBar = false;
        });

        // show on parent mouseover
        me.hover(function(){
          isOverPanel = true;
          showBar();
          hideBar();
        }, function(){
          isOverPanel = false;
          hideBar();
        });

        // support for mobile
        me.bind('touchstart', function(e,b){
          if (e.originalEvent.touches.length)
          {
            // record where touch started
            touchDif = e.originalEvent.touches[0].pageY;
          }
        });

        me.bind('touchmove', function(e){
          // prevent scrolling the page if necessary
          if(!releaseScroll)
          {
            e.originalEvent.preventDefault();
          }
          if (e.originalEvent.touches.length)
          {
            // see how far user swiped
            var diff = (touchDif - e.originalEvent.touches[0].pageY) / o.touchScrollStep;
            // scroll content
            scrollContent(diff, true);
            touchDif = e.originalEvent.touches[0].pageY;
          }
        });

        // set up initial height
        getBarHeight();

        // check start position
        if (o.start === 'bottom')
        {
          // scroll content to bottom
          bar.css({ top: me.outerHeight() - bar.outerHeight() });
          scrollContent(0, true);
        }
        else if (o.start !== 'top')
        {
          // assume jQuery selector
          scrollContent($(o.start).position().top, null, true);

          // make sure bar stays hidden
          if (!o.alwaysVisible) { bar.hide(); }
        }

        // attach scroll events
        attachWheel(this);

        function _onWheel(e)
        {
          // use mouse wheel only when mouse is over
          if (!isOverPanel) { return; }

          var e = e || window.event;

          var delta = 0;
          if (e.wheelDelta) { delta = -e.wheelDelta/120; }
          if (e.detail) { delta = e.detail / 3; }

          var target = e.target || e.srcTarget || e.srcElement;
          if ($(target).closest('.' + o.wrapperClass).is(me.parent())) {
            // scroll content
            scrollContent(delta, true);
          }

          // stop window scroll
          if (e.preventDefault && !releaseScroll) { e.preventDefault(); }
          if (!releaseScroll) { e.returnValue = false; }
        }

        function scrollContent(y, isWheel, isJump)
        {
          releaseScroll = false;
          var delta = y;
          var maxTop = me.outerHeight() - bar.outerHeight();

          if (isWheel)
          {
            // move bar with mouse wheel
            delta = parseInt(bar.css('top')) + y * parseInt(o.wheelStep) / 100 * bar.outerHeight();

            // move bar, make sure it doesn't go out
            delta = Math.min(Math.max(delta, 0), maxTop);

            // if scrolling down, make sure a fractional change to the
            // scroll position isn't rounded away when the scrollbar's CSS is set
            // this flooring of delta would happened automatically when
            // bar.css is set below, but we floor here for clarity
            delta = (y > 0) ? Math.ceil(delta) : Math.floor(delta);

            // scroll the scrollbar
            bar.css({ top: delta + 'px' });
          }

          // calculate actual scroll amount
          percentScroll = parseInt(bar.css('top')) / (me.outerHeight() - bar.outerHeight());
          delta = percentScroll * (me[0].scrollHeight - me.outerHeight());

          if (isJump)
          {
            delta = y;
            var offsetTop = delta / me[0].scrollHeight * me.outerHeight();
            offsetTop = Math.min(Math.max(offsetTop, 0), maxTop);
            bar.css({ top: offsetTop + 'px' });
          }

          // scroll content
          me.scrollTop(delta);

          // fire scrolling event
          me.trigger('slimscrolling', ~~delta);

          // ensure bar is visible
          showBar();

          // trigger hide when scroll is stopped
          hideBar();
        }

        function attachWheel(target)
        {
          if (window.addEventListener)
          {
            target.addEventListener('DOMMouseScroll', _onWheel, false );
            target.addEventListener('mousewheel', _onWheel, false );
          }
          else
          {
            document.attachEvent("onmousewheel", _onWheel)
          }
        }

        function getBarHeight()
        {
          // calculate scrollbar height and make sure it is not too small
          barHeight = Math.max((me.outerHeight() / me[0].scrollHeight) * me.outerHeight(), minBarHeight);
          bar.css({ height: barHeight + 'px' });

          // hide scrollbar if content is not long enough
          var display = barHeight == me.outerHeight() ? 'none' : 'block';
          bar.css({ display: display });
        }

        function showBar()
        {
          // recalculate bar height
          getBarHeight();
          clearTimeout(queueHide);

          // when bar reached top or bottom
          if (percentScroll == ~~percentScroll)
          {
            //release wheel
            releaseScroll = o.allowPageScroll;

            // publish approporiate event
            if (lastScroll != percentScroll)
            {
              var msg = (~~percentScroll == 0) ? 'top' : 'bottom';
              me.trigger('slimscroll', msg);
            }
          }
          else
          {
            releaseScroll = false;
          }
          lastScroll = percentScroll;

          // show only when required
          if(barHeight >= me.outerHeight()) {
            //allow window scroll
            releaseScroll = true;
            return;
          }
          bar.stop(true,true).fadeIn('fast');
          if (o.railVisible) { rail.stop(true,true).fadeIn('fast'); }
        }

        function hideBar()
        {
          // only hide when options allow it
          if (!o.alwaysVisible)
          {
            queueHide = setTimeout(function(){
              if (!(o.disableFadeOut && isOverPanel) && !isOverBar && !isDragg)
              {
                bar.fadeOut('slow');
                rail.fadeOut('slow');
              }
            }, 1000);
          }
        }

      });

      // maintain chainability
      return this;
    }
  });

  $.fn.extend({
    slimscroll: $.fn.slimScroll
  });

})(jQuery);

/***/ },

/***/ "./WebContent/js/settings_main.js"
/*!****************************************!*\
  !*** ./WebContent/js/settings_main.js ***!
  \****************************************/
() {


/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Purpose: Manage the panels that display graphs, maps etc of results data
 */



const $ = window.$;
const localise = window.localise;
const globals = window.globals;
const moment = window.moment;


	var
		gGroups,
		gSmsType,
		gPanel,
		gCssFile,
		gCssOrgFile,
		gCssModal,
		gResetWebformPressed = false,
		page = 'settings',
		gNumbers;

	$(document).ready(function() {

		setCustomUserMgmt();			// Apply custom javascript

		setTheme();
		localise.setlang();		// Localise HTML
		setupUserProfile(true);
		window.moment = moment;		// Make moment global for use by common.js
		enableDebugging();

		getSmsType();
		getLoggedInUser(userKnown, false, false, undefined, false,
			false, undefined, getServerDetails, undefined);
		getDeviceSettings();
		getEmailSettings();
		getWebformSettings();
		getAppearanceSettings();
		getSensitiveSettings();
		getOtherSettings();		// miscellaneous settings

		// Set up the tabs
		$('#appearanceTab a').on('click', function (e) {
			e.preventDefault();
			panelChange($(this), 'appearance');
		});
		$('#serverTab a').on('click',function (e) {
			e.preventDefault();
			panelChange($(this), 'server');
		});
		$('#deviceTab a').on('click',function (e) {
			e.preventDefault();
			panelChange($(this), 'device');
		});
		$('#webformTab a').on('click',function (e) {
			e.preventDefault();
			panelChange($(this), 'webform');
		});
		$('#sensitiveTab a').on('click',function (e) {
			e.preventDefault();
			panelChange($(this), 'sensitive');
		});
		$('#caseManagementTab a').on('click',function (e) {
			e.preventDefault();
			panelChange($(this), 'caseManagement');
		});
		$('#emailTab a').on('click',function (e) {
			e.preventDefault();
			panelChange($(this), 'email');
		});
		$('#otherTab a').on('click',function (e) {
			e.preventDefault();
			panelChange($(this), 'other');
		});

		// Copy user ident to email if it is a valid email
		$('#user_ident').blur(function(){
			var ident = $('#user_ident').val();

			if(validateEmails(ident)) {
				$('#user_email').val(ident);
			}

		});

		/*
		 * Setting organisation theme
		 */
		$('#change_banner_logo').change(function(){
			displayAsImage($(this)[0].files[0], $('#o_banner_logo')[0]);
		});
		$('#change_main_logo').change(function(){
			displayAsImage($(this)[0].files[0], $('#o_main_logo')[0]);
		});

		// Function to save server details
		$('#saveServer').click(function(e) {
			e.preventDefault();
			writeServerDetails();
		});

		/*
		 * Set focus to first element on opening modals
		 */
		$('.modal').on('shown.bs.modal', function() {
			$(this).find('input[type=text],textarea,select').filter(':visible:first').focus();
		});

		$('#saveSensitive').click(function() {

			var sensitiveObj = {
				signature: $('#sens_sig').val()
			};

			var sensitiveString = JSON.stringify(sensitiveObj);
			addHourglass();
			$.ajax({
				type: "POST",
				contentType: "application/x-www-form-urlencoded",
				cache: false,
				url: "/surveyKPI/organisationList/sensitive",
				data: { sensitive: sensitiveString },
				success: function(data, status) {
					removeHourglass();
					getSensitiveSettings();
					$('.org_alert').show().removeClass('alert-danger').addClass('alert-success').html(localise.set["msg_upd"]);
				},
				error: function(xhr, textStatus, err) {
					removeHourglass();

					if(xhr.readyState == 0 || xhr.status == 0) {
						$('.org_alert').show().removeClass('alert-danger').addClass('alert-success').html(localise.set["msg_upd"]);
						return;  // Not an error
					} else {
						var msg = xhr.responseText;
						alert(localise.set["msg_err_upd"] + msg);  // Alerts htmlencode text already
					}
				}
			});
		});

		$('#saveOtherSettings').click(function() {

			var otherObj = {
				password_strength: $('#o_p_strength').val()
			};

			var otherString = JSON.stringify(otherObj);
			addHourglass();
			$.ajax({
				type: "POST",
				contentType: "application/x-www-form-urlencoded",
				cache: false,
				url: "/surveyKPI/organisationList/other",
				data: { other: otherString },
				success: function(data, status) {
					removeHourglass();
					getOtherSettings();
					$('.org_alert').show().removeClass('alert-danger').addClass('alert-success').html(localise.set["msg_upd"]);
				},
				error: function(xhr, textStatus, err) {
					removeHourglass();

					if(xhr.readyState == 0 || xhr.status == 0) {
						$('.org_alert').show().removeClass('alert-danger').addClass('alert-success').html(localise.set["msg_upd"]);
						return;  // Not an error
					} else {
						var msg = xhr.responseText;
						alert(localise.set["msg_err_upd"] + msg);    // Alerts htmlencode text already
					}
				}
			});
		});

		/*
 		 * Respond to change on password profile combo
 		 */
		$('#s_email_type').change(function() {
			emailServerTypeChanged();
		});

		/*
		 * Respond to change on password profile combo
		 */
		$('#ft_login_policy1').change(function() {
			if($(this).val() === 'periodic') {
				$('.pw_timeout').removeClass("d-none").show();
			} else {
				$('.pw_timeout').hide();
			}
		});

		/*
		 * Respond to change on GeoPoly input method
		 */
		$('#ft_input_method').change(function() {
			if($(this).val() === 'auto') {
				$('.u_ft_im_auto').removeClass("d-none").show();
			} else {
				$('.u_ft_im_auto').hide();
			}
		});

		/*
		 * Save the device options
		 */
		$('#saveDevice').click(function() {
			var device = {},
				error = false,
				options=[],
				i;

			device.ft_send_location = $('#ft_send_location').val();
			device.ft_input_method = $('#ft_input_method').val();
			device.ft_im_ri = $('#ft_im_ri').val();
			device.ft_im_acc = $('#ft_im_acc').val();
			device.ft_send = $('#ft_send').val();
			device.ft_delete = $('#ft_delete').val();
			device.ft_backward_navigation = $('#ft_backward_navigation').val();
			device.ft_high_res_video = $('#ft_high_res_video').val();
			device.ft_navigation = $('#ft_navigation').val();
			device.ft_guidance = $('#ft_guidance').val();
			device.ft_image_size = $('#ft_image_size').val();

			device.ft_number_tasks = $('#ft_number_tasks').val();
			if(typeof device.ft_number_tasks === "undefined" || device.ft_number_tasks == '') {
				device.ft_number_tasks = 20;
			}

			var pw_policy1 = $('#ft_login_policy1').val();
			if(pw_policy1 === 'never') {
				device.ft_pw_policy = -1;
			} else if(pw_policy1 === 'always') {
				device.ft_pw_policy = 0;
			} else {
				device.ft_pw_policy = parseInt($('#ft_login_policy2').val());
				if(!Number.isInteger(device.ft_pw_policy) || device.ft_pw_policy <= 0) {
					alert(localise.set["msg_pe"]);
					return false;
				}
			}

			options = $(".devoption:checked").map(function(){
				return $(this).val();
			}).toArray();

			for(i = 0; i < options.length; i++) {
				if(options[i] === "ft_odk_style_menus") {
					device.ft_odk_style_menus = true;
				} else if(options[i] === "ft_specify_instancename") {
					device.ft_specify_instancename = true;
				} else if(options[i] === "ft_mark_finalized") {
					device.ft_mark_finalized = true;
				} else if(options[i] === "ft_prevent_disable_track") {
					device.ft_prevent_disable_track = true;
				}  else if(options[i] === "ft_enable_geofence") {
					device.ft_enable_geofence = true;
				} else if(options[i] === "ft_admin_menu") {
					device.ft_admin_menu = true;
				} else if(options[i] === "ft_server_menu") {
					device.ft_server_menu = true;
				} else if(options[i] === "ft_meta_menu") {
					device.ft_meta_menu = true;
				} else if(options[i] === "ft_exit_track_menu") {
					device.ft_exit_track_menu = true;
				} else if(options[i] === "ft_bg_stop_menu") {
					device.ft_bg_stop_menu = true;
				} else if(options[i] === "ft_review_final") {
					device.ft_review_final = true;
				} else if(options[i] === "ft_force_token") {
					device.ft_force_token = true;
				}
			}

			var deviceString = JSON.stringify(device);

			$('.org_alert').hide();
			addHourglass();
			$.ajax({
				type: 'POST',
				data: {settings: deviceString},
				cache: false,
				contentType: "application/x-www-form-urlencoded",
				url: "/surveyKPI/organisationList/device",
				success: function(data) {
					removeHourglass();
					if(handleLogout(data)) {
						$('.org_alert').show().removeClass('alert-danger').addClass('alert-success').html(localise.set["msg_upd"]);
						getDeviceSettings();
					}
				}, error: function(xhr, textStatus, err) {
					removeHourglass();
					if(xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						var msg = err;
						$('.org_alert').show().removeClass('alert-success').addClass('alert-danger').html(localise.set["msg_err_upd"] + htmlEncode(xhr.responseText));
					}
				}
			});

		});

		/*
         * Save the email options
         */
		$('#saveEmailSettings').click(function() {
			var email = {},
				error = false;

			email.admin_email = $('#o_admin_email').val();
			email.smtp_host = $('#o_smtp_host').val();
			email.email_domain = $('#o_email_domain').val();

			var eu = $('#o_email_user').val();      // avoid autofill
			if(eu === '-') {
				eu = undefined;
			}
			email.email_user = eu;

			email.email_password = $('#o_email_password').val();
			email.email_port = parseInt($('#o_email_port').val());
			email.default_email_content = $('#o_default_email_content').val();
			email.server_description = $('#o_server_description').val();

			var emailString = JSON.stringify(email);

			$('.org_alert').hide();
			addHourglass();
			$.ajax({
				type: 'POST',
				data: {settings: emailString},
				cache: false,
				contentType: "application/x-www-form-urlencoded",
				url: "/surveyKPI/organisationList/email",
				success: function(data, status) {
					removeHourglass();
					$('.org_alert').show().removeClass('alert-danger').addClass('alert-success').html(localise.set["msg_upd"]);
					getEmailSettings();
				}, error: function(xhr, textStatus, err) {
					removeHourglass();
					if(xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						var msg = err;
						$('.org_alert').show().removeClass('alert-success').addClass('alert-danger').html(localise.set["msg_err_upd"] + htmlEncode(xhr.responseText));
					}
				}
			});

		});

		/*
		 * Reset the webform options back to their defaults
		 */
		$('#resetWebform').click(function() {
			$('#wf_page_background').colorpicker('setValue', '#f0f0f0');
			$('#wf_paper_background').colorpicker('setValue', '#fff');
			$('#wf_footer_horizontal_offset').val(5);
			$('#wf_button_background_color').colorpicker('setValue', '#556B2F');
			$('#wf_button_text_color').colorpicker('setValue', '#fff');
			$('#wf_header_text_color').colorpicker('setValue', '#004200');
			$('#o_banner_logo').attr("src", "/images/smap_logo.png");
			$('.wfoption').each(function() {
				this.checked = false;
			});
			gResetWebformPressed = true;
		});

		/*
         * Save the webform options
         */
		$('#saveWebform').click(function() {
			var webform = {},
				error = false,
				options=[],
				i;

			webform.page_background_color = $('#wf_page_background').val();
			webform.button_background_color = $('#wf_button_background_color').val();
			webform.button_text_color = $('#wf_button_text_color').val();
			webform.header_text_color = $('#wf_header_text_color').val();
			webform.paper_background_color = $('#wf_paper_background').val();
			webform.footer_horizontal_offset = $('#wf_footer_horizontal_offset').val();
			webform.footer_horizontal_offset = webform.footer_horizontal_offset || 0;
			webform.resetPressed = gResetWebformPressed;

			var options = $(".wfoption:checked").map(function(){
				return $(this).val();
			}).toArray();

			for(i = 0; i < options.length; i++) {
				if(options[i] === "wf_hide_draft") {
					webform.wf_hide_draft = true;
				}
			}

			var webformString = JSON.stringify(webform);

			$('#webformSettings').val(webformString);
			var f = document.forms.namedItem("webformsave");
			var formData = new FormData(f);

			$('.org_alert').hide();
			addHourglass();
			$.ajax({
				type: 'POST',
				data: formData,
				cache: false,
				contentType: false,
				processData:false,
				url: "/surveyKPI/organisationList/webform",
				success: function(data, status) {
					removeHourglass();
					$('.org_alert').show().removeClass('alert-danger').addClass('alert-success').html(localise.set["msg_upd"]);
				}, error: function(xhr, textStatus, err) {
					removeHourglass();
					if(xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						var msg = err;
						$('.org_alert').show().removeClass('alert-success').addClass('alert-danger').html(localise.set["msg_err_upd"] + htmlEncode(xhr.responseText));
					}
				}
			});

		});

		/*
         * Save the appearance options
         */
		$('#saveAppearance').click(function() {
			var appearance = {
				set_as_theme: $('#app_set_as_theme').prop('checked'),
				navbar_color: $('#app_navbar_color').val(),
				navbar_text_color: $('#app_navbar_text_color').val(),
				css: $('#cssSelectOrg').val()
			};

			var appearanceString = JSON.stringify(appearance);

			$('#appearanceSettings').val(appearanceString);
			var f = document.forms.namedItem("appearancesave");
			var formData = new FormData(f);

			$('.org_alert').hide();
			addHourglass();
			$.ajax({
				type: 'POST',
				data: formData,
				cache: false,
				contentType: false,
				processData:false,
				url: "/surveyKPI/organisationList/appearance",
				success: function(data, status) {
					removeHourglass();
					gCssOrgFile = $('#cssSelectOrg').val();
					$('.my_org_alert').show().removeClass('alert-danger').addClass('alert-success').html(localise.set["msg_upd"]);
				}, error: function(xhr, textStatus, err) {
					removeHourglass();
					if(xhr.readyState == 0 || xhr.status == 0) {
						return;  // Not an error
					} else {
						var msg = err;
						$('.my_org_alert').show().removeClass('alert-success').addClass('alert-danger').html(localise.set["msg_err_upd"] + htmlEncode(xhr.responseText));
					}
				}
			});

		});
		// Disable style delete if style is set to none
		cssSelectChange();
		$('#cssSelect').change(function() {
			cssSelectChange();
		});
		cssSelectOrgChange();
		$('#cssSelectOrg').change(function() {
			cssSelectOrgChange();
		});

		/*
		 * Set up colour picker
		 */
		$('.colorpicker-component').colorpicker({
			format: 'hex'
		});

		$('input').focus(function() {
			$('.org_alert').hide();
		});

		// Set page defaults
		var currentTab = getFromLocalStorage("currentTab" + page);
		if(currentTab) {
			$(currentTab).trigger('click');
		}

		/*
         * Support deletion of a css file
         */
		$('#deleteCss').click(function() {
			deleteCss();
		});
		$('#deleteCssOrg').click(function() {
			deleteCss(globals.gOrgId);
		});

		/*
		 * Support uploading of a css file
		 */
		$('#uploadCss').click(function() {
			$('#cssUpload').val("");
			$('.load_file_alert').hide();
			gCssModal = "server";
			$('#upload_css_popup').modal("show");
		});

		$('#uploadCssOrg').click(function() {
			$('#cssUploadOrg').val("");
			$('.load_file_alert').hide();
			gCssModal = "org";
			$('#upload_css_popup_org').modal("show");
		});

		$('#cssSave, #cssSaveOrg').click(function(){
			let url = "/surveyKPI/css";
			let f;

			if(gCssModal === "server") {
				f = document.forms.namedItem("upload_css_form");
			} else {
				f = document.forms.namedItem("upload_css_form_org");
				url += "?org=true";
			}

			var formData = new FormData(f);
			addHourglass();
			$.ajax({
				type: "POST",
				data: formData,
				cache: false,
				contentType: false,
				processData:false,
				url: url,
				success: function(data, status) {
					removeHourglass();
					if(handleLogout(data)) {
						if (gCssModal === "server") {
							getCustomCss();
						} else {
							getCustomCssOrg();
						}
						$('#upload_css_popup, #upload_css_popup_org').modal("hide");
					}
				},
				error: function(xhr, textStatus, err) {
					removeHourglass();
					var msg = htmlEncode(xhr.responseText);
					if(handleLogout(msg)) {
						if (msg && msg === "only csv") {
							msg = localise.set["t_efnl"] + " " + localise.set["msg_csv"];
						} else {
							msg = localise.set["t_efnl"] + " " + htmlEncode(xhr.responseText);
						}

						$('.load_file_alert').show().removeClass('alert-success').addClass('alert-danger').html(msg);
					}
				}
			});
		});

	});



	function deleteCss(org) {
		var url = "/surveyKPI/css/";
		if(org) {
			url += encodeURIComponent($('#cssSelectOrg').val());
			url += "?org=true";
		} else {
			url += encodeURIComponent($('#cssSelect').val());
		}

		addHourglass();
		$.ajax({
			type: "DELETE",
			cache: false,
			url: url,
			success: function(data, status) {
				removeHourglass();
				if(org) {
					getCustomCssOrg();
				} else {
					getCustomCss();
				}
				$('.org_alert, .my_org_alert').show().removeClass('alert-danger').addClass('alert-success').html(localise.set["c_success"]);
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				var msg = htmlEncode(xhr.responseText);
				if(msg && msg === "only csv") {
					msg = localise.set["t_efnl"] + " " + localise.set["msg_csv"];
				} else {
					msg = localise.set["t_efnl"] + " " + htmlEncode(xhr.responseText);
				}

				$('.org_alert,.my_org_alert').show().removeClass('alert-success').addClass('alert-danger').html(msg);

			}
		});
	}

	/*
	 * Respond to change of cssSelect
	 */
	function cssSelectChange() {
		let val = $('#cssSelect').val();
		if(val === "_none") {
			$('#deleteCss').prop("disabled", true);
		} else {
			$('#deleteCss').prop("disabled", false);
		}
	}

	function cssSelectOrgChange() {
		let val = $('#cssSelectOrg').val();
		if(val === "_none") {
			$('#deleteCssOrg').prop("disabled", true);
		} else {
			$('#deleteCssOrg').prop("disabled", false);
		}
	}

	/*
	 * Respond to a panel being changed
	 * panelChange($(this), 'userPanel', 'usersTab');
	 */
	function panelChange($this, name) {
		gPanel = name;

		$('.org_alert').hide();
		$this.tab('show');

		$(".usertab").hide();
		$('.panel' + name).show();
		$('#' + name + 'Panel').show();
		setInLocalStorage("currentTab" + page, '#' + name + 'Tab a');

	}

	function userKnown() {
		getGroups();
		if(globals.gIsServerOwner) {
			getCustomCss();
		}
		getCustomCssOrg();
		setLogos(globals.gOrgId);
	}

	function getServerDetails() {
		// Get the server details
		addHourglass();
		$.ajax({
			url: "/surveyKPI/server",
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				updateServerData(data);
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	function emailServerTypeChanged() {
		var emailType = $('#s_email_type').val();
		if(emailType === 'smtp') {
			$('.smtp').show();
			$('.awssdk').hide();
		} else {
			$('.smtp').hide();
			$('.awssdk').show();
		}
	}
	function getSmsType() {
		// Get the server details
		addHourglass();
		$.ajax({
			url: "/surveyKPI/server/sms",
			cache: false,
			success: function(data) {
				removeHourglass();
				gSmsType = data;
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	/*
	 * Populate the server tab
	 */
	function updateServerData(data) {
		$('#mapbox_key').val(data.mapbox_default);
		$('#google_key').val(data.google_key);
		$('#maptiler_key').val(data.maptiler_key);
		$('#vonage_application_id').val(data.vonage_application_id);
		$('#vonage_webhook_secret').val(data.vonage_webhook_secret);
		$('#s_email_type').val(data.email_type);
		$('#s_smtp_host').val(data.smtp_host);
		$('#s_aws_region').val(data.aws_region);
		$('#s_email_domain').val(data.email_domain);
		$('#s_email_user').val(data.email_user);
		$('#s_email_password').val(data.email_password);
		$('#s_email_port').val(data.email_port);
		$('#s_sms_url').val(data.sms_url);
		$('#s_ratelimit').val(data.ratelimit);
		$('#s_p_strength').val(data.password_strength);
		$('#s_sec_mgr_del').prop('checked', data.sec_mgr_del);
		gCssFile = data.css;

		emailServerTypeChanged();
	}

	/*
	 * Update the server with the server config
	 */
	function writeServerDetails() {

		var url = "/surveyKPI/server",
			server = {
				mapbox_default: $('#mapbox_key').val(),
				google_key: $('#google_key').val(),
				maptiler_key: $('#maptiler_key').val(),
				vonage_application_id: $('#vonage_application_id').val(),
				vonage_webhook_secret: $('#vonage_webhook_secret').val(),
				email_type: $('#s_email_type').val(),
				smtp_host: $('#s_smtp_host').val(),
				aws_region: $('#s_aws_region').val(),
				email_domain: $('#s_email_domain').val(),
				email_user: $('#s_email_user').val(),
				email_password: $('#s_email_password').val(),
				email_port: $('#s_email_port').val(),
				sms_url: $('#s_sms_url').val(),
				ratelimit: $('#s_ratelimit').val(),
				password_strength: $('#s_p_strength').val(),
				sec_mgr_del: $('#s_sec_mgr_del').prop('checked'),
				css: $('#cssSelect').val()
			};

		var serverString = JSON.stringify(server);

		$('.org_alert').hide();
		addHourglass();
		$.ajax({
			type: "POST",
			data: {settings: serverString},
			cache: false,
			contentType: "application/x-www-form-urlencoded",
			url: url,
			success: function (data) {
				removeHourglass();
				if(handleLogout(data)) {
					gCssFile = $('#cssSelect').val();
					$('.org_alert').show().removeClass('alert-danger').addClass('alert-success').html(localise.set["c_saved"]);
				}
			},
			error: function (xhr, textStatus, err) {
				removeHourglass();
				$('.org_alert').show().removeClass('alert-success').addClass('alert-danger').html(localise.set["t_ens"] + htmlEncode(xhr.responseText));

			}
		});
	}

	/*
	 * Get the list of available groups from the server
	 */
	function getGroups() {
		addHourglass();
		$.ajax({
			url: "/surveyKPI/groupList",
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				gGroups = data;
				updateGroupTable();
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	/*
	 * Update the group table with the current group list
	 */
	function updateGroupTable() {
		var $groupSelect = $('#group_name'),
			i,
			h = [],
			idx = -1;

		h[++idx] = '<option value="All">' + localise.set["c_all"] + '</option>';
		for(i = 0; i < gGroups.length; i++) {
			if((gGroups[i].id != globals.GROUP_ORG_ADMIN || globals.gIsOrgAdministrator) &&
				(gGroups[i].id != globals.GROUP_SECURITY || globals.gIsSecurityAdministrator || globals.gIsOrgAdministrator) &&
				(gGroups[i].id != globals.GROUP_ENTERPRISE || globals.gIsEnterpriseAdministrator) &&
				gGroups[i].id != globals.GROUP_OWNER
			) {
				h[++idx] = '<option value="';
				h[++idx] = gGroups[i].name;
				h[++idx] = '">';
				h[++idx] = localise.set[gGroups[i].name];
				h[++idx] = '</option>';
			}
		}
		$groupSelect.empty().append(h.join(''));
		$groupSelect.val("All");
	}

	/*
	 * Get the device settings
	 */
	function getDeviceSettings() {

		addHourglass();
		$.ajax({
			url: "/surveyKPI/organisationList/device",
			dataType: 'json',
			cache: false,
			success: function(device) {
				removeHourglass();

				if(handleLogout(device)) {
					$('.devoption').each(function () {
						if ($(this).val() === "ft_odk_style_menus") {
							this.checked = device.ft_odk_style_menus;
						} else if ($(this).val() === "ft_specify_instancename") {
							this.checked = device.ft_specify_instancename;
						} else if ($(this).val() === "ft_mark_finalized") {
							this.checked = device.ft_mark_finalized;
						} else if ($(this).val() === "ft_prevent_disable_track") {
							this.checked = device.ft_prevent_disable_track;
						} else if ($(this).val() === "ft_enable_geofence") {
							this.checked = device.ft_enable_geofence;
						} else if ($(this).val() === "ft_admin_menu") {
							this.checked = device.ft_admin_menu;
						} else if ($(this).val() === "ft_server_menu") {
							this.checked = device.ft_server_menu;
						} else if ($(this).val() === "ft_meta_menu") {
							this.checked = device.ft_meta_menu;
						} else if ($(this).val() === "ft_exit_track_menu") {
							this.checked = device.ft_exit_track_menu;
						} else if ($(this).val() === "ft_bg_stop_menu") {
							this.checked = device.ft_bg_stop_menu;
						} else if ($(this).val() === "ft_review_final") {
							this.checked = device.ft_review_final;
						} else if ($(this).val() === "ft_force_token") {
							this.checked = device.ft_force_token;
						}
					});

					$('#ft_send').val(device.ft_send);
					$('#ft_send_location').val(device.ft_send_location);
					$('#ft_input_method').val(device.ft_input_method);
					$('#ft_im_ri').val(device.ft_im_ri);
					$('#ft_im_acc').val(device.ft_im_acc);
					$('#ft_delete').val(device.ft_delete);
					$('#ft_backward_navigation').val(device.ft_backward_navigation);
					$('#ft_high_res_video').val(device.ft_high_res_video);
					$('#ft_navigation').val(device.ft_navigation);
					$('#ft_guidance').val(device.ft_guidance);
					$('#ft_image_size').val(device.ft_image_size);
					$('#ft_number_tasks').val(device.ft_number_tasks);

					if (device.ft_pw_policy > 0) {
						$('#ft_login_policy1').val("periodic");
						$('#ft_login_policy2').val(device.ft_pw_policy);
						$('.pw_timeout').removeClass("d-none").show();
					} else {
						if (device.ft_pw_policy < 0) {
							$('#ft_login_policy1').val("never");
						} else {
							$('#ft_login_policy1').val("always");       // policy == 0
						}
						$('.pw_timeout').hide();
					}

					if (device.ft_input_method === 'auto') {
						$('.u_ft_im_auto').removeClass("d-none").show();
					}
				}
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	/*
     * Get the device settings
     */
	function getEmailSettings() {

		addHourglass();
		$.ajax({
			url: "/surveyKPI/organisationList/email",
			dataType: 'json',
			cache: false,
			success: function(org) {
				removeHourglass();

				$('#o_admin_email').val(org.admin_email);
				$('#o_smtp_host').val(org.smtp_host);
				$('#o_email_domain').val(org.email_domain);

				if(typeof org.email_user === "undefined" || org.email_user.trim() === '') {
					$('#o_email_user').val('-');
				} else {
					$('#o_email_user').val(org.email_user);
				}
				$('#o_email_password').val(org.email_password);
				$('#o_email_port').val(org.email_port);
				$('#o_default_email_content').val(org.default_email_content);
				$('#o_server_description').val(org.server_description);
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	/*
     * Get the webform settings that can be modified by an administrator settings
     */
	function getWebformSettings() {

		addHourglass();
		$.ajax({
			url: "/surveyKPI/organisationList/webform",
			dataType: 'json',
			cache: false,
			success: function(webform) {
				removeHourglass();

				$('.wfoption').each(function() {
					if($(this).val() === "wf_hide_draft") {
						this.checked = webform.wf_hide_draft;
					}
				});

				if(webform.page_background_color) {
					$('#wf_page_background').colorpicker('setValue', webform.page_background_color);
				} else {
					$('#wf_page_background').colorpicker('setValue', '#f0f0f0');
				}

				if(webform.paper_background_color) {
					$('#wf_paper_background').colorpicker('setValue', webform.paper_background_color);
				} else {
					$('#wf_paper_background').colorpicker('setValue', '#fff');
				}

				if(webform.button_background_color) {
					$('#wf_button_background_color').colorpicker('setValue', webform.button_background_color);
				} else {
					$('#wf_button_background_color').colorpicker('setValue', '#556B2F');
				}
				if(webform.button_text_color) {
					$('#wf_button_text_color').colorpicker('setValue', webform.button_text_color);
				} else {
					$('#wf_button_text_color').colorpicker('setValue', '#fff');
				}
				if(webform.header_text_color) {
					$('#wf_header_text_color').colorpicker('setValue', webform.header_text_color);
				} else {
					$('#wf_header_text_color').colorpicker('setValue', '#004200');
				}

				$('#wf_footer_horizontal_offset').val(webform.footer_horizontal_offset);

			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	/*
     * Get the appearance settings that can be modified by an administrator settings
     */
	function getAppearanceSettings() {

		addHourglass();
		$.ajax({
			url: "/surveyKPI/organisationList/appearance",
			dataType: 'json',
			cache: false,
			success: function(appearance) {
				removeHourglass();

				$('#app_set_as_theme').prop('checked', appearance.set_as_theme);
				$('#app_navbar_color').colorpicker('setValue', appearance.navbar_color);
				$('#app_navbar_text_color').colorpicker('setValue', appearance.navbar_text_color);
				$('#cssSelectOrg').val(appearance.css);
				gCssOrgFile = appearance.css;

			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	/*
	 * Get the sensitive question settings
	 */
	function getSensitiveSettings() {

		addHourglass();
		$.ajax({
			url: "/surveyKPI/organisationList/sensitive",
			dataType: 'json',
			cache: false,
			success: function(sensitive) {
				removeHourglass();
				$('#sens_sig').val(sensitive.signature);

			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	/*
 * Get the sensitive question settings
 */
	function getOtherSettings() {

		addHourglass();
		$.ajax({
			url: "/surveyKPI/organisationList/other",
			dataType: 'json',
			cache: false,
			success: function(other) {
				removeHourglass();
				$('#o_p_strength').val(other.password_strength);

			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	/*
	 * Get the available custom css files
	 */
	function getCustomCss() {
		addHourglass();
		$.ajax({
			url: "/surveyKPI/css",
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				showCssNames(data);
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	/*
     * Get the available custom css files for an organisation
     */
	function getCustomCssOrg() {
		addHourglass();
		$.ajax({
			url: "/surveyKPI/css?org=true",
			dataType: 'json',
			cache: false,
			success: function(data) {
				removeHourglass();
				showCssOrgNames(data);
			},
			error: function(xhr, textStatus, err) {
				removeHourglass();
				if(xhr.readyState == 0 || xhr.status == 0) {
					return;  // Not an error
				} else {
					alert(localise.set["c_error"] + ": " + err);
				}
			}
		});
	}

	function showCssNames(names) {
		let $elem = $('#cssSelect'),
			h = [],
			idx = -1;

		h[++idx] = '<option value="_none">';
		h[++idx] = localise.set["c_none"];
		h[++idx] = '</option>';

		if(names && names.length > 0) {
			for (let i = 0; i < names.length; i++) {
				h[++idx] = '<option value="';
				h[++idx] = names[i]
				h[++idx] = '">';
				h[++idx] = names[i];
				h[++idx] = '</option>';
			}
		}
		$elem.html(h.join(''));
		if(!gCssFile || gCssFile === '') {
			gCssFile = '_none';
		}
		$elem.val(gCssFile);
		cssSelectChange();

	}

	function showCssOrgNames(names) {
		let $elem = $('#cssSelectOrg'),
			h = [],
			idx = -1;

		h[++idx] = '<option value="_none">';
		h[++idx] = localise.set["c_none"];
		h[++idx] = '</option>';

		if(names && names.length > 0) {
			for (let i = 0; i < names.length; i++) {
				h[++idx] = '<option value="';
				h[++idx] = names[i]
				h[++idx] = '">';
				h[++idx] = htmlEncode(names[i]);
				h[++idx] = '</option>';
			}
		}
		$elem.html(h.join(''));
		if(!gCssOrgFile || gCssOrgFile === '') {
			gCssOrgFile = '_none';
		}
		$elem.val(gCssOrgFile);
		cssSelectOrgChange();

	}

	function setLogos(orgId) {
		var d = new Date();
		$('#o_banner_logo').attr("src", "/surveyKPI/file/bannerLogo/organisation?settings=true&org=" + orgId + "&" + d.valueOf());
		$('#o_main_logo').attr("src", "/surveyKPI/file/mainLogo/organisation?settings=true&org=" + orgId + "&" + d.valueOf());
	}



/***/ },

/***/ "jquery"
/*!*************************!*\
  !*** external "jQuery" ***!
  \*************************/
(module) {


module.exports = jQuery;

/***/ },

/***/ "moment"
/*!*************************!*\
  !*** external "moment" ***!
  \*************************/
(module) {


module.exports = moment;

/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/create fake namespace object */
/******/ 	(() => {
/******/ 		var getProto = Object.getPrototypeOf ? (obj) => (Object.getPrototypeOf(obj)) : (obj) => (obj.__proto__);
/******/ 		var leafPrototypes;
/******/ 		// create a fake namespace object
/******/ 		// mode & 1: value is a module id, require it
/******/ 		// mode & 2: merge all properties of value into the ns
/******/ 		// mode & 4: return value when already ns object
/******/ 		// mode & 16: return value when it's Promise-like
/******/ 		// mode & 8|1: behave like require
/******/ 		__webpack_require__.t = function(value, mode) {
/******/ 			if(mode & 1) value = this(value);
/******/ 			if(mode & 8) return value;
/******/ 			if(typeof value === 'object' && value) {
/******/ 				if((mode & 4) && value.__esModule) return value;
/******/ 				if((mode & 16) && typeof value.then === 'function') return value;
/******/ 			}
/******/ 			var ns = Object.create(null);
/******/ 			__webpack_require__.r(ns);
/******/ 			var def = {};
/******/ 			leafPrototypes = leafPrototypes || [null, getProto({}), getProto([]), getProto(getProto)];
/******/ 			for(var current = mode & 2 && value; (typeof current == 'object' || typeof current == 'function') && !~leafPrototypes.indexOf(current); current = getProto(current)) {
/******/ 				Object.getOwnPropertyNames(current).forEach((key) => (def[key] = () => (value[key])));
/******/ 			}
/******/ 			def['default'] = () => (value);
/******/ 			__webpack_require__.d(ns, def);
/******/ 			return ns;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!***********************************!*\
  !*** ./WebContent/js/settings.js ***!
  \***********************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _smapServer_WebContent_js_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/bootbox.min */ "../smapServer/WebContent/js/libs/bootbox.min.js");
/* harmony import */ var _smapServer_WebContent_js_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/app/localise */ "../smapServer/WebContent/js/app/localise.js");
/* harmony import */ var _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/app/globals */ "../smapServer/WebContent/js/app/globals.js");
/* harmony import */ var _smapServer_WebContent_js_libs_wb_plugins_slimscroll_jquery_slimscroll__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/wb/plugins/slimscroll/jquery.slimscroll */ "../smapServer/WebContent/js/libs/wb/plugins/slimscroll/jquery.slimscroll.js");
/* harmony import */ var _smapServer_WebContent_js_libs_wb_plugins_slimscroll_jquery_slimscroll__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_wb_plugins_slimscroll_jquery_slimscroll__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _smapServer_WebContent_js_libs_bootstrap_colorpicker_min__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/bootstrap-colorpicker.min */ "../smapServer/WebContent/js/libs/bootstrap-colorpicker.min.js");
/* harmony import */ var _smapServer_WebContent_js_libs_bootstrap_colorpicker_min__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_bootstrap_colorpicker_min__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _smapServer_WebContent_js_libs_bootstrap_datetimepicker_4_17_47__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../smapServer/WebContent/js/libs/bootstrap-datetimepicker-4.17.47 */ "../smapServer/WebContent/js/libs/bootstrap-datetimepicker-4.17.47.js");
/* harmony import */ var _smapServer_WebContent_js_libs_bootstrap_datetimepicker_4_17_47__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_smapServer_WebContent_js_libs_bootstrap_datetimepicker_4_17_47__WEBPACK_IMPORTED_MODULE_5__);
/*
This file is part of SMAP.

SMAP is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SMAP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SMAP.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * Purpose: Manage the panels that display graphs, maps etc of results data
 */










const moment = window.moment;

var gUserLocale = navigator.language;
if (typeof localStorage !== "undefined") {
	try {
		gUserLocale = localStorage.getItem('user_locale') || navigator.language;
	} catch (error) {
		gUserLocale = navigator.language;
	}
}
window.gUserLocale = gUserLocale;
window.bootbox = (_smapServer_WebContent_js_libs_bootbox_min__WEBPACK_IMPORTED_MODULE_0___default());

_smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"].initLocale(gUserLocale).then(function () {
	window.moment = window.moment || moment;
	window.localise = _smapServer_WebContent_js_app_localise__WEBPACK_IMPORTED_MODULE_1__["default"];
	window.globals = _smapServer_WebContent_js_app_globals__WEBPACK_IMPORTED_MODULE_2__["default"];

	Promise.resolve(/*! import() eager */).then(__webpack_require__.t.bind(__webpack_require__, /*! ./settings_main */ "./WebContent/js/settings_main.js", 23));
});

})();

/******/ })()
;